# This file was automatically generated by SWIG (http://www.swig.org).
# Version 4.0.2
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

# This wrapper is part of IMP,
# Copyright 2007-2021 IMP Inventors. All rights reserved.

from __future__ import print_function, division, absolute_import
from sys import version_info as _swig_python_version_info
if _swig_python_version_info < (2, 7, 0):
    raise RuntimeError("Python 2.7 or later required")

import _IMP_em

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "thisown":
            self.this.own(value)
        elif name == "this":
            set(self, name, value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


import weakref

class IMP_EM_SwigPyIterator(object):
    r"""Proxy of C++ swig::IMP_EM_SwigPyIterator class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _IMP_em.delete_IMP_EM_SwigPyIterator

    def value(self):
        r"""value(IMP_EM_SwigPyIterator self) -> PyObject *"""
        return _IMP_em.IMP_EM_SwigPyIterator_value(self)

    def incr(self, n=1):
        r"""incr(IMP_EM_SwigPyIterator self, size_t n=1) -> IMP_EM_SwigPyIterator"""
        return _IMP_em.IMP_EM_SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        r"""decr(IMP_EM_SwigPyIterator self, size_t n=1) -> IMP_EM_SwigPyIterator"""
        return _IMP_em.IMP_EM_SwigPyIterator_decr(self, n)

    def distance(self, x):
        r"""distance(IMP_EM_SwigPyIterator self, IMP_EM_SwigPyIterator x) -> ptrdiff_t"""
        return _IMP_em.IMP_EM_SwigPyIterator_distance(self, x)

    def equal(self, x):
        r"""equal(IMP_EM_SwigPyIterator self, IMP_EM_SwigPyIterator x) -> bool"""
        return _IMP_em.IMP_EM_SwigPyIterator_equal(self, x)

    def copy(self):
        r"""copy(IMP_EM_SwigPyIterator self) -> IMP_EM_SwigPyIterator"""
        return _IMP_em.IMP_EM_SwigPyIterator_copy(self)

    def next(self):
        r"""next(IMP_EM_SwigPyIterator self) -> PyObject *"""
        return _IMP_em.IMP_EM_SwigPyIterator_next(self)

    def __next__(self):
        r"""__next__(IMP_EM_SwigPyIterator self) -> PyObject *"""
        return _IMP_em.IMP_EM_SwigPyIterator___next__(self)

    def previous(self):
        r"""previous(IMP_EM_SwigPyIterator self) -> PyObject *"""
        return _IMP_em.IMP_EM_SwigPyIterator_previous(self)

    def advance(self, n):
        r"""advance(IMP_EM_SwigPyIterator self, ptrdiff_t n) -> IMP_EM_SwigPyIterator"""
        return _IMP_em.IMP_EM_SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        r"""__eq__(IMP_EM_SwigPyIterator self, IMP_EM_SwigPyIterator x) -> bool"""
        return _IMP_em.IMP_EM_SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        r"""__ne__(IMP_EM_SwigPyIterator self, IMP_EM_SwigPyIterator x) -> bool"""
        return _IMP_em.IMP_EM_SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        r"""__iadd__(IMP_EM_SwigPyIterator self, ptrdiff_t n) -> IMP_EM_SwigPyIterator"""
        return _IMP_em.IMP_EM_SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        r"""__isub__(IMP_EM_SwigPyIterator self, ptrdiff_t n) -> IMP_EM_SwigPyIterator"""
        return _IMP_em.IMP_EM_SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        r"""__add__(IMP_EM_SwigPyIterator self, ptrdiff_t n) -> IMP_EM_SwigPyIterator"""
        return _IMP_em.IMP_EM_SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        r"""
        __sub__(IMP_EM_SwigPyIterator self, ptrdiff_t n) -> IMP_EM_SwigPyIterator
        __sub__(IMP_EM_SwigPyIterator self, IMP_EM_SwigPyIterator x) -> ptrdiff_t
        """
        return _IMP_em.IMP_EM_SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register IMP_EM_SwigPyIterator in _IMP_em:
_IMP_em.IMP_EM_SwigPyIterator_swigregister(IMP_EM_SwigPyIterator)


_value_types=[]
_object_types=[]
_raii_types=[]
_plural_types=[]

IMP_DEBUG = _IMP_em.IMP_DEBUG

IMP_RELEASE = _IMP_em.IMP_RELEASE

IMP_SILENT = _IMP_em.IMP_SILENT

IMP_PROGRESS = _IMP_em.IMP_PROGRESS

IMP_TERSE = _IMP_em.IMP_TERSE

IMP_VERBOSE = _IMP_em.IMP_VERBOSE

IMP_MEMORY = _IMP_em.IMP_MEMORY

IMP_NONE = _IMP_em.IMP_NONE

IMP_USAGE = _IMP_em.IMP_USAGE

IMP_INTERNAL = _IMP_em.IMP_INTERNAL

IMP_KERNEL_HAS_LOG4CXX = _IMP_em.IMP_KERNEL_HAS_LOG4CXX

IMP_COMPILER_HAS_AUTO = _IMP_em.IMP_COMPILER_HAS_AUTO

IMP_COMPILER_HAS_DEBUG_VECTOR = _IMP_em.IMP_COMPILER_HAS_DEBUG_VECTOR

IMP_COMPILER_HAS_UNIQUE_PTR = _IMP_em.IMP_COMPILER_HAS_UNIQUE_PTR

IMP_KERNEL_HAS_BOOST_RANDOM = _IMP_em.IMP_KERNEL_HAS_BOOST_RANDOM

IMP_KERNEL_HAS_NUMPY = _IMP_em.IMP_KERNEL_HAS_NUMPY

IMP_KERNEL_HAS_GPERFTOOLS = _IMP_em.IMP_KERNEL_HAS_GPERFTOOLS

IMP_KERNEL_HAS_TCMALLOC_HEAPCHECKER = _IMP_em.IMP_KERNEL_HAS_TCMALLOC_HEAPCHECKER

IMP_KERNEL_HAS_TCMALLOC_HEAPPROFILER = _IMP_em.IMP_KERNEL_HAS_TCMALLOC_HEAPPROFILER

IMPKERNEL_SHOW_WARNINGS = _IMP_em.IMPKERNEL_SHOW_WARNINGS


import sys
class _DirectorObjects(object):
    """@internal Simple class to keep references to director objects
       to prevent premature deletion."""
    def __init__(self):
        self._objects = []
    def register(self, obj):
        """Take a reference to a director object; will only work for
           refcounted C++ classes"""
        if hasattr(obj, 'get_ref_count'):
            self._objects.append(obj)
    def cleanup(self):
        """Only drop our reference and allow cleanup by Python if no other
           Python references exist (we hold 3 references: one in self._objects,
           one in x, and one in the argument list for getrefcount) *and* no
           other C++ references exist (the Python object always holds one)"""
        objs = [x for x in self._objects if sys.getrefcount(x) > 3 \
                                         or x.get_ref_count() > 1]
# Do in two steps so the references are kept until the end of the
# function (deleting references may trigger a fresh call to this method)
        self._objects = objs
    def get_object_count(self):
        """Get number of director objects (useful for testing only)"""
        return len(self._objects)
_director_objects = _DirectorObjects()

class _ostream(object):
    r"""Proxy of C++ std::ostream class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def write(self, osa_buf):
        r"""write(_ostream self, char const * osa_buf)"""
        return _IMP_em._ostream_write(self, osa_buf)

# Register _ostream in _IMP_em:
_IMP_em._ostream_swigregister(_ostream)

IMP_COMPILER_HAS_OVERRIDE = _IMP_em.IMP_COMPILER_HAS_OVERRIDE

IMP_COMPILER_HAS_FINAL = _IMP_em.IMP_COMPILER_HAS_FINAL

IMP_HAS_NOEXCEPT = _IMP_em.IMP_HAS_NOEXCEPT

IMP_C_OPEN_BINARY = _IMP_em.IMP_C_OPEN_BINARY

import IMP
IMP_CGAL_HAS_BOOST_FILESYSTEM = _IMP_em.IMP_CGAL_HAS_BOOST_FILESYSTEM

IMP_CGAL_HAS_BOOST_PROGRAMOPTIONS = _IMP_em.IMP_CGAL_HAS_BOOST_PROGRAMOPTIONS

IMP_CGAL_HAS_BOOST_RANDOM = _IMP_em.IMP_CGAL_HAS_BOOST_RANDOM

IMP_CGAL_HAS_BOOST_SYSTEM = _IMP_em.IMP_CGAL_HAS_BOOST_SYSTEM

IMP_CGAL_HAS_NUMPY = _IMP_em.IMP_CGAL_HAS_NUMPY

IMPCGAL_SHOW_WARNINGS = _IMP_em.IMPCGAL_SHOW_WARNINGS

import IMP.cgal
IMP_ALGEBRA_HAS_IMP_CGAL = _IMP_em.IMP_ALGEBRA_HAS_IMP_CGAL

IMP_ALGEBRA_HAS_BOOST_FILESYSTEM = _IMP_em.IMP_ALGEBRA_HAS_BOOST_FILESYSTEM

IMP_ALGEBRA_HAS_BOOST_PROGRAMOPTIONS = _IMP_em.IMP_ALGEBRA_HAS_BOOST_PROGRAMOPTIONS

IMP_ALGEBRA_HAS_BOOST_RANDOM = _IMP_em.IMP_ALGEBRA_HAS_BOOST_RANDOM

IMP_ALGEBRA_HAS_BOOST_SYSTEM = _IMP_em.IMP_ALGEBRA_HAS_BOOST_SYSTEM

IMP_ALGEBRA_HAS_CGAL = _IMP_em.IMP_ALGEBRA_HAS_CGAL

IMP_ALGEBRA_HAS_NUMPY = _IMP_em.IMP_ALGEBRA_HAS_NUMPY

IMP_ALGEBRA_HAS_ANN = _IMP_em.IMP_ALGEBRA_HAS_ANN

IMPALGEBRA_SHOW_WARNINGS = _IMP_em.IMPALGEBRA_SHOW_WARNINGS

import IMP.algebra
IMP_DISPLAY_HAS_IMP_CGAL = _IMP_em.IMP_DISPLAY_HAS_IMP_CGAL

IMP_DISPLAY_HAS_BOOST_FILESYSTEM = _IMP_em.IMP_DISPLAY_HAS_BOOST_FILESYSTEM

IMP_DISPLAY_HAS_BOOST_PROGRAMOPTIONS = _IMP_em.IMP_DISPLAY_HAS_BOOST_PROGRAMOPTIONS

IMP_DISPLAY_HAS_BOOST_RANDOM = _IMP_em.IMP_DISPLAY_HAS_BOOST_RANDOM

IMP_DISPLAY_HAS_BOOST_SYSTEM = _IMP_em.IMP_DISPLAY_HAS_BOOST_SYSTEM

IMP_DISPLAY_HAS_CGAL = _IMP_em.IMP_DISPLAY_HAS_CGAL

IMP_DISPLAY_HAS_NUMPY = _IMP_em.IMP_DISPLAY_HAS_NUMPY

IMPDISPLAY_SHOW_WARNINGS = _IMP_em.IMPDISPLAY_SHOW_WARNINGS

import IMP.display
IMP_SCORE_FUNCTOR_HAS_IMP_CGAL = _IMP_em.IMP_SCORE_FUNCTOR_HAS_IMP_CGAL

IMP_SCORE_FUNCTOR_HAS_BOOST_FILESYSTEM = _IMP_em.IMP_SCORE_FUNCTOR_HAS_BOOST_FILESYSTEM

IMP_SCORE_FUNCTOR_HAS_BOOST_PROGRAMOPTIONS = _IMP_em.IMP_SCORE_FUNCTOR_HAS_BOOST_PROGRAMOPTIONS

IMP_SCORE_FUNCTOR_HAS_BOOST_RANDOM = _IMP_em.IMP_SCORE_FUNCTOR_HAS_BOOST_RANDOM

IMP_SCORE_FUNCTOR_HAS_BOOST_SYSTEM = _IMP_em.IMP_SCORE_FUNCTOR_HAS_BOOST_SYSTEM

IMP_SCORE_FUNCTOR_HAS_CGAL = _IMP_em.IMP_SCORE_FUNCTOR_HAS_CGAL

IMP_SCORE_FUNCTOR_HAS_HDF5 = _IMP_em.IMP_SCORE_FUNCTOR_HAS_HDF5

IMP_SCORE_FUNCTOR_HAS_NUMPY = _IMP_em.IMP_SCORE_FUNCTOR_HAS_NUMPY

IMPSCOREFUNCTOR_SHOW_WARNINGS = _IMP_em.IMPSCOREFUNCTOR_SHOW_WARNINGS

import IMP.score_functor
IMP_STATISTICS_HAS_IMP_CGAL = _IMP_em.IMP_STATISTICS_HAS_IMP_CGAL

IMP_STATISTICS_HAS_BOOST_FILESYSTEM = _IMP_em.IMP_STATISTICS_HAS_BOOST_FILESYSTEM

IMP_STATISTICS_HAS_BOOST_PROGRAMOPTIONS = _IMP_em.IMP_STATISTICS_HAS_BOOST_PROGRAMOPTIONS

IMP_STATISTICS_HAS_BOOST_RANDOM = _IMP_em.IMP_STATISTICS_HAS_BOOST_RANDOM

IMP_STATISTICS_HAS_BOOST_SYSTEM = _IMP_em.IMP_STATISTICS_HAS_BOOST_SYSTEM

IMP_STATISTICS_HAS_CGAL = _IMP_em.IMP_STATISTICS_HAS_CGAL

IMP_STATISTICS_HAS_NUMPY = _IMP_em.IMP_STATISTICS_HAS_NUMPY

IMPSTATISTICS_SHOW_WARNINGS = _IMP_em.IMPSTATISTICS_SHOW_WARNINGS

import IMP.statistics
IMP_CORE_HAS_IMP_CGAL = _IMP_em.IMP_CORE_HAS_IMP_CGAL

IMP_CORE_HAS_IMP_KERNEL = _IMP_em.IMP_CORE_HAS_IMP_KERNEL

IMP_CORE_HAS_BOOST_FILESYSTEM = _IMP_em.IMP_CORE_HAS_BOOST_FILESYSTEM

IMP_CORE_HAS_BOOST_PROGRAMOPTIONS = _IMP_em.IMP_CORE_HAS_BOOST_PROGRAMOPTIONS

IMP_CORE_HAS_BOOST_RANDOM = _IMP_em.IMP_CORE_HAS_BOOST_RANDOM

IMP_CORE_HAS_BOOST_SYSTEM = _IMP_em.IMP_CORE_HAS_BOOST_SYSTEM

IMP_CORE_HAS_CGAL = _IMP_em.IMP_CORE_HAS_CGAL

IMP_CORE_HAS_HDF5 = _IMP_em.IMP_CORE_HAS_HDF5

IMP_CORE_HAS_NUMPY = _IMP_em.IMP_CORE_HAS_NUMPY

IMPCORE_SHOW_WARNINGS = _IMP_em.IMPCORE_SHOW_WARNINGS

import IMP.core
IMP_CONTAINER_HAS_IMP_ALGEBRA = _IMP_em.IMP_CONTAINER_HAS_IMP_ALGEBRA

IMP_CONTAINER_HAS_IMP_CGAL = _IMP_em.IMP_CONTAINER_HAS_IMP_CGAL

IMP_CONTAINER_HAS_IMP_DISPLAY = _IMP_em.IMP_CONTAINER_HAS_IMP_DISPLAY

IMP_CONTAINER_HAS_IMP_KERNEL = _IMP_em.IMP_CONTAINER_HAS_IMP_KERNEL

IMP_CONTAINER_HAS_IMP_SCORE_FUNCTOR = _IMP_em.IMP_CONTAINER_HAS_IMP_SCORE_FUNCTOR

IMP_CONTAINER_HAS_BOOST_FILESYSTEM = _IMP_em.IMP_CONTAINER_HAS_BOOST_FILESYSTEM

IMP_CONTAINER_HAS_BOOST_PROGRAMOPTIONS = _IMP_em.IMP_CONTAINER_HAS_BOOST_PROGRAMOPTIONS

IMP_CONTAINER_HAS_BOOST_RANDOM = _IMP_em.IMP_CONTAINER_HAS_BOOST_RANDOM

IMP_CONTAINER_HAS_BOOST_SYSTEM = _IMP_em.IMP_CONTAINER_HAS_BOOST_SYSTEM

IMP_CONTAINER_HAS_CGAL = _IMP_em.IMP_CONTAINER_HAS_CGAL

IMP_CONTAINER_HAS_HDF5 = _IMP_em.IMP_CONTAINER_HAS_HDF5

IMP_CONTAINER_HAS_NUMPY = _IMP_em.IMP_CONTAINER_HAS_NUMPY

IMP_CONTAINER_HAS_PYTHON_IHM = _IMP_em.IMP_CONTAINER_HAS_PYTHON_IHM

IMP_CONTAINER_HAS_GOOGLE_DENSE_HASH_MAP = _IMP_em.IMP_CONTAINER_HAS_GOOGLE_DENSE_HASH_MAP

IMP_CONTAINER_HAS_ROBIN_MAP = _IMP_em.IMP_CONTAINER_HAS_ROBIN_MAP

IMPCONTAINER_SHOW_WARNINGS = _IMP_em.IMPCONTAINER_SHOW_WARNINGS

import IMP.container
IMP_ATOM_HAS_IMP_CGAL = _IMP_em.IMP_ATOM_HAS_IMP_CGAL

IMP_ATOM_HAS_IMP_KERNEL = _IMP_em.IMP_ATOM_HAS_IMP_KERNEL

IMP_ATOM_HAS_IMP_SCORE_FUNCTOR = _IMP_em.IMP_ATOM_HAS_IMP_SCORE_FUNCTOR

IMP_ATOM_HAS_BOOST_PROGRAMOPTIONS = _IMP_em.IMP_ATOM_HAS_BOOST_PROGRAMOPTIONS

IMP_ATOM_HAS_BOOST_RANDOM = _IMP_em.IMP_ATOM_HAS_BOOST_RANDOM

IMP_ATOM_HAS_BOOST_REGEX = _IMP_em.IMP_ATOM_HAS_BOOST_REGEX

IMP_ATOM_HAS_BOOST_SYSTEM = _IMP_em.IMP_ATOM_HAS_BOOST_SYSTEM

IMP_ATOM_HAS_CGAL = _IMP_em.IMP_ATOM_HAS_CGAL

IMP_ATOM_HAS_HDF5 = _IMP_em.IMP_ATOM_HAS_HDF5

IMP_ATOM_HAS_NUMPY = _IMP_em.IMP_ATOM_HAS_NUMPY

IMP_ATOM_HAS_PYTHON_IHM = _IMP_em.IMP_ATOM_HAS_PYTHON_IHM

IMPATOM_SHOW_WARNINGS = _IMP_em.IMPATOM_SHOW_WARNINGS

IMP_ATOM_TYPE_INDEX = _IMP_em.IMP_ATOM_TYPE_INDEX

IMP_RESIDUE_TYPE_INDEX = _IMP_em.IMP_RESIDUE_TYPE_INDEX

IMP_HIERARCHY_TYPE_INDEX = _IMP_em.IMP_HIERARCHY_TYPE_INDEX

IMP_CHAIN_TYPE_INDEX = _IMP_em.IMP_CHAIN_TYPE_INDEX

import IMP.atom
IMP_EM_HAS_IMP_CGAL = _IMP_em.IMP_EM_HAS_IMP_CGAL

IMP_EM_HAS_IMP_CONTAINER = _IMP_em.IMP_EM_HAS_IMP_CONTAINER

IMP_EM_HAS_IMP_DISPLAY = _IMP_em.IMP_EM_HAS_IMP_DISPLAY

IMP_EM_HAS_IMP_SCORE_FUNCTOR = _IMP_em.IMP_EM_HAS_IMP_SCORE_FUNCTOR

IMP_EM_HAS_BOOST_FILESYSTEM = _IMP_em.IMP_EM_HAS_BOOST_FILESYSTEM

IMP_EM_HAS_BOOST_PROGRAMOPTIONS = _IMP_em.IMP_EM_HAS_BOOST_PROGRAMOPTIONS

IMP_EM_HAS_BOOST_RANDOM = _IMP_em.IMP_EM_HAS_BOOST_RANDOM

IMP_EM_HAS_BOOST_REGEX = _IMP_em.IMP_EM_HAS_BOOST_REGEX

IMP_EM_HAS_BOOST_SYSTEM = _IMP_em.IMP_EM_HAS_BOOST_SYSTEM

IMP_EM_HAS_CGAL = _IMP_em.IMP_EM_HAS_CGAL

IMP_EM_HAS_HDF5 = _IMP_em.IMP_EM_HAS_HDF5

IMP_EM_HAS_NUMPY = _IMP_em.IMP_EM_HAS_NUMPY

IMP_EM_HAS_PYTHON_IHM = _IMP_em.IMP_EM_HAS_PYTHON_IHM

IMPEM_SHOW_WARNINGS = _IMP_em.IMPEM_SHOW_WARNINGS


_object_types.append("DensityMap")


def _object_cast_to_DensityMap(o):
    r"""_object_cast_to_DensityMap(Object o) -> DensityMap"""
    return _IMP_em._object_cast_to_DensityMap(o)

_object_types.append("SampledDensityMap")


def _object_cast_to_SampledDensityMap(o):
    r"""_object_cast_to_SampledDensityMap(Object o) -> SampledDensityMap"""
    return _IMP_em._object_cast_to_SampledDensityMap(o)

_object_types.append("SurfaceShellDensityMap")


def _object_cast_to_SurfaceShellDensityMap(o):
    r"""_object_cast_to_SurfaceShellDensityMap(Object o) -> SurfaceShellDensityMap"""
    return _IMP_em._object_cast_to_SurfaceShellDensityMap(o)

_object_types.append("FitRestraint")


def _object_cast_to_FitRestraint(o):
    r"""_object_cast_to_FitRestraint(Object o) -> FitRestraint"""
    return _IMP_em._object_cast_to_FitRestraint(o)

_object_types.append("FitRestraintBayesEM3D")


def _object_cast_to_FitRestraintBayesEM3D(o):
    r"""_object_cast_to_FitRestraintBayesEM3D(Object o) -> FitRestraintBayesEM3D"""
    return _IMP_em._object_cast_to_FitRestraintBayesEM3D(o)

_object_types.append("PCAFitRestraint")


def _object_cast_to_PCAFitRestraint(o):
    r"""_object_cast_to_PCAFitRestraint(Object o) -> PCAFitRestraint"""
    return _IMP_em._object_cast_to_PCAFitRestraint(o)

_object_types.append("EnvelopePenetrationRestraint")


def _object_cast_to_EnvelopePenetrationRestraint(o):
    r"""_object_cast_to_EnvelopePenetrationRestraint(Object o) -> EnvelopePenetrationRestraint"""
    return _IMP_em._object_cast_to_EnvelopePenetrationRestraint(o)

_object_types.append("EnvelopeFitRestraint")


def _object_cast_to_EnvelopeFitRestraint(o):
    r"""_object_cast_to_EnvelopeFitRestraint(Object o) -> EnvelopeFitRestraint"""
    return _IMP_em._object_cast_to_EnvelopeFitRestraint(o)

KernelParametersList=list
_plural_types.append("KernelParametersList")
_value_types.append("KernelParameters")


_object_types.append("HighDensityEmbedding")


def _object_cast_to_HighDensityEmbedding(o):
    r"""_object_cast_to_HighDensityEmbedding(Object o) -> HighDensityEmbedding"""
    return _IMP_em._object_cast_to_HighDensityEmbedding(o)

_object_types.append("MapReaderWriter")


def _object_cast_to_MapReaderWriter(o):
    r"""_object_cast_to_MapReaderWriter(Object o) -> MapReaderWriter"""
    return _IMP_em._object_cast_to_MapReaderWriter(o)

_object_types.append("MRCReaderWriter")


def _object_cast_to_MRCReaderWriter(o):
    r"""_object_cast_to_MRCReaderWriter(Object o) -> MRCReaderWriter"""
    return _IMP_em._object_cast_to_MRCReaderWriter(o)

_object_types.append("SpiderMapReaderWriter")


def _object_cast_to_SpiderMapReaderWriter(o):
    r"""_object_cast_to_SpiderMapReaderWriter(Object o) -> SpiderMapReaderWriter"""
    return _IMP_em._object_cast_to_SpiderMapReaderWriter(o)

_object_types.append("EMReaderWriter")


def _object_cast_to_EMReaderWriter(o):
    r"""_object_cast_to_EMReaderWriter(Object o) -> EMReaderWriter"""
    return _IMP_em._object_cast_to_EMReaderWriter(o)

_object_types.append("XplorReaderWriter")


def _object_cast_to_XplorReaderWriter(o):
    r"""_object_cast_to_XplorReaderWriter(Object o) -> XplorReaderWriter"""
    return _IMP_em._object_cast_to_XplorReaderWriter(o)

_object_types.append("CoarseCC")


def _object_cast_to_CoarseCC(o):
    r"""_object_cast_to_CoarseCC(Object o) -> CoarseCC"""
    return _IMP_em._object_cast_to_CoarseCC(o)

_object_types.append("CoarseCCatIntervals")


def _object_cast_to_CoarseCCatIntervals(o):
    r"""_object_cast_to_CoarseCCatIntervals(Object o) -> CoarseCCatIntervals"""
    return _IMP_em._object_cast_to_CoarseCCatIntervals(o)

FittingSolutionsList=list
_plural_types.append("FittingSolutionsList")
_value_types.append("FittingSolutions")


_object_types.append("MapDistanceTransform")


def _object_cast_to_MapDistanceTransform(o):
    r"""_object_cast_to_MapDistanceTransform(Object o) -> MapDistanceTransform"""
    return _IMP_em._object_cast_to_MapDistanceTransform(o)

_object_types.append("EnvelopeScore")


def _object_cast_to_EnvelopeScore(o):
    r"""_object_cast_to_EnvelopeScore(Object o) -> EnvelopeScore"""
    return _IMP_em._object_cast_to_EnvelopeScore(o)

def _get_density_map_x_loc(m, pyobj):
    r"""_get_density_map_x_loc(DensityMap m, PyObject * pyobj) -> PyObject *"""
    return _IMP_em._get_density_map_x_loc(m, pyobj)

def _get_density_map_y_loc(m, pyobj):
    r"""_get_density_map_y_loc(DensityMap m, PyObject * pyobj) -> PyObject *"""
    return _IMP_em._get_density_map_y_loc(m, pyobj)

def _get_density_map_z_loc(m, pyobj):
    r"""_get_density_map_z_loc(DensityMap m, PyObject * pyobj) -> PyObject *"""
    return _IMP_em._get_density_map_z_loc(m, pyobj)

def _get_density_map_data(m, pyobj):
    r"""_get_density_map_data(DensityMap m, PyObject * pyobj) -> PyObject *"""
    return _IMP_em._get_density_map_data(m, pyobj)
class MapReaderWriter(IMP.Object):
    r"""Proxy of C++ IMP::em::MapReaderWriter class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self):
        r"""__init__(MapReaderWriter self) -> MapReaderWriter"""
        _IMP_em.MapReaderWriter_swiginit(self, _IMP_em.new_MapReaderWriter())

    def get_version_info(self):
        r"""get_version_info(MapReaderWriter self) -> VersionInfo"""
        return _IMP_em.MapReaderWriter_get_version_info(self)

    def __str__(self):
        r"""__str__(MapReaderWriter self) -> std::string"""
        return _IMP_em.MapReaderWriter___str__(self)

    def __repr__(self):
        r"""__repr__(MapReaderWriter self) -> std::string"""
        return _IMP_em.MapReaderWriter___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_MapReaderWriter(o)


# Register MapReaderWriter in _IMP_em:
_IMP_em.MapReaderWriter_swigregister(MapReaderWriter)
cvar = _IMP_em.cvar
EPS = cvar.EPS

class DensityHeader(object):
    r"""Proxy of C++ IMP::em::DensityHeader class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""__init__(DensityHeader self) -> DensityHeader"""
        _IMP_em.DensityHeader_swiginit(self, _IMP_em.new_DensityHeader())

    def get_top(self, ind):
        r"""get_top(DensityHeader self, int ind) -> IMP::em::emreal"""
        return _IMP_em.DensityHeader_get_top(self, ind)

    def compute_xyz_top(self, force=False):
        r"""compute_xyz_top(DensityHeader self, bool force=False)"""
        return _IMP_em.DensityHeader_compute_xyz_top(self, force)

    def update_map_dimensions(self, nnx, nny, nnz):
        r"""update_map_dimensions(DensityHeader self, int nnx, int nny, int nnz)"""
        return _IMP_em.DensityHeader_update_map_dimensions(self, nnx, nny, nnz)

    def update_cell_dimensions(self):
        r"""update_cell_dimensions(DensityHeader self)"""
        return _IMP_em.DensityHeader_update_cell_dimensions(self)

    def show(self, *args):
        r"""show(DensityHeader self, _ostream out=std::cout)"""
        return _IMP_em.DensityHeader_show(self, *args)
    MAP_FIELD_SIZE = _IMP_em.DensityHeader_MAP_FIELD_SIZE
    
    USER_FIELD_SIZE = _IMP_em.DensityHeader_USER_FIELD_SIZE
    
    COMMENT_FIELD_NUM_OF = _IMP_em.DensityHeader_COMMENT_FIELD_NUM_OF
    
    COMMENT_FIELD_SINGLE_SIZE = _IMP_em.DensityHeader_COMMENT_FIELD_SINGLE_SIZE
    
    nxstart = property(_IMP_em.DensityHeader_nxstart_get, _IMP_em.DensityHeader_nxstart_set, doc=r"""nxstart : int""")
    nystart = property(_IMP_em.DensityHeader_nystart_get, _IMP_em.DensityHeader_nystart_set, doc=r"""nystart : int""")
    nzstart = property(_IMP_em.DensityHeader_nzstart_get, _IMP_em.DensityHeader_nzstart_set, doc=r"""nzstart : int""")
    mx = property(_IMP_em.DensityHeader_mx_get, _IMP_em.DensityHeader_mx_set, doc=r"""mx : int""")
    my = property(_IMP_em.DensityHeader_my_get, _IMP_em.DensityHeader_my_set, doc=r"""my : int""")
    mz = property(_IMP_em.DensityHeader_mz_get, _IMP_em.DensityHeader_mz_set, doc=r"""mz : int""")
    xlen = property(_IMP_em.DensityHeader_xlen_get, _IMP_em.DensityHeader_xlen_set, doc=r"""xlen : float""")
    ylen = property(_IMP_em.DensityHeader_ylen_get, _IMP_em.DensityHeader_ylen_set, doc=r"""ylen : float""")
    zlen = property(_IMP_em.DensityHeader_zlen_get, _IMP_em.DensityHeader_zlen_set, doc=r"""zlen : float""")
    alpha = property(_IMP_em.DensityHeader_alpha_get, _IMP_em.DensityHeader_alpha_set, doc=r"""alpha : float""")
    beta = property(_IMP_em.DensityHeader_beta_get, _IMP_em.DensityHeader_beta_set, doc=r"""beta : float""")
    gamma = property(_IMP_em.DensityHeader_gamma_get, _IMP_em.DensityHeader_gamma_set, doc=r"""gamma : float""")
    mapc = property(_IMP_em.DensityHeader_mapc_get, _IMP_em.DensityHeader_mapc_set, doc=r"""mapc : int""")
    mapr = property(_IMP_em.DensityHeader_mapr_get, _IMP_em.DensityHeader_mapr_set, doc=r"""mapr : int""")
    maps = property(_IMP_em.DensityHeader_maps_get, _IMP_em.DensityHeader_maps_set, doc=r"""maps : int""")
    dmin = property(_IMP_em.DensityHeader_dmin_get, _IMP_em.DensityHeader_dmin_set, doc=r"""dmin : float""")
    dmax = property(_IMP_em.DensityHeader_dmax_get, _IMP_em.DensityHeader_dmax_set, doc=r"""dmax : float""")
    dmean = property(_IMP_em.DensityHeader_dmean_get, _IMP_em.DensityHeader_dmean_set, doc=r"""dmean : float""")
    ispg = property(_IMP_em.DensityHeader_ispg_get, _IMP_em.DensityHeader_ispg_set, doc=r"""ispg : int""")
    nsymbt = property(_IMP_em.DensityHeader_nsymbt_get, _IMP_em.DensityHeader_nsymbt_set, doc=r"""nsymbt : int""")
    user = property(_IMP_em.DensityHeader_user_get, _IMP_em.DensityHeader_user_set, doc=r"""user : a(IMP::em::DensityHeader::USER_FIELD_SIZE).int""")
    map = property(_IMP_em.DensityHeader_map_get, _IMP_em.DensityHeader_map_set, doc=r"""map : a(IMP::em::DensityHeader::MAP_FIELD_SIZE).char""")
    machinestamp = property(_IMP_em.DensityHeader_machinestamp_get, _IMP_em.DensityHeader_machinestamp_set, doc=r"""machinestamp : int""")
    rms = property(_IMP_em.DensityHeader_rms_get, _IMP_em.DensityHeader_rms_set, doc=r"""rms : float""")
    nlabl = property(_IMP_em.DensityHeader_nlabl_get, _IMP_em.DensityHeader_nlabl_set, doc=r"""nlabl : int""")
    comments = property(_IMP_em.DensityHeader_comments_get, _IMP_em.DensityHeader_comments_set, doc=r"""comments : a(IMP::em::DensityHeader::COMMENT_FIELD_NUM_OF).a(IMP::em::DensityHeader::COMMENT_FIELD_SINGLE_SIZE).char""")
    magic = property(_IMP_em.DensityHeader_magic_get, _IMP_em.DensityHeader_magic_set, doc=r"""magic : int""")
    voltage = property(_IMP_em.DensityHeader_voltage_get, _IMP_em.DensityHeader_voltage_set, doc=r"""voltage : float""")
    Cs = property(_IMP_em.DensityHeader_Cs_get, _IMP_em.DensityHeader_Cs_set, doc=r"""Cs : float""")
    Aperture = property(_IMP_em.DensityHeader_Aperture_get, _IMP_em.DensityHeader_Aperture_set, doc=r"""Aperture : float""")
    Magnification = property(_IMP_em.DensityHeader_Magnification_get, _IMP_em.DensityHeader_Magnification_set, doc=r"""Magnification : float""")
    Postmagnification = property(_IMP_em.DensityHeader_Postmagnification_get, _IMP_em.DensityHeader_Postmagnification_set, doc=r"""Postmagnification : float""")
    Exposuretime = property(_IMP_em.DensityHeader_Exposuretime_get, _IMP_em.DensityHeader_Exposuretime_set, doc=r"""Exposuretime : float""")
    Microscope = property(_IMP_em.DensityHeader_Microscope_get, _IMP_em.DensityHeader_Microscope_set, doc=r"""Microscope : float""")
    Pixelsize = property(_IMP_em.DensityHeader_Pixelsize_get, _IMP_em.DensityHeader_Pixelsize_set, doc=r"""Pixelsize : float""")
    CCDArea = property(_IMP_em.DensityHeader_CCDArea_get, _IMP_em.DensityHeader_CCDArea_set, doc=r"""CCDArea : float""")
    Defocus = property(_IMP_em.DensityHeader_Defocus_get, _IMP_em.DensityHeader_Defocus_set, doc=r"""Defocus : float""")
    Astigmatism = property(_IMP_em.DensityHeader_Astigmatism_get, _IMP_em.DensityHeader_Astigmatism_set, doc=r"""Astigmatism : float""")
    AstigmatismAngle = property(_IMP_em.DensityHeader_AstigmatismAngle_get, _IMP_em.DensityHeader_AstigmatismAngle_set, doc=r"""AstigmatismAngle : float""")
    FocusIncrement = property(_IMP_em.DensityHeader_FocusIncrement_get, _IMP_em.DensityHeader_FocusIncrement_set, doc=r"""FocusIncrement : float""")
    CountsPerElectron = property(_IMP_em.DensityHeader_CountsPerElectron_get, _IMP_em.DensityHeader_CountsPerElectron_set, doc=r"""CountsPerElectron : float""")
    Intensity = property(_IMP_em.DensityHeader_Intensity_get, _IMP_em.DensityHeader_Intensity_set, doc=r"""Intensity : float""")
    EnergySlitwidth = property(_IMP_em.DensityHeader_EnergySlitwidth_get, _IMP_em.DensityHeader_EnergySlitwidth_set, doc=r"""EnergySlitwidth : float""")
    EnergyOffset = property(_IMP_em.DensityHeader_EnergyOffset_get, _IMP_em.DensityHeader_EnergyOffset_set, doc=r"""EnergyOffset : float""")
    Tiltangle = property(_IMP_em.DensityHeader_Tiltangle_get, _IMP_em.DensityHeader_Tiltangle_set, doc=r"""Tiltangle : float""")
    Tiltaxis = property(_IMP_em.DensityHeader_Tiltaxis_get, _IMP_em.DensityHeader_Tiltaxis_set, doc=r"""Tiltaxis : float""")
    MarkerX = property(_IMP_em.DensityHeader_MarkerX_get, _IMP_em.DensityHeader_MarkerX_set, doc=r"""MarkerX : float""")
    MarkerY = property(_IMP_em.DensityHeader_MarkerY_get, _IMP_em.DensityHeader_MarkerY_set, doc=r"""MarkerY : float""")
    lswap = property(_IMP_em.DensityHeader_lswap_get, _IMP_em.DensityHeader_lswap_set, doc=r"""lswap : int""")

    def get_resolution(self):
        r"""get_resolution(DensityHeader self) -> float"""
        return _IMP_em.DensityHeader_get_resolution(self)

    def get_has_resolution(self):
        r"""get_has_resolution(DensityHeader self) -> bool"""
        return _IMP_em.DensityHeader_get_has_resolution(self)

    def set_resolution(self, resolution):
        r"""set_resolution(DensityHeader self, float resolution)"""
        return _IMP_em.DensityHeader_set_resolution(self, resolution)

    def get_spacing(self):
        r"""get_spacing(DensityHeader self) -> float"""
        return _IMP_em.DensityHeader_get_spacing(self)

    def get_xorigin(self):
        r"""get_xorigin(DensityHeader self) -> float"""
        return _IMP_em.DensityHeader_get_xorigin(self)

    def get_yorigin(self):
        r"""get_yorigin(DensityHeader self) -> float"""
        return _IMP_em.DensityHeader_get_yorigin(self)

    def get_zorigin(self):
        r"""get_zorigin(DensityHeader self) -> float"""
        return _IMP_em.DensityHeader_get_zorigin(self)

    def get_origin(self, i):
        r"""get_origin(DensityHeader self, int i) -> float"""
        return _IMP_em.DensityHeader_get_origin(self, i)

    def set_xorigin(self, x):
        r"""set_xorigin(DensityHeader self, float x)"""
        return _IMP_em.DensityHeader_set_xorigin(self, x)

    def set_yorigin(self, y):
        r"""set_yorigin(DensityHeader self, float y)"""
        return _IMP_em.DensityHeader_set_yorigin(self, y)

    def set_zorigin(self, z):
        r"""set_zorigin(DensityHeader self, float z)"""
        return _IMP_em.DensityHeader_set_zorigin(self, z)

    def is_top_calculated(self):
        r"""is_top_calculated(DensityHeader self) -> bool"""
        return _IMP_em.DensityHeader_is_top_calculated(self)
    Objectpixelsize_ = property(_IMP_em.DensityHeader_Objectpixelsize__get, _IMP_em.DensityHeader_Objectpixelsize__set, doc=r"""Objectpixelsize_ : float""")

    def get_nx(self):
        r"""get_nx(DensityHeader self) -> int"""
        return _IMP_em.DensityHeader_get_nx(self)

    def get_ny(self):
        r"""get_ny(DensityHeader self) -> int"""
        return _IMP_em.DensityHeader_get_ny(self)

    def get_nz(self):
        r"""get_nz(DensityHeader self) -> int"""
        return _IMP_em.DensityHeader_get_nz(self)

    def get_number_of_voxels(self):
        r"""get_number_of_voxels(DensityHeader self) -> int"""
        return _IMP_em.DensityHeader_get_number_of_voxels(self)

    def get_data_type(self):
        r"""get_data_type(DensityHeader self) -> int"""
        return _IMP_em.DensityHeader_get_data_type(self)

    def set_data_type(self, data_type):
        r"""set_data_type(DensityHeader self, int data_type)"""
        return _IMP_em.DensityHeader_set_data_type(self, data_type)
    __swig_destroy__ = _IMP_em.delete_DensityHeader

# Register DensityHeader in _IMP_em:
_IMP_em.DensityHeader_swigregister(DensityHeader)


def create_density_header(bb, spacing):
    r"""create_density_header(BoundingBox3D bb, float spacing) -> DensityHeader"""
    return _IMP_em.create_density_header(bb, spacing)

def read_map(*args):
    r"""
    read_map(std::string filename, MapReaderWriter reader) -> DensityMap
    read_map(std::string filename) -> DensityMap
    """
    return _IMP_em.read_map(*args)

def write_map(*args):
    r"""
    write_map(DensityMap m, std::string filename, MapReaderWriter writer)
    write_map(DensityMap m, std::string filename)
    """
    return _IMP_em.write_map(*args)

def approximate_molecular_mass(m, threshold):
    r"""approximate_molecular_mass(DensityMap m, IMP::Float threshold) -> IMP::Float"""
    return _IMP_em.approximate_molecular_mass(m, threshold)
class DensityMap(IMP.Object):
    r"""Proxy of C++ IMP::em::DensityMap class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(DensityMap self, std::string name="DensityMap%1%") -> DensityMap
        __init__(DensityMap self, DensityHeader header, std::string name="DensityMap%1%") -> DensityMap
        """
        _IMP_em.DensityMap_swiginit(self, _IMP_em.new_DensityMap(*args))

    def reset_data(self, value=0.0):
        r"""reset_data(DensityMap self, float value=0.0)"""
        return _IMP_em.DensityMap_reset_data(self, value)

    def calcRMS(self):
        r"""calcRMS(DensityMap self) -> IMP::em::emreal"""
        return _IMP_em.DensityMap_calcRMS(self)

    def std_normalize(self):
        r"""std_normalize(DensityMap self)"""
        return _IMP_em.DensityMap_std_normalize(self)

    def is_normalized(self):
        r"""is_normalized(DensityMap self) -> bool"""
        return _IMP_em.DensityMap_is_normalized(self)

    def get_location_in_dim_by_voxel(self, index, dim):
        r"""get_location_in_dim_by_voxel(DensityMap self, long index, int dim) -> float"""
        return _IMP_em.DensityMap_get_location_in_dim_by_voxel(self, index, dim)

    def xyz_ind2voxel(self, x, y, z):
        r"""xyz_ind2voxel(DensityMap self, int x, int y, int z) -> long"""
        return _IMP_em.DensityMap_xyz_ind2voxel(self, x, y, z)

    def get_voxel_by_location(self, *args):
        r"""
        get_voxel_by_location(DensityMap self, float x, float y, float z) -> long
        get_voxel_by_location(DensityMap self, Vector3D v) -> long
        """
        return _IMP_em.DensityMap_get_voxel_by_location(self, *args)

    def get_location_by_voxel(self, index):
        r"""get_location_by_voxel(DensityMap self, long index) -> Vector3D"""
        return _IMP_em.DensityMap_get_location_by_voxel(self, index)

    def is_xyz_ind_part_of_volume(self, ix, iy, iz):
        r"""is_xyz_ind_part_of_volume(DensityMap self, int ix, int iy, int iz) -> bool"""
        return _IMP_em.DensityMap_is_xyz_ind_part_of_volume(self, ix, iy, iz)

    def is_part_of_volume(self, *args):
        r"""
        is_part_of_volume(DensityMap self, float x, float y, float z) -> bool
        is_part_of_volume(DensityMap self, Vector3D v) -> bool
        """
        return _IMP_em.DensityMap_is_part_of_volume(self, *args)

    def get_value(self, *args):
        r"""
        get_value(DensityMap self, float x, float y, float z) -> IMP::em::emreal
        get_value(DensityMap self, Vector3D point) -> IMP::em::emreal
        get_value(DensityMap self, long index) -> IMP::em::emreal
        """
        return _IMP_em.DensityMap_get_value(self, *args)

    def set_value(self, *args):
        r"""
        set_value(DensityMap self, long index, IMP::em::emreal value)
        set_value(DensityMap self, float x, float y, float z, IMP::em::emreal value)
        """
        return _IMP_em.DensityMap_set_value(self, *args)

    def set_origin(self, *args):
        r"""
        set_origin(DensityMap self, float x, float y, float z)
        set_origin(DensityMap self, Vector3D v)
        """
        return _IMP_em.DensityMap_set_origin(self, *args)

    def get_origin(self):
        r"""get_origin(DensityMap self) -> Vector3D"""
        return _IMP_em.DensityMap_get_origin(self)

    def get_top(self):
        r"""get_top(DensityMap self) -> Vector3D"""
        return _IMP_em.DensityMap_get_top(self)

    def get_header(self):
        h = _IMP_em.DensityMap_get_header(self)
        h._owner = self
        return h



    def get_header_writable(self):
        h = _IMP_em.DensityMap_get_header_writable(self)
        h._owner = self
        return h



    def same_origin(self, other):
        r"""same_origin(DensityMap self, DensityMap other) -> bool"""
        return _IMP_em.DensityMap_same_origin(self, other)

    def same_dimensions(self, other):
        r"""same_dimensions(DensityMap self, DensityMap other) -> bool"""
        return _IMP_em.DensityMap_same_dimensions(self, other)

    def same_voxel_size(self, other):
        r"""same_voxel_size(DensityMap self, DensityMap other) -> bool"""
        return _IMP_em.DensityMap_same_voxel_size(self, other)

    def get_centroid(self, threshold=0.0):
        r"""get_centroid(DensityMap self, IMP::em::emreal threshold=0.0) -> Vector3D"""
        return _IMP_em.DensityMap_get_centroid(self, threshold)

    def get_max_value(self):
        r"""get_max_value(DensityMap self) -> IMP::em::emreal"""
        return _IMP_em.DensityMap_get_max_value(self)

    def get_min_value(self):
        r"""get_min_value(DensityMap self) -> IMP::em::emreal"""
        return _IMP_em.DensityMap_get_min_value(self)

    def add(self, *args):
        r"""
        add(DensityMap self, DensityMap other)
        add(DensityMap self, IMP::Float d)
        """
        return _IMP_em.DensityMap_add(self, *args)

    def pick_max(self, other):
        r"""pick_max(DensityMap self, DensityMap other)"""
        return _IMP_em.DensityMap_pick_max(self, other)

    def get_number_of_voxels(self):
        r"""get_number_of_voxels(DensityMap self) -> long"""
        return _IMP_em.DensityMap_get_number_of_voxels(self)

    def set_void_map(self, nx, ny, nz):
        r"""set_void_map(DensityMap self, int nx, int ny, int nz)"""
        return _IMP_em.DensityMap_set_void_map(self, nx, ny, nz)

    def pad(self, nx, ny, nz, val=0.0):
        r"""pad(DensityMap self, int nx, int ny, int nz, float val=0.0)"""
        return _IMP_em.DensityMap_pad(self, nx, ny, nz, val)

    def pad_margin(self, mrg_x, mrg_y, mrg_z, val=0.0):
        r"""pad_margin(DensityMap self, int mrg_x, int mrg_y, int mrg_z, float val=0.0) -> DensityMap"""
        return _IMP_em.DensityMap_pad_margin(self, mrg_x, mrg_y, mrg_z, val)

    def get_cropped(self, *args):
        r"""
        get_cropped(DensityMap self, float threshold) -> DensityMap
        get_cropped(DensityMap self, IMP::Particles ps, double distance, bool inverse=False, bool keep_map_dimensions=False) -> DensityMap
        get_cropped(DensityMap self, BoundingBox3D bb) -> DensityMap
        """
        return _IMP_em.DensityMap_get_cropped(self, *args)

    def get_maximum_value_in_xy_plane(self, z_ind):
        r"""get_maximum_value_in_xy_plane(DensityMap self, int z_ind) -> float"""
        return _IMP_em.DensityMap_get_maximum_value_in_xy_plane(self, z_ind)

    def get_maximum_value_in_xz_plane(self, y_ind):
        r"""get_maximum_value_in_xz_plane(DensityMap self, int y_ind) -> float"""
        return _IMP_em.DensityMap_get_maximum_value_in_xz_plane(self, y_ind)

    def get_maximum_value_in_yz_plane(self, x_ind):
        r"""get_maximum_value_in_yz_plane(DensityMap self, int x_ind) -> float"""
        return _IMP_em.DensityMap_get_maximum_value_in_yz_plane(self, x_ind)

    def multiply(self, factor):
        r"""multiply(DensityMap self, float factor)"""
        return _IMP_em.DensityMap_multiply(self, factor)

    def get_locations_string(self, t):
        r"""get_locations_string(DensityMap self, float t) -> std::string"""
        return _IMP_em.DensityMap_get_locations_string(self, t)

    def update_voxel_size(self, new_apix):
        r"""update_voxel_size(DensityMap self, float new_apix)"""
        return _IMP_em.DensityMap_update_voxel_size(self, new_apix)

    def get_spacing(self):
        r"""get_spacing(DensityMap self) -> IMP::Float"""
        return _IMP_em.DensityMap_get_spacing(self)

    def calc_all_voxel2loc(self):
        r"""calc_all_voxel2loc(DensityMap self)"""
        return _IMP_em.DensityMap_calc_all_voxel2loc(self)

    def copy_map(self, other):
        r"""copy_map(DensityMap self, DensityMap other)"""
        return _IMP_em.DensityMap_copy_map(self, other)

    def get_version_info(self):
        r"""get_version_info(DensityMap self) -> VersionInfo"""
        return _IMP_em.DensityMap_get_version_info(self)

    def lower_voxel_shift(self, loc, kdist, orig, ndim):
        r"""lower_voxel_shift(DensityMap self, IMP::em::emreal loc, IMP::em::emreal kdist, IMP::em::emreal orig, int ndim) -> int"""
        return _IMP_em.DensityMap_lower_voxel_shift(self, loc, kdist, orig, ndim)

    def upper_voxel_shift(self, loc, kdist, orig, ndim):
        r"""upper_voxel_shift(DensityMap self, IMP::em::emreal loc, IMP::em::emreal kdist, IMP::em::emreal orig, int ndim) -> int"""
        return _IMP_em.DensityMap_upper_voxel_shift(self, loc, kdist, orig, ndim)

    def get_rms_calculated(self):
        r"""get_rms_calculated(DensityMap self) -> bool"""
        return _IMP_em.DensityMap_get_rms_calculated(self)

    def get_dim_index_by_location(self, *args):
        r"""
        get_dim_index_by_location(DensityMap self, Vector3D v, int ind) -> int
        get_dim_index_by_location(DensityMap self, float loc_val, int ind) -> int
        """
        return _IMP_em.DensityMap_get_dim_index_by_location(self, *args)

    def __str__(self):
        r"""__str__(DensityMap self) -> std::string"""
        return _IMP_em.DensityMap___str__(self)

    def __repr__(self):
        r"""__repr__(DensityMap self) -> std::string"""
        return _IMP_em.DensityMap___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_DensityMap(o)


    def get_x_loc(self):
        return _get_density_map_x_loc(self, self)

    def get_y_loc(self):
        return _get_density_map_y_loc(self, self)

    def get_z_loc(self):
        return _get_density_map_z_loc(self, self)

    def get_data(self):
        return _get_density_map_data(self, self)


# Register DensityMap in _IMP_em:
_IMP_em.DensityMap_swigregister(DensityMap)


def get_bounding_box(*args):
    r"""
    get_bounding_box(DensityMap m, IMP::Float threshold) -> BoundingBox3D
    get_bounding_box(DensityMap m) -> BoundingBox3D
    """
    return _IMP_em.get_bounding_box(*args)

def get_density(m, v):
    r"""get_density(DensityMap m, Vector3D v) -> double"""
    return _IMP_em.get_density(m, v)

def get_transformed(*args):
    r"""
    get_transformed(DensityMap input, Transformation3D tr, double threshold) -> DensityMap
    get_transformed(DensityMap input, Transformation3D tr) -> DensityMap
    """
    return _IMP_em.get_transformed(*args)

def get_resampled(input, scaling):
    r"""get_resampled(DensityMap input, double scaling) -> DensityMap"""
    return _IMP_em.get_resampled(input, scaling)

def get_transformed_into(source, tr, into, calc_rms=True):
    r"""get_transformed_into(DensityMap source, Transformation3D tr, DensityMap into, bool calc_rms=True)"""
    return _IMP_em.get_transformed_into(source, tr, into, calc_rms)

def get_transformed_into2(source, tr, into):
    r"""get_transformed_into2(DensityMap source, Transformation3D tr, DensityMap into)"""
    return _IMP_em.get_transformed_into2(source, tr, into)

def get_interiors_intersect(d1, d2):
    r"""get_interiors_intersect(DensityMap d1, DensityMap d2) -> bool"""
    return _IMP_em.get_interiors_intersect(d1, d2)

def get_segment(*args):
    r"""
    get_segment(DensityMap map_to_segment, int nx_start, int nx_end, int ny_start, int ny_end, int nz_start, int nz_end) -> DensityMap
    get_segment(DensityMap map_to_segment, IMP::algebra::Vector3Ds vecs, float dist) -> DensityMap
    """
    return _IMP_em.get_segment(*args)

def get_segment_by_masking(map_to_segment, mask, mas_threshold):
    r"""get_segment_by_masking(DensityMap map_to_segment, DensityMap mask, float mas_threshold) -> DensityMap"""
    return _IMP_em.get_segment_by_masking(map_to_segment, mask, mas_threshold)

def binarize(orig_map, threshold, reverse=False):
    r"""binarize(DensityMap orig_map, float threshold, bool reverse=False) -> DensityMap"""
    return _IMP_em.binarize(orig_map, threshold, reverse)

def get_threshold_map(orig_map, threshold):
    r"""get_threshold_map(DensityMap orig_map, float threshold) -> DensityMap"""
    return _IMP_em.get_threshold_map(orig_map, threshold)

def multiply(m1, m2):
    r"""multiply(DensityMap m1, DensityMap m2) -> DensityMap"""
    return _IMP_em.multiply(m1, m2)

def convolute(m1, m2):
    r"""convolute(DensityMap m1, DensityMap m2) -> double"""
    return _IMP_em.convolute(m1, m2)

def get_sum(m1):
    r"""get_sum(DensityMap m1) -> double"""
    return _IMP_em.get_sum(m1)

def get_max_map(maps):
    r"""get_max_map(IMP::em::DensityMaps maps) -> DensityMap"""
    return _IMP_em.get_max_map(maps)

def interpolate_map(in_map, new_spacing):
    r"""interpolate_map(DensityMap in_map, double new_spacing) -> DensityMap"""
    return _IMP_em.interpolate_map(in_map, new_spacing)

def get_grid(in_map):
    r"""get_grid(DensityMap in_map) -> IMP::algebra::GridD< 3,IMP::algebra::DenseGridStorageD< 3,float >,float,IMP::algebra::DefaultEmbeddingD< 3 > >"""
    return _IMP_em.get_grid(in_map)

def create_density_map(*args):
    r"""
    create_density_map(DensityMap other) -> DensityMap
    create_density_map(BoundingBox3D bb, double spacing) -> DensityMap
    create_density_map(int nx, int ny, int nz, double spacing) -> DensityMap
    create_density_map(DenseFloatGrid3D grid) -> DensityMap
    create_density_map(DenseDoubleGrid3D grid) -> DensityMap
    """
    return _IMP_em.create_density_map(*args)

def get_binarized_interior(dmap):
    r"""get_binarized_interior(DensityMap dmap) -> DensityMap"""
    return _IMP_em.get_binarized_interior(dmap)

def add_to_map(dm, pis):
    r"""add_to_map(DensityMap dm, IMP::Particles const & pis)"""
    return _IMP_em.add_to_map(dm, pis)
class RadiusDependentDistanceMask(object):
    r"""Proxy of C++ IMP::em::RadiusDependentDistanceMask class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, sampling_radius, header):
        r"""__init__(RadiusDependentDistanceMask self, float sampling_radius, DensityHeader header) -> RadiusDependentDistanceMask"""
        _IMP_em.RadiusDependentDistanceMask_swiginit(self, _IMP_em.new_RadiusDependentDistanceMask(sampling_radius, header))

    def get_neighbor_shift(self):
        r"""get_neighbor_shift(RadiusDependentDistanceMask self) -> std::vector< double,std::allocator< double > > const *"""
        return _IMP_em.RadiusDependentDistanceMask_get_neighbor_shift(self)

    def get_neighbor_dist(self):
        r"""get_neighbor_dist(RadiusDependentDistanceMask self) -> std::vector< double,std::allocator< double > > const *"""
        return _IMP_em.RadiusDependentDistanceMask_get_neighbor_dist(self)

    def get_neighbor_dist_exp(self):
        r"""get_neighbor_dist_exp(RadiusDependentDistanceMask self) -> std::vector< double,std::allocator< double > > const *"""
        return _IMP_em.RadiusDependentDistanceMask_get_neighbor_dist_exp(self)

    def show(self, out):
        r"""show(RadiusDependentDistanceMask self, _ostream out)"""
        return _IMP_em.RadiusDependentDistanceMask_show(self, out)
    __swig_destroy__ = _IMP_em.delete_RadiusDependentDistanceMask

# Register RadiusDependentDistanceMask in _IMP_em:
_IMP_em.RadiusDependentDistanceMask_swigregister(RadiusDependentDistanceMask)

class DistanceMask(object):
    r"""Proxy of C++ IMP::em::DistanceMask class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(DistanceMask self) -> DistanceMask
        __init__(DistanceMask self, DensityHeader header) -> DistanceMask
        """
        _IMP_em.DistanceMask_swiginit(self, _IMP_em.new_DistanceMask(*args))

    def show(self, out):
        r"""show(DistanceMask self, _ostream out)"""
        return _IMP_em.DistanceMask_show(self, out)

    def is_mask_set(self, radius, eps=0.001):
        r"""is_mask_set(DistanceMask self, float radius, float eps=0.001) -> bool"""
        return _IMP_em.DistanceMask_is_mask_set(self, radius, eps)
    __swig_destroy__ = _IMP_em.delete_DistanceMask

# Register DistanceMask in _IMP_em:
_IMP_em.DistanceMask_swigregister(DistanceMask)

class EMReaderWriter(MapReaderWriter):
    r"""Proxy of C++ IMP::em::EMReaderWriter class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __str__(self):
        r"""__str__(EMReaderWriter self) -> std::string"""
        return _IMP_em.EMReaderWriter___str__(self)

    def __repr__(self):
        r"""__repr__(EMReaderWriter self) -> std::string"""
        return _IMP_em.EMReaderWriter___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_EMReaderWriter(o)


    def __init__(self):
        r"""__init__(EMReaderWriter self) -> EMReaderWriter"""
        _IMP_em.EMReaderWriter_swiginit(self, _IMP_em.new_EMReaderWriter())

# Register EMReaderWriter in _IMP_em:
_IMP_em.EMReaderWriter_swigregister(EMReaderWriter)

class XplorReaderWriter(MapReaderWriter):
    r"""Proxy of C++ IMP::em::XplorReaderWriter class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __str__(self):
        r"""__str__(XplorReaderWriter self) -> std::string"""
        return _IMP_em.XplorReaderWriter___str__(self)

    def __repr__(self):
        r"""__repr__(XplorReaderWriter self) -> std::string"""
        return _IMP_em.XplorReaderWriter___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_XplorReaderWriter(o)


    def __init__(self):
        r"""__init__(XplorReaderWriter self) -> XplorReaderWriter"""
        _IMP_em.XplorReaderWriter_swiginit(self, _IMP_em.new_XplorReaderWriter())

# Register XplorReaderWriter in _IMP_em:
_IMP_em.XplorReaderWriter_swigregister(XplorReaderWriter)

class MRCReaderWriter(MapReaderWriter):
    r"""Proxy of C++ IMP::em::MRCReaderWriter class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(MRCReaderWriter self) -> MRCReaderWriter
        __init__(MRCReaderWriter self, std::string fn) -> MRCReaderWriter
        """
        _IMP_em.MRCReaderWriter_swiginit(self, _IMP_em.new_MRCReaderWriter(*args))

    def __str__(self):
        r"""__str__(MRCReaderWriter self) -> std::string"""
        return _IMP_em.MRCReaderWriter___str__(self)

    def __repr__(self):
        r"""__repr__(MRCReaderWriter self) -> std::string"""
        return _IMP_em.MRCReaderWriter___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_MRCReaderWriter(o)


# Register MRCReaderWriter in _IMP_em:
_IMP_em.MRCReaderWriter_swigregister(MRCReaderWriter)

class KernelParameters(object):
    r"""Proxy of C++ IMP::em::KernelParameters class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(KernelParameters self) -> KernelParameters
        __init__(KernelParameters self, float resolution) -> KernelParameters
        """
        _IMP_em.KernelParameters_swiginit(self, _IMP_em.new_KernelParameters(*args))
    __swig_destroy__ = _IMP_em.delete_KernelParameters

    def get_rsig(self):
        r"""get_rsig(KernelParameters self) -> float"""
        return _IMP_em.KernelParameters_get_rsig(self)

    def get_rsigsq(self):
        r"""get_rsigsq(KernelParameters self) -> float"""
        return _IMP_em.KernelParameters_get_rsigsq(self)

    def get_inv_rsigsq(self):
        r"""get_inv_rsigsq(KernelParameters self) -> float"""
        return _IMP_em.KernelParameters_get_inv_rsigsq(self)

    def get_timessig(self):
        r"""get_timessig(KernelParameters self) -> float"""
        return _IMP_em.KernelParameters_get_timessig(self)

    def get_sq2pi3(self):
        r"""get_sq2pi3(KernelParameters self) -> float"""
        return _IMP_em.KernelParameters_get_sq2pi3(self)

    def get_rnormfac(self):
        r"""get_rnormfac(KernelParameters self) -> float"""
        return _IMP_em.KernelParameters_get_rnormfac(self)

    def get_rkdist(self):
        r"""get_rkdist(KernelParameters self) -> float"""
        return _IMP_em.KernelParameters_get_rkdist(self)

    def get_rkdistsq(self):
        r"""get_rkdistsq(KernelParameters self) -> float"""
        return _IMP_em.KernelParameters_get_rkdistsq(self)

    def get_lim(self):
        r"""get_lim(KernelParameters self) -> float"""
        return _IMP_em.KernelParameters_get_lim(self)

    def show(self, *args):
        r"""show(KernelParameters self, _ostream out=std::cout)"""
        return _IMP_em.KernelParameters_show(self, *args)

    def __str__(self):
        r"""__str__(KernelParameters self) -> std::string"""
        return _IMP_em.KernelParameters___str__(self)

    def __repr__(self):
        r"""__repr__(KernelParameters self) -> std::string"""
        return _IMP_em.KernelParameters___repr__(self)

# Register KernelParameters in _IMP_em:
_IMP_em.KernelParameters_swigregister(KernelParameters)

GAUSSIAN = _IMP_em.GAUSSIAN

BINARIZED_SPHERE = _IMP_em.BINARIZED_SPHERE

SPHERE = _IMP_em.SPHERE

class SampledDensityMap(DensityMap):
    r"""Proxy of C++ IMP::em::SampledDensityMap class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(SampledDensityMap self, IMP::em::KernelType kt=GAUSSIAN) -> SampledDensityMap
        __init__(SampledDensityMap self, DensityHeader header, IMP::em::KernelType kt=GAUSSIAN) -> SampledDensityMap
        __init__(SampledDensityMap self, IMP::ParticlesTemp const & ps, IMP::em::emreal resolution, IMP::em::emreal voxel_size, FloatKey mass_key=IMP::atom::Mass::get_mass_key(), int sig_cutoff=3, IMP::em::KernelType kt=GAUSSIAN) -> SampledDensityMap
        """
        _IMP_em.SampledDensityMap_swiginit(self, _IMP_em.new_SampledDensityMap(*args))

    def resample(self):
        r"""resample(SampledDensityMap self)"""
        return _IMP_em.SampledDensityMap_resample(self)

    def project(self, *args):
        r"""project(SampledDensityMap self, IMP::ParticlesTemp const & ps, int x_margin, int y_margin, int z_margin, Vector3D shift=IMP::algebra::Vector3D(0., 0., 0.), FloatKey mass_key=IMP::atom::Mass::get_mass_key())"""
        return _IMP_em.SampledDensityMap_project(self, *args)

    def set_particles(self, *args):
        r"""set_particles(SampledDensityMap self, IMP::ParticlesTemp const & ps, FloatKey mass_key=IMP::atom::Mass::get_mass_key())"""
        return _IMP_em.SampledDensityMap_set_particles(self, *args)

    def get_xyzr_particles(self):
        r"""get_xyzr_particles(SampledDensityMap self) -> IMP::core::XYZRs const &"""
        return _IMP_em.SampledDensityMap_get_xyzr_particles(self)

    def get_sampled_particles(self):
        r"""get_sampled_particles(SampledDensityMap self) -> IMP::Particles const &"""
        return _IMP_em.SampledDensityMap_get_sampled_particles(self)

    def get_weight_key(self):
        r"""get_weight_key(SampledDensityMap self) -> FloatKey"""
        return _IMP_em.SampledDensityMap_get_weight_key(self)

    def get_minimum_resampled_value(self):
        r"""get_minimum_resampled_value(SampledDensityMap self) -> float"""
        return _IMP_em.SampledDensityMap_get_minimum_resampled_value(self)

    def update_resolution(self, res):
        r"""update_resolution(SampledDensityMap self, IMP::Float res)"""
        return _IMP_em.SampledDensityMap_update_resolution(self, res)
    __swig_destroy__ = _IMP_em.delete_SampledDensityMap

    def __str__(self):
        r"""__str__(SampledDensityMap self) -> std::string"""
        return _IMP_em.SampledDensityMap___str__(self)

    def __repr__(self):
        r"""__repr__(SampledDensityMap self) -> std::string"""
        return _IMP_em.SampledDensityMap___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_SampledDensityMap(o)


# Register SampledDensityMap in _IMP_em:
_IMP_em.SampledDensityMap_swigregister(SampledDensityMap)

IMP_DEFAULT_NUM_SHELLS = _IMP_em.IMP_DEFAULT_NUM_SHELLS

IMP_SIG_CUTOFF = _IMP_em.IMP_SIG_CUTOFF

class SurfaceShellDensityMap(SampledDensityMap):
    r"""Proxy of C++ IMP::em::SurfaceShellDensityMap class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(SurfaceShellDensityMap self) -> SurfaceShellDensityMap
        __init__(SurfaceShellDensityMap self, DensityHeader header) -> SurfaceShellDensityMap
        __init__(SurfaceShellDensityMap self, IMP::ParticlesTemp const & ps, float voxel_size, FloatKey mass_key=IMP::atom::Mass::get_mass_key(), int num_shells=5) -> SurfaceShellDensityMap
        """
        _IMP_em.SurfaceShellDensityMap_swiginit(self, _IMP_em.new_SurfaceShellDensityMap(*args))

    def binarize(self, scene_val):
        r"""binarize(SurfaceShellDensityMap self, float scene_val)"""
        return _IMP_em.SurfaceShellDensityMap_binarize(self, scene_val)

    def has_background_neighbor(self, voxel_ind):
        r"""has_background_neighbor(SurfaceShellDensityMap self, long voxel_ind) -> bool"""
        return _IMP_em.SurfaceShellDensityMap_has_background_neighbor(self, voxel_ind)
    __swig_destroy__ = _IMP_em.delete_SurfaceShellDensityMap

    def __str__(self):
        r"""__str__(SurfaceShellDensityMap self) -> std::string"""
        return _IMP_em.SurfaceShellDensityMap___str__(self)

    def __repr__(self):
        r"""__repr__(SurfaceShellDensityMap self) -> std::string"""
        return _IMP_em.SurfaceShellDensityMap___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_SurfaceShellDensityMap(o)


# Register SurfaceShellDensityMap in _IMP_em:
_IMP_em.SurfaceShellDensityMap_swigregister(SurfaceShellDensityMap)


def get_coarse_cc_score(*args):
    r"""get_coarse_cc_score(DensityMap data, SampledDensityMap model_map, double scalefactor, bool recalc_rms=True, bool resample=True, IMP::FloatPair norm_factors=IMP::FloatPair(0., 0.)) -> double"""
    return _IMP_em.get_coarse_cc_score(*args)

def get_coarse_cc_coefficient(*args):
    r"""get_coarse_cc_coefficient(DensityMap grid1, DensityMap grid2, double grid2_voxel_data_threshold, bool allow_padding=False, IMP::FloatPair norm_factors=IMP::FloatPair(0., 0.)) -> double"""
    return _IMP_em.get_coarse_cc_coefficient(*args)

def get_coarse_cc_local_coefficient(em_map, model_map, voxel_data_threshold):
    r"""get_coarse_cc_local_coefficient(DensityMap em_map, DensityMap model_map, double voxel_data_threshold) -> double"""
    return _IMP_em.get_coarse_cc_local_coefficient(em_map, model_map, voxel_data_threshold)
class CoarseCC(IMP.Object):
    r"""Proxy of C++ IMP::em::CoarseCC class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self):
        r"""__init__(CoarseCC self) -> CoarseCC"""
        _IMP_em.CoarseCC_swiginit(self, _IMP_em.new_CoarseCC())

    @staticmethod
    def calc_score(*args):
        r"""calc_score(DensityMap data, SampledDensityMap model_map, float scalefactor, bool recalc_rms=True, bool resample=True, IMP::FloatPair norm_factors=IMP::FloatPair(0., 0.)) -> float"""
        return _IMP_em.CoarseCC_calc_score(*args)

    @staticmethod
    def cross_correlation_coefficient(*args):
        r"""cross_correlation_coefficient(DensityMap grid1, DensityMap grid2, float grid2_voxel_data_threshold, bool allow_padding=False, IMP::FloatPair norm_factors=IMP::FloatPair(0., 0.)) -> double"""
        return _IMP_em.CoarseCC_cross_correlation_coefficient(*args)

    @staticmethod
    def local_cross_correlation_coefficient(em_map, model_map, voxel_data_threshold):
        r"""local_cross_correlation_coefficient(DensityMap em_map, DensityMap model_map, float voxel_data_threshold) -> float"""
        return _IMP_em.CoarseCC_local_cross_correlation_coefficient(em_map, model_map, voxel_data_threshold)

    def get_version_info(self):
        r"""get_version_info(CoarseCC self) -> VersionInfo"""
        return _IMP_em.CoarseCC_get_version_info(self)

    def __str__(self):
        r"""__str__(CoarseCC self) -> std::string"""
        return _IMP_em.CoarseCC___str__(self)

    def __repr__(self):
        r"""__repr__(CoarseCC self) -> std::string"""
        return _IMP_em.CoarseCC___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_CoarseCC(o)


# Register CoarseCC in _IMP_em:
_IMP_em.CoarseCC_swigregister(CoarseCC)

def CoarseCC_calc_score(*args):
    r"""CoarseCC_calc_score(DensityMap data, SampledDensityMap model_map, float scalefactor, bool recalc_rms=True, bool resample=True, IMP::FloatPair norm_factors=IMP::FloatPair(0., 0.)) -> float"""
    return _IMP_em.CoarseCC_calc_score(*args)

def CoarseCC_cross_correlation_coefficient(*args):
    r"""CoarseCC_cross_correlation_coefficient(DensityMap grid1, DensityMap grid2, float grid2_voxel_data_threshold, bool allow_padding=False, IMP::FloatPair norm_factors=IMP::FloatPair(0., 0.)) -> double"""
    return _IMP_em.CoarseCC_cross_correlation_coefficient(*args)

def CoarseCC_local_cross_correlation_coefficient(em_map, model_map, voxel_data_threshold):
    r"""CoarseCC_local_cross_correlation_coefficient(DensityMap em_map, DensityMap model_map, float voxel_data_threshold) -> float"""
    return _IMP_em.CoarseCC_local_cross_correlation_coefficient(em_map, model_map, voxel_data_threshold)

class CoarseConvolution(object):
    r"""Proxy of C++ IMP::em::CoarseConvolution class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    @staticmethod
    def convolution(em_map, model_map, voxel_data_threshold, recalc_ccnormfac=True):
        r"""convolution(DensityMap em_map, DensityMap model_map, float voxel_data_threshold, bool recalc_ccnormfac=True) -> float"""
        return _IMP_em.CoarseConvolution_convolution(em_map, model_map, voxel_data_threshold, recalc_ccnormfac)

    def __init__(self):
        r"""__init__(CoarseConvolution self) -> CoarseConvolution"""
        _IMP_em.CoarseConvolution_swiginit(self, _IMP_em.new_CoarseConvolution())
    __swig_destroy__ = _IMP_em.delete_CoarseConvolution

# Register CoarseConvolution in _IMP_em:
_IMP_em.CoarseConvolution_swigregister(CoarseConvolution)

def CoarseConvolution_convolution(em_map, model_map, voxel_data_threshold, recalc_ccnormfac=True):
    r"""CoarseConvolution_convolution(DensityMap em_map, DensityMap model_map, float voxel_data_threshold, bool recalc_ccnormfac=True) -> float"""
    return _IMP_em.CoarseConvolution_convolution(em_map, model_map, voxel_data_threshold, recalc_ccnormfac)

class CoarseCCatIntervals(IMP.Object):
    r"""Proxy of C++ IMP::em::CoarseCCatIntervals class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(CoarseCCatIntervals self, int const & ncd) -> CoarseCCatIntervals
        __init__(CoarseCCatIntervals self) -> CoarseCCatIntervals
        """
        _IMP_em.CoarseCCatIntervals_swiginit(self, _IMP_em.new_CoarseCCatIntervals(*args))

    def evaluate(self, em_map, model_map, deriv, scalefac, lderiv, eval_interval):
        r"""evaluate(CoarseCCatIntervals self, DensityMap em_map, SampledDensityMap model_map, IMP::algebra::Vector3Ds const & deriv, float scalefac, bool lderiv, unsigned long eval_interval) -> std::pair< double,IMP::algebra::Vector3Ds >"""
        return _IMP_em.CoarseCCatIntervals_evaluate(self, em_map, model_map, deriv, scalefac, lderiv, eval_interval)

    def get_version_info(self):
        r"""get_version_info(CoarseCCatIntervals self) -> VersionInfo"""
        return _IMP_em.CoarseCCatIntervals_get_version_info(self)

    def __str__(self):
        r"""__str__(CoarseCCatIntervals self) -> std::string"""
        return _IMP_em.CoarseCCatIntervals___str__(self)

    def __repr__(self):
        r"""__repr__(CoarseCCatIntervals self) -> std::string"""
        return _IMP_em.CoarseCCatIntervals___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_CoarseCCatIntervals(o)


# Register CoarseCCatIntervals in _IMP_em:
_IMP_em.CoarseCCatIntervals_swigregister(CoarseCCatIntervals)


def bayesem3d_get_distinct_and_counts(em):
    r"""bayesem3d_get_distinct_and_counts(DensityMap em) -> std::map< double,int >"""
    return _IMP_em.bayesem3d_get_distinct_and_counts(em)

def bayesem3d_get_cumulative_sum(em):
    r"""bayesem3d_get_cumulative_sum(DensityMap em) -> IMP::Floats"""
    return _IMP_em.bayesem3d_get_cumulative_sum(em)

def bayesem3d_get_cumulative_sum_with_reference(em):
    r"""bayesem3d_get_cumulative_sum_with_reference(DensityMap em) -> std::map< double,double >"""
    return _IMP_em.bayesem3d_get_cumulative_sum_with_reference(em)

def bayesem3d_linear_interpolate(x_data, y_data, x, extrapolate):
    r"""bayesem3d_linear_interpolate(IMP::Floats const & x_data, IMP::Floats const & y_data, double x, bool extrapolate) -> double"""
    return _IMP_em.bayesem3d_linear_interpolate(x_data, y_data, x, extrapolate)

def bayesem3d_get_logabssumexp(x, y, sx, sy):
    r"""bayesem3d_get_logabssumexp(double x, double y, double sx, double sy) -> IMP::FloatPair"""
    return _IMP_em.bayesem3d_get_logabssumexp(x, y, sx, sy)

def bayesem3d_get_logabssumprodexp(x, y, wx, wy):
    r"""bayesem3d_get_logabssumprodexp(double x, double y, double wx, double wy) -> IMP::FloatPair"""
    return _IMP_em.bayesem3d_get_logabssumprodexp(x, y, wx, wy)

def bayesem3d_get_logsumexp(x, y):
    r"""bayesem3d_get_logsumexp(double x, double y) -> double"""
    return _IMP_em.bayesem3d_get_logsumexp(x, y)

def bayesem3d_get_logsumprodexp(x, y, wx, wy):
    r"""bayesem3d_get_logsumprodexp(double x, double y, double wx, double wy) -> double"""
    return _IMP_em.bayesem3d_get_logsumprodexp(x, y, wx, wy)

def bayesem3d_get_em_density_squared(em, number_of_voxels):
    r"""bayesem3d_get_em_density_squared(DensityMap em, long number_of_voxels) -> IMP::FloatPair"""
    return _IMP_em.bayesem3d_get_em_density_squared(em, number_of_voxels)

def bayesem3d_get_value(p, pt, mass_ii, kps):
    r"""bayesem3d_get_value(Particle p, Vector3D pt, double mass_ii, KernelParameters kps) -> std::vector< double,std::allocator< double > >"""
    return _IMP_em.bayesem3d_get_value(p, pt, mass_ii, kps)

def bayesem3d_get_value_no_deriv(p, pt, mass_ii, kps):
    r"""bayesem3d_get_value_no_deriv(Particle p, Vector3D pt, double mass_ii, KernelParameters kps) -> std::vector< double,std::allocator< double > >"""
    return _IMP_em.bayesem3d_get_value_no_deriv(p, pt, mass_ii, kps)

def bayesem3d_get_density_from_particle(em, ps, resolution, window_size=1.0):
    r"""bayesem3d_get_density_from_particle(DensityMap em, IMP::ParticlesTemp const & ps, double resolution, double const window_size=1.0) -> DensityMap"""
    return _IMP_em.bayesem3d_get_density_from_particle(em, ps, resolution, window_size)

def bayesem3d_get_cross_correlation_coefficient(em1, em2):
    r"""bayesem3d_get_cross_correlation_coefficient(DensityMap em1, DensityMap em2) -> double"""
    return _IMP_em.bayesem3d_get_cross_correlation_coefficient(em1, em2)

def bayesem3d_get_score_and_derivative(em, ps, resolution, sigma, window_size=1.0):
    r"""bayesem3d_get_score_and_derivative(DensityMap em, IMP::ParticlesTemp const & ps, double resolution, double sigma, double const window_size=1.0) -> std::pair< double,IMP::algebra::Vector3Ds >"""
    return _IMP_em.bayesem3d_get_score_and_derivative(em, ps, resolution, sigma, window_size)

def bayesem3d_get_normalized_intensities(em, ps, resolution):
    r"""bayesem3d_get_normalized_intensities(DensityMap em, IMP::ParticlesTemp const & ps, double resolution)"""
    return _IMP_em.bayesem3d_get_normalized_intensities(em, ps, resolution)
class FitRestraint(IMP.Restraint):
    r"""Proxy of C++ IMP::em::FitRestraint class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""__init__(FitRestraint self, IMP::ParticlesTemp ps, DensityMap em_map, IMP::FloatPair norm_factors=IMP::FloatPair(0., 0.), FloatKey weight_key=IMP::atom::Mass::get_mass_key(), float scale=1, bool use_rigid_bodies=True, IMP::em::KernelType kt=GAUSSIAN) -> FitRestraint"""
        _IMP_em.FitRestraint_swiginit(self, _IMP_em.new_FitRestraint(*args))

    def get_model_dens_map(self):
        r"""get_model_dens_map(FitRestraint self) -> SampledDensityMap"""
        return _IMP_em.FitRestraint_get_model_dens_map(self)

    def set_scale_factor(self, scale):
        r"""set_scale_factor(FitRestraint self, float scale)"""
        return _IMP_em.FitRestraint_set_scale_factor(self, scale)

    def get_scale_factor(self):
        r"""get_scale_factor(FitRestraint self) -> float"""
        return _IMP_em.FitRestraint_get_scale_factor(self)

    def do_get_inputs(self):
        r"""do_get_inputs(FitRestraint self) -> IMP::ModelObjectsTemp"""
        return _IMP_em.FitRestraint_do_get_inputs(self)

    def get_version_info(self):
        r"""get_version_info(FitRestraint self) -> VersionInfo"""
        return _IMP_em.FitRestraint_get_version_info(self)

    def __str__(self):
        r"""__str__(FitRestraint self) -> std::string"""
        return _IMP_em.FitRestraint___str__(self)

    def __repr__(self):
        r"""__repr__(FitRestraint self) -> std::string"""
        return _IMP_em.FitRestraint___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_FitRestraint(o)


# Register FitRestraint in _IMP_em:
_IMP_em.FitRestraint_swigregister(FitRestraint)

class FitRestraintBayesEM3D(IMP.Restraint):
    r"""Proxy of C++ IMP::em::FitRestraintBayesEM3D class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""__init__(FitRestraintBayesEM3D self, IMP::ParticlesTemp ps, DensityMap em_map, FloatKey weight_key=IMP::atom::Mass::get_mass_key(), bool use_rigid_bodies=True, double sigma=.1, double window_size=1.0) -> FitRestraintBayesEM3D"""
        _IMP_em.FitRestraintBayesEM3D_swiginit(self, _IMP_em.new_FitRestraintBayesEM3D(*args))

    def do_get_inputs(self):
        r"""do_get_inputs(FitRestraintBayesEM3D self) -> IMP::ModelObjectsTemp"""
        return _IMP_em.FitRestraintBayesEM3D_do_get_inputs(self)

    def get_version_info(self):
        r"""get_version_info(FitRestraintBayesEM3D self) -> VersionInfo"""
        return _IMP_em.FitRestraintBayesEM3D_get_version_info(self)

    def __str__(self):
        r"""__str__(FitRestraintBayesEM3D self) -> std::string"""
        return _IMP_em.FitRestraintBayesEM3D___str__(self)

    def __repr__(self):
        r"""__repr__(FitRestraintBayesEM3D self) -> std::string"""
        return _IMP_em.FitRestraintBayesEM3D___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_FitRestraintBayesEM3D(o)


# Register FitRestraintBayesEM3D in _IMP_em:
_IMP_em.FitRestraintBayesEM3D_swigregister(FitRestraintBayesEM3D)


def density2particles(dmap, threshold, m, step=1):
    r"""density2particles(DensityMap dmap, IMP::Float threshold, Model m, int step=1) -> IMP::Particles"""
    return _IMP_em.density2particles(dmap, threshold, m, step)

def density2vectors(dmap, threshold):
    r"""density2vectors(DensityMap dmap, IMP::Float threshold) -> IMP::algebra::Vector3Ds"""
    return _IMP_em.density2vectors(dmap, threshold)

def particles2density(*args):
    r"""particles2density(IMP::ParticlesTemp const & ps, IMP::Float resolution, IMP::Float apix, int sig_cutoff=3, FloatKey weight_key=IMP::atom::Mass::get_mass_key()) -> SampledDensityMap"""
    return _IMP_em.particles2density(*args)

def particles2binarized_density(*args):
    r"""particles2binarized_density(IMP::ParticlesTemp const & ps, IMP::Float resolution, IMP::Float apix, int sig_cutoff=3, FloatKey weight_key=IMP::atom::Mass::get_mass_key()) -> SampledDensityMap"""
    return _IMP_em.particles2binarized_density(*args)

def particles2surface(*args):
    r"""particles2surface(IMP::ParticlesTemp const & ps, IMP::Float apix, FloatKey weight_key=IMP::atom::Mass::get_mass_key()) -> SurfaceShellDensityMap"""
    return _IMP_em.particles2surface(*args)

def calculate_intersection_score(d1, d2):
    r"""calculate_intersection_score(SurfaceShellDensityMap d1, SurfaceShellDensityMap d2) -> IMP::Float"""
    return _IMP_em.calculate_intersection_score(d1, d2)
class SpiderHeader(object):
    r"""Proxy of C++ IMP::em::SpiderHeader class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    fNslice = property(_IMP_em.SpiderHeader_fNslice_get, _IMP_em.SpiderHeader_fNslice_set, doc=r"""fNslice : float""")
    fNrow = property(_IMP_em.SpiderHeader_fNrow_get, _IMP_em.SpiderHeader_fNrow_set, doc=r"""fNrow : float""")
    fNrec = property(_IMP_em.SpiderHeader_fNrec_get, _IMP_em.SpiderHeader_fNrec_set, doc=r"""fNrec : float""")
    fNlabel = property(_IMP_em.SpiderHeader_fNlabel_get, _IMP_em.SpiderHeader_fNlabel_set, doc=r"""fNlabel : float""")
    fIform = property(_IMP_em.SpiderHeader_fIform_get, _IMP_em.SpiderHeader_fIform_set, doc=r"""fIform : float""")
    fImami = property(_IMP_em.SpiderHeader_fImami_get, _IMP_em.SpiderHeader_fImami_set, doc=r"""fImami : float""")
    fFmax = property(_IMP_em.SpiderHeader_fFmax_get, _IMP_em.SpiderHeader_fFmax_set, doc=r"""fFmax : float""")
    fFmin = property(_IMP_em.SpiderHeader_fFmin_get, _IMP_em.SpiderHeader_fFmin_set, doc=r"""fFmin : float""")
    fAv = property(_IMP_em.SpiderHeader_fAv_get, _IMP_em.SpiderHeader_fAv_set, doc=r"""fAv : float""")
    fSig = property(_IMP_em.SpiderHeader_fSig_get, _IMP_em.SpiderHeader_fSig_set, doc=r"""fSig : float""")
    fIhist = property(_IMP_em.SpiderHeader_fIhist_get, _IMP_em.SpiderHeader_fIhist_set, doc=r"""fIhist : float""")
    fNcol = property(_IMP_em.SpiderHeader_fNcol_get, _IMP_em.SpiderHeader_fNcol_set, doc=r"""fNcol : float""")
    fLabrec = property(_IMP_em.SpiderHeader_fLabrec_get, _IMP_em.SpiderHeader_fLabrec_set, doc=r"""fLabrec : float""")
    fIangle = property(_IMP_em.SpiderHeader_fIangle_get, _IMP_em.SpiderHeader_fIangle_set, doc=r"""fIangle : float""")
    fPhi = property(_IMP_em.SpiderHeader_fPhi_get, _IMP_em.SpiderHeader_fPhi_set, doc=r"""fPhi : float""")
    fTheta = property(_IMP_em.SpiderHeader_fTheta_get, _IMP_em.SpiderHeader_fTheta_set, doc=r"""fTheta : float""")
    fPsi = property(_IMP_em.SpiderHeader_fPsi_get, _IMP_em.SpiderHeader_fPsi_set, doc=r"""fPsi : float""")
    fXoff = property(_IMP_em.SpiderHeader_fXoff_get, _IMP_em.SpiderHeader_fXoff_set, doc=r"""fXoff : float""")
    fYoff = property(_IMP_em.SpiderHeader_fYoff_get, _IMP_em.SpiderHeader_fYoff_set, doc=r"""fYoff : float""")
    fZoff = property(_IMP_em.SpiderHeader_fZoff_get, _IMP_em.SpiderHeader_fZoff_set, doc=r"""fZoff : float""")
    fScale = property(_IMP_em.SpiderHeader_fScale_get, _IMP_em.SpiderHeader_fScale_set, doc=r"""fScale : float""")
    fLabbyt = property(_IMP_em.SpiderHeader_fLabbyt_get, _IMP_em.SpiderHeader_fLabbyt_set, doc=r"""fLabbyt : float""")
    fLenbyt = property(_IMP_em.SpiderHeader_fLenbyt_get, _IMP_em.SpiderHeader_fLenbyt_set, doc=r"""fLenbyt : float""")
    fNothing = property(_IMP_em.SpiderHeader_fNothing_get, _IMP_em.SpiderHeader_fNothing_set, doc=r"""fNothing : a(24).char""")
    fFlag = property(_IMP_em.SpiderHeader_fFlag_get, _IMP_em.SpiderHeader_fFlag_set, doc=r"""fFlag : float""")
    fPhi1 = property(_IMP_em.SpiderHeader_fPhi1_get, _IMP_em.SpiderHeader_fPhi1_set, doc=r"""fPhi1 : float""")
    fTheta1 = property(_IMP_em.SpiderHeader_fTheta1_get, _IMP_em.SpiderHeader_fTheta1_set, doc=r"""fTheta1 : float""")
    fPsi1 = property(_IMP_em.SpiderHeader_fPsi1_get, _IMP_em.SpiderHeader_fPsi1_set, doc=r"""fPsi1 : float""")
    fPhi2 = property(_IMP_em.SpiderHeader_fPhi2_get, _IMP_em.SpiderHeader_fPhi2_set, doc=r"""fPhi2 : float""")
    fTheta2 = property(_IMP_em.SpiderHeader_fTheta2_get, _IMP_em.SpiderHeader_fTheta2_set, doc=r"""fTheta2 : float""")
    fPsi2 = property(_IMP_em.SpiderHeader_fPsi2_get, _IMP_em.SpiderHeader_fPsi2_set, doc=r"""fPsi2 : float""")
    fGeo_matrix = property(_IMP_em.SpiderHeader_fGeo_matrix_get, _IMP_em.SpiderHeader_fGeo_matrix_set, doc=r"""fGeo_matrix : a(3).a(3).double""")
    fAngle1 = property(_IMP_em.SpiderHeader_fAngle1_get, _IMP_em.SpiderHeader_fAngle1_set, doc=r"""fAngle1 : float""")
    fr1 = property(_IMP_em.SpiderHeader_fr1_get, _IMP_em.SpiderHeader_fr1_set, doc=r"""fr1 : float""")
    fr2 = property(_IMP_em.SpiderHeader_fr2_get, _IMP_em.SpiderHeader_fr2_set, doc=r"""fr2 : float""")
    RTflag = property(_IMP_em.SpiderHeader_RTflag_get, _IMP_em.SpiderHeader_RTflag_set, doc=r"""RTflag : float""")
    Astart = property(_IMP_em.SpiderHeader_Astart_get, _IMP_em.SpiderHeader_Astart_set, doc=r"""Astart : float""")
    Aend = property(_IMP_em.SpiderHeader_Aend_get, _IMP_em.SpiderHeader_Aend_set, doc=r"""Aend : float""")
    Ainc = property(_IMP_em.SpiderHeader_Ainc_get, _IMP_em.SpiderHeader_Ainc_set, doc=r"""Ainc : float""")
    Rsigma = property(_IMP_em.SpiderHeader_Rsigma_get, _IMP_em.SpiderHeader_Rsigma_set, doc=r"""Rsigma : float""")
    Tstart = property(_IMP_em.SpiderHeader_Tstart_get, _IMP_em.SpiderHeader_Tstart_set, doc=r"""Tstart : float""")
    Tend = property(_IMP_em.SpiderHeader_Tend_get, _IMP_em.SpiderHeader_Tend_set, doc=r"""Tend : float""")
    Tinc = property(_IMP_em.SpiderHeader_Tinc_get, _IMP_em.SpiderHeader_Tinc_set, doc=r"""Tinc : float""")
    Weight = property(_IMP_em.SpiderHeader_Weight_get, _IMP_em.SpiderHeader_Weight_set, doc=r"""Weight : float""")
    Flip = property(_IMP_em.SpiderHeader_Flip_get, _IMP_em.SpiderHeader_Flip_set, doc=r"""Flip : float""")
    empty = property(_IMP_em.SpiderHeader_empty_get, _IMP_em.SpiderHeader_empty_set, doc=r"""empty : a(576).char""")
    szIDat = property(_IMP_em.SpiderHeader_szIDat_get, _IMP_em.SpiderHeader_szIDat_set, doc=r"""szIDat : a(12).char""")
    szITim = property(_IMP_em.SpiderHeader_szITim_get, _IMP_em.SpiderHeader_szITim_set, doc=r"""szITim : a(8).char""")
    szITit = property(_IMP_em.SpiderHeader_szITit_get, _IMP_em.SpiderHeader_szITit_set, doc=r"""szITit : a(160).char""")

    def show(self, out):
        r"""show(SpiderHeader self, _ostream out)"""
        return _IMP_em.SpiderHeader_show(self, out)

    def __init__(self):
        r"""__init__(SpiderHeader self) -> SpiderHeader"""
        _IMP_em.SpiderHeader_swiginit(self, _IMP_em.new_SpiderHeader())
    __swig_destroy__ = _IMP_em.delete_SpiderHeader

# Register SpiderHeader in _IMP_em:
_IMP_em.SpiderHeader_swigregister(SpiderHeader)

class ImageHeader(object):
    r"""Proxy of C++ IMP::em::ImageHeader class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    IMG_BYTE = _IMP_em.ImageHeader_IMG_BYTE
    
    IMG_IMPEM = _IMP_em.ImageHeader_IMG_IMPEM
    
    IMG_INT = _IMP_em.ImageHeader_IMG_INT
    
    VOL_BYTE = _IMP_em.ImageHeader_VOL_BYTE
    
    VOL_IMPEM = _IMP_em.ImageHeader_VOL_IMPEM
    
    VOL_INT = _IMP_em.ImageHeader_VOL_INT
    
    IMG_FOURIER = _IMP_em.ImageHeader_IMG_FOURIER
    
    VOL_FOURIER = _IMP_em.ImageHeader_VOL_FOURIER
    

    def __init__(self, *args):
        r"""
        __init__(ImageHeader self) -> ImageHeader
        __init__(ImageHeader self, IMP::em::ImageHeader::img_type im) -> ImageHeader
        __init__(ImageHeader self, float im) -> ImageHeader
        """
        _IMP_em.ImageHeader_swiginit(self, _IMP_em.new_ImageHeader(*args))

    def get_image_type(self):
        r"""get_image_type(ImageHeader self) -> float"""
        return _IMP_em.ImageHeader_get_image_type(self)

    def set_image_type(self, *args):
        r"""
        set_image_type(ImageHeader self, IMP::em::ImageHeader::img_type im)
        set_image_type(ImageHeader self, float im)
        """
        return _IMP_em.ImageHeader_set_image_type(self, *args)

    def do_show(self, out):
        r"""do_show(ImageHeader self, _ostream out)"""
        return _IMP_em.ImageHeader_do_show(self, out)

    def show(self, *args):
        r"""show(ImageHeader self, _ostream out=std::cout)"""
        return _IMP_em.ImageHeader_show(self, *args)

    def print_hard(self, out):
        r"""print_hard(ImageHeader self, _ostream out)"""
        return _IMP_em.ImageHeader_print_hard(self, out)

    def show_projection_params(self, out):
        r"""show_projection_params(ImageHeader self, _ostream out)"""
        return _IMP_em.ImageHeader_show_projection_params(self, out)

    def read(self, *args):
        r"""
        read(ImageHeader self, IMP::String const filename, bool skip_type_check=False, bool force_reversed=False, bool skip_extra_checkings=False) -> int
        read(ImageHeader self, std::ifstream & f, bool skip_type_check=False, bool force_reversed=False, bool skip_extra_checkings=False) -> bool
        """
        return _IMP_em.ImageHeader_read(self, *args)

    def write(self, *args):
        r"""
        write(ImageHeader self, IMP::String const & filename, bool force_reversed=False)
        write(ImageHeader self, std::ofstream & f, bool force_reversed=False)
        """
        return _IMP_em.ImageHeader_write(self, *args)

    def clear(self):
        r"""clear(ImageHeader self)"""
        return _IMP_em.ImageHeader_clear(self)

    def set_header(self):
        r"""set_header(ImageHeader self)"""
        return _IMP_em.ImageHeader_set_header(self)

    def get_reversed(self):
        r"""get_reversed(ImageHeader self) -> bool"""
        return _IMP_em.ImageHeader_get_reversed(self)

    def set_reversed(self, value):
        r"""set_reversed(ImageHeader self, bool value)"""
        return _IMP_em.ImageHeader_set_reversed(self, value)

    def get_number_of_slices(self):
        r"""get_number_of_slices(ImageHeader self) -> unsigned int"""
        return _IMP_em.ImageHeader_get_number_of_slices(self)

    def set_number_of_slices(self, n):
        r"""set_number_of_slices(ImageHeader self, unsigned int n)"""
        return _IMP_em.ImageHeader_set_number_of_slices(self, n)

    def get_number_of_rows(self):
        r"""get_number_of_rows(ImageHeader self) -> unsigned int"""
        return _IMP_em.ImageHeader_get_number_of_rows(self)

    def set_number_of_rows(self, n):
        r"""set_number_of_rows(ImageHeader self, unsigned int n)"""
        return _IMP_em.ImageHeader_set_number_of_rows(self, n)

    def get_number_of_columns(self):
        r"""get_number_of_columns(ImageHeader self) -> unsigned int"""
        return _IMP_em.ImageHeader_get_number_of_columns(self)

    def set_number_of_columns(self, n):
        r"""set_number_of_columns(ImageHeader self, unsigned int n)"""
        return _IMP_em.ImageHeader_set_number_of_columns(self, n)

    def get_old_rot(self):
        r"""get_old_rot(ImageHeader self) -> float"""
        return _IMP_em.ImageHeader_get_old_rot(self)

    def set_old_rot(self, value):
        r"""set_old_rot(ImageHeader self, float value)"""
        return _IMP_em.ImageHeader_set_old_rot(self, value)

    def get_fAngle1(self):
        r"""get_fAngle1(ImageHeader self) -> float"""
        return _IMP_em.ImageHeader_get_fAngle1(self)

    def set_fAngle1(self, value):
        r"""set_fAngle1(ImageHeader self, float value)"""
        return _IMP_em.ImageHeader_set_fAngle1(self, value)

    def get_Scale(self):
        r"""get_Scale(ImageHeader self) -> float"""
        return _IMP_em.ImageHeader_get_Scale(self)

    def set_Scale(self, value):
        r"""set_Scale(ImageHeader self, float value)"""
        return _IMP_em.ImageHeader_set_Scale(self, value)

    def get_Flip(self):
        r"""get_Flip(ImageHeader self) -> float"""
        return _IMP_em.ImageHeader_get_Flip(self)

    def set_Flip(self, value):
        r"""set_Flip(ImageHeader self, float value)"""
        return _IMP_em.ImageHeader_set_Flip(self, value)

    def get_Weight(self):
        r"""get_Weight(ImageHeader self) -> float"""
        return _IMP_em.ImageHeader_get_Weight(self)

    def set_Weight(self, value):
        r"""set_Weight(ImageHeader self, float value)"""
        return _IMP_em.ImageHeader_set_Weight(self, value)

    def get_fNrec(self):
        r"""get_fNrec(ImageHeader self) -> float"""
        return _IMP_em.ImageHeader_get_fNrec(self)

    def set_fNrec(self, value):
        r"""set_fNrec(ImageHeader self, float value)"""
        return _IMP_em.ImageHeader_set_fNrec(self, value)

    def get_fNlabel(self):
        r"""get_fNlabel(ImageHeader self) -> float"""
        return _IMP_em.ImageHeader_get_fNlabel(self)

    def set_fNlabel(self, value):
        r"""set_fNlabel(ImageHeader self, float value)"""
        return _IMP_em.ImageHeader_set_fNlabel(self, value)

    def get_fIform(self):
        r"""get_fIform(ImageHeader self) -> float"""
        return _IMP_em.ImageHeader_get_fIform(self)

    def set_fIform(self, value):
        r"""set_fIform(ImageHeader self, float value)"""
        return _IMP_em.ImageHeader_set_fIform(self, value)

    def get_fImami(self):
        r"""get_fImami(ImageHeader self) -> float"""
        return _IMP_em.ImageHeader_get_fImami(self)

    def set_fImami(self, value):
        r"""set_fImami(ImageHeader self, float value)"""
        return _IMP_em.ImageHeader_set_fImami(self, value)

    def get_fFmax(self):
        r"""get_fFmax(ImageHeader self) -> float"""
        return _IMP_em.ImageHeader_get_fFmax(self)

    def set_fFmax(self, value):
        r"""set_fFmax(ImageHeader self, float value)"""
        return _IMP_em.ImageHeader_set_fFmax(self, value)

    def get_fFmin(self):
        r"""get_fFmin(ImageHeader self) -> float"""
        return _IMP_em.ImageHeader_get_fFmin(self)

    def set_fFmin(self, value):
        r"""set_fFmin(ImageHeader self, float value)"""
        return _IMP_em.ImageHeader_set_fFmin(self, value)

    def get_fAv(self):
        r"""get_fAv(ImageHeader self) -> float"""
        return _IMP_em.ImageHeader_get_fAv(self)

    def set_fAv(self, value):
        r"""set_fAv(ImageHeader self, float value)"""
        return _IMP_em.ImageHeader_set_fAv(self, value)

    def get_fSig(self):
        r"""get_fSig(ImageHeader self) -> float"""
        return _IMP_em.ImageHeader_get_fSig(self)

    def set_fSig(self, value):
        r"""set_fSig(ImageHeader self, float value)"""
        return _IMP_em.ImageHeader_set_fSig(self, value)

    def get_fIhist(self):
        r"""get_fIhist(ImageHeader self) -> float"""
        return _IMP_em.ImageHeader_get_fIhist(self)

    def set_fIhist(self, value):
        r"""set_fIhist(ImageHeader self, float value)"""
        return _IMP_em.ImageHeader_set_fIhist(self, value)

    def get_fLabrec(self):
        r"""get_fLabrec(ImageHeader self) -> float"""
        return _IMP_em.ImageHeader_get_fLabrec(self)

    def set_fLabrec(self, value):
        r"""set_fLabrec(ImageHeader self, float value)"""
        return _IMP_em.ImageHeader_set_fLabrec(self, value)

    def get_fIangle(self):
        r"""get_fIangle(ImageHeader self) -> float"""
        return _IMP_em.ImageHeader_get_fIangle(self)

    def set_fIangle(self, value):
        r"""set_fIangle(ImageHeader self, float value)"""
        return _IMP_em.ImageHeader_set_fIangle(self, value)

    def get_origin(self):
        r"""get_origin(ImageHeader self) -> Vector3D"""
        return _IMP_em.ImageHeader_get_origin(self)

    def set_origin(self, *args):
        r"""
        set_origin(ImageHeader self, Vector3D v)
        set_origin(ImageHeader self, Vector2D v)
        """
        return _IMP_em.ImageHeader_set_origin(self, *args)

    def get_object_pixel_size(self):
        r"""get_object_pixel_size(ImageHeader self) -> float"""
        return _IMP_em.ImageHeader_get_object_pixel_size(self)

    def set_object_pixel_size(self, value):
        r"""set_object_pixel_size(ImageHeader self, float value)"""
        return _IMP_em.ImageHeader_set_object_pixel_size(self, value)

    def get_fLabbyt(self):
        r"""get_fLabbyt(ImageHeader self) -> float"""
        return _IMP_em.ImageHeader_get_fLabbyt(self)

    def set_fLabbyt(self, value):
        r"""set_fLabbyt(ImageHeader self, float value)"""
        return _IMP_em.ImageHeader_set_fLabbyt(self, value)

    def get_fLenbyt(self):
        r"""get_fLenbyt(ImageHeader self) -> float"""
        return _IMP_em.ImageHeader_get_fLenbyt(self)

    def set_fLenbyt(self, value):
        r"""set_fLenbyt(ImageHeader self, float value)"""
        return _IMP_em.ImageHeader_set_fLenbyt(self, value)

    def get_fGeo_matrix(self, i, j):
        r"""get_fGeo_matrix(ImageHeader self, unsigned int i, unsigned int j) -> double"""
        return _IMP_em.ImageHeader_get_fGeo_matrix(self, i, j)

    def get_fFlag(self):
        r"""get_fFlag(ImageHeader self) -> float"""
        return _IMP_em.ImageHeader_get_fFlag(self)

    def set_fFlag(self, value):
        r"""set_fFlag(ImageHeader self, float value)"""
        return _IMP_em.ImageHeader_set_fFlag(self, value)

    def get_euler_angles(self):
        r"""get_euler_angles(ImageHeader self) -> Vector3D"""
        return _IMP_em.ImageHeader_get_euler_angles(self)

    def get_euler_angles1(self):
        r"""get_euler_angles1(ImageHeader self) -> Vector3D"""
        return _IMP_em.ImageHeader_get_euler_angles1(self)

    def get_euler_angles2(self):
        r"""get_euler_angles2(ImageHeader self) -> Vector3D"""
        return _IMP_em.ImageHeader_get_euler_angles2(self)

    def set_euler_angles(self, euler):
        r"""set_euler_angles(ImageHeader self, Vector3D euler)"""
        return _IMP_em.ImageHeader_set_euler_angles(self, euler)

    def set_euler_angles1(self, euler):
        r"""set_euler_angles1(ImageHeader self, Vector3D euler)"""
        return _IMP_em.ImageHeader_set_euler_angles1(self, euler)

    def set_euler_angles2(self, euler):
        r"""set_euler_angles2(ImageHeader self, Vector3D euler)"""
        return _IMP_em.ImageHeader_set_euler_angles2(self, euler)

    def is_normalized(self):
        r"""is_normalized(ImageHeader self) -> bool"""
        return _IMP_em.ImageHeader_is_normalized(self)

    def set_date(self):
        r"""set_date(ImageHeader self)"""
        return _IMP_em.ImageHeader_set_date(self)

    def set_time(self):
        r"""set_time(ImageHeader self)"""
        return _IMP_em.ImageHeader_set_time(self)

    def set_title(self, newName):
        r"""set_title(ImageHeader self, IMP::String newName)"""
        return _IMP_em.ImageHeader_set_title(self, newName)
    __swig_destroy__ = _IMP_em.delete_ImageHeader

# Register ImageHeader in _IMP_em:
_IMP_em.ImageHeader_swigregister(ImageHeader)

class SpiderMapReaderWriter(MapReaderWriter):
    r"""Proxy of C++ IMP::em::SpiderMapReaderWriter class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    filename_ = property(_IMP_em.SpiderMapReaderWriter_filename__get, _IMP_em.SpiderMapReaderWriter_filename__set, doc=r"""filename_ : IMP::String""")
    skip_type_check_ = property(_IMP_em.SpiderMapReaderWriter_skip_type_check__get, _IMP_em.SpiderMapReaderWriter_skip_type_check__set, doc=r"""skip_type_check_ : bool""")
    force_reversed_ = property(_IMP_em.SpiderMapReaderWriter_force_reversed__get, _IMP_em.SpiderMapReaderWriter_force_reversed__set, doc=r"""force_reversed_ : bool""")
    skip_extra_checkings_ = property(_IMP_em.SpiderMapReaderWriter_skip_extra_checkings__get, _IMP_em.SpiderMapReaderWriter_skip_extra_checkings__set, doc=r"""skip_extra_checkings_ : bool""")

    def __init__(self, *args):
        r"""
        __init__(SpiderMapReaderWriter self) -> SpiderMapReaderWriter
        __init__(SpiderMapReaderWriter self, IMP::String filename, bool skip_type_check, bool force_reversed, bool skip_extra_checkings) -> SpiderMapReaderWriter
        """
        _IMP_em.SpiderMapReaderWriter_swiginit(self, _IMP_em.new_SpiderMapReaderWriter(*args))

    def __str__(self):
        r"""__str__(SpiderMapReaderWriter self) -> std::string"""
        return _IMP_em.SpiderMapReaderWriter___str__(self)

    def __repr__(self):
        r"""__repr__(SpiderMapReaderWriter self) -> std::string"""
        return _IMP_em.SpiderMapReaderWriter___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_SpiderMapReaderWriter(o)


# Register SpiderMapReaderWriter in _IMP_em:
_IMP_em.SpiderMapReaderWriter_swigregister(SpiderMapReaderWriter)

class FittingSolutions(object):
    r"""Proxy of C++ IMP::em::FittingSolutions class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self):
        r"""__init__(FittingSolutions self) -> FittingSolutions"""
        _IMP_em.FittingSolutions_swiginit(self, _IMP_em.new_FittingSolutions())

    def get_number_of_solutions(self):
        r"""get_number_of_solutions(FittingSolutions self) -> int"""
        return _IMP_em.FittingSolutions_get_number_of_solutions(self)

    def get_transformation(self, i):
        r"""get_transformation(FittingSolutions self, unsigned int i) -> Transformation3D"""
        return _IMP_em.FittingSolutions_get_transformation(self, i)

    def get_score(self, i):
        r"""get_score(FittingSolutions self, unsigned int i) -> IMP::Float"""
        return _IMP_em.FittingSolutions_get_score(self, i)

    def set_score(self, i, score):
        r"""set_score(FittingSolutions self, unsigned int i, IMP::Float score)"""
        return _IMP_em.FittingSolutions_set_score(self, i, score)

    def add_solution(self, t, score):
        r"""add_solution(FittingSolutions self, Transformation3D t, IMP::Float score)"""
        return _IMP_em.FittingSolutions_add_solution(self, t, score)

    def sort(self, reverse=False):
        r"""sort(FittingSolutions self, bool reverse=False)"""
        return _IMP_em.FittingSolutions_sort(self, reverse)

    def multiply(self, t):
        r"""multiply(FittingSolutions self, Transformation3D t)"""
        return _IMP_em.FittingSolutions_multiply(self, t)

    def get_transformations(self):
        r"""get_transformations(FittingSolutions self) -> IMP::algebra::Transformation3Ds"""
        return _IMP_em.FittingSolutions_get_transformations(self)

    def show(self, *args):
        r"""show(FittingSolutions self, _ostream out=std::cout)"""
        return _IMP_em.FittingSolutions_show(self, *args)

    def __str__(self):
        r"""__str__(FittingSolutions self) -> std::string"""
        return _IMP_em.FittingSolutions___str__(self)

    def __repr__(self):
        r"""__repr__(FittingSolutions self) -> std::string"""
        return _IMP_em.FittingSolutions___repr__(self)
    __swig_destroy__ = _IMP_em.delete_FittingSolutions

# Register FittingSolutions in _IMP_em:
_IMP_em.FittingSolutions_swigregister(FittingSolutions)


def local_rigid_fitting_around_point(p, refiner, weight_key, dmap, anchor_centroid, display_log, number_of_optimization_runs=5, number_of_mc_steps=10, number_of_cg_steps=100, max_translation=2., max_rotation=.3, fast=False):
    r"""local_rigid_fitting_around_point(Particle p, Refiner refiner, FloatKey weight_key, DensityMap dmap, Vector3D anchor_centroid, IMP::OptimizerStates display_log, IMP::Int number_of_optimization_runs=5, IMP::Int number_of_mc_steps=10, IMP::Int number_of_cg_steps=100, IMP::Float max_translation=2., IMP::Float max_rotation=.3, bool fast=False) -> FittingSolutions"""
    return _IMP_em.local_rigid_fitting_around_point(p, refiner, weight_key, dmap, anchor_centroid, display_log, number_of_optimization_runs, number_of_mc_steps, number_of_cg_steps, max_translation, max_rotation, fast)

def local_rigid_fitting(p, refiner, weight_key, dmap, display_log, number_of_optimization_runs=5, number_of_mc_steps=10, number_of_cg_steps=100, max_translation=2., max_rotation=.3, fast=True):
    r"""local_rigid_fitting(Particle p, Refiner refiner, FloatKey weight_key, DensityMap dmap, IMP::OptimizerStates display_log, IMP::Int number_of_optimization_runs=5, IMP::Int number_of_mc_steps=10, IMP::Int number_of_cg_steps=100, IMP::Float max_translation=2., IMP::Float max_rotation=.3, bool fast=True) -> FittingSolutions"""
    return _IMP_em.local_rigid_fitting(p, refiner, weight_key, dmap, display_log, number_of_optimization_runs, number_of_mc_steps, number_of_cg_steps, max_translation, max_rotation, fast)

def local_rigid_fitting_around_points(p, refiner, wei_key, dmap, anchor_centroids, display_log, number_of_optimization_runs=5, number_of_mc_steps=10, number_of_cg_steps=100, max_translation=2., max_rotation=.3):
    r"""local_rigid_fitting_around_points(Particle p, Refiner refiner, FloatKey wei_key, DensityMap dmap, IMP::algebra::Vector3Ds const & anchor_centroids, IMP::OptimizerStates display_log, IMP::Int number_of_optimization_runs=5, IMP::Int number_of_mc_steps=10, IMP::Int number_of_cg_steps=100, IMP::Float max_translation=2., IMP::Float max_rotation=.3) -> FittingSolutions"""
    return _IMP_em.local_rigid_fitting_around_points(p, refiner, wei_key, dmap, anchor_centroids, display_log, number_of_optimization_runs, number_of_mc_steps, number_of_cg_steps, max_translation, max_rotation)

def local_rigid_fitting_grid_search(ps, wei_key, dmap, max_voxels_translation=2, translation_step=1, max_angle_in_radians=0.174, number_of_rotations=100):
    r"""local_rigid_fitting_grid_search(IMP::ParticlesTemp const & ps, FloatKey wei_key, DensityMap dmap, IMP::Int max_voxels_translation=2, IMP::Int translation_step=1, IMP::Float max_angle_in_radians=0.174, IMP::Int number_of_rotations=100) -> FittingSolutions"""
    return _IMP_em.local_rigid_fitting_grid_search(ps, wei_key, dmap, max_voxels_translation, translation_step, max_angle_in_radians, number_of_rotations)

def compute_fitting_scores(*args):
    r"""
    compute_fitting_scores(IMP::ParticlesTemp const & ps, DensityMap em_map, IMP::algebra::Transformation3Ds const & transformations, bool fast_version=False, bool local_score=False, FloatKey wei_key=IMP::atom::Mass::get_mass_key()) -> FittingSolutions
    compute_fitting_scores(DensityMap em_map, RigidBody rb, Refiner refiner, IMP::algebra::Transformation3Ds const & transformations) -> FittingSolutions
    """
    return _IMP_em.compute_fitting_scores(*args)

def compute_fitting_score(*args):
    r"""compute_fitting_score(IMP::ParticlesTemp const & ps, DensityMap em_map, FloatKey wei_key=IMP::atom::Mass::get_mass_key()) -> IMP::Float"""
    return _IMP_em.compute_fitting_score(*args)

def get_number_of_particles_outside_of_the_density(*args):
    r"""get_number_of_particles_outside_of_the_density(DensityMap dmap, IMP::Particles const & ps, Transformation3D t=IMP::algebra::get_identity_transformation_3d(), float thr=0.0) -> long"""
    return _IMP_em.get_number_of_particles_outside_of_the_density(*args)

def get_numbers_of_particles_outside_of_the_density(dmap, ps, transformations, thr=0.0):
    r"""get_numbers_of_particles_outside_of_the_density(DensityMap dmap, IMP::Particles const & ps, IMP::algebra::Transformation3Ds const & transformations, float thr=0.0) -> IMP::Ints"""
    return _IMP_em.get_numbers_of_particles_outside_of_the_density(dmap, ps, transformations, thr)

def get_percentage_of_voxels_covered_by_particles(*args):
    r"""get_percentage_of_voxels_covered_by_particles(DensityMap dmap, IMP::Particles const & ps, float smoothing_radius=3., Transformation3D t=IMP::algebra::get_identity_transformation_3d(), float thr=0.0) -> double"""
    return _IMP_em.get_percentage_of_voxels_covered_by_particles(*args)
class HighDensityEmbedding(IMP.statistics.Embedding):
    r"""Proxy of C++ IMP::em::HighDensityEmbedding class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, dm, threshold):
        r"""__init__(HighDensityEmbedding self, DensityMap dm, double threshold) -> HighDensityEmbedding"""
        _IMP_em.HighDensityEmbedding_swiginit(self, _IMP_em.new_HighDensityEmbedding(dm, threshold))

    def get_version_info(self):
        r"""get_version_info(HighDensityEmbedding self) -> VersionInfo"""
        return _IMP_em.HighDensityEmbedding_get_version_info(self)

    def __str__(self):
        r"""__str__(HighDensityEmbedding self) -> std::string"""
        return _IMP_em.HighDensityEmbedding___str__(self)

    def __repr__(self):
        r"""__repr__(HighDensityEmbedding self) -> std::string"""
        return _IMP_em.HighDensityEmbedding___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_HighDensityEmbedding(o)


# Register HighDensityEmbedding in _IMP_em:
_IMP_em.HighDensityEmbedding_swigregister(HighDensityEmbedding)


def mask_and_norm(dmap, mask):
    r"""mask_and_norm(DensityMap dmap, DensityMap mask) -> DensityMap"""
    return _IMP_em.mask_and_norm(dmap, mask)

def get_volume_at_threshold(m, threshold):
    r"""get_volume_at_threshold(DensityMap m, IMP::Float threshold) -> IMP::Float"""
    return _IMP_em.get_volume_at_threshold(m, threshold)

def get_molecular_mass_at_threshold(*args):
    r"""get_molecular_mass_at_threshold(DensityMap m, IMP::Float threshold, IMP::atom::ProteinDensityReference ref=HARPAZ) -> IMP::Float"""
    return _IMP_em.get_molecular_mass_at_threshold(*args)

def get_threshold_for_approximate_volume(m, desired_volume):
    r"""get_threshold_for_approximate_volume(DensityMap m, IMP::Float desired_volume) -> IMP::Float"""
    return _IMP_em.get_threshold_for_approximate_volume(m, desired_volume)

def get_threshold_for_approximate_mass(*args):
    r"""get_threshold_for_approximate_mass(DensityMap m, IMP::Float desired_mass, IMP::atom::ProteinDensityReference ref=HARPAZ) -> IMP::Float"""
    return _IMP_em.get_threshold_for_approximate_mass(*args)
class EnvelopePenetrationRestraint(IMP.Restraint):
    r"""Proxy of C++ IMP::em::EnvelopePenetrationRestraint class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, ps, em_map, threshold):
        r"""__init__(EnvelopePenetrationRestraint self, IMP::Particles ps, DensityMap em_map, IMP::Float threshold) -> EnvelopePenetrationRestraint"""
        _IMP_em.EnvelopePenetrationRestraint_swiginit(self, _IMP_em.new_EnvelopePenetrationRestraint(ps, em_map, threshold))

    def do_get_inputs(self):
        r"""do_get_inputs(EnvelopePenetrationRestraint self) -> IMP::ModelObjectsTemp"""
        return _IMP_em.EnvelopePenetrationRestraint_do_get_inputs(self)

    def get_version_info(self):
        r"""get_version_info(EnvelopePenetrationRestraint self) -> VersionInfo"""
        return _IMP_em.EnvelopePenetrationRestraint_get_version_info(self)

    def __str__(self):
        r"""__str__(EnvelopePenetrationRestraint self) -> std::string"""
        return _IMP_em.EnvelopePenetrationRestraint___str__(self)

    def __repr__(self):
        r"""__repr__(EnvelopePenetrationRestraint self) -> std::string"""
        return _IMP_em.EnvelopePenetrationRestraint___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_EnvelopePenetrationRestraint(o)


# Register EnvelopePenetrationRestraint in _IMP_em:
_IMP_em.EnvelopePenetrationRestraint_swigregister(EnvelopePenetrationRestraint)

class PCAFitRestraint(IMP.Restraint):
    r"""Proxy of C++ IMP::em::PCAFitRestraint class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""__init__(PCAFitRestraint self, IMP::ParticlesTemp ps, DensityMap em_map, float threshold, float max_pca_size_diff, float max_angle_diff, float max_centroid_diff, FloatKey weight_key=IMP::atom::Mass::get_mass_key()) -> PCAFitRestraint"""
        _IMP_em.PCAFitRestraint_swiginit(self, _IMP_em.new_PCAFitRestraint(*args))

    def do_get_inputs(self):
        r"""do_get_inputs(PCAFitRestraint self) -> IMP::ModelObjectsTemp"""
        return _IMP_em.PCAFitRestraint_do_get_inputs(self)

    def get_version_info(self):
        r"""get_version_info(PCAFitRestraint self) -> VersionInfo"""
        return _IMP_em.PCAFitRestraint_get_version_info(self)

    def __str__(self):
        r"""__str__(PCAFitRestraint self) -> std::string"""
        return _IMP_em.PCAFitRestraint___str__(self)

    def __repr__(self):
        r"""__repr__(PCAFitRestraint self) -> std::string"""
        return _IMP_em.PCAFitRestraint___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_PCAFitRestraint(o)


# Register PCAFitRestraint in _IMP_em:
_IMP_em.PCAFitRestraint_swigregister(PCAFitRestraint)

class EnvelopeFitRestraint(IMP.Restraint):
    r"""Proxy of C++ IMP::em::EnvelopeFitRestraint class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, particles, em_map, density_threshold, penetration_threshold):
        r"""__init__(EnvelopeFitRestraint self, IMP::Particles particles, DensityMap em_map, double density_threshold, double penetration_threshold) -> EnvelopeFitRestraint"""
        _IMP_em.EnvelopeFitRestraint_swiginit(self, _IMP_em.new_EnvelopeFitRestraint(particles, em_map, density_threshold, penetration_threshold))

    def get_transformation(self):
        r"""get_transformation(EnvelopeFitRestraint self) -> Transformation3D"""
        return _IMP_em.EnvelopeFitRestraint_get_transformation(self)

    def apply_transformation(self):
        r"""apply_transformation(EnvelopeFitRestraint self)"""
        return _IMP_em.EnvelopeFitRestraint_apply_transformation(self)

    def do_get_inputs(self):
        r"""do_get_inputs(EnvelopeFitRestraint self) -> IMP::ModelObjectsTemp"""
        return _IMP_em.EnvelopeFitRestraint_do_get_inputs(self)

    def get_version_info(self):
        r"""get_version_info(EnvelopeFitRestraint self) -> VersionInfo"""
        return _IMP_em.EnvelopeFitRestraint_get_version_info(self)

    def __str__(self):
        r"""__str__(EnvelopeFitRestraint self) -> std::string"""
        return _IMP_em.EnvelopeFitRestraint___str__(self)

    def __repr__(self):
        r"""__repr__(EnvelopeFitRestraint self) -> std::string"""
        return _IMP_em.EnvelopeFitRestraint___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_EnvelopeFitRestraint(o)


# Register EnvelopeFitRestraint in _IMP_em:
_IMP_em.EnvelopeFitRestraint_swigregister(EnvelopeFitRestraint)

class MapDistanceTransform(DensityMap):
    r"""Proxy of C++ IMP::em::MapDistanceTransform class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, map, density_threshold, max_distance):
        r"""__init__(MapDistanceTransform self, DensityMap map, float density_threshold, float max_distance) -> MapDistanceTransform"""
        _IMP_em.MapDistanceTransform_swiginit(self, _IMP_em.new_MapDistanceTransform(map, density_threshold, max_distance))

    def get_distance_from_envelope(self, v):
        r"""get_distance_from_envelope(MapDistanceTransform self, Vector3D v) -> float"""
        return _IMP_em.MapDistanceTransform_get_distance_from_envelope(self, v)

    def __str__(self):
        r"""__str__(MapDistanceTransform self) -> std::string"""
        return _IMP_em.MapDistanceTransform___str__(self)

    def __repr__(self):
        r"""__repr__(MapDistanceTransform self) -> std::string"""
        return _IMP_em.MapDistanceTransform___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_MapDistanceTransform(o)

    __swig_destroy__ = _IMP_em.delete_MapDistanceTransform

# Register MapDistanceTransform in _IMP_em:
_IMP_em.MapDistanceTransform_swigregister(MapDistanceTransform)

class EnvelopeScore(IMP.Object):
    r"""Proxy of C++ IMP::em::EnvelopeScore class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, mdt):
        r"""__init__(EnvelopeScore self, MapDistanceTransform mdt) -> EnvelopeScore"""
        _IMP_em.EnvelopeScore_swiginit(self, _IMP_em.new_EnvelopeScore(mdt))

    def is_penetrating(self, *args):
        r"""
        is_penetrating(EnvelopeScore self, IMP::algebra::Vector3Ds const & points, float penetration_thr) -> bool
        is_penetrating(EnvelopeScore self, IMP::algebra::Vector3Ds const & points, Transformation3D trans, float penetration_thr) -> bool
        """
        return _IMP_em.EnvelopeScore_is_penetrating(self, *args)

    def score(self, *args):
        r"""
        score(EnvelopeScore self, IMP::algebra::Vector3Ds const & points) -> double
        score(EnvelopeScore self, IMP::algebra::Vector3Ds const & points, Transformation3D trans) -> double
        """
        return _IMP_em.EnvelopeScore_score(self, *args)
    __swig_destroy__ = _IMP_em.delete_EnvelopeScore

    def __str__(self):
        r"""__str__(EnvelopeScore self) -> std::string"""
        return _IMP_em.EnvelopeScore___str__(self)

    def __repr__(self):
        r"""__repr__(EnvelopeScore self) -> std::string"""
        return _IMP_em.EnvelopeScore___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_EnvelopeScore(o)


# Register EnvelopeScore in _IMP_em:
_IMP_em.EnvelopeScore_swigregister(EnvelopeScore)


import math

def write_pca_cmm(pca, fh):
    """Write out principal components to a file in Chimera Marker format"""
    eigen_values = pca.get_principal_values()
    eigen_vecs = pca.get_principal_components()
    centroid = pca.get_centroid()

    fh.write("<marker_set>\n")
    fh.write("<!-- PCA with eigen values: (%g,%g,%g) and "
                 "centroid (%g,%g,%g) -->\n"
          % (math.sqrt(eigen_values[0]),
             math.sqrt(eigen_values[1]),
             math.sqrt(eigen_values[2]),
             centroid[0], centroid[1], centroid[2]))

    radius = 2.

    for i in range(3):
        val = math.sqrt(eigen_values[i])
        v1 = centroid - val * eigen_vecs[i]
        v2 = centroid + val * eigen_vecs[i]
        for markerid, v in ((i*2+1, v1), (i*2+2, v2)):
            fh.write("<marker id=\"%d\" x=\"%g\" y=\"%g\" z=\"%g\" "
                         "radius=\"%g\"/>\n"
                  % (markerid, v[0], v[1], v[2], radius))

    for i in range(1, 7, 2):
        fh.write("<link id1= \"%d\" id2=\"%d\" radius=\"%g\"/>\n"
              % (i, i+1, radius))
    fh.write("</marker_set>\n")


def get_module_version():
    r"""get_module_version() -> std::string const"""
    return _IMP_em.get_module_version()

def get_example_path(fname):
    r"""get_example_path(std::string fname) -> std::string"""
    return _IMP_em.get_example_path(fname)

def get_data_path(fname):
    r"""get_data_path(std::string fname) -> std::string"""
    return _IMP_em.get_data_path(fname)

from . import _version_check
_version_check.check_version(get_module_version())
__version__ = get_module_version()



