%import "RMF.i"
%{
#include "RMF.h"
%}

IMP_SWIG_OBJECT(IMP::multifit, RadiusOfGyrationRestraint,
                RadiusOfGyrationRestraints);
IMP_SWIG_OBJECT(IMP::multifit, ComponentHeader, ComponentHeaders);
IMP_SWIG_OBJECT(IMP::multifit, AssemblyHeader, AssemblyHeaders);
IMP_SWIG_OBJECT(IMP::multifit, SettingsData, SettingsDataList);
IMP_SWIG_OBJECT(IMP::multifit, WeightedExcludedVolumeRestraint, WeightedExcludedVolumeRestraints);
IMP_SWIG_OBJECT(IMP::multifit, ComplementarityRestraint, ComplementarityRestraints);
IMP_SWIG_VALUE(IMP::multifit, ProteinRecordData, ProteinRecordDataList);
IMP_SWIG_VALUE(IMP::multifit, FittingSolutionRecord, FittingSolutionRecords);
IMP_SWIG_VALUE(IMP::multifit, AnchorsData, AnchorsDataList);
IMP_SWIG_VALUE(IMP::multifit, DominoParams, DominoParamsList);
IMP_SWIG_VALUE(IMP::multifit, ComplementarityParams, ComplementarityParamsList);
IMP_SWIG_VALUE(IMP::multifit, XlinkParams, XlinkParamsList);
IMP_SWIG_VALUE(IMP::multifit, ConnectivityParams, ConnectivityParamsList);
IMP_SWIG_VALUE(IMP::multifit, FragmentsParams, FragmentsParamsList);
IMP_SWIG_VALUE(IMP::multifit, RogParams, RogParamsList);
IMP_SWIG_VALUE(IMP::multifit, EVParams, EVParamsList);
IMP_SWIG_VALUE(IMP::multifit, FiltersParams, FiltersParamsList);
IMP_SWIG_VALUE(IMP::multifit, AlignmentParams, AlignmentParamsList);
IMP_SWIG_VALUE(IMP::multifit, FittingParams, FittingParamsList);
IMP_SWIG_VALUE(IMP::multifit, ProteinsAnchorsSamplingSpace, ProteinsAnchorsSamplingSpaces);
IMP_SWIG_OBJECT(IMP::multifit, ProteomicsData, ProteomicsDataList);
IMP_SWIG_OBJECT(IMP::multifit, FFTFitting, FFTFittings);
IMP_SWIG_OBJECT(IMP::multifit, FFTFittingOutput, FFTFittingOutputs);
IMP_SWIG_OBJECT(IMP::multifit, ProbabilisticAnchorGraph, ProbabilisticAnchorGraphs)
IMP_SWIG_OBJECT(IMP::multifit, Ensemble, Ensembles);
IMP_SWIG_OBJECT(IMP::multifit, ProteomicsEMAlignmentAtomic, ProteomicsEMAlignmentAtomics);
IMP_SWIG_OBJECT(IMP::multifit, RigidLeavesRefiner, RigidLeavesRefiners);

/* Wrap our own classes */
%include "IMP/multifit/weighted_excluded_volume.h"
%include "IMP/multifit/FittingSolutionRecord.h"
%include "IMP/multifit/pca_based_rigid_fitting.h"
%include "IMP/multifit/SettingsData.h"
%include "IMP/multifit/WeightedExcludedVolumeRestraint.h"
%include "IMP/multifit/fft_based_rigid_fitting.h"
%include "IMP/multifit/density_analysis.h"
%include "IMP/multifit/ComplementarityRestraint.h"
%include "IMP/multifit/fitting_solutions_reader_writer.h"
%include "IMP/multifit/fitting_tools.h"
%include "IMP/multifit/anchor_graph.h"
%include "IMP/multifit/proteomics_reader.h"
%include "IMP/multifit/anchors_reader.h"
%include "IMP/multifit/coarse_molecule.h"
%include "IMP/multifit/fitting_utils.h"
%include "IMP/multifit/RadiusOfGyrationRestraint.h"
%include "IMP/multifit/protein_anchors_mapping_reader.h"
%include "IMP/multifit/path_reader_writer.h"
%include "IMP/multifit/anchor_utilities.h"
%include "IMP/multifit/AlignmentParams.h"
%include "IMP/multifit/proteomics_em_alignment_atomic.h"
%include "IMP/multifit/connolly_surface.h"
%include "IMP/multifit/ensemble_analysis.h"
%include "IMP/multifit/RigidLeavesRefiner.h"

/* All scripts that can be called from the multifit application */
%pythoncode %{
_all_commands = ["param", "anchors", "fit_fft", "cluster", "add_fit_rmsd",
                 "indexes", "proteomics", "align", "models", "transforms",
                 "score", "merge_tree", "reference", "refine_fft", "segment"]
%}
