# This file was automatically generated by SWIG (http://www.swig.org).
# Version 4.0.2
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

# This wrapper is part of IMP,
# Copyright 2007-2021 IMP Inventors. All rights reserved.

from __future__ import print_function, division, absolute_import
from sys import version_info as _swig_python_version_info
if _swig_python_version_info < (2, 7, 0):
    raise RuntimeError("Python 2.7 or later required")

import _IMP_example

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "thisown":
            self.this.own(value)
        elif name == "this":
            set(self, name, value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


import weakref

class IMP_EXAMPLE_SwigPyIterator(object):
    r"""Proxy of C++ swig::IMP_EXAMPLE_SwigPyIterator class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _IMP_example.delete_IMP_EXAMPLE_SwigPyIterator

    def value(self):
        r"""value(IMP_EXAMPLE_SwigPyIterator self) -> PyObject *"""
        return _IMP_example.IMP_EXAMPLE_SwigPyIterator_value(self)

    def incr(self, n=1):
        r"""incr(IMP_EXAMPLE_SwigPyIterator self, size_t n=1) -> IMP_EXAMPLE_SwigPyIterator"""
        return _IMP_example.IMP_EXAMPLE_SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        r"""decr(IMP_EXAMPLE_SwigPyIterator self, size_t n=1) -> IMP_EXAMPLE_SwigPyIterator"""
        return _IMP_example.IMP_EXAMPLE_SwigPyIterator_decr(self, n)

    def distance(self, x):
        r"""distance(IMP_EXAMPLE_SwigPyIterator self, IMP_EXAMPLE_SwigPyIterator x) -> ptrdiff_t"""
        return _IMP_example.IMP_EXAMPLE_SwigPyIterator_distance(self, x)

    def equal(self, x):
        r"""equal(IMP_EXAMPLE_SwigPyIterator self, IMP_EXAMPLE_SwigPyIterator x) -> bool"""
        return _IMP_example.IMP_EXAMPLE_SwigPyIterator_equal(self, x)

    def copy(self):
        r"""copy(IMP_EXAMPLE_SwigPyIterator self) -> IMP_EXAMPLE_SwigPyIterator"""
        return _IMP_example.IMP_EXAMPLE_SwigPyIterator_copy(self)

    def next(self):
        r"""next(IMP_EXAMPLE_SwigPyIterator self) -> PyObject *"""
        return _IMP_example.IMP_EXAMPLE_SwigPyIterator_next(self)

    def __next__(self):
        r"""__next__(IMP_EXAMPLE_SwigPyIterator self) -> PyObject *"""
        return _IMP_example.IMP_EXAMPLE_SwigPyIterator___next__(self)

    def previous(self):
        r"""previous(IMP_EXAMPLE_SwigPyIterator self) -> PyObject *"""
        return _IMP_example.IMP_EXAMPLE_SwigPyIterator_previous(self)

    def advance(self, n):
        r"""advance(IMP_EXAMPLE_SwigPyIterator self, ptrdiff_t n) -> IMP_EXAMPLE_SwigPyIterator"""
        return _IMP_example.IMP_EXAMPLE_SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        r"""__eq__(IMP_EXAMPLE_SwigPyIterator self, IMP_EXAMPLE_SwigPyIterator x) -> bool"""
        return _IMP_example.IMP_EXAMPLE_SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        r"""__ne__(IMP_EXAMPLE_SwigPyIterator self, IMP_EXAMPLE_SwigPyIterator x) -> bool"""
        return _IMP_example.IMP_EXAMPLE_SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        r"""__iadd__(IMP_EXAMPLE_SwigPyIterator self, ptrdiff_t n) -> IMP_EXAMPLE_SwigPyIterator"""
        return _IMP_example.IMP_EXAMPLE_SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        r"""__isub__(IMP_EXAMPLE_SwigPyIterator self, ptrdiff_t n) -> IMP_EXAMPLE_SwigPyIterator"""
        return _IMP_example.IMP_EXAMPLE_SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        r"""__add__(IMP_EXAMPLE_SwigPyIterator self, ptrdiff_t n) -> IMP_EXAMPLE_SwigPyIterator"""
        return _IMP_example.IMP_EXAMPLE_SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        r"""
        __sub__(IMP_EXAMPLE_SwigPyIterator self, ptrdiff_t n) -> IMP_EXAMPLE_SwigPyIterator
        __sub__(IMP_EXAMPLE_SwigPyIterator self, IMP_EXAMPLE_SwigPyIterator x) -> ptrdiff_t
        """
        return _IMP_example.IMP_EXAMPLE_SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register IMP_EXAMPLE_SwigPyIterator in _IMP_example:
_IMP_example.IMP_EXAMPLE_SwigPyIterator_swigregister(IMP_EXAMPLE_SwigPyIterator)


_value_types=[]
_object_types=[]
_raii_types=[]
_plural_types=[]

IMP_DEBUG = _IMP_example.IMP_DEBUG

IMP_RELEASE = _IMP_example.IMP_RELEASE

IMP_SILENT = _IMP_example.IMP_SILENT

IMP_PROGRESS = _IMP_example.IMP_PROGRESS

IMP_TERSE = _IMP_example.IMP_TERSE

IMP_VERBOSE = _IMP_example.IMP_VERBOSE

IMP_MEMORY = _IMP_example.IMP_MEMORY

IMP_NONE = _IMP_example.IMP_NONE

IMP_USAGE = _IMP_example.IMP_USAGE

IMP_INTERNAL = _IMP_example.IMP_INTERNAL

IMP_KERNEL_HAS_LOG4CXX = _IMP_example.IMP_KERNEL_HAS_LOG4CXX

IMP_COMPILER_HAS_AUTO = _IMP_example.IMP_COMPILER_HAS_AUTO

IMP_COMPILER_HAS_DEBUG_VECTOR = _IMP_example.IMP_COMPILER_HAS_DEBUG_VECTOR

IMP_COMPILER_HAS_UNIQUE_PTR = _IMP_example.IMP_COMPILER_HAS_UNIQUE_PTR

IMP_KERNEL_HAS_BOOST_RANDOM = _IMP_example.IMP_KERNEL_HAS_BOOST_RANDOM

IMP_KERNEL_HAS_NUMPY = _IMP_example.IMP_KERNEL_HAS_NUMPY

IMP_KERNEL_HAS_GPERFTOOLS = _IMP_example.IMP_KERNEL_HAS_GPERFTOOLS

IMP_KERNEL_HAS_TCMALLOC_HEAPCHECKER = _IMP_example.IMP_KERNEL_HAS_TCMALLOC_HEAPCHECKER

IMP_KERNEL_HAS_TCMALLOC_HEAPPROFILER = _IMP_example.IMP_KERNEL_HAS_TCMALLOC_HEAPPROFILER

IMPKERNEL_SHOW_WARNINGS = _IMP_example.IMPKERNEL_SHOW_WARNINGS


import sys
class _DirectorObjects(object):
    """@internal Simple class to keep references to director objects
       to prevent premature deletion."""
    def __init__(self):
        self._objects = []
    def register(self, obj):
        """Take a reference to a director object; will only work for
           refcounted C++ classes"""
        if hasattr(obj, 'get_ref_count'):
            self._objects.append(obj)
    def cleanup(self):
        """Only drop our reference and allow cleanup by Python if no other
           Python references exist (we hold 3 references: one in self._objects,
           one in x, and one in the argument list for getrefcount) *and* no
           other C++ references exist (the Python object always holds one)"""
        objs = [x for x in self._objects if sys.getrefcount(x) > 3 \
                                         or x.get_ref_count() > 1]
# Do in two steps so the references are kept until the end of the
# function (deleting references may trigger a fresh call to this method)
        self._objects = objs
    def get_object_count(self):
        """Get number of director objects (useful for testing only)"""
        return len(self._objects)
_director_objects = _DirectorObjects()

class _ostream(object):
    r"""Proxy of C++ std::ostream class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def write(self, osa_buf):
        r"""write(_ostream self, char const * osa_buf)"""
        return _IMP_example._ostream_write(self, osa_buf)

# Register _ostream in _IMP_example:
_IMP_example._ostream_swigregister(_ostream)

IMP_COMPILER_HAS_OVERRIDE = _IMP_example.IMP_COMPILER_HAS_OVERRIDE

IMP_COMPILER_HAS_FINAL = _IMP_example.IMP_COMPILER_HAS_FINAL

IMP_HAS_NOEXCEPT = _IMP_example.IMP_HAS_NOEXCEPT

IMP_C_OPEN_BINARY = _IMP_example.IMP_C_OPEN_BINARY

import IMP
IMP_CGAL_HAS_BOOST_FILESYSTEM = _IMP_example.IMP_CGAL_HAS_BOOST_FILESYSTEM

IMP_CGAL_HAS_BOOST_PROGRAMOPTIONS = _IMP_example.IMP_CGAL_HAS_BOOST_PROGRAMOPTIONS

IMP_CGAL_HAS_BOOST_RANDOM = _IMP_example.IMP_CGAL_HAS_BOOST_RANDOM

IMP_CGAL_HAS_BOOST_SYSTEM = _IMP_example.IMP_CGAL_HAS_BOOST_SYSTEM

IMP_CGAL_HAS_NUMPY = _IMP_example.IMP_CGAL_HAS_NUMPY

IMPCGAL_SHOW_WARNINGS = _IMP_example.IMPCGAL_SHOW_WARNINGS

import IMP.cgal
IMP_ALGEBRA_HAS_IMP_CGAL = _IMP_example.IMP_ALGEBRA_HAS_IMP_CGAL

IMP_ALGEBRA_HAS_BOOST_FILESYSTEM = _IMP_example.IMP_ALGEBRA_HAS_BOOST_FILESYSTEM

IMP_ALGEBRA_HAS_BOOST_PROGRAMOPTIONS = _IMP_example.IMP_ALGEBRA_HAS_BOOST_PROGRAMOPTIONS

IMP_ALGEBRA_HAS_BOOST_RANDOM = _IMP_example.IMP_ALGEBRA_HAS_BOOST_RANDOM

IMP_ALGEBRA_HAS_BOOST_SYSTEM = _IMP_example.IMP_ALGEBRA_HAS_BOOST_SYSTEM

IMP_ALGEBRA_HAS_CGAL = _IMP_example.IMP_ALGEBRA_HAS_CGAL

IMP_ALGEBRA_HAS_NUMPY = _IMP_example.IMP_ALGEBRA_HAS_NUMPY

IMP_ALGEBRA_HAS_ANN = _IMP_example.IMP_ALGEBRA_HAS_ANN

IMPALGEBRA_SHOW_WARNINGS = _IMP_example.IMPALGEBRA_SHOW_WARNINGS

import IMP.algebra
IMP_DISPLAY_HAS_IMP_CGAL = _IMP_example.IMP_DISPLAY_HAS_IMP_CGAL

IMP_DISPLAY_HAS_BOOST_FILESYSTEM = _IMP_example.IMP_DISPLAY_HAS_BOOST_FILESYSTEM

IMP_DISPLAY_HAS_BOOST_PROGRAMOPTIONS = _IMP_example.IMP_DISPLAY_HAS_BOOST_PROGRAMOPTIONS

IMP_DISPLAY_HAS_BOOST_RANDOM = _IMP_example.IMP_DISPLAY_HAS_BOOST_RANDOM

IMP_DISPLAY_HAS_BOOST_SYSTEM = _IMP_example.IMP_DISPLAY_HAS_BOOST_SYSTEM

IMP_DISPLAY_HAS_CGAL = _IMP_example.IMP_DISPLAY_HAS_CGAL

IMP_DISPLAY_HAS_NUMPY = _IMP_example.IMP_DISPLAY_HAS_NUMPY

IMPDISPLAY_SHOW_WARNINGS = _IMP_example.IMPDISPLAY_SHOW_WARNINGS

import IMP.display
IMP_SCORE_FUNCTOR_HAS_IMP_CGAL = _IMP_example.IMP_SCORE_FUNCTOR_HAS_IMP_CGAL

IMP_SCORE_FUNCTOR_HAS_BOOST_FILESYSTEM = _IMP_example.IMP_SCORE_FUNCTOR_HAS_BOOST_FILESYSTEM

IMP_SCORE_FUNCTOR_HAS_BOOST_PROGRAMOPTIONS = _IMP_example.IMP_SCORE_FUNCTOR_HAS_BOOST_PROGRAMOPTIONS

IMP_SCORE_FUNCTOR_HAS_BOOST_RANDOM = _IMP_example.IMP_SCORE_FUNCTOR_HAS_BOOST_RANDOM

IMP_SCORE_FUNCTOR_HAS_BOOST_SYSTEM = _IMP_example.IMP_SCORE_FUNCTOR_HAS_BOOST_SYSTEM

IMP_SCORE_FUNCTOR_HAS_CGAL = _IMP_example.IMP_SCORE_FUNCTOR_HAS_CGAL

IMP_SCORE_FUNCTOR_HAS_HDF5 = _IMP_example.IMP_SCORE_FUNCTOR_HAS_HDF5

IMP_SCORE_FUNCTOR_HAS_NUMPY = _IMP_example.IMP_SCORE_FUNCTOR_HAS_NUMPY

IMPSCOREFUNCTOR_SHOW_WARNINGS = _IMP_example.IMPSCOREFUNCTOR_SHOW_WARNINGS

import IMP.score_functor
IMP_STATISTICS_HAS_IMP_CGAL = _IMP_example.IMP_STATISTICS_HAS_IMP_CGAL

IMP_STATISTICS_HAS_BOOST_FILESYSTEM = _IMP_example.IMP_STATISTICS_HAS_BOOST_FILESYSTEM

IMP_STATISTICS_HAS_BOOST_PROGRAMOPTIONS = _IMP_example.IMP_STATISTICS_HAS_BOOST_PROGRAMOPTIONS

IMP_STATISTICS_HAS_BOOST_RANDOM = _IMP_example.IMP_STATISTICS_HAS_BOOST_RANDOM

IMP_STATISTICS_HAS_BOOST_SYSTEM = _IMP_example.IMP_STATISTICS_HAS_BOOST_SYSTEM

IMP_STATISTICS_HAS_CGAL = _IMP_example.IMP_STATISTICS_HAS_CGAL

IMP_STATISTICS_HAS_NUMPY = _IMP_example.IMP_STATISTICS_HAS_NUMPY

IMPSTATISTICS_SHOW_WARNINGS = _IMP_example.IMPSTATISTICS_SHOW_WARNINGS

import IMP.statistics
IMP_CORE_HAS_IMP_CGAL = _IMP_example.IMP_CORE_HAS_IMP_CGAL

IMP_CORE_HAS_IMP_KERNEL = _IMP_example.IMP_CORE_HAS_IMP_KERNEL

IMP_CORE_HAS_BOOST_FILESYSTEM = _IMP_example.IMP_CORE_HAS_BOOST_FILESYSTEM

IMP_CORE_HAS_BOOST_PROGRAMOPTIONS = _IMP_example.IMP_CORE_HAS_BOOST_PROGRAMOPTIONS

IMP_CORE_HAS_BOOST_RANDOM = _IMP_example.IMP_CORE_HAS_BOOST_RANDOM

IMP_CORE_HAS_BOOST_SYSTEM = _IMP_example.IMP_CORE_HAS_BOOST_SYSTEM

IMP_CORE_HAS_CGAL = _IMP_example.IMP_CORE_HAS_CGAL

IMP_CORE_HAS_HDF5 = _IMP_example.IMP_CORE_HAS_HDF5

IMP_CORE_HAS_NUMPY = _IMP_example.IMP_CORE_HAS_NUMPY

IMPCORE_SHOW_WARNINGS = _IMP_example.IMPCORE_SHOW_WARNINGS

import IMP.core
IMP_CONTAINER_HAS_IMP_ALGEBRA = _IMP_example.IMP_CONTAINER_HAS_IMP_ALGEBRA

IMP_CONTAINER_HAS_IMP_CGAL = _IMP_example.IMP_CONTAINER_HAS_IMP_CGAL

IMP_CONTAINER_HAS_IMP_DISPLAY = _IMP_example.IMP_CONTAINER_HAS_IMP_DISPLAY

IMP_CONTAINER_HAS_IMP_KERNEL = _IMP_example.IMP_CONTAINER_HAS_IMP_KERNEL

IMP_CONTAINER_HAS_IMP_SCORE_FUNCTOR = _IMP_example.IMP_CONTAINER_HAS_IMP_SCORE_FUNCTOR

IMP_CONTAINER_HAS_BOOST_FILESYSTEM = _IMP_example.IMP_CONTAINER_HAS_BOOST_FILESYSTEM

IMP_CONTAINER_HAS_BOOST_PROGRAMOPTIONS = _IMP_example.IMP_CONTAINER_HAS_BOOST_PROGRAMOPTIONS

IMP_CONTAINER_HAS_BOOST_RANDOM = _IMP_example.IMP_CONTAINER_HAS_BOOST_RANDOM

IMP_CONTAINER_HAS_BOOST_SYSTEM = _IMP_example.IMP_CONTAINER_HAS_BOOST_SYSTEM

IMP_CONTAINER_HAS_CGAL = _IMP_example.IMP_CONTAINER_HAS_CGAL

IMP_CONTAINER_HAS_HDF5 = _IMP_example.IMP_CONTAINER_HAS_HDF5

IMP_CONTAINER_HAS_NUMPY = _IMP_example.IMP_CONTAINER_HAS_NUMPY

IMP_CONTAINER_HAS_PYTHON_IHM = _IMP_example.IMP_CONTAINER_HAS_PYTHON_IHM

IMP_CONTAINER_HAS_GOOGLE_DENSE_HASH_MAP = _IMP_example.IMP_CONTAINER_HAS_GOOGLE_DENSE_HASH_MAP

IMP_CONTAINER_HAS_ROBIN_MAP = _IMP_example.IMP_CONTAINER_HAS_ROBIN_MAP

IMPCONTAINER_SHOW_WARNINGS = _IMP_example.IMPCONTAINER_SHOW_WARNINGS

import IMP.container
IMP_ATOM_HAS_IMP_CGAL = _IMP_example.IMP_ATOM_HAS_IMP_CGAL

IMP_ATOM_HAS_IMP_KERNEL = _IMP_example.IMP_ATOM_HAS_IMP_KERNEL

IMP_ATOM_HAS_IMP_SCORE_FUNCTOR = _IMP_example.IMP_ATOM_HAS_IMP_SCORE_FUNCTOR

IMP_ATOM_HAS_BOOST_PROGRAMOPTIONS = _IMP_example.IMP_ATOM_HAS_BOOST_PROGRAMOPTIONS

IMP_ATOM_HAS_BOOST_RANDOM = _IMP_example.IMP_ATOM_HAS_BOOST_RANDOM

IMP_ATOM_HAS_BOOST_REGEX = _IMP_example.IMP_ATOM_HAS_BOOST_REGEX

IMP_ATOM_HAS_BOOST_SYSTEM = _IMP_example.IMP_ATOM_HAS_BOOST_SYSTEM

IMP_ATOM_HAS_CGAL = _IMP_example.IMP_ATOM_HAS_CGAL

IMP_ATOM_HAS_HDF5 = _IMP_example.IMP_ATOM_HAS_HDF5

IMP_ATOM_HAS_NUMPY = _IMP_example.IMP_ATOM_HAS_NUMPY

IMP_ATOM_HAS_PYTHON_IHM = _IMP_example.IMP_ATOM_HAS_PYTHON_IHM

IMPATOM_SHOW_WARNINGS = _IMP_example.IMPATOM_SHOW_WARNINGS

IMP_ATOM_TYPE_INDEX = _IMP_example.IMP_ATOM_TYPE_INDEX

IMP_RESIDUE_TYPE_INDEX = _IMP_example.IMP_RESIDUE_TYPE_INDEX

IMP_HIERARCHY_TYPE_INDEX = _IMP_example.IMP_HIERARCHY_TYPE_INDEX

IMP_CHAIN_TYPE_INDEX = _IMP_example.IMP_CHAIN_TYPE_INDEX

import IMP.atom
IMP_EM_HAS_IMP_CGAL = _IMP_example.IMP_EM_HAS_IMP_CGAL

IMP_EM_HAS_IMP_CONTAINER = _IMP_example.IMP_EM_HAS_IMP_CONTAINER

IMP_EM_HAS_IMP_DISPLAY = _IMP_example.IMP_EM_HAS_IMP_DISPLAY

IMP_EM_HAS_IMP_SCORE_FUNCTOR = _IMP_example.IMP_EM_HAS_IMP_SCORE_FUNCTOR

IMP_EM_HAS_BOOST_FILESYSTEM = _IMP_example.IMP_EM_HAS_BOOST_FILESYSTEM

IMP_EM_HAS_BOOST_PROGRAMOPTIONS = _IMP_example.IMP_EM_HAS_BOOST_PROGRAMOPTIONS

IMP_EM_HAS_BOOST_RANDOM = _IMP_example.IMP_EM_HAS_BOOST_RANDOM

IMP_EM_HAS_BOOST_REGEX = _IMP_example.IMP_EM_HAS_BOOST_REGEX

IMP_EM_HAS_BOOST_SYSTEM = _IMP_example.IMP_EM_HAS_BOOST_SYSTEM

IMP_EM_HAS_CGAL = _IMP_example.IMP_EM_HAS_CGAL

IMP_EM_HAS_HDF5 = _IMP_example.IMP_EM_HAS_HDF5

IMP_EM_HAS_NUMPY = _IMP_example.IMP_EM_HAS_NUMPY

IMP_EM_HAS_PYTHON_IHM = _IMP_example.IMP_EM_HAS_PYTHON_IHM

IMPEM_SHOW_WARNINGS = _IMP_example.IMPEM_SHOW_WARNINGS

import IMP.em
IMP_SAXS_HAS_IMP_CGAL = _IMP_example.IMP_SAXS_HAS_IMP_CGAL

IMP_SAXS_HAS_IMP_CONTAINER = _IMP_example.IMP_SAXS_HAS_IMP_CONTAINER

IMP_SAXS_HAS_IMP_DISPLAY = _IMP_example.IMP_SAXS_HAS_IMP_DISPLAY

IMP_SAXS_HAS_IMP_KERNEL = _IMP_example.IMP_SAXS_HAS_IMP_KERNEL

IMP_SAXS_HAS_IMP_SCORE_FUNCTOR = _IMP_example.IMP_SAXS_HAS_IMP_SCORE_FUNCTOR

IMP_SAXS_HAS_BOOST_FILESYSTEM = _IMP_example.IMP_SAXS_HAS_BOOST_FILESYSTEM

IMP_SAXS_HAS_BOOST_PROGRAMOPTIONS = _IMP_example.IMP_SAXS_HAS_BOOST_PROGRAMOPTIONS

IMP_SAXS_HAS_BOOST_RANDOM = _IMP_example.IMP_SAXS_HAS_BOOST_RANDOM

IMP_SAXS_HAS_BOOST_REGEX = _IMP_example.IMP_SAXS_HAS_BOOST_REGEX

IMP_SAXS_HAS_BOOST_SYSTEM = _IMP_example.IMP_SAXS_HAS_BOOST_SYSTEM

IMP_SAXS_HAS_CGAL = _IMP_example.IMP_SAXS_HAS_CGAL

IMP_SAXS_HAS_HDF5 = _IMP_example.IMP_SAXS_HAS_HDF5

IMP_SAXS_HAS_NUMPY = _IMP_example.IMP_SAXS_HAS_NUMPY

IMP_SAXS_HAS_PYTHON_IHM = _IMP_example.IMP_SAXS_HAS_PYTHON_IHM

IMPSAXS_SHOW_WARNINGS = _IMP_example.IMPSAXS_SHOW_WARNINGS

import IMP.saxs
IMP_ISD_HAS_IMP_CGAL = _IMP_example.IMP_ISD_HAS_IMP_CGAL

IMP_ISD_HAS_IMP_DISPLAY = _IMP_example.IMP_ISD_HAS_IMP_DISPLAY

IMP_ISD_HAS_IMP_SCORE_FUNCTOR = _IMP_example.IMP_ISD_HAS_IMP_SCORE_FUNCTOR

IMP_ISD_HAS_BOOST_FILESYSTEM = _IMP_example.IMP_ISD_HAS_BOOST_FILESYSTEM

IMP_ISD_HAS_BOOST_PROGRAMOPTIONS = _IMP_example.IMP_ISD_HAS_BOOST_PROGRAMOPTIONS

IMP_ISD_HAS_BOOST_RANDOM = _IMP_example.IMP_ISD_HAS_BOOST_RANDOM

IMP_ISD_HAS_BOOST_REGEX = _IMP_example.IMP_ISD_HAS_BOOST_REGEX

IMP_ISD_HAS_BOOST_SYSTEM = _IMP_example.IMP_ISD_HAS_BOOST_SYSTEM

IMP_ISD_HAS_CGAL = _IMP_example.IMP_ISD_HAS_CGAL

IMP_ISD_HAS_HDF5 = _IMP_example.IMP_ISD_HAS_HDF5

IMP_ISD_HAS_NUMPY = _IMP_example.IMP_ISD_HAS_NUMPY

IMP_ISD_HAS_PYTHON_IHM = _IMP_example.IMP_ISD_HAS_PYTHON_IHM

IMPISD_SHOW_WARNINGS = _IMP_example.IMPISD_SHOW_WARNINGS

import IMP.isd
IMP_RMF_HAS_IMP_CGAL = _IMP_example.IMP_RMF_HAS_IMP_CGAL

IMP_RMF_HAS_IMP_EM = _IMP_example.IMP_RMF_HAS_IMP_EM

IMP_RMF_HAS_IMP_SAXS = _IMP_example.IMP_RMF_HAS_IMP_SAXS

IMP_RMF_HAS_IMP_SCORE_FUNCTOR = _IMP_example.IMP_RMF_HAS_IMP_SCORE_FUNCTOR

IMP_RMF_HAS_IMP_STATISTICS = _IMP_example.IMP_RMF_HAS_IMP_STATISTICS

IMP_RMF_HAS_BOOST_FILESYSTEM = _IMP_example.IMP_RMF_HAS_BOOST_FILESYSTEM

IMP_RMF_HAS_BOOST_PROGRAMOPTIONS = _IMP_example.IMP_RMF_HAS_BOOST_PROGRAMOPTIONS

IMP_RMF_HAS_BOOST_RANDOM = _IMP_example.IMP_RMF_HAS_BOOST_RANDOM

IMP_RMF_HAS_BOOST_REGEX = _IMP_example.IMP_RMF_HAS_BOOST_REGEX

IMP_RMF_HAS_BOOST_SYSTEM = _IMP_example.IMP_RMF_HAS_BOOST_SYSTEM

IMP_RMF_HAS_CGAL = _IMP_example.IMP_RMF_HAS_CGAL

IMP_RMF_HAS_HDF5 = _IMP_example.IMP_RMF_HAS_HDF5

IMP_RMF_HAS_NUMPY = _IMP_example.IMP_RMF_HAS_NUMPY

IMP_RMF_HAS_PYTHON_IHM = _IMP_example.IMP_RMF_HAS_PYTHON_IHM

IMPRMF_SHOW_WARNINGS = _IMP_example.IMPRMF_SHOW_WARNINGS

import IMP.rmf
import RMF
IMP_DOMINO_HAS_IMP_ATOM = _IMP_example.IMP_DOMINO_HAS_IMP_ATOM

IMP_DOMINO_HAS_IMP_CGAL = _IMP_example.IMP_DOMINO_HAS_IMP_CGAL

IMP_DOMINO_HAS_IMP_EM = _IMP_example.IMP_DOMINO_HAS_IMP_EM

IMP_DOMINO_HAS_IMP_ISD = _IMP_example.IMP_DOMINO_HAS_IMP_ISD

IMP_DOMINO_HAS_IMP_KERNEL = _IMP_example.IMP_DOMINO_HAS_IMP_KERNEL

IMP_DOMINO_HAS_IMP_RMF = _IMP_example.IMP_DOMINO_HAS_IMP_RMF

IMP_DOMINO_HAS_IMP_SAXS = _IMP_example.IMP_DOMINO_HAS_IMP_SAXS

IMP_DOMINO_HAS_IMP_SCORE_FUNCTOR = _IMP_example.IMP_DOMINO_HAS_IMP_SCORE_FUNCTOR

IMP_DOMINO_HAS_BOOST_FILESYSTEM = _IMP_example.IMP_DOMINO_HAS_BOOST_FILESYSTEM

IMP_DOMINO_HAS_BOOST_PROGRAMOPTIONS = _IMP_example.IMP_DOMINO_HAS_BOOST_PROGRAMOPTIONS

IMP_DOMINO_HAS_BOOST_RANDOM = _IMP_example.IMP_DOMINO_HAS_BOOST_RANDOM

IMP_DOMINO_HAS_BOOST_REGEX = _IMP_example.IMP_DOMINO_HAS_BOOST_REGEX

IMP_DOMINO_HAS_BOOST_SYSTEM = _IMP_example.IMP_DOMINO_HAS_BOOST_SYSTEM

IMP_DOMINO_HAS_CGAL = _IMP_example.IMP_DOMINO_HAS_CGAL

IMP_DOMINO_HAS_HDF5 = _IMP_example.IMP_DOMINO_HAS_HDF5

IMP_DOMINO_HAS_NUMPY = _IMP_example.IMP_DOMINO_HAS_NUMPY

IMP_DOMINO_HAS_RMF = _IMP_example.IMP_DOMINO_HAS_RMF

IMP_DOMINO_HAS_PYTHON_IHM = _IMP_example.IMP_DOMINO_HAS_PYTHON_IHM

IMPDOMINO_SHOW_WARNINGS = _IMP_example.IMPDOMINO_SHOW_WARNINGS

import RMF_HDF5
import IMP.domino
IMP_EXAMPLE_HAS_IMP_ALGEBRA = _IMP_example.IMP_EXAMPLE_HAS_IMP_ALGEBRA

IMP_EXAMPLE_HAS_IMP_CGAL = _IMP_example.IMP_EXAMPLE_HAS_IMP_CGAL

IMP_EXAMPLE_HAS_IMP_DISPLAY = _IMP_example.IMP_EXAMPLE_HAS_IMP_DISPLAY

IMP_EXAMPLE_HAS_IMP_EM = _IMP_example.IMP_EXAMPLE_HAS_IMP_EM

IMP_EXAMPLE_HAS_IMP_ISD = _IMP_example.IMP_EXAMPLE_HAS_IMP_ISD

IMP_EXAMPLE_HAS_IMP_KERNEL = _IMP_example.IMP_EXAMPLE_HAS_IMP_KERNEL

IMP_EXAMPLE_HAS_IMP_RMF = _IMP_example.IMP_EXAMPLE_HAS_IMP_RMF

IMP_EXAMPLE_HAS_IMP_SAXS = _IMP_example.IMP_EXAMPLE_HAS_IMP_SAXS

IMP_EXAMPLE_HAS_IMP_SCORE_FUNCTOR = _IMP_example.IMP_EXAMPLE_HAS_IMP_SCORE_FUNCTOR

IMP_EXAMPLE_HAS_IMP_STATISTICS = _IMP_example.IMP_EXAMPLE_HAS_IMP_STATISTICS

IMP_EXAMPLE_HAS_BOOST_FILESYSTEM = _IMP_example.IMP_EXAMPLE_HAS_BOOST_FILESYSTEM

IMP_EXAMPLE_HAS_BOOST_GRAPH = _IMP_example.IMP_EXAMPLE_HAS_BOOST_GRAPH

IMP_EXAMPLE_HAS_BOOST_PROGRAMOPTIONS = _IMP_example.IMP_EXAMPLE_HAS_BOOST_PROGRAMOPTIONS

IMP_EXAMPLE_HAS_BOOST_RANDOM = _IMP_example.IMP_EXAMPLE_HAS_BOOST_RANDOM

IMP_EXAMPLE_HAS_BOOST_REGEX = _IMP_example.IMP_EXAMPLE_HAS_BOOST_REGEX

IMP_EXAMPLE_HAS_BOOST_SYSTEM = _IMP_example.IMP_EXAMPLE_HAS_BOOST_SYSTEM

IMP_EXAMPLE_HAS_CGAL = _IMP_example.IMP_EXAMPLE_HAS_CGAL

IMP_EXAMPLE_HAS_HDF5 = _IMP_example.IMP_EXAMPLE_HAS_HDF5

IMP_EXAMPLE_HAS_NUMPY = _IMP_example.IMP_EXAMPLE_HAS_NUMPY

IMP_EXAMPLE_HAS_RMF = _IMP_example.IMP_EXAMPLE_HAS_RMF

IMP_EXAMPLE_HAS_PYTHON_IHM = _IMP_example.IMP_EXAMPLE_HAS_PYTHON_IHM

IMP_EXAMPLE_HAS_EXAMPLEDEPENDENCY = _IMP_example.IMP_EXAMPLE_HAS_EXAMPLEDEPENDENCY

IMPEXAMPLE_SHOW_WARNINGS = _IMP_example.IMPEXAMPLE_SHOW_WARNINGS


_object_types.append("ExampleRestraint")


def _object_cast_to_ExampleRestraint(o):
    r"""_object_cast_to_ExampleRestraint(Object o) -> ExampleRestraint"""
    return _IMP_example._object_cast_to_ExampleRestraint(o)

def ExampleDecorators(l=[]):
    return [ExampleDecorator(x) for x in l]
_plural_types.append("ExampleDecorators")


_value_types.append("ExampleDecorator")


_object_types.append("ExampleUnaryFunction")


def _object_cast_to_ExampleUnaryFunction(o):
    r"""_object_cast_to_ExampleUnaryFunction(Object o) -> ExampleUnaryFunction"""
    return _IMP_example._object_cast_to_ExampleUnaryFunction(o)

_object_types.append("ExampleSingletonModifier")


def _object_cast_to_ExampleSingletonModifier(o):
    r"""_object_cast_to_ExampleSingletonModifier(Object o) -> ExampleSingletonModifier"""
    return _IMP_example._object_cast_to_ExampleSingletonModifier(o)

_object_types.append("ExamplePairScore")


def _object_cast_to_ExamplePairScore(o):
    r"""_object_cast_to_ExamplePairScore(Object o) -> ExamplePairScore"""
    return _IMP_example._object_cast_to_ExamplePairScore(o)

_object_types.append("ExampleSubsetFilterTable")


def _object_cast_to_ExampleSubsetFilterTable(o):
    r"""_object_cast_to_ExampleSubsetFilterTable(Object o) -> ExampleSubsetFilterTable"""
    return _IMP_example._object_cast_to_ExampleSubsetFilterTable(o)

_object_types.append("ExampleConstraint")


def _object_cast_to_ExampleConstraint(o):
    r"""_object_cast_to_ExampleConstraint(Object o) -> ExampleConstraint"""
    return _IMP_example._object_cast_to_ExampleConstraint(o)

_object_types.append("ExampleObject")


def _object_cast_to_ExampleObject(o):
    r"""_object_cast_to_ExampleObject(Object o) -> ExampleObject"""
    return _IMP_example._object_cast_to_ExampleObject(o)

ExampleTemplateClass3Ds=list
_plural_types.append("ExampleTemplateClass3Ds")
_value_types.append("ExampleTemplateClass3D")


def create_model_and_particles():
    m = IMP.Model()
    sc = IMP.container.ListSingletonContainer(m)
    b = IMP.algebra.BoundingBox3D(IMP.algebra.Vector3D(0,0,0),
                                 IMP.algebra.Vector3D(10,10,10))
    for i in range(0,100):
        p = m.add_particle("p")
        sc.add(p)
        d = IMP.core.XYZR.setup_particle(m, p,
                  IMP.algebra.Sphere3D(IMP.algebra.get_random_vector_in(b), 1))
        d.set_coordinates_are_optimized(True)
    return (m, sc)



class PythonExampleRestraint(IMP.Restraint):
    """An example restraint written in Python.
       This should be functionally equivalent to the C++ ExampleRestraint.
    """
    def __init__(self, m, p, k):
        IMP.Restraint.__init__(self, m, "PythonExampleRestraint%1%")
        self.p, self.k = p, k

    def do_add_score_and_derivatives(self, sa):
        d = IMP.core.XYZ(self.get_model(), self.p)
        score = .5 * self.k * d.get_z() * d.get_z()
        if sa.get_derivative_accumulator():
            deriv = self.k * d.get_z()
            d.add_to_derivative(2, deriv, sa.get_derivative_accumulator())
        sa.add_score(score)

    def do_get_inputs(self):
        return [self.get_model().get_particle(self.p)]




class PythonExamplePairScore(IMP.PairScore):
    """An example PairScore written in Python.
       This should be functionally equivalent to the C++ ExamplePairScore.
    """
    def __init__(self, x0, k):
        IMP.PairScore.__init__(self)
        self.x0, self.k = x0, k

    def evaluate_index(self, m, pip, da):
        d0 = IMP.core.XYZ(m, pip[0])
        d1 = IMP.core.XYZ(m, pip[1])
        diff = (d0.get_coordinates()
                - d1.get_coordinates()).get_magnitude() - self.x0
        score = .5 * self.k * diff * diff
        if da:
# derivatives are requested
            delta = d0.get_coordinates() - d1.get_coordinates()
            udelta = delta.get_unit_vector()
            dv = self.k * diff
            d0.add_to_derivatives(udelta * dv, da)
            d1.add_to_derivatives(-udelta * dv, da)
        return score

    def do_get_inputs(self, m, pis):
        return IMP.get_particles(m, pis)




class PythonExampleUnaryFunction(IMP.UnaryFunction):
    """An example UnaryFunction written in Python.
       This should be functionally equivalent to the C++ ExampleUnaryFunction.
    """
    def __init__(self, center, k):
        IMP.UnaryFunction.__init__(self)
        self.center, self.k = center, k

    def evaluate_with_derivative(self, feature):
        return (self.evaluate(feature), self.k * (feature - self.center))

    def evaluate(self, feature):
        return .5 * self.k * (feature - self.center) * (feature - self.center)




class PythonExampleConstraint(IMP.Constraint):
    """An example Constraint written in Python.
       This should be functionally equivalent to the C++ ExampleConstraint.
    """

    k = None

    def __init__(self, p):
        IMP.Constraint.__init__(self, p.get_model(), "ExampleConstraint%1%")
        self.p = p
        if self.k is None:
            PythonExampleConstraint.k = IMP.IntKey("Constraint key")
        if not p.has_attribute(self.k):
            p.add_attribute(self.k, 0)

    def do_update_attributes(self):
        self.p.set_value(self.k, self.p.get_value(self.k) + 1)

    def do_update_derivatives(self, da):
        pass

    def do_get_inputs(self):
        return [self.p]

    def do_get_outputs(self):
        return [self.p]




class PythonExampleSingletonModifier(IMP.SingletonModifier):
    """An example SingletonModifier written in Python.
       This should be functionally equivalent to the C++
       ExampleSingletonModifier.
    """

    def __init__(self, bb):
        IMP.SingletonModifier.__init__(self, "ExampleSingletonModifier%1%")
        self.bb = bb

    def apply_index(self, m, pi):
        d = IMP.core.XYZ(m, pi)
        for i in range(3):
# shift the coordinate until it is in the box
            while d.get_coordinate(i) < self.bb.get_corner(0)[i]:
                d.set_coordinate(i,d.get_coordinate(i) + \
                       (self.bb.get_corner(1)[i] - self.bb.get_corner(0)[i]))
            while d.get_coordinate(i) > self.bb.get_corner(1)[i]:
                d.set_coordinate(i,d.get_coordinate(i) - \
                       (self.bb.get_corner(1)[i] - self.bb.get_corner(0)[i]))

    def do_get_inputs(self, m, pis):
        return IMP.get_particles(m, pis)

    def do_get_outputs(self, m, pis):
        return self.do_get_inputs(m, pis)


class ExampleRestraint(IMP.Restraint):
    r"""Proxy of C++ IMP::example::ExampleRestraint class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, m, p, k):
        r"""__init__(ExampleRestraint self, Model m, ParticleIndex p, double k) -> ExampleRestraint"""
        _IMP_example.ExampleRestraint_swiginit(self, _IMP_example.new_ExampleRestraint(m, p, k))

    def do_add_score_and_derivatives(self, sa):
        r"""do_add_score_and_derivatives(ExampleRestraint self, ScoreAccumulator sa)"""
        return _IMP_example.ExampleRestraint_do_add_score_and_derivatives(self, sa)

    def do_get_inputs(self):
        r"""do_get_inputs(ExampleRestraint self) -> IMP::ModelObjectsTemp"""
        return _IMP_example.ExampleRestraint_do_get_inputs(self)

    def get_version_info(self):
        r"""get_version_info(ExampleRestraint self) -> VersionInfo"""
        return _IMP_example.ExampleRestraint_get_version_info(self)

    def __str__(self):
        r"""__str__(ExampleRestraint self) -> std::string"""
        return _IMP_example.ExampleRestraint___str__(self)

    def __repr__(self):
        r"""__repr__(ExampleRestraint self) -> std::string"""
        return _IMP_example.ExampleRestraint___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_ExampleRestraint(o)


# Register ExampleRestraint in _IMP_example:
_IMP_example.ExampleRestraint_swigregister(ExampleRestraint)

class ExampleDecorator(IMP.Decorator):
    r"""Proxy of C++ IMP::example::ExampleDecorator class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def get_decorator_name(self):
        r"""get_decorator_name(ExampleDecorator self) -> std::string"""
        return _IMP_example.ExampleDecorator_get_decorator_name(self)

    def set_decorator_name(self, nm):
        r"""set_decorator_name(ExampleDecorator self, std::string nm)"""
        return _IMP_example.ExampleDecorator_set_decorator_name(self, nm)

    def __init__(self, *args):
        r"""
        __init__(ExampleDecorator self) -> ExampleDecorator
        __init__(ExampleDecorator self, Model m, ParticleIndex id) -> ExampleDecorator
        __init__(ExampleDecorator self, _ParticleAdaptor d) -> ExampleDecorator
        """
        _IMP_example.ExampleDecorator_swiginit(self, _IMP_example.new_ExampleDecorator(*args))

    @staticmethod
    def get_is_setup(*args):
        r"""
        get_is_setup(Model m, ParticleIndex pi) -> bool
        get_is_setup(_ParticleAdaptor p) -> bool
        """
        return _IMP_example.ExampleDecorator_get_is_setup(*args)

    def show(self, *args):
        r"""show(ExampleDecorator self, _ostream out=std::cout)"""
        return _IMP_example.ExampleDecorator_show(self, *args)

    @staticmethod
    def setup_particle(*args):
        r"""
        setup_particle(Model m, ParticleIndex pi, std::string name) -> ExampleDecorator
        setup_particle(_ParticleAdaptor decorator, std::string name) -> ExampleDecorator
        """
        return _IMP_example.ExampleDecorator_setup_particle(*args)

    def add_attribute(self, *args):
        r"""
        add_attribute(ExampleDecorator self, FloatKey k, IMP::Float v, bool opt)
        add_attribute(ExampleDecorator self, FloatKey a0, IMP::Float a1)
        add_attribute(ExampleDecorator self, IntKey a0, IMP::Int a1)
        add_attribute(ExampleDecorator self, FloatsKey a0, IMP::Floats a1)
        add_attribute(ExampleDecorator self, IntsKey a0, IMP::Ints a1)
        add_attribute(ExampleDecorator self, StringKey a0, IMP::String a1)
        add_attribute(ExampleDecorator self, ParticleIndexKey a0, Particle a1)
        add_attribute(ExampleDecorator self, ObjectKey a0, Object a1)
        """
        return _IMP_example.ExampleDecorator_add_attribute(self, *args)

    def get_value(self, *args):
        r"""
        get_value(ExampleDecorator self, FloatKey a0) -> IMP::Float
        get_value(ExampleDecorator self, IntKey a0) -> IMP::Int
        get_value(ExampleDecorator self, FloatsKey a0) -> IMP::Floats
        get_value(ExampleDecorator self, IntsKey a0) -> IMP::Ints
        get_value(ExampleDecorator self, StringKey a0) -> IMP::String
        get_value(ExampleDecorator self, ParticleIndexKey a0) -> Particle
        get_value(ExampleDecorator self, ObjectKey a0) -> Object
        """
        return _IMP_example.ExampleDecorator_get_value(self, *args)

    def set_value(self, *args):
        r"""
        set_value(ExampleDecorator self, FloatKey a0, IMP::Float a1)
        set_value(ExampleDecorator self, IntKey a0, IMP::Int a1)
        set_value(ExampleDecorator self, FloatsKey a0, IMP::Floats a1)
        set_value(ExampleDecorator self, IntsKey a0, IMP::Ints a1)
        set_value(ExampleDecorator self, StringKey a0, IMP::String a1)
        set_value(ExampleDecorator self, ParticleIndexKey a0, Particle a1)
        set_value(ExampleDecorator self, ObjectKey a0, Object a1)
        """
        return _IMP_example.ExampleDecorator_set_value(self, *args)

    def remove_attribute(self, *args):
        r"""
        remove_attribute(ExampleDecorator self, FloatKey a0)
        remove_attribute(ExampleDecorator self, IntKey a0)
        remove_attribute(ExampleDecorator self, FloatsKey a0)
        remove_attribute(ExampleDecorator self, IntsKey a0)
        remove_attribute(ExampleDecorator self, StringKey a0)
        remove_attribute(ExampleDecorator self, ParticleIndexKey a0)
        remove_attribute(ExampleDecorator self, ObjectKey a0)
        """
        return _IMP_example.ExampleDecorator_remove_attribute(self, *args)

    def has_attribute(self, *args):
        r"""
        has_attribute(ExampleDecorator self, FloatKey a0) -> bool
        has_attribute(ExampleDecorator self, IntKey a0) -> bool
        has_attribute(ExampleDecorator self, FloatsKey a0) -> bool
        has_attribute(ExampleDecorator self, IntsKey a0) -> bool
        has_attribute(ExampleDecorator self, StringKey a0) -> bool
        has_attribute(ExampleDecorator self, ParticleIndexKey a0) -> bool
        has_attribute(ExampleDecorator self, ObjectKey a0) -> bool
        """
        return _IMP_example.ExampleDecorator_has_attribute(self, *args)

    def get_derivative(self, a0):
        r"""get_derivative(ExampleDecorator self, FloatKey a0) -> double"""
        return _IMP_example.ExampleDecorator_get_derivative(self, a0)

    def get_name(self):
        r"""get_name(ExampleDecorator self) -> std::string"""
        return _IMP_example.ExampleDecorator_get_name(self)

    def clear_caches(self):
        r"""clear_caches(ExampleDecorator self)"""
        return _IMP_example.ExampleDecorator_clear_caches(self)

    def set_name(self, a0):
        r"""set_name(ExampleDecorator self, std::string a0)"""
        return _IMP_example.ExampleDecorator_set_name(self, a0)

    def set_check_level(self, a0):
        r"""set_check_level(ExampleDecorator self, IMP::CheckLevel a0)"""
        return _IMP_example.ExampleDecorator_set_check_level(self, a0)

    def add_to_derivative(self, a0, a1, a2):
        r"""add_to_derivative(ExampleDecorator self, FloatKey a0, double a1, DerivativeAccumulator a2)"""
        return _IMP_example.ExampleDecorator_add_to_derivative(self, a0, a1, a2)

    def set_is_optimized(self, a0, a1):
        r"""set_is_optimized(ExampleDecorator self, FloatKey a0, bool a1)"""
        return _IMP_example.ExampleDecorator_set_is_optimized(self, a0, a1)

    def get_is_optimized(self, a0):
        r"""get_is_optimized(ExampleDecorator self, FloatKey a0) -> bool"""
        return _IMP_example.ExampleDecorator_get_is_optimized(self, a0)

    def get_check_level(self):
        r"""get_check_level(ExampleDecorator self) -> IMP::CheckLevel"""
        return _IMP_example.ExampleDecorator_get_check_level(self)

    def __eq__(self, *args):
        r"""
        __eq__(ExampleDecorator self, ExampleDecorator o) -> bool
        __eq__(ExampleDecorator self, Particle d) -> bool
        """
        return _IMP_example.ExampleDecorator___eq__(self, *args)

    def __ne__(self, *args):
        r"""
        __ne__(ExampleDecorator self, ExampleDecorator o) -> bool
        __ne__(ExampleDecorator self, Particle d) -> bool
        """
        return _IMP_example.ExampleDecorator___ne__(self, *args)

    def __le__(self, *args):
        r"""
        __le__(ExampleDecorator self, ExampleDecorator o) -> bool
        __le__(ExampleDecorator self, Particle d) -> bool
        """
        return _IMP_example.ExampleDecorator___le__(self, *args)

    def __lt__(self, *args):
        r"""
        __lt__(ExampleDecorator self, ExampleDecorator o) -> bool
        __lt__(ExampleDecorator self, Particle d) -> bool
        """
        return _IMP_example.ExampleDecorator___lt__(self, *args)

    def __ge__(self, *args):
        r"""
        __ge__(ExampleDecorator self, ExampleDecorator o) -> bool
        __ge__(ExampleDecorator self, Particle d) -> bool
        """
        return _IMP_example.ExampleDecorator___ge__(self, *args)

    def __gt__(self, *args):
        r"""
        __gt__(ExampleDecorator self, ExampleDecorator o) -> bool
        __gt__(ExampleDecorator self, Particle d) -> bool
        """
        return _IMP_example.ExampleDecorator___gt__(self, *args)

    def __hash__(self):
        r"""__hash__(ExampleDecorator self) -> std::size_t"""
        return _IMP_example.ExampleDecorator___hash__(self)

    def __str__(self):
        r"""__str__(ExampleDecorator self) -> std::string"""
        return _IMP_example.ExampleDecorator___str__(self)

    def __repr__(self):
        r"""__repr__(ExampleDecorator self) -> std::string"""
        return _IMP_example.ExampleDecorator___repr__(self)
    __swig_destroy__ = _IMP_example.delete_ExampleDecorator

# Register ExampleDecorator in _IMP_example:
_IMP_example.ExampleDecorator_swigregister(ExampleDecorator)

def ExampleDecorator_get_is_setup(*args):
    r"""
    ExampleDecorator_get_is_setup(Model m, ParticleIndex pi) -> bool
    ExampleDecorator_get_is_setup(_ParticleAdaptor p) -> bool
    """
    return _IMP_example.ExampleDecorator_get_is_setup(*args)

def ExampleDecorator_setup_particle(*args):
    r"""
    ExampleDecorator_setup_particle(Model m, ParticleIndex pi, std::string name) -> ExampleDecorator
    ExampleDecorator_setup_particle(_ParticleAdaptor decorator, std::string name) -> ExampleDecorator
    """
    return _IMP_example.ExampleDecorator_setup_particle(*args)


def __lshift__(out, n):
    r"""__lshift__(_ostream out, ExampleDecorator n) -> _ostream"""
    return _IMP_example.__lshift__(out, n)
class ExampleUnaryFunction(IMP.UnaryFunction):
    r"""Proxy of C++ IMP::example::ExampleUnaryFunction class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, center, k):
        r"""__init__(ExampleUnaryFunction self, IMP::Float center, IMP::Float k) -> ExampleUnaryFunction"""
        _IMP_example.ExampleUnaryFunction_swiginit(self, _IMP_example.new_ExampleUnaryFunction(center, k))

    def get_version_info(self):
        r"""get_version_info(ExampleUnaryFunction self) -> VersionInfo"""
        return _IMP_example.ExampleUnaryFunction_get_version_info(self)

    def __str__(self):
        r"""__str__(ExampleUnaryFunction self) -> std::string"""
        return _IMP_example.ExampleUnaryFunction___str__(self)

    def __repr__(self):
        r"""__repr__(ExampleUnaryFunction self) -> std::string"""
        return _IMP_example.ExampleUnaryFunction___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_ExampleUnaryFunction(o)


# Register ExampleUnaryFunction in _IMP_example:
_IMP_example.ExampleUnaryFunction_swigregister(ExampleUnaryFunction)

class ExampleObject(IMP.Object):
    r"""Proxy of C++ IMP::example::ExampleObject class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, data):
        r"""__init__(ExampleObject self, IMP::Floats const & data) -> ExampleObject"""
        _IMP_example.ExampleObject_swiginit(self, _IMP_example.new_ExampleObject(data))

    def get_data(self, i):
        r"""get_data(ExampleObject self, unsigned int i) -> double"""
        return _IMP_example.ExampleObject_get_data(self, i)

    def get_version_info(self):
        r"""get_version_info(ExampleObject self) -> VersionInfo"""
        return _IMP_example.ExampleObject_get_version_info(self)

    def __str__(self):
        r"""__str__(ExampleObject self) -> std::string"""
        return _IMP_example.ExampleObject___str__(self)

    def __repr__(self):
        r"""__repr__(ExampleObject self) -> std::string"""
        return _IMP_example.ExampleObject___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_ExampleObject(o)


# Register ExampleObject in _IMP_example:
_IMP_example.ExampleObject_swigregister(ExampleObject)

class ExampleSingletonModifier(IMP.SingletonModifier):
    r"""Proxy of C++ IMP::example::ExampleSingletonModifier class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, bb):
        r"""__init__(ExampleSingletonModifier self, BoundingBox3D bb) -> ExampleSingletonModifier"""
        _IMP_example.ExampleSingletonModifier_swiginit(self, _IMP_example.new_ExampleSingletonModifier(bb))

    def do_get_inputs(self, m, pis):
        r"""do_get_inputs(ExampleSingletonModifier self, Model m, IMP::ParticleIndexes const & pis) -> IMP::ModelObjectsTemp"""
        return _IMP_example.ExampleSingletonModifier_do_get_inputs(self, m, pis)

    def do_get_outputs(self, m, pis):
        r"""do_get_outputs(ExampleSingletonModifier self, Model m, IMP::ParticleIndexes const & pis) -> IMP::ModelObjectsTemp"""
        return _IMP_example.ExampleSingletonModifier_do_get_outputs(self, m, pis)

    def get_version_info(self):
        r"""get_version_info(ExampleSingletonModifier self) -> VersionInfo"""
        return _IMP_example.ExampleSingletonModifier_get_version_info(self)

    def __str__(self):
        r"""__str__(ExampleSingletonModifier self) -> std::string"""
        return _IMP_example.ExampleSingletonModifier___str__(self)

    def __repr__(self):
        r"""__repr__(ExampleSingletonModifier self) -> std::string"""
        return _IMP_example.ExampleSingletonModifier___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_ExampleSingletonModifier(o)


# Register ExampleSingletonModifier in _IMP_example:
_IMP_example.ExampleSingletonModifier_swigregister(ExampleSingletonModifier)

class ExamplePairScore(IMP.PairScore):
    r"""Proxy of C++ IMP::example::ExamplePairScore class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, x0, k):
        r"""__init__(ExamplePairScore self, double x0, double k) -> ExamplePairScore"""
        _IMP_example.ExamplePairScore_swiginit(self, _IMP_example.new_ExamplePairScore(x0, k))

    def do_get_inputs(self, m, pis):
        r"""do_get_inputs(ExamplePairScore self, Model m, IMP::ParticleIndexes const & pis) -> IMP::ModelObjectsTemp"""
        return _IMP_example.ExamplePairScore_do_get_inputs(self, m, pis)

    def get_version_info(self):
        r"""get_version_info(ExamplePairScore self) -> VersionInfo"""
        return _IMP_example.ExamplePairScore_get_version_info(self)

    def __str__(self):
        r"""__str__(ExamplePairScore self) -> std::string"""
        return _IMP_example.ExamplePairScore___str__(self)

    def __repr__(self):
        r"""__repr__(ExamplePairScore self) -> std::string"""
        return _IMP_example.ExamplePairScore___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_ExamplePairScore(o)


# Register ExamplePairScore in _IMP_example:
_IMP_example.ExamplePairScore_swigregister(ExamplePairScore)

class ExampleSubsetFilterTable(IMP.domino.SubsetFilterTable):
    r"""Proxy of C++ IMP::example::ExampleSubsetFilterTable class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, max_diff, pt):
        r"""__init__(ExampleSubsetFilterTable self, unsigned int max_diff, IMP::ParticlesTemp const & pt) -> ExampleSubsetFilterTable"""
        _IMP_example.ExampleSubsetFilterTable_swiginit(self, _IMP_example.new_ExampleSubsetFilterTable(max_diff, pt))

    def get_version_info(self):
        r"""get_version_info(ExampleSubsetFilterTable self) -> VersionInfo"""
        return _IMP_example.ExampleSubsetFilterTable_get_version_info(self)

    def __str__(self):
        r"""__str__(ExampleSubsetFilterTable self) -> std::string"""
        return _IMP_example.ExampleSubsetFilterTable___str__(self)

    def __repr__(self):
        r"""__repr__(ExampleSubsetFilterTable self) -> std::string"""
        return _IMP_example.ExampleSubsetFilterTable___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_ExampleSubsetFilterTable(o)


# Register ExampleSubsetFilterTable in _IMP_example:
_IMP_example.ExampleSubsetFilterTable_swigregister(ExampleSubsetFilterTable)

class ExampleConstraint(IMP.Constraint):
    r"""Proxy of C++ IMP::example::ExampleConstraint class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, p):
        r"""__init__(ExampleConstraint self, Particle p) -> ExampleConstraint"""
        _IMP_example.ExampleConstraint_swiginit(self, _IMP_example.new_ExampleConstraint(p))

    def do_get_inputs(self):
        r"""do_get_inputs(ExampleConstraint self) -> IMP::ModelObjectsTemp"""
        return _IMP_example.ExampleConstraint_do_get_inputs(self)

    def do_get_outputs(self):
        r"""do_get_outputs(ExampleConstraint self) -> IMP::ModelObjectsTemp"""
        return _IMP_example.ExampleConstraint_do_get_outputs(self)

    @staticmethod
    def get_key():
        r"""get_key() -> IntKey"""
        return _IMP_example.ExampleConstraint_get_key()

    def get_version_info(self):
        r"""get_version_info(ExampleConstraint self) -> VersionInfo"""
        return _IMP_example.ExampleConstraint_get_version_info(self)

    def __str__(self):
        r"""__str__(ExampleConstraint self) -> std::string"""
        return _IMP_example.ExampleConstraint___str__(self)

    def __repr__(self):
        r"""__repr__(ExampleConstraint self) -> std::string"""
        return _IMP_example.ExampleConstraint___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_ExampleConstraint(o)


# Register ExampleConstraint in _IMP_example:
_IMP_example.ExampleConstraint_swigregister(ExampleConstraint)

def ExampleConstraint_get_key():
    r"""ExampleConstraint_get_key() -> IntKey"""
    return _IMP_example.ExampleConstraint_get_key()


def create_serial_mover(m, pis):
    r"""create_serial_mover(Model m, IMP::ParticleIndexes const & pis) -> MonteCarloMover"""
    return _IMP_example.create_serial_mover(m, pis)

def optimize_balls(*args):
    r"""optimize_balls(Model m, IMP::ParticleIndexes const & pis, IMP::RestraintsTemp const & rs=IMP::RestraintsTemp(), IMP::PairPredicates const & excluded=IMP::PairPredicates(), IMP::OptimizerStates const & opt_states=IMP::OptimizerStates(), IMP::LogLevel ll=DEFAULT)"""
    return _IMP_example.optimize_balls(*args)

def optimize_assembly(*args):
    r"""optimize_assembly(Model m, IMP::ParticleIndexes const & components, IMP::RestraintsTemp const & interactions, IMP::RestraintsTemp const & other_restraints, BoundingBox3D bb, PairScore ev, double cutoff, IMP::PairPredicates const & excluded=IMP::PairPredicates())"""
    return _IMP_example.optimize_assembly(*args)

def get_number_of_incidences(psa, psb, point_distance):
    r"""get_number_of_incidences(IMP::ParticlesTemp const & psa, IMP::ParticlesTemp const & psb, double point_distance) -> unsigned int"""
    return _IMP_example.get_number_of_incidences(psa, psb, point_distance)

def create_chain_restraint(m, ps, length_factor, k, name):
    r"""create_chain_restraint(Model m, IMP::ParticleIndexes const & ps, double length_factor, double k, std::string name) -> Restraint"""
    return _IMP_example.create_chain_restraint(m, ps, length_factor, k, name)

def create_excluded_volume(m, ps, k, name):
    r"""create_excluded_volume(Model m, IMP::ParticleIndexes const & ps, double k, std::string name) -> Restraint"""
    return _IMP_example.create_excluded_volume(m, ps, k, name)
class ExampleTemplateClass3D(object):
    r"""Proxy of C++ IMP::example::ExampleTemplateClassD< 3 > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(ExampleTemplateClass3D self) -> ExampleTemplateClass3D
        __init__(ExampleTemplateClass3D self, Vector3D a, Vector3D b) -> ExampleTemplateClass3D
        """
        _IMP_example.ExampleTemplateClass3D_swiginit(self, _IMP_example.new_ExampleTemplateClass3D(*args))

    def get_point(self, i):
        r"""get_point(ExampleTemplateClass3D self, unsigned int i) -> Vector3D"""
        return _IMP_example.ExampleTemplateClass3D_get_point(self, i)

    def show(self, *args):
        r"""show(ExampleTemplateClass3D self, _ostream out=std::cout)"""
        return _IMP_example.ExampleTemplateClass3D_show(self, *args)

    def __str__(self):
        r"""__str__(ExampleTemplateClass3D self) -> std::string"""
        return _IMP_example.ExampleTemplateClass3D___str__(self)

    def __repr__(self):
        r"""__repr__(ExampleTemplateClass3D self) -> std::string"""
        return _IMP_example.ExampleTemplateClass3D___repr__(self)
    __swig_destroy__ = _IMP_example.delete_ExampleTemplateClass3D

# Register ExampleTemplateClass3D in _IMP_example:
_IMP_example.ExampleTemplateClass3D_swigregister(ExampleTemplateClass3D)


def get_module_version():
    r"""get_module_version() -> std::string const"""
    return _IMP_example.get_module_version()

def get_example_path(fname):
    r"""get_example_path(std::string fname) -> std::string"""
    return _IMP_example.get_example_path(fname)

def get_data_path(fname):
    r"""get_data_path(std::string fname) -> std::string"""
    return _IMP_example.get_data_path(fname)

from . import _version_check
_version_check.check_version(get_module_version())
__version__ = get_module_version()



