imp_get_process_exit_code(ElementTree has_element_tree ${CMAKE_BINARY_DIR} COMMAND python -c "import xml.etree.ElementTree")

if(${has_element_tree})
message(STATUS "Python xml.etree not found, docs disabled.")
    set(IMP_DOXYGEN_FOUND False CACHE INTERNAL "")
    set(IMP_DOXYGEN_EXECUTABLE "${DOXYGEN_EXECUTABLE}" CACHE INTERNAL "")
else()
find_package(Doxygen QUIET)
set(needed_doxygen_version "1.8.6")
if(DOXYGEN_FOUND)
  imp_get_process_output("Doxygen version" doxygen_version ${CMAKE_BINARY_DIR} COMMAND ${DOXYGEN_EXECUTABLE} --version)
  if("${doxygen_version}" STREQUAL "${needed_doxygen_version}")
    message(STATUS "Doxygen is ${DOXYGEN_EXECUTABLE}, version ${doxygen_version}")
    set(IMP_DOXYGEN_FOUND True CACHE INTERNAL "")
    set(IMP_DOXYGEN_EXECUTABLE ${DOXYGEN_EXECUTABLE} CACHE INTERNAL "")
  else()
    message(STATUS "Wrong doxygen version at ${DOXYGEN_EXECUTABLE}. Found ${doxygen_version}, but needed ${needed_doxygen_version}")
    set(IMP_DOXYGEN_FOUND False CACHE INTERNAL "")
    set(IMP_DOXYGEN_EXECUTABLE "not-found" CACHE INTERNAL "")
  endif()
else()
  message(STATUS "Doxygen not found")
endif(DOXYGEN_FOUND)

endif(${has_element_tree})
