# This file was automatically generated by SWIG (http://www.swig.org).
# Version 4.0.2
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

# This wrapper is part of IMP,
# Copyright 2007-2021 IMP Inventors. All rights reserved.

from __future__ import print_function, division, absolute_import
from sys import version_info as _swig_python_version_info
if _swig_python_version_info < (2, 7, 0):
    raise RuntimeError("Python 2.7 or later required")

import _IMP_kernel

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "thisown":
            self.this.own(value)
        elif name == "this":
            set(self, name, value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


import weakref

class IMP_KERNEL_SwigPyIterator(object):
    r"""Proxy of C++ swig::IMP_KERNEL_SwigPyIterator class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _IMP_kernel.delete_IMP_KERNEL_SwigPyIterator

    def value(self):
        r"""value(IMP_KERNEL_SwigPyIterator self) -> PyObject *"""
        return _IMP_kernel.IMP_KERNEL_SwigPyIterator_value(self)

    def incr(self, n=1):
        r"""incr(IMP_KERNEL_SwigPyIterator self, size_t n=1) -> IMP_KERNEL_SwigPyIterator"""
        return _IMP_kernel.IMP_KERNEL_SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        r"""decr(IMP_KERNEL_SwigPyIterator self, size_t n=1) -> IMP_KERNEL_SwigPyIterator"""
        return _IMP_kernel.IMP_KERNEL_SwigPyIterator_decr(self, n)

    def distance(self, x):
        r"""distance(IMP_KERNEL_SwigPyIterator self, IMP_KERNEL_SwigPyIterator x) -> ptrdiff_t"""
        return _IMP_kernel.IMP_KERNEL_SwigPyIterator_distance(self, x)

    def equal(self, x):
        r"""equal(IMP_KERNEL_SwigPyIterator self, IMP_KERNEL_SwigPyIterator x) -> bool"""
        return _IMP_kernel.IMP_KERNEL_SwigPyIterator_equal(self, x)

    def copy(self):
        r"""copy(IMP_KERNEL_SwigPyIterator self) -> IMP_KERNEL_SwigPyIterator"""
        return _IMP_kernel.IMP_KERNEL_SwigPyIterator_copy(self)

    def next(self):
        r"""next(IMP_KERNEL_SwigPyIterator self) -> PyObject *"""
        return _IMP_kernel.IMP_KERNEL_SwigPyIterator_next(self)

    def __next__(self):
        r"""__next__(IMP_KERNEL_SwigPyIterator self) -> PyObject *"""
        return _IMP_kernel.IMP_KERNEL_SwigPyIterator___next__(self)

    def previous(self):
        r"""previous(IMP_KERNEL_SwigPyIterator self) -> PyObject *"""
        return _IMP_kernel.IMP_KERNEL_SwigPyIterator_previous(self)

    def advance(self, n):
        r"""advance(IMP_KERNEL_SwigPyIterator self, ptrdiff_t n) -> IMP_KERNEL_SwigPyIterator"""
        return _IMP_kernel.IMP_KERNEL_SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        r"""__eq__(IMP_KERNEL_SwigPyIterator self, IMP_KERNEL_SwigPyIterator x) -> bool"""
        return _IMP_kernel.IMP_KERNEL_SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        r"""__ne__(IMP_KERNEL_SwigPyIterator self, IMP_KERNEL_SwigPyIterator x) -> bool"""
        return _IMP_kernel.IMP_KERNEL_SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        r"""__iadd__(IMP_KERNEL_SwigPyIterator self, ptrdiff_t n) -> IMP_KERNEL_SwigPyIterator"""
        return _IMP_kernel.IMP_KERNEL_SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        r"""__isub__(IMP_KERNEL_SwigPyIterator self, ptrdiff_t n) -> IMP_KERNEL_SwigPyIterator"""
        return _IMP_kernel.IMP_KERNEL_SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        r"""__add__(IMP_KERNEL_SwigPyIterator self, ptrdiff_t n) -> IMP_KERNEL_SwigPyIterator"""
        return _IMP_kernel.IMP_KERNEL_SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        r"""
        __sub__(IMP_KERNEL_SwigPyIterator self, ptrdiff_t n) -> IMP_KERNEL_SwigPyIterator
        __sub__(IMP_KERNEL_SwigPyIterator self, IMP_KERNEL_SwigPyIterator x) -> ptrdiff_t
        """
        return _IMP_kernel.IMP_KERNEL_SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register IMP_KERNEL_SwigPyIterator in _IMP_kernel:
_IMP_kernel.IMP_KERNEL_SwigPyIterator_swigregister(IMP_KERNEL_SwigPyIterator)


_value_types=[]
_object_types=[]
_raii_types=[]
_plural_types=[]

IMP_DEBUG = _IMP_kernel.IMP_DEBUG

IMP_RELEASE = _IMP_kernel.IMP_RELEASE

IMP_SILENT = _IMP_kernel.IMP_SILENT

IMP_PROGRESS = _IMP_kernel.IMP_PROGRESS

IMP_TERSE = _IMP_kernel.IMP_TERSE

IMP_VERBOSE = _IMP_kernel.IMP_VERBOSE

IMP_MEMORY = _IMP_kernel.IMP_MEMORY

IMP_NONE = _IMP_kernel.IMP_NONE

IMP_USAGE = _IMP_kernel.IMP_USAGE

IMP_INTERNAL = _IMP_kernel.IMP_INTERNAL

IMP_KERNEL_HAS_LOG4CXX = _IMP_kernel.IMP_KERNEL_HAS_LOG4CXX

IMP_COMPILER_HAS_AUTO = _IMP_kernel.IMP_COMPILER_HAS_AUTO

IMP_COMPILER_HAS_DEBUG_VECTOR = _IMP_kernel.IMP_COMPILER_HAS_DEBUG_VECTOR

IMP_COMPILER_HAS_UNIQUE_PTR = _IMP_kernel.IMP_COMPILER_HAS_UNIQUE_PTR

IMP_KERNEL_HAS_BOOST_RANDOM = _IMP_kernel.IMP_KERNEL_HAS_BOOST_RANDOM

IMP_KERNEL_HAS_NUMPY = _IMP_kernel.IMP_KERNEL_HAS_NUMPY

IMP_KERNEL_HAS_GPERFTOOLS = _IMP_kernel.IMP_KERNEL_HAS_GPERFTOOLS

IMP_KERNEL_HAS_TCMALLOC_HEAPCHECKER = _IMP_kernel.IMP_KERNEL_HAS_TCMALLOC_HEAPCHECKER

IMP_KERNEL_HAS_TCMALLOC_HEAPPROFILER = _IMP_kernel.IMP_KERNEL_HAS_TCMALLOC_HEAPPROFILER

IMPKERNEL_SHOW_WARNINGS = _IMP_kernel.IMPKERNEL_SHOW_WARNINGS


import sys
class _DirectorObjects(object):
    """@internal Simple class to keep references to director objects
       to prevent premature deletion."""
    def __init__(self):
        self._objects = []
    def register(self, obj):
        """Take a reference to a director object; will only work for
           refcounted C++ classes"""
        if hasattr(obj, 'get_ref_count'):
            self._objects.append(obj)
    def cleanup(self):
        """Only drop our reference and allow cleanup by Python if no other
           Python references exist (we hold 3 references: one in self._objects,
           one in x, and one in the argument list for getrefcount) *and* no
           other C++ references exist (the Python object always holds one)"""
        objs = [x for x in self._objects if sys.getrefcount(x) > 3 \
                                         or x.get_ref_count() > 1]
# Do in two steps so the references are kept until the end of the
# function (deleting references may trigger a fresh call to this method)
        self._objects = objs
    def get_object_count(self):
        """Get number of director objects (useful for testing only)"""
        return len(self._objects)
_director_objects = _DirectorObjects()

DEFAULT_CHECK = _IMP_kernel.DEFAULT_CHECK

NONE = _IMP_kernel.NONE

USAGE = _IMP_kernel.USAGE

USAGE_AND_INTERNAL = _IMP_kernel.USAGE_AND_INTERNAL


def set_check_level(tf):
    r"""set_check_level(IMP::CheckLevel tf)"""
    return _IMP_kernel.set_check_level(tf)

def get_check_level():
    r"""get_check_level() -> IMP::CheckLevel"""
    return _IMP_kernel.get_check_level()

from _IMP_kernel import Exception, InternalException, ModelException, EventException
from _IMP_kernel import UsageException, IndexException, IOException, ValueException
from _IMP_kernel import TypeException

class _ostream(object):
    r"""Proxy of C++ std::ostream class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def write(self, osa_buf):
        r"""write(_ostream self, char const * osa_buf)"""
        return _IMP_kernel._ostream_write(self, osa_buf)

# Register _ostream in _IMP_kernel:
_IMP_kernel._ostream_swigregister(_ostream)

IMP_COMPILER_HAS_OVERRIDE = _IMP_kernel.IMP_COMPILER_HAS_OVERRIDE

IMP_COMPILER_HAS_FINAL = _IMP_kernel.IMP_COMPILER_HAS_FINAL

IMP_HAS_NOEXCEPT = _IMP_kernel.IMP_HAS_NOEXCEPT

IMP_C_OPEN_BINARY = _IMP_kernel.IMP_C_OPEN_BINARY


_raii_types.append("SetLogState")


_raii_types.append("SetNumberOfThreads")


_raii_types.append("SetCheckState")


_object_types.append("Object")


def _object_cast_to_Object(o):
    r"""_object_cast_to_Object(Object * o) -> Object"""
    return _IMP_kernel._object_cast_to_Object(o)

_object_types.append("_TestObject")


def _object_cast_to__TestObject(o):
    r"""_object_cast_to__TestObject(Object * o) -> _TestObject"""
    return _IMP_kernel._object_cast_to__TestObject(o)

VersionInfos=list
_plural_types.append("VersionInfos")
_value_types.append("VersionInfo")


_raii_types.append("CreateLogContext")


_raii_types.append("WarningContext")


_raii_types.append("SetLogTarget")


_TestValues=list
_plural_types.append("_TestValues")
_value_types.append("_TestValue")


Floats=list
_plural_types.append("Floats")
_value_types.append("Float")


Ints=list
_plural_types.append("Ints")
_value_types.append("Int")


Strings=list
_plural_types.append("Strings")
_value_types.append("String")


_Protections=list
_plural_types.append("_Protections")
_value_types.append("_Protection")

class _InputAdaptor(object):
    r"""Proxy of C++ IMP::InputAdaptor class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    __swig_destroy__ = _IMP_kernel.delete__InputAdaptor

# Register _InputAdaptor in _IMP_kernel:
_IMP_kernel._InputAdaptor_swigregister(_InputAdaptor)

class _NonCopyable(object):
    r"""Proxy of C++ IMP::NonCopyable class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    __swig_destroy__ = _IMP_kernel.delete__NonCopyable

# Register _NonCopyable in _IMP_kernel:
_IMP_kernel._NonCopyable_swigregister(_NonCopyable)

class _RAII(_NonCopyable):
    r"""Proxy of C++ IMP::RAII class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    __swig_destroy__ = _IMP_kernel.delete__RAII

# Register _RAII in _IMP_kernel:
_IMP_kernel._RAII_swigregister(_RAII)

class _Value(object):
    r"""Proxy of C++ IMP::Value class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    __swig_destroy__ = _IMP_kernel.delete__Value

# Register _Value in _IMP_kernel:
_IMP_kernel._Value_swigregister(_Value)


def get_executable_name():
    r"""get_executable_name() -> std::string"""
    return _IMP_kernel.get_executable_name()

def setup_from_argv(*args):
    r"""
    setup_from_argv(IMP::Strings const & argv, std::string description)
    setup_from_argv(IMP::Strings const & argv, std::string description, std::string positional_description, int num_positional) -> IMP::Strings
    """
    return _IMP_kernel.setup_from_argv(*args)

def add_string_flag(name, default_value, description):
    r"""add_string_flag(std::string name, std::string default_value, std::string description)"""
    return _IMP_kernel.add_string_flag(name, default_value, description)

def get_string_flag(name):
    r"""get_string_flag(std::string name) -> std::string"""
    return _IMP_kernel.get_string_flag(name)

def add_int_flag(name, default_value, description):
    r"""add_int_flag(std::string name, size_t default_value, std::string description)"""
    return _IMP_kernel.add_int_flag(name, default_value, description)

def get_int_flag(name):
    r"""get_int_flag(std::string name) -> size_t"""
    return _IMP_kernel.get_int_flag(name)

def add_bool_flag(name, description):
    r"""add_bool_flag(std::string name, std::string description)"""
    return _IMP_kernel.add_bool_flag(name, description)

def get_bool_flag(name):
    r"""get_bool_flag(std::string name) -> bool"""
    return _IMP_kernel.get_bool_flag(name)

def add_float_flag(name, default_value, description):
    r"""add_float_flag(std::string name, double default_value, std::string description)"""
    return _IMP_kernel.add_float_flag(name, default_value, description)

def get_float_flag(name):
    r"""get_float_flag(std::string name) -> double"""
    return _IMP_kernel.get_float_flag(name)

def write_help(*args):
    r"""write_help(_ostream out=std::cerr)"""
    return _IMP_kernel.write_help(*args)

def get_is_quick_test():
    r"""get_is_quick_test() -> bool"""
    return _IMP_kernel.get_is_quick_test()
DEFAULT = _IMP_kernel.DEFAULT

SILENT = _IMP_kernel.SILENT

WARNING = _IMP_kernel.WARNING

PROGRESS = _IMP_kernel.PROGRESS

TERSE = _IMP_kernel.TERSE

VERBOSE = _IMP_kernel.VERBOSE

MEMORY = _IMP_kernel.MEMORY

ALL_LOG = _IMP_kernel.ALL_LOG

class VersionInfo(_Value):
    r"""Proxy of C++ IMP::VersionInfo class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(VersionInfo self, std::string module, std::string version) -> VersionInfo
        __init__(VersionInfo self) -> VersionInfo
        """
        _IMP_kernel.VersionInfo_swiginit(self, _IMP_kernel.new_VersionInfo(*args))

    def get_module(self):
        r"""get_module(VersionInfo self) -> std::string"""
        return _IMP_kernel.VersionInfo_get_module(self)

    def get_version(self):
        r"""get_version(VersionInfo self) -> std::string"""
        return _IMP_kernel.VersionInfo_get_version(self)

    def show(self, *args):
        r"""show(VersionInfo self, _ostream out=std::cout)"""
        return _IMP_kernel.VersionInfo_show(self, *args)

    def __cmp__(self, o):
        r"""__cmp__(VersionInfo self, VersionInfo o) -> int"""
        return _IMP_kernel.VersionInfo___cmp__(self, o)

    def __eq__(self, o):
        r"""__eq__(VersionInfo self, VersionInfo o) -> bool"""
        return _IMP_kernel.VersionInfo___eq__(self, o)

    def __ne__(self, o):
        r"""__ne__(VersionInfo self, VersionInfo o) -> bool"""
        return _IMP_kernel.VersionInfo___ne__(self, o)

    def __lt__(self, o):
        r"""__lt__(VersionInfo self, VersionInfo o) -> bool"""
        return _IMP_kernel.VersionInfo___lt__(self, o)

    def __gt__(self, o):
        r"""__gt__(VersionInfo self, VersionInfo o) -> bool"""
        return _IMP_kernel.VersionInfo___gt__(self, o)

    def __ge__(self, o):
        r"""__ge__(VersionInfo self, VersionInfo o) -> bool"""
        return _IMP_kernel.VersionInfo___ge__(self, o)

    def __le__(self, o):
        r"""__le__(VersionInfo self, VersionInfo o) -> bool"""
        return _IMP_kernel.VersionInfo___le__(self, o)

    def __str__(self):
        r"""__str__(VersionInfo self) -> std::string"""
        return _IMP_kernel.VersionInfo___str__(self)

    def __repr__(self):
        r"""__repr__(VersionInfo self) -> std::string"""
        return _IMP_kernel.VersionInfo___repr__(self)
    __swig_destroy__ = _IMP_kernel.delete_VersionInfo

# Register VersionInfo in _IMP_kernel:
_IMP_kernel.VersionInfo_swigregister(VersionInfo)

class TextOutput(_InputAdaptor):
    r"""Proxy of C++ IMP::TextOutput class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(TextOutput self, int arg2) -> TextOutput
        __init__(TextOutput self, double arg2) -> TextOutput
        __init__(TextOutput self, char const * c, bool append=False) -> TextOutput
        __init__(TextOutput self, IMP::TextProxy< std::ostream > p) -> TextOutput
        __init__(TextOutput self) -> TextOutput
        __init__(TextOutput self, std::string file_name, bool append=False) -> TextOutput
        """
        _IMP_kernel.TextOutput_swiginit(self, _IMP_kernel.new_TextOutput(*args))

    def show(self, *args):
        r"""show(TextOutput self, _ostream out=std::cout)"""
        return _IMP_kernel.TextOutput_show(self, *args)

    def get_name(self):
        r"""get_name(TextOutput self) -> std::string"""
        return _IMP_kernel.TextOutput_get_name(self)
    __swig_destroy__ = _IMP_kernel.delete_TextOutput

# Register TextOutput in _IMP_kernel:
_IMP_kernel.TextOutput_swigregister(TextOutput)

class TextInput(_InputAdaptor):
    r"""Proxy of C++ IMP::TextInput class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(TextInput self, int arg2) -> TextInput
        __init__(TextInput self, double arg2) -> TextInput
        __init__(TextInput self, char const * c) -> TextInput
        __init__(TextInput self, IMP::TextProxy< std::istream > p) -> TextInput
        __init__(TextInput self) -> TextInput
        __init__(TextInput self, std::string file_name) -> TextInput
        """
        _IMP_kernel.TextInput_swiginit(self, _IMP_kernel.new_TextInput(*args))

    def show(self, *args):
        r"""show(TextInput self, _ostream out=std::cout)"""
        return _IMP_kernel.TextInput_show(self, *args)

    def get_name(self):
        r"""get_name(TextInput self) -> std::string"""
        return _IMP_kernel.TextInput_get_name(self)
    __swig_destroy__ = _IMP_kernel.delete_TextInput

# Register TextInput in _IMP_kernel:
_IMP_kernel.TextInput_swigregister(TextInput)

class SetLogTarget(_RAII):
    r"""Proxy of C++ IMP::SetLogTarget class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(SetLogTarget self) -> SetLogTarget
        __init__(SetLogTarget self, TextOutput to) -> SetLogTarget
        """
        _IMP_kernel.SetLogTarget_swiginit(self, _IMP_kernel.new_SetLogTarget(*args))

    def set(self, to):
        r"""set(SetLogTarget self, TextOutput to)"""
        return _IMP_kernel.SetLogTarget_set(self, to)

    def reset(self):
        r"""reset(SetLogTarget self)"""
        return _IMP_kernel.SetLogTarget_reset(self)
    __swig_destroy__ = _IMP_kernel.delete_SetLogTarget

    def show(self, *args):
        r"""show(SetLogTarget self, _ostream out=std::cout)"""
        return _IMP_kernel.SetLogTarget_show(self, *args)

    def __enter__(self):
        return self
    def __exit__(self, exc_type, exc_val, exc_tb):
        self.reset()
        return False


    def __str__(self):
        r"""__str__(SetLogTarget self) -> std::string"""
        return _IMP_kernel.SetLogTarget___str__(self)

    def __repr__(self):
        r"""__repr__(SetLogTarget self) -> std::string"""
        return _IMP_kernel.SetLogTarget___repr__(self)

# Register SetLogTarget in _IMP_kernel:
_IMP_kernel.SetLogTarget_swigregister(SetLogTarget)


def create_temporary_file(*args):
    r"""create_temporary_file(std::string prefix="imp_temp", std::string suffix="") -> TextOutput"""
    return _IMP_kernel.create_temporary_file(*args)

def create_temporary_file_name(*args):
    r"""create_temporary_file_name(std::string prefix="imp_temp", std::string suffix="") -> std::string"""
    return _IMP_kernel.create_temporary_file_name(*args)

def get_relative_path(base, relative):
    r"""get_relative_path(std::string base, std::string relative) -> std::string"""
    return _IMP_kernel.get_relative_path(base, relative)

def get_absolute_path(file):
    r"""get_absolute_path(std::string file) -> std::string"""
    return _IMP_kernel.get_absolute_path(file)

def push_log_context(functionname, object):
    r"""push_log_context(char const * functionname, void const * object)"""
    return _IMP_kernel.push_log_context(functionname, object)

def pop_log_context():
    r"""pop_log_context()"""
    return _IMP_kernel.pop_log_context()

def add_to_log(*args):
    r"""
    add_to_log(std::string to_write)
    add_to_log(IMP::LogLevel level, std::string to_write)
    """
    return _IMP_kernel.add_to_log(*args)

def set_log_level(l):
    r"""set_log_level(IMP::LogLevel l)"""
    return _IMP_kernel.set_log_level(l)

def set_log_timer(tb):
    r"""set_log_timer(bool tb)"""
    return _IMP_kernel.set_log_timer(tb)

def reset_log_timer():
    r"""reset_log_timer()"""
    return _IMP_kernel.reset_log_timer()

def get_log_level():
    r"""get_log_level() -> IMP::LogLevel"""
    return _IMP_kernel.get_log_level()

def set_progress_display(description, steps):
    r"""set_progress_display(std::string description, unsigned int steps)"""
    return _IMP_kernel.set_progress_display(description, steps)

def add_to_progress_display(step=1):
    r"""add_to_progress_display(unsigned int step=1)"""
    return _IMP_kernel.add_to_progress_display(step)
class Object(_NonCopyable):
    r"""Proxy of C++ IMP::Object class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, name):
        r"""__init__(Object self, std::string name) -> Object"""
        if self.__class__ == Object:
            _self = None
        else:
            _self = self
        _IMP_kernel.Object_swiginit(self, _IMP_kernel.new_Object(_self, name))

        if self.__class__ != Object:
            _director_objects.register(self)



    __swig_destroy__ = _IMP_kernel.delete_Object

    def __hash__(self):
        r"""__hash__(Object self) -> std::size_t"""
        return _IMP_kernel.Object___hash__(self)

    def set_log_level(self, l):
        r"""set_log_level(Object self, IMP::LogLevel l)"""
        return _IMP_kernel.Object_set_log_level(self, l)

    def set_check_level(self, l):
        r"""set_check_level(Object self, IMP::CheckLevel l)"""
        return _IMP_kernel.Object_set_check_level(self, l)

    def get_log_level(self):
        r"""get_log_level(Object self) -> IMP::LogLevel"""
        return _IMP_kernel.Object_get_log_level(self)

    def get_check_level(self):
        r"""get_check_level(Object self) -> IMP::CheckLevel"""
        return _IMP_kernel.Object_get_check_level(self)

    def get_version_info(self):
        r"""get_version_info(Object self) -> VersionInfo"""
        return _IMP_kernel.Object_get_version_info(self)

    def get_name(self):
        r"""get_name(Object self) -> std::string const &"""
        return _IMP_kernel.Object_get_name(self)

    def set_name(self, name):
        r"""set_name(Object self, std::string name)"""
        return _IMP_kernel.Object_set_name(self, name)

    def get_type_name(self):
        r"""get_type_name(Object self) -> std::string"""
        return _IMP_kernel.Object_get_type_name(self)

    def set_was_used(self, tf):
        r"""set_was_used(Object self, bool tf)"""
        return _IMP_kernel.Object_set_was_used(self, tf)

    def show(self, *args):
        r"""show(Object self, _ostream out=std::cout)"""
        return _IMP_kernel.Object_show(self, *args)

    def get_string(self):
        r"""get_string(Object self) -> std::string"""
        return _IMP_kernel.Object_get_string(self)

    def _on_destruction(self):
        r"""_on_destruction(Object self)"""
        return _IMP_kernel.Object__on_destruction(self)

    def get_is_valid(self):
        r"""get_is_valid(Object self) -> bool"""
        return _IMP_kernel.Object_get_is_valid(self)

    def get_ref_count(self):
        r"""get_ref_count(Object self) -> unsigned int"""
        return _IMP_kernel.Object_get_ref_count(self)

    @staticmethod
    def get_number_of_live_objects():
        r"""get_number_of_live_objects() -> unsigned int"""
        return _IMP_kernel.Object_get_number_of_live_objects()

    def get_is_shared(self):
        r"""get_is_shared(Object self) -> bool"""
        return _IMP_kernel.Object_get_is_shared(self)

    def clear_caches(self):
        r"""clear_caches(Object self)"""
        return _IMP_kernel.Object_clear_caches(self)

    def do_destroy(self):
        r"""do_destroy(Object self)"""
        return _IMP_kernel.Object_do_destroy(self)

    def __eq__(self, o):
        r"""__eq__(Object self, Object o) -> bool"""
        return _IMP_kernel.Object___eq__(self, o)

    def __ne__(self, o):
        r"""__ne__(Object self, Object o) -> bool"""
        return _IMP_kernel.Object___ne__(self, o)

    def __le__(self, o):
        r"""__le__(Object self, Object o) -> bool"""
        return _IMP_kernel.Object___le__(self, o)

    def __lt__(self, o):
        r"""__lt__(Object self, Object o) -> bool"""
        return _IMP_kernel.Object___lt__(self, o)

    def __ge__(self, o):
        r"""__ge__(Object self, Object o) -> bool"""
        return _IMP_kernel.Object___ge__(self, o)

    def __gt__(self, o):
        r"""__gt__(Object self, Object o) -> bool"""
        return _IMP_kernel.Object___gt__(self, o)

    def __str__(self):
        r"""__str__(Object self) -> std::string"""
        return _IMP_kernel.Object___str__(self)

    def __repr__(self):
        r"""__repr__(Object self) -> std::string"""
        return _IMP_kernel.Object___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_Object(o)

    def __disown__(self):
        self.this.disown()
        _IMP_kernel.disown_Object(self)
        return weakref.proxy(self)

# Register Object in _IMP_kernel:
_IMP_kernel.Object_swigregister(Object)

def Object_get_number_of_live_objects():
    r"""Object_get_number_of_live_objects() -> unsigned int"""
    return _IMP_kernel.Object_get_number_of_live_objects()

class SetLogState(_RAII):
    r"""Proxy of C++ IMP::SetLogState class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def reset(self):
        r"""reset(SetLogState self)"""
        return _IMP_kernel.SetLogState_reset(self)
    __swig_destroy__ = _IMP_kernel.delete_SetLogState

    def show(self, *args):
        r"""show(SetLogState self, _ostream out=std::cout)"""
        return _IMP_kernel.SetLogState_show(self, *args)

    def __init__(self, *args):
        r"""
        __init__(SetLogState self) -> SetLogState
        __init__(SetLogState self, Object o, IMP::LogLevel l) -> SetLogState
        __init__(SetLogState self, IMP::LogLevel l) -> SetLogState
        """
        _IMP_kernel.SetLogState_swiginit(self, _IMP_kernel.new_SetLogState(*args))

    def set(self, *args):
        r"""
        set(SetLogState self, Object o, IMP::LogLevel l)
        set(SetLogState self, IMP::LogLevel l)
        """
        return _IMP_kernel.SetLogState_set(self, *args)

    def __enter__(self):
        return self
    def __exit__(self, exc_type, exc_val, exc_tb):
        self.reset()
        return False


    def __str__(self):
        r"""__str__(SetLogState self) -> std::string"""
        return _IMP_kernel.SetLogState___str__(self)

    def __repr__(self):
        r"""__repr__(SetLogState self) -> std::string"""
        return _IMP_kernel.SetLogState___repr__(self)

# Register SetLogState in _IMP_kernel:
_IMP_kernel.SetLogState_swigregister(SetLogState)

class WarningContext(object):
    r"""Proxy of C++ IMP::WarningContext class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    data_ = property(_IMP_kernel.WarningContext_data__get, _IMP_kernel.WarningContext_data__set, doc=r"""data_ : boost::unordered_set<(std::string)>""")

    def add_warning(self, key, warning):
        r"""add_warning(WarningContext self, std::string key, std::string warning)"""
        return _IMP_kernel.WarningContext_add_warning(self, key, warning)

    def clear_warnings(self):
        r"""clear_warnings(WarningContext self)"""
        return _IMP_kernel.WarningContext_clear_warnings(self)

    def dump_warnings(self):
        r"""dump_warnings(WarningContext self)"""
        return _IMP_kernel.WarningContext_dump_warnings(self)
    __swig_destroy__ = _IMP_kernel.delete_WarningContext

    def show(self, *args):
        r"""show(WarningContext self, _ostream out=std::cout)"""
        return _IMP_kernel.WarningContext_show(self, *args)

    def __enter__(self):
        return self
    def __exit__(self, exc_type, exc_val, exc_tb):
        self.reset()
        return False


    def __str__(self):
        r"""__str__(WarningContext self) -> std::string"""
        return _IMP_kernel.WarningContext___str__(self)

    def __repr__(self):
        r"""__repr__(WarningContext self) -> std::string"""
        return _IMP_kernel.WarningContext___repr__(self)

    def __init__(self):
        r"""__init__(WarningContext self) -> WarningContext"""
        _IMP_kernel.WarningContext_swiginit(self, _IMP_kernel.new_WarningContext())

# Register WarningContext in _IMP_kernel:
_IMP_kernel.WarningContext_swigregister(WarningContext)

class CreateLogContext(_RAII):
    r"""Proxy of C++ IMP::CreateLogContext class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(CreateLogContext self, std::string fname, Object object=None) -> CreateLogContext
        __init__(CreateLogContext self) -> CreateLogContext
        __init__(CreateLogContext self, char const * fname, Object object=None) -> CreateLogContext
        """
        _IMP_kernel.CreateLogContext_swiginit(self, _IMP_kernel.new_CreateLogContext(*args))

    def set(self, fname, object=None):
        r"""set(CreateLogContext self, char const * fname, Object object=None)"""
        return _IMP_kernel.CreateLogContext_set(self, fname, object)

    def reset(self):
        r"""reset(CreateLogContext self)"""
        return _IMP_kernel.CreateLogContext_reset(self)
    __swig_destroy__ = _IMP_kernel.delete_CreateLogContext

    def show(self, *args):
        r"""show(CreateLogContext self, _ostream out=std::cout)"""
        return _IMP_kernel.CreateLogContext_show(self, *args)

    def __enter__(self):
        return self
    def __exit__(self, exc_type, exc_val, exc_tb):
        self.reset()
        return False


    def __str__(self):
        r"""__str__(CreateLogContext self) -> std::string"""
        return _IMP_kernel.CreateLogContext___str__(self)

    def __repr__(self):
        r"""__repr__(CreateLogContext self) -> std::string"""
        return _IMP_kernel.CreateLogContext___repr__(self)

# Register CreateLogContext in _IMP_kernel:
_IMP_kernel.CreateLogContext_swigregister(CreateLogContext)

class SetCheckState(_RAII):
    r"""Proxy of C++ IMP::SetCheckState class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def reset(self):
        r"""reset(SetCheckState self)"""
        return _IMP_kernel.SetCheckState_reset(self)
    __swig_destroy__ = _IMP_kernel.delete_SetCheckState

    def show(self, *args):
        r"""show(SetCheckState self, _ostream out=std::cout)"""
        return _IMP_kernel.SetCheckState_show(self, *args)

    def __init__(self, *args):
        r"""
        __init__(SetCheckState self) -> SetCheckState
        __init__(SetCheckState self, Object o, IMP::CheckLevel l) -> SetCheckState
        __init__(SetCheckState self, IMP::CheckLevel l) -> SetCheckState
        """
        _IMP_kernel.SetCheckState_swiginit(self, _IMP_kernel.new_SetCheckState(*args))

    def set(self, *args):
        r"""
        set(SetCheckState self, Object o, IMP::CheckLevel l)
        set(SetCheckState self, IMP::CheckLevel l)
        """
        return _IMP_kernel.SetCheckState_set(self, *args)

    def __enter__(self):
        return self
    def __exit__(self, exc_type, exc_val, exc_tb):
        self.reset()
        return False


    def __str__(self):
        r"""__str__(SetCheckState self) -> std::string"""
        return _IMP_kernel.SetCheckState___str__(self)

    def __repr__(self):
        r"""__repr__(SetCheckState self) -> std::string"""
        return _IMP_kernel.SetCheckState___repr__(self)

# Register SetCheckState in _IMP_kernel:
_IMP_kernel.SetCheckState_swigregister(SetCheckState)


def get_unique_name(templ):
    r"""get_unique_name(std::string templ) -> std::string"""
    return _IMP_kernel.get_unique_name(templ)
class _Protection(object):
    r"""Proxy of C++ IMP::internal::_Protection class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")

    def show(self, *args):
        r"""show(_Protection self, _ostream out=std::cout)"""
        return _IMP_kernel._Protection_show(self, *args)

    def __str__(self):
        r"""__str__(_Protection self) -> std::string"""
        return _IMP_kernel._Protection___str__(self)

    def __repr__(self):
        r"""__repr__(_Protection self) -> std::string"""
        return _IMP_kernel._Protection___repr__(self)
    __swig_destroy__ = _IMP_kernel.delete__Protection

# Register _Protection in _IMP_kernel:
_IMP_kernel._Protection_swigregister(_Protection)


def _test_log():
    r"""_test_log()"""
    return _IMP_kernel._test_log()

def _test_intranges(ips):
    r"""_test_intranges(IMP::IntRanges const & ips) -> int"""
    return _IMP_kernel._test_intranges(ips)

def _test_intrange(*args):
    r"""
    _test_intrange(IMP::IntRange const & ips) -> IMP::IntRange
    _test_intrange() -> IMP::IntRange
    """
    return _IMP_kernel._test_intrange(*args)

def _test_ifile(a):
    r"""_test_ifile(TextInput a) -> std::string"""
    return _IMP_kernel._test_ifile(a)

def _test_ofile(a):
    r"""_test_ofile(TextOutput a) -> std::string"""
    return _IMP_kernel._test_ofile(a)

def _test_ifile_overloaded(*args):
    r"""
    _test_ifile_overloaded(TextInput a, int i) -> std::string
    _test_ifile_overloaded(TextInput a, std::string st) -> std::string
    """
    return _IMP_kernel._test_ifile_overloaded(*args)

def _test_ofile_overloaded(*args):
    r"""
    _test_ofile_overloaded(TextOutput a, int i) -> std::string
    _test_ofile_overloaded(TextOutput a, std::string st) -> std::string
    """
    return _IMP_kernel._test_ofile_overloaded(*args)
class _TestValue(object):
    r"""Proxy of C++ IMP::internal::_TestValue class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, i):
        r"""__init__(_TestValue self, int i) -> _TestValue"""
        _IMP_kernel._TestValue_swiginit(self, _IMP_kernel.new__TestValue(i))

    def show(self, *args):
        r"""show(_TestValue self, _ostream out=std::cout)"""
        return _IMP_kernel._TestValue_show(self, *args)

    def __cmp__(self, o):
        r"""__cmp__(_TestValue self, _TestValue o) -> int"""
        return _IMP_kernel._TestValue___cmp__(self, o)

    def __eq__(self, o):
        r"""__eq__(_TestValue self, _TestValue o) -> bool"""
        return _IMP_kernel._TestValue___eq__(self, o)

    def __ne__(self, o):
        r"""__ne__(_TestValue self, _TestValue o) -> bool"""
        return _IMP_kernel._TestValue___ne__(self, o)

    def __lt__(self, o):
        r"""__lt__(_TestValue self, _TestValue o) -> bool"""
        return _IMP_kernel._TestValue___lt__(self, o)

    def __gt__(self, o):
        r"""__gt__(_TestValue self, _TestValue o) -> bool"""
        return _IMP_kernel._TestValue___gt__(self, o)

    def __ge__(self, o):
        r"""__ge__(_TestValue self, _TestValue o) -> bool"""
        return _IMP_kernel._TestValue___ge__(self, o)

    def __le__(self, o):
        r"""__le__(_TestValue self, _TestValue o) -> bool"""
        return _IMP_kernel._TestValue___le__(self, o)

    def get(self):
        r"""get(_TestValue self) -> int"""
        return _IMP_kernel._TestValue_get(self)

    def get_float(self):
        r"""get_float(_TestValue self) -> float const &"""
        return _IMP_kernel._TestValue_get_float(self)

    def get_double(self):
        r"""get_double(_TestValue self) -> double const &"""
        return _IMP_kernel._TestValue_get_double(self)

    def get_Float(self):
        r"""get_Float(_TestValue self) -> IMP::Float const &"""
        return _IMP_kernel._TestValue_get_Float(self)

    def get_int(self):
        r"""get_int(_TestValue self) -> int const &"""
        return _IMP_kernel._TestValue_get_int(self)

    def get_Int(self):
        r"""get_Int(_TestValue self) -> IMP::Int const &"""
        return _IMP_kernel._TestValue_get_Int(self)

    def get_string(self):
        r"""get_string(_TestValue self) -> std::string const &"""
        return _IMP_kernel._TestValue_get_string(self)

    def get_String(self):
        r"""get_String(_TestValue self) -> IMP::String const &"""
        return _IMP_kernel._TestValue_get_String(self)

    def __str__(self):
        r"""__str__(_TestValue self) -> std::string"""
        return _IMP_kernel._TestValue___str__(self)

    def __repr__(self):
        r"""__repr__(_TestValue self) -> std::string"""
        return _IMP_kernel._TestValue___repr__(self)
    __swig_destroy__ = _IMP_kernel.delete__TestValue

# Register _TestValue in _IMP_kernel:
_IMP_kernel._TestValue_swigregister(_TestValue)


def _pass_plain_pair(p):
    r"""_pass_plain_pair(IMP::FloatPair p) -> IMP::FloatPair"""
    return _IMP_kernel._pass_plain_pair(p)

def _pass_overloaded_strings(*args):
    r"""
    _pass_overloaded_strings(IMP::Strings const & a, int arg2) -> IMP::Strings
    _pass_overloaded_strings(IMP::Strings const & a) -> IMP::Strings
    """
    return _IMP_kernel._pass_overloaded_strings(*args)

def _pass_pair(p):
    r"""_pass_pair(IMP::DerivativePair const & p) -> IMP::DerivativePair"""
    return _IMP_kernel._pass_pair(p)

def _pass_floats(input):
    r"""_pass_floats(IMP::Floats const & input) -> IMP::Floats"""
    return _IMP_kernel._pass_floats(input)

def _pass_ints(input):
    r"""_pass_ints(IMP::Ints input) -> IMP::Ints"""
    return _IMP_kernel._pass_ints(input)

def _pass_ints_list(input):
    r"""_pass_ints_list(IMP::IntsList const & input) -> IMP::IntsList"""
    return _IMP_kernel._pass_ints_list(input)

def _pass_ints_lists(input):
    r"""_pass_ints_lists(IMP::IntsLists const & input) -> IMP::IntsLists"""
    return _IMP_kernel._pass_ints_lists(input)

def _pass_strings(input):
    r"""_pass_strings(IMP::Strings const & input) -> IMP::Strings const &"""
    return _IMP_kernel._pass_strings(input)
class _TestObject(Object):
    r"""Proxy of C++ IMP::internal::_TestObject class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self):
        r"""__init__(_TestObject self) -> _TestObject"""
        _IMP_kernel._TestObject_swiginit(self, _IMP_kernel.new__TestObject())

    def get_version_info(self):
        r"""get_version_info(_TestObject self) -> VersionInfo"""
        return _IMP_kernel._TestObject_get_version_info(self)

    def __str__(self):
        r"""__str__(_TestObject self) -> std::string"""
        return _IMP_kernel._TestObject___str__(self)

    def __repr__(self):
        r"""__repr__(_TestObject self) -> std::string"""
        return _IMP_kernel._TestObject___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to__TestObject(o)


# Register _TestObject in _IMP_kernel:
_IMP_kernel._TestObject_swigregister(_TestObject)


def get_live_object_names():
    r"""get_live_object_names() -> IMP::Strings"""
    return _IMP_kernel.get_live_object_names()

def get_live_objects():
    r"""get_live_objects() -> IMP::Objects"""
    return _IMP_kernel.get_live_objects()

def set_show_leaked_objects(tf):
    r"""set_show_leaked_objects(bool tf)"""
    return _IMP_kernel.set_show_leaked_objects(tf)

def set_deprecation_warnings(tf):
    r"""set_deprecation_warnings(bool tf)"""
    return _IMP_kernel.set_deprecation_warnings(tf)

def set_deprecation_exceptions(tf):
    r"""set_deprecation_exceptions(bool tf)"""
    return _IMP_kernel.set_deprecation_exceptions(tf)

def get_deprecation_exceptions():
    r"""get_deprecation_exceptions() -> bool"""
    return _IMP_kernel.get_deprecation_exceptions()

def handle_use_deprecated(message):
    r"""handle_use_deprecated(std::string message)"""
    return _IMP_kernel.handle_use_deprecated(message)

def get_number_of_threads():
    r"""get_number_of_threads() -> unsigned int"""
    return _IMP_kernel.get_number_of_threads()

def set_number_of_threads(n):
    r"""set_number_of_threads(unsigned int n)"""
    return _IMP_kernel.set_number_of_threads(n)
class SetNumberOfThreads(_RAII):
    r"""Proxy of C++ IMP::SetNumberOfThreads class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(SetNumberOfThreads self) -> SetNumberOfThreads
        __init__(SetNumberOfThreads self, unsigned int n) -> SetNumberOfThreads
        """
        _IMP_kernel.SetNumberOfThreads_swiginit(self, _IMP_kernel.new_SetNumberOfThreads(*args))

    def set(self, n):
        r"""set(SetNumberOfThreads self, unsigned int n)"""
        return _IMP_kernel.SetNumberOfThreads_set(self, n)

    def reset(self):
        r"""reset(SetNumberOfThreads self)"""
        return _IMP_kernel.SetNumberOfThreads_reset(self)
    __swig_destroy__ = _IMP_kernel.delete_SetNumberOfThreads

    def show(self, *args):
        r"""show(SetNumberOfThreads self, _ostream out=std::cout)"""
        return _IMP_kernel.SetNumberOfThreads_show(self, *args)

    def __enter__(self):
        return self
    def __exit__(self, exc_type, exc_val, exc_tb):
        self.reset()
        return False


    def __str__(self):
        r"""__str__(SetNumberOfThreads self) -> std::string"""
        return _IMP_kernel.SetNumberOfThreads___str__(self)

    def __repr__(self):
        r"""__repr__(SetNumberOfThreads self) -> std::string"""
        return _IMP_kernel.SetNumberOfThreads___repr__(self)

# Register SetNumberOfThreads in _IMP_kernel:
_IMP_kernel.SetNumberOfThreads_swigregister(SetNumberOfThreads)


import os
i_m_p="IMP_MODULE_PATH"
if i_m_p in os.environ.keys():
  __path__.insert(0, os.environ[i_m_p])

def _forward_add_attribute(self, name, value, opt=None):
    if opt is not None:
        self.get_particle().add_attribute(name, value, opt)
    else:
        self.get_particle().add_attribute(name, value)
def _forward_get_value(self, name):
    self.get_particle().get_value(name)
def _forward_set_value(self, name, value):
    self.get_particle().set_value(name, value)


build="release"


_object_types.append("Constraint")


def _object_cast_to_Constraint(o):
    r"""_object_cast_to_Constraint(Object o) -> Constraint"""
    return _IMP_kernel._object_cast_to_Constraint(o)

_object_types.append("Undecorator")


def _object_cast_to_Undecorator(o):
    r"""_object_cast_to_Undecorator(Object o) -> Undecorator"""
    return _IMP_kernel._object_cast_to_Undecorator(o)

_object_types.append("Container")


def _object_cast_to_Container(o):
    r"""_object_cast_to_Container(Object o) -> Container"""
    return _IMP_kernel._object_cast_to_Container(o)

_object_types.append("Optimizer")


def _object_cast_to_Optimizer(o):
    r"""_object_cast_to_Optimizer(Object o) -> Optimizer"""
    return _IMP_kernel._object_cast_to_Optimizer(o)

_object_types.append("AttributeOptimizer")


def _object_cast_to_AttributeOptimizer(o):
    r"""_object_cast_to_AttributeOptimizer(Object o) -> AttributeOptimizer"""
    return _IMP_kernel._object_cast_to_AttributeOptimizer(o)

_object_types.append("OptimizerState")


def _object_cast_to_OptimizerState(o):
    r"""_object_cast_to_OptimizerState(Object o) -> OptimizerState"""
    return _IMP_kernel._object_cast_to_OptimizerState(o)

_object_types.append("PairContainer")


def _object_cast_to_PairContainer(o):
    r"""_object_cast_to_PairContainer(Object o) -> PairContainer"""
    return _IMP_kernel._object_cast_to_PairContainer(o)

_object_types.append("PairModifier")


def _object_cast_to_PairModifier(o):
    r"""_object_cast_to_PairModifier(Object o) -> PairModifier"""
    return _IMP_kernel._object_cast_to_PairModifier(o)

_object_types.append("PairScore")


def _object_cast_to_PairScore(o):
    r"""_object_cast_to_PairScore(Object o) -> PairScore"""
    return _IMP_kernel._object_cast_to_PairScore(o)

_object_types.append("QuadContainer")


def _object_cast_to_QuadContainer(o):
    r"""_object_cast_to_QuadContainer(Object o) -> QuadContainer"""
    return _IMP_kernel._object_cast_to_QuadContainer(o)

_object_types.append("QuadModifier")


def _object_cast_to_QuadModifier(o):
    r"""_object_cast_to_QuadModifier(Object o) -> QuadModifier"""
    return _IMP_kernel._object_cast_to_QuadModifier(o)

_object_types.append("QuadScore")


def _object_cast_to_QuadScore(o):
    r"""_object_cast_to_QuadScore(Object o) -> QuadScore"""
    return _IMP_kernel._object_cast_to_QuadScore(o)

_object_types.append("Refiner")


def _object_cast_to_Refiner(o):
    r"""_object_cast_to_Refiner(Object o) -> Refiner"""
    return _IMP_kernel._object_cast_to_Refiner(o)

_object_types.append("Restraint")


def _object_cast_to_Restraint(o):
    r"""_object_cast_to_Restraint(Object o) -> Restraint"""
    return _IMP_kernel._object_cast_to_Restraint(o)

_object_types.append("Sampler")


def _object_cast_to_Sampler(o):
    r"""_object_cast_to_Sampler(Object o) -> Sampler"""
    return _IMP_kernel._object_cast_to_Sampler(o)

_object_types.append("ScoreState")


def _object_cast_to_ScoreState(o):
    r"""_object_cast_to_ScoreState(Object o) -> ScoreState"""
    return _IMP_kernel._object_cast_to_ScoreState(o)

_object_types.append("SingletonContainer")


def _object_cast_to_SingletonContainer(o):
    r"""_object_cast_to_SingletonContainer(Object o) -> SingletonContainer"""
    return _IMP_kernel._object_cast_to_SingletonContainer(o)

_object_types.append("SingletonModifier")


def _object_cast_to_SingletonModifier(o):
    r"""_object_cast_to_SingletonModifier(Object o) -> SingletonModifier"""
    return _IMP_kernel._object_cast_to_SingletonModifier(o)

_object_types.append("SingletonScore")


def _object_cast_to_SingletonScore(o):
    r"""_object_cast_to_SingletonScore(Object o) -> SingletonScore"""
    return _IMP_kernel._object_cast_to_SingletonScore(o)

_object_types.append("TripletContainer")


def _object_cast_to_TripletContainer(o):
    r"""_object_cast_to_TripletContainer(Object o) -> TripletContainer"""
    return _IMP_kernel._object_cast_to_TripletContainer(o)

_object_types.append("TripletModifier")


def _object_cast_to_TripletModifier(o):
    r"""_object_cast_to_TripletModifier(Object o) -> TripletModifier"""
    return _IMP_kernel._object_cast_to_TripletModifier(o)

_object_types.append("TripletScore")


def _object_cast_to_TripletScore(o):
    r"""_object_cast_to_TripletScore(Object o) -> TripletScore"""
    return _IMP_kernel._object_cast_to_TripletScore(o)

_object_types.append("UnaryFunction")


def _object_cast_to_UnaryFunction(o):
    r"""_object_cast_to_UnaryFunction(Object o) -> UnaryFunction"""
    return _IMP_kernel._object_cast_to_UnaryFunction(o)

_object_types.append("RestraintInfo")


def _object_cast_to_RestraintInfo(o):
    r"""_object_cast_to_RestraintInfo(Object o) -> RestraintInfo"""
    return _IMP_kernel._object_cast_to_RestraintInfo(o)

_object_types.append("ConfigurationSet")


def _object_cast_to_ConfigurationSet(o):
    r"""_object_cast_to_ConfigurationSet(Object o) -> ConfigurationSet"""
    return _IMP_kernel._object_cast_to_ConfigurationSet(o)

_object_types.append("Configuration")


def _object_cast_to_Configuration(o):
    r"""_object_cast_to_Configuration(Object o) -> Configuration"""
    return _IMP_kernel._object_cast_to_Configuration(o)

_object_types.append("Model")


def _object_cast_to_Model(o):
    r"""_object_cast_to_Model(Object o) -> Model"""
    return _IMP_kernel._object_cast_to_Model(o)

_object_types.append("Particle")


def _object_cast_to_Particle(o):
    r"""_object_cast_to_Particle(Object o) -> Particle"""
    return _IMP_kernel._object_cast_to_Particle(o)

_object_types.append("RestraintSet")


def _object_cast_to_RestraintSet(o):
    r"""_object_cast_to_RestraintSet(Object o) -> RestraintSet"""
    return _IMP_kernel._object_cast_to_RestraintSet(o)

ParticlePairsTemp=list
_plural_types.append("ParticlePairsTemp")
_value_types.append("ParticlePair")


ParticleTripletsTemp=list
_plural_types.append("ParticleTripletsTemp")
_value_types.append("ParticleTriplet")


ParticleQuadsTemp=list
_plural_types.append("ParticleQuadsTemp")
_value_types.append("ParticleQuad")


ParticleIndexPairs=list
_plural_types.append("ParticleIndexPairs")
_value_types.append("ParticleIndexPair")


ParticleIndexTriplets=list
_plural_types.append("ParticleIndexTriplets")
_value_types.append("ParticleIndexTriplet")


ParticleIndexQuads=list
_plural_types.append("ParticleIndexQuads")
_value_types.append("ParticleIndexQuad")


_object_types.append("SingletonPredicate")


def _object_cast_to_SingletonPredicate(o):
    r"""_object_cast_to_SingletonPredicate(Object o) -> SingletonPredicate"""
    return _IMP_kernel._object_cast_to_SingletonPredicate(o)

_object_types.append("PairPredicate")


def _object_cast_to_PairPredicate(o):
    r"""_object_cast_to_PairPredicate(Object o) -> PairPredicate"""
    return _IMP_kernel._object_cast_to_PairPredicate(o)

_object_types.append("TripletPredicate")


def _object_cast_to_TripletPredicate(o):
    r"""_object_cast_to_TripletPredicate(Object o) -> TripletPredicate"""
    return _IMP_kernel._object_cast_to_TripletPredicate(o)

_object_types.append("QuadPredicate")


def _object_cast_to_QuadPredicate(o):
    r"""_object_cast_to_QuadPredicate(Object o) -> QuadPredicate"""
    return _IMP_kernel._object_cast_to_QuadPredicate(o)

_object_types.append("SaveToConfigurationSetOptimizerState")


def _object_cast_to_SaveToConfigurationSetOptimizerState(o):
    r"""_object_cast_to_SaveToConfigurationSetOptimizerState(Object o) -> SaveToConfigurationSetOptimizerState"""
    return _IMP_kernel._object_cast_to_SaveToConfigurationSetOptimizerState(o)

EvaluationStates=list
_plural_types.append("EvaluationStates")
_value_types.append("EvaluationState")


ScoreAccumulators=list
_plural_types.append("ScoreAccumulators")
_value_types.append("ScoreAccumulator")


ParticleIndexes=list
_plural_types.append("ParticleIndexes")
_value_types.append("ParticleIndex")


FloatIndexes=list
_plural_types.append("FloatIndexes")
_value_types.append("FloatIndex")


FloatKeys=list
_plural_types.append("FloatKeys")
_value_types.append("FloatKey")


FloatsKeys=list
_plural_types.append("FloatsKeys")
_value_types.append("FloatsKey")


IntKeys=list
_plural_types.append("IntKeys")
_value_types.append("IntKey")


IntsKeys=list
_plural_types.append("IntsKeys")
_value_types.append("IntsKey")


StringKeys=list
_plural_types.append("StringKeys")
_value_types.append("StringKey")


ParticleIndexKeys=list
_plural_types.append("ParticleIndexKeys")
_value_types.append("ParticleIndexKey")


ParticleIndexesKeys=list
_plural_types.append("ParticleIndexesKeys")
_value_types.append("ParticleIndexesKey")


ObjectKeys=list
_plural_types.append("ObjectKeys")
_value_types.append("ObjectKey")


ModelKeys=list
_plural_types.append("ModelKeys")
_value_types.append("ModelKey")


TriggerKeys=list
_plural_types.append("TriggerKeys")
_value_types.append("TriggerKey")


_raii_types.append("ScopedSetFloatAttribute")


_object_types.append("ScoringFunction")


def _object_cast_to_ScoringFunction(o):
    r"""_object_cast_to_ScoringFunction(Object o) -> ScoringFunction"""
    return _IMP_kernel._object_cast_to_ScoringFunction(o)

_object_types.append("ModelObject")


def _object_cast_to_ModelObject(o):
    r"""_object_cast_to_ModelObject(Object o) -> ModelObject"""
    return _IMP_kernel._object_cast_to_ModelObject(o)

def _TrivialDecorators(l=[]):
    return [_TrivialDecorator(x) for x in l]
_plural_types.append("_TrivialDecorators")


_value_types.append("_TrivialDecorator")


def _TrivialDerivedDecorators(l=[]):
    return [_TrivialDerivedDecorator(x) for x in l]
_plural_types.append("_TrivialDerivedDecorators")


_value_types.append("_TrivialDerivedDecorator")


def _TrivialTraitsDecorators(l=[]):
    return [_TrivialTraitsDecorator(x) for x in l]
_plural_types.append("_TrivialTraitsDecorators")


_value_types.append("_TrivialTraitsDecorator")


_object_types.append("_ConstRestraint")


def _object_cast_to__ConstRestraint(o):
    r"""_object_cast_to__ConstRestraint(Object o) -> _ConstRestraint"""
    return _IMP_kernel._object_cast_to__ConstRestraint(o)

_object_types.append("_ConstOptimizer")


def _object_cast_to__ConstOptimizer(o):
    r"""_object_cast_to__ConstOptimizer(Object o) -> _ConstOptimizer"""
    return _IMP_kernel._object_cast_to__ConstOptimizer(o)
class DependencyGraph(Object):
    r"""Proxy of C++ IMP::internal::BoostDigraph< IMP::DependencyGraph,IMP::ModelObject *,IMP::ShowDependencyGraphVertex > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""__init__(DependencyGraph self) -> DependencyGraph"""
        _IMP_kernel.DependencyGraph_swiginit(self, _IMP_kernel.new_DependencyGraph())

    def get_graph(self):
        r"""get_graph(DependencyGraph self) -> IMP::DependencyGraph const &"""
        return _IMP_kernel.DependencyGraph_get_graph(self)

    def get_vertices(self):
        r"""get_vertices(DependencyGraph self) -> IMP::internal::BoostDigraph< IMP::DependencyGraph,IMP::ModelObject *,IMP::ShowDependencyGraphVertex >::VertexDescriptors"""
        return _IMP_kernel.DependencyGraph_get_vertices(self)

    def get_vertex_name(self, i):
        r"""get_vertex_name(DependencyGraph self, IMP::internal::BoostDigraph< IMP::DependencyGraph,IMP::ModelObject *,IMP::ShowDependencyGraphVertex >::VertexDescriptor i) -> ModelObject"""
        return _IMP_kernel.DependencyGraph_get_vertex_name(self, i)

    def get_in_neighbors(self, v):
        r"""get_in_neighbors(DependencyGraph self, IMP::internal::BoostDigraph< IMP::DependencyGraph,IMP::ModelObject *,IMP::ShowDependencyGraphVertex >::VertexDescriptor v) -> IMP::internal::BoostDigraph< IMP::DependencyGraph,IMP::ModelObject *,IMP::ShowDependencyGraphVertex >::VertexDescriptors"""
        return _IMP_kernel.DependencyGraph_get_in_neighbors(self, v)

    def get_out_neighbors(self, v):
        r"""get_out_neighbors(DependencyGraph self, IMP::internal::BoostDigraph< IMP::DependencyGraph,IMP::ModelObject *,IMP::ShowDependencyGraphVertex >::VertexDescriptor v) -> IMP::internal::BoostDigraph< IMP::DependencyGraph,IMP::ModelObject *,IMP::ShowDependencyGraphVertex >::VertexDescriptors"""
        return _IMP_kernel.DependencyGraph_get_out_neighbors(self, v)

    def show_graphviz(self, *args):
        r"""show_graphviz(DependencyGraph self, _ostream out=std::cout)"""
        return _IMP_kernel.DependencyGraph_show_graphviz(self, *args)

    def get_graphviz_string(self):
        r"""get_graphviz_string(DependencyGraph self) -> std::string"""
        return _IMP_kernel.DependencyGraph_get_graphviz_string(self)

    def add_edge(self, v0, v1):
        r"""add_edge(DependencyGraph self, IMP::internal::BoostDigraph< IMP::DependencyGraph,IMP::ModelObject *,IMP::ShowDependencyGraphVertex >::VertexDescriptor v0, IMP::internal::BoostDigraph< IMP::DependencyGraph,IMP::ModelObject *,IMP::ShowDependencyGraphVertex >::VertexDescriptor v1)"""
        return _IMP_kernel.DependencyGraph_add_edge(self, v0, v1)

    def add_vertex(self, l):
        r"""add_vertex(DependencyGraph self, ModelObject l) -> IMP::internal::BoostDigraph< IMP::DependencyGraph,IMP::ModelObject *,IMP::ShowDependencyGraphVertex >::VertexDescriptor"""
        return _IMP_kernel.DependencyGraph_add_vertex(self, l)

    def remove_vertex(self, l):
        r"""remove_vertex(DependencyGraph self, IMP::internal::BoostDigraph< IMP::DependencyGraph,IMP::ModelObject *,IMP::ShowDependencyGraphVertex >::VertexDescriptor l)"""
        return _IMP_kernel.DependencyGraph_remove_vertex(self, l)
    __swig_destroy__ = _IMP_kernel.delete_DependencyGraph

# Register DependencyGraph in _IMP_kernel:
_IMP_kernel.DependencyGraph_swigregister(DependencyGraph)


_value_types.append("DependencyGraph")

class FloatKey(_Value):
    r"""Proxy of C++ IMP::Key< 0 > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(FloatKey self) -> FloatKey
        __init__(FloatKey self, std::string const & c, bool is_implicit_add_permitted=True) -> FloatKey
        __init__(FloatKey self, unsigned int i) -> FloatKey
        """
        _IMP_kernel.FloatKey_swiginit(self, _IMP_kernel.new_FloatKey(*args))

    @staticmethod
    def add_key(sc):
        r"""add_key(std::string sc) -> unsigned int"""
        return _IMP_kernel.FloatKey_add_key(sc)

    @staticmethod
    def get_key_exists(sc):
        r"""get_key_exists(std::string sc) -> bool"""
        return _IMP_kernel.FloatKey_get_key_exists(sc)

    def get_string(self):
        r"""get_string(FloatKey self) -> std::string const"""
        return _IMP_kernel.FloatKey_get_string(self)

    def __cmp__(self, o):
        r"""__cmp__(FloatKey self, FloatKey o) -> int"""
        return _IMP_kernel.FloatKey___cmp__(self, o)

    def __eq__(self, o):
        r"""__eq__(FloatKey self, FloatKey o) -> bool"""
        return _IMP_kernel.FloatKey___eq__(self, o)

    def __ne__(self, o):
        r"""__ne__(FloatKey self, FloatKey o) -> bool"""
        return _IMP_kernel.FloatKey___ne__(self, o)

    def __lt__(self, o):
        r"""__lt__(FloatKey self, FloatKey o) -> bool"""
        return _IMP_kernel.FloatKey___lt__(self, o)

    def __gt__(self, o):
        r"""__gt__(FloatKey self, FloatKey o) -> bool"""
        return _IMP_kernel.FloatKey___gt__(self, o)

    def __ge__(self, o):
        r"""__ge__(FloatKey self, FloatKey o) -> bool"""
        return _IMP_kernel.FloatKey___ge__(self, o)

    def __le__(self, o):
        r"""__le__(FloatKey self, FloatKey o) -> bool"""
        return _IMP_kernel.FloatKey___le__(self, o)

    def __hash__(self):
        r"""__hash__(FloatKey self) -> std::size_t"""
        return _IMP_kernel.FloatKey___hash__(self)

    def show(self, *args):
        r"""show(FloatKey self, _ostream out=std::cout)"""
        return _IMP_kernel.FloatKey_show(self, *args)

    @staticmethod
    def add_alias(old_key, new_name):
        r"""add_alias(FloatKey old_key, std::string new_name) -> FloatKey"""
        return _IMP_kernel.FloatKey_add_alias(old_key, new_name)

    @staticmethod
    def get_number_of_keys():
        r"""get_number_of_keys() -> unsigned int"""
        return _IMP_kernel.FloatKey_get_number_of_keys()

    def get_index(self):
        r"""get_index(FloatKey self) -> unsigned int"""
        return _IMP_kernel.FloatKey_get_index(self)

    @staticmethod
    def show_all(out):
        r"""show_all(_ostream out)"""
        return _IMP_kernel.FloatKey_show_all(out)

    @staticmethod
    def get_all_strings():
        r"""get_all_strings() -> IMP::Vector< std::string >"""
        return _IMP_kernel.FloatKey_get_all_strings()

    @staticmethod
    def get_number_unique():
        r"""get_number_unique() -> unsigned int"""
        return _IMP_kernel.FloatKey_get_number_unique()

    def __str__(self):
        r"""__str__(FloatKey self) -> std::string"""
        return _IMP_kernel.FloatKey___str__(self)

    def __repr__(self):
        r"""__repr__(FloatKey self) -> std::string"""
        return _IMP_kernel.FloatKey___repr__(self)
    __swig_destroy__ = _IMP_kernel.delete_FloatKey

# Register FloatKey in _IMP_kernel:
_IMP_kernel.FloatKey_swigregister(FloatKey)

def FloatKey_add_key(sc):
    r"""FloatKey_add_key(std::string sc) -> unsigned int"""
    return _IMP_kernel.FloatKey_add_key(sc)

def FloatKey_get_key_exists(sc):
    r"""FloatKey_get_key_exists(std::string sc) -> bool"""
    return _IMP_kernel.FloatKey_get_key_exists(sc)

def FloatKey_add_alias(old_key, new_name):
    r"""FloatKey_add_alias(FloatKey old_key, std::string new_name) -> FloatKey"""
    return _IMP_kernel.FloatKey_add_alias(old_key, new_name)

def FloatKey_get_number_of_keys():
    r"""FloatKey_get_number_of_keys() -> unsigned int"""
    return _IMP_kernel.FloatKey_get_number_of_keys()

def FloatKey_show_all(out):
    r"""FloatKey_show_all(_ostream out)"""
    return _IMP_kernel.FloatKey_show_all(out)

def FloatKey_get_all_strings():
    r"""FloatKey_get_all_strings() -> IMP::Vector< std::string >"""
    return _IMP_kernel.FloatKey_get_all_strings()

def FloatKey_get_number_unique():
    r"""FloatKey_get_number_unique() -> unsigned int"""
    return _IMP_kernel.FloatKey_get_number_unique()

class IntKey(_Value):
    r"""Proxy of C++ IMP::Key< 1 > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(IntKey self) -> IntKey
        __init__(IntKey self, std::string const & c, bool is_implicit_add_permitted=True) -> IntKey
        __init__(IntKey self, unsigned int i) -> IntKey
        """
        _IMP_kernel.IntKey_swiginit(self, _IMP_kernel.new_IntKey(*args))

    @staticmethod
    def add_key(sc):
        r"""add_key(std::string sc) -> unsigned int"""
        return _IMP_kernel.IntKey_add_key(sc)

    @staticmethod
    def get_key_exists(sc):
        r"""get_key_exists(std::string sc) -> bool"""
        return _IMP_kernel.IntKey_get_key_exists(sc)

    def get_string(self):
        r"""get_string(IntKey self) -> std::string const"""
        return _IMP_kernel.IntKey_get_string(self)

    def __cmp__(self, o):
        r"""__cmp__(IntKey self, IntKey o) -> int"""
        return _IMP_kernel.IntKey___cmp__(self, o)

    def __eq__(self, o):
        r"""__eq__(IntKey self, IntKey o) -> bool"""
        return _IMP_kernel.IntKey___eq__(self, o)

    def __ne__(self, o):
        r"""__ne__(IntKey self, IntKey o) -> bool"""
        return _IMP_kernel.IntKey___ne__(self, o)

    def __lt__(self, o):
        r"""__lt__(IntKey self, IntKey o) -> bool"""
        return _IMP_kernel.IntKey___lt__(self, o)

    def __gt__(self, o):
        r"""__gt__(IntKey self, IntKey o) -> bool"""
        return _IMP_kernel.IntKey___gt__(self, o)

    def __ge__(self, o):
        r"""__ge__(IntKey self, IntKey o) -> bool"""
        return _IMP_kernel.IntKey___ge__(self, o)

    def __le__(self, o):
        r"""__le__(IntKey self, IntKey o) -> bool"""
        return _IMP_kernel.IntKey___le__(self, o)

    def __hash__(self):
        r"""__hash__(IntKey self) -> std::size_t"""
        return _IMP_kernel.IntKey___hash__(self)

    def show(self, *args):
        r"""show(IntKey self, _ostream out=std::cout)"""
        return _IMP_kernel.IntKey_show(self, *args)

    @staticmethod
    def add_alias(old_key, new_name):
        r"""add_alias(IntKey old_key, std::string new_name) -> IntKey"""
        return _IMP_kernel.IntKey_add_alias(old_key, new_name)

    @staticmethod
    def get_number_of_keys():
        r"""get_number_of_keys() -> unsigned int"""
        return _IMP_kernel.IntKey_get_number_of_keys()

    def get_index(self):
        r"""get_index(IntKey self) -> unsigned int"""
        return _IMP_kernel.IntKey_get_index(self)

    @staticmethod
    def show_all(out):
        r"""show_all(_ostream out)"""
        return _IMP_kernel.IntKey_show_all(out)

    @staticmethod
    def get_all_strings():
        r"""get_all_strings() -> IMP::Vector< std::string >"""
        return _IMP_kernel.IntKey_get_all_strings()

    @staticmethod
    def get_number_unique():
        r"""get_number_unique() -> unsigned int"""
        return _IMP_kernel.IntKey_get_number_unique()

    def __str__(self):
        r"""__str__(IntKey self) -> std::string"""
        return _IMP_kernel.IntKey___str__(self)

    def __repr__(self):
        r"""__repr__(IntKey self) -> std::string"""
        return _IMP_kernel.IntKey___repr__(self)
    __swig_destroy__ = _IMP_kernel.delete_IntKey

# Register IntKey in _IMP_kernel:
_IMP_kernel.IntKey_swigregister(IntKey)

def IntKey_add_key(sc):
    r"""IntKey_add_key(std::string sc) -> unsigned int"""
    return _IMP_kernel.IntKey_add_key(sc)

def IntKey_get_key_exists(sc):
    r"""IntKey_get_key_exists(std::string sc) -> bool"""
    return _IMP_kernel.IntKey_get_key_exists(sc)

def IntKey_add_alias(old_key, new_name):
    r"""IntKey_add_alias(IntKey old_key, std::string new_name) -> IntKey"""
    return _IMP_kernel.IntKey_add_alias(old_key, new_name)

def IntKey_get_number_of_keys():
    r"""IntKey_get_number_of_keys() -> unsigned int"""
    return _IMP_kernel.IntKey_get_number_of_keys()

def IntKey_show_all(out):
    r"""IntKey_show_all(_ostream out)"""
    return _IMP_kernel.IntKey_show_all(out)

def IntKey_get_all_strings():
    r"""IntKey_get_all_strings() -> IMP::Vector< std::string >"""
    return _IMP_kernel.IntKey_get_all_strings()

def IntKey_get_number_unique():
    r"""IntKey_get_number_unique() -> unsigned int"""
    return _IMP_kernel.IntKey_get_number_unique()

class StringKey(_Value):
    r"""Proxy of C++ IMP::Key< 2 > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(StringKey self) -> StringKey
        __init__(StringKey self, std::string const & c, bool is_implicit_add_permitted=True) -> StringKey
        __init__(StringKey self, unsigned int i) -> StringKey
        """
        _IMP_kernel.StringKey_swiginit(self, _IMP_kernel.new_StringKey(*args))

    @staticmethod
    def add_key(sc):
        r"""add_key(std::string sc) -> unsigned int"""
        return _IMP_kernel.StringKey_add_key(sc)

    @staticmethod
    def get_key_exists(sc):
        r"""get_key_exists(std::string sc) -> bool"""
        return _IMP_kernel.StringKey_get_key_exists(sc)

    def get_string(self):
        r"""get_string(StringKey self) -> std::string const"""
        return _IMP_kernel.StringKey_get_string(self)

    def __cmp__(self, o):
        r"""__cmp__(StringKey self, StringKey o) -> int"""
        return _IMP_kernel.StringKey___cmp__(self, o)

    def __eq__(self, o):
        r"""__eq__(StringKey self, StringKey o) -> bool"""
        return _IMP_kernel.StringKey___eq__(self, o)

    def __ne__(self, o):
        r"""__ne__(StringKey self, StringKey o) -> bool"""
        return _IMP_kernel.StringKey___ne__(self, o)

    def __lt__(self, o):
        r"""__lt__(StringKey self, StringKey o) -> bool"""
        return _IMP_kernel.StringKey___lt__(self, o)

    def __gt__(self, o):
        r"""__gt__(StringKey self, StringKey o) -> bool"""
        return _IMP_kernel.StringKey___gt__(self, o)

    def __ge__(self, o):
        r"""__ge__(StringKey self, StringKey o) -> bool"""
        return _IMP_kernel.StringKey___ge__(self, o)

    def __le__(self, o):
        r"""__le__(StringKey self, StringKey o) -> bool"""
        return _IMP_kernel.StringKey___le__(self, o)

    def __hash__(self):
        r"""__hash__(StringKey self) -> std::size_t"""
        return _IMP_kernel.StringKey___hash__(self)

    def show(self, *args):
        r"""show(StringKey self, _ostream out=std::cout)"""
        return _IMP_kernel.StringKey_show(self, *args)

    @staticmethod
    def add_alias(old_key, new_name):
        r"""add_alias(StringKey old_key, std::string new_name) -> StringKey"""
        return _IMP_kernel.StringKey_add_alias(old_key, new_name)

    @staticmethod
    def get_number_of_keys():
        r"""get_number_of_keys() -> unsigned int"""
        return _IMP_kernel.StringKey_get_number_of_keys()

    def get_index(self):
        r"""get_index(StringKey self) -> unsigned int"""
        return _IMP_kernel.StringKey_get_index(self)

    @staticmethod
    def show_all(out):
        r"""show_all(_ostream out)"""
        return _IMP_kernel.StringKey_show_all(out)

    @staticmethod
    def get_all_strings():
        r"""get_all_strings() -> IMP::Vector< std::string >"""
        return _IMP_kernel.StringKey_get_all_strings()

    @staticmethod
    def get_number_unique():
        r"""get_number_unique() -> unsigned int"""
        return _IMP_kernel.StringKey_get_number_unique()

    def __str__(self):
        r"""__str__(StringKey self) -> std::string"""
        return _IMP_kernel.StringKey___str__(self)

    def __repr__(self):
        r"""__repr__(StringKey self) -> std::string"""
        return _IMP_kernel.StringKey___repr__(self)
    __swig_destroy__ = _IMP_kernel.delete_StringKey

# Register StringKey in _IMP_kernel:
_IMP_kernel.StringKey_swigregister(StringKey)

def StringKey_add_key(sc):
    r"""StringKey_add_key(std::string sc) -> unsigned int"""
    return _IMP_kernel.StringKey_add_key(sc)

def StringKey_get_key_exists(sc):
    r"""StringKey_get_key_exists(std::string sc) -> bool"""
    return _IMP_kernel.StringKey_get_key_exists(sc)

def StringKey_add_alias(old_key, new_name):
    r"""StringKey_add_alias(StringKey old_key, std::string new_name) -> StringKey"""
    return _IMP_kernel.StringKey_add_alias(old_key, new_name)

def StringKey_get_number_of_keys():
    r"""StringKey_get_number_of_keys() -> unsigned int"""
    return _IMP_kernel.StringKey_get_number_of_keys()

def StringKey_show_all(out):
    r"""StringKey_show_all(_ostream out)"""
    return _IMP_kernel.StringKey_show_all(out)

def StringKey_get_all_strings():
    r"""StringKey_get_all_strings() -> IMP::Vector< std::string >"""
    return _IMP_kernel.StringKey_get_all_strings()

def StringKey_get_number_unique():
    r"""StringKey_get_number_unique() -> unsigned int"""
    return _IMP_kernel.StringKey_get_number_unique()

class ParticleIndexKey(_Value):
    r"""Proxy of C++ IMP::Key< 3 > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(ParticleIndexKey self) -> ParticleIndexKey
        __init__(ParticleIndexKey self, std::string const & c, bool is_implicit_add_permitted=True) -> ParticleIndexKey
        __init__(ParticleIndexKey self, unsigned int i) -> ParticleIndexKey
        """
        _IMP_kernel.ParticleIndexKey_swiginit(self, _IMP_kernel.new_ParticleIndexKey(*args))

    @staticmethod
    def add_key(sc):
        r"""add_key(std::string sc) -> unsigned int"""
        return _IMP_kernel.ParticleIndexKey_add_key(sc)

    @staticmethod
    def get_key_exists(sc):
        r"""get_key_exists(std::string sc) -> bool"""
        return _IMP_kernel.ParticleIndexKey_get_key_exists(sc)

    def get_string(self):
        r"""get_string(ParticleIndexKey self) -> std::string const"""
        return _IMP_kernel.ParticleIndexKey_get_string(self)

    def __cmp__(self, o):
        r"""__cmp__(ParticleIndexKey self, ParticleIndexKey o) -> int"""
        return _IMP_kernel.ParticleIndexKey___cmp__(self, o)

    def __eq__(self, o):
        r"""__eq__(ParticleIndexKey self, ParticleIndexKey o) -> bool"""
        return _IMP_kernel.ParticleIndexKey___eq__(self, o)

    def __ne__(self, o):
        r"""__ne__(ParticleIndexKey self, ParticleIndexKey o) -> bool"""
        return _IMP_kernel.ParticleIndexKey___ne__(self, o)

    def __lt__(self, o):
        r"""__lt__(ParticleIndexKey self, ParticleIndexKey o) -> bool"""
        return _IMP_kernel.ParticleIndexKey___lt__(self, o)

    def __gt__(self, o):
        r"""__gt__(ParticleIndexKey self, ParticleIndexKey o) -> bool"""
        return _IMP_kernel.ParticleIndexKey___gt__(self, o)

    def __ge__(self, o):
        r"""__ge__(ParticleIndexKey self, ParticleIndexKey o) -> bool"""
        return _IMP_kernel.ParticleIndexKey___ge__(self, o)

    def __le__(self, o):
        r"""__le__(ParticleIndexKey self, ParticleIndexKey o) -> bool"""
        return _IMP_kernel.ParticleIndexKey___le__(self, o)

    def __hash__(self):
        r"""__hash__(ParticleIndexKey self) -> std::size_t"""
        return _IMP_kernel.ParticleIndexKey___hash__(self)

    def show(self, *args):
        r"""show(ParticleIndexKey self, _ostream out=std::cout)"""
        return _IMP_kernel.ParticleIndexKey_show(self, *args)

    @staticmethod
    def add_alias(old_key, new_name):
        r"""add_alias(ParticleIndexKey old_key, std::string new_name) -> ParticleIndexKey"""
        return _IMP_kernel.ParticleIndexKey_add_alias(old_key, new_name)

    @staticmethod
    def get_number_of_keys():
        r"""get_number_of_keys() -> unsigned int"""
        return _IMP_kernel.ParticleIndexKey_get_number_of_keys()

    def get_index(self):
        r"""get_index(ParticleIndexKey self) -> unsigned int"""
        return _IMP_kernel.ParticleIndexKey_get_index(self)

    @staticmethod
    def show_all(out):
        r"""show_all(_ostream out)"""
        return _IMP_kernel.ParticleIndexKey_show_all(out)

    @staticmethod
    def get_all_strings():
        r"""get_all_strings() -> IMP::Vector< std::string >"""
        return _IMP_kernel.ParticleIndexKey_get_all_strings()

    @staticmethod
    def get_number_unique():
        r"""get_number_unique() -> unsigned int"""
        return _IMP_kernel.ParticleIndexKey_get_number_unique()

    def __str__(self):
        r"""__str__(ParticleIndexKey self) -> std::string"""
        return _IMP_kernel.ParticleIndexKey___str__(self)

    def __repr__(self):
        r"""__repr__(ParticleIndexKey self) -> std::string"""
        return _IMP_kernel.ParticleIndexKey___repr__(self)
    __swig_destroy__ = _IMP_kernel.delete_ParticleIndexKey

# Register ParticleIndexKey in _IMP_kernel:
_IMP_kernel.ParticleIndexKey_swigregister(ParticleIndexKey)

def ParticleIndexKey_add_key(sc):
    r"""ParticleIndexKey_add_key(std::string sc) -> unsigned int"""
    return _IMP_kernel.ParticleIndexKey_add_key(sc)

def ParticleIndexKey_get_key_exists(sc):
    r"""ParticleIndexKey_get_key_exists(std::string sc) -> bool"""
    return _IMP_kernel.ParticleIndexKey_get_key_exists(sc)

def ParticleIndexKey_add_alias(old_key, new_name):
    r"""ParticleIndexKey_add_alias(ParticleIndexKey old_key, std::string new_name) -> ParticleIndexKey"""
    return _IMP_kernel.ParticleIndexKey_add_alias(old_key, new_name)

def ParticleIndexKey_get_number_of_keys():
    r"""ParticleIndexKey_get_number_of_keys() -> unsigned int"""
    return _IMP_kernel.ParticleIndexKey_get_number_of_keys()

def ParticleIndexKey_show_all(out):
    r"""ParticleIndexKey_show_all(_ostream out)"""
    return _IMP_kernel.ParticleIndexKey_show_all(out)

def ParticleIndexKey_get_all_strings():
    r"""ParticleIndexKey_get_all_strings() -> IMP::Vector< std::string >"""
    return _IMP_kernel.ParticleIndexKey_get_all_strings()

def ParticleIndexKey_get_number_unique():
    r"""ParticleIndexKey_get_number_unique() -> unsigned int"""
    return _IMP_kernel.ParticleIndexKey_get_number_unique()

class ObjectKey(_Value):
    r"""Proxy of C++ IMP::Key< 4 > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(ObjectKey self) -> ObjectKey
        __init__(ObjectKey self, std::string const & c, bool is_implicit_add_permitted=True) -> ObjectKey
        __init__(ObjectKey self, unsigned int i) -> ObjectKey
        """
        _IMP_kernel.ObjectKey_swiginit(self, _IMP_kernel.new_ObjectKey(*args))

    @staticmethod
    def add_key(sc):
        r"""add_key(std::string sc) -> unsigned int"""
        return _IMP_kernel.ObjectKey_add_key(sc)

    @staticmethod
    def get_key_exists(sc):
        r"""get_key_exists(std::string sc) -> bool"""
        return _IMP_kernel.ObjectKey_get_key_exists(sc)

    def get_string(self):
        r"""get_string(ObjectKey self) -> std::string const"""
        return _IMP_kernel.ObjectKey_get_string(self)

    def __cmp__(self, o):
        r"""__cmp__(ObjectKey self, ObjectKey o) -> int"""
        return _IMP_kernel.ObjectKey___cmp__(self, o)

    def __eq__(self, o):
        r"""__eq__(ObjectKey self, ObjectKey o) -> bool"""
        return _IMP_kernel.ObjectKey___eq__(self, o)

    def __ne__(self, o):
        r"""__ne__(ObjectKey self, ObjectKey o) -> bool"""
        return _IMP_kernel.ObjectKey___ne__(self, o)

    def __lt__(self, o):
        r"""__lt__(ObjectKey self, ObjectKey o) -> bool"""
        return _IMP_kernel.ObjectKey___lt__(self, o)

    def __gt__(self, o):
        r"""__gt__(ObjectKey self, ObjectKey o) -> bool"""
        return _IMP_kernel.ObjectKey___gt__(self, o)

    def __ge__(self, o):
        r"""__ge__(ObjectKey self, ObjectKey o) -> bool"""
        return _IMP_kernel.ObjectKey___ge__(self, o)

    def __le__(self, o):
        r"""__le__(ObjectKey self, ObjectKey o) -> bool"""
        return _IMP_kernel.ObjectKey___le__(self, o)

    def __hash__(self):
        r"""__hash__(ObjectKey self) -> std::size_t"""
        return _IMP_kernel.ObjectKey___hash__(self)

    def show(self, *args):
        r"""show(ObjectKey self, _ostream out=std::cout)"""
        return _IMP_kernel.ObjectKey_show(self, *args)

    @staticmethod
    def add_alias(old_key, new_name):
        r"""add_alias(ObjectKey old_key, std::string new_name) -> ObjectKey"""
        return _IMP_kernel.ObjectKey_add_alias(old_key, new_name)

    @staticmethod
    def get_number_of_keys():
        r"""get_number_of_keys() -> unsigned int"""
        return _IMP_kernel.ObjectKey_get_number_of_keys()

    def get_index(self):
        r"""get_index(ObjectKey self) -> unsigned int"""
        return _IMP_kernel.ObjectKey_get_index(self)

    @staticmethod
    def show_all(out):
        r"""show_all(_ostream out)"""
        return _IMP_kernel.ObjectKey_show_all(out)

    @staticmethod
    def get_all_strings():
        r"""get_all_strings() -> IMP::Vector< std::string >"""
        return _IMP_kernel.ObjectKey_get_all_strings()

    @staticmethod
    def get_number_unique():
        r"""get_number_unique() -> unsigned int"""
        return _IMP_kernel.ObjectKey_get_number_unique()

    def __str__(self):
        r"""__str__(ObjectKey self) -> std::string"""
        return _IMP_kernel.ObjectKey___str__(self)

    def __repr__(self):
        r"""__repr__(ObjectKey self) -> std::string"""
        return _IMP_kernel.ObjectKey___repr__(self)
    __swig_destroy__ = _IMP_kernel.delete_ObjectKey

# Register ObjectKey in _IMP_kernel:
_IMP_kernel.ObjectKey_swigregister(ObjectKey)

def ObjectKey_add_key(sc):
    r"""ObjectKey_add_key(std::string sc) -> unsigned int"""
    return _IMP_kernel.ObjectKey_add_key(sc)

def ObjectKey_get_key_exists(sc):
    r"""ObjectKey_get_key_exists(std::string sc) -> bool"""
    return _IMP_kernel.ObjectKey_get_key_exists(sc)

def ObjectKey_add_alias(old_key, new_name):
    r"""ObjectKey_add_alias(ObjectKey old_key, std::string new_name) -> ObjectKey"""
    return _IMP_kernel.ObjectKey_add_alias(old_key, new_name)

def ObjectKey_get_number_of_keys():
    r"""ObjectKey_get_number_of_keys() -> unsigned int"""
    return _IMP_kernel.ObjectKey_get_number_of_keys()

def ObjectKey_show_all(out):
    r"""ObjectKey_show_all(_ostream out)"""
    return _IMP_kernel.ObjectKey_show_all(out)

def ObjectKey_get_all_strings():
    r"""ObjectKey_get_all_strings() -> IMP::Vector< std::string >"""
    return _IMP_kernel.ObjectKey_get_all_strings()

def ObjectKey_get_number_unique():
    r"""ObjectKey_get_number_unique() -> unsigned int"""
    return _IMP_kernel.ObjectKey_get_number_unique()

class IntsKey(_Value):
    r"""Proxy of C++ IMP::Key< 5 > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(IntsKey self) -> IntsKey
        __init__(IntsKey self, std::string const & c, bool is_implicit_add_permitted=True) -> IntsKey
        __init__(IntsKey self, unsigned int i) -> IntsKey
        """
        _IMP_kernel.IntsKey_swiginit(self, _IMP_kernel.new_IntsKey(*args))

    @staticmethod
    def add_key(sc):
        r"""add_key(std::string sc) -> unsigned int"""
        return _IMP_kernel.IntsKey_add_key(sc)

    @staticmethod
    def get_key_exists(sc):
        r"""get_key_exists(std::string sc) -> bool"""
        return _IMP_kernel.IntsKey_get_key_exists(sc)

    def get_string(self):
        r"""get_string(IntsKey self) -> std::string const"""
        return _IMP_kernel.IntsKey_get_string(self)

    def __cmp__(self, o):
        r"""__cmp__(IntsKey self, IntsKey o) -> int"""
        return _IMP_kernel.IntsKey___cmp__(self, o)

    def __eq__(self, o):
        r"""__eq__(IntsKey self, IntsKey o) -> bool"""
        return _IMP_kernel.IntsKey___eq__(self, o)

    def __ne__(self, o):
        r"""__ne__(IntsKey self, IntsKey o) -> bool"""
        return _IMP_kernel.IntsKey___ne__(self, o)

    def __lt__(self, o):
        r"""__lt__(IntsKey self, IntsKey o) -> bool"""
        return _IMP_kernel.IntsKey___lt__(self, o)

    def __gt__(self, o):
        r"""__gt__(IntsKey self, IntsKey o) -> bool"""
        return _IMP_kernel.IntsKey___gt__(self, o)

    def __ge__(self, o):
        r"""__ge__(IntsKey self, IntsKey o) -> bool"""
        return _IMP_kernel.IntsKey___ge__(self, o)

    def __le__(self, o):
        r"""__le__(IntsKey self, IntsKey o) -> bool"""
        return _IMP_kernel.IntsKey___le__(self, o)

    def __hash__(self):
        r"""__hash__(IntsKey self) -> std::size_t"""
        return _IMP_kernel.IntsKey___hash__(self)

    def show(self, *args):
        r"""show(IntsKey self, _ostream out=std::cout)"""
        return _IMP_kernel.IntsKey_show(self, *args)

    @staticmethod
    def add_alias(old_key, new_name):
        r"""add_alias(IntsKey old_key, std::string new_name) -> IntsKey"""
        return _IMP_kernel.IntsKey_add_alias(old_key, new_name)

    @staticmethod
    def get_number_of_keys():
        r"""get_number_of_keys() -> unsigned int"""
        return _IMP_kernel.IntsKey_get_number_of_keys()

    def get_index(self):
        r"""get_index(IntsKey self) -> unsigned int"""
        return _IMP_kernel.IntsKey_get_index(self)

    @staticmethod
    def show_all(out):
        r"""show_all(_ostream out)"""
        return _IMP_kernel.IntsKey_show_all(out)

    @staticmethod
    def get_all_strings():
        r"""get_all_strings() -> IMP::Vector< std::string >"""
        return _IMP_kernel.IntsKey_get_all_strings()

    @staticmethod
    def get_number_unique():
        r"""get_number_unique() -> unsigned int"""
        return _IMP_kernel.IntsKey_get_number_unique()

    def __str__(self):
        r"""__str__(IntsKey self) -> std::string"""
        return _IMP_kernel.IntsKey___str__(self)

    def __repr__(self):
        r"""__repr__(IntsKey self) -> std::string"""
        return _IMP_kernel.IntsKey___repr__(self)
    __swig_destroy__ = _IMP_kernel.delete_IntsKey

# Register IntsKey in _IMP_kernel:
_IMP_kernel.IntsKey_swigregister(IntsKey)

def IntsKey_add_key(sc):
    r"""IntsKey_add_key(std::string sc) -> unsigned int"""
    return _IMP_kernel.IntsKey_add_key(sc)

def IntsKey_get_key_exists(sc):
    r"""IntsKey_get_key_exists(std::string sc) -> bool"""
    return _IMP_kernel.IntsKey_get_key_exists(sc)

def IntsKey_add_alias(old_key, new_name):
    r"""IntsKey_add_alias(IntsKey old_key, std::string new_name) -> IntsKey"""
    return _IMP_kernel.IntsKey_add_alias(old_key, new_name)

def IntsKey_get_number_of_keys():
    r"""IntsKey_get_number_of_keys() -> unsigned int"""
    return _IMP_kernel.IntsKey_get_number_of_keys()

def IntsKey_show_all(out):
    r"""IntsKey_show_all(_ostream out)"""
    return _IMP_kernel.IntsKey_show_all(out)

def IntsKey_get_all_strings():
    r"""IntsKey_get_all_strings() -> IMP::Vector< std::string >"""
    return _IMP_kernel.IntsKey_get_all_strings()

def IntsKey_get_number_unique():
    r"""IntsKey_get_number_unique() -> unsigned int"""
    return _IMP_kernel.IntsKey_get_number_unique()

class ParticleIndexesKey(_Value):
    r"""Proxy of C++ IMP::Key< 6 > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(ParticleIndexesKey self) -> ParticleIndexesKey
        __init__(ParticleIndexesKey self, std::string const & c, bool is_implicit_add_permitted=True) -> ParticleIndexesKey
        __init__(ParticleIndexesKey self, unsigned int i) -> ParticleIndexesKey
        """
        _IMP_kernel.ParticleIndexesKey_swiginit(self, _IMP_kernel.new_ParticleIndexesKey(*args))

    @staticmethod
    def add_key(sc):
        r"""add_key(std::string sc) -> unsigned int"""
        return _IMP_kernel.ParticleIndexesKey_add_key(sc)

    @staticmethod
    def get_key_exists(sc):
        r"""get_key_exists(std::string sc) -> bool"""
        return _IMP_kernel.ParticleIndexesKey_get_key_exists(sc)

    def get_string(self):
        r"""get_string(ParticleIndexesKey self) -> std::string const"""
        return _IMP_kernel.ParticleIndexesKey_get_string(self)

    def __cmp__(self, o):
        r"""__cmp__(ParticleIndexesKey self, ParticleIndexesKey o) -> int"""
        return _IMP_kernel.ParticleIndexesKey___cmp__(self, o)

    def __eq__(self, o):
        r"""__eq__(ParticleIndexesKey self, ParticleIndexesKey o) -> bool"""
        return _IMP_kernel.ParticleIndexesKey___eq__(self, o)

    def __ne__(self, o):
        r"""__ne__(ParticleIndexesKey self, ParticleIndexesKey o) -> bool"""
        return _IMP_kernel.ParticleIndexesKey___ne__(self, o)

    def __lt__(self, o):
        r"""__lt__(ParticleIndexesKey self, ParticleIndexesKey o) -> bool"""
        return _IMP_kernel.ParticleIndexesKey___lt__(self, o)

    def __gt__(self, o):
        r"""__gt__(ParticleIndexesKey self, ParticleIndexesKey o) -> bool"""
        return _IMP_kernel.ParticleIndexesKey___gt__(self, o)

    def __ge__(self, o):
        r"""__ge__(ParticleIndexesKey self, ParticleIndexesKey o) -> bool"""
        return _IMP_kernel.ParticleIndexesKey___ge__(self, o)

    def __le__(self, o):
        r"""__le__(ParticleIndexesKey self, ParticleIndexesKey o) -> bool"""
        return _IMP_kernel.ParticleIndexesKey___le__(self, o)

    def __hash__(self):
        r"""__hash__(ParticleIndexesKey self) -> std::size_t"""
        return _IMP_kernel.ParticleIndexesKey___hash__(self)

    def show(self, *args):
        r"""show(ParticleIndexesKey self, _ostream out=std::cout)"""
        return _IMP_kernel.ParticleIndexesKey_show(self, *args)

    @staticmethod
    def add_alias(old_key, new_name):
        r"""add_alias(ParticleIndexesKey old_key, std::string new_name) -> ParticleIndexesKey"""
        return _IMP_kernel.ParticleIndexesKey_add_alias(old_key, new_name)

    @staticmethod
    def get_number_of_keys():
        r"""get_number_of_keys() -> unsigned int"""
        return _IMP_kernel.ParticleIndexesKey_get_number_of_keys()

    def get_index(self):
        r"""get_index(ParticleIndexesKey self) -> unsigned int"""
        return _IMP_kernel.ParticleIndexesKey_get_index(self)

    @staticmethod
    def show_all(out):
        r"""show_all(_ostream out)"""
        return _IMP_kernel.ParticleIndexesKey_show_all(out)

    @staticmethod
    def get_all_strings():
        r"""get_all_strings() -> IMP::Vector< std::string >"""
        return _IMP_kernel.ParticleIndexesKey_get_all_strings()

    @staticmethod
    def get_number_unique():
        r"""get_number_unique() -> unsigned int"""
        return _IMP_kernel.ParticleIndexesKey_get_number_unique()

    def __str__(self):
        r"""__str__(ParticleIndexesKey self) -> std::string"""
        return _IMP_kernel.ParticleIndexesKey___str__(self)

    def __repr__(self):
        r"""__repr__(ParticleIndexesKey self) -> std::string"""
        return _IMP_kernel.ParticleIndexesKey___repr__(self)
    __swig_destroy__ = _IMP_kernel.delete_ParticleIndexesKey

# Register ParticleIndexesKey in _IMP_kernel:
_IMP_kernel.ParticleIndexesKey_swigregister(ParticleIndexesKey)

def ParticleIndexesKey_add_key(sc):
    r"""ParticleIndexesKey_add_key(std::string sc) -> unsigned int"""
    return _IMP_kernel.ParticleIndexesKey_add_key(sc)

def ParticleIndexesKey_get_key_exists(sc):
    r"""ParticleIndexesKey_get_key_exists(std::string sc) -> bool"""
    return _IMP_kernel.ParticleIndexesKey_get_key_exists(sc)

def ParticleIndexesKey_add_alias(old_key, new_name):
    r"""ParticleIndexesKey_add_alias(ParticleIndexesKey old_key, std::string new_name) -> ParticleIndexesKey"""
    return _IMP_kernel.ParticleIndexesKey_add_alias(old_key, new_name)

def ParticleIndexesKey_get_number_of_keys():
    r"""ParticleIndexesKey_get_number_of_keys() -> unsigned int"""
    return _IMP_kernel.ParticleIndexesKey_get_number_of_keys()

def ParticleIndexesKey_show_all(out):
    r"""ParticleIndexesKey_show_all(_ostream out)"""
    return _IMP_kernel.ParticleIndexesKey_show_all(out)

def ParticleIndexesKey_get_all_strings():
    r"""ParticleIndexesKey_get_all_strings() -> IMP::Vector< std::string >"""
    return _IMP_kernel.ParticleIndexesKey_get_all_strings()

def ParticleIndexesKey_get_number_unique():
    r"""ParticleIndexesKey_get_number_unique() -> unsigned int"""
    return _IMP_kernel.ParticleIndexesKey_get_number_unique()

class ModelKey(_Value):
    r"""Proxy of C++ IMP::Key< 8 > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(ModelKey self) -> ModelKey
        __init__(ModelKey self, std::string const & c, bool is_implicit_add_permitted=True) -> ModelKey
        __init__(ModelKey self, unsigned int i) -> ModelKey
        """
        _IMP_kernel.ModelKey_swiginit(self, _IMP_kernel.new_ModelKey(*args))

    @staticmethod
    def add_key(sc):
        r"""add_key(std::string sc) -> unsigned int"""
        return _IMP_kernel.ModelKey_add_key(sc)

    @staticmethod
    def get_key_exists(sc):
        r"""get_key_exists(std::string sc) -> bool"""
        return _IMP_kernel.ModelKey_get_key_exists(sc)

    def get_string(self):
        r"""get_string(ModelKey self) -> std::string const"""
        return _IMP_kernel.ModelKey_get_string(self)

    def __cmp__(self, o):
        r"""__cmp__(ModelKey self, ModelKey o) -> int"""
        return _IMP_kernel.ModelKey___cmp__(self, o)

    def __eq__(self, o):
        r"""__eq__(ModelKey self, ModelKey o) -> bool"""
        return _IMP_kernel.ModelKey___eq__(self, o)

    def __ne__(self, o):
        r"""__ne__(ModelKey self, ModelKey o) -> bool"""
        return _IMP_kernel.ModelKey___ne__(self, o)

    def __lt__(self, o):
        r"""__lt__(ModelKey self, ModelKey o) -> bool"""
        return _IMP_kernel.ModelKey___lt__(self, o)

    def __gt__(self, o):
        r"""__gt__(ModelKey self, ModelKey o) -> bool"""
        return _IMP_kernel.ModelKey___gt__(self, o)

    def __ge__(self, o):
        r"""__ge__(ModelKey self, ModelKey o) -> bool"""
        return _IMP_kernel.ModelKey___ge__(self, o)

    def __le__(self, o):
        r"""__le__(ModelKey self, ModelKey o) -> bool"""
        return _IMP_kernel.ModelKey___le__(self, o)

    def __hash__(self):
        r"""__hash__(ModelKey self) -> std::size_t"""
        return _IMP_kernel.ModelKey___hash__(self)

    def show(self, *args):
        r"""show(ModelKey self, _ostream out=std::cout)"""
        return _IMP_kernel.ModelKey_show(self, *args)

    @staticmethod
    def add_alias(old_key, new_name):
        r"""add_alias(ModelKey old_key, std::string new_name) -> ModelKey"""
        return _IMP_kernel.ModelKey_add_alias(old_key, new_name)

    @staticmethod
    def get_number_of_keys():
        r"""get_number_of_keys() -> unsigned int"""
        return _IMP_kernel.ModelKey_get_number_of_keys()

    def get_index(self):
        r"""get_index(ModelKey self) -> unsigned int"""
        return _IMP_kernel.ModelKey_get_index(self)

    @staticmethod
    def show_all(out):
        r"""show_all(_ostream out)"""
        return _IMP_kernel.ModelKey_show_all(out)

    @staticmethod
    def get_all_strings():
        r"""get_all_strings() -> IMP::Vector< std::string >"""
        return _IMP_kernel.ModelKey_get_all_strings()

    @staticmethod
    def get_number_unique():
        r"""get_number_unique() -> unsigned int"""
        return _IMP_kernel.ModelKey_get_number_unique()

    def __str__(self):
        r"""__str__(ModelKey self) -> std::string"""
        return _IMP_kernel.ModelKey___str__(self)

    def __repr__(self):
        r"""__repr__(ModelKey self) -> std::string"""
        return _IMP_kernel.ModelKey___repr__(self)
    __swig_destroy__ = _IMP_kernel.delete_ModelKey

# Register ModelKey in _IMP_kernel:
_IMP_kernel.ModelKey_swigregister(ModelKey)

def ModelKey_add_key(sc):
    r"""ModelKey_add_key(std::string sc) -> unsigned int"""
    return _IMP_kernel.ModelKey_add_key(sc)

def ModelKey_get_key_exists(sc):
    r"""ModelKey_get_key_exists(std::string sc) -> bool"""
    return _IMP_kernel.ModelKey_get_key_exists(sc)

def ModelKey_add_alias(old_key, new_name):
    r"""ModelKey_add_alias(ModelKey old_key, std::string new_name) -> ModelKey"""
    return _IMP_kernel.ModelKey_add_alias(old_key, new_name)

def ModelKey_get_number_of_keys():
    r"""ModelKey_get_number_of_keys() -> unsigned int"""
    return _IMP_kernel.ModelKey_get_number_of_keys()

def ModelKey_show_all(out):
    r"""ModelKey_show_all(_ostream out)"""
    return _IMP_kernel.ModelKey_show_all(out)

def ModelKey_get_all_strings():
    r"""ModelKey_get_all_strings() -> IMP::Vector< std::string >"""
    return _IMP_kernel.ModelKey_get_all_strings()

def ModelKey_get_number_unique():
    r"""ModelKey_get_number_unique() -> unsigned int"""
    return _IMP_kernel.ModelKey_get_number_unique()

class TriggerKey(_Value):
    r"""Proxy of C++ IMP::Key< 11 > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(TriggerKey self) -> TriggerKey
        __init__(TriggerKey self, std::string const & c, bool is_implicit_add_permitted=True) -> TriggerKey
        __init__(TriggerKey self, unsigned int i) -> TriggerKey
        """
        _IMP_kernel.TriggerKey_swiginit(self, _IMP_kernel.new_TriggerKey(*args))

    @staticmethod
    def add_key(sc):
        r"""add_key(std::string sc) -> unsigned int"""
        return _IMP_kernel.TriggerKey_add_key(sc)

    @staticmethod
    def get_key_exists(sc):
        r"""get_key_exists(std::string sc) -> bool"""
        return _IMP_kernel.TriggerKey_get_key_exists(sc)

    def get_string(self):
        r"""get_string(TriggerKey self) -> std::string const"""
        return _IMP_kernel.TriggerKey_get_string(self)

    def __cmp__(self, o):
        r"""__cmp__(TriggerKey self, TriggerKey o) -> int"""
        return _IMP_kernel.TriggerKey___cmp__(self, o)

    def __eq__(self, o):
        r"""__eq__(TriggerKey self, TriggerKey o) -> bool"""
        return _IMP_kernel.TriggerKey___eq__(self, o)

    def __ne__(self, o):
        r"""__ne__(TriggerKey self, TriggerKey o) -> bool"""
        return _IMP_kernel.TriggerKey___ne__(self, o)

    def __lt__(self, o):
        r"""__lt__(TriggerKey self, TriggerKey o) -> bool"""
        return _IMP_kernel.TriggerKey___lt__(self, o)

    def __gt__(self, o):
        r"""__gt__(TriggerKey self, TriggerKey o) -> bool"""
        return _IMP_kernel.TriggerKey___gt__(self, o)

    def __ge__(self, o):
        r"""__ge__(TriggerKey self, TriggerKey o) -> bool"""
        return _IMP_kernel.TriggerKey___ge__(self, o)

    def __le__(self, o):
        r"""__le__(TriggerKey self, TriggerKey o) -> bool"""
        return _IMP_kernel.TriggerKey___le__(self, o)

    def __hash__(self):
        r"""__hash__(TriggerKey self) -> std::size_t"""
        return _IMP_kernel.TriggerKey___hash__(self)

    def show(self, *args):
        r"""show(TriggerKey self, _ostream out=std::cout)"""
        return _IMP_kernel.TriggerKey_show(self, *args)

    @staticmethod
    def add_alias(old_key, new_name):
        r"""add_alias(TriggerKey old_key, std::string new_name) -> TriggerKey"""
        return _IMP_kernel.TriggerKey_add_alias(old_key, new_name)

    @staticmethod
    def get_number_of_keys():
        r"""get_number_of_keys() -> unsigned int"""
        return _IMP_kernel.TriggerKey_get_number_of_keys()

    def get_index(self):
        r"""get_index(TriggerKey self) -> unsigned int"""
        return _IMP_kernel.TriggerKey_get_index(self)

    @staticmethod
    def show_all(out):
        r"""show_all(_ostream out)"""
        return _IMP_kernel.TriggerKey_show_all(out)

    @staticmethod
    def get_all_strings():
        r"""get_all_strings() -> IMP::Vector< std::string >"""
        return _IMP_kernel.TriggerKey_get_all_strings()

    @staticmethod
    def get_number_unique():
        r"""get_number_unique() -> unsigned int"""
        return _IMP_kernel.TriggerKey_get_number_unique()

    def __str__(self):
        r"""__str__(TriggerKey self) -> std::string"""
        return _IMP_kernel.TriggerKey___str__(self)

    def __repr__(self):
        r"""__repr__(TriggerKey self) -> std::string"""
        return _IMP_kernel.TriggerKey___repr__(self)
    __swig_destroy__ = _IMP_kernel.delete_TriggerKey

# Register TriggerKey in _IMP_kernel:
_IMP_kernel.TriggerKey_swigregister(TriggerKey)

def TriggerKey_add_key(sc):
    r"""TriggerKey_add_key(std::string sc) -> unsigned int"""
    return _IMP_kernel.TriggerKey_add_key(sc)

def TriggerKey_get_key_exists(sc):
    r"""TriggerKey_get_key_exists(std::string sc) -> bool"""
    return _IMP_kernel.TriggerKey_get_key_exists(sc)

def TriggerKey_add_alias(old_key, new_name):
    r"""TriggerKey_add_alias(TriggerKey old_key, std::string new_name) -> TriggerKey"""
    return _IMP_kernel.TriggerKey_add_alias(old_key, new_name)

def TriggerKey_get_number_of_keys():
    r"""TriggerKey_get_number_of_keys() -> unsigned int"""
    return _IMP_kernel.TriggerKey_get_number_of_keys()

def TriggerKey_show_all(out):
    r"""TriggerKey_show_all(_ostream out)"""
    return _IMP_kernel.TriggerKey_show_all(out)

def TriggerKey_get_all_strings():
    r"""TriggerKey_get_all_strings() -> IMP::Vector< std::string >"""
    return _IMP_kernel.TriggerKey_get_all_strings()

def TriggerKey_get_number_unique():
    r"""TriggerKey_get_number_unique() -> unsigned int"""
    return _IMP_kernel.TriggerKey_get_number_unique()

class ParticleIndex(_Value):
    r"""Proxy of C++ IMP::Index< IMP::ParticleIndexTag > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(ParticleIndex self, int i) -> ParticleIndex
        __init__(ParticleIndex self) -> ParticleIndex
        """
        _IMP_kernel.ParticleIndex_swiginit(self, _IMP_kernel.new_ParticleIndex(*args))

    def get_index(self):
        r"""get_index(ParticleIndex self) -> int"""
        return _IMP_kernel.ParticleIndex_get_index(self)

    def __cmp__(self, o):
        r"""__cmp__(ParticleIndex self, ParticleIndex o) -> int"""
        return _IMP_kernel.ParticleIndex___cmp__(self, o)

    def __eq__(self, o):
        r"""__eq__(ParticleIndex self, ParticleIndex o) -> bool"""
        return _IMP_kernel.ParticleIndex___eq__(self, o)

    def __ne__(self, o):
        r"""__ne__(ParticleIndex self, ParticleIndex o) -> bool"""
        return _IMP_kernel.ParticleIndex___ne__(self, o)

    def __lt__(self, o):
        r"""__lt__(ParticleIndex self, ParticleIndex o) -> bool"""
        return _IMP_kernel.ParticleIndex___lt__(self, o)

    def __gt__(self, o):
        r"""__gt__(ParticleIndex self, ParticleIndex o) -> bool"""
        return _IMP_kernel.ParticleIndex___gt__(self, o)

    def __ge__(self, o):
        r"""__ge__(ParticleIndex self, ParticleIndex o) -> bool"""
        return _IMP_kernel.ParticleIndex___ge__(self, o)

    def __le__(self, o):
        r"""__le__(ParticleIndex self, ParticleIndex o) -> bool"""
        return _IMP_kernel.ParticleIndex___le__(self, o)

    def show(self, *args):
        r"""show(ParticleIndex self, _ostream out=std::cout)"""
        return _IMP_kernel.ParticleIndex_show(self, *args)

    def __hash__(self):
        r"""__hash__(ParticleIndex self) -> std::size_t"""
        return _IMP_kernel.ParticleIndex___hash__(self)

    def __str__(self):
        r"""__str__(ParticleIndex self) -> std::string"""
        return _IMP_kernel.ParticleIndex___str__(self)

    def __repr__(self):
        r"""__repr__(ParticleIndex self) -> std::string"""
        return _IMP_kernel.ParticleIndex___repr__(self)
    __swig_destroy__ = _IMP_kernel.delete_ParticleIndex

# Register ParticleIndex in _IMP_kernel:
_IMP_kernel.ParticleIndex_swigregister(ParticleIndex)

class FloatsKey(_Value):
    r"""Proxy of C++ IMP::Key< 10 > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(FloatsKey self) -> FloatsKey
        __init__(FloatsKey self, std::string const & c, bool is_implicit_add_permitted=True) -> FloatsKey
        __init__(FloatsKey self, unsigned int i) -> FloatsKey
        """
        _IMP_kernel.FloatsKey_swiginit(self, _IMP_kernel.new_FloatsKey(*args))

    @staticmethod
    def add_key(sc):
        r"""add_key(std::string sc) -> unsigned int"""
        return _IMP_kernel.FloatsKey_add_key(sc)

    @staticmethod
    def get_key_exists(sc):
        r"""get_key_exists(std::string sc) -> bool"""
        return _IMP_kernel.FloatsKey_get_key_exists(sc)

    def get_string(self):
        r"""get_string(FloatsKey self) -> std::string const"""
        return _IMP_kernel.FloatsKey_get_string(self)

    def __cmp__(self, o):
        r"""__cmp__(FloatsKey self, FloatsKey o) -> int"""
        return _IMP_kernel.FloatsKey___cmp__(self, o)

    def __eq__(self, o):
        r"""__eq__(FloatsKey self, FloatsKey o) -> bool"""
        return _IMP_kernel.FloatsKey___eq__(self, o)

    def __ne__(self, o):
        r"""__ne__(FloatsKey self, FloatsKey o) -> bool"""
        return _IMP_kernel.FloatsKey___ne__(self, o)

    def __lt__(self, o):
        r"""__lt__(FloatsKey self, FloatsKey o) -> bool"""
        return _IMP_kernel.FloatsKey___lt__(self, o)

    def __gt__(self, o):
        r"""__gt__(FloatsKey self, FloatsKey o) -> bool"""
        return _IMP_kernel.FloatsKey___gt__(self, o)

    def __ge__(self, o):
        r"""__ge__(FloatsKey self, FloatsKey o) -> bool"""
        return _IMP_kernel.FloatsKey___ge__(self, o)

    def __le__(self, o):
        r"""__le__(FloatsKey self, FloatsKey o) -> bool"""
        return _IMP_kernel.FloatsKey___le__(self, o)

    def __hash__(self):
        r"""__hash__(FloatsKey self) -> std::size_t"""
        return _IMP_kernel.FloatsKey___hash__(self)

    def show(self, *args):
        r"""show(FloatsKey self, _ostream out=std::cout)"""
        return _IMP_kernel.FloatsKey_show(self, *args)

    @staticmethod
    def add_alias(old_key, new_name):
        r"""add_alias(FloatsKey old_key, std::string new_name) -> FloatsKey"""
        return _IMP_kernel.FloatsKey_add_alias(old_key, new_name)

    @staticmethod
    def get_number_of_keys():
        r"""get_number_of_keys() -> unsigned int"""
        return _IMP_kernel.FloatsKey_get_number_of_keys()

    def get_index(self):
        r"""get_index(FloatsKey self) -> unsigned int"""
        return _IMP_kernel.FloatsKey_get_index(self)

    @staticmethod
    def show_all(out):
        r"""show_all(_ostream out)"""
        return _IMP_kernel.FloatsKey_show_all(out)

    @staticmethod
    def get_all_strings():
        r"""get_all_strings() -> IMP::Vector< std::string >"""
        return _IMP_kernel.FloatsKey_get_all_strings()

    @staticmethod
    def get_number_unique():
        r"""get_number_unique() -> unsigned int"""
        return _IMP_kernel.FloatsKey_get_number_unique()

    def __str__(self):
        r"""__str__(FloatsKey self) -> std::string"""
        return _IMP_kernel.FloatsKey___str__(self)

    def __repr__(self):
        r"""__repr__(FloatsKey self) -> std::string"""
        return _IMP_kernel.FloatsKey___repr__(self)
    __swig_destroy__ = _IMP_kernel.delete_FloatsKey

# Register FloatsKey in _IMP_kernel:
_IMP_kernel.FloatsKey_swigregister(FloatsKey)

def FloatsKey_add_key(sc):
    r"""FloatsKey_add_key(std::string sc) -> unsigned int"""
    return _IMP_kernel.FloatsKey_add_key(sc)

def FloatsKey_get_key_exists(sc):
    r"""FloatsKey_get_key_exists(std::string sc) -> bool"""
    return _IMP_kernel.FloatsKey_get_key_exists(sc)

def FloatsKey_add_alias(old_key, new_name):
    r"""FloatsKey_add_alias(FloatsKey old_key, std::string new_name) -> FloatsKey"""
    return _IMP_kernel.FloatsKey_add_alias(old_key, new_name)

def FloatsKey_get_number_of_keys():
    r"""FloatsKey_get_number_of_keys() -> unsigned int"""
    return _IMP_kernel.FloatsKey_get_number_of_keys()

def FloatsKey_show_all(out):
    r"""FloatsKey_show_all(_ostream out)"""
    return _IMP_kernel.FloatsKey_show_all(out)

def FloatsKey_get_all_strings():
    r"""FloatsKey_get_all_strings() -> IMP::Vector< std::string >"""
    return _IMP_kernel.FloatsKey_get_all_strings()

def FloatsKey_get_number_unique():
    r"""FloatsKey_get_number_unique() -> unsigned int"""
    return _IMP_kernel.FloatsKey_get_number_unique()


def ParticlePair(a, b):
  return (a,b)
def ParticleTriplet(a, b, c):
  return (a,b,c)
def ParticleQuad(a, b, c, d):
  return (a,b,c,d)

class FloatIndex(_Value):
    r"""Proxy of C++ IMP::FloatIndex class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""__init__(FloatIndex self, ParticleIndex i0=ParticleIndex(), FloatKey i1=FloatKey()) -> FloatIndex"""
        _IMP_kernel.FloatIndex_swiginit(self, _IMP_kernel.new_FloatIndex(*args))

    def __hash__(self):
        r"""__hash__(FloatIndex self) -> std::size_t"""
        return _IMP_kernel.FloatIndex___hash__(self)

    def show(self, *args):
        r"""show(FloatIndex self, _ostream out=std::cout)"""
        return _IMP_kernel.FloatIndex_show(self, *args)

    def __cmp__(self, o):
        r"""__cmp__(FloatIndex self, FloatIndex o) -> int"""
        return _IMP_kernel.FloatIndex___cmp__(self, o)

    def __eq__(self, o):
        r"""__eq__(FloatIndex self, FloatIndex o) -> bool"""
        return _IMP_kernel.FloatIndex___eq__(self, o)

    def __ne__(self, o):
        r"""__ne__(FloatIndex self, FloatIndex o) -> bool"""
        return _IMP_kernel.FloatIndex___ne__(self, o)

    def __lt__(self, o):
        r"""__lt__(FloatIndex self, FloatIndex o) -> bool"""
        return _IMP_kernel.FloatIndex___lt__(self, o)

    def __gt__(self, o):
        r"""__gt__(FloatIndex self, FloatIndex o) -> bool"""
        return _IMP_kernel.FloatIndex___gt__(self, o)

    def __ge__(self, o):
        r"""__ge__(FloatIndex self, FloatIndex o) -> bool"""
        return _IMP_kernel.FloatIndex___ge__(self, o)

    def __le__(self, o):
        r"""__le__(FloatIndex self, FloatIndex o) -> bool"""
        return _IMP_kernel.FloatIndex___le__(self, o)

    def get_particle(self):
        r"""get_particle(FloatIndex self) -> ParticleIndex const &"""
        return _IMP_kernel.FloatIndex_get_particle(self)

    def set_particle(self, v):
        r"""set_particle(FloatIndex self, ParticleIndex const & v)"""
        return _IMP_kernel.FloatIndex_set_particle(self, v)

    def get_key(self):
        r"""get_key(FloatIndex self) -> FloatKey const &"""
        return _IMP_kernel.FloatIndex_get_key(self)

    def set_key(self, v):
        r"""set_key(FloatIndex self, FloatKey const & v)"""
        return _IMP_kernel.FloatIndex_set_key(self, v)

    def __str__(self):
        r"""__str__(FloatIndex self) -> std::string"""
        return _IMP_kernel.FloatIndex___str__(self)

    def __repr__(self):
        r"""__repr__(FloatIndex self) -> std::string"""
        return _IMP_kernel.FloatIndex___repr__(self)
    __swig_destroy__ = _IMP_kernel.delete_FloatIndex

# Register FloatIndex in _IMP_kernel:
_IMP_kernel.FloatIndex_swigregister(FloatIndex)

class _ParticleIndexTag(object):
    r"""Proxy of C++ IMP::ParticleIndexTag class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""__init__(_ParticleIndexTag self) -> _ParticleIndexTag"""
        _IMP_kernel._ParticleIndexTag_swiginit(self, _IMP_kernel.new__ParticleIndexTag())
    __swig_destroy__ = _IMP_kernel.delete__ParticleIndexTag

# Register _ParticleIndexTag in _IMP_kernel:
_IMP_kernel._ParticleIndexTag_swigregister(_ParticleIndexTag)

class ModelObject(Object):
    r"""Proxy of C++ IMP::ModelObject class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, m, name):
        r"""__init__(ModelObject self, Model m, std::string name) -> ModelObject"""
        if self.__class__ == ModelObject:
            _self = None
        else:
            _self = self
        _IMP_kernel.ModelObject_swiginit(self, _IMP_kernel.new_ModelObject(_self, m, name))

        if self.__class__ != ModelObject:
            _director_objects.register(self)



    __swig_destroy__ = _IMP_kernel.delete_ModelObject

    def get_model(self):
        r"""get_model(ModelObject self) -> Model"""
        return _IMP_kernel.ModelObject_get_model(self)

    def get_inputs(self):
        r"""get_inputs(ModelObject self) -> IMP::ModelObjectsTemp"""
        return _IMP_kernel.ModelObject_get_inputs(self)

    def get_outputs(self):
        r"""get_outputs(ModelObject self) -> IMP::ModelObjectsTemp"""
        return _IMP_kernel.ModelObject_get_outputs(self)

    def get_interactions(self):
        r"""get_interactions(ModelObject self) -> IMP::ModelObjectsTemps"""
        return _IMP_kernel.ModelObject_get_interactions(self)

    def get_has_dependencies(self):
        r"""get_has_dependencies(ModelObject self) -> bool"""
        return _IMP_kernel.ModelObject_get_has_dependencies(self)

    def set_has_dependencies(self, tf):
        r"""set_has_dependencies(ModelObject self, bool tf)"""
        return _IMP_kernel.ModelObject_set_has_dependencies(self, tf)

    def set_has_required_score_states(self, tf):
        r"""set_has_required_score_states(ModelObject self, bool tf)"""
        return _IMP_kernel.ModelObject_set_has_required_score_states(self, tf)

    def get_has_required_score_states(self):
        r"""get_has_required_score_states(ModelObject self) -> bool"""
        return _IMP_kernel.ModelObject_get_has_required_score_states(self)

    def get_required_score_states(self):
        r"""get_required_score_states(ModelObject self) -> IMP::ScoreStatesTemp const &"""
        return _IMP_kernel.ModelObject_get_required_score_states(self)

    def handle_set_has_required_score_states(self, arg0):
        r"""handle_set_has_required_score_states(ModelObject self, bool arg0)"""
        return _IMP_kernel.ModelObject_handle_set_has_required_score_states(self, arg0)

    def do_get_inputs(self):
        r"""do_get_inputs(ModelObject self) -> IMP::ModelObjectsTemp"""
        return _IMP_kernel.ModelObject_do_get_inputs(self)

    def do_get_outputs(self):
        r"""do_get_outputs(ModelObject self) -> IMP::ModelObjectsTemp"""
        return _IMP_kernel.ModelObject_do_get_outputs(self)

    def do_get_interactions(self):
        r"""do_get_interactions(ModelObject self) -> IMP::ModelObjectsTemps"""
        return _IMP_kernel.ModelObject_do_get_interactions(self)

    def __str__(self):
        r"""__str__(ModelObject self) -> std::string"""
        return _IMP_kernel.ModelObject___str__(self)

    def __repr__(self):
        r"""__repr__(ModelObject self) -> std::string"""
        return _IMP_kernel.ModelObject___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_ModelObject(o)


    def get_type_name(self):
        return self.__class__.__name__
    def do_show(self, out):
        pass
    def get_version_info(self):
        if"IMP" == "IMP":
          return VersionInfo(self.__module__,
                             __import__(self.__module__).get_module_version())
        else:
          return IMP.VersionInfo(self.__module__,
                             __import__(self.__module__).get_module_version())
    @staticmethod
    def get_from(o):
       return _object_cast_to_ModelObject(o)

    def __disown__(self):
        self.this.disown()
        _IMP_kernel.disown_ModelObject(self)
        return weakref.proxy(self)

    def do_destroy(self):
        r"""do_destroy(ModelObject self)"""
        return _IMP_kernel.ModelObject_do_destroy(self)

# Register ModelObject in _IMP_kernel:
_IMP_kernel.ModelObject_swigregister(ModelObject)
cvar = _IMP_kernel.cvar
NO_MAX = cvar.NO_MAX
BAD_SCORE = cvar.BAD_SCORE

class _ParticleInputs(object):
    r"""Proxy of C++ IMP::ParticleInputs class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    def get_inputs(self, m, pis):
        r"""get_inputs(_ParticleInputs self, Model m, IMP::ParticleIndexes const & pis) -> IMP::ModelObjectsTemp"""
        return _IMP_kernel._ParticleInputs_get_inputs(self, m, pis)

# Register _ParticleInputs in _IMP_kernel:
_IMP_kernel._ParticleInputs_swigregister(_ParticleInputs)

class _ParticleOutputs(object):
    r"""Proxy of C++ IMP::ParticleOutputs class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    def get_outputs(self, m, pis):
        r"""get_outputs(_ParticleOutputs self, Model m, IMP::ParticleIndexes const & pis) -> IMP::ModelObjectsTemp"""
        return _IMP_kernel._ParticleOutputs_get_outputs(self, m, pis)

# Register _ParticleOutputs in _IMP_kernel:
_IMP_kernel._ParticleOutputs_swigregister(_ParticleOutputs)


def get_input_particles(mos):
    r"""get_input_particles(IMP::ModelObjectsTemp const & mos) -> IMP::ParticlesTemp"""
    return _IMP_kernel.get_input_particles(mos)

def get_input_containers(mos):
    r"""get_input_containers(IMP::ModelObjectsTemp const & mos) -> IMP::ContainersTemp"""
    return _IMP_kernel.get_input_containers(mos)

def get_output_particles(mos):
    r"""get_output_particles(IMP::ModelObjectsTemp const & mos) -> IMP::ParticlesTemp"""
    return _IMP_kernel.get_output_particles(mos)

def get_output_containers(mos):
    r"""get_output_containers(IMP::ModelObjectsTemp const & mos) -> IMP::ContainersTemp"""
    return _IMP_kernel.get_output_containers(mos)
class DerivativeAccumulator(object):
    r"""Proxy of C++ IMP::DerivativeAccumulator class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(DerivativeAccumulator self, double weight=1.0) -> DerivativeAccumulator
        __init__(DerivativeAccumulator self, DerivativeAccumulator copy, double weight) -> DerivativeAccumulator
        """
        _IMP_kernel.DerivativeAccumulator_swiginit(self, _IMP_kernel.new_DerivativeAccumulator(*args))

    def __call__(self, value):
        r"""__call__(DerivativeAccumulator self, double const value) -> double"""
        return _IMP_kernel.DerivativeAccumulator___call__(self, value)

    def get_weight(self):
        r"""get_weight(DerivativeAccumulator self) -> double"""
        return _IMP_kernel.DerivativeAccumulator_get_weight(self)

    def show(self, *args):
        r"""show(DerivativeAccumulator self, _ostream out=std::cout)"""
        return _IMP_kernel.DerivativeAccumulator_show(self, *args)
    __swig_destroy__ = _IMP_kernel.delete_DerivativeAccumulator

# Register DerivativeAccumulator in _IMP_kernel:
_IMP_kernel.DerivativeAccumulator_swigregister(DerivativeAccumulator)

class EvaluationState(object):
    r"""Proxy of C++ IMP::EvaluationState class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    score = property(_IMP_kernel.EvaluationState_score_get, _IMP_kernel.EvaluationState_score_set, doc=r"""score : double""")
    good = property(_IMP_kernel.EvaluationState_good_get, _IMP_kernel.EvaluationState_good_set, doc=r"""good : bool""")

    def __init__(self, *args):
        r"""
        __init__(EvaluationState self, double oscore, bool ogood) -> EvaluationState
        __init__(EvaluationState self) -> EvaluationState
        """
        _IMP_kernel.EvaluationState_swiginit(self, _IMP_kernel.new_EvaluationState(*args))

    def show(self, *args):
        r"""show(EvaluationState self, _ostream out=std::cout)"""
        return _IMP_kernel.EvaluationState_show(self, *args)

    def __str__(self):
        r"""__str__(EvaluationState self) -> std::string"""
        return _IMP_kernel.EvaluationState___str__(self)

    def __repr__(self):
        r"""__repr__(EvaluationState self) -> std::string"""
        return _IMP_kernel.EvaluationState___repr__(self)
    __swig_destroy__ = _IMP_kernel.delete_EvaluationState

# Register EvaluationState in _IMP_kernel:
_IMP_kernel.EvaluationState_swigregister(EvaluationState)

class ScoreAccumulator(_Value):
    r"""Proxy of C++ IMP::ScoreAccumulator class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(ScoreAccumulator self) -> ScoreAccumulator
        __init__(ScoreAccumulator self, ScoreAccumulator o, Restraint r) -> ScoreAccumulator
        __init__(ScoreAccumulator self, ScoreAccumulator o, double weight, double local_max) -> ScoreAccumulator
        """
        _IMP_kernel.ScoreAccumulator_swiginit(self, _IMP_kernel.new_ScoreAccumulator(*args))

    def add_score(self, score):
        r"""add_score(ScoreAccumulator self, double score)"""
        return _IMP_kernel.ScoreAccumulator_add_score(self, score)

    def get_abort_evaluation(self):
        r"""get_abort_evaluation(ScoreAccumulator self) -> bool"""
        return _IMP_kernel.ScoreAccumulator_get_abort_evaluation(self)

    def get_is_evaluate_if_below(self):
        r"""get_is_evaluate_if_below(ScoreAccumulator self) -> bool"""
        return _IMP_kernel.ScoreAccumulator_get_is_evaluate_if_below(self)

    def get_is_evaluate_if_good(self):
        r"""get_is_evaluate_if_good(ScoreAccumulator self) -> bool"""
        return _IMP_kernel.ScoreAccumulator_get_is_evaluate_if_good(self)

    def get_maximum(self):
        r"""get_maximum(ScoreAccumulator self) -> double"""
        return _IMP_kernel.ScoreAccumulator_get_maximum(self)

    def get_derivative_accumulator(self):
        r"""get_derivative_accumulator(ScoreAccumulator self) -> DerivativeAccumulator"""
        return _IMP_kernel.ScoreAccumulator_get_derivative_accumulator(self)

    def show(self, *args):
        r"""show(ScoreAccumulator self, _ostream out=std::cout)"""
        return _IMP_kernel.ScoreAccumulator_show(self, *args)

    def __str__(self):
        r"""__str__(ScoreAccumulator self) -> std::string"""
        return _IMP_kernel.ScoreAccumulator___str__(self)

    def __repr__(self):
        r"""__repr__(ScoreAccumulator self) -> std::string"""
        return _IMP_kernel.ScoreAccumulator___repr__(self)
    __swig_destroy__ = _IMP_kernel.delete_ScoreAccumulator

# Register ScoreAccumulator in _IMP_kernel:
_IMP_kernel.ScoreAccumulator_swigregister(ScoreAccumulator)

class ScoreState(ModelObject):
    r"""Proxy of C++ IMP::ScoreState class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def set_can_skip(self, can_skip):
        r"""set_can_skip(ScoreState self, bool can_skip)"""
        return _IMP_kernel.ScoreState_set_can_skip(self, can_skip)

    def __init__(self, m, name):
        r"""__init__(ScoreState self, Model m, std::string name) -> ScoreState"""
        if self.__class__ == ScoreState:
            _self = None
        else:
            _self = self
        _IMP_kernel.ScoreState_swiginit(self, _IMP_kernel.new_ScoreState(_self, m, name))

        if self.__class__ != ScoreState:
            _director_objects.register(self)




    def before_evaluate(self):
        r"""before_evaluate(ScoreState self)"""
        return _IMP_kernel.ScoreState_before_evaluate(self)

    def after_evaluate(self, accpt):
        r"""after_evaluate(ScoreState self, DerivativeAccumulator accpt)"""
        return _IMP_kernel.ScoreState_after_evaluate(self, accpt)

    def get_can_skip(self):
        r"""get_can_skip(ScoreState self) -> bool"""
        return _IMP_kernel.ScoreState_get_can_skip(self)

    def get_has_update_order(self):
        r"""get_has_update_order(ScoreState self) -> bool"""
        return _IMP_kernel.ScoreState_get_has_update_order(self)

    def get_update_order(self):
        r"""get_update_order(ScoreState self) -> unsigned int"""
        return _IMP_kernel.ScoreState_get_update_order(self)

    def handle_set_has_required_score_states(self, tf):
        r"""handle_set_has_required_score_states(ScoreState self, bool tf)"""
        return _IMP_kernel.ScoreState_handle_set_has_required_score_states(self, tf)

    def do_before_evaluate(self):
        r"""do_before_evaluate(ScoreState self)"""
        return _IMP_kernel.ScoreState_do_before_evaluate(self)

    def do_after_evaluate(self, accpt):
        r"""do_after_evaluate(ScoreState self, DerivativeAccumulator accpt)"""
        return _IMP_kernel.ScoreState_do_after_evaluate(self, accpt)
    __swig_destroy__ = _IMP_kernel.delete_ScoreState

    def __str__(self):
        r"""__str__(ScoreState self) -> std::string"""
        return _IMP_kernel.ScoreState___str__(self)

    def __repr__(self):
        r"""__repr__(ScoreState self) -> std::string"""
        return _IMP_kernel.ScoreState___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_ScoreState(o)


    def get_type_name(self):
        return self.__class__.__name__
    def do_show(self, out):
        pass
    def get_version_info(self):
        if"IMP" == "IMP":
          return VersionInfo(self.__module__,
                             __import__(self.__module__).get_module_version())
        else:
          return IMP.VersionInfo(self.__module__,
                             __import__(self.__module__).get_module_version())
    @staticmethod
    def get_from(o):
       return _object_cast_to_ScoreState(o)

    def __disown__(self):
        self.this.disown()
        _IMP_kernel.disown_ScoreState(self)
        return weakref.proxy(self)

    def do_destroy(self):
        r"""do_destroy(ScoreState self)"""
        return _IMP_kernel.ScoreState_do_destroy(self)

    def do_get_inputs(self):
        r"""do_get_inputs(ScoreState self) -> IMP::ModelObjectsTemp"""
        return _IMP_kernel.ScoreState_do_get_inputs(self)

    def do_get_outputs(self):
        r"""do_get_outputs(ScoreState self) -> IMP::ModelObjectsTemp"""
        return _IMP_kernel.ScoreState_do_get_outputs(self)

    def do_get_interactions(self):
        r"""do_get_interactions(ScoreState self) -> IMP::ModelObjectsTemps"""
        return _IMP_kernel.ScoreState_do_get_interactions(self)

# Register ScoreState in _IMP_kernel:
_IMP_kernel.ScoreState_swigregister(ScoreState)


def get_update_order(input):
    r"""get_update_order(IMP::ScoreStatesTemp input) -> IMP::ScoreStatesTemp"""
    return _IMP_kernel.get_update_order(input)
class Constraint(ScoreState):
    r"""Proxy of C++ IMP::Constraint class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""__init__(Constraint self, Model m, std::string name="Constraint %1%") -> Constraint"""
        if self.__class__ == Constraint:
            _self = None
        else:
            _self = self
        _IMP_kernel.Constraint_swiginit(self, _IMP_kernel.new_Constraint(_self, *args))

        if self.__class__ != Constraint:
            _director_objects.register(self)




    def do_update_attributes(self):
        r"""do_update_attributes(Constraint self)"""
        return _IMP_kernel.Constraint_do_update_attributes(self)

    def do_update_derivatives(self, da):
        r"""do_update_derivatives(Constraint self, DerivativeAccumulator da)"""
        return _IMP_kernel.Constraint_do_update_derivatives(self, da)

    def do_before_evaluate(self):
        r"""do_before_evaluate(Constraint self)"""
        return _IMP_kernel.Constraint_do_before_evaluate(self)

    def do_after_evaluate(self, da):
        r"""do_after_evaluate(Constraint self, DerivativeAccumulator da)"""
        return _IMP_kernel.Constraint_do_after_evaluate(self, da)
    __swig_destroy__ = _IMP_kernel.delete_Constraint

    def __str__(self):
        r"""__str__(Constraint self) -> std::string"""
        return _IMP_kernel.Constraint___str__(self)

    def __repr__(self):
        r"""__repr__(Constraint self) -> std::string"""
        return _IMP_kernel.Constraint___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_Constraint(o)


    def get_type_name(self):
        return self.__class__.__name__
    def do_show(self, out):
        pass
    def get_version_info(self):
        if"IMP" == "IMP":
          return VersionInfo(self.__module__,
                             __import__(self.__module__).get_module_version())
        else:
          return IMP.VersionInfo(self.__module__,
                             __import__(self.__module__).get_module_version())
    @staticmethod
    def get_from(o):
       return _object_cast_to_Constraint(o)

    def __disown__(self):
        self.this.disown()
        _IMP_kernel.disown_Constraint(self)
        return weakref.proxy(self)

    def do_destroy(self):
        r"""do_destroy(Constraint self)"""
        return _IMP_kernel.Constraint_do_destroy(self)

    def do_get_inputs(self):
        r"""do_get_inputs(Constraint self) -> IMP::ModelObjectsTemp"""
        return _IMP_kernel.Constraint_do_get_inputs(self)

    def do_get_outputs(self):
        r"""do_get_outputs(Constraint self) -> IMP::ModelObjectsTemp"""
        return _IMP_kernel.Constraint_do_get_outputs(self)

    def do_get_interactions(self):
        r"""do_get_interactions(Constraint self) -> IMP::ModelObjectsTemps"""
        return _IMP_kernel.Constraint_do_get_interactions(self)

# Register Constraint in _IMP_kernel:
_IMP_kernel.Constraint_swigregister(Constraint)

class Container(ModelObject):
    r"""Proxy of C++ IMP::Container class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""__init__(Container self, Model m, std::string name="Container %1%") -> Container"""
        if self.__class__ == Container:
            _self = None
        else:
            _self = self
        _IMP_kernel.Container_swiginit(self, _IMP_kernel.new_Container(_self, *args))

        if self.__class__ != Container:
            _director_objects.register(self)




    def do_get_contents_hash(self):
        r"""do_get_contents_hash(Container self) -> std::size_t"""
        return _IMP_kernel.Container_do_get_contents_hash(self)

    def get_all_possible_indexes(self):
        r"""get_all_possible_indexes(Container self) -> IMP::ParticleIndexes"""
        return _IMP_kernel.Container_get_all_possible_indexes(self)

    def get_contents_hash(self):
        r"""get_contents_hash(Container self) -> std::size_t"""
        return _IMP_kernel.Container_get_contents_hash(self)

    def do_get_outputs(self):
        r"""do_get_outputs(Container self) -> IMP::ModelObjectsTemp"""
        return _IMP_kernel.Container_do_get_outputs(self)

    def get_is_decomposable(self):
        r"""get_is_decomposable(Container self) -> bool"""
        return _IMP_kernel.Container_get_is_decomposable(self)

    def validate_readable(self):
        r"""validate_readable(Container self)"""
        return _IMP_kernel.Container_validate_readable(self)

    def validate_writable(self):
        r"""validate_writable(Container self)"""
        return _IMP_kernel.Container_validate_writable(self)

    def set_is_readable(self, tf):
        r"""set_is_readable(Container self, bool tf)"""
        return _IMP_kernel.Container_set_is_readable(self, tf)

    def set_is_writable(self, tf):
        r"""set_is_writable(Container self, bool tf)"""
        return _IMP_kernel.Container_set_is_writable(self, tf)
    __swig_destroy__ = _IMP_kernel.delete_Container

    def __str__(self):
        r"""__str__(Container self) -> std::string"""
        return _IMP_kernel.Container___str__(self)

    def __repr__(self):
        r"""__repr__(Container self) -> std::string"""
        return _IMP_kernel.Container___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_Container(o)


    def get_type_name(self):
        return self.__class__.__name__
    def do_show(self, out):
        pass
    def get_version_info(self):
        if"IMP" == "IMP":
          return VersionInfo(self.__module__,
                             __import__(self.__module__).get_module_version())
        else:
          return IMP.VersionInfo(self.__module__,
                             __import__(self.__module__).get_module_version())
    @staticmethod
    def get_from(o):
       return _object_cast_to_Container(o)

    def __disown__(self):
        self.this.disown()
        _IMP_kernel.disown_Container(self)
        return weakref.proxy(self)

    def do_destroy(self):
        r"""do_destroy(Container self)"""
        return _IMP_kernel.Container_do_destroy(self)

    def handle_set_has_required_score_states(self, arg0):
        r"""handle_set_has_required_score_states(Container self, bool arg0)"""
        return _IMP_kernel.Container_handle_set_has_required_score_states(self, arg0)

    def do_get_inputs(self):
        r"""do_get_inputs(Container self) -> IMP::ModelObjectsTemp"""
        return _IMP_kernel.Container_do_get_inputs(self)

    def do_get_interactions(self):
        r"""do_get_interactions(Container self) -> IMP::ModelObjectsTemps"""
        return _IMP_kernel.Container_do_get_interactions(self)

# Register Container in _IMP_kernel:
_IMP_kernel.Container_swigregister(Container)

class RestraintInfo(Object):
    r"""Proxy of C++ IMP::RestraintInfo class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""__init__(RestraintInfo self, std::string name="RestraintInfo %1%") -> RestraintInfo"""
        _IMP_kernel.RestraintInfo_swiginit(self, _IMP_kernel.new_RestraintInfo(*args))

    def add_int(self, key, value):
        r"""add_int(RestraintInfo self, std::string key, int value)"""
        return _IMP_kernel.RestraintInfo_add_int(self, key, value)

    def get_number_of_int(self):
        r"""get_number_of_int(RestraintInfo self) -> unsigned int"""
        return _IMP_kernel.RestraintInfo_get_number_of_int(self)

    def get_int_key(self, i):
        r"""get_int_key(RestraintInfo self, unsigned int i) -> std::string"""
        return _IMP_kernel.RestraintInfo_get_int_key(self, i)

    def get_int_value(self, i):
        r"""get_int_value(RestraintInfo self, unsigned int i) -> int"""
        return _IMP_kernel.RestraintInfo_get_int_value(self, i)

    def add_float(self, key, value):
        r"""add_float(RestraintInfo self, std::string key, double value)"""
        return _IMP_kernel.RestraintInfo_add_float(self, key, value)

    def get_number_of_float(self):
        r"""get_number_of_float(RestraintInfo self) -> unsigned int"""
        return _IMP_kernel.RestraintInfo_get_number_of_float(self)

    def get_float_key(self, i):
        r"""get_float_key(RestraintInfo self, unsigned int i) -> std::string"""
        return _IMP_kernel.RestraintInfo_get_float_key(self, i)

    def get_float_value(self, i):
        r"""get_float_value(RestraintInfo self, unsigned int i) -> double"""
        return _IMP_kernel.RestraintInfo_get_float_value(self, i)

    def add_string(self, key, value):
        r"""add_string(RestraintInfo self, std::string key, std::string value)"""
        return _IMP_kernel.RestraintInfo_add_string(self, key, value)

    def get_number_of_string(self):
        r"""get_number_of_string(RestraintInfo self) -> unsigned int"""
        return _IMP_kernel.RestraintInfo_get_number_of_string(self)

    def get_string_key(self, i):
        r"""get_string_key(RestraintInfo self, unsigned int i) -> std::string"""
        return _IMP_kernel.RestraintInfo_get_string_key(self, i)

    def get_string_value(self, i):
        r"""get_string_value(RestraintInfo self, unsigned int i) -> std::string"""
        return _IMP_kernel.RestraintInfo_get_string_value(self, i)

    def add_filename(self, key, value):
        r"""add_filename(RestraintInfo self, std::string key, std::string value)"""
        return _IMP_kernel.RestraintInfo_add_filename(self, key, value)

    def get_number_of_filename(self):
        r"""get_number_of_filename(RestraintInfo self) -> unsigned int"""
        return _IMP_kernel.RestraintInfo_get_number_of_filename(self)

    def get_filename_key(self, i):
        r"""get_filename_key(RestraintInfo self, unsigned int i) -> std::string"""
        return _IMP_kernel.RestraintInfo_get_filename_key(self, i)

    def get_filename_value(self, i):
        r"""get_filename_value(RestraintInfo self, unsigned int i) -> std::string"""
        return _IMP_kernel.RestraintInfo_get_filename_value(self, i)

    def add_floats(self, key, value):
        r"""add_floats(RestraintInfo self, std::string key, IMP::Floats value)"""
        return _IMP_kernel.RestraintInfo_add_floats(self, key, value)

    def get_number_of_floats(self):
        r"""get_number_of_floats(RestraintInfo self) -> unsigned int"""
        return _IMP_kernel.RestraintInfo_get_number_of_floats(self)

    def get_floats_key(self, i):
        r"""get_floats_key(RestraintInfo self, unsigned int i) -> std::string"""
        return _IMP_kernel.RestraintInfo_get_floats_key(self, i)

    def get_floats_value(self, i):
        r"""get_floats_value(RestraintInfo self, unsigned int i) -> IMP::Floats"""
        return _IMP_kernel.RestraintInfo_get_floats_value(self, i)

    def add_ints(self, key, value):
        r"""add_ints(RestraintInfo self, std::string key, IMP::Ints value)"""
        return _IMP_kernel.RestraintInfo_add_ints(self, key, value)

    def get_number_of_ints(self):
        r"""get_number_of_ints(RestraintInfo self) -> unsigned int"""
        return _IMP_kernel.RestraintInfo_get_number_of_ints(self)

    def get_ints_key(self, i):
        r"""get_ints_key(RestraintInfo self, unsigned int i) -> std::string"""
        return _IMP_kernel.RestraintInfo_get_ints_key(self, i)

    def get_ints_value(self, i):
        r"""get_ints_value(RestraintInfo self, unsigned int i) -> IMP::Ints"""
        return _IMP_kernel.RestraintInfo_get_ints_value(self, i)

    def add_strings(self, key, value):
        r"""add_strings(RestraintInfo self, std::string key, IMP::Strings value)"""
        return _IMP_kernel.RestraintInfo_add_strings(self, key, value)

    def get_number_of_strings(self):
        r"""get_number_of_strings(RestraintInfo self) -> unsigned int"""
        return _IMP_kernel.RestraintInfo_get_number_of_strings(self)

    def get_strings_key(self, i):
        r"""get_strings_key(RestraintInfo self, unsigned int i) -> std::string"""
        return _IMP_kernel.RestraintInfo_get_strings_key(self, i)

    def get_strings_value(self, i):
        r"""get_strings_value(RestraintInfo self, unsigned int i) -> IMP::Strings"""
        return _IMP_kernel.RestraintInfo_get_strings_value(self, i)

    def add_filenames(self, key, value):
        r"""add_filenames(RestraintInfo self, std::string key, IMP::Strings value)"""
        return _IMP_kernel.RestraintInfo_add_filenames(self, key, value)

    def get_number_of_filenames(self):
        r"""get_number_of_filenames(RestraintInfo self) -> unsigned int"""
        return _IMP_kernel.RestraintInfo_get_number_of_filenames(self)

    def get_filenames_key(self, i):
        r"""get_filenames_key(RestraintInfo self, unsigned int i) -> std::string"""
        return _IMP_kernel.RestraintInfo_get_filenames_key(self, i)

    def get_filenames_value(self, i):
        r"""get_filenames_value(RestraintInfo self, unsigned int i) -> IMP::Strings"""
        return _IMP_kernel.RestraintInfo_get_filenames_value(self, i)

    def add_particle_indexes(self, key, value):
        r"""add_particle_indexes(RestraintInfo self, std::string key, IMP::ParticleIndexes value)"""
        return _IMP_kernel.RestraintInfo_add_particle_indexes(self, key, value)

    def get_number_of_particle_indexes(self):
        r"""get_number_of_particle_indexes(RestraintInfo self) -> unsigned int"""
        return _IMP_kernel.RestraintInfo_get_number_of_particle_indexes(self)

    def get_particle_indexes_key(self, i):
        r"""get_particle_indexes_key(RestraintInfo self, unsigned int i) -> std::string"""
        return _IMP_kernel.RestraintInfo_get_particle_indexes_key(self, i)

    def get_particle_indexes_value(self, i):
        r"""get_particle_indexes_value(RestraintInfo self, unsigned int i) -> IMP::ParticleIndexes"""
        return _IMP_kernel.RestraintInfo_get_particle_indexes_value(self, i)

    def get_version_info(self):
        r"""get_version_info(RestraintInfo self) -> VersionInfo"""
        return _IMP_kernel.RestraintInfo_get_version_info(self)

    def __str__(self):
        r"""__str__(RestraintInfo self) -> std::string"""
        return _IMP_kernel.RestraintInfo___str__(self)

    def __repr__(self):
        r"""__repr__(RestraintInfo self) -> std::string"""
        return _IMP_kernel.RestraintInfo___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_RestraintInfo(o)


# Register RestraintInfo in _IMP_kernel:
_IMP_kernel.RestraintInfo_swigregister(RestraintInfo)

class Restraint(ModelObject):
    r"""Proxy of C++ IMP::Restraint class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, m, name):
        r"""__init__(Restraint self, Model m, std::string name) -> Restraint"""
        if self.__class__ == Restraint:
            _self = None
        else:
            _self = self
        _IMP_kernel.Restraint_swiginit(self, _IMP_kernel.new_Restraint(_self, m, name))

        if self.__class__ != Restraint:
            _director_objects.register(self)




    def get_score(self):
        r"""get_score(Restraint self) -> double"""
        return _IMP_kernel.Restraint_get_score(self)

    def evaluate(self, calc_derivs):
        r"""evaluate(Restraint self, bool calc_derivs) -> double"""
        return _IMP_kernel.Restraint_evaluate(self, calc_derivs)

    def evaluate_moved(self, calc_derivs, moved_pis, reset_pis):
        r"""evaluate_moved(Restraint self, bool calc_derivs, IMP::ParticleIndexes const & moved_pis, IMP::ParticleIndexes const & reset_pis) -> double"""
        return _IMP_kernel.Restraint_evaluate_moved(self, calc_derivs, moved_pis, reset_pis)

    def evaluate_moved_if_below(self, calc_derivatives, moved_pis, reset_pis, max):
        r"""evaluate_moved_if_below(Restraint self, bool calc_derivatives, IMP::ParticleIndexes const & moved_pis, IMP::ParticleIndexes const & reset_pis, double max) -> double"""
        return _IMP_kernel.Restraint_evaluate_moved_if_below(self, calc_derivatives, moved_pis, reset_pis, max)

    def evaluate_moved_if_good(self, calc_derivatives, moved_pis, reset_pis):
        r"""evaluate_moved_if_good(Restraint self, bool calc_derivatives, IMP::ParticleIndexes const & moved_pis, IMP::ParticleIndexes const & reset_pis) -> double"""
        return _IMP_kernel.Restraint_evaluate_moved_if_good(self, calc_derivatives, moved_pis, reset_pis)

    def evaluate_if_good(self, calc_derivatives):
        r"""evaluate_if_good(Restraint self, bool calc_derivatives) -> double"""
        return _IMP_kernel.Restraint_evaluate_if_good(self, calc_derivatives)

    def evaluate_if_below(self, calc_derivatives, max):
        r"""evaluate_if_below(Restraint self, bool calc_derivatives, double max) -> double"""
        return _IMP_kernel.Restraint_evaluate_if_below(self, calc_derivatives, max)

    def unprotected_evaluate(self, da):
        r"""unprotected_evaluate(Restraint self, DerivativeAccumulator da) -> double"""
        return _IMP_kernel.Restraint_unprotected_evaluate(self, da)

    def unprotected_evaluate_moved(self, da, moved_pis, reset_pis):
        r"""unprotected_evaluate_moved(Restraint self, DerivativeAccumulator da, IMP::ParticleIndexes const & moved_pis, IMP::ParticleIndexes const & reset_pis) -> double"""
        return _IMP_kernel.Restraint_unprotected_evaluate_moved(self, da, moved_pis, reset_pis)

    def unprotected_evaluate_if_good(self, da, max):
        r"""unprotected_evaluate_if_good(Restraint self, DerivativeAccumulator da, double max) -> double"""
        return _IMP_kernel.Restraint_unprotected_evaluate_if_good(self, da, max)

    def unprotected_evaluate_if_below(self, da, max):
        r"""unprotected_evaluate_if_below(Restraint self, DerivativeAccumulator da, double max) -> double"""
        return _IMP_kernel.Restraint_unprotected_evaluate_if_below(self, da, max)

    def unprotected_evaluate_moved_if_below(self, da, moved_pis, reset_pis, max):
        r"""unprotected_evaluate_moved_if_below(Restraint self, DerivativeAccumulator da, IMP::ParticleIndexes const & moved_pis, IMP::ParticleIndexes const & reset_pis, double max) -> double"""
        return _IMP_kernel.Restraint_unprotected_evaluate_moved_if_below(self, da, moved_pis, reset_pis, max)

    def unprotected_evaluate_moved_if_good(self, da, moved_pis, reset_pis, max):
        r"""unprotected_evaluate_moved_if_good(Restraint self, DerivativeAccumulator da, IMP::ParticleIndexes const & moved_pis, IMP::ParticleIndexes const & reset_pis, double max) -> double"""
        return _IMP_kernel.Restraint_unprotected_evaluate_moved_if_good(self, da, moved_pis, reset_pis, max)

    def get_static_info(self):
        r"""get_static_info(Restraint self) -> RestraintInfo"""
        return _IMP_kernel.Restraint_get_static_info(self)

    def get_dynamic_info(self):
        r"""get_dynamic_info(Restraint self) -> RestraintInfo"""
        return _IMP_kernel.Restraint_get_dynamic_info(self)

    def add_score_and_derivatives(self, sa):
        r"""add_score_and_derivatives(Restraint self, ScoreAccumulator sa)"""
        return _IMP_kernel.Restraint_add_score_and_derivatives(self, sa)

    def add_score_and_derivatives_moved(self, sa, moved_pis, reset_pis):
        r"""add_score_and_derivatives_moved(Restraint self, ScoreAccumulator sa, IMP::ParticleIndexes const & moved_pis, IMP::ParticleIndexes const & reset_pis)"""
        return _IMP_kernel.Restraint_add_score_and_derivatives_moved(self, sa, moved_pis, reset_pis)

    def create_decomposition(self):
        r"""create_decomposition(Restraint self) -> Restraint"""
        return _IMP_kernel.Restraint_create_decomposition(self)

    def create_current_decomposition(self):
        r"""create_current_decomposition(Restraint self) -> Restraint"""
        return _IMP_kernel.Restraint_create_current_decomposition(self)

    def set_weight(self, weight):
        r"""set_weight(Restraint self, IMP::Float weight)"""
        return _IMP_kernel.Restraint_set_weight(self, weight)

    def get_weight(self):
        r"""get_weight(Restraint self) -> IMP::Float"""
        return _IMP_kernel.Restraint_get_weight(self)

    def get_maximum_score(self):
        r"""get_maximum_score(Restraint self) -> double"""
        return _IMP_kernel.Restraint_get_maximum_score(self)

    def set_maximum_score(self, s):
        r"""set_maximum_score(Restraint self, double s)"""
        return _IMP_kernel.Restraint_set_maximum_score(self, s)

    def create_scoring_function(self, *args):
        r"""create_scoring_function(Restraint self, double weight=1.0, double max=NO_MAX) -> ScoringFunction"""
        return _IMP_kernel.Restraint_create_scoring_function(self, *args)

    def set_last_score(self, s):
        r"""set_last_score(Restraint self, double s)"""
        return _IMP_kernel.Restraint_set_last_score(self, s)

    def set_last_last_score(self, s):
        r"""set_last_last_score(Restraint self, double s)"""
        return _IMP_kernel.Restraint_set_last_last_score(self, s)

    def get_last_score(self):
        r"""get_last_score(Restraint self) -> double"""
        return _IMP_kernel.Restraint_get_last_score(self)

    def get_last_last_score(self):
        r"""get_last_last_score(Restraint self) -> double"""
        return _IMP_kernel.Restraint_get_last_last_score(self)

    def get_was_good(self):
        r"""get_was_good(Restraint self) -> bool"""
        return _IMP_kernel.Restraint_get_was_good(self)
    __swig_destroy__ = _IMP_kernel.delete_Restraint

    def do_create_decomposition(self):
        r"""do_create_decomposition(Restraint self) -> IMP::Restraints"""
        return _IMP_kernel.Restraint_do_create_decomposition(self)

    def do_create_current_decomposition(self):
        r"""do_create_current_decomposition(Restraint self) -> IMP::Restraints"""
        return _IMP_kernel.Restraint_do_create_current_decomposition(self)

    def do_add_score_and_derivatives(self, sa):
        r"""do_add_score_and_derivatives(Restraint self, ScoreAccumulator sa)"""
        return _IMP_kernel.Restraint_do_add_score_and_derivatives(self, sa)

    def do_add_score_and_derivatives_moved(self, sa, moved_pis, reset_pis):
        r"""do_add_score_and_derivatives_moved(Restraint self, ScoreAccumulator sa, IMP::ParticleIndexes const & moved_pis, IMP::ParticleIndexes const & reset_pis)"""
        return _IMP_kernel.Restraint_do_add_score_and_derivatives_moved(self, sa, moved_pis, reset_pis)

    def do_get_outputs(self):
        r"""do_get_outputs(Restraint self) -> IMP::ModelObjectsTemp"""
        return _IMP_kernel.Restraint_do_get_outputs(self)

    def __str__(self):
        r"""__str__(Restraint self) -> std::string"""
        return _IMP_kernel.Restraint___str__(self)

    def __repr__(self):
        r"""__repr__(Restraint self) -> std::string"""
        return _IMP_kernel.Restraint___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_Restraint(o)


    def get_type_name(self):
        return self.__class__.__name__
    def do_show(self, out):
        pass
    def get_version_info(self):
        if"IMP" == "IMP":
          return VersionInfo(self.__module__,
                             __import__(self.__module__).get_module_version())
        else:
          return IMP.VersionInfo(self.__module__,
                             __import__(self.__module__).get_module_version())
    @staticmethod
    def get_from(o):
       return _object_cast_to_Restraint(o)

    def __disown__(self):
        self.this.disown()
        _IMP_kernel.disown_Restraint(self)
        return weakref.proxy(self)

    def do_destroy(self):
        r"""do_destroy(Restraint self)"""
        return _IMP_kernel.Restraint_do_destroy(self)

    def handle_set_has_required_score_states(self, arg0):
        r"""handle_set_has_required_score_states(Restraint self, bool arg0)"""
        return _IMP_kernel.Restraint_handle_set_has_required_score_states(self, arg0)

    def do_get_inputs(self):
        r"""do_get_inputs(Restraint self) -> IMP::ModelObjectsTemp"""
        return _IMP_kernel.Restraint_do_get_inputs(self)

    def do_get_interactions(self):
        r"""do_get_interactions(Restraint self) -> IMP::ModelObjectsTemps"""
        return _IMP_kernel.Restraint_do_get_interactions(self)

# Register Restraint in _IMP_kernel:
_IMP_kernel.Restraint_swigregister(Restraint)

class _RestraintsAdaptor(_InputAdaptor):
    r"""Proxy of C++ IMP::RestraintsAdaptor class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(_RestraintsAdaptor self) -> _RestraintsAdaptor
        __init__(_RestraintsAdaptor self, IMP::Restraints const & sf) -> _RestraintsAdaptor
        __init__(_RestraintsAdaptor self, IMP::RestraintsTemp const & sf) -> _RestraintsAdaptor
        __init__(_RestraintsAdaptor self, Restraint sf) -> _RestraintsAdaptor
        """
        _IMP_kernel._RestraintsAdaptor_swiginit(self, _IMP_kernel.new__RestraintsAdaptor(*args))
    __swig_destroy__ = _IMP_kernel.delete__RestraintsAdaptor

# Register _RestraintsAdaptor in _IMP_kernel:
_IMP_kernel._RestraintsAdaptor_swigregister(_RestraintsAdaptor)

class RestraintSet(Restraint):
    r"""Proxy of C++ IMP::RestraintSet class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(RestraintSet self, Model m, double weight, std::string const & name="RestraintSet %1%") -> RestraintSet
        __init__(RestraintSet self, Model m, std::string const & name="RestraintSet %1%") -> RestraintSet
        __init__(RestraintSet self, IMP::RestraintsTemp const & rs, double weight, std::string const & name="RestraintSet %1%") -> RestraintSet
        """
        if self.__class__ == RestraintSet:
            _self = None
        else:
            _self = self
        _IMP_kernel.RestraintSet_swiginit(self, _IMP_kernel.new_RestraintSet(_self, *args))

        if self.__class__ != RestraintSet:
            _director_objects.register(self)




    def unprotected_evaluate(self, da):
        r"""unprotected_evaluate(RestraintSet self, DerivativeAccumulator da) -> double"""
        return _IMP_kernel.RestraintSet_unprotected_evaluate(self, da)

    def get_type_name(self):
        r"""get_type_name(RestraintSet self) -> std::string"""
        return _IMP_kernel.RestraintSet_get_type_name(self)

    def get_version_info(self):
        r"""get_version_info(RestraintSet self) -> VersionInfo"""
        return _IMP_kernel.RestraintSet_get_version_info(self)

    def remove_restraint(self, d):
        r"""remove_restraint(RestraintSet self, Restraint d)"""
        return _IMP_kernel.RestraintSet_remove_restraint(self, d)

    def remove_restraints(self, d):
        r"""remove_restraints(RestraintSet self, IMP::Restraints const & d)"""
        return _IMP_kernel.RestraintSet_remove_restraints(self, d)

    def set_restraints(self, ps):
        r"""set_restraints(RestraintSet self, IMP::Restraints const & ps)"""
        return _IMP_kernel.RestraintSet_set_restraints(self, ps)

    def set_restraints_order(self, objs):
        r"""set_restraints_order(RestraintSet self, IMP::Restraints const & objs)"""
        return _IMP_kernel.RestraintSet_set_restraints_order(self, objs)

    def add_restraint(self, obj):
        r"""add_restraint(RestraintSet self, Restraint obj) -> unsigned int"""
        return _IMP_kernel.RestraintSet_add_restraint(self, obj)

    def add_restraints(self, objs):
        r"""add_restraints(RestraintSet self, IMP::Restraints const & objs)"""
        return _IMP_kernel.RestraintSet_add_restraints(self, objs)

    def clear_restraints(self):
        r"""clear_restraints(RestraintSet self)"""
        return _IMP_kernel.RestraintSet_clear_restraints(self)

    def get_number_of_restraints(self):
        r"""get_number_of_restraints(RestraintSet self) -> unsigned int"""
        return _IMP_kernel.RestraintSet_get_number_of_restraints(self)

    def get_has_restraints(self):
        r"""get_has_restraints(RestraintSet self) -> bool"""
        return _IMP_kernel.RestraintSet_get_has_restraints(self)

    def get_restraint(self, i):
        r"""get_restraint(RestraintSet self, unsigned int i) -> Restraint"""
        return _IMP_kernel.RestraintSet_get_restraint(self, i)

    def get_restraints(self):
        r"""get_restraints(RestraintSet self) -> IMP::Restraints"""
        return _IMP_kernel.RestraintSet_get_restraints(self)

    def reserve_restraints(self, sz):
        r"""reserve_restraints(RestraintSet self, unsigned int sz)"""
        return _IMP_kernel.RestraintSet_reserve_restraints(self, sz)

    def get_non_sets_and_sets(self):
        r"""get_non_sets_and_sets(RestraintSet self) -> std::pair< IMP::RestraintsTemp,IMP::RestraintSetsTemp >"""
        return _IMP_kernel.RestraintSet_get_non_sets_and_sets(self)

    def do_get_inputs(self):
        r"""do_get_inputs(RestraintSet self) -> IMP::ModelObjectsTemp"""
        return _IMP_kernel.RestraintSet_do_get_inputs(self)

    def create_scoring_function(self, *args):
        r"""create_scoring_function(RestraintSet self, double weight=1.0, double max=std::numeric_limits< double >::max()) -> ScoringFunction"""
        return _IMP_kernel.RestraintSet_create_scoring_function(self, *args)

    def get_last_score(self):
        r"""get_last_score(RestraintSet self) -> double"""
        return _IMP_kernel.RestraintSet_get_last_score(self)

    def get_last_last_score(self):
        r"""get_last_last_score(RestraintSet self) -> double"""
        return _IMP_kernel.RestraintSet_get_last_last_score(self)

    def __str__(self):
        r"""__str__(RestraintSet self) -> std::string"""
        return _IMP_kernel.RestraintSet___str__(self)

    def __repr__(self):
        r"""__repr__(RestraintSet self) -> std::string"""
        return _IMP_kernel.RestraintSet___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_RestraintSet(o)


    def get_type_name(self):
        return self.__class__.__name__
    def do_show(self, out):
        pass
    def get_version_info(self):
        if"IMP" == "IMP":
          return VersionInfo(self.__module__,
                             __import__(self.__module__).get_module_version())
        else:
          return IMP.VersionInfo(self.__module__,
                             __import__(self.__module__).get_module_version())
    @staticmethod
    def get_from(o):
       return _object_cast_to_RestraintSet(o)

    def __disown__(self):
        self.this.disown()
        _IMP_kernel.disown_RestraintSet(self)
        return weakref.proxy(self)

    def do_destroy(self):
        r"""do_destroy(RestraintSet self)"""
        return _IMP_kernel.RestraintSet_do_destroy(self)

    def handle_set_has_required_score_states(self, arg0):
        r"""handle_set_has_required_score_states(RestraintSet self, bool arg0)"""
        return _IMP_kernel.RestraintSet_handle_set_has_required_score_states(self, arg0)

    def do_get_outputs(self):
        r"""do_get_outputs(RestraintSet self) -> IMP::ModelObjectsTemp"""
        return _IMP_kernel.RestraintSet_do_get_outputs(self)

    def do_get_interactions(self):
        r"""do_get_interactions(RestraintSet self) -> IMP::ModelObjectsTemps"""
        return _IMP_kernel.RestraintSet_do_get_interactions(self)

    def do_create_decomposition(self):
        r"""do_create_decomposition(RestraintSet self) -> IMP::Restraints"""
        return _IMP_kernel.RestraintSet_do_create_decomposition(self)

    def do_create_current_decomposition(self):
        r"""do_create_current_decomposition(RestraintSet self) -> IMP::Restraints"""
        return _IMP_kernel.RestraintSet_do_create_current_decomposition(self)

    def do_add_score_and_derivatives(self, sa):
        r"""do_add_score_and_derivatives(RestraintSet self, ScoreAccumulator sa)"""
        return _IMP_kernel.RestraintSet_do_add_score_and_derivatives(self, sa)

    def do_add_score_and_derivatives_moved(self, sa, moved_pis, reset_pis):
        r"""do_add_score_and_derivatives_moved(RestraintSet self, ScoreAccumulator sa, IMP::ParticleIndexes const & moved_pis, IMP::ParticleIndexes const & reset_pis)"""
        return _IMP_kernel.RestraintSet_do_add_score_and_derivatives_moved(self, sa, moved_pis, reset_pis)

# Register RestraintSet in _IMP_kernel:
_IMP_kernel.RestraintSet_swigregister(RestraintSet)


def get_restraints(rs):
    r"""get_restraints(IMP::RestraintsTemp const & rs) -> IMP::RestraintsTemp"""
    return _IMP_kernel.get_restraints(rs)

def _check_particle(p, a):
   if (not p.get_is_active()):
      raise ValueError("Inactive Particle")
   if (type(a)() == a):
      raise IndexError("Cannot use default Index")
   if (not p.has_attribute(a)):
      raise IndexError("Particle does not have attribute")

class Particle(ModelObject):
    r"""Proxy of C++ IMP::Particle class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def get_version_info(self):
        r"""get_version_info(Particle self) -> VersionInfo"""
        return _IMP_kernel.Particle_get_version_info(self)

    def __init__(self, *args):
        r"""
        __init__(Particle self, Model m, std::string name) -> Particle
        __init__(Particle self, Model m) -> Particle
        """
        _IMP_kernel.Particle_swiginit(self, _IMP_kernel.new_Particle(*args))

    def get_float_keys(self):
        r"""get_float_keys(Particle self) -> IMP::FloatKeys"""
        return _IMP_kernel.Particle_get_float_keys(self)

    def get_floats_keys(self):
        r"""get_floats_keys(Particle self) -> IMP::FloatsKeys"""
        return _IMP_kernel.Particle_get_floats_keys(self)

    def get_int_keys(self):
        r"""get_int_keys(Particle self) -> IMP::IntKeys"""
        return _IMP_kernel.Particle_get_int_keys(self)

    def get_ints_keys(self):
        r"""get_ints_keys(Particle self) -> IMP::IntsKeys"""
        return _IMP_kernel.Particle_get_ints_keys(self)

    def get_string_keys(self):
        r"""get_string_keys(Particle self) -> IMP::StringKeys"""
        return _IMP_kernel.Particle_get_string_keys(self)

    def get_object_keys(self):
        r"""get_object_keys(Particle self) -> IMP::ObjectKeys"""
        return _IMP_kernel.Particle_get_object_keys(self)

    def add_cache_attribute(self, *args):
        r"""
        add_cache_attribute(Particle self, FloatKey name, IMP::Float value)
        add_cache_attribute(Particle self, FloatsKey name, IMP::Floats value)
        add_cache_attribute(Particle self, IntKey name, IMP::Int value)
        add_cache_attribute(Particle self, IntsKey name, IMP::Ints value)
        add_cache_attribute(Particle self, StringKey name, IMP::String value)
        add_cache_attribute(Particle self, ObjectKey name, Object value)
        add_cache_attribute(Particle self, IMP::WeakObjectKey name, Object value)
        """
        return _IMP_kernel.Particle_add_cache_attribute(self, *args)

    def get_weak_object_keys(self):
        r"""get_weak_object_keys(Particle self) -> IMP::WeakObjectKeys"""
        return _IMP_kernel.Particle_get_weak_object_keys(self)

    def add_to_derivative(self, key, value, da):
        r"""add_to_derivative(Particle self, FloatKey key, IMP::Float value, DerivativeAccumulator da)"""
        return _IMP_kernel.Particle_add_to_derivative(self, key, value, da)

    def set_is_optimized(self, k, tf):
        r"""set_is_optimized(Particle self, FloatKey k, bool tf)"""
        return _IMP_kernel.Particle_set_is_optimized(self, k, tf)

    def get_is_optimized(self, k):
        r"""get_is_optimized(Particle self, FloatKey k) -> bool"""
        return _IMP_kernel.Particle_get_is_optimized(self, k)

    def get_derivative(self, k):
        r"""get_derivative(Particle self, FloatKey k) -> IMP::Float"""
        return _IMP_kernel.Particle_get_derivative(self, k)

    def add_attribute(self, *args):
        r"""
        add_attribute(Particle self, FloatKey name, IMP::Float initial_value)
        add_attribute(Particle self, FloatsKey name, IMP::Floats initial_value)
        add_attribute(Particle self, IntKey name, IMP::Int initial_value)
        add_attribute(Particle self, IntsKey name, IMP::Ints initial_value)
        add_attribute(Particle self, StringKey name, IMP::String initial_value)
        add_attribute(Particle self, ObjectKey name, Object initial_value)
        add_attribute(Particle self, IMP::WeakObjectKey name, Object initial_value)
        add_attribute(Particle self, FloatKey name, IMP::Float const initial_value, bool optimized)
        add_attribute(Particle self, ParticleIndexKey k, Particle v)
        """
        return _IMP_kernel.Particle_add_attribute(self, *args)

    def has_attribute(self, *args):
        r"""
        has_attribute(Particle self, FloatKey name) -> bool
        has_attribute(Particle self, FloatsKey name) -> bool
        has_attribute(Particle self, IntKey name) -> bool
        has_attribute(Particle self, IntsKey name) -> bool
        has_attribute(Particle self, StringKey name) -> bool
        has_attribute(Particle self, ObjectKey name) -> bool
        has_attribute(Particle self, IMP::WeakObjectKey name) -> bool
        has_attribute(Particle self, ParticleIndexKey k) -> bool
        """
        return _IMP_kernel.Particle_has_attribute(self, *args)

    def set_value(self, *args):
        r"""
        set_value(Particle self, FloatKey name, IMP::Float value)
        set_value(Particle self, FloatsKey name, IMP::Floats value)
        set_value(Particle self, IntKey name, IMP::Int value)
        set_value(Particle self, IntsKey name, IMP::Ints value)
        set_value(Particle self, StringKey name, IMP::String value)
        set_value(Particle self, ObjectKey name, Object value)
        set_value(Particle self, IMP::WeakObjectKey name, Object value)
        set_value(Particle self, ParticleIndexKey k, Particle v)
        """
        return _IMP_kernel.Particle_set_value(self, *args)

    def get_value(self, *args):
        r"""
        get_value(Particle self, FloatKey name) -> IMP::Float
        get_value(Particle self, FloatsKey name) -> IMP::Floats
        get_value(Particle self, IntKey name) -> IMP::Int
        get_value(Particle self, IntsKey name) -> IMP::Ints
        get_value(Particle self, StringKey name) -> IMP::String
        get_value(Particle self, ObjectKey name) -> Object
        get_value(Particle self, IMP::WeakObjectKey name) -> Object
        get_value(Particle self, ParticleIndexKey k) -> Particle
        """
        return _IMP_kernel.Particle_get_value(self, *args)

    def remove_attribute(self, *args):
        r"""
        remove_attribute(Particle self, FloatKey name)
        remove_attribute(Particle self, FloatsKey name)
        remove_attribute(Particle self, IntKey name)
        remove_attribute(Particle self, IntsKey name)
        remove_attribute(Particle self, StringKey name)
        remove_attribute(Particle self, ObjectKey name)
        remove_attribute(Particle self, IMP::WeakObjectKey name)
        remove_attribute(Particle self, ParticleIndexKey k)
        """
        return _IMP_kernel.Particle_remove_attribute(self, *args)

    def get_particle_keys(self):
        r"""get_particle_keys(Particle self) -> IMP::ParticleIndexKeys"""
        return _IMP_kernel.Particle_get_particle_keys(self)

    def show(self, *args):
        r"""show(Particle self, _ostream out=std::cout)"""
        return _IMP_kernel.Particle_show(self, *args)

    def get_is_active(self):
        r"""get_is_active(Particle self) -> bool"""
        return _IMP_kernel.Particle_get_is_active(self)

    def get_index(self):
        r"""get_index(Particle self) -> ParticleIndex"""
        return _IMP_kernel.Particle_get_index(self)

    def __eq__(self, *args):
        r"""
        __eq__(Particle self, Particle o) -> bool
        __eq__(Particle self, Decorator d) -> bool
        """
        return _IMP_kernel.Particle___eq__(self, *args)

    def __ne__(self, *args):
        r"""
        __ne__(Particle self, Particle o) -> bool
        __ne__(Particle self, Decorator d) -> bool
        """
        return _IMP_kernel.Particle___ne__(self, *args)

    def __le__(self, *args):
        r"""
        __le__(Particle self, Particle o) -> bool
        __le__(Particle self, Decorator d) -> bool
        """
        return _IMP_kernel.Particle___le__(self, *args)

    def __lt__(self, *args):
        r"""
        __lt__(Particle self, Particle o) -> bool
        __lt__(Particle self, Decorator d) -> bool
        """
        return _IMP_kernel.Particle___lt__(self, *args)

    def __ge__(self, *args):
        r"""
        __ge__(Particle self, Particle o) -> bool
        __ge__(Particle self, Decorator d) -> bool
        """
        return _IMP_kernel.Particle___ge__(self, *args)

    def __gt__(self, *args):
        r"""
        __gt__(Particle self, Particle o) -> bool
        __gt__(Particle self, Decorator d) -> bool
        """
        return _IMP_kernel.Particle___gt__(self, *args)

    __hash__ = ModelObject.__hash__


    def __str__(self):
        r"""__str__(Particle self) -> std::string"""
        return _IMP_kernel.Particle___str__(self)

    def __repr__(self):
        r"""__repr__(Particle self) -> std::string"""
        return _IMP_kernel.Particle___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_Particle(o)


# Register Particle in _IMP_kernel:
_IMP_kernel.Particle_swigregister(Particle)

class _ParticleAdaptor(_InputAdaptor):
    r"""Proxy of C++ IMP::ParticleAdaptor class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(_ParticleAdaptor self) -> _ParticleAdaptor
        __init__(_ParticleAdaptor self, Particle p) -> _ParticleAdaptor
        __init__(_ParticleAdaptor self, Decorator d) -> _ParticleAdaptor
        """
        _IMP_kernel._ParticleAdaptor_swiginit(self, _IMP_kernel.new__ParticleAdaptor(*args))

    def get_model(self):
        r"""get_model(_ParticleAdaptor self) -> Model"""
        return _IMP_kernel._ParticleAdaptor_get_model(self)

    def get_particle_index(self):
        r"""get_particle_index(_ParticleAdaptor self) -> ParticleIndex"""
        return _IMP_kernel._ParticleAdaptor_get_particle_index(self)
    __swig_destroy__ = _IMP_kernel.delete__ParticleAdaptor

# Register _ParticleAdaptor in _IMP_kernel:
_IMP_kernel._ParticleAdaptor_swigregister(_ParticleAdaptor)

class _DependencyGraphVertexIndex(object):
    r"""Proxy of C++ IMP::DependencyGraphVertexIndex class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""__init__(_DependencyGraphVertexIndex self) -> _DependencyGraphVertexIndex"""
        _IMP_kernel._DependencyGraphVertexIndex_swiginit(self, _IMP_kernel.new__DependencyGraphVertexIndex())
    __swig_destroy__ = _IMP_kernel.delete__DependencyGraphVertexIndex

# Register _DependencyGraphVertexIndex in _IMP_kernel:
_IMP_kernel._DependencyGraphVertexIndex_swigregister(_DependencyGraphVertexIndex)


def show_as_graphviz(name, out):
    r"""show_as_graphviz(IMP::DependencyGraph const & name, TextOutput out)"""
    return _IMP_kernel.show_as_graphviz(name, out)

def get_vertex_index(g):
    r"""get_vertex_index(IMP::DependencyGraph const & g) -> _DependencyGraphVertexIndex"""
    return _IMP_kernel.get_vertex_index(g)

def get_dependency_graph(m):
    r"""get_dependency_graph(Model m) -> IMP::DependencyGraph"""
    return _IMP_kernel.get_dependency_graph(m)

def get_pruned_dependency_graph(m):
    r"""get_pruned_dependency_graph(Model m) -> IMP::DependencyGraph"""
    return _IMP_kernel.get_pruned_dependency_graph(m)

def get_dependent_restraints(m, pi):
    r"""get_dependent_restraints(Model m, ParticleIndex pi) -> IMP::RestraintsTemp"""
    return _IMP_kernel.get_dependent_restraints(m, pi)

def get_dependent_score_states(m, pi):
    r"""get_dependent_score_states(Model m, ParticleIndex pi) -> IMP::ScoreStatesTemp"""
    return _IMP_kernel.get_dependent_score_states(m, pi)

def get_required_score_states(*args):
    r"""
    get_required_score_states(IMP::ModelObjectsTemp const & mos, IMP::ScoreStatesTemp exclude=IMP::ScoreStatesTemp()) -> IMP::ScoreStatesTemp
    get_required_score_states(ModelObject p, IMP::ModelObjectsTemp const & all, IMP::DependencyGraph const & dg, _DependencyGraphVertexIndex index) -> IMP::ScoreStatesTemp
    get_required_score_states(Model m, ParticleIndex pi) -> IMP::ScoreStatesTemp
    """
    return _IMP_kernel.get_required_score_states(*args)

def get_dependent_particles(*args):
    r"""
    get_dependent_particles(ModelObject p, IMP::ModelObjectsTemp const & all, IMP::DependencyGraph const & dg, _DependencyGraphVertexIndex index) -> IMP::ParticlesTemp
    get_dependent_particles(Model m, ParticleIndex pi) -> IMP::ParticlesTemp
    """
    return _IMP_kernel.get_dependent_particles(*args)
class ScoringFunction(ModelObject):
    r"""Proxy of C++ IMP::ScoringFunction class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def do_add_score_and_derivatives(self, sa, ss):
        r"""do_add_score_and_derivatives(ScoringFunction self, ScoreAccumulator sa, IMP::ScoreStatesTemp const & ss)"""
        return _IMP_kernel.ScoringFunction_do_add_score_and_derivatives(self, sa, ss)

    def do_add_score_and_derivatives_moved(self, sa, moved_pis, reset_pis, ss):
        r"""do_add_score_and_derivatives_moved(ScoringFunction self, ScoreAccumulator sa, IMP::ParticleIndexes const & moved_pis, IMP::ParticleIndexes const & reset_pis, IMP::ScoreStatesTemp const & ss)"""
        return _IMP_kernel.ScoringFunction_do_add_score_and_derivatives_moved(self, sa, moved_pis, reset_pis, ss)

    def get_score_accumulator_if_below(self, deriv, max):
        r"""get_score_accumulator_if_below(ScoringFunction self, bool deriv, double max) -> ScoreAccumulator"""
        return _IMP_kernel.ScoringFunction_get_score_accumulator_if_below(self, deriv, max)

    def get_score_accumulator_if_good(self, deriv):
        r"""get_score_accumulator_if_good(ScoringFunction self, bool deriv) -> ScoreAccumulator"""
        return _IMP_kernel.ScoringFunction_get_score_accumulator_if_good(self, deriv)

    def get_score_accumulator(self, deriv):
        r"""get_score_accumulator(ScoringFunction self, bool deriv) -> ScoreAccumulator"""
        return _IMP_kernel.ScoringFunction_get_score_accumulator(self, deriv)

    def __init__(self, m, name):
        r"""__init__(ScoringFunction self, Model m, std::string name) -> ScoringFunction"""
        if self.__class__ == ScoringFunction:
            _self = None
        else:
            _self = self
        _IMP_kernel.ScoringFunction_swiginit(self, _IMP_kernel.new_ScoringFunction(_self, m, name))

        if self.__class__ != ScoringFunction:
            _director_objects.register(self)




    def do_get_outputs(self):
        r"""do_get_outputs(ScoringFunction self) -> IMP::ModelObjectsTemp"""
        return _IMP_kernel.ScoringFunction_do_get_outputs(self)

    def evaluate_if_good(self, derivatives):
        r"""evaluate_if_good(ScoringFunction self, bool derivatives) -> double"""
        return _IMP_kernel.ScoringFunction_evaluate_if_good(self, derivatives)

    def evaluate(self, derivatives):
        r"""evaluate(ScoringFunction self, bool derivatives) -> double"""
        return _IMP_kernel.ScoringFunction_evaluate(self, derivatives)

    def evaluate_moved(self, derivatives, moved_pis, reset_pis):
        r"""evaluate_moved(ScoringFunction self, bool derivatives, IMP::ParticleIndexes const & moved_pis, IMP::ParticleIndexes const & reset_pis) -> double"""
        return _IMP_kernel.ScoringFunction_evaluate_moved(self, derivatives, moved_pis, reset_pis)

    def evaluate_moved_if_below(self, derivatives, moved_pis, reset_pis, max):
        r"""evaluate_moved_if_below(ScoringFunction self, bool derivatives, IMP::ParticleIndexes const & moved_pis, IMP::ParticleIndexes const & reset_pis, double max) -> double"""
        return _IMP_kernel.ScoringFunction_evaluate_moved_if_below(self, derivatives, moved_pis, reset_pis, max)

    def evaluate_moved_if_good(self, derivatives, moved_pis, reset_pis):
        r"""evaluate_moved_if_good(ScoringFunction self, bool derivatives, IMP::ParticleIndexes const & moved_pis, IMP::ParticleIndexes const & reset_pis) -> double"""
        return _IMP_kernel.ScoringFunction_evaluate_moved_if_good(self, derivatives, moved_pis, reset_pis)

    def evaluate_if_below(self, derivatives, max):
        r"""evaluate_if_below(ScoringFunction self, bool derivatives, double max) -> double"""
        return _IMP_kernel.ScoringFunction_evaluate_if_below(self, derivatives, max)

    def get_had_good_score(self):
        r"""get_had_good_score(ScoringFunction self) -> bool"""
        return _IMP_kernel.ScoringFunction_get_had_good_score(self)

    def get_last_score(self):
        r"""get_last_score(ScoringFunction self) -> double"""
        return _IMP_kernel.ScoringFunction_get_last_score(self)

    def create_restraints(self):
        r"""create_restraints(ScoringFunction self) -> IMP::Restraints"""
        return _IMP_kernel.ScoringFunction_create_restraints(self)

    def __str__(self):
        r"""__str__(ScoringFunction self) -> std::string"""
        return _IMP_kernel.ScoringFunction___str__(self)

    def __repr__(self):
        r"""__repr__(ScoringFunction self) -> std::string"""
        return _IMP_kernel.ScoringFunction___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_ScoringFunction(o)


    def get_type_name(self):
        return self.__class__.__name__
    def do_show(self, out):
        pass
    def get_version_info(self):
        if"IMP" == "IMP":
          return VersionInfo(self.__module__,
                             __import__(self.__module__).get_module_version())
        else:
          return IMP.VersionInfo(self.__module__,
                             __import__(self.__module__).get_module_version())
    @staticmethod
    def get_from(o):
       return _object_cast_to_ScoringFunction(o)

    __swig_destroy__ = _IMP_kernel.delete_ScoringFunction
    def __disown__(self):
        self.this.disown()
        _IMP_kernel.disown_ScoringFunction(self)
        return weakref.proxy(self)

    def do_destroy(self):
        r"""do_destroy(ScoringFunction self)"""
        return _IMP_kernel.ScoringFunction_do_destroy(self)

    def handle_set_has_required_score_states(self, arg0):
        r"""handle_set_has_required_score_states(ScoringFunction self, bool arg0)"""
        return _IMP_kernel.ScoringFunction_handle_set_has_required_score_states(self, arg0)

    def do_get_inputs(self):
        r"""do_get_inputs(ScoringFunction self) -> IMP::ModelObjectsTemp"""
        return _IMP_kernel.ScoringFunction_do_get_inputs(self)

    def do_get_interactions(self):
        r"""do_get_interactions(ScoringFunction self) -> IMP::ModelObjectsTemps"""
        return _IMP_kernel.ScoringFunction_do_get_interactions(self)

# Register ScoringFunction in _IMP_kernel:
_IMP_kernel.ScoringFunction_swigregister(ScoringFunction)


def create_decomposition(*args):
    r"""
    create_decomposition(IMP::RestraintsTemp const & rs) -> IMP::Restraints
    create_decomposition(ScoringFunction sf) -> IMP::ScoringFunctions
    """
    return _IMP_kernel.create_decomposition(*args)
class _ScoringFunctionAdaptor(_InputAdaptor):
    r"""Proxy of C++ IMP::ScoringFunctionAdaptor class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(_ScoringFunctionAdaptor self) -> _ScoringFunctionAdaptor
        __init__(_ScoringFunctionAdaptor self, ScoringFunction sf) -> _ScoringFunctionAdaptor
        __init__(_ScoringFunctionAdaptor self, IMP::RestraintsTemp const & sf) -> _ScoringFunctionAdaptor
        __init__(_ScoringFunctionAdaptor self, IMP::Restraints const & sf) -> _ScoringFunctionAdaptor
        __init__(_ScoringFunctionAdaptor self, Restraint sf) -> _ScoringFunctionAdaptor
        """
        _IMP_kernel._ScoringFunctionAdaptor_swiginit(self, _IMP_kernel.new__ScoringFunctionAdaptor(*args))
    __swig_destroy__ = _IMP_kernel.delete__ScoringFunctionAdaptor

# Register _ScoringFunctionAdaptor in _IMP_kernel:
_IMP_kernel._ScoringFunctionAdaptor_swigregister(_ScoringFunctionAdaptor)


def show_restraint_hierarchy(*args):
    r"""show_restraint_hierarchy(_ScoringFunctionAdaptor rs, _ostream out=std::cout)"""
    return _IMP_kernel.show_restraint_hierarchy(*args)
class Undecorator(Object):
    r"""Proxy of C++ IMP::Undecorator class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, m, name):
        r"""__init__(Undecorator self, Model m, std::string name) -> Undecorator"""
        if self.__class__ == Undecorator:
            _self = None
        else:
            _self = self
        _IMP_kernel.Undecorator_swiginit(self, _IMP_kernel.new_Undecorator(_self, m, name))

        if self.__class__ != Undecorator:
            _director_objects.register(self)




    def teardown(self, pi):
        r"""teardown(Undecorator self, ParticleIndex pi)"""
        return _IMP_kernel.Undecorator_teardown(self, pi)

    def __str__(self):
        r"""__str__(Undecorator self) -> std::string"""
        return _IMP_kernel.Undecorator___str__(self)

    def __repr__(self):
        r"""__repr__(Undecorator self) -> std::string"""
        return _IMP_kernel.Undecorator___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_Undecorator(o)


    def get_type_name(self):
        return self.__class__.__name__
    def do_show(self, out):
        pass
    def get_version_info(self):
        if"IMP" == "IMP":
          return VersionInfo(self.__module__,
                             __import__(self.__module__).get_module_version())
        else:
          return IMP.VersionInfo(self.__module__,
                             __import__(self.__module__).get_module_version())
    @staticmethod
    def get_from(o):
       return _object_cast_to_Undecorator(o)

    __swig_destroy__ = _IMP_kernel.delete_Undecorator
    def __disown__(self):
        self.this.disown()
        _IMP_kernel.disown_Undecorator(self)
        return weakref.proxy(self)

    def do_destroy(self):
        r"""do_destroy(Undecorator self)"""
        return _IMP_kernel.Undecorator_do_destroy(self)

# Register Undecorator in _IMP_kernel:
_IMP_kernel.Undecorator_swigregister(Undecorator)

class Model(Object):
    r"""Proxy of C++ IMP::Model class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""__init__(Model self, std::string name="Model %1%") -> Model"""
        _IMP_kernel.Model_swiginit(self, _IMP_kernel.new_Model(*args))

    def clear_particle_caches(self, pi):
        r"""clear_particle_caches(Model self, ParticleIndex pi)"""
        return _IMP_kernel.Model_clear_particle_caches(self, pi)

    def add_particle(self, name):
        r"""add_particle(Model self, std::string name) -> ParticleIndex"""
        return _IMP_kernel.Model_add_particle(self, name)

    def get_particle_name(self, pi):
        r"""get_particle_name(Model self, ParticleIndex pi) -> std::string"""
        return _IMP_kernel.Model_get_particle_name(self, pi)

    def add_undecorator(self, pi, d):
        r"""add_undecorator(Model self, ParticleIndex pi, Undecorator d)"""
        return _IMP_kernel.Model_add_undecorator(self, pi, d)

    def remove_score_state(self, d):
        r"""remove_score_state(Model self, ScoreState d)"""
        return _IMP_kernel.Model_remove_score_state(self, d)

    def remove_score_states(self, d):
        r"""remove_score_states(Model self, IMP::ScoreStates const & d)"""
        return _IMP_kernel.Model_remove_score_states(self, d)

    def set_score_states(self, ps):
        r"""set_score_states(Model self, IMP::ScoreStates const & ps)"""
        return _IMP_kernel.Model_set_score_states(self, ps)

    def set_score_states_order(self, objs):
        r"""set_score_states_order(Model self, IMP::ScoreStates const & objs)"""
        return _IMP_kernel.Model_set_score_states_order(self, objs)

    def add_score_state(self, obj):
        r"""add_score_state(Model self, ScoreState obj) -> unsigned int"""
        return _IMP_kernel.Model_add_score_state(self, obj)

    def add_score_states(self, objs):
        r"""add_score_states(Model self, IMP::ScoreStates const & objs)"""
        return _IMP_kernel.Model_add_score_states(self, objs)

    def clear_score_states(self):
        r"""clear_score_states(Model self)"""
        return _IMP_kernel.Model_clear_score_states(self)

    def get_number_of_score_states(self):
        r"""get_number_of_score_states(Model self) -> unsigned int"""
        return _IMP_kernel.Model_get_number_of_score_states(self)

    def get_has_score_states(self):
        r"""get_has_score_states(Model self) -> bool"""
        return _IMP_kernel.Model_get_has_score_states(self)

    def get_score_state(self, i):
        r"""get_score_state(Model self, unsigned int i) -> ScoreState"""
        return _IMP_kernel.Model_get_score_state(self, i)

    def get_score_states(self):
        r"""get_score_states(Model self) -> IMP::ScoreStates"""
        return _IMP_kernel.Model_get_score_states(self)

    def reserve_score_states(self, sz):
        r"""reserve_score_states(Model self, unsigned int sz)"""
        return _IMP_kernel.Model_reserve_score_states(self, sz)

    def update(self):
        r"""update(Model self)"""
        return _IMP_kernel.Model_update(self)

    def add_attribute(self, *args):
        r"""
        add_attribute(Model self, FloatKey attribute_key, ParticleIndex particle, IMP::Float value)
        add_attribute(Model self, IntKey attribute_key, ParticleIndex particle, IMP::Int value)
        add_attribute(Model self, FloatsKey attribute_key, ParticleIndex particle, IMP::Floats value)
        add_attribute(Model self, IntsKey attribute_key, ParticleIndex particle, IMP::Ints value)
        add_attribute(Model self, StringKey attribute_key, ParticleIndex particle, IMP::String value)
        add_attribute(Model self, ParticleIndexesKey attribute_key, ParticleIndex particle, IMP::ParticleIndexes value)
        add_attribute(Model self, ParticleIndexKey attribute_key, ParticleIndex particle, ParticleIndex value)
        add_attribute(Model self, ObjectKey attribute_key, ParticleIndex particle, Object value)
        add_attribute(Model self, IMP::WeakObjectKey attribute_key, ParticleIndex particle, Object value)
        """
        return _IMP_kernel.Model_add_attribute(self, *args)

    def remove_attribute(self, *args):
        r"""
        remove_attribute(Model self, FloatKey attribute_key, ParticleIndex particle)
        remove_attribute(Model self, IntKey attribute_key, ParticleIndex particle)
        remove_attribute(Model self, FloatsKey attribute_key, ParticleIndex particle)
        remove_attribute(Model self, IntsKey attribute_key, ParticleIndex particle)
        remove_attribute(Model self, StringKey attribute_key, ParticleIndex particle)
        remove_attribute(Model self, ParticleIndexesKey attribute_key, ParticleIndex particle)
        remove_attribute(Model self, ParticleIndexKey attribute_key, ParticleIndex particle)
        remove_attribute(Model self, ObjectKey attribute_key, ParticleIndex particle)
        remove_attribute(Model self, IMP::WeakObjectKey attribute_key, ParticleIndex particle)
        """
        return _IMP_kernel.Model_remove_attribute(self, *args)

    def get_has_attribute(self, *args):
        r"""
        get_has_attribute(Model self, FloatKey attribute_key, ParticleIndex particle) -> bool
        get_has_attribute(Model self, IntKey attribute_key, ParticleIndex particle) -> bool
        get_has_attribute(Model self, FloatsKey attribute_key, ParticleIndex particle) -> bool
        get_has_attribute(Model self, IntsKey attribute_key, ParticleIndex particle) -> bool
        get_has_attribute(Model self, StringKey attribute_key, ParticleIndex particle) -> bool
        get_has_attribute(Model self, ParticleIndexesKey attribute_key, ParticleIndex particle) -> bool
        get_has_attribute(Model self, ParticleIndexKey attribute_key, ParticleIndex particle) -> bool
        get_has_attribute(Model self, ObjectKey attribute_key, ParticleIndex particle) -> bool
        get_has_attribute(Model self, IMP::WeakObjectKey attribute_key, ParticleIndex particle) -> bool
        """
        return _IMP_kernel.Model_get_has_attribute(self, *args)

    def set_attribute(self, *args):
        r"""
        set_attribute(Model self, FloatKey attribute_key, ParticleIndex particle, IMP::Float value)
        set_attribute(Model self, IntKey attribute_key, ParticleIndex particle, IMP::Int value)
        set_attribute(Model self, FloatsKey attribute_key, ParticleIndex particle, IMP::Floats value)
        set_attribute(Model self, IntsKey attribute_key, ParticleIndex particle, IMP::Ints value)
        set_attribute(Model self, StringKey attribute_key, ParticleIndex particle, IMP::String value)
        set_attribute(Model self, ParticleIndexesKey attribute_key, ParticleIndex particle, IMP::ParticleIndexes value)
        set_attribute(Model self, ParticleIndexKey attribute_key, ParticleIndex particle, ParticleIndex value)
        set_attribute(Model self, ObjectKey attribute_key, ParticleIndex particle, Object value)
        set_attribute(Model self, IMP::WeakObjectKey attribute_key, ParticleIndex particle, Object value)
        """
        return _IMP_kernel.Model_set_attribute(self, *args)

    def get_attribute(self, *args):
        r"""
        get_attribute(Model self, FloatKey attribute_key, ParticleIndex particle) -> IMP::Float
        get_attribute(Model self, IntKey attribute_key, ParticleIndex particle) -> IMP::Int
        get_attribute(Model self, FloatsKey attribute_key, ParticleIndex particle) -> IMP::Floats
        get_attribute(Model self, IntsKey attribute_key, ParticleIndex particle) -> IMP::Ints
        get_attribute(Model self, StringKey attribute_key, ParticleIndex particle) -> IMP::String
        get_attribute(Model self, ParticleIndexesKey attribute_key, ParticleIndex particle) -> IMP::ParticleIndexes
        get_attribute(Model self, ParticleIndexKey attribute_key, ParticleIndex particle) -> ParticleIndex
        get_attribute(Model self, ObjectKey attribute_key, ParticleIndex particle) -> Object
        get_attribute(Model self, IMP::WeakObjectKey attribute_key, ParticleIndex particle) -> Object
        """
        return _IMP_kernel.Model_get_attribute(self, *args)

    def add_cache_attribute(self, *args):
        r"""
        add_cache_attribute(Model self, FloatKey attribute_key, ParticleIndex particle, IMP::Float value)
        add_cache_attribute(Model self, IntKey attribute_key, ParticleIndex particle, IMP::Int value)
        add_cache_attribute(Model self, FloatsKey attribute_key, ParticleIndex particle, IMP::Floats value)
        add_cache_attribute(Model self, IntsKey attribute_key, ParticleIndex particle, IMP::Ints value)
        add_cache_attribute(Model self, StringKey attribute_key, ParticleIndex particle, IMP::String value)
        add_cache_attribute(Model self, ParticleIndexesKey attribute_key, ParticleIndex particle, IMP::ParticleIndexes value)
        add_cache_attribute(Model self, ParticleIndexKey attribute_key, ParticleIndex particle, ParticleIndex value)
        add_cache_attribute(Model self, ObjectKey attribute_key, ParticleIndex particle, Object value)
        add_cache_attribute(Model self, IMP::WeakObjectKey attribute_key, ParticleIndex particle, Object value)
        """
        return _IMP_kernel.Model_add_cache_attribute(self, *args)

    def set_is_optimized(self, arg2, arg3, arg4):
        r"""set_is_optimized(Model self, FloatKey arg2, ParticleIndex arg3, bool arg4)"""
        return _IMP_kernel.Model_set_is_optimized(self, arg2, arg3, arg4)

    def add_to_derivative(self, k, particle, v, da):
        r"""add_to_derivative(Model self, FloatKey k, ParticleIndex particle, double v, DerivativeAccumulator da)"""
        return _IMP_kernel.Model_add_to_derivative(self, k, particle, v, da)

    def get_particle(self, p):
        r"""get_particle(Model self, ParticleIndex p) -> Particle"""
        return _IMP_kernel.Model_get_particle(self, p)

    def get_has_particle(self, p):
        r"""get_has_particle(Model self, ParticleIndex p) -> bool"""
        return _IMP_kernel.Model_get_has_particle(self, p)

    def get_particle_indexes(self):
        r"""get_particle_indexes(Model self) -> IMP::ParticleIndexes"""
        return _IMP_kernel.Model_get_particle_indexes(self)

    def get_model_objects(self):
        r"""get_model_objects(Model self) -> IMP::ModelObjectsTemp"""
        return _IMP_kernel.Model_get_model_objects(self)

    def remove_particle(self, pi):
        r"""remove_particle(Model self, ParticleIndex pi)"""
        return _IMP_kernel.Model_remove_particle(self, pi)

    def add_data(self, mk, o):
        r"""add_data(Model self, ModelKey mk, Object o)"""
        return _IMP_kernel.Model_add_data(self, mk, o)

    def get_data(self, mk):
        r"""get_data(Model self, ModelKey mk) -> Object"""
        return _IMP_kernel.Model_get_data(self, mk)

    def remove_data(self, mk):
        r"""remove_data(Model self, ModelKey mk)"""
        return _IMP_kernel.Model_remove_data(self, mk)

    def get_has_data(self, mk):
        r"""get_has_data(Model self, ModelKey mk) -> bool"""
        return _IMP_kernel.Model_get_has_data(self, mk)

    def get_age(self):
        r"""get_age(Model self) -> unsigned int"""
        return _IMP_kernel.Model_get_age(self)

    def get_trigger_last_updated(self, tk):
        r"""get_trigger_last_updated(Model self, TriggerKey tk) -> unsigned int"""
        return _IMP_kernel.Model_get_trigger_last_updated(self, tk)

    def set_trigger_updated(self, tk):
        r"""set_trigger_updated(Model self, TriggerKey tk)"""
        return _IMP_kernel.Model_set_trigger_updated(self, tk)

    def get_dependencies_updated(self):
        r"""get_dependencies_updated(Model self) -> unsigned int"""
        return _IMP_kernel.Model_get_dependencies_updated(self)

    def get_version_info(self):
        r"""get_version_info(Model self) -> VersionInfo"""
        return _IMP_kernel.Model_get_version_info(self)

    def do_destroy(self):
        r"""do_destroy(Model self)"""
        return _IMP_kernel.Model_do_destroy(self)

    def __str__(self):
        r"""__str__(Model self) -> std::string"""
        return _IMP_kernel.Model___str__(self)

    def __repr__(self):
        r"""__repr__(Model self) -> std::string"""
        return _IMP_kernel.Model___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_Model(o)


    def get_ints_numpy(self, k):
        """Get the model's attribute array for IntKey k as a NumPy array.
           The array is indexed by ParticleIndex; particles that don't have
           this attribute will either be off the end of the array or will have
           the value INT_MAX.
           This is a NumPy view that shares memory with the Model. Thus,
           any changes to values in this list will be reflected in the Model.
           Also, if the Model attribute array moves in memory (e.g. if particles
           or attributes are added) this array will be invalidated, so it is
           unsafe to keep it around long term.
        """
        return _get_ints_numpy(self, k, self)

    def get_floats_numpy(self, k):
        """Get the model's attribute array for FloatKey k as a NumPy array.
           See Model::get_ints_numpy() for more details."""
        return _get_floats_numpy(self, k, self)

    def get_derivatives_numpy(self, k):
        """Get the model's attribute derivatives array for FloatKey k
           as a NumPy array. See Model::get_ints_numpy() for more details."""
        return _get_derivatives_numpy(self, k, self)

    def get_spheres_numpy(self):
        """Get the model's XYZR attribute arrays as NumPy arrays.
           The attribute arrays for Cartesian coordinates and radii are
           stored separately from those for other FloatKeys. This function
           returns a tuple of two NumPy arrays, the first of coordinates and
           the second of radii. See Model::get_ints_numpy() for more details."""
        return _get_spheres_numpy(self, self)

    def get_sphere_derivatives_numpy(self):
        """Get the model's XYZR attribute derivatives arrays as NumPy arrays.
           See Model::get_ints_numpy() for more details."""
        return _get_sphere_derivatives_numpy(self, self)


# Register Model in _IMP_kernel:
_IMP_kernel.Model_swigregister(Model)

class Decorator(_Value):
    r"""Proxy of C++ IMP::Decorator class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, p):
        r"""__init__(Decorator self, _ParticleAdaptor p) -> Decorator"""
        _IMP_kernel.Decorator_swiginit(self, _IMP_kernel.new_Decorator(p))

    def __ne__(self, o):
        r"""__ne__(Decorator self, Object o) -> bool"""
        return _IMP_kernel.Decorator___ne__(self, o)

    def __lt__(self, o):
        r"""__lt__(Decorator self, Object o) -> bool"""
        return _IMP_kernel.Decorator___lt__(self, o)

    def __gt__(self, o):
        r"""__gt__(Decorator self, Object o) -> bool"""
        return _IMP_kernel.Decorator___gt__(self, o)

    def __ge__(self, o):
        r"""__ge__(Decorator self, Object o) -> bool"""
        return _IMP_kernel.Decorator___ge__(self, o)

    def __le__(self, o):
        r"""__le__(Decorator self, Object o) -> bool"""
        return _IMP_kernel.Decorator___le__(self, o)

    def get_particle(self):
        r"""get_particle(Decorator self) -> Particle"""
        return _IMP_kernel.Decorator_get_particle(self)

    def get_particle_index(self):
        r"""get_particle_index(Decorator self) -> ParticleIndex"""
        return _IMP_kernel.Decorator_get_particle_index(self)

    def get_model(self):
        r"""get_model(Decorator self) -> Model"""
        return _IMP_kernel.Decorator_get_model(self)

    def get_is_valid(self):
        r"""get_is_valid(Decorator self) -> bool"""
        return _IMP_kernel.Decorator_get_is_valid(self)

    def __hash__(self):
        r"""__hash__(Decorator self) -> std::size_t"""
        return _IMP_kernel.Decorator___hash__(self)

    def __eq__(self, *args):
        r"""
        __eq__(Decorator self, Object o) -> bool
        __eq__(Decorator self, Decorator o) -> bool
        __eq__(Decorator self, Particle o) -> bool
        """
        return _IMP_kernel.Decorator___eq__(self, *args)

    def __bool__(self):
        r"""__bool__(Decorator self) -> bool"""
        return _IMP_kernel.Decorator___bool__(self)

    __nonzero__ = __bool__

    __swig_destroy__ = _IMP_kernel.delete_Decorator

# Register Decorator in _IMP_kernel:
_IMP_kernel.Decorator_swigregister(Decorator)


def check_particle(m, pi):
    r"""check_particle(Model m, ParticleIndex pi)"""
    return _IMP_kernel.check_particle(m, pi)
class UnaryFunction(Object):
    r"""Proxy of C++ IMP::UnaryFunction class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""__init__(UnaryFunction self, std::string name="UnaryFunction%1%") -> UnaryFunction"""
        if self.__class__ == UnaryFunction:
            _self = None
        else:
            _self = self
        _IMP_kernel.UnaryFunction_swiginit(self, _IMP_kernel.new_UnaryFunction(_self, *args))

        if self.__class__ != UnaryFunction:
            _director_objects.register(self)




    def evaluate(self, feature):
        r"""evaluate(UnaryFunction self, double feature) -> double"""
        return _IMP_kernel.UnaryFunction_evaluate(self, feature)

    def evaluate_with_derivative(self, feature):
        r"""evaluate_with_derivative(UnaryFunction self, double feature) -> IMP::DerivativePair"""
        return _IMP_kernel.UnaryFunction_evaluate_with_derivative(self, feature)
    __swig_destroy__ = _IMP_kernel.delete_UnaryFunction

    def __str__(self):
        r"""__str__(UnaryFunction self) -> std::string"""
        return _IMP_kernel.UnaryFunction___str__(self)

    def __repr__(self):
        r"""__repr__(UnaryFunction self) -> std::string"""
        return _IMP_kernel.UnaryFunction___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_UnaryFunction(o)


    def get_type_name(self):
        return self.__class__.__name__
    def do_show(self, out):
        pass
    def get_version_info(self):
        if"IMP" == "IMP":
          return VersionInfo(self.__module__,
                             __import__(self.__module__).get_module_version())
        else:
          return IMP.VersionInfo(self.__module__,
                             __import__(self.__module__).get_module_version())
    @staticmethod
    def get_from(o):
       return _object_cast_to_UnaryFunction(o)

    def __disown__(self):
        self.this.disown()
        _IMP_kernel.disown_UnaryFunction(self)
        return weakref.proxy(self)

    def do_destroy(self):
        r"""do_destroy(UnaryFunction self)"""
        return _IMP_kernel.UnaryFunction_do_destroy(self)

# Register UnaryFunction in _IMP_kernel:
_IMP_kernel.UnaryFunction_swigregister(UnaryFunction)

class OptimizerState(ModelObject):
    r"""Proxy of C++ IMP::OptimizerState class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, m, name):
        r"""__init__(OptimizerState self, Model m, std::string name) -> OptimizerState"""
        if self.__class__ == OptimizerState:
            _self = None
        else:
            _self = self
        _IMP_kernel.OptimizerState_swiginit(self, _IMP_kernel.new_OptimizerState(_self, m, name))

        if self.__class__ != OptimizerState:
            _director_objects.register(self)




    def update(self):
        r"""update(OptimizerState self)"""
        return _IMP_kernel.OptimizerState_update(self)

    def set_is_optimizing(self, arg0):
        r"""set_is_optimizing(OptimizerState self, bool arg0)"""
        return _IMP_kernel.OptimizerState_set_is_optimizing(self, arg0)

    def get_optimizer(self):
        r"""get_optimizer(OptimizerState self) -> Optimizer"""
        return _IMP_kernel.OptimizerState_get_optimizer(self)

    def set_period(self, p):
        r"""set_period(OptimizerState self, unsigned int p)"""
        return _IMP_kernel.OptimizerState_set_period(self, p)

    def get_period(self):
        r"""get_period(OptimizerState self) -> unsigned int"""
        return _IMP_kernel.OptimizerState_get_period(self)

    def reset(self):
        r"""reset(OptimizerState self)"""
        return _IMP_kernel.OptimizerState_reset(self)

    def update_always(self):
        r"""update_always(OptimizerState self)"""
        return _IMP_kernel.OptimizerState_update_always(self)

    def get_number_of_updates(self):
        r"""get_number_of_updates(OptimizerState self) -> unsigned int"""
        return _IMP_kernel.OptimizerState_get_number_of_updates(self)

    def set_number_of_updates(self, n):
        r"""set_number_of_updates(OptimizerState self, unsigned int n)"""
        return _IMP_kernel.OptimizerState_set_number_of_updates(self, n)
    __swig_destroy__ = _IMP_kernel.delete_OptimizerState

    def do_update(self, arg0):
        r"""do_update(OptimizerState self, unsigned int arg0)"""
        return _IMP_kernel.OptimizerState_do_update(self, arg0)

    def do_set_is_optimizing(self, arg0):
        r"""do_set_is_optimizing(OptimizerState self, bool arg0)"""
        return _IMP_kernel.OptimizerState_do_set_is_optimizing(self, arg0)

    def do_get_inputs(self):
        r"""do_get_inputs(OptimizerState self) -> IMP::ModelObjectsTemp"""
        return _IMP_kernel.OptimizerState_do_get_inputs(self)

    def do_get_outputs(self):
        r"""do_get_outputs(OptimizerState self) -> IMP::ModelObjectsTemp"""
        return _IMP_kernel.OptimizerState_do_get_outputs(self)

    def __str__(self):
        r"""__str__(OptimizerState self) -> std::string"""
        return _IMP_kernel.OptimizerState___str__(self)

    def __repr__(self):
        r"""__repr__(OptimizerState self) -> std::string"""
        return _IMP_kernel.OptimizerState___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_OptimizerState(o)


    def get_type_name(self):
        return self.__class__.__name__
    def do_show(self, out):
        pass
    def get_version_info(self):
        if"IMP" == "IMP":
          return VersionInfo(self.__module__,
                             __import__(self.__module__).get_module_version())
        else:
          return IMP.VersionInfo(self.__module__,
                             __import__(self.__module__).get_module_version())
    @staticmethod
    def get_from(o):
       return _object_cast_to_OptimizerState(o)

    def __disown__(self):
        self.this.disown()
        _IMP_kernel.disown_OptimizerState(self)
        return weakref.proxy(self)

    def do_destroy(self):
        r"""do_destroy(OptimizerState self)"""
        return _IMP_kernel.OptimizerState_do_destroy(self)

    def handle_set_has_required_score_states(self, arg0):
        r"""handle_set_has_required_score_states(OptimizerState self, bool arg0)"""
        return _IMP_kernel.OptimizerState_handle_set_has_required_score_states(self, arg0)

    def do_get_interactions(self):
        r"""do_get_interactions(OptimizerState self) -> IMP::ModelObjectsTemps"""
        return _IMP_kernel.OptimizerState_do_get_interactions(self)

# Register OptimizerState in _IMP_kernel:
_IMP_kernel.OptimizerState_swigregister(OptimizerState)

class Refiner(_ParticleInputs, Object):
    r"""Proxy of C++ IMP::Refiner class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""__init__(Refiner self, std::string name="Refiner %1%", bool is_by_ref=False) -> Refiner"""
        if self.__class__ == Refiner:
            _self = None
        else:
            _self = self
        _IMP_kernel.Refiner_swiginit(self, _IMP_kernel.new_Refiner(_self, *args))

        if self.__class__ != Refiner:
            _director_objects.register(self)




    def get_can_refine(self, arg0):
        r"""get_can_refine(Refiner self, Particle arg0) -> bool"""
        return _IMP_kernel.Refiner_get_can_refine(self, arg0)

    def get_refined_indexes(self, m, pi):
        r"""get_refined_indexes(Refiner self, Model m, ParticleIndex pi) -> IMP::ParticleIndexes"""
        return _IMP_kernel.Refiner_get_refined_indexes(self, m, pi)

    def get_refined_indexes_by_ref(self, m, pi):
        r"""get_refined_indexes_by_ref(Refiner self, Model m, ParticleIndex pi) -> IMP::ParticleIndexes const &"""
        return _IMP_kernel.Refiner_get_refined_indexes_by_ref(self, m, pi)

    def get_is_by_ref_supported(self):
        r"""get_is_by_ref_supported(Refiner self) -> bool"""
        return _IMP_kernel.Refiner_get_is_by_ref_supported(self)

    def get_refined(self, *args):
        r"""
        get_refined(Refiner self, Particle a) -> IMP::ParticlesTemp const
        get_refined(Refiner self, Particle a, unsigned int i) -> Particle
        """
        return _IMP_kernel.Refiner_get_refined(self, *args)

    def get_number_of_refined(self, a):
        r"""get_number_of_refined(Refiner self, Particle a) -> unsigned int"""
        return _IMP_kernel.Refiner_get_number_of_refined(self, a)

    def __str__(self):
        r"""__str__(Refiner self) -> std::string"""
        return _IMP_kernel.Refiner___str__(self)

    def __repr__(self):
        r"""__repr__(Refiner self) -> std::string"""
        return _IMP_kernel.Refiner___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_Refiner(o)


    def get_type_name(self):
        return self.__class__.__name__
    def do_show(self, out):
        pass
    def get_version_info(self):
        if"IMP" == "IMP":
          return VersionInfo(self.__module__,
                             __import__(self.__module__).get_module_version())
        else:
          return IMP.VersionInfo(self.__module__,
                             __import__(self.__module__).get_module_version())
    @staticmethod
    def get_from(o):
       return _object_cast_to_Refiner(o)

    __swig_destroy__ = _IMP_kernel.delete_Refiner
    def __disown__(self):
        self.this.disown()
        _IMP_kernel.disown_Refiner(self)
        return weakref.proxy(self)

    def do_get_inputs(self, m, pis):
        r"""do_get_inputs(Refiner self, Model m, IMP::ParticleIndexes const & pis) -> IMP::ModelObjectsTemp"""
        return _IMP_kernel.Refiner_do_get_inputs(self, m, pis)

    def do_destroy(self):
        r"""do_destroy(Refiner self)"""
        return _IMP_kernel.Refiner_do_destroy(self)

# Register Refiner in _IMP_kernel:
_IMP_kernel.Refiner_swigregister(Refiner)

class Optimizer(ModelObject):
    r"""Proxy of C++ IMP::Optimizer class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def set_is_optimizing_states(self, tf):
        r"""set_is_optimizing_states(Optimizer self, bool tf)"""
        return _IMP_kernel.Optimizer_set_is_optimizing_states(self, tf)

    def get_optimizer_state_inputs(self):
        r"""get_optimizer_state_inputs(Optimizer self) -> IMP::ModelObjectsTemp"""
        return _IMP_kernel.Optimizer_get_optimizer_state_inputs(self)

    def do_get_inputs(self):
        r"""do_get_inputs(Optimizer self) -> IMP::ModelObjectsTemp"""
        return _IMP_kernel.Optimizer_do_get_inputs(self)

    def do_get_outputs(self):
        r"""do_get_outputs(Optimizer self) -> IMP::ModelObjectsTemp"""
        return _IMP_kernel.Optimizer_do_get_outputs(self)

    def __init__(self, *args):
        r"""__init__(Optimizer self, Model m, std::string name="Optimizer %1%") -> Optimizer"""
        if self.__class__ == Optimizer:
            _self = None
        else:
            _self = self
        _IMP_kernel.Optimizer_swiginit(self, _IMP_kernel.new_Optimizer(_self, *args))

        if self.__class__ != Optimizer:
            _director_objects.register(self)




    def optimize(self, max_steps):
        r"""optimize(Optimizer self, unsigned int max_steps) -> double"""
        return _IMP_kernel.Optimizer_optimize(self, max_steps)

    def set_stop_on_good_score(self, tf):
        r"""set_stop_on_good_score(Optimizer self, bool tf)"""
        return _IMP_kernel.Optimizer_set_stop_on_good_score(self, tf)

    def get_stop_on_good_score(self):
        r"""get_stop_on_good_score(Optimizer self) -> bool"""
        return _IMP_kernel.Optimizer_get_stop_on_good_score(self)

    def get_last_score(self):
        r"""get_last_score(Optimizer self) -> double"""
        return _IMP_kernel.Optimizer_get_last_score(self)

    def get_scoring_function(self):
        r"""get_scoring_function(Optimizer self) -> ScoringFunction"""
        return _IMP_kernel.Optimizer_get_scoring_function(self)

    def remove_optimizer_state(self, d):
        r"""remove_optimizer_state(Optimizer self, OptimizerState d)"""
        return _IMP_kernel.Optimizer_remove_optimizer_state(self, d)

    def remove_optimizer_states(self, d):
        r"""remove_optimizer_states(Optimizer self, IMP::OptimizerStates const & d)"""
        return _IMP_kernel.Optimizer_remove_optimizer_states(self, d)

    def set_optimizer_states(self, ps):
        r"""set_optimizer_states(Optimizer self, IMP::OptimizerStates const & ps)"""
        return _IMP_kernel.Optimizer_set_optimizer_states(self, ps)

    def set_optimizer_states_order(self, objs):
        r"""set_optimizer_states_order(Optimizer self, IMP::OptimizerStates const & objs)"""
        return _IMP_kernel.Optimizer_set_optimizer_states_order(self, objs)

    def add_optimizer_state(self, obj):
        r"""add_optimizer_state(Optimizer self, OptimizerState obj) -> unsigned int"""
        return _IMP_kernel.Optimizer_add_optimizer_state(self, obj)

    def add_optimizer_states(self, objs):
        r"""add_optimizer_states(Optimizer self, IMP::OptimizerStates const & objs)"""
        return _IMP_kernel.Optimizer_add_optimizer_states(self, objs)

    def clear_optimizer_states(self):
        r"""clear_optimizer_states(Optimizer self)"""
        return _IMP_kernel.Optimizer_clear_optimizer_states(self)

    def get_number_of_optimizer_states(self):
        r"""get_number_of_optimizer_states(Optimizer self) -> unsigned int"""
        return _IMP_kernel.Optimizer_get_number_of_optimizer_states(self)

    def get_has_optimizer_states(self):
        r"""get_has_optimizer_states(Optimizer self) -> bool"""
        return _IMP_kernel.Optimizer_get_has_optimizer_states(self)

    def get_optimizer_state(self, i):
        r"""get_optimizer_state(Optimizer self, unsigned int i) -> OptimizerState"""
        return _IMP_kernel.Optimizer_get_optimizer_state(self, i)

    def get_optimizer_states(self):
        r"""get_optimizer_states(Optimizer self) -> IMP::OptimizerStates"""
        return _IMP_kernel.Optimizer_get_optimizer_states(self)

    def reserve_optimizer_states(self, sz):
        r"""reserve_optimizer_states(Optimizer self, unsigned int sz)"""
        return _IMP_kernel.Optimizer_reserve_optimizer_states(self, sz)

    def set_scoring_function(self, sf):
        r"""set_scoring_function(Optimizer self, _ScoringFunctionAdaptor sf)"""
        return _IMP_kernel.Optimizer_set_scoring_function(self, sf)
    __swig_destroy__ = _IMP_kernel.delete_Optimizer
    def __del__(self):
        r"""__del__(Optimizer self)"""

        _director_objects.cleanup()


        pass


    def do_optimize(self, ns):
        r"""do_optimize(Optimizer self, unsigned int ns) -> double"""
        return _IMP_kernel.Optimizer_do_optimize(self, ns)

    def update_states(self):
        r"""update_states(Optimizer self)"""
        return _IMP_kernel.Optimizer_update_states(self)

    def __str__(self):
        r"""__str__(Optimizer self) -> std::string"""
        return _IMP_kernel.Optimizer___str__(self)

    def __repr__(self):
        r"""__repr__(Optimizer self) -> std::string"""
        return _IMP_kernel.Optimizer___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_Optimizer(o)


    def get_type_name(self):
        return self.__class__.__name__
    def do_show(self, out):
        pass
    def get_version_info(self):
        if"IMP" == "IMP":
          return VersionInfo(self.__module__,
                             __import__(self.__module__).get_module_version())
        else:
          return IMP.VersionInfo(self.__module__,
                             __import__(self.__module__).get_module_version())
    @staticmethod
    def get_from(o):
       return _object_cast_to_Optimizer(o)

    def __disown__(self):
        self.this.disown()
        _IMP_kernel.disown_Optimizer(self)
        return weakref.proxy(self)

    def do_destroy(self):
        r"""do_destroy(Optimizer self)"""
        return _IMP_kernel.Optimizer_do_destroy(self)

    def handle_set_has_required_score_states(self, arg0):
        r"""handle_set_has_required_score_states(Optimizer self, bool arg0)"""
        return _IMP_kernel.Optimizer_handle_set_has_required_score_states(self, arg0)

    def do_get_interactions(self):
        r"""do_get_interactions(Optimizer self) -> IMP::ModelObjectsTemps"""
        return _IMP_kernel.Optimizer_do_get_interactions(self)

# Register Optimizer in _IMP_kernel:
_IMP_kernel.Optimizer_swigregister(Optimizer)

class AttributeOptimizer(Optimizer):
    r"""Proxy of C++ IMP::AttributeOptimizer class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""__init__(AttributeOptimizer self, Model m, std::string name="Optimizer %1%") -> AttributeOptimizer"""
        if self.__class__ == AttributeOptimizer:
            _self = None
        else:
            _self = self
        _IMP_kernel.AttributeOptimizer_swiginit(self, _IMP_kernel.new_AttributeOptimizer(_self, *args))

        if self.__class__ != AttributeOptimizer:
            _director_objects.register(self)




    def get_optimized_attributes(self):
        r"""get_optimized_attributes(AttributeOptimizer self) -> IMP::FloatIndexes"""
        return _IMP_kernel.AttributeOptimizer_get_optimized_attributes(self)

    def set_value(self, fi, v):
        r"""set_value(AttributeOptimizer self, FloatIndex fi, double v)"""
        return _IMP_kernel.AttributeOptimizer_set_value(self, fi, v)

    def get_value(self, fi):
        r"""get_value(AttributeOptimizer self, FloatIndex fi) -> IMP::Float"""
        return _IMP_kernel.AttributeOptimizer_get_value(self, fi)

    def get_derivative(self, fi):
        r"""get_derivative(AttributeOptimizer self, FloatIndex fi) -> IMP::Float"""
        return _IMP_kernel.AttributeOptimizer_get_derivative(self, fi)

    def get_width(self, k):
        r"""get_width(AttributeOptimizer self, FloatKey k) -> double"""
        return _IMP_kernel.AttributeOptimizer_get_width(self, k)

    def set_scaled_value(self, fi, v):
        r"""set_scaled_value(AttributeOptimizer self, FloatIndex fi, IMP::Float v)"""
        return _IMP_kernel.AttributeOptimizer_set_scaled_value(self, fi, v)

    def get_scaled_value(self, fi):
        r"""get_scaled_value(AttributeOptimizer self, FloatIndex fi) -> double"""
        return _IMP_kernel.AttributeOptimizer_get_scaled_value(self, fi)

    def get_scaled_derivative(self, fi):
        r"""get_scaled_derivative(AttributeOptimizer self, FloatIndex fi) -> double"""
        return _IMP_kernel.AttributeOptimizer_get_scaled_derivative(self, fi)

    def clear_range_cache(self):
        r"""clear_range_cache(AttributeOptimizer self)"""
        return _IMP_kernel.AttributeOptimizer_clear_range_cache(self)

    def __str__(self):
        r"""__str__(AttributeOptimizer self) -> std::string"""
        return _IMP_kernel.AttributeOptimizer___str__(self)

    def __repr__(self):
        r"""__repr__(AttributeOptimizer self) -> std::string"""
        return _IMP_kernel.AttributeOptimizer___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_AttributeOptimizer(o)


    def get_type_name(self):
        return self.__class__.__name__
    def do_show(self, out):
        pass
    def get_version_info(self):
        if"IMP" == "IMP":
          return VersionInfo(self.__module__,
                             __import__(self.__module__).get_module_version())
        else:
          return IMP.VersionInfo(self.__module__,
                             __import__(self.__module__).get_module_version())
    @staticmethod
    def get_from(o):
       return _object_cast_to_AttributeOptimizer(o)

    __swig_destroy__ = _IMP_kernel.delete_AttributeOptimizer
    def __disown__(self):
        self.this.disown()
        _IMP_kernel.disown_AttributeOptimizer(self)
        return weakref.proxy(self)

    def do_destroy(self):
        r"""do_destroy(AttributeOptimizer self)"""
        return _IMP_kernel.AttributeOptimizer_do_destroy(self)

    def handle_set_has_required_score_states(self, arg0):
        r"""handle_set_has_required_score_states(AttributeOptimizer self, bool arg0)"""
        return _IMP_kernel.AttributeOptimizer_handle_set_has_required_score_states(self, arg0)

    def do_get_inputs(self):
        r"""do_get_inputs(AttributeOptimizer self) -> IMP::ModelObjectsTemp"""
        return _IMP_kernel.AttributeOptimizer_do_get_inputs(self)

    def do_get_outputs(self):
        r"""do_get_outputs(AttributeOptimizer self) -> IMP::ModelObjectsTemp"""
        return _IMP_kernel.AttributeOptimizer_do_get_outputs(self)

    def do_get_interactions(self):
        r"""do_get_interactions(AttributeOptimizer self) -> IMP::ModelObjectsTemps"""
        return _IMP_kernel.AttributeOptimizer_do_get_interactions(self)

    def do_optimize(self, ns):
        r"""do_optimize(AttributeOptimizer self, unsigned int ns) -> double"""
        return _IMP_kernel.AttributeOptimizer_do_optimize(self, ns)

# Register AttributeOptimizer in _IMP_kernel:
_IMP_kernel.AttributeOptimizer_swigregister(AttributeOptimizer)

class ConfigurationSet(Object):
    r"""Proxy of C++ IMP::ConfigurationSet class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""__init__(ConfigurationSet self, Model m, std::string name="ConfigurationSet %1%") -> ConfigurationSet"""
        _IMP_kernel.ConfigurationSet_swiginit(self, _IMP_kernel.new_ConfigurationSet(*args))

    def save_configuration(self):
        r"""save_configuration(ConfigurationSet self)"""
        return _IMP_kernel.ConfigurationSet_save_configuration(self)

    def get_number_of_configurations(self):
        r"""get_number_of_configurations(ConfigurationSet self) -> unsigned int"""
        return _IMP_kernel.ConfigurationSet_get_number_of_configurations(self)

    def load_configuration(self, i):
        r"""load_configuration(ConfigurationSet self, int i)"""
        return _IMP_kernel.ConfigurationSet_load_configuration(self, i)

    def remove_configuration(self, i):
        r"""remove_configuration(ConfigurationSet self, unsigned int i)"""
        return _IMP_kernel.ConfigurationSet_remove_configuration(self, i)

    def get_model(self):
        r"""get_model(ConfigurationSet self) -> Model"""
        return _IMP_kernel.ConfigurationSet_get_model(self)

    def get_version_info(self):
        r"""get_version_info(ConfigurationSet self) -> VersionInfo"""
        return _IMP_kernel.ConfigurationSet_get_version_info(self)

    def __str__(self):
        r"""__str__(ConfigurationSet self) -> std::string"""
        return _IMP_kernel.ConfigurationSet___str__(self)

    def __repr__(self):
        r"""__repr__(ConfigurationSet self) -> std::string"""
        return _IMP_kernel.ConfigurationSet___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_ConfigurationSet(o)


# Register ConfigurationSet in _IMP_kernel:
_IMP_kernel.ConfigurationSet_swigregister(ConfigurationSet)

class SaveToConfigurationSetOptimizerState(OptimizerState):
    r"""Proxy of C++ IMP::SaveToConfigurationSetOptimizerState class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, cs):
        r"""__init__(SaveToConfigurationSetOptimizerState self, ConfigurationSet cs) -> SaveToConfigurationSetOptimizerState"""
        _IMP_kernel.SaveToConfigurationSetOptimizerState_swiginit(self, _IMP_kernel.new_SaveToConfigurationSetOptimizerState(cs))

    def get_version_info(self):
        r"""get_version_info(SaveToConfigurationSetOptimizerState self) -> VersionInfo"""
        return _IMP_kernel.SaveToConfigurationSetOptimizerState_get_version_info(self)

    def __str__(self):
        r"""__str__(SaveToConfigurationSetOptimizerState self) -> std::string"""
        return _IMP_kernel.SaveToConfigurationSetOptimizerState___str__(self)

    def __repr__(self):
        r"""__repr__(SaveToConfigurationSetOptimizerState self) -> std::string"""
        return _IMP_kernel.SaveToConfigurationSetOptimizerState___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_SaveToConfigurationSetOptimizerState(o)


# Register SaveToConfigurationSetOptimizerState in _IMP_kernel:
_IMP_kernel.SaveToConfigurationSetOptimizerState_swigregister(SaveToConfigurationSetOptimizerState)

class Configuration(Object):
    r"""Proxy of C++ IMP::Configuration class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(Configuration self, Model m, std::string name="Configuration %1%") -> Configuration
        __init__(Configuration self, Model m, Configuration base, std::string name="Configuration %1%") -> Configuration
        """
        _IMP_kernel.Configuration_swiginit(self, _IMP_kernel.new_Configuration(*args))

    def load_configuration(self):
        r"""load_configuration(Configuration self)"""
        return _IMP_kernel.Configuration_load_configuration(self)

    def swap_configuration(self):
        r"""swap_configuration(Configuration self)"""
        return _IMP_kernel.Configuration_swap_configuration(self)

    def get_version_info(self):
        r"""get_version_info(Configuration self) -> VersionInfo"""
        return _IMP_kernel.Configuration_get_version_info(self)

    def __str__(self):
        r"""__str__(Configuration self) -> std::string"""
        return _IMP_kernel.Configuration___str__(self)

    def __repr__(self):
        r"""__repr__(Configuration self) -> std::string"""
        return _IMP_kernel.Configuration___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_Configuration(o)


# Register Configuration in _IMP_kernel:
_IMP_kernel.Configuration_swigregister(Configuration)

class Sampler(Object):
    r"""Proxy of C++ IMP::Sampler class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""__init__(Sampler self, Model m, std::string name="Sampler %1%") -> Sampler"""
        if self.__class__ == Sampler:
            _self = None
        else:
            _self = self
        _IMP_kernel.Sampler_swiginit(self, _IMP_kernel.new_Sampler(_self, *args))

        if self.__class__ != Sampler:
            _director_objects.register(self)




    def create_sample(self):
        r"""create_sample(Sampler self) -> ConfigurationSet"""
        return _IMP_kernel.Sampler_create_sample(self)

    def get_scoring_function(self):
        r"""get_scoring_function(Sampler self) -> ScoringFunction"""
        return _IMP_kernel.Sampler_get_scoring_function(self)

    def set_scoring_function(self, sf):
        r"""set_scoring_function(Sampler self, _ScoringFunctionAdaptor sf)"""
        return _IMP_kernel.Sampler_set_scoring_function(self, sf)

    def get_model(self):
        r"""get_model(Sampler self) -> Model"""
        return _IMP_kernel.Sampler_get_model(self)

    def do_sample(self):
        r"""do_sample(Sampler self) -> ConfigurationSet"""
        return _IMP_kernel.Sampler_do_sample(self)
    __swig_destroy__ = _IMP_kernel.delete_Sampler

    def __str__(self):
        r"""__str__(Sampler self) -> std::string"""
        return _IMP_kernel.Sampler___str__(self)

    def __repr__(self):
        r"""__repr__(Sampler self) -> std::string"""
        return _IMP_kernel.Sampler___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_Sampler(o)


    def get_type_name(self):
        return self.__class__.__name__
    def do_show(self, out):
        pass
    def get_version_info(self):
        if"IMP" == "IMP":
          return VersionInfo(self.__module__,
                             __import__(self.__module__).get_module_version())
        else:
          return IMP.VersionInfo(self.__module__,
                             __import__(self.__module__).get_module_version())
    @staticmethod
    def get_from(o):
       return _object_cast_to_Sampler(o)

    def __disown__(self):
        self.this.disown()
        _IMP_kernel.disown_Sampler(self)
        return weakref.proxy(self)

    def do_destroy(self):
        r"""do_destroy(Sampler self)"""
        return _IMP_kernel.Sampler_do_destroy(self)

# Register Sampler in _IMP_kernel:
_IMP_kernel.Sampler_swigregister(Sampler)

class PairModifier(_ParticleInputs, _ParticleOutputs, Object):
    r"""Proxy of C++ IMP::PairModifier class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""__init__(PairModifier self, std::string name="PairModifier %1%") -> PairModifier"""
        if self.__class__ == PairModifier:
            _self = None
        else:
            _self = self
        _IMP_kernel.PairModifier_swiginit(self, _IMP_kernel.new_PairModifier(_self, *args))

        if self.__class__ != PairModifier:
            _director_objects.register(self)




    def apply_index(self, m, v):
        r"""apply_index(PairModifier self, Model m, IMP::ParticleIndexPair const & v)"""
        return _IMP_kernel.PairModifier_apply_index(self, m, v)

    def apply_indexes(self, m, o, lower_bound, upper_bound):
        r"""apply_indexes(PairModifier self, Model m, IMP::ParticleIndexPairs const & o, unsigned int lower_bound, unsigned int upper_bound)"""
        return _IMP_kernel.PairModifier_apply_indexes(self, m, o, lower_bound, upper_bound)

    def apply_indexes_moved(self, m, o, lower_bound, upper_bound, moved_pis, reset_pis):
        r"""apply_indexes_moved(PairModifier self, Model m, IMP::ParticleIndexPairs const & o, unsigned int lower_bound, unsigned int upper_bound, IMP::ParticleIndexes const & moved_pis, IMP::ParticleIndexes const & reset_pis)"""
        return _IMP_kernel.PairModifier_apply_indexes_moved(self, m, o, lower_bound, upper_bound, moved_pis, reset_pis)

    def __str__(self):
        r"""__str__(PairModifier self) -> std::string"""
        return _IMP_kernel.PairModifier___str__(self)

    def __repr__(self):
        r"""__repr__(PairModifier self) -> std::string"""
        return _IMP_kernel.PairModifier___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_PairModifier(o)


    def get_type_name(self):
        return self.__class__.__name__
    def do_show(self, out):
        pass
    def get_version_info(self):
        if"IMP" == "IMP":
          return VersionInfo(self.__module__,
                             __import__(self.__module__).get_module_version())
        else:
          return IMP.VersionInfo(self.__module__,
                             __import__(self.__module__).get_module_version())
    @staticmethod
    def get_from(o):
       return _object_cast_to_PairModifier(o)

    __swig_destroy__ = _IMP_kernel.delete_PairModifier
    def __disown__(self):
        self.this.disown()
        _IMP_kernel.disown_PairModifier(self)
        return weakref.proxy(self)

    def do_get_inputs(self, m, pis):
        r"""do_get_inputs(PairModifier self, Model m, IMP::ParticleIndexes const & pis) -> IMP::ModelObjectsTemp"""
        return _IMP_kernel.PairModifier_do_get_inputs(self, m, pis)

    def do_get_outputs(self, m, pis):
        r"""do_get_outputs(PairModifier self, Model m, IMP::ParticleIndexes const & pis) -> IMP::ModelObjectsTemp"""
        return _IMP_kernel.PairModifier_do_get_outputs(self, m, pis)

    def do_destroy(self):
        r"""do_destroy(PairModifier self)"""
        return _IMP_kernel.PairModifier_do_destroy(self)

# Register PairModifier in _IMP_kernel:
_IMP_kernel.PairModifier_swigregister(PairModifier)

class PairScore(_ParticleInputs, Object):
    r"""Proxy of C++ IMP::PairScore class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""__init__(PairScore self, std::string name="PairScore %1%") -> PairScore"""
        if self.__class__ == PairScore:
            _self = None
        else:
            _self = self
        _IMP_kernel.PairScore_swiginit(self, _IMP_kernel.new_PairScore(_self, *args))

        if self.__class__ != PairScore:
            _director_objects.register(self)




    def evaluate_index(self, m, vt, da):
        r"""evaluate_index(PairScore self, Model m, IMP::ParticleIndexPair const & vt, DerivativeAccumulator da) -> double"""
        return _IMP_kernel.PairScore_evaluate_index(self, m, vt, da)

    def evaluate_indexes(self, m, o, da, lower_bound, upper_bound):
        r"""evaluate_indexes(PairScore self, Model m, IMP::ParticleIndexPairs const & o, DerivativeAccumulator da, unsigned int lower_bound, unsigned int upper_bound) -> double"""
        return _IMP_kernel.PairScore_evaluate_indexes(self, m, o, da, lower_bound, upper_bound)

    def evaluate_indexes_scores(self, m, o, da, lower_bound, upper_bound, score):
        r"""evaluate_indexes_scores(PairScore self, Model m, IMP::ParticleIndexPairs const & o, DerivativeAccumulator da, unsigned int lower_bound, unsigned int upper_bound, std::vector< double,std::allocator< double > > & score) -> double"""
        return _IMP_kernel.PairScore_evaluate_indexes_scores(self, m, o, da, lower_bound, upper_bound, score)

    def evaluate_indexes_delta(self, m, o, da, indexes, score):
        r"""evaluate_indexes_delta(PairScore self, Model m, IMP::ParticleIndexPairs const & o, DerivativeAccumulator da, std::vector< unsigned int,std::allocator< unsigned int > > const & indexes, std::vector< double,std::allocator< double > > & score) -> double"""
        return _IMP_kernel.PairScore_evaluate_indexes_delta(self, m, o, da, indexes, score)

    def evaluate_if_good_index(self, m, vt, da, max):
        r"""evaluate_if_good_index(PairScore self, Model m, IMP::ParticleIndexPair const & vt, DerivativeAccumulator da, double max) -> double"""
        return _IMP_kernel.PairScore_evaluate_if_good_index(self, m, vt, da, max)

    def evaluate_if_good_indexes(self, m, o, da, max, lower_bound, upper_bound):
        r"""evaluate_if_good_indexes(PairScore self, Model m, IMP::ParticleIndexPairs const & o, DerivativeAccumulator da, double max, unsigned int lower_bound, unsigned int upper_bound) -> double"""
        return _IMP_kernel.PairScore_evaluate_if_good_indexes(self, m, o, da, max, lower_bound, upper_bound)

    def create_current_decomposition(self, m, vt):
        r"""create_current_decomposition(PairScore self, Model m, IMP::ParticleIndexPair const & vt) -> IMP::Restraints"""
        return _IMP_kernel.PairScore_create_current_decomposition(self, m, vt)

    def do_create_current_decomposition(self, m, vt):
        r"""do_create_current_decomposition(PairScore self, Model m, IMP::ParticleIndexPair const & vt) -> IMP::Restraints"""
        return _IMP_kernel.PairScore_do_create_current_decomposition(self, m, vt)
    __swig_destroy__ = _IMP_kernel.delete_PairScore

    def __str__(self):
        r"""__str__(PairScore self) -> std::string"""
        return _IMP_kernel.PairScore___str__(self)

    def __repr__(self):
        r"""__repr__(PairScore self) -> std::string"""
        return _IMP_kernel.PairScore___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_PairScore(o)


    def get_type_name(self):
        return self.__class__.__name__
    def do_show(self, out):
        pass
    def get_version_info(self):
        if"IMP" == "IMP":
          return VersionInfo(self.__module__,
                             __import__(self.__module__).get_module_version())
        else:
          return IMP.VersionInfo(self.__module__,
                             __import__(self.__module__).get_module_version())
    @staticmethod
    def get_from(o):
       return _object_cast_to_PairScore(o)

    def __disown__(self):
        self.this.disown()
        _IMP_kernel.disown_PairScore(self)
        return weakref.proxy(self)

    def do_get_inputs(self, m, pis):
        r"""do_get_inputs(PairScore self, Model m, IMP::ParticleIndexes const & pis) -> IMP::ModelObjectsTemp"""
        return _IMP_kernel.PairScore_do_get_inputs(self, m, pis)

    def do_destroy(self):
        r"""do_destroy(PairScore self)"""
        return _IMP_kernel.PairScore_do_destroy(self)

# Register PairScore in _IMP_kernel:
_IMP_kernel.PairScore_swigregister(PairScore)

class PairPredicate(_ParticleInputs, Object):
    r"""Proxy of C++ IMP::PairPredicate class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""__init__(PairPredicate self, std::string name="PairPredicate %1%") -> PairPredicate"""
        if self.__class__ == PairPredicate:
            _self = None
        else:
            _self = self
        _IMP_kernel.PairPredicate_swiginit(self, _IMP_kernel.new_PairPredicate(_self, *args))

        if self.__class__ != PairPredicate:
            _director_objects.register(self)




    def setup_for_get_value_index_in_batch(self, arg0):
        r"""setup_for_get_value_index_in_batch(PairPredicate self, Model arg0)"""
        return _IMP_kernel.PairPredicate_setup_for_get_value_index_in_batch(self, arg0)

    def get_value_index_in_batch(self, m, vt):
        r"""get_value_index_in_batch(PairPredicate self, Model m, IMP::ParticleIndexPair const & vt) -> int"""
        return _IMP_kernel.PairPredicate_get_value_index_in_batch(self, m, vt)

    def __call__(self, m, vt):
        r"""__call__(PairPredicate self, Model m, IMP::ParticleIndexPair const & vt) -> int"""
        return _IMP_kernel.PairPredicate___call__(self, m, vt)

    def get_value_index(self, *args):
        r"""
        get_value_index(PairPredicate self, Model m, IMP::ParticleIndexPair const & vt) -> int
        get_value_index(PairPredicate self, Model m, IMP::ParticleIndexPairs const & o) -> IMP::Ints
        """
        return _IMP_kernel.PairPredicate_get_value_index(self, *args)
    __swig_destroy__ = _IMP_kernel.delete_PairPredicate

    def __str__(self):
        r"""__str__(PairPredicate self) -> std::string"""
        return _IMP_kernel.PairPredicate___str__(self)

    def __repr__(self):
        r"""__repr__(PairPredicate self) -> std::string"""
        return _IMP_kernel.PairPredicate___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_PairPredicate(o)


    def get_type_name(self):
        return self.__class__.__name__
    def do_show(self, out):
        pass
    def get_version_info(self):
        if"IMP" == "IMP":
          return VersionInfo(self.__module__,
                             __import__(self.__module__).get_module_version())
        else:
          return IMP.VersionInfo(self.__module__,
                             __import__(self.__module__).get_module_version())
    @staticmethod
    def get_from(o):
       return _object_cast_to_PairPredicate(o)

    def __disown__(self):
        self.this.disown()
        _IMP_kernel.disown_PairPredicate(self)
        return weakref.proxy(self)

    def do_get_inputs(self, m, pis):
        r"""do_get_inputs(PairPredicate self, Model m, IMP::ParticleIndexes const & pis) -> IMP::ModelObjectsTemp"""
        return _IMP_kernel.PairPredicate_do_get_inputs(self, m, pis)

    def do_destroy(self):
        r"""do_destroy(PairPredicate self)"""
        return _IMP_kernel.PairPredicate_do_destroy(self)

# Register PairPredicate in _IMP_kernel:
_IMP_kernel.PairPredicate_swigregister(PairPredicate)

class PairContainer(Container):
    r"""Proxy of C++ IMP::PairContainer class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def apply_generic(self, m):
        r"""apply_generic(PairContainer self, PairModifier m)"""
        return _IMP_kernel.PairContainer_apply_generic(self, m)

    def apply_generic_moved(self, m, moved_pis, reset_pis):
        r"""apply_generic_moved(PairContainer self, PairModifier m, IMP::ParticleIndexes const & moved_pis, IMP::ParticleIndexes const & reset_pis)"""
        return _IMP_kernel.PairContainer_apply_generic_moved(self, m, moved_pis, reset_pis)

    def apply(self, sm):
        r"""apply(PairContainer self, PairModifier sm)"""
        return _IMP_kernel.PairContainer_apply(self, sm)

    def apply_moved(self, sm, moved_pis, reset_pis):
        r"""apply_moved(PairContainer self, PairModifier sm, IMP::ParticleIndexes const & moved_pis, IMP::ParticleIndexes const & reset_pis)"""
        return _IMP_kernel.PairContainer_apply_moved(self, sm, moved_pis, reset_pis)

    def get_range_indexes(self):
        r"""get_range_indexes(PairContainer self) -> IMP::ParticleIndexPairs"""
        return _IMP_kernel.PairContainer_get_range_indexes(self)

    def get_contents(self):
        r"""get_contents(PairContainer self) -> IMP::ParticleIndexPairs const &"""
        return _IMP_kernel.PairContainer_get_contents(self)

    def get_indexes(self):
        r"""get_indexes(PairContainer self) -> IMP::ParticleIndexPairs"""
        return _IMP_kernel.PairContainer_get_indexes(self)

    def get(self, *args):
        r"""
        get(PairContainer self) -> IMP::ParticlePairsTemp
        get(PairContainer self, unsigned int i) -> IMP::ParticlePair
        """
        return _IMP_kernel.PairContainer_get(self, *args)

    def get_number(self):
        r"""get_number(PairContainer self) -> unsigned int"""
        return _IMP_kernel.PairContainer_get_number(self)

    def __init__(self, *args):
        r"""__init__(PairContainer self, Model m, std::string name="PairContainer %1%") -> PairContainer"""
        if self.__class__ == PairContainer:
            _self = None
        else:
            _self = self
        _IMP_kernel.PairContainer_swiginit(self, _IMP_kernel.new_PairContainer(_self, *args))

        if self.__class__ != PairContainer:
            _director_objects.register(self)




    def do_apply(self, sm):
        r"""do_apply(PairContainer self, PairModifier sm)"""
        return _IMP_kernel.PairContainer_do_apply(self, sm)

    def do_apply_moved(self, sm, moved_pis, reset_pis):
        r"""do_apply_moved(PairContainer self, PairModifier sm, IMP::ParticleIndexes const & moved_pis, IMP::ParticleIndexes const & reset_pis)"""
        return _IMP_kernel.PairContainer_do_apply_moved(self, sm, moved_pis, reset_pis)

    def do_get_provides_access(self):
        r"""do_get_provides_access(PairContainer self) -> bool"""
        return _IMP_kernel.PairContainer_do_get_provides_access(self)
    __swig_destroy__ = _IMP_kernel.delete_PairContainer

    def __str__(self):
        r"""__str__(PairContainer self) -> std::string"""
        return _IMP_kernel.PairContainer___str__(self)

    def __repr__(self):
        r"""__repr__(PairContainer self) -> std::string"""
        return _IMP_kernel.PairContainer___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_PairContainer(o)


    def get_type_name(self):
        return self.__class__.__name__
    def do_show(self, out):
        pass
    def get_version_info(self):
        if"IMP" == "IMP":
          return VersionInfo(self.__module__,
                             __import__(self.__module__).get_module_version())
        else:
          return IMP.VersionInfo(self.__module__,
                             __import__(self.__module__).get_module_version())
    @staticmethod
    def get_from(o):
       return _object_cast_to_PairContainer(o)

    def __disown__(self):
        self.this.disown()
        _IMP_kernel.disown_PairContainer(self)
        return weakref.proxy(self)

    def do_destroy(self):
        r"""do_destroy(PairContainer self)"""
        return _IMP_kernel.PairContainer_do_destroy(self)

    def handle_set_has_required_score_states(self, arg0):
        r"""handle_set_has_required_score_states(PairContainer self, bool arg0)"""
        return _IMP_kernel.PairContainer_handle_set_has_required_score_states(self, arg0)

    def do_get_inputs(self):
        r"""do_get_inputs(PairContainer self) -> IMP::ModelObjectsTemp"""
        return _IMP_kernel.PairContainer_do_get_inputs(self)

    def do_get_interactions(self):
        r"""do_get_interactions(PairContainer self) -> IMP::ModelObjectsTemps"""
        return _IMP_kernel.PairContainer_do_get_interactions(self)

    def do_get_contents_hash(self):
        r"""do_get_contents_hash(PairContainer self) -> std::size_t"""
        return _IMP_kernel.PairContainer_do_get_contents_hash(self)

# Register PairContainer in _IMP_kernel:
_IMP_kernel.PairContainer_swigregister(PairContainer)

class _PairContainerAdaptor(_InputAdaptor):
    r"""Proxy of C++ IMP::PairContainerAdaptor class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(_PairContainerAdaptor self) -> _PairContainerAdaptor
        __init__(_PairContainerAdaptor self, PairContainer c) -> _PairContainerAdaptor
        __init__(_PairContainerAdaptor self, IMP::ParticlePairsTemp const & t) -> _PairContainerAdaptor
        """
        _IMP_kernel._PairContainerAdaptor_swiginit(self, _IMP_kernel.new__PairContainerAdaptor(*args))

    def set_name_if_default(self, name):
        r"""set_name_if_default(_PairContainerAdaptor self, std::string name)"""
        return _IMP_kernel._PairContainerAdaptor_set_name_if_default(self, name)
    __swig_destroy__ = _IMP_kernel.delete__PairContainerAdaptor

# Register _PairContainerAdaptor in _IMP_kernel:
_IMP_kernel._PairContainerAdaptor_swigregister(_PairContainerAdaptor)

class QuadModifier(_ParticleInputs, _ParticleOutputs, Object):
    r"""Proxy of C++ IMP::QuadModifier class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""__init__(QuadModifier self, std::string name="QuadModifier %1%") -> QuadModifier"""
        if self.__class__ == QuadModifier:
            _self = None
        else:
            _self = self
        _IMP_kernel.QuadModifier_swiginit(self, _IMP_kernel.new_QuadModifier(_self, *args))

        if self.__class__ != QuadModifier:
            _director_objects.register(self)




    def apply_index(self, m, v):
        r"""apply_index(QuadModifier self, Model m, IMP::ParticleIndexQuad const & v)"""
        return _IMP_kernel.QuadModifier_apply_index(self, m, v)

    def apply_indexes(self, m, o, lower_bound, upper_bound):
        r"""apply_indexes(QuadModifier self, Model m, IMP::ParticleIndexQuads const & o, unsigned int lower_bound, unsigned int upper_bound)"""
        return _IMP_kernel.QuadModifier_apply_indexes(self, m, o, lower_bound, upper_bound)

    def apply_indexes_moved(self, m, o, lower_bound, upper_bound, moved_pis, reset_pis):
        r"""apply_indexes_moved(QuadModifier self, Model m, IMP::ParticleIndexQuads const & o, unsigned int lower_bound, unsigned int upper_bound, IMP::ParticleIndexes const & moved_pis, IMP::ParticleIndexes const & reset_pis)"""
        return _IMP_kernel.QuadModifier_apply_indexes_moved(self, m, o, lower_bound, upper_bound, moved_pis, reset_pis)

    def __str__(self):
        r"""__str__(QuadModifier self) -> std::string"""
        return _IMP_kernel.QuadModifier___str__(self)

    def __repr__(self):
        r"""__repr__(QuadModifier self) -> std::string"""
        return _IMP_kernel.QuadModifier___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_QuadModifier(o)


    def get_type_name(self):
        return self.__class__.__name__
    def do_show(self, out):
        pass
    def get_version_info(self):
        if"IMP" == "IMP":
          return VersionInfo(self.__module__,
                             __import__(self.__module__).get_module_version())
        else:
          return IMP.VersionInfo(self.__module__,
                             __import__(self.__module__).get_module_version())
    @staticmethod
    def get_from(o):
       return _object_cast_to_QuadModifier(o)

    __swig_destroy__ = _IMP_kernel.delete_QuadModifier
    def __disown__(self):
        self.this.disown()
        _IMP_kernel.disown_QuadModifier(self)
        return weakref.proxy(self)

    def do_get_inputs(self, m, pis):
        r"""do_get_inputs(QuadModifier self, Model m, IMP::ParticleIndexes const & pis) -> IMP::ModelObjectsTemp"""
        return _IMP_kernel.QuadModifier_do_get_inputs(self, m, pis)

    def do_get_outputs(self, m, pis):
        r"""do_get_outputs(QuadModifier self, Model m, IMP::ParticleIndexes const & pis) -> IMP::ModelObjectsTemp"""
        return _IMP_kernel.QuadModifier_do_get_outputs(self, m, pis)

    def do_destroy(self):
        r"""do_destroy(QuadModifier self)"""
        return _IMP_kernel.QuadModifier_do_destroy(self)

# Register QuadModifier in _IMP_kernel:
_IMP_kernel.QuadModifier_swigregister(QuadModifier)

class QuadScore(_ParticleInputs, Object):
    r"""Proxy of C++ IMP::QuadScore class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""__init__(QuadScore self, std::string name="QuadScore %1%") -> QuadScore"""
        if self.__class__ == QuadScore:
            _self = None
        else:
            _self = self
        _IMP_kernel.QuadScore_swiginit(self, _IMP_kernel.new_QuadScore(_self, *args))

        if self.__class__ != QuadScore:
            _director_objects.register(self)




    def evaluate_index(self, m, vt, da):
        r"""evaluate_index(QuadScore self, Model m, IMP::ParticleIndexQuad const & vt, DerivativeAccumulator da) -> double"""
        return _IMP_kernel.QuadScore_evaluate_index(self, m, vt, da)

    def evaluate_indexes(self, m, o, da, lower_bound, upper_bound):
        r"""evaluate_indexes(QuadScore self, Model m, IMP::ParticleIndexQuads const & o, DerivativeAccumulator da, unsigned int lower_bound, unsigned int upper_bound) -> double"""
        return _IMP_kernel.QuadScore_evaluate_indexes(self, m, o, da, lower_bound, upper_bound)

    def evaluate_indexes_scores(self, m, o, da, lower_bound, upper_bound, score):
        r"""evaluate_indexes_scores(QuadScore self, Model m, IMP::ParticleIndexQuads const & o, DerivativeAccumulator da, unsigned int lower_bound, unsigned int upper_bound, std::vector< double,std::allocator< double > > & score) -> double"""
        return _IMP_kernel.QuadScore_evaluate_indexes_scores(self, m, o, da, lower_bound, upper_bound, score)

    def evaluate_indexes_delta(self, m, o, da, indexes, score):
        r"""evaluate_indexes_delta(QuadScore self, Model m, IMP::ParticleIndexQuads const & o, DerivativeAccumulator da, std::vector< unsigned int,std::allocator< unsigned int > > const & indexes, std::vector< double,std::allocator< double > > & score) -> double"""
        return _IMP_kernel.QuadScore_evaluate_indexes_delta(self, m, o, da, indexes, score)

    def evaluate_if_good_index(self, m, vt, da, max):
        r"""evaluate_if_good_index(QuadScore self, Model m, IMP::ParticleIndexQuad const & vt, DerivativeAccumulator da, double max) -> double"""
        return _IMP_kernel.QuadScore_evaluate_if_good_index(self, m, vt, da, max)

    def evaluate_if_good_indexes(self, m, o, da, max, lower_bound, upper_bound):
        r"""evaluate_if_good_indexes(QuadScore self, Model m, IMP::ParticleIndexQuads const & o, DerivativeAccumulator da, double max, unsigned int lower_bound, unsigned int upper_bound) -> double"""
        return _IMP_kernel.QuadScore_evaluate_if_good_indexes(self, m, o, da, max, lower_bound, upper_bound)

    def create_current_decomposition(self, m, vt):
        r"""create_current_decomposition(QuadScore self, Model m, IMP::ParticleIndexQuad const & vt) -> IMP::Restraints"""
        return _IMP_kernel.QuadScore_create_current_decomposition(self, m, vt)

    def do_create_current_decomposition(self, m, vt):
        r"""do_create_current_decomposition(QuadScore self, Model m, IMP::ParticleIndexQuad const & vt) -> IMP::Restraints"""
        return _IMP_kernel.QuadScore_do_create_current_decomposition(self, m, vt)
    __swig_destroy__ = _IMP_kernel.delete_QuadScore

    def __str__(self):
        r"""__str__(QuadScore self) -> std::string"""
        return _IMP_kernel.QuadScore___str__(self)

    def __repr__(self):
        r"""__repr__(QuadScore self) -> std::string"""
        return _IMP_kernel.QuadScore___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_QuadScore(o)


    def get_type_name(self):
        return self.__class__.__name__
    def do_show(self, out):
        pass
    def get_version_info(self):
        if"IMP" == "IMP":
          return VersionInfo(self.__module__,
                             __import__(self.__module__).get_module_version())
        else:
          return IMP.VersionInfo(self.__module__,
                             __import__(self.__module__).get_module_version())
    @staticmethod
    def get_from(o):
       return _object_cast_to_QuadScore(o)

    def __disown__(self):
        self.this.disown()
        _IMP_kernel.disown_QuadScore(self)
        return weakref.proxy(self)

    def do_get_inputs(self, m, pis):
        r"""do_get_inputs(QuadScore self, Model m, IMP::ParticleIndexes const & pis) -> IMP::ModelObjectsTemp"""
        return _IMP_kernel.QuadScore_do_get_inputs(self, m, pis)

    def do_destroy(self):
        r"""do_destroy(QuadScore self)"""
        return _IMP_kernel.QuadScore_do_destroy(self)

# Register QuadScore in _IMP_kernel:
_IMP_kernel.QuadScore_swigregister(QuadScore)

class QuadPredicate(_ParticleInputs, Object):
    r"""Proxy of C++ IMP::QuadPredicate class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""__init__(QuadPredicate self, std::string name="QuadPredicate %1%") -> QuadPredicate"""
        if self.__class__ == QuadPredicate:
            _self = None
        else:
            _self = self
        _IMP_kernel.QuadPredicate_swiginit(self, _IMP_kernel.new_QuadPredicate(_self, *args))

        if self.__class__ != QuadPredicate:
            _director_objects.register(self)




    def setup_for_get_value_index_in_batch(self, arg0):
        r"""setup_for_get_value_index_in_batch(QuadPredicate self, Model arg0)"""
        return _IMP_kernel.QuadPredicate_setup_for_get_value_index_in_batch(self, arg0)

    def get_value_index_in_batch(self, m, vt):
        r"""get_value_index_in_batch(QuadPredicate self, Model m, IMP::ParticleIndexQuad const & vt) -> int"""
        return _IMP_kernel.QuadPredicate_get_value_index_in_batch(self, m, vt)

    def __call__(self, m, vt):
        r"""__call__(QuadPredicate self, Model m, IMP::ParticleIndexQuad const & vt) -> int"""
        return _IMP_kernel.QuadPredicate___call__(self, m, vt)

    def get_value_index(self, *args):
        r"""
        get_value_index(QuadPredicate self, Model m, IMP::ParticleIndexQuad const & vt) -> int
        get_value_index(QuadPredicate self, Model m, IMP::ParticleIndexQuads const & o) -> IMP::Ints
        """
        return _IMP_kernel.QuadPredicate_get_value_index(self, *args)
    __swig_destroy__ = _IMP_kernel.delete_QuadPredicate

    def __str__(self):
        r"""__str__(QuadPredicate self) -> std::string"""
        return _IMP_kernel.QuadPredicate___str__(self)

    def __repr__(self):
        r"""__repr__(QuadPredicate self) -> std::string"""
        return _IMP_kernel.QuadPredicate___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_QuadPredicate(o)


    def get_type_name(self):
        return self.__class__.__name__
    def do_show(self, out):
        pass
    def get_version_info(self):
        if"IMP" == "IMP":
          return VersionInfo(self.__module__,
                             __import__(self.__module__).get_module_version())
        else:
          return IMP.VersionInfo(self.__module__,
                             __import__(self.__module__).get_module_version())
    @staticmethod
    def get_from(o):
       return _object_cast_to_QuadPredicate(o)

    def __disown__(self):
        self.this.disown()
        _IMP_kernel.disown_QuadPredicate(self)
        return weakref.proxy(self)

    def do_get_inputs(self, m, pis):
        r"""do_get_inputs(QuadPredicate self, Model m, IMP::ParticleIndexes const & pis) -> IMP::ModelObjectsTemp"""
        return _IMP_kernel.QuadPredicate_do_get_inputs(self, m, pis)

    def do_destroy(self):
        r"""do_destroy(QuadPredicate self)"""
        return _IMP_kernel.QuadPredicate_do_destroy(self)

# Register QuadPredicate in _IMP_kernel:
_IMP_kernel.QuadPredicate_swigregister(QuadPredicate)

class QuadContainer(Container):
    r"""Proxy of C++ IMP::QuadContainer class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def apply_generic(self, m):
        r"""apply_generic(QuadContainer self, QuadModifier m)"""
        return _IMP_kernel.QuadContainer_apply_generic(self, m)

    def apply_generic_moved(self, m, moved_pis, reset_pis):
        r"""apply_generic_moved(QuadContainer self, QuadModifier m, IMP::ParticleIndexes const & moved_pis, IMP::ParticleIndexes const & reset_pis)"""
        return _IMP_kernel.QuadContainer_apply_generic_moved(self, m, moved_pis, reset_pis)

    def apply(self, sm):
        r"""apply(QuadContainer self, QuadModifier sm)"""
        return _IMP_kernel.QuadContainer_apply(self, sm)

    def apply_moved(self, sm, moved_pis, reset_pis):
        r"""apply_moved(QuadContainer self, QuadModifier sm, IMP::ParticleIndexes const & moved_pis, IMP::ParticleIndexes const & reset_pis)"""
        return _IMP_kernel.QuadContainer_apply_moved(self, sm, moved_pis, reset_pis)

    def get_range_indexes(self):
        r"""get_range_indexes(QuadContainer self) -> IMP::ParticleIndexQuads"""
        return _IMP_kernel.QuadContainer_get_range_indexes(self)

    def get_contents(self):
        r"""get_contents(QuadContainer self) -> IMP::ParticleIndexQuads const &"""
        return _IMP_kernel.QuadContainer_get_contents(self)

    def get_indexes(self):
        r"""get_indexes(QuadContainer self) -> IMP::ParticleIndexQuads"""
        return _IMP_kernel.QuadContainer_get_indexes(self)

    def get(self, *args):
        r"""
        get(QuadContainer self) -> IMP::ParticleQuadsTemp
        get(QuadContainer self, unsigned int i) -> IMP::ParticleQuad
        """
        return _IMP_kernel.QuadContainer_get(self, *args)

    def get_number(self):
        r"""get_number(QuadContainer self) -> unsigned int"""
        return _IMP_kernel.QuadContainer_get_number(self)

    def __init__(self, *args):
        r"""__init__(QuadContainer self, Model m, std::string name="QuadContainer %1%") -> QuadContainer"""
        if self.__class__ == QuadContainer:
            _self = None
        else:
            _self = self
        _IMP_kernel.QuadContainer_swiginit(self, _IMP_kernel.new_QuadContainer(_self, *args))

        if self.__class__ != QuadContainer:
            _director_objects.register(self)




    def do_apply(self, sm):
        r"""do_apply(QuadContainer self, QuadModifier sm)"""
        return _IMP_kernel.QuadContainer_do_apply(self, sm)

    def do_apply_moved(self, sm, moved_pis, reset_pis):
        r"""do_apply_moved(QuadContainer self, QuadModifier sm, IMP::ParticleIndexes const & moved_pis, IMP::ParticleIndexes const & reset_pis)"""
        return _IMP_kernel.QuadContainer_do_apply_moved(self, sm, moved_pis, reset_pis)

    def do_get_provides_access(self):
        r"""do_get_provides_access(QuadContainer self) -> bool"""
        return _IMP_kernel.QuadContainer_do_get_provides_access(self)
    __swig_destroy__ = _IMP_kernel.delete_QuadContainer

    def __str__(self):
        r"""__str__(QuadContainer self) -> std::string"""
        return _IMP_kernel.QuadContainer___str__(self)

    def __repr__(self):
        r"""__repr__(QuadContainer self) -> std::string"""
        return _IMP_kernel.QuadContainer___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_QuadContainer(o)


    def get_type_name(self):
        return self.__class__.__name__
    def do_show(self, out):
        pass
    def get_version_info(self):
        if"IMP" == "IMP":
          return VersionInfo(self.__module__,
                             __import__(self.__module__).get_module_version())
        else:
          return IMP.VersionInfo(self.__module__,
                             __import__(self.__module__).get_module_version())
    @staticmethod
    def get_from(o):
       return _object_cast_to_QuadContainer(o)

    def __disown__(self):
        self.this.disown()
        _IMP_kernel.disown_QuadContainer(self)
        return weakref.proxy(self)

    def do_destroy(self):
        r"""do_destroy(QuadContainer self)"""
        return _IMP_kernel.QuadContainer_do_destroy(self)

    def handle_set_has_required_score_states(self, arg0):
        r"""handle_set_has_required_score_states(QuadContainer self, bool arg0)"""
        return _IMP_kernel.QuadContainer_handle_set_has_required_score_states(self, arg0)

    def do_get_inputs(self):
        r"""do_get_inputs(QuadContainer self) -> IMP::ModelObjectsTemp"""
        return _IMP_kernel.QuadContainer_do_get_inputs(self)

    def do_get_interactions(self):
        r"""do_get_interactions(QuadContainer self) -> IMP::ModelObjectsTemps"""
        return _IMP_kernel.QuadContainer_do_get_interactions(self)

    def do_get_contents_hash(self):
        r"""do_get_contents_hash(QuadContainer self) -> std::size_t"""
        return _IMP_kernel.QuadContainer_do_get_contents_hash(self)

# Register QuadContainer in _IMP_kernel:
_IMP_kernel.QuadContainer_swigregister(QuadContainer)

class _QuadContainerAdaptor(_InputAdaptor):
    r"""Proxy of C++ IMP::QuadContainerAdaptor class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(_QuadContainerAdaptor self) -> _QuadContainerAdaptor
        __init__(_QuadContainerAdaptor self, QuadContainer c) -> _QuadContainerAdaptor
        __init__(_QuadContainerAdaptor self, IMP::ParticleQuadsTemp const & t) -> _QuadContainerAdaptor
        """
        _IMP_kernel._QuadContainerAdaptor_swiginit(self, _IMP_kernel.new__QuadContainerAdaptor(*args))

    def set_name_if_default(self, name):
        r"""set_name_if_default(_QuadContainerAdaptor self, std::string name)"""
        return _IMP_kernel._QuadContainerAdaptor_set_name_if_default(self, name)
    __swig_destroy__ = _IMP_kernel.delete__QuadContainerAdaptor

# Register _QuadContainerAdaptor in _IMP_kernel:
_IMP_kernel._QuadContainerAdaptor_swigregister(_QuadContainerAdaptor)

class SingletonModifier(_ParticleInputs, _ParticleOutputs, Object):
    r"""Proxy of C++ IMP::SingletonModifier class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""__init__(SingletonModifier self, std::string name="SingletonModifier %1%") -> SingletonModifier"""
        if self.__class__ == SingletonModifier:
            _self = None
        else:
            _self = self
        _IMP_kernel.SingletonModifier_swiginit(self, _IMP_kernel.new_SingletonModifier(_self, *args))

        if self.__class__ != SingletonModifier:
            _director_objects.register(self)




    def apply_index(self, m, v):
        r"""apply_index(SingletonModifier self, Model m, ParticleIndex v)"""
        return _IMP_kernel.SingletonModifier_apply_index(self, m, v)

    def apply_indexes(self, m, o, lower_bound, upper_bound):
        r"""apply_indexes(SingletonModifier self, Model m, IMP::ParticleIndexes const & o, unsigned int lower_bound, unsigned int upper_bound)"""
        return _IMP_kernel.SingletonModifier_apply_indexes(self, m, o, lower_bound, upper_bound)

    def apply_indexes_moved(self, m, o, lower_bound, upper_bound, moved_pis, reset_pis):
        r"""apply_indexes_moved(SingletonModifier self, Model m, IMP::ParticleIndexes const & o, unsigned int lower_bound, unsigned int upper_bound, IMP::ParticleIndexes const & moved_pis, IMP::ParticleIndexes const & reset_pis)"""
        return _IMP_kernel.SingletonModifier_apply_indexes_moved(self, m, o, lower_bound, upper_bound, moved_pis, reset_pis)

    def __str__(self):
        r"""__str__(SingletonModifier self) -> std::string"""
        return _IMP_kernel.SingletonModifier___str__(self)

    def __repr__(self):
        r"""__repr__(SingletonModifier self) -> std::string"""
        return _IMP_kernel.SingletonModifier___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_SingletonModifier(o)


    def get_type_name(self):
        return self.__class__.__name__
    def do_show(self, out):
        pass
    def get_version_info(self):
        if"IMP" == "IMP":
          return VersionInfo(self.__module__,
                             __import__(self.__module__).get_module_version())
        else:
          return IMP.VersionInfo(self.__module__,
                             __import__(self.__module__).get_module_version())
    @staticmethod
    def get_from(o):
       return _object_cast_to_SingletonModifier(o)

    __swig_destroy__ = _IMP_kernel.delete_SingletonModifier
    def __disown__(self):
        self.this.disown()
        _IMP_kernel.disown_SingletonModifier(self)
        return weakref.proxy(self)

    def do_get_inputs(self, m, pis):
        r"""do_get_inputs(SingletonModifier self, Model m, IMP::ParticleIndexes const & pis) -> IMP::ModelObjectsTemp"""
        return _IMP_kernel.SingletonModifier_do_get_inputs(self, m, pis)

    def do_get_outputs(self, m, pis):
        r"""do_get_outputs(SingletonModifier self, Model m, IMP::ParticleIndexes const & pis) -> IMP::ModelObjectsTemp"""
        return _IMP_kernel.SingletonModifier_do_get_outputs(self, m, pis)

    def do_destroy(self):
        r"""do_destroy(SingletonModifier self)"""
        return _IMP_kernel.SingletonModifier_do_destroy(self)

# Register SingletonModifier in _IMP_kernel:
_IMP_kernel.SingletonModifier_swigregister(SingletonModifier)

class SingletonScore(_ParticleInputs, Object):
    r"""Proxy of C++ IMP::SingletonScore class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""__init__(SingletonScore self, std::string name="SingletonScore %1%") -> SingletonScore"""
        if self.__class__ == SingletonScore:
            _self = None
        else:
            _self = self
        _IMP_kernel.SingletonScore_swiginit(self, _IMP_kernel.new_SingletonScore(_self, *args))

        if self.__class__ != SingletonScore:
            _director_objects.register(self)




    def evaluate_index(self, m, vt, da):
        r"""evaluate_index(SingletonScore self, Model m, ParticleIndex vt, DerivativeAccumulator da) -> double"""
        return _IMP_kernel.SingletonScore_evaluate_index(self, m, vt, da)

    def evaluate_indexes(self, m, o, da, lower_bound, upper_bound):
        r"""evaluate_indexes(SingletonScore self, Model m, IMP::ParticleIndexes const & o, DerivativeAccumulator da, unsigned int lower_bound, unsigned int upper_bound) -> double"""
        return _IMP_kernel.SingletonScore_evaluate_indexes(self, m, o, da, lower_bound, upper_bound)

    def evaluate_indexes_scores(self, m, o, da, lower_bound, upper_bound, score):
        r"""evaluate_indexes_scores(SingletonScore self, Model m, IMP::ParticleIndexes const & o, DerivativeAccumulator da, unsigned int lower_bound, unsigned int upper_bound, std::vector< double,std::allocator< double > > & score) -> double"""
        return _IMP_kernel.SingletonScore_evaluate_indexes_scores(self, m, o, da, lower_bound, upper_bound, score)

    def evaluate_indexes_delta(self, m, o, da, indexes, score):
        r"""evaluate_indexes_delta(SingletonScore self, Model m, IMP::ParticleIndexes const & o, DerivativeAccumulator da, std::vector< unsigned int,std::allocator< unsigned int > > const & indexes, std::vector< double,std::allocator< double > > & score) -> double"""
        return _IMP_kernel.SingletonScore_evaluate_indexes_delta(self, m, o, da, indexes, score)

    def evaluate_if_good_index(self, m, vt, da, max):
        r"""evaluate_if_good_index(SingletonScore self, Model m, ParticleIndex vt, DerivativeAccumulator da, double max) -> double"""
        return _IMP_kernel.SingletonScore_evaluate_if_good_index(self, m, vt, da, max)

    def evaluate_if_good_indexes(self, m, o, da, max, lower_bound, upper_bound):
        r"""evaluate_if_good_indexes(SingletonScore self, Model m, IMP::ParticleIndexes const & o, DerivativeAccumulator da, double max, unsigned int lower_bound, unsigned int upper_bound) -> double"""
        return _IMP_kernel.SingletonScore_evaluate_if_good_indexes(self, m, o, da, max, lower_bound, upper_bound)

    def create_current_decomposition(self, m, vt):
        r"""create_current_decomposition(SingletonScore self, Model m, ParticleIndex vt) -> IMP::Restraints"""
        return _IMP_kernel.SingletonScore_create_current_decomposition(self, m, vt)

    def do_create_current_decomposition(self, m, vt):
        r"""do_create_current_decomposition(SingletonScore self, Model m, ParticleIndex vt) -> IMP::Restraints"""
        return _IMP_kernel.SingletonScore_do_create_current_decomposition(self, m, vt)
    __swig_destroy__ = _IMP_kernel.delete_SingletonScore

    def __str__(self):
        r"""__str__(SingletonScore self) -> std::string"""
        return _IMP_kernel.SingletonScore___str__(self)

    def __repr__(self):
        r"""__repr__(SingletonScore self) -> std::string"""
        return _IMP_kernel.SingletonScore___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_SingletonScore(o)


    def get_type_name(self):
        return self.__class__.__name__
    def do_show(self, out):
        pass
    def get_version_info(self):
        if"IMP" == "IMP":
          return VersionInfo(self.__module__,
                             __import__(self.__module__).get_module_version())
        else:
          return IMP.VersionInfo(self.__module__,
                             __import__(self.__module__).get_module_version())
    @staticmethod
    def get_from(o):
       return _object_cast_to_SingletonScore(o)

    def __disown__(self):
        self.this.disown()
        _IMP_kernel.disown_SingletonScore(self)
        return weakref.proxy(self)

    def do_get_inputs(self, m, pis):
        r"""do_get_inputs(SingletonScore self, Model m, IMP::ParticleIndexes const & pis) -> IMP::ModelObjectsTemp"""
        return _IMP_kernel.SingletonScore_do_get_inputs(self, m, pis)

    def do_destroy(self):
        r"""do_destroy(SingletonScore self)"""
        return _IMP_kernel.SingletonScore_do_destroy(self)

# Register SingletonScore in _IMP_kernel:
_IMP_kernel.SingletonScore_swigregister(SingletonScore)

class SingletonPredicate(_ParticleInputs, Object):
    r"""Proxy of C++ IMP::SingletonPredicate class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""__init__(SingletonPredicate self, std::string name="SingletonPredicate %1%") -> SingletonPredicate"""
        if self.__class__ == SingletonPredicate:
            _self = None
        else:
            _self = self
        _IMP_kernel.SingletonPredicate_swiginit(self, _IMP_kernel.new_SingletonPredicate(_self, *args))

        if self.__class__ != SingletonPredicate:
            _director_objects.register(self)




    def setup_for_get_value_index_in_batch(self, arg0):
        r"""setup_for_get_value_index_in_batch(SingletonPredicate self, Model arg0)"""
        return _IMP_kernel.SingletonPredicate_setup_for_get_value_index_in_batch(self, arg0)

    def get_value_index_in_batch(self, m, vt):
        r"""get_value_index_in_batch(SingletonPredicate self, Model m, ParticleIndex vt) -> int"""
        return _IMP_kernel.SingletonPredicate_get_value_index_in_batch(self, m, vt)

    def __call__(self, m, vt):
        r"""__call__(SingletonPredicate self, Model m, ParticleIndex vt) -> int"""
        return _IMP_kernel.SingletonPredicate___call__(self, m, vt)

    def get_value_index(self, *args):
        r"""
        get_value_index(SingletonPredicate self, Model m, ParticleIndex vt) -> int
        get_value_index(SingletonPredicate self, Model m, IMP::ParticleIndexes const & o) -> IMP::Ints
        """
        return _IMP_kernel.SingletonPredicate_get_value_index(self, *args)
    __swig_destroy__ = _IMP_kernel.delete_SingletonPredicate

    def __str__(self):
        r"""__str__(SingletonPredicate self) -> std::string"""
        return _IMP_kernel.SingletonPredicate___str__(self)

    def __repr__(self):
        r"""__repr__(SingletonPredicate self) -> std::string"""
        return _IMP_kernel.SingletonPredicate___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_SingletonPredicate(o)


    def get_type_name(self):
        return self.__class__.__name__
    def do_show(self, out):
        pass
    def get_version_info(self):
        if"IMP" == "IMP":
          return VersionInfo(self.__module__,
                             __import__(self.__module__).get_module_version())
        else:
          return IMP.VersionInfo(self.__module__,
                             __import__(self.__module__).get_module_version())
    @staticmethod
    def get_from(o):
       return _object_cast_to_SingletonPredicate(o)

    def __disown__(self):
        self.this.disown()
        _IMP_kernel.disown_SingletonPredicate(self)
        return weakref.proxy(self)

    def do_get_inputs(self, m, pis):
        r"""do_get_inputs(SingletonPredicate self, Model m, IMP::ParticleIndexes const & pis) -> IMP::ModelObjectsTemp"""
        return _IMP_kernel.SingletonPredicate_do_get_inputs(self, m, pis)

    def do_destroy(self):
        r"""do_destroy(SingletonPredicate self)"""
        return _IMP_kernel.SingletonPredicate_do_destroy(self)

# Register SingletonPredicate in _IMP_kernel:
_IMP_kernel.SingletonPredicate_swigregister(SingletonPredicate)

class SingletonContainer(Container):
    r"""Proxy of C++ IMP::SingletonContainer class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def apply_generic(self, m):
        r"""apply_generic(SingletonContainer self, SingletonModifier m)"""
        return _IMP_kernel.SingletonContainer_apply_generic(self, m)

    def apply_generic_moved(self, m, moved_pis, reset_pis):
        r"""apply_generic_moved(SingletonContainer self, SingletonModifier m, IMP::ParticleIndexes const & moved_pis, IMP::ParticleIndexes const & reset_pis)"""
        return _IMP_kernel.SingletonContainer_apply_generic_moved(self, m, moved_pis, reset_pis)

    def apply(self, sm):
        r"""apply(SingletonContainer self, SingletonModifier sm)"""
        return _IMP_kernel.SingletonContainer_apply(self, sm)

    def apply_moved(self, sm, moved_pis, reset_pis):
        r"""apply_moved(SingletonContainer self, SingletonModifier sm, IMP::ParticleIndexes const & moved_pis, IMP::ParticleIndexes const & reset_pis)"""
        return _IMP_kernel.SingletonContainer_apply_moved(self, sm, moved_pis, reset_pis)

    def get_range_indexes(self):
        r"""get_range_indexes(SingletonContainer self) -> IMP::ParticleIndexes"""
        return _IMP_kernel.SingletonContainer_get_range_indexes(self)

    def get_contents(self):
        r"""get_contents(SingletonContainer self) -> IMP::ParticleIndexes const &"""
        return _IMP_kernel.SingletonContainer_get_contents(self)

    def get_indexes(self):
        r"""get_indexes(SingletonContainer self) -> IMP::ParticleIndexes"""
        return _IMP_kernel.SingletonContainer_get_indexes(self)

    def get(self, *args):
        r"""
        get(SingletonContainer self) -> IMP::ParticlesTemp
        get(SingletonContainer self, unsigned int i) -> Particle
        """
        return _IMP_kernel.SingletonContainer_get(self, *args)

    def get_number(self):
        r"""get_number(SingletonContainer self) -> unsigned int"""
        return _IMP_kernel.SingletonContainer_get_number(self)

    def __init__(self, *args):
        r"""__init__(SingletonContainer self, Model m, std::string name="SingletonContainer %1%") -> SingletonContainer"""
        if self.__class__ == SingletonContainer:
            _self = None
        else:
            _self = self
        _IMP_kernel.SingletonContainer_swiginit(self, _IMP_kernel.new_SingletonContainer(_self, *args))

        if self.__class__ != SingletonContainer:
            _director_objects.register(self)




    def do_apply(self, sm):
        r"""do_apply(SingletonContainer self, SingletonModifier sm)"""
        return _IMP_kernel.SingletonContainer_do_apply(self, sm)

    def do_apply_moved(self, sm, moved_pis, reset_pis):
        r"""do_apply_moved(SingletonContainer self, SingletonModifier sm, IMP::ParticleIndexes const & moved_pis, IMP::ParticleIndexes const & reset_pis)"""
        return _IMP_kernel.SingletonContainer_do_apply_moved(self, sm, moved_pis, reset_pis)

    def do_get_provides_access(self):
        r"""do_get_provides_access(SingletonContainer self) -> bool"""
        return _IMP_kernel.SingletonContainer_do_get_provides_access(self)
    __swig_destroy__ = _IMP_kernel.delete_SingletonContainer

    def __str__(self):
        r"""__str__(SingletonContainer self) -> std::string"""
        return _IMP_kernel.SingletonContainer___str__(self)

    def __repr__(self):
        r"""__repr__(SingletonContainer self) -> std::string"""
        return _IMP_kernel.SingletonContainer___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_SingletonContainer(o)


    def get_type_name(self):
        return self.__class__.__name__
    def do_show(self, out):
        pass
    def get_version_info(self):
        if"IMP" == "IMP":
          return VersionInfo(self.__module__,
                             __import__(self.__module__).get_module_version())
        else:
          return IMP.VersionInfo(self.__module__,
                             __import__(self.__module__).get_module_version())
    @staticmethod
    def get_from(o):
       return _object_cast_to_SingletonContainer(o)

    def __disown__(self):
        self.this.disown()
        _IMP_kernel.disown_SingletonContainer(self)
        return weakref.proxy(self)

    def do_destroy(self):
        r"""do_destroy(SingletonContainer self)"""
        return _IMP_kernel.SingletonContainer_do_destroy(self)

    def handle_set_has_required_score_states(self, arg0):
        r"""handle_set_has_required_score_states(SingletonContainer self, bool arg0)"""
        return _IMP_kernel.SingletonContainer_handle_set_has_required_score_states(self, arg0)

    def do_get_inputs(self):
        r"""do_get_inputs(SingletonContainer self) -> IMP::ModelObjectsTemp"""
        return _IMP_kernel.SingletonContainer_do_get_inputs(self)

    def do_get_interactions(self):
        r"""do_get_interactions(SingletonContainer self) -> IMP::ModelObjectsTemps"""
        return _IMP_kernel.SingletonContainer_do_get_interactions(self)

    def do_get_contents_hash(self):
        r"""do_get_contents_hash(SingletonContainer self) -> std::size_t"""
        return _IMP_kernel.SingletonContainer_do_get_contents_hash(self)

# Register SingletonContainer in _IMP_kernel:
_IMP_kernel.SingletonContainer_swigregister(SingletonContainer)

class _SingletonContainerAdaptor(_InputAdaptor):
    r"""Proxy of C++ IMP::SingletonContainerAdaptor class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(_SingletonContainerAdaptor self) -> _SingletonContainerAdaptor
        __init__(_SingletonContainerAdaptor self, SingletonContainer c) -> _SingletonContainerAdaptor
        __init__(_SingletonContainerAdaptor self, IMP::ParticlesTemp const & t) -> _SingletonContainerAdaptor
        """
        _IMP_kernel._SingletonContainerAdaptor_swiginit(self, _IMP_kernel.new__SingletonContainerAdaptor(*args))

    def set_name_if_default(self, name):
        r"""set_name_if_default(_SingletonContainerAdaptor self, std::string name)"""
        return _IMP_kernel._SingletonContainerAdaptor_set_name_if_default(self, name)
    __swig_destroy__ = _IMP_kernel.delete__SingletonContainerAdaptor

# Register _SingletonContainerAdaptor in _IMP_kernel:
_IMP_kernel._SingletonContainerAdaptor_swigregister(_SingletonContainerAdaptor)

class TripletModifier(_ParticleInputs, _ParticleOutputs, Object):
    r"""Proxy of C++ IMP::TripletModifier class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""__init__(TripletModifier self, std::string name="TripletModifier %1%") -> TripletModifier"""
        if self.__class__ == TripletModifier:
            _self = None
        else:
            _self = self
        _IMP_kernel.TripletModifier_swiginit(self, _IMP_kernel.new_TripletModifier(_self, *args))

        if self.__class__ != TripletModifier:
            _director_objects.register(self)




    def apply_index(self, m, v):
        r"""apply_index(TripletModifier self, Model m, IMP::ParticleIndexTriplet const & v)"""
        return _IMP_kernel.TripletModifier_apply_index(self, m, v)

    def apply_indexes(self, m, o, lower_bound, upper_bound):
        r"""apply_indexes(TripletModifier self, Model m, IMP::ParticleIndexTriplets const & o, unsigned int lower_bound, unsigned int upper_bound)"""
        return _IMP_kernel.TripletModifier_apply_indexes(self, m, o, lower_bound, upper_bound)

    def apply_indexes_moved(self, m, o, lower_bound, upper_bound, moved_pis, reset_pis):
        r"""apply_indexes_moved(TripletModifier self, Model m, IMP::ParticleIndexTriplets const & o, unsigned int lower_bound, unsigned int upper_bound, IMP::ParticleIndexes const & moved_pis, IMP::ParticleIndexes const & reset_pis)"""
        return _IMP_kernel.TripletModifier_apply_indexes_moved(self, m, o, lower_bound, upper_bound, moved_pis, reset_pis)

    def __str__(self):
        r"""__str__(TripletModifier self) -> std::string"""
        return _IMP_kernel.TripletModifier___str__(self)

    def __repr__(self):
        r"""__repr__(TripletModifier self) -> std::string"""
        return _IMP_kernel.TripletModifier___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_TripletModifier(o)


    def get_type_name(self):
        return self.__class__.__name__
    def do_show(self, out):
        pass
    def get_version_info(self):
        if"IMP" == "IMP":
          return VersionInfo(self.__module__,
                             __import__(self.__module__).get_module_version())
        else:
          return IMP.VersionInfo(self.__module__,
                             __import__(self.__module__).get_module_version())
    @staticmethod
    def get_from(o):
       return _object_cast_to_TripletModifier(o)

    __swig_destroy__ = _IMP_kernel.delete_TripletModifier
    def __disown__(self):
        self.this.disown()
        _IMP_kernel.disown_TripletModifier(self)
        return weakref.proxy(self)

    def do_get_inputs(self, m, pis):
        r"""do_get_inputs(TripletModifier self, Model m, IMP::ParticleIndexes const & pis) -> IMP::ModelObjectsTemp"""
        return _IMP_kernel.TripletModifier_do_get_inputs(self, m, pis)

    def do_get_outputs(self, m, pis):
        r"""do_get_outputs(TripletModifier self, Model m, IMP::ParticleIndexes const & pis) -> IMP::ModelObjectsTemp"""
        return _IMP_kernel.TripletModifier_do_get_outputs(self, m, pis)

    def do_destroy(self):
        r"""do_destroy(TripletModifier self)"""
        return _IMP_kernel.TripletModifier_do_destroy(self)

# Register TripletModifier in _IMP_kernel:
_IMP_kernel.TripletModifier_swigregister(TripletModifier)

class TripletScore(_ParticleInputs, Object):
    r"""Proxy of C++ IMP::TripletScore class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""__init__(TripletScore self, std::string name="TripletScore %1%") -> TripletScore"""
        if self.__class__ == TripletScore:
            _self = None
        else:
            _self = self
        _IMP_kernel.TripletScore_swiginit(self, _IMP_kernel.new_TripletScore(_self, *args))

        if self.__class__ != TripletScore:
            _director_objects.register(self)




    def evaluate_index(self, m, vt, da):
        r"""evaluate_index(TripletScore self, Model m, IMP::ParticleIndexTriplet const & vt, DerivativeAccumulator da) -> double"""
        return _IMP_kernel.TripletScore_evaluate_index(self, m, vt, da)

    def evaluate_indexes(self, m, o, da, lower_bound, upper_bound):
        r"""evaluate_indexes(TripletScore self, Model m, IMP::ParticleIndexTriplets const & o, DerivativeAccumulator da, unsigned int lower_bound, unsigned int upper_bound) -> double"""
        return _IMP_kernel.TripletScore_evaluate_indexes(self, m, o, da, lower_bound, upper_bound)

    def evaluate_indexes_scores(self, m, o, da, lower_bound, upper_bound, score):
        r"""evaluate_indexes_scores(TripletScore self, Model m, IMP::ParticleIndexTriplets const & o, DerivativeAccumulator da, unsigned int lower_bound, unsigned int upper_bound, std::vector< double,std::allocator< double > > & score) -> double"""
        return _IMP_kernel.TripletScore_evaluate_indexes_scores(self, m, o, da, lower_bound, upper_bound, score)

    def evaluate_indexes_delta(self, m, o, da, indexes, score):
        r"""evaluate_indexes_delta(TripletScore self, Model m, IMP::ParticleIndexTriplets const & o, DerivativeAccumulator da, std::vector< unsigned int,std::allocator< unsigned int > > const & indexes, std::vector< double,std::allocator< double > > & score) -> double"""
        return _IMP_kernel.TripletScore_evaluate_indexes_delta(self, m, o, da, indexes, score)

    def evaluate_if_good_index(self, m, vt, da, max):
        r"""evaluate_if_good_index(TripletScore self, Model m, IMP::ParticleIndexTriplet const & vt, DerivativeAccumulator da, double max) -> double"""
        return _IMP_kernel.TripletScore_evaluate_if_good_index(self, m, vt, da, max)

    def evaluate_if_good_indexes(self, m, o, da, max, lower_bound, upper_bound):
        r"""evaluate_if_good_indexes(TripletScore self, Model m, IMP::ParticleIndexTriplets const & o, DerivativeAccumulator da, double max, unsigned int lower_bound, unsigned int upper_bound) -> double"""
        return _IMP_kernel.TripletScore_evaluate_if_good_indexes(self, m, o, da, max, lower_bound, upper_bound)

    def create_current_decomposition(self, m, vt):
        r"""create_current_decomposition(TripletScore self, Model m, IMP::ParticleIndexTriplet const & vt) -> IMP::Restraints"""
        return _IMP_kernel.TripletScore_create_current_decomposition(self, m, vt)

    def do_create_current_decomposition(self, m, vt):
        r"""do_create_current_decomposition(TripletScore self, Model m, IMP::ParticleIndexTriplet const & vt) -> IMP::Restraints"""
        return _IMP_kernel.TripletScore_do_create_current_decomposition(self, m, vt)
    __swig_destroy__ = _IMP_kernel.delete_TripletScore

    def __str__(self):
        r"""__str__(TripletScore self) -> std::string"""
        return _IMP_kernel.TripletScore___str__(self)

    def __repr__(self):
        r"""__repr__(TripletScore self) -> std::string"""
        return _IMP_kernel.TripletScore___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_TripletScore(o)


    def get_type_name(self):
        return self.__class__.__name__
    def do_show(self, out):
        pass
    def get_version_info(self):
        if"IMP" == "IMP":
          return VersionInfo(self.__module__,
                             __import__(self.__module__).get_module_version())
        else:
          return IMP.VersionInfo(self.__module__,
                             __import__(self.__module__).get_module_version())
    @staticmethod
    def get_from(o):
       return _object_cast_to_TripletScore(o)

    def __disown__(self):
        self.this.disown()
        _IMP_kernel.disown_TripletScore(self)
        return weakref.proxy(self)

    def do_get_inputs(self, m, pis):
        r"""do_get_inputs(TripletScore self, Model m, IMP::ParticleIndexes const & pis) -> IMP::ModelObjectsTemp"""
        return _IMP_kernel.TripletScore_do_get_inputs(self, m, pis)

    def do_destroy(self):
        r"""do_destroy(TripletScore self)"""
        return _IMP_kernel.TripletScore_do_destroy(self)

# Register TripletScore in _IMP_kernel:
_IMP_kernel.TripletScore_swigregister(TripletScore)

class TripletPredicate(_ParticleInputs, Object):
    r"""Proxy of C++ IMP::TripletPredicate class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""__init__(TripletPredicate self, std::string name="TripletPredicate %1%") -> TripletPredicate"""
        if self.__class__ == TripletPredicate:
            _self = None
        else:
            _self = self
        _IMP_kernel.TripletPredicate_swiginit(self, _IMP_kernel.new_TripletPredicate(_self, *args))

        if self.__class__ != TripletPredicate:
            _director_objects.register(self)




    def setup_for_get_value_index_in_batch(self, arg0):
        r"""setup_for_get_value_index_in_batch(TripletPredicate self, Model arg0)"""
        return _IMP_kernel.TripletPredicate_setup_for_get_value_index_in_batch(self, arg0)

    def get_value_index_in_batch(self, m, vt):
        r"""get_value_index_in_batch(TripletPredicate self, Model m, IMP::ParticleIndexTriplet const & vt) -> int"""
        return _IMP_kernel.TripletPredicate_get_value_index_in_batch(self, m, vt)

    def __call__(self, m, vt):
        r"""__call__(TripletPredicate self, Model m, IMP::ParticleIndexTriplet const & vt) -> int"""
        return _IMP_kernel.TripletPredicate___call__(self, m, vt)

    def get_value_index(self, *args):
        r"""
        get_value_index(TripletPredicate self, Model m, IMP::ParticleIndexTriplet const & vt) -> int
        get_value_index(TripletPredicate self, Model m, IMP::ParticleIndexTriplets const & o) -> IMP::Ints
        """
        return _IMP_kernel.TripletPredicate_get_value_index(self, *args)
    __swig_destroy__ = _IMP_kernel.delete_TripletPredicate

    def __str__(self):
        r"""__str__(TripletPredicate self) -> std::string"""
        return _IMP_kernel.TripletPredicate___str__(self)

    def __repr__(self):
        r"""__repr__(TripletPredicate self) -> std::string"""
        return _IMP_kernel.TripletPredicate___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_TripletPredicate(o)


    def get_type_name(self):
        return self.__class__.__name__
    def do_show(self, out):
        pass
    def get_version_info(self):
        if"IMP" == "IMP":
          return VersionInfo(self.__module__,
                             __import__(self.__module__).get_module_version())
        else:
          return IMP.VersionInfo(self.__module__,
                             __import__(self.__module__).get_module_version())
    @staticmethod
    def get_from(o):
       return _object_cast_to_TripletPredicate(o)

    def __disown__(self):
        self.this.disown()
        _IMP_kernel.disown_TripletPredicate(self)
        return weakref.proxy(self)

    def do_get_inputs(self, m, pis):
        r"""do_get_inputs(TripletPredicate self, Model m, IMP::ParticleIndexes const & pis) -> IMP::ModelObjectsTemp"""
        return _IMP_kernel.TripletPredicate_do_get_inputs(self, m, pis)

    def do_destroy(self):
        r"""do_destroy(TripletPredicate self)"""
        return _IMP_kernel.TripletPredicate_do_destroy(self)

# Register TripletPredicate in _IMP_kernel:
_IMP_kernel.TripletPredicate_swigregister(TripletPredicate)

class TripletContainer(Container):
    r"""Proxy of C++ IMP::TripletContainer class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def apply_generic(self, m):
        r"""apply_generic(TripletContainer self, TripletModifier m)"""
        return _IMP_kernel.TripletContainer_apply_generic(self, m)

    def apply_generic_moved(self, m, moved_pis, reset_pis):
        r"""apply_generic_moved(TripletContainer self, TripletModifier m, IMP::ParticleIndexes const & moved_pis, IMP::ParticleIndexes const & reset_pis)"""
        return _IMP_kernel.TripletContainer_apply_generic_moved(self, m, moved_pis, reset_pis)

    def apply(self, sm):
        r"""apply(TripletContainer self, TripletModifier sm)"""
        return _IMP_kernel.TripletContainer_apply(self, sm)

    def apply_moved(self, sm, moved_pis, reset_pis):
        r"""apply_moved(TripletContainer self, TripletModifier sm, IMP::ParticleIndexes const & moved_pis, IMP::ParticleIndexes const & reset_pis)"""
        return _IMP_kernel.TripletContainer_apply_moved(self, sm, moved_pis, reset_pis)

    def get_range_indexes(self):
        r"""get_range_indexes(TripletContainer self) -> IMP::ParticleIndexTriplets"""
        return _IMP_kernel.TripletContainer_get_range_indexes(self)

    def get_contents(self):
        r"""get_contents(TripletContainer self) -> IMP::ParticleIndexTriplets const &"""
        return _IMP_kernel.TripletContainer_get_contents(self)

    def get_indexes(self):
        r"""get_indexes(TripletContainer self) -> IMP::ParticleIndexTriplets"""
        return _IMP_kernel.TripletContainer_get_indexes(self)

    def get(self, *args):
        r"""
        get(TripletContainer self) -> IMP::ParticleTripletsTemp
        get(TripletContainer self, unsigned int i) -> IMP::ParticleTriplet
        """
        return _IMP_kernel.TripletContainer_get(self, *args)

    def get_number(self):
        r"""get_number(TripletContainer self) -> unsigned int"""
        return _IMP_kernel.TripletContainer_get_number(self)

    def __init__(self, *args):
        r"""__init__(TripletContainer self, Model m, std::string name="TripletContainer %1%") -> TripletContainer"""
        if self.__class__ == TripletContainer:
            _self = None
        else:
            _self = self
        _IMP_kernel.TripletContainer_swiginit(self, _IMP_kernel.new_TripletContainer(_self, *args))

        if self.__class__ != TripletContainer:
            _director_objects.register(self)




    def do_apply(self, sm):
        r"""do_apply(TripletContainer self, TripletModifier sm)"""
        return _IMP_kernel.TripletContainer_do_apply(self, sm)

    def do_apply_moved(self, sm, moved_pis, reset_pis):
        r"""do_apply_moved(TripletContainer self, TripletModifier sm, IMP::ParticleIndexes const & moved_pis, IMP::ParticleIndexes const & reset_pis)"""
        return _IMP_kernel.TripletContainer_do_apply_moved(self, sm, moved_pis, reset_pis)

    def do_get_provides_access(self):
        r"""do_get_provides_access(TripletContainer self) -> bool"""
        return _IMP_kernel.TripletContainer_do_get_provides_access(self)
    __swig_destroy__ = _IMP_kernel.delete_TripletContainer

    def __str__(self):
        r"""__str__(TripletContainer self) -> std::string"""
        return _IMP_kernel.TripletContainer___str__(self)

    def __repr__(self):
        r"""__repr__(TripletContainer self) -> std::string"""
        return _IMP_kernel.TripletContainer___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_TripletContainer(o)


    def get_type_name(self):
        return self.__class__.__name__
    def do_show(self, out):
        pass
    def get_version_info(self):
        if"IMP" == "IMP":
          return VersionInfo(self.__module__,
                             __import__(self.__module__).get_module_version())
        else:
          return IMP.VersionInfo(self.__module__,
                             __import__(self.__module__).get_module_version())
    @staticmethod
    def get_from(o):
       return _object_cast_to_TripletContainer(o)

    def __disown__(self):
        self.this.disown()
        _IMP_kernel.disown_TripletContainer(self)
        return weakref.proxy(self)

    def do_destroy(self):
        r"""do_destroy(TripletContainer self)"""
        return _IMP_kernel.TripletContainer_do_destroy(self)

    def handle_set_has_required_score_states(self, arg0):
        r"""handle_set_has_required_score_states(TripletContainer self, bool arg0)"""
        return _IMP_kernel.TripletContainer_handle_set_has_required_score_states(self, arg0)

    def do_get_inputs(self):
        r"""do_get_inputs(TripletContainer self) -> IMP::ModelObjectsTemp"""
        return _IMP_kernel.TripletContainer_do_get_inputs(self)

    def do_get_interactions(self):
        r"""do_get_interactions(TripletContainer self) -> IMP::ModelObjectsTemps"""
        return _IMP_kernel.TripletContainer_do_get_interactions(self)

    def do_get_contents_hash(self):
        r"""do_get_contents_hash(TripletContainer self) -> std::size_t"""
        return _IMP_kernel.TripletContainer_do_get_contents_hash(self)

# Register TripletContainer in _IMP_kernel:
_IMP_kernel.TripletContainer_swigregister(TripletContainer)

class _TripletContainerAdaptor(_InputAdaptor):
    r"""Proxy of C++ IMP::TripletContainerAdaptor class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(_TripletContainerAdaptor self) -> _TripletContainerAdaptor
        __init__(_TripletContainerAdaptor self, TripletContainer c) -> _TripletContainerAdaptor
        __init__(_TripletContainerAdaptor self, IMP::ParticleTripletsTemp const & t) -> _TripletContainerAdaptor
        """
        _IMP_kernel._TripletContainerAdaptor_swiginit(self, _IMP_kernel.new__TripletContainerAdaptor(*args))

    def set_name_if_default(self, name):
        r"""set_name_if_default(_TripletContainerAdaptor self, std::string name)"""
        return _IMP_kernel._TripletContainerAdaptor_set_name_if_default(self, name)
    __swig_destroy__ = _IMP_kernel.delete__TripletContainerAdaptor

# Register _TripletContainerAdaptor in _IMP_kernel:
_IMP_kernel._TripletContainerAdaptor_swigregister(_TripletContainerAdaptor)


def write_particles_to_buffer(particles, keys):
    r"""write_particles_to_buffer(IMP::ParticlesTemp const & particles, IMP::FloatKeys const & keys) -> IMP::Vector< char >"""
    return _IMP_kernel.write_particles_to_buffer(particles, keys)

def read_particles_from_buffer(buffer, particles, keys):
    r"""read_particles_from_buffer(IMP::Vector< char > const & buffer, IMP::ParticlesTemp const & particles, IMP::FloatKeys const & keys)"""
    return _IMP_kernel.read_particles_from_buffer(buffer, particles, keys)

def get_particles(m, ps):
    r"""get_particles(Model m, IMP::ParticleIndexes const & ps) -> IMP::ParticlesTemp"""
    return _IMP_kernel.get_particles(m, ps)

def get_indexes(*args):
    r"""
    get_indexes(IMP::ParticlesTemp const & ps) -> IMP::ParticleIndexes
    get_indexes(IMP::ParticlePairsTemp const & ps) -> IMP::ParticleIndexPairs
    """
    return _IMP_kernel.get_indexes(*args)
class _ParticleIndexAdaptor(object):
    r"""Proxy of C++ IMP::ParticleIndexAdaptor class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(_ParticleIndexAdaptor self, Particle p) -> _ParticleIndexAdaptor
        __init__(_ParticleIndexAdaptor self, ParticleIndex pi) -> _ParticleIndexAdaptor
        __init__(_ParticleIndexAdaptor self, Decorator d) -> _ParticleIndexAdaptor
        """
        _IMP_kernel._ParticleIndexAdaptor_swiginit(self, _IMP_kernel.new__ParticleIndexAdaptor(*args))
    __swig_destroy__ = _IMP_kernel.delete__ParticleIndexAdaptor

# Register _ParticleIndexAdaptor in _IMP_kernel:
_IMP_kernel._ParticleIndexAdaptor_swigregister(_ParticleIndexAdaptor)

class _ParticleIndexesAdaptor(_InputAdaptor):
    r"""Proxy of C++ IMP::ParticleIndexesAdaptor class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(_ParticleIndexesAdaptor self, IMP::ParticlesTemp const & ps) -> _ParticleIndexesAdaptor
        __init__(_ParticleIndexesAdaptor self, IMP::ParticleIndexes const & pi) -> _ParticleIndexesAdaptor
        __init__(_ParticleIndexesAdaptor self) -> _ParticleIndexesAdaptor
        """
        _IMP_kernel._ParticleIndexesAdaptor_swiginit(self, _IMP_kernel.new__ParticleIndexesAdaptor(*args))
    __swig_destroy__ = _IMP_kernel.delete__ParticleIndexesAdaptor

# Register _ParticleIndexesAdaptor in _IMP_kernel:
_IMP_kernel._ParticleIndexesAdaptor_swigregister(_ParticleIndexesAdaptor)

class _ParticleIndexPairsAdaptor(object):
    r"""Proxy of C++ IMP::ParticleIndexPairsAdaptor class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(_ParticleIndexPairsAdaptor self, IMP::ParticlePairsTemp const & ps) -> _ParticleIndexPairsAdaptor
        __init__(_ParticleIndexPairsAdaptor self, IMP::ParticleIndexPairs const & pi) -> _ParticleIndexPairsAdaptor
        __init__(_ParticleIndexPairsAdaptor self) -> _ParticleIndexPairsAdaptor
        """
        _IMP_kernel._ParticleIndexPairsAdaptor_swiginit(self, _IMP_kernel.new__ParticleIndexPairsAdaptor(*args))
    __swig_destroy__ = _IMP_kernel.delete__ParticleIndexPairsAdaptor

# Register _ParticleIndexPairsAdaptor in _IMP_kernel:
_IMP_kernel._ParticleIndexPairsAdaptor_swigregister(_ParticleIndexPairsAdaptor)

class _ConstRestraint(Restraint):
    r"""Proxy of C++ IMP::internal::_ConstRestraint class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(_ConstRestraint self, double v, IMP::ParticlesTemp const ps) -> _ConstRestraint
        __init__(_ConstRestraint self, Model m, IMP::ParticleIndexes const & pis, double v) -> _ConstRestraint
        """
        _IMP_kernel._ConstRestraint_swiginit(self, _IMP_kernel.new__ConstRestraint(*args))

    def get_value(self):
        r"""get_value(_ConstRestraint self) -> double"""
        return _IMP_kernel._ConstRestraint_get_value(self)

    def do_create_decomposition(self):
        r"""do_create_decomposition(_ConstRestraint self) -> IMP::Restraints"""
        return _IMP_kernel._ConstRestraint_do_create_decomposition(self)

    def do_get_inputs(self):
        r"""do_get_inputs(_ConstRestraint self) -> IMP::ModelObjectsTemp"""
        return _IMP_kernel._ConstRestraint_do_get_inputs(self)

    def get_version_info(self):
        r"""get_version_info(_ConstRestraint self) -> VersionInfo"""
        return _IMP_kernel._ConstRestraint_get_version_info(self)

    def __str__(self):
        r"""__str__(_ConstRestraint self) -> std::string"""
        return _IMP_kernel._ConstRestraint___str__(self)

    def __repr__(self):
        r"""__repr__(_ConstRestraint self) -> std::string"""
        return _IMP_kernel._ConstRestraint___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to__ConstRestraint(o)


# Register _ConstRestraint in _IMP_kernel:
_IMP_kernel._ConstRestraint_swigregister(_ConstRestraint)

class _ConstSingletonScore(SingletonScore):
    r"""Proxy of C++ IMP::internal::_ConstSingletonScore class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, v):
        r"""__init__(_ConstSingletonScore self, double v) -> _ConstSingletonScore"""
        _IMP_kernel._ConstSingletonScore_swiginit(self, _IMP_kernel.new__ConstSingletonScore(v))

    def do_get_inputs(self, arg2, arg3):
        r"""do_get_inputs(_ConstSingletonScore self, Model arg2, IMP::ParticleIndexes const & arg3) -> IMP::ModelObjectsTemp"""
        return _IMP_kernel._ConstSingletonScore_do_get_inputs(self, arg2, arg3)

    def get_version_info(self):
        r"""get_version_info(_ConstSingletonScore self) -> VersionInfo"""
        return _IMP_kernel._ConstSingletonScore_get_version_info(self)

# Register _ConstSingletonScore in _IMP_kernel:
_IMP_kernel._ConstSingletonScore_swigregister(_ConstSingletonScore)

class _ConstPairScore(PairScore):
    r"""Proxy of C++ IMP::internal::_ConstPairScore class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, v):
        r"""__init__(_ConstPairScore self, double v) -> _ConstPairScore"""
        _IMP_kernel._ConstPairScore_swiginit(self, _IMP_kernel.new__ConstPairScore(v))

    def do_get_inputs(self, arg2, arg3):
        r"""do_get_inputs(_ConstPairScore self, Model arg2, IMP::ParticleIndexes const & arg3) -> IMP::ModelObjectsTemp"""
        return _IMP_kernel._ConstPairScore_do_get_inputs(self, arg2, arg3)

    def get_version_info(self):
        r"""get_version_info(_ConstPairScore self) -> VersionInfo"""
        return _IMP_kernel._ConstPairScore_get_version_info(self)

# Register _ConstPairScore in _IMP_kernel:
_IMP_kernel._ConstPairScore_swigregister(_ConstPairScore)

class _TrivialDecorator(Decorator):
    r"""Proxy of C++ IMP::internal::_TrivialDecorator class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(_TrivialDecorator self) -> _TrivialDecorator
        __init__(_TrivialDecorator self, Model m, ParticleIndex id) -> _TrivialDecorator
        __init__(_TrivialDecorator self, _ParticleAdaptor d) -> _TrivialDecorator
        """
        _IMP_kernel._TrivialDecorator_swiginit(self, _IMP_kernel.new__TrivialDecorator(*args))

    def show(self, *args):
        r"""show(_TrivialDecorator self, _ostream out=std::cout)"""
        return _IMP_kernel._TrivialDecorator_show(self, *args)

    @staticmethod
    def setup_particle(*args):
        r"""
        setup_particle(Model m, ParticleIndex pi) -> _TrivialDecorator
        setup_particle(_ParticleAdaptor decorator) -> _TrivialDecorator
        """
        return _IMP_kernel._TrivialDecorator_setup_particle(*args)

    @staticmethod
    def get_is_setup(*args):
        r"""
        get_is_setup(_ParticleAdaptor p) -> bool
        get_is_setup(Model m, ParticleIndex pi) -> bool
        """
        return _IMP_kernel._TrivialDecorator_get_is_setup(*args)

    def add_attribute(self, *args):
        r"""
        add_attribute(_TrivialDecorator self, FloatKey k, IMP::Float v, bool opt)
        add_attribute(_TrivialDecorator self, FloatKey a0, IMP::Float a1)
        add_attribute(_TrivialDecorator self, IntKey a0, IMP::Int a1)
        add_attribute(_TrivialDecorator self, FloatsKey a0, IMP::Floats a1)
        add_attribute(_TrivialDecorator self, IntsKey a0, IMP::Ints a1)
        add_attribute(_TrivialDecorator self, StringKey a0, IMP::String a1)
        add_attribute(_TrivialDecorator self, ParticleIndexKey a0, Particle a1)
        add_attribute(_TrivialDecorator self, ObjectKey a0, Object a1)
        """
        return _IMP_kernel._TrivialDecorator_add_attribute(self, *args)

    def get_value(self, *args):
        r"""
        get_value(_TrivialDecorator self, FloatKey a0) -> IMP::Float
        get_value(_TrivialDecorator self, IntKey a0) -> IMP::Int
        get_value(_TrivialDecorator self, FloatsKey a0) -> IMP::Floats
        get_value(_TrivialDecorator self, IntsKey a0) -> IMP::Ints
        get_value(_TrivialDecorator self, StringKey a0) -> IMP::String
        get_value(_TrivialDecorator self, ParticleIndexKey a0) -> Particle
        get_value(_TrivialDecorator self, ObjectKey a0) -> Object
        """
        return _IMP_kernel._TrivialDecorator_get_value(self, *args)

    def set_value(self, *args):
        r"""
        set_value(_TrivialDecorator self, FloatKey a0, IMP::Float a1)
        set_value(_TrivialDecorator self, IntKey a0, IMP::Int a1)
        set_value(_TrivialDecorator self, FloatsKey a0, IMP::Floats a1)
        set_value(_TrivialDecorator self, IntsKey a0, IMP::Ints a1)
        set_value(_TrivialDecorator self, StringKey a0, IMP::String a1)
        set_value(_TrivialDecorator self, ParticleIndexKey a0, Particle a1)
        set_value(_TrivialDecorator self, ObjectKey a0, Object a1)
        """
        return _IMP_kernel._TrivialDecorator_set_value(self, *args)

    def remove_attribute(self, *args):
        r"""
        remove_attribute(_TrivialDecorator self, FloatKey a0)
        remove_attribute(_TrivialDecorator self, IntKey a0)
        remove_attribute(_TrivialDecorator self, FloatsKey a0)
        remove_attribute(_TrivialDecorator self, IntsKey a0)
        remove_attribute(_TrivialDecorator self, StringKey a0)
        remove_attribute(_TrivialDecorator self, ParticleIndexKey a0)
        remove_attribute(_TrivialDecorator self, ObjectKey a0)
        """
        return _IMP_kernel._TrivialDecorator_remove_attribute(self, *args)

    def has_attribute(self, *args):
        r"""
        has_attribute(_TrivialDecorator self, FloatKey a0) -> bool
        has_attribute(_TrivialDecorator self, IntKey a0) -> bool
        has_attribute(_TrivialDecorator self, FloatsKey a0) -> bool
        has_attribute(_TrivialDecorator self, IntsKey a0) -> bool
        has_attribute(_TrivialDecorator self, StringKey a0) -> bool
        has_attribute(_TrivialDecorator self, ParticleIndexKey a0) -> bool
        has_attribute(_TrivialDecorator self, ObjectKey a0) -> bool
        """
        return _IMP_kernel._TrivialDecorator_has_attribute(self, *args)

    def get_derivative(self, a0):
        r"""get_derivative(_TrivialDecorator self, FloatKey a0) -> double"""
        return _IMP_kernel._TrivialDecorator_get_derivative(self, a0)

    def get_name(self):
        r"""get_name(_TrivialDecorator self) -> std::string"""
        return _IMP_kernel._TrivialDecorator_get_name(self)

    def clear_caches(self):
        r"""clear_caches(_TrivialDecorator self)"""
        return _IMP_kernel._TrivialDecorator_clear_caches(self)

    def set_name(self, a0):
        r"""set_name(_TrivialDecorator self, std::string a0)"""
        return _IMP_kernel._TrivialDecorator_set_name(self, a0)

    def set_check_level(self, a0):
        r"""set_check_level(_TrivialDecorator self, IMP::CheckLevel a0)"""
        return _IMP_kernel._TrivialDecorator_set_check_level(self, a0)

    def add_to_derivative(self, a0, a1, a2):
        r"""add_to_derivative(_TrivialDecorator self, FloatKey a0, double a1, DerivativeAccumulator a2)"""
        return _IMP_kernel._TrivialDecorator_add_to_derivative(self, a0, a1, a2)

    def set_is_optimized(self, a0, a1):
        r"""set_is_optimized(_TrivialDecorator self, FloatKey a0, bool a1)"""
        return _IMP_kernel._TrivialDecorator_set_is_optimized(self, a0, a1)

    def get_is_optimized(self, a0):
        r"""get_is_optimized(_TrivialDecorator self, FloatKey a0) -> bool"""
        return _IMP_kernel._TrivialDecorator_get_is_optimized(self, a0)

    def get_check_level(self):
        r"""get_check_level(_TrivialDecorator self) -> IMP::CheckLevel"""
        return _IMP_kernel._TrivialDecorator_get_check_level(self)

    def __eq__(self, *args):
        r"""
        __eq__(_TrivialDecorator self, _TrivialDecorator o) -> bool
        __eq__(_TrivialDecorator self, Particle d) -> bool
        """
        return _IMP_kernel._TrivialDecorator___eq__(self, *args)

    def __ne__(self, *args):
        r"""
        __ne__(_TrivialDecorator self, _TrivialDecorator o) -> bool
        __ne__(_TrivialDecorator self, Particle d) -> bool
        """
        return _IMP_kernel._TrivialDecorator___ne__(self, *args)

    def __le__(self, *args):
        r"""
        __le__(_TrivialDecorator self, _TrivialDecorator o) -> bool
        __le__(_TrivialDecorator self, Particle d) -> bool
        """
        return _IMP_kernel._TrivialDecorator___le__(self, *args)

    def __lt__(self, *args):
        r"""
        __lt__(_TrivialDecorator self, _TrivialDecorator o) -> bool
        __lt__(_TrivialDecorator self, Particle d) -> bool
        """
        return _IMP_kernel._TrivialDecorator___lt__(self, *args)

    def __ge__(self, *args):
        r"""
        __ge__(_TrivialDecorator self, _TrivialDecorator o) -> bool
        __ge__(_TrivialDecorator self, Particle d) -> bool
        """
        return _IMP_kernel._TrivialDecorator___ge__(self, *args)

    def __gt__(self, *args):
        r"""
        __gt__(_TrivialDecorator self, _TrivialDecorator o) -> bool
        __gt__(_TrivialDecorator self, Particle d) -> bool
        """
        return _IMP_kernel._TrivialDecorator___gt__(self, *args)

    def __hash__(self):
        r"""__hash__(_TrivialDecorator self) -> std::size_t"""
        return _IMP_kernel._TrivialDecorator___hash__(self)

    def __str__(self):
        r"""__str__(_TrivialDecorator self) -> std::string"""
        return _IMP_kernel._TrivialDecorator___str__(self)

    def __repr__(self):
        r"""__repr__(_TrivialDecorator self) -> std::string"""
        return _IMP_kernel._TrivialDecorator___repr__(self)
    __swig_destroy__ = _IMP_kernel.delete__TrivialDecorator

# Register _TrivialDecorator in _IMP_kernel:
_IMP_kernel._TrivialDecorator_swigregister(_TrivialDecorator)

def _TrivialDecorator_setup_particle(*args):
    r"""
    _TrivialDecorator_setup_particle(Model m, ParticleIndex pi) -> _TrivialDecorator
    _TrivialDecorator_setup_particle(_ParticleAdaptor decorator) -> _TrivialDecorator
    """
    return _IMP_kernel._TrivialDecorator_setup_particle(*args)

def _TrivialDecorator_get_is_setup(*args):
    r"""
    _TrivialDecorator_get_is_setup(_ParticleAdaptor p) -> bool
    _TrivialDecorator_get_is_setup(Model m, ParticleIndex pi) -> bool
    """
    return _IMP_kernel._TrivialDecorator_get_is_setup(*args)

class _TrivialDerivedDecorator(_TrivialDecorator):
    r"""Proxy of C++ IMP::internal::_TrivialDerivedDecorator class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(_TrivialDerivedDecorator self) -> _TrivialDerivedDecorator
        __init__(_TrivialDerivedDecorator self, Model m, ParticleIndex id) -> _TrivialDerivedDecorator
        __init__(_TrivialDerivedDecorator self, _ParticleAdaptor d) -> _TrivialDerivedDecorator
        """
        _IMP_kernel._TrivialDerivedDecorator_swiginit(self, _IMP_kernel.new__TrivialDerivedDecorator(*args))

    def show(self, *args):
        r"""show(_TrivialDerivedDecorator self, _ostream out=std::cout)"""
        return _IMP_kernel._TrivialDerivedDecorator_show(self, *args)

    @staticmethod
    def setup_particle(*args):
        r"""
        setup_particle(Model m, ParticleIndex pi) -> _TrivialDerivedDecorator
        setup_particle(_ParticleAdaptor decorator) -> _TrivialDerivedDecorator
        """
        return _IMP_kernel._TrivialDerivedDecorator_setup_particle(*args)

    @staticmethod
    def get_is_setup(*args):
        r"""
        get_is_setup(_ParticleAdaptor p) -> bool
        get_is_setup(Model m, ParticleIndex pi) -> bool
        """
        return _IMP_kernel._TrivialDerivedDecorator_get_is_setup(*args)

    def add_attribute(self, *args):
        r"""
        add_attribute(_TrivialDerivedDecorator self, FloatKey k, IMP::Float v, bool opt)
        add_attribute(_TrivialDerivedDecorator self, FloatKey a0, IMP::Float a1)
        add_attribute(_TrivialDerivedDecorator self, IntKey a0, IMP::Int a1)
        add_attribute(_TrivialDerivedDecorator self, FloatsKey a0, IMP::Floats a1)
        add_attribute(_TrivialDerivedDecorator self, IntsKey a0, IMP::Ints a1)
        add_attribute(_TrivialDerivedDecorator self, StringKey a0, IMP::String a1)
        add_attribute(_TrivialDerivedDecorator self, ParticleIndexKey a0, Particle a1)
        add_attribute(_TrivialDerivedDecorator self, ObjectKey a0, Object a1)
        """
        return _IMP_kernel._TrivialDerivedDecorator_add_attribute(self, *args)

    def get_value(self, *args):
        r"""
        get_value(_TrivialDerivedDecorator self, FloatKey a0) -> IMP::Float
        get_value(_TrivialDerivedDecorator self, IntKey a0) -> IMP::Int
        get_value(_TrivialDerivedDecorator self, FloatsKey a0) -> IMP::Floats
        get_value(_TrivialDerivedDecorator self, IntsKey a0) -> IMP::Ints
        get_value(_TrivialDerivedDecorator self, StringKey a0) -> IMP::String
        get_value(_TrivialDerivedDecorator self, ParticleIndexKey a0) -> Particle
        get_value(_TrivialDerivedDecorator self, ObjectKey a0) -> Object
        """
        return _IMP_kernel._TrivialDerivedDecorator_get_value(self, *args)

    def set_value(self, *args):
        r"""
        set_value(_TrivialDerivedDecorator self, FloatKey a0, IMP::Float a1)
        set_value(_TrivialDerivedDecorator self, IntKey a0, IMP::Int a1)
        set_value(_TrivialDerivedDecorator self, FloatsKey a0, IMP::Floats a1)
        set_value(_TrivialDerivedDecorator self, IntsKey a0, IMP::Ints a1)
        set_value(_TrivialDerivedDecorator self, StringKey a0, IMP::String a1)
        set_value(_TrivialDerivedDecorator self, ParticleIndexKey a0, Particle a1)
        set_value(_TrivialDerivedDecorator self, ObjectKey a0, Object a1)
        """
        return _IMP_kernel._TrivialDerivedDecorator_set_value(self, *args)

    def remove_attribute(self, *args):
        r"""
        remove_attribute(_TrivialDerivedDecorator self, FloatKey a0)
        remove_attribute(_TrivialDerivedDecorator self, IntKey a0)
        remove_attribute(_TrivialDerivedDecorator self, FloatsKey a0)
        remove_attribute(_TrivialDerivedDecorator self, IntsKey a0)
        remove_attribute(_TrivialDerivedDecorator self, StringKey a0)
        remove_attribute(_TrivialDerivedDecorator self, ParticleIndexKey a0)
        remove_attribute(_TrivialDerivedDecorator self, ObjectKey a0)
        """
        return _IMP_kernel._TrivialDerivedDecorator_remove_attribute(self, *args)

    def has_attribute(self, *args):
        r"""
        has_attribute(_TrivialDerivedDecorator self, FloatKey a0) -> bool
        has_attribute(_TrivialDerivedDecorator self, IntKey a0) -> bool
        has_attribute(_TrivialDerivedDecorator self, FloatsKey a0) -> bool
        has_attribute(_TrivialDerivedDecorator self, IntsKey a0) -> bool
        has_attribute(_TrivialDerivedDecorator self, StringKey a0) -> bool
        has_attribute(_TrivialDerivedDecorator self, ParticleIndexKey a0) -> bool
        has_attribute(_TrivialDerivedDecorator self, ObjectKey a0) -> bool
        """
        return _IMP_kernel._TrivialDerivedDecorator_has_attribute(self, *args)

    def get_derivative(self, a0):
        r"""get_derivative(_TrivialDerivedDecorator self, FloatKey a0) -> double"""
        return _IMP_kernel._TrivialDerivedDecorator_get_derivative(self, a0)

    def get_name(self):
        r"""get_name(_TrivialDerivedDecorator self) -> std::string"""
        return _IMP_kernel._TrivialDerivedDecorator_get_name(self)

    def clear_caches(self):
        r"""clear_caches(_TrivialDerivedDecorator self)"""
        return _IMP_kernel._TrivialDerivedDecorator_clear_caches(self)

    def set_name(self, a0):
        r"""set_name(_TrivialDerivedDecorator self, std::string a0)"""
        return _IMP_kernel._TrivialDerivedDecorator_set_name(self, a0)

    def set_check_level(self, a0):
        r"""set_check_level(_TrivialDerivedDecorator self, IMP::CheckLevel a0)"""
        return _IMP_kernel._TrivialDerivedDecorator_set_check_level(self, a0)

    def add_to_derivative(self, a0, a1, a2):
        r"""add_to_derivative(_TrivialDerivedDecorator self, FloatKey a0, double a1, DerivativeAccumulator a2)"""
        return _IMP_kernel._TrivialDerivedDecorator_add_to_derivative(self, a0, a1, a2)

    def set_is_optimized(self, a0, a1):
        r"""set_is_optimized(_TrivialDerivedDecorator self, FloatKey a0, bool a1)"""
        return _IMP_kernel._TrivialDerivedDecorator_set_is_optimized(self, a0, a1)

    def get_is_optimized(self, a0):
        r"""get_is_optimized(_TrivialDerivedDecorator self, FloatKey a0) -> bool"""
        return _IMP_kernel._TrivialDerivedDecorator_get_is_optimized(self, a0)

    def get_check_level(self):
        r"""get_check_level(_TrivialDerivedDecorator self) -> IMP::CheckLevel"""
        return _IMP_kernel._TrivialDerivedDecorator_get_check_level(self)

    def __eq__(self, *args):
        r"""
        __eq__(_TrivialDerivedDecorator self, _TrivialDerivedDecorator o) -> bool
        __eq__(_TrivialDerivedDecorator self, Particle d) -> bool
        """
        return _IMP_kernel._TrivialDerivedDecorator___eq__(self, *args)

    def __ne__(self, *args):
        r"""
        __ne__(_TrivialDerivedDecorator self, _TrivialDerivedDecorator o) -> bool
        __ne__(_TrivialDerivedDecorator self, Particle d) -> bool
        """
        return _IMP_kernel._TrivialDerivedDecorator___ne__(self, *args)

    def __le__(self, *args):
        r"""
        __le__(_TrivialDerivedDecorator self, _TrivialDerivedDecorator o) -> bool
        __le__(_TrivialDerivedDecorator self, Particle d) -> bool
        """
        return _IMP_kernel._TrivialDerivedDecorator___le__(self, *args)

    def __lt__(self, *args):
        r"""
        __lt__(_TrivialDerivedDecorator self, _TrivialDerivedDecorator o) -> bool
        __lt__(_TrivialDerivedDecorator self, Particle d) -> bool
        """
        return _IMP_kernel._TrivialDerivedDecorator___lt__(self, *args)

    def __ge__(self, *args):
        r"""
        __ge__(_TrivialDerivedDecorator self, _TrivialDerivedDecorator o) -> bool
        __ge__(_TrivialDerivedDecorator self, Particle d) -> bool
        """
        return _IMP_kernel._TrivialDerivedDecorator___ge__(self, *args)

    def __gt__(self, *args):
        r"""
        __gt__(_TrivialDerivedDecorator self, _TrivialDerivedDecorator o) -> bool
        __gt__(_TrivialDerivedDecorator self, Particle d) -> bool
        """
        return _IMP_kernel._TrivialDerivedDecorator___gt__(self, *args)

    def __hash__(self):
        r"""__hash__(_TrivialDerivedDecorator self) -> std::size_t"""
        return _IMP_kernel._TrivialDerivedDecorator___hash__(self)

    def __str__(self):
        r"""__str__(_TrivialDerivedDecorator self) -> std::string"""
        return _IMP_kernel._TrivialDerivedDecorator___str__(self)

    def __repr__(self):
        r"""__repr__(_TrivialDerivedDecorator self) -> std::string"""
        return _IMP_kernel._TrivialDerivedDecorator___repr__(self)
    __swig_destroy__ = _IMP_kernel.delete__TrivialDerivedDecorator

# Register _TrivialDerivedDecorator in _IMP_kernel:
_IMP_kernel._TrivialDerivedDecorator_swigregister(_TrivialDerivedDecorator)

def _TrivialDerivedDecorator_setup_particle(*args):
    r"""
    _TrivialDerivedDecorator_setup_particle(Model m, ParticleIndex pi) -> _TrivialDerivedDecorator
    _TrivialDerivedDecorator_setup_particle(_ParticleAdaptor decorator) -> _TrivialDerivedDecorator
    """
    return _IMP_kernel._TrivialDerivedDecorator_setup_particle(*args)

def _TrivialDerivedDecorator_get_is_setup(*args):
    r"""
    _TrivialDerivedDecorator_get_is_setup(_ParticleAdaptor p) -> bool
    _TrivialDerivedDecorator_get_is_setup(Model m, ParticleIndex pi) -> bool
    """
    return _IMP_kernel._TrivialDerivedDecorator_get_is_setup(*args)

class _TrivialTraitsDecorator(Decorator):
    r"""Proxy of C++ IMP::internal::_TrivialTraitsDecorator class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def get_decorator_traits(self):
        r"""get_decorator_traits(_TrivialTraitsDecorator self) -> StringKey"""
        return _IMP_kernel._TrivialTraitsDecorator_get_decorator_traits(self)

    @staticmethod
    def get_default_decorator_traits():
        r"""get_default_decorator_traits() -> StringKey"""
        return _IMP_kernel._TrivialTraitsDecorator_get_default_decorator_traits()

    def __init__(self, *args):
        r"""
        __init__(_TrivialTraitsDecorator self) -> _TrivialTraitsDecorator
        __init__(_TrivialTraitsDecorator self, Model m, ParticleIndex id, StringKey tr=get_default_key()) -> _TrivialTraitsDecorator
        __init__(_TrivialTraitsDecorator self, _ParticleAdaptor d, StringKey tr=get_default_key()) -> _TrivialTraitsDecorator
        """
        _IMP_kernel._TrivialTraitsDecorator_swiginit(self, _IMP_kernel.new__TrivialTraitsDecorator(*args))

    def show(self, *args):
        r"""show(_TrivialTraitsDecorator self, _ostream out=std::cout)"""
        return _IMP_kernel._TrivialTraitsDecorator_show(self, *args)

    @staticmethod
    def setup_particle(*args):
        r"""
        setup_particle(Model m, ParticleIndex pi, StringKey tr=IMP::internal::_TrivialTraitsDecorator::get_default_decorator_traits()) -> _TrivialTraitsDecorator
        setup_particle(_ParticleAdaptor d, StringKey tr=IMP::internal::_TrivialTraitsDecorator::get_default_decorator_traits()) -> _TrivialTraitsDecorator
        """
        return _IMP_kernel._TrivialTraitsDecorator_setup_particle(*args)

    @staticmethod
    def get_is_setup(*args):
        r"""
        get_is_setup(_ParticleAdaptor p, StringKey tr=get_default_key()) -> bool
        get_is_setup(Model m, ParticleIndex pi, StringKey k=get_default_key()) -> bool
        """
        return _IMP_kernel._TrivialTraitsDecorator_get_is_setup(*args)

    @staticmethod
    def get_default_key():
        r"""get_default_key() -> StringKey"""
        return _IMP_kernel._TrivialTraitsDecorator_get_default_key()

    def add_attribute(self, *args):
        r"""
        add_attribute(_TrivialTraitsDecorator self, FloatKey k, IMP::Float v, bool opt)
        add_attribute(_TrivialTraitsDecorator self, FloatKey a0, IMP::Float a1)
        add_attribute(_TrivialTraitsDecorator self, IntKey a0, IMP::Int a1)
        add_attribute(_TrivialTraitsDecorator self, FloatsKey a0, IMP::Floats a1)
        add_attribute(_TrivialTraitsDecorator self, IntsKey a0, IMP::Ints a1)
        add_attribute(_TrivialTraitsDecorator self, StringKey a0, IMP::String a1)
        add_attribute(_TrivialTraitsDecorator self, ParticleIndexKey a0, Particle a1)
        add_attribute(_TrivialTraitsDecorator self, ObjectKey a0, Object a1)
        """
        return _IMP_kernel._TrivialTraitsDecorator_add_attribute(self, *args)

    def get_value(self, *args):
        r"""
        get_value(_TrivialTraitsDecorator self, FloatKey a0) -> IMP::Float
        get_value(_TrivialTraitsDecorator self, IntKey a0) -> IMP::Int
        get_value(_TrivialTraitsDecorator self, FloatsKey a0) -> IMP::Floats
        get_value(_TrivialTraitsDecorator self, IntsKey a0) -> IMP::Ints
        get_value(_TrivialTraitsDecorator self, StringKey a0) -> IMP::String
        get_value(_TrivialTraitsDecorator self, ParticleIndexKey a0) -> Particle
        get_value(_TrivialTraitsDecorator self, ObjectKey a0) -> Object
        """
        return _IMP_kernel._TrivialTraitsDecorator_get_value(self, *args)

    def set_value(self, *args):
        r"""
        set_value(_TrivialTraitsDecorator self, FloatKey a0, IMP::Float a1)
        set_value(_TrivialTraitsDecorator self, IntKey a0, IMP::Int a1)
        set_value(_TrivialTraitsDecorator self, FloatsKey a0, IMP::Floats a1)
        set_value(_TrivialTraitsDecorator self, IntsKey a0, IMP::Ints a1)
        set_value(_TrivialTraitsDecorator self, StringKey a0, IMP::String a1)
        set_value(_TrivialTraitsDecorator self, ParticleIndexKey a0, Particle a1)
        set_value(_TrivialTraitsDecorator self, ObjectKey a0, Object a1)
        """
        return _IMP_kernel._TrivialTraitsDecorator_set_value(self, *args)

    def remove_attribute(self, *args):
        r"""
        remove_attribute(_TrivialTraitsDecorator self, FloatKey a0)
        remove_attribute(_TrivialTraitsDecorator self, IntKey a0)
        remove_attribute(_TrivialTraitsDecorator self, FloatsKey a0)
        remove_attribute(_TrivialTraitsDecorator self, IntsKey a0)
        remove_attribute(_TrivialTraitsDecorator self, StringKey a0)
        remove_attribute(_TrivialTraitsDecorator self, ParticleIndexKey a0)
        remove_attribute(_TrivialTraitsDecorator self, ObjectKey a0)
        """
        return _IMP_kernel._TrivialTraitsDecorator_remove_attribute(self, *args)

    def has_attribute(self, *args):
        r"""
        has_attribute(_TrivialTraitsDecorator self, FloatKey a0) -> bool
        has_attribute(_TrivialTraitsDecorator self, IntKey a0) -> bool
        has_attribute(_TrivialTraitsDecorator self, FloatsKey a0) -> bool
        has_attribute(_TrivialTraitsDecorator self, IntsKey a0) -> bool
        has_attribute(_TrivialTraitsDecorator self, StringKey a0) -> bool
        has_attribute(_TrivialTraitsDecorator self, ParticleIndexKey a0) -> bool
        has_attribute(_TrivialTraitsDecorator self, ObjectKey a0) -> bool
        """
        return _IMP_kernel._TrivialTraitsDecorator_has_attribute(self, *args)

    def get_derivative(self, a0):
        r"""get_derivative(_TrivialTraitsDecorator self, FloatKey a0) -> double"""
        return _IMP_kernel._TrivialTraitsDecorator_get_derivative(self, a0)

    def get_name(self):
        r"""get_name(_TrivialTraitsDecorator self) -> std::string"""
        return _IMP_kernel._TrivialTraitsDecorator_get_name(self)

    def clear_caches(self):
        r"""clear_caches(_TrivialTraitsDecorator self)"""
        return _IMP_kernel._TrivialTraitsDecorator_clear_caches(self)

    def set_name(self, a0):
        r"""set_name(_TrivialTraitsDecorator self, std::string a0)"""
        return _IMP_kernel._TrivialTraitsDecorator_set_name(self, a0)

    def set_check_level(self, a0):
        r"""set_check_level(_TrivialTraitsDecorator self, IMP::CheckLevel a0)"""
        return _IMP_kernel._TrivialTraitsDecorator_set_check_level(self, a0)

    def add_to_derivative(self, a0, a1, a2):
        r"""add_to_derivative(_TrivialTraitsDecorator self, FloatKey a0, double a1, DerivativeAccumulator a2)"""
        return _IMP_kernel._TrivialTraitsDecorator_add_to_derivative(self, a0, a1, a2)

    def set_is_optimized(self, a0, a1):
        r"""set_is_optimized(_TrivialTraitsDecorator self, FloatKey a0, bool a1)"""
        return _IMP_kernel._TrivialTraitsDecorator_set_is_optimized(self, a0, a1)

    def get_is_optimized(self, a0):
        r"""get_is_optimized(_TrivialTraitsDecorator self, FloatKey a0) -> bool"""
        return _IMP_kernel._TrivialTraitsDecorator_get_is_optimized(self, a0)

    def get_check_level(self):
        r"""get_check_level(_TrivialTraitsDecorator self) -> IMP::CheckLevel"""
        return _IMP_kernel._TrivialTraitsDecorator_get_check_level(self)

    def __eq__(self, *args):
        r"""
        __eq__(_TrivialTraitsDecorator self, _TrivialTraitsDecorator o) -> bool
        __eq__(_TrivialTraitsDecorator self, Particle d) -> bool
        """
        return _IMP_kernel._TrivialTraitsDecorator___eq__(self, *args)

    def __ne__(self, *args):
        r"""
        __ne__(_TrivialTraitsDecorator self, _TrivialTraitsDecorator o) -> bool
        __ne__(_TrivialTraitsDecorator self, Particle d) -> bool
        """
        return _IMP_kernel._TrivialTraitsDecorator___ne__(self, *args)

    def __le__(self, *args):
        r"""
        __le__(_TrivialTraitsDecorator self, _TrivialTraitsDecorator o) -> bool
        __le__(_TrivialTraitsDecorator self, Particle d) -> bool
        """
        return _IMP_kernel._TrivialTraitsDecorator___le__(self, *args)

    def __lt__(self, *args):
        r"""
        __lt__(_TrivialTraitsDecorator self, _TrivialTraitsDecorator o) -> bool
        __lt__(_TrivialTraitsDecorator self, Particle d) -> bool
        """
        return _IMP_kernel._TrivialTraitsDecorator___lt__(self, *args)

    def __ge__(self, *args):
        r"""
        __ge__(_TrivialTraitsDecorator self, _TrivialTraitsDecorator o) -> bool
        __ge__(_TrivialTraitsDecorator self, Particle d) -> bool
        """
        return _IMP_kernel._TrivialTraitsDecorator___ge__(self, *args)

    def __gt__(self, *args):
        r"""
        __gt__(_TrivialTraitsDecorator self, _TrivialTraitsDecorator o) -> bool
        __gt__(_TrivialTraitsDecorator self, Particle d) -> bool
        """
        return _IMP_kernel._TrivialTraitsDecorator___gt__(self, *args)

    def __hash__(self):
        r"""__hash__(_TrivialTraitsDecorator self) -> std::size_t"""
        return _IMP_kernel._TrivialTraitsDecorator___hash__(self)

    def __str__(self):
        r"""__str__(_TrivialTraitsDecorator self) -> std::string"""
        return _IMP_kernel._TrivialTraitsDecorator___str__(self)

    def __repr__(self):
        r"""__repr__(_TrivialTraitsDecorator self) -> std::string"""
        return _IMP_kernel._TrivialTraitsDecorator___repr__(self)
    __swig_destroy__ = _IMP_kernel.delete__TrivialTraitsDecorator

# Register _TrivialTraitsDecorator in _IMP_kernel:
_IMP_kernel._TrivialTraitsDecorator_swigregister(_TrivialTraitsDecorator)

def _TrivialTraitsDecorator_get_default_decorator_traits():
    r"""_TrivialTraitsDecorator_get_default_decorator_traits() -> StringKey"""
    return _IMP_kernel._TrivialTraitsDecorator_get_default_decorator_traits()

def _TrivialTraitsDecorator_setup_particle(*args):
    r"""
    _TrivialTraitsDecorator_setup_particle(Model m, ParticleIndex pi, StringKey tr=IMP::internal::_TrivialTraitsDecorator::get_default_decorator_traits()) -> _TrivialTraitsDecorator
    _TrivialTraitsDecorator_setup_particle(_ParticleAdaptor d, StringKey tr=IMP::internal::_TrivialTraitsDecorator::get_default_decorator_traits()) -> _TrivialTraitsDecorator
    """
    return _IMP_kernel._TrivialTraitsDecorator_setup_particle(*args)

def _TrivialTraitsDecorator_get_is_setup(*args):
    r"""
    _TrivialTraitsDecorator_get_is_setup(_ParticleAdaptor p, StringKey tr=get_default_key()) -> bool
    _TrivialTraitsDecorator_get_is_setup(Model m, ParticleIndex pi, StringKey k=get_default_key()) -> bool
    """
    return _IMP_kernel._TrivialTraitsDecorator_get_is_setup(*args)

def _TrivialTraitsDecorator_get_default_key():
    r"""_TrivialTraitsDecorator_get_default_key() -> StringKey"""
    return _IMP_kernel._TrivialTraitsDecorator_get_default_key()


def __lshift__(*args):
    r"""
    __lshift__(_ostream out, _TrivialDecorator n) -> _ostream
    __lshift__(_ostream out, _TrivialDerivedDecorator n) -> _ostream
    __lshift__(_ostream out, _TrivialTraitsDecorator n) -> _ostream
    """
    return _IMP_kernel.__lshift__(*args)
class _ConstOptimizer(Optimizer):
    r"""Proxy of C++ IMP::internal::_ConstOptimizer class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, m):
        r"""__init__(_ConstOptimizer self, Model m) -> _ConstOptimizer"""
        _IMP_kernel._ConstOptimizer_swiginit(self, _IMP_kernel.new__ConstOptimizer(m))

    def do_optimize(self, max_steps):
        r"""do_optimize(_ConstOptimizer self, unsigned int max_steps) -> IMP::Float"""
        return _IMP_kernel._ConstOptimizer_do_optimize(self, max_steps)

    def get_version_info(self):
        r"""get_version_info(_ConstOptimizer self) -> VersionInfo"""
        return _IMP_kernel._ConstOptimizer_get_version_info(self)

    def __str__(self):
        r"""__str__(_ConstOptimizer self) -> std::string"""
        return _IMP_kernel._ConstOptimizer___str__(self)

    def __repr__(self):
        r"""__repr__(_ConstOptimizer self) -> std::string"""
        return _IMP_kernel._ConstOptimizer___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to__ConstOptimizer(o)


# Register _ConstOptimizer in _IMP_kernel:
_IMP_kernel._ConstOptimizer_swigregister(_ConstOptimizer)


def get_particle(p):
    r"""get_particle(Particle p) -> Particle"""
    return _IMP_kernel.get_particle(p)

def _decorator_test(p):
    r"""_decorator_test(Particle p)"""
    return _IMP_kernel._decorator_test(p)

def _overloaded_decorator(*args):
    r"""
    _overloaded_decorator(_TrivialDecorator a) -> int
    _overloaded_decorator(_TrivialDerivedDecorator a) -> int
    """
    return _IMP_kernel._overloaded_decorator(*args)

def _take_particles(*args):
    r"""
    _take_particles(IMP::Particles const & ps) -> unsigned int
    _take_particles(Model m, IMP::Particles const & ps) -> unsigned int
    _take_particles(Model m, IMP::Particles const & ps, TextOutput out) -> unsigned int
    """
    return _IMP_kernel._take_particles(*args)

def _give_particles(m):
    r"""_give_particles(Model m) -> IMP::Particles const &"""
    return _IMP_kernel._give_particles(m)

def _pass_particles(ps):
    r"""_pass_particles(IMP::Particles const & ps) -> IMP::Particles const &"""
    return _IMP_kernel._pass_particles(ps)

def _pass_particle(ps):
    r"""_pass_particle(Particle ps) -> Particle"""
    return _IMP_kernel._pass_particle(ps)

def _pass_particle_pair(pp):
    r"""_pass_particle_pair(IMP::ParticlePair const & pp) -> IMP::ParticlePair const &"""
    return _IMP_kernel._pass_particle_pair(pp)

def _give_particles_copy(m):
    r"""_give_particles_copy(Model m) -> IMP::Particles"""
    return _IMP_kernel._give_particles_copy(m)

def _pass_float_keys(input):
    r"""_pass_float_keys(IMP::FloatKeys const & input) -> IMP::FloatKeys"""
    return _IMP_kernel._pass_float_keys(input)

def _pass(*args):
    r"""
    _pass(IMP::Particles const & p) -> IMP::Particles const
    _pass(IMP::Restraints const & p) -> IMP::Restraints const &
    """
    return _IMP_kernel._pass(*args)

def _pass_decorators(p):
    r"""_pass_decorators(IMP::internal::_TrivialDecorators const & p) -> IMP::internal::_TrivialDecorators const &"""
    return _IMP_kernel._pass_decorators(p)

def _pass_decorator_traits(p):
    r"""_pass_decorator_traits(IMP::internal::_TrivialTraitsDecorators const & p) -> IMP::internal::_TrivialTraitsDecorators const &"""
    return _IMP_kernel._pass_decorator_traits(p)

def _pass_particle_pairs(p):
    r"""_pass_particle_pairs(IMP::ParticlePairsTemp const & p) -> IMP::ParticlePairsTemp"""
    return _IMP_kernel._pass_particle_pairs(p)

def _pass_particle_index_pairs(p):
    r"""_pass_particle_index_pairs(IMP::ParticleIndexPairs const & p) -> IMP::ParticleIndexPairs"""
    return _IMP_kernel._pass_particle_index_pairs(p)

def _pass_model_objects(p):
    r"""_pass_model_objects(IMP::ModelObjectsTemp const & p) -> IMP::ModelObjectsTemp"""
    return _IMP_kernel._pass_model_objects(p)

def _pass_particles_temps(ps):
    r"""_pass_particles_temps(IMP::ParticlesTemps const & ps) -> IMP::ParticlesTemps"""
    return _IMP_kernel._pass_particles_temps(ps)

def _test_overload(*args):
    r"""
    _test_overload(IMP::Particles const & ps) -> int
    _test_overload(IMP::Restraints const & ps) -> int
    """
    return _IMP_kernel._test_overload(*args)

def _get_range(m, k):
    r"""_get_range(Model m, FloatKey k) -> IMP::FloatRange"""
    return _IMP_kernel._get_range(m, k)

def _create_particles_from_pdb(name, m):
    r"""_create_particles_from_pdb(std::string name, Model m) -> IMP::ParticleIndexes"""
    return _IMP_kernel._create_particles_from_pdb(name, m)
class _LogPairScore(PairScore):
    r"""Proxy of C++ IMP::internal::_LogPairScore class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""__init__(_LogPairScore self) -> _LogPairScore"""
        _IMP_kernel._LogPairScore_swiginit(self, _IMP_kernel.new__LogPairScore())

    def do_get_inputs(self, arg2, arg3):
        r"""do_get_inputs(_LogPairScore self, Model arg2, IMP::ParticleIndexes const & arg3) -> IMP::ModelObjectsTemp"""
        return _IMP_kernel._LogPairScore_do_get_inputs(self, arg2, arg3)

    def get_version_info(self):
        r"""get_version_info(_LogPairScore self) -> VersionInfo"""
        return _IMP_kernel._LogPairScore_get_version_info(self)

    def get_particle_pairs(self):
        r"""get_particle_pairs(_LogPairScore self) -> IMP::ParticlePairsTemp"""
        return _IMP_kernel._LogPairScore_get_particle_pairs(self)

    def clear(self):
        r"""clear(_LogPairScore self)"""
        return _IMP_kernel._LogPairScore_clear(self)

    def get_contains(self, pp):
        r"""get_contains(_LogPairScore self, IMP::ParticlePair const & pp) -> bool"""
        return _IMP_kernel._LogPairScore_get_contains(self, pp)

# Register _LogPairScore in _IMP_kernel:
_IMP_kernel._LogPairScore_swigregister(_LogPairScore)


def _overloaded_particles(*args):
    r"""
    _overloaded_particles(Particle arg1)
    _overloaded_particles(IMP::Particles const & arg1)
    _overloaded_particles(IMP::ParticlesTemp const & arg1)
    _overloaded_particles(Model arg1, IMP::ParticleIndexes const & arg2)
    _overloaded_particles(IMP::internal::_TrivialDecorators const & arg1)
    _overloaded_particles(_TrivialDecorator arg1)
    """
    return _IMP_kernel._overloaded_particles(*args)
class _ImplicitParticles(object):
    r"""Proxy of C++ IMP::internal::_ImplicitParticles class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(_ImplicitParticles self, Particle arg2) -> _ImplicitParticles
        __init__(_ImplicitParticles self, IMP::Particles const & arg2) -> _ImplicitParticles
        __init__(_ImplicitParticles self, IMP::ParticlesTemp const & arg2) -> _ImplicitParticles
        __init__(_ImplicitParticles self, Model arg2, IMP::ParticleIndexes const & arg3) -> _ImplicitParticles
        __init__(_ImplicitParticles self, IMP::internal::_TrivialDecorators const & arg2) -> _ImplicitParticles
        __init__(_ImplicitParticles self, _TrivialDecorator arg2) -> _ImplicitParticles
        """
        _IMP_kernel._ImplicitParticles_swiginit(self, _IMP_kernel.new__ImplicitParticles(*args))
    __swig_destroy__ = _IMP_kernel.delete__ImplicitParticles

# Register _ImplicitParticles in _IMP_kernel:
_IMP_kernel._ImplicitParticles_swigregister(_ImplicitParticles)


def _implicit_particles(arg1):
    r"""_implicit_particles(_ImplicitParticles arg1)"""
    return _IMP_kernel._implicit_particles(arg1)

def _take_particle_adaptor(pa):
    r"""_take_particle_adaptor(_ParticleAdaptor pa) -> ParticleIndex"""
    return _IMP_kernel._take_particle_adaptor(pa)

def _take_particle_indexes_adaptor(pa):
    r"""_take_particle_indexes_adaptor(_ParticleIndexesAdaptor pa) -> IMP::ParticleIndexes"""
    return _IMP_kernel._take_particle_indexes_adaptor(pa)
class ScopedSetFloatAttribute(_RAII):
    r"""Proxy of C++ IMP::ScopedSetAttribute< FloatKey,IMP::Float > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(ScopedSetFloatAttribute self) -> ScopedSetFloatAttribute
        __init__(ScopedSetFloatAttribute self, Particle p, FloatKey key, double const & value) -> ScopedSetFloatAttribute
        """
        _IMP_kernel.ScopedSetFloatAttribute_swiginit(self, _IMP_kernel.new_ScopedSetFloatAttribute(*args))

    def set(self, p, key, value):
        r"""set(ScopedSetFloatAttribute self, Particle p, FloatKey key, double const & value)"""
        return _IMP_kernel.ScopedSetFloatAttribute_set(self, p, key, value)

    def reset(self):
        r"""reset(ScopedSetFloatAttribute self)"""
        return _IMP_kernel.ScopedSetFloatAttribute_reset(self)
    __swig_destroy__ = _IMP_kernel.delete_ScopedSetFloatAttribute

    def show(self, *args):
        r"""show(ScopedSetFloatAttribute self, _ostream out=std::cout)"""
        return _IMP_kernel.ScopedSetFloatAttribute_show(self, *args)

    def __str__(self):
        r"""__str__(ScopedSetFloatAttribute self) -> std::string"""
        return _IMP_kernel.ScopedSetFloatAttribute___str__(self)

    def __repr__(self):
        r"""__repr__(ScopedSetFloatAttribute self) -> std::string"""
        return _IMP_kernel.ScopedSetFloatAttribute___repr__(self)

# Register ScopedSetFloatAttribute in _IMP_kernel:
_IMP_kernel.ScopedSetFloatAttribute_swigregister(ScopedSetFloatAttribute)


def _get_module_data_path(module, file_name):
    r"""_get_module_data_path(std::string module, std::string file_name) -> std::string"""
    return _IMP_kernel._get_module_data_path(module, file_name)

def _get_module_example_path(module, file_name):
    r"""_get_module_example_path(std::string module, std::string file_name) -> std::string"""
    return _IMP_kernel._get_module_example_path(module, file_name)

#used_modules=[]
#def show_used_modules():
#    for m in used_modules:
#        print "%-20s %s" % (m.get_module(), m.get_version())

# Ensure that Windows gets the PATH set to include anything in the library
# search path
if sys.platform == 'win32' and 'IMP_LD_PATH' in os.environ:
    dirs = os.environ['IMP_LD_PATH'].split(":")
    pathcomps = os.environ['PATH'].split(";")
    for d in dirs:
        if d not in pathcomps:
            os.environ['PATH'] = d + ';' + os.environ['PATH']



import sys
import os

class CommandDispatcher(object):
    """Allow command line tools to easily implement multiple commands.
       Typically, an IMP command line tool will use an instance of this class
       to provide a consistent interface to multiple distinct commands
       from a single binary, rather than providing a potentially large
       number of binaries. This is similar to the way a number of common
       command line tools outside of %IMP function (e.g. Git provides a single
       `git` tool which implements multiple commands - `git add`, `git commit`,
       `git push` and so on).

       Each command is implemented with a Python module of the same name
       that can be imported from the module (for example, if `module_name`
       is `IMP.foo`, the `bar` command is provided by the `IMP.foo.bar` Python
       module, which would usually be found as `modules/foo/pyext/src/bar.py`).
       Each such module should have a docstring and a `%main()` method
       that takes no arguments (the module should also call its `%main()` method
       if it is run directly, i.e. with something like
       `if __name__=="__main__": %main()`). The encompassing module
       (`IMP.foo` in the example) should define `_all_commands` as a Python
       list of all valid commands.

       See the `multifit` and `cnmultifit` command line tools for example
       usage.
    """

    def __init__(self, short_help, long_help, module_name):
        """Constructor.
           @param short_help A few words that describe the command line tool.
           @param long_help Longer text, used in the `help` command.
           @param module_name Name of the module (e.g. `IMP.foo`) that
                  implements the commands.
        """
        self.short_help = short_help
        self.long_help = long_help
        self.module_name = module_name
        self._all_commands = self.import_module()._all_commands
        self._progname = os.path.basename(sys.argv[0])

    def main(self):
        """Call this method to act upon the user-provided command line"""
        if len(sys.argv) <= 1:
            print(self.short_help + " Use '%s help' for help." % self._progname)
        else:
            command = sys.argv[1]
            if command in ('help', '--help', '-h'):
                if len(sys.argv) == 3:
                    self.show_command_help(sys.argv[2])
                else:
                    self.show_help()
            elif command == '--version':
                self.show_version()
            elif command in self._all_commands:
                self.do_command(command)
            else:
                self.unknown_command(command)

    def import_module(self, mod=None):
        modname = self.module_name
        if mod is not None:
            modname += "." + mod
        return __import__(modname, {}, {}, [''])

    def unknown_command(self, command):
        print("Unknown command: '%s'" % command)
        print("Use '%s help' for help." % self._progname)
        sys.exit(1)

    def _get_version(self):
        return self.import_module().get_module_version()

    def show_version(self):
        print(self._progname + ' ' + self._get_version())

    def show_help(self):
        ver = self._get_version()
        print("%s, version %s." % (self._progname, ver))
        print(self.long_help + """

This program is part of IMP, the Integrative Modeling Platform,
which is Copyright 2007-2021 IMP Inventors.
For additional information about IMP, see <https://integrativemodeling.org>.

Usage: %s <command> [options] [args]

Commands:""" % self._progname)
        commands = self._all_commands[:] + ['help']
        commands.sort()
        cmdlen = max([len(c) for c in commands])
        for c in commands:
            if c == 'help':
                doc = 'Get help on using %s.' % self._progname
            else:
                doc = self.import_module(c).__doc__ or "<no help>"
            c += ' ' * (cmdlen - len(c))
            print('    ' + c + '  ' + doc)
        print("""
Use "%s help <command>" for detailed help on any command
 or "%s --version" to see the version number.""" % (self._progname,
                                                    self._progname))

    def do_command(self, command):
        mod = self.import_module(command)
        sys.argv[0] = self._progname + ' ' + command
        del sys.argv[1]
        mod.main()

    def show_command_help(self, command):
        if command == 'help':
            self.show_help()
        elif command in self._all_commands or command == 'help':
            mod = self.import_module(command)
            sys.argv = [self._progname + ' ' + command, '--help']
            mod.main()
        else:
            self.unknown_command(command)




def get_networkx_graph(ig):
    import networkx
    g = networkx.DiGraph()
    if len(ig.get_vertices()) == 0:
        return g

    class NodeWrapper:

        def __init__(self, p):
            self.p = p

        def __str__(self):
            return self.p.get_name()

        def __call__(self, name):
            return self.p.__call__(name)

    for vi in ig.get_vertices():
        n = ig.get_vertex_name(vi)
        g.add_node(NodeWrapper(n))
    for vi in ig.get_vertices():
        n = ig.get_vertex_name(vi)
        for ni in ig.get_out_neighbors(vi):
            nn = ig.get_vertex_name(ni)
            g.add_edge(NodeWrapper(n), NodeWrapper(nn))
    return g


def show_altgraph(g):
    def clean(name):
        try:
            n0 = name.get_name()
        except:
            n0 = str(name)
        n1 = str(n0).replace('"', '')
        n2 = n1.replace("\n", '')
        return n2
    import altgraph
    from altgraph import Graph, Dot
    graph = Graph.Graph()
    for i, v in enumerate(g.get_vertices()):
        graph.add_node(i)  # , node_data=g.get_vertex_name(v)
    for i, v in enumerate(g.get_vertices()):
        for n in g.get_out_neighbors(v):
            graph.add_edge(v, n)
    dot = Dot.Dot(graph)  # , graph_type="digraph"
    for i, v in enumerate(g.get_vertices()):
        dot.node_style(i, label=clean(g.get_vertex_name(v)))
    dot.display()


def show_graphviz(g):
    tfn = create_temporary_file_name("graph", ".dot")
    tfon = create_temporary_file_name("graph", ".pdf")
    st = g.get_graphviz_string()
    open(tfn, "w").write(st)
    try:
        import subprocess
    except ImportError:
        import sys
        sys.stderr.write("Cannot run dot on Python 2.3 systems.\n")
        return
    try:
        print("running dot")
        sp = subprocess.Popen(["dot", "-Tpdf", tfn, "-o" + tfon])
        sp.wait()
    except:
        import sys
        sys.stderr.write("The dot command from the graphviz package was not found. Please make sure it is in the PATH passed to IMP.\n")
        return
    import platform
    if platform.system() == "Darwin":
        cmd = ["open"]
    else:
        cmd = ["gv", "acroread", "xpdf"]
    success = False
    for c in cmd:
        print("launching viewer " + c)
        try:
            subprocess.check_call([c, tfon])
            success = True
            break
        except:
            pass
    if not success:
        print("Could not display file. It is saved at " + tfon)
    return tfon




import functools
import contextlib

def deprecated_module(version, module, help_message):
    """Mark a Python module as deprecated.
       @note The `module` argument would normally be `__name__`.
       @see [deprecation support](@ref deprecation)."""
    handle_use_deprecated(
                "Module %s is deprecated. %s\n" % (module, help_message))

def deprecated_object(version, help_message):
    """Python decorator to mark a class as deprecated.
       @see [deprecation support](@ref deprecation)."""
    def wrapper(obj):
        orig_init = obj.__init__
# Don't try to copy __module__ since __init__ may not have it
# (e.g. if we subclassed object but didn't override __init__)
        @functools.wraps(orig_init, ('__name__', '__doc__'))
        def __init__(obj, *args, **keys):
            handle_use_deprecated("Object %s is deprecated. %s\n"
                                  % (type(obj), help_message))
            orig_init(obj, *args, **keys)
        obj.__init__ = __init__
        return obj
    return wrapper

def deprecated_method(version, help_message):
    """Python decorator to mark a method as deprecated.
       @see [deprecation support](@ref deprecation)."""
    def out_wrapper(obj):
        @functools.wraps(obj)
        def wrapper(cls, *args, **keys):
            handle_use_deprecated("Method %s in %s is deprecated. %s\n"
                               % (obj.__name__, type(cls), help_message))
            return obj(cls, *args, **keys)
        return wrapper
    return out_wrapper

def deprecated_function(version, help_message):
    """Python decorator to mark a function as deprecated.
       @see [deprecation support](@ref deprecation)."""
    def out_wrapper(obj):
        @functools.wraps(obj)
        def wrapper(*args, **keys):
            handle_use_deprecated("Function %s is deprecated. %s\n"
                                  % (obj.__name__, help_message))
            return obj(*args, **keys)
        return wrapper
    return out_wrapper

@contextlib.contextmanager
def allow_deprecated(allow=True):
    """Context manager to temporarily allow (or disallow) deprecated code.
       @see [deprecation support](@ref deprecation)."""
    old = get_deprecation_exceptions()
    set_deprecation_exceptions(not allow)
    yield
    set_deprecation_exceptions(old)


def _get_all_flags(ntokens):
    r"""_get_all_flags(unsigned int ntokens) -> IMP::Strings"""
    return _IMP_kernel._get_all_flags(ntokens)

def _print_internal_help(out, description):
    r"""_print_internal_help(_ostream out, std::string description)"""
    return _IMP_kernel._print_internal_help(out, description)


import argparse
import sys

class _PassThroughAction(argparse.Action):
    """Pass an argument through to the IMP Boost parser"""
    def __call__(self, parser, namespace, values, option_string=None):
        parser._boost_command_line.append(option_string)
        if values != []:
            parser._boost_command_line.append(values)
# Terminate processing immediately if necessary (otherwise argparse
# may fail if we're missing positional arguments)
        if option_string in ('-h', '--help', '--help_advanced', '--version'):
            parser._handle_boost()


class ArgumentParser(argparse.ArgumentParser):
    """IMP-specific subclass of argparse.ArgumentParser.
       This adds options common to all IMP applications
       (see IMP::setup_from_argv()).
    """

    def __init__(self, *args, **kwargs):
# Don't add --help option (since the Boost option parser handles it)
        kwargs['add_help'] = False
        super(ArgumentParser, self).__init__(*args, **kwargs)
        for ntoken in (0, 1):
            flags = _get_all_flags(ntoken)
            for f in flags:
                arg = ['-h', '--help'] if f == 'help' else ['--' + f]
                self.add_argument(*arg, help=argparse.SUPPRESS,
                                  nargs=None if ntoken else 0,
                                  action=_PassThroughAction,
                                  default=argparse.SUPPRESS)

    def parse_args(self, args=None, namespace=None):
        """Parse the command line and return optional and positional arguments.
           This functions in the same way as the method in the base class
           argparse.ArgumentParser, except that it also processes optional
           arguments common to all IMP applications (these are not returned
           in `args`, but can be obtained in the usual way, e.g. by calling
           IMP::get_string_flag()).
           @returns   args
        """
        self._boost_command_line = [sys.argv[0]]
        ret = super(ArgumentParser, self).parse_args(args, namespace)
        if len(self._boost_command_line) > 1:
            self._handle_boost()
        return ret

    def _get_description(self):
        return self.format_help() + "\nOptions common to all IMP applications:"

    def print_help(self, file=None):
        _print_internal_help(file if file else sys.stdout,
                             self._get_description())

    def _handle_boost(self):
        setup_from_argv(self._boost_command_line,
                        self._get_description(),
                        '==SUPPRESS==', 0)

class RandomNumberGenerator(object):
    r"""Proxy of C++ IMP::RandomNumberGenerator class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def seed(self, x):
        r"""seed(RandomNumberGenerator self, ::boost::int32_t x)"""
        return _IMP_kernel.RandomNumberGenerator_seed(self, x)

    def __call__(self):
        r"""__call__(RandomNumberGenerator self) -> int"""
        return _IMP_kernel.RandomNumberGenerator___call__(self)

    def __init__(self):
        r"""__init__(RandomNumberGenerator self) -> RandomNumberGenerator"""
        _IMP_kernel.RandomNumberGenerator_swiginit(self, _IMP_kernel.new_RandomNumberGenerator())
    __swig_destroy__ = _IMP_kernel.delete_RandomNumberGenerator

# Register RandomNumberGenerator in _IMP_kernel:
_IMP_kernel.RandomNumberGenerator_swigregister(RandomNumberGenerator)


def get_random_float_uniform(*args):
    r"""
    get_random_float_uniform() -> float
    get_random_float_uniform(float min, float max) -> float
    """
    return _IMP_kernel.get_random_float_uniform(*args)

def get_random_double_uniform(*args):
    r"""
    get_random_double_uniform() -> double
    get_random_double_uniform(double min, double max) -> double
    """
    return _IMP_kernel.get_random_double_uniform(*args)

def get_random_floats_normal(n, mean=0.0, stddev=1.0):
    r"""get_random_floats_normal(unsigned int n, float mean=0.0, float stddev=1.0) -> IMP::Vector< float >"""
    return _IMP_kernel.get_random_floats_normal(n, mean, stddev)

def get_random_doubles_normal(n, mean=0.0, stddev=1.0):
    r"""get_random_doubles_normal(unsigned int n, double mean=0.0, double stddev=1.0) -> IMP::Vector< double >"""
    return _IMP_kernel.get_random_doubles_normal(n, mean, stddev)

def get_random_floats_uniform(n):
    r"""get_random_floats_uniform(unsigned int n) -> IMP::Vector< float >"""
    return _IMP_kernel.get_random_floats_uniform(n)

def get_random_doubles_uniform(n):
    r"""get_random_doubles_uniform(unsigned int n) -> IMP::Vector< double >"""
    return _IMP_kernel.get_random_doubles_uniform(n)

def get_random_seed():
    r"""get_random_seed() -> boost::uint64_t"""
    return _IMP_kernel.get_random_seed()

def _get_derivatives_numpy(m, k, m_pyobj):
    r"""_get_derivatives_numpy(Model m, FloatKey k, PyObject * m_pyobj) -> PyObject *"""
    return _IMP_kernel._get_derivatives_numpy(m, k, m_pyobj)

def _get_floats_numpy(m, k, m_pyobj):
    r"""_get_floats_numpy(Model m, FloatKey k, PyObject * m_pyobj) -> PyObject *"""
    return _IMP_kernel._get_floats_numpy(m, k, m_pyobj)

def _get_ints_numpy(m, k, m_pyobj):
    r"""_get_ints_numpy(Model m, IntKey k, PyObject * m_pyobj) -> PyObject *"""
    return _IMP_kernel._get_ints_numpy(m, k, m_pyobj)

def _get_spheres_numpy(m, m_pyobj):
    r"""_get_spheres_numpy(Model m, PyObject * m_pyobj) -> PyObject *"""
    return _IMP_kernel._get_spheres_numpy(m, m_pyobj)

def _get_sphere_derivatives_numpy(m, m_pyobj):
    r"""_get_sphere_derivatives_numpy(Model m, PyObject * m_pyobj) -> PyObject *"""
    return _IMP_kernel._get_sphere_derivatives_numpy(m, m_pyobj)

try:
    import numpy
    ParticleIndex = numpy.int32
except ImportError:
    pass


def get_module_version():
    r"""get_module_version() -> std::string const"""
    return _IMP_kernel.get_module_version()

def get_example_path(fname):
    r"""get_example_path(std::string fname) -> std::string"""
    return _IMP_kernel.get_example_path(fname)

def get_data_path(fname):
    r"""get_data_path(std::string fname) -> std::string"""
    return _IMP_kernel.get_data_path(fname)

from . import _version_check
_version_check.check_version(get_module_version())
__version__ = get_module_version()


random_number_generator = cvar.random_number_generator

