/* Tell swig how to treat various types when moving them to and from python. Among other
   things, they tell swig how to convert collections of C++ objects (eg ExampleRestraints)
   into python lists and back.

   IMP_SWIG_OBJECT, IMP_SWIG_VALUE and IMP_SWIG_DECORATOR lines need to appear before any
   %include lines as well as any inline C++ code (or at least any such code which uses
   the types in question).
  */
IMP_SWIG_BASE_OBJECT(IMP::isd, ISDRestraint, ISDRestraints);
IMP_SWIG_OBJECT(IMP::isd, CrossLinkMSRestraint, CrossLinkMSRestraints);
IMP_SWIG_OBJECT(IMP::isd, LogWrapper, LogWrappers);
IMP_SWIG_OBJECT(IMP::isd, UniformPrior, UniformPriors);
IMP_SWIG_OBJECT(IMP::isd, JeffreysRestraint, JeffreysRestraints);
IMP_SWIG_OBJECT(IMP::isd, NormalSigmaPCRestraint, NormalSigmaPCRestraints);
IMP_SWIG_OBJECT(IMP::isd, vonMisesKappaJeffreysRestraint, vonMisesKappaJeffreysRestraints);
IMP_SWIG_OBJECT(IMP::isd, vonMisesKappaConjugateRestraint, vonMisesKappaConjugateRestraints);
IMP_SWIG_BASE_OBJECT(IMP::isd, Distribution, Distributions);
IMP_SWIG_BASE_OBJECT(IMP::isd, OneDimensionalDistribution, OneDimensionalDistributions);
IMP_SWIG_BASE_OBJECT(IMP::isd, OneDimensionalSufficientDistribution, OneDimensionalSufficientDistributions);
IMP_SWIG_OBJECT(IMP::isd, FNormal, FNormals);
IMP_SWIG_OBJECT(IMP::isd, FStudentT, FStudentTs);
IMP_SWIG_OBJECT(IMP::isd, vonMises, vonMisess);
IMP_SWIG_OBJECT(IMP::isd, vonMisesSufficient, vonMisesSufficients);
IMP_SWIG_OBJECT(IMP::isd, PenalizedComplexityPrior, PenalizedComplexityPriors);
IMP_SWIG_DECORATOR(IMP::isd, Nuisance, Nuisances);
IMP_SWIG_DECORATOR(IMP::isd, Scale, Scales);
IMP_SWIG_DECORATOR(IMP::isd, Switching, Switchings);
IMP_SWIG_OBJECT(IMP::isd, NOERestraint, NOERestraints);
IMP_SWIG_DECORATOR(IMP::isd, Weight, Weights);
IMP_SWIG_OBJECT(IMP::isd, GaussianRestraint, GaussianRestraints);
IMP_SWIG_OBJECT(IMP::isd, StudentTRestraint, StudentTRestraints);
IMP_SWIG_OBJECT(IMP::isd, LognormalRestraint, LognormalRestraints);
IMP_SWIG_OBJECT(IMP::isd, LognormalAmbiguousRestraint, LognormalAmbiguousRestraints);
IMP_SWIG_OBJECT(IMP::isd, AmbiguousNOERestraint, AmbigousNOERestraints);
IMP_SWIG_OBJECT(IMP::isd, MarginalNOERestraint, AmbigousNOERestraints);
IMP_SWIG_OBJECT(IMP::isd, MarginalHBondRestraint, AmbigousHBondRestraints);
IMP_SWIG_OBJECT(IMP::isd, TALOSRestraint, TALOSRestraints);
IMP_SWIG_OBJECT(IMP::isd, RepulsiveDistancePairScore, RepulsiveDistancePairScores);
IMP_SWIG_OBJECT(IMP::isd, AmbiguousRestraint, AmbiguousRestraints);
IMP_SWIG_OBJECT(IMP::isd, UnivariateFunction, UnivariateFunctions);
IMP_SWIG_OBJECT(IMP::isd, Linear1DFunction, Linear1DFunctions);
IMP_SWIG_OBJECT(IMP::isd, GeneralizedGuinierPorodFunction, GeneralizedGuinierPorodFunctions);
IMP_SWIG_OBJECT(IMP::isd, BivariateFunction,  BivariateFunctions);
IMP_SWIG_OBJECT(IMP::isd, Covariance1DFunction, Covariance1DFunctions);
IMP_SWIG_OBJECT(IMP::isd, GaussianProcessInterpolation, GaussianProcessInterpolations);
IMP_SWIG_OBJECT(IMP::isd, GaussianProcessInterpolationRestraint, GaussianProcessInterpolationRestraints);
IMP_SWIG_OBJECT(IMP::isd, MolecularDynamics, MolecularDynamicss);
IMP_SWIG_OBJECT(IMP::isd, MolecularDynamicsMover, MolecularDynamicsMovers);
IMP_SWIG_OBJECT(IMP::isd, HybridMonteCarlo, HybridMonteCarlos);
IMP_SWIG_OBJECT(IMP::isd, FretData, FretDatas);
IMP_SWIG_OBJECT(IMP::isd, FretRestraint, FretRestraints);
IMP_SWIG_OBJECT(IMP::isd, CrossLinkData, CrossLinkDatas);
IMP_SWIG_OBJECT(IMP::isd, CysteineCrossLinkData, CysteineCrossLinkDatas);
IMP_SWIG_OBJECT(IMP::isd, CysteineCrossLinkRestraint, CysteineCrossLinkRestraints);
IMP_SWIG_OBJECT(IMP::isd, WeightMover, WeightMovers);
IMP_SWIG_OBJECT(IMP::isd, WeightRestraint, WeightRestraints);
IMP_SWIG_OBJECT(IMP::isd, AtomicCrossLinkMSRestraint, AtomicCrossLinkMSRestraints);
IMP_SWIG_OBJECT(IMP::isd, GaussianEMRestraint, GaussianEMRestraints);
IMP_SWIG_OBJECT(IMP::isd, GaussianAnchorEMRestraint, GaussianAnchorEMRestraints);
IMP_SWIG_OBJECT(IMP::isd, GammaPrior, GammaPriors);

/* One can add python methods to your module by putting code in %pythoncode blocks
   This function can be called as IMP.isds.say_hello(). */
%pythoncode %{
def create_model_and_particles():
  m= IMP.Model()
  sc= IMP.container.ListSingletonContainer(m)
  b= IMP.algebra.BoundingBox3D(IMP.algebra.Vector3D(0,0,0),
                               IMP.algebra.Vector3D(10,10,10))
  for i in range(0,100):
     p= IMP.Particle(m)
     sc.add_particle(p)
     d=IMP.core.XYZR.setup_particle(p, IMP.algebra.Sphere3D(IMP.algebra.get_random_vector_in(b), 1))
     d.set_coordinates_are_optimized(True)
  return (m, sc)
%}

/* Wrap our own classes. Each header in the module should be listed here with a
   %include line.*/
%include "IMP/isd/ISDRestraint.h"
%include "IMP/isd/CrossLinkMSRestraint.h"
%include "IMP/isd/LogWrapper.h"
%include "IMP/isd/UniformPrior.h"
%include "IMP/isd/Nuisance.h"
%include "IMP/isd/Scale.h"
%include "IMP/isd/Switching.h"
%include "IMP/isd/Weight.h"
%include "IMP/isd/JeffreysRestraint.h"
%include "IMP/isd/NormalSigmaPCRestraint.h"
%include "IMP/isd/distribution.h"
%include "IMP/isd/FNormal.h"
%include "IMP/isd/FStudentT.h"
%include "IMP/isd/vonMises.h"
%include "IMP/isd/vonMisesSufficient.h"
%include "IMP/isd/PenalizedComplexityPrior.h"
%include "IMP/isd/vonMisesKappaJeffreysRestraint.h"
%include "IMP/isd/vonMisesKappaConjugateRestraint.h"
%include "IMP/isd/NOERestraint.h"
%include "IMP/isd/GaussianRestraint.h"
%include "IMP/isd/StudentTRestraint.h"
%include "IMP/isd/LognormalRestraint.h"
%include "IMP/isd/LognormalAmbiguousRestraint.h"
%include "IMP/isd/AmbiguousNOERestraint.h"
%include "IMP/isd/MarginalNOERestraint.h"
%include "IMP/isd/MarginalHBondRestraint.h"
%include "IMP/isd/TALOSRestraint.h"
%include "IMP/isd/RepulsiveDistancePairScore.h"
%include "IMP/isd/AmbiguousRestraint.h"
%include "IMP/isd/univariate_functions.h"
%include "IMP/isd/bivariate_functions.h"
%include "IMP/isd/GaussianProcessInterpolation.h"
%include "IMP/isd/GaussianProcessInterpolationRestraint.h"
%include "IMP/isd/MolecularDynamics.h"
%include "IMP/isd/MolecularDynamicsMover.h"
%include "IMP/isd/HybridMonteCarlo.h"
%include "IMP/isd/FretData.h"
%include "IMP/isd/FretRestraint.h"
%include "IMP/isd/CysteineCrossLinkData.h"
%include "IMP/isd/CrossLinkData.h"
%include "IMP/isd/CysteineCrossLinkRestraint.h"
%include "IMP/isd/WeightMover.h"
%include "IMP/isd/WeightRestraint.h"
%include "IMP/isd/AtomicCrossLinkMSRestraint.h"
%include "IMP/isd/GaussianEMRestraint.h"
%include "IMP/isd/GaussianAnchorEMRestraint.h"
%include "IMP/isd/GammaPrior.h"
%include "IMP/isd/em_utilities.h"
