// Autogenerated by tools\build\make_containers.py
// from tools\build\container_templates\container\ClassnameContainerSet.h
// Do not edit - any changes will be lost!

/**
 *  \file IMP/container/QuadContainerSet.h
 *  \brief Store a set of QuadContainers
 *
 *  Copyright 2007-2021 IMP Inventors. All rights reserved.
 */

#ifndef IMPCONTAINER_QUAD_CONTAINER_SET_H
#define IMPCONTAINER_QUAD_CONTAINER_SET_H

#include <IMP/container/container_config.h>
#include <IMP/QuadContainer.h>
#include <IMP/container_macros.h>
#include <IMP/internal/container_helpers.h>
#include <IMP/scoped.h>

IMPCONTAINER_BEGIN_NAMESPACE

//! Stores a set of QuadContainers
/** The input sets must be disjoint. This can change if there is
    demand for it.

    \usesconstraint
*/
class IMPCONTAINEREXPORT QuadContainerSet : public QuadContainer {
  Ints versions_;
  static QuadContainerSet *get_set(QuadContainer *c) {
    return dynamic_cast<QuadContainerSet *>(c);
  }
  virtual std::size_t do_get_contents_hash() const IMP_OVERRIDE;

 public:
  //! Construct and empty set
  QuadContainerSet(Model *m,
                        std::string name = "QuadContainerSet %1%");

  QuadContainerSet(const QuadContainersTemp &pc,
                        std::string name = "QuadContainerSet %1%");

  /** \brief apply modifier sm to all quad containers */
  IMP_IMPLEMENT(void do_apply(const QuadModifier *sm) const);

  template <class M>
  void apply_generic(const M *m) const {
    apply(m);
  }

  ParticleIndexes get_all_possible_indexes() const;
  IMP_OBJECT_METHODS(QuadContainerSet);

  /** @name Methods to control the nested container

      This container merges a set of nested containers. To add
      or remove nested containers, use the methods below.
  */
  /**@{*/
  IMP_LIST_ACTION(public, QuadContainer, QuadContainers,
                  quad_container, quad_containers,
                  QuadContainer *, QuadContainers,
  {
    obj->set_was_used(true);
    versions_.clear();
  },
                  {}, );
/**@}*/

#ifndef IMP_DOXYGEN
  ParticleIndexQuads get_indexes() const;
  ParticleIndexQuads get_range_indexes() const;
  ModelObjectsTemp do_get_inputs() const;
#endif

 protected:
  //! Insert the contents of the container into output
  //! instead of output's current content
  virtual void get_indexes_in_place(ParticleIndexQuads& output)
    const IMP_OVERRIDE;
};

IMPCONTAINER_END_NAMESPACE

#endif /* IMPCONTAINER_QUAD_CONTAINER_SET_H */
