%extend IMP::Object {
  bool __eq__(const Object *o) const {
     return self ==o;
  }
  bool __ne__(const Object *o) const {
     return self !=o;
  }
  bool __le__(const Object *o) const {
     return self <= o;
  }
  bool __lt__(const Object *o) const {
     return self < o;
  }
  bool __ge__(const Object *o) const {
     return self >= o;
  }
  bool __gt__(const Object *o) const {
     return self > o;
  }
}

%feature("ref")   IMP::Object "if ($this) $this->ref();"
%feature("unref") IMP::Object "if ($this) $this->unref();"

%include "IMP/object_cast.h"

IMP_SWIG_RAII(IMP, SetLogState);
IMP_SWIG_RAII(IMP, SetNumberOfThreads);
IMP_SWIG_RAII(IMP, SetCheckState);
IMP_SWIG_OBJECT(IMP, Object, Objects);
IMP_SWIG_OBJECT(IMP::internal, _TestObject, _TestObjects);
IMP_SWIG_DIRECTOR(IMP, Object);
IMP_SWIG_VALUE(IMP, VersionInfo, VersionInfos);
/*IMP_SWIG_VALUE(IMP, TextOutput, TextOutputs);
IMP_SWIG_VALUE(IMP, TextInput, TextInputs);*/
IMP_SWIG_RAII(IMP, CreateLogContext)
IMP_SWIG_RAII(IMP, WarningContext)
IMP_SWIG_RAII(IMP, SetLogTarget);
IMP_SWIG_VALUE(IMP::internal, _TestValue, _TestValues);


IMP_SWIG_NATIVE_PAIR(IMP, double, DerivativePair, DerivativePairs);
IMP_SWIG_NATIVE_PAIR(IMP, double, FloatRange, FloatRanges);
IMP_SWIG_NATIVE_PAIR(IMP, double, FloatPair, FloatPairs);
IMP_SWIG_NATIVE_PAIR(IMP, int, IntRange, IntRanges);
IMP_SWIG_NATIVE_PAIR(IMP, int, IntPair, IntPairs);
IMP_SWIG_NATIVE_VALUES_LIST(IMP, double, Floats, FloatsList);
IMP_SWIG_NATIVE_VALUES_LIST(IMP, int, Ints, IntsList);
IMP_SWIG_NATIVE_VALUES_LIST(IMP, std::string, Strings, StringsList);
IMP_SWIG_VALUE_BUILTIN(IMP, Float, Floats, double);
IMP_SWIG_VALUE_BUILTIN(IMP, Int, Ints, int);
IMP_SWIG_VALUE_BUILTIN(IMP, String, Strings, std::string);
IMP_SWIG_NATIVE_VALUE(float);
IMP_SWIG_NATIVE_VALUE(double);
IMP_SWIG_NATIVE_VALUE(int);
IMP_SWIG_NATIVE_VALUE(std::string);
/* While we try not to return const& of primitive types, it can happen in
   template or other generated code. Special case this and have it act like
   simple return-by-value in Python. */
%typemap(out) IMP::Float const & {
  $result = SWIG_From_double(*$1);
}
%typemap(out) IMP::Int const & {
  $result = SWIG_From_int(*$1);
}
%typemap(out) IMP::String const & {
  $result = SWIG_From_std_string(*$1);
}

IMP_SWIG_VALUE_TEMPLATE(IMP, Index);
IMP_SWIG_VALUE(IMP::internal, _Protection, _Protections);

%rename(_InputAdaptor) IMP::InputAdaptor;
%rename(_NonCopyable) IMP::NonCopyable;
%rename(_RAII) IMP::RAII;
%rename(_Value) IMP::Value;

%include "IMP/InputAdaptor.h"
%include "IMP/NonCopyable.h"
%include "IMP/RAII.h"
%include "IMP/Value.h"
%include "IMP/Vector.h"
%include "IMP/types.h"
%include "IMP/flags.h"
%include "IMP/enums.h"
%include "IMP/VersionInfo.h"
%include "IMP/file.h"
%include "IMP/log.h"
%include "IMP/Object.h"
%include "IMP/SetLogState.h"
%include "IMP/WarningContext.h"
%include "IMP/CreateLogContext.h"
%include "IMP/SetCheckState.h"
%include "IMP/base_utility.h"
%include "IMP/internal/swig_base.h"
%include "IMP/ConstVector.h"
%include "IMP/Array.h"
%include "IMP/Index.h"
%include "IMP/live_objects.h"
%include "IMP/deprecation.h"
%include "IMP/threads.h"

%{
#if IMP_KERNEL_HAS_LOG4CXX
namespace {
struct LogInit {
LogInit() {IMP::internal::init_logger();}
} loginit;
}
#endif
%}

%{
#include <IMP/internal/swig.h>
#include <IMP/internal/directories.h>
%}

%pythoncode %{
import os
i_m_p="IMP_MODULE_PATH"
if i_m_p in os.environ.keys():
  __path__.insert(0, os.environ[i_m_p])

def _forward_add_attribute(self, name, value, opt=None):
    if opt is not None:
        self.get_particle().add_attribute(name, value, opt)
    else:
        self.get_particle().add_attribute(name, value)
def _forward_get_value(self, name):
    self.get_particle().get_value(name)
def _forward_set_value(self, name, value):
    self.get_particle().set_value(name, value)
%}


%typemap(in) char * {
  strings_must_be_passed_by_std_string;
}
%typemap(out) char * {
  strings_must_be_passed_by_std_string;
}

%extend IMP::Particle {
  bool __eq__(const Particle *o) const {
     return self ==o;
  }
  bool __ne__(const Particle *o) const {
     return self !=o;
  }
  bool __le__(const Particle *o) const {
     return self <= o;
  }
  bool __lt__(const Particle *o) const {
     return self < o;
  }
  bool __ge__(const Particle *o) const {
     return self >= o;
  }
  bool __gt__(const Particle *o) const {
     return self > o;
  }
  bool __eq__(const IMP::Decorator &d) const {
     return self == d.get_particle();
  }
  bool __ne__(const IMP::Decorator &d) const {
     return self != d.get_particle();
  }
  bool __le__(const IMP::Decorator &d) const {
     return self <= d.get_particle();
  }
  bool __lt__(const IMP::Decorator &d) const {
     return self < d.get_particle();
  }
  bool __ge__(const IMP::Decorator &d) const {
     return self >= d.get_particle();
  }
  bool __gt__(const IMP::Decorator &d) const {
     return self > d.get_particle();
  }
  /* Since we override __eq__, Python 3 will automatically disable __hash__.
     So we need to explicitly use the base class implementation */
  %pythoncode %{
  __hash__ = ModelObject.__hash__
  %}
}



#if IMP_BUILD == IMP_RELEASE
%pythoncode %{
build="release"
%}
#else
%pythoncode %{
build="debug"
%}
#endif



namespace IMP {
%warnfilter(473) Refiner;
%warnfilter(473) SingletonContainer;
%warnfilter(473) PairContainer;
%warnfilter(403) Constraint;
%warnfilter(403) Container;
%warnfilter(403) ModelObject;
%warnfilter(473) Sampler;
%warnfilter(473) Restraint;
%warnfilter(403) Restraint;
%warnfilter(403) SingletonPredicate;
%warnfilter(403) PairPredicate;
%warnfilter(403) TripletPredicate;
%warnfilter(403) QuadPredicate;
%warnfilter(403) SingletonModifier;
%warnfilter(403) PairModifier;
%warnfilter(403) TripletModifier;
%warnfilter(403) QuadModifier;
%warnfilter(403) SingletonScore;
%warnfilter(403) PairScore;
%warnfilter(403) TripletScore;
%warnfilter(403) QuadScore;
%warnfilter(403) AttributeOptimizer;
%warnfilter(403) OptimizerState;
}
%warnfilter(403) IMP::TrackedObject< IMP::ModelObject,IMP::Model >;


// to avoid extend clash
IMP_SWIG_BASE_OBJECT(IMP,Constraint, Constraints);
IMP_SWIG_BASE_OBJECT(IMP,Undecorator, Undecorators);
IMP_SWIG_BASE_OBJECT(IMP,Container, Containers);
IMP_SWIG_BASE_OBJECT(IMP,Optimizer, Optimizers);
IMP_SWIG_BASE_OBJECT(IMP,AttributeOptimizer, AttributeOptimizers);
IMP_SWIG_BASE_OBJECT(IMP,OptimizerState, OptimizerStates);
IMP_SWIG_BASE_OBJECT(IMP,PairContainer, PairContainers);
IMP_SWIG_BASE_OBJECT(IMP,PairModifier, PairModifiers);
IMP_SWIG_BASE_OBJECT(IMP,PairScore, PairScores);
IMP_SWIG_BASE_OBJECT(IMP,QuadContainer, QuadContainers);
IMP_SWIG_BASE_OBJECT(IMP,QuadModifier, QuadModifiers);
IMP_SWIG_BASE_OBJECT(IMP,QuadScore, QuadScores);
IMP_SWIG_BASE_OBJECT(IMP,Refiner, Refiners);
IMP_SWIG_BASE_OBJECT(IMP,Restraint, Restraints);
IMP_SWIG_BASE_OBJECT(IMP,Sampler, Samplers);
IMP_SWIG_BASE_OBJECT(IMP,ScoreState, ScoreStates);
IMP_SWIG_BASE_OBJECT(IMP,SingletonContainer, SingletonContainers);
IMP_SWIG_BASE_OBJECT(IMP,SingletonModifier, SingletonModifiers);
IMP_SWIG_BASE_OBJECT(IMP,SingletonScore, SingletonScores);
IMP_SWIG_BASE_OBJECT(IMP,TripletContainer, TripletContainers);
IMP_SWIG_BASE_OBJECT(IMP,TripletModifier, TripletModifiers);
IMP_SWIG_BASE_OBJECT(IMP,TripletScore, TripletScores);
IMP_SWIG_BASE_OBJECT(IMP,UnaryFunction, UnaryFunctions);
IMP_SWIG_OBJECT(IMP, RestraintInfo, RestraintInfos);
IMP_SWIG_OBJECT(IMP,ConfigurationSet, ConfigurationSets);
IMP_SWIG_OBJECT(IMP,Configuration, Configurations);
IMP_SWIG_OBJECT(IMP,Model, Models);
IMP_SWIG_OBJECT(IMP,Particle, Particles);

IMP_SWIG_NESTED_SEQUENCE_TYPEMAP(IMP::Particle, IMP::ParticlesTemp, IMP::ParticlesTemps, const&);
IMP_SWIG_NESTED_SEQUENCE_TYPEMAP(IMP::Particle, IMP::ParticlesTemp, IMP::ParticlesTemps,);

IMP_SWIG_BASE_OBJECT(IMP,RestraintSet, RestraintSets);
IMP_SWIG_ARRAY(IMP, ParticlePair, ParticlePairsTemp, IMP::Particle);
IMP_SWIG_ARRAY(IMP, ParticleTriplet, ParticleTripletsTemp, IMP::Particle);
IMP_SWIG_ARRAY(IMP, ParticleQuad, ParticleQuadsTemp, IMP::Particle);
IMP_SWIG_ARRAY(IMP, ParticleIndexPair, ParticleIndexPairs, IMP::ParticleIndex);
IMP_SWIG_ARRAY(IMP, ParticleIndexTriplet, ParticleIndexTriplets, IMP::ParticleIndex);
IMP_SWIG_ARRAY(IMP, ParticleIndexQuad, ParticleIndexQuads, IMP::ParticleIndex);
IMP_SWIG_BASE_OBJECT(IMP, SingletonPredicate, SingletonPredicates);
IMP_SWIG_BASE_OBJECT(IMP, PairPredicate, PairPredicates);
IMP_SWIG_BASE_OBJECT(IMP, TripletPredicate, TripletPredicates);
IMP_SWIG_BASE_OBJECT(IMP, QuadPredicate, QuadPredicates);

IMP_SWIG_OBJECT(IMP, SaveToConfigurationSetOptimizerState, SaveToConfigurationSetOptimizerStates);

// derivative accumulator is weird
// IMP_SWIG_VALUE(IMP, DerivativeAccumulator, DerivativeAccumulators);
IMP_SWIG_VALUE(IMP, EvaluationState, EvaluationStates);
IMP_SWIG_VALUE(IMP, ScoreAccumulator, ScoreAccumulators);
IMP_SWIG_VALUE_INSTANCE(IMP, ParticleIndex, IMP::Index, ParticleIndexes);
IMP_SWIG_VALUE(IMP, FloatIndex, FloatIndexes);
IMP_SWIG_VALUE_INSTANCE(IMP, FloatKey, Key, FloatKeys);
IMP_SWIG_VALUE_INSTANCE(IMP, FloatsKey, Key, FloatsKeys);
IMP_SWIG_VALUE_INSTANCE(IMP, IntKey, Key, IntKeys);
IMP_SWIG_VALUE_INSTANCE(IMP, IntsKey, Key, IntsKeys);
IMP_SWIG_VALUE_INSTANCE(IMP, StringKey, Key, StringKeys);
IMP_SWIG_VALUE_INSTANCE(IMP, ParticleIndexKey, Key, ParticleIndexKeys);
IMP_SWIG_VALUE_INSTANCE(IMP, ParticleIndexesKey, Key, ParticleIndexesKeys);
IMP_SWIG_VALUE_INSTANCE(IMP, ObjectKey, Key, ObjectKeys);
IMP_SWIG_VALUE_INSTANCE(IMP, ModelKey, Key, ModelKeys);
IMP_SWIG_VALUE_TEMPLATE(IMP, Key);
IMP_SWIG_RAII_TEMPLATE(IMP, ScopedSetAttribute);
IMP_SWIG_RAII_INSTANCE(IMP, ScopedSetFloatAttribute, ScopedSetAttribute);

IMP_SWIG_BASE_OBJECT(IMP, ScoringFunction, ScoringFunctions);
IMP_SWIG_BASE_OBJECT(IMP, ModelObject, ModelObjects);


IMP_SWIG_DECORATOR(IMP::internal, _TrivialDecorator, _TrivialDecorators);
IMP_SWIG_DECORATOR(IMP::internal, _TrivialDerivedDecorator, _TrivialDerivedDecorators);
IMP_SWIG_DECORATOR_WITH_TRAITS(IMP::internal, _TrivialTraitsDecorator, _TrivialTraitsDecorators);
IMP_SWIG_OBJECT(IMP::internal, _ConstRestraint, _ConstRestraints);
IMP_SWIG_OBJECT(IMP::internal, _ConstOptimizer, _ConstOptimizers);
IMP_SWIG_GRAPH(IMP, DependencyGraph, DependencyGraph, IMP::ModelObject*);


IMP_SWIG_CONTAINER(IMP, IMP, RestraintSet, Restraint, restraint)
IMP_SWIG_CONTAINER(IMP, IMP, Model, ScoreState, score_state)
IMP_SWIG_CONTAINER(IMP, IMP, Model, Restraint, restraint)
IMP_SWIG_CONTAINER(IMP, IMP, Optimizer, OptimizerState, optimizer_state)

%include "IMP/utility.h"
%include "IMP/Key.h"

namespace IMP {
  %template(FloatKey) ::IMP::Key<0>;
  %template(IntKey) ::IMP::Key<1>;
  %template(StringKey) ::IMP::Key<2>;
  %template(ParticleIndexKey) ::IMP::Key<3>;
  %template(ObjectKey) ::IMP::Key<4>;
  %template(IntsKey) ::IMP::Key<5>;
  %template(ParticleIndexesKey) ::IMP::Key<6>;
  %template(ModelKey) ::IMP::Key<8>;
  %template(ParticleIndex) ::IMP::Index<IMP::ParticleIndexTag>;
  %template(FloatsKey) ::IMP::Key<10>;
}

%inline %{
namespace IMP {
template <class T, class P, class E>
class Decorators;
}
%}


%pythoncode %{
  def ParticlePair(a, b):
    return (a,b)
  def ParticleTriplet(a, b, c):
    return (a,b,c)
  def ParticleQuad(a, b, c, d):
    return (a,b,c,d)
%}

%rename(_ParticleIndexTag) ParticleIndexTag;
%rename(_ScoringFunctionAdaptor) ScoringFunctionAdaptor;
%rename(_RestraintsAdaptor) RestraintsAdaptor;
%rename(_SingletonContainerAdaptor) SingletonContainerAdaptor;
%rename(_PairContainerAdaptor) PairContainerAdaptor;
%rename(_TripletContainerAdaptor) TripletContainerAdaptor;
%rename(_QuadContainerAdaptor) QuadContainerAdaptor;
%rename(_ParticleIndexAdaptor) ParticleIndexAdaptor;
%rename(_ParticleIndexesAdaptor) ParticleIndexesAdaptor;
%rename(_ParticleIndexPairsAdaptor) ParticleIndexPairsAdaptor;
%rename(_ParticleAdaptor) ParticleAdaptor;

%include "IMP/FloatIndex.h"
%include "IMP/base_types.h"
%include "IMP/constants.h"
%include "IMP/ModelObject.h"
%rename(_ParticleInputs) ParticleInputs;
%rename(_ParticleOutputs) ParticleOutputs;
%include "IMP/model_object_helpers.h"
%include "IMP/input_output.h"
%include "IMP/utility.h"
%include "IMP/DerivativeAccumulator.h"
%include "IMP/ScoreAccumulator.h"
%include "IMP/ScoreState.h"
%include "IMP/Constraint.h"
%include "IMP/container_base.h"

namespace IMP {
  class Restraints;
  class ScoreStates;
}

%include "IMP/RestraintInfo.h"
%include "IMP/Restraint.h"
%include "IMP/RestraintSet.h"
%include "IMP_kernel.particle.i"
%include "IMP/dependency_graph.h"
%include "IMP/ScoringFunction.h"
%include "IMP/Undecorator.h"
%include "IMP/Model.h"
%include "IMP/Decorator.h"
%include "IMP/UnaryFunction.h"
%include "IMP/OptimizerState.h"
%include "IMP/Refiner.h"
%include "IMP/Optimizer.h"
%include "IMP/AttributeOptimizer.h"
%include "IMP/ConfigurationSet.h"
%include "IMP/Configuration.h"
%include "IMP/Sampler.h"
%include "IMP/PairDerivativeModifier.h"
%include "IMP/PairModifier.h"
%include "IMP/PairScore.h"
%include "IMP/PairPredicate.h"
%include "IMP/PairContainer.h"
%include "IMP/QuadDerivativeModifier.h"
%include "IMP/QuadModifier.h"
%include "IMP/QuadScore.h"
%include "IMP/QuadPredicate.h"
%include "IMP/QuadContainer.h"
%include "IMP/SingletonDerivativeModifier.h"
%include "IMP/SingletonModifier.h"
%include "IMP/SingletonScore.h"
%include "IMP/SingletonPredicate.h"
%include "IMP/SingletonContainer.h"
%include "IMP/TripletDerivativeModifier.h"
%include "IMP/TripletModifier.h"
%include "IMP/TripletScore.h"
%include "IMP/TripletPredicate.h"
%include "IMP/TripletContainer.h"
%include "IMP/io.h"
%include "IMP/particle_index.h"
%include "IMP/internal/swig.h"
%include "IMP/scoped.h"


namespace IMP {
  %template(ScopedSetFloatAttribute) ::IMP::ScopedSetAttribute<FloatKey, Float>;
}

%inline %{
  std::string _get_module_data_path(std::string module, std::string file_name) {
    return IMP::internal::get_data_path(module, file_name);
  }
  std::string _get_module_example_path(std::string module,
                                       std::string file_name)  {
    return IMP::internal::get_example_path(module, file_name);
  }
%}

%pythoncode %{
#used_modules=[]
#def show_used_modules():
#    for m in used_modules:
#        print "%-20s %s" % (m.get_module(), m.get_version())

# Ensure that Windows gets the PATH set to include anything in the library
# search path
if sys.platform == 'win32' and 'IMP_LD_PATH' in os.environ:
    dirs = os.environ['IMP_LD_PATH'].split(":")
    pathcomps = os.environ['PATH'].split(";")
    for d in dirs:
        if d not in pathcomps:
            os.environ['PATH'] = d + ';' + os.environ['PATH']
%}

%include "IMP_kernel.dispatcher.i"
%include "IMP_kernel.graph_show.i"
%include "IMP_kernel.deprecation.i"
%include "IMP_kernel.argparse.i"
%include "IMP_kernel.random.i"
%include "IMP_kernel.numpy.i"
