## \example atom/multiresolution.py
# This example shows how to use the multiresolution support available in
# IMP.atom via the IMP.atom.Resolution decorator and IMP.atom.Selection

from __future__ import print_function
import IMP.atom
import sys

IMP.setup_from_argv(sys.argv, "multiresolution")

# Create an IMP model and add a heavy atom-only protein from a PDB file
m = IMP.Model()

root = IMP.atom.Hierarchy.setup_particle(m, m.add_particle("root"))
rigid_body = IMP.core.RigidBody.setup_particle(
    m, m.add_particle("rigid body"),
    IMP.algebra.ReferenceFrame3D())

prot = IMP.atom.read_pdb(IMP.atom.get_example_path("example_protein.pdb"), m,
                         IMP.atom.NonWaterNonHydrogenPDBSelector())
root.add_child(prot)
print("adding rigid body for atoms")
rigid_body.add_member(IMP.atom.create_rigid_body(prot))

resolutions = IMP.atom.Representation.setup_particle(root)

print("creating residue level rep")
residues = IMP.atom.create_simplified_along_backbone(prot, 1)
print("adding rigid body for residues")
rigid_body.add_member(IMP.atom.create_rigid_body(residues))
resolutions.add_representation(residues)

print("creating triplet residue level rep")
triplets = IMP.atom.create_simplified_along_backbone(prot, 3)
resolutions.add_representation(triplets)
print("adding rigid body for triplets")
rigid_body.add_member(IMP.atom.create_rigid_body(triplets))

whole = IMP.atom.create_simplified_along_backbone(prot, 10000)
resolutions.add_representation(whole)

print("resolutions are", resolutions)

# note these resolutions need to be fixed
print("atoms")
print(IMP.atom.Selection(root, residue_index=15, resolution=1).get_selected_particles())
print("residues")
print(IMP.atom.Selection(root, residue_index=15, resolution=.3).get_selected_particles())
print("several residues")
print(IMP.atom.Selection(root, residue_index=15, resolution=.2).get_selected_particles())
print("very coarse")
print(IMP.atom.Selection(root, residue_index=15, resolution=.01).get_selected_particles())
print("all")
print(IMP.atom.Selection(root, residue_index=15, resolution=IMP.atom.ALL_RESOLUTIONS).get_selected_particles())
