%import "RMF.i"
%{
#include "RMF.h"
%}

IMP_SWIG_VALUE(IMP::em2d, PolarResamplingParameters,
                                          PolarResamplingParametersList);
IMP_SWIG_VALUE(IMP::em2d, ProjectionMask, ProjectionMasks);
IMP_SWIG_VALUE(IMP::em2d, MasksManager ,MasksManagers);
IMP_SWIG_VALUE(IMP::em2d, RegistrationResult, RegistrationResults);

IMP_SWIG_VALUE(IMP::em2d, ClusterSet, ClusterSets);
IMP_SWIG_VALUE(IMP::em2d, SingleLinkage, SingleLinkages);
IMP_SWIG_VALUE(IMP::em2d, CompleteLinkage, CompleteLinkages);
IMP_SWIG_VALUE(IMP::em2d, AverageDistanceLinkage, AverageDistanceLinkages);

IMP_SWIG_VALUE(IMP::em2d, SegmentationParameters, SegmentationParametersList);
IMP_SWIG_VALUE(IMP::em2d, MatchTemplateResult, MatchTemplateResults);
IMP_SWIG_VALUE(IMP::em2d, ProjectingParameters, ProjectingParametersList);
IMP_SWIG_VALUE(IMP::em2d, ProjectingOptions, ProjectingOptionsList);
IMP_SWIG_VALUE(IMP::em2d, Em2DRestraintParameters, Em2DRestraintParametersList);


IMP_SWIG_OBJECT(IMP::em2d, ProjectionFinder, ProjectionFinders);
IMP_SWIG_OBJECT(IMP::em2d, ScoreFunction,ScoreFunctions);
IMP_SWIG_OBJECT(IMP::em2d, ChiSquaredScore,ChiSquaredScores);
IMP_SWIG_OBJECT(IMP::em2d, EM2DScore,EM2DScores);
IMP_SWIG_OBJECT(IMP::em2d, MeanAbsoluteDifference,MeanAbsoluteDifferences);

IMP_SWIG_OBJECT(IMP::em2d, ProjectionParametersScoreState,
                                     ProjectionParametersScoreStates);
IMP_SWIG_OBJECT(IMP::em2d, Em2DRestraint, Em2DRestraints);
/*header is not included
IMP_SWIG_OBJECT(IMP::em2d, Fine2DRegistrationRestraint,
                                  Fine2DRegistrationRestraints);*/
IMP_SWIG_OBJECT(IMP::em2d, Image, Images);
IMP_SWIG_OBJECT(IMP::em2d, ImageReaderWriter, ImageReaderWriters);
IMP_SWIG_OBJECT(IMP::em2d, JPGImageReaderWriter, JPGImageReaderWriters);
IMP_SWIG_OBJECT(IMP::em2d, TIFFImageReaderWriter, TIFFImageReaderWriters);
IMP_SWIG_OBJECT(IMP::em2d, SpiderImageReaderWriter, SpiderImageReaderWriters);
IMP_SWIG_OBJECT(IMP::em2d, CollisionCrossSection, CollisionCrossSections);

IMP_SWIG_OBJECT(IMP::em2d, GridStates, GridStatesList);
IMP_SWIG_OBJECT(IMP::em2d, ProjectionStates, ProjectionStatesList);
IMP_SWIG_OBJECT(IMP::em2d, DistanceFilter, DistanceFilters);
IMP_SWIG_OBJECT(IMP::em2d, DistanceFilterTable,DistanceFilterTables);

IMP_SWIG_OBJECT(IMP::em2d, RigidBodiesImageFitRestraint,
                            RigidBodiesImageFitRestraints);

IMP_SWIG_OBJECT(IMP::em2d, DummyRestraint, DummyRestraints);
IMP_SWIG_OBJECT(IMP::em2d, ParticlesDummyRestraint, ParticlesDummyRestraints);
IMP_SWIG_OBJECT(IMP::em2d, RelativePositionMover, RelativePositionMovers);

// 4th argument is to help SWIG distinguish this class from the
// identically-named class in IMP::em
// (see https://github.com/salilab/imp/issues/985)
IMP_SWIG_OBJECT(IMP::em2d, PCAFitRestraint, PCAFitRestraints, em2d);

IMP_BUILTIN_VALUES(Transformation3Ds, Transformation3DsList);

//IMP_SWIG_VALUE_BUILTIN(IMP::em2d, Floats, VectorOfFloats, IMP::Floats)


// IMP_SWIG_OBJECT(IMP::em2d, TemplateFinder, TemplateFinders);


// wrapping of a decorator with swig. Parameters: namespace, name, plural name
IMP_SWIG_DECORATOR(IMP::em2d, ProjectionParameters, ProjectionParametersList);


// IF swig complaints about something not found, check the order of these files
%include "IMP/em2d/opencv_interface.h"
%include "IMP/em2d/ImageReaderWriter.h"
%include "IMP/em2d/PolarResamplingParameters.h"
%include "IMP/em2d/image_processing.h"
%include "IMP/em2d/Image.h"
%include "IMP/em2d/RegistrationResult.h"
%include "IMP/em2d/SpiderImageReaderWriter.h"
%include "IMP/em2d/JPGImageReaderWriter.h"
%include "IMP/em2d/TIFFImageReaderWriter.h"
%include "IMP/em2d/FFToperations.h"
%include "IMP/em2d/scores2D.h"
%include "IMP/em2d/filenames_manipulation.h"
%include "IMP/em2d/ProjectionParameters.h"
%include "IMP/em2d/ProjectionMask.h"
%include "IMP/em2d/project.h"
%include "IMP/em2d/align2D.h"
%include "IMP/em2d/model_interaction.h"
%include "IMP/em2d/ProjectionFinder.h"
%include "IMP/em2d/Em2DRestraint.h"
%include "IMP/em2d/hierarchical_clustering.h"
%include "IMP/em2d/CollisionCrossSection.h"
%include "IMP/em2d/domino_particle_states.h"
%include "IMP/em2d/domino_filters.h"
%include "IMP/em2d/domino_filter_tables.h"
%include "IMP/em2d/RigidBodiesImageFitRestraint.h"
%include "IMP/em2d/RelativePositionMover.h"
%include "IMP/em2d/DummyRestraint.h"
%include "IMP/em2d/PCAFitRestraint.h"

// %include "IMP/em2d/TemplateFinder.h"

namespace IMP {
  namespace em2d {
    %template(ResultAlign2D)
            ::std::pair< IMP::algebra::Transformation2D,double >;

//    %template(VectorOfInts)   ::std::vector< IMP::Ints >;
//    %template(VectorOfFloats) ::std::vector< IMP::Floats >;

   %template(_do_hierarchical_clustering_single_linkage)
          ::IMP::em2d::do_hierarchical_agglomerative_clustering<SingleLinkage>;
   %template(_do_hierarchical_clustering_complete_linkage)
           ::IMP::em2d::do_hierarchical_agglomerative_clustering<CompleteLinkage>;
   %template(_do_hierarchical_clustering_average_distance_linkage)
           ::IMP::em2d::do_hierarchical_agglomerative_clustering<AverageDistanceLinkage>;
  }
}

%pythoncode %{
  do_hierarchical_clustering_single_linkage = _do_hierarchical_clustering_single_linkage
  do_hierarchical_clustering_complete_linkage = _do_hierarchical_clustering_complete_linkage
  do_hierarchical_clustering_average_distance_linkage = _do_hierarchical_clustering_average_distance_linkage
%}
