/**
 *  \file IMP.h
 *  \brief Include all non-deprecated headers in IMP.
 *
 *  Copyright 2007-2021 IMP Inventors. All rights reserved.
 */

#ifndef IMP_H
#define IMP_H
#include <IMP/Array.h>
#include <IMP/AttributeOptimizer.h>
#include <IMP/Configuration.h>
#include <IMP/ConfigurationSet.h>
#include <IMP/ConstVector.h>
#include <IMP/Constraint.h>
#include <IMP/CreateLogContext.h>
#include <IMP/Decorator.h>
#include <IMP/DerivativeAccumulator.h>
#include <IMP/Flag.h>
#include <IMP/FloatIndex.h>
#include <IMP/Index.h>
#include <IMP/InputAdaptor.h>
#include <IMP/Key.h>
#include <IMP/Model.h>
#include <IMP/ModelObject.h>
#include <IMP/NonCopyable.h>
#include <IMP/Object.h>
#include <IMP/Optimizer.h>
#include <IMP/OptimizerState.h>
#include <IMP/Particle.h>
#include <IMP/Pointer.h>
#include <IMP/RAII.h>
#include <IMP/Refiner.h>
#include <IMP/Restraint.h>
#include <IMP/RestraintInfo.h>
#include <IMP/RestraintSet.h>
#include <IMP/Sampler.h>
#include <IMP/ScoreAccumulator.h>
#include <IMP/ScoreState.h>
#include <IMP/ScoringFunction.h>
#include <IMP/SetCheckState.h>
#include <IMP/SetLogState.h>
#include <IMP/Showable.h>
#include <IMP/UnaryFunction.h>
#include <IMP/Undecorator.h>
#include <IMP/Value.h>
#include <IMP/Vector.h>
#include <IMP/VersionInfo.h>
#include <IMP/WarningContext.h>
#include <IMP/WeakPointer.h>
#include <IMP/base_macros.h>
#include <IMP/base_types.h>
#include <IMP/base_utility.h>
#include <IMP/bracket_macros.h>
#include <IMP/cache.h>
#include <IMP/check_macros.h>
#include <IMP/comparison_macros.h>
#include <IMP/compiler_macros.h>
#include <IMP/constants.h>
#include <IMP/container_base.h>
#include <IMP/container_macros.h>
#include <IMP/decorator_macros.h>
#include <IMP/dependency_graph.h>
#include <IMP/deprecation.h>
#include <IMP/deprecation_macros.h>
#include <IMP/doxygen_macros.h>
#include <IMP/enums.h>
#include <IMP/exception.h>
#include <IMP/file.h>
#include <IMP/flags.h>
#include <IMP/functor.h>
#include <IMP/generic.h>
#include <IMP/graph_macros.h>
#include <IMP/hash.h>
#include <IMP/hash_macros.h>
#include <IMP/input_output.h>
#include <IMP/io.h>
#include <IMP/live_objects.h>
#include <IMP/log.h>
#include <IMP/log_macros.h>
#include <IMP/macros.h>
#include <IMP/math.h>
#include <IMP/model_object_helpers.h>
#include <IMP/nullptr.h>
#include <IMP/nullptr_macros.h>
#include <IMP/object_cast.h>
#include <IMP/object_macros.h>
#include <IMP/particle_index.h>
#include <IMP/piecewise_linear_distribution.h>
#include <IMP/python_only.h>
#include <IMP/raii_macros.h>
#include <IMP/random.h>
#include <IMP/random_utils.h>
#include <IMP/ref_counted_macros.h>
#include <IMP/scoped.h>
#include <IMP/set_map_macros.h>
#include <IMP/showable_macros.h>
#include <IMP/swap_macros.h>
#include <IMP/swig_macros.h>
#include <IMP/thread_macros.h>
#include <IMP/threads.h>
#include <IMP/tuple_macros.h>
#include <IMP/types.h>
#include <IMP/utility.h>
#include <IMP/utility_macros.h>
#include <IMP/value_macros.h>
#include <IMP/vector_property_map.h>
#include <IMP/warning_macros.h>
#include <IMP/SingletonContainer.h>
#include <IMP/SingletonDerivativeModifier.h>
#include <IMP/SingletonModifier.h>
#include <IMP/SingletonPredicate.h>
#include <IMP/SingletonScore.h>
#include <IMP/singleton_macros.h>
#include <IMP/PairContainer.h>
#include <IMP/PairDerivativeModifier.h>
#include <IMP/PairModifier.h>
#include <IMP/PairPredicate.h>
#include <IMP/PairScore.h>
#include <IMP/pair_macros.h>
#include <IMP/TripletContainer.h>
#include <IMP/TripletDerivativeModifier.h>
#include <IMP/TripletModifier.h>
#include <IMP/TripletPredicate.h>
#include <IMP/TripletScore.h>
#include <IMP/triplet_macros.h>
#include <IMP/QuadContainer.h>
#include <IMP/QuadDerivativeModifier.h>
#include <IMP/QuadModifier.h>
#include <IMP/QuadPredicate.h>
#include <IMP/QuadScore.h>
#include <IMP/quad_macros.h>
#endif /* IMP_H */
