namespace std {
%template(DistBase) std::vector<double>;

}
/* Ignore some stuff to quell SWIG warnings */
%ignore operator>>(std::istream& s,
                   AtomFactorCoefficients& atom_factor_coefficients);
%ignore operator<<(std::ostream& s,
                   const AtomFactorCoefficients& atom_factor_coefficients);
%ignore operator<<(std::ostream& q, const IntensityEntry& e);
%ignore operator>>(std::istream& q, IntensityEntry& e);
//%template(_Vector3Ds) ::std::vector< ::IMP::algebra::Vector3D>;

IMP_SWIG_OBJECT(IMP::saxs, Profile, Profiles);
IMP_SWIG_OBJECT(IMP::saxs, ChiScore, ChiScores);
IMP_SWIG_OBJECT(IMP::saxs, ChiScoreLog, ChiScoreLogs);

/* Wrap our own classes */
%include "IMP/saxs/FormFactorTable.h"
%include "IMP/saxs/Profile.h"
%include "IMP/saxs/FitParameters.h"
%include "IMP/saxs/WeightedFitParameters.h"
%include "IMP/saxs/ChiScore.h"
%include "IMP/saxs/ChiScoreLog.h"
%include "IMP/saxs/ProfileFitter.h"
%template(ProfileFitterChi) IMP::saxs::ProfileFitter<IMP::saxs::ChiScore>;
%include "IMP/saxs/WeightedProfileFitter.h"
%template(WeightedProfileFitterChi) IMP::saxs::WeightedProfileFitter<IMP::saxs::ChiScore>;
%include "IMP/saxs/Restraint.h"
%include "IMP/saxs/RadiusOfGyrationRestraint.h"
%include "IMP/saxs/Distribution.h"
%include "IMP/saxs/SolventAccessibleSurface.h"

%template(ProfileFitterChiLog) IMP::saxs::ProfileFitter<IMP::saxs::ChiScoreLog>;
%template(ProfileFitterRatioVolatility) IMP::saxs::ProfileFitter<IMP::saxs::RatioVolatilityScore>;
