/* Tell swig how to treat various types when moving them to and from python. Among other
   things, they tell swig how to convert collections of C++ objects (eg ExampleRestraints)
   into python lists and back.

   IMP_SWIG_OBJECT, IMP_SWIG_VALUE and IMP_SWIG_DECORATOR lines need to appear before any
   %include lines as well as any inline C++ code (or at least any such code which uses
   the types in question).
  */
%import "RMF.i"
%{
#include "RMF.h"
%}

IMP_SWIG_DECORATOR(IMP::spb, HelixDecorator, HelixDecorators);

IMP_SWIG_OBJECT(IMP::spb,AttributeDistancePairScore,AttributeDistancePairScores);
IMP_SWIG_OBJECT(IMP::spb,BoxedMover,BoxedMovers);
IMP_SWIG_OBJECT(IMP::spb,CellMover,CellMovers);
IMP_SWIG_OBJECT(IMP::spb,ChiSquareMetric,ChiSquareMetrics);
IMP_SWIG_OBJECT(IMP::spb,ContactMapMetric,ContactMapMetrics);
IMP_SWIG_OBJECT(IMP::spb,DiameterRgyrRestraint,DiameterRgyrRestraints);
IMP_SWIG_OBJECT(IMP::spb,DistanceRMSDMetric,DistanceRMSDMetrics);
IMP_SWIG_OBJECT(IMP::spb,Gaussian,Gaussians);
IMP_SWIG_OBJECT(IMP::spb,ISDRestraint,ISDRestraints);
IMP_SWIG_OBJECT(IMP::spb,KinkPairScore,KinkPairScores);
IMP_SWIG_OBJECT(IMP::spb,MolecularDynamicsWithWte,MolecularDynamicsWithWtes);
IMP_SWIG_OBJECT(IMP::spb,MonteCarloWithWte,MonteCarloWithWtes);
IMP_SWIG_OBJECT(IMP::spb,NuisanceRangeModifier,NuisanceRangeModifiers);
IMP_SWIG_OBJECT(IMP::spb,PbcBoxedMover,PbcBoxedMovers);
IMP_SWIG_OBJECT(IMP::spb,PbcBoxedRigidBodyMover,PbcBoxedRigidBodyMovers);
IMP_SWIG_OBJECT(IMP::spb,RigidBodyNewMover,RigidBodyNewMovers);
IMP_SWIG_OBJECT(IMP::spb,RigidBodyPackingScore,RigidBodyPackingScores);
IMP_SWIG_OBJECT(IMP::spb,RMSDMetric,RMSDMetrics);
IMP_SWIG_OBJECT(IMP::spb,SameParticlePairFilter,SameParticlePairFilters);
IMP_SWIG_OBJECT(IMP::spb,SameRigidBodyPairFilter,SameRigidBodyPairFilters);
IMP_SWIG_OBJECT(IMP::spb,TiltSingletonScore,TiltSingletonScores);
IMP_SWIG_OBJECT(IMP::spb,TransformationSymmetry,TransformationSymmetrys);
IMP_SWIG_OBJECT(IMP::spb,TwoStateGoModelRestraint,TwoStateGoModelRestraints);
IMP_SWIG_OBJECT(IMP::spb,UniformBoundedRestraint,UniformBoundedRestraints);

/* Wrap our own classes. Each header in the module should be listed here with a
   %include line.*/
%include "IMP/spb/AttributeDistancePairScore.h"
%include "IMP/spb/BoxedMover.h"
%include "IMP/spb/CellMover.h"
%include "IMP/spb/ChiSquareMetric.h"
%include "IMP/spb/ContactMapMetric.h"
%include "IMP/spb/DiameterRgyrRestraint.h"
%include "IMP/spb/DistanceRMSDMetric.h"
%include "IMP/spb/Gaussian.h"
%include "IMP/spb/HelixDecorator.h"
%include "IMP/spb/ISDRestraint.h"
%include "IMP/spb/KinkPairScore.h"
%include "IMP/spb/MolecularDynamicsWithWte.h"
%include "IMP/spb/MonteCarloWithWte.h"
%include "IMP/spb/NuisanceRangeModifier.h"
%include "IMP/spb/PbcBoxedMover.h"
%include "IMP/spb/PbcBoxedRigidBodyMover.h"
%include "IMP/spb/RigidBodyNewMover.h"
%include "IMP/spb/RigidBodyPackingScore.h"
%include "IMP/spb/RMSDMetric.h"
%include "IMP/spb/SameParticlePairFilter.h"
%include "IMP/spb/SameRigidBodyPairFilter.h"
%include "IMP/spb/TiltSingletonScore.h"
%include "IMP/spb/TransformationSymmetry.h"
%include "IMP/spb/TwoStateGoModelRestraint.h"
%include "IMP/spb/UniformBoundedRestraint.h"

