%import "RMF.i"
%import "IMP_kernel.i"
%import "IMP_core.i"
%import "IMP_score_functor.i"
%{
#include <RMF.h>
//#include <RMF/HDF5.h>
IMP_CLANG_PRAGMA(diagnostic ignored "-Wc++11-long-long")
%}
IMP_SWIG_OBJECT(IMP::npctransport, SitesPairScore, SitesPairScores);
// IMP_SWIG_OBJECT(IMP::npctransport, TemplateBaseSitesPairScore, TemplateBaseSitesPairScores);
IMP_SWIG_OBJECT(IMP::npctransport, Scoring, Scorings);
IMP_SWIG_OBJECT(IMP::npctransport, BrownianDynamicsTAMDWithSlabSupport, BrownianDynamicsTAMDWithSlabSupports);
IMP_SWIG_OBJECT(IMP::npctransport, Statistics, StatisticsList);
IMP_SWIG_OBJECT(IMP::npctransport, SimulationData, SimulationDatas);
IMP_SWIG_OBJECT(IMP::npctransport, SitesGeometry, SitesGeometries);
IMP_SWIG_OBJECT(IMP::npctransport, TypedSitesGeometry, TypedSitesGeometries);
IMP_SWIG_OBJECT(IMP::npctransport, SlabWithCylindricalPorePairScore, SlabWithCylindricalPorePairScores);
IMP_SWIG_OBJECT(IMP::npctransport, SlabWithToroidalPorePairScore, SlabWithToroidalPorePairScores);
IMP_SWIG_OBJECT(IMP::npctransport, PoreRadiusSingletonScore, PoreRadiusSingletonScores);
IMP_SWIG_OBJECT(IMP::npctransport, ExcludeZRangeSingletonScore, ExcludeZRangeSingletonScores);
IMP_SWIG_OBJECT(IMP::npctransport, ZBiasSingletonScore, ZBiasSingletonScores);
IMP_SWIG_OBJECT(IMP::npctransport, SlabWithCylindricalPoreWireGeometry, SlabWithCylindricalPoreWireGeometries);
IMP_SWIG_OBJECT(IMP::npctransport, SlabWithCylindricalPoreSurfaceGeometry, SlabWithCylindricalPoreSurfaceGeometries);
IMP_SWIG_OBJECT(IMP::npctransport, SlabWithToroidalPoreWireGeometry, SlabWithToroidalPoreWireGeometries);
IMP_SWIG_OBJECT(IMP::npctransport, LinearSoftSpherePairScore, LinearSoftSpherePairScores);
IMP_SWIG_OBJECT(IMP::npctransport, FunctorLinearSoftSpherePairScore, FunctorLinearSoftSpherePairScores);
IMP_SWIG_OBJECT(IMP::npctransport, LinearInteractionPairScore, LinearInteractionPairScores);
IMP_SWIG_OBJECT(IMP::npctransport, FunctorLinearInteractionPairScore, FunctorLinearInteractionPairScores);
IMP_SWIG_OBJECT(IMP::npctransport, LinearWellPairScore, LinearWellPairScores);
IMP_SWIG_OBJECT(IMP::npctransport, HarmonicSpringSingletonScore, HarmonicSpringSingletonScores);
IMP_SWIG_OBJECT(IMP::npctransport, HierarchyWithSitesSaveLink, HierarchyWithSitesSaveLinks);
IMP_SWIG_OBJECT(IMP::npctransport, HierarchyWithSitesLoadLink, HierarchyWithSitesLoadLinks);
IMP_SWIG_OBJECT(IMP::npctransport, ChainStatisticsOptimizerState, ChainStatisticsptimizerStates);
IMP_SWIG_OBJECT(IMP::npctransport, BodyStatisticsOptimizerState, BodyStatisticsOptimizerStates);
IMP_SWIG_OBJECT(IMP::npctransport, BipartitePairsStatisticsOptimizerState, BipartitePairsStatisticsOptimizerStates);
IMP_SWIG_OBJECT(IMP::npctransport, ParticleTransportStatisticsOptimizerState, ParticleTransportStatisticsOptimizerStates);
IMP_SWIG_OBJECT(IMP::npctransport, FGChain, FGChains);
IMP_SWIG_OBJECT(IMP::npctransport, ParticleFactory, ParticleFactories);
// IMP_SWIG_OBJECT(IMP::npctransport::internal, TAMDChain, TAMDChains);
IMP_SWIG_VALUE(IMP::npctransport, Avro2PBReader, Avro2PBReaders);
IMP_SWIG_VALUE(IMP::npctransport, SitesPairScoreParameters, SitesPairScoreParametersList);
//IMP_SWIG_VALUE(IMP::npctransport, LinearInteraction, LinearInteractions);
IMP_SWIG_DECORATOR(IMP::npctransport, Transporting, Transportings);
IMP_SWIG_DECORATOR(IMP::npctransport, SlabWithPore, SlabWithPores);
IMP_SWIG_DECORATOR(IMP::npctransport, SlabWithCylindricalPore, SlabWithCylindricalPores);
IMP_SWIG_DECORATOR(IMP::npctransport, RelaxingSpring, RelaxingSprings);
IMP_SWIG_DECORATOR(IMP::npctransport, SlabWithToroidalPore, SlabWithToroidalPores);
//IMP_SWIG_VALUE_INSTANCE(IMP::npctransport, InteractionType, std::pair, InteractionTypes);

%apply unsigned int { boost::uint32_t }
%apply unsigned long long { boost::uint64_t }

// Return value from Avro2PBReader::read_next() should be handled as an
// array of bytes in Python 3, not a Unicode string
%typemap(out) IMP::npctransport::Avro2PBReader::ByteBuffer {
%#if PY_VERSION_HEX >= 0x03000000
  $result = PyBytes_FromStringAndSize($1.data(), $1.size());
%#else
  $result = PyString_FromStringAndSize($1.data(), $1.size());
%#endif
}

%include "IMP_npctransport.Parameter.i"
%include "IMP/npctransport/typedefs.h"
%include "IMP/npctransport/linear_distance_pair_scores.h"
%include "IMP/npctransport/RelaxingSpring.h"
%include "IMP/npctransport/HarmonicSpringSingletonScore.h"
%include "IMP/npctransport/functor_linear_distance_pair_scores_typedefs.h"
// The following templates are necessary for proper interpreation of class inheritence in linear_distance_pair_scores.h
%template(_DistancePairScoreForLinearSoftSphere) IMP::score_functor::DistancePairScore<IMP::npctransport::LinearSoftSphereScore>;
%template(_DistancePairScoreForLinearInteraction) IMP::score_functor::DistancePairScore<IMP::npctransport::LinearInteractionScore>;
%include "IMP/npctransport/functor_linear_distance_pair_scores.h"
%include "IMP/npctransport/BrownianDynamicsTAMDWithSlabSupport.h"
%include "IMP/npctransport/SitesPairScoreParameters.h"
%include "IMP/npctransport/SitesGeometry.h"
%include "IMP/npctransport/SitesPairScore.h"
%include "IMP/npctransport/FGChain.h"
%include "IMP/npctransport/Scoring.h"
%include "IMP/npctransport/Statistics.h"
%include "IMP/npctransport/SimulationData.h"
%include "IMP/npctransport/io.h"
%include "IMP/npctransport/ParticleFactory.h"
// %include "IMP/npctransport/internal/TAMDChain.h"
%include "IMP/npctransport/rmf_links.h"
%include "IMP/npctransport/Transporting.h"
%include "IMP/npctransport/protobuf.h"
%include "IMP/npctransport/SlabWithPore.h"
%include "IMP/npctransport/SlabWithCylindricalPore.h"
%include "IMP/npctransport/SlabWithToroidalPore.h"
%include "IMP/npctransport/SlabWithCylindricalPorePairScore.h"
%include "IMP/npctransport/SlabWithToroidalPorePairScore.h"
%include "IMP/npctransport/SlabWithCylindricalPoreGeometry.h"
%include "IMP/npctransport/SlabWithToroidalPoreGeometry.h"
// The following template is necessary for proper interpretation of class inheritence in PoreRadiusSingletonScore
%template(_GenericAttributeSingletonScoreForPoreRadus) IMP::core::GenericAttributeSingletonScore<IMP::core::Harmonic>;
%include "IMP/npctransport/PoreRadiusSingletonScore.h"
%include "IMP/npctransport/ExcludeZRangeSingletonScore.h"
%include "IMP/npctransport/ZBiasSingletonScore.h"
%include "IMP/npctransport/BodyStatisticsOptimizerState.h"
%include "IMP/npctransport/ParticleTransportStatisticsOptimizerState.h"
%include "IMP/npctransport/ChainStatisticsOptimizerState.h"
%include "IMP/npctransport/BipartitePairsStatisticsOptimizerState.h"
%include "IMP/npctransport/automatic_parameters.h"
%include "IMP/npctransport/initialize_positions.h"
%include "IMP/npctransport/Avro2PBReader.h"
%include "IMP/npctransport/util.h"

// %rename(_TemplateBaseSitesPairScore) TemplateBaseSitesPairScore;
%pythoncode %{
try:
  from .npctransport_pb2 import *
  import google.protobuf
except ImportError:
  print("no protobuf support in python")
from ._configuration import *
%}
