IMP_SWIG_OBJECT(IMP::pmi, CompositeRestraint, CompositeRestraints);
IMP_SWIG_DECORATOR(IMP::pmi, Uncertainty, Uncertainties);
IMP_SWIG_DECORATOR(IMP::pmi, Resolution, Resolutions);
IMP_SWIG_DECORATOR(IMP::pmi, Symmetric, Symmetrics);
IMP_SWIG_OBJECT(IMP::pmi, TransformMover, TransformMovers);
IMP_SWIG_OBJECT(IMP::pmi, MembraneRestraint, MembraneRestraints);

%pythoncode %{
class StructureWarning(UserWarning):
    """Warning related to handling of structures"""
    pass


class ParameterWarning(UserWarning):
    """Warning for probably incorrect input parameters"""
    pass


class MissingFileWarning(UserWarning):
    """Warning for an expected, but missing, file"""
    pass
%}


%include "IMP/pmi/MembraneRestraint.h"
%include "IMP/pmi/CompositeRestraint.h"
%include "IMP/pmi/Uncertainty.h"
%include "IMP/pmi/Resolution.h"
%include "IMP/pmi/Symmetric.h"
%include "IMP/pmi/TransformMover.h"
%include "IMP/pmi/utilities.h"
