# This file was automatically generated by SWIG (http://www.swig.org).
# Version 4.0.2
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

# This wrapper is part of IMP,
# Copyright 2007-2021 IMP Inventors. All rights reserved.

from __future__ import print_function, division, absolute_import
from sys import version_info as _swig_python_version_info
if _swig_python_version_info < (2, 7, 0):
    raise RuntimeError("Python 2.7 or later required")

import _IMP_atom

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "thisown":
            self.this.own(value)
        elif name == "this":
            set(self, name, value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


import weakref

class IMP_ATOM_SwigPyIterator(object):
    r"""Proxy of C++ swig::IMP_ATOM_SwigPyIterator class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _IMP_atom.delete_IMP_ATOM_SwigPyIterator

    def value(self):
        r"""value(IMP_ATOM_SwigPyIterator self) -> PyObject *"""
        return _IMP_atom.IMP_ATOM_SwigPyIterator_value(self)

    def incr(self, n=1):
        r"""incr(IMP_ATOM_SwigPyIterator self, size_t n=1) -> IMP_ATOM_SwigPyIterator"""
        return _IMP_atom.IMP_ATOM_SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        r"""decr(IMP_ATOM_SwigPyIterator self, size_t n=1) -> IMP_ATOM_SwigPyIterator"""
        return _IMP_atom.IMP_ATOM_SwigPyIterator_decr(self, n)

    def distance(self, x):
        r"""distance(IMP_ATOM_SwigPyIterator self, IMP_ATOM_SwigPyIterator x) -> ptrdiff_t"""
        return _IMP_atom.IMP_ATOM_SwigPyIterator_distance(self, x)

    def equal(self, x):
        r"""equal(IMP_ATOM_SwigPyIterator self, IMP_ATOM_SwigPyIterator x) -> bool"""
        return _IMP_atom.IMP_ATOM_SwigPyIterator_equal(self, x)

    def copy(self):
        r"""copy(IMP_ATOM_SwigPyIterator self) -> IMP_ATOM_SwigPyIterator"""
        return _IMP_atom.IMP_ATOM_SwigPyIterator_copy(self)

    def next(self):
        r"""next(IMP_ATOM_SwigPyIterator self) -> PyObject *"""
        return _IMP_atom.IMP_ATOM_SwigPyIterator_next(self)

    def __next__(self):
        r"""__next__(IMP_ATOM_SwigPyIterator self) -> PyObject *"""
        return _IMP_atom.IMP_ATOM_SwigPyIterator___next__(self)

    def previous(self):
        r"""previous(IMP_ATOM_SwigPyIterator self) -> PyObject *"""
        return _IMP_atom.IMP_ATOM_SwigPyIterator_previous(self)

    def advance(self, n):
        r"""advance(IMP_ATOM_SwigPyIterator self, ptrdiff_t n) -> IMP_ATOM_SwigPyIterator"""
        return _IMP_atom.IMP_ATOM_SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        r"""__eq__(IMP_ATOM_SwigPyIterator self, IMP_ATOM_SwigPyIterator x) -> bool"""
        return _IMP_atom.IMP_ATOM_SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        r"""__ne__(IMP_ATOM_SwigPyIterator self, IMP_ATOM_SwigPyIterator x) -> bool"""
        return _IMP_atom.IMP_ATOM_SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        r"""__iadd__(IMP_ATOM_SwigPyIterator self, ptrdiff_t n) -> IMP_ATOM_SwigPyIterator"""
        return _IMP_atom.IMP_ATOM_SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        r"""__isub__(IMP_ATOM_SwigPyIterator self, ptrdiff_t n) -> IMP_ATOM_SwigPyIterator"""
        return _IMP_atom.IMP_ATOM_SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        r"""__add__(IMP_ATOM_SwigPyIterator self, ptrdiff_t n) -> IMP_ATOM_SwigPyIterator"""
        return _IMP_atom.IMP_ATOM_SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        r"""
        __sub__(IMP_ATOM_SwigPyIterator self, ptrdiff_t n) -> IMP_ATOM_SwigPyIterator
        __sub__(IMP_ATOM_SwigPyIterator self, IMP_ATOM_SwigPyIterator x) -> ptrdiff_t
        """
        return _IMP_atom.IMP_ATOM_SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register IMP_ATOM_SwigPyIterator in _IMP_atom:
_IMP_atom.IMP_ATOM_SwigPyIterator_swigregister(IMP_ATOM_SwigPyIterator)


_value_types=[]
_object_types=[]
_raii_types=[]
_plural_types=[]

IMP_DEBUG = _IMP_atom.IMP_DEBUG

IMP_RELEASE = _IMP_atom.IMP_RELEASE

IMP_SILENT = _IMP_atom.IMP_SILENT

IMP_PROGRESS = _IMP_atom.IMP_PROGRESS

IMP_TERSE = _IMP_atom.IMP_TERSE

IMP_VERBOSE = _IMP_atom.IMP_VERBOSE

IMP_MEMORY = _IMP_atom.IMP_MEMORY

IMP_NONE = _IMP_atom.IMP_NONE

IMP_USAGE = _IMP_atom.IMP_USAGE

IMP_INTERNAL = _IMP_atom.IMP_INTERNAL

IMP_KERNEL_HAS_LOG4CXX = _IMP_atom.IMP_KERNEL_HAS_LOG4CXX

IMP_COMPILER_HAS_AUTO = _IMP_atom.IMP_COMPILER_HAS_AUTO

IMP_COMPILER_HAS_DEBUG_VECTOR = _IMP_atom.IMP_COMPILER_HAS_DEBUG_VECTOR

IMP_COMPILER_HAS_UNIQUE_PTR = _IMP_atom.IMP_COMPILER_HAS_UNIQUE_PTR

IMP_KERNEL_HAS_BOOST_RANDOM = _IMP_atom.IMP_KERNEL_HAS_BOOST_RANDOM

IMP_KERNEL_HAS_NUMPY = _IMP_atom.IMP_KERNEL_HAS_NUMPY

IMP_KERNEL_HAS_GPERFTOOLS = _IMP_atom.IMP_KERNEL_HAS_GPERFTOOLS

IMP_KERNEL_HAS_TCMALLOC_HEAPCHECKER = _IMP_atom.IMP_KERNEL_HAS_TCMALLOC_HEAPCHECKER

IMP_KERNEL_HAS_TCMALLOC_HEAPPROFILER = _IMP_atom.IMP_KERNEL_HAS_TCMALLOC_HEAPPROFILER

IMPKERNEL_SHOW_WARNINGS = _IMP_atom.IMPKERNEL_SHOW_WARNINGS


import sys
class _DirectorObjects(object):
    """@internal Simple class to keep references to director objects
       to prevent premature deletion."""
    def __init__(self):
        self._objects = []
    def register(self, obj):
        """Take a reference to a director object; will only work for
           refcounted C++ classes"""
        if hasattr(obj, 'get_ref_count'):
            self._objects.append(obj)
    def cleanup(self):
        """Only drop our reference and allow cleanup by Python if no other
           Python references exist (we hold 3 references: one in self._objects,
           one in x, and one in the argument list for getrefcount) *and* no
           other C++ references exist (the Python object always holds one)"""
        objs = [x for x in self._objects if sys.getrefcount(x) > 3 \
                                         or x.get_ref_count() > 1]
# Do in two steps so the references are kept until the end of the
# function (deleting references may trigger a fresh call to this method)
        self._objects = objs
    def get_object_count(self):
        """Get number of director objects (useful for testing only)"""
        return len(self._objects)
_director_objects = _DirectorObjects()

class _ostream(object):
    r"""Proxy of C++ std::ostream class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def write(self, osa_buf):
        r"""write(_ostream self, char const * osa_buf)"""
        return _IMP_atom._ostream_write(self, osa_buf)

# Register _ostream in _IMP_atom:
_IMP_atom._ostream_swigregister(_ostream)

IMP_COMPILER_HAS_OVERRIDE = _IMP_atom.IMP_COMPILER_HAS_OVERRIDE

IMP_COMPILER_HAS_FINAL = _IMP_atom.IMP_COMPILER_HAS_FINAL

IMP_HAS_NOEXCEPT = _IMP_atom.IMP_HAS_NOEXCEPT

IMP_C_OPEN_BINARY = _IMP_atom.IMP_C_OPEN_BINARY

import IMP
IMP_CGAL_HAS_BOOST_FILESYSTEM = _IMP_atom.IMP_CGAL_HAS_BOOST_FILESYSTEM

IMP_CGAL_HAS_BOOST_PROGRAMOPTIONS = _IMP_atom.IMP_CGAL_HAS_BOOST_PROGRAMOPTIONS

IMP_CGAL_HAS_BOOST_RANDOM = _IMP_atom.IMP_CGAL_HAS_BOOST_RANDOM

IMP_CGAL_HAS_BOOST_SYSTEM = _IMP_atom.IMP_CGAL_HAS_BOOST_SYSTEM

IMP_CGAL_HAS_NUMPY = _IMP_atom.IMP_CGAL_HAS_NUMPY

IMPCGAL_SHOW_WARNINGS = _IMP_atom.IMPCGAL_SHOW_WARNINGS

import IMP.cgal
IMP_ALGEBRA_HAS_IMP_CGAL = _IMP_atom.IMP_ALGEBRA_HAS_IMP_CGAL

IMP_ALGEBRA_HAS_BOOST_FILESYSTEM = _IMP_atom.IMP_ALGEBRA_HAS_BOOST_FILESYSTEM

IMP_ALGEBRA_HAS_BOOST_PROGRAMOPTIONS = _IMP_atom.IMP_ALGEBRA_HAS_BOOST_PROGRAMOPTIONS

IMP_ALGEBRA_HAS_BOOST_RANDOM = _IMP_atom.IMP_ALGEBRA_HAS_BOOST_RANDOM

IMP_ALGEBRA_HAS_BOOST_SYSTEM = _IMP_atom.IMP_ALGEBRA_HAS_BOOST_SYSTEM

IMP_ALGEBRA_HAS_CGAL = _IMP_atom.IMP_ALGEBRA_HAS_CGAL

IMP_ALGEBRA_HAS_NUMPY = _IMP_atom.IMP_ALGEBRA_HAS_NUMPY

IMP_ALGEBRA_HAS_ANN = _IMP_atom.IMP_ALGEBRA_HAS_ANN

IMPALGEBRA_SHOW_WARNINGS = _IMP_atom.IMPALGEBRA_SHOW_WARNINGS

import IMP.algebra
IMP_DISPLAY_HAS_IMP_CGAL = _IMP_atom.IMP_DISPLAY_HAS_IMP_CGAL

IMP_DISPLAY_HAS_BOOST_FILESYSTEM = _IMP_atom.IMP_DISPLAY_HAS_BOOST_FILESYSTEM

IMP_DISPLAY_HAS_BOOST_PROGRAMOPTIONS = _IMP_atom.IMP_DISPLAY_HAS_BOOST_PROGRAMOPTIONS

IMP_DISPLAY_HAS_BOOST_RANDOM = _IMP_atom.IMP_DISPLAY_HAS_BOOST_RANDOM

IMP_DISPLAY_HAS_BOOST_SYSTEM = _IMP_atom.IMP_DISPLAY_HAS_BOOST_SYSTEM

IMP_DISPLAY_HAS_CGAL = _IMP_atom.IMP_DISPLAY_HAS_CGAL

IMP_DISPLAY_HAS_NUMPY = _IMP_atom.IMP_DISPLAY_HAS_NUMPY

IMPDISPLAY_SHOW_WARNINGS = _IMP_atom.IMPDISPLAY_SHOW_WARNINGS

import IMP.display
IMP_SCORE_FUNCTOR_HAS_IMP_CGAL = _IMP_atom.IMP_SCORE_FUNCTOR_HAS_IMP_CGAL

IMP_SCORE_FUNCTOR_HAS_BOOST_FILESYSTEM = _IMP_atom.IMP_SCORE_FUNCTOR_HAS_BOOST_FILESYSTEM

IMP_SCORE_FUNCTOR_HAS_BOOST_PROGRAMOPTIONS = _IMP_atom.IMP_SCORE_FUNCTOR_HAS_BOOST_PROGRAMOPTIONS

IMP_SCORE_FUNCTOR_HAS_BOOST_RANDOM = _IMP_atom.IMP_SCORE_FUNCTOR_HAS_BOOST_RANDOM

IMP_SCORE_FUNCTOR_HAS_BOOST_SYSTEM = _IMP_atom.IMP_SCORE_FUNCTOR_HAS_BOOST_SYSTEM

IMP_SCORE_FUNCTOR_HAS_CGAL = _IMP_atom.IMP_SCORE_FUNCTOR_HAS_CGAL

IMP_SCORE_FUNCTOR_HAS_HDF5 = _IMP_atom.IMP_SCORE_FUNCTOR_HAS_HDF5

IMP_SCORE_FUNCTOR_HAS_NUMPY = _IMP_atom.IMP_SCORE_FUNCTOR_HAS_NUMPY

IMPSCOREFUNCTOR_SHOW_WARNINGS = _IMP_atom.IMPSCOREFUNCTOR_SHOW_WARNINGS

import IMP.score_functor
IMP_CORE_HAS_IMP_CGAL = _IMP_atom.IMP_CORE_HAS_IMP_CGAL

IMP_CORE_HAS_IMP_KERNEL = _IMP_atom.IMP_CORE_HAS_IMP_KERNEL

IMP_CORE_HAS_BOOST_FILESYSTEM = _IMP_atom.IMP_CORE_HAS_BOOST_FILESYSTEM

IMP_CORE_HAS_BOOST_PROGRAMOPTIONS = _IMP_atom.IMP_CORE_HAS_BOOST_PROGRAMOPTIONS

IMP_CORE_HAS_BOOST_RANDOM = _IMP_atom.IMP_CORE_HAS_BOOST_RANDOM

IMP_CORE_HAS_BOOST_SYSTEM = _IMP_atom.IMP_CORE_HAS_BOOST_SYSTEM

IMP_CORE_HAS_CGAL = _IMP_atom.IMP_CORE_HAS_CGAL

IMP_CORE_HAS_HDF5 = _IMP_atom.IMP_CORE_HAS_HDF5

IMP_CORE_HAS_NUMPY = _IMP_atom.IMP_CORE_HAS_NUMPY

IMPCORE_SHOW_WARNINGS = _IMP_atom.IMPCORE_SHOW_WARNINGS

import IMP.core
IMP_CONTAINER_HAS_IMP_ALGEBRA = _IMP_atom.IMP_CONTAINER_HAS_IMP_ALGEBRA

IMP_CONTAINER_HAS_IMP_CGAL = _IMP_atom.IMP_CONTAINER_HAS_IMP_CGAL

IMP_CONTAINER_HAS_IMP_DISPLAY = _IMP_atom.IMP_CONTAINER_HAS_IMP_DISPLAY

IMP_CONTAINER_HAS_IMP_KERNEL = _IMP_atom.IMP_CONTAINER_HAS_IMP_KERNEL

IMP_CONTAINER_HAS_IMP_SCORE_FUNCTOR = _IMP_atom.IMP_CONTAINER_HAS_IMP_SCORE_FUNCTOR

IMP_CONTAINER_HAS_BOOST_FILESYSTEM = _IMP_atom.IMP_CONTAINER_HAS_BOOST_FILESYSTEM

IMP_CONTAINER_HAS_BOOST_PROGRAMOPTIONS = _IMP_atom.IMP_CONTAINER_HAS_BOOST_PROGRAMOPTIONS

IMP_CONTAINER_HAS_BOOST_RANDOM = _IMP_atom.IMP_CONTAINER_HAS_BOOST_RANDOM

IMP_CONTAINER_HAS_BOOST_SYSTEM = _IMP_atom.IMP_CONTAINER_HAS_BOOST_SYSTEM

IMP_CONTAINER_HAS_CGAL = _IMP_atom.IMP_CONTAINER_HAS_CGAL

IMP_CONTAINER_HAS_HDF5 = _IMP_atom.IMP_CONTAINER_HAS_HDF5

IMP_CONTAINER_HAS_NUMPY = _IMP_atom.IMP_CONTAINER_HAS_NUMPY

IMP_CONTAINER_HAS_PYTHON_IHM = _IMP_atom.IMP_CONTAINER_HAS_PYTHON_IHM

IMP_CONTAINER_HAS_GOOGLE_DENSE_HASH_MAP = _IMP_atom.IMP_CONTAINER_HAS_GOOGLE_DENSE_HASH_MAP

IMP_CONTAINER_HAS_ROBIN_MAP = _IMP_atom.IMP_CONTAINER_HAS_ROBIN_MAP

IMPCONTAINER_SHOW_WARNINGS = _IMP_atom.IMPCONTAINER_SHOW_WARNINGS

import IMP.container
IMP_ATOM_HAS_IMP_CGAL = _IMP_atom.IMP_ATOM_HAS_IMP_CGAL

IMP_ATOM_HAS_IMP_KERNEL = _IMP_atom.IMP_ATOM_HAS_IMP_KERNEL

IMP_ATOM_HAS_IMP_SCORE_FUNCTOR = _IMP_atom.IMP_ATOM_HAS_IMP_SCORE_FUNCTOR

IMP_ATOM_HAS_BOOST_PROGRAMOPTIONS = _IMP_atom.IMP_ATOM_HAS_BOOST_PROGRAMOPTIONS

IMP_ATOM_HAS_BOOST_RANDOM = _IMP_atom.IMP_ATOM_HAS_BOOST_RANDOM

IMP_ATOM_HAS_BOOST_REGEX = _IMP_atom.IMP_ATOM_HAS_BOOST_REGEX

IMP_ATOM_HAS_BOOST_SYSTEM = _IMP_atom.IMP_ATOM_HAS_BOOST_SYSTEM

IMP_ATOM_HAS_CGAL = _IMP_atom.IMP_ATOM_HAS_CGAL

IMP_ATOM_HAS_HDF5 = _IMP_atom.IMP_ATOM_HAS_HDF5

IMP_ATOM_HAS_NUMPY = _IMP_atom.IMP_ATOM_HAS_NUMPY

IMP_ATOM_HAS_PYTHON_IHM = _IMP_atom.IMP_ATOM_HAS_PYTHON_IHM

IMPATOM_SHOW_WARNINGS = _IMP_atom.IMPATOM_SHOW_WARNINGS

IMP_ATOM_TYPE_INDEX = _IMP_atom.IMP_ATOM_TYPE_INDEX

IMP_RESIDUE_TYPE_INDEX = _IMP_atom.IMP_RESIDUE_TYPE_INDEX

IMP_HIERARCHY_TYPE_INDEX = _IMP_atom.IMP_HIERARCHY_TYPE_INDEX

IMP_CHAIN_TYPE_INDEX = _IMP_atom.IMP_CHAIN_TYPE_INDEX

class HierarchyTree(IMP.Object):
    r"""Proxy of C++ IMP::internal::BoostDigraph< IMP::atom::HierarchyTree,IMP::atom::Hierarchy,IMP::atom::ShowHierarchyTreeVertex > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""__init__(HierarchyTree self) -> HierarchyTree"""
        _IMP_atom.HierarchyTree_swiginit(self, _IMP_atom.new_HierarchyTree())

    def get_graph(self):
        r"""get_graph(HierarchyTree self) -> IMP::atom::HierarchyTree const &"""
        return _IMP_atom.HierarchyTree_get_graph(self)

    def get_vertices(self):
        r"""get_vertices(HierarchyTree self) -> IMP::internal::BoostDigraph< IMP::atom::HierarchyTree,IMP::atom::Hierarchy,IMP::atom::ShowHierarchyTreeVertex >::VertexDescriptors"""
        return _IMP_atom.HierarchyTree_get_vertices(self)

    def get_vertex_name(self, i):
        r"""get_vertex_name(HierarchyTree self, IMP::internal::BoostDigraph< IMP::atom::HierarchyTree,IMP::atom::Hierarchy,IMP::atom::ShowHierarchyTreeVertex >::VertexDescriptor i) -> Hierarchy"""
        return _IMP_atom.HierarchyTree_get_vertex_name(self, i)

    def get_in_neighbors(self, v):
        r"""get_in_neighbors(HierarchyTree self, IMP::internal::BoostDigraph< IMP::atom::HierarchyTree,IMP::atom::Hierarchy,IMP::atom::ShowHierarchyTreeVertex >::VertexDescriptor v) -> IMP::internal::BoostDigraph< IMP::atom::HierarchyTree,IMP::atom::Hierarchy,IMP::atom::ShowHierarchyTreeVertex >::VertexDescriptors"""
        return _IMP_atom.HierarchyTree_get_in_neighbors(self, v)

    def get_out_neighbors(self, v):
        r"""get_out_neighbors(HierarchyTree self, IMP::internal::BoostDigraph< IMP::atom::HierarchyTree,IMP::atom::Hierarchy,IMP::atom::ShowHierarchyTreeVertex >::VertexDescriptor v) -> IMP::internal::BoostDigraph< IMP::atom::HierarchyTree,IMP::atom::Hierarchy,IMP::atom::ShowHierarchyTreeVertex >::VertexDescriptors"""
        return _IMP_atom.HierarchyTree_get_out_neighbors(self, v)

    def show_graphviz(self, *args):
        r"""show_graphviz(HierarchyTree self, _ostream out=std::cout)"""
        return _IMP_atom.HierarchyTree_show_graphviz(self, *args)

    def get_graphviz_string(self):
        r"""get_graphviz_string(HierarchyTree self) -> std::string"""
        return _IMP_atom.HierarchyTree_get_graphviz_string(self)

    def add_edge(self, v0, v1):
        r"""add_edge(HierarchyTree self, IMP::internal::BoostDigraph< IMP::atom::HierarchyTree,IMP::atom::Hierarchy,IMP::atom::ShowHierarchyTreeVertex >::VertexDescriptor v0, IMP::internal::BoostDigraph< IMP::atom::HierarchyTree,IMP::atom::Hierarchy,IMP::atom::ShowHierarchyTreeVertex >::VertexDescriptor v1)"""
        return _IMP_atom.HierarchyTree_add_edge(self, v0, v1)

    def add_vertex(self, l):
        r"""add_vertex(HierarchyTree self, Hierarchy l) -> IMP::internal::BoostDigraph< IMP::atom::HierarchyTree,IMP::atom::Hierarchy,IMP::atom::ShowHierarchyTreeVertex >::VertexDescriptor"""
        return _IMP_atom.HierarchyTree_add_vertex(self, l)

    def remove_vertex(self, l):
        r"""remove_vertex(HierarchyTree self, IMP::internal::BoostDigraph< IMP::atom::HierarchyTree,IMP::atom::Hierarchy,IMP::atom::ShowHierarchyTreeVertex >::VertexDescriptor l)"""
        return _IMP_atom.HierarchyTree_remove_vertex(self, l)
    __swig_destroy__ = _IMP_atom.delete_HierarchyTree

# Register HierarchyTree in _IMP_atom:
_IMP_atom.HierarchyTree_swigregister(HierarchyTree)


_value_types.append("HierarchyTree")


_object_types.append("PDBSelector")


def _object_cast_to_PDBSelector(o):
    r"""_object_cast_to_PDBSelector(Object o) -> PDBSelector"""
    return _IMP_atom._object_cast_to_PDBSelector(o)

def Angles(l=[]):
    return [Angle(x) for x in l]
_plural_types.append("Angles")


_value_types.append("Angle")


def Atoms(l=[]):
    return [Atom(x) for x in l]
_plural_types.append("Atoms")


_value_types.append("Atom")


def Bonds(l=[]):
    return [Bond(x) for x in l]
_plural_types.append("Bonds")


_value_types.append("Bond")


def Bondeds(l=[]):
    return [Bonded(x) for x in l]
_plural_types.append("Bondeds")


_value_types.append("Bonded")


def CHARMMAtomList(l=[]):
    return [CHARMMAtom(x) for x in l]
_plural_types.append("CHARMMAtomList")


_value_types.append("CHARMMAtom")


def Chains(l=[]):
    return [Chain(x) for x in l]
_plural_types.append("Chains")


_value_types.append("Chain")


def CenterOfMasses(l=[]):
    return [CenterOfMass(x) for x in l]
_plural_types.append("CenterOfMasses")


_value_types.append("CenterOfMass")


def Chargeds(l=[]):
    return [Charged(x) for x in l]
_plural_types.append("Chargeds")


_value_types.append("Charged")


def Diffusions(l=[]):
    return [Diffusion(x) for x in l]
_plural_types.append("Diffusions")


_value_types.append("Diffusion")


def RigidBodyDiffusions(l=[]):
    return [RigidBodyDiffusion(x) for x in l]
_plural_types.append("RigidBodyDiffusions")


_value_types.append("RigidBodyDiffusion")


def TAMDParticles(l=[]):
    return [TAMDParticle(x) for x in l]
_plural_types.append("TAMDParticles")


_value_types.append("TAMDParticle")


def TAMDCentroids(l=[]):
    return [TAMDCentroid(x) for x in l]
_plural_types.append("TAMDCentroids")


_value_types.append("TAMDCentroid")


def Dihedrals(l=[]):
    return [Dihedral(x) for x in l]
_plural_types.append("Dihedrals")


_value_types.append("Dihedral")


def Domains(l=[]):
    return [Domain(x) for x in l]
_plural_types.append("Domains")


_value_types.append("Domain")


def Fragments(l=[]):
    return [Fragment(x) for x in l]
_plural_types.append("Fragments")


_value_types.append("Fragment")


def Hierarchies(l=[]):
    return [Hierarchy(x) for x in l]
_plural_types.append("Hierarchies")


_value_types.append("Hierarchy")


def LennardJonesList(l=[]):
    return [LennardJones(x) for x in l]
_plural_types.append("LennardJonesList")


_value_types.append("LennardJones")


def Masses(l=[]):
    return [Mass(x) for x in l]
_plural_types.append("Masses")


_value_types.append("Mass")


def LinearVelocities(l=[]):
    return [LinearVelocity(x) for x in l]
_plural_types.append("LinearVelocities")


_value_types.append("LinearVelocity")


def AngularVelocities(l=[]):
    return [AngularVelocity(x) for x in l]
_plural_types.append("AngularVelocities")


_value_types.append("AngularVelocity")


def Molecules(l=[]):
    return [Molecule(x) for x in l]
_plural_types.append("Molecules")


_value_types.append("Molecule")


def Residues(l=[]):
    return [Residue(x) for x in l]
_plural_types.append("Residues")


_value_types.append("Residue")


def Representations(l=[]):
    return [Representation(x) for x in l]
_plural_types.append("Representations")


_value_types.append("Representation")


def States(l=[]):
    return [State(x) for x in l]
_plural_types.append("States")


_value_types.append("State")


def Copies(l=[]):
    return [Copy(x) for x in l]
_plural_types.append("Copies")


_value_types.append("Copy")


def SecondaryStructureResidues(l=[]):
    return [SecondaryStructureResidue(x) for x in l]
_plural_types.append("SecondaryStructureResidues")


_value_types.append("SecondaryStructureResidue")


def StructureSources(l=[]):
    return [StructureSource(x) for x in l]
_plural_types.append("StructureSources")


_value_types.append("StructureSource")


_object_types.append("Simulator")


def _object_cast_to_Simulator(o):
    r"""_object_cast_to_Simulator(Object o) -> Simulator"""
    return _IMP_atom._object_cast_to_Simulator(o)

_object_types.append("ATOMPDBSelector")


def _object_cast_to_ATOMPDBSelector(o):
    r"""_object_cast_to_ATOMPDBSelector(Object o) -> ATOMPDBSelector"""
    return _IMP_atom._object_cast_to_ATOMPDBSelector(o)

_object_types.append("AllMol2Selector")


def _object_cast_to_AllMol2Selector(o):
    r"""_object_cast_to_AllMol2Selector(Object o) -> AllMol2Selector"""
    return _IMP_atom._object_cast_to_AllMol2Selector(o)

_object_types.append("AllPDBSelector")


def _object_cast_to_AllPDBSelector(o):
    r"""_object_cast_to_AllPDBSelector(Object o) -> AllPDBSelector"""
    return _IMP_atom._object_cast_to_AllPDBSelector(o)

_object_types.append("AndPDBSelector")


def _object_cast_to_AndPDBSelector(o):
    r"""_object_cast_to_AndPDBSelector(Object o) -> AndPDBSelector"""
    return _IMP_atom._object_cast_to_AndPDBSelector(o)

_object_types.append("XorPDBSelector")


def _object_cast_to_XorPDBSelector(o):
    r"""_object_cast_to_XorPDBSelector(Object o) -> XorPDBSelector"""
    return _IMP_atom._object_cast_to_XorPDBSelector(o)

_object_types.append("ResidueTypePDBSelector")


def _object_cast_to_ResidueTypePDBSelector(o):
    r"""_object_cast_to_ResidueTypePDBSelector(Object o) -> ResidueTypePDBSelector"""
    return _IMP_atom._object_cast_to_ResidueTypePDBSelector(o)

_object_types.append("AtomTypePDBSelector")


def _object_cast_to_AtomTypePDBSelector(o):
    r"""_object_cast_to_AtomTypePDBSelector(Object o) -> AtomTypePDBSelector"""
    return _IMP_atom._object_cast_to_AtomTypePDBSelector(o)

_object_types.append("AngleSingletonScore")


def _object_cast_to_AngleSingletonScore(o):
    r"""_object_cast_to_AngleSingletonScore(Object o) -> AngleSingletonScore"""
    return _IMP_atom._object_cast_to_AngleSingletonScore(o)

_object_types.append("BondEndpointsRefiner")


def _object_cast_to_BondEndpointsRefiner(o):
    r"""_object_cast_to_BondEndpointsRefiner(Object o) -> BondEndpointsRefiner"""
    return _IMP_atom._object_cast_to_BondEndpointsRefiner(o)

_object_types.append("BondPairContainer")


def _object_cast_to_BondPairContainer(o):
    r"""_object_cast_to_BondPairContainer(Object o) -> BondPairContainer"""
    return _IMP_atom._object_cast_to_BondPairContainer(o)

_object_types.append("BondSingletonScore")


def _object_cast_to_BondSingletonScore(o):
    r"""_object_cast_to_BondSingletonScore(Object o) -> BondSingletonScore"""
    return _IMP_atom._object_cast_to_BondSingletonScore(o)

_object_types.append("BondedPairFilter")


def _object_cast_to_BondedPairFilter(o):
    r"""_object_cast_to_BondedPairFilter(Object o) -> BondedPairFilter"""
    return _IMP_atom._object_cast_to_BondedPairFilter(o)

_object_types.append("BrownianDynamics")


def _object_cast_to_BrownianDynamics(o):
    r"""_object_cast_to_BrownianDynamics(Object o) -> BrownianDynamics"""
    return _IMP_atom._object_cast_to_BrownianDynamics(o)

_object_types.append("BrownianDynamicsTAMD")


def _object_cast_to_BrownianDynamicsTAMD(o):
    r"""_object_cast_to_BrownianDynamicsTAMD(Object o) -> BrownianDynamicsTAMD"""
    return _IMP_atom._object_cast_to_BrownianDynamicsTAMD(o)

_object_types.append("CAlphaPDBSelector")


def _object_cast_to_CAlphaPDBSelector(o):
    r"""_object_cast_to_CAlphaPDBSelector(Object o) -> CAlphaPDBSelector"""
    return _IMP_atom._object_cast_to_CAlphaPDBSelector(o)

_object_types.append("CBetaPDBSelector")


def _object_cast_to_CBetaPDBSelector(o):
    r"""_object_cast_to_CBetaPDBSelector(Object o) -> CBetaPDBSelector"""
    return _IMP_atom._object_cast_to_CBetaPDBSelector(o)

_object_types.append("BackbonePDBSelector")


def _object_cast_to_BackbonePDBSelector(o):
    r"""_object_cast_to_BackbonePDBSelector(Object o) -> BackbonePDBSelector"""
    return _IMP_atom._object_cast_to_BackbonePDBSelector(o)

_object_types.append("CHARMMParameters")


def _object_cast_to_CHARMMParameters(o):
    r"""_object_cast_to_CHARMMParameters(Object o) -> CHARMMParameters"""
    return _IMP_atom._object_cast_to_CHARMMParameters(o)

_object_types.append("CHARMMResidueTopology")


def _object_cast_to_CHARMMResidueTopology(o):
    r"""_object_cast_to_CHARMMResidueTopology(Object o) -> CHARMMResidueTopology"""
    return _IMP_atom._object_cast_to_CHARMMResidueTopology(o)

_object_types.append("CHARMMSegmentTopology")


def _object_cast_to_CHARMMSegmentTopology(o):
    r"""_object_cast_to_CHARMMSegmentTopology(Object o) -> CHARMMSegmentTopology"""
    return _IMP_atom._object_cast_to_CHARMMSegmentTopology(o)

_object_types.append("CHARMMStereochemistryRestraint")


def _object_cast_to_CHARMMStereochemistryRestraint(o):
    r"""_object_cast_to_CHARMMStereochemistryRestraint(Object o) -> CHARMMStereochemistryRestraint"""
    return _IMP_atom._object_cast_to_CHARMMStereochemistryRestraint(o)

_object_types.append("CHARMMTopology")


def _object_cast_to_CHARMMTopology(o):
    r"""_object_cast_to_CHARMMTopology(Object o) -> CHARMMTopology"""
    return _IMP_atom._object_cast_to_CHARMMTopology(o)

_object_types.append("CPDBSelector")


def _object_cast_to_CPDBSelector(o):
    r"""_object_cast_to_CPDBSelector(Object o) -> CPDBSelector"""
    return _IMP_atom._object_cast_to_CPDBSelector(o)

_object_types.append("ChainPDBSelector")


def _object_cast_to_ChainPDBSelector(o):
    r"""_object_cast_to_ChainPDBSelector(Object o) -> ChainPDBSelector"""
    return _IMP_atom._object_cast_to_ChainPDBSelector(o)

_object_types.append("CoulombPairScore")


def _object_cast_to_CoulombPairScore(o):
    r"""_object_cast_to_CoulombPairScore(Object o) -> CoulombPairScore"""
    return _IMP_atom._object_cast_to_CoulombPairScore(o)

_object_types.append("CoverBond")


def _object_cast_to_CoverBond(o):
    r"""_object_cast_to_CoverBond(Object o) -> CoverBond"""
    return _IMP_atom._object_cast_to_CoverBond(o)

_object_types.append("DihedralSingletonScore")


def _object_cast_to_DihedralSingletonScore(o):
    r"""_object_cast_to_DihedralSingletonScore(Object o) -> DihedralSingletonScore"""
    return _IMP_atom._object_cast_to_DihedralSingletonScore(o)

_object_types.append("DopePairScore")


def _object_cast_to_DopePairScore(o):
    r"""_object_cast_to_DopePairScore(Object o) -> DopePairScore"""
    return _IMP_atom._object_cast_to_DopePairScore(o)

_object_types.append("LoopStatisticalPairScore")


def _object_cast_to_LoopStatisticalPairScore(o):
    r"""_object_cast_to_LoopStatisticalPairScore(Object o) -> LoopStatisticalPairScore"""
    return _IMP_atom._object_cast_to_LoopStatisticalPairScore(o)

_object_types.append("OrientedSoapPairScore")


def _object_cast_to_OrientedSoapPairScore(o):
    r"""_object_cast_to_OrientedSoapPairScore(Object o) -> OrientedSoapPairScore"""
    return _IMP_atom._object_cast_to_OrientedSoapPairScore(o)

_object_types.append("EzRestraint")


def _object_cast_to_EzRestraint(o):
    r"""_object_cast_to_EzRestraint(Object o) -> EzRestraint"""
    return _IMP_atom._object_cast_to_EzRestraint(o)

_object_types.append("ForceFieldParameters")


def _object_cast_to_ForceFieldParameters(o):
    r"""_object_cast_to_ForceFieldParameters(Object o) -> ForceFieldParameters"""
    return _IMP_atom._object_cast_to_ForceFieldParameters(o)

_object_types.append("ForceSwitch")


def _object_cast_to_ForceSwitch(o):
    r"""_object_cast_to_ForceSwitch(Object o) -> ForceSwitch"""
    return _IMP_atom._object_cast_to_ForceSwitch(o)

_object_types.append("HydrogenPDBSelector")


def _object_cast_to_HydrogenPDBSelector(o):
    r"""_object_cast_to_HydrogenPDBSelector(Object o) -> HydrogenPDBSelector"""
    return _IMP_atom._object_cast_to_HydrogenPDBSelector(o)

_object_types.append("ImproperSingletonScore")


def _object_cast_to_ImproperSingletonScore(o):
    r"""_object_cast_to_ImproperSingletonScore(Object o) -> ImproperSingletonScore"""
    return _IMP_atom._object_cast_to_ImproperSingletonScore(o)

_object_types.append("LennardJonesPairScore")


def _object_cast_to_LennardJonesPairScore(o):
    r"""_object_cast_to_LennardJonesPairScore(Object o) -> LennardJonesPairScore"""
    return _IMP_atom._object_cast_to_LennardJonesPairScore(o)

_object_types.append("Mol2Selector")


def _object_cast_to_Mol2Selector(o):
    r"""_object_cast_to_Mol2Selector(Object o) -> Mol2Selector"""
    return _IMP_atom._object_cast_to_Mol2Selector(o)

_object_types.append("MolecularDynamics")


def _object_cast_to_MolecularDynamics(o):
    r"""_object_cast_to_MolecularDynamics(Object o) -> MolecularDynamics"""
    return _IMP_atom._object_cast_to_MolecularDynamics(o)

_object_types.append("NPDBSelector")


def _object_cast_to_NPDBSelector(o):
    r"""_object_cast_to_NPDBSelector(Object o) -> NPDBSelector"""
    return _IMP_atom._object_cast_to_NPDBSelector(o)

_object_types.append("NonAlternativePDBSelector")


def _object_cast_to_NonAlternativePDBSelector(o):
    r"""_object_cast_to_NonAlternativePDBSelector(Object o) -> NonAlternativePDBSelector"""
    return _IMP_atom._object_cast_to_NonAlternativePDBSelector(o)

_object_types.append("NonHydrogenMol2Selector")


def _object_cast_to_NonHydrogenMol2Selector(o):
    r"""_object_cast_to_NonHydrogenMol2Selector(Object o) -> NonHydrogenMol2Selector"""
    return _IMP_atom._object_cast_to_NonHydrogenMol2Selector(o)

_object_types.append("NonHydrogenPDBSelector")


def _object_cast_to_NonHydrogenPDBSelector(o):
    r"""_object_cast_to_NonHydrogenPDBSelector(Object o) -> NonHydrogenPDBSelector"""
    return _IMP_atom._object_cast_to_NonHydrogenPDBSelector(o)

_object_types.append("NonWaterNonHydrogenPDBSelector")


def _object_cast_to_NonWaterNonHydrogenPDBSelector(o):
    r"""_object_cast_to_NonWaterNonHydrogenPDBSelector(Object o) -> NonWaterNonHydrogenPDBSelector"""
    return _IMP_atom._object_cast_to_NonWaterNonHydrogenPDBSelector(o)

_object_types.append("NonWaterPDBSelector")


def _object_cast_to_NonWaterPDBSelector(o):
    r"""_object_cast_to_NonWaterPDBSelector(Object o) -> NonWaterPDBSelector"""
    return _IMP_atom._object_cast_to_NonWaterPDBSelector(o)

_object_types.append("NotPDBSelector")


def _object_cast_to_NotPDBSelector(o):
    r"""_object_cast_to_NotPDBSelector(Object o) -> NotPDBSelector"""
    return _IMP_atom._object_cast_to_NotPDBSelector(o)

_object_types.append("OrPDBSelector")


def _object_cast_to_OrPDBSelector(o):
    r"""_object_cast_to_OrPDBSelector(Object o) -> OrPDBSelector"""
    return _IMP_atom._object_cast_to_OrPDBSelector(o)

_object_types.append("PPDBSelector")


def _object_cast_to_PPDBSelector(o):
    r"""_object_cast_to_PPDBSelector(Object o) -> PPDBSelector"""
    return _IMP_atom._object_cast_to_PPDBSelector(o)

_object_types.append("ProteinLigandAtomPairScore")


def _object_cast_to_ProteinLigandAtomPairScore(o):
    r"""_object_cast_to_ProteinLigandAtomPairScore(Object o) -> ProteinLigandAtomPairScore"""
    return _IMP_atom._object_cast_to_ProteinLigandAtomPairScore(o)

_object_types.append("ProteinLigandRestraint")


def _object_cast_to_ProteinLigandRestraint(o):
    r"""_object_cast_to_ProteinLigandRestraint(Object o) -> ProteinLigandRestraint"""
    return _IMP_atom._object_cast_to_ProteinLigandRestraint(o)

_object_types.append("SameResiduePairFilter")


def _object_cast_to_SameResiduePairFilter(o):
    r"""_object_cast_to_SameResiduePairFilter(Object o) -> SameResiduePairFilter"""
    return _IMP_atom._object_cast_to_SameResiduePairFilter(o)

_object_types.append("SoapPairFilter")


def _object_cast_to_SoapPairFilter(o):
    r"""_object_cast_to_SoapPairFilter(Object o) -> SoapPairFilter"""
    return _IMP_atom._object_cast_to_SoapPairFilter(o)

_object_types.append("SmoothingFunction")


def _object_cast_to_SmoothingFunction(o):
    r"""_object_cast_to_SmoothingFunction(Object o) -> SmoothingFunction"""
    return _IMP_atom._object_cast_to_SmoothingFunction(o)

_object_types.append("StereochemistryPairFilter")


def _object_cast_to_StereochemistryPairFilter(o):
    r"""_object_cast_to_StereochemistryPairFilter(Object o) -> StereochemistryPairFilter"""
    return _IMP_atom._object_cast_to_StereochemistryPairFilter(o)

_object_types.append("VelocityScalingOptimizerState")


def _object_cast_to_VelocityScalingOptimizerState(o):
    r"""_object_cast_to_VelocityScalingOptimizerState(Object o) -> VelocityScalingOptimizerState"""
    return _IMP_atom._object_cast_to_VelocityScalingOptimizerState(o)

_object_types.append("WaterPDBSelector")


def _object_cast_to_WaterPDBSelector(o):
    r"""_object_cast_to_WaterPDBSelector(Object o) -> WaterPDBSelector"""
    return _IMP_atom._object_cast_to_WaterPDBSelector(o)

_object_types.append("WritePDBOptimizerState")


def _object_cast_to_WritePDBOptimizerState(o):
    r"""_object_cast_to_WritePDBOptimizerState(Object o) -> WritePDBOptimizerState"""
    return _IMP_atom._object_cast_to_WritePDBOptimizerState(o)

AtomTypes=list
_plural_types.append("AtomTypes")
_value_types.append("AtomType")


CHARMMAtomTopologies=list
_plural_types.append("CHARMMAtomTopologies")
_value_types.append("CHARMMAtomTopology")


CHARMMBondEndpoints=list
_plural_types.append("CHARMMBondEndpoints")
_value_types.append("CHARMMBondEndpoint")


CHARMMBondParametersList=list
_plural_types.append("CHARMMBondParametersList")
_value_types.append("CHARMMBondParameters")


CHARMMDihedralParametersList=list
_plural_types.append("CHARMMDihedralParametersList")
_value_types.append("CHARMMDihedralParameters")


_object_types.append("CHARMMIdealResidueTopology")


def _object_cast_to_CHARMMIdealResidueTopology(o):
    r"""_object_cast_to_CHARMMIdealResidueTopology(Object o) -> CHARMMIdealResidueTopology"""
    return _IMP_atom._object_cast_to_CHARMMIdealResidueTopology(o)

CHARMMInternalCoordinates=list
_plural_types.append("CHARMMInternalCoordinates")
_value_types.append("CHARMMInternalCoordinate")


_object_types.append("CHARMMPatch")


def _object_cast_to_CHARMMPatch(o):
    r"""_object_cast_to_CHARMMPatch(Object o) -> CHARMMPatch"""
    return _IMP_atom._object_cast_to_CHARMMPatch(o)

_object_types.append("CHARMMResidueTopologyBase")


def _object_cast_to_CHARMMResidueTopologyBase(o):
    r"""_object_cast_to_CHARMMResidueTopologyBase(Object o) -> CHARMMResidueTopologyBase"""
    return _IMP_atom._object_cast_to_CHARMMResidueTopologyBase(o)

ResidueTypes=list
_plural_types.append("ResidueTypes")
_value_types.append("ResidueType")


ChainTypes=list
_plural_types.append("ChainTypes")
_value_types.append("ChainType")


Selections=list
_plural_types.append("Selections")
_value_types.append("Selection")


_object_types.append("RemoveRigidMotionOptimizerState")


def _object_cast_to_RemoveRigidMotionOptimizerState(o):
    r"""_object_cast_to_RemoveRigidMotionOptimizerState(Object o) -> RemoveRigidMotionOptimizerState"""
    return _IMP_atom._object_cast_to_RemoveRigidMotionOptimizerState(o)

_object_types.append("BerendsenThermostatOptimizerState")


def _object_cast_to_BerendsenThermostatOptimizerState(o):
    r"""_object_cast_to_BerendsenThermostatOptimizerState(Object o) -> BerendsenThermostatOptimizerState"""
    return _IMP_atom._object_cast_to_BerendsenThermostatOptimizerState(o)

_object_types.append("LangevinThermostatOptimizerState")


def _object_cast_to_LangevinThermostatOptimizerState(o):
    r"""_object_cast_to_LangevinThermostatOptimizerState(Object o) -> LangevinThermostatOptimizerState"""
    return _IMP_atom._object_cast_to_LangevinThermostatOptimizerState(o)

_object_types.append("SelectionGeometry")


def _object_cast_to_SelectionGeometry(o):
    r"""_object_cast_to_SelectionGeometry(Object o) -> SelectionGeometry"""
    return _IMP_atom._object_cast_to_SelectionGeometry(o)

_object_types.append("HierarchyGeometry")


def _object_cast_to_HierarchyGeometry(o):
    r"""_object_cast_to_HierarchyGeometry(Object o) -> HierarchyGeometry"""
    return _IMP_atom._object_cast_to_HierarchyGeometry(o)

_object_types.append("HierarchiesGeometry")


def _object_cast_to_HierarchiesGeometry(o):
    r"""_object_cast_to_HierarchiesGeometry(Object o) -> HierarchiesGeometry"""
    return _IMP_atom._object_cast_to_HierarchiesGeometry(o)

_object_types.append("BondGeometry")


def _object_cast_to_BondGeometry(o):
    r"""_object_cast_to_BondGeometry(Object o) -> BondGeometry"""
    return _IMP_atom._object_cast_to_BondGeometry(o)

_object_types.append("BondsGeometry")


def _object_cast_to_BondsGeometry(o):
    r"""_object_cast_to_BondsGeometry(Object o) -> BondsGeometry"""
    return _IMP_atom._object_cast_to_BondsGeometry(o)

_object_types.append("CAAngleRestraint")


def _object_cast_to_CAAngleRestraint(o):
    r"""_object_cast_to_CAAngleRestraint(Object o) -> CAAngleRestraint"""
    return _IMP_atom._object_cast_to_CAAngleRestraint(o)

_object_types.append("CADihedralRestraint")


def _object_cast_to_CADihedralRestraint(o):
    r"""_object_cast_to_CADihedralRestraint(Object o) -> CADihedralRestraint"""
    return _IMP_atom._object_cast_to_CADihedralRestraint(o)

_object_types.append("HelixRestraint")


def _object_cast_to_HelixRestraint(o):
    r"""_object_cast_to_HelixRestraint(Object o) -> HelixRestraint"""
    return _IMP_atom._object_cast_to_HelixRestraint(o)

CHARMMDihedrals=list
_plural_types.append("CHARMMDihedrals")
_value_types.append("CHARMMDihedral")


CHARMMBonds=list
_plural_types.append("CHARMMBonds")
_value_types.append("CHARMMBond")


CHARMMAngles=list
_plural_types.append("CHARMMAngles")
_value_types.append("CHARMMAngle")

class Bond(IMP.Decorator):
    r"""Proxy of C++ IMP::atom::Bond class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(Bond self) -> Bond
        __init__(Bond self, Model m, ParticleIndex id) -> Bond
        __init__(Bond self, _ParticleAdaptor d) -> Bond
        """
        _IMP_atom.Bond_swiginit(self, _IMP_atom.new_Bond(*args))

    def show(self, *args):
        r"""show(Bond self, _ostream out=std::cout)"""
        return _IMP_atom.Bond_show(self, *args)

    @staticmethod
    def get_is_setup(*args):
        r"""
        get_is_setup(_ParticleAdaptor p) -> bool
        get_is_setup(Model m, ParticleIndex pi) -> bool
        """
        return _IMP_atom.Bond_get_is_setup(*args)
    UNKNOWN = _IMP_atom.Bond_UNKNOWN
    
    NONBIOLOGICAL = _IMP_atom.Bond_NONBIOLOGICAL
    
    SINGLE = _IMP_atom.Bond_SINGLE
    
    DOUBLE = _IMP_atom.Bond_DOUBLE
    
    TRIPLE = _IMP_atom.Bond_TRIPLE
    
    HYDROGEN = _IMP_atom.Bond_HYDROGEN
    
    SALT = _IMP_atom.Bond_SALT
    
    PEPTIDE = _IMP_atom.Bond_PEPTIDE
    
    AMIDE = _IMP_atom.Bond_AMIDE
    
    AROMATIC = _IMP_atom.Bond_AROMATIC
    

    def get_bonded(self, i):
        r"""get_bonded(Bond self, unsigned int i) -> Bonded"""
        return _IMP_atom.Bond_get_bonded(self, i)

    def get_type(self):
        r"""get_type(Bond self) -> IMP::Int"""
        return _IMP_atom.Bond_get_type(self)

    def set_type(self, t):
        r"""set_type(Bond self, IMP::Int t)"""
        return _IMP_atom.Bond_set_type(self, t)

    def get_order(self):
        r"""get_order(Bond self) -> IMP::Int"""
        return _IMP_atom.Bond_get_order(self)

    def set_order(self, t):
        r"""set_order(Bond self, IMP::Int t)"""
        return _IMP_atom.Bond_set_order(self, t)

    def get_length(self):
        r"""get_length(Bond self) -> IMP::Float"""
        return _IMP_atom.Bond_get_length(self)

    def set_length(self, t):
        r"""set_length(Bond self, IMP::Float t)"""
        return _IMP_atom.Bond_set_length(self, t)

    def get_stiffness(self):
        r"""get_stiffness(Bond self) -> IMP::Float"""
        return _IMP_atom.Bond_get_stiffness(self)

    def set_stiffness(self, t):
        r"""set_stiffness(Bond self, IMP::Float t)"""
        return _IMP_atom.Bond_set_stiffness(self, t)

    @staticmethod
    def get_length_key():
        r"""get_length_key() -> FloatKey"""
        return _IMP_atom.Bond_get_length_key()

    def add_attribute(self, *args):
        r"""
        add_attribute(Bond self, FloatKey k, IMP::Float v, bool opt)
        add_attribute(Bond self, FloatKey a0, IMP::Float a1)
        add_attribute(Bond self, IntKey a0, IMP::Int a1)
        add_attribute(Bond self, FloatsKey a0, IMP::Floats a1)
        add_attribute(Bond self, IntsKey a0, IMP::Ints a1)
        add_attribute(Bond self, StringKey a0, IMP::String a1)
        add_attribute(Bond self, ParticleIndexKey a0, Particle a1)
        add_attribute(Bond self, ObjectKey a0, Object a1)
        """
        return _IMP_atom.Bond_add_attribute(self, *args)

    def get_value(self, *args):
        r"""
        get_value(Bond self, FloatKey a0) -> IMP::Float
        get_value(Bond self, IntKey a0) -> IMP::Int
        get_value(Bond self, FloatsKey a0) -> IMP::Floats
        get_value(Bond self, IntsKey a0) -> IMP::Ints
        get_value(Bond self, StringKey a0) -> IMP::String
        get_value(Bond self, ParticleIndexKey a0) -> Particle
        get_value(Bond self, ObjectKey a0) -> Object
        """
        return _IMP_atom.Bond_get_value(self, *args)

    def set_value(self, *args):
        r"""
        set_value(Bond self, FloatKey a0, IMP::Float a1)
        set_value(Bond self, IntKey a0, IMP::Int a1)
        set_value(Bond self, FloatsKey a0, IMP::Floats a1)
        set_value(Bond self, IntsKey a0, IMP::Ints a1)
        set_value(Bond self, StringKey a0, IMP::String a1)
        set_value(Bond self, ParticleIndexKey a0, Particle a1)
        set_value(Bond self, ObjectKey a0, Object a1)
        """
        return _IMP_atom.Bond_set_value(self, *args)

    def remove_attribute(self, *args):
        r"""
        remove_attribute(Bond self, FloatKey a0)
        remove_attribute(Bond self, IntKey a0)
        remove_attribute(Bond self, FloatsKey a0)
        remove_attribute(Bond self, IntsKey a0)
        remove_attribute(Bond self, StringKey a0)
        remove_attribute(Bond self, ParticleIndexKey a0)
        remove_attribute(Bond self, ObjectKey a0)
        """
        return _IMP_atom.Bond_remove_attribute(self, *args)

    def has_attribute(self, *args):
        r"""
        has_attribute(Bond self, FloatKey a0) -> bool
        has_attribute(Bond self, IntKey a0) -> bool
        has_attribute(Bond self, FloatsKey a0) -> bool
        has_attribute(Bond self, IntsKey a0) -> bool
        has_attribute(Bond self, StringKey a0) -> bool
        has_attribute(Bond self, ParticleIndexKey a0) -> bool
        has_attribute(Bond self, ObjectKey a0) -> bool
        """
        return _IMP_atom.Bond_has_attribute(self, *args)

    def get_derivative(self, a0):
        r"""get_derivative(Bond self, FloatKey a0) -> double"""
        return _IMP_atom.Bond_get_derivative(self, a0)

    def get_name(self):
        r"""get_name(Bond self) -> std::string"""
        return _IMP_atom.Bond_get_name(self)

    def clear_caches(self):
        r"""clear_caches(Bond self)"""
        return _IMP_atom.Bond_clear_caches(self)

    def set_name(self, a0):
        r"""set_name(Bond self, std::string a0)"""
        return _IMP_atom.Bond_set_name(self, a0)

    def set_check_level(self, a0):
        r"""set_check_level(Bond self, IMP::CheckLevel a0)"""
        return _IMP_atom.Bond_set_check_level(self, a0)

    def add_to_derivative(self, a0, a1, a2):
        r"""add_to_derivative(Bond self, FloatKey a0, double a1, DerivativeAccumulator a2)"""
        return _IMP_atom.Bond_add_to_derivative(self, a0, a1, a2)

    def set_is_optimized(self, a0, a1):
        r"""set_is_optimized(Bond self, FloatKey a0, bool a1)"""
        return _IMP_atom.Bond_set_is_optimized(self, a0, a1)

    def get_is_optimized(self, a0):
        r"""get_is_optimized(Bond self, FloatKey a0) -> bool"""
        return _IMP_atom.Bond_get_is_optimized(self, a0)

    def get_check_level(self):
        r"""get_check_level(Bond self) -> IMP::CheckLevel"""
        return _IMP_atom.Bond_get_check_level(self)

    def __eq__(self, *args):
        r"""
        __eq__(Bond self, Bond o) -> bool
        __eq__(Bond self, Particle d) -> bool
        """
        return _IMP_atom.Bond___eq__(self, *args)

    def __ne__(self, *args):
        r"""
        __ne__(Bond self, Bond o) -> bool
        __ne__(Bond self, Particle d) -> bool
        """
        return _IMP_atom.Bond___ne__(self, *args)

    def __le__(self, *args):
        r"""
        __le__(Bond self, Bond o) -> bool
        __le__(Bond self, Particle d) -> bool
        """
        return _IMP_atom.Bond___le__(self, *args)

    def __lt__(self, *args):
        r"""
        __lt__(Bond self, Bond o) -> bool
        __lt__(Bond self, Particle d) -> bool
        """
        return _IMP_atom.Bond___lt__(self, *args)

    def __ge__(self, *args):
        r"""
        __ge__(Bond self, Bond o) -> bool
        __ge__(Bond self, Particle d) -> bool
        """
        return _IMP_atom.Bond___ge__(self, *args)

    def __gt__(self, *args):
        r"""
        __gt__(Bond self, Bond o) -> bool
        __gt__(Bond self, Particle d) -> bool
        """
        return _IMP_atom.Bond___gt__(self, *args)

    def __hash__(self):
        r"""__hash__(Bond self) -> std::size_t"""
        return _IMP_atom.Bond___hash__(self)

    def __str__(self):
        r"""__str__(Bond self) -> std::string"""
        return _IMP_atom.Bond___str__(self)

    def __repr__(self):
        r"""__repr__(Bond self) -> std::string"""
        return _IMP_atom.Bond___repr__(self)
    __swig_destroy__ = _IMP_atom.delete_Bond

# Register Bond in _IMP_atom:
_IMP_atom.Bond_swigregister(Bond)

def Bond_get_is_setup(*args):
    r"""
    Bond_get_is_setup(_ParticleAdaptor p) -> bool
    Bond_get_is_setup(Model m, ParticleIndex pi) -> bool
    """
    return _IMP_atom.Bond_get_is_setup(*args)

def Bond_get_length_key():
    r"""Bond_get_length_key() -> FloatKey"""
    return _IMP_atom.Bond_get_length_key()

class Bonded(IMP.Decorator):
    r"""Proxy of C++ IMP::atom::Bonded class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(Bonded self) -> Bonded
        __init__(Bonded self, Model m, ParticleIndex id) -> Bonded
        __init__(Bonded self, _ParticleAdaptor d) -> Bonded
        """
        _IMP_atom.Bonded_swiginit(self, _IMP_atom.new_Bonded(*args))

    def show(self, *args):
        r"""show(Bonded self, _ostream out=std::cout)"""
        return _IMP_atom.Bonded_show(self, *args)

    @staticmethod
    def setup_particle(*args):
        r"""
        setup_particle(Model m, ParticleIndex pi) -> Bonded
        setup_particle(_ParticleAdaptor decorator) -> Bonded
        """
        return _IMP_atom.Bonded_setup_particle(*args)

    @staticmethod
    def get_is_setup(*args):
        r"""
        get_is_setup(_ParticleAdaptor p) -> bool
        get_is_setup(Model m, ParticleIndex pi) -> bool
        """
        return _IMP_atom.Bonded_get_is_setup(*args)

    def get_number_of_bonds(self):
        r"""get_number_of_bonds(Bonded self) -> unsigned int"""
        return _IMP_atom.Bonded_get_number_of_bonds(self)

    def get_bond_indexes(self):
        r"""get_bond_indexes(Bonded self) -> IMP::ParticleIndexes"""
        return _IMP_atom.Bonded_get_bond_indexes(self)

    def get_bond(self, i):
        r"""get_bond(Bonded self, unsigned int i) -> Bond"""
        return _IMP_atom.Bonded_get_bond(self, i)

    def get_bonded(self, i):
        r"""get_bonded(Bonded self, unsigned int i) -> Bonded"""
        return _IMP_atom.Bonded_get_bonded(self, i)

    def add_attribute(self, *args):
        r"""
        add_attribute(Bonded self, FloatKey k, IMP::Float v, bool opt)
        add_attribute(Bonded self, FloatKey a0, IMP::Float a1)
        add_attribute(Bonded self, IntKey a0, IMP::Int a1)
        add_attribute(Bonded self, FloatsKey a0, IMP::Floats a1)
        add_attribute(Bonded self, IntsKey a0, IMP::Ints a1)
        add_attribute(Bonded self, StringKey a0, IMP::String a1)
        add_attribute(Bonded self, ParticleIndexKey a0, Particle a1)
        add_attribute(Bonded self, ObjectKey a0, Object a1)
        """
        return _IMP_atom.Bonded_add_attribute(self, *args)

    def get_value(self, *args):
        r"""
        get_value(Bonded self, FloatKey a0) -> IMP::Float
        get_value(Bonded self, IntKey a0) -> IMP::Int
        get_value(Bonded self, FloatsKey a0) -> IMP::Floats
        get_value(Bonded self, IntsKey a0) -> IMP::Ints
        get_value(Bonded self, StringKey a0) -> IMP::String
        get_value(Bonded self, ParticleIndexKey a0) -> Particle
        get_value(Bonded self, ObjectKey a0) -> Object
        """
        return _IMP_atom.Bonded_get_value(self, *args)

    def set_value(self, *args):
        r"""
        set_value(Bonded self, FloatKey a0, IMP::Float a1)
        set_value(Bonded self, IntKey a0, IMP::Int a1)
        set_value(Bonded self, FloatsKey a0, IMP::Floats a1)
        set_value(Bonded self, IntsKey a0, IMP::Ints a1)
        set_value(Bonded self, StringKey a0, IMP::String a1)
        set_value(Bonded self, ParticleIndexKey a0, Particle a1)
        set_value(Bonded self, ObjectKey a0, Object a1)
        """
        return _IMP_atom.Bonded_set_value(self, *args)

    def remove_attribute(self, *args):
        r"""
        remove_attribute(Bonded self, FloatKey a0)
        remove_attribute(Bonded self, IntKey a0)
        remove_attribute(Bonded self, FloatsKey a0)
        remove_attribute(Bonded self, IntsKey a0)
        remove_attribute(Bonded self, StringKey a0)
        remove_attribute(Bonded self, ParticleIndexKey a0)
        remove_attribute(Bonded self, ObjectKey a0)
        """
        return _IMP_atom.Bonded_remove_attribute(self, *args)

    def has_attribute(self, *args):
        r"""
        has_attribute(Bonded self, FloatKey a0) -> bool
        has_attribute(Bonded self, IntKey a0) -> bool
        has_attribute(Bonded self, FloatsKey a0) -> bool
        has_attribute(Bonded self, IntsKey a0) -> bool
        has_attribute(Bonded self, StringKey a0) -> bool
        has_attribute(Bonded self, ParticleIndexKey a0) -> bool
        has_attribute(Bonded self, ObjectKey a0) -> bool
        """
        return _IMP_atom.Bonded_has_attribute(self, *args)

    def get_derivative(self, a0):
        r"""get_derivative(Bonded self, FloatKey a0) -> double"""
        return _IMP_atom.Bonded_get_derivative(self, a0)

    def get_name(self):
        r"""get_name(Bonded self) -> std::string"""
        return _IMP_atom.Bonded_get_name(self)

    def clear_caches(self):
        r"""clear_caches(Bonded self)"""
        return _IMP_atom.Bonded_clear_caches(self)

    def set_name(self, a0):
        r"""set_name(Bonded self, std::string a0)"""
        return _IMP_atom.Bonded_set_name(self, a0)

    def set_check_level(self, a0):
        r"""set_check_level(Bonded self, IMP::CheckLevel a0)"""
        return _IMP_atom.Bonded_set_check_level(self, a0)

    def add_to_derivative(self, a0, a1, a2):
        r"""add_to_derivative(Bonded self, FloatKey a0, double a1, DerivativeAccumulator a2)"""
        return _IMP_atom.Bonded_add_to_derivative(self, a0, a1, a2)

    def set_is_optimized(self, a0, a1):
        r"""set_is_optimized(Bonded self, FloatKey a0, bool a1)"""
        return _IMP_atom.Bonded_set_is_optimized(self, a0, a1)

    def get_is_optimized(self, a0):
        r"""get_is_optimized(Bonded self, FloatKey a0) -> bool"""
        return _IMP_atom.Bonded_get_is_optimized(self, a0)

    def get_check_level(self):
        r"""get_check_level(Bonded self) -> IMP::CheckLevel"""
        return _IMP_atom.Bonded_get_check_level(self)

    def __eq__(self, *args):
        r"""
        __eq__(Bonded self, Bonded o) -> bool
        __eq__(Bonded self, Particle d) -> bool
        """
        return _IMP_atom.Bonded___eq__(self, *args)

    def __ne__(self, *args):
        r"""
        __ne__(Bonded self, Bonded o) -> bool
        __ne__(Bonded self, Particle d) -> bool
        """
        return _IMP_atom.Bonded___ne__(self, *args)

    def __le__(self, *args):
        r"""
        __le__(Bonded self, Bonded o) -> bool
        __le__(Bonded self, Particle d) -> bool
        """
        return _IMP_atom.Bonded___le__(self, *args)

    def __lt__(self, *args):
        r"""
        __lt__(Bonded self, Bonded o) -> bool
        __lt__(Bonded self, Particle d) -> bool
        """
        return _IMP_atom.Bonded___lt__(self, *args)

    def __ge__(self, *args):
        r"""
        __ge__(Bonded self, Bonded o) -> bool
        __ge__(Bonded self, Particle d) -> bool
        """
        return _IMP_atom.Bonded___ge__(self, *args)

    def __gt__(self, *args):
        r"""
        __gt__(Bonded self, Bonded o) -> bool
        __gt__(Bonded self, Particle d) -> bool
        """
        return _IMP_atom.Bonded___gt__(self, *args)

    def __hash__(self):
        r"""__hash__(Bonded self) -> std::size_t"""
        return _IMP_atom.Bonded___hash__(self)

    def __str__(self):
        r"""__str__(Bonded self) -> std::string"""
        return _IMP_atom.Bonded___str__(self)

    def __repr__(self):
        r"""__repr__(Bonded self) -> std::string"""
        return _IMP_atom.Bonded___repr__(self)
    __swig_destroy__ = _IMP_atom.delete_Bonded

# Register Bonded in _IMP_atom:
_IMP_atom.Bonded_swigregister(Bonded)

def Bonded_setup_particle(*args):
    r"""
    Bonded_setup_particle(Model m, ParticleIndex pi) -> Bonded
    Bonded_setup_particle(_ParticleAdaptor decorator) -> Bonded
    """
    return _IMP_atom.Bonded_setup_particle(*args)

def Bonded_get_is_setup(*args):
    r"""
    Bonded_get_is_setup(_ParticleAdaptor p) -> bool
    Bonded_get_is_setup(Model m, ParticleIndex pi) -> bool
    """
    return _IMP_atom.Bonded_get_is_setup(*args)


def create_custom_bond(a, b, length, stiffness=-1):
    r"""create_custom_bond(Bonded a, Bonded b, IMP::Float length, IMP::Float stiffness=-1) -> Bond"""
    return _IMP_atom.create_custom_bond(a, b, length, stiffness)

def create_bond(*args):
    r"""
    create_bond(Bonded a, Bonded b, IMP::Int t) -> Bond
    create_bond(Bonded a, Bonded b, Bond o) -> Bond
    """
    return _IMP_atom.create_bond(*args)

def destroy_bond(b):
    r"""destroy_bond(Bond b)"""
    return _IMP_atom.destroy_bond(b)

def get_bond(a, b):
    r"""get_bond(Bonded a, Bonded b) -> Bond"""
    return _IMP_atom.get_bond(a, b)
class BondGeometry(IMP.display.SingletonGeometry):
    r"""Proxy of C++ IMP::atom::BondGeometry class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(BondGeometry self, Particle p) -> BondGeometry
        __init__(BondGeometry self, Bond d) -> BondGeometry
        """
        _IMP_atom.BondGeometry_swiginit(self, _IMP_atom.new_BondGeometry(*args))

    def get_version_info(self):
        r"""get_version_info(BondGeometry self) -> VersionInfo"""
        return _IMP_atom.BondGeometry_get_version_info(self)

    def __str__(self):
        r"""__str__(BondGeometry self) -> std::string"""
        return _IMP_atom.BondGeometry___str__(self)

    def __repr__(self):
        r"""__repr__(BondGeometry self) -> std::string"""
        return _IMP_atom.BondGeometry___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_BondGeometry(o)


# Register BondGeometry in _IMP_atom:
_IMP_atom.BondGeometry_swigregister(BondGeometry)

class BondsGeometry(IMP.display.SingletonsGeometry):
    r"""Proxy of C++ IMP::atom::BondsGeometry class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, sc):
        r"""__init__(BondsGeometry self, SingletonContainer sc) -> BondsGeometry"""
        _IMP_atom.BondsGeometry_swiginit(self, _IMP_atom.new_BondsGeometry(sc))

    def get_version_info(self):
        r"""get_version_info(BondsGeometry self) -> VersionInfo"""
        return _IMP_atom.BondsGeometry_get_version_info(self)

    def __str__(self):
        r"""__str__(BondsGeometry self) -> std::string"""
        return _IMP_atom.BondsGeometry___str__(self)

    def __repr__(self):
        r"""__repr__(BondsGeometry self) -> std::string"""
        return _IMP_atom.BondsGeometry___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_BondsGeometry(o)


# Register BondsGeometry in _IMP_atom:
_IMP_atom.BondsGeometry_swigregister(BondsGeometry)

class Hierarchy(IMP.core.Hierarchy):
    r"""Proxy of C++ IMP::atom::Hierarchy class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(Hierarchy self, Model m, ParticleIndex pi) -> Hierarchy
        __init__(Hierarchy self, _ParticleAdaptor pi) -> Hierarchy
        __init__(Hierarchy self) -> Hierarchy
        __init__(Hierarchy self, Hierarchy h) -> Hierarchy
        """
        _IMP_atom.Hierarchy_swiginit(self, _IMP_atom.new_Hierarchy(*args))

    @staticmethod
    def setup_particle(*args):
        r"""
        setup_particle(Particle p, _ParticleIndexesAdaptor children) -> Hierarchy
        setup_particle(Particle p) -> Hierarchy
        setup_particle(Model m, ParticleIndex pi, _ParticleIndexesAdaptor children=IMP::ParticleIndexesAdaptor()) -> Hierarchy
        """
        return _IMP_atom.Hierarchy_setup_particle(*args)

    @staticmethod
    def get_is_setup(*args):
        r"""
        get_is_setup(Particle p) -> bool
        get_is_setup(Model m, ParticleIndex p) -> bool
        """
        return _IMP_atom.Hierarchy_get_is_setup(*args)

    def get_is_valid(self, print_info=False):
        r"""get_is_valid(Hierarchy self, bool print_info=False) -> bool"""
        return _IMP_atom.Hierarchy_get_is_valid(self, print_info)

    def add_child(self, o):
        r"""add_child(Hierarchy self, Hierarchy o)"""
        return _IMP_atom.Hierarchy_add_child(self, o)

    def get_child(self, i):
        r"""get_child(Hierarchy self, unsigned int i) -> Hierarchy"""
        return _IMP_atom.Hierarchy_get_child(self, i)

    def get_children(self):
        r"""get_children(Hierarchy self) -> IMP::atom::Hierarchies"""
        return _IMP_atom.Hierarchy_get_children(self)

    def get_parent(self):
        r"""get_parent(Hierarchy self) -> Hierarchy"""
        return _IMP_atom.Hierarchy_get_parent(self)

    @staticmethod
    def get_traits():
        r"""get_traits() -> HierarchyTraits"""
        return _IMP_atom.Hierarchy_get_traits()

    def show(self, *args):
        r"""
        show(Hierarchy self, _ostream out, std::string delimiter)
        show(Hierarchy self, _ostream out=std::cout)
        """
        return _IMP_atom.Hierarchy_show(self, *args)

    def add_attribute(self, *args):
        r"""
        add_attribute(Hierarchy self, FloatKey k, IMP::Float v, bool opt)
        add_attribute(Hierarchy self, FloatKey a0, IMP::Float a1)
        add_attribute(Hierarchy self, IntKey a0, IMP::Int a1)
        add_attribute(Hierarchy self, FloatsKey a0, IMP::Floats a1)
        add_attribute(Hierarchy self, IntsKey a0, IMP::Ints a1)
        add_attribute(Hierarchy self, StringKey a0, IMP::String a1)
        add_attribute(Hierarchy self, ParticleIndexKey a0, Particle a1)
        add_attribute(Hierarchy self, ObjectKey a0, Object a1)
        """
        return _IMP_atom.Hierarchy_add_attribute(self, *args)

    def get_value(self, *args):
        r"""
        get_value(Hierarchy self, FloatKey a0) -> IMP::Float
        get_value(Hierarchy self, IntKey a0) -> IMP::Int
        get_value(Hierarchy self, FloatsKey a0) -> IMP::Floats
        get_value(Hierarchy self, IntsKey a0) -> IMP::Ints
        get_value(Hierarchy self, StringKey a0) -> IMP::String
        get_value(Hierarchy self, ParticleIndexKey a0) -> Particle
        get_value(Hierarchy self, ObjectKey a0) -> Object
        """
        return _IMP_atom.Hierarchy_get_value(self, *args)

    def set_value(self, *args):
        r"""
        set_value(Hierarchy self, FloatKey a0, IMP::Float a1)
        set_value(Hierarchy self, IntKey a0, IMP::Int a1)
        set_value(Hierarchy self, FloatsKey a0, IMP::Floats a1)
        set_value(Hierarchy self, IntsKey a0, IMP::Ints a1)
        set_value(Hierarchy self, StringKey a0, IMP::String a1)
        set_value(Hierarchy self, ParticleIndexKey a0, Particle a1)
        set_value(Hierarchy self, ObjectKey a0, Object a1)
        """
        return _IMP_atom.Hierarchy_set_value(self, *args)

    def remove_attribute(self, *args):
        r"""
        remove_attribute(Hierarchy self, FloatKey a0)
        remove_attribute(Hierarchy self, IntKey a0)
        remove_attribute(Hierarchy self, FloatsKey a0)
        remove_attribute(Hierarchy self, IntsKey a0)
        remove_attribute(Hierarchy self, StringKey a0)
        remove_attribute(Hierarchy self, ParticleIndexKey a0)
        remove_attribute(Hierarchy self, ObjectKey a0)
        """
        return _IMP_atom.Hierarchy_remove_attribute(self, *args)

    def has_attribute(self, *args):
        r"""
        has_attribute(Hierarchy self, FloatKey a0) -> bool
        has_attribute(Hierarchy self, IntKey a0) -> bool
        has_attribute(Hierarchy self, FloatsKey a0) -> bool
        has_attribute(Hierarchy self, IntsKey a0) -> bool
        has_attribute(Hierarchy self, StringKey a0) -> bool
        has_attribute(Hierarchy self, ParticleIndexKey a0) -> bool
        has_attribute(Hierarchy self, ObjectKey a0) -> bool
        """
        return _IMP_atom.Hierarchy_has_attribute(self, *args)

    def get_derivative(self, a0):
        r"""get_derivative(Hierarchy self, FloatKey a0) -> double"""
        return _IMP_atom.Hierarchy_get_derivative(self, a0)

    def get_name(self):
        r"""get_name(Hierarchy self) -> std::string"""
        return _IMP_atom.Hierarchy_get_name(self)

    def clear_caches(self):
        r"""clear_caches(Hierarchy self)"""
        return _IMP_atom.Hierarchy_clear_caches(self)

    def set_name(self, a0):
        r"""set_name(Hierarchy self, std::string a0)"""
        return _IMP_atom.Hierarchy_set_name(self, a0)

    def set_check_level(self, a0):
        r"""set_check_level(Hierarchy self, IMP::CheckLevel a0)"""
        return _IMP_atom.Hierarchy_set_check_level(self, a0)

    def add_to_derivative(self, a0, a1, a2):
        r"""add_to_derivative(Hierarchy self, FloatKey a0, double a1, DerivativeAccumulator a2)"""
        return _IMP_atom.Hierarchy_add_to_derivative(self, a0, a1, a2)

    def set_is_optimized(self, a0, a1):
        r"""set_is_optimized(Hierarchy self, FloatKey a0, bool a1)"""
        return _IMP_atom.Hierarchy_set_is_optimized(self, a0, a1)

    def get_is_optimized(self, a0):
        r"""get_is_optimized(Hierarchy self, FloatKey a0) -> bool"""
        return _IMP_atom.Hierarchy_get_is_optimized(self, a0)

    def get_check_level(self):
        r"""get_check_level(Hierarchy self) -> IMP::CheckLevel"""
        return _IMP_atom.Hierarchy_get_check_level(self)

    def __eq__(self, *args):
        r"""
        __eq__(Hierarchy self, Hierarchy o) -> bool
        __eq__(Hierarchy self, Particle d) -> bool
        """
        return _IMP_atom.Hierarchy___eq__(self, *args)

    def __ne__(self, *args):
        r"""
        __ne__(Hierarchy self, Hierarchy o) -> bool
        __ne__(Hierarchy self, Particle d) -> bool
        """
        return _IMP_atom.Hierarchy___ne__(self, *args)

    def __le__(self, *args):
        r"""
        __le__(Hierarchy self, Hierarchy o) -> bool
        __le__(Hierarchy self, Particle d) -> bool
        """
        return _IMP_atom.Hierarchy___le__(self, *args)

    def __lt__(self, *args):
        r"""
        __lt__(Hierarchy self, Hierarchy o) -> bool
        __lt__(Hierarchy self, Particle d) -> bool
        """
        return _IMP_atom.Hierarchy___lt__(self, *args)

    def __ge__(self, *args):
        r"""
        __ge__(Hierarchy self, Hierarchy o) -> bool
        __ge__(Hierarchy self, Particle d) -> bool
        """
        return _IMP_atom.Hierarchy___ge__(self, *args)

    def __gt__(self, *args):
        r"""
        __gt__(Hierarchy self, Hierarchy o) -> bool
        __gt__(Hierarchy self, Particle d) -> bool
        """
        return _IMP_atom.Hierarchy___gt__(self, *args)

    def __hash__(self):
        r"""__hash__(Hierarchy self) -> std::size_t"""
        return _IMP_atom.Hierarchy___hash__(self)

    def __str__(self):
        r"""__str__(Hierarchy self) -> std::string"""
        return _IMP_atom.Hierarchy___str__(self)

    def __repr__(self):
        r"""__repr__(Hierarchy self) -> std::string"""
        return _IMP_atom.Hierarchy___repr__(self)
    __swig_destroy__ = _IMP_atom.delete_Hierarchy

# Register Hierarchy in _IMP_atom:
_IMP_atom.Hierarchy_swigregister(Hierarchy)

def Hierarchy_setup_particle(*args):
    r"""
    Hierarchy_setup_particle(Particle p, _ParticleIndexesAdaptor children) -> Hierarchy
    Hierarchy_setup_particle(Particle p) -> Hierarchy
    Hierarchy_setup_particle(Model m, ParticleIndex pi, _ParticleIndexesAdaptor children=IMP::ParticleIndexesAdaptor()) -> Hierarchy
    """
    return _IMP_atom.Hierarchy_setup_particle(*args)

def Hierarchy_get_is_setup(*args):
    r"""
    Hierarchy_get_is_setup(Particle p) -> bool
    Hierarchy_get_is_setup(Model m, ParticleIndex p) -> bool
    """
    return _IMP_atom.Hierarchy_get_is_setup(*args)

def Hierarchy_get_traits():
    r"""Hierarchy_get_traits() -> HierarchyTraits"""
    return _IMP_atom.Hierarchy_get_traits()

ATOM_TYPE = _IMP_atom.ATOM_TYPE

RESIDUE_TYPE = _IMP_atom.RESIDUE_TYPE

CHAIN_TYPE = _IMP_atom.CHAIN_TYPE

MOLECULE_TYPE = _IMP_atom.MOLECULE_TYPE

DOMAIN_TYPE = _IMP_atom.DOMAIN_TYPE

FRAGMENT_TYPE = _IMP_atom.FRAGMENT_TYPE

XYZ_TYPE = _IMP_atom.XYZ_TYPE

XYZR_TYPE = _IMP_atom.XYZR_TYPE

MASS_TYPE = _IMP_atom.MASS_TYPE

STATE_TYPE = _IMP_atom.STATE_TYPE


def get_by_type(mhd, t):
    r"""get_by_type(Hierarchy mhd, IMP::atom::GetByType t) -> IMP::atom::Hierarchies"""
    return _IMP_atom.get_by_type(mhd, t)

def create_fragment(ps):
    r"""create_fragment(IMP::atom::Hierarchies const & ps) -> Hierarchy"""
    return _IMP_atom.create_fragment(ps)

def get_internal_bonds(mhd):
    r"""get_internal_bonds(Hierarchy mhd) -> IMP::atom::Bonds"""
    return _IMP_atom.get_internal_bonds(mhd)

def get_root(h):
    r"""get_root(Hierarchy h) -> Hierarchy"""
    return _IMP_atom.get_root(h)

def show(*args):
    r"""show(Hierarchy h, _ostream out=std::cout)"""
    return _IMP_atom.show(*args)

def create_rigid_body(*args):
    r"""
    create_rigid_body(IMP::atom::Hierarchies const & h, std::string name=std::string("created rigid body")) -> RigidBody
    create_rigid_body(Hierarchy h) -> RigidBody
    """
    return _IMP_atom.create_rigid_body(*args)

def create_compatible_rigid_body(h, reference):
    r"""create_compatible_rigid_body(Hierarchy h, Hierarchy reference) -> RigidBody"""
    return _IMP_atom.create_compatible_rigid_body(h, reference)

def get_is_heterogen(h):
    r"""get_is_heterogen(Hierarchy h) -> bool"""
    return _IMP_atom.get_is_heterogen(h)

def create_clone(d):
    r"""create_clone(Hierarchy d) -> Hierarchy"""
    return _IMP_atom.create_clone(d)

def create_clone_one(d):
    r"""create_clone_one(Hierarchy d) -> Hierarchy"""
    return _IMP_atom.create_clone_one(d)

def destroy(d):
    r"""destroy(Hierarchy d)"""
    return _IMP_atom.destroy(d)

def get_bounding_box(h):
    r"""get_bounding_box(Hierarchy h) -> BoundingBox3D"""
    return _IMP_atom.get_bounding_box(h)

def get_bounding_sphere(h):
    r"""get_bounding_sphere(Hierarchy h) -> Sphere3D"""
    return _IMP_atom.get_bounding_sphere(h)
class Angle(IMP.Decorator):
    r"""Proxy of C++ IMP::atom::Angle class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(Angle self) -> Angle
        __init__(Angle self, Model m, ParticleIndex id) -> Angle
        __init__(Angle self, _ParticleAdaptor d) -> Angle
        """
        _IMP_atom.Angle_swiginit(self, _IMP_atom.new_Angle(*args))

    def show(self, *args):
        r"""show(Angle self, _ostream out=std::cout)"""
        return _IMP_atom.Angle_show(self, *args)

    @staticmethod
    def setup_particle(*args):
        r"""
        setup_particle(Model m, ParticleIndex pi, XYZ a, XYZ b, XYZ c) -> Angle
        setup_particle(_ParticleAdaptor decorator, XYZ a, XYZ b, XYZ c) -> Angle
        """
        return _IMP_atom.Angle_setup_particle(*args)

    @staticmethod
    def get_is_setup(*args):
        r"""
        get_is_setup(_ParticleAdaptor p) -> bool
        get_is_setup(Model m, ParticleIndex pi) -> bool
        """
        return _IMP_atom.Angle_get_is_setup(*args)

    def get_particle(self, *args):
        r"""
        get_particle(Angle self) -> Particle
        get_particle(Angle self, unsigned int i) -> Particle
        """
        return _IMP_atom.Angle_get_particle(self, *args)

    def get_ideal(self):
        r"""get_ideal(Angle self) -> IMP::Float"""
        return _IMP_atom.Angle_get_ideal(self)

    def set_ideal(self, t):
        r"""set_ideal(Angle self, IMP::Float t)"""
        return _IMP_atom.Angle_set_ideal(self, t)

    def get_stiffness(self):
        r"""get_stiffness(Angle self) -> IMP::Float"""
        return _IMP_atom.Angle_get_stiffness(self)

    def set_stiffness(self, t):
        r"""set_stiffness(Angle self, IMP::Float t)"""
        return _IMP_atom.Angle_set_stiffness(self, t)

    @staticmethod
    def get_particle_key(i):
        r"""get_particle_key(unsigned int i) -> ParticleIndexKey"""
        return _IMP_atom.Angle_get_particle_key(i)

    @staticmethod
    def get_ideal_key():
        r"""get_ideal_key() -> FloatKey"""
        return _IMP_atom.Angle_get_ideal_key()

    @staticmethod
    def get_stiffness_key():
        r"""get_stiffness_key() -> FloatKey"""
        return _IMP_atom.Angle_get_stiffness_key()

    def add_attribute(self, *args):
        r"""
        add_attribute(Angle self, FloatKey k, IMP::Float v, bool opt)
        add_attribute(Angle self, FloatKey a0, IMP::Float a1)
        add_attribute(Angle self, IntKey a0, IMP::Int a1)
        add_attribute(Angle self, FloatsKey a0, IMP::Floats a1)
        add_attribute(Angle self, IntsKey a0, IMP::Ints a1)
        add_attribute(Angle self, StringKey a0, IMP::String a1)
        add_attribute(Angle self, ParticleIndexKey a0, Particle a1)
        add_attribute(Angle self, ObjectKey a0, Object a1)
        """
        return _IMP_atom.Angle_add_attribute(self, *args)

    def get_value(self, *args):
        r"""
        get_value(Angle self, FloatKey a0) -> IMP::Float
        get_value(Angle self, IntKey a0) -> IMP::Int
        get_value(Angle self, FloatsKey a0) -> IMP::Floats
        get_value(Angle self, IntsKey a0) -> IMP::Ints
        get_value(Angle self, StringKey a0) -> IMP::String
        get_value(Angle self, ParticleIndexKey a0) -> Particle
        get_value(Angle self, ObjectKey a0) -> Object
        """
        return _IMP_atom.Angle_get_value(self, *args)

    def set_value(self, *args):
        r"""
        set_value(Angle self, FloatKey a0, IMP::Float a1)
        set_value(Angle self, IntKey a0, IMP::Int a1)
        set_value(Angle self, FloatsKey a0, IMP::Floats a1)
        set_value(Angle self, IntsKey a0, IMP::Ints a1)
        set_value(Angle self, StringKey a0, IMP::String a1)
        set_value(Angle self, ParticleIndexKey a0, Particle a1)
        set_value(Angle self, ObjectKey a0, Object a1)
        """
        return _IMP_atom.Angle_set_value(self, *args)

    def remove_attribute(self, *args):
        r"""
        remove_attribute(Angle self, FloatKey a0)
        remove_attribute(Angle self, IntKey a0)
        remove_attribute(Angle self, FloatsKey a0)
        remove_attribute(Angle self, IntsKey a0)
        remove_attribute(Angle self, StringKey a0)
        remove_attribute(Angle self, ParticleIndexKey a0)
        remove_attribute(Angle self, ObjectKey a0)
        """
        return _IMP_atom.Angle_remove_attribute(self, *args)

    def has_attribute(self, *args):
        r"""
        has_attribute(Angle self, FloatKey a0) -> bool
        has_attribute(Angle self, IntKey a0) -> bool
        has_attribute(Angle self, FloatsKey a0) -> bool
        has_attribute(Angle self, IntsKey a0) -> bool
        has_attribute(Angle self, StringKey a0) -> bool
        has_attribute(Angle self, ParticleIndexKey a0) -> bool
        has_attribute(Angle self, ObjectKey a0) -> bool
        """
        return _IMP_atom.Angle_has_attribute(self, *args)

    def get_derivative(self, a0):
        r"""get_derivative(Angle self, FloatKey a0) -> double"""
        return _IMP_atom.Angle_get_derivative(self, a0)

    def get_name(self):
        r"""get_name(Angle self) -> std::string"""
        return _IMP_atom.Angle_get_name(self)

    def clear_caches(self):
        r"""clear_caches(Angle self)"""
        return _IMP_atom.Angle_clear_caches(self)

    def set_name(self, a0):
        r"""set_name(Angle self, std::string a0)"""
        return _IMP_atom.Angle_set_name(self, a0)

    def set_check_level(self, a0):
        r"""set_check_level(Angle self, IMP::CheckLevel a0)"""
        return _IMP_atom.Angle_set_check_level(self, a0)

    def add_to_derivative(self, a0, a1, a2):
        r"""add_to_derivative(Angle self, FloatKey a0, double a1, DerivativeAccumulator a2)"""
        return _IMP_atom.Angle_add_to_derivative(self, a0, a1, a2)

    def set_is_optimized(self, a0, a1):
        r"""set_is_optimized(Angle self, FloatKey a0, bool a1)"""
        return _IMP_atom.Angle_set_is_optimized(self, a0, a1)

    def get_is_optimized(self, a0):
        r"""get_is_optimized(Angle self, FloatKey a0) -> bool"""
        return _IMP_atom.Angle_get_is_optimized(self, a0)

    def get_check_level(self):
        r"""get_check_level(Angle self) -> IMP::CheckLevel"""
        return _IMP_atom.Angle_get_check_level(self)

    def __eq__(self, *args):
        r"""
        __eq__(Angle self, Angle o) -> bool
        __eq__(Angle self, Particle d) -> bool
        """
        return _IMP_atom.Angle___eq__(self, *args)

    def __ne__(self, *args):
        r"""
        __ne__(Angle self, Angle o) -> bool
        __ne__(Angle self, Particle d) -> bool
        """
        return _IMP_atom.Angle___ne__(self, *args)

    def __le__(self, *args):
        r"""
        __le__(Angle self, Angle o) -> bool
        __le__(Angle self, Particle d) -> bool
        """
        return _IMP_atom.Angle___le__(self, *args)

    def __lt__(self, *args):
        r"""
        __lt__(Angle self, Angle o) -> bool
        __lt__(Angle self, Particle d) -> bool
        """
        return _IMP_atom.Angle___lt__(self, *args)

    def __ge__(self, *args):
        r"""
        __ge__(Angle self, Angle o) -> bool
        __ge__(Angle self, Particle d) -> bool
        """
        return _IMP_atom.Angle___ge__(self, *args)

    def __gt__(self, *args):
        r"""
        __gt__(Angle self, Angle o) -> bool
        __gt__(Angle self, Particle d) -> bool
        """
        return _IMP_atom.Angle___gt__(self, *args)

    def __hash__(self):
        r"""__hash__(Angle self) -> std::size_t"""
        return _IMP_atom.Angle___hash__(self)

    def __str__(self):
        r"""__str__(Angle self) -> std::string"""
        return _IMP_atom.Angle___str__(self)

    def __repr__(self):
        r"""__repr__(Angle self) -> std::string"""
        return _IMP_atom.Angle___repr__(self)
    __swig_destroy__ = _IMP_atom.delete_Angle

# Register Angle in _IMP_atom:
_IMP_atom.Angle_swigregister(Angle)

def Angle_setup_particle(*args):
    r"""
    Angle_setup_particle(Model m, ParticleIndex pi, XYZ a, XYZ b, XYZ c) -> Angle
    Angle_setup_particle(_ParticleAdaptor decorator, XYZ a, XYZ b, XYZ c) -> Angle
    """
    return _IMP_atom.Angle_setup_particle(*args)

def Angle_get_is_setup(*args):
    r"""
    Angle_get_is_setup(_ParticleAdaptor p) -> bool
    Angle_get_is_setup(Model m, ParticleIndex pi) -> bool
    """
    return _IMP_atom.Angle_get_is_setup(*args)

def Angle_get_particle_key(i):
    r"""Angle_get_particle_key(unsigned int i) -> ParticleIndexKey"""
    return _IMP_atom.Angle_get_particle_key(i)

def Angle_get_ideal_key():
    r"""Angle_get_ideal_key() -> FloatKey"""
    return _IMP_atom.Angle_get_ideal_key()

def Angle_get_stiffness_key():
    r"""Angle_get_stiffness_key() -> FloatKey"""
    return _IMP_atom.Angle_get_stiffness_key()

class Dihedral(IMP.Decorator):
    r"""Proxy of C++ IMP::atom::Dihedral class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(Dihedral self) -> Dihedral
        __init__(Dihedral self, Model m, ParticleIndex id) -> Dihedral
        __init__(Dihedral self, _ParticleAdaptor d) -> Dihedral
        """
        _IMP_atom.Dihedral_swiginit(self, _IMP_atom.new_Dihedral(*args))

    def show(self, *args):
        r"""show(Dihedral self, _ostream out=std::cout)"""
        return _IMP_atom.Dihedral_show(self, *args)

    @staticmethod
    def setup_particle(*args):
        r"""
        setup_particle(Model m, ParticleIndex pi, XYZ a, XYZ b, XYZ c, XYZ d) -> Dihedral
        setup_particle(_ParticleAdaptor decorator, XYZ a, XYZ b, XYZ c, XYZ d) -> Dihedral
        """
        return _IMP_atom.Dihedral_setup_particle(*args)

    @staticmethod
    def get_is_setup(*args):
        r"""
        get_is_setup(_ParticleAdaptor p) -> bool
        get_is_setup(Model m, ParticleIndex pi) -> bool
        """
        return _IMP_atom.Dihedral_get_is_setup(*args)

    def get_particle(self, *args):
        r"""
        get_particle(Dihedral self) -> Particle
        get_particle(Dihedral self, unsigned int i) -> Particle
        """
        return _IMP_atom.Dihedral_get_particle(self, *args)

    def get_ideal(self):
        r"""get_ideal(Dihedral self) -> IMP::Float"""
        return _IMP_atom.Dihedral_get_ideal(self)

    def set_ideal(self, t):
        r"""set_ideal(Dihedral self, IMP::Float t)"""
        return _IMP_atom.Dihedral_set_ideal(self, t)

    def get_multiplicity(self):
        r"""get_multiplicity(Dihedral self) -> IMP::Int"""
        return _IMP_atom.Dihedral_get_multiplicity(self)

    def set_multiplicity(self, t):
        r"""set_multiplicity(Dihedral self, IMP::Int t)"""
        return _IMP_atom.Dihedral_set_multiplicity(self, t)

    def get_stiffness(self):
        r"""get_stiffness(Dihedral self) -> IMP::Float"""
        return _IMP_atom.Dihedral_get_stiffness(self)

    def set_stiffness(self, t):
        r"""set_stiffness(Dihedral self, IMP::Float t)"""
        return _IMP_atom.Dihedral_set_stiffness(self, t)

    @staticmethod
    def get_particle_key(i):
        r"""get_particle_key(unsigned int i) -> ParticleIndexKey"""
        return _IMP_atom.Dihedral_get_particle_key(i)

    @staticmethod
    def get_ideal_key():
        r"""get_ideal_key() -> FloatKey"""
        return _IMP_atom.Dihedral_get_ideal_key()

    @staticmethod
    def get_multiplicity_key():
        r"""get_multiplicity_key() -> IntKey"""
        return _IMP_atom.Dihedral_get_multiplicity_key()

    @staticmethod
    def get_stiffness_key():
        r"""get_stiffness_key() -> FloatKey"""
        return _IMP_atom.Dihedral_get_stiffness_key()

    def add_attribute(self, *args):
        r"""
        add_attribute(Dihedral self, FloatKey k, IMP::Float v, bool opt)
        add_attribute(Dihedral self, FloatKey a0, IMP::Float a1)
        add_attribute(Dihedral self, IntKey a0, IMP::Int a1)
        add_attribute(Dihedral self, FloatsKey a0, IMP::Floats a1)
        add_attribute(Dihedral self, IntsKey a0, IMP::Ints a1)
        add_attribute(Dihedral self, StringKey a0, IMP::String a1)
        add_attribute(Dihedral self, ParticleIndexKey a0, Particle a1)
        add_attribute(Dihedral self, ObjectKey a0, Object a1)
        """
        return _IMP_atom.Dihedral_add_attribute(self, *args)

    def get_value(self, *args):
        r"""
        get_value(Dihedral self, FloatKey a0) -> IMP::Float
        get_value(Dihedral self, IntKey a0) -> IMP::Int
        get_value(Dihedral self, FloatsKey a0) -> IMP::Floats
        get_value(Dihedral self, IntsKey a0) -> IMP::Ints
        get_value(Dihedral self, StringKey a0) -> IMP::String
        get_value(Dihedral self, ParticleIndexKey a0) -> Particle
        get_value(Dihedral self, ObjectKey a0) -> Object
        """
        return _IMP_atom.Dihedral_get_value(self, *args)

    def set_value(self, *args):
        r"""
        set_value(Dihedral self, FloatKey a0, IMP::Float a1)
        set_value(Dihedral self, IntKey a0, IMP::Int a1)
        set_value(Dihedral self, FloatsKey a0, IMP::Floats a1)
        set_value(Dihedral self, IntsKey a0, IMP::Ints a1)
        set_value(Dihedral self, StringKey a0, IMP::String a1)
        set_value(Dihedral self, ParticleIndexKey a0, Particle a1)
        set_value(Dihedral self, ObjectKey a0, Object a1)
        """
        return _IMP_atom.Dihedral_set_value(self, *args)

    def remove_attribute(self, *args):
        r"""
        remove_attribute(Dihedral self, FloatKey a0)
        remove_attribute(Dihedral self, IntKey a0)
        remove_attribute(Dihedral self, FloatsKey a0)
        remove_attribute(Dihedral self, IntsKey a0)
        remove_attribute(Dihedral self, StringKey a0)
        remove_attribute(Dihedral self, ParticleIndexKey a0)
        remove_attribute(Dihedral self, ObjectKey a0)
        """
        return _IMP_atom.Dihedral_remove_attribute(self, *args)

    def has_attribute(self, *args):
        r"""
        has_attribute(Dihedral self, FloatKey a0) -> bool
        has_attribute(Dihedral self, IntKey a0) -> bool
        has_attribute(Dihedral self, FloatsKey a0) -> bool
        has_attribute(Dihedral self, IntsKey a0) -> bool
        has_attribute(Dihedral self, StringKey a0) -> bool
        has_attribute(Dihedral self, ParticleIndexKey a0) -> bool
        has_attribute(Dihedral self, ObjectKey a0) -> bool
        """
        return _IMP_atom.Dihedral_has_attribute(self, *args)

    def get_derivative(self, a0):
        r"""get_derivative(Dihedral self, FloatKey a0) -> double"""
        return _IMP_atom.Dihedral_get_derivative(self, a0)

    def get_name(self):
        r"""get_name(Dihedral self) -> std::string"""
        return _IMP_atom.Dihedral_get_name(self)

    def clear_caches(self):
        r"""clear_caches(Dihedral self)"""
        return _IMP_atom.Dihedral_clear_caches(self)

    def set_name(self, a0):
        r"""set_name(Dihedral self, std::string a0)"""
        return _IMP_atom.Dihedral_set_name(self, a0)

    def set_check_level(self, a0):
        r"""set_check_level(Dihedral self, IMP::CheckLevel a0)"""
        return _IMP_atom.Dihedral_set_check_level(self, a0)

    def add_to_derivative(self, a0, a1, a2):
        r"""add_to_derivative(Dihedral self, FloatKey a0, double a1, DerivativeAccumulator a2)"""
        return _IMP_atom.Dihedral_add_to_derivative(self, a0, a1, a2)

    def set_is_optimized(self, a0, a1):
        r"""set_is_optimized(Dihedral self, FloatKey a0, bool a1)"""
        return _IMP_atom.Dihedral_set_is_optimized(self, a0, a1)

    def get_is_optimized(self, a0):
        r"""get_is_optimized(Dihedral self, FloatKey a0) -> bool"""
        return _IMP_atom.Dihedral_get_is_optimized(self, a0)

    def get_check_level(self):
        r"""get_check_level(Dihedral self) -> IMP::CheckLevel"""
        return _IMP_atom.Dihedral_get_check_level(self)

    def __eq__(self, *args):
        r"""
        __eq__(Dihedral self, Dihedral o) -> bool
        __eq__(Dihedral self, Particle d) -> bool
        """
        return _IMP_atom.Dihedral___eq__(self, *args)

    def __ne__(self, *args):
        r"""
        __ne__(Dihedral self, Dihedral o) -> bool
        __ne__(Dihedral self, Particle d) -> bool
        """
        return _IMP_atom.Dihedral___ne__(self, *args)

    def __le__(self, *args):
        r"""
        __le__(Dihedral self, Dihedral o) -> bool
        __le__(Dihedral self, Particle d) -> bool
        """
        return _IMP_atom.Dihedral___le__(self, *args)

    def __lt__(self, *args):
        r"""
        __lt__(Dihedral self, Dihedral o) -> bool
        __lt__(Dihedral self, Particle d) -> bool
        """
        return _IMP_atom.Dihedral___lt__(self, *args)

    def __ge__(self, *args):
        r"""
        __ge__(Dihedral self, Dihedral o) -> bool
        __ge__(Dihedral self, Particle d) -> bool
        """
        return _IMP_atom.Dihedral___ge__(self, *args)

    def __gt__(self, *args):
        r"""
        __gt__(Dihedral self, Dihedral o) -> bool
        __gt__(Dihedral self, Particle d) -> bool
        """
        return _IMP_atom.Dihedral___gt__(self, *args)

    def __hash__(self):
        r"""__hash__(Dihedral self) -> std::size_t"""
        return _IMP_atom.Dihedral___hash__(self)

    def __str__(self):
        r"""__str__(Dihedral self) -> std::string"""
        return _IMP_atom.Dihedral___str__(self)

    def __repr__(self):
        r"""__repr__(Dihedral self) -> std::string"""
        return _IMP_atom.Dihedral___repr__(self)
    __swig_destroy__ = _IMP_atom.delete_Dihedral

# Register Dihedral in _IMP_atom:
_IMP_atom.Dihedral_swigregister(Dihedral)

def Dihedral_setup_particle(*args):
    r"""
    Dihedral_setup_particle(Model m, ParticleIndex pi, XYZ a, XYZ b, XYZ c, XYZ d) -> Dihedral
    Dihedral_setup_particle(_ParticleAdaptor decorator, XYZ a, XYZ b, XYZ c, XYZ d) -> Dihedral
    """
    return _IMP_atom.Dihedral_setup_particle(*args)

def Dihedral_get_is_setup(*args):
    r"""
    Dihedral_get_is_setup(_ParticleAdaptor p) -> bool
    Dihedral_get_is_setup(Model m, ParticleIndex pi) -> bool
    """
    return _IMP_atom.Dihedral_get_is_setup(*args)

def Dihedral_get_particle_key(i):
    r"""Dihedral_get_particle_key(unsigned int i) -> ParticleIndexKey"""
    return _IMP_atom.Dihedral_get_particle_key(i)

def Dihedral_get_ideal_key():
    r"""Dihedral_get_ideal_key() -> FloatKey"""
    return _IMP_atom.Dihedral_get_ideal_key()

def Dihedral_get_multiplicity_key():
    r"""Dihedral_get_multiplicity_key() -> IntKey"""
    return _IMP_atom.Dihedral_get_multiplicity_key()

def Dihedral_get_stiffness_key():
    r"""Dihedral_get_stiffness_key() -> FloatKey"""
    return _IMP_atom.Dihedral_get_stiffness_key()

class SmoothingFunction(IMP.Object):
    r"""Proxy of C++ IMP::atom::SmoothingFunction class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")

    def __call__(self, *args):
        r"""
        __call__(SmoothingFunction self, double score, double distance) -> double
        __call__(SmoothingFunction self, double score, double deriv, double distance) -> IMP::DerivativePair
        """
        return _IMP_atom.SmoothingFunction___call__(self, *args)
    __swig_destroy__ = _IMP_atom.delete_SmoothingFunction

    def __str__(self):
        r"""__str__(SmoothingFunction self) -> std::string"""
        return _IMP_atom.SmoothingFunction___str__(self)

    def __repr__(self):
        r"""__repr__(SmoothingFunction self) -> std::string"""
        return _IMP_atom.SmoothingFunction___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_SmoothingFunction(o)


# Register SmoothingFunction in _IMP_atom:
_IMP_atom.SmoothingFunction_swigregister(SmoothingFunction)

class ForceSwitch(SmoothingFunction):
    r"""Proxy of C++ IMP::atom::ForceSwitch class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, min_distance, max_distance):
        r"""__init__(ForceSwitch self, double min_distance, double max_distance) -> ForceSwitch"""
        _IMP_atom.ForceSwitch_swiginit(self, _IMP_atom.new_ForceSwitch(min_distance, max_distance))

    def __call__(self, *args):
        r"""
        __call__(ForceSwitch self, double score, double distance) -> double
        __call__(ForceSwitch self, double score, double deriv, double distance) -> IMP::DerivativePair
        """
        return _IMP_atom.ForceSwitch___call__(self, *args)

    def get_version_info(self):
        r"""get_version_info(ForceSwitch self) -> VersionInfo"""
        return _IMP_atom.ForceSwitch_get_version_info(self)

    def __str__(self):
        r"""__str__(ForceSwitch self) -> std::string"""
        return _IMP_atom.ForceSwitch___str__(self)

    def __repr__(self):
        r"""__repr__(ForceSwitch self) -> std::string"""
        return _IMP_atom.ForceSwitch___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_ForceSwitch(o)


# Register ForceSwitch in _IMP_atom:
_IMP_atom.ForceSwitch_swigregister(ForceSwitch)

class AngleSingletonScore(IMP.SingletonScore):
    r"""Proxy of C++ IMP::atom::AngleSingletonScore class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, f):
        r"""__init__(AngleSingletonScore self, UnaryFunction f) -> AngleSingletonScore"""
        _IMP_atom.AngleSingletonScore_swiginit(self, _IMP_atom.new_AngleSingletonScore(f))

    def do_get_inputs(self, m, pis):
        r"""do_get_inputs(AngleSingletonScore self, Model m, IMP::ParticleIndexes const & pis) -> IMP::ModelObjectsTemp"""
        return _IMP_atom.AngleSingletonScore_do_get_inputs(self, m, pis)

    def get_version_info(self):
        r"""get_version_info(AngleSingletonScore self) -> VersionInfo"""
        return _IMP_atom.AngleSingletonScore_get_version_info(self)

    def __str__(self):
        r"""__str__(AngleSingletonScore self) -> std::string"""
        return _IMP_atom.AngleSingletonScore___str__(self)

    def __repr__(self):
        r"""__repr__(AngleSingletonScore self) -> std::string"""
        return _IMP_atom.AngleSingletonScore___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_AngleSingletonScore(o)


# Register AngleSingletonScore in _IMP_atom:
_IMP_atom.AngleSingletonScore_swigregister(AngleSingletonScore)

class BondEndpointsRefiner(IMP.Refiner):
    r"""Proxy of C++ IMP::atom::BondEndpointsRefiner class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self):
        r"""__init__(BondEndpointsRefiner self) -> BondEndpointsRefiner"""
        _IMP_atom.BondEndpointsRefiner_swiginit(self, _IMP_atom.new_BondEndpointsRefiner())

    def do_get_inputs(self, m, pis):
        r"""do_get_inputs(BondEndpointsRefiner self, Model m, IMP::ParticleIndexes const & pis) -> IMP::ModelObjectsTemp"""
        return _IMP_atom.BondEndpointsRefiner_do_get_inputs(self, m, pis)

    def get_version_info(self):
        r"""get_version_info(BondEndpointsRefiner self) -> VersionInfo"""
        return _IMP_atom.BondEndpointsRefiner_get_version_info(self)

    def __str__(self):
        r"""__str__(BondEndpointsRefiner self) -> std::string"""
        return _IMP_atom.BondEndpointsRefiner___str__(self)

    def __repr__(self):
        r"""__repr__(BondEndpointsRefiner self) -> std::string"""
        return _IMP_atom.BondEndpointsRefiner___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_BondEndpointsRefiner(o)


# Register BondEndpointsRefiner in _IMP_atom:
_IMP_atom.BondEndpointsRefiner_swigregister(BondEndpointsRefiner)

class BondPairContainer(IMP.PairContainer):
    r"""Proxy of C++ IMP::atom::BondPairContainer class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, sc):
        r"""__init__(BondPairContainer self, SingletonContainer sc) -> BondPairContainer"""
        _IMP_atom.BondPairContainer_swiginit(self, _IMP_atom.new_BondPairContainer(sc))

    def do_get_inputs(self):
        r"""do_get_inputs(BondPairContainer self) -> IMP::ModelObjectsTemp"""
        return _IMP_atom.BondPairContainer_do_get_inputs(self)

    def do_apply(self, sm):
        r"""do_apply(BondPairContainer self, PairModifier sm)"""
        return _IMP_atom.BondPairContainer_do_apply(self, sm)

    def get_version_info(self):
        r"""get_version_info(BondPairContainer self) -> VersionInfo"""
        return _IMP_atom.BondPairContainer_get_version_info(self)

    def __str__(self):
        r"""__str__(BondPairContainer self) -> std::string"""
        return _IMP_atom.BondPairContainer___str__(self)

    def __repr__(self):
        r"""__repr__(BondPairContainer self) -> std::string"""
        return _IMP_atom.BondPairContainer___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_BondPairContainer(o)


# Register BondPairContainer in _IMP_atom:
_IMP_atom.BondPairContainer_swigregister(BondPairContainer)

class BondSingletonScore(IMP.SingletonScore):
    r"""Proxy of C++ IMP::atom::BondSingletonScore class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, f):
        r"""__init__(BondSingletonScore self, UnaryFunction f) -> BondSingletonScore"""
        _IMP_atom.BondSingletonScore_swiginit(self, _IMP_atom.new_BondSingletonScore(f))

    def get_unary_function(self):
        r"""get_unary_function(BondSingletonScore self) -> UnaryFunction"""
        return _IMP_atom.BondSingletonScore_get_unary_function(self)

    def do_get_inputs(self, m, pis):
        r"""do_get_inputs(BondSingletonScore self, Model m, IMP::ParticleIndexes const & pis) -> IMP::ModelObjectsTemp"""
        return _IMP_atom.BondSingletonScore_do_get_inputs(self, m, pis)

    def get_version_info(self):
        r"""get_version_info(BondSingletonScore self) -> VersionInfo"""
        return _IMP_atom.BondSingletonScore_get_version_info(self)

    def __str__(self):
        r"""__str__(BondSingletonScore self) -> std::string"""
        return _IMP_atom.BondSingletonScore___str__(self)

    def __repr__(self):
        r"""__repr__(BondSingletonScore self) -> std::string"""
        return _IMP_atom.BondSingletonScore___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_BondSingletonScore(o)


# Register BondSingletonScore in _IMP_atom:
_IMP_atom.BondSingletonScore_swigregister(BondSingletonScore)

class DihedralSingletonScore(IMP.SingletonScore):
    r"""Proxy of C++ IMP::atom::DihedralSingletonScore class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self):
        r"""__init__(DihedralSingletonScore self) -> DihedralSingletonScore"""
        _IMP_atom.DihedralSingletonScore_swiginit(self, _IMP_atom.new_DihedralSingletonScore())

    def do_get_inputs(self, m, pis):
        r"""do_get_inputs(DihedralSingletonScore self, Model m, IMP::ParticleIndexes const & pis) -> IMP::ModelObjectsTemp"""
        return _IMP_atom.DihedralSingletonScore_do_get_inputs(self, m, pis)

    def get_version_info(self):
        r"""get_version_info(DihedralSingletonScore self) -> VersionInfo"""
        return _IMP_atom.DihedralSingletonScore_get_version_info(self)

    def __str__(self):
        r"""__str__(DihedralSingletonScore self) -> std::string"""
        return _IMP_atom.DihedralSingletonScore___str__(self)

    def __repr__(self):
        r"""__repr__(DihedralSingletonScore self) -> std::string"""
        return _IMP_atom.DihedralSingletonScore___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_DihedralSingletonScore(o)


# Register DihedralSingletonScore in _IMP_atom:
_IMP_atom.DihedralSingletonScore_swigregister(DihedralSingletonScore)

class ImproperSingletonScore(IMP.SingletonScore):
    r"""Proxy of C++ IMP::atom::ImproperSingletonScore class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, f):
        r"""__init__(ImproperSingletonScore self, UnaryFunction f) -> ImproperSingletonScore"""
        _IMP_atom.ImproperSingletonScore_swiginit(self, _IMP_atom.new_ImproperSingletonScore(f))

    def do_get_inputs(self, m, pis):
        r"""do_get_inputs(ImproperSingletonScore self, Model m, IMP::ParticleIndexes const & pis) -> IMP::ModelObjectsTemp"""
        return _IMP_atom.ImproperSingletonScore_do_get_inputs(self, m, pis)

    def get_version_info(self):
        r"""get_version_info(ImproperSingletonScore self) -> VersionInfo"""
        return _IMP_atom.ImproperSingletonScore_get_version_info(self)

    def __str__(self):
        r"""__str__(ImproperSingletonScore self) -> std::string"""
        return _IMP_atom.ImproperSingletonScore___str__(self)

    def __repr__(self):
        r"""__repr__(ImproperSingletonScore self) -> std::string"""
        return _IMP_atom.ImproperSingletonScore___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_ImproperSingletonScore(o)


# Register ImproperSingletonScore in _IMP_atom:
_IMP_atom.ImproperSingletonScore_swigregister(ImproperSingletonScore)

class CenterOfMass(IMP.Decorator):
    r"""Proxy of C++ IMP::atom::CenterOfMass class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def get_constraint(self):
        r"""get_constraint(CenterOfMass self) -> Constraint"""
        return _IMP_atom.CenterOfMass_get_constraint(self)

    def get_mass(self):
        r"""get_mass(CenterOfMass self) -> IMP::Float"""
        return _IMP_atom.CenterOfMass_get_mass(self)

    def get_coordinate(self, i):
        r"""get_coordinate(CenterOfMass self, int i) -> IMP::Float"""
        return _IMP_atom.CenterOfMass_get_coordinate(self, i)

    def get_coordinates(self):
        r"""get_coordinates(CenterOfMass self) -> Vector3D"""
        return _IMP_atom.CenterOfMass_get_coordinates(self)

    def __init__(self, *args):
        r"""
        __init__(CenterOfMass self) -> CenterOfMass
        __init__(CenterOfMass self, Model m, ParticleIndex id) -> CenterOfMass
        __init__(CenterOfMass self, _ParticleAdaptor d) -> CenterOfMass
        """
        _IMP_atom.CenterOfMass_swiginit(self, _IMP_atom.new_CenterOfMass(*args))

    def show(self, *args):
        r"""show(CenterOfMass self, _ostream out=std::cout)"""
        return _IMP_atom.CenterOfMass_show(self, *args)

    @staticmethod
    def setup_particle(*args):
        r"""
        setup_particle(Model m, ParticleIndex pi, _ParticleIndexesAdaptor members) -> CenterOfMass
        setup_particle(_ParticleAdaptor decorator, _ParticleIndexesAdaptor members) -> CenterOfMass
        setup_particle(Model m, ParticleIndex pi, Refiner refiner) -> CenterOfMass
        setup_particle(_ParticleAdaptor decorator, Refiner refiner) -> CenterOfMass
        """
        return _IMP_atom.CenterOfMass_setup_particle(*args)

    @staticmethod
    def get_is_setup(*args):
        r"""
        get_is_setup(_ParticleAdaptor p) -> bool
        get_is_setup(Model m, ParticleIndex pi) -> bool
        """
        return _IMP_atom.CenterOfMass_get_is_setup(*args)

    def add_attribute(self, *args):
        r"""
        add_attribute(CenterOfMass self, FloatKey k, IMP::Float v, bool opt)
        add_attribute(CenterOfMass self, FloatKey a0, IMP::Float a1)
        add_attribute(CenterOfMass self, IntKey a0, IMP::Int a1)
        add_attribute(CenterOfMass self, FloatsKey a0, IMP::Floats a1)
        add_attribute(CenterOfMass self, IntsKey a0, IMP::Ints a1)
        add_attribute(CenterOfMass self, StringKey a0, IMP::String a1)
        add_attribute(CenterOfMass self, ParticleIndexKey a0, Particle a1)
        add_attribute(CenterOfMass self, ObjectKey a0, Object a1)
        """
        return _IMP_atom.CenterOfMass_add_attribute(self, *args)

    def get_value(self, *args):
        r"""
        get_value(CenterOfMass self, FloatKey a0) -> IMP::Float
        get_value(CenterOfMass self, IntKey a0) -> IMP::Int
        get_value(CenterOfMass self, FloatsKey a0) -> IMP::Floats
        get_value(CenterOfMass self, IntsKey a0) -> IMP::Ints
        get_value(CenterOfMass self, StringKey a0) -> IMP::String
        get_value(CenterOfMass self, ParticleIndexKey a0) -> Particle
        get_value(CenterOfMass self, ObjectKey a0) -> Object
        """
        return _IMP_atom.CenterOfMass_get_value(self, *args)

    def set_value(self, *args):
        r"""
        set_value(CenterOfMass self, FloatKey a0, IMP::Float a1)
        set_value(CenterOfMass self, IntKey a0, IMP::Int a1)
        set_value(CenterOfMass self, FloatsKey a0, IMP::Floats a1)
        set_value(CenterOfMass self, IntsKey a0, IMP::Ints a1)
        set_value(CenterOfMass self, StringKey a0, IMP::String a1)
        set_value(CenterOfMass self, ParticleIndexKey a0, Particle a1)
        set_value(CenterOfMass self, ObjectKey a0, Object a1)
        """
        return _IMP_atom.CenterOfMass_set_value(self, *args)

    def remove_attribute(self, *args):
        r"""
        remove_attribute(CenterOfMass self, FloatKey a0)
        remove_attribute(CenterOfMass self, IntKey a0)
        remove_attribute(CenterOfMass self, FloatsKey a0)
        remove_attribute(CenterOfMass self, IntsKey a0)
        remove_attribute(CenterOfMass self, StringKey a0)
        remove_attribute(CenterOfMass self, ParticleIndexKey a0)
        remove_attribute(CenterOfMass self, ObjectKey a0)
        """
        return _IMP_atom.CenterOfMass_remove_attribute(self, *args)

    def has_attribute(self, *args):
        r"""
        has_attribute(CenterOfMass self, FloatKey a0) -> bool
        has_attribute(CenterOfMass self, IntKey a0) -> bool
        has_attribute(CenterOfMass self, FloatsKey a0) -> bool
        has_attribute(CenterOfMass self, IntsKey a0) -> bool
        has_attribute(CenterOfMass self, StringKey a0) -> bool
        has_attribute(CenterOfMass self, ParticleIndexKey a0) -> bool
        has_attribute(CenterOfMass self, ObjectKey a0) -> bool
        """
        return _IMP_atom.CenterOfMass_has_attribute(self, *args)

    def get_derivative(self, a0):
        r"""get_derivative(CenterOfMass self, FloatKey a0) -> double"""
        return _IMP_atom.CenterOfMass_get_derivative(self, a0)

    def get_name(self):
        r"""get_name(CenterOfMass self) -> std::string"""
        return _IMP_atom.CenterOfMass_get_name(self)

    def clear_caches(self):
        r"""clear_caches(CenterOfMass self)"""
        return _IMP_atom.CenterOfMass_clear_caches(self)

    def set_name(self, a0):
        r"""set_name(CenterOfMass self, std::string a0)"""
        return _IMP_atom.CenterOfMass_set_name(self, a0)

    def set_check_level(self, a0):
        r"""set_check_level(CenterOfMass self, IMP::CheckLevel a0)"""
        return _IMP_atom.CenterOfMass_set_check_level(self, a0)

    def add_to_derivative(self, a0, a1, a2):
        r"""add_to_derivative(CenterOfMass self, FloatKey a0, double a1, DerivativeAccumulator a2)"""
        return _IMP_atom.CenterOfMass_add_to_derivative(self, a0, a1, a2)

    def set_is_optimized(self, a0, a1):
        r"""set_is_optimized(CenterOfMass self, FloatKey a0, bool a1)"""
        return _IMP_atom.CenterOfMass_set_is_optimized(self, a0, a1)

    def get_is_optimized(self, a0):
        r"""get_is_optimized(CenterOfMass self, FloatKey a0) -> bool"""
        return _IMP_atom.CenterOfMass_get_is_optimized(self, a0)

    def get_check_level(self):
        r"""get_check_level(CenterOfMass self) -> IMP::CheckLevel"""
        return _IMP_atom.CenterOfMass_get_check_level(self)

    def __eq__(self, *args):
        r"""
        __eq__(CenterOfMass self, CenterOfMass o) -> bool
        __eq__(CenterOfMass self, Particle d) -> bool
        """
        return _IMP_atom.CenterOfMass___eq__(self, *args)

    def __ne__(self, *args):
        r"""
        __ne__(CenterOfMass self, CenterOfMass o) -> bool
        __ne__(CenterOfMass self, Particle d) -> bool
        """
        return _IMP_atom.CenterOfMass___ne__(self, *args)

    def __le__(self, *args):
        r"""
        __le__(CenterOfMass self, CenterOfMass o) -> bool
        __le__(CenterOfMass self, Particle d) -> bool
        """
        return _IMP_atom.CenterOfMass___le__(self, *args)

    def __lt__(self, *args):
        r"""
        __lt__(CenterOfMass self, CenterOfMass o) -> bool
        __lt__(CenterOfMass self, Particle d) -> bool
        """
        return _IMP_atom.CenterOfMass___lt__(self, *args)

    def __ge__(self, *args):
        r"""
        __ge__(CenterOfMass self, CenterOfMass o) -> bool
        __ge__(CenterOfMass self, Particle d) -> bool
        """
        return _IMP_atom.CenterOfMass___ge__(self, *args)

    def __gt__(self, *args):
        r"""
        __gt__(CenterOfMass self, CenterOfMass o) -> bool
        __gt__(CenterOfMass self, Particle d) -> bool
        """
        return _IMP_atom.CenterOfMass___gt__(self, *args)

    def __hash__(self):
        r"""__hash__(CenterOfMass self) -> std::size_t"""
        return _IMP_atom.CenterOfMass___hash__(self)

    def __str__(self):
        r"""__str__(CenterOfMass self) -> std::string"""
        return _IMP_atom.CenterOfMass___str__(self)

    def __repr__(self):
        r"""__repr__(CenterOfMass self) -> std::string"""
        return _IMP_atom.CenterOfMass___repr__(self)
    __swig_destroy__ = _IMP_atom.delete_CenterOfMass

# Register CenterOfMass in _IMP_atom:
_IMP_atom.CenterOfMass_swigregister(CenterOfMass)

def CenterOfMass_setup_particle(*args):
    r"""
    CenterOfMass_setup_particle(Model m, ParticleIndex pi, _ParticleIndexesAdaptor members) -> CenterOfMass
    CenterOfMass_setup_particle(_ParticleAdaptor decorator, _ParticleIndexesAdaptor members) -> CenterOfMass
    CenterOfMass_setup_particle(Model m, ParticleIndex pi, Refiner refiner) -> CenterOfMass
    CenterOfMass_setup_particle(_ParticleAdaptor decorator, Refiner refiner) -> CenterOfMass
    """
    return _IMP_atom.CenterOfMass_setup_particle(*args)

def CenterOfMass_get_is_setup(*args):
    r"""
    CenterOfMass_get_is_setup(_ParticleAdaptor p) -> bool
    CenterOfMass_get_is_setup(Model m, ParticleIndex pi) -> bool
    """
    return _IMP_atom.CenterOfMass_get_is_setup(*args)

class CoverBond(IMP.SingletonModifier):
    r"""Proxy of C++ IMP::atom::CoverBond class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self):
        r"""__init__(CoverBond self) -> CoverBond"""
        _IMP_atom.CoverBond_swiginit(self, _IMP_atom.new_CoverBond())

    def do_get_inputs(self, m, pis):
        r"""do_get_inputs(CoverBond self, Model m, IMP::ParticleIndexes const & pis) -> IMP::ModelObjectsTemp"""
        return _IMP_atom.CoverBond_do_get_inputs(self, m, pis)

    def do_get_outputs(self, m, pis):
        r"""do_get_outputs(CoverBond self, Model m, IMP::ParticleIndexes const & pis) -> IMP::ModelObjectsTemp"""
        return _IMP_atom.CoverBond_do_get_outputs(self, m, pis)

    def get_version_info(self):
        r"""get_version_info(CoverBond self) -> VersionInfo"""
        return _IMP_atom.CoverBond_get_version_info(self)

    def __str__(self):
        r"""__str__(CoverBond self) -> std::string"""
        return _IMP_atom.CoverBond___str__(self)

    def __repr__(self):
        r"""__repr__(CoverBond self) -> std::string"""
        return _IMP_atom.CoverBond___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_CoverBond(o)


# Register CoverBond in _IMP_atom:
_IMP_atom.CoverBond_swigregister(CoverBond)

class Simulator(IMP.Optimizer):
    r"""Proxy of C++ IMP::atom::Simulator class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""__init__(Simulator self, Model m, std::string name="Simulator %1%", double wave_factor=1.0) -> Simulator"""
        if self.__class__ == Simulator:
            _self = None
        else:
            _self = self
        _IMP_atom.Simulator_swiginit(self, _IMP_atom.new_Simulator(_self, *args))

        if self.__class__ != Simulator:
            _director_objects.register(self)




    def simulate(self, time_in_fs):
        r"""simulate(Simulator self, double time_in_fs) -> double"""
        return _IMP_atom.Simulator_simulate(self, time_in_fs)

    def simulate_wave(self, time_in_fs, max_time_step_factor=10.0, base=1.5):
        r"""simulate_wave(Simulator self, double time_in_fs, double max_time_step_factor=10.0, double base=1.5) -> double"""
        return _IMP_atom.Simulator_simulate_wave(self, time_in_fs, max_time_step_factor, base)

    def get_temperature(self):
        r"""get_temperature(Simulator self) -> double"""
        return _IMP_atom.Simulator_get_temperature(self)

    def set_temperature(self, d):
        r"""set_temperature(Simulator self, double d)"""
        return _IMP_atom.Simulator_set_temperature(self, d)

    def set_maximum_time_step(self, ts):
        r"""set_maximum_time_step(Simulator self, double ts)"""
        return _IMP_atom.Simulator_set_maximum_time_step(self, ts)

    def get_maximum_time_step(self):
        r"""get_maximum_time_step(Simulator self) -> double"""
        return _IMP_atom.Simulator_get_maximum_time_step(self)

    def get_last_time_step(self):
        r"""get_last_time_step(Simulator self) -> double"""
        return _IMP_atom.Simulator_get_last_time_step(self)

    def set_time_step(self, ts):
        r"""set_time_step(Simulator self, double ts)"""
        return _IMP_atom.Simulator_set_time_step(self, ts)

    def get_kt(self):
        r"""get_kt(Simulator self) -> double"""
        return _IMP_atom.Simulator_get_kt(self)

    def get_current_time(self):
        r"""get_current_time(Simulator self) -> double"""
        return _IMP_atom.Simulator_get_current_time(self)

    def set_current_time(self, ct):
        r"""set_current_time(Simulator self, double ct)"""
        return _IMP_atom.Simulator_set_current_time(self, ct)

    def get_simulation_particles(self):
        r"""get_simulation_particles(Simulator self) -> IMP::ParticlesTemp"""
        return _IMP_atom.Simulator_get_simulation_particles(self)

    def get_simulation_particle_indexes(self):
        r"""get_simulation_particle_indexes(Simulator self) -> IMP::ParticleIndexes"""
        return _IMP_atom.Simulator_get_simulation_particle_indexes(self)

    def remove_particle(self, d):
        r"""remove_particle(Simulator self, Particle d)"""
        return _IMP_atom.Simulator_remove_particle(self, d)

    def remove_particles(self, d):
        r"""remove_particles(Simulator self, IMP::Particles const & d)"""
        return _IMP_atom.Simulator_remove_particles(self, d)

    def set_particles(self, ps):
        r"""set_particles(Simulator self, IMP::Particles const & ps)"""
        return _IMP_atom.Simulator_set_particles(self, ps)

    def set_particles_order(self, objs):
        r"""set_particles_order(Simulator self, IMP::Particles const & objs)"""
        return _IMP_atom.Simulator_set_particles_order(self, objs)

    def add_particle(self, obj):
        r"""add_particle(Simulator self, Particle obj) -> unsigned int"""
        return _IMP_atom.Simulator_add_particle(self, obj)

    def add_particles(self, objs):
        r"""add_particles(Simulator self, IMP::Particles const & objs)"""
        return _IMP_atom.Simulator_add_particles(self, objs)

    def clear_particles(self):
        r"""clear_particles(Simulator self)"""
        return _IMP_atom.Simulator_clear_particles(self)

    def get_number_of_particles(self):
        r"""get_number_of_particles(Simulator self) -> unsigned int"""
        return _IMP_atom.Simulator_get_number_of_particles(self)

    def get_has_particles(self):
        r"""get_has_particles(Simulator self) -> bool"""
        return _IMP_atom.Simulator_get_has_particles(self)

    def get_particle(self, i):
        r"""get_particle(Simulator self, unsigned int i) -> Particle"""
        return _IMP_atom.Simulator_get_particle(self, i)

    def get_particles(self):
        r"""get_particles(Simulator self) -> IMP::Particles"""
        return _IMP_atom.Simulator_get_particles(self)

    def reserve_particles(self, sz):
        r"""reserve_particles(Simulator self, unsigned int sz)"""
        return _IMP_atom.Simulator_reserve_particles(self, sz)

    def do_optimize(self, max_steps):
        r"""do_optimize(Simulator self, unsigned int max_steps) -> IMP::Float"""
        return _IMP_atom.Simulator_do_optimize(self, max_steps)

    def setup(self, arg0):
        r"""setup(Simulator self, IMP::ParticleIndexes const & arg0)"""
        return _IMP_atom.Simulator_setup(self, arg0)

    def do_step(self, sc, dt):
        r"""do_step(Simulator self, IMP::ParticleIndexes const & sc, double dt) -> double"""
        return _IMP_atom.Simulator_do_step(self, sc, dt)

    def get_is_simulation_particle(self, p):
        r"""get_is_simulation_particle(Simulator self, ParticleIndex p) -> bool"""
        return _IMP_atom.Simulator_get_is_simulation_particle(self, p)

    def do_simulate(self, time):
        r"""do_simulate(Simulator self, double time) -> double"""
        return _IMP_atom.Simulator_do_simulate(self, time)

    def do_simulate_wave(self, time_in_fs, max_time_step_factor=10.0, base=1.5):
        r"""do_simulate_wave(Simulator self, double time_in_fs, double max_time_step_factor=10.0, double base=1.5) -> double"""
        return _IMP_atom.Simulator_do_simulate_wave(self, time_in_fs, max_time_step_factor, base)

    def __str__(self):
        r"""__str__(Simulator self) -> std::string"""
        return _IMP_atom.Simulator___str__(self)

    def __repr__(self):
        r"""__repr__(Simulator self) -> std::string"""
        return _IMP_atom.Simulator___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_Simulator(o)


    def get_type_name(self):
        return self.__class__.__name__
    def do_show(self, out):
        pass
    def get_version_info(self):
        if"IMP::atom" == "IMP":
          return VersionInfo(self.__module__,
                             __import__(self.__module__).get_module_version())
        else:
          return IMP.VersionInfo(self.__module__,
                             __import__(self.__module__).get_module_version())
    @staticmethod
    def get_from(o):
       return _object_cast_to_Simulator(o)

    __swig_destroy__ = _IMP_atom.delete_Simulator
    def __disown__(self):
        self.this.disown()
        _IMP_atom.disown_Simulator(self)
        return weakref.proxy(self)

    def do_destroy(self):
        r"""do_destroy(Simulator self)"""
        return _IMP_atom.Simulator_do_destroy(self)

    def handle_set_has_required_score_states(self, arg0):
        r"""handle_set_has_required_score_states(Simulator self, bool arg0)"""
        return _IMP_atom.Simulator_handle_set_has_required_score_states(self, arg0)

    def do_get_inputs(self):
        r"""do_get_inputs(Simulator self) -> IMP::ModelObjectsTemp"""
        return _IMP_atom.Simulator_do_get_inputs(self)

    def do_get_outputs(self):
        r"""do_get_outputs(Simulator self) -> IMP::ModelObjectsTemp"""
        return _IMP_atom.Simulator_do_get_outputs(self)

    def do_get_interactions(self):
        r"""do_get_interactions(Simulator self) -> IMP::ModelObjectsTemps"""
        return _IMP_atom.Simulator_do_get_interactions(self)

# Register Simulator in _IMP_atom:
_IMP_atom.Simulator_swigregister(Simulator)

IMP_ATOM_DEFAULT_BD_RANDOM_POOL_SIZE = _IMP_atom.IMP_ATOM_DEFAULT_BD_RANDOM_POOL_SIZE

class BrownianDynamics(Simulator):
    r"""Proxy of C++ IMP::atom::BrownianDynamics class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""__init__(BrownianDynamics self, Model m, std::string name="BrownianDynamics%1%", double wave_factor=1.0, unsigned int random_pool_size=10000) -> BrownianDynamics"""
        _IMP_atom.BrownianDynamics_swiginit(self, _IMP_atom.new_BrownianDynamics(*args))

    def set_maximum_move(self, ms_in_A):
        r"""set_maximum_move(BrownianDynamics self, double ms_in_A)"""
        return _IMP_atom.BrownianDynamics_set_maximum_move(self, ms_in_A)

    def set_use_stochastic_runge_kutta(self, tf):
        r"""set_use_stochastic_runge_kutta(BrownianDynamics self, bool tf)"""
        return _IMP_atom.BrownianDynamics_set_use_stochastic_runge_kutta(self, tf)

    def get_version_info(self):
        r"""get_version_info(BrownianDynamics self) -> VersionInfo"""
        return _IMP_atom.BrownianDynamics_get_version_info(self)

    def __str__(self):
        r"""__str__(BrownianDynamics self) -> std::string"""
        return _IMP_atom.BrownianDynamics___str__(self)

    def __repr__(self):
        r"""__repr__(BrownianDynamics self) -> std::string"""
        return _IMP_atom.BrownianDynamics___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_BrownianDynamics(o)


# Register BrownianDynamics in _IMP_atom:
_IMP_atom.BrownianDynamics_swigregister(BrownianDynamics)


def get_maximum_time_step_estimate(bd):
    r"""get_maximum_time_step_estimate(BrownianDynamics bd) -> double"""
    return _IMP_atom.get_maximum_time_step_estimate(bd)

def get_harmonic_sigma(D, f):
    r"""get_harmonic_sigma(double D, double f) -> double"""
    return _IMP_atom.get_harmonic_sigma(D, f)
class BrownianDynamicsTAMD(BrownianDynamics):
    r"""Proxy of C++ IMP::atom::BrownianDynamicsTAMD class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""__init__(BrownianDynamicsTAMD self, Model m, std::string name="BrownianDynamicsTAMD%1%", double wave_factor=1.0) -> BrownianDynamicsTAMD"""
        _IMP_atom.BrownianDynamicsTAMD_swiginit(self, _IMP_atom.new_BrownianDynamicsTAMD(*args))

    def __str__(self):
        r"""__str__(BrownianDynamicsTAMD self) -> std::string"""
        return _IMP_atom.BrownianDynamicsTAMD___str__(self)

    def __repr__(self):
        r"""__repr__(BrownianDynamicsTAMD self) -> std::string"""
        return _IMP_atom.BrownianDynamicsTAMD___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_BrownianDynamicsTAMD(o)

    __swig_destroy__ = _IMP_atom.delete_BrownianDynamicsTAMD

# Register BrownianDynamicsTAMD in _IMP_atom:
_IMP_atom.BrownianDynamicsTAMD_swigregister(BrownianDynamicsTAMD)

class Diffusion(IMP.core.XYZ):
    r"""Proxy of C++ IMP::atom::Diffusion class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(Diffusion self) -> Diffusion
        __init__(Diffusion self, Model m, ParticleIndex id) -> Diffusion
        __init__(Diffusion self, _ParticleAdaptor d) -> Diffusion
        """
        _IMP_atom.Diffusion_swiginit(self, _IMP_atom.new_Diffusion(*args))

    def show(self, *args):
        r"""show(Diffusion self, _ostream out=std::cout)"""
        return _IMP_atom.Diffusion_show(self, *args)

    @staticmethod
    def setup_particle(*args):
        r"""
        setup_particle(Model m, ParticleIndex pi, IMP::Float D) -> Diffusion
        setup_particle(_ParticleAdaptor decorator, IMP::Float D) -> Diffusion
        setup_particle(Model m, ParticleIndex pi, Vector3D v, IMP::Float D) -> Diffusion
        setup_particle(_ParticleAdaptor decorator, Vector3D v, IMP::Float D) -> Diffusion
        setup_particle(Model m, ParticleIndex pi) -> Diffusion
        setup_particle(_ParticleAdaptor decorator) -> Diffusion
        """
        return _IMP_atom.Diffusion_setup_particle(*args)

    @staticmethod
    def get_is_setup(*args):
        r"""
        get_is_setup(_ParticleAdaptor p) -> bool
        get_is_setup(Model m, ParticleIndex p) -> bool
        """
        return _IMP_atom.Diffusion_get_is_setup(*args)

    def set_diffusion_coefficient(self, d):
        r"""set_diffusion_coefficient(Diffusion self, double d)"""
        return _IMP_atom.Diffusion_set_diffusion_coefficient(self, d)

    def get_diffusion_coefficient(self):
        r"""get_diffusion_coefficient(Diffusion self) -> double"""
        return _IMP_atom.Diffusion_get_diffusion_coefficient(self)

    @staticmethod
    def get_diffusion_coefficient_key():
        r"""get_diffusion_coefficient_key() -> FloatKey"""
        return _IMP_atom.Diffusion_get_diffusion_coefficient_key()

    def add_attribute(self, *args):
        r"""
        add_attribute(Diffusion self, FloatKey k, IMP::Float v, bool opt)
        add_attribute(Diffusion self, FloatKey a0, IMP::Float a1)
        add_attribute(Diffusion self, IntKey a0, IMP::Int a1)
        add_attribute(Diffusion self, FloatsKey a0, IMP::Floats a1)
        add_attribute(Diffusion self, IntsKey a0, IMP::Ints a1)
        add_attribute(Diffusion self, StringKey a0, IMP::String a1)
        add_attribute(Diffusion self, ParticleIndexKey a0, Particle a1)
        add_attribute(Diffusion self, ObjectKey a0, Object a1)
        """
        return _IMP_atom.Diffusion_add_attribute(self, *args)

    def get_value(self, *args):
        r"""
        get_value(Diffusion self, FloatKey a0) -> IMP::Float
        get_value(Diffusion self, IntKey a0) -> IMP::Int
        get_value(Diffusion self, FloatsKey a0) -> IMP::Floats
        get_value(Diffusion self, IntsKey a0) -> IMP::Ints
        get_value(Diffusion self, StringKey a0) -> IMP::String
        get_value(Diffusion self, ParticleIndexKey a0) -> Particle
        get_value(Diffusion self, ObjectKey a0) -> Object
        """
        return _IMP_atom.Diffusion_get_value(self, *args)

    def set_value(self, *args):
        r"""
        set_value(Diffusion self, FloatKey a0, IMP::Float a1)
        set_value(Diffusion self, IntKey a0, IMP::Int a1)
        set_value(Diffusion self, FloatsKey a0, IMP::Floats a1)
        set_value(Diffusion self, IntsKey a0, IMP::Ints a1)
        set_value(Diffusion self, StringKey a0, IMP::String a1)
        set_value(Diffusion self, ParticleIndexKey a0, Particle a1)
        set_value(Diffusion self, ObjectKey a0, Object a1)
        """
        return _IMP_atom.Diffusion_set_value(self, *args)

    def remove_attribute(self, *args):
        r"""
        remove_attribute(Diffusion self, FloatKey a0)
        remove_attribute(Diffusion self, IntKey a0)
        remove_attribute(Diffusion self, FloatsKey a0)
        remove_attribute(Diffusion self, IntsKey a0)
        remove_attribute(Diffusion self, StringKey a0)
        remove_attribute(Diffusion self, ParticleIndexKey a0)
        remove_attribute(Diffusion self, ObjectKey a0)
        """
        return _IMP_atom.Diffusion_remove_attribute(self, *args)

    def has_attribute(self, *args):
        r"""
        has_attribute(Diffusion self, FloatKey a0) -> bool
        has_attribute(Diffusion self, IntKey a0) -> bool
        has_attribute(Diffusion self, FloatsKey a0) -> bool
        has_attribute(Diffusion self, IntsKey a0) -> bool
        has_attribute(Diffusion self, StringKey a0) -> bool
        has_attribute(Diffusion self, ParticleIndexKey a0) -> bool
        has_attribute(Diffusion self, ObjectKey a0) -> bool
        """
        return _IMP_atom.Diffusion_has_attribute(self, *args)

    def get_derivative(self, a0):
        r"""get_derivative(Diffusion self, FloatKey a0) -> double"""
        return _IMP_atom.Diffusion_get_derivative(self, a0)

    def get_name(self):
        r"""get_name(Diffusion self) -> std::string"""
        return _IMP_atom.Diffusion_get_name(self)

    def clear_caches(self):
        r"""clear_caches(Diffusion self)"""
        return _IMP_atom.Diffusion_clear_caches(self)

    def set_name(self, a0):
        r"""set_name(Diffusion self, std::string a0)"""
        return _IMP_atom.Diffusion_set_name(self, a0)

    def set_check_level(self, a0):
        r"""set_check_level(Diffusion self, IMP::CheckLevel a0)"""
        return _IMP_atom.Diffusion_set_check_level(self, a0)

    def add_to_derivative(self, a0, a1, a2):
        r"""add_to_derivative(Diffusion self, FloatKey a0, double a1, DerivativeAccumulator a2)"""
        return _IMP_atom.Diffusion_add_to_derivative(self, a0, a1, a2)

    def set_is_optimized(self, a0, a1):
        r"""set_is_optimized(Diffusion self, FloatKey a0, bool a1)"""
        return _IMP_atom.Diffusion_set_is_optimized(self, a0, a1)

    def get_is_optimized(self, a0):
        r"""get_is_optimized(Diffusion self, FloatKey a0) -> bool"""
        return _IMP_atom.Diffusion_get_is_optimized(self, a0)

    def get_check_level(self):
        r"""get_check_level(Diffusion self) -> IMP::CheckLevel"""
        return _IMP_atom.Diffusion_get_check_level(self)

    def __eq__(self, *args):
        r"""
        __eq__(Diffusion self, Diffusion o) -> bool
        __eq__(Diffusion self, Particle d) -> bool
        """
        return _IMP_atom.Diffusion___eq__(self, *args)

    def __ne__(self, *args):
        r"""
        __ne__(Diffusion self, Diffusion o) -> bool
        __ne__(Diffusion self, Particle d) -> bool
        """
        return _IMP_atom.Diffusion___ne__(self, *args)

    def __le__(self, *args):
        r"""
        __le__(Diffusion self, Diffusion o) -> bool
        __le__(Diffusion self, Particle d) -> bool
        """
        return _IMP_atom.Diffusion___le__(self, *args)

    def __lt__(self, *args):
        r"""
        __lt__(Diffusion self, Diffusion o) -> bool
        __lt__(Diffusion self, Particle d) -> bool
        """
        return _IMP_atom.Diffusion___lt__(self, *args)

    def __ge__(self, *args):
        r"""
        __ge__(Diffusion self, Diffusion o) -> bool
        __ge__(Diffusion self, Particle d) -> bool
        """
        return _IMP_atom.Diffusion___ge__(self, *args)

    def __gt__(self, *args):
        r"""
        __gt__(Diffusion self, Diffusion o) -> bool
        __gt__(Diffusion self, Particle d) -> bool
        """
        return _IMP_atom.Diffusion___gt__(self, *args)

    def __hash__(self):
        r"""__hash__(Diffusion self) -> std::size_t"""
        return _IMP_atom.Diffusion___hash__(self)

    def __str__(self):
        r"""__str__(Diffusion self) -> std::string"""
        return _IMP_atom.Diffusion___str__(self)

    def __repr__(self):
        r"""__repr__(Diffusion self) -> std::string"""
        return _IMP_atom.Diffusion___repr__(self)
    __swig_destroy__ = _IMP_atom.delete_Diffusion

# Register Diffusion in _IMP_atom:
_IMP_atom.Diffusion_swigregister(Diffusion)

def Diffusion_setup_particle(*args):
    r"""
    Diffusion_setup_particle(Model m, ParticleIndex pi, IMP::Float D) -> Diffusion
    Diffusion_setup_particle(_ParticleAdaptor decorator, IMP::Float D) -> Diffusion
    Diffusion_setup_particle(Model m, ParticleIndex pi, Vector3D v, IMP::Float D) -> Diffusion
    Diffusion_setup_particle(_ParticleAdaptor decorator, Vector3D v, IMP::Float D) -> Diffusion
    Diffusion_setup_particle(Model m, ParticleIndex pi) -> Diffusion
    Diffusion_setup_particle(_ParticleAdaptor decorator) -> Diffusion
    """
    return _IMP_atom.Diffusion_setup_particle(*args)

def Diffusion_get_is_setup(*args):
    r"""
    Diffusion_get_is_setup(_ParticleAdaptor p) -> bool
    Diffusion_get_is_setup(Model m, ParticleIndex p) -> bool
    """
    return _IMP_atom.Diffusion_get_is_setup(*args)

def Diffusion_get_diffusion_coefficient_key():
    r"""Diffusion_get_diffusion_coefficient_key() -> FloatKey"""
    return _IMP_atom.Diffusion_get_diffusion_coefficient_key()


def get_diffusion_coefficient_from_cm2_per_second(din):
    r"""get_diffusion_coefficient_from_cm2_per_second(double din) -> double"""
    return _IMP_atom.get_diffusion_coefficient_from_cm2_per_second(din)
class RigidBodyDiffusion(Diffusion):
    r"""Proxy of C++ IMP::atom::RigidBodyDiffusion class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(RigidBodyDiffusion self) -> RigidBodyDiffusion
        __init__(RigidBodyDiffusion self, Model m, ParticleIndex id) -> RigidBodyDiffusion
        __init__(RigidBodyDiffusion self, _ParticleAdaptor d) -> RigidBodyDiffusion
        """
        _IMP_atom.RigidBodyDiffusion_swiginit(self, _IMP_atom.new_RigidBodyDiffusion(*args))

    def show(self, *args):
        r"""show(RigidBodyDiffusion self, _ostream out=std::cout)"""
        return _IMP_atom.RigidBodyDiffusion_show(self, *args)

    @staticmethod
    def setup_particle(*args):
        r"""
        setup_particle(Model m, ParticleIndex pi) -> RigidBodyDiffusion
        setup_particle(_ParticleAdaptor decorator) -> RigidBodyDiffusion
        """
        return _IMP_atom.RigidBodyDiffusion_setup_particle(*args)

    def get_rotational_diffusion_coefficient(self):
        r"""get_rotational_diffusion_coefficient(RigidBodyDiffusion self) -> double"""
        return _IMP_atom.RigidBodyDiffusion_get_rotational_diffusion_coefficient(self)

    def set_rotational_diffusion_coefficient(self, d):
        r"""set_rotational_diffusion_coefficient(RigidBodyDiffusion self, double d)"""
        return _IMP_atom.RigidBodyDiffusion_set_rotational_diffusion_coefficient(self, d)

    @staticmethod
    def get_is_setup(*args):
        r"""
        get_is_setup(_ParticleAdaptor p) -> bool
        get_is_setup(Model m, ParticleIndex p) -> bool
        """
        return _IMP_atom.RigidBodyDiffusion_get_is_setup(*args)

    @staticmethod
    def get_rotational_diffusion_coefficient_key():
        r"""get_rotational_diffusion_coefficient_key() -> FloatKey"""
        return _IMP_atom.RigidBodyDiffusion_get_rotational_diffusion_coefficient_key()

    def add_attribute(self, *args):
        r"""
        add_attribute(RigidBodyDiffusion self, FloatKey k, IMP::Float v, bool opt)
        add_attribute(RigidBodyDiffusion self, FloatKey a0, IMP::Float a1)
        add_attribute(RigidBodyDiffusion self, IntKey a0, IMP::Int a1)
        add_attribute(RigidBodyDiffusion self, FloatsKey a0, IMP::Floats a1)
        add_attribute(RigidBodyDiffusion self, IntsKey a0, IMP::Ints a1)
        add_attribute(RigidBodyDiffusion self, StringKey a0, IMP::String a1)
        add_attribute(RigidBodyDiffusion self, ParticleIndexKey a0, Particle a1)
        add_attribute(RigidBodyDiffusion self, ObjectKey a0, Object a1)
        """
        return _IMP_atom.RigidBodyDiffusion_add_attribute(self, *args)

    def get_value(self, *args):
        r"""
        get_value(RigidBodyDiffusion self, FloatKey a0) -> IMP::Float
        get_value(RigidBodyDiffusion self, IntKey a0) -> IMP::Int
        get_value(RigidBodyDiffusion self, FloatsKey a0) -> IMP::Floats
        get_value(RigidBodyDiffusion self, IntsKey a0) -> IMP::Ints
        get_value(RigidBodyDiffusion self, StringKey a0) -> IMP::String
        get_value(RigidBodyDiffusion self, ParticleIndexKey a0) -> Particle
        get_value(RigidBodyDiffusion self, ObjectKey a0) -> Object
        """
        return _IMP_atom.RigidBodyDiffusion_get_value(self, *args)

    def set_value(self, *args):
        r"""
        set_value(RigidBodyDiffusion self, FloatKey a0, IMP::Float a1)
        set_value(RigidBodyDiffusion self, IntKey a0, IMP::Int a1)
        set_value(RigidBodyDiffusion self, FloatsKey a0, IMP::Floats a1)
        set_value(RigidBodyDiffusion self, IntsKey a0, IMP::Ints a1)
        set_value(RigidBodyDiffusion self, StringKey a0, IMP::String a1)
        set_value(RigidBodyDiffusion self, ParticleIndexKey a0, Particle a1)
        set_value(RigidBodyDiffusion self, ObjectKey a0, Object a1)
        """
        return _IMP_atom.RigidBodyDiffusion_set_value(self, *args)

    def remove_attribute(self, *args):
        r"""
        remove_attribute(RigidBodyDiffusion self, FloatKey a0)
        remove_attribute(RigidBodyDiffusion self, IntKey a0)
        remove_attribute(RigidBodyDiffusion self, FloatsKey a0)
        remove_attribute(RigidBodyDiffusion self, IntsKey a0)
        remove_attribute(RigidBodyDiffusion self, StringKey a0)
        remove_attribute(RigidBodyDiffusion self, ParticleIndexKey a0)
        remove_attribute(RigidBodyDiffusion self, ObjectKey a0)
        """
        return _IMP_atom.RigidBodyDiffusion_remove_attribute(self, *args)

    def has_attribute(self, *args):
        r"""
        has_attribute(RigidBodyDiffusion self, FloatKey a0) -> bool
        has_attribute(RigidBodyDiffusion self, IntKey a0) -> bool
        has_attribute(RigidBodyDiffusion self, FloatsKey a0) -> bool
        has_attribute(RigidBodyDiffusion self, IntsKey a0) -> bool
        has_attribute(RigidBodyDiffusion self, StringKey a0) -> bool
        has_attribute(RigidBodyDiffusion self, ParticleIndexKey a0) -> bool
        has_attribute(RigidBodyDiffusion self, ObjectKey a0) -> bool
        """
        return _IMP_atom.RigidBodyDiffusion_has_attribute(self, *args)

    def get_derivative(self, a0):
        r"""get_derivative(RigidBodyDiffusion self, FloatKey a0) -> double"""
        return _IMP_atom.RigidBodyDiffusion_get_derivative(self, a0)

    def get_name(self):
        r"""get_name(RigidBodyDiffusion self) -> std::string"""
        return _IMP_atom.RigidBodyDiffusion_get_name(self)

    def clear_caches(self):
        r"""clear_caches(RigidBodyDiffusion self)"""
        return _IMP_atom.RigidBodyDiffusion_clear_caches(self)

    def set_name(self, a0):
        r"""set_name(RigidBodyDiffusion self, std::string a0)"""
        return _IMP_atom.RigidBodyDiffusion_set_name(self, a0)

    def set_check_level(self, a0):
        r"""set_check_level(RigidBodyDiffusion self, IMP::CheckLevel a0)"""
        return _IMP_atom.RigidBodyDiffusion_set_check_level(self, a0)

    def add_to_derivative(self, a0, a1, a2):
        r"""add_to_derivative(RigidBodyDiffusion self, FloatKey a0, double a1, DerivativeAccumulator a2)"""
        return _IMP_atom.RigidBodyDiffusion_add_to_derivative(self, a0, a1, a2)

    def set_is_optimized(self, a0, a1):
        r"""set_is_optimized(RigidBodyDiffusion self, FloatKey a0, bool a1)"""
        return _IMP_atom.RigidBodyDiffusion_set_is_optimized(self, a0, a1)

    def get_is_optimized(self, a0):
        r"""get_is_optimized(RigidBodyDiffusion self, FloatKey a0) -> bool"""
        return _IMP_atom.RigidBodyDiffusion_get_is_optimized(self, a0)

    def get_check_level(self):
        r"""get_check_level(RigidBodyDiffusion self) -> IMP::CheckLevel"""
        return _IMP_atom.RigidBodyDiffusion_get_check_level(self)

    def __eq__(self, *args):
        r"""
        __eq__(RigidBodyDiffusion self, RigidBodyDiffusion o) -> bool
        __eq__(RigidBodyDiffusion self, Particle d) -> bool
        """
        return _IMP_atom.RigidBodyDiffusion___eq__(self, *args)

    def __ne__(self, *args):
        r"""
        __ne__(RigidBodyDiffusion self, RigidBodyDiffusion o) -> bool
        __ne__(RigidBodyDiffusion self, Particle d) -> bool
        """
        return _IMP_atom.RigidBodyDiffusion___ne__(self, *args)

    def __le__(self, *args):
        r"""
        __le__(RigidBodyDiffusion self, RigidBodyDiffusion o) -> bool
        __le__(RigidBodyDiffusion self, Particle d) -> bool
        """
        return _IMP_atom.RigidBodyDiffusion___le__(self, *args)

    def __lt__(self, *args):
        r"""
        __lt__(RigidBodyDiffusion self, RigidBodyDiffusion o) -> bool
        __lt__(RigidBodyDiffusion self, Particle d) -> bool
        """
        return _IMP_atom.RigidBodyDiffusion___lt__(self, *args)

    def __ge__(self, *args):
        r"""
        __ge__(RigidBodyDiffusion self, RigidBodyDiffusion o) -> bool
        __ge__(RigidBodyDiffusion self, Particle d) -> bool
        """
        return _IMP_atom.RigidBodyDiffusion___ge__(self, *args)

    def __gt__(self, *args):
        r"""
        __gt__(RigidBodyDiffusion self, RigidBodyDiffusion o) -> bool
        __gt__(RigidBodyDiffusion self, Particle d) -> bool
        """
        return _IMP_atom.RigidBodyDiffusion___gt__(self, *args)

    def __hash__(self):
        r"""__hash__(RigidBodyDiffusion self) -> std::size_t"""
        return _IMP_atom.RigidBodyDiffusion___hash__(self)

    def __str__(self):
        r"""__str__(RigidBodyDiffusion self) -> std::string"""
        return _IMP_atom.RigidBodyDiffusion___str__(self)

    def __repr__(self):
        r"""__repr__(RigidBodyDiffusion self) -> std::string"""
        return _IMP_atom.RigidBodyDiffusion___repr__(self)
    __swig_destroy__ = _IMP_atom.delete_RigidBodyDiffusion

# Register RigidBodyDiffusion in _IMP_atom:
_IMP_atom.RigidBodyDiffusion_swigregister(RigidBodyDiffusion)

def RigidBodyDiffusion_setup_particle(*args):
    r"""
    RigidBodyDiffusion_setup_particle(Model m, ParticleIndex pi) -> RigidBodyDiffusion
    RigidBodyDiffusion_setup_particle(_ParticleAdaptor decorator) -> RigidBodyDiffusion
    """
    return _IMP_atom.RigidBodyDiffusion_setup_particle(*args)

def RigidBodyDiffusion_get_is_setup(*args):
    r"""
    RigidBodyDiffusion_get_is_setup(_ParticleAdaptor p) -> bool
    RigidBodyDiffusion_get_is_setup(Model m, ParticleIndex p) -> bool
    """
    return _IMP_atom.RigidBodyDiffusion_get_is_setup(*args)

def RigidBodyDiffusion_get_rotational_diffusion_coefficient_key():
    r"""RigidBodyDiffusion_get_rotational_diffusion_coefficient_key() -> FloatKey"""
    return _IMP_atom.RigidBodyDiffusion_get_rotational_diffusion_coefficient_key()

class TAMDParticle(IMP.Decorator):
    r"""Proxy of C++ IMP::atom::TAMDParticle class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(TAMDParticle self) -> TAMDParticle
        __init__(TAMDParticle self, Model m, ParticleIndex id) -> TAMDParticle
        __init__(TAMDParticle self, _ParticleAdaptor d) -> TAMDParticle
        """
        _IMP_atom.TAMDParticle_swiginit(self, _IMP_atom.new_TAMDParticle(*args))

    def show(self, *args):
        r"""show(TAMDParticle self, _ostream out=std::cout)"""
        return _IMP_atom.TAMDParticle_show(self, *args)

    @staticmethod
    def setup_particle(*args):
        r"""
        setup_particle(Model m, ParticleIndex pi, ParticleIndex pi_ref, IMP::Float tsf, IMP::Float fsf) -> TAMDParticle
        setup_particle(_ParticleAdaptor decorator, ParticleIndex pi_ref, IMP::Float tsf, IMP::Float fsf) -> TAMDParticle
        setup_particle(Model m, ParticleIndex pi, Particle p_ref, IMP::Float tsf, IMP::Float fsf) -> TAMDParticle
        setup_particle(_ParticleAdaptor decorator, Particle p_ref, IMP::Float tsf, IMP::Float fsf) -> TAMDParticle
        """
        return _IMP_atom.TAMDParticle_setup_particle(*args)

    @staticmethod
    def get_is_setup(*args):
        r"""
        get_is_setup(_ParticleAdaptor p) -> bool
        get_is_setup(Model m, ParticleIndex p) -> bool
        """
        return _IMP_atom.TAMDParticle_get_is_setup(*args)

    def get_reference_particle_index(self):
        r"""get_reference_particle_index(TAMDParticle self) -> ParticleIndex"""
        return _IMP_atom.TAMDParticle_get_reference_particle_index(self)

    def set_temperature_scale_factor(self, tsf):
        r"""set_temperature_scale_factor(TAMDParticle self, float tsf)"""
        return _IMP_atom.TAMDParticle_set_temperature_scale_factor(self, tsf)

    def get_temperature_scale_factor(self):
        r"""get_temperature_scale_factor(TAMDParticle self) -> double"""
        return _IMP_atom.TAMDParticle_get_temperature_scale_factor(self)

    def set_friction_scale_factor(self, tsf):
        r"""set_friction_scale_factor(TAMDParticle self, float tsf)"""
        return _IMP_atom.TAMDParticle_set_friction_scale_factor(self, tsf)

    def get_friction_scale_factor(self):
        r"""get_friction_scale_factor(TAMDParticle self) -> double"""
        return _IMP_atom.TAMDParticle_get_friction_scale_factor(self)

    def update_coordinates_from_ref(self):
        r"""update_coordinates_from_ref(TAMDParticle self)"""
        return _IMP_atom.TAMDParticle_update_coordinates_from_ref(self)

    @staticmethod
    def get_temperature_scale_factor_key():
        r"""get_temperature_scale_factor_key() -> FloatKey"""
        return _IMP_atom.TAMDParticle_get_temperature_scale_factor_key()

    @staticmethod
    def get_friction_scale_factor_key():
        r"""get_friction_scale_factor_key() -> FloatKey"""
        return _IMP_atom.TAMDParticle_get_friction_scale_factor_key()

    @staticmethod
    def get_reference_particle_index_key():
        r"""get_reference_particle_index_key() -> ParticleIndexKey"""
        return _IMP_atom.TAMDParticle_get_reference_particle_index_key()

    def add_attribute(self, *args):
        r"""
        add_attribute(TAMDParticle self, FloatKey k, IMP::Float v, bool opt)
        add_attribute(TAMDParticle self, FloatKey a0, IMP::Float a1)
        add_attribute(TAMDParticle self, IntKey a0, IMP::Int a1)
        add_attribute(TAMDParticle self, FloatsKey a0, IMP::Floats a1)
        add_attribute(TAMDParticle self, IntsKey a0, IMP::Ints a1)
        add_attribute(TAMDParticle self, StringKey a0, IMP::String a1)
        add_attribute(TAMDParticle self, ParticleIndexKey a0, Particle a1)
        add_attribute(TAMDParticle self, ObjectKey a0, Object a1)
        """
        return _IMP_atom.TAMDParticle_add_attribute(self, *args)

    def get_value(self, *args):
        r"""
        get_value(TAMDParticle self, FloatKey a0) -> IMP::Float
        get_value(TAMDParticle self, IntKey a0) -> IMP::Int
        get_value(TAMDParticle self, FloatsKey a0) -> IMP::Floats
        get_value(TAMDParticle self, IntsKey a0) -> IMP::Ints
        get_value(TAMDParticle self, StringKey a0) -> IMP::String
        get_value(TAMDParticle self, ParticleIndexKey a0) -> Particle
        get_value(TAMDParticle self, ObjectKey a0) -> Object
        """
        return _IMP_atom.TAMDParticle_get_value(self, *args)

    def set_value(self, *args):
        r"""
        set_value(TAMDParticle self, FloatKey a0, IMP::Float a1)
        set_value(TAMDParticle self, IntKey a0, IMP::Int a1)
        set_value(TAMDParticle self, FloatsKey a0, IMP::Floats a1)
        set_value(TAMDParticle self, IntsKey a0, IMP::Ints a1)
        set_value(TAMDParticle self, StringKey a0, IMP::String a1)
        set_value(TAMDParticle self, ParticleIndexKey a0, Particle a1)
        set_value(TAMDParticle self, ObjectKey a0, Object a1)
        """
        return _IMP_atom.TAMDParticle_set_value(self, *args)

    def remove_attribute(self, *args):
        r"""
        remove_attribute(TAMDParticle self, FloatKey a0)
        remove_attribute(TAMDParticle self, IntKey a0)
        remove_attribute(TAMDParticle self, FloatsKey a0)
        remove_attribute(TAMDParticle self, IntsKey a0)
        remove_attribute(TAMDParticle self, StringKey a0)
        remove_attribute(TAMDParticle self, ParticleIndexKey a0)
        remove_attribute(TAMDParticle self, ObjectKey a0)
        """
        return _IMP_atom.TAMDParticle_remove_attribute(self, *args)

    def has_attribute(self, *args):
        r"""
        has_attribute(TAMDParticle self, FloatKey a0) -> bool
        has_attribute(TAMDParticle self, IntKey a0) -> bool
        has_attribute(TAMDParticle self, FloatsKey a0) -> bool
        has_attribute(TAMDParticle self, IntsKey a0) -> bool
        has_attribute(TAMDParticle self, StringKey a0) -> bool
        has_attribute(TAMDParticle self, ParticleIndexKey a0) -> bool
        has_attribute(TAMDParticle self, ObjectKey a0) -> bool
        """
        return _IMP_atom.TAMDParticle_has_attribute(self, *args)

    def get_derivative(self, a0):
        r"""get_derivative(TAMDParticle self, FloatKey a0) -> double"""
        return _IMP_atom.TAMDParticle_get_derivative(self, a0)

    def get_name(self):
        r"""get_name(TAMDParticle self) -> std::string"""
        return _IMP_atom.TAMDParticle_get_name(self)

    def clear_caches(self):
        r"""clear_caches(TAMDParticle self)"""
        return _IMP_atom.TAMDParticle_clear_caches(self)

    def set_name(self, a0):
        r"""set_name(TAMDParticle self, std::string a0)"""
        return _IMP_atom.TAMDParticle_set_name(self, a0)

    def set_check_level(self, a0):
        r"""set_check_level(TAMDParticle self, IMP::CheckLevel a0)"""
        return _IMP_atom.TAMDParticle_set_check_level(self, a0)

    def add_to_derivative(self, a0, a1, a2):
        r"""add_to_derivative(TAMDParticle self, FloatKey a0, double a1, DerivativeAccumulator a2)"""
        return _IMP_atom.TAMDParticle_add_to_derivative(self, a0, a1, a2)

    def set_is_optimized(self, a0, a1):
        r"""set_is_optimized(TAMDParticle self, FloatKey a0, bool a1)"""
        return _IMP_atom.TAMDParticle_set_is_optimized(self, a0, a1)

    def get_is_optimized(self, a0):
        r"""get_is_optimized(TAMDParticle self, FloatKey a0) -> bool"""
        return _IMP_atom.TAMDParticle_get_is_optimized(self, a0)

    def get_check_level(self):
        r"""get_check_level(TAMDParticle self) -> IMP::CheckLevel"""
        return _IMP_atom.TAMDParticle_get_check_level(self)

    def __eq__(self, *args):
        r"""
        __eq__(TAMDParticle self, TAMDParticle o) -> bool
        __eq__(TAMDParticle self, Particle d) -> bool
        """
        return _IMP_atom.TAMDParticle___eq__(self, *args)

    def __ne__(self, *args):
        r"""
        __ne__(TAMDParticle self, TAMDParticle o) -> bool
        __ne__(TAMDParticle self, Particle d) -> bool
        """
        return _IMP_atom.TAMDParticle___ne__(self, *args)

    def __le__(self, *args):
        r"""
        __le__(TAMDParticle self, TAMDParticle o) -> bool
        __le__(TAMDParticle self, Particle d) -> bool
        """
        return _IMP_atom.TAMDParticle___le__(self, *args)

    def __lt__(self, *args):
        r"""
        __lt__(TAMDParticle self, TAMDParticle o) -> bool
        __lt__(TAMDParticle self, Particle d) -> bool
        """
        return _IMP_atom.TAMDParticle___lt__(self, *args)

    def __ge__(self, *args):
        r"""
        __ge__(TAMDParticle self, TAMDParticle o) -> bool
        __ge__(TAMDParticle self, Particle d) -> bool
        """
        return _IMP_atom.TAMDParticle___ge__(self, *args)

    def __gt__(self, *args):
        r"""
        __gt__(TAMDParticle self, TAMDParticle o) -> bool
        __gt__(TAMDParticle self, Particle d) -> bool
        """
        return _IMP_atom.TAMDParticle___gt__(self, *args)

    def __hash__(self):
        r"""__hash__(TAMDParticle self) -> std::size_t"""
        return _IMP_atom.TAMDParticle___hash__(self)

    def __str__(self):
        r"""__str__(TAMDParticle self) -> std::string"""
        return _IMP_atom.TAMDParticle___str__(self)

    def __repr__(self):
        r"""__repr__(TAMDParticle self) -> std::string"""
        return _IMP_atom.TAMDParticle___repr__(self)
    __swig_destroy__ = _IMP_atom.delete_TAMDParticle

# Register TAMDParticle in _IMP_atom:
_IMP_atom.TAMDParticle_swigregister(TAMDParticle)

def TAMDParticle_setup_particle(*args):
    r"""
    TAMDParticle_setup_particle(Model m, ParticleIndex pi, ParticleIndex pi_ref, IMP::Float tsf, IMP::Float fsf) -> TAMDParticle
    TAMDParticle_setup_particle(_ParticleAdaptor decorator, ParticleIndex pi_ref, IMP::Float tsf, IMP::Float fsf) -> TAMDParticle
    TAMDParticle_setup_particle(Model m, ParticleIndex pi, Particle p_ref, IMP::Float tsf, IMP::Float fsf) -> TAMDParticle
    TAMDParticle_setup_particle(_ParticleAdaptor decorator, Particle p_ref, IMP::Float tsf, IMP::Float fsf) -> TAMDParticle
    """
    return _IMP_atom.TAMDParticle_setup_particle(*args)

def TAMDParticle_get_is_setup(*args):
    r"""
    TAMDParticle_get_is_setup(_ParticleAdaptor p) -> bool
    TAMDParticle_get_is_setup(Model m, ParticleIndex p) -> bool
    """
    return _IMP_atom.TAMDParticle_get_is_setup(*args)

def TAMDParticle_get_temperature_scale_factor_key():
    r"""TAMDParticle_get_temperature_scale_factor_key() -> FloatKey"""
    return _IMP_atom.TAMDParticle_get_temperature_scale_factor_key()

def TAMDParticle_get_friction_scale_factor_key():
    r"""TAMDParticle_get_friction_scale_factor_key() -> FloatKey"""
    return _IMP_atom.TAMDParticle_get_friction_scale_factor_key()

def TAMDParticle_get_reference_particle_index_key():
    r"""TAMDParticle_get_reference_particle_index_key() -> ParticleIndexKey"""
    return _IMP_atom.TAMDParticle_get_reference_particle_index_key()

class Chain(Hierarchy):
    r"""Proxy of C++ IMP::atom::Chain class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(Chain self) -> Chain
        __init__(Chain self, Model m, ParticleIndex id) -> Chain
        __init__(Chain self, _ParticleAdaptor d) -> Chain
        """
        _IMP_atom.Chain_swiginit(self, _IMP_atom.new_Chain(*args))

    def show(self, *args):
        r"""show(Chain self, _ostream out=std::cout)"""
        return _IMP_atom.Chain_show(self, *args)

    @staticmethod
    def setup_particle(*args):
        r"""
        setup_particle(Model m, ParticleIndex pi, std::string id) -> Chain
        setup_particle(_ParticleAdaptor decorator, std::string id) -> Chain
        setup_particle(Model m, ParticleIndex pi, char id) -> Chain
        setup_particle(_ParticleAdaptor decorator, char id) -> Chain
        setup_particle(Model m, ParticleIndex pi, Chain other) -> Chain
        setup_particle(_ParticleAdaptor decorator, Chain other) -> Chain
        """
        return _IMP_atom.Chain_setup_particle(*args)

    @staticmethod
    def get_is_setup(*args):
        r"""
        get_is_setup(_ParticleAdaptor p) -> bool
        get_is_setup(Model m, ParticleIndex pi) -> bool
        """
        return _IMP_atom.Chain_get_is_setup(*args)

    def get_id(self):
        r"""get_id(Chain self) -> std::string"""
        return _IMP_atom.Chain_get_id(self)

    def set_id(self, c):
        r"""set_id(Chain self, std::string c)"""
        return _IMP_atom.Chain_set_id(self, c)

    def get_sequence(self):
        r"""get_sequence(Chain self) -> std::string"""
        return _IMP_atom.Chain_get_sequence(self)

    def set_sequence(self, sequence):
        r"""set_sequence(Chain self, std::string sequence)"""
        return _IMP_atom.Chain_set_sequence(self, sequence)

    def get_chain_type(self):
        r"""get_chain_type(Chain self) -> ChainType"""
        return _IMP_atom.Chain_get_chain_type(self)

    def set_chain_type(self, t):
        r"""set_chain_type(Chain self, ChainType t)"""
        return _IMP_atom.Chain_set_chain_type(self, t)

    @staticmethod
    def get_id_key():
        r"""get_id_key() -> StringKey"""
        return _IMP_atom.Chain_get_id_key()

    @staticmethod
    def get_sequence_key():
        r"""get_sequence_key() -> StringKey"""
        return _IMP_atom.Chain_get_sequence_key()

    @staticmethod
    def get_chain_type_key():
        r"""get_chain_type_key() -> IntKey"""
        return _IMP_atom.Chain_get_chain_type_key()

    def add_attribute(self, *args):
        r"""
        add_attribute(Chain self, FloatKey k, IMP::Float v, bool opt)
        add_attribute(Chain self, FloatKey a0, IMP::Float a1)
        add_attribute(Chain self, IntKey a0, IMP::Int a1)
        add_attribute(Chain self, FloatsKey a0, IMP::Floats a1)
        add_attribute(Chain self, IntsKey a0, IMP::Ints a1)
        add_attribute(Chain self, StringKey a0, IMP::String a1)
        add_attribute(Chain self, ParticleIndexKey a0, Particle a1)
        add_attribute(Chain self, ObjectKey a0, Object a1)
        """
        return _IMP_atom.Chain_add_attribute(self, *args)

    def get_value(self, *args):
        r"""
        get_value(Chain self, FloatKey a0) -> IMP::Float
        get_value(Chain self, IntKey a0) -> IMP::Int
        get_value(Chain self, FloatsKey a0) -> IMP::Floats
        get_value(Chain self, IntsKey a0) -> IMP::Ints
        get_value(Chain self, StringKey a0) -> IMP::String
        get_value(Chain self, ParticleIndexKey a0) -> Particle
        get_value(Chain self, ObjectKey a0) -> Object
        """
        return _IMP_atom.Chain_get_value(self, *args)

    def set_value(self, *args):
        r"""
        set_value(Chain self, FloatKey a0, IMP::Float a1)
        set_value(Chain self, IntKey a0, IMP::Int a1)
        set_value(Chain self, FloatsKey a0, IMP::Floats a1)
        set_value(Chain self, IntsKey a0, IMP::Ints a1)
        set_value(Chain self, StringKey a0, IMP::String a1)
        set_value(Chain self, ParticleIndexKey a0, Particle a1)
        set_value(Chain self, ObjectKey a0, Object a1)
        """
        return _IMP_atom.Chain_set_value(self, *args)

    def remove_attribute(self, *args):
        r"""
        remove_attribute(Chain self, FloatKey a0)
        remove_attribute(Chain self, IntKey a0)
        remove_attribute(Chain self, FloatsKey a0)
        remove_attribute(Chain self, IntsKey a0)
        remove_attribute(Chain self, StringKey a0)
        remove_attribute(Chain self, ParticleIndexKey a0)
        remove_attribute(Chain self, ObjectKey a0)
        """
        return _IMP_atom.Chain_remove_attribute(self, *args)

    def has_attribute(self, *args):
        r"""
        has_attribute(Chain self, FloatKey a0) -> bool
        has_attribute(Chain self, IntKey a0) -> bool
        has_attribute(Chain self, FloatsKey a0) -> bool
        has_attribute(Chain self, IntsKey a0) -> bool
        has_attribute(Chain self, StringKey a0) -> bool
        has_attribute(Chain self, ParticleIndexKey a0) -> bool
        has_attribute(Chain self, ObjectKey a0) -> bool
        """
        return _IMP_atom.Chain_has_attribute(self, *args)

    def get_derivative(self, a0):
        r"""get_derivative(Chain self, FloatKey a0) -> double"""
        return _IMP_atom.Chain_get_derivative(self, a0)

    def get_name(self):
        r"""get_name(Chain self) -> std::string"""
        return _IMP_atom.Chain_get_name(self)

    def clear_caches(self):
        r"""clear_caches(Chain self)"""
        return _IMP_atom.Chain_clear_caches(self)

    def set_name(self, a0):
        r"""set_name(Chain self, std::string a0)"""
        return _IMP_atom.Chain_set_name(self, a0)

    def set_check_level(self, a0):
        r"""set_check_level(Chain self, IMP::CheckLevel a0)"""
        return _IMP_atom.Chain_set_check_level(self, a0)

    def add_to_derivative(self, a0, a1, a2):
        r"""add_to_derivative(Chain self, FloatKey a0, double a1, DerivativeAccumulator a2)"""
        return _IMP_atom.Chain_add_to_derivative(self, a0, a1, a2)

    def set_is_optimized(self, a0, a1):
        r"""set_is_optimized(Chain self, FloatKey a0, bool a1)"""
        return _IMP_atom.Chain_set_is_optimized(self, a0, a1)

    def get_is_optimized(self, a0):
        r"""get_is_optimized(Chain self, FloatKey a0) -> bool"""
        return _IMP_atom.Chain_get_is_optimized(self, a0)

    def get_check_level(self):
        r"""get_check_level(Chain self) -> IMP::CheckLevel"""
        return _IMP_atom.Chain_get_check_level(self)

    def __eq__(self, *args):
        r"""
        __eq__(Chain self, Chain o) -> bool
        __eq__(Chain self, Particle d) -> bool
        """
        return _IMP_atom.Chain___eq__(self, *args)

    def __ne__(self, *args):
        r"""
        __ne__(Chain self, Chain o) -> bool
        __ne__(Chain self, Particle d) -> bool
        """
        return _IMP_atom.Chain___ne__(self, *args)

    def __le__(self, *args):
        r"""
        __le__(Chain self, Chain o) -> bool
        __le__(Chain self, Particle d) -> bool
        """
        return _IMP_atom.Chain___le__(self, *args)

    def __lt__(self, *args):
        r"""
        __lt__(Chain self, Chain o) -> bool
        __lt__(Chain self, Particle d) -> bool
        """
        return _IMP_atom.Chain___lt__(self, *args)

    def __ge__(self, *args):
        r"""
        __ge__(Chain self, Chain o) -> bool
        __ge__(Chain self, Particle d) -> bool
        """
        return _IMP_atom.Chain___ge__(self, *args)

    def __gt__(self, *args):
        r"""
        __gt__(Chain self, Chain o) -> bool
        __gt__(Chain self, Particle d) -> bool
        """
        return _IMP_atom.Chain___gt__(self, *args)

    def __hash__(self):
        r"""__hash__(Chain self) -> std::size_t"""
        return _IMP_atom.Chain___hash__(self)

    def __str__(self):
        r"""__str__(Chain self) -> std::string"""
        return _IMP_atom.Chain___str__(self)

    def __repr__(self):
        r"""__repr__(Chain self) -> std::string"""
        return _IMP_atom.Chain___repr__(self)
    __swig_destroy__ = _IMP_atom.delete_Chain

# Register Chain in _IMP_atom:
_IMP_atom.Chain_swigregister(Chain)
cvar = _IMP_atom.cvar
UnknownChainType = cvar.UnknownChainType
DPolypeptide = cvar.DPolypeptide
LPolypeptide = cvar.LPolypeptide
Polydeoxyribonucleotide = cvar.Polydeoxyribonucleotide
Polyribonucleotide = cvar.Polyribonucleotide
DPolysaccharide = cvar.DPolysaccharide
LPolysaccharide = cvar.LPolysaccharide
Protein = cvar.Protein
DNA = cvar.DNA
RNA = cvar.RNA

def Chain_setup_particle(*args):
    r"""
    Chain_setup_particle(Model m, ParticleIndex pi, std::string id) -> Chain
    Chain_setup_particle(_ParticleAdaptor decorator, std::string id) -> Chain
    Chain_setup_particle(Model m, ParticleIndex pi, char id) -> Chain
    Chain_setup_particle(_ParticleAdaptor decorator, char id) -> Chain
    Chain_setup_particle(Model m, ParticleIndex pi, Chain other) -> Chain
    Chain_setup_particle(_ParticleAdaptor decorator, Chain other) -> Chain
    """
    return _IMP_atom.Chain_setup_particle(*args)

def Chain_get_is_setup(*args):
    r"""
    Chain_get_is_setup(_ParticleAdaptor p) -> bool
    Chain_get_is_setup(Model m, ParticleIndex pi) -> bool
    """
    return _IMP_atom.Chain_get_is_setup(*args)

def Chain_get_id_key():
    r"""Chain_get_id_key() -> StringKey"""
    return _IMP_atom.Chain_get_id_key()

def Chain_get_sequence_key():
    r"""Chain_get_sequence_key() -> StringKey"""
    return _IMP_atom.Chain_get_sequence_key()

def Chain_get_chain_type_key():
    r"""Chain_get_chain_type_key() -> IntKey"""
    return _IMP_atom.Chain_get_chain_type_key()


def get_chain(h):
    r"""get_chain(Hierarchy h) -> Chain"""
    return _IMP_atom.get_chain(h)

def get_chain_id(h):
    r"""get_chain_id(Hierarchy h) -> std::string"""
    return _IMP_atom.get_chain_id(h)
class Charged(IMP.core.XYZ):
    r"""Proxy of C++ IMP::atom::Charged class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(Charged self) -> Charged
        __init__(Charged self, Model m, ParticleIndex id) -> Charged
        __init__(Charged self, _ParticleAdaptor d) -> Charged
        """
        _IMP_atom.Charged_swiginit(self, _IMP_atom.new_Charged(*args))

    def show(self, *args):
        r"""show(Charged self, _ostream out=std::cout)"""
        return _IMP_atom.Charged_show(self, *args)

    @staticmethod
    def setup_particle(*args):
        r"""
        setup_particle(Model m, ParticleIndex pi, IMP::Float charge) -> Charged
        setup_particle(_ParticleAdaptor decorator, IMP::Float charge) -> Charged
        setup_particle(Model m, ParticleIndex pi, Vector3D v, IMP::Float charge) -> Charged
        setup_particle(_ParticleAdaptor decorator, Vector3D v, IMP::Float charge) -> Charged
        """
        return _IMP_atom.Charged_setup_particle(*args)

    def get_charge(self):
        r"""get_charge(Charged self) -> IMP::Float"""
        return _IMP_atom.Charged_get_charge(self)

    def set_charge(self, t):
        r"""set_charge(Charged self, IMP::Float t)"""
        return _IMP_atom.Charged_set_charge(self, t)

    @staticmethod
    def get_is_setup(*args):
        r"""
        get_is_setup(_ParticleAdaptor p) -> bool
        get_is_setup(Model m, ParticleIndex pi) -> bool
        """
        return _IMP_atom.Charged_get_is_setup(*args)

    @staticmethod
    def get_charge_key():
        r"""get_charge_key() -> FloatKey"""
        return _IMP_atom.Charged_get_charge_key()

    def add_attribute(self, *args):
        r"""
        add_attribute(Charged self, FloatKey k, IMP::Float v, bool opt)
        add_attribute(Charged self, FloatKey a0, IMP::Float a1)
        add_attribute(Charged self, IntKey a0, IMP::Int a1)
        add_attribute(Charged self, FloatsKey a0, IMP::Floats a1)
        add_attribute(Charged self, IntsKey a0, IMP::Ints a1)
        add_attribute(Charged self, StringKey a0, IMP::String a1)
        add_attribute(Charged self, ParticleIndexKey a0, Particle a1)
        add_attribute(Charged self, ObjectKey a0, Object a1)
        """
        return _IMP_atom.Charged_add_attribute(self, *args)

    def get_value(self, *args):
        r"""
        get_value(Charged self, FloatKey a0) -> IMP::Float
        get_value(Charged self, IntKey a0) -> IMP::Int
        get_value(Charged self, FloatsKey a0) -> IMP::Floats
        get_value(Charged self, IntsKey a0) -> IMP::Ints
        get_value(Charged self, StringKey a0) -> IMP::String
        get_value(Charged self, ParticleIndexKey a0) -> Particle
        get_value(Charged self, ObjectKey a0) -> Object
        """
        return _IMP_atom.Charged_get_value(self, *args)

    def set_value(self, *args):
        r"""
        set_value(Charged self, FloatKey a0, IMP::Float a1)
        set_value(Charged self, IntKey a0, IMP::Int a1)
        set_value(Charged self, FloatsKey a0, IMP::Floats a1)
        set_value(Charged self, IntsKey a0, IMP::Ints a1)
        set_value(Charged self, StringKey a0, IMP::String a1)
        set_value(Charged self, ParticleIndexKey a0, Particle a1)
        set_value(Charged self, ObjectKey a0, Object a1)
        """
        return _IMP_atom.Charged_set_value(self, *args)

    def remove_attribute(self, *args):
        r"""
        remove_attribute(Charged self, FloatKey a0)
        remove_attribute(Charged self, IntKey a0)
        remove_attribute(Charged self, FloatsKey a0)
        remove_attribute(Charged self, IntsKey a0)
        remove_attribute(Charged self, StringKey a0)
        remove_attribute(Charged self, ParticleIndexKey a0)
        remove_attribute(Charged self, ObjectKey a0)
        """
        return _IMP_atom.Charged_remove_attribute(self, *args)

    def has_attribute(self, *args):
        r"""
        has_attribute(Charged self, FloatKey a0) -> bool
        has_attribute(Charged self, IntKey a0) -> bool
        has_attribute(Charged self, FloatsKey a0) -> bool
        has_attribute(Charged self, IntsKey a0) -> bool
        has_attribute(Charged self, StringKey a0) -> bool
        has_attribute(Charged self, ParticleIndexKey a0) -> bool
        has_attribute(Charged self, ObjectKey a0) -> bool
        """
        return _IMP_atom.Charged_has_attribute(self, *args)

    def get_derivative(self, a0):
        r"""get_derivative(Charged self, FloatKey a0) -> double"""
        return _IMP_atom.Charged_get_derivative(self, a0)

    def get_name(self):
        r"""get_name(Charged self) -> std::string"""
        return _IMP_atom.Charged_get_name(self)

    def clear_caches(self):
        r"""clear_caches(Charged self)"""
        return _IMP_atom.Charged_clear_caches(self)

    def set_name(self, a0):
        r"""set_name(Charged self, std::string a0)"""
        return _IMP_atom.Charged_set_name(self, a0)

    def set_check_level(self, a0):
        r"""set_check_level(Charged self, IMP::CheckLevel a0)"""
        return _IMP_atom.Charged_set_check_level(self, a0)

    def add_to_derivative(self, a0, a1, a2):
        r"""add_to_derivative(Charged self, FloatKey a0, double a1, DerivativeAccumulator a2)"""
        return _IMP_atom.Charged_add_to_derivative(self, a0, a1, a2)

    def set_is_optimized(self, a0, a1):
        r"""set_is_optimized(Charged self, FloatKey a0, bool a1)"""
        return _IMP_atom.Charged_set_is_optimized(self, a0, a1)

    def get_is_optimized(self, a0):
        r"""get_is_optimized(Charged self, FloatKey a0) -> bool"""
        return _IMP_atom.Charged_get_is_optimized(self, a0)

    def get_check_level(self):
        r"""get_check_level(Charged self) -> IMP::CheckLevel"""
        return _IMP_atom.Charged_get_check_level(self)

    def __eq__(self, *args):
        r"""
        __eq__(Charged self, Charged o) -> bool
        __eq__(Charged self, Particle d) -> bool
        """
        return _IMP_atom.Charged___eq__(self, *args)

    def __ne__(self, *args):
        r"""
        __ne__(Charged self, Charged o) -> bool
        __ne__(Charged self, Particle d) -> bool
        """
        return _IMP_atom.Charged___ne__(self, *args)

    def __le__(self, *args):
        r"""
        __le__(Charged self, Charged o) -> bool
        __le__(Charged self, Particle d) -> bool
        """
        return _IMP_atom.Charged___le__(self, *args)

    def __lt__(self, *args):
        r"""
        __lt__(Charged self, Charged o) -> bool
        __lt__(Charged self, Particle d) -> bool
        """
        return _IMP_atom.Charged___lt__(self, *args)

    def __ge__(self, *args):
        r"""
        __ge__(Charged self, Charged o) -> bool
        __ge__(Charged self, Particle d) -> bool
        """
        return _IMP_atom.Charged___ge__(self, *args)

    def __gt__(self, *args):
        r"""
        __gt__(Charged self, Charged o) -> bool
        __gt__(Charged self, Particle d) -> bool
        """
        return _IMP_atom.Charged___gt__(self, *args)

    def __hash__(self):
        r"""__hash__(Charged self) -> std::size_t"""
        return _IMP_atom.Charged___hash__(self)

    def __str__(self):
        r"""__str__(Charged self) -> std::string"""
        return _IMP_atom.Charged___str__(self)

    def __repr__(self):
        r"""__repr__(Charged self) -> std::string"""
        return _IMP_atom.Charged___repr__(self)
    __swig_destroy__ = _IMP_atom.delete_Charged

# Register Charged in _IMP_atom:
_IMP_atom.Charged_swigregister(Charged)

def Charged_setup_particle(*args):
    r"""
    Charged_setup_particle(Model m, ParticleIndex pi, IMP::Float charge) -> Charged
    Charged_setup_particle(_ParticleAdaptor decorator, IMP::Float charge) -> Charged
    Charged_setup_particle(Model m, ParticleIndex pi, Vector3D v, IMP::Float charge) -> Charged
    Charged_setup_particle(_ParticleAdaptor decorator, Vector3D v, IMP::Float charge) -> Charged
    """
    return _IMP_atom.Charged_setup_particle(*args)

def Charged_get_is_setup(*args):
    r"""
    Charged_get_is_setup(_ParticleAdaptor p) -> bool
    Charged_get_is_setup(Model m, ParticleIndex pi) -> bool
    """
    return _IMP_atom.Charged_get_is_setup(*args)

def Charged_get_charge_key():
    r"""Charged_get_charge_key() -> FloatKey"""
    return _IMP_atom.Charged_get_charge_key()

class CoulombPairScore(IMP.PairScore):
    r"""Proxy of C++ IMP::atom::CoulombPairScore class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, f):
        r"""__init__(CoulombPairScore self, SmoothingFunction f) -> CoulombPairScore"""
        _IMP_atom.CoulombPairScore_swiginit(self, _IMP_atom.new_CoulombPairScore(f))

    def set_relative_dielectric(self, relative_dielectric):
        r"""set_relative_dielectric(CoulombPairScore self, double relative_dielectric)"""
        return _IMP_atom.CoulombPairScore_set_relative_dielectric(self, relative_dielectric)

    def get_relative_dielectric(self):
        r"""get_relative_dielectric(CoulombPairScore self) -> double"""
        return _IMP_atom.CoulombPairScore_get_relative_dielectric(self)

    def do_get_inputs(self, m, pis):
        r"""do_get_inputs(CoulombPairScore self, Model m, IMP::ParticleIndexes const & pis) -> IMP::ModelObjectsTemp"""
        return _IMP_atom.CoulombPairScore_do_get_inputs(self, m, pis)

    def get_version_info(self):
        r"""get_version_info(CoulombPairScore self) -> VersionInfo"""
        return _IMP_atom.CoulombPairScore_get_version_info(self)

    def __str__(self):
        r"""__str__(CoulombPairScore self) -> std::string"""
        return _IMP_atom.CoulombPairScore___str__(self)

    def __repr__(self):
        r"""__repr__(CoulombPairScore self) -> std::string"""
        return _IMP_atom.CoulombPairScore___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_CoulombPairScore(o)


# Register CoulombPairScore in _IMP_atom:
_IMP_atom.CoulombPairScore_swigregister(CoulombPairScore)

class Domain(Hierarchy):
    r"""Proxy of C++ IMP::atom::Domain class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def set_index_range(self, ir):
        r"""set_index_range(Domain self, IMP::IntRange ir)"""
        return _IMP_atom.Domain_set_index_range(self, ir)

    def get_index_range(self):
        r"""get_index_range(Domain self) -> IMP::IntRange"""
        return _IMP_atom.Domain_get_index_range(self)

    def __init__(self, *args):
        r"""
        __init__(Domain self) -> Domain
        __init__(Domain self, Model m, ParticleIndex id) -> Domain
        __init__(Domain self, _ParticleAdaptor d) -> Domain
        """
        _IMP_atom.Domain_swiginit(self, _IMP_atom.new_Domain(*args))

    @staticmethod
    def get_is_setup(*args):
        r"""
        get_is_setup(Model m, ParticleIndex pi) -> bool
        get_is_setup(_ParticleAdaptor p) -> bool
        """
        return _IMP_atom.Domain_get_is_setup(*args)

    def show(self, *args):
        r"""show(Domain self, _ostream out=std::cout)"""
        return _IMP_atom.Domain_show(self, *args)

    @staticmethod
    def setup_particle(*args):
        r"""
        setup_particle(Model m, ParticleIndex pi, Domain other) -> Domain
        setup_particle(_ParticleAdaptor decorator, Domain other) -> Domain
        setup_particle(Model m, ParticleIndex pi, IMP::IntRange residues) -> Domain
        setup_particle(_ParticleAdaptor decorator, IMP::IntRange residues) -> Domain
        """
        return _IMP_atom.Domain_setup_particle(*args)

    def add_attribute(self, *args):
        r"""
        add_attribute(Domain self, FloatKey k, IMP::Float v, bool opt)
        add_attribute(Domain self, FloatKey a0, IMP::Float a1)
        add_attribute(Domain self, IntKey a0, IMP::Int a1)
        add_attribute(Domain self, FloatsKey a0, IMP::Floats a1)
        add_attribute(Domain self, IntsKey a0, IMP::Ints a1)
        add_attribute(Domain self, StringKey a0, IMP::String a1)
        add_attribute(Domain self, ParticleIndexKey a0, Particle a1)
        add_attribute(Domain self, ObjectKey a0, Object a1)
        """
        return _IMP_atom.Domain_add_attribute(self, *args)

    def get_value(self, *args):
        r"""
        get_value(Domain self, FloatKey a0) -> IMP::Float
        get_value(Domain self, IntKey a0) -> IMP::Int
        get_value(Domain self, FloatsKey a0) -> IMP::Floats
        get_value(Domain self, IntsKey a0) -> IMP::Ints
        get_value(Domain self, StringKey a0) -> IMP::String
        get_value(Domain self, ParticleIndexKey a0) -> Particle
        get_value(Domain self, ObjectKey a0) -> Object
        """
        return _IMP_atom.Domain_get_value(self, *args)

    def set_value(self, *args):
        r"""
        set_value(Domain self, FloatKey a0, IMP::Float a1)
        set_value(Domain self, IntKey a0, IMP::Int a1)
        set_value(Domain self, FloatsKey a0, IMP::Floats a1)
        set_value(Domain self, IntsKey a0, IMP::Ints a1)
        set_value(Domain self, StringKey a0, IMP::String a1)
        set_value(Domain self, ParticleIndexKey a0, Particle a1)
        set_value(Domain self, ObjectKey a0, Object a1)
        """
        return _IMP_atom.Domain_set_value(self, *args)

    def remove_attribute(self, *args):
        r"""
        remove_attribute(Domain self, FloatKey a0)
        remove_attribute(Domain self, IntKey a0)
        remove_attribute(Domain self, FloatsKey a0)
        remove_attribute(Domain self, IntsKey a0)
        remove_attribute(Domain self, StringKey a0)
        remove_attribute(Domain self, ParticleIndexKey a0)
        remove_attribute(Domain self, ObjectKey a0)
        """
        return _IMP_atom.Domain_remove_attribute(self, *args)

    def has_attribute(self, *args):
        r"""
        has_attribute(Domain self, FloatKey a0) -> bool
        has_attribute(Domain self, IntKey a0) -> bool
        has_attribute(Domain self, FloatsKey a0) -> bool
        has_attribute(Domain self, IntsKey a0) -> bool
        has_attribute(Domain self, StringKey a0) -> bool
        has_attribute(Domain self, ParticleIndexKey a0) -> bool
        has_attribute(Domain self, ObjectKey a0) -> bool
        """
        return _IMP_atom.Domain_has_attribute(self, *args)

    def get_derivative(self, a0):
        r"""get_derivative(Domain self, FloatKey a0) -> double"""
        return _IMP_atom.Domain_get_derivative(self, a0)

    def get_name(self):
        r"""get_name(Domain self) -> std::string"""
        return _IMP_atom.Domain_get_name(self)

    def clear_caches(self):
        r"""clear_caches(Domain self)"""
        return _IMP_atom.Domain_clear_caches(self)

    def set_name(self, a0):
        r"""set_name(Domain self, std::string a0)"""
        return _IMP_atom.Domain_set_name(self, a0)

    def set_check_level(self, a0):
        r"""set_check_level(Domain self, IMP::CheckLevel a0)"""
        return _IMP_atom.Domain_set_check_level(self, a0)

    def add_to_derivative(self, a0, a1, a2):
        r"""add_to_derivative(Domain self, FloatKey a0, double a1, DerivativeAccumulator a2)"""
        return _IMP_atom.Domain_add_to_derivative(self, a0, a1, a2)

    def set_is_optimized(self, a0, a1):
        r"""set_is_optimized(Domain self, FloatKey a0, bool a1)"""
        return _IMP_atom.Domain_set_is_optimized(self, a0, a1)

    def get_is_optimized(self, a0):
        r"""get_is_optimized(Domain self, FloatKey a0) -> bool"""
        return _IMP_atom.Domain_get_is_optimized(self, a0)

    def get_check_level(self):
        r"""get_check_level(Domain self) -> IMP::CheckLevel"""
        return _IMP_atom.Domain_get_check_level(self)

    def __eq__(self, *args):
        r"""
        __eq__(Domain self, Domain o) -> bool
        __eq__(Domain self, Particle d) -> bool
        """
        return _IMP_atom.Domain___eq__(self, *args)

    def __ne__(self, *args):
        r"""
        __ne__(Domain self, Domain o) -> bool
        __ne__(Domain self, Particle d) -> bool
        """
        return _IMP_atom.Domain___ne__(self, *args)

    def __le__(self, *args):
        r"""
        __le__(Domain self, Domain o) -> bool
        __le__(Domain self, Particle d) -> bool
        """
        return _IMP_atom.Domain___le__(self, *args)

    def __lt__(self, *args):
        r"""
        __lt__(Domain self, Domain o) -> bool
        __lt__(Domain self, Particle d) -> bool
        """
        return _IMP_atom.Domain___lt__(self, *args)

    def __ge__(self, *args):
        r"""
        __ge__(Domain self, Domain o) -> bool
        __ge__(Domain self, Particle d) -> bool
        """
        return _IMP_atom.Domain___ge__(self, *args)

    def __gt__(self, *args):
        r"""
        __gt__(Domain self, Domain o) -> bool
        __gt__(Domain self, Particle d) -> bool
        """
        return _IMP_atom.Domain___gt__(self, *args)

    def __hash__(self):
        r"""__hash__(Domain self) -> std::size_t"""
        return _IMP_atom.Domain___hash__(self)

    def __str__(self):
        r"""__str__(Domain self) -> std::string"""
        return _IMP_atom.Domain___str__(self)

    def __repr__(self):
        r"""__repr__(Domain self) -> std::string"""
        return _IMP_atom.Domain___repr__(self)
    __swig_destroy__ = _IMP_atom.delete_Domain

# Register Domain in _IMP_atom:
_IMP_atom.Domain_swigregister(Domain)

def Domain_get_is_setup(*args):
    r"""
    Domain_get_is_setup(Model m, ParticleIndex pi) -> bool
    Domain_get_is_setup(_ParticleAdaptor p) -> bool
    """
    return _IMP_atom.Domain_get_is_setup(*args)

def Domain_setup_particle(*args):
    r"""
    Domain_setup_particle(Model m, ParticleIndex pi, Domain other) -> Domain
    Domain_setup_particle(_ParticleAdaptor decorator, Domain other) -> Domain
    Domain_setup_particle(Model m, ParticleIndex pi, IMP::IntRange residues) -> Domain
    Domain_setup_particle(_ParticleAdaptor decorator, IMP::IntRange residues) -> Domain
    """
    return _IMP_atom.Domain_setup_particle(*args)

class LennardJones(IMP.core.XYZR):
    r"""Proxy of C++ IMP::atom::LennardJones class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(LennardJones self) -> LennardJones
        __init__(LennardJones self, Model m, ParticleIndex id) -> LennardJones
        __init__(LennardJones self, _ParticleAdaptor d) -> LennardJones
        """
        _IMP_atom.LennardJones_swiginit(self, _IMP_atom.new_LennardJones(*args))

    def show(self, *args):
        r"""show(LennardJones self, _ostream out=std::cout)"""
        return _IMP_atom.LennardJones_show(self, *args)

    @staticmethod
    def setup_particle(*args):
        r"""
        setup_particle(Model m, ParticleIndex pi) -> LennardJones
        setup_particle(_ParticleAdaptor decorator) -> LennardJones
        setup_particle(Model m, ParticleIndex pi, IMP::Float well_depth) -> LennardJones
        setup_particle(_ParticleAdaptor decorator, IMP::Float well_depth) -> LennardJones
        """
        return _IMP_atom.LennardJones_setup_particle(*args)

    def get_well_depth(self):
        r"""get_well_depth(LennardJones self) -> IMP::Float"""
        return _IMP_atom.LennardJones_get_well_depth(self)

    def set_well_depth(self, well_depth):
        r"""set_well_depth(LennardJones self, IMP::Float well_depth)"""
        return _IMP_atom.LennardJones_set_well_depth(self, well_depth)

    @staticmethod
    def get_is_setup(*args):
        r"""
        get_is_setup(_ParticleAdaptor p) -> bool
        get_is_setup(Model m, ParticleIndex pi) -> bool
        """
        return _IMP_atom.LennardJones_get_is_setup(*args)

    @staticmethod
    def get_well_depth_key():
        r"""get_well_depth_key() -> FloatKey"""
        return _IMP_atom.LennardJones_get_well_depth_key()

    def add_attribute(self, *args):
        r"""
        add_attribute(LennardJones self, FloatKey k, IMP::Float v, bool opt)
        add_attribute(LennardJones self, FloatKey a0, IMP::Float a1)
        add_attribute(LennardJones self, IntKey a0, IMP::Int a1)
        add_attribute(LennardJones self, FloatsKey a0, IMP::Floats a1)
        add_attribute(LennardJones self, IntsKey a0, IMP::Ints a1)
        add_attribute(LennardJones self, StringKey a0, IMP::String a1)
        add_attribute(LennardJones self, ParticleIndexKey a0, Particle a1)
        add_attribute(LennardJones self, ObjectKey a0, Object a1)
        """
        return _IMP_atom.LennardJones_add_attribute(self, *args)

    def get_value(self, *args):
        r"""
        get_value(LennardJones self, FloatKey a0) -> IMP::Float
        get_value(LennardJones self, IntKey a0) -> IMP::Int
        get_value(LennardJones self, FloatsKey a0) -> IMP::Floats
        get_value(LennardJones self, IntsKey a0) -> IMP::Ints
        get_value(LennardJones self, StringKey a0) -> IMP::String
        get_value(LennardJones self, ParticleIndexKey a0) -> Particle
        get_value(LennardJones self, ObjectKey a0) -> Object
        """
        return _IMP_atom.LennardJones_get_value(self, *args)

    def set_value(self, *args):
        r"""
        set_value(LennardJones self, FloatKey a0, IMP::Float a1)
        set_value(LennardJones self, IntKey a0, IMP::Int a1)
        set_value(LennardJones self, FloatsKey a0, IMP::Floats a1)
        set_value(LennardJones self, IntsKey a0, IMP::Ints a1)
        set_value(LennardJones self, StringKey a0, IMP::String a1)
        set_value(LennardJones self, ParticleIndexKey a0, Particle a1)
        set_value(LennardJones self, ObjectKey a0, Object a1)
        """
        return _IMP_atom.LennardJones_set_value(self, *args)

    def remove_attribute(self, *args):
        r"""
        remove_attribute(LennardJones self, FloatKey a0)
        remove_attribute(LennardJones self, IntKey a0)
        remove_attribute(LennardJones self, FloatsKey a0)
        remove_attribute(LennardJones self, IntsKey a0)
        remove_attribute(LennardJones self, StringKey a0)
        remove_attribute(LennardJones self, ParticleIndexKey a0)
        remove_attribute(LennardJones self, ObjectKey a0)
        """
        return _IMP_atom.LennardJones_remove_attribute(self, *args)

    def has_attribute(self, *args):
        r"""
        has_attribute(LennardJones self, FloatKey a0) -> bool
        has_attribute(LennardJones self, IntKey a0) -> bool
        has_attribute(LennardJones self, FloatsKey a0) -> bool
        has_attribute(LennardJones self, IntsKey a0) -> bool
        has_attribute(LennardJones self, StringKey a0) -> bool
        has_attribute(LennardJones self, ParticleIndexKey a0) -> bool
        has_attribute(LennardJones self, ObjectKey a0) -> bool
        """
        return _IMP_atom.LennardJones_has_attribute(self, *args)

    def get_derivative(self, a0):
        r"""get_derivative(LennardJones self, FloatKey a0) -> double"""
        return _IMP_atom.LennardJones_get_derivative(self, a0)

    def get_name(self):
        r"""get_name(LennardJones self) -> std::string"""
        return _IMP_atom.LennardJones_get_name(self)

    def clear_caches(self):
        r"""clear_caches(LennardJones self)"""
        return _IMP_atom.LennardJones_clear_caches(self)

    def set_name(self, a0):
        r"""set_name(LennardJones self, std::string a0)"""
        return _IMP_atom.LennardJones_set_name(self, a0)

    def set_check_level(self, a0):
        r"""set_check_level(LennardJones self, IMP::CheckLevel a0)"""
        return _IMP_atom.LennardJones_set_check_level(self, a0)

    def add_to_derivative(self, a0, a1, a2):
        r"""add_to_derivative(LennardJones self, FloatKey a0, double a1, DerivativeAccumulator a2)"""
        return _IMP_atom.LennardJones_add_to_derivative(self, a0, a1, a2)

    def set_is_optimized(self, a0, a1):
        r"""set_is_optimized(LennardJones self, FloatKey a0, bool a1)"""
        return _IMP_atom.LennardJones_set_is_optimized(self, a0, a1)

    def get_is_optimized(self, a0):
        r"""get_is_optimized(LennardJones self, FloatKey a0) -> bool"""
        return _IMP_atom.LennardJones_get_is_optimized(self, a0)

    def get_check_level(self):
        r"""get_check_level(LennardJones self) -> IMP::CheckLevel"""
        return _IMP_atom.LennardJones_get_check_level(self)

    def __eq__(self, *args):
        r"""
        __eq__(LennardJones self, LennardJones o) -> bool
        __eq__(LennardJones self, Particle d) -> bool
        """
        return _IMP_atom.LennardJones___eq__(self, *args)

    def __ne__(self, *args):
        r"""
        __ne__(LennardJones self, LennardJones o) -> bool
        __ne__(LennardJones self, Particle d) -> bool
        """
        return _IMP_atom.LennardJones___ne__(self, *args)

    def __le__(self, *args):
        r"""
        __le__(LennardJones self, LennardJones o) -> bool
        __le__(LennardJones self, Particle d) -> bool
        """
        return _IMP_atom.LennardJones___le__(self, *args)

    def __lt__(self, *args):
        r"""
        __lt__(LennardJones self, LennardJones o) -> bool
        __lt__(LennardJones self, Particle d) -> bool
        """
        return _IMP_atom.LennardJones___lt__(self, *args)

    def __ge__(self, *args):
        r"""
        __ge__(LennardJones self, LennardJones o) -> bool
        __ge__(LennardJones self, Particle d) -> bool
        """
        return _IMP_atom.LennardJones___ge__(self, *args)

    def __gt__(self, *args):
        r"""
        __gt__(LennardJones self, LennardJones o) -> bool
        __gt__(LennardJones self, Particle d) -> bool
        """
        return _IMP_atom.LennardJones___gt__(self, *args)

    def __hash__(self):
        r"""__hash__(LennardJones self) -> std::size_t"""
        return _IMP_atom.LennardJones___hash__(self)

    def __str__(self):
        r"""__str__(LennardJones self) -> std::string"""
        return _IMP_atom.LennardJones___str__(self)

    def __repr__(self):
        r"""__repr__(LennardJones self) -> std::string"""
        return _IMP_atom.LennardJones___repr__(self)
    __swig_destroy__ = _IMP_atom.delete_LennardJones

# Register LennardJones in _IMP_atom:
_IMP_atom.LennardJones_swigregister(LennardJones)

def LennardJones_setup_particle(*args):
    r"""
    LennardJones_setup_particle(Model m, ParticleIndex pi) -> LennardJones
    LennardJones_setup_particle(_ParticleAdaptor decorator) -> LennardJones
    LennardJones_setup_particle(Model m, ParticleIndex pi, IMP::Float well_depth) -> LennardJones
    LennardJones_setup_particle(_ParticleAdaptor decorator, IMP::Float well_depth) -> LennardJones
    """
    return _IMP_atom.LennardJones_setup_particle(*args)

def LennardJones_get_is_setup(*args):
    r"""
    LennardJones_get_is_setup(_ParticleAdaptor p) -> bool
    LennardJones_get_is_setup(Model m, ParticleIndex pi) -> bool
    """
    return _IMP_atom.LennardJones_get_is_setup(*args)

def LennardJones_get_well_depth_key():
    r"""LennardJones_get_well_depth_key() -> FloatKey"""
    return _IMP_atom.LennardJones_get_well_depth_key()

class LennardJonesPairScore(IMP.PairScore):
    r"""Proxy of C++ IMP::atom::LennardJonesPairScore class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, f):
        r"""__init__(LennardJonesPairScore self, SmoothingFunction f) -> LennardJonesPairScore"""
        _IMP_atom.LennardJonesPairScore_swiginit(self, _IMP_atom.new_LennardJonesPairScore(f))

    def set_repulsive_weight(self, repulsive_weight):
        r"""set_repulsive_weight(LennardJonesPairScore self, double repulsive_weight)"""
        return _IMP_atom.LennardJonesPairScore_set_repulsive_weight(self, repulsive_weight)

    def get_repulsive_weight(self):
        r"""get_repulsive_weight(LennardJonesPairScore self) -> double"""
        return _IMP_atom.LennardJonesPairScore_get_repulsive_weight(self)

    def set_attractive_weight(self, attractive_weight):
        r"""set_attractive_weight(LennardJonesPairScore self, double attractive_weight)"""
        return _IMP_atom.LennardJonesPairScore_set_attractive_weight(self, attractive_weight)

    def get_attractive_weight(self):
        r"""get_attractive_weight(LennardJonesPairScore self) -> double"""
        return _IMP_atom.LennardJonesPairScore_get_attractive_weight(self)

    def do_get_inputs(self, m, pis):
        r"""do_get_inputs(LennardJonesPairScore self, Model m, IMP::ParticleIndexes const & pis) -> IMP::ModelObjectsTemp"""
        return _IMP_atom.LennardJonesPairScore_do_get_inputs(self, m, pis)

    def get_version_info(self):
        r"""get_version_info(LennardJonesPairScore self) -> VersionInfo"""
        return _IMP_atom.LennardJonesPairScore_get_version_info(self)

    def __str__(self):
        r"""__str__(LennardJonesPairScore self) -> std::string"""
        return _IMP_atom.LennardJonesPairScore___str__(self)

    def __repr__(self):
        r"""__repr__(LennardJonesPairScore self) -> std::string"""
        return _IMP_atom.LennardJonesPairScore___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_LennardJonesPairScore(o)


# Register LennardJonesPairScore in _IMP_atom:
_IMP_atom.LennardJonesPairScore_swigregister(LennardJonesPairScore)

class LinearVelocity(IMP.Decorator):
    r"""Proxy of C++ IMP::atom::LinearVelocity class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(LinearVelocity self) -> LinearVelocity
        __init__(LinearVelocity self, Model m, ParticleIndex id) -> LinearVelocity
        __init__(LinearVelocity self, _ParticleAdaptor d) -> LinearVelocity
        """
        _IMP_atom.LinearVelocity_swiginit(self, _IMP_atom.new_LinearVelocity(*args))

    @staticmethod
    def get_is_setup(*args):
        r"""
        get_is_setup(Model m, ParticleIndex pi) -> bool
        get_is_setup(_ParticleAdaptor p) -> bool
        """
        return _IMP_atom.LinearVelocity_get_is_setup(*args)

    def show(self, *args):
        r"""show(LinearVelocity self, _ostream out=std::cout)"""
        return _IMP_atom.LinearVelocity_show(self, *args)

    @staticmethod
    def setup_particle(*args):
        r"""
        setup_particle(Model m, ParticleIndex pi) -> LinearVelocity
        setup_particle(_ParticleAdaptor decorator) -> LinearVelocity
        setup_particle(Model m, ParticleIndex pi, Vector3D v) -> LinearVelocity
        setup_particle(_ParticleAdaptor decorator, Vector3D v) -> LinearVelocity
        """
        return _IMP_atom.LinearVelocity_setup_particle(*args)

    def set_velocity(self, v):
        r"""set_velocity(LinearVelocity self, Vector3D v)"""
        return _IMP_atom.LinearVelocity_set_velocity(self, v)

    def get_velocity(self):
        r"""get_velocity(LinearVelocity self) -> Vector3D"""
        return _IMP_atom.LinearVelocity_get_velocity(self)

    def add_attribute(self, *args):
        r"""
        add_attribute(LinearVelocity self, FloatKey k, IMP::Float v, bool opt)
        add_attribute(LinearVelocity self, FloatKey a0, IMP::Float a1)
        add_attribute(LinearVelocity self, IntKey a0, IMP::Int a1)
        add_attribute(LinearVelocity self, FloatsKey a0, IMP::Floats a1)
        add_attribute(LinearVelocity self, IntsKey a0, IMP::Ints a1)
        add_attribute(LinearVelocity self, StringKey a0, IMP::String a1)
        add_attribute(LinearVelocity self, ParticleIndexKey a0, Particle a1)
        add_attribute(LinearVelocity self, ObjectKey a0, Object a1)
        """
        return _IMP_atom.LinearVelocity_add_attribute(self, *args)

    def get_value(self, *args):
        r"""
        get_value(LinearVelocity self, FloatKey a0) -> IMP::Float
        get_value(LinearVelocity self, IntKey a0) -> IMP::Int
        get_value(LinearVelocity self, FloatsKey a0) -> IMP::Floats
        get_value(LinearVelocity self, IntsKey a0) -> IMP::Ints
        get_value(LinearVelocity self, StringKey a0) -> IMP::String
        get_value(LinearVelocity self, ParticleIndexKey a0) -> Particle
        get_value(LinearVelocity self, ObjectKey a0) -> Object
        """
        return _IMP_atom.LinearVelocity_get_value(self, *args)

    def set_value(self, *args):
        r"""
        set_value(LinearVelocity self, FloatKey a0, IMP::Float a1)
        set_value(LinearVelocity self, IntKey a0, IMP::Int a1)
        set_value(LinearVelocity self, FloatsKey a0, IMP::Floats a1)
        set_value(LinearVelocity self, IntsKey a0, IMP::Ints a1)
        set_value(LinearVelocity self, StringKey a0, IMP::String a1)
        set_value(LinearVelocity self, ParticleIndexKey a0, Particle a1)
        set_value(LinearVelocity self, ObjectKey a0, Object a1)
        """
        return _IMP_atom.LinearVelocity_set_value(self, *args)

    def remove_attribute(self, *args):
        r"""
        remove_attribute(LinearVelocity self, FloatKey a0)
        remove_attribute(LinearVelocity self, IntKey a0)
        remove_attribute(LinearVelocity self, FloatsKey a0)
        remove_attribute(LinearVelocity self, IntsKey a0)
        remove_attribute(LinearVelocity self, StringKey a0)
        remove_attribute(LinearVelocity self, ParticleIndexKey a0)
        remove_attribute(LinearVelocity self, ObjectKey a0)
        """
        return _IMP_atom.LinearVelocity_remove_attribute(self, *args)

    def has_attribute(self, *args):
        r"""
        has_attribute(LinearVelocity self, FloatKey a0) -> bool
        has_attribute(LinearVelocity self, IntKey a0) -> bool
        has_attribute(LinearVelocity self, FloatsKey a0) -> bool
        has_attribute(LinearVelocity self, IntsKey a0) -> bool
        has_attribute(LinearVelocity self, StringKey a0) -> bool
        has_attribute(LinearVelocity self, ParticleIndexKey a0) -> bool
        has_attribute(LinearVelocity self, ObjectKey a0) -> bool
        """
        return _IMP_atom.LinearVelocity_has_attribute(self, *args)

    def get_derivative(self, a0):
        r"""get_derivative(LinearVelocity self, FloatKey a0) -> double"""
        return _IMP_atom.LinearVelocity_get_derivative(self, a0)

    def get_name(self):
        r"""get_name(LinearVelocity self) -> std::string"""
        return _IMP_atom.LinearVelocity_get_name(self)

    def clear_caches(self):
        r"""clear_caches(LinearVelocity self)"""
        return _IMP_atom.LinearVelocity_clear_caches(self)

    def set_name(self, a0):
        r"""set_name(LinearVelocity self, std::string a0)"""
        return _IMP_atom.LinearVelocity_set_name(self, a0)

    def set_check_level(self, a0):
        r"""set_check_level(LinearVelocity self, IMP::CheckLevel a0)"""
        return _IMP_atom.LinearVelocity_set_check_level(self, a0)

    def add_to_derivative(self, a0, a1, a2):
        r"""add_to_derivative(LinearVelocity self, FloatKey a0, double a1, DerivativeAccumulator a2)"""
        return _IMP_atom.LinearVelocity_add_to_derivative(self, a0, a1, a2)

    def set_is_optimized(self, a0, a1):
        r"""set_is_optimized(LinearVelocity self, FloatKey a0, bool a1)"""
        return _IMP_atom.LinearVelocity_set_is_optimized(self, a0, a1)

    def get_is_optimized(self, a0):
        r"""get_is_optimized(LinearVelocity self, FloatKey a0) -> bool"""
        return _IMP_atom.LinearVelocity_get_is_optimized(self, a0)

    def get_check_level(self):
        r"""get_check_level(LinearVelocity self) -> IMP::CheckLevel"""
        return _IMP_atom.LinearVelocity_get_check_level(self)

    def __eq__(self, *args):
        r"""
        __eq__(LinearVelocity self, LinearVelocity o) -> bool
        __eq__(LinearVelocity self, Particle d) -> bool
        """
        return _IMP_atom.LinearVelocity___eq__(self, *args)

    def __ne__(self, *args):
        r"""
        __ne__(LinearVelocity self, LinearVelocity o) -> bool
        __ne__(LinearVelocity self, Particle d) -> bool
        """
        return _IMP_atom.LinearVelocity___ne__(self, *args)

    def __le__(self, *args):
        r"""
        __le__(LinearVelocity self, LinearVelocity o) -> bool
        __le__(LinearVelocity self, Particle d) -> bool
        """
        return _IMP_atom.LinearVelocity___le__(self, *args)

    def __lt__(self, *args):
        r"""
        __lt__(LinearVelocity self, LinearVelocity o) -> bool
        __lt__(LinearVelocity self, Particle d) -> bool
        """
        return _IMP_atom.LinearVelocity___lt__(self, *args)

    def __ge__(self, *args):
        r"""
        __ge__(LinearVelocity self, LinearVelocity o) -> bool
        __ge__(LinearVelocity self, Particle d) -> bool
        """
        return _IMP_atom.LinearVelocity___ge__(self, *args)

    def __gt__(self, *args):
        r"""
        __gt__(LinearVelocity self, LinearVelocity o) -> bool
        __gt__(LinearVelocity self, Particle d) -> bool
        """
        return _IMP_atom.LinearVelocity___gt__(self, *args)

    def __hash__(self):
        r"""__hash__(LinearVelocity self) -> std::size_t"""
        return _IMP_atom.LinearVelocity___hash__(self)

    def __str__(self):
        r"""__str__(LinearVelocity self) -> std::string"""
        return _IMP_atom.LinearVelocity___str__(self)

    def __repr__(self):
        r"""__repr__(LinearVelocity self) -> std::string"""
        return _IMP_atom.LinearVelocity___repr__(self)
    __swig_destroy__ = _IMP_atom.delete_LinearVelocity

# Register LinearVelocity in _IMP_atom:
_IMP_atom.LinearVelocity_swigregister(LinearVelocity)

def LinearVelocity_get_is_setup(*args):
    r"""
    LinearVelocity_get_is_setup(Model m, ParticleIndex pi) -> bool
    LinearVelocity_get_is_setup(_ParticleAdaptor p) -> bool
    """
    return _IMP_atom.LinearVelocity_get_is_setup(*args)

def LinearVelocity_setup_particle(*args):
    r"""
    LinearVelocity_setup_particle(Model m, ParticleIndex pi) -> LinearVelocity
    LinearVelocity_setup_particle(_ParticleAdaptor decorator) -> LinearVelocity
    LinearVelocity_setup_particle(Model m, ParticleIndex pi, Vector3D v) -> LinearVelocity
    LinearVelocity_setup_particle(_ParticleAdaptor decorator, Vector3D v) -> LinearVelocity
    """
    return _IMP_atom.LinearVelocity_setup_particle(*args)

class AngularVelocity(IMP.Decorator):
    r"""Proxy of C++ IMP::atom::AngularVelocity class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(AngularVelocity self) -> AngularVelocity
        __init__(AngularVelocity self, Model m, ParticleIndex id) -> AngularVelocity
        __init__(AngularVelocity self, _ParticleAdaptor d) -> AngularVelocity
        """
        _IMP_atom.AngularVelocity_swiginit(self, _IMP_atom.new_AngularVelocity(*args))

    @staticmethod
    def get_is_setup(*args):
        r"""
        get_is_setup(Model m, ParticleIndex pi) -> bool
        get_is_setup(_ParticleAdaptor p) -> bool
        """
        return _IMP_atom.AngularVelocity_get_is_setup(*args)

    def show(self, *args):
        r"""show(AngularVelocity self, _ostream out=std::cout)"""
        return _IMP_atom.AngularVelocity_show(self, *args)

    @staticmethod
    def setup_particle(*args):
        r"""
        setup_particle(Model m, ParticleIndex pi) -> AngularVelocity
        setup_particle(_ParticleAdaptor decorator) -> AngularVelocity
        setup_particle(Model m, ParticleIndex pi, Vector4D v) -> AngularVelocity
        setup_particle(_ParticleAdaptor decorator, Vector4D v) -> AngularVelocity
        """
        return _IMP_atom.AngularVelocity_setup_particle(*args)

    def set_velocity(self, v):
        r"""set_velocity(AngularVelocity self, Vector4D v)"""
        return _IMP_atom.AngularVelocity_set_velocity(self, v)

    def get_velocity(self):
        r"""get_velocity(AngularVelocity self) -> Vector4D"""
        return _IMP_atom.AngularVelocity_get_velocity(self)

    def add_attribute(self, *args):
        r"""
        add_attribute(AngularVelocity self, FloatKey k, IMP::Float v, bool opt)
        add_attribute(AngularVelocity self, FloatKey a0, IMP::Float a1)
        add_attribute(AngularVelocity self, IntKey a0, IMP::Int a1)
        add_attribute(AngularVelocity self, FloatsKey a0, IMP::Floats a1)
        add_attribute(AngularVelocity self, IntsKey a0, IMP::Ints a1)
        add_attribute(AngularVelocity self, StringKey a0, IMP::String a1)
        add_attribute(AngularVelocity self, ParticleIndexKey a0, Particle a1)
        add_attribute(AngularVelocity self, ObjectKey a0, Object a1)
        """
        return _IMP_atom.AngularVelocity_add_attribute(self, *args)

    def get_value(self, *args):
        r"""
        get_value(AngularVelocity self, FloatKey a0) -> IMP::Float
        get_value(AngularVelocity self, IntKey a0) -> IMP::Int
        get_value(AngularVelocity self, FloatsKey a0) -> IMP::Floats
        get_value(AngularVelocity self, IntsKey a0) -> IMP::Ints
        get_value(AngularVelocity self, StringKey a0) -> IMP::String
        get_value(AngularVelocity self, ParticleIndexKey a0) -> Particle
        get_value(AngularVelocity self, ObjectKey a0) -> Object
        """
        return _IMP_atom.AngularVelocity_get_value(self, *args)

    def set_value(self, *args):
        r"""
        set_value(AngularVelocity self, FloatKey a0, IMP::Float a1)
        set_value(AngularVelocity self, IntKey a0, IMP::Int a1)
        set_value(AngularVelocity self, FloatsKey a0, IMP::Floats a1)
        set_value(AngularVelocity self, IntsKey a0, IMP::Ints a1)
        set_value(AngularVelocity self, StringKey a0, IMP::String a1)
        set_value(AngularVelocity self, ParticleIndexKey a0, Particle a1)
        set_value(AngularVelocity self, ObjectKey a0, Object a1)
        """
        return _IMP_atom.AngularVelocity_set_value(self, *args)

    def remove_attribute(self, *args):
        r"""
        remove_attribute(AngularVelocity self, FloatKey a0)
        remove_attribute(AngularVelocity self, IntKey a0)
        remove_attribute(AngularVelocity self, FloatsKey a0)
        remove_attribute(AngularVelocity self, IntsKey a0)
        remove_attribute(AngularVelocity self, StringKey a0)
        remove_attribute(AngularVelocity self, ParticleIndexKey a0)
        remove_attribute(AngularVelocity self, ObjectKey a0)
        """
        return _IMP_atom.AngularVelocity_remove_attribute(self, *args)

    def has_attribute(self, *args):
        r"""
        has_attribute(AngularVelocity self, FloatKey a0) -> bool
        has_attribute(AngularVelocity self, IntKey a0) -> bool
        has_attribute(AngularVelocity self, FloatsKey a0) -> bool
        has_attribute(AngularVelocity self, IntsKey a0) -> bool
        has_attribute(AngularVelocity self, StringKey a0) -> bool
        has_attribute(AngularVelocity self, ParticleIndexKey a0) -> bool
        has_attribute(AngularVelocity self, ObjectKey a0) -> bool
        """
        return _IMP_atom.AngularVelocity_has_attribute(self, *args)

    def get_derivative(self, a0):
        r"""get_derivative(AngularVelocity self, FloatKey a0) -> double"""
        return _IMP_atom.AngularVelocity_get_derivative(self, a0)

    def get_name(self):
        r"""get_name(AngularVelocity self) -> std::string"""
        return _IMP_atom.AngularVelocity_get_name(self)

    def clear_caches(self):
        r"""clear_caches(AngularVelocity self)"""
        return _IMP_atom.AngularVelocity_clear_caches(self)

    def set_name(self, a0):
        r"""set_name(AngularVelocity self, std::string a0)"""
        return _IMP_atom.AngularVelocity_set_name(self, a0)

    def set_check_level(self, a0):
        r"""set_check_level(AngularVelocity self, IMP::CheckLevel a0)"""
        return _IMP_atom.AngularVelocity_set_check_level(self, a0)

    def add_to_derivative(self, a0, a1, a2):
        r"""add_to_derivative(AngularVelocity self, FloatKey a0, double a1, DerivativeAccumulator a2)"""
        return _IMP_atom.AngularVelocity_add_to_derivative(self, a0, a1, a2)

    def set_is_optimized(self, a0, a1):
        r"""set_is_optimized(AngularVelocity self, FloatKey a0, bool a1)"""
        return _IMP_atom.AngularVelocity_set_is_optimized(self, a0, a1)

    def get_is_optimized(self, a0):
        r"""get_is_optimized(AngularVelocity self, FloatKey a0) -> bool"""
        return _IMP_atom.AngularVelocity_get_is_optimized(self, a0)

    def get_check_level(self):
        r"""get_check_level(AngularVelocity self) -> IMP::CheckLevel"""
        return _IMP_atom.AngularVelocity_get_check_level(self)

    def __eq__(self, *args):
        r"""
        __eq__(AngularVelocity self, AngularVelocity o) -> bool
        __eq__(AngularVelocity self, Particle d) -> bool
        """
        return _IMP_atom.AngularVelocity___eq__(self, *args)

    def __ne__(self, *args):
        r"""
        __ne__(AngularVelocity self, AngularVelocity o) -> bool
        __ne__(AngularVelocity self, Particle d) -> bool
        """
        return _IMP_atom.AngularVelocity___ne__(self, *args)

    def __le__(self, *args):
        r"""
        __le__(AngularVelocity self, AngularVelocity o) -> bool
        __le__(AngularVelocity self, Particle d) -> bool
        """
        return _IMP_atom.AngularVelocity___le__(self, *args)

    def __lt__(self, *args):
        r"""
        __lt__(AngularVelocity self, AngularVelocity o) -> bool
        __lt__(AngularVelocity self, Particle d) -> bool
        """
        return _IMP_atom.AngularVelocity___lt__(self, *args)

    def __ge__(self, *args):
        r"""
        __ge__(AngularVelocity self, AngularVelocity o) -> bool
        __ge__(AngularVelocity self, Particle d) -> bool
        """
        return _IMP_atom.AngularVelocity___ge__(self, *args)

    def __gt__(self, *args):
        r"""
        __gt__(AngularVelocity self, AngularVelocity o) -> bool
        __gt__(AngularVelocity self, Particle d) -> bool
        """
        return _IMP_atom.AngularVelocity___gt__(self, *args)

    def __hash__(self):
        r"""__hash__(AngularVelocity self) -> std::size_t"""
        return _IMP_atom.AngularVelocity___hash__(self)

    def __str__(self):
        r"""__str__(AngularVelocity self) -> std::string"""
        return _IMP_atom.AngularVelocity___str__(self)

    def __repr__(self):
        r"""__repr__(AngularVelocity self) -> std::string"""
        return _IMP_atom.AngularVelocity___repr__(self)
    __swig_destroy__ = _IMP_atom.delete_AngularVelocity

# Register AngularVelocity in _IMP_atom:
_IMP_atom.AngularVelocity_swigregister(AngularVelocity)

def AngularVelocity_get_is_setup(*args):
    r"""
    AngularVelocity_get_is_setup(Model m, ParticleIndex pi) -> bool
    AngularVelocity_get_is_setup(_ParticleAdaptor p) -> bool
    """
    return _IMP_atom.AngularVelocity_get_is_setup(*args)

def AngularVelocity_setup_particle(*args):
    r"""
    AngularVelocity_setup_particle(Model m, ParticleIndex pi) -> AngularVelocity
    AngularVelocity_setup_particle(_ParticleAdaptor decorator) -> AngularVelocity
    AngularVelocity_setup_particle(Model m, ParticleIndex pi, Vector4D v) -> AngularVelocity
    AngularVelocity_setup_particle(_ParticleAdaptor decorator, Vector4D v) -> AngularVelocity
    """
    return _IMP_atom.AngularVelocity_setup_particle(*args)

class MolecularDynamics(Simulator):
    r"""Proxy of C++ IMP::atom::MolecularDynamics class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, m):
        r"""__init__(MolecularDynamics self, Model m) -> MolecularDynamics"""
        _IMP_atom.MolecularDynamics_swiginit(self, _IMP_atom.new_MolecularDynamics(m))

    def get_kinetic_energy(self):
        r"""get_kinetic_energy(MolecularDynamics self) -> IMP::Float"""
        return _IMP_atom.MolecularDynamics_get_kinetic_energy(self)

    def get_kinetic_temperature(self, ekinetic):
        r"""get_kinetic_temperature(MolecularDynamics self, IMP::Float ekinetic) -> IMP::Float"""
        return _IMP_atom.MolecularDynamics_get_kinetic_temperature(self, ekinetic)

    def set_velocity_cap(self, velocity_cap):
        r"""set_velocity_cap(MolecularDynamics self, IMP::Float velocity_cap)"""
        return _IMP_atom.MolecularDynamics_set_velocity_cap(self, velocity_cap)

    def assign_velocities(self, temperature):
        r"""assign_velocities(MolecularDynamics self, IMP::Float temperature)"""
        return _IMP_atom.MolecularDynamics_assign_velocities(self, temperature)

    def setup(self, ps):
        r"""setup(MolecularDynamics self, IMP::ParticleIndexes const & ps)"""
        return _IMP_atom.MolecularDynamics_setup(self, ps)

    def do_step(self, sc, dt):
        r"""do_step(MolecularDynamics self, IMP::ParticleIndexes const & sc, double dt) -> double"""
        return _IMP_atom.MolecularDynamics_do_step(self, sc, dt)

    def get_is_simulation_particle(self, p):
        r"""get_is_simulation_particle(MolecularDynamics self, ParticleIndex p) -> bool"""
        return _IMP_atom.MolecularDynamics_get_is_simulation_particle(self, p)

    def get_version_info(self):
        r"""get_version_info(MolecularDynamics self) -> VersionInfo"""
        return _IMP_atom.MolecularDynamics_get_version_info(self)

    def __str__(self):
        r"""__str__(MolecularDynamics self) -> std::string"""
        return _IMP_atom.MolecularDynamics___str__(self)

    def __repr__(self):
        r"""__repr__(MolecularDynamics self) -> std::string"""
        return _IMP_atom.MolecularDynamics___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_MolecularDynamics(o)


# Register MolecularDynamics in _IMP_atom:
_IMP_atom.MolecularDynamics_swigregister(MolecularDynamics)

class VelocityScalingOptimizerState(IMP.OptimizerState):
    r"""Proxy of C++ IMP::atom::VelocityScalingOptimizerState class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, m, pis, temperature):
        r"""__init__(VelocityScalingOptimizerState self, Model m, _ParticleIndexesAdaptor pis, double temperature) -> VelocityScalingOptimizerState"""
        _IMP_atom.VelocityScalingOptimizerState_swiginit(self, _IMP_atom.new_VelocityScalingOptimizerState(m, pis, temperature))

    def set_particles(self, pis):
        r"""set_particles(VelocityScalingOptimizerState self, IMP::Particles const & pis)"""
        return _IMP_atom.VelocityScalingOptimizerState_set_particles(self, pis)

    def set_temperature(self, temperature):
        r"""set_temperature(VelocityScalingOptimizerState self, IMP::Float temperature)"""
        return _IMP_atom.VelocityScalingOptimizerState_set_temperature(self, temperature)

    def rescale_velocities(self):
        r"""rescale_velocities(VelocityScalingOptimizerState self)"""
        return _IMP_atom.VelocityScalingOptimizerState_rescale_velocities(self)

    def get_version_info(self):
        r"""get_version_info(VelocityScalingOptimizerState self) -> VersionInfo"""
        return _IMP_atom.VelocityScalingOptimizerState_get_version_info(self)

    def __str__(self):
        r"""__str__(VelocityScalingOptimizerState self) -> std::string"""
        return _IMP_atom.VelocityScalingOptimizerState___str__(self)

    def __repr__(self):
        r"""__repr__(VelocityScalingOptimizerState self) -> std::string"""
        return _IMP_atom.VelocityScalingOptimizerState___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_VelocityScalingOptimizerState(o)


# Register VelocityScalingOptimizerState in _IMP_atom:
_IMP_atom.VelocityScalingOptimizerState_swigregister(VelocityScalingOptimizerState)

class Fragment(Hierarchy):
    r"""Proxy of C++ IMP::atom::Fragment class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def set_residue_indexes(self, o):
        r"""set_residue_indexes(Fragment self, IMP::Ints o)"""
        return _IMP_atom.Fragment_set_residue_indexes(self, o)

    def get_residue_indexes(self):
        r"""get_residue_indexes(Fragment self) -> IMP::Ints"""
        return _IMP_atom.Fragment_get_residue_indexes(self)

    def get_contains_residue(self, rindex):
        r"""get_contains_residue(Fragment self, int rindex) -> bool"""
        return _IMP_atom.Fragment_get_contains_residue(self, rindex)

    def __init__(self, *args):
        r"""
        __init__(Fragment self) -> Fragment
        __init__(Fragment self, Model m, ParticleIndex id) -> Fragment
        __init__(Fragment self, _ParticleAdaptor d) -> Fragment
        """
        _IMP_atom.Fragment_swiginit(self, _IMP_atom.new_Fragment(*args))

    @staticmethod
    def get_is_setup(*args):
        r"""
        get_is_setup(Model m, ParticleIndex pi) -> bool
        get_is_setup(_ParticleAdaptor p) -> bool
        """
        return _IMP_atom.Fragment_get_is_setup(*args)

    def show(self, *args):
        r"""show(Fragment self, _ostream out=std::cout)"""
        return _IMP_atom.Fragment_show(self, *args)

    @staticmethod
    def setup_particle(*args):
        r"""
        setup_particle(Model m, ParticleIndex pi) -> Fragment
        setup_particle(_ParticleAdaptor decorator) -> Fragment
        setup_particle(Model m, ParticleIndex pi, Fragment other) -> Fragment
        setup_particle(_ParticleAdaptor decorator, Fragment other) -> Fragment
        setup_particle(Model m, ParticleIndex pi, IMP::Ints residue_indexes) -> Fragment
        setup_particle(_ParticleAdaptor decorator, IMP::Ints residue_indexes) -> Fragment
        """
        return _IMP_atom.Fragment_setup_particle(*args)

    def add_attribute(self, *args):
        r"""
        add_attribute(Fragment self, FloatKey k, IMP::Float v, bool opt)
        add_attribute(Fragment self, FloatKey a0, IMP::Float a1)
        add_attribute(Fragment self, IntKey a0, IMP::Int a1)
        add_attribute(Fragment self, FloatsKey a0, IMP::Floats a1)
        add_attribute(Fragment self, IntsKey a0, IMP::Ints a1)
        add_attribute(Fragment self, StringKey a0, IMP::String a1)
        add_attribute(Fragment self, ParticleIndexKey a0, Particle a1)
        add_attribute(Fragment self, ObjectKey a0, Object a1)
        """
        return _IMP_atom.Fragment_add_attribute(self, *args)

    def get_value(self, *args):
        r"""
        get_value(Fragment self, FloatKey a0) -> IMP::Float
        get_value(Fragment self, IntKey a0) -> IMP::Int
        get_value(Fragment self, FloatsKey a0) -> IMP::Floats
        get_value(Fragment self, IntsKey a0) -> IMP::Ints
        get_value(Fragment self, StringKey a0) -> IMP::String
        get_value(Fragment self, ParticleIndexKey a0) -> Particle
        get_value(Fragment self, ObjectKey a0) -> Object
        """
        return _IMP_atom.Fragment_get_value(self, *args)

    def set_value(self, *args):
        r"""
        set_value(Fragment self, FloatKey a0, IMP::Float a1)
        set_value(Fragment self, IntKey a0, IMP::Int a1)
        set_value(Fragment self, FloatsKey a0, IMP::Floats a1)
        set_value(Fragment self, IntsKey a0, IMP::Ints a1)
        set_value(Fragment self, StringKey a0, IMP::String a1)
        set_value(Fragment self, ParticleIndexKey a0, Particle a1)
        set_value(Fragment self, ObjectKey a0, Object a1)
        """
        return _IMP_atom.Fragment_set_value(self, *args)

    def remove_attribute(self, *args):
        r"""
        remove_attribute(Fragment self, FloatKey a0)
        remove_attribute(Fragment self, IntKey a0)
        remove_attribute(Fragment self, FloatsKey a0)
        remove_attribute(Fragment self, IntsKey a0)
        remove_attribute(Fragment self, StringKey a0)
        remove_attribute(Fragment self, ParticleIndexKey a0)
        remove_attribute(Fragment self, ObjectKey a0)
        """
        return _IMP_atom.Fragment_remove_attribute(self, *args)

    def has_attribute(self, *args):
        r"""
        has_attribute(Fragment self, FloatKey a0) -> bool
        has_attribute(Fragment self, IntKey a0) -> bool
        has_attribute(Fragment self, FloatsKey a0) -> bool
        has_attribute(Fragment self, IntsKey a0) -> bool
        has_attribute(Fragment self, StringKey a0) -> bool
        has_attribute(Fragment self, ParticleIndexKey a0) -> bool
        has_attribute(Fragment self, ObjectKey a0) -> bool
        """
        return _IMP_atom.Fragment_has_attribute(self, *args)

    def get_derivative(self, a0):
        r"""get_derivative(Fragment self, FloatKey a0) -> double"""
        return _IMP_atom.Fragment_get_derivative(self, a0)

    def get_name(self):
        r"""get_name(Fragment self) -> std::string"""
        return _IMP_atom.Fragment_get_name(self)

    def clear_caches(self):
        r"""clear_caches(Fragment self)"""
        return _IMP_atom.Fragment_clear_caches(self)

    def set_name(self, a0):
        r"""set_name(Fragment self, std::string a0)"""
        return _IMP_atom.Fragment_set_name(self, a0)

    def set_check_level(self, a0):
        r"""set_check_level(Fragment self, IMP::CheckLevel a0)"""
        return _IMP_atom.Fragment_set_check_level(self, a0)

    def add_to_derivative(self, a0, a1, a2):
        r"""add_to_derivative(Fragment self, FloatKey a0, double a1, DerivativeAccumulator a2)"""
        return _IMP_atom.Fragment_add_to_derivative(self, a0, a1, a2)

    def set_is_optimized(self, a0, a1):
        r"""set_is_optimized(Fragment self, FloatKey a0, bool a1)"""
        return _IMP_atom.Fragment_set_is_optimized(self, a0, a1)

    def get_is_optimized(self, a0):
        r"""get_is_optimized(Fragment self, FloatKey a0) -> bool"""
        return _IMP_atom.Fragment_get_is_optimized(self, a0)

    def get_check_level(self):
        r"""get_check_level(Fragment self) -> IMP::CheckLevel"""
        return _IMP_atom.Fragment_get_check_level(self)

    def __eq__(self, *args):
        r"""
        __eq__(Fragment self, Fragment o) -> bool
        __eq__(Fragment self, Particle d) -> bool
        """
        return _IMP_atom.Fragment___eq__(self, *args)

    def __ne__(self, *args):
        r"""
        __ne__(Fragment self, Fragment o) -> bool
        __ne__(Fragment self, Particle d) -> bool
        """
        return _IMP_atom.Fragment___ne__(self, *args)

    def __le__(self, *args):
        r"""
        __le__(Fragment self, Fragment o) -> bool
        __le__(Fragment self, Particle d) -> bool
        """
        return _IMP_atom.Fragment___le__(self, *args)

    def __lt__(self, *args):
        r"""
        __lt__(Fragment self, Fragment o) -> bool
        __lt__(Fragment self, Particle d) -> bool
        """
        return _IMP_atom.Fragment___lt__(self, *args)

    def __ge__(self, *args):
        r"""
        __ge__(Fragment self, Fragment o) -> bool
        __ge__(Fragment self, Particle d) -> bool
        """
        return _IMP_atom.Fragment___ge__(self, *args)

    def __gt__(self, *args):
        r"""
        __gt__(Fragment self, Fragment o) -> bool
        __gt__(Fragment self, Particle d) -> bool
        """
        return _IMP_atom.Fragment___gt__(self, *args)

    def __hash__(self):
        r"""__hash__(Fragment self) -> std::size_t"""
        return _IMP_atom.Fragment___hash__(self)

    def __str__(self):
        r"""__str__(Fragment self) -> std::string"""
        return _IMP_atom.Fragment___str__(self)

    def __repr__(self):
        r"""__repr__(Fragment self) -> std::string"""
        return _IMP_atom.Fragment___repr__(self)
    __swig_destroy__ = _IMP_atom.delete_Fragment

# Register Fragment in _IMP_atom:
_IMP_atom.Fragment_swigregister(Fragment)

def Fragment_get_is_setup(*args):
    r"""
    Fragment_get_is_setup(Model m, ParticleIndex pi) -> bool
    Fragment_get_is_setup(_ParticleAdaptor p) -> bool
    """
    return _IMP_atom.Fragment_get_is_setup(*args)

def Fragment_setup_particle(*args):
    r"""
    Fragment_setup_particle(Model m, ParticleIndex pi) -> Fragment
    Fragment_setup_particle(_ParticleAdaptor decorator) -> Fragment
    Fragment_setup_particle(Model m, ParticleIndex pi, Fragment other) -> Fragment
    Fragment_setup_particle(_ParticleAdaptor decorator, Fragment other) -> Fragment
    Fragment_setup_particle(Model m, ParticleIndex pi, IMP::Ints residue_indexes) -> Fragment
    Fragment_setup_particle(_ParticleAdaptor decorator, IMP::Ints residue_indexes) -> Fragment
    """
    return _IMP_atom.Fragment_setup_particle(*args)

class StereochemistryPairFilter(IMP.PairPredicate):
    r"""Proxy of C++ IMP::atom::StereochemistryPairFilter class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self):
        r"""__init__(StereochemistryPairFilter self) -> StereochemistryPairFilter"""
        _IMP_atom.StereochemistryPairFilter_swiginit(self, _IMP_atom.new_StereochemistryPairFilter())

    def set_bonds(self, bonds):
        r"""set_bonds(StereochemistryPairFilter self, IMP::Particles const & bonds)"""
        return _IMP_atom.StereochemistryPairFilter_set_bonds(self, bonds)

    def set_angles(self, angles):
        r"""set_angles(StereochemistryPairFilter self, IMP::Particles const & angles)"""
        return _IMP_atom.StereochemistryPairFilter_set_angles(self, angles)

    def set_dihedrals(self, dihedrals):
        r"""set_dihedrals(StereochemistryPairFilter self, IMP::Particles const & dihedrals)"""
        return _IMP_atom.StereochemistryPairFilter_set_dihedrals(self, dihedrals)

    def do_get_inputs(self, m, pis):
        r"""do_get_inputs(StereochemistryPairFilter self, Model m, IMP::ParticleIndexes const & pis) -> IMP::ModelObjectsTemp"""
        return _IMP_atom.StereochemistryPairFilter_do_get_inputs(self, m, pis)

    def get_value(self, *args):
        r"""
        get_value(StereochemistryPairFilter self, IMP::ParticlePair const & a) -> int
        get_value(StereochemistryPairFilter self, IMP::ParticlePairsTemp const & o) -> IMP::Ints
        """
        return _IMP_atom.StereochemistryPairFilter_get_value(self, *args)

    def get_value_index(self, *args):
        r"""
        get_value_index(StereochemistryPairFilter self, Model m, IMP::ParticleIndexPair const & p) -> int
        get_value_index(StereochemistryPairFilter self, Model m, IMP::ParticleIndexPairs const & o) -> IMP::Ints
        """
        return _IMP_atom.StereochemistryPairFilter_get_value_index(self, *args)

    def get_version_info(self):
        r"""get_version_info(StereochemistryPairFilter self) -> VersionInfo"""
        return _IMP_atom.StereochemistryPairFilter_get_version_info(self)

    def __str__(self):
        r"""__str__(StereochemistryPairFilter self) -> std::string"""
        return _IMP_atom.StereochemistryPairFilter___str__(self)

    def __repr__(self):
        r"""__repr__(StereochemistryPairFilter self) -> std::string"""
        return _IMP_atom.StereochemistryPairFilter___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_StereochemistryPairFilter(o)


# Register StereochemistryPairFilter in _IMP_atom:
_IMP_atom.StereochemistryPairFilter_swigregister(StereochemistryPairFilter)

class SoapPairFilter(IMP.PairPredicate):
    r"""Proxy of C++ IMP::atom::SoapPairFilter class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, library):
        r"""__init__(SoapPairFilter self, std::string library) -> SoapPairFilter"""
        _IMP_atom.SoapPairFilter_swiginit(self, _IMP_atom.new_SoapPairFilter(library))

    def do_get_inputs(self, m, pis):
        r"""do_get_inputs(SoapPairFilter self, Model m, IMP::ParticleIndexes const & pis) -> IMP::ModelObjectsTemp"""
        return _IMP_atom.SoapPairFilter_do_get_inputs(self, m, pis)

    def get_value(self, *args):
        r"""
        get_value(SoapPairFilter self, IMP::ParticlePair const & a) -> int
        get_value(SoapPairFilter self, IMP::ParticlePairsTemp const & o) -> IMP::Ints
        """
        return _IMP_atom.SoapPairFilter_get_value(self, *args)

    def get_value_index(self, *args):
        r"""
        get_value_index(SoapPairFilter self, Model m, IMP::ParticleIndexPair const & p) -> int
        get_value_index(SoapPairFilter self, Model m, IMP::ParticleIndexPairs const & o) -> IMP::Ints
        """
        return _IMP_atom.SoapPairFilter_get_value_index(self, *args)

    def get_version_info(self):
        r"""get_version_info(SoapPairFilter self) -> VersionInfo"""
        return _IMP_atom.SoapPairFilter_get_version_info(self)

    def __str__(self):
        r"""__str__(SoapPairFilter self) -> std::string"""
        return _IMP_atom.SoapPairFilter___str__(self)

    def __repr__(self):
        r"""__repr__(SoapPairFilter self) -> std::string"""
        return _IMP_atom.SoapPairFilter___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_SoapPairFilter(o)


# Register SoapPairFilter in _IMP_atom:
_IMP_atom.SoapPairFilter_swigregister(SoapPairFilter)

class Mass(IMP.Decorator):
    r"""Proxy of C++ IMP::atom::Mass class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def get_mass(self):
        r"""get_mass(Mass self) -> IMP::Float"""
        return _IMP_atom.Mass_get_mass(self)

    def set_mass(self, d):
        r"""set_mass(Mass self, IMP::Float d)"""
        return _IMP_atom.Mass_set_mass(self, d)

    def __init__(self, *args):
        r"""
        __init__(Mass self) -> Mass
        __init__(Mass self, Model m, ParticleIndex id) -> Mass
        __init__(Mass self, _ParticleAdaptor d) -> Mass
        """
        _IMP_atom.Mass_swiginit(self, _IMP_atom.new_Mass(*args))

    @staticmethod
    def get_is_setup(*args):
        r"""
        get_is_setup(Model m, ParticleIndex pi) -> bool
        get_is_setup(_ParticleAdaptor p) -> bool
        """
        return _IMP_atom.Mass_get_is_setup(*args)

    def show(self, *args):
        r"""show(Mass self, _ostream out=std::cout)"""
        return _IMP_atom.Mass_show(self, *args)

    @staticmethod
    def setup_particle(*args):
        r"""
        setup_particle(Model m, ParticleIndex pi, IMP::Float mass) -> Mass
        setup_particle(_ParticleAdaptor decorator, IMP::Float mass) -> Mass
        setup_particle(Model m, ParticleIndex pi, Mass other) -> Mass
        setup_particle(_ParticleAdaptor decorator, Mass other) -> Mass
        """
        return _IMP_atom.Mass_setup_particle(*args)

    @staticmethod
    def get_mass_key():
        r"""get_mass_key() -> FloatKey"""
        return _IMP_atom.Mass_get_mass_key()

    def add_attribute(self, *args):
        r"""
        add_attribute(Mass self, FloatKey k, IMP::Float v, bool opt)
        add_attribute(Mass self, FloatKey a0, IMP::Float a1)
        add_attribute(Mass self, IntKey a0, IMP::Int a1)
        add_attribute(Mass self, FloatsKey a0, IMP::Floats a1)
        add_attribute(Mass self, IntsKey a0, IMP::Ints a1)
        add_attribute(Mass self, StringKey a0, IMP::String a1)
        add_attribute(Mass self, ParticleIndexKey a0, Particle a1)
        add_attribute(Mass self, ObjectKey a0, Object a1)
        """
        return _IMP_atom.Mass_add_attribute(self, *args)

    def get_value(self, *args):
        r"""
        get_value(Mass self, FloatKey a0) -> IMP::Float
        get_value(Mass self, IntKey a0) -> IMP::Int
        get_value(Mass self, FloatsKey a0) -> IMP::Floats
        get_value(Mass self, IntsKey a0) -> IMP::Ints
        get_value(Mass self, StringKey a0) -> IMP::String
        get_value(Mass self, ParticleIndexKey a0) -> Particle
        get_value(Mass self, ObjectKey a0) -> Object
        """
        return _IMP_atom.Mass_get_value(self, *args)

    def set_value(self, *args):
        r"""
        set_value(Mass self, FloatKey a0, IMP::Float a1)
        set_value(Mass self, IntKey a0, IMP::Int a1)
        set_value(Mass self, FloatsKey a0, IMP::Floats a1)
        set_value(Mass self, IntsKey a0, IMP::Ints a1)
        set_value(Mass self, StringKey a0, IMP::String a1)
        set_value(Mass self, ParticleIndexKey a0, Particle a1)
        set_value(Mass self, ObjectKey a0, Object a1)
        """
        return _IMP_atom.Mass_set_value(self, *args)

    def remove_attribute(self, *args):
        r"""
        remove_attribute(Mass self, FloatKey a0)
        remove_attribute(Mass self, IntKey a0)
        remove_attribute(Mass self, FloatsKey a0)
        remove_attribute(Mass self, IntsKey a0)
        remove_attribute(Mass self, StringKey a0)
        remove_attribute(Mass self, ParticleIndexKey a0)
        remove_attribute(Mass self, ObjectKey a0)
        """
        return _IMP_atom.Mass_remove_attribute(self, *args)

    def has_attribute(self, *args):
        r"""
        has_attribute(Mass self, FloatKey a0) -> bool
        has_attribute(Mass self, IntKey a0) -> bool
        has_attribute(Mass self, FloatsKey a0) -> bool
        has_attribute(Mass self, IntsKey a0) -> bool
        has_attribute(Mass self, StringKey a0) -> bool
        has_attribute(Mass self, ParticleIndexKey a0) -> bool
        has_attribute(Mass self, ObjectKey a0) -> bool
        """
        return _IMP_atom.Mass_has_attribute(self, *args)

    def get_derivative(self, a0):
        r"""get_derivative(Mass self, FloatKey a0) -> double"""
        return _IMP_atom.Mass_get_derivative(self, a0)

    def get_name(self):
        r"""get_name(Mass self) -> std::string"""
        return _IMP_atom.Mass_get_name(self)

    def clear_caches(self):
        r"""clear_caches(Mass self)"""
        return _IMP_atom.Mass_clear_caches(self)

    def set_name(self, a0):
        r"""set_name(Mass self, std::string a0)"""
        return _IMP_atom.Mass_set_name(self, a0)

    def set_check_level(self, a0):
        r"""set_check_level(Mass self, IMP::CheckLevel a0)"""
        return _IMP_atom.Mass_set_check_level(self, a0)

    def add_to_derivative(self, a0, a1, a2):
        r"""add_to_derivative(Mass self, FloatKey a0, double a1, DerivativeAccumulator a2)"""
        return _IMP_atom.Mass_add_to_derivative(self, a0, a1, a2)

    def set_is_optimized(self, a0, a1):
        r"""set_is_optimized(Mass self, FloatKey a0, bool a1)"""
        return _IMP_atom.Mass_set_is_optimized(self, a0, a1)

    def get_is_optimized(self, a0):
        r"""get_is_optimized(Mass self, FloatKey a0) -> bool"""
        return _IMP_atom.Mass_get_is_optimized(self, a0)

    def get_check_level(self):
        r"""get_check_level(Mass self) -> IMP::CheckLevel"""
        return _IMP_atom.Mass_get_check_level(self)

    def __eq__(self, *args):
        r"""
        __eq__(Mass self, Mass o) -> bool
        __eq__(Mass self, Particle d) -> bool
        """
        return _IMP_atom.Mass___eq__(self, *args)

    def __ne__(self, *args):
        r"""
        __ne__(Mass self, Mass o) -> bool
        __ne__(Mass self, Particle d) -> bool
        """
        return _IMP_atom.Mass___ne__(self, *args)

    def __le__(self, *args):
        r"""
        __le__(Mass self, Mass o) -> bool
        __le__(Mass self, Particle d) -> bool
        """
        return _IMP_atom.Mass___le__(self, *args)

    def __lt__(self, *args):
        r"""
        __lt__(Mass self, Mass o) -> bool
        __lt__(Mass self, Particle d) -> bool
        """
        return _IMP_atom.Mass___lt__(self, *args)

    def __ge__(self, *args):
        r"""
        __ge__(Mass self, Mass o) -> bool
        __ge__(Mass self, Particle d) -> bool
        """
        return _IMP_atom.Mass___ge__(self, *args)

    def __gt__(self, *args):
        r"""
        __gt__(Mass self, Mass o) -> bool
        __gt__(Mass self, Particle d) -> bool
        """
        return _IMP_atom.Mass___gt__(self, *args)

    def __hash__(self):
        r"""__hash__(Mass self) -> std::size_t"""
        return _IMP_atom.Mass___hash__(self)

    def __str__(self):
        r"""__str__(Mass self) -> std::string"""
        return _IMP_atom.Mass___str__(self)

    def __repr__(self):
        r"""__repr__(Mass self) -> std::string"""
        return _IMP_atom.Mass___repr__(self)
    __swig_destroy__ = _IMP_atom.delete_Mass

# Register Mass in _IMP_atom:
_IMP_atom.Mass_swigregister(Mass)

def Mass_get_is_setup(*args):
    r"""
    Mass_get_is_setup(Model m, ParticleIndex pi) -> bool
    Mass_get_is_setup(_ParticleAdaptor p) -> bool
    """
    return _IMP_atom.Mass_get_is_setup(*args)

def Mass_setup_particle(*args):
    r"""
    Mass_setup_particle(Model m, ParticleIndex pi, IMP::Float mass) -> Mass
    Mass_setup_particle(_ParticleAdaptor decorator, IMP::Float mass) -> Mass
    Mass_setup_particle(Model m, ParticleIndex pi, Mass other) -> Mass
    Mass_setup_particle(_ParticleAdaptor decorator, Mass other) -> Mass
    """
    return _IMP_atom.Mass_setup_particle(*args)

def Mass_get_mass_key():
    r"""Mass_get_mass_key() -> FloatKey"""
    return _IMP_atom.Mass_get_mass_key()

class BondedPairFilter(IMP.PairPredicate):
    r"""Proxy of C++ IMP::atom::BondedPairFilter class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self):
        r"""__init__(BondedPairFilter self) -> BondedPairFilter"""
        _IMP_atom.BondedPairFilter_swiginit(self, _IMP_atom.new_BondedPairFilter())

    def do_get_inputs(self, m, pis):
        r"""do_get_inputs(BondedPairFilter self, Model m, IMP::ParticleIndexes const & pis) -> IMP::ModelObjectsTemp"""
        return _IMP_atom.BondedPairFilter_do_get_inputs(self, m, pis)

    def get_value(self, *args):
        r"""
        get_value(BondedPairFilter self, IMP::ParticlePair const & a) -> int
        get_value(BondedPairFilter self, IMP::ParticlePairsTemp const & o) -> IMP::Ints
        """
        return _IMP_atom.BondedPairFilter_get_value(self, *args)

    def get_value_index(self, *args):
        r"""
        get_value_index(BondedPairFilter self, Model m, IMP::ParticleIndexPair const & p) -> int
        get_value_index(BondedPairFilter self, Model m, IMP::ParticleIndexPairs const & o) -> IMP::Ints
        """
        return _IMP_atom.BondedPairFilter_get_value_index(self, *args)

    def get_version_info(self):
        r"""get_version_info(BondedPairFilter self) -> VersionInfo"""
        return _IMP_atom.BondedPairFilter_get_version_info(self)

    def __str__(self):
        r"""__str__(BondedPairFilter self) -> std::string"""
        return _IMP_atom.BondedPairFilter___str__(self)

    def __repr__(self):
        r"""__repr__(BondedPairFilter self) -> std::string"""
        return _IMP_atom.BondedPairFilter___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_BondedPairFilter(o)


# Register BondedPairFilter in _IMP_atom:
_IMP_atom.BondedPairFilter_swigregister(BondedPairFilter)

class Mol2Selector(IMP.Object):
    r"""Proxy of C++ IMP::atom::Mol2Selector class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")

    def get_is_selected(self, atom_line):
        r"""get_is_selected(Mol2Selector self, std::string const & atom_line) -> bool"""
        return _IMP_atom.Mol2Selector_get_is_selected(self, atom_line)
    __swig_destroy__ = _IMP_atom.delete_Mol2Selector

    def __str__(self):
        r"""__str__(Mol2Selector self) -> std::string"""
        return _IMP_atom.Mol2Selector___str__(self)

    def __repr__(self):
        r"""__repr__(Mol2Selector self) -> std::string"""
        return _IMP_atom.Mol2Selector___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_Mol2Selector(o)


# Register Mol2Selector in _IMP_atom:
_IMP_atom.Mol2Selector_swigregister(Mol2Selector)

class AllMol2Selector(Mol2Selector):
    r"""Proxy of C++ IMP::atom::AllMol2Selector class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __str__(self):
        r"""__str__(AllMol2Selector self) -> std::string"""
        return _IMP_atom.AllMol2Selector___str__(self)

    def __repr__(self):
        r"""__repr__(AllMol2Selector self) -> std::string"""
        return _IMP_atom.AllMol2Selector___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_AllMol2Selector(o)


    def __init__(self):
        r"""__init__(AllMol2Selector self) -> AllMol2Selector"""
        _IMP_atom.AllMol2Selector_swiginit(self, _IMP_atom.new_AllMol2Selector())
    __swig_destroy__ = _IMP_atom.delete_AllMol2Selector

# Register AllMol2Selector in _IMP_atom:
_IMP_atom.AllMol2Selector_swigregister(AllMol2Selector)

class NonHydrogenMol2Selector(Mol2Selector):
    r"""Proxy of C++ IMP::atom::NonHydrogenMol2Selector class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __str__(self):
        r"""__str__(NonHydrogenMol2Selector self) -> std::string"""
        return _IMP_atom.NonHydrogenMol2Selector___str__(self)

    def __repr__(self):
        r"""__repr__(NonHydrogenMol2Selector self) -> std::string"""
        return _IMP_atom.NonHydrogenMol2Selector___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_NonHydrogenMol2Selector(o)


    def __init__(self):
        r"""__init__(NonHydrogenMol2Selector self) -> NonHydrogenMol2Selector"""
        _IMP_atom.NonHydrogenMol2Selector_swiginit(self, _IMP_atom.new_NonHydrogenMol2Selector())
    __swig_destroy__ = _IMP_atom.delete_NonHydrogenMol2Selector

# Register NonHydrogenMol2Selector in _IMP_atom:
_IMP_atom.NonHydrogenMol2Selector_swigregister(NonHydrogenMol2Selector)


def read_mol2(mol2_file, model, mol2sel=None):
    r"""read_mol2(TextInput mol2_file, Model model, Mol2Selector mol2sel=None) -> Hierarchy"""
    return _IMP_atom.read_mol2(mol2_file, model, mol2sel)

def write_mol2(rhd, file_name):
    r"""write_mol2(Hierarchy rhd, TextOutput file_name)"""
    return _IMP_atom.write_mol2(rhd, file_name)
class SecondaryStructureResidue(IMP.Decorator):
    r"""Proxy of C++ IMP::atom::SecondaryStructureResidue class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(SecondaryStructureResidue self) -> SecondaryStructureResidue
        __init__(SecondaryStructureResidue self, Model m, ParticleIndex id) -> SecondaryStructureResidue
        __init__(SecondaryStructureResidue self, _ParticleAdaptor d) -> SecondaryStructureResidue
        """
        _IMP_atom.SecondaryStructureResidue_swiginit(self, _IMP_atom.new_SecondaryStructureResidue(*args))

    def show(self, *args):
        r"""show(SecondaryStructureResidue self, _ostream out=std::cout)"""
        return _IMP_atom.SecondaryStructureResidue_show(self, *args)

    @staticmethod
    def setup_particle(*args):
        r"""
        setup_particle(Model m, ParticleIndex pi, IMP::Float prob_helix, IMP::Float prob_strand, IMP::Float prob_coil) -> SecondaryStructureResidue
        setup_particle(_ParticleAdaptor decorator, IMP::Float prob_helix, IMP::Float prob_strand, IMP::Float prob_coil) -> SecondaryStructureResidue
        setup_particle(Particle res_p) -> SecondaryStructureResidue
        """
        return _IMP_atom.SecondaryStructureResidue_setup_particle(*args)

    @staticmethod
    def get_is_setup(*args):
        r"""
        get_is_setup(_ParticleAdaptor p) -> bool
        get_is_setup(Model m, ParticleIndex pi) -> bool
        """
        return _IMP_atom.SecondaryStructureResidue_get_is_setup(*args)

    def get_particle(self):
        r"""get_particle(SecondaryStructureResidue self) -> Particle"""
        return _IMP_atom.SecondaryStructureResidue_get_particle(self)

    def get_all_probabilities(self):
        r"""get_all_probabilities(SecondaryStructureResidue self) -> IMP::Floats"""
        return _IMP_atom.SecondaryStructureResidue_get_all_probabilities(self)

    def get_prob_helix(self):
        r"""get_prob_helix(SecondaryStructureResidue self) -> IMP::Float"""
        return _IMP_atom.SecondaryStructureResidue_get_prob_helix(self)

    def set_prob_helix(self, t):
        r"""set_prob_helix(SecondaryStructureResidue self, IMP::Float t)"""
        return _IMP_atom.SecondaryStructureResidue_set_prob_helix(self, t)

    def get_prob_strand(self):
        r"""get_prob_strand(SecondaryStructureResidue self) -> IMP::Float"""
        return _IMP_atom.SecondaryStructureResidue_get_prob_strand(self)

    def set_prob_strand(self, t):
        r"""set_prob_strand(SecondaryStructureResidue self, IMP::Float t)"""
        return _IMP_atom.SecondaryStructureResidue_set_prob_strand(self, t)

    def get_prob_coil(self):
        r"""get_prob_coil(SecondaryStructureResidue self) -> IMP::Float"""
        return _IMP_atom.SecondaryStructureResidue_get_prob_coil(self)

    def set_prob_coil(self, t):
        r"""set_prob_coil(SecondaryStructureResidue self, IMP::Float t)"""
        return _IMP_atom.SecondaryStructureResidue_set_prob_coil(self, t)

    @staticmethod
    def get_prob_helix_key():
        r"""get_prob_helix_key() -> FloatKey"""
        return _IMP_atom.SecondaryStructureResidue_get_prob_helix_key()

    @staticmethod
    def get_prob_strand_key():
        r"""get_prob_strand_key() -> FloatKey"""
        return _IMP_atom.SecondaryStructureResidue_get_prob_strand_key()

    @staticmethod
    def get_prob_coil_key():
        r"""get_prob_coil_key() -> FloatKey"""
        return _IMP_atom.SecondaryStructureResidue_get_prob_coil_key()

    def add_attribute(self, *args):
        r"""
        add_attribute(SecondaryStructureResidue self, FloatKey k, IMP::Float v, bool opt)
        add_attribute(SecondaryStructureResidue self, FloatKey a0, IMP::Float a1)
        add_attribute(SecondaryStructureResidue self, IntKey a0, IMP::Int a1)
        add_attribute(SecondaryStructureResidue self, FloatsKey a0, IMP::Floats a1)
        add_attribute(SecondaryStructureResidue self, IntsKey a0, IMP::Ints a1)
        add_attribute(SecondaryStructureResidue self, StringKey a0, IMP::String a1)
        add_attribute(SecondaryStructureResidue self, ParticleIndexKey a0, Particle a1)
        add_attribute(SecondaryStructureResidue self, ObjectKey a0, Object a1)
        """
        return _IMP_atom.SecondaryStructureResidue_add_attribute(self, *args)

    def get_value(self, *args):
        r"""
        get_value(SecondaryStructureResidue self, FloatKey a0) -> IMP::Float
        get_value(SecondaryStructureResidue self, IntKey a0) -> IMP::Int
        get_value(SecondaryStructureResidue self, FloatsKey a0) -> IMP::Floats
        get_value(SecondaryStructureResidue self, IntsKey a0) -> IMP::Ints
        get_value(SecondaryStructureResidue self, StringKey a0) -> IMP::String
        get_value(SecondaryStructureResidue self, ParticleIndexKey a0) -> Particle
        get_value(SecondaryStructureResidue self, ObjectKey a0) -> Object
        """
        return _IMP_atom.SecondaryStructureResidue_get_value(self, *args)

    def set_value(self, *args):
        r"""
        set_value(SecondaryStructureResidue self, FloatKey a0, IMP::Float a1)
        set_value(SecondaryStructureResidue self, IntKey a0, IMP::Int a1)
        set_value(SecondaryStructureResidue self, FloatsKey a0, IMP::Floats a1)
        set_value(SecondaryStructureResidue self, IntsKey a0, IMP::Ints a1)
        set_value(SecondaryStructureResidue self, StringKey a0, IMP::String a1)
        set_value(SecondaryStructureResidue self, ParticleIndexKey a0, Particle a1)
        set_value(SecondaryStructureResidue self, ObjectKey a0, Object a1)
        """
        return _IMP_atom.SecondaryStructureResidue_set_value(self, *args)

    def remove_attribute(self, *args):
        r"""
        remove_attribute(SecondaryStructureResidue self, FloatKey a0)
        remove_attribute(SecondaryStructureResidue self, IntKey a0)
        remove_attribute(SecondaryStructureResidue self, FloatsKey a0)
        remove_attribute(SecondaryStructureResidue self, IntsKey a0)
        remove_attribute(SecondaryStructureResidue self, StringKey a0)
        remove_attribute(SecondaryStructureResidue self, ParticleIndexKey a0)
        remove_attribute(SecondaryStructureResidue self, ObjectKey a0)
        """
        return _IMP_atom.SecondaryStructureResidue_remove_attribute(self, *args)

    def has_attribute(self, *args):
        r"""
        has_attribute(SecondaryStructureResidue self, FloatKey a0) -> bool
        has_attribute(SecondaryStructureResidue self, IntKey a0) -> bool
        has_attribute(SecondaryStructureResidue self, FloatsKey a0) -> bool
        has_attribute(SecondaryStructureResidue self, IntsKey a0) -> bool
        has_attribute(SecondaryStructureResidue self, StringKey a0) -> bool
        has_attribute(SecondaryStructureResidue self, ParticleIndexKey a0) -> bool
        has_attribute(SecondaryStructureResidue self, ObjectKey a0) -> bool
        """
        return _IMP_atom.SecondaryStructureResidue_has_attribute(self, *args)

    def get_derivative(self, a0):
        r"""get_derivative(SecondaryStructureResidue self, FloatKey a0) -> double"""
        return _IMP_atom.SecondaryStructureResidue_get_derivative(self, a0)

    def get_name(self):
        r"""get_name(SecondaryStructureResidue self) -> std::string"""
        return _IMP_atom.SecondaryStructureResidue_get_name(self)

    def clear_caches(self):
        r"""clear_caches(SecondaryStructureResidue self)"""
        return _IMP_atom.SecondaryStructureResidue_clear_caches(self)

    def set_name(self, a0):
        r"""set_name(SecondaryStructureResidue self, std::string a0)"""
        return _IMP_atom.SecondaryStructureResidue_set_name(self, a0)

    def set_check_level(self, a0):
        r"""set_check_level(SecondaryStructureResidue self, IMP::CheckLevel a0)"""
        return _IMP_atom.SecondaryStructureResidue_set_check_level(self, a0)

    def add_to_derivative(self, a0, a1, a2):
        r"""add_to_derivative(SecondaryStructureResidue self, FloatKey a0, double a1, DerivativeAccumulator a2)"""
        return _IMP_atom.SecondaryStructureResidue_add_to_derivative(self, a0, a1, a2)

    def set_is_optimized(self, a0, a1):
        r"""set_is_optimized(SecondaryStructureResidue self, FloatKey a0, bool a1)"""
        return _IMP_atom.SecondaryStructureResidue_set_is_optimized(self, a0, a1)

    def get_is_optimized(self, a0):
        r"""get_is_optimized(SecondaryStructureResidue self, FloatKey a0) -> bool"""
        return _IMP_atom.SecondaryStructureResidue_get_is_optimized(self, a0)

    def get_check_level(self):
        r"""get_check_level(SecondaryStructureResidue self) -> IMP::CheckLevel"""
        return _IMP_atom.SecondaryStructureResidue_get_check_level(self)

    def __eq__(self, *args):
        r"""
        __eq__(SecondaryStructureResidue self, SecondaryStructureResidue o) -> bool
        __eq__(SecondaryStructureResidue self, Particle d) -> bool
        """
        return _IMP_atom.SecondaryStructureResidue___eq__(self, *args)

    def __ne__(self, *args):
        r"""
        __ne__(SecondaryStructureResidue self, SecondaryStructureResidue o) -> bool
        __ne__(SecondaryStructureResidue self, Particle d) -> bool
        """
        return _IMP_atom.SecondaryStructureResidue___ne__(self, *args)

    def __le__(self, *args):
        r"""
        __le__(SecondaryStructureResidue self, SecondaryStructureResidue o) -> bool
        __le__(SecondaryStructureResidue self, Particle d) -> bool
        """
        return _IMP_atom.SecondaryStructureResidue___le__(self, *args)

    def __lt__(self, *args):
        r"""
        __lt__(SecondaryStructureResidue self, SecondaryStructureResidue o) -> bool
        __lt__(SecondaryStructureResidue self, Particle d) -> bool
        """
        return _IMP_atom.SecondaryStructureResidue___lt__(self, *args)

    def __ge__(self, *args):
        r"""
        __ge__(SecondaryStructureResidue self, SecondaryStructureResidue o) -> bool
        __ge__(SecondaryStructureResidue self, Particle d) -> bool
        """
        return _IMP_atom.SecondaryStructureResidue___ge__(self, *args)

    def __gt__(self, *args):
        r"""
        __gt__(SecondaryStructureResidue self, SecondaryStructureResidue o) -> bool
        __gt__(SecondaryStructureResidue self, Particle d) -> bool
        """
        return _IMP_atom.SecondaryStructureResidue___gt__(self, *args)

    def __hash__(self):
        r"""__hash__(SecondaryStructureResidue self) -> std::size_t"""
        return _IMP_atom.SecondaryStructureResidue___hash__(self)

    def __str__(self):
        r"""__str__(SecondaryStructureResidue self) -> std::string"""
        return _IMP_atom.SecondaryStructureResidue___str__(self)

    def __repr__(self):
        r"""__repr__(SecondaryStructureResidue self) -> std::string"""
        return _IMP_atom.SecondaryStructureResidue___repr__(self)
    __swig_destroy__ = _IMP_atom.delete_SecondaryStructureResidue

# Register SecondaryStructureResidue in _IMP_atom:
_IMP_atom.SecondaryStructureResidue_swigregister(SecondaryStructureResidue)

def SecondaryStructureResidue_setup_particle(*args):
    r"""
    SecondaryStructureResidue_setup_particle(Model m, ParticleIndex pi, IMP::Float prob_helix, IMP::Float prob_strand, IMP::Float prob_coil) -> SecondaryStructureResidue
    SecondaryStructureResidue_setup_particle(_ParticleAdaptor decorator, IMP::Float prob_helix, IMP::Float prob_strand, IMP::Float prob_coil) -> SecondaryStructureResidue
    SecondaryStructureResidue_setup_particle(Particle res_p) -> SecondaryStructureResidue
    """
    return _IMP_atom.SecondaryStructureResidue_setup_particle(*args)

def SecondaryStructureResidue_get_is_setup(*args):
    r"""
    SecondaryStructureResidue_get_is_setup(_ParticleAdaptor p) -> bool
    SecondaryStructureResidue_get_is_setup(Model m, ParticleIndex pi) -> bool
    """
    return _IMP_atom.SecondaryStructureResidue_get_is_setup(*args)

def SecondaryStructureResidue_get_prob_helix_key():
    r"""SecondaryStructureResidue_get_prob_helix_key() -> FloatKey"""
    return _IMP_atom.SecondaryStructureResidue_get_prob_helix_key()

def SecondaryStructureResidue_get_prob_strand_key():
    r"""SecondaryStructureResidue_get_prob_strand_key() -> FloatKey"""
    return _IMP_atom.SecondaryStructureResidue_get_prob_strand_key()

def SecondaryStructureResidue_get_prob_coil_key():
    r"""SecondaryStructureResidue_get_prob_coil_key() -> FloatKey"""
    return _IMP_atom.SecondaryStructureResidue_get_prob_coil_key()


def setup_coarse_secondary_structure_residue(ssr_ps, mdl, winner_takes_all_per_res=False):
    r"""setup_coarse_secondary_structure_residue(IMP::Particles const & ssr_ps, Model mdl, bool winner_takes_all_per_res=False) -> SecondaryStructureResidue"""
    return _IMP_atom.setup_coarse_secondary_structure_residue(ssr_ps, mdl, winner_takes_all_per_res)

def setup_coarse_secondary_structure_residues(ssr_ps, mdl, coarse_factor, start_res_num, winner_takes_all_per_res=False):
    r"""setup_coarse_secondary_structure_residues(IMP::Particles const & ssr_ps, Model mdl, int coarse_factor, int start_res_num, bool winner_takes_all_per_res=False) -> IMP::atom::SecondaryStructureResidues"""
    return _IMP_atom.setup_coarse_secondary_structure_residues(ssr_ps, mdl, coarse_factor, start_res_num, winner_takes_all_per_res)

def get_secondary_structure_match_score(ssr1, ssr2):
    r"""get_secondary_structure_match_score(SecondaryStructureResidue ssr1, SecondaryStructureResidue ssr2) -> IMP::Float"""
    return _IMP_atom.get_secondary_structure_match_score(ssr1, ssr2)

def read_psipred(*args):
    r"""
    read_psipred(TextInput inf, Model mdl) -> IMP::atom::SecondaryStructureResidues
    read_psipred(TextInput inf, IMP::Particles ps) -> IMP::atom::SecondaryStructureResidues
    """
    return _IMP_atom.read_psipred(*args)
class _ADopeBase(IMP.PairScore):
    r"""Proxy of C++ IMP::score_functor::DistancePairScore< IMP::score_functor::Dope > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(_ADopeBase self, Dope t0, std::string name="FunctorDistancePairScore %1%") -> _ADopeBase"""
        _IMP_atom._ADopeBase_swiginit(self, _IMP_atom.new__ADopeBase(*args))

    def do_get_inputs(self, m, pis):
        r"""do_get_inputs(_ADopeBase self, Model m, IMP::ParticleIndexes const & pis) -> IMP::ModelObjectsTemp"""
        return _IMP_atom._ADopeBase_do_get_inputs(self, m, pis)

    def get_score_functor(self):
        r"""get_score_functor(_ADopeBase self) -> Dope"""
        return _IMP_atom._ADopeBase_get_score_functor(self)

    def get_version_info(self):
        r"""get_version_info(_ADopeBase self) -> VersionInfo"""
        return _IMP_atom._ADopeBase_get_version_info(self)

# Register _ADopeBase in _IMP_atom:
_IMP_atom._ADopeBase_swigregister(_ADopeBase)

class _BDopeBase(IMP.PairScore):
    r"""Proxy of C++ IMP::score_functor::DistancePairScore< IMP::score_functor::Statistical< IMP::atom::DopeType,false,true,false > > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(_BDopeBase self, IMP::score_functor::DistancePairScore< IMP::score_functor::Statistical< IMP::atom::DopeType,false,true,false > >::DistanceScore const & t0, std::string name="FunctorDistancePairScore %1%") -> _BDopeBase"""
        _IMP_atom._BDopeBase_swiginit(self, _IMP_atom.new__BDopeBase(*args))

    def do_get_inputs(self, m, pis):
        r"""do_get_inputs(_BDopeBase self, Model m, IMP::ParticleIndexes const & pis) -> IMP::ModelObjectsTemp"""
        return _IMP_atom._BDopeBase_do_get_inputs(self, m, pis)

    def get_score_functor(self):
        r"""get_score_functor(_BDopeBase self) -> _DopeBase"""
        return _IMP_atom._BDopeBase_get_score_functor(self)

    def get_version_info(self):
        r"""get_version_info(_BDopeBase self) -> VersionInfo"""
        return _IMP_atom._BDopeBase_get_version_info(self)

# Register _BDopeBase in _IMP_atom:
_IMP_atom._BDopeBase_swigregister(_BDopeBase)

class _ALoopStatisticalBase(IMP.PairScore):
    r"""Proxy of C++ IMP::score_functor::DistancePairScore< IMP::score_functor::LoopStatistical > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(_ALoopStatisticalBase self, LoopStatistical t0, std::string name="FunctorDistancePairScore %1%") -> _ALoopStatisticalBase"""
        _IMP_atom._ALoopStatisticalBase_swiginit(self, _IMP_atom.new__ALoopStatisticalBase(*args))

    def do_get_inputs(self, m, pis):
        r"""do_get_inputs(_ALoopStatisticalBase self, Model m, IMP::ParticleIndexes const & pis) -> IMP::ModelObjectsTemp"""
        return _IMP_atom._ALoopStatisticalBase_do_get_inputs(self, m, pis)

    def get_score_functor(self):
        r"""get_score_functor(_ALoopStatisticalBase self) -> LoopStatistical"""
        return _IMP_atom._ALoopStatisticalBase_get_score_functor(self)

    def get_version_info(self):
        r"""get_version_info(_ALoopStatisticalBase self) -> VersionInfo"""
        return _IMP_atom._ALoopStatisticalBase_get_version_info(self)

# Register _ALoopStatisticalBase in _IMP_atom:
_IMP_atom._ALoopStatisticalBase_swigregister(_ALoopStatisticalBase)

class _BLoopStatisticalBase(IMP.PairScore):
    r"""Proxy of C++ IMP::score_functor::DistancePairScore< IMP::score_functor::Statistical< IMP::atom::LoopStatisticalType,false,true,false > > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(_BLoopStatisticalBase self, IMP::score_functor::DistancePairScore< IMP::score_functor::Statistical< IMP::atom::LoopStatisticalType,false,true,false > >::DistanceScore const & t0, std::string name="FunctorDistancePairScore %1%") -> _BLoopStatisticalBase"""
        _IMP_atom._BLoopStatisticalBase_swiginit(self, _IMP_atom.new__BLoopStatisticalBase(*args))

    def do_get_inputs(self, m, pis):
        r"""do_get_inputs(_BLoopStatisticalBase self, Model m, IMP::ParticleIndexes const & pis) -> IMP::ModelObjectsTemp"""
        return _IMP_atom._BLoopStatisticalBase_do_get_inputs(self, m, pis)

    def get_score_functor(self):
        r"""get_score_functor(_BLoopStatisticalBase self) -> _LoopStatisticalBase"""
        return _IMP_atom._BLoopStatisticalBase_get_score_functor(self)

    def get_version_info(self):
        r"""get_version_info(_BLoopStatisticalBase self) -> VersionInfo"""
        return _IMP_atom._BLoopStatisticalBase_get_version_info(self)

# Register _BLoopStatisticalBase in _IMP_atom:
_IMP_atom._BLoopStatisticalBase_swigregister(_BLoopStatisticalBase)

class _OrientedSoapBase(IMP.PairScore):
    r"""Proxy of C++ IMP::score_functor::DistancePairScore< IMP::score_functor::OrientedSoap > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(_OrientedSoapBase self, IMP::score_functor::DistancePairScore< IMP::score_functor::OrientedSoap >::DistanceScore const & t0, std::string name="FunctorDistancePairScore %1%") -> _OrientedSoapBase"""
        _IMP_atom._OrientedSoapBase_swiginit(self, _IMP_atom.new__OrientedSoapBase(*args))

    def do_get_inputs(self, m, pis):
        r"""do_get_inputs(_OrientedSoapBase self, Model m, IMP::ParticleIndexes const & pis) -> IMP::ModelObjectsTemp"""
        return _IMP_atom._OrientedSoapBase_do_get_inputs(self, m, pis)

    def get_score_functor(self):
        r"""get_score_functor(_OrientedSoapBase self) -> IMP::score_functor::OrientedSoap &"""
        return _IMP_atom._OrientedSoapBase_get_score_functor(self)

    def get_version_info(self):
        r"""get_version_info(_OrientedSoapBase self) -> VersionInfo"""
        return _IMP_atom._OrientedSoapBase_get_version_info(self)

# Register _OrientedSoapBase in _IMP_atom:
_IMP_atom._OrientedSoapBase_swigregister(_OrientedSoapBase)

class _SPSFTB(IMP.PairScore):
    r"""Proxy of C++ IMP::score_functor::DistancePairScore< IMP::score_functor::Statistical< IMP::atom::ProteinLigandType,true,false > > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""__init__(_SPSFTB self, IMP::score_functor::DistancePairScore< IMP::score_functor::Statistical< IMP::atom::ProteinLigandType,true,false > >::DistanceScore const & t0, std::string name="FunctorDistancePairScore %1%") -> _SPSFTB"""
        _IMP_atom._SPSFTB_swiginit(self, _IMP_atom.new__SPSFTB(*args))

    def do_get_inputs(self, m, pis):
        r"""do_get_inputs(_SPSFTB self, Model m, IMP::ParticleIndexes const & pis) -> IMP::ModelObjectsTemp"""
        return _IMP_atom._SPSFTB_do_get_inputs(self, m, pis)

    def get_score_functor(self):
        r"""get_score_functor(_SPSFTB self) -> IMP::score_functor::Statistical< IMP::atom::ProteinLigandType,true,false,false > &"""
        return _IMP_atom._SPSFTB_get_score_functor(self)

    def get_version_info(self):
        r"""get_version_info(_SPSFTB self) -> VersionInfo"""
        return _IMP_atom._SPSFTB_get_version_info(self)

# Register _SPSFTB in _IMP_atom:
_IMP_atom._SPSFTB_swigregister(_SPSFTB)

class _SPSTF(_SPSFTB):
    r"""Proxy of C++ IMP::core::StatisticalPairScore< IMP::atom::ProteinLigandType,true,false > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(_SPSTF self, IntKey k, double threshold, TextInput data_file) -> _SPSTF
        __init__(_SPSTF self, IntKey k, double threshold, TextInput data_file, unsigned int shift) -> _SPSTF
        """
        _IMP_atom._SPSTF_swiginit(self, _IMP_atom.new__SPSTF(*args))
    __swig_destroy__ = _IMP_atom.delete__SPSTF

# Register _SPSTF in _IMP_atom:
_IMP_atom._SPSTF_swigregister(_SPSTF)

class _SPSFT(_BDopeBase):
    r"""Proxy of C++ IMP::core::StatisticalPairScore< IMP::atom::DopeType,false,true > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(_SPSFT self, IntKey k, double threshold, TextInput data_file) -> _SPSFT
        __init__(_SPSFT self, IntKey k, double threshold, TextInput data_file, unsigned int shift) -> _SPSFT
        """
        _IMP_atom._SPSFT_swiginit(self, _IMP_atom.new__SPSFT(*args))
    __swig_destroy__ = _IMP_atom.delete__SPSFT

# Register _SPSFT in _IMP_atom:
_IMP_atom._SPSFT_swigregister(_SPSFT)

class _SPSFTL(_BLoopStatisticalBase):
    r"""Proxy of C++ IMP::core::StatisticalPairScore< IMP::atom::LoopStatisticalType,false,true > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        __init__(_SPSFTL self, IntKey k, double threshold, TextInput data_file) -> _SPSFTL
        __init__(_SPSFTL self, IntKey k, double threshold, TextInput data_file, unsigned int shift) -> _SPSFTL
        """
        _IMP_atom._SPSFTL_swiginit(self, _IMP_atom.new__SPSFTL(*args))
    __swig_destroy__ = _IMP_atom.delete__SPSFTL

# Register _SPSFTL in _IMP_atom:
_IMP_atom._SPSFTL_swigregister(_SPSFTL)

class ProteinLigandAtomPairScore(_SPSTF):
    r"""Proxy of C++ IMP::atom::ProteinLigandAtomPairScore class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(ProteinLigandAtomPairScore self, double threshold=std::numeric_limits< double >::max()) -> ProteinLigandAtomPairScore
        __init__(ProteinLigandAtomPairScore self, double threshold, TextInput data_file) -> ProteinLigandAtomPairScore
        """
        _IMP_atom.ProteinLigandAtomPairScore_swiginit(self, _IMP_atom.new_ProteinLigandAtomPairScore(*args))

    def get_maximum_distance(self):
        r"""get_maximum_distance(ProteinLigandAtomPairScore self) -> double"""
        return _IMP_atom.ProteinLigandAtomPairScore_get_maximum_distance(self)

    def __str__(self):
        r"""__str__(ProteinLigandAtomPairScore self) -> std::string"""
        return _IMP_atom.ProteinLigandAtomPairScore___str__(self)

    def __repr__(self):
        r"""__repr__(ProteinLigandAtomPairScore self) -> std::string"""
        return _IMP_atom.ProteinLigandAtomPairScore___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_ProteinLigandAtomPairScore(o)

    __swig_destroy__ = _IMP_atom.delete_ProteinLigandAtomPairScore

# Register ProteinLigandAtomPairScore in _IMP_atom:
_IMP_atom.ProteinLigandAtomPairScore_swigregister(ProteinLigandAtomPairScore)

class ProteinLigandRestraint(IMP.container.PairsRestraint):
    r"""Proxy of C++ IMP::atom::ProteinLigandRestraint class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(ProteinLigandRestraint self, Hierarchy protein, Hierarchy ligand, double threshold=std::numeric_limits< double >::max()) -> ProteinLigandRestraint
        __init__(ProteinLigandRestraint self, Hierarchy protein, Hierarchy ligand, double threshold, TextInput data_file) -> ProteinLigandRestraint
        """
        _IMP_atom.ProteinLigandRestraint_swiginit(self, _IMP_atom.new_ProteinLigandRestraint(*args))

    def __str__(self):
        r"""__str__(ProteinLigandRestraint self) -> std::string"""
        return _IMP_atom.ProteinLigandRestraint___str__(self)

    def __repr__(self):
        r"""__repr__(ProteinLigandRestraint self) -> std::string"""
        return _IMP_atom.ProteinLigandRestraint___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_ProteinLigandRestraint(o)

    __swig_destroy__ = _IMP_atom.delete_ProteinLigandRestraint

# Register ProteinLigandRestraint in _IMP_atom:
_IMP_atom.ProteinLigandRestraint_swigregister(ProteinLigandRestraint)


def add_protein_ligand_score_data(h):
    r"""add_protein_ligand_score_data(Hierarchy h)"""
    return _IMP_atom.add_protein_ligand_score_data(h)
class AtomType(IMP._Value):
    r"""Proxy of C++ IMP::Key< 8974343 > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(AtomType self) -> AtomType
        __init__(AtomType self, std::string const & c, bool is_implicit_add_permitted=True) -> AtomType
        __init__(AtomType self, unsigned int i) -> AtomType
        """
        _IMP_atom.AtomType_swiginit(self, _IMP_atom.new_AtomType(*args))

    @staticmethod
    def add_key(sc):
        r"""add_key(std::string sc) -> unsigned int"""
        return _IMP_atom.AtomType_add_key(sc)

    @staticmethod
    def get_key_exists(sc):
        r"""get_key_exists(std::string sc) -> bool"""
        return _IMP_atom.AtomType_get_key_exists(sc)

    def get_string(self):
        r"""get_string(AtomType self) -> std::string const"""
        return _IMP_atom.AtomType_get_string(self)

    def __cmp__(self, o):
        r"""__cmp__(AtomType self, AtomType o) -> int"""
        return _IMP_atom.AtomType___cmp__(self, o)

    def __eq__(self, o):
        r"""__eq__(AtomType self, AtomType o) -> bool"""
        return _IMP_atom.AtomType___eq__(self, o)

    def __ne__(self, o):
        r"""__ne__(AtomType self, AtomType o) -> bool"""
        return _IMP_atom.AtomType___ne__(self, o)

    def __lt__(self, o):
        r"""__lt__(AtomType self, AtomType o) -> bool"""
        return _IMP_atom.AtomType___lt__(self, o)

    def __gt__(self, o):
        r"""__gt__(AtomType self, AtomType o) -> bool"""
        return _IMP_atom.AtomType___gt__(self, o)

    def __ge__(self, o):
        r"""__ge__(AtomType self, AtomType o) -> bool"""
        return _IMP_atom.AtomType___ge__(self, o)

    def __le__(self, o):
        r"""__le__(AtomType self, AtomType o) -> bool"""
        return _IMP_atom.AtomType___le__(self, o)

    def __hash__(self):
        r"""__hash__(AtomType self) -> std::size_t"""
        return _IMP_atom.AtomType___hash__(self)

    def show(self, *args):
        r"""show(AtomType self, _ostream out=std::cout)"""
        return _IMP_atom.AtomType_show(self, *args)

    @staticmethod
    def add_alias(old_key, new_name):
        r"""add_alias(AtomType old_key, std::string new_name) -> AtomType"""
        return _IMP_atom.AtomType_add_alias(old_key, new_name)

    @staticmethod
    def get_number_of_keys():
        r"""get_number_of_keys() -> unsigned int"""
        return _IMP_atom.AtomType_get_number_of_keys()

    def get_index(self):
        r"""get_index(AtomType self) -> unsigned int"""
        return _IMP_atom.AtomType_get_index(self)

    @staticmethod
    def show_all(out):
        r"""show_all(_ostream out)"""
        return _IMP_atom.AtomType_show_all(out)

    @staticmethod
    def get_all_strings():
        r"""get_all_strings() -> IMP::Vector< std::string >"""
        return _IMP_atom.AtomType_get_all_strings()

    @staticmethod
    def get_number_unique():
        r"""get_number_unique() -> unsigned int"""
        return _IMP_atom.AtomType_get_number_unique()

    def __str__(self):
        r"""__str__(AtomType self) -> std::string"""
        return _IMP_atom.AtomType___str__(self)

    def __repr__(self):
        r"""__repr__(AtomType self) -> std::string"""
        return _IMP_atom.AtomType___repr__(self)
    __swig_destroy__ = _IMP_atom.delete_AtomType

# Register AtomType in _IMP_atom:
_IMP_atom.AtomType_swigregister(AtomType)

def AtomType_add_key(sc):
    r"""AtomType_add_key(std::string sc) -> unsigned int"""
    return _IMP_atom.AtomType_add_key(sc)

def AtomType_get_key_exists(sc):
    r"""AtomType_get_key_exists(std::string sc) -> bool"""
    return _IMP_atom.AtomType_get_key_exists(sc)

def AtomType_add_alias(old_key, new_name):
    r"""AtomType_add_alias(AtomType old_key, std::string new_name) -> AtomType"""
    return _IMP_atom.AtomType_add_alias(old_key, new_name)

def AtomType_get_number_of_keys():
    r"""AtomType_get_number_of_keys() -> unsigned int"""
    return _IMP_atom.AtomType_get_number_of_keys()

def AtomType_show_all(out):
    r"""AtomType_show_all(_ostream out)"""
    return _IMP_atom.AtomType_show_all(out)

def AtomType_get_all_strings():
    r"""AtomType_get_all_strings() -> IMP::Vector< std::string >"""
    return _IMP_atom.AtomType_get_all_strings()

def AtomType_get_number_unique():
    r"""AtomType_get_number_unique() -> unsigned int"""
    return _IMP_atom.AtomType_get_number_unique()

class ResidueType(IMP._Value):
    r"""Proxy of C++ IMP::Key< 90784334 > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(ResidueType self) -> ResidueType
        __init__(ResidueType self, std::string const & c, bool is_implicit_add_permitted=True) -> ResidueType
        __init__(ResidueType self, unsigned int i) -> ResidueType
        """
        _IMP_atom.ResidueType_swiginit(self, _IMP_atom.new_ResidueType(*args))

    @staticmethod
    def add_key(sc):
        r"""add_key(std::string sc) -> unsigned int"""
        return _IMP_atom.ResidueType_add_key(sc)

    @staticmethod
    def get_key_exists(sc):
        r"""get_key_exists(std::string sc) -> bool"""
        return _IMP_atom.ResidueType_get_key_exists(sc)

    def get_string(self):
        r"""get_string(ResidueType self) -> std::string const"""
        return _IMP_atom.ResidueType_get_string(self)

    def __cmp__(self, o):
        r"""__cmp__(ResidueType self, ResidueType o) -> int"""
        return _IMP_atom.ResidueType___cmp__(self, o)

    def __eq__(self, o):
        r"""__eq__(ResidueType self, ResidueType o) -> bool"""
        return _IMP_atom.ResidueType___eq__(self, o)

    def __ne__(self, o):
        r"""__ne__(ResidueType self, ResidueType o) -> bool"""
        return _IMP_atom.ResidueType___ne__(self, o)

    def __lt__(self, o):
        r"""__lt__(ResidueType self, ResidueType o) -> bool"""
        return _IMP_atom.ResidueType___lt__(self, o)

    def __gt__(self, o):
        r"""__gt__(ResidueType self, ResidueType o) -> bool"""
        return _IMP_atom.ResidueType___gt__(self, o)

    def __ge__(self, o):
        r"""__ge__(ResidueType self, ResidueType o) -> bool"""
        return _IMP_atom.ResidueType___ge__(self, o)

    def __le__(self, o):
        r"""__le__(ResidueType self, ResidueType o) -> bool"""
        return _IMP_atom.ResidueType___le__(self, o)

    def __hash__(self):
        r"""__hash__(ResidueType self) -> std::size_t"""
        return _IMP_atom.ResidueType___hash__(self)

    def show(self, *args):
        r"""show(ResidueType self, _ostream out=std::cout)"""
        return _IMP_atom.ResidueType_show(self, *args)

    @staticmethod
    def add_alias(old_key, new_name):
        r"""add_alias(ResidueType old_key, std::string new_name) -> ResidueType"""
        return _IMP_atom.ResidueType_add_alias(old_key, new_name)

    @staticmethod
    def get_number_of_keys():
        r"""get_number_of_keys() -> unsigned int"""
        return _IMP_atom.ResidueType_get_number_of_keys()

    def get_index(self):
        r"""get_index(ResidueType self) -> unsigned int"""
        return _IMP_atom.ResidueType_get_index(self)

    @staticmethod
    def show_all(out):
        r"""show_all(_ostream out)"""
        return _IMP_atom.ResidueType_show_all(out)

    @staticmethod
    def get_all_strings():
        r"""get_all_strings() -> IMP::Vector< std::string >"""
        return _IMP_atom.ResidueType_get_all_strings()

    @staticmethod
    def get_number_unique():
        r"""get_number_unique() -> unsigned int"""
        return _IMP_atom.ResidueType_get_number_unique()

    def __str__(self):
        r"""__str__(ResidueType self) -> std::string"""
        return _IMP_atom.ResidueType___str__(self)

    def __repr__(self):
        r"""__repr__(ResidueType self) -> std::string"""
        return _IMP_atom.ResidueType___repr__(self)
    __swig_destroy__ = _IMP_atom.delete_ResidueType

# Register ResidueType in _IMP_atom:
_IMP_atom.ResidueType_swigregister(ResidueType)

def ResidueType_add_key(sc):
    r"""ResidueType_add_key(std::string sc) -> unsigned int"""
    return _IMP_atom.ResidueType_add_key(sc)

def ResidueType_get_key_exists(sc):
    r"""ResidueType_get_key_exists(std::string sc) -> bool"""
    return _IMP_atom.ResidueType_get_key_exists(sc)

def ResidueType_add_alias(old_key, new_name):
    r"""ResidueType_add_alias(ResidueType old_key, std::string new_name) -> ResidueType"""
    return _IMP_atom.ResidueType_add_alias(old_key, new_name)

def ResidueType_get_number_of_keys():
    r"""ResidueType_get_number_of_keys() -> unsigned int"""
    return _IMP_atom.ResidueType_get_number_of_keys()

def ResidueType_show_all(out):
    r"""ResidueType_show_all(_ostream out)"""
    return _IMP_atom.ResidueType_show_all(out)

def ResidueType_get_all_strings():
    r"""ResidueType_get_all_strings() -> IMP::Vector< std::string >"""
    return _IMP_atom.ResidueType_get_all_strings()

def ResidueType_get_number_unique():
    r"""ResidueType_get_number_unique() -> unsigned int"""
    return _IMP_atom.ResidueType_get_number_unique()

class ChainType(IMP._Value):
    r"""Proxy of C++ IMP::Key< 90784336 > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(ChainType self) -> ChainType
        __init__(ChainType self, std::string const & c, bool is_implicit_add_permitted=True) -> ChainType
        __init__(ChainType self, unsigned int i) -> ChainType
        """
        _IMP_atom.ChainType_swiginit(self, _IMP_atom.new_ChainType(*args))

    @staticmethod
    def add_key(sc):
        r"""add_key(std::string sc) -> unsigned int"""
        return _IMP_atom.ChainType_add_key(sc)

    @staticmethod
    def get_key_exists(sc):
        r"""get_key_exists(std::string sc) -> bool"""
        return _IMP_atom.ChainType_get_key_exists(sc)

    def get_string(self):
        r"""get_string(ChainType self) -> std::string const"""
        return _IMP_atom.ChainType_get_string(self)

    def __cmp__(self, o):
        r"""__cmp__(ChainType self, ChainType o) -> int"""
        return _IMP_atom.ChainType___cmp__(self, o)

    def __eq__(self, o):
        r"""__eq__(ChainType self, ChainType o) -> bool"""
        return _IMP_atom.ChainType___eq__(self, o)

    def __ne__(self, o):
        r"""__ne__(ChainType self, ChainType o) -> bool"""
        return _IMP_atom.ChainType___ne__(self, o)

    def __lt__(self, o):
        r"""__lt__(ChainType self, ChainType o) -> bool"""
        return _IMP_atom.ChainType___lt__(self, o)

    def __gt__(self, o):
        r"""__gt__(ChainType self, ChainType o) -> bool"""
        return _IMP_atom.ChainType___gt__(self, o)

    def __ge__(self, o):
        r"""__ge__(ChainType self, ChainType o) -> bool"""
        return _IMP_atom.ChainType___ge__(self, o)

    def __le__(self, o):
        r"""__le__(ChainType self, ChainType o) -> bool"""
        return _IMP_atom.ChainType___le__(self, o)

    def __hash__(self):
        r"""__hash__(ChainType self) -> std::size_t"""
        return _IMP_atom.ChainType___hash__(self)

    def show(self, *args):
        r"""show(ChainType self, _ostream out=std::cout)"""
        return _IMP_atom.ChainType_show(self, *args)

    @staticmethod
    def add_alias(old_key, new_name):
        r"""add_alias(ChainType old_key, std::string new_name) -> ChainType"""
        return _IMP_atom.ChainType_add_alias(old_key, new_name)

    @staticmethod
    def get_number_of_keys():
        r"""get_number_of_keys() -> unsigned int"""
        return _IMP_atom.ChainType_get_number_of_keys()

    def get_index(self):
        r"""get_index(ChainType self) -> unsigned int"""
        return _IMP_atom.ChainType_get_index(self)

    @staticmethod
    def show_all(out):
        r"""show_all(_ostream out)"""
        return _IMP_atom.ChainType_show_all(out)

    @staticmethod
    def get_all_strings():
        r"""get_all_strings() -> IMP::Vector< std::string >"""
        return _IMP_atom.ChainType_get_all_strings()

    @staticmethod
    def get_number_unique():
        r"""get_number_unique() -> unsigned int"""
        return _IMP_atom.ChainType_get_number_unique()

    def __str__(self):
        r"""__str__(ChainType self) -> std::string"""
        return _IMP_atom.ChainType___str__(self)

    def __repr__(self):
        r"""__repr__(ChainType self) -> std::string"""
        return _IMP_atom.ChainType___repr__(self)
    __swig_destroy__ = _IMP_atom.delete_ChainType

# Register ChainType in _IMP_atom:
_IMP_atom.ChainType_swigregister(ChainType)

def ChainType_add_key(sc):
    r"""ChainType_add_key(std::string sc) -> unsigned int"""
    return _IMP_atom.ChainType_add_key(sc)

def ChainType_get_key_exists(sc):
    r"""ChainType_get_key_exists(std::string sc) -> bool"""
    return _IMP_atom.ChainType_get_key_exists(sc)

def ChainType_add_alias(old_key, new_name):
    r"""ChainType_add_alias(ChainType old_key, std::string new_name) -> ChainType"""
    return _IMP_atom.ChainType_add_alias(old_key, new_name)

def ChainType_get_number_of_keys():
    r"""ChainType_get_number_of_keys() -> unsigned int"""
    return _IMP_atom.ChainType_get_number_of_keys()

def ChainType_show_all(out):
    r"""ChainType_show_all(_ostream out)"""
    return _IMP_atom.ChainType_show_all(out)

def ChainType_get_all_strings():
    r"""ChainType_get_all_strings() -> IMP::Vector< std::string >"""
    return _IMP_atom.ChainType_get_all_strings()

def ChainType_get_number_unique():
    r"""ChainType_get_number_unique() -> unsigned int"""
    return _IMP_atom.ChainType_get_number_unique()

UNKNOWN_ELEMENT = _IMP_atom.UNKNOWN_ELEMENT

OH = _IMP_atom.OH

H2O = _IMP_atom.H2O

H = _IMP_atom.H

He = _IMP_atom.He

Li = _IMP_atom.Li

Be = _IMP_atom.Be

B = _IMP_atom.B

C = _IMP_atom.C

N = _IMP_atom.N

O = _IMP_atom.O

F = _IMP_atom.F

Ne = _IMP_atom.Ne

Na = _IMP_atom.Na

Mg = _IMP_atom.Mg

Al = _IMP_atom.Al

Si = _IMP_atom.Si

P = _IMP_atom.P

S = _IMP_atom.S

Cl = _IMP_atom.Cl

Ar = _IMP_atom.Ar

K = _IMP_atom.K

Ca = _IMP_atom.Ca

Sc = _IMP_atom.Sc

Ti = _IMP_atom.Ti

V = _IMP_atom.V

Cr = _IMP_atom.Cr

Mn = _IMP_atom.Mn

Fe = _IMP_atom.Fe

Co = _IMP_atom.Co

Ni = _IMP_atom.Ni

Cu = _IMP_atom.Cu

Zn = _IMP_atom.Zn

Ga = _IMP_atom.Ga

Ge = _IMP_atom.Ge

As = _IMP_atom.As

Se = _IMP_atom.Se

Br = _IMP_atom.Br

Kr = _IMP_atom.Kr

Rb = _IMP_atom.Rb

Sr = _IMP_atom.Sr

Y = _IMP_atom.Y

Zr = _IMP_atom.Zr

Nb = _IMP_atom.Nb

Mo = _IMP_atom.Mo

Tc = _IMP_atom.Tc

Ru = _IMP_atom.Ru

Rh = _IMP_atom.Rh

Pd = _IMP_atom.Pd

Ag = _IMP_atom.Ag

Cd = _IMP_atom.Cd

In = _IMP_atom.In

Sn = _IMP_atom.Sn

Sb = _IMP_atom.Sb

Te = _IMP_atom.Te

I = _IMP_atom.I

Xe = _IMP_atom.Xe

Cs = _IMP_atom.Cs

Ba = _IMP_atom.Ba

La = _IMP_atom.La

Ce = _IMP_atom.Ce

Pr = _IMP_atom.Pr

Nd = _IMP_atom.Nd

Pm = _IMP_atom.Pm

Sm = _IMP_atom.Sm

Eu = _IMP_atom.Eu

Gd = _IMP_atom.Gd

Tb = _IMP_atom.Tb

Dy = _IMP_atom.Dy

Ho = _IMP_atom.Ho

Er = _IMP_atom.Er

Tm = _IMP_atom.Tm

Yb = _IMP_atom.Yb

Lu = _IMP_atom.Lu

Hf = _IMP_atom.Hf

Ta = _IMP_atom.Ta

W = _IMP_atom.W

Re = _IMP_atom.Re

Os = _IMP_atom.Os

Ir = _IMP_atom.Ir

Pt = _IMP_atom.Pt

Au = _IMP_atom.Au

Hg = _IMP_atom.Hg

Tl = _IMP_atom.Tl

Pb = _IMP_atom.Pb

Bi = _IMP_atom.Bi

Po = _IMP_atom.Po

At = _IMP_atom.At

Rn = _IMP_atom.Rn

Fr = _IMP_atom.Fr

Ra = _IMP_atom.Ra

Ac = _IMP_atom.Ac

Th = _IMP_atom.Th

Pa = _IMP_atom.Pa

U = _IMP_atom.U

Np = _IMP_atom.Np

Pu = _IMP_atom.Pu

Am = _IMP_atom.Am

Cm = _IMP_atom.Cm

Bk = _IMP_atom.Bk

Cf = _IMP_atom.Cf

Es = _IMP_atom.Es

Fm = _IMP_atom.Fm

Md = _IMP_atom.Md

No = _IMP_atom.No

Lr = _IMP_atom.Lr

Db = _IMP_atom.Db

Jl = _IMP_atom.Jl

Rf = _IMP_atom.Rf

NUMBER_OF_ELEMENTS = _IMP_atom.NUMBER_OF_ELEMENTS


def hash_value(e):
    r"""hash_value(IMP::atom::Element e) -> size_t"""
    return _IMP_atom.hash_value(e)
class ElementTable(object):
    r"""Proxy of C++ IMP::atom::ElementTable class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""__init__(ElementTable self) -> ElementTable"""
        _IMP_atom.ElementTable_swiginit(self, _IMP_atom.new_ElementTable())

    def get_element(self, s):
        r"""get_element(ElementTable self, std::string const & s) -> IMP::atom::Element"""
        return _IMP_atom.ElementTable_get_element(self, s)

    def get_name(self, e):
        r"""get_name(ElementTable self, IMP::atom::Element e) -> std::string"""
        return _IMP_atom.ElementTable_get_name(self, e)

    def get_mass(self, e):
        r"""get_mass(ElementTable self, IMP::atom::Element e) -> IMP::Float"""
        return _IMP_atom.ElementTable_get_mass(self, e)
    __swig_destroy__ = _IMP_atom.delete_ElementTable

# Register ElementTable in _IMP_atom:
_IMP_atom.ElementTable_swigregister(ElementTable)


def get_element_table():
    r"""get_element_table() -> ElementTable"""
    return _IMP_atom.get_element_table()
class Atom(Hierarchy):
    r"""Proxy of C++ IMP::atom::Atom class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(Atom self) -> Atom
        __init__(Atom self, Model m, ParticleIndex id) -> Atom
        __init__(Atom self, _ParticleAdaptor d) -> Atom
        """
        _IMP_atom.Atom_swiginit(self, _IMP_atom.new_Atom(*args))

    def show(self, *args):
        r"""show(Atom self, _ostream out=std::cout)"""
        return _IMP_atom.Atom_show(self, *args)

    @staticmethod
    def setup_particle(*args):
        r"""
        setup_particle(Model m, ParticleIndex pi, Atom other) -> Atom
        setup_particle(_ParticleAdaptor decorator, Atom other) -> Atom
        setup_particle(Model m, ParticleIndex pi, AtomType atom_type) -> Atom
        setup_particle(_ParticleAdaptor decorator, AtomType atom_type) -> Atom
        """
        return _IMP_atom.Atom_setup_particle(*args)

    @staticmethod
    def get_is_setup(*args):
        r"""
        get_is_setup(_ParticleAdaptor p) -> bool
        get_is_setup(Model m, ParticleIndex pi) -> bool
        """
        return _IMP_atom.Atom_get_is_setup(*args)

    def get_atom_type(self):
        r"""get_atom_type(Atom self) -> AtomType"""
        return _IMP_atom.Atom_get_atom_type(self)

    def set_atom_type(self, t):
        r"""set_atom_type(Atom self, AtomType t)"""
        return _IMP_atom.Atom_set_atom_type(self, t)

    def get_element(self):
        r"""get_element(Atom self) -> IMP::atom::Element"""
        return _IMP_atom.Atom_get_element(self)

    def set_element(self, e):
        r"""set_element(Atom self, IMP::atom::Element e)"""
        return _IMP_atom.Atom_set_element(self, e)

    def get_occupancy(self):
        r"""get_occupancy(Atom self) -> double"""
        return _IMP_atom.Atom_get_occupancy(self)

    def set_occupancy(self, occupancy):
        r"""set_occupancy(Atom self, double occupancy)"""
        return _IMP_atom.Atom_set_occupancy(self, occupancy)

    def get_temperature_factor(self):
        r"""get_temperature_factor(Atom self) -> double"""
        return _IMP_atom.Atom_get_temperature_factor(self)

    def set_temperature_factor(self, tempFactor):
        r"""set_temperature_factor(Atom self, double tempFactor)"""
        return _IMP_atom.Atom_set_temperature_factor(self, tempFactor)

    def get_input_index(self):
        r"""get_input_index(Atom self) -> IMP::Int"""
        return _IMP_atom.Atom_get_input_index(self)

    def set_input_index(self, t):
        r"""set_input_index(Atom self, IMP::Int t)"""
        return _IMP_atom.Atom_set_input_index(self, t)

    @staticmethod
    def get_atom_type_key():
        r"""get_atom_type_key() -> IntKey"""
        return _IMP_atom.Atom_get_atom_type_key()

    @staticmethod
    def get_element_key():
        r"""get_element_key() -> IntKey"""
        return _IMP_atom.Atom_get_element_key()

    @staticmethod
    def get_input_index_key():
        r"""get_input_index_key() -> IntKey"""
        return _IMP_atom.Atom_get_input_index_key()

    @staticmethod
    def get_occupancy_key():
        r"""get_occupancy_key() -> FloatKey"""
        return _IMP_atom.Atom_get_occupancy_key()

    @staticmethod
    def get_temperature_factor_key():
        r"""get_temperature_factor_key() -> FloatKey"""
        return _IMP_atom.Atom_get_temperature_factor_key()

    def add_attribute(self, *args):
        r"""
        add_attribute(Atom self, FloatKey k, IMP::Float v, bool opt)
        add_attribute(Atom self, FloatKey a0, IMP::Float a1)
        add_attribute(Atom self, IntKey a0, IMP::Int a1)
        add_attribute(Atom self, FloatsKey a0, IMP::Floats a1)
        add_attribute(Atom self, IntsKey a0, IMP::Ints a1)
        add_attribute(Atom self, StringKey a0, IMP::String a1)
        add_attribute(Atom self, ParticleIndexKey a0, Particle a1)
        add_attribute(Atom self, ObjectKey a0, Object a1)
        """
        return _IMP_atom.Atom_add_attribute(self, *args)

    def get_value(self, *args):
        r"""
        get_value(Atom self, FloatKey a0) -> IMP::Float
        get_value(Atom self, IntKey a0) -> IMP::Int
        get_value(Atom self, FloatsKey a0) -> IMP::Floats
        get_value(Atom self, IntsKey a0) -> IMP::Ints
        get_value(Atom self, StringKey a0) -> IMP::String
        get_value(Atom self, ParticleIndexKey a0) -> Particle
        get_value(Atom self, ObjectKey a0) -> Object
        """
        return _IMP_atom.Atom_get_value(self, *args)

    def set_value(self, *args):
        r"""
        set_value(Atom self, FloatKey a0, IMP::Float a1)
        set_value(Atom self, IntKey a0, IMP::Int a1)
        set_value(Atom self, FloatsKey a0, IMP::Floats a1)
        set_value(Atom self, IntsKey a0, IMP::Ints a1)
        set_value(Atom self, StringKey a0, IMP::String a1)
        set_value(Atom self, ParticleIndexKey a0, Particle a1)
        set_value(Atom self, ObjectKey a0, Object a1)
        """
        return _IMP_atom.Atom_set_value(self, *args)

    def remove_attribute(self, *args):
        r"""
        remove_attribute(Atom self, FloatKey a0)
        remove_attribute(Atom self, IntKey a0)
        remove_attribute(Atom self, FloatsKey a0)
        remove_attribute(Atom self, IntsKey a0)
        remove_attribute(Atom self, StringKey a0)
        remove_attribute(Atom self, ParticleIndexKey a0)
        remove_attribute(Atom self, ObjectKey a0)
        """
        return _IMP_atom.Atom_remove_attribute(self, *args)

    def has_attribute(self, *args):
        r"""
        has_attribute(Atom self, FloatKey a0) -> bool
        has_attribute(Atom self, IntKey a0) -> bool
        has_attribute(Atom self, FloatsKey a0) -> bool
        has_attribute(Atom self, IntsKey a0) -> bool
        has_attribute(Atom self, StringKey a0) -> bool
        has_attribute(Atom self, ParticleIndexKey a0) -> bool
        has_attribute(Atom self, ObjectKey a0) -> bool
        """
        return _IMP_atom.Atom_has_attribute(self, *args)

    def get_derivative(self, a0):
        r"""get_derivative(Atom self, FloatKey a0) -> double"""
        return _IMP_atom.Atom_get_derivative(self, a0)

    def get_name(self):
        r"""get_name(Atom self) -> std::string"""
        return _IMP_atom.Atom_get_name(self)

    def clear_caches(self):
        r"""clear_caches(Atom self)"""
        return _IMP_atom.Atom_clear_caches(self)

    def set_name(self, a0):
        r"""set_name(Atom self, std::string a0)"""
        return _IMP_atom.Atom_set_name(self, a0)

    def set_check_level(self, a0):
        r"""set_check_level(Atom self, IMP::CheckLevel a0)"""
        return _IMP_atom.Atom_set_check_level(self, a0)

    def add_to_derivative(self, a0, a1, a2):
        r"""add_to_derivative(Atom self, FloatKey a0, double a1, DerivativeAccumulator a2)"""
        return _IMP_atom.Atom_add_to_derivative(self, a0, a1, a2)

    def set_is_optimized(self, a0, a1):
        r"""set_is_optimized(Atom self, FloatKey a0, bool a1)"""
        return _IMP_atom.Atom_set_is_optimized(self, a0, a1)

    def get_is_optimized(self, a0):
        r"""get_is_optimized(Atom self, FloatKey a0) -> bool"""
        return _IMP_atom.Atom_get_is_optimized(self, a0)

    def get_check_level(self):
        r"""get_check_level(Atom self) -> IMP::CheckLevel"""
        return _IMP_atom.Atom_get_check_level(self)

    def __eq__(self, *args):
        r"""
        __eq__(Atom self, Atom o) -> bool
        __eq__(Atom self, Particle d) -> bool
        """
        return _IMP_atom.Atom___eq__(self, *args)

    def __ne__(self, *args):
        r"""
        __ne__(Atom self, Atom o) -> bool
        __ne__(Atom self, Particle d) -> bool
        """
        return _IMP_atom.Atom___ne__(self, *args)

    def __le__(self, *args):
        r"""
        __le__(Atom self, Atom o) -> bool
        __le__(Atom self, Particle d) -> bool
        """
        return _IMP_atom.Atom___le__(self, *args)

    def __lt__(self, *args):
        r"""
        __lt__(Atom self, Atom o) -> bool
        __lt__(Atom self, Particle d) -> bool
        """
        return _IMP_atom.Atom___lt__(self, *args)

    def __ge__(self, *args):
        r"""
        __ge__(Atom self, Atom o) -> bool
        __ge__(Atom self, Particle d) -> bool
        """
        return _IMP_atom.Atom___ge__(self, *args)

    def __gt__(self, *args):
        r"""
        __gt__(Atom self, Atom o) -> bool
        __gt__(Atom self, Particle d) -> bool
        """
        return _IMP_atom.Atom___gt__(self, *args)

    def __hash__(self):
        r"""__hash__(Atom self) -> std::size_t"""
        return _IMP_atom.Atom___hash__(self)

    def __str__(self):
        r"""__str__(Atom self) -> std::string"""
        return _IMP_atom.Atom___str__(self)

    def __repr__(self):
        r"""__repr__(Atom self) -> std::string"""
        return _IMP_atom.Atom___repr__(self)
    __swig_destroy__ = _IMP_atom.delete_Atom

# Register Atom in _IMP_atom:
_IMP_atom.Atom_swigregister(Atom)
AT_UNKNOWN = cvar.AT_UNKNOWN
AT_N = cvar.AT_N
AT_CA = cvar.AT_CA
AT_C = cvar.AT_C
AT_O = cvar.AT_O
AT_H = cvar.AT_H
AT_H1 = cvar.AT_H1
AT_H2 = cvar.AT_H2
AT_H3 = cvar.AT_H3
AT_HA = cvar.AT_HA
AT_HA1 = cvar.AT_HA1
AT_HA2 = cvar.AT_HA2
AT_HA3 = cvar.AT_HA3
AT_CB = cvar.AT_CB
AT_HB = cvar.AT_HB
AT_HB1 = cvar.AT_HB1
AT_HB2 = cvar.AT_HB2
AT_HB3 = cvar.AT_HB3
AT_OXT = cvar.AT_OXT
AT_CH3 = cvar.AT_CH3
AT_CH = cvar.AT_CH
AT_CG = cvar.AT_CG
AT_CG1 = cvar.AT_CG1
AT_CG2 = cvar.AT_CG2
AT_HG = cvar.AT_HG
AT_HG1 = cvar.AT_HG1
AT_HG2 = cvar.AT_HG2
AT_HG3 = cvar.AT_HG3
AT_HG11 = cvar.AT_HG11
AT_HG21 = cvar.AT_HG21
AT_HG31 = cvar.AT_HG31
AT_HG12 = cvar.AT_HG12
AT_HG13 = cvar.AT_HG13
AT_HG22 = cvar.AT_HG22
AT_HG23 = cvar.AT_HG23
AT_HG32 = cvar.AT_HG32
AT_OG = cvar.AT_OG
AT_OG1 = cvar.AT_OG1
AT_SG = cvar.AT_SG
AT_CD = cvar.AT_CD
AT_CD1 = cvar.AT_CD1
AT_CD2 = cvar.AT_CD2
AT_HD = cvar.AT_HD
AT_HD1 = cvar.AT_HD1
AT_HD2 = cvar.AT_HD2
AT_HD3 = cvar.AT_HD3
AT_HD11 = cvar.AT_HD11
AT_HD21 = cvar.AT_HD21
AT_HD31 = cvar.AT_HD31
AT_HD12 = cvar.AT_HD12
AT_HD13 = cvar.AT_HD13
AT_HD22 = cvar.AT_HD22
AT_HD23 = cvar.AT_HD23
AT_HD32 = cvar.AT_HD32
AT_SD = cvar.AT_SD
AT_OD1 = cvar.AT_OD1
AT_OD2 = cvar.AT_OD2
AT_ND1 = cvar.AT_ND1
AT_ND2 = cvar.AT_ND2
AT_CE = cvar.AT_CE
AT_CE1 = cvar.AT_CE1
AT_CE2 = cvar.AT_CE2
AT_CE3 = cvar.AT_CE3
AT_HE = cvar.AT_HE
AT_HE1 = cvar.AT_HE1
AT_HE2 = cvar.AT_HE2
AT_HE3 = cvar.AT_HE3
AT_HE21 = cvar.AT_HE21
AT_HE22 = cvar.AT_HE22
AT_OE1 = cvar.AT_OE1
AT_OE2 = cvar.AT_OE2
AT_NE = cvar.AT_NE
AT_NE1 = cvar.AT_NE1
AT_NE2 = cvar.AT_NE2
AT_CZ = cvar.AT_CZ
AT_CZ2 = cvar.AT_CZ2
AT_CZ3 = cvar.AT_CZ3
AT_NZ = cvar.AT_NZ
AT_HZ = cvar.AT_HZ
AT_HZ1 = cvar.AT_HZ1
AT_HZ2 = cvar.AT_HZ2
AT_HZ3 = cvar.AT_HZ3
AT_CH2 = cvar.AT_CH2
AT_NH1 = cvar.AT_NH1
AT_NH2 = cvar.AT_NH2
AT_OH = cvar.AT_OH
AT_HH = cvar.AT_HH
AT_HH11 = cvar.AT_HH11
AT_HH21 = cvar.AT_HH21
AT_HH2 = cvar.AT_HH2
AT_HH12 = cvar.AT_HH12
AT_HH22 = cvar.AT_HH22
AT_HH13 = cvar.AT_HH13
AT_HH23 = cvar.AT_HH23
AT_HH33 = cvar.AT_HH33
AT_P = cvar.AT_P
AT_OP1 = cvar.AT_OP1
AT_OP2 = cvar.AT_OP2
AT_OP3 = cvar.AT_OP3
AT_O5p = cvar.AT_O5p
AT_C5p = cvar.AT_C5p
AT_H5p = cvar.AT_H5p
AT_H5pp = cvar.AT_H5pp
AT_C4p = cvar.AT_C4p
AT_H4p = cvar.AT_H4p
AT_O4p = cvar.AT_O4p
AT_C1p = cvar.AT_C1p
AT_H1p = cvar.AT_H1p
AT_C3p = cvar.AT_C3p
AT_H3p = cvar.AT_H3p
AT_O3p = cvar.AT_O3p
AT_C2p = cvar.AT_C2p
AT_H2p = cvar.AT_H2p
AT_H2pp = cvar.AT_H2pp
AT_O2p = cvar.AT_O2p
AT_HO2p = cvar.AT_HO2p
AT_N9 = cvar.AT_N9
AT_C8 = cvar.AT_C8
AT_H8 = cvar.AT_H8
AT_N7 = cvar.AT_N7
AT_C5 = cvar.AT_C5
AT_C4 = cvar.AT_C4
AT_N3 = cvar.AT_N3
AT_C2 = cvar.AT_C2
AT_N1 = cvar.AT_N1
AT_C6 = cvar.AT_C6
AT_N6 = cvar.AT_N6
AT_H61 = cvar.AT_H61
AT_H62 = cvar.AT_H62
AT_O6 = cvar.AT_O6
AT_N2 = cvar.AT_N2
AT_NT = cvar.AT_NT
AT_H21 = cvar.AT_H21
AT_H22 = cvar.AT_H22
AT_H6 = cvar.AT_H6
AT_H5 = cvar.AT_H5
AT_O2 = cvar.AT_O2
AT_N4 = cvar.AT_N4
AT_H41 = cvar.AT_H41
AT_H42 = cvar.AT_H42
AT_O4 = cvar.AT_O4
AT_C7 = cvar.AT_C7
AT_H71 = cvar.AT_H71
AT_H72 = cvar.AT_H72
AT_H73 = cvar.AT_H73
AT_O1A = cvar.AT_O1A
AT_O2A = cvar.AT_O2A
AT_O3A = cvar.AT_O3A
AT_O1B = cvar.AT_O1B
AT_O2B = cvar.AT_O2B
AT_O3B = cvar.AT_O3B

def Atom_setup_particle(*args):
    r"""
    Atom_setup_particle(Model m, ParticleIndex pi, Atom other) -> Atom
    Atom_setup_particle(_ParticleAdaptor decorator, Atom other) -> Atom
    Atom_setup_particle(Model m, ParticleIndex pi, AtomType atom_type) -> Atom
    Atom_setup_particle(_ParticleAdaptor decorator, AtomType atom_type) -> Atom
    """
    return _IMP_atom.Atom_setup_particle(*args)

def Atom_get_is_setup(*args):
    r"""
    Atom_get_is_setup(_ParticleAdaptor p) -> bool
    Atom_get_is_setup(Model m, ParticleIndex pi) -> bool
    """
    return _IMP_atom.Atom_get_is_setup(*args)

def Atom_get_atom_type_key():
    r"""Atom_get_atom_type_key() -> IntKey"""
    return _IMP_atom.Atom_get_atom_type_key()

def Atom_get_element_key():
    r"""Atom_get_element_key() -> IntKey"""
    return _IMP_atom.Atom_get_element_key()

def Atom_get_input_index_key():
    r"""Atom_get_input_index_key() -> IntKey"""
    return _IMP_atom.Atom_get_input_index_key()

def Atom_get_occupancy_key():
    r"""Atom_get_occupancy_key() -> FloatKey"""
    return _IMP_atom.Atom_get_occupancy_key()

def Atom_get_temperature_factor_key():
    r"""Atom_get_temperature_factor_key() -> FloatKey"""
    return _IMP_atom.Atom_get_temperature_factor_key()


def get_residue(*args):
    r"""
    get_residue(Hierarchy mhd, unsigned int index) -> Hierarchy
    get_residue(Atom d, bool nothrow=False) -> Residue
    """
    return _IMP_atom.get_residue(*args)

def get_atom(rd, at):
    r"""get_atom(Residue rd, AtomType at) -> Atom"""
    return _IMP_atom.get_atom(rd, at)

def add_atom_type(name, e):
    r"""add_atom_type(std::string name, IMP::atom::Element e) -> AtomType"""
    return _IMP_atom.add_atom_type(name, e)

def get_element_for_atom_type(at):
    r"""get_element_for_atom_type(AtomType at) -> IMP::atom::Element"""
    return _IMP_atom.get_element_for_atom_type(at)

def get_atom_type_exists(name):
    r"""get_atom_type_exists(std::string name) -> bool"""
    return _IMP_atom.get_atom_type_exists(name)
class Residue(Hierarchy):
    r"""Proxy of C++ IMP::atom::Residue class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(Residue self) -> Residue
        __init__(Residue self, Model m, ParticleIndex id) -> Residue
        __init__(Residue self, _ParticleAdaptor d) -> Residue
        """
        _IMP_atom.Residue_swiginit(self, _IMP_atom.new_Residue(*args))

    def show(self, *args):
        r"""show(Residue self, _ostream out=std::cout)"""
        return _IMP_atom.Residue_show(self, *args)

    @staticmethod
    def setup_particle(*args):
        r"""
        setup_particle(Model m, ParticleIndex pi, ResidueType t, int index, int insertion_code) -> Residue
        setup_particle(_ParticleAdaptor decorator, ResidueType t, int index, int insertion_code) -> Residue
        setup_particle(Model m, ParticleIndex pi, ResidueType t, int index) -> Residue
        setup_particle(_ParticleAdaptor decorator, ResidueType t, int index) -> Residue
        setup_particle(Model m, ParticleIndex pi, ResidueType t) -> Residue
        setup_particle(_ParticleAdaptor decorator, ResidueType t) -> Residue
        setup_particle(Model m, ParticleIndex pi, Residue other) -> Residue
        setup_particle(_ParticleAdaptor decorator, Residue other) -> Residue
        """
        return _IMP_atom.Residue_setup_particle(*args)

    @staticmethod
    def get_is_setup(*args):
        r"""
        get_is_setup(_ParticleAdaptor p) -> bool
        get_is_setup(Model m, ParticleIndex pi) -> bool
        """
        return _IMP_atom.Residue_get_is_setup(*args)

    def get_residue_type(self):
        r"""get_residue_type(Residue self) -> ResidueType"""
        return _IMP_atom.Residue_get_residue_type(self)

    def set_residue_type(self, t):
        r"""set_residue_type(Residue self, ResidueType t)"""
        return _IMP_atom.Residue_set_residue_type(self, t)

    def get_is_protein(self):
        r"""get_is_protein(Residue self) -> bool"""
        return _IMP_atom.Residue_get_is_protein(self)

    def get_is_dna(self):
        r"""get_is_dna(Residue self) -> bool"""
        return _IMP_atom.Residue_get_is_dna(self)

    def get_is_rna(self):
        r"""get_is_rna(Residue self) -> bool"""
        return _IMP_atom.Residue_get_is_rna(self)

    def get_index(self):
        r"""get_index(Residue self) -> IMP::Int"""
        return _IMP_atom.Residue_get_index(self)

    def set_index(self, t):
        r"""set_index(Residue self, IMP::Int t)"""
        return _IMP_atom.Residue_set_index(self, t)

    def get_insertion_code(self):
        r"""get_insertion_code(Residue self) -> char"""
        return _IMP_atom.Residue_get_insertion_code(self)

    def set_insertion_code(self, insertion_code):
        r"""set_insertion_code(Residue self, char insertion_code)"""
        return _IMP_atom.Residue_set_insertion_code(self, insertion_code)

    @staticmethod
    def get_index_key():
        r"""get_index_key() -> IntKey"""
        return _IMP_atom.Residue_get_index_key()

    @staticmethod
    def get_residue_type_key():
        r"""get_residue_type_key() -> IntKey"""
        return _IMP_atom.Residue_get_residue_type_key()

    @staticmethod
    def get_insertion_code_key():
        r"""get_insertion_code_key() -> IntKey"""
        return _IMP_atom.Residue_get_insertion_code_key()

    def add_attribute(self, *args):
        r"""
        add_attribute(Residue self, FloatKey k, IMP::Float v, bool opt)
        add_attribute(Residue self, FloatKey a0, IMP::Float a1)
        add_attribute(Residue self, IntKey a0, IMP::Int a1)
        add_attribute(Residue self, FloatsKey a0, IMP::Floats a1)
        add_attribute(Residue self, IntsKey a0, IMP::Ints a1)
        add_attribute(Residue self, StringKey a0, IMP::String a1)
        add_attribute(Residue self, ParticleIndexKey a0, Particle a1)
        add_attribute(Residue self, ObjectKey a0, Object a1)
        """
        return _IMP_atom.Residue_add_attribute(self, *args)

    def get_value(self, *args):
        r"""
        get_value(Residue self, FloatKey a0) -> IMP::Float
        get_value(Residue self, IntKey a0) -> IMP::Int
        get_value(Residue self, FloatsKey a0) -> IMP::Floats
        get_value(Residue self, IntsKey a0) -> IMP::Ints
        get_value(Residue self, StringKey a0) -> IMP::String
        get_value(Residue self, ParticleIndexKey a0) -> Particle
        get_value(Residue self, ObjectKey a0) -> Object
        """
        return _IMP_atom.Residue_get_value(self, *args)

    def set_value(self, *args):
        r"""
        set_value(Residue self, FloatKey a0, IMP::Float a1)
        set_value(Residue self, IntKey a0, IMP::Int a1)
        set_value(Residue self, FloatsKey a0, IMP::Floats a1)
        set_value(Residue self, IntsKey a0, IMP::Ints a1)
        set_value(Residue self, StringKey a0, IMP::String a1)
        set_value(Residue self, ParticleIndexKey a0, Particle a1)
        set_value(Residue self, ObjectKey a0, Object a1)
        """
        return _IMP_atom.Residue_set_value(self, *args)

    def remove_attribute(self, *args):
        r"""
        remove_attribute(Residue self, FloatKey a0)
        remove_attribute(Residue self, IntKey a0)
        remove_attribute(Residue self, FloatsKey a0)
        remove_attribute(Residue self, IntsKey a0)
        remove_attribute(Residue self, StringKey a0)
        remove_attribute(Residue self, ParticleIndexKey a0)
        remove_attribute(Residue self, ObjectKey a0)
        """
        return _IMP_atom.Residue_remove_attribute(self, *args)

    def has_attribute(self, *args):
        r"""
        has_attribute(Residue self, FloatKey a0) -> bool
        has_attribute(Residue self, IntKey a0) -> bool
        has_attribute(Residue self, FloatsKey a0) -> bool
        has_attribute(Residue self, IntsKey a0) -> bool
        has_attribute(Residue self, StringKey a0) -> bool
        has_attribute(Residue self, ParticleIndexKey a0) -> bool
        has_attribute(Residue self, ObjectKey a0) -> bool
        """
        return _IMP_atom.Residue_has_attribute(self, *args)

    def get_derivative(self, a0):
        r"""get_derivative(Residue self, FloatKey a0) -> double"""
        return _IMP_atom.Residue_get_derivative(self, a0)

    def get_name(self):
        r"""get_name(Residue self) -> std::string"""
        return _IMP_atom.Residue_get_name(self)

    def clear_caches(self):
        r"""clear_caches(Residue self)"""
        return _IMP_atom.Residue_clear_caches(self)

    def set_name(self, a0):
        r"""set_name(Residue self, std::string a0)"""
        return _IMP_atom.Residue_set_name(self, a0)

    def set_check_level(self, a0):
        r"""set_check_level(Residue self, IMP::CheckLevel a0)"""
        return _IMP_atom.Residue_set_check_level(self, a0)

    def add_to_derivative(self, a0, a1, a2):
        r"""add_to_derivative(Residue self, FloatKey a0, double a1, DerivativeAccumulator a2)"""
        return _IMP_atom.Residue_add_to_derivative(self, a0, a1, a2)

    def set_is_optimized(self, a0, a1):
        r"""set_is_optimized(Residue self, FloatKey a0, bool a1)"""
        return _IMP_atom.Residue_set_is_optimized(self, a0, a1)

    def get_is_optimized(self, a0):
        r"""get_is_optimized(Residue self, FloatKey a0) -> bool"""
        return _IMP_atom.Residue_get_is_optimized(self, a0)

    def get_check_level(self):
        r"""get_check_level(Residue self) -> IMP::CheckLevel"""
        return _IMP_atom.Residue_get_check_level(self)

    def __eq__(self, *args):
        r"""
        __eq__(Residue self, Residue o) -> bool
        __eq__(Residue self, Particle d) -> bool
        """
        return _IMP_atom.Residue___eq__(self, *args)

    def __ne__(self, *args):
        r"""
        __ne__(Residue self, Residue o) -> bool
        __ne__(Residue self, Particle d) -> bool
        """
        return _IMP_atom.Residue___ne__(self, *args)

    def __le__(self, *args):
        r"""
        __le__(Residue self, Residue o) -> bool
        __le__(Residue self, Particle d) -> bool
        """
        return _IMP_atom.Residue___le__(self, *args)

    def __lt__(self, *args):
        r"""
        __lt__(Residue self, Residue o) -> bool
        __lt__(Residue self, Particle d) -> bool
        """
        return _IMP_atom.Residue___lt__(self, *args)

    def __ge__(self, *args):
        r"""
        __ge__(Residue self, Residue o) -> bool
        __ge__(Residue self, Particle d) -> bool
        """
        return _IMP_atom.Residue___ge__(self, *args)

    def __gt__(self, *args):
        r"""
        __gt__(Residue self, Residue o) -> bool
        __gt__(Residue self, Particle d) -> bool
        """
        return _IMP_atom.Residue___gt__(self, *args)

    def __hash__(self):
        r"""__hash__(Residue self) -> std::size_t"""
        return _IMP_atom.Residue___hash__(self)

    def __str__(self):
        r"""__str__(Residue self) -> std::string"""
        return _IMP_atom.Residue___str__(self)

    def __repr__(self):
        r"""__repr__(Residue self) -> std::string"""
        return _IMP_atom.Residue___repr__(self)
    __swig_destroy__ = _IMP_atom.delete_Residue

# Register Residue in _IMP_atom:
_IMP_atom.Residue_swigregister(Residue)
UNK = cvar.UNK
GLY = cvar.GLY
ALA = cvar.ALA
VAL = cvar.VAL
LEU = cvar.LEU
ILE = cvar.ILE
SER = cvar.SER
THR = cvar.THR
CYS = cvar.CYS
MET = cvar.MET
PRO = cvar.PRO
ASP = cvar.ASP
ASN = cvar.ASN
GLU = cvar.GLU
GLN = cvar.GLN
LYS = cvar.LYS
ARG = cvar.ARG
HIS = cvar.HIS
PHE = cvar.PHE
TYR = cvar.TYR
TRP = cvar.TRP
ACE = cvar.ACE
NH2 = cvar.NH2
ADE = cvar.ADE
URA = cvar.URA
CYT = cvar.CYT
GUA = cvar.GUA
THY = cvar.THY
DADE = cvar.DADE
DURA = cvar.DURA
DCYT = cvar.DCYT
DGUA = cvar.DGUA
DTHY = cvar.DTHY
HOH = cvar.HOH
HEME = cvar.HEME
POP = cvar.POP

def Residue_setup_particle(*args):
    r"""
    Residue_setup_particle(Model m, ParticleIndex pi, ResidueType t, int index, int insertion_code) -> Residue
    Residue_setup_particle(_ParticleAdaptor decorator, ResidueType t, int index, int insertion_code) -> Residue
    Residue_setup_particle(Model m, ParticleIndex pi, ResidueType t, int index) -> Residue
    Residue_setup_particle(_ParticleAdaptor decorator, ResidueType t, int index) -> Residue
    Residue_setup_particle(Model m, ParticleIndex pi, ResidueType t) -> Residue
    Residue_setup_particle(_ParticleAdaptor decorator, ResidueType t) -> Residue
    Residue_setup_particle(Model m, ParticleIndex pi, Residue other) -> Residue
    Residue_setup_particle(_ParticleAdaptor decorator, Residue other) -> Residue
    """
    return _IMP_atom.Residue_setup_particle(*args)

def Residue_get_is_setup(*args):
    r"""
    Residue_get_is_setup(_ParticleAdaptor p) -> bool
    Residue_get_is_setup(Model m, ParticleIndex pi) -> bool
    """
    return _IMP_atom.Residue_get_is_setup(*args)

def Residue_get_index_key():
    r"""Residue_get_index_key() -> IntKey"""
    return _IMP_atom.Residue_get_index_key()

def Residue_get_residue_type_key():
    r"""Residue_get_residue_type_key() -> IntKey"""
    return _IMP_atom.Residue_get_residue_type_key()

def Residue_get_insertion_code_key():
    r"""Residue_get_insertion_code_key() -> IntKey"""
    return _IMP_atom.Residue_get_insertion_code_key()


def get_next_residue(rd):
    r"""get_next_residue(Residue rd) -> Hierarchy"""
    return _IMP_atom.get_next_residue(rd)

def get_previous_residue(rd):
    r"""get_previous_residue(Residue rd) -> Hierarchy"""
    return _IMP_atom.get_previous_residue(rd)

def get_one_letter_code(c):
    r"""get_one_letter_code(ResidueType c) -> char"""
    return _IMP_atom.get_one_letter_code(c)
BALLS = _IMP_atom.BALLS

DENSITIES = _IMP_atom.DENSITIES

class Representation(Hierarchy):
    r"""Proxy of C++ IMP::atom::Representation class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    @staticmethod
    def setup_particle(*args):
        r"""
        setup_particle(Model m, ParticleIndex pi) -> Representation
        setup_particle(_ParticleAdaptor decorator) -> Representation
        setup_particle(Model m, ParticleIndex pi, double resolution) -> Representation
        setup_particle(_ParticleAdaptor decorator, double resolution) -> Representation
        setup_particle(Model m, ParticleIndex pi, Representation other) -> Representation
        setup_particle(_ParticleAdaptor decorator, Representation other) -> Representation
        """
        return _IMP_atom.Representation_setup_particle(*args)

    def __init__(self, *args):
        r"""
        __init__(Representation self) -> Representation
        __init__(Representation self, Model m, ParticleIndex id) -> Representation
        __init__(Representation self, _ParticleAdaptor d) -> Representation
        """
        _IMP_atom.Representation_swiginit(self, _IMP_atom.new_Representation(*args))

    def show(self, *args):
        r"""show(Representation self, _ostream out=std::cout)"""
        return _IMP_atom.Representation_show(self, *args)

    @staticmethod
    def get_is_setup(*args):
        r"""
        get_is_setup(_ParticleAdaptor p) -> bool
        get_is_setup(Model m, ParticleIndex pi) -> bool
        """
        return _IMP_atom.Representation_get_is_setup(*args)

    def get_representation(self, *args):
        r"""get_representation(Representation self, double resolution, IMP::atom::RepresentationType type=BALLS) -> Hierarchy"""
        return _IMP_atom.Representation_get_representation(self, *args)

    def get_representations(self, *args):
        r"""get_representations(Representation self, IMP::atom::RepresentationType type=BALLS) -> IMP::atom::Hierarchies"""
        return _IMP_atom.Representation_get_representations(self, *args)

    def add_representation(self, *args):
        r"""add_representation(Representation self, _ParticleIndexAdaptor rep, IMP::atom::RepresentationType type=BALLS, double resolution=-1)"""
        return _IMP_atom.Representation_add_representation(self, *args)

    def get_resolutions(self, *args):
        r"""get_resolutions(Representation self, IMP::atom::RepresentationType type=BALLS) -> IMP::Floats"""
        return _IMP_atom.Representation_get_resolutions(self, *args)

    def remove_representation(self, rep):
        r"""remove_representation(Representation self, _ParticleIndexAdaptor rep)"""
        return _IMP_atom.Representation_remove_representation(self, rep)

    def update_parents(self):
        r"""update_parents(Representation self)"""
        return _IMP_atom.Representation_update_parents(self)

    def add_attribute(self, *args):
        r"""
        add_attribute(Representation self, FloatKey k, IMP::Float v, bool opt)
        add_attribute(Representation self, FloatKey a0, IMP::Float a1)
        add_attribute(Representation self, IntKey a0, IMP::Int a1)
        add_attribute(Representation self, FloatsKey a0, IMP::Floats a1)
        add_attribute(Representation self, IntsKey a0, IMP::Ints a1)
        add_attribute(Representation self, StringKey a0, IMP::String a1)
        add_attribute(Representation self, ParticleIndexKey a0, Particle a1)
        add_attribute(Representation self, ObjectKey a0, Object a1)
        """
        return _IMP_atom.Representation_add_attribute(self, *args)

    def get_value(self, *args):
        r"""
        get_value(Representation self, FloatKey a0) -> IMP::Float
        get_value(Representation self, IntKey a0) -> IMP::Int
        get_value(Representation self, FloatsKey a0) -> IMP::Floats
        get_value(Representation self, IntsKey a0) -> IMP::Ints
        get_value(Representation self, StringKey a0) -> IMP::String
        get_value(Representation self, ParticleIndexKey a0) -> Particle
        get_value(Representation self, ObjectKey a0) -> Object
        """
        return _IMP_atom.Representation_get_value(self, *args)

    def set_value(self, *args):
        r"""
        set_value(Representation self, FloatKey a0, IMP::Float a1)
        set_value(Representation self, IntKey a0, IMP::Int a1)
        set_value(Representation self, FloatsKey a0, IMP::Floats a1)
        set_value(Representation self, IntsKey a0, IMP::Ints a1)
        set_value(Representation self, StringKey a0, IMP::String a1)
        set_value(Representation self, ParticleIndexKey a0, Particle a1)
        set_value(Representation self, ObjectKey a0, Object a1)
        """
        return _IMP_atom.Representation_set_value(self, *args)

    def remove_attribute(self, *args):
        r"""
        remove_attribute(Representation self, FloatKey a0)
        remove_attribute(Representation self, IntKey a0)
        remove_attribute(Representation self, FloatsKey a0)
        remove_attribute(Representation self, IntsKey a0)
        remove_attribute(Representation self, StringKey a0)
        remove_attribute(Representation self, ParticleIndexKey a0)
        remove_attribute(Representation self, ObjectKey a0)
        """
        return _IMP_atom.Representation_remove_attribute(self, *args)

    def has_attribute(self, *args):
        r"""
        has_attribute(Representation self, FloatKey a0) -> bool
        has_attribute(Representation self, IntKey a0) -> bool
        has_attribute(Representation self, FloatsKey a0) -> bool
        has_attribute(Representation self, IntsKey a0) -> bool
        has_attribute(Representation self, StringKey a0) -> bool
        has_attribute(Representation self, ParticleIndexKey a0) -> bool
        has_attribute(Representation self, ObjectKey a0) -> bool
        """
        return _IMP_atom.Representation_has_attribute(self, *args)

    def get_derivative(self, a0):
        r"""get_derivative(Representation self, FloatKey a0) -> double"""
        return _IMP_atom.Representation_get_derivative(self, a0)

    def get_name(self):
        r"""get_name(Representation self) -> std::string"""
        return _IMP_atom.Representation_get_name(self)

    def clear_caches(self):
        r"""clear_caches(Representation self)"""
        return _IMP_atom.Representation_clear_caches(self)

    def set_name(self, a0):
        r"""set_name(Representation self, std::string a0)"""
        return _IMP_atom.Representation_set_name(self, a0)

    def set_check_level(self, a0):
        r"""set_check_level(Representation self, IMP::CheckLevel a0)"""
        return _IMP_atom.Representation_set_check_level(self, a0)

    def add_to_derivative(self, a0, a1, a2):
        r"""add_to_derivative(Representation self, FloatKey a0, double a1, DerivativeAccumulator a2)"""
        return _IMP_atom.Representation_add_to_derivative(self, a0, a1, a2)

    def set_is_optimized(self, a0, a1):
        r"""set_is_optimized(Representation self, FloatKey a0, bool a1)"""
        return _IMP_atom.Representation_set_is_optimized(self, a0, a1)

    def get_is_optimized(self, a0):
        r"""get_is_optimized(Representation self, FloatKey a0) -> bool"""
        return _IMP_atom.Representation_get_is_optimized(self, a0)

    def get_check_level(self):
        r"""get_check_level(Representation self) -> IMP::CheckLevel"""
        return _IMP_atom.Representation_get_check_level(self)

    def __eq__(self, *args):
        r"""
        __eq__(Representation self, Representation o) -> bool
        __eq__(Representation self, Particle d) -> bool
        """
        return _IMP_atom.Representation___eq__(self, *args)

    def __ne__(self, *args):
        r"""
        __ne__(Representation self, Representation o) -> bool
        __ne__(Representation self, Particle d) -> bool
        """
        return _IMP_atom.Representation___ne__(self, *args)

    def __le__(self, *args):
        r"""
        __le__(Representation self, Representation o) -> bool
        __le__(Representation self, Particle d) -> bool
        """
        return _IMP_atom.Representation___le__(self, *args)

    def __lt__(self, *args):
        r"""
        __lt__(Representation self, Representation o) -> bool
        __lt__(Representation self, Particle d) -> bool
        """
        return _IMP_atom.Representation___lt__(self, *args)

    def __ge__(self, *args):
        r"""
        __ge__(Representation self, Representation o) -> bool
        __ge__(Representation self, Particle d) -> bool
        """
        return _IMP_atom.Representation___ge__(self, *args)

    def __gt__(self, *args):
        r"""
        __gt__(Representation self, Representation o) -> bool
        __gt__(Representation self, Particle d) -> bool
        """
        return _IMP_atom.Representation___gt__(self, *args)

    def __hash__(self):
        r"""__hash__(Representation self) -> std::size_t"""
        return _IMP_atom.Representation___hash__(self)

    def __str__(self):
        r"""__str__(Representation self) -> std::string"""
        return _IMP_atom.Representation___str__(self)

    def __repr__(self):
        r"""__repr__(Representation self) -> std::string"""
        return _IMP_atom.Representation___repr__(self)
    __swig_destroy__ = _IMP_atom.delete_Representation

# Register Representation in _IMP_atom:
_IMP_atom.Representation_swigregister(Representation)
ALL_RESOLUTIONS = cvar.ALL_RESOLUTIONS

def Representation_setup_particle(*args):
    r"""
    Representation_setup_particle(Model m, ParticleIndex pi) -> Representation
    Representation_setup_particle(_ParticleAdaptor decorator) -> Representation
    Representation_setup_particle(Model m, ParticleIndex pi, double resolution) -> Representation
    Representation_setup_particle(_ParticleAdaptor decorator, double resolution) -> Representation
    Representation_setup_particle(Model m, ParticleIndex pi, Representation other) -> Representation
    Representation_setup_particle(_ParticleAdaptor decorator, Representation other) -> Representation
    """
    return _IMP_atom.Representation_setup_particle(*args)

def Representation_get_is_setup(*args):
    r"""
    Representation_get_is_setup(_ParticleAdaptor p) -> bool
    Representation_get_is_setup(Model m, ParticleIndex pi) -> bool
    """
    return _IMP_atom.Representation_get_is_setup(*args)


def get_resolution(*args):
    r"""
    get_resolution(Model m, ParticleIndex pi) -> double
    get_resolution(Hierarchy h) -> double
    """
    return _IMP_atom.get_resolution(*args)

def get_representation(h, nothrow=False):
    r"""get_representation(Hierarchy h, bool nothrow=False) -> Representation"""
    return _IMP_atom.get_representation(h, nothrow)

def show_with_representations(*args):
    r"""show_with_representations(Hierarchy h, _ostream out=std::cout)"""
    return _IMP_atom.show_with_representations(*args)
class State(Hierarchy):
    r"""Proxy of C++ IMP::atom::State class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    @staticmethod
    def setup_particle(*args):
        r"""
        setup_particle(Model m, ParticleIndex pi, unsigned int index) -> State
        setup_particle(_ParticleAdaptor decorator, unsigned int index) -> State
        setup_particle(Model m, ParticleIndex pi, State other) -> State
        setup_particle(_ParticleAdaptor decorator, State other) -> State
        """
        return _IMP_atom.State_setup_particle(*args)

    def __init__(self, *args):
        r"""
        __init__(State self) -> State
        __init__(State self, Model m, ParticleIndex id) -> State
        __init__(State self, _ParticleAdaptor d) -> State
        """
        _IMP_atom.State_swiginit(self, _IMP_atom.new_State(*args))

    def show(self, *args):
        r"""show(State self, _ostream out=std::cout)"""
        return _IMP_atom.State_show(self, *args)

    @staticmethod
    def get_is_setup(*args):
        r"""
        get_is_setup(_ParticleAdaptor p) -> bool
        get_is_setup(Model m, ParticleIndex pi) -> bool
        """
        return _IMP_atom.State_get_is_setup(*args)

    def get_state_index(self):
        r"""get_state_index(State self) -> unsigned int"""
        return _IMP_atom.State_get_state_index(self)

    def add_attribute(self, *args):
        r"""
        add_attribute(State self, FloatKey k, IMP::Float v, bool opt)
        add_attribute(State self, FloatKey a0, IMP::Float a1)
        add_attribute(State self, IntKey a0, IMP::Int a1)
        add_attribute(State self, FloatsKey a0, IMP::Floats a1)
        add_attribute(State self, IntsKey a0, IMP::Ints a1)
        add_attribute(State self, StringKey a0, IMP::String a1)
        add_attribute(State self, ParticleIndexKey a0, Particle a1)
        add_attribute(State self, ObjectKey a0, Object a1)
        """
        return _IMP_atom.State_add_attribute(self, *args)

    def get_value(self, *args):
        r"""
        get_value(State self, FloatKey a0) -> IMP::Float
        get_value(State self, IntKey a0) -> IMP::Int
        get_value(State self, FloatsKey a0) -> IMP::Floats
        get_value(State self, IntsKey a0) -> IMP::Ints
        get_value(State self, StringKey a0) -> IMP::String
        get_value(State self, ParticleIndexKey a0) -> Particle
        get_value(State self, ObjectKey a0) -> Object
        """
        return _IMP_atom.State_get_value(self, *args)

    def set_value(self, *args):
        r"""
        set_value(State self, FloatKey a0, IMP::Float a1)
        set_value(State self, IntKey a0, IMP::Int a1)
        set_value(State self, FloatsKey a0, IMP::Floats a1)
        set_value(State self, IntsKey a0, IMP::Ints a1)
        set_value(State self, StringKey a0, IMP::String a1)
        set_value(State self, ParticleIndexKey a0, Particle a1)
        set_value(State self, ObjectKey a0, Object a1)
        """
        return _IMP_atom.State_set_value(self, *args)

    def remove_attribute(self, *args):
        r"""
        remove_attribute(State self, FloatKey a0)
        remove_attribute(State self, IntKey a0)
        remove_attribute(State self, FloatsKey a0)
        remove_attribute(State self, IntsKey a0)
        remove_attribute(State self, StringKey a0)
        remove_attribute(State self, ParticleIndexKey a0)
        remove_attribute(State self, ObjectKey a0)
        """
        return _IMP_atom.State_remove_attribute(self, *args)

    def has_attribute(self, *args):
        r"""
        has_attribute(State self, FloatKey a0) -> bool
        has_attribute(State self, IntKey a0) -> bool
        has_attribute(State self, FloatsKey a0) -> bool
        has_attribute(State self, IntsKey a0) -> bool
        has_attribute(State self, StringKey a0) -> bool
        has_attribute(State self, ParticleIndexKey a0) -> bool
        has_attribute(State self, ObjectKey a0) -> bool
        """
        return _IMP_atom.State_has_attribute(self, *args)

    def get_derivative(self, a0):
        r"""get_derivative(State self, FloatKey a0) -> double"""
        return _IMP_atom.State_get_derivative(self, a0)

    def get_name(self):
        r"""get_name(State self) -> std::string"""
        return _IMP_atom.State_get_name(self)

    def clear_caches(self):
        r"""clear_caches(State self)"""
        return _IMP_atom.State_clear_caches(self)

    def set_name(self, a0):
        r"""set_name(State self, std::string a0)"""
        return _IMP_atom.State_set_name(self, a0)

    def set_check_level(self, a0):
        r"""set_check_level(State self, IMP::CheckLevel a0)"""
        return _IMP_atom.State_set_check_level(self, a0)

    def add_to_derivative(self, a0, a1, a2):
        r"""add_to_derivative(State self, FloatKey a0, double a1, DerivativeAccumulator a2)"""
        return _IMP_atom.State_add_to_derivative(self, a0, a1, a2)

    def set_is_optimized(self, a0, a1):
        r"""set_is_optimized(State self, FloatKey a0, bool a1)"""
        return _IMP_atom.State_set_is_optimized(self, a0, a1)

    def get_is_optimized(self, a0):
        r"""get_is_optimized(State self, FloatKey a0) -> bool"""
        return _IMP_atom.State_get_is_optimized(self, a0)

    def get_check_level(self):
        r"""get_check_level(State self) -> IMP::CheckLevel"""
        return _IMP_atom.State_get_check_level(self)

    def __eq__(self, *args):
        r"""
        __eq__(State self, State o) -> bool
        __eq__(State self, Particle d) -> bool
        """
        return _IMP_atom.State___eq__(self, *args)

    def __ne__(self, *args):
        r"""
        __ne__(State self, State o) -> bool
        __ne__(State self, Particle d) -> bool
        """
        return _IMP_atom.State___ne__(self, *args)

    def __le__(self, *args):
        r"""
        __le__(State self, State o) -> bool
        __le__(State self, Particle d) -> bool
        """
        return _IMP_atom.State___le__(self, *args)

    def __lt__(self, *args):
        r"""
        __lt__(State self, State o) -> bool
        __lt__(State self, Particle d) -> bool
        """
        return _IMP_atom.State___lt__(self, *args)

    def __ge__(self, *args):
        r"""
        __ge__(State self, State o) -> bool
        __ge__(State self, Particle d) -> bool
        """
        return _IMP_atom.State___ge__(self, *args)

    def __gt__(self, *args):
        r"""
        __gt__(State self, State o) -> bool
        __gt__(State self, Particle d) -> bool
        """
        return _IMP_atom.State___gt__(self, *args)

    def __hash__(self):
        r"""__hash__(State self) -> std::size_t"""
        return _IMP_atom.State___hash__(self)

    def __str__(self):
        r"""__str__(State self) -> std::string"""
        return _IMP_atom.State___str__(self)

    def __repr__(self):
        r"""__repr__(State self) -> std::string"""
        return _IMP_atom.State___repr__(self)
    __swig_destroy__ = _IMP_atom.delete_State

# Register State in _IMP_atom:
_IMP_atom.State_swigregister(State)

def State_setup_particle(*args):
    r"""
    State_setup_particle(Model m, ParticleIndex pi, unsigned int index) -> State
    State_setup_particle(_ParticleAdaptor decorator, unsigned int index) -> State
    State_setup_particle(Model m, ParticleIndex pi, State other) -> State
    State_setup_particle(_ParticleAdaptor decorator, State other) -> State
    """
    return _IMP_atom.State_setup_particle(*args)

def State_get_is_setup(*args):
    r"""
    State_get_is_setup(_ParticleAdaptor p) -> bool
    State_get_is_setup(Model m, ParticleIndex pi) -> bool
    """
    return _IMP_atom.State_get_is_setup(*args)


def get_state_index(h):
    r"""get_state_index(Hierarchy h) -> int"""
    return _IMP_atom.get_state_index(h)

def get_phi_dihedral_atoms(rd):
    r"""get_phi_dihedral_atoms(Residue rd) -> IMP::atom::Atoms"""
    return _IMP_atom.get_phi_dihedral_atoms(rd)

def get_psi_dihedral_atoms(rd):
    r"""get_psi_dihedral_atoms(Residue rd) -> IMP::atom::Atoms"""
    return _IMP_atom.get_psi_dihedral_atoms(rd)

def get_omega_dihedral_atoms(rd):
    r"""get_omega_dihedral_atoms(Residue rd) -> IMP::atom::Atoms"""
    return _IMP_atom.get_omega_dihedral_atoms(rd)

def get_chi_dihedral_atom_types(rt):
    r"""get_chi_dihedral_atom_types(ResidueType rt) -> IMP::Vector< IMP::atom::AtomTypes >"""
    return _IMP_atom.get_chi_dihedral_atom_types(rt)

def get_chi_dihedral_atoms(rd):
    r"""get_chi_dihedral_atoms(Residue rd) -> IMP::Vector< IMP::atom::Atoms >"""
    return _IMP_atom.get_chi_dihedral_atoms(rd)

def get_chi_dihedral_particle_indexes(rd):
    r"""get_chi_dihedral_particle_indexes(Residue rd) -> IMP::ParticleIndexQuads"""
    return _IMP_atom.get_chi_dihedral_particle_indexes(rd)
class Molecule(Hierarchy):
    r"""Proxy of C++ IMP::atom::Molecule class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(Molecule self) -> Molecule
        __init__(Molecule self, Model m, ParticleIndex id) -> Molecule
        __init__(Molecule self, _ParticleAdaptor d) -> Molecule
        """
        _IMP_atom.Molecule_swiginit(self, _IMP_atom.new_Molecule(*args))

    def show(self, *args):
        r"""show(Molecule self, _ostream out=std::cout)"""
        return _IMP_atom.Molecule_show(self, *args)

    @staticmethod
    def setup_particle(*args):
        r"""
        setup_particle(Model m, ParticleIndex pi) -> Molecule
        setup_particle(_ParticleAdaptor decorator) -> Molecule
        setup_particle(Model m, ParticleIndex pi, Molecule other) -> Molecule
        setup_particle(_ParticleAdaptor decorator, Molecule other) -> Molecule
        """
        return _IMP_atom.Molecule_setup_particle(*args)

    @staticmethod
    def get_is_setup(*args):
        r"""
        get_is_setup(_ParticleAdaptor p) -> bool
        get_is_setup(Model m, ParticleIndex pi) -> bool
        """
        return _IMP_atom.Molecule_get_is_setup(*args)

    def add_attribute(self, *args):
        r"""
        add_attribute(Molecule self, FloatKey k, IMP::Float v, bool opt)
        add_attribute(Molecule self, FloatKey a0, IMP::Float a1)
        add_attribute(Molecule self, IntKey a0, IMP::Int a1)
        add_attribute(Molecule self, FloatsKey a0, IMP::Floats a1)
        add_attribute(Molecule self, IntsKey a0, IMP::Ints a1)
        add_attribute(Molecule self, StringKey a0, IMP::String a1)
        add_attribute(Molecule self, ParticleIndexKey a0, Particle a1)
        add_attribute(Molecule self, ObjectKey a0, Object a1)
        """
        return _IMP_atom.Molecule_add_attribute(self, *args)

    def get_value(self, *args):
        r"""
        get_value(Molecule self, FloatKey a0) -> IMP::Float
        get_value(Molecule self, IntKey a0) -> IMP::Int
        get_value(Molecule self, FloatsKey a0) -> IMP::Floats
        get_value(Molecule self, IntsKey a0) -> IMP::Ints
        get_value(Molecule self, StringKey a0) -> IMP::String
        get_value(Molecule self, ParticleIndexKey a0) -> Particle
        get_value(Molecule self, ObjectKey a0) -> Object
        """
        return _IMP_atom.Molecule_get_value(self, *args)

    def set_value(self, *args):
        r"""
        set_value(Molecule self, FloatKey a0, IMP::Float a1)
        set_value(Molecule self, IntKey a0, IMP::Int a1)
        set_value(Molecule self, FloatsKey a0, IMP::Floats a1)
        set_value(Molecule self, IntsKey a0, IMP::Ints a1)
        set_value(Molecule self, StringKey a0, IMP::String a1)
        set_value(Molecule self, ParticleIndexKey a0, Particle a1)
        set_value(Molecule self, ObjectKey a0, Object a1)
        """
        return _IMP_atom.Molecule_set_value(self, *args)

    def remove_attribute(self, *args):
        r"""
        remove_attribute(Molecule self, FloatKey a0)
        remove_attribute(Molecule self, IntKey a0)
        remove_attribute(Molecule self, FloatsKey a0)
        remove_attribute(Molecule self, IntsKey a0)
        remove_attribute(Molecule self, StringKey a0)
        remove_attribute(Molecule self, ParticleIndexKey a0)
        remove_attribute(Molecule self, ObjectKey a0)
        """
        return _IMP_atom.Molecule_remove_attribute(self, *args)

    def has_attribute(self, *args):
        r"""
        has_attribute(Molecule self, FloatKey a0) -> bool
        has_attribute(Molecule self, IntKey a0) -> bool
        has_attribute(Molecule self, FloatsKey a0) -> bool
        has_attribute(Molecule self, IntsKey a0) -> bool
        has_attribute(Molecule self, StringKey a0) -> bool
        has_attribute(Molecule self, ParticleIndexKey a0) -> bool
        has_attribute(Molecule self, ObjectKey a0) -> bool
        """
        return _IMP_atom.Molecule_has_attribute(self, *args)

    def get_derivative(self, a0):
        r"""get_derivative(Molecule self, FloatKey a0) -> double"""
        return _IMP_atom.Molecule_get_derivative(self, a0)

    def get_name(self):
        r"""get_name(Molecule self) -> std::string"""
        return _IMP_atom.Molecule_get_name(self)

    def clear_caches(self):
        r"""clear_caches(Molecule self)"""
        return _IMP_atom.Molecule_clear_caches(self)

    def set_name(self, a0):
        r"""set_name(Molecule self, std::string a0)"""
        return _IMP_atom.Molecule_set_name(self, a0)

    def set_check_level(self, a0):
        r"""set_check_level(Molecule self, IMP::CheckLevel a0)"""
        return _IMP_atom.Molecule_set_check_level(self, a0)

    def add_to_derivative(self, a0, a1, a2):
        r"""add_to_derivative(Molecule self, FloatKey a0, double a1, DerivativeAccumulator a2)"""
        return _IMP_atom.Molecule_add_to_derivative(self, a0, a1, a2)

    def set_is_optimized(self, a0, a1):
        r"""set_is_optimized(Molecule self, FloatKey a0, bool a1)"""
        return _IMP_atom.Molecule_set_is_optimized(self, a0, a1)

    def get_is_optimized(self, a0):
        r"""get_is_optimized(Molecule self, FloatKey a0) -> bool"""
        return _IMP_atom.Molecule_get_is_optimized(self, a0)

    def get_check_level(self):
        r"""get_check_level(Molecule self) -> IMP::CheckLevel"""
        return _IMP_atom.Molecule_get_check_level(self)

    def __eq__(self, *args):
        r"""
        __eq__(Molecule self, Molecule o) -> bool
        __eq__(Molecule self, Particle d) -> bool
        """
        return _IMP_atom.Molecule___eq__(self, *args)

    def __ne__(self, *args):
        r"""
        __ne__(Molecule self, Molecule o) -> bool
        __ne__(Molecule self, Particle d) -> bool
        """
        return _IMP_atom.Molecule___ne__(self, *args)

    def __le__(self, *args):
        r"""
        __le__(Molecule self, Molecule o) -> bool
        __le__(Molecule self, Particle d) -> bool
        """
        return _IMP_atom.Molecule___le__(self, *args)

    def __lt__(self, *args):
        r"""
        __lt__(Molecule self, Molecule o) -> bool
        __lt__(Molecule self, Particle d) -> bool
        """
        return _IMP_atom.Molecule___lt__(self, *args)

    def __ge__(self, *args):
        r"""
        __ge__(Molecule self, Molecule o) -> bool
        __ge__(Molecule self, Particle d) -> bool
        """
        return _IMP_atom.Molecule___ge__(self, *args)

    def __gt__(self, *args):
        r"""
        __gt__(Molecule self, Molecule o) -> bool
        __gt__(Molecule self, Particle d) -> bool
        """
        return _IMP_atom.Molecule___gt__(self, *args)

    def __hash__(self):
        r"""__hash__(Molecule self) -> std::size_t"""
        return _IMP_atom.Molecule___hash__(self)

    def __str__(self):
        r"""__str__(Molecule self) -> std::string"""
        return _IMP_atom.Molecule___str__(self)

    def __repr__(self):
        r"""__repr__(Molecule self) -> std::string"""
        return _IMP_atom.Molecule___repr__(self)
    __swig_destroy__ = _IMP_atom.delete_Molecule

# Register Molecule in _IMP_atom:
_IMP_atom.Molecule_swigregister(Molecule)

def Molecule_setup_particle(*args):
    r"""
    Molecule_setup_particle(Model m, ParticleIndex pi) -> Molecule
    Molecule_setup_particle(_ParticleAdaptor decorator) -> Molecule
    Molecule_setup_particle(Model m, ParticleIndex pi, Molecule other) -> Molecule
    Molecule_setup_particle(_ParticleAdaptor decorator, Molecule other) -> Molecule
    """
    return _IMP_atom.Molecule_setup_particle(*args)

def Molecule_get_is_setup(*args):
    r"""
    Molecule_get_is_setup(_ParticleAdaptor p) -> bool
    Molecule_get_is_setup(Model m, ParticleIndex pi) -> bool
    """
    return _IMP_atom.Molecule_get_is_setup(*args)


def get_molecule_name(h):
    r"""get_molecule_name(Hierarchy h) -> std::string"""
    return _IMP_atom.get_molecule_name(h)
class Copy(Molecule):
    r"""Proxy of C++ IMP::atom::Copy class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    @staticmethod
    def get_copy_index_key():
        r"""get_copy_index_key() -> IntKey"""
        return _IMP_atom.Copy_get_copy_index_key()

    def __init__(self, *args):
        r"""
        __init__(Copy self) -> Copy
        __init__(Copy self, Model m, ParticleIndex id) -> Copy
        __init__(Copy self, _ParticleAdaptor d) -> Copy
        """
        _IMP_atom.Copy_swiginit(self, _IMP_atom.new_Copy(*args))

    def show(self, *args):
        r"""show(Copy self, _ostream out=std::cout)"""
        return _IMP_atom.Copy_show(self, *args)

    @staticmethod
    def setup_particle(*args):
        r"""
        setup_particle(Model m, ParticleIndex pi, IMP::Int number) -> Copy
        setup_particle(_ParticleAdaptor decorator, IMP::Int number) -> Copy
        """
        return _IMP_atom.Copy_setup_particle(*args)

    @staticmethod
    def get_is_setup(*args):
        r"""
        get_is_setup(_ParticleAdaptor p) -> bool
        get_is_setup(Model m, ParticleIndex pi) -> bool
        """
        return _IMP_atom.Copy_get_is_setup(*args)

    def get_copy_index(self):
        r"""get_copy_index(Copy self) -> int"""
        return _IMP_atom.Copy_get_copy_index(self)

    def add_attribute(self, *args):
        r"""
        add_attribute(Copy self, FloatKey k, IMP::Float v, bool opt)
        add_attribute(Copy self, FloatKey a0, IMP::Float a1)
        add_attribute(Copy self, IntKey a0, IMP::Int a1)
        add_attribute(Copy self, FloatsKey a0, IMP::Floats a1)
        add_attribute(Copy self, IntsKey a0, IMP::Ints a1)
        add_attribute(Copy self, StringKey a0, IMP::String a1)
        add_attribute(Copy self, ParticleIndexKey a0, Particle a1)
        add_attribute(Copy self, ObjectKey a0, Object a1)
        """
        return _IMP_atom.Copy_add_attribute(self, *args)

    def get_value(self, *args):
        r"""
        get_value(Copy self, FloatKey a0) -> IMP::Float
        get_value(Copy self, IntKey a0) -> IMP::Int
        get_value(Copy self, FloatsKey a0) -> IMP::Floats
        get_value(Copy self, IntsKey a0) -> IMP::Ints
        get_value(Copy self, StringKey a0) -> IMP::String
        get_value(Copy self, ParticleIndexKey a0) -> Particle
        get_value(Copy self, ObjectKey a0) -> Object
        """
        return _IMP_atom.Copy_get_value(self, *args)

    def set_value(self, *args):
        r"""
        set_value(Copy self, FloatKey a0, IMP::Float a1)
        set_value(Copy self, IntKey a0, IMP::Int a1)
        set_value(Copy self, FloatsKey a0, IMP::Floats a1)
        set_value(Copy self, IntsKey a0, IMP::Ints a1)
        set_value(Copy self, StringKey a0, IMP::String a1)
        set_value(Copy self, ParticleIndexKey a0, Particle a1)
        set_value(Copy self, ObjectKey a0, Object a1)
        """
        return _IMP_atom.Copy_set_value(self, *args)

    def remove_attribute(self, *args):
        r"""
        remove_attribute(Copy self, FloatKey a0)
        remove_attribute(Copy self, IntKey a0)
        remove_attribute(Copy self, FloatsKey a0)
        remove_attribute(Copy self, IntsKey a0)
        remove_attribute(Copy self, StringKey a0)
        remove_attribute(Copy self, ParticleIndexKey a0)
        remove_attribute(Copy self, ObjectKey a0)
        """
        return _IMP_atom.Copy_remove_attribute(self, *args)

    def has_attribute(self, *args):
        r"""
        has_attribute(Copy self, FloatKey a0) -> bool
        has_attribute(Copy self, IntKey a0) -> bool
        has_attribute(Copy self, FloatsKey a0) -> bool
        has_attribute(Copy self, IntsKey a0) -> bool
        has_attribute(Copy self, StringKey a0) -> bool
        has_attribute(Copy self, ParticleIndexKey a0) -> bool
        has_attribute(Copy self, ObjectKey a0) -> bool
        """
        return _IMP_atom.Copy_has_attribute(self, *args)

    def get_derivative(self, a0):
        r"""get_derivative(Copy self, FloatKey a0) -> double"""
        return _IMP_atom.Copy_get_derivative(self, a0)

    def get_name(self):
        r"""get_name(Copy self) -> std::string"""
        return _IMP_atom.Copy_get_name(self)

    def clear_caches(self):
        r"""clear_caches(Copy self)"""
        return _IMP_atom.Copy_clear_caches(self)

    def set_name(self, a0):
        r"""set_name(Copy self, std::string a0)"""
        return _IMP_atom.Copy_set_name(self, a0)

    def set_check_level(self, a0):
        r"""set_check_level(Copy self, IMP::CheckLevel a0)"""
        return _IMP_atom.Copy_set_check_level(self, a0)

    def add_to_derivative(self, a0, a1, a2):
        r"""add_to_derivative(Copy self, FloatKey a0, double a1, DerivativeAccumulator a2)"""
        return _IMP_atom.Copy_add_to_derivative(self, a0, a1, a2)

    def set_is_optimized(self, a0, a1):
        r"""set_is_optimized(Copy self, FloatKey a0, bool a1)"""
        return _IMP_atom.Copy_set_is_optimized(self, a0, a1)

    def get_is_optimized(self, a0):
        r"""get_is_optimized(Copy self, FloatKey a0) -> bool"""
        return _IMP_atom.Copy_get_is_optimized(self, a0)

    def get_check_level(self):
        r"""get_check_level(Copy self) -> IMP::CheckLevel"""
        return _IMP_atom.Copy_get_check_level(self)

    def __eq__(self, *args):
        r"""
        __eq__(Copy self, Copy o) -> bool
        __eq__(Copy self, Particle d) -> bool
        """
        return _IMP_atom.Copy___eq__(self, *args)

    def __ne__(self, *args):
        r"""
        __ne__(Copy self, Copy o) -> bool
        __ne__(Copy self, Particle d) -> bool
        """
        return _IMP_atom.Copy___ne__(self, *args)

    def __le__(self, *args):
        r"""
        __le__(Copy self, Copy o) -> bool
        __le__(Copy self, Particle d) -> bool
        """
        return _IMP_atom.Copy___le__(self, *args)

    def __lt__(self, *args):
        r"""
        __lt__(Copy self, Copy o) -> bool
        __lt__(Copy self, Particle d) -> bool
        """
        return _IMP_atom.Copy___lt__(self, *args)

    def __ge__(self, *args):
        r"""
        __ge__(Copy self, Copy o) -> bool
        __ge__(Copy self, Particle d) -> bool
        """
        return _IMP_atom.Copy___ge__(self, *args)

    def __gt__(self, *args):
        r"""
        __gt__(Copy self, Copy o) -> bool
        __gt__(Copy self, Particle d) -> bool
        """
        return _IMP_atom.Copy___gt__(self, *args)

    def __hash__(self):
        r"""__hash__(Copy self) -> std::size_t"""
        return _IMP_atom.Copy___hash__(self)

    def __str__(self):
        r"""__str__(Copy self) -> std::string"""
        return _IMP_atom.Copy___str__(self)

    def __repr__(self):
        r"""__repr__(Copy self) -> std::string"""
        return _IMP_atom.Copy___repr__(self)
    __swig_destroy__ = _IMP_atom.delete_Copy

# Register Copy in _IMP_atom:
_IMP_atom.Copy_swigregister(Copy)

def Copy_get_copy_index_key():
    r"""Copy_get_copy_index_key() -> IntKey"""
    return _IMP_atom.Copy_get_copy_index_key()

def Copy_setup_particle(*args):
    r"""
    Copy_setup_particle(Model m, ParticleIndex pi, IMP::Int number) -> Copy
    Copy_setup_particle(_ParticleAdaptor decorator, IMP::Int number) -> Copy
    """
    return _IMP_atom.Copy_setup_particle(*args)

def Copy_get_is_setup(*args):
    r"""
    Copy_get_is_setup(_ParticleAdaptor p) -> bool
    Copy_get_is_setup(Model m, ParticleIndex pi) -> bool
    """
    return _IMP_atom.Copy_get_is_setup(*args)


def get_copy_index(h):
    r"""get_copy_index(Hierarchy h) -> int"""
    return _IMP_atom.get_copy_index(h)
class Selection(IMP._ParticleIndexesAdaptor):
    r"""Proxy of C++ IMP::atom::Selection class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    NONE = _IMP_atom.Selection_NONE
    
    C = _IMP_atom.Selection_C
    
    N = _IMP_atom.Selection_N
    

    def __init__(self, *args):
        r"""
        __init__(Selection self) -> Selection
        __init__(Selection self, Hierarchy h) -> Selection
        __init__(Selection self, Particle h) -> Selection
        __init__(Selection self, Model m, IMP::ParticleIndexes const & pis) -> Selection
        __init__(Selection self, IMP::ParticlesTemp const & h) -> Selection
        """
        _IMP_atom.Selection_swiginit(self, _IMP_atom.new_Selection(*args))

    def create_clone(self):
        r"""create_clone(Selection self) -> Selection"""
        return _IMP_atom.Selection_create_clone(self)

    def get_hierarchies(self):
        r"""get_hierarchies(Selection self) -> IMP::atom::Hierarchies"""
        return _IMP_atom.Selection_get_hierarchies(self)

    def set_molecules(self, mols):
        r"""set_molecules(Selection self, IMP::Strings mols)"""
        return _IMP_atom.Selection_set_molecules(self, mols)

    def set_resolution(self, r):
        r"""set_resolution(Selection self, double r)"""
        return _IMP_atom.Selection_set_resolution(self, r)

    def set_representation_type(self, t):
        r"""set_representation_type(Selection self, IMP::atom::RepresentationType t)"""
        return _IMP_atom.Selection_set_representation_type(self, t)

    def set_state_index(self, state):
        r"""set_state_index(Selection self, int state)"""
        return _IMP_atom.Selection_set_state_index(self, state)

    def set_state_indexes(self, states):
        r"""set_state_indexes(Selection self, IMP::Ints states)"""
        return _IMP_atom.Selection_set_state_indexes(self, states)

    def set_terminus(self, t):
        r"""set_terminus(Selection self, IMP::atom::Selection::Terminus t)"""
        return _IMP_atom.Selection_set_terminus(self, t)

    def set_element(self, e):
        r"""set_element(Selection self, IMP::atom::Element e)"""
        return _IMP_atom.Selection_set_element(self, e)

    def set_chain_ids(self, chains):
        r"""set_chain_ids(Selection self, IMP::Strings chains)"""
        return _IMP_atom.Selection_set_chain_ids(self, chains)

    def set_chains(self, chains):
        r"""set_chains(Selection self, IMP::Strings chains)"""
        return _IMP_atom.Selection_set_chains(self, chains)

    def set_residue_indexes(self, indexes):
        r"""set_residue_indexes(Selection self, IMP::Ints indexes)"""
        return _IMP_atom.Selection_set_residue_indexes(self, indexes)

    def set_atom_types(self, types):
        r"""set_atom_types(Selection self, IMP::atom::AtomTypes types)"""
        return _IMP_atom.Selection_set_atom_types(self, types)

    def set_residue_types(self, types):
        r"""set_residue_types(Selection self, IMP::atom::ResidueTypes types)"""
        return _IMP_atom.Selection_set_residue_types(self, types)

    def set_domains(self, names):
        r"""set_domains(Selection self, IMP::Strings names)"""
        return _IMP_atom.Selection_set_domains(self, names)

    def set_molecule(self, mol):
        r"""set_molecule(Selection self, std::string mol)"""
        return _IMP_atom.Selection_set_molecule(self, mol)

    def set_chain_id(self, c):
        r"""set_chain_id(Selection self, std::string c)"""
        return _IMP_atom.Selection_set_chain_id(self, c)

    def set_chain(self, c):
        r"""set_chain(Selection self, std::string c)"""
        return _IMP_atom.Selection_set_chain(self, c)

    def set_residue_index(self, i):
        r"""set_residue_index(Selection self, int i)"""
        return _IMP_atom.Selection_set_residue_index(self, i)

    def set_atom_type(self, types):
        r"""set_atom_type(Selection self, AtomType types)"""
        return _IMP_atom.Selection_set_atom_type(self, types)

    def set_residue_type(self, type):
        r"""set_residue_type(Selection self, ResidueType type)"""
        return _IMP_atom.Selection_set_residue_type(self, type)

    def set_domain(self, name):
        r"""set_domain(Selection self, std::string name)"""
        return _IMP_atom.Selection_set_domain(self, name)

    def set_copy_index(self, copy):
        r"""set_copy_index(Selection self, unsigned int copy)"""
        return _IMP_atom.Selection_set_copy_index(self, copy)

    def set_copy_indexes(self, copies):
        r"""set_copy_indexes(Selection self, IMP::Ints copies)"""
        return _IMP_atom.Selection_set_copy_indexes(self, copies)

    def set_particle_type(self, t):
        r"""set_particle_type(Selection self, ParticleType t)"""
        return _IMP_atom.Selection_set_particle_type(self, t)

    def set_particle_types(self, t):
        r"""set_particle_types(Selection self, IMP::core::ParticleTypes t)"""
        return _IMP_atom.Selection_set_particle_types(self, t)

    def set_hierarchy_types(self, types):
        r"""set_hierarchy_types(Selection self, IMP::Ints types)"""
        return _IMP_atom.Selection_set_hierarchy_types(self, types)

    def set_intersection(self, s):
        r"""set_intersection(Selection self, Selection s)"""
        return _IMP_atom.Selection_set_intersection(self, s)

    def set_union(self, s):
        r"""set_union(Selection self, Selection s)"""
        return _IMP_atom.Selection_set_union(self, s)

    def set_symmetric_difference(self, s):
        r"""set_symmetric_difference(Selection self, Selection s)"""
        return _IMP_atom.Selection_set_symmetric_difference(self, s)

    def set_difference(self, s):
        r"""set_difference(Selection self, Selection s)"""
        return _IMP_atom.Selection_set_difference(self, s)

    def get_selected_particles(self, with_representation=True):
        r"""get_selected_particles(Selection self, bool with_representation=True) -> IMP::ParticlesTemp"""
        return _IMP_atom.Selection_get_selected_particles(self, with_representation)

    def get_selected_particle_indexes(self, with_representation=True):
        r"""get_selected_particle_indexes(Selection self, bool with_representation=True) -> IMP::ParticleIndexes"""
        return _IMP_atom.Selection_get_selected_particle_indexes(self, with_representation)

    def show(self, *args):
        r"""show(Selection self, _ostream out=std::cout)"""
        return _IMP_atom.Selection_show(self, *args)

    def __str__(self):
        r"""__str__(Selection self) -> std::string"""
        return _IMP_atom.Selection___str__(self)

    def __repr__(self):
        r"""__repr__(Selection self) -> std::string"""
        return _IMP_atom.Selection___repr__(self)

    def __init__(self, hierarchy=None,
                 hierarchies=None, **params):
        if hierarchy and hierarchies:
          raise RuntimeError("You can't pass both hierarchy and hierarchies to Selection")
        if hierarchy:
          this = _IMP_atom.new_Selection(hierarchy)
          try: self.this.append(this)
          except: self.this = this
        elif hierarchies:
          this = _IMP_atom.new_Selection(hierarchies)
          try: self.this.append(this)
          except: self.this = this
        else:
          raise ValueError("Either hierarchy or hierarchies must be provided.")
        for k in params.keys():
          eval("self.set_%s(params[k])"%k)

    def union(self, s):
        news = self.create_clone()
        news.union_update(s)
        return news
    def intersection(self, s):
        news = self.create_clone()
        news.intersection_update(s)
        return news
    def symmetric_difference(self, s):
        news = self.create_clone()
        news.symmetric_difference_update(s)
        return news
    def difference(self, s):
        news = self.create_clone()
        news.difference_update(s)
        return news
    def union_update(self, s):
        self.set_union(s)
        return self
    def intersection_update(self, s):
        self.set_intersection(s)
        return self
    def symmetric_difference_update(self, s):
        self.set_symmetric_difference(s)
        return self
    def difference_update(self, s):
        self.set_difference(s)
        return self
    __or__ = union
    __and__ = intersection
    __xor__ = symmetric_difference
    __sub__ = difference
    __ior__ = union_update
    __iand__ = intersection_update
    __ixor__ = symmetric_difference_update
    __isub__ = difference_update

    __swig_destroy__ = _IMP_atom.delete_Selection

# Register Selection in _IMP_atom:
_IMP_atom.Selection_swigregister(Selection)


def create_distance_restraint(*args):
    r"""create_distance_restraint(Selection n0, Selection n1, double x0, double k, std::string name="Distance%1%") -> Restraint"""
    return _IMP_atom.create_distance_restraint(*args)

def create_connectivity_restraint(*args):
    r"""
    create_connectivity_restraint(IMP::atom::Selections const & s, double k, std::string name="Connectivity%1%") -> Restraint
    create_connectivity_restraint(IMP::atom::Selections const & s, double x0, double k, std::string name="Connectivity%1%") -> Restraint
    """
    return _IMP_atom.create_connectivity_restraint(*args)

def create_internal_connectivity_restraint(*args):
    r"""
    create_internal_connectivity_restraint(Selection s, double k, std::string name="Connectivity%1%") -> Restraint
    create_internal_connectivity_restraint(Selection s, double x0, double k, std::string name="Connectivity%1%") -> Restraint
    """
    return _IMP_atom.create_internal_connectivity_restraint(*args)

def create_cover(*args):
    r"""create_cover(Selection s, std::string name=std::string()) -> XYZR"""
    return _IMP_atom.create_cover(*args)

def get_mass(*args):
    r"""
    get_mass(ResidueType c) -> double
    get_mass(Selection s) -> double
    """
    return _IMP_atom.get_mass(*args)

def get_volume(s):
    r"""get_volume(Selection s) -> double"""
    return _IMP_atom.get_volume(s)

def get_surface_area(s):
    r"""get_surface_area(Selection s) -> double"""
    return _IMP_atom.get_surface_area(s)

def get_leaves(*args):
    r"""
    get_leaves(Hierarchy h) -> IMP::atom::Hierarchies
    get_leaves(IMP::atom::Hierarchies const & h) -> IMP::atom::Hierarchies
    get_leaves(Selection h) -> IMP::atom::Hierarchies
    """
    return _IMP_atom.get_leaves(*args)
class SelectionGeometry(IMP.display.Geometry):
    r"""Proxy of C++ IMP::atom::SelectionGeometry class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""__init__(SelectionGeometry self, Selection d, std::string name="Selection") -> SelectionGeometry"""
        _IMP_atom.SelectionGeometry_swiginit(self, _IMP_atom.new_SelectionGeometry(*args))

    def get_version_info(self):
        r"""get_version_info(SelectionGeometry self) -> VersionInfo"""
        return _IMP_atom.SelectionGeometry_get_version_info(self)

    def __str__(self):
        r"""__str__(SelectionGeometry self) -> std::string"""
        return _IMP_atom.SelectionGeometry___str__(self)

    def __repr__(self):
        r"""__repr__(SelectionGeometry self) -> std::string"""
        return _IMP_atom.SelectionGeometry___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_SelectionGeometry(o)


# Register SelectionGeometry in _IMP_atom:
_IMP_atom.SelectionGeometry_swigregister(SelectionGeometry)


def get_rmsd(*args):
    r"""
    get_rmsd(IMP::core::XYZs const & s0, IMP::core::XYZs const & s1) -> double
    get_rmsd(Selection s0, Selection s1) -> double
    """
    return _IMP_atom.get_rmsd(*args)

def get_rmsd_transforming_first(*args):
    r"""
    get_rmsd_transforming_first(Transformation3D tr, IMP::core::XYZs const & s0, IMP::core::XYZs const & s1) -> double
    get_rmsd_transforming_first(Transformation3D tr, Selection s0, Selection s1) -> double
    """
    return _IMP_atom.get_rmsd_transforming_first(*args)

def get_placement_score(source, target):
    r"""get_placement_score(IMP::core::XYZs const & source, IMP::core::XYZs const & target) -> IMP::FloatPair"""
    return _IMP_atom.get_placement_score(source, target)

def get_component_placement_score(ref1, ref2, mdl1, mdl2):
    r"""get_component_placement_score(IMP::core::XYZs const & ref1, IMP::core::XYZs const & ref2, IMP::core::XYZs const & mdl1, IMP::core::XYZs const & mdl2) -> IMP::FloatPair"""
    return _IMP_atom.get_component_placement_score(ref1, ref2, mdl1, mdl2)

def get_pairwise_rmsd_score(ref1, ref2, mdl1, mdl2):
    r"""get_pairwise_rmsd_score(IMP::core::XYZs const & ref1, IMP::core::XYZs const & ref2, IMP::core::XYZs const & mdl1, IMP::core::XYZs const & mdl2) -> double"""
    return _IMP_atom.get_pairwise_rmsd_score(ref1, ref2, mdl1, mdl2)

def get_radius_of_gyration(*args):
    r"""
    get_radius_of_gyration(Selection s) -> double
    get_radius_of_gyration(IMP::ParticlesTemp const & ps, bool weighted=True) -> double
    """
    return _IMP_atom.get_radius_of_gyration(*args)
class ForceFieldParameters(IMP.Object):
    r"""Proxy of C++ IMP::atom::ForceFieldParameters class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self):
        r"""__init__(ForceFieldParameters self) -> ForceFieldParameters"""
        _IMP_atom.ForceFieldParameters_swiginit(self, _IMP_atom.new_ForceFieldParameters())

    def get_radius(self, atom):
        r"""get_radius(ForceFieldParameters self, Atom atom) -> IMP::Float"""
        return _IMP_atom.ForceFieldParameters_get_radius(self, atom)

    def get_epsilon(self, atom):
        r"""get_epsilon(ForceFieldParameters self, Atom atom) -> IMP::Float"""
        return _IMP_atom.ForceFieldParameters_get_epsilon(self, atom)

    def add_radii(self, *args):
        r"""add_radii(ForceFieldParameters self, Hierarchy mhd, double scale=1.0, FloatKey radius_key=FloatKey("radius"))"""
        return _IMP_atom.ForceFieldParameters_add_radii(self, *args)

    def add_well_depths(self, mhd):
        r"""add_well_depths(ForceFieldParameters self, Hierarchy mhd)"""
        return _IMP_atom.ForceFieldParameters_add_well_depths(self, mhd)

    def add_bonds(self, mhd):
        r"""add_bonds(ForceFieldParameters self, Hierarchy mhd)"""
        return _IMP_atom.ForceFieldParameters_add_bonds(self, mhd)
    __swig_destroy__ = _IMP_atom.delete_ForceFieldParameters

    def __str__(self):
        r"""__str__(ForceFieldParameters self) -> std::string"""
        return _IMP_atom.ForceFieldParameters___str__(self)

    def __repr__(self):
        r"""__repr__(ForceFieldParameters self) -> std::string"""
        return _IMP_atom.ForceFieldParameters___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_ForceFieldParameters(o)


# Register ForceFieldParameters in _IMP_atom:
_IMP_atom.ForceFieldParameters_swigregister(ForceFieldParameters)

class CHARMMAtomTopology(object):
    r"""Proxy of C++ IMP::atom::CHARMMAtomTopology class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(CHARMMAtomTopology self, std::string name) -> CHARMMAtomTopology
        __init__(CHARMMAtomTopology self, std::string name, CHARMMAtomTopology other) -> CHARMMAtomTopology
        """
        _IMP_atom.CHARMMAtomTopology_swiginit(self, _IMP_atom.new_CHARMMAtomTopology(*args))

    def get_name(self):
        r"""get_name(CHARMMAtomTopology self) -> std::string"""
        return _IMP_atom.CHARMMAtomTopology_get_name(self)

    def get_charmm_type(self):
        r"""get_charmm_type(CHARMMAtomTopology self) -> std::string"""
        return _IMP_atom.CHARMMAtomTopology_get_charmm_type(self)

    def get_charge(self):
        r"""get_charge(CHARMMAtomTopology self) -> double"""
        return _IMP_atom.CHARMMAtomTopology_get_charge(self)

    def set_charmm_type(self, charmm_type):
        r"""set_charmm_type(CHARMMAtomTopology self, std::string charmm_type)"""
        return _IMP_atom.CHARMMAtomTopology_set_charmm_type(self, charmm_type)

    def set_charge(self, charge):
        r"""set_charge(CHARMMAtomTopology self, double charge)"""
        return _IMP_atom.CHARMMAtomTopology_set_charge(self, charge)

    def show(self, *args):
        r"""show(CHARMMAtomTopology self, _ostream out=std::cout)"""
        return _IMP_atom.CHARMMAtomTopology_show(self, *args)

    def __str__(self):
        r"""__str__(CHARMMAtomTopology self) -> std::string"""
        return _IMP_atom.CHARMMAtomTopology___str__(self)

    def __repr__(self):
        r"""__repr__(CHARMMAtomTopology self) -> std::string"""
        return _IMP_atom.CHARMMAtomTopology___repr__(self)
    __swig_destroy__ = _IMP_atom.delete_CHARMMAtomTopology

# Register CHARMMAtomTopology in _IMP_atom:
_IMP_atom.CHARMMAtomTopology_swigregister(CHARMMAtomTopology)

class CHARMMBondEndpoint(object):
    r"""Proxy of C++ IMP::atom::CHARMMBondEndpoint class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, atom_name, residue=None):
        r"""__init__(CHARMMBondEndpoint self, std::string atom_name, CHARMMResidueTopology residue=None) -> CHARMMBondEndpoint"""
        _IMP_atom.CHARMMBondEndpoint_swiginit(self, _IMP_atom.new_CHARMMBondEndpoint(atom_name, residue))

    def get_atom_name(self):
        r"""get_atom_name(CHARMMBondEndpoint self) -> std::string"""
        return _IMP_atom.CHARMMBondEndpoint_get_atom_name(self)

    def get_atom(self, current_residue, previous_residue, next_residue, resmap):
        r"""get_atom(CHARMMBondEndpoint self, CHARMMResidueTopology current_residue, CHARMMResidueTopology previous_residue, CHARMMResidueTopology next_residue, std::map< IMP::atom::CHARMMResidueTopology const *,IMP::atom::Hierarchy > const & resmap) -> Atom"""
        return _IMP_atom.CHARMMBondEndpoint_get_atom(self, current_residue, previous_residue, next_residue, resmap)

    def show(self, *args):
        r"""show(CHARMMBondEndpoint self, _ostream out=std::cout)"""
        return _IMP_atom.CHARMMBondEndpoint_show(self, *args)

    def __str__(self):
        r"""__str__(CHARMMBondEndpoint self) -> std::string"""
        return _IMP_atom.CHARMMBondEndpoint___str__(self)

    def __repr__(self):
        r"""__repr__(CHARMMBondEndpoint self) -> std::string"""
        return _IMP_atom.CHARMMBondEndpoint___repr__(self)
    __swig_destroy__ = _IMP_atom.delete_CHARMMBondEndpoint

# Register CHARMMBondEndpoint in _IMP_atom:
_IMP_atom.CHARMMBondEndpoint_swigregister(CHARMMBondEndpoint)

class CHARMMDihedral(object):
    r"""Proxy of C++ IMP::atom::CHARMMConnection< 4 > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, atoms):
        r"""__init__(CHARMMDihedral self, IMP::Strings const & atoms) -> CHARMMDihedral"""
        _IMP_atom.CHARMMDihedral_swiginit(self, _IMP_atom.new_CHARMMDihedral(atoms))

    def get_endpoint(self, i):
        r"""get_endpoint(CHARMMDihedral self, unsigned int i) -> CHARMMBondEndpoint"""
        return _IMP_atom.CHARMMDihedral_get_endpoint(self, i)

    def get_contains_atom(self, name):
        r"""get_contains_atom(CHARMMDihedral self, std::string name) -> bool"""
        return _IMP_atom.CHARMMDihedral_get_contains_atom(self, name)

    def show(self, *args):
        r"""show(CHARMMDihedral self, _ostream out=std::cout)"""
        return _IMP_atom.CHARMMDihedral_show(self, *args)
    __swig_destroy__ = _IMP_atom.delete_CHARMMDihedral

# Register CHARMMDihedral in _IMP_atom:
_IMP_atom.CHARMMDihedral_swigregister(CHARMMDihedral)

class CHARMMInternalCoordinate(CHARMMDihedral):
    r"""Proxy of C++ IMP::atom::CHARMMInternalCoordinate class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(CHARMMInternalCoordinate self, IMP::Strings const & atoms, float first_distance, float first_angle, float dihedral, float second_angle, float second_distance, bool improper) -> CHARMMInternalCoordinate
        __init__(CHARMMInternalCoordinate self, IMP::Vector< IMP::atom::CHARMMBondEndpoint > const endpoints, float first_distance, float first_angle, float dihedral, float second_angle, float second_distance, bool improper) -> CHARMMInternalCoordinate
        """
        _IMP_atom.CHARMMInternalCoordinate_swiginit(self, _IMP_atom.new_CHARMMInternalCoordinate(*args))

    def get_first_distance(self):
        r"""get_first_distance(CHARMMInternalCoordinate self) -> float"""
        return _IMP_atom.CHARMMInternalCoordinate_get_first_distance(self)

    def get_second_distance(self):
        r"""get_second_distance(CHARMMInternalCoordinate self) -> float"""
        return _IMP_atom.CHARMMInternalCoordinate_get_second_distance(self)

    def get_first_angle(self):
        r"""get_first_angle(CHARMMInternalCoordinate self) -> float"""
        return _IMP_atom.CHARMMInternalCoordinate_get_first_angle(self)

    def get_second_angle(self):
        r"""get_second_angle(CHARMMInternalCoordinate self) -> float"""
        return _IMP_atom.CHARMMInternalCoordinate_get_second_angle(self)

    def get_dihedral(self):
        r"""get_dihedral(CHARMMInternalCoordinate self) -> float"""
        return _IMP_atom.CHARMMInternalCoordinate_get_dihedral(self)

    def get_improper(self):
        r"""get_improper(CHARMMInternalCoordinate self) -> bool"""
        return _IMP_atom.CHARMMInternalCoordinate_get_improper(self)

    def show(self, *args):
        r"""show(CHARMMInternalCoordinate self, _ostream out=std::cout)"""
        return _IMP_atom.CHARMMInternalCoordinate_show(self, *args)

    def __str__(self):
        r"""__str__(CHARMMInternalCoordinate self) -> std::string"""
        return _IMP_atom.CHARMMInternalCoordinate___str__(self)

    def __repr__(self):
        r"""__repr__(CHARMMInternalCoordinate self) -> std::string"""
        return _IMP_atom.CHARMMInternalCoordinate___repr__(self)
    __swig_destroy__ = _IMP_atom.delete_CHARMMInternalCoordinate

# Register CHARMMInternalCoordinate in _IMP_atom:
_IMP_atom.CHARMMInternalCoordinate_swigregister(CHARMMInternalCoordinate)

class CHARMMResidueTopologyBase(IMP.Object):
    r"""Proxy of C++ IMP::atom::CHARMMResidueTopologyBase class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")

    def get_type(self):
        r"""get_type(CHARMMResidueTopologyBase self) -> std::string"""
        return _IMP_atom.CHARMMResidueTopologyBase_get_type(self)

    def get_number_of_atoms(self):
        r"""get_number_of_atoms(CHARMMResidueTopologyBase self) -> unsigned int"""
        return _IMP_atom.CHARMMResidueTopologyBase_get_number_of_atoms(self)

    def add_atom(self, atom):
        r"""add_atom(CHARMMResidueTopologyBase self, CHARMMAtomTopology atom)"""
        return _IMP_atom.CHARMMResidueTopologyBase_add_atom(self, atom)

    def get_atom(self, *args):
        r"""
        get_atom(CHARMMResidueTopologyBase self, unsigned int i) -> CHARMMAtomTopology
        get_atom(CHARMMResidueTopologyBase self, AtomType type) -> CHARMMAtomTopology
        get_atom(CHARMMResidueTopologyBase self, std::string name) -> CHARMMAtomTopology
        """
        return _IMP_atom.CHARMMResidueTopologyBase_get_atom(self, *args)

    def get_number_of_bonds(self):
        r"""get_number_of_bonds(CHARMMResidueTopologyBase self) -> unsigned int"""
        return _IMP_atom.CHARMMResidueTopologyBase_get_number_of_bonds(self)

    def add_bond(self, bond):
        r"""add_bond(CHARMMResidueTopologyBase self, CHARMMBond bond)"""
        return _IMP_atom.CHARMMResidueTopologyBase_add_bond(self, bond)

    def get_number_of_angles(self):
        r"""get_number_of_angles(CHARMMResidueTopologyBase self) -> unsigned int"""
        return _IMP_atom.CHARMMResidueTopologyBase_get_number_of_angles(self)

    def add_angle(self, bond):
        r"""add_angle(CHARMMResidueTopologyBase self, CHARMMAngle bond)"""
        return _IMP_atom.CHARMMResidueTopologyBase_add_angle(self, bond)

    def get_number_of_dihedrals(self):
        r"""get_number_of_dihedrals(CHARMMResidueTopologyBase self) -> unsigned int"""
        return _IMP_atom.CHARMMResidueTopologyBase_get_number_of_dihedrals(self)

    def add_dihedral(self, bond):
        r"""add_dihedral(CHARMMResidueTopologyBase self, CHARMMDihedral bond)"""
        return _IMP_atom.CHARMMResidueTopologyBase_add_dihedral(self, bond)

    def get_number_of_impropers(self):
        r"""get_number_of_impropers(CHARMMResidueTopologyBase self) -> unsigned int"""
        return _IMP_atom.CHARMMResidueTopologyBase_get_number_of_impropers(self)

    def add_improper(self, bond):
        r"""add_improper(CHARMMResidueTopologyBase self, CHARMMDihedral bond)"""
        return _IMP_atom.CHARMMResidueTopologyBase_add_improper(self, bond)

    def get_number_of_internal_coordinates(self):
        r"""get_number_of_internal_coordinates(CHARMMResidueTopologyBase self) -> unsigned int"""
        return _IMP_atom.CHARMMResidueTopologyBase_get_number_of_internal_coordinates(self)

    def add_internal_coordinate(self, ic):
        r"""add_internal_coordinate(CHARMMResidueTopologyBase self, CHARMMInternalCoordinate ic)"""
        return _IMP_atom.CHARMMResidueTopologyBase_add_internal_coordinate(self, ic)

    def get_internal_coordinate(self, index):
        r"""get_internal_coordinate(CHARMMResidueTopologyBase self, unsigned int index) -> CHARMMInternalCoordinate"""
        return _IMP_atom.CHARMMResidueTopologyBase_get_internal_coordinate(self, index)

    def get_bond(self, index):
        r"""get_bond(CHARMMResidueTopologyBase self, unsigned int index) -> CHARMMBond"""
        return _IMP_atom.CHARMMResidueTopologyBase_get_bond(self, index)

    def get_angle(self, index):
        r"""get_angle(CHARMMResidueTopologyBase self, unsigned int index) -> CHARMMAngle"""
        return _IMP_atom.CHARMMResidueTopologyBase_get_angle(self, index)

    def get_dihedral(self, index):
        r"""get_dihedral(CHARMMResidueTopologyBase self, unsigned int index) -> CHARMMDihedral"""
        return _IMP_atom.CHARMMResidueTopologyBase_get_dihedral(self, index)

    def get_improper(self, index):
        r"""get_improper(CHARMMResidueTopologyBase self, unsigned int index) -> CHARMMDihedral"""
        return _IMP_atom.CHARMMResidueTopologyBase_get_improper(self, index)

    def get_version_info(self):
        r"""get_version_info(CHARMMResidueTopologyBase self) -> VersionInfo"""
        return _IMP_atom.CHARMMResidueTopologyBase_get_version_info(self)

    def __str__(self):
        r"""__str__(CHARMMResidueTopologyBase self) -> std::string"""
        return _IMP_atom.CHARMMResidueTopologyBase___str__(self)

    def __repr__(self):
        r"""__repr__(CHARMMResidueTopologyBase self) -> std::string"""
        return _IMP_atom.CHARMMResidueTopologyBase___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_CHARMMResidueTopologyBase(o)


# Register CHARMMResidueTopologyBase in _IMP_atom:
_IMP_atom.CHARMMResidueTopologyBase_swigregister(CHARMMResidueTopologyBase)

class CHARMMIdealResidueTopology(CHARMMResidueTopologyBase):
    r"""Proxy of C++ IMP::atom::CHARMMIdealResidueTopology class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(CHARMMIdealResidueTopology self, std::string type) -> CHARMMIdealResidueTopology
        __init__(CHARMMIdealResidueTopology self, ResidueType type) -> CHARMMIdealResidueTopology
        """
        _IMP_atom.CHARMMIdealResidueTopology_swiginit(self, _IMP_atom.new_CHARMMIdealResidueTopology(*args))

    def remove_atom(self, name):
        r"""remove_atom(CHARMMIdealResidueTopology self, std::string name)"""
        return _IMP_atom.CHARMMIdealResidueTopology_remove_atom(self, name)

    def set_default_first_patch(self, patch):
        r"""set_default_first_patch(CHARMMIdealResidueTopology self, std::string patch)"""
        return _IMP_atom.CHARMMIdealResidueTopology_set_default_first_patch(self, patch)

    def set_default_last_patch(self, patch):
        r"""set_default_last_patch(CHARMMIdealResidueTopology self, std::string patch)"""
        return _IMP_atom.CHARMMIdealResidueTopology_set_default_last_patch(self, patch)

    def get_default_first_patch(self):
        r"""get_default_first_patch(CHARMMIdealResidueTopology self) -> std::string"""
        return _IMP_atom.CHARMMIdealResidueTopology_get_default_first_patch(self)

    def get_default_last_patch(self):
        r"""get_default_last_patch(CHARMMIdealResidueTopology self) -> std::string"""
        return _IMP_atom.CHARMMIdealResidueTopology_get_default_last_patch(self)

    def __str__(self):
        r"""__str__(CHARMMIdealResidueTopology self) -> std::string"""
        return _IMP_atom.CHARMMIdealResidueTopology___str__(self)

    def __repr__(self):
        r"""__repr__(CHARMMIdealResidueTopology self) -> std::string"""
        return _IMP_atom.CHARMMIdealResidueTopology___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_CHARMMIdealResidueTopology(o)


# Register CHARMMIdealResidueTopology in _IMP_atom:
_IMP_atom.CHARMMIdealResidueTopology_swigregister(CHARMMIdealResidueTopology)

class CHARMMPatch(CHARMMResidueTopologyBase):
    r"""Proxy of C++ IMP::atom::CHARMMPatch class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, type):
        r"""__init__(CHARMMPatch self, std::string type) -> CHARMMPatch"""
        _IMP_atom.CHARMMPatch_swiginit(self, _IMP_atom.new_CHARMMPatch(type))

    def add_removed_atom(self, name):
        r"""add_removed_atom(CHARMMPatch self, std::string name)"""
        return _IMP_atom.CHARMMPatch_add_removed_atom(self, name)

    def get_number_of_removed_atoms(self):
        r"""get_number_of_removed_atoms(CHARMMPatch self) -> unsigned int"""
        return _IMP_atom.CHARMMPatch_get_number_of_removed_atoms(self)

    def get_removed_atom(self, i):
        r"""get_removed_atom(CHARMMPatch self, unsigned int i) -> std::string"""
        return _IMP_atom.CHARMMPatch_get_removed_atom(self, i)

    def apply(self, *args):
        r"""
        apply(CHARMMPatch self, CHARMMResidueTopology res)
        apply(CHARMMPatch self, CHARMMResidueTopology res1, CHARMMResidueTopology res2)
        """
        return _IMP_atom.CHARMMPatch_apply(self, *args)

    def __str__(self):
        r"""__str__(CHARMMPatch self) -> std::string"""
        return _IMP_atom.CHARMMPatch___str__(self)

    def __repr__(self):
        r"""__repr__(CHARMMPatch self) -> std::string"""
        return _IMP_atom.CHARMMPatch___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_CHARMMPatch(o)


# Register CHARMMPatch in _IMP_atom:
_IMP_atom.CHARMMPatch_swigregister(CHARMMPatch)

class CHARMMResidueTopology(CHARMMIdealResidueTopology):
    r"""Proxy of C++ IMP::atom::CHARMMResidueTopology class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(CHARMMResidueTopology self, ResidueType type) -> CHARMMResidueTopology
        __init__(CHARMMResidueTopology self, CHARMMIdealResidueTopology ideal) -> CHARMMResidueTopology
        """
        _IMP_atom.CHARMMResidueTopology_swiginit(self, _IMP_atom.new_CHARMMResidueTopology(*args))

    def get_patched(self):
        r"""get_patched(CHARMMResidueTopology self) -> bool"""
        return _IMP_atom.CHARMMResidueTopology_get_patched(self)

    def set_patched(self, patched):
        r"""set_patched(CHARMMResidueTopology self, bool patched)"""
        return _IMP_atom.CHARMMResidueTopology_set_patched(self, patched)

    def __str__(self):
        r"""__str__(CHARMMResidueTopology self) -> std::string"""
        return _IMP_atom.CHARMMResidueTopology___str__(self)

    def __repr__(self):
        r"""__repr__(CHARMMResidueTopology self) -> std::string"""
        return _IMP_atom.CHARMMResidueTopology___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_CHARMMResidueTopology(o)


# Register CHARMMResidueTopology in _IMP_atom:
_IMP_atom.CHARMMResidueTopology_swigregister(CHARMMResidueTopology)

class CHARMMAtom(Atom):
    r"""Proxy of C++ IMP::atom::CHARMMAtom class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(CHARMMAtom self) -> CHARMMAtom
        __init__(CHARMMAtom self, Model m, ParticleIndex id) -> CHARMMAtom
        __init__(CHARMMAtom self, _ParticleAdaptor d) -> CHARMMAtom
        """
        _IMP_atom.CHARMMAtom_swiginit(self, _IMP_atom.new_CHARMMAtom(*args))

    def show(self, *args):
        r"""show(CHARMMAtom self, _ostream out=std::cout)"""
        return _IMP_atom.CHARMMAtom_show(self, *args)

    @staticmethod
    def setup_particle(*args):
        r"""
        setup_particle(Model m, ParticleIndex pi, IMP::String charmm_type) -> CHARMMAtom
        setup_particle(_ParticleAdaptor decorator, IMP::String charmm_type) -> CHARMMAtom
        """
        return _IMP_atom.CHARMMAtom_setup_particle(*args)

    def get_charmm_type(self):
        r"""get_charmm_type(CHARMMAtom self) -> IMP::String"""
        return _IMP_atom.CHARMMAtom_get_charmm_type(self)

    def set_charmm_type(self, t):
        r"""set_charmm_type(CHARMMAtom self, IMP::String t)"""
        return _IMP_atom.CHARMMAtom_set_charmm_type(self, t)

    @staticmethod
    def get_is_setup(*args):
        r"""
        get_is_setup(_ParticleAdaptor p) -> bool
        get_is_setup(Model m, ParticleIndex pi) -> bool
        """
        return _IMP_atom.CHARMMAtom_get_is_setup(*args)

    @staticmethod
    def get_charmm_type_key():
        r"""get_charmm_type_key() -> StringKey"""
        return _IMP_atom.CHARMMAtom_get_charmm_type_key()

    def add_attribute(self, *args):
        r"""
        add_attribute(CHARMMAtom self, FloatKey k, IMP::Float v, bool opt)
        add_attribute(CHARMMAtom self, FloatKey a0, IMP::Float a1)
        add_attribute(CHARMMAtom self, IntKey a0, IMP::Int a1)
        add_attribute(CHARMMAtom self, FloatsKey a0, IMP::Floats a1)
        add_attribute(CHARMMAtom self, IntsKey a0, IMP::Ints a1)
        add_attribute(CHARMMAtom self, StringKey a0, IMP::String a1)
        add_attribute(CHARMMAtom self, ParticleIndexKey a0, Particle a1)
        add_attribute(CHARMMAtom self, ObjectKey a0, Object a1)
        """
        return _IMP_atom.CHARMMAtom_add_attribute(self, *args)

    def get_value(self, *args):
        r"""
        get_value(CHARMMAtom self, FloatKey a0) -> IMP::Float
        get_value(CHARMMAtom self, IntKey a0) -> IMP::Int
        get_value(CHARMMAtom self, FloatsKey a0) -> IMP::Floats
        get_value(CHARMMAtom self, IntsKey a0) -> IMP::Ints
        get_value(CHARMMAtom self, StringKey a0) -> IMP::String
        get_value(CHARMMAtom self, ParticleIndexKey a0) -> Particle
        get_value(CHARMMAtom self, ObjectKey a0) -> Object
        """
        return _IMP_atom.CHARMMAtom_get_value(self, *args)

    def set_value(self, *args):
        r"""
        set_value(CHARMMAtom self, FloatKey a0, IMP::Float a1)
        set_value(CHARMMAtom self, IntKey a0, IMP::Int a1)
        set_value(CHARMMAtom self, FloatsKey a0, IMP::Floats a1)
        set_value(CHARMMAtom self, IntsKey a0, IMP::Ints a1)
        set_value(CHARMMAtom self, StringKey a0, IMP::String a1)
        set_value(CHARMMAtom self, ParticleIndexKey a0, Particle a1)
        set_value(CHARMMAtom self, ObjectKey a0, Object a1)
        """
        return _IMP_atom.CHARMMAtom_set_value(self, *args)

    def remove_attribute(self, *args):
        r"""
        remove_attribute(CHARMMAtom self, FloatKey a0)
        remove_attribute(CHARMMAtom self, IntKey a0)
        remove_attribute(CHARMMAtom self, FloatsKey a0)
        remove_attribute(CHARMMAtom self, IntsKey a0)
        remove_attribute(CHARMMAtom self, StringKey a0)
        remove_attribute(CHARMMAtom self, ParticleIndexKey a0)
        remove_attribute(CHARMMAtom self, ObjectKey a0)
        """
        return _IMP_atom.CHARMMAtom_remove_attribute(self, *args)

    def has_attribute(self, *args):
        r"""
        has_attribute(CHARMMAtom self, FloatKey a0) -> bool
        has_attribute(CHARMMAtom self, IntKey a0) -> bool
        has_attribute(CHARMMAtom self, FloatsKey a0) -> bool
        has_attribute(CHARMMAtom self, IntsKey a0) -> bool
        has_attribute(CHARMMAtom self, StringKey a0) -> bool
        has_attribute(CHARMMAtom self, ParticleIndexKey a0) -> bool
        has_attribute(CHARMMAtom self, ObjectKey a0) -> bool
        """
        return _IMP_atom.CHARMMAtom_has_attribute(self, *args)

    def get_derivative(self, a0):
        r"""get_derivative(CHARMMAtom self, FloatKey a0) -> double"""
        return _IMP_atom.CHARMMAtom_get_derivative(self, a0)

    def get_name(self):
        r"""get_name(CHARMMAtom self) -> std::string"""
        return _IMP_atom.CHARMMAtom_get_name(self)

    def clear_caches(self):
        r"""clear_caches(CHARMMAtom self)"""
        return _IMP_atom.CHARMMAtom_clear_caches(self)

    def set_name(self, a0):
        r"""set_name(CHARMMAtom self, std::string a0)"""
        return _IMP_atom.CHARMMAtom_set_name(self, a0)

    def set_check_level(self, a0):
        r"""set_check_level(CHARMMAtom self, IMP::CheckLevel a0)"""
        return _IMP_atom.CHARMMAtom_set_check_level(self, a0)

    def add_to_derivative(self, a0, a1, a2):
        r"""add_to_derivative(CHARMMAtom self, FloatKey a0, double a1, DerivativeAccumulator a2)"""
        return _IMP_atom.CHARMMAtom_add_to_derivative(self, a0, a1, a2)

    def set_is_optimized(self, a0, a1):
        r"""set_is_optimized(CHARMMAtom self, FloatKey a0, bool a1)"""
        return _IMP_atom.CHARMMAtom_set_is_optimized(self, a0, a1)

    def get_is_optimized(self, a0):
        r"""get_is_optimized(CHARMMAtom self, FloatKey a0) -> bool"""
        return _IMP_atom.CHARMMAtom_get_is_optimized(self, a0)

    def get_check_level(self):
        r"""get_check_level(CHARMMAtom self) -> IMP::CheckLevel"""
        return _IMP_atom.CHARMMAtom_get_check_level(self)

    def __eq__(self, *args):
        r"""
        __eq__(CHARMMAtom self, CHARMMAtom o) -> bool
        __eq__(CHARMMAtom self, Particle d) -> bool
        """
        return _IMP_atom.CHARMMAtom___eq__(self, *args)

    def __ne__(self, *args):
        r"""
        __ne__(CHARMMAtom self, CHARMMAtom o) -> bool
        __ne__(CHARMMAtom self, Particle d) -> bool
        """
        return _IMP_atom.CHARMMAtom___ne__(self, *args)

    def __le__(self, *args):
        r"""
        __le__(CHARMMAtom self, CHARMMAtom o) -> bool
        __le__(CHARMMAtom self, Particle d) -> bool
        """
        return _IMP_atom.CHARMMAtom___le__(self, *args)

    def __lt__(self, *args):
        r"""
        __lt__(CHARMMAtom self, CHARMMAtom o) -> bool
        __lt__(CHARMMAtom self, Particle d) -> bool
        """
        return _IMP_atom.CHARMMAtom___lt__(self, *args)

    def __ge__(self, *args):
        r"""
        __ge__(CHARMMAtom self, CHARMMAtom o) -> bool
        __ge__(CHARMMAtom self, Particle d) -> bool
        """
        return _IMP_atom.CHARMMAtom___ge__(self, *args)

    def __gt__(self, *args):
        r"""
        __gt__(CHARMMAtom self, CHARMMAtom o) -> bool
        __gt__(CHARMMAtom self, Particle d) -> bool
        """
        return _IMP_atom.CHARMMAtom___gt__(self, *args)

    def __hash__(self):
        r"""__hash__(CHARMMAtom self) -> std::size_t"""
        return _IMP_atom.CHARMMAtom___hash__(self)

    def __str__(self):
        r"""__str__(CHARMMAtom self) -> std::string"""
        return _IMP_atom.CHARMMAtom___str__(self)

    def __repr__(self):
        r"""__repr__(CHARMMAtom self) -> std::string"""
        return _IMP_atom.CHARMMAtom___repr__(self)
    __swig_destroy__ = _IMP_atom.delete_CHARMMAtom

# Register CHARMMAtom in _IMP_atom:
_IMP_atom.CHARMMAtom_swigregister(CHARMMAtom)

def CHARMMAtom_setup_particle(*args):
    r"""
    CHARMMAtom_setup_particle(Model m, ParticleIndex pi, IMP::String charmm_type) -> CHARMMAtom
    CHARMMAtom_setup_particle(_ParticleAdaptor decorator, IMP::String charmm_type) -> CHARMMAtom
    """
    return _IMP_atom.CHARMMAtom_setup_particle(*args)

def CHARMMAtom_get_is_setup(*args):
    r"""
    CHARMMAtom_get_is_setup(_ParticleAdaptor p) -> bool
    CHARMMAtom_get_is_setup(Model m, ParticleIndex pi) -> bool
    """
    return _IMP_atom.CHARMMAtom_get_is_setup(*args)

def CHARMMAtom_get_charmm_type_key():
    r"""CHARMMAtom_get_charmm_type_key() -> StringKey"""
    return _IMP_atom.CHARMMAtom_get_charmm_type_key()


def get_charmm_untyped_atoms(hierarchy):
    r"""get_charmm_untyped_atoms(Hierarchy hierarchy) -> IMP::atom::Atoms"""
    return _IMP_atom.get_charmm_untyped_atoms(hierarchy)

def remove_charmm_untyped_atoms(hierarchy):
    r"""remove_charmm_untyped_atoms(Hierarchy hierarchy)"""
    return _IMP_atom.remove_charmm_untyped_atoms(hierarchy)
class CHARMMBondParameters(object):
    r"""Proxy of C++ IMP::atom::CHARMMBondParameters class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    force_constant = property(_IMP_atom.CHARMMBondParameters_force_constant_get, _IMP_atom.CHARMMBondParameters_force_constant_set, doc=r"""force_constant : double""")
    ideal = property(_IMP_atom.CHARMMBondParameters_ideal_get, _IMP_atom.CHARMMBondParameters_ideal_set, doc=r"""ideal : double""")

    def __init__(self):
        r"""__init__(CHARMMBondParameters self) -> CHARMMBondParameters"""
        _IMP_atom.CHARMMBondParameters_swiginit(self, _IMP_atom.new_CHARMMBondParameters())

    def show(self, *args):
        r"""show(CHARMMBondParameters self, _ostream out=std::cout)"""
        return _IMP_atom.CHARMMBondParameters_show(self, *args)

    def __str__(self):
        r"""__str__(CHARMMBondParameters self) -> std::string"""
        return _IMP_atom.CHARMMBondParameters___str__(self)

    def __repr__(self):
        r"""__repr__(CHARMMBondParameters self) -> std::string"""
        return _IMP_atom.CHARMMBondParameters___repr__(self)
    __swig_destroy__ = _IMP_atom.delete_CHARMMBondParameters

# Register CHARMMBondParameters in _IMP_atom:
_IMP_atom.CHARMMBondParameters_swigregister(CHARMMBondParameters)

class CHARMMDihedralParameters(object):
    r"""Proxy of C++ IMP::atom::CHARMMDihedralParameters class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    force_constant = property(_IMP_atom.CHARMMDihedralParameters_force_constant_get, _IMP_atom.CHARMMDihedralParameters_force_constant_set, doc=r"""force_constant : double""")
    multiplicity = property(_IMP_atom.CHARMMDihedralParameters_multiplicity_get, _IMP_atom.CHARMMDihedralParameters_multiplicity_set, doc=r"""multiplicity : int""")
    ideal = property(_IMP_atom.CHARMMDihedralParameters_ideal_get, _IMP_atom.CHARMMDihedralParameters_ideal_set, doc=r"""ideal : double""")

    def __init__(self):
        r"""__init__(CHARMMDihedralParameters self) -> CHARMMDihedralParameters"""
        _IMP_atom.CHARMMDihedralParameters_swiginit(self, _IMP_atom.new_CHARMMDihedralParameters())

    def show(self, *args):
        r"""show(CHARMMDihedralParameters self, _ostream out=std::cout)"""
        return _IMP_atom.CHARMMDihedralParameters_show(self, *args)

    def __str__(self):
        r"""__str__(CHARMMDihedralParameters self) -> std::string"""
        return _IMP_atom.CHARMMDihedralParameters___str__(self)

    def __repr__(self):
        r"""__repr__(CHARMMDihedralParameters self) -> std::string"""
        return _IMP_atom.CHARMMDihedralParameters___repr__(self)
    __swig_destroy__ = _IMP_atom.delete_CHARMMDihedralParameters

# Register CHARMMDihedralParameters in _IMP_atom:
_IMP_atom.CHARMMDihedralParameters_swigregister(CHARMMDihedralParameters)

class CHARMMParameters(ForceFieldParameters):
    r"""Proxy of C++ IMP::atom::CHARMMParameters class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""__init__(CHARMMParameters self, TextInput topology_file_name, TextInput par_file_name=IMP::TextInput(), bool translate_names_to_pdb=False) -> CHARMMParameters"""
        _IMP_atom.CHARMMParameters_swiginit(self, _IMP_atom.new_CHARMMParameters(*args))

    def add_residue_topology(self, res):
        r"""add_residue_topology(CHARMMParameters self, CHARMMIdealResidueTopology res)"""
        return _IMP_atom.CHARMMParameters_add_residue_topology(self, res)

    def get_residue_topology(self, type):
        r"""get_residue_topology(CHARMMParameters self, ResidueType type) -> CHARMMIdealResidueTopology"""
        return _IMP_atom.CHARMMParameters_get_residue_topology(self, type)

    def add_patch(self, patch):
        r"""add_patch(CHARMMParameters self, CHARMMPatch patch)"""
        return _IMP_atom.CHARMMParameters_add_patch(self, patch)

    def get_patch(self, name):
        r"""get_patch(CHARMMParameters self, std::string name) -> CHARMMPatch"""
        return _IMP_atom.CHARMMParameters_get_patch(self, name)

    def create_topology(self, hierarchy):
        r"""create_topology(CHARMMParameters self, Hierarchy hierarchy) -> CHARMMTopology"""
        return _IMP_atom.CHARMMParameters_create_topology(self, hierarchy)

    def get_bond_parameters(self, type1, type2):
        r"""get_bond_parameters(CHARMMParameters self, std::string type1, std::string type2) -> CHARMMBondParameters"""
        return _IMP_atom.CHARMMParameters_get_bond_parameters(self, type1, type2)

    def get_angle_parameters(self, type1, type2, type3):
        r"""get_angle_parameters(CHARMMParameters self, std::string type1, std::string type2, std::string type3) -> CHARMMBondParameters"""
        return _IMP_atom.CHARMMParameters_get_angle_parameters(self, type1, type2, type3)

    def get_dihedral_parameters(self, type1, type2, type3, type4):
        r"""get_dihedral_parameters(CHARMMParameters self, std::string type1, std::string type2, std::string type3, std::string type4) -> IMP::atom::CHARMMDihedralParametersList"""
        return _IMP_atom.CHARMMParameters_get_dihedral_parameters(self, type1, type2, type3, type4)

    def get_improper_parameters(self, type1, type2, type3, type4):
        r"""get_improper_parameters(CHARMMParameters self, std::string type1, std::string type2, std::string type3, std::string type4) -> CHARMMDihedralParameters"""
        return _IMP_atom.CHARMMParameters_get_improper_parameters(self, type1, type2, type3, type4)

    def create_angles(self, bonds):
        r"""create_angles(CHARMMParameters self, IMP::Particles bonds) -> IMP::Particles"""
        return _IMP_atom.CHARMMParameters_create_angles(self, bonds)

    def create_dihedrals(self, bonds):
        r"""create_dihedrals(CHARMMParameters self, IMP::Particles bonds) -> IMP::Particles"""
        return _IMP_atom.CHARMMParameters_create_dihedrals(self, bonds)

    def get_version_info(self):
        r"""get_version_info(CHARMMParameters self) -> VersionInfo"""
        return _IMP_atom.CHARMMParameters_get_version_info(self)

    def __str__(self):
        r"""__str__(CHARMMParameters self) -> std::string"""
        return _IMP_atom.CHARMMParameters___str__(self)

    def __repr__(self):
        r"""__repr__(CHARMMParameters self) -> std::string"""
        return _IMP_atom.CHARMMParameters___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_CHARMMParameters(o)


# Register CHARMMParameters in _IMP_atom:
_IMP_atom.CHARMMParameters_swigregister(CHARMMParameters)


def get_heavy_atom_CHARMM_parameters():
    r"""get_heavy_atom_CHARMM_parameters() -> CHARMMParameters"""
    return _IMP_atom.get_heavy_atom_CHARMM_parameters()

def get_all_atom_CHARMM_parameters():
    r"""get_all_atom_CHARMM_parameters() -> CHARMMParameters"""
    return _IMP_atom.get_all_atom_CHARMM_parameters()
class CHARMMSegmentTopology(IMP.Object):
    r"""Proxy of C++ IMP::atom::CHARMMSegmentTopology class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def remove_residue(self, d):
        r"""remove_residue(CHARMMSegmentTopology self, CHARMMResidueTopology d)"""
        return _IMP_atom.CHARMMSegmentTopology_remove_residue(self, d)

    def remove_residues(self, d):
        r"""remove_residues(CHARMMSegmentTopology self, IMP::atom::CHARMMResidueTopologies const & d)"""
        return _IMP_atom.CHARMMSegmentTopology_remove_residues(self, d)

    def set_residues(self, ps):
        r"""set_residues(CHARMMSegmentTopology self, IMP::atom::CHARMMResidueTopologies const & ps)"""
        return _IMP_atom.CHARMMSegmentTopology_set_residues(self, ps)

    def set_residues_order(self, objs):
        r"""set_residues_order(CHARMMSegmentTopology self, IMP::atom::CHARMMResidueTopologies const & objs)"""
        return _IMP_atom.CHARMMSegmentTopology_set_residues_order(self, objs)

    def add_residue(self, obj):
        r"""add_residue(CHARMMSegmentTopology self, CHARMMResidueTopology obj) -> unsigned int"""
        return _IMP_atom.CHARMMSegmentTopology_add_residue(self, obj)

    def add_residues(self, objs):
        r"""add_residues(CHARMMSegmentTopology self, IMP::atom::CHARMMResidueTopologies const & objs)"""
        return _IMP_atom.CHARMMSegmentTopology_add_residues(self, objs)

    def clear_residues(self):
        r"""clear_residues(CHARMMSegmentTopology self)"""
        return _IMP_atom.CHARMMSegmentTopology_clear_residues(self)

    def get_number_of_residues(self):
        r"""get_number_of_residues(CHARMMSegmentTopology self) -> unsigned int"""
        return _IMP_atom.CHARMMSegmentTopology_get_number_of_residues(self)

    def get_has_residues(self):
        r"""get_has_residues(CHARMMSegmentTopology self) -> bool"""
        return _IMP_atom.CHARMMSegmentTopology_get_has_residues(self)

    def get_residue(self, i):
        r"""get_residue(CHARMMSegmentTopology self, unsigned int i) -> CHARMMResidueTopology"""
        return _IMP_atom.CHARMMSegmentTopology_get_residue(self, i)

    def get_residues(self):
        r"""get_residues(CHARMMSegmentTopology self) -> IMP::atom::CHARMMResidueTopologies"""
        return _IMP_atom.CHARMMSegmentTopology_get_residues(self)

    def reserve_residues(self, sz):
        r"""reserve_residues(CHARMMSegmentTopology self, unsigned int sz)"""
        return _IMP_atom.CHARMMSegmentTopology_reserve_residues(self, sz)

    def get_version_info(self):
        r"""get_version_info(CHARMMSegmentTopology self) -> VersionInfo"""
        return _IMP_atom.CHARMMSegmentTopology_get_version_info(self)

    def __init__(self, *args):
        r"""__init__(CHARMMSegmentTopology self, std::string name="CHARMM segment topology %1%") -> CHARMMSegmentTopology"""
        _IMP_atom.CHARMMSegmentTopology_swiginit(self, _IMP_atom.new_CHARMMSegmentTopology(*args))

    def apply_default_patches(self, ff):
        r"""apply_default_patches(CHARMMSegmentTopology self, CHARMMParameters ff)"""
        return _IMP_atom.CHARMMSegmentTopology_apply_default_patches(self, ff)

    def __str__(self):
        r"""__str__(CHARMMSegmentTopology self) -> std::string"""
        return _IMP_atom.CHARMMSegmentTopology___str__(self)

    def __repr__(self):
        r"""__repr__(CHARMMSegmentTopology self) -> std::string"""
        return _IMP_atom.CHARMMSegmentTopology___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_CHARMMSegmentTopology(o)


# Register CHARMMSegmentTopology in _IMP_atom:
_IMP_atom.CHARMMSegmentTopology_swigregister(CHARMMSegmentTopology)

class CHARMMTopology(IMP.Object):
    r"""Proxy of C++ IMP::atom::CHARMMTopology class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""__init__(CHARMMTopology self, CHARMMParameters force_field, std::string name="CHARMM topology %1%") -> CHARMMTopology"""
        _IMP_atom.CHARMMTopology_swiginit(self, _IMP_atom.new_CHARMMTopology(*args))

    def get_parameters(self):
        r"""get_parameters(CHARMMTopology self) -> CHARMMParameters"""
        return _IMP_atom.CHARMMTopology_get_parameters(self)

    def add_sequence(self, sequence):
        r"""add_sequence(CHARMMTopology self, std::string sequence)"""
        return _IMP_atom.CHARMMTopology_add_sequence(self, sequence)

    def apply_default_patches(self):
        r"""apply_default_patches(CHARMMTopology self)"""
        return _IMP_atom.CHARMMTopology_apply_default_patches(self)

    def create_hierarchy(self, model):
        r"""create_hierarchy(CHARMMTopology self, Model model) -> Hierarchy"""
        return _IMP_atom.CHARMMTopology_create_hierarchy(self, model)

    def add_atom_types(self, hierarchy):
        r"""add_atom_types(CHARMMTopology self, Hierarchy hierarchy)"""
        return _IMP_atom.CHARMMTopology_add_atom_types(self, hierarchy)

    def add_coordinates(self, hierarchy):
        r"""add_coordinates(CHARMMTopology self, Hierarchy hierarchy)"""
        return _IMP_atom.CHARMMTopology_add_coordinates(self, hierarchy)

    def add_missing_atoms(self, hierarchy):
        r"""add_missing_atoms(CHARMMTopology self, Hierarchy hierarchy)"""
        return _IMP_atom.CHARMMTopology_add_missing_atoms(self, hierarchy)

    def setup_hierarchy(self, hierarchy):
        r"""setup_hierarchy(CHARMMTopology self, Hierarchy hierarchy)"""
        return _IMP_atom.CHARMMTopology_setup_hierarchy(self, hierarchy)

    def add_charges(self, hierarchy):
        r"""add_charges(CHARMMTopology self, Hierarchy hierarchy)"""
        return _IMP_atom.CHARMMTopology_add_charges(self, hierarchy)

    def add_bonds(self, hierarchy):
        r"""add_bonds(CHARMMTopology self, Hierarchy hierarchy) -> IMP::Particles"""
        return _IMP_atom.CHARMMTopology_add_bonds(self, hierarchy)

    def add_dihedrals(self, hierarchy):
        r"""add_dihedrals(CHARMMTopology self, Hierarchy hierarchy) -> IMP::Particles"""
        return _IMP_atom.CHARMMTopology_add_dihedrals(self, hierarchy)

    def add_impropers(self, hierarchy):
        r"""add_impropers(CHARMMTopology self, Hierarchy hierarchy) -> IMP::Particles"""
        return _IMP_atom.CHARMMTopology_add_impropers(self, hierarchy)

    def remove_segment(self, d):
        r"""remove_segment(CHARMMTopology self, CHARMMSegmentTopology d)"""
        return _IMP_atom.CHARMMTopology_remove_segment(self, d)

    def remove_segments(self, d):
        r"""remove_segments(CHARMMTopology self, IMP::atom::CHARMMSegmentTopologies const & d)"""
        return _IMP_atom.CHARMMTopology_remove_segments(self, d)

    def set_segments(self, ps):
        r"""set_segments(CHARMMTopology self, IMP::atom::CHARMMSegmentTopologies const & ps)"""
        return _IMP_atom.CHARMMTopology_set_segments(self, ps)

    def set_segments_order(self, objs):
        r"""set_segments_order(CHARMMTopology self, IMP::atom::CHARMMSegmentTopologies const & objs)"""
        return _IMP_atom.CHARMMTopology_set_segments_order(self, objs)

    def add_segment(self, obj):
        r"""add_segment(CHARMMTopology self, CHARMMSegmentTopology obj) -> unsigned int"""
        return _IMP_atom.CHARMMTopology_add_segment(self, obj)

    def add_segments(self, objs):
        r"""add_segments(CHARMMTopology self, IMP::atom::CHARMMSegmentTopologies const & objs)"""
        return _IMP_atom.CHARMMTopology_add_segments(self, objs)

    def clear_segments(self):
        r"""clear_segments(CHARMMTopology self)"""
        return _IMP_atom.CHARMMTopology_clear_segments(self)

    def get_number_of_segments(self):
        r"""get_number_of_segments(CHARMMTopology self) -> unsigned int"""
        return _IMP_atom.CHARMMTopology_get_number_of_segments(self)

    def get_has_segments(self):
        r"""get_has_segments(CHARMMTopology self) -> bool"""
        return _IMP_atom.CHARMMTopology_get_has_segments(self)

    def get_segment(self, i):
        r"""get_segment(CHARMMTopology self, unsigned int i) -> CHARMMSegmentTopology"""
        return _IMP_atom.CHARMMTopology_get_segment(self, i)

    def get_segments(self):
        r"""get_segments(CHARMMTopology self) -> IMP::atom::CHARMMSegmentTopologies"""
        return _IMP_atom.CHARMMTopology_get_segments(self)

    def reserve_segments(self, sz):
        r"""reserve_segments(CHARMMTopology self, unsigned int sz)"""
        return _IMP_atom.CHARMMTopology_reserve_segments(self, sz)

    def get_version_info(self):
        r"""get_version_info(CHARMMTopology self) -> VersionInfo"""
        return _IMP_atom.CHARMMTopology_get_version_info(self)

    def __str__(self):
        r"""__str__(CHARMMTopology self) -> std::string"""
        return _IMP_atom.CHARMMTopology___str__(self)

    def __repr__(self):
        r"""__repr__(CHARMMTopology self) -> std::string"""
        return _IMP_atom.CHARMMTopology___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_CHARMMTopology(o)


# Register CHARMMTopology in _IMP_atom:
_IMP_atom.CHARMMTopology_swigregister(CHARMMTopology)

class CHARMMStereochemistryRestraint(IMP.Restraint):
    r"""Proxy of C++ IMP::atom::CHARMMStereochemistryRestraint class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(CHARMMStereochemistryRestraint self, Hierarchy h, CHARMMTopology topology) -> CHARMMStereochemistryRestraint
        __init__(CHARMMStereochemistryRestraint self, Hierarchy h, CHARMMTopology topology, IMP::ParticlesTemp limit_to_these_particles) -> CHARMMStereochemistryRestraint
        """
        _IMP_atom.CHARMMStereochemistryRestraint_swiginit(self, _IMP_atom.new_CHARMMStereochemistryRestraint(*args))

    def get_pair_filter(self):
        r"""get_pair_filter(CHARMMStereochemistryRestraint self) -> StereochemistryPairFilter"""
        return _IMP_atom.CHARMMStereochemistryRestraint_get_pair_filter(self)

    def get_full_pair_filter(self):
        r"""get_full_pair_filter(CHARMMStereochemistryRestraint self) -> StereochemistryPairFilter"""
        return _IMP_atom.CHARMMStereochemistryRestraint_get_full_pair_filter(self)

    def do_get_inputs(self):
        r"""do_get_inputs(CHARMMStereochemistryRestraint self) -> IMP::ModelObjectsTemp"""
        return _IMP_atom.CHARMMStereochemistryRestraint_do_get_inputs(self)

    def get_version_info(self):
        r"""get_version_info(CHARMMStereochemistryRestraint self) -> VersionInfo"""
        return _IMP_atom.CHARMMStereochemistryRestraint_get_version_info(self)

    def __str__(self):
        r"""__str__(CHARMMStereochemistryRestraint self) -> std::string"""
        return _IMP_atom.CHARMMStereochemistryRestraint___str__(self)

    def __repr__(self):
        r"""__repr__(CHARMMStereochemistryRestraint self) -> std::string"""
        return _IMP_atom.CHARMMStereochemistryRestraint___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_CHARMMStereochemistryRestraint(o)


# Register CHARMMStereochemistryRestraint in _IMP_atom:
_IMP_atom.CHARMMStereochemistryRestraint_swigregister(CHARMMStereochemistryRestraint)


def add_bonds(*args):
    r"""add_bonds(Hierarchy d, ForceFieldParameters ffp=IMP::atom::get_all_atom_CHARMM_parameters())"""
    return _IMP_atom.add_bonds(*args)

def add_radii(*args):
    r"""add_radii(Hierarchy d, ForceFieldParameters ffp=IMP::atom::get_all_atom_CHARMM_parameters(), FloatKey radius_key=FloatKey("radius"))"""
    return _IMP_atom.add_radii(*args)
ALBER = _IMP_atom.ALBER

HARPAZ = _IMP_atom.HARPAZ

ANDERSSON = _IMP_atom.ANDERSSON

TSAI = _IMP_atom.TSAI

QUILLIN = _IMP_atom.QUILLIN

SQUIRE = _IMP_atom.SQUIRE


def get_protein_density_from_reference(densityReference):
    r"""get_protein_density_from_reference(IMP::atom::ProteinDensityReference densityReference) -> double"""
    return _IMP_atom.get_protein_density_from_reference(densityReference)

def get_volume_from_mass(*args):
    r"""get_volume_from_mass(double m, IMP::atom::ProteinDensityReference ref=ALBER) -> double"""
    return _IMP_atom.get_volume_from_mass(*args)

def get_mass_from_volume(*args):
    r"""get_mass_from_volume(double v, IMP::atom::ProteinDensityReference ref=ALBER) -> double"""
    return _IMP_atom.get_mass_from_volume(*args)

def get_mass_from_number_of_residues(num_aa):
    r"""get_mass_from_number_of_residues(unsigned int num_aa) -> double"""
    return _IMP_atom.get_mass_from_number_of_residues(num_aa)

def get_volume_from_residue_type(rt):
    r"""get_volume_from_residue_type(ResidueType rt) -> double"""
    return _IMP_atom.get_volume_from_residue_type(rt)

def get_molarity(n, volume):
    r"""get_molarity(double n, double volume) -> double"""
    return _IMP_atom.get_molarity(n, volume)

def get_kd(na, nb, nab, volume):
    r"""get_kd(double na, double nb, double nab, double volume) -> double"""
    return _IMP_atom.get_kd(na, nb, nab, volume)

def get_einstein_diffusion_coefficient(r, temp=-1):
    r"""get_einstein_diffusion_coefficient(double r, double temp=-1) -> double"""
    return _IMP_atom.get_einstein_diffusion_coefficient(r, temp)

def get_einstein_rotational_diffusion_coefficient(r, temp=-1):
    r"""get_einstein_rotational_diffusion_coefficient(double r, double temp=-1) -> double"""
    return _IMP_atom.get_einstein_rotational_diffusion_coefficient(r, temp)

def get_diffusion_length(*args):
    r"""
    get_diffusion_length(double D, double t) -> double
    get_diffusion_length(double D, double force, double t, double temp=-1) -> double
    """
    return _IMP_atom.get_diffusion_length(*args)

def get_diffusion_angle(D, dtfs):
    r"""get_diffusion_angle(double D, double dtfs) -> double"""
    return _IMP_atom.get_diffusion_angle(D, dtfs)

def get_diffusion_coefficient(*args):
    r"""
    get_diffusion_coefficient(IMP::algebra::Vector3Ds const & displacements, double dt) -> double
    get_diffusion_coefficient(IMP::algebra::Vector3Ds const & displacements, IMP::Floats const & dts) -> double
    """
    return _IMP_atom.get_diffusion_coefficient(*args)

def get_rotational_diffusion_coefficient(orientations, dt):
    r"""get_rotational_diffusion_coefficient(IMP::algebra::Rotation3Ds const & orientations, double dt) -> double"""
    return _IMP_atom.get_rotational_diffusion_coefficient(orientations, dt)

def get_energy_in_femto_joules(energy_in_kcal_per_mol):
    r"""get_energy_in_femto_joules(double energy_in_kcal_per_mol) -> double"""
    return _IMP_atom.get_energy_in_femto_joules(energy_in_kcal_per_mol)

def get_force_in_femto_newtons(force_in_kcal_per_mol_per_angstrom):
    r"""get_force_in_femto_newtons(double force_in_kcal_per_mol_per_angstrom) -> double"""
    return _IMP_atom.get_force_in_femto_newtons(force_in_kcal_per_mol_per_angstrom)

def get_spring_constant_in_femto_newtons_per_angstrom(k_in_kcal_per_mol_per_angstrom_square):
    r"""get_spring_constant_in_femto_newtons_per_angstrom(double k_in_kcal_per_mol_per_angstrom_square) -> double"""
    return _IMP_atom.get_spring_constant_in_femto_newtons_per_angstrom(k_in_kcal_per_mol_per_angstrom_square)
class EzRestraint(IMP.Restraint):
    r"""Proxy of C++ IMP::atom::EzRestraint class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, m, ps):
        r"""__init__(EzRestraint self, Model m, _ParticleIndexesAdaptor ps) -> EzRestraint"""
        _IMP_atom.EzRestraint_swiginit(self, _IMP_atom.new_EzRestraint(m, ps))

    def get_version_info(self):
        r"""get_version_info(EzRestraint self) -> VersionInfo"""
        return _IMP_atom.EzRestraint_get_version_info(self)

    def __str__(self):
        r"""__str__(EzRestraint self) -> std::string"""
        return _IMP_atom.EzRestraint___str__(self)

    def __repr__(self):
        r"""__repr__(EzRestraint self) -> std::string"""
        return _IMP_atom.EzRestraint___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_EzRestraint(o)


# Register EzRestraint in _IMP_atom:
_IMP_atom.EzRestraint_swigregister(EzRestraint)


def create_protein(*args):
    r"""
    create_protein(Model m, std::string name, double target_radius, int number_of_residues, int first_residue_index=0, double volume=-1, bool ismol=True) -> Hierarchy
    create_protein(Model m, std::string name, double target_radius, IMP::Ints const domain_boundaries) -> Hierarchy
    """
    return _IMP_atom.create_protein(*args)

def create_simplified_along_backbone(*args):
    r"""
    create_simplified_along_backbone(Hierarchy input, int num_res, bool keep_detailed=False) -> Hierarchy
    create_simplified_along_backbone(Chain input, IMP::IntRanges const & residue_segments, bool keep_detailed=False) -> Hierarchy
    """
    return _IMP_atom.create_simplified_along_backbone(*args)

def create_simplified_from_volume(h, resolution):
    r"""create_simplified_from_volume(Hierarchy h, double resolution) -> Hierarchy"""
    return _IMP_atom.create_simplified_from_volume(h, resolution)

def create_simplified_assembly_from_volume(h, resolution):
    r"""create_simplified_assembly_from_volume(Hierarchy h, double resolution) -> Hierarchy"""
    return _IMP_atom.create_simplified_assembly_from_volume(h, resolution)

def get_residue_indexes(h):
    r"""get_residue_indexes(Hierarchy h) -> IMP::Ints"""
    return _IMP_atom.get_residue_indexes(h)

def get_residue_type(*args):
    r"""
    get_residue_type(char c) -> ResidueType
    get_residue_type(Hierarchy h) -> ResidueType
    """
    return _IMP_atom.get_residue_type(*args)

def get_atom_type(h):
    r"""get_atom_type(Hierarchy h) -> AtomType"""
    return _IMP_atom.get_atom_type(h)

def get_domain_name(h):
    r"""get_domain_name(Hierarchy h) -> std::string"""
    return _IMP_atom.get_domain_name(h)

def create_excluded_volume_restraint(*args):
    r"""
    create_excluded_volume_restraint(IMP::atom::Selections const & s) -> Restraint
    create_excluded_volume_restraint(IMP::atom::Hierarchies const & hs, double resolution=-1) -> Restraint
    """
    return _IMP_atom.create_excluded_volume_restraint(*args)

def setup_as_approximation(*args):
    r"""
    setup_as_approximation(Particle h, IMP::ParticlesTemp const & other, double resolution=-1)
    setup_as_approximation(Hierarchy h, double resolution=-1)
    """
    return _IMP_atom.setup_as_approximation(*args)
class _HierarchyTreeVertexIndex(object):
    r"""Proxy of C++ IMP::atom::HierarchyTreeVertexIndex class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        r"""__init__(_HierarchyTreeVertexIndex self) -> _HierarchyTreeVertexIndex"""
        _IMP_atom._HierarchyTreeVertexIndex_swiginit(self, _IMP_atom.new__HierarchyTreeVertexIndex())
    __swig_destroy__ = _IMP_atom.delete__HierarchyTreeVertexIndex

# Register _HierarchyTreeVertexIndex in _IMP_atom:
_IMP_atom._HierarchyTreeVertexIndex_swigregister(_HierarchyTreeVertexIndex)


def show_as_graphviz(name, out):
    r"""show_as_graphviz(IMP::atom::HierarchyTree const & name, TextOutput out)"""
    return _IMP_atom.show_as_graphviz(name, out)

def get_vertex_index(g):
    r"""get_vertex_index(IMP::atom::HierarchyTree const & g) -> _HierarchyTreeVertexIndex"""
    return _IMP_atom.get_vertex_index(g)

def get_hierarchy_tree(h):
    r"""get_hierarchy_tree(Hierarchy h) -> IMP::atom::HierarchyTree"""
    return _IMP_atom.get_hierarchy_tree(h)
class HierarchyGeometry(IMP.display.SingletonGeometry):
    r"""Proxy of C++ IMP::atom::HierarchyGeometry class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, d, resolution=0):
        r"""__init__(HierarchyGeometry self, Hierarchy d, double resolution=0) -> HierarchyGeometry"""
        _IMP_atom.HierarchyGeometry_swiginit(self, _IMP_atom.new_HierarchyGeometry(d, resolution))

    def get_version_info(self):
        r"""get_version_info(HierarchyGeometry self) -> VersionInfo"""
        return _IMP_atom.HierarchyGeometry_get_version_info(self)

    def __str__(self):
        r"""__str__(HierarchyGeometry self) -> std::string"""
        return _IMP_atom.HierarchyGeometry___str__(self)

    def __repr__(self):
        r"""__repr__(HierarchyGeometry self) -> std::string"""
        return _IMP_atom.HierarchyGeometry___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_HierarchyGeometry(o)


# Register HierarchyGeometry in _IMP_atom:
_IMP_atom.HierarchyGeometry_swigregister(HierarchyGeometry)

class HierarchiesGeometry(IMP.display.SingletonsGeometry):
    r"""Proxy of C++ IMP::atom::HierarchiesGeometry class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, sc, resolution=-1):
        r"""__init__(HierarchiesGeometry self, SingletonContainer sc, double resolution=-1) -> HierarchiesGeometry"""
        _IMP_atom.HierarchiesGeometry_swiginit(self, _IMP_atom.new_HierarchiesGeometry(sc, resolution))

    def get_version_info(self):
        r"""get_version_info(HierarchiesGeometry self) -> VersionInfo"""
        return _IMP_atom.HierarchiesGeometry_get_version_info(self)

    def __str__(self):
        r"""__str__(HierarchiesGeometry self) -> std::string"""
        return _IMP_atom.HierarchiesGeometry___str__(self)

    def __repr__(self):
        r"""__repr__(HierarchiesGeometry self) -> std::string"""
        return _IMP_atom.HierarchiesGeometry___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_HierarchiesGeometry(o)


# Register HierarchiesGeometry in _IMP_atom:
_IMP_atom.HierarchiesGeometry_swigregister(HierarchiesGeometry)


def transform(*args):
    r"""
    transform(Hierarchy h, Transformation3D tr)
    transform(Hierarchy h, Transformation3D tr)
    """
    return _IMP_atom.transform(*args)
class DopePairScore(_ADopeBase):
    r"""Proxy of C++ IMP::atom::DopePairScore class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(DopePairScore self, double threshold=std::numeric_limits< double >::max()) -> DopePairScore
        __init__(DopePairScore self, double threshold, TextInput data_file) -> DopePairScore
        """
        _IMP_atom.DopePairScore_swiginit(self, _IMP_atom.new_DopePairScore(*args))

    def __str__(self):
        r"""__str__(DopePairScore self) -> std::string"""
        return _IMP_atom.DopePairScore___str__(self)

    def __repr__(self):
        r"""__repr__(DopePairScore self) -> std::string"""
        return _IMP_atom.DopePairScore___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_DopePairScore(o)

    __swig_destroy__ = _IMP_atom.delete_DopePairScore

# Register DopePairScore in _IMP_atom:
_IMP_atom.DopePairScore_swigregister(DopePairScore)


def add_dope_score_data(h):
    r"""add_dope_score_data(Hierarchy h)"""
    return _IMP_atom.add_dope_score_data(h)
class LoopStatisticalPairScore(_ALoopStatisticalBase):
    r"""Proxy of C++ IMP::atom::LoopStatisticalPairScore class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(LoopStatisticalPairScore self, double threshold=std::numeric_limits< double >::max()) -> LoopStatisticalPairScore
        __init__(LoopStatisticalPairScore self, double threshold, TextInput data_file) -> LoopStatisticalPairScore
        """
        _IMP_atom.LoopStatisticalPairScore_swiginit(self, _IMP_atom.new_LoopStatisticalPairScore(*args))

    def __str__(self):
        r"""__str__(LoopStatisticalPairScore self) -> std::string"""
        return _IMP_atom.LoopStatisticalPairScore___str__(self)

    def __repr__(self):
        r"""__repr__(LoopStatisticalPairScore self) -> std::string"""
        return _IMP_atom.LoopStatisticalPairScore___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_LoopStatisticalPairScore(o)

    __swig_destroy__ = _IMP_atom.delete_LoopStatisticalPairScore

# Register LoopStatisticalPairScore in _IMP_atom:
_IMP_atom.LoopStatisticalPairScore_swigregister(LoopStatisticalPairScore)


def add_loop_statistical_score_data(h):
    r"""add_loop_statistical_score_data(Hierarchy h)"""
    return _IMP_atom.add_loop_statistical_score_data(h)
class OrientedSoapPairScore(_OrientedSoapBase):
    r"""Proxy of C++ IMP::atom::OrientedSoapPairScore class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, library):
        r"""__init__(OrientedSoapPairScore self, std::string library) -> OrientedSoapPairScore"""
        _IMP_atom.OrientedSoapPairScore_swiginit(self, _IMP_atom.new_OrientedSoapPairScore(library))

    def get_pair_filter(self):
        r"""get_pair_filter(OrientedSoapPairScore self) -> SoapPairFilter"""
        return _IMP_atom.OrientedSoapPairScore_get_pair_filter(self)

    def __str__(self):
        r"""__str__(OrientedSoapPairScore self) -> std::string"""
        return _IMP_atom.OrientedSoapPairScore___str__(self)

    def __repr__(self):
        r"""__repr__(OrientedSoapPairScore self) -> std::string"""
        return _IMP_atom.OrientedSoapPairScore___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_OrientedSoapPairScore(o)

    __swig_destroy__ = _IMP_atom.delete_OrientedSoapPairScore

# Register OrientedSoapPairScore in _IMP_atom:
_IMP_atom.OrientedSoapPairScore_swigregister(OrientedSoapPairScore)

class SameResiduePairFilter(IMP.PairPredicate):
    r"""Proxy of C++ IMP::atom::SameResiduePairFilter class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self):
        r"""__init__(SameResiduePairFilter self) -> SameResiduePairFilter"""
        _IMP_atom.SameResiduePairFilter_swiginit(self, _IMP_atom.new_SameResiduePairFilter())

    def do_get_inputs(self, m, pis):
        r"""do_get_inputs(SameResiduePairFilter self, Model m, IMP::ParticleIndexes const & pis) -> IMP::ModelObjectsTemp"""
        return _IMP_atom.SameResiduePairFilter_do_get_inputs(self, m, pis)

    def get_value(self, *args):
        r"""
        get_value(SameResiduePairFilter self, IMP::ParticlePair const & a) -> int
        get_value(SameResiduePairFilter self, IMP::ParticlePairsTemp const & o) -> IMP::Ints
        """
        return _IMP_atom.SameResiduePairFilter_get_value(self, *args)

    def get_value_index(self, *args):
        r"""
        get_value_index(SameResiduePairFilter self, Model m, IMP::ParticleIndexPair const & p) -> int
        get_value_index(SameResiduePairFilter self, Model m, IMP::ParticleIndexPairs const & o) -> IMP::Ints
        """
        return _IMP_atom.SameResiduePairFilter_get_value_index(self, *args)

    def get_version_info(self):
        r"""get_version_info(SameResiduePairFilter self) -> VersionInfo"""
        return _IMP_atom.SameResiduePairFilter_get_version_info(self)

    def __str__(self):
        r"""__str__(SameResiduePairFilter self) -> std::string"""
        return _IMP_atom.SameResiduePairFilter___str__(self)

    def __repr__(self):
        r"""__repr__(SameResiduePairFilter self) -> std::string"""
        return _IMP_atom.SameResiduePairFilter___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_SameResiduePairFilter(o)


# Register SameResiduePairFilter in _IMP_atom:
_IMP_atom.SameResiduePairFilter_swigregister(SameResiduePairFilter)

class RemoveRigidMotionOptimizerState(IMP.OptimizerState):
    r"""Proxy of C++ IMP::atom::RemoveRigidMotionOptimizerState class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, m, pis):
        r"""__init__(RemoveRigidMotionOptimizerState self, Model m, _ParticleIndexesAdaptor pis) -> RemoveRigidMotionOptimizerState"""
        _IMP_atom.RemoveRigidMotionOptimizerState_swiginit(self, _IMP_atom.new_RemoveRigidMotionOptimizerState(m, pis))

    def set_particles(self, pis):
        r"""set_particles(RemoveRigidMotionOptimizerState self, IMP::Particles const & pis)"""
        return _IMP_atom.RemoveRigidMotionOptimizerState_set_particles(self, pis)

    def remove_rigid_motion(self):
        r"""remove_rigid_motion(RemoveRigidMotionOptimizerState self)"""
        return _IMP_atom.RemoveRigidMotionOptimizerState_remove_rigid_motion(self)

    def get_version_info(self):
        r"""get_version_info(RemoveRigidMotionOptimizerState self) -> VersionInfo"""
        return _IMP_atom.RemoveRigidMotionOptimizerState_get_version_info(self)

    def __str__(self):
        r"""__str__(RemoveRigidMotionOptimizerState self) -> std::string"""
        return _IMP_atom.RemoveRigidMotionOptimizerState___str__(self)

    def __repr__(self):
        r"""__repr__(RemoveRigidMotionOptimizerState self) -> std::string"""
        return _IMP_atom.RemoveRigidMotionOptimizerState___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_RemoveRigidMotionOptimizerState(o)


# Register RemoveRigidMotionOptimizerState in _IMP_atom:
_IMP_atom.RemoveRigidMotionOptimizerState_swigregister(RemoveRigidMotionOptimizerState)

class BerendsenThermostatOptimizerState(IMP.OptimizerState):
    r"""Proxy of C++ IMP::atom::BerendsenThermostatOptimizerState class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, pis, temperature, tau):
        r"""__init__(BerendsenThermostatOptimizerState self, IMP::Particles const & pis, double temperature, double tau) -> BerendsenThermostatOptimizerState"""
        _IMP_atom.BerendsenThermostatOptimizerState_swiginit(self, _IMP_atom.new_BerendsenThermostatOptimizerState(pis, temperature, tau))

    def set_particles(self, pis):
        r"""set_particles(BerendsenThermostatOptimizerState self, IMP::Particles const & pis)"""
        return _IMP_atom.BerendsenThermostatOptimizerState_set_particles(self, pis)

    def get_temperature(self):
        r"""get_temperature(BerendsenThermostatOptimizerState self) -> double"""
        return _IMP_atom.BerendsenThermostatOptimizerState_get_temperature(self)

    def get_tau(self):
        r"""get_tau(BerendsenThermostatOptimizerState self) -> double"""
        return _IMP_atom.BerendsenThermostatOptimizerState_get_tau(self)

    def set_temperature(self, temperature):
        r"""set_temperature(BerendsenThermostatOptimizerState self, double temperature)"""
        return _IMP_atom.BerendsenThermostatOptimizerState_set_temperature(self, temperature)

    def set_tau(self, tau):
        r"""set_tau(BerendsenThermostatOptimizerState self, double tau)"""
        return _IMP_atom.BerendsenThermostatOptimizerState_set_tau(self, tau)

    def rescale_velocities(self):
        r"""rescale_velocities(BerendsenThermostatOptimizerState self)"""
        return _IMP_atom.BerendsenThermostatOptimizerState_rescale_velocities(self)

    def get_version_info(self):
        r"""get_version_info(BerendsenThermostatOptimizerState self) -> VersionInfo"""
        return _IMP_atom.BerendsenThermostatOptimizerState_get_version_info(self)

    def __str__(self):
        r"""__str__(BerendsenThermostatOptimizerState self) -> std::string"""
        return _IMP_atom.BerendsenThermostatOptimizerState___str__(self)

    def __repr__(self):
        r"""__repr__(BerendsenThermostatOptimizerState self) -> std::string"""
        return _IMP_atom.BerendsenThermostatOptimizerState___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_BerendsenThermostatOptimizerState(o)


# Register BerendsenThermostatOptimizerState in _IMP_atom:
_IMP_atom.BerendsenThermostatOptimizerState_swigregister(BerendsenThermostatOptimizerState)

class LangevinThermostatOptimizerState(IMP.OptimizerState):
    r"""Proxy of C++ IMP::atom::LangevinThermostatOptimizerState class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, m, pis, temperature, gamma):
        r"""__init__(LangevinThermostatOptimizerState self, Model m, _ParticleIndexesAdaptor pis, double temperature, double gamma) -> LangevinThermostatOptimizerState"""
        _IMP_atom.LangevinThermostatOptimizerState_swiginit(self, _IMP_atom.new_LangevinThermostatOptimizerState(m, pis, temperature, gamma))

    def set_particles(self, pis):
        r"""set_particles(LangevinThermostatOptimizerState self, IMP::Particles const & pis)"""
        return _IMP_atom.LangevinThermostatOptimizerState_set_particles(self, pis)

    def get_temperature(self):
        r"""get_temperature(LangevinThermostatOptimizerState self) -> double"""
        return _IMP_atom.LangevinThermostatOptimizerState_get_temperature(self)

    def get_gamma(self):
        r"""get_gamma(LangevinThermostatOptimizerState self) -> double"""
        return _IMP_atom.LangevinThermostatOptimizerState_get_gamma(self)

    def set_temperature(self, temperature):
        r"""set_temperature(LangevinThermostatOptimizerState self, double temperature)"""
        return _IMP_atom.LangevinThermostatOptimizerState_set_temperature(self, temperature)

    def set_gamma(self, gamma):
        r"""set_gamma(LangevinThermostatOptimizerState self, double gamma)"""
        return _IMP_atom.LangevinThermostatOptimizerState_set_gamma(self, gamma)

    def rescale_velocities(self):
        r"""rescale_velocities(LangevinThermostatOptimizerState self)"""
        return _IMP_atom.LangevinThermostatOptimizerState_rescale_velocities(self)

    def get_version_info(self):
        r"""get_version_info(LangevinThermostatOptimizerState self) -> VersionInfo"""
        return _IMP_atom.LangevinThermostatOptimizerState_get_version_info(self)

    def __str__(self):
        r"""__str__(LangevinThermostatOptimizerState self) -> std::string"""
        return _IMP_atom.LangevinThermostatOptimizerState___str__(self)

    def __repr__(self):
        r"""__repr__(LangevinThermostatOptimizerState self) -> std::string"""
        return _IMP_atom.LangevinThermostatOptimizerState___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_LangevinThermostatOptimizerState(o)


# Register LangevinThermostatOptimizerState in _IMP_atom:
_IMP_atom.LangevinThermostatOptimizerState_swigregister(LangevinThermostatOptimizerState)

class PDBSelector(IMP.Object):
    r"""Proxy of C++ IMP::atom::PDBSelector class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, name):
        r"""__init__(PDBSelector self, std::string name) -> PDBSelector"""
        if self.__class__ == PDBSelector:
            _self = None
        else:
            _self = self
        _IMP_atom.PDBSelector_swiginit(self, _IMP_atom.new_PDBSelector(_self, name))

        if self.__class__ != PDBSelector:
            _director_objects.register(self)




    def get_is_selected(self, pdb_line):
        r"""get_is_selected(PDBSelector self, std::string const & pdb_line) -> bool"""
        return _IMP_atom.PDBSelector_get_is_selected(self, pdb_line)
    __swig_destroy__ = _IMP_atom.delete_PDBSelector

    def __str__(self):
        r"""__str__(PDBSelector self) -> std::string"""
        return _IMP_atom.PDBSelector___str__(self)

    def __repr__(self):
        r"""__repr__(PDBSelector self) -> std::string"""
        return _IMP_atom.PDBSelector___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_PDBSelector(o)


    def get_type_name(self):
        return self.__class__.__name__
    def do_show(self, out):
        pass
    def get_version_info(self):
        if"IMP::atom" == "IMP":
          return VersionInfo(self.__module__,
                             __import__(self.__module__).get_module_version())
        else:
          return IMP.VersionInfo(self.__module__,
                             __import__(self.__module__).get_module_version())
    @staticmethod
    def get_from(o):
       return _object_cast_to_PDBSelector(o)


    def __and__(self, s):
        return AndPDBSelector(self, s)
    def __or__(self, s):
        return OrPDBSelector(self, s)
    def __xor__(self, s):
        return XorPDBSelector(self, s)
    def __invert__(self):
        return NotPDBSelector(self)
    def __sub__(self, s):
        return AndPDBSelector(self, NotPDBSelector(s))

    def __disown__(self):
        self.this.disown()
        _IMP_atom.disown_PDBSelector(self)
        return weakref.proxy(self)

    def do_destroy(self):
        r"""do_destroy(PDBSelector self)"""
        return _IMP_atom.PDBSelector_do_destroy(self)

# Register PDBSelector in _IMP_atom:
_IMP_atom.PDBSelector_swigregister(PDBSelector)

class NonAlternativePDBSelector(PDBSelector):
    r"""Proxy of C++ IMP::atom::NonAlternativePDBSelector class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""__init__(NonAlternativePDBSelector self, std::string name="NonAlternativePDBSelector%1%") -> NonAlternativePDBSelector"""
        _IMP_atom.NonAlternativePDBSelector_swiginit(self, _IMP_atom.new_NonAlternativePDBSelector(*args))

    def get_version_info(self):
        r"""get_version_info(NonAlternativePDBSelector self) -> VersionInfo"""
        return _IMP_atom.NonAlternativePDBSelector_get_version_info(self)

    def __str__(self):
        r"""__str__(NonAlternativePDBSelector self) -> std::string"""
        return _IMP_atom.NonAlternativePDBSelector___str__(self)

    def __repr__(self):
        r"""__repr__(NonAlternativePDBSelector self) -> std::string"""
        return _IMP_atom.NonAlternativePDBSelector___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_NonAlternativePDBSelector(o)


# Register NonAlternativePDBSelector in _IMP_atom:
_IMP_atom.NonAlternativePDBSelector_swigregister(NonAlternativePDBSelector)

class ATOMPDBSelector(NonAlternativePDBSelector):
    r"""Proxy of C++ IMP::atom::ATOMPDBSelector class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""__init__(ATOMPDBSelector self, std::string name="ATOMPDBSelector%1%") -> ATOMPDBSelector"""
        _IMP_atom.ATOMPDBSelector_swiginit(self, _IMP_atom.new_ATOMPDBSelector(*args))

    def __str__(self):
        r"""__str__(ATOMPDBSelector self) -> std::string"""
        return _IMP_atom.ATOMPDBSelector___str__(self)

    def __repr__(self):
        r"""__repr__(ATOMPDBSelector self) -> std::string"""
        return _IMP_atom.ATOMPDBSelector___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_ATOMPDBSelector(o)


# Register ATOMPDBSelector in _IMP_atom:
_IMP_atom.ATOMPDBSelector_swigregister(ATOMPDBSelector)

class CAlphaPDBSelector(NonAlternativePDBSelector):
    r"""Proxy of C++ IMP::atom::CAlphaPDBSelector class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""__init__(CAlphaPDBSelector self, std::string name="CAlphaPDBSelector%1%") -> CAlphaPDBSelector"""
        _IMP_atom.CAlphaPDBSelector_swiginit(self, _IMP_atom.new_CAlphaPDBSelector(*args))

    def __str__(self):
        r"""__str__(CAlphaPDBSelector self) -> std::string"""
        return _IMP_atom.CAlphaPDBSelector___str__(self)

    def __repr__(self):
        r"""__repr__(CAlphaPDBSelector self) -> std::string"""
        return _IMP_atom.CAlphaPDBSelector___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_CAlphaPDBSelector(o)


# Register CAlphaPDBSelector in _IMP_atom:
_IMP_atom.CAlphaPDBSelector_swigregister(CAlphaPDBSelector)

class CBetaPDBSelector(NonAlternativePDBSelector):
    r"""Proxy of C++ IMP::atom::CBetaPDBSelector class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""__init__(CBetaPDBSelector self, std::string name="CBetaPDBSelector%1%") -> CBetaPDBSelector"""
        _IMP_atom.CBetaPDBSelector_swiginit(self, _IMP_atom.new_CBetaPDBSelector(*args))

    def __str__(self):
        r"""__str__(CBetaPDBSelector self) -> std::string"""
        return _IMP_atom.CBetaPDBSelector___str__(self)

    def __repr__(self):
        r"""__repr__(CBetaPDBSelector self) -> std::string"""
        return _IMP_atom.CBetaPDBSelector___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_CBetaPDBSelector(o)


# Register CBetaPDBSelector in _IMP_atom:
_IMP_atom.CBetaPDBSelector_swigregister(CBetaPDBSelector)

class AtomTypePDBSelector(PDBSelector):
    r"""Proxy of C++ IMP::atom::AtomTypePDBSelector class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""__init__(AtomTypePDBSelector self, IMP::Strings atom_types, std::string name="AtomTypePDBSelector%1%") -> AtomTypePDBSelector"""
        _IMP_atom.AtomTypePDBSelector_swiginit(self, _IMP_atom.new_AtomTypePDBSelector(*args))

    def get_version_info(self):
        r"""get_version_info(AtomTypePDBSelector self) -> VersionInfo"""
        return _IMP_atom.AtomTypePDBSelector_get_version_info(self)

    def __str__(self):
        r"""__str__(AtomTypePDBSelector self) -> std::string"""
        return _IMP_atom.AtomTypePDBSelector___str__(self)

    def __repr__(self):
        r"""__repr__(AtomTypePDBSelector self) -> std::string"""
        return _IMP_atom.AtomTypePDBSelector___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_AtomTypePDBSelector(o)


# Register AtomTypePDBSelector in _IMP_atom:
_IMP_atom.AtomTypePDBSelector_swigregister(AtomTypePDBSelector)

class ResidueTypePDBSelector(PDBSelector):
    r"""Proxy of C++ IMP::atom::ResidueTypePDBSelector class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""__init__(ResidueTypePDBSelector self, IMP::Strings residue_types, std::string name="ResidueTypePDBSelector%1%") -> ResidueTypePDBSelector"""
        _IMP_atom.ResidueTypePDBSelector_swiginit(self, _IMP_atom.new_ResidueTypePDBSelector(*args))

    def get_version_info(self):
        r"""get_version_info(ResidueTypePDBSelector self) -> VersionInfo"""
        return _IMP_atom.ResidueTypePDBSelector_get_version_info(self)

    def __str__(self):
        r"""__str__(ResidueTypePDBSelector self) -> std::string"""
        return _IMP_atom.ResidueTypePDBSelector___str__(self)

    def __repr__(self):
        r"""__repr__(ResidueTypePDBSelector self) -> std::string"""
        return _IMP_atom.ResidueTypePDBSelector___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_ResidueTypePDBSelector(o)


# Register ResidueTypePDBSelector in _IMP_atom:
_IMP_atom.ResidueTypePDBSelector_swigregister(ResidueTypePDBSelector)

class CPDBSelector(NonAlternativePDBSelector):
    r"""Proxy of C++ IMP::atom::CPDBSelector class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""__init__(CPDBSelector self, std::string name="CPDBSelector%1%") -> CPDBSelector"""
        _IMP_atom.CPDBSelector_swiginit(self, _IMP_atom.new_CPDBSelector(*args))

    def __str__(self):
        r"""__str__(CPDBSelector self) -> std::string"""
        return _IMP_atom.CPDBSelector___str__(self)

    def __repr__(self):
        r"""__repr__(CPDBSelector self) -> std::string"""
        return _IMP_atom.CPDBSelector___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_CPDBSelector(o)


# Register CPDBSelector in _IMP_atom:
_IMP_atom.CPDBSelector_swigregister(CPDBSelector)

class NPDBSelector(NonAlternativePDBSelector):
    r"""Proxy of C++ IMP::atom::NPDBSelector class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""__init__(NPDBSelector self, std::string name="NPDBSelector%1%") -> NPDBSelector"""
        _IMP_atom.NPDBSelector_swiginit(self, _IMP_atom.new_NPDBSelector(*args))

    def __str__(self):
        r"""__str__(NPDBSelector self) -> std::string"""
        return _IMP_atom.NPDBSelector___str__(self)

    def __repr__(self):
        r"""__repr__(NPDBSelector self) -> std::string"""
        return _IMP_atom.NPDBSelector___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_NPDBSelector(o)


# Register NPDBSelector in _IMP_atom:
_IMP_atom.NPDBSelector_swigregister(NPDBSelector)

class AllPDBSelector(PDBSelector):
    r"""Proxy of C++ IMP::atom::AllPDBSelector class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""__init__(AllPDBSelector self, std::string name="AllPDBSelector%1%") -> AllPDBSelector"""
        _IMP_atom.AllPDBSelector_swiginit(self, _IMP_atom.new_AllPDBSelector(*args))

    def get_version_info(self):
        r"""get_version_info(AllPDBSelector self) -> VersionInfo"""
        return _IMP_atom.AllPDBSelector_get_version_info(self)

    def __str__(self):
        r"""__str__(AllPDBSelector self) -> std::string"""
        return _IMP_atom.AllPDBSelector___str__(self)

    def __repr__(self):
        r"""__repr__(AllPDBSelector self) -> std::string"""
        return _IMP_atom.AllPDBSelector___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_AllPDBSelector(o)


# Register AllPDBSelector in _IMP_atom:
_IMP_atom.AllPDBSelector_swigregister(AllPDBSelector)

class ChainPDBSelector(NonAlternativePDBSelector):
    r"""Proxy of C++ IMP::atom::ChainPDBSelector class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""__init__(ChainPDBSelector self, std::string const & chains, std::string name="ChainPDBSelector%1%") -> ChainPDBSelector"""
        _IMP_atom.ChainPDBSelector_swiginit(self, _IMP_atom.new_ChainPDBSelector(*args))

    def __str__(self):
        r"""__str__(ChainPDBSelector self) -> std::string"""
        return _IMP_atom.ChainPDBSelector___str__(self)

    def __repr__(self):
        r"""__repr__(ChainPDBSelector self) -> std::string"""
        return _IMP_atom.ChainPDBSelector___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_ChainPDBSelector(o)


# Register ChainPDBSelector in _IMP_atom:
_IMP_atom.ChainPDBSelector_swigregister(ChainPDBSelector)

class WaterPDBSelector(NonAlternativePDBSelector):
    r"""Proxy of C++ IMP::atom::WaterPDBSelector class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""__init__(WaterPDBSelector self, std::string name="WaterPDBSelector%1%") -> WaterPDBSelector"""
        _IMP_atom.WaterPDBSelector_swiginit(self, _IMP_atom.new_WaterPDBSelector(*args))

    def __str__(self):
        r"""__str__(WaterPDBSelector self) -> std::string"""
        return _IMP_atom.WaterPDBSelector___str__(self)

    def __repr__(self):
        r"""__repr__(WaterPDBSelector self) -> std::string"""
        return _IMP_atom.WaterPDBSelector___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_WaterPDBSelector(o)


# Register WaterPDBSelector in _IMP_atom:
_IMP_atom.WaterPDBSelector_swigregister(WaterPDBSelector)

class HydrogenPDBSelector(NonAlternativePDBSelector):
    r"""Proxy of C++ IMP::atom::HydrogenPDBSelector class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""__init__(HydrogenPDBSelector self, std::string name="HydrogenPDBSelector%1%") -> HydrogenPDBSelector"""
        _IMP_atom.HydrogenPDBSelector_swiginit(self, _IMP_atom.new_HydrogenPDBSelector(*args))

    def __str__(self):
        r"""__str__(HydrogenPDBSelector self) -> std::string"""
        return _IMP_atom.HydrogenPDBSelector___str__(self)

    def __repr__(self):
        r"""__repr__(HydrogenPDBSelector self) -> std::string"""
        return _IMP_atom.HydrogenPDBSelector___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_HydrogenPDBSelector(o)


# Register HydrogenPDBSelector in _IMP_atom:
_IMP_atom.HydrogenPDBSelector_swigregister(HydrogenPDBSelector)

class NonWaterNonHydrogenPDBSelector(NonAlternativePDBSelector):
    r"""Proxy of C++ IMP::atom::NonWaterNonHydrogenPDBSelector class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(NonWaterNonHydrogenPDBSelector self, std::string name) -> NonWaterNonHydrogenPDBSelector
        __init__(NonWaterNonHydrogenPDBSelector self) -> NonWaterNonHydrogenPDBSelector
        """
        _IMP_atom.NonWaterNonHydrogenPDBSelector_swiginit(self, _IMP_atom.new_NonWaterNonHydrogenPDBSelector(*args))

    def __str__(self):
        r"""__str__(NonWaterNonHydrogenPDBSelector self) -> std::string"""
        return _IMP_atom.NonWaterNonHydrogenPDBSelector___str__(self)

    def __repr__(self):
        r"""__repr__(NonWaterNonHydrogenPDBSelector self) -> std::string"""
        return _IMP_atom.NonWaterNonHydrogenPDBSelector___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_NonWaterNonHydrogenPDBSelector(o)


# Register NonWaterNonHydrogenPDBSelector in _IMP_atom:
_IMP_atom.NonWaterNonHydrogenPDBSelector_swigregister(NonWaterNonHydrogenPDBSelector)

class NonHydrogenPDBSelector(NonAlternativePDBSelector):
    r"""Proxy of C++ IMP::atom::NonHydrogenPDBSelector class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(NonHydrogenPDBSelector self, std::string name) -> NonHydrogenPDBSelector
        __init__(NonHydrogenPDBSelector self) -> NonHydrogenPDBSelector
        """
        _IMP_atom.NonHydrogenPDBSelector_swiginit(self, _IMP_atom.new_NonHydrogenPDBSelector(*args))

    def __str__(self):
        r"""__str__(NonHydrogenPDBSelector self) -> std::string"""
        return _IMP_atom.NonHydrogenPDBSelector___str__(self)

    def __repr__(self):
        r"""__repr__(NonHydrogenPDBSelector self) -> std::string"""
        return _IMP_atom.NonHydrogenPDBSelector___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_NonHydrogenPDBSelector(o)


# Register NonHydrogenPDBSelector in _IMP_atom:
_IMP_atom.NonHydrogenPDBSelector_swigregister(NonHydrogenPDBSelector)

class NonWaterPDBSelector(NonAlternativePDBSelector):
    r"""Proxy of C++ IMP::atom::NonWaterPDBSelector class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(NonWaterPDBSelector self, std::string name) -> NonWaterPDBSelector
        __init__(NonWaterPDBSelector self) -> NonWaterPDBSelector
        """
        _IMP_atom.NonWaterPDBSelector_swiginit(self, _IMP_atom.new_NonWaterPDBSelector(*args))

    def __str__(self):
        r"""__str__(NonWaterPDBSelector self) -> std::string"""
        return _IMP_atom.NonWaterPDBSelector___str__(self)

    def __repr__(self):
        r"""__repr__(NonWaterPDBSelector self) -> std::string"""
        return _IMP_atom.NonWaterPDBSelector___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_NonWaterPDBSelector(o)


# Register NonWaterPDBSelector in _IMP_atom:
_IMP_atom.NonWaterPDBSelector_swigregister(NonWaterPDBSelector)

class BackbonePDBSelector(NonWaterNonHydrogenPDBSelector):
    r"""Proxy of C++ IMP::atom::BackbonePDBSelector class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""__init__(BackbonePDBSelector self, std::string name="BackbonePDBSelector%1%") -> BackbonePDBSelector"""
        _IMP_atom.BackbonePDBSelector_swiginit(self, _IMP_atom.new_BackbonePDBSelector(*args))

    def __str__(self):
        r"""__str__(BackbonePDBSelector self) -> std::string"""
        return _IMP_atom.BackbonePDBSelector___str__(self)

    def __repr__(self):
        r"""__repr__(BackbonePDBSelector self) -> std::string"""
        return _IMP_atom.BackbonePDBSelector___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_BackbonePDBSelector(o)


# Register BackbonePDBSelector in _IMP_atom:
_IMP_atom.BackbonePDBSelector_swigregister(BackbonePDBSelector)

class PPDBSelector(NonAlternativePDBSelector):
    r"""Proxy of C++ IMP::atom::PPDBSelector class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""__init__(PPDBSelector self, std::string name="PPDBSelector%1%") -> PPDBSelector"""
        _IMP_atom.PPDBSelector_swiginit(self, _IMP_atom.new_PPDBSelector(*args))

    def __str__(self):
        r"""__str__(PPDBSelector self) -> std::string"""
        return _IMP_atom.PPDBSelector___str__(self)

    def __repr__(self):
        r"""__repr__(PPDBSelector self) -> std::string"""
        return _IMP_atom.PPDBSelector___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_PPDBSelector(o)


# Register PPDBSelector in _IMP_atom:
_IMP_atom.PPDBSelector_swigregister(PPDBSelector)

class AndPDBSelector(PDBSelector):
    r"""Proxy of C++ IMP::atom::AndPDBSelector class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def get_version_info(self):
        r"""get_version_info(AndPDBSelector self) -> VersionInfo"""
        return _IMP_atom.AndPDBSelector_get_version_info(self)

    def __init__(self, a, b):
        r"""__init__(AndPDBSelector self, PDBSelector a, PDBSelector b) -> AndPDBSelector"""
        _IMP_atom.AndPDBSelector_swiginit(self, _IMP_atom.new_AndPDBSelector(a, b))

    def __str__(self):
        r"""__str__(AndPDBSelector self) -> std::string"""
        return _IMP_atom.AndPDBSelector___str__(self)

    def __repr__(self):
        r"""__repr__(AndPDBSelector self) -> std::string"""
        return _IMP_atom.AndPDBSelector___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_AndPDBSelector(o)


# Register AndPDBSelector in _IMP_atom:
_IMP_atom.AndPDBSelector_swigregister(AndPDBSelector)

class OrPDBSelector(PDBSelector):
    r"""Proxy of C++ IMP::atom::OrPDBSelector class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def get_version_info(self):
        r"""get_version_info(OrPDBSelector self) -> VersionInfo"""
        return _IMP_atom.OrPDBSelector_get_version_info(self)

    def __init__(self, a, b):
        r"""__init__(OrPDBSelector self, PDBSelector a, PDBSelector b) -> OrPDBSelector"""
        _IMP_atom.OrPDBSelector_swiginit(self, _IMP_atom.new_OrPDBSelector(a, b))

    def __str__(self):
        r"""__str__(OrPDBSelector self) -> std::string"""
        return _IMP_atom.OrPDBSelector___str__(self)

    def __repr__(self):
        r"""__repr__(OrPDBSelector self) -> std::string"""
        return _IMP_atom.OrPDBSelector___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_OrPDBSelector(o)


# Register OrPDBSelector in _IMP_atom:
_IMP_atom.OrPDBSelector_swigregister(OrPDBSelector)

class XorPDBSelector(PDBSelector):
    r"""Proxy of C++ IMP::atom::XorPDBSelector class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def get_version_info(self):
        r"""get_version_info(XorPDBSelector self) -> VersionInfo"""
        return _IMP_atom.XorPDBSelector_get_version_info(self)

    def __init__(self, a, b):
        r"""__init__(XorPDBSelector self, PDBSelector a, PDBSelector b) -> XorPDBSelector"""
        _IMP_atom.XorPDBSelector_swiginit(self, _IMP_atom.new_XorPDBSelector(a, b))

    def __str__(self):
        r"""__str__(XorPDBSelector self) -> std::string"""
        return _IMP_atom.XorPDBSelector___str__(self)

    def __repr__(self):
        r"""__repr__(XorPDBSelector self) -> std::string"""
        return _IMP_atom.XorPDBSelector___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_XorPDBSelector(o)


# Register XorPDBSelector in _IMP_atom:
_IMP_atom.XorPDBSelector_swigregister(XorPDBSelector)

class NotPDBSelector(PDBSelector):
    r"""Proxy of C++ IMP::atom::NotPDBSelector class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def get_version_info(self):
        r"""get_version_info(NotPDBSelector self) -> VersionInfo"""
        return _IMP_atom.NotPDBSelector_get_version_info(self)

    def __init__(self, a):
        r"""__init__(NotPDBSelector self, PDBSelector a) -> NotPDBSelector"""
        _IMP_atom.NotPDBSelector_swiginit(self, _IMP_atom.new_NotPDBSelector(a))

    def __str__(self):
        r"""__str__(NotPDBSelector self) -> std::string"""
        return _IMP_atom.NotPDBSelector___str__(self)

    def __repr__(self):
        r"""__repr__(NotPDBSelector self) -> std::string"""
        return _IMP_atom.NotPDBSelector___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_NotPDBSelector(o)


# Register NotPDBSelector in _IMP_atom:
_IMP_atom.NotPDBSelector_swigregister(NotPDBSelector)


def get_default_pdb_selector():
    r"""get_default_pdb_selector() -> PDBSelector"""
    return _IMP_atom.get_default_pdb_selector()

def read_pdb(*args):
    r"""
    read_pdb(TextInput input, Model model, PDBSelector selector=IMP::atom::get_default_pdb_selector(), bool select_first_model=True, bool no_radii=False) -> Hierarchy
    read_pdb(TextInput input, int model, Hierarchy h)
    """
    return _IMP_atom.read_pdb(*args)

def read_multimodel_pdb(*args):
    r"""read_multimodel_pdb(TextInput input, Model model, PDBSelector selector=IMP::atom::get_default_pdb_selector(), bool noradii=False) -> IMP::atom::Hierarchies"""
    return _IMP_atom.read_multimodel_pdb(*args)

def write_pdb(mhd, out, model=1):
    r"""write_pdb(Selection mhd, TextOutput out, unsigned int model=1)"""
    return _IMP_atom.write_pdb(mhd, out, model)

def write_pdb_of_c_alphas(mhd, out, model=1):
    r"""write_pdb_of_c_alphas(Selection mhd, TextOutput out, unsigned int model=1)"""
    return _IMP_atom.write_pdb_of_c_alphas(mhd, out, model)

def write_multimodel_pdb(mhd, out):
    r"""write_multimodel_pdb(IMP::atom::Hierarchies const & mhd, TextOutput out)"""
    return _IMP_atom.write_multimodel_pdb(mhd, out)

def get_pdb_string(*args):
    r"""get_pdb_string(Vector3D v, int index=-1, AtomType at=AT_CA, ResidueType rt=ALA, char chain=' ', int res_index=1, char res_icode=' ', double occupancy=1.00, double tempFactor=0.00, IMP::atom::Element e=C) -> std::string"""
    return _IMP_atom.get_pdb_string(*args)

def get_pdb_conect_record_string(arg1, arg2):
    r"""get_pdb_conect_record_string(int arg1, int arg2) -> std::string"""
    return _IMP_atom.get_pdb_conect_record_string(arg1, arg2)
class WritePDBOptimizerState(IMP.OptimizerState):
    r"""Proxy of C++ IMP::atom::WritePDBOptimizerState class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args):
        r"""
        __init__(WritePDBOptimizerState self, Model m, _ParticleIndexesAdaptor pis, std::string filename) -> WritePDBOptimizerState
        __init__(WritePDBOptimizerState self, IMP::atom::Hierarchies const mh, std::string filename) -> WritePDBOptimizerState
        """
        _IMP_atom.WritePDBOptimizerState_swiginit(self, _IMP_atom.new_WritePDBOptimizerState(*args))

    def get_version_info(self):
        r"""get_version_info(WritePDBOptimizerState self) -> VersionInfo"""
        return _IMP_atom.WritePDBOptimizerState_get_version_info(self)

    def __str__(self):
        r"""__str__(WritePDBOptimizerState self) -> std::string"""
        return _IMP_atom.WritePDBOptimizerState___str__(self)

    def __repr__(self):
        r"""__repr__(WritePDBOptimizerState self) -> std::string"""
        return _IMP_atom.WritePDBOptimizerState___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_WritePDBOptimizerState(o)


# Register WritePDBOptimizerState in _IMP_atom:
_IMP_atom.WritePDBOptimizerState_swigregister(WritePDBOptimizerState)


def read_multimodel_mmcif(*args):
    r"""read_multimodel_mmcif(TextInput input, Model model, PDBSelector selector=IMP::atom::get_default_pdb_selector(), bool noradii=False) -> IMP::atom::Hierarchies"""
    return _IMP_atom.read_multimodel_mmcif(*args)

def read_mmcif(*args):
    r"""read_mmcif(TextInput input, Model model, PDBSelector selector=IMP::atom::get_default_pdb_selector(), bool noradii=False) -> Hierarchy"""
    return _IMP_atom.read_mmcif(*args)

def get_kt(T):
    r"""get_kt(double T) -> double"""
    return _IMP_atom.get_kt(T)
class CAAngleRestraint(IMP.Restraint):
    r"""Proxy of C++ IMP::atom::CAAngleRestraint class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, m, p1, p2, p3, phi0, score):
        r"""__init__(CAAngleRestraint self, Model m, _ParticleIndexAdaptor p1, _ParticleIndexAdaptor p2, _ParticleIndexAdaptor p3, IMP::Floats phi0, IMP::Floats score) -> CAAngleRestraint"""
        _IMP_atom.CAAngleRestraint_swiginit(self, _IMP_atom.new_CAAngleRestraint(m, p1, p2, p3, phi0, score))

    def do_get_inputs(self):
        r"""do_get_inputs(CAAngleRestraint self) -> IMP::ModelObjectsTemp"""
        return _IMP_atom.CAAngleRestraint_do_get_inputs(self)

    def get_version_info(self):
        r"""get_version_info(CAAngleRestraint self) -> VersionInfo"""
        return _IMP_atom.CAAngleRestraint_get_version_info(self)

    def __str__(self):
        r"""__str__(CAAngleRestraint self) -> std::string"""
        return _IMP_atom.CAAngleRestraint___str__(self)

    def __repr__(self):
        r"""__repr__(CAAngleRestraint self) -> std::string"""
        return _IMP_atom.CAAngleRestraint___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_CAAngleRestraint(o)


# Register CAAngleRestraint in _IMP_atom:
_IMP_atom.CAAngleRestraint_swigregister(CAAngleRestraint)

class CADihedralRestraint(IMP.Restraint):
    r"""Proxy of C++ IMP::atom::CADihedralRestraint class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, m, p1, p2, p3, p4, p5, phi0, phi1, score):
        r"""__init__(CADihedralRestraint self, Model m, _ParticleIndexAdaptor p1, _ParticleIndexAdaptor p2, _ParticleIndexAdaptor p3, _ParticleIndexAdaptor p4, _ParticleIndexAdaptor p5, IMP::Floats phi0, IMP::Floats phi1, IMP::Floats score) -> CADihedralRestraint"""
        _IMP_atom.CADihedralRestraint_swiginit(self, _IMP_atom.new_CADihedralRestraint(m, p1, p2, p3, p4, p5, phi0, phi1, score))

    def do_get_inputs(self):
        r"""do_get_inputs(CADihedralRestraint self) -> IMP::ModelObjectsTemp"""
        return _IMP_atom.CADihedralRestraint_do_get_inputs(self)

    def get_version_info(self):
        r"""get_version_info(CADihedralRestraint self) -> VersionInfo"""
        return _IMP_atom.CADihedralRestraint_get_version_info(self)

    def __str__(self):
        r"""__str__(CADihedralRestraint self) -> std::string"""
        return _IMP_atom.CADihedralRestraint___str__(self)

    def __repr__(self):
        r"""__repr__(CADihedralRestraint self) -> std::string"""
        return _IMP_atom.CADihedralRestraint___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_CADihedralRestraint(o)


# Register CADihedralRestraint in _IMP_atom:
_IMP_atom.CADihedralRestraint_swigregister(CADihedralRestraint)

class StructureSource(IMP.Decorator):
    r"""Proxy of C++ IMP::atom::StructureSource class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def get_source_id(self):
        r"""get_source_id(StructureSource self) -> std::string"""
        return _IMP_atom.StructureSource_get_source_id(self)

    def get_source_chain_id(self):
        r"""get_source_chain_id(StructureSource self) -> std::string"""
        return _IMP_atom.StructureSource_get_source_chain_id(self)

    def set_source_id(self, source_id):
        r"""set_source_id(StructureSource self, std::string source_id)"""
        return _IMP_atom.StructureSource_set_source_id(self, source_id)

    def set_source_chain_id(self, source_chain_id):
        r"""set_source_chain_id(StructureSource self, std::string source_chain_id)"""
        return _IMP_atom.StructureSource_set_source_chain_id(self, source_chain_id)

    def __init__(self, *args):
        r"""
        __init__(StructureSource self) -> StructureSource
        __init__(StructureSource self, Model m, ParticleIndex id) -> StructureSource
        __init__(StructureSource self, _ParticleAdaptor d) -> StructureSource
        """
        _IMP_atom.StructureSource_swiginit(self, _IMP_atom.new_StructureSource(*args))

    @staticmethod
    def get_is_setup(*args):
        r"""
        get_is_setup(Model m, ParticleIndex pi) -> bool
        get_is_setup(_ParticleAdaptor p) -> bool
        """
        return _IMP_atom.StructureSource_get_is_setup(*args)

    def show(self, *args):
        r"""show(StructureSource self, _ostream out=std::cout)"""
        return _IMP_atom.StructureSource_show(self, *args)

    @staticmethod
    def setup_particle(*args):
        r"""
        setup_particle(Model m, ParticleIndex pi, std::string source_id, std::string source_chain_id) -> StructureSource
        setup_particle(_ParticleAdaptor decorator, std::string source_id, std::string source_chain_id) -> StructureSource
        """
        return _IMP_atom.StructureSource_setup_particle(*args)

    def add_attribute(self, *args):
        r"""
        add_attribute(StructureSource self, FloatKey k, IMP::Float v, bool opt)
        add_attribute(StructureSource self, FloatKey a0, IMP::Float a1)
        add_attribute(StructureSource self, IntKey a0, IMP::Int a1)
        add_attribute(StructureSource self, FloatsKey a0, IMP::Floats a1)
        add_attribute(StructureSource self, IntsKey a0, IMP::Ints a1)
        add_attribute(StructureSource self, StringKey a0, IMP::String a1)
        add_attribute(StructureSource self, ParticleIndexKey a0, Particle a1)
        add_attribute(StructureSource self, ObjectKey a0, Object a1)
        """
        return _IMP_atom.StructureSource_add_attribute(self, *args)

    def get_value(self, *args):
        r"""
        get_value(StructureSource self, FloatKey a0) -> IMP::Float
        get_value(StructureSource self, IntKey a0) -> IMP::Int
        get_value(StructureSource self, FloatsKey a0) -> IMP::Floats
        get_value(StructureSource self, IntsKey a0) -> IMP::Ints
        get_value(StructureSource self, StringKey a0) -> IMP::String
        get_value(StructureSource self, ParticleIndexKey a0) -> Particle
        get_value(StructureSource self, ObjectKey a0) -> Object
        """
        return _IMP_atom.StructureSource_get_value(self, *args)

    def set_value(self, *args):
        r"""
        set_value(StructureSource self, FloatKey a0, IMP::Float a1)
        set_value(StructureSource self, IntKey a0, IMP::Int a1)
        set_value(StructureSource self, FloatsKey a0, IMP::Floats a1)
        set_value(StructureSource self, IntsKey a0, IMP::Ints a1)
        set_value(StructureSource self, StringKey a0, IMP::String a1)
        set_value(StructureSource self, ParticleIndexKey a0, Particle a1)
        set_value(StructureSource self, ObjectKey a0, Object a1)
        """
        return _IMP_atom.StructureSource_set_value(self, *args)

    def remove_attribute(self, *args):
        r"""
        remove_attribute(StructureSource self, FloatKey a0)
        remove_attribute(StructureSource self, IntKey a0)
        remove_attribute(StructureSource self, FloatsKey a0)
        remove_attribute(StructureSource self, IntsKey a0)
        remove_attribute(StructureSource self, StringKey a0)
        remove_attribute(StructureSource self, ParticleIndexKey a0)
        remove_attribute(StructureSource self, ObjectKey a0)
        """
        return _IMP_atom.StructureSource_remove_attribute(self, *args)

    def has_attribute(self, *args):
        r"""
        has_attribute(StructureSource self, FloatKey a0) -> bool
        has_attribute(StructureSource self, IntKey a0) -> bool
        has_attribute(StructureSource self, FloatsKey a0) -> bool
        has_attribute(StructureSource self, IntsKey a0) -> bool
        has_attribute(StructureSource self, StringKey a0) -> bool
        has_attribute(StructureSource self, ParticleIndexKey a0) -> bool
        has_attribute(StructureSource self, ObjectKey a0) -> bool
        """
        return _IMP_atom.StructureSource_has_attribute(self, *args)

    def get_derivative(self, a0):
        r"""get_derivative(StructureSource self, FloatKey a0) -> double"""
        return _IMP_atom.StructureSource_get_derivative(self, a0)

    def get_name(self):
        r"""get_name(StructureSource self) -> std::string"""
        return _IMP_atom.StructureSource_get_name(self)

    def clear_caches(self):
        r"""clear_caches(StructureSource self)"""
        return _IMP_atom.StructureSource_clear_caches(self)

    def set_name(self, a0):
        r"""set_name(StructureSource self, std::string a0)"""
        return _IMP_atom.StructureSource_set_name(self, a0)

    def set_check_level(self, a0):
        r"""set_check_level(StructureSource self, IMP::CheckLevel a0)"""
        return _IMP_atom.StructureSource_set_check_level(self, a0)

    def add_to_derivative(self, a0, a1, a2):
        r"""add_to_derivative(StructureSource self, FloatKey a0, double a1, DerivativeAccumulator a2)"""
        return _IMP_atom.StructureSource_add_to_derivative(self, a0, a1, a2)

    def set_is_optimized(self, a0, a1):
        r"""set_is_optimized(StructureSource self, FloatKey a0, bool a1)"""
        return _IMP_atom.StructureSource_set_is_optimized(self, a0, a1)

    def get_is_optimized(self, a0):
        r"""get_is_optimized(StructureSource self, FloatKey a0) -> bool"""
        return _IMP_atom.StructureSource_get_is_optimized(self, a0)

    def get_check_level(self):
        r"""get_check_level(StructureSource self) -> IMP::CheckLevel"""
        return _IMP_atom.StructureSource_get_check_level(self)

    def __eq__(self, *args):
        r"""
        __eq__(StructureSource self, StructureSource o) -> bool
        __eq__(StructureSource self, Particle d) -> bool
        """
        return _IMP_atom.StructureSource___eq__(self, *args)

    def __ne__(self, *args):
        r"""
        __ne__(StructureSource self, StructureSource o) -> bool
        __ne__(StructureSource self, Particle d) -> bool
        """
        return _IMP_atom.StructureSource___ne__(self, *args)

    def __le__(self, *args):
        r"""
        __le__(StructureSource self, StructureSource o) -> bool
        __le__(StructureSource self, Particle d) -> bool
        """
        return _IMP_atom.StructureSource___le__(self, *args)

    def __lt__(self, *args):
        r"""
        __lt__(StructureSource self, StructureSource o) -> bool
        __lt__(StructureSource self, Particle d) -> bool
        """
        return _IMP_atom.StructureSource___lt__(self, *args)

    def __ge__(self, *args):
        r"""
        __ge__(StructureSource self, StructureSource o) -> bool
        __ge__(StructureSource self, Particle d) -> bool
        """
        return _IMP_atom.StructureSource___ge__(self, *args)

    def __gt__(self, *args):
        r"""
        __gt__(StructureSource self, StructureSource o) -> bool
        __gt__(StructureSource self, Particle d) -> bool
        """
        return _IMP_atom.StructureSource___gt__(self, *args)

    def __hash__(self):
        r"""__hash__(StructureSource self) -> std::size_t"""
        return _IMP_atom.StructureSource___hash__(self)

    def __str__(self):
        r"""__str__(StructureSource self) -> std::string"""
        return _IMP_atom.StructureSource___str__(self)

    def __repr__(self):
        r"""__repr__(StructureSource self) -> std::string"""
        return _IMP_atom.StructureSource___repr__(self)
    __swig_destroy__ = _IMP_atom.delete_StructureSource

# Register StructureSource in _IMP_atom:
_IMP_atom.StructureSource_swigregister(StructureSource)

def StructureSource_get_is_setup(*args):
    r"""
    StructureSource_get_is_setup(Model m, ParticleIndex pi) -> bool
    StructureSource_get_is_setup(_ParticleAdaptor p) -> bool
    """
    return _IMP_atom.StructureSource_get_is_setup(*args)

def StructureSource_setup_particle(*args):
    r"""
    StructureSource_setup_particle(Model m, ParticleIndex pi, std::string source_id, std::string source_chain_id) -> StructureSource
    StructureSource_setup_particle(_ParticleAdaptor decorator, std::string source_id, std::string source_chain_id) -> StructureSource
    """
    return _IMP_atom.StructureSource_setup_particle(*args)


def __lshift__(*args):
    r"""
    __lshift__(_ostream out, Bonded n) -> _ostream
    __lshift__(_ostream out, Bond n) -> _ostream
    __lshift__(_ostream out, Hierarchy n) -> _ostream
    __lshift__(_ostream out, Angle n) -> _ostream
    __lshift__(_ostream out, Dihedral n) -> _ostream
    __lshift__(_ostream out, CenterOfMass n) -> _ostream
    __lshift__(_ostream out, Diffusion n) -> _ostream
    __lshift__(_ostream out, RigidBodyDiffusion n) -> _ostream
    __lshift__(_ostream out, TAMDParticle n) -> _ostream
    __lshift__(_ostream out, Chain n) -> _ostream
    __lshift__(_ostream out, Charged n) -> _ostream
    __lshift__(_ostream out, Domain n) -> _ostream
    __lshift__(_ostream out, LennardJones n) -> _ostream
    __lshift__(_ostream out, Fragment n) -> _ostream
    __lshift__(_ostream out, SecondaryStructureResidue n) -> _ostream
    __lshift__(_ostream out, Atom n) -> _ostream
    __lshift__(_ostream out, Residue n) -> _ostream
    __lshift__(_ostream out, Representation n) -> _ostream
    __lshift__(_ostream out, State n) -> _ostream
    __lshift__(_ostream out, Molecule n) -> _ostream
    __lshift__(_ostream out, Copy n) -> _ostream
    __lshift__(_ostream out, StructureSource n) -> _ostream
    """
    return _IMP_atom.__lshift__(*args)
class HelixRestraint(IMP.Restraint):
    r"""Proxy of C++ IMP::atom::HelixRestraint class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, rs, ideal=True):
        r"""__init__(HelixRestraint self, IMP::atom::Residues rs, bool ideal=True) -> HelixRestraint"""
        _IMP_atom.HelixRestraint_swiginit(self, _IMP_atom.new_HelixRestraint(rs, ideal))

    def get_number_of_bonds(self):
        r"""get_number_of_bonds(HelixRestraint self) -> int"""
        return _IMP_atom.HelixRestraint_get_number_of_bonds(self)

    def get_number_of_dihedrals(self):
        r"""get_number_of_dihedrals(HelixRestraint self) -> int"""
        return _IMP_atom.HelixRestraint_get_number_of_dihedrals(self)

    def do_get_inputs(self):
        r"""do_get_inputs(HelixRestraint self) -> IMP::ModelObjectsTemp"""
        return _IMP_atom.HelixRestraint_do_get_inputs(self)

    def get_version_info(self):
        r"""get_version_info(HelixRestraint self) -> VersionInfo"""
        return _IMP_atom.HelixRestraint_get_version_info(self)

    def __str__(self):
        r"""__str__(HelixRestraint self) -> std::string"""
        return _IMP_atom.HelixRestraint___str__(self)

    def __repr__(self):
        r"""__repr__(HelixRestraint self) -> std::string"""
        return _IMP_atom.HelixRestraint___repr__(self)

    @staticmethod
    def get_from(o):
       return _object_cast_to_HelixRestraint(o)


# Register HelixRestraint in _IMP_atom:
_IMP_atom.HelixRestraint_swigregister(HelixRestraint)


def get_transformation_aligning_first_to_second(s1, s2):
    r"""get_transformation_aligning_first_to_second(Selection s1, Selection s2) -> Transformation3D"""
    return _IMP_atom.get_transformation_aligning_first_to_second(s1, s2)

def show_molecular_hierarchy(*args):
    r"""show_molecular_hierarchy(Hierarchy h, _ostream out=std::cout) -> _ostream"""
    return _IMP_atom.show_molecular_hierarchy(*args)
class CHARMMBond(object):
    r"""Proxy of C++ IMP::atom::CHARMMConnection< 2 > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, atoms):
        r"""__init__(CHARMMBond self, IMP::Strings const & atoms) -> CHARMMBond"""
        _IMP_atom.CHARMMBond_swiginit(self, _IMP_atom.new_CHARMMBond(atoms))

    def get_endpoint(self, i):
        r"""get_endpoint(CHARMMBond self, unsigned int i) -> CHARMMBondEndpoint"""
        return _IMP_atom.CHARMMBond_get_endpoint(self, i)

    def get_contains_atom(self, name):
        r"""get_contains_atom(CHARMMBond self, std::string name) -> bool"""
        return _IMP_atom.CHARMMBond_get_contains_atom(self, name)

    def show(self, *args):
        r"""show(CHARMMBond self, _ostream out=std::cout)"""
        return _IMP_atom.CHARMMBond_show(self, *args)
    __swig_destroy__ = _IMP_atom.delete_CHARMMBond

# Register CHARMMBond in _IMP_atom:
_IMP_atom.CHARMMBond_swigregister(CHARMMBond)

class CHARMMAngle(object):
    r"""Proxy of C++ IMP::atom::CHARMMConnection< 3 > class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, atoms):
        r"""__init__(CHARMMAngle self, IMP::Strings const & atoms) -> CHARMMAngle"""
        _IMP_atom.CHARMMAngle_swiginit(self, _IMP_atom.new_CHARMMAngle(atoms))

    def get_endpoint(self, i):
        r"""get_endpoint(CHARMMAngle self, unsigned int i) -> CHARMMBondEndpoint"""
        return _IMP_atom.CHARMMAngle_get_endpoint(self, i)

    def get_contains_atom(self, name):
        r"""get_contains_atom(CHARMMAngle self, std::string name) -> bool"""
        return _IMP_atom.CHARMMAngle_get_contains_atom(self, name)

    def show(self, *args):
        r"""show(CHARMMAngle self, _ostream out=std::cout)"""
        return _IMP_atom.CHARMMAngle_show(self, *args)
    __swig_destroy__ = _IMP_atom.delete_CHARMMAngle

# Register CHARMMAngle in _IMP_atom:
_IMP_atom.CHARMMAngle_swigregister(CHARMMAngle)


def _get_native_overlap_cpp(m1, m2, threshold):
    r"""_get_native_overlap_cpp(IMP::Vector< IMP::algebra::VectorD< 3 > > const & m1, IMP::Vector< IMP::algebra::VectorD< 3 > > const & m2, double threshold) -> double"""
    return _IMP_atom._get_native_overlap_cpp(m1, m2, threshold)

def _get_drmsd_cpp(m0, m1):
    r"""_get_drmsd_cpp(IMP::Vector< IMP::algebra::VectorD< 3 > > const & m0, IMP::Vector< IMP::algebra::VectorD< 3 > > const & m1) -> double"""
    return _IMP_atom._get_drmsd_cpp(m0, m1)

def _get_drmsd_Q_cpp(m0, m1, threshold):
    r"""_get_drmsd_Q_cpp(IMP::Vector< IMP::algebra::VectorD< 3 > > const & m0, IMP::Vector< IMP::algebra::VectorD< 3 > > const & m1, double threshold) -> double"""
    return _IMP_atom._get_drmsd_Q_cpp(m0, m1, threshold)

def _get_drms_cpp(m1, m2):
    r"""_get_drms_cpp(IMP::Vector< IMP::algebra::VectorD< 3 > > const & m1, IMP::Vector< IMP::algebra::VectorD< 3 > > const & m2) -> double"""
    return _IMP_atom._get_drms_cpp(m1, m2)

def _get_rigid_bodies_drms_cpp(m1, m2, ranges):
    r"""_get_rigid_bodies_drms_cpp(IMP::Vector< IMP::algebra::VectorD< 3 > > const & m1, IMP::Vector< IMP::algebra::VectorD< 3 > > const & m2, IMP::IntRanges const & ranges) -> double"""
    return _IMP_atom._get_rigid_bodies_drms_cpp(m1, m2, ranges)

def get_native_overlap(a, b, d):
   va= [IMP.algebra.get_vector(x) for x in a]
   vb= [IMP.algebra.get_vector(x) for x in b]
   return _get_native_overlap_cpp(va, vb, d)

def get_drmsd(a, b):
   va= [IMP.algebra.get_vector(x) for x in a]
   vb= [IMP.algebra.get_vector(x) for x in b]
   return _get_drmsd_cpp(va, vb)

def get_drms(a, b):
   va= [IMP.algebra.get_vector(x) for x in a]
   vb= [IMP.algebra.get_vector(x) for x in b]
   return _get_drms_cpp(va, vb)

def get_drmsd_Q(a, b, t):
   va= [IMP.algebra.get_vector(x) for x in a]
   vb= [IMP.algebra.get_vector(x) for x in b]
   return _get_drmsd_Q_cpp(va, vb, t)

def get_rigid_bodies_drms(a, b, ranges):
    va= [IMP.algebra.get_vector(x) for x in a]
    vb= [IMP.algebra.get_vector(x) for x in b]
#rs = [IMP.IntRange(r[0],r[1]) for r in ranges]
    return _get_rigid_bodies_drms_cpp(va, vb, ranges)



def get_module_version():
    r"""get_module_version() -> std::string const"""
    return _IMP_atom.get_module_version()

def get_example_path(fname):
    r"""get_example_path(std::string fname) -> std::string"""
    return _IMP_atom.get_example_path(fname)

def get_data_path(fname):
    r"""get_data_path(std::string fname) -> std::string"""
    return _IMP_atom.get_data_path(fname)

from . import _version_check
_version_check.check_version(get_module_version())
__version__ = get_module_version()



