/********************************************************************************
 *                                                                              *
 * This file is part of IfcOpenShell.                                           *
 *                                                                              *
 * IfcOpenShell is free software: you can redistribute it and/or modify         *
 * it under the terms of the Lesser GNU General Public License as published by  *
 * the Free Software Foundation, either version 3.0 of the License, or          *
 * (at your option) any later version.                                          *
 *                                                                              *
 * IfcOpenShell is distributed in the hope that it will be useful,              *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of               *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the                 *
 * Lesser GNU General Public License for more details.                          *
 *                                                                              *
 * You should have received a copy of the Lesser GNU General Public License     *
 * along with this program. If not, see <http://www.gnu.org/licenses/>.         *
 *                                                                              *
 ********************************************************************************/

/********************************************************************************
 *                                                                              *
 * This file has been generated from IFC2X3_TC1.exp. Do not make modifications  *
 * but instead modify the python script that has been used to generate this.    *
 *                                                                              *
 ********************************************************************************/

#ifndef IFC2X3_H
#define IFC2X3_H

#include <string>
#include <vector>

#include <boost/optional.hpp>

#include "../ifcparse/ifc_parse_api.h"

#include "../ifcparse/IfcEntityList.h"
#include "../ifcparse/IfcBaseClass.h"
#include "../ifcparse/IfcSchema.h"
#include "../ifcparse/IfcException.h"
#include "../ifcparse/Argument.h"

#include "../ifcparse/Ifc2x3enum.h"

struct Ifc2x3 {

static const IfcParse::schema_definition& get_schema();

static const char* const Identifier;

// Forward definitions
class Ifc2DCompositeCurve; class IfcActionRequest; class IfcActor; class IfcActorRole; class IfcActuatorType; class IfcAddress; class IfcAirTerminalBoxType; class IfcAirTerminalType; class IfcAirToAirHeatRecoveryType; class IfcAlarmType; class IfcAngularDimension; class IfcAnnotation; class IfcAnnotationCurveOccurrence; class IfcAnnotationFillArea; class IfcAnnotationFillAreaOccurrence; class IfcAnnotationOccurrence; class IfcAnnotationSurface; class IfcAnnotationSurfaceOccurrence; class IfcAnnotationSymbolOccurrence; class IfcAnnotationTextOccurrence; class IfcApplication; class IfcAppliedValue; class IfcAppliedValueRelationship; class IfcApproval; class IfcApprovalActorRelationship; class IfcApprovalPropertyRelationship; class IfcApprovalRelationship; class IfcArbitraryClosedProfileDef; class IfcArbitraryOpenProfileDef; class IfcArbitraryProfileDefWithVoids; class IfcAsset; class IfcAsymmetricIShapeProfileDef; class IfcAxis1Placement; class IfcAxis2Placement2D; class IfcAxis2Placement3D; class IfcBSplineCurve; class IfcBeam; class IfcBeamType; class IfcBezierCurve; class IfcBlobTexture; class IfcBlock; class IfcBoilerType; class IfcBooleanClippingResult; class IfcBooleanResult; class IfcBoundaryCondition; class IfcBoundaryEdgeCondition; class IfcBoundaryFaceCondition; class IfcBoundaryNodeCondition; class IfcBoundaryNodeConditionWarping; class IfcBoundedCurve; class IfcBoundedSurface; class IfcBoundingBox; class IfcBoxedHalfSpace; class IfcBuilding; class IfcBuildingElement; class IfcBuildingElementComponent; class IfcBuildingElementPart; class IfcBuildingElementProxy; class IfcBuildingElementProxyType; class IfcBuildingElementType; class IfcBuildingStorey; class IfcCShapeProfileDef; class IfcCableCarrierFittingType; class IfcCableCarrierSegmentType; class IfcCableSegmentType; class IfcCalendarDate; class IfcCartesianPoint; class IfcCartesianTransformationOperator; class IfcCartesianTransformationOperator2D; class IfcCartesianTransformationOperator2DnonUniform; class IfcCartesianTransformationOperator3D; class IfcCartesianTransformationOperator3DnonUniform; class IfcCenterLineProfileDef; class IfcChamferEdgeFeature; class IfcChillerType; class IfcCircle; class IfcCircleHollowProfileDef; class IfcCircleProfileDef; class IfcClassification; class IfcClassificationItem; class IfcClassificationItemRelationship; class IfcClassificationNotation; class IfcClassificationNotationFacet; class IfcClassificationReference; class IfcClosedShell; class IfcCoilType; class IfcColourRgb; class IfcColourSpecification; class IfcColumn; class IfcColumnType; class IfcComplexProperty; class IfcCompositeCurve; class IfcCompositeCurveSegment; class IfcCompositeProfileDef; class IfcCompressorType; class IfcCondenserType; class IfcCondition; class IfcConditionCriterion; class IfcConic; class IfcConnectedFaceSet; class IfcConnectionCurveGeometry; class IfcConnectionGeometry; class IfcConnectionPointEccentricity; class IfcConnectionPointGeometry; class IfcConnectionPortGeometry; class IfcConnectionSurfaceGeometry; class IfcConstraint; class IfcConstraintAggregationRelationship; class IfcConstraintClassificationRelationship; class IfcConstraintRelationship; class IfcConstructionEquipmentResource; class IfcConstructionMaterialResource; class IfcConstructionProductResource; class IfcConstructionResource; class IfcContextDependentUnit; class IfcControl; class IfcControllerType; class IfcConversionBasedUnit; class IfcCooledBeamType; class IfcCoolingTowerType; class IfcCoordinatedUniversalTimeOffset; class IfcCostItem; class IfcCostSchedule; class IfcCostValue; class IfcCovering; class IfcCoveringType; class IfcCraneRailAShapeProfileDef; class IfcCraneRailFShapeProfileDef; class IfcCrewResource; class IfcCsgPrimitive3D; class IfcCsgSolid; class IfcCurrencyRelationship; class IfcCurtainWall; class IfcCurtainWallType; class IfcCurve; class IfcCurveBoundedPlane; class IfcCurveStyle; class IfcCurveStyleFont; class IfcCurveStyleFontAndScaling; class IfcCurveStyleFontPattern; class IfcDamperType; class IfcDateAndTime; class IfcDefinedSymbol; class IfcDerivedProfileDef; class IfcDerivedUnit; class IfcDerivedUnitElement; class IfcDiameterDimension; class IfcDimensionCalloutRelationship; class IfcDimensionCurve; class IfcDimensionCurveDirectedCallout; class IfcDimensionCurveTerminator; class IfcDimensionPair; class IfcDimensionalExponents; class IfcDirection; class IfcDiscreteAccessory; class IfcDiscreteAccessoryType; class IfcDistributionChamberElement; class IfcDistributionChamberElementType; class IfcDistributionControlElement; class IfcDistributionControlElementType; class IfcDistributionElement; class IfcDistributionElementType; class IfcDistributionFlowElement; class IfcDistributionFlowElementType; class IfcDistributionPort; class IfcDocumentElectronicFormat; class IfcDocumentInformation; class IfcDocumentInformationRelationship; class IfcDocumentReference; class IfcDoor; class IfcDoorLiningProperties; class IfcDoorPanelProperties; class IfcDoorStyle; class IfcDraughtingCallout; class IfcDraughtingCalloutRelationship; class IfcDraughtingPreDefinedColour; class IfcDraughtingPreDefinedCurveFont; class IfcDraughtingPreDefinedTextFont; class IfcDuctFittingType; class IfcDuctSegmentType; class IfcDuctSilencerType; class IfcEdge; class IfcEdgeCurve; class IfcEdgeFeature; class IfcEdgeLoop; class IfcElectricApplianceType; class IfcElectricDistributionPoint; class IfcElectricFlowStorageDeviceType; class IfcElectricGeneratorType; class IfcElectricHeaterType; class IfcElectricMotorType; class IfcElectricTimeControlType; class IfcElectricalBaseProperties; class IfcElectricalCircuit; class IfcElectricalElement; class IfcElement; class IfcElementAssembly; class IfcElementComponent; class IfcElementComponentType; class IfcElementQuantity; class IfcElementType; class IfcElementarySurface; class IfcEllipse; class IfcEllipseProfileDef; class IfcEnergyConversionDevice; class IfcEnergyConversionDeviceType; class IfcEnergyProperties; class IfcEnvironmentalImpactValue; class IfcEquipmentElement; class IfcEquipmentStandard; class IfcEvaporativeCoolerType; class IfcEvaporatorType; class IfcExtendedMaterialProperties; class IfcExternalReference; class IfcExternallyDefinedHatchStyle; class IfcExternallyDefinedSurfaceStyle; class IfcExternallyDefinedSymbol; class IfcExternallyDefinedTextFont; class IfcExtrudedAreaSolid; class IfcFace; class IfcFaceBasedSurfaceModel; class IfcFaceBound; class IfcFaceOuterBound; class IfcFaceSurface; class IfcFacetedBrep; class IfcFacetedBrepWithVoids; class IfcFailureConnectionCondition; class IfcFanType; class IfcFastener; class IfcFastenerType; class IfcFeatureElement; class IfcFeatureElementAddition; class IfcFeatureElementSubtraction; class IfcFillAreaStyle; class IfcFillAreaStyleHatching; class IfcFillAreaStyleTileSymbolWithStyle; class IfcFillAreaStyleTiles; class IfcFilterType; class IfcFireSuppressionTerminalType; class IfcFlowController; class IfcFlowControllerType; class IfcFlowFitting; class IfcFlowFittingType; class IfcFlowInstrumentType; class IfcFlowMeterType; class IfcFlowMovingDevice; class IfcFlowMovingDeviceType; class IfcFlowSegment; class IfcFlowSegmentType; class IfcFlowStorageDevice; class IfcFlowStorageDeviceType; class IfcFlowTerminal; class IfcFlowTerminalType; class IfcFlowTreatmentDevice; class IfcFlowTreatmentDeviceType; class IfcFluidFlowProperties; class IfcFooting; class IfcFuelProperties; class IfcFurnishingElement; class IfcFurnishingElementType; class IfcFurnitureStandard; class IfcFurnitureType; class IfcGasTerminalType; class IfcGeneralMaterialProperties; class IfcGeneralProfileProperties; class IfcGeometricCurveSet; class IfcGeometricRepresentationContext; class IfcGeometricRepresentationItem; class IfcGeometricRepresentationSubContext; class IfcGeometricSet; class IfcGrid; class IfcGridAxis; class IfcGridPlacement; class IfcGroup; class IfcHalfSpaceSolid; class IfcHeatExchangerType; class IfcHumidifierType; class IfcHygroscopicMaterialProperties; class IfcIShapeProfileDef; class IfcImageTexture; class IfcInventory; class IfcIrregularTimeSeries; class IfcIrregularTimeSeriesValue; class IfcJunctionBoxType; class IfcLShapeProfileDef; class IfcLaborResource; class IfcLampType; class IfcLibraryInformation; class IfcLibraryReference; class IfcLightDistributionData; class IfcLightFixtureType; class IfcLightIntensityDistribution; class IfcLightSource; class IfcLightSourceAmbient; class IfcLightSourceDirectional; class IfcLightSourceGoniometric; class IfcLightSourcePositional; class IfcLightSourceSpot; class IfcLine; class IfcLinearDimension; class IfcLocalPlacement; class IfcLocalTime; class IfcLoop; class IfcManifoldSolidBrep; class IfcMappedItem; class IfcMaterial; class IfcMaterialClassificationRelationship; class IfcMaterialDefinitionRepresentation; class IfcMaterialLayer; class IfcMaterialLayerSet; class IfcMaterialLayerSetUsage; class IfcMaterialList; class IfcMaterialProperties; class IfcMeasureWithUnit; class IfcMechanicalConcreteMaterialProperties; class IfcMechanicalFastener; class IfcMechanicalFastenerType; class IfcMechanicalMaterialProperties; class IfcMechanicalSteelMaterialProperties; class IfcMember; class IfcMemberType; class IfcMetric; class IfcMonetaryUnit; class IfcMotorConnectionType; class IfcMove; class IfcNamedUnit; class IfcObject; class IfcObjectDefinition; class IfcObjectPlacement; class IfcObjective; class IfcOccupant; class IfcOffsetCurve2D; class IfcOffsetCurve3D; class IfcOneDirectionRepeatFactor; class IfcOpenShell; class IfcOpeningElement; class IfcOpticalMaterialProperties; class IfcOrderAction; class IfcOrganization; class IfcOrganizationRelationship; class IfcOrientedEdge; class IfcOutletType; class IfcOwnerHistory; class IfcParameterizedProfileDef; class IfcPath; class IfcPerformanceHistory; class IfcPermeableCoveringProperties; class IfcPermit; class IfcPerson; class IfcPersonAndOrganization; class IfcPhysicalComplexQuantity; class IfcPhysicalQuantity; class IfcPhysicalSimpleQuantity; class IfcPile; class IfcPipeFittingType; class IfcPipeSegmentType; class IfcPixelTexture; class IfcPlacement; class IfcPlanarBox; class IfcPlanarExtent; class IfcPlane; class IfcPlate; class IfcPlateType; class IfcPoint; class IfcPointOnCurve; class IfcPointOnSurface; class IfcPolyLoop; class IfcPolygonalBoundedHalfSpace; class IfcPolyline; class IfcPort; class IfcPostalAddress; class IfcPreDefinedColour; class IfcPreDefinedCurveFont; class IfcPreDefinedDimensionSymbol; class IfcPreDefinedItem; class IfcPreDefinedPointMarkerSymbol; class IfcPreDefinedSymbol; class IfcPreDefinedTerminatorSymbol; class IfcPreDefinedTextFont; class IfcPresentationLayerAssignment; class IfcPresentationLayerWithStyle; class IfcPresentationStyle; class IfcPresentationStyleAssignment; class IfcProcedure; class IfcProcess; class IfcProduct; class IfcProductDefinitionShape; class IfcProductRepresentation; class IfcProductsOfCombustionProperties; class IfcProfileDef; class IfcProfileProperties; class IfcProject; class IfcProjectOrder; class IfcProjectOrderRecord; class IfcProjectionCurve; class IfcProjectionElement; class IfcProperty; class IfcPropertyBoundedValue; class IfcPropertyConstraintRelationship; class IfcPropertyDefinition; class IfcPropertyDependencyRelationship; class IfcPropertyEnumeratedValue; class IfcPropertyEnumeration; class IfcPropertyListValue; class IfcPropertyReferenceValue; class IfcPropertySet; class IfcPropertySetDefinition; class IfcPropertySingleValue; class IfcPropertyTableValue; class IfcProtectiveDeviceType; class IfcProxy; class IfcPumpType; class IfcQuantityArea; class IfcQuantityCount; class IfcQuantityLength; class IfcQuantityTime; class IfcQuantityVolume; class IfcQuantityWeight; class IfcRadiusDimension; class IfcRailing; class IfcRailingType; class IfcRamp; class IfcRampFlight; class IfcRampFlightType; class IfcRationalBezierCurve; class IfcRectangleHollowProfileDef; class IfcRectangleProfileDef; class IfcRectangularPyramid; class IfcRectangularTrimmedSurface; class IfcReferencesValueDocument; class IfcRegularTimeSeries; class IfcReinforcementBarProperties; class IfcReinforcementDefinitionProperties; class IfcReinforcingBar; class IfcReinforcingElement; class IfcReinforcingMesh; class IfcRelAggregates; class IfcRelAssigns; class IfcRelAssignsTasks; class IfcRelAssignsToActor; class IfcRelAssignsToControl; class IfcRelAssignsToGroup; class IfcRelAssignsToProcess; class IfcRelAssignsToProduct; class IfcRelAssignsToProjectOrder; class IfcRelAssignsToResource; class IfcRelAssociates; class IfcRelAssociatesAppliedValue; class IfcRelAssociatesApproval; class IfcRelAssociatesClassification; class IfcRelAssociatesConstraint; class IfcRelAssociatesDocument; class IfcRelAssociatesLibrary; class IfcRelAssociatesMaterial; class IfcRelAssociatesProfileProperties; class IfcRelConnects; class IfcRelConnectsElements; class IfcRelConnectsPathElements; class IfcRelConnectsPortToElement; class IfcRelConnectsPorts; class IfcRelConnectsStructuralActivity; class IfcRelConnectsStructuralElement; class IfcRelConnectsStructuralMember; class IfcRelConnectsWithEccentricity; class IfcRelConnectsWithRealizingElements; class IfcRelContainedInSpatialStructure; class IfcRelCoversBldgElements; class IfcRelCoversSpaces; class IfcRelDecomposes; class IfcRelDefines; class IfcRelDefinesByProperties; class IfcRelDefinesByType; class IfcRelFillsElement; class IfcRelFlowControlElements; class IfcRelInteractionRequirements; class IfcRelNests; class IfcRelOccupiesSpaces; class IfcRelOverridesProperties; class IfcRelProjectsElement; class IfcRelReferencedInSpatialStructure; class IfcRelSchedulesCostItems; class IfcRelSequence; class IfcRelServicesBuildings; class IfcRelSpaceBoundary; class IfcRelVoidsElement; class IfcRelationship; class IfcRelaxation; class IfcRepresentation; class IfcRepresentationContext; class IfcRepresentationItem; class IfcRepresentationMap; class IfcResource; class IfcRevolvedAreaSolid; class IfcRibPlateProfileProperties; class IfcRightCircularCone; class IfcRightCircularCylinder; class IfcRoof; class IfcRoot; class IfcRoundedEdgeFeature; class IfcRoundedRectangleProfileDef; class IfcSIUnit; class IfcSanitaryTerminalType; class IfcScheduleTimeControl; class IfcSectionProperties; class IfcSectionReinforcementProperties; class IfcSectionedSpine; class IfcSensorType; class IfcServiceLife; class IfcServiceLifeFactor; class IfcShapeAspect; class IfcShapeModel; class IfcShapeRepresentation; class IfcShellBasedSurfaceModel; class IfcSimpleProperty; class IfcSite; class IfcSlab; class IfcSlabType; class IfcSlippageConnectionCondition; class IfcSolidModel; class IfcSoundProperties; class IfcSoundValue; class IfcSpace; class IfcSpaceHeaterType; class IfcSpaceProgram; class IfcSpaceThermalLoadProperties; class IfcSpaceType; class IfcSpatialStructureElement; class IfcSpatialStructureElementType; class IfcSphere; class IfcStackTerminalType; class IfcStair; class IfcStairFlight; class IfcStairFlightType; class IfcStructuralAction; class IfcStructuralActivity; class IfcStructuralAnalysisModel; class IfcStructuralConnection; class IfcStructuralConnectionCondition; class IfcStructuralCurveConnection; class IfcStructuralCurveMember; class IfcStructuralCurveMemberVarying; class IfcStructuralItem; class IfcStructuralLinearAction; class IfcStructuralLinearActionVarying; class IfcStructuralLoad; class IfcStructuralLoadGroup; class IfcStructuralLoadLinearForce; class IfcStructuralLoadPlanarForce; class IfcStructuralLoadSingleDisplacement; class IfcStructuralLoadSingleDisplacementDistortion; class IfcStructuralLoadSingleForce; class IfcStructuralLoadSingleForceWarping; class IfcStructuralLoadStatic; class IfcStructuralLoadTemperature; class IfcStructuralMember; class IfcStructuralPlanarAction; class IfcStructuralPlanarActionVarying; class IfcStructuralPointAction; class IfcStructuralPointConnection; class IfcStructuralPointReaction; class IfcStructuralProfileProperties; class IfcStructuralReaction; class IfcStructuralResultGroup; class IfcStructuralSteelProfileProperties; class IfcStructuralSurfaceConnection; class IfcStructuralSurfaceMember; class IfcStructuralSurfaceMemberVarying; class IfcStructuredDimensionCallout; class IfcStyleModel; class IfcStyledItem; class IfcStyledRepresentation; class IfcSubContractResource; class IfcSubedge; class IfcSurface; class IfcSurfaceCurveSweptAreaSolid; class IfcSurfaceOfLinearExtrusion; class IfcSurfaceOfRevolution; class IfcSurfaceStyle; class IfcSurfaceStyleLighting; class IfcSurfaceStyleRefraction; class IfcSurfaceStyleRendering; class IfcSurfaceStyleShading; class IfcSurfaceStyleWithTextures; class IfcSurfaceTexture; class IfcSweptAreaSolid; class IfcSweptDiskSolid; class IfcSweptSurface; class IfcSwitchingDeviceType; class IfcSymbolStyle; class IfcSystem; class IfcSystemFurnitureElementType; class IfcTShapeProfileDef; class IfcTable; class IfcTableRow; class IfcTankType; class IfcTask; class IfcTelecomAddress; class IfcTendon; class IfcTendonAnchor; class IfcTerminatorSymbol; class IfcTextLiteral; class IfcTextLiteralWithExtent; class IfcTextStyle; class IfcTextStyleFontModel; class IfcTextStyleForDefinedFont; class IfcTextStyleTextModel; class IfcTextStyleWithBoxCharacteristics; class IfcTextureCoordinate; class IfcTextureCoordinateGenerator; class IfcTextureMap; class IfcTextureVertex; class IfcThermalMaterialProperties; class IfcTimeSeries; class IfcTimeSeriesReferenceRelationship; class IfcTimeSeriesSchedule; class IfcTimeSeriesValue; class IfcTopologicalRepresentationItem; class IfcTopologyRepresentation; class IfcTransformerType; class IfcTransportElement; class IfcTransportElementType; class IfcTrapeziumProfileDef; class IfcTrimmedCurve; class IfcTubeBundleType; class IfcTwoDirectionRepeatFactor; class IfcTypeObject; class IfcTypeProduct; class IfcUShapeProfileDef; class IfcUnitAssignment; class IfcUnitaryEquipmentType; class IfcValveType; class IfcVector; class IfcVertex; class IfcVertexBasedTextureMap; class IfcVertexLoop; class IfcVertexPoint; class IfcVibrationIsolatorType; class IfcVirtualElement; class IfcVirtualGridIntersection; class IfcWall; class IfcWallStandardCase; class IfcWallType; class IfcWasteTerminalType; class IfcWaterProperties; class IfcWindow; class IfcWindowLiningProperties; class IfcWindowPanelProperties; class IfcWindowStyle; class IfcWorkControl; class IfcWorkPlan; class IfcWorkSchedule; class IfcZShapeProfileDef; class IfcZone; class IfcAbsorbedDoseMeasure; class IfcAccelerationMeasure; class IfcAmountOfSubstanceMeasure; class IfcAngularVelocityMeasure; class IfcAreaMeasure; class IfcBoolean; class IfcBoxAlignment; class IfcComplexNumber; class IfcCompoundPlaneAngleMeasure; class IfcContextDependentMeasure; class IfcCountMeasure; class IfcCurvatureMeasure; class IfcDayInMonthNumber; class IfcDaylightSavingHour; class IfcDescriptiveMeasure; class IfcDimensionCount; class IfcDoseEquivalentMeasure; class IfcDynamicViscosityMeasure; class IfcElectricCapacitanceMeasure; class IfcElectricChargeMeasure; class IfcElectricConductanceMeasure; class IfcElectricCurrentMeasure; class IfcElectricResistanceMeasure; class IfcElectricVoltageMeasure; class IfcEnergyMeasure; class IfcFontStyle; class IfcFontVariant; class IfcFontWeight; class IfcForceMeasure; class IfcFrequencyMeasure; class IfcGloballyUniqueId; class IfcHeatFluxDensityMeasure; class IfcHeatingValueMeasure; class IfcHourInDay; class IfcIdentifier; class IfcIlluminanceMeasure; class IfcInductanceMeasure; class IfcInteger; class IfcIntegerCountRateMeasure; class IfcIonConcentrationMeasure; class IfcIsothermalMoistureCapacityMeasure; class IfcKinematicViscosityMeasure; class IfcLabel; class IfcLengthMeasure; class IfcLinearForceMeasure; class IfcLinearMomentMeasure; class IfcLinearStiffnessMeasure; class IfcLinearVelocityMeasure; class IfcLogical; class IfcLuminousFluxMeasure; class IfcLuminousIntensityDistributionMeasure; class IfcLuminousIntensityMeasure; class IfcMagneticFluxDensityMeasure; class IfcMagneticFluxMeasure; class IfcMassDensityMeasure; class IfcMassFlowRateMeasure; class IfcMassMeasure; class IfcMassPerLengthMeasure; class IfcMinuteInHour; class IfcModulusOfElasticityMeasure; class IfcModulusOfLinearSubgradeReactionMeasure; class IfcModulusOfRotationalSubgradeReactionMeasure; class IfcModulusOfSubgradeReactionMeasure; class IfcMoistureDiffusivityMeasure; class IfcMolecularWeightMeasure; class IfcMomentOfInertiaMeasure; class IfcMonetaryMeasure; class IfcMonthInYearNumber; class IfcNormalisedRatioMeasure; class IfcNumericMeasure; class IfcPHMeasure; class IfcParameterValue; class IfcPlanarForceMeasure; class IfcPlaneAngleMeasure; class IfcPositiveLengthMeasure; class IfcPositivePlaneAngleMeasure; class IfcPositiveRatioMeasure; class IfcPowerMeasure; class IfcPresentableText; class IfcPressureMeasure; class IfcRadioActivityMeasure; class IfcRatioMeasure; class IfcReal; class IfcRotationalFrequencyMeasure; class IfcRotationalMassMeasure; class IfcRotationalStiffnessMeasure; class IfcSecondInMinute; class IfcSectionModulusMeasure; class IfcSectionalAreaIntegralMeasure; class IfcShearModulusMeasure; class IfcSolidAngleMeasure; class IfcSoundPowerMeasure; class IfcSoundPressureMeasure; class IfcSpecificHeatCapacityMeasure; class IfcSpecularExponent; class IfcSpecularRoughness; class IfcTemperatureGradientMeasure; class IfcText; class IfcTextAlignment; class IfcTextDecoration; class IfcTextFontName; class IfcTextTransformation; class IfcThermalAdmittanceMeasure; class IfcThermalConductivityMeasure; class IfcThermalExpansionCoefficientMeasure; class IfcThermalResistanceMeasure; class IfcThermalTransmittanceMeasure; class IfcThermodynamicTemperatureMeasure; class IfcTimeMeasure; class IfcTimeStamp; class IfcTorqueMeasure; class IfcVaporPermeabilityMeasure; class IfcVolumeMeasure; class IfcVolumetricFlowRateMeasure; class IfcWarpingConstantMeasure; class IfcWarpingMomentMeasure; class IfcYearNumber; 

/// The actor select type allows a person, or an organization, or a person associated with an organization to be referenced.
/// 
/// NOTE Corresponds to the following entity in ISO 10303-41: person_organization_select.
/// 
/// HISTORY New entity in IFC Release 1.5.1
/// 
/// SELECT 
/// 
/// IfcOrganization An organization. 
/// IfcPerson A person. 
/// IfcPersonAndOrganization A person related to an organization.
typedef IfcUtil::IfcBaseClass IfcActorSelect;
/// IfcAppliedValueSelect defines the selection of whether a value (expressed as a ratio) or an amount should be used as the value for an IfcAppliedValue. 
/// 
/// Select from:  
/// 
/// IfcMeasureWithUnit 
///   IfcMonetaryMeasure 
///   IfcRatioMeasure 
/// 
/// HISTORY: New SELECT type in IFC 2x2.
/// 
/// Use definitions 
/// Selecting IfcMeasureWithUnit allows the specification of both the actual figure for the value together with the currency in which the value is represented. 
/// Selecting IfcMonetaryMeasure allows the specification only of the value, the currency being as set by the global context 
/// Selecting IfcRatioMeasure assumes that the amount is a percentage or other REAL number. Note that if the amount is normally specified as -20%, then this figure will need to be converted to a multiplier of 0.8
typedef IfcUtil::IfcBaseClass IfcAppliedValueSelect;
/// Definition from ISO/CD 10303-42:1992: This select type collects together both versions of the placement as used in two dimensional or in three dimensional Cartesian space. This enables entities requiring this information to reference them without specifying the space dimensionality.  
/// 
/// NOTE: Corresponding STEP type: axis2_placement, please refer to ISO/IS 10303-42:1994, p. 19 for the final definition of the formal standard.
/// 
/// HISTORY: New type in IFC Release 1.5
typedef IfcUtil::IfcBaseClass IfcAxis2Placement;
/// Definition from ISO/CD 10303-42:1992: This select type identifies
///   all those types of entities which may participate in a Boolean operation to
///   form a CSG solid.  
///   Definition from IAI: CSG primitives are out of scope for the
///   current IFC Release. Only faceted B-reps, swept area solids and half space
///   solids are available as Boolean operands. Boolean results themselves can be used
///   as operands thus enabling nested Boolean operations. 
/// 
/// NOTE Corresponding STEP type:
///   boolean_operand, please refer to ISO/IS 10303-42:1994, p.167 for the final
///   definition of the formal standard. In IFC Release 1.5.1 & 2.0 only Boolean
///   results (IfcBooleanResult), half space solids
///   (IfcHalfSpaceSolid), faceted B-Rep, extruded solids and revolved solids
///   (IfcSolidModel) are defined for being valid Boolean operands.
/// 
/// HISTORY: New Type in IFC Release 1.5.1
typedef IfcUtil::IfcBaseClass IfcBooleanOperand;
/// The character style select allows for a selection of character styles for text. Currently only text color and background color is selectable.
/// 
/// NOTE  Corresponding ISO 10303 name: character_style_select. Please refer to ISO/IS
/// 10303-46:1994, p. 89 for the final definition of the formal standard.
/// 
/// HISTORY  New type in IFC2x2.
/// 
/// IFC2x3 CHANGE  The SELECT item IfcTextStyleForDefinedFont replaces the old IfcColour.
typedef IfcUtil::IfcBaseClass IfcCharacterStyleSelect;

typedef IfcUtil::IfcBaseClass IfcClassificationNotationSelect;
/// Definition from ISO/CD 10303-46:1992: The colour entity defines a basic appearance of elements which shall be visualized in a picture.
/// 
/// NOTE  Corresponding STEP name: colour. It has been made into a SELECT type in IFC to avoid multiple inheritance for pre defined colour. Please refer to ISO/IS 10303-46:1994, p. 138 for the final definition of the formal standard.
/// 
/// HISTORY  New entity in IFC2x2.
typedef IfcUtil::IfcBaseClass IfcColour;
/// The IfcColourOrFactor enables the selection of either a RGB colour value or a scalar factor value for the use as values of the reflectance components.
/// 
/// HISTORY: New type in IFC2x2.
typedef IfcUtil::IfcBaseClass IfcColourOrFactor;

typedef IfcUtil::IfcBaseClass IfcConditionCriterionSelect;
/// Definition from ISO/CD 10303-42:1992: This type identifies the types of entity which may be selected as the root of a CSG tree including a single CSG primitive as a special case.
/// Definition from IAI: The IfcBooleanResult, and subtypes of IfcCsgPrimitive3D are defined as potential root tree expression (at IfcCsgSolid). A subtype of IfcCsgPrimitive3D marks the special case of a CSG solid solely expressed by a single primitive.
/// 
/// NOTE Corresponding ISO 10303-42 type: csg_select, please refer to ISO/IS 10303-42:1994, p.168 for the final definition of the formal standard.
/// 
/// HISTORY New Type in IFC Release 1.5.1.
typedef IfcUtil::IfcBaseClass IfcCsgSelect;
/// Definition from ISO/CD 10303-46:1992: The curve font or scaled curve font select is a selection of either a curve font style select (being either a predefined curve font or an explicitly defined curve font) or a curve style font and scaling. 
/// 
/// NOTE Corresponding ISO 10303 name: curve_font_or_scaled_curve_font_select. Please refer to ISO/IS 10303-46:1994 for the final definition of the formal standard.
/// 
/// HISTORY New entity in IFC2x2.
typedef IfcUtil::IfcBaseClass IfcCurveFontOrScaledCurveFontSelect;
/// IfcCurveOrEdgeCurve provides the option to either select a geometric curve (IfcCurve
/// and subtypes) within a geometric model, or a curve with associated geometry and coordinates (IfcEdgeCurve) within a topological model.
/// SELECT 
/// 
/// IfcCurve
///   IfcEdgeCurve
/// 
/// HISTORY  New select type in IFC2x Edition 3.
typedef IfcUtil::IfcBaseClass IfcCurveOrEdgeCurve;
/// Definition from ISO/CD 10303-46:1992: The curve style font select is a selection of a curve style font or a predefined curve style font. 
/// 
/// NOTE Corresponding ISO 10303 name: curve_style_font_select. Please refer to ISO/IS 10303-46:1994 for the final definition of the formal standard.
/// 
/// HISTORY New entity in IFC2x2.
typedef IfcUtil::IfcBaseClass IfcCurveStyleFontSelect;

typedef IfcUtil::IfcBaseClass IfcDateTimeSelect;
/// The defined symbol select is a selection between a predefined symbol and an externally defined symbol. 
/// 
/// NOTE Corresponding ISO 10303 name: defined_symbol_select. Please refer to ISO/IS 10303-46:1994 for the final definition of the formal standard.
/// 
/// HISTORY New type in IFC2x2.
typedef IfcUtil::IfcBaseClass IfcDefinedSymbolSelect;
/// IfcDerivedMeasureValue is a select type for selecting between derived measure types.
/// 
/// SELECT 
/// 
/// IfcAbsorbedDoseMeasure 
///   IfcAccelerationMeasure 
///   IfcAngularVelocityMeasure 
///   IfcCompoundPlaneAngleMeasure 
///   IfcDoseEquivalentMeasure 
///   IfcDynamicViscosityMeasure 
///   IfcElectricCapacitanceMeasure 
///   IfcElectricChargeMeasure 
///   IfcElectricConductanceMeasure 
///   IfcElectricResistanceMeasure 
///   IfcElectricVoltageMeasure 
///   IfcEnergyMeasure 
///   IfcForceMeasure 
///   IfcFrequencyMeasure 
///   IfcHeatFluxDensityMeasure 
///   IfcIlluminanceMeasure 
///   IfcInductanceMeasure 
///   IfcIntegerCountRateMeasure 
///   IfcIsothermalMoisturecapacityMeasure 
///   IfcKinematicViscosityMeasure 
///   IfcLinearForceMeasure 
///   IfcLinearMomentMeasure  
///   IfcLinearStiffnessMeasure 
///   IfcLinearVelocityMeasure 
///   IfcLuminousFluxMeasure 
///   IfcMagneticFluxDensityMeasure 
///   IfcMagneticFluxMeasure 
///   IfcMassDensityMeasure 
///   IfcMassFlowRateMeasure 
///   IfcModulusOfElasticityMeasure 
///   IfcModulusOfSubgradeReactionMeasure 
///   IfcMoistureDiffusivityMeasure 
///   IfcMolecularWeightMeasure 
///   IfcMomentOfInertiaMeasure  
///   IfcMonetaryMeasure 
///   IfcPlanarForceMeasure 
///   IfcPowerMeasure 
///   IfcPressureMeasure 
///   IfcRadioActivityMeasure 
///   IfcRotationalFrequencyMeasure 
///   IfcRotationalStiffnessMeasure 
///   IfcShearModulusMeasure 
///   IfcSpecificHeatCapacityMeasure 
///   IfcThermalAdmittanceMeasure 
///   IfcThermalConductivityMeasure 
///   IfcThermalResistanceMeasure 
///   IfcThermalTransmittanceMeasure 
///   IfcTimeStamp 
///   IfcTorqueMeasure 
///   IfcVaporPermeabilityMeasure 
///   IfcVolumetricFlowRateMeasure 
///   IfcCurvatureMeasure 
///   IfcMassPerLengthMeasure 
///   IfcRotationalMassMeasure 
///   IfcSectionalAreaIntegralMeasure 
///   IfcSectionModulusMeasure 
///   IfcTemperatureGradientMeasure 
///   IfcTemperatureRateOfChangeMeasure 
///   IfcWarpingConstantMeasure 
///   IfcWarpingMomentMeasure 
///   IfcThermalExpansionCoefficientMeasure 
///   IfcModulusOfLinearSubgradeReactionMeasure 
///   IfcModulusOfRotationalSubgradeReactionMeasure 
///   IfcLuminousIntensityDistributionMeasure 
///   IfcSoundPowerMeasure 
///   IfcSoundPressureMeasure 
/// 
/// HISTORY New type in IFC Release 2x.
/// 
/// IFC2x4 change: added IfcTemperatureRateOfChangeMeasure.
typedef IfcUtil::IfcBaseClass IfcDerivedMeasureValue;
/// IfcDocumentSelect enables selection of whether document information is to be contained within an IFC model or is to be referenced from an external source. 
/// 
/// HISTORY: New Select Type in IFC 2x
/// 
/// Select From: 
/// 
/// IfcDocumentInformation (for "metadata" of an external document)  
/// IfcDocumentReference (for reference within a document)
typedef IfcUtil::IfcBaseClass IfcDocumentSelect;

typedef IfcUtil::IfcBaseClass IfcDraughtingCalloutElement;
/// The fill area style tile shape select is used to make a selection for the style of the fill area style tile.
/// 
/// NOTE: The IfcFillAreaStyleTileShapeSelect is an entity that had been adopted from ISO 10303, Industrial automation systems and integration&#151;Product data representation and exchange, Part 46: Integrated generic resources: Visual presentation.
/// 
/// NOTE Corresponding ISO 10303 name: fill_area_style_tile_shape_select. Please refer to ISO/IS 10303-46:1994 for the final definition of the formal standard.
/// 
/// HISTORY New type in IFC2x2.
typedef IfcUtil::IfcBaseClass IfcFillAreaStyleTileShapeSelect;
/// Definition from ISO/CD 10303-46:1992: The fill style select is a selection between different fill area styles.
/// 
/// NOTE Corresponding ISO 10303 name: fill_style_select. Please refer to ISO/IS 10303-46:1994 for
/// the final definition of the formal standard.
/// 
/// HISTORY New type in IFC2x2.
typedef IfcUtil::IfcBaseClass IfcFillStyleSelect;
/// Definition from ISO/CD 10303-42:1992: This select type identifies the types of entities which can occur in a geometric set. 
/// 
/// NOTE: Corresponding ISO 10303 type: geometric_set_select. Please refer to ISO/IS 10303-42:1994, p. 169 for the final definition of the formal standard.
/// 
/// HISTORY: New type in IFC Release 2x.
typedef IfcUtil::IfcBaseClass IfcGeometricSetSelect;
/// The IfcHatchLineDistanceSelect is a selection between different ways to determine the distance and potentially start point of hatch lines, either by an offset distance length measure or by a vector.
/// 
/// HISTORY  New type in IFC2x3.
typedef IfcUtil::IfcBaseClass IfcHatchLineDistanceSelect;
/// Definition from ISO/CD 10303-46:1992: The layered things type selects those things, which can be grouped in layers. 
/// 
/// It is the collection of all those items, that are assigned to a single layer. These items are representation items or complete representations (IfcRepresentationItem, IfcRepresentation). If an IfcRepresentation is referenced, all IfcRepresentationItem within its set of Items are assigned to the same layer. 
/// 
/// NOTE: Corresponding ISO 10303 name: layered_item. It was called layered_things in the ISO/CD version and had been renamed to layered_item in the ISO/IS final version. Please refer to ISO/IS 10303-46:1994, p. 13 for the final definition of the formal standard.
/// 
/// HISTORY: New type in IFC2x2.
typedef IfcUtil::IfcBaseClass IfcLayeredItem;
/// IfcLibrarySelect enables selection of whether library information is to be contained within an IFC model or is to be referenced from an external source. 
/// 
/// HISTORY: New Select Type in IFC2x
/// 
/// Select From: 
/// 
/// IfcLibraryInformation (for library information)  
/// IfcLibraryReference (for reference into a library of information by location)  
/// 
/// Generally, it is expected that selection will be IfcLibraryReference and only rarely IfcLibraryInformation. IfcLibraryInformation should only be selected in circumstances where there could be a need to indicate the libraries that will be used without making individual references. This may occur for higher level objects such as a project or building.
typedef IfcUtil::IfcBaseClass IfcLibrarySelect;
/// A goniometric light gets its intensity distribution function (how much light goes in any one direction) from one of two sources: (i) an industry-standard file, (ii) from distribution data passed directly via the IfcLightIntensityDistribution. 
/// 
/// The light distribution provides the luminous intensity distribution according to some standardized light distribution curves. 
/// 
/// Select: 
/// 
/// Type 
///   Definition 
/// 
/// IfcExternalReference 
///   Light distribution is represented by a standard photometric data file such as Eulumdat, IES, CIBSE TM14.  
/// 
/// IfcLightIntensityDistribution 
///   For representing a light distribution directly the
///   following values needs to be given in a table like structure with column and
///   row headings. These headings should contain the angles (C/&#947; or B/&#946; )
///   and the table body contains the intensity values, (normally normalized to
///   cd/Klm). The angles can be non- equidistant and the angle steps can be almost
///   any value in the valid range, so a list of all available angles in both
///   directions covers all cases.  
/// 
/// HISTORY New type in IFC2x2.
typedef IfcUtil::IfcBaseClass IfcLightDistributionDataSourceSelect;
/// IfcMaterialSelect provides selection of either a material
/// definition or a material usage definition that can be assigned to
/// an element, a resource or another entity within IFC.
/// SELECT
/// 
/// IfcMaterialDefinition
/// 
/// IfcMaterial
/// IfcMaterialLayer
/// IfcMaterialLayerSet
/// IfcMaterialProfile
/// IfcMaterialProfileSet
/// IfcMaterialConstituent
/// IfcMaterialConstituentSet
/// 
/// IfcMaterialUsageDefinition
/// 
/// IfcMaterialLayerSetUsage
/// IfcMaterialProfileSetUsage
/// 
/// IfcMaterialList
/// 
/// HISTORY New select in IFC 1.0
/// 
/// IFC2x4 CHANGE The select now includes two new abstract entities IfcMaterialDefinition
/// and IfcMaterialUsageDefinition with upward compatibility.  The use of IfcMaterialList is deprecated from IFC2x4 onwards.
typedef IfcUtil::IfcBaseClass IfcMaterialSelect;
/// Definition from ISO/CD 10303-41:1992: A measure value is a value as defined in ISO 31-0 (clause 2).
/// 
/// NOTE IfcMeasureValue is a select data type for most basic measure types coming from ISO 10303-41.  Select item IfcNonNegativeLengthMeasure is in addition to ISO 10303-41.
/// 
/// NOTE Corresponding ISO 10303 name: measure_value, please refer to ISO/IS 10303-41 for the final definition of the formal standard.
/// 
/// HISTORY New type in IFC Release 1.5.1.
/// 
/// IFC 2x4 change: added IfcNonNegativeLengthMeasure
typedef IfcUtil::IfcBaseClass IfcMeasureValue;
/// IfcMetricValueSelect is a select type that enables selection of the data type for the value component of an IfcMetric. 
/// 
/// HISTORY: New type in IFC Release 2.0
/// 
/// Select 
/// 
/// IfcCostValue
///   IfcDateTime 
///   IfcMeasureWithUnit 
///   IfcTable 
///   IfcText 
///   IfcTimeSeries
typedef IfcUtil::IfcBaseClass IfcMetricValueSelect;
/// IfcObjectReferenceSelect is a select type, that holds a list of resource level entities that can be used as properties within a property set. 
/// 
/// HISTORY  New select type in IFC Release 2.0.
typedef IfcUtil::IfcBaseClass IfcObjectReferenceSelect;

typedef IfcUtil::IfcBaseClass IfcOrientationSelect;
/// IfcPointOrVertexPoint provides the option to either select a geometric point (IfcPoint and subtypes) within a geometric model, or a vertex with associated point coordinates (IfcVertexPoint) within a topological model.
/// SELECT 
/// 
/// IfcPoint, 
///   IfcVertexPoint
/// 
/// HISTORY  New select type in IFC2x Edition 3.
typedef IfcUtil::IfcBaseClass IfcPointOrVertexPoint;
/// Definition from ISO/CD 10303-46:1992: The presentation style select is a selection of one of many kinds of styles, a different one for each kind of geometric representation item to be styled.
/// 
/// NOTE Corresponding ISO 10303 name: presentation_style_Select. Please refer to ISO/IS
/// 10303-46:1994 for the final definition of the formal standard.
/// 
/// HISTORY New type in IFC2x2.
/// 
/// IFC2x4 CHANGE The select type has been deprecated.
typedef IfcUtil::IfcBaseClass IfcPresentationStyleSelect;
/// Definition from ISO/CD 10303-42:1992 This type collects together, for reference when constructing more complex models, the subtypes which have the characteristics of a shell. A shell is a connected object of fixed dimensionality d = 0; 1; or 2, typically used to bound a region. The domain of a shell, if present, includes its bounds and 0 £ X < ¥.  
/// 
/// A shell of dimensionality 0 is represented by a graph consisting of a single vertex. The vertex shall not have any associated edges. 
/// A shell of dimensionality 1 is represented by a connected graph of dimensionality 1. 
/// A shell of dimensionality 2 is a topological entity constructed by joining faces along edges. Its domain, if present, is a connected, orientable 2-manifold with boundary, that is, a connected, oriented, finite, non-self-intersecting surface, which may be closed or open. 
/// 
/// Shells of dimensionality 0 and 1 are not part of the current IFC release. 
/// 
/// NOTE  Corresponding ISO 10303 type: shell. Please refer to ISO/IS 10303-42:1994, p. 127 for the final definition of the formal standard. Only the select items closed_shell (IfcClosedShell) and open_shell (IfcOpenShell) have been incorporated in the current IFC release. 
/// 
/// HISTORY  New type in IFC2x.
typedef IfcUtil::IfcBaseClass IfcShell;
/// IfcSimpleValue is a select type for selecting between simple value types.
/// 
/// SELECT 
/// 
/// IfcInteger: Defined type of simple type INTEGER. 
///   IfcReal: Defined type of simple type REAL. 
///   IfcBoolean: Defined type of simple type BOOLEAN. 
///   IfcLogical: Defined type of simple type LOGICAL. 
///   IfcIdentifier: Defined type of simple type STRING for identification purposes. 
///   IfcLabel: Defined type of simple type STRING for naming purposes. 
///   IfcText: Defined type of simple type STRING for descriptive purposes. 
///   IfcDateTime: Defined type of simple type STRING to represent a date and time. 
///   IfcDate: Defined type of simple type STRING to represent a date. 
///   IfcTime: Defined type of simple type STRING to represent a time. 
///   IfcDuration: Defined type of simple type STRING to represent a duration. 
/// 
/// HISTORY New type in IFC Release 2x.
/// 
/// IFC2x4 CHANGE Items IfcDateTime, IfcDate, IfcTime, IfcDuration added.
typedef IfcUtil::IfcBaseClass IfcSimpleValue;
/// Definition from ISO/CD 10303-46:1992: The size select is a selection of a specific positive length measure.
/// 
/// Definition from ISO: The size (or width) measure value is given in the global drawing length units.
/// 
/// NOTE  global units are defined at the single IfcProject instance, given by UnitsInContext:IfcUnitAssignment, the same units are used for the geometric representation items and for the style definitions.
/// 
/// NOTE  Corresponding ISO 10303 name: size_select. Please refer to ISO/IS 10303-46:1994 for the final
/// definition of the formal standard.
/// 
/// HISTORY  New type in IFC2x2.
/// 
/// IFC2x3 CHANGE  The SELECT item IfcMeasureWithUnit has been removed from the IfcSizeSelect, the IfcRatioMeasure and IfcDescriptiveMeasure has been added.
typedef IfcUtil::IfcBaseClass IfcSizeSelect;
/// The IfcSpecularHighlightSelect defines the selectable types of value for specular highlight sharpness. 
/// 
/// NOTE: The two select types relate to the different ways to specifiy the sharpness (or shininess) of the specular part of the reflectance equation. It relates to the attributes: 
/// 
/// in ISO10303-46 the attribute specular_exponent is given 
///   in VRML97 the attribute shininess is given 
/// 
/// For each surface side style only one of the two methods is needed for calculating the specular part of the equation.
/// 
/// HISTORY: New type in IFC2x2.
typedef IfcUtil::IfcBaseClass IfcSpecularHighlightSelect;
/// Definition from IAI: This type definition shall be used to
///   distinguish between a reference to an instance either of
///   IfcStructuralItem or IfcBuildingElement. The
///   IfcStructuralActivityAssignmentSelect type is referenced by the entity
///   IfcRelConnectsStructuralActivity which defines the connection between
///   activities (IfcStructuralActivity) and the loaded element.  
/// 
/// HISTORY: New type in Release IFC2x
///   Edition 2.
typedef IfcUtil::IfcBaseClass IfcStructuralActivityAssignmentSelect;
/// IfcSurfaceOrFaceSurface provides the option to either select a geometric surface (IfcSurface
/// and subtypes) within a geometric model, or a face with associated surface geometry and coordinates (IfcFaceSurface) within a topological model.
/// SELECT 
/// 
/// IfcSurface 
///   IfcFaceSurface
///   IfcFaceBasedSurfaceModel (a connected face set, representing a faceted surface as an approximation of a non planar, non rectangular bounded surface)
/// 
/// HISTORY  New select type in IFC2x3.
typedef IfcUtil::IfcBaseClass IfcSurfaceOrFaceSurface;
/// Definition from ISO/CD 10303-46:1992: The surface style element select is a selection of the different surface styles to use in the presentation of the side of a surface. 
/// 
/// The select type only includes the IfcSurfaceStyleRendering (which is the equivalent to surface_style_rendering) from the select type surface_style_element_select. In addition it has the IfcSurfaceStyleLighting, which holds the exact physically based lighting properties for lighting based calculation algorithms (as the opposite to the rendering based calculation), the IfcSurfaceStyleRefraction (for more advanced refraction indices) and IfcSurfaceStyleWithTextures (to allow for image textures applied to surfaces). In addition an IfcExternallyDefinedSurfaceStyle can be selected that points into an external material library. 
/// 
/// NOTE The IfcSurfaceLightingProperties are needed for exact lighting calculation, because physically based lighting calculation algorithms need exact physically based parameters. The factors in IfcSurfaceStyleRendering lack the physical base, they are intended for rendering calculations, but a lighting calculation based software cannot use these values.
/// 
/// NOTE: Corresponding ISO 10303 type: surface_style_element_select. Please refer to ISO/IS 10303-46:1994, p. 85 for the final definition of the formal standard.
/// 
/// HISTORY: New Select type in IFC2x2.
typedef IfcUtil::IfcBaseClass IfcSurfaceStyleElementSelect;
/// The symbol style select allows for the selection of styles to be assigned to an annotated symbol.
/// 
/// NOTE: The selection is restricted to colour within the current release of IFC
/// 
/// NOTE Corresponding ISO 10303 name: symbol_style_select. Please refer to ISO/IS 10303-46:1994 for the final definition of the formal standard.
/// 
/// HISTORY New entity in IFC2x2.
typedef IfcUtil::IfcBaseClass IfcSymbolStyleSelect;
/// IfcTextFontSelect allows for either a predefined text font, a text font model or an externally defined text font to be used to describe the font of a text literal. The definition of the text font model is based on W3C TR Cascading Style Sheet Version 1, whereas the definition of predefined text font is based on ISO 10303.
/// 
/// NOTE  IfcTextFontSelect is an entity that had been adopted from ISO 10303, Industrial automation systems and integration—Product data representation and exchange, Part 46: Integrated generic resources: Visual presentation. Corresponding ISO 10303 name: font_select. Please refer to ISO/IS 10303-46:1994, p. 133 for the final definition of the formal standard.
/// 
/// HISTORY  New type in IFC2x2.
/// 
/// IFC2x3 CHANGE  The select type has been renamed from IfcFontSelect.
typedef IfcUtil::IfcBaseClass IfcTextFontSelect;
/// The text style select allows for the selection of styles to be assigned to an annotated text. The text style determines the text model that affect the visual presentation of characters, spaces, words, and paragraphs. There are two choices:
/// 
/// IfcTextStyleWithBoxCharacteristics for definitions from ISO/IS 10303-46:1994 for (old) vector based and monospace text.
///   IfcTextStyleTextModel for definitions from Cascading
/// Style Sheets, level 1, W3C Recommendation 17 Dec 1996, revised 11 Jan 1999, CSS1, for all true type text. The use of the CSS1 definitions is the preferred way to represent text styles.
/// 
/// HISTORY  New type in IFC2x2.
/// 
/// IFC2x3 CHANGE  The items within the IfcTextStyleSelect have changed to IfcTextStyleWithBoxCharacteristics and IfcTextStyleTextModel.
typedef IfcUtil::IfcBaseClass IfcTextStyleSelect;
/// Definition from ISO/CD 10303-42:1992: This select type identifies the two possible ways of trimming a parametric curve; by a Cartesian point on the curve, or by a REAL number defining a parameter value within the parametric range of the curve. 
/// 
/// NOTE Corresponding ISO 10303 type: trimming_select, please refer to ISO/IS 10303-42:1994, p. 20 for the final definition of the formal standard.
/// 
/// HISTORY New Type in IFC Release 1.0
typedef IfcUtil::IfcBaseClass IfcTrimmingSelect;
/// Definition from ISO/CD 10303-41:1992: A unit is a physical quantity, with a value of one, which is used as a standard in terms of which other quantities are expressed.
/// 
/// NOTE: Select item IfcMonetaryUnit is an addition to ISO 10303-41.
/// 
/// NOTE: Corresponding ISO 10303 name: unit, please refer to ISO/IS 10303-41 for the final definition of the formal standard.
/// 
/// SELECT 
/// 
/// IfcNamedUnit: A unit which is identified by a name.
/// IfcDerivedUnit: A unit which is derived from an expression of units. 
/// IfcMonetaryUnit: A unit for defining currencies. 
/// 
/// HISTORY: New type in IFC Release 1.5.1.
typedef IfcUtil::IfcBaseClass IfcUnit;
/// IfcValue is a select type for selecting between more specialised select types IfcSimpleValue,
/// IfcMeasureValue and IfcDerivedMeasureValue.
/// 
/// SELECT 
/// 
/// IfcSimpleValue A select type for basic defined types of simple data type. 
///   IfcMeasureValue A select type for basic measure types of ISO 10303-41. 
///   IfcDerivedMeasureValue A select type for derived measure types.
/// 
/// HISTORY New type in IFC Release 2x.
typedef IfcUtil::IfcBaseClass IfcValue;
/// Definition from ISO/CD 10303-42:1992: This type is used to
///   identify the types of entity which can participate in vector computations. 
/// 
/// NOTE Corresponding STEP type:
///   vector_or_direction, please refer to ISO/IS 10303-42:1994, p. 20 for the final
///   definition of the formal standard.  
///   HISTORY New Type in IFC Release
///   1.5
typedef IfcUtil::IfcBaseClass IfcVectorOrDirection;
struct IfcActionSourceTypeEnum {
/// Definition from IAI:This enumeration type contains possible
///   action sources. 
/// 
/// HISTORY: New type in Release IFC2x
///   Edition 2.
typedef enum {IfcActionSourceType_DEAD_LOAD_G, IfcActionSourceType_COMPLETION_G1, IfcActionSourceType_LIVE_LOAD_Q, IfcActionSourceType_SNOW_S, IfcActionSourceType_WIND_W, IfcActionSourceType_PRESTRESSING_P, IfcActionSourceType_SETTLEMENT_U, IfcActionSourceType_TEMPERATURE_T, IfcActionSourceType_EARTHQUAKE_E, IfcActionSourceType_FIRE, IfcActionSourceType_IMPULSE, IfcActionSourceType_IMPACT, IfcActionSourceType_TRANSPORT, IfcActionSourceType_ERECTION, IfcActionSourceType_PROPPING, IfcActionSourceType_SYSTEM_IMPERFECTION, IfcActionSourceType_SHRINKAGE, IfcActionSourceType_CREEP, IfcActionSourceType_LACK_OF_FIT, IfcActionSourceType_BUOYANCY, IfcActionSourceType_ICE, IfcActionSourceType_CURRENT, IfcActionSourceType_WAVE, IfcActionSourceType_RAIN, IfcActionSourceType_BRAKES, IfcActionSourceType_USERDEFINED, IfcActionSourceType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcActionTypeEnum {
/// Definition from IAI: This enumeration type is used to distinguish
///   between possible action types at a high level. It can be used for an automated
///   definition of load combinations and for dimensioning. The contained items and
///   their acronyms are adopted from the Eurocode standard. 
/// 
/// HISTORY: New type in Release IFC2x
///   Edition 2.
typedef enum {IfcActionType_PERMANENT_G, IfcActionType_VARIABLE_Q, IfcActionType_EXTRAORDINARY_A, IfcActionType_USERDEFINED, IfcActionType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcActuatorTypeEnum {
/// The IfcActuatorTypeEnum defines the range of different types of actuator that can be specified. 
/// 
/// HISTORY: New type in IFC
///   R2.0  
///   Enumeration 
/// 
/// ELECTRICACTUATOR: A device that electrically actuates a control element.  
/// PNEUMATICACTUATOR<: A device that pneumatically actuates a control element  
/// HYDRAULICACTUATOR: A device that electrically actuates a control element.  
/// HANDOPERATEDACTUATOR: A device that manually actuates a control element. 
/// THERMOSTATICACTUATOR: A device that thermostatically actuates a control element. 
/// USERDEFINED: User-defined type. 
/// NOTDEFINED: Undefined type. 
/// 
/// See property set of actuator common attributes for specification of
///   properties for hand operated actuators.
typedef enum {IfcActuatorType_ELECTRICACTUATOR, IfcActuatorType_HANDOPERATEDACTUATOR, IfcActuatorType_HYDRAULICACTUATOR, IfcActuatorType_PNEUMATICACTUATOR, IfcActuatorType_THERMOSTATICACTUATOR, IfcActuatorType_USERDEFINED, IfcActuatorType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcAddressTypeEnum {
/// Definition from IAI: Identifies the logical location of the address.
/// 
/// HISTORY New type in IFC Release 2x.
/// 
/// ENUMERATION 
/// 
/// OFFICE An office address. 
///   SITE A site address.
///   HOME A home address.
///   DISTRIBUTIONPOINT A postal distribution point address.
///   USERDEFINED A user defined address type to be provided.
typedef enum {IfcAddressType_OFFICE, IfcAddressType_SITE, IfcAddressType_HOME, IfcAddressType_DISTRIBUTIONPOINT, IfcAddressType_USERDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcAheadOrBehind {

typedef enum {IfcAheadOrBehind_AHEAD, IfcAheadOrBehind_BEHIND} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcAirTerminalBoxTypeEnum {
/// This enumeration identifies different types of air terminal boxes.   
/// 
/// Valid enumerations are:
/// 
/// CONSTANTFLOW:  Terminal box does not include a means to reset the volume automatically to an outside signal such as thermostat.
///   VARIABLEFLOWPRESSUREDEPENDANT:  terminal box includes a means to reset the volume automatically to a different control point in response to an outside signal such as thermostat: air-flow rate depends on supply pressure.
///   VARIABLEFLOWPRESSUREINDEPENDANT:  terminal box includes a means to reset the volume automatically to a different control point in response to an outside signal such as thermostat: air-flow rate is independant of supply pressure.
///   USERDEFINED:				  User-defined terminal box.
///   NOTDEFINED:					  Undefined terminal box.
/// 
/// HISTORY: New enumeration in IFC R2.0
typedef enum {IfcAirTerminalBoxType_CONSTANTFLOW, IfcAirTerminalBoxType_VARIABLEFLOWPRESSUREDEPENDANT, IfcAirTerminalBoxType_VARIABLEFLOWPRESSUREINDEPENDANT, IfcAirTerminalBoxType_USERDEFINED, IfcAirTerminalBoxType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcAirTerminalTypeEnum {
/// Enumeration defining the functional types of air terminals. 
///   The IfcAirTerminalTypeEnum contains the following:
/// 
/// GRILLE: A covering for any area through which air passes.
///   REGISTER: A grille typically equipped with a damper or control valve.
///   DIFFUSER: An outlet discharging supply air in various directions and planes.
///   LOUVRE: A rectilinear louvre.
///   USERDEFINED: User-defined air terminal type.
///   NOTDEFINED:  Undefined air terminal type.
/// 
/// NOTE: Architectural louvres within doors or windows are defined by IfcPermeableCoveringProperties.
/// 
/// HISTORY: New enumeration in IFC R2x2.  Modified in IFC R2x4 to add LOUVRE and remove EYEBALL, IRIS, LINEARGRILLE, LINEARDIFFUSER
typedef enum {IfcAirTerminalType_GRILLE, IfcAirTerminalType_REGISTER, IfcAirTerminalType_DIFFUSER, IfcAirTerminalType_EYEBALL, IfcAirTerminalType_IRIS, IfcAirTerminalType_LINEARGRILLE, IfcAirTerminalType_LINEARDIFFUSER, IfcAirTerminalType_USERDEFINED, IfcAirTerminalType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcAirToAirHeatRecoveryTypeEnum {
/// Defines general types of pumps.
///   The IfcPumpTypeEnum contains the following:
/// 
/// FIXEDPLATECOUNTERFLOWEXCHANGER: Heat exchanger with moving parts and alternate layers of plates, separated and sealed from the exhaust and supply air stream passages with primary air enters at secondary air outlet location and exits at secondary air inlet location.
///   FIXEDPLATECROSSFLOWEXCHANGER: Heat exchanger with moving parts and alternate layers of plates, separated and sealed from the exhaust and supply air stream passages with secondary air flow in the direction perpendicular to primary air flow.
///   FIXEDPLATEPARALLELFLOWEXCHANGER: Heat exchanger with moving parts and alternate layers of plates, separated and sealed from the exhaust and supply air stream passages with primary air enters at secondary air inlet location and exits at secondary air outlet location.
///   ROTARYWHEEL: A heat wheel with a revolving cylinder filled with an air-permeable medium having a large internal surface area.
///   RUNAROUNDCOILLOOP: A typical coil energy recovery loop places extended surface, finned tube water coils in the supply and exhaust airstreams of a building.
///   HEATPIPE: A passive energy recovery device with a heat pipe divided into evaporator and condenser sections.
///   TWINTOWERENTHALPYRECOVERYLOOPS: An air-to-liquid, liquid-to-air enthalpy recovery system with a sorbent liquid circulates continuously between supply and exhaust airstreams, alternately contacting both airstreams directly in contactor towers.
///   THERMOSIPHONSEALEDTUBEHEATEXCHANGERS: Sealed systems that consist of an evaporator, a condenser, interconnecting piping, and an intermediate working fluid that is present in both liquid and vapor phases where the evaporator and the condenser are usually at opposite ends of a bundle of straight, individual thermosiphon tubes and the exhaust and supply ducts are adjacent to each other.
///   THERMOSIPHONCOILTYPEHEATEXCHANGERS: Sealed systems that consist of an evaporator, a condenser, interconnecting piping, and an intermediate working fluid that is present in both liquid and vapor phases where the evaporator and condensor coils are installed independently in the ducts and are interconnected by the working fluid piping.
///   USERDEFINED: User-defined air to air heat recovery type.
///   NOTDEFINED:  Undefined air to air heat recovery type.
/// 
/// HISTORY: New enumeration in IFC R2x.
typedef enum {IfcAirToAirHeatRecoveryType_FIXEDPLATECOUNTERFLOWEXCHANGER, IfcAirToAirHeatRecoveryType_FIXEDPLATECROSSFLOWEXCHANGER, IfcAirToAirHeatRecoveryType_FIXEDPLATEPARALLELFLOWEXCHANGER, IfcAirToAirHeatRecoveryType_ROTARYWHEEL, IfcAirToAirHeatRecoveryType_RUNAROUNDCOILLOOP, IfcAirToAirHeatRecoveryType_HEATPIPE, IfcAirToAirHeatRecoveryType_TWINTOWERENTHALPYRECOVERYLOOPS, IfcAirToAirHeatRecoveryType_THERMOSIPHONSEALEDTUBEHEATEXCHANGERS, IfcAirToAirHeatRecoveryType_THERMOSIPHONCOILTYPEHEATEXCHANGERS, IfcAirToAirHeatRecoveryType_USERDEFINED, IfcAirToAirHeatRecoveryType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcAlarmTypeEnum {
/// The IfcAlarmTypeEnum defines the range of different types of alarm that can be specified. 
/// 
/// HISTORY: New type in IFC 2x2
/// 
/// Enumeration 
/// 
/// BELL: An audible alarm. 
/// BREAKGLASSBUTTON: An alarm activation mechanism in which a protective glass has to be broken to enable a button to be pressed. 
/// LIGHT: A visual alarm. 
/// MANUALPULLBOX: An alarm activation mechanism in which activation is achieved by a pulling action. 
/// SIREN: An audible alarm. 
/// WHISTLE: An audible alarm.  
/// USERDEFINED: User-defined type. 
/// NOTDEFINED: Undefined type.
typedef enum {IfcAlarmType_BELL, IfcAlarmType_BREAKGLASSBUTTON, IfcAlarmType_LIGHT, IfcAlarmType_MANUALPULLBOX, IfcAlarmType_SIREN, IfcAlarmType_WHISTLE, IfcAlarmType_USERDEFINED, IfcAlarmType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcAnalysisModelTypeEnum {
/// Definition from IAI: This type definition is used to distinguish
///   between different types of structural analysis models. The analysis models are
///   differentiated by their dimensionality. 
/// 
/// HISTORY: New type in Release IFC2x
///   Edition 2.
typedef enum {IfcAnalysisModelType_IN_PLANE_LOADING_2D, IfcAnalysisModelType_OUT_PLANE_LOADING_2D, IfcAnalysisModelType_LOADING_3D, IfcAnalysisModelType_USERDEFINED, IfcAnalysisModelType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcAnalysisTheoryTypeEnum {
/// Definition from IAI: This type definition is used to distinguish
///   between different types of structural analysis methods, i.e. first order
///   theory, second order theory (small deformations), third order theory (large
///   deformations) and the full nonlinear theory (geometric nonlinearity together with other nonlinearities, e.g. plasticity). 
/// 
/// HISTORY: New type in Release IFC2x
///   Edition 2.
typedef enum {IfcAnalysisTheoryType_FIRST_ORDER_THEORY, IfcAnalysisTheoryType_SECOND_ORDER_THEORY, IfcAnalysisTheoryType_THIRD_ORDER_THEORY, IfcAnalysisTheoryType_FULL_NONLINEAR_THEORY, IfcAnalysisTheoryType_USERDEFINED, IfcAnalysisTheoryType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcArithmeticOperatorEnum {
/// IfcArithmeticOperatorEnum specifies the form of arithmetical operation implied by the relationship. 
/// Enumeration 
/// 
/// ADD 
///   DIVIDE 
///   MULTIPLY 
///   SUBTRACT 
/// 
/// HISTORY: New enumeration in IFC2x2.
/// 
/// Use definitions 
/// There can be only one arithmetic operator for each applied value relationship. This is to enforce arithmetic consistency. Given this consistency, the cardinality of the IfcAppliedValueRelationship.Components attribute is a set of one to many applied values that are components of an applied value.
typedef enum {IfcArithmeticOperator_ADD, IfcArithmeticOperator_DIVIDE, IfcArithmeticOperator_MULTIPLY, IfcArithmeticOperator_SUBTRACT} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcAssemblyPlaceEnum {
/// Definition from IAI: Enumeration defining where the
///   assembly is intended to take place, either in a factory or
///   on the building site.
/// 
/// HISTORY New enumeration in
///   Release IFC2x Edition 2.
/// 
/// Enumeration
/// 
/// SITE - this assembly is assembled at site
/// 
/// FACTORY - this assembly is assembled in a factory
typedef enum {IfcAssemblyPlace_SITE, IfcAssemblyPlace_FACTORY, IfcAssemblyPlace_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcBSplineCurveForm {
/// Definition from ISO/CD 10303-42:1992: This type is used to indicate that the B-spline curve represents a part of a curve of some specific form.
/// 
/// Enumeration
/// 
/// polyline form: A connected sequence of line segments represented by degree 1 B-spline basis functions.
/// circular arc: An arc of a circle, or a complete circle represented by a B-spline curve.
/// elliptic arc: An arc of an ellipse, or a complete ellipse, represented by a B-spline curve.
/// parabolic arc: An arc of finite length of a parabola represented by a B-spline curve.
/// hyperbolic arc: An arc of finite length of one branch of a hyperbola represented by a B-spline curve.
/// unspecified: A B-spline curve for which no particular form is specified.
/// 
/// NOTE  Corresponding ISO 10303 type: b_spline_curve_form. Please refer to ISO/IS 10303-42:1994, p. 15 for the final definition of the formal standard.
/// 
/// HISTORY  New type in Release IFC2x2.
typedef enum {IfcBSplineCurveForm_POLYLINE_FORM, IfcBSplineCurveForm_CIRCULAR_ARC, IfcBSplineCurveForm_ELLIPTIC_ARC, IfcBSplineCurveForm_PARABOLIC_ARC, IfcBSplineCurveForm_HYPERBOLIC_ARC, IfcBSplineCurveForm_UNSPECIFIED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcBeamTypeEnum {
/// Definition from IAI: This enumeration defines the
/// different types of linear elements an IfcBeamType object
/// can fulfill:
/// 
/// BEAM: A standard beam usually used horizontally.
/// JOIST: A beam used to support a floor or ceiling.
/// HOLLOWCORE: A wide often prestressed beam with a
/// hollow-core profile that usually serves as a slab component.
/// LINTEL: A beam or horizontal piece of material over an
/// opening (e.g. door, window).
/// SPANDREL: A tall beam placed on the facade of a
/// building. One tall side is usually finished to provide the
/// exterior of the building. Can be used to support joists or slab
/// elements on its interior side.
/// 
/// NOTE  They are also referred to as "spandrel
/// panels", which are parts of a facade and sometimes have
/// supporting consoles for floor slabs
/// integrated.
/// 
/// T_BEAM: A beam that forms part of a slab construction
/// and acts together with the slab which its carries. Such beams are
/// often of T-shape (therefore the English name), but may have other
/// shapes as well, e.g. an L-Shape or an Inverted-T-Shape.
/// 
/// NOTE  In order to distinguish beams by shape,
/// the assigned IfcProfileDef subtypes provide the shape type
/// and, if using a subtype of
/// IfcParameterizedProfileDef, also the shape
/// parameterization.
/// 
/// USERDEFINED: User-defined linear beam element.
/// NOTDEFINED: Undefined linear beam element
/// 
/// HISTORY  New Enumeration
/// in Release IFC2x Edition 2.
/// IFC2x4 CHANGE  The enumerators
/// HOLLOWCORE and SPANDREL have been
/// added.
typedef enum {IfcBeamType_BEAM, IfcBeamType_JOIST, IfcBeamType_LINTEL, IfcBeamType_T_BEAM, IfcBeamType_USERDEFINED, IfcBeamType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcBenchmarkEnum {
/// IfcBenchmarkEnum is an enumeration used to identify the logical comparators that can be applied in conjunction with constraint values. 
/// 
/// HISTORY: New type in IFC Release 2.0
/// 
/// IFC2x4 CHANGE: Extended to include comparators for item-set and set-item comparisons: INCLUDES, NOTINCLUDES, INCLUDEDIN and NOTINCLUDEDIN, to test if an individual item is a member of a given aggregation, or if an aggregation has a given individual item as a member.
/// 
/// Enumeration 
/// 
/// Value 
///   Definition 
/// 
/// GREATERTHAN 
///   Identifies that a value must be greater than that set by the constraint. 
/// 
/// GREATERTHANOREQUALTO 
///   Identifies that a value must be either greater than or equal to that set by the constraint. 
/// 
/// LESSTHAN 
///   Identifies that a value must be less than that set by the constraint. 
/// 
/// LESSTHANOREQUALTO 
///   Identifies that a value must be either less than or equal to that set by the constraint. 
/// 
/// EQUALTO 
///   Identifies that a value must be equal to that set by the constraint. 
/// 
/// NOTEQUALTO 
///   Identifies that a value must be not equal to that set by the constraint. 
/// 
/// INCLUDES 
///   Identifies that an aggregation (set, list or table) must include the value (individual item) set by the constraint. 
/// 
/// NOTINCLUDES 
///   Identifies that an aggregation (set, list or table) must not include (i.e must exclude) the value (individual item) set by the constraint. 
/// 
/// INCLUDEDIN 
///   Identifies that a value (individual item) must be included in the aggregation (set, list or table) set by the constraint. 
/// 
/// NOTINCLUDEDIN 
///   Identifies that a value (individual item) must not be included (i.e. must be excluded) in the aggregation (set, list or table) set by the constraint.
typedef enum {IfcBenchmark_GREATERTHAN, IfcBenchmark_GREATERTHANOREQUALTO, IfcBenchmark_LESSTHAN, IfcBenchmark_LESSTHANOREQUALTO, IfcBenchmark_EQUALTO, IfcBenchmark_NOTEQUALTO} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcBoilerTypeEnum {
/// Enumeration defining the typical types of boilers.
///   The IfcBoilerTypeEnum contains the following:
/// 
/// WATER: Water boiler.
///   STEAM: Steam boiler.
///   USERDEFINED: User-defined Boiler type.
///   NOTDEFINED:  Undefined Boiler type.
/// 
/// HISTORY: New enumeration in IFC R2x.
typedef enum {IfcBoilerType_WATER, IfcBoilerType_STEAM, IfcBoilerType_USERDEFINED, IfcBoilerType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcBooleanOperator {
/// Definition from ISO/CD 10303-42:1992: This type defines the three Boolean operators used in the definition of CSG solids.
/// 
/// UNION: The operation of constructing the regularized set theoretic union of the volumes defined by two solids.
/// INTERSECTION: The operation of constructing the regularised set theoretic intersection of the volumes defined by two solids.
/// DIFFERENCE: The operation of constructing the regularized set theoretic intersection of the volumes defined by two solids.
/// 
/// NOTE Corresponding STEP type: boolean_operator, please refer to ISO/IS 10303-42:1994, p.167 for the final definition of the formal standard.
/// 
/// HISTORY New Type in IFC Release 1.5.1.
typedef enum {IfcBooleanOperator_UNION, IfcBooleanOperator_INTERSECTION, IfcBooleanOperator_DIFFERENCE} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcBuildingElementProxyTypeEnum {
/// Definition from IAI: This enumeration defines the
///   available generic types for IfcBuildingElementProxyType.
/// 
/// HISTORY  New enumeration
///   in Release IFC2x Edition 3.
/// 
/// Enumeration
/// 
/// USERDEFINED
/// 
/// NOTDEFINED
typedef enum {IfcBuildingElementProxyType_USERDEFINED, IfcBuildingElementProxyType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcCableCarrierFittingTypeEnum {
/// The IfcCableCarrierFittingTypeEnum defines the range of different types of cable carrier fitting that can be specified. 
///   HISTORY: New type in IFC 2x2  
///   Enumeration 
/// 
/// BEND: A fitting that changes the route of the cable carrier. 
/// CROSS: A fitting at which two branches are taken from the main route of the cable carrier simultaneously. 
/// REDUCER: A fitting that changes the physical size of the main route of the cable carrier. 
/// TEE: A fitting at which a branch is taken from the main route of the cable carrier. 
/// USERDEFINED: User-defined type. 
/// NOTDEFINED: Undefined type.
typedef enum {IfcCableCarrierFittingType_BEND, IfcCableCarrierFittingType_CROSS, IfcCableCarrierFittingType_REDUCER, IfcCableCarrierFittingType_TEE, IfcCableCarrierFittingType_USERDEFINED, IfcCableCarrierFittingType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcCableCarrierSegmentTypeEnum {
/// The IfcCableCarrierSegmentTypeEnum defines the range of different types of cable carrier segment that can be specified. 
///   HISTORY: New type in IFC 2x2  
///   Enumeration 
/// 
/// CABLELADDERSEGMENT: An open carrier segment on which cables are carried on a ladder structure.
/// CABLETRAYSEGMENT: A (typically) open carrier segment onto which cables are laid.
/// CABLETRUNKINGSEGMENT: An enclosed carrier segment with one or more compartments into which cables are placed.
/// CONDUITSEGMENT: An enclosed tubular carrier segment through which cables are pulled.
/// USERDEFINED: User-defined type.  
/// NOTDEFINED: Undefined type.
typedef enum {IfcCableCarrierSegmentType_CABLELADDERSEGMENT, IfcCableCarrierSegmentType_CABLETRAYSEGMENT, IfcCableCarrierSegmentType_CABLETRUNKINGSEGMENT, IfcCableCarrierSegmentType_CONDUITSEGMENT, IfcCableCarrierSegmentType_USERDEFINED, IfcCableCarrierSegmentType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcCableSegmentTypeEnum {
/// The IfcCableSegmentTypeEnum defines the range of different types of cable segment that can be specified. 
/// 
/// HISTORY: New type in IFC
///   2x2. Core and busbar segment added in IFC 2x4.  
///   Enumeration 
/// 
/// BUSBARSEGMENT: Electrical conductor that makes a common connection between several electrical circuits. Properties of a busbar are the same as those of a cable segment and are captured by the cable segment property set. 
/// CABLESEGMENT: Cable with a specific purpose to lead electric current within a circuit or any other electric construction. Includes all types of electric cables, mainly several core segments or conductor segments wrapped together. 
/// CONDUCTORSEGMENT: A single linear element within a cable or an exposed wire (such as for grounding) with the specific purpose to lead electric current, data, or a telecommunications signal.  
/// CORESEGMENT: A self contained element of a  cable that comprises one or more conductors and sheathing.The core of one lead is normally single wired or multiwired which are intertwined.  
/// USERDEFINED: User-defined type.  
/// NOTDEFINED: Undefined type.
typedef enum {IfcCableSegmentType_CABLESEGMENT, IfcCableSegmentType_CONDUCTORSEGMENT, IfcCableSegmentType_USERDEFINED, IfcCableSegmentType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcChangeActionEnum {
/// IfcChangeActionEnum identifies the type of change that might have occurred to the object during the last session (for example, added, modified, deleted). This information is required in a partial model exchange scenario so that an application or model server will know how an object might have been affected by the previous application. Valid enumerations are:
/// 
/// NOCHANGE: Object has not been modified.
/// 
/// MODIFIED: A modification to the object has been made by the user and application defined by the LastModifyingUser and LastModifyingApplication respectively.
/// 
/// ADDED: The object has been created by the user and application defined by the OwningUser and OwningApplication respectively.
/// 
/// DELETED: The object has been deleted by the user and application defined by the LastModifyingUser and LastModifyingApplication respectively.
/// 
/// NOTDEFINED: The change action is not known or has not been defined.
/// 
/// Consider Application A will create an IFC dataset that it wants to publish to others for modification and have the ability to subsequently merge these changes back into the original model. Before publication, it may want to set the IfcChangeActionEnum to NOCHANGE to establish a baseline so that other application changes can be easily identified. Application B then receives this IFC dataset and adds a new object and sets IfcChangeActionEnum to ADDED with Application B defined as the OwningApplication. Application B then modifies an existing object and (re)defines the LastModifiedDate to the time of the modification, LastModifyingUser to the IfcPersonAndOrganization making the change, and sets the LastModifyingApplication to Application B. When Application A receives this modified dataset, it can determine which objects have been added and modified by Application B and either merge or reject these changes as necessary. Consequently, the intent is that an application only modifies the value of IfcChangeActionEnum when it does something to the object, with the further intent that a model server is responsible for clearing the IfcChangeActionEnum back to NOCHANGE when it is ready to be republished.
/// 
/// HISTORY: New enumeration in IFC R2.0. Modified in IFC2x4.
typedef enum {IfcChangeAction_NOCHANGE, IfcChangeAction_MODIFIED, IfcChangeAction_ADDED, IfcChangeAction_DELETED, IfcChangeAction_MODIFIEDADDED, IfcChangeAction_MODIFIEDDELETED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcChillerTypeEnum {
/// Enumeration defining the typical types of Chillers classified by their method of heat rejection. 
///   The IfcChillerTypeEnum contains the following:
/// 
/// AIRCOOLED: Air cooled chiller.
///   WATERCOOLED: Water cooled chiller.
///   HEATRECOVERY: Heat recovery chiller.
///   USERDEFINED:	User-defined chiller type.
///   NOTDEFINED: Undefined chiller type.
/// 
/// HISTORY: New enumeration in IFC R2x.
typedef enum {IfcChillerType_AIRCOOLED, IfcChillerType_WATERCOOLED, IfcChillerType_HEATRECOVERY, IfcChillerType_USERDEFINED, IfcChillerType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcCoilTypeEnum {
/// Enumeration defining the typical types of coils.
/// 
/// The IfcCoilTypeEnum contains the following:
/// 
/// DXCOOLINGCOIL: Cooling coil using a refrigerant to cool the air stream directly.
/// 
/// WATERCOOLINGCOIL: Cooling coil using chilled water. HYDRONICCOIL supercedes this enumerator.
/// 
/// STEAMHEATINGCOIL: Heating coil using steam as heating source.
/// 
/// WATERHEATINGCOIL: Heating coil using hot water as a heating source. HYDRONICCOIL supercedes this enumerator.
/// 
/// ELECTRICHEATINGCOIL: Heating coil using electricity as a heating source.
/// 
/// GASHEATINGCOIL: Heating coil using gas as a heating source.
/// 
/// HYDRONICCOIL: Cooling or Heating coil that uses a hydronic fluid as a cooling or heating source.
///   USERDEFINED: User-defined coil type.
/// 
/// NOTDEFINED:  Undefined coil type.
/// 
/// HISTORY: New enumeration in IFC R2x.
typedef enum {IfcCoilType_DXCOOLINGCOIL, IfcCoilType_WATERCOOLINGCOIL, IfcCoilType_STEAMHEATINGCOIL, IfcCoilType_WATERHEATINGCOIL, IfcCoilType_ELECTRICHEATINGCOIL, IfcCoilType_GASHEATINGCOIL, IfcCoilType_USERDEFINED, IfcCoilType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcColumnTypeEnum {
/// Definition from IAI: This enumeration defines the
/// different types of linear elements an IfcColumnType object
/// can fulfill:
/// 
/// COLUMN: A standard column element usually used
/// vertically.
/// USERDEFINED: User-defined linear element.
/// NOTDEFINED: Undefined linear element
/// 
/// NOTE: This enumeration has been mainly
/// introduced to allow further detailing of the type information in
/// future releases of IFC.
/// HISTORY New Enumeration
/// in Release IFC2x Edition 2.
typedef enum {IfcColumnType_COLUMN, IfcColumnType_USERDEFINED, IfcColumnType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcCompressorTypeEnum {
/// Types of compressors.
///   The IfcCompressorTypeEnum contains the following:
/// 
/// DYNAMIC: The pressure of refrigerant vapor is increased by a continuous transfer of angular momentum from a rotating member to the vapor followed by conversion of this momentum into static pressure.
///   RECIPROCATING: Positive-displacement compressor using a piston driven by a connecting rod from a crankshaft.
///   ROTARY: Positive-displacement compressor using a roller or rotor device.
///   SCROLL: Positive-displacement compressor using two inter-fitting, spiral-shaped scroll members.
///   TROCHOIDAL: Positive-displacement compressor using a rolling motion of one circle outside or inside the circumference of a basic circle and produce either epitrochoids or hypotrochoids.
///   SINGLESTAGE: Positive-displacement reciprocating compressor where vapor is compressed in a single stage.
///   BOOSTER: Positive-displacement reciprocating compressor where pressure is increased by a booster.
///   OPENTYPE: Positive-displacement reciprocating compressor where the shaft extends through a seal in the crankcase for an external drive.
///   HERMETIC: Positive-displacement reciprocating compressor where the motor and compressor are contained within the same housing, with the motor shaft integral with the compressor crankshaft and the motor in contact with refrigerant.
///   SEMIHERMETIC: Positive-displacement reciprocating compressor where the hermetic compressors use bolted construction amenable to field repair.
///   WELDEDSHELLHERMETIC: Positive-displacement reciprocating compressor where the motor compressor is mounted inside a steel shell, which, in turn is sealed by welding.
///   ROLLINGPISTON: Positive-displacement rotary compressor using a roller mounted on the eccentric of a shaft with a single vane in the nonrotating cylindrical housing.
///   ROTARYVANE: Positive-displacement rotary compressor using a roller mounted on the eccentric of a shaft with multiple vanes in the nontotating cylindrical housing.
///   SINGLESCREW: Positive-displacement rotary compressor using a single cylindrical main rotor that works with a pair of gate rotors.
///   TWINSCREW: Positive-displacement rotary compressor using two mating helically grooved rotors, male (lobes) and female (flutes) in a stationary housing with inlet and outlet gas ports.
///   USERDEFINED: User-defined compressor type.
///   NOTDEFINED:  Undefined compressor type.
/// 
/// HISTORY: New enumeration in IFC R2x.
typedef enum {IfcCompressorType_DYNAMIC, IfcCompressorType_RECIPROCATING, IfcCompressorType_ROTARY, IfcCompressorType_SCROLL, IfcCompressorType_TROCHOIDAL, IfcCompressorType_SINGLESTAGE, IfcCompressorType_BOOSTER, IfcCompressorType_OPENTYPE, IfcCompressorType_HERMETIC, IfcCompressorType_SEMIHERMETIC, IfcCompressorType_WELDEDSHELLHERMETIC, IfcCompressorType_ROLLINGPISTON, IfcCompressorType_ROTARYVANE, IfcCompressorType_SINGLESCREW, IfcCompressorType_TWINSCREW, IfcCompressorType_USERDEFINED, IfcCompressorType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcCondenserTypeEnum {
/// Enumeration defining the typical types of condensers.  Air is used as the cooling medium for AIRCOOLED; water is used as the cooling medium for all other types.  The IfcCondenserTypeEnum contains the following:
/// 
/// AIRCOOLED: A condenser in which heat is transferred to an air-stream.
///   EVAPORATIVECOOLED: A condenser that is cooled evaporatively.
///   WATERCOOLED: Water-cooled condenser with unspecified operation.
///   WATERCOOLEDSHELLTUBE: Water-cooled condenser with cooling water circulated through one or more tubes contained within the shell.
///   WATERCOOLEDSHELLCOIL: Water-cooled condenser with cooling water circulated through one or more continuous or assembled coils contained within the shell.
///   WATERCOOLEDTUBEINTUBE: Water-cooled condenser consisting of one or more assemblies of two tubes, one within the other.
///   WATERCOOLEDBRAZEDPLATE: Water-cooled condenser condenser with plates brazed together to form an assembly of separate channels.
///   USERDEFINED: User-defined condenser type.
///   NOTDEFINED:  Undefined condenser type.
/// 
/// HISTORY: New enumeration in IFC 2x2.  WATERCOOLED added in IFC 2x4.
typedef enum {IfcCondenserType_WATERCOOLEDSHELLTUBE, IfcCondenserType_WATERCOOLEDSHELLCOIL, IfcCondenserType_WATERCOOLEDTUBEINTUBE, IfcCondenserType_WATERCOOLEDBRAZEDPLATE, IfcCondenserType_AIRCOOLED, IfcCondenserType_EVAPORATIVECOOLED, IfcCondenserType_USERDEFINED, IfcCondenserType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcConnectionTypeEnum {
/// This enumeration defines the different ways how path based elements (such as IfcWallStandardCase) can connect, as shown in Figure 65. 
/// 
/// HISTORY New type in IFC Release 2.0 
/// 
/// L-Shape Connection 
/// 
/// RelatingConnectionType: AtStart 
///   RelatedConnectionType: AtStart 
/// 
/// L-Shape Connection 
/// 
/// RelatingConnectionType: AtEnd 
///   RelatedConnectionType: AtStart 
/// 
/// T-Shape Connection 
/// 
/// RelatingConnectionType: AtPath 
///   RelatedConnectionType: AtStart 
/// 
/// Figure 65 — Connection types</td
typedef enum {IfcConnectionType_ATPATH, IfcConnectionType_ATSTART, IfcConnectionType_ATEND, IfcConnectionType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcConstraintEnum {
/// IfcConstraintEnum is an enumeration used to qualify a constraint. 
/// 
/// HISTORY: New type in IFC Release 2.0
/// 
/// Enumeration 
/// 
/// Value 
///   Definition 
/// 
/// HARD 
///   Qualifies a constraint such that it must be followed rigidly within or at the values set. 
/// 
/// SOFT 
///   Qualifies a constraint such that it should be followed within or at the values set. 
/// 
/// ADVISORY 
///   Qualifies a constraint such that it is advised that it is followed within or at the values set.
typedef enum {IfcConstraint_HARD, IfcConstraint_SOFT, IfcConstraint_ADVISORY, IfcConstraint_USERDEFINED, IfcConstraint_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcControllerTypeEnum {
/// The IfcControllerTypeEnum defines the range of different types of controller that can be specified.
/// 
/// HISTORY: New type in IFC R2.0
///   Documentation extended in IFC 2x4. PROPORTIONALINTEGRAL and PROPORTIONALINTEGRALDERIVATIVE values deleted (property set enumeration now used).  MULTIPOSITION added.
/// 
/// Enumeration
/// 
/// FLOATING: Output increases or decreases at a constant or accelerating rate.
/// MULTIPOSITION: Output is discrete value, can be one of three or more values.
/// PROGRAMMABLE: Output is programmable such as Discrete Digital Control (DDC).
/// PROPORTIONAL: Output is proportional to the control error and optionally time integral and derivative.
/// TWOPOSITION: Output can be either on or off
/// USERDEFINED: User-defined type.
/// NOTDEFINED: Undefined type.
typedef enum {IfcControllerType_FLOATING, IfcControllerType_PROPORTIONAL, IfcControllerType_PROPORTIONALINTEGRAL, IfcControllerType_PROPORTIONALINTEGRALDERIVATIVE, IfcControllerType_TIMEDTWOPOSITION, IfcControllerType_TWOPOSITION, IfcControllerType_USERDEFINED, IfcControllerType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcCooledBeamTypeEnum {
/// There are two general types of cooled or chilled beams: passive and active.
/// 
/// An active Cooled Beam uses a fan or other auxilliary device to aid in air recirculation, while a passive
/// 
/// Cooled Beam relies solely on convection to cool the space.
/// 
/// Enumeration defining the typical types of cooled beams.
/// 
/// The IfcCooledBeamTypeEnum contains the following:
/// 
/// ACTIVE: An active or ventilated cooled beam provides cooling (and heating) but can also function as an air terminal in a ventilation system.
/// 
/// PASSIVE: A passive or static cooled beam provides cooling (and heating) to a room or zone.
/// 
/// USERDEFINED: User-defined cooled beam type.
/// 
/// NOTDEFINED:  Undefined cooled beam type.
/// 
/// HISTORY: New enumeration in IFC 2x2.
typedef enum {IfcCooledBeamType_ACTIVE, IfcCooledBeamType_PASSIVE, IfcCooledBeamType_USERDEFINED, IfcCooledBeamType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcCoolingTowerTypeEnum {
/// Enumeration defining the typical types of cooling towers. 
///   The IfcCoolingTowerTypeEnum contains the following:
/// 
/// NATURALDRAFT: Air flow is produced naturally.
///   MECHANICALINDUCEDDRAFT: Air flow is produced by a mechanical device, typically one or more fans, located on 
/// 
/// the air outlet side of the cooling tower.
///   MECHANICALFORCEDDRAFT: Air flow is produced by a mechanical device, typically one or more fans, located on 
/// 
/// the inlet air side of the cooling tower.
///   USERDEFINED:  User-defined cooling tower type.
///   NOTDEFINED:  Undefined cooling tower type.
/// 
/// HISTORY: New enumeration in IFC R2x.
typedef enum {IfcCoolingTowerType_NATURALDRAFT, IfcCoolingTowerType_MECHANICALINDUCEDDRAFT, IfcCoolingTowerType_MECHANICALFORCEDDRAFT, IfcCoolingTowerType_USERDEFINED, IfcCoolingTowerType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcCostScheduleTypeEnum {
/// An IfcCostScheduleTypeEnum is a list of the available types of cost schedule from which that required may be selected. 
///   HISTORY: New type in IFC 2x2  
///   Enumeration 
/// 
/// BUDGET: An allocation of money for a particular purpose. 
/// COSTPLAN: An assessment of the amount of money needing to be expended for a defined purpose based on incomplete information about the goods and services required for a construction or installation.  
/// ESTIMATE: An assessment of the amount of money needing to be expended for a defined purpose based on actual information about the goods and services required for a construction or installation. 
/// TENDER: An offer to provide goods and services.  
/// PRICEDBILLOFQUANTITIES: A complete listing of all work items forming construction or installation works in which costs have been allocated to work items.  
/// UNPRICEDBILLOFQUANTITIES: A complete listing of all work items forming construction or installation works in which costs have not yet been allocated to work items. 
/// SCHEDULEOFRATES: A listing of each type of goods forming construction or installation works with the cost of purchase, construction/installation, overheads and profit assigned so that additional items of that type can be costed.  
/// USERDEFINED: User-defined type. 
/// NOTDEFINED: Undefined type.
typedef enum {IfcCostScheduleType_BUDGET, IfcCostScheduleType_COSTPLAN, IfcCostScheduleType_ESTIMATE, IfcCostScheduleType_TENDER, IfcCostScheduleType_PRICEDBILLOFQUANTITIES, IfcCostScheduleType_UNPRICEDBILLOFQUANTITIES, IfcCostScheduleType_SCHEDULEOFRATES, IfcCostScheduleType_USERDEFINED, IfcCostScheduleType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcCoveringTypeEnum {
/// Definition from IAI: This enumeration defines the range
/// of different types of covering that can further specify an
/// IfcCovering or an IfcCoveringType.
/// HISTORY New enumeration
/// in IFC Release 1.0
/// IFC2x4 CHANGE The following
/// enumerators of the IfcCoveringTypeEnum have been
/// deprecated INSULATION, SLEEVING and
/// WRAPPING.
/// Enumeration
/// 
/// CEILING: the covering is used to
/// represent a ceiling
/// FLOORING: the covering is used to
/// represent a flooring
/// CLADDING: the covering is used to
/// represent a cladding
/// ROOFING: the covering is used to
/// represent a roof
/// 
/// INSULATION: the covering is used to
/// insulate an element for thermal or acoustic purposes.
/// IFC2x4 NOTE The use of this
/// enumerator is deprecated.
/// MEMBRANE: an impervious layer that
/// could be used for e.g. roof covering (below tiling - that may be
/// known as sarking etc.) or as a damp proof course membrane
/// IFC2x4 NOTE The use of this
/// enumerator is deprecated.
/// SLEEVING: the covering is used to
/// isolate a distribution element from a space in which it is
/// contained.
/// IFC2x4 NOTE The use of this
/// enumerator is deprecated.
/// WRAPPING: the covering is used for
/// wrapping particularly of distribution elements using tape.
/// IFC2x4 NOTE The use of this
/// enumerator is deprecated.
/// 
/// USERDEFINED: user defined type of
/// covering
/// NOTDEFINED: undefined type of
/// covering
typedef enum {IfcCoveringType_CEILING, IfcCoveringType_FLOORING, IfcCoveringType_CLADDING, IfcCoveringType_ROOFING, IfcCoveringType_INSULATION, IfcCoveringType_MEMBRANE, IfcCoveringType_SLEEVING, IfcCoveringType_WRAPPING, IfcCoveringType_USERDEFINED, IfcCoveringType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcCurrencyEnum {

typedef enum {IfcCurrency_AED, IfcCurrency_AES, IfcCurrency_ATS, IfcCurrency_AUD, IfcCurrency_BBD, IfcCurrency_BEG, IfcCurrency_BGL, IfcCurrency_BHD, IfcCurrency_BMD, IfcCurrency_BND, IfcCurrency_BRL, IfcCurrency_BSD, IfcCurrency_BWP, IfcCurrency_BZD, IfcCurrency_CAD, IfcCurrency_CBD, IfcCurrency_CHF, IfcCurrency_CLP, IfcCurrency_CNY, IfcCurrency_CYS, IfcCurrency_CZK, IfcCurrency_DDP, IfcCurrency_DEM, IfcCurrency_DKK, IfcCurrency_EGL, IfcCurrency_EST, IfcCurrency_EUR, IfcCurrency_FAK, IfcCurrency_FIM, IfcCurrency_FJD, IfcCurrency_FKP, IfcCurrency_FRF, IfcCurrency_GBP, IfcCurrency_GIP, IfcCurrency_GMD, IfcCurrency_GRX, IfcCurrency_HKD, IfcCurrency_HUF, IfcCurrency_ICK, IfcCurrency_IDR, IfcCurrency_ILS, IfcCurrency_INR, IfcCurrency_IRP, IfcCurrency_ITL, IfcCurrency_JMD, IfcCurrency_JOD, IfcCurrency_JPY, IfcCurrency_KES, IfcCurrency_KRW, IfcCurrency_KWD, IfcCurrency_KYD, IfcCurrency_LKR, IfcCurrency_LUF, IfcCurrency_MTL, IfcCurrency_MUR, IfcCurrency_MXN, IfcCurrency_MYR, IfcCurrency_NLG, IfcCurrency_NZD, IfcCurrency_OMR, IfcCurrency_PGK, IfcCurrency_PHP, IfcCurrency_PKR, IfcCurrency_PLN, IfcCurrency_PTN, IfcCurrency_QAR, IfcCurrency_RUR, IfcCurrency_SAR, IfcCurrency_SCR, IfcCurrency_SEK, IfcCurrency_SGD, IfcCurrency_SKP, IfcCurrency_THB, IfcCurrency_TRL, IfcCurrency_TTD, IfcCurrency_TWD, IfcCurrency_USD, IfcCurrency_VEB, IfcCurrency_VND, IfcCurrency_XEU, IfcCurrency_ZAR, IfcCurrency_ZWD, IfcCurrency_NOK} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcCurtainWallTypeEnum {
/// Definition from IAI: Enumeration defining
/// the valid types of curtain wall that can be predefined using the
/// enumeration values. 
/// HISTORY 
/// New Enumeration in Release IFC2x Edition 3
/// NOTE  Currently there
/// are no specific enumerators defined, the IfcCurtainWallTypeEnum
/// has
/// been added for future extensions.
typedef enum {IfcCurtainWallType_USERDEFINED, IfcCurtainWallType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcDamperTypeEnum {
/// This enumeration defines the various types of damper:
/// 
/// BALANCINGDAMPER: Damper used for purposes of manually balancing pressure differences.  Commonly operated by mechanical adjustment.
/// BACKDRAFTDAMPER: Backdraft damper used to restrict the movement of air in one direction.  Commonly operated by mechanical spring.
/// BLASTDAMPER: Blast damper use to prevent protect occupants and equipment against overpressures resultant of an explosion.  Commonly operated by mechanical spring.
/// CONTROLDAMPER: Control damper used to modulate the flow of air by adjusting the position of the blades.  Commonly operated by an actuator of a building automation system.
/// FIREDAMPER: Fire damper used to prevent the spread of fire for a specified duration.  Commonly operated by fusable link that melts above a certain temperature.
/// FIRESMOKEDAMPER: Combination fire and smoke damper used to preven the spread of fire and smoke.  Commonly operated by a fusable link and a smoke detector
/// FUMEHOODEXHAUST: Fume hood exhaust damper.  Commonly operated by actuator.
/// GRAVITYDAMPER: Gravity damper closes from the force of gravity.  Commonly operated by gravitational weight.
/// GRAVITYRELIEFDAMPER: Gravity-relief damper used to allow air to move upon a buildup of enough pressure to overcome the gravitational force exerted upon the damper blades.  Commonly operated by gravitational weight.
/// RELIEFDAMPER: Relief damper used to allow air to move upon a buildup of a specified pressure differential.  Commonly operated by mechanical spring.
/// SMOKEDAMPER: Smoke damper used to prevent the spread of smoke.  Commonly operated by a smoke detector of a building automation system.
/// USERDEFINED: User-defined damper.
/// NOTDEFINED: Undefined damper.
/// 
/// HISTORY: New enumeration in IFC R2.0
typedef enum {IfcDamperType_CONTROLDAMPER, IfcDamperType_FIREDAMPER, IfcDamperType_SMOKEDAMPER, IfcDamperType_FIRESMOKEDAMPER, IfcDamperType_BACKDRAFTDAMPER, IfcDamperType_RELIEFDAMPER, IfcDamperType_BLASTDAMPER, IfcDamperType_GRAVITYDAMPER, IfcDamperType_GRAVITYRELIEFDAMPER, IfcDamperType_BALANCINGDAMPER, IfcDamperType_FUMEHOODEXHAUST, IfcDamperType_USERDEFINED, IfcDamperType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcDataOriginEnum {
/// IfcDataOriginEnum identifies the origin of time data:
/// 
/// MEASURED: The origin of the time data is a measurement device.
///   PREDICTED: The time data are a prediction.
///   SIMULATED: The origin of the time data is a simulation.
///   NOTDEFINED: The origin of the time data is undefined.
/// 
/// HISTORY: New enumeration in IFC 2x2.
typedef enum {IfcDataOrigin_MEASURED, IfcDataOrigin_PREDICTED, IfcDataOrigin_SIMULATED, IfcDataOrigin_USERDEFINED, IfcDataOrigin_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcDerivedUnitEnum {
/// IfcDerivedUnitEnum is an enumeration type for allowed types of derived units.
/// ENUMERATION 
/// 
/// ACCELERATIONUNIT 
///   ANGULARVELOCITYUNIT 
///   COMPOUNDPLANEANGLEUNIT 
///   DYNAMICVISCOSITYUNIT 
///   HEATFLUXDENSITYUNIT 
///   INTEGERCOUNTRATEUNIT 
///   ISOTHERMALMOISTURECAPACITYUNIT 
///   KINEMATICVISCOSITYUNIT 
///   LINEARFORCEUNIT 
///   LINEARMOMENTUNIT 
///   LINEARSTIFFNESSUNIT 
///   LINEARVELOCITYUNIT 
///   MASSDENSITYUNIT 
///   MASSFLOWRATEUNIT 
///   MODULUSOFELASTICITYUNIT 
///   MODULUSOFSUBGRADEREACTIONUNIT 
///   MOISTUREDIFFUSIVITYUNIT 
///   MOLECULARWEIGHTUNIT 
///   MOMENTORINERTIAUNIT 
///   PLANARFORCEUNIT 
///   ROTATIONALFREQUENCYUNIT 
///   ROTATIONALSTIFFNESSUNIT 
///   SHEARMODULUSUNIT 
///   SPECIFICHEATCAPACITYUNIT 
///   THERMALADMITTANCEUNIT 
///   THERMALCONDUCTANCEUNIT 
///   THERMALRESISTANCEUNIT 
///   THERMALTRANSMITTANCEUNIT 
///   TORQUEUNIT 
///   VAPORPERMEABILITYUNIT 
///   VOLUMETRICFLOWRATEUNIT 
///   CURVATUREUNIT 
///   HEATINGVALUEUNIT 
///   IONCONCENTRATIONUNIT 
///   LUMINOUSINTENSITYDISTRIBUTIONUNIT 
///   MASSPERLENGTHUNIT 
///   MODULUSOFLINEARSUBGRADEREACTIONUNIT 
///   MODULUSOFROTATIONALSUBGRADEREACTIONUNIT 
///   PHUNIT 
///   ROTATIONALMASSUNIT 
///   SECTIONAREAINTEGRALUNIT 
///   SECTIONMODULUSUNIT 
///   SOUNDPOWERUNIT 
///   SOUNDPRESSUREUNIT 
///   TEMPERATUREGRADIENTUNIT 
///   TEMPERATURERATEOFCHANGE 
///   THERMALEXPANSIONCOEFFICIENTUNIT 
///   WARPINGCONSTANTUNIT 
///   WARPINGMOMENTUNIT 
///   USERDEFINED: User defined derived unit. 
/// 
/// HISTORY: New type in IFC Release 2.0.
/// 
/// IFC 2x4 change: added TEMPERATURERATEOFCHANGE.
typedef enum {IfcDerivedUnit_ANGULARVELOCITYUNIT, IfcDerivedUnit_COMPOUNDPLANEANGLEUNIT, IfcDerivedUnit_DYNAMICVISCOSITYUNIT, IfcDerivedUnit_HEATFLUXDENSITYUNIT, IfcDerivedUnit_INTEGERCOUNTRATEUNIT, IfcDerivedUnit_ISOTHERMALMOISTURECAPACITYUNIT, IfcDerivedUnit_KINEMATICVISCOSITYUNIT, IfcDerivedUnit_LINEARVELOCITYUNIT, IfcDerivedUnit_MASSDENSITYUNIT, IfcDerivedUnit_MASSFLOWRATEUNIT, IfcDerivedUnit_MOISTUREDIFFUSIVITYUNIT, IfcDerivedUnit_MOLECULARWEIGHTUNIT, IfcDerivedUnit_SPECIFICHEATCAPACITYUNIT, IfcDerivedUnit_THERMALADMITTANCEUNIT, IfcDerivedUnit_THERMALCONDUCTANCEUNIT, IfcDerivedUnit_THERMALRESISTANCEUNIT, IfcDerivedUnit_THERMALTRANSMITTANCEUNIT, IfcDerivedUnit_VAPORPERMEABILITYUNIT, IfcDerivedUnit_VOLUMETRICFLOWRATEUNIT, IfcDerivedUnit_ROTATIONALFREQUENCYUNIT, IfcDerivedUnit_TORQUEUNIT, IfcDerivedUnit_MOMENTOFINERTIAUNIT, IfcDerivedUnit_LINEARMOMENTUNIT, IfcDerivedUnit_LINEARFORCEUNIT, IfcDerivedUnit_PLANARFORCEUNIT, IfcDerivedUnit_MODULUSOFELASTICITYUNIT, IfcDerivedUnit_SHEARMODULUSUNIT, IfcDerivedUnit_LINEARSTIFFNESSUNIT, IfcDerivedUnit_ROTATIONALSTIFFNESSUNIT, IfcDerivedUnit_MODULUSOFSUBGRADEREACTIONUNIT, IfcDerivedUnit_ACCELERATIONUNIT, IfcDerivedUnit_CURVATUREUNIT, IfcDerivedUnit_HEATINGVALUEUNIT, IfcDerivedUnit_IONCONCENTRATIONUNIT, IfcDerivedUnit_LUMINOUSINTENSITYDISTRIBUTIONUNIT, IfcDerivedUnit_MASSPERLENGTHUNIT, IfcDerivedUnit_MODULUSOFLINEARSUBGRADEREACTIONUNIT, IfcDerivedUnit_MODULUSOFROTATIONALSUBGRADEREACTIONUNIT, IfcDerivedUnit_PHUNIT, IfcDerivedUnit_ROTATIONALMASSUNIT, IfcDerivedUnit_SECTIONAREAINTEGRALUNIT, IfcDerivedUnit_SECTIONMODULUSUNIT, IfcDerivedUnit_SOUNDPOWERUNIT, IfcDerivedUnit_SOUNDPRESSUREUNIT, IfcDerivedUnit_TEMPERATUREGRADIENTUNIT, IfcDerivedUnit_THERMALEXPANSIONCOEFFICIENTUNIT, IfcDerivedUnit_WARPINGCONSTANTUNIT, IfcDerivedUnit_WARPINGMOMENTUNIT, IfcDerivedUnit_USERDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcDimensionExtentUsage {

typedef enum {IfcDimensionExtentUsage_ORIGIN, IfcDimensionExtentUsage_TARGET} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcDirectionSenseEnum {
/// IfcDirectionSenseEnum is an enumeration denoting whether sense of direction is positive or negative along the given axis.
/// 
/// ENUMERATION
/// 
/// POSITIVE: Direction defined to be positive.
/// NEGATIVE: Direction defined to be negative.
/// 
/// HISTORY New Type in IFC2x.
typedef enum {IfcDirectionSense_POSITIVE, IfcDirectionSense_NEGATIVE} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcDistributionChamberElementTypeEnum {
/// This enumeration identifies different types of distribution chambers.
/// 
/// Valid enumerations are:
/// 
/// FORMEDDUCT: Space formed in the ground for the passage of pipes, cables, ducts.
/// INSPECTIONCHAMBER: Chamber constructed on a drain, sewer or pipeline with a removable cover that permits visble inspection.
/// INSPECTIONPIT:  Recess or chamber formed to permit access for inspection of substructure and services.
/// MANHOLE: Chamber constructed on a drain, sewer or pipeline with a removable cover that permits the entry of a person.
/// METERCHAMBER: Chamber that houses a meter(s).
/// SUMP: Recessed or small chamber into which liquid is drained to facilitate its collection for removal.
/// TRENCH: Excavated chamber, the length of which typically exceeds the width.
/// VALVECHAMBER: Chamber that houses a valve(s).
/// USERDEFINED: User-defined chamber type.
/// NOTDEFINED: Undefined chamber type.
/// 
/// HISTORY: New enumeration in IFC R2x2
typedef enum {IfcDistributionChamberElementType_FORMEDDUCT, IfcDistributionChamberElementType_INSPECTIONCHAMBER, IfcDistributionChamberElementType_INSPECTIONPIT, IfcDistributionChamberElementType_MANHOLE, IfcDistributionChamberElementType_METERCHAMBER, IfcDistributionChamberElementType_SUMP, IfcDistributionChamberElementType_TRENCH, IfcDistributionChamberElementType_VALVECHAMBER, IfcDistributionChamberElementType_USERDEFINED, IfcDistributionChamberElementType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcDocumentConfidentialityEnum {
/// IfcDocumentConfidentialityEnum enables selection of the level of confidentiality of document information from a list of choices. 
/// 
/// HISTORY: New enumeration in IFC 2x
/// 
/// Enumeration 
/// 
/// PUBLIC: Document is publicly available. 
/// RESTRICTED: Document availability is restricted. 
/// CONFIDENTIAL: Document is confidential and its contents should not be revealed without permission. 
/// PERSONAL: Document is personal to the author. 
/// USERDEFINED 
/// NOTDEFINED
typedef enum {IfcDocumentConfidentiality_PUBLIC, IfcDocumentConfidentiality_RESTRICTED, IfcDocumentConfidentiality_CONFIDENTIAL, IfcDocumentConfidentiality_PERSONAL, IfcDocumentConfidentiality_USERDEFINED, IfcDocumentConfidentiality_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcDocumentStatusEnum {
/// IfcDocumentStatusEnum enables selection of the status of document information from a list of choices.
/// 
/// HISTORY: New enumeration in IFC Release 2x.
typedef enum {IfcDocumentStatus_DRAFT, IfcDocumentStatus_FINALDRAFT, IfcDocumentStatus_FINAL, IfcDocumentStatus_REVISION, IfcDocumentStatus_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcDoorPanelOperationEnum {
/// This enumeration defines the basic ways how individual door panels operate as shown in Figure 164.
/// HISTORY New Enumeration in IFC Release 2.0.
/// IFC2x4 CHANGE Enumerator FIXEDPANELadded.
/// 
/// Swinging
/// 
/// DoubleActing
/// 
/// Sliding
/// 
/// Folding
/// 
/// Revolving
/// 
/// Rollingup
/// 
/// FixedPanel
/// 
/// NOTE Enumerator added in IFC2x4.
/// 
/// UserDefined
///  
/// 
/// NotDefined
///  
/// 
/// Figure 164 — Door operations
/// 
/// The opening direction of the door panels is given by the local
/// placement of the IfcDoor. The positive y-axis determines
/// the direction as shown in Figure 165.
/// 
/// Figure 165 — Door panel operations
/// 
/// NOTE  Figures (symbolic representation) depend on the national building code.  These figures are only shown as illustrations
typedef enum {IfcDoorPanelOperation_SWINGING, IfcDoorPanelOperation_DOUBLE_ACTING, IfcDoorPanelOperation_SLIDING, IfcDoorPanelOperation_FOLDING, IfcDoorPanelOperation_REVOLVING, IfcDoorPanelOperation_ROLLINGUP, IfcDoorPanelOperation_USERDEFINED, IfcDoorPanelOperation_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcDoorPanelPositionEnum {
/// Definition: This enumeration defines the basic ways to describe the location of a door panel within a door lining.
/// 
/// HISTORY New Enumeration in IFC Release 2.x
/// 
/// Figure 166 shows the designation of a door panel with PanelPosition = LEFT and a door panel with PanelPosition = RIGHT within a door style with OperationType = DOUBLE_DOOR_SINGLE_SWING. The position is given as shown in the XZ plane of the local placement, looking into the direction of the positive Y axis. 
/// 
/// Figure 166 — Door panel positions
typedef enum {IfcDoorPanelPosition_LEFT, IfcDoorPanelPosition_MIDDLE, IfcDoorPanelPosition_RIGHT, IfcDoorPanelPosition_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcDoorStyleConstructionEnum {
/// Definition from IAI: This enumeration defines the
///   basic types of construction of doors. The construction type
///   relates to the main material (or material combination) used
///   for making the door.
/// 
/// HISTORY New Enumeration in
///   IFC Release 2x .
typedef enum {IfcDoorStyleConstruction_ALUMINIUM, IfcDoorStyleConstruction_HIGH_GRADE_STEEL, IfcDoorStyleConstruction_STEEL, IfcDoorStyleConstruction_WOOD, IfcDoorStyleConstruction_ALUMINIUM_WOOD, IfcDoorStyleConstruction_ALUMINIUM_PLASTIC, IfcDoorStyleConstruction_PLASTIC, IfcDoorStyleConstruction_USERDEFINED, IfcDoorStyleConstruction_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcDoorStyleOperationEnum {
/// This enumeration defines the basic ways to describe how doors operate as shown in Figure 167.
/// HISTORY  New Enumeration in Release IFC2x.
/// 
/// Enumerator
///   Description
///   Figure
/// 
/// SINGLE_SWING_LEFT
/// 
/// Door with one
/// panel that opens (swings) to the
/// left. The hinges are on the left side as viewed in the direction of the
/// positive y-axis.
///   Note: Direction of swing (whether
/// in or out)
/// is determined at the IfcDoor.
/// 
/// SINGLE_SWING_RIGHT
/// 
/// Door with one
/// panel that opens (swings) to the
/// right. The hinges are on the right side as viewed in the direction of
/// the positive y-axis.
///   Note: Direction of swing (whether
/// in or out)
/// is determined at the IfcDoor.
/// 
/// DOUBLE_DOOR_
/// SINGLE_SWING
/// 
/// Door with two
/// panels, one opens (swings) to the
/// left the other opens (swings) to the right.
///   Note: Direction of swing (whether
/// in or out)
/// is determined at the IfcDoor. 
/// 
/// DOUBLE_SWING_LEFT
/// 
/// Door with one
/// panel that swings in both
/// directions and to the left in the main trafic direction. Also called
/// double acting door.
///   Note: Direction of main swing
/// (whether in or
/// out) is determined at the IfcDoor. 
/// 
/// DOUBLE_SWING_RIGHT
/// 
/// Door with one
/// panel that swings in both
/// directions and to the right in the main trafic direction. Also called
/// double acting door.
///   Note: Direction of main swing
/// (whether in or
/// out) is determined at the IfcDoor.
/// 
/// DOUBLE_DOOR_
/// DOUBLE_SWING
/// 
/// Door with two
/// panels, one swings in both
/// directions and to the right in the main trafic direction the other
/// swings also in both directions and to the left in the main trafic
/// direction.
///   Note: Direction of main swing
/// (whether in or
/// out) is determined at the IfcDoor.
/// 
/// DOUBLE_DOOR_
/// SINGLE_SWING_
/// OPPOSITE_LEFT
/// 
/// Door with two
/// panels that both open to the left,
/// one panel swings in one direction and the other panel swings in the
/// opposite direction.
///   Note: Direction of main swing
/// (whether in or
/// out) is determined at the IfcDoor.
/// 
/// DOUBLE_DOOR_
/// SINGLE_SWING_
/// OPPOSITE_RIGHT
///   Door with two
/// panels that both open to the right,
/// one panel swings in one direction and the other panel swings in the
/// opposite direction.
///   Note: Direction of main swing
/// (whether in or
/// out) is determined at the IfcDoor.
/// 
/// SLIDING_TO_LEFT
/// 
/// Door with one
/// panel that is sliding to the left. 
/// 
/// SLIDING_TO_RIGHT
/// 
/// Door with one
/// panel that is sliding to the right. 
/// 
/// DOUBLE_DOOR_SLIDING
/// 
/// Door with two
/// panels, one is sliding to the left
/// the other is sliding to the right. 
/// 
/// FOLDING_TO_LEFT
/// 
/// Door with one
/// panel that is folding to the left. 
/// 
/// FOLDING_TO_RIGHT
///   Door with one
/// panel that is folding to the right. 
/// 
/// DOUBLE_DOOR_FOLDING
/// 
/// Door with two
/// panels, one is folding to the left
/// the other is folding to the right. 
/// 
/// REVOLVING
/// 
/// An entrance door
/// consisting of four leaves set in
/// a form of a cross and revolving around a central vertical axis (the
/// four panels are described by a single IfcDoor panel
/// property). 
/// 
/// ROLLINGUP
/// 
/// Door that opens
/// by rolling up.
///   Note: Whether it rolls up to the
/// inside or
/// outside is determined at the IfcDoor.
/// 
/// USERDEFINED
///   User defined
/// operation type
///    
/// 
/// NOTDEFINED
///   A door with a
/// not defined operation type is
/// considered as a door with a lining, but no panels. It is thereby always
/// open.
///    
/// 
/// Figure 167 — Door style operations
/// 
/// NOTE
/// 
/// Figures are shown in the ground view.
///   Figures (symbolic representation) depend on the national
/// building
/// code.
///   These figures are only shown as illustrations, the actual
/// representation in the ground view might differ. 
///   Open to the outside is declared as open into the direction
/// of the
/// positive y-axis, determined by the ObjectPlacement
/// at IfcDoor
///   The location of the panel relative to the wall thickness is
/// defined by the ObjectPlacement at IfcDoor,
/// and the IfcDoorLiningProperties.LiningOffset
/// parameter.
typedef enum {IfcDoorStyleOperation_SINGLE_SWING_LEFT, IfcDoorStyleOperation_SINGLE_SWING_RIGHT, IfcDoorStyleOperation_DOUBLE_DOOR_SINGLE_SWING, IfcDoorStyleOperation_DOUBLE_DOOR_SINGLE_SWING_OPPOSITE_LEFT, IfcDoorStyleOperation_DOUBLE_DOOR_SINGLE_SWING_OPPOSITE_RIGHT, IfcDoorStyleOperation_DOUBLE_SWING_LEFT, IfcDoorStyleOperation_DOUBLE_SWING_RIGHT, IfcDoorStyleOperation_DOUBLE_DOOR_DOUBLE_SWING, IfcDoorStyleOperation_SLIDING_TO_LEFT, IfcDoorStyleOperation_SLIDING_TO_RIGHT, IfcDoorStyleOperation_DOUBLE_DOOR_SLIDING, IfcDoorStyleOperation_FOLDING_TO_LEFT, IfcDoorStyleOperation_FOLDING_TO_RIGHT, IfcDoorStyleOperation_DOUBLE_DOOR_FOLDING, IfcDoorStyleOperation_REVOLVING, IfcDoorStyleOperation_ROLLINGUP, IfcDoorStyleOperation_USERDEFINED, IfcDoorStyleOperation_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcDuctFittingTypeEnum {
/// This enumeration is used to identify the primary purpose of a duct fitting. This is a very basic categorization mechanism
///   to generically identify the duct fitting type. Subcategories
///   of duct fittings are not enumerated. 
///   The IfcDuctFittingTypeEnum contains the following:
/// 
/// BEND:		A fitting with typically two ports used to change 
///   the direction of flow between connected elements.
///   CONNECTOR:   Connector fitting, typically used to join two
///   ports together within a flow distribution system 
///   (e.g., a coupling used to join two duct segments).
///   ENTRY:       Entry fitting, typically unconnected at one port
///   and connected to a flow distribution system at 
///   the other (e.g., an outside air duct system 
///   intake opening).
///   EXIT:        Exit fitting, typically unconnected at one port
///   and connected to a flow distribution system at 
///   the other (e.g., an exhaust air discharge 
///   opening).
///   JUNCTION:	A fitting with typically more than two ports used
///   to redistribute flow among the ports and/or to
///   change the direction of flow between connected
///   elements (e.g, tee, cross, wye, etc.).
///   OBSTRUCTION: A fitting with typically two ports used to 
///   obstruct or restrict flow between the connected
///   elements (e.g., screen, perforated plate, etc.).
///   TRANSITION:	A fitting with typically two ports having
///   different shapes or sizes. Can also be used to
///   change the direction of flow between connected
///   elements.
///   USERDEFINED: User-defined fitting.
///   NOTDEFINED:  Undefined fitting.
/// 
/// HISTORY: New enumeration in IFC 2x2
typedef enum {IfcDuctFittingType_BEND, IfcDuctFittingType_CONNECTOR, IfcDuctFittingType_ENTRY, IfcDuctFittingType_EXIT, IfcDuctFittingType_JUNCTION, IfcDuctFittingType_OBSTRUCTION, IfcDuctFittingType_TRANSITION, IfcDuctFittingType_USERDEFINED, IfcDuctFittingType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcDuctSegmentTypeEnum {
/// This enumeration is used to identify the primary purpose of a
///   duct segment. This is a very basic categorization mechanism
///   to generically identify the duct segment type. Subcategories
///   of duct segments are not enumerated. 
///   The IfcDuctSegmentTypeEnum contains the following:
/// 
/// RIGIDSEGMENT: A rigid segment is continuous linear segment of duct
///   that cannot be deformed.
///   FLEXIBLESEGMENT:  A flexible segment is a continuous non-linear segment
///   of duct that can be deformed and change the direction 
///   of flow.
///   USERDEFINED: User-defined segment.
///   NOTDEFINED:  Undefined segment.
/// 
/// HISTORY: New enumeration in IFC 2x2
typedef enum {IfcDuctSegmentType_RIGIDSEGMENT, IfcDuctSegmentType_FLEXIBLESEGMENT, IfcDuctSegmentType_USERDEFINED, IfcDuctSegmentType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcDuctSilencerTypeEnum {
/// Enumeration defining the typical types of duct silencers. 
///   The IfcDuctSilencerTypeEnum contains the following:
/// 
/// FLATOVAL:  Flat-oval shaped duct silencer type.
///   RECTANGULAR:  Rectangular shaped duct silencer type.
///   ROUND:  Round duct silencer type.
///   USERDEFINED:  User-defined duct silencer type.
///   NOTDEFINED:  Undefined duct silencer type.
/// 
/// HISTORY: New enumeration in IFC 2x2.
typedef enum {IfcDuctSilencerType_FLATOVAL, IfcDuctSilencerType_RECTANGULAR, IfcDuctSilencerType_ROUND, IfcDuctSilencerType_USERDEFINED, IfcDuctSilencerType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcElectricApplianceTypeEnum {
/// The IfcElectricApplianceTypeEnum defines the range of different types of electrical appliance that can be specified. 
/// 
/// HISTORY: New type in IFC R2.0.
///   Renamed from IfcElectricalApplianceTypeEnum if IFC 2x2.IFC 2x2 Addendum 1:
///   Missing enumeration values added (ELECTRICHEATER, TUMBLEDRYER and
///   WATERHEATER)
///   IFC 2x4: ELECTRICHEATER changed to FREESTANDINGELECTRICHEATER and noted as being for occasional use. RADIANTHEATER removed as part of general 'heater consolidation'. WATERHEATER, DIRECTWATERHEATER and INDIRECTWATERHEATER rationalized to FREESTANDINGWATERHEATER. WATERCOOLER changed to FREESTANDINGWATERCOOLER.
///   COMPUTER, FACSIMILE (FAX), PRINTER, SCANNER, TELEPHONE, TV (TELEVISION) moved to IfcAudioVisualApplianceTypeEnum and IfcCommunicationsApplianceTypeEnum. KITCHENMACHINE added.
/// 
/// Enumeration 
/// 
/// DISHWASHER: An appliance that has the primary function of washing dishes. 
/// ELECTRICCOOKER: An electrical appliance that has the primary function of cooking food (including oven, hob, grill). 
/// FREESTANDINGELECTRICHEATER: An electrical appliance that is used occasionally to provide heat. A freestanding electric heater is a 'plugged' appliance whose load may be removed from an electric circuit. 
/// FREESTANDINGFAN: An electrical appliance that is used occasionally to provide ventilation. A freestanding fan is a 'plugged' appliance whose load may be removed from an electric circuit. 
/// FREESTANDINGWATERHEATER: A small, local electrical appliance for heating water. A freestanding water heater is a 'plugged' appliance whose load may be removed from an electric circuit. 
/// FREESTANDINGWATERCOOLER: A small, local electrical appliance for cooling water. A freestanding water cooler is a 'plugged' appliance whose load may be removed from an electric circuit. 
/// FREEZER: An electrical appliance that has the primary function of storing food at temperatures below the freezing point of water. 
/// FRIDGE_FREEZER: An electrical appliance that combines the functions of a freezer and a refrigerator through the provision of separate compartments. 
/// KITCHENMACHINE: A specialized appliance used in commercial kitchens such as a mixer. 
/// HANDDRYER: An electrical appliance that has the primary function of drying hands. 
/// MICROWAVE: An electrical appliance that has the primary function of cooking food using microwaves. 
/// PHOTOCOPIER: A machine that has the primary function of reproduction of printed matter. 
/// REFRIGERATOR: An electrical appliance that has the primary function of storing food at low temperature but above the freezing point of water. 
/// TUMBLEDRYER: An electrical appliance that has the primary function of drying clothes. 
/// VENDINGMACHINE: An appliance that stores and vends goods including food, drink and goods of various types. 
/// WASHINGMACHINE: An appliance that has the primary function of washing clothes. 	  
/// USERDEFINED: User-defined type. 
/// NOTDEFINED: Undefined type.
typedef enum {IfcElectricApplianceType_COMPUTER, IfcElectricApplianceType_DIRECTWATERHEATER, IfcElectricApplianceType_DISHWASHER, IfcElectricApplianceType_ELECTRICCOOKER, IfcElectricApplianceType_ELECTRICHEATER, IfcElectricApplianceType_FACSIMILE, IfcElectricApplianceType_FREESTANDINGFAN, IfcElectricApplianceType_FREEZER, IfcElectricApplianceType_FRIDGE_FREEZER, IfcElectricApplianceType_HANDDRYER, IfcElectricApplianceType_INDIRECTWATERHEATER, IfcElectricApplianceType_MICROWAVE, IfcElectricApplianceType_PHOTOCOPIER, IfcElectricApplianceType_PRINTER, IfcElectricApplianceType_REFRIGERATOR, IfcElectricApplianceType_RADIANTHEATER, IfcElectricApplianceType_SCANNER, IfcElectricApplianceType_TELEPHONE, IfcElectricApplianceType_TUMBLEDRYER, IfcElectricApplianceType_TV, IfcElectricApplianceType_VENDINGMACHINE, IfcElectricApplianceType_WASHINGMACHINE, IfcElectricApplianceType_WATERHEATER, IfcElectricApplianceType_WATERCOOLER, IfcElectricApplianceType_USERDEFINED, IfcElectricApplianceType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcElectricCurrentEnum {

typedef enum {IfcElectricCurrent_ALTERNATING, IfcElectricCurrent_DIRECT, IfcElectricCurrent_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcElectricDistributionPointFunctionEnum {

typedef enum {IfcElectricDistributionPointFunction_ALARMPANEL, IfcElectricDistributionPointFunction_CONSUMERUNIT, IfcElectricDistributionPointFunction_CONTROLPANEL, IfcElectricDistributionPointFunction_DISTRIBUTIONBOARD, IfcElectricDistributionPointFunction_GASDETECTORPANEL, IfcElectricDistributionPointFunction_INDICATORPANEL, IfcElectricDistributionPointFunction_MIMICPANEL, IfcElectricDistributionPointFunction_MOTORCONTROLCENTRE, IfcElectricDistributionPointFunction_SWITCHBOARD, IfcElectricDistributionPointFunction_USERDEFINED, IfcElectricDistributionPointFunction_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcElectricFlowStorageDeviceTypeEnum {
/// The IfcElectricFlowStorageDeviceTypeEnum defines the range of different types of electrical flow storage device available. 
///   HISTORY: New type in IFC 2x2  
///   Enumeration 
/// 
/// BATTERY: A device for storing energy in chemical form so that it can be released as electrical energy. 
/// CAPACITORBANK: A device that stores electrical energy when an external power supply is present using the electrical property of capacitance 
/// HARMONICFILTER: A device that constantly injects currents that precisely correspond to the harmonic components drawn by the load. 
/// UPS: A device that provides a time limited alternative source of power supply in the event of failure of the main supply.  
/// USERDEFINED: User-defined type.  
/// NOTDEFINED: Undefined type.
typedef enum {IfcElectricFlowStorageDeviceType_BATTERY, IfcElectricFlowStorageDeviceType_CAPACITORBANK, IfcElectricFlowStorageDeviceType_HARMONICFILTER, IfcElectricFlowStorageDeviceType_INDUCTORBANK, IfcElectricFlowStorageDeviceType_UPS, IfcElectricFlowStorageDeviceType_USERDEFINED, IfcElectricFlowStorageDeviceType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcElectricGeneratorTypeEnum {
/// The IfcElectricGeneratorTypeEnum defines the range of types of electric generators available.
///   HISTORY: New type in IFC 2x2.  Values added in IFC 2x4. 
/// 
/// Enumeration 
/// 
/// CHP: Combined heat and power supply, used not only as a source of electric energy but also as a heating source for the building. It may therefore be not only part of an electrical system but also of a heating system. 
/// ENGINEGENERATOR: Electrical generator with a fuel-driven engine, for example a diesel-driven emergency power supply. 
/// STANDALONE: Electrical generator which does not include its source of kinetic energy, that is, a motor, engine, or turbine is modeled by a separate object. 
/// USERDEFINED: User-defined type. 
/// NOTDEFINED: Undefined type.
typedef enum {IfcElectricGeneratorType_USERDEFINED, IfcElectricGeneratorType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcElectricHeaterTypeEnum {

typedef enum {IfcElectricHeaterType_ELECTRICPOINTHEATER, IfcElectricHeaterType_ELECTRICCABLEHEATER, IfcElectricHeaterType_ELECTRICMATHEATER, IfcElectricHeaterType_USERDEFINED, IfcElectricHeaterType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcElectricMotorTypeEnum {
/// The IfcElectricMotorTypeEnum defines the range of different types of electric motor that can be specified. 
///   HISTORY: New type in IFC 2x2  
///   Enumeration 
/// 
/// DC: A motor using either generated or rectified D.C. power. 
/// INDUCTION: An alternating current motor in which the primary winding on one member (usually the stator) is connected to the power source and a secondary winding or a squirrel-cage secondary winding on the other member (usually the rotor) carries the induced current. There is no physical electrical connection to the secondary winding, its current is induced. 
/// POLYPHASE: A two or three-phase induction motor in which the windings, one for each phase, are evenly divided by the same number of electrical degrees.  
/// RELUCTANCESYNCHRONOUS: A synchronous motor with a special rotor design which directly lines the rotor up with the rotating magnetic field of the stator, allowing for no slip under load.  
/// SYNCHRONOUS: A motor that operates at a constant speed up to full load. The rotor speed is equal to the speed of the rotating magnetic field of the stator; there is no slip. 
/// USERDEFINED: User-defined type. 
/// NOTDEFINED: Undefined type.
typedef enum {IfcElectricMotorType_DC, IfcElectricMotorType_INDUCTION, IfcElectricMotorType_POLYPHASE, IfcElectricMotorType_RELUCTANCESYNCHRONOUS, IfcElectricMotorType_SYNCHRONOUS, IfcElectricMotorType_USERDEFINED, IfcElectricMotorType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcElectricTimeControlTypeEnum {
/// The IfcElectricTimeControlTypeEnum defines the range of types of electrical time control available. 
///   HISTORY: New type in IFC 2x2  
///   Enumeration 
/// 
/// TIMECLOCK: A control that causes action to occur at set times. 
/// TIMEDELAY: A control that causes action to occur following a set duration. 
/// RELAY: Electromagnetically operated contactor for making or breaking a control circuit. 
/// USERDEFINED: User-defined type. 
/// NOTDEFINED: Undefined type.
typedef enum {IfcElectricTimeControlType_TIMECLOCK, IfcElectricTimeControlType_TIMEDELAY, IfcElectricTimeControlType_RELAY, IfcElectricTimeControlType_USERDEFINED, IfcElectricTimeControlType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcElementAssemblyTypeEnum {
/// Definition from IAI: An enumeration defining the
///   basic configuration types for element assemblies.
/// 
/// HISTORY New enumeration type
///   in Release IFC2x Edition 2.
/// 
/// Enumeration
/// 
/// ACCESSORY_ASSEMBLY: Assembled accessories or components
///   ARCH: A curved structure
///   BEAM_GRID: Interconnected beams, located in one (typically horizontal) plane
///   BRACED_FRAME: A rigid frame with additional bracing members
///   GIRDER: A beam-like superstructure
///   REINFORCEMENT_UNIT: Assembled reinforcement elements
///   RIGID_FRAME: A structure built up of beams, columns, etc. with moment-resisting joints
///   SLAB_FIELD: Slabs, laid out in one plane
///   TRUSS: A structure built up of members with (quasi) pinned joints
///   USERDEFINED: User-defined element assembly
///   NOTDEFINED: Undefined element assembly
typedef enum {IfcElementAssemblyType_ACCESSORY_ASSEMBLY, IfcElementAssemblyType_ARCH, IfcElementAssemblyType_BEAM_GRID, IfcElementAssemblyType_BRACED_FRAME, IfcElementAssemblyType_GIRDER, IfcElementAssemblyType_REINFORCEMENT_UNIT, IfcElementAssemblyType_RIGID_FRAME, IfcElementAssemblyType_SLAB_FIELD, IfcElementAssemblyType_TRUSS, IfcElementAssemblyType_USERDEFINED, IfcElementAssemblyType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcElementCompositionEnum {
/// Definition from IAI: Enumeration that provides an
///   indication, whether the spatial structure element or proxy
///   represents a:
/// 
/// COMPLEX - a group or aggregation of similar elements
/// 
/// ELEMENT - a (undivided) element itself
/// 
/// PARTIAL - a subelement or part
/// 
/// HISTORY New enumeration in
///   IFC Release 2.x
typedef enum {IfcElementComposition_COMPLEX, IfcElementComposition_ELEMENT, IfcElementComposition_PARTIAL} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcEnergySequenceEnum {

typedef enum {IfcEnergySequence_PRIMARY, IfcEnergySequence_SECONDARY, IfcEnergySequence_TERTIARY, IfcEnergySequence_AUXILIARY, IfcEnergySequence_USERDEFINED, IfcEnergySequence_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcEnvironmentalImpactCategoryEnum {

typedef enum {IfcEnvironmentalImpactCategory_COMBINEDVALUE, IfcEnvironmentalImpactCategory_DISPOSAL, IfcEnvironmentalImpactCategory_EXTRACTION, IfcEnvironmentalImpactCategory_INSTALLATION, IfcEnvironmentalImpactCategory_MANUFACTURE, IfcEnvironmentalImpactCategory_TRANSPORTATION, IfcEnvironmentalImpactCategory_USERDEFINED, IfcEnvironmentalImpactCategory_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcEvaporativeCoolerTypeEnum {
/// Enumeration defining the typical types of evaporative coolers. 
///   The IfcEvaporativeCoolerTypeEnum contains the following:
/// 
/// DIRECTEVAPORATIVERANDOMMEDIAAIRCOOLER: Direct evaporative random media air cooler: Cools the air stream by evaporating water dircectly into the air stream using coolers with evaporative pads, usually of aspen wood or plastic fiber/foam.
///   DIRECTEVAPORATIVERIGIDMEDIAAIRCOOLER: Direct evaporative rigid media air cooler: Cools the air stream by evaporating water dircectly into the air stream using coolers with sheets of rigid, corrugated material as the wetted surface.
///   DIRECTEVAPORATIVESLINGERSPACKAGEDAIRCOOLER: Direct evaporative slingers packaged air cooler: Cools the air stream by evaporating water dircectly into the air stream using coolers with a water slinger in an evaporative cooling section and a fan section.
///   DIRECTEVAPORATIVEPACKAGEDROTARYAIRCOOLER: Direct evaporative packaged rotary air cooler: Cools the air stream by evaporating water dircectly into the air stream using coolers that wet and wash the evaporative pad by rotating it through a water bath.
///   DIRECTEVAPORATIVEAIRWASHER: Direct evaporative air washer: Cools the air stream by evaporating water dircectly into the air stream using coolers with spray-type air washer consist of a chamber or casing containing spray nozzles, and tank for collecting spray water, and an eliminator section for removing entrained drops of water from the air.
///   INDIRECTEVAPORATIVEPACKAGEAIRCOOLER: Indirect evaporative package air cooler: Cools the air stream by evaporating water indirectly and without adding moisture into the air stream. On one side of the heat exchanger, the secondary air stream is cooled by evaporation, while on the other side of heat exchanger, the primary air stream (conditioned air to be supplied to the room) is sensibly cooled by the heat exchanger surfaces.
///   INDIRECTEVAPORATIVEWETCOIL: Indirect evaporative wet coil: Cools the air stream by evaporating water indirectly and without adding moisture into the air stream. Water is sprayed directly on the tubes of the heat exchanger where latent cooling takes place and the vaporization of the water on the outside of the heat exchanger tubes allows the simultaneous heat and mass transfer which removes heat from the supply air on the tube side.
///   INDIRECTEVAPORATIVECOOLINGTOWERORCOILCOOLER: Indirect evaporative cooling tower or coil cooler: Cools the air stream by evaporating water indirectly and without adding moisture into the air stream using a combination of a cooling tower or other evaporative water cooler with a water-to-air heat exchanger coil and water circulating pump.
///   INDIRECTDIRECTCOMBINATION: Indirect/Direct combination: Cools the air stream by evaporating water indirectly and without adding moisture into the air stream using a two-stage cooler with a first-stage indirect evaporative cooler and second-stage direct evaporative cooler.
///   USERDEFINED:  User-defined evaporative cooler type.
///   NOTDEFINED:  Undefined evaporative cooler type.
/// 
/// HISTORY: New enumeration in IFC 2x2.
typedef enum {IfcEvaporativeCoolerType_DIRECTEVAPORATIVERANDOMMEDIAAIRCOOLER, IfcEvaporativeCoolerType_DIRECTEVAPORATIVERIGIDMEDIAAIRCOOLER, IfcEvaporativeCoolerType_DIRECTEVAPORATIVESLINGERSPACKAGEDAIRCOOLER, IfcEvaporativeCoolerType_DIRECTEVAPORATIVEPACKAGEDROTARYAIRCOOLER, IfcEvaporativeCoolerType_DIRECTEVAPORATIVEAIRWASHER, IfcEvaporativeCoolerType_INDIRECTEVAPORATIVEPACKAGEAIRCOOLER, IfcEvaporativeCoolerType_INDIRECTEVAPORATIVEWETCOIL, IfcEvaporativeCoolerType_INDIRECTEVAPORATIVECOOLINGTOWERORCOILCOOLER, IfcEvaporativeCoolerType_INDIRECTDIRECTCOMBINATION, IfcEvaporativeCoolerType_USERDEFINED, IfcEvaporativeCoolerType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcEvaporatorTypeEnum {
/// Enumeration defining the typical types of evaporators. 
///   The IfcEvaporatorTypeEnum contains the following:
/// 
/// DIRECTEXPANSION: Direct-expansion evaporator.
///   DIRECTEXPANSIONSHELLANDTUBE: Direct-expansion evaporator where a refrigerant evaporates inside a series of baffles that channel the fluid throughout the shell side.
///   DIRECTEXPANSIONTUBEINTUBE: Direct-expansion evaporator where a refrigerant evaporates inside one or more pairs of coaxial tubes.
///   DIRECTEXPANSIONBRAZEDPLATE: Direct-expansion evaporator where a refrigerant evaporates inside plates brazed or welded together to make up an assembly of separate channels.
///   FLOODEDSHELLANDTUBE: Evaporator in which refrigerant evaporates outside tubes.
///   SHELLANDCOIL: Evaporator in which refrigerant evaporates inside a simple coiled tube immersed in the fluid to be cooled.
///   USERDEFINED:  User-defined evaporator type.
///   NOTDEFINED:  Undefined evaporator type.
/// 
/// HISTORY: New enumeration in IFC 2x2.
typedef enum {IfcEvaporatorType_DIRECTEXPANSIONSHELLANDTUBE, IfcEvaporatorType_DIRECTEXPANSIONTUBEINTUBE, IfcEvaporatorType_DIRECTEXPANSIONBRAZEDPLATE, IfcEvaporatorType_FLOODEDSHELLANDTUBE, IfcEvaporatorType_SHELLANDCOIL, IfcEvaporatorType_USERDEFINED, IfcEvaporatorType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcFanTypeEnum {
/// Enumeration defining the typical types of fans.
///   The IfcFanTypeEnum contains the following:
/// 
/// CENTRIFUGALFORWARDCURVED: Air flows through the impeller radially using blades that are forward curved.
///   CENTRIFUGALRADIAL: Air flows through the impeller radially using blades that are uncurved or slightl forward curved.
///   CENTRIFUGALBACKWARDINCLINEDCURVED: Air flows through the impeller radially using blades that are backward curved.
///   CENTRIFUGALAIRFOIL: Air flows through the impeller radially using blades are airfoil shaped.
///   TUBEAXIAL: Air flows through the impeller axially with reduced tip clearance and operating at higher tip speeds.
///   VANEAXIAL: Air flows through the impeller axially with guide vanes and reduced running blade tip clearance.
///   PROPELLORAXIAL: Air flows through the impeller axially and small hub-to-tip ratio impeller mounted in an orifice plate or inlet ring.
///   USERDEFINED:	User-defined fan type.
///   NOTDEFINED: Undefined fan type.
/// 
/// HISTORY: New enumeration in IFC 2x2.
typedef enum {IfcFanType_CENTRIFUGALFORWARDCURVED, IfcFanType_CENTRIFUGALRADIAL, IfcFanType_CENTRIFUGALBACKWARDINCLINEDCURVED, IfcFanType_CENTRIFUGALAIRFOIL, IfcFanType_TUBEAXIAL, IfcFanType_VANEAXIAL, IfcFanType_PROPELLORAXIAL, IfcFanType_USERDEFINED, IfcFanType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcFilterTypeEnum {
/// This enumeration defines the various types of filter typically used
///   within building services distribution systems:
/// 
/// AIRPARTICLEFILTER: A filter used to remove particulates from air.
///   COMPRESSEDAIRFILTER: A filter used to remove particulates from compressed air.
///   ODORFILTER: A filter used to remove odors from air.
///   OILFILTER: A filter used to remove particulates from oil.
///   STRAINER: A filter used to remove particulates from a fluid.
///   WATERFILTER: A filter used to remove particulates from water.
///   USERDEFINED:	User-defined filter type.
///   NOTDEFINED:	Undefined filter type.
/// 
/// HISTORY: New enumeration in IFC R2x.  COMPRESSEDAIRFILTER added in IFC2x4.
typedef enum {IfcFilterType_AIRPARTICLEFILTER, IfcFilterType_ODORFILTER, IfcFilterType_OILFILTER, IfcFilterType_STRAINER, IfcFilterType_WATERFILTER, IfcFilterType_USERDEFINED, IfcFilterType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcFireSuppressionTerminalTypeEnum {
/// The IfcFireSuppressionTerminalTypeEnum defines the range of different types of fire suppression terminal that can be specified. 
/// 
/// HISTORY: New type in IFC 2x2
/// 
/// Enumeration
/// 
/// BREECHINGINLET: Symmetrical pipe fitting that unites two or more inlets into a single pipe (BS6100 330 114 adapted). A breeching inlet may be used on either a wet or dry riser. Used by fire services personnel for fast connection of fire appliance hose reels. May also be used for foam. 
/// FIREHYDRANT: Device, fitted to a pipe, through which a temporary supply of water may be provided (BS6100 330 6107).  May also be termed a stand pipe. 
/// HOSEREEL: A supporting framework on which a hose may be wound (BS6100 155 8201). 
/// SPRINKLER: Device for sprinkling water from a pipe under pressure over an area (BS6100 100 3432). 
/// SPRINKLERDEFLECTOR: Device attached to a sprinkler to deflect the water flow into a spread pattern to cover the required area. 
/// USERDEFINED: User-defined type. 
/// NOTDEFINED: Underined type.
typedef enum {IfcFireSuppressionTerminalType_BREECHINGINLET, IfcFireSuppressionTerminalType_FIREHYDRANT, IfcFireSuppressionTerminalType_HOSEREEL, IfcFireSuppressionTerminalType_SPRINKLER, IfcFireSuppressionTerminalType_SPRINKLERDEFLECTOR, IfcFireSuppressionTerminalType_USERDEFINED, IfcFireSuppressionTerminalType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcFlowDirectionEnum {
/// This enumeration defines the flow direction at a port as either a SOURCE, SINK, or SOURCEANDSINK.  For solids, liquids, or gas, the direction is the physical flow direction.  For electric power (circuits containing hot, neutral, ground), the direction is from the origination of power (from a distribution board to protective devices to switches to fixtures).  For communication signals, the direction originates from where the signal is shaped, such as a sensor.  For communicaton networks, the direction originates from the up-level network host, such as a router (having SOURCE ports) hosting multiple computers (having SINK ports).
/// 
/// SOURCE:        A flow source, where a substance flows out of the connection.
///   SINK:          A flow sink, where a substance flows into the connection.
///   SOURCEANDSINK: Both a source and sink, where a substance flows both into and out of the connection simultaneously.
///   NOTDEFINED:    Undefined flow direction.
/// 
/// HISTORY: New enumeration in IFC R2.0
typedef enum {IfcFlowDirection_SOURCE, IfcFlowDirection_SINK, IfcFlowDirection_SOURCEANDSINK, IfcFlowDirection_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcFlowInstrumentTypeEnum {
/// The IfcFlowInstrumentTypeEnum defines the range of different types of flow instrument that can be specified. 
/// 
/// HISTORY: New type in IFC
///   2x2  
///   Enumeration 
/// 
/// PRESSUREGAUGE: A device that reads and displays a pressure value at a point or the pressure difference between two points. 
/// THERMOMETER: A device that reads and displays a temperature value at a point. 
/// AMMETER: A device that reads and displays the current flow in a circuit. 
/// FREQUENCYMETER: A device that reads and displays the electrical frequency of an alternating current circuit. 
/// PHASEANGLEMETER: A device that reads and displays the phase angle of a phase in a polyphase electrical circuit. 
/// POWERFACTORMETER: A device that reads and displays the power factor of an electrical circuit. 
/// VOLTMETER_PEAK: A device that reads and displays the peak voltage in an electrical circuit. 
/// VOLTMETER_RMS: A device that reads and displays the RMS (mean) voltage in an electrical circuit. 
/// USERDEFINED: User-defined type. 
/// NOTDEFINED: Undefined type.
typedef enum {IfcFlowInstrumentType_PRESSUREGAUGE, IfcFlowInstrumentType_THERMOMETER, IfcFlowInstrumentType_AMMETER, IfcFlowInstrumentType_FREQUENCYMETER, IfcFlowInstrumentType_POWERFACTORMETER, IfcFlowInstrumentType_PHASEANGLEMETER, IfcFlowInstrumentType_VOLTMETER_PEAK, IfcFlowInstrumentType_VOLTMETER_RMS, IfcFlowInstrumentType_USERDEFINED, IfcFlowInstrumentType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcFlowMeterTypeEnum {
/// This enumeration defines various types of flow meter:
/// 
/// ENERGYMETER:   An electric meter or energy meter is a device that measures the amount of electrical energy supplied to or produced by a residence, business or machine.
/// 
/// GASMETER:   A device that measures the quantity of a gas or fuel.
/// 
/// OILMETER:   A device that measures the quantity of oil.
/// 
/// WATERMETER:   A device that measures the quantity of water.
/// 
/// USERDEFINED:   User-defined meter type
/// 
/// NOTDEFINED:    Undefined meter type
/// 
/// HISTORY: New enumeration in IFC 2x2
typedef enum {IfcFlowMeterType_ELECTRICMETER, IfcFlowMeterType_ENERGYMETER, IfcFlowMeterType_FLOWMETER, IfcFlowMeterType_GASMETER, IfcFlowMeterType_OILMETER, IfcFlowMeterType_WATERMETER, IfcFlowMeterType_USERDEFINED, IfcFlowMeterType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcFootingTypeEnum {
/// Definition from IAI: Enumeration defining the generic footing type.
/// 
/// HISTORY New type in IFC Release 2x2
/// IFC 2x4 change:  Item CAISSON_FOUNDATION added
/// 
/// ENUMERATION 
/// 
/// CAISSON_FOUNDATION A foundation construction type used in underwater construction.
///   FOOTING_BEAM Footing elements that are in bending and are supported clear of the ground. They will normally span between piers, piles or pile caps. They are distinguished from beams in the building superstructure since they will normally require a lower grade of finish. They are distinguished from STRIP_FOOTING since they are clear of the ground surface and hence require support to the lower face while the concrete is curing.
///   PAD_FOOTING An element that transfers the load of a single column (possibly two) to the ground.
///   PILE_CAP An element that transfers the load from a column or group of columns to a pier or pile or group of piers or piles.
///   STRIP_FOOTING A linear element that transfers loads into the ground from either a continuous element, such as a wall, or from a series of elements, such as columns.
///   USERDEFINED Special types of footings which meet specific local requirements.
///   NOTDEFINED The type of footing is not defined.
typedef enum {IfcFootingType_FOOTING_BEAM, IfcFootingType_PAD_FOOTING, IfcFootingType_PILE_CAP, IfcFootingType_STRIP_FOOTING, IfcFootingType_USERDEFINED, IfcFootingType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcGasTerminalTypeEnum {

typedef enum {IfcGasTerminalType_GASAPPLIANCE, IfcGasTerminalType_GASBOOSTER, IfcGasTerminalType_GASBURNER, IfcGasTerminalType_USERDEFINED, IfcGasTerminalType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcGeometricProjectionEnum {
/// IfcGeometricProjectionEnum defines the various representation types that can be semantically distinguished. Often different levels of detail of the shape representation are controlled by the representation type.
/// 
/// GRAPH_VIEW:
/// Geometric display representation that shows an abstract, often 1D
/// element representation, e.g. representing a wall by its axis line.
///   SKETCH_VIEW:
/// Geometric display representation that shows an abstract, often 2D
/// element representation, e.g. representing a wall by its two foot print
/// edges, surpressing any inner layer representation.
///   MODEL_VIEW:
/// Geometric display representation that shows a full 3D element
/// representation, e.g. representing a wall by its volumetric body.
///   PLAN_VIEW:
/// Geometric display representation that shows a full 2D element
/// representation, the level of detail often depends on the target scale,
/// e.g. representing a wall by its two foot print edges and the edges of
/// all inner layers. The projection is shown in ground view as seen from
/// above.
///   REFLECTED_PLAN_VIEW:
/// Geometric display representation that shows a full 2D element
/// representation, the level of detail often depends on the target scale,
/// e.g. representing a wall by its two foot print edges and the edges of
/// all inner layers. The projection is shown in ground view as seen from
/// below.
///   SECTION_VIEW:
/// Geometric display representation that shows a full 2D element
/// representation, the level of detail often depends on the target scale,
/// e.g. representing a wall by its two inner/outer edges and the edges of
/// all inner layers, if the element is cut by the section line.
///   ELEVATION_VIEW:
/// Geometric display representation that shows a full 2D element
/// representation, the level of detail often depends on the target scale,
/// e.g. representing a wall by its bounding edges if the element is within
/// an elevation view.
///   USERDEFINED:
/// A user defined specification is given by the value of the UserDefinedTargetView
/// attribute.
///   NOTDEFINED:
/// No specification given.
/// 
/// HISTORY: New Type in Release IFC2x2.
typedef enum {IfcGeometricProjection_GRAPH_VIEW, IfcGeometricProjection_SKETCH_VIEW, IfcGeometricProjection_MODEL_VIEW, IfcGeometricProjection_PLAN_VIEW, IfcGeometricProjection_REFLECTED_PLAN_VIEW, IfcGeometricProjection_SECTION_VIEW, IfcGeometricProjection_ELEVATION_VIEW, IfcGeometricProjection_USERDEFINED, IfcGeometricProjection_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcGlobalOrLocalEnum {
/// This enumeration type defines if the local object coordinate system or the global world coordinate system for the project is used to describe the measure values of entities which have a reference to this type.
/// 
/// NOTE  The world coordinate system is given by the IfcGeometricRepresentationContext.WorldCoordinateSystem
/// and is unique within the project. The local (or object) coordinate system is given by IfcProduct.ObjectPlacement and is used by all IfcRepresentation's within the IfcProduct.Representation.
/// 
/// HISTORY: New type in IFC2x2.
typedef enum {IfcGlobalOrLocal_GLOBAL_COORDS, IfcGlobalOrLocal_LOCAL_COORDS} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcHeatExchangerTypeEnum {
/// Enumeration defining the typical types of heat exchangers. 
///   The IfcHeatExchangerTypeEnum contains the following:
/// 
/// PLATE: Plate heat exchanger.
///   SHELLANDTUBE: Shell and Tube heat exchanger.
///   USERDEFINED:  User-defined heat exchanger type.
///   NOTDEFINED:  Undefined heat exchanger type.
/// 
/// HISTORY: New enumeration in IFC R2x.
typedef enum {IfcHeatExchangerType_PLATE, IfcHeatExchangerType_SHELLANDTUBE, IfcHeatExchangerType_USERDEFINED, IfcHeatExchangerType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcHumidifierTypeEnum {
/// Enumeration defining the typical types of humidifiers. 
///   The IfcHumidifierTypeEnum contains the following:
/// 
/// STEAMINJECTION: Water vapor is added into the airstream through direction steam injection.
///   ADIABATICAIRWASHER: Water vapor is added into the airstream through adiabatic evaporation using an air washing element.
///   ADIABATICPAN:  Water vapor is added into the airstream through adiabatic evaporation using a pan.
///   ADIABATICWETTEDELEMENT: Water vapor is added into the airstream through adiabatic evaporation using a wetted element.
///   ADIABATICATOMIZING: Water vapor is added into the airstream through adiabatic evaporation using an atomizing element.
///   ADIABATICULTRASONIC: Water vapor is added into the airstream through adiabatic evaporation using an ultrasonic element.
///   ADIABATICRIGIDMEDIA: Water vapor is added into the airstream through adiabatic evaporation using a rigid media.
///   ADIABATICCOMPRESSEDAIRNOZZLE: Water vapor is added into the airstream through adiabatic evaporation using a compressed air nozzle.
///   ASSISTEDELECTRIC: Water vapor is added into the airstream through water heated evaporation using an electric heater.
///   ASSISTEDNATURALGAS: Water vapor is added into the airstream through water heated evaporation using a natural gas heater.
///   ASSISTEDPROPANE: Water vapor is added into the airstream through water heated evaporation using a propane heater.
///   ASSISTEDBUTANE: Water vapor is added into the airstream through water heated evaporation using a butane heater.
///   ASSISTEDSTEAM: Water vapor is added into the airstream through water heated evaporation using a steam heater.
///   USERDEFINED:  User-defined humidifier type.
///   NOTDEFINED:  Undefined humidifier type.
/// 
/// HISTORY: New enumeration in IFC 2x2.
typedef enum {IfcHumidifierType_STEAMINJECTION, IfcHumidifierType_ADIABATICAIRWASHER, IfcHumidifierType_ADIABATICPAN, IfcHumidifierType_ADIABATICWETTEDELEMENT, IfcHumidifierType_ADIABATICATOMIZING, IfcHumidifierType_ADIABATICULTRASONIC, IfcHumidifierType_ADIABATICRIGIDMEDIA, IfcHumidifierType_ADIABATICCOMPRESSEDAIRNOZZLE, IfcHumidifierType_ASSISTEDELECTRIC, IfcHumidifierType_ASSISTEDNATURALGAS, IfcHumidifierType_ASSISTEDPROPANE, IfcHumidifierType_ASSISTEDBUTANE, IfcHumidifierType_ASSISTEDSTEAM, IfcHumidifierType_USERDEFINED, IfcHumidifierType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcInternalOrExternalEnum {
/// Definition from IAI: This enumeration defines the
/// different types of space boundaries in terms of either being
/// inside the building or outside the building.
/// Enumeration:
/// 
/// INTERNAL
/// 
/// IfcSpaceBoundary
/// The space boundary faces a physical
/// or virtual element where there is an internal space on the other
/// side.
/// 
/// EXTERNAL
/// 
/// IfcSpaceBoundary
/// The space boundary faces a physical
/// or virtual element where there is an external space on the other
/// side (i.e. air). Or it is the space boundary of that external
/// space against the building.
/// 
/// EXTERNAL_EARTH
/// 
/// IfcSpaceBoundary
/// The space boundary faces a physical
/// or virtual element where there is earth (or terrain) on the other
/// side. Or it is the space boundary of that earth (or terrain
/// object) external space against the building.
/// 
/// EXTERNAL_WATER
/// 
/// IfcSpaceBoundary
/// The space boundary faces a physical
/// or virtual element where there is water (water component of
/// terrain) on the other side. Or it is the space boundary of that
/// object representing water external space against the
/// building.
/// 
/// EXTERNAL_FIRE
/// 
/// IfcSpaceBoundary
/// The space boundary faces a physical
/// or virtual element where there is another building on the other
/// side. Or it is the space boundary of that other neighbor building
/// against the building in question.
/// 
/// NOTDEFINED
/// 
/// No information available.
/// 
/// HISTORY: New enumeration
/// in IFC Release 2.0
/// IFC2x4 CHANGE: Enumeration no longer
/// applicable to IfcSpace. The following enumerators are
/// added: EXTERNAL_EARTH, EXTERNAL_WATER,
/// EXTERNAL_FIRE.
typedef enum {IfcInternalOrExternal_INTERNAL, IfcInternalOrExternal_EXTERNAL, IfcInternalOrExternal_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcInventoryTypeEnum {
/// IfcInventoryTypeEnum defines the types of inventory that can be defined. 
///   HISTORY: New Enumeration in IFC Release 2.0  
///   Enumeration: 
/// 
/// ASSETINVENTORY: A collection of asset instances of type IfcAsset 
/// SPACEINVENTORY: A collection of space instances of type IfcSpace 
/// FURNITUREINVENTORY: A collection of furniture instances of type IfcFurnishingElement 
/// USERDEFINED: User-defined type. 
/// NOTDEFINED: Undefined type.
typedef enum {IfcInventoryType_ASSETINVENTORY, IfcInventoryType_SPACEINVENTORY, IfcInventoryType_FURNITUREINVENTORY, IfcInventoryType_USERDEFINED, IfcInventoryType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcJunctionBoxTypeEnum {
/// The IfcJunctionBoxTypeEnum defines the range of types of junction boxes available.
///   HISTORY: New type in IFC 2x2.  Values added in IFC 2x4. 
/// 
/// POWER: Contains cables, outlets, and/or switches for electrical power.
/// DATA: Contains cables, outlets, and/or switches for communications use.
/// USERDEFINED: User-defined type.
/// NOTDEFINED: Undefined type.
typedef enum {IfcJunctionBoxType_USERDEFINED, IfcJunctionBoxType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcLampTypeEnum {
/// The IfcLampTypeEnum defines the range of different types of lamp available. 
/// 
/// HISTORY: New type in IFC 2x2 Addendum
///   1  
///   Enumeration 
/// 
/// COMPACTFLUORESCENT: A fluorescent lamp having a compact form factor produced by shaping the tube. 
/// FLUORESCENT: A typically tubular discharge lamp in which most of the light is emitted by one or several layers of phosphors excited by ultraviolet radiation from the discharge.
/// HALOGEN: an incandescent lamp in which a tungsten filament is sealed into a compact transport envelope filled with an inert gas and a small amount of halogen such as iodine or bromine.
/// HIGHPRESSUREMERCURY: A discharge lamp in which most of the light is emitted by exciting mercury at high pressure.
/// HIGHPRESSURESODIUM: A discharge lamp in which most of the light is emitted by exciting sodium at high pressure.
/// LED: a solid state lamp that uses light-emitting diodes as the source of light.
/// METALHALIDE: A discharge lamp in which most of the light is emitted by exciting a metal halide.
/// OLED: a solid state lamp that uses light-emitting diodes as the source of light whose emissive electroluminescent layer is composed of a film of organic compounds.
/// TUNGSTENFILAMENT: A lamp that emits light by passing an electrical current through a tungsten wire filament in a near vacuum.
/// USERDEFINED: User-defined type.
/// NOTDEFINED: Undefined type.
typedef enum {IfcLampType_COMPACTFLUORESCENT, IfcLampType_FLUORESCENT, IfcLampType_HIGHPRESSUREMERCURY, IfcLampType_HIGHPRESSURESODIUM, IfcLampType_METALHALIDE, IfcLampType_TUNGSTENFILAMENT, IfcLampType_USERDEFINED, IfcLampType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcLayerSetDirectionEnum {
/// IfcLayerSetDirectionEnum provides identification of the axis of element geometry, denoting the layer set thickness direction, or direction of layer offsets.
/// 
/// ENUMERATION
/// 
/// AXIS1: Usually x-axis.
/// AXIS2: Usually y-axis.
/// AXIS3: Usually z-axis.
/// 
/// HISTORY: New Type in IFC2x.
typedef enum {IfcLayerSetDirection_AXIS1, IfcLayerSetDirection_AXIS2, IfcLayerSetDirection_AXIS3} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcLightDistributionCurveEnum {
/// There are three kinds of light distribution curves, according to Standard CEN TC 169, prEN 13032-1, CIE 121: 
/// 
/// TYPE_A: Type A is basically not used. For completeness the Type A Photometry equals the Type B rotated 90° around the Z-Axis counter clockwise. 
/// TYPE_B: Type B is sometimes used for floodlights. The B-Plane System has a horizontal axis. B-Angles are valid from -180° to +180° with B 0° at the bottom and B180°/B-180° at the top, &#946;-Angles are valid from -90° to +90°. (See Figure 302.)
/// TYPE_C: Type C is the recommended standard system. The C-Plane system equals a globe with a vertical axis. C-Angles are valid from 0° to 360°, &#947;-Angles are valid from 0° (south pole) to 180° (north pole). (See Figure 302.) 
/// 
/// <table
/// 
/// B-Type System 
///   C-Type System 
/// 
/// Figure 302 — Light distribution curves
/// 
/// HISTORY  This is a new enumeration in IFC2x2.
typedef enum {IfcLightDistributionCurve_TYPE_A, IfcLightDistributionCurve_TYPE_B, IfcLightDistributionCurve_TYPE_C, IfcLightDistributionCurve_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcLightEmissionSourceEnum {
/// IfcLightEmissionSourceEnum defines the range of different types of light emitter available. 
/// 
/// HISTORY: New type in IFC2x2.
/// 
/// Enumeration 
/// 
/// COMPACTFLUORESCENT
/// FLUORESCENT
/// HIGHPRESSUREMERCURY
/// HIGHPRESSURESODIUM
/// LIGHTEMITTINGDIODE
/// LOWPRESSURESODIUM
/// LOWVOLTAGEHALOGEN
/// MAINVOLTAGEHALOGEN
/// METALHALIDE 
/// TUNGSTENFILAMENT 
/// NOTDEFINED
typedef enum {IfcLightEmissionSource_COMPACTFLUORESCENT, IfcLightEmissionSource_FLUORESCENT, IfcLightEmissionSource_HIGHPRESSUREMERCURY, IfcLightEmissionSource_HIGHPRESSURESODIUM, IfcLightEmissionSource_LIGHTEMITTINGDIODE, IfcLightEmissionSource_LOWPRESSURESODIUM, IfcLightEmissionSource_LOWVOLTAGEHALOGEN, IfcLightEmissionSource_MAINVOLTAGEHALOGEN, IfcLightEmissionSource_METALHALIDE, IfcLightEmissionSource_TUNGSTENFILAMENT, IfcLightEmissionSource_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcLightFixtureTypeEnum {
/// The IfcLightFixtureTypeEnum defines the range of different types of light fixture available.
/// 
/// HISTORY: New type in IFC 2x Edition 2IFC 2x4: SECURITYLIGHTING added
/// 
/// Enumeration
/// 
/// POINTSOURCE: A light fixture that is considered to have negligible area and that emit light with approximately equal intensity in all directions.  A light fixture containing a tungsten, halogen or similar bulb is an example of a point source.
/// DIRECTIONSOURCE: A light fixture that is considered to have a length or surface area from which it emits light in a direction. A light fixture containing one or more fluorescent lamps is an example of a direction source. 
/// SECURITYLIGHTING: A light fixture having specific purpose of directing occupants in an emergency, such as an illuminated exit sign or emergency flood light. 
/// USERDEFINED: User-defined type.
/// NOTDEFINED: Undefined type.
typedef enum {IfcLightFixtureType_POINTSOURCE, IfcLightFixtureType_DIRECTIONSOURCE, IfcLightFixtureType_USERDEFINED, IfcLightFixtureType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcLoadGroupTypeEnum {
/// Definition from IAI: This type definition is used to distinguish between different levels
/// of load grouping.  It allows to differentiate between load groups, load cases, and load combinations.
/// Normally, these enumeration types shall be used in the following context:
/// 
/// LOAD_GROUP groups instances of subtypes of IfcStructuralAction.  It shall be used as a
///   container for loads grouped together for specific purposes, e.g. loads which are part of a
///   special load pattern.
///   LOAD_CASE groups LOAD_GROUPs and instances of subtypes of IfcStructuralAction.
///   It should be used as a container for loads with the same origin.
///   LOAD_COMBINATION_GROUP is an intermediate level between LOAD_CASE and LOAD_COMBINATION.
///   The purpose of this level is to provide a factor with which one or more LOAD_CASEs occur in a
///   LOAD_COMBINATION.  This factor cannot be specified directly at the load case if the load case
///   is meant to occur in more than one combination with different factors.
///   This intermediate level is obsolete.  Instead, 
///   LOAD_COMBINATION is used to group load cases which act together into a load combination.
///   USERDEFINED:  A grouping level which does not follow the standard hierarchy of load group types.
///   NOTDEFINED:  The grouping level is not yet known.
/// 
/// HISTORY: New type in IFC 2x2.
/// 
/// IFC 2x4 change:  Obsolete item LOAD_COMBINATION_GROUP removed.  Load cases are directly assigned to load combinations with different factors for each load case—load combination pair by means of IfcRelAssignsToGroupByFactor.
typedef enum {IfcLoadGroupType_LOAD_GROUP, IfcLoadGroupType_LOAD_CASE, IfcLoadGroupType_LOAD_COMBINATION_GROUP, IfcLoadGroupType_LOAD_COMBINATION, IfcLoadGroupType_USERDEFINED, IfcLoadGroupType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcLogicalOperatorEnum {
/// Definition: IfcLogicalOperatorEnum is an enumeration that defines the logical operators that may be applied for the satisfaction of one or more operands (IfcConstraint) at a time. 
/// 
/// HISTORY  New type in IFC Release 2.0.  Renamed from IfcConstraintAggregatorEnum in IFC 2x2
/// 
/// IFC2x4 CHANGE: Extended to include LOGICALXOR, LOGICALNOTAND and LOGICALNOTOR.
/// 
/// Enumeration 
/// 
/// Value 
///   Definition 
/// 
/// LOGICALAND 
///   Defines a relationship between operands whereby the result is true if all operands are true, i.e. false if at least 
/// 
/// one operand is false. 
/// 
/// LOGICALOR 
///   Defines a relationship between operands whereby the result is true if at least one operand is true, i.e false if 
/// 
/// all operands are false. 
/// 
/// LOGICALXOR 
///   Defines a relationship between operands whereby the result is true if exactly one operand is true (exclusive or). 
/// 
/// LOGICALNOTAND 
///   Defines a relationship between operands whereby the result is true if at least one operand is false, i.e false if 
/// 
/// all operands are true. 
/// 
/// LOGICALNOTOR 
///   Defines a relationship between operands whereby the result is true if all operands are false, i.e false if at least 
/// 
/// one operand is true. 
/// 
/// Use Definition 
/// 
/// The IfcLogicalOperatorEnum, when applied in a case of three operands, A, B and C, evaluates for each operator as 
/// 
/// follows:
/// 
/// TRUTH TABLE: LOGICALAND(A,B,C)
/// 
/// A
/// F
/// F
/// F
/// T
/// F
/// T
/// T
/// T
/// 
/// B
/// F
/// F
/// T
/// F
/// T
/// F
/// T
/// T
/// 
/// C
/// F
/// T
/// F
/// F
/// T
/// T
/// F
/// T
/// 
/// AND
/// F
/// F
/// F
/// F
/// F
/// F
/// F
/// T
/// 
/// TRUTH TABLE: LOGICALOR(A,B,C)
/// 
/// A
/// F
/// F
/// F
/// T
/// F
/// T
/// T
/// T
/// 
/// B
/// F
/// F
/// T
/// F
/// T
/// F
/// T
/// T
/// 
/// C
/// F
/// T
/// F
/// F
/// T
/// T
/// F
/// T
/// 
/// OR
/// F
/// T
/// T
/// T
/// T
/// T
/// T
/// T
/// 
/// TRUTH TABLE: LOGICALXOR(A,B,C)
/// 
/// A
/// F
/// F
/// F
/// T
/// F
/// T
/// T
/// T
/// 
/// B
/// F
/// F
/// T
/// F
/// T
/// F
/// T
/// T
/// 
/// C
/// F
/// T
/// F
/// F
/// T
/// T
/// F
/// T
/// 
/// XOR
/// F
/// T
/// T
/// T
/// F
/// F
/// F
/// F
/// 
/// TRUTH TABLE: LOGICALNOTAND(A,B,C)
/// 
/// A
/// F
/// F
/// F
/// T
/// F
/// T
/// T
/// T
/// 
/// B
/// F
/// F
/// T
/// F
/// T
/// F
/// T
/// T
/// 
/// C
/// F
/// T
/// F
/// F
/// T
/// T
/// F
/// T
/// 
/// NOTAND
/// T
/// T
/// T
/// T
/// T
/// T
/// T
/// F
/// 
/// TRUTH TABLE: LOGICALNOTOR(A,B,C)
/// 
/// A
/// F
/// F
/// F
/// T
/// F
/// T
/// T
/// T
/// 
/// B
/// F
/// F
/// T
/// F
/// T
/// F
/// T
/// T
/// 
/// C
/// F
/// T
/// F
/// F
/// T
/// T
/// F
/// T
/// 
/// NOTOR
/// T
/// F
/// F
/// F
/// F
/// F
/// F
/// F
typedef enum {IfcLogicalOperator_LOGICALAND, IfcLogicalOperator_LOGICALOR} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcMemberTypeEnum {
/// Definition from IAI: This enumeration defines the
/// different types of linear elements an IfcMemberType object
/// can fulfill:
/// 
/// BRACE: A linear element (usually sloped) often used
/// for bracing of a girder or truss.
/// CHORD: Upper or lower longitudinal member of a truss,
/// used horizontally or sloped.
/// COLLAR: A linear element (usually used horizontally)
/// within a roof structure to connect rafters and posts.
/// MEMBER: A linear element within a girder or truss with
/// no further meaning.
/// MULLION: A linear element within a curtain wall system
/// to connect two (or more) panels.
/// PLATE: A linear continuous horizontal element in wall
/// framing, e.g. a head piece or a sole plate.
/// 
/// NOTE  This head piece or sole plate shall not
/// be mixed up with planar elements, such as sheets and panels, that
/// are handled as IfcPlate (and
/// IfcPlateType).
/// 
/// POST: A linear member (usually used vertically) within
/// a roof structure to support purlins.
/// PURLIN: A linear element (usually used horizontally)
/// within a roof structure to support rafters
/// RAFTER: A linear elements used to support roof slabs
/// or roof covering, usually used with slope.
/// STRINGER: A linear element used to support stair or
/// ramp flights, usually used with slope.
/// STRUT: A linear element often used within a girder or
/// truss.
/// STUD: Vertical element in wall framing.
/// USERDEFINED: User-defined linear element.
/// NOTDEFINED: Undefined linear element
/// 
/// HISTORY: New
/// Enumeration in Release IFC2x Edition 2.
/// IFC2x Edition 2
/// Addendum 1 CHANGE  The additional identifiers CHORD, PLATE, STUD
/// are added.
/// IFC2x Edition 3 CHANGE  The additional identifier MULLION has
/// been added.
typedef enum {IfcMemberType_BRACE, IfcMemberType_CHORD, IfcMemberType_COLLAR, IfcMemberType_MEMBER, IfcMemberType_MULLION, IfcMemberType_PLATE, IfcMemberType_POST, IfcMemberType_PURLIN, IfcMemberType_RAFTER, IfcMemberType_STRINGER, IfcMemberType_STRUT, IfcMemberType_STUD, IfcMemberType_USERDEFINED, IfcMemberType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcMotorConnectionTypeEnum {
/// The IfcMotorConnectionTypeEnum defines the range of different types of motor connection that can be specified. 
///   HISTORY: New type in IFC 2x.  
///   Enumeration 
/// 
/// BELTDRIVE: An indirect connection made through the medium of a shaped, flexible continuous loop. 
/// COUPLING: An indirect connection made through the medium of the viscosity of a fluid. 
/// DIRECTDRIVE: A direct, physical connection made between the motor and the driven device. 
/// USERDEFINED: User-defined type. 
/// NOTDEFINED: Undefined type.
typedef enum {IfcMotorConnectionType_BELTDRIVE, IfcMotorConnectionType_COUPLING, IfcMotorConnectionType_DIRECTDRIVE, IfcMotorConnectionType_USERDEFINED, IfcMotorConnectionType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcNullStyle {
/// Definition from ISO/CD 10303-46:1992: The null style type specifies, that a representation item is not styled.
/// 
/// NOTE  Corresponding ISO 10303 name: null_style. Please refer to ISO/IS 10303-46:1994 for the final
/// definition of the formal standard.
/// 
/// HISTORY  New enumeration in IFC2x2.
/// 
/// IFC2x4 CHANGE  The enumeration is deprecated.
typedef enum {IfcNullStyle_NULL} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcObjectTypeEnum {
/// This enumeration defines the applicable object categories, that is, the subtypes at the 2nd level of the IFC inheritance tree. Attached to an object, it indicates to which subtype of IfcObject the entity referencing it would otherwise comply with. 
/// 
/// HISTORY New entity in IFC Release 1.0, has been renamed from IfcProxyEnum in IFC 2x.
typedef enum {IfcObjectType_PRODUCT, IfcObjectType_PROCESS, IfcObjectType_CONTROL, IfcObjectType_RESOURCE, IfcObjectType_ACTOR, IfcObjectType_GROUP, IfcObjectType_PROJECT, IfcObjectType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcObjectiveEnum {
/// IfcObjectiveEnum is an enumeration used to determine the objective for which purpose the constraint needs to be satisfied. 
/// 
/// HISTORY: IFC2x4 CHANGE: Extended to include CODEWAIVER.
/// 
/// Enumeration 
/// 
/// Value 
///   Definition 
/// 
/// CODECOMPLIANCE 
///   A constraint whose objective is to ensure satisfaction of a code compliance provision. 
/// 
/// CODEWAIVER 
///   A constraint whose objective is to identify an agreement that code compliance requirements (the waiver) will not be enforced. 
/// 
/// DESIGNINTENT 
///   A constraint whose objective is to ensure satisfaction of a design intent provision. 
/// 
/// HEALTHANDSAFETY 
///   A constraint whose objective is to ensure satisfaction of a health and safety provision. 
/// 
/// REQUIREMENT 
///   A constraint whose objective is to ensure satisfaction of a project requirement provision. 
/// 
/// SPECIFICATION 
///   A constraint whose objective is to ensure satisfaction of a specification provision. 
/// 
/// TRIGGERCONDITION 
///   A constraint whose objective is to indicate a limiting value beyond which the condition of an object requires a particular form of attention.
typedef enum {IfcObjective_CODECOMPLIANCE, IfcObjective_DESIGNINTENT, IfcObjective_HEALTHANDSAFETY, IfcObjective_REQUIREMENT, IfcObjective_SPECIFICATION, IfcObjective_TRIGGERCONDITION, IfcObjective_USERDEFINED, IfcObjective_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcOccupantTypeEnum {
/// IfcOccupantTypeEnum defines the types of occupant from which the type required can be selected. 
///   HISTORY: New Enumeration in IFC Release 2.0 Modified in IFC 2x2 
///   Enumeration: 
/// 
/// ASSIGNEE: Actor receiving the assignment of a property agreement from an assignor  
/// ASSIGNOR: Actor assigning a property agreement to an assignor  
/// LESSEE: Actor receiving the lease of a property from a lessor  
/// LESSOR: Actor leasing a property to a lessee  
/// LETTINGAGENT: Actor participating in a property agreement on behalf of an owner, lessor or assignor  
/// OWNER: Actor that owns a property  
/// TENANT: Actor renting the use of a property fro a period of time  
/// USERDEFINED: User-defined type.  
/// NOTDEFINED: Undefined type.
typedef enum {IfcOccupantType_ASSIGNEE, IfcOccupantType_ASSIGNOR, IfcOccupantType_LESSEE, IfcOccupantType_LESSOR, IfcOccupantType_LETTINGAGENT, IfcOccupantType_OWNER, IfcOccupantType_TENANT, IfcOccupantType_USERDEFINED, IfcOccupantType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcOutletTypeEnum {
/// The IfcOutletTypeEnum defines the range of different types of outlet that can be specified. 
/// 
/// HISTORY: New type in IFC 2x. Telephone and Data outlets added in IFC 2x4
/// 
/// Enumeration 
/// 
/// AUDIOVISUALOUTLET: An outlet used for an audio or visual device. 
/// COMMUNICATIONSOUTLET: An outlet used for connecting communications equipment. 
/// POWEROUTLET: An outlet used for connecting electrical devices requiring power.  
/// DATAOUTLET: An outlet used for connecting data communications equipment. 
/// TELEPHONEOUTLET: An outlet used for connecting telephone communications equipment.  
/// USERDEFINED: User-defined type. 
/// NOTDEFINED: Undefined type.
typedef enum {IfcOutletType_AUDIOVISUALOUTLET, IfcOutletType_COMMUNICATIONSOUTLET, IfcOutletType_POWEROUTLET, IfcOutletType_USERDEFINED, IfcOutletType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcPermeableCoveringOperationEnum {
/// Definition: Enumeration defining the valid types of permeable coverings. 
/// 
/// Enumeration:
/// 
/// GRILL 
///   protective screen of metal bars or wires
/// 
/// LOUVER 
///   set of fixed or movable strips of wood, metal, etc. arranged to let
///   air in while keeping light or rain out
/// 
/// SCREEN 
///   upright, fixed or movable, sometimes folding framework used for
///   protection against heat, light, access or similar
/// 
/// USERDEFINED 
///   user defined permeable covering type
/// 
/// NOTDEFINED 
///   no information available
/// 
/// HISTORY: New Enumeration in IFC Release 2.0
typedef enum {IfcPermeableCoveringOperation_GRILL, IfcPermeableCoveringOperation_LOUVER, IfcPermeableCoveringOperation_SCREEN, IfcPermeableCoveringOperation_USERDEFINED, IfcPermeableCoveringOperation_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcPhysicalOrVirtualEnum {
/// Definition from IAI: This enumeration defines the
///   different types of space boundaries in terms of its
///   physical manifestation. A space boundary can either be
///   physically dividing or can be a virtual divider.
/// 
/// Enumeration:
/// 
/// PHYSICAL
/// 
/// The space boundary is provided physically, i.e. by an
///   physical element.
/// 
/// VIRTUAL
/// 
/// The space boundary is provided virtually, i.e. by a
///   logical divider that has no physical manifestation.
/// 
/// NOTDEFINED
/// 
/// No information available.
/// 
/// HISTORY: New enumeration in
///   IFC Release 2.0
typedef enum {IfcPhysicalOrVirtual_PHYSICAL, IfcPhysicalOrVirtual_VIRTUAL, IfcPhysicalOrVirtual_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcPileConstructionEnum {
/// Definition from IAI: Enumeration defining the construction type
///   for piles. The type is mainly based on how the piles are used and manufactured.
///   Some material information is mixed in because this affects the way the piles
///   are used.  
/// 
/// HISTORY New type in IFC Release 2x2
/// 
/// ENUMERATION 
/// 
/// CAST_IN_PLACE Piles and piers that are excavated and poured in
///   place. 
///   COMPOSITE Piles that are a mix of components, such as a steel
///   outer casing which is driven into the ground with a cast-in-place concrete
///   core. 
///   PRECAST_CONCRETE Piles that are entirely of precast concrete
///   (possibly with some steel or other fixtures). 
///   PREFAB_STEEL Prefabricated piles made entirely out of steel.
///   It will also include steel sheet piles where these are not part of another
///   construction element. 
///   USERDEFINED Special types of pile construction which meet
///   specific local requirements. 
///   NOTDEFINED The type of pile construction is not defined.
typedef enum {IfcPileConstruction_CAST_IN_PLACE, IfcPileConstruction_COMPOSITE, IfcPileConstruction_PRECAST_CONCRETE, IfcPileConstruction_PREFAB_STEEL, IfcPileConstruction_USERDEFINED, IfcPileConstruction_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcPileTypeEnum {
/// Definition from IAI: Enumeration defining the pile type. 
/// 
/// HISTORY New type in IFC Release 2x2
/// IFC 2x4 change:  Items BORED, DRIVEN, JETGROUTING added
/// 
/// BORED A bore pile.
///   DRIVEN A rammed, vibrated, or otherwise driven pile.
///   JETGROUTING An injected pile-like construction.
///   COHESION A cohesion pile.
///   FRICTION A friction pile.
///   SUPPORT A support pile.
///   USERDEFINED The type of pile function is user defined.
///   NOTDEFINED The type of pile function is not defined.
typedef enum {IfcPileType_COHESION, IfcPileType_FRICTION, IfcPileType_SUPPORT, IfcPileType_USERDEFINED, IfcPileType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcPipeFittingTypeEnum {
/// This enumeration is used to identify the primary purpose of a pipe fitting. This is a very basic categorization mechanism
///   to generically identify the pipe fitting type. Subcategories
///   of pipe fittings are not enumerated. 
///   The IfcpipeFittingTypeEnum contains the following:
/// 
/// BEND:		A fitting with typically two ports used to change 
///   the direction of flow between connected elements.
///   CONNECTOR:   Connector fitting, typically used to join two
///   ports together within a flow distribution system 
///   (e.g., a coupling used to join two pipe segments).
///   ENTRY:       Entry fitting, typically unconnected at one port
///   and connected to a flow distribution system at 
///   the other (e.g., a breeching inlet).
///   EXIT:        Exit fitting, typically unconnected at one port
///   and connected to a flow distribution system at 
///   the other (e.g., a hose bibb).
///   JUNCTION:	A fitting with typically more than two ports used
///   to redistribute flow among the ports and/or to
///   change the direction of flow between connected
///   elements (e.g, tee, cross, wye, etc.).
///   OBSTRUCTION: A fitting with typically two ports used to 
///   obstruct or restrict flow between the connected
///   elements (e.g., screen, perforated plate, etc.).
///   TRANSITION:	A fitting with typically two ports having
///   different shapes or sizes. Can also be used to
///   change the direction of flow between connected
///   elements.
///   USERDEFINED: User-defined fitting.
///   NOTDEFINED:  Undefined fitting.
/// 
/// HISTORY: New enumeration in IFC 2x2
typedef enum {IfcPipeFittingType_BEND, IfcPipeFittingType_CONNECTOR, IfcPipeFittingType_ENTRY, IfcPipeFittingType_EXIT, IfcPipeFittingType_JUNCTION, IfcPipeFittingType_OBSTRUCTION, IfcPipeFittingType_TRANSITION, IfcPipeFittingType_USERDEFINED, IfcPipeFittingType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcPipeSegmentTypeEnum {
/// This enumeration is used to identify the primary purpose of a
///   pipe segment. This is a very basic categorization mechanism
///   to generically identify the pipe segment type. Subcategories
///   of pipe segments are not enumerated. 
///   The IfcPipeSegmentTypeEnum contains the following:
/// 
/// CULVERT: A covered channel or large pipe that forms a watercourse below ground level, usually under a road or railway.
///   RIGIDSEGMENT: A rigid segment is continuous linear segment of pipe that cannot be deformed.
///   FLEXIBLESEGMENT:  A flexible segment is a continuous non-linear segment of pipe that can be deformed and change the direction of flow.
///   GUTTER: A gutter segment is a continuous open-channel segment of pipe.
///   SPOOL: A type of rigid segment that is typically shorter and used for providing connectivity within a piping network.
///   USERDEFINED: User-defined segment.
///   NOTDEFINED:  Undefined segment.
/// 
/// HISTORY: New enumeration in IFC 2x2
typedef enum {IfcPipeSegmentType_FLEXIBLESEGMENT, IfcPipeSegmentType_RIGIDSEGMENT, IfcPipeSegmentType_GUTTER, IfcPipeSegmentType_SPOOL, IfcPipeSegmentType_USERDEFINED, IfcPipeSegmentType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcPlateTypeEnum {
/// Definition from IAI: This enumeration
/// defines the different types of planar elements an IfcPlateType
/// object can fulfill:
/// 
/// CURTAIN_PANEL: A planar element within a
/// curtain wall, often consisting of a frame with fixed glazing.
///   SHEET: A planar, flat and thin element,
/// comes usually as metal sheet, and is often used as an additonal part
/// within an assembly.
///   USERDEFINED: User-defined linear element.
///   NOTDEFINED: Undefined linear element
/// 
/// HISTORY  New Enumeration in Release IFC2x Edition 2. 
/// IFC2x
/// Edition 3
/// CHANGE  The additional identifiers CURTAIN_PANEL, SHEET have
/// been
/// added.
typedef enum {IfcPlateType_CURTAIN_PANEL, IfcPlateType_SHEET, IfcPlateType_USERDEFINED, IfcPlateType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcProcedureTypeEnum {
/// The IfcProcedureTypeEnum defines the range of different types of procedure that can be specified.
/// 
/// HISTORY: New type in IFC2x2
/// 
/// Enumeration:
/// 
/// ADVICE_CAUTION: A caution that should be taken note of as a procedure or when carrying out a procedure
/// ADVICE_NOTE: Additional information or advice that should be taken note of as a procedure or when carrying out a procedure
/// ADVICE_WARNING: A warning of potential danger that should be taken note of as a procedure or when carrying out a procedure
/// CALIBRATION: A procedure undertaken to calibrate an artifact
/// SHUTDOWN: A procedure undertaken to shutdown the operation an artifact
/// STARTUP: A procedure undertaken to start up the operation an artifact
/// USERDEFINED
/// NOTDEFINED
typedef enum {IfcProcedureType_ADVICE_CAUTION, IfcProcedureType_ADVICE_NOTE, IfcProcedureType_ADVICE_WARNING, IfcProcedureType_CALIBRATION, IfcProcedureType_DIAGNOSTIC, IfcProcedureType_SHUTDOWN, IfcProcedureType_STARTUP, IfcProcedureType_USERDEFINED, IfcProcedureType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcProfileTypeEnum {
/// The enumeration defines whether the definition of a profile shape shall be geometrically resolved into a curve or into a surface.
/// 
/// HISTORY: New type in IFC 1.5.
/// 
/// Enumeration values:
/// 
/// CURVE: The resulting geometric item is of type curve and closed (with the only exception of the curve created by the IfcArbitraryOpenProfileDef which resolves into an open curve). The resulting geometry after applying a sweeping operation is a swept surface. This can be used to define shapes with thin sheets, such as ducts, where the thickness is not appropriate for geometric representation.
/// AREA: The resulting geometric item is of type surface. The resulting geometry after applying a sweeping operation is a swept solid with defined volume.
typedef enum {IfcProfileType_CURVE, IfcProfileType_AREA} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcProjectOrderRecordTypeEnum {

typedef enum {IfcProjectOrderRecordType_CHANGE, IfcProjectOrderRecordType_MAINTENANCE, IfcProjectOrderRecordType_MOVE, IfcProjectOrderRecordType_PURCHASE, IfcProjectOrderRecordType_WORK, IfcProjectOrderRecordType_USERDEFINED, IfcProjectOrderRecordType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcProjectOrderTypeEnum {
/// An IfcProjectOrderTypeEnum is a list of the types of project order that may be identified. 
///   HISTORY: New type in IFC 2x2  
///   Enumeration 
/// 
/// CHANGEORDER: An instruction to make a change to a product or work being undertaken and a description of the work that is to be performed. 
/// MAINTENANCEWORKORDER: An instruction to carry out maintenance work and a description of the work that is to be performed. 
/// MOVEORDER: An instruction to move persons and artefacts and a description of the move locations, objects to be moved, etc.  
/// PURCHASEORDER: An instruction to purchase goods and/or services and a description of the goods and/or services to be purchased that is to be performed. 
/// WORKORDER: A general instruction to carry out work and a description of the work to be done. Note the difference between a work order generally and a maintenance work order. 
/// USERDEFINED: User-defined type. 
/// NOTDEFINED: Undefined type.
typedef enum {IfcProjectOrderType_CHANGEORDER, IfcProjectOrderType_MAINTENANCEWORKORDER, IfcProjectOrderType_MOVEORDER, IfcProjectOrderType_PURCHASEORDER, IfcProjectOrderType_WORKORDER, IfcProjectOrderType_USERDEFINED, IfcProjectOrderType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcProjectedOrTrueLengthEnum {
/// This enumeration type is needed for load definition and is only considered if the load values are given as global actions and if they define linear or planar loads (that is, one- or two-dimensionally distributed loads).
/// Figure 234 illustrates the interpretation of a load definition depending on the enumeration types IfcGlobalOrLocalEnum and IfcProjectedOrTrueLengthEnum.
/// 
/// HISTORY  New type in IFC2x2. 
/// 
/// Figure 234 — Projected or true length
typedef enum {IfcProjectedOrTrueLength_PROJECTED_LENGTH, IfcProjectedOrTrueLength_TRUE_LENGTH} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcPropertySourceEnum {

typedef enum {IfcPropertySource_DESIGN, IfcPropertySource_DESIGNMAXIMUM, IfcPropertySource_DESIGNMINIMUM, IfcPropertySource_SIMULATED, IfcPropertySource_ASBUILT, IfcPropertySource_COMMISSIONING, IfcPropertySource_MEASURED, IfcPropertySource_USERDEFINED, IfcPropertySource_NOTKNOWN} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcProtectiveDeviceTypeEnum {
/// The IfcProtectiveDeviceTypeEnum specifically defines the range of different breaker unit types that can be used in conjunction with protective device. Types may also be used as a reference to a complete protective device in circumstances where tripping units are not separately identified (typically expected to be the case during earlier stages of design). 
/// 
/// HISTORY: New type in IFC 2x2. Modified definition and usage in IFC 2x4 
/// 
/// Enumeration
/// 
/// FUSEDISCONNECTOR: A device that will electrically open the circuit after a period of prolonged, abnormal current flow.
/// CIRCUITBREAKER: A mechanical switching device capable of making, carrying, and breaking currents under normal circuit conditions and also making, carrying for a specified time and breaking, current under specified abnormal circuit conditions such as those of short circuit.
/// EARTHINGSWITCH: A safety device used to open or close a circuit when there is no current. Used to isolate a part of a circuit, a machine, a part of an overhead line or an underground line so that maintenance can be safely conducted.
/// EARTHLEAKAGECIRCUITBREAKER: A device that opens, closes, or isolates a circuit and has short circuit protection but no overload protection.  It attempts to break the circuit when there is a leakage of current from phase to earth, by measuring voltage on the earth conductor.
/// RESIDUALCURRENTCIRCUITBREAKER: A device that opens, closes, or isolates a circuit and has short circuit and overload protection.  It attempts to break the circuit when there is a difference in current between any two phases.  May also be referred to as 'Ground Fault Interupter (GFI)' or 'Ground Fault Circuit Interuptor (GFCI)'
/// RESIDUALCURRENTSWITCH: A device that opens, closes or isolates a circuit and has no short circuit or overload protection.  May also be identified as a 'ground fault switch'.
/// VARISTOR: A high voltage surge protection device.
/// USERDEFINED: User-defined type.
/// NOTDEFINED: Undefined type.
typedef enum {IfcProtectiveDeviceType_FUSEDISCONNECTOR, IfcProtectiveDeviceType_CIRCUITBREAKER, IfcProtectiveDeviceType_EARTHFAILUREDEVICE, IfcProtectiveDeviceType_RESIDUALCURRENTCIRCUITBREAKER, IfcProtectiveDeviceType_RESIDUALCURRENTSWITCH, IfcProtectiveDeviceType_VARISTOR, IfcProtectiveDeviceType_USERDEFINED, IfcProtectiveDeviceType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcPumpTypeEnum {
/// Defines general types of pumps.
/// 
/// The IfcPumpTypeEnum contains the following:
/// 
/// CIRCULATOR: A Circulator pump is a generic low-pressure, low-capacity pump. It may have a wet rotor and
///   may be driven by a flexible-coupled motor.
/// 
/// ENDSUCTION: An End Suction pump, when mounted horizontally, has a single horizontal inlet on the impeller suction side
///   and a vertical discharge. It may have a direct or close-coupled motor.
/// 
/// SPLITCASE: A Split Case pump, when mounted horizontally, has an inlet and outlet on each side of the impeller.
///   The impeller can be easily accessed by removing the front of the impeller casing. It may have a direct or close-coupled motor.
/// 
/// SUBMERSIBLEPUMP: A pump designed to be immersed in a fluid, typically a collection tank.
/// 
/// SUMPPUMP: A pump designed to sit above a collection tank with a suction inlet extending into the tank.
/// 
/// VERTICALINLINE: A Vertical Inline pump has the pump and motor close-coupled on the pump casing.
///   The pump depends on the connected, horizontal piping for support, with the suction and discharge along the piping axis.
/// 
/// VERTICALTURBINE: A Vertical Turbine pump has a motor mounted vertically on the pump casing for either
///   wet-pit sump mounting or dry-well mounting.
/// 
/// USERDEFINED: User-defined pump type.
/// 
/// NOTDEFINED:  Pump type has not been defined.
/// 
/// HISTORY: New enumeration in IFC R2x.  SUBMERSIBLEPUMP and SUMPPUMP added in IFC2x4.
typedef enum {IfcPumpType_CIRCULATOR, IfcPumpType_ENDSUCTION, IfcPumpType_SPLITCASE, IfcPumpType_VERTICALINLINE, IfcPumpType_VERTICALTURBINE, IfcPumpType_USERDEFINED, IfcPumpType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcRailingTypeEnum {
/// Definition from IAI: Enumeration defining the valid types of
///   railings that can be predefined using the enumeration values.  
///   HISTORY: New Enumeration in IFC
///   Release 2.0  
///   Enumeration 
/// 
/// HANDRAIL: A type of railing designed to serve as an optional
///   structural support for loads applied by human occupants (at hand height).
///   Generally located adjacent to ramps and stairs. Generally floor or wall
///   mounted. 
///   GUARDRAIL: A type of railing designed to guard human occupants
///   from falling off a stair, ramp or landing where there is a vertical drop at the
///   edge of such floors/landings. 
///   BALUSTRADE: Similar to the definitions of a guardrail except
///   the location is at the edge of a floor, rather then a stair or ramp. Examples
///   are balustrates at roof-tops or balconies. 
///   USERDEFINED: User-defined railing element, a term to identify
///   the user type is given by the attribute IfcRailing.ObjectType. 
///   NOTDEFINED: Undefined railing element, no type information
///   available.
typedef enum {IfcRailingType_HANDRAIL, IfcRailingType_GUARDRAIL, IfcRailingType_BALUSTRADE, IfcRailingType_USERDEFINED, IfcRailingType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcRampFlightTypeEnum {
/// Definition from IAI: This enumeration defines the different types
///   of linear elements an IfcRampFlightType object can fulfill: 
/// 
/// STRAIGHT: A ramp flight with a straight walking line.  
///   SPIRAL: A ramp flight with a circular or elliptic walking
///   line. 
///   USERDEFINED: User-defined ramp flight. 
///   NOTDEFINED: Undefined ramp flight. 
/// 
/// HISTORY: New Enumeration in
///   Release IFC2x Edition 2.
typedef enum {IfcRampFlightType_STRAIGHT, IfcRampFlightType_SPIRAL, IfcRampFlightType_USERDEFINED, IfcRampFlightType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcRampTypeEnum {
/// This enumeration defines the basic configuration of the ramp type in terms of the number and shape of ramp flights, as shown in Figure 67. The type also distinguished turns by landings. In addition the subdivision of the straight and changing direction ramps is included. The ramp configurations are given for ramps without and with one and two landings. 
/// 
/// Ramps which are subdivided into more than two landings have to be defined by the geometry only. Also ramps with non-regular shapes have to be defined by the geometry only. The type of such ramps is USERDEFINED. 
/// 
/// HISTORY New Enumeration in IFC Release 2.0. 
/// 
/// Enumerator 
///   Description 
///   Figure 
/// 
/// StraightRunRamp 
///   A ramp - which is a sloping
///   floor, walk, or roadway - connecting two levels. The straight ramp consists of
///   one straight flight without turns or winders.  
/// 
/// TwoStraightRunRamp 
///   A straight ramp consisting of
///   two straight flights without turns but with one landing. 
/// 
/// QuarterTurnRamp 
///   A ramp making a 90° turn,
///   consisting of two straight flights connected by a quarterspace landing. The
///   direction of the turn is determined by the walking line. 
/// 
/// TwoQuarterTurnRamp 
///   A ramp making a 180°
///   turn, consisting of three straight flights connected by two quarterspace
///   landings. The direction of the turn is determined by the walking line. 
/// 
/// HalfTurnRamp 
///   A ramp making a 180°
///   turn, consisting of two straight flights connected by a halfspace landing. The
///   orientation of the turn is determined by the walking line. 
/// 
/// SpiralRamp 
///   A ramp constructed around a
///   circular or elliptical well without newels and landings. 
/// 
/// UserDefined 
///   Free form ramp (user defined
///   operation type) 
///     
/// 
/// NotDefined 
///     
///     
/// 
/// Figure 67 — Ramp types
typedef enum {IfcRampType_STRAIGHT_RUN_RAMP, IfcRampType_TWO_STRAIGHT_RUN_RAMP, IfcRampType_QUARTER_TURN_RAMP, IfcRampType_TWO_QUARTER_TURN_RAMP, IfcRampType_HALF_TURN_RAMP, IfcRampType_SPIRAL_RAMP, IfcRampType_USERDEFINED, IfcRampType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcReflectanceMethodEnum {
/// The IfcReflectanceMethodEnum defines the range of different reflectance methods available. 
/// 
/// HISTORY: New type in IFC 2x2.
/// 
/// Enumeration 
/// 
/// BLINN: A reflectance model providing a smooth, slightly shiny appearance.
/// FLAT: A reflectance model providing a constant colour. This model ignores the effect of all light sources. 
/// GLASS: A reflectance model that supports an approximation of glass-like materials that have both reflective and transmissive properties. 
/// MATT: A reflectance model providing a dull matte appearance. 
/// METAL: A reflectance model providing a specular metallic appearance. 
/// MIRROR: A reflectance model that supports secondary mirrored views through ray tracing. 
/// PHONG: A reflectance model conforming with the Phong model in which reflections are greatest in the `mirror' direction of a surface opposite the viewing direction with respect to the surface normal. 
/// PLASTIC: A reflectance model providing a specular effect which is similar to the Phong model. 
/// STRAUSS: A reflectance model for metallic and non-metallic appearance based on a limited set of control parameter.
/// NOTDEFINED
typedef enum {IfcReflectanceMethod_BLINN, IfcReflectanceMethod_FLAT, IfcReflectanceMethod_GLASS, IfcReflectanceMethod_MATT, IfcReflectanceMethod_METAL, IfcReflectanceMethod_MIRROR, IfcReflectanceMethod_PHONG, IfcReflectanceMethod_PLASTIC, IfcReflectanceMethod_STRAUSS, IfcReflectanceMethod_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcReinforcingBarRoleEnum {
/// Definition from IAI: Enumeration defining standard types for the
///   role, purpose or usage of the bar, i.e. the kind of loads and stresses they are
///   intended to carry.  
/// 
/// HISTORY New type in IFC Release 2x2.
///   Item ANCHORING (documented since IFC 2x2) added to the EXPRESS definition in IFC 2x4.
/// 
/// ENUMERATION 
/// 
/// MAIN The reinforcing bar is a main bar. 
///   SHEAR The reinforcing bar is a shear bar. 
///   LIGATURE The reinforcing bar is a ligature (link, stirrup). 
///   STUD The reinforcing bar is a stud. 
///   PUNCHING Punching reinforcement. 
///   EDGE Edge reinforcement. 
///   RING Ring reinforcement. 
///   ANCHORING Anchoring reinforcement. 
///   USERDEFINED The type of reinforcement is user defined. 
///   NOTDEFINED The type of reinforcement is not defined.
typedef enum {IfcReinforcingBarRole_MAIN, IfcReinforcingBarRole_SHEAR, IfcReinforcingBarRole_LIGATURE, IfcReinforcingBarRole_STUD, IfcReinforcingBarRole_PUNCHING, IfcReinforcingBarRole_EDGE, IfcReinforcingBarRole_RING, IfcReinforcingBarRole_USERDEFINED, IfcReinforcingBarRole_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcReinforcingBarSurfaceEnum {
/// Definition from IAI: Enumeration indicating whether the bar has a
///   plain or textured (ribbed) surface.  
/// 
/// HISTORY New type in IFC Release 2x2
/// 
/// ENUMERATION 
/// 
/// PLAIN The reinforcing bar surface is plain. 
///   TEXTURED The reinforcing bar surface is textured (ribbed).
typedef enum {IfcReinforcingBarSurface_PLAIN, IfcReinforcingBarSurface_TEXTURED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcResourceConsumptionEnum {
/// The IfcResourceConsumptionEnum indicates how a construction resource is consumed during its use.  The IfcResourceConsumptionEnum contains the following:
/// 
/// CONSUMED: Resource is production-based and is immediately consumed at the start of its usage.
/// PARTIALLYCONSUMED: Resource is production-based and is consumed over its usage.
/// NOTCONSUMED: Resource is production-based and is not consumed during its usage.
/// OCCUPIED: Resource is duration-based and is immediately consumed at the start of its usage.
/// PARTIALLYOCCUPIED: Resource is duration-based and is consumed over its usage.
/// NOTOCCUPIED: Resource is duration-based and is not consumed during its usage.
/// USERDEFINED: User-defined consumption; custom property sets must indicate usage.
/// NOTDEFINED: Undefined consumption.
/// 
/// HISTORY: New Enumeration in IFC Release 2.0.
typedef enum {IfcResourceConsumption_CONSUMED, IfcResourceConsumption_PARTIALLYCONSUMED, IfcResourceConsumption_NOTCONSUMED, IfcResourceConsumption_OCCUPIED, IfcResourceConsumption_PARTIALLYOCCUPIED, IfcResourceConsumption_NOTOCCUPIED, IfcResourceConsumption_USERDEFINED, IfcResourceConsumption_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcRibPlateDirectionEnum {

typedef enum {IfcRibPlateDirection_DIRECTION_X, IfcRibPlateDirection_DIRECTION_Y} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcRoleEnum {
/// Definition: Roles which may be played by an actor.
/// 
/// HISTORY This type has changes after IFC Release 2.0.  Spelling of COMMISSIONINGENGINEER fixed in IFC 2x4.
/// 
/// ENUMERATION 
/// 
/// SUPPLIER
///   MANUFACTURER
///   CONTRACTOR 
///   SUBCONTRACTOR
///   ARCHITECT
///   STRUCTURALENGINEER
///   COSTENGINEER 
///   CLIENT
///   BUILDINGOWNER
///   BUILDINGOPERATOR
///   MECHANICALENGINEER 
///   ELECTRICALENGINEER
///   PROJECTMANAGER
///   FACILITIESMANAGER
///   CIVILENGINEER
///   COMMISSIONINGENGINEER 
///   ENGINEER
///   OWNER
///   CONSULTANT
///   CONSTRUCTIONMANAGER
///   FIELDCONSTRUCTIONMANAGER 
///   RESELLER
///   USERDEFINED User defined value to be provided.
typedef enum {IfcRole_SUPPLIER, IfcRole_MANUFACTURER, IfcRole_CONTRACTOR, IfcRole_SUBCONTRACTOR, IfcRole_ARCHITECT, IfcRole_STRUCTURALENGINEER, IfcRole_COSTENGINEER, IfcRole_CLIENT, IfcRole_BUILDINGOWNER, IfcRole_BUILDINGOPERATOR, IfcRole_MECHANICALENGINEER, IfcRole_ELECTRICALENGINEER, IfcRole_PROJECTMANAGER, IfcRole_FACILITIESMANAGER, IfcRole_CIVILENGINEER, IfcRole_COMISSIONINGENGINEER, IfcRole_ENGINEER, IfcRole_OWNER, IfcRole_CONSULTANT, IfcRole_CONSTRUCTIONMANAGER, IfcRole_FIELDCONSTRUCTIONMANAGER, IfcRole_RESELLER, IfcRole_USERDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcRoofTypeEnum {
/// This enumeration defines the basic configuration of the roof in terms of the different roof shapes, as illustrated in Figure 68.
/// 
/// Roofs which are subdivided into more than these basic shapes have to be defined by the geometry only. Also roofs with non-regular shapes (free form roof) have to be defined by the geometry only. The type of such roofs is FREEFORM. 
/// 
/// HISTORY New Enumeration in IFC Release 2x. 
/// 
/// Enumerator 
///   Description 
///   Figure 
/// 
/// FLAT_ROOF 
///   A roof having no slope, or
///   one with only a slight pitch so as to drain rainwater. 
/// 
/// SHED_ROOF 
///   A roof having a single
///   slope. 
/// 
/// GABLE_ROOF 
///   A roof sloping downward in
///   two parts from a central ridge, so as to form a gable at each end. 
/// 
/// HIP_ROOF 
///   A roof having sloping ends
///   and sides meeting at an inclined projecting angle. 
/// 
/// HIPPED_GABLE_ROOF 
///   A roof having a hipped end
///   truncating a gable. 
/// 
/// GAMBREL_ROOF 
///   A ridged roof divided on each
///   side into a shallower slope above a steeper one. 
/// 
/// MANSARD_ROOF 
///   A roof having on each side a
///   steeper lower part and a shallower upper part. 
/// 
/// BARREL_ROOF 
///   A roof or ceiling having a
///   semicylindrical form. 
/// 
/// RAINBOW_ROOF 
///   A gable roof in the form of a
///   broad Gothic arch, with gently sloping convex surfaces. 
/// 
/// BUTTERFLY_ROOF 
///   A roof having two slopes,
///   each descending inward from the eaves. 
/// 
/// PAVILION_ROOF 
///   A pyramidal hip roof. 
/// 
/// DOME_ROOF 
///   A hemispherical hip
///   roof. 
/// 
/// FREEFORM 
///   Free form roof  
///     
/// 
/// NOTDEFINED 
///   No specification given 
///     
/// 
/// Figure 68 — Roof types
typedef enum {IfcRoofType_FLAT_ROOF, IfcRoofType_SHED_ROOF, IfcRoofType_GABLE_ROOF, IfcRoofType_HIP_ROOF, IfcRoofType_HIPPED_GABLE_ROOF, IfcRoofType_GAMBREL_ROOF, IfcRoofType_MANSARD_ROOF, IfcRoofType_BARREL_ROOF, IfcRoofType_RAINBOW_ROOF, IfcRoofType_BUTTERFLY_ROOF, IfcRoofType_PAVILION_ROOF, IfcRoofType_DOME_ROOF, IfcRoofType_FREEFORM, IfcRoofType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcSIPrefix {
/// Definition from ISO/CD 10303-41:1992: An SI prefix is the name of a prefix that may be associated 
/// with an SI unit. The definitions of SI prefixes are specified in ISO 1000 (clause 3).
/// 
/// NOTE The prefix defines multiples and submultiples of the SI units.
/// 
/// NOTE Corresponding ISO 10303 name: SI_prefix, please refer to ISO/IS 10303-41 for the final definition of the formal standard.
/// 
/// ENUMERATION 
/// 
/// EXA: 10^18. 
///   PETA: 10^15. 
///   TERA: 10^12. 
///   GIGA: 10^9. 
///   MEGA: 10^6. 
///   KILO: 10^3. 
///   HECTO: 10^2.  
///   DECA: 10. 
///   DECI: 10^-1. 
///   CENTI: 10^-2. 
///   MILLI: 10^-3. 
///   MICRO: 10^-6. 
///   NANO: 10^-9. 
///   PICO: 10^-12. 
///   FEMTO: 10^-15. 
///   ATTO: 10^-18. 
/// 
/// HISTORY New entity in IFC Release 1.5.1.
typedef enum {IfcSIPrefix_EXA, IfcSIPrefix_PETA, IfcSIPrefix_TERA, IfcSIPrefix_GIGA, IfcSIPrefix_MEGA, IfcSIPrefix_KILO, IfcSIPrefix_HECTO, IfcSIPrefix_DECA, IfcSIPrefix_DECI, IfcSIPrefix_CENTI, IfcSIPrefix_MILLI, IfcSIPrefix_MICRO, IfcSIPrefix_NANO, IfcSIPrefix_PICO, IfcSIPrefix_FEMTO, IfcSIPrefix_ATTO} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcSIUnitName {
/// Definition from ISO/CD 10303-41:1992: An SI unit name is the name of an SI unit. The definitions of the 
/// names of SI units are specified in ISO 1000 (clause 2).
/// 
/// NOTE Corresponding STEP name: SI_unit_name, please refer to ISO/IS 10303-41 for the final definition of the formal standard.
/// 
/// ENUMERATION 
/// 
/// AMPERE: Unit for electric current. 
///   BECQUEREL: Unit for radioactivity. 
///   CANDELA: Unit for luminousintensity. 
///   COULOMB: Unit for electric charge. 
///   CUBIC_METRE: Unit for volume. 
///   DEGREE_CELSIUS: Unit for thermodynamic temperature. 
///   FARAD: Unit for electric capacitance. 
///   GRAM: Unit for mass. 
///   GRAY: Unit for absorbed radioactive dose. 
///   HENRY: Unit for inductance. 
///   HERTZ: Unit for frequency. 
///   JOULE: Unit for energy. 
///   KELVIN: Unit for thermodynamic temperature. 
///   LUMEN: Unit for luminous flux. 
///   LUX: Unit for illuminance. 
///   METRE: Unit for length. 
///   MOLE: Unit for amount of substance. 
///   NEWTON: Unit for force. 
///   OHM: Unit for electric resistance. 
///   PASCAL: Unit for pressure. 
///   RADIAN: Unit for plane angle. 
///   SECOND: Unit for time. 
///   SIEMENS: Unit for electric conductance. 
///   SIEVERT: Unit for radioactive dose equivalent. 
///   SQUARE_METRE: Unit for area. 
///   STERADIAN: Unit for solid angle. 
///   TESLA: Unit for magnetic flux density. 
///   VOLT: Unit for electric voltage. 
///   WATT: Unit for power. 
///   WEBER: Unit for magnetic flux. 
/// 
/// HISTORY New entity in IFC Release 1.5.1.
typedef enum {IfcSIUnitName_AMPERE, IfcSIUnitName_BECQUEREL, IfcSIUnitName_CANDELA, IfcSIUnitName_COULOMB, IfcSIUnitName_CUBIC_METRE, IfcSIUnitName_DEGREE_CELSIUS, IfcSIUnitName_FARAD, IfcSIUnitName_GRAM, IfcSIUnitName_GRAY, IfcSIUnitName_HENRY, IfcSIUnitName_HERTZ, IfcSIUnitName_JOULE, IfcSIUnitName_KELVIN, IfcSIUnitName_LUMEN, IfcSIUnitName_LUX, IfcSIUnitName_METRE, IfcSIUnitName_MOLE, IfcSIUnitName_NEWTON, IfcSIUnitName_OHM, IfcSIUnitName_PASCAL, IfcSIUnitName_RADIAN, IfcSIUnitName_SECOND, IfcSIUnitName_SIEMENS, IfcSIUnitName_SIEVERT, IfcSIUnitName_SQUARE_METRE, IfcSIUnitName_STERADIAN, IfcSIUnitName_TESLA, IfcSIUnitName_VOLT, IfcSIUnitName_WATT, IfcSIUnitName_WEBER} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcSanitaryTerminalTypeEnum {
/// The IfcSanitaryTerminalTypeEnum defines the range of different types of sanitary terminal that can be specified. 
/// 
/// NOTE: The value WCSEAT has been deprecated and should no longer be used; toilet seats should be represented by IfcDiscreteAccessory with ObjectType 'WC Seat'. 
///   HISTORY: New type in IFC 2x2 
/// 
/// Enumeration 
/// 
/// BATH: Sanitary appliance for immersion of the human body or parts of it. 
/// BIDET: Waste water appliance for washing the excretory organs while sitting astride the bowl. 
/// CISTERN: A water storage unit attached to a sanitary terminal that is fitted with a device, operated automatically or by the user, that discharges water to cleanse a water closet (toilet) pan, urinal or slop hopper. 
/// SHOWER: Installation or waste water appliance that emits a spray of water to wash the human body. 
/// SINK: Waste water appliance for receiving, retaining or disposing of domestic, culinary, laboratory or industrial process liquids. 
/// SANITARYFOUNTAIN: A sanitary terminal that provides a low pressure jet of water for a specific purpose. 
/// TOILETPAN: Soil appliance for the disposal of excrement. 
/// URINAL: Soil appliance that receives urine and directs it to a waste outlet (BS6100). 
/// WASHHANDBASIN: Waste water appliance for washing the upper parts of the body. 
/// WCSEAT: [Deprecated] Hinged seat that fits on the top of a water closet (WC) pan. 
/// USERDEFINED: User-defined type. 
/// NOTDEFINED: Undefined type.
typedef enum {IfcSanitaryTerminalType_BATH, IfcSanitaryTerminalType_BIDET, IfcSanitaryTerminalType_CISTERN, IfcSanitaryTerminalType_SHOWER, IfcSanitaryTerminalType_SINK, IfcSanitaryTerminalType_SANITARYFOUNTAIN, IfcSanitaryTerminalType_TOILETPAN, IfcSanitaryTerminalType_URINAL, IfcSanitaryTerminalType_WASHHANDBASIN, IfcSanitaryTerminalType_WCSEAT, IfcSanitaryTerminalType_USERDEFINED, IfcSanitaryTerminalType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcSectionTypeEnum {
/// Definition from IAI: An enumeration indicating whether a
///   specific piece of a cross section is uniform or tapered in longitudinal
///   direction.  
///   HISTORY New type in IFC
///   Release 2x2  
///   ENUMERATION 
/// 
/// UNIFORM The section is uniform in longitudinal direction.
/// 
/// TAPERED The section is tapered in longitudinal direction.
typedef enum {IfcSectionType_UNIFORM, IfcSectionType_TAPERED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcSensorTypeEnum {
/// The IfcSensorTypeEnum defines the range of different types of sensor that can be specified. 
/// 
/// HISTORY: New type in IFC R2.0.  Added missing enumerations in IFC2x4
/// 
/// Enumeration 
/// 
/// CONDUCTANCESENSOR: A device that senses or detects electrical conductance. 
/// CONTACTSENSOR: A device that senses or detects contact, such as for detecting if a door is closed. 
/// FIRESENSOR: A device that senses or detects fire. 
/// FLOWSENSOR: A device that senses or detects flow in a fluid. 
/// GASSENSOR: A device that senses or detects gas concentration. 
/// HEATSENSOR: A device that senses or detects heat. 
/// IONCONCENTRATIONSENSOR: A device that senses or detects ion concentration, such as for water hardness. 
/// LEVELSENSOR: A device that senses or detects fill level, such as for a tank. 
/// HUMIDITYSENSOR: A device that senses or detects humidity. 
/// LIGHTSENSOR: A device that senses or detects light. 
/// MOISTURESENSOR: A device that senses or detects moisture. 
/// MOVEMENTSENSOR: A device that senses or detects movement.  
/// PHSENSOR: A device that senses or detects acidity. 
/// PRESSURESENSOR: A device that senses or detects pressure. 
/// RADIATIONSENSOR: A device that senses or detects electromagnetic radiation. 
/// RADIOACTIVITYSENSOR: A device that senses or detects atomic decay. 
/// SMOKESENSOR: A device that senses or detects smoke. 
/// SOUNDSENSOR: A device that senses or detects sound.  
/// TEMPERATURESENSOR: A device that senses or detects temperature. 
/// WINDSENSOR: A device that senses or detects airflow speed and direction. 
/// USERDEFINED: User-defined type. 
/// NOTDEFINED: Undefined type.
typedef enum {IfcSensorType_CO2SENSOR, IfcSensorType_FIRESENSOR, IfcSensorType_FLOWSENSOR, IfcSensorType_GASSENSOR, IfcSensorType_HEATSENSOR, IfcSensorType_HUMIDITYSENSOR, IfcSensorType_LIGHTSENSOR, IfcSensorType_MOISTURESENSOR, IfcSensorType_MOVEMENTSENSOR, IfcSensorType_PRESSURESENSOR, IfcSensorType_SMOKESENSOR, IfcSensorType_SOUNDSENSOR, IfcSensorType_TEMPERATURESENSOR, IfcSensorType_USERDEFINED, IfcSensorType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcSequenceEnum {
/// IfcSequenceEnum is an
///   enumeration that defines the different ways in which a
///   time lag is applied to a sequence between two processes.
/// 
/// HISTORY  New entity in IFC 1.0
typedef enum {IfcSequence_START_START, IfcSequence_START_FINISH, IfcSequence_FINISH_START, IfcSequence_FINISH_FINISH, IfcSequence_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcServiceLifeFactorTypeEnum {

typedef enum {IfcServiceLifeFactorType_A_QUALITYOFCOMPONENTS, IfcServiceLifeFactorType_B_DESIGNLEVEL, IfcServiceLifeFactorType_C_WORKEXECUTIONLEVEL, IfcServiceLifeFactorType_D_INDOORENVIRONMENT, IfcServiceLifeFactorType_E_OUTDOORENVIRONMENT, IfcServiceLifeFactorType_F_INUSECONDITIONS, IfcServiceLifeFactorType_G_MAINTENANCELEVEL, IfcServiceLifeFactorType_USERDEFINED, IfcServiceLifeFactorType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcServiceLifeTypeEnum {

typedef enum {IfcServiceLifeType_ACTUALSERVICELIFE, IfcServiceLifeType_EXPECTEDSERVICELIFE, IfcServiceLifeType_OPTIMISTICREFERENCESERVICELIFE, IfcServiceLifeType_PESSIMISTICREFERENCESERVICELIFE, IfcServiceLifeType_REFERENCESERVICELIFE} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcSlabTypeEnum {
/// Definition from IAI: This enumeration defines the
///   available predefined types of a slab. The
///   IfcSlabTypeEnum can be used for slab occurrences,
///   IfcSlab, and slab types, IfcSlabType. A
///   special property set definition may be provided for each
///   predefined type.
/// 
/// HISTORY  New type in IFC
///   Release 2.0
/// 
/// Floor
/// 
/// The slab is used to represent a floor slab.
/// 
/// Roof
/// 
/// The slab is used to represent a roof slab (either
///   flat or sloped).
/// 
/// Landing
/// 
/// The slab is used to represent a landing within a
///   stair or ramp.
/// 
/// BaseSlab
/// 
/// The slab is used to represent a floor slab against
///   the ground (and thereby being a part of the
///   foundation). Another name is mat foundation.
/// 
/// IFC2x3 CHANGE
///    new enumerator added.
typedef enum {IfcSlabType_FLOOR, IfcSlabType_ROOF, IfcSlabType_LANDING, IfcSlabType_BASESLAB, IfcSlabType_USERDEFINED, IfcSlabType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcSoundScaleEnum {

typedef enum {IfcSoundScale_DBA, IfcSoundScale_DBB, IfcSoundScale_DBC, IfcSoundScale_NC, IfcSoundScale_NR, IfcSoundScale_USERDEFINED, IfcSoundScale_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcSpaceHeaterTypeEnum {
/// Enumeration defining the functional type of space heater.
/// 
/// The IfcSpaceHeaterTypeEnum contains the following:
/// 
/// CONVECTOR: A heat-distributing unit that operates with gravity-circulated air.
/// RADIATOR: A heat-distributing unit that operates with thermal radiation.
/// USERDEFINED: User-defined space heater type.
/// NOTDEFINED:  Undefined space heater type.
/// 
/// NOTE: This enumeration was revised in IFC 2x4 and was renamed from IfcHydronicHeaterTypeEnum in IFC R2x.
/// 
/// HISTORY: New enumeration in IFC R2x.
typedef enum {IfcSpaceHeaterType_SECTIONALRADIATOR, IfcSpaceHeaterType_PANELRADIATOR, IfcSpaceHeaterType_TUBULARRADIATOR, IfcSpaceHeaterType_CONVECTOR, IfcSpaceHeaterType_BASEBOARDHEATER, IfcSpaceHeaterType_FINNEDTUBEUNIT, IfcSpaceHeaterType_UNITHEATER, IfcSpaceHeaterType_USERDEFINED, IfcSpaceHeaterType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcSpaceTypeEnum {
/// Definition from IAI: This enumeration defines the
/// available generic types for IfcSpace and
/// IfcSpaceType.
/// HISTORY New enumeration
/// in IFC2x3.
/// IFC2x4 CHANGE The enumerators
/// INTERNAL and EXTERNAL have been added for upward compatibility to
/// replace InteriorOrExteriorSpace
/// usage.
/// Enumeration
/// 
/// SPACE Any space not falling into another category.
/// 
/// NOTE For classification of spaces according to its
/// function that is often determined by national classification
/// systems use IfcClassificationReference via the
/// relationship IfcRelAssociatesClassification.
/// 
/// PARKING A space dedication for use as a parking spot
/// for vehicles, including access, such as a parking aisle
/// GFA Gross Floor Area - a specific kind of space for
/// each building story that includes all net area and construction
/// area (also the external envelop). Provision of such a specific
/// space is often required by regulations.
/// INTERNAL
/// 
/// NOTE the use is deprecated and
/// only provided for backward compatibility
/// purposes.
/// 
/// EXTERNAL
/// 
/// NOTE the use is deprecated and
/// only provided for backward compatibility
/// purposes.
typedef enum {IfcSpaceType_USERDEFINED, IfcSpaceType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcStackTerminalTypeEnum {
/// An IfcStackTerminalTypeEnum defines the range of different types of stack terminal that can be specified for use at the top of a vertical stack subsystem. 
///   HISTORY: New type in IFC 2x  
///   Enumeration 
/// 
/// BIRDCAGE: Guard cage, typically wire mesh, at the top of the stack preventing access by birds. 
/// COWL: A cowling placed at the top of a stack to eliminate downdraft. 
/// RAINWATERHOPPER: A box placed at the top of a rainwater downpipe to catch rainwater from guttering. 
/// USERDEFINED: User-defined type. 
/// NOTDEFINED: Undefined type.
typedef enum {IfcStackTerminalType_BIRDCAGE, IfcStackTerminalType_COWL, IfcStackTerminalType_RAINWATERHOPPER, IfcStackTerminalType_USERDEFINED, IfcStackTerminalType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcStairFlightTypeEnum {
/// Definition from IAI: This enumeration defines the different types
///   of stair flights an IfcStairFlightType object can fulfill: 
/// 
/// STRAIGHT: A stair flight with a straight walking line.  
///   WINDER: A stair flight with a straight walking line. 
///   SPIRAL: A stair flight with a circular or elliptic walking
///   line. 
///   CURVED: A stair flight with a curved walking line. 
///   FREEFORM: A stair flight with a free form walking line (and
///   outer boundaries). 
///   USERDEFINED: User-defined stair flight . 
///   NOTDEFINED: Undefined stair flight . 
/// 
/// HISTORY: New Enumeration in
///   Release IFC2x Edition 2.
typedef enum {IfcStairFlightType_STRAIGHT, IfcStairFlightType_WINDER, IfcStairFlightType_SPIRAL, IfcStairFlightType_CURVED, IfcStairFlightType_FREEFORM, IfcStairFlightType_USERDEFINED, IfcStairFlightType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcStairTypeEnum {
/// This enumeration defines the basic configuration of the stair type in terms of the number of stair flights and the number of landings, as illustrated in Figure 69. The type also distinguished turns by windings or by landings. In addition the subdivision of the straight and changing direction stairs is included. The stair configurations are given for stairs without and with one, two or three landings. 
/// 
/// Stairs which are subdivided into more than three landings have to be defined by the geometry only. Also stairs with non-regular shapes have to be defined by the geometry only. The type of such stairs is OTHEROPERATION. 
/// 
/// HISTORY New Enumeration in IFC Release 2.0. 
/// 
/// Enumerator 
///   Description 
///   Figure 
/// 
/// StraightRunStair 
///   A stair extending from
///   one level to another without turns or winders. The stair consists of one
///   straight flight. 
/// 
/// TwoStraightRunStair 
///   A straight stair
///   consisting of two straight flights without turns but with one landing. 
/// 
/// QuarterWindingStair 
///   A stair consisting of one
///   flight with a quarter winder, which is making a 90° turn. The direction of
///   the turn is determined by the walking line. 
/// 
/// QuarterTurnStair 
///   A stair making a 90°
///   turn, consisting of two straight flights connected by a quarterspace landing.
///   The direction of the turn is determined by the walking line. 
/// 
/// HalfWindingStair 
///   A stair consisting of one
///   flight with one half winder, which makes a 180° turn. The orientation of
///   the turn is determined by the walking line. 
/// 
/// HalfTurnStair 
///   A stair making a 180°
///   turn, consisting of two straight flights connected by a halfspace landing. The
///   orientation of the turn is determined by the walking line. 
/// 
/// TwoQuarterWindingStair 
///   A stair consisting of one
///   flight with two quarter winders, which make a 90° turn. The stair makes a
///   180° turn. The direction of the turns is determined by the walking
///   line. 
/// 
/// TwoQuarterTurnStair 
///   A stair making a 180°
///   turn, consisting of three straight flights connected by two quarterspace
///   landings. The direction of the turns is determined by the walking line. 
/// 
/// ThreeQuarterWindingStair
/// 
/// A stair consisting of one
///   flight with three quarter winders, which make a 90° turn. The stair makes a
///   270° turn. The direction of the turns is determined by the walking
///   line. 
/// 
/// ThreeQuarterTurnStair 
///   A stair making a 270°
///   turn, consisting of four straight flights connected by three quarterspace
///   landings. The direction of the turns is determined by the walking line. 
/// 
/// SpiralStair 
///   A stair constructed with
///   winders around a circular newel often without landings. Depending on outer
///   boundary it can be either a circular, elliptical or rectangular spiral stair.
///   The orientation of the winding stairs is determined by the walking line. 
/// 
/// DoubleReturnStair 
///   A stair having one
///   straight flight to a wide quarterspace landing, and two side flights from that
///   landing into opposite directions. The stair is making a 90° turn. The
///   direction of traffic is determined by the walking line. 
/// 
/// CurvedRunStair 
///   A stair extending from one
///   level to another without turns or winders. The stair is consisting of one
///   curved flight. 
/// 
/// TwoCurvedRunStair 
///   A curved stair consisting of
///   two curved flights without turns but with one landing. 
/// 
/// OtherOperation 
///   Free form stair (user defined
///   operation type) 
///     
/// 
/// NotDefined 
///     
///     
/// 
/// Figure 69 — Stair types
typedef enum {IfcStairType_STRAIGHT_RUN_STAIR, IfcStairType_TWO_STRAIGHT_RUN_STAIR, IfcStairType_QUARTER_WINDING_STAIR, IfcStairType_QUARTER_TURN_STAIR, IfcStairType_HALF_WINDING_STAIR, IfcStairType_HALF_TURN_STAIR, IfcStairType_TWO_QUARTER_WINDING_STAIR, IfcStairType_TWO_QUARTER_TURN_STAIR, IfcStairType_THREE_QUARTER_WINDING_STAIR, IfcStairType_THREE_QUARTER_TURN_STAIR, IfcStairType_SPIRAL_STAIR, IfcStairType_DOUBLE_RETURN_STAIR, IfcStairType_CURVED_RUN_STAIR, IfcStairType_TWO_CURVED_RUN_STAIR, IfcStairType_USERDEFINED, IfcStairType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcStateEnum {
/// The IfcStateEnum enumeration identifies the state or accessibility of the object (for example, read/write, locked).
/// 
/// Valid enumerations are:
/// 
/// READWRITE: Object is in a Read-Write state. It may be modified by an application.
/// READONLY: Object is in a Read-Only state. It may be viewed but not modified by an application.
/// LOCKED: Object is in a Locked state. It may not be accessed by an application.
/// READWRITELOCKED: Object is in a Read-Write-Locked state. It may not be accessed by an application.
/// READONLYLOCKED: Object is in a Read-Only-Locked state. It may not be accessed by an application.
/// 
/// HISTORY  New enumeration in IFC R2.0.
/// 
/// IFC2x3 CHANGE  This concept was initially introduced in IFC 2.0 as IfcModifiedFlag of type BINARY(3) FIXED and has been modified in R2x to an enumeration. It was initially introduced as a first step towards providing facilities for partial model exchange from a server as requested by the IFC implementers. It is intended for use primarily by a model server so that an application can identify the state of the object.
typedef enum {IfcState_READWRITE, IfcState_READONLY, IfcState_LOCKED, IfcState_READWRITELOCKED, IfcState_READONLYLOCKED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcStructuralCurveTypeEnum {

typedef enum {IfcStructuralCurveType_RIGID_JOINED_MEMBER, IfcStructuralCurveType_PIN_JOINED_MEMBER, IfcStructuralCurveType_CABLE, IfcStructuralCurveType_TENSION_MEMBER, IfcStructuralCurveType_COMPRESSION_MEMBER, IfcStructuralCurveType_USERDEFINED, IfcStructuralCurveType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcStructuralSurfaceTypeEnum {

typedef enum {IfcStructuralSurfaceType_BENDING_ELEMENT, IfcStructuralSurfaceType_MEMBRANE_ELEMENT, IfcStructuralSurfaceType_SHELL, IfcStructuralSurfaceType_USERDEFINED, IfcStructuralSurfaceType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcSurfaceSide {
/// IfcSurfaceSide is a denotion of whether negative, positive or both sides of a surface are being referenced. 
/// 
/// ENUMERATION Definition from ISO/CD 10303-46:1992: 
/// 
/// POSITIVE: The side of a surface which is in the same direction as the surface normal derived from the mathematical definition.  
/// NEGATIVE: The side of a surface which is in the opposite direction than the surface normal derived from the mathematical definition. 
/// BOTH: Both, positive and negative side. 
/// 
/// NOTE Corresponding ISO 10303 type: surface_side. Please refer to ISO/IS 10303-46:1994 for the final definition of the formal standard.
/// 
/// HISTORY: New Enumeration in IFC 2.0
typedef enum {IfcSurfaceSide_POSITIVE, IfcSurfaceSide_NEGATIVE, IfcSurfaceSide_BOTH} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcSurfaceTextureEnum {

typedef enum {IfcSurfaceTexture_BUMP, IfcSurfaceTexture_OPACITY, IfcSurfaceTexture_REFLECTION, IfcSurfaceTexture_SELFILLUMINATION, IfcSurfaceTexture_SHININESS, IfcSurfaceTexture_SPECULAR, IfcSurfaceTexture_TEXTURE, IfcSurfaceTexture_TRANSPARENCYMAP, IfcSurfaceTexture_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcSwitchingDeviceTypeEnum {
/// The IfcSwitchingDeviceTypeEnum defines the range of different types of switch that can be specified. 
///   HISTORY: New type in IFC 2x2 
///   Enumeration 
/// 
/// CONTACTOR: An electrical device used to control the flow of power in a circuit on or off. 
/// DIMMERSWITCH: A dimmer switch has variable positions, and may adjust electrical power or other setting (according to the switched port type). 
/// EMERGENCYSTOP: An emergency stop device acts to remove as quickly as possible any danger that may have arisen unexpectedly. 
/// KEYPAD: A set of buttons or switches, each potentially applicable to a different device.  
/// MOMENTARYSWITCH: A momentary switch has no position, and may trigger some action to occur.  
/// SELECTORSWITCH: A selector switch has multiple positions, and may switch connectivity or other setting.  
/// STARTER: A starter is a switch which in the closed position controls the application of power to an electrical device. 
/// SWITCHDISCONNECTOR: A switch disconnector is a switch which in the open position satisfies the isolating requirements specified for a disconnector. 
/// SELECTORSWITCH: A selector switch has multiple positions, and may change the source or level of power or other setting (according to the switched port type). 
/// TOGGLESWITCH: A toggle switch has two positions, and may enable or isolate electrical power or other setting (according to the switched port type). 
/// USERDEFINED: User-defined type. 
/// NOTDEFINED: Undefined type.
typedef enum {IfcSwitchingDeviceType_CONTACTOR, IfcSwitchingDeviceType_EMERGENCYSTOP, IfcSwitchingDeviceType_STARTER, IfcSwitchingDeviceType_SWITCHDISCONNECTOR, IfcSwitchingDeviceType_TOGGLESWITCH, IfcSwitchingDeviceType_USERDEFINED, IfcSwitchingDeviceType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcTankTypeEnum {
/// Enumeration defining the typical types of tanks.
/// 
/// The IfcTankTypeEnum contains the following:
/// 
/// BASIN:  An arbitrary open tank type.
/// 
/// BREAKPRESSURE:  An open container that breaks the hydraulic pressure in a distribution system, typically located between the fluid reservoir and the fluid supply points. A typical break pressure tank allows the flow to discharge into the atmosphere, thereby reducing its hydrostatic pressure to zero.
/// 
/// EXPANSION:  A closed container used in a closed fluid distribution system to mitigate the effects of thermal expansion or water hammer. The tank is typically constructed with a diaphragm dividing the tank into two sections, with fluid on one side of the diaphragm and air on the other. One example application is when connected to the primary circuit of a hot water system to accommodate the increase in volume of the water when it is heated.
/// 
/// FEEDANDEXPANSION:  An open tank that is used for both storage and thermal expansion. A typical example is a tank used to store make-up water at ambient pressure for supply to a hot water system, simultaneously accommodating increases in volume of the water when heated.
/// 
/// PRESSUREVESSEL:  A closed container used for storing fluids or gases at a pressure different from the ambient pressure. A pressure vessel is typically rated by an authority having jurisdiction for the operational pressure.
/// 
/// STORAGE:  An open or closed containter used for storing a fluid at ambient pressure and from which it can be supplied to the fluid distribution system. There are many examples of storage tanks, such as potable water storage tanks, fuel storage tanks, etc.
/// 
/// VESSEL:  An arbitrary closed tank type.
/// 
/// USERDEFINED:  User-defined tank type.
/// 
/// NOTDEFINED:  Undefined tank type.
/// 
/// HISTORY: New enumeration in IFC 2x2.  BASIN and VESSEL added in IFC2x4.
typedef enum {IfcTankType_PREFORMED, IfcTankType_SECTIONAL, IfcTankType_EXPANSION, IfcTankType_PRESSUREVESSEL, IfcTankType_USERDEFINED, IfcTankType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcTendonTypeEnum {

typedef enum {IfcTendonType_STRAND, IfcTendonType_WIRE, IfcTendonType_BAR, IfcTendonType_COATED, IfcTendonType_USERDEFINED, IfcTendonType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcTextPath {
/// The text path determines the direction of the text characters in respect to each other.
/// 
/// NOTE: The IfcTextPath is an entity that had been adopted from ISO 10303, Industrial automation systems and integration&#151;Product data representation and exchange, Part 46: Integrated generic resources: Visual presentation.
/// 
/// NOTE Corresponding ISO 10303 name:text_path . Please refer to ISO/IS 10303-46:1994 for the final definition of the formal standard.
/// 
/// HISTORY New entity in IFC2x2.
typedef enum {IfcTextPath_LEFT, IfcTextPath_RIGHT, IfcTextPath_UP, IfcTextPath_DOWN} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcThermalLoadSourceEnum {

typedef enum {IfcThermalLoadSource_PEOPLE, IfcThermalLoadSource_LIGHTING, IfcThermalLoadSource_EQUIPMENT, IfcThermalLoadSource_VENTILATIONINDOORAIR, IfcThermalLoadSource_VENTILATIONOUTSIDEAIR, IfcThermalLoadSource_RECIRCULATEDAIR, IfcThermalLoadSource_EXHAUSTAIR, IfcThermalLoadSource_AIREXCHANGERATE, IfcThermalLoadSource_DRYBULBTEMPERATURE, IfcThermalLoadSource_RELATIVEHUMIDITY, IfcThermalLoadSource_INFILTRATION, IfcThermalLoadSource_USERDEFINED, IfcThermalLoadSource_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcThermalLoadTypeEnum {

typedef enum {IfcThermalLoadType_SENSIBLE, IfcThermalLoadType_LATENT, IfcThermalLoadType_RADIANT, IfcThermalLoadType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcTimeSeriesDataTypeEnum {
/// IfcTimeSeriesDataTypeEnum describes a type of time series data and is used to determine a value during the time series which is not explicitly specified: 
/// 
/// CONTINUOUS: The time series data is continuous. 
///   DISCRETE: The time series data is discrete. 
///   DISCRETEBINARY: The time series data is discrete binary. 
///   PIECEWISEBINARY: The time series data is piecewise binary. 
///   PIECEWISECONSTANT: The time series data is piecewise constant. 
///   PIECEWISECONTINUOUS: The time series data is piecewise continuous. 
///   NOTDEFINED: The time series data is not defined. 
/// 
/// HISTORY: New enumeration in IFC2x2.
typedef enum {IfcTimeSeriesDataType_CONTINUOUS, IfcTimeSeriesDataType_DISCRETE, IfcTimeSeriesDataType_DISCRETEBINARY, IfcTimeSeriesDataType_PIECEWISEBINARY, IfcTimeSeriesDataType_PIECEWISECONSTANT, IfcTimeSeriesDataType_PIECEWISECONTINUOUS, IfcTimeSeriesDataType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcTimeSeriesScheduleTypeEnum {

typedef enum {IfcTimeSeriesScheduleType_ANNUAL, IfcTimeSeriesScheduleType_MONTHLY, IfcTimeSeriesScheduleType_WEEKLY, IfcTimeSeriesScheduleType_DAILY, IfcTimeSeriesScheduleType_USERDEFINED, IfcTimeSeriesScheduleType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcTransformerTypeEnum {
/// The IfcTransformerTypeEnum defines the range of different types of transformer that can be specified. 
///   HISTORY: New type in IFC 2x2 
///   Enumeration 
/// 
/// CURRENT: A transformer that changes the current between circuits. 
/// FREQUENCY: A transformer that changes the frequency between circuits. 
/// INVERTER: A transformer that converts from direct current (DC) to alternating current (AC). 
/// RECTIFIER: A transformer that converts from alternating current (AC) to direct current (DC).  
/// VOLTAGE: A transformer that changes the voltage between circuits.  
/// USERDEFINED: User-defined type. 
/// NOTDEFINED: Undefined type.
typedef enum {IfcTransformerType_CURRENT, IfcTransformerType_FREQUENCY, IfcTransformerType_VOLTAGE, IfcTransformerType_USERDEFINED, IfcTransformerType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcTransitionCode {
/// Definition from ISO/CD 10303-42:1992: This type conveys the continuity properties of a composite curve or surface. The continuity referred to is geometric, not parametric continuity. For example, in ContSameGradient the tangent vectors of successive segments will have the same direction, but may have different magnitude.  
/// 
/// NOTE  Corresponding ISO 10303 type: transition_code, please refer to ISO/IS 10303-42:1994, p. 14 for the final definition of the formal standard.
/// 
/// HISTORY  New Type in IFC Release 1.0
/// 
/// Figure 273 (quoted from ISO/CD 10303-42:1992, p.55) illustrates transition types.
/// 
/// Figure 273 — Transition code
/// 
/// ENUMERATION 
/// 
/// DISCONTINUOUS: The segments do not join. This is permitted only at the boundary of the curve or surface to indicate that it is not closed.
/// CONTINUOUS: The segments join but no condition on their tangents is implied. 
/// CONTSAMEGRADIENT: The segments join and their tangent vectors or tangent planes are parallel and have the same direction at the joint: equality of derivatives is not required. 
/// CONTSAMEGRADIENTSAMECURVATURE: For a curve, the segments join, their tangent vectors are parallel and in the same direction and their curvatures are equal at the joint: equality of derivatives is not required. For a surface this implies that the principle curvatures are the same and the principle directions are coincident along the common boundary.
typedef enum {IfcTransitionCode_DISCONTINUOUS, IfcTransitionCode_CONTINUOUS, IfcTransitionCode_CONTSAMEGRADIENT, IfcTransitionCode_CONTSAMEGRADIENTSAMECURVATURE} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcTransportElementTypeEnum {
/// Definition from IAI: This enumeration is used to
/// identify primary transport element types. The
/// IfcTransportElementTypeEnum contains the following:
/// 
/// ELEVATOR: Elevator or lift being a transport device to
/// move people of good vertically.
/// ESCALATOR: Escalator being a transport device to move
/// people. It consists of individual linked steps that move up and
/// down on tracks while keeping the threads horizontal.
/// MOVINGWALKWAY: Moving walkway being a transport device
/// to move people horizontally or on an incline. It is a slow
/// conveyor belt that transports people.
/// CRANEWAY: A crane way system, normally including the
/// crane rails, fasteners and the crane. It is primarily used to
/// move heavy goods in a factory or other industry buildings.
/// LIFTINGGEAR: A device used for lifting or lowering
/// heavy goods. It may be manually operated or electrically or
/// pneumatically driven.
/// 
/// HISTORY  New enumeration
/// in IFC Release 2x.
/// IFC2x4 CHANGE  New enumerators
/// CRANEWAY and LIFTINGGEAR added in
/// IFC2x4.
typedef enum {IfcTransportElementType_ELEVATOR, IfcTransportElementType_ESCALATOR, IfcTransportElementType_MOVINGWALKWAY, IfcTransportElementType_USERDEFINED, IfcTransportElementType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcTrimmingPreference {
/// Definition from ISO/CD 10303-42:1992: This type is used to describe the preferred way of trimming a parametric curve where the trimming is multiply defined. 
/// 
/// NOTE Corresponding ISO 10303 type: trimming_preference, please refer to ISO/IS 10303-42:1994, p. 18 for the final definition of the formal standard.
/// 
/// HISTORY New Type in IFC Release 1.0
/// 
/// ENUMERATION 
/// 
/// CARTESIAN: Indicates that trimming by Cartesian point is preferred. 
/// PARAMETER: Indicates the preference for the parameter value. 
/// UNSPECIFIED: Indicates that no preference is communicated.
typedef enum {IfcTrimmingPreference_CARTESIAN, IfcTrimmingPreference_PARAMETER, IfcTrimmingPreference_UNSPECIFIED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcTubeBundleTypeEnum {
/// Enumeration defining the typical types of tube bundles. 
///   The IfcTubeBundleTypeEnum contains the following:
/// 
/// FINNED:  Finned tube bundle type.
///   USERDEFINED:  User-defined tube bundle type.
///   NOTDEFINED:  Undefined tube bundle type.
/// 
/// HISTORY: New enumeration in IFC 2x2.
typedef enum {IfcTubeBundleType_FINNED, IfcTubeBundleType_USERDEFINED, IfcTubeBundleType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcUnitEnum {
/// IfcUnitEnum is an enumeration type for allowed unit types of IfcNamedUnit.
/// 
/// ENUMERATION 
/// 
/// ABSORBEDDOSEUNIT
///   AMOUNTOFSUBSTANCEUNIT
///   AREAUNIT
///   DOSEEQUIVALENTUNIT
///   ELECTRICCAPACITANCEUNIT
///   ELECTRICCHARGEUNIT
///   ELECTRICCONDUCTANCEUNIT
///   ELECTRICCURRENTUNIT
///   ELECTRICRESISTANCEUNIT
///   ELECTRICVOLTAGEUNIT
///   ENERGYUNIT
///   FORCEUNIT
///   FREQUENCYUNIT
///   ILLUMINANCEUNIT
///   INDUCTANCEUNIT
///   LENGTHUNIT
///   LUMINOUSFLUXUNIT
///   LUMINOUSINTENSITYUNIT
///   MAGNETICFLUXDENSITYUNIT
///   MAGNETICFLUXUNIT
///   MASSUNIT
///   PLANEANGLEUNIT
///   POWERUNIT
///   PRESSUREUNIT
///   RADIOACTIVITYUNIT
///   SOLIDANGLEUNIT
///   THERMODYNAMICTEMPERATUREUNIT
///   TIMEUNIT
///   VOLUMEUNIT
///   USERDEFINED: User defined unit type. The type of unit is only implied by its name or the usage context.
/// 
/// HISTORY New type in IFC Release 1.5.1.
typedef enum {IfcUnit_ABSORBEDDOSEUNIT, IfcUnit_AMOUNTOFSUBSTANCEUNIT, IfcUnit_AREAUNIT, IfcUnit_DOSEEQUIVALENTUNIT, IfcUnit_ELECTRICCAPACITANCEUNIT, IfcUnit_ELECTRICCHARGEUNIT, IfcUnit_ELECTRICCONDUCTANCEUNIT, IfcUnit_ELECTRICCURRENTUNIT, IfcUnit_ELECTRICRESISTANCEUNIT, IfcUnit_ELECTRICVOLTAGEUNIT, IfcUnit_ENERGYUNIT, IfcUnit_FORCEUNIT, IfcUnit_FREQUENCYUNIT, IfcUnit_ILLUMINANCEUNIT, IfcUnit_INDUCTANCEUNIT, IfcUnit_LENGTHUNIT, IfcUnit_LUMINOUSFLUXUNIT, IfcUnit_LUMINOUSINTENSITYUNIT, IfcUnit_MAGNETICFLUXDENSITYUNIT, IfcUnit_MAGNETICFLUXUNIT, IfcUnit_MASSUNIT, IfcUnit_PLANEANGLEUNIT, IfcUnit_POWERUNIT, IfcUnit_PRESSUREUNIT, IfcUnit_RADIOACTIVITYUNIT, IfcUnit_SOLIDANGLEUNIT, IfcUnit_THERMODYNAMICTEMPERATUREUNIT, IfcUnit_TIMEUNIT, IfcUnit_VOLUMEUNIT, IfcUnit_USERDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcUnitaryEquipmentTypeEnum {
/// Enumeration defining the functional type of unitary equipment. 
///   The IfcUnitaryEquipmentTypeEnum contains the following:
/// 
/// AIRHANDLER: A unitary air handling unit typically containing a fan, economizer, and coils.
///   AIRCONDITIONINGUNIT: A unitary packaged air-conditioning unit typically used in residential or light commercial applications.
///   DEHUMIDIFIER: A unitary packaged dehumidification unit.  Note: units supporting multiple modes (dehumidification, cooling, and/or heating) should use AIRCONDITIONINGUNIT.
///   SPLITSYSTEM: A system which separates the compressor from the evaporator, but acts as a unitary component typically within residential or light commercial applications.
///   ROOFTOPUNIT: A packaged assembly that is either field-erected or manufactured atop the roof of a large residential or commercial building and acts as a unitary component.
///   USERDEFINED: User-defined unitary equipment type.
///   NOTDEFINED:  Undefined unitary equipment type.
/// 
/// HISTORY: New enumeration in IFC R2x.  DEHUMIDIFIER added in IFC 2x4
typedef enum {IfcUnitaryEquipmentType_AIRHANDLER, IfcUnitaryEquipmentType_AIRCONDITIONINGUNIT, IfcUnitaryEquipmentType_SPLITSYSTEM, IfcUnitaryEquipmentType_ROOFTOPUNIT, IfcUnitaryEquipmentType_USERDEFINED, IfcUnitaryEquipmentType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcValveTypeEnum {
/// The IfcValveTypeEnum defines the
///   range of different types of valve that can be specified. These are typically
///   used in conjunction with Pset_ValveTypeCommon, which contains common
///   properties for all valve types. The IfcValveTypeEnum contains:
/// 
/// AIRRELEASE: Valve used to release air from a pipe or fitting.  
///   ANTIVACUUM: Valve that opens to admit air if the pressure falls below
///   atmospheric pressure (BS6100 330 4104) 
///   CHANGEOVER: Valve that enables flow to be switched between pipelines (3 or 4
///   port). 
///   CHECK: Valve that permits water to flow in one direction only and is
///   enclosed when there is no flow (2 port). 
///   COMMISSIONING: Valve used to facilitate commissioning of a system (2 port). 
///   DIVERTING: Valve that enables flow to be diverted from one branch of a
///   pipeline to another (3 port). 
///   DOUBLECHECK: An assembly that incorporates two valves used to prevent backflow
///   (BS6100 330 4106). 
///   DOUBLEREGULATING: Valve used to facilitate regulation of fluid flow in a system.
///   DRAWOFFCOCK: A valve used to remove fluid from a piping system.
///   FAUCET: Faucet valve typically used as a flow discharge.
///   FLUSHING: Valve that flushes a predetermined quantity of water to cleanse a
///   toilet, urinal, etc.
///   GASCOCK: Valve that is used for controlling the flow of gas. 
///   GASTAP: Gas tap typically used for venting or discharging gas from a system.
///   ISOLATING: Valve that closes off flow in a pipeline. 
///   MIXING: Valve that enables flow from two branches of a pipeline to be mixed
///   together (3 port). 
///   PRESSUREREDUCING: Valve that reduces the pressure of a fluid immediately downstream
///   of its position in a pipeline to a preselected value or by a predetermined
///   ratio. 
///   PRESSURERELIEF: Spring or weight loaded valve that automatically discharges to a
///   safe place fluid that has built up to excessive pressure in pipes or
///   fittings 
///   REGULATING: Valve used to facilitate regulation of fluid flow in a system.
///   SAFETYCUTOFF: Valve that closes under the action of a safety mechanism such as a
///   drop weight, solenoid etc. 
///   STEAMTRAP: Valve that restricts flow of steam while allowing condensate to 
///   pass through. 
///   STOPCOCK: An isolating valve used on a domestic water service. 
///   USERDEFINED: User-defined valve type. 
///   NOTDEFINED: Undefined valve type. 
/// 
/// HISTORY: New type in IFC R2.0
typedef enum {IfcValveType_AIRRELEASE, IfcValveType_ANTIVACUUM, IfcValveType_CHANGEOVER, IfcValveType_CHECK, IfcValveType_COMMISSIONING, IfcValveType_DIVERTING, IfcValveType_DRAWOFFCOCK, IfcValveType_DOUBLECHECK, IfcValveType_DOUBLEREGULATING, IfcValveType_FAUCET, IfcValveType_FLUSHING, IfcValveType_GASCOCK, IfcValveType_GASTAP, IfcValveType_ISOLATING, IfcValveType_MIXING, IfcValveType_PRESSUREREDUCING, IfcValveType_PRESSURERELIEF, IfcValveType_REGULATING, IfcValveType_SAFETYCUTOFF, IfcValveType_STEAMTRAP, IfcValveType_STOPCOCK, IfcValveType_USERDEFINED, IfcValveType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcVibrationIsolatorTypeEnum {
/// Enumeration defining the typical types of vibration isolators. 
///   The IfcVibrationIsolatorTypeEnum contains the following:
/// 
/// COMPRESSION:  Compression type vibration isolator.
///   SPRING:  Spring type vibration isolator.
///   USERDEFINED:  User-defined vibration isolator type.
///   NOTDEFINED:  Undefined vibration isolator type.
/// 
/// HISTORY: New enumeration in IFC 2x2.
typedef enum {IfcVibrationIsolatorType_COMPRESSION, IfcVibrationIsolatorType_SPRING, IfcVibrationIsolatorType_USERDEFINED, IfcVibrationIsolatorType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcWallTypeEnum {
/// Definition from IAI: This enumeration defines the
/// different types of walls an IfcWallType object can
/// fulfill:
/// 
/// STANDARD: A standard wall, extruded vertically with a
/// constant thickness along the wall path.
/// POLYGONAL: A polygonal wall, extruded vertically,
/// where the wall thickness varies along the wall path.
/// SHEAR: A wall having a non-rectangular cross section
/// along the wall path.
/// 
/// NOTE The potentially misleading term shall not impose
/// a particular resistance against shear forces, but a particular
/// shape.
/// 
/// ELEMENTEDWALL: A stud wall framed with studs and faced
/// with sheatings, sidings, wallboard, or plasterwork.
/// PLUMBINGWALL: A pier, or enclosure, or encasement,
/// normally used to enclose plumbing in sanitary rooms.
/// MOVABLE: A movable wall that is either movable, e.g. a
/// folding wall, or a sliding wall, or can be easily removed as a
/// removable partitioning or mounting wall. Movable walls do
/// normally not define space boundaries and often belong to the
/// furnishing system.
/// USERDEFINED: User-defined wall element.
/// NOTDEFINED: Undefined wall element
/// 
/// HISTORY  New
/// Enumeration in Release IFC2x Edition 2.
/// IFC2x2 ADDENDUM CHANGE 
/// The enumerator POLYGON has been changed to
/// POLYGONAL.
/// IFC2x3 CHANGE  The enumerators
/// ELEMENTEDWALL and PLUMBINGWALL have been
/// added.
/// IFC2x4 CHANGE  New enumerator
/// MOVABLE has been added.
typedef enum {IfcWallType_STANDARD, IfcWallType_POLYGONAL, IfcWallType_SHEAR, IfcWallType_ELEMENTEDWALL, IfcWallType_PLUMBINGWALL, IfcWallType_USERDEFINED, IfcWallType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcWasteTerminalTypeEnum {
/// The IfcWasteTerminalTypeEnum defines the range of different types of waste terminal that can be specified. 
///   HISTORY: New type in IFC 2x2.  GREASEINTERCEPTOR, OILINTERCEPTOR, PETROLINTERCEPTOR moved to IfcInterceptorTypeEnum in IFC2x4.
/// 
/// Enumeration 	 
/// 
/// FLOORTRAP: Pipe fitting, set into the floor, that retains liquid to prevent the passage of foul air 
/// FLOOORWASTE: Pipe fitting, set into the floor, that collects waste water and discharges it to a separate trap. 
/// GULLYSUMP: Pipe fitting or assembly of fittings to receive surface water or waste water, fitted with a grating or sealed cover. 
/// GULLYTRAP: Pipe fitting or assembly of fittings to receive surface water or waste water, fitted with a grating or sealed cover and discharging through a trap (BS6100 330 3504 modified). 
/// ROOFDRAIN: Pipe fitting, set into the roof, that collects rainwater for discharge into the rainwater system.  
/// WASTEDISPOSALUNIT: Electrically operated device that reduces kitchen or other waste into fragments small enough to be flushed into a drainage system. 
/// WASTETRAP: Pipe fitting, set adjacent to a sanitary terminal, that retains liquid to prevent the passage of foul air. 
/// USERDEFINED: User-defined type. 
/// NOTDEFINED: Undefined type.
typedef enum {IfcWasteTerminalType_FLOORTRAP, IfcWasteTerminalType_FLOORWASTE, IfcWasteTerminalType_GULLYSUMP, IfcWasteTerminalType_GULLYTRAP, IfcWasteTerminalType_GREASEINTERCEPTOR, IfcWasteTerminalType_OILINTERCEPTOR, IfcWasteTerminalType_PETROLINTERCEPTOR, IfcWasteTerminalType_ROOFDRAIN, IfcWasteTerminalType_WASTEDISPOSALUNIT, IfcWasteTerminalType_WASTETRAP, IfcWasteTerminalType_USERDEFINED, IfcWasteTerminalType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcWindowPanelOperationEnum {
/// This enumeration defines the basic ways to describe how window panels operate, as shown in Figure 168. 
/// 
/// HISTORY New Enumeration in IFC Release 2.0
/// 
/// Enumerator 
///   Description 
///   Figure 
/// 
/// SideHungRightHand 
///   panel that opens to the right
///   when viewed from the outside 
///     
/// 
/// SideHungLeftHand 
///   panel that opens to the left
///   when viewed from the outside 
///     
/// 
/// TiltAndTurnRightHand 
///   panel that opens to the right
///   and is bottom hung 
///     
/// 
/// TiltAndTurnLeftHand 
///   panel that opens to the left
///   and is bottom hung 
///     
/// 
/// TopHung 
///   panel is top hung 
///     
/// 
/// BottomHung 
///   panel is bottom hung 
///     
/// 
/// PivotHorizontal 
///   panel is swinging
///   horizontally (hinges are in the middle) 
///     
/// 
/// PivotVertical 
///   panel is swinging vertically
///   (hinges are in the middle) 
///     
/// 
/// SlidingHorizontal 
///   panel is sliding horizontally
/// 
///   
/// 
/// SlidingVertical 
///   panel is sliding
///   vertically 
///     
/// 
/// RemovableCasement 
///   panel is removable 
///     
/// 
/// FixedCasement 
///   panel is fixed 
///     
/// 
/// OtherOperation 
///   user defined operation type 
///     
/// 
/// NotDefined 
///     
///     
/// 
/// Figure 168 — Window panel operations
/// 
/// The opening direction of the window panels is given by the local placement of the IfcWindow. The positive y-axis determines the direction as shown in Figure 169.
///   NOTE 
/// 
/// Figures are shown as viewed from the outside (in direction of the
///   positive y-axis). 
///   Figures (symbolic representation) depend on the national building
///   code 
///   These figures are only shown as illustrations 
/// 
/// Figure 169 — Window panel directions
typedef enum {IfcWindowPanelOperation_SIDEHUNGRIGHTHAND, IfcWindowPanelOperation_SIDEHUNGLEFTHAND, IfcWindowPanelOperation_TILTANDTURNRIGHTHAND, IfcWindowPanelOperation_TILTANDTURNLEFTHAND, IfcWindowPanelOperation_TOPHUNG, IfcWindowPanelOperation_BOTTOMHUNG, IfcWindowPanelOperation_PIVOTHORIZONTAL, IfcWindowPanelOperation_PIVOTVERTICAL, IfcWindowPanelOperation_SLIDINGHORIZONTAL, IfcWindowPanelOperation_SLIDINGVERTICAL, IfcWindowPanelOperation_REMOVABLECASEMENT, IfcWindowPanelOperation_FIXEDCASEMENT, IfcWindowPanelOperation_OTHEROPERATION, IfcWindowPanelOperation_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcWindowPanelPositionEnum {
/// This enumeration defines the basic configuration of the window type in terms of the location of window panels. The window configurations are given for windows with one, two or three panels (including fixed panels) as shown in Figure 170. It corresponds to the OperationType of the IfcWindowStyle definition, which references the IfcWindowPanelProperties. 
/// 
/// Windows which are subdivided into more than three panels have to be defined by the geometry only. The type of such windows is given by an IfcWindowStyle.OperationType = USERDEFINED or NOTDEFINED (see IfcWindowStyleOperationEnum for details). 
/// 
/// HISTORY New Enumeration in IFC Release 2.0.
/// 
/// Enumerator from IfcWindowStyleOperationEnum 
///   Use of enumerators from IfcWindowPanelPositionEnum 
///   Figure 
/// 
/// DoublePanelVertical 
///   first
///   IfcWindowPanelProperties with PanelPosition = LEFTsecond
///   IfcWindowPanelProperties with PanelPosition = RIGHT 
/// 
/// DoublePanelHorizontal 
///   first
///   IfcWindowPanelProperties with PanelPosition = TOPsecond
///   IfcWindowPanelProperties with PanelPosition = BOTTOM 
/// 
/// TriplePanelVertical 
///   first
///   IfcWindowPanelProperties with PanelPosition = LEFTsecond
///   IfcWindowPanelProperties with PanelPosition = MIDDLEthird
///   IfcWindowPanelProperties with PanelPosition = RIGHT 
/// 
/// TriplePanelHorizontal  
///   first
///   IfcWindowPanelProperties with PanelPosition = TOPsecond
///   IfcWindowPanelProperties with PanelPosition = MIDDLEthird
///   IfcWindowPanelProperties with PanelPosition = BOTTOM 
/// 
/// TriplePanelBottom 
///   first
///   IfcWindowPanelProperties with PanelPosition = LEFTsecond
///   IfcWindowPanelProperties with PanelPosition = RIGHTthird
///   IfcWindowPanelProperties with PanelPosition = BOTTOM 
/// 
/// TriplePanelTop 
///   first
///   IfcWindowPanelProperties with PanelPosition = TOPsecond
///   IfcWindowPanelProperties with PanelPosition = LEFTthird
///   IfcWindowPanelProperties with PanelPosition = RIGHT 
/// 
/// TriplePanelLeft 
///   first
///   IfcWindowPanelProperties with PanelPosition = LEFTsecond
///   IfcWindowPanelProperties with PanelPosition = TOPthird
///   IfcWindowPanelProperties with PanelPosition = BOTTOM 
/// 
/// TriplePanelRight 
///   first
///   IfcWindowPanelProperties with PanelPosition = TOPsecond
///   IfcWindowPanelProperties with PanelPosition = BOTTOMthird
///   IfcWindowPanelProperties with PanelPosition = RIGHT 
/// 
/// Figure 170 — Window panel positions
/// 
/// NOTE 
/// 
/// The figures are shown as elevations in the XZ plane of the local
///   placement of the window, looking into the direction of the positive Y
///   axis. 
///   These figures are only shown as illustrations.
typedef enum {IfcWindowPanelPosition_LEFT, IfcWindowPanelPosition_MIDDLE, IfcWindowPanelPosition_RIGHT, IfcWindowPanelPosition_BOTTOM, IfcWindowPanelPosition_TOP, IfcWindowPanelPosition_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcWindowStyleConstructionEnum {
/// Definition from IAI: This enumeration defines the
///   basic types of construction of windows. The construction
///   type relates to the main material (or material combination)
///   used for making the window.
/// 
/// HISTORY New Enumeration in
///   IFC Release 2x .
typedef enum {IfcWindowStyleConstruction_ALUMINIUM, IfcWindowStyleConstruction_HIGH_GRADE_STEEL, IfcWindowStyleConstruction_STEEL, IfcWindowStyleConstruction_WOOD, IfcWindowStyleConstruction_ALUMINIUM_WOOD, IfcWindowStyleConstruction_PLASTIC, IfcWindowStyleConstruction_OTHER_CONSTRUCTION, IfcWindowStyleConstruction_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcWindowStyleOperationEnum {
/// This enumeration defines the basic
///   configuration of the window type in terms of the number of window panels and
///   the subdivision of the total window. The window configurations are given for
///   windows with one, two or three panels (including fixed panels) as shown in Figure 171. 
///   Windows which are subdivided into more than three panels have to be
///   defined by the geometry only. The type of such windows is USERDEFINED. 
///   HISTORY New Enumeration in IFC Release 2.0. 
/// 
/// Enumerator 
///   Description 
///   Figure 
/// 
/// SinglePanel 
///   Window with one
///   panel. 
/// 
/// DoublePanelVertical 
///   Window with two panels. The
///   configuration of the panels is vertically. 
/// 
/// DoublePanelHorizontal 
///   Window with two panels. The
///   configuration of the panels is horizontally. 
/// 
/// TriplePanelVertical 
///   Window with three panels. The
///   configuration of the panels is vertically. 
/// 
/// TriplePanelHorizontal  
///   Window with three panels. The
///   configuration of the panels is horizontally. 
/// 
/// TriplePanelBottom 
///   Window with three panels. The
///   configuration of two panels is vertically and the third one is horizontally at
///   the bottom. 
/// 
/// TriplePanelTop 
///   Window with three panels. The
///   configuration of two panels is vertically and the third one is horizontally at
///   the top. 
/// 
/// TriplePanelLeft 
///   Window with three panels. The
///   configuration of two panels is horizontally and the third one is vertically at
///   the left hand side. 
/// 
/// TriplePanelRight 
///   Window with three panels. The
///   configuration of two panels is horizontally and the third one is vertically at
///   the right hand side. 
/// 
/// UserDefined 
///   user defined operation
///   type 
///     
/// 
/// NotDefined 
///     
///     
/// 
/// Figure 171 — Window style operations
/// 
/// NOTE 
/// 
/// The way how each panel operates is defined at the
///   IfcWindowPanelProperties.OperationType. 
///   The reference from the window panel to the location of that panel in
///   the window style configuration is handled by the
///   IfcWindowPanelProperties.PanelPosition. 
///   The figures are shown as elevations in the XZ plane of the local
///   placement of the window, looking into the direction of the positive Y
///   axis. 
///   These figures are only shown as illustrations
typedef enum {IfcWindowStyleOperation_SINGLE_PANEL, IfcWindowStyleOperation_DOUBLE_PANEL_VERTICAL, IfcWindowStyleOperation_DOUBLE_PANEL_HORIZONTAL, IfcWindowStyleOperation_TRIPLE_PANEL_VERTICAL, IfcWindowStyleOperation_TRIPLE_PANEL_BOTTOM, IfcWindowStyleOperation_TRIPLE_PANEL_TOP, IfcWindowStyleOperation_TRIPLE_PANEL_LEFT, IfcWindowStyleOperation_TRIPLE_PANEL_RIGHT, IfcWindowStyleOperation_TRIPLE_PANEL_HORIZONTAL, IfcWindowStyleOperation_USERDEFINED, IfcWindowStyleOperation_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
struct IfcWorkControlTypeEnum {

typedef enum {IfcWorkControlType_ACTUAL, IfcWorkControlType_BASELINE, IfcWorkControlType_PLANNED, IfcWorkControlType_USERDEFINED, IfcWorkControlType_NOTDEFINED} Value;
IFC_PARSE_API static const char* ToString(Value v);
IFC_PARSE_API static Value FromString(const std::string& s);
};
/// IfcAbsorbedDoseMeasure is a measure of the absorbed radioactivity dose.
/// Usually measured in Gray (Gy, J/kg).
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2x.
class IFC_PARSE_API IfcAbsorbedDoseMeasure : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcAbsorbedDoseMeasure (IfcEntityInstanceData* e);
    IfcAbsorbedDoseMeasure (double v);
    operator double() const;
};
/// IfcAccelerationMeasure is a measure of acceleration.
/// Usually measured in m/s2.
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2x.
class IFC_PARSE_API IfcAccelerationMeasure : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcAccelerationMeasure (IfcEntityInstanceData* e);
    IfcAccelerationMeasure (double v);
    operator double() const;
};
/// Definition from ISO/CD 10303-41:1992: An amount of substance measure is the value for the quantity  of a substance when compared with the number of atoms in 0.012kilogram of carbon 12.
/// 
/// Usually measure in mole (mol).
/// Type: REAL
/// 
/// NOTE Corresponding ISO 10303 name: amount_of_substance_measure, please refer to ISO/IS 10303-41 for the final definition of the formal standard.
/// 
/// HISTORY New type in IFC Release 1.5.1.
class IFC_PARSE_API IfcAmountOfSubstanceMeasure : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcAmountOfSubstanceMeasure (IfcEntityInstanceData* e);
    IfcAmountOfSubstanceMeasure (double v);
    operator double() const;
};
/// IfcAngularVelocityMeasure is a measure of the velocity of a body measured in terms of angle subtended per unit time.
/// Usually measured in radians/s.
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2.0.
class IFC_PARSE_API IfcAngularVelocityMeasure : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcAngularVelocityMeasure (IfcEntityInstanceData* e);
    IfcAngularVelocityMeasure (double v);
    operator double() const;
};
/// Definition from ISO/CD 10303-41:1992: An area measure is the value of the extent of a surface.
/// Usually measured in square metre (m2).
/// Type: REAL
/// 
/// NOTE Corresponding ISO 10303 name: area_measure, please refer to ISO/IS 10303-41 for the final definition of the formal standard.
/// 
/// HISTORY New type in IFC Release 1.5.1.
class IFC_PARSE_API IfcAreaMeasure : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcAreaMeasure (IfcEntityInstanceData* e);
    IfcAreaMeasure (double v);
    operator double() const;
};
/// IfcBoolean is a defined data type of simple data type Boolean. It is required since a select type (IfcSimpleValue) cannot directly include simple types in its select list.  A boolean type can have value TRUE or FALSE.
/// 
/// Type: BOOLEAN
/// 
/// HISTORY New type in IFC Release 1.5.1.
class IFC_PARSE_API IfcBoolean : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcBoolean (IfcEntityInstanceData* e);
    IfcBoolean (bool v);
    operator bool() const;
};
/// IfcComplexNumber is a representation of a complex number expressed as an array with two elements.
///   The first element (index 1) denotes the real component which is the numerical
///   component of a complex number whose square roots can be calculated explicitly.
///   The second element (index 2) denotes the imaginary component which is the numerical
///   component of a complex number whose square roots cannot be determined other
///   than through the provision of the square of the imaginary number j where j^2 = -1.
///   Note that the imaginary component may be referred to as i in certain references.
/// 
/// Type: ARRAY [1:2] OF REAL
/// 
/// HISTORY New type in IFC Release 2x2.
class IFC_PARSE_API IfcComplexNumber : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcComplexNumber (IfcEntityInstanceData* e);
    IfcComplexNumber (std::vector< double > /*[1:2]*/ v);
    operator std::vector< double > /*[1:2]*/() const;
};
/// IfcCompoundPlaneAngleMeasure is a compound measure of plane angle in degrees, minutes, seconds, and optionally millionth-seconds of arc.
/// 
/// NOTE: IfcCompoundPlaneAngleMeasure is used where angles need to be described to an accuracy as fine as one millionth of a degree and expressed as parts of an arc. It may be used for angular measurement by surveyors or for other angular measurements where precision is required. Another usage is exact or approximate global positioning against a geographic coordinate systems using longitude and latitude.
/// 
/// NOTE: While the unit of measurement of the type IfcPlaneAngleMeasure depends on unit assignment (radian or degree or other derived units; globally at the IfcPoject or locally at an IfcMeasureWithUnit), the units of IfcCompoundPlaneAngleMeasure are always degrees, minutes, seconds, and millionth-seconds irrespective of unit assignments.
/// 
/// HISTORY New type in IFC Release 1.5.1.
/// 
/// Type: LIST [3:4] OF INTEGER
/// 
/// Value restrictions
/// 
/// The first integer measure is the number of degrees and is generally not range-restricted.  However, when IfcCompoundPlaneAngleMeasure is used to express geographic coordinates, only latitudes of [-90, 90] and longitudes of [-180, 180] are used in practice.
/// The second integer measure is the number of minutes and shall be in the range (-60, 60).
/// The third integer measure is the number of seconds and shall be in the range (-60, 60).
/// The optional fourth integer measure is the number of millionth-seconds and shall be in the range (-1 000 000, 1 000 000).
/// 
/// Signedness
/// 
/// All measure components have the same sign (positive or negative).  It is therefore trivial to convert between floating point representation (decimal degrees) and compound representation regardless whether the angle is greater or smaller than zero.  Example:
/// 
/// LOCAL
///   a : IfcPlaneAngleMeasure := -50.975864;  (* decimal degrees, -50° 58' 33" 110400 *)
///   b : IfcPlaneAngleMeasure;
///   c : IfcCompoundPlaneAngleMeasure;
///   s : IfcText;
/// END_LOCAL;
/// 
/// (* convert from float to compound *)
///   c[1] :=    a;                                           -- -50
///   c[2] :=   (a - c[1]) * 60;                              -- -58
///   c[3] :=  ((a - c[1]) * 60 - c[2]) * 60;                 -- -33
///   c[4] := (((a - c[1]) * 60 - c[2]) * 60 - c[3]) * 1.e6;  -- -110400
/// 
/// (* convert from compound to float *)
///   b := c[1] + c[2]/60. + c[3]/3600. + c[4]/3600.e6;       -- -50.975864
/// 
/// Use in string representations
/// 
/// When a compound plane angle measure is formatted for display or printout, the signs of the fractional components will usually be discarded because, to a human reader, the sign of the first component alone already indicates the sense of the angle:
/// 
/// (* convert from compound to human-readable string *)
///   s := FORMAT(c[1], '+##')     + "000000B0"
///      + FORMAT(ABS(c[2]), '##') + ''''
///      + FORMAT(ABS(c[3]), '##') + '"'
///      + FORMAT(ABS(c[4]), '##');  -- -50° 58' 33" 110400
/// 
/// Another often encountered display format of latitudes and longitudes is to omit the signs and print N, S, E, W indicators instead, for example, 50°58'33"S.  When stored as IfcCompoundPlaneAngleMeasure however, a compound plane angle measure is always signed, with same sign of all components.
class IFC_PARSE_API IfcCompoundPlaneAngleMeasure : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcCompoundPlaneAngleMeasure (IfcEntityInstanceData* e);
    IfcCompoundPlaneAngleMeasure (std::vector< int > /*[3:4]*/ v);
    operator std::vector< int > /*[3:4]*/() const;
};
/// Definition from ISO/CD 10303-41:1992: Is the value of a physical quantity as defined by an application context.
/// Type: REAL
/// 
/// NOTE Corresponding ISO 10303 name: context_dependent_measure, please refer to ISO/IS 10303-41 for the final definition of the formal standard.
/// 
/// HISTORY New type in IFC Release 1.5.1.
class IFC_PARSE_API IfcContextDependentMeasure : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcContextDependentMeasure (IfcEntityInstanceData* e);
    IfcContextDependentMeasure (double v);
    operator double() const;
};
/// Definition from ISO/CD 10303-41:1992: A count measure is the value of a count.
/// Type: NUMBER
/// 
/// NOTE Corresponding ISO 10303 name: count_measure, please refer to ISO/IS 10303-41 for the final definition of the formal standard.
/// 
/// HISTORY New type in IFC Release 1.5.1.
class IFC_PARSE_API IfcCountMeasure : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcCountMeasure (IfcEntityInstanceData* e);
    IfcCountMeasure (double v);
    operator double() const;
};
/// IfcCurvatureMeasure is a measure for curvature, which is defined as the change of slope per length.
///   This is typically a computed value in structural analysis.
///   It is usually measured in rad/m.
/// 
/// Type: REAL
/// 
/// HISTORY New type in IFC2x2.
class IFC_PARSE_API IfcCurvatureMeasure : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcCurvatureMeasure (IfcEntityInstanceData* e);
    IfcCurvatureMeasure (double v);
    operator double() const;
};
/// Definition from IAI: The IfcDayInMonthNumber is
/// an integer that defines the position of the specified day in a
/// month.
/// Type: INTEGER
/// NOTE Corresponding STEP
/// name: day_in_month_number, please refer to ISO/IS 10303-41:1994
/// for the final definition of the formal
/// standard.
/// HISTORY New type in IFC
/// Release 1.5.1.
/// IFC2x4 CHANGE Where rule
/// ValidRange added.
class IFC_PARSE_API IfcDayInMonthNumber : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcDayInMonthNumber (IfcEntityInstanceData* e);
    IfcDayInMonthNumber (int v);
    operator int() const;
};

class IFC_PARSE_API IfcDaylightSavingHour : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcDaylightSavingHour (IfcEntityInstanceData* e);
    IfcDaylightSavingHour (int v);
    operator int() const;
};
/// Definition from ISO/CD 10303-41:1992: A descriptive measure is a human interpretable definition of a quantifiable value.
/// Type: STRING
/// 
/// NOTE Corresponding ISO 10303 name:descriptive_measure, please refer to ISO/IS 10303-41 for the final definition of the formal standard.
/// 
/// HISTORY New type in IFC Release 1.5.1.
class IFC_PARSE_API IfcDescriptiveMeasure : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcDescriptiveMeasure (IfcEntityInstanceData* e);
    IfcDescriptiveMeasure (std::string v);
    operator std::string() const;
};
/// Definition from ISO/CD 10303-42:1992: A dimension count is a positive integer used to define the coordinate space dimensionality.  
/// 
/// The IfcDimensionCount is restricted to have the dimensionality of either 1, 2, or 3 - the WR1 had been added as an addition to the ISO 10303:42 entity dimension_count. In contrary to the ISO 10303:42 constraint, that all geometric representation items within a geometric representation context are forced to have the same dimension count, the IFC geometry allows mixed dimensions, particularly when defining the boundary of planar surfaces.  
/// 
/// NOTE Corresponding ISO 10303 type: dimension_count, please refer to ISO/IS 10303-42:1994, p. 14 for the final definition of the formal standard.
/// 
/// HISTORY New Type in IFC Release 1.5
class IFC_PARSE_API IfcDimensionCount : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcDimensionCount (IfcEntityInstanceData* e);
    IfcDimensionCount (int v);
    operator int() const;
};
/// IfcDoseEquivalentMeasure is a measure of the radioactive dose equivalent.
/// Usually measured in Sievert (Sv, J/kg).
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2x.
class IFC_PARSE_API IfcDoseEquivalentMeasure : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcDoseEquivalentMeasure (IfcEntityInstanceData* e);
    IfcDoseEquivalentMeasure (double v);
    operator double() const;
};
/// IfcDynamicViscosityMeasure is a measure of the viscous resistance of a medium.
/// 
/// Usually measured in Pascal second (Pa s).
/// Type: REAL 
/// 
/// HISTORY New type in IFC Release 2.0.
class IFC_PARSE_API IfcDynamicViscosityMeasure : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcDynamicViscosityMeasure (IfcEntityInstanceData* e);
    IfcDynamicViscosityMeasure (double v);
    operator double() const;
};
/// IfcElectricCapacitanceMeasure is a measure of the electric capacitance.
/// Usually measured in Farad (F, C/V = A s/V).
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2x.
class IFC_PARSE_API IfcElectricCapacitanceMeasure : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcElectricCapacitanceMeasure (IfcEntityInstanceData* e);
    IfcElectricCapacitanceMeasure (double v);
    operator double() const;
};
/// IfcElectricChargeMeasure is a measure of the electric charge.
/// Usually measured in Coulomb (C, A s).
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2x.
class IFC_PARSE_API IfcElectricChargeMeasure : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcElectricChargeMeasure (IfcEntityInstanceData* e);
    IfcElectricChargeMeasure (double v);
    operator double() const;
};
/// IfcElectricConductanceMeasure is a measure of the electric conductance.
/// Usually measured in Siemens (S, 1/Ohm = A/V).
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2x.
class IFC_PARSE_API IfcElectricConductanceMeasure : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcElectricConductanceMeasure (IfcEntityInstanceData* e);
    IfcElectricConductanceMeasure (double v);
    operator double() const;
};
/// Definition from ISO/CD 10303-41:1992: The value for the movement of electrically charged particles.
/// Usually measured in Ampere (A).
/// Type: REAL
/// 
/// NOTE Corresponding ISO 10303 name: electric_current_measure, please refer to ISO/IS 10303-41 for the final definition of the formal standard.
/// 
/// HISTORY New type in IFC Release 1.5.1.
class IFC_PARSE_API IfcElectricCurrentMeasure : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcElectricCurrentMeasure (IfcEntityInstanceData* e);
    IfcElectricCurrentMeasure (double v);
    operator double() const;
};
/// IfcElectricResistanceMeasure is a measure of the electric resistance.
/// Usually measured in Ohm (V/A).
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2x.
class IFC_PARSE_API IfcElectricResistanceMeasure : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcElectricResistanceMeasure (IfcEntityInstanceData* e);
    IfcElectricResistanceMeasure (double v);
    operator double() const;
};
/// IfcElectricVoltageMeasure is a measure of electromotive force.
/// Usually measured in Volts (V, W/A).
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2.0.
class IFC_PARSE_API IfcElectricVoltageMeasure : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcElectricVoltageMeasure (IfcEntityInstanceData* e);
    IfcElectricVoltageMeasure (double v);
    operator double() const;
};
/// IfcEnergyMeasure is a measure of energy required or used.
/// Usually measured in Joules, (J, Nm).
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2.0.
class IFC_PARSE_API IfcEnergyMeasure : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcEnergyMeasure (IfcEntityInstanceData* e);
    IfcEnergyMeasure (double v);
    operator double() const;
};
/// Definition from CSS1 (W3C Recommendation): The font-style property selects between normal (sometimes
/// referred to as "roman" or "upright"), italic and oblique faces within a font family. Values are:
/// 
/// normal 
///   italic 
///   oblique
/// 
/// A value of 'normal' selects a font that is classified as 'normal' in the user agents font database, while 'oblique' selects a font that is labeled 'oblique'. A value of 'italic' selects a font that is labeled 'italic', or, if that is not available, one labeled 'oblique'. The font that is labeled 'oblique' in the user agents font database may actually have been generated by electronically slanting a normal font.
/// 
/// Fonts with Oblique, Slanted or Incline in their names will typically be labeled 'oblique' in the user agents font database. Fonts with Italic, Cursive or Kursiv in their names will typically be labeled 'italic'.
/// 
/// NOTE  Corresponding CSS1 definitions is font-style.
/// 
/// HISTORY  New type in IFC2x3.
class IFC_PARSE_API IfcFontStyle : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcFontStyle (IfcEntityInstanceData* e);
    IfcFontStyle (std::string v);
    operator std::string() const;
};
/// Definition from CSS1 (W3C Recommendation): The font-style property selects between normal and small-caps within a font family. Values are:
/// 
/// normal 
///   small-caps 
/// 
/// Another type of variation within a font family is the small-caps. In a small-caps font the lower case letters look similar to the uppercase ones, but in a smaller size and with slightly different proportions. The 'font-variant' property selects that font.
/// 
/// A value of 'normal' selects a font that is not a small-caps font, 'small-caps' selects a small-caps font. It is acceptable (but not required) in CSS1 if the small-caps font is a created by taking a normal font and replacing the lower case letters by scaled uppercase characters. As a last resort, uppercase letters will be used as replacement for a small-caps font.
/// 
/// NOTE  Corresponding CSS1 definitions is font-variant.
/// 
/// HISTORY  New type in IFC2x3.
class IFC_PARSE_API IfcFontVariant : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcFontVariant (IfcEntityInstanceData* e);
    IfcFontVariant (std::string v);
    operator std::string() const;
};
/// Definition from CSS1 (W3C Recommendation): The 'font-weight' property selects the weight of the font. The values '100' to '900' form an ordered sequence, where each number indicates a weight that is at least as dark as its predecessor. The keyword 'normal' is synonymous with '400', and 'bold' is synonymous with '700'. Keywords other than 'normal' and 'bold' have been shown to be often confused with font names and a numerical scale was therefore chosen for the 9-value list. Values are:
/// 
/// normal 
///   bold 
///   100 | 200 | 300 | 400 | 500 | 600 | 700 | 800 | 900
/// 
/// Fonts (the font data) typically have one or more properties whose values are names that are descriptive of the "weight" of a font. There is no accepted, universal meaning to these weight names. Their primary role is to distinguish faces of differing darkness within a single font family. Usage across font families is quite variant; for example a font that you might think of as being bold might be described as being Regular, Roman, Book, Medium, Semi- or DemiBold, Bold, or Black, depending on how black the "normal" face of the font is within the design. Because there is no standard usage of names, the weight property values in CSS1 are given on a numerical scale in which the value '400' (or 'normal') corresponds to the "normal" text face for that family. The weight name associated with that face will typically be Book, Regular, Roman, Normal or sometimes Medium.
/// 
/// The association of other weights within a family to the numerical weight values is intended only to preserve the ordering of darkness within that family. However, the following heuristics tell how the assignment is done in typical cases:
/// 
/// If the font family already uses a numerical scale with nine values (such as with OpenType), the font weights should be mapped directly. 
///   If there is both a face labeled Medium and one labeled Book, Regular, Roman or Normal, then the Medium is normally assigned to the '500'. 
///   The font labeled "Bold" will often correspond to the weight value '700'. 
///   If there are fewer then 9 weights in the family, the default algorithm for filling the "holes" is as follows. If '500' is unassigned, it will be assigned the same font as '400'. If any of the values '600', '700', '800' or '900' remains unassigned, they are assigned to the same face as the next darker assigned keyword, if any, or the next lighter one otherwise. If any of '300', '200' or '100' remains unassigned, it is assigned to the next lighter assigned keyword, if any, or the next darker otherwise. 
/// 
/// The following two examples illustrate the process. Assume four weights in the "Example1" family, from lightest to darkest: Regular, Medium, Bold, Heavy. And assume six weights in the "Example2" family: Book, Medium, Bold, Heavy, Black, ExtraBlack. Note how in the second example it has been decided not to assign "Example2 ExtraBlack" to anything.
/// 
/// Available faces       | Assignments   | Filling the holes----------------------+---------------+-------------------"Example1 Regular"    | 400           | 100, 200, 300"Example1 Medium"     | 500           |"Example1 Bold"       | 700           | 600"Example1 Heavy"      | 800           | 900
/// Available faces       | Assignments   | Filling the holes----------------------+---------------+-------------------"Example2 Book"       | 400           | 100, 200, 300"Example2 Medium"     | 500           |"Example2 Bold"       | 700           | 600 "Example2 Heavy"      | 800           |"Example2 Black"      | 900           |"Example2 ExtraBlack" | (none)        |
/// 
/// NOTE  Corresponding CSS1 definitions is font-weight.
/// 
/// HISTORY  New type in IFC2x2 Addendum 2.
class IFC_PARSE_API IfcFontWeight : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcFontWeight (IfcEntityInstanceData* e);
    IfcFontWeight (std::string v);
    operator std::string() const;
};
/// IfcForceMeasure is a measure of the force.
/// Usually measured in Newton (N, kg m/s2).
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2x.
class IFC_PARSE_API IfcForceMeasure : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcForceMeasure (IfcEntityInstanceData* e);
    IfcForceMeasure (double v);
    operator double() const;
};
/// IfcFrequencyMeasure is a measure of the number of times that an item vibrates in unit time.
/// Usually measured in cycles/s or Herz (Hz).
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2.0.
class IFC_PARSE_API IfcFrequencyMeasure : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcFrequencyMeasure (IfcEntityInstanceData* e);
    IfcFrequencyMeasure (double v);
    operator double() const;
};
/// An IfcGloballyUniqueId holds an encoded string identifier that is used to uniquely identify an IFC object. An IfcGloballyUniqueId is a Globally
///   Unique Identifier (GUID) which is an auto-generated 128-bit number. Since this identifier is
///   required for all IFC object instances, it is desirable to compress it to reduce overhead. The encoding of the base 64 character set is shown below:
/// 
///            1         2         3         4         5         6
/// 
///  0123456789012345678901234567890123456789012345678901234567890123
/// 
/// "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz_$";
/// 
/// The resulting string is a fixed 22 character length string to be exchanged within the IFC exchange file structure.
/// 
/// Refer to the BuildingSMART website (www.buildingsmart-tech.org) for more information and sample encoding algorithms.
/// 
/// HISTORY  New type in IFC R1.5.1.
class IFC_PARSE_API IfcGloballyUniqueId : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcGloballyUniqueId (IfcEntityInstanceData* e);
    IfcGloballyUniqueId (std::string v);
    operator std::string() const;
};
/// IfcHeatFluxDensityMeasure is a measure of the density of heat flux within a body.
/// Usually measured in W/m2 (J/s m2).
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2.0.
class IFC_PARSE_API IfcHeatFluxDensityMeasure : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcHeatFluxDensityMeasure (IfcEntityInstanceData* e);
    IfcHeatFluxDensityMeasure (double v);
    operator double() const;
};
/// IfcHeatingValueMeasure defines the amount of energy released (usually in MJ/kg) when a fuel is burned.
/// 
/// HISTORY: This is new type in IFC2x2.
class IFC_PARSE_API IfcHeatingValueMeasure : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcHeatingValueMeasure (IfcEntityInstanceData* e);
    IfcHeatingValueMeasure (double v);
    operator double() const;
};

class IFC_PARSE_API IfcHourInDay : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcHourInDay (IfcEntityInstanceData* e);
    IfcHourInDay (int v);
    operator int() const;
};
/// Definition from ISO/CD 10303-41:1992: An identifier is an alphanumeric string which allows an individual thing to be identified. It may not provide natural-language meaning.
/// 
/// Type: STRING of up to 255 characters
/// 
/// NOTE Corresponding STEP name: identifier, please refer to ISO/IS 10303-41 for the final definition of the formal standard.
/// 
/// HISTORY New type in IFC Release 2x.
/// IFC 2x4 CHANGE: Previously recommended size restriction of 255 characters is now mandatory.
/// 
/// As a merely machine-readable string for identification purposes, an identifier is usually machine-generated and locale-independent (in contrast to human-readable labels, IfcLabel).
/// 
/// Per ISO 10303-11, the set of characters that may appear in STRINGs is defined in ISO 10646.  The encoding of characters in case of file-based exchange is defined in ISO 10303-21 (STEP physical files) and ISO 10303-28 (XML files).  Among else, these specifications define the encoding of 8-bit characters from ISO 8859-1...-16 and of 2-byte Unicode characters.
/// 
/// Note that while IfcIdentifier is restricted to 255 characters, the size in exchange files after encoding may be considerably larger than 255 octets, depending on the particular encoding and on the contents of the identifier.
class IFC_PARSE_API IfcIdentifier : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcIdentifier (IfcEntityInstanceData* e);
    IfcIdentifier (std::string v);
    operator std::string() const;
};
/// IfcIlluminanceMeasure is a measure of the illuminance.
/// Usually measured in Lux (lx, Lumen/m2 = Candela Steradian/m2).
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2x.
class IFC_PARSE_API IfcIlluminanceMeasure : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcIlluminanceMeasure (IfcEntityInstanceData* e);
    IfcIlluminanceMeasure (double v);
    operator double() const;
};
/// IfcInductanceMeasure is a measure of the inductance.
/// Usually measure in Henry (H, Weber/A = V s/A).
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2x.
class IFC_PARSE_API IfcInductanceMeasure : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcInductanceMeasure (IfcEntityInstanceData* e);
    IfcInductanceMeasure (double v);
    operator double() const;
};
/// IfcInteger is a defined type of simple data type Integer. It is required since a select type (IfcSimpleValue) cannot include directly simple types in its select list.
/// 
/// In principle, the domain of IfcInteger (being an Integer) is all integer numbers. Here the number of bits used for the IfcInteger representation is unconstrained, but in practice it is implementation specific.
/// 
/// Type: INTEGER
/// 
/// HISTORY New type in IFC Release 1.5.1.
class IFC_PARSE_API IfcInteger : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcInteger (IfcEntityInstanceData* e);
    IfcInteger (int v);
    operator int() const;
};
/// IfcIntegerCountRateMeasure is a measure of the integer number of units flowing per unit time.
/// 
/// EXAMPLE: This measure may be used for measuring integer units per second or per hour. For example, it may be used to measure the number of books per hour passing along a part of a mechanical book handling system, the number of people per hour travelling along a moving walkway or the number of vehicles per hour travelling along a section of road.
/// 
/// Type: INTEGER
/// 
/// HISTORY New type in IFC Release 2.0.
class IFC_PARSE_API IfcIntegerCountRateMeasure : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcIntegerCountRateMeasure (IfcEntityInstanceData* e);
    IfcIntegerCountRateMeasure (int v);
    operator int() const;
};
/// IfcIonConcentrationMeasure is a measure of particular ion concentration in a liquid, given in mg/L.
/// 
/// HISTORY: New type in IFC2x2.
class IFC_PARSE_API IfcIonConcentrationMeasure : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcIonConcentrationMeasure (IfcEntityInstanceData* e);
    IfcIonConcentrationMeasure (double v);
    operator double() const;
};
/// IfcIsothermalMoistureCapacityMeasure is a measure of isothermal moisture capacity.
/// Usually measured in m3/kg.
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2x.
class IFC_PARSE_API IfcIsothermalMoistureCapacityMeasure : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcIsothermalMoistureCapacityMeasure (IfcEntityInstanceData* e);
    IfcIsothermalMoistureCapacityMeasure (double v);
    operator double() const;
};
/// IfcKinematicViscosityMeasure is a measure of the viscous resistance of a medium to a moving body.
/// Usually measured in m2/s.
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2.0.
class IFC_PARSE_API IfcKinematicViscosityMeasure : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcKinematicViscosityMeasure (IfcEntityInstanceData* e);
    IfcKinematicViscosityMeasure (double v);
    operator double() const;
};
/// Definition from ISO/CD 10303-41:1992: A label is the term by which something may be referred to.  It is a string which represents the human-interpretable name of something and shall have a natural-language meaning.
/// 
/// Type: STRING of up to 255 characters
/// 
/// NOTE Corresponding STEP name: label, please refer to ISO/IS 10303-41 for the final definition of the formal standard.
/// 
/// HISTORY New type in IFC Release 2x.
/// IFC 2x4 CHANGE: Previously recommended size restriction of 255 characters is now mandatory.
/// 
/// As a human-readable string for naming purposes, a label is usually human-specified and locale-dependent (in contrast to purely machine-readable identifiers, IfcIdentifier).
/// 
/// Per ISO 10303-11, the set of characters that may appear in STRINGs is defined in ISO 10646.  The encoding of characters in case of file-based exchange is defined in ISO 10303-21 (STEP physical files) and ISO 10303-28 (XML files).  Among else, these specifications define the encoding of 8-bit characters from ISO 8859-1...-16 and of 2-byte Unicode characters.
/// 
/// Note that while IfcLabel is restricted to 255 characters, the size in exchange files after encoding may be considerably larger than 255 octets, depending on the particular encoding and on the contents of the label.
class IFC_PARSE_API IfcLabel : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcLabel (IfcEntityInstanceData* e);
    IfcLabel (std::string v);
    operator std::string() const;
};
/// Definition from ISO/CD 10303-41:1992: A length measure is the value of a distance.
/// Usually measured in millimeters (mm).
/// Type: REAL
/// 
/// NOTE Corresponding ISO 10303 name: length_measure, please refer to ISO/IS 10303-41 for the final definition of the formal standard.
/// 
/// HISTORY New type in IFC Release 1.5.1.
class IFC_PARSE_API IfcLengthMeasure : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcLengthMeasure (IfcEntityInstanceData* e);
    IfcLengthMeasure (double v);
    operator double() const;
};
/// IfcLinearForceMeasure is a measure of linear force.
/// Usually measured in N/m.
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2x.
class IFC_PARSE_API IfcLinearForceMeasure : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcLinearForceMeasure (IfcEntityInstanceData* e);
    IfcLinearForceMeasure (double v);
    operator double() const;
};
/// IfcLinearMomentMeasure is a measure of linear moment.
/// Usually measured in Nm/m.
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2x.
class IFC_PARSE_API IfcLinearMomentMeasure : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcLinearMomentMeasure (IfcEntityInstanceData* e);
    IfcLinearMomentMeasure (double v);
    operator double() const;
};
/// IfcLinearStiffnessMeasureA measure of linear stiffness.
/// Usually measured in N/m.
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2x.
class IFC_PARSE_API IfcLinearStiffnessMeasure : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcLinearStiffnessMeasure (IfcEntityInstanceData* e);
    IfcLinearStiffnessMeasure (double v);
    operator double() const;
};
/// IfcLinearVelocityMeasure is a measure of the velocity of a body measured in terms of distance moved per unit time.
/// Usually measured in m/s.
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2.0.
class IFC_PARSE_API IfcLinearVelocityMeasure : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcLinearVelocityMeasure (IfcEntityInstanceData* e);
    IfcLinearVelocityMeasure (double v);
    operator double() const;
};
/// IfcLogical</iL is a defined type of simple type Logical. It is required since a select type (IfcSimpleValue) cannot directly include simple types in its select list). Logical datatype can have values TRUE, FALSE or UNKNOWN.
/// 
/// Type: LOGICAL
/// 
/// HISTORY New type in IFC Release 2x.
class IFC_PARSE_API IfcLogical : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcLogical (IfcEntityInstanceData* e);
    IfcLogical (bool v);
    operator bool() const;
};
/// IfcLuminousFluxMeasure is a measure of the luminous flux.
/// Usually measured in Lumen (lm, Candela Steradian).
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2x.
class IFC_PARSE_API IfcLuminousFluxMeasure : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcLuminousFluxMeasure (IfcEntityInstanceData* e);
    IfcLuminousFluxMeasure (double v);
    operator double() const;
};
/// IfcLuminousIntensityDistributionMeasure is a measure of the luminous intensity of a light source that changes according to the direction of the ray. It is normally based on some standardized distribution light distribution curves. 
/// 
/// Usually measured in Candela/Lumen (cd/lm) or (cd/klm).  
/// 
/// Type: REAL  
/// 
/// HISTORY New type in IFC2x2.
class IFC_PARSE_API IfcLuminousIntensityDistributionMeasure : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcLuminousIntensityDistributionMeasure (IfcEntityInstanceData* e);
    IfcLuminousIntensityDistributionMeasure (double v);
    operator double() const;
};
/// Definition from ISO/CD 10303-41:1992: A luminous intensity measure is the value for the brightness of a body.
/// Usually measured in candela (cd).
/// Type: REAL
/// 
/// NOTE Corresponding ISO 10303 name: luminous_intensity_measure, please refer to ISO/IS 10303-41 for the final definition of the formal standard.
/// 
/// HISTORY New type in IFC Release 1.5.1.
class IFC_PARSE_API IfcLuminousIntensityMeasure : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcLuminousIntensityMeasure (IfcEntityInstanceData* e);
    IfcLuminousIntensityMeasure (double v);
    operator double() const;
};
/// IfcMagneticFluxDensityMeasure is a measure of the magnetic flux density.
/// Usually measured in Tesla (T, Weber/m2 = V s/m2).
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2x.
class IFC_PARSE_API IfcMagneticFluxDensityMeasure : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcMagneticFluxDensityMeasure (IfcEntityInstanceData* e);
    IfcMagneticFluxDensityMeasure (double v);
    operator double() const;
};
/// IfcMagneticFluxMeasure is a measure of the magnetic flux.
/// Usually measured in Weber (Wb, V s).
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2x.
class IFC_PARSE_API IfcMagneticFluxMeasure : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcMagneticFluxMeasure (IfcEntityInstanceData* e);
    IfcMagneticFluxMeasure (double v);
    operator double() const;
};
/// IfcMassDensityMeasure is a measure of the density of a medium.
/// Usually measured in kg/m3.
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2.0.
class IFC_PARSE_API IfcMassDensityMeasure : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcMassDensityMeasure (IfcEntityInstanceData* e);
    IfcMassDensityMeasure (double v);
    operator double() const;
};
/// IfcMassFlowRateMeasure is a measure of the mass of a medium flowing per unit time.
/// Usually measured in kg/s.
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2.0.
class IFC_PARSE_API IfcMassFlowRateMeasure : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcMassFlowRateMeasure (IfcEntityInstanceData* e);
    IfcMassFlowRateMeasure (double v);
    operator double() const;
};
/// Definition from ISO/CD 10303-41:1992: A mass measure is the value of the amount of matter that a body contains.
/// Usually measured in kilograms (kg) or grams (g).
/// Type: REAL
/// 
/// NOTE Corresponding ISO 10303 name: mass_measure, please refer to ISO/IS 10303-41 for the final definition of the formal standard.
/// 
/// HISTORY New type in IFC Release 1.5.1.
class IFC_PARSE_API IfcMassMeasure : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcMassMeasure (IfcEntityInstanceData* e);
    IfcMassMeasure (double v);
    operator double() const;
};
/// IfcMassPerLengthMeasure is a measure for mass per length. For example for rolled steel profiles the weight of
///   an imaginary beam is usually expressed by kg/m length for cost calculation and
///   structural analysis purposes.
/// 
/// Type: REAL
/// 
/// HISTORY New type in IFC2x2.
class IFC_PARSE_API IfcMassPerLengthMeasure : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcMassPerLengthMeasure (IfcEntityInstanceData* e);
    IfcMassPerLengthMeasure (double v);
    operator double() const;
};

class IFC_PARSE_API IfcMinuteInHour : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcMinuteInHour (IfcEntityInstanceData* e);
    IfcMinuteInHour (int v);
    operator int() const;
};
/// IfcModulusOfElasticityMeasure is a measure of modulus of elasticity.
/// Usually measured in N/m2.
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2x.
class IFC_PARSE_API IfcModulusOfElasticityMeasure : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcModulusOfElasticityMeasure (IfcEntityInstanceData* e);
    IfcModulusOfElasticityMeasure (double v);
    operator double() const;
};
/// IfcModulusOfLinearSubgradeReactionMeasure is a measure for modulus of linear subgrade reaction, which expresses the elastic bedding of a linear structural element per length, such as for a beam. It is typically measured in N/m^2.
/// 
/// Type: REAL  
/// 
/// HISTORY New type in IFC Release 2x2.
class IFC_PARSE_API IfcModulusOfLinearSubgradeReactionMeasure : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcModulusOfLinearSubgradeReactionMeasure (IfcEntityInstanceData* e);
    IfcModulusOfLinearSubgradeReactionMeasure (double v);
    operator double() const;
};
/// IfcModulusOfRotationalSubgradeReactionMeasure is a measure for modulus of rotational subgrade reaction, which expresses the rotational elastic bedding of a linear structural element per length, such as for a beam. It is typically measured in Nm/(m*rad). 
/// 
/// Type: REAL  
/// 
/// HISTORY New type in IFC2x2.
class IFC_PARSE_API IfcModulusOfRotationalSubgradeReactionMeasure : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcModulusOfRotationalSubgradeReactionMeasure (IfcEntityInstanceData* e);
    IfcModulusOfRotationalSubgradeReactionMeasure (double v);
    operator double() const;
};
/// IfcModulusOfSubgradeReactionMeasure is a geotechnical measure describing interaction between foundation structures and the soil. May also be known as bedding measure. 
///   Usually measured in N/m3.  
///   Type: REAL  
/// 
/// HISTORY New type in IFC Release 2x.
/// 
/// Figure 290 illustrates elastic support of a planar member.
/// 
/// Figure 290 — Modulus of subgrade reaction measure
class IFC_PARSE_API IfcModulusOfSubgradeReactionMeasure : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcModulusOfSubgradeReactionMeasure (IfcEntityInstanceData* e);
    IfcModulusOfSubgradeReactionMeasure (double v);
    operator double() const;
};
/// IfcMoistureDiffusivityMeasure is a measure of moisture diffusivity.
/// Usually measured in m3/s.
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2x.
class IFC_PARSE_API IfcMoistureDiffusivityMeasure : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcMoistureDiffusivityMeasure (IfcEntityInstanceData* e);
    IfcMoistureDiffusivityMeasure (double v);
    operator double() const;
};
/// IfcMolecularWeightMeasure is a measure of molecular weight of material (typically gas).
/// Usually measured in g/mole.
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2x.
class IFC_PARSE_API IfcMolecularWeightMeasure : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcMolecularWeightMeasure (IfcEntityInstanceData* e);
    IfcMolecularWeightMeasure (double v);
    operator double() const;
};
/// IfcMomentOfInertiaMeasure is a measure of moment of inertia.
/// Usually measured in m4.
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2x.
class IFC_PARSE_API IfcMomentOfInertiaMeasure : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcMomentOfInertiaMeasure (IfcEntityInstanceData* e);
    IfcMomentOfInertiaMeasure (double v);
    operator double() const;
};
/// A monetary measure is the value of an amount of money without regard to its currency.
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2.0.
class IFC_PARSE_API IfcMonetaryMeasure : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcMonetaryMeasure (IfcEntityInstanceData* e);
    IfcMonetaryMeasure (double v);
    operator double() const;
};
/// Definition from IAI: The IfcDayInMonthNumber is
/// an integer that defines the position of the specified month in a
/// year. The positions have the following meaning (according to
/// ISO8601 "calendar month") that assigns the Calendar month number
/// to the Calender month name.
/// NOTE Refer to ISO 8601 for the definitions for
/// using the Gregorian calendar as the standard for the
/// identification of calendar days.
/// 
/// Calendar month number
/// Calendar month
/// name
/// 
/// 01
/// January
/// 
/// 02
/// February
/// 
/// 03
/// March
/// 
/// 04
/// April
/// 
/// 05
/// May
/// 
/// 06
/// June
/// 
/// 07
/// July
/// 
/// 08
/// August
/// 
/// 09
/// September
/// 
/// 10
/// October
/// 
/// 11
/// November
/// 
/// 12
/// December
/// 
/// Type: INTEGER
/// NOTE Corresponding STEP
/// name: month_in_year_number, please refer to ISO/IS 10303-41:1994
/// for the final definition of the formal
/// standard.
/// HISTORY New type in IFC
/// Release 1.5.1.
class IFC_PARSE_API IfcMonthInYearNumber : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcMonthInYearNumber (IfcEntityInstanceData* e);
    IfcMonthInYearNumber (int v);
    operator int() const;
};
/// Definition from ISO/CD 10303-41:1992: A numeric measure is the numeric value of a physical quantity.
/// Type: NUMBER
/// 
/// NOTE Corresponding ISO 10303 name: numeric_measure, please refer to ISO/IS 10303-41 for the final definition of the formal standard.
/// 
/// HISTORY New type in IFC Release 1.5.1.
class IFC_PARSE_API IfcNumericMeasure : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcNumericMeasure (IfcEntityInstanceData* e);
    IfcNumericMeasure (double v);
    operator double() const;
};
/// IfcPHMeasure is a measure of the molar hydrogen ion concentration in a liquid (usually defined as the measure of acidity) in a range from 0 to 14.
/// 
/// HISTORY: New type in IFC 2x2.
class IFC_PARSE_API IfcPHMeasure : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcPHMeasure (IfcEntityInstanceData* e);
    IfcPHMeasure (double v);
    operator double() const;
};
/// Definition from ISO/CD 10303-41:1992: A parameter value is the value which specifies the amount of a 
/// parameter in some parameter space.
/// Type: REAL
/// 
/// NOTE Corresponding STEP name: parameter_value, please refer to ISO/IS 10303-41 for the final definition of the formal standard.
/// 
/// HISTORY New type in IFC Release 1.5.1.
class IFC_PARSE_API IfcParameterValue : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcParameterValue (IfcEntityInstanceData* e);
    IfcParameterValue (double v);
    operator double() const;
};
/// IfcPlanarForceMeasure is a measure of force on an area.
/// Usually measured in N/m2.
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2x.
class IFC_PARSE_API IfcPlanarForceMeasure : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcPlanarForceMeasure (IfcEntityInstanceData* e);
    IfcPlanarForceMeasure (double v);
    operator double() const;
};
/// Definition from ISO/CD 10303-41:1992: A plane angle measure is the value of an angle in a plane.
/// 
/// Usually measured in radian (rad, m/m = 1), but also grads may be used. The grad unit may be declared as a conversion based unit based on radian unit.
/// 
/// NOTE IfcPlaneAngleMeasure is used where angles need to be described to an accuracy of less than one degree and expressed as decimal parts of an angle. It is widely used for angular measurement except for situations where accuracy needs to be defined using arc measurement; for which purpose the IfcCompoundPlaneAngleMeasure is provided.
/// 
/// Type: REAL
/// 
/// NOTE Corresponding ISO 10303 name: plane_angle_measure, please refer to ISO/IS 10303-41 for the final definition of the formal standard.
/// 
/// HISTORY New type in IFC Release 1.5.1.
class IFC_PARSE_API IfcPlaneAngleMeasure : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcPlaneAngleMeasure (IfcEntityInstanceData* e);
    IfcPlaneAngleMeasure (double v);
    operator double() const;
};
/// Definition from ISO/CD 10303-41:1992: A positive length measure is a length measure that is greater than zero.
/// Type: IfcLengthMeasure
/// 
/// NOTE Corresponding ISO 10303 name: positive_length_measure, please refer to ISO/IS 10303-41 for the final definition of the formal standard.
/// 
/// HISTORY New type in IFC Release 1.5.1.
class IFC_PARSE_API IfcPositiveLengthMeasure : public IfcLengthMeasure {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcPositiveLengthMeasure (IfcEntityInstanceData* e);
    IfcPositiveLengthMeasure (double v);
    operator double() const;
};
/// Definition from ISO/CD 10303-41:1992: Positive plane angle measure is a plane angle measure that is greater than zero.
/// Type: IfcPlaneAngleMeasure 
/// 
/// NOTE Corresponding STEP name: positive_plane_angle_measure, please refer to ISO/IS 10303-41 for the final definition of the formal standard.
/// 
/// HISTORY New type in IFC Release 1.5.1.
class IFC_PARSE_API IfcPositivePlaneAngleMeasure : public IfcPlaneAngleMeasure {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcPositivePlaneAngleMeasure (IfcEntityInstanceData* e);
    IfcPositivePlaneAngleMeasure (double v);
    operator double() const;
};
/// IfcPowerMeasure is a measure of power required or used.
/// Usually measured in Watts (W, J/s).
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2.0.
class IFC_PARSE_API IfcPowerMeasure : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcPowerMeasure (IfcEntityInstanceData* e);
    IfcPowerMeasure (double v);
    operator double() const;
};
/// IfcPresentableText is a text string used to capture the content of a text literal for the purpose of presentation. The IfcPresentableText can include multiple lines of text, for which the line feed character LF, 0x0A, should be used to separate lines.
/// 
/// NOTE  The non printable characters are converted within the standard exchange format ISO 10303-21 (STEP physical file format), commonly the \X\09 represents the TAB, and \X\0A the LF character.
/// 
/// NOTE  The IfcPresentableText is an entity that had been adopted from ISO 10303, Industrial automation systems and integration—Product data representation and exchange, Part 46: Integrated generic resources: Visual presentation.
/// 
/// NOTE  Corresponding ISO 10303 name: presentable_text. Please refer to ISO/IS 10303-46:1994, p. 133 for the final definition of the formal standard.
/// 
/// HISTORY  New type in IFC2x2.
class IFC_PARSE_API IfcPresentableText : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcPresentableText (IfcEntityInstanceData* e);
    IfcPresentableText (std::string v);
    operator std::string() const;
};
/// IfcPressureMeasure is a measure of the quantity of a medium acting on a unit area.
/// Usually measured in Pascals (Pa, N/m2).
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2.0.
class IFC_PARSE_API IfcPressureMeasure : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcPressureMeasure (IfcEntityInstanceData* e);
    IfcPressureMeasure (double v);
    operator double() const;
};
/// IfcRadioActivityMeasure is a measure of activity of radionuclide.
/// Usually measured in Becquerel (Bq, 1/s).
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2x.
class IFC_PARSE_API IfcRadioActivityMeasure : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcRadioActivityMeasure (IfcEntityInstanceData* e);
    IfcRadioActivityMeasure (double v);
    operator double() const;
};
/// Definition from ISO/CD 10303-41:1992: A ratio measure is the value of the relation between two 
/// physical quantities that are of the same kind.
/// 
/// NOTE: Input given in percent is to be divided by 100% when stored as an IfcRatioMeasure. For example, 25% becomes 0.25.
/// 
/// Type: REAL
/// 
/// NOTE Corresponding STEP name: ratio_measure, please refer to ISO/IS 10303-41 for the final definition of the formal standard.
/// 
/// HISTORY New type in IFC Release 1.5.1.
class IFC_PARSE_API IfcRatioMeasure : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcRatioMeasure (IfcEntityInstanceData* e);
    IfcRatioMeasure (double v);
    operator double() const;
};
/// IfcReal is a defined type of simple data type REAL.  It is required since a select type (IfcSimpleValue), cannot directly include simple types in its select list.
/// 
/// In principle, the domain of IfcReal (being a Real) is all rational, irrational and scientific real numbers. Here the precision is unconstrained, but in practice it is implementation specific.
/// 
/// Type: REAL
/// 
/// HISTORY: New type in IFC Release 1.5.1.
class IFC_PARSE_API IfcReal : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcReal (IfcEntityInstanceData* e);
    IfcReal (double v);
    operator double() const;
};
/// IfcRotationalFrequencyMeasure is a measure of the number of cycles that an item revolves in unit time.
/// Usually measured in cycles/s.
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2x.
class IFC_PARSE_API IfcRotationalFrequencyMeasure : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcRotationalFrequencyMeasure (IfcEntityInstanceData* e);
    IfcRotationalFrequencyMeasure (double v);
    operator double() const;
};
/// The rotational mass measure denotes the inertia of a body with respect to angular acceleration.
/// It is usually measured in kg*m^2.
/// 
/// Type: REAL  
/// 
/// HISTORY New type in IFC2x2.
class IFC_PARSE_API IfcRotationalMassMeasure : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcRotationalMassMeasure (IfcEntityInstanceData* e);
    IfcRotationalMassMeasure (double v);
    operator double() const;
};
/// IfcRotationalStiffnessMeasure is a measure of rotational stiffness.
/// Usually measured in Nm/rad.
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2x.
class IFC_PARSE_API IfcRotationalStiffnessMeasure : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcRotationalStiffnessMeasure (IfcEntityInstanceData* e);
    IfcRotationalStiffnessMeasure (double v);
    operator double() const;
};

class IFC_PARSE_API IfcSecondInMinute : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcSecondInMinute (IfcEntityInstanceData* e);
    IfcSecondInMinute (double v);
    operator double() const;
};
/// IfcSectionModulusMeasure is a measure for the resistance of a cross section against bending or torsional moment.  It is usually measured in m^3.
/// 
/// Type: REAL 
/// 
/// HISTORY New type in IFC Release 2x2.
class IFC_PARSE_API IfcSectionModulusMeasure : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcSectionModulusMeasure (IfcEntityInstanceData* e);
    IfcSectionModulusMeasure (double v);
    operator double() const;
};
/// The sectional area integral measure is typically used in torsional analysis. It is usually measured in m^5.
/// 
/// Type: REAL  
/// 
/// HISTORY New type in IFC2x2.
class IFC_PARSE_API IfcSectionalAreaIntegralMeasure : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcSectionalAreaIntegralMeasure (IfcEntityInstanceData* e);
    IfcSectionalAreaIntegralMeasure (double v);
    operator double() const;
};
/// IfcShearModulusMeasure is a measure of shear modulus.
/// Usually measured in N/m2.
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2x.
class IFC_PARSE_API IfcShearModulusMeasure : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcShearModulusMeasure (IfcEntityInstanceData* e);
    IfcShearModulusMeasure (double v);
    operator double() const;
};
/// Definition from ISO/CD 10303-41:1992: A solid angle measure is the value of an angle in a solid.
/// Usually measured in Steradians, (sr, m2/m2).
/// Type: REAL
/// 
/// NOTE Corresponding ISO 10303 name: solid_angle_measure, please refer to ISO/IS 10303-41 for the final definition of the formal standard.
/// 
/// HISTORY New type in IFC Release 1.5.1.
class IFC_PARSE_API IfcSolidAngleMeasure : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcSolidAngleMeasure (IfcEntityInstanceData* e);
    IfcSolidAngleMeasure (double v);
    operator double() const;
};
/// A sound power measure is a measure of total radiated noise with units of decibels with a reference value of picowatts.
/// 
/// Type: REAL  
/// 
/// HISTORY New type in IFC2x2.
class IFC_PARSE_API IfcSoundPowerMeasure : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcSoundPowerMeasure (IfcEntityInstanceData* e);
    IfcSoundPowerMeasure (double v);
    operator double() const;
};
/// A sound pressure measure is a measure of the pressure fluctuations superimposed over the ambient pressure level with units of decibels with a reference value of micropascals. 
/// 
/// Type: REAL  
/// 
/// HISTORY New type in IFC2x2.
class IFC_PARSE_API IfcSoundPressureMeasure : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcSoundPressureMeasure (IfcEntityInstanceData* e);
    IfcSoundPressureMeasure (double v);
    operator double() const;
};
/// IfcSpecificHeatCapacityMeasure defines the specific heat of material: The heat energy absorbed per temperature unit.
/// Usually measured in J / kg Kelvin.
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2x.
class IFC_PARSE_API IfcSpecificHeatCapacityMeasure : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcSpecificHeatCapacityMeasure (IfcEntityInstanceData* e);
    IfcSpecificHeatCapacityMeasure (double v);
    operator double() const;
};
/// The IfcSpecularExponent defines the datatype for exponent determining the sharpness of the 'reflection'. reflection is made sharper with large values of the exponent, such as 10.0. Small values, such as 1.0, decrease the specular fall-off. 
/// 
/// IfcSpecularExponent is of type REAL.
/// 
/// NOTE: The datatype relates to the definition of specular_exponent in ISO 10303-46 entity surface_style_reflectance_ambient_diffuse_specular.
/// 
/// HISTORY: New type in IFC2x2.
class IFC_PARSE_API IfcSpecularExponent : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcSpecularExponent (IfcEntityInstanceData* e);
    IfcSpecularExponent (double v);
    operator double() const;
};
/// The IfcSpecularRoughness defines the datatype for the reflection resulting from the roughness of a surface through the height of surface impurities where the specular highlight is made sharper with small values for the roughness, such as 0.1.  
/// 
/// Applies to "glass", "metal", "mirror" and "plastic" reflection models. Larger values, close to 1.0 decrease the specular fall-off. 
/// 
/// IfcSpecularRoughness is of type REAL. It is constraint to values between (and including) 0 and 1.
/// 
/// NOTE: The datatype relates to the definition of "shiness" in VRML97, which is the reciprocate value to the specular roughness.
/// 
/// HISTORY: New type in Release IFC2x2.
class IFC_PARSE_API IfcSpecularRoughness : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcSpecularRoughness (IfcEntityInstanceData* e);
    IfcSpecularRoughness (double v);
    operator double() const;
};
/// The temperature gradient measures the difference of a temperature per lenght, as for instance used in an external wall or its layers.  It is usually measured in K/m.
/// 
/// Type: REAL  
/// 
/// HISTORY New type in IFC2x2.
class IFC_PARSE_API IfcTemperatureGradientMeasure : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcTemperatureGradientMeasure (IfcEntityInstanceData* e);
    IfcTemperatureGradientMeasure (double v);
    operator double() const;
};
/// Definition from ISO/CD 10303-41:1992: A text is an alphanumeric string of characters which is intended to be read and understood by a human being. It is for information purposes only.
/// 
/// Type: STRING
/// 
/// NOTE Corresponding STEP name: text, please refer to ISO/IS 10303-41 for the final definition of the formal standard.
/// 
/// HISTORY New type in IFC Release 2x.
/// 
/// Per ISO 10303-11, the set of characters that may appear in STRINGs is defined in ISO 10646.  The encoding of characters in case of file-based exchange is defined in ISO 10303-21 (STEP physical files) and ISO 10303-28 (XML files).  Among else, these specifications define the encoding of 8-bit characters from ISO 8859-1...-16 and of 2-byte Unicode characters.
/// 
/// Note that while IfcText is not formally restricted in length, the size of a string in ISO 10303-21:2002 conforming exchange files must not exceed 32767 octets after encoding and escaping.
class IFC_PARSE_API IfcText : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcText (IfcEntityInstanceData* e);
    IfcText (std::string v);
    operator std::string() const;
};
/// Definition from CSS1 (W3C Recommendation): This property describes how text is aligned within the element. The actual justification algorithm used is user agent and human language dependent. If 'justify' is not supported, the user agent will supply a replacement. Typically, this will be 'left' for western languages. Values are:
/// 
/// left
///   right
///   center
///   justify
/// 
/// NOTE  Corresponding CSS1 definition is text-align.
/// 
/// HISTORY  New type in IFC2x3.
class IFC_PARSE_API IfcTextAlignment : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcTextAlignment (IfcEntityInstanceData* e);
    IfcTextAlignment (std::string v);
    operator std::string() const;
};
/// Definition from CSS1 (W3C Recommendation): This property describes decorations that are added to the text of an element. A value of 'blink' causes the text to blink.. Values are:
/// 
/// none
///   underline
///   overline
///   line-through
///   blink
/// 
/// User agents must recognize the keyword 'blink', but are not required to support the blink effect.
/// 
/// NOTE  Corresponding CSS1 definition is text-decoration.
/// 
/// HISTORY  New type in IFC2x3.
class IFC_PARSE_API IfcTextDecoration : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcTextDecoration (IfcEntityInstanceData* e);
    IfcTextDecoration (std::string v);
    operator std::string() const;
};
/// Definition from CSS1 (W3C Recommendation): The value is a font family name and/or generic family name. Values are:
/// 
/// The name of a font family of choice. For example, "gill" and "helvetica" are font families.
/// 
/// In the example above, the last value is a generic family name. The following generic families are defined:
/// 
/// 'serif' (Example: Times)
///   'sans-serif' (Example: Helvetica)
///   'cursive' (Example: Zapf-Chancery)
///   'fantasy' (Example: Western)
///   'monospace' (Example: Courier)
/// 
/// It is encouraged to offer a generic font family as a last alternative.
/// 
/// NOTE  Corresponding CSS1 definitions are font-family.
/// 
/// HISTORY  New type in IFC2x2 Addendum 2.
/// 
/// IFC2x2 Addendum 2 CHANGE: The IfcFontFamily has been added.
class IFC_PARSE_API IfcTextFontName : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcTextFontName (IfcEntityInstanceData* e);
    IfcTextFontName (std::string v);
    operator std::string() const;
};
/// Definition from CSS1 (W3C Recommendation): This property describes how the cases of characters are handled. Values are:
/// 
/// capitalize: uppercases the first character of each word
///   uppercase: uppercases all letters of the element
///   lowercase: lowercases all letters of the element
///   none
/// 
/// NOTE  Corresponding CSS1 definition is text-transform.
/// 
/// HISTORY  New type in IFC2x3.
class IFC_PARSE_API IfcTextTransformation : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcTextTransformation (IfcEntityInstanceData* e);
    IfcTextTransformation (std::string v);
    operator std::string() const;
};
/// IfcThermalAdmittanceMeasure is the measure of the ability of a surface to smooth out temperature variations.
/// Usually measured in Watt / m2 Kelvin.
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2.0.
class IFC_PARSE_API IfcThermalAdmittanceMeasure : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcThermalAdmittanceMeasure (IfcEntityInstanceData* e);
    IfcThermalAdmittanceMeasure (double v);
    operator double() const;
};
/// IfcThermalConductivityMeasure is a measure of thermal conductivity.
/// Usually measured in Watt / m Kelvin.
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2x.
class IFC_PARSE_API IfcThermalConductivityMeasure : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcThermalConductivityMeasure (IfcEntityInstanceData* e);
    IfcThermalConductivityMeasure (double v);
    operator double() const;
};
/// IfcThermalExpansionCoeffientMeasure is a measure of the thermal expansion coefficient of a material, which expresses its elongation (as a ratio) per temperature difference. It is usually measured in 1/K. A positive elongation per (positive) rise of temperature is expressed by a positive value.
/// Type: REAL  
/// 
/// HISTORY New type in IFC2x2.
class IFC_PARSE_API IfcThermalExpansionCoefficientMeasure : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcThermalExpansionCoefficientMeasure (IfcEntityInstanceData* e);
    IfcThermalExpansionCoefficientMeasure (double v);
    operator double() const;
};
/// IfcThermalResistanceMeasure is a measure of the resistance offered by a body to the flow of energy.
/// Usually measured in m2 Kelvin/Watt.
/// 
/// HISTORY New type in IFC Release 2.0.
class IFC_PARSE_API IfcThermalResistanceMeasure : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcThermalResistanceMeasure (IfcEntityInstanceData* e);
    IfcThermalResistanceMeasure (double v);
    operator double() const;
};
/// IfcThermalTransmittanceMeasure is a measure of the rate at which energy is transmitted through a body.
/// Usually measured in Watts/m2 Kelvin.
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2.0.
class IFC_PARSE_API IfcThermalTransmittanceMeasure : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcThermalTransmittanceMeasure (IfcEntityInstanceData* e);
    IfcThermalTransmittanceMeasure (double v);
    operator double() const;
};
/// Definition from ISO/CD 10303-41:1992: A thermodynamic temperature measure is the value for the degree of heat of a body.
/// Usually measured in degrees Kelvin (K).
/// Type: REAL
/// 
/// NOTE Corresponding ISO 10303 name: thermodynamic_temperature_measure, please refer to ISO/IS 10303-41 for the final definition of the formal standard.
/// 
/// HISTORY New type in IFC Release 1.5.1.
class IFC_PARSE_API IfcThermodynamicTemperatureMeasure : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcThermodynamicTemperatureMeasure (IfcEntityInstanceData* e);
    IfcThermodynamicTemperatureMeasure (double v);
    operator double() const;
};
/// Definition from ISO/CD 10303-41:1992: A time measure is the value of the duration of periods.
/// Measured in seconds (s) or days (d) or other units of time.
/// Type: REAL
/// 
/// NOTE Corresponding ISO 10303 name: time_measure, please refer to ISO/IS 10303-41 for the final definition of the formal standard.
/// 
/// HISTORY New type in IFC Release 1.5.1.
class IFC_PARSE_API IfcTimeMeasure : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcTimeMeasure (IfcEntityInstanceData* e);
    IfcTimeMeasure (double v);
    operator double() const;
};
/// IfcTimeStamp is an indication of date and time by measuring the number of seconds which have elapsed since the beginning of the year 1970.
/// Type: INTEGER
/// 
/// HISTORY New type in IFC Release 1.5.1.
class IFC_PARSE_API IfcTimeStamp : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcTimeStamp (IfcEntityInstanceData* e);
    IfcTimeStamp (int v);
    operator int() const;
};
/// IfcTorqueMeasure is a measure of the torque or moment of a couple.
/// Usually measured in N m.
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2x.
class IFC_PARSE_API IfcTorqueMeasure : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcTorqueMeasure (IfcEntityInstanceData* e);
    IfcTorqueMeasure (double v);
    operator double() const;
};
/// IfcVaporPermeabilityMeasure is a measure of vapor permeability.
/// Usually measured in kg / s m Pascal.
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2x.
class IFC_PARSE_API IfcVaporPermeabilityMeasure : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcVaporPermeabilityMeasure (IfcEntityInstanceData* e);
    IfcVaporPermeabilityMeasure (double v);
    operator double() const;
};
/// Definition from ISO/CD 10303-41:1992: A volume measure is the value of the solid content of a body.
/// Usually measured in cubic metre (m3).
/// Type: REAL
/// 
/// NOTE Corresponding ISO 10303 name: volume_measure, please refer to ISO/IS 10303-41 for the final definition of the formal standard.
/// 
/// HISTORY New type in IFC Release 1.5.1.
class IFC_PARSE_API IfcVolumeMeasure : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcVolumeMeasure (IfcEntityInstanceData* e);
    IfcVolumeMeasure (double v);
    operator double() const;
};
/// IfcVolumetricFlowRateMeasure is a measure of the volume of a medium flowing per unit time.
/// Usually measured in m3/s.
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2.0.
class IFC_PARSE_API IfcVolumetricFlowRateMeasure : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcVolumetricFlowRateMeasure (IfcEntityInstanceData* e);
    IfcVolumetricFlowRateMeasure (double v);
    operator double() const;
};
/// IfcWarpingConstantMeasure is a measure for the warping constant or warping resistance of a cross section under torsional loading. It is usually measured in m^6.
/// 
/// Type: REAL  
/// 
/// HISTORY New type in IFC2x2.
class IFC_PARSE_API IfcWarpingConstantMeasure : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcWarpingConstantMeasure (IfcEntityInstanceData* e);
    IfcWarpingConstantMeasure (double v);
    operator double() const;
};
/// The warping moment measure is a measure for the warping moment, which occurs in warping torsional analysis. It is usually measured in kN*m^2.
/// 
/// Type: REAL  
/// 
/// HISTORY New type in IFC2x2.
class IFC_PARSE_API IfcWarpingMomentMeasure : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcWarpingMomentMeasure (IfcEntityInstanceData* e);
    IfcWarpingMomentMeasure (double v);
    operator double() const;
};

class IFC_PARSE_API IfcYearNumber : public IfcUtil::IfcBaseType {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcYearNumber (IfcEntityInstanceData* e);
    IfcYearNumber (int v);
    operator int() const;
};
/// The box alignment specifies the alignment of the text box relative to its position. The following string values shall be used:
/// 
/// top-left
///   top-middle
///   top-right
///   middle-left
///   center
///   middle-right
///   bottom-left
///   bottom-middle
///   bottom-right
/// 
/// NOTE  The top-left is the default value.
/// 
/// Figure 298 illustrates alignment values.
/// 
/// Figure 298 — Box alignment values
/// 
/// Figure 299 illustrates use of alignment values together with the placement and planar extent.
/// 
/// Figure 299 — Box alignment examples
/// 
/// HISTORY  New type in IFC2x2 Addendum2.
/// 
/// IFC2x3 CHANGE  The IfcBoxAlignment has been added.
class IFC_PARSE_API IfcBoxAlignment : public IfcLabel {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcBoxAlignment (IfcEntityInstanceData* e);
    IfcBoxAlignment (std::string v);
    operator std::string() const;
};
/// IfcNormalisedRatioMeasure is a dimensionless measure to express ratio values ranging from 0.0 to 1.0.
/// 
/// Type: REAL
/// 
/// HISTORY New type in IFC Release 2x.
class IFC_PARSE_API IfcNormalisedRatioMeasure : public IfcRatioMeasure {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcNormalisedRatioMeasure (IfcEntityInstanceData* e);
    IfcNormalisedRatioMeasure (double v);
    operator double() const;
};
/// Definition from ISO/CD 10303-41:1992: A positive ratio measure is a ratio measure that is greater than zero.
/// Type: IfcRatioMeasure
/// 
/// NOTE Corresponding ISO 10303 name: positive_ratio_measure, please refer to ISO/IS 10303-41 for the final definition of the formal standard.
/// 
/// HISTORY New type in IFC Release 1.5.1.
class IFC_PARSE_API IfcPositiveRatioMeasure : public IfcRatioMeasure {
public:
    virtual const IfcParse::type_declaration& declaration() const;
    static const IfcParse::type_declaration& Class();
    explicit IfcPositiveRatioMeasure (IfcEntityInstanceData* e);
    IfcPositiveRatioMeasure (double v);
    operator double() const;
};


/// Definition: A role which is performed by an actor, either a person, an organization or a 
/// person related to an organization.
/// 
/// NOTE: The list of roles of the enumeration values of the Role attribute can never
/// be complete. Therefore using enumeration value USERDEFINED, the user can provide his/her own role as a value 
/// of the attribute UserDefinedRole.
/// 
/// Corresponds to the following entity in ISO-10303-41: organization_role and person_role.
/// 
/// HISTORY New entity in IFC Release 1.5.1
class IFC_PARSE_API IfcActorRole : public IfcUtil::IfcBaseEntity {
public:
    /// The name of the role played by an actor. If the Role has value USERDEFINED, then
    /// the user defined role shall be provided as a value of the attribute UserDefinedRole.
    ::Ifc2x3::IfcRoleEnum::Value Role() const;
    void setRole(::Ifc2x3::IfcRoleEnum::Value v);
    /// Whether the optional attribute UserDefinedRole is defined for this IfcActorRole
    bool hasUserDefinedRole() const;
    /// Allows for specification of user defined roles beyond the 
    /// enumeration values provided by Role attribute of type IfcRoleEnum. 
    /// When a value is provided for attribute UserDefinedRole in parallel 
    /// the attribute Role shall have enumeration value USERDEFINED.
    std::string UserDefinedRole() const;
    void setUserDefinedRole(std::string v);
    /// Whether the optional attribute Description is defined for this IfcActorRole
    bool hasDescription() const;
    /// A textual description relating the nature of the role played by an actor.
    std::string Description() const;
    void setDescription(std::string v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcActorRole (IfcEntityInstanceData* e);
    IfcActorRole (::Ifc2x3::IfcRoleEnum::Value v1_Role, boost::optional< std::string > v2_UserDefinedRole, boost::optional< std::string > v3_Description);
    typedef IfcTemplatedEntityList< IfcActorRole > list;
};
/// Definition: An abstract entity type for various kinds of postal and telecom addresses.
/// 
/// NOTE Corresponds to the following entity in ISO-10303-41: address.
/// 
/// HISTORY New entity in IFC Release 1.5.1.
class IFC_PARSE_API IfcAddress : public IfcUtil::IfcBaseEntity {
public:
    /// Whether the optional attribute Purpose is defined for this IfcAddress
    bool hasPurpose() const;
    /// Identifies the logical location of the address.
    ::Ifc2x3::IfcAddressTypeEnum::Value Purpose() const;
    void setPurpose(::Ifc2x3::IfcAddressTypeEnum::Value v);
    /// Whether the optional attribute Description is defined for this IfcAddress
    bool hasDescription() const;
    /// Text that relates the nature of the address.
    std::string Description() const;
    void setDescription(std::string v);
    /// Whether the optional attribute UserDefinedPurpose is defined for this IfcAddress
    bool hasUserDefinedPurpose() const;
    /// Allows for specification of user specific purpose of the address beyond the 
    /// enumeration values provided by Purpose attribute of type IfcAddressTypeEnum. 
    /// When a value is provided for attribute UserDefinedPurpose, in parallel the 
    /// attribute Purpose shall have enumeration value USERDEFINED.
    std::string UserDefinedPurpose() const;
    void setUserDefinedPurpose(std::string v);
        IfcTemplatedEntityList< IfcPerson >::ptr OfPerson() const; // INVERSE IfcPerson::Addresses
    IfcTemplatedEntityList< IfcOrganization >::ptr OfOrganization() const; // INVERSE IfcOrganization::Addresses
    virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcAddress (IfcEntityInstanceData* e);
    IfcAddress (boost::optional< ::Ifc2x3::IfcAddressTypeEnum::Value > v1_Purpose, boost::optional< std::string > v2_Description, boost::optional< std::string > v3_UserDefinedPurpose);
    typedef IfcTemplatedEntityList< IfcAddress > list;
};
/// IfcApplication holds the information about an IFC compliant application developed by an application developer. The IfcApplication utilizes a short identifying name as provided by the application developer.
/// 
/// HISTORY  New entity in IFC R1.5.
class IFC_PARSE_API IfcApplication : public IfcUtil::IfcBaseEntity {
public:
    /// Name of the application developer, being requested to be member of the IAI.
    ::Ifc2x3::IfcOrganization* ApplicationDeveloper() const;
    void setApplicationDeveloper(::Ifc2x3::IfcOrganization* v);
    /// The version number of this software as specified by the developer of the application.
    std::string Version() const;
    void setVersion(std::string v);
    /// The full name of the application as specified by the application developer.
    std::string ApplicationFullName() const;
    void setApplicationFullName(std::string v);
    /// Short identifying name for the application.
    std::string ApplicationIdentifier() const;
    void setApplicationIdentifier(std::string v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcApplication (IfcEntityInstanceData* e);
    IfcApplication (::Ifc2x3::IfcOrganization* v1_ApplicationDeveloper, std::string v2_Version, std::string v3_ApplicationFullName, std::string v4_ApplicationIdentifier);
    typedef IfcTemplatedEntityList< IfcApplication > list;
};
/// IfcAppliedValue is an abstract supertype that specifies the common attributes for cost values. 
/// 
/// HISTORY: New Entity in IFC2x2.  Modifed in IFC2x4 to use IfcDate for date values.
/// 
/// Use definitions 
/// The extent of the IfcAppliedValue is determined by the AppliedValue attribute which may be defined either as an IfcMeasureWithUnit or as an IfcMonetaryMeasure or as an IfcRatioMeasure via the IfcAppliedValueSelect type.  
/// 
/// Optionally, an IfcAppliedValue may have an applicable date. This is intended to fix the date on which the value became relevant for use. It may be the date on which the value was set in the model or it may be a prior or future date when the value becomes operable.
/// 
/// Similarly, an IfcAppliedValue may have a 'fixed until' date. This is intended to fix the date on which the value ceases to be relevant for use. 
/// 
/// An instance of IfcAppliedValue may have a unit basis asserted.  This is defined as an IfcMeasureWithUnit that determines the extent of the unit value for application purposes. It is assumed that when this attribute is asserted, then the value given to IfcAppliedValue is that for unit quantity. This is not enforced within the IFC schema and thus needs to be controlled within an application.
/// 
/// Applied values may be referenced from a document (such as a price list). The relationship between one or more occurrences of IfcAppliedValue (or its subtypes) is achieved through the use of the IfcExternalReferenceRelationship in which the document provides the IfcExternalReferenceRelationship.RelatingExtReference and the value occurrences are the IfcExternalReferenceRelationship.RelatedResourceObjects.
class IFC_PARSE_API IfcAppliedValue : public IfcUtil::IfcBaseEntity {
public:
    /// Whether the optional attribute Name is defined for this IfcAppliedValue
    bool hasName() const;
    /// A name or additional clarification given to a cost value.
    std::string Name() const;
    void setName(std::string v);
    /// Whether the optional attribute Description is defined for this IfcAppliedValue
    bool hasDescription() const;
    /// The description that may apply additional information about a cost value.
    std::string Description() const;
    void setDescription(std::string v);
    /// Whether the optional attribute AppliedValue is defined for this IfcAppliedValue
    bool hasAppliedValue() const;
    /// The extent or quantity or amount of an applied value.
    ::Ifc2x3::IfcAppliedValueSelect* AppliedValue() const;
    void setAppliedValue(::Ifc2x3::IfcAppliedValueSelect* v);
    /// Whether the optional attribute UnitBasis is defined for this IfcAppliedValue
    bool hasUnitBasis() const;
    /// The number and unit of measure on which the unit cost is based.
    /// 
    /// Note: As well as the normally expected units of measure such as length, area, volume etc., costs may be based on units of measure which need to be defined e.g. sack, drum, pallet, item etc. Unit costs may be based on quantities greater (or lesser) than a unitary value of the basis measure. For instance, timber may have a unit cost rate per X meters where X > 1; similarly for cable, piping and many other items. The basis number may be either an integer or a real value.
    /// 
    /// Note: This attribute should be asserted for all circumstances where the cost to be applied is per unit quantity. It may be asserted even for circumstances where an item price is used, in which case the unit cost basis should be by item (or equivalent definition).
    ::Ifc2x3::IfcMeasureWithUnit* UnitBasis() const;
    void setUnitBasis(::Ifc2x3::IfcMeasureWithUnit* v);
    /// Whether the optional attribute ApplicableDate is defined for this IfcAppliedValue
    bool hasApplicableDate() const;
    /// The date on or from which an applied value is applicable.
    /// 
    /// IFC2x4 CHANGE Type changed from IfcDateTimeSelect.
    ::Ifc2x3::IfcDateTimeSelect* ApplicableDate() const;
    void setApplicableDate(::Ifc2x3::IfcDateTimeSelect* v);
    /// Whether the optional attribute FixedUntilDate is defined for this IfcAppliedValue
    bool hasFixedUntilDate() const;
    /// The date until which applied value is applicable.
    /// 
    /// IFC2x4 CHANGE Type changed from IfcDateTimeSelect.
    ::Ifc2x3::IfcDateTimeSelect* FixedUntilDate() const;
    void setFixedUntilDate(::Ifc2x3::IfcDateTimeSelect* v);
        IfcTemplatedEntityList< IfcReferencesValueDocument >::ptr ValuesReferenced() const; // INVERSE IfcReferencesValueDocument::ReferencingValues
    IfcTemplatedEntityList< IfcAppliedValueRelationship >::ptr ValueOfComponents() const; // INVERSE IfcAppliedValueRelationship::ComponentOfTotal
    IfcTemplatedEntityList< IfcAppliedValueRelationship >::ptr IsComponentIn() const; // INVERSE IfcAppliedValueRelationship::Components
    virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcAppliedValue (IfcEntityInstanceData* e);
    IfcAppliedValue (boost::optional< std::string > v1_Name, boost::optional< std::string > v2_Description, ::Ifc2x3::IfcAppliedValueSelect* v3_AppliedValue, ::Ifc2x3::IfcMeasureWithUnit* v4_UnitBasis, ::Ifc2x3::IfcDateTimeSelect* v5_ApplicableDate, ::Ifc2x3::IfcDateTimeSelect* v6_FixedUntilDate);
    typedef IfcTemplatedEntityList< IfcAppliedValue > list;
};
/// An IfcAppliedValueRelationship is a relationship class that enables cost values to be aggregated together as components of another cost value.
/// 
/// HISTORY  New Entity in Release IFC2.0.
/// 
/// IFC2x4 CHANGE  Subtyped from IfcResourceLevelRelationship, attribute order changed.
/// 
/// Use definitions
/// Dependency relationships can exist between applied values on the basis that one particular value may be determined by operations on one or more other values. This is captured through the IfcAppliedValueRelationship entity. In this relationship, one instance of IfcAppliedValue acts as the principal (IfcAppliedValueRelationship.ComponentOf) whose value may be
/// determined from the instances of IfcAppliedValue that are defined as its components
/// (IfcAppliedValueRelationship.Components)
/// An IfcAppliedValueRelationship has an ArithmeticOperator attribute that specifies the form of arithmetical operation implied by the relationship.
/// A practical consideration when using the applied value relationship is that when the arithmetic operator is ADD, then the
/// type of the IfcAppliedValue.AppliedValue attribute will be IfcMeasureWithUnit or IfcMonetaryMeasure while if the arithmetic operator is MULTIPLY, then the type of the IfcAppliedValue.AppliedValue attribute for one instance of
/// IfcAppliedValue will be IfcMeasureWithUnit or IfcMonetaryMeasure while for other instances it will be
/// IfcRatioMeasure.
/// If the arithmetic operator is SUBTRACT or DIVIDE then there can only be two occurrences of IfcAppliedValue that can contribute and the order in which they occur is significant. The value of (A - B) will usually differ from the value of (B - A) whilst (X / Y) is the reciprocal of (Y / X).
/// 
/// Figure 239 illustrates one level aggregation of applied values. A relationship exists between applied value A and applied values B, C and D such that the value of A is determined by the addition of B, C and D such that: A = B + C + D
/// 
/// Figure 239 — Applied value relationship single level
/// 
/// Figure 240 illustrates two level aggregation of applied values. It is possible to develop more complex applied value specifications by creating hierarchies of applied value relationships. In the diagram, the development of a applied value is shown whereby, because B = E * F and D = G * H * J, then: A = ((E * F) + C + (G * H * J)).
/// 
/// Figure 240 — Applied value relationship multiple level
class IFC_PARSE_API IfcAppliedValueRelationship : public IfcUtil::IfcBaseEntity {
public:
    /// The applied value (total or subtotal) of which the value being considered is a component.
    ::Ifc2x3::IfcAppliedValue* ComponentOfTotal() const;
    void setComponentOfTotal(::Ifc2x3::IfcAppliedValue* v);
    /// Applied values that are components of another applied value and from which that applied value may be deduced.
    IfcTemplatedEntityList< ::Ifc2x3::IfcAppliedValue >::ptr Components() const;
    void setComponents(IfcTemplatedEntityList< ::Ifc2x3::IfcAppliedValue >::ptr v);
    /// The arithmetic operator applied in an applied value relationship.
    ::Ifc2x3::IfcArithmeticOperatorEnum::Value ArithmeticOperator() const;
    void setArithmeticOperator(::Ifc2x3::IfcArithmeticOperatorEnum::Value v);
    /// Whether the optional attribute Name is defined for this IfcAppliedValueRelationship
    bool hasName() const;
    std::string Name() const;
    void setName(std::string v);
    /// Whether the optional attribute Description is defined for this IfcAppliedValueRelationship
    bool hasDescription() const;
    std::string Description() const;
    void setDescription(std::string v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcAppliedValueRelationship (IfcEntityInstanceData* e);
    IfcAppliedValueRelationship (::Ifc2x3::IfcAppliedValue* v1_ComponentOfTotal, IfcTemplatedEntityList< ::Ifc2x3::IfcAppliedValue >::ptr v2_Components, ::Ifc2x3::IfcArithmeticOperatorEnum::Value v3_ArithmeticOperator, boost::optional< std::string > v4_Name, boost::optional< std::string > v5_Description);
    typedef IfcTemplatedEntityList< IfcAppliedValueRelationship > list;
};
/// Definition: An IfcApproval represents information about approval processes such as for a plan, a design, a proposal, or a change order in a construction or facilities management project. IfcApproval is referenced by IfcRelAssociatesApproval in IfcControlExtension schema, and thereby can be related to all subtypes of IfcRoot. An approval may also be given to resource objects using IfcResourceApprovalRelationship
/// 
/// HISTORY New Entity in IFC Release 2.0
/// 
/// IFC2x Edition 4 CHANGE  Attributes Identifier and Name made optional, where rule added to require at least one of them being asserted. Inverse attributes ApprovedObjects, ApprovedResources and HasExternalReferences added. Inverse attribute Properties deleted (more general relationship via inverse ApprovedResources to be used instead).
class IFC_PARSE_API IfcApproval : public IfcUtil::IfcBaseEntity {
public:
    /// Whether the optional attribute Description is defined for this IfcApproval
    bool hasDescription() const;
    /// A general textual description of a design, work task, plan, etc. that is being approved for.
    std::string Description() const;
    void setDescription(std::string v);
    ::Ifc2x3::IfcDateTimeSelect* ApprovalDateTime() const;
    void setApprovalDateTime(::Ifc2x3::IfcDateTimeSelect* v);
    /// Whether the optional attribute ApprovalStatus is defined for this IfcApproval
    bool hasApprovalStatus() const;
    std::string ApprovalStatus() const;
    void setApprovalStatus(std::string v);
    /// Whether the optional attribute ApprovalLevel is defined for this IfcApproval
    bool hasApprovalLevel() const;
    std::string ApprovalLevel() const;
    void setApprovalLevel(std::string v);
    /// Whether the optional attribute ApprovalQualifier is defined for this IfcApproval
    bool hasApprovalQualifier() const;
    std::string ApprovalQualifier() const;
    void setApprovalQualifier(std::string v);
    /// A human readable name given to an approval.
    std::string Name() const;
    void setName(std::string v);
    /// A computer interpretable identifier by which the approval is known.
    std::string Identifier() const;
    void setIdentifier(std::string v);
        IfcTemplatedEntityList< IfcApprovalActorRelationship >::ptr Actors() const; // INVERSE IfcApprovalActorRelationship::Approval
    IfcTemplatedEntityList< IfcApprovalRelationship >::ptr IsRelatedWith() const; // INVERSE IfcApprovalRelationship::RelatedApproval
    IfcTemplatedEntityList< IfcApprovalRelationship >::ptr Relates() const; // INVERSE IfcApprovalRelationship::RelatingApproval
    virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcApproval (IfcEntityInstanceData* e);
    IfcApproval (boost::optional< std::string > v1_Description, ::Ifc2x3::IfcDateTimeSelect* v2_ApprovalDateTime, boost::optional< std::string > v3_ApprovalStatus, boost::optional< std::string > v4_ApprovalLevel, boost::optional< std::string > v5_ApprovalQualifier, std::string v6_Name, std::string v7_Identifier);
    typedef IfcTemplatedEntityList< IfcApproval > list;
};

class IFC_PARSE_API IfcApprovalActorRelationship : public IfcUtil::IfcBaseEntity {
public:
    ::Ifc2x3::IfcActorSelect* Actor() const;
    void setActor(::Ifc2x3::IfcActorSelect* v);
    ::Ifc2x3::IfcApproval* Approval() const;
    void setApproval(::Ifc2x3::IfcApproval* v);
    ::Ifc2x3::IfcActorRole* Role() const;
    void setRole(::Ifc2x3::IfcActorRole* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcApprovalActorRelationship (IfcEntityInstanceData* e);
    IfcApprovalActorRelationship (::Ifc2x3::IfcActorSelect* v1_Actor, ::Ifc2x3::IfcApproval* v2_Approval, ::Ifc2x3::IfcActorRole* v3_Role);
    typedef IfcTemplatedEntityList< IfcApprovalActorRelationship > list;
};

class IFC_PARSE_API IfcApprovalPropertyRelationship : public IfcUtil::IfcBaseEntity {
public:
    IfcTemplatedEntityList< ::Ifc2x3::IfcProperty >::ptr ApprovedProperties() const;
    void setApprovedProperties(IfcTemplatedEntityList< ::Ifc2x3::IfcProperty >::ptr v);
    ::Ifc2x3::IfcApproval* Approval() const;
    void setApproval(::Ifc2x3::IfcApproval* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcApprovalPropertyRelationship (IfcEntityInstanceData* e);
    IfcApprovalPropertyRelationship (IfcTemplatedEntityList< ::Ifc2x3::IfcProperty >::ptr v1_ApprovedProperties, ::Ifc2x3::IfcApproval* v2_Approval);
    typedef IfcTemplatedEntityList< IfcApprovalPropertyRelationship > list;
};
/// An IfcApprovalRelationship associates approvals (one
/// relating approval and one or more related approvals), each having different status or level as the approval process or the approved
/// objects evolve.
/// 
/// HISTORY: New entity in Release IFC2x2.
/// 
/// IFC2x4 CHANGE  Subtyped from IfcResourceLevelRelationship, order of attributes changed.
class IFC_PARSE_API IfcApprovalRelationship : public IfcUtil::IfcBaseEntity {
public:
    ::Ifc2x3::IfcApproval* RelatedApproval() const;
    void setRelatedApproval(::Ifc2x3::IfcApproval* v);
    /// The approval that other approval is related to.
    ::Ifc2x3::IfcApproval* RelatingApproval() const;
    void setRelatingApproval(::Ifc2x3::IfcApproval* v);
    /// Whether the optional attribute Description is defined for this IfcApprovalRelationship
    bool hasDescription() const;
    std::string Description() const;
    void setDescription(std::string v);
    std::string Name() const;
    void setName(std::string v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcApprovalRelationship (IfcEntityInstanceData* e);
    IfcApprovalRelationship (::Ifc2x3::IfcApproval* v1_RelatedApproval, ::Ifc2x3::IfcApproval* v2_RelatingApproval, boost::optional< std::string > v3_Description, std::string v4_Name);
    typedef IfcTemplatedEntityList< IfcApprovalRelationship > list;
};
/// Definition
/// from IAI: The abstract entity IfcBoundaryCondition
/// is the supertype of all boundary conditions that can be applied to
/// structural connection definitions, either directly for the connection
/// (e.g. the joint) or for the relation between a structural member and
/// the connection.
/// NOTE: The boundary conditions are used
/// within other parts, mainly by instances of IfcStructuralConnection
/// (for the definition of supports) and instances of IfcRelConnectsStructuralMember
/// (for the definition of connections between structural members and
/// structural connections). 
/// 
/// HISTORY: New entity
/// in Release IFC2x Edition
/// 2.
class IFC_PARSE_API IfcBoundaryCondition : public IfcUtil::IfcBaseEntity {
public:
    /// Whether the optional attribute Name is defined for this IfcBoundaryCondition
    bool hasName() const;
    /// Optionally defines a name for this boundary condition.
    std::string Name() const;
    void setName(std::string v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcBoundaryCondition (IfcEntityInstanceData* e);
    IfcBoundaryCondition (boost::optional< std::string > v1_Name);
    typedef IfcTemplatedEntityList< IfcBoundaryCondition > list;
};
/// Definition from IAI: Describes linearly elastic support conditions or connection conditions.
/// 
/// Applicability:
/// 
/// Curve supports and connections.
/// 
/// HISTORY: New entity in IFC 2x2.
/// IFC 2x4 change: Attributes LinearStiffnessX/Y/Z renamed to TranslationalStiffnessX/Y/Z.
/// 
/// IFC 2x4 change: All attribute data types changed from numeric to SELECT between Boolean and numeric.  Stiffnesses may now also be negative, for example to capture destabilizing effects in boundary conditions.  The IFC 2x3 convention of -1. representing infinite stiffness is no longer valid and must not be used.  Infinite stiffness, i.e. fixed supports, are now modeled by the Boolean value TRUE.
class IFC_PARSE_API IfcBoundaryEdgeCondition : public IfcBoundaryCondition {
public:
    /// Whether the optional attribute LinearStiffnessByLengthX is defined for this IfcBoundaryEdgeCondition
    bool hasLinearStiffnessByLengthX() const;
    double LinearStiffnessByLengthX() const;
    void setLinearStiffnessByLengthX(double v);
    /// Whether the optional attribute LinearStiffnessByLengthY is defined for this IfcBoundaryEdgeCondition
    bool hasLinearStiffnessByLengthY() const;
    double LinearStiffnessByLengthY() const;
    void setLinearStiffnessByLengthY(double v);
    /// Whether the optional attribute LinearStiffnessByLengthZ is defined for this IfcBoundaryEdgeCondition
    bool hasLinearStiffnessByLengthZ() const;
    double LinearStiffnessByLengthZ() const;
    void setLinearStiffnessByLengthZ(double v);
    /// Whether the optional attribute RotationalStiffnessByLengthX is defined for this IfcBoundaryEdgeCondition
    bool hasRotationalStiffnessByLengthX() const;
    /// Rotational stiffness value about the x-axis of the coordinate system defined by the instance which uses this resource object.
    double RotationalStiffnessByLengthX() const;
    void setRotationalStiffnessByLengthX(double v);
    /// Whether the optional attribute RotationalStiffnessByLengthY is defined for this IfcBoundaryEdgeCondition
    bool hasRotationalStiffnessByLengthY() const;
    /// Rotational stiffness value about the y-axis of the coordinate system defined by the instance which uses this resource object.
    double RotationalStiffnessByLengthY() const;
    void setRotationalStiffnessByLengthY(double v);
    /// Whether the optional attribute RotationalStiffnessByLengthZ is defined for this IfcBoundaryEdgeCondition
    bool hasRotationalStiffnessByLengthZ() const;
    /// Rotational stiffness value about the z-axis of the coordinate system defined by the instance which uses this resource object.
    double RotationalStiffnessByLengthZ() const;
    void setRotationalStiffnessByLengthZ(double v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcBoundaryEdgeCondition (IfcEntityInstanceData* e);
    IfcBoundaryEdgeCondition (boost::optional< std::string > v1_Name, boost::optional< double > v2_LinearStiffnessByLengthX, boost::optional< double > v3_LinearStiffnessByLengthY, boost::optional< double > v4_LinearStiffnessByLengthZ, boost::optional< double > v5_RotationalStiffnessByLengthX, boost::optional< double > v6_RotationalStiffnessByLengthY, boost::optional< double > v7_RotationalStiffnessByLengthZ);
    typedef IfcTemplatedEntityList< IfcBoundaryEdgeCondition > list;
};
/// Definition from IAI: Describes linearly elastic support conditions or connection conditions.
/// 
/// Applicability:
/// 
/// Surface supports and connections.
/// 
/// HISTORY: New entity in IFC 2x2.
/// IFC 2x4 change: Attributes LinearStiffnessX/Y/Z renamed to TranslationalStiffnessX/Y/Z.
/// 
/// IFC 2x4 change: All attribute data types changed from numeric to SELECT between Boolean and numeric.  Stiffnesses may now also be negative, for example to capture destabilizing effects in boundary conditions.  The IFC 2x3 convention of -1. representing infinite stiffness is no longer valid and must not be used.  Infinite stiffness, i.e. fixed supports, are now modeled by the Boolean value TRUE.
class IFC_PARSE_API IfcBoundaryFaceCondition : public IfcBoundaryCondition {
public:
    /// Whether the optional attribute LinearStiffnessByAreaX is defined for this IfcBoundaryFaceCondition
    bool hasLinearStiffnessByAreaX() const;
    double LinearStiffnessByAreaX() const;
    void setLinearStiffnessByAreaX(double v);
    /// Whether the optional attribute LinearStiffnessByAreaY is defined for this IfcBoundaryFaceCondition
    bool hasLinearStiffnessByAreaY() const;
    double LinearStiffnessByAreaY() const;
    void setLinearStiffnessByAreaY(double v);
    /// Whether the optional attribute LinearStiffnessByAreaZ is defined for this IfcBoundaryFaceCondition
    bool hasLinearStiffnessByAreaZ() const;
    double LinearStiffnessByAreaZ() const;
    void setLinearStiffnessByAreaZ(double v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcBoundaryFaceCondition (IfcEntityInstanceData* e);
    IfcBoundaryFaceCondition (boost::optional< std::string > v1_Name, boost::optional< double > v2_LinearStiffnessByAreaX, boost::optional< double > v3_LinearStiffnessByAreaY, boost::optional< double > v4_LinearStiffnessByAreaZ);
    typedef IfcTemplatedEntityList< IfcBoundaryFaceCondition > list;
};
/// Definition from IAI: Describes linearly elastic support conditions or connection conditions.
/// 
/// Applicability:
/// 
/// Point supports and connections.
/// 
/// HISTORY: New entity in IFC 2x2.
/// IFC 2x4 change: Attributes LinearStiffnessX/Y/Z renamed to TranslationalStiffnessX/Y/Z.
/// 
/// IFC 2x4 change: All attribute data types changed from numeric to SELECT between Boolean and numeric.  Stiffnesses may now also be negative, for example to capture destabilizing effects in boundary conditions.  The IFC 2x3 convention of -1. representing infinite stiffness is no longer valid and must not be used.  Infinite stiffness, i.e. fixed supports, are now modeled by the Boolean value TRUE.
class IFC_PARSE_API IfcBoundaryNodeCondition : public IfcBoundaryCondition {
public:
    /// Whether the optional attribute LinearStiffnessX is defined for this IfcBoundaryNodeCondition
    bool hasLinearStiffnessX() const;
    double LinearStiffnessX() const;
    void setLinearStiffnessX(double v);
    /// Whether the optional attribute LinearStiffnessY is defined for this IfcBoundaryNodeCondition
    bool hasLinearStiffnessY() const;
    double LinearStiffnessY() const;
    void setLinearStiffnessY(double v);
    /// Whether the optional attribute LinearStiffnessZ is defined for this IfcBoundaryNodeCondition
    bool hasLinearStiffnessZ() const;
    double LinearStiffnessZ() const;
    void setLinearStiffnessZ(double v);
    /// Whether the optional attribute RotationalStiffnessX is defined for this IfcBoundaryNodeCondition
    bool hasRotationalStiffnessX() const;
    /// Rotational stiffness value about the x-axis of the coordinate system defined by the instance which uses this resource object.
    double RotationalStiffnessX() const;
    void setRotationalStiffnessX(double v);
    /// Whether the optional attribute RotationalStiffnessY is defined for this IfcBoundaryNodeCondition
    bool hasRotationalStiffnessY() const;
    /// Rotational stiffness value about the y-axis of the coordinate system defined by the instance which uses this resource object.
    double RotationalStiffnessY() const;
    void setRotationalStiffnessY(double v);
    /// Whether the optional attribute RotationalStiffnessZ is defined for this IfcBoundaryNodeCondition
    bool hasRotationalStiffnessZ() const;
    /// Rotational stiffness value about the z-axis of the coordinate system defined by the instance which uses this resource object.
    double RotationalStiffnessZ() const;
    void setRotationalStiffnessZ(double v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcBoundaryNodeCondition (IfcEntityInstanceData* e);
    IfcBoundaryNodeCondition (boost::optional< std::string > v1_Name, boost::optional< double > v2_LinearStiffnessX, boost::optional< double > v3_LinearStiffnessY, boost::optional< double > v4_LinearStiffnessZ, boost::optional< double > v5_RotationalStiffnessX, boost::optional< double > v6_RotationalStiffnessY, boost::optional< double > v7_RotationalStiffnessZ);
    typedef IfcTemplatedEntityList< IfcBoundaryNodeCondition > list;
};
/// Definition from IAI: Describes linearly elastic support conditions or connection conditions, including linearly elastic warping restraints.
/// 
/// Applicability:
/// 
/// Point supports and connections.
/// 
/// HISTORY: New entity in IFC 2x2. 
/// 
/// IFC 2x4 change: All attribute data types changed from numeric to SELECT between Boolean and numeric.  Stiffnesses may now also be negative, for example to capture destabilizing effects in boundary conditions.  The IFC 2x3 convention of -1. representing infinite stiffness is no longer valid and must not be used.  Infinite stiffness, i.e. fixed supports, are now modeled by the Boolean value TRUE.
class IFC_PARSE_API IfcBoundaryNodeConditionWarping : public IfcBoundaryNodeCondition {
public:
    /// Whether the optional attribute WarpingStiffness is defined for this IfcBoundaryNodeConditionWarping
    bool hasWarpingStiffness() const;
    /// Defines the warping stiffness value.
    double WarpingStiffness() const;
    void setWarpingStiffness(double v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcBoundaryNodeConditionWarping (IfcEntityInstanceData* e);
    IfcBoundaryNodeConditionWarping (boost::optional< std::string > v1_Name, boost::optional< double > v2_LinearStiffnessX, boost::optional< double > v3_LinearStiffnessY, boost::optional< double > v4_LinearStiffnessZ, boost::optional< double > v5_RotationalStiffnessX, boost::optional< double > v6_RotationalStiffnessY, boost::optional< double > v7_RotationalStiffnessZ, boost::optional< double > v8_WarpingStiffness);
    typedef IfcTemplatedEntityList< IfcBoundaryNodeConditionWarping > list;
};

class IFC_PARSE_API IfcCalendarDate : public IfcUtil::IfcBaseEntity {
public:
    int DayComponent() const;
    void setDayComponent(int v);
    int MonthComponent() const;
    void setMonthComponent(int v);
    int YearComponent() const;
    void setYearComponent(int v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcCalendarDate (IfcEntityInstanceData* e);
    IfcCalendarDate (int v1_DayComponent, int v2_MonthComponent, int v3_YearComponent);
    typedef IfcTemplatedEntityList< IfcCalendarDate > list;
};
/// An IfcClassification is used for the arrangement of objects into a class or category according to a common purpose or their possession of common
/// characteristics. A classification in the sense of IfcClassification is taxonomy, or taxonomic scheme, arranged in a hierarchical structure. A category of objects relates to other categories in a generalization-specialization relationship. Therefore the classification items in an
/// classification are organized in a tree structure.
/// 
/// HISTORY New class in IFC Release 1.5. Modified in IFC 2x.
/// 
/// IFC 2x4 CHANGE Attribute Edition made optional. Attributes: PublicationLocation, Description and ReferenceTokens added. Inverse attribute HasClassificationReferences added.
/// 
/// Classification use definitions
/// IfcClassification identifies the classification system or source from which a classification notation is derived. Each classification reference or classification item, belonging to a single classification system, shall reference a single instance of IfcClassification. Therefore, each particular classification system or source used should have only one IfcClassification instance. However, because multiple classification is allowed, there may be many IfcClassification objects used, each identifying a different classification system or source.
/// 
/// A classification system declared may be either formally published (such as Omniclass, Uniclass, Masterformat, or DIN) or it may be a locally defined method of classifiying information.  There are two methods to define a classification system within an IFC dataset:
/// 
/// Including the classification system structure within the dataset: Here a hierarchical tree of IfcClassificationItem's is included that defines the classification system including the relationship between the classification items. An IfcClassificationNotation is used to classify an object.
/// Referencing the classification system by a classification key or id: Here the IfcClassificationReference is used to assign a classification id or key to each classified object.
class IFC_PARSE_API IfcClassification : public IfcUtil::IfcBaseEntity {
public:
    /// Source (or publisher) for this classification.
    /// 
    /// NOTE that the source of the classification means the person or organization that was the original author or the person or organization currently acting as the publisher.
    std::string Source() const;
    void setSource(std::string v);
    /// The edition or version of the classification system from which the classification notation is derived.
    /// 
    /// NOTE the version labeling system is specific to the classification system. 
    /// 
    /// IFC2x4 CHANGE The attribute has been changed to be optional.
    std::string Edition() const;
    void setEdition(std::string v);
    /// Whether the optional attribute EditionDate is defined for this IfcClassification
    bool hasEditionDate() const;
    /// The date on which the edition of the classification used became valid.
    /// 
    /// NOTE The indication of edition may be sufficient to identify the classification source uniquely but the edition date is provided as an optional attribute to enable more precise identification where required.
    /// 
    /// IFC2x4 CHANGE The data type has been changed to IfcDate, the date string according to ISO8601.
    ::Ifc2x3::IfcCalendarDate* EditionDate() const;
    void setEditionDate(::Ifc2x3::IfcCalendarDate* v);
    /// The name or label by which the classification used is normally known.
    /// 
    /// NOTE Examples of names include CI/SfB, Masterformat, BSAB, Uniclass, STABU, DIN276, DIN277 etc.
    std::string Name() const;
    void setName(std::string v);
        IfcTemplatedEntityList< IfcClassificationItem >::ptr Contains() const; // INVERSE IfcClassificationItem::ItemOf
    virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcClassification (IfcEntityInstanceData* e);
    IfcClassification (std::string v1_Source, std::string v2_Edition, ::Ifc2x3::IfcCalendarDate* v3_EditionDate, std::string v4_Name);
    typedef IfcTemplatedEntityList< IfcClassification > list;
};

class IFC_PARSE_API IfcClassificationItem : public IfcUtil::IfcBaseEntity {
public:
    ::Ifc2x3::IfcClassificationNotationFacet* Notation() const;
    void setNotation(::Ifc2x3::IfcClassificationNotationFacet* v);
    /// Whether the optional attribute ItemOf is defined for this IfcClassificationItem
    bool hasItemOf() const;
    ::Ifc2x3::IfcClassification* ItemOf() const;
    void setItemOf(::Ifc2x3::IfcClassification* v);
    std::string Title() const;
    void setTitle(std::string v);
        IfcTemplatedEntityList< IfcClassificationItemRelationship >::ptr IsClassifiedItemIn() const; // INVERSE IfcClassificationItemRelationship::RelatedItems
    IfcTemplatedEntityList< IfcClassificationItemRelationship >::ptr IsClassifyingItemIn() const; // INVERSE IfcClassificationItemRelationship::RelatingItem
    virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcClassificationItem (IfcEntityInstanceData* e);
    IfcClassificationItem (::Ifc2x3::IfcClassificationNotationFacet* v1_Notation, ::Ifc2x3::IfcClassification* v2_ItemOf, std::string v3_Title);
    typedef IfcTemplatedEntityList< IfcClassificationItem > list;
};

class IFC_PARSE_API IfcClassificationItemRelationship : public IfcUtil::IfcBaseEntity {
public:
    ::Ifc2x3::IfcClassificationItem* RelatingItem() const;
    void setRelatingItem(::Ifc2x3::IfcClassificationItem* v);
    IfcTemplatedEntityList< ::Ifc2x3::IfcClassificationItem >::ptr RelatedItems() const;
    void setRelatedItems(IfcTemplatedEntityList< ::Ifc2x3::IfcClassificationItem >::ptr v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcClassificationItemRelationship (IfcEntityInstanceData* e);
    IfcClassificationItemRelationship (::Ifc2x3::IfcClassificationItem* v1_RelatingItem, IfcTemplatedEntityList< ::Ifc2x3::IfcClassificationItem >::ptr v2_RelatedItems);
    typedef IfcTemplatedEntityList< IfcClassificationItemRelationship > list;
};

class IFC_PARSE_API IfcClassificationNotation : public IfcUtil::IfcBaseEntity {
public:
    IfcTemplatedEntityList< ::Ifc2x3::IfcClassificationNotationFacet >::ptr NotationFacets() const;
    void setNotationFacets(IfcTemplatedEntityList< ::Ifc2x3::IfcClassificationNotationFacet >::ptr v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcClassificationNotation (IfcEntityInstanceData* e);
    IfcClassificationNotation (IfcTemplatedEntityList< ::Ifc2x3::IfcClassificationNotationFacet >::ptr v1_NotationFacets);
    typedef IfcTemplatedEntityList< IfcClassificationNotation > list;
};

class IFC_PARSE_API IfcClassificationNotationFacet : public IfcUtil::IfcBaseEntity {
public:
    std::string NotationValue() const;
    void setNotationValue(std::string v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcClassificationNotationFacet (IfcEntityInstanceData* e);
    IfcClassificationNotationFacet (std::string v1_NotationValue);
    typedef IfcTemplatedEntityList< IfcClassificationNotationFacet > list;
};
/// Definition from ISO/CD 10303-46:1992: The colour specification entity contains a direct colour definition. Colour component values refer directly to a specific colour space.
/// 
/// NOTE  Corresponding ISO 10303 name: colour_specification. It has been made into an abstract entity in IFC. Please refer to ISO/IS 10303-46:1994, p. 138 for the final definition of the formal standard.
/// 
/// HISTORY  New entity in IFC2x2.
class IFC_PARSE_API IfcColourSpecification : public IfcUtil::IfcBaseEntity {
public:
    /// Whether the optional attribute Name is defined for this IfcColourSpecification
    bool hasName() const;
    /// Optional name given to a particular colour specification in addition to the colour components (like the RGB values).
    /// 
    /// NOTE  Examples are the names of a industry colour classification, such as RAL.
    /// IFC2x Edition 3 CHANGE  Attribute added.
    std::string Name() const;
    void setName(std::string v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcColourSpecification (IfcEntityInstanceData* e);
    IfcColourSpecification (boost::optional< std::string > v1_Name);
    typedef IfcTemplatedEntityList< IfcColourSpecification > list;
};
/// IfcConnectionGeometry is used to describe the geometric and topological constraints that facilitate the physical connection of two objects. It is envisioned as a control that applies to the element connection relationships.
/// 
/// NOTE  The element connection relationship normally provides for a logical connection information, by referencing the relating and related elements. If in addition an IfcConnectionGeometry is provided, physical connection information is given by specifying exactly where at the relating and related element the element connection occurs. 
/// Using the eccentricity subtypes, the connection can also be described when there is a physical distance (or eccentricity) between the connection elements.
/// 
/// The IfcConnectionGeometry allows for the provision of connection constraints between geometric and topological elements, the following connection geometry/topology types are in scope:
/// 
/// point | vertex point,
///   curve | edge curve,
///   surface | face surface,
/// 
/// HISTORY  New entity in IFC Release 1.5.
/// 
/// IFC2x Edition 3 CHANGE  The definition of the subtypes has been enhanced by allowing either geometric representation items (point | curve | surface) or topological representation items with associated geometry (vertex point | edge curve | face  surface).
class IFC_PARSE_API IfcConnectionGeometry : public IfcUtil::IfcBaseEntity {
public:
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcConnectionGeometry (IfcEntityInstanceData* e);
    IfcConnectionGeometry ();
    typedef IfcTemplatedEntityList< IfcConnectionGeometry > list;
};
/// IfcConnectionPointGeometry
/// is used to describe the geometric constraints that facilitate the
/// physical connection of two objects at a point (here IfcCartesianPoint) or at an vertex with point
/// coordinates associated. It is envisioned as a control that applies to the element connection relationships. 
/// 
/// EXAMPLE  The connection relationship between two path based elements (like a column and a beam) has a geometric constraint which describes the connection points by a PointOnRelatingElement for the column and a PointOnRelatedElement for the beam. The exact usage of the IfcConnectionPointGeometry is further defined in the geometry use sections of the elements that use it.
/// 
/// NOTE  If the point connection has an offset (if the two points or vertex points at the relating and related element do not physically match), the subtype IfcConnectionPointEccentricity shall be used.
/// 
/// HISTORY  New entity in IFC Release 1.5, has been renamed from IfcPointConnectionGeometry in IFC Release 2x.
/// 
/// IFC2x Edition 3 CHANGE  The provision of topology with associated geometry, IfcVertexPoint, is
/// enabled by using the IfcPointOrVertexPoint.
/// 
/// Geometry use definitions
/// The IfcPoint (or the IfcVertexPoint with an associated IfcPoint) at the PointOnRelatingElement attribute defines the point where the basic geometry items of the connected elements connect. The point coordinates are provided within the local coordinate system of the RelatingElement, as specified at the IfcRelConnectsSubtype that utilizes the IfcConnectionPointGeometry. Optionally, the same point coordinates can also be provided within the local coordinate system of the RelatedElement by using the PointOnRelatedElement attribute. If both point coordinates are not identical within a common parent coordinate system (ultimately within the world coordinate system), the subtype IfcConnectionPointEccentricity shall be used.
class IFC_PARSE_API IfcConnectionPointGeometry : public IfcConnectionGeometry {
public:
    /// Point at which the connected object is aligned at the relating element, given in the LCS of the relating element.
    ::Ifc2x3::IfcPointOrVertexPoint* PointOnRelatingElement() const;
    void setPointOnRelatingElement(::Ifc2x3::IfcPointOrVertexPoint* v);
    /// Whether the optional attribute PointOnRelatedElement is defined for this IfcConnectionPointGeometry
    bool hasPointOnRelatedElement() const;
    /// Point at which connected objects are aligned at the related element, given in the LCS of the related element. If the information is omitted, then the origin of the related element is used.
    ::Ifc2x3::IfcPointOrVertexPoint* PointOnRelatedElement() const;
    void setPointOnRelatedElement(::Ifc2x3::IfcPointOrVertexPoint* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcConnectionPointGeometry (IfcEntityInstanceData* e);
    IfcConnectionPointGeometry (::Ifc2x3::IfcPointOrVertexPoint* v1_PointOnRelatingElement, ::Ifc2x3::IfcPointOrVertexPoint* v2_PointOnRelatedElement);
    typedef IfcTemplatedEntityList< IfcConnectionPointGeometry > list;
};

class IFC_PARSE_API IfcConnectionPortGeometry : public IfcConnectionGeometry {
public:
    ::Ifc2x3::IfcAxis2Placement* LocationAtRelatingElement() const;
    void setLocationAtRelatingElement(::Ifc2x3::IfcAxis2Placement* v);
    /// Whether the optional attribute LocationAtRelatedElement is defined for this IfcConnectionPortGeometry
    bool hasLocationAtRelatedElement() const;
    ::Ifc2x3::IfcAxis2Placement* LocationAtRelatedElement() const;
    void setLocationAtRelatedElement(::Ifc2x3::IfcAxis2Placement* v);
    ::Ifc2x3::IfcProfileDef* ProfileOfPort() const;
    void setProfileOfPort(::Ifc2x3::IfcProfileDef* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcConnectionPortGeometry (IfcEntityInstanceData* e);
    IfcConnectionPortGeometry (::Ifc2x3::IfcAxis2Placement* v1_LocationAtRelatingElement, ::Ifc2x3::IfcAxis2Placement* v2_LocationAtRelatedElement, ::Ifc2x3::IfcProfileDef* v3_ProfileOfPort);
    typedef IfcTemplatedEntityList< IfcConnectionPortGeometry > list;
};
/// IfcConnectionSurfaceGeometry is used to describe the geometric constraints that facilitate the physical connection of two objects at a surface or at a face with surface geometry associated. It is envisioned as a control that applies to the element connection relationships. 
/// 
/// HISTORY  New entity in IFC Release 2x.
/// 
/// IFC2x Edition 3 CHANGE  The provision of topology with associated geometry, IfcFaceSurface, is enabled by using the IfcSurfaceOrFaceSurface.
/// 
/// Geometry use definitions 
/// The IfcSurface (or the IfcFaceSurface with an associated IfcSurface) at the SurfaceOnRelatingElement attribute defines the surface where the basic geometry items of the connected elements connects. The surface geometry and coordinates are provided within the local coordinate system of the RelatingElement, as specified at the IfcRelConnectsSubtype that utilizes the IfcConnectionSurfaceGeometry. Optionally, the same surface geometry and coordinates can also be provided within the local coordinate system of the RelatedElement by using the SurfaceOnRelatedElement attribute.
class IFC_PARSE_API IfcConnectionSurfaceGeometry : public IfcConnectionGeometry {
public:
    /// Surface at which related object is aligned at the relating element, given in the LCS of the relating element.
    ::Ifc2x3::IfcSurfaceOrFaceSurface* SurfaceOnRelatingElement() const;
    void setSurfaceOnRelatingElement(::Ifc2x3::IfcSurfaceOrFaceSurface* v);
    /// Whether the optional attribute SurfaceOnRelatedElement is defined for this IfcConnectionSurfaceGeometry
    bool hasSurfaceOnRelatedElement() const;
    /// Surface at which the relating element is aligned at the related element, given in the LCS of the related element. If the information is omitted, then the origin of the related element is used.
    ::Ifc2x3::IfcSurfaceOrFaceSurface* SurfaceOnRelatedElement() const;
    void setSurfaceOnRelatedElement(::Ifc2x3::IfcSurfaceOrFaceSurface* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcConnectionSurfaceGeometry (IfcEntityInstanceData* e);
    IfcConnectionSurfaceGeometry (::Ifc2x3::IfcSurfaceOrFaceSurface* v1_SurfaceOnRelatingElement, ::Ifc2x3::IfcSurfaceOrFaceSurface* v2_SurfaceOnRelatedElement);
    typedef IfcTemplatedEntityList< IfcConnectionSurfaceGeometry > list;
};
/// An IfcConstraint is used to define a constraint or limiting value or boundary condition that may be applied to an object or to the value of a property.  
/// 
/// HISTORY: New Entity in IFC Release 2.0
/// 
/// Use Definition 
/// IfcConstraint may be associated with any subtype of IfcRoot (unless restricted in specific subtypes) through the IfcRelAssociatesConstraint relationship in the IfcControlExtension schema, or may be associated with IfcProperty by IfcPropertyConstraintRelationship. 
/// 
/// A constraint may aggregate other constraints through the IfcConstraintAggregationRelationship through which a logical association between constraints may be applied, or constraints may have other defined relationship to other constraints via IfcConstraintRelationship. 
/// 
/// A constraint must have a name applied through the IfcConstraint.Name attribute and optionally, a description through IfcConstraint.Description. The grade of the constraint (hard, soft, advisory) must be specified through IfcConstraint.ConstraintGrade or IfcConstraint.UserDefinedGrade whilst the source, creating actor and time at which the constraint is created may be optionally asserted through IfcConstraint.ConstraintSource, IfcConstraint.CreatingActor and IfcConstraint.CreationTime. 
/// 
/// A constraint may also have additional external information (such as classification or document information) associated to it by IfcExternalReferenceRelationship, accessible through inverse attribute IfcConstraint.HasExternalReferences
class IFC_PARSE_API IfcConstraint : public IfcUtil::IfcBaseEntity {
public:
    /// A name to be used for the constraint (e.g., ChillerCoefficientOfPerformance).
    std::string Name() const;
    void setName(std::string v);
    /// Whether the optional attribute Description is defined for this IfcConstraint
    bool hasDescription() const;
    /// A description that may apply additional information about a constraint.
    std::string Description() const;
    void setDescription(std::string v);
    /// Enumeration that qualifies the type of constraint.
    ::Ifc2x3::IfcConstraintEnum::Value ConstraintGrade() const;
    void setConstraintGrade(::Ifc2x3::IfcConstraintEnum::Value v);
    /// Whether the optional attribute ConstraintSource is defined for this IfcConstraint
    bool hasConstraintSource() const;
    /// Any source material, such as a code or standard, from which the constraint originated.
    std::string ConstraintSource() const;
    void setConstraintSource(std::string v);
    /// Whether the optional attribute CreatingActor is defined for this IfcConstraint
    bool hasCreatingActor() const;
    /// Person and/or organization that has created the constraint.
    ::Ifc2x3::IfcActorSelect* CreatingActor() const;
    void setCreatingActor(::Ifc2x3::IfcActorSelect* v);
    /// Whether the optional attribute CreationTime is defined for this IfcConstraint
    bool hasCreationTime() const;
    /// Time when information specifying the constraint instance was created.
    /// 
    /// Note IFC2x4 CHANGE: Attribute data type changed to IfcDateTime using ISO 8601 representation
    ::Ifc2x3::IfcDateTimeSelect* CreationTime() const;
    void setCreationTime(::Ifc2x3::IfcDateTimeSelect* v);
    /// Whether the optional attribute UserDefinedGrade is defined for this IfcConstraint
    bool hasUserDefinedGrade() const;
    /// Allows for specification of user defined grade of the constraint  beyond the enumeration values (hard, soft, advisory) provided by ConstraintGrade attribute of type IfcConstraintEnum. 
    /// When a value is provided for attribute UserDefinedGrade in parallel the attribute ConstraintGrade shall have enumeration value USERDEFINED.
    std::string UserDefinedGrade() const;
    void setUserDefinedGrade(std::string v);
        IfcTemplatedEntityList< IfcConstraintClassificationRelationship >::ptr ClassifiedAs() const; // INVERSE IfcConstraintClassificationRelationship::ClassifiedConstraint
    IfcTemplatedEntityList< IfcConstraintRelationship >::ptr RelatesConstraints() const; // INVERSE IfcConstraintRelationship::RelatingConstraint
    IfcTemplatedEntityList< IfcConstraintRelationship >::ptr IsRelatedWith() const; // INVERSE IfcConstraintRelationship::RelatedConstraints
    IfcTemplatedEntityList< IfcPropertyConstraintRelationship >::ptr PropertiesForConstraint() const; // INVERSE IfcPropertyConstraintRelationship::RelatingConstraint
    IfcTemplatedEntityList< IfcConstraintAggregationRelationship >::ptr Aggregates() const; // INVERSE IfcConstraintAggregationRelationship::RelatingConstraint
    IfcTemplatedEntityList< IfcConstraintAggregationRelationship >::ptr IsAggregatedIn() const; // INVERSE IfcConstraintAggregationRelationship::RelatedConstraints
    virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcConstraint (IfcEntityInstanceData* e);
    IfcConstraint (std::string v1_Name, boost::optional< std::string > v2_Description, ::Ifc2x3::IfcConstraintEnum::Value v3_ConstraintGrade, boost::optional< std::string > v4_ConstraintSource, ::Ifc2x3::IfcActorSelect* v5_CreatingActor, ::Ifc2x3::IfcDateTimeSelect* v6_CreationTime, boost::optional< std::string > v7_UserDefinedGrade);
    typedef IfcTemplatedEntityList< IfcConstraint > list;
};
/// An IfcConstraintAggregationRelationship is an objectified relationship that enables instances of IfcConstraint subtypes to be aggregated together logically. 
/// 
/// HISTORY  New Entity in IFC Release 2.0. Modified in IFC2x2.
/// 
/// IFC2x4 CHANGE  Subtyped from IfcConstraintRelationship
/// 
/// Use definition 
/// IfcConstraintAggregationRelationship allows the aggregation link between subtypes of constraint to be logically defined (AND, OR, XOR, NOTAND, NOTOR). In this way, whereby an object or property can have multiple constraints assigned, and the logical linkage between them can be specified. Thus linked constraints might show as for example (> X AND < Y) which is useful for an allowed range, or bounded value, for example, (A OR B OR C) which is valuable for an enumerated property where a selection is constrained to be (at least) one of A, B or C. 
/// Figure 237 illustrates constraint aggregation.
/// 
/// Figure 237 — Constraint aggregation
class IFC_PARSE_API IfcConstraintAggregationRelationship : public IfcUtil::IfcBaseEntity {
public:
    /// Whether the optional attribute Name is defined for this IfcConstraintAggregationRelationship
    bool hasName() const;
    std::string Name() const;
    void setName(std::string v);
    /// Whether the optional attribute Description is defined for this IfcConstraintAggregationRelationship
    bool hasDescription() const;
    std::string Description() const;
    void setDescription(std::string v);
    ::Ifc2x3::IfcConstraint* RelatingConstraint() const;
    void setRelatingConstraint(::Ifc2x3::IfcConstraint* v);
    IfcTemplatedEntityList< ::Ifc2x3::IfcConstraint >::ptr RelatedConstraints() const;
    void setRelatedConstraints(IfcTemplatedEntityList< ::Ifc2x3::IfcConstraint >::ptr v);
    /// Enumeration that identifies the logical type of aggregation.
    ::Ifc2x3::IfcLogicalOperatorEnum::Value LogicalAggregator() const;
    void setLogicalAggregator(::Ifc2x3::IfcLogicalOperatorEnum::Value v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcConstraintAggregationRelationship (IfcEntityInstanceData* e);
    IfcConstraintAggregationRelationship (boost::optional< std::string > v1_Name, boost::optional< std::string > v2_Description, ::Ifc2x3::IfcConstraint* v3_RelatingConstraint, IfcTemplatedEntityList< ::Ifc2x3::IfcConstraint >::ptr v4_RelatedConstraints, ::Ifc2x3::IfcLogicalOperatorEnum::Value v5_LogicalAggregator);
    typedef IfcTemplatedEntityList< IfcConstraintAggregationRelationship > list;
};

class IFC_PARSE_API IfcConstraintClassificationRelationship : public IfcUtil::IfcBaseEntity {
public:
    ::Ifc2x3::IfcConstraint* ClassifiedConstraint() const;
    void setClassifiedConstraint(::Ifc2x3::IfcConstraint* v);
    IfcEntityList::ptr RelatedClassifications() const;
    void setRelatedClassifications(IfcEntityList::ptr v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcConstraintClassificationRelationship (IfcEntityInstanceData* e);
    IfcConstraintClassificationRelationship (::Ifc2x3::IfcConstraint* v1_ClassifiedConstraint, IfcEntityList::ptr v2_RelatedClassifications);
    typedef IfcTemplatedEntityList< IfcConstraintClassificationRelationship > list;
};
/// An IfcConstraintRelationship is an objectified relationship that enables instances of IfcConstraint and its
/// subtypes to be associated to each other. Logical aggregation of instances of IfcConstraint and its subtypes is handled by the subtype IfcConstraintAggregationRelationship.
/// 
/// EXAMPLE: Certain constraints related to an IfcWall may be derived from a constraint related to an
/// IfcSpace.
/// 
/// HISTORY  New entity in Release IFC2x2 (Addendum 1).
/// 
/// IFC2x4 CHANGE  Subtyped from IfcResourceLevelRelationship.
class IFC_PARSE_API IfcConstraintRelationship : public IfcUtil::IfcBaseEntity {
public:
    /// Whether the optional attribute Name is defined for this IfcConstraintRelationship
    bool hasName() const;
    std::string Name() const;
    void setName(std::string v);
    /// Whether the optional attribute Description is defined for this IfcConstraintRelationship
    bool hasDescription() const;
    std::string Description() const;
    void setDescription(std::string v);
    /// Constraint with which the other Constraints referenced by attribute RelatedConstraints are related.
    ::Ifc2x3::IfcConstraint* RelatingConstraint() const;
    void setRelatingConstraint(::Ifc2x3::IfcConstraint* v);
    /// Constraints that are related with the one referenced as RelatingConstraint.
    IfcTemplatedEntityList< ::Ifc2x3::IfcConstraint >::ptr RelatedConstraints() const;
    void setRelatedConstraints(IfcTemplatedEntityList< ::Ifc2x3::IfcConstraint >::ptr v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcConstraintRelationship (IfcEntityInstanceData* e);
    IfcConstraintRelationship (boost::optional< std::string > v1_Name, boost::optional< std::string > v2_Description, ::Ifc2x3::IfcConstraint* v3_RelatingConstraint, IfcTemplatedEntityList< ::Ifc2x3::IfcConstraint >::ptr v4_RelatedConstraints);
    typedef IfcTemplatedEntityList< IfcConstraintRelationship > list;
};

class IFC_PARSE_API IfcCoordinatedUniversalTimeOffset : public IfcUtil::IfcBaseEntity {
public:
    int HourOffset() const;
    void setHourOffset(int v);
    /// Whether the optional attribute MinuteOffset is defined for this IfcCoordinatedUniversalTimeOffset
    bool hasMinuteOffset() const;
    int MinuteOffset() const;
    void setMinuteOffset(int v);
    ::Ifc2x3::IfcAheadOrBehind::Value Sense() const;
    void setSense(::Ifc2x3::IfcAheadOrBehind::Value v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcCoordinatedUniversalTimeOffset (IfcEntityInstanceData* e);
    IfcCoordinatedUniversalTimeOffset (int v1_HourOffset, boost::optional< int > v2_MinuteOffset, ::Ifc2x3::IfcAheadOrBehind::Value v3_Sense);
    typedef IfcTemplatedEntityList< IfcCoordinatedUniversalTimeOffset > list;
};
/// IfcCostValue is an amount of money or a value that affects an amount of money. 
/// 
/// HISTORY: New Entity in IFC Release 1.0
/// 
/// Use definitions 
/// Each instance of IfcCostValue may also have a CostType. There are many possible types of cost value that may be identified. While there is a broad understanding of the meaning of names that may be assigned to different types of costs, there is no general standard for naming cost types nor are there any broadly defined classifications. To allow for any type of cost value, the IfcLabel datatype is assigned.
/// 
/// The following defines some cost types that might be applied:  
/// 
/// Annual rate of return
/// Bonus
/// Bulk purchase rebate
/// Contract
/// Consultancy
/// Delivery
/// Estimated cost
/// Hire
/// Installation
/// Interest rate
/// Labor
/// Lease
/// List price
/// Maintenance
/// Material
/// Overhead
/// Postage and packing
/// Profit
/// Purchase 
/// Rental
/// Repair
/// Replacement
/// Sale
/// Small quantity surcharge
/// Spares
/// Storage
/// Sub-Contract
/// Trade discount
/// Transportation
/// Waste allowance
/// Whole life
/// 
/// In the absence of any well-defined standard, it is recommended that local agreements should be made to define allowable and understandable cost value types within a project or region.
class IFC_PARSE_API IfcCostValue : public IfcAppliedValue {
public:
    /// Specification of the type of cost type used.
    /// 
    /// NOTE: There are many possible types of cost value that may be identified. Whilst there is a broad understanding of the meaning of names that may be assigned to different types of costs, there is no general standard for naming cost types nor are there any broadly defined classifications. To allow for any type of cost value, the IfcLabel datatype is assigned.
    /// 
    /// In the absence of any well defined standard, it is recommended that local agreements should be made to define allowable and understandable cost value types within a project or region.
    std::string CostType() const;
    void setCostType(std::string v);
    /// Whether the optional attribute Condition is defined for this IfcCostValue
    bool hasCondition() const;
    /// The condition under which a cost value applies.
    std::string Condition() const;
    void setCondition(std::string v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcCostValue (IfcEntityInstanceData* e);
    IfcCostValue (boost::optional< std::string > v1_Name, boost::optional< std::string > v2_Description, ::Ifc2x3::IfcAppliedValueSelect* v3_AppliedValue, ::Ifc2x3::IfcMeasureWithUnit* v4_UnitBasis, ::Ifc2x3::IfcDateTimeSelect* v5_ApplicableDate, ::Ifc2x3::IfcDateTimeSelect* v6_FixedUntilDate, std::string v7_CostType, boost::optional< std::string > v8_Condition);
    typedef IfcTemplatedEntityList< IfcCostValue > list;
};
/// IfcCurrencyRelationship defines the rate of exchange
/// that applies between two designated currencies at a particular time
/// and as published by a particular source.
/// 
/// HISTORY  New Entity in IFC2x2.
/// 
/// IFC2x4 CHANGE  Subtyped from IfcResourceLevelRelationship, attribute order changed.
/// 
/// Use definitions
/// An IfcCurrencyRelationship is used where there may be a need to reference an IfcCostValue in one currency to an IfcCostValue in another currency. It takes account of fact that currency exchange rates may vary by requiring the recording the date and time of the currency exchange rate used and the source that publishes the rate. There may be many sources and there are different strategies for currency conversion (spot rate, forward buying of currency at a fixed rate).
/// The source for the currency exchange is defined as an instance of IfcLibraryInformation that includes a name and a URL.
class IFC_PARSE_API IfcCurrencyRelationship : public IfcUtil::IfcBaseEntity {
public:
    /// The monetary unit from which an exchange is derived. For instance, in the case of a conversion from GBP to USD, the relating monetary unit is GBP.
    ::Ifc2x3::IfcMonetaryUnit* RelatingMonetaryUnit() const;
    void setRelatingMonetaryUnit(::Ifc2x3::IfcMonetaryUnit* v);
    /// The monetary unit to which an exchange results. For instance, in the case of a conversion from GBP to USD, the related monetary unit is USD.
    ::Ifc2x3::IfcMonetaryUnit* RelatedMonetaryUnit() const;
    void setRelatedMonetaryUnit(::Ifc2x3::IfcMonetaryUnit* v);
    /// The currently agreed ratio of the amount of a related monetary unit that is equivalent to a unit amount of the relating monetary unit in a currency relationship. For instance, in the case of a conversion from GBP to USD, the value of the exchange rate may be 1.486 (USD) : 1 (GBP).
    double ExchangeRate() const;
    void setExchangeRate(double v);
    /// The date and time at which an exchange rate applies.
    /// 
    /// IFC2x4 CHANGE Type changed from IfcDateTimeSelect. Attribute made optional.
    ::Ifc2x3::IfcDateAndTime* RateDateTime() const;
    void setRateDateTime(::Ifc2x3::IfcDateAndTime* v);
    /// Whether the optional attribute RateSource is defined for this IfcCurrencyRelationship
    bool hasRateSource() const;
    /// The source from which an exchange rate is obtained.
    ::Ifc2x3::IfcLibraryInformation* RateSource() const;
    void setRateSource(::Ifc2x3::IfcLibraryInformation* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcCurrencyRelationship (IfcEntityInstanceData* e);
    IfcCurrencyRelationship (::Ifc2x3::IfcMonetaryUnit* v1_RelatingMonetaryUnit, ::Ifc2x3::IfcMonetaryUnit* v2_RelatedMonetaryUnit, double v3_ExchangeRate, ::Ifc2x3::IfcDateAndTime* v4_RateDateTime, ::Ifc2x3::IfcLibraryInformation* v5_RateSource);
    typedef IfcTemplatedEntityList< IfcCurrencyRelationship > list;
};
/// Definition from ISO/CD 10303-46:1992: A curve style font combines several curve style font pattern entities into a more complex pattern. The resulting pattern is repeated along the curve. 
/// 
/// NOTE: Corresponding ISO 10303 name: curve_style_font. Please refer to ISO/IS 10303-46:1994 for the final definition of the formal standard.
/// 
/// HISTORY: New entity in IFC2x2.
class IFC_PARSE_API IfcCurveStyleFont : public IfcUtil::IfcBaseEntity {
public:
    /// Whether the optional attribute Name is defined for this IfcCurveStyleFont
    bool hasName() const;
    /// Name that may be assigned with the curve font.
    std::string Name() const;
    void setName(std::string v);
    /// A list of curve font pattern entities, that contains the simple patterns used for drawing curves. The patterns are applied in the order they occur in the list.
    IfcTemplatedEntityList< ::Ifc2x3::IfcCurveStyleFontPattern >::ptr PatternList() const;
    void setPatternList(IfcTemplatedEntityList< ::Ifc2x3::IfcCurveStyleFontPattern >::ptr v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcCurveStyleFont (IfcEntityInstanceData* e);
    IfcCurveStyleFont (boost::optional< std::string > v1_Name, IfcTemplatedEntityList< ::Ifc2x3::IfcCurveStyleFontPattern >::ptr v2_PatternList);
    typedef IfcTemplatedEntityList< IfcCurveStyleFont > list;
};
/// Definition from ISO/CD 10303-46:1992: A curve style font and scaling is a curve style font and a scalar factor for that font, so that a given curve style font may be applied at various scales.
/// 
/// The IfcCurveStyleFontAndScaling allows for the reuse of the same curve style definition in several sizes. The definition of the CurveFontScale is the scaling of a base curve style pattern to be used as a new or derived curve style pattern.
/// 
/// NOTE  The CurveFontScale should not be mixed up with the target plot scale.
/// 
/// An example for IfcCurveStyleFontAndScaling is the sizing of a basic curve style dash pattern 'dash' (visible 0.01m, invisible 0.005m) into 'dash large' with CurveFontScale = 2 (resulting in visible 0.02m, invisible 0.01m), and into 'dash small' with CurveFontScale = 0.5 (resulting in visible 0.005m, invisible 0.0025m).
/// 
/// NOTE  Corresponding ISO 10303 name: curve_style_font_and_scaling. Please refer to ISO/IS 10303-46:1994 for the final definition of the formal standard.
/// 
/// HISTORY  New entity in IFC2x2.
class IFC_PARSE_API IfcCurveStyleFontAndScaling : public IfcUtil::IfcBaseEntity {
public:
    /// Whether the optional attribute Name is defined for this IfcCurveStyleFontAndScaling
    bool hasName() const;
    /// Name that may be assigned with the scaling of a curve font.
    std::string Name() const;
    void setName(std::string v);
    /// The curve font to be scaled.
    ::Ifc2x3::IfcCurveStyleFontSelect* CurveFont() const;
    void setCurveFont(::Ifc2x3::IfcCurveStyleFontSelect* v);
    /// The scale factor.
    double CurveFontScaling() const;
    void setCurveFontScaling(double v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcCurveStyleFontAndScaling (IfcEntityInstanceData* e);
    IfcCurveStyleFontAndScaling (boost::optional< std::string > v1_Name, ::Ifc2x3::IfcCurveStyleFontSelect* v2_CurveFont, double v3_CurveFontScaling);
    typedef IfcTemplatedEntityList< IfcCurveStyleFontAndScaling > list;
};
/// Definition from ISO/CD 10303-46:1992: A curve style font pattern is a pair of visible and invisible curve segment length measures in presentation area units. 
/// 
/// NOTE Corresponding ISO 10303 name: curve_style_font_pattern. Please refer to ISO/IS 10303-46:1994 for the final definition of the formal standard.
/// 
/// HISTORY New entity in IFC2x2.
class IFC_PARSE_API IfcCurveStyleFontPattern : public IfcUtil::IfcBaseEntity {
public:
    /// The length of the visible segment in the pattern definition.
    /// 
    /// NOTE  For a visible segment representing a point, the value 0. should be assigned.
    /// 
    /// IFC2x Edition 3 CHANGE  The datatype has been changed to IfcLengthMeasure with upward compatibility for file-based exchange.
    double VisibleSegmentLength() const;
    void setVisibleSegmentLength(double v);
    /// The length of the invisible segment in the pattern definition.
    double InvisibleSegmentLength() const;
    void setInvisibleSegmentLength(double v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcCurveStyleFontPattern (IfcEntityInstanceData* e);
    IfcCurveStyleFontPattern (double v1_VisibleSegmentLength, double v2_InvisibleSegmentLength);
    typedef IfcTemplatedEntityList< IfcCurveStyleFontPattern > list;
};

class IFC_PARSE_API IfcDateAndTime : public IfcUtil::IfcBaseEntity {
public:
    ::Ifc2x3::IfcCalendarDate* DateComponent() const;
    void setDateComponent(::Ifc2x3::IfcCalendarDate* v);
    ::Ifc2x3::IfcLocalTime* TimeComponent() const;
    void setTimeComponent(::Ifc2x3::IfcLocalTime* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcDateAndTime (IfcEntityInstanceData* e);
    IfcDateAndTime (::Ifc2x3::IfcCalendarDate* v1_DateComponent, ::Ifc2x3::IfcLocalTime* v2_TimeComponent);
    typedef IfcTemplatedEntityList< IfcDateAndTime > list;
};
/// Definition from ISO/CD 10303-41:1992: A derived unit is an expression of units.
/// 
/// EXAMPLE: Newton per square millimetre is a derived unit.
/// 
/// NOTE: Corresponding ISO 10303 name: derived_unit, please refer to ISO/IS 10303-41 for the final definition of the formal standard.
/// 
/// HISTORY: New entity in IFC Release 1.5.1.
class IFC_PARSE_API IfcDerivedUnit : public IfcUtil::IfcBaseEntity {
public:
    /// The group of units and their exponents that define the derived unit.
    IfcTemplatedEntityList< ::Ifc2x3::IfcDerivedUnitElement >::ptr Elements() const;
    void setElements(IfcTemplatedEntityList< ::Ifc2x3::IfcDerivedUnitElement >::ptr v);
    /// Name of the derived unit chosen from an enumeration of derived unit types for use in IFC models.
    ::Ifc2x3::IfcDerivedUnitEnum::Value UnitType() const;
    void setUnitType(::Ifc2x3::IfcDerivedUnitEnum::Value v);
    /// Whether the optional attribute UserDefinedType is defined for this IfcDerivedUnit
    bool hasUserDefinedType() const;
    std::string UserDefinedType() const;
    void setUserDefinedType(std::string v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcDerivedUnit (IfcEntityInstanceData* e);
    IfcDerivedUnit (IfcTemplatedEntityList< ::Ifc2x3::IfcDerivedUnitElement >::ptr v1_Elements, ::Ifc2x3::IfcDerivedUnitEnum::Value v2_UnitType, boost::optional< std::string > v3_UserDefinedType);
    typedef IfcTemplatedEntityList< IfcDerivedUnit > list;
};
/// Definition from ISO/CD 10303-41:1992: A derived unit element is one of the unit quantities 
/// which makes up a derived unit.
/// 
/// EXAMPLE: Newtons per square millimetre is a derived unit. 
/// It has two elements, Newton whose exponent has a value of 1 and millimetre whose exponent is -2.
/// 
/// NOTE: Corresponding ISO 10303 name: derived_unit_element, please refer to ISO/IS 10303-41 for the final definition of the formal standard.
/// 
/// HISTORY New entity in IFC Release 1.5.1.
class IFC_PARSE_API IfcDerivedUnitElement : public IfcUtil::IfcBaseEntity {
public:
    /// The fixed quantity which is used as the mathematical factor.
    ::Ifc2x3::IfcNamedUnit* Unit() const;
    void setUnit(::Ifc2x3::IfcNamedUnit* v);
    /// The power that is applied to the unit attribute.
    int Exponent() const;
    void setExponent(int v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcDerivedUnitElement (IfcEntityInstanceData* e);
    IfcDerivedUnitElement (::Ifc2x3::IfcNamedUnit* v1_Unit, int v2_Exponent);
    typedef IfcTemplatedEntityList< IfcDerivedUnitElement > list;
};
/// Definition from ISO/CD 10303-41:1992: The dimensionality of any quantity can be expressed as a product of powers of the dimensions of base quantities. 
/// The dimensional exponents entity defines the powers of the dimensions of the base quantities. All the physical 
/// quantities are founded on seven base quantities (ISO 31 (clause 2)).
/// 
/// NOTE: Length, mass, time, electric current, thermodynamic temperature, amount of substance, 
/// and luminous intensity are the seven base quantities.
/// 
/// EXAMPLE: A length of 2 millimetres has a length exponent of 1. The remaining exponents 
/// are equal to 0.
/// 
/// EXAMPLE: A velocity of 2 millimetres per second has a length exponent of 1 and 
/// a time exponent of -1. The remaining exponents are equal to 0.
/// 
/// NOTE Corresponding STEP name: dimensional_exponents, please refer to ISO/IS 10303-41
///   for the final definition of the formal standard.
/// 
/// HISTORY New entity in IFC Release 1.5.1.
class IFC_PARSE_API IfcDimensionalExponents : public IfcUtil::IfcBaseEntity {
public:
    /// The power of the length base quantity.
    int LengthExponent() const;
    void setLengthExponent(int v);
    /// The power of the mass base quantity.
    int MassExponent() const;
    void setMassExponent(int v);
    /// The power of the time base quantity.
    int TimeExponent() const;
    void setTimeExponent(int v);
    /// The power of the electric current base quantity.
    int ElectricCurrentExponent() const;
    void setElectricCurrentExponent(int v);
    /// The power of the thermodynamic temperature base quantity.
    int ThermodynamicTemperatureExponent() const;
    void setThermodynamicTemperatureExponent(int v);
    /// The power of the amount of substance base quantity.
    int AmountOfSubstanceExponent() const;
    void setAmountOfSubstanceExponent(int v);
    /// The power of the luminous intensity base quantity.
    int LuminousIntensityExponent() const;
    void setLuminousIntensityExponent(int v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcDimensionalExponents (IfcEntityInstanceData* e);
    IfcDimensionalExponents (int v1_LengthExponent, int v2_MassExponent, int v3_TimeExponent, int v4_ElectricCurrentExponent, int v5_ThermodynamicTemperatureExponent, int v6_AmountOfSubstanceExponent, int v7_LuminousIntensityExponent);
    typedef IfcTemplatedEntityList< IfcDimensionalExponents > list;
};
/// IfcDocumentElectronicFormat captures the type of document being referenced as an external source, and for which metadata is specified by IfcDocumentInformation. 
/// 
/// HISTORY: New entity in IFC 2x
class IFC_PARSE_API IfcDocumentElectronicFormat : public IfcUtil::IfcBaseEntity {
public:
    /// Whether the optional attribute FileExtension is defined for this IfcDocumentElectronicFormat
    bool hasFileExtension() const;
    /// File extension of electronic document used by computer operating system.
    std::string FileExtension() const;
    void setFileExtension(std::string v);
    /// Whether the optional attribute MimeContentType is defined for this IfcDocumentElectronicFormat
    bool hasMimeContentType() const;
    /// Main Mime type (as published by W3C or as user defined application type).
    std::string MimeContentType() const;
    void setMimeContentType(std::string v);
    /// Whether the optional attribute MimeSubtype is defined for this IfcDocumentElectronicFormat
    bool hasMimeSubtype() const;
    /// Mime subtype information.
    std::string MimeSubtype() const;
    void setMimeSubtype(std::string v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcDocumentElectronicFormat (IfcEntityInstanceData* e);
    IfcDocumentElectronicFormat (boost::optional< std::string > v1_FileExtension, boost::optional< std::string > v2_MimeContentType, boost::optional< std::string > v3_MimeSubtype);
    typedef IfcTemplatedEntityList< IfcDocumentElectronicFormat > list;
};
/// IfcDocumentInformation captures "metadata" of an external document. The actual content of the document is not defined in IFC; instead, it can be found following the reference given to IfcDocumentReference. 
/// 
/// HISTORY: New entity in IFC 2x.
class IFC_PARSE_API IfcDocumentInformation : public IfcUtil::IfcBaseEntity {
public:
    /// Identifier that uniquely identifies a document.
    std::string DocumentId() const;
    void setDocumentId(std::string v);
    /// File name or document name assigned by owner.
    std::string Name() const;
    void setName(std::string v);
    /// Whether the optional attribute Description is defined for this IfcDocumentInformation
    bool hasDescription() const;
    /// Description of document and its content.
    std::string Description() const;
    void setDescription(std::string v);
    /// Whether the optional attribute DocumentReferences is defined for this IfcDocumentInformation
    bool hasDocumentReferences() const;
    IfcTemplatedEntityList< ::Ifc2x3::IfcDocumentReference >::ptr DocumentReferences() const;
    void setDocumentReferences(IfcTemplatedEntityList< ::Ifc2x3::IfcDocumentReference >::ptr v);
    /// Whether the optional attribute Purpose is defined for this IfcDocumentInformation
    bool hasPurpose() const;
    /// Purpose for this document.
    std::string Purpose() const;
    void setPurpose(std::string v);
    /// Whether the optional attribute IntendedUse is defined for this IfcDocumentInformation
    bool hasIntendedUse() const;
    /// Intended use for this document.
    std::string IntendedUse() const;
    void setIntendedUse(std::string v);
    /// Whether the optional attribute Scope is defined for this IfcDocumentInformation
    bool hasScope() const;
    /// Scope for this document.
    std::string Scope() const;
    void setScope(std::string v);
    /// Whether the optional attribute Revision is defined for this IfcDocumentInformation
    bool hasRevision() const;
    /// Document revision designation.
    std::string Revision() const;
    void setRevision(std::string v);
    /// Whether the optional attribute DocumentOwner is defined for this IfcDocumentInformation
    bool hasDocumentOwner() const;
    /// Information about the person and/or organization acknowledged as the 'owner' of this document. In some contexts, the document owner determines who has access to or editing right to the document.
    ::Ifc2x3::IfcActorSelect* DocumentOwner() const;
    void setDocumentOwner(::Ifc2x3::IfcActorSelect* v);
    /// Whether the optional attribute Editors is defined for this IfcDocumentInformation
    bool hasEditors() const;
    /// The persons and/or organizations who have created this document or contributed to it.
    IfcEntityList::ptr Editors() const;
    void setEditors(IfcEntityList::ptr v);
    /// Whether the optional attribute CreationTime is defined for this IfcDocumentInformation
    bool hasCreationTime() const;
    /// Date and time stamp when the document was originally created.
    /// 
    /// IFC2x4 CHANGE The data type has been changed to IfcDateTime, the date time string according to ISO8601.
    ::Ifc2x3::IfcDateAndTime* CreationTime() const;
    void setCreationTime(::Ifc2x3::IfcDateAndTime* v);
    /// Whether the optional attribute LastRevisionTime is defined for this IfcDocumentInformation
    bool hasLastRevisionTime() const;
    /// Date and time stamp when this document version was created.
    /// 
    /// IFC2x4 CHANGE The data type has been changed to IfcDateTime, the date time string according to ISO8601.
    ::Ifc2x3::IfcDateAndTime* LastRevisionTime() const;
    void setLastRevisionTime(::Ifc2x3::IfcDateAndTime* v);
    /// Whether the optional attribute ElectronicFormat is defined for this IfcDocumentInformation
    bool hasElectronicFormat() const;
    /// Describes the electronic format of the document being referenced, providing the file extension and the manner in which the content is provided.
    ::Ifc2x3::IfcDocumentElectronicFormat* ElectronicFormat() const;
    void setElectronicFormat(::Ifc2x3::IfcDocumentElectronicFormat* v);
    /// Whether the optional attribute ValidFrom is defined for this IfcDocumentInformation
    bool hasValidFrom() const;
    /// Date when the document becomes valid.
    /// 
    /// IFC2x4 CHANGE The data type has been changed to IfcDate, the date string according to ISO8601.
    ::Ifc2x3::IfcCalendarDate* ValidFrom() const;
    void setValidFrom(::Ifc2x3::IfcCalendarDate* v);
    /// Whether the optional attribute ValidUntil is defined for this IfcDocumentInformation
    bool hasValidUntil() const;
    /// Date until which the document remains valid.
    /// 
    /// IFC2x4 CHANGE The data type has been changed to IfcDate, the date string according to ISO8601.
    ::Ifc2x3::IfcCalendarDate* ValidUntil() const;
    void setValidUntil(::Ifc2x3::IfcCalendarDate* v);
    /// Whether the optional attribute Confidentiality is defined for this IfcDocumentInformation
    bool hasConfidentiality() const;
    /// The level of confidentiality of the document.
    ::Ifc2x3::IfcDocumentConfidentialityEnum::Value Confidentiality() const;
    void setConfidentiality(::Ifc2x3::IfcDocumentConfidentialityEnum::Value v);
    /// Whether the optional attribute Status is defined for this IfcDocumentInformation
    bool hasStatus() const;
    /// The current status of the document. Examples of status values that might be used for a document information status include:
    /// - DRAFT
    /// - FINAL DRAFT
    /// - FINAL
    /// - REVISION
    ::Ifc2x3::IfcDocumentStatusEnum::Value Status() const;
    void setStatus(::Ifc2x3::IfcDocumentStatusEnum::Value v);
        IfcTemplatedEntityList< IfcDocumentInformationRelationship >::ptr IsPointedTo() const; // INVERSE IfcDocumentInformationRelationship::RelatedDocuments
    IfcTemplatedEntityList< IfcDocumentInformationRelationship >::ptr IsPointer() const; // INVERSE IfcDocumentInformationRelationship::RelatingDocument
    virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcDocumentInformation (IfcEntityInstanceData* e);
    IfcDocumentInformation (std::string v1_DocumentId, std::string v2_Name, boost::optional< std::string > v3_Description, boost::optional< IfcTemplatedEntityList< ::Ifc2x3::IfcDocumentReference >::ptr > v4_DocumentReferences, boost::optional< std::string > v5_Purpose, boost::optional< std::string > v6_IntendedUse, boost::optional< std::string > v7_Scope, boost::optional< std::string > v8_Revision, ::Ifc2x3::IfcActorSelect* v9_DocumentOwner, boost::optional< IfcEntityList::ptr > v10_Editors, ::Ifc2x3::IfcDateAndTime* v11_CreationTime, ::Ifc2x3::IfcDateAndTime* v12_LastRevisionTime, ::Ifc2x3::IfcDocumentElectronicFormat* v13_ElectronicFormat, ::Ifc2x3::IfcCalendarDate* v14_ValidFrom, ::Ifc2x3::IfcCalendarDate* v15_ValidUntil, boost::optional< ::Ifc2x3::IfcDocumentConfidentialityEnum::Value > v16_Confidentiality, boost::optional< ::Ifc2x3::IfcDocumentStatusEnum::Value > v17_Status);
    typedef IfcTemplatedEntityList< IfcDocumentInformation > list;
};
/// An IfcDocumentInformationRelationship is a relationship class that enables a document to have the ability to reference other documents.
/// 
/// HISTORY  New entity in Release IFC2x.
/// 
/// IFC2x4 CHANGE  Subtyped from IfcResourceLevelRelationship, order of attributes changed.
/// 
/// Use definitions
/// This class can be used to describe relationships in which one document may reference one or more other sub documents or where a document is used as a replacement for another document (but where both the original and the replacing document need to be retained).
class IFC_PARSE_API IfcDocumentInformationRelationship : public IfcUtil::IfcBaseEntity {
public:
    /// The document that acts as the parent, referencing or original document in a relationship.
    ::Ifc2x3::IfcDocumentInformation* RelatingDocument() const;
    void setRelatingDocument(::Ifc2x3::IfcDocumentInformation* v);
    /// The document that acts as the child, referenced or replacing document in a relationship.
    IfcTemplatedEntityList< ::Ifc2x3::IfcDocumentInformation >::ptr RelatedDocuments() const;
    void setRelatedDocuments(IfcTemplatedEntityList< ::Ifc2x3::IfcDocumentInformation >::ptr v);
    /// Whether the optional attribute RelationshipType is defined for this IfcDocumentInformationRelationship
    bool hasRelationshipType() const;
    /// Describes the type of relationship between documents. This could be sub-document, replacement etc. The interpretation has to be established in an application context.
    std::string RelationshipType() const;
    void setRelationshipType(std::string v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcDocumentInformationRelationship (IfcEntityInstanceData* e);
    IfcDocumentInformationRelationship (::Ifc2x3::IfcDocumentInformation* v1_RelatingDocument, IfcTemplatedEntityList< ::Ifc2x3::IfcDocumentInformation >::ptr v2_RelatedDocuments, boost::optional< std::string > v3_RelationshipType);
    typedef IfcTemplatedEntityList< IfcDocumentInformationRelationship > list;
};

class IFC_PARSE_API IfcDraughtingCalloutRelationship : public IfcUtil::IfcBaseEntity {
public:
    /// Whether the optional attribute Name is defined for this IfcDraughtingCalloutRelationship
    bool hasName() const;
    std::string Name() const;
    void setName(std::string v);
    /// Whether the optional attribute Description is defined for this IfcDraughtingCalloutRelationship
    bool hasDescription() const;
    std::string Description() const;
    void setDescription(std::string v);
    ::Ifc2x3::IfcDraughtingCallout* RelatingDraughtingCallout() const;
    void setRelatingDraughtingCallout(::Ifc2x3::IfcDraughtingCallout* v);
    ::Ifc2x3::IfcDraughtingCallout* RelatedDraughtingCallout() const;
    void setRelatedDraughtingCallout(::Ifc2x3::IfcDraughtingCallout* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcDraughtingCalloutRelationship (IfcEntityInstanceData* e);
    IfcDraughtingCalloutRelationship (boost::optional< std::string > v1_Name, boost::optional< std::string > v2_Description, ::Ifc2x3::IfcDraughtingCallout* v3_RelatingDraughtingCallout, ::Ifc2x3::IfcDraughtingCallout* v4_RelatedDraughtingCallout);
    typedef IfcTemplatedEntityList< IfcDraughtingCalloutRelationship > list;
};

class IFC_PARSE_API IfcEnvironmentalImpactValue : public IfcAppliedValue {
public:
    std::string ImpactType() const;
    void setImpactType(std::string v);
    ::Ifc2x3::IfcEnvironmentalImpactCategoryEnum::Value Category() const;
    void setCategory(::Ifc2x3::IfcEnvironmentalImpactCategoryEnum::Value v);
    /// Whether the optional attribute UserDefinedCategory is defined for this IfcEnvironmentalImpactValue
    bool hasUserDefinedCategory() const;
    std::string UserDefinedCategory() const;
    void setUserDefinedCategory(std::string v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcEnvironmentalImpactValue (IfcEntityInstanceData* e);
    IfcEnvironmentalImpactValue (boost::optional< std::string > v1_Name, boost::optional< std::string > v2_Description, ::Ifc2x3::IfcAppliedValueSelect* v3_AppliedValue, ::Ifc2x3::IfcMeasureWithUnit* v4_UnitBasis, ::Ifc2x3::IfcDateTimeSelect* v5_ApplicableDate, ::Ifc2x3::IfcDateTimeSelect* v6_FixedUntilDate, std::string v7_ImpactType, ::Ifc2x3::IfcEnvironmentalImpactCategoryEnum::Value v8_Category, boost::optional< std::string > v9_UserDefinedCategory);
    typedef IfcTemplatedEntityList< IfcEnvironmentalImpactValue > list;
};
/// An IfcExternalReference is the identification of information that is not explicitly represented in the current model or in the project database (as an implementation of the current model). Such information may be contained in classifications, documents or libraries. The IfcExternalReference identifies a particular item, such as a
/// dictionary entry, a classification notation, or a document reference within the external source.
/// 
/// Only the Location (as a URL) is given to describe the place where the information can be found. Also an optional
/// Identification as a key to allow more specific references (as to sections or tables) is provided. The Identification defines a system interpretable method to identify the relevant part of information at the source. In addition a human interpretable Name can be assigned to identify the information subject, such as a classification code.
/// 
/// IfcExternalReference is an abstract supertype of all external reference entities.
/// 
/// HISTORY New entity in IFC2x.
class IFC_PARSE_API IfcExternalReference : public IfcUtil::IfcBaseEntity {
public:
    /// Whether the optional attribute Location is defined for this IfcExternalReference
    bool hasLocation() const;
    /// Location, where the external source (classification, document or library) can be accessed by electronic means. The electronic location is provided as an URI, and would normally be given as an URL location string.
    /// 
    /// IFC2x4 CHANGE  The data type has been changed from IfcLabel to IfcURIReference.
    std::string Location() const;
    void setLocation(std::string v);
    /// Whether the optional attribute ItemReference is defined for this IfcExternalReference
    bool hasItemReference() const;
    std::string ItemReference() const;
    void setItemReference(std::string v);
    /// Whether the optional attribute Name is defined for this IfcExternalReference
    bool hasName() const;
    /// Optional name to further specify the reference. It can provide a human readable identifier (which does not necessarily need to have a counterpart in the internal structure of the document).
    std::string Name() const;
    void setName(std::string v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcExternalReference (IfcEntityInstanceData* e);
    IfcExternalReference (boost::optional< std::string > v1_Location, boost::optional< std::string > v2_ItemReference, boost::optional< std::string > v3_Name);
    typedef IfcTemplatedEntityList< IfcExternalReference > list;
};
/// Definition from ISO/CD 10303-46:1992: The externally defined hatch style is an entity which makes an external reference to a hatching style.
/// 
/// NOTE: The allowable values for the name source and item reference, by which the externally defined hatch style is identified, need to be determined by implementer agreements.
/// 
/// NOTE: Corresponding ISO 10303 name: fill_style_select. Please refer to ISO/IS 10303-46:1994 for
/// the final definition of the formal standard.
/// 
/// HISTORY: New entity in IFC2x2.
class IFC_PARSE_API IfcExternallyDefinedHatchStyle : public IfcExternalReference {
public:
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcExternallyDefinedHatchStyle (IfcEntityInstanceData* e);
    IfcExternallyDefinedHatchStyle (boost::optional< std::string > v1_Location, boost::optional< std::string > v2_ItemReference, boost::optional< std::string > v3_Name);
    typedef IfcTemplatedEntityList< IfcExternallyDefinedHatchStyle > list;
};
/// IfcExternallyDefinedSurfaceStyle is a definition of a surface style through referencing an external source, such as a material library for rendering information.
/// 
/// NOTE  In order to achieve expected results, the externally defined surface style should normally only be given in addition to an explicitly defined surface styles.
/// 
/// HISTORY  New entity in IFC2x2.
/// 
/// IFC2x3 CHANGE  The spelling has been corrected from IfcExternallyDefinedSufaceStyle with no upward compatibility.
class IFC_PARSE_API IfcExternallyDefinedSurfaceStyle : public IfcExternalReference {
public:
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcExternallyDefinedSurfaceStyle (IfcEntityInstanceData* e);
    IfcExternallyDefinedSurfaceStyle (boost::optional< std::string > v1_Location, boost::optional< std::string > v2_ItemReference, boost::optional< std::string > v3_Name);
    typedef IfcTemplatedEntityList< IfcExternallyDefinedSurfaceStyle > list;
};
/// An externally defined symbol is a symbol that gets its shape information by an agreed reference to an external source.
/// 
/// NOTE: The allowable symbol names and sources have to be established by implementers agreements.
/// 
/// NOTE: The IfcExternallyDefinedSymbol is an entity that had been adopted from ISO 10303, Industrial automation systems and integration&#151;Product data representation and exchange, Part 46: Integrated generic resources: Visual presentation.
/// 
/// NOTE Corresponding ISO 10303 name: externally_defined_symbol. Please refer to ISO/IS 10303-46:1994 for the final definition of the formal standard.
/// 
/// HISTORY New entity in IFC2x2.
class IFC_PARSE_API IfcExternallyDefinedSymbol : public IfcExternalReference {
public:
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcExternallyDefinedSymbol (IfcEntityInstanceData* e);
    IfcExternallyDefinedSymbol (boost::optional< std::string > v1_Location, boost::optional< std::string > v2_ItemReference, boost::optional< std::string > v3_Name);
    typedef IfcTemplatedEntityList< IfcExternallyDefinedSymbol > list;
};
/// Definition from ISO/CD 10303-46:1992: The externally defined text font is an external reference to a text font 
/// 
/// NOTE  Restrictions of the font source and font names to be used may be exposed by implementation guidelines.
/// 
/// NOTE  Corresponding ISO 10303 name: externally_defined_text_font. Please refer to ISO/IS 10303-46:1994, p. 137 for the final definition of the formal standard.
/// 
/// HISTORY  New entity in IFC2x2.
class IFC_PARSE_API IfcExternallyDefinedTextFont : public IfcExternalReference {
public:
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcExternallyDefinedTextFont (IfcEntityInstanceData* e);
    IfcExternallyDefinedTextFont (boost::optional< std::string > v1_Location, boost::optional< std::string > v2_ItemReference, boost::optional< std::string > v3_Name);
    typedef IfcTemplatedEntityList< IfcExternallyDefinedTextFont > list;
};
/// An individual axis, IfcGridAxis, is defined in the context of a design grid.  The axis definition is based on a curve of dimensionality 2. The grid axis is positioned within the XY plane of the position coordinate system defined by the IfcDesignGrid.
/// 
/// HISTORY  New entity in IFC Release 1.0
/// 
/// Geometry use definitions
/// The standard geometric representation of IfcGridAxis is
/// defined using a 2D curve entity. Grid axes are normally defined
/// by an offset to another axis. The IfcOffsetCurve2D
/// supports this concept.
/// Each grid axis has a sense given by the parameterization of
/// the curve. The attribute SameSense is an indicator of
/// whether or not the sense of the grid axis agrees with, or
/// opposes, that of the underlying curve.
/// As shown in Figure 242, the grid axis is defined as a 2D curve within
/// the xy plane of the position coordinate system. Any curve can be
/// used to define a grid axis, most common is the use of IfcLine for
/// linear grids and IfcCircle for radial grids.
/// Most grids are defined by a pair of axis
/// lists, each defined by a base grid axis and axes given by an
/// offset to the base axis. The use of IfcOffsetCurve2D as
/// underlying AxisCurve supports this concept.
/// 
/// Figure 242 — Grid axis
class IFC_PARSE_API IfcGridAxis : public IfcUtil::IfcBaseEntity {
public:
    /// Whether the optional attribute AxisTag is defined for this IfcGridAxis
    bool hasAxisTag() const;
    /// The tag or name for this grid axis.
    std::string AxisTag() const;
    void setAxisTag(std::string v);
    /// Underlying curve which provides the geometry for this grid axis.
    ::Ifc2x3::IfcCurve* AxisCurve() const;
    void setAxisCurve(::Ifc2x3::IfcCurve* v);
    /// Defines whether the original sense of curve is used or whether it is reversed in the context of the grid axis.
    bool SameSense() const;
    void setSameSense(bool v);
        IfcTemplatedEntityList< IfcGrid >::ptr PartOfW() const; // INVERSE IfcGrid::WAxes
    IfcTemplatedEntityList< IfcGrid >::ptr PartOfV() const; // INVERSE IfcGrid::VAxes
    IfcTemplatedEntityList< IfcGrid >::ptr PartOfU() const; // INVERSE IfcGrid::UAxes
    IfcTemplatedEntityList< IfcVirtualGridIntersection >::ptr HasIntersections() const; // INVERSE IfcVirtualGridIntersection::IntersectingAxes
    virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcGridAxis (IfcEntityInstanceData* e);
    IfcGridAxis (boost::optional< std::string > v1_AxisTag, ::Ifc2x3::IfcCurve* v2_AxisCurve, bool v3_SameSense);
    typedef IfcTemplatedEntityList< IfcGridAxis > list;
};
/// The IfcIrregularTimeSeriesValue describes a value (or set of values) at a particular time point. 
/// 
/// HISTORY: New entity in IFC 2x2.
class IFC_PARSE_API IfcIrregularTimeSeriesValue : public IfcUtil::IfcBaseEntity {
public:
    /// The specification of the time point.
    ::Ifc2x3::IfcDateTimeSelect* TimeStamp() const;
    void setTimeStamp(::Ifc2x3::IfcDateTimeSelect* v);
    /// A list of time-series values. At least one value is required.
    IfcEntityList::ptr ListValues() const;
    void setListValues(IfcEntityList::ptr v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcIrregularTimeSeriesValue (IfcEntityInstanceData* e);
    IfcIrregularTimeSeriesValue (::Ifc2x3::IfcDateTimeSelect* v1_TimeStamp, IfcEntityList::ptr v2_ListValues);
    typedef IfcTemplatedEntityList< IfcIrregularTimeSeriesValue > list;
};
/// An IfcLibraryInformation describes a library where a library is a structured store of information, normally organized in a manner which allows information lookup through an index or reference value. IfcLibraryInformation provides the library Name and optional Version, VersionDate and Publisher attributes. A Location may be added for electronic access to the library.
/// 
/// NOTE  The complete definition of the information in an external library is out of scope in this IFC release.
/// 
/// HISTORY  New
/// Entity in IFC2x.
/// 
/// IFC2x4 CHANGE  Location attribute added, HasLibraryReferences inverse attribute added (previous LibraryReference changed to inverse).
class IFC_PARSE_API IfcLibraryInformation : public IfcUtil::IfcBaseEntity {
public:
    /// The name which is used to identify the library.
    std::string Name() const;
    void setName(std::string v);
    /// Whether the optional attribute Version is defined for this IfcLibraryInformation
    bool hasVersion() const;
    /// Identifier for the library version used for reference.
    std::string Version() const;
    void setVersion(std::string v);
    /// Whether the optional attribute Publisher is defined for this IfcLibraryInformation
    bool hasPublisher() const;
    /// Information of the organization that acts as the library publisher.
    ::Ifc2x3::IfcOrganization* Publisher() const;
    void setPublisher(::Ifc2x3::IfcOrganization* v);
    /// Whether the optional attribute VersionDate is defined for this IfcLibraryInformation
    bool hasVersionDate() const;
    /// Date of the referenced version of the library.
    /// 
    /// IFC2x4 CHANGE  The data type has been changed to IfcDate, the date string according to ISO8601.
    ::Ifc2x3::IfcCalendarDate* VersionDate() const;
    void setVersionDate(::Ifc2x3::IfcCalendarDate* v);
    /// Whether the optional attribute LibraryReference is defined for this IfcLibraryInformation
    bool hasLibraryReference() const;
    IfcTemplatedEntityList< ::Ifc2x3::IfcLibraryReference >::ptr LibraryReference() const;
    void setLibraryReference(IfcTemplatedEntityList< ::Ifc2x3::IfcLibraryReference >::ptr v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcLibraryInformation (IfcEntityInstanceData* e);
    IfcLibraryInformation (std::string v1_Name, boost::optional< std::string > v2_Version, ::Ifc2x3::IfcOrganization* v3_Publisher, ::Ifc2x3::IfcCalendarDate* v4_VersionDate, boost::optional< IfcTemplatedEntityList< ::Ifc2x3::IfcLibraryReference >::ptr > v5_LibraryReference);
    typedef IfcTemplatedEntityList< IfcLibraryInformation > list;
};
/// An IfcLibraryReference is a reference into a library of information by Location (provided as a URI). It also provides an optional inherited Identification key to allow more specific references to library sections or tables. The inherited Name attribute allows for a human interpretable identification of the library item. Also, general information on the library from which the reference is taken, is given by the ReferencedLibrary relation which identifies the relevant occurrence of IfcLibraryInformation.
/// 
/// The ifcLibraryReference additionally provides the capability to handle multilingual library entries. The Language attribute then holds the language tag for the language used by the strings kept in the Name and the Description attribute.
/// 
/// HISTORY  New Entity in IFC2.0.
/// 
/// IFC2x4 CHANGE  Description and Language attribute added; ReferencedLibrary attribute added (reversing previous ReferenceIntoLibrary inverse relationship).
class IFC_PARSE_API IfcLibraryReference : public IfcExternalReference {
public:
        IfcTemplatedEntityList< IfcLibraryInformation >::ptr ReferenceIntoLibrary() const; // INVERSE IfcLibraryInformation::LibraryReference
    virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcLibraryReference (IfcEntityInstanceData* e);
    IfcLibraryReference (boost::optional< std::string > v1_Location, boost::optional< std::string > v2_ItemReference, boost::optional< std::string > v3_Name);
    typedef IfcTemplatedEntityList< IfcLibraryReference > list;
};
/// IfcLightDistributionData defines the luminous intensity of a light source given at a particular main plane angle. It is based on some standardized light distribution curves; the MainPlaneAngle is either the 
/// 
/// A angle; if the IfcLightDistributionCurveEnum is set to TYPE_A 
/// B angle; if the IfcLightDistributionCurveEnum is set to TYPE_B 
/// C angle; if the IfcLightDistributionCurveEnum is set to TYPE_C 
/// 
/// For each MainPlaneAngle (considered as being the row of a table) a list of SecondaryPlaneAngle's are given (considered to be the columns of a table). They are either the: 
/// 
/// &#945; angle; if the IfcLightDistributionCurveEnum is set to TYPE_A 
/// &#946; angle; if the IfcLightDistributionCurveEnum is set to TYPE_B 
/// &#947; angle; if the IfcLightDistributionCurveEnum is set to TYPE_C 
/// 
/// For each pair of MainPlaneAngle and SecondaryPlaneAngle the LuminousIntensity is provided (the unit is given by the IfcUnitAssignment referring to the LuminousIntensityDistributionUnit, normally cd/klm). 
/// 
/// HISTORY: New entity in IFC2x2.
class IFC_PARSE_API IfcLightDistributionData : public IfcUtil::IfcBaseEntity {
public:
    /// The main plane angle (A, B or C angles, according to the light distribution curve chosen).
    double MainPlaneAngle() const;
    void setMainPlaneAngle(double v);
    /// The list of secondary plane angles (the &#945;, &#946; or &#947; angles) according to the light distribution curve chosen.
    /// 
    /// NOTE: The SecondaryPlaneAngle and LuminousIntensity lists are corresponding lists.
    std::vector< double > /*[1:?]*/ SecondaryPlaneAngle() const;
    void setSecondaryPlaneAngle(std::vector< double > /*[1:?]*/ v);
    /// The luminous intensity distribution measure for this pair of main and secondary plane angles according to the light distribution curve chosen.
    std::vector< double > /*[1:?]*/ LuminousIntensity() const;
    void setLuminousIntensity(std::vector< double > /*[1:?]*/ v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcLightDistributionData (IfcEntityInstanceData* e);
    IfcLightDistributionData (double v1_MainPlaneAngle, std::vector< double > /*[1:?]*/ v2_SecondaryPlaneAngle, std::vector< double > /*[1:?]*/ v3_LuminousIntensity);
    typedef IfcTemplatedEntityList< IfcLightDistributionData > list;
};
/// IfcLightIntensityDistribution defines the the luminous intensity of a light source that changes according to the direction of the ray. It is based on some standardized light distribution curves, which are defined by the LightDistributionCurve attribute. 
/// 
/// New entity in IFC2x2.
class IFC_PARSE_API IfcLightIntensityDistribution : public IfcUtil::IfcBaseEntity {
public:
    /// Standardized  light distribution curve used to define the luminous intensity of the light in all directions.
    ::Ifc2x3::IfcLightDistributionCurveEnum::Value LightDistributionCurve() const;
    void setLightDistributionCurve(::Ifc2x3::IfcLightDistributionCurveEnum::Value v);
    /// Light distribution data applied to the light source. It is defined by a list of main plane angles (B or C according to the light distribution curve chosen) that includes (for each B or C angle) a second list of secondary plane angles (the &#946; or &#947; angles) and the according luminous intensity distribution measures.
    IfcTemplatedEntityList< ::Ifc2x3::IfcLightDistributionData >::ptr DistributionData() const;
    void setDistributionData(IfcTemplatedEntityList< ::Ifc2x3::IfcLightDistributionData >::ptr v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcLightIntensityDistribution (IfcEntityInstanceData* e);
    IfcLightIntensityDistribution (::Ifc2x3::IfcLightDistributionCurveEnum::Value v1_LightDistributionCurve, IfcTemplatedEntityList< ::Ifc2x3::IfcLightDistributionData >::ptr v2_DistributionData);
    typedef IfcTemplatedEntityList< IfcLightIntensityDistribution > list;
};

class IFC_PARSE_API IfcLocalTime : public IfcUtil::IfcBaseEntity {
public:
    int HourComponent() const;
    void setHourComponent(int v);
    /// Whether the optional attribute MinuteComponent is defined for this IfcLocalTime
    bool hasMinuteComponent() const;
    int MinuteComponent() const;
    void setMinuteComponent(int v);
    /// Whether the optional attribute SecondComponent is defined for this IfcLocalTime
    bool hasSecondComponent() const;
    double SecondComponent() const;
    void setSecondComponent(double v);
    /// Whether the optional attribute Zone is defined for this IfcLocalTime
    bool hasZone() const;
    ::Ifc2x3::IfcCoordinatedUniversalTimeOffset* Zone() const;
    void setZone(::Ifc2x3::IfcCoordinatedUniversalTimeOffset* v);
    /// Whether the optional attribute DaylightSavingOffset is defined for this IfcLocalTime
    bool hasDaylightSavingOffset() const;
    int DaylightSavingOffset() const;
    void setDaylightSavingOffset(int v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcLocalTime (IfcEntityInstanceData* e);
    IfcLocalTime (int v1_HourComponent, boost::optional< int > v2_MinuteComponent, boost::optional< double > v3_SecondComponent, ::Ifc2x3::IfcCoordinatedUniversalTimeOffset* v4_Zone, boost::optional< int > v5_DaylightSavingOffset);
    typedef IfcTemplatedEntityList< IfcLocalTime > list;
};
/// IfcMaterial is a homogeneous or inhomogeneous
/// substance that can be used to form elements (physical products or
/// their components).
/// IfcMaterial is the basic entity for material
/// designation and definition; this includes identification by name
/// and classification (via reference to an external classification),
/// as well as association of material properties (isotropic or
/// anisotropic) defined by (subtypes of)
/// IfcMaterialProperties. An instance of IfcMaterial
/// may be associated to an element or element type using the
/// IfcRelAssociatesMaterial relationship. The assignment
/// might either be direct as a single material information, or
/// via
/// 
/// a material layer set
/// a material profile set
/// a material constituent set
/// 
/// An IfcMaterial may also have presentation information
/// associated. Such presentation information is provided by
/// IfcMaterialDefinitionRepresentation, associating line
/// styles, hatching definitions or surface coloring/rendering
/// information to a material.
/// 
/// HISTORYÿNew entity in IFC2x4
/// 
/// IFC2x4 CHANGEÿ The attributes Description and Category have been added.
class IFC_PARSE_API IfcMaterial : public IfcUtil::IfcBaseEntity {
public:
    /// Name of the material. 
    /// 
    /// EXAMPLE A view definition may require Material.Name to uniquely specify e.g. concrete or steel grade, in which case the attribute Material.Category could take the value 'Concrete' or 'Steel'. 
    /// 
    /// NOTE Material grade may have diffenrent meaning in different view definitions, e.g. strength grade for structural design and analysis, or visible appearance grade in architectural application. Also, more elaborate material grade definition may be associated as classification via inverse attribute HasExternalReferences.
    std::string Name() const;
    void setName(std::string v);
        IfcTemplatedEntityList< IfcMaterialDefinitionRepresentation >::ptr HasRepresentation() const; // INVERSE IfcMaterialDefinitionRepresentation::RepresentedMaterial
    IfcTemplatedEntityList< IfcMaterialClassificationRelationship >::ptr ClassifiedAs() const; // INVERSE IfcMaterialClassificationRelationship::ClassifiedMaterial
    virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcMaterial (IfcEntityInstanceData* e);
    IfcMaterial (std::string v1_Name);
    typedef IfcTemplatedEntityList< IfcMaterial > list;
};
/// IfcMaterialClassificationRelationship is a relationship assigning classifications to materials.
/// 
/// HISTORYÿ New entity in IFC2x.
/// 
/// IFC2x4 CHANGEÿ The entity IfcMaterialClassificationRelationship is deprecated since IFC2x4 and shall no longer be used. Use IfcExternalReferenceRelationship instead.
class IFC_PARSE_API IfcMaterialClassificationRelationship : public IfcUtil::IfcBaseEntity {
public:
    /// The material classifications identifying the type of material.
    IfcEntityList::ptr MaterialClassifications() const;
    void setMaterialClassifications(IfcEntityList::ptr v);
    /// Material being classified.
    ::Ifc2x3::IfcMaterial* ClassifiedMaterial() const;
    void setClassifiedMaterial(::Ifc2x3::IfcMaterial* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcMaterialClassificationRelationship (IfcEntityInstanceData* e);
    IfcMaterialClassificationRelationship (IfcEntityList::ptr v1_MaterialClassifications, ::Ifc2x3::IfcMaterial* v2_ClassifiedMaterial);
    typedef IfcTemplatedEntityList< IfcMaterialClassificationRelationship > list;
};
/// IfcMaterialLayer is a single and identifiable part of an element which is constructed of a number of layers (one or more). Each IfcMaterialLayer has a constant thickness and is located relative to the referencing IfcMaterialLayerSet along the MlsBase.
/// 
/// EXAMPLE  A cavity wall with brick masonry used with
/// an air gap in between would be modeled using three
/// IfcMaterialLayer's: [1] Brick, [2] Air gap, [3] Brick. The
/// inner layer "Brick" would have a Name = "Brick", an
/// individual LayerThickness, and potentially a
/// Category indicating it as "load bearing", and a
/// Priority that controls how this material layer interacts
/// with other material layers in wall connections.
/// 
/// The IfcMaterialLayer may have a material layer name,
/// that might be different to the IfcMaterial name
/// referenced.
/// 
/// EXAMPLE  The IfcMaterialLayer name of an
/// insulation layer can be "Insulation", whereas the
/// IfcMaterial name is "polystyrene insulating
/// boards".
/// 
/// HISTORY  New entity in IFC 1.5
/// 
/// IFC2x4 CHANGE  The attributes Name, Description, Category, Priority have been added at the end of attribute list. Data type of LayerThickness relaxed to IfcNonNegativeLengthMeasure.
class IFC_PARSE_API IfcMaterialLayer : public IfcUtil::IfcBaseEntity {
public:
    /// Whether the optional attribute Material is defined for this IfcMaterialLayer
    bool hasMaterial() const;
    /// Optional reference to the material from which the layer is constructed. Note that if this value is not given, it does not denote a layer with no material (an air gap), it only means that the material is not specified at that point.
    ::Ifc2x3::IfcMaterial* Material() const;
    void setMaterial(::Ifc2x3::IfcMaterial* v);
    /// The thickness of the material layer. The dimension is measured along the positive MlsDirection as specified in IfcMaterialLayerSet (that is mapped to AXIS-2, as specified in IfcMaterialLayerSetUsage for element occurrences supporting IfcMaterialLayerSetUsage.
    /// 
    /// NOTE  The attribute value can be 0. for material thicknesses very close to zero, such as for a membrane. Material layers with thickess 0. shall not be rendered in the geometric representation.
    /// 
    /// IFC2x4 CHANGE  The attribute datatype has been changed to IfcNonNegativeLengthMeasure allowing for 0. as thickness.
    double LayerThickness() const;
    void setLayerThickness(double v);
    /// Whether the optional attribute IsVentilated is defined for this IfcMaterialLayer
    bool hasIsVentilated() const;
    /// Indication of whether the material layer represents an air layer (or cavity). 
    /// 
    /// set to TRUE if the material layer is an air gap and provides air exchange from the layer to the outside air.
    ///   set to UNKNOWN if the material layer is an air gap and does not provide air exchange (or when this information about air exchange of the air gap is not available).
    ///   set to FALSE if the material layer is a solid material layer (the default).
    bool IsVentilated() const;
    void setIsVentilated(bool v);
        IfcTemplatedEntityList< IfcMaterialLayerSet >::ptr ToMaterialLayerSet() const; // INVERSE IfcMaterialLayerSet::MaterialLayers
    virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcMaterialLayer (IfcEntityInstanceData* e);
    IfcMaterialLayer (::Ifc2x3::IfcMaterial* v1_Material, double v2_LayerThickness, boost::optional< bool > v3_IsVentilated);
    typedef IfcTemplatedEntityList< IfcMaterialLayer > list;
};
/// IfcMaterialLayerSet is a designation by which materials of an element constructed of a number of material layers is known and through which the relative positioning of individual layers can be expressed.
/// 
/// The Material Layer Set Base (MlsBase) describes the axis along
/// which the material layers are positioned. The MlsBase is positioned
/// along the reference axis or reference plane of the element
/// supporting the IfcMaterialLayerSetUsage concept with a
/// potential offset (see here). The positive Material Layer Set
/// Direction (MlsDirection) describes the direction by which the
/// individual material layers, with their material layer thicknesses
/// are stacked. IfcMaterialLayer's are stacked with no gap,
/// gaps within a material layer set are expresses as layers by
/// themselves.
/// 
/// EXAMPLE A cavity brick wall would be modeled as
/// IfcMaterialLayerSet consisting of three
/// IfcMaterialLayer's: brick, air cavity and brick. The air
/// gap is identified, using the IsVentilated flag at
/// IfcMaterialLayer.
/// 
/// HISTORY  New entity in IFC 1.0
/// 
/// IFC2x4 CHANGE  Subtyped from IfcMaterialDefinition, the attribute Description
/// has been added at the end of attribute list.
/// 
/// Attribute use definition
/// As shown in Figure 285, each IfcMaterialLayerSet implicitly defines a material
/// layer set base line (MlsBase), to which the start of the first
/// IfcMaterialLayer is aligned. The total thickness of a
/// layer set is calculated from the individual layer thicknesses, the
/// first layer starting from the MlsBase and following layers being
/// placed on top of the previous (no gaps or overlaps).
/// 
/// Figure 285 — Material layer set
class IFC_PARSE_API IfcMaterialLayerSet : public IfcUtil::IfcBaseEntity {
public:
    /// Identification of the layers from which the material layer set is composed.
    IfcTemplatedEntityList< ::Ifc2x3::IfcMaterialLayer >::ptr MaterialLayers() const;
    void setMaterialLayers(IfcTemplatedEntityList< ::Ifc2x3::IfcMaterialLayer >::ptr v);
    /// Whether the optional attribute LayerSetName is defined for this IfcMaterialLayerSet
    bool hasLayerSetName() const;
    /// The name by which the material layer set is known.
    std::string LayerSetName() const;
    void setLayerSetName(std::string v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcMaterialLayerSet (IfcEntityInstanceData* e);
    IfcMaterialLayerSet (IfcTemplatedEntityList< ::Ifc2x3::IfcMaterialLayer >::ptr v1_MaterialLayers, boost::optional< std::string > v2_LayerSetName);
    typedef IfcTemplatedEntityList< IfcMaterialLayerSet > list;
};
/// IfcMaterialLayerSetUsage determines the usage of
/// IfcMaterialLayerSet in terms of its location and
/// orientation relative to the associated element geometry. The
/// location of material layer set shall be compatible with the
/// building element geometry (that is, material layers shall fit inside
/// the element geometry). The rules to ensure the compatibility
/// depend on the type of the building element.
/// 
/// EXAMPLE ÿFor a cavity brick wall with shape
/// representation SweptSolid, the
/// IfcMaterialLayerSet.TotalThickness shall be equal to the
/// wall thickness. Also the OffsetFromReferenceLine shall
/// match the exact positions between the two shape representations
/// of IfcWallStandardCase, i.e. the
/// IfcShapeRepresentation's with
/// RepresentationIdentifier="Axis" and
/// RepresentationIdentifier="Body".
/// 
/// NOTE ÿRefer to the implementation guide and agreements for
/// more information on matching between building element geometry
/// and material layer set usage.
/// 
/// The IfcMaterialLayerSetUsage is always assigned to an
/// individual occurrence object only (i.e. to relevant subtypes of
/// IfcElement). The IfcMaterialLayerSet, referenced by
/// ForLayerSet can however be shared among several occurrence
/// objects. If the element type is available (i.e. the relevant
/// subtype of IfcElementType, then the
/// IfcMaterialLayerSet can be assigned to the type object.
/// The assignment between aÿsubtype of IfcElement and the
/// IfcMaterialLayerSetUsage is handled by
/// IfcRelAssociatesMaterial.
/// 
/// Use definition
/// The IfcMaterialLayerSetUsage is primarily intended to
/// be associated with planar building elements having a constant
/// thickness. With further agreements on the interpretation of
/// LayerSetDirection, the usage can be extended also to other
/// cases, e.g. to curved building elements, provided that the
/// material layer thicknesses are constant.
/// Generally, an element may be layered in any of its primary
/// directions, denoted by its x, y or z axis. The geometry use
/// definitions at eachÿspecific types of building element will
/// determine the applicableÿLayerSetDirection.
/// 
/// The following examples illustrate how the IfcMaterialLayerSetUsage attributes (LayerSetDirection, DirectionSense, OffsetFromReferenceLine) can
/// be used in different cases. The normative material use definitions are documented at each element (how these shall be used).
/// 
/// Figure 286 shows an example of the use of IfcMaterialLayerSetUsage aligned to the axis of a wall.
/// 
/// EXAMPLE  For a standard wall with extruded
/// geometric representation (vertical extrusion), the layer set
/// direction will be perpendicular to extrusion direction,
/// andÿcan be derived from the direction of the wall
/// axis. With the DirectionSense(positive in
/// this example) the individual IfcMaterialLayers are
/// assigned consecutively right-to-left or left-to-right. For a
/// curved wall, "direction denoting the wall thickness" can be
/// derived from the direction of the wall axis, and it will remain
/// perpendicular to the wall path. The
/// DirectionSenseÿapplies as well.
/// 
/// NOTE  According to the IfcWallStandardCase material use
/// definition the LayerSetDirection for
/// IfcWallStandardCase is always AXIS2 (i.e. along the
/// y-axis), as shown in this example.
/// 
/// Figure 286 — Material layer set usage for wall
/// 
/// Figure 287 shows an example of the use of IfcMaterialLayerSetUsage aligned to a slab.
/// 
/// EXAMPLE ÿFor a slab with perpendicular
/// extruded geometric representation, the LayerSetDirection
/// will coincide with the extrusion direction (in positive or
/// negative sense). In this example, the material layer set base is
/// the extruded profile and consistent with the
/// IfcExtrudedAreaSolid.Position,ÿwith the
/// DirectionSensebeing positive, the
/// individual IfcMaterialLayers are built up from the base
/// towards positive z direction in this case.
/// 
/// NOTE ÿAccording to the IfcSlabStandardCase
/// material use definition the LayerSetDirection for
/// IfcSlabStandardCase is always AXIS3 (i.e. along the
/// z-axis).
/// 
/// Figure 287 — Material layer set usage for slab
/// 
/// Figure 288 shows an example of the use of IfcMaterialLayerSetUsage aligned to a roof slab with non-perpendicular extrusion.
/// 
/// EXAMPLE ÿFor a slab with non-perpendicular
/// extruded geometric representation, the guidelines above apply as
/// well. The material layer thickness and the
/// OffsetFromReferenceLine is always measured
/// perpendicularly, even if the extrusion direction is not
/// perpendicular. Therefore the total material layer thickness is
/// not equal to the extrusion depth of the
/// geometry.
/// 
/// Figure 288 — Material layer set usage for roof slab
class IFC_PARSE_API IfcMaterialLayerSetUsage : public IfcUtil::IfcBaseEntity {
public:
    /// The IfcMaterialLayerSet set to which the usage is applied.
    ::Ifc2x3::IfcMaterialLayerSet* ForLayerSet() const;
    void setForLayerSet(::Ifc2x3::IfcMaterialLayerSet* v);
    /// Orientation of the material layer set relative to element reference geometry. The meaning of the value of this attribute shall be specified in the geometry use section for each element. For extruded shape representation, direction can be given along the extrusion path (e.g. for slabs) or perpendicular to it (e.g. for walls).
    /// 
    /// NOTE  the LayerSetDirection for IfcWallStandardCase shall be AXIS2 (i.e. the y-axis) and for IfcSlabStandardCase and IfcPlateStandardCase it shall be AXIS3 (i.e. the z-axis).
    /// 
    /// Whether the material layers of the set being used shall 'grow' into the positive or negative direction of the given axis, shall be deifned by DirectionSense attribute.
    ::Ifc2x3::IfcLayerSetDirectionEnum::Value LayerSetDirection() const;
    void setLayerSetDirection(::Ifc2x3::IfcLayerSetDirectionEnum::Value v);
    /// Denotion whether the material layer set is oriented in positive or negative sense along the specified axis (defined by LayerSetDirection). "Positive" means that the consecutive layers (the IfcMaterialLayer instances in the list of  IfcMaterialLayerSet.MaterialLayers) are placed face-by-face in the direction of the positive axis as established by LayerSetDirection: for AXIS2 it would be in +y, for AXIS3 it would be +z. "Negative" means that the layers are placed face-by-face in the direction of the negative LayerSetDirection. In both cases,  starting at the material layer set base line.
    /// NOTE  the material layer set base line (MlsBase) is located by OffsetFromReferenceLine, and may be on the positive or negative side of the element reference line (or plane); positive or negative for MlsBase placement does not depend on the DirectionSense attribute, but on the relevant element axis.
    ::Ifc2x3::IfcDirectionSenseEnum::Value DirectionSense() const;
    void setDirectionSense(::Ifc2x3::IfcDirectionSenseEnum::Value v);
    /// Offset of the material layer set base line (MlsBase) from reference geometry (line or plane) of element. The offset can be positive or negative, unless restricted for a particular building element type in its use definition or by implementer agreement. A positive value means, that the MlsBase is placed on the positive side of the reference line or plane, on the axis established by LayerSetDirection (in case of AXIS2 into the direction of +y, or in case of AXIS2 into the direction of +z). A negative value means that the MlsBase is placed on the negative side, as established by LayerSetDirection (in case of AXIS2 into the direction of -y). NOTE  the positive or negative sign in the offset only affects the MlsBase placement, it does not have any effect on the application of DirectionSense for orientation of the material layers; also DirectionSense does not change the MlsBase placement.
    double OffsetFromReferenceLine() const;
    void setOffsetFromReferenceLine(double v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcMaterialLayerSetUsage (IfcEntityInstanceData* e);
    IfcMaterialLayerSetUsage (::Ifc2x3::IfcMaterialLayerSet* v1_ForLayerSet, ::Ifc2x3::IfcLayerSetDirectionEnum::Value v2_LayerSetDirection, ::Ifc2x3::IfcDirectionSenseEnum::Value v3_DirectionSense, double v4_OffsetFromReferenceLine);
    typedef IfcTemplatedEntityList< IfcMaterialLayerSetUsage > list;
};
/// IfcMaterialList is a list of the different materials
/// that are used in an element.
/// 
/// NOTE: The class IfcMaterialList will
/// normally be used where an element is described at a more abstract
/// level. For example, for an architectural specification writer,
/// the only information that may be needed about a concrete column
/// is that it contains concrete, reinforcing steel and mild steel
/// ligatures. It shall not be used for elements consisting of
/// material layers when the different layers can be defined and the
/// class IfcMaterialLayerSet can be used. Also,
/// IfcMaterialList shall not be used for elements consisting
/// of a single identifiable material (for example, to represent anisotropic
/// material).
/// 
/// IFC2x4 CHANGEÿ The entity IfcMaterialList is deprecated and shall no longer
/// be used. Use IfcMaterialConstituentSet instead.
class IFC_PARSE_API IfcMaterialList : public IfcUtil::IfcBaseEntity {
public:
    /// Materials used in a composition of substances.
    IfcTemplatedEntityList< ::Ifc2x3::IfcMaterial >::ptr Materials() const;
    void setMaterials(IfcTemplatedEntityList< ::Ifc2x3::IfcMaterial >::ptr v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcMaterialList (IfcEntityInstanceData* e);
    IfcMaterialList (IfcTemplatedEntityList< ::Ifc2x3::IfcMaterial >::ptr v1_Materials);
    typedef IfcTemplatedEntityList< IfcMaterialList > list;
};
/// IfcMaterialProperties is defined as an abstract
/// supertype for entities that apply material properties to material
/// definitions. A set of material properties that are assigned to an
/// individual material definiton may be identified by a Name
/// and a Description.
/// 
/// NOTE  The set of material properties can be assigned
/// to an individual IfcMaterial, a set or composite of
/// materials (IfcMaterialConstituent,
/// IfcMaterialConstituentSet), or set or individual material
/// layer (IfcMaterialLayer, IfcMaterialLayerSet), or
/// a set or individual material profile (IfcMaterialProfile,
/// IfcMaterialProfileSet)
/// 
/// The applicable set of material properties is defined at the
/// subtype IfcExtendedMaterialProperties. It includes
/// material properties defined in this IFC specification and those
/// defined as user-defined extended material properties.
/// 
/// HISTORY  New Entity in IFC 2x.
/// 
/// IFC2x4 CHANGE  The subtypes that represented a fixed list of statically defined material properties, IfcMechanicalMaterialProperties, IfcThermalMaterialProperties, IfcHygroscopicMaterialProperties, IfcGeneralMaterialProperties, IfcOpticalMaterialProperties, IfcWaterProperties, IfcFuelProperties, IfcProductsOfCombustionProperties have been deleted, use the generic IfcExtendedMaterialProperties instead.
class IFC_PARSE_API IfcMaterialProperties : public IfcUtil::IfcBaseEntity {
public:
    /// Reference to the material definition to which the set of properties is assigned.
    /// 
    /// IFC2x4 CHANGE  The datatype has been changed to supertype IfcMaterialDefinition.
    ::Ifc2x3::IfcMaterial* Material() const;
    void setMaterial(::Ifc2x3::IfcMaterial* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcMaterialProperties (IfcEntityInstanceData* e);
    IfcMaterialProperties (::Ifc2x3::IfcMaterial* v1_Material);
    typedef IfcTemplatedEntityList< IfcMaterialProperties > list;
};
/// Definition from ISO/CD 10303-41:1992: A measure with unit is the specification of a physical quantity  as defined in ISO 31 (clause 2).
/// 
/// IfcMeasureWithUnit has two usages:
/// 1. For representing measure value together with its unit on the entity type attribute level; thus
///   overriding the IFC model global unit assignments.
/// 2. For conversion based unit to give the conversion rate and its base.
/// 
/// NOTE Corresponding ISO 10303 name: measure_with_unit, please refer to ISO/IS 10303-41 for the final definition of the formal standard.
/// 
/// HISTORY New entity in IFC Release 1.5.1.
class IFC_PARSE_API IfcMeasureWithUnit : public IfcUtil::IfcBaseEntity {
public:
    /// The value of the physical quantity when expressed in the specified units.
    ::Ifc2x3::IfcValue* ValueComponent() const;
    void setValueComponent(::Ifc2x3::IfcValue* v);
    /// The unit in which the physical quantity is expressed.
    ::Ifc2x3::IfcUnit* UnitComponent() const;
    void setUnitComponent(::Ifc2x3::IfcUnit* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcMeasureWithUnit (IfcEntityInstanceData* e);
    IfcMeasureWithUnit (::Ifc2x3::IfcValue* v1_ValueComponent, ::Ifc2x3::IfcUnit* v2_UnitComponent);
    typedef IfcTemplatedEntityList< IfcMeasureWithUnit > list;
};

class IFC_PARSE_API IfcMechanicalMaterialProperties : public IfcMaterialProperties {
public:
    /// Whether the optional attribute DynamicViscosity is defined for this IfcMechanicalMaterialProperties
    bool hasDynamicViscosity() const;
    double DynamicViscosity() const;
    void setDynamicViscosity(double v);
    /// Whether the optional attribute YoungModulus is defined for this IfcMechanicalMaterialProperties
    bool hasYoungModulus() const;
    double YoungModulus() const;
    void setYoungModulus(double v);
    /// Whether the optional attribute ShearModulus is defined for this IfcMechanicalMaterialProperties
    bool hasShearModulus() const;
    double ShearModulus() const;
    void setShearModulus(double v);
    /// Whether the optional attribute PoissonRatio is defined for this IfcMechanicalMaterialProperties
    bool hasPoissonRatio() const;
    double PoissonRatio() const;
    void setPoissonRatio(double v);
    /// Whether the optional attribute ThermalExpansionCoefficient is defined for this IfcMechanicalMaterialProperties
    bool hasThermalExpansionCoefficient() const;
    double ThermalExpansionCoefficient() const;
    void setThermalExpansionCoefficient(double v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcMechanicalMaterialProperties (IfcEntityInstanceData* e);
    IfcMechanicalMaterialProperties (::Ifc2x3::IfcMaterial* v1_Material, boost::optional< double > v2_DynamicViscosity, boost::optional< double > v3_YoungModulus, boost::optional< double > v4_ShearModulus, boost::optional< double > v5_PoissonRatio, boost::optional< double > v6_ThermalExpansionCoefficient);
    typedef IfcTemplatedEntityList< IfcMechanicalMaterialProperties > list;
};

class IFC_PARSE_API IfcMechanicalSteelMaterialProperties : public IfcMechanicalMaterialProperties {
public:
    /// Whether the optional attribute YieldStress is defined for this IfcMechanicalSteelMaterialProperties
    bool hasYieldStress() const;
    double YieldStress() const;
    void setYieldStress(double v);
    /// Whether the optional attribute UltimateStress is defined for this IfcMechanicalSteelMaterialProperties
    bool hasUltimateStress() const;
    double UltimateStress() const;
    void setUltimateStress(double v);
    /// Whether the optional attribute UltimateStrain is defined for this IfcMechanicalSteelMaterialProperties
    bool hasUltimateStrain() const;
    double UltimateStrain() const;
    void setUltimateStrain(double v);
    /// Whether the optional attribute HardeningModule is defined for this IfcMechanicalSteelMaterialProperties
    bool hasHardeningModule() const;
    double HardeningModule() const;
    void setHardeningModule(double v);
    /// Whether the optional attribute ProportionalStress is defined for this IfcMechanicalSteelMaterialProperties
    bool hasProportionalStress() const;
    double ProportionalStress() const;
    void setProportionalStress(double v);
    /// Whether the optional attribute PlasticStrain is defined for this IfcMechanicalSteelMaterialProperties
    bool hasPlasticStrain() const;
    double PlasticStrain() const;
    void setPlasticStrain(double v);
    /// Whether the optional attribute Relaxations is defined for this IfcMechanicalSteelMaterialProperties
    bool hasRelaxations() const;
    IfcTemplatedEntityList< ::Ifc2x3::IfcRelaxation >::ptr Relaxations() const;
    void setRelaxations(IfcTemplatedEntityList< ::Ifc2x3::IfcRelaxation >::ptr v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcMechanicalSteelMaterialProperties (IfcEntityInstanceData* e);
    IfcMechanicalSteelMaterialProperties (::Ifc2x3::IfcMaterial* v1_Material, boost::optional< double > v2_DynamicViscosity, boost::optional< double > v3_YoungModulus, boost::optional< double > v4_ShearModulus, boost::optional< double > v5_PoissonRatio, boost::optional< double > v6_ThermalExpansionCoefficient, boost::optional< double > v7_YieldStress, boost::optional< double > v8_UltimateStress, boost::optional< double > v9_UltimateStrain, boost::optional< double > v10_HardeningModule, boost::optional< double > v11_ProportionalStress, boost::optional< double > v12_PlasticStrain, boost::optional< IfcTemplatedEntityList< ::Ifc2x3::IfcRelaxation >::ptr > v13_Relaxations);
    typedef IfcTemplatedEntityList< IfcMechanicalSteelMaterialProperties > list;
};
/// An IfcMetric is used to capture quantitative resultant metrics that can be applied to objectives. 
/// 
/// HISTORY: New Entity in IFC Release 2.0
/// 
/// Use Definition 
/// IfcMetric is a subtype of IfcConstraint and may be associated with any subtype of IfcRoot through the IfcRelAssociatesConstraint relationship in the IfcControlExtension schema, or may be associated with IfcProperty by IfcPropertyConstraintRelationship. 
/// 
/// The aim of IfcMetric is to capture the quantitative aspects of a constraint. 
/// 
/// For instance, when undertaking a move (instantiated through the IfcTask class), a constraint is instantiated as the class IfcMetric and may be named as a 'Move Start Constraint' or 'Move End Constraint' and described using one of a possible range of move constraints as shown in the table below. 
/// 
/// Constraint 
///   Description 
///   Benchmark 
///   Grade 
/// 
/// ASSOONASPOSSIBLE 
///   Action should commence at the earliest possible opportunity. 
///   GREATERTHANOREQUALTO 
///   SOFT 
/// 
/// MUSTSTARTON 
///   Action must start at a prescribed date/time. 
///   EQUALTO 
///   HARD 
/// 
/// MUSTSTARTBEFORE 
///   Action must start before a prescribed date/time. 
///   LESSTHANOREQUALTO 
///   HARD 
/// 
/// MUSTSTARTAFTER 
///   Action must not start before a prescribed date/time. 
///   GREATERTHANOREQUALTO 
///   HARD 
/// 
/// MAYSTARTAFTER 
///   Action may start at any time following a prescribed date/time. 
///   GREATERTHANOREQUALTO 
///   SOFT 
/// 
/// MUSTFINISHON 
///   Action must be complete at or by a prescribed date/time. 
///   EQUALTO 
///   HARD 
/// 
/// MUSTFINISHBEFORE 
///   Action must be complete before a prescribed date/time. 
///   LESSTHANOREQUALTO 
///   HARD 
/// 
/// This constraint (instantiated as IfcMetric) uses a Date/Time value in IfcMetric.DataValue through IfcMetricValueSelect. An appropriate benchmark is applied according to the requirement of the constraint (as indicated) by IfcMetric.Benchmark. The grade of the constraint (hard, soft, advisory) must be specified through		IfcConstraint.ConstraintGrade whilst the time at which the constraint is	created may be optionally asserted through IfcConstraint.CreationTime.
class IFC_PARSE_API IfcMetric : public IfcConstraint {
public:
    /// Enumeration that identifies the type of benchmark data.
    ::Ifc2x3::IfcBenchmarkEnum::Value Benchmark() const;
    void setBenchmark(::Ifc2x3::IfcBenchmarkEnum::Value v);
    /// Whether the optional attribute ValueSource is defined for this IfcMetric
    bool hasValueSource() const;
    /// Reference source for data values.
    std::string ValueSource() const;
    void setValueSource(std::string v);
    /// The value with data type defined by the underlying type accesses via IfcMetricValueSelect.
    ::Ifc2x3::IfcMetricValueSelect* DataValue() const;
    void setDataValue(::Ifc2x3::IfcMetricValueSelect* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcMetric (IfcEntityInstanceData* e);
    IfcMetric (std::string v1_Name, boost::optional< std::string > v2_Description, ::Ifc2x3::IfcConstraintEnum::Value v3_ConstraintGrade, boost::optional< std::string > v4_ConstraintSource, ::Ifc2x3::IfcActorSelect* v5_CreatingActor, ::Ifc2x3::IfcDateTimeSelect* v6_CreationTime, boost::optional< std::string > v7_UserDefinedGrade, ::Ifc2x3::IfcBenchmarkEnum::Value v8_Benchmark, boost::optional< std::string > v9_ValueSource, ::Ifc2x3::IfcMetricValueSelect* v10_DataValue);
    typedef IfcTemplatedEntityList< IfcMetric > list;
};
/// IfcMonetaryUnit is a unit to define currency for money.
/// 
/// HISTORY: New entity in IFC Release 2x.
/// 
/// IFC2x4 CHANGE: Type of the attribute Currency changed.
class IFC_PARSE_API IfcMonetaryUnit : public IfcUtil::IfcBaseEntity {
public:
    /// Code or name of the currency.  Permissible values are the three-letter alphabetic currency codes as per ISO 4217, for example CNY, EUR, GBP, JPY, USD.
    ::Ifc2x3::IfcCurrencyEnum::Value Currency() const;
    void setCurrency(::Ifc2x3::IfcCurrencyEnum::Value v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcMonetaryUnit (IfcEntityInstanceData* e);
    IfcMonetaryUnit (::Ifc2x3::IfcCurrencyEnum::Value v1_Currency);
    typedef IfcTemplatedEntityList< IfcMonetaryUnit > list;
};
/// Definition from ISO/CD 10303-41:1992: A named unit is a unit quantity associated with the word, or group of words, by which the unit is identified.
/// 
/// NOTE Corresponding ISO 10303 name: named_unit, please refer to ISO/IS 10303-41 for the final definition of the formal standard.
/// 
/// HISTORY New type in IFC Release 1.5.1.
class IFC_PARSE_API IfcNamedUnit : public IfcUtil::IfcBaseEntity {
public:
    /// The dimensional exponents of the SI base units by which the named unit is defined.
    ::Ifc2x3::IfcDimensionalExponents* Dimensions() const;
    void setDimensions(::Ifc2x3::IfcDimensionalExponents* v);
    /// The type of the unit.
    ::Ifc2x3::IfcUnitEnum::Value UnitType() const;
    void setUnitType(::Ifc2x3::IfcUnitEnum::Value v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcNamedUnit (IfcEntityInstanceData* e);
    IfcNamedUnit (::Ifc2x3::IfcDimensionalExponents* v1_Dimensions, ::Ifc2x3::IfcUnitEnum::Value v2_UnitType);
    typedef IfcTemplatedEntityList< IfcNamedUnit > list;
};
/// IfcObjectPlacement is an abstract supertype for the special types defining the object coordinate system. The
/// IfcObjectPlacement has to be provided for each product that has a shape representation.
/// The object placement can be given:
/// 
/// absolute: by an axis2 placement, relative to the world coordinate system,
/// relative: by an axis2 placement, relative to the object placement of another product,
/// by grid reference: by the virtual intersection and reference direction given by two axes of a design grid.
/// 
/// In any case the object placement has to unambiguously define the object coordinate system as either two-dimensional axis placement (IfcAxis2Placement2D) or three-dimensional axis placement (IfcAxis2Placement3D). The axis placement may have to be calculated.
/// 
/// HISTORY New entity in IFC Release 2x.
class IFC_PARSE_API IfcObjectPlacement : public IfcUtil::IfcBaseEntity {
public:
        IfcTemplatedEntityList< IfcProduct >::ptr PlacesObject() const; // INVERSE IfcProduct::ObjectPlacement
    IfcTemplatedEntityList< IfcLocalPlacement >::ptr ReferencedByPlacements() const; // INVERSE IfcLocalPlacement::PlacementRelTo
    virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcObjectPlacement (IfcEntityInstanceData* e);
    IfcObjectPlacement ();
    typedef IfcTemplatedEntityList< IfcObjectPlacement > list;
};
/// An IfcObjective captures qualitative information for an objective-based constraint. 
/// 
/// HISTORY: New Entity in IFC Release 2.0
/// 
/// Use definition 
/// 
/// IfcObjective is a subtype of IfcConstraint and may be associated with any subtype of IfcRoot through the IfcRelAssociatesConstraint relationship in the IfcControlExtension schema, or may be associated with IfcProperty by IfcPropertyConstraintRelationship.
/// 
/// The aim of IfcObjective is to specify the purpose for which the constraint is applied and to capture the values of the constraint. These may be both the benchmark values that are intended to indicate the constraint extent and the resulting values in use that enable performance comparisons to be applied.
class IFC_PARSE_API IfcObjective : public IfcConstraint {
public:
    /// Whether the optional attribute BenchmarkValues is defined for this IfcObjective
    bool hasBenchmarkValues() const;
    /// A list of any benchmark values used for comparison purposes.
    ::Ifc2x3::IfcMetric* BenchmarkValues() const;
    void setBenchmarkValues(::Ifc2x3::IfcMetric* v);
    /// Whether the optional attribute ResultValues is defined for this IfcObjective
    bool hasResultValues() const;
    /// A list of any resultant values used for comparison purposes.
    ::Ifc2x3::IfcMetric* ResultValues() const;
    void setResultValues(::Ifc2x3::IfcMetric* v);
    /// Enumeration that qualifies the type of objective constraint.
    ::Ifc2x3::IfcObjectiveEnum::Value ObjectiveQualifier() const;
    void setObjectiveQualifier(::Ifc2x3::IfcObjectiveEnum::Value v);
    /// Whether the optional attribute UserDefinedQualifier is defined for this IfcObjective
    bool hasUserDefinedQualifier() const;
    /// A user defined value that qualifies the type of objective constraint when ObjectiveQualifier attribute of type IfcObjectiveEnum has value USERDEFINED.
    std::string UserDefinedQualifier() const;
    void setUserDefinedQualifier(std::string v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcObjective (IfcEntityInstanceData* e);
    IfcObjective (std::string v1_Name, boost::optional< std::string > v2_Description, ::Ifc2x3::IfcConstraintEnum::Value v3_ConstraintGrade, boost::optional< std::string > v4_ConstraintSource, ::Ifc2x3::IfcActorSelect* v5_CreatingActor, ::Ifc2x3::IfcDateTimeSelect* v6_CreationTime, boost::optional< std::string > v7_UserDefinedGrade, ::Ifc2x3::IfcMetric* v8_BenchmarkValues, ::Ifc2x3::IfcMetric* v9_ResultValues, ::Ifc2x3::IfcObjectiveEnum::Value v10_ObjectiveQualifier, boost::optional< std::string > v11_UserDefinedQualifier);
    typedef IfcTemplatedEntityList< IfcObjective > list;
};

class IFC_PARSE_API IfcOpticalMaterialProperties : public IfcMaterialProperties {
public:
    /// Whether the optional attribute VisibleTransmittance is defined for this IfcOpticalMaterialProperties
    bool hasVisibleTransmittance() const;
    double VisibleTransmittance() const;
    void setVisibleTransmittance(double v);
    /// Whether the optional attribute SolarTransmittance is defined for this IfcOpticalMaterialProperties
    bool hasSolarTransmittance() const;
    double SolarTransmittance() const;
    void setSolarTransmittance(double v);
    /// Whether the optional attribute ThermalIrTransmittance is defined for this IfcOpticalMaterialProperties
    bool hasThermalIrTransmittance() const;
    double ThermalIrTransmittance() const;
    void setThermalIrTransmittance(double v);
    /// Whether the optional attribute ThermalIrEmissivityBack is defined for this IfcOpticalMaterialProperties
    bool hasThermalIrEmissivityBack() const;
    double ThermalIrEmissivityBack() const;
    void setThermalIrEmissivityBack(double v);
    /// Whether the optional attribute ThermalIrEmissivityFront is defined for this IfcOpticalMaterialProperties
    bool hasThermalIrEmissivityFront() const;
    double ThermalIrEmissivityFront() const;
    void setThermalIrEmissivityFront(double v);
    /// Whether the optional attribute VisibleReflectanceBack is defined for this IfcOpticalMaterialProperties
    bool hasVisibleReflectanceBack() const;
    double VisibleReflectanceBack() const;
    void setVisibleReflectanceBack(double v);
    /// Whether the optional attribute VisibleReflectanceFront is defined for this IfcOpticalMaterialProperties
    bool hasVisibleReflectanceFront() const;
    double VisibleReflectanceFront() const;
    void setVisibleReflectanceFront(double v);
    /// Whether the optional attribute SolarReflectanceFront is defined for this IfcOpticalMaterialProperties
    bool hasSolarReflectanceFront() const;
    double SolarReflectanceFront() const;
    void setSolarReflectanceFront(double v);
    /// Whether the optional attribute SolarReflectanceBack is defined for this IfcOpticalMaterialProperties
    bool hasSolarReflectanceBack() const;
    double SolarReflectanceBack() const;
    void setSolarReflectanceBack(double v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcOpticalMaterialProperties (IfcEntityInstanceData* e);
    IfcOpticalMaterialProperties (::Ifc2x3::IfcMaterial* v1_Material, boost::optional< double > v2_VisibleTransmittance, boost::optional< double > v3_SolarTransmittance, boost::optional< double > v4_ThermalIrTransmittance, boost::optional< double > v5_ThermalIrEmissivityBack, boost::optional< double > v6_ThermalIrEmissivityFront, boost::optional< double > v7_VisibleReflectanceBack, boost::optional< double > v8_VisibleReflectanceFront, boost::optional< double > v9_SolarReflectanceFront, boost::optional< double > v10_SolarReflectanceBack);
    typedef IfcTemplatedEntityList< IfcOpticalMaterialProperties > list;
};
/// A named and structured grouping with a corporate identity.
/// 
/// NOTE: The relationships between IfcOrganizations, like a Department within a Company, can be expressed using IfcOrganizationRelationship.
/// 
/// NOTE Corresponds to the following entity in ISO-10303-41: organization.
/// 
/// HISTORY New entity in IFC Release 1.5.1.
/// IFC 2x4 change: attribute Id renamed to Identification.
class IFC_PARSE_API IfcOrganization : public IfcUtil::IfcBaseEntity {
public:
    /// Whether the optional attribute Id is defined for this IfcOrganization
    bool hasId() const;
    std::string Id() const;
    void setId(std::string v);
    /// The word, or group of words, by which the organization is referred to.
    std::string Name() const;
    void setName(std::string v);
    /// Whether the optional attribute Description is defined for this IfcOrganization
    bool hasDescription() const;
    /// Text that relates the nature of the organization.
    std::string Description() const;
    void setDescription(std::string v);
    /// Whether the optional attribute Roles is defined for this IfcOrganization
    bool hasRoles() const;
    /// Roles played by the organization.
    IfcTemplatedEntityList< ::Ifc2x3::IfcActorRole >::ptr Roles() const;
    void setRoles(IfcTemplatedEntityList< ::Ifc2x3::IfcActorRole >::ptr v);
    /// Whether the optional attribute Addresses is defined for this IfcOrganization
    bool hasAddresses() const;
    /// Postal and telecom addresses of an organization.
    /// NOTE: There may be several addresses related to an organization.
    IfcTemplatedEntityList< ::Ifc2x3::IfcAddress >::ptr Addresses() const;
    void setAddresses(IfcTemplatedEntityList< ::Ifc2x3::IfcAddress >::ptr v);
        IfcTemplatedEntityList< IfcOrganizationRelationship >::ptr IsRelatedBy() const; // INVERSE IfcOrganizationRelationship::RelatedOrganizations
    IfcTemplatedEntityList< IfcOrganizationRelationship >::ptr Relates() const; // INVERSE IfcOrganizationRelationship::RelatingOrganization
    IfcTemplatedEntityList< IfcPersonAndOrganization >::ptr Engages() const; // INVERSE IfcPersonAndOrganization::TheOrganization
    virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcOrganization (IfcEntityInstanceData* e);
    IfcOrganization (boost::optional< std::string > v1_Id, std::string v2_Name, boost::optional< std::string > v3_Description, boost::optional< IfcTemplatedEntityList< ::Ifc2x3::IfcActorRole >::ptr > v4_Roles, boost::optional< IfcTemplatedEntityList< ::Ifc2x3::IfcAddress >::ptr > v5_Addresses);
    typedef IfcTemplatedEntityList< IfcOrganization > list;
};
/// Definition: establishes an association between one relating organization and one or more related organizations.
/// 
/// NOTE Corresponds to the following entity in ISO-10303-41: organization_relationship.
/// 
/// HISTORY New entity in IFC Release 2x.
/// IFC 2x4 change: attribute Name made optional.
class IFC_PARSE_API IfcOrganizationRelationship : public IfcUtil::IfcBaseEntity {
public:
    /// The word or group of words by which the relationship is referred to.
    std::string Name() const;
    void setName(std::string v);
    /// Whether the optional attribute Description is defined for this IfcOrganizationRelationship
    bool hasDescription() const;
    /// Text that relates the nature of the relationship.
    std::string Description() const;
    void setDescription(std::string v);
    /// Organization which is the relating part of the relationship between organizations.
    ::Ifc2x3::IfcOrganization* RelatingOrganization() const;
    void setRelatingOrganization(::Ifc2x3::IfcOrganization* v);
    /// The other, possibly dependent, organizations which are the related parts of the relationship between organizations.
    IfcTemplatedEntityList< ::Ifc2x3::IfcOrganization >::ptr RelatedOrganizations() const;
    void setRelatedOrganizations(IfcTemplatedEntityList< ::Ifc2x3::IfcOrganization >::ptr v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcOrganizationRelationship (IfcEntityInstanceData* e);
    IfcOrganizationRelationship (std::string v1_Name, boost::optional< std::string > v2_Description, ::Ifc2x3::IfcOrganization* v3_RelatingOrganization, IfcTemplatedEntityList< ::Ifc2x3::IfcOrganization >::ptr v4_RelatedOrganizations);
    typedef IfcTemplatedEntityList< IfcOrganizationRelationship > list;
};
/// IfcOwnerHistory defines all history and identification related information. In order to provide fast access it is directly attached to all independent objects, relationships and properties.
/// 
/// IfcOwnerHistory is used to identify the creating and owning application and user for the associated object, as well as capture the last modifying application and user.
/// 
/// HISTORY  New entity in IFC R1.0. Modified in IFC R2x4.
/// 
/// Informal propositions
/// 
/// If LastModifiedDate is defined but ChangeAction is not asserted, then the state of ChangeAction is assumed to be UNDEFINED.	  
/// If both LastModifiedDate and ChangeAction are asserted, then the state of ChangeAction applies to the value asserted in LastModifiedDate.
class IFC_PARSE_API IfcOwnerHistory : public IfcUtil::IfcBaseEntity {
public:
    /// Direct reference to the end user who currently "owns" this object. Note that IFC includes the concept of ownership transfer from one user to another and therefore distinguishes between the Owning User and Creating User.
    ::Ifc2x3::IfcPersonAndOrganization* OwningUser() const;
    void setOwningUser(::Ifc2x3::IfcPersonAndOrganization* v);
    /// Direct reference to the application which currently "Owns" this object on behalf of the owning user, who uses this application. Note that IFC includes the concept of ownership transfer from one application to another and therefore distinguishes between the Owning Application and Creating Application.
    ::Ifc2x3::IfcApplication* OwningApplication() const;
    void setOwningApplication(::Ifc2x3::IfcApplication* v);
    /// Whether the optional attribute State is defined for this IfcOwnerHistory
    bool hasState() const;
    /// Enumeration that defines the current access state of the object.
    ::Ifc2x3::IfcStateEnum::Value State() const;
    void setState(::Ifc2x3::IfcStateEnum::Value v);
    /// Enumeration that defines the actions associated with changes made to the object.
    ::Ifc2x3::IfcChangeActionEnum::Value ChangeAction() const;
    void setChangeAction(::Ifc2x3::IfcChangeActionEnum::Value v);
    /// Whether the optional attribute LastModifiedDate is defined for this IfcOwnerHistory
    bool hasLastModifiedDate() const;
    /// Date and Time expressed in UTC (Universal Time Coordinated, formerly Greenwich Mean Time or GMT) at which the last modification was made by LastModifyingUser and LastModifyingApplication.
    int LastModifiedDate() const;
    void setLastModifiedDate(int v);
    /// Whether the optional attribute LastModifyingUser is defined for this IfcOwnerHistory
    bool hasLastModifyingUser() const;
    /// User who carried out the last modification using LastModifyingApplication.
    ::Ifc2x3::IfcPersonAndOrganization* LastModifyingUser() const;
    void setLastModifyingUser(::Ifc2x3::IfcPersonAndOrganization* v);
    /// Whether the optional attribute LastModifyingApplication is defined for this IfcOwnerHistory
    bool hasLastModifyingApplication() const;
    /// Application used to make the last modification.
    ::Ifc2x3::IfcApplication* LastModifyingApplication() const;
    void setLastModifyingApplication(::Ifc2x3::IfcApplication* v);
    /// The date and time expressed in UTC (Universal Time Coordinated, formerly Greenwich Mean Time or GMT) when first created by the original OwningApplication. Once defined this value remains unchanged through the lifetime of the entity.
    int CreationDate() const;
    void setCreationDate(int v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcOwnerHistory (IfcEntityInstanceData* e);
    IfcOwnerHistory (::Ifc2x3::IfcPersonAndOrganization* v1_OwningUser, ::Ifc2x3::IfcApplication* v2_OwningApplication, boost::optional< ::Ifc2x3::IfcStateEnum::Value > v3_State, ::Ifc2x3::IfcChangeActionEnum::Value v4_ChangeAction, boost::optional< int > v5_LastModifiedDate, ::Ifc2x3::IfcPersonAndOrganization* v6_LastModifyingUser, ::Ifc2x3::IfcApplication* v7_LastModifyingApplication, int v8_CreationDate);
    typedef IfcTemplatedEntityList< IfcOwnerHistory > list;
};
/// Definition: an individual human being.
/// 
/// NOTE Many countries have legislation concerning the identification of individual persons within databases. Although the intent of the IFC Model is to act as a specification for data exchange 
/// and sharing, an IFC file might in some situations be considered to be a database that enables identification of a particular person under the terms of such legislation. Users should be aware of the constraints of legislation that might apply in the places where IFC files are used.
/// 
/// NOTE Corresponds to the following entity in ISO-10303-41: person.
/// 
/// HISTORY New entity in IFC Release 1.5.1.
/// IFC 2x4 change: attribute Id renamed to Identification.  WHERE rule relaxed to allow omission of names if Identification is provided.
class IFC_PARSE_API IfcPerson : public IfcUtil::IfcBaseEntity {
public:
    /// Whether the optional attribute Id is defined for this IfcPerson
    bool hasId() const;
    std::string Id() const;
    void setId(std::string v);
    /// Whether the optional attribute FamilyName is defined for this IfcPerson
    bool hasFamilyName() const;
    /// The name by which the family identity of the person may be recognized.
    /// NOTE: Depending on geographical location and culture, family name may appear either as the first or last component of a name.
    std::string FamilyName() const;
    void setFamilyName(std::string v);
    /// Whether the optional attribute GivenName is defined for this IfcPerson
    bool hasGivenName() const;
    /// The name by which a person is known within a family and by which he or she may be familiarly recognized.
    /// NOTE: Depending on geographical location and culture, given name may appear either as the first or last component of a name.
    std::string GivenName() const;
    void setGivenName(std::string v);
    /// Whether the optional attribute MiddleNames is defined for this IfcPerson
    bool hasMiddleNames() const;
    /// Additional names given to a person that enable their identification apart from others who may have the same or similar family and given names.
    /// NOTE: Middle names are not normally used in familiar communication but may be asserted to provide additional 
    /// identification of a particular person if necessary. They may be particularly useful in situations where the person concerned has a 
    /// family name that occurs commonly in the geographical region.
    std::vector< std::string > /*[1:?]*/ MiddleNames() const;
    void setMiddleNames(std::vector< std::string > /*[1:?]*/ v);
    /// Whether the optional attribute PrefixTitles is defined for this IfcPerson
    bool hasPrefixTitles() const;
    /// The word, or group of words, which specify the person's social and/or professional standing and appear before his/her names.
    std::vector< std::string > /*[1:?]*/ PrefixTitles() const;
    void setPrefixTitles(std::vector< std::string > /*[1:?]*/ v);
    /// Whether the optional attribute SuffixTitles is defined for this IfcPerson
    bool hasSuffixTitles() const;
    /// The word, or group of words, which specify the person's social and/or professional standing and appear after his/her names.
    std::vector< std::string > /*[1:?]*/ SuffixTitles() const;
    void setSuffixTitles(std::vector< std::string > /*[1:?]*/ v);
    /// Whether the optional attribute Roles is defined for this IfcPerson
    bool hasRoles() const;
    /// Roles played by the person.
    IfcTemplatedEntityList< ::Ifc2x3::IfcActorRole >::ptr Roles() const;
    void setRoles(IfcTemplatedEntityList< ::Ifc2x3::IfcActorRole >::ptr v);
    /// Whether the optional attribute Addresses is defined for this IfcPerson
    bool hasAddresses() const;
    /// Postal and telecommunication addresses of a person.
    /// NOTE - A person may have several addresses.
    IfcTemplatedEntityList< ::Ifc2x3::IfcAddress >::ptr Addresses() const;
    void setAddresses(IfcTemplatedEntityList< ::Ifc2x3::IfcAddress >::ptr v);
        IfcTemplatedEntityList< IfcPersonAndOrganization >::ptr EngagedIn() const; // INVERSE IfcPersonAndOrganization::ThePerson
    virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcPerson (IfcEntityInstanceData* e);
    IfcPerson (boost::optional< std::string > v1_Id, boost::optional< std::string > v2_FamilyName, boost::optional< std::string > v3_GivenName, boost::optional< std::vector< std::string > /*[1:?]*/ > v4_MiddleNames, boost::optional< std::vector< std::string > /*[1:?]*/ > v5_PrefixTitles, boost::optional< std::vector< std::string > /*[1:?]*/ > v6_SuffixTitles, boost::optional< IfcTemplatedEntityList< ::Ifc2x3::IfcActorRole >::ptr > v7_Roles, boost::optional< IfcTemplatedEntityList< ::Ifc2x3::IfcAddress >::ptr > v8_Addresses);
    typedef IfcTemplatedEntityList< IfcPerson > list;
};
/// Definition: Identification of a person within an organization.
/// 
/// NOTE Corresponds to the following entity in ISO-10303-41: person_and_organization.
/// 
/// HISTORY New entity in IFC Release 1.5.1
class IFC_PARSE_API IfcPersonAndOrganization : public IfcUtil::IfcBaseEntity {
public:
    /// The person who is related to the organization.
    ::Ifc2x3::IfcPerson* ThePerson() const;
    void setThePerson(::Ifc2x3::IfcPerson* v);
    /// The organization to which the person is related.
    ::Ifc2x3::IfcOrganization* TheOrganization() const;
    void setTheOrganization(::Ifc2x3::IfcOrganization* v);
    /// Whether the optional attribute Roles is defined for this IfcPersonAndOrganization
    bool hasRoles() const;
    /// Roles played by the person within the context of an organization.  These may differ from the roles in ThePerson.Roles which may be asserted without organizational context.
    IfcTemplatedEntityList< ::Ifc2x3::IfcActorRole >::ptr Roles() const;
    void setRoles(IfcTemplatedEntityList< ::Ifc2x3::IfcActorRole >::ptr v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcPersonAndOrganization (IfcEntityInstanceData* e);
    IfcPersonAndOrganization (::Ifc2x3::IfcPerson* v1_ThePerson, ::Ifc2x3::IfcOrganization* v2_TheOrganization, boost::optional< IfcTemplatedEntityList< ::Ifc2x3::IfcActorRole >::ptr > v3_Roles);
    typedef IfcTemplatedEntityList< IfcPersonAndOrganization > list;
};
/// The physical quantity, IfcPhysicalQuantity, is an abstract entity that holds a complex or simple quantity measure together with a semantic definition of the usage for the single or several measure value. 
/// 
/// The Name attribute defines the actual usage or kind of measure. The interpretation of the name label has to be established within the actual exchange context. In addition an informative text may be associated to each quantity by the Description attribute. 
/// 
/// HISTORY  New entity in IFC2x. It replaces the calcXxx attributes used in previous IFC Releases.
class IFC_PARSE_API IfcPhysicalQuantity : public IfcUtil::IfcBaseEntity {
public:
    /// Name of the element quantity or measure. The name attribute has to be made recognizable by further agreements.
    std::string Name() const;
    void setName(std::string v);
    /// Whether the optional attribute Description is defined for this IfcPhysicalQuantity
    bool hasDescription() const;
    /// Further explanation that might be given to the quantity.
    std::string Description() const;
    void setDescription(std::string v);
        IfcTemplatedEntityList< IfcPhysicalComplexQuantity >::ptr PartOfComplex() const; // INVERSE IfcPhysicalComplexQuantity::HasQuantities
    virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcPhysicalQuantity (IfcEntityInstanceData* e);
    IfcPhysicalQuantity (std::string v1_Name, boost::optional< std::string > v2_Description);
    typedef IfcTemplatedEntityList< IfcPhysicalQuantity > list;
};
/// The physical quantity, IfcPhysicalSimpleQuantity, is an entity that holds a single quantity measure value (as defined at the subtypes of IfcPhysicalSimpleQuantity) together with a semantic definition of the usage for the measure value. 
/// 
/// EXAMPLE  An element, like a wall, may have several area measures, like footprint area, left wall face area, right wall face area. These areas would be given by three instances of the area quantity subtype, with different Name string values.
/// 
/// A section "Quantity Use Definition" at individual entities as subtypes of IfcBuildingElement gives guidance to the usage of the Name attribute to characterize the individual quantities. If the Unit attribute is given, the value attribute (introduced at the level of subtypes of IfcPhysicalSimpleQuantity) are given as quantities of this unit, otherwise the global unit definitions (given by IfcUnitAssignment) are used.
/// 
/// HISTORY New entity in IFC2x2 Addendum 1.
/// 
/// IFC2x2 ADDENDUM 1 CHANGE  The abstract entity IfcPhysicalSimpleQuantity has been added. Upward compatibility for file based exchange is guaranteed.
class IFC_PARSE_API IfcPhysicalSimpleQuantity : public IfcPhysicalQuantity {
public:
    /// Whether the optional attribute Unit is defined for this IfcPhysicalSimpleQuantity
    bool hasUnit() const;
    /// Optional assignment of a unit. If no unit is given, then the global unit assignment, as established at the IfcProject, applies to the quantity measures.
    ::Ifc2x3::IfcNamedUnit* Unit() const;
    void setUnit(::Ifc2x3::IfcNamedUnit* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcPhysicalSimpleQuantity (IfcEntityInstanceData* e);
    IfcPhysicalSimpleQuantity (std::string v1_Name, boost::optional< std::string > v2_Description, ::Ifc2x3::IfcNamedUnit* v3_Unit);
    typedef IfcTemplatedEntityList< IfcPhysicalSimpleQuantity > list;
};
/// Definition: The address for delivery of paper based mail.
/// 
/// HISTORY New entity in IFC Release 2x.
class IFC_PARSE_API IfcPostalAddress : public IfcAddress {
public:
    /// Whether the optional attribute InternalLocation is defined for this IfcPostalAddress
    bool hasInternalLocation() const;
    /// An organization defined address for internal mail delivery.
    std::string InternalLocation() const;
    void setInternalLocation(std::string v);
    /// Whether the optional attribute AddressLines is defined for this IfcPostalAddress
    bool hasAddressLines() const;
    /// The postal address.
    /// NOTE: A postal address may occupy several lines (or elements) when recorded. 
    /// It is expected that normal usage will incorporate relevant elements of the following address concepts: 
    /// A location within a building (e.g. 3rd Floor) Building name (e.g. Interoperability House) Street number 
    /// (e.g. 6400) Street name (e.g. Alliance Boulevard). Typical content of address lines may vary in different 
    /// countries.
    std::vector< std::string > /*[1:?]*/ AddressLines() const;
    void setAddressLines(std::vector< std::string > /*[1:?]*/ v);
    /// Whether the optional attribute PostalBox is defined for this IfcPostalAddress
    bool hasPostalBox() const;
    /// An address that is implied by an identifiable mail drop.
    std::string PostalBox() const;
    void setPostalBox(std::string v);
    /// Whether the optional attribute Town is defined for this IfcPostalAddress
    bool hasTown() const;
    /// The name of a town.
    std::string Town() const;
    void setTown(std::string v);
    /// Whether the optional attribute Region is defined for this IfcPostalAddress
    bool hasRegion() const;
    /// The name of a region.
    /// NOTE: The counties of the United Kingdom and the states of North America are examples of regions.
    std::string Region() const;
    void setRegion(std::string v);
    /// Whether the optional attribute PostalCode is defined for this IfcPostalAddress
    bool hasPostalCode() const;
    /// The code that is used by the country's postal service.
    std::string PostalCode() const;
    void setPostalCode(std::string v);
    /// Whether the optional attribute Country is defined for this IfcPostalAddress
    bool hasCountry() const;
    /// The name of a country.
    std::string Country() const;
    void setCountry(std::string v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcPostalAddress (IfcEntityInstanceData* e);
    IfcPostalAddress (boost::optional< ::Ifc2x3::IfcAddressTypeEnum::Value > v1_Purpose, boost::optional< std::string > v2_Description, boost::optional< std::string > v3_UserDefinedPurpose, boost::optional< std::string > v4_InternalLocation, boost::optional< std::vector< std::string > /*[1:?]*/ > v5_AddressLines, boost::optional< std::string > v6_PostalBox, boost::optional< std::string > v7_Town, boost::optional< std::string > v8_Region, boost::optional< std::string > v9_PostalCode, boost::optional< std::string > v10_Country);
    typedef IfcTemplatedEntityList< IfcPostalAddress > list;
};
/// A pre defined item is a qualified name given to a style or font which is determined within the data exchange specification by convention on using the Name attribute value (in contrary to externally defined items, which are agreed by an external source).
/// 
/// NOTE  The convention on using the Name value is defined at the subtypes of IfcPreDefinedItem and is part of the specification.
/// 
/// NOTE  Corresponding ISO 10303 name: pre_defined_item. Please refer to ISO/IS 10303-41:1994, page 137 for the final definition of the formal standard.
/// 
/// HISTORY  New entity in IFC2x2.
class IFC_PARSE_API IfcPreDefinedItem : public IfcUtil::IfcBaseEntity {
public:
    /// The string by which the pre defined item is identified. Allowable values for the string are declared at the level of subtypes.
    std::string Name() const;
    void setName(std::string v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcPreDefinedItem (IfcEntityInstanceData* e);
    IfcPreDefinedItem (std::string v1_Name);
    typedef IfcTemplatedEntityList< IfcPreDefinedItem > list;
};
/// A predefined symbol is a symbol that gets its shape information by a conforming name that is specified within subtypes of the entity.
/// 
/// NOTE: The IfcPreDefinedSymbol is an entity that had been adopted from ISO 10303, Industrial automation systems and integration&#151;Product data representation and exchange, Part 46: Integrated generic resources: Visual presentation.
/// 
/// NOTE Corresponding ISO 10303 name: pre_defined_symbol. Please refer to ISO/IS 10303-46:1994 for the final definition of the formal standard.
/// 
/// HISTORY New entity in IFC2x2.
class IFC_PARSE_API IfcPreDefinedSymbol : public IfcPreDefinedItem {
public:
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcPreDefinedSymbol (IfcEntityInstanceData* e);
    IfcPreDefinedSymbol (std::string v1_Name);
    typedef IfcTemplatedEntityList< IfcPreDefinedSymbol > list;
};

class IFC_PARSE_API IfcPreDefinedTerminatorSymbol : public IfcPreDefinedSymbol {
public:
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcPreDefinedTerminatorSymbol (IfcEntityInstanceData* e);
    IfcPreDefinedTerminatorSymbol (std::string v1_Name);
    typedef IfcTemplatedEntityList< IfcPreDefinedTerminatorSymbol > list;
};
/// The pre defined text font determines those qualified names which can be used for fonts that are in scope of the current data exchange specification (in contrary to externally defined text fonts). There are two choices:
/// 
/// IfcDraughtingPreDefinedTextFont for definitions from ISO/IS 10303-46:1994 for (old) vector based and monospace text.
/// 
/// IfcTextStyleFontModel for definitions from Cascading Style Sheets, level 1, W3C Recommendation 17 Dec 1996, revised 11 Jan 1999, CSS1, for all true type text. The use of the CSS1 definitions is the preferred way to represent text fonts.
/// 
/// NOTE  Corresponding ISO 10303 name: pre_defined_text_font. Please refer to ISO/IS 10303-46:1994, p. 138 for the final definition of the formal standard.
/// 
/// HISTORY  New entity in IFC2x2.
/// 
/// IFC2x3 CHANGE  The IfcTextStyleFontModel has been added as new subtype.
class IFC_PARSE_API IfcPreDefinedTextFont : public IfcPreDefinedItem {
public:
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcPreDefinedTextFont (IfcEntityInstanceData* e);
    IfcPreDefinedTextFont (std::string v1_Name);
    typedef IfcTemplatedEntityList< IfcPreDefinedTextFont > list;
};
/// The presentation layer assignment provides the layer name (and optionally a description and an identifier) for a collection of geometric representation items. The IfcPresentationLayerAssignment corresponds to the term "CAD Layer" and is used mainly for grouping and visibility control.
/// 
/// NOTE  The use of presentation layer shall be restricted to simple grouping and displaying purposes.
/// 
/// Visibility and access control and layer style assignment (colour, line style, line width) is handled by the subtype IfcPresentationLayerAssignmentWithStyle.
/// 
/// NOTE  Corresponding ISO 10303 name: presentation layer assignment. Please refer to ISO/IS 10303-46:1994, p. 36 for the final definition of the formal standard.
/// 
/// HISTORY  New entity in IFC2x2.
/// 
/// Attribute use definition
/// 
/// Figure 305 illustrates assignment of items by shape representation or representation item. The set of AssignedItems can either include a whole shape representation, or individual geometric representation items. If both, the IfcShapeRepresentation has a layer assignment, and an individual geometric representation item in the set of IfcShapeRepresentation.Items, then the layer assignment of the IfcGeometricRepresentationItem overides the layer assignment of the IfcShapeRepresentation.
/// 
/// Figure 305 — Presentation layer assignment
class IFC_PARSE_API IfcPresentationLayerAssignment : public IfcUtil::IfcBaseEntity {
public:
    /// Name of the layer.
    std::string Name() const;
    void setName(std::string v);
    /// Whether the optional attribute Description is defined for this IfcPresentationLayerAssignment
    bool hasDescription() const;
    /// Additional description of the layer.
    std::string Description() const;
    void setDescription(std::string v);
    /// The set of layered items, which are assigned to this layer.
    IfcEntityList::ptr AssignedItems() const;
    void setAssignedItems(IfcEntityList::ptr v);
    /// Whether the optional attribute Identifier is defined for this IfcPresentationLayerAssignment
    bool hasIdentifier() const;
    /// An (internal) identifier assigned to the layer.
    std::string Identifier() const;
    void setIdentifier(std::string v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcPresentationLayerAssignment (IfcEntityInstanceData* e);
    IfcPresentationLayerAssignment (std::string v1_Name, boost::optional< std::string > v2_Description, IfcEntityList::ptr v3_AssignedItems, boost::optional< std::string > v4_Identifier);
    typedef IfcTemplatedEntityList< IfcPresentationLayerAssignment > list;
};
/// An IfcPresentationLayerAssignmentWithStyle extends the presentation layer assignment with capabilities to define visibility control, access control and common style information.
/// 
/// The visibility control allows to define a layer to be either 'on' or 'off', and/or 'frozen' or 'not frozen'. The access control allows to block graphical entities from manipulations by setting a layer to be either 'blocked' or 'not blocked'. Common style information can be given to the layer.
/// 
/// NOTE  Style information assigned to layers is often restricted to 'layer colour', 'curve font', and/or 'curve width'. These styles are assigned by using the IfcCurveStyle within the LayerStyles.
/// 
/// NOTE: If a styled item is assigned to a layer using the IfcPresentationLayerAssignmentWithStyle, it inherits the style information from the layer. In this case, it should omit its own style information. If the styled item has style information assigned (such as by IfcCurveStyle, IfcFillAreaStyle, IfcTextStyle, IfcSurfaceStyle, IfcSymbolStyle), then it overrides the style provided by the IfcPresentationLayerAssignmentWithStyle.
/// 
/// NOTE  The IfcPresentationLayerAssignmentWithStyle extends the presentation_layer_assignment entity as defined in ISO/IS 10303-46:1994, p. 36.
/// 
/// HISTORY  New entity in IFC2x2.
/// 
/// IFC2x3 CHANGE  The attributes have been modified without upward compatibility.
class IFC_PARSE_API IfcPresentationLayerWithStyle : public IfcPresentationLayerAssignment {
public:
    /// A logical setting, TRUE indicates that the layer is set to 'On', FALSE that the layer is set to 'Off', UNKNOWN that such information is not available.
    bool LayerOn() const;
    void setLayerOn(bool v);
    /// A logical setting, TRUE indicates that the layer is set to 'Frozen', FALSE that the layer is set to 'Not frozen', UNKNOWN that such information is not available.
    bool LayerFrozen() const;
    void setLayerFrozen(bool v);
    /// A logical setting, TRUE indicates that the layer is set to 'Blocked', FALSE that the layer is set to 'Not blocked', UNKNOWN that such information is not available.
    bool LayerBlocked() const;
    void setLayerBlocked(bool v);
    /// Assignment of presentation styles to the layer to provide a default style for representation items.
    /// 
    /// NOTE  In most cases the assignment of styles to a layer is restricted to an IfcCurveStyle representing the layer curve colour, layer curve thickness, and layer curve type.
    /// 
    /// IFC2x4 CHANGE  The data type has been changed from IfcPresentationStyleSelect (now deprecated) to IfcPresentationStyle.
    IfcEntityList::ptr LayerStyles() const;
    void setLayerStyles(IfcEntityList::ptr v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcPresentationLayerWithStyle (IfcEntityInstanceData* e);
    IfcPresentationLayerWithStyle (std::string v1_Name, boost::optional< std::string > v2_Description, IfcEntityList::ptr v3_AssignedItems, boost::optional< std::string > v4_Identifier, bool v5_LayerOn, bool v6_LayerFrozen, bool v7_LayerBlocked, IfcEntityList::ptr v8_LayerStyles);
    typedef IfcTemplatedEntityList< IfcPresentationLayerWithStyle > list;
};
/// IfcPresentationStyle is an abstract generalization of style table for presentation information assigned to geometric representation items. It includes styles for curves, areas, surfaces, text and symbols. Style information may include colour, hatching, rendering, and text fonts.
/// 
/// Each subtype of  IfcPresentationStyle can be assigned to IfcGeometricRepresentationItem's via the IfcPresentationStyleAssignment through an intermediate IfcStyledItem or one of its subtypes.
/// 
/// HISTORY  New entity in IFC2x3.
class IFC_PARSE_API IfcPresentationStyle : public IfcUtil::IfcBaseEntity {
public:
    /// Whether the optional attribute Name is defined for this IfcPresentationStyle
    bool hasName() const;
    /// Name of the presentation style.
    std::string Name() const;
    void setName(std::string v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcPresentationStyle (IfcEntityInstanceData* e);
    IfcPresentationStyle (boost::optional< std::string > v1_Name);
    typedef IfcTemplatedEntityList< IfcPresentationStyle > list;
};
/// Definition from ISO/CD 10303-46:1992: The presentation style assignment is a set of styles which are assigned to styled items for the purpose of presenting these styled items. 
/// 
/// NOTE Corresponding ISO 10303 name: presentation_style_assignment. Please refer to ISO/IS 10303-46:1994 for the final definition of the formal standard.
/// 
/// HISTORY New entity in Release IFC2x2.
class IFC_PARSE_API IfcPresentationStyleAssignment : public IfcUtil::IfcBaseEntity {
public:
    /// A set of presentation styles that are assigned to styled items.
    IfcEntityList::ptr Styles() const;
    void setStyles(IfcEntityList::ptr v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcPresentationStyleAssignment (IfcEntityInstanceData* e);
    IfcPresentationStyleAssignment (IfcEntityList::ptr v1_Styles);
    typedef IfcTemplatedEntityList< IfcPresentationStyleAssignment > list;
};
/// IfcProductRepresentation defines a representation of a
/// product, including its (geometric or topological) representation.
/// A product can have zero, one or many geometric representations,
/// and a single geometric representation can be shared among various
/// products using mapped representations.
/// 
/// NOTE: The definition
/// of this entity relates to the ISO 10303 entity property_definition.
/// The use of the term ‘property’ was avoided since it
/// conflicts with the property, property type, and property set
/// definitions elsewhere in the IFC model.
/// 
/// HISTORY New entity in IFC Release 2.0
/// 
/// IFC2x3 NOTE ÿUsers should not instantiate the entity from IFC2x Edition 3 onwards.
/// 
/// IFC2x4 CHANGE  Entity made abstract.
class IFC_PARSE_API IfcProductRepresentation : public IfcUtil::IfcBaseEntity {
public:
    /// Whether the optional attribute Name is defined for this IfcProductRepresentation
    bool hasName() const;
    /// The word or group of words by which the product representation is known.
    std::string Name() const;
    void setName(std::string v);
    /// Whether the optional attribute Description is defined for this IfcProductRepresentation
    bool hasDescription() const;
    /// The word or group of words that characterize the product representation. It can be used to add additional meaning to the name of the product representation.
    std::string Description() const;
    void setDescription(std::string v);
    /// Contained list of representations (including shape representations). Each member defines a valid representation of a particular type within a particular representation context.
    IfcTemplatedEntityList< ::Ifc2x3::IfcRepresentation >::ptr Representations() const;
    void setRepresentations(IfcTemplatedEntityList< ::Ifc2x3::IfcRepresentation >::ptr v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcProductRepresentation (IfcEntityInstanceData* e);
    IfcProductRepresentation (boost::optional< std::string > v1_Name, boost::optional< std::string > v2_Description, IfcTemplatedEntityList< ::Ifc2x3::IfcRepresentation >::ptr v3_Representations);
    typedef IfcTemplatedEntityList< IfcProductRepresentation > list;
};

class IFC_PARSE_API IfcProductsOfCombustionProperties : public IfcMaterialProperties {
public:
    /// Whether the optional attribute SpecificHeatCapacity is defined for this IfcProductsOfCombustionProperties
    bool hasSpecificHeatCapacity() const;
    double SpecificHeatCapacity() const;
    void setSpecificHeatCapacity(double v);
    /// Whether the optional attribute N20Content is defined for this IfcProductsOfCombustionProperties
    bool hasN20Content() const;
    double N20Content() const;
    void setN20Content(double v);
    /// Whether the optional attribute COContent is defined for this IfcProductsOfCombustionProperties
    bool hasCOContent() const;
    double COContent() const;
    void setCOContent(double v);
    /// Whether the optional attribute CO2Content is defined for this IfcProductsOfCombustionProperties
    bool hasCO2Content() const;
    double CO2Content() const;
    void setCO2Content(double v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcProductsOfCombustionProperties (IfcEntityInstanceData* e);
    IfcProductsOfCombustionProperties (::Ifc2x3::IfcMaterial* v1_Material, boost::optional< double > v2_SpecificHeatCapacity, boost::optional< double > v3_N20Content, boost::optional< double > v4_COContent, boost::optional< double > v5_CO2Content);
    typedef IfcTemplatedEntityList< IfcProductsOfCombustionProperties > list;
};
/// IfcProfileDef
/// is the supertype of all definitions of standard and arbitrary profiles
/// within IFC. It is used to define a standard set of commonly used
/// section profiles by their parameters or by their explicit curve geometry.
/// 
/// Parameterized profiles are 2D primitives, which are used within the industry to describe cross
///   sections by a description of its parameters.
///   Arbitrary profiles are cross
///   sections defined by an outer boundary as bounded curve, which may also
///   include holes, defined by inner boundaries.
///   Derived profiles, based on a
///   transformation of a parent profile, are also part of the profile
///   definitions available.
///   In addition composite
///   profiles can be defined, which include two or more profile definitions
///   to define the resulting profile.
/// 
/// HISTORY  New class in IFC Release 1.5, the capabilities have been extended in IFC Release 2x.
/// Profiles can now support swept surfaces and swept area solids with
/// inner boundaries. It had been renamed from IfcAttDrivenProfileDef.
/// 
/// IFC2x4 CHANGE  Changed from ABSTRACT to non-abstract for uses which do not
/// require an explicitly defined geometry.  Added inverse attributes HasProperties and HasExternalReference.
/// 
/// Use in material association
/// 
/// Beams, columns, and similarly shaped building elements and their type objects may
/// be associated with a section profile definition, combined with material definition,
/// by means of IfcRelAssociatesMaterial together with IfcMaterialProfileSet
/// and IfcMaterialProfileSetUsage. This way, building elements and element types
/// with same section and material can share a common section profile definition and
/// association.
/// 
/// The profile definition in material association is required to be consistent with
/// shape representations of the respective building elements.
/// 
/// A higher-level description of spatial aligment of the section profile of a member
/// (such as centered, bottom-left, in the geometric centroid, and more) can be provided
/// within IfcMaterialProfileSetUsage by means of a cardinal point reference.
/// This can be used redundant to geometric data in order to convey design intent.
/// 
/// Use in shape models
/// 
/// Profile definitions are used within the geometry and geometric model
/// resource to create either swept surfaces, swept area solids, or
/// sectioned spines.
/// 
/// The purpose of the profile
/// definition within the swept surfaces or swept area solids is to define
/// a uniform cross section being swept:
/// 
/// along a line (extrusion) using IfcSurfaceOfLinearExtrusion or IfcExtrudedAreaSolid
///   along a circular arc (revolution) using IfcSurfaceOfRevolution or IfcRevolvedAreaSolid
///   along a directrix lying on a reference surface using IfcSurfaceCurveSweptAreaSolid
/// 
/// The purpose fo the profile
/// definition within the sectioned spine is to define a varying cross
/// sections at several positions along a spine curve. The subtype IfcDerivedProfileDef
/// is particularly suited to provide the consecutive profiles to be based
/// on transformations of the start profile and thus maintaining the
/// identity of vertices and edges.
/// 
/// NOTE  Subtypes of the IfcProfileDef
/// contain parameterized profiles (as subtypes of IfcParameterizedProfileDef)
/// which establish their own 2D position coordinate system, profiles given
/// by explicit curve geometry (either open or closed profiles) and two
/// special types for composite profiles and derived profiles, based on a
/// 2D Cartesian transformation.
/// 
/// An IfcProfileDef
/// is treated as bounded area if it is used within swept area solids. In
/// this case, the inside of the profile is part of the profile. The
/// attribute ProfileType is set to AREA. An IfcProfileDef
/// is treated as a curve if it is used within swept surfaces. In this
/// case, the inside of the profile (if the curve is closed) is not part of
/// the profile. The attribute ProfileType
/// is set to CURVE.
/// 
/// Figure 320 illustrates use of parameterized profiles within a swept area solid.
/// 
/// Position
/// The IfcProfileDef is defined within the underlying
/// coordinate system which is defined by the swept surface or swept area solid
/// that uses the profile definition. It is the xy plane
/// 
/// of IfcSweptSurface.Position or
///   of IfcSweptAreaSolid.Position or
///   of each list member of IfcSectionedSpine.CrossSectionPositions.
/// 
/// In the figure to the left, the z axis of the position coordinate system points outwards of the drawing plane.
/// 
/// Note: The subtype IfcParameterizedProfileDef optionally provides an additional 2D position coordinate system relative to the underlying coordinate system of the IfcProfileDef.
/// 
/// Sweeping
/// 
/// In the later use of the IfcProfileDef
/// within the swept surface or swept area solid,  e.g. the IfcExtrudedAreaSolid
/// (here used as an example), the profile boundaries (here based on the 2D
/// position coordinate system of IfcParameterizedProfileDef)
/// are placed within the xy plane of the 3D position coordinate system of
/// the swept surface or swept area solid.
/// 
/// The profile is inserted into the underlying coordinate system either:
/// 
/// directly in case of using IfcArbitraryClosedProfileDef
///   and IfcArbitraryOpenProfileDef,
/// 
/// through an intermediate position coordinate system in case of
///   using IfcParameterizedProfileDef.
/// 
/// through an 2D Cartesian transformation operator (applied directly
///   to the curve position when using arbitrary profile definitions,
///   or applied to the position coordinate system when using parameterized
///   profile definitions) in case of using IfcDerivedProfileDef.
/// 
/// when using IfcCompositeProfileDef the insertion depends on
///   the subtype of the included sub-profiles.
/// 
/// Figure 320 — Profile sweeping
/// 
/// Profile types
/// 
/// Results of the different usage of the ProfileType attribute are demonstrated here. The ProfileType defines whether the inside (the bounded area) is part of the profile definition (Area) or not (Curve). Figure 321 illustrates the resulting area or curve depending on ProfileType.
/// 
/// ProfileType = AREA
/// 
/// ProfileType = CURVE
/// 
/// Figure 321 — Profile types
/// 
/// Profile specification by external reference
/// 
/// If the profile is standardized by a norm or a catalogue, a reference
/// to this norm or catalogue should be provided by means of HasExternalReference.
/// This inverse relationship is used to associate an IfcExternalReference (notably
/// IfcClassificationReference or IfcLibraryReference) with the
/// profile.
/// 
/// IfcClassificationReference is used to refer to a profile norm (a common standard or
/// manufacturer's standard).  In this case,
/// 
/// IfcClassificationReference.ItemReference
/// contains the formal profile designation from the norm.
/// (On the other hand, IfcProfileDef.ProfileName contains a displayable name which may
/// not necessarily be the same as the formal designation.)
/// IfcClassificationReference.Name carries the short name of the profile norm.
/// Optionally, the norm can be further described by
/// IfcClassificationReference.ReferencedSource.
/// 
/// IfcLibraryReference is used to refer to a library which contains profile
/// definitions. In this case,
/// 
/// IfcLibraryReference.ItemReference contains the identifier of the
/// profile within the library and is meant to be machine-readable (in contrast to
/// IfcProfileDef.ProfileName which should be human-readable).
/// IfcLibraryReference.Location and .Name or .ReferencedLibrary
/// further describe the library.
/// 
/// If an external reference is provided, sending systems shall ensure that
/// the shape of the profile definition object agrees with the definitions in the
/// referenced classification or library.
/// 
/// Direct instances of IfcProfileDef
/// 
/// Usually, only subtypes of IfcProfileDef should be instantiated.
/// In some special cases, e.g. if the profile object is used for purposes
/// other than geometric models (e.g. for structural analysis models), it may be
/// possible to directly instantiate IfcProfileDef and further specify
/// the profile only by external reference or by profile properties. The latter
/// are tracked by the inverse attribute HasProperties.
class IFC_PARSE_API IfcProfileDef : public IfcUtil::IfcBaseEntity {
public:
    /// Defines the type of geometry into which this profile definition shall be resolved, either a curve or a surface area. In case of curve the profile should be referenced by a swept surface, in case of area the profile should be referenced by a swept area solid.
    ::Ifc2x3::IfcProfileTypeEnum::Value ProfileType() const;
    void setProfileType(::Ifc2x3::IfcProfileTypeEnum::Value v);
    /// Whether the optional attribute ProfileName is defined for this IfcProfileDef
    bool hasProfileName() const;
    /// Human-readable name of the profile, for example according to a standard profile table. As noted above, machine-readable standardized profile designations should be provided in IfcExternalReference.ItemReference.
    std::string ProfileName() const;
    void setProfileName(std::string v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcProfileDef (IfcEntityInstanceData* e);
    IfcProfileDef (::Ifc2x3::IfcProfileTypeEnum::Value v1_ProfileType, boost::optional< std::string > v2_ProfileName);
    typedef IfcTemplatedEntityList< IfcProfileDef > list;
};
/// This is a collection of properties applicable to section profile definitions.
/// 
/// The following sets of extended profile property definitions are part of this IFC release:
/// 
/// mechanical properties for all classes of profiles
/// properties for precast concrete double-T sections
/// properties for precast concrete hollow core sections
/// 
/// HISTORY  New entity in IFC2x2.
/// 
/// IFC2x4 CHANGE  Entity made non-abstract.  Subtypes IfcGeneralProfileProperties, IfcStructuralProfileProperties, and IfcStructuralSteelProfileProperties deleted. Attribute ProfileName deleted, use ProfileDefinition.ProfileName instead. Attribute ProfileDefinition made mandatory. Attributes Name, Description, and HasProperties added.
class IFC_PARSE_API IfcProfileProperties : public IfcUtil::IfcBaseEntity {
public:
    /// Whether the optional attribute ProfileName is defined for this IfcProfileProperties
    bool hasProfileName() const;
    std::string ProfileName() const;
    void setProfileName(std::string v);
    /// Whether the optional attribute ProfileDefinition is defined for this IfcProfileProperties
    bool hasProfileDefinition() const;
    /// Profile definition which is qualified by these properties.
    ::Ifc2x3::IfcProfileDef* ProfileDefinition() const;
    void setProfileDefinition(::Ifc2x3::IfcProfileDef* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcProfileProperties (IfcEntityInstanceData* e);
    IfcProfileProperties (boost::optional< std::string > v1_ProfileName, ::Ifc2x3::IfcProfileDef* v2_ProfileDefinition);
    typedef IfcTemplatedEntityList< IfcProfileProperties > list;
};
/// IfcProperty is an abstract generalization for all types of properties that can be associated with IFC objects through the property set mechanism. 
/// 
/// HISTORY  New entity in IFC Release 1.0.
class IFC_PARSE_API IfcProperty : public IfcUtil::IfcBaseEntity {
public:
    /// Name for this property. This label is the significant name string that defines the semantic meaning for the property.
    std::string Name() const;
    void setName(std::string v);
    /// Whether the optional attribute Description is defined for this IfcProperty
    bool hasDescription() const;
    /// Informative text to explain the property.
    std::string Description() const;
    void setDescription(std::string v);
        IfcTemplatedEntityList< IfcPropertyDependencyRelationship >::ptr PropertyForDependance() const; // INVERSE IfcPropertyDependencyRelationship::DependingProperty
    IfcTemplatedEntityList< IfcPropertyDependencyRelationship >::ptr PropertyDependsOn() const; // INVERSE IfcPropertyDependencyRelationship::DependantProperty
    IfcTemplatedEntityList< IfcComplexProperty >::ptr PartOfComplex() const; // INVERSE IfcComplexProperty::HasProperties
    virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcProperty (IfcEntityInstanceData* e);
    IfcProperty (std::string v1_Name, boost::optional< std::string > v2_Description);
    typedef IfcTemplatedEntityList< IfcProperty > list;
};

class IFC_PARSE_API IfcPropertyConstraintRelationship : public IfcUtil::IfcBaseEntity {
public:
    ::Ifc2x3::IfcConstraint* RelatingConstraint() const;
    void setRelatingConstraint(::Ifc2x3::IfcConstraint* v);
    IfcTemplatedEntityList< ::Ifc2x3::IfcProperty >::ptr RelatedProperties() const;
    void setRelatedProperties(IfcTemplatedEntityList< ::Ifc2x3::IfcProperty >::ptr v);
    /// Whether the optional attribute Name is defined for this IfcPropertyConstraintRelationship
    bool hasName() const;
    std::string Name() const;
    void setName(std::string v);
    /// Whether the optional attribute Description is defined for this IfcPropertyConstraintRelationship
    bool hasDescription() const;
    std::string Description() const;
    void setDescription(std::string v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcPropertyConstraintRelationship (IfcEntityInstanceData* e);
    IfcPropertyConstraintRelationship (::Ifc2x3::IfcConstraint* v1_RelatingConstraint, IfcTemplatedEntityList< ::Ifc2x3::IfcProperty >::ptr v2_RelatedProperties, boost::optional< std::string > v3_Name, boost::optional< std::string > v4_Description);
    typedef IfcTemplatedEntityList< IfcPropertyConstraintRelationship > list;
};
/// An IfcPropertyDependencyRelationship describes an identified dependency between the value of one property and that of another.
/// 
/// HISTORY  New entity in IFC2x2
/// 
/// IFC2x4 CHANGE  Made subtype of IfcResourceLevelRelationship (attribute order changed).
/// 
/// Use Definition
/// Whilst the IfcPropertyDependencyRelationship may be used to describe the dependency, and it may do so in terms of the expression of how the dependency operates, it is not possible through the current IFC model for the value of the related property to be actually derived from the value of the relating property. The determination of value according to the dependency is required to be performed by an application that can then use the Expression attribute to flag the form of the dependency.
class IFC_PARSE_API IfcPropertyDependencyRelationship : public IfcUtil::IfcBaseEntity {
public:
    /// The property on which the relationship depends.
    ::Ifc2x3::IfcProperty* DependingProperty() const;
    void setDependingProperty(::Ifc2x3::IfcProperty* v);
    /// The dependant property.
    ::Ifc2x3::IfcProperty* DependantProperty() const;
    void setDependantProperty(::Ifc2x3::IfcProperty* v);
    /// Whether the optional attribute Name is defined for this IfcPropertyDependencyRelationship
    bool hasName() const;
    std::string Name() const;
    void setName(std::string v);
    /// Whether the optional attribute Description is defined for this IfcPropertyDependencyRelationship
    bool hasDescription() const;
    std::string Description() const;
    void setDescription(std::string v);
    /// Whether the optional attribute Expression is defined for this IfcPropertyDependencyRelationship
    bool hasExpression() const;
    /// Expression that further describes the nature of the dependency relation.
    std::string Expression() const;
    void setExpression(std::string v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcPropertyDependencyRelationship (IfcEntityInstanceData* e);
    IfcPropertyDependencyRelationship (::Ifc2x3::IfcProperty* v1_DependingProperty, ::Ifc2x3::IfcProperty* v2_DependantProperty, boost::optional< std::string > v3_Name, boost::optional< std::string > v4_Description, boost::optional< std::string > v5_Expression);
    typedef IfcTemplatedEntityList< IfcPropertyDependencyRelationship > list;
};
/// IfcPropertyEnumeration is a collection of simple
/// or measure values that define a prescribed set of alternatives from
/// which 'enumeration values' are selected. This enables inclusion of
/// enumeration values in property sets. IfcPropertyEnumeration
/// provides a name for the enumeration as well as a list of unique
/// (numeric or descriptive) values (that may have a measure type
/// assigned). The entity defines the list of potential enumerators to be
/// exchanged together (or separately) with properties of type IfcPropertyEnumeratedValue
/// that selects their actual property values from this enumeration. 
/// The unit is handled by the Unit attribute:
/// 
/// If the Unit attribute is not given,
/// than the unit is already implied by the type of IfcMeasureValue
/// or IfcDerivedMeasureValue. The associated unit can
/// be found at the IfcUnitAssignment globally defined
/// at the project level (IfcProject.UnitsInContext).
///   If the Unit attribute is given, the
/// unit assigned by the unit attribute overrides the globally assigned
/// unit.
/// 
/// Name
///   EnumerationValues
///   Type (through IfcValue)
///   Unit
/// 
/// PEnum_DamperBladeAction
///   Parallel
///   IfcString
///   -
/// 
///  
///   Opposed
///   IfcString
///    
/// 
///  
///   Other
///   IfcString
///    
/// 
///  
///   Unset
///   IfcString
///    
/// 
/// HISTORY  New Entity in IFC Release 2.0, capabilities enhanced in IFC Release 2x. Entity has been renamed from IfcEnumeration in IFC Release 2x.
class IFC_PARSE_API IfcPropertyEnumeration : public IfcUtil::IfcBaseEntity {
public:
    /// Name of this enumeration.
    std::string Name() const;
    void setName(std::string v);
    /// List of values that form the enumeration.
    IfcEntityList::ptr EnumerationValues() const;
    void setEnumerationValues(IfcEntityList::ptr v);
    /// Whether the optional attribute Unit is defined for this IfcPropertyEnumeration
    bool hasUnit() const;
    /// Unit for the enumerator values, if not given, the default value for the measure type (given by the TYPE of nominal value) is used as defined by the global unit assignment at IfcProject.
    ::Ifc2x3::IfcUnit* Unit() const;
    void setUnit(::Ifc2x3::IfcUnit* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcPropertyEnumeration (IfcEntityInstanceData* e);
    IfcPropertyEnumeration (std::string v1_Name, IfcEntityList::ptr v2_EnumerationValues, ::Ifc2x3::IfcUnit* v3_Unit);
    typedef IfcTemplatedEntityList< IfcPropertyEnumeration > list;
};
/// IfcQuantityArea is a physical quantity that defines a derived area measure to provide an element's physical property. It is normally derived from the physical properties of the element under the specific measure rules given by a method of measurement. 
/// 
/// EXAMPLE  An opening may have an opening area used to deduct it from the wall surface area. The actual size of the area depends on the method of measurement used.
/// 
/// HISTORY  New entity in IFC2x. It replaces the calcXxx attributes used in previous IFC Releases.
class IFC_PARSE_API IfcQuantityArea : public IfcPhysicalSimpleQuantity {
public:
    /// Area measure value of this quantity.
    double AreaValue() const;
    void setAreaValue(double v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcQuantityArea (IfcEntityInstanceData* e);
    IfcQuantityArea (std::string v1_Name, boost::optional< std::string > v2_Description, ::Ifc2x3::IfcNamedUnit* v3_Unit, double v4_AreaValue);
    typedef IfcTemplatedEntityList< IfcQuantityArea > list;
};
/// IfcQuantityCount is a physical quantity that defines a derived count measure to provide an element's physical property. It is normally derived from the physical properties of the element under the specific measure rules given by a method of measurement.
/// 
/// EXAMPLE  An radiator may be measured according to its number of coils. The actual counting method depends on the method of measurement used.
/// 
/// HISTORY  New entity in IFC2x. It replaces the calcXxx attributes used in previous IFC Releases.
class IFC_PARSE_API IfcQuantityCount : public IfcPhysicalSimpleQuantity {
public:
    /// Count measure value of this quantity.
    double CountValue() const;
    void setCountValue(double v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcQuantityCount (IfcEntityInstanceData* e);
    IfcQuantityCount (std::string v1_Name, boost::optional< std::string > v2_Description, ::Ifc2x3::IfcNamedUnit* v3_Unit, double v4_CountValue);
    typedef IfcTemplatedEntityList< IfcQuantityCount > list;
};
/// IfcQuantityLength is a physical quantity that defines a derived length measure to provide an element's physical property. It is normally derived from the physical properties of the element under the specific measure rules given by a method of measurement.
/// 
/// EXAMPLE  A rafter within a roof construction may be measured according to its length (taking a common cross section into account). The actual size of the length depends on the method of measurement used.
/// 
/// HISTORY  New entity in IFC Release 2.x. It replaces the calcXxx attributes used in previous IFC Releases.
class IFC_PARSE_API IfcQuantityLength : public IfcPhysicalSimpleQuantity {
public:
    /// Length measure value of this quantity.
    double LengthValue() const;
    void setLengthValue(double v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcQuantityLength (IfcEntityInstanceData* e);
    IfcQuantityLength (std::string v1_Name, boost::optional< std::string > v2_Description, ::Ifc2x3::IfcNamedUnit* v3_Unit, double v4_LengthValue);
    typedef IfcTemplatedEntityList< IfcQuantityLength > list;
};
/// IfcQuantityTime is an element quantity that defines a time measure to provide an property of time related to an element. It is normally given by the recipe information of the element under the specific measure rules given by a method of measurement.
/// 
/// EXAMPLE  The amount of time needed to pour concrete for a wall is given as a time quantity for the labor part of the recipe information.
/// 
/// HISTORY  New entity in IFC2x2.
class IFC_PARSE_API IfcQuantityTime : public IfcPhysicalSimpleQuantity {
public:
    /// Time measure value of this quantity.
    double TimeValue() const;
    void setTimeValue(double v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcQuantityTime (IfcEntityInstanceData* e);
    IfcQuantityTime (std::string v1_Name, boost::optional< std::string > v2_Description, ::Ifc2x3::IfcNamedUnit* v3_Unit, double v4_TimeValue);
    typedef IfcTemplatedEntityList< IfcQuantityTime > list;
};
/// IfcQuantityVolume is a physical quantity that defines a derived volume measure to provide an element's physical property. It is normally derived from the physical properties of the element under the specific measure rules given by a method of measurement. 
/// 
/// EXAMPLE  A thick brick wall may be measured according to its volume. The actual size of the volume depends on the method of measurement used.
/// 
/// HISTORY New entity in IFC2x. It replaces the calcXxx attributes used in previous IFC Releases.
class IFC_PARSE_API IfcQuantityVolume : public IfcPhysicalSimpleQuantity {
public:
    /// Volume measure value of this quantity.
    double VolumeValue() const;
    void setVolumeValue(double v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcQuantityVolume (IfcEntityInstanceData* e);
    IfcQuantityVolume (std::string v1_Name, boost::optional< std::string > v2_Description, ::Ifc2x3::IfcNamedUnit* v3_Unit, double v4_VolumeValue);
    typedef IfcTemplatedEntityList< IfcQuantityVolume > list;
};
/// IfcQuantityWeight is a physical element quantity that defines a derived weight measure to provide an element's physical property. It is normally derived from the physical properties of the element under the specific measure rules given by a method of measurement. 
/// 
/// EXAMPLE  The amount of reinforcement used within a building element may be measured according to its weight. The actual size of the weight depends on the method of measurement used.
/// 
/// HISTORY  New entity in IFC2x. It replaces the calcXxx attributes used in previous IFC Releases.
class IFC_PARSE_API IfcQuantityWeight : public IfcPhysicalSimpleQuantity {
public:
    /// Mass measure value of this quantity.
    double WeightValue() const;
    void setWeightValue(double v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcQuantityWeight (IfcEntityInstanceData* e);
    IfcQuantityWeight (std::string v1_Name, boost::optional< std::string > v2_Description, ::Ifc2x3::IfcNamedUnit* v3_Unit, double v4_WeightValue);
    typedef IfcTemplatedEntityList< IfcQuantityWeight > list;
};

class IFC_PARSE_API IfcReferencesValueDocument : public IfcUtil::IfcBaseEntity {
public:
    ::Ifc2x3::IfcDocumentSelect* ReferencedDocument() const;
    void setReferencedDocument(::Ifc2x3::IfcDocumentSelect* v);
    IfcTemplatedEntityList< ::Ifc2x3::IfcAppliedValue >::ptr ReferencingValues() const;
    void setReferencingValues(IfcTemplatedEntityList< ::Ifc2x3::IfcAppliedValue >::ptr v);
    /// Whether the optional attribute Name is defined for this IfcReferencesValueDocument
    bool hasName() const;
    std::string Name() const;
    void setName(std::string v);
    /// Whether the optional attribute Description is defined for this IfcReferencesValueDocument
    bool hasDescription() const;
    std::string Description() const;
    void setDescription(std::string v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcReferencesValueDocument (IfcEntityInstanceData* e);
    IfcReferencesValueDocument (::Ifc2x3::IfcDocumentSelect* v1_ReferencedDocument, IfcTemplatedEntityList< ::Ifc2x3::IfcAppliedValue >::ptr v2_ReferencingValues, boost::optional< std::string > v3_Name, boost::optional< std::string > v4_Description);
    typedef IfcTemplatedEntityList< IfcReferencesValueDocument > list;
};
/// IfcReinforcementProperties defines the set of properties for a specific combination of reinforcement bar steel grade, bar type and effective depth. 
/// 
/// HISTORY  New entity in IFC2x2.
/// 
/// The total cross section area for the specific steel grade is always provided. Additionally also general reinforcing bar configurations as a count of bars may be provided as defined in attribute BarCount. In this case the nominal bar diameter should be identical for all given bars as defined in attribute NominalBarDiameter.
class IFC_PARSE_API IfcReinforcementBarProperties : public IfcUtil::IfcBaseEntity {
public:
    /// The total effective cross-section area of the reinforcement of a specific steel grade.
    double TotalCrossSectionArea() const;
    void setTotalCrossSectionArea(double v);
    /// The nominal steel grade defined according to local standards.
    std::string SteelGrade() const;
    void setSteelGrade(std::string v);
    /// Whether the optional attribute BarSurface is defined for this IfcReinforcementBarProperties
    bool hasBarSurface() const;
    /// Indicator for whether the bar surface is plain or textured.
    ::Ifc2x3::IfcReinforcingBarSurfaceEnum::Value BarSurface() const;
    void setBarSurface(::Ifc2x3::IfcReinforcingBarSurfaceEnum::Value v);
    /// Whether the optional attribute EffectiveDepth is defined for this IfcReinforcementBarProperties
    bool hasEffectiveDepth() const;
    /// The effective depth, i.e. the distance of the specific reinforcement cross section area or reinforcement configuration in a row, counted from a common specific reference point. Usually the reference point is the upper surface (for beams and slabs) or a similar projection in a plane (for columns).
    double EffectiveDepth() const;
    void setEffectiveDepth(double v);
    /// Whether the optional attribute NominalBarDiameter is defined for this IfcReinforcementBarProperties
    bool hasNominalBarDiameter() const;
    /// The nominal diameter defining the cross-section size of the reinforcing bar. The bar diameter should be identical for all bars included in the specific reinforcement configuration.
    double NominalBarDiameter() const;
    void setNominalBarDiameter(double v);
    /// Whether the optional attribute BarCount is defined for this IfcReinforcementBarProperties
    bool hasBarCount() const;
    /// The number of bars with identical nominal diameter and steel grade included in the specific reinforcement configuration.
    double BarCount() const;
    void setBarCount(double v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcReinforcementBarProperties (IfcEntityInstanceData* e);
    IfcReinforcementBarProperties (double v1_TotalCrossSectionArea, std::string v2_SteelGrade, boost::optional< ::Ifc2x3::IfcReinforcingBarSurfaceEnum::Value > v3_BarSurface, boost::optional< double > v4_EffectiveDepth, boost::optional< double > v5_NominalBarDiameter, boost::optional< double > v6_BarCount);
    typedef IfcTemplatedEntityList< IfcReinforcementBarProperties > list;
};

class IFC_PARSE_API IfcRelaxation : public IfcUtil::IfcBaseEntity {
public:
    double RelaxationValue() const;
    void setRelaxationValue(double v);
    double InitialStress() const;
    void setInitialStress(double v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcRelaxation (IfcEntityInstanceData* e);
    IfcRelaxation (double v1_RelaxationValue, double v2_InitialStress);
    typedef IfcTemplatedEntityList< IfcRelaxation > list;
};
/// Definition from ISO/CD 10303-43:1992: A
///   representation is one or more representation items that are
///   related in a specified representation context as the
///   representation of some concept.
/// 
/// IfcRepresentation
///   defines the general concept of representing product
///   properties.
/// 
/// Representation Use Definition
/// 
/// Each representation, either IfcShapeRepresentation, or
///   IfcTopologyRepresentation shall have a well defined:
/// 
/// ContextOfItems: Reference to an
///   IfcGeometricRepresentationContext as agreed for 
///   this representation.
/// 
/// RepresentationIdentifier: Name of the
///   representation, for example, 'Body' for 3D shape, 'FootPrint' for
///   2D ground view, 'Axis' for reference axis.
/// 
/// RepresentationType: Name for the geometric, or
///   topological representation type, for example, 'SweptSolid' for 3D
///   swept solids, 'Brep' for boundary representation.
/// 
/// Values and guidelines for these three items are provided in
///   the geometry use definition section at each subtype of
///   IfcElement, or in view definitions / implementer
///   agreements.
/// 
/// NOTE ÿThe definition of this
///   entity relates to the ISO 10303 entity representation. Please
///   refer to ISO/IS 10303-43:1994 for the final definition of
///   the formal standard.
/// 
/// HISTORY  New entity in IFC Release 2.0
/// 
/// IFC2x3 CHANGE  The
///   inverse attributes LayerAssignments
///   andRepresentationMap have been added with upward
///   compatibility.
/// 
/// IFC2x4 CHANGE  Entity
///   IfcRepresentation has been changed into an ABSTRACT
///   supertype.
class IFC_PARSE_API IfcRepresentation : public IfcUtil::IfcBaseEntity {
public:
    /// Definition of the representation context for which the different subtypes of representation are valid.
    ::Ifc2x3::IfcRepresentationContext* ContextOfItems() const;
    void setContextOfItems(::Ifc2x3::IfcRepresentationContext* v);
    /// Whether the optional attribute RepresentationIdentifier is defined for this IfcRepresentation
    bool hasRepresentationIdentifier() const;
    /// The optional identifier of the representation as used within a project.
    std::string RepresentationIdentifier() const;
    void setRepresentationIdentifier(std::string v);
    /// Whether the optional attribute RepresentationType is defined for this IfcRepresentation
    bool hasRepresentationType() const;
    /// The description of the type of a representation context. The representation type defines the type of geometry or topology used for representing the product representation. More information is given at the subtypes IfcShapeRepresentation and IfcTopologyRepresentation.
    /// The supported values for context type are to be specified by implementers agreements.
    std::string RepresentationType() const;
    void setRepresentationType(std::string v);
    /// Set of geometric representation items that are defined for this representation.
    IfcTemplatedEntityList< ::Ifc2x3::IfcRepresentationItem >::ptr Items() const;
    void setItems(IfcTemplatedEntityList< ::Ifc2x3::IfcRepresentationItem >::ptr v);
        IfcTemplatedEntityList< IfcRepresentationMap >::ptr RepresentationMap() const; // INVERSE IfcRepresentationMap::MappedRepresentation
    IfcTemplatedEntityList< IfcPresentationLayerAssignment >::ptr LayerAssignments() const; // INVERSE IfcPresentationLayerAssignment::AssignedItems
    IfcTemplatedEntityList< IfcProductRepresentation >::ptr OfProductRepresentation() const; // INVERSE IfcProductRepresentation::Representations
    virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcRepresentation (IfcEntityInstanceData* e);
    IfcRepresentation (::Ifc2x3::IfcRepresentationContext* v1_ContextOfItems, boost::optional< std::string > v2_RepresentationIdentifier, boost::optional< std::string > v3_RepresentationType, IfcTemplatedEntityList< ::Ifc2x3::IfcRepresentationItem >::ptr v4_Items);
    typedef IfcTemplatedEntityList< IfcRepresentation > list;
};
/// Definition from ISO/CD 10303-42:1992: A representation context is a context in which a set of representation items are related.
/// 
/// The IfcRepresentationContext defines the context to which the IfcRepresentation of a product is related.
/// 
/// NOTE  The definition of this class relates to the ISO 10303 entity representation_context. Please refer to ISO/IS 10303-43:1994 for the final definition of the formal standard.
/// 
/// HISTORY  New entity in IFC Release 1.5.
/// 
/// IFC2x4 CHANGE Entity made abstract, had been deprecated from instantiation since
/// IFC2x2.
class IFC_PARSE_API IfcRepresentationContext : public IfcUtil::IfcBaseEntity {
public:
    /// Whether the optional attribute ContextIdentifier is defined for this IfcRepresentationContext
    bool hasContextIdentifier() const;
    /// The optional identifier of the representation context as used within a project.
    std::string ContextIdentifier() const;
    void setContextIdentifier(std::string v);
    /// Whether the optional attribute ContextType is defined for this IfcRepresentationContext
    bool hasContextType() const;
    /// The description of the type of a representation context. The supported values for context type are to be specified by implementers agreements.
    std::string ContextType() const;
    void setContextType(std::string v);
        IfcTemplatedEntityList< IfcRepresentation >::ptr RepresentationsInContext() const; // INVERSE IfcRepresentation::ContextOfItems
    virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcRepresentationContext (IfcEntityInstanceData* e);
    IfcRepresentationContext (boost::optional< std::string > v1_ContextIdentifier, boost::optional< std::string > v2_ContextType);
    typedef IfcTemplatedEntityList< IfcRepresentationContext > list;
};
/// Definition from ISO/CD
/// 10303-43:1992: A representation item is an element of
/// product data that participates in one or more representations or
/// contributes to the definition of another representation item. A
/// representation item contributes to the definition of another
/// representation item when it is referenced by that representation
/// item.
/// 
/// NOTE  Corresponding entity in ISO 10303-43:1994: representation_item. Please refer to ISO/IS 10303-43:1994, for the final definition of the formal standard. The following changes have been made: The attribute 'name' and the WR1 have not been incorporated.
/// 
/// The IfcRepresentationItem is used within an IfcRepresentation (directly or indirectly through other IfcRepresentationItem's) to represent an IfcProductRepresentation. Most commonly these IfcRepresentationItem's are geometric or topological representation items, that can (but not need to) have presentation style infomation assigned.
/// 
/// NOTE  The assignment of a style is only applicable
/// to the subtypes IfcGeometricRepresentationItem, IfcMappedItem and some selected subtypes of IfcTopologicalRepresentationItem (IfcVertexPoint, IfcEdgeCurve, IfcFaceSurface).
/// 
/// In case that presentation style information is applied, it can be either applied by an IfcStyledItem, or by an assignment to an IfcPresentationLayerWithStyle. If both are present, and both style assignments include the same subtype of IfcPresentationStyle, then the style assigned by IfcStyledItem takes priority.
/// 
/// Figure 281 shows an instance diagram explaining the use of IfcStyledItem and IfcPresentationLayerWithStyle to apply presentation styles.
/// 
/// EXAMPLE  The assignment of style information by a styled item and a presentation layer with style. Since the presentation styles are different, IfcCurveStyle and IfcSurfaceStyle, both are applied to the geometric representation item.
/// 
/// Figure 281 — Representation item style
/// 
/// Figure 282 shows in instance diagram explaining the override of IfcPresentationLayerWithStyle by IfcStyledItem to apply presentation styles.
/// 
/// EXAMPLE  The assignment of style information by a styled item and a presentation layer with style. Since the presentation styles for curve style are aprovided by both, the IfcCurveStyle provided by the IfcStyledItem overrides the IfcCurveStyle provided by the IfcPresentationLayerWithStyle
/// 
/// Figure 282 — Representation item style override
/// 
/// HISTORY  New entity in IFC Release 2x.
/// 
/// IFC2x3 CHANGE  The inverse attributes StyledByItem and LayerAssignments have been added. Upward compatibility for file based exchange is guaranteed.
class IFC_PARSE_API IfcRepresentationItem : public IfcUtil::IfcBaseEntity {
public:
        IfcTemplatedEntityList< IfcPresentationLayerAssignment >::ptr LayerAssignments() const; // INVERSE IfcPresentationLayerAssignment::AssignedItems
    IfcTemplatedEntityList< IfcStyledItem >::ptr StyledByItem() const; // INVERSE IfcStyledItem::Item
    virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcRepresentationItem (IfcEntityInstanceData* e);
    IfcRepresentationItem ();
    typedef IfcTemplatedEntityList< IfcRepresentationItem > list;
};
/// Definition from ISO/CD 10303-43:1992: A representation map is the identification of a representation and a representation item in that representation for the purpose of mapping. The representation item defines the origin of the mapping. The representation map is used as the source of a mapping by a mapped item.
/// 
/// NOTE  Corresponding ISO 10303 entity: representation_map. Please refer to ISO/IS 10303-43:1994, for the final definition of the formal standard. The following changes have been made: The mapping_origin (MappingOrigin) is constrained to be of type axis2_placement (IfcAxis2Placement).
/// 
/// An IfcRepresentationMap defines the base definition (also referred to as block, cell or macro) called MappedRepresentation within the MappingOrigin. The MappingOrigin defines the coordinate system in which the MappedRepresentation is defined.
/// 
/// The RepresentationMap is used through an IfcMappeditem in one or several IfcShapeRepresentation's. An Cartesian transformation operator can be applied to transform the MappedRepresentation into the placement coordinate system of the shape representation. The transformation of the representation map is restricted to be a Cartesian transformation mapping (translation, rotation, mirroring and scaling).
/// 
/// NOTE  The definition of a mapping which is used to specify a new representation item comprises a representation map and a mapped item entity. Without both entities, the mapping is not fully defined. Two entities are specified to allow the same source representation to be mapped into multiple new representations.
/// 
/// HISTORY  New entity in IFC Release 2x.
class IFC_PARSE_API IfcRepresentationMap : public IfcUtil::IfcBaseEntity {
public:
    /// An axis2 placement that defines the position about which the mapped
    /// representation is mapped.
    ::Ifc2x3::IfcAxis2Placement* MappingOrigin() const;
    void setMappingOrigin(::Ifc2x3::IfcAxis2Placement* v);
    /// A representation that is mapped to at least one mapped item.
    ::Ifc2x3::IfcRepresentation* MappedRepresentation() const;
    void setMappedRepresentation(::Ifc2x3::IfcRepresentation* v);
        IfcTemplatedEntityList< IfcMappedItem >::ptr MapUsage() const; // INVERSE IfcMappedItem::MappingSource
    virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcRepresentationMap (IfcEntityInstanceData* e);
    IfcRepresentationMap (::Ifc2x3::IfcAxis2Placement* v1_MappingOrigin, ::Ifc2x3::IfcRepresentation* v2_MappedRepresentation);
    typedef IfcTemplatedEntityList< IfcRepresentationMap > list;
};

class IFC_PARSE_API IfcRibPlateProfileProperties : public IfcProfileProperties {
public:
    /// Whether the optional attribute Thickness is defined for this IfcRibPlateProfileProperties
    bool hasThickness() const;
    double Thickness() const;
    void setThickness(double v);
    /// Whether the optional attribute RibHeight is defined for this IfcRibPlateProfileProperties
    bool hasRibHeight() const;
    double RibHeight() const;
    void setRibHeight(double v);
    /// Whether the optional attribute RibWidth is defined for this IfcRibPlateProfileProperties
    bool hasRibWidth() const;
    double RibWidth() const;
    void setRibWidth(double v);
    /// Whether the optional attribute RibSpacing is defined for this IfcRibPlateProfileProperties
    bool hasRibSpacing() const;
    double RibSpacing() const;
    void setRibSpacing(double v);
    ::Ifc2x3::IfcRibPlateDirectionEnum::Value Direction() const;
    void setDirection(::Ifc2x3::IfcRibPlateDirectionEnum::Value v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcRibPlateProfileProperties (IfcEntityInstanceData* e);
    IfcRibPlateProfileProperties (boost::optional< std::string > v1_ProfileName, ::Ifc2x3::IfcProfileDef* v2_ProfileDefinition, boost::optional< double > v3_Thickness, boost::optional< double > v4_RibHeight, boost::optional< double > v5_RibWidth, boost::optional< double > v6_RibSpacing, ::Ifc2x3::IfcRibPlateDirectionEnum::Value v7_Direction);
    typedef IfcTemplatedEntityList< IfcRibPlateProfileProperties > list;
};
/// IfcRoot is the most abstract and root class for all IFC entity definitions that roots in the kernel or in subsequent layers of the IFC object model. It is therefore the common supertype of all IFC entities, beside those defined in an IFC resource schema. All entities that are subtypes of IfcRoot can be used independently, whereas resource schema entities, that are not subtypes of IfcRoot, are not supposed to be independent entities.
/// 
/// IfcRoot assigns the globally unique ID, and the ownership and history information to the entity. In addition it may provide for a name and a description about the concept.
/// 
/// NOTE View definitions and implementation agreement may impose additional restrictions on the use of the OwnerHistory to handle object versioning.
/// 
/// HISTORY New entity in IFC Release 1.0
/// 
/// IFC2x4 CHANGE The attribute OwnerHistory has been made OPTIONAL.
class IFC_PARSE_API IfcRoot : public IfcUtil::IfcBaseEntity {
public:
    /// Assignment of a globally unique identifier within the entire software world.
    std::string GlobalId() const;
    void setGlobalId(std::string v);
    /// Assignment of the information about the current ownership of that object, including owning actor, application, local identification and information captured about the recent changes of the object, 
    /// 
    /// NOTE only the last modification in stored - either as addition, deletion or modification.
    /// 
    /// IFC2x4 CHANGE  The attribute has been changed to be OPTIONAL.
    ::Ifc2x3::IfcOwnerHistory* OwnerHistory() const;
    void setOwnerHistory(::Ifc2x3::IfcOwnerHistory* v);
    /// Whether the optional attribute Name is defined for this IfcRoot
    bool hasName() const;
    /// Optional name for use by the participating software systems or users. For some subtypes of IfcRoot the insertion of the Name attribute may be required. This would be enforced by a where rule.
    std::string Name() const;
    void setName(std::string v);
    /// Whether the optional attribute Description is defined for this IfcRoot
    bool hasDescription() const;
    /// Optional description, provided for exchanging informative comments.
    std::string Description() const;
    void setDescription(std::string v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcRoot (IfcEntityInstanceData* e);
    IfcRoot (std::string v1_GlobalId, ::Ifc2x3::IfcOwnerHistory* v2_OwnerHistory, boost::optional< std::string > v3_Name, boost::optional< std::string > v4_Description);
    typedef IfcTemplatedEntityList< IfcRoot > list;
};
/// Definition from ISO/CD 10303-41:1992: An SI unit is the fixed quantity used as a standard in terms of which items are measured as defined by ISO 1000 (clause 2).
/// 
/// IfcSIUnit covers both standard base SI units such as meter and second, and derived SI units such as Pascal, square meter and cubic meter.
/// 
/// NOTE Corresponding ISO 10303 name: si_unit, please refer to ISO/IS 10303-41 for the final definition of the formal standard.
/// 
/// HISTORY New entity in IFC Release 1.5.1.
class IFC_PARSE_API IfcSIUnit : public IfcNamedUnit {
public:
    /// Whether the optional attribute Prefix is defined for this IfcSIUnit
    bool hasPrefix() const;
    /// The SI Prefix for defining decimal multiples and submultiples of the unit.
    ::Ifc2x3::IfcSIPrefix::Value Prefix() const;
    void setPrefix(::Ifc2x3::IfcSIPrefix::Value v);
    /// The word, or group of words, by which the SI unit is referred to.
    /// 
    /// NOTE  Even though the SI system's base unit for mass is kilogram, the IfcSIUnit for mass is gram if no Prefix is asserted.
    ::Ifc2x3::IfcSIUnitName::Value Name() const;
    void setName(::Ifc2x3::IfcSIUnitName::Value v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcSIUnit (IfcEntityInstanceData* e);
    IfcSIUnit (::Ifc2x3::IfcUnitEnum::Value v2_UnitType, boost::optional< ::Ifc2x3::IfcSIPrefix::Value > v3_Prefix, ::Ifc2x3::IfcSIUnitName::Value v4_Name);
    typedef IfcTemplatedEntityList< IfcSIUnit > list;
};
/// IfcSectionProperties defines the cross section properties for a single longitudinal piece of a cross section.  It is a special-purpose helper class for IfcSectionReinforcementProperties.
/// 
/// HISTORY  New entity in IFC2x2.
/// 
/// The section piece may be either uniform or tapered. In the latter case an end profile should also be provided. The start and end profiles are assumed to be of the same profile type. Generally only rectangular or circular cross section profiles are assumed to be used.
class IFC_PARSE_API IfcSectionProperties : public IfcUtil::IfcBaseEntity {
public:
    /// An indicator whether a specific piece of a cross section is uniform or tapered in longitudinal direction.
    ::Ifc2x3::IfcSectionTypeEnum::Value SectionType() const;
    void setSectionType(::Ifc2x3::IfcSectionTypeEnum::Value v);
    /// The cross section profile at the start point of the longitudinal section.
    ::Ifc2x3::IfcProfileDef* StartProfile() const;
    void setStartProfile(::Ifc2x3::IfcProfileDef* v);
    /// Whether the optional attribute EndProfile is defined for this IfcSectionProperties
    bool hasEndProfile() const;
    /// The cross section profile at the end point of the longitudinal section.
    ::Ifc2x3::IfcProfileDef* EndProfile() const;
    void setEndProfile(::Ifc2x3::IfcProfileDef* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcSectionProperties (IfcEntityInstanceData* e);
    IfcSectionProperties (::Ifc2x3::IfcSectionTypeEnum::Value v1_SectionType, ::Ifc2x3::IfcProfileDef* v2_StartProfile, ::Ifc2x3::IfcProfileDef* v3_EndProfile);
    typedef IfcTemplatedEntityList< IfcSectionProperties > list;
};
/// IfcSectionReinforcementProperties defines the cross section properties of reinforcement for a single longitudinal piece of a cross section with a specific reinforcement usage type.  
/// 
/// HISTORY  New entity in IFC2x2.
/// 
/// Several sets of cross section reinforcement properties represented by instances of IfcReinforcementProperties may be attached to the section reinforcement properties
/// (IfcReinforcementDefinitionProperties of IfcStructuralElementsDomain schema),
/// one for each combination of steel grades and reinforcement bar types and sizes.
class IFC_PARSE_API IfcSectionReinforcementProperties : public IfcUtil::IfcBaseEntity {
public:
    /// The start position in longitudinal direction for the section reinforcement properties.
    double LongitudinalStartPosition() const;
    void setLongitudinalStartPosition(double v);
    /// The end position in longitudinal direction for the section reinforcement properties.
    double LongitudinalEndPosition() const;
    void setLongitudinalEndPosition(double v);
    /// Whether the optional attribute TransversePosition is defined for this IfcSectionReinforcementProperties
    bool hasTransversePosition() const;
    /// The position for the section reinforcement properties in transverse direction.
    double TransversePosition() const;
    void setTransversePosition(double v);
    /// The role, purpose or usage of the reinforcement, i.e. the kind of loads and stresses it is intended to carry, defined for the section reinforcement properties.
    ::Ifc2x3::IfcReinforcingBarRoleEnum::Value ReinforcementRole() const;
    void setReinforcementRole(::Ifc2x3::IfcReinforcingBarRoleEnum::Value v);
    /// Definition of the cross section profile and longitudinal section type.
    ::Ifc2x3::IfcSectionProperties* SectionDefinition() const;
    void setSectionDefinition(::Ifc2x3::IfcSectionProperties* v);
    /// The set of reinforcment properties attached to a section reinforcement properties definition.
    IfcTemplatedEntityList< ::Ifc2x3::IfcReinforcementBarProperties >::ptr CrossSectionReinforcementDefinitions() const;
    void setCrossSectionReinforcementDefinitions(IfcTemplatedEntityList< ::Ifc2x3::IfcReinforcementBarProperties >::ptr v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcSectionReinforcementProperties (IfcEntityInstanceData* e);
    IfcSectionReinforcementProperties (double v1_LongitudinalStartPosition, double v2_LongitudinalEndPosition, boost::optional< double > v3_TransversePosition, ::Ifc2x3::IfcReinforcingBarRoleEnum::Value v4_ReinforcementRole, ::Ifc2x3::IfcSectionProperties* v5_SectionDefinition, IfcTemplatedEntityList< ::Ifc2x3::IfcReinforcementBarProperties >::ptr v6_CrossSectionReinforcementDefinitions);
    typedef IfcTemplatedEntityList< IfcSectionReinforcementProperties > list;
};
/// Definition from ISO/CD 10303-41:1992: The shape
///   aspect is an identifiable element of the shape of a
///   product.
/// 
/// IfcShapeAspect
///   allows for grouping of shape representation items that
///   represent aspects (or components) of the shape of a
///   product. Thereby shape representations of components of the
///   product shape represent a distinctive part to a product
///   that can be explicitly addressed.
/// 
/// NOTE ÿThe definition of
///   this class relates to the ISO 10303 entity shape_aspect. Please
///   refer to ISO/IS 10303-41:1994 for the final definition of
///   the formal standard.
/// 
/// HISTORY  New Entity in IFC Release 2.0
/// 
/// IFC 2x4 CHANGE  Attribute
///   PartOfProductDefinitionShape declared OPTIONAL with 
///   upward compatibility for file based exchange.
/// 
/// Informal propositions:
/// 
/// If ShapeRepresentations points to shape
///   representations that are part of an
///   IfcProductDefinitionShape,
///   PartOfProductDefinitionShape must refer to this
///   instance of IfcProductDefinitionShape.
/// 
/// NOTEÿ PartOfProductDefinitionShape is
///   only to be omitted if the shape representations are
///   attached to an IfcRepresentationMap. ÿThis
///   enables the use of IfcShapeAspect with
///   IfcRepresentationMap's that are used by an
///   IfcTypeProduct through the
///   RepresentationMaps attribute.
class IFC_PARSE_API IfcShapeAspect : public IfcUtil::IfcBaseEntity {
public:
    /// List of shape representations. Each member defines a valid representation of a particular type within a particular representation context as being an aspect (or part) of a product definition.
    /// IFC2x Edition 3 CHANGE  The data type has been changed from IfcShapeRepresentation to IfcShapeModel with upward compatibility
    IfcTemplatedEntityList< ::Ifc2x3::IfcShapeModel >::ptr ShapeRepresentations() const;
    void setShapeRepresentations(IfcTemplatedEntityList< ::Ifc2x3::IfcShapeModel >::ptr v);
    /// Whether the optional attribute Name is defined for this IfcShapeAspect
    bool hasName() const;
    /// The word or group of words by which the shape aspect is known. It is a tag to indicate the particular semantic of a component within the product definition shape, used to provide meaning. Example: use the tag "Glazing" to define which component of a window shape defines the glazing area.
    std::string Name() const;
    void setName(std::string v);
    /// Whether the optional attribute Description is defined for this IfcShapeAspect
    bool hasDescription() const;
    /// The word or group of words that characterize the shape aspect. It can be used to add additional meaning to the name of the aspect.
    std::string Description() const;
    void setDescription(std::string v);
    /// An indication that the shape aspect is on the physical boundary of the product definition shape. If the value of this attribute is TRUE, it shall be asserted that the shape aspect being identified is on such a boundary. If the value is FALSE, it shall be asserted that the shape aspect being identified is not on such a boundary. If the value is UNKNOWN, it shall be asserted that it is not known whether or not the shape aspect being identified is on such a boundary. 
    /// ---
    /// EXAMPLE: Would be FALSE for a center line, identified as shape aspect; would be TRUE for a cantilever.
    /// ---
    bool ProductDefinitional() const;
    void setProductDefinitional(bool v);
    /// Reference to the product definition shape of which this class is an aspect.
    ::Ifc2x3::IfcProductDefinitionShape* PartOfProductDefinitionShape() const;
    void setPartOfProductDefinitionShape(::Ifc2x3::IfcProductDefinitionShape* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcShapeAspect (IfcEntityInstanceData* e);
    IfcShapeAspect (IfcTemplatedEntityList< ::Ifc2x3::IfcShapeModel >::ptr v1_ShapeRepresentations, boost::optional< std::string > v2_Name, boost::optional< std::string > v3_Description, bool v4_ProductDefinitional, ::Ifc2x3::IfcProductDefinitionShape* v5_PartOfProductDefinitionShape);
    typedef IfcTemplatedEntityList< IfcShapeAspect > list;
};
/// IfcShapeModel represents
/// the concept of a particular geometric and/or topological
/// representation of a product's shape or a product component's shape
/// within a representation context. This representation context has to
/// be a geometric representation context (with the exception of
/// topology representations without associated geometry). The two
/// subtypes are IfcShapeRepresentation to cover geometric
/// models that represent a shape, and IfcTopologyRepresentation
/// to cover the conectivity of a product or product component. The
/// topology may or may not have geometry associated.
/// 
/// The IfcShapeModel can be a shape representation
/// (geometric and/or topologogical) of a product (via
/// IfcProductDefinitionShape), or a shape representation
/// (geometric and/or topologogical)  of a component of a product
/// shape (via IfcShapeAspect).
/// 
/// HISTORY  New entity in IFC2x3.
class IFC_PARSE_API IfcShapeModel : public IfcRepresentation {
public:
        IfcTemplatedEntityList< IfcShapeAspect >::ptr OfShapeAspect() const; // INVERSE IfcShapeAspect::ShapeRepresentations
    virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcShapeModel (IfcEntityInstanceData* e);
    IfcShapeModel (::Ifc2x3::IfcRepresentationContext* v1_ContextOfItems, boost::optional< std::string > v2_RepresentationIdentifier, boost::optional< std::string > v3_RepresentationType, IfcTemplatedEntityList< ::Ifc2x3::IfcRepresentationItem >::ptr v4_Items);
    typedef IfcTemplatedEntityList< IfcShapeModel > list;
};
/// The IfcShapeRepresentation represents the concept of a
/// particular geometric representation of a product or a product
/// component within a specific geometric representation context. The
/// inherited attribute RepresentationType is used to define
/// the geometric model used for the shape representation (for example, 
/// 'SweptSolid', or 'Brep'), the inherited attribute
/// RepresentationIdentifier is used to denote the part of the
/// representation captured by the IfcShapeRepresentation
/// (for example, 'Axis', 'Body').
/// 
/// Several representation identifiers for shape representation are
/// included as predefined values for RepresentationIdentifier:
/// 
/// Box
/// Bounding box as simplified 3D box
/// geometry of an element
/// 
/// Annotation
/// 2D annotations not representing
/// elements
/// 
/// Axis
/// 2D or 3D Axis, or single line,
/// representation of an element
/// 
/// FootPrint
/// 2D Foot print, or double line,
/// representation of an element, projected to ground view
/// 
/// Surface
/// 3D Surface representation, e.g. of an
/// analytical surface, of an elementplane)
/// 
/// Body
/// 3D Body representation, e.g. as
/// wireframe, surface, or solid model, of an element
/// 
/// Lighting
/// Representation of emitting light as a
/// light source within a shape representation
/// 
/// Several representation types for shape representation are
/// included as predefined values for RepresentationType:
/// 
/// Curve2D
/// 2 dimensional curve
/// 
/// Curve3D
/// 3 dimensional curve
/// 
/// Surface2D
/// 2 dimensional surface (a region on
/// ground view)
/// 
/// Surface3D
/// 3 dimensional surface
/// 
/// GeometricSet
/// points, curves, surfaces (2 or 3
/// dimensional)
/// 
/// GeometricCurveSet
/// points, curves (2 or 3
/// dimensional)
/// 
/// Annotation2D
/// points, curves (2 or 3 dimensional), hatches and text (2
/// dimensional)
/// 
/// SurfaceModel
/// face based and shell based surface
/// model
/// 
/// SolidModel
/// including swept solid, Boolean
/// results and Brep bodies
/// more specific types are:
/// 
/// SweptSolid
/// swept area solids, by extrusion and
/// revolution, excluding tapered sweeps
/// 
/// AdvancedSweptSolid
/// swept area solids created by sweeping
/// a profile along a directrix, and tapered sweeps
/// 
/// Brep
/// faceted Brep's with and without
/// voids
/// 
/// AdvancedBrep
/// Brep's based on advanced faces, with
/// b-spline surface geometry, with and without voids
/// 
/// CSG
/// Boolean results of operations between
/// solid models, half spaces and Boolean results
/// 
/// Clipping
/// Boolean differences between swept
/// area solids, half spaces and Boolean results
/// 
/// additional types
/// 
/// some additional representation types are provided:
/// 
/// BoundingBox
/// simplistic 3D representation by a
/// bounding box
/// 
/// SectionedSpine
/// cross section based representation of
/// a spine curve and planar cross sections. It can represent a surface
/// or a solid and the interpolations of the between the cross sections
/// is not defined
/// 
/// LightSource
/// light source with (depending on type)
/// position, orientation, light colour, intensity and attenuation
/// 
/// MappedRepresentation
/// representation based on mapped
/// item(s), referring to a representation map. Note: it can be seen as
/// an inserted block reference. The shape representation of the mapped
/// item has a representation type declaring the type of its
/// representation items.
/// 
/// Table 1: string values for the inherited attribute
/// 'RepresentationType'.
/// 
/// NOTE  The definition of this entity relates to the ISO 10303 entity shape_representation. Please refer to ISO/IS 10303-41:1994 for the final definition of the formal standard.
/// 
/// HISTORY  New entity in IFC Release 1.5.
/// 
/// IFC2x4 CHANGE  The RepresentationType's 'Curve3D', 'Surface2D', 'Surface3D', 'AdvancedBrep', 'LightSource', and the RepresentationIdentifier 'Lighting' have been added.
class IFC_PARSE_API IfcShapeRepresentation : public IfcShapeModel {
public:
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcShapeRepresentation (IfcEntityInstanceData* e);
    IfcShapeRepresentation (::Ifc2x3::IfcRepresentationContext* v1_ContextOfItems, boost::optional< std::string > v2_RepresentationIdentifier, boost::optional< std::string > v3_RepresentationType, IfcTemplatedEntityList< ::Ifc2x3::IfcRepresentationItem >::ptr v4_Items);
    typedef IfcTemplatedEntityList< IfcShapeRepresentation > list;
};
/// IfcSimpleProperty is a generalization of a single property object. The various subtypes of IfcSimpleProperty establish different ways in which a property value can be set. 
/// 
/// HISTORY  New Entity in IFC Release 1.0, definition changed in IFC Release 2x.
class IFC_PARSE_API IfcSimpleProperty : public IfcProperty {
public:
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcSimpleProperty (IfcEntityInstanceData* e);
    IfcSimpleProperty (std::string v1_Name, boost::optional< std::string > v2_Description);
    typedef IfcTemplatedEntityList< IfcSimpleProperty > list;
};
/// Definition from IAI: Describe more rarely needed connection properties.
/// 
/// HISTORY: New entity in IFC 2x2.
class IFC_PARSE_API IfcStructuralConnectionCondition : public IfcUtil::IfcBaseEntity {
public:
    /// Whether the optional attribute Name is defined for this IfcStructuralConnectionCondition
    bool hasName() const;
    /// Optionally defines a name for this connection condition.
    std::string Name() const;
    void setName(std::string v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcStructuralConnectionCondition (IfcEntityInstanceData* e);
    IfcStructuralConnectionCondition (boost::optional< std::string > v1_Name);
    typedef IfcTemplatedEntityList< IfcStructuralConnectionCondition > list;
};
/// Definition from IAI: The abstract entity IfcStructuralLoadOrResult is the supertype of all loads (actions or reactions) or of certain requirements resulting from structural analysis, or certain provisions which influence structural analysis.
/// 
/// HISTORY: New entity in IFC 2x2.
class IFC_PARSE_API IfcStructuralLoad : public IfcUtil::IfcBaseEntity {
public:
    /// Whether the optional attribute Name is defined for this IfcStructuralLoad
    bool hasName() const;
    /// Optionally defines a name for this load.
    std::string Name() const;
    void setName(std::string v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcStructuralLoad (IfcEntityInstanceData* e);
    IfcStructuralLoad (boost::optional< std::string > v1_Name);
    typedef IfcTemplatedEntityList< IfcStructuralLoad > list;
};
/// Definition from IAI: The abstract entity IfcStructuralLoadStatic is the supertype of all static loads (actions or reactions) which can be defined.  Within scope are single i.e. concentrated forces and moments, linear i.e. one-dimensionally distributed forces and moments, planar i.e. two-dimensionally distributed forces, furthermore displacements and temperature loads.
/// 
/// HISTORY: New entity in IFC 2x2.
class IFC_PARSE_API IfcStructuralLoadStatic : public IfcStructuralLoad {
public:
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcStructuralLoadStatic (IfcEntityInstanceData* e);
    IfcStructuralLoadStatic (boost::optional< std::string > v1_Name);
    typedef IfcTemplatedEntityList< IfcStructuralLoadStatic > list;
};
/// An instance of the entity IfcStructuralLoadTemperature shall be used to define actions which are caused by a temperature change. As shown in Figure 332, the change of temperature is given with a constant value which is applied to the complete section and values for temperature differences between outer fibres of the section.
/// 
/// HISTORY  New entity in IFC2x2. 
/// 
/// Figure 332 — Structural load temperature
class IFC_PARSE_API IfcStructuralLoadTemperature : public IfcStructuralLoadStatic {
public:
    /// Whether the optional attribute DeltaT_Constant is defined for this IfcStructuralLoadTemperature
    bool hasDeltaT_Constant() const;
    double DeltaT_Constant() const;
    void setDeltaT_Constant(double v);
    /// Whether the optional attribute DeltaT_Y is defined for this IfcStructuralLoadTemperature
    bool hasDeltaT_Y() const;
    double DeltaT_Y() const;
    void setDeltaT_Y(double v);
    /// Whether the optional attribute DeltaT_Z is defined for this IfcStructuralLoadTemperature
    bool hasDeltaT_Z() const;
    double DeltaT_Z() const;
    void setDeltaT_Z(double v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcStructuralLoadTemperature (IfcEntityInstanceData* e);
    IfcStructuralLoadTemperature (boost::optional< std::string > v1_Name, boost::optional< double > v2_DeltaT_Constant, boost::optional< double > v3_DeltaT_Y, boost::optional< double > v4_DeltaT_Z);
    typedef IfcTemplatedEntityList< IfcStructuralLoadTemperature > list;
};
/// IfcStyleModel represents the concept of a particular presentation style defined for a material (or other characteristic) of a product or a product component within a representation context. This representation context may (but has not to be) a geometric representation context.
/// 
/// IfcStyleModel can be a style representation (presentation style) of a material (via IfcMaterialDefinitionRepresentation), potentially differentiated for different representation contexts (for example, different material hatching depending on the scale of the target representation context).
/// 
/// HISTORY  New entity in IFC2x3.
class IFC_PARSE_API IfcStyleModel : public IfcRepresentation {
public:
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcStyleModel (IfcEntityInstanceData* e);
    IfcStyleModel (::Ifc2x3::IfcRepresentationContext* v1_ContextOfItems, boost::optional< std::string > v2_RepresentationIdentifier, boost::optional< std::string > v3_RepresentationType, IfcTemplatedEntityList< ::Ifc2x3::IfcRepresentationItem >::ptr v4_Items);
    typedef IfcTemplatedEntityList< IfcStyleModel > list;
};
/// Definition from ISO/CD 10303-46:1992: The styled item is an assignment of style for presentation to a geometric representation item as it is used in a representation.
/// 
/// NOTE  Corresponding ISO 10303 name: styled_item. Please refer to ISO/IS 10303-46:1994 for the final definition of the formal standard.
/// 
/// The IfcStyledItem holds presentation style information for products, either explicitly for an IfcGeometricRepresentationItem being part of an IfcShapeRepresentation assigned to a product, or by assigning presentation information to IfcMaterial being assigned as other representation for a product.
/// 
/// If the IfcStyledItem is used within a reference from an IfcProductDefinitionShape then one Item shall be provided.
/// If the IfcStyledItem is used within a reference from an IfcMaterialDefinitionRepresentation then no Item shall be provided.
/// 
/// HISTORY  New entity in IFC2x2.
/// 
/// IFC2x2 Addendum 1 CHANGE  The entity IfcStyledItem has been made non abstract and the attribute Name added.
/// 
/// IFC2x3 CHANGE The attribute Item has been made optional, upward compatibility for file
/// based exchange is guaranteed.
/// 
/// IFC2x4 CHANGE The subtype IfcAnnotationOccurrence and its subtypes are deleted. Use IfcStyledItem for all instantiations. The data type of Styles has been changed to IfcStyleAssignmentSelect
/// 
/// Use Definition
/// 
/// Figure 293 illustrates use of IfcStyledItem for the two usage examples:
/// 
/// As a presentation for a geometric representation item
/// As a presentation for a material definition
/// 
/// NOTE  The new IfcStyleAssignmentSelect allows the direct assignment styles, such as IfcCurveStyle, IfcSurfaceStyle without using the intermediate IfcPresentationStyleAssignment
/// 
/// Figure 293 — Styled item
class IFC_PARSE_API IfcStyledItem : public IfcRepresentationItem {
public:
    /// Whether the optional attribute Item is defined for this IfcStyledItem
    bool hasItem() const;
    /// A geometric representation item to which the style is assigned.
    /// 
    /// IFC2x Edition 2 Addendum 2 CHANGE The attribute Item has been made optional. Upward compatibility for file based exchange is guaranteed.
    ::Ifc2x3::IfcRepresentationItem* Item() const;
    void setItem(::Ifc2x3::IfcRepresentationItem* v);
    /// Representation styles which are assigned, either to an geometric representation item, or to a material definition.
    /// 
    /// IFC2x4 CHANGE  The data type has been changed to IfcStyleAssignmentSelect with upward compatibility 
    /// for file based exchange.
    /// 
    /// NOTE  Only the select item IfcPresentationStyle shall be used from IFC2x4 onwards, the IfcPresentationStyleAssignment has been deprecated.
    IfcTemplatedEntityList< ::Ifc2x3::IfcPresentationStyleAssignment >::ptr Styles() const;
    void setStyles(IfcTemplatedEntityList< ::Ifc2x3::IfcPresentationStyleAssignment >::ptr v);
    /// Whether the optional attribute Name is defined for this IfcStyledItem
    bool hasName() const;
    /// The word, or group of words, by which the styled item is referred to.
    std::string Name() const;
    void setName(std::string v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcStyledItem (IfcEntityInstanceData* e);
    IfcStyledItem (::Ifc2x3::IfcRepresentationItem* v1_Item, IfcTemplatedEntityList< ::Ifc2x3::IfcPresentationStyleAssignment >::ptr v2_Styles, boost::optional< std::string > v3_Name);
    typedef IfcTemplatedEntityList< IfcStyledItem > list;
};
/// The IfcStyledRepresentation represents the concept of a styled presentation being a representation of a product or a product component, like material. within a representation context. This representation context does not need to be (but may be) a geometric representation context.
/// 
/// NOTE  Current usage of IfcStyledRepresentation is restricted to the assignment of presentation information to an material. The IfcStyledRepresentation includes only presentation styles (IfcCurveStyle, FillAreaStyle, IfcSurfaceStyle) that define how a material should be presented within a particular (eventually view and scale dependent) representation context. All instances of IfcStyledRepresentation are referenced by IfcMaterialDefinitionRepresentation, and assigned to IfcMaterial by IfcMaterialDefinitionRepresentation.RepresentedMaterial.
/// 
/// A styled representation has to include one or several styled items with the associated style information (curve, symbol, text, fill area, or surface styles). It shall not contain the geometric representation items that are styled.
/// 
/// HISTORY  New entity in IFC2x2.
class IFC_PARSE_API IfcStyledRepresentation : public IfcStyleModel {
public:
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcStyledRepresentation (IfcEntityInstanceData* e);
    IfcStyledRepresentation (::Ifc2x3::IfcRepresentationContext* v1_ContextOfItems, boost::optional< std::string > v2_RepresentationIdentifier, boost::optional< std::string > v3_RepresentationType, IfcTemplatedEntityList< ::Ifc2x3::IfcRepresentationItem >::ptr v4_Items);
    typedef IfcTemplatedEntityList< IfcStyledRepresentation > list;
};
/// IfcSurfaceStyle is an assignment of one or many surface style elements to a surface, defined by subtypes of IfcSurface, IfcFaceBasedSurfaceModel, IfcShellBasedSurfaceModel, or by subtypes of IfcSolidModel. The positive direction of the surface normal relates to the positive side. In case of solids the outside of the solid is to be taken as positive side. 
/// 
/// NOTE: The surface style is often referred to as material definition in rendering applications.
/// 
/// NOTE Corresponding ISO 10303 entity: surface_style_usage and surface_side_style. Please refer to ISO/IS 10303-46:1994 for the final definition of the formal standard. The surface style definition in regard to support of rendering has been greatly expanded beyond the scope of ISO/IS 10303-46.
/// 
/// HISTORY New Entity in IFC 2.x.
class IFC_PARSE_API IfcSurfaceStyle : public IfcPresentationStyle {
public:
    /// An indication of which side of the surface to apply the style.
    ::Ifc2x3::IfcSurfaceSide::Value Side() const;
    void setSide(::Ifc2x3::IfcSurfaceSide::Value v);
    /// A collection of different surface styles.
    IfcEntityList::ptr Styles() const;
    void setStyles(IfcEntityList::ptr v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcSurfaceStyle (IfcEntityInstanceData* e);
    IfcSurfaceStyle (boost::optional< std::string > v1_Name, ::Ifc2x3::IfcSurfaceSide::Value v2_Side, IfcEntityList::ptr v3_Styles);
    typedef IfcTemplatedEntityList< IfcSurfaceStyle > list;
};
/// IfcSurfaceStyleLighting is a container class for properties for calculation of physically exact illuminance related to a particular surface style.
/// 
/// Figure 294 shows the reflection and transmission components from an incident ray. The sum of the components for reflection and transmission is a value of 1.0 denoting that the incident ray is completely decomposed into reflection and transmission components. Each value of reflection and transmission is therefore within the range 0.0 to 1.0. 
/// 
/// Figure 294 — Surface style lighting
/// 
/// All these factors can be measured physically and are ratios for the red, green and blue part of the light. These properties are defined in the model as Type IfcColorRGB with a factor for each colour. 
/// 
/// EXAMPLE  A green glass transmits only green light, so its transmission factor is 0.0 for red, between 0.0 and 1.0 for green and 0.0 for blue. A green surface reflects only green light, so the reflectance factor is 0.0 for red, between 0.0 and 1.0 for green and 0.0 for blue.
/// 
/// HISTORY  New entity in IFC 2x2.
class IFC_PARSE_API IfcSurfaceStyleLighting : public IfcUtil::IfcBaseEntity {
public:
    /// The degree of diffusion of the transmitted light. In the case of completely transparent materials there is no diffusion. The greater the diffusing power, the smaller the direct component of the transmitted light, up to the point where only diffuse light is produced.A value of 1 means totally diffuse for that colour part of the light.
    /// The factor can be measured physically and has three ratios for the red, green and blue part of the light.
    ::Ifc2x3::IfcColourRgb* DiffuseTransmissionColour() const;
    void setDiffuseTransmissionColour(::Ifc2x3::IfcColourRgb* v);
    /// The degree of diffusion of the reflected light. In the case of specular surfaces there is no diffusion. The greater the diffusing power of the reflecting surface, the smaller the specular component of the reflected light, up to the point where only diffuse light is produced. A value of 1 means totally diffuse for that colour part of the light. 
    /// The factor can be measured physically and has three ratios for the red, green and blue part of the light.
    ::Ifc2x3::IfcColourRgb* DiffuseReflectionColour() const;
    void setDiffuseReflectionColour(::Ifc2x3::IfcColourRgb* v);
    /// Describes how the light falling on a body is totally or partially transmitted. 
    /// The factor can be measured physically and has three ratios for the red, green and blue part of the light.
    ::Ifc2x3::IfcColourRgb* TransmissionColour() const;
    void setTransmissionColour(::Ifc2x3::IfcColourRgb* v);
    /// A coefficient that determines the extent that the light falling onto a surface is fully or partially reflected. 
    /// The factor can be measured physically and has three ratios for the red, green and blue part of the light.
    ::Ifc2x3::IfcColourRgb* ReflectanceColour() const;
    void setReflectanceColour(::Ifc2x3::IfcColourRgb* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcSurfaceStyleLighting (IfcEntityInstanceData* e);
    IfcSurfaceStyleLighting (::Ifc2x3::IfcColourRgb* v1_DiffuseTransmissionColour, ::Ifc2x3::IfcColourRgb* v2_DiffuseReflectionColour, ::Ifc2x3::IfcColourRgb* v3_TransmissionColour, ::Ifc2x3::IfcColourRgb* v4_ReflectanceColour);
    typedef IfcTemplatedEntityList< IfcSurfaceStyleLighting > list;
};
/// IfcSurfaceStyleRefraction extends the surface style lighting, or the surface style rendering definition for properties for calculation of physically exact illuminance by adding seldomly used properties. Currently this includes the refraction index (by which the light ray refracts when passing through a prism) and the dispersion factor (or Abbe constant) which takes into account the wavelength dependency of the refraction.
/// 
/// NOTE: If such refraction properties are used, the IfcSurfaceStyle should include within its set of Styles (depending on whether rendering or lighting is used) an instance of IfcSurfaceStyleLighting and IfcSurfaceStyleRefraction, or an instance of IfcSurfaceStyleRendering and IfcSurfaceStyleRefraction.
/// 
/// HISTORY: New entity in IFC 2x2.
class IFC_PARSE_API IfcSurfaceStyleRefraction : public IfcUtil::IfcBaseEntity {
public:
    /// Whether the optional attribute RefractionIndex is defined for this IfcSurfaceStyleRefraction
    bool hasRefractionIndex() const;
    /// The index of refraction for all wave lengths of light. The refraction index is the ratio between the speed of light in a vacuum and the speed of light in the medium. E.g. glass has a refraction index of 1.5, whereas water has an index of 1.33
    double RefractionIndex() const;
    void setRefractionIndex(double v);
    /// Whether the optional attribute DispersionFactor is defined for this IfcSurfaceStyleRefraction
    bool hasDispersionFactor() const;
    /// The Abbe constant given as a fixed ratio between the refractive indices of the material at different wavelengths. A low Abbe number means a high dispersive power. In general this translates to a greater angular spread of the emergent spectrum.
    double DispersionFactor() const;
    void setDispersionFactor(double v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcSurfaceStyleRefraction (IfcEntityInstanceData* e);
    IfcSurfaceStyleRefraction (boost::optional< double > v1_RefractionIndex, boost::optional< double > v2_DispersionFactor);
    typedef IfcTemplatedEntityList< IfcSurfaceStyleRefraction > list;
};
/// Definition from ISO/CD 10303-46:1992: The surface style rendering allows the realistic visualization of surfaces referring to rendering techniques based on the laws of physics and mathematics. 
/// 
/// The entity IfcSurfaceStyleShading allows for colour information used for shading, whereas subtypes provide data for more sophisticated rendering techniques. The surface colour is used for colouring or simple shading of the assigned surfaces. 
/// 
/// NOTE Corresponding ISO 10303 entity: surface_style_rendering. Please refer to ISO/IS 10303-46:1994 for the final definition of the formal standard. No rendering method is defined for each surface style (such as constant, colour, dot or normal shading), therefore the attribute rendering_method has been omitted.
/// 
/// HISTORY: New entity in IFC 2x.
class IFC_PARSE_API IfcSurfaceStyleShading : public IfcUtil::IfcBaseEntity {
public:
    /// The colour used to render the surface. The surface colour for visualisation is defined by specifying the intensity of red, green and blue.
    ::Ifc2x3::IfcColourRgb* SurfaceColour() const;
    void setSurfaceColour(::Ifc2x3::IfcColourRgb* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcSurfaceStyleShading (IfcEntityInstanceData* e);
    IfcSurfaceStyleShading (::Ifc2x3::IfcColourRgb* v1_SurfaceColour);
    typedef IfcTemplatedEntityList< IfcSurfaceStyleShading > list;
};
/// The entity IfcSurfaceStyleWithTextures allows to include image textures in surface styles. These image textures can be applied repeating across the surface or mapped with a particular scale upon the surface.
/// 
/// The entity IfcSurfaceStyleWithTextures is part of the surface style table for presentation information assigned to surfaces for shading, rendering and lighting with textures. The mapping of the texture onto the surface or the solid is determined by the texture coordinates, in absense of an IfcTextureCoordinate assigned to each surface texture, a default mapping of the texture to the geometric face or surface applies.
/// 
/// Surface textures included in the IfcSurfaceStyleWithTextures are two dimensional map formats. They define 2D images that contain an array of colour values describing the texture. Depending on the number of IfcSurfaceTextures being included in the list of Textures the IfcSurfaceStyleWithTextures either describes a single texture, or a multi texture.
/// 
/// single texture: a single surface texture is applied to the styled geometric item (entirely or partly) with optional repetition and texture transformation
/// multi texture: two or more surface textures are applied to the styled geometric item (entirely or partly) with optional repetition, texture transformation or texture coordinate mapping being specific for each texture.
/// 
/// Informal proposition
/// 
/// Only one instance of IfcSurfaceStyleWithTextures shall be referenced by an IfcStyledItem and be assigned to an IfcGeometricRepresentationItem
/// 
/// NOTE  The definitions of texturing within this standard have been developed in dependence on the texture component of X3D. See ISO/IEC 19775-1.2:2008 X3D Architecture and base components Edition 2, Part 1, 18 Texturing component for the definitions in the international standard.
/// 
/// HISTORY  New entity in IFC2x2.
/// 
/// IFC2x3 CHANGE  inverse attribute HasTextureCoordinates deleted.
class IFC_PARSE_API IfcSurfaceStyleWithTextures : public IfcUtil::IfcBaseEntity {
public:
    /// The textures applied to the surface. In case of more than one surface texture is included, the IfcSurfaceStyleWithTexture defines a multi texture.
    IfcTemplatedEntityList< ::Ifc2x3::IfcSurfaceTexture >::ptr Textures() const;
    void setTextures(IfcTemplatedEntityList< ::Ifc2x3::IfcSurfaceTexture >::ptr v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcSurfaceStyleWithTextures (IfcEntityInstanceData* e);
    IfcSurfaceStyleWithTextures (IfcTemplatedEntityList< ::Ifc2x3::IfcSurfaceTexture >::ptr v1_Textures);
    typedef IfcTemplatedEntityList< IfcSurfaceStyleWithTextures > list;
};
/// An IfcSurfaceTexture provides a 2-dimensional
/// image-based texture map. It can either be given by referencing an
/// external image file through an URL reference
/// (IfcImageTexture), including the image file as a blob
/// (long binary) into the data set (IfcBlobTexture), or by
/// explicitly including an array of pixels
/// (IfcPixelTexture).
/// The following definitions from ISO/IEC 19775-1 X3D Architecture
/// and base components (X3D Specification)
/// apply:
/// 
/// Texture: An image
/// used in a texture map to create visual appearance effects when
/// applied to geometry nodes.
/// Texture map: A
/// texture plus the general parameters necessary for mapping the
/// texture to geometry.
/// 
/// Texture are defined by 2D images that contain an array of colour
/// values describing the texture. The texture values are interpreted
/// differently depending on the number of components in the texture
/// and the specifics of the image format. In general, texture may be
/// described using one of the following forms:
/// 
/// Intensity textures (one-component)
/// Intensity plus alpha opacity textures (two-component)
/// Full RGB textures (three-component)
/// Full RGB plus alpha opacity textures (four-component)
/// 
/// NOTE  Image formats specify an alpha opacity, not transparency (where alpha = 1 - transparency).
/// 
/// Figure 295 illustrates the texture coordinate system.
/// 
/// Figure 295 — Surface texture coordinates
/// 
/// The following definitions from ISO/IEC 19775-1 X3D Architecture and base components (X3D Specification) on texture coordinates apply:
/// 
/// Texture maps are defined in a 2D coordinate system (s, t) that ranges from [0.0, 1.0] in both directions. The bottom edge of the image corresponds to the S-axis of the texture map, and left edge of the image corresponds to the T-axis of the texture map. The lower-left pixel of the image corresponds to s=0, t=0, and the top-right pixel of the image corresponds to s=1, t=1. Texture maps may be viewed as two dimensional colour functions that, given an (s, t) coordinate, return a colour value colour(s, t).
/// 
/// If multiple surface textures are included in the
/// IfcSurfaceStyleWithTextures applying them to a geometric
/// item, a mode and optional parameters can be included that blending
/// operations.
/// The RepeatS and RepeatT Boolean flags control
/// whether the texture map is repeated outside the [0.0, 1.0] texture
/// coordinate range, when applied to a geometric surface, or clamped
/// to lie within the [0.0, 1.0] range. The TextureTransform
/// applies a 2D non-uniform transformation to the texture before it is
/// applied to a geometric surface.
/// The following definitions from ISO/IEC 19775-1 X3D Architecture
/// and base components (X3D Specification)
/// apply:
/// 
/// These parameters
/// support changes to the size, orientation, and position of textures
/// on shapes. Note that these operations appear reversed when viewed
/// on the surface of geometry. For example, a scale value of (2
/// 2) will scale the texture coordinates and have the net effect of
/// shrinking the texture size by a factor of 2 (texture coordinates
/// are twice as large and thus cause the texture to repeat). A
/// translation of (0.5 0.0) translates the texture coordinates +.5
/// units along the S-axis and has the net effect of translating the
/// texture −0.5 along the S-axis on the geometry's surface. A
/// rotation of π/2 of the texture coordinates results in a
/// −π/2 rotation of the texture on the geometry.
/// The center
/// field specifies a translation offset in texture coordinate space
/// about which the rotation and scale fields are
/// applied. The scale field specifies a scaling factor in S and
/// T of the texture coordinates about the center point.
/// scale values shall be in the range (−∞,∞).
/// The rotation field specifies a rotation in radians of the
/// texture coordinates about the center point after the scale
/// has been applied. A positive rotation value makes the texture
/// coordinates rotate counterclockwise about the centre, thereby
/// rotating the appearance of the texture itself clockwise. The
/// translation field specifies a translation of the texture
/// coordinates.
/// The following conventions
/// apply:
/// 
/// center =
/// TextureTransform.LocalOrigin;
/// rotation = TextureTransform.Axis1
/// scale S = TextureTransform.Scale
/// scale T = TextureTransform.Scale2
/// 
/// NOTE  The definitions of texturing within this standard have been developed in dependence on the texture component of X3D. See ISO/IEC 19775-1.2:2008 X3D Architecture and base components Edition 2, Part 1, 18 Texturing component for the definitions in the international standard.
/// 
/// HISTORY  New entity in IFC 2x2.
/// 
/// IFC2x4 CHANGE  Attribute TextureType replaces by Mode, attributes Parameter and MapsTo aded, new inverse attribute UsedInStyle.
class IFC_PARSE_API IfcSurfaceTexture : public IfcUtil::IfcBaseEntity {
public:
    /// The RepeatS field specifies how the texture wraps in the S direction. If RepeatS is TRUE (the default), the texture map is repeated outside the [0.0, 1.0] texture coordinate range in the S direction so that it fills the shape. If RepeatS is FALSE, the texture coordinates are clamped in the S direction to lie within the [0.0, 1.0] range.
    bool RepeatS() const;
    void setRepeatS(bool v);
    /// The RepeatT field specifies how the texture wraps in the T direction. If RepeatT is TRUE (the default), the texture map is repeated outside the [0.0, 1.0] texture coordinate range in the T direction so that it fills the shape. If RepeatT is FALSE, the texture coordinates are clamped in the T direction to lie within the [0.0, 1.0] range.
    bool RepeatT() const;
    void setRepeatT(bool v);
    ::Ifc2x3::IfcSurfaceTextureEnum::Value TextureType() const;
    void setTextureType(::Ifc2x3::IfcSurfaceTextureEnum::Value v);
    /// Whether the optional attribute TextureTransform is defined for this IfcSurfaceTexture
    bool hasTextureTransform() const;
    /// The TextureTransform defines a 2D transformation that is applied to the texture coordinates. It affects the way texture coordinates are applied to the surfaces of geometric representation itesm. The 2D transformation supports changes to the size, orientation, and position of textures on shapes. 
    /// 
    /// Mirroring is not allowed to be used in the IfcCarteesianTransformationOperator
    ::Ifc2x3::IfcCartesianTransformationOperator2D* TextureTransform() const;
    void setTextureTransform(::Ifc2x3::IfcCartesianTransformationOperator2D* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcSurfaceTexture (IfcEntityInstanceData* e);
    IfcSurfaceTexture (bool v1_RepeatS, bool v2_RepeatT, ::Ifc2x3::IfcSurfaceTextureEnum::Value v3_TextureType, ::Ifc2x3::IfcCartesianTransformationOperator2D* v4_TextureTransform);
    typedef IfcTemplatedEntityList< IfcSurfaceTexture > list;
};
/// Definition from ISO/CD 10303-46:1992: The symbol style is the presentation style that indicates the presentation of annotation symbols. 
/// 
/// NOTE: Corresponding ISO 10303 name: symbol_style. Please refer to ISO/IS 10303-46:1994, p. 124 for the final definition of the formal standard.
/// 
/// HISTORY: New entity in Release IFC2x2.
class IFC_PARSE_API IfcSymbolStyle : public IfcPresentationStyle {
public:
    /// The style applied to the symbol for its visual appearance.
    ::Ifc2x3::IfcSymbolStyleSelect* StyleOfSymbol() const;
    void setStyleOfSymbol(::Ifc2x3::IfcSymbolStyleSelect* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcSymbolStyle (IfcEntityInstanceData* e);
    IfcSymbolStyle (boost::optional< std::string > v1_Name, ::Ifc2x3::IfcSymbolStyleSelect* v2_StyleOfSymbol);
    typedef IfcTemplatedEntityList< IfcSymbolStyle > list;
};
/// An IfcTable is a data structure for the provision of information in the form of rows and columns. Each instance may have IfcTableColumn instances that define the name, description and units for each column. The rows of information are stored as a list of IfcTableRow objects. 
/// 
/// Limitation: For backwards compatibility, the rows of an IfcTable object are constrained to have the same number of cells. The first Row of the table provides the number of cells. All other rows are forced to include the same number of cells. This is enforced by the WR2. 
/// 
/// Figure 335 illustrates table use.
/// 
/// Figure 335 — Table use
/// 
/// Figure 336 depicts how tables were structured prior to IFC2x4.
/// 
/// Figure 336 — Table use alternative
/// 
/// HISTORY  New entity in IFC R1.5.
/// 
/// IFC2x4 CHANGE  Columns attribute added.
class IFC_PARSE_API IfcTable : public IfcUtil::IfcBaseEntity {
public:
    /// A unique name which is intended to describe the usage of the Table.
    std::string Name() const;
    void setName(std::string v);
    /// Reference to information content of rows.
    IfcTemplatedEntityList< ::Ifc2x3::IfcTableRow >::ptr Rows() const;
    void setRows(IfcTemplatedEntityList< ::Ifc2x3::IfcTableRow >::ptr v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcTable (IfcEntityInstanceData* e);
    IfcTable (std::string v1_Name, IfcTemplatedEntityList< ::Ifc2x3::IfcTableRow >::ptr v2_Rows);
    typedef IfcTemplatedEntityList< IfcTable > list;
};
/// IfcTableRow contains data for a single row within an IfcTable. 
/// 
/// Limitation: For backward compatibility, all IfcTableRow objects referenced by an IfcTable shall have the same number of Row Cells. The actual number of Cells shall be taken from the number of cells of the first IfcTableRow for that table. The number of Cells is calculated by the derived attribute NumberOfCellsInRow in the associated IfcTable. 
/// 
/// Figure 337 illustrates table row use.
/// 
/// Figure 337 — Table row use
/// 
/// Figure 338 depicts how table rows were structured prior to IFC2x4 with the use of the IsHeading flag. Note that the use of the IfcTableColumn constructs should be used instead of the IsHeading flag (which remains for backward compatibility only): 
/// 
/// Figure 338 — Table row use alternative
/// 
/// HISTORY  New entity in IFC R1.5.
class IFC_PARSE_API IfcTableRow : public IfcUtil::IfcBaseEntity {
public:
    /// The data value of the table cell..
    IfcEntityList::ptr RowCells() const;
    void setRowCells(IfcEntityList::ptr v);
    /// Flag which identifies if the row is a heading row or a row which contains row values. NOTE - If the row is a heading, the flag takes the value = TRUE.
    bool IsHeading() const;
    void setIsHeading(bool v);
        IfcTemplatedEntityList< IfcTable >::ptr OfTable() const; // INVERSE IfcTable::Rows
    virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcTableRow (IfcEntityInstanceData* e);
    IfcTableRow (IfcEntityList::ptr v1_RowCells, bool v2_IsHeading);
    typedef IfcTemplatedEntityList< IfcTableRow > list;
};
/// Definition: Address to which telephone, electronic mail and other forms of telecommunications should be addressed.
/// 
/// HISTORY New entity in IFC Release 2x.
/// 
/// IFC 2x4 change:  Added attribute MessagingIDs.
/// Type of attribute WWWHomePageURL compatibly changed from IfcLabel to IfcURIReference.
class IFC_PARSE_API IfcTelecomAddress : public IfcAddress {
public:
    /// Whether the optional attribute TelephoneNumbers is defined for this IfcTelecomAddress
    bool hasTelephoneNumbers() const;
    /// The list of telephone numbers at which telephone messages may be received.
    std::vector< std::string > /*[1:?]*/ TelephoneNumbers() const;
    void setTelephoneNumbers(std::vector< std::string > /*[1:?]*/ v);
    /// Whether the optional attribute FacsimileNumbers is defined for this IfcTelecomAddress
    bool hasFacsimileNumbers() const;
    /// The list of fax numbers at which fax messages may be received.
    std::vector< std::string > /*[1:?]*/ FacsimileNumbers() const;
    void setFacsimileNumbers(std::vector< std::string > /*[1:?]*/ v);
    /// Whether the optional attribute PagerNumber is defined for this IfcTelecomAddress
    bool hasPagerNumber() const;
    /// The pager number at which paging messages may be received.
    std::string PagerNumber() const;
    void setPagerNumber(std::string v);
    /// Whether the optional attribute ElectronicMailAddresses is defined for this IfcTelecomAddress
    bool hasElectronicMailAddresses() const;
    /// The list of Email addresses at which Email messages may be received.
    std::vector< std::string > /*[1:?]*/ ElectronicMailAddresses() const;
    void setElectronicMailAddresses(std::vector< std::string > /*[1:?]*/ v);
    /// Whether the optional attribute WWWHomePageURL is defined for this IfcTelecomAddress
    bool hasWWWHomePageURL() const;
    /// The world wide web address at which the preliminary page of information for the person or organization can be located.
    /// NOTE: Information on the world wide web for a person or organization may be separated 
    /// into a number of pages and across a number of host sites, all of which may be linked together. It is assumed that 
    /// all such information may be referenced from a single page that is termed the home page for that person or organization.
    std::string WWWHomePageURL() const;
    void setWWWHomePageURL(std::string v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcTelecomAddress (IfcEntityInstanceData* e);
    IfcTelecomAddress (boost::optional< ::Ifc2x3::IfcAddressTypeEnum::Value > v1_Purpose, boost::optional< std::string > v2_Description, boost::optional< std::string > v3_UserDefinedPurpose, boost::optional< std::vector< std::string > /*[1:?]*/ > v4_TelephoneNumbers, boost::optional< std::vector< std::string > /*[1:?]*/ > v5_FacsimileNumbers, boost::optional< std::string > v6_PagerNumber, boost::optional< std::vector< std::string > /*[1:?]*/ > v7_ElectronicMailAddresses, boost::optional< std::string > v8_WWWHomePageURL);
    typedef IfcTemplatedEntityList< IfcTelecomAddress > list;
};
/// Definition from ISO/CD 10303-46:1992: The text style is a presentation style for annotation text.
/// 
/// The IfcTextStyle provides the text style table for presentation information assigned to text literals. The style is defined by color, text font characteristics, and text box characteristics. The definitions are based upon:
/// 
/// definitions from ISO/IS 10303-46:1994 for (old) vector based and monospace text.
///   definitions from Cascading Style Sheets, level 1, W3C Recommendation 17 Dec 1996, revised 11 Jan 1999, CSS1, for all true type text. The use of the CSS1 definitions is the preferred way to represent text styles.
/// 
/// An IfcTextStyle, when representing (old) vector based and monospace text, is instantiated with:
/// 
/// TextCharacterAppearance:: IfcTextStyleForDefinedFont (with BackgroundColour = NIL)
///   TextStyle:: IfcTextStyleWithBoxCharacteristics
///   TextFontStyle:: IfcDraughtingPreDefinedTextFont or IfcExternallyDefinedTextFont
/// 
/// An IfcTextStyle, when representing (new) true type text, based on CSS1 definitions, is instantiated with:
/// 
/// TextCharacterAppearance:: IfcTextStyleForDefinedFont
///   TextStyle:: IfcTextStyleTextModel
///   TextFontStyle:: IfcTextStyleFontModel
/// 
/// An IfcTextStyle can be assigned to IfcTextLiteral via the IfcPresentationStyleAssignment through an intermediate IfcAnnotationTextOccurrence.
/// 
/// NOTE  Corresponding ISO 10303 name: text_style. Please refer to ISO/IS 10303-46:1994 for the final definition of the formal standard. In order to avoid ANDOR subtype relationships, the IfcTextBlockStyleSelect has been introduced that allows the combination of a text style as having box characteristic, and/or having spacing, or having none of those additional properties.
/// 
/// NOTE  Corresponding CSS1 definitions are: Font properties (font-family, font-style, font-variant, font-weight, font-size), Color and background properties (color, background-color) and Text properties (word-spacing, letter-spacing, text-decoration, text-transform, text-align, text-indent, line-height).
/// 
/// HISTORY  New entity in IFC2x2.
/// 
/// IFC2x3 CHANGE  The IfcTextStyle has been changed by adding TextFontStyle and different data types for TextStyle and IfcCharacterStyleSelect.
class IFC_PARSE_API IfcTextStyle : public IfcPresentationStyle {
public:
    /// Whether the optional attribute TextCharacterAppearance is defined for this IfcTextStyle
    bool hasTextCharacterAppearance() const;
    /// A character style to be used for presented text.
    ::Ifc2x3::IfcCharacterStyleSelect* TextCharacterAppearance() const;
    void setTextCharacterAppearance(::Ifc2x3::IfcCharacterStyleSelect* v);
    /// Whether the optional attribute TextStyle is defined for this IfcTextStyle
    bool hasTextStyle() const;
    /// The style applied to the text block for its visual appearance.
    /// It defines the text block characteristics, either for vector based or monospace text fonts (see select item IfcTextStyleWithBoxCharacteristics), or for true type text fonts (see select item IfcTextStyleTextModel.
    /// 
    /// IFC2x Edition 3 CHANGE  The attribute TextBlockStyle has been changed from SET[1:?] to a non-aggregated optional, it has been renamed from TextStyles.
    ::Ifc2x3::IfcTextStyleSelect* TextStyle() const;
    void setTextStyle(::Ifc2x3::IfcTextStyleSelect* v);
    /// The style applied to the text font for its visual appearance.
    /// It defines the font family, font style, weight and size.
    /// 
    /// IFC2x Edition 2 Addendum 2 CHANGE The attribute TextFontStyle is a new attribute attached to IfcTextStyle.
    ::Ifc2x3::IfcTextFontSelect* TextFontStyle() const;
    void setTextFontStyle(::Ifc2x3::IfcTextFontSelect* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcTextStyle (IfcEntityInstanceData* e);
    IfcTextStyle (boost::optional< std::string > v1_Name, ::Ifc2x3::IfcCharacterStyleSelect* v2_TextCharacterAppearance, ::Ifc2x3::IfcTextStyleSelect* v3_TextStyle, ::Ifc2x3::IfcTextFontSelect* v4_TextFontStyle);
    typedef IfcTemplatedEntityList< IfcTextStyle > list;
};
/// Definition from CSS1 (W3C Recommendation): Setting font properties will be among the most common uses of style sheets. Unfortunately, there exists no well-defined and universally accepted taxonomy for classifying fonts, and terms that apply to one font family may not be appropriate for others. For example, 'italic' is commonly used to label slanted text, but slanted text may also be labeled as being Oblique, Slanted, Incline, Cursive or Kursiv. Therefore it is not a simple problem to map typical font selection properties to a specific font.
/// 
/// Font matching
/// Because there is no accepted, universal taxonomy of font properties, matching of properties to font faces must be done carefully. The properties are matched in a well-defined order to ensure that the results of this matching process are as consistent as possible across user agents (assuming that the same library of font faces is presented to each of them).
/// 
/// The user agent makes (or
/// accesses) a database of relevant CSS1
/// properties of all the fonts of which the UA is aware. The UA may be
/// aware of a font because it has been installed locally or it has been
/// previously downloaded over the web. If there are two fonts with
/// exactly the same properties, one of them is ignored. 
///   At a given element and for
/// each character in that element, the UA
/// assembles the font-properties applicable to that element. Using the
/// complete set of properties, the UA uses the 'font-family' property to
/// choose a tentative font family. The remaining properties are tested
/// against the family according to the matching criteria described with
/// each property. If there are matches for all the remaining properties,
/// then that is the matching font face for the given element. 
///   If there is no matching font
/// face within the 'font-family' being
/// processed by step 2, and if there is a next alternative 'font-family'
/// in the font set, then repeat step 2 with the next alternative
/// 'font-family'. 
///   If there is a matching font
/// face, but it doesn't contain a glyph
/// for the current character, and if there is a next alternative
/// 'font-family' in the font sets, then repeat step 2 with the next
/// alternative 'font-family'.  
///   If there is no font within
/// the family selected in 2, then use a
/// UA-dependent default 'font-family' and repeat step 2, using the best
/// match that can be obtained within the default font. 
/// 
/// (The above algorithm can be
/// optimized to avoid having to revisit
/// the CSS1 properties for each character.)
/// 
/// The per-property matching rules
/// from (2) above are as follows:
/// 
/// 'font-style' is tried first.
/// 'italic'
/// will be satisfied if there is either a face in the UA's font database
/// labeled with the CSS keyword 'italic' (preferred) or 'oblique'.
/// Otherwise the values must be matched exactly or font-style will fail. 
///   'font-variant' is tried
/// next. 'normal'
/// matches a font not labeled as 'small-caps'; 'small-caps' matches (1) a
/// font labeled as 'small-caps', (2) a font in which the small caps are
/// synthesized, or (3) a font where all lowercase letters are replaced by
/// upper case letters. A small-caps font may be synthesized by
/// electronically scaling uppercase letters from a normal font. 
///   'font-weight' is matched next, it will never fail. (See 'font-weight' below.) 
///   'font-size' must be matched within a
/// UA-dependent margin of tolerance. (Typically, sizes for scalable fonts
/// are rounded to the nearest whole pixel, while the tolerance for
/// bitmapped fonts could be as large as 20%.) Further computations, are
/// based on the 'font-size' value that is used, not the one that is specified.
/// 
/// The inherited Name attribute is used to define the font name, particularly in cases, where no (list of) font families are provided. 
/// 
/// NOTE  Corresponding CSS1 definitions are Font properties ('font-family', 'font-style', 'font-variant',  'font-weight').
/// 
/// HISTORY  New entity in IFC2x3.
class IFC_PARSE_API IfcTextStyleFontModel : public IfcPreDefinedTextFont {
public:
    /// Whether the optional attribute FontFamily is defined for this IfcTextStyleFontModel
    bool hasFontFamily() const;
    /// The value is a prioritized list of font family names and/or generic family names. The first list entry has the highest priority, if this font fails, the next list item shall be used. The last list item should (if possible) be a generic family.
    std::vector< std::string > /*[1:?]*/ FontFamily() const;
    void setFontFamily(std::vector< std::string > /*[1:?]*/ v);
    /// Whether the optional attribute FontStyle is defined for this IfcTextStyleFontModel
    bool hasFontStyle() const;
    /// The font style property selects between normal (sometimes referred to as "roman" or "upright"), italic and oblique faces within a font family.
    std::string FontStyle() const;
    void setFontStyle(std::string v);
    /// Whether the optional attribute FontVariant is defined for this IfcTextStyleFontModel
    bool hasFontVariant() const;
    /// The font variant property selects between normal and small-caps.
    ///   NOTE  It has been introduced for later compliance to full CSS1 support.
    std::string FontVariant() const;
    void setFontVariant(std::string v);
    /// Whether the optional attribute FontWeight is defined for this IfcTextStyleFontModel
    bool hasFontWeight() const;
    /// The font weight property selects the weight of the font.
    ///   NOTE  Values other then 'normal' and 'bold' have been introduced for later compliance to full CSS1 support.
    std::string FontWeight() const;
    void setFontWeight(std::string v);
    /// The font size provides the size or height of the text font.
    ///   NOTE  The following values are allowed, <IfcLengthMeasure, with positive values, the length unit is globally defined at IfcUnitAssignment.
    ::Ifc2x3::IfcSizeSelect* FontSize() const;
    void setFontSize(::Ifc2x3::IfcSizeSelect* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcTextStyleFontModel (IfcEntityInstanceData* e);
    IfcTextStyleFontModel (std::string v1_Name, boost::optional< std::vector< std::string > /*[1:?]*/ > v2_FontFamily, boost::optional< std::string > v3_FontStyle, boost::optional< std::string > v4_FontVariant, boost::optional< std::string > v5_FontWeight, ::Ifc2x3::IfcSizeSelect* v6_FontSize);
    typedef IfcTemplatedEntityList< IfcTextStyleFontModel > list;
};
/// Definition from ISO/CD 10303-46:1992: A text style for defined font is a character glyph style for pre-defined or externally defined text fonts.
/// 
/// Definition from CSS1 (W3C Recommendation): These properties describe the color (often called foreground color) and background of an element (i.e. the surface onto which the content is rendered). One can set a background color.
/// 
/// NOTE  The CSS1 definition allows also for a background image. This has not been incorporated into IFC.
/// 
/// The IfcTextStyleForDefinedFont combines the text font color with an optional background color, that fills the text box, defined by the planar extent given to the text literal.
/// 
/// NOTE  Corresponding ISO 10303 name: text_style_for_defined_font. Please refer to ISO/IS
/// 10303-46:1994, p.122 for the final definition of the formal standard. The attribute BackgroundColour
/// has been added.
/// 
/// NOTE  Corresponding CSS1 definitions are Color and background properties (color, background-color).
/// 
/// HISTORY  New entity in IFC2x3.
/// 
/// IFC2x3 CHANGE  The IfcTextStyleForDefinedFont has been added and replaces IfcColour at the IfcCharacterStyleSelect.
class IFC_PARSE_API IfcTextStyleForDefinedFont : public IfcUtil::IfcBaseEntity {
public:
    /// This property describes the text color of an element (often referred to as the foreground color).
    ::Ifc2x3::IfcColour* Colour() const;
    void setColour(::Ifc2x3::IfcColour* v);
    /// Whether the optional attribute BackgroundColour is defined for this IfcTextStyleForDefinedFont
    bool hasBackgroundColour() const;
    /// This property sets the background color of an element.
    ::Ifc2x3::IfcColour* BackgroundColour() const;
    void setBackgroundColour(::Ifc2x3::IfcColour* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcTextStyleForDefinedFont (IfcEntityInstanceData* e);
    IfcTextStyleForDefinedFont (::Ifc2x3::IfcColour* v1_Colour, ::Ifc2x3::IfcColour* v2_BackgroundColour);
    typedef IfcTemplatedEntityList< IfcTextStyleForDefinedFont > list;
};
/// Definition from CSS1 (W3C Recommendation): The properties defined in the text model affect the visual presentation of characters, spaces, words, and paragraphs.
/// 
/// The IfcTextStyleTextModel combines all text style properties, that affect the presentation of a text literal within a given extent. It includes the spacing between characters and words, the horizontal and vertical alignment of the text within the planar box of the extent, decorations (like underline), transformations of the literal (like uppercase), and the height of each text line within a multi-line text block.
/// 
/// NOTE  Corresponding CSS1 definitions are Text properties (word-spacing, letter-spacing, text-decoration, vertical-align, text-transform, text-align, text-indent, line-height).
/// 
/// HISTORY  New entity in IFC2x3.
class IFC_PARSE_API IfcTextStyleTextModel : public IfcUtil::IfcBaseEntity {
public:
    /// Whether the optional attribute TextIndent is defined for this IfcTextStyleTextModel
    bool hasTextIndent() const;
    /// The property specifies the indentation that appears before the first formatted line.
    ///   NOTE  It has been introduced for later compliance to full CSS1 support.
    ::Ifc2x3::IfcSizeSelect* TextIndent() const;
    void setTextIndent(::Ifc2x3::IfcSizeSelect* v);
    /// Whether the optional attribute TextAlign is defined for this IfcTextStyleTextModel
    bool hasTextAlign() const;
    /// This property describes how text is aligned horizontally within the element. The actual justification algorithm used is dependent on the rendering algorithm.
    std::string TextAlign() const;
    void setTextAlign(std::string v);
    /// Whether the optional attribute TextDecoration is defined for this IfcTextStyleTextModel
    bool hasTextDecoration() const;
    /// This property describes decorations that are added to the text of an element.
    std::string TextDecoration() const;
    void setTextDecoration(std::string v);
    /// Whether the optional attribute LetterSpacing is defined for this IfcTextStyleTextModel
    bool hasLetterSpacing() const;
    /// The length unit indicates an addition to the default space between characters. Values can be negative, but there may be implementation-specific limits. The user agent is free to select the exact spacing algorithm. The letter spacing may also be influenced by justification (which is a value of the 'align' property).
    ///   NOTE  The following values are allowed, IfcDescriptiveMeasure with value='normal', or IfcLengthMeasure, the length unit is globally defined at IfcUnitAssignment.
    ::Ifc2x3::IfcSizeSelect* LetterSpacing() const;
    void setLetterSpacing(::Ifc2x3::IfcSizeSelect* v);
    /// Whether the optional attribute WordSpacing is defined for this IfcTextStyleTextModel
    bool hasWordSpacing() const;
    /// The length unit indicates an addition to the default space between words. Values can be negative, but there may be implementation-specific limits. The user agent is free to select the exact spacing algorithm. The word spacing may also be influenced by justification (which is a value of the 'text-align' property).
    ///   NOTE  It has been introduced for later compliance to full CSS1 support.
    ::Ifc2x3::IfcSizeSelect* WordSpacing() const;
    void setWordSpacing(::Ifc2x3::IfcSizeSelect* v);
    /// Whether the optional attribute TextTransform is defined for this IfcTextStyleTextModel
    bool hasTextTransform() const;
    /// This property describes how text characters may transform to upper case, lower case, or capitalized case, independent of the character case used in the text literal.
    ///   NOTE  It has been introduced for later compliance to full CSS1 support.
    std::string TextTransform() const;
    void setTextTransform(std::string v);
    /// Whether the optional attribute LineHeight is defined for this IfcTextStyleTextModel
    bool hasLineHeight() const;
    /// The property sets the distance between two adjacent lines' baselines.
    /// When a ratio value is specified, the line height is given by the font size of the current element multiplied with the numerical value. A value of 'normal' sets the line height to a reasonable value for the element's font. It is suggested that user agents set the 'normal' value to be a ratio number in the range of 1.0 to 1.2.
    ///   NOTE  The following values are allowed: IfcDescriptiveMeasure with value='normal', or 
    /// IfcLengthMeasure, with non-negative values, the length unit is globally defined at IfcUnitAssignment, or IfcRatioMeasure.
    ::Ifc2x3::IfcSizeSelect* LineHeight() const;
    void setLineHeight(::Ifc2x3::IfcSizeSelect* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcTextStyleTextModel (IfcEntityInstanceData* e);
    IfcTextStyleTextModel (::Ifc2x3::IfcSizeSelect* v1_TextIndent, boost::optional< std::string > v2_TextAlign, boost::optional< std::string > v3_TextDecoration, ::Ifc2x3::IfcSizeSelect* v4_LetterSpacing, ::Ifc2x3::IfcSizeSelect* v5_WordSpacing, boost::optional< std::string > v6_TextTransform, ::Ifc2x3::IfcSizeSelect* v7_LineHeight);
    typedef IfcTemplatedEntityList< IfcTextStyleTextModel > list;
};
/// The text style with box characteristics allows the presentation of annotated text by specifying the characteristics of the character boxes of the text and the spacing between the character boxes.
/// 
/// NOTE  The IfcTextStyleWithBoxCharacteristics is an entity that had been adopted from ISO 10303, Industrial automation systems and integration—Product data representation and exchange, Part 46: Integrated generic resources: Visual presentation.
/// 
/// The IfcTextStyleWithBoxCharacteristics is mainly used to provide some compatibility with ISO10303. Its usage is restricted to monospace text fonts (having uniform character boxes) and simple vector based text fonts. For true text fonts however the use of IfcTextStyleTextModel is required.
/// 
/// Figure 296 (from ISO 10303-46, page 91) illustrates angles.  Figure 297 illustrates attribute use.
/// 
/// Figure 296 — Text style box angles
///   Figure 297 — Text style box attributes
/// 
/// NOTE  Corresponding ISO 10303 name: text_style_with_box_characteristics. Please refer to ISO/IS 10303-46:1994, p. 123 for the final definition of the formal standard. The four optional attributes BoxHeight, BoxWidth, BoxSlantAngle, BoxRotateAngle are included directly at the entity, and are not handled through the box_characteristic_select selecting box_height, box_width, box_slant_angle, box_rotate_angle, each being defined types. 
/// The CharacterSpacing attribute has been added from ISO/IS 10303-46:1994 entity text_style_with_spacing.
/// 
/// HISTORY  New entity in IFC2x2.
/// 
/// IFC2x3 CHANGE  The attribute item CharacterSpacing has been added.
class IFC_PARSE_API IfcTextStyleWithBoxCharacteristics : public IfcUtil::IfcBaseEntity {
public:
    /// Whether the optional attribute BoxHeight is defined for this IfcTextStyleWithBoxCharacteristics
    bool hasBoxHeight() const;
    /// It is the height scaling factor in the definition of a character glyph.
    double BoxHeight() const;
    void setBoxHeight(double v);
    /// Whether the optional attribute BoxWidth is defined for this IfcTextStyleWithBoxCharacteristics
    bool hasBoxWidth() const;
    /// It is the width scaling factor in the definition of a character glyph.
    double BoxWidth() const;
    void setBoxWidth(double v);
    /// Whether the optional attribute BoxSlantAngle is defined for this IfcTextStyleWithBoxCharacteristics
    bool hasBoxSlantAngle() const;
    /// It indicated that the box of a character glyph shall be represented as a parallelogram, with the angle being between the character up line and an axis perpendicular to the character base line.
    double BoxSlantAngle() const;
    void setBoxSlantAngle(double v);
    /// Whether the optional attribute BoxRotateAngle is defined for this IfcTextStyleWithBoxCharacteristics
    bool hasBoxRotateAngle() const;
    /// It indicated that the box of a character glyph shall be presented at an angle to the base line of a text string within which the glyph occurs, the angle being that between the base line of the glyph and an axis perpendicular to the baseline of the text string.
    double BoxRotateAngle() const;
    void setBoxRotateAngle(double v);
    /// Whether the optional attribute CharacterSpacing is defined for this IfcTextStyleWithBoxCharacteristics
    bool hasCharacterSpacing() const;
    /// The distance between the character boxes of adjacent characters.
    ::Ifc2x3::IfcSizeSelect* CharacterSpacing() const;
    void setCharacterSpacing(::Ifc2x3::IfcSizeSelect* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcTextStyleWithBoxCharacteristics (IfcEntityInstanceData* e);
    IfcTextStyleWithBoxCharacteristics (boost::optional< double > v1_BoxHeight, boost::optional< double > v2_BoxWidth, boost::optional< double > v3_BoxSlantAngle, boost::optional< double > v4_BoxRotateAngle, ::Ifc2x3::IfcSizeSelect* v5_CharacterSpacing);
    typedef IfcTemplatedEntityList< IfcTextStyleWithBoxCharacteristics > list;
};
/// The IfcTextureCoordinate a an abstract supertype of the different kinds to apply texture coordinates to geometries. For vertex based geometries an explicit assignment of 2D texture vertices to the 3D geometry points is supported by the subtype IfcTextureMap, in addition there can be a procedural description of how texture coordinates shall be applied to geometric items. If no IfcTextureCoordinate is provided for the IfcSurfaceTexture, the default mapping shall be used.
/// 
/// See relevant subtypes of IfcGeometricRepresentationItem for default texture mapping description.
/// 
/// NOTE  The definitions of texturing within this standard have been developed in dependence on the texture component of X3D. See ISO/IEC 19775-1.2:2008 X3D Architecture and base components Edition 2, Part 1, 18 Texturing component for the definitions in the international standard.
/// 
/// HISTORY  New entity in IFC2x2.
/// 
/// IFC2x3 CHANGE  The attribute Texture is deleted.
/// 
/// IFC2x4 CHANGE  The inverse attribute AnnotatedSurface is deleted, and the inverse AppliesTextures is added.
class IFC_PARSE_API IfcTextureCoordinate : public IfcUtil::IfcBaseEntity {
public:
        IfcTemplatedEntityList< IfcAnnotationSurface >::ptr AnnotatedSurface() const; // INVERSE IfcAnnotationSurface::TextureCoordinates
    virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcTextureCoordinate (IfcEntityInstanceData* e);
    IfcTextureCoordinate ();
    typedef IfcTemplatedEntityList< IfcTextureCoordinate > list;
};
/// The IfcTextureCoordinateGenerator describes a procedurally defined mapping function with input parameter to map 2D texture coordinates to 3D geometry vertices. The allowable Mode values and input Parameter need to be agreed upon in view definitions and implementer agreements.
/// 
/// It is recommended to use the texture coordinate generation modes as defined in X3D.
/// 
/// The following definitions from ISO/IEC 19775-1 X3D Architecture and base components (X3D Specification) apply:
/// 
/// The TextureCoordinateGenerator supports the automatic generation of texture coordinates for geometric shapes.
/// The mode field describes the algorithm used to compute texture coordinates.
/// 
/// SPHERE,
/// CAMERASPACENORMAL,
/// CAMERASPACEPOSITION,
/// CAMERASPACEREFLECTIONVECTOR,
/// SPHERE-LOCAL,
/// COORD,
/// COORD-EYE,
/// NOISE,
/// NOISE-EYE,
/// SPHERE-REFLECT,
/// SPHERE-REFLECT-LOCAL
/// 
/// NOTE  The definitions of texturing within this standard have been developed in dependence on the texture component of X3D. See ISO/IEC 19775-1.2:2008 X3D Architecture and base components Edition 2, Part 1, 18 Texturing component for the definitions in the international standard.
/// 
/// HISTORY New entity in IFC2x2.
/// 
/// IFC2x2 Addendum 2 CHANGE  The attribute Texturehas been deleted.
class IFC_PARSE_API IfcTextureCoordinateGenerator : public IfcTextureCoordinate {
public:
    /// The Mode attribute describes the algorithm used to compute texture coordinates.
    /// 
    /// NOTE  The applicable values for the Mode attribute are determined by view definitions or implementer agreements. It is recommended to use the modes described in ISO/IES 19775-1.2:2008 X3D Architecture and base components Edition 2, Part 1. See 18.4.8 TextureCoordinateGenerator for recommended values.
    std::string Mode() const;
    void setMode(std::string v);
    /// The parameters used as arguments by the function as specified by Mode.
    /// 
    /// IFC2x4 CHANGE  Made optional data type restricted to REAL.
    IfcEntityList::ptr Parameter() const;
    void setParameter(IfcEntityList::ptr v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcTextureCoordinateGenerator (IfcEntityInstanceData* e);
    IfcTextureCoordinateGenerator (std::string v1_Mode, IfcEntityList::ptr v2_Parameter);
    typedef IfcTemplatedEntityList< IfcTextureCoordinateGenerator > list;
};
/// An IfcTextureMap provides the mapping of the
/// 2-dimensional texture coordinates to the surface onto which it is
/// mapped. It is used for mapping the texture to surfaces of vertex
/// based geometry models, such as
/// 
/// IfcFacetedBrep
/// IfcFacetedBrepWithVoids
/// IfcFaceBasedSurfaceModel
/// IfcShellBasedSurfaceModel
/// 
/// The IfcTextureMap has a list of TextureVertex,
/// that corresponds to the points of the face bound of the vertex
/// based geometry item. The corresponding pair of lists is:
/// 
/// the list of Polygon of type IfcCartesianPoint,
/// and
/// the list of Vertices of type
/// IfcTextureVertex.
/// 
/// Each IfcTextureVertex (given as S, T coordinates of the
/// 2-dimension texture coordinate system) corresponds to the geometric
/// coordinates of the IfcCartesianPoint (given as 3-dimension
/// X, Y, and Z coordinates within the object coordinate system of the
/// geometric item).
/// The following definitions from ISO/IEC 19775-1 X3D Architecture
/// and base components (X3D Specification)
/// apply:
/// 
/// The TextureCoordinate node is a geometry property node that
/// specifies a set of 2D texture coordinates used by vertex-based
/// geometry nodes to map textures to vertices.
/// 
/// NOTE  In contrary to the
/// X3D vertext based geometry, for example IndexedFaceSet and
/// ElevationGrid, the vertext based geometry in IFC may include inner
/// loops. The areas of inner loops have to be cut-out from the texture
/// applied to the outer loop.
/// 
/// Figure 301 illustrates applying a texture map to a vertex based geometry.
/// 
/// Figure 301 — Texture map
/// 
/// HISTORY  New entity in IFC2x2.
/// 
/// IFC2x3 CHANGE  The attribute Texture is deleted, and the attribute TextureMaps is added.
/// 
/// IFC2x4 CHANGE  The attribute TextureMap is replaced by Vertices, and the attribute AppliedTo is added.
/// 
/// Informal propositions:
/// 
/// The FaceBound referenced in AppliedTo shall be used by the vertex based geometry, to which this texture map is assigned to by through the IfcStyledItem.
class IFC_PARSE_API IfcTextureMap : public IfcTextureCoordinate {
public:
    IfcTemplatedEntityList< ::Ifc2x3::IfcVertexBasedTextureMap >::ptr TextureMaps() const;
    void setTextureMaps(IfcTemplatedEntityList< ::Ifc2x3::IfcVertexBasedTextureMap >::ptr v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcTextureMap (IfcEntityInstanceData* e);
    IfcTextureMap (IfcTemplatedEntityList< ::Ifc2x3::IfcVertexBasedTextureMap >::ptr v1_TextureMaps);
    typedef IfcTemplatedEntityList< IfcTextureMap > list;
};
/// An IfcTextureVertex is a list of 2 (S, T) texture coordinates. 
/// 
/// The following additional definitions from ISO 19775 apply:
/// 
/// Each vertex-based geometry node uses a set of 2D texture
/// coordinates that map textures to vertices. Texture map values (
/// ImageTexture, PixelTexture) range from [0.0, 1.0] along the S-axis and
/// T-axis. However, texture coordinate values may be in the range
/// (-∞,∞). Texture coordinates identify a location
/// (and thus a
/// colour value) in the texture map. The horizontal coordinate S is
/// specified first, followed by the vertical coordinate T. If the texture
/// map is repeated in a given direction (S-axis or T-axis), a texture
/// coordinate C (s or t) is mapped into a texture map that has N pixels in
/// the given direction as follows: 
/// 
/// Texture map location = (C - floor(C)) × N			 
/// 
/// If the texture map is not
/// repeated, the texture coordinates are
/// clamped to the 0.0 to 1.0 range as follows: 
/// 
/// Texture map location = N,     if C > 1.0,                     = 0.0,   if C < 0.0,                     = C × N, if 0.0 ≤ C ≤ 1.0.
/// 
/// Texture coordinates may be transformed (scaled, rotated, translated) by supplying a TextureTransform as a component of the texture's definition. 
/// 
/// HISTORY: New entity in IFC 2x2.
class IFC_PARSE_API IfcTextureVertex : public IfcUtil::IfcBaseEntity {
public:
    /// The first coordinate[1] is the S, the second coordinate[2] is the T parameter value.
    std::vector< double > /*[2:2]*/ Coordinates() const;
    void setCoordinates(std::vector< double > /*[2:2]*/ v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcTextureVertex (IfcEntityInstanceData* e);
    IfcTextureVertex (std::vector< double > /*[2:2]*/ v1_Coordinates);
    typedef IfcTemplatedEntityList< IfcTextureVertex > list;
};

class IFC_PARSE_API IfcThermalMaterialProperties : public IfcMaterialProperties {
public:
    /// Whether the optional attribute SpecificHeatCapacity is defined for this IfcThermalMaterialProperties
    bool hasSpecificHeatCapacity() const;
    double SpecificHeatCapacity() const;
    void setSpecificHeatCapacity(double v);
    /// Whether the optional attribute BoilingPoint is defined for this IfcThermalMaterialProperties
    bool hasBoilingPoint() const;
    double BoilingPoint() const;
    void setBoilingPoint(double v);
    /// Whether the optional attribute FreezingPoint is defined for this IfcThermalMaterialProperties
    bool hasFreezingPoint() const;
    double FreezingPoint() const;
    void setFreezingPoint(double v);
    /// Whether the optional attribute ThermalConductivity is defined for this IfcThermalMaterialProperties
    bool hasThermalConductivity() const;
    double ThermalConductivity() const;
    void setThermalConductivity(double v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcThermalMaterialProperties (IfcEntityInstanceData* e);
    IfcThermalMaterialProperties (::Ifc2x3::IfcMaterial* v1_Material, boost::optional< double > v2_SpecificHeatCapacity, boost::optional< double > v3_BoilingPoint, boost::optional< double > v4_FreezingPoint, boost::optional< double > v5_ThermalConductivity);
    typedef IfcTemplatedEntityList< IfcThermalMaterialProperties > list;
};
/// A time series is a set of a time-stamped data entries. It allows a natural association of data collected over intervals of time. Time series can be regular or irregular. In regular time series data arrive predictably at predefined intervals.  In irregular time series  some or all time stamps do not follow a repetitive pattern and unpredictable bursts of data may arrive at unspecified points in time.
/// 
/// The modeling of buildings and their performance involves data that are generated and recorded over a period of time.  Such data cover a large spectrum, from weather data to schedules of all kinds to status measurements to reporting to everything else that has a time related aspect. Their correct placement in time is essential for their proper understanding and use, and the IfcTimeSeries subtypes provide the appropriate data structures to accommodate these types of data.
/// 
/// HISTORY: New entity in IFC 2x2.
class IFC_PARSE_API IfcTimeSeries : public IfcUtil::IfcBaseEntity {
public:
    /// An unique name for the time series.
    std::string Name() const;
    void setName(std::string v);
    /// Whether the optional attribute Description is defined for this IfcTimeSeries
    bool hasDescription() const;
    /// A text description of the data that the series represents.
    std::string Description() const;
    void setDescription(std::string v);
    /// The start time of a time series.
    ::Ifc2x3::IfcDateTimeSelect* StartTime() const;
    void setStartTime(::Ifc2x3::IfcDateTimeSelect* v);
    /// The end time of a time series.
    ::Ifc2x3::IfcDateTimeSelect* EndTime() const;
    void setEndTime(::Ifc2x3::IfcDateTimeSelect* v);
    /// The time series data type.
    ::Ifc2x3::IfcTimeSeriesDataTypeEnum::Value TimeSeriesDataType() const;
    void setTimeSeriesDataType(::Ifc2x3::IfcTimeSeriesDataTypeEnum::Value v);
    /// The orgin of a time series data.
    ::Ifc2x3::IfcDataOriginEnum::Value DataOrigin() const;
    void setDataOrigin(::Ifc2x3::IfcDataOriginEnum::Value v);
    /// Whether the optional attribute UserDefinedDataOrigin is defined for this IfcTimeSeries
    bool hasUserDefinedDataOrigin() const;
    /// Value of the data origin if DataOrigin attribute is USERDEFINED.
    std::string UserDefinedDataOrigin() const;
    void setUserDefinedDataOrigin(std::string v);
    /// Whether the optional attribute Unit is defined for this IfcTimeSeries
    bool hasUnit() const;
    /// The unit to be assigned to all values within the time series. Note that mixing units is not allowed. If the value is not given, the global unit for the type of IfcValue, as defined at IfcProject.UnitsInContext is used.
    ::Ifc2x3::IfcUnit* Unit() const;
    void setUnit(::Ifc2x3::IfcUnit* v);
        IfcTemplatedEntityList< IfcTimeSeriesReferenceRelationship >::ptr DocumentedBy() const; // INVERSE IfcTimeSeriesReferenceRelationship::ReferencedTimeSeries
    virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcTimeSeries (IfcEntityInstanceData* e);
    IfcTimeSeries (std::string v1_Name, boost::optional< std::string > v2_Description, ::Ifc2x3::IfcDateTimeSelect* v3_StartTime, ::Ifc2x3::IfcDateTimeSelect* v4_EndTime, ::Ifc2x3::IfcTimeSeriesDataTypeEnum::Value v5_TimeSeriesDataType, ::Ifc2x3::IfcDataOriginEnum::Value v6_DataOrigin, boost::optional< std::string > v7_UserDefinedDataOrigin, ::Ifc2x3::IfcUnit* v8_Unit);
    typedef IfcTemplatedEntityList< IfcTimeSeries > list;
};

class IFC_PARSE_API IfcTimeSeriesReferenceRelationship : public IfcUtil::IfcBaseEntity {
public:
    ::Ifc2x3::IfcTimeSeries* ReferencedTimeSeries() const;
    void setReferencedTimeSeries(::Ifc2x3::IfcTimeSeries* v);
    IfcEntityList::ptr TimeSeriesReferences() const;
    void setTimeSeriesReferences(IfcEntityList::ptr v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcTimeSeriesReferenceRelationship (IfcEntityInstanceData* e);
    IfcTimeSeriesReferenceRelationship (::Ifc2x3::IfcTimeSeries* v1_ReferencedTimeSeries, IfcEntityList::ptr v2_TimeSeriesReferences);
    typedef IfcTemplatedEntityList< IfcTimeSeriesReferenceRelationship > list;
};
/// A time series value is a list of values that comprise the time series. At least one value must be supplied. Applications are expected to normalize values by applying the following three rules:
/// 
/// All time (universal, local, daylight savings, and solar) is normalized against the ISO 8601 standard GMT/UTC (Universal Coordinated Time).
/// Any rollover is handled by the application providing the data.  Rollover occurs, for example, when the measurement device resets itself while measuring and the recording data do not include the data measured before the reset.
/// The normalized data refer to the preceding time unit.  The time series example shown in Figure 241 below contains four time points: Time "a" indicates the beginning of the time series and the associated datum has no relevance.  Data at time points "b," "c" and "d" are associated with values 1, 2 and 3, respectively.
/// 
/// Figure 241 — Time series value 
/// 
/// HISTORY  New entity in IFC2x2.
class IFC_PARSE_API IfcTimeSeriesValue : public IfcUtil::IfcBaseEntity {
public:
    /// A list of time-series values. At least one value is required.
    IfcEntityList::ptr ListValues() const;
    void setListValues(IfcEntityList::ptr v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcTimeSeriesValue (IfcEntityInstanceData* e);
    IfcTimeSeriesValue (IfcEntityList::ptr v1_ListValues);
    typedef IfcTemplatedEntityList< IfcTimeSeriesValue > list;
};
/// Definition from ISO/CD 10303-42:1992: The topological representation item is the supertype for all the topological representation items in the geometry resource. 
/// 
/// NOTE  Corresponding ISO 10303 entity: topological_representation_item. Please refer to ISO/IS 10303-42:1994, p.129 for the final definition of the formal standard.
/// 
/// HISTORY: New entity in IFC Release 1.5
class IFC_PARSE_API IfcTopologicalRepresentationItem : public IfcRepresentationItem {
public:
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcTopologicalRepresentationItem (IfcEntityInstanceData* e);
    IfcTopologicalRepresentationItem ();
    typedef IfcTemplatedEntityList< IfcTopologicalRepresentationItem > list;
};
/// IfcTopologyRepresentation
/// represents the concept of a particular topological representation of a
/// product or a product component within a representation context. This
/// representation context does not need to be (but may be) a geometric
/// representation context. Several representation types for shape
/// representation are included as predefined types: 
/// 
/// Vertex
///   topological vertex
/// representation (with or without assigned geometry)
/// 
/// Edge
///   topological edge
/// representation (with or without assigned geometry)
/// 
/// Path
///   topological path
/// representation (with or without assigned geometry)
/// 
/// Face
///   topological face
/// representation (with or without assigned geometry)
/// 
/// Shell
///   topological shell
/// representation (with or without assigned geometry)
/// 
/// Undefined
///   no constraints imposed
/// 
/// The representation type is
/// given as a string value at the inherited attribute 'RepresentationType'.
/// 
/// HISTORY: New entity in IFC 2x2.
class IFC_PARSE_API IfcTopologyRepresentation : public IfcShapeModel {
public:
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcTopologyRepresentation (IfcEntityInstanceData* e);
    IfcTopologyRepresentation (::Ifc2x3::IfcRepresentationContext* v1_ContextOfItems, boost::optional< std::string > v2_RepresentationIdentifier, boost::optional< std::string > v3_RepresentationType, IfcTemplatedEntityList< ::Ifc2x3::IfcRepresentationItem >::ptr v4_Items);
    typedef IfcTemplatedEntityList< IfcTopologyRepresentation > list;
};
/// IfcUnitAssignment indicates a set of units which may be assigned. Within an IfcUnitAssigment each unit definition shall be unique; that is, there shall be no redundant unit definitions for the same unit type such as length unit or area unit. For currencies, there shall be only a single IfcMonetaryUnit within an IfcUnitAssignment.
/// 
/// NOTE  A project (IfcProject) has a unit assignment which establishes a set of units which will be used globally within the project, if not otherwise defined. Other objects may have local unit assignments if there is a requirement for them to make use of units which do not fall within the project unit assignment.
/// 
/// HISTORY  New entity in IFC Release 1.5.1.
class IFC_PARSE_API IfcUnitAssignment : public IfcUtil::IfcBaseEntity {
public:
    /// Units to be included within a unit assignment.
    IfcEntityList::ptr Units() const;
    void setUnits(IfcEntityList::ptr v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcUnitAssignment (IfcEntityInstanceData* e);
    IfcUnitAssignment (IfcEntityList::ptr v1_Units);
    typedef IfcTemplatedEntityList< IfcUnitAssignment > list;
};
/// Definition from ISO/CD 10303-42:1992: A vertex is the topological construct corresponding to a point. It has dimensionality 0 and extent 0. The domain of a vertex, if present, is a point in m dimensional real space RM; this is represented by the vertex point subtype. 
/// 
/// NOTE  Corresponding ISO 10303 entity: vertex. Please refer to ISO/IS 10303-42:1994, p. 129 for the final definition of the formal standard.
/// 
/// HISTORY  New Entity in IFC Release 2.0
/// 
/// Informal proposition:
/// 
/// The vertex has dimensionality 0. This is a fundamental property of the vertex.
/// The extent of a vertex is defined to be zero.
class IFC_PARSE_API IfcVertex : public IfcTopologicalRepresentationItem {
public:
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcVertex (IfcEntityInstanceData* e);
    IfcVertex ();
    typedef IfcTemplatedEntityList< IfcVertex > list;
};

class IFC_PARSE_API IfcVertexBasedTextureMap : public IfcUtil::IfcBaseEntity {
public:
    IfcTemplatedEntityList< ::Ifc2x3::IfcTextureVertex >::ptr TextureVertices() const;
    void setTextureVertices(IfcTemplatedEntityList< ::Ifc2x3::IfcTextureVertex >::ptr v);
    IfcTemplatedEntityList< ::Ifc2x3::IfcCartesianPoint >::ptr TexturePoints() const;
    void setTexturePoints(IfcTemplatedEntityList< ::Ifc2x3::IfcCartesianPoint >::ptr v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcVertexBasedTextureMap (IfcEntityInstanceData* e);
    IfcVertexBasedTextureMap (IfcTemplatedEntityList< ::Ifc2x3::IfcTextureVertex >::ptr v1_TextureVertices, IfcTemplatedEntityList< ::Ifc2x3::IfcCartesianPoint >::ptr v2_TexturePoints);
    typedef IfcTemplatedEntityList< IfcVertexBasedTextureMap > list;
};
/// Definition from ISO/CD 10303-42:1992: A vertex point is a vertex which has its geometry defined as a point.  
/// 
/// NOTE  Corresponding ISO 10303 entity: vertex_point. Please refer to ISO/IS 10303-42:1994, p. 130 for the final definition of the formal standard. Due to the general IFC model specification rule not to use multiple inheritance, the subtype relationship to geometric_representation_item is not included.
/// 
/// HISTORY  New Entity in IFC2x.
/// 
/// Informal proposition: 
/// 
/// The domain of the vertex is formally defined to be the domain of its vertex point.
class IFC_PARSE_API IfcVertexPoint : public IfcVertex {
public:
    /// The geometric point, which defines the position in geometric space of the vertex.
    ::Ifc2x3::IfcPoint* VertexGeometry() const;
    void setVertexGeometry(::Ifc2x3::IfcPoint* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcVertexPoint (IfcEntityInstanceData* e);
    IfcVertexPoint (::Ifc2x3::IfcPoint* v1_VertexGeometry);
    typedef IfcTemplatedEntityList< IfcVertexPoint > list;
};
/// IfcVirtualGridIntersection defines the derived location of the intersection between two grid axes. Offset values may be given to set an offset distance to the grid axis for the calculation of the virtual grid intersection.
/// 
/// The two intersecting axes (IntersectingAxes) define the intersection point, which exact location (in terms of the Cartesian point representing the intersection) has to be calculated from the geometric representation of the two participating curves.
/// 
/// NOTE The IfcGrid local placement, that can be provided relative to the local placement of another spatial structure element, has to be taken into account for calculating the absolute placement of the IfcVirtualGridIntersection. Where rules and informal rules ensure, that the IntersectingAxes belong to the same IfcGrid
/// 
/// Offset values may be given (OffsetDistances). If given, the position within the list of OffsetDistances
/// corresponds with the position within the list of IntersectingAxes. Therefore:
/// 
/// OffsetDistances[1] sets the offset to IntersectingAxes[1],
/// OffsetDistances[2] sets the offset to IntersectingAxes[2], and
/// OffsetDistances[3] sets the offset to the virtual intersection in direction of the orientation of the cross product
/// of IntersectingAxes[1] and the orthogonal complement of the IntersectingAxes[1] (which is the positive or negative
/// direction of the z axis of the design grid position).
/// 
/// HISTORY  New entity in IFC Release 1.5. The entity name was changed from IfcConstraintRelIntersection in IFC Release 2x.
/// 
/// Informal Propositions:
/// 
/// Both, IntersectingAxes[1] and
/// IntersectingAxes[2] shall be two IfcGridAxis
/// defined by the same IfcGrid.
/// IntersectingAxes[1] and IntersectingAxes[2]
/// shall not be part of the same row of grid axes, i.e. both shall
/// not be within the same set of IfcGrid.UAxes or
/// IfcGrid.VAxes of the corresponding IfcGrid.
/// 
/// Geometry use definitions:
/// The following figures explain the usage of the OffsetDistances and IntersectingAxes attributes.
/// 
/// Figure 246 illustrates two offset distances given where the virtual intersection is defined in the xy plane of the grid axis placement.
/// 
/// Figure 246 — Virtual grid intersection with two offsets
/// 
/// Figure 247 illustrates three offset distances given where the virtual intersection is defined by an offset (in direction of the
/// z-axis of the design grid placement) to the virtual intersection in the xy plane of the grid axis placement.
/// 
/// Figure 247 — Virtual grid intersection with three offsets
/// 
/// The distance of the offset curve (OffsetDistances[n])
/// is measured from the basis curve. The distance may be positive,
/// negative or zero. A positive value of distance defines an offset
/// in the direction which is normal to the curve in the sense of an
/// anti-clockwise rotation through 90 degrees from the tangent
/// vector T at the given point. (This is in the direction of
/// orthogonal complement(T).) This can be reverted by the
/// SameSense attribute at IfcGridAxis which may switch
/// the sense of the AxisCurve.
/// Illustration
/// 
/// Figure 248 illustrates an example of a negative offset where the figure shows the side of the offset.
/// 
/// IntersectingAxes[1].AxisCurve is an
/// IfcTrimmedCurve with an IfcCircle as
/// BasisCurve and SenseAgreement = TRUE.
/// IntersectingAxes[1].SameSense = TRUE.
/// OffsetDistances[1] is a negative length measure
/// 
/// Figure 248 — Virtual grid intersection negative offset
class IFC_PARSE_API IfcVirtualGridIntersection : public IfcUtil::IfcBaseEntity {
public:
    /// Two grid axes which intersects at exactly one intersection (see also informal proposition at IfcGrid). If attribute OffsetDistances is omitted, the intersection defines the placement or ref direction of a grid placement directly. If OffsetDistances are given, the intersection is defined by the offset curves to the grid axes.
    IfcTemplatedEntityList< ::Ifc2x3::IfcGridAxis >::ptr IntersectingAxes() const;
    void setIntersectingAxes(IfcTemplatedEntityList< ::Ifc2x3::IfcGridAxis >::ptr v);
    /// Offset distances to the grid axes. If given, it defines virtual offset curves to the grid axes. The intersection of the offset curves specify the virtual grid intersection.
    std::vector< double > /*[2:3]*/ OffsetDistances() const;
    void setOffsetDistances(std::vector< double > /*[2:3]*/ v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcVirtualGridIntersection (IfcEntityInstanceData* e);
    IfcVirtualGridIntersection (IfcTemplatedEntityList< ::Ifc2x3::IfcGridAxis >::ptr v1_IntersectingAxes, std::vector< double > /*[2:3]*/ v2_OffsetDistances);
    typedef IfcTemplatedEntityList< IfcVirtualGridIntersection > list;
};

class IFC_PARSE_API IfcWaterProperties : public IfcMaterialProperties {
public:
    /// Whether the optional attribute IsPotable is defined for this IfcWaterProperties
    bool hasIsPotable() const;
    bool IsPotable() const;
    void setIsPotable(bool v);
    /// Whether the optional attribute Hardness is defined for this IfcWaterProperties
    bool hasHardness() const;
    double Hardness() const;
    void setHardness(double v);
    /// Whether the optional attribute AlkalinityConcentration is defined for this IfcWaterProperties
    bool hasAlkalinityConcentration() const;
    double AlkalinityConcentration() const;
    void setAlkalinityConcentration(double v);
    /// Whether the optional attribute AcidityConcentration is defined for this IfcWaterProperties
    bool hasAcidityConcentration() const;
    double AcidityConcentration() const;
    void setAcidityConcentration(double v);
    /// Whether the optional attribute ImpuritiesContent is defined for this IfcWaterProperties
    bool hasImpuritiesContent() const;
    double ImpuritiesContent() const;
    void setImpuritiesContent(double v);
    /// Whether the optional attribute PHLevel is defined for this IfcWaterProperties
    bool hasPHLevel() const;
    double PHLevel() const;
    void setPHLevel(double v);
    /// Whether the optional attribute DissolvedSolidsContent is defined for this IfcWaterProperties
    bool hasDissolvedSolidsContent() const;
    double DissolvedSolidsContent() const;
    void setDissolvedSolidsContent(double v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcWaterProperties (IfcEntityInstanceData* e);
    IfcWaterProperties (::Ifc2x3::IfcMaterial* v1_Material, boost::optional< bool > v2_IsPotable, boost::optional< double > v3_Hardness, boost::optional< double > v4_AlkalinityConcentration, boost::optional< double > v5_AcidityConcentration, boost::optional< double > v6_ImpuritiesContent, boost::optional< double > v7_PHLevel, boost::optional< double > v8_DissolvedSolidsContent);
    typedef IfcTemplatedEntityList< IfcWaterProperties > list;
};

class IFC_PARSE_API IfcAnnotationOccurrence : public IfcStyledItem {
public:
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcAnnotationOccurrence (IfcEntityInstanceData* e);
    IfcAnnotationOccurrence (::Ifc2x3::IfcRepresentationItem* v1_Item, IfcTemplatedEntityList< ::Ifc2x3::IfcPresentationStyleAssignment >::ptr v2_Styles, boost::optional< std::string > v3_Name);
    typedef IfcTemplatedEntityList< IfcAnnotationOccurrence > list;
};

class IFC_PARSE_API IfcAnnotationSurfaceOccurrence : public IfcAnnotationOccurrence {
public:
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcAnnotationSurfaceOccurrence (IfcEntityInstanceData* e);
    IfcAnnotationSurfaceOccurrence (::Ifc2x3::IfcRepresentationItem* v1_Item, IfcTemplatedEntityList< ::Ifc2x3::IfcPresentationStyleAssignment >::ptr v2_Styles, boost::optional< std::string > v3_Name);
    typedef IfcTemplatedEntityList< IfcAnnotationSurfaceOccurrence > list;
};

class IFC_PARSE_API IfcAnnotationSymbolOccurrence : public IfcAnnotationOccurrence {
public:
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcAnnotationSymbolOccurrence (IfcEntityInstanceData* e);
    IfcAnnotationSymbolOccurrence (::Ifc2x3::IfcRepresentationItem* v1_Item, IfcTemplatedEntityList< ::Ifc2x3::IfcPresentationStyleAssignment >::ptr v2_Styles, boost::optional< std::string > v3_Name);
    typedef IfcTemplatedEntityList< IfcAnnotationSymbolOccurrence > list;
};

class IFC_PARSE_API IfcAnnotationTextOccurrence : public IfcAnnotationOccurrence {
public:
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcAnnotationTextOccurrence (IfcEntityInstanceData* e);
    IfcAnnotationTextOccurrence (::Ifc2x3::IfcRepresentationItem* v1_Item, IfcTemplatedEntityList< ::Ifc2x3::IfcPresentationStyleAssignment >::ptr v2_Styles, boost::optional< std::string > v3_Name);
    typedef IfcTemplatedEntityList< IfcAnnotationTextOccurrence > list;
};
/// The closed profile IfcArbitraryClosedProfileDef defines an arbitrary two-dimensional profile for the use within the swept surface geometry, the swept area solid or a sectioned spine. It is given by an outer boundary from which the surface or solid can be constructed. 
/// 
/// HISTORY: New entity in IFC 1.5. Entity has been renamed from IfcArbitraryProfileDef in IFC Release 2x.
/// 
/// Informal proposition: 
/// 
/// The OuterCurve has to be a closed curve.
///   The OuterCurve shall not intersect.
/// 
/// Figure 307 illustrates the arbitrary closed profile definition. The OuterCurve is defined in the underlying coordinate system. The underlying coordinate system is defined by the swept surface or swept area solid that uses the profile definition. It is the xy plane of either:
/// 
/// IfcSweptSurface.Position
///   IfcSweptAreaSolid.Position
/// 
/// or in case of sectioned spines the xy plane of each list member of IfcSectionedSpine.CrossSectionPositions. The OuterCurve
/// attribute defines a two dimensional closed bounded curve.
/// 
/// Figure 307 — Arbitrary closed profile
class IFC_PARSE_API IfcArbitraryClosedProfileDef : public IfcProfileDef {
public:
    /// Bounded curve, defining the outer boundaries of the arbitrary profile.
    ::Ifc2x3::IfcCurve* OuterCurve() const;
    void setOuterCurve(::Ifc2x3::IfcCurve* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcArbitraryClosedProfileDef (IfcEntityInstanceData* e);
    IfcArbitraryClosedProfileDef (::Ifc2x3::IfcProfileTypeEnum::Value v1_ProfileType, boost::optional< std::string > v2_ProfileName, ::Ifc2x3::IfcCurve* v3_OuterCurve);
    typedef IfcTemplatedEntityList< IfcArbitraryClosedProfileDef > list;
};
/// The open profile IfcArbitraryOpenProfileDef defines an arbitrary two-dimensional open profile for the use within the swept surface geometry. It is given by an open boundary from with the surface can be constructed. 
/// 
/// HISTORY  New entity in IFC2x.
/// 
/// Informal proposition:
/// 
/// The Curve has to be an open curve.
/// 
/// Figure 308 illustrates the arbitrary open profile definition. The Curve is defined in the underlying coordinate system. The underlying coordinate system is defined by the swept surface that uses the profile definition. It is the xy plane of: 
/// 
/// IfcSweptSurface.Position
/// 
/// The Curve attribute defines a two dimensional open bounded curve.
/// 
/// Figure 308 — Arbitrary open profile
class IFC_PARSE_API IfcArbitraryOpenProfileDef : public IfcProfileDef {
public:
    /// Open bounded curve defining the profile.
    ::Ifc2x3::IfcBoundedCurve* Curve() const;
    void setCurve(::Ifc2x3::IfcBoundedCurve* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcArbitraryOpenProfileDef (IfcEntityInstanceData* e);
    IfcArbitraryOpenProfileDef (::Ifc2x3::IfcProfileTypeEnum::Value v1_ProfileType, boost::optional< std::string > v2_ProfileName, ::Ifc2x3::IfcBoundedCurve* v3_Curve);
    typedef IfcTemplatedEntityList< IfcArbitraryOpenProfileDef > list;
};
/// The IfcArbitraryProfileDefWithVoids defines an arbitrary closed two-dimensional profile with holes defined for the use for the swept area solid or a sectioned spine. It is given by an outer boundary and inner boundaries from with the solid the can be constructed.
/// 
/// HISTORY  New entity in IFC2x.
/// 
/// Informal propositions:
/// 
/// The outer curve and all inner curves shall be closed curves.
///   The outer curve shall enclose all inner curves.
///   No inner curve shall intersect with the outer curve or any other inner curve.
///   No inner curve may enclose another inner curve.
/// 
/// Figure 309 illustrates the arbitrary closed profile definition with voids. The OuterCurve, defined at the supertype IfcArbitraryClosedProfileDef
/// and the inner curves are defined in the same underlying coordinate system. The common underlying coordinate system is defined by the swept area solid that uses the profile definition. It is the xy plane of:
/// 
/// IfcSweptAreaSolid.Position
/// 
/// or in case of sectioned spines the xy plane of each list member of IfcSectionedSpine.CrossSectionPositions.  The OuterCurve attribute defines a two dimensional closed bounded curve, the InnerCurves define a set of two dimensional closed bounded curves.
/// 
/// Figure 309 — Arbitrary profile with voids
class IFC_PARSE_API IfcArbitraryProfileDefWithVoids : public IfcArbitraryClosedProfileDef {
public:
    /// Set of bounded curves, defining the inner boundaries of the arbitrary profile.
    IfcTemplatedEntityList< ::Ifc2x3::IfcCurve >::ptr InnerCurves() const;
    void setInnerCurves(IfcTemplatedEntityList< ::Ifc2x3::IfcCurve >::ptr v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcArbitraryProfileDefWithVoids (IfcEntityInstanceData* e);
    IfcArbitraryProfileDefWithVoids (::Ifc2x3::IfcProfileTypeEnum::Value v1_ProfileType, boost::optional< std::string > v2_ProfileName, ::Ifc2x3::IfcCurve* v3_OuterCurve, IfcTemplatedEntityList< ::Ifc2x3::IfcCurve >::ptr v4_InnerCurves);
    typedef IfcTemplatedEntityList< IfcArbitraryProfileDefWithVoids > list;
};
/// An IfcBlobTexture provides a 2-dimensional distribution of the lighting parameters of a surface onto which it is mapped. The texture itself is given as a single binary blob, representing the content of a pixel format file. The file format of the pixel file is given by the RasterFormat attribute and allowable formats are guided by where rule SupportedRasterFormat.
/// 
/// NOTE  Toolbox specific implementations of the binary datatype may restrict the maximum length of the binary blob to capture the raster file content.
/// 
/// For interpretation of the texture nodes see IfcImageTexture definition.
/// 
/// HISTORY  New class in IFC2x3.
/// 
/// IFC2x4 CHANGE  Data type of RasterCode has been corrected to BINARY.
class IFC_PARSE_API IfcBlobTexture : public IfcSurfaceTexture {
public:
    /// The format of the RasterCode often using a compression.
    std::string RasterFormat() const;
    void setRasterFormat(std::string v);
    /// Blob, given as a single binary, to capture the texture within one popular file (compression) format. The file format is provided by the RasterFormat attribute.
    bool RasterCode() const;
    void setRasterCode(bool v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcBlobTexture (IfcEntityInstanceData* e);
    IfcBlobTexture (bool v1_RepeatS, bool v2_RepeatT, ::Ifc2x3::IfcSurfaceTextureEnum::Value v3_TextureType, ::Ifc2x3::IfcCartesianTransformationOperator2D* v4_TextureTransform, std::string v5_RasterFormat, bool v6_RasterCode);
    typedef IfcTemplatedEntityList< IfcBlobTexture > list;
};
/// The profile IfcCenterLineProfileDef defines an arbitrary two-dimensional open, not self intersecting profile for the use within the swept solid geometry. It is given by an area defined by applying a constant thickness to a centerline, generating an area from which the solid can be constructed.
/// 
/// Among else, IfcCenterLineProfileDef is used to model cold-formed
/// steel or aluminium sections (Sigma, Zeta, Omega, and similar sections
/// which are not covered by subtypes of IfcParameterizedProfileDef).
/// However, since IfcCenterLineProfileDef does not provide shape parameters
/// except for the thickness, there is generally a need to further specify the
/// profile definition by means of
/// 
/// the name,
///   external reference to a document or library,
///   profile properties,
/// 
/// or a combination of them.  See IfcProfileDef for guidance on external references for profiles.
/// 
/// HISTORY  New entity in IFC2x3.
/// 
/// Informal proposition: 
/// 
/// The Curve has to be an open curve.
///   The Curve has to be a non-intersecting curve.
/// 
/// Figure 311 illustrates the center line profile definition. The Curve is defined in the underlying coordinate system. The underlying coordinate system is defined by the swept surface that uses the profile  definition. It is the xy plane of: 
/// 
/// IfcSweptSurface.Position
/// 
/// The Curve attribute defines a two dimensional open bounded curve. The Thickness attribute defines a constant thickness along the curve.
/// 
/// Figure 311 — Centerline profile
class IFC_PARSE_API IfcCenterLineProfileDef : public IfcArbitraryOpenProfileDef {
public:
    /// Constant thickness applied along the center line.
    double Thickness() const;
    void setThickness(double v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcCenterLineProfileDef (IfcEntityInstanceData* e);
    IfcCenterLineProfileDef (::Ifc2x3::IfcProfileTypeEnum::Value v1_ProfileType, boost::optional< std::string > v2_ProfileName, ::Ifc2x3::IfcBoundedCurve* v3_Curve, double v4_Thickness);
    typedef IfcTemplatedEntityList< IfcCenterLineProfileDef > list;
};
/// An IfcClassificationReference is a reference into a classification system or source (see IfcClassification) for a specific classification key (or notation).
/// 
/// The inherited attributes have the following meaning:
/// 
/// Identification: holds the key provided for a specific references to classification items (or tables).
/// Name: allows for a human interpretable designation of a classification notation.
/// Location: optionally holds a direct URI link into the classification system (or source) to hyperlink the classification key.
/// 
/// The IfcClassificationReference can either be assigned directly to the IfcClassification, such as if no classification hierarchy has to be included, or it references the parent classification notation, if the fully classification hierarchy is included in the data set. The attribute ReferencedSource then holds the following information (choice by IfcClassificationReferenceSelect):
/// 
/// being of type IfcClassification: direct reference to the classification system (with meta information provided), used for highest level of classification notations, or if the classification notation hierarchy is not relevant,
/// being of type IfcClassificationReference: reference to the parent classification notation within the classification hierarchy.
/// 
/// HISTORY New entity in IFC 2x.
/// 
/// IFC2x4 CHANGE The attribute Description and inverse attribute HasReferences are added.  The attribute Identification has been renamed from ItemReference.
/// 
/// Use definitions
/// The IfcClassificationReference can be used to only assign classification keys to objects, or to hold a fully classification hierarchy. The first is refered to as "lightweight classification", and the second as "full classification"
/// 
/// The IfcClassificationReference can be used as a form of 'lightweight' classification through the 'Identification' attribute inherited from the abstract IfcExternalReference class. In this case, the 'Identification' could take (for instance) the Uniclass notation "L6814" which, if the classification was well understood by all parties and was known to be taken from a particular classification source, would be sufficient. The Name attribute could be the title "Tanking". This would remove the need for the overhead of the more complete classification structure of the model.
class IFC_PARSE_API IfcClassificationReference : public IfcExternalReference {
public:
    /// Whether the optional attribute ReferencedSource is defined for this IfcClassificationReference
    bool hasReferencedSource() const;
    /// The classification system or source that is referenced.
    ::Ifc2x3::IfcClassification* ReferencedSource() const;
    void setReferencedSource(::Ifc2x3::IfcClassification* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcClassificationReference (IfcEntityInstanceData* e);
    IfcClassificationReference (boost::optional< std::string > v1_Location, boost::optional< std::string > v2_ItemReference, boost::optional< std::string > v3_Name, ::Ifc2x3::IfcClassification* v4_ReferencedSource);
    typedef IfcTemplatedEntityList< IfcClassificationReference > list;
};
/// Definition from ISO/CD 10303-46:1992: A colour rgb as a subtype of colour specifications is defined by three colour component values for red, green, and blue in the RGB colour model.
/// 
/// NOTE  In contrary to the usual value range of colour components being integer from 0...255, the definition from ISO10303-46 defines the colour components as real from 0.0 ... 1.0. Applications need to execute this conversion before populating the colour RGB values.
/// 
/// NOTE  Corresponding STEP name: colour_rgb. The name attribute has been omitted, the data type for the reg, green and blue parts is IfcNormalizedRatioMeasure, that already includes the range restrictions for the values. Please
/// refer to ISO/IS 10303-46:1994, p. 138 for the final definition of the formal standard.
/// 
/// HISTORY  New entity in IFC2x2.
class IFC_PARSE_API IfcColourRgb : public IfcColourSpecification {
public:
    /// The intensity of the red colour component.
    /// 
    /// NOTE  The colour component value is given within the range of 0..1, and not within the range of 0..255 as otherwise usual.
    double Red() const;
    void setRed(double v);
    /// The intensity of the green colour component.
    /// 
    /// NOTE  The colour component value is given within the range of 0..1, and not within the range of 0..255 as otherwise usual.
    double Green() const;
    void setGreen(double v);
    /// The intensity of the blue colour component.
    /// 
    /// NOTE  The colour component value is given within the range of 0..1, and not within the range of 0..255 as otherwise usual.
    double Blue() const;
    void setBlue(double v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcColourRgb (IfcEntityInstanceData* e);
    IfcColourRgb (boost::optional< std::string > v1_Name, double v2_Red, double v3_Green, double v4_Blue);
    typedef IfcTemplatedEntityList< IfcColourRgb > list;
};
/// IfcComplexProperty is used to define complex properties to be handled completely within a property set. The included set of properties may be a mixed or consistent collection of IfcProperty subtypes. This enables the definition of a set of properties to be included as a single 'property' entry in an IfcPropertySet. The definition of such an IfcComplexProperty can be reused in many different IfcPropertySet's.
/// 
/// NOTE  Since an IfcComplexProperty may contain other complex properties, sets of properties can be nested. This nesting may be restricted by view definitions and implementer agreements.
/// 
/// HISTORY New Entity in IFC Release 2.0, capabilities enhanced in IFC Release 2x.
class IFC_PARSE_API IfcComplexProperty : public IfcProperty {
public:
    /// Usage description of the IfcComplexProperty within the property set which references the IfcComplexProperty.
    ///   NOTE: Consider a complex property for glazing properties. The Name attribute of the IfcComplexProperty could be Pset_GlazingProperties, and the UsageName attribute could be OuterGlazingPane.
    std::string UsageName() const;
    void setUsageName(std::string v);
    /// Set of properties that can be used within this complex property (may include other complex properties).
    IfcTemplatedEntityList< ::Ifc2x3::IfcProperty >::ptr HasProperties() const;
    void setHasProperties(IfcTemplatedEntityList< ::Ifc2x3::IfcProperty >::ptr v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcComplexProperty (IfcEntityInstanceData* e);
    IfcComplexProperty (std::string v1_Name, boost::optional< std::string > v2_Description, std::string v3_UsageName, IfcTemplatedEntityList< ::Ifc2x3::IfcProperty >::ptr v4_HasProperties);
    typedef IfcTemplatedEntityList< IfcComplexProperty > list;
};
/// The IfcCompositeProfileDef
/// defines the profile by composition of other profiles. The composition
/// is given by a set of at least two other profile definitions. Any
/// profile definition (except for another composite profile) can be used
/// to construct the composite. 
/// 
/// HISTORY  New entity in IFC2x.
/// 
/// Figure 314 illustrates the composite profile definition. The IfcCompositeProfileDef does not define an own position coordinate system, it is directly defined in the underlying coordinate system. The underlying coordinate system is defined by the swept surface or swept area solid that uses the profile definition. It is the xy plane of either:
/// 
/// IfcSweptSurface.Position
///   IfcSweptAreaSolid.Position
/// 
/// Or in case of sectioned spines it is the xy plane of each list member of IfcSectionedSpine.CrossSectionPositions. The IfcCompositeProfileDef is defined using other profile definitions. Those other profile definitions are directly inserted into the underlying coordinate system.
/// 
/// In case of parameterized profile definitions, the Position attribute of those standard profiles is used to place the profiles relatively to each other.
///   In case of arbitrary profile definitions, each Cartesian coordinate is given directly within the underlying coordinate system.
/// 
/// NOTE  The black coordinate axes show the underlying coordinate system of the swept surface or swept area solid.
/// 
/// Figure 314
/// 
/// Twin profiles special case
/// 
/// If twin profiles are modeled by profile composition, the base profile should
/// only be specified once. It is then included into the composite profile directly
/// and additionally indirectly via IfcMirroredProfileDef. For example, a
/// double angle made of two L100x10 with 10mm air gap between them, i.e. a
/// _| |_ shape, can be modeled as
/// 
/// single_L : IfcLShapeProfileDef := IfcLShapeProfileDef(AREA, 'L100X100X10',
///     IfcAxis2Placement2D(IfcCartesianPoint(((.100+.010)/2., .0)), ?),
///     .100, .100, .010, .012, ?, 0., ?, ?);
///  
/// double_L : IfcCompositeProfileDef := IfcCompositeProfileDef(AREA, 'double angle',
///     (single_L, IfcMirroredProfileDef(AREA, ?, single_L, ?)), 'twin profile');
class IFC_PARSE_API IfcCompositeProfileDef : public IfcProfileDef {
public:
    /// The profiles which are used to define the composite profile.
    IfcTemplatedEntityList< ::Ifc2x3::IfcProfileDef >::ptr Profiles() const;
    void setProfiles(IfcTemplatedEntityList< ::Ifc2x3::IfcProfileDef >::ptr v);
    /// Whether the optional attribute Label is defined for this IfcCompositeProfileDef
    bool hasLabel() const;
    /// The name by which the composition may be referred to. The actual meaning of the name has to be defined in the context of applications.
    std::string Label() const;
    void setLabel(std::string v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcCompositeProfileDef (IfcEntityInstanceData* e);
    IfcCompositeProfileDef (::Ifc2x3::IfcProfileTypeEnum::Value v1_ProfileType, boost::optional< std::string > v2_ProfileName, IfcTemplatedEntityList< ::Ifc2x3::IfcProfileDef >::ptr v3_Profiles, boost::optional< std::string > v4_Label);
    typedef IfcTemplatedEntityList< IfcCompositeProfileDef > list;
};
/// Definition from ISO/CD 10303-42:1992: A connected_face_set is a set of faces such that the domain of faces together with their bounding edges and vertices is connected.  
/// 
/// NOTE  Corresponding ISO 10303 entity: connected_face_set, the subtype closed_shell is included as IfcClosedShell and the subtype open_shell is included as IfcOpenShell. Please refer to ISO/IS 10303-42:1994, p. 144 for the final definition of the formal standard.
/// 
/// HISTORY  New class in IFC Release 1.0
/// 
/// Informal proposition: 
/// 
/// The union of the domains of the faces and their bounding loops shall be arcwise connected.
class IFC_PARSE_API IfcConnectedFaceSet : public IfcTopologicalRepresentationItem {
public:
    /// The set of faces arcwise connected along common edges or vertices.
    IfcTemplatedEntityList< ::Ifc2x3::IfcFace >::ptr CfsFaces() const;
    void setCfsFaces(IfcTemplatedEntityList< ::Ifc2x3::IfcFace >::ptr v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcConnectedFaceSet (IfcEntityInstanceData* e);
    IfcConnectedFaceSet (IfcTemplatedEntityList< ::Ifc2x3::IfcFace >::ptr v1_CfsFaces);
    typedef IfcTemplatedEntityList< IfcConnectedFaceSet > list;
};
/// IfcConnectionCurveGeometry is used to describe the geometric constraints that facilitate the physical connection of two objects at a curve or at an edge with curve geometry associated. It is envisioned as a control that applies to the element connection relationships. 
/// 
/// EXAMPLE  The connection relationship between two walls has a geometric constraint which describes the end caps (or cut-off of the wall ends) by a CurveOnRelatingElement for the first wall and a CurveOnRelatedElement for the second wall. The exact usage of the IfcConnectionCurveGeometry is further defined in the geometry use sections of the elements that use it.
/// 
/// The available geometry for the connection constraint may be further restricted to only allow straight segments by applying IfcPolyline
/// only. Such an usage constraint is provided at the object definition of the IfcElement subtype, utilizing the element connection by referring to the subtype of IfcRelConnects with the associated IfcConnectionCurveGeometry.
/// 
/// HISTORY  New entity in IFC Release 1.5, has been renamed from IfcLineConnectionGeometry in IFC Release 2x.
/// 
/// IFC2x Edition 3 CHANGE  The provision of topology with associated geometry, IfcEdgeCurve, is enabled by using the IfcCurveOrEdgeCurve.
/// 
/// Geometry use definitions
/// The IfcCurve (or the IfcEdgeCurve with an associated IfcCurve) at the CurveOnRelatingElement attribute defines the curve where the basic geometry items of the connected elements connects. The curve geometry and coordinates are provided within the local coordinate system of the RelatingElement, as specified at the IfcRelConnects Subtype that utilizes the IfcConnectionCurveGeometry. Optionally, the same curve geometry and coordinates can also be provided within the local coordinate system of the RelatedElement by using the CurveOnRelatedElement attribute.
class IFC_PARSE_API IfcConnectionCurveGeometry : public IfcConnectionGeometry {
public:
    /// The bounded curve at which the connected objects are aligned at the relating element, given in the LCS of the relating element.
    ::Ifc2x3::IfcCurveOrEdgeCurve* CurveOnRelatingElement() const;
    void setCurveOnRelatingElement(::Ifc2x3::IfcCurveOrEdgeCurve* v);
    /// Whether the optional attribute CurveOnRelatedElement is defined for this IfcConnectionCurveGeometry
    bool hasCurveOnRelatedElement() const;
    /// The bounded curve at which the connected objects are aligned at the related element, given in the LCS of the related element. If the information is omitted, then the origin of the related element is used.
    ::Ifc2x3::IfcCurveOrEdgeCurve* CurveOnRelatedElement() const;
    void setCurveOnRelatedElement(::Ifc2x3::IfcCurveOrEdgeCurve* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcConnectionCurveGeometry (IfcEntityInstanceData* e);
    IfcConnectionCurveGeometry (::Ifc2x3::IfcCurveOrEdgeCurve* v1_CurveOnRelatingElement, ::Ifc2x3::IfcCurveOrEdgeCurve* v2_CurveOnRelatedElement);
    typedef IfcTemplatedEntityList< IfcConnectionCurveGeometry > list;
};
/// IfcConnectionPointEccentricity is used to describe the geometric constraints that facilitate the physical connection of two objects at a point or vertex point with associated point coordinates. There is a physical distance, or eccentricity, etween the connection points of both object. The eccentricity can be either given by:
/// 
/// providing the PointOnRelatingElement and the PointOnRelatedElement, where bothÿpoint coordinates are not identical within a common parent coordinate system (latestly within the world coordinate system),
/// providing the PointOnRelatingElement and the three distance measures, EccentricityInX, EccentricityInY, and EccentricityInZ (or only EccentricityInX, and EccentricityInY if the
/// underlying coordinate system is two-dimensional), or
/// providing both.
/// 
/// NOTEÿ If both, PointOnRelatedElement, and EccentricityInX, EccentricityInY, (EccentricityInZ) are provided, the values should be consistent. In case of any non-consistency, the calculated distance between PointOnRelatingElement and PointOnRelatedElement takes precedence.
/// 
/// The explicit values for EccentricityInX, EccentricityInY, and EccentricityInZ are always
/// measured in the following direction and coordinate system (defining when the value is positive or negative):
/// 
/// from the PointOnRelatedElement to PointOnRelatingElement within the coordinate system of the RelatingElement.
/// in addition: when used to specify connections in structural analysis models, the IfcStructuralMember is to be used as the RelatingElement of the relationship object utilizing IfcConnectionPointEccentricity, and the IfcStructuralConnection is the RelatedElement.
/// 
/// HISTORYÿ New entity in IFC 2x Edition 3.
/// 
/// Geometry use definitions
/// The IfcPoint (or the IfcVertexPoint with an associated IfcPoint) at the PointOnRelatingElement attribute defines the point where the basic geometry items of the connected elements connects. The point coordinates are provided within the local coordinate system of the RelatingElement, as specified at the IfcRelConnects subtype that utilizes the IfcConnectionPointGeometry. Optionally, the same point coordinates can also be provided within the local coordinate system of the RelatedElement by using the PointOnRelatedElement attribute, otherwise the distance to the point at the RelatedElement has to be given by the three eccentricity values.
class IFC_PARSE_API IfcConnectionPointEccentricity : public IfcConnectionPointGeometry {
public:
    /// Whether the optional attribute EccentricityInX is defined for this IfcConnectionPointEccentricity
    bool hasEccentricityInX() const;
    /// Distance in x direction between the two points (or vertex points) engaged in the point connection.
    double EccentricityInX() const;
    void setEccentricityInX(double v);
    /// Whether the optional attribute EccentricityInY is defined for this IfcConnectionPointEccentricity
    bool hasEccentricityInY() const;
    /// Distance in y direction between the two points (or vertex points) engaged in the point connection.
    double EccentricityInY() const;
    void setEccentricityInY(double v);
    /// Whether the optional attribute EccentricityInZ is defined for this IfcConnectionPointEccentricity
    bool hasEccentricityInZ() const;
    /// Distance in z direction between the two points (or vertex points) engaged in the point connection.
    double EccentricityInZ() const;
    void setEccentricityInZ(double v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcConnectionPointEccentricity (IfcEntityInstanceData* e);
    IfcConnectionPointEccentricity (::Ifc2x3::IfcPointOrVertexPoint* v1_PointOnRelatingElement, ::Ifc2x3::IfcPointOrVertexPoint* v2_PointOnRelatedElement, boost::optional< double > v3_EccentricityInX, boost::optional< double > v4_EccentricityInY, boost::optional< double > v5_EccentricityInZ);
    typedef IfcTemplatedEntityList< IfcConnectionPointEccentricity > list;
};
/// Definition from ISO/CD 10303-41:1992: A context dependent unit is a unit which is not related to the SI system.
/// 
/// NOTE The number of parts in an assembly is a physical quantity measured in units that may be called "parts" but which cannot be related to an SI unit.
/// 
/// NOTE Corresponding ISO 10303 name: context_dependent_unit, please refer to ISO/IS 10303-41 for the final definition of the formal standard.
/// 
/// HISTORY New entity in IFC Release 1.5.1.
class IFC_PARSE_API IfcContextDependentUnit : public IfcNamedUnit {
public:
    /// The word, or group of words, by which the context dependent unit is referred to.
    std::string Name() const;
    void setName(std::string v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcContextDependentUnit (IfcEntityInstanceData* e);
    IfcContextDependentUnit (::Ifc2x3::IfcDimensionalExponents* v1_Dimensions, ::Ifc2x3::IfcUnitEnum::Value v2_UnitType, std::string v3_Name);
    typedef IfcTemplatedEntityList< IfcContextDependentUnit > list;
};
/// Definition from ISO/CD 10303-41:1992: A conversion based unit is a unit that is defined based on a measure with unit.
/// 
/// NOTE Corresponding ISO 10303 name: conversion_based_unit, please refer to ISO/IS 10303-41 for the final definition of the formal standard.
/// 
/// HISTORY New entity in IFC Release 1.5.1.
/// 
/// IFC 2x3 change: standard names of typical units added.
/// 
/// IFC 2x4 change: further names added: square inch, square foot, square mile, square yard, cubic inch, cubic foot, cubic yard, fluid ounce UK/US, ton UK/US, degree.
/// 
/// Example: An inch is a converted unit. It is from the Imperial system, its name is "inch" and it can be related to the si unit, millimetre, through a measure with unit whose value is 25.4 millimetre. A foot is also a converted unit. It is from the Imperial system, its name is "foot" and it can be related to an IfcSIUnit, millimetre, either directly or through the unit called "inch". Note that several US customary units differ from Imperial units (nonmetric English units) of the same name.
/// 
/// To identify some commonly used conversion based units, the standard designations (case insensitive) for the Name attribute include the following:
/// 
/// Name	Description
///   'inch'		Length measure equal to 25.4 mm
///   'foot'		Length measure equal to 304.8 mm
///   'yard'		Length measure equal to 914 mm
///   'mile'		Length measure equal to 1609 m
///   'square inch'	Area measure equal to 0.0006452 square meters
///   'square foot'	Area measure equal to 0.09290 square meters
///   'square yard'	Area measure equal to 0.83612736 square meters
///   'acre'		Area measure equal to 4046.86 square meters
///   'square mile'	Area measure equal to 2 588 881 square meters
///   'cubic inch'	Volume measure equal to 0.00001639 cubic meters
///   'cubic foot'	Volume measure equal to 0.02832 cubic meters
///   'cubic yard'	Volume measure equal to 0.7636 cubic meters
///   'litre'		Volume measure equal to 0.001 cubic meters
///   'fluid ounce UK'	Volume measure equal to 0.0000284130625 cubic meters
///   'fluid ounce US'	Volume measure equal to 0.00002957353 cubic meters
///   'pint UK'		Volume measure equal to 0.000568 cubic meters
///   'pint US'		Volume measure equal to 0.000473 cubic meters
///   'gallon UK'	Volume measure equal to 0.004546 cubic meters
///   'gallon US'	Volume measure equal to 0.003785 cubic meters
///   'degree'		Angle measure equal to π/180 rad
///   'ounce'		Mass measure equal to 28.35 g
///   'pound'		Mass measure equal to 0.454 kg
///   'ton UK'		Mass measure equal to 1016.0469088 kg, also known as long ton, gross ton, shipper's ton
///   'ton US'		Mass measure equal to 907.18474 kg, also known as short ton, net ton
///   'lbf'		Force measure equal to 4.4482216153 N, pound-force
///   'kip'		Force measure equal to 4448.2216153 N, kilopound-force
///   'psi'		Pressure measure equal to 6894.7572932 Pa, pound-force per square inch
///   'ksi'		Pressure measure equal to 6894757.2932 Pa, kilopound-force per square inch
///   'minute'		Time measure equal to 60 s
///   'hour'		Time measure equal to 3600 s
///   'day'		Time measure equal to 86400 s
///   'btu'		Energy measure equal to 1055.056 J, British Thermal Unit
class IFC_PARSE_API IfcConversionBasedUnit : public IfcNamedUnit {
public:
    /// The word, or group of words, by which the conversion based unit is referred to.
    std::string Name() const;
    void setName(std::string v);
    /// The physical quantity from which the converted unit is derived.
    ::Ifc2x3::IfcMeasureWithUnit* ConversionFactor() const;
    void setConversionFactor(::Ifc2x3::IfcMeasureWithUnit* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcConversionBasedUnit (IfcEntityInstanceData* e);
    IfcConversionBasedUnit (::Ifc2x3::IfcDimensionalExponents* v1_Dimensions, ::Ifc2x3::IfcUnitEnum::Value v2_UnitType, std::string v3_Name, ::Ifc2x3::IfcMeasureWithUnit* v4_ConversionFactor);
    typedef IfcTemplatedEntityList< IfcConversionBasedUnit > list;
};
/// Definition from ISO/CD 10303-46:1992: A curve style specifies the visual appearance of curves.
/// 
/// An IfcCurveStyle provides the style table for presentation information assigned to geometric curves. The style is defined by a color, a font and a width. The IfcCurveStyle defines curve patterns as model patterns, that is, the distance between visible and invisible segments of curve patterns are given in model space dimensions (that have to be scaled using the target plot scale).
/// 
/// Styles are intended to be shared by multiple IfcStyledItem's, assigning the style to occurrences of (subtypes of) IfcGeometricRepresentationItem's. Measures given to a font pattern or a curve width are given in global drawing length units.
/// 
/// NOTE  global units are defined at the single IfcProject instance, given by UnitsInContext:IfcUnitAssignment, the same units are used for the geometric representation items and for the style definitions.
/// 
/// The measure values for font pattern and curve width apply to the model space with a target plot scale provided for the correct appearance in the default plot scale.. For different scale and projection dependent curve styles a different instance of IfcCurveStyle needs to be used by IfcPresentationStyleAssignment for different IfcGeometricRepresentationSubContext dependent representations.
/// 
/// NOTE  the target plot scale is given by IfcGeometricRepresentationSubContext.TargetScale.
/// 
/// An IfcCurveStyle can be assigned to IfcGeometricRepresentationItem's via the IfcPresentationStyleAssignment through an intermediate IfcStyledItem or IfcAnnotationCurveOccurrence.
/// 
/// NOTE  Corresponding ISO 10303 name: curve_style. Please refer to ISO/IS 10303-46:1994 for the final definition of the formal standard.
/// 
/// HISTORY  New entity in IFC2x2.
class IFC_PARSE_API IfcCurveStyle : public IfcPresentationStyle {
public:
    /// Whether the optional attribute CurveFont is defined for this IfcCurveStyle
    bool hasCurveFont() const;
    /// A curve style font which is used to present a curve. It can either be a predefined curve font, or an explicitly defined curve font. Both may be scaled. If not given, then the curve font should be taken from the layer assignment with style, if that is not given either, then the default curve font applies.
    ::Ifc2x3::IfcCurveFontOrScaledCurveFontSelect* CurveFont() const;
    void setCurveFont(::Ifc2x3::IfcCurveFontOrScaledCurveFontSelect* v);
    /// Whether the optional attribute CurveWidth is defined for this IfcCurveStyle
    bool hasCurveWidth() const;
    /// A positive length measure in units of the presentation area for the width of a presented curve. If not given, then the style should be taken from the layer assignment with style, if that is not given either, then the default style applies.
    ::Ifc2x3::IfcSizeSelect* CurveWidth() const;
    void setCurveWidth(::Ifc2x3::IfcSizeSelect* v);
    /// Whether the optional attribute CurveColour is defined for this IfcCurveStyle
    bool hasCurveColour() const;
    /// The colour of the visible part of the curve. If not given, then the colour should be taken from the layer assignment with style, if that is not given either, then the default colour applies.
    ::Ifc2x3::IfcColour* CurveColour() const;
    void setCurveColour(::Ifc2x3::IfcColour* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcCurveStyle (IfcEntityInstanceData* e);
    IfcCurveStyle (boost::optional< std::string > v1_Name, ::Ifc2x3::IfcCurveFontOrScaledCurveFontSelect* v2_CurveFont, ::Ifc2x3::IfcSizeSelect* v3_CurveWidth, ::Ifc2x3::IfcColour* v4_CurveColour);
    typedef IfcTemplatedEntityList< IfcCurveStyle > list;
};
/// IfcDerivedProfileDef defines the profile by transformation from the parent profile. The transformation is given by a two dimensional transformation operator. Transformation includes translation, rotation, mirror and scaling. The latter can be uniform or non uniform. The derived profiles may be used to define swept surfaces, swept area solids or sectioned spines.
/// 
/// The transformation effects the position, rotation, mirroring or scale of the profile at the underlying coordinate system, i.e. the coordinate system defined by the swept surface or swept area solid that uses the profile definition. It is the xy plane of either: 
/// 
/// IfcSweptSurface.Position
///   IfcSweptAreaSolid.Position
/// 
/// or in case of sectioned spines the xy plane of each list member of IfcSectionedSpine.CrossSectionPositions. The position and potential rotation of the ParentProfile within the underlying coordinate system is taken into consideration before applying the Cartesian transformation operator.
/// 
/// Note, if only mirroring is required, IfcMirroredProfileDef should be used instead.
/// 
/// HISTORY: New entity in IFC Release 2x.
/// 
/// Figure 316 illustrates examples of derived profiles.
/// 
/// Parameter
/// The IfcDerivedProfileDef
/// is defined using the IfcCartesianTransformationOperator2D
/// (CTO), which is applied to the parent profile definition. 
/// 
/// Example
/// The example shows an uniform scaling and a transformation
/// of an IfcRectangleProfileDef
/// to match the lower-left cardinal point. The attributes of the CTO are:
/// 
/// Axis1 = NIL (defaults to 1.,0.)
///   Axis2 = NIL (defaults to 0.,1.)
///   LocalOrigin = IfcCartesianPoint(,)
///   Scale = 2.
/// 
/// Note: The ParentProfile has a Position
/// = IfcCartesianPoint(,) already.
/// 
/// Parameter
/// The IfcDerivedProfileDef is defined using
/// non uniform transformationsby applying the IfcCartesianTransformationOperator2DnonUniform
/// as a subtype of the 2D CTO.
/// 
/// Example
/// The example shows a non-uniform scaling and a translation of an IfcRectangleProfileDef
/// to match the lower-left cardinal point. The attributes of the CTO are:
/// 
/// Axis1 = NIL (defaults to 1.,0.)
///   Axis2 = NIL (defaults to 0.,1.)
///   LocalOrigin = IfcCartesianPoint(0.,<1/2 YDim)
///   Scale  = 1.
///   Scale2 = 2.
/// 
/// Note: The ParentProfile has a Position
/// = IfcCartesianPoint(,) already.
/// 
/// Parameter
/// The IfcDerivedProfileDef
/// is defined using mirroring by applying the IfcCartesianTransformationOperator2D
/// (CTO) to the parent profile.
/// 
/// Example
/// The example shows a mirroring of an IfcLShapeProfileDef
/// to match the centre cardinal point. The attributes of the CTO are:
/// 
/// Axis1 = (-1.,0.)
///   Axis2 = NIL (defaults to 0.,1.)
///   LocalOrigin = IfcCartesianPoint(0.,0.)
///   Scale = NIL (defaults to 1.)
/// 
/// Note: The ParentProfile has a Position = IfcCartesianPoint(0.,0.).
/// 
/// This example is for illustration only.
/// If the transformation results only in mirroring like shown in the example, then
/// IfcMirroredProfileDef should be used instead of IfcDerivedProfileDef.
/// 
/// Note: The following color map applies:
/// 
/// black coordinate axes show the
///   underlying coordinate system of the swept surface, swept area solid, or
///   sectioned spine
/// 
/// red coordinate axes
///   show the position coordinate system of the parent profile
/// 
/// brown coordinate axes
///   show the position coordinate system of the derived profile
/// 
/// Figure 316 — Derived profile
class IFC_PARSE_API IfcDerivedProfileDef : public IfcProfileDef {
public:
    /// The parent profile provides the origin of the transformation.
    ::Ifc2x3::IfcProfileDef* ParentProfile() const;
    void setParentProfile(::Ifc2x3::IfcProfileDef* v);
    /// Transformation operator applied to the parent profile.
    ::Ifc2x3::IfcCartesianTransformationOperator2D* Operator() const;
    void setOperator(::Ifc2x3::IfcCartesianTransformationOperator2D* v);
    /// Whether the optional attribute Label is defined for this IfcDerivedProfileDef
    bool hasLabel() const;
    /// The name by which the transformation may be referred to. The actual meaning of the name has to be defined in the context of applications.
    std::string Label() const;
    void setLabel(std::string v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcDerivedProfileDef (IfcEntityInstanceData* e);
    IfcDerivedProfileDef (::Ifc2x3::IfcProfileTypeEnum::Value v1_ProfileType, boost::optional< std::string > v2_ProfileName, ::Ifc2x3::IfcProfileDef* v3_ParentProfile, ::Ifc2x3::IfcCartesianTransformationOperator2D* v4_Operator, boost::optional< std::string > v5_Label);
    typedef IfcTemplatedEntityList< IfcDerivedProfileDef > list;
};

class IFC_PARSE_API IfcDimensionCalloutRelationship : public IfcDraughtingCalloutRelationship {
public:
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcDimensionCalloutRelationship (IfcEntityInstanceData* e);
    IfcDimensionCalloutRelationship (boost::optional< std::string > v1_Name, boost::optional< std::string > v2_Description, ::Ifc2x3::IfcDraughtingCallout* v3_RelatingDraughtingCallout, ::Ifc2x3::IfcDraughtingCallout* v4_RelatedDraughtingCallout);
    typedef IfcTemplatedEntityList< IfcDimensionCalloutRelationship > list;
};

class IFC_PARSE_API IfcDimensionPair : public IfcDraughtingCalloutRelationship {
public:
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcDimensionPair (IfcEntityInstanceData* e);
    IfcDimensionPair (boost::optional< std::string > v1_Name, boost::optional< std::string > v2_Description, ::Ifc2x3::IfcDraughtingCallout* v3_RelatingDraughtingCallout, ::Ifc2x3::IfcDraughtingCallout* v4_RelatedDraughtingCallout);
    typedef IfcTemplatedEntityList< IfcDimensionPair > list;
};
/// An IfcDocumentReference is a reference 
/// to the location of a document. The reference is given by a system 
/// interpretable Location attribute (a URL string) where the document can be found, and an optional inherited
///   internal reference Identification, which refers to a system
///   interpretable position within the document. The optional inherited
/// Name attribute is meant to have meaning for human readers. Optional 
/// document metadata can also be captured through reference to 
/// IfcDocumentInformation.
/// 
/// HISTORY: New Entity in IFC Release 2.0.
///   Modified in IFC 2x.
class IFC_PARSE_API IfcDocumentReference : public IfcExternalReference {
public:
        IfcTemplatedEntityList< IfcDocumentInformation >::ptr ReferenceToDocument() const; // INVERSE IfcDocumentInformation::DocumentReferences
    virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcDocumentReference (IfcEntityInstanceData* e);
    IfcDocumentReference (boost::optional< std::string > v1_Location, boost::optional< std::string > v2_ItemReference, boost::optional< std::string > v3_Name);
    typedef IfcTemplatedEntityList< IfcDocumentReference > list;
};
/// The draughting pre defined text font is a pre defined text font for the purpose to identify a font by name. Allowable names are:
/// 
/// 'ISO 3098-1 font A',
///   'ISO 3098-1 font B',
/// 
/// The ISO 3098-1 font A is the text font as denoted as Letterng A in clause 3 of ISO 3098-1, the ISO 3098-1 font B is the text font as denoted as Letterng B in clause 3 of ISO 3098-1.
/// 
/// NOTE  The IfcDraughtingPreDefinedTextFont is an entity that had been adopted from ISO 10303, Industrial automation systems and integration—Product data representation and exchange, Part 202: Application protocol: Associative draughting. Corresponding ISO 10303 name: draughting_pre_defined_text_font. Please refer to ISO/IS 10303-202:1994 page 196 for the final definition of the formal standard.
/// 
/// HISTORY  New entity in IFC2x2.
class IFC_PARSE_API IfcDraughtingPreDefinedTextFont : public IfcPreDefinedTextFont {
public:
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcDraughtingPreDefinedTextFont (IfcEntityInstanceData* e);
    IfcDraughtingPreDefinedTextFont (std::string v1_Name);
    typedef IfcTemplatedEntityList< IfcDraughtingPreDefinedTextFont > list;
};
/// Definition from ISO/CD 10303-42:1992: An edge is the
/// topological construct corresponding to the connection of two
/// vertices. More abstractly, it may stand for a logical
/// relationship between two vertices. The domain of an edge, if
/// present, is a finite, non-self-intersecting open curve in
/// RM, that is, a connected 1-dimensional
/// manifold. The bounds of an edge are two vertices, which need not
/// be distinct. The edge is oriented by choosing its traversal
/// direction to run from the first to the second vertex. If the two
/// vertices are the same, the edge is a self loop. The domain of the
/// edge does not include its bounds, and 0 ≤ Ξ ≤ ∞.
/// Associated with an edge may be a geometric curve to locate the
/// edge in a coordinate space; this is represented by the edge curve
/// (IfcEdgeCurve) subtype. The curve shall be finite and
/// non-self-intersecting within the domain of the edge. An edge is a
/// graph, so its multiplicity M and graph genus Ge
/// may be determined by the graph traversal algorithm. Since
/// M = E = 1, the Euler equation (1) reduces in the
/// case to
/// 
/// where V = 1 or 2, and Ge = 1 or 0.
/// Specifically, the topological edge defining data shall
/// satisfy:
/// 
/// - an edge has two vertices
/// 
/// - the vertices need not be distinct
/// 
/// - Equation (2) shall hold.
/// 
/// The geometry between the two
/// vertices defaults to a straight line if no curve geometry is
/// assigned using the subtype IfcEdgeCurve. The
/// IfcEdge can therefore be used to exchange straight edges
/// without an associated geometry provided by IfcLine or
/// IfcPolyline thought IfcEdgeCurve.EdgeGeometry.
/// 
/// Figure 333 illustrates an example where the bounds of the IfcEdge are given by the EdgeStart and EdgeEnd; this also determines the direction of the edge. The location within a coordinate space is determined by the IfcVertexPoint type for EdgeStart and EdgeEnd. Since no edge geometry is assigned, it defaults to a straight line agreeing to the direction sense.
/// 
/// Figure 333 — Edge representation
/// 
/// NOTE  Corresponding ISO 10303 entity: edge. Please refer to ISO/IS 10303-42:1994, p. 130 for the final definition of the formal standard.
/// 
/// HISTORY  New Entity in IFC Release 2.0
/// 
/// Informal propositions:
/// 
/// The edge has dimensionality 1.
/// The extend of an edge shall be finite and nonzero.
class IFC_PARSE_API IfcEdge : public IfcTopologicalRepresentationItem {
public:
    /// Start point (vertex) of the edge.
    ::Ifc2x3::IfcVertex* EdgeStart() const;
    void setEdgeStart(::Ifc2x3::IfcVertex* v);
    /// End point (vertex) of the edge. The same vertex can be used for both EdgeStart and EdgeEnd.
    ::Ifc2x3::IfcVertex* EdgeEnd() const;
    void setEdgeEnd(::Ifc2x3::IfcVertex* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcEdge (IfcEntityInstanceData* e);
    IfcEdge (::Ifc2x3::IfcVertex* v1_EdgeStart, ::Ifc2x3::IfcVertex* v2_EdgeEnd);
    typedef IfcTemplatedEntityList< IfcEdge > list;
};
/// Definition from ISO/CD 10303-42:1992: An edge curve is
/// a special subtype of edge which has its geometry fully defined.
/// The geometry is defined by associating the edge with a curve
/// which may be unbounded. As the topological and geometric
/// directions may be opposed, an indicator (same sense) is used to
/// identify whether the edge and curve directions agree or are
/// opposed. The Boolean value indicates whether the curve direction
/// agrees with (TRUE) or is in the opposite direction (FALSE) to the
/// edge direction. Any geometry associated with the vertices of the
/// edge shall be consistent with the edge geometry. Multiple edges
/// can reference the same curve.
/// 
/// Figure 334 illustrates an example where the edge geometry is given by an unbounded curve, here IfcCircle. The bounds are provided by the EdgeStart and EdgeEnd, the topological direction of the IfcEdgeCurve opposes the direction of the IfcCircle by SameSense = FALSE.
/// 
/// Figure 334 — Edge curve
/// 
/// NOTE  Corresponding ISO 10303 entity: edge_curve. Please refer to ISO/IS 10303-42:1994, p. 132
/// for the final definition of the formal standard. Due to the general IFC model specification rule not to use multiple inheritance, the subtype relationship to geometric_representation_item is not included.
/// 
/// <blockquote class="history"
/// HISTORY  New Entity in IFC2x.
/// 
/// Informal propositions:
/// 
/// The domain of the edge curve is formally defined to be the
/// domain of its edge geometry as trimmed by the vertices. This
/// domain does not include the vertices.
/// An edge curve has non-zero finite extent.
/// An edge curve is a manifold.
/// An edge curve is arcwise connected.
/// The edge start is not a part of the edge domain.
/// The edge end is not a part of the edge domain.
/// Vertex geometry shall be consistent with edge geometry.
class IFC_PARSE_API IfcEdgeCurve : public IfcEdge {
public:
    /// The curve which defines the shape and spatial location of the edge. This curve may be unbounded and is implicitly trimmed by the vertices of the edge; this defines the edge domain. Multiple edges can reference the same curve.
    ::Ifc2x3::IfcCurve* EdgeGeometry() const;
    void setEdgeGeometry(::Ifc2x3::IfcCurve* v);
    /// This logical flag indicates whether (TRUE), or not (FALSE) the senses of the edge and the curve defining the edge geometry are the same. The sense of an edge is from the edge start vertex to the edge end vertex; the sense of a curve is in the direction of increasing parameter.
    bool SameSense() const;
    void setSameSense(bool v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcEdgeCurve (IfcEntityInstanceData* e);
    IfcEdgeCurve (::Ifc2x3::IfcVertex* v1_EdgeStart, ::Ifc2x3::IfcVertex* v2_EdgeEnd, ::Ifc2x3::IfcCurve* v3_EdgeGeometry, bool v4_SameSense);
    typedef IfcTemplatedEntityList< IfcEdgeCurve > list;
};
/// The IfcExtendedMaterialProperties assign a set of
/// defined material properties to associated material definitions.
/// This provides a mechanism to assign any material properties to
/// material. Those material properties that are defined as part of the
/// IFC specification are provided within the use definitions
/// below.
/// NOTE The usage of this entity has changed in
/// IFC2x4, it is now used to express all material
/// properties.
/// The IfcProperty (instantiable subtypes) is used to
/// express the individual material properties.
/// 
/// HISTORY  New entity in Release IFC2x.
/// 
/// IFC2x4 CHANGE  The attributes Name and Description are promoted to supertype,
/// attribute ExtendedProperties has been renamed to Properties.
/// 
/// Extended property use definitions
/// The following sets of material property definitions are part of
/// this IFC release:
/// 
/// General Material Properties
/// General Mechanical Properties
/// 
/// Steel Mechanical Properties
/// Concrete Mechanical Properties
/// Timber and Wood-based Mechanical Properties
/// 
/// General Thermal Properties
/// General Hygroscopic Properties
/// General Optical Properties
/// General Water Properties
/// General Fuel Properties
/// General Products of Combustion Properties
/// General Energy Calculation Properties
class IFC_PARSE_API IfcExtendedMaterialProperties : public IfcMaterialProperties {
public:
    IfcTemplatedEntityList< ::Ifc2x3::IfcProperty >::ptr ExtendedProperties() const;
    void setExtendedProperties(IfcTemplatedEntityList< ::Ifc2x3::IfcProperty >::ptr v);
    /// Whether the optional attribute Description is defined for this IfcExtendedMaterialProperties
    bool hasDescription() const;
    std::string Description() const;
    void setDescription(std::string v);
    std::string Name() const;
    void setName(std::string v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcExtendedMaterialProperties (IfcEntityInstanceData* e);
    IfcExtendedMaterialProperties (::Ifc2x3::IfcMaterial* v1_Material, IfcTemplatedEntityList< ::Ifc2x3::IfcProperty >::ptr v2_ExtendedProperties, boost::optional< std::string > v3_Description, std::string v4_Name);
    typedef IfcTemplatedEntityList< IfcExtendedMaterialProperties > list;
};
/// Definition from ISO/CD 10303-42:1992: A face is a topological
///   entity of dimensionality 2 corresponding to the intuitive notion of a piece of
///   surface bounded by loops. Its domain, if present, is an oriented, connected,
///   finite 2-manifold in Rm. A face domain shall not have handles
///   but it may have holes, each hole bounded by a loop. The domain of the
///   underlying geometry of the face, if present, does not contain its bounds, and 0
///   < Ξ < ∞. 
///   A face is represented by its bounding loops, which are defined as face
///   bounds. A face has a topological normal n and the tangent to a loop is t. For a
///   loop bounding a face with defined geometry, the cross product n x t points
///   toward the interior of the face. That is, each loop runs counter-clockwise
///   around the face when viewed from above, if we consider the normal n to point
///   up. With each loop is associated a BOOLEAN flag to signify whether the loop
///   direction is oriented with respect to the face normal (TRUE) or should be
///   reversed (FALSE).  
///   A face shall have at least one bound, and the loops shall not intersect.
///   One loop is optionally distinguished as the outer loop of the face. If so, it
///   establishes a preferred way of embedding the face domain in the plane, in which
///   the other bounding loops of the face are inside the outer bound. Because the
///   face domain is arcwise connected, no inner loop will contain any other loop.
///   This is true regardless of which embedding in the plane is chosen.  
///   The edges and vertices referenced by the loops of a face form a graph,
///   of which the individual loops are the connected components. The Euler equation
///   (1) for this graph becomes: 
/// 
/// where Gli is the graph genus of the
///   i th loop. 
/// 
/// NOTE  Corresponding ISO 10303 entity: face. No subtypes of face have been incorporated
///   into this IFC Release. Please refer to ISO/IS 10303-42:1994, p. 140 for the
///   final definition of the formal standard. The WR1 has not been incorporated,
///   since it is always satisfied, due to the fact that only poly loops exist for
///   face bounds.
/// 
/// HISTORY  New class in IFC Release 1.0
/// 
/// Informal propositions: 
/// 
/// No edge shall be referenced by the face more than twice.  
///   Distinct face bounds of the face shall have no common vertices. 
///   If geometry is present, distinct loops of the same face shall not
///   intersect.  
///   The face shall satisfy the Euler Equation: (number of vertices) -
///   (number of edges) - (number of loops) + (sum of genus for loops) = 0.
class IFC_PARSE_API IfcFace : public IfcTopologicalRepresentationItem {
public:
    /// Boundaries of the face.
    IfcTemplatedEntityList< ::Ifc2x3::IfcFaceBound >::ptr Bounds() const;
    void setBounds(IfcTemplatedEntityList< ::Ifc2x3::IfcFaceBound >::ptr v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcFace (IfcEntityInstanceData* e);
    IfcFace (IfcTemplatedEntityList< ::Ifc2x3::IfcFaceBound >::ptr v1_Bounds);
    typedef IfcTemplatedEntityList< IfcFace > list;
};
/// Definition from ISO/CD 10303-42:1992: A face bound is a loop which is intended to be used for bounding a face.  
/// 
/// NOTE  Corresponding ISO 10303 entity: face_bound. Please refer to ISO/IS 10303-42:1994, p. 139 for the final definition of the formal standard.
/// 
/// HISTORY  New class in IFC Release 1.0
class IFC_PARSE_API IfcFaceBound : public IfcTopologicalRepresentationItem {
public:
    /// The loop which will be used as a face boundary.
    ::Ifc2x3::IfcLoop* Bound() const;
    void setBound(::Ifc2x3::IfcLoop* v);
    /// This indicated whether (TRUE) or not (FALSE) the loop has the same sense when used to bound the face as when first defined. If sense is FALSE the senses of all its component oriented edges are implicitly reversed when used in the face.
    bool Orientation() const;
    void setOrientation(bool v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcFaceBound (IfcEntityInstanceData* e);
    IfcFaceBound (::Ifc2x3::IfcLoop* v1_Bound, bool v2_Orientation);
    typedef IfcTemplatedEntityList< IfcFaceBound > list;
};
/// Definition from ISO/CD 10303-42:1992: A face outer bound is a special subtype of face bound which carries the additional semantics of defining an outer boundary on the face. No more than one boundary of a face shall be of this type.  
/// 
/// NOTE Corresponding ISO 10303 entity: face_outer_bound. Please refer to ISO/IS 10303-42:1994, p. 139 for the final definition of the formal standard.
/// 
/// HISTORY New class in IFC Release 1.0
class IFC_PARSE_API IfcFaceOuterBound : public IfcFaceBound {
public:
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcFaceOuterBound (IfcEntityInstanceData* e);
    IfcFaceOuterBound (::Ifc2x3::IfcLoop* v1_Bound, bool v2_Orientation);
    typedef IfcTemplatedEntityList< IfcFaceOuterBound > list;
};
/// Definition from ISO/CD 10303-42:1992: A face surface
///   (IfcFaceSurface) is a subtype of face in which the geometry is defined by an
///   associated surface. The portion of the surface used by the face shall be
///   embeddable in the plane as an open disk, possibly with holes. However, the
///   union of the face with the edges and vertices of its bounding loops need not be
///   embeddable in the plane. It may, for example, cover an entire sphere or torus.
///   As both a face and a geometric surface have defined normal directions, a
///   BOOLEAN flag (the orientation attribute) is used to indicate whether the
///   surface normal agrees with (TRUE) or is opposed to (FALSE) the face normal
///   direction. The geometry associated with any component of the loops of the face
///   shall be consistent with the surface geometry, in the sense that the domains of
///   all the vertex points and edge curves are contained in the face geometry
///   surface. A surface may be referenced by more than one face surface. 
/// 
/// NOTE  Corresponding ISO 10303 entity:
///   face_surface. Please refer to ISO/IS 10303-42:1994, p. 204 for the final
///   definition of the formal standard. Due to the general IFC model specification
///   rule not to use multiple inheritance, the subtype relationship to
///   geometric_representation_item is not included.
/// 
/// HISTORY  New class in IFC2x
/// 
/// Informal propositions: 
/// 
/// The domain of the face surface is formally defined to be the domain
///   of its face geometry as trimmed by the loops, this domain does not include the
///   bounding loops. 
///   A face surface has non zero finite extent. 
///   A face surface is a manifold. 
///   A face surface is arcwise connected. 
///   A face surface has surface genus 0.
///   The loops are not part of the face domain.
///   Loop geometry shall be consistent with face geometry. This implies
///   that any edge - curves or vertex points used in defining the loops bounding the
///   face surface shall lie on the face geometry.
///   The loops of the face shall not intersect.
class IFC_PARSE_API IfcFaceSurface : public IfcFace {
public:
    /// The surface which defines the internal shape of the face. This surface may be unbounded. The domain of the face is defined by this surface and the bounding loops in the inherited attribute SELF\FaceBounds.
    ::Ifc2x3::IfcSurface* FaceSurface() const;
    void setFaceSurface(::Ifc2x3::IfcSurface* v);
    /// This flag indicates whether the sense of the surface normal agrees with (TRUE), or opposes (FALSE), the sense of the topological normal to the face.
    bool SameSense() const;
    void setSameSense(bool v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcFaceSurface (IfcEntityInstanceData* e);
    IfcFaceSurface (IfcTemplatedEntityList< ::Ifc2x3::IfcFaceBound >::ptr v1_Bounds, ::Ifc2x3::IfcSurface* v2_FaceSurface, bool v3_SameSense);
    typedef IfcTemplatedEntityList< IfcFaceSurface > list;
};
/// Definition from IAI: Defines forces at which a support or connection fails.
/// 
/// Applicability:
/// 
/// Point supports and connections.
/// 
/// HISTORY: New entity in IFC 2x2.
class IFC_PARSE_API IfcFailureConnectionCondition : public IfcStructuralConnectionCondition {
public:
    /// Whether the optional attribute TensionFailureX is defined for this IfcFailureConnectionCondition
    bool hasTensionFailureX() const;
    /// Tension force in x-direction leading to failure of the connection.
    double TensionFailureX() const;
    void setTensionFailureX(double v);
    /// Whether the optional attribute TensionFailureY is defined for this IfcFailureConnectionCondition
    bool hasTensionFailureY() const;
    /// Tension force in y-direction leading to failure of the connection.
    double TensionFailureY() const;
    void setTensionFailureY(double v);
    /// Whether the optional attribute TensionFailureZ is defined for this IfcFailureConnectionCondition
    bool hasTensionFailureZ() const;
    /// Tension force in z-direction leading to failure of the connection.
    double TensionFailureZ() const;
    void setTensionFailureZ(double v);
    /// Whether the optional attribute CompressionFailureX is defined for this IfcFailureConnectionCondition
    bool hasCompressionFailureX() const;
    /// Compression force in x-direction leading to failure of the connection.
    double CompressionFailureX() const;
    void setCompressionFailureX(double v);
    /// Whether the optional attribute CompressionFailureY is defined for this IfcFailureConnectionCondition
    bool hasCompressionFailureY() const;
    /// Compression force in y-direction leading to failure of the connection.
    double CompressionFailureY() const;
    void setCompressionFailureY(double v);
    /// Whether the optional attribute CompressionFailureZ is defined for this IfcFailureConnectionCondition
    bool hasCompressionFailureZ() const;
    /// Compression force in z-direction leading to failure of the connection.
    double CompressionFailureZ() const;
    void setCompressionFailureZ(double v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcFailureConnectionCondition (IfcEntityInstanceData* e);
    IfcFailureConnectionCondition (boost::optional< std::string > v1_Name, boost::optional< double > v2_TensionFailureX, boost::optional< double > v3_TensionFailureY, boost::optional< double > v4_TensionFailureZ, boost::optional< double > v5_CompressionFailureX, boost::optional< double > v6_CompressionFailureY, boost::optional< double > v7_CompressionFailureZ);
    typedef IfcTemplatedEntityList< IfcFailureConnectionCondition > list;
};
/// Definition from ISO/CD 10303-46:1992: The style for filling visible curve segments, annotation fill areas or surfaces with tiles or hatches.
/// 
/// An IfcFillAreaStyle provides the style table for presentation information assigned to annotation fill areas or surfaces for hatching and tiling. The IfcFillAreaStyle defines hatches as model hatches, that is, the distance between hatch lines, or the curve patterns of hatch lines are given in model space dimensions (that have to be scaled using the target plot scale). The IfcFillAreaStyle allows for the following combinations of defining the style of hatching and tiling:
/// 
/// Solid fill for areas and surfaces by only assigning IfcColour to the set of FillStyles. It then provides the background colour for the filled area or surface.
/// 
/// NOTE  Color information of surfaces for rendering is assigned by using IfcSurfaceStyle, not by using IfcFillAreaStyle.
/// 
/// Vector based hatching for areas and surfaces based on a single row of hatch lines by assigning a single instance of IfcFillAreaStyleHatching to the set of FillStyles.  If an instance of IfcColour is assigned in addition to the set of FillStyles, it provides the background colour for the hatching.  Vector based hatching for areas and surfaces based on two (potentially crossing) rows of hatch lines by assigning two instances of IfcFillAreaStyleHatching to the set of FillStyles. 
/// 
/// If an instance of IfcColour is assigned in addition to the set of FillStyles, it provides the background colour for the hatching. 
/// 
/// NOTE  Assigning more then two instances of IfcFillAreaStyleHatching to define three or more rows of hatch lines is not encouraged.
/// 
/// Tiling for areas and surfaces by assigning a single instance of IfcFillAreaStyleTiles to the set of FillStyles.  If an instance of IfcColour is assigned in addition to the set of FillStyles, it provides the background colour for the tiling. 
/// 
/// IFC2x3 NOTE  The use of IfcFillAreaStyleTiles is discouraged., as its definition might change is future releases.
/// 
/// Externally defined hatch style by assigning a single instance of IfcExternallyDefinedHatchStyle to the set of FillStyles. 
///   If an instance of IfcColour is assigned in addition to the set of FillStyles, it provides the background colour for the hatching.
/// 
/// Measures given to a hatch or tile pattern are given in global drawing length units.
/// 
/// NOTE  Global units are defined at the single IfcProject instance, given by UnitsInContext:IfcUnitAssignment, the same units are used for the geometric representation items and for the style definitions.
/// 
/// The measure values for hatch or tile pattern apply to the model space with a target plot scale provided for the correct appearance in the default plot scale. For different scale and projection dependent fill area styles a different instance of IfcFillAreaStyle needs to be used by IfcPresentationStyleAssignment for different IfcGeometricRepresentationSubContext dependent representations.
/// 
/// NOTE  the target plot scale is given by IfcGeometricRepresentationSubContext.TargetScale.
/// 
/// An IfcFillAreaStyle can be assigned to IfcFillArea via the IfcPresentationStyleAssignment through an intermediate IfcStyledItem or subtype IfcAnnotationFillAreaOccurrence.
/// 
/// NOTE  Corresponding ISO 10303 name: fill_area_style. Please refer to ISO/IS 10303-46:1994 for the final definition of the formal standard.
/// 
/// HISTORY  New entity in IFC2x2.
class IFC_PARSE_API IfcFillAreaStyle : public IfcPresentationStyle {
public:
    /// The set of fill area styles to use in presenting visible curve segments, annotation fill areas or surfaces.
    IfcEntityList::ptr FillStyles() const;
    void setFillStyles(IfcEntityList::ptr v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcFillAreaStyle (IfcEntityInstanceData* e);
    IfcFillAreaStyle (boost::optional< std::string > v1_Name, IfcEntityList::ptr v2_FillStyles);
    typedef IfcTemplatedEntityList< IfcFillAreaStyle > list;
};

class IFC_PARSE_API IfcFuelProperties : public IfcMaterialProperties {
public:
    /// Whether the optional attribute CombustionTemperature is defined for this IfcFuelProperties
    bool hasCombustionTemperature() const;
    double CombustionTemperature() const;
    void setCombustionTemperature(double v);
    /// Whether the optional attribute CarbonContent is defined for this IfcFuelProperties
    bool hasCarbonContent() const;
    double CarbonContent() const;
    void setCarbonContent(double v);
    /// Whether the optional attribute LowerHeatingValue is defined for this IfcFuelProperties
    bool hasLowerHeatingValue() const;
    double LowerHeatingValue() const;
    void setLowerHeatingValue(double v);
    /// Whether the optional attribute HigherHeatingValue is defined for this IfcFuelProperties
    bool hasHigherHeatingValue() const;
    double HigherHeatingValue() const;
    void setHigherHeatingValue(double v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcFuelProperties (IfcEntityInstanceData* e);
    IfcFuelProperties (::Ifc2x3::IfcMaterial* v1_Material, boost::optional< double > v2_CombustionTemperature, boost::optional< double > v3_CarbonContent, boost::optional< double > v4_LowerHeatingValue, boost::optional< double > v5_HigherHeatingValue);
    typedef IfcTemplatedEntityList< IfcFuelProperties > list;
};

class IFC_PARSE_API IfcGeneralMaterialProperties : public IfcMaterialProperties {
public:
    /// Whether the optional attribute MolecularWeight is defined for this IfcGeneralMaterialProperties
    bool hasMolecularWeight() const;
    double MolecularWeight() const;
    void setMolecularWeight(double v);
    /// Whether the optional attribute Porosity is defined for this IfcGeneralMaterialProperties
    bool hasPorosity() const;
    double Porosity() const;
    void setPorosity(double v);
    /// Whether the optional attribute MassDensity is defined for this IfcGeneralMaterialProperties
    bool hasMassDensity() const;
    double MassDensity() const;
    void setMassDensity(double v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcGeneralMaterialProperties (IfcEntityInstanceData* e);
    IfcGeneralMaterialProperties (::Ifc2x3::IfcMaterial* v1_Material, boost::optional< double > v2_MolecularWeight, boost::optional< double > v3_Porosity, boost::optional< double > v4_MassDensity);
    typedef IfcTemplatedEntityList< IfcGeneralMaterialProperties > list;
};

class IFC_PARSE_API IfcGeneralProfileProperties : public IfcProfileProperties {
public:
    /// Whether the optional attribute PhysicalWeight is defined for this IfcGeneralProfileProperties
    bool hasPhysicalWeight() const;
    double PhysicalWeight() const;
    void setPhysicalWeight(double v);
    /// Whether the optional attribute Perimeter is defined for this IfcGeneralProfileProperties
    bool hasPerimeter() const;
    double Perimeter() const;
    void setPerimeter(double v);
    /// Whether the optional attribute MinimumPlateThickness is defined for this IfcGeneralProfileProperties
    bool hasMinimumPlateThickness() const;
    double MinimumPlateThickness() const;
    void setMinimumPlateThickness(double v);
    /// Whether the optional attribute MaximumPlateThickness is defined for this IfcGeneralProfileProperties
    bool hasMaximumPlateThickness() const;
    double MaximumPlateThickness() const;
    void setMaximumPlateThickness(double v);
    /// Whether the optional attribute CrossSectionArea is defined for this IfcGeneralProfileProperties
    bool hasCrossSectionArea() const;
    double CrossSectionArea() const;
    void setCrossSectionArea(double v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcGeneralProfileProperties (IfcEntityInstanceData* e);
    IfcGeneralProfileProperties (boost::optional< std::string > v1_ProfileName, ::Ifc2x3::IfcProfileDef* v2_ProfileDefinition, boost::optional< double > v3_PhysicalWeight, boost::optional< double > v4_Perimeter, boost::optional< double > v5_MinimumPlateThickness, boost::optional< double > v6_MaximumPlateThickness, boost::optional< double > v7_CrossSectionArea);
    typedef IfcTemplatedEntityList< IfcGeneralProfileProperties > list;
};
/// Definition from ISO/CD 10303-42:1992: A geometric
/// representation context is a representation context in which the
/// geometric representation items are geometrically founded. A
/// geometric representation context is a distinct coordinate space,
/// spatially unrelated to other coordinate spaces.
/// 
/// IfcGeometricRepresentationContext defines the context that
/// applies to several shape representations of products within a
/// project. It defines the type of the context in which the shape
/// representation is defined, and the numeric precision applicable
/// to the geometric representation items defined in this context. In
/// addition it can be used to offset the project coordinate system
/// from a global point of origin, using the
/// WorldCoordinateSystem attribute.
/// 
/// As shown in Figure 329, the TrueNorth attribute should be provided if the y axis of the WorldCoordinateSystem does not point to the global northing. Direction of the true north, or geographic northing direction, relative to the underlying project coordinate
/// system as established by the attribute WorldCoordinateSystem. It is given by a 2 dimensional direction within the xy-plane of the project coordinate system. If not resent, it defaults to [0.,1.] - i.e. the positive Y axis of the project coordinate system equals the geographic northing direction. The direction is provided within project coordinate system and identifies the true north direction (see
/// figure).
/// 
/// Figure 329 — Geometric representation context true north
/// 
/// NOTE ÿThe inherited attribute
/// ContextType shall have one of the following recognized
/// values: 'Sketch', 'Outline', 'Design', 'Detail',
/// 'Model', 'Plan',
/// 'NotDefined'.
/// 
/// The use of one instance of
/// IfcGeometricRepresentationContext to represent the model
/// (3D) view is mandatory, the use of a second instance of
/// IfcGeometricRepresentationContext to represent the plan
/// (2D) view is optional (but needs to be given, if there are scale
/// dependent plan views), the additional scale or view dependent
/// contexts need to be handled by using the subtype
/// IfcGeometricRepresentationSubContext pointing to the model
/// view (or the plan view) as the ParentContext.
/// 
/// Figure 330 illustrates use of representation contexts defined at IfcProject for 3D model and 2D plan context, including sub
/// context definitions for different target scales.
/// 
/// Figure 330 — Geometric representation context use
/// 
/// NOTE  The definition of this class relates to the ISO 10303 entity geometric_representation_context. Please refer to ISO/IS 10303-42:1994 for the final definition of the formal standard.
/// 
/// HISTORY ÿNew Entity in IFC Release 2.0
/// 
/// IFC2x3 CHANGE ÿApplicable values for ContextType are only 'Model',ÿ 'Plan', andÿ'NotDefined'. All other sub contexts are now handled by the new subtype in IFC2x Edition 2 IfcGeometricRepresentationSubContext. Upward compatibility for file based exchange is guaranteed.
class IFC_PARSE_API IfcGeometricRepresentationContext : public IfcRepresentationContext {
public:
    /// The integer dimension count of the coordinate space modeled in a geometric representation context.
    int CoordinateSpaceDimension() const;
    void setCoordinateSpaceDimension(int v);
    /// Whether the optional attribute Precision is defined for this IfcGeometricRepresentationContext
    bool hasPrecision() const;
    /// Value of the model precision for geometric models. It is a double value (REAL), typically in 1E-5 to 1E-8 range, that indicates the tolerance under which two given points are still assumed to be identical. The value can be used e.g. to sets the maximum distance from an edge curve to the underlying face surface in brep models.
    double Precision() const;
    void setPrecision(double v);
    /// Establishment of the engineering coordinate system (often referred to as the world coordinate system in CAD) for all representation contexts used by the project. 
    /// 
    /// Note  it can be used to provide better numeric stability if the placement of the building(s) is far away from the origin. In most cases however it would be set to origin: (0.,0.,0.) and directions x(1.,0.,0.), y(0.,1.,0.), z(0.,0.,1.).
    ::Ifc2x3::IfcAxis2Placement* WorldCoordinateSystem() const;
    void setWorldCoordinateSystem(::Ifc2x3::IfcAxis2Placement* v);
    /// Whether the optional attribute TrueNorth is defined for this IfcGeometricRepresentationContext
    bool hasTrueNorth() const;
    /// Direction of the true north, or geographic northing direction, relative to the underlying project coordinate system. It is given by a 2 dimensional direction within the xy-plane of the project coordinate system. If not resent, it defaults to 0. 1. - i.e. the positive Y axis of the project coordinate system equals the geographic northing direction.
    ::Ifc2x3::IfcDirection* TrueNorth() const;
    void setTrueNorth(::Ifc2x3::IfcDirection* v);
        IfcTemplatedEntityList< IfcGeometricRepresentationSubContext >::ptr HasSubContexts() const; // INVERSE IfcGeometricRepresentationSubContext::ParentContext
    virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcGeometricRepresentationContext (IfcEntityInstanceData* e);
    IfcGeometricRepresentationContext (boost::optional< std::string > v1_ContextIdentifier, boost::optional< std::string > v2_ContextType, int v3_CoordinateSpaceDimension, boost::optional< double > v4_Precision, ::Ifc2x3::IfcAxis2Placement* v5_WorldCoordinateSystem, ::Ifc2x3::IfcDirection* v6_TrueNorth);
    typedef IfcTemplatedEntityList< IfcGeometricRepresentationContext > list;
};
/// Definition from ISO/CD 10303-43:1992: An geometric representation item is a representation item that has the additional meaning of having geometric position or orientation or both. This meaning is present by virtue of:  
/// 
/// being a Cartesian point or a direction  
///   referencing directly a Cartesian point or direction  
///   referencing indirectly a Cartesian point or direction  
/// 
/// An indirect reference to a Cartesian point or direction means that a given geometric item references the Cartesian point or direction through one or more intervening geometry or topology items.  
/// 
/// EXAMPLE: Consider a circle. It gains its geometric position and orientation by virtue of a reference to axis2_placement (IfcAxis2Placement) that is turn references a cartesian_point (IfcCartesianPoint) and several directions (IfcDirection). 
/// 
/// EXAMPLE: Consider a manifold brep. A manifold_solid_brep (IfcManifoldSolidBrep) is a geometric_representation_item (IfcGeometricRepresentationItem) that through several layers of topological_representation_item's (IfcTopologicalRepresentationItem) references poly loops (IfcPolyLoop). Through additional intervening entities poly loops reference cartesian_point's (IfcCartesianPoint).
/// 
/// The derivation of the dimensionality of the IfcGeometricRepresentationItem is different to ISO 10303; there is a specific derived attribute at each class that defines the dimensionality, whereas ISO 10303 does it for the representation_context and requires all geometric_representation_item's to have the same dimensionality therein.  
/// 
/// The definition of swept area solids as geometric representation items is different to ISO 10303; it is based on a set of predefined profiles (or cross sections), that is, a set of parameterized geometric primitives widely supported in the industry. Those profiles are used to create volumes through extrusion, revolution and cross section based sweep operations.
/// 
/// NOTE: Corresponding ISO 10303 entity: geometric_representation_item. Please refer to ISO/IS 10303-42:1994, p. 22 for the final definition of the formal standard. The following changes have been made: It does not inherit from ISO/IS 10303-43:1994 entity representation_item. The derived attribute Dim is demoted to the appropriate subtypes. The WR1 has not been incorporated. Not all subtypes that are in ISO/IS 10303-42:1994 have been added to the current IFC Release.
/// 
/// HISTORY: New entity in IFC Release 1.5
class IFC_PARSE_API IfcGeometricRepresentationItem : public IfcRepresentationItem {
public:
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcGeometricRepresentationItem (IfcEntityInstanceData* e);
    IfcGeometricRepresentationItem ();
    typedef IfcTemplatedEntityList< IfcGeometricRepresentationItem > list;
};
/// IfcGeometricRepresentationSubContext defines the context that applies to several shape representations of a product being a sub context, sharing the WorldCoordinateSystem, CoordinateSpaceDimension, Precision and TrueNorth attributes with the parent IfcGeometricRepresentationContext.
/// 
/// The IfcGeometricRepresentationSubContext is used to define semantically distinguished representation types for different information content, dependent on the representation view and the target scale. It can be used to control the level of detail of the shape representation that is most applicable to this geometric representation context. addition the sub context is used to control the later appearance of the IfcShapeRepresentation within a plot view.
/// 
/// NOTE  If the IfcShapeRepresentation using this sub context has IfcStyledItem's assigned to the Items, the presentation style information (e.g. IfcCurveStyle, IfcTextStyle) associated with the IfcStyledItem is given in target plot dimensions. For example, a line thickness (IfcCurveStyle.CurveWidth) is given by a thickness measure relating to the thickness for a plot within the (range of) target scale.
/// 
/// Each IfcProduct can then have several instances of subtypes of IfcRepresentation, each being assigned to a different geometric representation context (IfcGeometricRepresentationContext or IfcGeometricRepresentationSubContext). The application can then choose the most appropriate representation for showing the geometric shape of the product, depending on the target view and scale.
/// 
/// NOTE  The provision of a model view (IfcGeometricRepresentationContext.ContextType = 'Model') is mandatory. Instances of IfcGeometricRepresentationSubContext relate to it as its ParentContext.
/// 
/// EXAMPLE  Instances of IfcGeometricRepresentationSubContext can be used to handle the multi-view blocks or macros, which are used in CAD programs to store several scale and/or view dependent geometric representations of the same object.
/// 
/// HISTORY  New entity in Release IFC 2x2.
class IFC_PARSE_API IfcGeometricRepresentationSubContext : public IfcGeometricRepresentationContext {
public:
    /// Parent context from which the sub context derives its world coordinate system, precision, space coordinate dimension and true north.
    ::Ifc2x3::IfcGeometricRepresentationContext* ParentContext() const;
    void setParentContext(::Ifc2x3::IfcGeometricRepresentationContext* v);
    /// Whether the optional attribute TargetScale is defined for this IfcGeometricRepresentationSubContext
    bool hasTargetScale() const;
    /// The target plot scale of the representation 
    /// to which this representation context applies.
    ///   Scale indicates the target plot scale for
    /// the representation sub context, all annotation styles are given in plot
    /// dimensions according to this target plot scale.
    /// If multiple instances of IfcGeometricRepresentationSubContext
    /// are given having the same TargetView value, the target plot scale 
    /// applies up to the next smaller scale, or up to unlimited small scale.
    /// 
    /// Note: Scale 1:100 (given as 0.01 within TargetScale)
    /// is bigger then 1:200 (given as 0.005 within TargetScale).
    double TargetScale() const;
    void setTargetScale(double v);
    /// Target view of the representation to which this representation context applies.
    ::Ifc2x3::IfcGeometricProjectionEnum::Value TargetView() const;
    void setTargetView(::Ifc2x3::IfcGeometricProjectionEnum::Value v);
    /// Whether the optional attribute UserDefinedTargetView is defined for this IfcGeometricRepresentationSubContext
    bool hasUserDefinedTargetView() const;
    /// User defined target view, this attribute value shall be given, if the TargetView attribute is set to USERDEFINED.
    std::string UserDefinedTargetView() const;
    void setUserDefinedTargetView(std::string v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcGeometricRepresentationSubContext (IfcEntityInstanceData* e);
    IfcGeometricRepresentationSubContext (boost::optional< std::string > v1_ContextIdentifier, boost::optional< std::string > v2_ContextType, ::Ifc2x3::IfcGeometricRepresentationContext* v7_ParentContext, boost::optional< double > v8_TargetScale, ::Ifc2x3::IfcGeometricProjectionEnum::Value v9_TargetView, boost::optional< std::string > v10_UserDefinedTargetView);
    typedef IfcTemplatedEntityList< IfcGeometricRepresentationSubContext > list;
};
/// Definition from ISO/CD 10303-42:1992: This entity is intended for the transfer of models when a topological structure is not available. 
/// 
/// The IfcGeometricSet is used for the exchange of shape representations consisting of (2D or 3D) points, curves, and/or surfaces, which do not have a topological structure (such as connected face sets or shells) and are not solid models (such as swept solids, CSG or Brep) 
/// 
/// NOTE: Corresponding ISO 10303-42 entity: geometric_set. The derived attribute Dim has been added at this level and was therefore demoted from the geometric_representation_item. Please refer to ISO/IS 10303-42:1994, p. 190 for the final definition of the formal standard.
/// 
/// HISTORY: New entity in IFC Release 2x.
class IFC_PARSE_API IfcGeometricSet : public IfcGeometricRepresentationItem {
public:
    /// The geometric elements which make up the geometric set, these may be points, curves or surfaces; but are required to be of the same coordinate space dimensionality.
    IfcEntityList::ptr Elements() const;
    void setElements(IfcEntityList::ptr v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcGeometricSet (IfcEntityInstanceData* e);
    IfcGeometricSet (IfcEntityList::ptr v1_Elements);
    typedef IfcTemplatedEntityList< IfcGeometricSet > list;
};
/// IfcGridPlacement provides a specialization of IfcObjectPlacement in which
/// the placement and axis direction of the object coordinate system is defined by a reference to the design grid as defined in IfcGrid.
/// The location of the object coordinate system is given by the attribute PlacementLocation. It is defined as an
/// IfcVirtualGridIntersection, that is, an intersection between two grid axes with optional offsets.
/// The axis direction of the x-axis of the object coordinate
/// system is given either:
/// 
/// PlacementRefDirection = NIL: by the tangent of the first grid axis (PlacementLocation.IntersectingAxes[1]) at the virtual intersection (maybe using the offset curve, if PlacementLocation.OffsetDistances is given);
/// PlacementRefDirection = IfcDirection: by the explicitly provided direction information;
/// PlacementRefDirection = IfcVirtualGridIntersection: by the tangent between the virtual grid intersection of PlacementLocation and the virtual grid intersection of PlacementRefDirection. Offsets as potentially provided in the IfcVirtualGridIntersection's of PlacementLocation and PlacementRefDirection have to be taken into account.
/// 
/// The direction of the y-axis of the IfcGridPlacement is the orthogonal complement to the x-axis. The plane defined by the x and y axis shall be co-planar to the xy plane of the local placement of the IfcGrid.ÿ 
/// The direction of the z-axis is the orientation of the cross product of the x-axis and the y-axis, i.e. the z-axis of the IfcGridPlacement shall be co-linear to the z-axis of the local placement of the IfcGrid.
/// 
/// NOTE The IfcGrid local placement, that can be provided relative to the local placement of another spatial structure element, has to be taken into account for calculating the absolute placement of the virtual grid intersection.
/// 
/// NOTE The PlacementLocation.OffsetDistances[3] and the PlacementRefDirection.OffsetDistances[3] shall either not be assigned or should have the same z offset value.
/// 
/// HISTORY ÿNew entity in IFC Release 1.5. The entity name was changed from IfcConstrainedPlacement in IFC Release 2x.
/// 
/// IFC2x4 CHANGE Attribute data type of PlacementRefDirection has been changed to IfcGridPlacementDirectionSelect.
/// 
/// Geometry use definitions
/// The following examples show the usage of placement location and direction for an IfcGridPlacement.
/// 
/// Figure 243 illustrates the case where PlacementRefDirection is not given - the object coordinate system is defined by:
/// 
/// its location: given by the virtual grid intersection of PlacementLocation
/// its x-axis direction: given by the tangent of the first intersecting axis in the offset location of the virtual grid intersection
/// 
/// Figure 243 — Grid placement
/// 
/// Figure 244 illustrates the case where PlacementRefDirection is given as an IfcDirection- the object coordinate system is defined by:
/// 
/// its location: given by the virtual grid intersection of PlacementLocation
/// its x-axis direction: given by the DirectionRatios of the IfcDirection, only the ratios for x and y are taken into account,
/// 
/// Figure 244 — Grid placement with direction
/// 
/// Figure 245 illustrates the case where PlacementRefDirection is given as an IfcVirtualGridIntersection- the object coordinate system is defined by:
/// 
/// its location: given by the virtual grid intersection of PlacementLocation
/// its x-axis direction: given by the tangent of the line between the virtual grid intersection of the PlacementLocation and the virtual grid intersection of the PlacementRefDirection.
/// 
/// Figure 245 — Grid placement with intersection
class IFC_PARSE_API IfcGridPlacement : public IfcObjectPlacement {
public:
    /// Placement of the object coordinate system defined by the intersection of two grid axes.
    ::Ifc2x3::IfcVirtualGridIntersection* PlacementLocation() const;
    void setPlacementLocation(::Ifc2x3::IfcVirtualGridIntersection* v);
    /// Whether the optional attribute PlacementRefDirection is defined for this IfcGridPlacement
    bool hasPlacementRefDirection() const;
    /// Reference to either an explicit direction, or a second grid axis intersection, which defines the orientation of the grid placement.
    /// 
    /// IFC2x4 CHANGE  The select of an explict direction has been added.
    ::Ifc2x3::IfcVirtualGridIntersection* PlacementRefDirection() const;
    void setPlacementRefDirection(::Ifc2x3::IfcVirtualGridIntersection* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcGridPlacement (IfcEntityInstanceData* e);
    IfcGridPlacement (::Ifc2x3::IfcVirtualGridIntersection* v1_PlacementLocation, ::Ifc2x3::IfcVirtualGridIntersection* v2_PlacementRefDirection);
    typedef IfcTemplatedEntityList< IfcGridPlacement > list;
};
/// Definition from ISO/CD 10303-42:1992: A half space solid is defined by the half space which is the regular subset of the domain which lies on one side of an unbounded surface. The side of the surface which is in the half space is determined by the surface normal and the agreement flag. If the agreement flag is TRUE, then the subset is the one the normal points away from. If the agreement flag is FALSE, then the subset is the one the normal points into. For a valid half space solid the surface shall divide the domain into exactly two subsets. Also, within the domain the surface shall be manifold and all surface normals shall point into the same subset.  
/// 
/// NOTE A half space is not a subtype of solid model (IfcSolidModel), half space solids are only useful as operands in Boolean expressions.
/// 
/// NOTE Corresponding STEP entity: half_space_solid. Please refer to ISO/IS 10303-42:1994, p. 185 for the final definition of the formal standard. The derived attribute Dim has been added at this level and was therefore demoted from the geometric_representation_item.
/// 
/// HISTORY New class in IFC Release 1.5
/// 
/// Informal propositions: 
/// 
/// The base surface shall divide the domain into exactly two subsets. If the half space solid is of subtype boxed half space (IfcBoxedHalfSpace), the domain in question is that of the attribute enclosure. In all other cases the domain is all of space and the base surface shall be unbounded.  The base surface shall be an unbounded surface (subtype of IfcElementarySurface). 
/// 
/// Figure 258 illustrates the definition of the IfcHalfSpaceSolid within a given coordinate system. The base surface is given by an unbounded plane, the red boundary is shown for visualization purposes only. 
/// 
/// Figure 258 — Half space solid geometry
class IFC_PARSE_API IfcHalfSpaceSolid : public IfcGeometricRepresentationItem {
public:
    /// Surface defining side of half space.
    ::Ifc2x3::IfcSurface* BaseSurface() const;
    void setBaseSurface(::Ifc2x3::IfcSurface* v);
    /// The agreement flag is TRUE if the normal to the BaseSurface points away from the material of the IfcHalfSpaceSolid. Otherwise it is FALSE.
    bool AgreementFlag() const;
    void setAgreementFlag(bool v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcHalfSpaceSolid (IfcEntityInstanceData* e);
    IfcHalfSpaceSolid (::Ifc2x3::IfcSurface* v1_BaseSurface, bool v2_AgreementFlag);
    typedef IfcTemplatedEntityList< IfcHalfSpaceSolid > list;
};

class IFC_PARSE_API IfcHygroscopicMaterialProperties : public IfcMaterialProperties {
public:
    /// Whether the optional attribute UpperVaporResistanceFactor is defined for this IfcHygroscopicMaterialProperties
    bool hasUpperVaporResistanceFactor() const;
    double UpperVaporResistanceFactor() const;
    void setUpperVaporResistanceFactor(double v);
    /// Whether the optional attribute LowerVaporResistanceFactor is defined for this IfcHygroscopicMaterialProperties
    bool hasLowerVaporResistanceFactor() const;
    double LowerVaporResistanceFactor() const;
    void setLowerVaporResistanceFactor(double v);
    /// Whether the optional attribute IsothermalMoistureCapacity is defined for this IfcHygroscopicMaterialProperties
    bool hasIsothermalMoistureCapacity() const;
    double IsothermalMoistureCapacity() const;
    void setIsothermalMoistureCapacity(double v);
    /// Whether the optional attribute VaporPermeability is defined for this IfcHygroscopicMaterialProperties
    bool hasVaporPermeability() const;
    double VaporPermeability() const;
    void setVaporPermeability(double v);
    /// Whether the optional attribute MoistureDiffusivity is defined for this IfcHygroscopicMaterialProperties
    bool hasMoistureDiffusivity() const;
    double MoistureDiffusivity() const;
    void setMoistureDiffusivity(double v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcHygroscopicMaterialProperties (IfcEntityInstanceData* e);
    IfcHygroscopicMaterialProperties (::Ifc2x3::IfcMaterial* v1_Material, boost::optional< double > v2_UpperVaporResistanceFactor, boost::optional< double > v3_LowerVaporResistanceFactor, boost::optional< double > v4_IsothermalMoistureCapacity, boost::optional< double > v5_VaporPermeability, boost::optional< double > v6_MoistureDiffusivity);
    typedef IfcTemplatedEntityList< IfcHygroscopicMaterialProperties > list;
};
/// An IfcImageTexture provides a 2-dimensional texture that can be applied to a surface of an geometric item and that provides lighting parameters of a surface onto which it is mapped. The texture is provided as an image file at an external location for which an URL is provided.
/// 
/// The following definitions from ISO/IEC 19775-1 X3D Architecture and base components (X3D Specification) apply:
/// 
/// The ImageTexture node defines a texture map by specifying an image file and general parameters for mapping to geometry. 
/// The texture is read from the URL specified by the url field. When the url field contains no [resolvable] values, texturing is disabled. Browsers shall support the JPEG and PNG (see ISO/IEC 15948) image file formats.
/// Texture nodes that require support for the PNG image format shall interpret the PNG pixel formats in the following way:
/// 
/// Greyscale pixels without alpha or simple transparency are treated as intensity textures.
/// >Greyscale pixels with alpha or simple transparency are treated as intensity plus alpha textures.
/// RGB pixels without alpha channel or simple transparency are treated as full RGB textures.
/// RGB pixels with alpha channel or simple transparency are treated as full RGB plus alpha textures.
/// 
/// If the image specifies colours as indexed-colour (that is, palettes or colourmaps), the following semantics should be used (note that `greyscale' refers to a palette entry with equal red, green, and blue values):
/// 
/// If all the colours in the palette are greyscale and there is no transparency chunk, it is treated as an intensity texture.
/// If all the colours in the palette are greyscale and there is a transparency chunk, it is treated as an intensity plus opacity texture.
/// >If any colour in the palette is not grey and there is no transparency chunk, it is treated as a full RGB texture.
/// If any colour in the palette is not grey and there is a transparency chunk, it is treated as a full RGB plus alpha texture.
/// 
/// Texture nodes that require support for JPEG files shall interpret JPEG files as follows:
/// 
/// Greyscale files (number of components equals 1) are treated as intensity textures.
/// YCbCr files are treated as full RGB textures.
/// No other JPEG file types are required. It is recommended that other JPEG files are treated as a full RGB textures.
/// 
/// Texture nodes that recommend support for GIF files shall follow the applicable semantics described above for the PNG format.
/// 
/// The Uniform Resource Locator (URL) is a form of an URI and specified in RFC1738 by IETF. It supports resources located on a particular server being accessed by a particular protocol (usually http), and resources located at a local machine.
/// 
/// NOTE  Exchange files following the ifcZIP convention may include a sub directory structure for image resources to be stored together with the product data set.
/// 
/// NOTE  The definitions of texturing within this standard have been developed in dependence on the texture component of X3D. See ISO/IEC 19775-1.2:2008 X3D Architecture and base components Edition 2, Part 1, 18 Texturing component for the definitions in the international standard.
/// 
/// HISTORY  New entity in Release IFC2x2.
class IFC_PARSE_API IfcImageTexture : public IfcSurfaceTexture {
public:
    /// Location, provided as an URI, at which the image texture is electronically published.
    std::string UrlReference() const;
    void setUrlReference(std::string v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcImageTexture (IfcEntityInstanceData* e);
    IfcImageTexture (bool v1_RepeatS, bool v2_RepeatT, ::Ifc2x3::IfcSurfaceTextureEnum::Value v3_TextureType, ::Ifc2x3::IfcCartesianTransformationOperator2D* v4_TextureTransform, std::string v5_UrlReference);
    typedef IfcTemplatedEntityList< IfcImageTexture > list;
};
/// In an irregular time series, unpredictable bursts of data arrive at unspecified points in time, or most time stamps cannot be characterized by a repeating pattern.
/// 
/// EXAMPLE: A circulating pump cycles on and off at unpredictable times as dictated by the demands on the piping system; the amount of light in a classroom varies depending on when the lights are manually switched on and off and and how many lamps are controlled by each switch.
/// 
/// HISTORY: New entity in IFC 2x2.
class IFC_PARSE_API IfcIrregularTimeSeries : public IfcTimeSeries {
public:
    /// The collection of time series values.
    IfcTemplatedEntityList< ::Ifc2x3::IfcIrregularTimeSeriesValue >::ptr Values() const;
    void setValues(IfcTemplatedEntityList< ::Ifc2x3::IfcIrregularTimeSeriesValue >::ptr v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcIrregularTimeSeries (IfcEntityInstanceData* e);
    IfcIrregularTimeSeries (std::string v1_Name, boost::optional< std::string > v2_Description, ::Ifc2x3::IfcDateTimeSelect* v3_StartTime, ::Ifc2x3::IfcDateTimeSelect* v4_EndTime, ::Ifc2x3::IfcTimeSeriesDataTypeEnum::Value v5_TimeSeriesDataType, ::Ifc2x3::IfcDataOriginEnum::Value v6_DataOrigin, boost::optional< std::string > v7_UserDefinedDataOrigin, ::Ifc2x3::IfcUnit* v8_Unit, IfcTemplatedEntityList< ::Ifc2x3::IfcIrregularTimeSeriesValue >::ptr v9_Values);
    typedef IfcTemplatedEntityList< IfcIrregularTimeSeries > list;
};
/// Definition from ISO/CD 10303-46:1992: The light source entity is determined by the reflectance specified in the surface style rendering. Lighting is applied on a surface by surface basis: no interactions between surfaces such as shadows or reflections are defined. 
/// 
/// NOTE: Corresponding STEP entity: light_source. Please refer to ISO/IS 10303-46:1994, p. 31 for the final definition of the formal standard. 
/// 
/// NOTE: In addition to the attributes as defined in ISO10303-46 the following additional properties from ISO/IEC 14772-1:1997 (VRML) are added: ambientIntensity and Intensity. The attribute Name has been added as well (as it is not inherited via representation_item).
/// 
/// HISTORY: This is a new Entity in IFC 2x, renamed and enhanced in IFC2x2.
class IFC_PARSE_API IfcLightSource : public IfcGeometricRepresentationItem {
public:
    /// Whether the optional attribute Name is defined for this IfcLightSource
    bool hasName() const;
    /// The name given to the light source in presentation.
    std::string Name() const;
    void setName(std::string v);
    /// Definition from ISO/CD 10303-46:1992: Based on the current lighting model, the colour of the light to be used for shading.
    /// Definition from VRML97 - ISO/IEC 14772-1:1997: The color field specifies the spectral color properties of both the direct and ambient light emission as an RGB value.
    ::Ifc2x3::IfcColourRgb* LightColour() const;
    void setLightColour(::Ifc2x3::IfcColourRgb* v);
    /// Whether the optional attribute AmbientIntensity is defined for this IfcLightSource
    bool hasAmbientIntensity() const;
    /// Definition from VRML97 - ISO/IEC 14772-1:1997: The ambientIntensity specifies the intensity of the ambient emission from the light. Light intensity may range from 0.0 (no light emission) to 1.0 (full intensity).
    double AmbientIntensity() const;
    void setAmbientIntensity(double v);
    /// Whether the optional attribute Intensity is defined for this IfcLightSource
    bool hasIntensity() const;
    /// Definition from VRML97 - ISO/IEC 14772-1:1997: The intensity field specifies the brightness of the direct emission from the ligth. Light intensity may range from 0.0 (no light emission) to 1.0 (full intensity).
    double Intensity() const;
    void setIntensity(double v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcLightSource (IfcEntityInstanceData* e);
    IfcLightSource (boost::optional< std::string > v1_Name, ::Ifc2x3::IfcColourRgb* v2_LightColour, boost::optional< double > v3_AmbientIntensity, boost::optional< double > v4_Intensity);
    typedef IfcTemplatedEntityList< IfcLightSource > list;
};
/// Definition from ISO/CD 10303-46:1992: The light source ambient entity is a subtype of light source. It lights a surface independent of the surface's orientation and position. 
/// 
/// NOTE: Corresponding ISO 10303 entity: light_source_ambient. Please refer to ISO/IS 10303-46:1994, p. 31 for the final definition of the formal standard.
/// 
/// NOTE: In addition to the attributes as defined in ISO 10303-46 the additional property from ISO/IEC 14772-1:1997 (VRML) AmbientIntensity is inherited from the supertype.
/// 
/// HISTORY: This is a new entity in IFC 2x, renamed and enhanced in IFC2x2.
class IFC_PARSE_API IfcLightSourceAmbient : public IfcLightSource {
public:
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcLightSourceAmbient (IfcEntityInstanceData* e);
    IfcLightSourceAmbient (boost::optional< std::string > v1_Name, ::Ifc2x3::IfcColourRgb* v2_LightColour, boost::optional< double > v3_AmbientIntensity, boost::optional< double > v4_Intensity);
    typedef IfcTemplatedEntityList< IfcLightSourceAmbient > list;
};
/// Definition from ISO/CD 10303-46:1992: The light source directional is a subtype of light source. This entity has a light source direction. With a conceptual origin at infinity, all the rays of the light are parallel to this direction. This kind of light source lights a surface based on the surface's orientation, but not position. 
/// 
/// Definition from ISO/IEC 14772-1:1997: The directional light node defines a directional light source that illuminates along rays parallel to a given 3-dimensional vector. Directional light nodes do not attenuate with distance. Directional light nodes are specified in the local coordinate system and are affected by ancestor transformations. 
/// 
/// NOTE: Corresponding ISO 10303 entity: light_source_directional. Please refer to ISO/IS 10303-46:1994, p. 32 for the final definition of the formal standard.
/// 
/// NOTE: In addition to the attributes as defined in ISO 10303-46 the additional property from ISO/IEC 14772-1:1997 (VRML) AmbientIntensity and Intensity are inherited from the supertype.
/// 
/// HISTORY: This is a new entity in IFC 2x, renamed and enhanced in IFC2x2.
class IFC_PARSE_API IfcLightSourceDirectional : public IfcLightSource {
public:
    /// Definition from ISO/CD 10303-46:1992: This direction is the direction of the light source.
    /// Definition from VRML97 - ISO/IEC 14772-1:1997: The direction field specifies the direction vector of the illumination emanating from the light source in the local coordinate system. Light is emitted along parallel rays from an infinite distance away.
    ::Ifc2x3::IfcDirection* Orientation() const;
    void setOrientation(::Ifc2x3::IfcDirection* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcLightSourceDirectional (IfcEntityInstanceData* e);
    IfcLightSourceDirectional (boost::optional< std::string > v1_Name, ::Ifc2x3::IfcColourRgb* v2_LightColour, boost::optional< double > v3_AmbientIntensity, boost::optional< double > v4_Intensity, ::Ifc2x3::IfcDirection* v5_Orientation);
    typedef IfcTemplatedEntityList< IfcLightSourceDirectional > list;
};
/// IfcLightSourceGoniometric defines a light source for which exact lighting data is available. It specifies the type of a light emitter, defines the position and orientation of a light distribution curve and the data concerning lamp and photometric information. 
/// 
/// Figure 303 shows an example of a light emitter having two light sources (of type IfcLightSourceGoniometric). 
/// 
/// Figure 303 — Light source goniometric
/// 
/// HISTORY: New entity in IFC2x2.
class IFC_PARSE_API IfcLightSourceGoniometric : public IfcLightSource {
public:
    /// The position of the light source. It is used to orientate the light distribution curves.
    ::Ifc2x3::IfcAxis2Placement3D* Position() const;
    void setPosition(::Ifc2x3::IfcAxis2Placement3D* v);
    /// Whether the optional attribute ColourAppearance is defined for this IfcLightSourceGoniometric
    bool hasColourAppearance() const;
    /// Artificial light sources are classified in terms of their color appearance. To the human eye they all appear to be white; the difference can only be detected by direct comparison. Visual performance is not directly affected by differences in color appearance.
    ::Ifc2x3::IfcColourRgb* ColourAppearance() const;
    void setColourAppearance(::Ifc2x3::IfcColourRgb* v);
    /// The color temperature of any source of radiation is defined as the temperature (in Kelvin) of a black-body or Planckian radiator whose radiation has the same chromaticity as the source of radiation. Often the values are only approximate color temperatures as the black-body radiator cannot emit radiation of every chromaticity value. The color temperatures of the commonest artificial light sources range from less than 3000K (warm white) to 4000K (intermediate) and over 5000K (daylight).
    double ColourTemperature() const;
    void setColourTemperature(double v);
    /// Luminous flux is a photometric measure of radiant flux, i.e. the volume of light emitted from a light source. Luminous flux is measured either for the interior as a whole or for a part of the interior (partial luminous flux for a solid angle). All other photometric parameters are derivatives of luminous flux. Luminous flux is measured in lumens (lm). The luminous flux is given as a nominal value for each lamp.
    double LuminousFlux() const;
    void setLuminousFlux(double v);
    /// Identifies the types of light emitter from which the type required may be set.
    ::Ifc2x3::IfcLightEmissionSourceEnum::Value LightEmissionSource() const;
    void setLightEmissionSource(::Ifc2x3::IfcLightEmissionSourceEnum::Value v);
    /// The data source from which light distribution data is obtained.
    ::Ifc2x3::IfcLightDistributionDataSourceSelect* LightDistributionDataSource() const;
    void setLightDistributionDataSource(::Ifc2x3::IfcLightDistributionDataSourceSelect* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcLightSourceGoniometric (IfcEntityInstanceData* e);
    IfcLightSourceGoniometric (boost::optional< std::string > v1_Name, ::Ifc2x3::IfcColourRgb* v2_LightColour, boost::optional< double > v3_AmbientIntensity, boost::optional< double > v4_Intensity, ::Ifc2x3::IfcAxis2Placement3D* v5_Position, ::Ifc2x3::IfcColourRgb* v6_ColourAppearance, double v7_ColourTemperature, double v8_LuminousFlux, ::Ifc2x3::IfcLightEmissionSourceEnum::Value v9_LightEmissionSource, ::Ifc2x3::IfcLightDistributionDataSourceSelect* v10_LightDistributionDataSource);
    typedef IfcTemplatedEntityList< IfcLightSourceGoniometric > list;
};
/// Definition from ISO/CD 10303-46:1992: The light source positional entity is a subtype of light source. This entity has a light source position and attenuation coefficients. A positional light source affects a surface based on the surface's orientation and position. 
/// 
/// Definition from ISO/IEC 14772-1:1997: The Point light node specifies a point light source at a 3D location in the local coordinate system. A point light source emits light equally in all directions; that is, it is omnidirectional. Point light nodes are specified in the local coordinate system and are affected by ancestor transformations.  
/// 
/// Point light node's illumination falls off with distance as specified by three attenuation coefficients. The attenuation factor is  
/// 
/// 1/max(attenuation[0] + attenuation[1] × r + attenuation[2] × r 2 , 1), 
/// 
/// where r is the distance from the light to the surface being illuminated. The default is no attenuation. An attenuation value of (0, 0, 0) is identical to (1, 0, 0). Attenuation values shall be greater than or equal to zero.  
/// 
/// NOTE: Corresponding ISO 10303 entity: light_source_positional. Please refer to ISO/IS 10303-46:1994, p. 32 for the final definition of the formal standard.
/// 
/// NOTE: In addition to the attributes as defined in ISO10303-46 the additional property from ISO/IEC 14772-1:1997 (VRML) Radius and QuadricAttenuation are added to this subtype and the AmbientIntensity and Intensity are inherited from the supertype.
/// 
/// HISTORY: This is a new entity in IFC 2x, renamed and enhanced in IFC2x2.
class IFC_PARSE_API IfcLightSourcePositional : public IfcLightSource {
public:
    /// Definition from ISO/CD 10303-46:1992: The Cartesian point indicates the position of the light source.
    /// Definition from VRML97 - ISO/IEC 14772-1:1997: A Point light node illuminates geometry within radius of its location.
    ::Ifc2x3::IfcCartesianPoint* Position() const;
    void setPosition(::Ifc2x3::IfcCartesianPoint* v);
    /// Definition from IAI: The maximum distance from the light source for a surface still to be illuminated.
    /// Definition from VRML97 - ISO/IEC 14772-1:1997: A Point light node illuminates geometry within radius of its location.
    double Radius() const;
    void setRadius(double v);
    /// Definition from ISO/CD 10303-46:1992: This real indicates the value of the attenuation in the lighting equation that is constant.
    double ConstantAttenuation() const;
    void setConstantAttenuation(double v);
    /// Definition from ISO/CD 10303-46:1992: This real indicates the value of the attenuation in the lighting equation that proportional to the distance from the light source.
    double DistanceAttenuation() const;
    void setDistanceAttenuation(double v);
    /// Definition from the IAI: This real indicates the value of the attenuation in the lighting equation that proportional to the square value of the distance from the light source.
    double QuadricAttenuation() const;
    void setQuadricAttenuation(double v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcLightSourcePositional (IfcEntityInstanceData* e);
    IfcLightSourcePositional (boost::optional< std::string > v1_Name, ::Ifc2x3::IfcColourRgb* v2_LightColour, boost::optional< double > v3_AmbientIntensity, boost::optional< double > v4_Intensity, ::Ifc2x3::IfcCartesianPoint* v5_Position, double v6_Radius, double v7_ConstantAttenuation, double v8_DistanceAttenuation, double v9_QuadricAttenuation);
    typedef IfcTemplatedEntityList< IfcLightSourcePositional > list;
};
/// Definition from ISO/CD 10303-46:1992: The light source spot entity is a subtype of light source. Spot light source entities have a light source colour, position, direction, attenuation coefficients, concentration exponent, and spread angle. If a point lies outside the cone of influence of a light source of this type as determined by the light source position, direction and spread angle its colour is not affected by that light source. 
/// 
/// NOTE  The IfcLightSourceSpot adds the BeamWidthAngle which defines the inner cone in which the light source emits light at uniform full intensity. The light source's emission intensity drops off from the inner solid angle (BeamWidthAngle) to the outer solid angle (SpreadAngle).
/// 
/// Definition from ISO/IEC 14772-1:1997: The Spot light node defines a light source that emits light from a specific point along a specific direction vector and constrained within a solid angle. Spot lights may illuminate geometry nodes that respond to light sources and intersect the solid angle defined by the Spot light. Spot light nodes are specified in the local coordinate system and are affected by ancestors' transformations. 
/// 
/// Figure 304 (from VRML97) shows the definition of spot light. 
/// 
/// Figure 304 — Light source spot
/// 
/// NOTE  Corresponding ISO 10303 entity: light_source_spot. Please refer to ISO/IS 10303-46:1994, p. 33 for the final definition of the formal standard.
/// 
/// NOTE  In addition to the attributes as defined in ISO10303-46 the additional property from ISO/IEC 14772-1:1997 (VRML) Radius, BeamWidth, and QuadricAttenuation are added to this subtype and the AmbientIntensity and Intensity are inherited from the supertype.
/// 
/// HISTORY  This is a new entity in IFC 2x, renamed and enhanced in IFC2x2.
class IFC_PARSE_API IfcLightSourceSpot : public IfcLightSourcePositional {
public:
    /// Definition from ISO/CD 10303-46:1992: This is the direction of the axis of the cone of the light source specified in the coordinate space of the representation being projected..
    /// Definition from VRML97 - ISO/IEC 14772-1:1997: The direction field specifies the direction vector of the light's central axis defined in the local coordinate system.
    ::Ifc2x3::IfcDirection* Orientation() const;
    void setOrientation(::Ifc2x3::IfcDirection* v);
    /// Whether the optional attribute ConcentrationExponent is defined for this IfcLightSourceSpot
    bool hasConcentrationExponent() const;
    /// Definition from ISO/CD 10303-46:1992: This real is the exponent on the cosine of the angle between the line that starts at the position of the spot light source and is in the direction of the orientation of the spot light source and a line that starts at the position of the spot light source and goes through a point on the surface being shaded.
    /// NOTE: This attribute does not exists in ISO/IEC 14772-1:1997.
    double ConcentrationExponent() const;
    void setConcentrationExponent(double v);
    /// Definition from ISO/CD 10303-46:1992: This planar angle measure is the angle between the line that starts at the position of the spot light source and is in the direction of the spot light source and any line on the boundary of the cone of influence.
    /// Definition from VRML97 - ISO/IEC 14772-1:1997: The cutOffAngle (name of spread angle in VRML) field specifies the outer bound of the solid angle. The light source does not emit light outside of this solid angle.
    double SpreadAngle() const;
    void setSpreadAngle(double v);
    /// Definition from VRML97 - ISO/IEC 14772-1:1997: The beamWidth field specifies an inner solid angle in which the light source emits light at uniform full intensity. The light source's emission intensity drops off from the inner solid angle (beamWidthAngle) to the outer solid angle (spreadAngle).
    double BeamWidthAngle() const;
    void setBeamWidthAngle(double v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcLightSourceSpot (IfcEntityInstanceData* e);
    IfcLightSourceSpot (boost::optional< std::string > v1_Name, ::Ifc2x3::IfcColourRgb* v2_LightColour, boost::optional< double > v3_AmbientIntensity, boost::optional< double > v4_Intensity, ::Ifc2x3::IfcCartesianPoint* v5_Position, double v6_Radius, double v7_ConstantAttenuation, double v8_DistanceAttenuation, double v9_QuadricAttenuation, ::Ifc2x3::IfcDirection* v10_Orientation, boost::optional< double > v11_ConcentrationExponent, double v12_SpreadAngle, double v13_BeamWidthAngle);
    typedef IfcTemplatedEntityList< IfcLightSourceSpot > list;
};
/// IfcLocalPlacement defines the relative placement of a product in relation to the
/// placement of another product or the absolute placement of a product within the geometric representation context of the project. 
/// IfcLocalPlacement allows that an IfcProduct can be placed by this IfcLocalPlacement (through
/// the attributeObjectPlacement) within the local coordinate system of the object placement of another IfcProduct,
/// which is referenced by the PlacementRelTo. Rules to prevent cyclic relative placements have to be introduced on the
/// application level.
/// If the PlacementRelTo is not given, then
/// the IfcProduct is placed absolutely within the
/// world coordinate system.
/// 
/// HISTORY: New entity in IFC Release 1.0.
/// 
/// Geometry use definitions
/// The following conventions shall apply as default relative positions if the relative placement is used. The conventions are given for all five direct subtypes of IfcProduct, the IfcSpatialStructureElement, IfcElement, IfcAnnotation, IfcGrid, IfcPort. More detailed placement information is given at the level of subtypes of those five types mentioned.
/// 
/// For the subtypes of IfcSpatialStructureElement the following conventions apply
/// 
/// IfcSite shall be placed absolutely within the world coordinate system established by the geometric
/// representation context of the IfcProject 
///   IfcBuilding shall be placed relative to the local placement of IfcSite 
///   IfcBuildingStorey shall be placed relative to the local placement of IfcBuilding 
/// 
/// For IfcGrid and IfcAnnotation the convention applies that it shall be placed relative
/// 
/// to the local placement of its container (IfcSite, IfcBuilding, IfcBuildingStorey)
/// 
/// it should be the same container element that is referenced by the IfcRelContainedInSpatialStructure
/// containment relationship,
/// 
/// For IfcPort the convention applies that it shall be placed relative
/// 
/// to the local placement of the element it belongs to (IfcElement)
/// 
/// it should be the same element that is referenced by the IfcRelConnectsPortToElement connection
/// relationship,
/// 
/// For IfcElement the convention applies that it shall be placed relative:
/// 
/// to the local placement of its container (IfcSite, IfcBuilding, IfcBuildingStorey)
/// 
/// it should be the same container element that is referenced by the IfcRelContainedInSpatialStructure
/// containment relationship,
/// 
/// to the local placement of the IfcElement to which it is tied by an element composition relationship
/// 
/// for features that are located relative to the main component (such as openings), as expressed by IfcRelVoidsElement and IfcRelProjectsElement,
///   for elements that fill an opening (such as doors or windows), as expressed byIfcRelFillsElement,
///   for coverings that cover the element, as expressed byIfcRelCoversBldgElements,
///   for sub components that are aggregated to the main component, as expressed by  IIfcRelAggregates and IfcRelNests)
/// 
/// If the PlacementRelTo relationship is not given, then it defaults to an absolute placement within the world
/// coordinate system established by the referenced geometric representation context within the project.
class IFC_PARSE_API IfcLocalPlacement : public IfcObjectPlacement {
public:
    /// Whether the optional attribute PlacementRelTo is defined for this IfcLocalPlacement
    bool hasPlacementRelTo() const;
    /// Reference to Object that provides the relative placement by its local coordinate system. If it is omitted, then the local placement is given to the WCS, established by the geometric representation context.
    ::Ifc2x3::IfcObjectPlacement* PlacementRelTo() const;
    void setPlacementRelTo(::Ifc2x3::IfcObjectPlacement* v);
    /// Geometric placement that defines the transformation from the related coordinate system into the relating. The placement can be either 2D or 3D, depending on the dimension count of the coordinate system.
    ::Ifc2x3::IfcAxis2Placement* RelativePlacement() const;
    void setRelativePlacement(::Ifc2x3::IfcAxis2Placement* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcLocalPlacement (IfcEntityInstanceData* e);
    IfcLocalPlacement (::Ifc2x3::IfcObjectPlacement* v1_PlacementRelTo, ::Ifc2x3::IfcAxis2Placement* v2_RelativePlacement);
    typedef IfcTemplatedEntityList< IfcLocalPlacement > list;
};
/// Definition from ISO/CD 10303-42:1992: A loop is a topological
///   entity constructed from a single vertex, or by stringing together connected
///   (oriented) edges, or linear segments beginning and ending at the same vertex.
///   It is typically used to bound a face lying on a surface. A loop has
///   dimensionality of 0 or 1. The domain of a 0-dimensional loop is a single point.
///   The domain of a 1-dimensional loop is a connected, oriented curve, but need not
///   to be manifold. As the loop is a circle, the location of its beginning/ending
///   point is arbitrary. The domain of the loop includes its bounds, an 0 ≤ Ξ
///   < ∞.  
///   A loop is represented by a single vertex, or by an ordered collection of
///   oriented edges, or by an ordered collection of points. A loop is a graph, so
///   M and the graph genus Gl may be determined by the
///   graph traversal algorithm. Since M = 1, the Euler equation (1) reduces
///   in this case to  
/// 
/// where V and El are the number of unique
///   vertices and oriented edges in the loop and Gl is the genus
///   of the loop.  
///   NOTE  Corresponding ISO 10303 entity: loop, the following subtypes have been incorporated into IFC: poly_loop as IfcPolyLoop, vertex_loop as IfcVertexLoop, edge_loop as IfcEdgeLoop. Please refer to ISO/IS 10303-42:1994, p. 136 for the final definition of the formal standard. 
/// 
/// HISTORY  New Entity in IFC2x. 
///   Informal propositions: 
/// 
/// A loop has a finite extent. 
///   A loop describes a closed (topological) curve with coincident start
///   and end vertices.
class IFC_PARSE_API IfcLoop : public IfcTopologicalRepresentationItem {
public:
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcLoop (IfcEntityInstanceData* e);
    IfcLoop ();
    typedef IfcTemplatedEntityList< IfcLoop > list;
};
/// Definition from ISO/CD 10303-43:1992: A mapped item is the use of an existing representation (the mapping source - mapped representation) as a representation item in a second representation. 
/// 
/// NOTE: A mapped item is a subtype of representation item. It enables a representation to be used as a representation item in one or more other representations. The mapped item allows for the definition of a representation using other representations. 
/// 
/// The IfcMappedItem is the inserted instance of a source definition (to be compared with a
/// block / shared cell / macro definition). The instance is inserted by applying a Cartesian transformation operator as the MappingTarget.
/// 
/// EXAMPLE  An IfcMappedItem can reuse other mapped items (ako nested blocks), doing so the IfcRepresentationMap is based on an IfcShapeRepresentation including one or more IfcMappedItem's.
/// 
/// NOTE   Corresponding ISO 10303 entity: mapped_item. Please refer to ISO/IS
/// 10303-43:1994, for the final definition of the formal standard. The definition of mapping_target (MappingTarget) has been restricted to be of the type cartesian_transformation_operator
/// (IfcCartesianTransformationOperator).
/// 
/// HISTORY  New entity in IFC Release 2x.
/// 
/// Informal Propositions
/// 
/// A mapped item shall not be self-defining by participating in the definition of the representation being mapped.
///   The dimensionality of the mapping source and the mapping target has to be the same, if the mapping source is a geometric representation item.
class IFC_PARSE_API IfcMappedItem : public IfcRepresentationItem {
public:
    /// A representation map that is the source of the mapped item. It can be seen as a block (or cell or marco) definition.
    ::Ifc2x3::IfcRepresentationMap* MappingSource() const;
    void setMappingSource(::Ifc2x3::IfcRepresentationMap* v);
    /// A representation item that is the target onto which the mapping source is mapped. It is constraint to be a Cartesian transformation operator.
    ::Ifc2x3::IfcCartesianTransformationOperator* MappingTarget() const;
    void setMappingTarget(::Ifc2x3::IfcCartesianTransformationOperator* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcMappedItem (IfcEntityInstanceData* e);
    IfcMappedItem (::Ifc2x3::IfcRepresentationMap* v1_MappingSource, ::Ifc2x3::IfcCartesianTransformationOperator* v2_MappingTarget);
    typedef IfcTemplatedEntityList< IfcMappedItem > list;
};
/// IfcMaterialDefinitionRepresentation defines presentation information relating to IfcMaterial. It allows for multiple presentations of the same material for different geometric representation contexts.
/// 
/// NOTE  The IfcMaterialDefinitionRepresentation is currently only used
/// to define presentation information to material used at element
/// occurrences, defined as subtypes of IfcElement, or at
/// element types, defined as subtypes of IfcElementType. The
/// IfcMaterial is assigned to the subtype of
/// IfcElement, or IfcElementType using the
/// IfcRelAssociatesMaterial relationship (eventually via
/// other material related entities IfcMaterialLayerSetUsage,
/// IfcMaterialLayerSet, IfcMaterialLayer, or
/// IfcMaterialProfileSetUsage, IfcMaterialProfileSet,
/// IfcMaterialProfile).
/// 
/// The IfcMaterialDefinitionRepresentation can apply
/// 
/// different presentation styles for different representation contexts, for example, a different style for sketch view, model view or plan view, or for different target scales,
/// for each representation context is can apply curve style, fill area style (hatching), symbol, text and surface style.
/// 
/// HISTORY  New entity in IFC2x3.
/// 
/// IFC2x3 CHANGE  The entity IfcMaterialDefinitionRepresentation has been added. Upward compatibility for file based exchange is guaranteed.
/// 
/// IFC2x4 CHANGE  The assignment of curve, surface and other styles to an IfcStyledItem has been simplified by IfcStyleAssignmentSelect. The use of intermediate IfcPresentationStyleAssignment is deprecated.
/// 
/// Use definition
/// 
/// As shown in Figure 331, the presentation assignment can be specific to a representation context by adding one and more IfcStyledRepresentation's. Each of them includes a single IfcStyledItem with exactly zero or one style for either curve, fill area, surface, text or symbol style that is applicable.
/// 
/// Figure 331 — Material definition representation
class IFC_PARSE_API IfcMaterialDefinitionRepresentation : public IfcProductRepresentation {
public:
    /// Reference to the material to which the representation applies.
    ::Ifc2x3::IfcMaterial* RepresentedMaterial() const;
    void setRepresentedMaterial(::Ifc2x3::IfcMaterial* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcMaterialDefinitionRepresentation (IfcEntityInstanceData* e);
    IfcMaterialDefinitionRepresentation (boost::optional< std::string > v1_Name, boost::optional< std::string > v2_Description, IfcTemplatedEntityList< ::Ifc2x3::IfcRepresentation >::ptr v3_Representations, ::Ifc2x3::IfcMaterial* v4_RepresentedMaterial);
    typedef IfcTemplatedEntityList< IfcMaterialDefinitionRepresentation > list;
};

class IFC_PARSE_API IfcMechanicalConcreteMaterialProperties : public IfcMechanicalMaterialProperties {
public:
    /// Whether the optional attribute CompressiveStrength is defined for this IfcMechanicalConcreteMaterialProperties
    bool hasCompressiveStrength() const;
    double CompressiveStrength() const;
    void setCompressiveStrength(double v);
    /// Whether the optional attribute MaxAggregateSize is defined for this IfcMechanicalConcreteMaterialProperties
    bool hasMaxAggregateSize() const;
    double MaxAggregateSize() const;
    void setMaxAggregateSize(double v);
    /// Whether the optional attribute AdmixturesDescription is defined for this IfcMechanicalConcreteMaterialProperties
    bool hasAdmixturesDescription() const;
    std::string AdmixturesDescription() const;
    void setAdmixturesDescription(std::string v);
    /// Whether the optional attribute Workability is defined for this IfcMechanicalConcreteMaterialProperties
    bool hasWorkability() const;
    std::string Workability() const;
    void setWorkability(std::string v);
    /// Whether the optional attribute ProtectivePoreRatio is defined for this IfcMechanicalConcreteMaterialProperties
    bool hasProtectivePoreRatio() const;
    double ProtectivePoreRatio() const;
    void setProtectivePoreRatio(double v);
    /// Whether the optional attribute WaterImpermeability is defined for this IfcMechanicalConcreteMaterialProperties
    bool hasWaterImpermeability() const;
    std::string WaterImpermeability() const;
    void setWaterImpermeability(std::string v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcMechanicalConcreteMaterialProperties (IfcEntityInstanceData* e);
    IfcMechanicalConcreteMaterialProperties (::Ifc2x3::IfcMaterial* v1_Material, boost::optional< double > v2_DynamicViscosity, boost::optional< double > v3_YoungModulus, boost::optional< double > v4_ShearModulus, boost::optional< double > v5_PoissonRatio, boost::optional< double > v6_ThermalExpansionCoefficient, boost::optional< double > v7_CompressiveStrength, boost::optional< double > v8_MaxAggregateSize, boost::optional< std::string > v9_AdmixturesDescription, boost::optional< std::string > v10_Workability, boost::optional< double > v11_ProtectivePoreRatio, boost::optional< std::string > v12_WaterImpermeability);
    typedef IfcTemplatedEntityList< IfcMechanicalConcreteMaterialProperties > list;
};
/// An IfcObjectDefinition is the generalization of any
/// semantically treated thing or process, either being a type or an
/// occurrences. Object defintions can be named, using the inherited
/// Name attribute, which should be a user recognizable label
/// for the object occurrance. Further explanations to the object can
/// be given using the inherited Description attribute. A
/// context is a specific kind of object definition as it provides the
/// project or library context in which object types and object
/// occurrences are defined.
/// Objects are independent pieces of information that might contain
/// or reference other pieces of information. There are four essential
/// kinds of relationships in which object definitons (by their
/// instantiable subtypes) can be involved:
/// 
/// Assignment of other objects - an assignment relationship
/// (IfcRelAssigns) that refers to other types of objects and
/// creates a bi-directional association. The semantic of the
/// assignment is established at the level of the subtypes of the
/// general IfcRelAssigns relationship. There is no dependency
/// implied a priori by the assignment.
/// Association to external resources - an association
/// relationship (IfcRelAssociates) that refers to external
/// sources of information (most notably a classification or document)
/// and creates a uni-directional association. There is no dependency
/// implied by the association.
/// Aggregation of other objects - an aggregation
/// relationship (IfcRelAggregates) that establishes an
/// unordered, spatial whole/part relation and creates a bi-directional
/// relation. There is an implied dependency established.
/// Nesting of other objects - a nesting relationship
/// (IfcRelNests) that establishes an ordered, non-spatial
/// whole/part relation and creates a bi-directional relation. There is
/// an implied dependency established.
/// Declaration within a context - a relationship
/// (IfcRelDeclares) of the uppermost object definition within
/// the object definition tree (e.g. the summary object within an
/// object nesting tree) to the context (a project or project library).
/// It applies the units, representation context and other context
/// information to this object definition and all dependent ones.
/// 
/// EXCEPTION  The link
/// between the uppermost object in the spatial structure tree, that is
/// IfcSite or ifcBuilding, and the context provided
/// by IfcProject is created using the
/// IfcRelAggregates relationship. See IfcProject for
/// more information.
/// 
/// HISTORY New abstract entity in IFC2x3.
/// 
/// IFC2x4 CHANGE The new subtype IfcContext and the relationship to context HasContext has been added . The decomposition relationship is split into ordered nesting (Nests, IsNestedBy) and un-ordered aggregating (Decomposes, IsDecomposedBy).
class IFC_PARSE_API IfcObjectDefinition : public IfcRoot {
public:
        IfcTemplatedEntityList< IfcRelAssigns >::ptr HasAssignments() const; // INVERSE IfcRelAssigns::RelatedObjects
    IfcTemplatedEntityList< IfcRelDecomposes >::ptr IsDecomposedBy() const; // INVERSE IfcRelDecomposes::RelatingObject
    IfcTemplatedEntityList< IfcRelDecomposes >::ptr Decomposes() const; // INVERSE IfcRelDecomposes::RelatedObjects
    IfcTemplatedEntityList< IfcRelAssociates >::ptr HasAssociations() const; // INVERSE IfcRelAssociates::RelatedObjects
    virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcObjectDefinition (IfcEntityInstanceData* e);
    IfcObjectDefinition (std::string v1_GlobalId, ::Ifc2x3::IfcOwnerHistory* v2_OwnerHistory, boost::optional< std::string > v3_Name, boost::optional< std::string > v4_Description);
    typedef IfcTemplatedEntityList< IfcObjectDefinition > list;
};
/// Definition from ISO/CD 10303-46:1992: A one time repeat factor is a vector used in the fill area style hatching and fill area style tiles entities for determining the origin of the repeated hatch line relative to the origin of the previous hatch line, Given the initial position of any hatch line, the one direction repeat factor determines two new positions according to the equation: 
/// 
/// I + k * R    k X{-1,1}
/// 
/// NOTE: Corresponding ISO 10303 name: one_direction_repeat_factor. Please refer to ISO/IS 10303-46:1994, p. 112 for the final definition of the formal standard.
/// 
/// HISTORY: New entity in IFC2x2.
class IFC_PARSE_API IfcOneDirectionRepeatFactor : public IfcGeometricRepresentationItem {
public:
    /// A vector which specifies the relative positioning of hatch lines.
    ::Ifc2x3::IfcVector* RepeatFactor() const;
    void setRepeatFactor(::Ifc2x3::IfcVector* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcOneDirectionRepeatFactor (IfcEntityInstanceData* e);
    IfcOneDirectionRepeatFactor (::Ifc2x3::IfcVector* v1_RepeatFactor);
    typedef IfcTemplatedEntityList< IfcOneDirectionRepeatFactor > list;
};
/// Definition from ISO/CD 10303-42:1992: An open shell is a shell of
///   the dimensionality 2. Its domain, if present, is a finite, connected, oriented,
///   2-manifold with boundary, but is not a closed surface. It can be thought of as
///   a closed shell with one or more holes punched in it. The domain of an open
///   shell satisfies 0
///   < Ξ < 1. An open shell is
///   functionally more general than a face because its domain can have handles. 
///   The shell is defined by a collection of faces, which may be oriented
///   faces. The sense of each face, after taking account of the orientation, shall
///   agree with the shell normal as defined below. The orientation can be supplied
///   directly as a BOOLEAN attribute of an oriented face, or be defaulted to TRUE if
///   the shell member is a face without the orientation attribute. 
///   The following combinatorial restrictions on open shells and geometrical
///   restrictions on their domains are designed, together with the informal
///   propositions, to ensure that any domain associated with an open shell is an
///   orientable manifold. 
/// 
/// Each face reference shall be unique.  
///   An open shell shall have at least one face.  
///   A given face may exist in more than one open shell. 
/// 
/// The boundary of an open shell consists of the edges that are referenced
///   only once by the face - bounds (loops) of its faces, together with all of their
///   vertices. The domain of an open shell, if present, contains all edges and
///   vertices of its faces. 
/// 
/// NOTE  Note that this is slightly different from the
///   definition of a face domain, which includes none of its bounds. For example, a
///   face domain may exclude an isolated point or line segment. An open shell domain
///   may not. (See the algorithm for computing below.) 
///   In the current IFC Release only poly loops
///   (IfcPolyLoop) are defined for bounds of face bound
///   (IfcFaceBound.Bound). This will allow for faceted B-rep only. For
///   further specification, including the Euler formulas to be satisfied, please
///   refer to ISO 10303-42:1994. 
/// 
/// NOTE  Corresponding ISO 10303 entity:
///   open_shell, please refer to ISO/IS 10303-42:1994, p.148 for the final
///   definition of the formal standard.
/// 
/// HISTORY  New class in IFC2x.
/// 
/// Informal propositions: 
/// 
/// Every edge shall be referenced exactly twice by the face bounds of
///   the face.  
///   Each oriented edge shall be unique.  
///   No edge shall be referenced by more than two faces.  
///   Distinct faces of the shell do not intersect, but may share edges or
///   vertices.  
///   Distinct edges do not intersect but may share vertices.  
///   Each face reference shall be unique.  
///   The loops of the shell shall not be a mixture of poly loop and other
///   loop types. Note: this is given, since only poly loop is defined as face bound
///   definition.  
///   The closed shell shall be an oriented arcwise connected 2-manifold.
/// 
/// The Euler equation shall be satisfied. Note: Please refer to ISO/IS
///   10303-42:1994, p.148 for the equation.
class IFC_PARSE_API IfcOpenShell : public IfcConnectedFaceSet {
public:
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcOpenShell (IfcEntityInstanceData* e);
    IfcOpenShell (IfcTemplatedEntityList< ::Ifc2x3::IfcFace >::ptr v1_CfsFaces);
    typedef IfcTemplatedEntityList< IfcOpenShell > list;
};
/// Definition from ISO/CD 10303-42:1992: An oriented edge is an edge constructed from another edge and contains a BOOLEAN direction flag to indicate whether or not the orientation of the constructed edge agrees with the orientation of the original edge. Except for perhaps orientation, the oriented edge is equivalent to the original edge.  
/// 
/// NOTE  A common practice is solid modelling systems is to have an entity that represents the "use" or "traversal" of an edge. This "use" entity explicitly represents the requirement in a manifold solid that each edge must be traversed exactly twice, once in each direction. The "use" functionality is provided by the edge subtype oriented edge.
/// 
/// NOTE  Corresponding ISO 10303 entity: oriented_edge. Please refer to ISO/IS 10303-42:1994, p. 133 for the final definition of the formal standard.
/// 
/// HISTORY  New Entity in IFC Release 2.0.
class IFC_PARSE_API IfcOrientedEdge : public IfcEdge {
public:
    /// Edge entity used to construct this oriented edge.
    ::Ifc2x3::IfcEdge* EdgeElement() const;
    void setEdgeElement(::Ifc2x3::IfcEdge* v);
    /// BOOLEAN, If TRUE the topological orientation as used coincides with the orientation from start vertex to end vertex of the edge element. If FALSE otherwise.
    bool Orientation() const;
    void setOrientation(bool v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcOrientedEdge (IfcEntityInstanceData* e);
    IfcOrientedEdge (::Ifc2x3::IfcEdge* v3_EdgeElement, bool v4_Orientation);
    typedef IfcTemplatedEntityList< IfcOrientedEdge > list;
};
/// The parameterized profile definition
/// defines a 2D position coordinate system to which the parameters of the
/// different profiles relate to. All profiles are defined centric to the
/// origin of the position coordinate system, or more specific, the origin
/// [0.,0.] shall be in the center of the bounding box of the profile.
/// 
/// The Position attribute of IfcParameterizedProfileDef
/// is used to position the profile within the XY plane of the underlying
/// coordinate system of the swept surface geometry, the swept area
/// solid or the sectioned spine. It can be used to position the profile at
/// any point which becomes the origin [0.,0.,0.] of the extruded
/// or rotated surface or solid.
/// 
/// The Position attribute should not be used if the transformation
/// can be specified in a containing object instead.  In particular, this
/// applies if the IfcParameterizedProfileDef is referenced as
/// SweptArea in subtypes of IfcSweptAreaSolid or as
/// CrossSections in IfcSectionedSpine.
/// 
/// Several subtypes of IfcParameterizedProfileDef provide
/// shape parameters which are optional. Sending systems should always
/// provide values for these parameters if possible. If these parameters
/// are left unspecified, receiving systems may retrieve values for them
/// by external reference (if a reference to an external document or library
/// is given; see guidance at IfcProfileDef), or estimate them, or
/// simply assume zero values.
/// 
/// HISTORY  New entity in IFC2x2.
/// 
/// IFC2x Platform CHANGE  The IfcParameterizedProfileDef
/// is introduced as an intermediate new abstract entity that unifies the
/// definition and usage of the position coordinate system for all
/// parameterized profiles. The Position attribute has been removed at all
/// subtypes (like IfcRectangleProfileDef, IfcCircleProfileDef,
/// etc.).
/// 
/// IFC2x3 CHANGE  All profile origins are now in the center
/// of the bounding box.
/// 
/// IFC2x4 CHANGE  Position attribute made optional (default: identity transformation).
/// Several radius parameters in subtypes have been changed from optional IfcPositiveLengthMeasure (assumed default: 0.) to optional IfcNonNegativeLengthMeasure (default: unspecified).  This change allows to explicitly specify zero radius.  Sending systems shall export 0. values if parameters are known to be 0.
/// Subtypes IfcCraneRailAShapeProfileDef and IfcCraneRailFShapeProfileDef deleted.  Rail profiles shall be modeled as IfcArbitraryClosedProfileDef or as IfcAsymmetricIShapeProfileDef together with appropriate external reference.
class IFC_PARSE_API IfcParameterizedProfileDef : public IfcProfileDef {
public:
    /// Position coordinate system of the parameterized profile definition. If unspecified, no translation and no rotation is applied.
    ::Ifc2x3::IfcAxis2Placement2D* Position() const;
    void setPosition(::Ifc2x3::IfcAxis2Placement2D* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcParameterizedProfileDef (IfcEntityInstanceData* e);
    IfcParameterizedProfileDef (::Ifc2x3::IfcProfileTypeEnum::Value v1_ProfileType, boost::optional< std::string > v2_ProfileName, ::Ifc2x3::IfcAxis2Placement2D* v3_Position);
    typedef IfcTemplatedEntityList< IfcParameterizedProfileDef > list;
};
/// Definition from ISO/CD 10303-42:1992: A path is a topological entity consisting of an ordered collection of oriented edges, such that the edge start vertex of each edge coincides with the edge end of its predecessor. The path is ordered from the edge start of the first oriented edge to the edge end of the last edge. The BOOLEAN value sense in the oriented edge indicates whether the edge direction agrees with the direction of the path (TRUE) or is the opposite direction (FALSE).  
/// 
/// An individual edge can only be referenced once by an individual path. An edge can be referenced by multiple paths. An edge can exist independently of a path.  
/// 
/// NOTE  Corresponding ISO 10303 entity: path. Please refer to ISO/IS 10303-42:1994, p. 133 for the final definition of the formal standard.
/// 
/// HISTORY  New Entity in IFC Release 2.0
/// 
/// Informal proposition:
/// 
/// A path has dimensionality 1.
/// A path is arcwise connected.
/// The edges of the path do not intersect except at common vertices.
/// A path has a finite, non-zero extent.
class IFC_PARSE_API IfcPath : public IfcTopologicalRepresentationItem {
public:
    /// The list of oriented edges which are concatenated together to form this path.
    IfcTemplatedEntityList< ::Ifc2x3::IfcOrientedEdge >::ptr EdgeList() const;
    void setEdgeList(IfcTemplatedEntityList< ::Ifc2x3::IfcOrientedEdge >::ptr v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcPath (IfcEntityInstanceData* e);
    IfcPath (IfcTemplatedEntityList< ::Ifc2x3::IfcOrientedEdge >::ptr v1_EdgeList);
    typedef IfcTemplatedEntityList< IfcPath > list;
};
/// The complex physical quantity, IfcPhysicalComplexQuantity, is an entity that holds a set of single quantity measure value (as defined at the subtypes of IfcPhysicalSimpleQuantity), that all apply to a given component or aspect of the element. 
/// 
/// EXAMPLE: A layered element, like a wall, may have several material layers, each having individual quantities, like footprint area, side area and volume. An instance of IfcPhysicalComplexQuantity would group these individual quantities (given by a subtype of IfcPhysicalSimpleQuantity) and name them according to the material layer name by using the Name attribute. The Discrimination attribute would then be 'layer'.
/// 
/// A section "Quantity Use Definition" at individual entities as subtypes of IfcBuildingElement gives guidance to the usage of the Name and Discrimination attribute to characterize the complex quantities.
/// 
/// HISTORY  New entity in IFC2x2 Addendum 1.
/// 
/// IFC2x2 ADDENDUM 1 CHANGE  The entity IfcPhysicalComplexQuantity has been added. Upward compatibility for file based exchange is guaranteed.
class IFC_PARSE_API IfcPhysicalComplexQuantity : public IfcPhysicalQuantity {
public:
    /// Set of physical quantities that are grouped by this complex physical quantity according to a given discrimination.
    IfcTemplatedEntityList< ::Ifc2x3::IfcPhysicalQuantity >::ptr HasQuantities() const;
    void setHasQuantities(IfcTemplatedEntityList< ::Ifc2x3::IfcPhysicalQuantity >::ptr v);
    /// Identification of the discrimination by which this physical complex property is distinguished. Examples of discriminations are 'layer', 'steel bar diameter', etc.
    std::string Discrimination() const;
    void setDiscrimination(std::string v);
    /// Whether the optional attribute Quality is defined for this IfcPhysicalComplexQuantity
    bool hasQuality() const;
    /// Additional indication of a quality of the quantities that are grouped under this physical complex quantity.
    std::string Quality() const;
    void setQuality(std::string v);
    /// Whether the optional attribute Usage is defined for this IfcPhysicalComplexQuantity
    bool hasUsage() const;
    /// Additional indication of a usage type of the quantities that are grouped under this physical complex quantity.
    std::string Usage() const;
    void setUsage(std::string v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcPhysicalComplexQuantity (IfcEntityInstanceData* e);
    IfcPhysicalComplexQuantity (std::string v1_Name, boost::optional< std::string > v2_Description, IfcTemplatedEntityList< ::Ifc2x3::IfcPhysicalQuantity >::ptr v3_HasQuantities, std::string v4_Discrimination, boost::optional< std::string > v5_Quality, boost::optional< std::string > v6_Usage);
    typedef IfcTemplatedEntityList< IfcPhysicalComplexQuantity > list;
};
/// An IfcPixelTexture provides a 2D image-based texture map as an explicit array of pixel values (list of Pixel binary attributes). In contrary to the IfcImageTexture the IfcPixelTexture holds a 2 dimensional list of pixel color
/// (and opacity) directly, instead of referencing to an URL.
/// 
/// The following definitions from ISO/IEC 19775-1 X3D Architecture and base components (X3D Specification) apply:
/// 
/// The PixelTexture node defines a 2D image-based texture map as an explicit array of pixel values (image field) and parameters controlling tiling repetition of the texture onto geometry.
/// Texture maps are defined in a 2D coordinate system (s, t) that ranges from 0.0 to 1.0 in both directions. The bottom edge of the pixel image corresponds to the S-axis of the texture map, and left edge of the pixel image corresponds to the T-axis of the texture map. The lower-left pixel of the pixel image corresponds to s=0.0, t=0.0, and the top-right pixel of the image corresponds to s = 1.0, t = 1.0.
/// The Image field specifies a single uncompressed 2-dimensional pixel image. Image fields contain three integers representing the width, height and number of components in the image, followed by width×height hexadecimal values representing the pixels in the image. Pixel values are limited to 256 levels of intensity (that is, 0x00-0xFF hexadecimal).
/// 
/// A one-component image specifies one-byte hexadecimal value representing the intensity of the image. For example, 0xFF is full intensity in hexadecimal (255 in decimal), 0x00 is no intensity (0 in decimal).
/// A two-component image specifies the intensity in the first
/// (high) byte and the alpha opacity in the second (low) byte.
/// Pixels in a three-component image specify the red component in the first (high) byte, followed by the green and blue components (for example, 0xFF0000 is red, 0x00FF00 is green, 0x0000FF is blue).
/// Four-component images specify the alpha opacity byte after red/green/blue (e.g., 0x0000FF80 is semi-transparent blue). A value of 00 is completely transparent, FF is completely opaque, 80 is semi-transparent.
/// 
/// Note that alpha equals (1.0 -transparency), if alpha and transparency each range from 0.0 to 1.0.
/// 
/// HISTORY: New class in IFC2x2.
class IFC_PARSE_API IfcPixelTexture : public IfcSurfaceTexture {
public:
    /// The number of pixels in width (S) direction.
    int Width() const;
    void setWidth(int v);
    /// The number of pixels in height (T) direction.
    int Height() const;
    void setHeight(int v);
    /// Indication whether the pixel values contain a 1, 2, 3, or 4 colour component.
    int ColourComponents() const;
    void setColourComponents(int v);
    /// Flat list of hexadecimal values, each describing one pixel by 1, 2, 3, or 4 components.
    /// 
    /// IFC2x Edition 3 CHANGE  The data type has been changed from STRING to BINARY.
    std::vector< boost::dynamic_bitset<> > /*[1:?]*/ Pixel() const;
    void setPixel(std::vector< boost::dynamic_bitset<> > /*[1:?]*/ v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcPixelTexture (IfcEntityInstanceData* e);
    IfcPixelTexture (bool v1_RepeatS, bool v2_RepeatT, ::Ifc2x3::IfcSurfaceTextureEnum::Value v3_TextureType, ::Ifc2x3::IfcCartesianTransformationOperator2D* v4_TextureTransform, int v5_Width, int v6_Height, int v7_ColourComponents, std::vector< boost::dynamic_bitset<> > /*[1:?]*/ v8_Pixel);
    typedef IfcTemplatedEntityList< IfcPixelTexture > list;
};
/// Definition from ISO/CD 10303-42:1992: A placement entity defines the local environment for the definition of a geometry item. It locates the item to be defined and, in the case of the axis placement subtypes, gives its orientation. 
/// 
/// Additional definition from ISO/WD SC4/WG12/N071 Part42.2 geometry_schema: A placement locates a geometric item with respect to the coordinate system of its geometric context. 
/// 
/// IfcPlacement is an abstract supertype not to be directly instantiated, whereas the ISO 10303-42 entity placement can be instantiated to define a placement without orientation. The derived attribute Dim has been added, see also note at IfcGeometricRepresentationItem.  
/// 
/// NOTE: Corresponding ISO 10303 entity: placement. Please refer to ISO/IS 10303-42:1994, p. 27 for the final definition of the formal standard.
/// 
/// HISTORY: New entity in IFC Release 1.0
class IFC_PARSE_API IfcPlacement : public IfcGeometricRepresentationItem {
public:
    /// The geometric position of a reference point, such as the center of a circle, of the item to be located.
    ::Ifc2x3::IfcCartesianPoint* Location() const;
    void setLocation(::Ifc2x3::IfcCartesianPoint* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcPlacement (IfcEntityInstanceData* e);
    IfcPlacement (::Ifc2x3::IfcCartesianPoint* v1_Location);
    typedef IfcTemplatedEntityList< IfcPlacement > list;
};
/// The planar extent defines the extent along the two axes of the two-dimensional coordinate system, independently of its position.
/// 
/// NOTE  Corresponding ISO 10303 name: planar_extent. Please refer to ISO/IS 10303-46:1994, p. 141 for the final definition of the formal standard.
/// 
/// HISTORY  New entity in IFC2x2.
class IFC_PARSE_API IfcPlanarExtent : public IfcGeometricRepresentationItem {
public:
    /// The extent in the direction of the x-axis.
    double SizeInX() const;
    void setSizeInX(double v);
    /// The extent in the direction of the y-axis.
    double SizeInY() const;
    void setSizeInY(double v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcPlanarExtent (IfcEntityInstanceData* e);
    IfcPlanarExtent (double v1_SizeInX, double v2_SizeInY);
    typedef IfcTemplatedEntityList< IfcPlanarExtent > list;
};
/// Definition from ISO/CD 10303-42:1992: A point is a location in some real Cartesian coordinate space Rm, for m = 1, 2 or 3.  
/// 
/// NOTE: Corresponding ISO 10303 entity: point. Only the subtypes cartesian_point, point_on_curve, point_on_surface have been incorporated in the current release of IFC. Please refer to ISO/IS 10303-42:1994, p. 22 for the final definition of the formal standard.
/// 
/// HISTORY: New entity in IFC Release 1.5
class IFC_PARSE_API IfcPoint : public IfcGeometricRepresentationItem {
public:
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcPoint (IfcEntityInstanceData* e);
    IfcPoint ();
    typedef IfcTemplatedEntityList< IfcPoint > list;
};
/// Definition from ISO/CD 10303-42:1992: A point on curve is a point which lies on a curve. The point is determined by evaluating the curve at a specific parameter value. The coordinate space dimensionality of the point is that of the basis curve. 
/// 
/// NOTE: Corresponding STEP entity: point_on_curve. Please refer to ISO/IS 10303-42:1994, p. 23 for the final definition of the formal standard.
/// 
/// HISTORY: New entity in Release IFC2x Edition 2.
/// 
/// Informal Propositions: 
/// 
/// The value of the point parameter shall not be outside the parametric range of the curve.
class IFC_PARSE_API IfcPointOnCurve : public IfcPoint {
public:
    /// The curve to which point parameter relates.
    ::Ifc2x3::IfcCurve* BasisCurve() const;
    void setBasisCurve(::Ifc2x3::IfcCurve* v);
    /// The parameter value of the point location.
    double PointParameter() const;
    void setPointParameter(double v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcPointOnCurve (IfcEntityInstanceData* e);
    IfcPointOnCurve (::Ifc2x3::IfcCurve* v1_BasisCurve, double v2_PointParameter);
    typedef IfcTemplatedEntityList< IfcPointOnCurve > list;
};
/// Definition from ISO/CD 10303-42:1992: A point on surface is a point which lies on a parametric surface. The point is determined by evaluating the surface at a particular pair of parameter values. 
/// 
/// NOTE: Corresponding ISO 10303 entity: point_on_surface. Please refer to ISO/IS 10303-42:1994, p. 24 for the final definition of the formal standard.  
/// 
/// HISTORY: New entity in Release IFC2x Edition 2.
/// 
/// Informal Propositions: 
/// 
/// The parametric values specified for u and v shall not be outside the parametric range of the basis surface.
class IFC_PARSE_API IfcPointOnSurface : public IfcPoint {
public:
    /// The surface to which the parameter values relate.
    ::Ifc2x3::IfcSurface* BasisSurface() const;
    void setBasisSurface(::Ifc2x3::IfcSurface* v);
    /// The first parameter value of the point location.
    double PointParameterU() const;
    void setPointParameterU(double v);
    /// The second parameter value of the point location.
    double PointParameterV() const;
    void setPointParameterV(double v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcPointOnSurface (IfcEntityInstanceData* e);
    IfcPointOnSurface (::Ifc2x3::IfcSurface* v1_BasisSurface, double v2_PointParameterU, double v3_PointParameterV);
    typedef IfcTemplatedEntityList< IfcPointOnSurface > list;
};
/// Definition from ISO/CD 10303-42:1992: A
/// poly loop is a loop with straight edges bounding a planar region in
/// space. A poly loop is a loop of genus 1 where the loop is represented
/// by an ordered coplanar collection of points forming the vertices of the
/// loop. The loop is composed of straight line segments joining a point in
/// the collection to the succeeding point in the collection. The closing
/// segment is from the last to the first point in the collection. 
/// The direction of the loop is in the direction of the line
/// segments. 
/// 
/// NOTE  This entity exists primarily to facilitate the efficient communication of faceted B-rep models.
/// 
/// A poly loop shall conform to the following topological
/// constraints:
/// 
/// - the loop has the genus of one.
///   - the following equation shall be satisfied
/// 
/// The IfcPolyLoop
/// is always closed and the last segment is from the last IfcCartesianPoint
/// in the list of Polygon's to the first IfcCartesianPoint.
/// Therefore the first point shall not be repeated at the end of the list,
/// neither by referencing the same instance, nor by using an additional
/// instance of IfcCartesianPoint having the
/// coordinates as the first point.
/// 
/// NOTE  Corresponding ISO 10303 entity: poly_loop. Please refer to ISO/IS
/// 10303-42:1994, p. 138 for the final definition of the formal standard.
/// Due to the general IFC model specification rule not to use multiple
/// inheritance, the subtype relationship to geometric_representation_item
/// is not included. The derived attribute Dim has been
/// added at this level.
/// 
/// HISTORY   New class in IFC Release 1.0
/// 
/// Informal propositions: 
/// 
/// All the points in the polygon defining the poly loop shall be coplanar.
///   The first and the last Polygon shall be different by value.
class IFC_PARSE_API IfcPolyLoop : public IfcLoop {
public:
    /// List of points defining the loop. There are no repeated points in the list.
    IfcTemplatedEntityList< ::Ifc2x3::IfcCartesianPoint >::ptr Polygon() const;
    void setPolygon(IfcTemplatedEntityList< ::Ifc2x3::IfcCartesianPoint >::ptr v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcPolyLoop (IfcEntityInstanceData* e);
    IfcPolyLoop (IfcTemplatedEntityList< ::Ifc2x3::IfcCartesianPoint >::ptr v1_Polygon);
    typedef IfcTemplatedEntityList< IfcPolyLoop > list;
};
/// The polygonal bounded
/// half space is a special subtype of a half space solid, where the
/// material of the half space used in Boolean expressions is bounded by a
/// polygonal boundary. The base
/// surface of the half space is positioned by its normal relativeto the
/// object coordinate system
/// (as defined at the supertype IfcHalfSpaceSolid), and
/// its polygonal (with or without arc segments) boundary is defined in the
/// XY plane of the position
/// coordinate system established by the Position
/// attribute, the subtraction body is extruded perpendicular to the XY
/// plane of the position coordinate system, that is, into the direction of the
/// positive Z axis defined by the Position attribute.
/// The boundary is defined by a 2 dimensional polyline (or 2 dimensional composite curve,
/// consisting of straight segments and circular arc segments)
/// within the
/// XY plane of the position coordinate system. The side of the surface
/// which is in the half space is determined by the surface normal and the
/// agreement flag. If the agreement flag is TRUE, then the subset is the
/// one the normal points away from. If the agreement flag is FALSE, then
/// the subset is the one the normal points into. 
/// 
/// NOTE  A polygonal bounded half space is not a subtype of IfcSolidModel, half space solids are only useful as operands in Boolean expressions.
/// 
/// HISTORY  New class in IFC Release 2x.
/// 
/// Informal propositions:
/// 
/// The IfcPolyline or the IfcCompositeCurve
/// providing the PolygonalBoundary
/// shall be closed.
///   If the PolygonalBoundary
/// is given by an IfcCompositeCurve, it shall only
/// have IfcCompositeCurveSegment's of type IfcPolyline,
/// or IfcTrimmedCurve (having a BasisCurve
/// of type IfcLine, or IfcCircle)
/// 
/// Figure 259 illustrates a polygonal bounded half space.
/// 
/// Black coordinates indicate the object coordinate system (usually provided by IfcLocalPlacement).
/// Green coordinates indicate the position coordinate system; the PolygonalBoundary is given within this coordinate system. It is provided by IfcPolygonalBoundedHalfSpace.Position. This coordinate system is relative to the object coordinate system. The extrusion direction of the subtraction body is the positive Z axis.
/// Red coordinates indicate the normal of the plane. It is provided by the BaseSurface (IfcSurface.Position). This normal is also relative to the object coordinate system.
/// 
/// Figure 259 — Polygonal half space geometry
/// 
/// Purpose
/// The polygonal bounded half space is used to limit the volume of the
/// half space in Boolean difference expressions. Only the part that is
/// defined by a theoretical intersection between the half space solid and
/// an extruded area solid, defined by extruding the polygonal boundary, is
/// used for Boolean expressions.
///   Parameter
/// The PolygonalBoundary defines the 2D polyline which
/// bounds the effectiveness of the half space in Boolean expressions. The BaseSurface
/// is defined by a plane, and the normal of the plane together with the AgreementFlag
/// defines the side of the material of the half space.
class IFC_PARSE_API IfcPolygonalBoundedHalfSpace : public IfcHalfSpaceSolid {
public:
    /// Definition of the position coordinate system for the bounding polyline and the base surface.
    ::Ifc2x3::IfcAxis2Placement3D* Position() const;
    void setPosition(::Ifc2x3::IfcAxis2Placement3D* v);
    /// Two-dimensional polyline bounded curve, defined in the xy plane of the position coordinate system.
    /// 
    /// IFC2x Edition 3 CHANGE  The attribute type has been changed from IfcPolyline to its supertype IfcBoundedCurve with upward compatibility for file based exchange.
    ::Ifc2x3::IfcBoundedCurve* PolygonalBoundary() const;
    void setPolygonalBoundary(::Ifc2x3::IfcBoundedCurve* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcPolygonalBoundedHalfSpace (IfcEntityInstanceData* e);
    IfcPolygonalBoundedHalfSpace (::Ifc2x3::IfcSurface* v1_BaseSurface, bool v2_AgreementFlag, ::Ifc2x3::IfcAxis2Placement3D* v3_Position, ::Ifc2x3::IfcBoundedCurve* v4_PolygonalBoundary);
    typedef IfcTemplatedEntityList< IfcPolygonalBoundedHalfSpace > list;
};
/// The pre defined colour determines those qualified names which can be used to identify a colour that is in scope of the current data exchange specification (in contrary to colour specification which defines the colour directly by its colour components).
/// 
/// NOTE  Corresponding ISO 10303 name: pre_defined_colour. It has been made into an abstract entity in IFC. Please refer to ISO/IS 10303-46:1994, p. 141 for the final definition of the formal standard.
/// 
/// HISTORY  New entity in IFC2x2.
class IFC_PARSE_API IfcPreDefinedColour : public IfcPreDefinedItem {
public:
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcPreDefinedColour (IfcEntityInstanceData* e);
    IfcPreDefinedColour (std::string v1_Name);
    typedef IfcTemplatedEntityList< IfcPreDefinedColour > list;
};
/// Definition from ISO/CD 10303-46:1992: The predefined curve font type is an abstract supertype provided to define an application specific curve font. The name label shall be constrained in the application protocol to values that are given specific meaning for curve fonts in that application protocol.
/// 
/// NOTE: The IfcPreDefinedCurveFont is an abstract entity, subtypes of it provide the predefined curve font by agreement of the values of the inherited Name attribute. Currently the only subtype provided is IfcDraughtingPreDefinedCurveFont.
/// 
/// NOTE: Corresponding ISO 10303 name: pre_defined_curve_font. Please refer to ISO/IS 10303-46:1994, p. 103 for the final definition of the formal standard.
/// 
/// HISTORY: New entity in IFC2x2.
class IFC_PARSE_API IfcPreDefinedCurveFont : public IfcPreDefinedItem {
public:
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcPreDefinedCurveFont (IfcEntityInstanceData* e);
    IfcPreDefinedCurveFont (std::string v1_Name);
    typedef IfcTemplatedEntityList< IfcPreDefinedCurveFont > list;
};

class IFC_PARSE_API IfcPreDefinedDimensionSymbol : public IfcPreDefinedSymbol {
public:
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcPreDefinedDimensionSymbol (IfcEntityInstanceData* e);
    IfcPreDefinedDimensionSymbol (std::string v1_Name);
    typedef IfcTemplatedEntityList< IfcPreDefinedDimensionSymbol > list;
};

class IFC_PARSE_API IfcPreDefinedPointMarkerSymbol : public IfcPreDefinedSymbol {
public:
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcPreDefinedPointMarkerSymbol (IfcEntityInstanceData* e);
    IfcPreDefinedPointMarkerSymbol (std::string v1_Name);
    typedef IfcTemplatedEntityList< IfcPreDefinedPointMarkerSymbol > list;
};
/// The IfcProductDefinitionShape defines all shape relevant information about an IfcProduct. It allows for multiple geometric shape representations of the same product. The shape relevant information includes:
/// 
/// the shape representation including geometric representation items (for 3D solids, 2D annotations, etc.) and:
/// 
/// associated presentation information (line color, line type, surface rendering properties)
/// assignment to presentation layers (CAD layers for visibility control)
/// 
/// or the topological representation items for connectivity systems (vertex, edge, face representations) that may include geometric representation items (vertex points, edge curves, face surfaces)
/// 
/// NOTE  The definition of this entity relates to the ISO 10303 entity product_definition_shape. Please refer to ISO/IS 10303-41:1994 for the final definition of the formal standard.
/// 
/// HISTORY  New Entity in IFC Release 1.5
class IFC_PARSE_API IfcProductDefinitionShape : public IfcProductRepresentation {
public:
        IfcTemplatedEntityList< IfcProduct >::ptr ShapeOfProduct() const; // INVERSE IfcProduct::Representation
    IfcTemplatedEntityList< IfcShapeAspect >::ptr HasShapeAspects() const; // INVERSE IfcShapeAspect::PartOfProductDefinitionShape
    virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcProductDefinitionShape (IfcEntityInstanceData* e);
    IfcProductDefinitionShape (boost::optional< std::string > v1_Name, boost::optional< std::string > v2_Description, IfcTemplatedEntityList< ::Ifc2x3::IfcRepresentation >::ptr v3_Representations);
    typedef IfcTemplatedEntityList< IfcProductDefinitionShape > list;
};
/// A property with a bounded
///   value, IfcPropertyBoundedValue, defines a property
///   object which has a maximum of two (numeric or descriptive)
///   values assigned, the first value specifying the upper bound
///   and the second value specifying the lower bound. It defines
///   a property - value bound (min-max) combination for which
///   the property Name, an optional
///   Description,ÿthe optional UpperBoundValue
///   with measure type, the optional LowerBoundValue with
///   measure type, and the optional Unit is given.
/// 
/// A set point value can be provided in addition to the upper and lower bound values for operational value setting.
/// 
/// The unit is handled by the Unit attribute:
/// 
/// If the Unit attribute is not given, then the
///   unit is already implied by the type of
///   IfcMeasureValue or IfcDerivedMeasureValue.
///   The associated unit can be found at the
///   IfcUnitAssignment globally defined at the project
///   level (IfcProject.UnitsInContext).
/// 
/// If the Unit attribute is given, then the unit
///   assigned by the Unit attribute overrides the
///   globally assigned unit.
/// 
/// The IfcPropertyBoundedValue allows for the
///   specification of an interval for the value component of the
///   property description. If either the
///   LowerBoundValue or the UpperBoundValue is not
///   given, then it indicates an open bound (either a minimum
///   value or a maximum value). The interval is by definition
///   inclusive, that is, the value given for the
///   LowerBoundValue or the UpperBoundValue is
///   included in the interval.
/// 
/// NOTE  An IfcPropertyBoundedValue may be
///   exchanged with no values assigned yet. In this case the
///   LowerBoundValue and the UpperBoundValue are
///   set to NIL.
/// 
/// Examples of a property with bounded value are:
/// 
/// Name
/// 
/// UpperBoundValue
/// 
/// LowerBoundValue
/// 
/// SetPointValue
/// 
/// Type (through
///   IfcValue, WR1 ensures same type for both
///   values)
/// 
/// Unit
/// 
/// OverallHeight
/// 
/// 1930
/// 
/// 2300
/// 
/// IfcPositiveLengthMeasure
/// 
/// -
/// 
/// OverallWidth
/// 
/// 0.9
/// 
/// 1.25
/// 
/// IfcPositiveLengthMeasure
/// 
/// m
/// 
/// MaxHeight
/// 
/// 20.0
/// 
/// IfcPositiveLengthMeasure
/// 
/// -
/// 
/// MinWeight
/// 
/// 20
/// 
/// IfcMassMeasure
/// 
/// kg
/// 
/// HISTORY ÿNew entity in IFC Release 2x.
/// 
/// IFC2x2 CHANGE  The attribute type of the attribute UpperBoundValue and LowerBoundValue has been changed from mandatory to optional with upward compatibility for file based exchange.
/// 
/// IFC2x4 CHANGE  The attribute SetPointValue has been added.
/// 
/// Informal proposition:
/// 
/// If the measure type for the upper and lover bound value
///   is a numeric measure, then the following shall be true: 
///   UpperBoundValue > LowerBoundValue.
class IFC_PARSE_API IfcPropertyBoundedValue : public IfcSimpleProperty {
public:
    /// Whether the optional attribute UpperBoundValue is defined for this IfcPropertyBoundedValue
    bool hasUpperBoundValue() const;
    /// Upper bound value for the interval defining the property value. If the value is not given, it indicates an open bound (all values to be greater than or equal to LowerBoundValue).
    ::Ifc2x3::IfcValue* UpperBoundValue() const;
    void setUpperBoundValue(::Ifc2x3::IfcValue* v);
    /// Whether the optional attribute LowerBoundValue is defined for this IfcPropertyBoundedValue
    bool hasLowerBoundValue() const;
    /// Lower bound value for the interval defining the property value. If the value is not given, it indicates an open bound (all values to be lower than or equal to UpperBoundValue).
    ::Ifc2x3::IfcValue* LowerBoundValue() const;
    void setLowerBoundValue(::Ifc2x3::IfcValue* v);
    /// Whether the optional attribute Unit is defined for this IfcPropertyBoundedValue
    bool hasUnit() const;
    /// Unit for the upper and lower bound values, if not given, the default value for the measure type is used as defined by the global unit assignment at IfcProject.UnitInContext. The applicable unit is then selected by the underlying TYPE of the UpperBoundValue, LowerBoundValue, and SetPointValue)
    ::Ifc2x3::IfcUnit* Unit() const;
    void setUnit(::Ifc2x3::IfcUnit* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcPropertyBoundedValue (IfcEntityInstanceData* e);
    IfcPropertyBoundedValue (std::string v1_Name, boost::optional< std::string > v2_Description, ::Ifc2x3::IfcValue* v3_UpperBoundValue, ::Ifc2x3::IfcValue* v4_LowerBoundValue, ::Ifc2x3::IfcUnit* v5_Unit);
    typedef IfcTemplatedEntityList< IfcPropertyBoundedValue > list;
};
/// IfcPropertyDefinition defines the generalization of
/// all characteristics (i.e. a grouping of individual properties),
/// that may be assigned to objects. Currently, subtypes of
/// IfcPropertyDefinition include property set occurrences,
/// property set templates, and property templates.
/// 
/// Property set template -
/// IfcPropertySetTemplate, a collection of property templates
/// that determine the definition of properties used within a project
/// context.
/// Property template -
/// IfcPropertyTemplate, a single template that determines the
/// definition of a particular property used in the same project
/// context. The template may determine the name, description, data
/// type, the unit, or a standard expression for each property that is
/// based on that template.
/// Property set occurrence -
/// IfcPropertySet, a set of individual properties (that may
/// or may not be determined by a property template) holding individual
/// values, measure types and units, and are associated to an object
/// occurrence or object type.
/// 
/// NOTE 1  The subtype hierarchy of IfcPropertyDefinition also includes statically defined property sets as IfcPreDefinedPropertySet. Those are rarely used collections of fixed attributes combined in an entity definition. The IfcPreDefinedPropertySet can not be determined by an IfcPropertySetTemplate.
/// 
/// NOTE 2  Individual properties, (subtypes of IfcProperty), are currently not included in the subtype hierarchy of IfcPropertyDefinition. This anomaly is due to upward compatibility reasons with earlier releases of this
/// standard.
/// 
/// HISTORY  New Entity in IFC2.0
/// 
/// Relationship use definition
/// Property definitions define information that is shared among
/// multiple instances of objects, either object occurrences or object
/// types. IfcPropertyDefinition's (by their instantiable
/// subtypes) can participated within the following relationships:
/// 
/// Assignment to a project context - an
/// HasContext relationship to IfcRelDeclares that
/// establishes the project context in which this property definition
/// is declared. This relationship is predominately applicable to
/// subtypes of IfcPropertyTemplateDefinition.
/// Association to external resources - an
/// HasAssociation relationship to IfcRelAssociates
/// that refers to external sources of information (most notably a
/// classification or document) and creates a uni-directional
/// association. There is no dependency implied by the
/// association.
/// 
/// Subtypes are included in more specific relationships, see
/// IfcPropertySetDefinition and
/// IfcPropertyTemplateDefinition for details.
class IFC_PARSE_API IfcPropertyDefinition : public IfcRoot {
public:
        IfcTemplatedEntityList< IfcRelAssociates >::ptr HasAssociations() const; // INVERSE IfcRelAssociates::RelatedObjects
    virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcPropertyDefinition (IfcEntityInstanceData* e);
    IfcPropertyDefinition (std::string v1_GlobalId, ::Ifc2x3::IfcOwnerHistory* v2_OwnerHistory, boost::optional< std::string > v3_Name, boost::optional< std::string > v4_Description);
    typedef IfcTemplatedEntityList< IfcPropertyDefinition > list;
};
/// A property with an enumerated
/// value, IfcPropertyEnumeratedValue, defines a property
/// object which has a value assigned that is chosen from an
/// enumeration. It defines a property - value combination for which
/// theÿproperty Name, an optional Description,ÿthe
/// optional EnumerationValues
/// with measure type and optionally an Unit is given.
/// 
/// NOTE  Multiple choices from the property enumeration are supported.
/// 
/// The unit is handled by the Unit attribute of the
/// IfcPropertyEnumeration:
/// 
/// If the Unit attribute is not given, then the unit is
/// already implied by the type of IfcMeasureValue or
/// IfcDerivedMeasureValue. The associated unit can be found
/// at the IfcUnitAssignment globally defined at the project
/// level (IfcProject.UnitsInContext).
/// If the Unit attribute is given, then the unit assigned
/// by the unit attribute overrides the globally assigned unit.
/// 
/// More precisely: The IfcPropertyEnumeratedValue defines
/// a property, which value is selected from a defined list of
/// enumerators. The enumerators are stored in a dynamic enumeration
/// of values including the type information from IfcValue
/// (see IfcPropertyEnumeration). This enables applications to
/// use an enumeration value as a property within a property set
/// (IfcPropertySet) including the allowed list of
/// values.ÿ
/// 
/// NOTE  An IfcPropertyEnumeratedValue may be exchanged with no values assigned yet. In this case the EnumerationValues are set to NIL.
/// 
/// Examples of a property with enumerated value are:
/// 
/// Nameÿ
/// Value (EnumerationValue)
/// Type (through
/// IfcValue)
/// ref.IfcPropertyEnumeration
/// (Name)ÿ
/// 
/// BladeAction
/// Opposed
/// IfcString
/// DamperBladeActionEnum
/// 
/// BladeAction
/// Parallel
/// IfcString
/// DamperBladeActionEnum
/// 
/// The IfcPropertyEnumeratedValue refers to an
/// IfcPropertyEnumeration, e.g. for the above:
/// 
/// Name
/// EnumerationValues
/// Type (through
/// IfcValue)
/// Unit
/// 
/// DamperBladeActionEnum
/// (Parallel, Opposed, Other, Unset)
/// IfcString
/// -
/// 
/// It is not mandatory to use an instance of
/// IfcPropertyEnumeration to hold the applicable values for
/// IfcPropertyEnumeratedValue, however this is the preferred
/// way. A single instance of IfcPropertyEnumeration can be
/// referenced by multiple instances of
/// IfcPropertyEnumeratedValue.
/// 
/// HISTORY ÿNew Entity in IFC Release 2.0, capabilities enhanced in IFC2x. The entity has
/// been renamed from IfcEnumeratedProperty in IFC2x.
/// 
/// IFC2x4 CHANGE Attribute EnumerationValues has been made OPTIONAL with upward
/// compatibility for file based exchange.
class IFC_PARSE_API IfcPropertyEnumeratedValue : public IfcSimpleProperty {
public:
    /// Enumeration values, which shall be listed in the referenced IfcPropertyEnumeration, if such a reference is provided.
    /// 
    /// IFC2x4 CHANGE  The attribute has been made optional with upward compatibility for file based exchange.
    IfcEntityList::ptr EnumerationValues() const;
    void setEnumerationValues(IfcEntityList::ptr v);
    /// Whether the optional attribute EnumerationReference is defined for this IfcPropertyEnumeratedValue
    bool hasEnumerationReference() const;
    /// Enumeration from which a enumeration value has been selected. The referenced enumeration also establishes the unit of the enumeration value.
    ::Ifc2x3::IfcPropertyEnumeration* EnumerationReference() const;
    void setEnumerationReference(::Ifc2x3::IfcPropertyEnumeration* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcPropertyEnumeratedValue (IfcEntityInstanceData* e);
    IfcPropertyEnumeratedValue (std::string v1_Name, boost::optional< std::string > v2_Description, IfcEntityList::ptr v3_EnumerationValues, ::Ifc2x3::IfcPropertyEnumeration* v4_EnumerationReference);
    typedef IfcTemplatedEntityList< IfcPropertyEnumeratedValue > list;
};
/// An IfcPropertyListValue
///   defines a property that has several (numeric or
///   descriptive) values assigned, these values are given by an
///   ordered list.ÿIt defines a property - list value
///   combination for which the property Name, an optional
///   Description,ÿthe optional ListValues with measure
///   type and optionally an Unit is given.
/// 
/// An IfcPropertyListValue is a list of values. The
///   order in which values appear is significant. Each value in
///   the list is unique i.e. no duplicate values are allowed.
///   All list members shall be of the same type.
/// 
/// The unit applicable to all values is handled by the
///   Unit attribute:
/// 
/// If the Unit attribute is not given, then the
///   unit is already implied by the type of
///   IfcMeasureValue or IfcDerivedMeasureValue.
///   The associated unit can be found at the
///   IfcUnitAssignment globally defined at the project
///   level (IfcProject.UnitsInContext).
/// 
/// If the Unit attribute is given, then the unit
///   assigned by the Unit attribute overrides the
///   globally assigned unit.
/// 
/// Example of a property with list value is:
/// 
/// Name
/// 
/// ListValues
/// 
/// Type (through
///   IfcValue)
/// 
/// Unit
/// 
/// ApplicableSizes
/// 
/// 1200
/// 
/// IfcPositiveLengthMeasure
/// 
/// -
/// 
/// -
/// 
/// 1600
/// 
/// IfcPositiveLengthMeasure
/// 
/// -
/// 
/// -
/// 
/// 2400
/// 
/// IfcPositiveLengthMeasure
/// 
/// -
/// 
/// HISTORY  New Entity in Release IFC 2x Edition 2.
/// 
/// IFC2x4 CHANGE  Attribute ListValues has been made OPTIONAL with upward compatibility for file based exchange.
class IFC_PARSE_API IfcPropertyListValue : public IfcSimpleProperty {
public:
    /// List of property values.
    /// 
    /// IFC2x4 CHANGE  The attribute has been made optional with upward compatibility for file based exchange.
    IfcEntityList::ptr ListValues() const;
    void setListValues(IfcEntityList::ptr v);
    /// Whether the optional attribute Unit is defined for this IfcPropertyListValue
    bool hasUnit() const;
    /// Unit for the list values, if not given, the default value for the measure type (given by the TYPE of nominal value) is used as defined by the global unit assignment at IfcProject.
    ::Ifc2x3::IfcUnit* Unit() const;
    void setUnit(::Ifc2x3::IfcUnit* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcPropertyListValue (IfcEntityInstanceData* e);
    IfcPropertyListValue (std::string v1_Name, boost::optional< std::string > v2_Description, IfcEntityList::ptr v3_ListValues, ::Ifc2x3::IfcUnit* v4_Unit);
    typedef IfcTemplatedEntityList< IfcPropertyListValue > list;
};
/// IfcPropertyReferenceValue allows a property value to
///   be given by referencing other entities within the resource
///   definitions of IFC. Those other entities are regarded as
///   predefined complex properties and can be aggregated within
///   a property set (IfcPropertySet). The allowable
///   entities to be used as value references are given by the
///   IfcObjectReferenceSelect.
/// 
/// HISTORY  New entity in IFC
///   Release 1.5. Entity has been renamed from
///   IfcObjectReference in IFC Release 2x.
/// 
/// IFC2x4 CHANGE  Attribute
///   PropertyReference has been made OPTIONAL with upward
///   compatibility for file based exchange.
class IFC_PARSE_API IfcPropertyReferenceValue : public IfcSimpleProperty {
public:
    /// Whether the optional attribute UsageName is defined for this IfcPropertyReferenceValue
    bool hasUsageName() const;
    /// Description of the use of the referenced value within the property.
    std::string UsageName() const;
    void setUsageName(std::string v);
    /// Reference to another property entity through one of the select types in the IfcObjectReferenceSelect.
    /// 
    /// IFC2x4 CHANGE  The attribute has been made optional with upward compatibility for file based exchange.
    ::Ifc2x3::IfcObjectReferenceSelect* PropertyReference() const;
    void setPropertyReference(::Ifc2x3::IfcObjectReferenceSelect* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcPropertyReferenceValue (IfcEntityInstanceData* e);
    IfcPropertyReferenceValue (std::string v1_Name, boost::optional< std::string > v2_Description, boost::optional< std::string > v3_UsageName, ::Ifc2x3::IfcObjectReferenceSelect* v4_PropertyReference);
    typedef IfcTemplatedEntityList< IfcPropertyReferenceValue > list;
};
/// IfcPropertySetDefinition is a generalization of all
/// individual property sets that can be assigned to an object or type
/// object. The property set definition can be either:
/// 
/// Dynamically extendable property sets -
/// IfcPropertySet, a set of properties for which the IFC
/// model only provides a kind of "meta model", to be further declared
/// by agreement. This means no entity definition of the properties
/// exists within the IFC model. The declaration is done by assigning a
/// significant string value to the Name attribute of the
/// entity as defined in the entity IfcPropertySet and at each
/// subtype of IfcProperty, referenced by the property set.
/// Dynamically defined property sets may have an underlying template
/// provided by IfcPropertySetTemplate.
/// Statically defined property sets -
/// IfcPreDefinedPropertySet, a property set entity that
/// exists within the IFC specification. The semantic meaning of each
/// statically defined property set is declared by its entity type and
/// the meaning of the properties is defined by the name and data type
/// of the explicit attribute representing it.
/// 
/// HISTORY  New Entity in IFC Release 2x
/// 
/// IFC2x4 CHANGE  The subtype IfcPreDefinedPropertySet has been added.
/// 
/// Relationship use definition
/// Property set definitions define information that is shared among
/// multiple instances of objects, either object occurrences or object
/// types. IfcPropertySetDefinition's (by their instantiable
/// subtypes) can participated within the following relationships:
/// 
/// Assignment to object types - an
/// DefinesType direct relationship to IfcTypeObject
/// that applies the property set, with all included properties, to the
/// object type. Those properties apply to all object occurrences
/// having the same object type.
/// Assignment to object occurrences - an
/// DefinesOccurrence relationship to
/// IfcRelDefinesByProperties that applies the property set,
/// with all included properties, to the object occurrence.
/// 
/// NOTE  Properties assigned to object occurrences may override properties assigned to the object type. See IfcRelDefinesByType for further information.
class IFC_PARSE_API IfcPropertySetDefinition : public IfcPropertyDefinition {
public:
        IfcTemplatedEntityList< IfcRelDefinesByProperties >::ptr PropertyDefinitionOf() const; // INVERSE IfcRelDefinesByProperties::RelatingPropertyDefinition
    IfcTemplatedEntityList< IfcTypeObject >::ptr DefinesType() const; // INVERSE IfcTypeObject::HasPropertySets
    virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcPropertySetDefinition (IfcEntityInstanceData* e);
    IfcPropertySetDefinition (std::string v1_GlobalId, ::Ifc2x3::IfcOwnerHistory* v2_OwnerHistory, boost::optional< std::string > v3_Name, boost::optional< std::string > v4_Description);
    typedef IfcTemplatedEntityList< IfcPropertySetDefinition > list;
};
/// The property with a single value
/// IfcPropertySingleValue defines a property object which has
/// a single (numeric or descriptive) value assigned. It defines a
/// property - single value combination for which the property
/// Name, an optional Description,ÿand an optional
/// NominalValue with measure type is provided. In addition,
/// the default unit as specified within the project unit context can
/// be overriden by assigning an Unit.
/// The unit is handled by the Unit attribute:
/// 
/// If the Unit attribute is not given, then the unit is
/// already implied by the type of IfcMeasureValue or
/// IfcDerivedMeasureValue. The associated unit can be found
/// at the IfcUnitAssignment globally defined at the project
/// level (IfcProject.UnitsInContext).
/// If the Unit attribute is given, then the unit assigned
/// by the Unit attribute overrides the globally assigned
/// unit.
/// 
/// Examples of a property with single value are:
/// 
/// Name
/// NominalValue
/// Type (through IfcValue)
/// Unit
/// 
/// Description
/// Manufacturer "A" door
/// IfcLabel
/// -
/// 
/// PanelThickness
/// 0.12
/// IfcPositiveLengthMeasure
/// -
/// 
/// ThermalTransmittance
/// 2.6
/// IfcThermalTransmittanceMeasure
/// W/(m2K)
/// 
/// HISTORY ÿNew entity in IFC Release 1.0. The entity has been renamed from IfcSimpleProperty in IFC Release 2x.
/// 
/// IFC2x3 CHANGE ÿAttribute NominalValue has been made OPTIONAL with upward compatibility for file based exchange.
class IFC_PARSE_API IfcPropertySingleValue : public IfcSimpleProperty {
public:
    /// Whether the optional attribute NominalValue is defined for this IfcPropertySingleValue
    bool hasNominalValue() const;
    /// Value and measure type of this property. 
    /// 
    /// NOTE  By virtue of the defined data type, that is selected from the SELECT IfcValue, the appropriate unit can be found within the IfcUnitAssignment, defined for the project if no value for the unit attribute is given.
    /// 
    /// IFC2x3 CHANGE  The attribute has been made optional with upward compatibility for file based exchange.
    ::Ifc2x3::IfcValue* NominalValue() const;
    void setNominalValue(::Ifc2x3::IfcValue* v);
    /// Whether the optional attribute Unit is defined for this IfcPropertySingleValue
    bool hasUnit() const;
    /// Unit for the nominal value, if not given, the default value for the measure type (given by the TYPE of nominal value) is used as defined by the global unit assignment at IfcProject.
    ::Ifc2x3::IfcUnit* Unit() const;
    void setUnit(::Ifc2x3::IfcUnit* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcPropertySingleValue (IfcEntityInstanceData* e);
    IfcPropertySingleValue (std::string v1_Name, boost::optional< std::string > v2_Description, ::Ifc2x3::IfcValue* v3_NominalValue, ::Ifc2x3::IfcUnit* v4_Unit);
    typedef IfcTemplatedEntityList< IfcPropertySingleValue > list;
};
/// A property with a range value
///   (IfcPropertyTableValue) defines a property object
///   which has two lists of (numeric or descriptive) values
///   assigned, the values specifying a table with two columns.
///   The defining values provide the first column and establish
///   the scope for the defined values (the second column).
///   Interpolations are out of scope of the
///   IfcPropertyTableValue. An optional Expression
///   attribute may give the equation used for deriving the range
///   value, which is for information purposes only.
/// 
/// The IfcPropertyTableValue defines a defining/defined
///   property value combination for which the property name, the
///   table with defining and defined values with measure type
///   (and optional the units for defining and defined values)
///   are given.
/// 
/// The units are handled by the DefiningUnit and
///   DefinedUnit attributes:
/// 
/// If the DefiningUnit or DefinedUnit
///   attribute is not given, then the unit is already implied by
///   the type of IfcMeasureValue or
///   IfcDerivedMeasureValue. The associated unit can be
///   found at the IfcUnitAssignment globally defined at
///   the project level (IfcProject.UnitsInContext).
/// 
/// If the DefiningUnit or DefinedUnit
///   attribute is given, then the unit assigned by the unit
///   attribute overrides the globally assigned unit.
/// 
/// The IfcPropertyTableValue allows for the
///   specification of a table of defining/defined value pairs of
///   the property description. The optional 
///   attribute CurveInterpolation allows to determine the 
///   interval between two given values.
/// 
/// Examples of a property with range value are:
/// 
/// Name
/// 
/// DefiningValues
/// 
/// DefiningValue Type (through IfcValue)
/// 
/// DefinedValues
/// 
/// DefinedValue Type (through
///   IfcValue)
/// 
/// DefingUnit
/// 
/// DefinedUnit
/// 
/// SoundTransmissionLoss
/// 
/// 100
/// 
/// IfcFrequencyMeasure
/// 
/// 20
/// 
/// IfcNumericMeasure
/// 
/// -
/// 
/// dB
/// 
/// ÿ
/// 
/// 200
/// 
/// IfcFrequencyMeasure
/// 
/// 42
/// 
/// IfcNumericMeasure
/// 
/// ÿ
/// 
/// ÿ
/// 
/// ÿ
/// 
/// 400
/// 
/// IfcFrequencyMeasure
/// 
/// 46
/// 
/// IfcNumericMeasure
/// 
/// ÿ
/// 
/// ÿ
/// 
/// ÿ
/// 
/// 800
/// 
/// IfcFrequencyMeasure
/// 
/// 56
/// 
/// IfcNumericMeasure
/// 
/// ÿ
/// 
/// ÿ
/// 
/// ÿ
/// 
/// 1600
/// 
/// IfcFrequencyMeasure
/// 
/// 60
/// 
/// IfcNumericMeasure
/// 
/// ÿ
/// 
/// ÿ
/// 
/// ÿ
/// 
/// 3200
/// 
/// IfcFrequencyMeasure
/// 
/// 65
/// 
/// IfcNumericMeasure
/// 
/// ÿ
/// 
/// ÿ
/// 
/// HISTORY: New entity in IFC2x.
/// 
/// IFC2x4 CHANGE  Attributes DefiningValues and DefinedValues have been made OPTIONAL with upward compatibility for file based exchange. The attribute CurveInterpolation has been added..
/// 
/// Informal propositions:
/// 
/// The list of DefinedValues and the list of
///   DefiningValues are corresponding lists.
class IFC_PARSE_API IfcPropertyTableValue : public IfcSimpleProperty {
public:
    /// List of defining values, which determine the defined values. This list shall have unique values only.
    /// 
    /// IFC2x4 CHANGE  The attribute has been made optional with upward compatibility for file based exchange.
    IfcEntityList::ptr DefiningValues() const;
    void setDefiningValues(IfcEntityList::ptr v);
    /// Defined values which are applicable for the scope as defined by the defining values.
    /// 
    /// IFC2x4 CHANGE  The attribute has been made optional with upward compatibility for file based exchange.
    IfcEntityList::ptr DefinedValues() const;
    void setDefinedValues(IfcEntityList::ptr v);
    /// Whether the optional attribute Expression is defined for this IfcPropertyTableValue
    bool hasExpression() const;
    /// Expression for the derivation of defined values from the defining values, the expression is given for information only, i.e. no automatic processing can be expected from the expression.
    std::string Expression() const;
    void setExpression(std::string v);
    /// Whether the optional attribute DefiningUnit is defined for this IfcPropertyTableValue
    bool hasDefiningUnit() const;
    /// Unit for the defining values, if not given, the default value for the measure type (given by the TYPE of the defining values) is used as defined by the global unit assignment at IfcProject.
    ::Ifc2x3::IfcUnit* DefiningUnit() const;
    void setDefiningUnit(::Ifc2x3::IfcUnit* v);
    /// Whether the optional attribute DefinedUnit is defined for this IfcPropertyTableValue
    bool hasDefinedUnit() const;
    /// Unit for the defined values, if not given, the default value for the measure type (given by the TYPE of the defined values) is used as defined by the global unit assignment at IfcProject.
    ::Ifc2x3::IfcUnit* DefinedUnit() const;
    void setDefinedUnit(::Ifc2x3::IfcUnit* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcPropertyTableValue (IfcEntityInstanceData* e);
    IfcPropertyTableValue (std::string v1_Name, boost::optional< std::string > v2_Description, IfcEntityList::ptr v3_DefiningValues, IfcEntityList::ptr v4_DefinedValues, boost::optional< std::string > v5_Expression, ::Ifc2x3::IfcUnit* v6_DefiningUnit, ::Ifc2x3::IfcUnit* v7_DefinedUnit);
    typedef IfcTemplatedEntityList< IfcPropertyTableValue > list;
};
/// IfcRectangleProfileDef defines a rectangle as the profile definition used by the swept surface geometry or the swept area solid. It is given by its X extent and its Y extent, and placed within the 2D position coordinate system, established by the Position attribute. It is placed centric within the position coordinate system. 
/// 
/// HISTORY: New class in IFC 1.5. The use definition has changed in IFC Release 2x.
/// 
/// Figure 323 illustrates parameters of the rectangle profile definition.
/// 
/// Position
/// 
/// The parameterized profile defines its own position coordinate system.
/// The underlying
/// coordinate system is defined by the swept surface or swept area solid
/// that uses the profile definition. It is the xy plane of either: 
/// 
/// IfcSweptSurface.Position
///   IfcSweptAreaSolid.Position
/// 
/// or in case of sectioned spines the xy plane of each list member of IfcSectionedSpine.CrossSectionPositions.
/// 
/// By using offsets of the position location, the parameterized profile
/// can be positioned centric (using x,y offsets = 0.), or at any position
/// relative to the profile. Explicit coordinate offsets are used to define
/// cardinal points (for example, upper-left bound).
///   Parameter
/// 
/// The IfcRectangleProfileDef
/// is defined within the position
/// coordinate system, where the XDim
/// defines the length measure
/// for the length of the rectangle (half along the positive x-axis) and
/// the YDim
/// defines the length measure for the width of the
/// rectangle (half along the positive y-axis).
/// 
/// Figure 323 — Rectangle profile
class IFC_PARSE_API IfcRectangleProfileDef : public IfcParameterizedProfileDef {
public:
    /// The extent of the rectangle in the direction of the x-axis.
    double XDim() const;
    void setXDim(double v);
    /// The extent of the rectangle in the direction of the y-axis.
    double YDim() const;
    void setYDim(double v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcRectangleProfileDef (IfcEntityInstanceData* e);
    IfcRectangleProfileDef (::Ifc2x3::IfcProfileTypeEnum::Value v1_ProfileType, boost::optional< std::string > v2_ProfileName, ::Ifc2x3::IfcAxis2Placement2D* v3_Position, double v4_XDim, double v5_YDim);
    typedef IfcTemplatedEntityList< IfcRectangleProfileDef > list;
};
/// In a regular time series, the data arrives predictably at predefined intervals. In a regular time series there is no need to store multiple time stamps and the algorithms for analyzing the time series are therefore significantly simpler.  Using the start time provided in the supertype, the time step is used to identify the frequency of the occurrences of the list of values.
/// 
/// EXAMPLE: A smoke detector samples the concentration of particulates in a space at a fixed rate (for example, every six seconds); a control system measures the outside air temperature every hour.
/// 
/// HISTORY: New entity in IFC 2x2.
class IFC_PARSE_API IfcRegularTimeSeries : public IfcTimeSeries {
public:
    /// A duration of time intervals between values.
    double TimeStep() const;
    void setTimeStep(double v);
    /// The collection of time series values.
    IfcTemplatedEntityList< ::Ifc2x3::IfcTimeSeriesValue >::ptr Values() const;
    void setValues(IfcTemplatedEntityList< ::Ifc2x3::IfcTimeSeriesValue >::ptr v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcRegularTimeSeries (IfcEntityInstanceData* e);
    IfcRegularTimeSeries (std::string v1_Name, boost::optional< std::string > v2_Description, ::Ifc2x3::IfcDateTimeSelect* v3_StartTime, ::Ifc2x3::IfcDateTimeSelect* v4_EndTime, ::Ifc2x3::IfcTimeSeriesDataTypeEnum::Value v5_TimeSeriesDataType, ::Ifc2x3::IfcDataOriginEnum::Value v6_DataOrigin, boost::optional< std::string > v7_UserDefinedDataOrigin, ::Ifc2x3::IfcUnit* v8_Unit, double v9_TimeStep, IfcTemplatedEntityList< ::Ifc2x3::IfcTimeSeriesValue >::ptr v10_Values);
    typedef IfcTemplatedEntityList< IfcRegularTimeSeries > list;
};
/// Definition from IAI: An
///   IfcReinforcementDefinitionProperties defines the cross section
///   properties of reinforcement included in reinforced concrete building elements.
///   The property set definition may be used both in conjunction with insitu and
///   precast structures.  
/// 
/// HISTORY New entity in IFC Release 2x2
/// IFC 2x4 change: Supertype changed from IfcPropertySetDefinition to IfcPreDefinedPropertySet
/// 
/// General usage: 
///   This subtype of IfcPropertySetDefinition is used to define the
///   reinforcement properties in early design stages, such as in requirement
///   definition or scheme design. In later design stages explicit instances of
///   subtypes of IfcReinforcingElement are used. The intended usage may be
///   indicated using the DefinitionType attribute value as a designator:
///   recommended values are 'Reinforcement area requirement' or 'Reinforcement
///   configuration requirement'. Other values may be used according to local
///   standards.  
///   Only one property set definition of this kind is used for each concrete
///   building element in each intended usage indicated by the DefinitionType
///   attribute value. This set then defines a list of cross section properties in a
///   discrete number of longitudinal sections as instances of
///   IfcSectionReinforcementProperties (one for each structural reinforcement
///   bar role), which in turn have a section cross section property defined as a
///   profile and a number of reinforcement properties, one for each steel grade /
///   bar type.
class IFC_PARSE_API IfcReinforcementDefinitionProperties : public IfcPropertySetDefinition {
public:
    /// Whether the optional attribute DefinitionType is defined for this IfcReinforcementDefinitionProperties
    bool hasDefinitionType() const;
    /// Descriptive type name applied to reinforcement definition properties.
    std::string DefinitionType() const;
    void setDefinitionType(std::string v);
    /// The list of section reinforcement properties attached to the reinforcement definition properties.
    IfcTemplatedEntityList< ::Ifc2x3::IfcSectionReinforcementProperties >::ptr ReinforcementSectionDefinitions() const;
    void setReinforcementSectionDefinitions(IfcTemplatedEntityList< ::Ifc2x3::IfcSectionReinforcementProperties >::ptr v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcReinforcementDefinitionProperties (IfcEntityInstanceData* e);
    IfcReinforcementDefinitionProperties (std::string v1_GlobalId, ::Ifc2x3::IfcOwnerHistory* v2_OwnerHistory, boost::optional< std::string > v3_Name, boost::optional< std::string > v4_Description, boost::optional< std::string > v5_DefinitionType, IfcTemplatedEntityList< ::Ifc2x3::IfcSectionReinforcementProperties >::ptr v6_ReinforcementSectionDefinitions);
    typedef IfcTemplatedEntityList< IfcReinforcementDefinitionProperties > list;
};
/// IfcRelationship is the abstract generalization of all objectified relationships in IFC. Objectified relationships are the preferred way to handle relationships among objects. This allows to keep relationship specific properties directly at the relationship and opens the possibility to later handle relationship specific behavior.  
/// 
/// There are two different types of relationships, 1-to-1 relationships and 1-to-many relationship. used within the subtypes of IfcRelationship. The following convention applies to all subtypes: 
/// 
/// The two sides of the objectified relationship are named - Relating+ and - Related+ 
/// In case of the 1-to-many relationship, the related side of the relationship shall be an aggregate SET 1:N 
/// 
/// HISTORY: New entity in IFC Release 1.0.
class IFC_PARSE_API IfcRelationship : public IfcRoot {
public:
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcRelationship (IfcEntityInstanceData* e);
    IfcRelationship (std::string v1_GlobalId, ::Ifc2x3::IfcOwnerHistory* v2_OwnerHistory, boost::optional< std::string > v3_Name, boost::optional< std::string > v4_Description);
    typedef IfcTemplatedEntityList< IfcRelationship > list;
};
/// IfcRoundedRectangleProfileDef defines a rectangle with equally rounded corners as the profile definition used by the swept surface geometry or the swept area solid. It is given by the X extent, the Y extent, and the radius for the rounded corners, and placed within the 2D position coordinate system, established by the Position attribute. It is placed centric within the position coordinate system, that is, in the center of the bounding box.
/// 
/// HISTORY  New class in IFC2x.
/// 
/// IFC2x PLATFORM CHANGE  The IfcRoundedRectangleProfileDef is now subtyped from IfcRectangleProfileDef. The XDim and YDim attributes have been removed (now inherited from supertype).
/// 
/// Figure 324 illustrates parameters of the rounded rectangle profile definition.
/// 
/// Position
/// 
/// The parameterized profile defines its own position coordinate system.
/// The underlying
/// coordinate system is defined by the swept surface or swept area solid
/// that uses the profile definition. It is the xy plane of either: 
/// 
/// IfcSweptSurface.Position
///   IfcSweptAreaSolid.Position
/// 
/// or in case of sectioned spines the xy plane of each list member of IfcSectionedSpine.CrossSectionPositions.
/// 
/// By using offsets of the position location, the parameterized profile
/// can be positioned centric (using x,y offsets = 0.), or at any position
/// relative to the profile. Explicit coordinate offsets are used to define
/// cardinal points (e.g. upper-left bound).
///   Parameter
/// 
/// The IfcRoundedRectangleProfileDef
/// is defined within the
/// position coordinate system, where the XDim
/// defines the measure
/// for the length of the rectangle (half along the positive x-axis), the YDim
/// defines the length measure for the width of the rectangle (half along
/// the positive y-axis) and the RoundingRadius
/// defines the radius
/// of curvature in all four corners of the rectangle.
/// 
/// Figure 324 — Rounded rectangle profile
class IFC_PARSE_API IfcRoundedRectangleProfileDef : public IfcRectangleProfileDef {
public:
    /// Radius of the circular arcs by which all four corners of the rectangle are equally rounded.
    double RoundingRadius() const;
    void setRoundingRadius(double v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcRoundedRectangleProfileDef (IfcEntityInstanceData* e);
    IfcRoundedRectangleProfileDef (::Ifc2x3::IfcProfileTypeEnum::Value v1_ProfileType, boost::optional< std::string > v2_ProfileName, ::Ifc2x3::IfcAxis2Placement2D* v3_Position, double v4_XDim, double v5_YDim, double v6_RoundingRadius);
    typedef IfcTemplatedEntityList< IfcRoundedRectangleProfileDef > list;
};
/// Definition from ISO 10303-42:1999: A sectioned
/// spine is a representation of the shape of a three dimensional
/// object composed of a spine curve and a number of planar cross
/// sections. The shape is defined between the first element of cross
/// sections and the last element of this set.
/// 
/// NOTE A sectioned spine may be used to represent a surface or a
/// solid but the interpolation of the shape between the
/// cross-sections is not defined. For the representation of a solid
/// all cross-sections are closed curves.
/// 
/// A sectioned spine
/// (IfcSectionedSpine) is a representation of the shape of a
/// three dimensional object composed by a number of planar cross
/// sections, and a spine curve. The shape is defined between the
/// first element of cross sections and the last element of the cross
/// sections. A sectioned spine may be used to represent a surface or
/// a solid but the interpolation of the shape between the cross
/// sections is not defined.
/// For the representation of a solid all cross sections are
/// areas. For representation of a surface all cross sections are
/// curves. The cross sections are defined as profiles, whereas the
/// consecutive profiles may be derived by a transformation of the
/// start profile or the previous consecutive profile.
/// The spine curve shall be of type IfcCompositeCurve,
/// each of its segments (IfcCompositeCurveSegment) shall
/// correspond to the part between exactly two consecutive
/// cross-sections.
/// 
/// NOTE: Corresponding ISO 10303 entity: sectioned spine. Please refer to ISO/DIS 10303-42-ed2:1999, p. 282 for the definition of the formal standard. The cross sections are defined in IFC as IfcProfileDef. The position coordinate systems are added.
/// 
/// HISTORY New entity in IFC Release 2x.
/// 
/// Figure 268 illustrates an example of an IfcSectionedSpine.
/// 
/// The SpineCurve is given by an IfcCompositeCurve with two Segments. The Segments[1] has a ParentCurve of type IfcPolyline and a Transition = CONTSAMEGRADIENT. The Segments[2] has a ParentCurve of type
/// IfcTrimmedCurve and a Transition = DISCONTINUOUS.
/// Each CrossSectionPosition lies at a start or end point of the Segments.
/// Each CrossSections are inserted by the CrossSectionPositions. The first two cross sections are of
/// type IfcRectangleProfileDef, the third is of type IfcDerivedProfileDef.
/// 
/// Figure 268 — Sectioned spine geometry
/// 
/// Figure 269 illustrates the final result of the IfcSectionedSpine. The body (shown transparently) is not fully defined by the
/// exchange definition.
/// 
/// Figure 269 — Sectioned spine result
/// 
/// Informal propositions
/// 
/// none of the cross sections, after being placed by the cross section positions, shall intersect
/// none of the cross sections, after being placed by the cross section positions, shall lie in the same plane
/// the local origin of each cross section position shall lie at the beginning or end of a composite curve segment.
class IFC_PARSE_API IfcSectionedSpine : public IfcGeometricRepresentationItem {
public:
    /// A single composite curve, that defines the spine curve. Each of the composite curve segments correspond to the part between two cross-sections.
    ::Ifc2x3::IfcCompositeCurve* SpineCurve() const;
    void setSpineCurve(::Ifc2x3::IfcCompositeCurve* v);
    /// A list of at least two cross sections, each defined within the xy plane of the position coordinate system of the cross section. The position coordinate system is given by the corresponding list CrossSectionPositions.
    IfcTemplatedEntityList< ::Ifc2x3::IfcProfileDef >::ptr CrossSections() const;
    void setCrossSections(IfcTemplatedEntityList< ::Ifc2x3::IfcProfileDef >::ptr v);
    /// Position coordinate systems for the cross sections that form the sectioned spine. The profiles defining the cross sections are positioned within the xy plane of the corresponding position coordinate system.
    IfcTemplatedEntityList< ::Ifc2x3::IfcAxis2Placement3D >::ptr CrossSectionPositions() const;
    void setCrossSectionPositions(IfcTemplatedEntityList< ::Ifc2x3::IfcAxis2Placement3D >::ptr v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcSectionedSpine (IfcEntityInstanceData* e);
    IfcSectionedSpine (::Ifc2x3::IfcCompositeCurve* v1_SpineCurve, IfcTemplatedEntityList< ::Ifc2x3::IfcProfileDef >::ptr v2_CrossSections, IfcTemplatedEntityList< ::Ifc2x3::IfcAxis2Placement3D >::ptr v3_CrossSectionPositions);
    typedef IfcTemplatedEntityList< IfcSectionedSpine > list;
};

class IFC_PARSE_API IfcServiceLifeFactor : public IfcPropertySetDefinition {
public:
    ::Ifc2x3::IfcServiceLifeFactorTypeEnum::Value PredefinedType() const;
    void setPredefinedType(::Ifc2x3::IfcServiceLifeFactorTypeEnum::Value v);
    /// Whether the optional attribute UpperValue is defined for this IfcServiceLifeFactor
    bool hasUpperValue() const;
    ::Ifc2x3::IfcMeasureValue* UpperValue() const;
    void setUpperValue(::Ifc2x3::IfcMeasureValue* v);
    ::Ifc2x3::IfcMeasureValue* MostUsedValue() const;
    void setMostUsedValue(::Ifc2x3::IfcMeasureValue* v);
    /// Whether the optional attribute LowerValue is defined for this IfcServiceLifeFactor
    bool hasLowerValue() const;
    ::Ifc2x3::IfcMeasureValue* LowerValue() const;
    void setLowerValue(::Ifc2x3::IfcMeasureValue* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcServiceLifeFactor (IfcEntityInstanceData* e);
    IfcServiceLifeFactor (std::string v1_GlobalId, ::Ifc2x3::IfcOwnerHistory* v2_OwnerHistory, boost::optional< std::string > v3_Name, boost::optional< std::string > v4_Description, ::Ifc2x3::IfcServiceLifeFactorTypeEnum::Value v5_PredefinedType, ::Ifc2x3::IfcMeasureValue* v6_UpperValue, ::Ifc2x3::IfcMeasureValue* v7_MostUsedValue, ::Ifc2x3::IfcMeasureValue* v8_LowerValue);
    typedef IfcTemplatedEntityList< IfcServiceLifeFactor > list;
};
/// Definition from ISO/CD 10303-42:1992: A shell based surface model is described by a set of open or closed shells of dimensionality 2. The shells shall not intersect except at edges and vertices. In particular, distinct faces may not intersect. A complete face of one shell may be shared with another shell. Coincident portions of shells shall both reference the same faces, edges and vertices defining the coincident region. There shall be at least one shell. 
/// 
/// A shell may exist independently of a surface model. 
/// 
/// NOTE Corresponding ISO 10303-42 entity: shell_based_surface_model. Please refer to ISO/IS 10303-42:1994, p. 187 for the final definition of the formal standard.
/// 
/// HISTORY: New entity in IFC Release 2x.
/// 
/// Informal propositions 
/// 
/// The dimensionality of the shell based surface model is 2.  
/// The shells shall not overlap or intersect except at common faces, edges or vertices.
class IFC_PARSE_API IfcShellBasedSurfaceModel : public IfcGeometricRepresentationItem {
public:
    IfcEntityList::ptr SbsmBoundary() const;
    void setSbsmBoundary(IfcEntityList::ptr v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcShellBasedSurfaceModel (IfcEntityInstanceData* e);
    IfcShellBasedSurfaceModel (IfcEntityList::ptr v1_SbsmBoundary);
    typedef IfcTemplatedEntityList< IfcShellBasedSurfaceModel > list;
};
/// Definition from IAI: Describes slippage in support conditions or connection conditions.  Slippage means that a relative displacement may occur in a support or connection before support or connection reactions are awoken.
/// 
/// Applicability:
/// 
/// Point supports and connections,
///   curve supports and connections,
///   surface supports and connections.
/// 
/// HISTORY: New entity in IFC 2x2.
class IFC_PARSE_API IfcSlippageConnectionCondition : public IfcStructuralConnectionCondition {
public:
    /// Whether the optional attribute SlippageX is defined for this IfcSlippageConnectionCondition
    bool hasSlippageX() const;
    /// Slippage in x-direction of the coordinate system defined by the instance which uses this resource object.
    double SlippageX() const;
    void setSlippageX(double v);
    /// Whether the optional attribute SlippageY is defined for this IfcSlippageConnectionCondition
    bool hasSlippageY() const;
    /// Slippage in y-direction of the coordinate system defined by the instance which uses this resource object.
    double SlippageY() const;
    void setSlippageY(double v);
    /// Whether the optional attribute SlippageZ is defined for this IfcSlippageConnectionCondition
    bool hasSlippageZ() const;
    /// Slippage in z-direction of the coordinate system defined by the instance which uses this resource object.
    double SlippageZ() const;
    void setSlippageZ(double v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcSlippageConnectionCondition (IfcEntityInstanceData* e);
    IfcSlippageConnectionCondition (boost::optional< std::string > v1_Name, boost::optional< double > v2_SlippageX, boost::optional< double > v3_SlippageY, boost::optional< double > v4_SlippageZ);
    typedef IfcTemplatedEntityList< IfcSlippageConnectionCondition > list;
};
/// Definition from ISO/CD 10303-42:1992: A solid model is a complete representation of the nominal shape of a product such that all points in the interior are connected. Any point can be classified as being inside, outside, or on the boundary of a solid. There are several different types of solid model representations. 
/// 
/// NOTE: Corresponding ISO 10303-42 entity: solid_model, only three subtypes have been incorporated into the current IFC Release - subset of manifold_solid_brep (IfcManifoldSolidBrep, constraint to faceted B-rep), swept_area_solid (IfcSweptAreaSolid), the swept_disk_solid (IfcSweptDiskSolid) and subset of csg_solid (IfcCsgSolid). The derived attribute Dim has been added at this level and was therefore demoted from the geometric_representation_item. Please refer to ISO/IS 10303-42:1994, p. 170 for the final definition of the formal standard.
/// 
/// HISTORY: New entity in IFC Release 1.5
class IFC_PARSE_API IfcSolidModel : public IfcGeometricRepresentationItem {
public:
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcSolidModel (IfcEntityInstanceData* e);
    IfcSolidModel ();
    typedef IfcTemplatedEntityList< IfcSolidModel > list;
};

class IFC_PARSE_API IfcSoundProperties : public IfcPropertySetDefinition {
public:
    bool IsAttenuating() const;
    void setIsAttenuating(bool v);
    /// Whether the optional attribute SoundScale is defined for this IfcSoundProperties
    bool hasSoundScale() const;
    ::Ifc2x3::IfcSoundScaleEnum::Value SoundScale() const;
    void setSoundScale(::Ifc2x3::IfcSoundScaleEnum::Value v);
    IfcTemplatedEntityList< ::Ifc2x3::IfcSoundValue >::ptr SoundValues() const;
    void setSoundValues(IfcTemplatedEntityList< ::Ifc2x3::IfcSoundValue >::ptr v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcSoundProperties (IfcEntityInstanceData* e);
    IfcSoundProperties (std::string v1_GlobalId, ::Ifc2x3::IfcOwnerHistory* v2_OwnerHistory, boost::optional< std::string > v3_Name, boost::optional< std::string > v4_Description, bool v5_IsAttenuating, boost::optional< ::Ifc2x3::IfcSoundScaleEnum::Value > v6_SoundScale, IfcTemplatedEntityList< ::Ifc2x3::IfcSoundValue >::ptr v7_SoundValues);
    typedef IfcTemplatedEntityList< IfcSoundProperties > list;
};

class IFC_PARSE_API IfcSoundValue : public IfcPropertySetDefinition {
public:
    /// Whether the optional attribute SoundLevelTimeSeries is defined for this IfcSoundValue
    bool hasSoundLevelTimeSeries() const;
    ::Ifc2x3::IfcTimeSeries* SoundLevelTimeSeries() const;
    void setSoundLevelTimeSeries(::Ifc2x3::IfcTimeSeries* v);
    double Frequency() const;
    void setFrequency(double v);
    /// Whether the optional attribute SoundLevelSingleValue is defined for this IfcSoundValue
    bool hasSoundLevelSingleValue() const;
    ::Ifc2x3::IfcDerivedMeasureValue* SoundLevelSingleValue() const;
    void setSoundLevelSingleValue(::Ifc2x3::IfcDerivedMeasureValue* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcSoundValue (IfcEntityInstanceData* e);
    IfcSoundValue (std::string v1_GlobalId, ::Ifc2x3::IfcOwnerHistory* v2_OwnerHistory, boost::optional< std::string > v3_Name, boost::optional< std::string > v4_Description, ::Ifc2x3::IfcTimeSeries* v5_SoundLevelTimeSeries, double v6_Frequency, ::Ifc2x3::IfcDerivedMeasureValue* v7_SoundLevelSingleValue);
    typedef IfcTemplatedEntityList< IfcSoundValue > list;
};

class IFC_PARSE_API IfcSpaceThermalLoadProperties : public IfcPropertySetDefinition {
public:
    /// Whether the optional attribute ApplicableValueRatio is defined for this IfcSpaceThermalLoadProperties
    bool hasApplicableValueRatio() const;
    double ApplicableValueRatio() const;
    void setApplicableValueRatio(double v);
    ::Ifc2x3::IfcThermalLoadSourceEnum::Value ThermalLoadSource() const;
    void setThermalLoadSource(::Ifc2x3::IfcThermalLoadSourceEnum::Value v);
    ::Ifc2x3::IfcPropertySourceEnum::Value PropertySource() const;
    void setPropertySource(::Ifc2x3::IfcPropertySourceEnum::Value v);
    /// Whether the optional attribute SourceDescription is defined for this IfcSpaceThermalLoadProperties
    bool hasSourceDescription() const;
    std::string SourceDescription() const;
    void setSourceDescription(std::string v);
    double MaximumValue() const;
    void setMaximumValue(double v);
    /// Whether the optional attribute MinimumValue is defined for this IfcSpaceThermalLoadProperties
    bool hasMinimumValue() const;
    double MinimumValue() const;
    void setMinimumValue(double v);
    /// Whether the optional attribute ThermalLoadTimeSeriesValues is defined for this IfcSpaceThermalLoadProperties
    bool hasThermalLoadTimeSeriesValues() const;
    ::Ifc2x3::IfcTimeSeries* ThermalLoadTimeSeriesValues() const;
    void setThermalLoadTimeSeriesValues(::Ifc2x3::IfcTimeSeries* v);
    /// Whether the optional attribute UserDefinedThermalLoadSource is defined for this IfcSpaceThermalLoadProperties
    bool hasUserDefinedThermalLoadSource() const;
    std::string UserDefinedThermalLoadSource() const;
    void setUserDefinedThermalLoadSource(std::string v);
    /// Whether the optional attribute UserDefinedPropertySource is defined for this IfcSpaceThermalLoadProperties
    bool hasUserDefinedPropertySource() const;
    std::string UserDefinedPropertySource() const;
    void setUserDefinedPropertySource(std::string v);
    ::Ifc2x3::IfcThermalLoadTypeEnum::Value ThermalLoadType() const;
    void setThermalLoadType(::Ifc2x3::IfcThermalLoadTypeEnum::Value v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcSpaceThermalLoadProperties (IfcEntityInstanceData* e);
    IfcSpaceThermalLoadProperties (std::string v1_GlobalId, ::Ifc2x3::IfcOwnerHistory* v2_OwnerHistory, boost::optional< std::string > v3_Name, boost::optional< std::string > v4_Description, boost::optional< double > v5_ApplicableValueRatio, ::Ifc2x3::IfcThermalLoadSourceEnum::Value v6_ThermalLoadSource, ::Ifc2x3::IfcPropertySourceEnum::Value v7_PropertySource, boost::optional< std::string > v8_SourceDescription, double v9_MaximumValue, boost::optional< double > v10_MinimumValue, ::Ifc2x3::IfcTimeSeries* v11_ThermalLoadTimeSeriesValues, boost::optional< std::string > v12_UserDefinedThermalLoadSource, boost::optional< std::string > v13_UserDefinedPropertySource, ::Ifc2x3::IfcThermalLoadTypeEnum::Value v14_ThermalLoadType);
    typedef IfcTemplatedEntityList< IfcSpaceThermalLoadProperties > list;
};
/// Definition from IAI: An instance of the entity
///   IfcStructuralLoadLinearForce shall be used to define actions on curves.
/// 
/// HISTORY: New entity in Release IFC2x
///   edition 2.
class IFC_PARSE_API IfcStructuralLoadLinearForce : public IfcStructuralLoadStatic {
public:
    /// Whether the optional attribute LinearForceX is defined for this IfcStructuralLoadLinearForce
    bool hasLinearForceX() const;
    /// Linear force value in x-direction.
    double LinearForceX() const;
    void setLinearForceX(double v);
    /// Whether the optional attribute LinearForceY is defined for this IfcStructuralLoadLinearForce
    bool hasLinearForceY() const;
    /// Linear force value in y-direction.
    double LinearForceY() const;
    void setLinearForceY(double v);
    /// Whether the optional attribute LinearForceZ is defined for this IfcStructuralLoadLinearForce
    bool hasLinearForceZ() const;
    /// Linear force value in z-direction.
    double LinearForceZ() const;
    void setLinearForceZ(double v);
    /// Whether the optional attribute LinearMomentX is defined for this IfcStructuralLoadLinearForce
    bool hasLinearMomentX() const;
    /// Linear moment about the x-axis.
    double LinearMomentX() const;
    void setLinearMomentX(double v);
    /// Whether the optional attribute LinearMomentY is defined for this IfcStructuralLoadLinearForce
    bool hasLinearMomentY() const;
    /// Linear moment about the y-axis.
    double LinearMomentY() const;
    void setLinearMomentY(double v);
    /// Whether the optional attribute LinearMomentZ is defined for this IfcStructuralLoadLinearForce
    bool hasLinearMomentZ() const;
    /// Linear moment about the z-axis.
    double LinearMomentZ() const;
    void setLinearMomentZ(double v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcStructuralLoadLinearForce (IfcEntityInstanceData* e);
    IfcStructuralLoadLinearForce (boost::optional< std::string > v1_Name, boost::optional< double > v2_LinearForceX, boost::optional< double > v3_LinearForceY, boost::optional< double > v4_LinearForceZ, boost::optional< double > v5_LinearMomentX, boost::optional< double > v6_LinearMomentY, boost::optional< double > v7_LinearMomentZ);
    typedef IfcTemplatedEntityList< IfcStructuralLoadLinearForce > list;
};
/// Definition from IAI: An instance of the entity
///   IfcStructuralLoadPlanarForce shall be used to define actions on faces.
/// 
/// HISTORY: New entity in Release IFC2x
///   edition 2.
class IFC_PARSE_API IfcStructuralLoadPlanarForce : public IfcStructuralLoadStatic {
public:
    /// Whether the optional attribute PlanarForceX is defined for this IfcStructuralLoadPlanarForce
    bool hasPlanarForceX() const;
    /// Planar force value in x-direction.
    double PlanarForceX() const;
    void setPlanarForceX(double v);
    /// Whether the optional attribute PlanarForceY is defined for this IfcStructuralLoadPlanarForce
    bool hasPlanarForceY() const;
    /// Planar force value in y-direction.
    double PlanarForceY() const;
    void setPlanarForceY(double v);
    /// Whether the optional attribute PlanarForceZ is defined for this IfcStructuralLoadPlanarForce
    bool hasPlanarForceZ() const;
    /// Planar force value in z-direction.
    double PlanarForceZ() const;
    void setPlanarForceZ(double v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcStructuralLoadPlanarForce (IfcEntityInstanceData* e);
    IfcStructuralLoadPlanarForce (boost::optional< std::string > v1_Name, boost::optional< double > v2_PlanarForceX, boost::optional< double > v3_PlanarForceY, boost::optional< double > v4_PlanarForceZ);
    typedef IfcTemplatedEntityList< IfcStructuralLoadPlanarForce > list;
};
/// Definition from IAI: Instances of the entity
///   IfcStructuralLoadSingleDisplacement shall be used to define displacements.
/// 
/// HISTORY: New entity in Release IFC2x
///   edition 2.
class IFC_PARSE_API IfcStructuralLoadSingleDisplacement : public IfcStructuralLoadStatic {
public:
    /// Whether the optional attribute DisplacementX is defined for this IfcStructuralLoadSingleDisplacement
    bool hasDisplacementX() const;
    /// Displacement in x-direction.
    double DisplacementX() const;
    void setDisplacementX(double v);
    /// Whether the optional attribute DisplacementY is defined for this IfcStructuralLoadSingleDisplacement
    bool hasDisplacementY() const;
    /// Displacement in y-direction.
    double DisplacementY() const;
    void setDisplacementY(double v);
    /// Whether the optional attribute DisplacementZ is defined for this IfcStructuralLoadSingleDisplacement
    bool hasDisplacementZ() const;
    /// Displacement in z-direction.
    double DisplacementZ() const;
    void setDisplacementZ(double v);
    /// Whether the optional attribute RotationalDisplacementRX is defined for this IfcStructuralLoadSingleDisplacement
    bool hasRotationalDisplacementRX() const;
    /// Rotation about the x-axis.
    double RotationalDisplacementRX() const;
    void setRotationalDisplacementRX(double v);
    /// Whether the optional attribute RotationalDisplacementRY is defined for this IfcStructuralLoadSingleDisplacement
    bool hasRotationalDisplacementRY() const;
    /// Rotation about the y-axis.
    double RotationalDisplacementRY() const;
    void setRotationalDisplacementRY(double v);
    /// Whether the optional attribute RotationalDisplacementRZ is defined for this IfcStructuralLoadSingleDisplacement
    bool hasRotationalDisplacementRZ() const;
    /// Rotation about the z-axis.
    double RotationalDisplacementRZ() const;
    void setRotationalDisplacementRZ(double v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcStructuralLoadSingleDisplacement (IfcEntityInstanceData* e);
    IfcStructuralLoadSingleDisplacement (boost::optional< std::string > v1_Name, boost::optional< double > v2_DisplacementX, boost::optional< double > v3_DisplacementY, boost::optional< double > v4_DisplacementZ, boost::optional< double > v5_RotationalDisplacementRX, boost::optional< double > v6_RotationalDisplacementRY, boost::optional< double > v7_RotationalDisplacementRZ);
    typedef IfcTemplatedEntityList< IfcStructuralLoadSingleDisplacement > list;
};
/// Definition from IAI: Defines a displacement with warping.
/// 
/// HISTORY: New entity in IFC 2x2.
class IFC_PARSE_API IfcStructuralLoadSingleDisplacementDistortion : public IfcStructuralLoadSingleDisplacement {
public:
    /// Whether the optional attribute Distortion is defined for this IfcStructuralLoadSingleDisplacementDistortion
    bool hasDistortion() const;
    /// The distortion curvature (warping, i.e. a cross-sectional deplanation) given to the displacement load.
    double Distortion() const;
    void setDistortion(double v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcStructuralLoadSingleDisplacementDistortion (IfcEntityInstanceData* e);
    IfcStructuralLoadSingleDisplacementDistortion (boost::optional< std::string > v1_Name, boost::optional< double > v2_DisplacementX, boost::optional< double > v3_DisplacementY, boost::optional< double > v4_DisplacementZ, boost::optional< double > v5_RotationalDisplacementRX, boost::optional< double > v6_RotationalDisplacementRY, boost::optional< double > v7_RotationalDisplacementRZ, boost::optional< double > v8_Distortion);
    typedef IfcTemplatedEntityList< IfcStructuralLoadSingleDisplacementDistortion > list;
};
/// Definition from IAI: Instances of the entity
///   IfcStructuralLoadSingleForce shall be used to define the forces and
///   moments of an action operating on a single point. 
/// 
/// HISTORY: New entity in Release IFC2x
///   edition 2.
class IFC_PARSE_API IfcStructuralLoadSingleForce : public IfcStructuralLoadStatic {
public:
    /// Whether the optional attribute ForceX is defined for this IfcStructuralLoadSingleForce
    bool hasForceX() const;
    /// Force value in x-direction.
    double ForceX() const;
    void setForceX(double v);
    /// Whether the optional attribute ForceY is defined for this IfcStructuralLoadSingleForce
    bool hasForceY() const;
    /// Force value in y-direction.
    double ForceY() const;
    void setForceY(double v);
    /// Whether the optional attribute ForceZ is defined for this IfcStructuralLoadSingleForce
    bool hasForceZ() const;
    /// Force value in z-direction.
    double ForceZ() const;
    void setForceZ(double v);
    /// Whether the optional attribute MomentX is defined for this IfcStructuralLoadSingleForce
    bool hasMomentX() const;
    /// Moment about the x-axis.
    double MomentX() const;
    void setMomentX(double v);
    /// Whether the optional attribute MomentY is defined for this IfcStructuralLoadSingleForce
    bool hasMomentY() const;
    /// Moment about the y-axis.
    double MomentY() const;
    void setMomentY(double v);
    /// Whether the optional attribute MomentZ is defined for this IfcStructuralLoadSingleForce
    bool hasMomentZ() const;
    /// Moment about the z-axis.
    double MomentZ() const;
    void setMomentZ(double v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcStructuralLoadSingleForce (IfcEntityInstanceData* e);
    IfcStructuralLoadSingleForce (boost::optional< std::string > v1_Name, boost::optional< double > v2_ForceX, boost::optional< double > v3_ForceY, boost::optional< double > v4_ForceZ, boost::optional< double > v5_MomentX, boost::optional< double > v6_MomentY, boost::optional< double > v7_MomentZ);
    typedef IfcTemplatedEntityList< IfcStructuralLoadSingleForce > list;
};
/// Definition from IAI: Instances of the entity
///   IfcStructuralLoadSingleForceWarping, as a subtype of
///   IfcStructuralLoadSingleForce, shall be used to define an action operation
///   on a single point. In addition to forces and moments defined by its supertype a
///   warping moment can be defined.  
/// 
/// HISTORY: New entity in Release IFC2x
///   edition 2.
class IFC_PARSE_API IfcStructuralLoadSingleForceWarping : public IfcStructuralLoadSingleForce {
public:
    /// Whether the optional attribute WarpingMoment is defined for this IfcStructuralLoadSingleForceWarping
    bool hasWarpingMoment() const;
    /// The warping moment at the point load.
    double WarpingMoment() const;
    void setWarpingMoment(double v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcStructuralLoadSingleForceWarping (IfcEntityInstanceData* e);
    IfcStructuralLoadSingleForceWarping (boost::optional< std::string > v1_Name, boost::optional< double > v2_ForceX, boost::optional< double > v3_ForceY, boost::optional< double > v4_ForceZ, boost::optional< double > v5_MomentX, boost::optional< double > v6_MomentY, boost::optional< double > v7_MomentZ, boost::optional< double > v8_WarpingMoment);
    typedef IfcTemplatedEntityList< IfcStructuralLoadSingleForceWarping > list;
};

class IFC_PARSE_API IfcStructuralProfileProperties : public IfcGeneralProfileProperties {
public:
    /// Whether the optional attribute TorsionalConstantX is defined for this IfcStructuralProfileProperties
    bool hasTorsionalConstantX() const;
    double TorsionalConstantX() const;
    void setTorsionalConstantX(double v);
    /// Whether the optional attribute MomentOfInertiaYZ is defined for this IfcStructuralProfileProperties
    bool hasMomentOfInertiaYZ() const;
    double MomentOfInertiaYZ() const;
    void setMomentOfInertiaYZ(double v);
    /// Whether the optional attribute MomentOfInertiaY is defined for this IfcStructuralProfileProperties
    bool hasMomentOfInertiaY() const;
    double MomentOfInertiaY() const;
    void setMomentOfInertiaY(double v);
    /// Whether the optional attribute MomentOfInertiaZ is defined for this IfcStructuralProfileProperties
    bool hasMomentOfInertiaZ() const;
    double MomentOfInertiaZ() const;
    void setMomentOfInertiaZ(double v);
    /// Whether the optional attribute WarpingConstant is defined for this IfcStructuralProfileProperties
    bool hasWarpingConstant() const;
    double WarpingConstant() const;
    void setWarpingConstant(double v);
    /// Whether the optional attribute ShearCentreZ is defined for this IfcStructuralProfileProperties
    bool hasShearCentreZ() const;
    double ShearCentreZ() const;
    void setShearCentreZ(double v);
    /// Whether the optional attribute ShearCentreY is defined for this IfcStructuralProfileProperties
    bool hasShearCentreY() const;
    double ShearCentreY() const;
    void setShearCentreY(double v);
    /// Whether the optional attribute ShearDeformationAreaZ is defined for this IfcStructuralProfileProperties
    bool hasShearDeformationAreaZ() const;
    double ShearDeformationAreaZ() const;
    void setShearDeformationAreaZ(double v);
    /// Whether the optional attribute ShearDeformationAreaY is defined for this IfcStructuralProfileProperties
    bool hasShearDeformationAreaY() const;
    double ShearDeformationAreaY() const;
    void setShearDeformationAreaY(double v);
    /// Whether the optional attribute MaximumSectionModulusY is defined for this IfcStructuralProfileProperties
    bool hasMaximumSectionModulusY() const;
    double MaximumSectionModulusY() const;
    void setMaximumSectionModulusY(double v);
    /// Whether the optional attribute MinimumSectionModulusY is defined for this IfcStructuralProfileProperties
    bool hasMinimumSectionModulusY() const;
    double MinimumSectionModulusY() const;
    void setMinimumSectionModulusY(double v);
    /// Whether the optional attribute MaximumSectionModulusZ is defined for this IfcStructuralProfileProperties
    bool hasMaximumSectionModulusZ() const;
    double MaximumSectionModulusZ() const;
    void setMaximumSectionModulusZ(double v);
    /// Whether the optional attribute MinimumSectionModulusZ is defined for this IfcStructuralProfileProperties
    bool hasMinimumSectionModulusZ() const;
    double MinimumSectionModulusZ() const;
    void setMinimumSectionModulusZ(double v);
    /// Whether the optional attribute TorsionalSectionModulus is defined for this IfcStructuralProfileProperties
    bool hasTorsionalSectionModulus() const;
    double TorsionalSectionModulus() const;
    void setTorsionalSectionModulus(double v);
    /// Whether the optional attribute CentreOfGravityInX is defined for this IfcStructuralProfileProperties
    bool hasCentreOfGravityInX() const;
    double CentreOfGravityInX() const;
    void setCentreOfGravityInX(double v);
    /// Whether the optional attribute CentreOfGravityInY is defined for this IfcStructuralProfileProperties
    bool hasCentreOfGravityInY() const;
    double CentreOfGravityInY() const;
    void setCentreOfGravityInY(double v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcStructuralProfileProperties (IfcEntityInstanceData* e);
    IfcStructuralProfileProperties (boost::optional< std::string > v1_ProfileName, ::Ifc2x3::IfcProfileDef* v2_ProfileDefinition, boost::optional< double > v3_PhysicalWeight, boost::optional< double > v4_Perimeter, boost::optional< double > v5_MinimumPlateThickness, boost::optional< double > v6_MaximumPlateThickness, boost::optional< double > v7_CrossSectionArea, boost::optional< double > v8_TorsionalConstantX, boost::optional< double > v9_MomentOfInertiaYZ, boost::optional< double > v10_MomentOfInertiaY, boost::optional< double > v11_MomentOfInertiaZ, boost::optional< double > v12_WarpingConstant, boost::optional< double > v13_ShearCentreZ, boost::optional< double > v14_ShearCentreY, boost::optional< double > v15_ShearDeformationAreaZ, boost::optional< double > v16_ShearDeformationAreaY, boost::optional< double > v17_MaximumSectionModulusY, boost::optional< double > v18_MinimumSectionModulusY, boost::optional< double > v19_MaximumSectionModulusZ, boost::optional< double > v20_MinimumSectionModulusZ, boost::optional< double > v21_TorsionalSectionModulus, boost::optional< double > v22_CentreOfGravityInX, boost::optional< double > v23_CentreOfGravityInY);
    typedef IfcTemplatedEntityList< IfcStructuralProfileProperties > list;
};

class IFC_PARSE_API IfcStructuralSteelProfileProperties : public IfcStructuralProfileProperties {
public:
    /// Whether the optional attribute ShearAreaZ is defined for this IfcStructuralSteelProfileProperties
    bool hasShearAreaZ() const;
    double ShearAreaZ() const;
    void setShearAreaZ(double v);
    /// Whether the optional attribute ShearAreaY is defined for this IfcStructuralSteelProfileProperties
    bool hasShearAreaY() const;
    double ShearAreaY() const;
    void setShearAreaY(double v);
    /// Whether the optional attribute PlasticShapeFactorY is defined for this IfcStructuralSteelProfileProperties
    bool hasPlasticShapeFactorY() const;
    double PlasticShapeFactorY() const;
    void setPlasticShapeFactorY(double v);
    /// Whether the optional attribute PlasticShapeFactorZ is defined for this IfcStructuralSteelProfileProperties
    bool hasPlasticShapeFactorZ() const;
    double PlasticShapeFactorZ() const;
    void setPlasticShapeFactorZ(double v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcStructuralSteelProfileProperties (IfcEntityInstanceData* e);
    IfcStructuralSteelProfileProperties (boost::optional< std::string > v1_ProfileName, ::Ifc2x3::IfcProfileDef* v2_ProfileDefinition, boost::optional< double > v3_PhysicalWeight, boost::optional< double > v4_Perimeter, boost::optional< double > v5_MinimumPlateThickness, boost::optional< double > v6_MaximumPlateThickness, boost::optional< double > v7_CrossSectionArea, boost::optional< double > v8_TorsionalConstantX, boost::optional< double > v9_MomentOfInertiaYZ, boost::optional< double > v10_MomentOfInertiaY, boost::optional< double > v11_MomentOfInertiaZ, boost::optional< double > v12_WarpingConstant, boost::optional< double > v13_ShearCentreZ, boost::optional< double > v14_ShearCentreY, boost::optional< double > v15_ShearDeformationAreaZ, boost::optional< double > v16_ShearDeformationAreaY, boost::optional< double > v17_MaximumSectionModulusY, boost::optional< double > v18_MinimumSectionModulusY, boost::optional< double > v19_MaximumSectionModulusZ, boost::optional< double > v20_MinimumSectionModulusZ, boost::optional< double > v21_TorsionalSectionModulus, boost::optional< double > v22_CentreOfGravityInX, boost::optional< double > v23_CentreOfGravityInY, boost::optional< double > v24_ShearAreaZ, boost::optional< double > v25_ShearAreaY, boost::optional< double > v26_PlasticShapeFactorY, boost::optional< double > v27_PlasticShapeFactorZ);
    typedef IfcTemplatedEntityList< IfcStructuralSteelProfileProperties > list;
};
/// Definition from ISO/DIS 10303-42:1999(E): A subedge is an edge whose domain is a connected portion of the domain of an existing edge. The topological constraints on a subedge are the same as those on an edge. 
/// 
/// Informal propositions: 
/// 
/// The domain of the subedge is formally defined to be the domain of the parent edge, as trimmed by the subedge start vertex and subedge end vertex. 
/// The start vertex and end vertex shall be within the union of the domains of the vertices of the parent edge and the domain of the parent edge. 
/// 
/// NOTE  Corresponding ISO 10303 entity: subedge. Please refer to ISO/DIS 10303-42:1999(E), p. 194 for the final definition of the formal standard.
/// 
/// HISTORY  New entity in IFC2x2.
class IFC_PARSE_API IfcSubedge : public IfcEdge {
public:
    /// The Edge, or Subedge, which contains the Subedge.
    ::Ifc2x3::IfcEdge* ParentEdge() const;
    void setParentEdge(::Ifc2x3::IfcEdge* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcSubedge (IfcEntityInstanceData* e);
    IfcSubedge (::Ifc2x3::IfcVertex* v1_EdgeStart, ::Ifc2x3::IfcVertex* v2_EdgeEnd, ::Ifc2x3::IfcEdge* v3_ParentEdge);
    typedef IfcTemplatedEntityList< IfcSubedge > list;
};
/// Definition from ISO/CD 10303-42:1992: A surface can be envisioned as a set of connected points in 3-dimensional space which is always locally 2-dimensional, but need not be a manifold.  
/// 
/// NOTE Corresponding ISO 10303 entity: surface, the following subtypes have been incorporated into IFC - elementary_surface (as IfcElementarySurface), swept_surface (as IfcSweptSurface) and bounded_surface (as IfcBoundedSurface). Please refer to ISO/IS 10303-42:1994, p. 68 for the final definition of the formal standard. 
/// 
/// HISTORY New class in IFC Release 1.5
/// 
/// Informal proposition: 
/// 
/// A surface has non zero area. 
/// A surface is arcwise connected.
class IFC_PARSE_API IfcSurface : public IfcGeometricRepresentationItem {
public:
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcSurface (IfcEntityInstanceData* e);
    IfcSurface ();
    typedef IfcTemplatedEntityList< IfcSurface > list;
};
/// IfcSurfaceStyleRendering holds the properties for visualization related to a particular surface side style.  
/// 
/// It allows rendering properties to be defined by: 
/// 
/// a transparency component (Transparency attribute) 
///   a colour component (SurfaceColour attribute inherited from IfcSurfaceStyleShading) 
///   a reflectance component, given either by 
/// 
/// applying reflectance factors to the surface colour: 
/// 
/// diffuse component (SurfaceColour * DiffuseFactor)				  
///   transmission component (SurfaceColour * TransmissionFactor) 
///   diffuse transmission component (SurfaceColour * DiffuseTransmissionFactor) 
///   reflection component (SurfaceColour * ReflectionFactor) 
///   specular component (SurfaceColour * SpecularFactor attribute together with SpecularHighlight) 
/// 
/// explicitly defining such factors as colours (DiffuseColour, TransmissionColour, DiffuseTransmissionColour, ReflectionColour and SpecularColour) 
/// 
/// a displacement component, currently only given by a texture map with the TextureType = bump 
///   a coverage component, currently only given by the alpha component of the texture map (2 or 4 component colour texture) 
/// 
/// NOTE: The inherited attribute SurfaceColour is treated as the ambient colour and specifies how much ambient light from light sources this surface shall reflect. Ambient light is omnidirectional and depends only on the number of light sources, not their positions with respect to the surface.
/// 
/// NOTE: If the reflectance method, as given by the IfcReflectanceMethodEnum is "GLASS", the transmission factor controls the level of transparency in the glass, In this case the transparency factor is interpreted as transmission factor.
/// 
/// NOTE: Both Transparency and TransmissionColour (or factor) are included, the following definitions apply:
/// 
/// Transparency is the ratio of the transmitted flux in a solid angle of 2 * PI sr (one hemisphere). It is a simple colour filtration that does not account for refraction. 
///   Transmission factor of a material is the ratio of transmitted flux in a given solid angle to the transmitted flux of a completely diffuse material with 100% transmission in the same solid angle. It is the portion of light that goes through the material and may be refracted. 
/// 
/// NOTE: IFC 2x2 adds additional capability for presentation of physically accurate illuminance on surfaces. VRML type rendering and rendering based on ISO 10303-46 continues to be supported by a subset of the information. For reflectance equations and further information about the surface style properties and its processing, see:
/// 
/// ISO/IEC 14772-1: 1997: The Virtual Reality Modeling Language 
/// 
/// NOTE: The definition of IfcSurfaceStyleRenderingProperties includes the definitions as found in ISO 10303-46:1994, in particular of:
/// 
/// surface_style_rendering_with_properties
///   surface_style_rendering_ambient
///   surface_style_rendering_ambient_diffuse
///   surface_style_rendering_ambient_diffuse_specular
///   surface_style_transparent
/// 
/// In addition to the attributes as defined in ISO 10303-46, (ambient_reflectance, diffuse_reflectance, specular_reflectance, specular_exponent, and specular_colour), the current IFC definition adds other colours, reflectance factors and specular roughness.
/// 
/// HISTORY: New Entity in IFC 2x.
class IFC_PARSE_API IfcSurfaceStyleRendering : public IfcSurfaceStyleShading {
public:
    /// Whether the optional attribute Transparency is defined for this IfcSurfaceStyleRendering
    bool hasTransparency() const;
    /// Definition from ISO/CD 10303-46: The degree of transparency is indicated by the percentage of light traversing the surface.
    /// Definition from VRML97 - ISO/IEC 14772-1:1997: The transparency field specifies how "clear" an object is, with 1.0 being completely transparent, and 0.0 completely opaque. If not given, the value 0.0 (opaque) is assumed.
    double Transparency() const;
    void setTransparency(double v);
    /// Whether the optional attribute DiffuseColour is defined for this IfcSurfaceStyleRendering
    bool hasDiffuseColour() const;
    /// The diffuse part of the reflectance equation can be given as either a colour or a scalar factor.
    /// The diffuse colour field reflects all light sources depending on the angle of the surface with respect to the light source. The more directly the surface faces the light, the more diffuse light reflects.
    /// The diffuse factor field specifies how much diffuse light from light sources this surface shall reflect. Diffuse light depends on the angle of the surface with respect to the light source. The more directly the surface faces the light, the more diffuse light reflects. The diffuse colour is then defined by surface colour * diffuse factor.
    ::Ifc2x3::IfcColourOrFactor* DiffuseColour() const;
    void setDiffuseColour(::Ifc2x3::IfcColourOrFactor* v);
    /// Whether the optional attribute TransmissionColour is defined for this IfcSurfaceStyleRendering
    bool hasTransmissionColour() const;
    /// The transmissive part of the reflectance equation can be given as either a colour or a scalar factor. It only applies to materials which Transparency field is greater than zero.
    /// The transmissive colour field specifies the colour that passes through a transparant material (like the colour that shines through a glass).
    /// The transmissive factor defines the transmissive part, the transmissive colour is then defined by surface colour * transmissive factor.
    ::Ifc2x3::IfcColourOrFactor* TransmissionColour() const;
    void setTransmissionColour(::Ifc2x3::IfcColourOrFactor* v);
    /// Whether the optional attribute DiffuseTransmissionColour is defined for this IfcSurfaceStyleRendering
    bool hasDiffuseTransmissionColour() const;
    /// The diffuse transmission part of the reflectance equation can be given as either a colour or a scalar factor. It only applies to materials whose Transparency field is greater than zero.
    /// The diffuse transmission colour specifies how much diffuse light is reflected at the opposite side of the material surface.
    /// The diffuse transmission factor field specifies how much diffuse light from light sources this surface shall reflect on the opposite side of the material surface. The diffuse transmissive colour is then defined by surface colour * diffuse transmissive factor.
    ::Ifc2x3::IfcColourOrFactor* DiffuseTransmissionColour() const;
    void setDiffuseTransmissionColour(::Ifc2x3::IfcColourOrFactor* v);
    /// Whether the optional attribute ReflectionColour is defined for this IfcSurfaceStyleRendering
    bool hasReflectionColour() const;
    /// The reflection (or mirror) part of the reflectance equation can be given as either a colour or a scalar factor. Applies to "glass" and "mirror" reflection models.
    /// The reflection colour specifies the contribution made by light from the mirror direction, i.e. light being reflected from the surface.
    /// The reflection factor specifies the amount of contribution made by light from the mirror direction. The reflection colour is then defined by surface colour * reflection factor.
    ::Ifc2x3::IfcColourOrFactor* ReflectionColour() const;
    void setReflectionColour(::Ifc2x3::IfcColourOrFactor* v);
    /// Whether the optional attribute SpecularColour is defined for this IfcSurfaceStyleRendering
    bool hasSpecularColour() const;
    /// The specular part of the reflectance equation can be given as either a colour or a scalar factor.
    /// The specular colour determine the specular highlights (e.g., the shiny spots on an apple). When the angle from the light to the surface is close to the angle from the surface to the viewer, the specular colour is added to the diffuse and ambient colour calculations.
    /// The specular factor defines the specular part, the specular colour is then defined by surface colour * specular factor.
    ::Ifc2x3::IfcColourOrFactor* SpecularColour() const;
    void setSpecularColour(::Ifc2x3::IfcColourOrFactor* v);
    /// Whether the optional attribute SpecularHighlight is defined for this IfcSurfaceStyleRendering
    bool hasSpecularHighlight() const;
    /// The exponent or roughness part of the specular reflectance.
    ::Ifc2x3::IfcSpecularHighlightSelect* SpecularHighlight() const;
    void setSpecularHighlight(::Ifc2x3::IfcSpecularHighlightSelect* v);
    /// Identifies the predefined types of reflectance method from which the method required may be set.
    ::Ifc2x3::IfcReflectanceMethodEnum::Value ReflectanceMethod() const;
    void setReflectanceMethod(::Ifc2x3::IfcReflectanceMethodEnum::Value v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcSurfaceStyleRendering (IfcEntityInstanceData* e);
    IfcSurfaceStyleRendering (::Ifc2x3::IfcColourRgb* v1_SurfaceColour, boost::optional< double > v2_Transparency, ::Ifc2x3::IfcColourOrFactor* v3_DiffuseColour, ::Ifc2x3::IfcColourOrFactor* v4_TransmissionColour, ::Ifc2x3::IfcColourOrFactor* v5_DiffuseTransmissionColour, ::Ifc2x3::IfcColourOrFactor* v6_ReflectionColour, ::Ifc2x3::IfcColourOrFactor* v7_SpecularColour, ::Ifc2x3::IfcSpecularHighlightSelect* v8_SpecularHighlight, ::Ifc2x3::IfcReflectanceMethodEnum::Value v9_ReflectanceMethod);
    typedef IfcTemplatedEntityList< IfcSurfaceStyleRendering > list;
};
/// Definition from ISO/CD 10303-42:1992: The swept area
///   solid entity collects the entities which are defined
///   procedurally by sweeping action on planar bounded surfaces.
///   The position is space of the swept solid will be dependent
///   upon the position of the swept area. The swept area will be
///   a face of the resulting swept area solid, except for the
///   case of a revolved area solid with angle equal to 2π
///   (or 360 degrees).
/// 
/// The swept area is defined by a
///   cross section (also referred to as profile), which is given
///   as a closed two-dimensional boundary on an implicit plane.
///   The swept area is defined in the xy plane of the position
///   coordinate system, which is given for the swept area solid.
/// 
/// NOTE Corresponding ISO 10303-42 entity: swept_area_solid, The data type of SweptArea is modified and given by a profile definition (IfcProfileDef). A position coordinate system is defined by the Position attribute has been added. Please refer to ISO/IS 10303-42:1994, p. 183 for the final definition of the formal standard.
/// 
/// HISTORY New entity in IFC Release 1.5, the capabilities have been enhanced in IFC Release 2x.
class IFC_PARSE_API IfcSweptAreaSolid : public IfcSolidModel {
public:
    /// The surface defining the area to be swept. It is given as a profile definition within the xy plane of the position coordinate system.
    ::Ifc2x3::IfcProfileDef* SweptArea() const;
    void setSweptArea(::Ifc2x3::IfcProfileDef* v);
    /// Position coordinate system for the swept area, provided by a profile definition within the XY plane of the Position.
    ::Ifc2x3::IfcAxis2Placement3D* Position() const;
    void setPosition(::Ifc2x3::IfcAxis2Placement3D* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcSweptAreaSolid (IfcEntityInstanceData* e);
    IfcSweptAreaSolid (::Ifc2x3::IfcProfileDef* v1_SweptArea, ::Ifc2x3::IfcAxis2Placement3D* v2_Position);
    typedef IfcTemplatedEntityList< IfcSweptAreaSolid > list;
};
/// Definition from ISO 10303-42:2002: A swept
/// disk solid is the solid produced by sweeping a circular disk
/// along a three dimensional curve. During the sweeping operation
/// the normal to the plane of the circular disk is in the direction
/// of the tangent to the directrix curve and the center of the disk
/// lies on the directrix. The circular disk may, optionally, have a
/// central hole, in this case the resulting solid has a through
/// hole, or, an internal void when the directrix forms a close
/// curve.
/// The StartParam and
/// EndParam parameter are optional, if not provided they
/// default to the start and end of the Directrix. Only if the
/// Directrix is given by a bounded or by a closed curve, it
/// is permissible to omit the values of StartParam and
/// EndParam.
/// If the transitions between consecutive segments of the
/// Directrix are not tangent continuous, the resulting solid
/// is created by a miter at half angle between the two segments.
/// Informal proposition restricts the permissible angle between two
/// non-tangent continuous segments.
/// 
/// Figure 272 illustrates an example.
/// 
/// Directrix given as IfcCompositeCurve being
/// tangent continuous between its segments
/// Directrix being a bounded and open curve
/// No StartParam and EndParam are provided, start
/// and end default to start and end of the bounded curve of the
/// Directrix
/// 
/// NOTE  Although the example shows a Directrix as a composite curve on a planar reference surface, the definition of IfcSweptDiskSolid is not restricted to be based on planer curves. However view definitions or implementer agreements may provide restrictions.
/// 
/// Figure 272 — Swept disk solid geometry
/// 
/// NOTE  Corresponding ISO 10303-42 entity: swept_disk_solid. Please refer to ISO/FDIS 10303-42:2002, p. 282 for the definition of the formal standard.
/// 
/// HISTORY  New entity in IFC Release 2x2.
/// 
/// IFC2x4 CHANGE  The attribute StartParam and EndParam have been made optional.
/// 
/// Informal proposition
/// 
/// If the Directrix curve definition is not tangent
/// continuous, the transition between the segments has to be within
/// an acceptable limit of tangent discontinuity. Very sharp edges
/// may result in nearly impossible miter. Implementer agreements may
/// define acceptable limits for tangent discontinuity.
/// The segments of the Directrix shall be long enough to
/// apply the Radius. In case of an arc segment forming part
/// of the Directrix ,its radius shall be greater then the
/// disk Radius
/// The Directrix shall not be based on an intersecting
/// curve.
class IFC_PARSE_API IfcSweptDiskSolid : public IfcSolidModel {
public:
    /// The curve used to define the sweeping operation. The solid is generated by sweeping a circular disk along the Directrix.
    ::Ifc2x3::IfcCurve* Directrix() const;
    void setDirectrix(::Ifc2x3::IfcCurve* v);
    /// The Radius of the circular disk to be swept along the directrix. Denotes the outer radius, if an InnerRadius is applied.
    double Radius() const;
    void setRadius(double v);
    /// Whether the optional attribute InnerRadius is defined for this IfcSweptDiskSolid
    bool hasInnerRadius() const;
    /// This attribute is optional, if present it defines the radius of a circular hole in the centre of the disk.
    double InnerRadius() const;
    void setInnerRadius(double v);
    /// The parameter value on the Directrix at which the sweeping operation commences. If no value is provided the start of the sweeping operation is at the start of the Directrix..
    /// 
    /// IFC2x4 CHANGE  The attribute has been changed to OPTIONAL with upward compatibility for file-based exchange.
    double StartParam() const;
    void setStartParam(double v);
    /// The parameter value on the Directrix at which the sweeping operation ends. If no value is provided the end of the sweeping operation is at the end of the Directrix..
    /// 
    /// IFC2x4 CHANGE  The attribute has been changed to OPTIONAL with upward compatibility for file-based exchange.
    double EndParam() const;
    void setEndParam(double v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcSweptDiskSolid (IfcEntityInstanceData* e);
    IfcSweptDiskSolid (::Ifc2x3::IfcCurve* v1_Directrix, double v2_Radius, boost::optional< double > v3_InnerRadius, double v4_StartParam, double v5_EndParam);
    typedef IfcTemplatedEntityList< IfcSweptDiskSolid > list;
};
/// Definition from ISO/CD 10303-42:1992: A swept surface is one that is constructed by sweeping a curve along another curve.  
/// 
/// NOTE: Corresponding ISO 10303 entity: swept_surface. Please refer to ISO/IS 10303-42:1994, p.76 for the final definition of the formal standard.
/// 
/// HISTORY: New entity in IFC Release 2x.
class IFC_PARSE_API IfcSweptSurface : public IfcSurface {
public:
    /// The curve to be swept in defining the surface. The curve is defined as a profile within the position coordinate system.
    ::Ifc2x3::IfcProfileDef* SweptCurve() const;
    void setSweptCurve(::Ifc2x3::IfcProfileDef* v);
    /// Position coordinate system for the placement of the profile within the xy plane of the axis placement.
    ::Ifc2x3::IfcAxis2Placement3D* Position() const;
    void setPosition(::Ifc2x3::IfcAxis2Placement3D* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcSweptSurface (IfcEntityInstanceData* e);
    IfcSweptSurface (::Ifc2x3::IfcProfileDef* v1_SweptCurve, ::Ifc2x3::IfcAxis2Placement3D* v2_Position);
    typedef IfcTemplatedEntityList< IfcSweptSurface > list;
};
/// IfcTShapeProfileDef defines
/// a section profile that provides the defining parameters of a T-shaped
/// section to be used by the swept area solid. Its parameters and
/// orientation relative to the position coordinate system are according to
/// the following illustration. The centre of the position coordinate
/// system is in the profile's centre of the bounding box.
/// 
/// HISTORY  New entity in IFC2x2.
/// 
/// IFC2x3 CHANGE  All profile origins are now in the center of the bounding box.
/// 
/// IFC2x4 CHANGE  Type of FilletRadius, FlangeEdgeRadius, and WebEdgeRadius relaxed to allow for zero radius. Trailing attribute CentreOfGravityInY deleted, use respective property in IfcExtendedProfileProperties instead.
/// 
/// Figure 326 illustrates parameters of the T-shape profile definition.
/// 
/// Position 
/// The parameterized profile defines its own position coordinate system.
/// The underlying
/// coordinate system is defined by the swept area solid
/// that uses the profile definition. It is the xy plane of:
/// 
/// IfcSweptAreaSolid.Position
/// 
/// by using offsets of the position location, the parameterized profile
/// can be positioned centric (using x,y offsets = 0.), or at any position
/// relative to the profile.
/// 
/// Figure 326 — T-shape profile
class IFC_PARSE_API IfcTShapeProfileDef : public IfcParameterizedProfileDef {
public:
    /// Web lengths, see illustration above (= h).
    double Depth() const;
    void setDepth(double v);
    /// Flange lengths, see illustration above (= b).
    double FlangeWidth() const;
    void setFlangeWidth(double v);
    /// Constant wall thickness of web (= ts).
    double WebThickness() const;
    void setWebThickness(double v);
    /// Constant wall thickness of flange (= tg).
    double FlangeThickness() const;
    void setFlangeThickness(double v);
    /// Whether the optional attribute FilletRadius is defined for this IfcTShapeProfileDef
    bool hasFilletRadius() const;
    /// Fillet radius according the above illustration (= r1).
    double FilletRadius() const;
    void setFilletRadius(double v);
    /// Whether the optional attribute FlangeEdgeRadius is defined for this IfcTShapeProfileDef
    bool hasFlangeEdgeRadius() const;
    /// Edge radius according the above illustration (= r2).
    double FlangeEdgeRadius() const;
    void setFlangeEdgeRadius(double v);
    /// Whether the optional attribute WebEdgeRadius is defined for this IfcTShapeProfileDef
    bool hasWebEdgeRadius() const;
    /// Edge radius according the above illustration (= r3).
    double WebEdgeRadius() const;
    void setWebEdgeRadius(double v);
    /// Whether the optional attribute WebSlope is defined for this IfcTShapeProfileDef
    bool hasWebSlope() const;
    /// Slope of flange of the profile.
    double WebSlope() const;
    void setWebSlope(double v);
    /// Whether the optional attribute FlangeSlope is defined for this IfcTShapeProfileDef
    bool hasFlangeSlope() const;
    /// Slope of web of the profile.
    double FlangeSlope() const;
    void setFlangeSlope(double v);
    /// Whether the optional attribute CentreOfGravityInY is defined for this IfcTShapeProfileDef
    bool hasCentreOfGravityInY() const;
    double CentreOfGravityInY() const;
    void setCentreOfGravityInY(double v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcTShapeProfileDef (IfcEntityInstanceData* e);
    IfcTShapeProfileDef (::Ifc2x3::IfcProfileTypeEnum::Value v1_ProfileType, boost::optional< std::string > v2_ProfileName, ::Ifc2x3::IfcAxis2Placement2D* v3_Position, double v4_Depth, double v5_FlangeWidth, double v6_WebThickness, double v7_FlangeThickness, boost::optional< double > v8_FilletRadius, boost::optional< double > v9_FlangeEdgeRadius, boost::optional< double > v10_WebEdgeRadius, boost::optional< double > v11_WebSlope, boost::optional< double > v12_FlangeSlope, boost::optional< double > v13_CentreOfGravityInY);
    typedef IfcTemplatedEntityList< IfcTShapeProfileDef > list;
};

class IFC_PARSE_API IfcTerminatorSymbol : public IfcAnnotationSymbolOccurrence {
public:
    ::Ifc2x3::IfcAnnotationCurveOccurrence* AnnotatedCurve() const;
    void setAnnotatedCurve(::Ifc2x3::IfcAnnotationCurveOccurrence* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcTerminatorSymbol (IfcEntityInstanceData* e);
    IfcTerminatorSymbol (::Ifc2x3::IfcRepresentationItem* v1_Item, IfcTemplatedEntityList< ::Ifc2x3::IfcPresentationStyleAssignment >::ptr v2_Styles, boost::optional< std::string > v3_Name, ::Ifc2x3::IfcAnnotationCurveOccurrence* v4_AnnotatedCurve);
    typedef IfcTemplatedEntityList< IfcTerminatorSymbol > list;
};
/// The text literal is a geometric representation item which describes a text string using a string literal and additional position and path information.
/// 
/// NOTE  The IfcTextLiteral is an entity that had been adopted from ISO 10303, Industrial automation systems and integration—Product data representation and exchange.
/// 
/// NOTE  Corresponding ISO 10303 name: text_literal. Please refer to ISO/IS 10303-46:1994 for the
/// final definition of the formal standard. The attributes font and alignment have been removed as those should be handled by the text style.
/// 
/// HISTORY  New entity in IFC2x2.
/// 
/// IFC2x3 CHANGE  The IfcTextLiteral has been changed by removing Font and Alignment.
class IFC_PARSE_API IfcTextLiteral : public IfcGeometricRepresentationItem {
public:
    /// The text literal to be presented.
    std::string Literal() const;
    void setLiteral(std::string v);
    /// An IfcAxis2Placement that determines the placement and orientation of the presented string.
    /// When used with a text style based on IfcTextStyleWithBoxCharacteristics then the y-axis is taken as the reference direction for the box rotation angle and the box slant angle.
    ::Ifc2x3::IfcAxis2Placement* Placement() const;
    void setPlacement(::Ifc2x3::IfcAxis2Placement* v);
    /// The writing direction of the text literal.
    ::Ifc2x3::IfcTextPath::Value Path() const;
    void setPath(::Ifc2x3::IfcTextPath::Value v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcTextLiteral (IfcEntityInstanceData* e);
    IfcTextLiteral (std::string v1_Literal, ::Ifc2x3::IfcAxis2Placement* v2_Placement, ::Ifc2x3::IfcTextPath::Value v3_Path);
    typedef IfcTemplatedEntityList< IfcTextLiteral > list;
};
/// The text literal with extent is a text literal with the additional explicit information of the planar extent (or surrounding text box). An alignment attribute defines, how the text box is aligned to the placement and how it may expand.
/// 
/// NOTE  The IfcTextLiteralWithExtent is an entity that had been adopted from ISO 10303, Industrial automation systems and integration—Product data representation and exchange, Part 46: Integrated generic resources: Visual presentation. 
/// 
/// NOTE  Corresponding ISO 10303 name: text_literal_with_extent. Please refer to ISO/IS 10303-46:1994 for the final definition of the formal standard.
/// 
/// HISTORY  New entity in IFC2x2.
/// 
/// IFC2x3 CHANGE  The IfcTextLiteralWithExtent has been changed by adding BoxAlignment.
class IFC_PARSE_API IfcTextLiteralWithExtent : public IfcTextLiteral {
public:
    /// The extent in the x and y direction of the text literal.
    ::Ifc2x3::IfcPlanarExtent* Extent() const;
    void setExtent(::Ifc2x3::IfcPlanarExtent* v);
    /// The alignment of the text literal relative to its position.
    std::string BoxAlignment() const;
    void setBoxAlignment(std::string v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcTextLiteralWithExtent (IfcEntityInstanceData* e);
    IfcTextLiteralWithExtent (std::string v1_Literal, ::Ifc2x3::IfcAxis2Placement* v2_Placement, ::Ifc2x3::IfcTextPath::Value v3_Path, ::Ifc2x3::IfcPlanarExtent* v4_Extent, std::string v5_BoxAlignment);
    typedef IfcTemplatedEntityList< IfcTextLiteralWithExtent > list;
};
/// IfcTrapeziumProfileDef defines a trapezium as the profile definition used by the swept surface geometry or the swept area solid. It is given by its Top X and Bottom X extent and its Y extent as well as by the offset of the Top X extend, and placed within the 2D position coordinate system, established by the Position attribute. It is placed centric within the position coordinate system, that is, in the center of the bounding box. 
/// 
/// HISTORY  New class in IFC 1.5. The use definition has changed in IFC2x.
/// 
/// Figure 325 illustrates parameters of the trapezium profile definition.
/// 
/// Position
/// 
/// The parameterized profile defines its own position coordinate system.
/// The underlying
/// coordinate system is defined by the swept surface or swept area solid
/// that uses the profile definition. It is the xy plane of either:
/// 
/// IfcSweptSurface.Position
///   IfcSweptAreaSolid.Position
/// 
/// or in case of sectioned spines the xy plane of each list member of IfcSectionedSpine.CrossSectionPositions.
/// 
/// By using offsets of the position location, the parameterized profile
/// can be positioned centric (using x,y offsets = 0.), or at any position
/// relative to the profile. Explicit coordinate offsets are used to define
/// cardinal points (e.g. upper-left bound).
///   Parameter
/// 
/// The IfcTrapeziumProfileDef
/// is defined within the position
/// coordinate system, where the BottomDim
/// defines the length
/// measure for the bottom line (half along the positive x-axis) and the YDim
/// defines the length measure for the parallel distance of bottom and top
/// line (half along the positive y-axis). The top line starts with a
/// distance of TopXOffset
/// from [-BottomLine/2,YDim] (which can be
/// negative, zero, or positive) and has a length of TopXDim
/// along
/// the positive x-axis.
/// 
/// Figure 325 — Trapezium profile
class IFC_PARSE_API IfcTrapeziumProfileDef : public IfcParameterizedProfileDef {
public:
    /// The extent of the bottom line measured along the implicit x-axis.
    double BottomXDim() const;
    void setBottomXDim(double v);
    /// The extent of the top line measured along the implicit x-axis.
    double TopXDim() const;
    void setTopXDim(double v);
    /// The extent of the distance between the parallel bottom and top lines measured along the implicit y-axis.
    double YDim() const;
    void setYDim(double v);
    /// Offset from the beginning of the top line to the bottom line, measured along the implicit x-axis.
    double TopXOffset() const;
    void setTopXOffset(double v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcTrapeziumProfileDef (IfcEntityInstanceData* e);
    IfcTrapeziumProfileDef (::Ifc2x3::IfcProfileTypeEnum::Value v1_ProfileType, boost::optional< std::string > v2_ProfileName, ::Ifc2x3::IfcAxis2Placement2D* v3_Position, double v4_BottomXDim, double v5_TopXDim, double v6_YDim, double v7_TopXOffset);
    typedef IfcTemplatedEntityList< IfcTrapeziumProfileDef > list;
};
/// Definition from ISO/CD 10303-46:1992: A two direction repeat factor combines two vectors which are used in the fill area style tiles entity for determining the shape and relative location of tiles. Given the initial position of any tile, the two direction repeat factor determines eight new positions according to the equation:
/// 
/// k1* R1 + k2* R2
///        k X{-1,1} 
/// 
/// NOTE Corresponding ISO 10303 name: two_direction_repeat_factor. Please refer to ISO/IS 10303-46:1994 for the final definition of the formal standard.
/// 
/// HISTORY New entity in IFC2x2.
class IFC_PARSE_API IfcTwoDirectionRepeatFactor : public IfcOneDirectionRepeatFactor {
public:
    /// A vector which specifies the relative positioning of tiles in the second direction.
    ::Ifc2x3::IfcVector* SecondRepeatFactor() const;
    void setSecondRepeatFactor(::Ifc2x3::IfcVector* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcTwoDirectionRepeatFactor (IfcEntityInstanceData* e);
    IfcTwoDirectionRepeatFactor (::Ifc2x3::IfcVector* v1_RepeatFactor, ::Ifc2x3::IfcVector* v2_SecondRepeatFactor);
    typedef IfcTemplatedEntityList< IfcTwoDirectionRepeatFactor > list;
};
/// The object type defines the
/// specific information about a type, being common to all
/// occurrences of this type. It refers to the specific level of the
/// well recognized generic - specific - occurrance modeling
/// paradigm. The IfcTypeObject gets assigned to the
/// individual object instances (the occurrences) via the
/// IfcRelDefinesByType relationship.
/// NOTE The terms 'Type' and 'Style' are often
/// used interchangeably.
/// The object type is represented by a set of property set
/// definitions. The attached property sets describe the available
/// alpha-numeric information about the object type. and are used to
/// define all common properties that apply to all object occurrences
/// of that type.
/// NOTE If a property having having the same name
/// is used within the IfcPropertySet assigned to an
/// IfcTypeObject (and subtypes) and to an occurrence of that
/// type, then the occurrence property overrides the type property.
/// See IfcRelDefinesByType for an explanatory
/// figure.
/// Object types may be exchanged without being already assigned
/// to objects. An object type may have an indication of the library
/// (or catalogue) from which its definition originates. This
/// association is handled by the inherited HasAssociations
/// relationship pointing to IfcRelAssociatesLibrary.
/// 
/// HISTORY New entity in IFC Release 2x
/// 
/// IFC2x3 CHANGE The IfcTypeObject is now subtyped from the new supertype IfcObjectDefinition, and the attribute HasPropertySets has been changed from a LIST into a SET.
/// 
/// IFC2x4 CHANGE (1) The entity IfcTypeObject shall not be instantiated from IFC2x4 onwards. It will be changed into an ABSTRACT supertype in future releases of IFC. (2) The inverse attribute Types has been renamed from ObjectTypeOf.
class IFC_PARSE_API IfcTypeObject : public IfcObjectDefinition {
public:
    /// Whether the optional attribute ApplicableOccurrence is defined for this IfcTypeObject
    bool hasApplicableOccurrence() const;
    /// The attribute optionally defines the data type of the occurrence object, to which the assigned type object can relate. If not present, no instruction is given to which occurrence object the type object is applicable. The following conventions are used:
    /// 
    /// The IFC entity name of the applicable occurrence using the IFC naming convention, CamelCase with IFC prefix
    ///   It can be optionally followed by the predefined type after the separator "/" (forward slash), using Uupper case
    ///   If one type object is applicable to many occurrence objects, then those occurrence object names should be separate by comma "," forming a comma separated string.
    /// 
    /// EXAMPLE  Refering to a furniture as applicable occurrence entity would be expressed as 'IfcFurnishingElement', refering to a brace as applicable entity would be expressed as 'IfcMember/BRACE', refering to a wall and wall standard case would be expressed as 'IfcWall, IfcWallStandardCase'.
    std::string ApplicableOccurrence() const;
    void setApplicableOccurrence(std::string v);
    /// Whether the optional attribute HasPropertySets is defined for this IfcTypeObject
    bool hasHasPropertySets() const;
    /// Set list of unique property sets, that are associated with the object type and are common to all object occurrences referring to this object type.
    /// 
    /// IFC2x3 CHANGE  The attribute aggregate type has been changed from LIST to SET.
    IfcTemplatedEntityList< ::Ifc2x3::IfcPropertySetDefinition >::ptr HasPropertySets() const;
    void setHasPropertySets(IfcTemplatedEntityList< ::Ifc2x3::IfcPropertySetDefinition >::ptr v);
        IfcTemplatedEntityList< IfcRelDefinesByType >::ptr ObjectTypeOf() const; // INVERSE IfcRelDefinesByType::RelatingType
    virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcTypeObject (IfcEntityInstanceData* e);
    IfcTypeObject (std::string v1_GlobalId, ::Ifc2x3::IfcOwnerHistory* v2_OwnerHistory, boost::optional< std::string > v3_Name, boost::optional< std::string > v4_Description, boost::optional< std::string > v5_ApplicableOccurrence, boost::optional< IfcTemplatedEntityList< ::Ifc2x3::IfcPropertySetDefinition >::ptr > v6_HasPropertySets);
    typedef IfcTemplatedEntityList< IfcTypeObject > list;
};
/// IfcTypeProduct defines a type
/// definition of a product without being already inserted into a
/// project structure (without having a placement), and not being
/// included into the geometric representation context of the
/// project.ÿIt is used to define a product specification, that is, the
/// specific product information that is common to all occurrences
/// of that product type.
/// 
/// An IfcTypeProduct may have a list of property set
/// attached and an optional set of product representations. Values
/// of these properties and the representation maps are common to all
/// occurrencesÿof that product type.ÿThe type occurrence
/// relationship is realized using the objectified relationship
/// IfcRelDefinesByType.
/// 
/// NOTE 1ÿ The product representations are
/// defined as representation maps, which gets assigned by a product
/// instance through the representation item(s) being an
/// IfcShapeRepresentation and having Items of
/// typeÿIfcMappedItem.
/// NOTE 2 ÿThe representations at the occurrence
/// level (represented by subtypes of IfcProduct) can override
/// the specific representations at the type level, ÿ
/// 
/// for geometric representations: a Cartesian
/// transformation operator can be applied at the occurrence level,
/// andÿ
/// for property sets: A property within an occurrence
/// property set, assigned at the product occurrence, overrides the
/// same property assigned to the product type.
/// 
/// An IfcTypeProduct may be exchanged without being
/// already assigned to subtypes of IfcProduct.
/// 
/// HISTORY New entity in IFC Release 2x.
/// 
/// IFC2x4 CHANGE The entity IfcTypeProduct shall not be instantiated from IFC2x4 onwards. It will be changed into an ABSTRACT supertype in future releases of IFC.
/// 
/// Geometry use definition
/// The RepresentationMaps define the type product shape
/// and multiple geometric representations can be assigned. If a
/// product occurrence is assigned to the type by using the
/// IfcRelDefinesByType relationship, then these occurrences
/// have to reference the representation maps. The reference is
/// created by one or multiple IfcShapeRepresentation's having
/// an IfcMappedItem as Items, that places the
/// IfcRepresentationMap of the type product into the spatial
/// contexts, i.e. by using an Cartesian transformation operator to
/// transform the IfcRepresentationMap into the object
/// coordinate system of the product occurrence.
/// 
/// Figure 10 illustrates an example of referencing a representation map by
/// the shape representation of a product occurrence. Here the
/// Cartesian transformation operator only uses translation, but no
/// rotation, mirroring, or scaling.
/// 
/// Figure 10 — Product type geometry with single placement
/// 
/// Figure 11 illustrates an example of referencing a representation
/// multiple times map by the shape representation of a product
/// occurrence. Here the Cartesian transformation operator only uses
/// translation, but no rotation, mirroring, or scaling. The
/// different translation values determine the pattern of the
/// multiple placement.
/// 
/// Figure 11 — Product type geometry with multiple placement
class IFC_PARSE_API IfcTypeProduct : public IfcTypeObject {
public:
    /// Whether the optional attribute RepresentationMaps is defined for this IfcTypeProduct
    bool hasRepresentationMaps() const;
    /// List of unique representation maps. Each representation map describes a block definition of the shape of the product style. By providing more than one representation map, a multi-view block definition can be given.
    IfcTemplatedEntityList< ::Ifc2x3::IfcRepresentationMap >::ptr RepresentationMaps() const;
    void setRepresentationMaps(IfcTemplatedEntityList< ::Ifc2x3::IfcRepresentationMap >::ptr v);
    /// Whether the optional attribute Tag is defined for this IfcTypeProduct
    bool hasTag() const;
    /// The tag (or label) identifier at the particular type of a product, e.g. the article number (like the EAN). It is the identifier at the specific level.
    std::string Tag() const;
    void setTag(std::string v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcTypeProduct (IfcEntityInstanceData* e);
    IfcTypeProduct (std::string v1_GlobalId, ::Ifc2x3::IfcOwnerHistory* v2_OwnerHistory, boost::optional< std::string > v3_Name, boost::optional< std::string > v4_Description, boost::optional< std::string > v5_ApplicableOccurrence, boost::optional< IfcTemplatedEntityList< ::Ifc2x3::IfcPropertySetDefinition >::ptr > v6_HasPropertySets, boost::optional< IfcTemplatedEntityList< ::Ifc2x3::IfcRepresentationMap >::ptr > v7_RepresentationMaps, boost::optional< std::string > v8_Tag);
    typedef IfcTemplatedEntityList< IfcTypeProduct > list;
};
/// IfcUShapeProfileDef defines
/// a section profile that provides the defining parameters of a U-shape
/// (channel) section to be used by the swept area solid. Its parameters
/// and orientation relative to the position coordinate system are
/// according to the following illustration. The centre of the position
/// coordinate system is in the profile's centre of the bounding box.
/// 
/// HISTORY  New entity in IFC2x2.
/// 
/// IFC2x3 CHANGE  All profile origins are now in the center of the bounding box.
/// 
/// IFC2x4 CHANGE  Type of FilletRadius and EdgeRadius relaxed to allow for zero radius.
/// Trailing attribute CentreOfGravityInX deleted, use respective property in IfcExtendedProfileProperties instead.
/// 
/// Figure 327 illustrates parameters of the U-shape profile definition.
/// 
/// Position 
/// The parameterized profile defines its own position coordinate system.
/// The underlying coordinate system is defined by the swept area solid
/// that uses the profile definition. It is the xy plane of:
/// 
/// IfcSweptAreaSolid.Position
/// 
/// By using offsets of the position location, the parameterized profile
/// can be positioned centric (using x,y offsets = 0.), or at any position
/// relative to the profile.
/// 
/// Figure 327 — U-shape profile
class IFC_PARSE_API IfcUShapeProfileDef : public IfcParameterizedProfileDef {
public:
    /// Web lengths, see illustration above (= h).
    double Depth() const;
    void setDepth(double v);
    /// Flange lengths, see illustration above (= b).
    double FlangeWidth() const;
    void setFlangeWidth(double v);
    /// Constant wall thickness of web (= ts).
    double WebThickness() const;
    void setWebThickness(double v);
    /// Constant wall thickness of flange (= tg).
    double FlangeThickness() const;
    void setFlangeThickness(double v);
    /// Whether the optional attribute FilletRadius is defined for this IfcUShapeProfileDef
    bool hasFilletRadius() const;
    /// Fillet radius according the above illustration (= r1).
    double FilletRadius() const;
    void setFilletRadius(double v);
    /// Whether the optional attribute EdgeRadius is defined for this IfcUShapeProfileDef
    bool hasEdgeRadius() const;
    /// Edge radius according the above illustration (= r2).
    double EdgeRadius() const;
    void setEdgeRadius(double v);
    /// Whether the optional attribute FlangeSlope is defined for this IfcUShapeProfileDef
    bool hasFlangeSlope() const;
    /// Slope of flange of the profile.
    double FlangeSlope() const;
    void setFlangeSlope(double v);
    /// Whether the optional attribute CentreOfGravityInX is defined for this IfcUShapeProfileDef
    bool hasCentreOfGravityInX() const;
    double CentreOfGravityInX() const;
    void setCentreOfGravityInX(double v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcUShapeProfileDef (IfcEntityInstanceData* e);
    IfcUShapeProfileDef (::Ifc2x3::IfcProfileTypeEnum::Value v1_ProfileType, boost::optional< std::string > v2_ProfileName, ::Ifc2x3::IfcAxis2Placement2D* v3_Position, double v4_Depth, double v5_FlangeWidth, double v6_WebThickness, double v7_FlangeThickness, boost::optional< double > v8_FilletRadius, boost::optional< double > v9_EdgeRadius, boost::optional< double > v10_FlangeSlope, boost::optional< double > v11_CentreOfGravityInX);
    typedef IfcTemplatedEntityList< IfcUShapeProfileDef > list;
};
/// Definition from ISO/CD 10303-42:1992: The vector is defined in terms of the direction and magnitude of the vector. The value of the magnitude attribute defines the magnitude of the vector. 
/// 
/// NOTE: The magnitude of the vector can not be reliable calculated from the components of the Orientation attribute. This form of representation was selected to reduce problems with numerical instability. For example a vector of magnitude 2.0 mm and equally inclined to the coordinate axes could be represented with Orientation attribute of (1.0,1.0,1.0).
/// 
/// NOTE: Corresponding ISO 10303 entity: vector. Please refer to ISO/IS 10303-42:1994, p.27 for the final definition of the formal standard. The derived attribute Dim has been added (see also note at IfcGeometricRepresentationItem).
/// 
/// HISTORY: New entity in IFC Release 1.0
class IFC_PARSE_API IfcVector : public IfcGeometricRepresentationItem {
public:
    /// The direction of the vector.
    ::Ifc2x3::IfcDirection* Orientation() const;
    void setOrientation(::Ifc2x3::IfcDirection* v);
    /// The magnitude of the vector. All vectors of Magnitude 0.0 are regarded as equal in value regardless of the orientation attribute.
    double Magnitude() const;
    void setMagnitude(double v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcVector (IfcEntityInstanceData* e);
    IfcVector (::Ifc2x3::IfcDirection* v1_Orientation, double v2_Magnitude);
    typedef IfcTemplatedEntityList< IfcVector > list;
};
/// Definition from ISO/CD 10303-42:1992: A vertex_loop is a loop of
///   zero genus consisting of a single vertex. A vertex can exist independently of a
///   vertex loop. The topological data shall satisfy the following constraint:  
/// 
/// Informal propositions: 
/// 
/// A vertex loop has zero extent and dimensionality. 
///   The vertex loop has genus 0. 
/// 
/// NOTE  Corresponding ISO 10303 entity: vertex_loop. Please refer to ISO/IS 10303-42:1994, p. 121 for the final definition of the formal standard.
/// 
/// HISTORY  New Entity in IFC2x2.
class IFC_PARSE_API IfcVertexLoop : public IfcLoop {
public:
    /// The vertex which defines the entire loop.
    ::Ifc2x3::IfcVertex* LoopVertex() const;
    void setLoopVertex(::Ifc2x3::IfcVertex* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcVertexLoop (IfcEntityInstanceData* e);
    IfcVertexLoop (::Ifc2x3::IfcVertex* v1_LoopVertex);
    typedef IfcTemplatedEntityList< IfcVertexLoop > list;
};
/// The window lining is the outer
/// frame which enables the window to be fixed in position. The
/// window lining is used to hold the window panels or other
/// casements. The parameter of the IfcWindowLiningProperties
/// define the geometrically relevant parameter of the lining.
/// 
/// NOTEÿ The IfcWindowLiningProperties
/// shall only be applied to construct the 3D shape of a window, if
/// the attribute IfcWindowStyle.ParameterTakesPrecedence is
/// set TRUE.
/// 
/// The IfcWindowLiningProperties are included in the set
/// of properties of IfcWindowStyle.HasPropertySets. More
/// information about the window lining can be included in the same
/// set of the IfcWindowStyle using another
/// IfcPropertySet for dynamic extensions.
/// 
/// HISTORY New Entity in IFC Release 2.0. Has been renamed from IfcWindowLining in
/// IFC Release 2x.
/// 
/// IFC2x4 CHANGEÿ The following attributes have been added LiningOffset,
/// LiningToPanelOffsetX, LiningToPanelOffsetY. The
/// attribute ShapeAspectStyle is deprecated and shall no
/// longer be used. Supertype changed to new
/// IfcPreDefinedPropertySet.
/// 
/// Geometry use definitions
/// The IfcWindowLiningProperties does not hold a geometric representation. However it defines parameters which can be used to create the shape of the window style (which is inserted by the IfcWindow into the spatial context of the project) as shown in Figure 175.
/// The parameters at the IfcWindowLiningProperties define a standard window lining, including (if given) a mullion and a transom (for horizontal and vertical splits). The outer boundary of the lining is determined by the occurrence parameter assigned to the IfcWindow, which inserts the IfcWindowStyle.
/// 
/// The lining is applied to all faces
/// of the opening reveal. The parameter are:
/// 
/// LiningDepth
/// LiningThickness
/// LiningOffset
/// LiningToPanelOffsetX
/// LiningToPanelOffsetY
/// 
/// NOTE Parameters added in
/// IFC2x4.
/// 
/// Inner side is defined as the direction of the window panel
/// opening operation.
/// 
/// If the OperationType of the
/// window style is
/// 
/// DoublePanelVertical (shown)
/// TriplePanelBottom
/// TriplePanelTop
/// TriplePanelLeft
/// TriplePanelRight
/// 
/// the following additional parameter apply:
/// 
/// MullionThickness
/// FirstMullionOffset - measured as offset to the Z axis
/// (in XZ plane)
/// 
/// If the OperationType of the
/// window style is
/// 
/// DoublePanelHorizontal
/// TriplePanelBottom
/// TriplePanelTop
/// TriplePanelLeft
/// TriplePanelRight
/// 
/// the following additional parameter apply
/// 
/// TransomThickness
/// FirstTransomOffset measured as offset to the X axis
/// (in XZ plane)
/// 
/// If the OperationType of the
/// window style is
/// 
/// TriplePanelVertical
/// 
/// the following additional parameter apply
/// 
/// SecondMullionOffset
/// 
/// If the OperationType of the
/// window style is
/// 
/// TriplePanelHorizontal
/// 
/// the following additional parameter apply
/// 
/// SecondTransomOffset
/// 
/// Figure 175 — Window lining properties
/// 
/// NOTE
/// 
/// All offsets are given as a normalized ratio measure.
class IFC_PARSE_API IfcWindowLiningProperties : public IfcPropertySetDefinition {
public:
    /// Whether the optional attribute LiningDepth is defined for this IfcWindowLiningProperties
    bool hasLiningDepth() const;
    /// Depth of the window lining (dimension measured perpendicular to window elevation plane).
    double LiningDepth() const;
    void setLiningDepth(double v);
    /// Whether the optional attribute LiningThickness is defined for this IfcWindowLiningProperties
    bool hasLiningThickness() const;
    /// Thickness of the window lining (measured parallel to the window elevation plane).
    double LiningThickness() const;
    void setLiningThickness(double v);
    /// Whether the optional attribute TransomThickness is defined for this IfcWindowLiningProperties
    bool hasTransomThickness() const;
    /// Thickness of the transom (horizontal separator of window panels within a window), measured parallel to the window elevation plane. The transom is part of the lining and the transom depth is assumed to be identical to the lining depth.
    double TransomThickness() const;
    void setTransomThickness(double v);
    /// Whether the optional attribute MullionThickness is defined for this IfcWindowLiningProperties
    bool hasMullionThickness() const;
    /// Thickness of the mullion (vertical separator of window panels within a window), measured parallel to the window elevation plane. The mullion is part of the lining and the mullion depth is assumed to be identical to the lining depth.
    double MullionThickness() const;
    void setMullionThickness(double v);
    /// Whether the optional attribute FirstTransomOffset is defined for this IfcWindowLiningProperties
    bool hasFirstTransomOffset() const;
    /// Offset of the transom centerline, measured along the z-axis of the window placement co-ordinate system. An offset value = 0.5 indicates that the transom is positioned in the middle of the window.
    double FirstTransomOffset() const;
    void setFirstTransomOffset(double v);
    /// Whether the optional attribute SecondTransomOffset is defined for this IfcWindowLiningProperties
    bool hasSecondTransomOffset() const;
    /// Offset of the transom centerline for the second transom, measured along the x-axis of the window placement co-ordinate system. An offset value = 0.666 indicates that the second transom is positioned at two/third of the window.
    double SecondTransomOffset() const;
    void setSecondTransomOffset(double v);
    /// Whether the optional attribute FirstMullionOffset is defined for this IfcWindowLiningProperties
    bool hasFirstMullionOffset() const;
    /// Offset of the mullion centerline, measured along the x-axis of the window placement co-ordinate system. An offset value = 0.5 indicates that the mullion is positioned in the middle of the window.
    double FirstMullionOffset() const;
    void setFirstMullionOffset(double v);
    /// Whether the optional attribute SecondMullionOffset is defined for this IfcWindowLiningProperties
    bool hasSecondMullionOffset() const;
    /// Offset of the mullion centerline for the second mullion, measured along the x-axis of the window placement co-ordinate system. An offset value = 0.666 indicates that the second mullion is positioned at two/third of the window.
    double SecondMullionOffset() const;
    void setSecondMullionOffset(double v);
    /// Whether the optional attribute ShapeAspectStyle is defined for this IfcWindowLiningProperties
    bool hasShapeAspectStyle() const;
    /// Optional link to a shape aspect definition, which points to the part of the geometric representation of the window style, which is used to represent the lining.
    /// 
    /// IFC2x4 CHANGE The attribute is deprecated and shall no longer be used, i.e. the value shall be NIL ($).
    ::Ifc2x3::IfcShapeAspect* ShapeAspectStyle() const;
    void setShapeAspectStyle(::Ifc2x3::IfcShapeAspect* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcWindowLiningProperties (IfcEntityInstanceData* e);
    IfcWindowLiningProperties (std::string v1_GlobalId, ::Ifc2x3::IfcOwnerHistory* v2_OwnerHistory, boost::optional< std::string > v3_Name, boost::optional< std::string > v4_Description, boost::optional< double > v5_LiningDepth, boost::optional< double > v6_LiningThickness, boost::optional< double > v7_TransomThickness, boost::optional< double > v8_MullionThickness, boost::optional< double > v9_FirstTransomOffset, boost::optional< double > v10_SecondTransomOffset, boost::optional< double > v11_FirstMullionOffset, boost::optional< double > v12_SecondMullionOffset, ::Ifc2x3::IfcShapeAspect* v13_ShapeAspectStyle);
    typedef IfcTemplatedEntityList< IfcWindowLiningProperties > list;
};
/// A window panel is a casement, that is, a component, fixed or opening,
/// consisting essentially of a frame and the infilling. The
/// infilling of a window panel is normally glazing. The way of
/// operation is defined in the operation type.
/// The IfcWindowPanelProperties are used to parametrically
/// describe the shape and operation of window panels. The parametric
/// definition can be added solely or additionally to the explicit
/// shape representation of the window.
/// The IfcWindowStyle can define windows consisting of
/// more then one panel. In this case, one instance of
/// IfcWindowPanelProperties has to be included for each
/// window panel. The PanelPosition attribute, in conjunction
/// with the IfcWindowStyle.OperationType attribute,
/// determines to which panel the IfcWindowPanelProperties
/// apply.
/// The IfcWindowPanelProperties are included in the list
/// of properties (HasPropertySets) of the
/// IfcWindowStyle. More information about the window panel
/// can be included in the same list of the IfcWindowStyle
/// using the IfcPropertySet for dynamic extensions.
/// 
/// HISTORY New entity in
/// IFC Release 2.0, it had been renamed from IfcWindowPanel in IFC
/// Release 2x.
/// 
/// IFC2x4 CHANGE Supertype changed to
/// new IfcPreDefinedPropertySet.
/// 
/// Geometry use definitions
/// The IfcWindowPanelProperties does not hold an own
/// geometric representation. However it defines parameter, which can
/// be used to create the shape of the IfcWindowStyle (which
/// is inserted by the IfcWindow into the spatial context of
/// the project).
/// The parameters at the IfcWindowPanelProperties define a
/// standard window panel. The outer boundary of the panel is
/// determined by the occurrence parameter assigned to the IfcWindow,
/// which inserts the IfcWindowStyle. It has to take the lining
/// parameter into account as well. The position of the window panel
/// within the overall window is determined by the
/// PanelPosition attribute.
/// 
/// As shown in Figure 176, the panel is applied to the position within the lining as defined by the panel position attribute. The following parameter apply to that panel: FrameDepth, FrameThickness.
/// 
/// Figure 176 — Window panel properties
class IFC_PARSE_API IfcWindowPanelProperties : public IfcPropertySetDefinition {
public:
    /// Types of window panel operations. Also used to assign standard symbolic presentations according to national building standards.
    ::Ifc2x3::IfcWindowPanelOperationEnum::Value OperationType() const;
    void setOperationType(::Ifc2x3::IfcWindowPanelOperationEnum::Value v);
    /// Position of this panel within the overall window style.
    ::Ifc2x3::IfcWindowPanelPositionEnum::Value PanelPosition() const;
    void setPanelPosition(::Ifc2x3::IfcWindowPanelPositionEnum::Value v);
    /// Whether the optional attribute FrameDepth is defined for this IfcWindowPanelProperties
    bool hasFrameDepth() const;
    /// Depth of panel frame, measured from front face to back face horizontally (i.e. perpendicular to the window (elevation) plane.
    double FrameDepth() const;
    void setFrameDepth(double v);
    /// Whether the optional attribute FrameThickness is defined for this IfcWindowPanelProperties
    bool hasFrameThickness() const;
    /// Width of panel frame, measured from inside of panel (at glazing) to outside of panel (at lining), i.e. parallel to the window (elevation) plane.
    double FrameThickness() const;
    void setFrameThickness(double v);
    /// Whether the optional attribute ShapeAspectStyle is defined for this IfcWindowPanelProperties
    bool hasShapeAspectStyle() const;
    /// Optional link to a shape aspect definition, which points to the part of the geometric representation of the window style, which is used to represent the panel.
    /// 
    /// IFC2x4 CHANGE The attribute is deprecated and shall no longer be used, i.e. the value shall be NIL ($).
    ::Ifc2x3::IfcShapeAspect* ShapeAspectStyle() const;
    void setShapeAspectStyle(::Ifc2x3::IfcShapeAspect* v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcWindowPanelProperties (IfcEntityInstanceData* e);
    IfcWindowPanelProperties (std::string v1_GlobalId, ::Ifc2x3::IfcOwnerHistory* v2_OwnerHistory, boost::optional< std::string > v3_Name, boost::optional< std::string > v4_Description, ::Ifc2x3::IfcWindowPanelOperationEnum::Value v5_OperationType, ::Ifc2x3::IfcWindowPanelPositionEnum::Value v6_PanelPosition, boost::optional< double > v7_FrameDepth, boost::optional< double > v8_FrameThickness, ::Ifc2x3::IfcShapeAspect* v9_ShapeAspectStyle);
    typedef IfcTemplatedEntityList< IfcWindowPanelProperties > list;
};
/// Definition: The window style defines a particular style of windows, which may be included into the spatial context of the building model through instances of IfcWindow. A window style defines the overall parameter of the window style and refers to the particular parameter of the lining and one (or several) panels through IfcWindowLiningProperties and IfcWindowPanelProperties.
/// 
/// The window entity (IfcWindow) defines a particular occurrence of a window inserted in the spatial context of a project. The actual parameter of the window and/or its shape is defined at the IfcWindowStyle, to which the IfcWindow related by the inverse relationship IsDefinedBy pointing to IfcRelDefinesByType. The IfcWindowStyle also defines the particular attributes for the lining (IfcWindowLiningProperties) and panels (IfcWindowPanelProperties).
/// 
/// HISTORY New entity in IFC Release 2x.
/// 
/// IFC2x4 CHANGE The entity has been deprecated and shall not be used. The new entity IfcWindowType shall be used instead.
/// 
/// Geometry use definitions
/// The IfcWindowStyle defines the baseline geometry, or the representation map, for all occurrences of the window style,
/// given by the IfcWindow, pointing to this style. The representation of the window style may be given by the agreed set
/// of minimal parameters, defined for the window lining and the window panel(s), or it may be given by a geometric representation
/// used by the IfcRepresentationMap. The attribute ParameterTakesPrecedence decides, whether the set of
/// parameters can be used to exactly represent the shape of the window style (TRUE), or whether the attached IfcRepresentationMap holds the exact representation (FALSE).
/// 
/// The IfcWindowStyleOperationTypeEnum defines the general layout of the window style. Depending on the enumerator, the
/// appropriate instances of IfcWindowLiningProperties and IfcWindowPanelProperties are attached in the list of
/// HasPropertySets. See geometry use definitions there.
class IFC_PARSE_API IfcWindowStyle : public IfcTypeProduct {
public:
    /// Type defining the basic construction and material type of the window.
    ::Ifc2x3::IfcWindowStyleConstructionEnum::Value ConstructionType() const;
    void setConstructionType(::Ifc2x3::IfcWindowStyleConstructionEnum::Value v);
    /// Type defining the general layout and operation of the window style.
    ::Ifc2x3::IfcWindowStyleOperationEnum::Value OperationType() const;
    void setOperationType(::Ifc2x3::IfcWindowStyleOperationEnum::Value v);
    /// The Boolean value reflects, whether the parameter given in the attached lining and panel properties exactly define the geometry (TRUE), or whether the attached style shape take precedence (FALSE). In the last case the parameter have only informative value.
    bool ParameterTakesPrecedence() const;
    void setParameterTakesPrecedence(bool v);
    /// The Boolean indicates, whether the attached ShapeStyle can be sized (using scale factor of transformation), or not (FALSE). If not, the ShapeStyle should be inserted by the IfcWindow (using IfcMappedItem) with the scale factor = 1.
    bool Sizeable() const;
    void setSizeable(bool v);
        virtual const IfcParse::entity& declaration() const;
    static const IfcParse::entity& Class();
    IfcWindowStyle (IfcEntityInstanceData* e);
    IfcWindowStyle (std::string v1_GlobalId, ::Ifc2x3::IfcOwnerHistory* v2_OwnerHistory, boost::optional< std::string > v3_Name, boost::optional< std::string > v4_Description, boost::optional< std::string > v5_ApplicableOccurrence, boost::option