
# Inspired from http://www.linuxfromscratch.org/blfs/view/svn/postlfs/profile.html
# and ported to zsh.
# Functions to help us manage paths.  Second argument is the name of the
# list variable to be modified
listremove () {
        local PATHVARIABLE=${2}
        local array_helper
        local scalar_helper=${(P)PATHVARIABLE}

        typeset -T scalar_helper array_helper

        array_helper=(${array_helper[@]:#${1}})

        export $PATHVARIABLE=${scalar_helper}
}

listprepend () {
        local PATHVARIABLE=${2}
        local array_helper
        local scalar_helper=${(P)PATHVARIABLE}

        typeset -T scalar_helper array_helper

        array_helper=(${1} ${array_helper})

        export $PATHVARIABLE=${scalar_helper}
}

listappend () {
        local PATHVARIABLE=${2}
        local array_helper
        local scalar_helper=${(P)PATHVARIABLE}

        typeset -T scalar_helper array_helper

        array_helper+=(${1})

        export $PATHVARIABLE=${scalar_helper}
}
if [[ ! -z $COMSPEC ]];
then
    listappend "$CONDA_PREFIX/Library\share\iCub" YARP_DATA_DIRS
    listappend "$CONDA_PREFIX/Library\share" ROS_PACKAGE_PATH
    listappend "$CONDA_PREFIX/Library" AMENT_PREFIX_PATH
else
    listappend "$CONDA_PREFIX/share/iCub" YARP_DATA_DIRS
    listappend "$CONDA_PREFIX/share" ROS_PACKAGE_PATH
    listappend "$CONDA_PREFIX" AMENT_PREFIX_PATH
fi;
if [[ ! -z $COMSPEC ]];
then
    listappend "$CONDA_PREFIX/Library\share\iCub\robots" GAZEBO_MODEL_PATH
else
    listappend "$CONDA_PREFIX/share/iCub/robots" GAZEBO_MODEL_PATH
fi;
if [[ ! -z $COMSPEC ]];
then
    listappend "$CONDA_PREFIX/Library\share" GAZEBO_MODEL_PATH
else
    listappend "$CONDA_PREFIX/share" GAZEBO_MODEL_PATH
fi;