
getpathlistseparator () {
        local PATHVARIABLE=${1:-PATH}
        # If on Windows and PATHVARIABLE is not PATH, 
        # the list separator is ";" otherwise is ":"
        local PATHSEP=":"
        if [ ! -z $COMSPEC ]; then
          if [ "$PATHVARIABLE" != "PATH" ]; then
            local PATHSEP=";"
          fi
        fi
        echo "$PATHSEP"
}

# Taken from http://www.linuxfromscratch.org/blfs/view/svn/postlfs/profile.html
# Functions to help us manage paths.  Second argument is the name of the
# path variable to be modified (default: PATH)
pathremove () {
        local NEWPATH
        local DIR
        local PATHVARIABLE=${2:-PATH}
        local PATHSEP=$(getpathlistseparator $PATHVARIABLE)
        local IFS=$PATHSEP
        for DIR in ${!PATHVARIABLE} ; do
                if [ "$DIR" != "$1" ] ; then
                  NEWPATH=${NEWPATH:+$NEWPATH${PATHSEP}}$DIR
                fi
        done
        export $PATHVARIABLE="$NEWPATH"
}

pathprepend () {
        # pathremove $1 $2
        local PATHVARIABLE=${2:-PATH}
        local PATHSEP=$(getpathlistseparator $PATHVARIABLE)
        export $PATHVARIABLE="$1${!PATHVARIABLE:+${PATHSEP}${!PATHVARIABLE}}"
}

pathappend () {
        # pathremove $1 $2
        local PATHVARIABLE=${2:-PATH}
        local PATHSEP=$(getpathlistseparator $PATHVARIABLE)
        export $PATHVARIABLE="${!PATHVARIABLE:+${!PATHVARIABLE}${PATHSEP}}$1"
}
if [[ ! -z $COMSPEC ]];
then
    pathappend "$CONDA_PREFIX/Library\share\iCub" YARP_DATA_DIRS
    pathappend "$CONDA_PREFIX/Library\share" ROS_PACKAGE_PATH
    pathappend "$CONDA_PREFIX/Library" AMENT_PREFIX_PATH
else
    pathappend "$CONDA_PREFIX/share/iCub" YARP_DATA_DIRS
    pathappend "$CONDA_PREFIX/share" ROS_PACKAGE_PATH
    pathappend "$CONDA_PREFIX" AMENT_PREFIX_PATH
fi;
if [[ ! -z $COMSPEC ]];
then
    pathappend "$CONDA_PREFIX/Library\share\iCub\robots" GAZEBO_MODEL_PATH
else
    pathappend "$CONDA_PREFIX/share/iCub/robots" GAZEBO_MODEL_PATH
fi;
if [[ ! -z $COMSPEC ]];
then
    pathappend "$CONDA_PREFIX/Library\share" GAZEBO_MODEL_PATH
else
    pathappend "$CONDA_PREFIX/share" GAZEBO_MODEL_PATH
fi;