
import os, sys

# Inspired from http://www.linuxfromscratch.org/blfs/view/svn/postlfs/profile.html
# and ported to xonsh.
# Functions to help us manage paths.  Second argument is the name of the
# list variable to be modified
def listremove(elemToRemove, varToModify):
    # xonsh has diffent types for the variables depending on their name,
    # see https://xon.sh/tutorial.html#environment-types
    # so we need to always distinguish three cases:
    # * the variable does not exist
    # * the variable is a string
    # * the variable is a list
    if (varToModify not in ${...}):
        return
    elif (type(${varToModify}) == str):
        ${varToModify} = os.pathsep.join(list(filter(lambda el: el != elemToRemove, ${varToModify}.split(os.pathsep))))
    elif (type(${varToModify}) == type($PATH)):
        while(elemToRemove in ${varToModify}): ${varToModify}.remove(elemToRemove)

def listprepend(elemToPrepend, varToModify):
    if (varToModify not in ${...}):
        ${varToModify}=elemToPrepend
    elif (type(${varToModify}) == str):
        ${varToModify} = os.pathsep.join([elemToPrepend] + ${varToModify}.split(os.pathsep))
    elif (type(${varToModify}) == type($PATH)):
        ${varToModify}.insert(0, elemToPrepend)

def listappend(elemToAppend, varToModify):
    if (varToModify not in ${...}):
        ${varToModify}=elemToAppend
    elif (type(${varToModify}) == str):
        ${varToModify} = os.pathsep.join(${varToModify}.split(os.pathsep) + [elemToAppend])
    elif (type(${varToModify}) == type($PATH)):
        ${varToModify}.append(elemToAppend)

if ("COMSPEC" in ${...}):
    listappend("@\(os\.path\.join\("\\\$CONDA_PREFIX",\ "Library\\\\share\\\\iCub"\)\)", "YARP_DATA_DIRS")
    listappend("@\(os\.path\.join\("\\\$CONDA_PREFIX",\ "Library\\\\share"\)\)", "ROS_PACKAGE_PATH")
    listappend("@\(os\.path\.join\("\\\$CONDA_PREFIX",\ "Library"\)\)", "AMENT_PREFIX_PATH")
else:
    listappend("@\(os\.path\.join\("\\\$CONDA_PREFIX",\ "share/iCub"\)\)", "YARP_DATA_DIRS")
    listappend("@\(os\.path\.join\("\\\$CONDA_PREFIX",\ "share"\)\)", "ROS_PACKAGE_PATH")
    listappend("\$CONDA_PREFIX", "AMENT_PREFIX_PATH")

if ("COMSPEC" in ${...}):
    listappend("@\(os\.path\.join\("\\\$CONDA_PREFIX",\ "Library\\\\share\\\\iCub\\\\robots"\)\)", "GAZEBO_MODEL_PATH")
else:
    listappend("@\(os\.path\.join\("\\\$CONDA_PREFIX",\ "share/iCub/robots"\)\)", "GAZEBO_MODEL_PATH")

if ("COMSPEC" in ${...}):
    listappend("@\(os\.path\.join\("\\\$CONDA_PREFIX",\ "Library\\\\share"\)\)", "GAZEBO_MODEL_PATH")
else:
    listappend("@\(os\.path\.join\("\\\$CONDA_PREFIX",\ "share"\)\)", "GAZEBO_MODEL_PATH")
