# Copyright 2011-2016, Vinothan N. Manoharan, Thomas G. Dimiduk,
# Rebecca W. Perry, Jerome Fung, and Ryan McGorty, Anna Wang
#
# This file is part of HoloPy.
#
# HoloPy is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# HoloPy is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with HoloPy.  If not, see <http://www.gnu.org/licenses/>.
"""Visualize HoloPy objects

Uses Matplotlib and Mayavi to visualize holopy objects.

1. :class:`.Image`, :class:`.Volume`, or :class:`.Spheres` object =>
   plot or rendering

This module does not import plotting packages until they are actually needed so
that holopy does not have a hard dependency on mayavi or matplotlib.  Because of
this you may see a small lag on your first plot.

.. moduleauthor:: Thomas G. Dimiduk <tdimiduk@physics.harvard.edu>
"""


from .show import show, test_disp
from .vis2d import show2d
