function(copy_interface_properties target source)
  foreach(prop
          INTERFACE_COMPILE_DEFINITIONS
          INTERFACE_COMPILE_FEATURES
          INTERFACE_COMPILE_OPTIONS
          INTERFACE_INCLUDE_DIRECTORIES
          INTERFACE_LINK_LIBRARIES
          INTERFACE_SOURCES
          INTERFACE_SYSTEM_INCLUDE_DIRECTORIES)
    set_property(TARGET ${target} APPEND PROPERTY ${prop} $<TARGET_PROPERTY:${source},${prop}>)
  endforeach()
endfunction()

# Get HighFive targets
include("${CMAKE_CURRENT_LIST_DIR}/HighFiveTargets.cmake")

# Recreate combined HighFive
add_library(HighFive INTERFACE IMPORTED)
set_property(TARGET HighFive APPEND PROPERTY INTERFACE_COMPILE_DEFINITIONS MPI_NO_CPPBIND)  # No c++ bindings

# Ensure we activate required C++ std
if(NOT DEFINED CMAKE_CXX_STANDARD)
  if(CMAKE_VERSION VERSION_LESS 3.8)
    message(WARNING "HighFive requires minimum C++11. (C++14 for XTensor) \
        You may need to set CMAKE_CXX_STANDARD in you project")
  else()
    # A client request for a higher std overrides this
    target_compile_features(HighFive INTERFACE cxx_std_11)
  endif()
endif()

# If the user sets this flag, all dependencies are preserved.
# Useful in central deployments where dependencies are not prepared later
option(HIGHFIVE_USE_INSTALL_DEPS "Use original Highfive dependencies" OFF)
if(HIGHFIVE_USE_INSTALL_DEPS)
  # If enabled in the deploy config, request c++14
  if(OFF AND NOT CMAKE_VERSION VERSION_LESS 3.8)
    set_property(TARGET HighFive APPEND PROPERTY INTERFACE_COMPILE_FEATURES cxx_std_14)
  endif()
  message("HIGHFIVE 2.2: Using original dependencies (HIGHFIVE_USE_INSTALL_DEPS=YES)")
  copy_interface_properties(HighFive HighFive_HighFive)
  return()
endif()

# When not using the pre-built dependencies, give user options
option(HIGHFIVE_USE_BOOST "Enable Boost Support" ON)
option(HIGHFIVE_USE_EIGEN "Enable Eigen testing" OFF)
option(HIGHFIVE_USE_XTENSOR "Enable xtensor testing" OFF)

# Options when used from external projects. Keep defaults
if(NOT DEFINED HIGHFIVE_PARALLEL_HDF5)
  option(HIGHFIVE_PARALLEL_HDF5 "Enable Parallel HDF5 support" OFF)
endif()
if(NOT DEFINED HIGHFIVE_USE_BOOST)
  option(HIGHFIVE_USE_BOOST "Enable Boost Support" ON)
endif()

if(HIGHFIVE_USE_XTENSOR AND NOT CMAKE_VERSION VERSION_LESS 3.8)
  set_property(TARGET HighFive APPEND PROPERTY INTERFACE_COMPILE_FEATURES cxx_std_14)
endif()

message("HIGHFIVE 2.2: (Re)Detecting Highfive dependencies (HIGHFIVE_USE_INSTALL_DEPS=NO)")
include("${CMAKE_CURRENT_LIST_DIR}/HighFiveTargetDeps.cmake")
foreach(dependency HighFive_libheaders libdeps)
    copy_interface_properties(HighFive ${dependency})
endforeach()
