# HELICS cmake module
# This module sets the following variables in your project::
#
#   HELICS_FOUND - true if HELICS found on the system
#   HELICS_INCLUDE_DIR - the directory containing HELICS headers
#   HELICS_C_SHARED_LIBRARY - the C shared library
# 	HELICS_CXX_SHARED_LIBRARY -the C++ shared library
#   HELICS_STATIC_LIBRARY -the static Library
# 	HELICS_DEPENDENCIES -- list of dependencies in the helics project
#   HELICS_PLAYER -- the player executable
#  	HELICS_RECORDER -- the recorder executable
#   HELICS_APP  -- the helics app executable
#   HELICS_BROKER -- the helics broker executable

####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was HELICSConfig.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

set(PN HELICS)
set_and_check(${PN}_INCLUDE_DIR "${PACKAGE_PREFIX_DIR}/include")

set(C_SHARED_BUILT )
if (C_SHARED_BUILT )
set(${PN}_C_SHARED_LIBRARY "${PACKAGE_PREFIX_DIR}/bin/helicsSharedLib.dll")
set(${PN}_C_SHARED_LIBRARY_DEBUG "${PACKAGE_PREFIX_DIR}/bin/helicsSharedLibd.dll")
endif()

set(CXX_SHARED_BUILT OFF)
if (CXX_SHARED_BUILT)
set(${PN}_CXX_SHARED_LIBRARY "${PACKAGE_PREFIX_DIR}/bin/")
set(${PN}_CXX_SHARED_LIBRARY_DEBUG "${PACKAGE_PREFIX_DIR}/bin/")
endif()

set(${PN}_STATIC_LIBRARY "${PACKAGE_PREFIX_DIR}/lib/helics-static.lib")
set(${PN}_STATIC_LIBRARY_DEBUG "${PACKAGE_PREFIX_DIR}/lib/helics-staticd.lib")

find_program(HELICS_PLAYER helics_player 
	PATH ${PACKAGE_PREFIX_DIR}/bin
	NO_DEFAULT_PATH)
	
find_program(HELICS_RECORDER helics_recorder 
	PATH ${PACKAGE_PREFIX_DIR}/bin
	NO_DEFAULT_PATH)
	
find_program(HELICS_APP helics_app 
	PATH ${PACKAGE_PREFIX_DIR}/bin
	NO_DEFAULT_PATH)
	
find_program(HELICS_BROKER helics_broker 
	PATH ${PACKAGE_PREFIX_DIR}/bin
	NO_DEFAULT_PATH)
	
set(HELICS_HAVE_ZEROMQ TRUE)
set(HELICS_HAVE_MPI FALSE)

set(CMAKE_MODULE_PATH ${PACKAGE_PREFIX_DIR}/lib/cmake/HELICS)

include(CMakeFindDependencyMacro)
include(extraMacros)

if (TARGET Boostlibs::core)
else()
	include(addBoost)
endif()

if (HELICS_HAVE_ZEROMQ)
	if (TARGET libzmq)
	else()
		set(ZeroMQ_LIBRARY_ONLY ON)
		if(NOT ZeroMQ_INSTALL_PATH)
			if(ENV{ZeroMQ_INSTALL_PATH})
				set(ZeroMQ_INSTALL_PATH $ENV{ZeroMQ_INSTALL_PATH})
			else()
				set(ZeroMQ_INSTALL_PATH ${PACKAGE_PREFIX_DIR})
			endif()
		endif()
		find_dependency(ZeroMQ)
	endif()
endif()

if (HELICS_HAVE_MPI)
	if (TARGET MPI::MPI_C)
	else()
		include(addMPI)
	endif()
endif()

#find_dependency(ZeroMQ)

if (TARGET Threads::Threads)
else()
	if (NOT WIN32)
		set(THREADS_PREFER_PTHREAD_FLAG ON)
	elseif (MSYS)
		set(THREADS_PREFER_PTHREAD_FLAG ON)
	endif()
	find_dependency(Threads REQUIRED)
endif()

include(${CMAKE_CURRENT_LIST_DIR}/helics-targets.cmake)

get_target_property(_BOOST_SYSTEM_INCLUDE_DIR Boostlibs::core INTERFACE_SYSTEM_INCLUDE_DIRECTORIES)
if(_BOOST_SYSTEM_INCLUDE_DIR)
	set_property(TARGET HELICS::helics_base_includes APPEND PROPERTY INTERFACE_INCLUDE_DIRECTORIES ${_BOOST_SYSTEM_INCLUDE_DIR})
endif()
unset(_BOOST_SYSTEM_INCLUDE_DIR)

if (TARGET HELICS::helicsSharedLib)
	add_library(HELICS::helicsCpp98 INTERFACE IMPORTED)
	set_property(TARGET HELICS::helicsCpp98 PROPERTY INTERFACE_INCLUDE_DIRECTORIES "${PACKAGE_PREFIX_DIR}/include/cpp98")

	set_property(TARGET HELICS::helicsCpp98 PROPERTY INTERFACE_LINK_LIBRARIES HELICS::helicsSharedLib)

	set_target_properties(HELICS::helicsSharedLib PROPERTIES
		INTERFACE_INCLUDE_DIRECTORIES "${PACKAGE_PREFIX_DIR}/include/helics/shared_api_library"
	)
endif()

check_required_components(${PN})

