# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '_helics')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('_helics')
    _helics = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_helics', [dirname(__file__)])
        except ImportError:
            import _helics
            return _helics
        try:
            _mod = imp.load_module('_helics', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    _helics = swig_import_helper()
    del swig_import_helper
else:
    import _helics
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        if _newclass:
            object.__setattr__(self, name, value)
        else:
            self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except __builtin__.Exception:
    class _object:
        pass
    _newclass = 0

helics_ok = _helics.helics_ok
helics_registration_failure = _helics.helics_registration_failure
helics_invalid_object = _helics.helics_invalid_object
helics_invalid_argument = _helics.helics_invalid_argument
helics_discard = _helics.helics_discard
helics_terminated = _helics.helics_terminated
helics_warning = _helics.helics_warning
helics_invalid_state_transition = _helics.helics_invalid_state_transition
helics_invalid_function_call = _helics.helics_invalid_function_call
helics_error = _helics.helics_error
no_iteration = _helics.no_iteration
force_iteration = _helics.force_iteration
iterate_if_needed = _helics.iterate_if_needed
next_step = _helics.next_step
iteration_error = _helics.iteration_error
iteration_halted = _helics.iteration_halted
iterating = _helics.iterating
helics_startup_state = _helics.helics_startup_state
helics_initialization_state = _helics.helics_initialization_state
helics_execution_state = _helics.helics_execution_state
helics_finalize_state = _helics.helics_finalize_state
helics_error_state = _helics.helics_error_state
helics_pending_init_state = _helics.helics_pending_init_state
helics_pending_exec_state = _helics.helics_pending_exec_state
helics_pending_time_state = _helics.helics_pending_time_state
helics_pending_iterative_time_state = _helics.helics_pending_iterative_time_state
helics_custom_filter = _helics.helics_custom_filter
helics_delay_filter = _helics.helics_delay_filter
helics_randomDelay_filter = _helics.helics_randomDelay_filter
helics_randomDrop_filter = _helics.helics_randomDrop_filter
helics_reroute_filter = _helics.helics_reroute_filter
helics_clone_filter = _helics.helics_clone_filter
class data_t(_object):
    """


    Data to be communicated.

    Core operates on opaque byte buffers.

    C++ includes: api-data.h

    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, data_t, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, data_t, name)
    __repr__ = _swig_repr
    __swig_setmethods__["data"] = _helics.data_t_data_set
    __swig_getmethods__["data"] = _helics.data_t_data_get
    if _newclass:
        data = _swig_property(_helics.data_t_data_get, _helics.data_t_data_set)
    __swig_setmethods__["length"] = _helics.data_t_length_set
    __swig_getmethods__["length"] = _helics.data_t_length_get
    if _newclass:
        length = _swig_property(_helics.data_t_length_get, _helics.data_t_length_set)

    def __init__(self):
        """


        Data to be communicated.

        Core operates on opaque byte buffers.

        C++ includes: api-data.h

        """
        this = _helics.new_data_t()
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _helics.delete_data_t
    __del__ = lambda self: None
data_t_swigregister = _helics.data_t_swigregister
data_t_swigregister(data_t)
cvar = _helics.cvar
helics_time_zero = cvar.helics_time_zero
helics_time_epsilon = cvar.helics_time_epsilon
helics_true = cvar.helics_true
helics_false = cvar.helics_false

class message_t(_object):
    """


    Message_t mapped to a c compatible structure

    C++ includes: api-data.h

    """

    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, message_t, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, message_t, name)
    __repr__ = _swig_repr
    __swig_setmethods__["time"] = _helics.message_t_time_set
    __swig_getmethods__["time"] = _helics.message_t_time_get
    if _newclass:
        time = _swig_property(_helics.message_t_time_get, _helics.message_t_time_set)
    __swig_setmethods__["data"] = _helics.message_t_data_set
    __swig_getmethods__["data"] = _helics.message_t_data_get
    if _newclass:
        data = _swig_property(_helics.message_t_data_get, _helics.message_t_data_set)
    __swig_setmethods__["length"] = _helics.message_t_length_set
    __swig_getmethods__["length"] = _helics.message_t_length_get
    if _newclass:
        length = _swig_property(_helics.message_t_length_get, _helics.message_t_length_set)
    __swig_setmethods__["original_source"] = _helics.message_t_original_source_set
    __swig_getmethods__["original_source"] = _helics.message_t_original_source_get
    if _newclass:
        original_source = _swig_property(_helics.message_t_original_source_get, _helics.message_t_original_source_set)
    __swig_setmethods__["source"] = _helics.message_t_source_set
    __swig_getmethods__["source"] = _helics.message_t_source_get
    if _newclass:
        source = _swig_property(_helics.message_t_source_get, _helics.message_t_source_set)
    __swig_setmethods__["dest"] = _helics.message_t_dest_set
    __swig_getmethods__["dest"] = _helics.message_t_dest_get
    if _newclass:
        dest = _swig_property(_helics.message_t_dest_get, _helics.message_t_dest_set)
    __swig_setmethods__["original_dest"] = _helics.message_t_original_dest_set
    __swig_getmethods__["original_dest"] = _helics.message_t_original_dest_get
    if _newclass:
        original_dest = _swig_property(_helics.message_t_original_dest_get, _helics.message_t_original_dest_set)

    def __init__(self):
        """


        Message_t mapped to a c compatible structure

        C++ includes: api-data.h

        """
        this = _helics.new_message_t()
        try:
            self.this.append(this)
        except __builtin__.Exception:
            self.this = this
    __swig_destroy__ = _helics.delete_message_t
    __del__ = lambda self: None
message_t_swigregister = _helics.message_t_swigregister
message_t_swigregister(message_t)

HELICS_CORE_TYPE_DEFAULT = _helics.HELICS_CORE_TYPE_DEFAULT
HELICS_CORE_TYPE_ZMQ = _helics.HELICS_CORE_TYPE_ZMQ
HELICS_CORE_TYPE_MPI = _helics.HELICS_CORE_TYPE_MPI
HELICS_CORE_TYPE_TEST = _helics.HELICS_CORE_TYPE_TEST
HELICS_CORE_TYPE_INTERPROCESS = _helics.HELICS_CORE_TYPE_INTERPROCESS
HELICS_CORE_TYPE_IPC = _helics.HELICS_CORE_TYPE_IPC
HELICS_CORE_TYPE_TCP = _helics.HELICS_CORE_TYPE_TCP
HELICS_CORE_TYPE_UDP = _helics.HELICS_CORE_TYPE_UDP

def helicsGetVersion() -> "char const *":
    """


    """
    return _helics.helicsGetVersion()

def helicsIsCoreTypeAvailable(type: 'char const *') -> "helics_bool_t":
    """


    Returns true if core/broker type specified is available in current compilation.

    """
    return _helics.helicsIsCoreTypeAvailable(type)

def helicsCreateCore(type: 'char const *', name: 'char const *', initString: 'char const *') -> "helics_core":
    """


    create a core object

    Parameters
    ----------
    * `type` :
        the type of the core to create
    * `name` :
        the name of the core , may be a nullptr or empty string to have a name
        automatically assigned
    * `initString` :
        an initialization string to send to the core-the format is similar to
        command line arguments typical options include a broker address
        --broker="XSSAF" or the number of federates or the address

    Returns
    -------
    a helics_core object

    """
    return _helics.helicsCreateCore(type, name, initString)

def helicsCreateCoreFromArgs(type: 'char const *', name: 'char const *', argc: 'int') -> "helics_core":
    """


    create a core object by passing command line arguments

    Parameters
    ----------
    * `type` :
        the type of the core to create
    * `name` :
        the name of the core , may be a nullptr or empty string to have a name
        automatically assigned
    * `argc` :
        the number of arguments
    * `argv` :
        the string values from a command line

    Returns
    -------
    a helics_core object

    """
    return _helics.helicsCreateCoreFromArgs(type, name, argc)

def helicsCoreClone(core: 'helics_core') -> "helics_core":
    return _helics.helicsCoreClone(core)
helicsCoreClone = _helics.helicsCoreClone

def helicsCreateBroker(type: 'char const *', name: 'char const *', initString: 'char const *') -> "helics_broker":
    """


    create a broker object

    Parameters
    ----------
    * `type` :
        the type of the broker to create
    * `name` :
        the name of the broker , may be a nullptr or empty string to have a name
        automatically assigned
    * `initString` :
        an initialization string to send to the core-the format is similar to
        command line arguments typical options include a broker address
        --broker="XSSAF" if this is a subbroker or the number of federates or the
        address

    Returns
    -------
    a helics_core object

    """
    return _helics.helicsCreateBroker(type, name, initString)

def helicsCreateBrokerFromArgs(type: 'char const *', name: 'char const *', argc: 'int') -> "helics_broker":
    """


    create a core object by passing command line arguments

    Parameters
    ----------
    * `type` :
        the type of the core to create
    * `name` :
        the name of the core , may be a nullptr or empty string to have a name
        automatically assigned
    * `argc` :
        the number of arguments
    * `argv` :
        the string values from a command line

    Returns
    -------
    a helics_core object

    """
    return _helics.helicsCreateBrokerFromArgs(type, name, argc)

def helicsBrokerClone(broker: 'helics_broker') -> "helics_broker":
    return _helics.helicsBrokerClone(broker)
helicsBrokerClone = _helics.helicsBrokerClone

def helicsBrokerIsConnected(broker: 'helics_broker') -> "int":
    """


    check if a broker is connected a connected broker implies is attached to cores
    or cores could reach out to communicate return 0 if not connected , something
    else if it is connected

    """
    return _helics.helicsBrokerIsConnected(broker)

def helicsBrokerWaitForDisconnect(broker: 'helics_broker', msToWait: 'int') -> "helics_status":
    return _helics.helicsBrokerWaitForDisconnect(broker, msToWait)
helicsBrokerWaitForDisconnect = _helics.helicsBrokerWaitForDisconnect

def helicsCoreIsConnected(core: 'helics_core') -> "int":
    """


    check if a core is connected a connected core implies is attached to federate or
    federates could be attached to it return 0 if not connected , something else if
    it is connected

    """
    return _helics.helicsCoreIsConnected(core)

def helicsBrokerGetIdentifier(broker: 'helics_broker') -> "int":
    """


    get an identifier for the broker

    Parameters
    ----------
    * `broker` :
        the broker to query
    * `identifier` :
        storage space to place the identifier string
    * `maxlen` :
        the maximum space available in identifier

    Returns
    -------
    a helics_status enumeration indicating any error condition

    """
    return _helics.helicsBrokerGetIdentifier(broker)

def helicsCoreGetIdentifier(core: 'helics_core') -> "int":
    """


    get an identifier for the core

    Parameters
    ----------
    * `core` :
        the core to query
    * `identifier` :
        storage space to place the identifier string
    * `maxlen` :
        the maximum space available in identifier

    Returns
    -------
    a helics_status enumeration indicating any error condition

    """
    return _helics.helicsCoreGetIdentifier(core)

def helicsBrokerGetAddress(broker: 'helics_broker') -> "int":
    """


    get the network address associated with a broker

    Parameters
    ----------
    * `broker` :
        the broker to query
    * `identifier` :
        storage space to place the identifier string
    * `maxlen` :
        the maximum space available in identifier

    Returns
    -------
    a helics_status enumeration indicating any error condition

    """
    return _helics.helicsBrokerGetAddress(broker)

def helicsCoreSetReadyToInit(core: 'helics_core') -> "helics_status":
    return _helics.helicsCoreSetReadyToInit(core)
helicsCoreSetReadyToInit = _helics.helicsCoreSetReadyToInit

def helicsCoreDisconnect(core: 'helics_core') -> "helics_status":
    """


    get an identifier for the core

    Parameters
    ----------
    * `core` :
        the core to query
    * `identifier` :
        storage space to place the identifier string
    * `maxlen` :
        the maximum space available in identifier

    Returns
    -------
    a helics_status enumeration indicating any error condition

    """
    return _helics.helicsCoreDisconnect(core)

def helicsGetFederateByName(fedName: 'char const *') -> "helics_federate":
    return _helics.helicsGetFederateByName(fedName)
helicsGetFederateByName = _helics.helicsGetFederateByName

def helicsBrokerDisconnect(broker: 'helics_broker') -> "helics_status":
    """


    get the network address associated with a broker

    Parameters
    ----------
    * `broker` :
        the broker to query
    * `identifier` :
        storage space to place the identifier string
    * `maxlen` :
        the maximum space available in identifier

    Returns
    -------
    a helics_status enumeration indicating any error condition

    """
    return _helics.helicsBrokerDisconnect(broker)

def helicsDestroyFederate(fed: 'helics_federate') -> "void":
    return _helics.helicsDestroyFederate(fed)
helicsDestroyFederate = _helics.helicsDestroyFederate

def helicsDestroyBroker(broker: 'helics_broker') -> "void":
    return _helics.helicsDestroyBroker(broker)
helicsDestroyBroker = _helics.helicsDestroyBroker

def helicsDestroyCore(core: 'helics_core') -> "void":
    return _helics.helicsDestroyCore(core)
helicsDestroyCore = _helics.helicsDestroyCore

def helicsCoreFree(core: 'helics_core') -> "void":
    """


    release the memory associated with a core

    """
    return _helics.helicsCoreFree(core)

def helicsBrokerFree(broker: 'helics_broker') -> "void":
    """


    release the memory associated with a broker

    """
    return _helics.helicsBrokerFree(broker)

def helicsCreateValueFederate(fi: 'helics_federate_info_t const') -> "helics_federate":
    """


    create a value federate from a federate info object

    helics_federate objects can be used in all functions that take a helics_federate
    or helics_federate object as an argument

    Parameters
    ----------
    * `fi` :
        the federate info object that contains details on the federate

    Returns
    -------
    an opaque value federate object

    """
    return _helics.helicsCreateValueFederate(fi)

def helicsCreateValueFederateFromJson(JSON: 'char const *') -> "helics_federate":
    """


    create a value federate from a JSON file or JSON string

    helics_federate objects can be used in all functions that take a helics_federate
    or helics_federate object as an argument

    Parameters
    ----------
    * `JSON` :
        a JSON file or a JSON string that contains setup and configuration
        information

    Returns
    -------
    an opaque value federate object

    """
    return _helics.helicsCreateValueFederateFromJson(JSON)

def helicsCreateMessageFederate(fi: 'helics_federate_info_t const') -> "helics_federate":
    """


    create a message federate from a federate info object

    helics_message_federate objects can be used in all functions that take a
    helics_message_federate or helics_federate object as an argument

    Parameters
    ----------
    * `fi` :
        the federate info object that contains details on the federate

    Returns
    -------
    an opaque message federate object

    """
    return _helics.helicsCreateMessageFederate(fi)

def helicsCreateMessageFederateFromJson(JSON: 'char const *') -> "helics_federate":
    """


    create a message federate from a JSON file or JSON string

    helics_message_federate objects can be used in all functions that take a
    helics_message_federate or helics_federate object as an argument

    Parameters
    ----------
    * `JSON` :
        a JSON file or a JSON string that contains setup and configuration
        information

    Returns
    -------
    an opaque message federate object

    """
    return _helics.helicsCreateMessageFederateFromJson(JSON)

def helicsCreateCombinationFederate(fi: 'helics_federate_info_t const') -> "helics_federate":
    """


    create a combination federate from a federate info object

    combination federates are both value federates and message federates, objects
    can be used in all functions that take a helics_federate,
    helics_message_federate or helics_federate object as an argument

    Parameters
    ----------
    * `fi` :
        the federate info object that contains details on the federate

    Returns
    -------
    an opaque value federate object nullptr if the object creation failed

    """
    return _helics.helicsCreateCombinationFederate(fi)

def helicsCreateCombinationFederateFromJson(JSON: 'char const *') -> "helics_federate":
    """


    create a combination federate from a JSON file or JSON string

    combination federates are both value federates and message federates, objects
    can be used in all functions that take a helics_federate,
    helics_message_federate or helics_federate object as an argument

    Parameters
    ----------
    * `JSON` :
        a JSON file or a JSON string that contains setup and configuration
        information

    Returns
    -------
    an opaque combination federate object

    """
    return _helics.helicsCreateCombinationFederateFromJson(JSON)

def helicsFederateClone(fed: 'helics_federate') -> "helics_federate":
    return _helics.helicsFederateClone(fed)
helicsFederateClone = _helics.helicsFederateClone

def helicsFederateInfoCreate() -> "helics_federate_info_t":
    """


    create a federate info object for specifying federate information when
    constructing a federate

    Returns
    -------
    a helics_federate_info_t object which is a reference to the created object

    """
    return _helics.helicsFederateInfoCreate()

def helicsFederateInfoLoadFromArgs(fi: 'helics_federate_info_t', argc: 'int') -> "helics_status":
    """


    load a federate info from command line arguments

    Parameters
    ----------
    * `fi` :
        a federateInfo object
    * `argc` :
        the number of command line arguments
    * `argv` :
        an array of strings from the command line

    Returns
    -------
    a helics_status enumeration indicating success or any potential errors

    """
    return _helics.helicsFederateInfoLoadFromArgs(fi, argc)

def helicsFederateInfoFree(fi: 'helics_federate_info_t') -> "void":
    """


    delete the memory associated with a federate info object

    """
    return _helics.helicsFederateInfoFree(fi)

def helicsFederateInfoSetFederateName(fi: 'helics_federate_info_t', name: 'char const *') -> "helics_status":
    """


    set the federate name in the Federate Info structure

    Parameters
    ----------
    * `fi` :
        the federate info object to alter
    * `name` :
        the new identifier for the federate

    Returns
    -------
    a helics_status enumeration helics_ok on success

    """
    return _helics.helicsFederateInfoSetFederateName(fi, name)

def helicsFederateInfoSetCoreName(fi: 'helics_federate_info_t', corename: 'char const *') -> "helics_status":
    """


    set the name of the core to link to for a federate

    Parameters
    ----------
    * `fi` :
        the federate info object to alter
    * `corename` :
        the identifier for a core to link to

    Returns
    -------
    a helics_status enumeration helics_ok on success helicsInvalidReference if fi is
    not a valid reference

    """
    return _helics.helicsFederateInfoSetCoreName(fi, corename)

def helicsFederateInfoSetCoreInitString(fi: 'helics_federate_info_t', coreInit: 'char const *') -> "helics_status":
    """


    set the initialization string for the core usually in the form of command line
    arguments

    Parameters
    ----------
    * `fi` :
        the federate info object to alter
    * `coreInit` :
        a string with the core initialization strings

    Returns
    -------
    a helics_status enumeration helics_ok on success helicsInvalidReference if fi is
    not a valid reference

    """
    return _helics.helicsFederateInfoSetCoreInitString(fi, coreInit)

def helicsFederateInfoSetCoreTypeFromString(fi: 'helics_federate_info_t', coretype: 'char const *') -> "helics_status":
    """


    set the core type from a string

    Parameters
    ----------
    * `fi` :
        the federate info object to alter
    * `coretype` :
        a string naming a core type

    Returns
    -------
    a helics_status enumeration helics_ok on success helicsInvalidReference if fi is
    not a valid reference helics_discard if the string is not recognized

    """
    return _helics.helicsFederateInfoSetCoreTypeFromString(fi, coretype)

def helicsFederateInfoSetCoreType(fi: 'helics_federate_info_t', coretype: 'int') -> "helics_status":
    """


    """
    return _helics.helicsFederateInfoSetCoreType(fi, coretype)

def helicsFederateInfoSetFlag(fi: 'helics_federate_info_t', flag: 'int', value: 'helics_bool_t') -> "helics_status":
    """


    """
    return _helics.helicsFederateInfoSetFlag(fi, flag, value)

def helicsFederateInfoSetSeparator(fi: 'helics_federate_info_t', separator: 'char') -> "helics_status":
    return _helics.helicsFederateInfoSetSeparator(fi, separator)
helicsFederateInfoSetSeparator = _helics.helicsFederateInfoSetSeparator

def helicsFederateInfoSetOutputDelay(fi: 'helics_federate_info_t', outputDelay: 'helics_time_t') -> "helics_status":
    """


    """
    return _helics.helicsFederateInfoSetOutputDelay(fi, outputDelay)

def helicsFederateInfoSetTimeDelta(fi: 'helics_federate_info_t', timeDelta: 'helics_time_t') -> "helics_status":
    """


    """
    return _helics.helicsFederateInfoSetTimeDelta(fi, timeDelta)

def helicsFederateInfoSetInputDelay(fi: 'helics_federate_info_t', inputDelay: 'helics_time_t') -> "helics_status":
    """


    """
    return _helics.helicsFederateInfoSetInputDelay(fi, inputDelay)

def helicsFederateInfoSetTimeOffset(fi: 'helics_federate_info_t', timeOffset: 'helics_time_t') -> "helics_status":
    """


    """
    return _helics.helicsFederateInfoSetTimeOffset(fi, timeOffset)

def helicsFederateInfoSetPeriod(fi: 'helics_federate_info_t', period: 'helics_time_t') -> "helics_status":
    """


    """
    return _helics.helicsFederateInfoSetPeriod(fi, period)

def helicsFederateInfoSetMaxIterations(fi: 'helics_federate_info_t', maxIterations: 'int') -> "helics_status":
    """


    """
    return _helics.helicsFederateInfoSetMaxIterations(fi, maxIterations)

def helicsFederateInfoSetLoggingLevel(fi: 'helics_federate_info_t', logLevel: 'int') -> "helics_status":
    """


    """
    return _helics.helicsFederateInfoSetLoggingLevel(fi, logLevel)

def helicsFederateFinalize(fed: 'helics_federate') -> "helics_status":
    """


    finalize the federate this halts all communication in the federate and
    disconnects it from the core

    """
    return _helics.helicsFederateFinalize(fed)

def helicsFederateFree(fed: 'helics_federate') -> "void":
    """


    release the memory associated withe a federate

    """
    return _helics.helicsFederateFree(fed)

def helicsCloseLibrary() -> "void":
    """


    call when done using the helics library, this function will ensure the threads
    are closed properly if possible this should be the last call before exiting,

    """
    return _helics.helicsCloseLibrary()

def helicsFederateEnterInitializationMode(fed: 'helics_federate') -> "helics_status":
    """


    enter the initialization state of a federate

    the initialization state allows initial values to be set and received if the
    iteration is requested on entry to the execution state This is a blocking call
    and will block until the core allows it to proceed

    """
    return _helics.helicsFederateEnterInitializationMode(fed)

def helicsFederateEnterInitializationModeAsync(fed: 'helics_federate') -> "helics_status":
    """


    non blocking alternative to  the function
    helicsFederateEnterInitializationModeFinalize must be called to finish the
    operation

    """
    return _helics.helicsFederateEnterInitializationModeAsync(fed)

def helicsFederateIsAsyncOperationCompleted(fed: 'helics_federate') -> "helics_bool_t":
    """


    check if the current Asynchronous operation has completed

    Parameters
    ----------
    * `fed` :
        the federate to operate on

    Returns
    -------
    0 if not completed, 1 if completed

    """
    return _helics.helicsFederateIsAsyncOperationCompleted(fed)

def helicsFederateEnterInitializationModeComplete(fed: 'helics_federate') -> "helics_status":
    """


    finalize the entry to initialize mode that was initiated with

    """
    return _helics.helicsFederateEnterInitializationModeComplete(fed)

def helicsFederateEnterExecutionMode(fed: 'helics_federate') -> "helics_status":
    """


    request that the federate enter the Execution mode

    this call is blocking until granted entry by the core object for an asynchronous
    alternative call /ref helicsFederateEnterExecutionModeAsync

    Parameters
    ----------
    * `fed` :
        a federate to change modes

    Returns
    -------
    a helics_status enumeration helics_error if something went wrong
    helicsInvalidReference if fed is invalid

    """
    return _helics.helicsFederateEnterExecutionMode(fed)

def helicsFederateEnterExecutionModeAsync(fed: 'helics_federate') -> "helics_status":
    """


    request that the federate enter the Execution mode

    this call is non-blocking and will return immediately call /ref
    helicsFederateEnterExecutionModeComplete to finish the call sequence /ref

    """
    return _helics.helicsFederateEnterExecutionModeAsync(fed)

def helicsFederateEnterExecutionModeComplete(fed: 'helics_federate') -> "helics_status":
    """


    complete the call to /ref EnterExecutionModeAsync

    Parameters
    ----------
    * `fed` :
        the federate object to complete the call

    """
    return _helics.helicsFederateEnterExecutionModeComplete(fed)

def helicsFederateEnterExecutionModeIterative(fed: 'helics_federate', iterate: 'helics_iteration_request') -> "helics_iteration_status *":
    """


    """
    return _helics.helicsFederateEnterExecutionModeIterative(fed, iterate)

def helicsFederateEnterExecutionModeIterativeAsync(fed: 'helics_federate', iterate: 'helics_iteration_request') -> "helics_status":
    """


    """
    return _helics.helicsFederateEnterExecutionModeIterativeAsync(fed, iterate)

def helicsFederateEnterExecutionModeIterativeComplete(fed: 'helics_federate') -> "helics_iteration_status *":
    """


    """
    return _helics.helicsFederateEnterExecutionModeIterativeComplete(fed)

def helicsFederateGetState(fed: 'helics_federate') -> "federate_state *":
    """


    get the current state of a federate

    Parameters
    ----------
    * `fed` :
        the fed to query
    * `state` :
        the resulting state if helics_status return helics_ok

    """
    return _helics.helicsFederateGetState(fed)

def helicsFederateGetCoreObject(fed: 'helics_federate') -> "helics_core":
    """


    get the core object associated with a federate

    Parameters
    ----------
    * `fed` :
        a federate object

    Returns
    -------
    a core object, nullptr if invalid

    """
    return _helics.helicsFederateGetCoreObject(fed)

def helicsFederateRequestTime(fed: 'helics_federate', requestTime: 'helics_time_t') -> "helics_time_t *":
    """


    request the next time for federate execution

    Parameters
    ----------
    * `fed` :
        the federate to make the request of
    * `requestTime` :
        the next requested time
    * `timeOut` :
        the time granted to the federate

    Returns
    -------
    a helics_status if the return value is equal to helics_ok the timeOut will
    contain the new granted time, otherwise timeOut is invalid

    """
    return _helics.helicsFederateRequestTime(fed, requestTime)

def helicsFederateRequestTimeIterative(fed: 'helics_federate', requestTime: 'helics_time_t', iterate: 'helics_iteration_request') -> "helics_time_t *, helics_iteration_status *":
    """


    request an iterative time

    this call allows for finer grain control of the iterative process then /ref
    helicsFederateRequestTime it takes a time and and iteration request and return a
    time and iteration status

    Parameters
    ----------
    * `fed` :
        the federate to make the request of
    * `requestTime` :
        the next desired time
    * `iterate` :
        the requested iteration mode
    * `timeOut` :
        the granted time
    * `outIterate` :
        the iteration specification of the result

    Returns
    -------
    a helics_status object with a return code of the result

    """
    return _helics.helicsFederateRequestTimeIterative(fed, requestTime, iterate)

def helicsFederateRequestTimeAsync(fed: 'helics_federate', requestTime: 'helics_time_t') -> "helics_status":
    """


    """
    return _helics.helicsFederateRequestTimeAsync(fed, requestTime)

def helicsFederateRequestTimeComplete(fed: 'helics_federate') -> "helics_time_t *":
    """


    """
    return _helics.helicsFederateRequestTimeComplete(fed)

def helicsFederateRequestTimeIterativeAsync(fed: 'helics_federate', requestTime: 'helics_time_t', iterate: 'helics_iteration_request') -> "helics_status":
    """


    """
    return _helics.helicsFederateRequestTimeIterativeAsync(fed, requestTime, iterate)

def helicsFederateRequestTimeIterativeComplete(fed: 'helics_federate') -> "helics_time_t *, helics_iteration_status *":
    """


    """
    return _helics.helicsFederateRequestTimeIterativeComplete(fed)

def helicsFederateGetName(fed: 'helics_federate') -> "int":
    """


    get the name of the federate

    Parameters
    ----------
    * `fed` :
        the federate object to query
    * `str` :
        memory buffer to store the result
    * `maxlen` :
        the maximum size of the buffer

    Returns
    -------
    helics_status object indicating success or error

    """
    return _helics.helicsFederateGetName(fed)

def helicsFederateSetTimeDelta(fed: 'helics_federate', time: 'helics_time_t') -> "helics_status":
    """


    set the minimum time delta for the federate

    Parameters
    ----------
    * `tdelta` :
        the minimum time delta to return from a time request function

    """
    return _helics.helicsFederateSetTimeDelta(fed, time)

def helicsFederateSetOutputDelay(fed: 'helics_federate', outputDelay: 'helics_time_t') -> "helics_status":
    """


    set the look ahead time

    the look ahead is the propagation time for messages/event to propagate from the
    Federate the federate

    Parameters
    ----------
    * `lookAhead` :
        the look ahead time

    """
    return _helics.helicsFederateSetOutputDelay(fed, outputDelay)

def helicsFederateSetInputDelay(fed: 'helics_federate', inputDelay: 'helics_time_t') -> "helics_status":
    """


    set the impact Window time

    the impact window is the time window around the time request in which other
    federates cannot affect the federate

    Parameters
    ----------
    * `lookAhead` :
        the look ahead time

    """
    return _helics.helicsFederateSetInputDelay(fed, inputDelay)

def helicsFederateSetPeriod(fed: 'helics_federate', period: 'helics_time_t', offset: 'helics_time_t') -> "helics_status":
    """


    set the period and offset of the federate

    the federate will on grant time on N*period+offset interval

    Parameters
    ----------
    * `period` :
        the length of time between each subsequent grants
    * `offset` :
        the shift of the period from 0 offset must be < period

    """
    return _helics.helicsFederateSetPeriod(fed, period, offset)

def helicsFederateSetFlag(fed: 'helics_federate', flag: 'int', flagValue: 'helics_bool_t') -> "helics_status":
    """


    set a flag for the federate

    Parameters
    ----------
    * `fed` :
        the federate to alter a flag for
    * `flag` :
        the flag to change
    * `flagValue` :
        the new value of the flag 0 for false !=0 for true

    """
    return _helics.helicsFederateSetFlag(fed, flag, flagValue)

def helicsFederateSetSeparator(fed: 'helics_federate', separator: 'char') -> "helics_status":
    return _helics.helicsFederateSetSeparator(fed, separator)
helicsFederateSetSeparator = _helics.helicsFederateSetSeparator

def helicsFederateSetLoggingLevel(fed: 'helics_federate', loggingLevel: 'int') -> "helics_status":
    """


    set the logging level for the federate @ details debug and trace only do
    anything if they were enabled in the compilation

    Parameters
    ----------
    * `loggingLevel` :
        (-1: none, 0: error_only, 1: warnings, 2: normal, 3: debug, 4: trace)

    """
    return _helics.helicsFederateSetLoggingLevel(fed, loggingLevel)

def helicsFederateSetMaxIterations(fi: 'helics_federate', maxIterations: 'int') -> "helics_status":
    return _helics.helicsFederateSetMaxIterations(fi, maxIterations)
helicsFederateSetMaxIterations = _helics.helicsFederateSetMaxIterations

def helicsFederateGetCurrentTime(fed: 'helics_federate') -> "helics_time_t *":
    """


    get the current time of the federate

    Parameters
    ----------
    * `fed` :
        the federate object to query
    * `time` :
        storage location for the time variable

    Returns
    -------
    helics_status object indicating success or error

    """
    return _helics.helicsFederateGetCurrentTime(fed)

def helicsCreateQuery(target: 'char const *', query: 'char const *') -> "helics_query":
    """


    create a query object

    a query object consists of a target and query string

    """
    return _helics.helicsCreateQuery(target, query)

def helicsQueryExecute(query: 'helics_query', fed: 'helics_federate') -> "char const *":
    """


    Execute a query

    the call will block until the query finishes which may require communication or
    other delays

    Parameters
    ----------
    * `query` :
        the query object to use in the query
    * `fed` :
        a federate to send the query through

    Returns
    -------
    a pointer to a string. the string will remain valid until the query is freed or
    executed again the return will be nullptr if fed or query is an invalid object

    """
    return _helics.helicsQueryExecute(query, fed)

def helicsQueryCoreExecute(query: 'helics_query', core: 'helics_core') -> "char const *":
    return _helics.helicsQueryCoreExecute(query, core)
helicsQueryCoreExecute = _helics.helicsQueryCoreExecute

def helicsQueryBrokerExecute(query: 'helics_query', broker: 'helics_broker') -> "char const *":
    return _helics.helicsQueryBrokerExecute(query, broker)
helicsQueryBrokerExecute = _helics.helicsQueryBrokerExecute

def helicsQueryExecuteAsync(query: 'helics_query', fed: 'helics_federate') -> "helics_status":
    """


    Execute a query in a non-blocking call

    Parameters
    ----------
    * `query` :
        the query object to use in the query
    * `fed` :
        a federate to send the query through

    Returns
    -------
    a helics status enumeration with the result of the query specification

    """
    return _helics.helicsQueryExecuteAsync(query, fed)

def helicsQueryExecuteComplete(query: 'helics_query') -> "char const *":
    """


    complete the return from a query called with /ref helicsExecuteQueryAsync

    the function will block until the query completes /ref isQueryComplete can be
    called to determine if a query has completed or not

    Parameters
    ----------
    * `query` :
        the query object to

    Returns
    -------
    a pointer to a string. the string will remain valid until the query is freed or
    executed again the return will be nullptr if query is an invalid object

    """
    return _helics.helicsQueryExecuteComplete(query)

def helicsQueryIsCompleted(query: 'helics_query') -> "helics_bool_t":
    """


    check if an asynchronously executed query has completed

    Returns
    -------
    will return helics_true if an async query has complete or a regular query call
    was made with a result and false if an async query has not completed or is
    invalid

    """
    return _helics.helicsQueryIsCompleted(query)

def helicsQueryFree(arg1: 'helics_query') -> "void":
    """


    free the memory associated with a query object

    """
    return _helics.helicsQueryFree(arg1)

def helicsCleanupHelicsLibrary() -> "void":
    return _helics.helicsCleanupHelicsLibrary()
helicsCleanupHelicsLibrary = _helics.helicsCleanupHelicsLibrary
HELICS_DATA_TYPE_STRING = _helics.HELICS_DATA_TYPE_STRING
HELICS_DATA_TYPE_DOUBLE = _helics.HELICS_DATA_TYPE_DOUBLE
HELICS_DATA_TYPE_INT = _helics.HELICS_DATA_TYPE_INT
HELICS_DATA_TYPE_COMPLEX = _helics.HELICS_DATA_TYPE_COMPLEX
HELICS_DATA_TYPE_VECTOR = _helics.HELICS_DATA_TYPE_VECTOR
HELICS_DATA_TYPE_NAMEDPOINT = _helics.HELICS_DATA_TYPE_NAMEDPOINT
HELICS_DATA_TYPE_BOOLEAN = _helics.HELICS_DATA_TYPE_BOOLEAN
HELICS_DATA_TYPE_RAW = _helics.HELICS_DATA_TYPE_RAW

def helicsFederateRegisterSubscription(fed: 'helics_federate', key: 'char const *', type: 'char const *', units: 'char const *') -> "helics_subscription":
    """


    create a subscription

    the subscription becomes part of the federate and is destroyed when the federate
    is freed so there are no separate free functions for subscriptions and
    publications

    Parameters
    ----------
    * `fed` :
        the federate object in which to create a subscription must have been create
        with helicsCreateValueFederate or helicsCreateCombinationFederate
    * `key` :
        the identifier matching a publication to get a subscription for
    * `type` :
        a string describing the expected type of the publication may be NULL
    * `units` :
        a string listing the units of the subscription maybe NULL

    Returns
    -------
    an object containing the subscription

    """
    return _helics.helicsFederateRegisterSubscription(fed, key, type, units)

def helicsFederateRegisterTypeSubscription(fed: 'helics_federate', key: 'char const *', type: 'int', units: 'char const *') -> "helics_subscription":
    """


    create a subscription of a specific known type

    the subscription becomes part of the federate and is destroyed when the federate
    is freed so there are no separate free functions for subscriptions and
    publications

    Parameters
    ----------
    * `fed` :
        the federate object in which to create a subscription
    * `key` :
        the identifier matching a publication to get a subscription for
    * `type` :
        a known type identifier HELICS_STRING_TYPE, HELICS_INT_TYPE,
        HELICS_DOUBLE_TYPE, HELICS_COMPLEX_TYPE, HELICS_VECTOR_TYPE, HELICS_RAW_TYPE
    * `units` :
        a string listing the units of the subscription maybe NULL

    Returns
    -------
    an object containing the subscription

    """
    return _helics.helicsFederateRegisterTypeSubscription(fed, key, type, units)

def helicsFederateRegisterOptionalSubscription(fed: 'helics_federate', key: 'char const *', type: 'char const *', units: 'char const *') -> "helics_subscription":
    """


    create a subscription that is specifically stated to be optional

    the subscription becomes part of the federate and is destroyed when the federate
    is freed so there are no separate free functions for subscriptions and
    publications

    optional implies that there may or may not be matching publication elsewhere in
    the federation

    Parameters
    ----------
    * `fed` :
        the federate object in which to create a subscription
    * `key` :
        the identifier matching a publication to get a subscription for
    * `type` :
        a string describing the expected type of the publication may be NULL
    * `units` :
        a string listing the units of the subscription maybe NULL

    Returns
    -------
    an object containing the subscription

    """
    return _helics.helicsFederateRegisterOptionalSubscription(fed, key, type, units)

def helicsFederateRegisterOptionalTypeSubscription(fed: 'helics_federate', key: 'char const *', type: 'int', units: 'char const *') -> "helics_subscription":
    """


    create a subscription of a specific known type that is specifically stated to be
    optional

    the subscription becomes part of the federate and is destroyed when the federate
    is freed so there are no separate free functions for subscriptions and
    publications optional implies that there may or may not be matching publication
    elsewhere in the federation

    Parameters
    ----------
    * `fed` :
        the federate object in which to create a subscription
    * `key` :
        the identifier matching a publication to get a subscription for
    * `type` :
        a known type identifier HELICS_STRING_TYPE, HELICS_INT_TYPE,
        HELICS_DOUBLE_TYPE, HELICS_COMPLEX_TYPE, HELICS_VECTOR_TYPE, HELICS_RAW_TYPE
    * `units` :
        a string listing the units of the subscription maybe NULL

    Returns
    -------
    an object containing the subscription

    """
    return _helics.helicsFederateRegisterOptionalTypeSubscription(fed, key, type, units)

def helicsFederateRegisterPublication(fed: 'helics_federate', key: 'char const *', type: 'char const *', units: 'char const *') -> "helics_publication":
    """


    """
    return _helics.helicsFederateRegisterPublication(fed, key, type, units)

def helicsFederateRegisterTypePublication(fed: 'helics_federate', key: 'char const *', type: 'int', units: 'char const *') -> "helics_publication":
    """


    """
    return _helics.helicsFederateRegisterTypePublication(fed, key, type, units)

def helicsFederateRegisterGlobalPublication(fed: 'helics_federate', key: 'char const *', type: 'char const *', units: 'char const *') -> "helics_publication":
    """


    """
    return _helics.helicsFederateRegisterGlobalPublication(fed, key, type, units)

def helicsFederateRegisterGlobalTypePublication(fed: 'helics_federate', key: 'char const *', type: 'int', units: 'char const *') -> "helics_publication":
    """


    """
    return _helics.helicsFederateRegisterGlobalTypePublication(fed, key, type, units)

def helicsPublicationPublishRaw(pub: 'helics_publication', data: 'void const *') -> "int":
    return _helics.helicsPublicationPublishRaw(pub, data)
helicsPublicationPublishRaw = _helics.helicsPublicationPublishRaw

def helicsPublicationPublishString(pub: 'helics_publication', str: 'char const *') -> "helics_status":
    """


    """
    return _helics.helicsPublicationPublishString(pub, str)

def helicsPublicationPublishInteger(pub: 'helics_publication', val: 'int64_t') -> "helics_status":
    """


    """
    return _helics.helicsPublicationPublishInteger(pub, val)

def helicsPublicationPublishBoolean(pub: 'helics_publication', val: 'helics_bool_t') -> "helics_status":
    return _helics.helicsPublicationPublishBoolean(pub, val)
helicsPublicationPublishBoolean = _helics.helicsPublicationPublishBoolean

def helicsPublicationPublishDouble(pub: 'helics_publication', val: 'double') -> "helics_status":
    """


    """
    return _helics.helicsPublicationPublishDouble(pub, val)

def helicsPublicationPublishComplex(pub: 'helics_publication', real: 'double', imag: 'double') -> "helics_status":
    """


    """
    return _helics.helicsPublicationPublishComplex(pub, real, imag)

def helicsPublicationPublishVector(pub: 'helics_publication', vectorInput: 'double const *') -> "int":
    """


    """
    return _helics.helicsPublicationPublishVector(pub, vectorInput)

def helicsPublicationPublishNamedPoint(pub: 'helics_publication', str: 'char const *', val: 'double') -> "helics_status":
    return _helics.helicsPublicationPublishNamedPoint(pub, str, val)
helicsPublicationPublishNamedPoint = _helics.helicsPublicationPublishNamedPoint

def helicsSubscriptionGetValueSize(sub: 'helics_subscription') -> "int":
    """


    """
    return _helics.helicsSubscriptionGetValueSize(sub)

def helicsSubscriptionGetRawValue(sub: 'helics_subscription', data: 'void *', maxlen: 'int') -> "int *":
    return _helics.helicsSubscriptionGetRawValue(sub, data, maxlen)
helicsSubscriptionGetRawValue = _helics.helicsSubscriptionGetRawValue

def helicsSubscriptionGetStringSize(sub: 'helics_subscription') -> "int":
    return _helics.helicsSubscriptionGetStringSize(sub)
helicsSubscriptionGetStringSize = _helics.helicsSubscriptionGetStringSize

def helicsSubscriptionGetString(sub: 'helics_subscription') -> "int *":
    """


    """
    return _helics.helicsSubscriptionGetString(sub)

def helicsSubscriptionGetInteger(sub: 'helics_subscription') -> "int64_t *":
    """


    """
    return _helics.helicsSubscriptionGetInteger(sub)

def helicsSubscriptionGetBoolean(sub: 'helics_subscription') -> "int *":
    return _helics.helicsSubscriptionGetBoolean(sub)
helicsSubscriptionGetBoolean = _helics.helicsSubscriptionGetBoolean

def helicsSubscriptionGetDouble(sub: 'helics_subscription') -> "double *":
    """


    """
    return _helics.helicsSubscriptionGetDouble(sub)

def helicsSubscriptionGetComplex(sub: 'helics_subscription') -> "double *, double *":
    """


    """
    return _helics.helicsSubscriptionGetComplex(sub)

def helicsSubscriptionGetVectorSize(sub: 'helics_subscription') -> "int":
    """


    """
    return _helics.helicsSubscriptionGetVectorSize(sub)

def helicsSubscriptionGetVector(sub: 'helics_subscription') -> "int *":
    """


    get a vector from a subscription

    Parameters
    ----------
    * `sub` :
        the subscription to get the result for
    * `data` :
        the location to store the data
    * `maxlen` :
        the maximum size of the vector
    * `actualSize` :
        pointer to variable to store the actual size

    """
    return _helics.helicsSubscriptionGetVector(sub)

def helicsSubscriptionGetNamedPoint(sub: 'helics_subscription') -> "int *, double *":
    return _helics.helicsSubscriptionGetNamedPoint(sub)
helicsSubscriptionGetNamedPoint = _helics.helicsSubscriptionGetNamedPoint

def helicsSubscriptionSetDefaultRaw(sub: 'helics_subscription', data: 'void const *') -> "int":
    return _helics.helicsSubscriptionSetDefaultRaw(sub, data)
helicsSubscriptionSetDefaultRaw = _helics.helicsSubscriptionSetDefaultRaw

def helicsSubscriptionSetDefaultString(sub: 'helics_subscription', str: 'char const *') -> "helics_status":
    """


    """
    return _helics.helicsSubscriptionSetDefaultString(sub, str)

def helicsSubscriptionSetDefaultInteger(sub: 'helics_subscription', val: 'int64_t') -> "helics_status":
    """


    """
    return _helics.helicsSubscriptionSetDefaultInteger(sub, val)

def helicsSubscriptionSetDefaultBoolean(sub: 'helics_subscription', val: 'helics_bool_t') -> "helics_status":
    return _helics.helicsSubscriptionSetDefaultBoolean(sub, val)
helicsSubscriptionSetDefaultBoolean = _helics.helicsSubscriptionSetDefaultBoolean

def helicsSubscriptionSetDefaultDouble(sub: 'helics_subscription', val: 'double') -> "helics_status":
    """


    """
    return _helics.helicsSubscriptionSetDefaultDouble(sub, val)

def helicsSubscriptionSetDefaultComplex(sub: 'helics_subscription', real: 'double', imag: 'double') -> "helics_status":
    """


    """
    return _helics.helicsSubscriptionSetDefaultComplex(sub, real, imag)

def helicsSubscriptionSetDefaultVector(sub: 'helics_subscription', vectorInput: 'double const *') -> "int":
    """


    """
    return _helics.helicsSubscriptionSetDefaultVector(sub, vectorInput)

def helicsSubscriptionSetDefaultNamedPoint(sub: 'helics_subscription', str: 'char const *', val: 'double') -> "helics_status":
    return _helics.helicsSubscriptionSetDefaultNamedPoint(sub, str, val)
helicsSubscriptionSetDefaultNamedPoint = _helics.helicsSubscriptionSetDefaultNamedPoint

def helicsSubscriptionGetType(sub: 'helics_subscription') -> "int":
    """


    """
    return _helics.helicsSubscriptionGetType(sub)

def helicsPublicationGetType(pub: 'helics_publication') -> "int":
    """


    """
    return _helics.helicsPublicationGetType(pub)

def helicsSubscriptionGetKey(sub: 'helics_subscription') -> "int":
    """


    """
    return _helics.helicsSubscriptionGetKey(sub)

def helicsPublicationGetKey(pub: 'helics_publication') -> "int":
    """


    """
    return _helics.helicsPublicationGetKey(pub)

def helicsSubscriptionGetUnits(sub: 'helics_subscription') -> "int":
    """


    """
    return _helics.helicsSubscriptionGetUnits(sub)

def helicsPublicationGetUnits(pub: 'helics_publication') -> "int":
    """


    """
    return _helics.helicsPublicationGetUnits(pub)

def helicsSubscriptionIsUpdated(sub: 'helics_subscription') -> "helics_bool_t":
    """


    """
    return _helics.helicsSubscriptionIsUpdated(sub)

def helicsSubscriptionLastUpdateTime(sub: 'helics_subscription') -> "helics_time_t":
    """


    """
    return _helics.helicsSubscriptionLastUpdateTime(sub)

def helicsFederateGetPublicationCount(fed: 'helics_federate') -> "int":
    return _helics.helicsFederateGetPublicationCount(fed)
helicsFederateGetPublicationCount = _helics.helicsFederateGetPublicationCount

def helicsFederateGetSubscriptionCount(fed: 'helics_federate') -> "int":
    return _helics.helicsFederateGetSubscriptionCount(fed)
helicsFederateGetSubscriptionCount = _helics.helicsFederateGetSubscriptionCount

def helicsFederateRegisterEndpoint(fed: 'helics_federate', name: 'char const *', type: 'char const *') -> "helics_endpoint":
    """


    """
    return _helics.helicsFederateRegisterEndpoint(fed, name, type)

def helicsFederateRegisterGlobalEndpoint(fed: 'helics_federate', name: 'char const *', type: 'char const *') -> "helics_endpoint":
    """


    """
    return _helics.helicsFederateRegisterGlobalEndpoint(fed, name, type)

def helicsEndpointSetDefaultDestination(endpoint: 'helics_endpoint', dest: 'char const *') -> "helics_status":
    """


    """
    return _helics.helicsEndpointSetDefaultDestination(endpoint, dest)

def helicsEndpointSendMessageRaw(endpoint: 'helics_endpoint', dest: 'char const *', data: 'void const *') -> "int":
    """


    """
    return _helics.helicsEndpointSendMessageRaw(endpoint, dest, data)

def helicsEndpointSendEventRaw(endpoint: 'helics_endpoint', dest: 'char const *', data: 'void const *', time: 'helics_time_t') -> "int":
    """


    """
    return _helics.helicsEndpointSendEventRaw(endpoint, dest, data, time)

def helicsEndpointSendMessage(endpoint: 'helics_endpoint', message: 'message_t') -> "helics_status":
    """


    """
    return _helics.helicsEndpointSendMessage(endpoint, message)

def helicsEndpointSubscribe(endpoint: 'helics_endpoint', key: 'char const *', type: 'char const *') -> "helics_status":
    """


    subscribe an endpoint to a publication

    Parameters
    ----------
    * `endpoint` :
        the endpoint to use
    * `key` :
        the name of the publication
    * `type` :
        the type of the publication that is expected (nullptr or "" for DON'T
        CARE)

    """
    return _helics.helicsEndpointSubscribe(endpoint, key, type)

def helicsFederateHasMessage(fed: 'helics_federate') -> "helics_bool_t":
    """


    check if the federate has any outstanding messages

    """
    return _helics.helicsFederateHasMessage(fed)

def helicsEndpointHasMessage(endpoint: 'helics_endpoint') -> "helics_bool_t":
    """


    """
    return _helics.helicsEndpointHasMessage(endpoint)

def helicsFederateReceiveCount(fed: 'helics_federate') -> "int":
    """


    Returns the number of pending receives for the specified destination endpoint.

    """
    return _helics.helicsFederateReceiveCount(fed)

def helicsEndpointReceiveCount(endpoint: 'helics_endpoint') -> "int":
    """


    Returns the number of pending receives for all endpoints of particular federate.

    """
    return _helics.helicsEndpointReceiveCount(endpoint)

def helicsEndpointGetMessage(endpoint: 'helics_endpoint') -> "message_t":
    """


    receive a packet from a particular endpoint

    Parameters
    ----------
    * `endpoint` :
        the identifier for the endpoint

    Returns
    -------
    a message object

    """
    return _helics.helicsEndpointGetMessage(endpoint)

def helicsFederateGetMessage(fed: 'helics_federate') -> "message_t":
    """


    receive a communication message for any endpoint in the federate

    the return order will be in order of endpoint creation then order of arrival all
    messages for the first endpoint, then all for the second, and so on

    Returns
    -------
    a unique_ptr to a Message object containing the message data

    """
    return _helics.helicsFederateGetMessage(fed)

def helicsEndpointGetType(endpoint: 'helics_endpoint') -> "int":
    """


    get the type specified for an endpoint

    Parameters
    ----------
    * `endpoint` :
        the endpoint object in question
    * `str` :
        the location where the string is stored
    * `maxlen` :
        the maximum string length that can be stored in str

    Returns
    -------
    a status variable

    """
    return _helics.helicsEndpointGetType(endpoint)

def helicsEndpointGetName(endpoint: 'helics_endpoint') -> "int":
    """


    get the name of an endpoint

    Parameters
    ----------
    * `endpoint` :
        the endpoint object in question
    * `str` :
        the location where the string is stored
    * `maxlen` :
        the maximum string length that can be stored in str

    Returns
    -------
    a status variable

    """
    return _helics.helicsEndpointGetName(endpoint)

def helicsFederateGetEndpointCount(fed: 'helics_federate') -> "int":
    return _helics.helicsFederateGetEndpointCount(fed)
helicsFederateGetEndpointCount = _helics.helicsFederateGetEndpointCount

def helicsFederateRegisterSourceFilter(fed: 'helics_federate', type: 'helics_filter_type_t', target: 'char const *', name: 'char const *') -> "helics_filter":
    """


    create a source Filter on the specified federate

    filters can be created through a federate or a core , linking through a federate
    allows a few extra features of name matching to function on the federate
    interface but otherwise equivalent behavior

    Parameters
    ----------
    * `fed` :
        the fed to register through
    * `name` :
        the name of the filter (can be nullptr)
    * `inputType` :
        the input type of the filter, used for ordering (can be nullptr)
    * `outputType` :
        the output type of the filter, used for ordering (can be nullptr)

    Returns
    -------
    a helics_source_filter object

    """
    return _helics.helicsFederateRegisterSourceFilter(fed, type, target, name)

def helicsFederateRegisterDestinationFilter(fed: 'helics_federate', type: 'helics_filter_type_t', target: 'char const *', name: 'char const *') -> "helics_filter":
    """


    """
    return _helics.helicsFederateRegisterDestinationFilter(fed, type, target, name)

def helicsFederateRegisterCloningFilter(fed: 'helics_federate', deliveryEndpoint: 'char const *') -> "helics_filter":
    """


    """
    return _helics.helicsFederateRegisterCloningFilter(fed, deliveryEndpoint)

def helicsCoreRegisterSourceFilter(core: 'helics_core', type: 'helics_filter_type_t', target: 'char const *', name: 'char const *') -> "helics_filter":
    """


    """
    return _helics.helicsCoreRegisterSourceFilter(core, type, target, name)

def helicsCoreRegisterDestinationFilter(core: 'helics_core', type: 'helics_filter_type_t', target: 'char const *', name: 'char const *') -> "helics_filter":
    """


    """
    return _helics.helicsCoreRegisterDestinationFilter(core, type, target, name)

def helicsCoreRegisterCloningFilter(core: 'helics_core', deliveryEndpoint: 'char const *') -> "helics_filter":
    """


    """
    return _helics.helicsCoreRegisterCloningFilter(core, deliveryEndpoint)

def helicsFilterGetTarget(filt: 'helics_filter') -> "int":
    """


    get the target of the filter

    """
    return _helics.helicsFilterGetTarget(filt)

def helicsFilterGetName(filt: 'helics_filter') -> "int":
    """


    get the name of the filter

    """
    return _helics.helicsFilterGetName(filt)

def helicsFilterSet(filt: 'helics_filter', property: 'char const *', val: 'double') -> "helics_status":
    """


    """
    return _helics.helicsFilterSet(filt, property, val)

def helicsFilterSetString(filt: 'helics_filter', property: 'char const *', val: 'char const *') -> "helics_status":
    return _helics.helicsFilterSetString(filt, property, val)
helicsFilterSetString = _helics.helicsFilterSetString

def helicsFilterAddDestinationTarget(filt: 'helics_filter', dest: 'char const *') -> "helics_status":
    """


    """
    return _helics.helicsFilterAddDestinationTarget(filt, dest)

def helicsFilterAddSourceTarget(filt: 'helics_filter', source: 'char const *') -> "helics_status":
    """


    """
    return _helics.helicsFilterAddSourceTarget(filt, source)

def helicsFilterAddDeliveryEndpoint(filt: 'helics_filter', deliveryEndpoint: 'char const *') -> "helics_status":
    """


    """
    return _helics.helicsFilterAddDeliveryEndpoint(filt, deliveryEndpoint)

def helicsFilterRemoveDestinationTarget(filt: 'helics_filter', dest: 'char const *') -> "helics_status":
    """


    """
    return _helics.helicsFilterRemoveDestinationTarget(filt, dest)

def helicsFilterRemoveSourceTarget(filt: 'helics_filter', source: 'char const *') -> "helics_status":
    """


    """
    return _helics.helicsFilterRemoveSourceTarget(filt, source)

def helicsFilterRemoveDeliveryEndpoint(filt: 'helics_filter', deliveryEndpoint: 'char const *') -> "helics_status":
    """


    """
    return _helics.helicsFilterRemoveDeliveryEndpoint(filt, deliveryEndpoint)
# This file is compatible with both classic and new-style classes.


