
import argh
import json

#!!! This is a hack to allow testing of this CLT without
#!!! re-installing great_expectations every time there's an edit
import sys
import os
import os.path
dir_path = os.path.dirname(os.path.realpath(__file__))
sys.path.append(dir_path+'/..')

import great_expectations as ge

def initialize():
	raise NotImplementedError()

@argh.arg('data_set')
@argh.arg('expectations_config_file')
@argh.arg('--output_format', '-o', default="SUMMARY")
@argh.arg('--catch_exceptions', '-e', default=True)
@argh.arg('--include_config', '-n', default=None)
@argh.arg('--only_return_failures', '-f', default=False)
@argh.arg('--custom_dataset_module', '-m', default=None)
@argh.arg('--custom_dataset_class', '-c', default=None)
def validate(data_set, expectations_config_file, **kwargs):

	if kwargs["include_config"]:
		if kwargs["include_config"] == "True":
			kwargs["include_config"] = True
		elif kwargs["include_config"] == "False":
			kwargs["include_config"] = False
		else:
			raise ValueError("includ_config expects None, True, or False. Got "+kwargs["include_config"]+" instead.")

	expectations_config = json.load(open(expectations_config_file))

	if kwargs["custom_dataset_module"]:
		sys.path.insert(0, os.path.dirname(kwargs["custom_dataset_module"]))
		module_name = os.path.basename(kwargs["custom_dataset_module"]).split('.')[0]
		custom_module = __import__(module_name)
		dataset_class = getattr(custom_module, kwargs["custom_dataset_class"])

	else:
		dataset_class = ge.dataset.PandasDataSet

	df = ge.read_csv(data_set, expectations_config=expectations_config, dataset_class=dataset_class)

	result = df.validate(
		output_format=kwargs["output_format"],
		catch_exceptions=kwargs["catch_exceptions"],
		include_config=kwargs["include_config"],
		only_return_failures=kwargs["only_return_failures"],
	)

	print(json.dumps(result, indent=2))

argh.dispatch_commands([
	initialize,
	validate,
])