# -*- coding: utf-8 -*-

import logging
from typing import Any

from great_expectations.core.batch import BatchDefinition
from great_expectations.datasource.data_connector.sorter.sorter import Sorter

logger = logging.getLogger(__name__)


class LexicographicSorter(Sorter):
    def get_partition_key(self, batch_definition: BatchDefinition) -> Any:
        partition_definition: dict = batch_definition.partition_definition
        partition_value: Any = partition_definition[self.name]
        return partition_value

    def __repr__(self) -> str:
        doc_fields_dict: dict = {
            "name": self.name,
            "reverse": self.reverse,
            "type": "LexicographicSorter",
        }
        return str(doc_fields_dict)
