/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot;

import java.util.Optional;
import java.util.stream.Stream;
import org.gradle.internal.snapshot.CaseSensitivity;
import org.gradle.internal.snapshot.VfsRelativePath;

public interface ChildMap<T> {
    public boolean isEmpty();

    public Stream<Entry<T>> stream();

    public <RESULT> RESULT withNode(VfsRelativePath var1, CaseSensitivity var2, NodeHandler<T, RESULT> var3);

    public <RESULT> ChildMap<RESULT> invalidate(VfsRelativePath var1, CaseSensitivity var2, InvalidationHandler<T, RESULT> var3);

    public ChildMap<T> store(VfsRelativePath var1, CaseSensitivity var2, StoreHandler<T> var3);

    public static class Entry<T> {
        private final String path;
        private final T value;

        public Entry(String path, T value) {
            this.path = path;
            this.value = value;
        }

        public <RESULT> RESULT withNode(VfsRelativePath targetPath, CaseSensitivity caseSensitivity, NodeHandler<T, RESULT> handler) {
            return (RESULT)this.handleAncestorDescendantOrExactMatch(targetPath, caseSensitivity, handler).orElseGet(handler::handleUnrelatedToAnyChild);
        }

        public <RESULT> Optional<RESULT> handleAncestorDescendantOrExactMatch(VfsRelativePath targetPath, CaseSensitivity caseSensitivity, NodeHandler<T, RESULT> handler) {
            if (targetPath.hasPrefix(this.path, caseSensitivity)) {
                if (targetPath.length() == this.path.length()) {
                    return Optional.of(handler.handleExactMatchWithChild(this.value));
                }
                return Optional.of(handler.handleAsDescendantOfChild(targetPath.fromChild(this.path), this.value));
            }
            if (targetPath.length() < this.path.length() && targetPath.isPrefixOf(this.path, caseSensitivity)) {
                return Optional.of(handler.handleAsAncestorOfChild(this.path, this.value));
            }
            return Optional.empty();
        }

        public <RESULT> RESULT handlePath(VfsRelativePath targetPath, CaseSensitivity caseSensitivity, PathRelationshipHandler<RESULT, T> handler) {
            int pathToParentLength = this.path.length();
            int targetPathLength = targetPath.length();
            int maxPos = Math.min(pathToParentLength, targetPathLength);
            int commonPrefixLength = targetPath.lengthOfCommonPrefix(this.path, caseSensitivity);
            if (commonPrefixLength == maxPos) {
                if (pathToParentLength > targetPathLength) {
                    return handler.handleAsAncestorOfChild(targetPath, this.path, this.value);
                }
                if (pathToParentLength == targetPathLength) {
                    return handler.handleExactMatchWithChild(targetPath, this.path, this.value);
                }
                return handler.handleAsDescendantOfChild(targetPath, this.path, this.value);
            }
            if (commonPrefixLength == 0) {
                return handler.handleUnrelatedToAnyChild(targetPath);
            }
            return handler.handleSiblingOfChild(targetPath, this.path, this.value, commonPrefixLength);
        }

        public String getPath() {
            return this.path;
        }

        public T getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry entry = (Entry)o;
            if (!this.path.equals(entry.path)) {
                return false;
            }
            return this.value.equals(entry.value);
        }

        public int hashCode() {
            int result = this.path.hashCode();
            result = 31 * result + this.value.hashCode();
            return result;
        }

        public String toString() {
            return "Entry{" + this.path + " : " + this.value + '}';
        }

        public static interface PathRelationshipHandler<RESULT, T> {
            public RESULT handleAsDescendantOfChild(VfsRelativePath var1, String var2, T var3);

            public RESULT handleAsAncestorOfChild(VfsRelativePath var1, String var2, T var3);

            public RESULT handleExactMatchWithChild(VfsRelativePath var1, String var2, T var3);

            public RESULT handleSiblingOfChild(VfsRelativePath var1, String var2, T var3, int var4);

            public RESULT handleUnrelatedToAnyChild(VfsRelativePath var1);
        }
    }

    public static interface StoreHandler<T> {
        public T handleAsDescendantOfChild(VfsRelativePath var1, T var2);

        public T handleAsAncestorOfChild(String var1, T var2);

        public T mergeWithExisting(T var1);

        public T createChild();

        public T createNodeFromChildren(ChildMap<T> var1);
    }

    public static interface InvalidationHandler<T, RESULT> {
        public Optional<RESULT> handleAsDescendantOfChild(VfsRelativePath var1, T var2);

        public void handleAsAncestorOfChild(String var1, T var2);

        public void handleExactMatchWithChild(T var1);

        public void handleUnrelatedToAnyChild();
    }

    public static interface NodeHandler<T, RESULT> {
        public RESULT handleAsDescendantOfChild(VfsRelativePath var1, T var2);

        public RESULT handleAsAncestorOfChild(String var1, T var2);

        public RESULT handleExactMatchWithChild(T var1);

        public RESULT handleUnrelatedToAnyChild();
    }
}

