/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationArgumentVisitor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.Flags;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.constants.AnnotationValue;
import org.jetbrains.kotlin.resolve.constants.ArrayValue;
import org.jetbrains.kotlin.resolve.constants.BooleanValue;
import org.jetbrains.kotlin.resolve.constants.ByteValue;
import org.jetbrains.kotlin.resolve.constants.CharValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.DoubleValue;
import org.jetbrains.kotlin.resolve.constants.EnumValue;
import org.jetbrains.kotlin.resolve.constants.ErrorValue;
import org.jetbrains.kotlin.resolve.constants.FloatValue;
import org.jetbrains.kotlin.resolve.constants.IntValue;
import org.jetbrains.kotlin.resolve.constants.KClassValue;
import org.jetbrains.kotlin.resolve.constants.LongValue;
import org.jetbrains.kotlin.resolve.constants.NullValue;
import org.jetbrains.kotlin.resolve.constants.ShortValue;
import org.jetbrains.kotlin.resolve.constants.StringValue;
import org.jetbrains.kotlin.resolve.constants.UByteValue;
import org.jetbrains.kotlin.resolve.constants.UIntValue;
import org.jetbrains.kotlin.resolve.constants.ULongValue;
import org.jetbrains.kotlin.resolve.constants.UShortValue;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.serialization.DescriptorAwareStringTable;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0010\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0012\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/serialization/AnnotationSerializer;", "", "stringTable", "Lorg/jetbrains/kotlin/serialization/DescriptorAwareStringTable;", "(Lorg/jetbrains/kotlin/serialization/DescriptorAwareStringTable;)V", "ignoreAnnotation", "", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "serializeAnnotation", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Annotation;", "annotation", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "valueProto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Annotation$Argument$Value$Builder;", "constant", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "serialization"})
public class AnnotationSerializer {
    @NotNull
    private final DescriptorAwareStringTable stringTable;

    public AnnotationSerializer(@NotNull DescriptorAwareStringTable stringTable) {
        Intrinsics.checkNotNullParameter((Object)stringTable, (String)"stringTable");
        this.stringTable = stringTable;
    }

    @Nullable
    public final ProtoBuf.Annotation serializeAnnotation(@NotNull AnnotationDescriptor annotation2) {
        Intrinsics.checkNotNullParameter((Object)annotation2, (String)"annotation");
        ProtoBuf.Annotation.Builder builder2 = ProtoBuf.Annotation.newBuilder();
        boolean bl = false;
        boolean bl2 = false;
        ProtoBuf.Annotation.Builder $this$serializeAnnotation_u24lambda_u2d0 = builder2;
        boolean bl3 = false;
        Object object = DescriptorUtilsKt.getAnnotationClass(annotation2);
        if (object == null) {
            String string2 = Intrinsics.stringPlus((String)"Annotation type is not a class: ", (Object)annotation2.getType());
            boolean bl4 = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        Object annotationClass = object;
        if (ErrorUtils.isError((DeclarationDescriptor)annotationClass)) {
            if (this.ignoreAnnotation(annotation2.getType())) {
                return null;
            }
            object = "Unresolved annotation type: " + annotation2.getType() + " at " + annotation2.getSource().getContainingFile();
            boolean bl5 = false;
            throw (Throwable)new IllegalStateException(object.toString());
        }
        $this$serializeAnnotation_u24lambda_u2d0.setId(this.stringTable.getFqNameIndex((ClassifierDescriptorWithTypeParameters)annotationClass));
        Object object2 = annotation2.getAllValueArguments();
        boolean bl6 = false;
        object = object2.entrySet().iterator();
        while (object.hasNext()) {
            Object object3 = object2 = (Map.Entry)object.next();
            boolean bl7 = false;
            Name name = (Name)object3.getKey();
            Object object4 = object2;
            boolean bl8 = false;
            ConstantValue value2 = (ConstantValue)object4.getValue();
            ProtoBuf.Annotation.Argument.Builder argument2 = ProtoBuf.Annotation.Argument.newBuilder();
            String string3 = name.asString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"name.asString()");
            argument2.setNameId(this.stringTable.getStringIndex(string3));
            argument2.setValue(this.valueProto(value2));
            $this$serializeAnnotation_u24lambda_u2d0.addArgument(argument2);
        }
        return builder2.build();
    }

    @NotNull
    public final ProtoBuf.Annotation.Argument.Value.Builder valueProto(@NotNull ConstantValue<?> constant) {
        Intrinsics.checkNotNullParameter(constant, (String)"constant");
        ProtoBuf.Annotation.Argument.Value.Builder builder2 = ProtoBuf.Annotation.Argument.Value.newBuilder();
        boolean bl = false;
        boolean bl2 = false;
        ProtoBuf.Annotation.Argument.Value.Builder $this$valueProto_u24lambda_u2d1 = builder2;
        boolean bl3 = false;
        constant.accept(new AnnotationArgumentVisitor<Unit, Unit>($this$valueProto_u24lambda_u2d1, this){
            final /* synthetic */ ProtoBuf.Annotation.Argument.Value.Builder $this_apply;
            final /* synthetic */ AnnotationSerializer this$0;
            {
                this.$this_apply = $receiver;
                this.this$0 = $receiver2;
            }

            public void visitAnnotationValue(@NotNull AnnotationValue value2, @NotNull Unit data) {
                Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                this.$this_apply.setType(ProtoBuf.Annotation.Argument.Value.Type.ANNOTATION);
                this.$this_apply.setAnnotation(this.this$0.serializeAnnotation((AnnotationDescriptor)value2.getValue()));
            }

            public void visitArrayValue(@NotNull ArrayValue value2, @NotNull Unit data) {
                Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                this.$this_apply.setType(ProtoBuf.Annotation.Argument.Value.Type.ARRAY);
                for (ConstantValue element : (List)value2.getValue()) {
                    this.$this_apply.addArrayElement(this.this$0.valueProto(element).build());
                }
            }

            public void visitBooleanValue(@NotNull BooleanValue value2, @NotNull Unit data) {
                Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                this.$this_apply.setType(ProtoBuf.Annotation.Argument.Value.Type.BOOLEAN);
                this.$this_apply.setIntValue((Boolean)value2.getValue() != false ? 1L : 0L);
            }

            public void visitByteValue(@NotNull ByteValue value2, @NotNull Unit data) {
                Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                this.$this_apply.setType(ProtoBuf.Annotation.Argument.Value.Type.BYTE);
                this.$this_apply.setIntValue(((Number)value2.getValue()).byteValue());
            }

            public void visitCharValue(@NotNull CharValue value2, @NotNull Unit data) {
                Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                this.$this_apply.setType(ProtoBuf.Annotation.Argument.Value.Type.CHAR);
                char c = ((Character)value2.getValue()).charValue();
                boolean bl = false;
                this.$this_apply.setIntValue(c);
            }

            public void visitDoubleValue(@NotNull DoubleValue value2, @NotNull Unit data) {
                Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                this.$this_apply.setType(ProtoBuf.Annotation.Argument.Value.Type.DOUBLE);
                this.$this_apply.setDoubleValue(((Number)value2.getValue()).doubleValue());
            }

            public void visitEnumValue(@NotNull EnumValue value2, @NotNull Unit data) {
                Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                this.$this_apply.setType(ProtoBuf.Annotation.Argument.Value.Type.ENUM);
                this.$this_apply.setClassId(AnnotationSerializer.access$getStringTable$p(this.this$0).getQualifiedClassNameIndex(value2.getEnumClassId()));
                DescriptorAwareStringTable descriptorAwareStringTable = AnnotationSerializer.access$getStringTable$p(this.this$0);
                String string2 = value2.getEnumEntryName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"value.enumEntryName.asString()");
                this.$this_apply.setEnumValueId(descriptorAwareStringTable.getStringIndex(string2));
            }

            public void visitErrorValue(@NotNull ErrorValue value2, @NotNull Unit data) {
                Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                throw new UnsupportedOperationException(Intrinsics.stringPlus((String)"Error value: ", (Object)value2));
            }

            public void visitFloatValue(@NotNull FloatValue value2, @NotNull Unit data) {
                Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                this.$this_apply.setType(ProtoBuf.Annotation.Argument.Value.Type.FLOAT);
                this.$this_apply.setFloatValue(((Number)value2.getValue()).floatValue());
            }

            public void visitIntValue(@NotNull IntValue value2, @NotNull Unit data) {
                Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                this.$this_apply.setType(ProtoBuf.Annotation.Argument.Value.Type.INT);
                this.$this_apply.setIntValue(((Number)value2.getValue()).intValue());
            }

            public void visitKClassValue(@NotNull KClassValue value2, @NotNull Unit data) {
                Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                this.$this_apply.setType(ProtoBuf.Annotation.Argument.Value.Type.CLASS);
                KClassValue.Value classValue = (KClassValue.Value)value2.getValue();
                if (classValue instanceof KClassValue.Value.NormalClass) {
                    this.$this_apply.setClassId(AnnotationSerializer.access$getStringTable$p(this.this$0).getQualifiedClassNameIndex(((KClassValue.Value.NormalClass)classValue).getClassId()));
                    if (((KClassValue.Value.NormalClass)classValue).getArrayDimensions() > 0) {
                        this.$this_apply.setArrayDimensionCount(((KClassValue.Value.NormalClass)classValue).getArrayDimensions());
                    }
                } else if (classValue instanceof KClassValue.Value.LocalClass) {
                    ClassDescriptor classDescriptor;
                    int arrayDimensions = 0;
                    KotlinType type2 = ((KClassValue.Value.LocalClass)classValue).getType();
                    while (KotlinBuiltIns.isArray(type2)) {
                        int n = arrayDimensions;
                        arrayDimensions = n + 1;
                        KotlinType kotlinType = ((TypeProjection)CollectionsKt.single(type2.getArguments())).getType();
                        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"type.arguments.single().type");
                        type2 = kotlinType;
                    }
                    Object object = type2.getConstructor().getDeclarationDescriptor();
                    ClassDescriptor classDescriptor2 = classDescriptor = object instanceof ClassDescriptor ? (ClassDescriptor)object : null;
                    if (classDescriptor == null) {
                        object = Intrinsics.stringPlus((String)"Type parameters are not allowed in class literal annotation arguments: ", (Object)classValue);
                        boolean bl = false;
                        throw (Throwable)new IllegalStateException(object.toString());
                    }
                    ClassDescriptor descriptor2 = classDescriptor;
                    this.$this_apply.setClassId(AnnotationSerializer.access$getStringTable$p(this.this$0).getFqNameIndex(descriptor2));
                    if (arrayDimensions > 0) {
                        this.$this_apply.setArrayDimensionCount(arrayDimensions);
                    }
                }
            }

            public void visitLongValue(@NotNull LongValue value2, @NotNull Unit data) {
                Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                this.$this_apply.setType(ProtoBuf.Annotation.Argument.Value.Type.LONG);
                this.$this_apply.setIntValue(((Number)value2.getValue()).longValue());
            }

            public void visitNullValue(@NotNull NullValue value2, @NotNull Unit data) {
                Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                throw new UnsupportedOperationException("Null should not appear in annotation arguments");
            }

            public void visitShortValue(@NotNull ShortValue value2, @NotNull Unit data) {
                Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                this.$this_apply.setType(ProtoBuf.Annotation.Argument.Value.Type.SHORT);
                this.$this_apply.setIntValue(((Number)value2.getValue()).shortValue());
            }

            public void visitStringValue(@NotNull StringValue value2, @NotNull Unit data) {
                Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                this.$this_apply.setType(ProtoBuf.Annotation.Argument.Value.Type.STRING);
                this.$this_apply.setStringValue(AnnotationSerializer.access$getStringTable$p(this.this$0).getStringIndex((String)value2.getValue()));
            }

            public void visitUByteValue(@NotNull UByteValue value2, @Nullable Unit data) {
                Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                this.$this_apply.setType(ProtoBuf.Annotation.Argument.Value.Type.BYTE);
                this.$this_apply.setIntValue(((Number)value2.getValue()).byteValue());
                this.$this_apply.setFlags(Flags.IS_UNSIGNED.toFlags(true));
            }

            public void visitUShortValue(@NotNull UShortValue value2, @Nullable Unit data) {
                Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                this.$this_apply.setType(ProtoBuf.Annotation.Argument.Value.Type.SHORT);
                this.$this_apply.setIntValue(((Number)value2.getValue()).shortValue());
                this.$this_apply.setFlags(Flags.IS_UNSIGNED.toFlags(true));
            }

            public void visitUIntValue(@NotNull UIntValue value2, @Nullable Unit data) {
                Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                this.$this_apply.setType(ProtoBuf.Annotation.Argument.Value.Type.INT);
                this.$this_apply.setIntValue(((Number)value2.getValue()).intValue());
                this.$this_apply.setFlags(Flags.IS_UNSIGNED.toFlags(true));
            }

            public void visitULongValue(@NotNull ULongValue value2, @Nullable Unit data) {
                Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                this.$this_apply.setType(ProtoBuf.Annotation.Argument.Value.Type.LONG);
                this.$this_apply.setIntValue(((Number)value2.getValue()).longValue());
                this.$this_apply.setFlags(Flags.IS_UNSIGNED.toFlags(true));
            }
        }, Unit.INSTANCE);
        ProtoBuf.Annotation.Argument.Value.Builder builder3 = builder2;
        Intrinsics.checkNotNullExpressionValue((Object)builder3, (String)"newBuilder().apply {\n   \u2026 }\n        }, Unit)\n    }");
        return builder3;
    }

    protected boolean ignoreAnnotation(@NotNull KotlinType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        return false;
    }

    public static final /* synthetic */ DescriptorAwareStringTable access$getStringTable$p(AnnotationSerializer $this) {
        return $this.stringTable;
    }
}

