/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.stack;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.interpreter.CompoundInstruction;
import org.jetbrains.kotlin.ir.interpreter.Instruction;
import org.jetbrains.kotlin.ir.interpreter.InstructionsUnfolderKt;
import org.jetbrains.kotlin.ir.interpreter.SimpleInstruction;
import org.jetbrains.kotlin.ir.interpreter.stack.Frame;
import org.jetbrains.kotlin.ir.interpreter.stack.SubFrame;
import org.jetbrains.kotlin.ir.interpreter.stack.Variable;
import org.jetbrains.kotlin.ir.interpreter.state.State;
import org.jetbrains.kotlin.ir.interpreter.state.StateWithClosure;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u000eJ\u0006\u0010\u0019\u001a\u00020\u000eJ\u0006\u0010\u001a\u001a\u00020\u000eJ\u0006\u0010\u001b\u001a\u00020\u000eJ\u0006\u0010\u001c\u001a\u00020\u000eJ\u0006\u0010\u001d\u001a\u00020\u001eJ\u0006\u0010\u001f\u001a\u00020 J\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001e0\"J\u000e\u0010#\u001a\u00020$2\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010%\u001a\u00020\u0015J\u000e\u0010&\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020(J\u001a\u0010)\u001a\u00020\u000e2\u0006\u0010*\u001a\u00020\b2\n\b\u0002\u0010+\u001a\u0004\u0018\u00010,J\u000e\u0010)\u001a\u00020\u000e2\u0006\u0010*\u001a\u00020-J\u000e\u0010.\u001a\u00020\u000e2\u0006\u0010*\u001a\u00020\bJ\b\u0010/\u001a\u0004\u0018\u00010$J\u0006\u00100\u001a\u00020\u0010J\u0006\u00101\u001a\u00020$J\u000e\u00102\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020$J\u000e\u00103\u001a\u00020\u000e2\u0006\u00104\u001a\u000205J\u0016\u00106\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u00107\u001a\u00020$J\u000e\u00108\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020(J\u000e\u00109\u001a\u00020\u000e2\u0006\u0010:\u001a\u00020;R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/stack/CallStack;", "", "()V", "currentFrame", "Lorg/jetbrains/kotlin/ir/interpreter/stack/Frame;", "getCurrentFrame", "()Lorg/jetbrains/kotlin/ir/interpreter/stack/Frame;", "currentFrameOwner", "Lorg/jetbrains/kotlin/ir/IrElement;", "getCurrentFrameOwner$ir_interpreter", "()Lorg/jetbrains/kotlin/ir/IrElement;", "frames", "", "addInstruction", "", "instruction", "Lorg/jetbrains/kotlin/ir/interpreter/Instruction;", "addVariable", "variable", "Lorg/jetbrains/kotlin/ir/interpreter/stack/Variable;", "containsVariable", "", "symbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "copyUpValuesFromPreviousFrame", "dropFrame", "dropFrameAndCopyResult", "dropFramesUntilTryCatch", "dropSubFrame", "getFileAndPositionInfo", "", "getStackCount", "", "getStackTrace", "", "getState", "Lorg/jetbrains/kotlin/ir/interpreter/state/State;", "hasNoInstructions", "loadUpValues", "state", "Lorg/jetbrains/kotlin/ir/interpreter/state/StateWithClosure;", "newFrame", "frameOwner", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "newSubFrame", "peekState", "popInstruction", "popState", "pushState", "returnFromFrameWithResult", "irReturn", "Lorg/jetbrains/kotlin/ir/expressions/IrReturn;", "setState", "newState", "storeUpValues", "unrollInstructionsForBreakContinue", "breakOrContinue", "Lorg/jetbrains/kotlin/ir/expressions/IrBreakContinue;", "ir.interpreter"})
public final class CallStack {
    @NotNull
    private final List<Frame> frames;

    public CallStack() {
        boolean bl = false;
        this.frames = new ArrayList();
    }

    private final Frame getCurrentFrame() {
        return (Frame)CollectionsKt.last(this.frames);
    }

    @NotNull
    public final IrElement getCurrentFrameOwner$ir_interpreter() {
        return this.getCurrentFrame().getCurrentSubFrameOwner();
    }

    public final void newFrame(@NotNull IrElement frameOwner, @Nullable IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)frameOwner, (String)"frameOwner");
        SubFrame newFrame2 = new SubFrame(frameOwner);
        this.frames.add(new Frame(newFrame2, irFile));
    }

    public static /* synthetic */ void newFrame$default(CallStack callStack, IrElement irElement, IrFile irFile, int n, Object object) {
        if ((n & 2) != 0) {
            irFile = null;
        }
        callStack.newFrame(irElement, irFile);
    }

    public final void newFrame(@NotNull IrFunction frameOwner) {
        Intrinsics.checkNotNullParameter((Object)frameOwner, (String)"frameOwner");
        SubFrame newFrame2 = new SubFrame(frameOwner);
        this.frames.add(new Frame(newFrame2, IrUtilsKt.getFileOrNull(frameOwner)));
    }

    public final void newSubFrame(@NotNull IrElement frameOwner) {
        Intrinsics.checkNotNullParameter((Object)frameOwner, (String)"frameOwner");
        SubFrame newFrame2 = new SubFrame(frameOwner);
        this.getCurrentFrame().addSubFrame(newFrame2);
    }

    public final void dropFrame() {
        CollectionsKt.removeLast(this.frames);
    }

    public final void dropFrameAndCopyResult() {
        State state = this.peekState();
        if (state == null) {
            this.dropFrame();
            return;
        }
        State result2 = state;
        this.popState();
        this.dropFrame();
        this.pushState(result2);
    }

    public final void dropSubFrame() {
        this.getCurrentFrame().removeSubFrame();
    }

    public final void returnFromFrameWithResult(@NotNull IrReturn irReturn) {
        Intrinsics.checkNotNullParameter((Object)irReturn, (String)"irReturn");
        State result2 = this.popState();
        IrElement frameOwner = this.getCurrentFrameOwner$ir_interpreter();
        while (!Intrinsics.areEqual((Object)frameOwner, (Object)irReturn.getReturnTargetSymbol().getOwner())) {
            IrElement irElement = frameOwner;
            if (irElement instanceof IrTry) {
                this.dropSubFrame();
                this.pushState(result2);
                this.addInstruction(new SimpleInstruction(irReturn));
                IrExpression irExpression = ((IrTry)frameOwner).getFinallyExpression();
                if (irExpression != null) {
                    InstructionsUnfolderKt.handleAndDropResult$default(irExpression, this, false, 2, null);
                }
                return;
            }
            if (irElement instanceof IrCatch) {
                Instruction instruction = this.getCurrentFrame().dropInstructions();
                Intrinsics.checkNotNull((Object)instruction);
                IrElement irElement2 = instruction.getElement();
                if (irElement2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrTry");
                }
                IrTry tryBlock = (IrTry)irElement2;
                this.dropSubFrame();
                this.pushState(result2);
                this.addInstruction(new SimpleInstruction(irReturn));
                irElement2 = tryBlock.getFinallyExpression();
                if (irElement2 != null) {
                    InstructionsUnfolderKt.handleAndDropResult$default((IrExpression)irElement2, this, false, 2, null);
                }
                return;
            }
            this.dropSubFrame();
            if (this.getCurrentFrame().hasNoSubFrames() && !Intrinsics.areEqual((Object)frameOwner, (Object)irReturn.getReturnTargetSymbol().getOwner())) {
                this.dropFrame();
            }
            frameOwner = this.getCurrentFrameOwner$ir_interpreter();
        }
        this.dropFrame();
        if (this.frames.size() == 0) {
            CallStack.newFrame$default(this, irReturn, null, 2, null);
        }
        this.pushState(result2);
    }

    public final void unrollInstructionsForBreakContinue(@NotNull IrBreakContinue breakOrContinue) {
        IrElement irElement;
        Intrinsics.checkNotNullParameter((Object)breakOrContinue, (String)"breakOrContinue");
        IrElement frameOwner = this.getCurrentFrameOwner$ir_interpreter();
        while (!Intrinsics.areEqual((Object)frameOwner, (Object)breakOrContinue.getLoop())) {
            irElement = frameOwner;
            if (irElement instanceof IrTry) {
                this.getCurrentFrame().removeSubFrameWithoutDataPropagation();
                this.addInstruction(new CompoundInstruction(breakOrContinue));
                this.newSubFrame(frameOwner);
                this.addInstruction(new SimpleInstruction(frameOwner));
                return;
            }
            if (irElement instanceof IrCatch) {
                Instruction instruction = this.getCurrentFrame().dropInstructions();
                Intrinsics.checkNotNull((Object)instruction);
                Instruction tryInstruction = instruction;
                this.getCurrentFrame().removeSubFrameWithoutDataPropagation();
                this.addInstruction(new CompoundInstruction(breakOrContinue));
                IrElement irElement2 = tryInstruction.getElement();
                Intrinsics.checkNotNull((Object)irElement2);
                this.newSubFrame(irElement2);
                this.addInstruction(tryInstruction);
                return;
            }
            this.getCurrentFrame().removeSubFrameWithoutDataPropagation();
            frameOwner = this.getCurrentFrameOwner$ir_interpreter();
        }
        irElement = breakOrContinue;
        if (irElement instanceof IrBreak) {
            this.getCurrentFrame().removeSubFrameWithoutDataPropagation();
        } else if (breakOrContinue.getLoop() instanceof IrDoWhileLoop) {
            this.addInstruction(new SimpleInstruction(breakOrContinue.getLoop()));
            this.addInstruction(new CompoundInstruction(breakOrContinue.getLoop().getCondition()));
        } else {
            this.addInstruction(new CompoundInstruction(breakOrContinue.getLoop()));
        }
    }

    public final void dropFramesUntilTryCatch() {
        State exception = this.popState();
        IrElement frameOwner = this.getCurrentFrameOwner$ir_interpreter();
        while (true) {
            Collection collection = this.frames;
            boolean bl = false;
            if (!(!collection.isEmpty())) break;
            Frame frame = this.getCurrentFrame();
            while (!frame.hasNoSubFrames()) {
                frameOwner = frame.getCurrentSubFrameOwner();
                IrElement irElement = frameOwner;
                if (irElement instanceof IrTry) {
                    this.dropSubFrame();
                    this.newSubFrame(frameOwner);
                    this.addInstruction(new SimpleInstruction(frameOwner));
                    Iterable $this$forEach$iv = CollectionsKt.reversed((Iterable)((IrTry)frameOwner).getCatches());
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        IrCatch it = (IrCatch)element$iv;
                        boolean bl2 = false;
                        this.addInstruction(new CompoundInstruction(it));
                    }
                    this.pushState(exception);
                    return;
                }
                if (irElement instanceof IrCatch) {
                    Instruction instruction = frame.dropInstructions();
                    Intrinsics.checkNotNull((Object)instruction);
                    this.addInstruction(instruction);
                    this.pushState(exception);
                    return;
                }
                frame.removeSubFrameWithoutDataPropagation();
            }
            this.dropFrame();
        }
        if (this.frames.size() == 0) {
            CallStack.newFrame$default(this, frameOwner, null, 2, null);
        }
        this.pushState(exception);
    }

    public final boolean hasNoInstructions() {
        return this.frames.isEmpty() || this.frames.size() == 1 && ((Frame)CollectionsKt.first(this.frames)).hasNoInstructions();
    }

    public final void addInstruction(@NotNull Instruction instruction) {
        Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
        this.getCurrentFrame().addInstruction(instruction);
    }

    @NotNull
    public final Instruction popInstruction() {
        return this.getCurrentFrame().popInstruction();
    }

    public final void pushState(@NotNull State state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.getCurrentFrame().pushState(state);
    }

    @NotNull
    public final State popState() {
        return this.getCurrentFrame().popState();
    }

    @Nullable
    public final State peekState() {
        return this.getCurrentFrame().peekState();
    }

    public final void addVariable(@NotNull Variable variable2) {
        Intrinsics.checkNotNullParameter((Object)variable2, (String)"variable");
        this.getCurrentFrame().addVariable(variable2);
    }

    @NotNull
    public final State getState(@NotNull IrSymbol symbol2) {
        Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
        return this.getCurrentFrame().getState(symbol2);
    }

    public final void setState(@NotNull IrSymbol symbol2, @NotNull State newState) {
        Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
        Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
        this.getCurrentFrame().setState(symbol2, newState);
    }

    public final boolean containsVariable(@NotNull IrSymbol symbol2) {
        Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
        return this.getCurrentFrame().containsVariable(symbol2);
    }

    public final void storeUpValues(@NotNull StateWithClosure state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        state.getUpValues().addAll(CollectionsKt.toMutableList((Collection)this.getCurrentFrame().getAll()));
    }

    public final void loadUpValues(@NotNull StateWithClosure state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Iterable $this$forEach$iv = state.getUpValues();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Variable it = (Variable)element$iv;
            boolean bl = false;
            this.addVariable(it);
        }
    }

    public final void copyUpValuesFromPreviousFrame() {
        Iterable $this$forEach$iv = this.frames.get(this.frames.size() - 2).getAll();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Variable it = (Variable)element$iv;
            boolean bl = false;
            if (this.containsVariable(it.getSymbol())) continue;
            this.addVariable(it);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getStackTrace() {
        void $this$filterTo$iv$iv;
        String it;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.frames;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Frame frame = (Frame)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string2 = ((Frame)((Object)it)).toString();
            collection.add(string2);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)it, (Object)"Not defined"))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final String getFileAndPositionInfo() {
        return this.frames.get(this.frames.size() - 2).getFileAndPositionInfo();
    }

    public final int getStackCount() {
        return this.frames.size();
    }
}

