/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal.scopes;

import java.io.File;
import org.gradle.cache.CacheBuilder;
import org.gradle.cache.CacheRepository;
import org.gradle.cache.internal.CacheScopeMapping;
import org.gradle.cache.internal.VersionStrategy;
import org.gradle.cache.internal.scopes.DefaultCacheScopeMapping;
import org.gradle.cache.scopes.ScopedCache;
import org.gradle.util.GradleVersion;

public abstract class AbstractScopedCache
implements ScopedCache {
    private final CacheScopeMapping cacheScopeMapping;
    private final CacheRepository cacheRepository;
    private final File rootDir;

    public AbstractScopedCache(File rootDir, CacheRepository cacheRepository) {
        this.rootDir = rootDir;
        this.cacheScopeMapping = new DefaultCacheScopeMapping(rootDir, GradleVersion.current());
        this.cacheRepository = cacheRepository;
    }

    protected CacheRepository getCacheRepository() {
        return this.cacheRepository;
    }

    @Override
    public File getRootDir() {
        return this.rootDir;
    }

    @Override
    public CacheBuilder cache(String key) {
        return this.cacheRepository.cache(this.baseDirForCache(key));
    }

    @Override
    public CacheBuilder crossVersionCache(String key) {
        return this.cacheRepository.cache(this.baseDirForCrossVersionCache(key));
    }

    @Override
    public File baseDirForCache(String key) {
        return this.cacheScopeMapping.getBaseDirectory(this.rootDir, key, VersionStrategy.CachePerVersion);
    }

    @Override
    public File baseDirForCrossVersionCache(String key) {
        return this.cacheScopeMapping.getBaseDirectory(this.rootDir, key, VersionStrategy.SharedCache);
    }
}

