/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.catalog;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Interner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.MutableVersionConstraint;
import org.gradle.api.attributes.Category;
import org.gradle.api.attributes.Usage;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.initialization.dsl.VersionCatalogBuilder;
import org.gradle.api.internal.artifacts.DependencyResolutionServices;
import org.gradle.api.internal.artifacts.ImmutableVersionConstraint;
import org.gradle.api.internal.artifacts.dependencies.DefaultImmutableVersionConstraint;
import org.gradle.api.internal.artifacts.dependencies.DefaultMutableVersionConstraint;
import org.gradle.api.internal.catalog.AliasNormalizer;
import org.gradle.api.internal.catalog.BundleModel;
import org.gradle.api.internal.catalog.DefaultVersionCatalog;
import org.gradle.api.internal.catalog.DependencyModel;
import org.gradle.api.internal.catalog.PluginModel;
import org.gradle.api.internal.catalog.VersionModel;
import org.gradle.api.internal.catalog.parser.DependenciesModelHelper;
import org.gradle.api.internal.catalog.parser.StrictVersionParser;
import org.gradle.api.internal.catalog.parser.TomlCatalogFileParser;
import org.gradle.api.internal.catalog.problems.DefaultCatalogProblemBuilder;
import org.gradle.api.internal.catalog.problems.VersionCatalogProblemBuilder;
import org.gradle.api.internal.catalog.problems.VersionCatalogProblemId;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.internal.FileUtils;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.lazy.Lazy;
import org.gradle.internal.management.VersionCatalogBuilderInternal;
import org.gradle.problems.internal.RenderingUtils;

public class DefaultVersionCatalogBuilder
implements VersionCatalogBuilderInternal {
    private static final Logger LOGGER = Logging.getLogger(DefaultVersionCatalogBuilder.class);
    private static final List<String> FORBIDDEN_LIBRARY_ALIAS_PREFIX = ImmutableList.of((Object)"bundles", (Object)"versions", (Object)"plugins");
    private static final Set<String> RESERVED_ALIAS_NAMES = ImmutableSet.of((Object)"extensions", (Object)"class", (Object)"convention");
    private final Interner<String> strings;
    private final Interner<ImmutableVersionConstraint> versionConstraintInterner;
    private final ObjectFactory objects;
    private final ProviderFactory providers;
    private final String name;
    private final Map<String, VersionModel> versionConstraints = Maps.newLinkedHashMap();
    private final Map<String, Supplier<DependencyModel>> libraries = Maps.newLinkedHashMap();
    private final Set<String> aliasesInProgress = Sets.newLinkedHashSet();
    private final Map<String, Supplier<PluginModel>> plugins = Maps.newLinkedHashMap();
    private final Map<String, BundleModel> bundles = Maps.newLinkedHashMap();
    private final Lazy<DefaultVersionCatalog> model = Lazy.unsafe().of(this::doBuild);
    private final Supplier<DependencyResolutionServices> dependencyResolutionServicesSupplier;
    private final List<Import> imports = Lists.newArrayList();
    private final StrictVersionParser strictVersionParser;
    private final Property<String> description;
    private String currentContext;

    @Inject
    public DefaultVersionCatalogBuilder(String name, Interner<String> strings, Interner<ImmutableVersionConstraint> versionConstraintInterner, ObjectFactory objects, ProviderFactory providers, Supplier<DependencyResolutionServices> dependencyResolutionServicesSupplier) {
        this.name = name;
        this.strings = strings;
        this.versionConstraintInterner = versionConstraintInterner;
        this.objects = objects;
        this.providers = providers;
        this.dependencyResolutionServicesSupplier = dependencyResolutionServicesSupplier;
        this.strictVersionParser = new StrictVersionParser(strings);
        this.description = objects.property(String.class).convention((Object)("A catalog of dependencies accessible via the `" + name + "` extension."));
    }

    public String getLibrariesExtensionName() {
        return this.name;
    }

    public Property<String> getDescription() {
        return this.description;
    }

    @Override
    public DefaultVersionCatalog build() {
        return (DefaultVersionCatalog)this.model.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void withContext(String context, Runnable action) {
        String oldContext = this.currentContext;
        this.currentContext = this.intern(context);
        try {
            action.run();
        }
        finally {
            this.currentContext = oldContext;
        }
    }

    private DefaultVersionCatalog doBuild() {
        this.maybeImportCatalogs();
        if (!this.aliasesInProgress.isEmpty()) {
            String alias = this.aliasesInProgress.iterator().next();
            return (DefaultVersionCatalog)this.throwVersionCatalogProblem(VersionCatalogProblemId.ALIAS_NOT_FINISHED, spec -> spec.withShortDescription(() -> "Dependency alias builder '" + alias + "' was not finished.").happensBecause("A version was not set or explicitly declared as not wanted").addSolution("Call `.version()` to give the alias a version").addSolution("Call `.withoutVersion()` to explicitly declare that the alias should not have a version").documented());
        }
        for (Map.Entry<String, BundleModel> entry : this.bundles.entrySet()) {
            String string = entry.getKey();
            List<String> aliases = entry.getValue().getComponents();
            for (String alias : aliases) {
                if (this.libraries.containsKey(alias)) continue;
                return (DefaultVersionCatalog)this.throwVersionCatalogProblem(VersionCatalogProblemId.UNDEFINED_ALIAS_REFERENCE, spec -> spec.withShortDescription(() -> "A bundle with name '" + bundleName + "' declares a dependency on '" + alias + "' which doesn't exist").happensBecause("Bundles can only contain references to existing library aliases").addSolution(() -> "Make sure that the library alias '" + alias + "' is declared").addSolution(() -> "Remove '" + alias + "' from bundle '" + bundleName + "'").documented());
            }
        }
        ImmutableMap.Builder realizedLibs = ImmutableMap.builderWithExpectedSize((int)this.libraries.size());
        for (Map.Entry<String, Supplier<DependencyModel>> entry : this.libraries.entrySet()) {
            realizedLibs.put((Object)entry.getKey(), (Object)entry.getValue().get());
        }
        ImmutableMap.Builder builder = ImmutableMap.builderWithExpectedSize((int)this.plugins.size());
        for (Map.Entry<String, Supplier<PluginModel>> entry : this.plugins.entrySet()) {
            builder.put((Object)entry.getKey(), (Object)entry.getValue().get());
        }
        return new DefaultVersionCatalog(this.name, (String)this.description.getOrElse((Object)""), (Map<String, DependencyModel>)realizedLibs.build(), (Map<String, BundleModel>)ImmutableMap.copyOf(this.bundles), (Map<String, VersionModel>)ImmutableMap.copyOf(this.versionConstraints), (Map<String, PluginModel>)builder.build());
    }

    private void maybeImportCatalogs() {
        if (this.imports.isEmpty()) {
            return;
        }
        DependencyResolutionServices drs = this.dependencyResolutionServicesSupplier.get();
        int importsSize = this.imports.size();
        for (int i = 0; i < importsSize; ++i) {
            Import importConfiguration = this.imports.get(i);
            Configuration cnf = this.createResolvableConfiguration(drs, i);
            this.addImportsToResolvableConfiguration(drs, cnf, importConfiguration);
            cnf.getIncoming().getArtifacts().getArtifacts().forEach(ar -> {
                File file = ar.getFile();
                this.withContext("catalog " + ar.getVariant().getOwner(), () -> this.importCatalogFromFile(file));
            });
        }
    }

    private void addImportsToResolvableConfiguration(DependencyResolutionServices drs, Configuration cnf, Import imported) {
        int importsSize = this.imports.size();
        for (int i = 0; i < importsSize; ++i) {
            Object notation = imported.notation;
            Dependency dependency = drs.getDependencyHandler().create(notation);
            cnf.getDependencies().add((Object)dependency);
        }
    }

    private Configuration createResolvableConfiguration(DependencyResolutionServices drs, int i) {
        Configuration cnf = (Configuration)drs.getConfigurationContainer().create("incomingCatalogFor" + StringUtils.capitalize((String)this.name) + i);
        cnf.getResolutionStrategy().activateDependencyLocking();
        cnf.attributes(attrs -> {
            attrs.attribute(Category.CATEGORY_ATTRIBUTE, (Object)((Category)this.objects.named(Category.class, "platform")));
            attrs.attribute(Usage.USAGE_ATTRIBUTE, (Object)((Usage)this.objects.named(Usage.class, "version-catalog")));
        });
        cnf.setCanBeResolved(true);
        cnf.setCanBeConsumed(false);
        return cnf;
    }

    public void from(Object dependencyNotation) {
        if (!this.imports.isEmpty()) {
            this.throwVersionCatalogProblem(VersionCatalogProblemId.MULTIPLE_IMPORTS, spec -> spec.withShortDescription("You can only import a single external catalog in a given catalog definition").happensBecause("Multiple catalog imports are not yet supported").addSolution("Create a separate catalog for each import you want to use").documentedAt("platforms", "sec:sharing-catalogs"));
        }
        this.imports.add(new Import(dependencyNotation));
    }

    private void importCatalogFromFile(File modelFile) {
        if (!FileUtils.hasExtensionIgnoresCase((String)modelFile.getName(), (String)"toml")) {
            this.throwVersionCatalogProblem(VersionCatalogProblemId.UNSUPPORTED_FILE_FORMAT, spec -> spec.withShortDescription(() -> "File " + modelFile.getName() + " isn't a supported").happensBecause("Only .toml files are allowed when importing catalogs").addSolution("Use a TOML file instead, with the .toml extension").documented());
        }
        if (!modelFile.exists()) {
            this.throwVersionCatalogProblem(VersionCatalogProblemId.CATALOG_FILE_DOES_NOT_EXIST, spec -> spec.withShortDescription(() -> "Import of external catalog file failed").happensBecause(() -> "File '" + modelFile + "' doesn't exist").addSolution(() -> "Make sure that the catalog file '" + modelFile.getName() + "' exists before importing it").documented());
        }
        RegularFileProperty srcProp = this.objects.fileProperty();
        srcProp.set(modelFile);
        Provider dataSource = this.providers.fileContents((Provider)srcProp).getAsBytes();
        try {
            TomlCatalogFileParser.parse((InputStream)new ByteArrayInputStream((byte[])dataSource.get()), (VersionCatalogBuilder)this);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public String version(String alias, Action<? super MutableVersionConstraint> versionSpec) {
        this.validateAlias(AliasType.VERSION, alias);
        alias = this.intern(AliasNormalizer.normalize(alias));
        if (this.versionConstraints.containsKey(alias)) {
            return alias;
        }
        DefaultMutableVersionConstraint versionBuilder = new DefaultMutableVersionConstraint("");
        versionSpec.execute((Object)versionBuilder);
        ImmutableVersionConstraint version = (ImmutableVersionConstraint)this.versionConstraintInterner.intern((Object)DefaultImmutableVersionConstraint.of(versionBuilder));
        this.versionConstraints.put(alias, new VersionModel(version, this.currentContext));
        return alias;
    }

    public String version(String alias, String version) {
        StrictVersionParser.RichVersion richVersion = this.strictVersionParser.parse(version);
        this.version(alias, (Action<? super MutableVersionConstraint>)((Action)vc -> {
            if (richVersion.require != null) {
                vc.require(richVersion.require);
            }
            if (richVersion.prefer != null) {
                vc.prefer(richVersion.prefer);
            }
            if (richVersion.strictly != null) {
                vc.strictly(richVersion.strictly);
            }
        }));
        return alias;
    }

    @Deprecated
    public VersionCatalogBuilder.AliasBuilder alias(String alias) {
        ((DeprecationMessageBuilder.DeprecateMethod)DeprecationLogger.deprecateMethod(VersionCatalogBuilder.class, (String)"alias(String)").withAdvice("Use one of the more specifically named methods (library or plugin) instead")).willBeRemovedInGradle8().withUpgradeGuideSection(7, "version_catalog_deprecations").nagUser();
        this.validateAlias(AliasType.ALIAS, alias);
        return new DefaultAliasBuilder(alias);
    }

    public VersionCatalogBuilder.LibraryAliasBuilder library(String alias, String group, String artifact) {
        this.validateAlias(AliasType.LIBRARY, alias);
        return new DefaultAliasBuilder(alias).to(group, artifact);
    }

    public void library(String alias, String groupArtifactVersion) {
        this.validateAlias(AliasType.LIBRARY, alias);
        new DefaultAliasBuilder(alias).to(groupArtifactVersion);
    }

    public VersionCatalogBuilder.PluginAliasBuilder plugin(String alias, String id) {
        this.validateAlias(AliasType.PLUGIN, alias);
        return new DefaultAliasBuilder(alias).toPluginId(id);
    }

    private void validateAlias(AliasType type, String value) {
        if (!DependenciesModelHelper.ALIAS_PATTERN.matcher(value).matches()) {
            this.throwVersionCatalogProblem(VersionCatalogProblemId.INVALID_ALIAS_NOTATION, spec -> spec.withShortDescription(() -> "Invalid " + (Object)((Object)type) + " alias '" + value + "'").happensBecause(() -> (Object)((Object)type) + " aliases must match the following regular expression: " + "[a-z]([a-zA-Z0-9_.\\-])+").addSolution(() -> "Make sure the alias matches the [a-z]([a-zA-Z0-9_.\\-])+ regular expression").documented());
        }
    }

    private <T> T throwVersionCatalogProblem(VersionCatalogProblemId id, Consumer<? super VersionCatalogProblemBuilder.ProblemWithId> spec) {
        DefaultCatalogProblemBuilder.maybeThrowError((String)"Invalid catalog definition", (List)ImmutableList.of((Object)DefaultCatalogProblemBuilder.buildProblem((VersionCatalogProblemId)id, pb -> spec.accept(pb.inContext(() -> "version catalog " + this.name)))));
        return null;
    }

    public void bundle(String alias, List<String> aliases) {
        this.validateAlias(AliasType.BUNDLE, alias);
        ImmutableList components = ImmutableList.copyOf((Collection)aliases.stream().map(AliasNormalizer::normalize).map(this::intern).collect(Collectors.toList()));
        BundleModel previous = this.bundles.put(AliasNormalizer.normalize(this.intern(alias)), new BundleModel((List<String>)components, this.currentContext));
        if (previous != null) {
            LOGGER.warn("Duplicate entry for bundle '{}': {} is replaced with {}", new Object[]{alias, previous.getComponents(), components});
        }
    }

    @Nullable
    private String intern(@Nullable String value) {
        if (value == null) {
            return null;
        }
        return (String)this.strings.intern((Object)value);
    }

    public boolean containsLibraryAlias(String name) {
        return this.libraries.containsKey(name);
    }

    public String getName() {
        return this.name;
    }

    private void createAliasWithVersionRef(String alias, String group, String name, String versionRef) {
        Supplier<DependencyModel> previous = this.libraries.put(this.intern(AliasNormalizer.normalize(alias)), new VersionReferencingDependencyModel(group, name, AliasNormalizer.normalize(versionRef)));
        if (previous != null) {
            LOGGER.warn("Duplicate entry for alias '{}': {} is replaced with {}", new Object[]{alias, previous.get(), this.model});
        }
    }

    private void createPluginAliasWithVersionRef(String alias, String id, String versionRef) {
        Supplier<PluginModel> previous = this.plugins.put(this.intern(AliasNormalizer.normalize(alias)), new VersionReferencingPluginModel(id, AliasNormalizer.normalize(versionRef)));
        if (previous != null) {
            LOGGER.warn("Duplicate entry for plugin '{}': {} is replaced with {}", new Object[]{alias, previous.get(), this.model});
        }
    }

    private static class Import {
        private final Object notation;

        private Import(Object notation) {
            this.notation = notation;
        }
    }

    public static class DefaultPluginAliasBuilder
    implements VersionCatalogBuilder.PluginAliasBuilder {
        private final DefaultVersionCatalogBuilder owner;
        private final String alias;
        private final String id;

        @Inject
        public DefaultPluginAliasBuilder(DefaultVersionCatalogBuilder owner, String alias, String id) {
            this.owner = owner;
            this.alias = alias;
            this.id = id;
        }

        public void version(Action<? super MutableVersionConstraint> versionSpec) {
            DefaultMutableVersionConstraint versionBuilder = new DefaultMutableVersionConstraint("");
            versionSpec.execute((Object)versionBuilder);
            this.owner.aliasesInProgress.remove(this.alias);
            ImmutableVersionConstraint version = (ImmutableVersionConstraint)this.owner.versionConstraintInterner.intern((Object)DefaultImmutableVersionConstraint.of(versionBuilder));
            PluginModel model = new PluginModel(this.owner.intern(this.id), null, version, this.owner.currentContext);
            Supplier<PluginModel> previous = this.owner.plugins.put(this.owner.intern(this.alias), () -> model);
            if (previous != null) {
                LOGGER.warn("Duplicate entry for plugin '{}': {} is replaced with {}", new Object[]{this.alias, previous.get(), model});
            }
        }

        public void version(String version) {
            StrictVersionParser.RichVersion richVersion = this.owner.strictVersionParser.parse(version);
            this.version((Action<? super MutableVersionConstraint>)((Action)vc -> {
                if (richVersion.require != null) {
                    vc.require(richVersion.require);
                }
                if (richVersion.prefer != null) {
                    vc.prefer(richVersion.prefer);
                }
                if (richVersion.strictly != null) {
                    vc.strictly(richVersion.strictly);
                }
            }));
        }

        public void versionRef(String versionRef) {
            this.owner.aliasesInProgress.remove(this.alias);
            this.owner.createPluginAliasWithVersionRef(this.alias, this.id, versionRef);
        }
    }

    public static class DefaultLibraryAliasBuilder
    implements VersionCatalogBuilder.LibraryAliasBuilder {
        private final DefaultVersionCatalogBuilder owner;
        private final String alias;
        private final String group;
        private final String name;

        @Inject
        public DefaultLibraryAliasBuilder(DefaultVersionCatalogBuilder owner, String alias, String group, String name) {
            this.owner = owner;
            this.alias = alias;
            this.group = group;
            this.name = name;
        }

        public void version(Action<? super MutableVersionConstraint> versionSpec) {
            DefaultMutableVersionConstraint versionBuilder = new DefaultMutableVersionConstraint("");
            versionSpec.execute((Object)versionBuilder);
            this.owner.aliasesInProgress.remove(this.alias);
            ImmutableVersionConstraint version = (ImmutableVersionConstraint)this.owner.versionConstraintInterner.intern((Object)DefaultImmutableVersionConstraint.of(versionBuilder));
            DependencyModel model = new DependencyModel(this.owner.intern(this.group), this.owner.intern(this.name), null, version, this.owner.currentContext);
            Supplier<DependencyModel> previous = this.owner.libraries.put(this.owner.intern(this.alias), () -> model);
            if (previous != null) {
                LOGGER.warn("Duplicate entry for alias '{}': {} is replaced with {}", new Object[]{this.alias, previous.get(), model});
            }
        }

        public void version(String version) {
            StrictVersionParser.RichVersion richVersion = this.owner.strictVersionParser.parse(version);
            this.version((Action<? super MutableVersionConstraint>)((Action)vc -> {
                if (richVersion.require != null) {
                    vc.require(richVersion.require);
                }
                if (richVersion.prefer != null) {
                    vc.prefer(richVersion.prefer);
                }
                if (richVersion.strictly != null) {
                    vc.strictly(richVersion.strictly);
                }
            }));
        }

        public void versionRef(String versionRef) {
            this.owner.aliasesInProgress.remove(this.alias);
            this.owner.createAliasWithVersionRef(this.alias, this.group, this.name, versionRef);
        }

        public void withoutVersion() {
            this.version("");
        }
    }

    private class DefaultAliasBuilder
    implements VersionCatalogBuilder.AliasBuilder {
        private final String alias;
        private final String normalizedAlias;

        public DefaultAliasBuilder(String alias) {
            this.alias = alias;
            this.normalizedAlias = AliasNormalizer.normalize(alias);
            if (!DefaultVersionCatalogBuilder.this.aliasesInProgress.add(this.normalizedAlias)) {
                LOGGER.warn("Duplicate alias builder registered for {}", (Object)this.normalizedAlias);
            }
        }

        public void to(String gavCoordinates) {
            this.validateAlias(AliasType.LIBRARY);
            String[] coordinates = gavCoordinates.split(":");
            if (coordinates.length == 3) {
                ((DefaultLibraryAliasBuilder)DefaultVersionCatalogBuilder.this.objects.newInstance(DefaultLibraryAliasBuilder.class, new Object[]{DefaultVersionCatalogBuilder.this, this.normalizedAlias, coordinates[0], coordinates[1]})).version(coordinates[2]);
            } else {
                DefaultVersionCatalogBuilder.this.throwVersionCatalogProblem(VersionCatalogProblemId.INVALID_DEPENDENCY_NOTATION, spec -> spec.withShortDescription(() -> "On alias '" + this.alias + "' notation '" + gavCoordinates + "' is not a valid dependency notation").happensBecause(() -> "The 'to(String)' method only supports 'group:artifact:version' coordinates").addSolution("Make sure that the coordinates consist of 3 parts separated by colons, eg: my.group:artifact:1.2").addSolution("Use the to(group, name) method instead").documented());
            }
        }

        public VersionCatalogBuilder.LibraryAliasBuilder to(String group, String name) {
            this.validateAlias(AliasType.LIBRARY);
            return (VersionCatalogBuilder.LibraryAliasBuilder)DefaultVersionCatalogBuilder.this.objects.newInstance(DefaultLibraryAliasBuilder.class, new Object[]{DefaultVersionCatalogBuilder.this, this.normalizedAlias, group, name});
        }

        public VersionCatalogBuilder.PluginAliasBuilder toPluginId(String id) {
            this.validateAlias(AliasType.PLUGIN);
            return (VersionCatalogBuilder.PluginAliasBuilder)DefaultVersionCatalogBuilder.this.objects.newInstance(DefaultPluginAliasBuilder.class, new Object[]{DefaultVersionCatalogBuilder.this, this.normalizedAlias, id});
        }

        private void validateAlias(AliasType type) {
            if (type == AliasType.LIBRARY) {
                for (String prefix : FORBIDDEN_LIBRARY_ALIAS_PREFIX) {
                    if (!this.normalizedAlias.equals(prefix) && !this.normalizedAlias.startsWith(prefix + ".")) continue;
                    DefaultVersionCatalogBuilder.this.throwVersionCatalogProblem(VersionCatalogProblemId.RESERVED_ALIAS_NAME, spec -> spec.withShortDescription(() -> "Alias '" + this.alias + "' is not a valid alias").happensBecause(() -> "Prefix for dependency shouldn't be equal to '" + prefix + "'").addSolution(() -> "Use a different alias which prefix is not equal to " + RenderingUtils.oxfordListOf((Collection)FORBIDDEN_LIBRARY_ALIAS_PREFIX, (String)"or")).documented());
                }
            }
            if (RESERVED_ALIAS_NAMES.contains(this.normalizedAlias)) {
                DefaultVersionCatalogBuilder.this.throwVersionCatalogProblem(VersionCatalogProblemId.RESERVED_ALIAS_NAME, spec -> spec.withShortDescription(() -> "Alias '" + this.alias + "' is not a valid alias").happensBecause(() -> "Alias '" + this.alias + "' is a reserved name in Gradle which prevents generation of accessors").addSolution(() -> "Use a different alias which isn't in the reserved names " + RenderingUtils.oxfordListOf((Collection)RESERVED_ALIAS_NAMES, (String)"or")).documented());
            }
        }
    }

    private class VersionReferencingPluginModel
    implements Supplier<PluginModel> {
        private final String id;
        private final String versionRef;
        private final String context;

        private VersionReferencingPluginModel(String id, String versionRef) {
            this.id = id;
            this.versionRef = versionRef;
            this.context = DefaultVersionCatalogBuilder.this.currentContext;
        }

        @Override
        public PluginModel get() {
            VersionModel model = (VersionModel)DefaultVersionCatalogBuilder.this.versionConstraints.get(this.versionRef);
            if (model == null) {
                return (PluginModel)DefaultVersionCatalogBuilder.this.throwVersionCatalogProblem(VersionCatalogProblemId.UNDEFINED_VERSION_REFERENCE, spec -> {
                    VersionCatalogProblemBuilder.DescribedProblemWithCause solutions = spec.withShortDescription(() -> "Version reference '" + this.versionRef + "' doesn't exist").happensBecause("Plugin '" + this.id + "' references version '" + this.versionRef + "' which doesn't exist").addSolution(() -> "Declare '" + this.versionRef + "' in the catalog").documented();
                    if (!DefaultVersionCatalogBuilder.this.versionConstraints.keySet().isEmpty()) {
                        solutions.addSolution(() -> "Use one of the following existing versions: " + RenderingUtils.oxfordListOf(DefaultVersionCatalogBuilder.this.versionConstraints.keySet(), (String)"or"));
                    }
                });
            }
            return new PluginModel(this.id, this.versionRef, model.getVersion(), this.context);
        }
    }

    private class VersionReferencingDependencyModel
    implements Supplier<DependencyModel> {
        private final String group;
        private final String name;
        private final String versionRef;
        private final String context;

        private VersionReferencingDependencyModel(String group, String name, String versionRef) {
            this.group = group;
            this.name = name;
            this.versionRef = versionRef;
            this.context = DefaultVersionCatalogBuilder.this.currentContext;
        }

        @Override
        public DependencyModel get() {
            VersionModel model = (VersionModel)DefaultVersionCatalogBuilder.this.versionConstraints.get(this.versionRef);
            if (model == null) {
                return (DependencyModel)DefaultVersionCatalogBuilder.this.throwVersionCatalogProblem(VersionCatalogProblemId.UNDEFINED_VERSION_REFERENCE, spec -> {
                    VersionCatalogProblemBuilder.DescribedProblemWithCause solutions = spec.withShortDescription(() -> "Version reference '" + this.versionRef + "' doesn't exist").happensBecause("Dependency '" + this.group + ":" + this.name + "' references version '" + this.versionRef + "' which doesn't exist").addSolution(() -> "Declare '" + this.versionRef + "' in the catalog").documented();
                    if (!DefaultVersionCatalogBuilder.this.versionConstraints.keySet().isEmpty()) {
                        solutions.addSolution(() -> "Use one of the following existing versions: " + RenderingUtils.oxfordListOf(DefaultVersionCatalogBuilder.this.versionConstraints.keySet(), (String)"or"));
                    }
                });
            }
            return new DependencyModel(this.group, this.name, this.versionRef, model.getVersion(), this.context);
        }
    }

    private static enum AliasType {
        LIBRARY,
        PLUGIN,
        BUNDLE,
        VERSION,
        ALIAS;


        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

