// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/bigquery/v2/model.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BIGQUERY_MODEL_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BIGQUERY_MODEL_CLIENT_H

#include "google/cloud/bigquery/model_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <map>
#include <memory>

namespace google {
namespace cloud {
namespace bigquery {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// ModelServiceClient
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class ModelServiceClient {
 public:
  explicit ModelServiceClient(
      std::shared_ptr<ModelServiceConnection> connection, Options opts = {});
  ~ModelServiceClient();

  //@{
  // @name Copy and move support
  ModelServiceClient(ModelServiceClient const&) = default;
  ModelServiceClient& operator=(ModelServiceClient const&) = default;
  ModelServiceClient(ModelServiceClient&&) = default;
  ModelServiceClient& operator=(ModelServiceClient&&) = default;
  //@}

  //@{
  // @name Equality
  friend bool operator==(ModelServiceClient const& a,
                         ModelServiceClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(ModelServiceClient const& a,
                         ModelServiceClient const& b) {
    return !(a == b);
  }
  //@}

  ///
  /// Gets the specified model resource by model ID.
  ///
  /// @param project_id  Required. Project ID of the requested model.
  /// @param dataset_id  Required. Dataset ID of the requested model.
  /// @param model_id  Required. Model ID of the requested model.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return
  /// @googleapis_link{google::cloud::bigquery::v2::Model,google/cloud/bigquery/v2/model.proto#L78}
  ///
  /// [google.cloud.bigquery.v2.GetModelRequest]:
  /// @googleapis_reference_link{google/cloud/bigquery/v2/model.proto#L1226}
  /// [google.cloud.bigquery.v2.Model]:
  /// @googleapis_reference_link{google/cloud/bigquery/v2/model.proto#L78}
  ///
  StatusOr<google::cloud::bigquery::v2::Model> GetModel(
      std::string const& project_id, std::string const& dataset_id,
      std::string const& model_id, Options opts = {});

  ///
  /// Gets the specified model resource by model ID.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::bigquery::v2::GetModelRequest,google/cloud/bigquery/v2/model.proto#L1226}
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return
  /// @googleapis_link{google::cloud::bigquery::v2::Model,google/cloud/bigquery/v2/model.proto#L78}
  ///
  /// [google.cloud.bigquery.v2.GetModelRequest]:
  /// @googleapis_reference_link{google/cloud/bigquery/v2/model.proto#L1226}
  /// [google.cloud.bigquery.v2.Model]:
  /// @googleapis_reference_link{google/cloud/bigquery/v2/model.proto#L78}
  ///
  StatusOr<google::cloud::bigquery::v2::Model> GetModel(
      google::cloud::bigquery::v2::GetModelRequest const& request,
      Options opts = {});

  ///
  /// Lists all models in the specified dataset. Requires the READER dataset
  /// role. After retrieving the list of models, you can get information about a
  /// particular model by calling the models.get method.
  ///
  /// @param project_id  Required. Project ID of the models to list.
  /// @param dataset_id  Required. Dataset ID of the models to list.
  /// @param max_results  The maximum number of results to return in a single
  /// response page.
  ///  Leverage the page tokens to iterate through the entire collection.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return
  /// @googleapis_link{google::cloud::bigquery::v2::ListModelsResponse,google/cloud/bigquery/v2/model.proto#L1280}
  ///
  /// [google.cloud.bigquery.v2.ListModelsRequest]:
  /// @googleapis_reference_link{google/cloud/bigquery/v2/model.proto#L1264}
  /// [google.cloud.bigquery.v2.ListModelsResponse]:
  /// @googleapis_reference_link{google/cloud/bigquery/v2/model.proto#L1280}
  ///
  StatusOr<google::cloud::bigquery::v2::ListModelsResponse> ListModels(
      std::string const& project_id, std::string const& dataset_id,
      google::protobuf::UInt32Value const& max_results, Options opts = {});

  ///
  /// Lists all models in the specified dataset. Requires the READER dataset
  /// role. After retrieving the list of models, you can get information about a
  /// particular model by calling the models.get method.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::bigquery::v2::ListModelsRequest,google/cloud/bigquery/v2/model.proto#L1264}
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return
  /// @googleapis_link{google::cloud::bigquery::v2::ListModelsResponse,google/cloud/bigquery/v2/model.proto#L1280}
  ///
  /// [google.cloud.bigquery.v2.ListModelsRequest]:
  /// @googleapis_reference_link{google/cloud/bigquery/v2/model.proto#L1264}
  /// [google.cloud.bigquery.v2.ListModelsResponse]:
  /// @googleapis_reference_link{google/cloud/bigquery/v2/model.proto#L1280}
  ///
  StatusOr<google::cloud::bigquery::v2::ListModelsResponse> ListModels(
      google::cloud::bigquery::v2::ListModelsRequest const& request,
      Options opts = {});

  ///
  /// Patch specific fields in the specified model.
  ///
  /// @param project_id  Required. Project ID of the model to patch.
  /// @param dataset_id  Required. Dataset ID of the model to patch.
  /// @param model_id  Required. Model ID of the model to patch.
  /// @param model  Required. Patched model.
  ///  Follows RFC5789 patch semantics. Missing fields are not updated.
  ///  To clear a field, explicitly set to default value.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return
  /// @googleapis_link{google::cloud::bigquery::v2::Model,google/cloud/bigquery/v2/model.proto#L78}
  ///
  /// [google.cloud.bigquery.v2.PatchModelRequest]:
  /// @googleapis_reference_link{google/cloud/bigquery/v2/model.proto#L1237}
  /// [google.cloud.bigquery.v2.Model]:
  /// @googleapis_reference_link{google/cloud/bigquery/v2/model.proto#L78}
  ///
  StatusOr<google::cloud::bigquery::v2::Model> PatchModel(
      std::string const& project_id, std::string const& dataset_id,
      std::string const& model_id,
      google::cloud::bigquery::v2::Model const& model, Options opts = {});

  ///
  /// Patch specific fields in the specified model.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::bigquery::v2::PatchModelRequest,google/cloud/bigquery/v2/model.proto#L1237}
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return
  /// @googleapis_link{google::cloud::bigquery::v2::Model,google/cloud/bigquery/v2/model.proto#L78}
  ///
  /// [google.cloud.bigquery.v2.PatchModelRequest]:
  /// @googleapis_reference_link{google/cloud/bigquery/v2/model.proto#L1237}
  /// [google.cloud.bigquery.v2.Model]:
  /// @googleapis_reference_link{google/cloud/bigquery/v2/model.proto#L78}
  ///
  StatusOr<google::cloud::bigquery::v2::Model> PatchModel(
      google::cloud::bigquery::v2::PatchModelRequest const& request,
      Options opts = {});

  ///
  /// Deletes the model specified by modelId from the dataset.
  ///
  /// @param project_id  Required. Project ID of the model to delete.
  /// @param dataset_id  Required. Dataset ID of the model to delete.
  /// @param model_id  Required. Model ID of the model to delete.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  ///
  /// [google.cloud.bigquery.v2.DeleteModelRequest]:
  /// @googleapis_reference_link{google/cloud/bigquery/v2/model.proto#L1253}
  ///
  Status DeleteModel(std::string const& project_id,
                     std::string const& dataset_id, std::string const& model_id,
                     Options opts = {});

  ///
  /// Deletes the model specified by modelId from the dataset.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::bigquery::v2::DeleteModelRequest,google/cloud/bigquery/v2/model.proto#L1253}
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  ///
  /// [google.cloud.bigquery.v2.DeleteModelRequest]:
  /// @googleapis_reference_link{google/cloud/bigquery/v2/model.proto#L1253}
  ///
  Status DeleteModel(
      google::cloud::bigquery::v2::DeleteModelRequest const& request,
      Options opts = {});

 private:
  std::shared_ptr<ModelServiceConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace bigquery
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BIGQUERY_MODEL_CLIENT_H
