// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/bigtable/admin/v2/bigtable_instance_admin.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BIGTABLE_ADMIN_BIGTABLE_INSTANCE_ADMIN_CONNECTION_IDEMPOTENCY_POLICY_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BIGTABLE_ADMIN_BIGTABLE_INSTANCE_ADMIN_CONNECTION_IDEMPOTENCY_POLICY_H

#include "google/cloud/idempotency.h"
#include "google/cloud/internal/retry_policy.h"
#include "google/cloud/version.h"
#include <google/bigtable/admin/v2/bigtable_instance_admin.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace bigtable_admin {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class BigtableInstanceAdminConnectionIdempotencyPolicy {
 public:
  virtual ~BigtableInstanceAdminConnectionIdempotencyPolicy() = 0;

  /// Create a new copy of this object.
  virtual std::unique_ptr<BigtableInstanceAdminConnectionIdempotencyPolicy>
  clone() const = 0;

  virtual google::cloud::Idempotency CreateInstance(
      google::bigtable::admin::v2::CreateInstanceRequest const& request) = 0;

  virtual google::cloud::Idempotency GetInstance(
      google::bigtable::admin::v2::GetInstanceRequest const& request) = 0;

  virtual google::cloud::Idempotency ListInstances(
      google::bigtable::admin::v2::ListInstancesRequest const& request) = 0;

  virtual google::cloud::Idempotency UpdateInstance(
      google::bigtable::admin::v2::Instance const& request) = 0;

  virtual google::cloud::Idempotency PartialUpdateInstance(
      google::bigtable::admin::v2::PartialUpdateInstanceRequest const&
          request) = 0;

  virtual google::cloud::Idempotency DeleteInstance(
      google::bigtable::admin::v2::DeleteInstanceRequest const& request) = 0;

  virtual google::cloud::Idempotency CreateCluster(
      google::bigtable::admin::v2::CreateClusterRequest const& request) = 0;

  virtual google::cloud::Idempotency GetCluster(
      google::bigtable::admin::v2::GetClusterRequest const& request) = 0;

  virtual google::cloud::Idempotency ListClusters(
      google::bigtable::admin::v2::ListClustersRequest const& request) = 0;

  virtual google::cloud::Idempotency UpdateCluster(
      google::bigtable::admin::v2::Cluster const& request) = 0;

  virtual google::cloud::Idempotency PartialUpdateCluster(
      google::bigtable::admin::v2::PartialUpdateClusterRequest const&
          request) = 0;

  virtual google::cloud::Idempotency DeleteCluster(
      google::bigtable::admin::v2::DeleteClusterRequest const& request) = 0;

  virtual google::cloud::Idempotency CreateAppProfile(
      google::bigtable::admin::v2::CreateAppProfileRequest const& request) = 0;

  virtual google::cloud::Idempotency GetAppProfile(
      google::bigtable::admin::v2::GetAppProfileRequest const& request) = 0;

  virtual google::cloud::Idempotency ListAppProfiles(
      google::bigtable::admin::v2::ListAppProfilesRequest request) = 0;

  virtual google::cloud::Idempotency UpdateAppProfile(
      google::bigtable::admin::v2::UpdateAppProfileRequest const& request) = 0;

  virtual google::cloud::Idempotency DeleteAppProfile(
      google::bigtable::admin::v2::DeleteAppProfileRequest const& request) = 0;

  virtual google::cloud::Idempotency GetIamPolicy(
      google::iam::v1::GetIamPolicyRequest const& request) = 0;

  virtual google::cloud::Idempotency SetIamPolicy(
      google::iam::v1::SetIamPolicyRequest const& request) = 0;

  virtual google::cloud::Idempotency TestIamPermissions(
      google::iam::v1::TestIamPermissionsRequest const& request) = 0;

  virtual google::cloud::Idempotency ListHotTablets(
      google::bigtable::admin::v2::ListHotTabletsRequest request) = 0;
};

std::unique_ptr<BigtableInstanceAdminConnectionIdempotencyPolicy>
MakeDefaultBigtableInstanceAdminConnectionIdempotencyPolicy();

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace bigtable_admin
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BIGTABLE_ADMIN_BIGTABLE_INSTANCE_ADMIN_CONNECTION_IDEMPOTENCY_POLICY_H
