// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/bigquery/reservation/v1/reservation.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BIGQUERY_RESERVATION_CONNECTION_IDEMPOTENCY_POLICY_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BIGQUERY_RESERVATION_CONNECTION_IDEMPOTENCY_POLICY_H

#include "google/cloud/idempotency.h"
#include "google/cloud/internal/retry_policy.h"
#include "google/cloud/version.h"
#include <google/cloud/bigquery/reservation/v1/reservation.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace bigquery {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class ReservationServiceConnectionIdempotencyPolicy {
 public:
  virtual ~ReservationServiceConnectionIdempotencyPolicy() = 0;

  /// Create a new copy of this object.
  virtual std::unique_ptr<ReservationServiceConnectionIdempotencyPolicy> clone()
      const = 0;

  virtual google::cloud::Idempotency CreateReservation(
      google::cloud::bigquery::reservation::v1::CreateReservationRequest const&
          request) = 0;

  virtual google::cloud::Idempotency ListReservations(
      google::cloud::bigquery::reservation::v1::ListReservationsRequest
          request) = 0;

  virtual google::cloud::Idempotency GetReservation(
      google::cloud::bigquery::reservation::v1::GetReservationRequest const&
          request) = 0;

  virtual google::cloud::Idempotency DeleteReservation(
      google::cloud::bigquery::reservation::v1::DeleteReservationRequest const&
          request) = 0;

  virtual google::cloud::Idempotency UpdateReservation(
      google::cloud::bigquery::reservation::v1::UpdateReservationRequest const&
          request) = 0;

  virtual google::cloud::Idempotency CreateCapacityCommitment(
      google::cloud::bigquery::reservation::v1::
          CreateCapacityCommitmentRequest const& request) = 0;

  virtual google::cloud::Idempotency ListCapacityCommitments(
      google::cloud::bigquery::reservation::v1::ListCapacityCommitmentsRequest
          request) = 0;

  virtual google::cloud::Idempotency GetCapacityCommitment(
      google::cloud::bigquery::reservation::v1::
          GetCapacityCommitmentRequest const& request) = 0;

  virtual google::cloud::Idempotency DeleteCapacityCommitment(
      google::cloud::bigquery::reservation::v1::
          DeleteCapacityCommitmentRequest const& request) = 0;

  virtual google::cloud::Idempotency UpdateCapacityCommitment(
      google::cloud::bigquery::reservation::v1::
          UpdateCapacityCommitmentRequest const& request) = 0;

  virtual google::cloud::Idempotency SplitCapacityCommitment(
      google::cloud::bigquery::reservation::v1::
          SplitCapacityCommitmentRequest const& request) = 0;

  virtual google::cloud::Idempotency MergeCapacityCommitments(
      google::cloud::bigquery::reservation::v1::
          MergeCapacityCommitmentsRequest const& request) = 0;

  virtual google::cloud::Idempotency CreateAssignment(
      google::cloud::bigquery::reservation::v1::CreateAssignmentRequest const&
          request) = 0;

  virtual google::cloud::Idempotency ListAssignments(
      google::cloud::bigquery::reservation::v1::ListAssignmentsRequest
          request) = 0;

  virtual google::cloud::Idempotency DeleteAssignment(
      google::cloud::bigquery::reservation::v1::DeleteAssignmentRequest const&
          request) = 0;

  virtual google::cloud::Idempotency SearchAssignments(
      google::cloud::bigquery::reservation::v1::SearchAssignmentsRequest
          request) = 0;

  virtual google::cloud::Idempotency SearchAllAssignments(
      google::cloud::bigquery::reservation::v1::SearchAllAssignmentsRequest
          request) = 0;

  virtual google::cloud::Idempotency MoveAssignment(
      google::cloud::bigquery::reservation::v1::MoveAssignmentRequest const&
          request) = 0;

  virtual google::cloud::Idempotency UpdateAssignment(
      google::cloud::bigquery::reservation::v1::UpdateAssignmentRequest const&
          request) = 0;

  virtual google::cloud::Idempotency GetBiReservation(
      google::cloud::bigquery::reservation::v1::GetBiReservationRequest const&
          request) = 0;

  virtual google::cloud::Idempotency UpdateBiReservation(
      google::cloud::bigquery::reservation::v1::
          UpdateBiReservationRequest const& request) = 0;
};

std::unique_ptr<ReservationServiceConnectionIdempotencyPolicy>
MakeDefaultReservationServiceConnectionIdempotencyPolicy();

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace bigquery
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BIGQUERY_RESERVATION_CONNECTION_IDEMPOTENCY_POLICY_H
