// Generated by the gRPC C++ plugin.
// If you make any local change, they will be lost.
// source: google/cloud/dialogflow/v2/conversation_dataset.proto
// Original file comments:
// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
#ifndef GRPC_google_2fcloud_2fdialogflow_2fv2_2fconversation_5fdataset_2eproto__INCLUDED
#define GRPC_google_2fcloud_2fdialogflow_2fv2_2fconversation_5fdataset_2eproto__INCLUDED

#include "google/cloud/dialogflow/v2/conversation_dataset.pb.h"

#include <functional>
#include <grpcpp/impl/codegen/async_generic_service.h>
#include <grpcpp/impl/codegen/async_stream.h>
#include <grpcpp/impl/codegen/async_unary_call.h>
#include <grpcpp/impl/codegen/client_callback.h>
#include <grpcpp/impl/codegen/client_context.h>
#include <grpcpp/impl/codegen/completion_queue.h>
#include <grpcpp/impl/codegen/message_allocator.h>
#include <grpcpp/impl/codegen/method_handler.h>
#include <grpcpp/impl/codegen/proto_utils.h>
#include <grpcpp/impl/codegen/rpc_method.h>
#include <grpcpp/impl/codegen/server_callback.h>
#include <grpcpp/impl/codegen/server_callback_handlers.h>
#include <grpcpp/impl/codegen/server_context.h>
#include <grpcpp/impl/codegen/service_type.h>
#include <grpcpp/impl/codegen/status.h>
#include <grpcpp/impl/codegen/stub_options.h>
#include <grpcpp/impl/codegen/sync_stream.h>

namespace google {
namespace cloud {
namespace dialogflow {
namespace v2 {

// Conversation datasets.
//
// Conversation datasets contain raw conversation files and their
// customizable metadata that can be used for model training.
class ConversationDatasets final {
 public:
  static constexpr char const* service_full_name() {
    return "google.cloud.dialogflow.v2.ConversationDatasets";
  }
  class StubInterface {
   public:
    virtual ~StubInterface() {}
    // Creates a new conversation dataset.
    //
    // This method is a [long-running
    // operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
    // The returned `Operation` type has the following method-specific fields:
    //
    // - `metadata`: [CreateConversationDatasetOperationMetadata][google.cloud.dialogflow.v2.CreateConversationDatasetOperationMetadata]
    // - `response`: [ConversationDataset][google.cloud.dialogflow.v2.ConversationDataset]
    virtual ::grpc::Status CreateConversationDataset(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::CreateConversationDatasetRequest& request, ::google::longrunning::Operation* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>> AsyncCreateConversationDataset(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::CreateConversationDatasetRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>>(AsyncCreateConversationDatasetRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>> PrepareAsyncCreateConversationDataset(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::CreateConversationDatasetRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>>(PrepareAsyncCreateConversationDatasetRaw(context, request, cq));
    }
    // Retrieves the specified conversation dataset.
    virtual ::grpc::Status GetConversationDataset(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::GetConversationDatasetRequest& request, ::google::cloud::dialogflow::v2::ConversationDataset* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::dialogflow::v2::ConversationDataset>> AsyncGetConversationDataset(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::GetConversationDatasetRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::dialogflow::v2::ConversationDataset>>(AsyncGetConversationDatasetRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::dialogflow::v2::ConversationDataset>> PrepareAsyncGetConversationDataset(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::GetConversationDatasetRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::dialogflow::v2::ConversationDataset>>(PrepareAsyncGetConversationDatasetRaw(context, request, cq));
    }
    // Returns the list of all conversation datasets in the specified
    // project and location.
    virtual ::grpc::Status ListConversationDatasets(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::ListConversationDatasetsRequest& request, ::google::cloud::dialogflow::v2::ListConversationDatasetsResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::dialogflow::v2::ListConversationDatasetsResponse>> AsyncListConversationDatasets(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::ListConversationDatasetsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::dialogflow::v2::ListConversationDatasetsResponse>>(AsyncListConversationDatasetsRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::dialogflow::v2::ListConversationDatasetsResponse>> PrepareAsyncListConversationDatasets(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::ListConversationDatasetsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::dialogflow::v2::ListConversationDatasetsResponse>>(PrepareAsyncListConversationDatasetsRaw(context, request, cq));
    }
    // Deletes the specified conversation dataset.
    //
    // This method is a [long-running
    // operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
    // The returned `Operation` type has the following method-specific fields:
    //
    // - `metadata`: [DeleteConversationDatasetOperationMetadata][google.cloud.dialogflow.v2.DeleteConversationDatasetOperationMetadata]
    // - `response`: An [Empty
    //   message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#empty)
    virtual ::grpc::Status DeleteConversationDataset(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::DeleteConversationDatasetRequest& request, ::google::longrunning::Operation* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>> AsyncDeleteConversationDataset(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::DeleteConversationDatasetRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>>(AsyncDeleteConversationDatasetRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>> PrepareAsyncDeleteConversationDataset(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::DeleteConversationDatasetRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>>(PrepareAsyncDeleteConversationDatasetRaw(context, request, cq));
    }
    // Import data into the specified conversation dataset. Note that it
    // is not allowed to import data to a conversation dataset that
    // already has data in it.
    //
    // This method is a [long-running
    // operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
    // The returned `Operation` type has the following method-specific fields:
    //
    // - `metadata`: [ImportConversationDataOperationMetadata][google.cloud.dialogflow.v2.ImportConversationDataOperationMetadata]
    // - `response`: [ImportConversationDataOperationResponse][google.cloud.dialogflow.v2.ImportConversationDataOperationResponse]
    virtual ::grpc::Status ImportConversationData(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::ImportConversationDataRequest& request, ::google::longrunning::Operation* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>> AsyncImportConversationData(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::ImportConversationDataRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>>(AsyncImportConversationDataRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>> PrepareAsyncImportConversationData(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::ImportConversationDataRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>>(PrepareAsyncImportConversationDataRaw(context, request, cq));
    }
    class async_interface {
     public:
      virtual ~async_interface() {}
      // Creates a new conversation dataset.
      //
      // This method is a [long-running
      // operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
      // The returned `Operation` type has the following method-specific fields:
      //
      // - `metadata`: [CreateConversationDatasetOperationMetadata][google.cloud.dialogflow.v2.CreateConversationDatasetOperationMetadata]
      // - `response`: [ConversationDataset][google.cloud.dialogflow.v2.ConversationDataset]
      virtual void CreateConversationDataset(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::CreateConversationDatasetRequest* request, ::google::longrunning::Operation* response, std::function<void(::grpc::Status)>) = 0;
      virtual void CreateConversationDataset(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::CreateConversationDatasetRequest* request, ::google::longrunning::Operation* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Retrieves the specified conversation dataset.
      virtual void GetConversationDataset(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::GetConversationDatasetRequest* request, ::google::cloud::dialogflow::v2::ConversationDataset* response, std::function<void(::grpc::Status)>) = 0;
      virtual void GetConversationDataset(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::GetConversationDatasetRequest* request, ::google::cloud::dialogflow::v2::ConversationDataset* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Returns the list of all conversation datasets in the specified
      // project and location.
      virtual void ListConversationDatasets(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::ListConversationDatasetsRequest* request, ::google::cloud::dialogflow::v2::ListConversationDatasetsResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void ListConversationDatasets(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::ListConversationDatasetsRequest* request, ::google::cloud::dialogflow::v2::ListConversationDatasetsResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Deletes the specified conversation dataset.
      //
      // This method is a [long-running
      // operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
      // The returned `Operation` type has the following method-specific fields:
      //
      // - `metadata`: [DeleteConversationDatasetOperationMetadata][google.cloud.dialogflow.v2.DeleteConversationDatasetOperationMetadata]
      // - `response`: An [Empty
      //   message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#empty)
      virtual void DeleteConversationDataset(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::DeleteConversationDatasetRequest* request, ::google::longrunning::Operation* response, std::function<void(::grpc::Status)>) = 0;
      virtual void DeleteConversationDataset(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::DeleteConversationDatasetRequest* request, ::google::longrunning::Operation* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Import data into the specified conversation dataset. Note that it
      // is not allowed to import data to a conversation dataset that
      // already has data in it.
      //
      // This method is a [long-running
      // operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
      // The returned `Operation` type has the following method-specific fields:
      //
      // - `metadata`: [ImportConversationDataOperationMetadata][google.cloud.dialogflow.v2.ImportConversationDataOperationMetadata]
      // - `response`: [ImportConversationDataOperationResponse][google.cloud.dialogflow.v2.ImportConversationDataOperationResponse]
      virtual void ImportConversationData(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::ImportConversationDataRequest* request, ::google::longrunning::Operation* response, std::function<void(::grpc::Status)>) = 0;
      virtual void ImportConversationData(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::ImportConversationDataRequest* request, ::google::longrunning::Operation* response, ::grpc::ClientUnaryReactor* reactor) = 0;
    };
    typedef class async_interface experimental_async_interface;
    virtual class async_interface* async() { return nullptr; }
    class async_interface* experimental_async() { return async(); }
   private:
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>* AsyncCreateConversationDatasetRaw(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::CreateConversationDatasetRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>* PrepareAsyncCreateConversationDatasetRaw(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::CreateConversationDatasetRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::dialogflow::v2::ConversationDataset>* AsyncGetConversationDatasetRaw(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::GetConversationDatasetRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::dialogflow::v2::ConversationDataset>* PrepareAsyncGetConversationDatasetRaw(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::GetConversationDatasetRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::dialogflow::v2::ListConversationDatasetsResponse>* AsyncListConversationDatasetsRaw(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::ListConversationDatasetsRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::dialogflow::v2::ListConversationDatasetsResponse>* PrepareAsyncListConversationDatasetsRaw(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::ListConversationDatasetsRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>* AsyncDeleteConversationDatasetRaw(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::DeleteConversationDatasetRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>* PrepareAsyncDeleteConversationDatasetRaw(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::DeleteConversationDatasetRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>* AsyncImportConversationDataRaw(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::ImportConversationDataRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>* PrepareAsyncImportConversationDataRaw(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::ImportConversationDataRequest& request, ::grpc::CompletionQueue* cq) = 0;
  };
  class Stub final : public StubInterface {
   public:
    Stub(const std::shared_ptr< ::grpc::ChannelInterface>& channel, const ::grpc::StubOptions& options = ::grpc::StubOptions());
    ::grpc::Status CreateConversationDataset(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::CreateConversationDatasetRequest& request, ::google::longrunning::Operation* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>> AsyncCreateConversationDataset(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::CreateConversationDatasetRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>>(AsyncCreateConversationDatasetRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>> PrepareAsyncCreateConversationDataset(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::CreateConversationDatasetRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>>(PrepareAsyncCreateConversationDatasetRaw(context, request, cq));
    }
    ::grpc::Status GetConversationDataset(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::GetConversationDatasetRequest& request, ::google::cloud::dialogflow::v2::ConversationDataset* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::dialogflow::v2::ConversationDataset>> AsyncGetConversationDataset(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::GetConversationDatasetRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::dialogflow::v2::ConversationDataset>>(AsyncGetConversationDatasetRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::dialogflow::v2::ConversationDataset>> PrepareAsyncGetConversationDataset(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::GetConversationDatasetRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::dialogflow::v2::ConversationDataset>>(PrepareAsyncGetConversationDatasetRaw(context, request, cq));
    }
    ::grpc::Status ListConversationDatasets(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::ListConversationDatasetsRequest& request, ::google::cloud::dialogflow::v2::ListConversationDatasetsResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::dialogflow::v2::ListConversationDatasetsResponse>> AsyncListConversationDatasets(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::ListConversationDatasetsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::dialogflow::v2::ListConversationDatasetsResponse>>(AsyncListConversationDatasetsRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::dialogflow::v2::ListConversationDatasetsResponse>> PrepareAsyncListConversationDatasets(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::ListConversationDatasetsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::dialogflow::v2::ListConversationDatasetsResponse>>(PrepareAsyncListConversationDatasetsRaw(context, request, cq));
    }
    ::grpc::Status DeleteConversationDataset(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::DeleteConversationDatasetRequest& request, ::google::longrunning::Operation* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>> AsyncDeleteConversationDataset(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::DeleteConversationDatasetRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>>(AsyncDeleteConversationDatasetRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>> PrepareAsyncDeleteConversationDataset(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::DeleteConversationDatasetRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>>(PrepareAsyncDeleteConversationDatasetRaw(context, request, cq));
    }
    ::grpc::Status ImportConversationData(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::ImportConversationDataRequest& request, ::google::longrunning::Operation* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>> AsyncImportConversationData(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::ImportConversationDataRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>>(AsyncImportConversationDataRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>> PrepareAsyncImportConversationData(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::ImportConversationDataRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>>(PrepareAsyncImportConversationDataRaw(context, request, cq));
    }
    class async final :
      public StubInterface::async_interface {
     public:
      void CreateConversationDataset(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::CreateConversationDatasetRequest* request, ::google::longrunning::Operation* response, std::function<void(::grpc::Status)>) override;
      void CreateConversationDataset(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::CreateConversationDatasetRequest* request, ::google::longrunning::Operation* response, ::grpc::ClientUnaryReactor* reactor) override;
      void GetConversationDataset(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::GetConversationDatasetRequest* request, ::google::cloud::dialogflow::v2::ConversationDataset* response, std::function<void(::grpc::Status)>) override;
      void GetConversationDataset(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::GetConversationDatasetRequest* request, ::google::cloud::dialogflow::v2::ConversationDataset* response, ::grpc::ClientUnaryReactor* reactor) override;
      void ListConversationDatasets(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::ListConversationDatasetsRequest* request, ::google::cloud::dialogflow::v2::ListConversationDatasetsResponse* response, std::function<void(::grpc::Status)>) override;
      void ListConversationDatasets(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::ListConversationDatasetsRequest* request, ::google::cloud::dialogflow::v2::ListConversationDatasetsResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
      void DeleteConversationDataset(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::DeleteConversationDatasetRequest* request, ::google::longrunning::Operation* response, std::function<void(::grpc::Status)>) override;
      void DeleteConversationDataset(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::DeleteConversationDatasetRequest* request, ::google::longrunning::Operation* response, ::grpc::ClientUnaryReactor* reactor) override;
      void ImportConversationData(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::ImportConversationDataRequest* request, ::google::longrunning::Operation* response, std::function<void(::grpc::Status)>) override;
      void ImportConversationData(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::ImportConversationDataRequest* request, ::google::longrunning::Operation* response, ::grpc::ClientUnaryReactor* reactor) override;
     private:
      friend class Stub;
      explicit async(Stub* stub): stub_(stub) { }
      Stub* stub() { return stub_; }
      Stub* stub_;
    };
    class async* async() override { return &async_stub_; }

   private:
    std::shared_ptr< ::grpc::ChannelInterface> channel_;
    class async async_stub_{this};
    ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>* AsyncCreateConversationDatasetRaw(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::CreateConversationDatasetRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>* PrepareAsyncCreateConversationDatasetRaw(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::CreateConversationDatasetRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::cloud::dialogflow::v2::ConversationDataset>* AsyncGetConversationDatasetRaw(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::GetConversationDatasetRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::cloud::dialogflow::v2::ConversationDataset>* PrepareAsyncGetConversationDatasetRaw(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::GetConversationDatasetRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::cloud::dialogflow::v2::ListConversationDatasetsResponse>* AsyncListConversationDatasetsRaw(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::ListConversationDatasetsRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::cloud::dialogflow::v2::ListConversationDatasetsResponse>* PrepareAsyncListConversationDatasetsRaw(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::ListConversationDatasetsRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>* AsyncDeleteConversationDatasetRaw(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::DeleteConversationDatasetRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>* PrepareAsyncDeleteConversationDatasetRaw(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::DeleteConversationDatasetRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>* AsyncImportConversationDataRaw(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::ImportConversationDataRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>* PrepareAsyncImportConversationDataRaw(::grpc::ClientContext* context, const ::google::cloud::dialogflow::v2::ImportConversationDataRequest& request, ::grpc::CompletionQueue* cq) override;
    const ::grpc::internal::RpcMethod rpcmethod_CreateConversationDataset_;
    const ::grpc::internal::RpcMethod rpcmethod_GetConversationDataset_;
    const ::grpc::internal::RpcMethod rpcmethod_ListConversationDatasets_;
    const ::grpc::internal::RpcMethod rpcmethod_DeleteConversationDataset_;
    const ::grpc::internal::RpcMethod rpcmethod_ImportConversationData_;
  };
  static std::unique_ptr<Stub> NewStub(const std::shared_ptr< ::grpc::ChannelInterface>& channel, const ::grpc::StubOptions& options = ::grpc::StubOptions());

  class Service : public ::grpc::Service {
   public:
    Service();
    virtual ~Service();
    // Creates a new conversation dataset.
    //
    // This method is a [long-running
    // operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
    // The returned `Operation` type has the following method-specific fields:
    //
    // - `metadata`: [CreateConversationDatasetOperationMetadata][google.cloud.dialogflow.v2.CreateConversationDatasetOperationMetadata]
    // - `response`: [ConversationDataset][google.cloud.dialogflow.v2.ConversationDataset]
    virtual ::grpc::Status CreateConversationDataset(::grpc::ServerContext* context, const ::google::cloud::dialogflow::v2::CreateConversationDatasetRequest* request, ::google::longrunning::Operation* response);
    // Retrieves the specified conversation dataset.
    virtual ::grpc::Status GetConversationDataset(::grpc::ServerContext* context, const ::google::cloud::dialogflow::v2::GetConversationDatasetRequest* request, ::google::cloud::dialogflow::v2::ConversationDataset* response);
    // Returns the list of all conversation datasets in the specified
    // project and location.
    virtual ::grpc::Status ListConversationDatasets(::grpc::ServerContext* context, const ::google::cloud::dialogflow::v2::ListConversationDatasetsRequest* request, ::google::cloud::dialogflow::v2::ListConversationDatasetsResponse* response);
    // Deletes the specified conversation dataset.
    //
    // This method is a [long-running
    // operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
    // The returned `Operation` type has the following method-specific fields:
    //
    // - `metadata`: [DeleteConversationDatasetOperationMetadata][google.cloud.dialogflow.v2.DeleteConversationDatasetOperationMetadata]
    // - `response`: An [Empty
    //   message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#empty)
    virtual ::grpc::Status DeleteConversationDataset(::grpc::ServerContext* context, const ::google::cloud::dialogflow::v2::DeleteConversationDatasetRequest* request, ::google::longrunning::Operation* response);
    // Import data into the specified conversation dataset. Note that it
    // is not allowed to import data to a conversation dataset that
    // already has data in it.
    //
    // This method is a [long-running
    // operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
    // The returned `Operation` type has the following method-specific fields:
    //
    // - `metadata`: [ImportConversationDataOperationMetadata][google.cloud.dialogflow.v2.ImportConversationDataOperationMetadata]
    // - `response`: [ImportConversationDataOperationResponse][google.cloud.dialogflow.v2.ImportConversationDataOperationResponse]
    virtual ::grpc::Status ImportConversationData(::grpc::ServerContext* context, const ::google::cloud::dialogflow::v2::ImportConversationDataRequest* request, ::google::longrunning::Operation* response);
  };
  template <class BaseClass>
  class WithAsyncMethod_CreateConversationDataset : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_CreateConversationDataset() {
      ::grpc::Service::MarkMethodAsync(0);
    }
    ~WithAsyncMethod_CreateConversationDataset() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateConversationDataset(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::CreateConversationDatasetRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestCreateConversationDataset(::grpc::ServerContext* context, ::google::cloud::dialogflow::v2::CreateConversationDatasetRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::longrunning::Operation>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(0, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_GetConversationDataset : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_GetConversationDataset() {
      ::grpc::Service::MarkMethodAsync(1);
    }
    ~WithAsyncMethod_GetConversationDataset() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetConversationDataset(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::GetConversationDatasetRequest* /*request*/, ::google::cloud::dialogflow::v2::ConversationDataset* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGetConversationDataset(::grpc::ServerContext* context, ::google::cloud::dialogflow::v2::GetConversationDatasetRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::cloud::dialogflow::v2::ConversationDataset>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(1, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_ListConversationDatasets : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_ListConversationDatasets() {
      ::grpc::Service::MarkMethodAsync(2);
    }
    ~WithAsyncMethod_ListConversationDatasets() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListConversationDatasets(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::ListConversationDatasetsRequest* /*request*/, ::google::cloud::dialogflow::v2::ListConversationDatasetsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestListConversationDatasets(::grpc::ServerContext* context, ::google::cloud::dialogflow::v2::ListConversationDatasetsRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::cloud::dialogflow::v2::ListConversationDatasetsResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(2, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_DeleteConversationDataset : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_DeleteConversationDataset() {
      ::grpc::Service::MarkMethodAsync(3);
    }
    ~WithAsyncMethod_DeleteConversationDataset() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteConversationDataset(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::DeleteConversationDatasetRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestDeleteConversationDataset(::grpc::ServerContext* context, ::google::cloud::dialogflow::v2::DeleteConversationDatasetRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::longrunning::Operation>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(3, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_ImportConversationData : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_ImportConversationData() {
      ::grpc::Service::MarkMethodAsync(4);
    }
    ~WithAsyncMethod_ImportConversationData() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ImportConversationData(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::ImportConversationDataRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestImportConversationData(::grpc::ServerContext* context, ::google::cloud::dialogflow::v2::ImportConversationDataRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::longrunning::Operation>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(4, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  typedef WithAsyncMethod_CreateConversationDataset<WithAsyncMethod_GetConversationDataset<WithAsyncMethod_ListConversationDatasets<WithAsyncMethod_DeleteConversationDataset<WithAsyncMethod_ImportConversationData<Service > > > > > AsyncService;
  template <class BaseClass>
  class WithCallbackMethod_CreateConversationDataset : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_CreateConversationDataset() {
      ::grpc::Service::MarkMethodCallback(0,
          new ::grpc::internal::CallbackUnaryHandler< ::google::cloud::dialogflow::v2::CreateConversationDatasetRequest, ::google::longrunning::Operation>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::cloud::dialogflow::v2::CreateConversationDatasetRequest* request, ::google::longrunning::Operation* response) { return this->CreateConversationDataset(context, request, response); }));}
    void SetMessageAllocatorFor_CreateConversationDataset(
        ::grpc::MessageAllocator< ::google::cloud::dialogflow::v2::CreateConversationDatasetRequest, ::google::longrunning::Operation>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(0);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::cloud::dialogflow::v2::CreateConversationDatasetRequest, ::google::longrunning::Operation>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_CreateConversationDataset() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateConversationDataset(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::CreateConversationDatasetRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* CreateConversationDataset(
      ::grpc::CallbackServerContext* /*context*/, const ::google::cloud::dialogflow::v2::CreateConversationDatasetRequest* /*request*/, ::google::longrunning::Operation* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_GetConversationDataset : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_GetConversationDataset() {
      ::grpc::Service::MarkMethodCallback(1,
          new ::grpc::internal::CallbackUnaryHandler< ::google::cloud::dialogflow::v2::GetConversationDatasetRequest, ::google::cloud::dialogflow::v2::ConversationDataset>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::cloud::dialogflow::v2::GetConversationDatasetRequest* request, ::google::cloud::dialogflow::v2::ConversationDataset* response) { return this->GetConversationDataset(context, request, response); }));}
    void SetMessageAllocatorFor_GetConversationDataset(
        ::grpc::MessageAllocator< ::google::cloud::dialogflow::v2::GetConversationDatasetRequest, ::google::cloud::dialogflow::v2::ConversationDataset>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(1);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::cloud::dialogflow::v2::GetConversationDatasetRequest, ::google::cloud::dialogflow::v2::ConversationDataset>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_GetConversationDataset() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetConversationDataset(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::GetConversationDatasetRequest* /*request*/, ::google::cloud::dialogflow::v2::ConversationDataset* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* GetConversationDataset(
      ::grpc::CallbackServerContext* /*context*/, const ::google::cloud::dialogflow::v2::GetConversationDatasetRequest* /*request*/, ::google::cloud::dialogflow::v2::ConversationDataset* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_ListConversationDatasets : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_ListConversationDatasets() {
      ::grpc::Service::MarkMethodCallback(2,
          new ::grpc::internal::CallbackUnaryHandler< ::google::cloud::dialogflow::v2::ListConversationDatasetsRequest, ::google::cloud::dialogflow::v2::ListConversationDatasetsResponse>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::cloud::dialogflow::v2::ListConversationDatasetsRequest* request, ::google::cloud::dialogflow::v2::ListConversationDatasetsResponse* response) { return this->ListConversationDatasets(context, request, response); }));}
    void SetMessageAllocatorFor_ListConversationDatasets(
        ::grpc::MessageAllocator< ::google::cloud::dialogflow::v2::ListConversationDatasetsRequest, ::google::cloud::dialogflow::v2::ListConversationDatasetsResponse>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(2);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::cloud::dialogflow::v2::ListConversationDatasetsRequest, ::google::cloud::dialogflow::v2::ListConversationDatasetsResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_ListConversationDatasets() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListConversationDatasets(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::ListConversationDatasetsRequest* /*request*/, ::google::cloud::dialogflow::v2::ListConversationDatasetsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* ListConversationDatasets(
      ::grpc::CallbackServerContext* /*context*/, const ::google::cloud::dialogflow::v2::ListConversationDatasetsRequest* /*request*/, ::google::cloud::dialogflow::v2::ListConversationDatasetsResponse* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_DeleteConversationDataset : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_DeleteConversationDataset() {
      ::grpc::Service::MarkMethodCallback(3,
          new ::grpc::internal::CallbackUnaryHandler< ::google::cloud::dialogflow::v2::DeleteConversationDatasetRequest, ::google::longrunning::Operation>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::cloud::dialogflow::v2::DeleteConversationDatasetRequest* request, ::google::longrunning::Operation* response) { return this->DeleteConversationDataset(context, request, response); }));}
    void SetMessageAllocatorFor_DeleteConversationDataset(
        ::grpc::MessageAllocator< ::google::cloud::dialogflow::v2::DeleteConversationDatasetRequest, ::google::longrunning::Operation>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(3);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::cloud::dialogflow::v2::DeleteConversationDatasetRequest, ::google::longrunning::Operation>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_DeleteConversationDataset() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteConversationDataset(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::DeleteConversationDatasetRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* DeleteConversationDataset(
      ::grpc::CallbackServerContext* /*context*/, const ::google::cloud::dialogflow::v2::DeleteConversationDatasetRequest* /*request*/, ::google::longrunning::Operation* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_ImportConversationData : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_ImportConversationData() {
      ::grpc::Service::MarkMethodCallback(4,
          new ::grpc::internal::CallbackUnaryHandler< ::google::cloud::dialogflow::v2::ImportConversationDataRequest, ::google::longrunning::Operation>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::cloud::dialogflow::v2::ImportConversationDataRequest* request, ::google::longrunning::Operation* response) { return this->ImportConversationData(context, request, response); }));}
    void SetMessageAllocatorFor_ImportConversationData(
        ::grpc::MessageAllocator< ::google::cloud::dialogflow::v2::ImportConversationDataRequest, ::google::longrunning::Operation>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(4);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::cloud::dialogflow::v2::ImportConversationDataRequest, ::google::longrunning::Operation>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_ImportConversationData() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ImportConversationData(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::ImportConversationDataRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* ImportConversationData(
      ::grpc::CallbackServerContext* /*context*/, const ::google::cloud::dialogflow::v2::ImportConversationDataRequest* /*request*/, ::google::longrunning::Operation* /*response*/)  { return nullptr; }
  };
  typedef WithCallbackMethod_CreateConversationDataset<WithCallbackMethod_GetConversationDataset<WithCallbackMethod_ListConversationDatasets<WithCallbackMethod_DeleteConversationDataset<WithCallbackMethod_ImportConversationData<Service > > > > > CallbackService;
  typedef CallbackService ExperimentalCallbackService;
  template <class BaseClass>
  class WithGenericMethod_CreateConversationDataset : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_CreateConversationDataset() {
      ::grpc::Service::MarkMethodGeneric(0);
    }
    ~WithGenericMethod_CreateConversationDataset() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateConversationDataset(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::CreateConversationDatasetRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_GetConversationDataset : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_GetConversationDataset() {
      ::grpc::Service::MarkMethodGeneric(1);
    }
    ~WithGenericMethod_GetConversationDataset() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetConversationDataset(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::GetConversationDatasetRequest* /*request*/, ::google::cloud::dialogflow::v2::ConversationDataset* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_ListConversationDatasets : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_ListConversationDatasets() {
      ::grpc::Service::MarkMethodGeneric(2);
    }
    ~WithGenericMethod_ListConversationDatasets() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListConversationDatasets(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::ListConversationDatasetsRequest* /*request*/, ::google::cloud::dialogflow::v2::ListConversationDatasetsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_DeleteConversationDataset : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_DeleteConversationDataset() {
      ::grpc::Service::MarkMethodGeneric(3);
    }
    ~WithGenericMethod_DeleteConversationDataset() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteConversationDataset(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::DeleteConversationDatasetRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_ImportConversationData : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_ImportConversationData() {
      ::grpc::Service::MarkMethodGeneric(4);
    }
    ~WithGenericMethod_ImportConversationData() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ImportConversationData(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::ImportConversationDataRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithRawMethod_CreateConversationDataset : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_CreateConversationDataset() {
      ::grpc::Service::MarkMethodRaw(0);
    }
    ~WithRawMethod_CreateConversationDataset() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateConversationDataset(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::CreateConversationDatasetRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestCreateConversationDataset(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(0, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_GetConversationDataset : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_GetConversationDataset() {
      ::grpc::Service::MarkMethodRaw(1);
    }
    ~WithRawMethod_GetConversationDataset() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetConversationDataset(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::GetConversationDatasetRequest* /*request*/, ::google::cloud::dialogflow::v2::ConversationDataset* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGetConversationDataset(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(1, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_ListConversationDatasets : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_ListConversationDatasets() {
      ::grpc::Service::MarkMethodRaw(2);
    }
    ~WithRawMethod_ListConversationDatasets() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListConversationDatasets(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::ListConversationDatasetsRequest* /*request*/, ::google::cloud::dialogflow::v2::ListConversationDatasetsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestListConversationDatasets(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(2, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_DeleteConversationDataset : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_DeleteConversationDataset() {
      ::grpc::Service::MarkMethodRaw(3);
    }
    ~WithRawMethod_DeleteConversationDataset() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteConversationDataset(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::DeleteConversationDatasetRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestDeleteConversationDataset(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(3, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_ImportConversationData : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_ImportConversationData() {
      ::grpc::Service::MarkMethodRaw(4);
    }
    ~WithRawMethod_ImportConversationData() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ImportConversationData(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::ImportConversationDataRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestImportConversationData(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(4, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_CreateConversationDataset : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_CreateConversationDataset() {
      ::grpc::Service::MarkMethodRawCallback(0,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->CreateConversationDataset(context, request, response); }));
    }
    ~WithRawCallbackMethod_CreateConversationDataset() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateConversationDataset(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::CreateConversationDatasetRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* CreateConversationDataset(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_GetConversationDataset : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_GetConversationDataset() {
      ::grpc::Service::MarkMethodRawCallback(1,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->GetConversationDataset(context, request, response); }));
    }
    ~WithRawCallbackMethod_GetConversationDataset() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetConversationDataset(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::GetConversationDatasetRequest* /*request*/, ::google::cloud::dialogflow::v2::ConversationDataset* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* GetConversationDataset(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_ListConversationDatasets : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_ListConversationDatasets() {
      ::grpc::Service::MarkMethodRawCallback(2,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->ListConversationDatasets(context, request, response); }));
    }
    ~WithRawCallbackMethod_ListConversationDatasets() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListConversationDatasets(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::ListConversationDatasetsRequest* /*request*/, ::google::cloud::dialogflow::v2::ListConversationDatasetsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* ListConversationDatasets(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_DeleteConversationDataset : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_DeleteConversationDataset() {
      ::grpc::Service::MarkMethodRawCallback(3,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->DeleteConversationDataset(context, request, response); }));
    }
    ~WithRawCallbackMethod_DeleteConversationDataset() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteConversationDataset(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::DeleteConversationDatasetRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* DeleteConversationDataset(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_ImportConversationData : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_ImportConversationData() {
      ::grpc::Service::MarkMethodRawCallback(4,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->ImportConversationData(context, request, response); }));
    }
    ~WithRawCallbackMethod_ImportConversationData() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ImportConversationData(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::ImportConversationDataRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* ImportConversationData(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_CreateConversationDataset : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_CreateConversationDataset() {
      ::grpc::Service::MarkMethodStreamed(0,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::cloud::dialogflow::v2::CreateConversationDatasetRequest, ::google::longrunning::Operation>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::cloud::dialogflow::v2::CreateConversationDatasetRequest, ::google::longrunning::Operation>* streamer) {
                       return this->StreamedCreateConversationDataset(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_CreateConversationDataset() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status CreateConversationDataset(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::CreateConversationDatasetRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedCreateConversationDataset(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::cloud::dialogflow::v2::CreateConversationDatasetRequest,::google::longrunning::Operation>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_GetConversationDataset : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_GetConversationDataset() {
      ::grpc::Service::MarkMethodStreamed(1,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::cloud::dialogflow::v2::GetConversationDatasetRequest, ::google::cloud::dialogflow::v2::ConversationDataset>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::cloud::dialogflow::v2::GetConversationDatasetRequest, ::google::cloud::dialogflow::v2::ConversationDataset>* streamer) {
                       return this->StreamedGetConversationDataset(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_GetConversationDataset() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status GetConversationDataset(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::GetConversationDatasetRequest* /*request*/, ::google::cloud::dialogflow::v2::ConversationDataset* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedGetConversationDataset(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::cloud::dialogflow::v2::GetConversationDatasetRequest,::google::cloud::dialogflow::v2::ConversationDataset>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_ListConversationDatasets : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_ListConversationDatasets() {
      ::grpc::Service::MarkMethodStreamed(2,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::cloud::dialogflow::v2::ListConversationDatasetsRequest, ::google::cloud::dialogflow::v2::ListConversationDatasetsResponse>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::cloud::dialogflow::v2::ListConversationDatasetsRequest, ::google::cloud::dialogflow::v2::ListConversationDatasetsResponse>* streamer) {
                       return this->StreamedListConversationDatasets(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_ListConversationDatasets() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status ListConversationDatasets(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::ListConversationDatasetsRequest* /*request*/, ::google::cloud::dialogflow::v2::ListConversationDatasetsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedListConversationDatasets(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::cloud::dialogflow::v2::ListConversationDatasetsRequest,::google::cloud::dialogflow::v2::ListConversationDatasetsResponse>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_DeleteConversationDataset : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_DeleteConversationDataset() {
      ::grpc::Service::MarkMethodStreamed(3,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::cloud::dialogflow::v2::DeleteConversationDatasetRequest, ::google::longrunning::Operation>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::cloud::dialogflow::v2::DeleteConversationDatasetRequest, ::google::longrunning::Operation>* streamer) {
                       return this->StreamedDeleteConversationDataset(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_DeleteConversationDataset() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status DeleteConversationDataset(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::DeleteConversationDatasetRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedDeleteConversationDataset(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::cloud::dialogflow::v2::DeleteConversationDatasetRequest,::google::longrunning::Operation>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_ImportConversationData : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_ImportConversationData() {
      ::grpc::Service::MarkMethodStreamed(4,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::cloud::dialogflow::v2::ImportConversationDataRequest, ::google::longrunning::Operation>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::cloud::dialogflow::v2::ImportConversationDataRequest, ::google::longrunning::Operation>* streamer) {
                       return this->StreamedImportConversationData(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_ImportConversationData() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status ImportConversationData(::grpc::ServerContext* /*context*/, const ::google::cloud::dialogflow::v2::ImportConversationDataRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedImportConversationData(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::cloud::dialogflow::v2::ImportConversationDataRequest,::google::longrunning::Operation>* server_unary_streamer) = 0;
  };
  typedef WithStreamedUnaryMethod_CreateConversationDataset<WithStreamedUnaryMethod_GetConversationDataset<WithStreamedUnaryMethod_ListConversationDatasets<WithStreamedUnaryMethod_DeleteConversationDataset<WithStreamedUnaryMethod_ImportConversationData<Service > > > > > StreamedUnaryService;
  typedef Service SplitStreamedService;
  typedef WithStreamedUnaryMethod_CreateConversationDataset<WithStreamedUnaryMethod_GetConversationDataset<WithStreamedUnaryMethod_ListConversationDatasets<WithStreamedUnaryMethod_DeleteConversationDataset<WithStreamedUnaryMethod_ImportConversationData<Service > > > > > StreamedService;
};

}  // namespace v2
}  // namespace dialogflow
}  // namespace cloud
}  // namespace google


#endif  // GRPC_google_2fcloud_2fdialogflow_2fv2_2fconversation_5fdataset_2eproto__INCLUDED
