// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/iam/admin/v1/iam.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_IAM_INTERNAL_IAM_LOGGING_DECORATOR_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_IAM_INTERNAL_IAM_LOGGING_DECORATOR_H

#include "google/cloud/iam/internal/iam_stub.h"
#include "google/cloud/tracing_options.h"
#include "google/cloud/version.h"
#include <memory>
#include <set>
#include <string>

namespace google {
namespace cloud {
namespace iam_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class IAMLogging : public IAMStub {
 public:
  ~IAMLogging() override = default;
  IAMLogging(std::shared_ptr<IAMStub> child, TracingOptions tracing_options,
             std::set<std::string> components);

  StatusOr<google::iam::admin::v1::ListServiceAccountsResponse>
  ListServiceAccounts(grpc::ClientContext& context,
                      google::iam::admin::v1::ListServiceAccountsRequest const&
                          request) override;

  StatusOr<google::iam::admin::v1::ServiceAccount> GetServiceAccount(
      grpc::ClientContext& context,
      google::iam::admin::v1::GetServiceAccountRequest const& request) override;

  StatusOr<google::iam::admin::v1::ServiceAccount> CreateServiceAccount(
      grpc::ClientContext& context,
      google::iam::admin::v1::CreateServiceAccountRequest const& request)
      override;

  StatusOr<google::iam::admin::v1::ServiceAccount> PatchServiceAccount(
      grpc::ClientContext& context,
      google::iam::admin::v1::PatchServiceAccountRequest const& request)
      override;

  Status DeleteServiceAccount(
      grpc::ClientContext& context,
      google::iam::admin::v1::DeleteServiceAccountRequest const& request)
      override;

  StatusOr<google::iam::admin::v1::UndeleteServiceAccountResponse>
  UndeleteServiceAccount(
      grpc::ClientContext& context,
      google::iam::admin::v1::UndeleteServiceAccountRequest const& request)
      override;

  Status EnableServiceAccount(
      grpc::ClientContext& context,
      google::iam::admin::v1::EnableServiceAccountRequest const& request)
      override;

  Status DisableServiceAccount(
      grpc::ClientContext& context,
      google::iam::admin::v1::DisableServiceAccountRequest const& request)
      override;

  StatusOr<google::iam::admin::v1::ListServiceAccountKeysResponse>
  ListServiceAccountKeys(
      grpc::ClientContext& context,
      google::iam::admin::v1::ListServiceAccountKeysRequest const& request)
      override;

  StatusOr<google::iam::admin::v1::ServiceAccountKey> GetServiceAccountKey(
      grpc::ClientContext& context,
      google::iam::admin::v1::GetServiceAccountKeyRequest const& request)
      override;

  StatusOr<google::iam::admin::v1::ServiceAccountKey> CreateServiceAccountKey(
      grpc::ClientContext& context,
      google::iam::admin::v1::CreateServiceAccountKeyRequest const& request)
      override;

  StatusOr<google::iam::admin::v1::ServiceAccountKey> UploadServiceAccountKey(
      grpc::ClientContext& context,
      google::iam::admin::v1::UploadServiceAccountKeyRequest const& request)
      override;

  Status DeleteServiceAccountKey(
      grpc::ClientContext& context,
      google::iam::admin::v1::DeleteServiceAccountKeyRequest const& request)
      override;

  StatusOr<google::iam::v1::Policy> GetIamPolicy(
      grpc::ClientContext& context,
      google::iam::v1::GetIamPolicyRequest const& request) override;

  StatusOr<google::iam::v1::Policy> SetIamPolicy(
      grpc::ClientContext& context,
      google::iam::v1::SetIamPolicyRequest const& request) override;

  StatusOr<google::iam::v1::TestIamPermissionsResponse> TestIamPermissions(
      grpc::ClientContext& context,
      google::iam::v1::TestIamPermissionsRequest const& request) override;

  StatusOr<google::iam::admin::v1::QueryGrantableRolesResponse>
  QueryGrantableRoles(grpc::ClientContext& context,
                      google::iam::admin::v1::QueryGrantableRolesRequest const&
                          request) override;

  StatusOr<google::iam::admin::v1::ListRolesResponse> ListRoles(
      grpc::ClientContext& context,
      google::iam::admin::v1::ListRolesRequest const& request) override;

  StatusOr<google::iam::admin::v1::Role> GetRole(
      grpc::ClientContext& context,
      google::iam::admin::v1::GetRoleRequest const& request) override;

  StatusOr<google::iam::admin::v1::Role> CreateRole(
      grpc::ClientContext& context,
      google::iam::admin::v1::CreateRoleRequest const& request) override;

  StatusOr<google::iam::admin::v1::Role> UpdateRole(
      grpc::ClientContext& context,
      google::iam::admin::v1::UpdateRoleRequest const& request) override;

  StatusOr<google::iam::admin::v1::Role> DeleteRole(
      grpc::ClientContext& context,
      google::iam::admin::v1::DeleteRoleRequest const& request) override;

  StatusOr<google::iam::admin::v1::Role> UndeleteRole(
      grpc::ClientContext& context,
      google::iam::admin::v1::UndeleteRoleRequest const& request) override;

  StatusOr<google::iam::admin::v1::QueryTestablePermissionsResponse>
  QueryTestablePermissions(
      grpc::ClientContext& context,
      google::iam::admin::v1::QueryTestablePermissionsRequest const& request)
      override;

  StatusOr<google::iam::admin::v1::QueryAuditableServicesResponse>
  QueryAuditableServices(
      grpc::ClientContext& context,
      google::iam::admin::v1::QueryAuditableServicesRequest const& request)
      override;

  StatusOr<google::iam::admin::v1::LintPolicyResponse> LintPolicy(
      grpc::ClientContext& context,
      google::iam::admin::v1::LintPolicyRequest const& request) override;

 private:
  std::shared_ptr<IAMStub> child_;
  TracingOptions tracing_options_;
  std::set<std::string> components_;
};  // IAMLogging

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
namespace gcpcxxV1 = GOOGLE_CLOUD_CPP_NS;  // NOLINT(misc-unused-alias-decls)
}  // namespace iam_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_IAM_INTERNAL_IAM_LOGGING_DECORATOR_H
