// Generated by the gRPC C++ plugin.
// If you make any local change, they will be lost.
// source: google/logging/v2/logging_config.proto
// Original file comments:
// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
#ifndef GRPC_google_2flogging_2fv2_2flogging_5fconfig_2eproto__INCLUDED
#define GRPC_google_2flogging_2fv2_2flogging_5fconfig_2eproto__INCLUDED

#include "google/logging/v2/logging_config.pb.h"

#include <functional>
#include <grpcpp/impl/codegen/async_generic_service.h>
#include <grpcpp/impl/codegen/async_stream.h>
#include <grpcpp/impl/codegen/async_unary_call.h>
#include <grpcpp/impl/codegen/client_callback.h>
#include <grpcpp/impl/codegen/client_context.h>
#include <grpcpp/impl/codegen/completion_queue.h>
#include <grpcpp/impl/codegen/message_allocator.h>
#include <grpcpp/impl/codegen/method_handler.h>
#include <grpcpp/impl/codegen/proto_utils.h>
#include <grpcpp/impl/codegen/rpc_method.h>
#include <grpcpp/impl/codegen/server_callback.h>
#include <grpcpp/impl/codegen/server_callback_handlers.h>
#include <grpcpp/impl/codegen/server_context.h>
#include <grpcpp/impl/codegen/service_type.h>
#include <grpcpp/impl/codegen/status.h>
#include <grpcpp/impl/codegen/stub_options.h>
#include <grpcpp/impl/codegen/sync_stream.h>

namespace google {
namespace logging {
namespace v2 {

// Service for configuring sinks used to route log entries.
class ConfigServiceV2 final {
 public:
  static constexpr char const* service_full_name() {
    return "google.logging.v2.ConfigServiceV2";
  }
  class StubInterface {
   public:
    virtual ~StubInterface() {}
    // Lists log buckets.
    virtual ::grpc::Status ListBuckets(::grpc::ClientContext* context, const ::google::logging::v2::ListBucketsRequest& request, ::google::logging::v2::ListBucketsResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::ListBucketsResponse>> AsyncListBuckets(::grpc::ClientContext* context, const ::google::logging::v2::ListBucketsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::ListBucketsResponse>>(AsyncListBucketsRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::ListBucketsResponse>> PrepareAsyncListBuckets(::grpc::ClientContext* context, const ::google::logging::v2::ListBucketsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::ListBucketsResponse>>(PrepareAsyncListBucketsRaw(context, request, cq));
    }
    // Gets a log bucket.
    virtual ::grpc::Status GetBucket(::grpc::ClientContext* context, const ::google::logging::v2::GetBucketRequest& request, ::google::logging::v2::LogBucket* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::LogBucket>> AsyncGetBucket(::grpc::ClientContext* context, const ::google::logging::v2::GetBucketRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::LogBucket>>(AsyncGetBucketRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::LogBucket>> PrepareAsyncGetBucket(::grpc::ClientContext* context, const ::google::logging::v2::GetBucketRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::LogBucket>>(PrepareAsyncGetBucketRaw(context, request, cq));
    }
    // Creates a log bucket that can be used to store log entries. After a bucket
    // has been created, the bucket's location cannot be changed.
    virtual ::grpc::Status CreateBucket(::grpc::ClientContext* context, const ::google::logging::v2::CreateBucketRequest& request, ::google::logging::v2::LogBucket* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::LogBucket>> AsyncCreateBucket(::grpc::ClientContext* context, const ::google::logging::v2::CreateBucketRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::LogBucket>>(AsyncCreateBucketRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::LogBucket>> PrepareAsyncCreateBucket(::grpc::ClientContext* context, const ::google::logging::v2::CreateBucketRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::LogBucket>>(PrepareAsyncCreateBucketRaw(context, request, cq));
    }
    // Updates a log bucket. This method replaces the following fields in the
    // existing bucket with values from the new bucket: `retention_period`
    //
    // If the retention period is decreased and the bucket is locked,
    // `FAILED_PRECONDITION` will be returned.
    //
    // If the bucket has a `lifecycle_state` of `DELETE_REQUESTED`, then
    // `FAILED_PRECONDITION` will be returned.
    //
    // After a bucket has been created, the bucket's location cannot be changed.
    virtual ::grpc::Status UpdateBucket(::grpc::ClientContext* context, const ::google::logging::v2::UpdateBucketRequest& request, ::google::logging::v2::LogBucket* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::LogBucket>> AsyncUpdateBucket(::grpc::ClientContext* context, const ::google::logging::v2::UpdateBucketRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::LogBucket>>(AsyncUpdateBucketRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::LogBucket>> PrepareAsyncUpdateBucket(::grpc::ClientContext* context, const ::google::logging::v2::UpdateBucketRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::LogBucket>>(PrepareAsyncUpdateBucketRaw(context, request, cq));
    }
    // Deletes a log bucket.
    //
    // Changes the bucket's `lifecycle_state` to the `DELETE_REQUESTED` state.
    // After 7 days, the bucket will be purged and all log entries in the bucket
    // will be permanently deleted.
    virtual ::grpc::Status DeleteBucket(::grpc::ClientContext* context, const ::google::logging::v2::DeleteBucketRequest& request, ::google::protobuf::Empty* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>> AsyncDeleteBucket(::grpc::ClientContext* context, const ::google::logging::v2::DeleteBucketRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>>(AsyncDeleteBucketRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>> PrepareAsyncDeleteBucket(::grpc::ClientContext* context, const ::google::logging::v2::DeleteBucketRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>>(PrepareAsyncDeleteBucketRaw(context, request, cq));
    }
    // Undeletes a log bucket. A bucket that has been deleted can be undeleted
    // within the grace period of 7 days.
    virtual ::grpc::Status UndeleteBucket(::grpc::ClientContext* context, const ::google::logging::v2::UndeleteBucketRequest& request, ::google::protobuf::Empty* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>> AsyncUndeleteBucket(::grpc::ClientContext* context, const ::google::logging::v2::UndeleteBucketRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>>(AsyncUndeleteBucketRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>> PrepareAsyncUndeleteBucket(::grpc::ClientContext* context, const ::google::logging::v2::UndeleteBucketRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>>(PrepareAsyncUndeleteBucketRaw(context, request, cq));
    }
    // Lists views on a log bucket.
    virtual ::grpc::Status ListViews(::grpc::ClientContext* context, const ::google::logging::v2::ListViewsRequest& request, ::google::logging::v2::ListViewsResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::ListViewsResponse>> AsyncListViews(::grpc::ClientContext* context, const ::google::logging::v2::ListViewsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::ListViewsResponse>>(AsyncListViewsRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::ListViewsResponse>> PrepareAsyncListViews(::grpc::ClientContext* context, const ::google::logging::v2::ListViewsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::ListViewsResponse>>(PrepareAsyncListViewsRaw(context, request, cq));
    }
    // Gets a view on a log bucket..
    virtual ::grpc::Status GetView(::grpc::ClientContext* context, const ::google::logging::v2::GetViewRequest& request, ::google::logging::v2::LogView* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::LogView>> AsyncGetView(::grpc::ClientContext* context, const ::google::logging::v2::GetViewRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::LogView>>(AsyncGetViewRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::LogView>> PrepareAsyncGetView(::grpc::ClientContext* context, const ::google::logging::v2::GetViewRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::LogView>>(PrepareAsyncGetViewRaw(context, request, cq));
    }
    // Creates a view over log entries in a log bucket. A bucket may contain a
    // maximum of 30 views.
    virtual ::grpc::Status CreateView(::grpc::ClientContext* context, const ::google::logging::v2::CreateViewRequest& request, ::google::logging::v2::LogView* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::LogView>> AsyncCreateView(::grpc::ClientContext* context, const ::google::logging::v2::CreateViewRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::LogView>>(AsyncCreateViewRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::LogView>> PrepareAsyncCreateView(::grpc::ClientContext* context, const ::google::logging::v2::CreateViewRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::LogView>>(PrepareAsyncCreateViewRaw(context, request, cq));
    }
    // Updates a view on a log bucket. This method replaces the following fields
    // in the existing view with values from the new view: `filter`.
    // If an `UNAVAILABLE` error is returned, this indicates that system is not in
    // a state where it can update the view. If this occurs, please try again in a
    // few minutes.
    virtual ::grpc::Status UpdateView(::grpc::ClientContext* context, const ::google::logging::v2::UpdateViewRequest& request, ::google::logging::v2::LogView* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::LogView>> AsyncUpdateView(::grpc::ClientContext* context, const ::google::logging::v2::UpdateViewRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::LogView>>(AsyncUpdateViewRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::LogView>> PrepareAsyncUpdateView(::grpc::ClientContext* context, const ::google::logging::v2::UpdateViewRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::LogView>>(PrepareAsyncUpdateViewRaw(context, request, cq));
    }
    // Deletes a view on a log bucket.
    // If an `UNAVAILABLE` error is returned, this indicates that system is not in
    // a state where it can delete the view. If this occurs, please try again in a
    // few minutes.
    virtual ::grpc::Status DeleteView(::grpc::ClientContext* context, const ::google::logging::v2::DeleteViewRequest& request, ::google::protobuf::Empty* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>> AsyncDeleteView(::grpc::ClientContext* context, const ::google::logging::v2::DeleteViewRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>>(AsyncDeleteViewRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>> PrepareAsyncDeleteView(::grpc::ClientContext* context, const ::google::logging::v2::DeleteViewRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>>(PrepareAsyncDeleteViewRaw(context, request, cq));
    }
    // Lists sinks.
    virtual ::grpc::Status ListSinks(::grpc::ClientContext* context, const ::google::logging::v2::ListSinksRequest& request, ::google::logging::v2::ListSinksResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::ListSinksResponse>> AsyncListSinks(::grpc::ClientContext* context, const ::google::logging::v2::ListSinksRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::ListSinksResponse>>(AsyncListSinksRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::ListSinksResponse>> PrepareAsyncListSinks(::grpc::ClientContext* context, const ::google::logging::v2::ListSinksRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::ListSinksResponse>>(PrepareAsyncListSinksRaw(context, request, cq));
    }
    // Gets a sink.
    virtual ::grpc::Status GetSink(::grpc::ClientContext* context, const ::google::logging::v2::GetSinkRequest& request, ::google::logging::v2::LogSink* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::LogSink>> AsyncGetSink(::grpc::ClientContext* context, const ::google::logging::v2::GetSinkRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::LogSink>>(AsyncGetSinkRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::LogSink>> PrepareAsyncGetSink(::grpc::ClientContext* context, const ::google::logging::v2::GetSinkRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::LogSink>>(PrepareAsyncGetSinkRaw(context, request, cq));
    }
    // Creates a sink that exports specified log entries to a destination. The
    // export of newly-ingested log entries begins immediately, unless the sink's
    // `writer_identity` is not permitted to write to the destination. A sink can
    // export log entries only from the resource owning the sink.
    virtual ::grpc::Status CreateSink(::grpc::ClientContext* context, const ::google::logging::v2::CreateSinkRequest& request, ::google::logging::v2::LogSink* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::LogSink>> AsyncCreateSink(::grpc::ClientContext* context, const ::google::logging::v2::CreateSinkRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::LogSink>>(AsyncCreateSinkRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::LogSink>> PrepareAsyncCreateSink(::grpc::ClientContext* context, const ::google::logging::v2::CreateSinkRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::LogSink>>(PrepareAsyncCreateSinkRaw(context, request, cq));
    }
    // Updates a sink. This method replaces the following fields in the existing
    // sink with values from the new sink: `destination`, and `filter`.
    //
    // The updated sink might also have a new `writer_identity`; see the
    // `unique_writer_identity` field.
    virtual ::grpc::Status UpdateSink(::grpc::ClientContext* context, const ::google::logging::v2::UpdateSinkRequest& request, ::google::logging::v2::LogSink* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::LogSink>> AsyncUpdateSink(::grpc::ClientContext* context, const ::google::logging::v2::UpdateSinkRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::LogSink>>(AsyncUpdateSinkRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::LogSink>> PrepareAsyncUpdateSink(::grpc::ClientContext* context, const ::google::logging::v2::UpdateSinkRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::LogSink>>(PrepareAsyncUpdateSinkRaw(context, request, cq));
    }
    // Deletes a sink. If the sink has a unique `writer_identity`, then that
    // service account is also deleted.
    virtual ::grpc::Status DeleteSink(::grpc::ClientContext* context, const ::google::logging::v2::DeleteSinkRequest& request, ::google::protobuf::Empty* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>> AsyncDeleteSink(::grpc::ClientContext* context, const ::google::logging::v2::DeleteSinkRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>>(AsyncDeleteSinkRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>> PrepareAsyncDeleteSink(::grpc::ClientContext* context, const ::google::logging::v2::DeleteSinkRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>>(PrepareAsyncDeleteSinkRaw(context, request, cq));
    }
    // Lists all the exclusions on the _Default sink in a parent resource.
    virtual ::grpc::Status ListExclusions(::grpc::ClientContext* context, const ::google::logging::v2::ListExclusionsRequest& request, ::google::logging::v2::ListExclusionsResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::ListExclusionsResponse>> AsyncListExclusions(::grpc::ClientContext* context, const ::google::logging::v2::ListExclusionsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::ListExclusionsResponse>>(AsyncListExclusionsRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::ListExclusionsResponse>> PrepareAsyncListExclusions(::grpc::ClientContext* context, const ::google::logging::v2::ListExclusionsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::ListExclusionsResponse>>(PrepareAsyncListExclusionsRaw(context, request, cq));
    }
    // Gets the description of an exclusion in the _Default sink.
    virtual ::grpc::Status GetExclusion(::grpc::ClientContext* context, const ::google::logging::v2::GetExclusionRequest& request, ::google::logging::v2::LogExclusion* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::LogExclusion>> AsyncGetExclusion(::grpc::ClientContext* context, const ::google::logging::v2::GetExclusionRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::LogExclusion>>(AsyncGetExclusionRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::LogExclusion>> PrepareAsyncGetExclusion(::grpc::ClientContext* context, const ::google::logging::v2::GetExclusionRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::LogExclusion>>(PrepareAsyncGetExclusionRaw(context, request, cq));
    }
    // Creates a new exclusion in the _Default sink in a specified parent
    // resource. Only log entries belonging to that resource can be excluded. You
    // can have up to 10 exclusions in a resource.
    virtual ::grpc::Status CreateExclusion(::grpc::ClientContext* context, const ::google::logging::v2::CreateExclusionRequest& request, ::google::logging::v2::LogExclusion* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::LogExclusion>> AsyncCreateExclusion(::grpc::ClientContext* context, const ::google::logging::v2::CreateExclusionRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::LogExclusion>>(AsyncCreateExclusionRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::LogExclusion>> PrepareAsyncCreateExclusion(::grpc::ClientContext* context, const ::google::logging::v2::CreateExclusionRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::LogExclusion>>(PrepareAsyncCreateExclusionRaw(context, request, cq));
    }
    // Changes one or more properties of an existing exclusion in the _Default
    // sink.
    virtual ::grpc::Status UpdateExclusion(::grpc::ClientContext* context, const ::google::logging::v2::UpdateExclusionRequest& request, ::google::logging::v2::LogExclusion* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::LogExclusion>> AsyncUpdateExclusion(::grpc::ClientContext* context, const ::google::logging::v2::UpdateExclusionRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::LogExclusion>>(AsyncUpdateExclusionRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::LogExclusion>> PrepareAsyncUpdateExclusion(::grpc::ClientContext* context, const ::google::logging::v2::UpdateExclusionRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::LogExclusion>>(PrepareAsyncUpdateExclusionRaw(context, request, cq));
    }
    // Deletes an exclusion in the _Default sink.
    virtual ::grpc::Status DeleteExclusion(::grpc::ClientContext* context, const ::google::logging::v2::DeleteExclusionRequest& request, ::google::protobuf::Empty* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>> AsyncDeleteExclusion(::grpc::ClientContext* context, const ::google::logging::v2::DeleteExclusionRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>>(AsyncDeleteExclusionRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>> PrepareAsyncDeleteExclusion(::grpc::ClientContext* context, const ::google::logging::v2::DeleteExclusionRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>>(PrepareAsyncDeleteExclusionRaw(context, request, cq));
    }
    // Gets the Logging CMEK settings for the given resource.
    //
    // Note: CMEK for the Log Router can be configured for Google Cloud projects,
    // folders, organizations and billing accounts. Once configured for an
    // organization, it applies to all projects and folders in the Google Cloud
    // organization.
    //
    // See [Enabling CMEK for Log
    // Router](https://cloud.google.com/logging/docs/routing/managed-encryption)
    // for more information.
    virtual ::grpc::Status GetCmekSettings(::grpc::ClientContext* context, const ::google::logging::v2::GetCmekSettingsRequest& request, ::google::logging::v2::CmekSettings* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::CmekSettings>> AsyncGetCmekSettings(::grpc::ClientContext* context, const ::google::logging::v2::GetCmekSettingsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::CmekSettings>>(AsyncGetCmekSettingsRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::CmekSettings>> PrepareAsyncGetCmekSettings(::grpc::ClientContext* context, const ::google::logging::v2::GetCmekSettingsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::CmekSettings>>(PrepareAsyncGetCmekSettingsRaw(context, request, cq));
    }
    // Updates the Log Router CMEK settings for the given resource.
    //
    // Note: CMEK for the Log Router can currently only be configured for Google
    // Cloud organizations. Once configured, it applies to all projects and
    // folders in the Google Cloud organization.
    //
    // [UpdateCmekSettings][google.logging.v2.ConfigServiceV2.UpdateCmekSettings]
    // will fail if 1) `kms_key_name` is invalid, or 2) the associated service
    // account does not have the required
    // `roles/cloudkms.cryptoKeyEncrypterDecrypter` role assigned for the key, or
    // 3) access to the key is disabled.
    //
    // See [Enabling CMEK for Log
    // Router](https://cloud.google.com/logging/docs/routing/managed-encryption)
    // for more information.
    virtual ::grpc::Status UpdateCmekSettings(::grpc::ClientContext* context, const ::google::logging::v2::UpdateCmekSettingsRequest& request, ::google::logging::v2::CmekSettings* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::CmekSettings>> AsyncUpdateCmekSettings(::grpc::ClientContext* context, const ::google::logging::v2::UpdateCmekSettingsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::CmekSettings>>(AsyncUpdateCmekSettingsRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::CmekSettings>> PrepareAsyncUpdateCmekSettings(::grpc::ClientContext* context, const ::google::logging::v2::UpdateCmekSettingsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::CmekSettings>>(PrepareAsyncUpdateCmekSettingsRaw(context, request, cq));
    }
    // Gets the Log Router settings for the given resource.
    //
    // Note: Settings for the Log Router can be get for Google Cloud projects,
    // folders, organizations and billing accounts. Currently it can only be
    // configured for organizations. Once configured for an organization, it
    // applies to all projects and folders in the Google Cloud organization.
    //
    // See [Enabling CMEK for Log
    // Router](https://cloud.google.com/logging/docs/routing/managed-encryption)
    // for more information.
    virtual ::grpc::Status GetSettings(::grpc::ClientContext* context, const ::google::logging::v2::GetSettingsRequest& request, ::google::logging::v2::Settings* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::Settings>> AsyncGetSettings(::grpc::ClientContext* context, const ::google::logging::v2::GetSettingsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::Settings>>(AsyncGetSettingsRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::Settings>> PrepareAsyncGetSettings(::grpc::ClientContext* context, const ::google::logging::v2::GetSettingsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::Settings>>(PrepareAsyncGetSettingsRaw(context, request, cq));
    }
    // Updates the Log Router settings for the given resource.
    //
    // Note: Settings for the Log Router can currently only be configured for
    // Google Cloud organizations. Once configured, it applies to all projects and
    // folders in the Google Cloud organization.
    //
    // [UpdateSettings][google.logging.v2.ConfigServiceV2.UpdateSettings]
    // will fail if 1) `kms_key_name` is invalid, or 2) the associated service
    // account does not have the required
    // `roles/cloudkms.cryptoKeyEncrypterDecrypter` role assigned for the key, or
    // 3) access to the key is disabled. 4) `location_id` is not supported by
    // Logging. 5) `location_id` violate OrgPolicy.
    //
    // See [Enabling CMEK for Log
    // Router](https://cloud.google.com/logging/docs/routing/managed-encryption)
    // for more information.
    virtual ::grpc::Status UpdateSettings(::grpc::ClientContext* context, const ::google::logging::v2::UpdateSettingsRequest& request, ::google::logging::v2::Settings* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::Settings>> AsyncUpdateSettings(::grpc::ClientContext* context, const ::google::logging::v2::UpdateSettingsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::Settings>>(AsyncUpdateSettingsRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::Settings>> PrepareAsyncUpdateSettings(::grpc::ClientContext* context, const ::google::logging::v2::UpdateSettingsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::Settings>>(PrepareAsyncUpdateSettingsRaw(context, request, cq));
    }
    // Copies a set of log entries from a log bucket to a Cloud Storage bucket.
    virtual ::grpc::Status CopyLogEntries(::grpc::ClientContext* context, const ::google::logging::v2::CopyLogEntriesRequest& request, ::google::longrunning::Operation* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>> AsyncCopyLogEntries(::grpc::ClientContext* context, const ::google::logging::v2::CopyLogEntriesRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>>(AsyncCopyLogEntriesRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>> PrepareAsyncCopyLogEntries(::grpc::ClientContext* context, const ::google::logging::v2::CopyLogEntriesRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>>(PrepareAsyncCopyLogEntriesRaw(context, request, cq));
    }
    class async_interface {
     public:
      virtual ~async_interface() {}
      // Lists log buckets.
      virtual void ListBuckets(::grpc::ClientContext* context, const ::google::logging::v2::ListBucketsRequest* request, ::google::logging::v2::ListBucketsResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void ListBuckets(::grpc::ClientContext* context, const ::google::logging::v2::ListBucketsRequest* request, ::google::logging::v2::ListBucketsResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Gets a log bucket.
      virtual void GetBucket(::grpc::ClientContext* context, const ::google::logging::v2::GetBucketRequest* request, ::google::logging::v2::LogBucket* response, std::function<void(::grpc::Status)>) = 0;
      virtual void GetBucket(::grpc::ClientContext* context, const ::google::logging::v2::GetBucketRequest* request, ::google::logging::v2::LogBucket* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Creates a log bucket that can be used to store log entries. After a bucket
      // has been created, the bucket's location cannot be changed.
      virtual void CreateBucket(::grpc::ClientContext* context, const ::google::logging::v2::CreateBucketRequest* request, ::google::logging::v2::LogBucket* response, std::function<void(::grpc::Status)>) = 0;
      virtual void CreateBucket(::grpc::ClientContext* context, const ::google::logging::v2::CreateBucketRequest* request, ::google::logging::v2::LogBucket* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Updates a log bucket. This method replaces the following fields in the
      // existing bucket with values from the new bucket: `retention_period`
      //
      // If the retention period is decreased and the bucket is locked,
      // `FAILED_PRECONDITION` will be returned.
      //
      // If the bucket has a `lifecycle_state` of `DELETE_REQUESTED`, then
      // `FAILED_PRECONDITION` will be returned.
      //
      // After a bucket has been created, the bucket's location cannot be changed.
      virtual void UpdateBucket(::grpc::ClientContext* context, const ::google::logging::v2::UpdateBucketRequest* request, ::google::logging::v2::LogBucket* response, std::function<void(::grpc::Status)>) = 0;
      virtual void UpdateBucket(::grpc::ClientContext* context, const ::google::logging::v2::UpdateBucketRequest* request, ::google::logging::v2::LogBucket* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Deletes a log bucket.
      //
      // Changes the bucket's `lifecycle_state` to the `DELETE_REQUESTED` state.
      // After 7 days, the bucket will be purged and all log entries in the bucket
      // will be permanently deleted.
      virtual void DeleteBucket(::grpc::ClientContext* context, const ::google::logging::v2::DeleteBucketRequest* request, ::google::protobuf::Empty* response, std::function<void(::grpc::Status)>) = 0;
      virtual void DeleteBucket(::grpc::ClientContext* context, const ::google::logging::v2::DeleteBucketRequest* request, ::google::protobuf::Empty* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Undeletes a log bucket. A bucket that has been deleted can be undeleted
      // within the grace period of 7 days.
      virtual void UndeleteBucket(::grpc::ClientContext* context, const ::google::logging::v2::UndeleteBucketRequest* request, ::google::protobuf::Empty* response, std::function<void(::grpc::Status)>) = 0;
      virtual void UndeleteBucket(::grpc::ClientContext* context, const ::google::logging::v2::UndeleteBucketRequest* request, ::google::protobuf::Empty* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Lists views on a log bucket.
      virtual void ListViews(::grpc::ClientContext* context, const ::google::logging::v2::ListViewsRequest* request, ::google::logging::v2::ListViewsResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void ListViews(::grpc::ClientContext* context, const ::google::logging::v2::ListViewsRequest* request, ::google::logging::v2::ListViewsResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Gets a view on a log bucket..
      virtual void GetView(::grpc::ClientContext* context, const ::google::logging::v2::GetViewRequest* request, ::google::logging::v2::LogView* response, std::function<void(::grpc::Status)>) = 0;
      virtual void GetView(::grpc::ClientContext* context, const ::google::logging::v2::GetViewRequest* request, ::google::logging::v2::LogView* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Creates a view over log entries in a log bucket. A bucket may contain a
      // maximum of 30 views.
      virtual void CreateView(::grpc::ClientContext* context, const ::google::logging::v2::CreateViewRequest* request, ::google::logging::v2::LogView* response, std::function<void(::grpc::Status)>) = 0;
      virtual void CreateView(::grpc::ClientContext* context, const ::google::logging::v2::CreateViewRequest* request, ::google::logging::v2::LogView* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Updates a view on a log bucket. This method replaces the following fields
      // in the existing view with values from the new view: `filter`.
      // If an `UNAVAILABLE` error is returned, this indicates that system is not in
      // a state where it can update the view. If this occurs, please try again in a
      // few minutes.
      virtual void UpdateView(::grpc::ClientContext* context, const ::google::logging::v2::UpdateViewRequest* request, ::google::logging::v2::LogView* response, std::function<void(::grpc::Status)>) = 0;
      virtual void UpdateView(::grpc::ClientContext* context, const ::google::logging::v2::UpdateViewRequest* request, ::google::logging::v2::LogView* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Deletes a view on a log bucket.
      // If an `UNAVAILABLE` error is returned, this indicates that system is not in
      // a state where it can delete the view. If this occurs, please try again in a
      // few minutes.
      virtual void DeleteView(::grpc::ClientContext* context, const ::google::logging::v2::DeleteViewRequest* request, ::google::protobuf::Empty* response, std::function<void(::grpc::Status)>) = 0;
      virtual void DeleteView(::grpc::ClientContext* context, const ::google::logging::v2::DeleteViewRequest* request, ::google::protobuf::Empty* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Lists sinks.
      virtual void ListSinks(::grpc::ClientContext* context, const ::google::logging::v2::ListSinksRequest* request, ::google::logging::v2::ListSinksResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void ListSinks(::grpc::ClientContext* context, const ::google::logging::v2::ListSinksRequest* request, ::google::logging::v2::ListSinksResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Gets a sink.
      virtual void GetSink(::grpc::ClientContext* context, const ::google::logging::v2::GetSinkRequest* request, ::google::logging::v2::LogSink* response, std::function<void(::grpc::Status)>) = 0;
      virtual void GetSink(::grpc::ClientContext* context, const ::google::logging::v2::GetSinkRequest* request, ::google::logging::v2::LogSink* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Creates a sink that exports specified log entries to a destination. The
      // export of newly-ingested log entries begins immediately, unless the sink's
      // `writer_identity` is not permitted to write to the destination. A sink can
      // export log entries only from the resource owning the sink.
      virtual void CreateSink(::grpc::ClientContext* context, const ::google::logging::v2::CreateSinkRequest* request, ::google::logging::v2::LogSink* response, std::function<void(::grpc::Status)>) = 0;
      virtual void CreateSink(::grpc::ClientContext* context, const ::google::logging::v2::CreateSinkRequest* request, ::google::logging::v2::LogSink* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Updates a sink. This method replaces the following fields in the existing
      // sink with values from the new sink: `destination`, and `filter`.
      //
      // The updated sink might also have a new `writer_identity`; see the
      // `unique_writer_identity` field.
      virtual void UpdateSink(::grpc::ClientContext* context, const ::google::logging::v2::UpdateSinkRequest* request, ::google::logging::v2::LogSink* response, std::function<void(::grpc::Status)>) = 0;
      virtual void UpdateSink(::grpc::ClientContext* context, const ::google::logging::v2::UpdateSinkRequest* request, ::google::logging::v2::LogSink* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Deletes a sink. If the sink has a unique `writer_identity`, then that
      // service account is also deleted.
      virtual void DeleteSink(::grpc::ClientContext* context, const ::google::logging::v2::DeleteSinkRequest* request, ::google::protobuf::Empty* response, std::function<void(::grpc::Status)>) = 0;
      virtual void DeleteSink(::grpc::ClientContext* context, const ::google::logging::v2::DeleteSinkRequest* request, ::google::protobuf::Empty* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Lists all the exclusions on the _Default sink in a parent resource.
      virtual void ListExclusions(::grpc::ClientContext* context, const ::google::logging::v2::ListExclusionsRequest* request, ::google::logging::v2::ListExclusionsResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void ListExclusions(::grpc::ClientContext* context, const ::google::logging::v2::ListExclusionsRequest* request, ::google::logging::v2::ListExclusionsResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Gets the description of an exclusion in the _Default sink.
      virtual void GetExclusion(::grpc::ClientContext* context, const ::google::logging::v2::GetExclusionRequest* request, ::google::logging::v2::LogExclusion* response, std::function<void(::grpc::Status)>) = 0;
      virtual void GetExclusion(::grpc::ClientContext* context, const ::google::logging::v2::GetExclusionRequest* request, ::google::logging::v2::LogExclusion* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Creates a new exclusion in the _Default sink in a specified parent
      // resource. Only log entries belonging to that resource can be excluded. You
      // can have up to 10 exclusions in a resource.
      virtual void CreateExclusion(::grpc::ClientContext* context, const ::google::logging::v2::CreateExclusionRequest* request, ::google::logging::v2::LogExclusion* response, std::function<void(::grpc::Status)>) = 0;
      virtual void CreateExclusion(::grpc::ClientContext* context, const ::google::logging::v2::CreateExclusionRequest* request, ::google::logging::v2::LogExclusion* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Changes one or more properties of an existing exclusion in the _Default
      // sink.
      virtual void UpdateExclusion(::grpc::ClientContext* context, const ::google::logging::v2::UpdateExclusionRequest* request, ::google::logging::v2::LogExclusion* response, std::function<void(::grpc::Status)>) = 0;
      virtual void UpdateExclusion(::grpc::ClientContext* context, const ::google::logging::v2::UpdateExclusionRequest* request, ::google::logging::v2::LogExclusion* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Deletes an exclusion in the _Default sink.
      virtual void DeleteExclusion(::grpc::ClientContext* context, const ::google::logging::v2::DeleteExclusionRequest* request, ::google::protobuf::Empty* response, std::function<void(::grpc::Status)>) = 0;
      virtual void DeleteExclusion(::grpc::ClientContext* context, const ::google::logging::v2::DeleteExclusionRequest* request, ::google::protobuf::Empty* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Gets the Logging CMEK settings for the given resource.
      //
      // Note: CMEK for the Log Router can be configured for Google Cloud projects,
      // folders, organizations and billing accounts. Once configured for an
      // organization, it applies to all projects and folders in the Google Cloud
      // organization.
      //
      // See [Enabling CMEK for Log
      // Router](https://cloud.google.com/logging/docs/routing/managed-encryption)
      // for more information.
      virtual void GetCmekSettings(::grpc::ClientContext* context, const ::google::logging::v2::GetCmekSettingsRequest* request, ::google::logging::v2::CmekSettings* response, std::function<void(::grpc::Status)>) = 0;
      virtual void GetCmekSettings(::grpc::ClientContext* context, const ::google::logging::v2::GetCmekSettingsRequest* request, ::google::logging::v2::CmekSettings* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Updates the Log Router CMEK settings for the given resource.
      //
      // Note: CMEK for the Log Router can currently only be configured for Google
      // Cloud organizations. Once configured, it applies to all projects and
      // folders in the Google Cloud organization.
      //
      // [UpdateCmekSettings][google.logging.v2.ConfigServiceV2.UpdateCmekSettings]
      // will fail if 1) `kms_key_name` is invalid, or 2) the associated service
      // account does not have the required
      // `roles/cloudkms.cryptoKeyEncrypterDecrypter` role assigned for the key, or
      // 3) access to the key is disabled.
      //
      // See [Enabling CMEK for Log
      // Router](https://cloud.google.com/logging/docs/routing/managed-encryption)
      // for more information.
      virtual void UpdateCmekSettings(::grpc::ClientContext* context, const ::google::logging::v2::UpdateCmekSettingsRequest* request, ::google::logging::v2::CmekSettings* response, std::function<void(::grpc::Status)>) = 0;
      virtual void UpdateCmekSettings(::grpc::ClientContext* context, const ::google::logging::v2::UpdateCmekSettingsRequest* request, ::google::logging::v2::CmekSettings* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Gets the Log Router settings for the given resource.
      //
      // Note: Settings for the Log Router can be get for Google Cloud projects,
      // folders, organizations and billing accounts. Currently it can only be
      // configured for organizations. Once configured for an organization, it
      // applies to all projects and folders in the Google Cloud organization.
      //
      // See [Enabling CMEK for Log
      // Router](https://cloud.google.com/logging/docs/routing/managed-encryption)
      // for more information.
      virtual void GetSettings(::grpc::ClientContext* context, const ::google::logging::v2::GetSettingsRequest* request, ::google::logging::v2::Settings* response, std::function<void(::grpc::Status)>) = 0;
      virtual void GetSettings(::grpc::ClientContext* context, const ::google::logging::v2::GetSettingsRequest* request, ::google::logging::v2::Settings* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Updates the Log Router settings for the given resource.
      //
      // Note: Settings for the Log Router can currently only be configured for
      // Google Cloud organizations. Once configured, it applies to all projects and
      // folders in the Google Cloud organization.
      //
      // [UpdateSettings][google.logging.v2.ConfigServiceV2.UpdateSettings]
      // will fail if 1) `kms_key_name` is invalid, or 2) the associated service
      // account does not have the required
      // `roles/cloudkms.cryptoKeyEncrypterDecrypter` role assigned for the key, or
      // 3) access to the key is disabled. 4) `location_id` is not supported by
      // Logging. 5) `location_id` violate OrgPolicy.
      //
      // See [Enabling CMEK for Log
      // Router](https://cloud.google.com/logging/docs/routing/managed-encryption)
      // for more information.
      virtual void UpdateSettings(::grpc::ClientContext* context, const ::google::logging::v2::UpdateSettingsRequest* request, ::google::logging::v2::Settings* response, std::function<void(::grpc::Status)>) = 0;
      virtual void UpdateSettings(::grpc::ClientContext* context, const ::google::logging::v2::UpdateSettingsRequest* request, ::google::logging::v2::Settings* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Copies a set of log entries from a log bucket to a Cloud Storage bucket.
      virtual void CopyLogEntries(::grpc::ClientContext* context, const ::google::logging::v2::CopyLogEntriesRequest* request, ::google::longrunning::Operation* response, std::function<void(::grpc::Status)>) = 0;
      virtual void CopyLogEntries(::grpc::ClientContext* context, const ::google::logging::v2::CopyLogEntriesRequest* request, ::google::longrunning::Operation* response, ::grpc::ClientUnaryReactor* reactor) = 0;
    };
    typedef class async_interface experimental_async_interface;
    virtual class async_interface* async() { return nullptr; }
    class async_interface* experimental_async() { return async(); }
   private:
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::ListBucketsResponse>* AsyncListBucketsRaw(::grpc::ClientContext* context, const ::google::logging::v2::ListBucketsRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::ListBucketsResponse>* PrepareAsyncListBucketsRaw(::grpc::ClientContext* context, const ::google::logging::v2::ListBucketsRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::LogBucket>* AsyncGetBucketRaw(::grpc::ClientContext* context, const ::google::logging::v2::GetBucketRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::LogBucket>* PrepareAsyncGetBucketRaw(::grpc::ClientContext* context, const ::google::logging::v2::GetBucketRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::LogBucket>* AsyncCreateBucketRaw(::grpc::ClientContext* context, const ::google::logging::v2::CreateBucketRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::LogBucket>* PrepareAsyncCreateBucketRaw(::grpc::ClientContext* context, const ::google::logging::v2::CreateBucketRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::LogBucket>* AsyncUpdateBucketRaw(::grpc::ClientContext* context, const ::google::logging::v2::UpdateBucketRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::LogBucket>* PrepareAsyncUpdateBucketRaw(::grpc::ClientContext* context, const ::google::logging::v2::UpdateBucketRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>* AsyncDeleteBucketRaw(::grpc::ClientContext* context, const ::google::logging::v2::DeleteBucketRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>* PrepareAsyncDeleteBucketRaw(::grpc::ClientContext* context, const ::google::logging::v2::DeleteBucketRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>* AsyncUndeleteBucketRaw(::grpc::ClientContext* context, const ::google::logging::v2::UndeleteBucketRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>* PrepareAsyncUndeleteBucketRaw(::grpc::ClientContext* context, const ::google::logging::v2::UndeleteBucketRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::ListViewsResponse>* AsyncListViewsRaw(::grpc::ClientContext* context, const ::google::logging::v2::ListViewsRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::ListViewsResponse>* PrepareAsyncListViewsRaw(::grpc::ClientContext* context, const ::google::logging::v2::ListViewsRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::LogView>* AsyncGetViewRaw(::grpc::ClientContext* context, const ::google::logging::v2::GetViewRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::LogView>* PrepareAsyncGetViewRaw(::grpc::ClientContext* context, const ::google::logging::v2::GetViewRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::LogView>* AsyncCreateViewRaw(::grpc::ClientContext* context, const ::google::logging::v2::CreateViewRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::LogView>* PrepareAsyncCreateViewRaw(::grpc::ClientContext* context, const ::google::logging::v2::CreateViewRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::LogView>* AsyncUpdateViewRaw(::grpc::ClientContext* context, const ::google::logging::v2::UpdateViewRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::LogView>* PrepareAsyncUpdateViewRaw(::grpc::ClientContext* context, const ::google::logging::v2::UpdateViewRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>* AsyncDeleteViewRaw(::grpc::ClientContext* context, const ::google::logging::v2::DeleteViewRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>* PrepareAsyncDeleteViewRaw(::grpc::ClientContext* context, const ::google::logging::v2::DeleteViewRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::ListSinksResponse>* AsyncListSinksRaw(::grpc::ClientContext* context, const ::google::logging::v2::ListSinksRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::ListSinksResponse>* PrepareAsyncListSinksRaw(::grpc::ClientContext* context, const ::google::logging::v2::ListSinksRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::LogSink>* AsyncGetSinkRaw(::grpc::ClientContext* context, const ::google::logging::v2::GetSinkRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::LogSink>* PrepareAsyncGetSinkRaw(::grpc::ClientContext* context, const ::google::logging::v2::GetSinkRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::LogSink>* AsyncCreateSinkRaw(::grpc::ClientContext* context, const ::google::logging::v2::CreateSinkRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::LogSink>* PrepareAsyncCreateSinkRaw(::grpc::ClientContext* context, const ::google::logging::v2::CreateSinkRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::LogSink>* AsyncUpdateSinkRaw(::grpc::ClientContext* context, const ::google::logging::v2::UpdateSinkRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::LogSink>* PrepareAsyncUpdateSinkRaw(::grpc::ClientContext* context, const ::google::logging::v2::UpdateSinkRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>* AsyncDeleteSinkRaw(::grpc::ClientContext* context, const ::google::logging::v2::DeleteSinkRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>* PrepareAsyncDeleteSinkRaw(::grpc::ClientContext* context, const ::google::logging::v2::DeleteSinkRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::ListExclusionsResponse>* AsyncListExclusionsRaw(::grpc::ClientContext* context, const ::google::logging::v2::ListExclusionsRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::ListExclusionsResponse>* PrepareAsyncListExclusionsRaw(::grpc::ClientContext* context, const ::google::logging::v2::ListExclusionsRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::LogExclusion>* AsyncGetExclusionRaw(::grpc::ClientContext* context, const ::google::logging::v2::GetExclusionRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::LogExclusion>* PrepareAsyncGetExclusionRaw(::grpc::ClientContext* context, const ::google::logging::v2::GetExclusionRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::LogExclusion>* AsyncCreateExclusionRaw(::grpc::ClientContext* context, const ::google::logging::v2::CreateExclusionRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::LogExclusion>* PrepareAsyncCreateExclusionRaw(::grpc::ClientContext* context, const ::google::logging::v2::CreateExclusionRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::LogExclusion>* AsyncUpdateExclusionRaw(::grpc::ClientContext* context, const ::google::logging::v2::UpdateExclusionRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::LogExclusion>* PrepareAsyncUpdateExclusionRaw(::grpc::ClientContext* context, const ::google::logging::v2::UpdateExclusionRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>* AsyncDeleteExclusionRaw(::grpc::ClientContext* context, const ::google::logging::v2::DeleteExclusionRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>* PrepareAsyncDeleteExclusionRaw(::grpc::ClientContext* context, const ::google::logging::v2::DeleteExclusionRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::CmekSettings>* AsyncGetCmekSettingsRaw(::grpc::ClientContext* context, const ::google::logging::v2::GetCmekSettingsRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::CmekSettings>* PrepareAsyncGetCmekSettingsRaw(::grpc::ClientContext* context, const ::google::logging::v2::GetCmekSettingsRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::CmekSettings>* AsyncUpdateCmekSettingsRaw(::grpc::ClientContext* context, const ::google::logging::v2::UpdateCmekSettingsRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::CmekSettings>* PrepareAsyncUpdateCmekSettingsRaw(::grpc::ClientContext* context, const ::google::logging::v2::UpdateCmekSettingsRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::Settings>* AsyncGetSettingsRaw(::grpc::ClientContext* context, const ::google::logging::v2::GetSettingsRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::Settings>* PrepareAsyncGetSettingsRaw(::grpc::ClientContext* context, const ::google::logging::v2::GetSettingsRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::Settings>* AsyncUpdateSettingsRaw(::grpc::ClientContext* context, const ::google::logging::v2::UpdateSettingsRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::logging::v2::Settings>* PrepareAsyncUpdateSettingsRaw(::grpc::ClientContext* context, const ::google::logging::v2::UpdateSettingsRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>* AsyncCopyLogEntriesRaw(::grpc::ClientContext* context, const ::google::logging::v2::CopyLogEntriesRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>* PrepareAsyncCopyLogEntriesRaw(::grpc::ClientContext* context, const ::google::logging::v2::CopyLogEntriesRequest& request, ::grpc::CompletionQueue* cq) = 0;
  };
  class Stub final : public StubInterface {
   public:
    Stub(const std::shared_ptr< ::grpc::ChannelInterface>& channel, const ::grpc::StubOptions& options = ::grpc::StubOptions());
    ::grpc::Status ListBuckets(::grpc::ClientContext* context, const ::google::logging::v2::ListBucketsRequest& request, ::google::logging::v2::ListBucketsResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::ListBucketsResponse>> AsyncListBuckets(::grpc::ClientContext* context, const ::google::logging::v2::ListBucketsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::ListBucketsResponse>>(AsyncListBucketsRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::ListBucketsResponse>> PrepareAsyncListBuckets(::grpc::ClientContext* context, const ::google::logging::v2::ListBucketsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::ListBucketsResponse>>(PrepareAsyncListBucketsRaw(context, request, cq));
    }
    ::grpc::Status GetBucket(::grpc::ClientContext* context, const ::google::logging::v2::GetBucketRequest& request, ::google::logging::v2::LogBucket* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::LogBucket>> AsyncGetBucket(::grpc::ClientContext* context, const ::google::logging::v2::GetBucketRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::LogBucket>>(AsyncGetBucketRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::LogBucket>> PrepareAsyncGetBucket(::grpc::ClientContext* context, const ::google::logging::v2::GetBucketRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::LogBucket>>(PrepareAsyncGetBucketRaw(context, request, cq));
    }
    ::grpc::Status CreateBucket(::grpc::ClientContext* context, const ::google::logging::v2::CreateBucketRequest& request, ::google::logging::v2::LogBucket* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::LogBucket>> AsyncCreateBucket(::grpc::ClientContext* context, const ::google::logging::v2::CreateBucketRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::LogBucket>>(AsyncCreateBucketRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::LogBucket>> PrepareAsyncCreateBucket(::grpc::ClientContext* context, const ::google::logging::v2::CreateBucketRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::LogBucket>>(PrepareAsyncCreateBucketRaw(context, request, cq));
    }
    ::grpc::Status UpdateBucket(::grpc::ClientContext* context, const ::google::logging::v2::UpdateBucketRequest& request, ::google::logging::v2::LogBucket* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::LogBucket>> AsyncUpdateBucket(::grpc::ClientContext* context, const ::google::logging::v2::UpdateBucketRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::LogBucket>>(AsyncUpdateBucketRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::LogBucket>> PrepareAsyncUpdateBucket(::grpc::ClientContext* context, const ::google::logging::v2::UpdateBucketRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::LogBucket>>(PrepareAsyncUpdateBucketRaw(context, request, cq));
    }
    ::grpc::Status DeleteBucket(::grpc::ClientContext* context, const ::google::logging::v2::DeleteBucketRequest& request, ::google::protobuf::Empty* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>> AsyncDeleteBucket(::grpc::ClientContext* context, const ::google::logging::v2::DeleteBucketRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>>(AsyncDeleteBucketRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>> PrepareAsyncDeleteBucket(::grpc::ClientContext* context, const ::google::logging::v2::DeleteBucketRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>>(PrepareAsyncDeleteBucketRaw(context, request, cq));
    }
    ::grpc::Status UndeleteBucket(::grpc::ClientContext* context, const ::google::logging::v2::UndeleteBucketRequest& request, ::google::protobuf::Empty* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>> AsyncUndeleteBucket(::grpc::ClientContext* context, const ::google::logging::v2::UndeleteBucketRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>>(AsyncUndeleteBucketRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>> PrepareAsyncUndeleteBucket(::grpc::ClientContext* context, const ::google::logging::v2::UndeleteBucketRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>>(PrepareAsyncUndeleteBucketRaw(context, request, cq));
    }
    ::grpc::Status ListViews(::grpc::ClientContext* context, const ::google::logging::v2::ListViewsRequest& request, ::google::logging::v2::ListViewsResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::ListViewsResponse>> AsyncListViews(::grpc::ClientContext* context, const ::google::logging::v2::ListViewsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::ListViewsResponse>>(AsyncListViewsRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::ListViewsResponse>> PrepareAsyncListViews(::grpc::ClientContext* context, const ::google::logging::v2::ListViewsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::ListViewsResponse>>(PrepareAsyncListViewsRaw(context, request, cq));
    }
    ::grpc::Status GetView(::grpc::ClientContext* context, const ::google::logging::v2::GetViewRequest& request, ::google::logging::v2::LogView* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::LogView>> AsyncGetView(::grpc::ClientContext* context, const ::google::logging::v2::GetViewRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::LogView>>(AsyncGetViewRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::LogView>> PrepareAsyncGetView(::grpc::ClientContext* context, const ::google::logging::v2::GetViewRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::LogView>>(PrepareAsyncGetViewRaw(context, request, cq));
    }
    ::grpc::Status CreateView(::grpc::ClientContext* context, const ::google::logging::v2::CreateViewRequest& request, ::google::logging::v2::LogView* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::LogView>> AsyncCreateView(::grpc::ClientContext* context, const ::google::logging::v2::CreateViewRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::LogView>>(AsyncCreateViewRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::LogView>> PrepareAsyncCreateView(::grpc::ClientContext* context, const ::google::logging::v2::CreateViewRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::LogView>>(PrepareAsyncCreateViewRaw(context, request, cq));
    }
    ::grpc::Status UpdateView(::grpc::ClientContext* context, const ::google::logging::v2::UpdateViewRequest& request, ::google::logging::v2::LogView* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::LogView>> AsyncUpdateView(::grpc::ClientContext* context, const ::google::logging::v2::UpdateViewRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::LogView>>(AsyncUpdateViewRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::LogView>> PrepareAsyncUpdateView(::grpc::ClientContext* context, const ::google::logging::v2::UpdateViewRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::LogView>>(PrepareAsyncUpdateViewRaw(context, request, cq));
    }
    ::grpc::Status DeleteView(::grpc::ClientContext* context, const ::google::logging::v2::DeleteViewRequest& request, ::google::protobuf::Empty* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>> AsyncDeleteView(::grpc::ClientContext* context, const ::google::logging::v2::DeleteViewRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>>(AsyncDeleteViewRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>> PrepareAsyncDeleteView(::grpc::ClientContext* context, const ::google::logging::v2::DeleteViewRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>>(PrepareAsyncDeleteViewRaw(context, request, cq));
    }
    ::grpc::Status ListSinks(::grpc::ClientContext* context, const ::google::logging::v2::ListSinksRequest& request, ::google::logging::v2::ListSinksResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::ListSinksResponse>> AsyncListSinks(::grpc::ClientContext* context, const ::google::logging::v2::ListSinksRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::ListSinksResponse>>(AsyncListSinksRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::ListSinksResponse>> PrepareAsyncListSinks(::grpc::ClientContext* context, const ::google::logging::v2::ListSinksRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::ListSinksResponse>>(PrepareAsyncListSinksRaw(context, request, cq));
    }
    ::grpc::Status GetSink(::grpc::ClientContext* context, const ::google::logging::v2::GetSinkRequest& request, ::google::logging::v2::LogSink* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::LogSink>> AsyncGetSink(::grpc::ClientContext* context, const ::google::logging::v2::GetSinkRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::LogSink>>(AsyncGetSinkRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::LogSink>> PrepareAsyncGetSink(::grpc::ClientContext* context, const ::google::logging::v2::GetSinkRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::LogSink>>(PrepareAsyncGetSinkRaw(context, request, cq));
    }
    ::grpc::Status CreateSink(::grpc::ClientContext* context, const ::google::logging::v2::CreateSinkRequest& request, ::google::logging::v2::LogSink* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::LogSink>> AsyncCreateSink(::grpc::ClientContext* context, const ::google::logging::v2::CreateSinkRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::LogSink>>(AsyncCreateSinkRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::LogSink>> PrepareAsyncCreateSink(::grpc::ClientContext* context, const ::google::logging::v2::CreateSinkRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::LogSink>>(PrepareAsyncCreateSinkRaw(context, request, cq));
    }
    ::grpc::Status UpdateSink(::grpc::ClientContext* context, const ::google::logging::v2::UpdateSinkRequest& request, ::google::logging::v2::LogSink* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::LogSink>> AsyncUpdateSink(::grpc::ClientContext* context, const ::google::logging::v2::UpdateSinkRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::LogSink>>(AsyncUpdateSinkRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::LogSink>> PrepareAsyncUpdateSink(::grpc::ClientContext* context, const ::google::logging::v2::UpdateSinkRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::LogSink>>(PrepareAsyncUpdateSinkRaw(context, request, cq));
    }
    ::grpc::Status DeleteSink(::grpc::ClientContext* context, const ::google::logging::v2::DeleteSinkRequest& request, ::google::protobuf::Empty* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>> AsyncDeleteSink(::grpc::ClientContext* context, const ::google::logging::v2::DeleteSinkRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>>(AsyncDeleteSinkRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>> PrepareAsyncDeleteSink(::grpc::ClientContext* context, const ::google::logging::v2::DeleteSinkRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>>(PrepareAsyncDeleteSinkRaw(context, request, cq));
    }
    ::grpc::Status ListExclusions(::grpc::ClientContext* context, const ::google::logging::v2::ListExclusionsRequest& request, ::google::logging::v2::ListExclusionsResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::ListExclusionsResponse>> AsyncListExclusions(::grpc::ClientContext* context, const ::google::logging::v2::ListExclusionsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::ListExclusionsResponse>>(AsyncListExclusionsRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::ListExclusionsResponse>> PrepareAsyncListExclusions(::grpc::ClientContext* context, const ::google::logging::v2::ListExclusionsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::ListExclusionsResponse>>(PrepareAsyncListExclusionsRaw(context, request, cq));
    }
    ::grpc::Status GetExclusion(::grpc::ClientContext* context, const ::google::logging::v2::GetExclusionRequest& request, ::google::logging::v2::LogExclusion* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::LogExclusion>> AsyncGetExclusion(::grpc::ClientContext* context, const ::google::logging::v2::GetExclusionRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::LogExclusion>>(AsyncGetExclusionRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::LogExclusion>> PrepareAsyncGetExclusion(::grpc::ClientContext* context, const ::google::logging::v2::GetExclusionRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::LogExclusion>>(PrepareAsyncGetExclusionRaw(context, request, cq));
    }
    ::grpc::Status CreateExclusion(::grpc::ClientContext* context, const ::google::logging::v2::CreateExclusionRequest& request, ::google::logging::v2::LogExclusion* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::LogExclusion>> AsyncCreateExclusion(::grpc::ClientContext* context, const ::google::logging::v2::CreateExclusionRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::LogExclusion>>(AsyncCreateExclusionRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::LogExclusion>> PrepareAsyncCreateExclusion(::grpc::ClientContext* context, const ::google::logging::v2::CreateExclusionRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::LogExclusion>>(PrepareAsyncCreateExclusionRaw(context, request, cq));
    }
    ::grpc::Status UpdateExclusion(::grpc::ClientContext* context, const ::google::logging::v2::UpdateExclusionRequest& request, ::google::logging::v2::LogExclusion* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::LogExclusion>> AsyncUpdateExclusion(::grpc::ClientContext* context, const ::google::logging::v2::UpdateExclusionRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::LogExclusion>>(AsyncUpdateExclusionRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::LogExclusion>> PrepareAsyncUpdateExclusion(::grpc::ClientContext* context, const ::google::logging::v2::UpdateExclusionRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::LogExclusion>>(PrepareAsyncUpdateExclusionRaw(context, request, cq));
    }
    ::grpc::Status DeleteExclusion(::grpc::ClientContext* context, const ::google::logging::v2::DeleteExclusionRequest& request, ::google::protobuf::Empty* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>> AsyncDeleteExclusion(::grpc::ClientContext* context, const ::google::logging::v2::DeleteExclusionRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>>(AsyncDeleteExclusionRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>> PrepareAsyncDeleteExclusion(::grpc::ClientContext* context, const ::google::logging::v2::DeleteExclusionRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>>(PrepareAsyncDeleteExclusionRaw(context, request, cq));
    }
    ::grpc::Status GetCmekSettings(::grpc::ClientContext* context, const ::google::logging::v2::GetCmekSettingsRequest& request, ::google::logging::v2::CmekSettings* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::CmekSettings>> AsyncGetCmekSettings(::grpc::ClientContext* context, const ::google::logging::v2::GetCmekSettingsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::CmekSettings>>(AsyncGetCmekSettingsRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::CmekSettings>> PrepareAsyncGetCmekSettings(::grpc::ClientContext* context, const ::google::logging::v2::GetCmekSettingsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::CmekSettings>>(PrepareAsyncGetCmekSettingsRaw(context, request, cq));
    }
    ::grpc::Status UpdateCmekSettings(::grpc::ClientContext* context, const ::google::logging::v2::UpdateCmekSettingsRequest& request, ::google::logging::v2::CmekSettings* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::CmekSettings>> AsyncUpdateCmekSettings(::grpc::ClientContext* context, const ::google::logging::v2::UpdateCmekSettingsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::CmekSettings>>(AsyncUpdateCmekSettingsRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::CmekSettings>> PrepareAsyncUpdateCmekSettings(::grpc::ClientContext* context, const ::google::logging::v2::UpdateCmekSettingsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::CmekSettings>>(PrepareAsyncUpdateCmekSettingsRaw(context, request, cq));
    }
    ::grpc::Status GetSettings(::grpc::ClientContext* context, const ::google::logging::v2::GetSettingsRequest& request, ::google::logging::v2::Settings* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::Settings>> AsyncGetSettings(::grpc::ClientContext* context, const ::google::logging::v2::GetSettingsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::Settings>>(AsyncGetSettingsRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::Settings>> PrepareAsyncGetSettings(::grpc::ClientContext* context, const ::google::logging::v2::GetSettingsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::Settings>>(PrepareAsyncGetSettingsRaw(context, request, cq));
    }
    ::grpc::Status UpdateSettings(::grpc::ClientContext* context, const ::google::logging::v2::UpdateSettingsRequest& request, ::google::logging::v2::Settings* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::Settings>> AsyncUpdateSettings(::grpc::ClientContext* context, const ::google::logging::v2::UpdateSettingsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::Settings>>(AsyncUpdateSettingsRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::Settings>> PrepareAsyncUpdateSettings(::grpc::ClientContext* context, const ::google::logging::v2::UpdateSettingsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::logging::v2::Settings>>(PrepareAsyncUpdateSettingsRaw(context, request, cq));
    }
    ::grpc::Status CopyLogEntries(::grpc::ClientContext* context, const ::google::logging::v2::CopyLogEntriesRequest& request, ::google::longrunning::Operation* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>> AsyncCopyLogEntries(::grpc::ClientContext* context, const ::google::logging::v2::CopyLogEntriesRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>>(AsyncCopyLogEntriesRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>> PrepareAsyncCopyLogEntries(::grpc::ClientContext* context, const ::google::logging::v2::CopyLogEntriesRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>>(PrepareAsyncCopyLogEntriesRaw(context, request, cq));
    }
    class async final :
      public StubInterface::async_interface {
     public:
      void ListBuckets(::grpc::ClientContext* context, const ::google::logging::v2::ListBucketsRequest* request, ::google::logging::v2::ListBucketsResponse* response, std::function<void(::grpc::Status)>) override;
      void ListBuckets(::grpc::ClientContext* context, const ::google::logging::v2::ListBucketsRequest* request, ::google::logging::v2::ListBucketsResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
      void GetBucket(::grpc::ClientContext* context, const ::google::logging::v2::GetBucketRequest* request, ::google::logging::v2::LogBucket* response, std::function<void(::grpc::Status)>) override;
      void GetBucket(::grpc::ClientContext* context, const ::google::logging::v2::GetBucketRequest* request, ::google::logging::v2::LogBucket* response, ::grpc::ClientUnaryReactor* reactor) override;
      void CreateBucket(::grpc::ClientContext* context, const ::google::logging::v2::CreateBucketRequest* request, ::google::logging::v2::LogBucket* response, std::function<void(::grpc::Status)>) override;
      void CreateBucket(::grpc::ClientContext* context, const ::google::logging::v2::CreateBucketRequest* request, ::google::logging::v2::LogBucket* response, ::grpc::ClientUnaryReactor* reactor) override;
      void UpdateBucket(::grpc::ClientContext* context, const ::google::logging::v2::UpdateBucketRequest* request, ::google::logging::v2::LogBucket* response, std::function<void(::grpc::Status)>) override;
      void UpdateBucket(::grpc::ClientContext* context, const ::google::logging::v2::UpdateBucketRequest* request, ::google::logging::v2::LogBucket* response, ::grpc::ClientUnaryReactor* reactor) override;
      void DeleteBucket(::grpc::ClientContext* context, const ::google::logging::v2::DeleteBucketRequest* request, ::google::protobuf::Empty* response, std::function<void(::grpc::Status)>) override;
      void DeleteBucket(::grpc::ClientContext* context, const ::google::logging::v2::DeleteBucketRequest* request, ::google::protobuf::Empty* response, ::grpc::ClientUnaryReactor* reactor) override;
      void UndeleteBucket(::grpc::ClientContext* context, const ::google::logging::v2::UndeleteBucketRequest* request, ::google::protobuf::Empty* response, std::function<void(::grpc::Status)>) override;
      void UndeleteBucket(::grpc::ClientContext* context, const ::google::logging::v2::UndeleteBucketRequest* request, ::google::protobuf::Empty* response, ::grpc::ClientUnaryReactor* reactor) override;
      void ListViews(::grpc::ClientContext* context, const ::google::logging::v2::ListViewsRequest* request, ::google::logging::v2::ListViewsResponse* response, std::function<void(::grpc::Status)>) override;
      void ListViews(::grpc::ClientContext* context, const ::google::logging::v2::ListViewsRequest* request, ::google::logging::v2::ListViewsResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
      void GetView(::grpc::ClientContext* context, const ::google::logging::v2::GetViewRequest* request, ::google::logging::v2::LogView* response, std::function<void(::grpc::Status)>) override;
      void GetView(::grpc::ClientContext* context, const ::google::logging::v2::GetViewRequest* request, ::google::logging::v2::LogView* response, ::grpc::ClientUnaryReactor* reactor) override;
      void CreateView(::grpc::ClientContext* context, const ::google::logging::v2::CreateViewRequest* request, ::google::logging::v2::LogView* response, std::function<void(::grpc::Status)>) override;
      void CreateView(::grpc::ClientContext* context, const ::google::logging::v2::CreateViewRequest* request, ::google::logging::v2::LogView* response, ::grpc::ClientUnaryReactor* reactor) override;
      void UpdateView(::grpc::ClientContext* context, const ::google::logging::v2::UpdateViewRequest* request, ::google::logging::v2::LogView* response, std::function<void(::grpc::Status)>) override;
      void UpdateView(::grpc::ClientContext* context, const ::google::logging::v2::UpdateViewRequest* request, ::google::logging::v2::LogView* response, ::grpc::ClientUnaryReactor* reactor) override;
      void DeleteView(::grpc::ClientContext* context, const ::google::logging::v2::DeleteViewRequest* request, ::google::protobuf::Empty* response, std::function<void(::grpc::Status)>) override;
      void DeleteView(::grpc::ClientContext* context, const ::google::logging::v2::DeleteViewRequest* request, ::google::protobuf::Empty* response, ::grpc::ClientUnaryReactor* reactor) override;
      void ListSinks(::grpc::ClientContext* context, const ::google::logging::v2::ListSinksRequest* request, ::google::logging::v2::ListSinksResponse* response, std::function<void(::grpc::Status)>) override;
      void ListSinks(::grpc::ClientContext* context, const ::google::logging::v2::ListSinksRequest* request, ::google::logging::v2::ListSinksResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
      void GetSink(::grpc::ClientContext* context, const ::google::logging::v2::GetSinkRequest* request, ::google::logging::v2::LogSink* response, std::function<void(::grpc::Status)>) override;
      void GetSink(::grpc::ClientContext* context, const ::google::logging::v2::GetSinkRequest* request, ::google::logging::v2::LogSink* response, ::grpc::ClientUnaryReactor* reactor) override;
      void CreateSink(::grpc::ClientContext* context, const ::google::logging::v2::CreateSinkRequest* request, ::google::logging::v2::LogSink* response, std::function<void(::grpc::Status)>) override;
      void CreateSink(::grpc::ClientContext* context, const ::google::logging::v2::CreateSinkRequest* request, ::google::logging::v2::LogSink* response, ::grpc::ClientUnaryReactor* reactor) override;
      void UpdateSink(::grpc::ClientContext* context, const ::google::logging::v2::UpdateSinkRequest* request, ::google::logging::v2::LogSink* response, std::function<void(::grpc::Status)>) override;
      void UpdateSink(::grpc::ClientContext* context, const ::google::logging::v2::UpdateSinkRequest* request, ::google::logging::v2::LogSink* response, ::grpc::ClientUnaryReactor* reactor) override;
      void DeleteSink(::grpc::ClientContext* context, const ::google::logging::v2::DeleteSinkRequest* request, ::google::protobuf::Empty* response, std::function<void(::grpc::Status)>) override;
      void DeleteSink(::grpc::ClientContext* context, const ::google::logging::v2::DeleteSinkRequest* request, ::google::protobuf::Empty* response, ::grpc::ClientUnaryReactor* reactor) override;
      void ListExclusions(::grpc::ClientContext* context, const ::google::logging::v2::ListExclusionsRequest* request, ::google::logging::v2::ListExclusionsResponse* response, std::function<void(::grpc::Status)>) override;
      void ListExclusions(::grpc::ClientContext* context, const ::google::logging::v2::ListExclusionsRequest* request, ::google::logging::v2::ListExclusionsResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
      void GetExclusion(::grpc::ClientContext* context, const ::google::logging::v2::GetExclusionRequest* request, ::google::logging::v2::LogExclusion* response, std::function<void(::grpc::Status)>) override;
      void GetExclusion(::grpc::ClientContext* context, const ::google::logging::v2::GetExclusionRequest* request, ::google::logging::v2::LogExclusion* response, ::grpc::ClientUnaryReactor* reactor) override;
      void CreateExclusion(::grpc::ClientContext* context, const ::google::logging::v2::CreateExclusionRequest* request, ::google::logging::v2::LogExclusion* response, std::function<void(::grpc::Status)>) override;
      void CreateExclusion(::grpc::ClientContext* context, const ::google::logging::v2::CreateExclusionRequest* request, ::google::logging::v2::LogExclusion* response, ::grpc::ClientUnaryReactor* reactor) override;
      void UpdateExclusion(::grpc::ClientContext* context, const ::google::logging::v2::UpdateExclusionRequest* request, ::google::logging::v2::LogExclusion* response, std::function<void(::grpc::Status)>) override;
      void UpdateExclusion(::grpc::ClientContext* context, const ::google::logging::v2::UpdateExclusionRequest* request, ::google::logging::v2::LogExclusion* response, ::grpc::ClientUnaryReactor* reactor) override;
      void DeleteExclusion(::grpc::ClientContext* context, const ::google::logging::v2::DeleteExclusionRequest* request, ::google::protobuf::Empty* response, std::function<void(::grpc::Status)>) override;
      void DeleteExclusion(::grpc::ClientContext* context, const ::google::logging::v2::DeleteExclusionRequest* request, ::google::protobuf::Empty* response, ::grpc::ClientUnaryReactor* reactor) override;
      void GetCmekSettings(::grpc::ClientContext* context, const ::google::logging::v2::GetCmekSettingsRequest* request, ::google::logging::v2::CmekSettings* response, std::function<void(::grpc::Status)>) override;
      void GetCmekSettings(::grpc::ClientContext* context, const ::google::logging::v2::GetCmekSettingsRequest* request, ::google::logging::v2::CmekSettings* response, ::grpc::ClientUnaryReactor* reactor) override;
      void UpdateCmekSettings(::grpc::ClientContext* context, const ::google::logging::v2::UpdateCmekSettingsRequest* request, ::google::logging::v2::CmekSettings* response, std::function<void(::grpc::Status)>) override;
      void UpdateCmekSettings(::grpc::ClientContext* context, const ::google::logging::v2::UpdateCmekSettingsRequest* request, ::google::logging::v2::CmekSettings* response, ::grpc::ClientUnaryReactor* reactor) override;
      void GetSettings(::grpc::ClientContext* context, const ::google::logging::v2::GetSettingsRequest* request, ::google::logging::v2::Settings* response, std::function<void(::grpc::Status)>) override;
      void GetSettings(::grpc::ClientContext* context, const ::google::logging::v2::GetSettingsRequest* request, ::google::logging::v2::Settings* response, ::grpc::ClientUnaryReactor* reactor) override;
      void UpdateSettings(::grpc::ClientContext* context, const ::google::logging::v2::UpdateSettingsRequest* request, ::google::logging::v2::Settings* response, std::function<void(::grpc::Status)>) override;
      void UpdateSettings(::grpc::ClientContext* context, const ::google::logging::v2::UpdateSettingsRequest* request, ::google::logging::v2::Settings* response, ::grpc::ClientUnaryReactor* reactor) override;
      void CopyLogEntries(::grpc::ClientContext* context, const ::google::logging::v2::CopyLogEntriesRequest* request, ::google::longrunning::Operation* response, std::function<void(::grpc::Status)>) override;
      void CopyLogEntries(::grpc::ClientContext* context, const ::google::logging::v2::CopyLogEntriesRequest* request, ::google::longrunning::Operation* response, ::grpc::ClientUnaryReactor* reactor) override;
     private:
      friend class Stub;
      explicit async(Stub* stub): stub_(stub) { }
      Stub* stub() { return stub_; }
      Stub* stub_;
    };
    class async* async() override { return &async_stub_; }

   private:
    std::shared_ptr< ::grpc::ChannelInterface> channel_;
    class async async_stub_{this};
    ::grpc::ClientAsyncResponseReader< ::google::logging::v2::ListBucketsResponse>* AsyncListBucketsRaw(::grpc::ClientContext* context, const ::google::logging::v2::ListBucketsRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::logging::v2::ListBucketsResponse>* PrepareAsyncListBucketsRaw(::grpc::ClientContext* context, const ::google::logging::v2::ListBucketsRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::logging::v2::LogBucket>* AsyncGetBucketRaw(::grpc::ClientContext* context, const ::google::logging::v2::GetBucketRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::logging::v2::LogBucket>* PrepareAsyncGetBucketRaw(::grpc::ClientContext* context, const ::google::logging::v2::GetBucketRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::logging::v2::LogBucket>* AsyncCreateBucketRaw(::grpc::ClientContext* context, const ::google::logging::v2::CreateBucketRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::logging::v2::LogBucket>* PrepareAsyncCreateBucketRaw(::grpc::ClientContext* context, const ::google::logging::v2::CreateBucketRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::logging::v2::LogBucket>* AsyncUpdateBucketRaw(::grpc::ClientContext* context, const ::google::logging::v2::UpdateBucketRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::logging::v2::LogBucket>* PrepareAsyncUpdateBucketRaw(::grpc::ClientContext* context, const ::google::logging::v2::UpdateBucketRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>* AsyncDeleteBucketRaw(::grpc::ClientContext* context, const ::google::logging::v2::DeleteBucketRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>* PrepareAsyncDeleteBucketRaw(::grpc::ClientContext* context, const ::google::logging::v2::DeleteBucketRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>* AsyncUndeleteBucketRaw(::grpc::ClientContext* context, const ::google::logging::v2::UndeleteBucketRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>* PrepareAsyncUndeleteBucketRaw(::grpc::ClientContext* context, const ::google::logging::v2::UndeleteBucketRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::logging::v2::ListViewsResponse>* AsyncListViewsRaw(::grpc::ClientContext* context, const ::google::logging::v2::ListViewsRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::logging::v2::ListViewsResponse>* PrepareAsyncListViewsRaw(::grpc::ClientContext* context, const ::google::logging::v2::ListViewsRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::logging::v2::LogView>* AsyncGetViewRaw(::grpc::ClientContext* context, const ::google::logging::v2::GetViewRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::logging::v2::LogView>* PrepareAsyncGetViewRaw(::grpc::ClientContext* context, const ::google::logging::v2::GetViewRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::logging::v2::LogView>* AsyncCreateViewRaw(::grpc::ClientContext* context, const ::google::logging::v2::CreateViewRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::logging::v2::LogView>* PrepareAsyncCreateViewRaw(::grpc::ClientContext* context, const ::google::logging::v2::CreateViewRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::logging::v2::LogView>* AsyncUpdateViewRaw(::grpc::ClientContext* context, const ::google::logging::v2::UpdateViewRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::logging::v2::LogView>* PrepareAsyncUpdateViewRaw(::grpc::ClientContext* context, const ::google::logging::v2::UpdateViewRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>* AsyncDeleteViewRaw(::grpc::ClientContext* context, const ::google::logging::v2::DeleteViewRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>* PrepareAsyncDeleteViewRaw(::grpc::ClientContext* context, const ::google::logging::v2::DeleteViewRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::logging::v2::ListSinksResponse>* AsyncListSinksRaw(::grpc::ClientContext* context, const ::google::logging::v2::ListSinksRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::logging::v2::ListSinksResponse>* PrepareAsyncListSinksRaw(::grpc::ClientContext* context, const ::google::logging::v2::ListSinksRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::logging::v2::LogSink>* AsyncGetSinkRaw(::grpc::ClientContext* context, const ::google::logging::v2::GetSinkRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::logging::v2::LogSink>* PrepareAsyncGetSinkRaw(::grpc::ClientContext* context, const ::google::logging::v2::GetSinkRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::logging::v2::LogSink>* AsyncCreateSinkRaw(::grpc::ClientContext* context, const ::google::logging::v2::CreateSinkRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::logging::v2::LogSink>* PrepareAsyncCreateSinkRaw(::grpc::ClientContext* context, const ::google::logging::v2::CreateSinkRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::logging::v2::LogSink>* AsyncUpdateSinkRaw(::grpc::ClientContext* context, const ::google::logging::v2::UpdateSinkRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::logging::v2::LogSink>* PrepareAsyncUpdateSinkRaw(::grpc::ClientContext* context, const ::google::logging::v2::UpdateSinkRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>* AsyncDeleteSinkRaw(::grpc::ClientContext* context, const ::google::logging::v2::DeleteSinkRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>* PrepareAsyncDeleteSinkRaw(::grpc::ClientContext* context, const ::google::logging::v2::DeleteSinkRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::logging::v2::ListExclusionsResponse>* AsyncListExclusionsRaw(::grpc::ClientContext* context, const ::google::logging::v2::ListExclusionsRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::logging::v2::ListExclusionsResponse>* PrepareAsyncListExclusionsRaw(::grpc::ClientContext* context, const ::google::logging::v2::ListExclusionsRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::logging::v2::LogExclusion>* AsyncGetExclusionRaw(::grpc::ClientContext* context, const ::google::logging::v2::GetExclusionRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::logging::v2::LogExclusion>* PrepareAsyncGetExclusionRaw(::grpc::ClientContext* context, const ::google::logging::v2::GetExclusionRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::logging::v2::LogExclusion>* AsyncCreateExclusionRaw(::grpc::ClientContext* context, const ::google::logging::v2::CreateExclusionRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::logging::v2::LogExclusion>* PrepareAsyncCreateExclusionRaw(::grpc::ClientContext* context, const ::google::logging::v2::CreateExclusionRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::logging::v2::LogExclusion>* AsyncUpdateExclusionRaw(::grpc::ClientContext* context, const ::google::logging::v2::UpdateExclusionRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::logging::v2::LogExclusion>* PrepareAsyncUpdateExclusionRaw(::grpc::ClientContext* context, const ::google::logging::v2::UpdateExclusionRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>* AsyncDeleteExclusionRaw(::grpc::ClientContext* context, const ::google::logging::v2::DeleteExclusionRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>* PrepareAsyncDeleteExclusionRaw(::grpc::ClientContext* context, const ::google::logging::v2::DeleteExclusionRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::logging::v2::CmekSettings>* AsyncGetCmekSettingsRaw(::grpc::ClientContext* context, const ::google::logging::v2::GetCmekSettingsRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::logging::v2::CmekSettings>* PrepareAsyncGetCmekSettingsRaw(::grpc::ClientContext* context, const ::google::logging::v2::GetCmekSettingsRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::logging::v2::CmekSettings>* AsyncUpdateCmekSettingsRaw(::grpc::ClientContext* context, const ::google::logging::v2::UpdateCmekSettingsRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::logging::v2::CmekSettings>* PrepareAsyncUpdateCmekSettingsRaw(::grpc::ClientContext* context, const ::google::logging::v2::UpdateCmekSettingsRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::logging::v2::Settings>* AsyncGetSettingsRaw(::grpc::ClientContext* context, const ::google::logging::v2::GetSettingsRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::logging::v2::Settings>* PrepareAsyncGetSettingsRaw(::grpc::ClientContext* context, const ::google::logging::v2::GetSettingsRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::logging::v2::Settings>* AsyncUpdateSettingsRaw(::grpc::ClientContext* context, const ::google::logging::v2::UpdateSettingsRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::logging::v2::Settings>* PrepareAsyncUpdateSettingsRaw(::grpc::ClientContext* context, const ::google::logging::v2::UpdateSettingsRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>* AsyncCopyLogEntriesRaw(::grpc::ClientContext* context, const ::google::logging::v2::CopyLogEntriesRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>* PrepareAsyncCopyLogEntriesRaw(::grpc::ClientContext* context, const ::google::logging::v2::CopyLogEntriesRequest& request, ::grpc::CompletionQueue* cq) override;
    const ::grpc::internal::RpcMethod rpcmethod_ListBuckets_;
    const ::grpc::internal::RpcMethod rpcmethod_GetBucket_;
    const ::grpc::internal::RpcMethod rpcmethod_CreateBucket_;
    const ::grpc::internal::RpcMethod rpcmethod_UpdateBucket_;
    const ::grpc::internal::RpcMethod rpcmethod_DeleteBucket_;
    const ::grpc::internal::RpcMethod rpcmethod_UndeleteBucket_;
    const ::grpc::internal::RpcMethod rpcmethod_ListViews_;
    const ::grpc::internal::RpcMethod rpcmethod_GetView_;
    const ::grpc::internal::RpcMethod rpcmethod_CreateView_;
    const ::grpc::internal::RpcMethod rpcmethod_UpdateView_;
    const ::grpc::internal::RpcMethod rpcmethod_DeleteView_;
    const ::grpc::internal::RpcMethod rpcmethod_ListSinks_;
    const ::grpc::internal::RpcMethod rpcmethod_GetSink_;
    const ::grpc::internal::RpcMethod rpcmethod_CreateSink_;
    const ::grpc::internal::RpcMethod rpcmethod_UpdateSink_;
    const ::grpc::internal::RpcMethod rpcmethod_DeleteSink_;
    const ::grpc::internal::RpcMethod rpcmethod_ListExclusions_;
    const ::grpc::internal::RpcMethod rpcmethod_GetExclusion_;
    const ::grpc::internal::RpcMethod rpcmethod_CreateExclusion_;
    const ::grpc::internal::RpcMethod rpcmethod_UpdateExclusion_;
    const ::grpc::internal::RpcMethod rpcmethod_DeleteExclusion_;
    const ::grpc::internal::RpcMethod rpcmethod_GetCmekSettings_;
    const ::grpc::internal::RpcMethod rpcmethod_UpdateCmekSettings_;
    const ::grpc::internal::RpcMethod rpcmethod_GetSettings_;
    const ::grpc::internal::RpcMethod rpcmethod_UpdateSettings_;
    const ::grpc::internal::RpcMethod rpcmethod_CopyLogEntries_;
  };
  static std::unique_ptr<Stub> NewStub(const std::shared_ptr< ::grpc::ChannelInterface>& channel, const ::grpc::StubOptions& options = ::grpc::StubOptions());

  class Service : public ::grpc::Service {
   public:
    Service();
    virtual ~Service();
    // Lists log buckets.
    virtual ::grpc::Status ListBuckets(::grpc::ServerContext* context, const ::google::logging::v2::ListBucketsRequest* request, ::google::logging::v2::ListBucketsResponse* response);
    // Gets a log bucket.
    virtual ::grpc::Status GetBucket(::grpc::ServerContext* context, const ::google::logging::v2::GetBucketRequest* request, ::google::logging::v2::LogBucket* response);
    // Creates a log bucket that can be used to store log entries. After a bucket
    // has been created, the bucket's location cannot be changed.
    virtual ::grpc::Status CreateBucket(::grpc::ServerContext* context, const ::google::logging::v2::CreateBucketRequest* request, ::google::logging::v2::LogBucket* response);
    // Updates a log bucket. This method replaces the following fields in the
    // existing bucket with values from the new bucket: `retention_period`
    //
    // If the retention period is decreased and the bucket is locked,
    // `FAILED_PRECONDITION` will be returned.
    //
    // If the bucket has a `lifecycle_state` of `DELETE_REQUESTED`, then
    // `FAILED_PRECONDITION` will be returned.
    //
    // After a bucket has been created, the bucket's location cannot be changed.
    virtual ::grpc::Status UpdateBucket(::grpc::ServerContext* context, const ::google::logging::v2::UpdateBucketRequest* request, ::google::logging::v2::LogBucket* response);
    // Deletes a log bucket.
    //
    // Changes the bucket's `lifecycle_state` to the `DELETE_REQUESTED` state.
    // After 7 days, the bucket will be purged and all log entries in the bucket
    // will be permanently deleted.
    virtual ::grpc::Status DeleteBucket(::grpc::ServerContext* context, const ::google::logging::v2::DeleteBucketRequest* request, ::google::protobuf::Empty* response);
    // Undeletes a log bucket. A bucket that has been deleted can be undeleted
    // within the grace period of 7 days.
    virtual ::grpc::Status UndeleteBucket(::grpc::ServerContext* context, const ::google::logging::v2::UndeleteBucketRequest* request, ::google::protobuf::Empty* response);
    // Lists views on a log bucket.
    virtual ::grpc::Status ListViews(::grpc::ServerContext* context, const ::google::logging::v2::ListViewsRequest* request, ::google::logging::v2::ListViewsResponse* response);
    // Gets a view on a log bucket..
    virtual ::grpc::Status GetView(::grpc::ServerContext* context, const ::google::logging::v2::GetViewRequest* request, ::google::logging::v2::LogView* response);
    // Creates a view over log entries in a log bucket. A bucket may contain a
    // maximum of 30 views.
    virtual ::grpc::Status CreateView(::grpc::ServerContext* context, const ::google::logging::v2::CreateViewRequest* request, ::google::logging::v2::LogView* response);
    // Updates a view on a log bucket. This method replaces the following fields
    // in the existing view with values from the new view: `filter`.
    // If an `UNAVAILABLE` error is returned, this indicates that system is not in
    // a state where it can update the view. If this occurs, please try again in a
    // few minutes.
    virtual ::grpc::Status UpdateView(::grpc::ServerContext* context, const ::google::logging::v2::UpdateViewRequest* request, ::google::logging::v2::LogView* response);
    // Deletes a view on a log bucket.
    // If an `UNAVAILABLE` error is returned, this indicates that system is not in
    // a state where it can delete the view. If this occurs, please try again in a
    // few minutes.
    virtual ::grpc::Status DeleteView(::grpc::ServerContext* context, const ::google::logging::v2::DeleteViewRequest* request, ::google::protobuf::Empty* response);
    // Lists sinks.
    virtual ::grpc::Status ListSinks(::grpc::ServerContext* context, const ::google::logging::v2::ListSinksRequest* request, ::google::logging::v2::ListSinksResponse* response);
    // Gets a sink.
    virtual ::grpc::Status GetSink(::grpc::ServerContext* context, const ::google::logging::v2::GetSinkRequest* request, ::google::logging::v2::LogSink* response);
    // Creates a sink that exports specified log entries to a destination. The
    // export of newly-ingested log entries begins immediately, unless the sink's
    // `writer_identity` is not permitted to write to the destination. A sink can
    // export log entries only from the resource owning the sink.
    virtual ::grpc::Status CreateSink(::grpc::ServerContext* context, const ::google::logging::v2::CreateSinkRequest* request, ::google::logging::v2::LogSink* response);
    // Updates a sink. This method replaces the following fields in the existing
    // sink with values from the new sink: `destination`, and `filter`.
    //
    // The updated sink might also have a new `writer_identity`; see the
    // `unique_writer_identity` field.
    virtual ::grpc::Status UpdateSink(::grpc::ServerContext* context, const ::google::logging::v2::UpdateSinkRequest* request, ::google::logging::v2::LogSink* response);
    // Deletes a sink. If the sink has a unique `writer_identity`, then that
    // service account is also deleted.
    virtual ::grpc::Status DeleteSink(::grpc::ServerContext* context, const ::google::logging::v2::DeleteSinkRequest* request, ::google::protobuf::Empty* response);
    // Lists all the exclusions on the _Default sink in a parent resource.
    virtual ::grpc::Status ListExclusions(::grpc::ServerContext* context, const ::google::logging::v2::ListExclusionsRequest* request, ::google::logging::v2::ListExclusionsResponse* response);
    // Gets the description of an exclusion in the _Default sink.
    virtual ::grpc::Status GetExclusion(::grpc::ServerContext* context, const ::google::logging::v2::GetExclusionRequest* request, ::google::logging::v2::LogExclusion* response);
    // Creates a new exclusion in the _Default sink in a specified parent
    // resource. Only log entries belonging to that resource can be excluded. You
    // can have up to 10 exclusions in a resource.
    virtual ::grpc::Status CreateExclusion(::grpc::ServerContext* context, const ::google::logging::v2::CreateExclusionRequest* request, ::google::logging::v2::LogExclusion* response);
    // Changes one or more properties of an existing exclusion in the _Default
    // sink.
    virtual ::grpc::Status UpdateExclusion(::grpc::ServerContext* context, const ::google::logging::v2::UpdateExclusionRequest* request, ::google::logging::v2::LogExclusion* response);
    // Deletes an exclusion in the _Default sink.
    virtual ::grpc::Status DeleteExclusion(::grpc::ServerContext* context, const ::google::logging::v2::DeleteExclusionRequest* request, ::google::protobuf::Empty* response);
    // Gets the Logging CMEK settings for the given resource.
    //
    // Note: CMEK for the Log Router can be configured for Google Cloud projects,
    // folders, organizations and billing accounts. Once configured for an
    // organization, it applies to all projects and folders in the Google Cloud
    // organization.
    //
    // See [Enabling CMEK for Log
    // Router](https://cloud.google.com/logging/docs/routing/managed-encryption)
    // for more information.
    virtual ::grpc::Status GetCmekSettings(::grpc::ServerContext* context, const ::google::logging::v2::GetCmekSettingsRequest* request, ::google::logging::v2::CmekSettings* response);
    // Updates the Log Router CMEK settings for the given resource.
    //
    // Note: CMEK for the Log Router can currently only be configured for Google
    // Cloud organizations. Once configured, it applies to all projects and
    // folders in the Google Cloud organization.
    //
    // [UpdateCmekSettings][google.logging.v2.ConfigServiceV2.UpdateCmekSettings]
    // will fail if 1) `kms_key_name` is invalid, or 2) the associated service
    // account does not have the required
    // `roles/cloudkms.cryptoKeyEncrypterDecrypter` role assigned for the key, or
    // 3) access to the key is disabled.
    //
    // See [Enabling CMEK for Log
    // Router](https://cloud.google.com/logging/docs/routing/managed-encryption)
    // for more information.
    virtual ::grpc::Status UpdateCmekSettings(::grpc::ServerContext* context, const ::google::logging::v2::UpdateCmekSettingsRequest* request, ::google::logging::v2::CmekSettings* response);
    // Gets the Log Router settings for the given resource.
    //
    // Note: Settings for the Log Router can be get for Google Cloud projects,
    // folders, organizations and billing accounts. Currently it can only be
    // configured for organizations. Once configured for an organization, it
    // applies to all projects and folders in the Google Cloud organization.
    //
    // See [Enabling CMEK for Log
    // Router](https://cloud.google.com/logging/docs/routing/managed-encryption)
    // for more information.
    virtual ::grpc::Status GetSettings(::grpc::ServerContext* context, const ::google::logging::v2::GetSettingsRequest* request, ::google::logging::v2::Settings* response);
    // Updates the Log Router settings for the given resource.
    //
    // Note: Settings for the Log Router can currently only be configured for
    // Google Cloud organizations. Once configured, it applies to all projects and
    // folders in the Google Cloud organization.
    //
    // [UpdateSettings][google.logging.v2.ConfigServiceV2.UpdateSettings]
    // will fail if 1) `kms_key_name` is invalid, or 2) the associated service
    // account does not have the required
    // `roles/cloudkms.cryptoKeyEncrypterDecrypter` role assigned for the key, or
    // 3) access to the key is disabled. 4) `location_id` is not supported by
    // Logging. 5) `location_id` violate OrgPolicy.
    //
    // See [Enabling CMEK for Log
    // Router](https://cloud.google.com/logging/docs/routing/managed-encryption)
    // for more information.
    virtual ::grpc::Status UpdateSettings(::grpc::ServerContext* context, const ::google::logging::v2::UpdateSettingsRequest* request, ::google::logging::v2::Settings* response);
    // Copies a set of log entries from a log bucket to a Cloud Storage bucket.
    virtual ::grpc::Status CopyLogEntries(::grpc::ServerContext* context, const ::google::logging::v2::CopyLogEntriesRequest* request, ::google::longrunning::Operation* response);
  };
  template <class BaseClass>
  class WithAsyncMethod_ListBuckets : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_ListBuckets() {
      ::grpc::Service::MarkMethodAsync(0);
    }
    ~WithAsyncMethod_ListBuckets() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListBuckets(::grpc::ServerContext* /*context*/, const ::google::logging::v2::ListBucketsRequest* /*request*/, ::google::logging::v2::ListBucketsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestListBuckets(::grpc::ServerContext* context, ::google::logging::v2::ListBucketsRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::logging::v2::ListBucketsResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(0, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_GetBucket : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_GetBucket() {
      ::grpc::Service::MarkMethodAsync(1);
    }
    ~WithAsyncMethod_GetBucket() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetBucket(::grpc::ServerContext* /*context*/, const ::google::logging::v2::GetBucketRequest* /*request*/, ::google::logging::v2::LogBucket* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGetBucket(::grpc::ServerContext* context, ::google::logging::v2::GetBucketRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::logging::v2::LogBucket>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(1, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_CreateBucket : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_CreateBucket() {
      ::grpc::Service::MarkMethodAsync(2);
    }
    ~WithAsyncMethod_CreateBucket() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateBucket(::grpc::ServerContext* /*context*/, const ::google::logging::v2::CreateBucketRequest* /*request*/, ::google::logging::v2::LogBucket* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestCreateBucket(::grpc::ServerContext* context, ::google::logging::v2::CreateBucketRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::logging::v2::LogBucket>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(2, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_UpdateBucket : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_UpdateBucket() {
      ::grpc::Service::MarkMethodAsync(3);
    }
    ~WithAsyncMethod_UpdateBucket() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateBucket(::grpc::ServerContext* /*context*/, const ::google::logging::v2::UpdateBucketRequest* /*request*/, ::google::logging::v2::LogBucket* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestUpdateBucket(::grpc::ServerContext* context, ::google::logging::v2::UpdateBucketRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::logging::v2::LogBucket>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(3, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_DeleteBucket : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_DeleteBucket() {
      ::grpc::Service::MarkMethodAsync(4);
    }
    ~WithAsyncMethod_DeleteBucket() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteBucket(::grpc::ServerContext* /*context*/, const ::google::logging::v2::DeleteBucketRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestDeleteBucket(::grpc::ServerContext* context, ::google::logging::v2::DeleteBucketRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::protobuf::Empty>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(4, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_UndeleteBucket : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_UndeleteBucket() {
      ::grpc::Service::MarkMethodAsync(5);
    }
    ~WithAsyncMethod_UndeleteBucket() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UndeleteBucket(::grpc::ServerContext* /*context*/, const ::google::logging::v2::UndeleteBucketRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestUndeleteBucket(::grpc::ServerContext* context, ::google::logging::v2::UndeleteBucketRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::protobuf::Empty>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(5, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_ListViews : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_ListViews() {
      ::grpc::Service::MarkMethodAsync(6);
    }
    ~WithAsyncMethod_ListViews() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListViews(::grpc::ServerContext* /*context*/, const ::google::logging::v2::ListViewsRequest* /*request*/, ::google::logging::v2::ListViewsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestListViews(::grpc::ServerContext* context, ::google::logging::v2::ListViewsRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::logging::v2::ListViewsResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(6, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_GetView : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_GetView() {
      ::grpc::Service::MarkMethodAsync(7);
    }
    ~WithAsyncMethod_GetView() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetView(::grpc::ServerContext* /*context*/, const ::google::logging::v2::GetViewRequest* /*request*/, ::google::logging::v2::LogView* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGetView(::grpc::ServerContext* context, ::google::logging::v2::GetViewRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::logging::v2::LogView>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(7, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_CreateView : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_CreateView() {
      ::grpc::Service::MarkMethodAsync(8);
    }
    ~WithAsyncMethod_CreateView() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateView(::grpc::ServerContext* /*context*/, const ::google::logging::v2::CreateViewRequest* /*request*/, ::google::logging::v2::LogView* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestCreateView(::grpc::ServerContext* context, ::google::logging::v2::CreateViewRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::logging::v2::LogView>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(8, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_UpdateView : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_UpdateView() {
      ::grpc::Service::MarkMethodAsync(9);
    }
    ~WithAsyncMethod_UpdateView() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateView(::grpc::ServerContext* /*context*/, const ::google::logging::v2::UpdateViewRequest* /*request*/, ::google::logging::v2::LogView* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestUpdateView(::grpc::ServerContext* context, ::google::logging::v2::UpdateViewRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::logging::v2::LogView>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(9, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_DeleteView : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_DeleteView() {
      ::grpc::Service::MarkMethodAsync(10);
    }
    ~WithAsyncMethod_DeleteView() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteView(::grpc::ServerContext* /*context*/, const ::google::logging::v2::DeleteViewRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestDeleteView(::grpc::ServerContext* context, ::google::logging::v2::DeleteViewRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::protobuf::Empty>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(10, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_ListSinks : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_ListSinks() {
      ::grpc::Service::MarkMethodAsync(11);
    }
    ~WithAsyncMethod_ListSinks() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListSinks(::grpc::ServerContext* /*context*/, const ::google::logging::v2::ListSinksRequest* /*request*/, ::google::logging::v2::ListSinksResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestListSinks(::grpc::ServerContext* context, ::google::logging::v2::ListSinksRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::logging::v2::ListSinksResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(11, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_GetSink : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_GetSink() {
      ::grpc::Service::MarkMethodAsync(12);
    }
    ~WithAsyncMethod_GetSink() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetSink(::grpc::ServerContext* /*context*/, const ::google::logging::v2::GetSinkRequest* /*request*/, ::google::logging::v2::LogSink* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGetSink(::grpc::ServerContext* context, ::google::logging::v2::GetSinkRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::logging::v2::LogSink>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(12, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_CreateSink : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_CreateSink() {
      ::grpc::Service::MarkMethodAsync(13);
    }
    ~WithAsyncMethod_CreateSink() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateSink(::grpc::ServerContext* /*context*/, const ::google::logging::v2::CreateSinkRequest* /*request*/, ::google::logging::v2::LogSink* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestCreateSink(::grpc::ServerContext* context, ::google::logging::v2::CreateSinkRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::logging::v2::LogSink>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(13, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_UpdateSink : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_UpdateSink() {
      ::grpc::Service::MarkMethodAsync(14);
    }
    ~WithAsyncMethod_UpdateSink() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateSink(::grpc::ServerContext* /*context*/, const ::google::logging::v2::UpdateSinkRequest* /*request*/, ::google::logging::v2::LogSink* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestUpdateSink(::grpc::ServerContext* context, ::google::logging::v2::UpdateSinkRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::logging::v2::LogSink>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(14, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_DeleteSink : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_DeleteSink() {
      ::grpc::Service::MarkMethodAsync(15);
    }
    ~WithAsyncMethod_DeleteSink() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteSink(::grpc::ServerContext* /*context*/, const ::google::logging::v2::DeleteSinkRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestDeleteSink(::grpc::ServerContext* context, ::google::logging::v2::DeleteSinkRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::protobuf::Empty>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(15, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_ListExclusions : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_ListExclusions() {
      ::grpc::Service::MarkMethodAsync(16);
    }
    ~WithAsyncMethod_ListExclusions() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListExclusions(::grpc::ServerContext* /*context*/, const ::google::logging::v2::ListExclusionsRequest* /*request*/, ::google::logging::v2::ListExclusionsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestListExclusions(::grpc::ServerContext* context, ::google::logging::v2::ListExclusionsRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::logging::v2::ListExclusionsResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(16, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_GetExclusion : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_GetExclusion() {
      ::grpc::Service::MarkMethodAsync(17);
    }
    ~WithAsyncMethod_GetExclusion() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetExclusion(::grpc::ServerContext* /*context*/, const ::google::logging::v2::GetExclusionRequest* /*request*/, ::google::logging::v2::LogExclusion* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGetExclusion(::grpc::ServerContext* context, ::google::logging::v2::GetExclusionRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::logging::v2::LogExclusion>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(17, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_CreateExclusion : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_CreateExclusion() {
      ::grpc::Service::MarkMethodAsync(18);
    }
    ~WithAsyncMethod_CreateExclusion() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateExclusion(::grpc::ServerContext* /*context*/, const ::google::logging::v2::CreateExclusionRequest* /*request*/, ::google::logging::v2::LogExclusion* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestCreateExclusion(::grpc::ServerContext* context, ::google::logging::v2::CreateExclusionRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::logging::v2::LogExclusion>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(18, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_UpdateExclusion : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_UpdateExclusion() {
      ::grpc::Service::MarkMethodAsync(19);
    }
    ~WithAsyncMethod_UpdateExclusion() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateExclusion(::grpc::ServerContext* /*context*/, const ::google::logging::v2::UpdateExclusionRequest* /*request*/, ::google::logging::v2::LogExclusion* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestUpdateExclusion(::grpc::ServerContext* context, ::google::logging::v2::UpdateExclusionRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::logging::v2::LogExclusion>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(19, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_DeleteExclusion : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_DeleteExclusion() {
      ::grpc::Service::MarkMethodAsync(20);
    }
    ~WithAsyncMethod_DeleteExclusion() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteExclusion(::grpc::ServerContext* /*context*/, const ::google::logging::v2::DeleteExclusionRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestDeleteExclusion(::grpc::ServerContext* context, ::google::logging::v2::DeleteExclusionRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::protobuf::Empty>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(20, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_GetCmekSettings : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_GetCmekSettings() {
      ::grpc::Service::MarkMethodAsync(21);
    }
    ~WithAsyncMethod_GetCmekSettings() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetCmekSettings(::grpc::ServerContext* /*context*/, const ::google::logging::v2::GetCmekSettingsRequest* /*request*/, ::google::logging::v2::CmekSettings* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGetCmekSettings(::grpc::ServerContext* context, ::google::logging::v2::GetCmekSettingsRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::logging::v2::CmekSettings>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(21, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_UpdateCmekSettings : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_UpdateCmekSettings() {
      ::grpc::Service::MarkMethodAsync(22);
    }
    ~WithAsyncMethod_UpdateCmekSettings() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateCmekSettings(::grpc::ServerContext* /*context*/, const ::google::logging::v2::UpdateCmekSettingsRequest* /*request*/, ::google::logging::v2::CmekSettings* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestUpdateCmekSettings(::grpc::ServerContext* context, ::google::logging::v2::UpdateCmekSettingsRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::logging::v2::CmekSettings>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(22, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_GetSettings : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_GetSettings() {
      ::grpc::Service::MarkMethodAsync(23);
    }
    ~WithAsyncMethod_GetSettings() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetSettings(::grpc::ServerContext* /*context*/, const ::google::logging::v2::GetSettingsRequest* /*request*/, ::google::logging::v2::Settings* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGetSettings(::grpc::ServerContext* context, ::google::logging::v2::GetSettingsRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::logging::v2::Settings>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(23, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_UpdateSettings : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_UpdateSettings() {
      ::grpc::Service::MarkMethodAsync(24);
    }
    ~WithAsyncMethod_UpdateSettings() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateSettings(::grpc::ServerContext* /*context*/, const ::google::logging::v2::UpdateSettingsRequest* /*request*/, ::google::logging::v2::Settings* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestUpdateSettings(::grpc::ServerContext* context, ::google::logging::v2::UpdateSettingsRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::logging::v2::Settings>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(24, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_CopyLogEntries : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_CopyLogEntries() {
      ::grpc::Service::MarkMethodAsync(25);
    }
    ~WithAsyncMethod_CopyLogEntries() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CopyLogEntries(::grpc::ServerContext* /*context*/, const ::google::logging::v2::CopyLogEntriesRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestCopyLogEntries(::grpc::ServerContext* context, ::google::logging::v2::CopyLogEntriesRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::longrunning::Operation>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(25, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  typedef WithAsyncMethod_ListBuckets<WithAsyncMethod_GetBucket<WithAsyncMethod_CreateBucket<WithAsyncMethod_UpdateBucket<WithAsyncMethod_DeleteBucket<WithAsyncMethod_UndeleteBucket<WithAsyncMethod_ListViews<WithAsyncMethod_GetView<WithAsyncMethod_CreateView<WithAsyncMethod_UpdateView<WithAsyncMethod_DeleteView<WithAsyncMethod_ListSinks<WithAsyncMethod_GetSink<WithAsyncMethod_CreateSink<WithAsyncMethod_UpdateSink<WithAsyncMethod_DeleteSink<WithAsyncMethod_ListExclusions<WithAsyncMethod_GetExclusion<WithAsyncMethod_CreateExclusion<WithAsyncMethod_UpdateExclusion<WithAsyncMethod_DeleteExclusion<WithAsyncMethod_GetCmekSettings<WithAsyncMethod_UpdateCmekSettings<WithAsyncMethod_GetSettings<WithAsyncMethod_UpdateSettings<WithAsyncMethod_CopyLogEntries<Service > > > > > > > > > > > > > > > > > > > > > > > > > > AsyncService;
  template <class BaseClass>
  class WithCallbackMethod_ListBuckets : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_ListBuckets() {
      ::grpc::Service::MarkMethodCallback(0,
          new ::grpc::internal::CallbackUnaryHandler< ::google::logging::v2::ListBucketsRequest, ::google::logging::v2::ListBucketsResponse>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::logging::v2::ListBucketsRequest* request, ::google::logging::v2::ListBucketsResponse* response) { return this->ListBuckets(context, request, response); }));}
    void SetMessageAllocatorFor_ListBuckets(
        ::grpc::MessageAllocator< ::google::logging::v2::ListBucketsRequest, ::google::logging::v2::ListBucketsResponse>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(0);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::logging::v2::ListBucketsRequest, ::google::logging::v2::ListBucketsResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_ListBuckets() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListBuckets(::grpc::ServerContext* /*context*/, const ::google::logging::v2::ListBucketsRequest* /*request*/, ::google::logging::v2::ListBucketsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* ListBuckets(
      ::grpc::CallbackServerContext* /*context*/, const ::google::logging::v2::ListBucketsRequest* /*request*/, ::google::logging::v2::ListBucketsResponse* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_GetBucket : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_GetBucket() {
      ::grpc::Service::MarkMethodCallback(1,
          new ::grpc::internal::CallbackUnaryHandler< ::google::logging::v2::GetBucketRequest, ::google::logging::v2::LogBucket>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::logging::v2::GetBucketRequest* request, ::google::logging::v2::LogBucket* response) { return this->GetBucket(context, request, response); }));}
    void SetMessageAllocatorFor_GetBucket(
        ::grpc::MessageAllocator< ::google::logging::v2::GetBucketRequest, ::google::logging::v2::LogBucket>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(1);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::logging::v2::GetBucketRequest, ::google::logging::v2::LogBucket>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_GetBucket() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetBucket(::grpc::ServerContext* /*context*/, const ::google::logging::v2::GetBucketRequest* /*request*/, ::google::logging::v2::LogBucket* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* GetBucket(
      ::grpc::CallbackServerContext* /*context*/, const ::google::logging::v2::GetBucketRequest* /*request*/, ::google::logging::v2::LogBucket* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_CreateBucket : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_CreateBucket() {
      ::grpc::Service::MarkMethodCallback(2,
          new ::grpc::internal::CallbackUnaryHandler< ::google::logging::v2::CreateBucketRequest, ::google::logging::v2::LogBucket>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::logging::v2::CreateBucketRequest* request, ::google::logging::v2::LogBucket* response) { return this->CreateBucket(context, request, response); }));}
    void SetMessageAllocatorFor_CreateBucket(
        ::grpc::MessageAllocator< ::google::logging::v2::CreateBucketRequest, ::google::logging::v2::LogBucket>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(2);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::logging::v2::CreateBucketRequest, ::google::logging::v2::LogBucket>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_CreateBucket() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateBucket(::grpc::ServerContext* /*context*/, const ::google::logging::v2::CreateBucketRequest* /*request*/, ::google::logging::v2::LogBucket* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* CreateBucket(
      ::grpc::CallbackServerContext* /*context*/, const ::google::logging::v2::CreateBucketRequest* /*request*/, ::google::logging::v2::LogBucket* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_UpdateBucket : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_UpdateBucket() {
      ::grpc::Service::MarkMethodCallback(3,
          new ::grpc::internal::CallbackUnaryHandler< ::google::logging::v2::UpdateBucketRequest, ::google::logging::v2::LogBucket>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::logging::v2::UpdateBucketRequest* request, ::google::logging::v2::LogBucket* response) { return this->UpdateBucket(context, request, response); }));}
    void SetMessageAllocatorFor_UpdateBucket(
        ::grpc::MessageAllocator< ::google::logging::v2::UpdateBucketRequest, ::google::logging::v2::LogBucket>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(3);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::logging::v2::UpdateBucketRequest, ::google::logging::v2::LogBucket>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_UpdateBucket() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateBucket(::grpc::ServerContext* /*context*/, const ::google::logging::v2::UpdateBucketRequest* /*request*/, ::google::logging::v2::LogBucket* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* UpdateBucket(
      ::grpc::CallbackServerContext* /*context*/, const ::google::logging::v2::UpdateBucketRequest* /*request*/, ::google::logging::v2::LogBucket* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_DeleteBucket : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_DeleteBucket() {
      ::grpc::Service::MarkMethodCallback(4,
          new ::grpc::internal::CallbackUnaryHandler< ::google::logging::v2::DeleteBucketRequest, ::google::protobuf::Empty>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::logging::v2::DeleteBucketRequest* request, ::google::protobuf::Empty* response) { return this->DeleteBucket(context, request, response); }));}
    void SetMessageAllocatorFor_DeleteBucket(
        ::grpc::MessageAllocator< ::google::logging::v2::DeleteBucketRequest, ::google::protobuf::Empty>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(4);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::logging::v2::DeleteBucketRequest, ::google::protobuf::Empty>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_DeleteBucket() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteBucket(::grpc::ServerContext* /*context*/, const ::google::logging::v2::DeleteBucketRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* DeleteBucket(
      ::grpc::CallbackServerContext* /*context*/, const ::google::logging::v2::DeleteBucketRequest* /*request*/, ::google::protobuf::Empty* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_UndeleteBucket : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_UndeleteBucket() {
      ::grpc::Service::MarkMethodCallback(5,
          new ::grpc::internal::CallbackUnaryHandler< ::google::logging::v2::UndeleteBucketRequest, ::google::protobuf::Empty>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::logging::v2::UndeleteBucketRequest* request, ::google::protobuf::Empty* response) { return this->UndeleteBucket(context, request, response); }));}
    void SetMessageAllocatorFor_UndeleteBucket(
        ::grpc::MessageAllocator< ::google::logging::v2::UndeleteBucketRequest, ::google::protobuf::Empty>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(5);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::logging::v2::UndeleteBucketRequest, ::google::protobuf::Empty>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_UndeleteBucket() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UndeleteBucket(::grpc::ServerContext* /*context*/, const ::google::logging::v2::UndeleteBucketRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* UndeleteBucket(
      ::grpc::CallbackServerContext* /*context*/, const ::google::logging::v2::UndeleteBucketRequest* /*request*/, ::google::protobuf::Empty* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_ListViews : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_ListViews() {
      ::grpc::Service::MarkMethodCallback(6,
          new ::grpc::internal::CallbackUnaryHandler< ::google::logging::v2::ListViewsRequest, ::google::logging::v2::ListViewsResponse>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::logging::v2::ListViewsRequest* request, ::google::logging::v2::ListViewsResponse* response) { return this->ListViews(context, request, response); }));}
    void SetMessageAllocatorFor_ListViews(
        ::grpc::MessageAllocator< ::google::logging::v2::ListViewsRequest, ::google::logging::v2::ListViewsResponse>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(6);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::logging::v2::ListViewsRequest, ::google::logging::v2::ListViewsResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_ListViews() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListViews(::grpc::ServerContext* /*context*/, const ::google::logging::v2::ListViewsRequest* /*request*/, ::google::logging::v2::ListViewsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* ListViews(
      ::grpc::CallbackServerContext* /*context*/, const ::google::logging::v2::ListViewsRequest* /*request*/, ::google::logging::v2::ListViewsResponse* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_GetView : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_GetView() {
      ::grpc::Service::MarkMethodCallback(7,
          new ::grpc::internal::CallbackUnaryHandler< ::google::logging::v2::GetViewRequest, ::google::logging::v2::LogView>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::logging::v2::GetViewRequest* request, ::google::logging::v2::LogView* response) { return this->GetView(context, request, response); }));}
    void SetMessageAllocatorFor_GetView(
        ::grpc::MessageAllocator< ::google::logging::v2::GetViewRequest, ::google::logging::v2::LogView>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(7);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::logging::v2::GetViewRequest, ::google::logging::v2::LogView>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_GetView() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetView(::grpc::ServerContext* /*context*/, const ::google::logging::v2::GetViewRequest* /*request*/, ::google::logging::v2::LogView* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* GetView(
      ::grpc::CallbackServerContext* /*context*/, const ::google::logging::v2::GetViewRequest* /*request*/, ::google::logging::v2::LogView* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_CreateView : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_CreateView() {
      ::grpc::Service::MarkMethodCallback(8,
          new ::grpc::internal::CallbackUnaryHandler< ::google::logging::v2::CreateViewRequest, ::google::logging::v2::LogView>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::logging::v2::CreateViewRequest* request, ::google::logging::v2::LogView* response) { return this->CreateView(context, request, response); }));}
    void SetMessageAllocatorFor_CreateView(
        ::grpc::MessageAllocator< ::google::logging::v2::CreateViewRequest, ::google::logging::v2::LogView>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(8);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::logging::v2::CreateViewRequest, ::google::logging::v2::LogView>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_CreateView() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateView(::grpc::ServerContext* /*context*/, const ::google::logging::v2::CreateViewRequest* /*request*/, ::google::logging::v2::LogView* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* CreateView(
      ::grpc::CallbackServerContext* /*context*/, const ::google::logging::v2::CreateViewRequest* /*request*/, ::google::logging::v2::LogView* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_UpdateView : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_UpdateView() {
      ::grpc::Service::MarkMethodCallback(9,
          new ::grpc::internal::CallbackUnaryHandler< ::google::logging::v2::UpdateViewRequest, ::google::logging::v2::LogView>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::logging::v2::UpdateViewRequest* request, ::google::logging::v2::LogView* response) { return this->UpdateView(context, request, response); }));}
    void SetMessageAllocatorFor_UpdateView(
        ::grpc::MessageAllocator< ::google::logging::v2::UpdateViewRequest, ::google::logging::v2::LogView>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(9);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::logging::v2::UpdateViewRequest, ::google::logging::v2::LogView>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_UpdateView() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateView(::grpc::ServerContext* /*context*/, const ::google::logging::v2::UpdateViewRequest* /*request*/, ::google::logging::v2::LogView* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* UpdateView(
      ::grpc::CallbackServerContext* /*context*/, const ::google::logging::v2::UpdateViewRequest* /*request*/, ::google::logging::v2::LogView* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_DeleteView : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_DeleteView() {
      ::grpc::Service::MarkMethodCallback(10,
          new ::grpc::internal::CallbackUnaryHandler< ::google::logging::v2::DeleteViewRequest, ::google::protobuf::Empty>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::logging::v2::DeleteViewRequest* request, ::google::protobuf::Empty* response) { return this->DeleteView(context, request, response); }));}
    void SetMessageAllocatorFor_DeleteView(
        ::grpc::MessageAllocator< ::google::logging::v2::DeleteViewRequest, ::google::protobuf::Empty>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(10);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::logging::v2::DeleteViewRequest, ::google::protobuf::Empty>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_DeleteView() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteView(::grpc::ServerContext* /*context*/, const ::google::logging::v2::DeleteViewRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* DeleteView(
      ::grpc::CallbackServerContext* /*context*/, const ::google::logging::v2::DeleteViewRequest* /*request*/, ::google::protobuf::Empty* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_ListSinks : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_ListSinks() {
      ::grpc::Service::MarkMethodCallback(11,
          new ::grpc::internal::CallbackUnaryHandler< ::google::logging::v2::ListSinksRequest, ::google::logging::v2::ListSinksResponse>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::logging::v2::ListSinksRequest* request, ::google::logging::v2::ListSinksResponse* response) { return this->ListSinks(context, request, response); }));}
    void SetMessageAllocatorFor_ListSinks(
        ::grpc::MessageAllocator< ::google::logging::v2::ListSinksRequest, ::google::logging::v2::ListSinksResponse>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(11);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::logging::v2::ListSinksRequest, ::google::logging::v2::ListSinksResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_ListSinks() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListSinks(::grpc::ServerContext* /*context*/, const ::google::logging::v2::ListSinksRequest* /*request*/, ::google::logging::v2::ListSinksResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* ListSinks(
      ::grpc::CallbackServerContext* /*context*/, const ::google::logging::v2::ListSinksRequest* /*request*/, ::google::logging::v2::ListSinksResponse* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_GetSink : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_GetSink() {
      ::grpc::Service::MarkMethodCallback(12,
          new ::grpc::internal::CallbackUnaryHandler< ::google::logging::v2::GetSinkRequest, ::google::logging::v2::LogSink>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::logging::v2::GetSinkRequest* request, ::google::logging::v2::LogSink* response) { return this->GetSink(context, request, response); }));}
    void SetMessageAllocatorFor_GetSink(
        ::grpc::MessageAllocator< ::google::logging::v2::GetSinkRequest, ::google::logging::v2::LogSink>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(12);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::logging::v2::GetSinkRequest, ::google::logging::v2::LogSink>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_GetSink() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetSink(::grpc::ServerContext* /*context*/, const ::google::logging::v2::GetSinkRequest* /*request*/, ::google::logging::v2::LogSink* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* GetSink(
      ::grpc::CallbackServerContext* /*context*/, const ::google::logging::v2::GetSinkRequest* /*request*/, ::google::logging::v2::LogSink* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_CreateSink : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_CreateSink() {
      ::grpc::Service::MarkMethodCallback(13,
          new ::grpc::internal::CallbackUnaryHandler< ::google::logging::v2::CreateSinkRequest, ::google::logging::v2::LogSink>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::logging::v2::CreateSinkRequest* request, ::google::logging::v2::LogSink* response) { return this->CreateSink(context, request, response); }));}
    void SetMessageAllocatorFor_CreateSink(
        ::grpc::MessageAllocator< ::google::logging::v2::CreateSinkRequest, ::google::logging::v2::LogSink>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(13);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::logging::v2::CreateSinkRequest, ::google::logging::v2::LogSink>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_CreateSink() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateSink(::grpc::ServerContext* /*context*/, const ::google::logging::v2::CreateSinkRequest* /*request*/, ::google::logging::v2::LogSink* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* CreateSink(
      ::grpc::CallbackServerContext* /*context*/, const ::google::logging::v2::CreateSinkRequest* /*request*/, ::google::logging::v2::LogSink* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_UpdateSink : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_UpdateSink() {
      ::grpc::Service::MarkMethodCallback(14,
          new ::grpc::internal::CallbackUnaryHandler< ::google::logging::v2::UpdateSinkRequest, ::google::logging::v2::LogSink>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::logging::v2::UpdateSinkRequest* request, ::google::logging::v2::LogSink* response) { return this->UpdateSink(context, request, response); }));}
    void SetMessageAllocatorFor_UpdateSink(
        ::grpc::MessageAllocator< ::google::logging::v2::UpdateSinkRequest, ::google::logging::v2::LogSink>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(14);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::logging::v2::UpdateSinkRequest, ::google::logging::v2::LogSink>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_UpdateSink() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateSink(::grpc::ServerContext* /*context*/, const ::google::logging::v2::UpdateSinkRequest* /*request*/, ::google::logging::v2::LogSink* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* UpdateSink(
      ::grpc::CallbackServerContext* /*context*/, const ::google::logging::v2::UpdateSinkRequest* /*request*/, ::google::logging::v2::LogSink* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_DeleteSink : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_DeleteSink() {
      ::grpc::Service::MarkMethodCallback(15,
          new ::grpc::internal::CallbackUnaryHandler< ::google::logging::v2::DeleteSinkRequest, ::google::protobuf::Empty>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::logging::v2::DeleteSinkRequest* request, ::google::protobuf::Empty* response) { return this->DeleteSink(context, request, response); }));}
    void SetMessageAllocatorFor_DeleteSink(
        ::grpc::MessageAllocator< ::google::logging::v2::DeleteSinkRequest, ::google::protobuf::Empty>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(15);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::logging::v2::DeleteSinkRequest, ::google::protobuf::Empty>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_DeleteSink() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteSink(::grpc::ServerContext* /*context*/, const ::google::logging::v2::DeleteSinkRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* DeleteSink(
      ::grpc::CallbackServerContext* /*context*/, const ::google::logging::v2::DeleteSinkRequest* /*request*/, ::google::protobuf::Empty* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_ListExclusions : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_ListExclusions() {
      ::grpc::Service::MarkMethodCallback(16,
          new ::grpc::internal::CallbackUnaryHandler< ::google::logging::v2::ListExclusionsRequest, ::google::logging::v2::ListExclusionsResponse>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::logging::v2::ListExclusionsRequest* request, ::google::logging::v2::ListExclusionsResponse* response) { return this->ListExclusions(context, request, response); }));}
    void SetMessageAllocatorFor_ListExclusions(
        ::grpc::MessageAllocator< ::google::logging::v2::ListExclusionsRequest, ::google::logging::v2::ListExclusionsResponse>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(16);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::logging::v2::ListExclusionsRequest, ::google::logging::v2::ListExclusionsResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_ListExclusions() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListExclusions(::grpc::ServerContext* /*context*/, const ::google::logging::v2::ListExclusionsRequest* /*request*/, ::google::logging::v2::ListExclusionsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* ListExclusions(
      ::grpc::CallbackServerContext* /*context*/, const ::google::logging::v2::ListExclusionsRequest* /*request*/, ::google::logging::v2::ListExclusionsResponse* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_GetExclusion : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_GetExclusion() {
      ::grpc::Service::MarkMethodCallback(17,
          new ::grpc::internal::CallbackUnaryHandler< ::google::logging::v2::GetExclusionRequest, ::google::logging::v2::LogExclusion>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::logging::v2::GetExclusionRequest* request, ::google::logging::v2::LogExclusion* response) { return this->GetExclusion(context, request, response); }));}
    void SetMessageAllocatorFor_GetExclusion(
        ::grpc::MessageAllocator< ::google::logging::v2::GetExclusionRequest, ::google::logging::v2::LogExclusion>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(17);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::logging::v2::GetExclusionRequest, ::google::logging::v2::LogExclusion>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_GetExclusion() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetExclusion(::grpc::ServerContext* /*context*/, const ::google::logging::v2::GetExclusionRequest* /*request*/, ::google::logging::v2::LogExclusion* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* GetExclusion(
      ::grpc::CallbackServerContext* /*context*/, const ::google::logging::v2::GetExclusionRequest* /*request*/, ::google::logging::v2::LogExclusion* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_CreateExclusion : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_CreateExclusion() {
      ::grpc::Service::MarkMethodCallback(18,
          new ::grpc::internal::CallbackUnaryHandler< ::google::logging::v2::CreateExclusionRequest, ::google::logging::v2::LogExclusion>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::logging::v2::CreateExclusionRequest* request, ::google::logging::v2::LogExclusion* response) { return this->CreateExclusion(context, request, response); }));}
    void SetMessageAllocatorFor_CreateExclusion(
        ::grpc::MessageAllocator< ::google::logging::v2::CreateExclusionRequest, ::google::logging::v2::LogExclusion>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(18);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::logging::v2::CreateExclusionRequest, ::google::logging::v2::LogExclusion>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_CreateExclusion() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateExclusion(::grpc::ServerContext* /*context*/, const ::google::logging::v2::CreateExclusionRequest* /*request*/, ::google::logging::v2::LogExclusion* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* CreateExclusion(
      ::grpc::CallbackServerContext* /*context*/, const ::google::logging::v2::CreateExclusionRequest* /*request*/, ::google::logging::v2::LogExclusion* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_UpdateExclusion : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_UpdateExclusion() {
      ::grpc::Service::MarkMethodCallback(19,
          new ::grpc::internal::CallbackUnaryHandler< ::google::logging::v2::UpdateExclusionRequest, ::google::logging::v2::LogExclusion>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::logging::v2::UpdateExclusionRequest* request, ::google::logging::v2::LogExclusion* response) { return this->UpdateExclusion(context, request, response); }));}
    void SetMessageAllocatorFor_UpdateExclusion(
        ::grpc::MessageAllocator< ::google::logging::v2::UpdateExclusionRequest, ::google::logging::v2::LogExclusion>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(19);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::logging::v2::UpdateExclusionRequest, ::google::logging::v2::LogExclusion>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_UpdateExclusion() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateExclusion(::grpc::ServerContext* /*context*/, const ::google::logging::v2::UpdateExclusionRequest* /*request*/, ::google::logging::v2::LogExclusion* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* UpdateExclusion(
      ::grpc::CallbackServerContext* /*context*/, const ::google::logging::v2::UpdateExclusionRequest* /*request*/, ::google::logging::v2::LogExclusion* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_DeleteExclusion : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_DeleteExclusion() {
      ::grpc::Service::MarkMethodCallback(20,
          new ::grpc::internal::CallbackUnaryHandler< ::google::logging::v2::DeleteExclusionRequest, ::google::protobuf::Empty>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::logging::v2::DeleteExclusionRequest* request, ::google::protobuf::Empty* response) { return this->DeleteExclusion(context, request, response); }));}
    void SetMessageAllocatorFor_DeleteExclusion(
        ::grpc::MessageAllocator< ::google::logging::v2::DeleteExclusionRequest, ::google::protobuf::Empty>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(20);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::logging::v2::DeleteExclusionRequest, ::google::protobuf::Empty>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_DeleteExclusion() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteExclusion(::grpc::ServerContext* /*context*/, const ::google::logging::v2::DeleteExclusionRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* DeleteExclusion(
      ::grpc::CallbackServerContext* /*context*/, const ::google::logging::v2::DeleteExclusionRequest* /*request*/, ::google::protobuf::Empty* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_GetCmekSettings : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_GetCmekSettings() {
      ::grpc::Service::MarkMethodCallback(21,
          new ::grpc::internal::CallbackUnaryHandler< ::google::logging::v2::GetCmekSettingsRequest, ::google::logging::v2::CmekSettings>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::logging::v2::GetCmekSettingsRequest* request, ::google::logging::v2::CmekSettings* response) { return this->GetCmekSettings(context, request, response); }));}
    void SetMessageAllocatorFor_GetCmekSettings(
        ::grpc::MessageAllocator< ::google::logging::v2::GetCmekSettingsRequest, ::google::logging::v2::CmekSettings>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(21);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::logging::v2::GetCmekSettingsRequest, ::google::logging::v2::CmekSettings>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_GetCmekSettings() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetCmekSettings(::grpc::ServerContext* /*context*/, const ::google::logging::v2::GetCmekSettingsRequest* /*request*/, ::google::logging::v2::CmekSettings* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* GetCmekSettings(
      ::grpc::CallbackServerContext* /*context*/, const ::google::logging::v2::GetCmekSettingsRequest* /*request*/, ::google::logging::v2::CmekSettings* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_UpdateCmekSettings : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_UpdateCmekSettings() {
      ::grpc::Service::MarkMethodCallback(22,
          new ::grpc::internal::CallbackUnaryHandler< ::google::logging::v2::UpdateCmekSettingsRequest, ::google::logging::v2::CmekSettings>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::logging::v2::UpdateCmekSettingsRequest* request, ::google::logging::v2::CmekSettings* response) { return this->UpdateCmekSettings(context, request, response); }));}
    void SetMessageAllocatorFor_UpdateCmekSettings(
        ::grpc::MessageAllocator< ::google::logging::v2::UpdateCmekSettingsRequest, ::google::logging::v2::CmekSettings>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(22);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::logging::v2::UpdateCmekSettingsRequest, ::google::logging::v2::CmekSettings>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_UpdateCmekSettings() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateCmekSettings(::grpc::ServerContext* /*context*/, const ::google::logging::v2::UpdateCmekSettingsRequest* /*request*/, ::google::logging::v2::CmekSettings* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* UpdateCmekSettings(
      ::grpc::CallbackServerContext* /*context*/, const ::google::logging::v2::UpdateCmekSettingsRequest* /*request*/, ::google::logging::v2::CmekSettings* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_GetSettings : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_GetSettings() {
      ::grpc::Service::MarkMethodCallback(23,
          new ::grpc::internal::CallbackUnaryHandler< ::google::logging::v2::GetSettingsRequest, ::google::logging::v2::Settings>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::logging::v2::GetSettingsRequest* request, ::google::logging::v2::Settings* response) { return this->GetSettings(context, request, response); }));}
    void SetMessageAllocatorFor_GetSettings(
        ::grpc::MessageAllocator< ::google::logging::v2::GetSettingsRequest, ::google::logging::v2::Settings>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(23);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::logging::v2::GetSettingsRequest, ::google::logging::v2::Settings>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_GetSettings() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetSettings(::grpc::ServerContext* /*context*/, const ::google::logging::v2::GetSettingsRequest* /*request*/, ::google::logging::v2::Settings* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* GetSettings(
      ::grpc::CallbackServerContext* /*context*/, const ::google::logging::v2::GetSettingsRequest* /*request*/, ::google::logging::v2::Settings* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_UpdateSettings : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_UpdateSettings() {
      ::grpc::Service::MarkMethodCallback(24,
          new ::grpc::internal::CallbackUnaryHandler< ::google::logging::v2::UpdateSettingsRequest, ::google::logging::v2::Settings>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::logging::v2::UpdateSettingsRequest* request, ::google::logging::v2::Settings* response) { return this->UpdateSettings(context, request, response); }));}
    void SetMessageAllocatorFor_UpdateSettings(
        ::grpc::MessageAllocator< ::google::logging::v2::UpdateSettingsRequest, ::google::logging::v2::Settings>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(24);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::logging::v2::UpdateSettingsRequest, ::google::logging::v2::Settings>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_UpdateSettings() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateSettings(::grpc::ServerContext* /*context*/, const ::google::logging::v2::UpdateSettingsRequest* /*request*/, ::google::logging::v2::Settings* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* UpdateSettings(
      ::grpc::CallbackServerContext* /*context*/, const ::google::logging::v2::UpdateSettingsRequest* /*request*/, ::google::logging::v2::Settings* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_CopyLogEntries : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_CopyLogEntries() {
      ::grpc::Service::MarkMethodCallback(25,
          new ::grpc::internal::CallbackUnaryHandler< ::google::logging::v2::CopyLogEntriesRequest, ::google::longrunning::Operation>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::logging::v2::CopyLogEntriesRequest* request, ::google::longrunning::Operation* response) { return this->CopyLogEntries(context, request, response); }));}
    void SetMessageAllocatorFor_CopyLogEntries(
        ::grpc::MessageAllocator< ::google::logging::v2::CopyLogEntriesRequest, ::google::longrunning::Operation>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(25);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::logging::v2::CopyLogEntriesRequest, ::google::longrunning::Operation>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_CopyLogEntries() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CopyLogEntries(::grpc::ServerContext* /*context*/, const ::google::logging::v2::CopyLogEntriesRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* CopyLogEntries(
      ::grpc::CallbackServerContext* /*context*/, const ::google::logging::v2::CopyLogEntriesRequest* /*request*/, ::google::longrunning::Operation* /*response*/)  { return nullptr; }
  };
  typedef WithCallbackMethod_ListBuckets<WithCallbackMethod_GetBucket<WithCallbackMethod_CreateBucket<WithCallbackMethod_UpdateBucket<WithCallbackMethod_DeleteBucket<WithCallbackMethod_UndeleteBucket<WithCallbackMethod_ListViews<WithCallbackMethod_GetView<WithCallbackMethod_CreateView<WithCallbackMethod_UpdateView<WithCallbackMethod_DeleteView<WithCallbackMethod_ListSinks<WithCallbackMethod_GetSink<WithCallbackMethod_CreateSink<WithCallbackMethod_UpdateSink<WithCallbackMethod_DeleteSink<WithCallbackMethod_ListExclusions<WithCallbackMethod_GetExclusion<WithCallbackMethod_CreateExclusion<WithCallbackMethod_UpdateExclusion<WithCallbackMethod_DeleteExclusion<WithCallbackMethod_GetCmekSettings<WithCallbackMethod_UpdateCmekSettings<WithCallbackMethod_GetSettings<WithCallbackMethod_UpdateSettings<WithCallbackMethod_CopyLogEntries<Service > > > > > > > > > > > > > > > > > > > > > > > > > > CallbackService;
  typedef CallbackService ExperimentalCallbackService;
  template <class BaseClass>
  class WithGenericMethod_ListBuckets : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_ListBuckets() {
      ::grpc::Service::MarkMethodGeneric(0);
    }
    ~WithGenericMethod_ListBuckets() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListBuckets(::grpc::ServerContext* /*context*/, const ::google::logging::v2::ListBucketsRequest* /*request*/, ::google::logging::v2::ListBucketsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_GetBucket : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_GetBucket() {
      ::grpc::Service::MarkMethodGeneric(1);
    }
    ~WithGenericMethod_GetBucket() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetBucket(::grpc::ServerContext* /*context*/, const ::google::logging::v2::GetBucketRequest* /*request*/, ::google::logging::v2::LogBucket* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_CreateBucket : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_CreateBucket() {
      ::grpc::Service::MarkMethodGeneric(2);
    }
    ~WithGenericMethod_CreateBucket() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateBucket(::grpc::ServerContext* /*context*/, const ::google::logging::v2::CreateBucketRequest* /*request*/, ::google::logging::v2::LogBucket* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_UpdateBucket : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_UpdateBucket() {
      ::grpc::Service::MarkMethodGeneric(3);
    }
    ~WithGenericMethod_UpdateBucket() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateBucket(::grpc::ServerContext* /*context*/, const ::google::logging::v2::UpdateBucketRequest* /*request*/, ::google::logging::v2::LogBucket* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_DeleteBucket : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_DeleteBucket() {
      ::grpc::Service::MarkMethodGeneric(4);
    }
    ~WithGenericMethod_DeleteBucket() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteBucket(::grpc::ServerContext* /*context*/, const ::google::logging::v2::DeleteBucketRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_UndeleteBucket : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_UndeleteBucket() {
      ::grpc::Service::MarkMethodGeneric(5);
    }
    ~WithGenericMethod_UndeleteBucket() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UndeleteBucket(::grpc::ServerContext* /*context*/, const ::google::logging::v2::UndeleteBucketRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_ListViews : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_ListViews() {
      ::grpc::Service::MarkMethodGeneric(6);
    }
    ~WithGenericMethod_ListViews() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListViews(::grpc::ServerContext* /*context*/, const ::google::logging::v2::ListViewsRequest* /*request*/, ::google::logging::v2::ListViewsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_GetView : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_GetView() {
      ::grpc::Service::MarkMethodGeneric(7);
    }
    ~WithGenericMethod_GetView() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetView(::grpc::ServerContext* /*context*/, const ::google::logging::v2::GetViewRequest* /*request*/, ::google::logging::v2::LogView* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_CreateView : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_CreateView() {
      ::grpc::Service::MarkMethodGeneric(8);
    }
    ~WithGenericMethod_CreateView() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateView(::grpc::ServerContext* /*context*/, const ::google::logging::v2::CreateViewRequest* /*request*/, ::google::logging::v2::LogView* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_UpdateView : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_UpdateView() {
      ::grpc::Service::MarkMethodGeneric(9);
    }
    ~WithGenericMethod_UpdateView() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateView(::grpc::ServerContext* /*context*/, const ::google::logging::v2::UpdateViewRequest* /*request*/, ::google::logging::v2::LogView* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_DeleteView : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_DeleteView() {
      ::grpc::Service::MarkMethodGeneric(10);
    }
    ~WithGenericMethod_DeleteView() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteView(::grpc::ServerContext* /*context*/, const ::google::logging::v2::DeleteViewRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_ListSinks : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_ListSinks() {
      ::grpc::Service::MarkMethodGeneric(11);
    }
    ~WithGenericMethod_ListSinks() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListSinks(::grpc::ServerContext* /*context*/, const ::google::logging::v2::ListSinksRequest* /*request*/, ::google::logging::v2::ListSinksResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_GetSink : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_GetSink() {
      ::grpc::Service::MarkMethodGeneric(12);
    }
    ~WithGenericMethod_GetSink() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetSink(::grpc::ServerContext* /*context*/, const ::google::logging::v2::GetSinkRequest* /*request*/, ::google::logging::v2::LogSink* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_CreateSink : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_CreateSink() {
      ::grpc::Service::MarkMethodGeneric(13);
    }
    ~WithGenericMethod_CreateSink() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateSink(::grpc::ServerContext* /*context*/, const ::google::logging::v2::CreateSinkRequest* /*request*/, ::google::logging::v2::LogSink* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_UpdateSink : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_UpdateSink() {
      ::grpc::Service::MarkMethodGeneric(14);
    }
    ~WithGenericMethod_UpdateSink() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateSink(::grpc::ServerContext* /*context*/, const ::google::logging::v2::UpdateSinkRequest* /*request*/, ::google::logging::v2::LogSink* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_DeleteSink : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_DeleteSink() {
      ::grpc::Service::MarkMethodGeneric(15);
    }
    ~WithGenericMethod_DeleteSink() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteSink(::grpc::ServerContext* /*context*/, const ::google::logging::v2::DeleteSinkRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_ListExclusions : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_ListExclusions() {
      ::grpc::Service::MarkMethodGeneric(16);
    }
    ~WithGenericMethod_ListExclusions() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListExclusions(::grpc::ServerContext* /*context*/, const ::google::logging::v2::ListExclusionsRequest* /*request*/, ::google::logging::v2::ListExclusionsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_GetExclusion : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_GetExclusion() {
      ::grpc::Service::MarkMethodGeneric(17);
    }
    ~WithGenericMethod_GetExclusion() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetExclusion(::grpc::ServerContext* /*context*/, const ::google::logging::v2::GetExclusionRequest* /*request*/, ::google::logging::v2::LogExclusion* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_CreateExclusion : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_CreateExclusion() {
      ::grpc::Service::MarkMethodGeneric(18);
    }
    ~WithGenericMethod_CreateExclusion() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateExclusion(::grpc::ServerContext* /*context*/, const ::google::logging::v2::CreateExclusionRequest* /*request*/, ::google::logging::v2::LogExclusion* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_UpdateExclusion : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_UpdateExclusion() {
      ::grpc::Service::MarkMethodGeneric(19);
    }
    ~WithGenericMethod_UpdateExclusion() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateExclusion(::grpc::ServerContext* /*context*/, const ::google::logging::v2::UpdateExclusionRequest* /*request*/, ::google::logging::v2::LogExclusion* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_DeleteExclusion : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_DeleteExclusion() {
      ::grpc::Service::MarkMethodGeneric(20);
    }
    ~WithGenericMethod_DeleteExclusion() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteExclusion(::grpc::ServerContext* /*context*/, const ::google::logging::v2::DeleteExclusionRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_GetCmekSettings : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_GetCmekSettings() {
      ::grpc::Service::MarkMethodGeneric(21);
    }
    ~WithGenericMethod_GetCmekSettings() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetCmekSettings(::grpc::ServerContext* /*context*/, const ::google::logging::v2::GetCmekSettingsRequest* /*request*/, ::google::logging::v2::CmekSettings* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_UpdateCmekSettings : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_UpdateCmekSettings() {
      ::grpc::Service::MarkMethodGeneric(22);
    }
    ~WithGenericMethod_UpdateCmekSettings() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateCmekSettings(::grpc::ServerContext* /*context*/, const ::google::logging::v2::UpdateCmekSettingsRequest* /*request*/, ::google::logging::v2::CmekSettings* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_GetSettings : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_GetSettings() {
      ::grpc::Service::MarkMethodGeneric(23);
    }
    ~WithGenericMethod_GetSettings() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetSettings(::grpc::ServerContext* /*context*/, const ::google::logging::v2::GetSettingsRequest* /*request*/, ::google::logging::v2::Settings* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_UpdateSettings : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_UpdateSettings() {
      ::grpc::Service::MarkMethodGeneric(24);
    }
    ~WithGenericMethod_UpdateSettings() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateSettings(::grpc::ServerContext* /*context*/, const ::google::logging::v2::UpdateSettingsRequest* /*request*/, ::google::logging::v2::Settings* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_CopyLogEntries : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_CopyLogEntries() {
      ::grpc::Service::MarkMethodGeneric(25);
    }
    ~WithGenericMethod_CopyLogEntries() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CopyLogEntries(::grpc::ServerContext* /*context*/, const ::google::logging::v2::CopyLogEntriesRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithRawMethod_ListBuckets : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_ListBuckets() {
      ::grpc::Service::MarkMethodRaw(0);
    }
    ~WithRawMethod_ListBuckets() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListBuckets(::grpc::ServerContext* /*context*/, const ::google::logging::v2::ListBucketsRequest* /*request*/, ::google::logging::v2::ListBucketsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestListBuckets(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(0, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_GetBucket : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_GetBucket() {
      ::grpc::Service::MarkMethodRaw(1);
    }
    ~WithRawMethod_GetBucket() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetBucket(::grpc::ServerContext* /*context*/, const ::google::logging::v2::GetBucketRequest* /*request*/, ::google::logging::v2::LogBucket* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGetBucket(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(1, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_CreateBucket : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_CreateBucket() {
      ::grpc::Service::MarkMethodRaw(2);
    }
    ~WithRawMethod_CreateBucket() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateBucket(::grpc::ServerContext* /*context*/, const ::google::logging::v2::CreateBucketRequest* /*request*/, ::google::logging::v2::LogBucket* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestCreateBucket(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(2, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_UpdateBucket : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_UpdateBucket() {
      ::grpc::Service::MarkMethodRaw(3);
    }
    ~WithRawMethod_UpdateBucket() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateBucket(::grpc::ServerContext* /*context*/, const ::google::logging::v2::UpdateBucketRequest* /*request*/, ::google::logging::v2::LogBucket* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestUpdateBucket(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(3, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_DeleteBucket : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_DeleteBucket() {
      ::grpc::Service::MarkMethodRaw(4);
    }
    ~WithRawMethod_DeleteBucket() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteBucket(::grpc::ServerContext* /*context*/, const ::google::logging::v2::DeleteBucketRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestDeleteBucket(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(4, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_UndeleteBucket : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_UndeleteBucket() {
      ::grpc::Service::MarkMethodRaw(5);
    }
    ~WithRawMethod_UndeleteBucket() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UndeleteBucket(::grpc::ServerContext* /*context*/, const ::google::logging::v2::UndeleteBucketRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestUndeleteBucket(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(5, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_ListViews : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_ListViews() {
      ::grpc::Service::MarkMethodRaw(6);
    }
    ~WithRawMethod_ListViews() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListViews(::grpc::ServerContext* /*context*/, const ::google::logging::v2::ListViewsRequest* /*request*/, ::google::logging::v2::ListViewsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestListViews(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(6, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_GetView : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_GetView() {
      ::grpc::Service::MarkMethodRaw(7);
    }
    ~WithRawMethod_GetView() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetView(::grpc::ServerContext* /*context*/, const ::google::logging::v2::GetViewRequest* /*request*/, ::google::logging::v2::LogView* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGetView(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(7, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_CreateView : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_CreateView() {
      ::grpc::Service::MarkMethodRaw(8);
    }
    ~WithRawMethod_CreateView() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateView(::grpc::ServerContext* /*context*/, const ::google::logging::v2::CreateViewRequest* /*request*/, ::google::logging::v2::LogView* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestCreateView(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(8, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_UpdateView : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_UpdateView() {
      ::grpc::Service::MarkMethodRaw(9);
    }
    ~WithRawMethod_UpdateView() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateView(::grpc::ServerContext* /*context*/, const ::google::logging::v2::UpdateViewRequest* /*request*/, ::google::logging::v2::LogView* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestUpdateView(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(9, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_DeleteView : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_DeleteView() {
      ::grpc::Service::MarkMethodRaw(10);
    }
    ~WithRawMethod_DeleteView() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteView(::grpc::ServerContext* /*context*/, const ::google::logging::v2::DeleteViewRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestDeleteView(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(10, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_ListSinks : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_ListSinks() {
      ::grpc::Service::MarkMethodRaw(11);
    }
    ~WithRawMethod_ListSinks() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListSinks(::grpc::ServerContext* /*context*/, const ::google::logging::v2::ListSinksRequest* /*request*/, ::google::logging::v2::ListSinksResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestListSinks(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(11, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_GetSink : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_GetSink() {
      ::grpc::Service::MarkMethodRaw(12);
    }
    ~WithRawMethod_GetSink() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetSink(::grpc::ServerContext* /*context*/, const ::google::logging::v2::GetSinkRequest* /*request*/, ::google::logging::v2::LogSink* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGetSink(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(12, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_CreateSink : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_CreateSink() {
      ::grpc::Service::MarkMethodRaw(13);
    }
    ~WithRawMethod_CreateSink() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateSink(::grpc::ServerContext* /*context*/, const ::google::logging::v2::CreateSinkRequest* /*request*/, ::google::logging::v2::LogSink* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestCreateSink(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(13, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_UpdateSink : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_UpdateSink() {
      ::grpc::Service::MarkMethodRaw(14);
    }
    ~WithRawMethod_UpdateSink() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateSink(::grpc::ServerContext* /*context*/, const ::google::logging::v2::UpdateSinkRequest* /*request*/, ::google::logging::v2::LogSink* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestUpdateSink(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(14, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_DeleteSink : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_DeleteSink() {
      ::grpc::Service::MarkMethodRaw(15);
    }
    ~WithRawMethod_DeleteSink() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteSink(::grpc::ServerContext* /*context*/, const ::google::logging::v2::DeleteSinkRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestDeleteSink(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(15, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_ListExclusions : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_ListExclusions() {
      ::grpc::Service::MarkMethodRaw(16);
    }
    ~WithRawMethod_ListExclusions() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListExclusions(::grpc::ServerContext* /*context*/, const ::google::logging::v2::ListExclusionsRequest* /*request*/, ::google::logging::v2::ListExclusionsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestListExclusions(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(16, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_GetExclusion : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_GetExclusion() {
      ::grpc::Service::MarkMethodRaw(17);
    }
    ~WithRawMethod_GetExclusion() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetExclusion(::grpc::ServerContext* /*context*/, const ::google::logging::v2::GetExclusionRequest* /*request*/, ::google::logging::v2::LogExclusion* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGetExclusion(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(17, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_CreateExclusion : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_CreateExclusion() {
      ::grpc::Service::MarkMethodRaw(18);
    }
    ~WithRawMethod_CreateExclusion() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateExclusion(::grpc::ServerContext* /*context*/, const ::google::logging::v2::CreateExclusionRequest* /*request*/, ::google::logging::v2::LogExclusion* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestCreateExclusion(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(18, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_UpdateExclusion : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_UpdateExclusion() {
      ::grpc::Service::MarkMethodRaw(19);
    }
    ~WithRawMethod_UpdateExclusion() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateExclusion(::grpc::ServerContext* /*context*/, const ::google::logging::v2::UpdateExclusionRequest* /*request*/, ::google::logging::v2::LogExclusion* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestUpdateExclusion(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(19, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_DeleteExclusion : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_DeleteExclusion() {
      ::grpc::Service::MarkMethodRaw(20);
    }
    ~WithRawMethod_DeleteExclusion() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteExclusion(::grpc::ServerContext* /*context*/, const ::google::logging::v2::DeleteExclusionRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestDeleteExclusion(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(20, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_GetCmekSettings : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_GetCmekSettings() {
      ::grpc::Service::MarkMethodRaw(21);
    }
    ~WithRawMethod_GetCmekSettings() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetCmekSettings(::grpc::ServerContext* /*context*/, const ::google::logging::v2::GetCmekSettingsRequest* /*request*/, ::google::logging::v2::CmekSettings* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGetCmekSettings(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(21, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_UpdateCmekSettings : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_UpdateCmekSettings() {
      ::grpc::Service::MarkMethodRaw(22);
    }
    ~WithRawMethod_UpdateCmekSettings() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateCmekSettings(::grpc::ServerContext* /*context*/, const ::google::logging::v2::UpdateCmekSettingsRequest* /*request*/, ::google::logging::v2::CmekSettings* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestUpdateCmekSettings(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(22, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_GetSettings : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_GetSettings() {
      ::grpc::Service::MarkMethodRaw(23);
    }
    ~WithRawMethod_GetSettings() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetSettings(::grpc::ServerContext* /*context*/, const ::google::logging::v2::GetSettingsRequest* /*request*/, ::google::logging::v2::Settings* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGetSettings(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(23, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_UpdateSettings : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_UpdateSettings() {
      ::grpc::Service::MarkMethodRaw(24);
    }
    ~WithRawMethod_UpdateSettings() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateSettings(::grpc::ServerContext* /*context*/, const ::google::logging::v2::UpdateSettingsRequest* /*request*/, ::google::logging::v2::Settings* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestUpdateSettings(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(24, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_CopyLogEntries : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_CopyLogEntries() {
      ::grpc::Service::MarkMethodRaw(25);
    }
    ~WithRawMethod_CopyLogEntries() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CopyLogEntries(::grpc::ServerContext* /*context*/, const ::google::logging::v2::CopyLogEntriesRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestCopyLogEntries(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(25, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_ListBuckets : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_ListBuckets() {
      ::grpc::Service::MarkMethodRawCallback(0,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->ListBuckets(context, request, response); }));
    }
    ~WithRawCallbackMethod_ListBuckets() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListBuckets(::grpc::ServerContext* /*context*/, const ::google::logging::v2::ListBucketsRequest* /*request*/, ::google::logging::v2::ListBucketsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* ListBuckets(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_GetBucket : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_GetBucket() {
      ::grpc::Service::MarkMethodRawCallback(1,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->GetBucket(context, request, response); }));
    }
    ~WithRawCallbackMethod_GetBucket() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetBucket(::grpc::ServerContext* /*context*/, const ::google::logging::v2::GetBucketRequest* /*request*/, ::google::logging::v2::LogBucket* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* GetBucket(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_CreateBucket : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_CreateBucket() {
      ::grpc::Service::MarkMethodRawCallback(2,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->CreateBucket(context, request, response); }));
    }
    ~WithRawCallbackMethod_CreateBucket() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateBucket(::grpc::ServerContext* /*context*/, const ::google::logging::v2::CreateBucketRequest* /*request*/, ::google::logging::v2::LogBucket* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* CreateBucket(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_UpdateBucket : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_UpdateBucket() {
      ::grpc::Service::MarkMethodRawCallback(3,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->UpdateBucket(context, request, response); }));
    }
    ~WithRawCallbackMethod_UpdateBucket() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateBucket(::grpc::ServerContext* /*context*/, const ::google::logging::v2::UpdateBucketRequest* /*request*/, ::google::logging::v2::LogBucket* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* UpdateBucket(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_DeleteBucket : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_DeleteBucket() {
      ::grpc::Service::MarkMethodRawCallback(4,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->DeleteBucket(context, request, response); }));
    }
    ~WithRawCallbackMethod_DeleteBucket() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteBucket(::grpc::ServerContext* /*context*/, const ::google::logging::v2::DeleteBucketRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* DeleteBucket(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_UndeleteBucket : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_UndeleteBucket() {
      ::grpc::Service::MarkMethodRawCallback(5,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->UndeleteBucket(context, request, response); }));
    }
    ~WithRawCallbackMethod_UndeleteBucket() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UndeleteBucket(::grpc::ServerContext* /*context*/, const ::google::logging::v2::UndeleteBucketRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* UndeleteBucket(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_ListViews : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_ListViews() {
      ::grpc::Service::MarkMethodRawCallback(6,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->ListViews(context, request, response); }));
    }
    ~WithRawCallbackMethod_ListViews() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListViews(::grpc::ServerContext* /*context*/, const ::google::logging::v2::ListViewsRequest* /*request*/, ::google::logging::v2::ListViewsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* ListViews(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_GetView : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_GetView() {
      ::grpc::Service::MarkMethodRawCallback(7,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->GetView(context, request, response); }));
    }
    ~WithRawCallbackMethod_GetView() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetView(::grpc::ServerContext* /*context*/, const ::google::logging::v2::GetViewRequest* /*request*/, ::google::logging::v2::LogView* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* GetView(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_CreateView : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_CreateView() {
      ::grpc::Service::MarkMethodRawCallback(8,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->CreateView(context, request, response); }));
    }
    ~WithRawCallbackMethod_CreateView() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateView(::grpc::ServerContext* /*context*/, const ::google::logging::v2::CreateViewRequest* /*request*/, ::google::logging::v2::LogView* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* CreateView(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_UpdateView : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_UpdateView() {
      ::grpc::Service::MarkMethodRawCallback(9,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->UpdateView(context, request, response); }));
    }
    ~WithRawCallbackMethod_UpdateView() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateView(::grpc::ServerContext* /*context*/, const ::google::logging::v2::UpdateViewRequest* /*request*/, ::google::logging::v2::LogView* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* UpdateView(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_DeleteView : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_DeleteView() {
      ::grpc::Service::MarkMethodRawCallback(10,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->DeleteView(context, request, response); }));
    }
    ~WithRawCallbackMethod_DeleteView() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteView(::grpc::ServerContext* /*context*/, const ::google::logging::v2::DeleteViewRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* DeleteView(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_ListSinks : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_ListSinks() {
      ::grpc::Service::MarkMethodRawCallback(11,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->ListSinks(context, request, response); }));
    }
    ~WithRawCallbackMethod_ListSinks() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListSinks(::grpc::ServerContext* /*context*/, const ::google::logging::v2::ListSinksRequest* /*request*/, ::google::logging::v2::ListSinksResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* ListSinks(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_GetSink : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_GetSink() {
      ::grpc::Service::MarkMethodRawCallback(12,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->GetSink(context, request, response); }));
    }
    ~WithRawCallbackMethod_GetSink() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetSink(::grpc::ServerContext* /*context*/, const ::google::logging::v2::GetSinkRequest* /*request*/, ::google::logging::v2::LogSink* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* GetSink(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_CreateSink : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_CreateSink() {
      ::grpc::Service::MarkMethodRawCallback(13,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->CreateSink(context, request, response); }));
    }
    ~WithRawCallbackMethod_CreateSink() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateSink(::grpc::ServerContext* /*context*/, const ::google::logging::v2::CreateSinkRequest* /*request*/, ::google::logging::v2::LogSink* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* CreateSink(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_UpdateSink : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_UpdateSink() {
      ::grpc::Service::MarkMethodRawCallback(14,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->UpdateSink(context, request, response); }));
    }
    ~WithRawCallbackMethod_UpdateSink() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateSink(::grpc::ServerContext* /*context*/, const ::google::logging::v2::UpdateSinkRequest* /*request*/, ::google::logging::v2::LogSink* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* UpdateSink(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_DeleteSink : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_DeleteSink() {
      ::grpc::Service::MarkMethodRawCallback(15,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->DeleteSink(context, request, response); }));
    }
    ~WithRawCallbackMethod_DeleteSink() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteSink(::grpc::ServerContext* /*context*/, const ::google::logging::v2::DeleteSinkRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* DeleteSink(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_ListExclusions : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_ListExclusions() {
      ::grpc::Service::MarkMethodRawCallback(16,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->ListExclusions(context, request, response); }));
    }
    ~WithRawCallbackMethod_ListExclusions() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListExclusions(::grpc::ServerContext* /*context*/, const ::google::logging::v2::ListExclusionsRequest* /*request*/, ::google::logging::v2::ListExclusionsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* ListExclusions(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_GetExclusion : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_GetExclusion() {
      ::grpc::Service::MarkMethodRawCallback(17,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->GetExclusion(context, request, response); }));
    }
    ~WithRawCallbackMethod_GetExclusion() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetExclusion(::grpc::ServerContext* /*context*/, const ::google::logging::v2::GetExclusionRequest* /*request*/, ::google::logging::v2::LogExclusion* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* GetExclusion(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_CreateExclusion : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_CreateExclusion() {
      ::grpc::Service::MarkMethodRawCallback(18,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->CreateExclusion(context, request, response); }));
    }
    ~WithRawCallbackMethod_CreateExclusion() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateExclusion(::grpc::ServerContext* /*context*/, const ::google::logging::v2::CreateExclusionRequest* /*request*/, ::google::logging::v2::LogExclusion* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* CreateExclusion(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_UpdateExclusion : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_UpdateExclusion() {
      ::grpc::Service::MarkMethodRawCallback(19,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->UpdateExclusion(context, request, response); }));
    }
    ~WithRawCallbackMethod_UpdateExclusion() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateExclusion(::grpc::ServerContext* /*context*/, const ::google::logging::v2::UpdateExclusionRequest* /*request*/, ::google::logging::v2::LogExclusion* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* UpdateExclusion(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_DeleteExclusion : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_DeleteExclusion() {
      ::grpc::Service::MarkMethodRawCallback(20,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->DeleteExclusion(context, request, response); }));
    }
    ~WithRawCallbackMethod_DeleteExclusion() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteExclusion(::grpc::ServerContext* /*context*/, const ::google::logging::v2::DeleteExclusionRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* DeleteExclusion(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_GetCmekSettings : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_GetCmekSettings() {
      ::grpc::Service::MarkMethodRawCallback(21,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->GetCmekSettings(context, request, response); }));
    }
    ~WithRawCallbackMethod_GetCmekSettings() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetCmekSettings(::grpc::ServerContext* /*context*/, const ::google::logging::v2::GetCmekSettingsRequest* /*request*/, ::google::logging::v2::CmekSettings* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* GetCmekSettings(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_UpdateCmekSettings : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_UpdateCmekSettings() {
      ::grpc::Service::MarkMethodRawCallback(22,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->UpdateCmekSettings(context, request, response); }));
    }
    ~WithRawCallbackMethod_UpdateCmekSettings() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateCmekSettings(::grpc::ServerContext* /*context*/, const ::google::logging::v2::UpdateCmekSettingsRequest* /*request*/, ::google::logging::v2::CmekSettings* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* UpdateCmekSettings(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_GetSettings : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_GetSettings() {
      ::grpc::Service::MarkMethodRawCallback(23,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->GetSettings(context, request, response); }));
    }
    ~WithRawCallbackMethod_GetSettings() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetSettings(::grpc::ServerContext* /*context*/, const ::google::logging::v2::GetSettingsRequest* /*request*/, ::google::logging::v2::Settings* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* GetSettings(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_UpdateSettings : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_UpdateSettings() {
      ::grpc::Service::MarkMethodRawCallback(24,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->UpdateSettings(context, request, response); }));
    }
    ~WithRawCallbackMethod_UpdateSettings() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateSettings(::grpc::ServerContext* /*context*/, const ::google::logging::v2::UpdateSettingsRequest* /*request*/, ::google::logging::v2::Settings* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* UpdateSettings(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_CopyLogEntries : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_CopyLogEntries() {
      ::grpc::Service::MarkMethodRawCallback(25,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->CopyLogEntries(context, request, response); }));
    }
    ~WithRawCallbackMethod_CopyLogEntries() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CopyLogEntries(::grpc::ServerContext* /*context*/, const ::google::logging::v2::CopyLogEntriesRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* CopyLogEntries(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_ListBuckets : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_ListBuckets() {
      ::grpc::Service::MarkMethodStreamed(0,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::logging::v2::ListBucketsRequest, ::google::logging::v2::ListBucketsResponse>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::logging::v2::ListBucketsRequest, ::google::logging::v2::ListBucketsResponse>* streamer) {
                       return this->StreamedListBuckets(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_ListBuckets() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status ListBuckets(::grpc::ServerContext* /*context*/, const ::google::logging::v2::ListBucketsRequest* /*request*/, ::google::logging::v2::ListBucketsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedListBuckets(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::logging::v2::ListBucketsRequest,::google::logging::v2::ListBucketsResponse>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_GetBucket : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_GetBucket() {
      ::grpc::Service::MarkMethodStreamed(1,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::logging::v2::GetBucketRequest, ::google::logging::v2::LogBucket>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::logging::v2::GetBucketRequest, ::google::logging::v2::LogBucket>* streamer) {
                       return this->StreamedGetBucket(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_GetBucket() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status GetBucket(::grpc::ServerContext* /*context*/, const ::google::logging::v2::GetBucketRequest* /*request*/, ::google::logging::v2::LogBucket* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedGetBucket(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::logging::v2::GetBucketRequest,::google::logging::v2::LogBucket>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_CreateBucket : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_CreateBucket() {
      ::grpc::Service::MarkMethodStreamed(2,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::logging::v2::CreateBucketRequest, ::google::logging::v2::LogBucket>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::logging::v2::CreateBucketRequest, ::google::logging::v2::LogBucket>* streamer) {
                       return this->StreamedCreateBucket(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_CreateBucket() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status CreateBucket(::grpc::ServerContext* /*context*/, const ::google::logging::v2::CreateBucketRequest* /*request*/, ::google::logging::v2::LogBucket* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedCreateBucket(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::logging::v2::CreateBucketRequest,::google::logging::v2::LogBucket>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_UpdateBucket : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_UpdateBucket() {
      ::grpc::Service::MarkMethodStreamed(3,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::logging::v2::UpdateBucketRequest, ::google::logging::v2::LogBucket>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::logging::v2::UpdateBucketRequest, ::google::logging::v2::LogBucket>* streamer) {
                       return this->StreamedUpdateBucket(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_UpdateBucket() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status UpdateBucket(::grpc::ServerContext* /*context*/, const ::google::logging::v2::UpdateBucketRequest* /*request*/, ::google::logging::v2::LogBucket* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedUpdateBucket(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::logging::v2::UpdateBucketRequest,::google::logging::v2::LogBucket>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_DeleteBucket : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_DeleteBucket() {
      ::grpc::Service::MarkMethodStreamed(4,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::logging::v2::DeleteBucketRequest, ::google::protobuf::Empty>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::logging::v2::DeleteBucketRequest, ::google::protobuf::Empty>* streamer) {
                       return this->StreamedDeleteBucket(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_DeleteBucket() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status DeleteBucket(::grpc::ServerContext* /*context*/, const ::google::logging::v2::DeleteBucketRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedDeleteBucket(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::logging::v2::DeleteBucketRequest,::google::protobuf::Empty>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_UndeleteBucket : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_UndeleteBucket() {
      ::grpc::Service::MarkMethodStreamed(5,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::logging::v2::UndeleteBucketRequest, ::google::protobuf::Empty>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::logging::v2::UndeleteBucketRequest, ::google::protobuf::Empty>* streamer) {
                       return this->StreamedUndeleteBucket(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_UndeleteBucket() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status UndeleteBucket(::grpc::ServerContext* /*context*/, const ::google::logging::v2::UndeleteBucketRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedUndeleteBucket(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::logging::v2::UndeleteBucketRequest,::google::protobuf::Empty>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_ListViews : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_ListViews() {
      ::grpc::Service::MarkMethodStreamed(6,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::logging::v2::ListViewsRequest, ::google::logging::v2::ListViewsResponse>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::logging::v2::ListViewsRequest, ::google::logging::v2::ListViewsResponse>* streamer) {
                       return this->StreamedListViews(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_ListViews() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status ListViews(::grpc::ServerContext* /*context*/, const ::google::logging::v2::ListViewsRequest* /*request*/, ::google::logging::v2::ListViewsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedListViews(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::logging::v2::ListViewsRequest,::google::logging::v2::ListViewsResponse>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_GetView : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_GetView() {
      ::grpc::Service::MarkMethodStreamed(7,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::logging::v2::GetViewRequest, ::google::logging::v2::LogView>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::logging::v2::GetViewRequest, ::google::logging::v2::LogView>* streamer) {
                       return this->StreamedGetView(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_GetView() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status GetView(::grpc::ServerContext* /*context*/, const ::google::logging::v2::GetViewRequest* /*request*/, ::google::logging::v2::LogView* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedGetView(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::logging::v2::GetViewRequest,::google::logging::v2::LogView>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_CreateView : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_CreateView() {
      ::grpc::Service::MarkMethodStreamed(8,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::logging::v2::CreateViewRequest, ::google::logging::v2::LogView>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::logging::v2::CreateViewRequest, ::google::logging::v2::LogView>* streamer) {
                       return this->StreamedCreateView(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_CreateView() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status CreateView(::grpc::ServerContext* /*context*/, const ::google::logging::v2::CreateViewRequest* /*request*/, ::google::logging::v2::LogView* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedCreateView(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::logging::v2::CreateViewRequest,::google::logging::v2::LogView>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_UpdateView : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_UpdateView() {
      ::grpc::Service::MarkMethodStreamed(9,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::logging::v2::UpdateViewRequest, ::google::logging::v2::LogView>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::logging::v2::UpdateViewRequest, ::google::logging::v2::LogView>* streamer) {
                       return this->StreamedUpdateView(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_UpdateView() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status UpdateView(::grpc::ServerContext* /*context*/, const ::google::logging::v2::UpdateViewRequest* /*request*/, ::google::logging::v2::LogView* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedUpdateView(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::logging::v2::UpdateViewRequest,::google::logging::v2::LogView>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_DeleteView : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_DeleteView() {
      ::grpc::Service::MarkMethodStreamed(10,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::logging::v2::DeleteViewRequest, ::google::protobuf::Empty>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::logging::v2::DeleteViewRequest, ::google::protobuf::Empty>* streamer) {
                       return this->StreamedDeleteView(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_DeleteView() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status DeleteView(::grpc::ServerContext* /*context*/, const ::google::logging::v2::DeleteViewRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedDeleteView(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::logging::v2::DeleteViewRequest,::google::protobuf::Empty>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_ListSinks : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_ListSinks() {
      ::grpc::Service::MarkMethodStreamed(11,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::logging::v2::ListSinksRequest, ::google::logging::v2::ListSinksResponse>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::logging::v2::ListSinksRequest, ::google::logging::v2::ListSinksResponse>* streamer) {
                       return this->StreamedListSinks(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_ListSinks() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status ListSinks(::grpc::ServerContext* /*context*/, const ::google::logging::v2::ListSinksRequest* /*request*/, ::google::logging::v2::ListSinksResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedListSinks(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::logging::v2::ListSinksRequest,::google::logging::v2::ListSinksResponse>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_GetSink : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_GetSink() {
      ::grpc::Service::MarkMethodStreamed(12,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::logging::v2::GetSinkRequest, ::google::logging::v2::LogSink>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::logging::v2::GetSinkRequest, ::google::logging::v2::LogSink>* streamer) {
                       return this->StreamedGetSink(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_GetSink() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status GetSink(::grpc::ServerContext* /*context*/, const ::google::logging::v2::GetSinkRequest* /*request*/, ::google::logging::v2::LogSink* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedGetSink(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::logging::v2::GetSinkRequest,::google::logging::v2::LogSink>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_CreateSink : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_CreateSink() {
      ::grpc::Service::MarkMethodStreamed(13,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::logging::v2::CreateSinkRequest, ::google::logging::v2::LogSink>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::logging::v2::CreateSinkRequest, ::google::logging::v2::LogSink>* streamer) {
                       return this->StreamedCreateSink(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_CreateSink() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status CreateSink(::grpc::ServerContext* /*context*/, const ::google::logging::v2::CreateSinkRequest* /*request*/, ::google::logging::v2::LogSink* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedCreateSink(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::logging::v2::CreateSinkRequest,::google::logging::v2::LogSink>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_UpdateSink : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_UpdateSink() {
      ::grpc::Service::MarkMethodStreamed(14,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::logging::v2::UpdateSinkRequest, ::google::logging::v2::LogSink>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::logging::v2::UpdateSinkRequest, ::google::logging::v2::LogSink>* streamer) {
                       return this->StreamedUpdateSink(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_UpdateSink() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status UpdateSink(::grpc::ServerContext* /*context*/, const ::google::logging::v2::UpdateSinkRequest* /*request*/, ::google::logging::v2::LogSink* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedUpdateSink(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::logging::v2::UpdateSinkRequest,::google::logging::v2::LogSink>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_DeleteSink : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_DeleteSink() {
      ::grpc::Service::MarkMethodStreamed(15,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::logging::v2::DeleteSinkRequest, ::google::protobuf::Empty>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::logging::v2::DeleteSinkRequest, ::google::protobuf::Empty>* streamer) {
                       return this->StreamedDeleteSink(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_DeleteSink() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status DeleteSink(::grpc::ServerContext* /*context*/, const ::google::logging::v2::DeleteSinkRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedDeleteSink(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::logging::v2::DeleteSinkRequest,::google::protobuf::Empty>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_ListExclusions : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_ListExclusions() {
      ::grpc::Service::MarkMethodStreamed(16,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::logging::v2::ListExclusionsRequest, ::google::logging::v2::ListExclusionsResponse>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::logging::v2::ListExclusionsRequest, ::google::logging::v2::ListExclusionsResponse>* streamer) {
                       return this->StreamedListExclusions(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_ListExclusions() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status ListExclusions(::grpc::ServerContext* /*context*/, const ::google::logging::v2::ListExclusionsRequest* /*request*/, ::google::logging::v2::ListExclusionsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedListExclusions(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::logging::v2::ListExclusionsRequest,::google::logging::v2::ListExclusionsResponse>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_GetExclusion : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_GetExclusion() {
      ::grpc::Service::MarkMethodStreamed(17,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::logging::v2::GetExclusionRequest, ::google::logging::v2::LogExclusion>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::logging::v2::GetExclusionRequest, ::google::logging::v2::LogExclusion>* streamer) {
                       return this->StreamedGetExclusion(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_GetExclusion() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status GetExclusion(::grpc::ServerContext* /*context*/, const ::google::logging::v2::GetExclusionRequest* /*request*/, ::google::logging::v2::LogExclusion* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedGetExclusion(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::logging::v2::GetExclusionRequest,::google::logging::v2::LogExclusion>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_CreateExclusion : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_CreateExclusion() {
      ::grpc::Service::MarkMethodStreamed(18,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::logging::v2::CreateExclusionRequest, ::google::logging::v2::LogExclusion>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::logging::v2::CreateExclusionRequest, ::google::logging::v2::LogExclusion>* streamer) {
                       return this->StreamedCreateExclusion(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_CreateExclusion() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status CreateExclusion(::grpc::ServerContext* /*context*/, const ::google::logging::v2::CreateExclusionRequest* /*request*/, ::google::logging::v2::LogExclusion* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedCreateExclusion(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::logging::v2::CreateExclusionRequest,::google::logging::v2::LogExclusion>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_UpdateExclusion : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_UpdateExclusion() {
      ::grpc::Service::MarkMethodStreamed(19,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::logging::v2::UpdateExclusionRequest, ::google::logging::v2::LogExclusion>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::logging::v2::UpdateExclusionRequest, ::google::logging::v2::LogExclusion>* streamer) {
                       return this->StreamedUpdateExclusion(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_UpdateExclusion() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status UpdateExclusion(::grpc::ServerContext* /*context*/, const ::google::logging::v2::UpdateExclusionRequest* /*request*/, ::google::logging::v2::LogExclusion* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedUpdateExclusion(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::logging::v2::UpdateExclusionRequest,::google::logging::v2::LogExclusion>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_DeleteExclusion : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_DeleteExclusion() {
      ::grpc::Service::MarkMethodStreamed(20,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::logging::v2::DeleteExclusionRequest, ::google::protobuf::Empty>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::logging::v2::DeleteExclusionRequest, ::google::protobuf::Empty>* streamer) {
                       return this->StreamedDeleteExclusion(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_DeleteExclusion() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status DeleteExclusion(::grpc::ServerContext* /*context*/, const ::google::logging::v2::DeleteExclusionRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedDeleteExclusion(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::logging::v2::DeleteExclusionRequest,::google::protobuf::Empty>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_GetCmekSettings : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_GetCmekSettings() {
      ::grpc::Service::MarkMethodStreamed(21,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::logging::v2::GetCmekSettingsRequest, ::google::logging::v2::CmekSettings>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::logging::v2::GetCmekSettingsRequest, ::google::logging::v2::CmekSettings>* streamer) {
                       return this->StreamedGetCmekSettings(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_GetCmekSettings() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status GetCmekSettings(::grpc::ServerContext* /*context*/, const ::google::logging::v2::GetCmekSettingsRequest* /*request*/, ::google::logging::v2::CmekSettings* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedGetCmekSettings(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::logging::v2::GetCmekSettingsRequest,::google::logging::v2::CmekSettings>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_UpdateCmekSettings : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_UpdateCmekSettings() {
      ::grpc::Service::MarkMethodStreamed(22,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::logging::v2::UpdateCmekSettingsRequest, ::google::logging::v2::CmekSettings>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::logging::v2::UpdateCmekSettingsRequest, ::google::logging::v2::CmekSettings>* streamer) {
                       return this->StreamedUpdateCmekSettings(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_UpdateCmekSettings() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status UpdateCmekSettings(::grpc::ServerContext* /*context*/, const ::google::logging::v2::UpdateCmekSettingsRequest* /*request*/, ::google::logging::v2::CmekSettings* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedUpdateCmekSettings(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::logging::v2::UpdateCmekSettingsRequest,::google::logging::v2::CmekSettings>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_GetSettings : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_GetSettings() {
      ::grpc::Service::MarkMethodStreamed(23,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::logging::v2::GetSettingsRequest, ::google::logging::v2::Settings>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::logging::v2::GetSettingsRequest, ::google::logging::v2::Settings>* streamer) {
                       return this->StreamedGetSettings(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_GetSettings() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status GetSettings(::grpc::ServerContext* /*context*/, const ::google::logging::v2::GetSettingsRequest* /*request*/, ::google::logging::v2::Settings* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedGetSettings(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::logging::v2::GetSettingsRequest,::google::logging::v2::Settings>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_UpdateSettings : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_UpdateSettings() {
      ::grpc::Service::MarkMethodStreamed(24,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::logging::v2::UpdateSettingsRequest, ::google::logging::v2::Settings>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::logging::v2::UpdateSettingsRequest, ::google::logging::v2::Settings>* streamer) {
                       return this->StreamedUpdateSettings(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_UpdateSettings() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status UpdateSettings(::grpc::ServerContext* /*context*/, const ::google::logging::v2::UpdateSettingsRequest* /*request*/, ::google::logging::v2::Settings* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedUpdateSettings(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::logging::v2::UpdateSettingsRequest,::google::logging::v2::Settings>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_CopyLogEntries : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_CopyLogEntries() {
      ::grpc::Service::MarkMethodStreamed(25,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::logging::v2::CopyLogEntriesRequest, ::google::longrunning::Operation>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::logging::v2::CopyLogEntriesRequest, ::google::longrunning::Operation>* streamer) {
                       return this->StreamedCopyLogEntries(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_CopyLogEntries() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status CopyLogEntries(::grpc::ServerContext* /*context*/, const ::google::logging::v2::CopyLogEntriesRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedCopyLogEntries(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::logging::v2::CopyLogEntriesRequest,::google::longrunning::Operation>* server_unary_streamer) = 0;
  };
  typedef WithStreamedUnaryMethod_ListBuckets<WithStreamedUnaryMethod_GetBucket<WithStreamedUnaryMethod_CreateBucket<WithStreamedUnaryMethod_UpdateBucket<WithStreamedUnaryMethod_DeleteBucket<WithStreamedUnaryMethod_UndeleteBucket<WithStreamedUnaryMethod_ListViews<WithStreamedUnaryMethod_GetView<WithStreamedUnaryMethod_CreateView<WithStreamedUnaryMethod_UpdateView<WithStreamedUnaryMethod_DeleteView<WithStreamedUnaryMethod_ListSinks<WithStreamedUnaryMethod_GetSink<WithStreamedUnaryMethod_CreateSink<WithStreamedUnaryMethod_UpdateSink<WithStreamedUnaryMethod_DeleteSink<WithStreamedUnaryMethod_ListExclusions<WithStreamedUnaryMethod_GetExclusion<WithStreamedUnaryMethod_CreateExclusion<WithStreamedUnaryMethod_UpdateExclusion<WithStreamedUnaryMethod_DeleteExclusion<WithStreamedUnaryMethod_GetCmekSettings<WithStreamedUnaryMethod_UpdateCmekSettings<WithStreamedUnaryMethod_GetSettings<WithStreamedUnaryMethod_UpdateSettings<WithStreamedUnaryMethod_CopyLogEntries<Service > > > > > > > > > > > > > > > > > > > > > > > > > > StreamedUnaryService;
  typedef Service SplitStreamedService;
  typedef WithStreamedUnaryMethod_ListBuckets<WithStreamedUnaryMethod_GetBucket<WithStreamedUnaryMethod_CreateBucket<WithStreamedUnaryMethod_UpdateBucket<WithStreamedUnaryMethod_DeleteBucket<WithStreamedUnaryMethod_UndeleteBucket<WithStreamedUnaryMethod_ListViews<WithStreamedUnaryMethod_GetView<WithStreamedUnaryMethod_CreateView<WithStreamedUnaryMethod_UpdateView<WithStreamedUnaryMethod_DeleteView<WithStreamedUnaryMethod_ListSinks<WithStreamedUnaryMethod_GetSink<WithStreamedUnaryMethod_CreateSink<WithStreamedUnaryMethod_UpdateSink<WithStreamedUnaryMethod_DeleteSink<WithStreamedUnaryMethod_ListExclusions<WithStreamedUnaryMethod_GetExclusion<WithStreamedUnaryMethod_CreateExclusion<WithStreamedUnaryMethod_UpdateExclusion<WithStreamedUnaryMethod_DeleteExclusion<WithStreamedUnaryMethod_GetCmekSettings<WithStreamedUnaryMethod_UpdateCmekSettings<WithStreamedUnaryMethod_GetSettings<WithStreamedUnaryMethod_UpdateSettings<WithStreamedUnaryMethod_CopyLogEntries<Service > > > > > > > > > > > > > > > > > > > > > > > > > > StreamedService;
};

}  // namespace v2
}  // namespace logging
}  // namespace google


#endif  // GRPC_google_2flogging_2fv2_2flogging_5fconfig_2eproto__INCLUDED
