// Generated by the gRPC C++ plugin.
// If you make any local change, they will be lost.
// source: google/cloud/bigquery/reservation/v1/reservation.proto
// Original file comments:
// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
#ifndef GRPC_google_2fcloud_2fbigquery_2freservation_2fv1_2freservation_2eproto__INCLUDED
#define GRPC_google_2fcloud_2fbigquery_2freservation_2fv1_2freservation_2eproto__INCLUDED

#include "google/cloud/bigquery/reservation/v1/reservation.pb.h"

#include <functional>
#include <grpcpp/impl/codegen/async_generic_service.h>
#include <grpcpp/impl/codegen/async_stream.h>
#include <grpcpp/impl/codegen/async_unary_call.h>
#include <grpcpp/impl/codegen/client_callback.h>
#include <grpcpp/impl/codegen/client_context.h>
#include <grpcpp/impl/codegen/completion_queue.h>
#include <grpcpp/impl/codegen/message_allocator.h>
#include <grpcpp/impl/codegen/method_handler.h>
#include <grpcpp/impl/codegen/proto_utils.h>
#include <grpcpp/impl/codegen/rpc_method.h>
#include <grpcpp/impl/codegen/server_callback.h>
#include <grpcpp/impl/codegen/server_callback_handlers.h>
#include <grpcpp/impl/codegen/server_context.h>
#include <grpcpp/impl/codegen/service_type.h>
#include <grpcpp/impl/codegen/status.h>
#include <grpcpp/impl/codegen/stub_options.h>
#include <grpcpp/impl/codegen/sync_stream.h>

namespace google {
namespace cloud {
namespace bigquery {
namespace reservation {
namespace v1 {

// This API allows users to manage their flat-rate BigQuery reservations.
//
// A reservation provides computational resource guarantees, in the form of
// [slots](https://cloud.google.com/bigquery/docs/slots), to users. A slot is a
// unit of computational power in BigQuery, and serves as the basic unit of
// parallelism. In a scan of a multi-partitioned table, a single slot operates
// on a single partition of the table. A reservation resource exists as a child
// resource of the admin project and location, e.g.:
//   `projects/myproject/locations/US/reservations/reservationName`.
//
// A capacity commitment is a way to purchase compute capacity for BigQuery jobs
// (in the form of slots) with some committed period of usage. A capacity
// commitment resource exists as a child resource of the admin project and
// location, e.g.:
//   `projects/myproject/locations/US/capacityCommitments/id`.
class ReservationService final {
 public:
  static constexpr char const* service_full_name() {
    return "google.cloud.bigquery.reservation.v1.ReservationService";
  }
  class StubInterface {
   public:
    virtual ~StubInterface() {}
    // Creates a new reservation resource.
    virtual ::grpc::Status CreateReservation(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::CreateReservationRequest& request, ::google::cloud::bigquery::reservation::v1::Reservation* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::Reservation>> AsyncCreateReservation(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::CreateReservationRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::Reservation>>(AsyncCreateReservationRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::Reservation>> PrepareAsyncCreateReservation(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::CreateReservationRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::Reservation>>(PrepareAsyncCreateReservationRaw(context, request, cq));
    }
    // Lists all the reservations for the project in the specified location.
    virtual ::grpc::Status ListReservations(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::ListReservationsRequest& request, ::google::cloud::bigquery::reservation::v1::ListReservationsResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::ListReservationsResponse>> AsyncListReservations(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::ListReservationsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::ListReservationsResponse>>(AsyncListReservationsRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::ListReservationsResponse>> PrepareAsyncListReservations(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::ListReservationsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::ListReservationsResponse>>(PrepareAsyncListReservationsRaw(context, request, cq));
    }
    // Returns information about the reservation.
    virtual ::grpc::Status GetReservation(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::GetReservationRequest& request, ::google::cloud::bigquery::reservation::v1::Reservation* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::Reservation>> AsyncGetReservation(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::GetReservationRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::Reservation>>(AsyncGetReservationRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::Reservation>> PrepareAsyncGetReservation(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::GetReservationRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::Reservation>>(PrepareAsyncGetReservationRaw(context, request, cq));
    }
    // Deletes a reservation.
    // Returns `google.rpc.Code.FAILED_PRECONDITION` when reservation has
    // assignments.
    virtual ::grpc::Status DeleteReservation(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::DeleteReservationRequest& request, ::google::protobuf::Empty* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>> AsyncDeleteReservation(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::DeleteReservationRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>>(AsyncDeleteReservationRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>> PrepareAsyncDeleteReservation(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::DeleteReservationRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>>(PrepareAsyncDeleteReservationRaw(context, request, cq));
    }
    // Updates an existing reservation resource.
    virtual ::grpc::Status UpdateReservation(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::UpdateReservationRequest& request, ::google::cloud::bigquery::reservation::v1::Reservation* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::Reservation>> AsyncUpdateReservation(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::UpdateReservationRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::Reservation>>(AsyncUpdateReservationRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::Reservation>> PrepareAsyncUpdateReservation(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::UpdateReservationRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::Reservation>>(PrepareAsyncUpdateReservationRaw(context, request, cq));
    }
    // Creates a new capacity commitment resource.
    virtual ::grpc::Status CreateCapacityCommitment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::CreateCapacityCommitmentRequest& request, ::google::cloud::bigquery::reservation::v1::CapacityCommitment* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::CapacityCommitment>> AsyncCreateCapacityCommitment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::CreateCapacityCommitmentRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::CapacityCommitment>>(AsyncCreateCapacityCommitmentRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::CapacityCommitment>> PrepareAsyncCreateCapacityCommitment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::CreateCapacityCommitmentRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::CapacityCommitment>>(PrepareAsyncCreateCapacityCommitmentRaw(context, request, cq));
    }
    // Lists all the capacity commitments for the admin project.
    virtual ::grpc::Status ListCapacityCommitments(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::ListCapacityCommitmentsRequest& request, ::google::cloud::bigquery::reservation::v1::ListCapacityCommitmentsResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::ListCapacityCommitmentsResponse>> AsyncListCapacityCommitments(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::ListCapacityCommitmentsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::ListCapacityCommitmentsResponse>>(AsyncListCapacityCommitmentsRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::ListCapacityCommitmentsResponse>> PrepareAsyncListCapacityCommitments(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::ListCapacityCommitmentsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::ListCapacityCommitmentsResponse>>(PrepareAsyncListCapacityCommitmentsRaw(context, request, cq));
    }
    // Returns information about the capacity commitment.
    virtual ::grpc::Status GetCapacityCommitment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::GetCapacityCommitmentRequest& request, ::google::cloud::bigquery::reservation::v1::CapacityCommitment* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::CapacityCommitment>> AsyncGetCapacityCommitment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::GetCapacityCommitmentRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::CapacityCommitment>>(AsyncGetCapacityCommitmentRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::CapacityCommitment>> PrepareAsyncGetCapacityCommitment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::GetCapacityCommitmentRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::CapacityCommitment>>(PrepareAsyncGetCapacityCommitmentRaw(context, request, cq));
    }
    // Deletes a capacity commitment. Attempting to delete capacity commitment
    // before its commitment_end_time will fail with the error code
    // `google.rpc.Code.FAILED_PRECONDITION`.
    virtual ::grpc::Status DeleteCapacityCommitment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::DeleteCapacityCommitmentRequest& request, ::google::protobuf::Empty* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>> AsyncDeleteCapacityCommitment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::DeleteCapacityCommitmentRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>>(AsyncDeleteCapacityCommitmentRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>> PrepareAsyncDeleteCapacityCommitment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::DeleteCapacityCommitmentRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>>(PrepareAsyncDeleteCapacityCommitmentRaw(context, request, cq));
    }
    // Updates an existing capacity commitment.
    //
    // Only `plan` and `renewal_plan` fields can be updated.
    //
    // Plan can only be changed to a plan of a longer commitment period.
    // Attempting to change to a plan with shorter commitment period will fail
    // with the error code `google.rpc.Code.FAILED_PRECONDITION`.
    virtual ::grpc::Status UpdateCapacityCommitment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::UpdateCapacityCommitmentRequest& request, ::google::cloud::bigquery::reservation::v1::CapacityCommitment* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::CapacityCommitment>> AsyncUpdateCapacityCommitment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::UpdateCapacityCommitmentRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::CapacityCommitment>>(AsyncUpdateCapacityCommitmentRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::CapacityCommitment>> PrepareAsyncUpdateCapacityCommitment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::UpdateCapacityCommitmentRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::CapacityCommitment>>(PrepareAsyncUpdateCapacityCommitmentRaw(context, request, cq));
    }
    // Splits capacity commitment to two commitments of the same plan and
    // `commitment_end_time`.
    //
    // A common use case is to enable downgrading commitments.
    //
    // For example, in order to downgrade from 10000 slots to 8000, you might
    // split a 10000 capacity commitment into commitments of 2000 and 8000. Then,
    // you delete the first one after the commitment end time passes.
    virtual ::grpc::Status SplitCapacityCommitment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::SplitCapacityCommitmentRequest& request, ::google::cloud::bigquery::reservation::v1::SplitCapacityCommitmentResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::SplitCapacityCommitmentResponse>> AsyncSplitCapacityCommitment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::SplitCapacityCommitmentRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::SplitCapacityCommitmentResponse>>(AsyncSplitCapacityCommitmentRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::SplitCapacityCommitmentResponse>> PrepareAsyncSplitCapacityCommitment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::SplitCapacityCommitmentRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::SplitCapacityCommitmentResponse>>(PrepareAsyncSplitCapacityCommitmentRaw(context, request, cq));
    }
    // Merges capacity commitments of the same plan into a single commitment.
    //
    // The resulting capacity commitment has the greater commitment_end_time
    // out of the to-be-merged capacity commitments.
    //
    // Attempting to merge capacity commitments of different plan will fail
    // with the error code `google.rpc.Code.FAILED_PRECONDITION`.
    virtual ::grpc::Status MergeCapacityCommitments(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::MergeCapacityCommitmentsRequest& request, ::google::cloud::bigquery::reservation::v1::CapacityCommitment* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::CapacityCommitment>> AsyncMergeCapacityCommitments(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::MergeCapacityCommitmentsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::CapacityCommitment>>(AsyncMergeCapacityCommitmentsRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::CapacityCommitment>> PrepareAsyncMergeCapacityCommitments(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::MergeCapacityCommitmentsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::CapacityCommitment>>(PrepareAsyncMergeCapacityCommitmentsRaw(context, request, cq));
    }
    // Creates an assignment object which allows the given project to submit jobs
    // of a certain type using slots from the specified reservation.
    //
    // Currently a
    // resource (project, folder, organization) can only have one assignment per
    // each (job_type, location) combination, and that reservation will be used
    // for all jobs of the matching type.
    //
    // Different assignments can be created on different levels of the
    // projects, folders or organization hierarchy.  During query execution,
    // the assignment is looked up at the project, folder and organization levels
    // in that order. The first assignment found is applied to the query.
    //
    // When creating assignments, it does not matter if other assignments exist at
    // higher levels.
    //
    // Example:
    //
    // * The organization `organizationA` contains two projects, `project1`
    //   and `project2`.
    // * Assignments for all three entities (`organizationA`, `project1`, and
    //   `project2`) could all be created and mapped to the same or different
    //   reservations.
    //
    // "None" assignments represent an absence of the assignment. Projects
    // assigned to None use on-demand pricing. To create a "None" assignment, use
    // "none" as a reservation_id in the parent. Example parent:
    // `projects/myproject/locations/US/reservations/none`.
    //
    // Returns `google.rpc.Code.PERMISSION_DENIED` if user does not have
    // 'bigquery.admin' permissions on the project using the reservation
    // and the project that owns this reservation.
    //
    // Returns `google.rpc.Code.INVALID_ARGUMENT` when location of the assignment
    // does not match location of the reservation.
    virtual ::grpc::Status CreateAssignment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::CreateAssignmentRequest& request, ::google::cloud::bigquery::reservation::v1::Assignment* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::Assignment>> AsyncCreateAssignment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::CreateAssignmentRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::Assignment>>(AsyncCreateAssignmentRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::Assignment>> PrepareAsyncCreateAssignment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::CreateAssignmentRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::Assignment>>(PrepareAsyncCreateAssignmentRaw(context, request, cq));
    }
    // Lists assignments.
    //
    // Only explicitly created assignments will be returned.
    //
    // Example:
    //
    // * Organization `organizationA` contains two projects, `project1` and
    //   `project2`.
    // * Reservation `res1` exists and was created previously.
    // * CreateAssignment was used previously to define the following
    //   associations between entities and reservations: `<organizationA, res1>`
    //   and `<project1, res1>`
    //
    // In this example, ListAssignments will just return the above two assignments
    // for reservation `res1`, and no expansion/merge will happen.
    //
    // The wildcard "-" can be used for
    // reservations in the request. In that case all assignments belongs to the
    // specified project and location will be listed.
    //
    // **Note** "-" cannot be used for projects nor locations.
    virtual ::grpc::Status ListAssignments(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::ListAssignmentsRequest& request, ::google::cloud::bigquery::reservation::v1::ListAssignmentsResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::ListAssignmentsResponse>> AsyncListAssignments(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::ListAssignmentsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::ListAssignmentsResponse>>(AsyncListAssignmentsRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::ListAssignmentsResponse>> PrepareAsyncListAssignments(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::ListAssignmentsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::ListAssignmentsResponse>>(PrepareAsyncListAssignmentsRaw(context, request, cq));
    }
    // Deletes a assignment. No expansion will happen.
    //
    // Example:
    //
    // * Organization `organizationA` contains two projects, `project1` and
    //   `project2`.
    // * Reservation `res1` exists and was created previously.
    // * CreateAssignment was used previously to define the following
    //   associations between entities and reservations: `<organizationA, res1>`
    //   and `<project1, res1>`
    //
    // In this example, deletion of the `<organizationA, res1>` assignment won't
    // affect the other assignment `<project1, res1>`. After said deletion,
    // queries from `project1` will still use `res1` while queries from
    // `project2` will switch to use on-demand mode.
    virtual ::grpc::Status DeleteAssignment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::DeleteAssignmentRequest& request, ::google::protobuf::Empty* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>> AsyncDeleteAssignment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::DeleteAssignmentRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>>(AsyncDeleteAssignmentRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>> PrepareAsyncDeleteAssignment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::DeleteAssignmentRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>>(PrepareAsyncDeleteAssignmentRaw(context, request, cq));
    }
    // Deprecated: Looks up assignments for a specified resource for a particular
    // region. If the request is about a project:
    //
    // 1. Assignments created on the project will be returned if they exist.
    // 2. Otherwise assignments created on the closest ancestor will be
    //    returned.
    // 3. Assignments for different JobTypes will all be returned.
    //
    // The same logic applies if the request is about a folder.
    //
    // If the request is about an organization, then assignments created on the
    // organization will be returned (organization doesn't have ancestors).
    //
    // Comparing to ListAssignments, there are some behavior
    // differences:
    //
    // 1. permission on the assignee will be verified in this API.
    // 2. Hierarchy lookup (project->folder->organization) happens in this API.
    // 3. Parent here is `projects/*/locations/*`, instead of
    //    `projects/*/locations/*reservations/*`.
    //
    // **Note** "-" cannot be used for projects
    // nor locations.
    virtual ::grpc::Status SearchAssignments(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::SearchAssignmentsRequest& request, ::google::cloud::bigquery::reservation::v1::SearchAssignmentsResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::SearchAssignmentsResponse>> AsyncSearchAssignments(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::SearchAssignmentsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::SearchAssignmentsResponse>>(AsyncSearchAssignmentsRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::SearchAssignmentsResponse>> PrepareAsyncSearchAssignments(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::SearchAssignmentsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::SearchAssignmentsResponse>>(PrepareAsyncSearchAssignmentsRaw(context, request, cq));
    }
    // Looks up assignments for a specified resource for a particular region.
    // If the request is about a project:
    //
    // 1. Assignments created on the project will be returned if they exist.
    // 2. Otherwise assignments created on the closest ancestor will be
    //    returned.
    // 3. Assignments for different JobTypes will all be returned.
    //
    // The same logic applies if the request is about a folder.
    //
    // If the request is about an organization, then assignments created on the
    // organization will be returned (organization doesn't have ancestors).
    //
    // Comparing to ListAssignments, there are some behavior
    // differences:
    //
    // 1. permission on the assignee will be verified in this API.
    // 2. Hierarchy lookup (project->folder->organization) happens in this API.
    // 3. Parent here is `projects/*/locations/*`, instead of
    //    `projects/*/locations/*reservations/*`.
    virtual ::grpc::Status SearchAllAssignments(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::SearchAllAssignmentsRequest& request, ::google::cloud::bigquery::reservation::v1::SearchAllAssignmentsResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::SearchAllAssignmentsResponse>> AsyncSearchAllAssignments(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::SearchAllAssignmentsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::SearchAllAssignmentsResponse>>(AsyncSearchAllAssignmentsRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::SearchAllAssignmentsResponse>> PrepareAsyncSearchAllAssignments(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::SearchAllAssignmentsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::SearchAllAssignmentsResponse>>(PrepareAsyncSearchAllAssignmentsRaw(context, request, cq));
    }
    // Moves an assignment under a new reservation.
    //
    // This differs from removing an existing assignment and recreating a new one
    // by providing a transactional change that ensures an assignee always has an
    // associated reservation.
    virtual ::grpc::Status MoveAssignment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::MoveAssignmentRequest& request, ::google::cloud::bigquery::reservation::v1::Assignment* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::Assignment>> AsyncMoveAssignment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::MoveAssignmentRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::Assignment>>(AsyncMoveAssignmentRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::Assignment>> PrepareAsyncMoveAssignment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::MoveAssignmentRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::Assignment>>(PrepareAsyncMoveAssignmentRaw(context, request, cq));
    }
    // Updates an existing assignment.
    //
    // Only the `priority` field can be updated.
    virtual ::grpc::Status UpdateAssignment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::UpdateAssignmentRequest& request, ::google::cloud::bigquery::reservation::v1::Assignment* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::Assignment>> AsyncUpdateAssignment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::UpdateAssignmentRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::Assignment>>(AsyncUpdateAssignmentRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::Assignment>> PrepareAsyncUpdateAssignment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::UpdateAssignmentRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::Assignment>>(PrepareAsyncUpdateAssignmentRaw(context, request, cq));
    }
    // Retrieves a BI reservation.
    virtual ::grpc::Status GetBiReservation(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::GetBiReservationRequest& request, ::google::cloud::bigquery::reservation::v1::BiReservation* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::BiReservation>> AsyncGetBiReservation(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::GetBiReservationRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::BiReservation>>(AsyncGetBiReservationRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::BiReservation>> PrepareAsyncGetBiReservation(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::GetBiReservationRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::BiReservation>>(PrepareAsyncGetBiReservationRaw(context, request, cq));
    }
    // Updates a BI reservation.
    //
    // Only fields specified in the `field_mask` are updated.
    //
    // A singleton BI reservation always exists with default size 0.
    // In order to reserve BI capacity it needs to be updated to an amount
    // greater than 0. In order to release BI capacity reservation size
    // must be set to 0.
    virtual ::grpc::Status UpdateBiReservation(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::UpdateBiReservationRequest& request, ::google::cloud::bigquery::reservation::v1::BiReservation* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::BiReservation>> AsyncUpdateBiReservation(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::UpdateBiReservationRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::BiReservation>>(AsyncUpdateBiReservationRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::BiReservation>> PrepareAsyncUpdateBiReservation(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::UpdateBiReservationRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::BiReservation>>(PrepareAsyncUpdateBiReservationRaw(context, request, cq));
    }
    class async_interface {
     public:
      virtual ~async_interface() {}
      // Creates a new reservation resource.
      virtual void CreateReservation(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::CreateReservationRequest* request, ::google::cloud::bigquery::reservation::v1::Reservation* response, std::function<void(::grpc::Status)>) = 0;
      virtual void CreateReservation(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::CreateReservationRequest* request, ::google::cloud::bigquery::reservation::v1::Reservation* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Lists all the reservations for the project in the specified location.
      virtual void ListReservations(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::ListReservationsRequest* request, ::google::cloud::bigquery::reservation::v1::ListReservationsResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void ListReservations(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::ListReservationsRequest* request, ::google::cloud::bigquery::reservation::v1::ListReservationsResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Returns information about the reservation.
      virtual void GetReservation(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::GetReservationRequest* request, ::google::cloud::bigquery::reservation::v1::Reservation* response, std::function<void(::grpc::Status)>) = 0;
      virtual void GetReservation(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::GetReservationRequest* request, ::google::cloud::bigquery::reservation::v1::Reservation* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Deletes a reservation.
      // Returns `google.rpc.Code.FAILED_PRECONDITION` when reservation has
      // assignments.
      virtual void DeleteReservation(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::DeleteReservationRequest* request, ::google::protobuf::Empty* response, std::function<void(::grpc::Status)>) = 0;
      virtual void DeleteReservation(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::DeleteReservationRequest* request, ::google::protobuf::Empty* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Updates an existing reservation resource.
      virtual void UpdateReservation(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::UpdateReservationRequest* request, ::google::cloud::bigquery::reservation::v1::Reservation* response, std::function<void(::grpc::Status)>) = 0;
      virtual void UpdateReservation(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::UpdateReservationRequest* request, ::google::cloud::bigquery::reservation::v1::Reservation* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Creates a new capacity commitment resource.
      virtual void CreateCapacityCommitment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::CreateCapacityCommitmentRequest* request, ::google::cloud::bigquery::reservation::v1::CapacityCommitment* response, std::function<void(::grpc::Status)>) = 0;
      virtual void CreateCapacityCommitment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::CreateCapacityCommitmentRequest* request, ::google::cloud::bigquery::reservation::v1::CapacityCommitment* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Lists all the capacity commitments for the admin project.
      virtual void ListCapacityCommitments(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::ListCapacityCommitmentsRequest* request, ::google::cloud::bigquery::reservation::v1::ListCapacityCommitmentsResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void ListCapacityCommitments(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::ListCapacityCommitmentsRequest* request, ::google::cloud::bigquery::reservation::v1::ListCapacityCommitmentsResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Returns information about the capacity commitment.
      virtual void GetCapacityCommitment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::GetCapacityCommitmentRequest* request, ::google::cloud::bigquery::reservation::v1::CapacityCommitment* response, std::function<void(::grpc::Status)>) = 0;
      virtual void GetCapacityCommitment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::GetCapacityCommitmentRequest* request, ::google::cloud::bigquery::reservation::v1::CapacityCommitment* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Deletes a capacity commitment. Attempting to delete capacity commitment
      // before its commitment_end_time will fail with the error code
      // `google.rpc.Code.FAILED_PRECONDITION`.
      virtual void DeleteCapacityCommitment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::DeleteCapacityCommitmentRequest* request, ::google::protobuf::Empty* response, std::function<void(::grpc::Status)>) = 0;
      virtual void DeleteCapacityCommitment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::DeleteCapacityCommitmentRequest* request, ::google::protobuf::Empty* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Updates an existing capacity commitment.
      //
      // Only `plan` and `renewal_plan` fields can be updated.
      //
      // Plan can only be changed to a plan of a longer commitment period.
      // Attempting to change to a plan with shorter commitment period will fail
      // with the error code `google.rpc.Code.FAILED_PRECONDITION`.
      virtual void UpdateCapacityCommitment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::UpdateCapacityCommitmentRequest* request, ::google::cloud::bigquery::reservation::v1::CapacityCommitment* response, std::function<void(::grpc::Status)>) = 0;
      virtual void UpdateCapacityCommitment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::UpdateCapacityCommitmentRequest* request, ::google::cloud::bigquery::reservation::v1::CapacityCommitment* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Splits capacity commitment to two commitments of the same plan and
      // `commitment_end_time`.
      //
      // A common use case is to enable downgrading commitments.
      //
      // For example, in order to downgrade from 10000 slots to 8000, you might
      // split a 10000 capacity commitment into commitments of 2000 and 8000. Then,
      // you delete the first one after the commitment end time passes.
      virtual void SplitCapacityCommitment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::SplitCapacityCommitmentRequest* request, ::google::cloud::bigquery::reservation::v1::SplitCapacityCommitmentResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void SplitCapacityCommitment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::SplitCapacityCommitmentRequest* request, ::google::cloud::bigquery::reservation::v1::SplitCapacityCommitmentResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Merges capacity commitments of the same plan into a single commitment.
      //
      // The resulting capacity commitment has the greater commitment_end_time
      // out of the to-be-merged capacity commitments.
      //
      // Attempting to merge capacity commitments of different plan will fail
      // with the error code `google.rpc.Code.FAILED_PRECONDITION`.
      virtual void MergeCapacityCommitments(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::MergeCapacityCommitmentsRequest* request, ::google::cloud::bigquery::reservation::v1::CapacityCommitment* response, std::function<void(::grpc::Status)>) = 0;
      virtual void MergeCapacityCommitments(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::MergeCapacityCommitmentsRequest* request, ::google::cloud::bigquery::reservation::v1::CapacityCommitment* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Creates an assignment object which allows the given project to submit jobs
      // of a certain type using slots from the specified reservation.
      //
      // Currently a
      // resource (project, folder, organization) can only have one assignment per
      // each (job_type, location) combination, and that reservation will be used
      // for all jobs of the matching type.
      //
      // Different assignments can be created on different levels of the
      // projects, folders or organization hierarchy.  During query execution,
      // the assignment is looked up at the project, folder and organization levels
      // in that order. The first assignment found is applied to the query.
      //
      // When creating assignments, it does not matter if other assignments exist at
      // higher levels.
      //
      // Example:
      //
      // * The organization `organizationA` contains two projects, `project1`
      //   and `project2`.
      // * Assignments for all three entities (`organizationA`, `project1`, and
      //   `project2`) could all be created and mapped to the same or different
      //   reservations.
      //
      // "None" assignments represent an absence of the assignment. Projects
      // assigned to None use on-demand pricing. To create a "None" assignment, use
      // "none" as a reservation_id in the parent. Example parent:
      // `projects/myproject/locations/US/reservations/none`.
      //
      // Returns `google.rpc.Code.PERMISSION_DENIED` if user does not have
      // 'bigquery.admin' permissions on the project using the reservation
      // and the project that owns this reservation.
      //
      // Returns `google.rpc.Code.INVALID_ARGUMENT` when location of the assignment
      // does not match location of the reservation.
      virtual void CreateAssignment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::CreateAssignmentRequest* request, ::google::cloud::bigquery::reservation::v1::Assignment* response, std::function<void(::grpc::Status)>) = 0;
      virtual void CreateAssignment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::CreateAssignmentRequest* request, ::google::cloud::bigquery::reservation::v1::Assignment* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Lists assignments.
      //
      // Only explicitly created assignments will be returned.
      //
      // Example:
      //
      // * Organization `organizationA` contains two projects, `project1` and
      //   `project2`.
      // * Reservation `res1` exists and was created previously.
      // * CreateAssignment was used previously to define the following
      //   associations between entities and reservations: `<organizationA, res1>`
      //   and `<project1, res1>`
      //
      // In this example, ListAssignments will just return the above two assignments
      // for reservation `res1`, and no expansion/merge will happen.
      //
      // The wildcard "-" can be used for
      // reservations in the request. In that case all assignments belongs to the
      // specified project and location will be listed.
      //
      // **Note** "-" cannot be used for projects nor locations.
      virtual void ListAssignments(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::ListAssignmentsRequest* request, ::google::cloud::bigquery::reservation::v1::ListAssignmentsResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void ListAssignments(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::ListAssignmentsRequest* request, ::google::cloud::bigquery::reservation::v1::ListAssignmentsResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Deletes a assignment. No expansion will happen.
      //
      // Example:
      //
      // * Organization `organizationA` contains two projects, `project1` and
      //   `project2`.
      // * Reservation `res1` exists and was created previously.
      // * CreateAssignment was used previously to define the following
      //   associations between entities and reservations: `<organizationA, res1>`
      //   and `<project1, res1>`
      //
      // In this example, deletion of the `<organizationA, res1>` assignment won't
      // affect the other assignment `<project1, res1>`. After said deletion,
      // queries from `project1` will still use `res1` while queries from
      // `project2` will switch to use on-demand mode.
      virtual void DeleteAssignment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::DeleteAssignmentRequest* request, ::google::protobuf::Empty* response, std::function<void(::grpc::Status)>) = 0;
      virtual void DeleteAssignment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::DeleteAssignmentRequest* request, ::google::protobuf::Empty* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Deprecated: Looks up assignments for a specified resource for a particular
      // region. If the request is about a project:
      //
      // 1. Assignments created on the project will be returned if they exist.
      // 2. Otherwise assignments created on the closest ancestor will be
      //    returned.
      // 3. Assignments for different JobTypes will all be returned.
      //
      // The same logic applies if the request is about a folder.
      //
      // If the request is about an organization, then assignments created on the
      // organization will be returned (organization doesn't have ancestors).
      //
      // Comparing to ListAssignments, there are some behavior
      // differences:
      //
      // 1. permission on the assignee will be verified in this API.
      // 2. Hierarchy lookup (project->folder->organization) happens in this API.
      // 3. Parent here is `projects/*/locations/*`, instead of
      //    `projects/*/locations/*reservations/*`.
      //
      // **Note** "-" cannot be used for projects
      // nor locations.
      virtual void SearchAssignments(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::SearchAssignmentsRequest* request, ::google::cloud::bigquery::reservation::v1::SearchAssignmentsResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void SearchAssignments(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::SearchAssignmentsRequest* request, ::google::cloud::bigquery::reservation::v1::SearchAssignmentsResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Looks up assignments for a specified resource for a particular region.
      // If the request is about a project:
      //
      // 1. Assignments created on the project will be returned if they exist.
      // 2. Otherwise assignments created on the closest ancestor will be
      //    returned.
      // 3. Assignments for different JobTypes will all be returned.
      //
      // The same logic applies if the request is about a folder.
      //
      // If the request is about an organization, then assignments created on the
      // organization will be returned (organization doesn't have ancestors).
      //
      // Comparing to ListAssignments, there are some behavior
      // differences:
      //
      // 1. permission on the assignee will be verified in this API.
      // 2. Hierarchy lookup (project->folder->organization) happens in this API.
      // 3. Parent here is `projects/*/locations/*`, instead of
      //    `projects/*/locations/*reservations/*`.
      virtual void SearchAllAssignments(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::SearchAllAssignmentsRequest* request, ::google::cloud::bigquery::reservation::v1::SearchAllAssignmentsResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void SearchAllAssignments(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::SearchAllAssignmentsRequest* request, ::google::cloud::bigquery::reservation::v1::SearchAllAssignmentsResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Moves an assignment under a new reservation.
      //
      // This differs from removing an existing assignment and recreating a new one
      // by providing a transactional change that ensures an assignee always has an
      // associated reservation.
      virtual void MoveAssignment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::MoveAssignmentRequest* request, ::google::cloud::bigquery::reservation::v1::Assignment* response, std::function<void(::grpc::Status)>) = 0;
      virtual void MoveAssignment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::MoveAssignmentRequest* request, ::google::cloud::bigquery::reservation::v1::Assignment* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Updates an existing assignment.
      //
      // Only the `priority` field can be updated.
      virtual void UpdateAssignment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::UpdateAssignmentRequest* request, ::google::cloud::bigquery::reservation::v1::Assignment* response, std::function<void(::grpc::Status)>) = 0;
      virtual void UpdateAssignment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::UpdateAssignmentRequest* request, ::google::cloud::bigquery::reservation::v1::Assignment* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Retrieves a BI reservation.
      virtual void GetBiReservation(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::GetBiReservationRequest* request, ::google::cloud::bigquery::reservation::v1::BiReservation* response, std::function<void(::grpc::Status)>) = 0;
      virtual void GetBiReservation(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::GetBiReservationRequest* request, ::google::cloud::bigquery::reservation::v1::BiReservation* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Updates a BI reservation.
      //
      // Only fields specified in the `field_mask` are updated.
      //
      // A singleton BI reservation always exists with default size 0.
      // In order to reserve BI capacity it needs to be updated to an amount
      // greater than 0. In order to release BI capacity reservation size
      // must be set to 0.
      virtual void UpdateBiReservation(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::UpdateBiReservationRequest* request, ::google::cloud::bigquery::reservation::v1::BiReservation* response, std::function<void(::grpc::Status)>) = 0;
      virtual void UpdateBiReservation(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::UpdateBiReservationRequest* request, ::google::cloud::bigquery::reservation::v1::BiReservation* response, ::grpc::ClientUnaryReactor* reactor) = 0;
    };
    typedef class async_interface experimental_async_interface;
    virtual class async_interface* async() { return nullptr; }
    class async_interface* experimental_async() { return async(); }
   private:
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::Reservation>* AsyncCreateReservationRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::CreateReservationRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::Reservation>* PrepareAsyncCreateReservationRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::CreateReservationRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::ListReservationsResponse>* AsyncListReservationsRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::ListReservationsRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::ListReservationsResponse>* PrepareAsyncListReservationsRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::ListReservationsRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::Reservation>* AsyncGetReservationRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::GetReservationRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::Reservation>* PrepareAsyncGetReservationRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::GetReservationRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>* AsyncDeleteReservationRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::DeleteReservationRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>* PrepareAsyncDeleteReservationRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::DeleteReservationRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::Reservation>* AsyncUpdateReservationRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::UpdateReservationRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::Reservation>* PrepareAsyncUpdateReservationRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::UpdateReservationRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::CapacityCommitment>* AsyncCreateCapacityCommitmentRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::CreateCapacityCommitmentRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::CapacityCommitment>* PrepareAsyncCreateCapacityCommitmentRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::CreateCapacityCommitmentRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::ListCapacityCommitmentsResponse>* AsyncListCapacityCommitmentsRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::ListCapacityCommitmentsRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::ListCapacityCommitmentsResponse>* PrepareAsyncListCapacityCommitmentsRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::ListCapacityCommitmentsRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::CapacityCommitment>* AsyncGetCapacityCommitmentRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::GetCapacityCommitmentRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::CapacityCommitment>* PrepareAsyncGetCapacityCommitmentRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::GetCapacityCommitmentRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>* AsyncDeleteCapacityCommitmentRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::DeleteCapacityCommitmentRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>* PrepareAsyncDeleteCapacityCommitmentRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::DeleteCapacityCommitmentRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::CapacityCommitment>* AsyncUpdateCapacityCommitmentRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::UpdateCapacityCommitmentRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::CapacityCommitment>* PrepareAsyncUpdateCapacityCommitmentRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::UpdateCapacityCommitmentRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::SplitCapacityCommitmentResponse>* AsyncSplitCapacityCommitmentRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::SplitCapacityCommitmentRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::SplitCapacityCommitmentResponse>* PrepareAsyncSplitCapacityCommitmentRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::SplitCapacityCommitmentRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::CapacityCommitment>* AsyncMergeCapacityCommitmentsRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::MergeCapacityCommitmentsRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::CapacityCommitment>* PrepareAsyncMergeCapacityCommitmentsRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::MergeCapacityCommitmentsRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::Assignment>* AsyncCreateAssignmentRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::CreateAssignmentRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::Assignment>* PrepareAsyncCreateAssignmentRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::CreateAssignmentRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::ListAssignmentsResponse>* AsyncListAssignmentsRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::ListAssignmentsRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::ListAssignmentsResponse>* PrepareAsyncListAssignmentsRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::ListAssignmentsRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>* AsyncDeleteAssignmentRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::DeleteAssignmentRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>* PrepareAsyncDeleteAssignmentRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::DeleteAssignmentRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::SearchAssignmentsResponse>* AsyncSearchAssignmentsRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::SearchAssignmentsRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::SearchAssignmentsResponse>* PrepareAsyncSearchAssignmentsRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::SearchAssignmentsRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::SearchAllAssignmentsResponse>* AsyncSearchAllAssignmentsRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::SearchAllAssignmentsRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::SearchAllAssignmentsResponse>* PrepareAsyncSearchAllAssignmentsRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::SearchAllAssignmentsRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::Assignment>* AsyncMoveAssignmentRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::MoveAssignmentRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::Assignment>* PrepareAsyncMoveAssignmentRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::MoveAssignmentRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::Assignment>* AsyncUpdateAssignmentRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::UpdateAssignmentRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::Assignment>* PrepareAsyncUpdateAssignmentRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::UpdateAssignmentRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::BiReservation>* AsyncGetBiReservationRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::GetBiReservationRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::BiReservation>* PrepareAsyncGetBiReservationRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::GetBiReservationRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::BiReservation>* AsyncUpdateBiReservationRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::UpdateBiReservationRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::cloud::bigquery::reservation::v1::BiReservation>* PrepareAsyncUpdateBiReservationRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::UpdateBiReservationRequest& request, ::grpc::CompletionQueue* cq) = 0;
  };
  class Stub final : public StubInterface {
   public:
    Stub(const std::shared_ptr< ::grpc::ChannelInterface>& channel, const ::grpc::StubOptions& options = ::grpc::StubOptions());
    ::grpc::Status CreateReservation(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::CreateReservationRequest& request, ::google::cloud::bigquery::reservation::v1::Reservation* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::Reservation>> AsyncCreateReservation(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::CreateReservationRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::Reservation>>(AsyncCreateReservationRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::Reservation>> PrepareAsyncCreateReservation(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::CreateReservationRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::Reservation>>(PrepareAsyncCreateReservationRaw(context, request, cq));
    }
    ::grpc::Status ListReservations(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::ListReservationsRequest& request, ::google::cloud::bigquery::reservation::v1::ListReservationsResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::ListReservationsResponse>> AsyncListReservations(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::ListReservationsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::ListReservationsResponse>>(AsyncListReservationsRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::ListReservationsResponse>> PrepareAsyncListReservations(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::ListReservationsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::ListReservationsResponse>>(PrepareAsyncListReservationsRaw(context, request, cq));
    }
    ::grpc::Status GetReservation(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::GetReservationRequest& request, ::google::cloud::bigquery::reservation::v1::Reservation* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::Reservation>> AsyncGetReservation(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::GetReservationRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::Reservation>>(AsyncGetReservationRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::Reservation>> PrepareAsyncGetReservation(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::GetReservationRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::Reservation>>(PrepareAsyncGetReservationRaw(context, request, cq));
    }
    ::grpc::Status DeleteReservation(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::DeleteReservationRequest& request, ::google::protobuf::Empty* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>> AsyncDeleteReservation(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::DeleteReservationRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>>(AsyncDeleteReservationRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>> PrepareAsyncDeleteReservation(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::DeleteReservationRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>>(PrepareAsyncDeleteReservationRaw(context, request, cq));
    }
    ::grpc::Status UpdateReservation(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::UpdateReservationRequest& request, ::google::cloud::bigquery::reservation::v1::Reservation* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::Reservation>> AsyncUpdateReservation(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::UpdateReservationRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::Reservation>>(AsyncUpdateReservationRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::Reservation>> PrepareAsyncUpdateReservation(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::UpdateReservationRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::Reservation>>(PrepareAsyncUpdateReservationRaw(context, request, cq));
    }
    ::grpc::Status CreateCapacityCommitment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::CreateCapacityCommitmentRequest& request, ::google::cloud::bigquery::reservation::v1::CapacityCommitment* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::CapacityCommitment>> AsyncCreateCapacityCommitment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::CreateCapacityCommitmentRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::CapacityCommitment>>(AsyncCreateCapacityCommitmentRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::CapacityCommitment>> PrepareAsyncCreateCapacityCommitment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::CreateCapacityCommitmentRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::CapacityCommitment>>(PrepareAsyncCreateCapacityCommitmentRaw(context, request, cq));
    }
    ::grpc::Status ListCapacityCommitments(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::ListCapacityCommitmentsRequest& request, ::google::cloud::bigquery::reservation::v1::ListCapacityCommitmentsResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::ListCapacityCommitmentsResponse>> AsyncListCapacityCommitments(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::ListCapacityCommitmentsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::ListCapacityCommitmentsResponse>>(AsyncListCapacityCommitmentsRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::ListCapacityCommitmentsResponse>> PrepareAsyncListCapacityCommitments(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::ListCapacityCommitmentsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::ListCapacityCommitmentsResponse>>(PrepareAsyncListCapacityCommitmentsRaw(context, request, cq));
    }
    ::grpc::Status GetCapacityCommitment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::GetCapacityCommitmentRequest& request, ::google::cloud::bigquery::reservation::v1::CapacityCommitment* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::CapacityCommitment>> AsyncGetCapacityCommitment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::GetCapacityCommitmentRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::CapacityCommitment>>(AsyncGetCapacityCommitmentRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::CapacityCommitment>> PrepareAsyncGetCapacityCommitment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::GetCapacityCommitmentRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::CapacityCommitment>>(PrepareAsyncGetCapacityCommitmentRaw(context, request, cq));
    }
    ::grpc::Status DeleteCapacityCommitment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::DeleteCapacityCommitmentRequest& request, ::google::protobuf::Empty* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>> AsyncDeleteCapacityCommitment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::DeleteCapacityCommitmentRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>>(AsyncDeleteCapacityCommitmentRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>> PrepareAsyncDeleteCapacityCommitment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::DeleteCapacityCommitmentRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>>(PrepareAsyncDeleteCapacityCommitmentRaw(context, request, cq));
    }
    ::grpc::Status UpdateCapacityCommitment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::UpdateCapacityCommitmentRequest& request, ::google::cloud::bigquery::reservation::v1::CapacityCommitment* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::CapacityCommitment>> AsyncUpdateCapacityCommitment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::UpdateCapacityCommitmentRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::CapacityCommitment>>(AsyncUpdateCapacityCommitmentRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::CapacityCommitment>> PrepareAsyncUpdateCapacityCommitment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::UpdateCapacityCommitmentRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::CapacityCommitment>>(PrepareAsyncUpdateCapacityCommitmentRaw(context, request, cq));
    }
    ::grpc::Status SplitCapacityCommitment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::SplitCapacityCommitmentRequest& request, ::google::cloud::bigquery::reservation::v1::SplitCapacityCommitmentResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::SplitCapacityCommitmentResponse>> AsyncSplitCapacityCommitment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::SplitCapacityCommitmentRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::SplitCapacityCommitmentResponse>>(AsyncSplitCapacityCommitmentRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::SplitCapacityCommitmentResponse>> PrepareAsyncSplitCapacityCommitment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::SplitCapacityCommitmentRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::SplitCapacityCommitmentResponse>>(PrepareAsyncSplitCapacityCommitmentRaw(context, request, cq));
    }
    ::grpc::Status MergeCapacityCommitments(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::MergeCapacityCommitmentsRequest& request, ::google::cloud::bigquery::reservation::v1::CapacityCommitment* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::CapacityCommitment>> AsyncMergeCapacityCommitments(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::MergeCapacityCommitmentsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::CapacityCommitment>>(AsyncMergeCapacityCommitmentsRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::CapacityCommitment>> PrepareAsyncMergeCapacityCommitments(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::MergeCapacityCommitmentsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::CapacityCommitment>>(PrepareAsyncMergeCapacityCommitmentsRaw(context, request, cq));
    }
    ::grpc::Status CreateAssignment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::CreateAssignmentRequest& request, ::google::cloud::bigquery::reservation::v1::Assignment* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::Assignment>> AsyncCreateAssignment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::CreateAssignmentRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::Assignment>>(AsyncCreateAssignmentRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::Assignment>> PrepareAsyncCreateAssignment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::CreateAssignmentRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::Assignment>>(PrepareAsyncCreateAssignmentRaw(context, request, cq));
    }
    ::grpc::Status ListAssignments(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::ListAssignmentsRequest& request, ::google::cloud::bigquery::reservation::v1::ListAssignmentsResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::ListAssignmentsResponse>> AsyncListAssignments(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::ListAssignmentsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::ListAssignmentsResponse>>(AsyncListAssignmentsRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::ListAssignmentsResponse>> PrepareAsyncListAssignments(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::ListAssignmentsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::ListAssignmentsResponse>>(PrepareAsyncListAssignmentsRaw(context, request, cq));
    }
    ::grpc::Status DeleteAssignment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::DeleteAssignmentRequest& request, ::google::protobuf::Empty* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>> AsyncDeleteAssignment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::DeleteAssignmentRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>>(AsyncDeleteAssignmentRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>> PrepareAsyncDeleteAssignment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::DeleteAssignmentRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>>(PrepareAsyncDeleteAssignmentRaw(context, request, cq));
    }
    ::grpc::Status SearchAssignments(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::SearchAssignmentsRequest& request, ::google::cloud::bigquery::reservation::v1::SearchAssignmentsResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::SearchAssignmentsResponse>> AsyncSearchAssignments(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::SearchAssignmentsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::SearchAssignmentsResponse>>(AsyncSearchAssignmentsRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::SearchAssignmentsResponse>> PrepareAsyncSearchAssignments(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::SearchAssignmentsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::SearchAssignmentsResponse>>(PrepareAsyncSearchAssignmentsRaw(context, request, cq));
    }
    ::grpc::Status SearchAllAssignments(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::SearchAllAssignmentsRequest& request, ::google::cloud::bigquery::reservation::v1::SearchAllAssignmentsResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::SearchAllAssignmentsResponse>> AsyncSearchAllAssignments(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::SearchAllAssignmentsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::SearchAllAssignmentsResponse>>(AsyncSearchAllAssignmentsRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::SearchAllAssignmentsResponse>> PrepareAsyncSearchAllAssignments(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::SearchAllAssignmentsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::SearchAllAssignmentsResponse>>(PrepareAsyncSearchAllAssignmentsRaw(context, request, cq));
    }
    ::grpc::Status MoveAssignment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::MoveAssignmentRequest& request, ::google::cloud::bigquery::reservation::v1::Assignment* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::Assignment>> AsyncMoveAssignment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::MoveAssignmentRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::Assignment>>(AsyncMoveAssignmentRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::Assignment>> PrepareAsyncMoveAssignment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::MoveAssignmentRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::Assignment>>(PrepareAsyncMoveAssignmentRaw(context, request, cq));
    }
    ::grpc::Status UpdateAssignment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::UpdateAssignmentRequest& request, ::google::cloud::bigquery::reservation::v1::Assignment* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::Assignment>> AsyncUpdateAssignment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::UpdateAssignmentRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::Assignment>>(AsyncUpdateAssignmentRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::Assignment>> PrepareAsyncUpdateAssignment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::UpdateAssignmentRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::Assignment>>(PrepareAsyncUpdateAssignmentRaw(context, request, cq));
    }
    ::grpc::Status GetBiReservation(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::GetBiReservationRequest& request, ::google::cloud::bigquery::reservation::v1::BiReservation* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::BiReservation>> AsyncGetBiReservation(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::GetBiReservationRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::BiReservation>>(AsyncGetBiReservationRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::BiReservation>> PrepareAsyncGetBiReservation(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::GetBiReservationRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::BiReservation>>(PrepareAsyncGetBiReservationRaw(context, request, cq));
    }
    ::grpc::Status UpdateBiReservation(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::UpdateBiReservationRequest& request, ::google::cloud::bigquery::reservation::v1::BiReservation* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::BiReservation>> AsyncUpdateBiReservation(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::UpdateBiReservationRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::BiReservation>>(AsyncUpdateBiReservationRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::BiReservation>> PrepareAsyncUpdateBiReservation(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::UpdateBiReservationRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::BiReservation>>(PrepareAsyncUpdateBiReservationRaw(context, request, cq));
    }
    class async final :
      public StubInterface::async_interface {
     public:
      void CreateReservation(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::CreateReservationRequest* request, ::google::cloud::bigquery::reservation::v1::Reservation* response, std::function<void(::grpc::Status)>) override;
      void CreateReservation(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::CreateReservationRequest* request, ::google::cloud::bigquery::reservation::v1::Reservation* response, ::grpc::ClientUnaryReactor* reactor) override;
      void ListReservations(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::ListReservationsRequest* request, ::google::cloud::bigquery::reservation::v1::ListReservationsResponse* response, std::function<void(::grpc::Status)>) override;
      void ListReservations(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::ListReservationsRequest* request, ::google::cloud::bigquery::reservation::v1::ListReservationsResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
      void GetReservation(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::GetReservationRequest* request, ::google::cloud::bigquery::reservation::v1::Reservation* response, std::function<void(::grpc::Status)>) override;
      void GetReservation(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::GetReservationRequest* request, ::google::cloud::bigquery::reservation::v1::Reservation* response, ::grpc::ClientUnaryReactor* reactor) override;
      void DeleteReservation(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::DeleteReservationRequest* request, ::google::protobuf::Empty* response, std::function<void(::grpc::Status)>) override;
      void DeleteReservation(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::DeleteReservationRequest* request, ::google::protobuf::Empty* response, ::grpc::ClientUnaryReactor* reactor) override;
      void UpdateReservation(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::UpdateReservationRequest* request, ::google::cloud::bigquery::reservation::v1::Reservation* response, std::function<void(::grpc::Status)>) override;
      void UpdateReservation(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::UpdateReservationRequest* request, ::google::cloud::bigquery::reservation::v1::Reservation* response, ::grpc::ClientUnaryReactor* reactor) override;
      void CreateCapacityCommitment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::CreateCapacityCommitmentRequest* request, ::google::cloud::bigquery::reservation::v1::CapacityCommitment* response, std::function<void(::grpc::Status)>) override;
      void CreateCapacityCommitment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::CreateCapacityCommitmentRequest* request, ::google::cloud::bigquery::reservation::v1::CapacityCommitment* response, ::grpc::ClientUnaryReactor* reactor) override;
      void ListCapacityCommitments(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::ListCapacityCommitmentsRequest* request, ::google::cloud::bigquery::reservation::v1::ListCapacityCommitmentsResponse* response, std::function<void(::grpc::Status)>) override;
      void ListCapacityCommitments(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::ListCapacityCommitmentsRequest* request, ::google::cloud::bigquery::reservation::v1::ListCapacityCommitmentsResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
      void GetCapacityCommitment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::GetCapacityCommitmentRequest* request, ::google::cloud::bigquery::reservation::v1::CapacityCommitment* response, std::function<void(::grpc::Status)>) override;
      void GetCapacityCommitment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::GetCapacityCommitmentRequest* request, ::google::cloud::bigquery::reservation::v1::CapacityCommitment* response, ::grpc::ClientUnaryReactor* reactor) override;
      void DeleteCapacityCommitment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::DeleteCapacityCommitmentRequest* request, ::google::protobuf::Empty* response, std::function<void(::grpc::Status)>) override;
      void DeleteCapacityCommitment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::DeleteCapacityCommitmentRequest* request, ::google::protobuf::Empty* response, ::grpc::ClientUnaryReactor* reactor) override;
      void UpdateCapacityCommitment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::UpdateCapacityCommitmentRequest* request, ::google::cloud::bigquery::reservation::v1::CapacityCommitment* response, std::function<void(::grpc::Status)>) override;
      void UpdateCapacityCommitment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::UpdateCapacityCommitmentRequest* request, ::google::cloud::bigquery::reservation::v1::CapacityCommitment* response, ::grpc::ClientUnaryReactor* reactor) override;
      void SplitCapacityCommitment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::SplitCapacityCommitmentRequest* request, ::google::cloud::bigquery::reservation::v1::SplitCapacityCommitmentResponse* response, std::function<void(::grpc::Status)>) override;
      void SplitCapacityCommitment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::SplitCapacityCommitmentRequest* request, ::google::cloud::bigquery::reservation::v1::SplitCapacityCommitmentResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
      void MergeCapacityCommitments(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::MergeCapacityCommitmentsRequest* request, ::google::cloud::bigquery::reservation::v1::CapacityCommitment* response, std::function<void(::grpc::Status)>) override;
      void MergeCapacityCommitments(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::MergeCapacityCommitmentsRequest* request, ::google::cloud::bigquery::reservation::v1::CapacityCommitment* response, ::grpc::ClientUnaryReactor* reactor) override;
      void CreateAssignment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::CreateAssignmentRequest* request, ::google::cloud::bigquery::reservation::v1::Assignment* response, std::function<void(::grpc::Status)>) override;
      void CreateAssignment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::CreateAssignmentRequest* request, ::google::cloud::bigquery::reservation::v1::Assignment* response, ::grpc::ClientUnaryReactor* reactor) override;
      void ListAssignments(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::ListAssignmentsRequest* request, ::google::cloud::bigquery::reservation::v1::ListAssignmentsResponse* response, std::function<void(::grpc::Status)>) override;
      void ListAssignments(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::ListAssignmentsRequest* request, ::google::cloud::bigquery::reservation::v1::ListAssignmentsResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
      void DeleteAssignment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::DeleteAssignmentRequest* request, ::google::protobuf::Empty* response, std::function<void(::grpc::Status)>) override;
      void DeleteAssignment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::DeleteAssignmentRequest* request, ::google::protobuf::Empty* response, ::grpc::ClientUnaryReactor* reactor) override;
      void SearchAssignments(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::SearchAssignmentsRequest* request, ::google::cloud::bigquery::reservation::v1::SearchAssignmentsResponse* response, std::function<void(::grpc::Status)>) override;
      void SearchAssignments(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::SearchAssignmentsRequest* request, ::google::cloud::bigquery::reservation::v1::SearchAssignmentsResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
      void SearchAllAssignments(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::SearchAllAssignmentsRequest* request, ::google::cloud::bigquery::reservation::v1::SearchAllAssignmentsResponse* response, std::function<void(::grpc::Status)>) override;
      void SearchAllAssignments(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::SearchAllAssignmentsRequest* request, ::google::cloud::bigquery::reservation::v1::SearchAllAssignmentsResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
      void MoveAssignment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::MoveAssignmentRequest* request, ::google::cloud::bigquery::reservation::v1::Assignment* response, std::function<void(::grpc::Status)>) override;
      void MoveAssignment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::MoveAssignmentRequest* request, ::google::cloud::bigquery::reservation::v1::Assignment* response, ::grpc::ClientUnaryReactor* reactor) override;
      void UpdateAssignment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::UpdateAssignmentRequest* request, ::google::cloud::bigquery::reservation::v1::Assignment* response, std::function<void(::grpc::Status)>) override;
      void UpdateAssignment(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::UpdateAssignmentRequest* request, ::google::cloud::bigquery::reservation::v1::Assignment* response, ::grpc::ClientUnaryReactor* reactor) override;
      void GetBiReservation(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::GetBiReservationRequest* request, ::google::cloud::bigquery::reservation::v1::BiReservation* response, std::function<void(::grpc::Status)>) override;
      void GetBiReservation(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::GetBiReservationRequest* request, ::google::cloud::bigquery::reservation::v1::BiReservation* response, ::grpc::ClientUnaryReactor* reactor) override;
      void UpdateBiReservation(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::UpdateBiReservationRequest* request, ::google::cloud::bigquery::reservation::v1::BiReservation* response, std::function<void(::grpc::Status)>) override;
      void UpdateBiReservation(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::UpdateBiReservationRequest* request, ::google::cloud::bigquery::reservation::v1::BiReservation* response, ::grpc::ClientUnaryReactor* reactor) override;
     private:
      friend class Stub;
      explicit async(Stub* stub): stub_(stub) { }
      Stub* stub() { return stub_; }
      Stub* stub_;
    };
    class async* async() override { return &async_stub_; }

   private:
    std::shared_ptr< ::grpc::ChannelInterface> channel_;
    class async async_stub_{this};
    ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::Reservation>* AsyncCreateReservationRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::CreateReservationRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::Reservation>* PrepareAsyncCreateReservationRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::CreateReservationRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::ListReservationsResponse>* AsyncListReservationsRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::ListReservationsRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::ListReservationsResponse>* PrepareAsyncListReservationsRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::ListReservationsRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::Reservation>* AsyncGetReservationRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::GetReservationRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::Reservation>* PrepareAsyncGetReservationRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::GetReservationRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>* AsyncDeleteReservationRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::DeleteReservationRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>* PrepareAsyncDeleteReservationRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::DeleteReservationRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::Reservation>* AsyncUpdateReservationRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::UpdateReservationRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::Reservation>* PrepareAsyncUpdateReservationRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::UpdateReservationRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::CapacityCommitment>* AsyncCreateCapacityCommitmentRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::CreateCapacityCommitmentRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::CapacityCommitment>* PrepareAsyncCreateCapacityCommitmentRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::CreateCapacityCommitmentRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::ListCapacityCommitmentsResponse>* AsyncListCapacityCommitmentsRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::ListCapacityCommitmentsRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::ListCapacityCommitmentsResponse>* PrepareAsyncListCapacityCommitmentsRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::ListCapacityCommitmentsRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::CapacityCommitment>* AsyncGetCapacityCommitmentRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::GetCapacityCommitmentRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::CapacityCommitment>* PrepareAsyncGetCapacityCommitmentRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::GetCapacityCommitmentRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>* AsyncDeleteCapacityCommitmentRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::DeleteCapacityCommitmentRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>* PrepareAsyncDeleteCapacityCommitmentRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::DeleteCapacityCommitmentRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::CapacityCommitment>* AsyncUpdateCapacityCommitmentRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::UpdateCapacityCommitmentRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::CapacityCommitment>* PrepareAsyncUpdateCapacityCommitmentRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::UpdateCapacityCommitmentRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::SplitCapacityCommitmentResponse>* AsyncSplitCapacityCommitmentRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::SplitCapacityCommitmentRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::SplitCapacityCommitmentResponse>* PrepareAsyncSplitCapacityCommitmentRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::SplitCapacityCommitmentRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::CapacityCommitment>* AsyncMergeCapacityCommitmentsRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::MergeCapacityCommitmentsRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::CapacityCommitment>* PrepareAsyncMergeCapacityCommitmentsRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::MergeCapacityCommitmentsRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::Assignment>* AsyncCreateAssignmentRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::CreateAssignmentRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::Assignment>* PrepareAsyncCreateAssignmentRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::CreateAssignmentRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::ListAssignmentsResponse>* AsyncListAssignmentsRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::ListAssignmentsRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::ListAssignmentsResponse>* PrepareAsyncListAssignmentsRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::ListAssignmentsRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>* AsyncDeleteAssignmentRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::DeleteAssignmentRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>* PrepareAsyncDeleteAssignmentRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::DeleteAssignmentRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::SearchAssignmentsResponse>* AsyncSearchAssignmentsRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::SearchAssignmentsRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::SearchAssignmentsResponse>* PrepareAsyncSearchAssignmentsRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::SearchAssignmentsRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::SearchAllAssignmentsResponse>* AsyncSearchAllAssignmentsRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::SearchAllAssignmentsRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::SearchAllAssignmentsResponse>* PrepareAsyncSearchAllAssignmentsRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::SearchAllAssignmentsRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::Assignment>* AsyncMoveAssignmentRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::MoveAssignmentRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::Assignment>* PrepareAsyncMoveAssignmentRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::MoveAssignmentRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::Assignment>* AsyncUpdateAssignmentRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::UpdateAssignmentRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::Assignment>* PrepareAsyncUpdateAssignmentRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::UpdateAssignmentRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::BiReservation>* AsyncGetBiReservationRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::GetBiReservationRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::BiReservation>* PrepareAsyncGetBiReservationRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::GetBiReservationRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::BiReservation>* AsyncUpdateBiReservationRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::UpdateBiReservationRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::cloud::bigquery::reservation::v1::BiReservation>* PrepareAsyncUpdateBiReservationRaw(::grpc::ClientContext* context, const ::google::cloud::bigquery::reservation::v1::UpdateBiReservationRequest& request, ::grpc::CompletionQueue* cq) override;
    const ::grpc::internal::RpcMethod rpcmethod_CreateReservation_;
    const ::grpc::internal::RpcMethod rpcmethod_ListReservations_;
    const ::grpc::internal::RpcMethod rpcmethod_GetReservation_;
    const ::grpc::internal::RpcMethod rpcmethod_DeleteReservation_;
    const ::grpc::internal::RpcMethod rpcmethod_UpdateReservation_;
    const ::grpc::internal::RpcMethod rpcmethod_CreateCapacityCommitment_;
    const ::grpc::internal::RpcMethod rpcmethod_ListCapacityCommitments_;
    const ::grpc::internal::RpcMethod rpcmethod_GetCapacityCommitment_;
    const ::grpc::internal::RpcMethod rpcmethod_DeleteCapacityCommitment_;
    const ::grpc::internal::RpcMethod rpcmethod_UpdateCapacityCommitment_;
    const ::grpc::internal::RpcMethod rpcmethod_SplitCapacityCommitment_;
    const ::grpc::internal::RpcMethod rpcmethod_MergeCapacityCommitments_;
    const ::grpc::internal::RpcMethod rpcmethod_CreateAssignment_;
    const ::grpc::internal::RpcMethod rpcmethod_ListAssignments_;
    const ::grpc::internal::RpcMethod rpcmethod_DeleteAssignment_;
    const ::grpc::internal::RpcMethod rpcmethod_SearchAssignments_;
    const ::grpc::internal::RpcMethod rpcmethod_SearchAllAssignments_;
    const ::grpc::internal::RpcMethod rpcmethod_MoveAssignment_;
    const ::grpc::internal::RpcMethod rpcmethod_UpdateAssignment_;
    const ::grpc::internal::RpcMethod rpcmethod_GetBiReservation_;
    const ::grpc::internal::RpcMethod rpcmethod_UpdateBiReservation_;
  };
  static std::unique_ptr<Stub> NewStub(const std::shared_ptr< ::grpc::ChannelInterface>& channel, const ::grpc::StubOptions& options = ::grpc::StubOptions());

  class Service : public ::grpc::Service {
   public:
    Service();
    virtual ~Service();
    // Creates a new reservation resource.
    virtual ::grpc::Status CreateReservation(::grpc::ServerContext* context, const ::google::cloud::bigquery::reservation::v1::CreateReservationRequest* request, ::google::cloud::bigquery::reservation::v1::Reservation* response);
    // Lists all the reservations for the project in the specified location.
    virtual ::grpc::Status ListReservations(::grpc::ServerContext* context, const ::google::cloud::bigquery::reservation::v1::ListReservationsRequest* request, ::google::cloud::bigquery::reservation::v1::ListReservationsResponse* response);
    // Returns information about the reservation.
    virtual ::grpc::Status GetReservation(::grpc::ServerContext* context, const ::google::cloud::bigquery::reservation::v1::GetReservationRequest* request, ::google::cloud::bigquery::reservation::v1::Reservation* response);
    // Deletes a reservation.
    // Returns `google.rpc.Code.FAILED_PRECONDITION` when reservation has
    // assignments.
    virtual ::grpc::Status DeleteReservation(::grpc::ServerContext* context, const ::google::cloud::bigquery::reservation::v1::DeleteReservationRequest* request, ::google::protobuf::Empty* response);
    // Updates an existing reservation resource.
    virtual ::grpc::Status UpdateReservation(::grpc::ServerContext* context, const ::google::cloud::bigquery::reservation::v1::UpdateReservationRequest* request, ::google::cloud::bigquery::reservation::v1::Reservation* response);
    // Creates a new capacity commitment resource.
    virtual ::grpc::Status CreateCapacityCommitment(::grpc::ServerContext* context, const ::google::cloud::bigquery::reservation::v1::CreateCapacityCommitmentRequest* request, ::google::cloud::bigquery::reservation::v1::CapacityCommitment* response);
    // Lists all the capacity commitments for the admin project.
    virtual ::grpc::Status ListCapacityCommitments(::grpc::ServerContext* context, const ::google::cloud::bigquery::reservation::v1::ListCapacityCommitmentsRequest* request, ::google::cloud::bigquery::reservation::v1::ListCapacityCommitmentsResponse* response);
    // Returns information about the capacity commitment.
    virtual ::grpc::Status GetCapacityCommitment(::grpc::ServerContext* context, const ::google::cloud::bigquery::reservation::v1::GetCapacityCommitmentRequest* request, ::google::cloud::bigquery::reservation::v1::CapacityCommitment* response);
    // Deletes a capacity commitment. Attempting to delete capacity commitment
    // before its commitment_end_time will fail with the error code
    // `google.rpc.Code.FAILED_PRECONDITION`.
    virtual ::grpc::Status DeleteCapacityCommitment(::grpc::ServerContext* context, const ::google::cloud::bigquery::reservation::v1::DeleteCapacityCommitmentRequest* request, ::google::protobuf::Empty* response);
    // Updates an existing capacity commitment.
    //
    // Only `plan` and `renewal_plan` fields can be updated.
    //
    // Plan can only be changed to a plan of a longer commitment period.
    // Attempting to change to a plan with shorter commitment period will fail
    // with the error code `google.rpc.Code.FAILED_PRECONDITION`.
    virtual ::grpc::Status UpdateCapacityCommitment(::grpc::ServerContext* context, const ::google::cloud::bigquery::reservation::v1::UpdateCapacityCommitmentRequest* request, ::google::cloud::bigquery::reservation::v1::CapacityCommitment* response);
    // Splits capacity commitment to two commitments of the same plan and
    // `commitment_end_time`.
    //
    // A common use case is to enable downgrading commitments.
    //
    // For example, in order to downgrade from 10000 slots to 8000, you might
    // split a 10000 capacity commitment into commitments of 2000 and 8000. Then,
    // you delete the first one after the commitment end time passes.
    virtual ::grpc::Status SplitCapacityCommitment(::grpc::ServerContext* context, const ::google::cloud::bigquery::reservation::v1::SplitCapacityCommitmentRequest* request, ::google::cloud::bigquery::reservation::v1::SplitCapacityCommitmentResponse* response);
    // Merges capacity commitments of the same plan into a single commitment.
    //
    // The resulting capacity commitment has the greater commitment_end_time
    // out of the to-be-merged capacity commitments.
    //
    // Attempting to merge capacity commitments of different plan will fail
    // with the error code `google.rpc.Code.FAILED_PRECONDITION`.
    virtual ::grpc::Status MergeCapacityCommitments(::grpc::ServerContext* context, const ::google::cloud::bigquery::reservation::v1::MergeCapacityCommitmentsRequest* request, ::google::cloud::bigquery::reservation::v1::CapacityCommitment* response);
    // Creates an assignment object which allows the given project to submit jobs
    // of a certain type using slots from the specified reservation.
    //
    // Currently a
    // resource (project, folder, organization) can only have one assignment per
    // each (job_type, location) combination, and that reservation will be used
    // for all jobs of the matching type.
    //
    // Different assignments can be created on different levels of the
    // projects, folders or organization hierarchy.  During query execution,
    // the assignment is looked up at the project, folder and organization levels
    // in that order. The first assignment found is applied to the query.
    //
    // When creating assignments, it does not matter if other assignments exist at
    // higher levels.
    //
    // Example:
    //
    // * The organization `organizationA` contains two projects, `project1`
    //   and `project2`.
    // * Assignments for all three entities (`organizationA`, `project1`, and
    //   `project2`) could all be created and mapped to the same or different
    //   reservations.
    //
    // "None" assignments represent an absence of the assignment. Projects
    // assigned to None use on-demand pricing. To create a "None" assignment, use
    // "none" as a reservation_id in the parent. Example parent:
    // `projects/myproject/locations/US/reservations/none`.
    //
    // Returns `google.rpc.Code.PERMISSION_DENIED` if user does not have
    // 'bigquery.admin' permissions on the project using the reservation
    // and the project that owns this reservation.
    //
    // Returns `google.rpc.Code.INVALID_ARGUMENT` when location of the assignment
    // does not match location of the reservation.
    virtual ::grpc::Status CreateAssignment(::grpc::ServerContext* context, const ::google::cloud::bigquery::reservation::v1::CreateAssignmentRequest* request, ::google::cloud::bigquery::reservation::v1::Assignment* response);
    // Lists assignments.
    //
    // Only explicitly created assignments will be returned.
    //
    // Example:
    //
    // * Organization `organizationA` contains two projects, `project1` and
    //   `project2`.
    // * Reservation `res1` exists and was created previously.
    // * CreateAssignment was used previously to define the following
    //   associations between entities and reservations: `<organizationA, res1>`
    //   and `<project1, res1>`
    //
    // In this example, ListAssignments will just return the above two assignments
    // for reservation `res1`, and no expansion/merge will happen.
    //
    // The wildcard "-" can be used for
    // reservations in the request. In that case all assignments belongs to the
    // specified project and location will be listed.
    //
    // **Note** "-" cannot be used for projects nor locations.
    virtual ::grpc::Status ListAssignments(::grpc::ServerContext* context, const ::google::cloud::bigquery::reservation::v1::ListAssignmentsRequest* request, ::google::cloud::bigquery::reservation::v1::ListAssignmentsResponse* response);
    // Deletes a assignment. No expansion will happen.
    //
    // Example:
    //
    // * Organization `organizationA` contains two projects, `project1` and
    //   `project2`.
    // * Reservation `res1` exists and was created previously.
    // * CreateAssignment was used previously to define the following
    //   associations between entities and reservations: `<organizationA, res1>`
    //   and `<project1, res1>`
    //
    // In this example, deletion of the `<organizationA, res1>` assignment won't
    // affect the other assignment `<project1, res1>`. After said deletion,
    // queries from `project1` will still use `res1` while queries from
    // `project2` will switch to use on-demand mode.
    virtual ::grpc::Status DeleteAssignment(::grpc::ServerContext* context, const ::google::cloud::bigquery::reservation::v1::DeleteAssignmentRequest* request, ::google::protobuf::Empty* response);
    // Deprecated: Looks up assignments for a specified resource for a particular
    // region. If the request is about a project:
    //
    // 1. Assignments created on the project will be returned if they exist.
    // 2. Otherwise assignments created on the closest ancestor will be
    //    returned.
    // 3. Assignments for different JobTypes will all be returned.
    //
    // The same logic applies if the request is about a folder.
    //
    // If the request is about an organization, then assignments created on the
    // organization will be returned (organization doesn't have ancestors).
    //
    // Comparing to ListAssignments, there are some behavior
    // differences:
    //
    // 1. permission on the assignee will be verified in this API.
    // 2. Hierarchy lookup (project->folder->organization) happens in this API.
    // 3. Parent here is `projects/*/locations/*`, instead of
    //    `projects/*/locations/*reservations/*`.
    //
    // **Note** "-" cannot be used for projects
    // nor locations.
    virtual ::grpc::Status SearchAssignments(::grpc::ServerContext* context, const ::google::cloud::bigquery::reservation::v1::SearchAssignmentsRequest* request, ::google::cloud::bigquery::reservation::v1::SearchAssignmentsResponse* response);
    // Looks up assignments for a specified resource for a particular region.
    // If the request is about a project:
    //
    // 1. Assignments created on the project will be returned if they exist.
    // 2. Otherwise assignments created on the closest ancestor will be
    //    returned.
    // 3. Assignments for different JobTypes will all be returned.
    //
    // The same logic applies if the request is about a folder.
    //
    // If the request is about an organization, then assignments created on the
    // organization will be returned (organization doesn't have ancestors).
    //
    // Comparing to ListAssignments, there are some behavior
    // differences:
    //
    // 1. permission on the assignee will be verified in this API.
    // 2. Hierarchy lookup (project->folder->organization) happens in this API.
    // 3. Parent here is `projects/*/locations/*`, instead of
    //    `projects/*/locations/*reservations/*`.
    virtual ::grpc::Status SearchAllAssignments(::grpc::ServerContext* context, const ::google::cloud::bigquery::reservation::v1::SearchAllAssignmentsRequest* request, ::google::cloud::bigquery::reservation::v1::SearchAllAssignmentsResponse* response);
    // Moves an assignment under a new reservation.
    //
    // This differs from removing an existing assignment and recreating a new one
    // by providing a transactional change that ensures an assignee always has an
    // associated reservation.
    virtual ::grpc::Status MoveAssignment(::grpc::ServerContext* context, const ::google::cloud::bigquery::reservation::v1::MoveAssignmentRequest* request, ::google::cloud::bigquery::reservation::v1::Assignment* response);
    // Updates an existing assignment.
    //
    // Only the `priority` field can be updated.
    virtual ::grpc::Status UpdateAssignment(::grpc::ServerContext* context, const ::google::cloud::bigquery::reservation::v1::UpdateAssignmentRequest* request, ::google::cloud::bigquery::reservation::v1::Assignment* response);
    // Retrieves a BI reservation.
    virtual ::grpc::Status GetBiReservation(::grpc::ServerContext* context, const ::google::cloud::bigquery::reservation::v1::GetBiReservationRequest* request, ::google::cloud::bigquery::reservation::v1::BiReservation* response);
    // Updates a BI reservation.
    //
    // Only fields specified in the `field_mask` are updated.
    //
    // A singleton BI reservation always exists with default size 0.
    // In order to reserve BI capacity it needs to be updated to an amount
    // greater than 0. In order to release BI capacity reservation size
    // must be set to 0.
    virtual ::grpc::Status UpdateBiReservation(::grpc::ServerContext* context, const ::google::cloud::bigquery::reservation::v1::UpdateBiReservationRequest* request, ::google::cloud::bigquery::reservation::v1::BiReservation* response);
  };
  template <class BaseClass>
  class WithAsyncMethod_CreateReservation : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_CreateReservation() {
      ::grpc::Service::MarkMethodAsync(0);
    }
    ~WithAsyncMethod_CreateReservation() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateReservation(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::CreateReservationRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::Reservation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestCreateReservation(::grpc::ServerContext* context, ::google::cloud::bigquery::reservation::v1::CreateReservationRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::cloud::bigquery::reservation::v1::Reservation>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(0, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_ListReservations : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_ListReservations() {
      ::grpc::Service::MarkMethodAsync(1);
    }
    ~WithAsyncMethod_ListReservations() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListReservations(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::ListReservationsRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::ListReservationsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestListReservations(::grpc::ServerContext* context, ::google::cloud::bigquery::reservation::v1::ListReservationsRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::cloud::bigquery::reservation::v1::ListReservationsResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(1, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_GetReservation : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_GetReservation() {
      ::grpc::Service::MarkMethodAsync(2);
    }
    ~WithAsyncMethod_GetReservation() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetReservation(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::GetReservationRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::Reservation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGetReservation(::grpc::ServerContext* context, ::google::cloud::bigquery::reservation::v1::GetReservationRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::cloud::bigquery::reservation::v1::Reservation>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(2, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_DeleteReservation : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_DeleteReservation() {
      ::grpc::Service::MarkMethodAsync(3);
    }
    ~WithAsyncMethod_DeleteReservation() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteReservation(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::DeleteReservationRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestDeleteReservation(::grpc::ServerContext* context, ::google::cloud::bigquery::reservation::v1::DeleteReservationRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::protobuf::Empty>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(3, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_UpdateReservation : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_UpdateReservation() {
      ::grpc::Service::MarkMethodAsync(4);
    }
    ~WithAsyncMethod_UpdateReservation() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateReservation(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::UpdateReservationRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::Reservation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestUpdateReservation(::grpc::ServerContext* context, ::google::cloud::bigquery::reservation::v1::UpdateReservationRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::cloud::bigquery::reservation::v1::Reservation>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(4, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_CreateCapacityCommitment : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_CreateCapacityCommitment() {
      ::grpc::Service::MarkMethodAsync(5);
    }
    ~WithAsyncMethod_CreateCapacityCommitment() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateCapacityCommitment(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::CreateCapacityCommitmentRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::CapacityCommitment* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestCreateCapacityCommitment(::grpc::ServerContext* context, ::google::cloud::bigquery::reservation::v1::CreateCapacityCommitmentRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::cloud::bigquery::reservation::v1::CapacityCommitment>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(5, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_ListCapacityCommitments : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_ListCapacityCommitments() {
      ::grpc::Service::MarkMethodAsync(6);
    }
    ~WithAsyncMethod_ListCapacityCommitments() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListCapacityCommitments(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::ListCapacityCommitmentsRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::ListCapacityCommitmentsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestListCapacityCommitments(::grpc::ServerContext* context, ::google::cloud::bigquery::reservation::v1::ListCapacityCommitmentsRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::cloud::bigquery::reservation::v1::ListCapacityCommitmentsResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(6, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_GetCapacityCommitment : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_GetCapacityCommitment() {
      ::grpc::Service::MarkMethodAsync(7);
    }
    ~WithAsyncMethod_GetCapacityCommitment() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetCapacityCommitment(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::GetCapacityCommitmentRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::CapacityCommitment* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGetCapacityCommitment(::grpc::ServerContext* context, ::google::cloud::bigquery::reservation::v1::GetCapacityCommitmentRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::cloud::bigquery::reservation::v1::CapacityCommitment>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(7, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_DeleteCapacityCommitment : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_DeleteCapacityCommitment() {
      ::grpc::Service::MarkMethodAsync(8);
    }
    ~WithAsyncMethod_DeleteCapacityCommitment() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteCapacityCommitment(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::DeleteCapacityCommitmentRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestDeleteCapacityCommitment(::grpc::ServerContext* context, ::google::cloud::bigquery::reservation::v1::DeleteCapacityCommitmentRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::protobuf::Empty>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(8, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_UpdateCapacityCommitment : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_UpdateCapacityCommitment() {
      ::grpc::Service::MarkMethodAsync(9);
    }
    ~WithAsyncMethod_UpdateCapacityCommitment() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateCapacityCommitment(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::UpdateCapacityCommitmentRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::CapacityCommitment* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestUpdateCapacityCommitment(::grpc::ServerContext* context, ::google::cloud::bigquery::reservation::v1::UpdateCapacityCommitmentRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::cloud::bigquery::reservation::v1::CapacityCommitment>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(9, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_SplitCapacityCommitment : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_SplitCapacityCommitment() {
      ::grpc::Service::MarkMethodAsync(10);
    }
    ~WithAsyncMethod_SplitCapacityCommitment() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status SplitCapacityCommitment(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::SplitCapacityCommitmentRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::SplitCapacityCommitmentResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestSplitCapacityCommitment(::grpc::ServerContext* context, ::google::cloud::bigquery::reservation::v1::SplitCapacityCommitmentRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::cloud::bigquery::reservation::v1::SplitCapacityCommitmentResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(10, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_MergeCapacityCommitments : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_MergeCapacityCommitments() {
      ::grpc::Service::MarkMethodAsync(11);
    }
    ~WithAsyncMethod_MergeCapacityCommitments() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status MergeCapacityCommitments(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::MergeCapacityCommitmentsRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::CapacityCommitment* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestMergeCapacityCommitments(::grpc::ServerContext* context, ::google::cloud::bigquery::reservation::v1::MergeCapacityCommitmentsRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::cloud::bigquery::reservation::v1::CapacityCommitment>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(11, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_CreateAssignment : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_CreateAssignment() {
      ::grpc::Service::MarkMethodAsync(12);
    }
    ~WithAsyncMethod_CreateAssignment() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateAssignment(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::CreateAssignmentRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::Assignment* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestCreateAssignment(::grpc::ServerContext* context, ::google::cloud::bigquery::reservation::v1::CreateAssignmentRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::cloud::bigquery::reservation::v1::Assignment>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(12, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_ListAssignments : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_ListAssignments() {
      ::grpc::Service::MarkMethodAsync(13);
    }
    ~WithAsyncMethod_ListAssignments() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListAssignments(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::ListAssignmentsRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::ListAssignmentsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestListAssignments(::grpc::ServerContext* context, ::google::cloud::bigquery::reservation::v1::ListAssignmentsRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::cloud::bigquery::reservation::v1::ListAssignmentsResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(13, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_DeleteAssignment : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_DeleteAssignment() {
      ::grpc::Service::MarkMethodAsync(14);
    }
    ~WithAsyncMethod_DeleteAssignment() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteAssignment(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::DeleteAssignmentRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestDeleteAssignment(::grpc::ServerContext* context, ::google::cloud::bigquery::reservation::v1::DeleteAssignmentRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::protobuf::Empty>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(14, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_SearchAssignments : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_SearchAssignments() {
      ::grpc::Service::MarkMethodAsync(15);
    }
    ~WithAsyncMethod_SearchAssignments() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status SearchAssignments(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::SearchAssignmentsRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::SearchAssignmentsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestSearchAssignments(::grpc::ServerContext* context, ::google::cloud::bigquery::reservation::v1::SearchAssignmentsRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::cloud::bigquery::reservation::v1::SearchAssignmentsResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(15, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_SearchAllAssignments : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_SearchAllAssignments() {
      ::grpc::Service::MarkMethodAsync(16);
    }
    ~WithAsyncMethod_SearchAllAssignments() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status SearchAllAssignments(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::SearchAllAssignmentsRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::SearchAllAssignmentsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestSearchAllAssignments(::grpc::ServerContext* context, ::google::cloud::bigquery::reservation::v1::SearchAllAssignmentsRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::cloud::bigquery::reservation::v1::SearchAllAssignmentsResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(16, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_MoveAssignment : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_MoveAssignment() {
      ::grpc::Service::MarkMethodAsync(17);
    }
    ~WithAsyncMethod_MoveAssignment() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status MoveAssignment(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::MoveAssignmentRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::Assignment* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestMoveAssignment(::grpc::ServerContext* context, ::google::cloud::bigquery::reservation::v1::MoveAssignmentRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::cloud::bigquery::reservation::v1::Assignment>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(17, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_UpdateAssignment : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_UpdateAssignment() {
      ::grpc::Service::MarkMethodAsync(18);
    }
    ~WithAsyncMethod_UpdateAssignment() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateAssignment(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::UpdateAssignmentRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::Assignment* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestUpdateAssignment(::grpc::ServerContext* context, ::google::cloud::bigquery::reservation::v1::UpdateAssignmentRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::cloud::bigquery::reservation::v1::Assignment>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(18, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_GetBiReservation : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_GetBiReservation() {
      ::grpc::Service::MarkMethodAsync(19);
    }
    ~WithAsyncMethod_GetBiReservation() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetBiReservation(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::GetBiReservationRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::BiReservation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGetBiReservation(::grpc::ServerContext* context, ::google::cloud::bigquery::reservation::v1::GetBiReservationRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::cloud::bigquery::reservation::v1::BiReservation>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(19, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_UpdateBiReservation : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_UpdateBiReservation() {
      ::grpc::Service::MarkMethodAsync(20);
    }
    ~WithAsyncMethod_UpdateBiReservation() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateBiReservation(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::UpdateBiReservationRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::BiReservation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestUpdateBiReservation(::grpc::ServerContext* context, ::google::cloud::bigquery::reservation::v1::UpdateBiReservationRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::cloud::bigquery::reservation::v1::BiReservation>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(20, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  typedef WithAsyncMethod_CreateReservation<WithAsyncMethod_ListReservations<WithAsyncMethod_GetReservation<WithAsyncMethod_DeleteReservation<WithAsyncMethod_UpdateReservation<WithAsyncMethod_CreateCapacityCommitment<WithAsyncMethod_ListCapacityCommitments<WithAsyncMethod_GetCapacityCommitment<WithAsyncMethod_DeleteCapacityCommitment<WithAsyncMethod_UpdateCapacityCommitment<WithAsyncMethod_SplitCapacityCommitment<WithAsyncMethod_MergeCapacityCommitments<WithAsyncMethod_CreateAssignment<WithAsyncMethod_ListAssignments<WithAsyncMethod_DeleteAssignment<WithAsyncMethod_SearchAssignments<WithAsyncMethod_SearchAllAssignments<WithAsyncMethod_MoveAssignment<WithAsyncMethod_UpdateAssignment<WithAsyncMethod_GetBiReservation<WithAsyncMethod_UpdateBiReservation<Service > > > > > > > > > > > > > > > > > > > > > AsyncService;
  template <class BaseClass>
  class WithCallbackMethod_CreateReservation : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_CreateReservation() {
      ::grpc::Service::MarkMethodCallback(0,
          new ::grpc::internal::CallbackUnaryHandler< ::google::cloud::bigquery::reservation::v1::CreateReservationRequest, ::google::cloud::bigquery::reservation::v1::Reservation>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::cloud::bigquery::reservation::v1::CreateReservationRequest* request, ::google::cloud::bigquery::reservation::v1::Reservation* response) { return this->CreateReservation(context, request, response); }));}
    void SetMessageAllocatorFor_CreateReservation(
        ::grpc::MessageAllocator< ::google::cloud::bigquery::reservation::v1::CreateReservationRequest, ::google::cloud::bigquery::reservation::v1::Reservation>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(0);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::cloud::bigquery::reservation::v1::CreateReservationRequest, ::google::cloud::bigquery::reservation::v1::Reservation>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_CreateReservation() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateReservation(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::CreateReservationRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::Reservation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* CreateReservation(
      ::grpc::CallbackServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::CreateReservationRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::Reservation* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_ListReservations : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_ListReservations() {
      ::grpc::Service::MarkMethodCallback(1,
          new ::grpc::internal::CallbackUnaryHandler< ::google::cloud::bigquery::reservation::v1::ListReservationsRequest, ::google::cloud::bigquery::reservation::v1::ListReservationsResponse>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::cloud::bigquery::reservation::v1::ListReservationsRequest* request, ::google::cloud::bigquery::reservation::v1::ListReservationsResponse* response) { return this->ListReservations(context, request, response); }));}
    void SetMessageAllocatorFor_ListReservations(
        ::grpc::MessageAllocator< ::google::cloud::bigquery::reservation::v1::ListReservationsRequest, ::google::cloud::bigquery::reservation::v1::ListReservationsResponse>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(1);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::cloud::bigquery::reservation::v1::ListReservationsRequest, ::google::cloud::bigquery::reservation::v1::ListReservationsResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_ListReservations() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListReservations(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::ListReservationsRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::ListReservationsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* ListReservations(
      ::grpc::CallbackServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::ListReservationsRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::ListReservationsResponse* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_GetReservation : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_GetReservation() {
      ::grpc::Service::MarkMethodCallback(2,
          new ::grpc::internal::CallbackUnaryHandler< ::google::cloud::bigquery::reservation::v1::GetReservationRequest, ::google::cloud::bigquery::reservation::v1::Reservation>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::cloud::bigquery::reservation::v1::GetReservationRequest* request, ::google::cloud::bigquery::reservation::v1::Reservation* response) { return this->GetReservation(context, request, response); }));}
    void SetMessageAllocatorFor_GetReservation(
        ::grpc::MessageAllocator< ::google::cloud::bigquery::reservation::v1::GetReservationRequest, ::google::cloud::bigquery::reservation::v1::Reservation>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(2);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::cloud::bigquery::reservation::v1::GetReservationRequest, ::google::cloud::bigquery::reservation::v1::Reservation>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_GetReservation() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetReservation(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::GetReservationRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::Reservation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* GetReservation(
      ::grpc::CallbackServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::GetReservationRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::Reservation* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_DeleteReservation : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_DeleteReservation() {
      ::grpc::Service::MarkMethodCallback(3,
          new ::grpc::internal::CallbackUnaryHandler< ::google::cloud::bigquery::reservation::v1::DeleteReservationRequest, ::google::protobuf::Empty>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::cloud::bigquery::reservation::v1::DeleteReservationRequest* request, ::google::protobuf::Empty* response) { return this->DeleteReservation(context, request, response); }));}
    void SetMessageAllocatorFor_DeleteReservation(
        ::grpc::MessageAllocator< ::google::cloud::bigquery::reservation::v1::DeleteReservationRequest, ::google::protobuf::Empty>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(3);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::cloud::bigquery::reservation::v1::DeleteReservationRequest, ::google::protobuf::Empty>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_DeleteReservation() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteReservation(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::DeleteReservationRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* DeleteReservation(
      ::grpc::CallbackServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::DeleteReservationRequest* /*request*/, ::google::protobuf::Empty* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_UpdateReservation : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_UpdateReservation() {
      ::grpc::Service::MarkMethodCallback(4,
          new ::grpc::internal::CallbackUnaryHandler< ::google::cloud::bigquery::reservation::v1::UpdateReservationRequest, ::google::cloud::bigquery::reservation::v1::Reservation>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::cloud::bigquery::reservation::v1::UpdateReservationRequest* request, ::google::cloud::bigquery::reservation::v1::Reservation* response) { return this->UpdateReservation(context, request, response); }));}
    void SetMessageAllocatorFor_UpdateReservation(
        ::grpc::MessageAllocator< ::google::cloud::bigquery::reservation::v1::UpdateReservationRequest, ::google::cloud::bigquery::reservation::v1::Reservation>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(4);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::cloud::bigquery::reservation::v1::UpdateReservationRequest, ::google::cloud::bigquery::reservation::v1::Reservation>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_UpdateReservation() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateReservation(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::UpdateReservationRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::Reservation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* UpdateReservation(
      ::grpc::CallbackServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::UpdateReservationRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::Reservation* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_CreateCapacityCommitment : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_CreateCapacityCommitment() {
      ::grpc::Service::MarkMethodCallback(5,
          new ::grpc::internal::CallbackUnaryHandler< ::google::cloud::bigquery::reservation::v1::CreateCapacityCommitmentRequest, ::google::cloud::bigquery::reservation::v1::CapacityCommitment>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::cloud::bigquery::reservation::v1::CreateCapacityCommitmentRequest* request, ::google::cloud::bigquery::reservation::v1::CapacityCommitment* response) { return this->CreateCapacityCommitment(context, request, response); }));}
    void SetMessageAllocatorFor_CreateCapacityCommitment(
        ::grpc::MessageAllocator< ::google::cloud::bigquery::reservation::v1::CreateCapacityCommitmentRequest, ::google::cloud::bigquery::reservation::v1::CapacityCommitment>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(5);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::cloud::bigquery::reservation::v1::CreateCapacityCommitmentRequest, ::google::cloud::bigquery::reservation::v1::CapacityCommitment>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_CreateCapacityCommitment() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateCapacityCommitment(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::CreateCapacityCommitmentRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::CapacityCommitment* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* CreateCapacityCommitment(
      ::grpc::CallbackServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::CreateCapacityCommitmentRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::CapacityCommitment* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_ListCapacityCommitments : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_ListCapacityCommitments() {
      ::grpc::Service::MarkMethodCallback(6,
          new ::grpc::internal::CallbackUnaryHandler< ::google::cloud::bigquery::reservation::v1::ListCapacityCommitmentsRequest, ::google::cloud::bigquery::reservation::v1::ListCapacityCommitmentsResponse>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::cloud::bigquery::reservation::v1::ListCapacityCommitmentsRequest* request, ::google::cloud::bigquery::reservation::v1::ListCapacityCommitmentsResponse* response) { return this->ListCapacityCommitments(context, request, response); }));}
    void SetMessageAllocatorFor_ListCapacityCommitments(
        ::grpc::MessageAllocator< ::google::cloud::bigquery::reservation::v1::ListCapacityCommitmentsRequest, ::google::cloud::bigquery::reservation::v1::ListCapacityCommitmentsResponse>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(6);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::cloud::bigquery::reservation::v1::ListCapacityCommitmentsRequest, ::google::cloud::bigquery::reservation::v1::ListCapacityCommitmentsResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_ListCapacityCommitments() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListCapacityCommitments(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::ListCapacityCommitmentsRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::ListCapacityCommitmentsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* ListCapacityCommitments(
      ::grpc::CallbackServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::ListCapacityCommitmentsRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::ListCapacityCommitmentsResponse* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_GetCapacityCommitment : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_GetCapacityCommitment() {
      ::grpc::Service::MarkMethodCallback(7,
          new ::grpc::internal::CallbackUnaryHandler< ::google::cloud::bigquery::reservation::v1::GetCapacityCommitmentRequest, ::google::cloud::bigquery::reservation::v1::CapacityCommitment>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::cloud::bigquery::reservation::v1::GetCapacityCommitmentRequest* request, ::google::cloud::bigquery::reservation::v1::CapacityCommitment* response) { return this->GetCapacityCommitment(context, request, response); }));}
    void SetMessageAllocatorFor_GetCapacityCommitment(
        ::grpc::MessageAllocator< ::google::cloud::bigquery::reservation::v1::GetCapacityCommitmentRequest, ::google::cloud::bigquery::reservation::v1::CapacityCommitment>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(7);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::cloud::bigquery::reservation::v1::GetCapacityCommitmentRequest, ::google::cloud::bigquery::reservation::v1::CapacityCommitment>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_GetCapacityCommitment() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetCapacityCommitment(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::GetCapacityCommitmentRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::CapacityCommitment* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* GetCapacityCommitment(
      ::grpc::CallbackServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::GetCapacityCommitmentRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::CapacityCommitment* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_DeleteCapacityCommitment : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_DeleteCapacityCommitment() {
      ::grpc::Service::MarkMethodCallback(8,
          new ::grpc::internal::CallbackUnaryHandler< ::google::cloud::bigquery::reservation::v1::DeleteCapacityCommitmentRequest, ::google::protobuf::Empty>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::cloud::bigquery::reservation::v1::DeleteCapacityCommitmentRequest* request, ::google::protobuf::Empty* response) { return this->DeleteCapacityCommitment(context, request, response); }));}
    void SetMessageAllocatorFor_DeleteCapacityCommitment(
        ::grpc::MessageAllocator< ::google::cloud::bigquery::reservation::v1::DeleteCapacityCommitmentRequest, ::google::protobuf::Empty>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(8);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::cloud::bigquery::reservation::v1::DeleteCapacityCommitmentRequest, ::google::protobuf::Empty>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_DeleteCapacityCommitment() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteCapacityCommitment(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::DeleteCapacityCommitmentRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* DeleteCapacityCommitment(
      ::grpc::CallbackServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::DeleteCapacityCommitmentRequest* /*request*/, ::google::protobuf::Empty* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_UpdateCapacityCommitment : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_UpdateCapacityCommitment() {
      ::grpc::Service::MarkMethodCallback(9,
          new ::grpc::internal::CallbackUnaryHandler< ::google::cloud::bigquery::reservation::v1::UpdateCapacityCommitmentRequest, ::google::cloud::bigquery::reservation::v1::CapacityCommitment>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::cloud::bigquery::reservation::v1::UpdateCapacityCommitmentRequest* request, ::google::cloud::bigquery::reservation::v1::CapacityCommitment* response) { return this->UpdateCapacityCommitment(context, request, response); }));}
    void SetMessageAllocatorFor_UpdateCapacityCommitment(
        ::grpc::MessageAllocator< ::google::cloud::bigquery::reservation::v1::UpdateCapacityCommitmentRequest, ::google::cloud::bigquery::reservation::v1::CapacityCommitment>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(9);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::cloud::bigquery::reservation::v1::UpdateCapacityCommitmentRequest, ::google::cloud::bigquery::reservation::v1::CapacityCommitment>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_UpdateCapacityCommitment() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateCapacityCommitment(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::UpdateCapacityCommitmentRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::CapacityCommitment* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* UpdateCapacityCommitment(
      ::grpc::CallbackServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::UpdateCapacityCommitmentRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::CapacityCommitment* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_SplitCapacityCommitment : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_SplitCapacityCommitment() {
      ::grpc::Service::MarkMethodCallback(10,
          new ::grpc::internal::CallbackUnaryHandler< ::google::cloud::bigquery::reservation::v1::SplitCapacityCommitmentRequest, ::google::cloud::bigquery::reservation::v1::SplitCapacityCommitmentResponse>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::cloud::bigquery::reservation::v1::SplitCapacityCommitmentRequest* request, ::google::cloud::bigquery::reservation::v1::SplitCapacityCommitmentResponse* response) { return this->SplitCapacityCommitment(context, request, response); }));}
    void SetMessageAllocatorFor_SplitCapacityCommitment(
        ::grpc::MessageAllocator< ::google::cloud::bigquery::reservation::v1::SplitCapacityCommitmentRequest, ::google::cloud::bigquery::reservation::v1::SplitCapacityCommitmentResponse>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(10);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::cloud::bigquery::reservation::v1::SplitCapacityCommitmentRequest, ::google::cloud::bigquery::reservation::v1::SplitCapacityCommitmentResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_SplitCapacityCommitment() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status SplitCapacityCommitment(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::SplitCapacityCommitmentRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::SplitCapacityCommitmentResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* SplitCapacityCommitment(
      ::grpc::CallbackServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::SplitCapacityCommitmentRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::SplitCapacityCommitmentResponse* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_MergeCapacityCommitments : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_MergeCapacityCommitments() {
      ::grpc::Service::MarkMethodCallback(11,
          new ::grpc::internal::CallbackUnaryHandler< ::google::cloud::bigquery::reservation::v1::MergeCapacityCommitmentsRequest, ::google::cloud::bigquery::reservation::v1::CapacityCommitment>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::cloud::bigquery::reservation::v1::MergeCapacityCommitmentsRequest* request, ::google::cloud::bigquery::reservation::v1::CapacityCommitment* response) { return this->MergeCapacityCommitments(context, request, response); }));}
    void SetMessageAllocatorFor_MergeCapacityCommitments(
        ::grpc::MessageAllocator< ::google::cloud::bigquery::reservation::v1::MergeCapacityCommitmentsRequest, ::google::cloud::bigquery::reservation::v1::CapacityCommitment>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(11);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::cloud::bigquery::reservation::v1::MergeCapacityCommitmentsRequest, ::google::cloud::bigquery::reservation::v1::CapacityCommitment>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_MergeCapacityCommitments() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status MergeCapacityCommitments(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::MergeCapacityCommitmentsRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::CapacityCommitment* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* MergeCapacityCommitments(
      ::grpc::CallbackServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::MergeCapacityCommitmentsRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::CapacityCommitment* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_CreateAssignment : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_CreateAssignment() {
      ::grpc::Service::MarkMethodCallback(12,
          new ::grpc::internal::CallbackUnaryHandler< ::google::cloud::bigquery::reservation::v1::CreateAssignmentRequest, ::google::cloud::bigquery::reservation::v1::Assignment>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::cloud::bigquery::reservation::v1::CreateAssignmentRequest* request, ::google::cloud::bigquery::reservation::v1::Assignment* response) { return this->CreateAssignment(context, request, response); }));}
    void SetMessageAllocatorFor_CreateAssignment(
        ::grpc::MessageAllocator< ::google::cloud::bigquery::reservation::v1::CreateAssignmentRequest, ::google::cloud::bigquery::reservation::v1::Assignment>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(12);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::cloud::bigquery::reservation::v1::CreateAssignmentRequest, ::google::cloud::bigquery::reservation::v1::Assignment>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_CreateAssignment() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateAssignment(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::CreateAssignmentRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::Assignment* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* CreateAssignment(
      ::grpc::CallbackServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::CreateAssignmentRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::Assignment* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_ListAssignments : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_ListAssignments() {
      ::grpc::Service::MarkMethodCallback(13,
          new ::grpc::internal::CallbackUnaryHandler< ::google::cloud::bigquery::reservation::v1::ListAssignmentsRequest, ::google::cloud::bigquery::reservation::v1::ListAssignmentsResponse>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::cloud::bigquery::reservation::v1::ListAssignmentsRequest* request, ::google::cloud::bigquery::reservation::v1::ListAssignmentsResponse* response) { return this->ListAssignments(context, request, response); }));}
    void SetMessageAllocatorFor_ListAssignments(
        ::grpc::MessageAllocator< ::google::cloud::bigquery::reservation::v1::ListAssignmentsRequest, ::google::cloud::bigquery::reservation::v1::ListAssignmentsResponse>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(13);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::cloud::bigquery::reservation::v1::ListAssignmentsRequest, ::google::cloud::bigquery::reservation::v1::ListAssignmentsResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_ListAssignments() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListAssignments(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::ListAssignmentsRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::ListAssignmentsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* ListAssignments(
      ::grpc::CallbackServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::ListAssignmentsRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::ListAssignmentsResponse* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_DeleteAssignment : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_DeleteAssignment() {
      ::grpc::Service::MarkMethodCallback(14,
          new ::grpc::internal::CallbackUnaryHandler< ::google::cloud::bigquery::reservation::v1::DeleteAssignmentRequest, ::google::protobuf::Empty>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::cloud::bigquery::reservation::v1::DeleteAssignmentRequest* request, ::google::protobuf::Empty* response) { return this->DeleteAssignment(context, request, response); }));}
    void SetMessageAllocatorFor_DeleteAssignment(
        ::grpc::MessageAllocator< ::google::cloud::bigquery::reservation::v1::DeleteAssignmentRequest, ::google::protobuf::Empty>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(14);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::cloud::bigquery::reservation::v1::DeleteAssignmentRequest, ::google::protobuf::Empty>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_DeleteAssignment() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteAssignment(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::DeleteAssignmentRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* DeleteAssignment(
      ::grpc::CallbackServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::DeleteAssignmentRequest* /*request*/, ::google::protobuf::Empty* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_SearchAssignments : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_SearchAssignments() {
      ::grpc::Service::MarkMethodCallback(15,
          new ::grpc::internal::CallbackUnaryHandler< ::google::cloud::bigquery::reservation::v1::SearchAssignmentsRequest, ::google::cloud::bigquery::reservation::v1::SearchAssignmentsResponse>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::cloud::bigquery::reservation::v1::SearchAssignmentsRequest* request, ::google::cloud::bigquery::reservation::v1::SearchAssignmentsResponse* response) { return this->SearchAssignments(context, request, response); }));}
    void SetMessageAllocatorFor_SearchAssignments(
        ::grpc::MessageAllocator< ::google::cloud::bigquery::reservation::v1::SearchAssignmentsRequest, ::google::cloud::bigquery::reservation::v1::SearchAssignmentsResponse>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(15);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::cloud::bigquery::reservation::v1::SearchAssignmentsRequest, ::google::cloud::bigquery::reservation::v1::SearchAssignmentsResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_SearchAssignments() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status SearchAssignments(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::SearchAssignmentsRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::SearchAssignmentsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* SearchAssignments(
      ::grpc::CallbackServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::SearchAssignmentsRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::SearchAssignmentsResponse* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_SearchAllAssignments : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_SearchAllAssignments() {
      ::grpc::Service::MarkMethodCallback(16,
          new ::grpc::internal::CallbackUnaryHandler< ::google::cloud::bigquery::reservation::v1::SearchAllAssignmentsRequest, ::google::cloud::bigquery::reservation::v1::SearchAllAssignmentsResponse>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::cloud::bigquery::reservation::v1::SearchAllAssignmentsRequest* request, ::google::cloud::bigquery::reservation::v1::SearchAllAssignmentsResponse* response) { return this->SearchAllAssignments(context, request, response); }));}
    void SetMessageAllocatorFor_SearchAllAssignments(
        ::grpc::MessageAllocator< ::google::cloud::bigquery::reservation::v1::SearchAllAssignmentsRequest, ::google::cloud::bigquery::reservation::v1::SearchAllAssignmentsResponse>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(16);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::cloud::bigquery::reservation::v1::SearchAllAssignmentsRequest, ::google::cloud::bigquery::reservation::v1::SearchAllAssignmentsResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_SearchAllAssignments() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status SearchAllAssignments(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::SearchAllAssignmentsRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::SearchAllAssignmentsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* SearchAllAssignments(
      ::grpc::CallbackServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::SearchAllAssignmentsRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::SearchAllAssignmentsResponse* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_MoveAssignment : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_MoveAssignment() {
      ::grpc::Service::MarkMethodCallback(17,
          new ::grpc::internal::CallbackUnaryHandler< ::google::cloud::bigquery::reservation::v1::MoveAssignmentRequest, ::google::cloud::bigquery::reservation::v1::Assignment>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::cloud::bigquery::reservation::v1::MoveAssignmentRequest* request, ::google::cloud::bigquery::reservation::v1::Assignment* response) { return this->MoveAssignment(context, request, response); }));}
    void SetMessageAllocatorFor_MoveAssignment(
        ::grpc::MessageAllocator< ::google::cloud::bigquery::reservation::v1::MoveAssignmentRequest, ::google::cloud::bigquery::reservation::v1::Assignment>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(17);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::cloud::bigquery::reservation::v1::MoveAssignmentRequest, ::google::cloud::bigquery::reservation::v1::Assignment>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_MoveAssignment() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status MoveAssignment(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::MoveAssignmentRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::Assignment* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* MoveAssignment(
      ::grpc::CallbackServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::MoveAssignmentRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::Assignment* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_UpdateAssignment : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_UpdateAssignment() {
      ::grpc::Service::MarkMethodCallback(18,
          new ::grpc::internal::CallbackUnaryHandler< ::google::cloud::bigquery::reservation::v1::UpdateAssignmentRequest, ::google::cloud::bigquery::reservation::v1::Assignment>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::cloud::bigquery::reservation::v1::UpdateAssignmentRequest* request, ::google::cloud::bigquery::reservation::v1::Assignment* response) { return this->UpdateAssignment(context, request, response); }));}
    void SetMessageAllocatorFor_UpdateAssignment(
        ::grpc::MessageAllocator< ::google::cloud::bigquery::reservation::v1::UpdateAssignmentRequest, ::google::cloud::bigquery::reservation::v1::Assignment>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(18);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::cloud::bigquery::reservation::v1::UpdateAssignmentRequest, ::google::cloud::bigquery::reservation::v1::Assignment>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_UpdateAssignment() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateAssignment(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::UpdateAssignmentRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::Assignment* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* UpdateAssignment(
      ::grpc::CallbackServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::UpdateAssignmentRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::Assignment* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_GetBiReservation : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_GetBiReservation() {
      ::grpc::Service::MarkMethodCallback(19,
          new ::grpc::internal::CallbackUnaryHandler< ::google::cloud::bigquery::reservation::v1::GetBiReservationRequest, ::google::cloud::bigquery::reservation::v1::BiReservation>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::cloud::bigquery::reservation::v1::GetBiReservationRequest* request, ::google::cloud::bigquery::reservation::v1::BiReservation* response) { return this->GetBiReservation(context, request, response); }));}
    void SetMessageAllocatorFor_GetBiReservation(
        ::grpc::MessageAllocator< ::google::cloud::bigquery::reservation::v1::GetBiReservationRequest, ::google::cloud::bigquery::reservation::v1::BiReservation>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(19);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::cloud::bigquery::reservation::v1::GetBiReservationRequest, ::google::cloud::bigquery::reservation::v1::BiReservation>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_GetBiReservation() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetBiReservation(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::GetBiReservationRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::BiReservation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* GetBiReservation(
      ::grpc::CallbackServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::GetBiReservationRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::BiReservation* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_UpdateBiReservation : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_UpdateBiReservation() {
      ::grpc::Service::MarkMethodCallback(20,
          new ::grpc::internal::CallbackUnaryHandler< ::google::cloud::bigquery::reservation::v1::UpdateBiReservationRequest, ::google::cloud::bigquery::reservation::v1::BiReservation>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::cloud::bigquery::reservation::v1::UpdateBiReservationRequest* request, ::google::cloud::bigquery::reservation::v1::BiReservation* response) { return this->UpdateBiReservation(context, request, response); }));}
    void SetMessageAllocatorFor_UpdateBiReservation(
        ::grpc::MessageAllocator< ::google::cloud::bigquery::reservation::v1::UpdateBiReservationRequest, ::google::cloud::bigquery::reservation::v1::BiReservation>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(20);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::cloud::bigquery::reservation::v1::UpdateBiReservationRequest, ::google::cloud::bigquery::reservation::v1::BiReservation>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_UpdateBiReservation() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateBiReservation(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::UpdateBiReservationRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::BiReservation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* UpdateBiReservation(
      ::grpc::CallbackServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::UpdateBiReservationRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::BiReservation* /*response*/)  { return nullptr; }
  };
  typedef WithCallbackMethod_CreateReservation<WithCallbackMethod_ListReservations<WithCallbackMethod_GetReservation<WithCallbackMethod_DeleteReservation<WithCallbackMethod_UpdateReservation<WithCallbackMethod_CreateCapacityCommitment<WithCallbackMethod_ListCapacityCommitments<WithCallbackMethod_GetCapacityCommitment<WithCallbackMethod_DeleteCapacityCommitment<WithCallbackMethod_UpdateCapacityCommitment<WithCallbackMethod_SplitCapacityCommitment<WithCallbackMethod_MergeCapacityCommitments<WithCallbackMethod_CreateAssignment<WithCallbackMethod_ListAssignments<WithCallbackMethod_DeleteAssignment<WithCallbackMethod_SearchAssignments<WithCallbackMethod_SearchAllAssignments<WithCallbackMethod_MoveAssignment<WithCallbackMethod_UpdateAssignment<WithCallbackMethod_GetBiReservation<WithCallbackMethod_UpdateBiReservation<Service > > > > > > > > > > > > > > > > > > > > > CallbackService;
  typedef CallbackService ExperimentalCallbackService;
  template <class BaseClass>
  class WithGenericMethod_CreateReservation : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_CreateReservation() {
      ::grpc::Service::MarkMethodGeneric(0);
    }
    ~WithGenericMethod_CreateReservation() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateReservation(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::CreateReservationRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::Reservation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_ListReservations : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_ListReservations() {
      ::grpc::Service::MarkMethodGeneric(1);
    }
    ~WithGenericMethod_ListReservations() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListReservations(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::ListReservationsRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::ListReservationsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_GetReservation : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_GetReservation() {
      ::grpc::Service::MarkMethodGeneric(2);
    }
    ~WithGenericMethod_GetReservation() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetReservation(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::GetReservationRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::Reservation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_DeleteReservation : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_DeleteReservation() {
      ::grpc::Service::MarkMethodGeneric(3);
    }
    ~WithGenericMethod_DeleteReservation() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteReservation(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::DeleteReservationRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_UpdateReservation : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_UpdateReservation() {
      ::grpc::Service::MarkMethodGeneric(4);
    }
    ~WithGenericMethod_UpdateReservation() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateReservation(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::UpdateReservationRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::Reservation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_CreateCapacityCommitment : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_CreateCapacityCommitment() {
      ::grpc::Service::MarkMethodGeneric(5);
    }
    ~WithGenericMethod_CreateCapacityCommitment() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateCapacityCommitment(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::CreateCapacityCommitmentRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::CapacityCommitment* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_ListCapacityCommitments : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_ListCapacityCommitments() {
      ::grpc::Service::MarkMethodGeneric(6);
    }
    ~WithGenericMethod_ListCapacityCommitments() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListCapacityCommitments(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::ListCapacityCommitmentsRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::ListCapacityCommitmentsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_GetCapacityCommitment : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_GetCapacityCommitment() {
      ::grpc::Service::MarkMethodGeneric(7);
    }
    ~WithGenericMethod_GetCapacityCommitment() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetCapacityCommitment(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::GetCapacityCommitmentRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::CapacityCommitment* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_DeleteCapacityCommitment : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_DeleteCapacityCommitment() {
      ::grpc::Service::MarkMethodGeneric(8);
    }
    ~WithGenericMethod_DeleteCapacityCommitment() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteCapacityCommitment(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::DeleteCapacityCommitmentRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_UpdateCapacityCommitment : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_UpdateCapacityCommitment() {
      ::grpc::Service::MarkMethodGeneric(9);
    }
    ~WithGenericMethod_UpdateCapacityCommitment() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateCapacityCommitment(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::UpdateCapacityCommitmentRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::CapacityCommitment* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_SplitCapacityCommitment : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_SplitCapacityCommitment() {
      ::grpc::Service::MarkMethodGeneric(10);
    }
    ~WithGenericMethod_SplitCapacityCommitment() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status SplitCapacityCommitment(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::SplitCapacityCommitmentRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::SplitCapacityCommitmentResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_MergeCapacityCommitments : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_MergeCapacityCommitments() {
      ::grpc::Service::MarkMethodGeneric(11);
    }
    ~WithGenericMethod_MergeCapacityCommitments() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status MergeCapacityCommitments(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::MergeCapacityCommitmentsRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::CapacityCommitment* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_CreateAssignment : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_CreateAssignment() {
      ::grpc::Service::MarkMethodGeneric(12);
    }
    ~WithGenericMethod_CreateAssignment() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateAssignment(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::CreateAssignmentRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::Assignment* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_ListAssignments : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_ListAssignments() {
      ::grpc::Service::MarkMethodGeneric(13);
    }
    ~WithGenericMethod_ListAssignments() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListAssignments(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::ListAssignmentsRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::ListAssignmentsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_DeleteAssignment : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_DeleteAssignment() {
      ::grpc::Service::MarkMethodGeneric(14);
    }
    ~WithGenericMethod_DeleteAssignment() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteAssignment(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::DeleteAssignmentRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_SearchAssignments : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_SearchAssignments() {
      ::grpc::Service::MarkMethodGeneric(15);
    }
    ~WithGenericMethod_SearchAssignments() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status SearchAssignments(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::SearchAssignmentsRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::SearchAssignmentsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_SearchAllAssignments : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_SearchAllAssignments() {
      ::grpc::Service::MarkMethodGeneric(16);
    }
    ~WithGenericMethod_SearchAllAssignments() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status SearchAllAssignments(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::SearchAllAssignmentsRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::SearchAllAssignmentsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_MoveAssignment : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_MoveAssignment() {
      ::grpc::Service::MarkMethodGeneric(17);
    }
    ~WithGenericMethod_MoveAssignment() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status MoveAssignment(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::MoveAssignmentRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::Assignment* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_UpdateAssignment : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_UpdateAssignment() {
      ::grpc::Service::MarkMethodGeneric(18);
    }
    ~WithGenericMethod_UpdateAssignment() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateAssignment(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::UpdateAssignmentRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::Assignment* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_GetBiReservation : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_GetBiReservation() {
      ::grpc::Service::MarkMethodGeneric(19);
    }
    ~WithGenericMethod_GetBiReservation() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetBiReservation(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::GetBiReservationRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::BiReservation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_UpdateBiReservation : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_UpdateBiReservation() {
      ::grpc::Service::MarkMethodGeneric(20);
    }
    ~WithGenericMethod_UpdateBiReservation() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateBiReservation(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::UpdateBiReservationRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::BiReservation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithRawMethod_CreateReservation : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_CreateReservation() {
      ::grpc::Service::MarkMethodRaw(0);
    }
    ~WithRawMethod_CreateReservation() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateReservation(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::CreateReservationRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::Reservation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestCreateReservation(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(0, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_ListReservations : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_ListReservations() {
      ::grpc::Service::MarkMethodRaw(1);
    }
    ~WithRawMethod_ListReservations() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListReservations(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::ListReservationsRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::ListReservationsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestListReservations(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(1, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_GetReservation : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_GetReservation() {
      ::grpc::Service::MarkMethodRaw(2);
    }
    ~WithRawMethod_GetReservation() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetReservation(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::GetReservationRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::Reservation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGetReservation(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(2, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_DeleteReservation : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_DeleteReservation() {
      ::grpc::Service::MarkMethodRaw(3);
    }
    ~WithRawMethod_DeleteReservation() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteReservation(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::DeleteReservationRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestDeleteReservation(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(3, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_UpdateReservation : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_UpdateReservation() {
      ::grpc::Service::MarkMethodRaw(4);
    }
    ~WithRawMethod_UpdateReservation() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateReservation(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::UpdateReservationRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::Reservation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestUpdateReservation(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(4, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_CreateCapacityCommitment : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_CreateCapacityCommitment() {
      ::grpc::Service::MarkMethodRaw(5);
    }
    ~WithRawMethod_CreateCapacityCommitment() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateCapacityCommitment(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::CreateCapacityCommitmentRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::CapacityCommitment* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestCreateCapacityCommitment(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(5, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_ListCapacityCommitments : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_ListCapacityCommitments() {
      ::grpc::Service::MarkMethodRaw(6);
    }
    ~WithRawMethod_ListCapacityCommitments() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListCapacityCommitments(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::ListCapacityCommitmentsRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::ListCapacityCommitmentsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestListCapacityCommitments(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(6, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_GetCapacityCommitment : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_GetCapacityCommitment() {
      ::grpc::Service::MarkMethodRaw(7);
    }
    ~WithRawMethod_GetCapacityCommitment() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetCapacityCommitment(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::GetCapacityCommitmentRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::CapacityCommitment* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGetCapacityCommitment(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(7, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_DeleteCapacityCommitment : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_DeleteCapacityCommitment() {
      ::grpc::Service::MarkMethodRaw(8);
    }
    ~WithRawMethod_DeleteCapacityCommitment() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteCapacityCommitment(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::DeleteCapacityCommitmentRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestDeleteCapacityCommitment(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(8, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_UpdateCapacityCommitment : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_UpdateCapacityCommitment() {
      ::grpc::Service::MarkMethodRaw(9);
    }
    ~WithRawMethod_UpdateCapacityCommitment() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateCapacityCommitment(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::UpdateCapacityCommitmentRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::CapacityCommitment* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestUpdateCapacityCommitment(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(9, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_SplitCapacityCommitment : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_SplitCapacityCommitment() {
      ::grpc::Service::MarkMethodRaw(10);
    }
    ~WithRawMethod_SplitCapacityCommitment() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status SplitCapacityCommitment(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::SplitCapacityCommitmentRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::SplitCapacityCommitmentResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestSplitCapacityCommitment(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(10, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_MergeCapacityCommitments : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_MergeCapacityCommitments() {
      ::grpc::Service::MarkMethodRaw(11);
    }
    ~WithRawMethod_MergeCapacityCommitments() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status MergeCapacityCommitments(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::MergeCapacityCommitmentsRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::CapacityCommitment* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestMergeCapacityCommitments(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(11, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_CreateAssignment : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_CreateAssignment() {
      ::grpc::Service::MarkMethodRaw(12);
    }
    ~WithRawMethod_CreateAssignment() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateAssignment(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::CreateAssignmentRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::Assignment* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestCreateAssignment(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(12, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_ListAssignments : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_ListAssignments() {
      ::grpc::Service::MarkMethodRaw(13);
    }
    ~WithRawMethod_ListAssignments() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListAssignments(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::ListAssignmentsRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::ListAssignmentsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestListAssignments(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(13, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_DeleteAssignment : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_DeleteAssignment() {
      ::grpc::Service::MarkMethodRaw(14);
    }
    ~WithRawMethod_DeleteAssignment() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteAssignment(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::DeleteAssignmentRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestDeleteAssignment(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(14, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_SearchAssignments : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_SearchAssignments() {
      ::grpc::Service::MarkMethodRaw(15);
    }
    ~WithRawMethod_SearchAssignments() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status SearchAssignments(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::SearchAssignmentsRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::SearchAssignmentsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestSearchAssignments(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(15, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_SearchAllAssignments : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_SearchAllAssignments() {
      ::grpc::Service::MarkMethodRaw(16);
    }
    ~WithRawMethod_SearchAllAssignments() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status SearchAllAssignments(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::SearchAllAssignmentsRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::SearchAllAssignmentsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestSearchAllAssignments(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(16, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_MoveAssignment : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_MoveAssignment() {
      ::grpc::Service::MarkMethodRaw(17);
    }
    ~WithRawMethod_MoveAssignment() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status MoveAssignment(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::MoveAssignmentRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::Assignment* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestMoveAssignment(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(17, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_UpdateAssignment : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_UpdateAssignment() {
      ::grpc::Service::MarkMethodRaw(18);
    }
    ~WithRawMethod_UpdateAssignment() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateAssignment(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::UpdateAssignmentRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::Assignment* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestUpdateAssignment(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(18, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_GetBiReservation : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_GetBiReservation() {
      ::grpc::Service::MarkMethodRaw(19);
    }
    ~WithRawMethod_GetBiReservation() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetBiReservation(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::GetBiReservationRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::BiReservation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGetBiReservation(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(19, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_UpdateBiReservation : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_UpdateBiReservation() {
      ::grpc::Service::MarkMethodRaw(20);
    }
    ~WithRawMethod_UpdateBiReservation() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateBiReservation(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::UpdateBiReservationRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::BiReservation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestUpdateBiReservation(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(20, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_CreateReservation : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_CreateReservation() {
      ::grpc::Service::MarkMethodRawCallback(0,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->CreateReservation(context, request, response); }));
    }
    ~WithRawCallbackMethod_CreateReservation() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateReservation(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::CreateReservationRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::Reservation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* CreateReservation(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_ListReservations : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_ListReservations() {
      ::grpc::Service::MarkMethodRawCallback(1,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->ListReservations(context, request, response); }));
    }
    ~WithRawCallbackMethod_ListReservations() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListReservations(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::ListReservationsRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::ListReservationsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* ListReservations(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_GetReservation : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_GetReservation() {
      ::grpc::Service::MarkMethodRawCallback(2,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->GetReservation(context, request, response); }));
    }
    ~WithRawCallbackMethod_GetReservation() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetReservation(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::GetReservationRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::Reservation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* GetReservation(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_DeleteReservation : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_DeleteReservation() {
      ::grpc::Service::MarkMethodRawCallback(3,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->DeleteReservation(context, request, response); }));
    }
    ~WithRawCallbackMethod_DeleteReservation() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteReservation(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::DeleteReservationRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* DeleteReservation(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_UpdateReservation : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_UpdateReservation() {
      ::grpc::Service::MarkMethodRawCallback(4,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->UpdateReservation(context, request, response); }));
    }
    ~WithRawCallbackMethod_UpdateReservation() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateReservation(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::UpdateReservationRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::Reservation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* UpdateReservation(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_CreateCapacityCommitment : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_CreateCapacityCommitment() {
      ::grpc::Service::MarkMethodRawCallback(5,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->CreateCapacityCommitment(context, request, response); }));
    }
    ~WithRawCallbackMethod_CreateCapacityCommitment() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateCapacityCommitment(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::CreateCapacityCommitmentRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::CapacityCommitment* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* CreateCapacityCommitment(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_ListCapacityCommitments : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_ListCapacityCommitments() {
      ::grpc::Service::MarkMethodRawCallback(6,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->ListCapacityCommitments(context, request, response); }));
    }
    ~WithRawCallbackMethod_ListCapacityCommitments() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListCapacityCommitments(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::ListCapacityCommitmentsRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::ListCapacityCommitmentsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* ListCapacityCommitments(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_GetCapacityCommitment : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_GetCapacityCommitment() {
      ::grpc::Service::MarkMethodRawCallback(7,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->GetCapacityCommitment(context, request, response); }));
    }
    ~WithRawCallbackMethod_GetCapacityCommitment() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetCapacityCommitment(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::GetCapacityCommitmentRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::CapacityCommitment* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* GetCapacityCommitment(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_DeleteCapacityCommitment : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_DeleteCapacityCommitment() {
      ::grpc::Service::MarkMethodRawCallback(8,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->DeleteCapacityCommitment(context, request, response); }));
    }
    ~WithRawCallbackMethod_DeleteCapacityCommitment() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteCapacityCommitment(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::DeleteCapacityCommitmentRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* DeleteCapacityCommitment(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_UpdateCapacityCommitment : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_UpdateCapacityCommitment() {
      ::grpc::Service::MarkMethodRawCallback(9,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->UpdateCapacityCommitment(context, request, response); }));
    }
    ~WithRawCallbackMethod_UpdateCapacityCommitment() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateCapacityCommitment(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::UpdateCapacityCommitmentRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::CapacityCommitment* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* UpdateCapacityCommitment(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_SplitCapacityCommitment : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_SplitCapacityCommitment() {
      ::grpc::Service::MarkMethodRawCallback(10,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->SplitCapacityCommitment(context, request, response); }));
    }
    ~WithRawCallbackMethod_SplitCapacityCommitment() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status SplitCapacityCommitment(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::SplitCapacityCommitmentRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::SplitCapacityCommitmentResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* SplitCapacityCommitment(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_MergeCapacityCommitments : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_MergeCapacityCommitments() {
      ::grpc::Service::MarkMethodRawCallback(11,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->MergeCapacityCommitments(context, request, response); }));
    }
    ~WithRawCallbackMethod_MergeCapacityCommitments() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status MergeCapacityCommitments(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::MergeCapacityCommitmentsRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::CapacityCommitment* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* MergeCapacityCommitments(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_CreateAssignment : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_CreateAssignment() {
      ::grpc::Service::MarkMethodRawCallback(12,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->CreateAssignment(context, request, response); }));
    }
    ~WithRawCallbackMethod_CreateAssignment() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateAssignment(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::CreateAssignmentRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::Assignment* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* CreateAssignment(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_ListAssignments : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_ListAssignments() {
      ::grpc::Service::MarkMethodRawCallback(13,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->ListAssignments(context, request, response); }));
    }
    ~WithRawCallbackMethod_ListAssignments() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListAssignments(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::ListAssignmentsRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::ListAssignmentsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* ListAssignments(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_DeleteAssignment : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_DeleteAssignment() {
      ::grpc::Service::MarkMethodRawCallback(14,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->DeleteAssignment(context, request, response); }));
    }
    ~WithRawCallbackMethod_DeleteAssignment() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteAssignment(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::DeleteAssignmentRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* DeleteAssignment(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_SearchAssignments : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_SearchAssignments() {
      ::grpc::Service::MarkMethodRawCallback(15,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->SearchAssignments(context, request, response); }));
    }
    ~WithRawCallbackMethod_SearchAssignments() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status SearchAssignments(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::SearchAssignmentsRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::SearchAssignmentsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* SearchAssignments(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_SearchAllAssignments : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_SearchAllAssignments() {
      ::grpc::Service::MarkMethodRawCallback(16,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->SearchAllAssignments(context, request, response); }));
    }
    ~WithRawCallbackMethod_SearchAllAssignments() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status SearchAllAssignments(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::SearchAllAssignmentsRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::SearchAllAssignmentsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* SearchAllAssignments(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_MoveAssignment : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_MoveAssignment() {
      ::grpc::Service::MarkMethodRawCallback(17,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->MoveAssignment(context, request, response); }));
    }
    ~WithRawCallbackMethod_MoveAssignment() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status MoveAssignment(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::MoveAssignmentRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::Assignment* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* MoveAssignment(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_UpdateAssignment : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_UpdateAssignment() {
      ::grpc::Service::MarkMethodRawCallback(18,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->UpdateAssignment(context, request, response); }));
    }
    ~WithRawCallbackMethod_UpdateAssignment() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateAssignment(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::UpdateAssignmentRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::Assignment* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* UpdateAssignment(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_GetBiReservation : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_GetBiReservation() {
      ::grpc::Service::MarkMethodRawCallback(19,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->GetBiReservation(context, request, response); }));
    }
    ~WithRawCallbackMethod_GetBiReservation() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetBiReservation(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::GetBiReservationRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::BiReservation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* GetBiReservation(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_UpdateBiReservation : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_UpdateBiReservation() {
      ::grpc::Service::MarkMethodRawCallback(20,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->UpdateBiReservation(context, request, response); }));
    }
    ~WithRawCallbackMethod_UpdateBiReservation() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateBiReservation(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::UpdateBiReservationRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::BiReservation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* UpdateBiReservation(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_CreateReservation : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_CreateReservation() {
      ::grpc::Service::MarkMethodStreamed(0,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::cloud::bigquery::reservation::v1::CreateReservationRequest, ::google::cloud::bigquery::reservation::v1::Reservation>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::cloud::bigquery::reservation::v1::CreateReservationRequest, ::google::cloud::bigquery::reservation::v1::Reservation>* streamer) {
                       return this->StreamedCreateReservation(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_CreateReservation() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status CreateReservation(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::CreateReservationRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::Reservation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedCreateReservation(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::cloud::bigquery::reservation::v1::CreateReservationRequest,::google::cloud::bigquery::reservation::v1::Reservation>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_ListReservations : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_ListReservations() {
      ::grpc::Service::MarkMethodStreamed(1,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::cloud::bigquery::reservation::v1::ListReservationsRequest, ::google::cloud::bigquery::reservation::v1::ListReservationsResponse>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::cloud::bigquery::reservation::v1::ListReservationsRequest, ::google::cloud::bigquery::reservation::v1::ListReservationsResponse>* streamer) {
                       return this->StreamedListReservations(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_ListReservations() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status ListReservations(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::ListReservationsRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::ListReservationsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedListReservations(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::cloud::bigquery::reservation::v1::ListReservationsRequest,::google::cloud::bigquery::reservation::v1::ListReservationsResponse>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_GetReservation : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_GetReservation() {
      ::grpc::Service::MarkMethodStreamed(2,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::cloud::bigquery::reservation::v1::GetReservationRequest, ::google::cloud::bigquery::reservation::v1::Reservation>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::cloud::bigquery::reservation::v1::GetReservationRequest, ::google::cloud::bigquery::reservation::v1::Reservation>* streamer) {
                       return this->StreamedGetReservation(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_GetReservation() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status GetReservation(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::GetReservationRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::Reservation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedGetReservation(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::cloud::bigquery::reservation::v1::GetReservationRequest,::google::cloud::bigquery::reservation::v1::Reservation>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_DeleteReservation : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_DeleteReservation() {
      ::grpc::Service::MarkMethodStreamed(3,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::cloud::bigquery::reservation::v1::DeleteReservationRequest, ::google::protobuf::Empty>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::cloud::bigquery::reservation::v1::DeleteReservationRequest, ::google::protobuf::Empty>* streamer) {
                       return this->StreamedDeleteReservation(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_DeleteReservation() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status DeleteReservation(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::DeleteReservationRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedDeleteReservation(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::cloud::bigquery::reservation::v1::DeleteReservationRequest,::google::protobuf::Empty>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_UpdateReservation : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_UpdateReservation() {
      ::grpc::Service::MarkMethodStreamed(4,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::cloud::bigquery::reservation::v1::UpdateReservationRequest, ::google::cloud::bigquery::reservation::v1::Reservation>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::cloud::bigquery::reservation::v1::UpdateReservationRequest, ::google::cloud::bigquery::reservation::v1::Reservation>* streamer) {
                       return this->StreamedUpdateReservation(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_UpdateReservation() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status UpdateReservation(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::UpdateReservationRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::Reservation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedUpdateReservation(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::cloud::bigquery::reservation::v1::UpdateReservationRequest,::google::cloud::bigquery::reservation::v1::Reservation>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_CreateCapacityCommitment : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_CreateCapacityCommitment() {
      ::grpc::Service::MarkMethodStreamed(5,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::cloud::bigquery::reservation::v1::CreateCapacityCommitmentRequest, ::google::cloud::bigquery::reservation::v1::CapacityCommitment>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::cloud::bigquery::reservation::v1::CreateCapacityCommitmentRequest, ::google::cloud::bigquery::reservation::v1::CapacityCommitment>* streamer) {
                       return this->StreamedCreateCapacityCommitment(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_CreateCapacityCommitment() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status CreateCapacityCommitment(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::CreateCapacityCommitmentRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::CapacityCommitment* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedCreateCapacityCommitment(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::cloud::bigquery::reservation::v1::CreateCapacityCommitmentRequest,::google::cloud::bigquery::reservation::v1::CapacityCommitment>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_ListCapacityCommitments : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_ListCapacityCommitments() {
      ::grpc::Service::MarkMethodStreamed(6,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::cloud::bigquery::reservation::v1::ListCapacityCommitmentsRequest, ::google::cloud::bigquery::reservation::v1::ListCapacityCommitmentsResponse>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::cloud::bigquery::reservation::v1::ListCapacityCommitmentsRequest, ::google::cloud::bigquery::reservation::v1::ListCapacityCommitmentsResponse>* streamer) {
                       return this->StreamedListCapacityCommitments(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_ListCapacityCommitments() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status ListCapacityCommitments(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::ListCapacityCommitmentsRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::ListCapacityCommitmentsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedListCapacityCommitments(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::cloud::bigquery::reservation::v1::ListCapacityCommitmentsRequest,::google::cloud::bigquery::reservation::v1::ListCapacityCommitmentsResponse>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_GetCapacityCommitment : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_GetCapacityCommitment() {
      ::grpc::Service::MarkMethodStreamed(7,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::cloud::bigquery::reservation::v1::GetCapacityCommitmentRequest, ::google::cloud::bigquery::reservation::v1::CapacityCommitment>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::cloud::bigquery::reservation::v1::GetCapacityCommitmentRequest, ::google::cloud::bigquery::reservation::v1::CapacityCommitment>* streamer) {
                       return this->StreamedGetCapacityCommitment(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_GetCapacityCommitment() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status GetCapacityCommitment(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::GetCapacityCommitmentRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::CapacityCommitment* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedGetCapacityCommitment(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::cloud::bigquery::reservation::v1::GetCapacityCommitmentRequest,::google::cloud::bigquery::reservation::v1::CapacityCommitment>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_DeleteCapacityCommitment : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_DeleteCapacityCommitment() {
      ::grpc::Service::MarkMethodStreamed(8,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::cloud::bigquery::reservation::v1::DeleteCapacityCommitmentRequest, ::google::protobuf::Empty>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::cloud::bigquery::reservation::v1::DeleteCapacityCommitmentRequest, ::google::protobuf::Empty>* streamer) {
                       return this->StreamedDeleteCapacityCommitment(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_DeleteCapacityCommitment() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status DeleteCapacityCommitment(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::DeleteCapacityCommitmentRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedDeleteCapacityCommitment(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::cloud::bigquery::reservation::v1::DeleteCapacityCommitmentRequest,::google::protobuf::Empty>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_UpdateCapacityCommitment : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_UpdateCapacityCommitment() {
      ::grpc::Service::MarkMethodStreamed(9,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::cloud::bigquery::reservation::v1::UpdateCapacityCommitmentRequest, ::google::cloud::bigquery::reservation::v1::CapacityCommitment>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::cloud::bigquery::reservation::v1::UpdateCapacityCommitmentRequest, ::google::cloud::bigquery::reservation::v1::CapacityCommitment>* streamer) {
                       return this->StreamedUpdateCapacityCommitment(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_UpdateCapacityCommitment() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status UpdateCapacityCommitment(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::UpdateCapacityCommitmentRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::CapacityCommitment* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedUpdateCapacityCommitment(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::cloud::bigquery::reservation::v1::UpdateCapacityCommitmentRequest,::google::cloud::bigquery::reservation::v1::CapacityCommitment>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_SplitCapacityCommitment : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_SplitCapacityCommitment() {
      ::grpc::Service::MarkMethodStreamed(10,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::cloud::bigquery::reservation::v1::SplitCapacityCommitmentRequest, ::google::cloud::bigquery::reservation::v1::SplitCapacityCommitmentResponse>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::cloud::bigquery::reservation::v1::SplitCapacityCommitmentRequest, ::google::cloud::bigquery::reservation::v1::SplitCapacityCommitmentResponse>* streamer) {
                       return this->StreamedSplitCapacityCommitment(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_SplitCapacityCommitment() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status SplitCapacityCommitment(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::SplitCapacityCommitmentRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::SplitCapacityCommitmentResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedSplitCapacityCommitment(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::cloud::bigquery::reservation::v1::SplitCapacityCommitmentRequest,::google::cloud::bigquery::reservation::v1::SplitCapacityCommitmentResponse>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_MergeCapacityCommitments : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_MergeCapacityCommitments() {
      ::grpc::Service::MarkMethodStreamed(11,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::cloud::bigquery::reservation::v1::MergeCapacityCommitmentsRequest, ::google::cloud::bigquery::reservation::v1::CapacityCommitment>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::cloud::bigquery::reservation::v1::MergeCapacityCommitmentsRequest, ::google::cloud::bigquery::reservation::v1::CapacityCommitment>* streamer) {
                       return this->StreamedMergeCapacityCommitments(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_MergeCapacityCommitments() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status MergeCapacityCommitments(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::MergeCapacityCommitmentsRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::CapacityCommitment* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedMergeCapacityCommitments(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::cloud::bigquery::reservation::v1::MergeCapacityCommitmentsRequest,::google::cloud::bigquery::reservation::v1::CapacityCommitment>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_CreateAssignment : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_CreateAssignment() {
      ::grpc::Service::MarkMethodStreamed(12,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::cloud::bigquery::reservation::v1::CreateAssignmentRequest, ::google::cloud::bigquery::reservation::v1::Assignment>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::cloud::bigquery::reservation::v1::CreateAssignmentRequest, ::google::cloud::bigquery::reservation::v1::Assignment>* streamer) {
                       return this->StreamedCreateAssignment(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_CreateAssignment() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status CreateAssignment(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::CreateAssignmentRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::Assignment* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedCreateAssignment(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::cloud::bigquery::reservation::v1::CreateAssignmentRequest,::google::cloud::bigquery::reservation::v1::Assignment>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_ListAssignments : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_ListAssignments() {
      ::grpc::Service::MarkMethodStreamed(13,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::cloud::bigquery::reservation::v1::ListAssignmentsRequest, ::google::cloud::bigquery::reservation::v1::ListAssignmentsResponse>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::cloud::bigquery::reservation::v1::ListAssignmentsRequest, ::google::cloud::bigquery::reservation::v1::ListAssignmentsResponse>* streamer) {
                       return this->StreamedListAssignments(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_ListAssignments() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status ListAssignments(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::ListAssignmentsRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::ListAssignmentsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedListAssignments(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::cloud::bigquery::reservation::v1::ListAssignmentsRequest,::google::cloud::bigquery::reservation::v1::ListAssignmentsResponse>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_DeleteAssignment : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_DeleteAssignment() {
      ::grpc::Service::MarkMethodStreamed(14,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::cloud::bigquery::reservation::v1::DeleteAssignmentRequest, ::google::protobuf::Empty>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::cloud::bigquery::reservation::v1::DeleteAssignmentRequest, ::google::protobuf::Empty>* streamer) {
                       return this->StreamedDeleteAssignment(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_DeleteAssignment() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status DeleteAssignment(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::DeleteAssignmentRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedDeleteAssignment(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::cloud::bigquery::reservation::v1::DeleteAssignmentRequest,::google::protobuf::Empty>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_SearchAssignments : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_SearchAssignments() {
      ::grpc::Service::MarkMethodStreamed(15,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::cloud::bigquery::reservation::v1::SearchAssignmentsRequest, ::google::cloud::bigquery::reservation::v1::SearchAssignmentsResponse>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::cloud::bigquery::reservation::v1::SearchAssignmentsRequest, ::google::cloud::bigquery::reservation::v1::SearchAssignmentsResponse>* streamer) {
                       return this->StreamedSearchAssignments(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_SearchAssignments() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status SearchAssignments(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::SearchAssignmentsRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::SearchAssignmentsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedSearchAssignments(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::cloud::bigquery::reservation::v1::SearchAssignmentsRequest,::google::cloud::bigquery::reservation::v1::SearchAssignmentsResponse>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_SearchAllAssignments : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_SearchAllAssignments() {
      ::grpc::Service::MarkMethodStreamed(16,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::cloud::bigquery::reservation::v1::SearchAllAssignmentsRequest, ::google::cloud::bigquery::reservation::v1::SearchAllAssignmentsResponse>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::cloud::bigquery::reservation::v1::SearchAllAssignmentsRequest, ::google::cloud::bigquery::reservation::v1::SearchAllAssignmentsResponse>* streamer) {
                       return this->StreamedSearchAllAssignments(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_SearchAllAssignments() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status SearchAllAssignments(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::SearchAllAssignmentsRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::SearchAllAssignmentsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedSearchAllAssignments(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::cloud::bigquery::reservation::v1::SearchAllAssignmentsRequest,::google::cloud::bigquery::reservation::v1::SearchAllAssignmentsResponse>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_MoveAssignment : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_MoveAssignment() {
      ::grpc::Service::MarkMethodStreamed(17,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::cloud::bigquery::reservation::v1::MoveAssignmentRequest, ::google::cloud::bigquery::reservation::v1::Assignment>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::cloud::bigquery::reservation::v1::MoveAssignmentRequest, ::google::cloud::bigquery::reservation::v1::Assignment>* streamer) {
                       return this->StreamedMoveAssignment(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_MoveAssignment() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status MoveAssignment(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::MoveAssignmentRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::Assignment* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedMoveAssignment(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::cloud::bigquery::reservation::v1::MoveAssignmentRequest,::google::cloud::bigquery::reservation::v1::Assignment>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_UpdateAssignment : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_UpdateAssignment() {
      ::grpc::Service::MarkMethodStreamed(18,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::cloud::bigquery::reservation::v1::UpdateAssignmentRequest, ::google::cloud::bigquery::reservation::v1::Assignment>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::cloud::bigquery::reservation::v1::UpdateAssignmentRequest, ::google::cloud::bigquery::reservation::v1::Assignment>* streamer) {
                       return this->StreamedUpdateAssignment(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_UpdateAssignment() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status UpdateAssignment(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::UpdateAssignmentRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::Assignment* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedUpdateAssignment(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::cloud::bigquery::reservation::v1::UpdateAssignmentRequest,::google::cloud::bigquery::reservation::v1::Assignment>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_GetBiReservation : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_GetBiReservation() {
      ::grpc::Service::MarkMethodStreamed(19,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::cloud::bigquery::reservation::v1::GetBiReservationRequest, ::google::cloud::bigquery::reservation::v1::BiReservation>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::cloud::bigquery::reservation::v1::GetBiReservationRequest, ::google::cloud::bigquery::reservation::v1::BiReservation>* streamer) {
                       return this->StreamedGetBiReservation(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_GetBiReservation() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status GetBiReservation(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::GetBiReservationRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::BiReservation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedGetBiReservation(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::cloud::bigquery::reservation::v1::GetBiReservationRequest,::google::cloud::bigquery::reservation::v1::BiReservation>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_UpdateBiReservation : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_UpdateBiReservation() {
      ::grpc::Service::MarkMethodStreamed(20,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::cloud::bigquery::reservation::v1::UpdateBiReservationRequest, ::google::cloud::bigquery::reservation::v1::BiReservation>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::cloud::bigquery::reservation::v1::UpdateBiReservationRequest, ::google::cloud::bigquery::reservation::v1::BiReservation>* streamer) {
                       return this->StreamedUpdateBiReservation(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_UpdateBiReservation() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status UpdateBiReservation(::grpc::ServerContext* /*context*/, const ::google::cloud::bigquery::reservation::v1::UpdateBiReservationRequest* /*request*/, ::google::cloud::bigquery::reservation::v1::BiReservation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedUpdateBiReservation(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::cloud::bigquery::reservation::v1::UpdateBiReservationRequest,::google::cloud::bigquery::reservation::v1::BiReservation>* server_unary_streamer) = 0;
  };
  typedef WithStreamedUnaryMethod_CreateReservation<WithStreamedUnaryMethod_ListReservations<WithStreamedUnaryMethod_GetReservation<WithStreamedUnaryMethod_DeleteReservation<WithStreamedUnaryMethod_UpdateReservation<WithStreamedUnaryMethod_CreateCapacityCommitment<WithStreamedUnaryMethod_ListCapacityCommitments<WithStreamedUnaryMethod_GetCapacityCommitment<WithStreamedUnaryMethod_DeleteCapacityCommitment<WithStreamedUnaryMethod_UpdateCapacityCommitment<WithStreamedUnaryMethod_SplitCapacityCommitment<WithStreamedUnaryMethod_MergeCapacityCommitments<WithStreamedUnaryMethod_CreateAssignment<WithStreamedUnaryMethod_ListAssignments<WithStreamedUnaryMethod_DeleteAssignment<WithStreamedUnaryMethod_SearchAssignments<WithStreamedUnaryMethod_SearchAllAssignments<WithStreamedUnaryMethod_MoveAssignment<WithStreamedUnaryMethod_UpdateAssignment<WithStreamedUnaryMethod_GetBiReservation<WithStreamedUnaryMethod_UpdateBiReservation<Service > > > > > > > > > > > > > > > > > > > > > StreamedUnaryService;
  typedef Service SplitStreamedService;
  typedef WithStreamedUnaryMethod_CreateReservation<WithStreamedUnaryMethod_ListReservations<WithStreamedUnaryMethod_GetReservation<WithStreamedUnaryMethod_DeleteReservation<WithStreamedUnaryMethod_UpdateReservation<WithStreamedUnaryMethod_CreateCapacityCommitment<WithStreamedUnaryMethod_ListCapacityCommitments<WithStreamedUnaryMethod_GetCapacityCommitment<WithStreamedUnaryMethod_DeleteCapacityCommitment<WithStreamedUnaryMethod_UpdateCapacityCommitment<WithStreamedUnaryMethod_SplitCapacityCommitment<WithStreamedUnaryMethod_MergeCapacityCommitments<WithStreamedUnaryMethod_CreateAssignment<WithStreamedUnaryMethod_ListAssignments<WithStreamedUnaryMethod_DeleteAssignment<WithStreamedUnaryMethod_SearchAssignments<WithStreamedUnaryMethod_SearchAllAssignments<WithStreamedUnaryMethod_MoveAssignment<WithStreamedUnaryMethod_UpdateAssignment<WithStreamedUnaryMethod_GetBiReservation<WithStreamedUnaryMethod_UpdateBiReservation<Service > > > > > > > > > > > > > > > > > > > > > StreamedService;
};

}  // namespace v1
}  // namespace reservation
}  // namespace bigquery
}  // namespace cloud
}  // namespace google


#endif  // GRPC_google_2fcloud_2fbigquery_2freservation_2fv1_2freservation_2eproto__INCLUDED
