// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/bigquery/v2/model.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BIGQUERY_INTERNAL_MODEL_CONNECTION_IMPL_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BIGQUERY_INTERNAL_MODEL_CONNECTION_IMPL_H

#include "google/cloud/bigquery/internal/model_retry_traits.h"
#include "google/cloud/bigquery/internal/model_stub.h"
#include "google/cloud/bigquery/model_connection.h"
#include "google/cloud/bigquery/model_connection_idempotency_policy.h"
#include "google/cloud/bigquery/model_options.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/options.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace bigquery_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class ModelServiceConnectionImpl : public bigquery::ModelServiceConnection {
 public:
  ~ModelServiceConnectionImpl() override = default;

  ModelServiceConnectionImpl(
      std::unique_ptr<google::cloud::BackgroundThreads> background,
      std::shared_ptr<bigquery_internal::ModelServiceStub> stub,
      Options options);

  Options options() override { return options_; }

  StatusOr<google::cloud::bigquery::v2::Model> GetModel(
      google::cloud::bigquery::v2::GetModelRequest const& request) override;

  StatusOr<google::cloud::bigquery::v2::ListModelsResponse> ListModels(
      google::cloud::bigquery::v2::ListModelsRequest const& request) override;

  StatusOr<google::cloud::bigquery::v2::Model> PatchModel(
      google::cloud::bigquery::v2::PatchModelRequest const& request) override;

  Status DeleteModel(
      google::cloud::bigquery::v2::DeleteModelRequest const& request) override;

 private:
  std::unique_ptr<bigquery::ModelServiceRetryPolicy> retry_policy() {
    auto const& options = internal::CurrentOptions();
    if (options.has<bigquery::ModelServiceRetryPolicyOption>()) {
      return options.get<bigquery::ModelServiceRetryPolicyOption>()->clone();
    }
    return options_.get<bigquery::ModelServiceRetryPolicyOption>()->clone();
  }

  std::unique_ptr<BackoffPolicy> backoff_policy() {
    auto const& options = internal::CurrentOptions();
    if (options.has<bigquery::ModelServiceBackoffPolicyOption>()) {
      return options.get<bigquery::ModelServiceBackoffPolicyOption>()->clone();
    }
    return options_.get<bigquery::ModelServiceBackoffPolicyOption>()->clone();
  }

  std::unique_ptr<bigquery::ModelServiceConnectionIdempotencyPolicy>
  idempotency_policy() {
    auto const& options = internal::CurrentOptions();
    if (options
            .has<bigquery::ModelServiceConnectionIdempotencyPolicyOption>()) {
      return options
          .get<bigquery::ModelServiceConnectionIdempotencyPolicyOption>()
          ->clone();
    }
    return options_
        .get<bigquery::ModelServiceConnectionIdempotencyPolicyOption>()
        ->clone();
  }

  std::unique_ptr<google::cloud::BackgroundThreads> background_;
  std::shared_ptr<bigquery_internal::ModelServiceStub> stub_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace bigquery_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BIGQUERY_INTERNAL_MODEL_CONNECTION_IMPL_H
