// Generated by the gRPC C++ plugin.
// If you make any local change, they will be lost.
// source: google/spanner/v1/spanner.proto
// Original file comments:
// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
#ifndef GRPC_google_2fspanner_2fv1_2fspanner_2eproto__INCLUDED
#define GRPC_google_2fspanner_2fv1_2fspanner_2eproto__INCLUDED

#include "google/spanner/v1/spanner.pb.h"

#include <functional>
#include <grpcpp/impl/codegen/async_generic_service.h>
#include <grpcpp/impl/codegen/async_stream.h>
#include <grpcpp/impl/codegen/async_unary_call.h>
#include <grpcpp/impl/codegen/client_callback.h>
#include <grpcpp/impl/codegen/client_context.h>
#include <grpcpp/impl/codegen/completion_queue.h>
#include <grpcpp/impl/codegen/message_allocator.h>
#include <grpcpp/impl/codegen/method_handler.h>
#include <grpcpp/impl/codegen/proto_utils.h>
#include <grpcpp/impl/codegen/rpc_method.h>
#include <grpcpp/impl/codegen/server_callback.h>
#include <grpcpp/impl/codegen/server_callback_handlers.h>
#include <grpcpp/impl/codegen/server_context.h>
#include <grpcpp/impl/codegen/service_type.h>
#include <grpcpp/impl/codegen/status.h>
#include <grpcpp/impl/codegen/stub_options.h>
#include <grpcpp/impl/codegen/sync_stream.h>

namespace google {
namespace spanner {
namespace v1 {

// Cloud Spanner API
//
// The Cloud Spanner API can be used to manage sessions and execute
// transactions on data stored in Cloud Spanner databases.
class Spanner final {
 public:
  static constexpr char const* service_full_name() {
    return "google.spanner.v1.Spanner";
  }
  class StubInterface {
   public:
    virtual ~StubInterface() {}
    // Creates a new session. A session can be used to perform
    // transactions that read and/or modify data in a Cloud Spanner database.
    // Sessions are meant to be reused for many consecutive
    // transactions.
    //
    // Sessions can only execute one transaction at a time. To execute
    // multiple concurrent read-write/write-only transactions, create
    // multiple sessions. Note that standalone reads and queries use a
    // transaction internally, and count toward the one transaction
    // limit.
    //
    // Active sessions use additional server resources, so it is a good idea to
    // delete idle and unneeded sessions.
    // Aside from explicit deletes, Cloud Spanner may delete sessions for which no
    // operations are sent for more than an hour. If a session is deleted,
    // requests to it return `NOT_FOUND`.
    //
    // Idle sessions can be kept alive by sending a trivial SQL query
    // periodically, e.g., `"SELECT 1"`.
    virtual ::grpc::Status CreateSession(::grpc::ClientContext* context, const ::google::spanner::v1::CreateSessionRequest& request, ::google::spanner::v1::Session* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::v1::Session>> AsyncCreateSession(::grpc::ClientContext* context, const ::google::spanner::v1::CreateSessionRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::v1::Session>>(AsyncCreateSessionRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::v1::Session>> PrepareAsyncCreateSession(::grpc::ClientContext* context, const ::google::spanner::v1::CreateSessionRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::v1::Session>>(PrepareAsyncCreateSessionRaw(context, request, cq));
    }
    // Creates multiple new sessions.
    //
    // This API can be used to initialize a session cache on the clients.
    // See https://goo.gl/TgSFN2 for best practices on session cache management.
    virtual ::grpc::Status BatchCreateSessions(::grpc::ClientContext* context, const ::google::spanner::v1::BatchCreateSessionsRequest& request, ::google::spanner::v1::BatchCreateSessionsResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::v1::BatchCreateSessionsResponse>> AsyncBatchCreateSessions(::grpc::ClientContext* context, const ::google::spanner::v1::BatchCreateSessionsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::v1::BatchCreateSessionsResponse>>(AsyncBatchCreateSessionsRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::v1::BatchCreateSessionsResponse>> PrepareAsyncBatchCreateSessions(::grpc::ClientContext* context, const ::google::spanner::v1::BatchCreateSessionsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::v1::BatchCreateSessionsResponse>>(PrepareAsyncBatchCreateSessionsRaw(context, request, cq));
    }
    // Gets a session. Returns `NOT_FOUND` if the session does not exist.
    // This is mainly useful for determining whether a session is still
    // alive.
    virtual ::grpc::Status GetSession(::grpc::ClientContext* context, const ::google::spanner::v1::GetSessionRequest& request, ::google::spanner::v1::Session* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::v1::Session>> AsyncGetSession(::grpc::ClientContext* context, const ::google::spanner::v1::GetSessionRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::v1::Session>>(AsyncGetSessionRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::v1::Session>> PrepareAsyncGetSession(::grpc::ClientContext* context, const ::google::spanner::v1::GetSessionRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::v1::Session>>(PrepareAsyncGetSessionRaw(context, request, cq));
    }
    // Lists all sessions in a given database.
    virtual ::grpc::Status ListSessions(::grpc::ClientContext* context, const ::google::spanner::v1::ListSessionsRequest& request, ::google::spanner::v1::ListSessionsResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::v1::ListSessionsResponse>> AsyncListSessions(::grpc::ClientContext* context, const ::google::spanner::v1::ListSessionsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::v1::ListSessionsResponse>>(AsyncListSessionsRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::v1::ListSessionsResponse>> PrepareAsyncListSessions(::grpc::ClientContext* context, const ::google::spanner::v1::ListSessionsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::v1::ListSessionsResponse>>(PrepareAsyncListSessionsRaw(context, request, cq));
    }
    // Ends a session, releasing server resources associated with it. This will
    // asynchronously trigger cancellation of any operations that are running with
    // this session.
    virtual ::grpc::Status DeleteSession(::grpc::ClientContext* context, const ::google::spanner::v1::DeleteSessionRequest& request, ::google::protobuf::Empty* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>> AsyncDeleteSession(::grpc::ClientContext* context, const ::google::spanner::v1::DeleteSessionRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>>(AsyncDeleteSessionRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>> PrepareAsyncDeleteSession(::grpc::ClientContext* context, const ::google::spanner::v1::DeleteSessionRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>>(PrepareAsyncDeleteSessionRaw(context, request, cq));
    }
    // Executes an SQL statement, returning all results in a single reply. This
    // method cannot be used to return a result set larger than 10 MiB;
    // if the query yields more data than that, the query fails with
    // a `FAILED_PRECONDITION` error.
    //
    // Operations inside read-write transactions might return `ABORTED`. If
    // this occurs, the application should restart the transaction from
    // the beginning. See [Transaction][google.spanner.v1.Transaction] for more details.
    //
    // Larger result sets can be fetched in streaming fashion by calling
    // [ExecuteStreamingSql][google.spanner.v1.Spanner.ExecuteStreamingSql] instead.
    virtual ::grpc::Status ExecuteSql(::grpc::ClientContext* context, const ::google::spanner::v1::ExecuteSqlRequest& request, ::google::spanner::v1::ResultSet* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::v1::ResultSet>> AsyncExecuteSql(::grpc::ClientContext* context, const ::google::spanner::v1::ExecuteSqlRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::v1::ResultSet>>(AsyncExecuteSqlRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::v1::ResultSet>> PrepareAsyncExecuteSql(::grpc::ClientContext* context, const ::google::spanner::v1::ExecuteSqlRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::v1::ResultSet>>(PrepareAsyncExecuteSqlRaw(context, request, cq));
    }
    // Like [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql], except returns the result
    // set as a stream. Unlike [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql], there
    // is no limit on the size of the returned result set. However, no
    // individual row in the result set can exceed 100 MiB, and no
    // column value can exceed 10 MiB.
    std::unique_ptr< ::grpc::ClientReaderInterface< ::google::spanner::v1::PartialResultSet>> ExecuteStreamingSql(::grpc::ClientContext* context, const ::google::spanner::v1::ExecuteSqlRequest& request) {
      return std::unique_ptr< ::grpc::ClientReaderInterface< ::google::spanner::v1::PartialResultSet>>(ExecuteStreamingSqlRaw(context, request));
    }
    std::unique_ptr< ::grpc::ClientAsyncReaderInterface< ::google::spanner::v1::PartialResultSet>> AsyncExecuteStreamingSql(::grpc::ClientContext* context, const ::google::spanner::v1::ExecuteSqlRequest& request, ::grpc::CompletionQueue* cq, void* tag) {
      return std::unique_ptr< ::grpc::ClientAsyncReaderInterface< ::google::spanner::v1::PartialResultSet>>(AsyncExecuteStreamingSqlRaw(context, request, cq, tag));
    }
    std::unique_ptr< ::grpc::ClientAsyncReaderInterface< ::google::spanner::v1::PartialResultSet>> PrepareAsyncExecuteStreamingSql(::grpc::ClientContext* context, const ::google::spanner::v1::ExecuteSqlRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncReaderInterface< ::google::spanner::v1::PartialResultSet>>(PrepareAsyncExecuteStreamingSqlRaw(context, request, cq));
    }
    // Executes a batch of SQL DML statements. This method allows many statements
    // to be run with lower latency than submitting them sequentially with
    // [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql].
    //
    // Statements are executed in sequential order. A request can succeed even if
    // a statement fails. The [ExecuteBatchDmlResponse.status][google.spanner.v1.ExecuteBatchDmlResponse.status] field in the
    // response provides information about the statement that failed. Clients must
    // inspect this field to determine whether an error occurred.
    //
    // Execution stops after the first failed statement; the remaining statements
    // are not executed.
    virtual ::grpc::Status ExecuteBatchDml(::grpc::ClientContext* context, const ::google::spanner::v1::ExecuteBatchDmlRequest& request, ::google::spanner::v1::ExecuteBatchDmlResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::v1::ExecuteBatchDmlResponse>> AsyncExecuteBatchDml(::grpc::ClientContext* context, const ::google::spanner::v1::ExecuteBatchDmlRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::v1::ExecuteBatchDmlResponse>>(AsyncExecuteBatchDmlRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::v1::ExecuteBatchDmlResponse>> PrepareAsyncExecuteBatchDml(::grpc::ClientContext* context, const ::google::spanner::v1::ExecuteBatchDmlRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::v1::ExecuteBatchDmlResponse>>(PrepareAsyncExecuteBatchDmlRaw(context, request, cq));
    }
    // Reads rows from the database using key lookups and scans, as a
    // simple key/value style alternative to
    // [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql].  This method cannot be used to
    // return a result set larger than 10 MiB; if the read matches more
    // data than that, the read fails with a `FAILED_PRECONDITION`
    // error.
    //
    // Reads inside read-write transactions might return `ABORTED`. If
    // this occurs, the application should restart the transaction from
    // the beginning. See [Transaction][google.spanner.v1.Transaction] for more details.
    //
    // Larger result sets can be yielded in streaming fashion by calling
    // [StreamingRead][google.spanner.v1.Spanner.StreamingRead] instead.
    virtual ::grpc::Status Read(::grpc::ClientContext* context, const ::google::spanner::v1::ReadRequest& request, ::google::spanner::v1::ResultSet* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::v1::ResultSet>> AsyncRead(::grpc::ClientContext* context, const ::google::spanner::v1::ReadRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::v1::ResultSet>>(AsyncReadRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::v1::ResultSet>> PrepareAsyncRead(::grpc::ClientContext* context, const ::google::spanner::v1::ReadRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::v1::ResultSet>>(PrepareAsyncReadRaw(context, request, cq));
    }
    // Like [Read][google.spanner.v1.Spanner.Read], except returns the result set as a
    // stream. Unlike [Read][google.spanner.v1.Spanner.Read], there is no limit on the
    // size of the returned result set. However, no individual row in
    // the result set can exceed 100 MiB, and no column value can exceed
    // 10 MiB.
    std::unique_ptr< ::grpc::ClientReaderInterface< ::google::spanner::v1::PartialResultSet>> StreamingRead(::grpc::ClientContext* context, const ::google::spanner::v1::ReadRequest& request) {
      return std::unique_ptr< ::grpc::ClientReaderInterface< ::google::spanner::v1::PartialResultSet>>(StreamingReadRaw(context, request));
    }
    std::unique_ptr< ::grpc::ClientAsyncReaderInterface< ::google::spanner::v1::PartialResultSet>> AsyncStreamingRead(::grpc::ClientContext* context, const ::google::spanner::v1::ReadRequest& request, ::grpc::CompletionQueue* cq, void* tag) {
      return std::unique_ptr< ::grpc::ClientAsyncReaderInterface< ::google::spanner::v1::PartialResultSet>>(AsyncStreamingReadRaw(context, request, cq, tag));
    }
    std::unique_ptr< ::grpc::ClientAsyncReaderInterface< ::google::spanner::v1::PartialResultSet>> PrepareAsyncStreamingRead(::grpc::ClientContext* context, const ::google::spanner::v1::ReadRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncReaderInterface< ::google::spanner::v1::PartialResultSet>>(PrepareAsyncStreamingReadRaw(context, request, cq));
    }
    // Begins a new transaction. This step can often be skipped:
    // [Read][google.spanner.v1.Spanner.Read], [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql] and
    // [Commit][google.spanner.v1.Spanner.Commit] can begin a new transaction as a
    // side-effect.
    virtual ::grpc::Status BeginTransaction(::grpc::ClientContext* context, const ::google::spanner::v1::BeginTransactionRequest& request, ::google::spanner::v1::Transaction* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::v1::Transaction>> AsyncBeginTransaction(::grpc::ClientContext* context, const ::google::spanner::v1::BeginTransactionRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::v1::Transaction>>(AsyncBeginTransactionRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::v1::Transaction>> PrepareAsyncBeginTransaction(::grpc::ClientContext* context, const ::google::spanner::v1::BeginTransactionRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::v1::Transaction>>(PrepareAsyncBeginTransactionRaw(context, request, cq));
    }
    // Commits a transaction. The request includes the mutations to be
    // applied to rows in the database.
    //
    // `Commit` might return an `ABORTED` error. This can occur at any time;
    // commonly, the cause is conflicts with concurrent
    // transactions. However, it can also happen for a variety of other
    // reasons. If `Commit` returns `ABORTED`, the caller should re-attempt
    // the transaction from the beginning, re-using the same session.
    //
    // On very rare occasions, `Commit` might return `UNKNOWN`. This can happen,
    // for example, if the client job experiences a 1+ hour networking failure.
    // At that point, Cloud Spanner has lost track of the transaction outcome and
    // we recommend that you perform another read from the database to see the
    // state of things as they are now.
    virtual ::grpc::Status Commit(::grpc::ClientContext* context, const ::google::spanner::v1::CommitRequest& request, ::google::spanner::v1::CommitResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::v1::CommitResponse>> AsyncCommit(::grpc::ClientContext* context, const ::google::spanner::v1::CommitRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::v1::CommitResponse>>(AsyncCommitRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::v1::CommitResponse>> PrepareAsyncCommit(::grpc::ClientContext* context, const ::google::spanner::v1::CommitRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::v1::CommitResponse>>(PrepareAsyncCommitRaw(context, request, cq));
    }
    // Rolls back a transaction, releasing any locks it holds. It is a good
    // idea to call this for any transaction that includes one or more
    // [Read][google.spanner.v1.Spanner.Read] or [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql] requests and
    // ultimately decides not to commit.
    //
    // `Rollback` returns `OK` if it successfully aborts the transaction, the
    // transaction was already aborted, or the transaction is not
    // found. `Rollback` never returns `ABORTED`.
    virtual ::grpc::Status Rollback(::grpc::ClientContext* context, const ::google::spanner::v1::RollbackRequest& request, ::google::protobuf::Empty* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>> AsyncRollback(::grpc::ClientContext* context, const ::google::spanner::v1::RollbackRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>>(AsyncRollbackRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>> PrepareAsyncRollback(::grpc::ClientContext* context, const ::google::spanner::v1::RollbackRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>>(PrepareAsyncRollbackRaw(context, request, cq));
    }
    // Creates a set of partition tokens that can be used to execute a query
    // operation in parallel.  Each of the returned partition tokens can be used
    // by [ExecuteStreamingSql][google.spanner.v1.Spanner.ExecuteStreamingSql] to specify a subset
    // of the query result to read.  The same session and read-only transaction
    // must be used by the PartitionQueryRequest used to create the
    // partition tokens and the ExecuteSqlRequests that use the partition tokens.
    //
    // Partition tokens become invalid when the session used to create them
    // is deleted, is idle for too long, begins a new transaction, or becomes too
    // old.  When any of these happen, it is not possible to resume the query, and
    // the whole operation must be restarted from the beginning.
    virtual ::grpc::Status PartitionQuery(::grpc::ClientContext* context, const ::google::spanner::v1::PartitionQueryRequest& request, ::google::spanner::v1::PartitionResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::v1::PartitionResponse>> AsyncPartitionQuery(::grpc::ClientContext* context, const ::google::spanner::v1::PartitionQueryRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::v1::PartitionResponse>>(AsyncPartitionQueryRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::v1::PartitionResponse>> PrepareAsyncPartitionQuery(::grpc::ClientContext* context, const ::google::spanner::v1::PartitionQueryRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::v1::PartitionResponse>>(PrepareAsyncPartitionQueryRaw(context, request, cq));
    }
    // Creates a set of partition tokens that can be used to execute a read
    // operation in parallel.  Each of the returned partition tokens can be used
    // by [StreamingRead][google.spanner.v1.Spanner.StreamingRead] to specify a subset of the read
    // result to read.  The same session and read-only transaction must be used by
    // the PartitionReadRequest used to create the partition tokens and the
    // ReadRequests that use the partition tokens.  There are no ordering
    // guarantees on rows returned among the returned partition tokens, or even
    // within each individual StreamingRead call issued with a partition_token.
    //
    // Partition tokens become invalid when the session used to create them
    // is deleted, is idle for too long, begins a new transaction, or becomes too
    // old.  When any of these happen, it is not possible to resume the read, and
    // the whole operation must be restarted from the beginning.
    virtual ::grpc::Status PartitionRead(::grpc::ClientContext* context, const ::google::spanner::v1::PartitionReadRequest& request, ::google::spanner::v1::PartitionResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::v1::PartitionResponse>> AsyncPartitionRead(::grpc::ClientContext* context, const ::google::spanner::v1::PartitionReadRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::v1::PartitionResponse>>(AsyncPartitionReadRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::v1::PartitionResponse>> PrepareAsyncPartitionRead(::grpc::ClientContext* context, const ::google::spanner::v1::PartitionReadRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::v1::PartitionResponse>>(PrepareAsyncPartitionReadRaw(context, request, cq));
    }
    class async_interface {
     public:
      virtual ~async_interface() {}
      // Creates a new session. A session can be used to perform
      // transactions that read and/or modify data in a Cloud Spanner database.
      // Sessions are meant to be reused for many consecutive
      // transactions.
      //
      // Sessions can only execute one transaction at a time. To execute
      // multiple concurrent read-write/write-only transactions, create
      // multiple sessions. Note that standalone reads and queries use a
      // transaction internally, and count toward the one transaction
      // limit.
      //
      // Active sessions use additional server resources, so it is a good idea to
      // delete idle and unneeded sessions.
      // Aside from explicit deletes, Cloud Spanner may delete sessions for which no
      // operations are sent for more than an hour. If a session is deleted,
      // requests to it return `NOT_FOUND`.
      //
      // Idle sessions can be kept alive by sending a trivial SQL query
      // periodically, e.g., `"SELECT 1"`.
      virtual void CreateSession(::grpc::ClientContext* context, const ::google::spanner::v1::CreateSessionRequest* request, ::google::spanner::v1::Session* response, std::function<void(::grpc::Status)>) = 0;
      virtual void CreateSession(::grpc::ClientContext* context, const ::google::spanner::v1::CreateSessionRequest* request, ::google::spanner::v1::Session* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Creates multiple new sessions.
      //
      // This API can be used to initialize a session cache on the clients.
      // See https://goo.gl/TgSFN2 for best practices on session cache management.
      virtual void BatchCreateSessions(::grpc::ClientContext* context, const ::google::spanner::v1::BatchCreateSessionsRequest* request, ::google::spanner::v1::BatchCreateSessionsResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void BatchCreateSessions(::grpc::ClientContext* context, const ::google::spanner::v1::BatchCreateSessionsRequest* request, ::google::spanner::v1::BatchCreateSessionsResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Gets a session. Returns `NOT_FOUND` if the session does not exist.
      // This is mainly useful for determining whether a session is still
      // alive.
      virtual void GetSession(::grpc::ClientContext* context, const ::google::spanner::v1::GetSessionRequest* request, ::google::spanner::v1::Session* response, std::function<void(::grpc::Status)>) = 0;
      virtual void GetSession(::grpc::ClientContext* context, const ::google::spanner::v1::GetSessionRequest* request, ::google::spanner::v1::Session* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Lists all sessions in a given database.
      virtual void ListSessions(::grpc::ClientContext* context, const ::google::spanner::v1::ListSessionsRequest* request, ::google::spanner::v1::ListSessionsResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void ListSessions(::grpc::ClientContext* context, const ::google::spanner::v1::ListSessionsRequest* request, ::google::spanner::v1::ListSessionsResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Ends a session, releasing server resources associated with it. This will
      // asynchronously trigger cancellation of any operations that are running with
      // this session.
      virtual void DeleteSession(::grpc::ClientContext* context, const ::google::spanner::v1::DeleteSessionRequest* request, ::google::protobuf::Empty* response, std::function<void(::grpc::Status)>) = 0;
      virtual void DeleteSession(::grpc::ClientContext* context, const ::google::spanner::v1::DeleteSessionRequest* request, ::google::protobuf::Empty* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Executes an SQL statement, returning all results in a single reply. This
      // method cannot be used to return a result set larger than 10 MiB;
      // if the query yields more data than that, the query fails with
      // a `FAILED_PRECONDITION` error.
      //
      // Operations inside read-write transactions might return `ABORTED`. If
      // this occurs, the application should restart the transaction from
      // the beginning. See [Transaction][google.spanner.v1.Transaction] for more details.
      //
      // Larger result sets can be fetched in streaming fashion by calling
      // [ExecuteStreamingSql][google.spanner.v1.Spanner.ExecuteStreamingSql] instead.
      virtual void ExecuteSql(::grpc::ClientContext* context, const ::google::spanner::v1::ExecuteSqlRequest* request, ::google::spanner::v1::ResultSet* response, std::function<void(::grpc::Status)>) = 0;
      virtual void ExecuteSql(::grpc::ClientContext* context, const ::google::spanner::v1::ExecuteSqlRequest* request, ::google::spanner::v1::ResultSet* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Like [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql], except returns the result
      // set as a stream. Unlike [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql], there
      // is no limit on the size of the returned result set. However, no
      // individual row in the result set can exceed 100 MiB, and no
      // column value can exceed 10 MiB.
      virtual void ExecuteStreamingSql(::grpc::ClientContext* context, const ::google::spanner::v1::ExecuteSqlRequest* request, ::grpc::ClientReadReactor< ::google::spanner::v1::PartialResultSet>* reactor) = 0;
      // Executes a batch of SQL DML statements. This method allows many statements
      // to be run with lower latency than submitting them sequentially with
      // [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql].
      //
      // Statements are executed in sequential order. A request can succeed even if
      // a statement fails. The [ExecuteBatchDmlResponse.status][google.spanner.v1.ExecuteBatchDmlResponse.status] field in the
      // response provides information about the statement that failed. Clients must
      // inspect this field to determine whether an error occurred.
      //
      // Execution stops after the first failed statement; the remaining statements
      // are not executed.
      virtual void ExecuteBatchDml(::grpc::ClientContext* context, const ::google::spanner::v1::ExecuteBatchDmlRequest* request, ::google::spanner::v1::ExecuteBatchDmlResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void ExecuteBatchDml(::grpc::ClientContext* context, const ::google::spanner::v1::ExecuteBatchDmlRequest* request, ::google::spanner::v1::ExecuteBatchDmlResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Reads rows from the database using key lookups and scans, as a
      // simple key/value style alternative to
      // [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql].  This method cannot be used to
      // return a result set larger than 10 MiB; if the read matches more
      // data than that, the read fails with a `FAILED_PRECONDITION`
      // error.
      //
      // Reads inside read-write transactions might return `ABORTED`. If
      // this occurs, the application should restart the transaction from
      // the beginning. See [Transaction][google.spanner.v1.Transaction] for more details.
      //
      // Larger result sets can be yielded in streaming fashion by calling
      // [StreamingRead][google.spanner.v1.Spanner.StreamingRead] instead.
      virtual void Read(::grpc::ClientContext* context, const ::google::spanner::v1::ReadRequest* request, ::google::spanner::v1::ResultSet* response, std::function<void(::grpc::Status)>) = 0;
      virtual void Read(::grpc::ClientContext* context, const ::google::spanner::v1::ReadRequest* request, ::google::spanner::v1::ResultSet* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Like [Read][google.spanner.v1.Spanner.Read], except returns the result set as a
      // stream. Unlike [Read][google.spanner.v1.Spanner.Read], there is no limit on the
      // size of the returned result set. However, no individual row in
      // the result set can exceed 100 MiB, and no column value can exceed
      // 10 MiB.
      virtual void StreamingRead(::grpc::ClientContext* context, const ::google::spanner::v1::ReadRequest* request, ::grpc::ClientReadReactor< ::google::spanner::v1::PartialResultSet>* reactor) = 0;
      // Begins a new transaction. This step can often be skipped:
      // [Read][google.spanner.v1.Spanner.Read], [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql] and
      // [Commit][google.spanner.v1.Spanner.Commit] can begin a new transaction as a
      // side-effect.
      virtual void BeginTransaction(::grpc::ClientContext* context, const ::google::spanner::v1::BeginTransactionRequest* request, ::google::spanner::v1::Transaction* response, std::function<void(::grpc::Status)>) = 0;
      virtual void BeginTransaction(::grpc::ClientContext* context, const ::google::spanner::v1::BeginTransactionRequest* request, ::google::spanner::v1::Transaction* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Commits a transaction. The request includes the mutations to be
      // applied to rows in the database.
      //
      // `Commit` might return an `ABORTED` error. This can occur at any time;
      // commonly, the cause is conflicts with concurrent
      // transactions. However, it can also happen for a variety of other
      // reasons. If `Commit` returns `ABORTED`, the caller should re-attempt
      // the transaction from the beginning, re-using the same session.
      //
      // On very rare occasions, `Commit` might return `UNKNOWN`. This can happen,
      // for example, if the client job experiences a 1+ hour networking failure.
      // At that point, Cloud Spanner has lost track of the transaction outcome and
      // we recommend that you perform another read from the database to see the
      // state of things as they are now.
      virtual void Commit(::grpc::ClientContext* context, const ::google::spanner::v1::CommitRequest* request, ::google::spanner::v1::CommitResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void Commit(::grpc::ClientContext* context, const ::google::spanner::v1::CommitRequest* request, ::google::spanner::v1::CommitResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Rolls back a transaction, releasing any locks it holds. It is a good
      // idea to call this for any transaction that includes one or more
      // [Read][google.spanner.v1.Spanner.Read] or [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql] requests and
      // ultimately decides not to commit.
      //
      // `Rollback` returns `OK` if it successfully aborts the transaction, the
      // transaction was already aborted, or the transaction is not
      // found. `Rollback` never returns `ABORTED`.
      virtual void Rollback(::grpc::ClientContext* context, const ::google::spanner::v1::RollbackRequest* request, ::google::protobuf::Empty* response, std::function<void(::grpc::Status)>) = 0;
      virtual void Rollback(::grpc::ClientContext* context, const ::google::spanner::v1::RollbackRequest* request, ::google::protobuf::Empty* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Creates a set of partition tokens that can be used to execute a query
      // operation in parallel.  Each of the returned partition tokens can be used
      // by [ExecuteStreamingSql][google.spanner.v1.Spanner.ExecuteStreamingSql] to specify a subset
      // of the query result to read.  The same session and read-only transaction
      // must be used by the PartitionQueryRequest used to create the
      // partition tokens and the ExecuteSqlRequests that use the partition tokens.
      //
      // Partition tokens become invalid when the session used to create them
      // is deleted, is idle for too long, begins a new transaction, or becomes too
      // old.  When any of these happen, it is not possible to resume the query, and
      // the whole operation must be restarted from the beginning.
      virtual void PartitionQuery(::grpc::ClientContext* context, const ::google::spanner::v1::PartitionQueryRequest* request, ::google::spanner::v1::PartitionResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void PartitionQuery(::grpc::ClientContext* context, const ::google::spanner::v1::PartitionQueryRequest* request, ::google::spanner::v1::PartitionResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Creates a set of partition tokens that can be used to execute a read
      // operation in parallel.  Each of the returned partition tokens can be used
      // by [StreamingRead][google.spanner.v1.Spanner.StreamingRead] to specify a subset of the read
      // result to read.  The same session and read-only transaction must be used by
      // the PartitionReadRequest used to create the partition tokens and the
      // ReadRequests that use the partition tokens.  There are no ordering
      // guarantees on rows returned among the returned partition tokens, or even
      // within each individual StreamingRead call issued with a partition_token.
      //
      // Partition tokens become invalid when the session used to create them
      // is deleted, is idle for too long, begins a new transaction, or becomes too
      // old.  When any of these happen, it is not possible to resume the read, and
      // the whole operation must be restarted from the beginning.
      virtual void PartitionRead(::grpc::ClientContext* context, const ::google::spanner::v1::PartitionReadRequest* request, ::google::spanner::v1::PartitionResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void PartitionRead(::grpc::ClientContext* context, const ::google::spanner::v1::PartitionReadRequest* request, ::google::spanner::v1::PartitionResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
    };
    typedef class async_interface experimental_async_interface;
    virtual class async_interface* async() { return nullptr; }
    class async_interface* experimental_async() { return async(); }
   private:
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::v1::Session>* AsyncCreateSessionRaw(::grpc::ClientContext* context, const ::google::spanner::v1::CreateSessionRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::v1::Session>* PrepareAsyncCreateSessionRaw(::grpc::ClientContext* context, const ::google::spanner::v1::CreateSessionRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::v1::BatchCreateSessionsResponse>* AsyncBatchCreateSessionsRaw(::grpc::ClientContext* context, const ::google::spanner::v1::BatchCreateSessionsRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::v1::BatchCreateSessionsResponse>* PrepareAsyncBatchCreateSessionsRaw(::grpc::ClientContext* context, const ::google::spanner::v1::BatchCreateSessionsRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::v1::Session>* AsyncGetSessionRaw(::grpc::ClientContext* context, const ::google::spanner::v1::GetSessionRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::v1::Session>* PrepareAsyncGetSessionRaw(::grpc::ClientContext* context, const ::google::spanner::v1::GetSessionRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::v1::ListSessionsResponse>* AsyncListSessionsRaw(::grpc::ClientContext* context, const ::google::spanner::v1::ListSessionsRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::v1::ListSessionsResponse>* PrepareAsyncListSessionsRaw(::grpc::ClientContext* context, const ::google::spanner::v1::ListSessionsRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>* AsyncDeleteSessionRaw(::grpc::ClientContext* context, const ::google::spanner::v1::DeleteSessionRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>* PrepareAsyncDeleteSessionRaw(::grpc::ClientContext* context, const ::google::spanner::v1::DeleteSessionRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::v1::ResultSet>* AsyncExecuteSqlRaw(::grpc::ClientContext* context, const ::google::spanner::v1::ExecuteSqlRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::v1::ResultSet>* PrepareAsyncExecuteSqlRaw(::grpc::ClientContext* context, const ::google::spanner::v1::ExecuteSqlRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientReaderInterface< ::google::spanner::v1::PartialResultSet>* ExecuteStreamingSqlRaw(::grpc::ClientContext* context, const ::google::spanner::v1::ExecuteSqlRequest& request) = 0;
    virtual ::grpc::ClientAsyncReaderInterface< ::google::spanner::v1::PartialResultSet>* AsyncExecuteStreamingSqlRaw(::grpc::ClientContext* context, const ::google::spanner::v1::ExecuteSqlRequest& request, ::grpc::CompletionQueue* cq, void* tag) = 0;
    virtual ::grpc::ClientAsyncReaderInterface< ::google::spanner::v1::PartialResultSet>* PrepareAsyncExecuteStreamingSqlRaw(::grpc::ClientContext* context, const ::google::spanner::v1::ExecuteSqlRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::v1::ExecuteBatchDmlResponse>* AsyncExecuteBatchDmlRaw(::grpc::ClientContext* context, const ::google::spanner::v1::ExecuteBatchDmlRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::v1::ExecuteBatchDmlResponse>* PrepareAsyncExecuteBatchDmlRaw(::grpc::ClientContext* context, const ::google::spanner::v1::ExecuteBatchDmlRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::v1::ResultSet>* AsyncReadRaw(::grpc::ClientContext* context, const ::google::spanner::v1::ReadRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::v1::ResultSet>* PrepareAsyncReadRaw(::grpc::ClientContext* context, const ::google::spanner::v1::ReadRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientReaderInterface< ::google::spanner::v1::PartialResultSet>* StreamingReadRaw(::grpc::ClientContext* context, const ::google::spanner::v1::ReadRequest& request) = 0;
    virtual ::grpc::ClientAsyncReaderInterface< ::google::spanner::v1::PartialResultSet>* AsyncStreamingReadRaw(::grpc::ClientContext* context, const ::google::spanner::v1::ReadRequest& request, ::grpc::CompletionQueue* cq, void* tag) = 0;
    virtual ::grpc::ClientAsyncReaderInterface< ::google::spanner::v1::PartialResultSet>* PrepareAsyncStreamingReadRaw(::grpc::ClientContext* context, const ::google::spanner::v1::ReadRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::v1::Transaction>* AsyncBeginTransactionRaw(::grpc::ClientContext* context, const ::google::spanner::v1::BeginTransactionRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::v1::Transaction>* PrepareAsyncBeginTransactionRaw(::grpc::ClientContext* context, const ::google::spanner::v1::BeginTransactionRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::v1::CommitResponse>* AsyncCommitRaw(::grpc::ClientContext* context, const ::google::spanner::v1::CommitRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::v1::CommitResponse>* PrepareAsyncCommitRaw(::grpc::ClientContext* context, const ::google::spanner::v1::CommitRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>* AsyncRollbackRaw(::grpc::ClientContext* context, const ::google::spanner::v1::RollbackRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>* PrepareAsyncRollbackRaw(::grpc::ClientContext* context, const ::google::spanner::v1::RollbackRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::v1::PartitionResponse>* AsyncPartitionQueryRaw(::grpc::ClientContext* context, const ::google::spanner::v1::PartitionQueryRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::v1::PartitionResponse>* PrepareAsyncPartitionQueryRaw(::grpc::ClientContext* context, const ::google::spanner::v1::PartitionQueryRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::v1::PartitionResponse>* AsyncPartitionReadRaw(::grpc::ClientContext* context, const ::google::spanner::v1::PartitionReadRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::v1::PartitionResponse>* PrepareAsyncPartitionReadRaw(::grpc::ClientContext* context, const ::google::spanner::v1::PartitionReadRequest& request, ::grpc::CompletionQueue* cq) = 0;
  };
  class Stub final : public StubInterface {
   public:
    Stub(const std::shared_ptr< ::grpc::ChannelInterface>& channel, const ::grpc::StubOptions& options = ::grpc::StubOptions());
    ::grpc::Status CreateSession(::grpc::ClientContext* context, const ::google::spanner::v1::CreateSessionRequest& request, ::google::spanner::v1::Session* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::spanner::v1::Session>> AsyncCreateSession(::grpc::ClientContext* context, const ::google::spanner::v1::CreateSessionRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::spanner::v1::Session>>(AsyncCreateSessionRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::spanner::v1::Session>> PrepareAsyncCreateSession(::grpc::ClientContext* context, const ::google::spanner::v1::CreateSessionRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::spanner::v1::Session>>(PrepareAsyncCreateSessionRaw(context, request, cq));
    }
    ::grpc::Status BatchCreateSessions(::grpc::ClientContext* context, const ::google::spanner::v1::BatchCreateSessionsRequest& request, ::google::spanner::v1::BatchCreateSessionsResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::spanner::v1::BatchCreateSessionsResponse>> AsyncBatchCreateSessions(::grpc::ClientContext* context, const ::google::spanner::v1::BatchCreateSessionsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::spanner::v1::BatchCreateSessionsResponse>>(AsyncBatchCreateSessionsRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::spanner::v1::BatchCreateSessionsResponse>> PrepareAsyncBatchCreateSessions(::grpc::ClientContext* context, const ::google::spanner::v1::BatchCreateSessionsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::spanner::v1::BatchCreateSessionsResponse>>(PrepareAsyncBatchCreateSessionsRaw(context, request, cq));
    }
    ::grpc::Status GetSession(::grpc::ClientContext* context, const ::google::spanner::v1::GetSessionRequest& request, ::google::spanner::v1::Session* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::spanner::v1::Session>> AsyncGetSession(::grpc::ClientContext* context, const ::google::spanner::v1::GetSessionRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::spanner::v1::Session>>(AsyncGetSessionRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::spanner::v1::Session>> PrepareAsyncGetSession(::grpc::ClientContext* context, const ::google::spanner::v1::GetSessionRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::spanner::v1::Session>>(PrepareAsyncGetSessionRaw(context, request, cq));
    }
    ::grpc::Status ListSessions(::grpc::ClientContext* context, const ::google::spanner::v1::ListSessionsRequest& request, ::google::spanner::v1::ListSessionsResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::spanner::v1::ListSessionsResponse>> AsyncListSessions(::grpc::ClientContext* context, const ::google::spanner::v1::ListSessionsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::spanner::v1::ListSessionsResponse>>(AsyncListSessionsRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::spanner::v1::ListSessionsResponse>> PrepareAsyncListSessions(::grpc::ClientContext* context, const ::google::spanner::v1::ListSessionsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::spanner::v1::ListSessionsResponse>>(PrepareAsyncListSessionsRaw(context, request, cq));
    }
    ::grpc::Status DeleteSession(::grpc::ClientContext* context, const ::google::spanner::v1::DeleteSessionRequest& request, ::google::protobuf::Empty* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>> AsyncDeleteSession(::grpc::ClientContext* context, const ::google::spanner::v1::DeleteSessionRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>>(AsyncDeleteSessionRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>> PrepareAsyncDeleteSession(::grpc::ClientContext* context, const ::google::spanner::v1::DeleteSessionRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>>(PrepareAsyncDeleteSessionRaw(context, request, cq));
    }
    ::grpc::Status ExecuteSql(::grpc::ClientContext* context, const ::google::spanner::v1::ExecuteSqlRequest& request, ::google::spanner::v1::ResultSet* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::spanner::v1::ResultSet>> AsyncExecuteSql(::grpc::ClientContext* context, const ::google::spanner::v1::ExecuteSqlRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::spanner::v1::ResultSet>>(AsyncExecuteSqlRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::spanner::v1::ResultSet>> PrepareAsyncExecuteSql(::grpc::ClientContext* context, const ::google::spanner::v1::ExecuteSqlRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::spanner::v1::ResultSet>>(PrepareAsyncExecuteSqlRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientReader< ::google::spanner::v1::PartialResultSet>> ExecuteStreamingSql(::grpc::ClientContext* context, const ::google::spanner::v1::ExecuteSqlRequest& request) {
      return std::unique_ptr< ::grpc::ClientReader< ::google::spanner::v1::PartialResultSet>>(ExecuteStreamingSqlRaw(context, request));
    }
    std::unique_ptr< ::grpc::ClientAsyncReader< ::google::spanner::v1::PartialResultSet>> AsyncExecuteStreamingSql(::grpc::ClientContext* context, const ::google::spanner::v1::ExecuteSqlRequest& request, ::grpc::CompletionQueue* cq, void* tag) {
      return std::unique_ptr< ::grpc::ClientAsyncReader< ::google::spanner::v1::PartialResultSet>>(AsyncExecuteStreamingSqlRaw(context, request, cq, tag));
    }
    std::unique_ptr< ::grpc::ClientAsyncReader< ::google::spanner::v1::PartialResultSet>> PrepareAsyncExecuteStreamingSql(::grpc::ClientContext* context, const ::google::spanner::v1::ExecuteSqlRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncReader< ::google::spanner::v1::PartialResultSet>>(PrepareAsyncExecuteStreamingSqlRaw(context, request, cq));
    }
    ::grpc::Status ExecuteBatchDml(::grpc::ClientContext* context, const ::google::spanner::v1::ExecuteBatchDmlRequest& request, ::google::spanner::v1::ExecuteBatchDmlResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::spanner::v1::ExecuteBatchDmlResponse>> AsyncExecuteBatchDml(::grpc::ClientContext* context, const ::google::spanner::v1::ExecuteBatchDmlRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::spanner::v1::ExecuteBatchDmlResponse>>(AsyncExecuteBatchDmlRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::spanner::v1::ExecuteBatchDmlResponse>> PrepareAsyncExecuteBatchDml(::grpc::ClientContext* context, const ::google::spanner::v1::ExecuteBatchDmlRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::spanner::v1::ExecuteBatchDmlResponse>>(PrepareAsyncExecuteBatchDmlRaw(context, request, cq));
    }
    ::grpc::Status Read(::grpc::ClientContext* context, const ::google::spanner::v1::ReadRequest& request, ::google::spanner::v1::ResultSet* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::spanner::v1::ResultSet>> AsyncRead(::grpc::ClientContext* context, const ::google::spanner::v1::ReadRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::spanner::v1::ResultSet>>(AsyncReadRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::spanner::v1::ResultSet>> PrepareAsyncRead(::grpc::ClientContext* context, const ::google::spanner::v1::ReadRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::spanner::v1::ResultSet>>(PrepareAsyncReadRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientReader< ::google::spanner::v1::PartialResultSet>> StreamingRead(::grpc::ClientContext* context, const ::google::spanner::v1::ReadRequest& request) {
      return std::unique_ptr< ::grpc::ClientReader< ::google::spanner::v1::PartialResultSet>>(StreamingReadRaw(context, request));
    }
    std::unique_ptr< ::grpc::ClientAsyncReader< ::google::spanner::v1::PartialResultSet>> AsyncStreamingRead(::grpc::ClientContext* context, const ::google::spanner::v1::ReadRequest& request, ::grpc::CompletionQueue* cq, void* tag) {
      return std::unique_ptr< ::grpc::ClientAsyncReader< ::google::spanner::v1::PartialResultSet>>(AsyncStreamingReadRaw(context, request, cq, tag));
    }
    std::unique_ptr< ::grpc::ClientAsyncReader< ::google::spanner::v1::PartialResultSet>> PrepareAsyncStreamingRead(::grpc::ClientContext* context, const ::google::spanner::v1::ReadRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncReader< ::google::spanner::v1::PartialResultSet>>(PrepareAsyncStreamingReadRaw(context, request, cq));
    }
    ::grpc::Status BeginTransaction(::grpc::ClientContext* context, const ::google::spanner::v1::BeginTransactionRequest& request, ::google::spanner::v1::Transaction* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::spanner::v1::Transaction>> AsyncBeginTransaction(::grpc::ClientContext* context, const ::google::spanner::v1::BeginTransactionRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::spanner::v1::Transaction>>(AsyncBeginTransactionRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::spanner::v1::Transaction>> PrepareAsyncBeginTransaction(::grpc::ClientContext* context, const ::google::spanner::v1::BeginTransactionRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::spanner::v1::Transaction>>(PrepareAsyncBeginTransactionRaw(context, request, cq));
    }
    ::grpc::Status Commit(::grpc::ClientContext* context, const ::google::spanner::v1::CommitRequest& request, ::google::spanner::v1::CommitResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::spanner::v1::CommitResponse>> AsyncCommit(::grpc::ClientContext* context, const ::google::spanner::v1::CommitRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::spanner::v1::CommitResponse>>(AsyncCommitRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::spanner::v1::CommitResponse>> PrepareAsyncCommit(::grpc::ClientContext* context, const ::google::spanner::v1::CommitRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::spanner::v1::CommitResponse>>(PrepareAsyncCommitRaw(context, request, cq));
    }
    ::grpc::Status Rollback(::grpc::ClientContext* context, const ::google::spanner::v1::RollbackRequest& request, ::google::protobuf::Empty* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>> AsyncRollback(::grpc::ClientContext* context, const ::google::spanner::v1::RollbackRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>>(AsyncRollbackRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>> PrepareAsyncRollback(::grpc::ClientContext* context, const ::google::spanner::v1::RollbackRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>>(PrepareAsyncRollbackRaw(context, request, cq));
    }
    ::grpc::Status PartitionQuery(::grpc::ClientContext* context, const ::google::spanner::v1::PartitionQueryRequest& request, ::google::spanner::v1::PartitionResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::spanner::v1::PartitionResponse>> AsyncPartitionQuery(::grpc::ClientContext* context, const ::google::spanner::v1::PartitionQueryRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::spanner::v1::PartitionResponse>>(AsyncPartitionQueryRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::spanner::v1::PartitionResponse>> PrepareAsyncPartitionQuery(::grpc::ClientContext* context, const ::google::spanner::v1::PartitionQueryRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::spanner::v1::PartitionResponse>>(PrepareAsyncPartitionQueryRaw(context, request, cq));
    }
    ::grpc::Status PartitionRead(::grpc::ClientContext* context, const ::google::spanner::v1::PartitionReadRequest& request, ::google::spanner::v1::PartitionResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::spanner::v1::PartitionResponse>> AsyncPartitionRead(::grpc::ClientContext* context, const ::google::spanner::v1::PartitionReadRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::spanner::v1::PartitionResponse>>(AsyncPartitionReadRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::spanner::v1::PartitionResponse>> PrepareAsyncPartitionRead(::grpc::ClientContext* context, const ::google::spanner::v1::PartitionReadRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::spanner::v1::PartitionResponse>>(PrepareAsyncPartitionReadRaw(context, request, cq));
    }
    class async final :
      public StubInterface::async_interface {
     public:
      void CreateSession(::grpc::ClientContext* context, const ::google::spanner::v1::CreateSessionRequest* request, ::google::spanner::v1::Session* response, std::function<void(::grpc::Status)>) override;
      void CreateSession(::grpc::ClientContext* context, const ::google::spanner::v1::CreateSessionRequest* request, ::google::spanner::v1::Session* response, ::grpc::ClientUnaryReactor* reactor) override;
      void BatchCreateSessions(::grpc::ClientContext* context, const ::google::spanner::v1::BatchCreateSessionsRequest* request, ::google::spanner::v1::BatchCreateSessionsResponse* response, std::function<void(::grpc::Status)>) override;
      void BatchCreateSessions(::grpc::ClientContext* context, const ::google::spanner::v1::BatchCreateSessionsRequest* request, ::google::spanner::v1::BatchCreateSessionsResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
      void GetSession(::grpc::ClientContext* context, const ::google::spanner::v1::GetSessionRequest* request, ::google::spanner::v1::Session* response, std::function<void(::grpc::Status)>) override;
      void GetSession(::grpc::ClientContext* context, const ::google::spanner::v1::GetSessionRequest* request, ::google::spanner::v1::Session* response, ::grpc::ClientUnaryReactor* reactor) override;
      void ListSessions(::grpc::ClientContext* context, const ::google::spanner::v1::ListSessionsRequest* request, ::google::spanner::v1::ListSessionsResponse* response, std::function<void(::grpc::Status)>) override;
      void ListSessions(::grpc::ClientContext* context, const ::google::spanner::v1::ListSessionsRequest* request, ::google::spanner::v1::ListSessionsResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
      void DeleteSession(::grpc::ClientContext* context, const ::google::spanner::v1::DeleteSessionRequest* request, ::google::protobuf::Empty* response, std::function<void(::grpc::Status)>) override;
      void DeleteSession(::grpc::ClientContext* context, const ::google::spanner::v1::DeleteSessionRequest* request, ::google::protobuf::Empty* response, ::grpc::ClientUnaryReactor* reactor) override;
      void ExecuteSql(::grpc::ClientContext* context, const ::google::spanner::v1::ExecuteSqlRequest* request, ::google::spanner::v1::ResultSet* response, std::function<void(::grpc::Status)>) override;
      void ExecuteSql(::grpc::ClientContext* context, const ::google::spanner::v1::ExecuteSqlRequest* request, ::google::spanner::v1::ResultSet* response, ::grpc::ClientUnaryReactor* reactor) override;
      void ExecuteStreamingSql(::grpc::ClientContext* context, const ::google::spanner::v1::ExecuteSqlRequest* request, ::grpc::ClientReadReactor< ::google::spanner::v1::PartialResultSet>* reactor) override;
      void ExecuteBatchDml(::grpc::ClientContext* context, const ::google::spanner::v1::ExecuteBatchDmlRequest* request, ::google::spanner::v1::ExecuteBatchDmlResponse* response, std::function<void(::grpc::Status)>) override;
      void ExecuteBatchDml(::grpc::ClientContext* context, const ::google::spanner::v1::ExecuteBatchDmlRequest* request, ::google::spanner::v1::ExecuteBatchDmlResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
      void Read(::grpc::ClientContext* context, const ::google::spanner::v1::ReadRequest* request, ::google::spanner::v1::ResultSet* response, std::function<void(::grpc::Status)>) override;
      void Read(::grpc::ClientContext* context, const ::google::spanner::v1::ReadRequest* request, ::google::spanner::v1::ResultSet* response, ::grpc::ClientUnaryReactor* reactor) override;
      void StreamingRead(::grpc::ClientContext* context, const ::google::spanner::v1::ReadRequest* request, ::grpc::ClientReadReactor< ::google::spanner::v1::PartialResultSet>* reactor) override;
      void BeginTransaction(::grpc::ClientContext* context, const ::google::spanner::v1::BeginTransactionRequest* request, ::google::spanner::v1::Transaction* response, std::function<void(::grpc::Status)>) override;
      void BeginTransaction(::grpc::ClientContext* context, const ::google::spanner::v1::BeginTransactionRequest* request, ::google::spanner::v1::Transaction* response, ::grpc::ClientUnaryReactor* reactor) override;
      void Commit(::grpc::ClientContext* context, const ::google::spanner::v1::CommitRequest* request, ::google::spanner::v1::CommitResponse* response, std::function<void(::grpc::Status)>) override;
      void Commit(::grpc::ClientContext* context, const ::google::spanner::v1::CommitRequest* request, ::google::spanner::v1::CommitResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
      void Rollback(::grpc::ClientContext* context, const ::google::spanner::v1::RollbackRequest* request, ::google::protobuf::Empty* response, std::function<void(::grpc::Status)>) override;
      void Rollback(::grpc::ClientContext* context, const ::google::spanner::v1::RollbackRequest* request, ::google::protobuf::Empty* response, ::grpc::ClientUnaryReactor* reactor) override;
      void PartitionQuery(::grpc::ClientContext* context, const ::google::spanner::v1::PartitionQueryRequest* request, ::google::spanner::v1::PartitionResponse* response, std::function<void(::grpc::Status)>) override;
      void PartitionQuery(::grpc::ClientContext* context, const ::google::spanner::v1::PartitionQueryRequest* request, ::google::spanner::v1::PartitionResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
      void PartitionRead(::grpc::ClientContext* context, const ::google::spanner::v1::PartitionReadRequest* request, ::google::spanner::v1::PartitionResponse* response, std::function<void(::grpc::Status)>) override;
      void PartitionRead(::grpc::ClientContext* context, const ::google::spanner::v1::PartitionReadRequest* request, ::google::spanner::v1::PartitionResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
     private:
      friend class Stub;
      explicit async(Stub* stub): stub_(stub) { }
      Stub* stub() { return stub_; }
      Stub* stub_;
    };
    class async* async() override { return &async_stub_; }

   private:
    std::shared_ptr< ::grpc::ChannelInterface> channel_;
    class async async_stub_{this};
    ::grpc::ClientAsyncResponseReader< ::google::spanner::v1::Session>* AsyncCreateSessionRaw(::grpc::ClientContext* context, const ::google::spanner::v1::CreateSessionRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::spanner::v1::Session>* PrepareAsyncCreateSessionRaw(::grpc::ClientContext* context, const ::google::spanner::v1::CreateSessionRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::spanner::v1::BatchCreateSessionsResponse>* AsyncBatchCreateSessionsRaw(::grpc::ClientContext* context, const ::google::spanner::v1::BatchCreateSessionsRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::spanner::v1::BatchCreateSessionsResponse>* PrepareAsyncBatchCreateSessionsRaw(::grpc::ClientContext* context, const ::google::spanner::v1::BatchCreateSessionsRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::spanner::v1::Session>* AsyncGetSessionRaw(::grpc::ClientContext* context, const ::google::spanner::v1::GetSessionRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::spanner::v1::Session>* PrepareAsyncGetSessionRaw(::grpc::ClientContext* context, const ::google::spanner::v1::GetSessionRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::spanner::v1::ListSessionsResponse>* AsyncListSessionsRaw(::grpc::ClientContext* context, const ::google::spanner::v1::ListSessionsRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::spanner::v1::ListSessionsResponse>* PrepareAsyncListSessionsRaw(::grpc::ClientContext* context, const ::google::spanner::v1::ListSessionsRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>* AsyncDeleteSessionRaw(::grpc::ClientContext* context, const ::google::spanner::v1::DeleteSessionRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>* PrepareAsyncDeleteSessionRaw(::grpc::ClientContext* context, const ::google::spanner::v1::DeleteSessionRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::spanner::v1::ResultSet>* AsyncExecuteSqlRaw(::grpc::ClientContext* context, const ::google::spanner::v1::ExecuteSqlRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::spanner::v1::ResultSet>* PrepareAsyncExecuteSqlRaw(::grpc::ClientContext* context, const ::google::spanner::v1::ExecuteSqlRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientReader< ::google::spanner::v1::PartialResultSet>* ExecuteStreamingSqlRaw(::grpc::ClientContext* context, const ::google::spanner::v1::ExecuteSqlRequest& request) override;
    ::grpc::ClientAsyncReader< ::google::spanner::v1::PartialResultSet>* AsyncExecuteStreamingSqlRaw(::grpc::ClientContext* context, const ::google::spanner::v1::ExecuteSqlRequest& request, ::grpc::CompletionQueue* cq, void* tag) override;
    ::grpc::ClientAsyncReader< ::google::spanner::v1::PartialResultSet>* PrepareAsyncExecuteStreamingSqlRaw(::grpc::ClientContext* context, const ::google::spanner::v1::ExecuteSqlRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::spanner::v1::ExecuteBatchDmlResponse>* AsyncExecuteBatchDmlRaw(::grpc::ClientContext* context, const ::google::spanner::v1::ExecuteBatchDmlRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::spanner::v1::ExecuteBatchDmlResponse>* PrepareAsyncExecuteBatchDmlRaw(::grpc::ClientContext* context, const ::google::spanner::v1::ExecuteBatchDmlRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::spanner::v1::ResultSet>* AsyncReadRaw(::grpc::ClientContext* context, const ::google::spanner::v1::ReadRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::spanner::v1::ResultSet>* PrepareAsyncReadRaw(::grpc::ClientContext* context, const ::google::spanner::v1::ReadRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientReader< ::google::spanner::v1::PartialResultSet>* StreamingReadRaw(::grpc::ClientContext* context, const ::google::spanner::v1::ReadRequest& request) override;
    ::grpc::ClientAsyncReader< ::google::spanner::v1::PartialResultSet>* AsyncStreamingReadRaw(::grpc::ClientContext* context, const ::google::spanner::v1::ReadRequest& request, ::grpc::CompletionQueue* cq, void* tag) override;
    ::grpc::ClientAsyncReader< ::google::spanner::v1::PartialResultSet>* PrepareAsyncStreamingReadRaw(::grpc::ClientContext* context, const ::google::spanner::v1::ReadRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::spanner::v1::Transaction>* AsyncBeginTransactionRaw(::grpc::ClientContext* context, const ::google::spanner::v1::BeginTransactionRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::spanner::v1::Transaction>* PrepareAsyncBeginTransactionRaw(::grpc::ClientContext* context, const ::google::spanner::v1::BeginTransactionRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::spanner::v1::CommitResponse>* AsyncCommitRaw(::grpc::ClientContext* context, const ::google::spanner::v1::CommitRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::spanner::v1::CommitResponse>* PrepareAsyncCommitRaw(::grpc::ClientContext* context, const ::google::spanner::v1::CommitRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>* AsyncRollbackRaw(::grpc::ClientContext* context, const ::google::spanner::v1::RollbackRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>* PrepareAsyncRollbackRaw(::grpc::ClientContext* context, const ::google::spanner::v1::RollbackRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::spanner::v1::PartitionResponse>* AsyncPartitionQueryRaw(::grpc::ClientContext* context, const ::google::spanner::v1::PartitionQueryRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::spanner::v1::PartitionResponse>* PrepareAsyncPartitionQueryRaw(::grpc::ClientContext* context, const ::google::spanner::v1::PartitionQueryRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::spanner::v1::PartitionResponse>* AsyncPartitionReadRaw(::grpc::ClientContext* context, const ::google::spanner::v1::PartitionReadRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::spanner::v1::PartitionResponse>* PrepareAsyncPartitionReadRaw(::grpc::ClientContext* context, const ::google::spanner::v1::PartitionReadRequest& request, ::grpc::CompletionQueue* cq) override;
    const ::grpc::internal::RpcMethod rpcmethod_CreateSession_;
    const ::grpc::internal::RpcMethod rpcmethod_BatchCreateSessions_;
    const ::grpc::internal::RpcMethod rpcmethod_GetSession_;
    const ::grpc::internal::RpcMethod rpcmethod_ListSessions_;
    const ::grpc::internal::RpcMethod rpcmethod_DeleteSession_;
    const ::grpc::internal::RpcMethod rpcmethod_ExecuteSql_;
    const ::grpc::internal::RpcMethod rpcmethod_ExecuteStreamingSql_;
    const ::grpc::internal::RpcMethod rpcmethod_ExecuteBatchDml_;
    const ::grpc::internal::RpcMethod rpcmethod_Read_;
    const ::grpc::internal::RpcMethod rpcmethod_StreamingRead_;
    const ::grpc::internal::RpcMethod rpcmethod_BeginTransaction_;
    const ::grpc::internal::RpcMethod rpcmethod_Commit_;
    const ::grpc::internal::RpcMethod rpcmethod_Rollback_;
    const ::grpc::internal::RpcMethod rpcmethod_PartitionQuery_;
    const ::grpc::internal::RpcMethod rpcmethod_PartitionRead_;
  };
  static std::unique_ptr<Stub> NewStub(const std::shared_ptr< ::grpc::ChannelInterface>& channel, const ::grpc::StubOptions& options = ::grpc::StubOptions());

  class Service : public ::grpc::Service {
   public:
    Service();
    virtual ~Service();
    // Creates a new session. A session can be used to perform
    // transactions that read and/or modify data in a Cloud Spanner database.
    // Sessions are meant to be reused for many consecutive
    // transactions.
    //
    // Sessions can only execute one transaction at a time. To execute
    // multiple concurrent read-write/write-only transactions, create
    // multiple sessions. Note that standalone reads and queries use a
    // transaction internally, and count toward the one transaction
    // limit.
    //
    // Active sessions use additional server resources, so it is a good idea to
    // delete idle and unneeded sessions.
    // Aside from explicit deletes, Cloud Spanner may delete sessions for which no
    // operations are sent for more than an hour. If a session is deleted,
    // requests to it return `NOT_FOUND`.
    //
    // Idle sessions can be kept alive by sending a trivial SQL query
    // periodically, e.g., `"SELECT 1"`.
    virtual ::grpc::Status CreateSession(::grpc::ServerContext* context, const ::google::spanner::v1::CreateSessionRequest* request, ::google::spanner::v1::Session* response);
    // Creates multiple new sessions.
    //
    // This API can be used to initialize a session cache on the clients.
    // See https://goo.gl/TgSFN2 for best practices on session cache management.
    virtual ::grpc::Status BatchCreateSessions(::grpc::ServerContext* context, const ::google::spanner::v1::BatchCreateSessionsRequest* request, ::google::spanner::v1::BatchCreateSessionsResponse* response);
    // Gets a session. Returns `NOT_FOUND` if the session does not exist.
    // This is mainly useful for determining whether a session is still
    // alive.
    virtual ::grpc::Status GetSession(::grpc::ServerContext* context, const ::google::spanner::v1::GetSessionRequest* request, ::google::spanner::v1::Session* response);
    // Lists all sessions in a given database.
    virtual ::grpc::Status ListSessions(::grpc::ServerContext* context, const ::google::spanner::v1::ListSessionsRequest* request, ::google::spanner::v1::ListSessionsResponse* response);
    // Ends a session, releasing server resources associated with it. This will
    // asynchronously trigger cancellation of any operations that are running with
    // this session.
    virtual ::grpc::Status DeleteSession(::grpc::ServerContext* context, const ::google::spanner::v1::DeleteSessionRequest* request, ::google::protobuf::Empty* response);
    // Executes an SQL statement, returning all results in a single reply. This
    // method cannot be used to return a result set larger than 10 MiB;
    // if the query yields more data than that, the query fails with
    // a `FAILED_PRECONDITION` error.
    //
    // Operations inside read-write transactions might return `ABORTED`. If
    // this occurs, the application should restart the transaction from
    // the beginning. See [Transaction][google.spanner.v1.Transaction] for more details.
    //
    // Larger result sets can be fetched in streaming fashion by calling
    // [ExecuteStreamingSql][google.spanner.v1.Spanner.ExecuteStreamingSql] instead.
    virtual ::grpc::Status ExecuteSql(::grpc::ServerContext* context, const ::google::spanner::v1::ExecuteSqlRequest* request, ::google::spanner::v1::ResultSet* response);
    // Like [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql], except returns the result
    // set as a stream. Unlike [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql], there
    // is no limit on the size of the returned result set. However, no
    // individual row in the result set can exceed 100 MiB, and no
    // column value can exceed 10 MiB.
    virtual ::grpc::Status ExecuteStreamingSql(::grpc::ServerContext* context, const ::google::spanner::v1::ExecuteSqlRequest* request, ::grpc::ServerWriter< ::google::spanner::v1::PartialResultSet>* writer);
    // Executes a batch of SQL DML statements. This method allows many statements
    // to be run with lower latency than submitting them sequentially with
    // [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql].
    //
    // Statements are executed in sequential order. A request can succeed even if
    // a statement fails. The [ExecuteBatchDmlResponse.status][google.spanner.v1.ExecuteBatchDmlResponse.status] field in the
    // response provides information about the statement that failed. Clients must
    // inspect this field to determine whether an error occurred.
    //
    // Execution stops after the first failed statement; the remaining statements
    // are not executed.
    virtual ::grpc::Status ExecuteBatchDml(::grpc::ServerContext* context, const ::google::spanner::v1::ExecuteBatchDmlRequest* request, ::google::spanner::v1::ExecuteBatchDmlResponse* response);
    // Reads rows from the database using key lookups and scans, as a
    // simple key/value style alternative to
    // [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql].  This method cannot be used to
    // return a result set larger than 10 MiB; if the read matches more
    // data than that, the read fails with a `FAILED_PRECONDITION`
    // error.
    //
    // Reads inside read-write transactions might return `ABORTED`. If
    // this occurs, the application should restart the transaction from
    // the beginning. See [Transaction][google.spanner.v1.Transaction] for more details.
    //
    // Larger result sets can be yielded in streaming fashion by calling
    // [StreamingRead][google.spanner.v1.Spanner.StreamingRead] instead.
    virtual ::grpc::Status Read(::grpc::ServerContext* context, const ::google::spanner::v1::ReadRequest* request, ::google::spanner::v1::ResultSet* response);
    // Like [Read][google.spanner.v1.Spanner.Read], except returns the result set as a
    // stream. Unlike [Read][google.spanner.v1.Spanner.Read], there is no limit on the
    // size of the returned result set. However, no individual row in
    // the result set can exceed 100 MiB, and no column value can exceed
    // 10 MiB.
    virtual ::grpc::Status StreamingRead(::grpc::ServerContext* context, const ::google::spanner::v1::ReadRequest* request, ::grpc::ServerWriter< ::google::spanner::v1::PartialResultSet>* writer);
    // Begins a new transaction. This step can often be skipped:
    // [Read][google.spanner.v1.Spanner.Read], [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql] and
    // [Commit][google.spanner.v1.Spanner.Commit] can begin a new transaction as a
    // side-effect.
    virtual ::grpc::Status BeginTransaction(::grpc::ServerContext* context, const ::google::spanner::v1::BeginTransactionRequest* request, ::google::spanner::v1::Transaction* response);
    // Commits a transaction. The request includes the mutations to be
    // applied to rows in the database.
    //
    // `Commit` might return an `ABORTED` error. This can occur at any time;
    // commonly, the cause is conflicts with concurrent
    // transactions. However, it can also happen for a variety of other
    // reasons. If `Commit` returns `ABORTED`, the caller should re-attempt
    // the transaction from the beginning, re-using the same session.
    //
    // On very rare occasions, `Commit` might return `UNKNOWN`. This can happen,
    // for example, if the client job experiences a 1+ hour networking failure.
    // At that point, Cloud Spanner has lost track of the transaction outcome and
    // we recommend that you perform another read from the database to see the
    // state of things as they are now.
    virtual ::grpc::Status Commit(::grpc::ServerContext* context, const ::google::spanner::v1::CommitRequest* request, ::google::spanner::v1::CommitResponse* response);
    // Rolls back a transaction, releasing any locks it holds. It is a good
    // idea to call this for any transaction that includes one or more
    // [Read][google.spanner.v1.Spanner.Read] or [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql] requests and
    // ultimately decides not to commit.
    //
    // `Rollback` returns `OK` if it successfully aborts the transaction, the
    // transaction was already aborted, or the transaction is not
    // found. `Rollback` never returns `ABORTED`.
    virtual ::grpc::Status Rollback(::grpc::ServerContext* context, const ::google::spanner::v1::RollbackRequest* request, ::google::protobuf::Empty* response);
    // Creates a set of partition tokens that can be used to execute a query
    // operation in parallel.  Each of the returned partition tokens can be used
    // by [ExecuteStreamingSql][google.spanner.v1.Spanner.ExecuteStreamingSql] to specify a subset
    // of the query result to read.  The same session and read-only transaction
    // must be used by the PartitionQueryRequest used to create the
    // partition tokens and the ExecuteSqlRequests that use the partition tokens.
    //
    // Partition tokens become invalid when the session used to create them
    // is deleted, is idle for too long, begins a new transaction, or becomes too
    // old.  When any of these happen, it is not possible to resume the query, and
    // the whole operation must be restarted from the beginning.
    virtual ::grpc::Status PartitionQuery(::grpc::ServerContext* context, const ::google::spanner::v1::PartitionQueryRequest* request, ::google::spanner::v1::PartitionResponse* response);
    // Creates a set of partition tokens that can be used to execute a read
    // operation in parallel.  Each of the returned partition tokens can be used
    // by [StreamingRead][google.spanner.v1.Spanner.StreamingRead] to specify a subset of the read
    // result to read.  The same session and read-only transaction must be used by
    // the PartitionReadRequest used to create the partition tokens and the
    // ReadRequests that use the partition tokens.  There are no ordering
    // guarantees on rows returned among the returned partition tokens, or even
    // within each individual StreamingRead call issued with a partition_token.
    //
    // Partition tokens become invalid when the session used to create them
    // is deleted, is idle for too long, begins a new transaction, or becomes too
    // old.  When any of these happen, it is not possible to resume the read, and
    // the whole operation must be restarted from the beginning.
    virtual ::grpc::Status PartitionRead(::grpc::ServerContext* context, const ::google::spanner::v1::PartitionReadRequest* request, ::google::spanner::v1::PartitionResponse* response);
  };
  template <class BaseClass>
  class WithAsyncMethod_CreateSession : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_CreateSession() {
      ::grpc::Service::MarkMethodAsync(0);
    }
    ~WithAsyncMethod_CreateSession() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateSession(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::CreateSessionRequest* /*request*/, ::google::spanner::v1::Session* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestCreateSession(::grpc::ServerContext* context, ::google::spanner::v1::CreateSessionRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::spanner::v1::Session>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(0, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_BatchCreateSessions : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_BatchCreateSessions() {
      ::grpc::Service::MarkMethodAsync(1);
    }
    ~WithAsyncMethod_BatchCreateSessions() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status BatchCreateSessions(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::BatchCreateSessionsRequest* /*request*/, ::google::spanner::v1::BatchCreateSessionsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestBatchCreateSessions(::grpc::ServerContext* context, ::google::spanner::v1::BatchCreateSessionsRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::spanner::v1::BatchCreateSessionsResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(1, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_GetSession : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_GetSession() {
      ::grpc::Service::MarkMethodAsync(2);
    }
    ~WithAsyncMethod_GetSession() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetSession(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::GetSessionRequest* /*request*/, ::google::spanner::v1::Session* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGetSession(::grpc::ServerContext* context, ::google::spanner::v1::GetSessionRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::spanner::v1::Session>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(2, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_ListSessions : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_ListSessions() {
      ::grpc::Service::MarkMethodAsync(3);
    }
    ~WithAsyncMethod_ListSessions() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListSessions(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::ListSessionsRequest* /*request*/, ::google::spanner::v1::ListSessionsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestListSessions(::grpc::ServerContext* context, ::google::spanner::v1::ListSessionsRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::spanner::v1::ListSessionsResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(3, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_DeleteSession : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_DeleteSession() {
      ::grpc::Service::MarkMethodAsync(4);
    }
    ~WithAsyncMethod_DeleteSession() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteSession(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::DeleteSessionRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestDeleteSession(::grpc::ServerContext* context, ::google::spanner::v1::DeleteSessionRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::protobuf::Empty>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(4, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_ExecuteSql : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_ExecuteSql() {
      ::grpc::Service::MarkMethodAsync(5);
    }
    ~WithAsyncMethod_ExecuteSql() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ExecuteSql(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::ExecuteSqlRequest* /*request*/, ::google::spanner::v1::ResultSet* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestExecuteSql(::grpc::ServerContext* context, ::google::spanner::v1::ExecuteSqlRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::spanner::v1::ResultSet>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(5, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_ExecuteStreamingSql : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_ExecuteStreamingSql() {
      ::grpc::Service::MarkMethodAsync(6);
    }
    ~WithAsyncMethod_ExecuteStreamingSql() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ExecuteStreamingSql(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::ExecuteSqlRequest* /*request*/, ::grpc::ServerWriter< ::google::spanner::v1::PartialResultSet>* /*writer*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestExecuteStreamingSql(::grpc::ServerContext* context, ::google::spanner::v1::ExecuteSqlRequest* request, ::grpc::ServerAsyncWriter< ::google::spanner::v1::PartialResultSet>* writer, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncServerStreaming(6, context, request, writer, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_ExecuteBatchDml : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_ExecuteBatchDml() {
      ::grpc::Service::MarkMethodAsync(7);
    }
    ~WithAsyncMethod_ExecuteBatchDml() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ExecuteBatchDml(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::ExecuteBatchDmlRequest* /*request*/, ::google::spanner::v1::ExecuteBatchDmlResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestExecuteBatchDml(::grpc::ServerContext* context, ::google::spanner::v1::ExecuteBatchDmlRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::spanner::v1::ExecuteBatchDmlResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(7, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_Read : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_Read() {
      ::grpc::Service::MarkMethodAsync(8);
    }
    ~WithAsyncMethod_Read() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Read(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::ReadRequest* /*request*/, ::google::spanner::v1::ResultSet* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestRead(::grpc::ServerContext* context, ::google::spanner::v1::ReadRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::spanner::v1::ResultSet>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(8, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_StreamingRead : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_StreamingRead() {
      ::grpc::Service::MarkMethodAsync(9);
    }
    ~WithAsyncMethod_StreamingRead() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status StreamingRead(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::ReadRequest* /*request*/, ::grpc::ServerWriter< ::google::spanner::v1::PartialResultSet>* /*writer*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestStreamingRead(::grpc::ServerContext* context, ::google::spanner::v1::ReadRequest* request, ::grpc::ServerAsyncWriter< ::google::spanner::v1::PartialResultSet>* writer, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncServerStreaming(9, context, request, writer, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_BeginTransaction : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_BeginTransaction() {
      ::grpc::Service::MarkMethodAsync(10);
    }
    ~WithAsyncMethod_BeginTransaction() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status BeginTransaction(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::BeginTransactionRequest* /*request*/, ::google::spanner::v1::Transaction* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestBeginTransaction(::grpc::ServerContext* context, ::google::spanner::v1::BeginTransactionRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::spanner::v1::Transaction>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(10, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_Commit : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_Commit() {
      ::grpc::Service::MarkMethodAsync(11);
    }
    ~WithAsyncMethod_Commit() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Commit(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::CommitRequest* /*request*/, ::google::spanner::v1::CommitResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestCommit(::grpc::ServerContext* context, ::google::spanner::v1::CommitRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::spanner::v1::CommitResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(11, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_Rollback : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_Rollback() {
      ::grpc::Service::MarkMethodAsync(12);
    }
    ~WithAsyncMethod_Rollback() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Rollback(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::RollbackRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestRollback(::grpc::ServerContext* context, ::google::spanner::v1::RollbackRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::protobuf::Empty>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(12, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_PartitionQuery : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_PartitionQuery() {
      ::grpc::Service::MarkMethodAsync(13);
    }
    ~WithAsyncMethod_PartitionQuery() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status PartitionQuery(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::PartitionQueryRequest* /*request*/, ::google::spanner::v1::PartitionResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestPartitionQuery(::grpc::ServerContext* context, ::google::spanner::v1::PartitionQueryRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::spanner::v1::PartitionResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(13, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_PartitionRead : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_PartitionRead() {
      ::grpc::Service::MarkMethodAsync(14);
    }
    ~WithAsyncMethod_PartitionRead() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status PartitionRead(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::PartitionReadRequest* /*request*/, ::google::spanner::v1::PartitionResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestPartitionRead(::grpc::ServerContext* context, ::google::spanner::v1::PartitionReadRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::spanner::v1::PartitionResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(14, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  typedef WithAsyncMethod_CreateSession<WithAsyncMethod_BatchCreateSessions<WithAsyncMethod_GetSession<WithAsyncMethod_ListSessions<WithAsyncMethod_DeleteSession<WithAsyncMethod_ExecuteSql<WithAsyncMethod_ExecuteStreamingSql<WithAsyncMethod_ExecuteBatchDml<WithAsyncMethod_Read<WithAsyncMethod_StreamingRead<WithAsyncMethod_BeginTransaction<WithAsyncMethod_Commit<WithAsyncMethod_Rollback<WithAsyncMethod_PartitionQuery<WithAsyncMethod_PartitionRead<Service > > > > > > > > > > > > > > > AsyncService;
  template <class BaseClass>
  class WithCallbackMethod_CreateSession : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_CreateSession() {
      ::grpc::Service::MarkMethodCallback(0,
          new ::grpc::internal::CallbackUnaryHandler< ::google::spanner::v1::CreateSessionRequest, ::google::spanner::v1::Session>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::spanner::v1::CreateSessionRequest* request, ::google::spanner::v1::Session* response) { return this->CreateSession(context, request, response); }));}
    void SetMessageAllocatorFor_CreateSession(
        ::grpc::MessageAllocator< ::google::spanner::v1::CreateSessionRequest, ::google::spanner::v1::Session>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(0);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::spanner::v1::CreateSessionRequest, ::google::spanner::v1::Session>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_CreateSession() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateSession(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::CreateSessionRequest* /*request*/, ::google::spanner::v1::Session* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* CreateSession(
      ::grpc::CallbackServerContext* /*context*/, const ::google::spanner::v1::CreateSessionRequest* /*request*/, ::google::spanner::v1::Session* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_BatchCreateSessions : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_BatchCreateSessions() {
      ::grpc::Service::MarkMethodCallback(1,
          new ::grpc::internal::CallbackUnaryHandler< ::google::spanner::v1::BatchCreateSessionsRequest, ::google::spanner::v1::BatchCreateSessionsResponse>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::spanner::v1::BatchCreateSessionsRequest* request, ::google::spanner::v1::BatchCreateSessionsResponse* response) { return this->BatchCreateSessions(context, request, response); }));}
    void SetMessageAllocatorFor_BatchCreateSessions(
        ::grpc::MessageAllocator< ::google::spanner::v1::BatchCreateSessionsRequest, ::google::spanner::v1::BatchCreateSessionsResponse>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(1);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::spanner::v1::BatchCreateSessionsRequest, ::google::spanner::v1::BatchCreateSessionsResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_BatchCreateSessions() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status BatchCreateSessions(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::BatchCreateSessionsRequest* /*request*/, ::google::spanner::v1::BatchCreateSessionsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* BatchCreateSessions(
      ::grpc::CallbackServerContext* /*context*/, const ::google::spanner::v1::BatchCreateSessionsRequest* /*request*/, ::google::spanner::v1::BatchCreateSessionsResponse* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_GetSession : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_GetSession() {
      ::grpc::Service::MarkMethodCallback(2,
          new ::grpc::internal::CallbackUnaryHandler< ::google::spanner::v1::GetSessionRequest, ::google::spanner::v1::Session>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::spanner::v1::GetSessionRequest* request, ::google::spanner::v1::Session* response) { return this->GetSession(context, request, response); }));}
    void SetMessageAllocatorFor_GetSession(
        ::grpc::MessageAllocator< ::google::spanner::v1::GetSessionRequest, ::google::spanner::v1::Session>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(2);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::spanner::v1::GetSessionRequest, ::google::spanner::v1::Session>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_GetSession() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetSession(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::GetSessionRequest* /*request*/, ::google::spanner::v1::Session* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* GetSession(
      ::grpc::CallbackServerContext* /*context*/, const ::google::spanner::v1::GetSessionRequest* /*request*/, ::google::spanner::v1::Session* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_ListSessions : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_ListSessions() {
      ::grpc::Service::MarkMethodCallback(3,
          new ::grpc::internal::CallbackUnaryHandler< ::google::spanner::v1::ListSessionsRequest, ::google::spanner::v1::ListSessionsResponse>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::spanner::v1::ListSessionsRequest* request, ::google::spanner::v1::ListSessionsResponse* response) { return this->ListSessions(context, request, response); }));}
    void SetMessageAllocatorFor_ListSessions(
        ::grpc::MessageAllocator< ::google::spanner::v1::ListSessionsRequest, ::google::spanner::v1::ListSessionsResponse>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(3);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::spanner::v1::ListSessionsRequest, ::google::spanner::v1::ListSessionsResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_ListSessions() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListSessions(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::ListSessionsRequest* /*request*/, ::google::spanner::v1::ListSessionsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* ListSessions(
      ::grpc::CallbackServerContext* /*context*/, const ::google::spanner::v1::ListSessionsRequest* /*request*/, ::google::spanner::v1::ListSessionsResponse* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_DeleteSession : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_DeleteSession() {
      ::grpc::Service::MarkMethodCallback(4,
          new ::grpc::internal::CallbackUnaryHandler< ::google::spanner::v1::DeleteSessionRequest, ::google::protobuf::Empty>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::spanner::v1::DeleteSessionRequest* request, ::google::protobuf::Empty* response) { return this->DeleteSession(context, request, response); }));}
    void SetMessageAllocatorFor_DeleteSession(
        ::grpc::MessageAllocator< ::google::spanner::v1::DeleteSessionRequest, ::google::protobuf::Empty>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(4);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::spanner::v1::DeleteSessionRequest, ::google::protobuf::Empty>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_DeleteSession() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteSession(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::DeleteSessionRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* DeleteSession(
      ::grpc::CallbackServerContext* /*context*/, const ::google::spanner::v1::DeleteSessionRequest* /*request*/, ::google::protobuf::Empty* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_ExecuteSql : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_ExecuteSql() {
      ::grpc::Service::MarkMethodCallback(5,
          new ::grpc::internal::CallbackUnaryHandler< ::google::spanner::v1::ExecuteSqlRequest, ::google::spanner::v1::ResultSet>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::spanner::v1::ExecuteSqlRequest* request, ::google::spanner::v1::ResultSet* response) { return this->ExecuteSql(context, request, response); }));}
    void SetMessageAllocatorFor_ExecuteSql(
        ::grpc::MessageAllocator< ::google::spanner::v1::ExecuteSqlRequest, ::google::spanner::v1::ResultSet>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(5);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::spanner::v1::ExecuteSqlRequest, ::google::spanner::v1::ResultSet>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_ExecuteSql() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ExecuteSql(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::ExecuteSqlRequest* /*request*/, ::google::spanner::v1::ResultSet* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* ExecuteSql(
      ::grpc::CallbackServerContext* /*context*/, const ::google::spanner::v1::ExecuteSqlRequest* /*request*/, ::google::spanner::v1::ResultSet* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_ExecuteStreamingSql : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_ExecuteStreamingSql() {
      ::grpc::Service::MarkMethodCallback(6,
          new ::grpc::internal::CallbackServerStreamingHandler< ::google::spanner::v1::ExecuteSqlRequest, ::google::spanner::v1::PartialResultSet>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::spanner::v1::ExecuteSqlRequest* request) { return this->ExecuteStreamingSql(context, request); }));
    }
    ~WithCallbackMethod_ExecuteStreamingSql() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ExecuteStreamingSql(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::ExecuteSqlRequest* /*request*/, ::grpc::ServerWriter< ::google::spanner::v1::PartialResultSet>* /*writer*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerWriteReactor< ::google::spanner::v1::PartialResultSet>* ExecuteStreamingSql(
      ::grpc::CallbackServerContext* /*context*/, const ::google::spanner::v1::ExecuteSqlRequest* /*request*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_ExecuteBatchDml : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_ExecuteBatchDml() {
      ::grpc::Service::MarkMethodCallback(7,
          new ::grpc::internal::CallbackUnaryHandler< ::google::spanner::v1::ExecuteBatchDmlRequest, ::google::spanner::v1::ExecuteBatchDmlResponse>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::spanner::v1::ExecuteBatchDmlRequest* request, ::google::spanner::v1::ExecuteBatchDmlResponse* response) { return this->ExecuteBatchDml(context, request, response); }));}
    void SetMessageAllocatorFor_ExecuteBatchDml(
        ::grpc::MessageAllocator< ::google::spanner::v1::ExecuteBatchDmlRequest, ::google::spanner::v1::ExecuteBatchDmlResponse>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(7);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::spanner::v1::ExecuteBatchDmlRequest, ::google::spanner::v1::ExecuteBatchDmlResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_ExecuteBatchDml() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ExecuteBatchDml(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::ExecuteBatchDmlRequest* /*request*/, ::google::spanner::v1::ExecuteBatchDmlResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* ExecuteBatchDml(
      ::grpc::CallbackServerContext* /*context*/, const ::google::spanner::v1::ExecuteBatchDmlRequest* /*request*/, ::google::spanner::v1::ExecuteBatchDmlResponse* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_Read : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_Read() {
      ::grpc::Service::MarkMethodCallback(8,
          new ::grpc::internal::CallbackUnaryHandler< ::google::spanner::v1::ReadRequest, ::google::spanner::v1::ResultSet>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::spanner::v1::ReadRequest* request, ::google::spanner::v1::ResultSet* response) { return this->Read(context, request, response); }));}
    void SetMessageAllocatorFor_Read(
        ::grpc::MessageAllocator< ::google::spanner::v1::ReadRequest, ::google::spanner::v1::ResultSet>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(8);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::spanner::v1::ReadRequest, ::google::spanner::v1::ResultSet>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_Read() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Read(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::ReadRequest* /*request*/, ::google::spanner::v1::ResultSet* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* Read(
      ::grpc::CallbackServerContext* /*context*/, const ::google::spanner::v1::ReadRequest* /*request*/, ::google::spanner::v1::ResultSet* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_StreamingRead : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_StreamingRead() {
      ::grpc::Service::MarkMethodCallback(9,
          new ::grpc::internal::CallbackServerStreamingHandler< ::google::spanner::v1::ReadRequest, ::google::spanner::v1::PartialResultSet>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::spanner::v1::ReadRequest* request) { return this->StreamingRead(context, request); }));
    }
    ~WithCallbackMethod_StreamingRead() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status StreamingRead(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::ReadRequest* /*request*/, ::grpc::ServerWriter< ::google::spanner::v1::PartialResultSet>* /*writer*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerWriteReactor< ::google::spanner::v1::PartialResultSet>* StreamingRead(
      ::grpc::CallbackServerContext* /*context*/, const ::google::spanner::v1::ReadRequest* /*request*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_BeginTransaction : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_BeginTransaction() {
      ::grpc::Service::MarkMethodCallback(10,
          new ::grpc::internal::CallbackUnaryHandler< ::google::spanner::v1::BeginTransactionRequest, ::google::spanner::v1::Transaction>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::spanner::v1::BeginTransactionRequest* request, ::google::spanner::v1::Transaction* response) { return this->BeginTransaction(context, request, response); }));}
    void SetMessageAllocatorFor_BeginTransaction(
        ::grpc::MessageAllocator< ::google::spanner::v1::BeginTransactionRequest, ::google::spanner::v1::Transaction>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(10);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::spanner::v1::BeginTransactionRequest, ::google::spanner::v1::Transaction>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_BeginTransaction() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status BeginTransaction(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::BeginTransactionRequest* /*request*/, ::google::spanner::v1::Transaction* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* BeginTransaction(
      ::grpc::CallbackServerContext* /*context*/, const ::google::spanner::v1::BeginTransactionRequest* /*request*/, ::google::spanner::v1::Transaction* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_Commit : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_Commit() {
      ::grpc::Service::MarkMethodCallback(11,
          new ::grpc::internal::CallbackUnaryHandler< ::google::spanner::v1::CommitRequest, ::google::spanner::v1::CommitResponse>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::spanner::v1::CommitRequest* request, ::google::spanner::v1::CommitResponse* response) { return this->Commit(context, request, response); }));}
    void SetMessageAllocatorFor_Commit(
        ::grpc::MessageAllocator< ::google::spanner::v1::CommitRequest, ::google::spanner::v1::CommitResponse>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(11);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::spanner::v1::CommitRequest, ::google::spanner::v1::CommitResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_Commit() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Commit(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::CommitRequest* /*request*/, ::google::spanner::v1::CommitResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* Commit(
      ::grpc::CallbackServerContext* /*context*/, const ::google::spanner::v1::CommitRequest* /*request*/, ::google::spanner::v1::CommitResponse* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_Rollback : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_Rollback() {
      ::grpc::Service::MarkMethodCallback(12,
          new ::grpc::internal::CallbackUnaryHandler< ::google::spanner::v1::RollbackRequest, ::google::protobuf::Empty>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::spanner::v1::RollbackRequest* request, ::google::protobuf::Empty* response) { return this->Rollback(context, request, response); }));}
    void SetMessageAllocatorFor_Rollback(
        ::grpc::MessageAllocator< ::google::spanner::v1::RollbackRequest, ::google::protobuf::Empty>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(12);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::spanner::v1::RollbackRequest, ::google::protobuf::Empty>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_Rollback() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Rollback(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::RollbackRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* Rollback(
      ::grpc::CallbackServerContext* /*context*/, const ::google::spanner::v1::RollbackRequest* /*request*/, ::google::protobuf::Empty* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_PartitionQuery : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_PartitionQuery() {
      ::grpc::Service::MarkMethodCallback(13,
          new ::grpc::internal::CallbackUnaryHandler< ::google::spanner::v1::PartitionQueryRequest, ::google::spanner::v1::PartitionResponse>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::spanner::v1::PartitionQueryRequest* request, ::google::spanner::v1::PartitionResponse* response) { return this->PartitionQuery(context, request, response); }));}
    void SetMessageAllocatorFor_PartitionQuery(
        ::grpc::MessageAllocator< ::google::spanner::v1::PartitionQueryRequest, ::google::spanner::v1::PartitionResponse>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(13);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::spanner::v1::PartitionQueryRequest, ::google::spanner::v1::PartitionResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_PartitionQuery() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status PartitionQuery(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::PartitionQueryRequest* /*request*/, ::google::spanner::v1::PartitionResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* PartitionQuery(
      ::grpc::CallbackServerContext* /*context*/, const ::google::spanner::v1::PartitionQueryRequest* /*request*/, ::google::spanner::v1::PartitionResponse* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_PartitionRead : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_PartitionRead() {
      ::grpc::Service::MarkMethodCallback(14,
          new ::grpc::internal::CallbackUnaryHandler< ::google::spanner::v1::PartitionReadRequest, ::google::spanner::v1::PartitionResponse>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::spanner::v1::PartitionReadRequest* request, ::google::spanner::v1::PartitionResponse* response) { return this->PartitionRead(context, request, response); }));}
    void SetMessageAllocatorFor_PartitionRead(
        ::grpc::MessageAllocator< ::google::spanner::v1::PartitionReadRequest, ::google::spanner::v1::PartitionResponse>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(14);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::spanner::v1::PartitionReadRequest, ::google::spanner::v1::PartitionResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_PartitionRead() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status PartitionRead(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::PartitionReadRequest* /*request*/, ::google::spanner::v1::PartitionResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* PartitionRead(
      ::grpc::CallbackServerContext* /*context*/, const ::google::spanner::v1::PartitionReadRequest* /*request*/, ::google::spanner::v1::PartitionResponse* /*response*/)  { return nullptr; }
  };
  typedef WithCallbackMethod_CreateSession<WithCallbackMethod_BatchCreateSessions<WithCallbackMethod_GetSession<WithCallbackMethod_ListSessions<WithCallbackMethod_DeleteSession<WithCallbackMethod_ExecuteSql<WithCallbackMethod_ExecuteStreamingSql<WithCallbackMethod_ExecuteBatchDml<WithCallbackMethod_Read<WithCallbackMethod_StreamingRead<WithCallbackMethod_BeginTransaction<WithCallbackMethod_Commit<WithCallbackMethod_Rollback<WithCallbackMethod_PartitionQuery<WithCallbackMethod_PartitionRead<Service > > > > > > > > > > > > > > > CallbackService;
  typedef CallbackService ExperimentalCallbackService;
  template <class BaseClass>
  class WithGenericMethod_CreateSession : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_CreateSession() {
      ::grpc::Service::MarkMethodGeneric(0);
    }
    ~WithGenericMethod_CreateSession() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateSession(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::CreateSessionRequest* /*request*/, ::google::spanner::v1::Session* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_BatchCreateSessions : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_BatchCreateSessions() {
      ::grpc::Service::MarkMethodGeneric(1);
    }
    ~WithGenericMethod_BatchCreateSessions() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status BatchCreateSessions(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::BatchCreateSessionsRequest* /*request*/, ::google::spanner::v1::BatchCreateSessionsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_GetSession : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_GetSession() {
      ::grpc::Service::MarkMethodGeneric(2);
    }
    ~WithGenericMethod_GetSession() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetSession(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::GetSessionRequest* /*request*/, ::google::spanner::v1::Session* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_ListSessions : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_ListSessions() {
      ::grpc::Service::MarkMethodGeneric(3);
    }
    ~WithGenericMethod_ListSessions() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListSessions(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::ListSessionsRequest* /*request*/, ::google::spanner::v1::ListSessionsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_DeleteSession : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_DeleteSession() {
      ::grpc::Service::MarkMethodGeneric(4);
    }
    ~WithGenericMethod_DeleteSession() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteSession(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::DeleteSessionRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_ExecuteSql : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_ExecuteSql() {
      ::grpc::Service::MarkMethodGeneric(5);
    }
    ~WithGenericMethod_ExecuteSql() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ExecuteSql(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::ExecuteSqlRequest* /*request*/, ::google::spanner::v1::ResultSet* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_ExecuteStreamingSql : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_ExecuteStreamingSql() {
      ::grpc::Service::MarkMethodGeneric(6);
    }
    ~WithGenericMethod_ExecuteStreamingSql() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ExecuteStreamingSql(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::ExecuteSqlRequest* /*request*/, ::grpc::ServerWriter< ::google::spanner::v1::PartialResultSet>* /*writer*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_ExecuteBatchDml : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_ExecuteBatchDml() {
      ::grpc::Service::MarkMethodGeneric(7);
    }
    ~WithGenericMethod_ExecuteBatchDml() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ExecuteBatchDml(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::ExecuteBatchDmlRequest* /*request*/, ::google::spanner::v1::ExecuteBatchDmlResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_Read : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_Read() {
      ::grpc::Service::MarkMethodGeneric(8);
    }
    ~WithGenericMethod_Read() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Read(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::ReadRequest* /*request*/, ::google::spanner::v1::ResultSet* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_StreamingRead : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_StreamingRead() {
      ::grpc::Service::MarkMethodGeneric(9);
    }
    ~WithGenericMethod_StreamingRead() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status StreamingRead(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::ReadRequest* /*request*/, ::grpc::ServerWriter< ::google::spanner::v1::PartialResultSet>* /*writer*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_BeginTransaction : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_BeginTransaction() {
      ::grpc::Service::MarkMethodGeneric(10);
    }
    ~WithGenericMethod_BeginTransaction() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status BeginTransaction(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::BeginTransactionRequest* /*request*/, ::google::spanner::v1::Transaction* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_Commit : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_Commit() {
      ::grpc::Service::MarkMethodGeneric(11);
    }
    ~WithGenericMethod_Commit() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Commit(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::CommitRequest* /*request*/, ::google::spanner::v1::CommitResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_Rollback : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_Rollback() {
      ::grpc::Service::MarkMethodGeneric(12);
    }
    ~WithGenericMethod_Rollback() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Rollback(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::RollbackRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_PartitionQuery : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_PartitionQuery() {
      ::grpc::Service::MarkMethodGeneric(13);
    }
    ~WithGenericMethod_PartitionQuery() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status PartitionQuery(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::PartitionQueryRequest* /*request*/, ::google::spanner::v1::PartitionResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_PartitionRead : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_PartitionRead() {
      ::grpc::Service::MarkMethodGeneric(14);
    }
    ~WithGenericMethod_PartitionRead() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status PartitionRead(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::PartitionReadRequest* /*request*/, ::google::spanner::v1::PartitionResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithRawMethod_CreateSession : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_CreateSession() {
      ::grpc::Service::MarkMethodRaw(0);
    }
    ~WithRawMethod_CreateSession() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateSession(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::CreateSessionRequest* /*request*/, ::google::spanner::v1::Session* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestCreateSession(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(0, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_BatchCreateSessions : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_BatchCreateSessions() {
      ::grpc::Service::MarkMethodRaw(1);
    }
    ~WithRawMethod_BatchCreateSessions() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status BatchCreateSessions(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::BatchCreateSessionsRequest* /*request*/, ::google::spanner::v1::BatchCreateSessionsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestBatchCreateSessions(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(1, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_GetSession : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_GetSession() {
      ::grpc::Service::MarkMethodRaw(2);
    }
    ~WithRawMethod_GetSession() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetSession(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::GetSessionRequest* /*request*/, ::google::spanner::v1::Session* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGetSession(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(2, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_ListSessions : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_ListSessions() {
      ::grpc::Service::MarkMethodRaw(3);
    }
    ~WithRawMethod_ListSessions() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListSessions(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::ListSessionsRequest* /*request*/, ::google::spanner::v1::ListSessionsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestListSessions(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(3, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_DeleteSession : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_DeleteSession() {
      ::grpc::Service::MarkMethodRaw(4);
    }
    ~WithRawMethod_DeleteSession() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteSession(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::DeleteSessionRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestDeleteSession(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(4, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_ExecuteSql : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_ExecuteSql() {
      ::grpc::Service::MarkMethodRaw(5);
    }
    ~WithRawMethod_ExecuteSql() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ExecuteSql(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::ExecuteSqlRequest* /*request*/, ::google::spanner::v1::ResultSet* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestExecuteSql(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(5, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_ExecuteStreamingSql : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_ExecuteStreamingSql() {
      ::grpc::Service::MarkMethodRaw(6);
    }
    ~WithRawMethod_ExecuteStreamingSql() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ExecuteStreamingSql(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::ExecuteSqlRequest* /*request*/, ::grpc::ServerWriter< ::google::spanner::v1::PartialResultSet>* /*writer*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestExecuteStreamingSql(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncWriter< ::grpc::ByteBuffer>* writer, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncServerStreaming(6, context, request, writer, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_ExecuteBatchDml : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_ExecuteBatchDml() {
      ::grpc::Service::MarkMethodRaw(7);
    }
    ~WithRawMethod_ExecuteBatchDml() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ExecuteBatchDml(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::ExecuteBatchDmlRequest* /*request*/, ::google::spanner::v1::ExecuteBatchDmlResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestExecuteBatchDml(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(7, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_Read : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_Read() {
      ::grpc::Service::MarkMethodRaw(8);
    }
    ~WithRawMethod_Read() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Read(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::ReadRequest* /*request*/, ::google::spanner::v1::ResultSet* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestRead(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(8, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_StreamingRead : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_StreamingRead() {
      ::grpc::Service::MarkMethodRaw(9);
    }
    ~WithRawMethod_StreamingRead() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status StreamingRead(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::ReadRequest* /*request*/, ::grpc::ServerWriter< ::google::spanner::v1::PartialResultSet>* /*writer*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestStreamingRead(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncWriter< ::grpc::ByteBuffer>* writer, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncServerStreaming(9, context, request, writer, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_BeginTransaction : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_BeginTransaction() {
      ::grpc::Service::MarkMethodRaw(10);
    }
    ~WithRawMethod_BeginTransaction() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status BeginTransaction(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::BeginTransactionRequest* /*request*/, ::google::spanner::v1::Transaction* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestBeginTransaction(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(10, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_Commit : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_Commit() {
      ::grpc::Service::MarkMethodRaw(11);
    }
    ~WithRawMethod_Commit() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Commit(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::CommitRequest* /*request*/, ::google::spanner::v1::CommitResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestCommit(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(11, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_Rollback : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_Rollback() {
      ::grpc::Service::MarkMethodRaw(12);
    }
    ~WithRawMethod_Rollback() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Rollback(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::RollbackRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestRollback(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(12, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_PartitionQuery : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_PartitionQuery() {
      ::grpc::Service::MarkMethodRaw(13);
    }
    ~WithRawMethod_PartitionQuery() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status PartitionQuery(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::PartitionQueryRequest* /*request*/, ::google::spanner::v1::PartitionResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestPartitionQuery(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(13, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_PartitionRead : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_PartitionRead() {
      ::grpc::Service::MarkMethodRaw(14);
    }
    ~WithRawMethod_PartitionRead() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status PartitionRead(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::PartitionReadRequest* /*request*/, ::google::spanner::v1::PartitionResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestPartitionRead(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(14, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_CreateSession : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_CreateSession() {
      ::grpc::Service::MarkMethodRawCallback(0,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->CreateSession(context, request, response); }));
    }
    ~WithRawCallbackMethod_CreateSession() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateSession(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::CreateSessionRequest* /*request*/, ::google::spanner::v1::Session* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* CreateSession(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_BatchCreateSessions : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_BatchCreateSessions() {
      ::grpc::Service::MarkMethodRawCallback(1,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->BatchCreateSessions(context, request, response); }));
    }
    ~WithRawCallbackMethod_BatchCreateSessions() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status BatchCreateSessions(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::BatchCreateSessionsRequest* /*request*/, ::google::spanner::v1::BatchCreateSessionsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* BatchCreateSessions(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_GetSession : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_GetSession() {
      ::grpc::Service::MarkMethodRawCallback(2,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->GetSession(context, request, response); }));
    }
    ~WithRawCallbackMethod_GetSession() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetSession(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::GetSessionRequest* /*request*/, ::google::spanner::v1::Session* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* GetSession(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_ListSessions : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_ListSessions() {
      ::grpc::Service::MarkMethodRawCallback(3,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->ListSessions(context, request, response); }));
    }
    ~WithRawCallbackMethod_ListSessions() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListSessions(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::ListSessionsRequest* /*request*/, ::google::spanner::v1::ListSessionsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* ListSessions(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_DeleteSession : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_DeleteSession() {
      ::grpc::Service::MarkMethodRawCallback(4,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->DeleteSession(context, request, response); }));
    }
    ~WithRawCallbackMethod_DeleteSession() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteSession(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::DeleteSessionRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* DeleteSession(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_ExecuteSql : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_ExecuteSql() {
      ::grpc::Service::MarkMethodRawCallback(5,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->ExecuteSql(context, request, response); }));
    }
    ~WithRawCallbackMethod_ExecuteSql() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ExecuteSql(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::ExecuteSqlRequest* /*request*/, ::google::spanner::v1::ResultSet* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* ExecuteSql(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_ExecuteStreamingSql : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_ExecuteStreamingSql() {
      ::grpc::Service::MarkMethodRawCallback(6,
          new ::grpc::internal::CallbackServerStreamingHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const::grpc::ByteBuffer* request) { return this->ExecuteStreamingSql(context, request); }));
    }
    ~WithRawCallbackMethod_ExecuteStreamingSql() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ExecuteStreamingSql(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::ExecuteSqlRequest* /*request*/, ::grpc::ServerWriter< ::google::spanner::v1::PartialResultSet>* /*writer*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerWriteReactor< ::grpc::ByteBuffer>* ExecuteStreamingSql(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_ExecuteBatchDml : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_ExecuteBatchDml() {
      ::grpc::Service::MarkMethodRawCallback(7,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->ExecuteBatchDml(context, request, response); }));
    }
    ~WithRawCallbackMethod_ExecuteBatchDml() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ExecuteBatchDml(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::ExecuteBatchDmlRequest* /*request*/, ::google::spanner::v1::ExecuteBatchDmlResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* ExecuteBatchDml(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_Read : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_Read() {
      ::grpc::Service::MarkMethodRawCallback(8,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->Read(context, request, response); }));
    }
    ~WithRawCallbackMethod_Read() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Read(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::ReadRequest* /*request*/, ::google::spanner::v1::ResultSet* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* Read(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_StreamingRead : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_StreamingRead() {
      ::grpc::Service::MarkMethodRawCallback(9,
          new ::grpc::internal::CallbackServerStreamingHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const::grpc::ByteBuffer* request) { return this->StreamingRead(context, request); }));
    }
    ~WithRawCallbackMethod_StreamingRead() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status StreamingRead(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::ReadRequest* /*request*/, ::grpc::ServerWriter< ::google::spanner::v1::PartialResultSet>* /*writer*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerWriteReactor< ::grpc::ByteBuffer>* StreamingRead(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_BeginTransaction : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_BeginTransaction() {
      ::grpc::Service::MarkMethodRawCallback(10,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->BeginTransaction(context, request, response); }));
    }
    ~WithRawCallbackMethod_BeginTransaction() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status BeginTransaction(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::BeginTransactionRequest* /*request*/, ::google::spanner::v1::Transaction* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* BeginTransaction(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_Commit : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_Commit() {
      ::grpc::Service::MarkMethodRawCallback(11,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->Commit(context, request, response); }));
    }
    ~WithRawCallbackMethod_Commit() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Commit(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::CommitRequest* /*request*/, ::google::spanner::v1::CommitResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* Commit(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_Rollback : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_Rollback() {
      ::grpc::Service::MarkMethodRawCallback(12,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->Rollback(context, request, response); }));
    }
    ~WithRawCallbackMethod_Rollback() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Rollback(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::RollbackRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* Rollback(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_PartitionQuery : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_PartitionQuery() {
      ::grpc::Service::MarkMethodRawCallback(13,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->PartitionQuery(context, request, response); }));
    }
    ~WithRawCallbackMethod_PartitionQuery() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status PartitionQuery(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::PartitionQueryRequest* /*request*/, ::google::spanner::v1::PartitionResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* PartitionQuery(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_PartitionRead : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_PartitionRead() {
      ::grpc::Service::MarkMethodRawCallback(14,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->PartitionRead(context, request, response); }));
    }
    ~WithRawCallbackMethod_PartitionRead() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status PartitionRead(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::PartitionReadRequest* /*request*/, ::google::spanner::v1::PartitionResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* PartitionRead(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_CreateSession : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_CreateSession() {
      ::grpc::Service::MarkMethodStreamed(0,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::spanner::v1::CreateSessionRequest, ::google::spanner::v1::Session>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::spanner::v1::CreateSessionRequest, ::google::spanner::v1::Session>* streamer) {
                       return this->StreamedCreateSession(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_CreateSession() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status CreateSession(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::CreateSessionRequest* /*request*/, ::google::spanner::v1::Session* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedCreateSession(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::spanner::v1::CreateSessionRequest,::google::spanner::v1::Session>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_BatchCreateSessions : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_BatchCreateSessions() {
      ::grpc::Service::MarkMethodStreamed(1,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::spanner::v1::BatchCreateSessionsRequest, ::google::spanner::v1::BatchCreateSessionsResponse>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::spanner::v1::BatchCreateSessionsRequest, ::google::spanner::v1::BatchCreateSessionsResponse>* streamer) {
                       return this->StreamedBatchCreateSessions(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_BatchCreateSessions() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status BatchCreateSessions(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::BatchCreateSessionsRequest* /*request*/, ::google::spanner::v1::BatchCreateSessionsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedBatchCreateSessions(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::spanner::v1::BatchCreateSessionsRequest,::google::spanner::v1::BatchCreateSessionsResponse>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_GetSession : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_GetSession() {
      ::grpc::Service::MarkMethodStreamed(2,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::spanner::v1::GetSessionRequest, ::google::spanner::v1::Session>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::spanner::v1::GetSessionRequest, ::google::spanner::v1::Session>* streamer) {
                       return this->StreamedGetSession(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_GetSession() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status GetSession(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::GetSessionRequest* /*request*/, ::google::spanner::v1::Session* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedGetSession(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::spanner::v1::GetSessionRequest,::google::spanner::v1::Session>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_ListSessions : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_ListSessions() {
      ::grpc::Service::MarkMethodStreamed(3,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::spanner::v1::ListSessionsRequest, ::google::spanner::v1::ListSessionsResponse>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::spanner::v1::ListSessionsRequest, ::google::spanner::v1::ListSessionsResponse>* streamer) {
                       return this->StreamedListSessions(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_ListSessions() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status ListSessions(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::ListSessionsRequest* /*request*/, ::google::spanner::v1::ListSessionsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedListSessions(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::spanner::v1::ListSessionsRequest,::google::spanner::v1::ListSessionsResponse>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_DeleteSession : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_DeleteSession() {
      ::grpc::Service::MarkMethodStreamed(4,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::spanner::v1::DeleteSessionRequest, ::google::protobuf::Empty>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::spanner::v1::DeleteSessionRequest, ::google::protobuf::Empty>* streamer) {
                       return this->StreamedDeleteSession(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_DeleteSession() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status DeleteSession(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::DeleteSessionRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedDeleteSession(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::spanner::v1::DeleteSessionRequest,::google::protobuf::Empty>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_ExecuteSql : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_ExecuteSql() {
      ::grpc::Service::MarkMethodStreamed(5,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::spanner::v1::ExecuteSqlRequest, ::google::spanner::v1::ResultSet>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::spanner::v1::ExecuteSqlRequest, ::google::spanner::v1::ResultSet>* streamer) {
                       return this->StreamedExecuteSql(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_ExecuteSql() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status ExecuteSql(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::ExecuteSqlRequest* /*request*/, ::google::spanner::v1::ResultSet* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedExecuteSql(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::spanner::v1::ExecuteSqlRequest,::google::spanner::v1::ResultSet>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_ExecuteBatchDml : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_ExecuteBatchDml() {
      ::grpc::Service::MarkMethodStreamed(7,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::spanner::v1::ExecuteBatchDmlRequest, ::google::spanner::v1::ExecuteBatchDmlResponse>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::spanner::v1::ExecuteBatchDmlRequest, ::google::spanner::v1::ExecuteBatchDmlResponse>* streamer) {
                       return this->StreamedExecuteBatchDml(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_ExecuteBatchDml() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status ExecuteBatchDml(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::ExecuteBatchDmlRequest* /*request*/, ::google::spanner::v1::ExecuteBatchDmlResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedExecuteBatchDml(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::spanner::v1::ExecuteBatchDmlRequest,::google::spanner::v1::ExecuteBatchDmlResponse>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_Read : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_Read() {
      ::grpc::Service::MarkMethodStreamed(8,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::spanner::v1::ReadRequest, ::google::spanner::v1::ResultSet>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::spanner::v1::ReadRequest, ::google::spanner::v1::ResultSet>* streamer) {
                       return this->StreamedRead(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_Read() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status Read(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::ReadRequest* /*request*/, ::google::spanner::v1::ResultSet* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedRead(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::spanner::v1::ReadRequest,::google::spanner::v1::ResultSet>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_BeginTransaction : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_BeginTransaction() {
      ::grpc::Service::MarkMethodStreamed(10,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::spanner::v1::BeginTransactionRequest, ::google::spanner::v1::Transaction>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::spanner::v1::BeginTransactionRequest, ::google::spanner::v1::Transaction>* streamer) {
                       return this->StreamedBeginTransaction(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_BeginTransaction() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status BeginTransaction(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::BeginTransactionRequest* /*request*/, ::google::spanner::v1::Transaction* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedBeginTransaction(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::spanner::v1::BeginTransactionRequest,::google::spanner::v1::Transaction>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_Commit : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_Commit() {
      ::grpc::Service::MarkMethodStreamed(11,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::spanner::v1::CommitRequest, ::google::spanner::v1::CommitResponse>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::spanner::v1::CommitRequest, ::google::spanner::v1::CommitResponse>* streamer) {
                       return this->StreamedCommit(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_Commit() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status Commit(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::CommitRequest* /*request*/, ::google::spanner::v1::CommitResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedCommit(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::spanner::v1::CommitRequest,::google::spanner::v1::CommitResponse>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_Rollback : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_Rollback() {
      ::grpc::Service::MarkMethodStreamed(12,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::spanner::v1::RollbackRequest, ::google::protobuf::Empty>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::spanner::v1::RollbackRequest, ::google::protobuf::Empty>* streamer) {
                       return this->StreamedRollback(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_Rollback() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status Rollback(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::RollbackRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedRollback(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::spanner::v1::RollbackRequest,::google::protobuf::Empty>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_PartitionQuery : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_PartitionQuery() {
      ::grpc::Service::MarkMethodStreamed(13,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::spanner::v1::PartitionQueryRequest, ::google::spanner::v1::PartitionResponse>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::spanner::v1::PartitionQueryRequest, ::google::spanner::v1::PartitionResponse>* streamer) {
                       return this->StreamedPartitionQuery(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_PartitionQuery() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status PartitionQuery(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::PartitionQueryRequest* /*request*/, ::google::spanner::v1::PartitionResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedPartitionQuery(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::spanner::v1::PartitionQueryRequest,::google::spanner::v1::PartitionResponse>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_PartitionRead : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_PartitionRead() {
      ::grpc::Service::MarkMethodStreamed(14,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::spanner::v1::PartitionReadRequest, ::google::spanner::v1::PartitionResponse>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::spanner::v1::PartitionReadRequest, ::google::spanner::v1::PartitionResponse>* streamer) {
                       return this->StreamedPartitionRead(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_PartitionRead() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status PartitionRead(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::PartitionReadRequest* /*request*/, ::google::spanner::v1::PartitionResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedPartitionRead(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::spanner::v1::PartitionReadRequest,::google::spanner::v1::PartitionResponse>* server_unary_streamer) = 0;
  };
  typedef WithStreamedUnaryMethod_CreateSession<WithStreamedUnaryMethod_BatchCreateSessions<WithStreamedUnaryMethod_GetSession<WithStreamedUnaryMethod_ListSessions<WithStreamedUnaryMethod_DeleteSession<WithStreamedUnaryMethod_ExecuteSql<WithStreamedUnaryMethod_ExecuteBatchDml<WithStreamedUnaryMethod_Read<WithStreamedUnaryMethod_BeginTransaction<WithStreamedUnaryMethod_Commit<WithStreamedUnaryMethod_Rollback<WithStreamedUnaryMethod_PartitionQuery<WithStreamedUnaryMethod_PartitionRead<Service > > > > > > > > > > > > > StreamedUnaryService;
  template <class BaseClass>
  class WithSplitStreamingMethod_ExecuteStreamingSql : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithSplitStreamingMethod_ExecuteStreamingSql() {
      ::grpc::Service::MarkMethodStreamed(6,
        new ::grpc::internal::SplitServerStreamingHandler<
          ::google::spanner::v1::ExecuteSqlRequest, ::google::spanner::v1::PartialResultSet>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerSplitStreamer<
                     ::google::spanner::v1::ExecuteSqlRequest, ::google::spanner::v1::PartialResultSet>* streamer) {
                       return this->StreamedExecuteStreamingSql(context,
                         streamer);
                  }));
    }
    ~WithSplitStreamingMethod_ExecuteStreamingSql() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status ExecuteStreamingSql(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::ExecuteSqlRequest* /*request*/, ::grpc::ServerWriter< ::google::spanner::v1::PartialResultSet>* /*writer*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with split streamed
    virtual ::grpc::Status StreamedExecuteStreamingSql(::grpc::ServerContext* context, ::grpc::ServerSplitStreamer< ::google::spanner::v1::ExecuteSqlRequest,::google::spanner::v1::PartialResultSet>* server_split_streamer) = 0;
  };
  template <class BaseClass>
  class WithSplitStreamingMethod_StreamingRead : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithSplitStreamingMethod_StreamingRead() {
      ::grpc::Service::MarkMethodStreamed(9,
        new ::grpc::internal::SplitServerStreamingHandler<
          ::google::spanner::v1::ReadRequest, ::google::spanner::v1::PartialResultSet>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerSplitStreamer<
                     ::google::spanner::v1::ReadRequest, ::google::spanner::v1::PartialResultSet>* streamer) {
                       return this->StreamedStreamingRead(context,
                         streamer);
                  }));
    }
    ~WithSplitStreamingMethod_StreamingRead() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status StreamingRead(::grpc::ServerContext* /*context*/, const ::google::spanner::v1::ReadRequest* /*request*/, ::grpc::ServerWriter< ::google::spanner::v1::PartialResultSet>* /*writer*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with split streamed
    virtual ::grpc::Status StreamedStreamingRead(::grpc::ServerContext* context, ::grpc::ServerSplitStreamer< ::google::spanner::v1::ReadRequest,::google::spanner::v1::PartialResultSet>* server_split_streamer) = 0;
  };
  typedef WithSplitStreamingMethod_ExecuteStreamingSql<WithSplitStreamingMethod_StreamingRead<Service > > SplitStreamedService;
  typedef WithStreamedUnaryMethod_CreateSession<WithStreamedUnaryMethod_BatchCreateSessions<WithStreamedUnaryMethod_GetSession<WithStreamedUnaryMethod_ListSessions<WithStreamedUnaryMethod_DeleteSession<WithStreamedUnaryMethod_ExecuteSql<WithSplitStreamingMethod_ExecuteStreamingSql<WithStreamedUnaryMethod_ExecuteBatchDml<WithStreamedUnaryMethod_Read<WithSplitStreamingMethod_StreamingRead<WithStreamedUnaryMethod_BeginTransaction<WithStreamedUnaryMethod_Commit<WithStreamedUnaryMethod_Rollback<WithStreamedUnaryMethod_PartitionQuery<WithStreamedUnaryMethod_PartitionRead<Service > > > > > > > > > > > > > > > StreamedService;
};

}  // namespace v1
}  // namespace spanner
}  // namespace google


#endif  // GRPC_google_2fspanner_2fv1_2fspanner_2eproto__INCLUDED
