// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/bigquery/datatransfer/v1/datatransfer.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BIGQUERY_DATA_TRANSFER_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BIGQUERY_DATA_TRANSFER_CONNECTION_H

#include "google/cloud/bigquery/data_transfer_connection_idempotency_policy.h"
#include "google/cloud/bigquery/internal/data_transfer_retry_traits.h"
#include "google/cloud/bigquery/internal/data_transfer_stub.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/options.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace bigquery {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using DataTransferServiceRetryPolicy =
    ::google::cloud::internal::TraitBasedRetryPolicy<
        bigquery_internal::DataTransferServiceRetryTraits>;

using DataTransferServiceLimitedTimeRetryPolicy =
    ::google::cloud::internal::LimitedTimeRetryPolicy<
        bigquery_internal::DataTransferServiceRetryTraits>;

using DataTransferServiceLimitedErrorCountRetryPolicy =
    ::google::cloud::internal::LimitedErrorCountRetryPolicy<
        bigquery_internal::DataTransferServiceRetryTraits>;

class DataTransferServiceConnection {
 public:
  virtual ~DataTransferServiceConnection() = 0;

  virtual Options options() { return Options{}; }

  virtual StatusOr<google::cloud::bigquery::datatransfer::v1::DataSource>
  GetDataSource(
      google::cloud::bigquery::datatransfer::v1::GetDataSourceRequest const&
          request);

  virtual StreamRange<google::cloud::bigquery::datatransfer::v1::DataSource>
  ListDataSources(
      google::cloud::bigquery::datatransfer::v1::ListDataSourcesRequest
          request);

  virtual StatusOr<google::cloud::bigquery::datatransfer::v1::TransferConfig>
  CreateTransferConfig(google::cloud::bigquery::datatransfer::v1::
                           CreateTransferConfigRequest const& request);

  virtual StatusOr<google::cloud::bigquery::datatransfer::v1::TransferConfig>
  UpdateTransferConfig(google::cloud::bigquery::datatransfer::v1::
                           UpdateTransferConfigRequest const& request);

  virtual Status DeleteTransferConfig(
      google::cloud::bigquery::datatransfer::v1::
          DeleteTransferConfigRequest const& request);

  virtual StatusOr<google::cloud::bigquery::datatransfer::v1::TransferConfig>
  GetTransferConfig(
      google::cloud::bigquery::datatransfer::v1::GetTransferConfigRequest const&
          request);

  virtual StreamRange<google::cloud::bigquery::datatransfer::v1::TransferConfig>
  ListTransferConfigs(
      google::cloud::bigquery::datatransfer::v1::ListTransferConfigsRequest
          request);

  virtual StatusOr<
      google::cloud::bigquery::datatransfer::v1::ScheduleTransferRunsResponse>
  ScheduleTransferRuns(google::cloud::bigquery::datatransfer::v1::
                           ScheduleTransferRunsRequest const& request);

  virtual StatusOr<google::cloud::bigquery::datatransfer::v1::
                       StartManualTransferRunsResponse>
  StartManualTransferRuns(google::cloud::bigquery::datatransfer::v1::
                              StartManualTransferRunsRequest const& request);

  virtual StatusOr<google::cloud::bigquery::datatransfer::v1::TransferRun>
  GetTransferRun(
      google::cloud::bigquery::datatransfer::v1::GetTransferRunRequest const&
          request);

  virtual Status DeleteTransferRun(
      google::cloud::bigquery::datatransfer::v1::DeleteTransferRunRequest const&
          request);

  virtual StreamRange<google::cloud::bigquery::datatransfer::v1::TransferRun>
  ListTransferRuns(
      google::cloud::bigquery::datatransfer::v1::ListTransferRunsRequest
          request);

  virtual StreamRange<
      google::cloud::bigquery::datatransfer::v1::TransferMessage>
  ListTransferLogs(
      google::cloud::bigquery::datatransfer::v1::ListTransferLogsRequest
          request);

  virtual StatusOr<
      google::cloud::bigquery::datatransfer::v1::CheckValidCredsResponse>
  CheckValidCreds(
      google::cloud::bigquery::datatransfer::v1::CheckValidCredsRequest const&
          request);

  virtual Status EnrollDataSources(
      google::cloud::bigquery::datatransfer::v1::EnrollDataSourcesRequest const&
          request);
};

std::shared_ptr<DataTransferServiceConnection>
MakeDataTransferServiceConnection(Options options = {});

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace bigquery
}  // namespace cloud
}  // namespace google

namespace google {
namespace cloud {
namespace bigquery_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

std::shared_ptr<bigquery::DataTransferServiceConnection>
MakeDataTransferServiceConnection(std::shared_ptr<DataTransferServiceStub> stub,
                                  Options options);

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace bigquery_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BIGQUERY_DATA_TRANSFER_CONNECTION_H
