// Generated by the gRPC C++ plugin.
// If you make any local change, they will be lost.
// source: google/monitoring/v3/uptime_service.proto
// Original file comments:
// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
#ifndef GRPC_google_2fmonitoring_2fv3_2fuptime_5fservice_2eproto__INCLUDED
#define GRPC_google_2fmonitoring_2fv3_2fuptime_5fservice_2eproto__INCLUDED

#include "google/monitoring/v3/uptime_service.pb.h"

#include <functional>
#include <grpcpp/impl/codegen/async_generic_service.h>
#include <grpcpp/impl/codegen/async_stream.h>
#include <grpcpp/impl/codegen/async_unary_call.h>
#include <grpcpp/impl/codegen/client_callback.h>
#include <grpcpp/impl/codegen/client_context.h>
#include <grpcpp/impl/codegen/completion_queue.h>
#include <grpcpp/impl/codegen/message_allocator.h>
#include <grpcpp/impl/codegen/method_handler.h>
#include <grpcpp/impl/codegen/proto_utils.h>
#include <grpcpp/impl/codegen/rpc_method.h>
#include <grpcpp/impl/codegen/server_callback.h>
#include <grpcpp/impl/codegen/server_callback_handlers.h>
#include <grpcpp/impl/codegen/server_context.h>
#include <grpcpp/impl/codegen/service_type.h>
#include <grpcpp/impl/codegen/status.h>
#include <grpcpp/impl/codegen/stub_options.h>
#include <grpcpp/impl/codegen/sync_stream.h>

namespace google {
namespace monitoring {
namespace v3 {

// The UptimeCheckService API is used to manage (list, create, delete, edit)
// Uptime check configurations in the Stackdriver Monitoring product. An Uptime
// check is a piece of configuration that determines which resources and
// services to monitor for availability. These configurations can also be
// configured interactively by navigating to the [Cloud Console]
// (http://console.cloud.google.com), selecting the appropriate project,
// clicking on "Monitoring" on the left-hand side to navigate to Stackdriver,
// and then clicking on "Uptime".
class UptimeCheckService final {
 public:
  static constexpr char const* service_full_name() {
    return "google.monitoring.v3.UptimeCheckService";
  }
  class StubInterface {
   public:
    virtual ~StubInterface() {}
    // Lists the existing valid Uptime check configurations for the project
    // (leaving out any invalid configurations).
    virtual ::grpc::Status ListUptimeCheckConfigs(::grpc::ClientContext* context, const ::google::monitoring::v3::ListUptimeCheckConfigsRequest& request, ::google::monitoring::v3::ListUptimeCheckConfigsResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::monitoring::v3::ListUptimeCheckConfigsResponse>> AsyncListUptimeCheckConfigs(::grpc::ClientContext* context, const ::google::monitoring::v3::ListUptimeCheckConfigsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::monitoring::v3::ListUptimeCheckConfigsResponse>>(AsyncListUptimeCheckConfigsRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::monitoring::v3::ListUptimeCheckConfigsResponse>> PrepareAsyncListUptimeCheckConfigs(::grpc::ClientContext* context, const ::google::monitoring::v3::ListUptimeCheckConfigsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::monitoring::v3::ListUptimeCheckConfigsResponse>>(PrepareAsyncListUptimeCheckConfigsRaw(context, request, cq));
    }
    // Gets a single Uptime check configuration.
    virtual ::grpc::Status GetUptimeCheckConfig(::grpc::ClientContext* context, const ::google::monitoring::v3::GetUptimeCheckConfigRequest& request, ::google::monitoring::v3::UptimeCheckConfig* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::monitoring::v3::UptimeCheckConfig>> AsyncGetUptimeCheckConfig(::grpc::ClientContext* context, const ::google::monitoring::v3::GetUptimeCheckConfigRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::monitoring::v3::UptimeCheckConfig>>(AsyncGetUptimeCheckConfigRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::monitoring::v3::UptimeCheckConfig>> PrepareAsyncGetUptimeCheckConfig(::grpc::ClientContext* context, const ::google::monitoring::v3::GetUptimeCheckConfigRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::monitoring::v3::UptimeCheckConfig>>(PrepareAsyncGetUptimeCheckConfigRaw(context, request, cq));
    }
    // Creates a new Uptime check configuration.
    virtual ::grpc::Status CreateUptimeCheckConfig(::grpc::ClientContext* context, const ::google::monitoring::v3::CreateUptimeCheckConfigRequest& request, ::google::monitoring::v3::UptimeCheckConfig* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::monitoring::v3::UptimeCheckConfig>> AsyncCreateUptimeCheckConfig(::grpc::ClientContext* context, const ::google::monitoring::v3::CreateUptimeCheckConfigRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::monitoring::v3::UptimeCheckConfig>>(AsyncCreateUptimeCheckConfigRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::monitoring::v3::UptimeCheckConfig>> PrepareAsyncCreateUptimeCheckConfig(::grpc::ClientContext* context, const ::google::monitoring::v3::CreateUptimeCheckConfigRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::monitoring::v3::UptimeCheckConfig>>(PrepareAsyncCreateUptimeCheckConfigRaw(context, request, cq));
    }
    // Updates an Uptime check configuration. You can either replace the entire
    // configuration with a new one or replace only certain fields in the current
    // configuration by specifying the fields to be updated via `updateMask`.
    // Returns the updated configuration.
    virtual ::grpc::Status UpdateUptimeCheckConfig(::grpc::ClientContext* context, const ::google::monitoring::v3::UpdateUptimeCheckConfigRequest& request, ::google::monitoring::v3::UptimeCheckConfig* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::monitoring::v3::UptimeCheckConfig>> AsyncUpdateUptimeCheckConfig(::grpc::ClientContext* context, const ::google::monitoring::v3::UpdateUptimeCheckConfigRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::monitoring::v3::UptimeCheckConfig>>(AsyncUpdateUptimeCheckConfigRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::monitoring::v3::UptimeCheckConfig>> PrepareAsyncUpdateUptimeCheckConfig(::grpc::ClientContext* context, const ::google::monitoring::v3::UpdateUptimeCheckConfigRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::monitoring::v3::UptimeCheckConfig>>(PrepareAsyncUpdateUptimeCheckConfigRaw(context, request, cq));
    }
    // Deletes an Uptime check configuration. Note that this method will fail
    // if the Uptime check configuration is referenced by an alert policy or
    // other dependent configs that would be rendered invalid by the deletion.
    virtual ::grpc::Status DeleteUptimeCheckConfig(::grpc::ClientContext* context, const ::google::monitoring::v3::DeleteUptimeCheckConfigRequest& request, ::google::protobuf::Empty* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>> AsyncDeleteUptimeCheckConfig(::grpc::ClientContext* context, const ::google::monitoring::v3::DeleteUptimeCheckConfigRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>>(AsyncDeleteUptimeCheckConfigRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>> PrepareAsyncDeleteUptimeCheckConfig(::grpc::ClientContext* context, const ::google::monitoring::v3::DeleteUptimeCheckConfigRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>>(PrepareAsyncDeleteUptimeCheckConfigRaw(context, request, cq));
    }
    // Returns the list of IP addresses that checkers run from
    virtual ::grpc::Status ListUptimeCheckIps(::grpc::ClientContext* context, const ::google::monitoring::v3::ListUptimeCheckIpsRequest& request, ::google::monitoring::v3::ListUptimeCheckIpsResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::monitoring::v3::ListUptimeCheckIpsResponse>> AsyncListUptimeCheckIps(::grpc::ClientContext* context, const ::google::monitoring::v3::ListUptimeCheckIpsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::monitoring::v3::ListUptimeCheckIpsResponse>>(AsyncListUptimeCheckIpsRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::monitoring::v3::ListUptimeCheckIpsResponse>> PrepareAsyncListUptimeCheckIps(::grpc::ClientContext* context, const ::google::monitoring::v3::ListUptimeCheckIpsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::monitoring::v3::ListUptimeCheckIpsResponse>>(PrepareAsyncListUptimeCheckIpsRaw(context, request, cq));
    }
    class async_interface {
     public:
      virtual ~async_interface() {}
      // Lists the existing valid Uptime check configurations for the project
      // (leaving out any invalid configurations).
      virtual void ListUptimeCheckConfigs(::grpc::ClientContext* context, const ::google::monitoring::v3::ListUptimeCheckConfigsRequest* request, ::google::monitoring::v3::ListUptimeCheckConfigsResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void ListUptimeCheckConfigs(::grpc::ClientContext* context, const ::google::monitoring::v3::ListUptimeCheckConfigsRequest* request, ::google::monitoring::v3::ListUptimeCheckConfigsResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Gets a single Uptime check configuration.
      virtual void GetUptimeCheckConfig(::grpc::ClientContext* context, const ::google::monitoring::v3::GetUptimeCheckConfigRequest* request, ::google::monitoring::v3::UptimeCheckConfig* response, std::function<void(::grpc::Status)>) = 0;
      virtual void GetUptimeCheckConfig(::grpc::ClientContext* context, const ::google::monitoring::v3::GetUptimeCheckConfigRequest* request, ::google::monitoring::v3::UptimeCheckConfig* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Creates a new Uptime check configuration.
      virtual void CreateUptimeCheckConfig(::grpc::ClientContext* context, const ::google::monitoring::v3::CreateUptimeCheckConfigRequest* request, ::google::monitoring::v3::UptimeCheckConfig* response, std::function<void(::grpc::Status)>) = 0;
      virtual void CreateUptimeCheckConfig(::grpc::ClientContext* context, const ::google::monitoring::v3::CreateUptimeCheckConfigRequest* request, ::google::monitoring::v3::UptimeCheckConfig* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Updates an Uptime check configuration. You can either replace the entire
      // configuration with a new one or replace only certain fields in the current
      // configuration by specifying the fields to be updated via `updateMask`.
      // Returns the updated configuration.
      virtual void UpdateUptimeCheckConfig(::grpc::ClientContext* context, const ::google::monitoring::v3::UpdateUptimeCheckConfigRequest* request, ::google::monitoring::v3::UptimeCheckConfig* response, std::function<void(::grpc::Status)>) = 0;
      virtual void UpdateUptimeCheckConfig(::grpc::ClientContext* context, const ::google::monitoring::v3::UpdateUptimeCheckConfigRequest* request, ::google::monitoring::v3::UptimeCheckConfig* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Deletes an Uptime check configuration. Note that this method will fail
      // if the Uptime check configuration is referenced by an alert policy or
      // other dependent configs that would be rendered invalid by the deletion.
      virtual void DeleteUptimeCheckConfig(::grpc::ClientContext* context, const ::google::monitoring::v3::DeleteUptimeCheckConfigRequest* request, ::google::protobuf::Empty* response, std::function<void(::grpc::Status)>) = 0;
      virtual void DeleteUptimeCheckConfig(::grpc::ClientContext* context, const ::google::monitoring::v3::DeleteUptimeCheckConfigRequest* request, ::google::protobuf::Empty* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Returns the list of IP addresses that checkers run from
      virtual void ListUptimeCheckIps(::grpc::ClientContext* context, const ::google::monitoring::v3::ListUptimeCheckIpsRequest* request, ::google::monitoring::v3::ListUptimeCheckIpsResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void ListUptimeCheckIps(::grpc::ClientContext* context, const ::google::monitoring::v3::ListUptimeCheckIpsRequest* request, ::google::monitoring::v3::ListUptimeCheckIpsResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
    };
    typedef class async_interface experimental_async_interface;
    virtual class async_interface* async() { return nullptr; }
    class async_interface* experimental_async() { return async(); }
   private:
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::monitoring::v3::ListUptimeCheckConfigsResponse>* AsyncListUptimeCheckConfigsRaw(::grpc::ClientContext* context, const ::google::monitoring::v3::ListUptimeCheckConfigsRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::monitoring::v3::ListUptimeCheckConfigsResponse>* PrepareAsyncListUptimeCheckConfigsRaw(::grpc::ClientContext* context, const ::google::monitoring::v3::ListUptimeCheckConfigsRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::monitoring::v3::UptimeCheckConfig>* AsyncGetUptimeCheckConfigRaw(::grpc::ClientContext* context, const ::google::monitoring::v3::GetUptimeCheckConfigRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::monitoring::v3::UptimeCheckConfig>* PrepareAsyncGetUptimeCheckConfigRaw(::grpc::ClientContext* context, const ::google::monitoring::v3::GetUptimeCheckConfigRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::monitoring::v3::UptimeCheckConfig>* AsyncCreateUptimeCheckConfigRaw(::grpc::ClientContext* context, const ::google::monitoring::v3::CreateUptimeCheckConfigRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::monitoring::v3::UptimeCheckConfig>* PrepareAsyncCreateUptimeCheckConfigRaw(::grpc::ClientContext* context, const ::google::monitoring::v3::CreateUptimeCheckConfigRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::monitoring::v3::UptimeCheckConfig>* AsyncUpdateUptimeCheckConfigRaw(::grpc::ClientContext* context, const ::google::monitoring::v3::UpdateUptimeCheckConfigRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::monitoring::v3::UptimeCheckConfig>* PrepareAsyncUpdateUptimeCheckConfigRaw(::grpc::ClientContext* context, const ::google::monitoring::v3::UpdateUptimeCheckConfigRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>* AsyncDeleteUptimeCheckConfigRaw(::grpc::ClientContext* context, const ::google::monitoring::v3::DeleteUptimeCheckConfigRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>* PrepareAsyncDeleteUptimeCheckConfigRaw(::grpc::ClientContext* context, const ::google::monitoring::v3::DeleteUptimeCheckConfigRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::monitoring::v3::ListUptimeCheckIpsResponse>* AsyncListUptimeCheckIpsRaw(::grpc::ClientContext* context, const ::google::monitoring::v3::ListUptimeCheckIpsRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::monitoring::v3::ListUptimeCheckIpsResponse>* PrepareAsyncListUptimeCheckIpsRaw(::grpc::ClientContext* context, const ::google::monitoring::v3::ListUptimeCheckIpsRequest& request, ::grpc::CompletionQueue* cq) = 0;
  };
  class Stub final : public StubInterface {
   public:
    Stub(const std::shared_ptr< ::grpc::ChannelInterface>& channel, const ::grpc::StubOptions& options = ::grpc::StubOptions());
    ::grpc::Status ListUptimeCheckConfigs(::grpc::ClientContext* context, const ::google::monitoring::v3::ListUptimeCheckConfigsRequest& request, ::google::monitoring::v3::ListUptimeCheckConfigsResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::monitoring::v3::ListUptimeCheckConfigsResponse>> AsyncListUptimeCheckConfigs(::grpc::ClientContext* context, const ::google::monitoring::v3::ListUptimeCheckConfigsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::monitoring::v3::ListUptimeCheckConfigsResponse>>(AsyncListUptimeCheckConfigsRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::monitoring::v3::ListUptimeCheckConfigsResponse>> PrepareAsyncListUptimeCheckConfigs(::grpc::ClientContext* context, const ::google::monitoring::v3::ListUptimeCheckConfigsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::monitoring::v3::ListUptimeCheckConfigsResponse>>(PrepareAsyncListUptimeCheckConfigsRaw(context, request, cq));
    }
    ::grpc::Status GetUptimeCheckConfig(::grpc::ClientContext* context, const ::google::monitoring::v3::GetUptimeCheckConfigRequest& request, ::google::monitoring::v3::UptimeCheckConfig* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::monitoring::v3::UptimeCheckConfig>> AsyncGetUptimeCheckConfig(::grpc::ClientContext* context, const ::google::monitoring::v3::GetUptimeCheckConfigRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::monitoring::v3::UptimeCheckConfig>>(AsyncGetUptimeCheckConfigRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::monitoring::v3::UptimeCheckConfig>> PrepareAsyncGetUptimeCheckConfig(::grpc::ClientContext* context, const ::google::monitoring::v3::GetUptimeCheckConfigRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::monitoring::v3::UptimeCheckConfig>>(PrepareAsyncGetUptimeCheckConfigRaw(context, request, cq));
    }
    ::grpc::Status CreateUptimeCheckConfig(::grpc::ClientContext* context, const ::google::monitoring::v3::CreateUptimeCheckConfigRequest& request, ::google::monitoring::v3::UptimeCheckConfig* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::monitoring::v3::UptimeCheckConfig>> AsyncCreateUptimeCheckConfig(::grpc::ClientContext* context, const ::google::monitoring::v3::CreateUptimeCheckConfigRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::monitoring::v3::UptimeCheckConfig>>(AsyncCreateUptimeCheckConfigRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::monitoring::v3::UptimeCheckConfig>> PrepareAsyncCreateUptimeCheckConfig(::grpc::ClientContext* context, const ::google::monitoring::v3::CreateUptimeCheckConfigRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::monitoring::v3::UptimeCheckConfig>>(PrepareAsyncCreateUptimeCheckConfigRaw(context, request, cq));
    }
    ::grpc::Status UpdateUptimeCheckConfig(::grpc::ClientContext* context, const ::google::monitoring::v3::UpdateUptimeCheckConfigRequest& request, ::google::monitoring::v3::UptimeCheckConfig* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::monitoring::v3::UptimeCheckConfig>> AsyncUpdateUptimeCheckConfig(::grpc::ClientContext* context, const ::google::monitoring::v3::UpdateUptimeCheckConfigRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::monitoring::v3::UptimeCheckConfig>>(AsyncUpdateUptimeCheckConfigRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::monitoring::v3::UptimeCheckConfig>> PrepareAsyncUpdateUptimeCheckConfig(::grpc::ClientContext* context, const ::google::monitoring::v3::UpdateUptimeCheckConfigRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::monitoring::v3::UptimeCheckConfig>>(PrepareAsyncUpdateUptimeCheckConfigRaw(context, request, cq));
    }
    ::grpc::Status DeleteUptimeCheckConfig(::grpc::ClientContext* context, const ::google::monitoring::v3::DeleteUptimeCheckConfigRequest& request, ::google::protobuf::Empty* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>> AsyncDeleteUptimeCheckConfig(::grpc::ClientContext* context, const ::google::monitoring::v3::DeleteUptimeCheckConfigRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>>(AsyncDeleteUptimeCheckConfigRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>> PrepareAsyncDeleteUptimeCheckConfig(::grpc::ClientContext* context, const ::google::monitoring::v3::DeleteUptimeCheckConfigRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>>(PrepareAsyncDeleteUptimeCheckConfigRaw(context, request, cq));
    }
    ::grpc::Status ListUptimeCheckIps(::grpc::ClientContext* context, const ::google::monitoring::v3::ListUptimeCheckIpsRequest& request, ::google::monitoring::v3::ListUptimeCheckIpsResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::monitoring::v3::ListUptimeCheckIpsResponse>> AsyncListUptimeCheckIps(::grpc::ClientContext* context, const ::google::monitoring::v3::ListUptimeCheckIpsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::monitoring::v3::ListUptimeCheckIpsResponse>>(AsyncListUptimeCheckIpsRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::monitoring::v3::ListUptimeCheckIpsResponse>> PrepareAsyncListUptimeCheckIps(::grpc::ClientContext* context, const ::google::monitoring::v3::ListUptimeCheckIpsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::monitoring::v3::ListUptimeCheckIpsResponse>>(PrepareAsyncListUptimeCheckIpsRaw(context, request, cq));
    }
    class async final :
      public StubInterface::async_interface {
     public:
      void ListUptimeCheckConfigs(::grpc::ClientContext* context, const ::google::monitoring::v3::ListUptimeCheckConfigsRequest* request, ::google::monitoring::v3::ListUptimeCheckConfigsResponse* response, std::function<void(::grpc::Status)>) override;
      void ListUptimeCheckConfigs(::grpc::ClientContext* context, const ::google::monitoring::v3::ListUptimeCheckConfigsRequest* request, ::google::monitoring::v3::ListUptimeCheckConfigsResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
      void GetUptimeCheckConfig(::grpc::ClientContext* context, const ::google::monitoring::v3::GetUptimeCheckConfigRequest* request, ::google::monitoring::v3::UptimeCheckConfig* response, std::function<void(::grpc::Status)>) override;
      void GetUptimeCheckConfig(::grpc::ClientContext* context, const ::google::monitoring::v3::GetUptimeCheckConfigRequest* request, ::google::monitoring::v3::UptimeCheckConfig* response, ::grpc::ClientUnaryReactor* reactor) override;
      void CreateUptimeCheckConfig(::grpc::ClientContext* context, const ::google::monitoring::v3::CreateUptimeCheckConfigRequest* request, ::google::monitoring::v3::UptimeCheckConfig* response, std::function<void(::grpc::Status)>) override;
      void CreateUptimeCheckConfig(::grpc::ClientContext* context, const ::google::monitoring::v3::CreateUptimeCheckConfigRequest* request, ::google::monitoring::v3::UptimeCheckConfig* response, ::grpc::ClientUnaryReactor* reactor) override;
      void UpdateUptimeCheckConfig(::grpc::ClientContext* context, const ::google::monitoring::v3::UpdateUptimeCheckConfigRequest* request, ::google::monitoring::v3::UptimeCheckConfig* response, std::function<void(::grpc::Status)>) override;
      void UpdateUptimeCheckConfig(::grpc::ClientContext* context, const ::google::monitoring::v3::UpdateUptimeCheckConfigRequest* request, ::google::monitoring::v3::UptimeCheckConfig* response, ::grpc::ClientUnaryReactor* reactor) override;
      void DeleteUptimeCheckConfig(::grpc::ClientContext* context, const ::google::monitoring::v3::DeleteUptimeCheckConfigRequest* request, ::google::protobuf::Empty* response, std::function<void(::grpc::Status)>) override;
      void DeleteUptimeCheckConfig(::grpc::ClientContext* context, const ::google::monitoring::v3::DeleteUptimeCheckConfigRequest* request, ::google::protobuf::Empty* response, ::grpc::ClientUnaryReactor* reactor) override;
      void ListUptimeCheckIps(::grpc::ClientContext* context, const ::google::monitoring::v3::ListUptimeCheckIpsRequest* request, ::google::monitoring::v3::ListUptimeCheckIpsResponse* response, std::function<void(::grpc::Status)>) override;
      void ListUptimeCheckIps(::grpc::ClientContext* context, const ::google::monitoring::v3::ListUptimeCheckIpsRequest* request, ::google::monitoring::v3::ListUptimeCheckIpsResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
     private:
      friend class Stub;
      explicit async(Stub* stub): stub_(stub) { }
      Stub* stub() { return stub_; }
      Stub* stub_;
    };
    class async* async() override { return &async_stub_; }

   private:
    std::shared_ptr< ::grpc::ChannelInterface> channel_;
    class async async_stub_{this};
    ::grpc::ClientAsyncResponseReader< ::google::monitoring::v3::ListUptimeCheckConfigsResponse>* AsyncListUptimeCheckConfigsRaw(::grpc::ClientContext* context, const ::google::monitoring::v3::ListUptimeCheckConfigsRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::monitoring::v3::ListUptimeCheckConfigsResponse>* PrepareAsyncListUptimeCheckConfigsRaw(::grpc::ClientContext* context, const ::google::monitoring::v3::ListUptimeCheckConfigsRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::monitoring::v3::UptimeCheckConfig>* AsyncGetUptimeCheckConfigRaw(::grpc::ClientContext* context, const ::google::monitoring::v3::GetUptimeCheckConfigRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::monitoring::v3::UptimeCheckConfig>* PrepareAsyncGetUptimeCheckConfigRaw(::grpc::ClientContext* context, const ::google::monitoring::v3::GetUptimeCheckConfigRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::monitoring::v3::UptimeCheckConfig>* AsyncCreateUptimeCheckConfigRaw(::grpc::ClientContext* context, const ::google::monitoring::v3::CreateUptimeCheckConfigRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::monitoring::v3::UptimeCheckConfig>* PrepareAsyncCreateUptimeCheckConfigRaw(::grpc::ClientContext* context, const ::google::monitoring::v3::CreateUptimeCheckConfigRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::monitoring::v3::UptimeCheckConfig>* AsyncUpdateUptimeCheckConfigRaw(::grpc::ClientContext* context, const ::google::monitoring::v3::UpdateUptimeCheckConfigRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::monitoring::v3::UptimeCheckConfig>* PrepareAsyncUpdateUptimeCheckConfigRaw(::grpc::ClientContext* context, const ::google::monitoring::v3::UpdateUptimeCheckConfigRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>* AsyncDeleteUptimeCheckConfigRaw(::grpc::ClientContext* context, const ::google::monitoring::v3::DeleteUptimeCheckConfigRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>* PrepareAsyncDeleteUptimeCheckConfigRaw(::grpc::ClientContext* context, const ::google::monitoring::v3::DeleteUptimeCheckConfigRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::monitoring::v3::ListUptimeCheckIpsResponse>* AsyncListUptimeCheckIpsRaw(::grpc::ClientContext* context, const ::google::monitoring::v3::ListUptimeCheckIpsRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::monitoring::v3::ListUptimeCheckIpsResponse>* PrepareAsyncListUptimeCheckIpsRaw(::grpc::ClientContext* context, const ::google::monitoring::v3::ListUptimeCheckIpsRequest& request, ::grpc::CompletionQueue* cq) override;
    const ::grpc::internal::RpcMethod rpcmethod_ListUptimeCheckConfigs_;
    const ::grpc::internal::RpcMethod rpcmethod_GetUptimeCheckConfig_;
    const ::grpc::internal::RpcMethod rpcmethod_CreateUptimeCheckConfig_;
    const ::grpc::internal::RpcMethod rpcmethod_UpdateUptimeCheckConfig_;
    const ::grpc::internal::RpcMethod rpcmethod_DeleteUptimeCheckConfig_;
    const ::grpc::internal::RpcMethod rpcmethod_ListUptimeCheckIps_;
  };
  static std::unique_ptr<Stub> NewStub(const std::shared_ptr< ::grpc::ChannelInterface>& channel, const ::grpc::StubOptions& options = ::grpc::StubOptions());

  class Service : public ::grpc::Service {
   public:
    Service();
    virtual ~Service();
    // Lists the existing valid Uptime check configurations for the project
    // (leaving out any invalid configurations).
    virtual ::grpc::Status ListUptimeCheckConfigs(::grpc::ServerContext* context, const ::google::monitoring::v3::ListUptimeCheckConfigsRequest* request, ::google::monitoring::v3::ListUptimeCheckConfigsResponse* response);
    // Gets a single Uptime check configuration.
    virtual ::grpc::Status GetUptimeCheckConfig(::grpc::ServerContext* context, const ::google::monitoring::v3::GetUptimeCheckConfigRequest* request, ::google::monitoring::v3::UptimeCheckConfig* response);
    // Creates a new Uptime check configuration.
    virtual ::grpc::Status CreateUptimeCheckConfig(::grpc::ServerContext* context, const ::google::monitoring::v3::CreateUptimeCheckConfigRequest* request, ::google::monitoring::v3::UptimeCheckConfig* response);
    // Updates an Uptime check configuration. You can either replace the entire
    // configuration with a new one or replace only certain fields in the current
    // configuration by specifying the fields to be updated via `updateMask`.
    // Returns the updated configuration.
    virtual ::grpc::Status UpdateUptimeCheckConfig(::grpc::ServerContext* context, const ::google::monitoring::v3::UpdateUptimeCheckConfigRequest* request, ::google::monitoring::v3::UptimeCheckConfig* response);
    // Deletes an Uptime check configuration. Note that this method will fail
    // if the Uptime check configuration is referenced by an alert policy or
    // other dependent configs that would be rendered invalid by the deletion.
    virtual ::grpc::Status DeleteUptimeCheckConfig(::grpc::ServerContext* context, const ::google::monitoring::v3::DeleteUptimeCheckConfigRequest* request, ::google::protobuf::Empty* response);
    // Returns the list of IP addresses that checkers run from
    virtual ::grpc::Status ListUptimeCheckIps(::grpc::ServerContext* context, const ::google::monitoring::v3::ListUptimeCheckIpsRequest* request, ::google::monitoring::v3::ListUptimeCheckIpsResponse* response);
  };
  template <class BaseClass>
  class WithAsyncMethod_ListUptimeCheckConfigs : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_ListUptimeCheckConfigs() {
      ::grpc::Service::MarkMethodAsync(0);
    }
    ~WithAsyncMethod_ListUptimeCheckConfigs() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListUptimeCheckConfigs(::grpc::ServerContext* /*context*/, const ::google::monitoring::v3::ListUptimeCheckConfigsRequest* /*request*/, ::google::monitoring::v3::ListUptimeCheckConfigsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestListUptimeCheckConfigs(::grpc::ServerContext* context, ::google::monitoring::v3::ListUptimeCheckConfigsRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::monitoring::v3::ListUptimeCheckConfigsResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(0, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_GetUptimeCheckConfig : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_GetUptimeCheckConfig() {
      ::grpc::Service::MarkMethodAsync(1);
    }
    ~WithAsyncMethod_GetUptimeCheckConfig() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetUptimeCheckConfig(::grpc::ServerContext* /*context*/, const ::google::monitoring::v3::GetUptimeCheckConfigRequest* /*request*/, ::google::monitoring::v3::UptimeCheckConfig* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGetUptimeCheckConfig(::grpc::ServerContext* context, ::google::monitoring::v3::GetUptimeCheckConfigRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::monitoring::v3::UptimeCheckConfig>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(1, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_CreateUptimeCheckConfig : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_CreateUptimeCheckConfig() {
      ::grpc::Service::MarkMethodAsync(2);
    }
    ~WithAsyncMethod_CreateUptimeCheckConfig() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateUptimeCheckConfig(::grpc::ServerContext* /*context*/, const ::google::monitoring::v3::CreateUptimeCheckConfigRequest* /*request*/, ::google::monitoring::v3::UptimeCheckConfig* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestCreateUptimeCheckConfig(::grpc::ServerContext* context, ::google::monitoring::v3::CreateUptimeCheckConfigRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::monitoring::v3::UptimeCheckConfig>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(2, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_UpdateUptimeCheckConfig : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_UpdateUptimeCheckConfig() {
      ::grpc::Service::MarkMethodAsync(3);
    }
    ~WithAsyncMethod_UpdateUptimeCheckConfig() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateUptimeCheckConfig(::grpc::ServerContext* /*context*/, const ::google::monitoring::v3::UpdateUptimeCheckConfigRequest* /*request*/, ::google::monitoring::v3::UptimeCheckConfig* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestUpdateUptimeCheckConfig(::grpc::ServerContext* context, ::google::monitoring::v3::UpdateUptimeCheckConfigRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::monitoring::v3::UptimeCheckConfig>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(3, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_DeleteUptimeCheckConfig : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_DeleteUptimeCheckConfig() {
      ::grpc::Service::MarkMethodAsync(4);
    }
    ~WithAsyncMethod_DeleteUptimeCheckConfig() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteUptimeCheckConfig(::grpc::ServerContext* /*context*/, const ::google::monitoring::v3::DeleteUptimeCheckConfigRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestDeleteUptimeCheckConfig(::grpc::ServerContext* context, ::google::monitoring::v3::DeleteUptimeCheckConfigRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::protobuf::Empty>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(4, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_ListUptimeCheckIps : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_ListUptimeCheckIps() {
      ::grpc::Service::MarkMethodAsync(5);
    }
    ~WithAsyncMethod_ListUptimeCheckIps() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListUptimeCheckIps(::grpc::ServerContext* /*context*/, const ::google::monitoring::v3::ListUptimeCheckIpsRequest* /*request*/, ::google::monitoring::v3::ListUptimeCheckIpsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestListUptimeCheckIps(::grpc::ServerContext* context, ::google::monitoring::v3::ListUptimeCheckIpsRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::monitoring::v3::ListUptimeCheckIpsResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(5, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  typedef WithAsyncMethod_ListUptimeCheckConfigs<WithAsyncMethod_GetUptimeCheckConfig<WithAsyncMethod_CreateUptimeCheckConfig<WithAsyncMethod_UpdateUptimeCheckConfig<WithAsyncMethod_DeleteUptimeCheckConfig<WithAsyncMethod_ListUptimeCheckIps<Service > > > > > > AsyncService;
  template <class BaseClass>
  class WithCallbackMethod_ListUptimeCheckConfigs : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_ListUptimeCheckConfigs() {
      ::grpc::Service::MarkMethodCallback(0,
          new ::grpc::internal::CallbackUnaryHandler< ::google::monitoring::v3::ListUptimeCheckConfigsRequest, ::google::monitoring::v3::ListUptimeCheckConfigsResponse>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::monitoring::v3::ListUptimeCheckConfigsRequest* request, ::google::monitoring::v3::ListUptimeCheckConfigsResponse* response) { return this->ListUptimeCheckConfigs(context, request, response); }));}
    void SetMessageAllocatorFor_ListUptimeCheckConfigs(
        ::grpc::MessageAllocator< ::google::monitoring::v3::ListUptimeCheckConfigsRequest, ::google::monitoring::v3::ListUptimeCheckConfigsResponse>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(0);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::monitoring::v3::ListUptimeCheckConfigsRequest, ::google::monitoring::v3::ListUptimeCheckConfigsResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_ListUptimeCheckConfigs() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListUptimeCheckConfigs(::grpc::ServerContext* /*context*/, const ::google::monitoring::v3::ListUptimeCheckConfigsRequest* /*request*/, ::google::monitoring::v3::ListUptimeCheckConfigsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* ListUptimeCheckConfigs(
      ::grpc::CallbackServerContext* /*context*/, const ::google::monitoring::v3::ListUptimeCheckConfigsRequest* /*request*/, ::google::monitoring::v3::ListUptimeCheckConfigsResponse* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_GetUptimeCheckConfig : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_GetUptimeCheckConfig() {
      ::grpc::Service::MarkMethodCallback(1,
          new ::grpc::internal::CallbackUnaryHandler< ::google::monitoring::v3::GetUptimeCheckConfigRequest, ::google::monitoring::v3::UptimeCheckConfig>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::monitoring::v3::GetUptimeCheckConfigRequest* request, ::google::monitoring::v3::UptimeCheckConfig* response) { return this->GetUptimeCheckConfig(context, request, response); }));}
    void SetMessageAllocatorFor_GetUptimeCheckConfig(
        ::grpc::MessageAllocator< ::google::monitoring::v3::GetUptimeCheckConfigRequest, ::google::monitoring::v3::UptimeCheckConfig>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(1);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::monitoring::v3::GetUptimeCheckConfigRequest, ::google::monitoring::v3::UptimeCheckConfig>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_GetUptimeCheckConfig() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetUptimeCheckConfig(::grpc::ServerContext* /*context*/, const ::google::monitoring::v3::GetUptimeCheckConfigRequest* /*request*/, ::google::monitoring::v3::UptimeCheckConfig* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* GetUptimeCheckConfig(
      ::grpc::CallbackServerContext* /*context*/, const ::google::monitoring::v3::GetUptimeCheckConfigRequest* /*request*/, ::google::monitoring::v3::UptimeCheckConfig* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_CreateUptimeCheckConfig : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_CreateUptimeCheckConfig() {
      ::grpc::Service::MarkMethodCallback(2,
          new ::grpc::internal::CallbackUnaryHandler< ::google::monitoring::v3::CreateUptimeCheckConfigRequest, ::google::monitoring::v3::UptimeCheckConfig>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::monitoring::v3::CreateUptimeCheckConfigRequest* request, ::google::monitoring::v3::UptimeCheckConfig* response) { return this->CreateUptimeCheckConfig(context, request, response); }));}
    void SetMessageAllocatorFor_CreateUptimeCheckConfig(
        ::grpc::MessageAllocator< ::google::monitoring::v3::CreateUptimeCheckConfigRequest, ::google::monitoring::v3::UptimeCheckConfig>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(2);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::monitoring::v3::CreateUptimeCheckConfigRequest, ::google::monitoring::v3::UptimeCheckConfig>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_CreateUptimeCheckConfig() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateUptimeCheckConfig(::grpc::ServerContext* /*context*/, const ::google::monitoring::v3::CreateUptimeCheckConfigRequest* /*request*/, ::google::monitoring::v3::UptimeCheckConfig* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* CreateUptimeCheckConfig(
      ::grpc::CallbackServerContext* /*context*/, const ::google::monitoring::v3::CreateUptimeCheckConfigRequest* /*request*/, ::google::monitoring::v3::UptimeCheckConfig* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_UpdateUptimeCheckConfig : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_UpdateUptimeCheckConfig() {
      ::grpc::Service::MarkMethodCallback(3,
          new ::grpc::internal::CallbackUnaryHandler< ::google::monitoring::v3::UpdateUptimeCheckConfigRequest, ::google::monitoring::v3::UptimeCheckConfig>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::monitoring::v3::UpdateUptimeCheckConfigRequest* request, ::google::monitoring::v3::UptimeCheckConfig* response) { return this->UpdateUptimeCheckConfig(context, request, response); }));}
    void SetMessageAllocatorFor_UpdateUptimeCheckConfig(
        ::grpc::MessageAllocator< ::google::monitoring::v3::UpdateUptimeCheckConfigRequest, ::google::monitoring::v3::UptimeCheckConfig>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(3);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::monitoring::v3::UpdateUptimeCheckConfigRequest, ::google::monitoring::v3::UptimeCheckConfig>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_UpdateUptimeCheckConfig() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateUptimeCheckConfig(::grpc::ServerContext* /*context*/, const ::google::monitoring::v3::UpdateUptimeCheckConfigRequest* /*request*/, ::google::monitoring::v3::UptimeCheckConfig* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* UpdateUptimeCheckConfig(
      ::grpc::CallbackServerContext* /*context*/, const ::google::monitoring::v3::UpdateUptimeCheckConfigRequest* /*request*/, ::google::monitoring::v3::UptimeCheckConfig* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_DeleteUptimeCheckConfig : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_DeleteUptimeCheckConfig() {
      ::grpc::Service::MarkMethodCallback(4,
          new ::grpc::internal::CallbackUnaryHandler< ::google::monitoring::v3::DeleteUptimeCheckConfigRequest, ::google::protobuf::Empty>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::monitoring::v3::DeleteUptimeCheckConfigRequest* request, ::google::protobuf::Empty* response) { return this->DeleteUptimeCheckConfig(context, request, response); }));}
    void SetMessageAllocatorFor_DeleteUptimeCheckConfig(
        ::grpc::MessageAllocator< ::google::monitoring::v3::DeleteUptimeCheckConfigRequest, ::google::protobuf::Empty>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(4);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::monitoring::v3::DeleteUptimeCheckConfigRequest, ::google::protobuf::Empty>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_DeleteUptimeCheckConfig() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteUptimeCheckConfig(::grpc::ServerContext* /*context*/, const ::google::monitoring::v3::DeleteUptimeCheckConfigRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* DeleteUptimeCheckConfig(
      ::grpc::CallbackServerContext* /*context*/, const ::google::monitoring::v3::DeleteUptimeCheckConfigRequest* /*request*/, ::google::protobuf::Empty* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_ListUptimeCheckIps : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_ListUptimeCheckIps() {
      ::grpc::Service::MarkMethodCallback(5,
          new ::grpc::internal::CallbackUnaryHandler< ::google::monitoring::v3::ListUptimeCheckIpsRequest, ::google::monitoring::v3::ListUptimeCheckIpsResponse>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::monitoring::v3::ListUptimeCheckIpsRequest* request, ::google::monitoring::v3::ListUptimeCheckIpsResponse* response) { return this->ListUptimeCheckIps(context, request, response); }));}
    void SetMessageAllocatorFor_ListUptimeCheckIps(
        ::grpc::MessageAllocator< ::google::monitoring::v3::ListUptimeCheckIpsRequest, ::google::monitoring::v3::ListUptimeCheckIpsResponse>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(5);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::monitoring::v3::ListUptimeCheckIpsRequest, ::google::monitoring::v3::ListUptimeCheckIpsResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_ListUptimeCheckIps() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListUptimeCheckIps(::grpc::ServerContext* /*context*/, const ::google::monitoring::v3::ListUptimeCheckIpsRequest* /*request*/, ::google::monitoring::v3::ListUptimeCheckIpsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* ListUptimeCheckIps(
      ::grpc::CallbackServerContext* /*context*/, const ::google::monitoring::v3::ListUptimeCheckIpsRequest* /*request*/, ::google::monitoring::v3::ListUptimeCheckIpsResponse* /*response*/)  { return nullptr; }
  };
  typedef WithCallbackMethod_ListUptimeCheckConfigs<WithCallbackMethod_GetUptimeCheckConfig<WithCallbackMethod_CreateUptimeCheckConfig<WithCallbackMethod_UpdateUptimeCheckConfig<WithCallbackMethod_DeleteUptimeCheckConfig<WithCallbackMethod_ListUptimeCheckIps<Service > > > > > > CallbackService;
  typedef CallbackService ExperimentalCallbackService;
  template <class BaseClass>
  class WithGenericMethod_ListUptimeCheckConfigs : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_ListUptimeCheckConfigs() {
      ::grpc::Service::MarkMethodGeneric(0);
    }
    ~WithGenericMethod_ListUptimeCheckConfigs() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListUptimeCheckConfigs(::grpc::ServerContext* /*context*/, const ::google::monitoring::v3::ListUptimeCheckConfigsRequest* /*request*/, ::google::monitoring::v3::ListUptimeCheckConfigsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_GetUptimeCheckConfig : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_GetUptimeCheckConfig() {
      ::grpc::Service::MarkMethodGeneric(1);
    }
    ~WithGenericMethod_GetUptimeCheckConfig() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetUptimeCheckConfig(::grpc::ServerContext* /*context*/, const ::google::monitoring::v3::GetUptimeCheckConfigRequest* /*request*/, ::google::monitoring::v3::UptimeCheckConfig* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_CreateUptimeCheckConfig : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_CreateUptimeCheckConfig() {
      ::grpc::Service::MarkMethodGeneric(2);
    }
    ~WithGenericMethod_CreateUptimeCheckConfig() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateUptimeCheckConfig(::grpc::ServerContext* /*context*/, const ::google::monitoring::v3::CreateUptimeCheckConfigRequest* /*request*/, ::google::monitoring::v3::UptimeCheckConfig* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_UpdateUptimeCheckConfig : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_UpdateUptimeCheckConfig() {
      ::grpc::Service::MarkMethodGeneric(3);
    }
    ~WithGenericMethod_UpdateUptimeCheckConfig() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateUptimeCheckConfig(::grpc::ServerContext* /*context*/, const ::google::monitoring::v3::UpdateUptimeCheckConfigRequest* /*request*/, ::google::monitoring::v3::UptimeCheckConfig* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_DeleteUptimeCheckConfig : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_DeleteUptimeCheckConfig() {
      ::grpc::Service::MarkMethodGeneric(4);
    }
    ~WithGenericMethod_DeleteUptimeCheckConfig() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteUptimeCheckConfig(::grpc::ServerContext* /*context*/, const ::google::monitoring::v3::DeleteUptimeCheckConfigRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_ListUptimeCheckIps : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_ListUptimeCheckIps() {
      ::grpc::Service::MarkMethodGeneric(5);
    }
    ~WithGenericMethod_ListUptimeCheckIps() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListUptimeCheckIps(::grpc::ServerContext* /*context*/, const ::google::monitoring::v3::ListUptimeCheckIpsRequest* /*request*/, ::google::monitoring::v3::ListUptimeCheckIpsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithRawMethod_ListUptimeCheckConfigs : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_ListUptimeCheckConfigs() {
      ::grpc::Service::MarkMethodRaw(0);
    }
    ~WithRawMethod_ListUptimeCheckConfigs() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListUptimeCheckConfigs(::grpc::ServerContext* /*context*/, const ::google::monitoring::v3::ListUptimeCheckConfigsRequest* /*request*/, ::google::monitoring::v3::ListUptimeCheckConfigsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestListUptimeCheckConfigs(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(0, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_GetUptimeCheckConfig : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_GetUptimeCheckConfig() {
      ::grpc::Service::MarkMethodRaw(1);
    }
    ~WithRawMethod_GetUptimeCheckConfig() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetUptimeCheckConfig(::grpc::ServerContext* /*context*/, const ::google::monitoring::v3::GetUptimeCheckConfigRequest* /*request*/, ::google::monitoring::v3::UptimeCheckConfig* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGetUptimeCheckConfig(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(1, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_CreateUptimeCheckConfig : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_CreateUptimeCheckConfig() {
      ::grpc::Service::MarkMethodRaw(2);
    }
    ~WithRawMethod_CreateUptimeCheckConfig() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateUptimeCheckConfig(::grpc::ServerContext* /*context*/, const ::google::monitoring::v3::CreateUptimeCheckConfigRequest* /*request*/, ::google::monitoring::v3::UptimeCheckConfig* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestCreateUptimeCheckConfig(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(2, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_UpdateUptimeCheckConfig : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_UpdateUptimeCheckConfig() {
      ::grpc::Service::MarkMethodRaw(3);
    }
    ~WithRawMethod_UpdateUptimeCheckConfig() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateUptimeCheckConfig(::grpc::ServerContext* /*context*/, const ::google::monitoring::v3::UpdateUptimeCheckConfigRequest* /*request*/, ::google::monitoring::v3::UptimeCheckConfig* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestUpdateUptimeCheckConfig(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(3, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_DeleteUptimeCheckConfig : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_DeleteUptimeCheckConfig() {
      ::grpc::Service::MarkMethodRaw(4);
    }
    ~WithRawMethod_DeleteUptimeCheckConfig() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteUptimeCheckConfig(::grpc::ServerContext* /*context*/, const ::google::monitoring::v3::DeleteUptimeCheckConfigRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestDeleteUptimeCheckConfig(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(4, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_ListUptimeCheckIps : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_ListUptimeCheckIps() {
      ::grpc::Service::MarkMethodRaw(5);
    }
    ~WithRawMethod_ListUptimeCheckIps() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListUptimeCheckIps(::grpc::ServerContext* /*context*/, const ::google::monitoring::v3::ListUptimeCheckIpsRequest* /*request*/, ::google::monitoring::v3::ListUptimeCheckIpsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestListUptimeCheckIps(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(5, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_ListUptimeCheckConfigs : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_ListUptimeCheckConfigs() {
      ::grpc::Service::MarkMethodRawCallback(0,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->ListUptimeCheckConfigs(context, request, response); }));
    }
    ~WithRawCallbackMethod_ListUptimeCheckConfigs() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListUptimeCheckConfigs(::grpc::ServerContext* /*context*/, const ::google::monitoring::v3::ListUptimeCheckConfigsRequest* /*request*/, ::google::monitoring::v3::ListUptimeCheckConfigsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* ListUptimeCheckConfigs(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_GetUptimeCheckConfig : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_GetUptimeCheckConfig() {
      ::grpc::Service::MarkMethodRawCallback(1,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->GetUptimeCheckConfig(context, request, response); }));
    }
    ~WithRawCallbackMethod_GetUptimeCheckConfig() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetUptimeCheckConfig(::grpc::ServerContext* /*context*/, const ::google::monitoring::v3::GetUptimeCheckConfigRequest* /*request*/, ::google::monitoring::v3::UptimeCheckConfig* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* GetUptimeCheckConfig(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_CreateUptimeCheckConfig : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_CreateUptimeCheckConfig() {
      ::grpc::Service::MarkMethodRawCallback(2,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->CreateUptimeCheckConfig(context, request, response); }));
    }
    ~WithRawCallbackMethod_CreateUptimeCheckConfig() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateUptimeCheckConfig(::grpc::ServerContext* /*context*/, const ::google::monitoring::v3::CreateUptimeCheckConfigRequest* /*request*/, ::google::monitoring::v3::UptimeCheckConfig* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* CreateUptimeCheckConfig(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_UpdateUptimeCheckConfig : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_UpdateUptimeCheckConfig() {
      ::grpc::Service::MarkMethodRawCallback(3,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->UpdateUptimeCheckConfig(context, request, response); }));
    }
    ~WithRawCallbackMethod_UpdateUptimeCheckConfig() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateUptimeCheckConfig(::grpc::ServerContext* /*context*/, const ::google::monitoring::v3::UpdateUptimeCheckConfigRequest* /*request*/, ::google::monitoring::v3::UptimeCheckConfig* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* UpdateUptimeCheckConfig(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_DeleteUptimeCheckConfig : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_DeleteUptimeCheckConfig() {
      ::grpc::Service::MarkMethodRawCallback(4,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->DeleteUptimeCheckConfig(context, request, response); }));
    }
    ~WithRawCallbackMethod_DeleteUptimeCheckConfig() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteUptimeCheckConfig(::grpc::ServerContext* /*context*/, const ::google::monitoring::v3::DeleteUptimeCheckConfigRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* DeleteUptimeCheckConfig(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_ListUptimeCheckIps : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_ListUptimeCheckIps() {
      ::grpc::Service::MarkMethodRawCallback(5,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->ListUptimeCheckIps(context, request, response); }));
    }
    ~WithRawCallbackMethod_ListUptimeCheckIps() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListUptimeCheckIps(::grpc::ServerContext* /*context*/, const ::google::monitoring::v3::ListUptimeCheckIpsRequest* /*request*/, ::google::monitoring::v3::ListUptimeCheckIpsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* ListUptimeCheckIps(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_ListUptimeCheckConfigs : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_ListUptimeCheckConfigs() {
      ::grpc::Service::MarkMethodStreamed(0,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::monitoring::v3::ListUptimeCheckConfigsRequest, ::google::monitoring::v3::ListUptimeCheckConfigsResponse>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::monitoring::v3::ListUptimeCheckConfigsRequest, ::google::monitoring::v3::ListUptimeCheckConfigsResponse>* streamer) {
                       return this->StreamedListUptimeCheckConfigs(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_ListUptimeCheckConfigs() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status ListUptimeCheckConfigs(::grpc::ServerContext* /*context*/, const ::google::monitoring::v3::ListUptimeCheckConfigsRequest* /*request*/, ::google::monitoring::v3::ListUptimeCheckConfigsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedListUptimeCheckConfigs(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::monitoring::v3::ListUptimeCheckConfigsRequest,::google::monitoring::v3::ListUptimeCheckConfigsResponse>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_GetUptimeCheckConfig : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_GetUptimeCheckConfig() {
      ::grpc::Service::MarkMethodStreamed(1,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::monitoring::v3::GetUptimeCheckConfigRequest, ::google::monitoring::v3::UptimeCheckConfig>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::monitoring::v3::GetUptimeCheckConfigRequest, ::google::monitoring::v3::UptimeCheckConfig>* streamer) {
                       return this->StreamedGetUptimeCheckConfig(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_GetUptimeCheckConfig() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status GetUptimeCheckConfig(::grpc::ServerContext* /*context*/, const ::google::monitoring::v3::GetUptimeCheckConfigRequest* /*request*/, ::google::monitoring::v3::UptimeCheckConfig* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedGetUptimeCheckConfig(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::monitoring::v3::GetUptimeCheckConfigRequest,::google::monitoring::v3::UptimeCheckConfig>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_CreateUptimeCheckConfig : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_CreateUptimeCheckConfig() {
      ::grpc::Service::MarkMethodStreamed(2,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::monitoring::v3::CreateUptimeCheckConfigRequest, ::google::monitoring::v3::UptimeCheckConfig>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::monitoring::v3::CreateUptimeCheckConfigRequest, ::google::monitoring::v3::UptimeCheckConfig>* streamer) {
                       return this->StreamedCreateUptimeCheckConfig(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_CreateUptimeCheckConfig() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status CreateUptimeCheckConfig(::grpc::ServerContext* /*context*/, const ::google::monitoring::v3::CreateUptimeCheckConfigRequest* /*request*/, ::google::monitoring::v3::UptimeCheckConfig* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedCreateUptimeCheckConfig(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::monitoring::v3::CreateUptimeCheckConfigRequest,::google::monitoring::v3::UptimeCheckConfig>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_UpdateUptimeCheckConfig : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_UpdateUptimeCheckConfig() {
      ::grpc::Service::MarkMethodStreamed(3,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::monitoring::v3::UpdateUptimeCheckConfigRequest, ::google::monitoring::v3::UptimeCheckConfig>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::monitoring::v3::UpdateUptimeCheckConfigRequest, ::google::monitoring::v3::UptimeCheckConfig>* streamer) {
                       return this->StreamedUpdateUptimeCheckConfig(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_UpdateUptimeCheckConfig() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status UpdateUptimeCheckConfig(::grpc::ServerContext* /*context*/, const ::google::monitoring::v3::UpdateUptimeCheckConfigRequest* /*request*/, ::google::monitoring::v3::UptimeCheckConfig* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedUpdateUptimeCheckConfig(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::monitoring::v3::UpdateUptimeCheckConfigRequest,::google::monitoring::v3::UptimeCheckConfig>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_DeleteUptimeCheckConfig : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_DeleteUptimeCheckConfig() {
      ::grpc::Service::MarkMethodStreamed(4,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::monitoring::v3::DeleteUptimeCheckConfigRequest, ::google::protobuf::Empty>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::monitoring::v3::DeleteUptimeCheckConfigRequest, ::google::protobuf::Empty>* streamer) {
                       return this->StreamedDeleteUptimeCheckConfig(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_DeleteUptimeCheckConfig() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status DeleteUptimeCheckConfig(::grpc::ServerContext* /*context*/, const ::google::monitoring::v3::DeleteUptimeCheckConfigRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedDeleteUptimeCheckConfig(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::monitoring::v3::DeleteUptimeCheckConfigRequest,::google::protobuf::Empty>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_ListUptimeCheckIps : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_ListUptimeCheckIps() {
      ::grpc::Service::MarkMethodStreamed(5,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::monitoring::v3::ListUptimeCheckIpsRequest, ::google::monitoring::v3::ListUptimeCheckIpsResponse>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::monitoring::v3::ListUptimeCheckIpsRequest, ::google::monitoring::v3::ListUptimeCheckIpsResponse>* streamer) {
                       return this->StreamedListUptimeCheckIps(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_ListUptimeCheckIps() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status ListUptimeCheckIps(::grpc::ServerContext* /*context*/, const ::google::monitoring::v3::ListUptimeCheckIpsRequest* /*request*/, ::google::monitoring::v3::ListUptimeCheckIpsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedListUptimeCheckIps(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::monitoring::v3::ListUptimeCheckIpsRequest,::google::monitoring::v3::ListUptimeCheckIpsResponse>* server_unary_streamer) = 0;
  };
  typedef WithStreamedUnaryMethod_ListUptimeCheckConfigs<WithStreamedUnaryMethod_GetUptimeCheckConfig<WithStreamedUnaryMethod_CreateUptimeCheckConfig<WithStreamedUnaryMethod_UpdateUptimeCheckConfig<WithStreamedUnaryMethod_DeleteUptimeCheckConfig<WithStreamedUnaryMethod_ListUptimeCheckIps<Service > > > > > > StreamedUnaryService;
  typedef Service SplitStreamedService;
  typedef WithStreamedUnaryMethod_ListUptimeCheckConfigs<WithStreamedUnaryMethod_GetUptimeCheckConfig<WithStreamedUnaryMethod_CreateUptimeCheckConfig<WithStreamedUnaryMethod_UpdateUptimeCheckConfig<WithStreamedUnaryMethod_DeleteUptimeCheckConfig<WithStreamedUnaryMethod_ListUptimeCheckIps<Service > > > > > > StreamedService;
};

}  // namespace v3
}  // namespace monitoring
}  // namespace google


#endif  // GRPC_google_2fmonitoring_2fv3_2fuptime_5fservice_2eproto__INCLUDED
