// Generated by the gRPC C++ plugin.
// If you make any local change, they will be lost.
// source: google/iam/admin/v1/iam.proto
// Original file comments:
// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
#ifndef GRPC_google_2fiam_2fadmin_2fv1_2fiam_2eproto__INCLUDED
#define GRPC_google_2fiam_2fadmin_2fv1_2fiam_2eproto__INCLUDED

#include "google/iam/admin/v1/iam.pb.h"

#include <functional>
#include <grpcpp/impl/codegen/async_generic_service.h>
#include <grpcpp/impl/codegen/async_stream.h>
#include <grpcpp/impl/codegen/async_unary_call.h>
#include <grpcpp/impl/codegen/client_callback.h>
#include <grpcpp/impl/codegen/client_context.h>
#include <grpcpp/impl/codegen/completion_queue.h>
#include <grpcpp/impl/codegen/message_allocator.h>
#include <grpcpp/impl/codegen/method_handler.h>
#include <grpcpp/impl/codegen/proto_utils.h>
#include <grpcpp/impl/codegen/rpc_method.h>
#include <grpcpp/impl/codegen/server_callback.h>
#include <grpcpp/impl/codegen/server_callback_handlers.h>
#include <grpcpp/impl/codegen/server_context.h>
#include <grpcpp/impl/codegen/service_type.h>
#include <grpcpp/impl/codegen/status.h>
#include <grpcpp/impl/codegen/stub_options.h>
#include <grpcpp/impl/codegen/sync_stream.h>

namespace google {
namespace iam {
namespace admin {
namespace v1 {

// Creates and manages Identity and Access Management (IAM) resources.
//
// You can use this service to work with all of the following resources:
//
// * **Service accounts**, which identify an application or a virtual machine
//   (VM) instance rather than a person
// * **Service account keys**, which service accounts use to authenticate with
//   Google APIs
// * **IAM policies for service accounts**, which specify the roles that a
//   member has for the service account
// * **IAM custom roles**, which help you limit the number of permissions that
//   you grant to members
//
// In addition, you can use this service to complete the following tasks, among
// others:
//
// * Test whether a service account can use specific permissions
// * Check which roles you can grant for a specific resource
// * Lint, or validate, condition expressions in an IAM policy
class IAM final {
 public:
  static constexpr char const* service_full_name() {
    return "google.iam.admin.v1.IAM";
  }
  class StubInterface {
   public:
    virtual ~StubInterface() {}
    // Lists every [ServiceAccount][google.iam.admin.v1.ServiceAccount] that belongs to a specific project.
    virtual ::grpc::Status ListServiceAccounts(::grpc::ClientContext* context, const ::google::iam::admin::v1::ListServiceAccountsRequest& request, ::google::iam::admin::v1::ListServiceAccountsResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::ListServiceAccountsResponse>> AsyncListServiceAccounts(::grpc::ClientContext* context, const ::google::iam::admin::v1::ListServiceAccountsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::ListServiceAccountsResponse>>(AsyncListServiceAccountsRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::ListServiceAccountsResponse>> PrepareAsyncListServiceAccounts(::grpc::ClientContext* context, const ::google::iam::admin::v1::ListServiceAccountsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::ListServiceAccountsResponse>>(PrepareAsyncListServiceAccountsRaw(context, request, cq));
    }
    // Gets a [ServiceAccount][google.iam.admin.v1.ServiceAccount].
    virtual ::grpc::Status GetServiceAccount(::grpc::ClientContext* context, const ::google::iam::admin::v1::GetServiceAccountRequest& request, ::google::iam::admin::v1::ServiceAccount* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::ServiceAccount>> AsyncGetServiceAccount(::grpc::ClientContext* context, const ::google::iam::admin::v1::GetServiceAccountRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::ServiceAccount>>(AsyncGetServiceAccountRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::ServiceAccount>> PrepareAsyncGetServiceAccount(::grpc::ClientContext* context, const ::google::iam::admin::v1::GetServiceAccountRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::ServiceAccount>>(PrepareAsyncGetServiceAccountRaw(context, request, cq));
    }
    // Creates a [ServiceAccount][google.iam.admin.v1.ServiceAccount].
    virtual ::grpc::Status CreateServiceAccount(::grpc::ClientContext* context, const ::google::iam::admin::v1::CreateServiceAccountRequest& request, ::google::iam::admin::v1::ServiceAccount* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::ServiceAccount>> AsyncCreateServiceAccount(::grpc::ClientContext* context, const ::google::iam::admin::v1::CreateServiceAccountRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::ServiceAccount>>(AsyncCreateServiceAccountRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::ServiceAccount>> PrepareAsyncCreateServiceAccount(::grpc::ClientContext* context, const ::google::iam::admin::v1::CreateServiceAccountRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::ServiceAccount>>(PrepareAsyncCreateServiceAccountRaw(context, request, cq));
    }
    // **Note:** We are in the process of deprecating this method. Use
    // [PatchServiceAccount][google.iam.admin.v1.IAM.PatchServiceAccount] instead.
    //
    // Updates a [ServiceAccount][google.iam.admin.v1.ServiceAccount].
    //
    // You can update only the `display_name` and `description` fields.
    virtual ::grpc::Status UpdateServiceAccount(::grpc::ClientContext* context, const ::google::iam::admin::v1::ServiceAccount& request, ::google::iam::admin::v1::ServiceAccount* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::ServiceAccount>> AsyncUpdateServiceAccount(::grpc::ClientContext* context, const ::google::iam::admin::v1::ServiceAccount& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::ServiceAccount>>(AsyncUpdateServiceAccountRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::ServiceAccount>> PrepareAsyncUpdateServiceAccount(::grpc::ClientContext* context, const ::google::iam::admin::v1::ServiceAccount& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::ServiceAccount>>(PrepareAsyncUpdateServiceAccountRaw(context, request, cq));
    }
    // Patches a [ServiceAccount][google.iam.admin.v1.ServiceAccount].
    virtual ::grpc::Status PatchServiceAccount(::grpc::ClientContext* context, const ::google::iam::admin::v1::PatchServiceAccountRequest& request, ::google::iam::admin::v1::ServiceAccount* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::ServiceAccount>> AsyncPatchServiceAccount(::grpc::ClientContext* context, const ::google::iam::admin::v1::PatchServiceAccountRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::ServiceAccount>>(AsyncPatchServiceAccountRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::ServiceAccount>> PrepareAsyncPatchServiceAccount(::grpc::ClientContext* context, const ::google::iam::admin::v1::PatchServiceAccountRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::ServiceAccount>>(PrepareAsyncPatchServiceAccountRaw(context, request, cq));
    }
    // Deletes a [ServiceAccount][google.iam.admin.v1.ServiceAccount].
    //
    // **Warning:** After you delete a service account, you might not be able to
    // undelete it. If you know that you need to re-enable the service account in
    // the future, use [DisableServiceAccount][google.iam.admin.v1.IAM.DisableServiceAccount] instead.
    //
    // If you delete a service account, IAM permanently removes the service
    // account 30 days later. Google Cloud cannot recover the service account
    // after it is permanently removed, even if you file a support request.
    //
    // To help avoid unplanned outages, we recommend that you disable the service
    // account before you delete it. Use [DisableServiceAccount][google.iam.admin.v1.IAM.DisableServiceAccount] to disable the
    // service account, then wait at least 24 hours and watch for unintended
    // consequences. If there are no unintended consequences, you can delete the
    // service account.
    virtual ::grpc::Status DeleteServiceAccount(::grpc::ClientContext* context, const ::google::iam::admin::v1::DeleteServiceAccountRequest& request, ::google::protobuf::Empty* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>> AsyncDeleteServiceAccount(::grpc::ClientContext* context, const ::google::iam::admin::v1::DeleteServiceAccountRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>>(AsyncDeleteServiceAccountRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>> PrepareAsyncDeleteServiceAccount(::grpc::ClientContext* context, const ::google::iam::admin::v1::DeleteServiceAccountRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>>(PrepareAsyncDeleteServiceAccountRaw(context, request, cq));
    }
    // Restores a deleted [ServiceAccount][google.iam.admin.v1.ServiceAccount].
    //
    // **Important:** It is not always possible to restore a deleted service
    // account. Use this method only as a last resort.
    //
    // After you delete a service account, IAM permanently removes the service
    // account 30 days later. There is no way to restore a deleted service account
    // that has been permanently removed.
    virtual ::grpc::Status UndeleteServiceAccount(::grpc::ClientContext* context, const ::google::iam::admin::v1::UndeleteServiceAccountRequest& request, ::google::iam::admin::v1::UndeleteServiceAccountResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::UndeleteServiceAccountResponse>> AsyncUndeleteServiceAccount(::grpc::ClientContext* context, const ::google::iam::admin::v1::UndeleteServiceAccountRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::UndeleteServiceAccountResponse>>(AsyncUndeleteServiceAccountRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::UndeleteServiceAccountResponse>> PrepareAsyncUndeleteServiceAccount(::grpc::ClientContext* context, const ::google::iam::admin::v1::UndeleteServiceAccountRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::UndeleteServiceAccountResponse>>(PrepareAsyncUndeleteServiceAccountRaw(context, request, cq));
    }
    // Enables a [ServiceAccount][google.iam.admin.v1.ServiceAccount] that was disabled by
    // [DisableServiceAccount][google.iam.admin.v1.IAM.DisableServiceAccount].
    //
    // If the service account is already enabled, then this method has no effect.
    //
    // If the service account was disabled by other means—for example, if Google
    // disabled the service account because it was compromised—you cannot use this
    // method to enable the service account.
    virtual ::grpc::Status EnableServiceAccount(::grpc::ClientContext* context, const ::google::iam::admin::v1::EnableServiceAccountRequest& request, ::google::protobuf::Empty* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>> AsyncEnableServiceAccount(::grpc::ClientContext* context, const ::google::iam::admin::v1::EnableServiceAccountRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>>(AsyncEnableServiceAccountRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>> PrepareAsyncEnableServiceAccount(::grpc::ClientContext* context, const ::google::iam::admin::v1::EnableServiceAccountRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>>(PrepareAsyncEnableServiceAccountRaw(context, request, cq));
    }
    // Disables a [ServiceAccount][google.iam.admin.v1.ServiceAccount] immediately.
    //
    // If an application uses the service account to authenticate, that
    // application can no longer call Google APIs or access Google Cloud
    // resources. Existing access tokens for the service account are rejected, and
    // requests for new access tokens will fail.
    //
    // To re-enable the service account, use [EnableServiceAccount][google.iam.admin.v1.IAM.EnableServiceAccount]. After you
    // re-enable the service account, its existing access tokens will be accepted,
    // and you can request new access tokens.
    //
    // To help avoid unplanned outages, we recommend that you disable the service
    // account before you delete it. Use this method to disable the service
    // account, then wait at least 24 hours and watch for unintended consequences.
    // If there are no unintended consequences, you can delete the service account
    // with [DeleteServiceAccount][google.iam.admin.v1.IAM.DeleteServiceAccount].
    virtual ::grpc::Status DisableServiceAccount(::grpc::ClientContext* context, const ::google::iam::admin::v1::DisableServiceAccountRequest& request, ::google::protobuf::Empty* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>> AsyncDisableServiceAccount(::grpc::ClientContext* context, const ::google::iam::admin::v1::DisableServiceAccountRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>>(AsyncDisableServiceAccountRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>> PrepareAsyncDisableServiceAccount(::grpc::ClientContext* context, const ::google::iam::admin::v1::DisableServiceAccountRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>>(PrepareAsyncDisableServiceAccountRaw(context, request, cq));
    }
    // Lists every [ServiceAccountKey][google.iam.admin.v1.ServiceAccountKey] for a service account.
    virtual ::grpc::Status ListServiceAccountKeys(::grpc::ClientContext* context, const ::google::iam::admin::v1::ListServiceAccountKeysRequest& request, ::google::iam::admin::v1::ListServiceAccountKeysResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::ListServiceAccountKeysResponse>> AsyncListServiceAccountKeys(::grpc::ClientContext* context, const ::google::iam::admin::v1::ListServiceAccountKeysRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::ListServiceAccountKeysResponse>>(AsyncListServiceAccountKeysRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::ListServiceAccountKeysResponse>> PrepareAsyncListServiceAccountKeys(::grpc::ClientContext* context, const ::google::iam::admin::v1::ListServiceAccountKeysRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::ListServiceAccountKeysResponse>>(PrepareAsyncListServiceAccountKeysRaw(context, request, cq));
    }
    // Gets a [ServiceAccountKey][google.iam.admin.v1.ServiceAccountKey].
    virtual ::grpc::Status GetServiceAccountKey(::grpc::ClientContext* context, const ::google::iam::admin::v1::GetServiceAccountKeyRequest& request, ::google::iam::admin::v1::ServiceAccountKey* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::ServiceAccountKey>> AsyncGetServiceAccountKey(::grpc::ClientContext* context, const ::google::iam::admin::v1::GetServiceAccountKeyRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::ServiceAccountKey>>(AsyncGetServiceAccountKeyRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::ServiceAccountKey>> PrepareAsyncGetServiceAccountKey(::grpc::ClientContext* context, const ::google::iam::admin::v1::GetServiceAccountKeyRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::ServiceAccountKey>>(PrepareAsyncGetServiceAccountKeyRaw(context, request, cq));
    }
    // Creates a [ServiceAccountKey][google.iam.admin.v1.ServiceAccountKey].
    virtual ::grpc::Status CreateServiceAccountKey(::grpc::ClientContext* context, const ::google::iam::admin::v1::CreateServiceAccountKeyRequest& request, ::google::iam::admin::v1::ServiceAccountKey* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::ServiceAccountKey>> AsyncCreateServiceAccountKey(::grpc::ClientContext* context, const ::google::iam::admin::v1::CreateServiceAccountKeyRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::ServiceAccountKey>>(AsyncCreateServiceAccountKeyRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::ServiceAccountKey>> PrepareAsyncCreateServiceAccountKey(::grpc::ClientContext* context, const ::google::iam::admin::v1::CreateServiceAccountKeyRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::ServiceAccountKey>>(PrepareAsyncCreateServiceAccountKeyRaw(context, request, cq));
    }
    // Creates a [ServiceAccountKey][google.iam.admin.v1.ServiceAccountKey], using a public key that you provide.
    virtual ::grpc::Status UploadServiceAccountKey(::grpc::ClientContext* context, const ::google::iam::admin::v1::UploadServiceAccountKeyRequest& request, ::google::iam::admin::v1::ServiceAccountKey* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::ServiceAccountKey>> AsyncUploadServiceAccountKey(::grpc::ClientContext* context, const ::google::iam::admin::v1::UploadServiceAccountKeyRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::ServiceAccountKey>>(AsyncUploadServiceAccountKeyRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::ServiceAccountKey>> PrepareAsyncUploadServiceAccountKey(::grpc::ClientContext* context, const ::google::iam::admin::v1::UploadServiceAccountKeyRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::ServiceAccountKey>>(PrepareAsyncUploadServiceAccountKeyRaw(context, request, cq));
    }
    // Deletes a [ServiceAccountKey][google.iam.admin.v1.ServiceAccountKey]. Deleting a service account key does not
    // revoke short-lived credentials that have been issued based on the service
    // account key.
    virtual ::grpc::Status DeleteServiceAccountKey(::grpc::ClientContext* context, const ::google::iam::admin::v1::DeleteServiceAccountKeyRequest& request, ::google::protobuf::Empty* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>> AsyncDeleteServiceAccountKey(::grpc::ClientContext* context, const ::google::iam::admin::v1::DeleteServiceAccountKeyRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>>(AsyncDeleteServiceAccountKeyRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>> PrepareAsyncDeleteServiceAccountKey(::grpc::ClientContext* context, const ::google::iam::admin::v1::DeleteServiceAccountKeyRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>>(PrepareAsyncDeleteServiceAccountKeyRaw(context, request, cq));
    }
    // **Note:** This method is deprecated. Use the
    // [`signBlob`](https://cloud.google.com/iam/help/rest-credentials/v1/projects.serviceAccounts/signBlob)
    // method in the IAM Service Account Credentials API instead. If you currently
    // use this method, see the [migration
    // guide](https://cloud.google.com/iam/help/credentials/migrate-api) for
    // instructions.
    //
    // Signs a blob using the system-managed private key for a [ServiceAccount][google.iam.admin.v1.ServiceAccount].
    virtual ::grpc::Status SignBlob(::grpc::ClientContext* context, const ::google::iam::admin::v1::SignBlobRequest& request, ::google::iam::admin::v1::SignBlobResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::SignBlobResponse>> AsyncSignBlob(::grpc::ClientContext* context, const ::google::iam::admin::v1::SignBlobRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::SignBlobResponse>>(AsyncSignBlobRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::SignBlobResponse>> PrepareAsyncSignBlob(::grpc::ClientContext* context, const ::google::iam::admin::v1::SignBlobRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::SignBlobResponse>>(PrepareAsyncSignBlobRaw(context, request, cq));
    }
    // **Note:** This method is deprecated. Use the
    // [`signJwt`](https://cloud.google.com/iam/help/rest-credentials/v1/projects.serviceAccounts/signJwt)
    // method in the IAM Service Account Credentials API instead. If you currently
    // use this method, see the [migration
    // guide](https://cloud.google.com/iam/help/credentials/migrate-api) for
    // instructions.
    //
    // Signs a JSON Web Token (JWT) using the system-managed private key for a
    // [ServiceAccount][google.iam.admin.v1.ServiceAccount].
    virtual ::grpc::Status SignJwt(::grpc::ClientContext* context, const ::google::iam::admin::v1::SignJwtRequest& request, ::google::iam::admin::v1::SignJwtResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::SignJwtResponse>> AsyncSignJwt(::grpc::ClientContext* context, const ::google::iam::admin::v1::SignJwtRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::SignJwtResponse>>(AsyncSignJwtRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::SignJwtResponse>> PrepareAsyncSignJwt(::grpc::ClientContext* context, const ::google::iam::admin::v1::SignJwtRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::SignJwtResponse>>(PrepareAsyncSignJwtRaw(context, request, cq));
    }
    // Gets the IAM policy that is attached to a [ServiceAccount][google.iam.admin.v1.ServiceAccount]. This IAM
    // policy specifies which members have access to the service account.
    //
    // This method does not tell you whether the service account has been granted
    // any roles on other resources. To check whether a service account has role
    // grants on a resource, use the `getIamPolicy` method for that resource. For
    // example, to view the role grants for a project, call the Resource Manager
    // API's
    // [`projects.getIamPolicy`](https://cloud.google.com/resource-manager/reference/rest/v1/projects/getIamPolicy)
    // method.
    virtual ::grpc::Status GetIamPolicy(::grpc::ClientContext* context, const ::google::iam::v1::GetIamPolicyRequest& request, ::google::iam::v1::Policy* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::v1::Policy>> AsyncGetIamPolicy(::grpc::ClientContext* context, const ::google::iam::v1::GetIamPolicyRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::v1::Policy>>(AsyncGetIamPolicyRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::v1::Policy>> PrepareAsyncGetIamPolicy(::grpc::ClientContext* context, const ::google::iam::v1::GetIamPolicyRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::v1::Policy>>(PrepareAsyncGetIamPolicyRaw(context, request, cq));
    }
    // Sets the IAM policy that is attached to a [ServiceAccount][google.iam.admin.v1.ServiceAccount].
    //
    // Use this method to grant or revoke access to the service account. For
    // example, you could grant a member the ability to impersonate the service
    // account.
    //
    // This method does not enable the service account to access other resources.
    // To grant roles to a service account on a resource, follow these steps:
    //
    // 1. Call the resource's `getIamPolicy` method to get its current IAM policy.
    // 2. Edit the policy so that it binds the service account to an IAM role for
    // the resource.
    // 3. Call the resource's `setIamPolicy` method to update its IAM policy.
    //
    // For detailed instructions, see
    // [Granting roles to a service account for specific
    // resources](https://cloud.google.com/iam/help/service-accounts/granting-access-to-service-accounts).
    virtual ::grpc::Status SetIamPolicy(::grpc::ClientContext* context, const ::google::iam::v1::SetIamPolicyRequest& request, ::google::iam::v1::Policy* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::v1::Policy>> AsyncSetIamPolicy(::grpc::ClientContext* context, const ::google::iam::v1::SetIamPolicyRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::v1::Policy>>(AsyncSetIamPolicyRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::v1::Policy>> PrepareAsyncSetIamPolicy(::grpc::ClientContext* context, const ::google::iam::v1::SetIamPolicyRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::v1::Policy>>(PrepareAsyncSetIamPolicyRaw(context, request, cq));
    }
    // Tests whether the caller has the specified permissions on a
    // [ServiceAccount][google.iam.admin.v1.ServiceAccount].
    virtual ::grpc::Status TestIamPermissions(::grpc::ClientContext* context, const ::google::iam::v1::TestIamPermissionsRequest& request, ::google::iam::v1::TestIamPermissionsResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::v1::TestIamPermissionsResponse>> AsyncTestIamPermissions(::grpc::ClientContext* context, const ::google::iam::v1::TestIamPermissionsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::v1::TestIamPermissionsResponse>>(AsyncTestIamPermissionsRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::v1::TestIamPermissionsResponse>> PrepareAsyncTestIamPermissions(::grpc::ClientContext* context, const ::google::iam::v1::TestIamPermissionsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::v1::TestIamPermissionsResponse>>(PrepareAsyncTestIamPermissionsRaw(context, request, cq));
    }
    // Lists roles that can be granted on a Google Cloud resource. A role is
    // grantable if the IAM policy for the resource can contain bindings to the
    // role.
    virtual ::grpc::Status QueryGrantableRoles(::grpc::ClientContext* context, const ::google::iam::admin::v1::QueryGrantableRolesRequest& request, ::google::iam::admin::v1::QueryGrantableRolesResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::QueryGrantableRolesResponse>> AsyncQueryGrantableRoles(::grpc::ClientContext* context, const ::google::iam::admin::v1::QueryGrantableRolesRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::QueryGrantableRolesResponse>>(AsyncQueryGrantableRolesRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::QueryGrantableRolesResponse>> PrepareAsyncQueryGrantableRoles(::grpc::ClientContext* context, const ::google::iam::admin::v1::QueryGrantableRolesRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::QueryGrantableRolesResponse>>(PrepareAsyncQueryGrantableRolesRaw(context, request, cq));
    }
    // Lists every predefined [Role][google.iam.admin.v1.Role] that IAM supports, or every custom role
    // that is defined for an organization or project.
    virtual ::grpc::Status ListRoles(::grpc::ClientContext* context, const ::google::iam::admin::v1::ListRolesRequest& request, ::google::iam::admin::v1::ListRolesResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::ListRolesResponse>> AsyncListRoles(::grpc::ClientContext* context, const ::google::iam::admin::v1::ListRolesRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::ListRolesResponse>>(AsyncListRolesRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::ListRolesResponse>> PrepareAsyncListRoles(::grpc::ClientContext* context, const ::google::iam::admin::v1::ListRolesRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::ListRolesResponse>>(PrepareAsyncListRolesRaw(context, request, cq));
    }
    // Gets the definition of a [Role][google.iam.admin.v1.Role].
    virtual ::grpc::Status GetRole(::grpc::ClientContext* context, const ::google::iam::admin::v1::GetRoleRequest& request, ::google::iam::admin::v1::Role* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::Role>> AsyncGetRole(::grpc::ClientContext* context, const ::google::iam::admin::v1::GetRoleRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::Role>>(AsyncGetRoleRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::Role>> PrepareAsyncGetRole(::grpc::ClientContext* context, const ::google::iam::admin::v1::GetRoleRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::Role>>(PrepareAsyncGetRoleRaw(context, request, cq));
    }
    // Creates a new custom [Role][google.iam.admin.v1.Role].
    virtual ::grpc::Status CreateRole(::grpc::ClientContext* context, const ::google::iam::admin::v1::CreateRoleRequest& request, ::google::iam::admin::v1::Role* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::Role>> AsyncCreateRole(::grpc::ClientContext* context, const ::google::iam::admin::v1::CreateRoleRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::Role>>(AsyncCreateRoleRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::Role>> PrepareAsyncCreateRole(::grpc::ClientContext* context, const ::google::iam::admin::v1::CreateRoleRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::Role>>(PrepareAsyncCreateRoleRaw(context, request, cq));
    }
    // Updates the definition of a custom [Role][google.iam.admin.v1.Role].
    virtual ::grpc::Status UpdateRole(::grpc::ClientContext* context, const ::google::iam::admin::v1::UpdateRoleRequest& request, ::google::iam::admin::v1::Role* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::Role>> AsyncUpdateRole(::grpc::ClientContext* context, const ::google::iam::admin::v1::UpdateRoleRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::Role>>(AsyncUpdateRoleRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::Role>> PrepareAsyncUpdateRole(::grpc::ClientContext* context, const ::google::iam::admin::v1::UpdateRoleRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::Role>>(PrepareAsyncUpdateRoleRaw(context, request, cq));
    }
    // Deletes a custom [Role][google.iam.admin.v1.Role].
    //
    // When you delete a custom role, the following changes occur immediately:
    //
    // * You cannot bind a member to the custom role in an IAM
    // [Policy][google.iam.v1.Policy].
    // * Existing bindings to the custom role are not changed, but they have no
    // effect.
    // * By default, the response from [ListRoles][google.iam.admin.v1.IAM.ListRoles] does not include the custom
    // role.
    //
    // You have 7 days to undelete the custom role. After 7 days, the following
    // changes occur:
    //
    // * The custom role is permanently deleted and cannot be recovered.
    // * If an IAM policy contains a binding to the custom role, the binding is
    // permanently removed.
    virtual ::grpc::Status DeleteRole(::grpc::ClientContext* context, const ::google::iam::admin::v1::DeleteRoleRequest& request, ::google::iam::admin::v1::Role* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::Role>> AsyncDeleteRole(::grpc::ClientContext* context, const ::google::iam::admin::v1::DeleteRoleRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::Role>>(AsyncDeleteRoleRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::Role>> PrepareAsyncDeleteRole(::grpc::ClientContext* context, const ::google::iam::admin::v1::DeleteRoleRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::Role>>(PrepareAsyncDeleteRoleRaw(context, request, cq));
    }
    // Undeletes a custom [Role][google.iam.admin.v1.Role].
    virtual ::grpc::Status UndeleteRole(::grpc::ClientContext* context, const ::google::iam::admin::v1::UndeleteRoleRequest& request, ::google::iam::admin::v1::Role* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::Role>> AsyncUndeleteRole(::grpc::ClientContext* context, const ::google::iam::admin::v1::UndeleteRoleRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::Role>>(AsyncUndeleteRoleRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::Role>> PrepareAsyncUndeleteRole(::grpc::ClientContext* context, const ::google::iam::admin::v1::UndeleteRoleRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::Role>>(PrepareAsyncUndeleteRoleRaw(context, request, cq));
    }
    // Lists every permission that you can test on a resource. A permission is
    // testable if you can check whether a member has that permission on the
    // resource.
    virtual ::grpc::Status QueryTestablePermissions(::grpc::ClientContext* context, const ::google::iam::admin::v1::QueryTestablePermissionsRequest& request, ::google::iam::admin::v1::QueryTestablePermissionsResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::QueryTestablePermissionsResponse>> AsyncQueryTestablePermissions(::grpc::ClientContext* context, const ::google::iam::admin::v1::QueryTestablePermissionsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::QueryTestablePermissionsResponse>>(AsyncQueryTestablePermissionsRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::QueryTestablePermissionsResponse>> PrepareAsyncQueryTestablePermissions(::grpc::ClientContext* context, const ::google::iam::admin::v1::QueryTestablePermissionsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::QueryTestablePermissionsResponse>>(PrepareAsyncQueryTestablePermissionsRaw(context, request, cq));
    }
    // Returns a list of services that allow you to opt into audit logs that are
    // not generated by default.
    //
    // To learn more about audit logs, see the [Logging
    // documentation](https://cloud.google.com/logging/docs/audit).
    virtual ::grpc::Status QueryAuditableServices(::grpc::ClientContext* context, const ::google::iam::admin::v1::QueryAuditableServicesRequest& request, ::google::iam::admin::v1::QueryAuditableServicesResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::QueryAuditableServicesResponse>> AsyncQueryAuditableServices(::grpc::ClientContext* context, const ::google::iam::admin::v1::QueryAuditableServicesRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::QueryAuditableServicesResponse>>(AsyncQueryAuditableServicesRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::QueryAuditableServicesResponse>> PrepareAsyncQueryAuditableServices(::grpc::ClientContext* context, const ::google::iam::admin::v1::QueryAuditableServicesRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::QueryAuditableServicesResponse>>(PrepareAsyncQueryAuditableServicesRaw(context, request, cq));
    }
    // Lints, or validates, an IAM policy. Currently checks the
    // [google.iam.v1.Binding.condition][google.iam.v1.Binding.condition] field, which contains a condition
    // expression for a role binding.
    //
    // Successful calls to this method always return an HTTP `200 OK` status code,
    // even if the linter detects an issue in the IAM policy.
    virtual ::grpc::Status LintPolicy(::grpc::ClientContext* context, const ::google::iam::admin::v1::LintPolicyRequest& request, ::google::iam::admin::v1::LintPolicyResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::LintPolicyResponse>> AsyncLintPolicy(::grpc::ClientContext* context, const ::google::iam::admin::v1::LintPolicyRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::LintPolicyResponse>>(AsyncLintPolicyRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::LintPolicyResponse>> PrepareAsyncLintPolicy(::grpc::ClientContext* context, const ::google::iam::admin::v1::LintPolicyRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::LintPolicyResponse>>(PrepareAsyncLintPolicyRaw(context, request, cq));
    }
    class async_interface {
     public:
      virtual ~async_interface() {}
      // Lists every [ServiceAccount][google.iam.admin.v1.ServiceAccount] that belongs to a specific project.
      virtual void ListServiceAccounts(::grpc::ClientContext* context, const ::google::iam::admin::v1::ListServiceAccountsRequest* request, ::google::iam::admin::v1::ListServiceAccountsResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void ListServiceAccounts(::grpc::ClientContext* context, const ::google::iam::admin::v1::ListServiceAccountsRequest* request, ::google::iam::admin::v1::ListServiceAccountsResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Gets a [ServiceAccount][google.iam.admin.v1.ServiceAccount].
      virtual void GetServiceAccount(::grpc::ClientContext* context, const ::google::iam::admin::v1::GetServiceAccountRequest* request, ::google::iam::admin::v1::ServiceAccount* response, std::function<void(::grpc::Status)>) = 0;
      virtual void GetServiceAccount(::grpc::ClientContext* context, const ::google::iam::admin::v1::GetServiceAccountRequest* request, ::google::iam::admin::v1::ServiceAccount* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Creates a [ServiceAccount][google.iam.admin.v1.ServiceAccount].
      virtual void CreateServiceAccount(::grpc::ClientContext* context, const ::google::iam::admin::v1::CreateServiceAccountRequest* request, ::google::iam::admin::v1::ServiceAccount* response, std::function<void(::grpc::Status)>) = 0;
      virtual void CreateServiceAccount(::grpc::ClientContext* context, const ::google::iam::admin::v1::CreateServiceAccountRequest* request, ::google::iam::admin::v1::ServiceAccount* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // **Note:** We are in the process of deprecating this method. Use
      // [PatchServiceAccount][google.iam.admin.v1.IAM.PatchServiceAccount] instead.
      //
      // Updates a [ServiceAccount][google.iam.admin.v1.ServiceAccount].
      //
      // You can update only the `display_name` and `description` fields.
      virtual void UpdateServiceAccount(::grpc::ClientContext* context, const ::google::iam::admin::v1::ServiceAccount* request, ::google::iam::admin::v1::ServiceAccount* response, std::function<void(::grpc::Status)>) = 0;
      virtual void UpdateServiceAccount(::grpc::ClientContext* context, const ::google::iam::admin::v1::ServiceAccount* request, ::google::iam::admin::v1::ServiceAccount* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Patches a [ServiceAccount][google.iam.admin.v1.ServiceAccount].
      virtual void PatchServiceAccount(::grpc::ClientContext* context, const ::google::iam::admin::v1::PatchServiceAccountRequest* request, ::google::iam::admin::v1::ServiceAccount* response, std::function<void(::grpc::Status)>) = 0;
      virtual void PatchServiceAccount(::grpc::ClientContext* context, const ::google::iam::admin::v1::PatchServiceAccountRequest* request, ::google::iam::admin::v1::ServiceAccount* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Deletes a [ServiceAccount][google.iam.admin.v1.ServiceAccount].
      //
      // **Warning:** After you delete a service account, you might not be able to
      // undelete it. If you know that you need to re-enable the service account in
      // the future, use [DisableServiceAccount][google.iam.admin.v1.IAM.DisableServiceAccount] instead.
      //
      // If you delete a service account, IAM permanently removes the service
      // account 30 days later. Google Cloud cannot recover the service account
      // after it is permanently removed, even if you file a support request.
      //
      // To help avoid unplanned outages, we recommend that you disable the service
      // account before you delete it. Use [DisableServiceAccount][google.iam.admin.v1.IAM.DisableServiceAccount] to disable the
      // service account, then wait at least 24 hours and watch for unintended
      // consequences. If there are no unintended consequences, you can delete the
      // service account.
      virtual void DeleteServiceAccount(::grpc::ClientContext* context, const ::google::iam::admin::v1::DeleteServiceAccountRequest* request, ::google::protobuf::Empty* response, std::function<void(::grpc::Status)>) = 0;
      virtual void DeleteServiceAccount(::grpc::ClientContext* context, const ::google::iam::admin::v1::DeleteServiceAccountRequest* request, ::google::protobuf::Empty* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Restores a deleted [ServiceAccount][google.iam.admin.v1.ServiceAccount].
      //
      // **Important:** It is not always possible to restore a deleted service
      // account. Use this method only as a last resort.
      //
      // After you delete a service account, IAM permanently removes the service
      // account 30 days later. There is no way to restore a deleted service account
      // that has been permanently removed.
      virtual void UndeleteServiceAccount(::grpc::ClientContext* context, const ::google::iam::admin::v1::UndeleteServiceAccountRequest* request, ::google::iam::admin::v1::UndeleteServiceAccountResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void UndeleteServiceAccount(::grpc::ClientContext* context, const ::google::iam::admin::v1::UndeleteServiceAccountRequest* request, ::google::iam::admin::v1::UndeleteServiceAccountResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Enables a [ServiceAccount][google.iam.admin.v1.ServiceAccount] that was disabled by
      // [DisableServiceAccount][google.iam.admin.v1.IAM.DisableServiceAccount].
      //
      // If the service account is already enabled, then this method has no effect.
      //
      // If the service account was disabled by other means—for example, if Google
      // disabled the service account because it was compromised—you cannot use this
      // method to enable the service account.
      virtual void EnableServiceAccount(::grpc::ClientContext* context, const ::google::iam::admin::v1::EnableServiceAccountRequest* request, ::google::protobuf::Empty* response, std::function<void(::grpc::Status)>) = 0;
      virtual void EnableServiceAccount(::grpc::ClientContext* context, const ::google::iam::admin::v1::EnableServiceAccountRequest* request, ::google::protobuf::Empty* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Disables a [ServiceAccount][google.iam.admin.v1.ServiceAccount] immediately.
      //
      // If an application uses the service account to authenticate, that
      // application can no longer call Google APIs or access Google Cloud
      // resources. Existing access tokens for the service account are rejected, and
      // requests for new access tokens will fail.
      //
      // To re-enable the service account, use [EnableServiceAccount][google.iam.admin.v1.IAM.EnableServiceAccount]. After you
      // re-enable the service account, its existing access tokens will be accepted,
      // and you can request new access tokens.
      //
      // To help avoid unplanned outages, we recommend that you disable the service
      // account before you delete it. Use this method to disable the service
      // account, then wait at least 24 hours and watch for unintended consequences.
      // If there are no unintended consequences, you can delete the service account
      // with [DeleteServiceAccount][google.iam.admin.v1.IAM.DeleteServiceAccount].
      virtual void DisableServiceAccount(::grpc::ClientContext* context, const ::google::iam::admin::v1::DisableServiceAccountRequest* request, ::google::protobuf::Empty* response, std::function<void(::grpc::Status)>) = 0;
      virtual void DisableServiceAccount(::grpc::ClientContext* context, const ::google::iam::admin::v1::DisableServiceAccountRequest* request, ::google::protobuf::Empty* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Lists every [ServiceAccountKey][google.iam.admin.v1.ServiceAccountKey] for a service account.
      virtual void ListServiceAccountKeys(::grpc::ClientContext* context, const ::google::iam::admin::v1::ListServiceAccountKeysRequest* request, ::google::iam::admin::v1::ListServiceAccountKeysResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void ListServiceAccountKeys(::grpc::ClientContext* context, const ::google::iam::admin::v1::ListServiceAccountKeysRequest* request, ::google::iam::admin::v1::ListServiceAccountKeysResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Gets a [ServiceAccountKey][google.iam.admin.v1.ServiceAccountKey].
      virtual void GetServiceAccountKey(::grpc::ClientContext* context, const ::google::iam::admin::v1::GetServiceAccountKeyRequest* request, ::google::iam::admin::v1::ServiceAccountKey* response, std::function<void(::grpc::Status)>) = 0;
      virtual void GetServiceAccountKey(::grpc::ClientContext* context, const ::google::iam::admin::v1::GetServiceAccountKeyRequest* request, ::google::iam::admin::v1::ServiceAccountKey* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Creates a [ServiceAccountKey][google.iam.admin.v1.ServiceAccountKey].
      virtual void CreateServiceAccountKey(::grpc::ClientContext* context, const ::google::iam::admin::v1::CreateServiceAccountKeyRequest* request, ::google::iam::admin::v1::ServiceAccountKey* response, std::function<void(::grpc::Status)>) = 0;
      virtual void CreateServiceAccountKey(::grpc::ClientContext* context, const ::google::iam::admin::v1::CreateServiceAccountKeyRequest* request, ::google::iam::admin::v1::ServiceAccountKey* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Creates a [ServiceAccountKey][google.iam.admin.v1.ServiceAccountKey], using a public key that you provide.
      virtual void UploadServiceAccountKey(::grpc::ClientContext* context, const ::google::iam::admin::v1::UploadServiceAccountKeyRequest* request, ::google::iam::admin::v1::ServiceAccountKey* response, std::function<void(::grpc::Status)>) = 0;
      virtual void UploadServiceAccountKey(::grpc::ClientContext* context, const ::google::iam::admin::v1::UploadServiceAccountKeyRequest* request, ::google::iam::admin::v1::ServiceAccountKey* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Deletes a [ServiceAccountKey][google.iam.admin.v1.ServiceAccountKey]. Deleting a service account key does not
      // revoke short-lived credentials that have been issued based on the service
      // account key.
      virtual void DeleteServiceAccountKey(::grpc::ClientContext* context, const ::google::iam::admin::v1::DeleteServiceAccountKeyRequest* request, ::google::protobuf::Empty* response, std::function<void(::grpc::Status)>) = 0;
      virtual void DeleteServiceAccountKey(::grpc::ClientContext* context, const ::google::iam::admin::v1::DeleteServiceAccountKeyRequest* request, ::google::protobuf::Empty* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // **Note:** This method is deprecated. Use the
      // [`signBlob`](https://cloud.google.com/iam/help/rest-credentials/v1/projects.serviceAccounts/signBlob)
      // method in the IAM Service Account Credentials API instead. If you currently
      // use this method, see the [migration
      // guide](https://cloud.google.com/iam/help/credentials/migrate-api) for
      // instructions.
      //
      // Signs a blob using the system-managed private key for a [ServiceAccount][google.iam.admin.v1.ServiceAccount].
      virtual void SignBlob(::grpc::ClientContext* context, const ::google::iam::admin::v1::SignBlobRequest* request, ::google::iam::admin::v1::SignBlobResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void SignBlob(::grpc::ClientContext* context, const ::google::iam::admin::v1::SignBlobRequest* request, ::google::iam::admin::v1::SignBlobResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // **Note:** This method is deprecated. Use the
      // [`signJwt`](https://cloud.google.com/iam/help/rest-credentials/v1/projects.serviceAccounts/signJwt)
      // method in the IAM Service Account Credentials API instead. If you currently
      // use this method, see the [migration
      // guide](https://cloud.google.com/iam/help/credentials/migrate-api) for
      // instructions.
      //
      // Signs a JSON Web Token (JWT) using the system-managed private key for a
      // [ServiceAccount][google.iam.admin.v1.ServiceAccount].
      virtual void SignJwt(::grpc::ClientContext* context, const ::google::iam::admin::v1::SignJwtRequest* request, ::google::iam::admin::v1::SignJwtResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void SignJwt(::grpc::ClientContext* context, const ::google::iam::admin::v1::SignJwtRequest* request, ::google::iam::admin::v1::SignJwtResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Gets the IAM policy that is attached to a [ServiceAccount][google.iam.admin.v1.ServiceAccount]. This IAM
      // policy specifies which members have access to the service account.
      //
      // This method does not tell you whether the service account has been granted
      // any roles on other resources. To check whether a service account has role
      // grants on a resource, use the `getIamPolicy` method for that resource. For
      // example, to view the role grants for a project, call the Resource Manager
      // API's
      // [`projects.getIamPolicy`](https://cloud.google.com/resource-manager/reference/rest/v1/projects/getIamPolicy)
      // method.
      virtual void GetIamPolicy(::grpc::ClientContext* context, const ::google::iam::v1::GetIamPolicyRequest* request, ::google::iam::v1::Policy* response, std::function<void(::grpc::Status)>) = 0;
      virtual void GetIamPolicy(::grpc::ClientContext* context, const ::google::iam::v1::GetIamPolicyRequest* request, ::google::iam::v1::Policy* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Sets the IAM policy that is attached to a [ServiceAccount][google.iam.admin.v1.ServiceAccount].
      //
      // Use this method to grant or revoke access to the service account. For
      // example, you could grant a member the ability to impersonate the service
      // account.
      //
      // This method does not enable the service account to access other resources.
      // To grant roles to a service account on a resource, follow these steps:
      //
      // 1. Call the resource's `getIamPolicy` method to get its current IAM policy.
      // 2. Edit the policy so that it binds the service account to an IAM role for
      // the resource.
      // 3. Call the resource's `setIamPolicy` method to update its IAM policy.
      //
      // For detailed instructions, see
      // [Granting roles to a service account for specific
      // resources](https://cloud.google.com/iam/help/service-accounts/granting-access-to-service-accounts).
      virtual void SetIamPolicy(::grpc::ClientContext* context, const ::google::iam::v1::SetIamPolicyRequest* request, ::google::iam::v1::Policy* response, std::function<void(::grpc::Status)>) = 0;
      virtual void SetIamPolicy(::grpc::ClientContext* context, const ::google::iam::v1::SetIamPolicyRequest* request, ::google::iam::v1::Policy* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Tests whether the caller has the specified permissions on a
      // [ServiceAccount][google.iam.admin.v1.ServiceAccount].
      virtual void TestIamPermissions(::grpc::ClientContext* context, const ::google::iam::v1::TestIamPermissionsRequest* request, ::google::iam::v1::TestIamPermissionsResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void TestIamPermissions(::grpc::ClientContext* context, const ::google::iam::v1::TestIamPermissionsRequest* request, ::google::iam::v1::TestIamPermissionsResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Lists roles that can be granted on a Google Cloud resource. A role is
      // grantable if the IAM policy for the resource can contain bindings to the
      // role.
      virtual void QueryGrantableRoles(::grpc::ClientContext* context, const ::google::iam::admin::v1::QueryGrantableRolesRequest* request, ::google::iam::admin::v1::QueryGrantableRolesResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void QueryGrantableRoles(::grpc::ClientContext* context, const ::google::iam::admin::v1::QueryGrantableRolesRequest* request, ::google::iam::admin::v1::QueryGrantableRolesResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Lists every predefined [Role][google.iam.admin.v1.Role] that IAM supports, or every custom role
      // that is defined for an organization or project.
      virtual void ListRoles(::grpc::ClientContext* context, const ::google::iam::admin::v1::ListRolesRequest* request, ::google::iam::admin::v1::ListRolesResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void ListRoles(::grpc::ClientContext* context, const ::google::iam::admin::v1::ListRolesRequest* request, ::google::iam::admin::v1::ListRolesResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Gets the definition of a [Role][google.iam.admin.v1.Role].
      virtual void GetRole(::grpc::ClientContext* context, const ::google::iam::admin::v1::GetRoleRequest* request, ::google::iam::admin::v1::Role* response, std::function<void(::grpc::Status)>) = 0;
      virtual void GetRole(::grpc::ClientContext* context, const ::google::iam::admin::v1::GetRoleRequest* request, ::google::iam::admin::v1::Role* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Creates a new custom [Role][google.iam.admin.v1.Role].
      virtual void CreateRole(::grpc::ClientContext* context, const ::google::iam::admin::v1::CreateRoleRequest* request, ::google::iam::admin::v1::Role* response, std::function<void(::grpc::Status)>) = 0;
      virtual void CreateRole(::grpc::ClientContext* context, const ::google::iam::admin::v1::CreateRoleRequest* request, ::google::iam::admin::v1::Role* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Updates the definition of a custom [Role][google.iam.admin.v1.Role].
      virtual void UpdateRole(::grpc::ClientContext* context, const ::google::iam::admin::v1::UpdateRoleRequest* request, ::google::iam::admin::v1::Role* response, std::function<void(::grpc::Status)>) = 0;
      virtual void UpdateRole(::grpc::ClientContext* context, const ::google::iam::admin::v1::UpdateRoleRequest* request, ::google::iam::admin::v1::Role* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Deletes a custom [Role][google.iam.admin.v1.Role].
      //
      // When you delete a custom role, the following changes occur immediately:
      //
      // * You cannot bind a member to the custom role in an IAM
      // [Policy][google.iam.v1.Policy].
      // * Existing bindings to the custom role are not changed, but they have no
      // effect.
      // * By default, the response from [ListRoles][google.iam.admin.v1.IAM.ListRoles] does not include the custom
      // role.
      //
      // You have 7 days to undelete the custom role. After 7 days, the following
      // changes occur:
      //
      // * The custom role is permanently deleted and cannot be recovered.
      // * If an IAM policy contains a binding to the custom role, the binding is
      // permanently removed.
      virtual void DeleteRole(::grpc::ClientContext* context, const ::google::iam::admin::v1::DeleteRoleRequest* request, ::google::iam::admin::v1::Role* response, std::function<void(::grpc::Status)>) = 0;
      virtual void DeleteRole(::grpc::ClientContext* context, const ::google::iam::admin::v1::DeleteRoleRequest* request, ::google::iam::admin::v1::Role* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Undeletes a custom [Role][google.iam.admin.v1.Role].
      virtual void UndeleteRole(::grpc::ClientContext* context, const ::google::iam::admin::v1::UndeleteRoleRequest* request, ::google::iam::admin::v1::Role* response, std::function<void(::grpc::Status)>) = 0;
      virtual void UndeleteRole(::grpc::ClientContext* context, const ::google::iam::admin::v1::UndeleteRoleRequest* request, ::google::iam::admin::v1::Role* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Lists every permission that you can test on a resource. A permission is
      // testable if you can check whether a member has that permission on the
      // resource.
      virtual void QueryTestablePermissions(::grpc::ClientContext* context, const ::google::iam::admin::v1::QueryTestablePermissionsRequest* request, ::google::iam::admin::v1::QueryTestablePermissionsResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void QueryTestablePermissions(::grpc::ClientContext* context, const ::google::iam::admin::v1::QueryTestablePermissionsRequest* request, ::google::iam::admin::v1::QueryTestablePermissionsResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Returns a list of services that allow you to opt into audit logs that are
      // not generated by default.
      //
      // To learn more about audit logs, see the [Logging
      // documentation](https://cloud.google.com/logging/docs/audit).
      virtual void QueryAuditableServices(::grpc::ClientContext* context, const ::google::iam::admin::v1::QueryAuditableServicesRequest* request, ::google::iam::admin::v1::QueryAuditableServicesResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void QueryAuditableServices(::grpc::ClientContext* context, const ::google::iam::admin::v1::QueryAuditableServicesRequest* request, ::google::iam::admin::v1::QueryAuditableServicesResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Lints, or validates, an IAM policy. Currently checks the
      // [google.iam.v1.Binding.condition][google.iam.v1.Binding.condition] field, which contains a condition
      // expression for a role binding.
      //
      // Successful calls to this method always return an HTTP `200 OK` status code,
      // even if the linter detects an issue in the IAM policy.
      virtual void LintPolicy(::grpc::ClientContext* context, const ::google::iam::admin::v1::LintPolicyRequest* request, ::google::iam::admin::v1::LintPolicyResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void LintPolicy(::grpc::ClientContext* context, const ::google::iam::admin::v1::LintPolicyRequest* request, ::google::iam::admin::v1::LintPolicyResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
    };
    typedef class async_interface experimental_async_interface;
    virtual class async_interface* async() { return nullptr; }
    class async_interface* experimental_async() { return async(); }
   private:
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::ListServiceAccountsResponse>* AsyncListServiceAccountsRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::ListServiceAccountsRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::ListServiceAccountsResponse>* PrepareAsyncListServiceAccountsRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::ListServiceAccountsRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::ServiceAccount>* AsyncGetServiceAccountRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::GetServiceAccountRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::ServiceAccount>* PrepareAsyncGetServiceAccountRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::GetServiceAccountRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::ServiceAccount>* AsyncCreateServiceAccountRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::CreateServiceAccountRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::ServiceAccount>* PrepareAsyncCreateServiceAccountRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::CreateServiceAccountRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::ServiceAccount>* AsyncUpdateServiceAccountRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::ServiceAccount& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::ServiceAccount>* PrepareAsyncUpdateServiceAccountRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::ServiceAccount& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::ServiceAccount>* AsyncPatchServiceAccountRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::PatchServiceAccountRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::ServiceAccount>* PrepareAsyncPatchServiceAccountRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::PatchServiceAccountRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>* AsyncDeleteServiceAccountRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::DeleteServiceAccountRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>* PrepareAsyncDeleteServiceAccountRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::DeleteServiceAccountRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::UndeleteServiceAccountResponse>* AsyncUndeleteServiceAccountRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::UndeleteServiceAccountRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::UndeleteServiceAccountResponse>* PrepareAsyncUndeleteServiceAccountRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::UndeleteServiceAccountRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>* AsyncEnableServiceAccountRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::EnableServiceAccountRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>* PrepareAsyncEnableServiceAccountRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::EnableServiceAccountRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>* AsyncDisableServiceAccountRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::DisableServiceAccountRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>* PrepareAsyncDisableServiceAccountRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::DisableServiceAccountRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::ListServiceAccountKeysResponse>* AsyncListServiceAccountKeysRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::ListServiceAccountKeysRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::ListServiceAccountKeysResponse>* PrepareAsyncListServiceAccountKeysRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::ListServiceAccountKeysRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::ServiceAccountKey>* AsyncGetServiceAccountKeyRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::GetServiceAccountKeyRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::ServiceAccountKey>* PrepareAsyncGetServiceAccountKeyRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::GetServiceAccountKeyRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::ServiceAccountKey>* AsyncCreateServiceAccountKeyRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::CreateServiceAccountKeyRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::ServiceAccountKey>* PrepareAsyncCreateServiceAccountKeyRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::CreateServiceAccountKeyRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::ServiceAccountKey>* AsyncUploadServiceAccountKeyRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::UploadServiceAccountKeyRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::ServiceAccountKey>* PrepareAsyncUploadServiceAccountKeyRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::UploadServiceAccountKeyRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>* AsyncDeleteServiceAccountKeyRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::DeleteServiceAccountKeyRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>* PrepareAsyncDeleteServiceAccountKeyRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::DeleteServiceAccountKeyRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::SignBlobResponse>* AsyncSignBlobRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::SignBlobRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::SignBlobResponse>* PrepareAsyncSignBlobRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::SignBlobRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::SignJwtResponse>* AsyncSignJwtRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::SignJwtRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::SignJwtResponse>* PrepareAsyncSignJwtRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::SignJwtRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::v1::Policy>* AsyncGetIamPolicyRaw(::grpc::ClientContext* context, const ::google::iam::v1::GetIamPolicyRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::v1::Policy>* PrepareAsyncGetIamPolicyRaw(::grpc::ClientContext* context, const ::google::iam::v1::GetIamPolicyRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::v1::Policy>* AsyncSetIamPolicyRaw(::grpc::ClientContext* context, const ::google::iam::v1::SetIamPolicyRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::v1::Policy>* PrepareAsyncSetIamPolicyRaw(::grpc::ClientContext* context, const ::google::iam::v1::SetIamPolicyRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::v1::TestIamPermissionsResponse>* AsyncTestIamPermissionsRaw(::grpc::ClientContext* context, const ::google::iam::v1::TestIamPermissionsRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::v1::TestIamPermissionsResponse>* PrepareAsyncTestIamPermissionsRaw(::grpc::ClientContext* context, const ::google::iam::v1::TestIamPermissionsRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::QueryGrantableRolesResponse>* AsyncQueryGrantableRolesRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::QueryGrantableRolesRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::QueryGrantableRolesResponse>* PrepareAsyncQueryGrantableRolesRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::QueryGrantableRolesRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::ListRolesResponse>* AsyncListRolesRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::ListRolesRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::ListRolesResponse>* PrepareAsyncListRolesRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::ListRolesRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::Role>* AsyncGetRoleRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::GetRoleRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::Role>* PrepareAsyncGetRoleRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::GetRoleRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::Role>* AsyncCreateRoleRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::CreateRoleRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::Role>* PrepareAsyncCreateRoleRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::CreateRoleRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::Role>* AsyncUpdateRoleRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::UpdateRoleRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::Role>* PrepareAsyncUpdateRoleRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::UpdateRoleRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::Role>* AsyncDeleteRoleRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::DeleteRoleRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::Role>* PrepareAsyncDeleteRoleRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::DeleteRoleRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::Role>* AsyncUndeleteRoleRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::UndeleteRoleRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::Role>* PrepareAsyncUndeleteRoleRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::UndeleteRoleRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::QueryTestablePermissionsResponse>* AsyncQueryTestablePermissionsRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::QueryTestablePermissionsRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::QueryTestablePermissionsResponse>* PrepareAsyncQueryTestablePermissionsRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::QueryTestablePermissionsRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::QueryAuditableServicesResponse>* AsyncQueryAuditableServicesRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::QueryAuditableServicesRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::QueryAuditableServicesResponse>* PrepareAsyncQueryAuditableServicesRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::QueryAuditableServicesRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::LintPolicyResponse>* AsyncLintPolicyRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::LintPolicyRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::admin::v1::LintPolicyResponse>* PrepareAsyncLintPolicyRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::LintPolicyRequest& request, ::grpc::CompletionQueue* cq) = 0;
  };
  class Stub final : public StubInterface {
   public:
    Stub(const std::shared_ptr< ::grpc::ChannelInterface>& channel, const ::grpc::StubOptions& options = ::grpc::StubOptions());
    ::grpc::Status ListServiceAccounts(::grpc::ClientContext* context, const ::google::iam::admin::v1::ListServiceAccountsRequest& request, ::google::iam::admin::v1::ListServiceAccountsResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::ListServiceAccountsResponse>> AsyncListServiceAccounts(::grpc::ClientContext* context, const ::google::iam::admin::v1::ListServiceAccountsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::ListServiceAccountsResponse>>(AsyncListServiceAccountsRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::ListServiceAccountsResponse>> PrepareAsyncListServiceAccounts(::grpc::ClientContext* context, const ::google::iam::admin::v1::ListServiceAccountsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::ListServiceAccountsResponse>>(PrepareAsyncListServiceAccountsRaw(context, request, cq));
    }
    ::grpc::Status GetServiceAccount(::grpc::ClientContext* context, const ::google::iam::admin::v1::GetServiceAccountRequest& request, ::google::iam::admin::v1::ServiceAccount* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::ServiceAccount>> AsyncGetServiceAccount(::grpc::ClientContext* context, const ::google::iam::admin::v1::GetServiceAccountRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::ServiceAccount>>(AsyncGetServiceAccountRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::ServiceAccount>> PrepareAsyncGetServiceAccount(::grpc::ClientContext* context, const ::google::iam::admin::v1::GetServiceAccountRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::ServiceAccount>>(PrepareAsyncGetServiceAccountRaw(context, request, cq));
    }
    ::grpc::Status CreateServiceAccount(::grpc::ClientContext* context, const ::google::iam::admin::v1::CreateServiceAccountRequest& request, ::google::iam::admin::v1::ServiceAccount* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::ServiceAccount>> AsyncCreateServiceAccount(::grpc::ClientContext* context, const ::google::iam::admin::v1::CreateServiceAccountRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::ServiceAccount>>(AsyncCreateServiceAccountRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::ServiceAccount>> PrepareAsyncCreateServiceAccount(::grpc::ClientContext* context, const ::google::iam::admin::v1::CreateServiceAccountRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::ServiceAccount>>(PrepareAsyncCreateServiceAccountRaw(context, request, cq));
    }
    ::grpc::Status UpdateServiceAccount(::grpc::ClientContext* context, const ::google::iam::admin::v1::ServiceAccount& request, ::google::iam::admin::v1::ServiceAccount* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::ServiceAccount>> AsyncUpdateServiceAccount(::grpc::ClientContext* context, const ::google::iam::admin::v1::ServiceAccount& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::ServiceAccount>>(AsyncUpdateServiceAccountRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::ServiceAccount>> PrepareAsyncUpdateServiceAccount(::grpc::ClientContext* context, const ::google::iam::admin::v1::ServiceAccount& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::ServiceAccount>>(PrepareAsyncUpdateServiceAccountRaw(context, request, cq));
    }
    ::grpc::Status PatchServiceAccount(::grpc::ClientContext* context, const ::google::iam::admin::v1::PatchServiceAccountRequest& request, ::google::iam::admin::v1::ServiceAccount* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::ServiceAccount>> AsyncPatchServiceAccount(::grpc::ClientContext* context, const ::google::iam::admin::v1::PatchServiceAccountRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::ServiceAccount>>(AsyncPatchServiceAccountRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::ServiceAccount>> PrepareAsyncPatchServiceAccount(::grpc::ClientContext* context, const ::google::iam::admin::v1::PatchServiceAccountRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::ServiceAccount>>(PrepareAsyncPatchServiceAccountRaw(context, request, cq));
    }
    ::grpc::Status DeleteServiceAccount(::grpc::ClientContext* context, const ::google::iam::admin::v1::DeleteServiceAccountRequest& request, ::google::protobuf::Empty* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>> AsyncDeleteServiceAccount(::grpc::ClientContext* context, const ::google::iam::admin::v1::DeleteServiceAccountRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>>(AsyncDeleteServiceAccountRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>> PrepareAsyncDeleteServiceAccount(::grpc::ClientContext* context, const ::google::iam::admin::v1::DeleteServiceAccountRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>>(PrepareAsyncDeleteServiceAccountRaw(context, request, cq));
    }
    ::grpc::Status UndeleteServiceAccount(::grpc::ClientContext* context, const ::google::iam::admin::v1::UndeleteServiceAccountRequest& request, ::google::iam::admin::v1::UndeleteServiceAccountResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::UndeleteServiceAccountResponse>> AsyncUndeleteServiceAccount(::grpc::ClientContext* context, const ::google::iam::admin::v1::UndeleteServiceAccountRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::UndeleteServiceAccountResponse>>(AsyncUndeleteServiceAccountRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::UndeleteServiceAccountResponse>> PrepareAsyncUndeleteServiceAccount(::grpc::ClientContext* context, const ::google::iam::admin::v1::UndeleteServiceAccountRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::UndeleteServiceAccountResponse>>(PrepareAsyncUndeleteServiceAccountRaw(context, request, cq));
    }
    ::grpc::Status EnableServiceAccount(::grpc::ClientContext* context, const ::google::iam::admin::v1::EnableServiceAccountRequest& request, ::google::protobuf::Empty* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>> AsyncEnableServiceAccount(::grpc::ClientContext* context, const ::google::iam::admin::v1::EnableServiceAccountRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>>(AsyncEnableServiceAccountRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>> PrepareAsyncEnableServiceAccount(::grpc::ClientContext* context, const ::google::iam::admin::v1::EnableServiceAccountRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>>(PrepareAsyncEnableServiceAccountRaw(context, request, cq));
    }
    ::grpc::Status DisableServiceAccount(::grpc::ClientContext* context, const ::google::iam::admin::v1::DisableServiceAccountRequest& request, ::google::protobuf::Empty* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>> AsyncDisableServiceAccount(::grpc::ClientContext* context, const ::google::iam::admin::v1::DisableServiceAccountRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>>(AsyncDisableServiceAccountRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>> PrepareAsyncDisableServiceAccount(::grpc::ClientContext* context, const ::google::iam::admin::v1::DisableServiceAccountRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>>(PrepareAsyncDisableServiceAccountRaw(context, request, cq));
    }
    ::grpc::Status ListServiceAccountKeys(::grpc::ClientContext* context, const ::google::iam::admin::v1::ListServiceAccountKeysRequest& request, ::google::iam::admin::v1::ListServiceAccountKeysResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::ListServiceAccountKeysResponse>> AsyncListServiceAccountKeys(::grpc::ClientContext* context, const ::google::iam::admin::v1::ListServiceAccountKeysRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::ListServiceAccountKeysResponse>>(AsyncListServiceAccountKeysRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::ListServiceAccountKeysResponse>> PrepareAsyncListServiceAccountKeys(::grpc::ClientContext* context, const ::google::iam::admin::v1::ListServiceAccountKeysRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::ListServiceAccountKeysResponse>>(PrepareAsyncListServiceAccountKeysRaw(context, request, cq));
    }
    ::grpc::Status GetServiceAccountKey(::grpc::ClientContext* context, const ::google::iam::admin::v1::GetServiceAccountKeyRequest& request, ::google::iam::admin::v1::ServiceAccountKey* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::ServiceAccountKey>> AsyncGetServiceAccountKey(::grpc::ClientContext* context, const ::google::iam::admin::v1::GetServiceAccountKeyRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::ServiceAccountKey>>(AsyncGetServiceAccountKeyRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::ServiceAccountKey>> PrepareAsyncGetServiceAccountKey(::grpc::ClientContext* context, const ::google::iam::admin::v1::GetServiceAccountKeyRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::ServiceAccountKey>>(PrepareAsyncGetServiceAccountKeyRaw(context, request, cq));
    }
    ::grpc::Status CreateServiceAccountKey(::grpc::ClientContext* context, const ::google::iam::admin::v1::CreateServiceAccountKeyRequest& request, ::google::iam::admin::v1::ServiceAccountKey* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::ServiceAccountKey>> AsyncCreateServiceAccountKey(::grpc::ClientContext* context, const ::google::iam::admin::v1::CreateServiceAccountKeyRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::ServiceAccountKey>>(AsyncCreateServiceAccountKeyRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::ServiceAccountKey>> PrepareAsyncCreateServiceAccountKey(::grpc::ClientContext* context, const ::google::iam::admin::v1::CreateServiceAccountKeyRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::ServiceAccountKey>>(PrepareAsyncCreateServiceAccountKeyRaw(context, request, cq));
    }
    ::grpc::Status UploadServiceAccountKey(::grpc::ClientContext* context, const ::google::iam::admin::v1::UploadServiceAccountKeyRequest& request, ::google::iam::admin::v1::ServiceAccountKey* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::ServiceAccountKey>> AsyncUploadServiceAccountKey(::grpc::ClientContext* context, const ::google::iam::admin::v1::UploadServiceAccountKeyRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::ServiceAccountKey>>(AsyncUploadServiceAccountKeyRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::ServiceAccountKey>> PrepareAsyncUploadServiceAccountKey(::grpc::ClientContext* context, const ::google::iam::admin::v1::UploadServiceAccountKeyRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::ServiceAccountKey>>(PrepareAsyncUploadServiceAccountKeyRaw(context, request, cq));
    }
    ::grpc::Status DeleteServiceAccountKey(::grpc::ClientContext* context, const ::google::iam::admin::v1::DeleteServiceAccountKeyRequest& request, ::google::protobuf::Empty* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>> AsyncDeleteServiceAccountKey(::grpc::ClientContext* context, const ::google::iam::admin::v1::DeleteServiceAccountKeyRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>>(AsyncDeleteServiceAccountKeyRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>> PrepareAsyncDeleteServiceAccountKey(::grpc::ClientContext* context, const ::google::iam::admin::v1::DeleteServiceAccountKeyRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>>(PrepareAsyncDeleteServiceAccountKeyRaw(context, request, cq));
    }
    ::grpc::Status SignBlob(::grpc::ClientContext* context, const ::google::iam::admin::v1::SignBlobRequest& request, ::google::iam::admin::v1::SignBlobResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::SignBlobResponse>> AsyncSignBlob(::grpc::ClientContext* context, const ::google::iam::admin::v1::SignBlobRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::SignBlobResponse>>(AsyncSignBlobRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::SignBlobResponse>> PrepareAsyncSignBlob(::grpc::ClientContext* context, const ::google::iam::admin::v1::SignBlobRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::SignBlobResponse>>(PrepareAsyncSignBlobRaw(context, request, cq));
    }
    ::grpc::Status SignJwt(::grpc::ClientContext* context, const ::google::iam::admin::v1::SignJwtRequest& request, ::google::iam::admin::v1::SignJwtResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::SignJwtResponse>> AsyncSignJwt(::grpc::ClientContext* context, const ::google::iam::admin::v1::SignJwtRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::SignJwtResponse>>(AsyncSignJwtRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::SignJwtResponse>> PrepareAsyncSignJwt(::grpc::ClientContext* context, const ::google::iam::admin::v1::SignJwtRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::SignJwtResponse>>(PrepareAsyncSignJwtRaw(context, request, cq));
    }
    ::grpc::Status GetIamPolicy(::grpc::ClientContext* context, const ::google::iam::v1::GetIamPolicyRequest& request, ::google::iam::v1::Policy* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::v1::Policy>> AsyncGetIamPolicy(::grpc::ClientContext* context, const ::google::iam::v1::GetIamPolicyRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::v1::Policy>>(AsyncGetIamPolicyRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::v1::Policy>> PrepareAsyncGetIamPolicy(::grpc::ClientContext* context, const ::google::iam::v1::GetIamPolicyRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::v1::Policy>>(PrepareAsyncGetIamPolicyRaw(context, request, cq));
    }
    ::grpc::Status SetIamPolicy(::grpc::ClientContext* context, const ::google::iam::v1::SetIamPolicyRequest& request, ::google::iam::v1::Policy* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::v1::Policy>> AsyncSetIamPolicy(::grpc::ClientContext* context, const ::google::iam::v1::SetIamPolicyRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::v1::Policy>>(AsyncSetIamPolicyRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::v1::Policy>> PrepareAsyncSetIamPolicy(::grpc::ClientContext* context, const ::google::iam::v1::SetIamPolicyRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::v1::Policy>>(PrepareAsyncSetIamPolicyRaw(context, request, cq));
    }
    ::grpc::Status TestIamPermissions(::grpc::ClientContext* context, const ::google::iam::v1::TestIamPermissionsRequest& request, ::google::iam::v1::TestIamPermissionsResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::v1::TestIamPermissionsResponse>> AsyncTestIamPermissions(::grpc::ClientContext* context, const ::google::iam::v1::TestIamPermissionsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::v1::TestIamPermissionsResponse>>(AsyncTestIamPermissionsRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::v1::TestIamPermissionsResponse>> PrepareAsyncTestIamPermissions(::grpc::ClientContext* context, const ::google::iam::v1::TestIamPermissionsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::v1::TestIamPermissionsResponse>>(PrepareAsyncTestIamPermissionsRaw(context, request, cq));
    }
    ::grpc::Status QueryGrantableRoles(::grpc::ClientContext* context, const ::google::iam::admin::v1::QueryGrantableRolesRequest& request, ::google::iam::admin::v1::QueryGrantableRolesResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::QueryGrantableRolesResponse>> AsyncQueryGrantableRoles(::grpc::ClientContext* context, const ::google::iam::admin::v1::QueryGrantableRolesRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::QueryGrantableRolesResponse>>(AsyncQueryGrantableRolesRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::QueryGrantableRolesResponse>> PrepareAsyncQueryGrantableRoles(::grpc::ClientContext* context, const ::google::iam::admin::v1::QueryGrantableRolesRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::QueryGrantableRolesResponse>>(PrepareAsyncQueryGrantableRolesRaw(context, request, cq));
    }
    ::grpc::Status ListRoles(::grpc::ClientContext* context, const ::google::iam::admin::v1::ListRolesRequest& request, ::google::iam::admin::v1::ListRolesResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::ListRolesResponse>> AsyncListRoles(::grpc::ClientContext* context, const ::google::iam::admin::v1::ListRolesRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::ListRolesResponse>>(AsyncListRolesRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::ListRolesResponse>> PrepareAsyncListRoles(::grpc::ClientContext* context, const ::google::iam::admin::v1::ListRolesRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::ListRolesResponse>>(PrepareAsyncListRolesRaw(context, request, cq));
    }
    ::grpc::Status GetRole(::grpc::ClientContext* context, const ::google::iam::admin::v1::GetRoleRequest& request, ::google::iam::admin::v1::Role* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::Role>> AsyncGetRole(::grpc::ClientContext* context, const ::google::iam::admin::v1::GetRoleRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::Role>>(AsyncGetRoleRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::Role>> PrepareAsyncGetRole(::grpc::ClientContext* context, const ::google::iam::admin::v1::GetRoleRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::Role>>(PrepareAsyncGetRoleRaw(context, request, cq));
    }
    ::grpc::Status CreateRole(::grpc::ClientContext* context, const ::google::iam::admin::v1::CreateRoleRequest& request, ::google::iam::admin::v1::Role* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::Role>> AsyncCreateRole(::grpc::ClientContext* context, const ::google::iam::admin::v1::CreateRoleRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::Role>>(AsyncCreateRoleRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::Role>> PrepareAsyncCreateRole(::grpc::ClientContext* context, const ::google::iam::admin::v1::CreateRoleRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::Role>>(PrepareAsyncCreateRoleRaw(context, request, cq));
    }
    ::grpc::Status UpdateRole(::grpc::ClientContext* context, const ::google::iam::admin::v1::UpdateRoleRequest& request, ::google::iam::admin::v1::Role* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::Role>> AsyncUpdateRole(::grpc::ClientContext* context, const ::google::iam::admin::v1::UpdateRoleRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::Role>>(AsyncUpdateRoleRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::Role>> PrepareAsyncUpdateRole(::grpc::ClientContext* context, const ::google::iam::admin::v1::UpdateRoleRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::Role>>(PrepareAsyncUpdateRoleRaw(context, request, cq));
    }
    ::grpc::Status DeleteRole(::grpc::ClientContext* context, const ::google::iam::admin::v1::DeleteRoleRequest& request, ::google::iam::admin::v1::Role* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::Role>> AsyncDeleteRole(::grpc::ClientContext* context, const ::google::iam::admin::v1::DeleteRoleRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::Role>>(AsyncDeleteRoleRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::Role>> PrepareAsyncDeleteRole(::grpc::ClientContext* context, const ::google::iam::admin::v1::DeleteRoleRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::Role>>(PrepareAsyncDeleteRoleRaw(context, request, cq));
    }
    ::grpc::Status UndeleteRole(::grpc::ClientContext* context, const ::google::iam::admin::v1::UndeleteRoleRequest& request, ::google::iam::admin::v1::Role* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::Role>> AsyncUndeleteRole(::grpc::ClientContext* context, const ::google::iam::admin::v1::UndeleteRoleRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::Role>>(AsyncUndeleteRoleRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::Role>> PrepareAsyncUndeleteRole(::grpc::ClientContext* context, const ::google::iam::admin::v1::UndeleteRoleRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::Role>>(PrepareAsyncUndeleteRoleRaw(context, request, cq));
    }
    ::grpc::Status QueryTestablePermissions(::grpc::ClientContext* context, const ::google::iam::admin::v1::QueryTestablePermissionsRequest& request, ::google::iam::admin::v1::QueryTestablePermissionsResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::QueryTestablePermissionsResponse>> AsyncQueryTestablePermissions(::grpc::ClientContext* context, const ::google::iam::admin::v1::QueryTestablePermissionsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::QueryTestablePermissionsResponse>>(AsyncQueryTestablePermissionsRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::QueryTestablePermissionsResponse>> PrepareAsyncQueryTestablePermissions(::grpc::ClientContext* context, const ::google::iam::admin::v1::QueryTestablePermissionsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::QueryTestablePermissionsResponse>>(PrepareAsyncQueryTestablePermissionsRaw(context, request, cq));
    }
    ::grpc::Status QueryAuditableServices(::grpc::ClientContext* context, const ::google::iam::admin::v1::QueryAuditableServicesRequest& request, ::google::iam::admin::v1::QueryAuditableServicesResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::QueryAuditableServicesResponse>> AsyncQueryAuditableServices(::grpc::ClientContext* context, const ::google::iam::admin::v1::QueryAuditableServicesRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::QueryAuditableServicesResponse>>(AsyncQueryAuditableServicesRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::QueryAuditableServicesResponse>> PrepareAsyncQueryAuditableServices(::grpc::ClientContext* context, const ::google::iam::admin::v1::QueryAuditableServicesRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::QueryAuditableServicesResponse>>(PrepareAsyncQueryAuditableServicesRaw(context, request, cq));
    }
    ::grpc::Status LintPolicy(::grpc::ClientContext* context, const ::google::iam::admin::v1::LintPolicyRequest& request, ::google::iam::admin::v1::LintPolicyResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::LintPolicyResponse>> AsyncLintPolicy(::grpc::ClientContext* context, const ::google::iam::admin::v1::LintPolicyRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::LintPolicyResponse>>(AsyncLintPolicyRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::LintPolicyResponse>> PrepareAsyncLintPolicy(::grpc::ClientContext* context, const ::google::iam::admin::v1::LintPolicyRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::LintPolicyResponse>>(PrepareAsyncLintPolicyRaw(context, request, cq));
    }
    class async final :
      public StubInterface::async_interface {
     public:
      void ListServiceAccounts(::grpc::ClientContext* context, const ::google::iam::admin::v1::ListServiceAccountsRequest* request, ::google::iam::admin::v1::ListServiceAccountsResponse* response, std::function<void(::grpc::Status)>) override;
      void ListServiceAccounts(::grpc::ClientContext* context, const ::google::iam::admin::v1::ListServiceAccountsRequest* request, ::google::iam::admin::v1::ListServiceAccountsResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
      void GetServiceAccount(::grpc::ClientContext* context, const ::google::iam::admin::v1::GetServiceAccountRequest* request, ::google::iam::admin::v1::ServiceAccount* response, std::function<void(::grpc::Status)>) override;
      void GetServiceAccount(::grpc::ClientContext* context, const ::google::iam::admin::v1::GetServiceAccountRequest* request, ::google::iam::admin::v1::ServiceAccount* response, ::grpc::ClientUnaryReactor* reactor) override;
      void CreateServiceAccount(::grpc::ClientContext* context, const ::google::iam::admin::v1::CreateServiceAccountRequest* request, ::google::iam::admin::v1::ServiceAccount* response, std::function<void(::grpc::Status)>) override;
      void CreateServiceAccount(::grpc::ClientContext* context, const ::google::iam::admin::v1::CreateServiceAccountRequest* request, ::google::iam::admin::v1::ServiceAccount* response, ::grpc::ClientUnaryReactor* reactor) override;
      void UpdateServiceAccount(::grpc::ClientContext* context, const ::google::iam::admin::v1::ServiceAccount* request, ::google::iam::admin::v1::ServiceAccount* response, std::function<void(::grpc::Status)>) override;
      void UpdateServiceAccount(::grpc::ClientContext* context, const ::google::iam::admin::v1::ServiceAccount* request, ::google::iam::admin::v1::ServiceAccount* response, ::grpc::ClientUnaryReactor* reactor) override;
      void PatchServiceAccount(::grpc::ClientContext* context, const ::google::iam::admin::v1::PatchServiceAccountRequest* request, ::google::iam::admin::v1::ServiceAccount* response, std::function<void(::grpc::Status)>) override;
      void PatchServiceAccount(::grpc::ClientContext* context, const ::google::iam::admin::v1::PatchServiceAccountRequest* request, ::google::iam::admin::v1::ServiceAccount* response, ::grpc::ClientUnaryReactor* reactor) override;
      void DeleteServiceAccount(::grpc::ClientContext* context, const ::google::iam::admin::v1::DeleteServiceAccountRequest* request, ::google::protobuf::Empty* response, std::function<void(::grpc::Status)>) override;
      void DeleteServiceAccount(::grpc::ClientContext* context, const ::google::iam::admin::v1::DeleteServiceAccountRequest* request, ::google::protobuf::Empty* response, ::grpc::ClientUnaryReactor* reactor) override;
      void UndeleteServiceAccount(::grpc::ClientContext* context, const ::google::iam::admin::v1::UndeleteServiceAccountRequest* request, ::google::iam::admin::v1::UndeleteServiceAccountResponse* response, std::function<void(::grpc::Status)>) override;
      void UndeleteServiceAccount(::grpc::ClientContext* context, const ::google::iam::admin::v1::UndeleteServiceAccountRequest* request, ::google::iam::admin::v1::UndeleteServiceAccountResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
      void EnableServiceAccount(::grpc::ClientContext* context, const ::google::iam::admin::v1::EnableServiceAccountRequest* request, ::google::protobuf::Empty* response, std::function<void(::grpc::Status)>) override;
      void EnableServiceAccount(::grpc::ClientContext* context, const ::google::iam::admin::v1::EnableServiceAccountRequest* request, ::google::protobuf::Empty* response, ::grpc::ClientUnaryReactor* reactor) override;
      void DisableServiceAccount(::grpc::ClientContext* context, const ::google::iam::admin::v1::DisableServiceAccountRequest* request, ::google::protobuf::Empty* response, std::function<void(::grpc::Status)>) override;
      void DisableServiceAccount(::grpc::ClientContext* context, const ::google::iam::admin::v1::DisableServiceAccountRequest* request, ::google::protobuf::Empty* response, ::grpc::ClientUnaryReactor* reactor) override;
      void ListServiceAccountKeys(::grpc::ClientContext* context, const ::google::iam::admin::v1::ListServiceAccountKeysRequest* request, ::google::iam::admin::v1::ListServiceAccountKeysResponse* response, std::function<void(::grpc::Status)>) override;
      void ListServiceAccountKeys(::grpc::ClientContext* context, const ::google::iam::admin::v1::ListServiceAccountKeysRequest* request, ::google::iam::admin::v1::ListServiceAccountKeysResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
      void GetServiceAccountKey(::grpc::ClientContext* context, const ::google::iam::admin::v1::GetServiceAccountKeyRequest* request, ::google::iam::admin::v1::ServiceAccountKey* response, std::function<void(::grpc::Status)>) override;
      void GetServiceAccountKey(::grpc::ClientContext* context, const ::google::iam::admin::v1::GetServiceAccountKeyRequest* request, ::google::iam::admin::v1::ServiceAccountKey* response, ::grpc::ClientUnaryReactor* reactor) override;
      void CreateServiceAccountKey(::grpc::ClientContext* context, const ::google::iam::admin::v1::CreateServiceAccountKeyRequest* request, ::google::iam::admin::v1::ServiceAccountKey* response, std::function<void(::grpc::Status)>) override;
      void CreateServiceAccountKey(::grpc::ClientContext* context, const ::google::iam::admin::v1::CreateServiceAccountKeyRequest* request, ::google::iam::admin::v1::ServiceAccountKey* response, ::grpc::ClientUnaryReactor* reactor) override;
      void UploadServiceAccountKey(::grpc::ClientContext* context, const ::google::iam::admin::v1::UploadServiceAccountKeyRequest* request, ::google::iam::admin::v1::ServiceAccountKey* response, std::function<void(::grpc::Status)>) override;
      void UploadServiceAccountKey(::grpc::ClientContext* context, const ::google::iam::admin::v1::UploadServiceAccountKeyRequest* request, ::google::iam::admin::v1::ServiceAccountKey* response, ::grpc::ClientUnaryReactor* reactor) override;
      void DeleteServiceAccountKey(::grpc::ClientContext* context, const ::google::iam::admin::v1::DeleteServiceAccountKeyRequest* request, ::google::protobuf::Empty* response, std::function<void(::grpc::Status)>) override;
      void DeleteServiceAccountKey(::grpc::ClientContext* context, const ::google::iam::admin::v1::DeleteServiceAccountKeyRequest* request, ::google::protobuf::Empty* response, ::grpc::ClientUnaryReactor* reactor) override;
      void SignBlob(::grpc::ClientContext* context, const ::google::iam::admin::v1::SignBlobRequest* request, ::google::iam::admin::v1::SignBlobResponse* response, std::function<void(::grpc::Status)>) override;
      void SignBlob(::grpc::ClientContext* context, const ::google::iam::admin::v1::SignBlobRequest* request, ::google::iam::admin::v1::SignBlobResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
      void SignJwt(::grpc::ClientContext* context, const ::google::iam::admin::v1::SignJwtRequest* request, ::google::iam::admin::v1::SignJwtResponse* response, std::function<void(::grpc::Status)>) override;
      void SignJwt(::grpc::ClientContext* context, const ::google::iam::admin::v1::SignJwtRequest* request, ::google::iam::admin::v1::SignJwtResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
      void GetIamPolicy(::grpc::ClientContext* context, const ::google::iam::v1::GetIamPolicyRequest* request, ::google::iam::v1::Policy* response, std::function<void(::grpc::Status)>) override;
      void GetIamPolicy(::grpc::ClientContext* context, const ::google::iam::v1::GetIamPolicyRequest* request, ::google::iam::v1::Policy* response, ::grpc::ClientUnaryReactor* reactor) override;
      void SetIamPolicy(::grpc::ClientContext* context, const ::google::iam::v1::SetIamPolicyRequest* request, ::google::iam::v1::Policy* response, std::function<void(::grpc::Status)>) override;
      void SetIamPolicy(::grpc::ClientContext* context, const ::google::iam::v1::SetIamPolicyRequest* request, ::google::iam::v1::Policy* response, ::grpc::ClientUnaryReactor* reactor) override;
      void TestIamPermissions(::grpc::ClientContext* context, const ::google::iam::v1::TestIamPermissionsRequest* request, ::google::iam::v1::TestIamPermissionsResponse* response, std::function<void(::grpc::Status)>) override;
      void TestIamPermissions(::grpc::ClientContext* context, const ::google::iam::v1::TestIamPermissionsRequest* request, ::google::iam::v1::TestIamPermissionsResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
      void QueryGrantableRoles(::grpc::ClientContext* context, const ::google::iam::admin::v1::QueryGrantableRolesRequest* request, ::google::iam::admin::v1::QueryGrantableRolesResponse* response, std::function<void(::grpc::Status)>) override;
      void QueryGrantableRoles(::grpc::ClientContext* context, const ::google::iam::admin::v1::QueryGrantableRolesRequest* request, ::google::iam::admin::v1::QueryGrantableRolesResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
      void ListRoles(::grpc::ClientContext* context, const ::google::iam::admin::v1::ListRolesRequest* request, ::google::iam::admin::v1::ListRolesResponse* response, std::function<void(::grpc::Status)>) override;
      void ListRoles(::grpc::ClientContext* context, const ::google::iam::admin::v1::ListRolesRequest* request, ::google::iam::admin::v1::ListRolesResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
      void GetRole(::grpc::ClientContext* context, const ::google::iam::admin::v1::GetRoleRequest* request, ::google::iam::admin::v1::Role* response, std::function<void(::grpc::Status)>) override;
      void GetRole(::grpc::ClientContext* context, const ::google::iam::admin::v1::GetRoleRequest* request, ::google::iam::admin::v1::Role* response, ::grpc::ClientUnaryReactor* reactor) override;
      void CreateRole(::grpc::ClientContext* context, const ::google::iam::admin::v1::CreateRoleRequest* request, ::google::iam::admin::v1::Role* response, std::function<void(::grpc::Status)>) override;
      void CreateRole(::grpc::ClientContext* context, const ::google::iam::admin::v1::CreateRoleRequest* request, ::google::iam::admin::v1::Role* response, ::grpc::ClientUnaryReactor* reactor) override;
      void UpdateRole(::grpc::ClientContext* context, const ::google::iam::admin::v1::UpdateRoleRequest* request, ::google::iam::admin::v1::Role* response, std::function<void(::grpc::Status)>) override;
      void UpdateRole(::grpc::ClientContext* context, const ::google::iam::admin::v1::UpdateRoleRequest* request, ::google::iam::admin::v1::Role* response, ::grpc::ClientUnaryReactor* reactor) override;
      void DeleteRole(::grpc::ClientContext* context, const ::google::iam::admin::v1::DeleteRoleRequest* request, ::google::iam::admin::v1::Role* response, std::function<void(::grpc::Status)>) override;
      void DeleteRole(::grpc::ClientContext* context, const ::google::iam::admin::v1::DeleteRoleRequest* request, ::google::iam::admin::v1::Role* response, ::grpc::ClientUnaryReactor* reactor) override;
      void UndeleteRole(::grpc::ClientContext* context, const ::google::iam::admin::v1::UndeleteRoleRequest* request, ::google::iam::admin::v1::Role* response, std::function<void(::grpc::Status)>) override;
      void UndeleteRole(::grpc::ClientContext* context, const ::google::iam::admin::v1::UndeleteRoleRequest* request, ::google::iam::admin::v1::Role* response, ::grpc::ClientUnaryReactor* reactor) override;
      void QueryTestablePermissions(::grpc::ClientContext* context, const ::google::iam::admin::v1::QueryTestablePermissionsRequest* request, ::google::iam::admin::v1::QueryTestablePermissionsResponse* response, std::function<void(::grpc::Status)>) override;
      void QueryTestablePermissions(::grpc::ClientContext* context, const ::google::iam::admin::v1::QueryTestablePermissionsRequest* request, ::google::iam::admin::v1::QueryTestablePermissionsResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
      void QueryAuditableServices(::grpc::ClientContext* context, const ::google::iam::admin::v1::QueryAuditableServicesRequest* request, ::google::iam::admin::v1::QueryAuditableServicesResponse* response, std::function<void(::grpc::Status)>) override;
      void QueryAuditableServices(::grpc::ClientContext* context, const ::google::iam::admin::v1::QueryAuditableServicesRequest* request, ::google::iam::admin::v1::QueryAuditableServicesResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
      void LintPolicy(::grpc::ClientContext* context, const ::google::iam::admin::v1::LintPolicyRequest* request, ::google::iam::admin::v1::LintPolicyResponse* response, std::function<void(::grpc::Status)>) override;
      void LintPolicy(::grpc::ClientContext* context, const ::google::iam::admin::v1::LintPolicyRequest* request, ::google::iam::admin::v1::LintPolicyResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
     private:
      friend class Stub;
      explicit async(Stub* stub): stub_(stub) { }
      Stub* stub() { return stub_; }
      Stub* stub_;
    };
    class async* async() override { return &async_stub_; }

   private:
    std::shared_ptr< ::grpc::ChannelInterface> channel_;
    class async async_stub_{this};
    ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::ListServiceAccountsResponse>* AsyncListServiceAccountsRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::ListServiceAccountsRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::ListServiceAccountsResponse>* PrepareAsyncListServiceAccountsRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::ListServiceAccountsRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::ServiceAccount>* AsyncGetServiceAccountRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::GetServiceAccountRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::ServiceAccount>* PrepareAsyncGetServiceAccountRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::GetServiceAccountRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::ServiceAccount>* AsyncCreateServiceAccountRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::CreateServiceAccountRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::ServiceAccount>* PrepareAsyncCreateServiceAccountRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::CreateServiceAccountRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::ServiceAccount>* AsyncUpdateServiceAccountRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::ServiceAccount& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::ServiceAccount>* PrepareAsyncUpdateServiceAccountRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::ServiceAccount& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::ServiceAccount>* AsyncPatchServiceAccountRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::PatchServiceAccountRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::ServiceAccount>* PrepareAsyncPatchServiceAccountRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::PatchServiceAccountRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>* AsyncDeleteServiceAccountRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::DeleteServiceAccountRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>* PrepareAsyncDeleteServiceAccountRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::DeleteServiceAccountRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::UndeleteServiceAccountResponse>* AsyncUndeleteServiceAccountRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::UndeleteServiceAccountRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::UndeleteServiceAccountResponse>* PrepareAsyncUndeleteServiceAccountRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::UndeleteServiceAccountRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>* AsyncEnableServiceAccountRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::EnableServiceAccountRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>* PrepareAsyncEnableServiceAccountRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::EnableServiceAccountRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>* AsyncDisableServiceAccountRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::DisableServiceAccountRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>* PrepareAsyncDisableServiceAccountRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::DisableServiceAccountRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::ListServiceAccountKeysResponse>* AsyncListServiceAccountKeysRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::ListServiceAccountKeysRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::ListServiceAccountKeysResponse>* PrepareAsyncListServiceAccountKeysRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::ListServiceAccountKeysRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::ServiceAccountKey>* AsyncGetServiceAccountKeyRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::GetServiceAccountKeyRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::ServiceAccountKey>* PrepareAsyncGetServiceAccountKeyRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::GetServiceAccountKeyRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::ServiceAccountKey>* AsyncCreateServiceAccountKeyRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::CreateServiceAccountKeyRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::ServiceAccountKey>* PrepareAsyncCreateServiceAccountKeyRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::CreateServiceAccountKeyRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::ServiceAccountKey>* AsyncUploadServiceAccountKeyRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::UploadServiceAccountKeyRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::ServiceAccountKey>* PrepareAsyncUploadServiceAccountKeyRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::UploadServiceAccountKeyRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>* AsyncDeleteServiceAccountKeyRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::DeleteServiceAccountKeyRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>* PrepareAsyncDeleteServiceAccountKeyRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::DeleteServiceAccountKeyRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::SignBlobResponse>* AsyncSignBlobRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::SignBlobRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::SignBlobResponse>* PrepareAsyncSignBlobRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::SignBlobRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::SignJwtResponse>* AsyncSignJwtRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::SignJwtRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::SignJwtResponse>* PrepareAsyncSignJwtRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::SignJwtRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::iam::v1::Policy>* AsyncGetIamPolicyRaw(::grpc::ClientContext* context, const ::google::iam::v1::GetIamPolicyRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::iam::v1::Policy>* PrepareAsyncGetIamPolicyRaw(::grpc::ClientContext* context, const ::google::iam::v1::GetIamPolicyRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::iam::v1::Policy>* AsyncSetIamPolicyRaw(::grpc::ClientContext* context, const ::google::iam::v1::SetIamPolicyRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::iam::v1::Policy>* PrepareAsyncSetIamPolicyRaw(::grpc::ClientContext* context, const ::google::iam::v1::SetIamPolicyRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::iam::v1::TestIamPermissionsResponse>* AsyncTestIamPermissionsRaw(::grpc::ClientContext* context, const ::google::iam::v1::TestIamPermissionsRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::iam::v1::TestIamPermissionsResponse>* PrepareAsyncTestIamPermissionsRaw(::grpc::ClientContext* context, const ::google::iam::v1::TestIamPermissionsRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::QueryGrantableRolesResponse>* AsyncQueryGrantableRolesRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::QueryGrantableRolesRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::QueryGrantableRolesResponse>* PrepareAsyncQueryGrantableRolesRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::QueryGrantableRolesRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::ListRolesResponse>* AsyncListRolesRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::ListRolesRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::ListRolesResponse>* PrepareAsyncListRolesRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::ListRolesRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::Role>* AsyncGetRoleRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::GetRoleRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::Role>* PrepareAsyncGetRoleRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::GetRoleRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::Role>* AsyncCreateRoleRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::CreateRoleRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::Role>* PrepareAsyncCreateRoleRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::CreateRoleRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::Role>* AsyncUpdateRoleRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::UpdateRoleRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::Role>* PrepareAsyncUpdateRoleRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::UpdateRoleRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::Role>* AsyncDeleteRoleRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::DeleteRoleRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::Role>* PrepareAsyncDeleteRoleRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::DeleteRoleRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::Role>* AsyncUndeleteRoleRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::UndeleteRoleRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::Role>* PrepareAsyncUndeleteRoleRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::UndeleteRoleRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::QueryTestablePermissionsResponse>* AsyncQueryTestablePermissionsRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::QueryTestablePermissionsRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::QueryTestablePermissionsResponse>* PrepareAsyncQueryTestablePermissionsRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::QueryTestablePermissionsRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::QueryAuditableServicesResponse>* AsyncQueryAuditableServicesRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::QueryAuditableServicesRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::QueryAuditableServicesResponse>* PrepareAsyncQueryAuditableServicesRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::QueryAuditableServicesRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::LintPolicyResponse>* AsyncLintPolicyRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::LintPolicyRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::iam::admin::v1::LintPolicyResponse>* PrepareAsyncLintPolicyRaw(::grpc::ClientContext* context, const ::google::iam::admin::v1::LintPolicyRequest& request, ::grpc::CompletionQueue* cq) override;
    const ::grpc::internal::RpcMethod rpcmethod_ListServiceAccounts_;
    const ::grpc::internal::RpcMethod rpcmethod_GetServiceAccount_;
    const ::grpc::internal::RpcMethod rpcmethod_CreateServiceAccount_;
    const ::grpc::internal::RpcMethod rpcmethod_UpdateServiceAccount_;
    const ::grpc::internal::RpcMethod rpcmethod_PatchServiceAccount_;
    const ::grpc::internal::RpcMethod rpcmethod_DeleteServiceAccount_;
    const ::grpc::internal::RpcMethod rpcmethod_UndeleteServiceAccount_;
    const ::grpc::internal::RpcMethod rpcmethod_EnableServiceAccount_;
    const ::grpc::internal::RpcMethod rpcmethod_DisableServiceAccount_;
    const ::grpc::internal::RpcMethod rpcmethod_ListServiceAccountKeys_;
    const ::grpc::internal::RpcMethod rpcmethod_GetServiceAccountKey_;
    const ::grpc::internal::RpcMethod rpcmethod_CreateServiceAccountKey_;
    const ::grpc::internal::RpcMethod rpcmethod_UploadServiceAccountKey_;
    const ::grpc::internal::RpcMethod rpcmethod_DeleteServiceAccountKey_;
    const ::grpc::internal::RpcMethod rpcmethod_SignBlob_;
    const ::grpc::internal::RpcMethod rpcmethod_SignJwt_;
    const ::grpc::internal::RpcMethod rpcmethod_GetIamPolicy_;
    const ::grpc::internal::RpcMethod rpcmethod_SetIamPolicy_;
    const ::grpc::internal::RpcMethod rpcmethod_TestIamPermissions_;
    const ::grpc::internal::RpcMethod rpcmethod_QueryGrantableRoles_;
    const ::grpc::internal::RpcMethod rpcmethod_ListRoles_;
    const ::grpc::internal::RpcMethod rpcmethod_GetRole_;
    const ::grpc::internal::RpcMethod rpcmethod_CreateRole_;
    const ::grpc::internal::RpcMethod rpcmethod_UpdateRole_;
    const ::grpc::internal::RpcMethod rpcmethod_DeleteRole_;
    const ::grpc::internal::RpcMethod rpcmethod_UndeleteRole_;
    const ::grpc::internal::RpcMethod rpcmethod_QueryTestablePermissions_;
    const ::grpc::internal::RpcMethod rpcmethod_QueryAuditableServices_;
    const ::grpc::internal::RpcMethod rpcmethod_LintPolicy_;
  };
  static std::unique_ptr<Stub> NewStub(const std::shared_ptr< ::grpc::ChannelInterface>& channel, const ::grpc::StubOptions& options = ::grpc::StubOptions());

  class Service : public ::grpc::Service {
   public:
    Service();
    virtual ~Service();
    // Lists every [ServiceAccount][google.iam.admin.v1.ServiceAccount] that belongs to a specific project.
    virtual ::grpc::Status ListServiceAccounts(::grpc::ServerContext* context, const ::google::iam::admin::v1::ListServiceAccountsRequest* request, ::google::iam::admin::v1::ListServiceAccountsResponse* response);
    // Gets a [ServiceAccount][google.iam.admin.v1.ServiceAccount].
    virtual ::grpc::Status GetServiceAccount(::grpc::ServerContext* context, const ::google::iam::admin::v1::GetServiceAccountRequest* request, ::google::iam::admin::v1::ServiceAccount* response);
    // Creates a [ServiceAccount][google.iam.admin.v1.ServiceAccount].
    virtual ::grpc::Status CreateServiceAccount(::grpc::ServerContext* context, const ::google::iam::admin::v1::CreateServiceAccountRequest* request, ::google::iam::admin::v1::ServiceAccount* response);
    // **Note:** We are in the process of deprecating this method. Use
    // [PatchServiceAccount][google.iam.admin.v1.IAM.PatchServiceAccount] instead.
    //
    // Updates a [ServiceAccount][google.iam.admin.v1.ServiceAccount].
    //
    // You can update only the `display_name` and `description` fields.
    virtual ::grpc::Status UpdateServiceAccount(::grpc::ServerContext* context, const ::google::iam::admin::v1::ServiceAccount* request, ::google::iam::admin::v1::ServiceAccount* response);
    // Patches a [ServiceAccount][google.iam.admin.v1.ServiceAccount].
    virtual ::grpc::Status PatchServiceAccount(::grpc::ServerContext* context, const ::google::iam::admin::v1::PatchServiceAccountRequest* request, ::google::iam::admin::v1::ServiceAccount* response);
    // Deletes a [ServiceAccount][google.iam.admin.v1.ServiceAccount].
    //
    // **Warning:** After you delete a service account, you might not be able to
    // undelete it. If you know that you need to re-enable the service account in
    // the future, use [DisableServiceAccount][google.iam.admin.v1.IAM.DisableServiceAccount] instead.
    //
    // If you delete a service account, IAM permanently removes the service
    // account 30 days later. Google Cloud cannot recover the service account
    // after it is permanently removed, even if you file a support request.
    //
    // To help avoid unplanned outages, we recommend that you disable the service
    // account before you delete it. Use [DisableServiceAccount][google.iam.admin.v1.IAM.DisableServiceAccount] to disable the
    // service account, then wait at least 24 hours and watch for unintended
    // consequences. If there are no unintended consequences, you can delete the
    // service account.
    virtual ::grpc::Status DeleteServiceAccount(::grpc::ServerContext* context, const ::google::iam::admin::v1::DeleteServiceAccountRequest* request, ::google::protobuf::Empty* response);
    // Restores a deleted [ServiceAccount][google.iam.admin.v1.ServiceAccount].
    //
    // **Important:** It is not always possible to restore a deleted service
    // account. Use this method only as a last resort.
    //
    // After you delete a service account, IAM permanently removes the service
    // account 30 days later. There is no way to restore a deleted service account
    // that has been permanently removed.
    virtual ::grpc::Status UndeleteServiceAccount(::grpc::ServerContext* context, const ::google::iam::admin::v1::UndeleteServiceAccountRequest* request, ::google::iam::admin::v1::UndeleteServiceAccountResponse* response);
    // Enables a [ServiceAccount][google.iam.admin.v1.ServiceAccount] that was disabled by
    // [DisableServiceAccount][google.iam.admin.v1.IAM.DisableServiceAccount].
    //
    // If the service account is already enabled, then this method has no effect.
    //
    // If the service account was disabled by other means—for example, if Google
    // disabled the service account because it was compromised—you cannot use this
    // method to enable the service account.
    virtual ::grpc::Status EnableServiceAccount(::grpc::ServerContext* context, const ::google::iam::admin::v1::EnableServiceAccountRequest* request, ::google::protobuf::Empty* response);
    // Disables a [ServiceAccount][google.iam.admin.v1.ServiceAccount] immediately.
    //
    // If an application uses the service account to authenticate, that
    // application can no longer call Google APIs or access Google Cloud
    // resources. Existing access tokens for the service account are rejected, and
    // requests for new access tokens will fail.
    //
    // To re-enable the service account, use [EnableServiceAccount][google.iam.admin.v1.IAM.EnableServiceAccount]. After you
    // re-enable the service account, its existing access tokens will be accepted,
    // and you can request new access tokens.
    //
    // To help avoid unplanned outages, we recommend that you disable the service
    // account before you delete it. Use this method to disable the service
    // account, then wait at least 24 hours and watch for unintended consequences.
    // If there are no unintended consequences, you can delete the service account
    // with [DeleteServiceAccount][google.iam.admin.v1.IAM.DeleteServiceAccount].
    virtual ::grpc::Status DisableServiceAccount(::grpc::ServerContext* context, const ::google::iam::admin::v1::DisableServiceAccountRequest* request, ::google::protobuf::Empty* response);
    // Lists every [ServiceAccountKey][google.iam.admin.v1.ServiceAccountKey] for a service account.
    virtual ::grpc::Status ListServiceAccountKeys(::grpc::ServerContext* context, const ::google::iam::admin::v1::ListServiceAccountKeysRequest* request, ::google::iam::admin::v1::ListServiceAccountKeysResponse* response);
    // Gets a [ServiceAccountKey][google.iam.admin.v1.ServiceAccountKey].
    virtual ::grpc::Status GetServiceAccountKey(::grpc::ServerContext* context, const ::google::iam::admin::v1::GetServiceAccountKeyRequest* request, ::google::iam::admin::v1::ServiceAccountKey* response);
    // Creates a [ServiceAccountKey][google.iam.admin.v1.ServiceAccountKey].
    virtual ::grpc::Status CreateServiceAccountKey(::grpc::ServerContext* context, const ::google::iam::admin::v1::CreateServiceAccountKeyRequest* request, ::google::iam::admin::v1::ServiceAccountKey* response);
    // Creates a [ServiceAccountKey][google.iam.admin.v1.ServiceAccountKey], using a public key that you provide.
    virtual ::grpc::Status UploadServiceAccountKey(::grpc::ServerContext* context, const ::google::iam::admin::v1::UploadServiceAccountKeyRequest* request, ::google::iam::admin::v1::ServiceAccountKey* response);
    // Deletes a [ServiceAccountKey][google.iam.admin.v1.ServiceAccountKey]. Deleting a service account key does not
    // revoke short-lived credentials that have been issued based on the service
    // account key.
    virtual ::grpc::Status DeleteServiceAccountKey(::grpc::ServerContext* context, const ::google::iam::admin::v1::DeleteServiceAccountKeyRequest* request, ::google::protobuf::Empty* response);
    // **Note:** This method is deprecated. Use the
    // [`signBlob`](https://cloud.google.com/iam/help/rest-credentials/v1/projects.serviceAccounts/signBlob)
    // method in the IAM Service Account Credentials API instead. If you currently
    // use this method, see the [migration
    // guide](https://cloud.google.com/iam/help/credentials/migrate-api) for
    // instructions.
    //
    // Signs a blob using the system-managed private key for a [ServiceAccount][google.iam.admin.v1.ServiceAccount].
    virtual ::grpc::Status SignBlob(::grpc::ServerContext* context, const ::google::iam::admin::v1::SignBlobRequest* request, ::google::iam::admin::v1::SignBlobResponse* response);
    // **Note:** This method is deprecated. Use the
    // [`signJwt`](https://cloud.google.com/iam/help/rest-credentials/v1/projects.serviceAccounts/signJwt)
    // method in the IAM Service Account Credentials API instead. If you currently
    // use this method, see the [migration
    // guide](https://cloud.google.com/iam/help/credentials/migrate-api) for
    // instructions.
    //
    // Signs a JSON Web Token (JWT) using the system-managed private key for a
    // [ServiceAccount][google.iam.admin.v1.ServiceAccount].
    virtual ::grpc::Status SignJwt(::grpc::ServerContext* context, const ::google::iam::admin::v1::SignJwtRequest* request, ::google::iam::admin::v1::SignJwtResponse* response);
    // Gets the IAM policy that is attached to a [ServiceAccount][google.iam.admin.v1.ServiceAccount]. This IAM
    // policy specifies which members have access to the service account.
    //
    // This method does not tell you whether the service account has been granted
    // any roles on other resources. To check whether a service account has role
    // grants on a resource, use the `getIamPolicy` method for that resource. For
    // example, to view the role grants for a project, call the Resource Manager
    // API's
    // [`projects.getIamPolicy`](https://cloud.google.com/resource-manager/reference/rest/v1/projects/getIamPolicy)
    // method.
    virtual ::grpc::Status GetIamPolicy(::grpc::ServerContext* context, const ::google::iam::v1::GetIamPolicyRequest* request, ::google::iam::v1::Policy* response);
    // Sets the IAM policy that is attached to a [ServiceAccount][google.iam.admin.v1.ServiceAccount].
    //
    // Use this method to grant or revoke access to the service account. For
    // example, you could grant a member the ability to impersonate the service
    // account.
    //
    // This method does not enable the service account to access other resources.
    // To grant roles to a service account on a resource, follow these steps:
    //
    // 1. Call the resource's `getIamPolicy` method to get its current IAM policy.
    // 2. Edit the policy so that it binds the service account to an IAM role for
    // the resource.
    // 3. Call the resource's `setIamPolicy` method to update its IAM policy.
    //
    // For detailed instructions, see
    // [Granting roles to a service account for specific
    // resources](https://cloud.google.com/iam/help/service-accounts/granting-access-to-service-accounts).
    virtual ::grpc::Status SetIamPolicy(::grpc::ServerContext* context, const ::google::iam::v1::SetIamPolicyRequest* request, ::google::iam::v1::Policy* response);
    // Tests whether the caller has the specified permissions on a
    // [ServiceAccount][google.iam.admin.v1.ServiceAccount].
    virtual ::grpc::Status TestIamPermissions(::grpc::ServerContext* context, const ::google::iam::v1::TestIamPermissionsRequest* request, ::google::iam::v1::TestIamPermissionsResponse* response);
    // Lists roles that can be granted on a Google Cloud resource. A role is
    // grantable if the IAM policy for the resource can contain bindings to the
    // role.
    virtual ::grpc::Status QueryGrantableRoles(::grpc::ServerContext* context, const ::google::iam::admin::v1::QueryGrantableRolesRequest* request, ::google::iam::admin::v1::QueryGrantableRolesResponse* response);
    // Lists every predefined [Role][google.iam.admin.v1.Role] that IAM supports, or every custom role
    // that is defined for an organization or project.
    virtual ::grpc::Status ListRoles(::grpc::ServerContext* context, const ::google::iam::admin::v1::ListRolesRequest* request, ::google::iam::admin::v1::ListRolesResponse* response);
    // Gets the definition of a [Role][google.iam.admin.v1.Role].
    virtual ::grpc::Status GetRole(::grpc::ServerContext* context, const ::google::iam::admin::v1::GetRoleRequest* request, ::google::iam::admin::v1::Role* response);
    // Creates a new custom [Role][google.iam.admin.v1.Role].
    virtual ::grpc::Status CreateRole(::grpc::ServerContext* context, const ::google::iam::admin::v1::CreateRoleRequest* request, ::google::iam::admin::v1::Role* response);
    // Updates the definition of a custom [Role][google.iam.admin.v1.Role].
    virtual ::grpc::Status UpdateRole(::grpc::ServerContext* context, const ::google::iam::admin::v1::UpdateRoleRequest* request, ::google::iam::admin::v1::Role* response);
    // Deletes a custom [Role][google.iam.admin.v1.Role].
    //
    // When you delete a custom role, the following changes occur immediately:
    //
    // * You cannot bind a member to the custom role in an IAM
    // [Policy][google.iam.v1.Policy].
    // * Existing bindings to the custom role are not changed, but they have no
    // effect.
    // * By default, the response from [ListRoles][google.iam.admin.v1.IAM.ListRoles] does not include the custom
    // role.
    //
    // You have 7 days to undelete the custom role. After 7 days, the following
    // changes occur:
    //
    // * The custom role is permanently deleted and cannot be recovered.
    // * If an IAM policy contains a binding to the custom role, the binding is
    // permanently removed.
    virtual ::grpc::Status DeleteRole(::grpc::ServerContext* context, const ::google::iam::admin::v1::DeleteRoleRequest* request, ::google::iam::admin::v1::Role* response);
    // Undeletes a custom [Role][google.iam.admin.v1.Role].
    virtual ::grpc::Status UndeleteRole(::grpc::ServerContext* context, const ::google::iam::admin::v1::UndeleteRoleRequest* request, ::google::iam::admin::v1::Role* response);
    // Lists every permission that you can test on a resource. A permission is
    // testable if you can check whether a member has that permission on the
    // resource.
    virtual ::grpc::Status QueryTestablePermissions(::grpc::ServerContext* context, const ::google::iam::admin::v1::QueryTestablePermissionsRequest* request, ::google::iam::admin::v1::QueryTestablePermissionsResponse* response);
    // Returns a list of services that allow you to opt into audit logs that are
    // not generated by default.
    //
    // To learn more about audit logs, see the [Logging
    // documentation](https://cloud.google.com/logging/docs/audit).
    virtual ::grpc::Status QueryAuditableServices(::grpc::ServerContext* context, const ::google::iam::admin::v1::QueryAuditableServicesRequest* request, ::google::iam::admin::v1::QueryAuditableServicesResponse* response);
    // Lints, or validates, an IAM policy. Currently checks the
    // [google.iam.v1.Binding.condition][google.iam.v1.Binding.condition] field, which contains a condition
    // expression for a role binding.
    //
    // Successful calls to this method always return an HTTP `200 OK` status code,
    // even if the linter detects an issue in the IAM policy.
    virtual ::grpc::Status LintPolicy(::grpc::ServerContext* context, const ::google::iam::admin::v1::LintPolicyRequest* request, ::google::iam::admin::v1::LintPolicyResponse* response);
  };
  template <class BaseClass>
  class WithAsyncMethod_ListServiceAccounts : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_ListServiceAccounts() {
      ::grpc::Service::MarkMethodAsync(0);
    }
    ~WithAsyncMethod_ListServiceAccounts() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListServiceAccounts(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::ListServiceAccountsRequest* /*request*/, ::google::iam::admin::v1::ListServiceAccountsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestListServiceAccounts(::grpc::ServerContext* context, ::google::iam::admin::v1::ListServiceAccountsRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::iam::admin::v1::ListServiceAccountsResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(0, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_GetServiceAccount : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_GetServiceAccount() {
      ::grpc::Service::MarkMethodAsync(1);
    }
    ~WithAsyncMethod_GetServiceAccount() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetServiceAccount(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::GetServiceAccountRequest* /*request*/, ::google::iam::admin::v1::ServiceAccount* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGetServiceAccount(::grpc::ServerContext* context, ::google::iam::admin::v1::GetServiceAccountRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::iam::admin::v1::ServiceAccount>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(1, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_CreateServiceAccount : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_CreateServiceAccount() {
      ::grpc::Service::MarkMethodAsync(2);
    }
    ~WithAsyncMethod_CreateServiceAccount() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateServiceAccount(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::CreateServiceAccountRequest* /*request*/, ::google::iam::admin::v1::ServiceAccount* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestCreateServiceAccount(::grpc::ServerContext* context, ::google::iam::admin::v1::CreateServiceAccountRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::iam::admin::v1::ServiceAccount>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(2, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_UpdateServiceAccount : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_UpdateServiceAccount() {
      ::grpc::Service::MarkMethodAsync(3);
    }
    ~WithAsyncMethod_UpdateServiceAccount() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateServiceAccount(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::ServiceAccount* /*request*/, ::google::iam::admin::v1::ServiceAccount* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestUpdateServiceAccount(::grpc::ServerContext* context, ::google::iam::admin::v1::ServiceAccount* request, ::grpc::ServerAsyncResponseWriter< ::google::iam::admin::v1::ServiceAccount>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(3, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_PatchServiceAccount : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_PatchServiceAccount() {
      ::grpc::Service::MarkMethodAsync(4);
    }
    ~WithAsyncMethod_PatchServiceAccount() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status PatchServiceAccount(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::PatchServiceAccountRequest* /*request*/, ::google::iam::admin::v1::ServiceAccount* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestPatchServiceAccount(::grpc::ServerContext* context, ::google::iam::admin::v1::PatchServiceAccountRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::iam::admin::v1::ServiceAccount>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(4, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_DeleteServiceAccount : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_DeleteServiceAccount() {
      ::grpc::Service::MarkMethodAsync(5);
    }
    ~WithAsyncMethod_DeleteServiceAccount() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteServiceAccount(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::DeleteServiceAccountRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestDeleteServiceAccount(::grpc::ServerContext* context, ::google::iam::admin::v1::DeleteServiceAccountRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::protobuf::Empty>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(5, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_UndeleteServiceAccount : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_UndeleteServiceAccount() {
      ::grpc::Service::MarkMethodAsync(6);
    }
    ~WithAsyncMethod_UndeleteServiceAccount() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UndeleteServiceAccount(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::UndeleteServiceAccountRequest* /*request*/, ::google::iam::admin::v1::UndeleteServiceAccountResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestUndeleteServiceAccount(::grpc::ServerContext* context, ::google::iam::admin::v1::UndeleteServiceAccountRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::iam::admin::v1::UndeleteServiceAccountResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(6, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_EnableServiceAccount : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_EnableServiceAccount() {
      ::grpc::Service::MarkMethodAsync(7);
    }
    ~WithAsyncMethod_EnableServiceAccount() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status EnableServiceAccount(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::EnableServiceAccountRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestEnableServiceAccount(::grpc::ServerContext* context, ::google::iam::admin::v1::EnableServiceAccountRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::protobuf::Empty>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(7, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_DisableServiceAccount : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_DisableServiceAccount() {
      ::grpc::Service::MarkMethodAsync(8);
    }
    ~WithAsyncMethod_DisableServiceAccount() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DisableServiceAccount(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::DisableServiceAccountRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestDisableServiceAccount(::grpc::ServerContext* context, ::google::iam::admin::v1::DisableServiceAccountRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::protobuf::Empty>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(8, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_ListServiceAccountKeys : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_ListServiceAccountKeys() {
      ::grpc::Service::MarkMethodAsync(9);
    }
    ~WithAsyncMethod_ListServiceAccountKeys() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListServiceAccountKeys(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::ListServiceAccountKeysRequest* /*request*/, ::google::iam::admin::v1::ListServiceAccountKeysResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestListServiceAccountKeys(::grpc::ServerContext* context, ::google::iam::admin::v1::ListServiceAccountKeysRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::iam::admin::v1::ListServiceAccountKeysResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(9, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_GetServiceAccountKey : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_GetServiceAccountKey() {
      ::grpc::Service::MarkMethodAsync(10);
    }
    ~WithAsyncMethod_GetServiceAccountKey() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetServiceAccountKey(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::GetServiceAccountKeyRequest* /*request*/, ::google::iam::admin::v1::ServiceAccountKey* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGetServiceAccountKey(::grpc::ServerContext* context, ::google::iam::admin::v1::GetServiceAccountKeyRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::iam::admin::v1::ServiceAccountKey>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(10, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_CreateServiceAccountKey : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_CreateServiceAccountKey() {
      ::grpc::Service::MarkMethodAsync(11);
    }
    ~WithAsyncMethod_CreateServiceAccountKey() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateServiceAccountKey(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::CreateServiceAccountKeyRequest* /*request*/, ::google::iam::admin::v1::ServiceAccountKey* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestCreateServiceAccountKey(::grpc::ServerContext* context, ::google::iam::admin::v1::CreateServiceAccountKeyRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::iam::admin::v1::ServiceAccountKey>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(11, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_UploadServiceAccountKey : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_UploadServiceAccountKey() {
      ::grpc::Service::MarkMethodAsync(12);
    }
    ~WithAsyncMethod_UploadServiceAccountKey() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UploadServiceAccountKey(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::UploadServiceAccountKeyRequest* /*request*/, ::google::iam::admin::v1::ServiceAccountKey* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestUploadServiceAccountKey(::grpc::ServerContext* context, ::google::iam::admin::v1::UploadServiceAccountKeyRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::iam::admin::v1::ServiceAccountKey>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(12, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_DeleteServiceAccountKey : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_DeleteServiceAccountKey() {
      ::grpc::Service::MarkMethodAsync(13);
    }
    ~WithAsyncMethod_DeleteServiceAccountKey() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteServiceAccountKey(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::DeleteServiceAccountKeyRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestDeleteServiceAccountKey(::grpc::ServerContext* context, ::google::iam::admin::v1::DeleteServiceAccountKeyRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::protobuf::Empty>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(13, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_SignBlob : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_SignBlob() {
      ::grpc::Service::MarkMethodAsync(14);
    }
    ~WithAsyncMethod_SignBlob() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status SignBlob(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::SignBlobRequest* /*request*/, ::google::iam::admin::v1::SignBlobResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestSignBlob(::grpc::ServerContext* context, ::google::iam::admin::v1::SignBlobRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::iam::admin::v1::SignBlobResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(14, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_SignJwt : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_SignJwt() {
      ::grpc::Service::MarkMethodAsync(15);
    }
    ~WithAsyncMethod_SignJwt() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status SignJwt(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::SignJwtRequest* /*request*/, ::google::iam::admin::v1::SignJwtResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestSignJwt(::grpc::ServerContext* context, ::google::iam::admin::v1::SignJwtRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::iam::admin::v1::SignJwtResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(15, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_GetIamPolicy : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_GetIamPolicy() {
      ::grpc::Service::MarkMethodAsync(16);
    }
    ~WithAsyncMethod_GetIamPolicy() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetIamPolicy(::grpc::ServerContext* /*context*/, const ::google::iam::v1::GetIamPolicyRequest* /*request*/, ::google::iam::v1::Policy* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGetIamPolicy(::grpc::ServerContext* context, ::google::iam::v1::GetIamPolicyRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::iam::v1::Policy>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(16, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_SetIamPolicy : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_SetIamPolicy() {
      ::grpc::Service::MarkMethodAsync(17);
    }
    ~WithAsyncMethod_SetIamPolicy() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status SetIamPolicy(::grpc::ServerContext* /*context*/, const ::google::iam::v1::SetIamPolicyRequest* /*request*/, ::google::iam::v1::Policy* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestSetIamPolicy(::grpc::ServerContext* context, ::google::iam::v1::SetIamPolicyRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::iam::v1::Policy>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(17, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_TestIamPermissions : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_TestIamPermissions() {
      ::grpc::Service::MarkMethodAsync(18);
    }
    ~WithAsyncMethod_TestIamPermissions() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status TestIamPermissions(::grpc::ServerContext* /*context*/, const ::google::iam::v1::TestIamPermissionsRequest* /*request*/, ::google::iam::v1::TestIamPermissionsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestTestIamPermissions(::grpc::ServerContext* context, ::google::iam::v1::TestIamPermissionsRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::iam::v1::TestIamPermissionsResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(18, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_QueryGrantableRoles : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_QueryGrantableRoles() {
      ::grpc::Service::MarkMethodAsync(19);
    }
    ~WithAsyncMethod_QueryGrantableRoles() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status QueryGrantableRoles(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::QueryGrantableRolesRequest* /*request*/, ::google::iam::admin::v1::QueryGrantableRolesResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestQueryGrantableRoles(::grpc::ServerContext* context, ::google::iam::admin::v1::QueryGrantableRolesRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::iam::admin::v1::QueryGrantableRolesResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(19, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_ListRoles : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_ListRoles() {
      ::grpc::Service::MarkMethodAsync(20);
    }
    ~WithAsyncMethod_ListRoles() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListRoles(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::ListRolesRequest* /*request*/, ::google::iam::admin::v1::ListRolesResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestListRoles(::grpc::ServerContext* context, ::google::iam::admin::v1::ListRolesRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::iam::admin::v1::ListRolesResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(20, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_GetRole : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_GetRole() {
      ::grpc::Service::MarkMethodAsync(21);
    }
    ~WithAsyncMethod_GetRole() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetRole(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::GetRoleRequest* /*request*/, ::google::iam::admin::v1::Role* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGetRole(::grpc::ServerContext* context, ::google::iam::admin::v1::GetRoleRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::iam::admin::v1::Role>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(21, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_CreateRole : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_CreateRole() {
      ::grpc::Service::MarkMethodAsync(22);
    }
    ~WithAsyncMethod_CreateRole() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateRole(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::CreateRoleRequest* /*request*/, ::google::iam::admin::v1::Role* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestCreateRole(::grpc::ServerContext* context, ::google::iam::admin::v1::CreateRoleRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::iam::admin::v1::Role>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(22, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_UpdateRole : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_UpdateRole() {
      ::grpc::Service::MarkMethodAsync(23);
    }
    ~WithAsyncMethod_UpdateRole() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateRole(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::UpdateRoleRequest* /*request*/, ::google::iam::admin::v1::Role* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestUpdateRole(::grpc::ServerContext* context, ::google::iam::admin::v1::UpdateRoleRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::iam::admin::v1::Role>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(23, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_DeleteRole : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_DeleteRole() {
      ::grpc::Service::MarkMethodAsync(24);
    }
    ~WithAsyncMethod_DeleteRole() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteRole(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::DeleteRoleRequest* /*request*/, ::google::iam::admin::v1::Role* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestDeleteRole(::grpc::ServerContext* context, ::google::iam::admin::v1::DeleteRoleRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::iam::admin::v1::Role>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(24, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_UndeleteRole : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_UndeleteRole() {
      ::grpc::Service::MarkMethodAsync(25);
    }
    ~WithAsyncMethod_UndeleteRole() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UndeleteRole(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::UndeleteRoleRequest* /*request*/, ::google::iam::admin::v1::Role* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestUndeleteRole(::grpc::ServerContext* context, ::google::iam::admin::v1::UndeleteRoleRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::iam::admin::v1::Role>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(25, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_QueryTestablePermissions : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_QueryTestablePermissions() {
      ::grpc::Service::MarkMethodAsync(26);
    }
    ~WithAsyncMethod_QueryTestablePermissions() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status QueryTestablePermissions(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::QueryTestablePermissionsRequest* /*request*/, ::google::iam::admin::v1::QueryTestablePermissionsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestQueryTestablePermissions(::grpc::ServerContext* context, ::google::iam::admin::v1::QueryTestablePermissionsRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::iam::admin::v1::QueryTestablePermissionsResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(26, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_QueryAuditableServices : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_QueryAuditableServices() {
      ::grpc::Service::MarkMethodAsync(27);
    }
    ~WithAsyncMethod_QueryAuditableServices() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status QueryAuditableServices(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::QueryAuditableServicesRequest* /*request*/, ::google::iam::admin::v1::QueryAuditableServicesResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestQueryAuditableServices(::grpc::ServerContext* context, ::google::iam::admin::v1::QueryAuditableServicesRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::iam::admin::v1::QueryAuditableServicesResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(27, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_LintPolicy : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_LintPolicy() {
      ::grpc::Service::MarkMethodAsync(28);
    }
    ~WithAsyncMethod_LintPolicy() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status LintPolicy(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::LintPolicyRequest* /*request*/, ::google::iam::admin::v1::LintPolicyResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestLintPolicy(::grpc::ServerContext* context, ::google::iam::admin::v1::LintPolicyRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::iam::admin::v1::LintPolicyResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(28, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  typedef WithAsyncMethod_ListServiceAccounts<WithAsyncMethod_GetServiceAccount<WithAsyncMethod_CreateServiceAccount<WithAsyncMethod_UpdateServiceAccount<WithAsyncMethod_PatchServiceAccount<WithAsyncMethod_DeleteServiceAccount<WithAsyncMethod_UndeleteServiceAccount<WithAsyncMethod_EnableServiceAccount<WithAsyncMethod_DisableServiceAccount<WithAsyncMethod_ListServiceAccountKeys<WithAsyncMethod_GetServiceAccountKey<WithAsyncMethod_CreateServiceAccountKey<WithAsyncMethod_UploadServiceAccountKey<WithAsyncMethod_DeleteServiceAccountKey<WithAsyncMethod_SignBlob<WithAsyncMethod_SignJwt<WithAsyncMethod_GetIamPolicy<WithAsyncMethod_SetIamPolicy<WithAsyncMethod_TestIamPermissions<WithAsyncMethod_QueryGrantableRoles<WithAsyncMethod_ListRoles<WithAsyncMethod_GetRole<WithAsyncMethod_CreateRole<WithAsyncMethod_UpdateRole<WithAsyncMethod_DeleteRole<WithAsyncMethod_UndeleteRole<WithAsyncMethod_QueryTestablePermissions<WithAsyncMethod_QueryAuditableServices<WithAsyncMethod_LintPolicy<Service > > > > > > > > > > > > > > > > > > > > > > > > > > > > > AsyncService;
  template <class BaseClass>
  class WithCallbackMethod_ListServiceAccounts : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_ListServiceAccounts() {
      ::grpc::Service::MarkMethodCallback(0,
          new ::grpc::internal::CallbackUnaryHandler< ::google::iam::admin::v1::ListServiceAccountsRequest, ::google::iam::admin::v1::ListServiceAccountsResponse>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::iam::admin::v1::ListServiceAccountsRequest* request, ::google::iam::admin::v1::ListServiceAccountsResponse* response) { return this->ListServiceAccounts(context, request, response); }));}
    void SetMessageAllocatorFor_ListServiceAccounts(
        ::grpc::MessageAllocator< ::google::iam::admin::v1::ListServiceAccountsRequest, ::google::iam::admin::v1::ListServiceAccountsResponse>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(0);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::iam::admin::v1::ListServiceAccountsRequest, ::google::iam::admin::v1::ListServiceAccountsResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_ListServiceAccounts() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListServiceAccounts(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::ListServiceAccountsRequest* /*request*/, ::google::iam::admin::v1::ListServiceAccountsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* ListServiceAccounts(
      ::grpc::CallbackServerContext* /*context*/, const ::google::iam::admin::v1::ListServiceAccountsRequest* /*request*/, ::google::iam::admin::v1::ListServiceAccountsResponse* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_GetServiceAccount : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_GetServiceAccount() {
      ::grpc::Service::MarkMethodCallback(1,
          new ::grpc::internal::CallbackUnaryHandler< ::google::iam::admin::v1::GetServiceAccountRequest, ::google::iam::admin::v1::ServiceAccount>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::iam::admin::v1::GetServiceAccountRequest* request, ::google::iam::admin::v1::ServiceAccount* response) { return this->GetServiceAccount(context, request, response); }));}
    void SetMessageAllocatorFor_GetServiceAccount(
        ::grpc::MessageAllocator< ::google::iam::admin::v1::GetServiceAccountRequest, ::google::iam::admin::v1::ServiceAccount>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(1);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::iam::admin::v1::GetServiceAccountRequest, ::google::iam::admin::v1::ServiceAccount>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_GetServiceAccount() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetServiceAccount(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::GetServiceAccountRequest* /*request*/, ::google::iam::admin::v1::ServiceAccount* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* GetServiceAccount(
      ::grpc::CallbackServerContext* /*context*/, const ::google::iam::admin::v1::GetServiceAccountRequest* /*request*/, ::google::iam::admin::v1::ServiceAccount* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_CreateServiceAccount : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_CreateServiceAccount() {
      ::grpc::Service::MarkMethodCallback(2,
          new ::grpc::internal::CallbackUnaryHandler< ::google::iam::admin::v1::CreateServiceAccountRequest, ::google::iam::admin::v1::ServiceAccount>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::iam::admin::v1::CreateServiceAccountRequest* request, ::google::iam::admin::v1::ServiceAccount* response) { return this->CreateServiceAccount(context, request, response); }));}
    void SetMessageAllocatorFor_CreateServiceAccount(
        ::grpc::MessageAllocator< ::google::iam::admin::v1::CreateServiceAccountRequest, ::google::iam::admin::v1::ServiceAccount>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(2);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::iam::admin::v1::CreateServiceAccountRequest, ::google::iam::admin::v1::ServiceAccount>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_CreateServiceAccount() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateServiceAccount(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::CreateServiceAccountRequest* /*request*/, ::google::iam::admin::v1::ServiceAccount* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* CreateServiceAccount(
      ::grpc::CallbackServerContext* /*context*/, const ::google::iam::admin::v1::CreateServiceAccountRequest* /*request*/, ::google::iam::admin::v1::ServiceAccount* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_UpdateServiceAccount : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_UpdateServiceAccount() {
      ::grpc::Service::MarkMethodCallback(3,
          new ::grpc::internal::CallbackUnaryHandler< ::google::iam::admin::v1::ServiceAccount, ::google::iam::admin::v1::ServiceAccount>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::iam::admin::v1::ServiceAccount* request, ::google::iam::admin::v1::ServiceAccount* response) { return this->UpdateServiceAccount(context, request, response); }));}
    void SetMessageAllocatorFor_UpdateServiceAccount(
        ::grpc::MessageAllocator< ::google::iam::admin::v1::ServiceAccount, ::google::iam::admin::v1::ServiceAccount>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(3);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::iam::admin::v1::ServiceAccount, ::google::iam::admin::v1::ServiceAccount>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_UpdateServiceAccount() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateServiceAccount(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::ServiceAccount* /*request*/, ::google::iam::admin::v1::ServiceAccount* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* UpdateServiceAccount(
      ::grpc::CallbackServerContext* /*context*/, const ::google::iam::admin::v1::ServiceAccount* /*request*/, ::google::iam::admin::v1::ServiceAccount* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_PatchServiceAccount : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_PatchServiceAccount() {
      ::grpc::Service::MarkMethodCallback(4,
          new ::grpc::internal::CallbackUnaryHandler< ::google::iam::admin::v1::PatchServiceAccountRequest, ::google::iam::admin::v1::ServiceAccount>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::iam::admin::v1::PatchServiceAccountRequest* request, ::google::iam::admin::v1::ServiceAccount* response) { return this->PatchServiceAccount(context, request, response); }));}
    void SetMessageAllocatorFor_PatchServiceAccount(
        ::grpc::MessageAllocator< ::google::iam::admin::v1::PatchServiceAccountRequest, ::google::iam::admin::v1::ServiceAccount>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(4);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::iam::admin::v1::PatchServiceAccountRequest, ::google::iam::admin::v1::ServiceAccount>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_PatchServiceAccount() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status PatchServiceAccount(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::PatchServiceAccountRequest* /*request*/, ::google::iam::admin::v1::ServiceAccount* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* PatchServiceAccount(
      ::grpc::CallbackServerContext* /*context*/, const ::google::iam::admin::v1::PatchServiceAccountRequest* /*request*/, ::google::iam::admin::v1::ServiceAccount* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_DeleteServiceAccount : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_DeleteServiceAccount() {
      ::grpc::Service::MarkMethodCallback(5,
          new ::grpc::internal::CallbackUnaryHandler< ::google::iam::admin::v1::DeleteServiceAccountRequest, ::google::protobuf::Empty>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::iam::admin::v1::DeleteServiceAccountRequest* request, ::google::protobuf::Empty* response) { return this->DeleteServiceAccount(context, request, response); }));}
    void SetMessageAllocatorFor_DeleteServiceAccount(
        ::grpc::MessageAllocator< ::google::iam::admin::v1::DeleteServiceAccountRequest, ::google::protobuf::Empty>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(5);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::iam::admin::v1::DeleteServiceAccountRequest, ::google::protobuf::Empty>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_DeleteServiceAccount() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteServiceAccount(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::DeleteServiceAccountRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* DeleteServiceAccount(
      ::grpc::CallbackServerContext* /*context*/, const ::google::iam::admin::v1::DeleteServiceAccountRequest* /*request*/, ::google::protobuf::Empty* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_UndeleteServiceAccount : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_UndeleteServiceAccount() {
      ::grpc::Service::MarkMethodCallback(6,
          new ::grpc::internal::CallbackUnaryHandler< ::google::iam::admin::v1::UndeleteServiceAccountRequest, ::google::iam::admin::v1::UndeleteServiceAccountResponse>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::iam::admin::v1::UndeleteServiceAccountRequest* request, ::google::iam::admin::v1::UndeleteServiceAccountResponse* response) { return this->UndeleteServiceAccount(context, request, response); }));}
    void SetMessageAllocatorFor_UndeleteServiceAccount(
        ::grpc::MessageAllocator< ::google::iam::admin::v1::UndeleteServiceAccountRequest, ::google::iam::admin::v1::UndeleteServiceAccountResponse>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(6);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::iam::admin::v1::UndeleteServiceAccountRequest, ::google::iam::admin::v1::UndeleteServiceAccountResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_UndeleteServiceAccount() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UndeleteServiceAccount(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::UndeleteServiceAccountRequest* /*request*/, ::google::iam::admin::v1::UndeleteServiceAccountResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* UndeleteServiceAccount(
      ::grpc::CallbackServerContext* /*context*/, const ::google::iam::admin::v1::UndeleteServiceAccountRequest* /*request*/, ::google::iam::admin::v1::UndeleteServiceAccountResponse* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_EnableServiceAccount : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_EnableServiceAccount() {
      ::grpc::Service::MarkMethodCallback(7,
          new ::grpc::internal::CallbackUnaryHandler< ::google::iam::admin::v1::EnableServiceAccountRequest, ::google::protobuf::Empty>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::iam::admin::v1::EnableServiceAccountRequest* request, ::google::protobuf::Empty* response) { return this->EnableServiceAccount(context, request, response); }));}
    void SetMessageAllocatorFor_EnableServiceAccount(
        ::grpc::MessageAllocator< ::google::iam::admin::v1::EnableServiceAccountRequest, ::google::protobuf::Empty>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(7);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::iam::admin::v1::EnableServiceAccountRequest, ::google::protobuf::Empty>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_EnableServiceAccount() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status EnableServiceAccount(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::EnableServiceAccountRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* EnableServiceAccount(
      ::grpc::CallbackServerContext* /*context*/, const ::google::iam::admin::v1::EnableServiceAccountRequest* /*request*/, ::google::protobuf::Empty* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_DisableServiceAccount : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_DisableServiceAccount() {
      ::grpc::Service::MarkMethodCallback(8,
          new ::grpc::internal::CallbackUnaryHandler< ::google::iam::admin::v1::DisableServiceAccountRequest, ::google::protobuf::Empty>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::iam::admin::v1::DisableServiceAccountRequest* request, ::google::protobuf::Empty* response) { return this->DisableServiceAccount(context, request, response); }));}
    void SetMessageAllocatorFor_DisableServiceAccount(
        ::grpc::MessageAllocator< ::google::iam::admin::v1::DisableServiceAccountRequest, ::google::protobuf::Empty>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(8);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::iam::admin::v1::DisableServiceAccountRequest, ::google::protobuf::Empty>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_DisableServiceAccount() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DisableServiceAccount(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::DisableServiceAccountRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* DisableServiceAccount(
      ::grpc::CallbackServerContext* /*context*/, const ::google::iam::admin::v1::DisableServiceAccountRequest* /*request*/, ::google::protobuf::Empty* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_ListServiceAccountKeys : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_ListServiceAccountKeys() {
      ::grpc::Service::MarkMethodCallback(9,
          new ::grpc::internal::CallbackUnaryHandler< ::google::iam::admin::v1::ListServiceAccountKeysRequest, ::google::iam::admin::v1::ListServiceAccountKeysResponse>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::iam::admin::v1::ListServiceAccountKeysRequest* request, ::google::iam::admin::v1::ListServiceAccountKeysResponse* response) { return this->ListServiceAccountKeys(context, request, response); }));}
    void SetMessageAllocatorFor_ListServiceAccountKeys(
        ::grpc::MessageAllocator< ::google::iam::admin::v1::ListServiceAccountKeysRequest, ::google::iam::admin::v1::ListServiceAccountKeysResponse>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(9);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::iam::admin::v1::ListServiceAccountKeysRequest, ::google::iam::admin::v1::ListServiceAccountKeysResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_ListServiceAccountKeys() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListServiceAccountKeys(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::ListServiceAccountKeysRequest* /*request*/, ::google::iam::admin::v1::ListServiceAccountKeysResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* ListServiceAccountKeys(
      ::grpc::CallbackServerContext* /*context*/, const ::google::iam::admin::v1::ListServiceAccountKeysRequest* /*request*/, ::google::iam::admin::v1::ListServiceAccountKeysResponse* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_GetServiceAccountKey : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_GetServiceAccountKey() {
      ::grpc::Service::MarkMethodCallback(10,
          new ::grpc::internal::CallbackUnaryHandler< ::google::iam::admin::v1::GetServiceAccountKeyRequest, ::google::iam::admin::v1::ServiceAccountKey>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::iam::admin::v1::GetServiceAccountKeyRequest* request, ::google::iam::admin::v1::ServiceAccountKey* response) { return this->GetServiceAccountKey(context, request, response); }));}
    void SetMessageAllocatorFor_GetServiceAccountKey(
        ::grpc::MessageAllocator< ::google::iam::admin::v1::GetServiceAccountKeyRequest, ::google::iam::admin::v1::ServiceAccountKey>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(10);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::iam::admin::v1::GetServiceAccountKeyRequest, ::google::iam::admin::v1::ServiceAccountKey>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_GetServiceAccountKey() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetServiceAccountKey(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::GetServiceAccountKeyRequest* /*request*/, ::google::iam::admin::v1::ServiceAccountKey* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* GetServiceAccountKey(
      ::grpc::CallbackServerContext* /*context*/, const ::google::iam::admin::v1::GetServiceAccountKeyRequest* /*request*/, ::google::iam::admin::v1::ServiceAccountKey* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_CreateServiceAccountKey : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_CreateServiceAccountKey() {
      ::grpc::Service::MarkMethodCallback(11,
          new ::grpc::internal::CallbackUnaryHandler< ::google::iam::admin::v1::CreateServiceAccountKeyRequest, ::google::iam::admin::v1::ServiceAccountKey>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::iam::admin::v1::CreateServiceAccountKeyRequest* request, ::google::iam::admin::v1::ServiceAccountKey* response) { return this->CreateServiceAccountKey(context, request, response); }));}
    void SetMessageAllocatorFor_CreateServiceAccountKey(
        ::grpc::MessageAllocator< ::google::iam::admin::v1::CreateServiceAccountKeyRequest, ::google::iam::admin::v1::ServiceAccountKey>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(11);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::iam::admin::v1::CreateServiceAccountKeyRequest, ::google::iam::admin::v1::ServiceAccountKey>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_CreateServiceAccountKey() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateServiceAccountKey(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::CreateServiceAccountKeyRequest* /*request*/, ::google::iam::admin::v1::ServiceAccountKey* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* CreateServiceAccountKey(
      ::grpc::CallbackServerContext* /*context*/, const ::google::iam::admin::v1::CreateServiceAccountKeyRequest* /*request*/, ::google::iam::admin::v1::ServiceAccountKey* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_UploadServiceAccountKey : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_UploadServiceAccountKey() {
      ::grpc::Service::MarkMethodCallback(12,
          new ::grpc::internal::CallbackUnaryHandler< ::google::iam::admin::v1::UploadServiceAccountKeyRequest, ::google::iam::admin::v1::ServiceAccountKey>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::iam::admin::v1::UploadServiceAccountKeyRequest* request, ::google::iam::admin::v1::ServiceAccountKey* response) { return this->UploadServiceAccountKey(context, request, response); }));}
    void SetMessageAllocatorFor_UploadServiceAccountKey(
        ::grpc::MessageAllocator< ::google::iam::admin::v1::UploadServiceAccountKeyRequest, ::google::iam::admin::v1::ServiceAccountKey>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(12);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::iam::admin::v1::UploadServiceAccountKeyRequest, ::google::iam::admin::v1::ServiceAccountKey>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_UploadServiceAccountKey() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UploadServiceAccountKey(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::UploadServiceAccountKeyRequest* /*request*/, ::google::iam::admin::v1::ServiceAccountKey* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* UploadServiceAccountKey(
      ::grpc::CallbackServerContext* /*context*/, const ::google::iam::admin::v1::UploadServiceAccountKeyRequest* /*request*/, ::google::iam::admin::v1::ServiceAccountKey* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_DeleteServiceAccountKey : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_DeleteServiceAccountKey() {
      ::grpc::Service::MarkMethodCallback(13,
          new ::grpc::internal::CallbackUnaryHandler< ::google::iam::admin::v1::DeleteServiceAccountKeyRequest, ::google::protobuf::Empty>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::iam::admin::v1::DeleteServiceAccountKeyRequest* request, ::google::protobuf::Empty* response) { return this->DeleteServiceAccountKey(context, request, response); }));}
    void SetMessageAllocatorFor_DeleteServiceAccountKey(
        ::grpc::MessageAllocator< ::google::iam::admin::v1::DeleteServiceAccountKeyRequest, ::google::protobuf::Empty>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(13);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::iam::admin::v1::DeleteServiceAccountKeyRequest, ::google::protobuf::Empty>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_DeleteServiceAccountKey() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteServiceAccountKey(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::DeleteServiceAccountKeyRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* DeleteServiceAccountKey(
      ::grpc::CallbackServerContext* /*context*/, const ::google::iam::admin::v1::DeleteServiceAccountKeyRequest* /*request*/, ::google::protobuf::Empty* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_SignBlob : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_SignBlob() {
      ::grpc::Service::MarkMethodCallback(14,
          new ::grpc::internal::CallbackUnaryHandler< ::google::iam::admin::v1::SignBlobRequest, ::google::iam::admin::v1::SignBlobResponse>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::iam::admin::v1::SignBlobRequest* request, ::google::iam::admin::v1::SignBlobResponse* response) { return this->SignBlob(context, request, response); }));}
    void SetMessageAllocatorFor_SignBlob(
        ::grpc::MessageAllocator< ::google::iam::admin::v1::SignBlobRequest, ::google::iam::admin::v1::SignBlobResponse>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(14);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::iam::admin::v1::SignBlobRequest, ::google::iam::admin::v1::SignBlobResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_SignBlob() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status SignBlob(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::SignBlobRequest* /*request*/, ::google::iam::admin::v1::SignBlobResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* SignBlob(
      ::grpc::CallbackServerContext* /*context*/, const ::google::iam::admin::v1::SignBlobRequest* /*request*/, ::google::iam::admin::v1::SignBlobResponse* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_SignJwt : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_SignJwt() {
      ::grpc::Service::MarkMethodCallback(15,
          new ::grpc::internal::CallbackUnaryHandler< ::google::iam::admin::v1::SignJwtRequest, ::google::iam::admin::v1::SignJwtResponse>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::iam::admin::v1::SignJwtRequest* request, ::google::iam::admin::v1::SignJwtResponse* response) { return this->SignJwt(context, request, response); }));}
    void SetMessageAllocatorFor_SignJwt(
        ::grpc::MessageAllocator< ::google::iam::admin::v1::SignJwtRequest, ::google::iam::admin::v1::SignJwtResponse>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(15);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::iam::admin::v1::SignJwtRequest, ::google::iam::admin::v1::SignJwtResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_SignJwt() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status SignJwt(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::SignJwtRequest* /*request*/, ::google::iam::admin::v1::SignJwtResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* SignJwt(
      ::grpc::CallbackServerContext* /*context*/, const ::google::iam::admin::v1::SignJwtRequest* /*request*/, ::google::iam::admin::v1::SignJwtResponse* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_GetIamPolicy : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_GetIamPolicy() {
      ::grpc::Service::MarkMethodCallback(16,
          new ::grpc::internal::CallbackUnaryHandler< ::google::iam::v1::GetIamPolicyRequest, ::google::iam::v1::Policy>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::iam::v1::GetIamPolicyRequest* request, ::google::iam::v1::Policy* response) { return this->GetIamPolicy(context, request, response); }));}
    void SetMessageAllocatorFor_GetIamPolicy(
        ::grpc::MessageAllocator< ::google::iam::v1::GetIamPolicyRequest, ::google::iam::v1::Policy>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(16);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::iam::v1::GetIamPolicyRequest, ::google::iam::v1::Policy>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_GetIamPolicy() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetIamPolicy(::grpc::ServerContext* /*context*/, const ::google::iam::v1::GetIamPolicyRequest* /*request*/, ::google::iam::v1::Policy* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* GetIamPolicy(
      ::grpc::CallbackServerContext* /*context*/, const ::google::iam::v1::GetIamPolicyRequest* /*request*/, ::google::iam::v1::Policy* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_SetIamPolicy : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_SetIamPolicy() {
      ::grpc::Service::MarkMethodCallback(17,
          new ::grpc::internal::CallbackUnaryHandler< ::google::iam::v1::SetIamPolicyRequest, ::google::iam::v1::Policy>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::iam::v1::SetIamPolicyRequest* request, ::google::iam::v1::Policy* response) { return this->SetIamPolicy(context, request, response); }));}
    void SetMessageAllocatorFor_SetIamPolicy(
        ::grpc::MessageAllocator< ::google::iam::v1::SetIamPolicyRequest, ::google::iam::v1::Policy>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(17);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::iam::v1::SetIamPolicyRequest, ::google::iam::v1::Policy>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_SetIamPolicy() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status SetIamPolicy(::grpc::ServerContext* /*context*/, const ::google::iam::v1::SetIamPolicyRequest* /*request*/, ::google::iam::v1::Policy* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* SetIamPolicy(
      ::grpc::CallbackServerContext* /*context*/, const ::google::iam::v1::SetIamPolicyRequest* /*request*/, ::google::iam::v1::Policy* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_TestIamPermissions : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_TestIamPermissions() {
      ::grpc::Service::MarkMethodCallback(18,
          new ::grpc::internal::CallbackUnaryHandler< ::google::iam::v1::TestIamPermissionsRequest, ::google::iam::v1::TestIamPermissionsResponse>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::iam::v1::TestIamPermissionsRequest* request, ::google::iam::v1::TestIamPermissionsResponse* response) { return this->TestIamPermissions(context, request, response); }));}
    void SetMessageAllocatorFor_TestIamPermissions(
        ::grpc::MessageAllocator< ::google::iam::v1::TestIamPermissionsRequest, ::google::iam::v1::TestIamPermissionsResponse>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(18);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::iam::v1::TestIamPermissionsRequest, ::google::iam::v1::TestIamPermissionsResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_TestIamPermissions() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status TestIamPermissions(::grpc::ServerContext* /*context*/, const ::google::iam::v1::TestIamPermissionsRequest* /*request*/, ::google::iam::v1::TestIamPermissionsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* TestIamPermissions(
      ::grpc::CallbackServerContext* /*context*/, const ::google::iam::v1::TestIamPermissionsRequest* /*request*/, ::google::iam::v1::TestIamPermissionsResponse* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_QueryGrantableRoles : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_QueryGrantableRoles() {
      ::grpc::Service::MarkMethodCallback(19,
          new ::grpc::internal::CallbackUnaryHandler< ::google::iam::admin::v1::QueryGrantableRolesRequest, ::google::iam::admin::v1::QueryGrantableRolesResponse>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::iam::admin::v1::QueryGrantableRolesRequest* request, ::google::iam::admin::v1::QueryGrantableRolesResponse* response) { return this->QueryGrantableRoles(context, request, response); }));}
    void SetMessageAllocatorFor_QueryGrantableRoles(
        ::grpc::MessageAllocator< ::google::iam::admin::v1::QueryGrantableRolesRequest, ::google::iam::admin::v1::QueryGrantableRolesResponse>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(19);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::iam::admin::v1::QueryGrantableRolesRequest, ::google::iam::admin::v1::QueryGrantableRolesResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_QueryGrantableRoles() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status QueryGrantableRoles(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::QueryGrantableRolesRequest* /*request*/, ::google::iam::admin::v1::QueryGrantableRolesResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* QueryGrantableRoles(
      ::grpc::CallbackServerContext* /*context*/, const ::google::iam::admin::v1::QueryGrantableRolesRequest* /*request*/, ::google::iam::admin::v1::QueryGrantableRolesResponse* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_ListRoles : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_ListRoles() {
      ::grpc::Service::MarkMethodCallback(20,
          new ::grpc::internal::CallbackUnaryHandler< ::google::iam::admin::v1::ListRolesRequest, ::google::iam::admin::v1::ListRolesResponse>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::iam::admin::v1::ListRolesRequest* request, ::google::iam::admin::v1::ListRolesResponse* response) { return this->ListRoles(context, request, response); }));}
    void SetMessageAllocatorFor_ListRoles(
        ::grpc::MessageAllocator< ::google::iam::admin::v1::ListRolesRequest, ::google::iam::admin::v1::ListRolesResponse>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(20);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::iam::admin::v1::ListRolesRequest, ::google::iam::admin::v1::ListRolesResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_ListRoles() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListRoles(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::ListRolesRequest* /*request*/, ::google::iam::admin::v1::ListRolesResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* ListRoles(
      ::grpc::CallbackServerContext* /*context*/, const ::google::iam::admin::v1::ListRolesRequest* /*request*/, ::google::iam::admin::v1::ListRolesResponse* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_GetRole : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_GetRole() {
      ::grpc::Service::MarkMethodCallback(21,
          new ::grpc::internal::CallbackUnaryHandler< ::google::iam::admin::v1::GetRoleRequest, ::google::iam::admin::v1::Role>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::iam::admin::v1::GetRoleRequest* request, ::google::iam::admin::v1::Role* response) { return this->GetRole(context, request, response); }));}
    void SetMessageAllocatorFor_GetRole(
        ::grpc::MessageAllocator< ::google::iam::admin::v1::GetRoleRequest, ::google::iam::admin::v1::Role>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(21);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::iam::admin::v1::GetRoleRequest, ::google::iam::admin::v1::Role>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_GetRole() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetRole(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::GetRoleRequest* /*request*/, ::google::iam::admin::v1::Role* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* GetRole(
      ::grpc::CallbackServerContext* /*context*/, const ::google::iam::admin::v1::GetRoleRequest* /*request*/, ::google::iam::admin::v1::Role* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_CreateRole : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_CreateRole() {
      ::grpc::Service::MarkMethodCallback(22,
          new ::grpc::internal::CallbackUnaryHandler< ::google::iam::admin::v1::CreateRoleRequest, ::google::iam::admin::v1::Role>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::iam::admin::v1::CreateRoleRequest* request, ::google::iam::admin::v1::Role* response) { return this->CreateRole(context, request, response); }));}
    void SetMessageAllocatorFor_CreateRole(
        ::grpc::MessageAllocator< ::google::iam::admin::v1::CreateRoleRequest, ::google::iam::admin::v1::Role>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(22);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::iam::admin::v1::CreateRoleRequest, ::google::iam::admin::v1::Role>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_CreateRole() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateRole(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::CreateRoleRequest* /*request*/, ::google::iam::admin::v1::Role* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* CreateRole(
      ::grpc::CallbackServerContext* /*context*/, const ::google::iam::admin::v1::CreateRoleRequest* /*request*/, ::google::iam::admin::v1::Role* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_UpdateRole : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_UpdateRole() {
      ::grpc::Service::MarkMethodCallback(23,
          new ::grpc::internal::CallbackUnaryHandler< ::google::iam::admin::v1::UpdateRoleRequest, ::google::iam::admin::v1::Role>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::iam::admin::v1::UpdateRoleRequest* request, ::google::iam::admin::v1::Role* response) { return this->UpdateRole(context, request, response); }));}
    void SetMessageAllocatorFor_UpdateRole(
        ::grpc::MessageAllocator< ::google::iam::admin::v1::UpdateRoleRequest, ::google::iam::admin::v1::Role>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(23);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::iam::admin::v1::UpdateRoleRequest, ::google::iam::admin::v1::Role>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_UpdateRole() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateRole(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::UpdateRoleRequest* /*request*/, ::google::iam::admin::v1::Role* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* UpdateRole(
      ::grpc::CallbackServerContext* /*context*/, const ::google::iam::admin::v1::UpdateRoleRequest* /*request*/, ::google::iam::admin::v1::Role* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_DeleteRole : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_DeleteRole() {
      ::grpc::Service::MarkMethodCallback(24,
          new ::grpc::internal::CallbackUnaryHandler< ::google::iam::admin::v1::DeleteRoleRequest, ::google::iam::admin::v1::Role>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::iam::admin::v1::DeleteRoleRequest* request, ::google::iam::admin::v1::Role* response) { return this->DeleteRole(context, request, response); }));}
    void SetMessageAllocatorFor_DeleteRole(
        ::grpc::MessageAllocator< ::google::iam::admin::v1::DeleteRoleRequest, ::google::iam::admin::v1::Role>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(24);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::iam::admin::v1::DeleteRoleRequest, ::google::iam::admin::v1::Role>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_DeleteRole() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteRole(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::DeleteRoleRequest* /*request*/, ::google::iam::admin::v1::Role* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* DeleteRole(
      ::grpc::CallbackServerContext* /*context*/, const ::google::iam::admin::v1::DeleteRoleRequest* /*request*/, ::google::iam::admin::v1::Role* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_UndeleteRole : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_UndeleteRole() {
      ::grpc::Service::MarkMethodCallback(25,
          new ::grpc::internal::CallbackUnaryHandler< ::google::iam::admin::v1::UndeleteRoleRequest, ::google::iam::admin::v1::Role>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::iam::admin::v1::UndeleteRoleRequest* request, ::google::iam::admin::v1::Role* response) { return this->UndeleteRole(context, request, response); }));}
    void SetMessageAllocatorFor_UndeleteRole(
        ::grpc::MessageAllocator< ::google::iam::admin::v1::UndeleteRoleRequest, ::google::iam::admin::v1::Role>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(25);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::iam::admin::v1::UndeleteRoleRequest, ::google::iam::admin::v1::Role>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_UndeleteRole() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UndeleteRole(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::UndeleteRoleRequest* /*request*/, ::google::iam::admin::v1::Role* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* UndeleteRole(
      ::grpc::CallbackServerContext* /*context*/, const ::google::iam::admin::v1::UndeleteRoleRequest* /*request*/, ::google::iam::admin::v1::Role* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_QueryTestablePermissions : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_QueryTestablePermissions() {
      ::grpc::Service::MarkMethodCallback(26,
          new ::grpc::internal::CallbackUnaryHandler< ::google::iam::admin::v1::QueryTestablePermissionsRequest, ::google::iam::admin::v1::QueryTestablePermissionsResponse>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::iam::admin::v1::QueryTestablePermissionsRequest* request, ::google::iam::admin::v1::QueryTestablePermissionsResponse* response) { return this->QueryTestablePermissions(context, request, response); }));}
    void SetMessageAllocatorFor_QueryTestablePermissions(
        ::grpc::MessageAllocator< ::google::iam::admin::v1::QueryTestablePermissionsRequest, ::google::iam::admin::v1::QueryTestablePermissionsResponse>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(26);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::iam::admin::v1::QueryTestablePermissionsRequest, ::google::iam::admin::v1::QueryTestablePermissionsResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_QueryTestablePermissions() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status QueryTestablePermissions(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::QueryTestablePermissionsRequest* /*request*/, ::google::iam::admin::v1::QueryTestablePermissionsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* QueryTestablePermissions(
      ::grpc::CallbackServerContext* /*context*/, const ::google::iam::admin::v1::QueryTestablePermissionsRequest* /*request*/, ::google::iam::admin::v1::QueryTestablePermissionsResponse* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_QueryAuditableServices : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_QueryAuditableServices() {
      ::grpc::Service::MarkMethodCallback(27,
          new ::grpc::internal::CallbackUnaryHandler< ::google::iam::admin::v1::QueryAuditableServicesRequest, ::google::iam::admin::v1::QueryAuditableServicesResponse>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::iam::admin::v1::QueryAuditableServicesRequest* request, ::google::iam::admin::v1::QueryAuditableServicesResponse* response) { return this->QueryAuditableServices(context, request, response); }));}
    void SetMessageAllocatorFor_QueryAuditableServices(
        ::grpc::MessageAllocator< ::google::iam::admin::v1::QueryAuditableServicesRequest, ::google::iam::admin::v1::QueryAuditableServicesResponse>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(27);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::iam::admin::v1::QueryAuditableServicesRequest, ::google::iam::admin::v1::QueryAuditableServicesResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_QueryAuditableServices() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status QueryAuditableServices(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::QueryAuditableServicesRequest* /*request*/, ::google::iam::admin::v1::QueryAuditableServicesResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* QueryAuditableServices(
      ::grpc::CallbackServerContext* /*context*/, const ::google::iam::admin::v1::QueryAuditableServicesRequest* /*request*/, ::google::iam::admin::v1::QueryAuditableServicesResponse* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_LintPolicy : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_LintPolicy() {
      ::grpc::Service::MarkMethodCallback(28,
          new ::grpc::internal::CallbackUnaryHandler< ::google::iam::admin::v1::LintPolicyRequest, ::google::iam::admin::v1::LintPolicyResponse>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::iam::admin::v1::LintPolicyRequest* request, ::google::iam::admin::v1::LintPolicyResponse* response) { return this->LintPolicy(context, request, response); }));}
    void SetMessageAllocatorFor_LintPolicy(
        ::grpc::MessageAllocator< ::google::iam::admin::v1::LintPolicyRequest, ::google::iam::admin::v1::LintPolicyResponse>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(28);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::iam::admin::v1::LintPolicyRequest, ::google::iam::admin::v1::LintPolicyResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_LintPolicy() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status LintPolicy(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::LintPolicyRequest* /*request*/, ::google::iam::admin::v1::LintPolicyResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* LintPolicy(
      ::grpc::CallbackServerContext* /*context*/, const ::google::iam::admin::v1::LintPolicyRequest* /*request*/, ::google::iam::admin::v1::LintPolicyResponse* /*response*/)  { return nullptr; }
  };
  typedef WithCallbackMethod_ListServiceAccounts<WithCallbackMethod_GetServiceAccount<WithCallbackMethod_CreateServiceAccount<WithCallbackMethod_UpdateServiceAccount<WithCallbackMethod_PatchServiceAccount<WithCallbackMethod_DeleteServiceAccount<WithCallbackMethod_UndeleteServiceAccount<WithCallbackMethod_EnableServiceAccount<WithCallbackMethod_DisableServiceAccount<WithCallbackMethod_ListServiceAccountKeys<WithCallbackMethod_GetServiceAccountKey<WithCallbackMethod_CreateServiceAccountKey<WithCallbackMethod_UploadServiceAccountKey<WithCallbackMethod_DeleteServiceAccountKey<WithCallbackMethod_SignBlob<WithCallbackMethod_SignJwt<WithCallbackMethod_GetIamPolicy<WithCallbackMethod_SetIamPolicy<WithCallbackMethod_TestIamPermissions<WithCallbackMethod_QueryGrantableRoles<WithCallbackMethod_ListRoles<WithCallbackMethod_GetRole<WithCallbackMethod_CreateRole<WithCallbackMethod_UpdateRole<WithCallbackMethod_DeleteRole<WithCallbackMethod_UndeleteRole<WithCallbackMethod_QueryTestablePermissions<WithCallbackMethod_QueryAuditableServices<WithCallbackMethod_LintPolicy<Service > > > > > > > > > > > > > > > > > > > > > > > > > > > > > CallbackService;
  typedef CallbackService ExperimentalCallbackService;
  template <class BaseClass>
  class WithGenericMethod_ListServiceAccounts : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_ListServiceAccounts() {
      ::grpc::Service::MarkMethodGeneric(0);
    }
    ~WithGenericMethod_ListServiceAccounts() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListServiceAccounts(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::ListServiceAccountsRequest* /*request*/, ::google::iam::admin::v1::ListServiceAccountsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_GetServiceAccount : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_GetServiceAccount() {
      ::grpc::Service::MarkMethodGeneric(1);
    }
    ~WithGenericMethod_GetServiceAccount() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetServiceAccount(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::GetServiceAccountRequest* /*request*/, ::google::iam::admin::v1::ServiceAccount* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_CreateServiceAccount : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_CreateServiceAccount() {
      ::grpc::Service::MarkMethodGeneric(2);
    }
    ~WithGenericMethod_CreateServiceAccount() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateServiceAccount(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::CreateServiceAccountRequest* /*request*/, ::google::iam::admin::v1::ServiceAccount* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_UpdateServiceAccount : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_UpdateServiceAccount() {
      ::grpc::Service::MarkMethodGeneric(3);
    }
    ~WithGenericMethod_UpdateServiceAccount() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateServiceAccount(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::ServiceAccount* /*request*/, ::google::iam::admin::v1::ServiceAccount* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_PatchServiceAccount : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_PatchServiceAccount() {
      ::grpc::Service::MarkMethodGeneric(4);
    }
    ~WithGenericMethod_PatchServiceAccount() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status PatchServiceAccount(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::PatchServiceAccountRequest* /*request*/, ::google::iam::admin::v1::ServiceAccount* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_DeleteServiceAccount : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_DeleteServiceAccount() {
      ::grpc::Service::MarkMethodGeneric(5);
    }
    ~WithGenericMethod_DeleteServiceAccount() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteServiceAccount(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::DeleteServiceAccountRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_UndeleteServiceAccount : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_UndeleteServiceAccount() {
      ::grpc::Service::MarkMethodGeneric(6);
    }
    ~WithGenericMethod_UndeleteServiceAccount() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UndeleteServiceAccount(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::UndeleteServiceAccountRequest* /*request*/, ::google::iam::admin::v1::UndeleteServiceAccountResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_EnableServiceAccount : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_EnableServiceAccount() {
      ::grpc::Service::MarkMethodGeneric(7);
    }
    ~WithGenericMethod_EnableServiceAccount() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status EnableServiceAccount(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::EnableServiceAccountRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_DisableServiceAccount : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_DisableServiceAccount() {
      ::grpc::Service::MarkMethodGeneric(8);
    }
    ~WithGenericMethod_DisableServiceAccount() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DisableServiceAccount(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::DisableServiceAccountRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_ListServiceAccountKeys : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_ListServiceAccountKeys() {
      ::grpc::Service::MarkMethodGeneric(9);
    }
    ~WithGenericMethod_ListServiceAccountKeys() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListServiceAccountKeys(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::ListServiceAccountKeysRequest* /*request*/, ::google::iam::admin::v1::ListServiceAccountKeysResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_GetServiceAccountKey : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_GetServiceAccountKey() {
      ::grpc::Service::MarkMethodGeneric(10);
    }
    ~WithGenericMethod_GetServiceAccountKey() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetServiceAccountKey(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::GetServiceAccountKeyRequest* /*request*/, ::google::iam::admin::v1::ServiceAccountKey* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_CreateServiceAccountKey : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_CreateServiceAccountKey() {
      ::grpc::Service::MarkMethodGeneric(11);
    }
    ~WithGenericMethod_CreateServiceAccountKey() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateServiceAccountKey(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::CreateServiceAccountKeyRequest* /*request*/, ::google::iam::admin::v1::ServiceAccountKey* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_UploadServiceAccountKey : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_UploadServiceAccountKey() {
      ::grpc::Service::MarkMethodGeneric(12);
    }
    ~WithGenericMethod_UploadServiceAccountKey() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UploadServiceAccountKey(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::UploadServiceAccountKeyRequest* /*request*/, ::google::iam::admin::v1::ServiceAccountKey* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_DeleteServiceAccountKey : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_DeleteServiceAccountKey() {
      ::grpc::Service::MarkMethodGeneric(13);
    }
    ~WithGenericMethod_DeleteServiceAccountKey() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteServiceAccountKey(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::DeleteServiceAccountKeyRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_SignBlob : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_SignBlob() {
      ::grpc::Service::MarkMethodGeneric(14);
    }
    ~WithGenericMethod_SignBlob() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status SignBlob(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::SignBlobRequest* /*request*/, ::google::iam::admin::v1::SignBlobResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_SignJwt : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_SignJwt() {
      ::grpc::Service::MarkMethodGeneric(15);
    }
    ~WithGenericMethod_SignJwt() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status SignJwt(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::SignJwtRequest* /*request*/, ::google::iam::admin::v1::SignJwtResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_GetIamPolicy : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_GetIamPolicy() {
      ::grpc::Service::MarkMethodGeneric(16);
    }
    ~WithGenericMethod_GetIamPolicy() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetIamPolicy(::grpc::ServerContext* /*context*/, const ::google::iam::v1::GetIamPolicyRequest* /*request*/, ::google::iam::v1::Policy* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_SetIamPolicy : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_SetIamPolicy() {
      ::grpc::Service::MarkMethodGeneric(17);
    }
    ~WithGenericMethod_SetIamPolicy() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status SetIamPolicy(::grpc::ServerContext* /*context*/, const ::google::iam::v1::SetIamPolicyRequest* /*request*/, ::google::iam::v1::Policy* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_TestIamPermissions : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_TestIamPermissions() {
      ::grpc::Service::MarkMethodGeneric(18);
    }
    ~WithGenericMethod_TestIamPermissions() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status TestIamPermissions(::grpc::ServerContext* /*context*/, const ::google::iam::v1::TestIamPermissionsRequest* /*request*/, ::google::iam::v1::TestIamPermissionsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_QueryGrantableRoles : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_QueryGrantableRoles() {
      ::grpc::Service::MarkMethodGeneric(19);
    }
    ~WithGenericMethod_QueryGrantableRoles() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status QueryGrantableRoles(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::QueryGrantableRolesRequest* /*request*/, ::google::iam::admin::v1::QueryGrantableRolesResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_ListRoles : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_ListRoles() {
      ::grpc::Service::MarkMethodGeneric(20);
    }
    ~WithGenericMethod_ListRoles() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListRoles(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::ListRolesRequest* /*request*/, ::google::iam::admin::v1::ListRolesResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_GetRole : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_GetRole() {
      ::grpc::Service::MarkMethodGeneric(21);
    }
    ~WithGenericMethod_GetRole() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetRole(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::GetRoleRequest* /*request*/, ::google::iam::admin::v1::Role* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_CreateRole : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_CreateRole() {
      ::grpc::Service::MarkMethodGeneric(22);
    }
    ~WithGenericMethod_CreateRole() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateRole(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::CreateRoleRequest* /*request*/, ::google::iam::admin::v1::Role* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_UpdateRole : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_UpdateRole() {
      ::grpc::Service::MarkMethodGeneric(23);
    }
    ~WithGenericMethod_UpdateRole() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateRole(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::UpdateRoleRequest* /*request*/, ::google::iam::admin::v1::Role* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_DeleteRole : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_DeleteRole() {
      ::grpc::Service::MarkMethodGeneric(24);
    }
    ~WithGenericMethod_DeleteRole() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteRole(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::DeleteRoleRequest* /*request*/, ::google::iam::admin::v1::Role* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_UndeleteRole : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_UndeleteRole() {
      ::grpc::Service::MarkMethodGeneric(25);
    }
    ~WithGenericMethod_UndeleteRole() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UndeleteRole(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::UndeleteRoleRequest* /*request*/, ::google::iam::admin::v1::Role* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_QueryTestablePermissions : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_QueryTestablePermissions() {
      ::grpc::Service::MarkMethodGeneric(26);
    }
    ~WithGenericMethod_QueryTestablePermissions() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status QueryTestablePermissions(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::QueryTestablePermissionsRequest* /*request*/, ::google::iam::admin::v1::QueryTestablePermissionsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_QueryAuditableServices : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_QueryAuditableServices() {
      ::grpc::Service::MarkMethodGeneric(27);
    }
    ~WithGenericMethod_QueryAuditableServices() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status QueryAuditableServices(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::QueryAuditableServicesRequest* /*request*/, ::google::iam::admin::v1::QueryAuditableServicesResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_LintPolicy : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_LintPolicy() {
      ::grpc::Service::MarkMethodGeneric(28);
    }
    ~WithGenericMethod_LintPolicy() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status LintPolicy(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::LintPolicyRequest* /*request*/, ::google::iam::admin::v1::LintPolicyResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithRawMethod_ListServiceAccounts : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_ListServiceAccounts() {
      ::grpc::Service::MarkMethodRaw(0);
    }
    ~WithRawMethod_ListServiceAccounts() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListServiceAccounts(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::ListServiceAccountsRequest* /*request*/, ::google::iam::admin::v1::ListServiceAccountsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestListServiceAccounts(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(0, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_GetServiceAccount : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_GetServiceAccount() {
      ::grpc::Service::MarkMethodRaw(1);
    }
    ~WithRawMethod_GetServiceAccount() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetServiceAccount(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::GetServiceAccountRequest* /*request*/, ::google::iam::admin::v1::ServiceAccount* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGetServiceAccount(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(1, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_CreateServiceAccount : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_CreateServiceAccount() {
      ::grpc::Service::MarkMethodRaw(2);
    }
    ~WithRawMethod_CreateServiceAccount() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateServiceAccount(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::CreateServiceAccountRequest* /*request*/, ::google::iam::admin::v1::ServiceAccount* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestCreateServiceAccount(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(2, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_UpdateServiceAccount : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_UpdateServiceAccount() {
      ::grpc::Service::MarkMethodRaw(3);
    }
    ~WithRawMethod_UpdateServiceAccount() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateServiceAccount(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::ServiceAccount* /*request*/, ::google::iam::admin::v1::ServiceAccount* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestUpdateServiceAccount(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(3, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_PatchServiceAccount : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_PatchServiceAccount() {
      ::grpc::Service::MarkMethodRaw(4);
    }
    ~WithRawMethod_PatchServiceAccount() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status PatchServiceAccount(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::PatchServiceAccountRequest* /*request*/, ::google::iam::admin::v1::ServiceAccount* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestPatchServiceAccount(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(4, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_DeleteServiceAccount : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_DeleteServiceAccount() {
      ::grpc::Service::MarkMethodRaw(5);
    }
    ~WithRawMethod_DeleteServiceAccount() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteServiceAccount(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::DeleteServiceAccountRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestDeleteServiceAccount(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(5, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_UndeleteServiceAccount : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_UndeleteServiceAccount() {
      ::grpc::Service::MarkMethodRaw(6);
    }
    ~WithRawMethod_UndeleteServiceAccount() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UndeleteServiceAccount(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::UndeleteServiceAccountRequest* /*request*/, ::google::iam::admin::v1::UndeleteServiceAccountResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestUndeleteServiceAccount(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(6, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_EnableServiceAccount : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_EnableServiceAccount() {
      ::grpc::Service::MarkMethodRaw(7);
    }
    ~WithRawMethod_EnableServiceAccount() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status EnableServiceAccount(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::EnableServiceAccountRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestEnableServiceAccount(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(7, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_DisableServiceAccount : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_DisableServiceAccount() {
      ::grpc::Service::MarkMethodRaw(8);
    }
    ~WithRawMethod_DisableServiceAccount() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DisableServiceAccount(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::DisableServiceAccountRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestDisableServiceAccount(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(8, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_ListServiceAccountKeys : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_ListServiceAccountKeys() {
      ::grpc::Service::MarkMethodRaw(9);
    }
    ~WithRawMethod_ListServiceAccountKeys() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListServiceAccountKeys(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::ListServiceAccountKeysRequest* /*request*/, ::google::iam::admin::v1::ListServiceAccountKeysResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestListServiceAccountKeys(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(9, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_GetServiceAccountKey : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_GetServiceAccountKey() {
      ::grpc::Service::MarkMethodRaw(10);
    }
    ~WithRawMethod_GetServiceAccountKey() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetServiceAccountKey(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::GetServiceAccountKeyRequest* /*request*/, ::google::iam::admin::v1::ServiceAccountKey* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGetServiceAccountKey(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(10, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_CreateServiceAccountKey : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_CreateServiceAccountKey() {
      ::grpc::Service::MarkMethodRaw(11);
    }
    ~WithRawMethod_CreateServiceAccountKey() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateServiceAccountKey(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::CreateServiceAccountKeyRequest* /*request*/, ::google::iam::admin::v1::ServiceAccountKey* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestCreateServiceAccountKey(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(11, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_UploadServiceAccountKey : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_UploadServiceAccountKey() {
      ::grpc::Service::MarkMethodRaw(12);
    }
    ~WithRawMethod_UploadServiceAccountKey() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UploadServiceAccountKey(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::UploadServiceAccountKeyRequest* /*request*/, ::google::iam::admin::v1::ServiceAccountKey* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestUploadServiceAccountKey(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(12, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_DeleteServiceAccountKey : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_DeleteServiceAccountKey() {
      ::grpc::Service::MarkMethodRaw(13);
    }
    ~WithRawMethod_DeleteServiceAccountKey() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteServiceAccountKey(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::DeleteServiceAccountKeyRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestDeleteServiceAccountKey(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(13, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_SignBlob : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_SignBlob() {
      ::grpc::Service::MarkMethodRaw(14);
    }
    ~WithRawMethod_SignBlob() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status SignBlob(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::SignBlobRequest* /*request*/, ::google::iam::admin::v1::SignBlobResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestSignBlob(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(14, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_SignJwt : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_SignJwt() {
      ::grpc::Service::MarkMethodRaw(15);
    }
    ~WithRawMethod_SignJwt() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status SignJwt(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::SignJwtRequest* /*request*/, ::google::iam::admin::v1::SignJwtResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestSignJwt(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(15, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_GetIamPolicy : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_GetIamPolicy() {
      ::grpc::Service::MarkMethodRaw(16);
    }
    ~WithRawMethod_GetIamPolicy() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetIamPolicy(::grpc::ServerContext* /*context*/, const ::google::iam::v1::GetIamPolicyRequest* /*request*/, ::google::iam::v1::Policy* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGetIamPolicy(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(16, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_SetIamPolicy : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_SetIamPolicy() {
      ::grpc::Service::MarkMethodRaw(17);
    }
    ~WithRawMethod_SetIamPolicy() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status SetIamPolicy(::grpc::ServerContext* /*context*/, const ::google::iam::v1::SetIamPolicyRequest* /*request*/, ::google::iam::v1::Policy* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestSetIamPolicy(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(17, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_TestIamPermissions : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_TestIamPermissions() {
      ::grpc::Service::MarkMethodRaw(18);
    }
    ~WithRawMethod_TestIamPermissions() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status TestIamPermissions(::grpc::ServerContext* /*context*/, const ::google::iam::v1::TestIamPermissionsRequest* /*request*/, ::google::iam::v1::TestIamPermissionsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestTestIamPermissions(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(18, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_QueryGrantableRoles : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_QueryGrantableRoles() {
      ::grpc::Service::MarkMethodRaw(19);
    }
    ~WithRawMethod_QueryGrantableRoles() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status QueryGrantableRoles(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::QueryGrantableRolesRequest* /*request*/, ::google::iam::admin::v1::QueryGrantableRolesResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestQueryGrantableRoles(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(19, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_ListRoles : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_ListRoles() {
      ::grpc::Service::MarkMethodRaw(20);
    }
    ~WithRawMethod_ListRoles() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListRoles(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::ListRolesRequest* /*request*/, ::google::iam::admin::v1::ListRolesResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestListRoles(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(20, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_GetRole : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_GetRole() {
      ::grpc::Service::MarkMethodRaw(21);
    }
    ~WithRawMethod_GetRole() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetRole(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::GetRoleRequest* /*request*/, ::google::iam::admin::v1::Role* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGetRole(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(21, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_CreateRole : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_CreateRole() {
      ::grpc::Service::MarkMethodRaw(22);
    }
    ~WithRawMethod_CreateRole() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateRole(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::CreateRoleRequest* /*request*/, ::google::iam::admin::v1::Role* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestCreateRole(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(22, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_UpdateRole : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_UpdateRole() {
      ::grpc::Service::MarkMethodRaw(23);
    }
    ~WithRawMethod_UpdateRole() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateRole(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::UpdateRoleRequest* /*request*/, ::google::iam::admin::v1::Role* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestUpdateRole(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(23, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_DeleteRole : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_DeleteRole() {
      ::grpc::Service::MarkMethodRaw(24);
    }
    ~WithRawMethod_DeleteRole() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteRole(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::DeleteRoleRequest* /*request*/, ::google::iam::admin::v1::Role* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestDeleteRole(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(24, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_UndeleteRole : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_UndeleteRole() {
      ::grpc::Service::MarkMethodRaw(25);
    }
    ~WithRawMethod_UndeleteRole() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UndeleteRole(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::UndeleteRoleRequest* /*request*/, ::google::iam::admin::v1::Role* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestUndeleteRole(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(25, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_QueryTestablePermissions : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_QueryTestablePermissions() {
      ::grpc::Service::MarkMethodRaw(26);
    }
    ~WithRawMethod_QueryTestablePermissions() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status QueryTestablePermissions(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::QueryTestablePermissionsRequest* /*request*/, ::google::iam::admin::v1::QueryTestablePermissionsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestQueryTestablePermissions(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(26, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_QueryAuditableServices : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_QueryAuditableServices() {
      ::grpc::Service::MarkMethodRaw(27);
    }
    ~WithRawMethod_QueryAuditableServices() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status QueryAuditableServices(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::QueryAuditableServicesRequest* /*request*/, ::google::iam::admin::v1::QueryAuditableServicesResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestQueryAuditableServices(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(27, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_LintPolicy : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_LintPolicy() {
      ::grpc::Service::MarkMethodRaw(28);
    }
    ~WithRawMethod_LintPolicy() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status LintPolicy(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::LintPolicyRequest* /*request*/, ::google::iam::admin::v1::LintPolicyResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestLintPolicy(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(28, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_ListServiceAccounts : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_ListServiceAccounts() {
      ::grpc::Service::MarkMethodRawCallback(0,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->ListServiceAccounts(context, request, response); }));
    }
    ~WithRawCallbackMethod_ListServiceAccounts() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListServiceAccounts(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::ListServiceAccountsRequest* /*request*/, ::google::iam::admin::v1::ListServiceAccountsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* ListServiceAccounts(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_GetServiceAccount : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_GetServiceAccount() {
      ::grpc::Service::MarkMethodRawCallback(1,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->GetServiceAccount(context, request, response); }));
    }
    ~WithRawCallbackMethod_GetServiceAccount() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetServiceAccount(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::GetServiceAccountRequest* /*request*/, ::google::iam::admin::v1::ServiceAccount* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* GetServiceAccount(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_CreateServiceAccount : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_CreateServiceAccount() {
      ::grpc::Service::MarkMethodRawCallback(2,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->CreateServiceAccount(context, request, response); }));
    }
    ~WithRawCallbackMethod_CreateServiceAccount() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateServiceAccount(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::CreateServiceAccountRequest* /*request*/, ::google::iam::admin::v1::ServiceAccount* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* CreateServiceAccount(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_UpdateServiceAccount : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_UpdateServiceAccount() {
      ::grpc::Service::MarkMethodRawCallback(3,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->UpdateServiceAccount(context, request, response); }));
    }
    ~WithRawCallbackMethod_UpdateServiceAccount() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateServiceAccount(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::ServiceAccount* /*request*/, ::google::iam::admin::v1::ServiceAccount* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* UpdateServiceAccount(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_PatchServiceAccount : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_PatchServiceAccount() {
      ::grpc::Service::MarkMethodRawCallback(4,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->PatchServiceAccount(context, request, response); }));
    }
    ~WithRawCallbackMethod_PatchServiceAccount() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status PatchServiceAccount(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::PatchServiceAccountRequest* /*request*/, ::google::iam::admin::v1::ServiceAccount* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* PatchServiceAccount(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_DeleteServiceAccount : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_DeleteServiceAccount() {
      ::grpc::Service::MarkMethodRawCallback(5,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->DeleteServiceAccount(context, request, response); }));
    }
    ~WithRawCallbackMethod_DeleteServiceAccount() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteServiceAccount(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::DeleteServiceAccountRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* DeleteServiceAccount(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_UndeleteServiceAccount : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_UndeleteServiceAccount() {
      ::grpc::Service::MarkMethodRawCallback(6,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->UndeleteServiceAccount(context, request, response); }));
    }
    ~WithRawCallbackMethod_UndeleteServiceAccount() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UndeleteServiceAccount(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::UndeleteServiceAccountRequest* /*request*/, ::google::iam::admin::v1::UndeleteServiceAccountResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* UndeleteServiceAccount(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_EnableServiceAccount : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_EnableServiceAccount() {
      ::grpc::Service::MarkMethodRawCallback(7,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->EnableServiceAccount(context, request, response); }));
    }
    ~WithRawCallbackMethod_EnableServiceAccount() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status EnableServiceAccount(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::EnableServiceAccountRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* EnableServiceAccount(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_DisableServiceAccount : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_DisableServiceAccount() {
      ::grpc::Service::MarkMethodRawCallback(8,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->DisableServiceAccount(context, request, response); }));
    }
    ~WithRawCallbackMethod_DisableServiceAccount() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DisableServiceAccount(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::DisableServiceAccountRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* DisableServiceAccount(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_ListServiceAccountKeys : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_ListServiceAccountKeys() {
      ::grpc::Service::MarkMethodRawCallback(9,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->ListServiceAccountKeys(context, request, response); }));
    }
    ~WithRawCallbackMethod_ListServiceAccountKeys() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListServiceAccountKeys(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::ListServiceAccountKeysRequest* /*request*/, ::google::iam::admin::v1::ListServiceAccountKeysResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* ListServiceAccountKeys(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_GetServiceAccountKey : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_GetServiceAccountKey() {
      ::grpc::Service::MarkMethodRawCallback(10,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->GetServiceAccountKey(context, request, response); }));
    }
    ~WithRawCallbackMethod_GetServiceAccountKey() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetServiceAccountKey(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::GetServiceAccountKeyRequest* /*request*/, ::google::iam::admin::v1::ServiceAccountKey* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* GetServiceAccountKey(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_CreateServiceAccountKey : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_CreateServiceAccountKey() {
      ::grpc::Service::MarkMethodRawCallback(11,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->CreateServiceAccountKey(context, request, response); }));
    }
    ~WithRawCallbackMethod_CreateServiceAccountKey() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateServiceAccountKey(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::CreateServiceAccountKeyRequest* /*request*/, ::google::iam::admin::v1::ServiceAccountKey* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* CreateServiceAccountKey(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_UploadServiceAccountKey : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_UploadServiceAccountKey() {
      ::grpc::Service::MarkMethodRawCallback(12,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->UploadServiceAccountKey(context, request, response); }));
    }
    ~WithRawCallbackMethod_UploadServiceAccountKey() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UploadServiceAccountKey(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::UploadServiceAccountKeyRequest* /*request*/, ::google::iam::admin::v1::ServiceAccountKey* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* UploadServiceAccountKey(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_DeleteServiceAccountKey : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_DeleteServiceAccountKey() {
      ::grpc::Service::MarkMethodRawCallback(13,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->DeleteServiceAccountKey(context, request, response); }));
    }
    ~WithRawCallbackMethod_DeleteServiceAccountKey() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteServiceAccountKey(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::DeleteServiceAccountKeyRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* DeleteServiceAccountKey(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_SignBlob : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_SignBlob() {
      ::grpc::Service::MarkMethodRawCallback(14,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->SignBlob(context, request, response); }));
    }
    ~WithRawCallbackMethod_SignBlob() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status SignBlob(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::SignBlobRequest* /*request*/, ::google::iam::admin::v1::SignBlobResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* SignBlob(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_SignJwt : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_SignJwt() {
      ::grpc::Service::MarkMethodRawCallback(15,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->SignJwt(context, request, response); }));
    }
    ~WithRawCallbackMethod_SignJwt() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status SignJwt(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::SignJwtRequest* /*request*/, ::google::iam::admin::v1::SignJwtResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* SignJwt(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_GetIamPolicy : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_GetIamPolicy() {
      ::grpc::Service::MarkMethodRawCallback(16,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->GetIamPolicy(context, request, response); }));
    }
    ~WithRawCallbackMethod_GetIamPolicy() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetIamPolicy(::grpc::ServerContext* /*context*/, const ::google::iam::v1::GetIamPolicyRequest* /*request*/, ::google::iam::v1::Policy* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* GetIamPolicy(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_SetIamPolicy : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_SetIamPolicy() {
      ::grpc::Service::MarkMethodRawCallback(17,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->SetIamPolicy(context, request, response); }));
    }
    ~WithRawCallbackMethod_SetIamPolicy() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status SetIamPolicy(::grpc::ServerContext* /*context*/, const ::google::iam::v1::SetIamPolicyRequest* /*request*/, ::google::iam::v1::Policy* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* SetIamPolicy(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_TestIamPermissions : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_TestIamPermissions() {
      ::grpc::Service::MarkMethodRawCallback(18,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->TestIamPermissions(context, request, response); }));
    }
    ~WithRawCallbackMethod_TestIamPermissions() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status TestIamPermissions(::grpc::ServerContext* /*context*/, const ::google::iam::v1::TestIamPermissionsRequest* /*request*/, ::google::iam::v1::TestIamPermissionsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* TestIamPermissions(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_QueryGrantableRoles : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_QueryGrantableRoles() {
      ::grpc::Service::MarkMethodRawCallback(19,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->QueryGrantableRoles(context, request, response); }));
    }
    ~WithRawCallbackMethod_QueryGrantableRoles() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status QueryGrantableRoles(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::QueryGrantableRolesRequest* /*request*/, ::google::iam::admin::v1::QueryGrantableRolesResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* QueryGrantableRoles(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_ListRoles : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_ListRoles() {
      ::grpc::Service::MarkMethodRawCallback(20,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->ListRoles(context, request, response); }));
    }
    ~WithRawCallbackMethod_ListRoles() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListRoles(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::ListRolesRequest* /*request*/, ::google::iam::admin::v1::ListRolesResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* ListRoles(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_GetRole : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_GetRole() {
      ::grpc::Service::MarkMethodRawCallback(21,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->GetRole(context, request, response); }));
    }
    ~WithRawCallbackMethod_GetRole() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetRole(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::GetRoleRequest* /*request*/, ::google::iam::admin::v1::Role* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* GetRole(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_CreateRole : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_CreateRole() {
      ::grpc::Service::MarkMethodRawCallback(22,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->CreateRole(context, request, response); }));
    }
    ~WithRawCallbackMethod_CreateRole() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateRole(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::CreateRoleRequest* /*request*/, ::google::iam::admin::v1::Role* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* CreateRole(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_UpdateRole : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_UpdateRole() {
      ::grpc::Service::MarkMethodRawCallback(23,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->UpdateRole(context, request, response); }));
    }
    ~WithRawCallbackMethod_UpdateRole() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateRole(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::UpdateRoleRequest* /*request*/, ::google::iam::admin::v1::Role* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* UpdateRole(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_DeleteRole : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_DeleteRole() {
      ::grpc::Service::MarkMethodRawCallback(24,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->DeleteRole(context, request, response); }));
    }
    ~WithRawCallbackMethod_DeleteRole() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteRole(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::DeleteRoleRequest* /*request*/, ::google::iam::admin::v1::Role* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* DeleteRole(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_UndeleteRole : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_UndeleteRole() {
      ::grpc::Service::MarkMethodRawCallback(25,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->UndeleteRole(context, request, response); }));
    }
    ~WithRawCallbackMethod_UndeleteRole() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UndeleteRole(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::UndeleteRoleRequest* /*request*/, ::google::iam::admin::v1::Role* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* UndeleteRole(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_QueryTestablePermissions : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_QueryTestablePermissions() {
      ::grpc::Service::MarkMethodRawCallback(26,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->QueryTestablePermissions(context, request, response); }));
    }
    ~WithRawCallbackMethod_QueryTestablePermissions() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status QueryTestablePermissions(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::QueryTestablePermissionsRequest* /*request*/, ::google::iam::admin::v1::QueryTestablePermissionsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* QueryTestablePermissions(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_QueryAuditableServices : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_QueryAuditableServices() {
      ::grpc::Service::MarkMethodRawCallback(27,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->QueryAuditableServices(context, request, response); }));
    }
    ~WithRawCallbackMethod_QueryAuditableServices() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status QueryAuditableServices(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::QueryAuditableServicesRequest* /*request*/, ::google::iam::admin::v1::QueryAuditableServicesResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* QueryAuditableServices(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_LintPolicy : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_LintPolicy() {
      ::grpc::Service::MarkMethodRawCallback(28,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->LintPolicy(context, request, response); }));
    }
    ~WithRawCallbackMethod_LintPolicy() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status LintPolicy(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::LintPolicyRequest* /*request*/, ::google::iam::admin::v1::LintPolicyResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* LintPolicy(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_ListServiceAccounts : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_ListServiceAccounts() {
      ::grpc::Service::MarkMethodStreamed(0,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::iam::admin::v1::ListServiceAccountsRequest, ::google::iam::admin::v1::ListServiceAccountsResponse>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::iam::admin::v1::ListServiceAccountsRequest, ::google::iam::admin::v1::ListServiceAccountsResponse>* streamer) {
                       return this->StreamedListServiceAccounts(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_ListServiceAccounts() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status ListServiceAccounts(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::ListServiceAccountsRequest* /*request*/, ::google::iam::admin::v1::ListServiceAccountsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedListServiceAccounts(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::iam::admin::v1::ListServiceAccountsRequest,::google::iam::admin::v1::ListServiceAccountsResponse>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_GetServiceAccount : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_GetServiceAccount() {
      ::grpc::Service::MarkMethodStreamed(1,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::iam::admin::v1::GetServiceAccountRequest, ::google::iam::admin::v1::ServiceAccount>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::iam::admin::v1::GetServiceAccountRequest, ::google::iam::admin::v1::ServiceAccount>* streamer) {
                       return this->StreamedGetServiceAccount(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_GetServiceAccount() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status GetServiceAccount(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::GetServiceAccountRequest* /*request*/, ::google::iam::admin::v1::ServiceAccount* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedGetServiceAccount(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::iam::admin::v1::GetServiceAccountRequest,::google::iam::admin::v1::ServiceAccount>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_CreateServiceAccount : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_CreateServiceAccount() {
      ::grpc::Service::MarkMethodStreamed(2,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::iam::admin::v1::CreateServiceAccountRequest, ::google::iam::admin::v1::ServiceAccount>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::iam::admin::v1::CreateServiceAccountRequest, ::google::iam::admin::v1::ServiceAccount>* streamer) {
                       return this->StreamedCreateServiceAccount(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_CreateServiceAccount() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status CreateServiceAccount(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::CreateServiceAccountRequest* /*request*/, ::google::iam::admin::v1::ServiceAccount* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedCreateServiceAccount(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::iam::admin::v1::CreateServiceAccountRequest,::google::iam::admin::v1::ServiceAccount>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_UpdateServiceAccount : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_UpdateServiceAccount() {
      ::grpc::Service::MarkMethodStreamed(3,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::iam::admin::v1::ServiceAccount, ::google::iam::admin::v1::ServiceAccount>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::iam::admin::v1::ServiceAccount, ::google::iam::admin::v1::ServiceAccount>* streamer) {
                       return this->StreamedUpdateServiceAccount(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_UpdateServiceAccount() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status UpdateServiceAccount(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::ServiceAccount* /*request*/, ::google::iam::admin::v1::ServiceAccount* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedUpdateServiceAccount(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::iam::admin::v1::ServiceAccount,::google::iam::admin::v1::ServiceAccount>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_PatchServiceAccount : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_PatchServiceAccount() {
      ::grpc::Service::MarkMethodStreamed(4,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::iam::admin::v1::PatchServiceAccountRequest, ::google::iam::admin::v1::ServiceAccount>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::iam::admin::v1::PatchServiceAccountRequest, ::google::iam::admin::v1::ServiceAccount>* streamer) {
                       return this->StreamedPatchServiceAccount(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_PatchServiceAccount() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status PatchServiceAccount(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::PatchServiceAccountRequest* /*request*/, ::google::iam::admin::v1::ServiceAccount* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedPatchServiceAccount(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::iam::admin::v1::PatchServiceAccountRequest,::google::iam::admin::v1::ServiceAccount>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_DeleteServiceAccount : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_DeleteServiceAccount() {
      ::grpc::Service::MarkMethodStreamed(5,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::iam::admin::v1::DeleteServiceAccountRequest, ::google::protobuf::Empty>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::iam::admin::v1::DeleteServiceAccountRequest, ::google::protobuf::Empty>* streamer) {
                       return this->StreamedDeleteServiceAccount(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_DeleteServiceAccount() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status DeleteServiceAccount(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::DeleteServiceAccountRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedDeleteServiceAccount(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::iam::admin::v1::DeleteServiceAccountRequest,::google::protobuf::Empty>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_UndeleteServiceAccount : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_UndeleteServiceAccount() {
      ::grpc::Service::MarkMethodStreamed(6,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::iam::admin::v1::UndeleteServiceAccountRequest, ::google::iam::admin::v1::UndeleteServiceAccountResponse>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::iam::admin::v1::UndeleteServiceAccountRequest, ::google::iam::admin::v1::UndeleteServiceAccountResponse>* streamer) {
                       return this->StreamedUndeleteServiceAccount(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_UndeleteServiceAccount() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status UndeleteServiceAccount(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::UndeleteServiceAccountRequest* /*request*/, ::google::iam::admin::v1::UndeleteServiceAccountResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedUndeleteServiceAccount(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::iam::admin::v1::UndeleteServiceAccountRequest,::google::iam::admin::v1::UndeleteServiceAccountResponse>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_EnableServiceAccount : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_EnableServiceAccount() {
      ::grpc::Service::MarkMethodStreamed(7,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::iam::admin::v1::EnableServiceAccountRequest, ::google::protobuf::Empty>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::iam::admin::v1::EnableServiceAccountRequest, ::google::protobuf::Empty>* streamer) {
                       return this->StreamedEnableServiceAccount(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_EnableServiceAccount() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status EnableServiceAccount(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::EnableServiceAccountRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedEnableServiceAccount(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::iam::admin::v1::EnableServiceAccountRequest,::google::protobuf::Empty>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_DisableServiceAccount : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_DisableServiceAccount() {
      ::grpc::Service::MarkMethodStreamed(8,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::iam::admin::v1::DisableServiceAccountRequest, ::google::protobuf::Empty>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::iam::admin::v1::DisableServiceAccountRequest, ::google::protobuf::Empty>* streamer) {
                       return this->StreamedDisableServiceAccount(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_DisableServiceAccount() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status DisableServiceAccount(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::DisableServiceAccountRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedDisableServiceAccount(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::iam::admin::v1::DisableServiceAccountRequest,::google::protobuf::Empty>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_ListServiceAccountKeys : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_ListServiceAccountKeys() {
      ::grpc::Service::MarkMethodStreamed(9,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::iam::admin::v1::ListServiceAccountKeysRequest, ::google::iam::admin::v1::ListServiceAccountKeysResponse>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::iam::admin::v1::ListServiceAccountKeysRequest, ::google::iam::admin::v1::ListServiceAccountKeysResponse>* streamer) {
                       return this->StreamedListServiceAccountKeys(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_ListServiceAccountKeys() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status ListServiceAccountKeys(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::ListServiceAccountKeysRequest* /*request*/, ::google::iam::admin::v1::ListServiceAccountKeysResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedListServiceAccountKeys(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::iam::admin::v1::ListServiceAccountKeysRequest,::google::iam::admin::v1::ListServiceAccountKeysResponse>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_GetServiceAccountKey : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_GetServiceAccountKey() {
      ::grpc::Service::MarkMethodStreamed(10,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::iam::admin::v1::GetServiceAccountKeyRequest, ::google::iam::admin::v1::ServiceAccountKey>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::iam::admin::v1::GetServiceAccountKeyRequest, ::google::iam::admin::v1::ServiceAccountKey>* streamer) {
                       return this->StreamedGetServiceAccountKey(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_GetServiceAccountKey() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status GetServiceAccountKey(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::GetServiceAccountKeyRequest* /*request*/, ::google::iam::admin::v1::ServiceAccountKey* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedGetServiceAccountKey(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::iam::admin::v1::GetServiceAccountKeyRequest,::google::iam::admin::v1::ServiceAccountKey>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_CreateServiceAccountKey : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_CreateServiceAccountKey() {
      ::grpc::Service::MarkMethodStreamed(11,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::iam::admin::v1::CreateServiceAccountKeyRequest, ::google::iam::admin::v1::ServiceAccountKey>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::iam::admin::v1::CreateServiceAccountKeyRequest, ::google::iam::admin::v1::ServiceAccountKey>* streamer) {
                       return this->StreamedCreateServiceAccountKey(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_CreateServiceAccountKey() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status CreateServiceAccountKey(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::CreateServiceAccountKeyRequest* /*request*/, ::google::iam::admin::v1::ServiceAccountKey* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedCreateServiceAccountKey(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::iam::admin::v1::CreateServiceAccountKeyRequest,::google::iam::admin::v1::ServiceAccountKey>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_UploadServiceAccountKey : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_UploadServiceAccountKey() {
      ::grpc::Service::MarkMethodStreamed(12,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::iam::admin::v1::UploadServiceAccountKeyRequest, ::google::iam::admin::v1::ServiceAccountKey>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::iam::admin::v1::UploadServiceAccountKeyRequest, ::google::iam::admin::v1::ServiceAccountKey>* streamer) {
                       return this->StreamedUploadServiceAccountKey(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_UploadServiceAccountKey() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status UploadServiceAccountKey(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::UploadServiceAccountKeyRequest* /*request*/, ::google::iam::admin::v1::ServiceAccountKey* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedUploadServiceAccountKey(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::iam::admin::v1::UploadServiceAccountKeyRequest,::google::iam::admin::v1::ServiceAccountKey>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_DeleteServiceAccountKey : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_DeleteServiceAccountKey() {
      ::grpc::Service::MarkMethodStreamed(13,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::iam::admin::v1::DeleteServiceAccountKeyRequest, ::google::protobuf::Empty>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::iam::admin::v1::DeleteServiceAccountKeyRequest, ::google::protobuf::Empty>* streamer) {
                       return this->StreamedDeleteServiceAccountKey(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_DeleteServiceAccountKey() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status DeleteServiceAccountKey(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::DeleteServiceAccountKeyRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedDeleteServiceAccountKey(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::iam::admin::v1::DeleteServiceAccountKeyRequest,::google::protobuf::Empty>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_SignBlob : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_SignBlob() {
      ::grpc::Service::MarkMethodStreamed(14,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::iam::admin::v1::SignBlobRequest, ::google::iam::admin::v1::SignBlobResponse>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::iam::admin::v1::SignBlobRequest, ::google::iam::admin::v1::SignBlobResponse>* streamer) {
                       return this->StreamedSignBlob(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_SignBlob() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status SignBlob(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::SignBlobRequest* /*request*/, ::google::iam::admin::v1::SignBlobResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedSignBlob(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::iam::admin::v1::SignBlobRequest,::google::iam::admin::v1::SignBlobResponse>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_SignJwt : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_SignJwt() {
      ::grpc::Service::MarkMethodStreamed(15,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::iam::admin::v1::SignJwtRequest, ::google::iam::admin::v1::SignJwtResponse>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::iam::admin::v1::SignJwtRequest, ::google::iam::admin::v1::SignJwtResponse>* streamer) {
                       return this->StreamedSignJwt(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_SignJwt() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status SignJwt(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::SignJwtRequest* /*request*/, ::google::iam::admin::v1::SignJwtResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedSignJwt(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::iam::admin::v1::SignJwtRequest,::google::iam::admin::v1::SignJwtResponse>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_GetIamPolicy : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_GetIamPolicy() {
      ::grpc::Service::MarkMethodStreamed(16,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::iam::v1::GetIamPolicyRequest, ::google::iam::v1::Policy>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::iam::v1::GetIamPolicyRequest, ::google::iam::v1::Policy>* streamer) {
                       return this->StreamedGetIamPolicy(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_GetIamPolicy() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status GetIamPolicy(::grpc::ServerContext* /*context*/, const ::google::iam::v1::GetIamPolicyRequest* /*request*/, ::google::iam::v1::Policy* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedGetIamPolicy(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::iam::v1::GetIamPolicyRequest,::google::iam::v1::Policy>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_SetIamPolicy : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_SetIamPolicy() {
      ::grpc::Service::MarkMethodStreamed(17,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::iam::v1::SetIamPolicyRequest, ::google::iam::v1::Policy>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::iam::v1::SetIamPolicyRequest, ::google::iam::v1::Policy>* streamer) {
                       return this->StreamedSetIamPolicy(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_SetIamPolicy() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status SetIamPolicy(::grpc::ServerContext* /*context*/, const ::google::iam::v1::SetIamPolicyRequest* /*request*/, ::google::iam::v1::Policy* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedSetIamPolicy(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::iam::v1::SetIamPolicyRequest,::google::iam::v1::Policy>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_TestIamPermissions : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_TestIamPermissions() {
      ::grpc::Service::MarkMethodStreamed(18,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::iam::v1::TestIamPermissionsRequest, ::google::iam::v1::TestIamPermissionsResponse>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::iam::v1::TestIamPermissionsRequest, ::google::iam::v1::TestIamPermissionsResponse>* streamer) {
                       return this->StreamedTestIamPermissions(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_TestIamPermissions() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status TestIamPermissions(::grpc::ServerContext* /*context*/, const ::google::iam::v1::TestIamPermissionsRequest* /*request*/, ::google::iam::v1::TestIamPermissionsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedTestIamPermissions(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::iam::v1::TestIamPermissionsRequest,::google::iam::v1::TestIamPermissionsResponse>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_QueryGrantableRoles : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_QueryGrantableRoles() {
      ::grpc::Service::MarkMethodStreamed(19,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::iam::admin::v1::QueryGrantableRolesRequest, ::google::iam::admin::v1::QueryGrantableRolesResponse>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::iam::admin::v1::QueryGrantableRolesRequest, ::google::iam::admin::v1::QueryGrantableRolesResponse>* streamer) {
                       return this->StreamedQueryGrantableRoles(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_QueryGrantableRoles() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status QueryGrantableRoles(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::QueryGrantableRolesRequest* /*request*/, ::google::iam::admin::v1::QueryGrantableRolesResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedQueryGrantableRoles(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::iam::admin::v1::QueryGrantableRolesRequest,::google::iam::admin::v1::QueryGrantableRolesResponse>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_ListRoles : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_ListRoles() {
      ::grpc::Service::MarkMethodStreamed(20,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::iam::admin::v1::ListRolesRequest, ::google::iam::admin::v1::ListRolesResponse>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::iam::admin::v1::ListRolesRequest, ::google::iam::admin::v1::ListRolesResponse>* streamer) {
                       return this->StreamedListRoles(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_ListRoles() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status ListRoles(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::ListRolesRequest* /*request*/, ::google::iam::admin::v1::ListRolesResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedListRoles(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::iam::admin::v1::ListRolesRequest,::google::iam::admin::v1::ListRolesResponse>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_GetRole : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_GetRole() {
      ::grpc::Service::MarkMethodStreamed(21,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::iam::admin::v1::GetRoleRequest, ::google::iam::admin::v1::Role>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::iam::admin::v1::GetRoleRequest, ::google::iam::admin::v1::Role>* streamer) {
                       return this->StreamedGetRole(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_GetRole() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status GetRole(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::GetRoleRequest* /*request*/, ::google::iam::admin::v1::Role* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedGetRole(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::iam::admin::v1::GetRoleRequest,::google::iam::admin::v1::Role>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_CreateRole : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_CreateRole() {
      ::grpc::Service::MarkMethodStreamed(22,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::iam::admin::v1::CreateRoleRequest, ::google::iam::admin::v1::Role>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::iam::admin::v1::CreateRoleRequest, ::google::iam::admin::v1::Role>* streamer) {
                       return this->StreamedCreateRole(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_CreateRole() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status CreateRole(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::CreateRoleRequest* /*request*/, ::google::iam::admin::v1::Role* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedCreateRole(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::iam::admin::v1::CreateRoleRequest,::google::iam::admin::v1::Role>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_UpdateRole : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_UpdateRole() {
      ::grpc::Service::MarkMethodStreamed(23,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::iam::admin::v1::UpdateRoleRequest, ::google::iam::admin::v1::Role>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::iam::admin::v1::UpdateRoleRequest, ::google::iam::admin::v1::Role>* streamer) {
                       return this->StreamedUpdateRole(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_UpdateRole() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status UpdateRole(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::UpdateRoleRequest* /*request*/, ::google::iam::admin::v1::Role* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedUpdateRole(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::iam::admin::v1::UpdateRoleRequest,::google::iam::admin::v1::Role>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_DeleteRole : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_DeleteRole() {
      ::grpc::Service::MarkMethodStreamed(24,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::iam::admin::v1::DeleteRoleRequest, ::google::iam::admin::v1::Role>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::iam::admin::v1::DeleteRoleRequest, ::google::iam::admin::v1::Role>* streamer) {
                       return this->StreamedDeleteRole(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_DeleteRole() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status DeleteRole(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::DeleteRoleRequest* /*request*/, ::google::iam::admin::v1::Role* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedDeleteRole(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::iam::admin::v1::DeleteRoleRequest,::google::iam::admin::v1::Role>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_UndeleteRole : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_UndeleteRole() {
      ::grpc::Service::MarkMethodStreamed(25,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::iam::admin::v1::UndeleteRoleRequest, ::google::iam::admin::v1::Role>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::iam::admin::v1::UndeleteRoleRequest, ::google::iam::admin::v1::Role>* streamer) {
                       return this->StreamedUndeleteRole(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_UndeleteRole() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status UndeleteRole(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::UndeleteRoleRequest* /*request*/, ::google::iam::admin::v1::Role* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedUndeleteRole(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::iam::admin::v1::UndeleteRoleRequest,::google::iam::admin::v1::Role>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_QueryTestablePermissions : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_QueryTestablePermissions() {
      ::grpc::Service::MarkMethodStreamed(26,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::iam::admin::v1::QueryTestablePermissionsRequest, ::google::iam::admin::v1::QueryTestablePermissionsResponse>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::iam::admin::v1::QueryTestablePermissionsRequest, ::google::iam::admin::v1::QueryTestablePermissionsResponse>* streamer) {
                       return this->StreamedQueryTestablePermissions(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_QueryTestablePermissions() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status QueryTestablePermissions(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::QueryTestablePermissionsRequest* /*request*/, ::google::iam::admin::v1::QueryTestablePermissionsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedQueryTestablePermissions(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::iam::admin::v1::QueryTestablePermissionsRequest,::google::iam::admin::v1::QueryTestablePermissionsResponse>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_QueryAuditableServices : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_QueryAuditableServices() {
      ::grpc::Service::MarkMethodStreamed(27,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::iam::admin::v1::QueryAuditableServicesRequest, ::google::iam::admin::v1::QueryAuditableServicesResponse>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::iam::admin::v1::QueryAuditableServicesRequest, ::google::iam::admin::v1::QueryAuditableServicesResponse>* streamer) {
                       return this->StreamedQueryAuditableServices(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_QueryAuditableServices() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status QueryAuditableServices(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::QueryAuditableServicesRequest* /*request*/, ::google::iam::admin::v1::QueryAuditableServicesResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedQueryAuditableServices(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::iam::admin::v1::QueryAuditableServicesRequest,::google::iam::admin::v1::QueryAuditableServicesResponse>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_LintPolicy : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_LintPolicy() {
      ::grpc::Service::MarkMethodStreamed(28,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::iam::admin::v1::LintPolicyRequest, ::google::iam::admin::v1::LintPolicyResponse>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::iam::admin::v1::LintPolicyRequest, ::google::iam::admin::v1::LintPolicyResponse>* streamer) {
                       return this->StreamedLintPolicy(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_LintPolicy() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status LintPolicy(::grpc::ServerContext* /*context*/, const ::google::iam::admin::v1::LintPolicyRequest* /*request*/, ::google::iam::admin::v1::LintPolicyResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedLintPolicy(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::iam::admin::v1::LintPolicyRequest,::google::iam::admin::v1::LintPolicyResponse>* server_unary_streamer) = 0;
  };
  typedef WithStreamedUnaryMethod_ListServiceAccounts<WithStreamedUnaryMethod_GetServiceAccount<WithStreamedUnaryMethod_CreateServiceAccount<WithStreamedUnaryMethod_UpdateServiceAccount<WithStreamedUnaryMethod_PatchServiceAccount<WithStreamedUnaryMethod_DeleteServiceAccount<WithStreamedUnaryMethod_UndeleteServiceAccount<WithStreamedUnaryMethod_EnableServiceAccount<WithStreamedUnaryMethod_DisableServiceAccount<WithStreamedUnaryMethod_ListServiceAccountKeys<WithStreamedUnaryMethod_GetServiceAccountKey<WithStreamedUnaryMethod_CreateServiceAccountKey<WithStreamedUnaryMethod_UploadServiceAccountKey<WithStreamedUnaryMethod_DeleteServiceAccountKey<WithStreamedUnaryMethod_SignBlob<WithStreamedUnaryMethod_SignJwt<WithStreamedUnaryMethod_GetIamPolicy<WithStreamedUnaryMethod_SetIamPolicy<WithStreamedUnaryMethod_TestIamPermissions<WithStreamedUnaryMethod_QueryGrantableRoles<WithStreamedUnaryMethod_ListRoles<WithStreamedUnaryMethod_GetRole<WithStreamedUnaryMethod_CreateRole<WithStreamedUnaryMethod_UpdateRole<WithStreamedUnaryMethod_DeleteRole<WithStreamedUnaryMethod_UndeleteRole<WithStreamedUnaryMethod_QueryTestablePermissions<WithStreamedUnaryMethod_QueryAuditableServices<WithStreamedUnaryMethod_LintPolicy<Service > > > > > > > > > > > > > > > > > > > > > > > > > > > > > StreamedUnaryService;
  typedef Service SplitStreamedService;
  typedef WithStreamedUnaryMethod_ListServiceAccounts<WithStreamedUnaryMethod_GetServiceAccount<WithStreamedUnaryMethod_CreateServiceAccount<WithStreamedUnaryMethod_UpdateServiceAccount<WithStreamedUnaryMethod_PatchServiceAccount<WithStreamedUnaryMethod_DeleteServiceAccount<WithStreamedUnaryMethod_UndeleteServiceAccount<WithStreamedUnaryMethod_EnableServiceAccount<WithStreamedUnaryMethod_DisableServiceAccount<WithStreamedUnaryMethod_ListServiceAccountKeys<WithStreamedUnaryMethod_GetServiceAccountKey<WithStreamedUnaryMethod_CreateServiceAccountKey<WithStreamedUnaryMethod_UploadServiceAccountKey<WithStreamedUnaryMethod_DeleteServiceAccountKey<WithStreamedUnaryMethod_SignBlob<WithStreamedUnaryMethod_SignJwt<WithStreamedUnaryMethod_GetIamPolicy<WithStreamedUnaryMethod_SetIamPolicy<WithStreamedUnaryMethod_TestIamPermissions<WithStreamedUnaryMethod_QueryGrantableRoles<WithStreamedUnaryMethod_ListRoles<WithStreamedUnaryMethod_GetRole<WithStreamedUnaryMethod_CreateRole<WithStreamedUnaryMethod_UpdateRole<WithStreamedUnaryMethod_DeleteRole<WithStreamedUnaryMethod_UndeleteRole<WithStreamedUnaryMethod_QueryTestablePermissions<WithStreamedUnaryMethod_QueryAuditableServices<WithStreamedUnaryMethod_LintPolicy<Service > > > > > > > > > > > > > > > > > > > > > > > > > > > > > StreamedService;
};

}  // namespace v1
}  // namespace admin
}  // namespace iam
}  // namespace google


#endif  // GRPC_google_2fiam_2fadmin_2fv1_2fiam_2eproto__INCLUDED
