// Generated by the gRPC C++ plugin.
// If you make any local change, they will be lost.
// source: google/pubsub/v1/pubsub.proto
// Original file comments:
// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
#ifndef GRPC_google_2fpubsub_2fv1_2fpubsub_2eproto__INCLUDED
#define GRPC_google_2fpubsub_2fv1_2fpubsub_2eproto__INCLUDED

#include "google/pubsub/v1/pubsub.pb.h"

#include <functional>
#include <grpcpp/impl/codegen/async_generic_service.h>
#include <grpcpp/impl/codegen/async_stream.h>
#include <grpcpp/impl/codegen/async_unary_call.h>
#include <grpcpp/impl/codegen/client_callback.h>
#include <grpcpp/impl/codegen/client_context.h>
#include <grpcpp/impl/codegen/completion_queue.h>
#include <grpcpp/impl/codegen/message_allocator.h>
#include <grpcpp/impl/codegen/method_handler.h>
#include <grpcpp/impl/codegen/proto_utils.h>
#include <grpcpp/impl/codegen/rpc_method.h>
#include <grpcpp/impl/codegen/server_callback.h>
#include <grpcpp/impl/codegen/server_callback_handlers.h>
#include <grpcpp/impl/codegen/server_context.h>
#include <grpcpp/impl/codegen/service_type.h>
#include <grpcpp/impl/codegen/status.h>
#include <grpcpp/impl/codegen/stub_options.h>
#include <grpcpp/impl/codegen/sync_stream.h>

namespace google {
namespace pubsub {
namespace v1 {

// The service that an application uses to manipulate topics, and to send
// messages to a topic.
class Publisher final {
 public:
  static constexpr char const* service_full_name() {
    return "google.pubsub.v1.Publisher";
  }
  class StubInterface {
   public:
    virtual ~StubInterface() {}
    // Creates the given topic with the given name. See the [resource name rules]
    // (https://cloud.google.com/pubsub/docs/admin#resource_names).
    virtual ::grpc::Status CreateTopic(::grpc::ClientContext* context, const ::google::pubsub::v1::Topic& request, ::google::pubsub::v1::Topic* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::Topic>> AsyncCreateTopic(::grpc::ClientContext* context, const ::google::pubsub::v1::Topic& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::Topic>>(AsyncCreateTopicRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::Topic>> PrepareAsyncCreateTopic(::grpc::ClientContext* context, const ::google::pubsub::v1::Topic& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::Topic>>(PrepareAsyncCreateTopicRaw(context, request, cq));
    }
    // Updates an existing topic. Note that certain properties of a
    // topic are not modifiable.
    virtual ::grpc::Status UpdateTopic(::grpc::ClientContext* context, const ::google::pubsub::v1::UpdateTopicRequest& request, ::google::pubsub::v1::Topic* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::Topic>> AsyncUpdateTopic(::grpc::ClientContext* context, const ::google::pubsub::v1::UpdateTopicRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::Topic>>(AsyncUpdateTopicRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::Topic>> PrepareAsyncUpdateTopic(::grpc::ClientContext* context, const ::google::pubsub::v1::UpdateTopicRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::Topic>>(PrepareAsyncUpdateTopicRaw(context, request, cq));
    }
    // Adds one or more messages to the topic. Returns `NOT_FOUND` if the topic
    // does not exist.
    virtual ::grpc::Status Publish(::grpc::ClientContext* context, const ::google::pubsub::v1::PublishRequest& request, ::google::pubsub::v1::PublishResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::PublishResponse>> AsyncPublish(::grpc::ClientContext* context, const ::google::pubsub::v1::PublishRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::PublishResponse>>(AsyncPublishRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::PublishResponse>> PrepareAsyncPublish(::grpc::ClientContext* context, const ::google::pubsub::v1::PublishRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::PublishResponse>>(PrepareAsyncPublishRaw(context, request, cq));
    }
    // Gets the configuration of a topic.
    virtual ::grpc::Status GetTopic(::grpc::ClientContext* context, const ::google::pubsub::v1::GetTopicRequest& request, ::google::pubsub::v1::Topic* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::Topic>> AsyncGetTopic(::grpc::ClientContext* context, const ::google::pubsub::v1::GetTopicRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::Topic>>(AsyncGetTopicRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::Topic>> PrepareAsyncGetTopic(::grpc::ClientContext* context, const ::google::pubsub::v1::GetTopicRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::Topic>>(PrepareAsyncGetTopicRaw(context, request, cq));
    }
    // Lists matching topics.
    virtual ::grpc::Status ListTopics(::grpc::ClientContext* context, const ::google::pubsub::v1::ListTopicsRequest& request, ::google::pubsub::v1::ListTopicsResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::ListTopicsResponse>> AsyncListTopics(::grpc::ClientContext* context, const ::google::pubsub::v1::ListTopicsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::ListTopicsResponse>>(AsyncListTopicsRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::ListTopicsResponse>> PrepareAsyncListTopics(::grpc::ClientContext* context, const ::google::pubsub::v1::ListTopicsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::ListTopicsResponse>>(PrepareAsyncListTopicsRaw(context, request, cq));
    }
    // Lists the names of the attached subscriptions on this topic.
    virtual ::grpc::Status ListTopicSubscriptions(::grpc::ClientContext* context, const ::google::pubsub::v1::ListTopicSubscriptionsRequest& request, ::google::pubsub::v1::ListTopicSubscriptionsResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::ListTopicSubscriptionsResponse>> AsyncListTopicSubscriptions(::grpc::ClientContext* context, const ::google::pubsub::v1::ListTopicSubscriptionsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::ListTopicSubscriptionsResponse>>(AsyncListTopicSubscriptionsRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::ListTopicSubscriptionsResponse>> PrepareAsyncListTopicSubscriptions(::grpc::ClientContext* context, const ::google::pubsub::v1::ListTopicSubscriptionsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::ListTopicSubscriptionsResponse>>(PrepareAsyncListTopicSubscriptionsRaw(context, request, cq));
    }
    // Lists the names of the snapshots on this topic. Snapshots are used in
    // [Seek](https://cloud.google.com/pubsub/docs/replay-overview) operations,
    // which allow you to manage message acknowledgments in bulk. That is, you can
    // set the acknowledgment state of messages in an existing subscription to the
    // state captured by a snapshot.
    virtual ::grpc::Status ListTopicSnapshots(::grpc::ClientContext* context, const ::google::pubsub::v1::ListTopicSnapshotsRequest& request, ::google::pubsub::v1::ListTopicSnapshotsResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::ListTopicSnapshotsResponse>> AsyncListTopicSnapshots(::grpc::ClientContext* context, const ::google::pubsub::v1::ListTopicSnapshotsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::ListTopicSnapshotsResponse>>(AsyncListTopicSnapshotsRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::ListTopicSnapshotsResponse>> PrepareAsyncListTopicSnapshots(::grpc::ClientContext* context, const ::google::pubsub::v1::ListTopicSnapshotsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::ListTopicSnapshotsResponse>>(PrepareAsyncListTopicSnapshotsRaw(context, request, cq));
    }
    // Deletes the topic with the given name. Returns `NOT_FOUND` if the topic
    // does not exist. After a topic is deleted, a new topic may be created with
    // the same name; this is an entirely new topic with none of the old
    // configuration or subscriptions. Existing subscriptions to this topic are
    // not deleted, but their `topic` field is set to `_deleted-topic_`.
    virtual ::grpc::Status DeleteTopic(::grpc::ClientContext* context, const ::google::pubsub::v1::DeleteTopicRequest& request, ::google::protobuf::Empty* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>> AsyncDeleteTopic(::grpc::ClientContext* context, const ::google::pubsub::v1::DeleteTopicRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>>(AsyncDeleteTopicRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>> PrepareAsyncDeleteTopic(::grpc::ClientContext* context, const ::google::pubsub::v1::DeleteTopicRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>>(PrepareAsyncDeleteTopicRaw(context, request, cq));
    }
    // Detaches a subscription from this topic. All messages retained in the
    // subscription are dropped. Subsequent `Pull` and `StreamingPull` requests
    // will return FAILED_PRECONDITION. If the subscription is a push
    // subscription, pushes to the endpoint will stop.
    virtual ::grpc::Status DetachSubscription(::grpc::ClientContext* context, const ::google::pubsub::v1::DetachSubscriptionRequest& request, ::google::pubsub::v1::DetachSubscriptionResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::DetachSubscriptionResponse>> AsyncDetachSubscription(::grpc::ClientContext* context, const ::google::pubsub::v1::DetachSubscriptionRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::DetachSubscriptionResponse>>(AsyncDetachSubscriptionRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::DetachSubscriptionResponse>> PrepareAsyncDetachSubscription(::grpc::ClientContext* context, const ::google::pubsub::v1::DetachSubscriptionRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::DetachSubscriptionResponse>>(PrepareAsyncDetachSubscriptionRaw(context, request, cq));
    }
    class async_interface {
     public:
      virtual ~async_interface() {}
      // Creates the given topic with the given name. See the [resource name rules]
      // (https://cloud.google.com/pubsub/docs/admin#resource_names).
      virtual void CreateTopic(::grpc::ClientContext* context, const ::google::pubsub::v1::Topic* request, ::google::pubsub::v1::Topic* response, std::function<void(::grpc::Status)>) = 0;
      virtual void CreateTopic(::grpc::ClientContext* context, const ::google::pubsub::v1::Topic* request, ::google::pubsub::v1::Topic* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Updates an existing topic. Note that certain properties of a
      // topic are not modifiable.
      virtual void UpdateTopic(::grpc::ClientContext* context, const ::google::pubsub::v1::UpdateTopicRequest* request, ::google::pubsub::v1::Topic* response, std::function<void(::grpc::Status)>) = 0;
      virtual void UpdateTopic(::grpc::ClientContext* context, const ::google::pubsub::v1::UpdateTopicRequest* request, ::google::pubsub::v1::Topic* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Adds one or more messages to the topic. Returns `NOT_FOUND` if the topic
      // does not exist.
      virtual void Publish(::grpc::ClientContext* context, const ::google::pubsub::v1::PublishRequest* request, ::google::pubsub::v1::PublishResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void Publish(::grpc::ClientContext* context, const ::google::pubsub::v1::PublishRequest* request, ::google::pubsub::v1::PublishResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Gets the configuration of a topic.
      virtual void GetTopic(::grpc::ClientContext* context, const ::google::pubsub::v1::GetTopicRequest* request, ::google::pubsub::v1::Topic* response, std::function<void(::grpc::Status)>) = 0;
      virtual void GetTopic(::grpc::ClientContext* context, const ::google::pubsub::v1::GetTopicRequest* request, ::google::pubsub::v1::Topic* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Lists matching topics.
      virtual void ListTopics(::grpc::ClientContext* context, const ::google::pubsub::v1::ListTopicsRequest* request, ::google::pubsub::v1::ListTopicsResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void ListTopics(::grpc::ClientContext* context, const ::google::pubsub::v1::ListTopicsRequest* request, ::google::pubsub::v1::ListTopicsResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Lists the names of the attached subscriptions on this topic.
      virtual void ListTopicSubscriptions(::grpc::ClientContext* context, const ::google::pubsub::v1::ListTopicSubscriptionsRequest* request, ::google::pubsub::v1::ListTopicSubscriptionsResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void ListTopicSubscriptions(::grpc::ClientContext* context, const ::google::pubsub::v1::ListTopicSubscriptionsRequest* request, ::google::pubsub::v1::ListTopicSubscriptionsResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Lists the names of the snapshots on this topic. Snapshots are used in
      // [Seek](https://cloud.google.com/pubsub/docs/replay-overview) operations,
      // which allow you to manage message acknowledgments in bulk. That is, you can
      // set the acknowledgment state of messages in an existing subscription to the
      // state captured by a snapshot.
      virtual void ListTopicSnapshots(::grpc::ClientContext* context, const ::google::pubsub::v1::ListTopicSnapshotsRequest* request, ::google::pubsub::v1::ListTopicSnapshotsResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void ListTopicSnapshots(::grpc::ClientContext* context, const ::google::pubsub::v1::ListTopicSnapshotsRequest* request, ::google::pubsub::v1::ListTopicSnapshotsResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Deletes the topic with the given name. Returns `NOT_FOUND` if the topic
      // does not exist. After a topic is deleted, a new topic may be created with
      // the same name; this is an entirely new topic with none of the old
      // configuration or subscriptions. Existing subscriptions to this topic are
      // not deleted, but their `topic` field is set to `_deleted-topic_`.
      virtual void DeleteTopic(::grpc::ClientContext* context, const ::google::pubsub::v1::DeleteTopicRequest* request, ::google::protobuf::Empty* response, std::function<void(::grpc::Status)>) = 0;
      virtual void DeleteTopic(::grpc::ClientContext* context, const ::google::pubsub::v1::DeleteTopicRequest* request, ::google::protobuf::Empty* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Detaches a subscription from this topic. All messages retained in the
      // subscription are dropped. Subsequent `Pull` and `StreamingPull` requests
      // will return FAILED_PRECONDITION. If the subscription is a push
      // subscription, pushes to the endpoint will stop.
      virtual void DetachSubscription(::grpc::ClientContext* context, const ::google::pubsub::v1::DetachSubscriptionRequest* request, ::google::pubsub::v1::DetachSubscriptionResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void DetachSubscription(::grpc::ClientContext* context, const ::google::pubsub::v1::DetachSubscriptionRequest* request, ::google::pubsub::v1::DetachSubscriptionResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
    };
    typedef class async_interface experimental_async_interface;
    virtual class async_interface* async() { return nullptr; }
    class async_interface* experimental_async() { return async(); }
   private:
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::Topic>* AsyncCreateTopicRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::Topic& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::Topic>* PrepareAsyncCreateTopicRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::Topic& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::Topic>* AsyncUpdateTopicRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::UpdateTopicRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::Topic>* PrepareAsyncUpdateTopicRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::UpdateTopicRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::PublishResponse>* AsyncPublishRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::PublishRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::PublishResponse>* PrepareAsyncPublishRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::PublishRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::Topic>* AsyncGetTopicRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::GetTopicRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::Topic>* PrepareAsyncGetTopicRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::GetTopicRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::ListTopicsResponse>* AsyncListTopicsRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::ListTopicsRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::ListTopicsResponse>* PrepareAsyncListTopicsRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::ListTopicsRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::ListTopicSubscriptionsResponse>* AsyncListTopicSubscriptionsRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::ListTopicSubscriptionsRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::ListTopicSubscriptionsResponse>* PrepareAsyncListTopicSubscriptionsRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::ListTopicSubscriptionsRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::ListTopicSnapshotsResponse>* AsyncListTopicSnapshotsRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::ListTopicSnapshotsRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::ListTopicSnapshotsResponse>* PrepareAsyncListTopicSnapshotsRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::ListTopicSnapshotsRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>* AsyncDeleteTopicRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::DeleteTopicRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>* PrepareAsyncDeleteTopicRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::DeleteTopicRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::DetachSubscriptionResponse>* AsyncDetachSubscriptionRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::DetachSubscriptionRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::DetachSubscriptionResponse>* PrepareAsyncDetachSubscriptionRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::DetachSubscriptionRequest& request, ::grpc::CompletionQueue* cq) = 0;
  };
  class Stub final : public StubInterface {
   public:
    Stub(const std::shared_ptr< ::grpc::ChannelInterface>& channel, const ::grpc::StubOptions& options = ::grpc::StubOptions());
    ::grpc::Status CreateTopic(::grpc::ClientContext* context, const ::google::pubsub::v1::Topic& request, ::google::pubsub::v1::Topic* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::Topic>> AsyncCreateTopic(::grpc::ClientContext* context, const ::google::pubsub::v1::Topic& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::Topic>>(AsyncCreateTopicRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::Topic>> PrepareAsyncCreateTopic(::grpc::ClientContext* context, const ::google::pubsub::v1::Topic& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::Topic>>(PrepareAsyncCreateTopicRaw(context, request, cq));
    }
    ::grpc::Status UpdateTopic(::grpc::ClientContext* context, const ::google::pubsub::v1::UpdateTopicRequest& request, ::google::pubsub::v1::Topic* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::Topic>> AsyncUpdateTopic(::grpc::ClientContext* context, const ::google::pubsub::v1::UpdateTopicRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::Topic>>(AsyncUpdateTopicRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::Topic>> PrepareAsyncUpdateTopic(::grpc::ClientContext* context, const ::google::pubsub::v1::UpdateTopicRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::Topic>>(PrepareAsyncUpdateTopicRaw(context, request, cq));
    }
    ::grpc::Status Publish(::grpc::ClientContext* context, const ::google::pubsub::v1::PublishRequest& request, ::google::pubsub::v1::PublishResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::PublishResponse>> AsyncPublish(::grpc::ClientContext* context, const ::google::pubsub::v1::PublishRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::PublishResponse>>(AsyncPublishRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::PublishResponse>> PrepareAsyncPublish(::grpc::ClientContext* context, const ::google::pubsub::v1::PublishRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::PublishResponse>>(PrepareAsyncPublishRaw(context, request, cq));
    }
    ::grpc::Status GetTopic(::grpc::ClientContext* context, const ::google::pubsub::v1::GetTopicRequest& request, ::google::pubsub::v1::Topic* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::Topic>> AsyncGetTopic(::grpc::ClientContext* context, const ::google::pubsub::v1::GetTopicRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::Topic>>(AsyncGetTopicRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::Topic>> PrepareAsyncGetTopic(::grpc::ClientContext* context, const ::google::pubsub::v1::GetTopicRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::Topic>>(PrepareAsyncGetTopicRaw(context, request, cq));
    }
    ::grpc::Status ListTopics(::grpc::ClientContext* context, const ::google::pubsub::v1::ListTopicsRequest& request, ::google::pubsub::v1::ListTopicsResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::ListTopicsResponse>> AsyncListTopics(::grpc::ClientContext* context, const ::google::pubsub::v1::ListTopicsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::ListTopicsResponse>>(AsyncListTopicsRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::ListTopicsResponse>> PrepareAsyncListTopics(::grpc::ClientContext* context, const ::google::pubsub::v1::ListTopicsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::ListTopicsResponse>>(PrepareAsyncListTopicsRaw(context, request, cq));
    }
    ::grpc::Status ListTopicSubscriptions(::grpc::ClientContext* context, const ::google::pubsub::v1::ListTopicSubscriptionsRequest& request, ::google::pubsub::v1::ListTopicSubscriptionsResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::ListTopicSubscriptionsResponse>> AsyncListTopicSubscriptions(::grpc::ClientContext* context, const ::google::pubsub::v1::ListTopicSubscriptionsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::ListTopicSubscriptionsResponse>>(AsyncListTopicSubscriptionsRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::ListTopicSubscriptionsResponse>> PrepareAsyncListTopicSubscriptions(::grpc::ClientContext* context, const ::google::pubsub::v1::ListTopicSubscriptionsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::ListTopicSubscriptionsResponse>>(PrepareAsyncListTopicSubscriptionsRaw(context, request, cq));
    }
    ::grpc::Status ListTopicSnapshots(::grpc::ClientContext* context, const ::google::pubsub::v1::ListTopicSnapshotsRequest& request, ::google::pubsub::v1::ListTopicSnapshotsResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::ListTopicSnapshotsResponse>> AsyncListTopicSnapshots(::grpc::ClientContext* context, const ::google::pubsub::v1::ListTopicSnapshotsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::ListTopicSnapshotsResponse>>(AsyncListTopicSnapshotsRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::ListTopicSnapshotsResponse>> PrepareAsyncListTopicSnapshots(::grpc::ClientContext* context, const ::google::pubsub::v1::ListTopicSnapshotsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::ListTopicSnapshotsResponse>>(PrepareAsyncListTopicSnapshotsRaw(context, request, cq));
    }
    ::grpc::Status DeleteTopic(::grpc::ClientContext* context, const ::google::pubsub::v1::DeleteTopicRequest& request, ::google::protobuf::Empty* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>> AsyncDeleteTopic(::grpc::ClientContext* context, const ::google::pubsub::v1::DeleteTopicRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>>(AsyncDeleteTopicRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>> PrepareAsyncDeleteTopic(::grpc::ClientContext* context, const ::google::pubsub::v1::DeleteTopicRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>>(PrepareAsyncDeleteTopicRaw(context, request, cq));
    }
    ::grpc::Status DetachSubscription(::grpc::ClientContext* context, const ::google::pubsub::v1::DetachSubscriptionRequest& request, ::google::pubsub::v1::DetachSubscriptionResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::DetachSubscriptionResponse>> AsyncDetachSubscription(::grpc::ClientContext* context, const ::google::pubsub::v1::DetachSubscriptionRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::DetachSubscriptionResponse>>(AsyncDetachSubscriptionRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::DetachSubscriptionResponse>> PrepareAsyncDetachSubscription(::grpc::ClientContext* context, const ::google::pubsub::v1::DetachSubscriptionRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::DetachSubscriptionResponse>>(PrepareAsyncDetachSubscriptionRaw(context, request, cq));
    }
    class async final :
      public StubInterface::async_interface {
     public:
      void CreateTopic(::grpc::ClientContext* context, const ::google::pubsub::v1::Topic* request, ::google::pubsub::v1::Topic* response, std::function<void(::grpc::Status)>) override;
      void CreateTopic(::grpc::ClientContext* context, const ::google::pubsub::v1::Topic* request, ::google::pubsub::v1::Topic* response, ::grpc::ClientUnaryReactor* reactor) override;
      void UpdateTopic(::grpc::ClientContext* context, const ::google::pubsub::v1::UpdateTopicRequest* request, ::google::pubsub::v1::Topic* response, std::function<void(::grpc::Status)>) override;
      void UpdateTopic(::grpc::ClientContext* context, const ::google::pubsub::v1::UpdateTopicRequest* request, ::google::pubsub::v1::Topic* response, ::grpc::ClientUnaryReactor* reactor) override;
      void Publish(::grpc::ClientContext* context, const ::google::pubsub::v1::PublishRequest* request, ::google::pubsub::v1::PublishResponse* response, std::function<void(::grpc::Status)>) override;
      void Publish(::grpc::ClientContext* context, const ::google::pubsub::v1::PublishRequest* request, ::google::pubsub::v1::PublishResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
      void GetTopic(::grpc::ClientContext* context, const ::google::pubsub::v1::GetTopicRequest* request, ::google::pubsub::v1::Topic* response, std::function<void(::grpc::Status)>) override;
      void GetTopic(::grpc::ClientContext* context, const ::google::pubsub::v1::GetTopicRequest* request, ::google::pubsub::v1::Topic* response, ::grpc::ClientUnaryReactor* reactor) override;
      void ListTopics(::grpc::ClientContext* context, const ::google::pubsub::v1::ListTopicsRequest* request, ::google::pubsub::v1::ListTopicsResponse* response, std::function<void(::grpc::Status)>) override;
      void ListTopics(::grpc::ClientContext* context, const ::google::pubsub::v1::ListTopicsRequest* request, ::google::pubsub::v1::ListTopicsResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
      void ListTopicSubscriptions(::grpc::ClientContext* context, const ::google::pubsub::v1::ListTopicSubscriptionsRequest* request, ::google::pubsub::v1::ListTopicSubscriptionsResponse* response, std::function<void(::grpc::Status)>) override;
      void ListTopicSubscriptions(::grpc::ClientContext* context, const ::google::pubsub::v1::ListTopicSubscriptionsRequest* request, ::google::pubsub::v1::ListTopicSubscriptionsResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
      void ListTopicSnapshots(::grpc::ClientContext* context, const ::google::pubsub::v1::ListTopicSnapshotsRequest* request, ::google::pubsub::v1::ListTopicSnapshotsResponse* response, std::function<void(::grpc::Status)>) override;
      void ListTopicSnapshots(::grpc::ClientContext* context, const ::google::pubsub::v1::ListTopicSnapshotsRequest* request, ::google::pubsub::v1::ListTopicSnapshotsResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
      void DeleteTopic(::grpc::ClientContext* context, const ::google::pubsub::v1::DeleteTopicRequest* request, ::google::protobuf::Empty* response, std::function<void(::grpc::Status)>) override;
      void DeleteTopic(::grpc::ClientContext* context, const ::google::pubsub::v1::DeleteTopicRequest* request, ::google::protobuf::Empty* response, ::grpc::ClientUnaryReactor* reactor) override;
      void DetachSubscription(::grpc::ClientContext* context, const ::google::pubsub::v1::DetachSubscriptionRequest* request, ::google::pubsub::v1::DetachSubscriptionResponse* response, std::function<void(::grpc::Status)>) override;
      void DetachSubscription(::grpc::ClientContext* context, const ::google::pubsub::v1::DetachSubscriptionRequest* request, ::google::pubsub::v1::DetachSubscriptionResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
     private:
      friend class Stub;
      explicit async(Stub* stub): stub_(stub) { }
      Stub* stub() { return stub_; }
      Stub* stub_;
    };
    class async* async() override { return &async_stub_; }

   private:
    std::shared_ptr< ::grpc::ChannelInterface> channel_;
    class async async_stub_{this};
    ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::Topic>* AsyncCreateTopicRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::Topic& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::Topic>* PrepareAsyncCreateTopicRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::Topic& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::Topic>* AsyncUpdateTopicRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::UpdateTopicRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::Topic>* PrepareAsyncUpdateTopicRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::UpdateTopicRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::PublishResponse>* AsyncPublishRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::PublishRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::PublishResponse>* PrepareAsyncPublishRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::PublishRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::Topic>* AsyncGetTopicRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::GetTopicRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::Topic>* PrepareAsyncGetTopicRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::GetTopicRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::ListTopicsResponse>* AsyncListTopicsRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::ListTopicsRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::ListTopicsResponse>* PrepareAsyncListTopicsRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::ListTopicsRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::ListTopicSubscriptionsResponse>* AsyncListTopicSubscriptionsRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::ListTopicSubscriptionsRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::ListTopicSubscriptionsResponse>* PrepareAsyncListTopicSubscriptionsRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::ListTopicSubscriptionsRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::ListTopicSnapshotsResponse>* AsyncListTopicSnapshotsRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::ListTopicSnapshotsRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::ListTopicSnapshotsResponse>* PrepareAsyncListTopicSnapshotsRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::ListTopicSnapshotsRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>* AsyncDeleteTopicRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::DeleteTopicRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>* PrepareAsyncDeleteTopicRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::DeleteTopicRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::DetachSubscriptionResponse>* AsyncDetachSubscriptionRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::DetachSubscriptionRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::DetachSubscriptionResponse>* PrepareAsyncDetachSubscriptionRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::DetachSubscriptionRequest& request, ::grpc::CompletionQueue* cq) override;
    const ::grpc::internal::RpcMethod rpcmethod_CreateTopic_;
    const ::grpc::internal::RpcMethod rpcmethod_UpdateTopic_;
    const ::grpc::internal::RpcMethod rpcmethod_Publish_;
    const ::grpc::internal::RpcMethod rpcmethod_GetTopic_;
    const ::grpc::internal::RpcMethod rpcmethod_ListTopics_;
    const ::grpc::internal::RpcMethod rpcmethod_ListTopicSubscriptions_;
    const ::grpc::internal::RpcMethod rpcmethod_ListTopicSnapshots_;
    const ::grpc::internal::RpcMethod rpcmethod_DeleteTopic_;
    const ::grpc::internal::RpcMethod rpcmethod_DetachSubscription_;
  };
  static std::unique_ptr<Stub> NewStub(const std::shared_ptr< ::grpc::ChannelInterface>& channel, const ::grpc::StubOptions& options = ::grpc::StubOptions());

  class Service : public ::grpc::Service {
   public:
    Service();
    virtual ~Service();
    // Creates the given topic with the given name. See the [resource name rules]
    // (https://cloud.google.com/pubsub/docs/admin#resource_names).
    virtual ::grpc::Status CreateTopic(::grpc::ServerContext* context, const ::google::pubsub::v1::Topic* request, ::google::pubsub::v1::Topic* response);
    // Updates an existing topic. Note that certain properties of a
    // topic are not modifiable.
    virtual ::grpc::Status UpdateTopic(::grpc::ServerContext* context, const ::google::pubsub::v1::UpdateTopicRequest* request, ::google::pubsub::v1::Topic* response);
    // Adds one or more messages to the topic. Returns `NOT_FOUND` if the topic
    // does not exist.
    virtual ::grpc::Status Publish(::grpc::ServerContext* context, const ::google::pubsub::v1::PublishRequest* request, ::google::pubsub::v1::PublishResponse* response);
    // Gets the configuration of a topic.
    virtual ::grpc::Status GetTopic(::grpc::ServerContext* context, const ::google::pubsub::v1::GetTopicRequest* request, ::google::pubsub::v1::Topic* response);
    // Lists matching topics.
    virtual ::grpc::Status ListTopics(::grpc::ServerContext* context, const ::google::pubsub::v1::ListTopicsRequest* request, ::google::pubsub::v1::ListTopicsResponse* response);
    // Lists the names of the attached subscriptions on this topic.
    virtual ::grpc::Status ListTopicSubscriptions(::grpc::ServerContext* context, const ::google::pubsub::v1::ListTopicSubscriptionsRequest* request, ::google::pubsub::v1::ListTopicSubscriptionsResponse* response);
    // Lists the names of the snapshots on this topic. Snapshots are used in
    // [Seek](https://cloud.google.com/pubsub/docs/replay-overview) operations,
    // which allow you to manage message acknowledgments in bulk. That is, you can
    // set the acknowledgment state of messages in an existing subscription to the
    // state captured by a snapshot.
    virtual ::grpc::Status ListTopicSnapshots(::grpc::ServerContext* context, const ::google::pubsub::v1::ListTopicSnapshotsRequest* request, ::google::pubsub::v1::ListTopicSnapshotsResponse* response);
    // Deletes the topic with the given name. Returns `NOT_FOUND` if the topic
    // does not exist. After a topic is deleted, a new topic may be created with
    // the same name; this is an entirely new topic with none of the old
    // configuration or subscriptions. Existing subscriptions to this topic are
    // not deleted, but their `topic` field is set to `_deleted-topic_`.
    virtual ::grpc::Status DeleteTopic(::grpc::ServerContext* context, const ::google::pubsub::v1::DeleteTopicRequest* request, ::google::protobuf::Empty* response);
    // Detaches a subscription from this topic. All messages retained in the
    // subscription are dropped. Subsequent `Pull` and `StreamingPull` requests
    // will return FAILED_PRECONDITION. If the subscription is a push
    // subscription, pushes to the endpoint will stop.
    virtual ::grpc::Status DetachSubscription(::grpc::ServerContext* context, const ::google::pubsub::v1::DetachSubscriptionRequest* request, ::google::pubsub::v1::DetachSubscriptionResponse* response);
  };
  template <class BaseClass>
  class WithAsyncMethod_CreateTopic : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_CreateTopic() {
      ::grpc::Service::MarkMethodAsync(0);
    }
    ~WithAsyncMethod_CreateTopic() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateTopic(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::Topic* /*request*/, ::google::pubsub::v1::Topic* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestCreateTopic(::grpc::ServerContext* context, ::google::pubsub::v1::Topic* request, ::grpc::ServerAsyncResponseWriter< ::google::pubsub::v1::Topic>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(0, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_UpdateTopic : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_UpdateTopic() {
      ::grpc::Service::MarkMethodAsync(1);
    }
    ~WithAsyncMethod_UpdateTopic() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateTopic(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::UpdateTopicRequest* /*request*/, ::google::pubsub::v1::Topic* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestUpdateTopic(::grpc::ServerContext* context, ::google::pubsub::v1::UpdateTopicRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::pubsub::v1::Topic>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(1, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_Publish : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_Publish() {
      ::grpc::Service::MarkMethodAsync(2);
    }
    ~WithAsyncMethod_Publish() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Publish(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::PublishRequest* /*request*/, ::google::pubsub::v1::PublishResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestPublish(::grpc::ServerContext* context, ::google::pubsub::v1::PublishRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::pubsub::v1::PublishResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(2, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_GetTopic : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_GetTopic() {
      ::grpc::Service::MarkMethodAsync(3);
    }
    ~WithAsyncMethod_GetTopic() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetTopic(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::GetTopicRequest* /*request*/, ::google::pubsub::v1::Topic* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGetTopic(::grpc::ServerContext* context, ::google::pubsub::v1::GetTopicRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::pubsub::v1::Topic>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(3, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_ListTopics : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_ListTopics() {
      ::grpc::Service::MarkMethodAsync(4);
    }
    ~WithAsyncMethod_ListTopics() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListTopics(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::ListTopicsRequest* /*request*/, ::google::pubsub::v1::ListTopicsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestListTopics(::grpc::ServerContext* context, ::google::pubsub::v1::ListTopicsRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::pubsub::v1::ListTopicsResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(4, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_ListTopicSubscriptions : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_ListTopicSubscriptions() {
      ::grpc::Service::MarkMethodAsync(5);
    }
    ~WithAsyncMethod_ListTopicSubscriptions() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListTopicSubscriptions(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::ListTopicSubscriptionsRequest* /*request*/, ::google::pubsub::v1::ListTopicSubscriptionsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestListTopicSubscriptions(::grpc::ServerContext* context, ::google::pubsub::v1::ListTopicSubscriptionsRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::pubsub::v1::ListTopicSubscriptionsResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(5, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_ListTopicSnapshots : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_ListTopicSnapshots() {
      ::grpc::Service::MarkMethodAsync(6);
    }
    ~WithAsyncMethod_ListTopicSnapshots() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListTopicSnapshots(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::ListTopicSnapshotsRequest* /*request*/, ::google::pubsub::v1::ListTopicSnapshotsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestListTopicSnapshots(::grpc::ServerContext* context, ::google::pubsub::v1::ListTopicSnapshotsRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::pubsub::v1::ListTopicSnapshotsResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(6, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_DeleteTopic : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_DeleteTopic() {
      ::grpc::Service::MarkMethodAsync(7);
    }
    ~WithAsyncMethod_DeleteTopic() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteTopic(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::DeleteTopicRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestDeleteTopic(::grpc::ServerContext* context, ::google::pubsub::v1::DeleteTopicRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::protobuf::Empty>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(7, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_DetachSubscription : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_DetachSubscription() {
      ::grpc::Service::MarkMethodAsync(8);
    }
    ~WithAsyncMethod_DetachSubscription() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DetachSubscription(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::DetachSubscriptionRequest* /*request*/, ::google::pubsub::v1::DetachSubscriptionResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestDetachSubscription(::grpc::ServerContext* context, ::google::pubsub::v1::DetachSubscriptionRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::pubsub::v1::DetachSubscriptionResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(8, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  typedef WithAsyncMethod_CreateTopic<WithAsyncMethod_UpdateTopic<WithAsyncMethod_Publish<WithAsyncMethod_GetTopic<WithAsyncMethod_ListTopics<WithAsyncMethod_ListTopicSubscriptions<WithAsyncMethod_ListTopicSnapshots<WithAsyncMethod_DeleteTopic<WithAsyncMethod_DetachSubscription<Service > > > > > > > > > AsyncService;
  template <class BaseClass>
  class WithCallbackMethod_CreateTopic : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_CreateTopic() {
      ::grpc::Service::MarkMethodCallback(0,
          new ::grpc::internal::CallbackUnaryHandler< ::google::pubsub::v1::Topic, ::google::pubsub::v1::Topic>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::pubsub::v1::Topic* request, ::google::pubsub::v1::Topic* response) { return this->CreateTopic(context, request, response); }));}
    void SetMessageAllocatorFor_CreateTopic(
        ::grpc::MessageAllocator< ::google::pubsub::v1::Topic, ::google::pubsub::v1::Topic>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(0);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::pubsub::v1::Topic, ::google::pubsub::v1::Topic>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_CreateTopic() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateTopic(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::Topic* /*request*/, ::google::pubsub::v1::Topic* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* CreateTopic(
      ::grpc::CallbackServerContext* /*context*/, const ::google::pubsub::v1::Topic* /*request*/, ::google::pubsub::v1::Topic* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_UpdateTopic : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_UpdateTopic() {
      ::grpc::Service::MarkMethodCallback(1,
          new ::grpc::internal::CallbackUnaryHandler< ::google::pubsub::v1::UpdateTopicRequest, ::google::pubsub::v1::Topic>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::pubsub::v1::UpdateTopicRequest* request, ::google::pubsub::v1::Topic* response) { return this->UpdateTopic(context, request, response); }));}
    void SetMessageAllocatorFor_UpdateTopic(
        ::grpc::MessageAllocator< ::google::pubsub::v1::UpdateTopicRequest, ::google::pubsub::v1::Topic>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(1);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::pubsub::v1::UpdateTopicRequest, ::google::pubsub::v1::Topic>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_UpdateTopic() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateTopic(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::UpdateTopicRequest* /*request*/, ::google::pubsub::v1::Topic* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* UpdateTopic(
      ::grpc::CallbackServerContext* /*context*/, const ::google::pubsub::v1::UpdateTopicRequest* /*request*/, ::google::pubsub::v1::Topic* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_Publish : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_Publish() {
      ::grpc::Service::MarkMethodCallback(2,
          new ::grpc::internal::CallbackUnaryHandler< ::google::pubsub::v1::PublishRequest, ::google::pubsub::v1::PublishResponse>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::pubsub::v1::PublishRequest* request, ::google::pubsub::v1::PublishResponse* response) { return this->Publish(context, request, response); }));}
    void SetMessageAllocatorFor_Publish(
        ::grpc::MessageAllocator< ::google::pubsub::v1::PublishRequest, ::google::pubsub::v1::PublishResponse>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(2);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::pubsub::v1::PublishRequest, ::google::pubsub::v1::PublishResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_Publish() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Publish(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::PublishRequest* /*request*/, ::google::pubsub::v1::PublishResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* Publish(
      ::grpc::CallbackServerContext* /*context*/, const ::google::pubsub::v1::PublishRequest* /*request*/, ::google::pubsub::v1::PublishResponse* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_GetTopic : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_GetTopic() {
      ::grpc::Service::MarkMethodCallback(3,
          new ::grpc::internal::CallbackUnaryHandler< ::google::pubsub::v1::GetTopicRequest, ::google::pubsub::v1::Topic>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::pubsub::v1::GetTopicRequest* request, ::google::pubsub::v1::Topic* response) { return this->GetTopic(context, request, response); }));}
    void SetMessageAllocatorFor_GetTopic(
        ::grpc::MessageAllocator< ::google::pubsub::v1::GetTopicRequest, ::google::pubsub::v1::Topic>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(3);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::pubsub::v1::GetTopicRequest, ::google::pubsub::v1::Topic>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_GetTopic() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetTopic(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::GetTopicRequest* /*request*/, ::google::pubsub::v1::Topic* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* GetTopic(
      ::grpc::CallbackServerContext* /*context*/, const ::google::pubsub::v1::GetTopicRequest* /*request*/, ::google::pubsub::v1::Topic* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_ListTopics : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_ListTopics() {
      ::grpc::Service::MarkMethodCallback(4,
          new ::grpc::internal::CallbackUnaryHandler< ::google::pubsub::v1::ListTopicsRequest, ::google::pubsub::v1::ListTopicsResponse>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::pubsub::v1::ListTopicsRequest* request, ::google::pubsub::v1::ListTopicsResponse* response) { return this->ListTopics(context, request, response); }));}
    void SetMessageAllocatorFor_ListTopics(
        ::grpc::MessageAllocator< ::google::pubsub::v1::ListTopicsRequest, ::google::pubsub::v1::ListTopicsResponse>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(4);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::pubsub::v1::ListTopicsRequest, ::google::pubsub::v1::ListTopicsResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_ListTopics() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListTopics(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::ListTopicsRequest* /*request*/, ::google::pubsub::v1::ListTopicsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* ListTopics(
      ::grpc::CallbackServerContext* /*context*/, const ::google::pubsub::v1::ListTopicsRequest* /*request*/, ::google::pubsub::v1::ListTopicsResponse* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_ListTopicSubscriptions : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_ListTopicSubscriptions() {
      ::grpc::Service::MarkMethodCallback(5,
          new ::grpc::internal::CallbackUnaryHandler< ::google::pubsub::v1::ListTopicSubscriptionsRequest, ::google::pubsub::v1::ListTopicSubscriptionsResponse>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::pubsub::v1::ListTopicSubscriptionsRequest* request, ::google::pubsub::v1::ListTopicSubscriptionsResponse* response) { return this->ListTopicSubscriptions(context, request, response); }));}
    void SetMessageAllocatorFor_ListTopicSubscriptions(
        ::grpc::MessageAllocator< ::google::pubsub::v1::ListTopicSubscriptionsRequest, ::google::pubsub::v1::ListTopicSubscriptionsResponse>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(5);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::pubsub::v1::ListTopicSubscriptionsRequest, ::google::pubsub::v1::ListTopicSubscriptionsResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_ListTopicSubscriptions() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListTopicSubscriptions(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::ListTopicSubscriptionsRequest* /*request*/, ::google::pubsub::v1::ListTopicSubscriptionsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* ListTopicSubscriptions(
      ::grpc::CallbackServerContext* /*context*/, const ::google::pubsub::v1::ListTopicSubscriptionsRequest* /*request*/, ::google::pubsub::v1::ListTopicSubscriptionsResponse* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_ListTopicSnapshots : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_ListTopicSnapshots() {
      ::grpc::Service::MarkMethodCallback(6,
          new ::grpc::internal::CallbackUnaryHandler< ::google::pubsub::v1::ListTopicSnapshotsRequest, ::google::pubsub::v1::ListTopicSnapshotsResponse>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::pubsub::v1::ListTopicSnapshotsRequest* request, ::google::pubsub::v1::ListTopicSnapshotsResponse* response) { return this->ListTopicSnapshots(context, request, response); }));}
    void SetMessageAllocatorFor_ListTopicSnapshots(
        ::grpc::MessageAllocator< ::google::pubsub::v1::ListTopicSnapshotsRequest, ::google::pubsub::v1::ListTopicSnapshotsResponse>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(6);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::pubsub::v1::ListTopicSnapshotsRequest, ::google::pubsub::v1::ListTopicSnapshotsResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_ListTopicSnapshots() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListTopicSnapshots(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::ListTopicSnapshotsRequest* /*request*/, ::google::pubsub::v1::ListTopicSnapshotsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* ListTopicSnapshots(
      ::grpc::CallbackServerContext* /*context*/, const ::google::pubsub::v1::ListTopicSnapshotsRequest* /*request*/, ::google::pubsub::v1::ListTopicSnapshotsResponse* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_DeleteTopic : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_DeleteTopic() {
      ::grpc::Service::MarkMethodCallback(7,
          new ::grpc::internal::CallbackUnaryHandler< ::google::pubsub::v1::DeleteTopicRequest, ::google::protobuf::Empty>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::pubsub::v1::DeleteTopicRequest* request, ::google::protobuf::Empty* response) { return this->DeleteTopic(context, request, response); }));}
    void SetMessageAllocatorFor_DeleteTopic(
        ::grpc::MessageAllocator< ::google::pubsub::v1::DeleteTopicRequest, ::google::protobuf::Empty>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(7);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::pubsub::v1::DeleteTopicRequest, ::google::protobuf::Empty>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_DeleteTopic() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteTopic(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::DeleteTopicRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* DeleteTopic(
      ::grpc::CallbackServerContext* /*context*/, const ::google::pubsub::v1::DeleteTopicRequest* /*request*/, ::google::protobuf::Empty* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_DetachSubscription : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_DetachSubscription() {
      ::grpc::Service::MarkMethodCallback(8,
          new ::grpc::internal::CallbackUnaryHandler< ::google::pubsub::v1::DetachSubscriptionRequest, ::google::pubsub::v1::DetachSubscriptionResponse>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::pubsub::v1::DetachSubscriptionRequest* request, ::google::pubsub::v1::DetachSubscriptionResponse* response) { return this->DetachSubscription(context, request, response); }));}
    void SetMessageAllocatorFor_DetachSubscription(
        ::grpc::MessageAllocator< ::google::pubsub::v1::DetachSubscriptionRequest, ::google::pubsub::v1::DetachSubscriptionResponse>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(8);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::pubsub::v1::DetachSubscriptionRequest, ::google::pubsub::v1::DetachSubscriptionResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_DetachSubscription() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DetachSubscription(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::DetachSubscriptionRequest* /*request*/, ::google::pubsub::v1::DetachSubscriptionResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* DetachSubscription(
      ::grpc::CallbackServerContext* /*context*/, const ::google::pubsub::v1::DetachSubscriptionRequest* /*request*/, ::google::pubsub::v1::DetachSubscriptionResponse* /*response*/)  { return nullptr; }
  };
  typedef WithCallbackMethod_CreateTopic<WithCallbackMethod_UpdateTopic<WithCallbackMethod_Publish<WithCallbackMethod_GetTopic<WithCallbackMethod_ListTopics<WithCallbackMethod_ListTopicSubscriptions<WithCallbackMethod_ListTopicSnapshots<WithCallbackMethod_DeleteTopic<WithCallbackMethod_DetachSubscription<Service > > > > > > > > > CallbackService;
  typedef CallbackService ExperimentalCallbackService;
  template <class BaseClass>
  class WithGenericMethod_CreateTopic : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_CreateTopic() {
      ::grpc::Service::MarkMethodGeneric(0);
    }
    ~WithGenericMethod_CreateTopic() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateTopic(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::Topic* /*request*/, ::google::pubsub::v1::Topic* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_UpdateTopic : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_UpdateTopic() {
      ::grpc::Service::MarkMethodGeneric(1);
    }
    ~WithGenericMethod_UpdateTopic() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateTopic(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::UpdateTopicRequest* /*request*/, ::google::pubsub::v1::Topic* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_Publish : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_Publish() {
      ::grpc::Service::MarkMethodGeneric(2);
    }
    ~WithGenericMethod_Publish() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Publish(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::PublishRequest* /*request*/, ::google::pubsub::v1::PublishResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_GetTopic : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_GetTopic() {
      ::grpc::Service::MarkMethodGeneric(3);
    }
    ~WithGenericMethod_GetTopic() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetTopic(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::GetTopicRequest* /*request*/, ::google::pubsub::v1::Topic* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_ListTopics : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_ListTopics() {
      ::grpc::Service::MarkMethodGeneric(4);
    }
    ~WithGenericMethod_ListTopics() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListTopics(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::ListTopicsRequest* /*request*/, ::google::pubsub::v1::ListTopicsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_ListTopicSubscriptions : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_ListTopicSubscriptions() {
      ::grpc::Service::MarkMethodGeneric(5);
    }
    ~WithGenericMethod_ListTopicSubscriptions() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListTopicSubscriptions(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::ListTopicSubscriptionsRequest* /*request*/, ::google::pubsub::v1::ListTopicSubscriptionsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_ListTopicSnapshots : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_ListTopicSnapshots() {
      ::grpc::Service::MarkMethodGeneric(6);
    }
    ~WithGenericMethod_ListTopicSnapshots() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListTopicSnapshots(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::ListTopicSnapshotsRequest* /*request*/, ::google::pubsub::v1::ListTopicSnapshotsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_DeleteTopic : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_DeleteTopic() {
      ::grpc::Service::MarkMethodGeneric(7);
    }
    ~WithGenericMethod_DeleteTopic() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteTopic(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::DeleteTopicRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_DetachSubscription : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_DetachSubscription() {
      ::grpc::Service::MarkMethodGeneric(8);
    }
    ~WithGenericMethod_DetachSubscription() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DetachSubscription(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::DetachSubscriptionRequest* /*request*/, ::google::pubsub::v1::DetachSubscriptionResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithRawMethod_CreateTopic : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_CreateTopic() {
      ::grpc::Service::MarkMethodRaw(0);
    }
    ~WithRawMethod_CreateTopic() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateTopic(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::Topic* /*request*/, ::google::pubsub::v1::Topic* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestCreateTopic(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(0, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_UpdateTopic : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_UpdateTopic() {
      ::grpc::Service::MarkMethodRaw(1);
    }
    ~WithRawMethod_UpdateTopic() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateTopic(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::UpdateTopicRequest* /*request*/, ::google::pubsub::v1::Topic* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestUpdateTopic(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(1, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_Publish : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_Publish() {
      ::grpc::Service::MarkMethodRaw(2);
    }
    ~WithRawMethod_Publish() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Publish(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::PublishRequest* /*request*/, ::google::pubsub::v1::PublishResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestPublish(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(2, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_GetTopic : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_GetTopic() {
      ::grpc::Service::MarkMethodRaw(3);
    }
    ~WithRawMethod_GetTopic() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetTopic(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::GetTopicRequest* /*request*/, ::google::pubsub::v1::Topic* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGetTopic(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(3, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_ListTopics : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_ListTopics() {
      ::grpc::Service::MarkMethodRaw(4);
    }
    ~WithRawMethod_ListTopics() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListTopics(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::ListTopicsRequest* /*request*/, ::google::pubsub::v1::ListTopicsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestListTopics(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(4, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_ListTopicSubscriptions : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_ListTopicSubscriptions() {
      ::grpc::Service::MarkMethodRaw(5);
    }
    ~WithRawMethod_ListTopicSubscriptions() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListTopicSubscriptions(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::ListTopicSubscriptionsRequest* /*request*/, ::google::pubsub::v1::ListTopicSubscriptionsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestListTopicSubscriptions(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(5, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_ListTopicSnapshots : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_ListTopicSnapshots() {
      ::grpc::Service::MarkMethodRaw(6);
    }
    ~WithRawMethod_ListTopicSnapshots() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListTopicSnapshots(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::ListTopicSnapshotsRequest* /*request*/, ::google::pubsub::v1::ListTopicSnapshotsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestListTopicSnapshots(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(6, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_DeleteTopic : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_DeleteTopic() {
      ::grpc::Service::MarkMethodRaw(7);
    }
    ~WithRawMethod_DeleteTopic() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteTopic(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::DeleteTopicRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestDeleteTopic(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(7, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_DetachSubscription : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_DetachSubscription() {
      ::grpc::Service::MarkMethodRaw(8);
    }
    ~WithRawMethod_DetachSubscription() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DetachSubscription(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::DetachSubscriptionRequest* /*request*/, ::google::pubsub::v1::DetachSubscriptionResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestDetachSubscription(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(8, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_CreateTopic : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_CreateTopic() {
      ::grpc::Service::MarkMethodRawCallback(0,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->CreateTopic(context, request, response); }));
    }
    ~WithRawCallbackMethod_CreateTopic() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateTopic(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::Topic* /*request*/, ::google::pubsub::v1::Topic* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* CreateTopic(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_UpdateTopic : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_UpdateTopic() {
      ::grpc::Service::MarkMethodRawCallback(1,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->UpdateTopic(context, request, response); }));
    }
    ~WithRawCallbackMethod_UpdateTopic() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateTopic(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::UpdateTopicRequest* /*request*/, ::google::pubsub::v1::Topic* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* UpdateTopic(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_Publish : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_Publish() {
      ::grpc::Service::MarkMethodRawCallback(2,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->Publish(context, request, response); }));
    }
    ~WithRawCallbackMethod_Publish() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Publish(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::PublishRequest* /*request*/, ::google::pubsub::v1::PublishResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* Publish(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_GetTopic : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_GetTopic() {
      ::grpc::Service::MarkMethodRawCallback(3,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->GetTopic(context, request, response); }));
    }
    ~WithRawCallbackMethod_GetTopic() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetTopic(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::GetTopicRequest* /*request*/, ::google::pubsub::v1::Topic* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* GetTopic(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_ListTopics : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_ListTopics() {
      ::grpc::Service::MarkMethodRawCallback(4,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->ListTopics(context, request, response); }));
    }
    ~WithRawCallbackMethod_ListTopics() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListTopics(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::ListTopicsRequest* /*request*/, ::google::pubsub::v1::ListTopicsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* ListTopics(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_ListTopicSubscriptions : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_ListTopicSubscriptions() {
      ::grpc::Service::MarkMethodRawCallback(5,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->ListTopicSubscriptions(context, request, response); }));
    }
    ~WithRawCallbackMethod_ListTopicSubscriptions() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListTopicSubscriptions(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::ListTopicSubscriptionsRequest* /*request*/, ::google::pubsub::v1::ListTopicSubscriptionsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* ListTopicSubscriptions(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_ListTopicSnapshots : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_ListTopicSnapshots() {
      ::grpc::Service::MarkMethodRawCallback(6,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->ListTopicSnapshots(context, request, response); }));
    }
    ~WithRawCallbackMethod_ListTopicSnapshots() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListTopicSnapshots(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::ListTopicSnapshotsRequest* /*request*/, ::google::pubsub::v1::ListTopicSnapshotsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* ListTopicSnapshots(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_DeleteTopic : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_DeleteTopic() {
      ::grpc::Service::MarkMethodRawCallback(7,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->DeleteTopic(context, request, response); }));
    }
    ~WithRawCallbackMethod_DeleteTopic() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteTopic(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::DeleteTopicRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* DeleteTopic(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_DetachSubscription : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_DetachSubscription() {
      ::grpc::Service::MarkMethodRawCallback(8,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->DetachSubscription(context, request, response); }));
    }
    ~WithRawCallbackMethod_DetachSubscription() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DetachSubscription(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::DetachSubscriptionRequest* /*request*/, ::google::pubsub::v1::DetachSubscriptionResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* DetachSubscription(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_CreateTopic : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_CreateTopic() {
      ::grpc::Service::MarkMethodStreamed(0,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::pubsub::v1::Topic, ::google::pubsub::v1::Topic>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::pubsub::v1::Topic, ::google::pubsub::v1::Topic>* streamer) {
                       return this->StreamedCreateTopic(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_CreateTopic() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status CreateTopic(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::Topic* /*request*/, ::google::pubsub::v1::Topic* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedCreateTopic(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::pubsub::v1::Topic,::google::pubsub::v1::Topic>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_UpdateTopic : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_UpdateTopic() {
      ::grpc::Service::MarkMethodStreamed(1,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::pubsub::v1::UpdateTopicRequest, ::google::pubsub::v1::Topic>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::pubsub::v1::UpdateTopicRequest, ::google::pubsub::v1::Topic>* streamer) {
                       return this->StreamedUpdateTopic(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_UpdateTopic() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status UpdateTopic(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::UpdateTopicRequest* /*request*/, ::google::pubsub::v1::Topic* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedUpdateTopic(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::pubsub::v1::UpdateTopicRequest,::google::pubsub::v1::Topic>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_Publish : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_Publish() {
      ::grpc::Service::MarkMethodStreamed(2,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::pubsub::v1::PublishRequest, ::google::pubsub::v1::PublishResponse>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::pubsub::v1::PublishRequest, ::google::pubsub::v1::PublishResponse>* streamer) {
                       return this->StreamedPublish(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_Publish() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status Publish(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::PublishRequest* /*request*/, ::google::pubsub::v1::PublishResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedPublish(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::pubsub::v1::PublishRequest,::google::pubsub::v1::PublishResponse>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_GetTopic : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_GetTopic() {
      ::grpc::Service::MarkMethodStreamed(3,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::pubsub::v1::GetTopicRequest, ::google::pubsub::v1::Topic>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::pubsub::v1::GetTopicRequest, ::google::pubsub::v1::Topic>* streamer) {
                       return this->StreamedGetTopic(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_GetTopic() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status GetTopic(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::GetTopicRequest* /*request*/, ::google::pubsub::v1::Topic* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedGetTopic(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::pubsub::v1::GetTopicRequest,::google::pubsub::v1::Topic>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_ListTopics : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_ListTopics() {
      ::grpc::Service::MarkMethodStreamed(4,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::pubsub::v1::ListTopicsRequest, ::google::pubsub::v1::ListTopicsResponse>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::pubsub::v1::ListTopicsRequest, ::google::pubsub::v1::ListTopicsResponse>* streamer) {
                       return this->StreamedListTopics(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_ListTopics() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status ListTopics(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::ListTopicsRequest* /*request*/, ::google::pubsub::v1::ListTopicsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedListTopics(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::pubsub::v1::ListTopicsRequest,::google::pubsub::v1::ListTopicsResponse>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_ListTopicSubscriptions : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_ListTopicSubscriptions() {
      ::grpc::Service::MarkMethodStreamed(5,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::pubsub::v1::ListTopicSubscriptionsRequest, ::google::pubsub::v1::ListTopicSubscriptionsResponse>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::pubsub::v1::ListTopicSubscriptionsRequest, ::google::pubsub::v1::ListTopicSubscriptionsResponse>* streamer) {
                       return this->StreamedListTopicSubscriptions(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_ListTopicSubscriptions() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status ListTopicSubscriptions(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::ListTopicSubscriptionsRequest* /*request*/, ::google::pubsub::v1::ListTopicSubscriptionsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedListTopicSubscriptions(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::pubsub::v1::ListTopicSubscriptionsRequest,::google::pubsub::v1::ListTopicSubscriptionsResponse>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_ListTopicSnapshots : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_ListTopicSnapshots() {
      ::grpc::Service::MarkMethodStreamed(6,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::pubsub::v1::ListTopicSnapshotsRequest, ::google::pubsub::v1::ListTopicSnapshotsResponse>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::pubsub::v1::ListTopicSnapshotsRequest, ::google::pubsub::v1::ListTopicSnapshotsResponse>* streamer) {
                       return this->StreamedListTopicSnapshots(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_ListTopicSnapshots() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status ListTopicSnapshots(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::ListTopicSnapshotsRequest* /*request*/, ::google::pubsub::v1::ListTopicSnapshotsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedListTopicSnapshots(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::pubsub::v1::ListTopicSnapshotsRequest,::google::pubsub::v1::ListTopicSnapshotsResponse>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_DeleteTopic : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_DeleteTopic() {
      ::grpc::Service::MarkMethodStreamed(7,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::pubsub::v1::DeleteTopicRequest, ::google::protobuf::Empty>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::pubsub::v1::DeleteTopicRequest, ::google::protobuf::Empty>* streamer) {
                       return this->StreamedDeleteTopic(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_DeleteTopic() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status DeleteTopic(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::DeleteTopicRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedDeleteTopic(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::pubsub::v1::DeleteTopicRequest,::google::protobuf::Empty>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_DetachSubscription : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_DetachSubscription() {
      ::grpc::Service::MarkMethodStreamed(8,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::pubsub::v1::DetachSubscriptionRequest, ::google::pubsub::v1::DetachSubscriptionResponse>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::pubsub::v1::DetachSubscriptionRequest, ::google::pubsub::v1::DetachSubscriptionResponse>* streamer) {
                       return this->StreamedDetachSubscription(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_DetachSubscription() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status DetachSubscription(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::DetachSubscriptionRequest* /*request*/, ::google::pubsub::v1::DetachSubscriptionResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedDetachSubscription(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::pubsub::v1::DetachSubscriptionRequest,::google::pubsub::v1::DetachSubscriptionResponse>* server_unary_streamer) = 0;
  };
  typedef WithStreamedUnaryMethod_CreateTopic<WithStreamedUnaryMethod_UpdateTopic<WithStreamedUnaryMethod_Publish<WithStreamedUnaryMethod_GetTopic<WithStreamedUnaryMethod_ListTopics<WithStreamedUnaryMethod_ListTopicSubscriptions<WithStreamedUnaryMethod_ListTopicSnapshots<WithStreamedUnaryMethod_DeleteTopic<WithStreamedUnaryMethod_DetachSubscription<Service > > > > > > > > > StreamedUnaryService;
  typedef Service SplitStreamedService;
  typedef WithStreamedUnaryMethod_CreateTopic<WithStreamedUnaryMethod_UpdateTopic<WithStreamedUnaryMethod_Publish<WithStreamedUnaryMethod_GetTopic<WithStreamedUnaryMethod_ListTopics<WithStreamedUnaryMethod_ListTopicSubscriptions<WithStreamedUnaryMethod_ListTopicSnapshots<WithStreamedUnaryMethod_DeleteTopic<WithStreamedUnaryMethod_DetachSubscription<Service > > > > > > > > > StreamedService;
};

// The service that an application uses to manipulate subscriptions and to
// consume messages from a subscription via the `Pull` method or by
// establishing a bi-directional stream using the `StreamingPull` method.
class Subscriber final {
 public:
  static constexpr char const* service_full_name() {
    return "google.pubsub.v1.Subscriber";
  }
  class StubInterface {
   public:
    virtual ~StubInterface() {}
    // Creates a subscription to a given topic. See the [resource name rules]
    // (https://cloud.google.com/pubsub/docs/admin#resource_names).
    // If the subscription already exists, returns `ALREADY_EXISTS`.
    // If the corresponding topic doesn't exist, returns `NOT_FOUND`.
    //
    // If the name is not provided in the request, the server will assign a random
    // name for this subscription on the same project as the topic, conforming
    // to the [resource name format]
    // (https://cloud.google.com/pubsub/docs/admin#resource_names). The generated
    // name is populated in the returned Subscription object. Note that for REST
    // API requests, you must specify a name in the request.
    virtual ::grpc::Status CreateSubscription(::grpc::ClientContext* context, const ::google::pubsub::v1::Subscription& request, ::google::pubsub::v1::Subscription* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::Subscription>> AsyncCreateSubscription(::grpc::ClientContext* context, const ::google::pubsub::v1::Subscription& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::Subscription>>(AsyncCreateSubscriptionRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::Subscription>> PrepareAsyncCreateSubscription(::grpc::ClientContext* context, const ::google::pubsub::v1::Subscription& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::Subscription>>(PrepareAsyncCreateSubscriptionRaw(context, request, cq));
    }
    // Gets the configuration details of a subscription.
    virtual ::grpc::Status GetSubscription(::grpc::ClientContext* context, const ::google::pubsub::v1::GetSubscriptionRequest& request, ::google::pubsub::v1::Subscription* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::Subscription>> AsyncGetSubscription(::grpc::ClientContext* context, const ::google::pubsub::v1::GetSubscriptionRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::Subscription>>(AsyncGetSubscriptionRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::Subscription>> PrepareAsyncGetSubscription(::grpc::ClientContext* context, const ::google::pubsub::v1::GetSubscriptionRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::Subscription>>(PrepareAsyncGetSubscriptionRaw(context, request, cq));
    }
    // Updates an existing subscription. Note that certain properties of a
    // subscription, such as its topic, are not modifiable.
    virtual ::grpc::Status UpdateSubscription(::grpc::ClientContext* context, const ::google::pubsub::v1::UpdateSubscriptionRequest& request, ::google::pubsub::v1::Subscription* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::Subscription>> AsyncUpdateSubscription(::grpc::ClientContext* context, const ::google::pubsub::v1::UpdateSubscriptionRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::Subscription>>(AsyncUpdateSubscriptionRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::Subscription>> PrepareAsyncUpdateSubscription(::grpc::ClientContext* context, const ::google::pubsub::v1::UpdateSubscriptionRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::Subscription>>(PrepareAsyncUpdateSubscriptionRaw(context, request, cq));
    }
    // Lists matching subscriptions.
    virtual ::grpc::Status ListSubscriptions(::grpc::ClientContext* context, const ::google::pubsub::v1::ListSubscriptionsRequest& request, ::google::pubsub::v1::ListSubscriptionsResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::ListSubscriptionsResponse>> AsyncListSubscriptions(::grpc::ClientContext* context, const ::google::pubsub::v1::ListSubscriptionsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::ListSubscriptionsResponse>>(AsyncListSubscriptionsRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::ListSubscriptionsResponse>> PrepareAsyncListSubscriptions(::grpc::ClientContext* context, const ::google::pubsub::v1::ListSubscriptionsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::ListSubscriptionsResponse>>(PrepareAsyncListSubscriptionsRaw(context, request, cq));
    }
    // Deletes an existing subscription. All messages retained in the subscription
    // are immediately dropped. Calls to `Pull` after deletion will return
    // `NOT_FOUND`. After a subscription is deleted, a new one may be created with
    // the same name, but the new one has no association with the old
    // subscription or its topic unless the same topic is specified.
    virtual ::grpc::Status DeleteSubscription(::grpc::ClientContext* context, const ::google::pubsub::v1::DeleteSubscriptionRequest& request, ::google::protobuf::Empty* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>> AsyncDeleteSubscription(::grpc::ClientContext* context, const ::google::pubsub::v1::DeleteSubscriptionRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>>(AsyncDeleteSubscriptionRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>> PrepareAsyncDeleteSubscription(::grpc::ClientContext* context, const ::google::pubsub::v1::DeleteSubscriptionRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>>(PrepareAsyncDeleteSubscriptionRaw(context, request, cq));
    }
    // Modifies the ack deadline for a specific message. This method is useful
    // to indicate that more time is needed to process a message by the
    // subscriber, or to make the message available for redelivery if the
    // processing was interrupted. Note that this does not modify the
    // subscription-level `ackDeadlineSeconds` used for subsequent messages.
    virtual ::grpc::Status ModifyAckDeadline(::grpc::ClientContext* context, const ::google::pubsub::v1::ModifyAckDeadlineRequest& request, ::google::protobuf::Empty* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>> AsyncModifyAckDeadline(::grpc::ClientContext* context, const ::google::pubsub::v1::ModifyAckDeadlineRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>>(AsyncModifyAckDeadlineRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>> PrepareAsyncModifyAckDeadline(::grpc::ClientContext* context, const ::google::pubsub::v1::ModifyAckDeadlineRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>>(PrepareAsyncModifyAckDeadlineRaw(context, request, cq));
    }
    // Acknowledges the messages associated with the `ack_ids` in the
    // `AcknowledgeRequest`. The Pub/Sub system can remove the relevant messages
    // from the subscription.
    //
    // Acknowledging a message whose ack deadline has expired may succeed,
    // but such a message may be redelivered later. Acknowledging a message more
    // than once will not result in an error.
    virtual ::grpc::Status Acknowledge(::grpc::ClientContext* context, const ::google::pubsub::v1::AcknowledgeRequest& request, ::google::protobuf::Empty* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>> AsyncAcknowledge(::grpc::ClientContext* context, const ::google::pubsub::v1::AcknowledgeRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>>(AsyncAcknowledgeRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>> PrepareAsyncAcknowledge(::grpc::ClientContext* context, const ::google::pubsub::v1::AcknowledgeRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>>(PrepareAsyncAcknowledgeRaw(context, request, cq));
    }
    // Pulls messages from the server. The server may return `UNAVAILABLE` if
    // there are too many concurrent pull requests pending for the given
    // subscription.
    virtual ::grpc::Status Pull(::grpc::ClientContext* context, const ::google::pubsub::v1::PullRequest& request, ::google::pubsub::v1::PullResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::PullResponse>> AsyncPull(::grpc::ClientContext* context, const ::google::pubsub::v1::PullRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::PullResponse>>(AsyncPullRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::PullResponse>> PrepareAsyncPull(::grpc::ClientContext* context, const ::google::pubsub::v1::PullRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::PullResponse>>(PrepareAsyncPullRaw(context, request, cq));
    }
    // Establishes a stream with the server, which sends messages down to the
    // client. The client streams acknowledgements and ack deadline modifications
    // back to the server. The server will close the stream and return the status
    // on any error. The server may close the stream with status `UNAVAILABLE` to
    // reassign server-side resources, in which case, the client should
    // re-establish the stream. Flow control can be achieved by configuring the
    // underlying RPC channel.
    std::unique_ptr< ::grpc::ClientReaderWriterInterface< ::google::pubsub::v1::StreamingPullRequest, ::google::pubsub::v1::StreamingPullResponse>> StreamingPull(::grpc::ClientContext* context) {
      return std::unique_ptr< ::grpc::ClientReaderWriterInterface< ::google::pubsub::v1::StreamingPullRequest, ::google::pubsub::v1::StreamingPullResponse>>(StreamingPullRaw(context));
    }
    std::unique_ptr< ::grpc::ClientAsyncReaderWriterInterface< ::google::pubsub::v1::StreamingPullRequest, ::google::pubsub::v1::StreamingPullResponse>> AsyncStreamingPull(::grpc::ClientContext* context, ::grpc::CompletionQueue* cq, void* tag) {
      return std::unique_ptr< ::grpc::ClientAsyncReaderWriterInterface< ::google::pubsub::v1::StreamingPullRequest, ::google::pubsub::v1::StreamingPullResponse>>(AsyncStreamingPullRaw(context, cq, tag));
    }
    std::unique_ptr< ::grpc::ClientAsyncReaderWriterInterface< ::google::pubsub::v1::StreamingPullRequest, ::google::pubsub::v1::StreamingPullResponse>> PrepareAsyncStreamingPull(::grpc::ClientContext* context, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncReaderWriterInterface< ::google::pubsub::v1::StreamingPullRequest, ::google::pubsub::v1::StreamingPullResponse>>(PrepareAsyncStreamingPullRaw(context, cq));
    }
    // Modifies the `PushConfig` for a specified subscription.
    //
    // This may be used to change a push subscription to a pull one (signified by
    // an empty `PushConfig`) or vice versa, or change the endpoint URL and other
    // attributes of a push subscription. Messages will accumulate for delivery
    // continuously through the call regardless of changes to the `PushConfig`.
    virtual ::grpc::Status ModifyPushConfig(::grpc::ClientContext* context, const ::google::pubsub::v1::ModifyPushConfigRequest& request, ::google::protobuf::Empty* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>> AsyncModifyPushConfig(::grpc::ClientContext* context, const ::google::pubsub::v1::ModifyPushConfigRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>>(AsyncModifyPushConfigRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>> PrepareAsyncModifyPushConfig(::grpc::ClientContext* context, const ::google::pubsub::v1::ModifyPushConfigRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>>(PrepareAsyncModifyPushConfigRaw(context, request, cq));
    }
    // Gets the configuration details of a snapshot. Snapshots are used in
    // <a href="https://cloud.google.com/pubsub/docs/replay-overview">Seek</a>
    // operations, which allow you to manage message acknowledgments in bulk. That
    // is, you can set the acknowledgment state of messages in an existing
    // subscription to the state captured by a snapshot.
    virtual ::grpc::Status GetSnapshot(::grpc::ClientContext* context, const ::google::pubsub::v1::GetSnapshotRequest& request, ::google::pubsub::v1::Snapshot* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::Snapshot>> AsyncGetSnapshot(::grpc::ClientContext* context, const ::google::pubsub::v1::GetSnapshotRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::Snapshot>>(AsyncGetSnapshotRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::Snapshot>> PrepareAsyncGetSnapshot(::grpc::ClientContext* context, const ::google::pubsub::v1::GetSnapshotRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::Snapshot>>(PrepareAsyncGetSnapshotRaw(context, request, cq));
    }
    // Lists the existing snapshots. Snapshots are used in [Seek](
    // https://cloud.google.com/pubsub/docs/replay-overview) operations, which
    // allow you to manage message acknowledgments in bulk. That is, you can set
    // the acknowledgment state of messages in an existing subscription to the
    // state captured by a snapshot.
    virtual ::grpc::Status ListSnapshots(::grpc::ClientContext* context, const ::google::pubsub::v1::ListSnapshotsRequest& request, ::google::pubsub::v1::ListSnapshotsResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::ListSnapshotsResponse>> AsyncListSnapshots(::grpc::ClientContext* context, const ::google::pubsub::v1::ListSnapshotsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::ListSnapshotsResponse>>(AsyncListSnapshotsRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::ListSnapshotsResponse>> PrepareAsyncListSnapshots(::grpc::ClientContext* context, const ::google::pubsub::v1::ListSnapshotsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::ListSnapshotsResponse>>(PrepareAsyncListSnapshotsRaw(context, request, cq));
    }
    // Creates a snapshot from the requested subscription. Snapshots are used in
    // [Seek](https://cloud.google.com/pubsub/docs/replay-overview) operations,
    // which allow you to manage message acknowledgments in bulk. That is, you can
    // set the acknowledgment state of messages in an existing subscription to the
    // state captured by a snapshot.
    // If the snapshot already exists, returns `ALREADY_EXISTS`.
    // If the requested subscription doesn't exist, returns `NOT_FOUND`.
    // If the backlog in the subscription is too old -- and the resulting snapshot
    // would expire in less than 1 hour -- then `FAILED_PRECONDITION` is returned.
    // See also the `Snapshot.expire_time` field. If the name is not provided in
    // the request, the server will assign a random
    // name for this snapshot on the same project as the subscription, conforming
    // to the [resource name format]
    // (https://cloud.google.com/pubsub/docs/admin#resource_names). The
    // generated name is populated in the returned Snapshot object. Note that for
    // REST API requests, you must specify a name in the request.
    virtual ::grpc::Status CreateSnapshot(::grpc::ClientContext* context, const ::google::pubsub::v1::CreateSnapshotRequest& request, ::google::pubsub::v1::Snapshot* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::Snapshot>> AsyncCreateSnapshot(::grpc::ClientContext* context, const ::google::pubsub::v1::CreateSnapshotRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::Snapshot>>(AsyncCreateSnapshotRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::Snapshot>> PrepareAsyncCreateSnapshot(::grpc::ClientContext* context, const ::google::pubsub::v1::CreateSnapshotRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::Snapshot>>(PrepareAsyncCreateSnapshotRaw(context, request, cq));
    }
    // Updates an existing snapshot. Snapshots are used in
    // <a href="https://cloud.google.com/pubsub/docs/replay-overview">Seek</a>
    // operations, which allow
    // you to manage message acknowledgments in bulk. That is, you can set the
    // acknowledgment state of messages in an existing subscription to the state
    // captured by a snapshot.
    virtual ::grpc::Status UpdateSnapshot(::grpc::ClientContext* context, const ::google::pubsub::v1::UpdateSnapshotRequest& request, ::google::pubsub::v1::Snapshot* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::Snapshot>> AsyncUpdateSnapshot(::grpc::ClientContext* context, const ::google::pubsub::v1::UpdateSnapshotRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::Snapshot>>(AsyncUpdateSnapshotRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::Snapshot>> PrepareAsyncUpdateSnapshot(::grpc::ClientContext* context, const ::google::pubsub::v1::UpdateSnapshotRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::Snapshot>>(PrepareAsyncUpdateSnapshotRaw(context, request, cq));
    }
    // Removes an existing snapshot. Snapshots are used in [Seek]
    // (https://cloud.google.com/pubsub/docs/replay-overview) operations, which
    // allow you to manage message acknowledgments in bulk. That is, you can set
    // the acknowledgment state of messages in an existing subscription to the
    // state captured by a snapshot.
    // When the snapshot is deleted, all messages retained in the snapshot
    // are immediately dropped. After a snapshot is deleted, a new one may be
    // created with the same name, but the new one has no association with the old
    // snapshot or its subscription, unless the same subscription is specified.
    virtual ::grpc::Status DeleteSnapshot(::grpc::ClientContext* context, const ::google::pubsub::v1::DeleteSnapshotRequest& request, ::google::protobuf::Empty* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>> AsyncDeleteSnapshot(::grpc::ClientContext* context, const ::google::pubsub::v1::DeleteSnapshotRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>>(AsyncDeleteSnapshotRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>> PrepareAsyncDeleteSnapshot(::grpc::ClientContext* context, const ::google::pubsub::v1::DeleteSnapshotRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>>(PrepareAsyncDeleteSnapshotRaw(context, request, cq));
    }
    // Seeks an existing subscription to a point in time or to a given snapshot,
    // whichever is provided in the request. Snapshots are used in [Seek]
    // (https://cloud.google.com/pubsub/docs/replay-overview) operations, which
    // allow you to manage message acknowledgments in bulk. That is, you can set
    // the acknowledgment state of messages in an existing subscription to the
    // state captured by a snapshot. Note that both the subscription and the
    // snapshot must be on the same topic.
    virtual ::grpc::Status Seek(::grpc::ClientContext* context, const ::google::pubsub::v1::SeekRequest& request, ::google::pubsub::v1::SeekResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::SeekResponse>> AsyncSeek(::grpc::ClientContext* context, const ::google::pubsub::v1::SeekRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::SeekResponse>>(AsyncSeekRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::SeekResponse>> PrepareAsyncSeek(::grpc::ClientContext* context, const ::google::pubsub::v1::SeekRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::SeekResponse>>(PrepareAsyncSeekRaw(context, request, cq));
    }
    class async_interface {
     public:
      virtual ~async_interface() {}
      // Creates a subscription to a given topic. See the [resource name rules]
      // (https://cloud.google.com/pubsub/docs/admin#resource_names).
      // If the subscription already exists, returns `ALREADY_EXISTS`.
      // If the corresponding topic doesn't exist, returns `NOT_FOUND`.
      //
      // If the name is not provided in the request, the server will assign a random
      // name for this subscription on the same project as the topic, conforming
      // to the [resource name format]
      // (https://cloud.google.com/pubsub/docs/admin#resource_names). The generated
      // name is populated in the returned Subscription object. Note that for REST
      // API requests, you must specify a name in the request.
      virtual void CreateSubscription(::grpc::ClientContext* context, const ::google::pubsub::v1::Subscription* request, ::google::pubsub::v1::Subscription* response, std::function<void(::grpc::Status)>) = 0;
      virtual void CreateSubscription(::grpc::ClientContext* context, const ::google::pubsub::v1::Subscription* request, ::google::pubsub::v1::Subscription* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Gets the configuration details of a subscription.
      virtual void GetSubscription(::grpc::ClientContext* context, const ::google::pubsub::v1::GetSubscriptionRequest* request, ::google::pubsub::v1::Subscription* response, std::function<void(::grpc::Status)>) = 0;
      virtual void GetSubscription(::grpc::ClientContext* context, const ::google::pubsub::v1::GetSubscriptionRequest* request, ::google::pubsub::v1::Subscription* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Updates an existing subscription. Note that certain properties of a
      // subscription, such as its topic, are not modifiable.
      virtual void UpdateSubscription(::grpc::ClientContext* context, const ::google::pubsub::v1::UpdateSubscriptionRequest* request, ::google::pubsub::v1::Subscription* response, std::function<void(::grpc::Status)>) = 0;
      virtual void UpdateSubscription(::grpc::ClientContext* context, const ::google::pubsub::v1::UpdateSubscriptionRequest* request, ::google::pubsub::v1::Subscription* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Lists matching subscriptions.
      virtual void ListSubscriptions(::grpc::ClientContext* context, const ::google::pubsub::v1::ListSubscriptionsRequest* request, ::google::pubsub::v1::ListSubscriptionsResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void ListSubscriptions(::grpc::ClientContext* context, const ::google::pubsub::v1::ListSubscriptionsRequest* request, ::google::pubsub::v1::ListSubscriptionsResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Deletes an existing subscription. All messages retained in the subscription
      // are immediately dropped. Calls to `Pull` after deletion will return
      // `NOT_FOUND`. After a subscription is deleted, a new one may be created with
      // the same name, but the new one has no association with the old
      // subscription or its topic unless the same topic is specified.
      virtual void DeleteSubscription(::grpc::ClientContext* context, const ::google::pubsub::v1::DeleteSubscriptionRequest* request, ::google::protobuf::Empty* response, std::function<void(::grpc::Status)>) = 0;
      virtual void DeleteSubscription(::grpc::ClientContext* context, const ::google::pubsub::v1::DeleteSubscriptionRequest* request, ::google::protobuf::Empty* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Modifies the ack deadline for a specific message. This method is useful
      // to indicate that more time is needed to process a message by the
      // subscriber, or to make the message available for redelivery if the
      // processing was interrupted. Note that this does not modify the
      // subscription-level `ackDeadlineSeconds` used for subsequent messages.
      virtual void ModifyAckDeadline(::grpc::ClientContext* context, const ::google::pubsub::v1::ModifyAckDeadlineRequest* request, ::google::protobuf::Empty* response, std::function<void(::grpc::Status)>) = 0;
      virtual void ModifyAckDeadline(::grpc::ClientContext* context, const ::google::pubsub::v1::ModifyAckDeadlineRequest* request, ::google::protobuf::Empty* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Acknowledges the messages associated with the `ack_ids` in the
      // `AcknowledgeRequest`. The Pub/Sub system can remove the relevant messages
      // from the subscription.
      //
      // Acknowledging a message whose ack deadline has expired may succeed,
      // but such a message may be redelivered later. Acknowledging a message more
      // than once will not result in an error.
      virtual void Acknowledge(::grpc::ClientContext* context, const ::google::pubsub::v1::AcknowledgeRequest* request, ::google::protobuf::Empty* response, std::function<void(::grpc::Status)>) = 0;
      virtual void Acknowledge(::grpc::ClientContext* context, const ::google::pubsub::v1::AcknowledgeRequest* request, ::google::protobuf::Empty* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Pulls messages from the server. The server may return `UNAVAILABLE` if
      // there are too many concurrent pull requests pending for the given
      // subscription.
      virtual void Pull(::grpc::ClientContext* context, const ::google::pubsub::v1::PullRequest* request, ::google::pubsub::v1::PullResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void Pull(::grpc::ClientContext* context, const ::google::pubsub::v1::PullRequest* request, ::google::pubsub::v1::PullResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Establishes a stream with the server, which sends messages down to the
      // client. The client streams acknowledgements and ack deadline modifications
      // back to the server. The server will close the stream and return the status
      // on any error. The server may close the stream with status `UNAVAILABLE` to
      // reassign server-side resources, in which case, the client should
      // re-establish the stream. Flow control can be achieved by configuring the
      // underlying RPC channel.
      virtual void StreamingPull(::grpc::ClientContext* context, ::grpc::ClientBidiReactor< ::google::pubsub::v1::StreamingPullRequest,::google::pubsub::v1::StreamingPullResponse>* reactor) = 0;
      // Modifies the `PushConfig` for a specified subscription.
      //
      // This may be used to change a push subscription to a pull one (signified by
      // an empty `PushConfig`) or vice versa, or change the endpoint URL and other
      // attributes of a push subscription. Messages will accumulate for delivery
      // continuously through the call regardless of changes to the `PushConfig`.
      virtual void ModifyPushConfig(::grpc::ClientContext* context, const ::google::pubsub::v1::ModifyPushConfigRequest* request, ::google::protobuf::Empty* response, std::function<void(::grpc::Status)>) = 0;
      virtual void ModifyPushConfig(::grpc::ClientContext* context, const ::google::pubsub::v1::ModifyPushConfigRequest* request, ::google::protobuf::Empty* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Gets the configuration details of a snapshot. Snapshots are used in
      // <a href="https://cloud.google.com/pubsub/docs/replay-overview">Seek</a>
      // operations, which allow you to manage message acknowledgments in bulk. That
      // is, you can set the acknowledgment state of messages in an existing
      // subscription to the state captured by a snapshot.
      virtual void GetSnapshot(::grpc::ClientContext* context, const ::google::pubsub::v1::GetSnapshotRequest* request, ::google::pubsub::v1::Snapshot* response, std::function<void(::grpc::Status)>) = 0;
      virtual void GetSnapshot(::grpc::ClientContext* context, const ::google::pubsub::v1::GetSnapshotRequest* request, ::google::pubsub::v1::Snapshot* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Lists the existing snapshots. Snapshots are used in [Seek](
      // https://cloud.google.com/pubsub/docs/replay-overview) operations, which
      // allow you to manage message acknowledgments in bulk. That is, you can set
      // the acknowledgment state of messages in an existing subscription to the
      // state captured by a snapshot.
      virtual void ListSnapshots(::grpc::ClientContext* context, const ::google::pubsub::v1::ListSnapshotsRequest* request, ::google::pubsub::v1::ListSnapshotsResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void ListSnapshots(::grpc::ClientContext* context, const ::google::pubsub::v1::ListSnapshotsRequest* request, ::google::pubsub::v1::ListSnapshotsResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Creates a snapshot from the requested subscription. Snapshots are used in
      // [Seek](https://cloud.google.com/pubsub/docs/replay-overview) operations,
      // which allow you to manage message acknowledgments in bulk. That is, you can
      // set the acknowledgment state of messages in an existing subscription to the
      // state captured by a snapshot.
      // If the snapshot already exists, returns `ALREADY_EXISTS`.
      // If the requested subscription doesn't exist, returns `NOT_FOUND`.
      // If the backlog in the subscription is too old -- and the resulting snapshot
      // would expire in less than 1 hour -- then `FAILED_PRECONDITION` is returned.
      // See also the `Snapshot.expire_time` field. If the name is not provided in
      // the request, the server will assign a random
      // name for this snapshot on the same project as the subscription, conforming
      // to the [resource name format]
      // (https://cloud.google.com/pubsub/docs/admin#resource_names). The
      // generated name is populated in the returned Snapshot object. Note that for
      // REST API requests, you must specify a name in the request.
      virtual void CreateSnapshot(::grpc::ClientContext* context, const ::google::pubsub::v1::CreateSnapshotRequest* request, ::google::pubsub::v1::Snapshot* response, std::function<void(::grpc::Status)>) = 0;
      virtual void CreateSnapshot(::grpc::ClientContext* context, const ::google::pubsub::v1::CreateSnapshotRequest* request, ::google::pubsub::v1::Snapshot* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Updates an existing snapshot. Snapshots are used in
      // <a href="https://cloud.google.com/pubsub/docs/replay-overview">Seek</a>
      // operations, which allow
      // you to manage message acknowledgments in bulk. That is, you can set the
      // acknowledgment state of messages in an existing subscription to the state
      // captured by a snapshot.
      virtual void UpdateSnapshot(::grpc::ClientContext* context, const ::google::pubsub::v1::UpdateSnapshotRequest* request, ::google::pubsub::v1::Snapshot* response, std::function<void(::grpc::Status)>) = 0;
      virtual void UpdateSnapshot(::grpc::ClientContext* context, const ::google::pubsub::v1::UpdateSnapshotRequest* request, ::google::pubsub::v1::Snapshot* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Removes an existing snapshot. Snapshots are used in [Seek]
      // (https://cloud.google.com/pubsub/docs/replay-overview) operations, which
      // allow you to manage message acknowledgments in bulk. That is, you can set
      // the acknowledgment state of messages in an existing subscription to the
      // state captured by a snapshot.
      // When the snapshot is deleted, all messages retained in the snapshot
      // are immediately dropped. After a snapshot is deleted, a new one may be
      // created with the same name, but the new one has no association with the old
      // snapshot or its subscription, unless the same subscription is specified.
      virtual void DeleteSnapshot(::grpc::ClientContext* context, const ::google::pubsub::v1::DeleteSnapshotRequest* request, ::google::protobuf::Empty* response, std::function<void(::grpc::Status)>) = 0;
      virtual void DeleteSnapshot(::grpc::ClientContext* context, const ::google::pubsub::v1::DeleteSnapshotRequest* request, ::google::protobuf::Empty* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Seeks an existing subscription to a point in time or to a given snapshot,
      // whichever is provided in the request. Snapshots are used in [Seek]
      // (https://cloud.google.com/pubsub/docs/replay-overview) operations, which
      // allow you to manage message acknowledgments in bulk. That is, you can set
      // the acknowledgment state of messages in an existing subscription to the
      // state captured by a snapshot. Note that both the subscription and the
      // snapshot must be on the same topic.
      virtual void Seek(::grpc::ClientContext* context, const ::google::pubsub::v1::SeekRequest* request, ::google::pubsub::v1::SeekResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void Seek(::grpc::ClientContext* context, const ::google::pubsub::v1::SeekRequest* request, ::google::pubsub::v1::SeekResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
    };
    typedef class async_interface experimental_async_interface;
    virtual class async_interface* async() { return nullptr; }
    class async_interface* experimental_async() { return async(); }
   private:
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::Subscription>* AsyncCreateSubscriptionRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::Subscription& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::Subscription>* PrepareAsyncCreateSubscriptionRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::Subscription& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::Subscription>* AsyncGetSubscriptionRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::GetSubscriptionRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::Subscription>* PrepareAsyncGetSubscriptionRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::GetSubscriptionRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::Subscription>* AsyncUpdateSubscriptionRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::UpdateSubscriptionRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::Subscription>* PrepareAsyncUpdateSubscriptionRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::UpdateSubscriptionRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::ListSubscriptionsResponse>* AsyncListSubscriptionsRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::ListSubscriptionsRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::ListSubscriptionsResponse>* PrepareAsyncListSubscriptionsRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::ListSubscriptionsRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>* AsyncDeleteSubscriptionRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::DeleteSubscriptionRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>* PrepareAsyncDeleteSubscriptionRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::DeleteSubscriptionRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>* AsyncModifyAckDeadlineRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::ModifyAckDeadlineRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>* PrepareAsyncModifyAckDeadlineRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::ModifyAckDeadlineRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>* AsyncAcknowledgeRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::AcknowledgeRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>* PrepareAsyncAcknowledgeRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::AcknowledgeRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::PullResponse>* AsyncPullRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::PullRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::PullResponse>* PrepareAsyncPullRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::PullRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientReaderWriterInterface< ::google::pubsub::v1::StreamingPullRequest, ::google::pubsub::v1::StreamingPullResponse>* StreamingPullRaw(::grpc::ClientContext* context) = 0;
    virtual ::grpc::ClientAsyncReaderWriterInterface< ::google::pubsub::v1::StreamingPullRequest, ::google::pubsub::v1::StreamingPullResponse>* AsyncStreamingPullRaw(::grpc::ClientContext* context, ::grpc::CompletionQueue* cq, void* tag) = 0;
    virtual ::grpc::ClientAsyncReaderWriterInterface< ::google::pubsub::v1::StreamingPullRequest, ::google::pubsub::v1::StreamingPullResponse>* PrepareAsyncStreamingPullRaw(::grpc::ClientContext* context, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>* AsyncModifyPushConfigRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::ModifyPushConfigRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>* PrepareAsyncModifyPushConfigRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::ModifyPushConfigRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::Snapshot>* AsyncGetSnapshotRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::GetSnapshotRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::Snapshot>* PrepareAsyncGetSnapshotRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::GetSnapshotRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::ListSnapshotsResponse>* AsyncListSnapshotsRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::ListSnapshotsRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::ListSnapshotsResponse>* PrepareAsyncListSnapshotsRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::ListSnapshotsRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::Snapshot>* AsyncCreateSnapshotRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::CreateSnapshotRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::Snapshot>* PrepareAsyncCreateSnapshotRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::CreateSnapshotRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::Snapshot>* AsyncUpdateSnapshotRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::UpdateSnapshotRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::Snapshot>* PrepareAsyncUpdateSnapshotRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::UpdateSnapshotRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>* AsyncDeleteSnapshotRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::DeleteSnapshotRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>* PrepareAsyncDeleteSnapshotRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::DeleteSnapshotRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::SeekResponse>* AsyncSeekRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::SeekRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::pubsub::v1::SeekResponse>* PrepareAsyncSeekRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::SeekRequest& request, ::grpc::CompletionQueue* cq) = 0;
  };
  class Stub final : public StubInterface {
   public:
    Stub(const std::shared_ptr< ::grpc::ChannelInterface>& channel, const ::grpc::StubOptions& options = ::grpc::StubOptions());
    ::grpc::Status CreateSubscription(::grpc::ClientContext* context, const ::google::pubsub::v1::Subscription& request, ::google::pubsub::v1::Subscription* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::Subscription>> AsyncCreateSubscription(::grpc::ClientContext* context, const ::google::pubsub::v1::Subscription& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::Subscription>>(AsyncCreateSubscriptionRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::Subscription>> PrepareAsyncCreateSubscription(::grpc::ClientContext* context, const ::google::pubsub::v1::Subscription& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::Subscription>>(PrepareAsyncCreateSubscriptionRaw(context, request, cq));
    }
    ::grpc::Status GetSubscription(::grpc::ClientContext* context, const ::google::pubsub::v1::GetSubscriptionRequest& request, ::google::pubsub::v1::Subscription* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::Subscription>> AsyncGetSubscription(::grpc::ClientContext* context, const ::google::pubsub::v1::GetSubscriptionRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::Subscription>>(AsyncGetSubscriptionRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::Subscription>> PrepareAsyncGetSubscription(::grpc::ClientContext* context, const ::google::pubsub::v1::GetSubscriptionRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::Subscription>>(PrepareAsyncGetSubscriptionRaw(context, request, cq));
    }
    ::grpc::Status UpdateSubscription(::grpc::ClientContext* context, const ::google::pubsub::v1::UpdateSubscriptionRequest& request, ::google::pubsub::v1::Subscription* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::Subscription>> AsyncUpdateSubscription(::grpc::ClientContext* context, const ::google::pubsub::v1::UpdateSubscriptionRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::Subscription>>(AsyncUpdateSubscriptionRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::Subscription>> PrepareAsyncUpdateSubscription(::grpc::ClientContext* context, const ::google::pubsub::v1::UpdateSubscriptionRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::Subscription>>(PrepareAsyncUpdateSubscriptionRaw(context, request, cq));
    }
    ::grpc::Status ListSubscriptions(::grpc::ClientContext* context, const ::google::pubsub::v1::ListSubscriptionsRequest& request, ::google::pubsub::v1::ListSubscriptionsResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::ListSubscriptionsResponse>> AsyncListSubscriptions(::grpc::ClientContext* context, const ::google::pubsub::v1::ListSubscriptionsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::ListSubscriptionsResponse>>(AsyncListSubscriptionsRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::ListSubscriptionsResponse>> PrepareAsyncListSubscriptions(::grpc::ClientContext* context, const ::google::pubsub::v1::ListSubscriptionsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::ListSubscriptionsResponse>>(PrepareAsyncListSubscriptionsRaw(context, request, cq));
    }
    ::grpc::Status DeleteSubscription(::grpc::ClientContext* context, const ::google::pubsub::v1::DeleteSubscriptionRequest& request, ::google::protobuf::Empty* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>> AsyncDeleteSubscription(::grpc::ClientContext* context, const ::google::pubsub::v1::DeleteSubscriptionRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>>(AsyncDeleteSubscriptionRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>> PrepareAsyncDeleteSubscription(::grpc::ClientContext* context, const ::google::pubsub::v1::DeleteSubscriptionRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>>(PrepareAsyncDeleteSubscriptionRaw(context, request, cq));
    }
    ::grpc::Status ModifyAckDeadline(::grpc::ClientContext* context, const ::google::pubsub::v1::ModifyAckDeadlineRequest& request, ::google::protobuf::Empty* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>> AsyncModifyAckDeadline(::grpc::ClientContext* context, const ::google::pubsub::v1::ModifyAckDeadlineRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>>(AsyncModifyAckDeadlineRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>> PrepareAsyncModifyAckDeadline(::grpc::ClientContext* context, const ::google::pubsub::v1::ModifyAckDeadlineRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>>(PrepareAsyncModifyAckDeadlineRaw(context, request, cq));
    }
    ::grpc::Status Acknowledge(::grpc::ClientContext* context, const ::google::pubsub::v1::AcknowledgeRequest& request, ::google::protobuf::Empty* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>> AsyncAcknowledge(::grpc::ClientContext* context, const ::google::pubsub::v1::AcknowledgeRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>>(AsyncAcknowledgeRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>> PrepareAsyncAcknowledge(::grpc::ClientContext* context, const ::google::pubsub::v1::AcknowledgeRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>>(PrepareAsyncAcknowledgeRaw(context, request, cq));
    }
    ::grpc::Status Pull(::grpc::ClientContext* context, const ::google::pubsub::v1::PullRequest& request, ::google::pubsub::v1::PullResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::PullResponse>> AsyncPull(::grpc::ClientContext* context, const ::google::pubsub::v1::PullRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::PullResponse>>(AsyncPullRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::PullResponse>> PrepareAsyncPull(::grpc::ClientContext* context, const ::google::pubsub::v1::PullRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::PullResponse>>(PrepareAsyncPullRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientReaderWriter< ::google::pubsub::v1::StreamingPullRequest, ::google::pubsub::v1::StreamingPullResponse>> StreamingPull(::grpc::ClientContext* context) {
      return std::unique_ptr< ::grpc::ClientReaderWriter< ::google::pubsub::v1::StreamingPullRequest, ::google::pubsub::v1::StreamingPullResponse>>(StreamingPullRaw(context));
    }
    std::unique_ptr<  ::grpc::ClientAsyncReaderWriter< ::google::pubsub::v1::StreamingPullRequest, ::google::pubsub::v1::StreamingPullResponse>> AsyncStreamingPull(::grpc::ClientContext* context, ::grpc::CompletionQueue* cq, void* tag) {
      return std::unique_ptr< ::grpc::ClientAsyncReaderWriter< ::google::pubsub::v1::StreamingPullRequest, ::google::pubsub::v1::StreamingPullResponse>>(AsyncStreamingPullRaw(context, cq, tag));
    }
    std::unique_ptr<  ::grpc::ClientAsyncReaderWriter< ::google::pubsub::v1::StreamingPullRequest, ::google::pubsub::v1::StreamingPullResponse>> PrepareAsyncStreamingPull(::grpc::ClientContext* context, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncReaderWriter< ::google::pubsub::v1::StreamingPullRequest, ::google::pubsub::v1::StreamingPullResponse>>(PrepareAsyncStreamingPullRaw(context, cq));
    }
    ::grpc::Status ModifyPushConfig(::grpc::ClientContext* context, const ::google::pubsub::v1::ModifyPushConfigRequest& request, ::google::protobuf::Empty* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>> AsyncModifyPushConfig(::grpc::ClientContext* context, const ::google::pubsub::v1::ModifyPushConfigRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>>(AsyncModifyPushConfigRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>> PrepareAsyncModifyPushConfig(::grpc::ClientContext* context, const ::google::pubsub::v1::ModifyPushConfigRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>>(PrepareAsyncModifyPushConfigRaw(context, request, cq));
    }
    ::grpc::Status GetSnapshot(::grpc::ClientContext* context, const ::google::pubsub::v1::GetSnapshotRequest& request, ::google::pubsub::v1::Snapshot* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::Snapshot>> AsyncGetSnapshot(::grpc::ClientContext* context, const ::google::pubsub::v1::GetSnapshotRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::Snapshot>>(AsyncGetSnapshotRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::Snapshot>> PrepareAsyncGetSnapshot(::grpc::ClientContext* context, const ::google::pubsub::v1::GetSnapshotRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::Snapshot>>(PrepareAsyncGetSnapshotRaw(context, request, cq));
    }
    ::grpc::Status ListSnapshots(::grpc::ClientContext* context, const ::google::pubsub::v1::ListSnapshotsRequest& request, ::google::pubsub::v1::ListSnapshotsResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::ListSnapshotsResponse>> AsyncListSnapshots(::grpc::ClientContext* context, const ::google::pubsub::v1::ListSnapshotsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::ListSnapshotsResponse>>(AsyncListSnapshotsRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::ListSnapshotsResponse>> PrepareAsyncListSnapshots(::grpc::ClientContext* context, const ::google::pubsub::v1::ListSnapshotsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::ListSnapshotsResponse>>(PrepareAsyncListSnapshotsRaw(context, request, cq));
    }
    ::grpc::Status CreateSnapshot(::grpc::ClientContext* context, const ::google::pubsub::v1::CreateSnapshotRequest& request, ::google::pubsub::v1::Snapshot* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::Snapshot>> AsyncCreateSnapshot(::grpc::ClientContext* context, const ::google::pubsub::v1::CreateSnapshotRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::Snapshot>>(AsyncCreateSnapshotRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::Snapshot>> PrepareAsyncCreateSnapshot(::grpc::ClientContext* context, const ::google::pubsub::v1::CreateSnapshotRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::Snapshot>>(PrepareAsyncCreateSnapshotRaw(context, request, cq));
    }
    ::grpc::Status UpdateSnapshot(::grpc::ClientContext* context, const ::google::pubsub::v1::UpdateSnapshotRequest& request, ::google::pubsub::v1::Snapshot* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::Snapshot>> AsyncUpdateSnapshot(::grpc::ClientContext* context, const ::google::pubsub::v1::UpdateSnapshotRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::Snapshot>>(AsyncUpdateSnapshotRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::Snapshot>> PrepareAsyncUpdateSnapshot(::grpc::ClientContext* context, const ::google::pubsub::v1::UpdateSnapshotRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::Snapshot>>(PrepareAsyncUpdateSnapshotRaw(context, request, cq));
    }
    ::grpc::Status DeleteSnapshot(::grpc::ClientContext* context, const ::google::pubsub::v1::DeleteSnapshotRequest& request, ::google::protobuf::Empty* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>> AsyncDeleteSnapshot(::grpc::ClientContext* context, const ::google::pubsub::v1::DeleteSnapshotRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>>(AsyncDeleteSnapshotRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>> PrepareAsyncDeleteSnapshot(::grpc::ClientContext* context, const ::google::pubsub::v1::DeleteSnapshotRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>>(PrepareAsyncDeleteSnapshotRaw(context, request, cq));
    }
    ::grpc::Status Seek(::grpc::ClientContext* context, const ::google::pubsub::v1::SeekRequest& request, ::google::pubsub::v1::SeekResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::SeekResponse>> AsyncSeek(::grpc::ClientContext* context, const ::google::pubsub::v1::SeekRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::SeekResponse>>(AsyncSeekRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::SeekResponse>> PrepareAsyncSeek(::grpc::ClientContext* context, const ::google::pubsub::v1::SeekRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::SeekResponse>>(PrepareAsyncSeekRaw(context, request, cq));
    }
    class async final :
      public StubInterface::async_interface {
     public:
      void CreateSubscription(::grpc::ClientContext* context, const ::google::pubsub::v1::Subscription* request, ::google::pubsub::v1::Subscription* response, std::function<void(::grpc::Status)>) override;
      void CreateSubscription(::grpc::ClientContext* context, const ::google::pubsub::v1::Subscription* request, ::google::pubsub::v1::Subscription* response, ::grpc::ClientUnaryReactor* reactor) override;
      void GetSubscription(::grpc::ClientContext* context, const ::google::pubsub::v1::GetSubscriptionRequest* request, ::google::pubsub::v1::Subscription* response, std::function<void(::grpc::Status)>) override;
      void GetSubscription(::grpc::ClientContext* context, const ::google::pubsub::v1::GetSubscriptionRequest* request, ::google::pubsub::v1::Subscription* response, ::grpc::ClientUnaryReactor* reactor) override;
      void UpdateSubscription(::grpc::ClientContext* context, const ::google::pubsub::v1::UpdateSubscriptionRequest* request, ::google::pubsub::v1::Subscription* response, std::function<void(::grpc::Status)>) override;
      void UpdateSubscription(::grpc::ClientContext* context, const ::google::pubsub::v1::UpdateSubscriptionRequest* request, ::google::pubsub::v1::Subscription* response, ::grpc::ClientUnaryReactor* reactor) override;
      void ListSubscriptions(::grpc::ClientContext* context, const ::google::pubsub::v1::ListSubscriptionsRequest* request, ::google::pubsub::v1::ListSubscriptionsResponse* response, std::function<void(::grpc::Status)>) override;
      void ListSubscriptions(::grpc::ClientContext* context, const ::google::pubsub::v1::ListSubscriptionsRequest* request, ::google::pubsub::v1::ListSubscriptionsResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
      void DeleteSubscription(::grpc::ClientContext* context, const ::google::pubsub::v1::DeleteSubscriptionRequest* request, ::google::protobuf::Empty* response, std::function<void(::grpc::Status)>) override;
      void DeleteSubscription(::grpc::ClientContext* context, const ::google::pubsub::v1::DeleteSubscriptionRequest* request, ::google::protobuf::Empty* response, ::grpc::ClientUnaryReactor* reactor) override;
      void ModifyAckDeadline(::grpc::ClientContext* context, const ::google::pubsub::v1::ModifyAckDeadlineRequest* request, ::google::protobuf::Empty* response, std::function<void(::grpc::Status)>) override;
      void ModifyAckDeadline(::grpc::ClientContext* context, const ::google::pubsub::v1::ModifyAckDeadlineRequest* request, ::google::protobuf::Empty* response, ::grpc::ClientUnaryReactor* reactor) override;
      void Acknowledge(::grpc::ClientContext* context, const ::google::pubsub::v1::AcknowledgeRequest* request, ::google::protobuf::Empty* response, std::function<void(::grpc::Status)>) override;
      void Acknowledge(::grpc::ClientContext* context, const ::google::pubsub::v1::AcknowledgeRequest* request, ::google::protobuf::Empty* response, ::grpc::ClientUnaryReactor* reactor) override;
      void Pull(::grpc::ClientContext* context, const ::google::pubsub::v1::PullRequest* request, ::google::pubsub::v1::PullResponse* response, std::function<void(::grpc::Status)>) override;
      void Pull(::grpc::ClientContext* context, const ::google::pubsub::v1::PullRequest* request, ::google::pubsub::v1::PullResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
      void StreamingPull(::grpc::ClientContext* context, ::grpc::ClientBidiReactor< ::google::pubsub::v1::StreamingPullRequest,::google::pubsub::v1::StreamingPullResponse>* reactor) override;
      void ModifyPushConfig(::grpc::ClientContext* context, const ::google::pubsub::v1::ModifyPushConfigRequest* request, ::google::protobuf::Empty* response, std::function<void(::grpc::Status)>) override;
      void ModifyPushConfig(::grpc::ClientContext* context, const ::google::pubsub::v1::ModifyPushConfigRequest* request, ::google::protobuf::Empty* response, ::grpc::ClientUnaryReactor* reactor) override;
      void GetSnapshot(::grpc::ClientContext* context, const ::google::pubsub::v1::GetSnapshotRequest* request, ::google::pubsub::v1::Snapshot* response, std::function<void(::grpc::Status)>) override;
      void GetSnapshot(::grpc::ClientContext* context, const ::google::pubsub::v1::GetSnapshotRequest* request, ::google::pubsub::v1::Snapshot* response, ::grpc::ClientUnaryReactor* reactor) override;
      void ListSnapshots(::grpc::ClientContext* context, const ::google::pubsub::v1::ListSnapshotsRequest* request, ::google::pubsub::v1::ListSnapshotsResponse* response, std::function<void(::grpc::Status)>) override;
      void ListSnapshots(::grpc::ClientContext* context, const ::google::pubsub::v1::ListSnapshotsRequest* request, ::google::pubsub::v1::ListSnapshotsResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
      void CreateSnapshot(::grpc::ClientContext* context, const ::google::pubsub::v1::CreateSnapshotRequest* request, ::google::pubsub::v1::Snapshot* response, std::function<void(::grpc::Status)>) override;
      void CreateSnapshot(::grpc::ClientContext* context, const ::google::pubsub::v1::CreateSnapshotRequest* request, ::google::pubsub::v1::Snapshot* response, ::grpc::ClientUnaryReactor* reactor) override;
      void UpdateSnapshot(::grpc::ClientContext* context, const ::google::pubsub::v1::UpdateSnapshotRequest* request, ::google::pubsub::v1::Snapshot* response, std::function<void(::grpc::Status)>) override;
      void UpdateSnapshot(::grpc::ClientContext* context, const ::google::pubsub::v1::UpdateSnapshotRequest* request, ::google::pubsub::v1::Snapshot* response, ::grpc::ClientUnaryReactor* reactor) override;
      void DeleteSnapshot(::grpc::ClientContext* context, const ::google::pubsub::v1::DeleteSnapshotRequest* request, ::google::protobuf::Empty* response, std::function<void(::grpc::Status)>) override;
      void DeleteSnapshot(::grpc::ClientContext* context, const ::google::pubsub::v1::DeleteSnapshotRequest* request, ::google::protobuf::Empty* response, ::grpc::ClientUnaryReactor* reactor) override;
      void Seek(::grpc::ClientContext* context, const ::google::pubsub::v1::SeekRequest* request, ::google::pubsub::v1::SeekResponse* response, std::function<void(::grpc::Status)>) override;
      void Seek(::grpc::ClientContext* context, const ::google::pubsub::v1::SeekRequest* request, ::google::pubsub::v1::SeekResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
     private:
      friend class Stub;
      explicit async(Stub* stub): stub_(stub) { }
      Stub* stub() { return stub_; }
      Stub* stub_;
    };
    class async* async() override { return &async_stub_; }

   private:
    std::shared_ptr< ::grpc::ChannelInterface> channel_;
    class async async_stub_{this};
    ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::Subscription>* AsyncCreateSubscriptionRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::Subscription& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::Subscription>* PrepareAsyncCreateSubscriptionRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::Subscription& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::Subscription>* AsyncGetSubscriptionRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::GetSubscriptionRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::Subscription>* PrepareAsyncGetSubscriptionRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::GetSubscriptionRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::Subscription>* AsyncUpdateSubscriptionRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::UpdateSubscriptionRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::Subscription>* PrepareAsyncUpdateSubscriptionRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::UpdateSubscriptionRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::ListSubscriptionsResponse>* AsyncListSubscriptionsRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::ListSubscriptionsRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::ListSubscriptionsResponse>* PrepareAsyncListSubscriptionsRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::ListSubscriptionsRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>* AsyncDeleteSubscriptionRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::DeleteSubscriptionRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>* PrepareAsyncDeleteSubscriptionRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::DeleteSubscriptionRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>* AsyncModifyAckDeadlineRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::ModifyAckDeadlineRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>* PrepareAsyncModifyAckDeadlineRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::ModifyAckDeadlineRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>* AsyncAcknowledgeRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::AcknowledgeRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>* PrepareAsyncAcknowledgeRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::AcknowledgeRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::PullResponse>* AsyncPullRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::PullRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::PullResponse>* PrepareAsyncPullRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::PullRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientReaderWriter< ::google::pubsub::v1::StreamingPullRequest, ::google::pubsub::v1::StreamingPullResponse>* StreamingPullRaw(::grpc::ClientContext* context) override;
    ::grpc::ClientAsyncReaderWriter< ::google::pubsub::v1::StreamingPullRequest, ::google::pubsub::v1::StreamingPullResponse>* AsyncStreamingPullRaw(::grpc::ClientContext* context, ::grpc::CompletionQueue* cq, void* tag) override;
    ::grpc::ClientAsyncReaderWriter< ::google::pubsub::v1::StreamingPullRequest, ::google::pubsub::v1::StreamingPullResponse>* PrepareAsyncStreamingPullRaw(::grpc::ClientContext* context, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>* AsyncModifyPushConfigRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::ModifyPushConfigRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>* PrepareAsyncModifyPushConfigRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::ModifyPushConfigRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::Snapshot>* AsyncGetSnapshotRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::GetSnapshotRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::Snapshot>* PrepareAsyncGetSnapshotRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::GetSnapshotRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::ListSnapshotsResponse>* AsyncListSnapshotsRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::ListSnapshotsRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::ListSnapshotsResponse>* PrepareAsyncListSnapshotsRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::ListSnapshotsRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::Snapshot>* AsyncCreateSnapshotRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::CreateSnapshotRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::Snapshot>* PrepareAsyncCreateSnapshotRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::CreateSnapshotRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::Snapshot>* AsyncUpdateSnapshotRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::UpdateSnapshotRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::Snapshot>* PrepareAsyncUpdateSnapshotRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::UpdateSnapshotRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>* AsyncDeleteSnapshotRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::DeleteSnapshotRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>* PrepareAsyncDeleteSnapshotRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::DeleteSnapshotRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::SeekResponse>* AsyncSeekRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::SeekRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::pubsub::v1::SeekResponse>* PrepareAsyncSeekRaw(::grpc::ClientContext* context, const ::google::pubsub::v1::SeekRequest& request, ::grpc::CompletionQueue* cq) override;
    const ::grpc::internal::RpcMethod rpcmethod_CreateSubscription_;
    const ::grpc::internal::RpcMethod rpcmethod_GetSubscription_;
    const ::grpc::internal::RpcMethod rpcmethod_UpdateSubscription_;
    const ::grpc::internal::RpcMethod rpcmethod_ListSubscriptions_;
    const ::grpc::internal::RpcMethod rpcmethod_DeleteSubscription_;
    const ::grpc::internal::RpcMethod rpcmethod_ModifyAckDeadline_;
    const ::grpc::internal::RpcMethod rpcmethod_Acknowledge_;
    const ::grpc::internal::RpcMethod rpcmethod_Pull_;
    const ::grpc::internal::RpcMethod rpcmethod_StreamingPull_;
    const ::grpc::internal::RpcMethod rpcmethod_ModifyPushConfig_;
    const ::grpc::internal::RpcMethod rpcmethod_GetSnapshot_;
    const ::grpc::internal::RpcMethod rpcmethod_ListSnapshots_;
    const ::grpc::internal::RpcMethod rpcmethod_CreateSnapshot_;
    const ::grpc::internal::RpcMethod rpcmethod_UpdateSnapshot_;
    const ::grpc::internal::RpcMethod rpcmethod_DeleteSnapshot_;
    const ::grpc::internal::RpcMethod rpcmethod_Seek_;
  };
  static std::unique_ptr<Stub> NewStub(const std::shared_ptr< ::grpc::ChannelInterface>& channel, const ::grpc::StubOptions& options = ::grpc::StubOptions());

  class Service : public ::grpc::Service {
   public:
    Service();
    virtual ~Service();
    // Creates a subscription to a given topic. See the [resource name rules]
    // (https://cloud.google.com/pubsub/docs/admin#resource_names).
    // If the subscription already exists, returns `ALREADY_EXISTS`.
    // If the corresponding topic doesn't exist, returns `NOT_FOUND`.
    //
    // If the name is not provided in the request, the server will assign a random
    // name for this subscription on the same project as the topic, conforming
    // to the [resource name format]
    // (https://cloud.google.com/pubsub/docs/admin#resource_names). The generated
    // name is populated in the returned Subscription object. Note that for REST
    // API requests, you must specify a name in the request.
    virtual ::grpc::Status CreateSubscription(::grpc::ServerContext* context, const ::google::pubsub::v1::Subscription* request, ::google::pubsub::v1::Subscription* response);
    // Gets the configuration details of a subscription.
    virtual ::grpc::Status GetSubscription(::grpc::ServerContext* context, const ::google::pubsub::v1::GetSubscriptionRequest* request, ::google::pubsub::v1::Subscription* response);
    // Updates an existing subscription. Note that certain properties of a
    // subscription, such as its topic, are not modifiable.
    virtual ::grpc::Status UpdateSubscription(::grpc::ServerContext* context, const ::google::pubsub::v1::UpdateSubscriptionRequest* request, ::google::pubsub::v1::Subscription* response);
    // Lists matching subscriptions.
    virtual ::grpc::Status ListSubscriptions(::grpc::ServerContext* context, const ::google::pubsub::v1::ListSubscriptionsRequest* request, ::google::pubsub::v1::ListSubscriptionsResponse* response);
    // Deletes an existing subscription. All messages retained in the subscription
    // are immediately dropped. Calls to `Pull` after deletion will return
    // `NOT_FOUND`. After a subscription is deleted, a new one may be created with
    // the same name, but the new one has no association with the old
    // subscription or its topic unless the same topic is specified.
    virtual ::grpc::Status DeleteSubscription(::grpc::ServerContext* context, const ::google::pubsub::v1::DeleteSubscriptionRequest* request, ::google::protobuf::Empty* response);
    // Modifies the ack deadline for a specific message. This method is useful
    // to indicate that more time is needed to process a message by the
    // subscriber, or to make the message available for redelivery if the
    // processing was interrupted. Note that this does not modify the
    // subscription-level `ackDeadlineSeconds` used for subsequent messages.
    virtual ::grpc::Status ModifyAckDeadline(::grpc::ServerContext* context, const ::google::pubsub::v1::ModifyAckDeadlineRequest* request, ::google::protobuf::Empty* response);
    // Acknowledges the messages associated with the `ack_ids` in the
    // `AcknowledgeRequest`. The Pub/Sub system can remove the relevant messages
    // from the subscription.
    //
    // Acknowledging a message whose ack deadline has expired may succeed,
    // but such a message may be redelivered later. Acknowledging a message more
    // than once will not result in an error.
    virtual ::grpc::Status Acknowledge(::grpc::ServerContext* context, const ::google::pubsub::v1::AcknowledgeRequest* request, ::google::protobuf::Empty* response);
    // Pulls messages from the server. The server may return `UNAVAILABLE` if
    // there are too many concurrent pull requests pending for the given
    // subscription.
    virtual ::grpc::Status Pull(::grpc::ServerContext* context, const ::google::pubsub::v1::PullRequest* request, ::google::pubsub::v1::PullResponse* response);
    // Establishes a stream with the server, which sends messages down to the
    // client. The client streams acknowledgements and ack deadline modifications
    // back to the server. The server will close the stream and return the status
    // on any error. The server may close the stream with status `UNAVAILABLE` to
    // reassign server-side resources, in which case, the client should
    // re-establish the stream. Flow control can be achieved by configuring the
    // underlying RPC channel.
    virtual ::grpc::Status StreamingPull(::grpc::ServerContext* context, ::grpc::ServerReaderWriter< ::google::pubsub::v1::StreamingPullResponse, ::google::pubsub::v1::StreamingPullRequest>* stream);
    // Modifies the `PushConfig` for a specified subscription.
    //
    // This may be used to change a push subscription to a pull one (signified by
    // an empty `PushConfig`) or vice versa, or change the endpoint URL and other
    // attributes of a push subscription. Messages will accumulate for delivery
    // continuously through the call regardless of changes to the `PushConfig`.
    virtual ::grpc::Status ModifyPushConfig(::grpc::ServerContext* context, const ::google::pubsub::v1::ModifyPushConfigRequest* request, ::google::protobuf::Empty* response);
    // Gets the configuration details of a snapshot. Snapshots are used in
    // <a href="https://cloud.google.com/pubsub/docs/replay-overview">Seek</a>
    // operations, which allow you to manage message acknowledgments in bulk. That
    // is, you can set the acknowledgment state of messages in an existing
    // subscription to the state captured by a snapshot.
    virtual ::grpc::Status GetSnapshot(::grpc::ServerContext* context, const ::google::pubsub::v1::GetSnapshotRequest* request, ::google::pubsub::v1::Snapshot* response);
    // Lists the existing snapshots. Snapshots are used in [Seek](
    // https://cloud.google.com/pubsub/docs/replay-overview) operations, which
    // allow you to manage message acknowledgments in bulk. That is, you can set
    // the acknowledgment state of messages in an existing subscription to the
    // state captured by a snapshot.
    virtual ::grpc::Status ListSnapshots(::grpc::ServerContext* context, const ::google::pubsub::v1::ListSnapshotsRequest* request, ::google::pubsub::v1::ListSnapshotsResponse* response);
    // Creates a snapshot from the requested subscription. Snapshots are used in
    // [Seek](https://cloud.google.com/pubsub/docs/replay-overview) operations,
    // which allow you to manage message acknowledgments in bulk. That is, you can
    // set the acknowledgment state of messages in an existing subscription to the
    // state captured by a snapshot.
    // If the snapshot already exists, returns `ALREADY_EXISTS`.
    // If the requested subscription doesn't exist, returns `NOT_FOUND`.
    // If the backlog in the subscription is too old -- and the resulting snapshot
    // would expire in less than 1 hour -- then `FAILED_PRECONDITION` is returned.
    // See also the `Snapshot.expire_time` field. If the name is not provided in
    // the request, the server will assign a random
    // name for this snapshot on the same project as the subscription, conforming
    // to the [resource name format]
    // (https://cloud.google.com/pubsub/docs/admin#resource_names). The
    // generated name is populated in the returned Snapshot object. Note that for
    // REST API requests, you must specify a name in the request.
    virtual ::grpc::Status CreateSnapshot(::grpc::ServerContext* context, const ::google::pubsub::v1::CreateSnapshotRequest* request, ::google::pubsub::v1::Snapshot* response);
    // Updates an existing snapshot. Snapshots are used in
    // <a href="https://cloud.google.com/pubsub/docs/replay-overview">Seek</a>
    // operations, which allow
    // you to manage message acknowledgments in bulk. That is, you can set the
    // acknowledgment state of messages in an existing subscription to the state
    // captured by a snapshot.
    virtual ::grpc::Status UpdateSnapshot(::grpc::ServerContext* context, const ::google::pubsub::v1::UpdateSnapshotRequest* request, ::google::pubsub::v1::Snapshot* response);
    // Removes an existing snapshot. Snapshots are used in [Seek]
    // (https://cloud.google.com/pubsub/docs/replay-overview) operations, which
    // allow you to manage message acknowledgments in bulk. That is, you can set
    // the acknowledgment state of messages in an existing subscription to the
    // state captured by a snapshot.
    // When the snapshot is deleted, all messages retained in the snapshot
    // are immediately dropped. After a snapshot is deleted, a new one may be
    // created with the same name, but the new one has no association with the old
    // snapshot or its subscription, unless the same subscription is specified.
    virtual ::grpc::Status DeleteSnapshot(::grpc::ServerContext* context, const ::google::pubsub::v1::DeleteSnapshotRequest* request, ::google::protobuf::Empty* response);
    // Seeks an existing subscription to a point in time or to a given snapshot,
    // whichever is provided in the request. Snapshots are used in [Seek]
    // (https://cloud.google.com/pubsub/docs/replay-overview) operations, which
    // allow you to manage message acknowledgments in bulk. That is, you can set
    // the acknowledgment state of messages in an existing subscription to the
    // state captured by a snapshot. Note that both the subscription and the
    // snapshot must be on the same topic.
    virtual ::grpc::Status Seek(::grpc::ServerContext* context, const ::google::pubsub::v1::SeekRequest* request, ::google::pubsub::v1::SeekResponse* response);
  };
  template <class BaseClass>
  class WithAsyncMethod_CreateSubscription : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_CreateSubscription() {
      ::grpc::Service::MarkMethodAsync(0);
    }
    ~WithAsyncMethod_CreateSubscription() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateSubscription(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::Subscription* /*request*/, ::google::pubsub::v1::Subscription* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestCreateSubscription(::grpc::ServerContext* context, ::google::pubsub::v1::Subscription* request, ::grpc::ServerAsyncResponseWriter< ::google::pubsub::v1::Subscription>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(0, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_GetSubscription : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_GetSubscription() {
      ::grpc::Service::MarkMethodAsync(1);
    }
    ~WithAsyncMethod_GetSubscription() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetSubscription(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::GetSubscriptionRequest* /*request*/, ::google::pubsub::v1::Subscription* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGetSubscription(::grpc::ServerContext* context, ::google::pubsub::v1::GetSubscriptionRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::pubsub::v1::Subscription>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(1, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_UpdateSubscription : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_UpdateSubscription() {
      ::grpc::Service::MarkMethodAsync(2);
    }
    ~WithAsyncMethod_UpdateSubscription() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateSubscription(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::UpdateSubscriptionRequest* /*request*/, ::google::pubsub::v1::Subscription* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestUpdateSubscription(::grpc::ServerContext* context, ::google::pubsub::v1::UpdateSubscriptionRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::pubsub::v1::Subscription>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(2, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_ListSubscriptions : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_ListSubscriptions() {
      ::grpc::Service::MarkMethodAsync(3);
    }
    ~WithAsyncMethod_ListSubscriptions() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListSubscriptions(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::ListSubscriptionsRequest* /*request*/, ::google::pubsub::v1::ListSubscriptionsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestListSubscriptions(::grpc::ServerContext* context, ::google::pubsub::v1::ListSubscriptionsRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::pubsub::v1::ListSubscriptionsResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(3, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_DeleteSubscription : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_DeleteSubscription() {
      ::grpc::Service::MarkMethodAsync(4);
    }
    ~WithAsyncMethod_DeleteSubscription() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteSubscription(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::DeleteSubscriptionRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestDeleteSubscription(::grpc::ServerContext* context, ::google::pubsub::v1::DeleteSubscriptionRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::protobuf::Empty>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(4, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_ModifyAckDeadline : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_ModifyAckDeadline() {
      ::grpc::Service::MarkMethodAsync(5);
    }
    ~WithAsyncMethod_ModifyAckDeadline() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ModifyAckDeadline(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::ModifyAckDeadlineRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestModifyAckDeadline(::grpc::ServerContext* context, ::google::pubsub::v1::ModifyAckDeadlineRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::protobuf::Empty>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(5, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_Acknowledge : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_Acknowledge() {
      ::grpc::Service::MarkMethodAsync(6);
    }
    ~WithAsyncMethod_Acknowledge() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Acknowledge(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::AcknowledgeRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestAcknowledge(::grpc::ServerContext* context, ::google::pubsub::v1::AcknowledgeRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::protobuf::Empty>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(6, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_Pull : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_Pull() {
      ::grpc::Service::MarkMethodAsync(7);
    }
    ~WithAsyncMethod_Pull() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Pull(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::PullRequest* /*request*/, ::google::pubsub::v1::PullResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestPull(::grpc::ServerContext* context, ::google::pubsub::v1::PullRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::pubsub::v1::PullResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(7, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_StreamingPull : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_StreamingPull() {
      ::grpc::Service::MarkMethodAsync(8);
    }
    ~WithAsyncMethod_StreamingPull() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status StreamingPull(::grpc::ServerContext* /*context*/, ::grpc::ServerReaderWriter< ::google::pubsub::v1::StreamingPullResponse, ::google::pubsub::v1::StreamingPullRequest>* /*stream*/)  override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestStreamingPull(::grpc::ServerContext* context, ::grpc::ServerAsyncReaderWriter< ::google::pubsub::v1::StreamingPullResponse, ::google::pubsub::v1::StreamingPullRequest>* stream, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncBidiStreaming(8, context, stream, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_ModifyPushConfig : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_ModifyPushConfig() {
      ::grpc::Service::MarkMethodAsync(9);
    }
    ~WithAsyncMethod_ModifyPushConfig() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ModifyPushConfig(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::ModifyPushConfigRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestModifyPushConfig(::grpc::ServerContext* context, ::google::pubsub::v1::ModifyPushConfigRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::protobuf::Empty>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(9, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_GetSnapshot : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_GetSnapshot() {
      ::grpc::Service::MarkMethodAsync(10);
    }
    ~WithAsyncMethod_GetSnapshot() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetSnapshot(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::GetSnapshotRequest* /*request*/, ::google::pubsub::v1::Snapshot* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGetSnapshot(::grpc::ServerContext* context, ::google::pubsub::v1::GetSnapshotRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::pubsub::v1::Snapshot>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(10, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_ListSnapshots : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_ListSnapshots() {
      ::grpc::Service::MarkMethodAsync(11);
    }
    ~WithAsyncMethod_ListSnapshots() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListSnapshots(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::ListSnapshotsRequest* /*request*/, ::google::pubsub::v1::ListSnapshotsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestListSnapshots(::grpc::ServerContext* context, ::google::pubsub::v1::ListSnapshotsRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::pubsub::v1::ListSnapshotsResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(11, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_CreateSnapshot : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_CreateSnapshot() {
      ::grpc::Service::MarkMethodAsync(12);
    }
    ~WithAsyncMethod_CreateSnapshot() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateSnapshot(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::CreateSnapshotRequest* /*request*/, ::google::pubsub::v1::Snapshot* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestCreateSnapshot(::grpc::ServerContext* context, ::google::pubsub::v1::CreateSnapshotRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::pubsub::v1::Snapshot>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(12, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_UpdateSnapshot : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_UpdateSnapshot() {
      ::grpc::Service::MarkMethodAsync(13);
    }
    ~WithAsyncMethod_UpdateSnapshot() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateSnapshot(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::UpdateSnapshotRequest* /*request*/, ::google::pubsub::v1::Snapshot* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestUpdateSnapshot(::grpc::ServerContext* context, ::google::pubsub::v1::UpdateSnapshotRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::pubsub::v1::Snapshot>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(13, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_DeleteSnapshot : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_DeleteSnapshot() {
      ::grpc::Service::MarkMethodAsync(14);
    }
    ~WithAsyncMethod_DeleteSnapshot() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteSnapshot(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::DeleteSnapshotRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestDeleteSnapshot(::grpc::ServerContext* context, ::google::pubsub::v1::DeleteSnapshotRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::protobuf::Empty>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(14, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_Seek : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_Seek() {
      ::grpc::Service::MarkMethodAsync(15);
    }
    ~WithAsyncMethod_Seek() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Seek(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::SeekRequest* /*request*/, ::google::pubsub::v1::SeekResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestSeek(::grpc::ServerContext* context, ::google::pubsub::v1::SeekRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::pubsub::v1::SeekResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(15, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  typedef WithAsyncMethod_CreateSubscription<WithAsyncMethod_GetSubscription<WithAsyncMethod_UpdateSubscription<WithAsyncMethod_ListSubscriptions<WithAsyncMethod_DeleteSubscription<WithAsyncMethod_ModifyAckDeadline<WithAsyncMethod_Acknowledge<WithAsyncMethod_Pull<WithAsyncMethod_StreamingPull<WithAsyncMethod_ModifyPushConfig<WithAsyncMethod_GetSnapshot<WithAsyncMethod_ListSnapshots<WithAsyncMethod_CreateSnapshot<WithAsyncMethod_UpdateSnapshot<WithAsyncMethod_DeleteSnapshot<WithAsyncMethod_Seek<Service > > > > > > > > > > > > > > > > AsyncService;
  template <class BaseClass>
  class WithCallbackMethod_CreateSubscription : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_CreateSubscription() {
      ::grpc::Service::MarkMethodCallback(0,
          new ::grpc::internal::CallbackUnaryHandler< ::google::pubsub::v1::Subscription, ::google::pubsub::v1::Subscription>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::pubsub::v1::Subscription* request, ::google::pubsub::v1::Subscription* response) { return this->CreateSubscription(context, request, response); }));}
    void SetMessageAllocatorFor_CreateSubscription(
        ::grpc::MessageAllocator< ::google::pubsub::v1::Subscription, ::google::pubsub::v1::Subscription>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(0);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::pubsub::v1::Subscription, ::google::pubsub::v1::Subscription>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_CreateSubscription() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateSubscription(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::Subscription* /*request*/, ::google::pubsub::v1::Subscription* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* CreateSubscription(
      ::grpc::CallbackServerContext* /*context*/, const ::google::pubsub::v1::Subscription* /*request*/, ::google::pubsub::v1::Subscription* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_GetSubscription : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_GetSubscription() {
      ::grpc::Service::MarkMethodCallback(1,
          new ::grpc::internal::CallbackUnaryHandler< ::google::pubsub::v1::GetSubscriptionRequest, ::google::pubsub::v1::Subscription>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::pubsub::v1::GetSubscriptionRequest* request, ::google::pubsub::v1::Subscription* response) { return this->GetSubscription(context, request, response); }));}
    void SetMessageAllocatorFor_GetSubscription(
        ::grpc::MessageAllocator< ::google::pubsub::v1::GetSubscriptionRequest, ::google::pubsub::v1::Subscription>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(1);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::pubsub::v1::GetSubscriptionRequest, ::google::pubsub::v1::Subscription>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_GetSubscription() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetSubscription(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::GetSubscriptionRequest* /*request*/, ::google::pubsub::v1::Subscription* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* GetSubscription(
      ::grpc::CallbackServerContext* /*context*/, const ::google::pubsub::v1::GetSubscriptionRequest* /*request*/, ::google::pubsub::v1::Subscription* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_UpdateSubscription : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_UpdateSubscription() {
      ::grpc::Service::MarkMethodCallback(2,
          new ::grpc::internal::CallbackUnaryHandler< ::google::pubsub::v1::UpdateSubscriptionRequest, ::google::pubsub::v1::Subscription>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::pubsub::v1::UpdateSubscriptionRequest* request, ::google::pubsub::v1::Subscription* response) { return this->UpdateSubscription(context, request, response); }));}
    void SetMessageAllocatorFor_UpdateSubscription(
        ::grpc::MessageAllocator< ::google::pubsub::v1::UpdateSubscriptionRequest, ::google::pubsub::v1::Subscription>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(2);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::pubsub::v1::UpdateSubscriptionRequest, ::google::pubsub::v1::Subscription>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_UpdateSubscription() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateSubscription(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::UpdateSubscriptionRequest* /*request*/, ::google::pubsub::v1::Subscription* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* UpdateSubscription(
      ::grpc::CallbackServerContext* /*context*/, const ::google::pubsub::v1::UpdateSubscriptionRequest* /*request*/, ::google::pubsub::v1::Subscription* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_ListSubscriptions : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_ListSubscriptions() {
      ::grpc::Service::MarkMethodCallback(3,
          new ::grpc::internal::CallbackUnaryHandler< ::google::pubsub::v1::ListSubscriptionsRequest, ::google::pubsub::v1::ListSubscriptionsResponse>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::pubsub::v1::ListSubscriptionsRequest* request, ::google::pubsub::v1::ListSubscriptionsResponse* response) { return this->ListSubscriptions(context, request, response); }));}
    void SetMessageAllocatorFor_ListSubscriptions(
        ::grpc::MessageAllocator< ::google::pubsub::v1::ListSubscriptionsRequest, ::google::pubsub::v1::ListSubscriptionsResponse>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(3);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::pubsub::v1::ListSubscriptionsRequest, ::google::pubsub::v1::ListSubscriptionsResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_ListSubscriptions() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListSubscriptions(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::ListSubscriptionsRequest* /*request*/, ::google::pubsub::v1::ListSubscriptionsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* ListSubscriptions(
      ::grpc::CallbackServerContext* /*context*/, const ::google::pubsub::v1::ListSubscriptionsRequest* /*request*/, ::google::pubsub::v1::ListSubscriptionsResponse* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_DeleteSubscription : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_DeleteSubscription() {
      ::grpc::Service::MarkMethodCallback(4,
          new ::grpc::internal::CallbackUnaryHandler< ::google::pubsub::v1::DeleteSubscriptionRequest, ::google::protobuf::Empty>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::pubsub::v1::DeleteSubscriptionRequest* request, ::google::protobuf::Empty* response) { return this->DeleteSubscription(context, request, response); }));}
    void SetMessageAllocatorFor_DeleteSubscription(
        ::grpc::MessageAllocator< ::google::pubsub::v1::DeleteSubscriptionRequest, ::google::protobuf::Empty>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(4);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::pubsub::v1::DeleteSubscriptionRequest, ::google::protobuf::Empty>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_DeleteSubscription() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteSubscription(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::DeleteSubscriptionRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* DeleteSubscription(
      ::grpc::CallbackServerContext* /*context*/, const ::google::pubsub::v1::DeleteSubscriptionRequest* /*request*/, ::google::protobuf::Empty* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_ModifyAckDeadline : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_ModifyAckDeadline() {
      ::grpc::Service::MarkMethodCallback(5,
          new ::grpc::internal::CallbackUnaryHandler< ::google::pubsub::v1::ModifyAckDeadlineRequest, ::google::protobuf::Empty>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::pubsub::v1::ModifyAckDeadlineRequest* request, ::google::protobuf::Empty* response) { return this->ModifyAckDeadline(context, request, response); }));}
    void SetMessageAllocatorFor_ModifyAckDeadline(
        ::grpc::MessageAllocator< ::google::pubsub::v1::ModifyAckDeadlineRequest, ::google::protobuf::Empty>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(5);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::pubsub::v1::ModifyAckDeadlineRequest, ::google::protobuf::Empty>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_ModifyAckDeadline() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ModifyAckDeadline(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::ModifyAckDeadlineRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* ModifyAckDeadline(
      ::grpc::CallbackServerContext* /*context*/, const ::google::pubsub::v1::ModifyAckDeadlineRequest* /*request*/, ::google::protobuf::Empty* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_Acknowledge : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_Acknowledge() {
      ::grpc::Service::MarkMethodCallback(6,
          new ::grpc::internal::CallbackUnaryHandler< ::google::pubsub::v1::AcknowledgeRequest, ::google::protobuf::Empty>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::pubsub::v1::AcknowledgeRequest* request, ::google::protobuf::Empty* response) { return this->Acknowledge(context, request, response); }));}
    void SetMessageAllocatorFor_Acknowledge(
        ::grpc::MessageAllocator< ::google::pubsub::v1::AcknowledgeRequest, ::google::protobuf::Empty>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(6);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::pubsub::v1::AcknowledgeRequest, ::google::protobuf::Empty>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_Acknowledge() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Acknowledge(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::AcknowledgeRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* Acknowledge(
      ::grpc::CallbackServerContext* /*context*/, const ::google::pubsub::v1::AcknowledgeRequest* /*request*/, ::google::protobuf::Empty* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_Pull : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_Pull() {
      ::grpc::Service::MarkMethodCallback(7,
          new ::grpc::internal::CallbackUnaryHandler< ::google::pubsub::v1::PullRequest, ::google::pubsub::v1::PullResponse>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::pubsub::v1::PullRequest* request, ::google::pubsub::v1::PullResponse* response) { return this->Pull(context, request, response); }));}
    void SetMessageAllocatorFor_Pull(
        ::grpc::MessageAllocator< ::google::pubsub::v1::PullRequest, ::google::pubsub::v1::PullResponse>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(7);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::pubsub::v1::PullRequest, ::google::pubsub::v1::PullResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_Pull() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Pull(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::PullRequest* /*request*/, ::google::pubsub::v1::PullResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* Pull(
      ::grpc::CallbackServerContext* /*context*/, const ::google::pubsub::v1::PullRequest* /*request*/, ::google::pubsub::v1::PullResponse* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_StreamingPull : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_StreamingPull() {
      ::grpc::Service::MarkMethodCallback(8,
          new ::grpc::internal::CallbackBidiHandler< ::google::pubsub::v1::StreamingPullRequest, ::google::pubsub::v1::StreamingPullResponse>(
            [this](
                   ::grpc::CallbackServerContext* context) { return this->StreamingPull(context); }));
    }
    ~WithCallbackMethod_StreamingPull() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status StreamingPull(::grpc::ServerContext* /*context*/, ::grpc::ServerReaderWriter< ::google::pubsub::v1::StreamingPullResponse, ::google::pubsub::v1::StreamingPullRequest>* /*stream*/)  override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerBidiReactor< ::google::pubsub::v1::StreamingPullRequest, ::google::pubsub::v1::StreamingPullResponse>* StreamingPull(
      ::grpc::CallbackServerContext* /*context*/)
      { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_ModifyPushConfig : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_ModifyPushConfig() {
      ::grpc::Service::MarkMethodCallback(9,
          new ::grpc::internal::CallbackUnaryHandler< ::google::pubsub::v1::ModifyPushConfigRequest, ::google::protobuf::Empty>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::pubsub::v1::ModifyPushConfigRequest* request, ::google::protobuf::Empty* response) { return this->ModifyPushConfig(context, request, response); }));}
    void SetMessageAllocatorFor_ModifyPushConfig(
        ::grpc::MessageAllocator< ::google::pubsub::v1::ModifyPushConfigRequest, ::google::protobuf::Empty>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(9);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::pubsub::v1::ModifyPushConfigRequest, ::google::protobuf::Empty>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_ModifyPushConfig() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ModifyPushConfig(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::ModifyPushConfigRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* ModifyPushConfig(
      ::grpc::CallbackServerContext* /*context*/, const ::google::pubsub::v1::ModifyPushConfigRequest* /*request*/, ::google::protobuf::Empty* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_GetSnapshot : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_GetSnapshot() {
      ::grpc::Service::MarkMethodCallback(10,
          new ::grpc::internal::CallbackUnaryHandler< ::google::pubsub::v1::GetSnapshotRequest, ::google::pubsub::v1::Snapshot>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::pubsub::v1::GetSnapshotRequest* request, ::google::pubsub::v1::Snapshot* response) { return this->GetSnapshot(context, request, response); }));}
    void SetMessageAllocatorFor_GetSnapshot(
        ::grpc::MessageAllocator< ::google::pubsub::v1::GetSnapshotRequest, ::google::pubsub::v1::Snapshot>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(10);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::pubsub::v1::GetSnapshotRequest, ::google::pubsub::v1::Snapshot>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_GetSnapshot() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetSnapshot(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::GetSnapshotRequest* /*request*/, ::google::pubsub::v1::Snapshot* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* GetSnapshot(
      ::grpc::CallbackServerContext* /*context*/, const ::google::pubsub::v1::GetSnapshotRequest* /*request*/, ::google::pubsub::v1::Snapshot* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_ListSnapshots : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_ListSnapshots() {
      ::grpc::Service::MarkMethodCallback(11,
          new ::grpc::internal::CallbackUnaryHandler< ::google::pubsub::v1::ListSnapshotsRequest, ::google::pubsub::v1::ListSnapshotsResponse>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::pubsub::v1::ListSnapshotsRequest* request, ::google::pubsub::v1::ListSnapshotsResponse* response) { return this->ListSnapshots(context, request, response); }));}
    void SetMessageAllocatorFor_ListSnapshots(
        ::grpc::MessageAllocator< ::google::pubsub::v1::ListSnapshotsRequest, ::google::pubsub::v1::ListSnapshotsResponse>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(11);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::pubsub::v1::ListSnapshotsRequest, ::google::pubsub::v1::ListSnapshotsResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_ListSnapshots() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListSnapshots(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::ListSnapshotsRequest* /*request*/, ::google::pubsub::v1::ListSnapshotsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* ListSnapshots(
      ::grpc::CallbackServerContext* /*context*/, const ::google::pubsub::v1::ListSnapshotsRequest* /*request*/, ::google::pubsub::v1::ListSnapshotsResponse* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_CreateSnapshot : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_CreateSnapshot() {
      ::grpc::Service::MarkMethodCallback(12,
          new ::grpc::internal::CallbackUnaryHandler< ::google::pubsub::v1::CreateSnapshotRequest, ::google::pubsub::v1::Snapshot>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::pubsub::v1::CreateSnapshotRequest* request, ::google::pubsub::v1::Snapshot* response) { return this->CreateSnapshot(context, request, response); }));}
    void SetMessageAllocatorFor_CreateSnapshot(
        ::grpc::MessageAllocator< ::google::pubsub::v1::CreateSnapshotRequest, ::google::pubsub::v1::Snapshot>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(12);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::pubsub::v1::CreateSnapshotRequest, ::google::pubsub::v1::Snapshot>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_CreateSnapshot() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateSnapshot(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::CreateSnapshotRequest* /*request*/, ::google::pubsub::v1::Snapshot* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* CreateSnapshot(
      ::grpc::CallbackServerContext* /*context*/, const ::google::pubsub::v1::CreateSnapshotRequest* /*request*/, ::google::pubsub::v1::Snapshot* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_UpdateSnapshot : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_UpdateSnapshot() {
      ::grpc::Service::MarkMethodCallback(13,
          new ::grpc::internal::CallbackUnaryHandler< ::google::pubsub::v1::UpdateSnapshotRequest, ::google::pubsub::v1::Snapshot>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::pubsub::v1::UpdateSnapshotRequest* request, ::google::pubsub::v1::Snapshot* response) { return this->UpdateSnapshot(context, request, response); }));}
    void SetMessageAllocatorFor_UpdateSnapshot(
        ::grpc::MessageAllocator< ::google::pubsub::v1::UpdateSnapshotRequest, ::google::pubsub::v1::Snapshot>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(13);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::pubsub::v1::UpdateSnapshotRequest, ::google::pubsub::v1::Snapshot>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_UpdateSnapshot() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateSnapshot(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::UpdateSnapshotRequest* /*request*/, ::google::pubsub::v1::Snapshot* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* UpdateSnapshot(
      ::grpc::CallbackServerContext* /*context*/, const ::google::pubsub::v1::UpdateSnapshotRequest* /*request*/, ::google::pubsub::v1::Snapshot* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_DeleteSnapshot : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_DeleteSnapshot() {
      ::grpc::Service::MarkMethodCallback(14,
          new ::grpc::internal::CallbackUnaryHandler< ::google::pubsub::v1::DeleteSnapshotRequest, ::google::protobuf::Empty>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::pubsub::v1::DeleteSnapshotRequest* request, ::google::protobuf::Empty* response) { return this->DeleteSnapshot(context, request, response); }));}
    void SetMessageAllocatorFor_DeleteSnapshot(
        ::grpc::MessageAllocator< ::google::pubsub::v1::DeleteSnapshotRequest, ::google::protobuf::Empty>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(14);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::pubsub::v1::DeleteSnapshotRequest, ::google::protobuf::Empty>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_DeleteSnapshot() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteSnapshot(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::DeleteSnapshotRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* DeleteSnapshot(
      ::grpc::CallbackServerContext* /*context*/, const ::google::pubsub::v1::DeleteSnapshotRequest* /*request*/, ::google::protobuf::Empty* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_Seek : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_Seek() {
      ::grpc::Service::MarkMethodCallback(15,
          new ::grpc::internal::CallbackUnaryHandler< ::google::pubsub::v1::SeekRequest, ::google::pubsub::v1::SeekResponse>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::pubsub::v1::SeekRequest* request, ::google::pubsub::v1::SeekResponse* response) { return this->Seek(context, request, response); }));}
    void SetMessageAllocatorFor_Seek(
        ::grpc::MessageAllocator< ::google::pubsub::v1::SeekRequest, ::google::pubsub::v1::SeekResponse>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(15);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::pubsub::v1::SeekRequest, ::google::pubsub::v1::SeekResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_Seek() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Seek(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::SeekRequest* /*request*/, ::google::pubsub::v1::SeekResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* Seek(
      ::grpc::CallbackServerContext* /*context*/, const ::google::pubsub::v1::SeekRequest* /*request*/, ::google::pubsub::v1::SeekResponse* /*response*/)  { return nullptr; }
  };
  typedef WithCallbackMethod_CreateSubscription<WithCallbackMethod_GetSubscription<WithCallbackMethod_UpdateSubscription<WithCallbackMethod_ListSubscriptions<WithCallbackMethod_DeleteSubscription<WithCallbackMethod_ModifyAckDeadline<WithCallbackMethod_Acknowledge<WithCallbackMethod_Pull<WithCallbackMethod_StreamingPull<WithCallbackMethod_ModifyPushConfig<WithCallbackMethod_GetSnapshot<WithCallbackMethod_ListSnapshots<WithCallbackMethod_CreateSnapshot<WithCallbackMethod_UpdateSnapshot<WithCallbackMethod_DeleteSnapshot<WithCallbackMethod_Seek<Service > > > > > > > > > > > > > > > > CallbackService;
  typedef CallbackService ExperimentalCallbackService;
  template <class BaseClass>
  class WithGenericMethod_CreateSubscription : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_CreateSubscription() {
      ::grpc::Service::MarkMethodGeneric(0);
    }
    ~WithGenericMethod_CreateSubscription() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateSubscription(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::Subscription* /*request*/, ::google::pubsub::v1::Subscription* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_GetSubscription : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_GetSubscription() {
      ::grpc::Service::MarkMethodGeneric(1);
    }
    ~WithGenericMethod_GetSubscription() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetSubscription(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::GetSubscriptionRequest* /*request*/, ::google::pubsub::v1::Subscription* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_UpdateSubscription : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_UpdateSubscription() {
      ::grpc::Service::MarkMethodGeneric(2);
    }
    ~WithGenericMethod_UpdateSubscription() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateSubscription(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::UpdateSubscriptionRequest* /*request*/, ::google::pubsub::v1::Subscription* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_ListSubscriptions : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_ListSubscriptions() {
      ::grpc::Service::MarkMethodGeneric(3);
    }
    ~WithGenericMethod_ListSubscriptions() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListSubscriptions(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::ListSubscriptionsRequest* /*request*/, ::google::pubsub::v1::ListSubscriptionsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_DeleteSubscription : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_DeleteSubscription() {
      ::grpc::Service::MarkMethodGeneric(4);
    }
    ~WithGenericMethod_DeleteSubscription() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteSubscription(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::DeleteSubscriptionRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_ModifyAckDeadline : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_ModifyAckDeadline() {
      ::grpc::Service::MarkMethodGeneric(5);
    }
    ~WithGenericMethod_ModifyAckDeadline() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ModifyAckDeadline(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::ModifyAckDeadlineRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_Acknowledge : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_Acknowledge() {
      ::grpc::Service::MarkMethodGeneric(6);
    }
    ~WithGenericMethod_Acknowledge() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Acknowledge(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::AcknowledgeRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_Pull : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_Pull() {
      ::grpc::Service::MarkMethodGeneric(7);
    }
    ~WithGenericMethod_Pull() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Pull(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::PullRequest* /*request*/, ::google::pubsub::v1::PullResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_StreamingPull : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_StreamingPull() {
      ::grpc::Service::MarkMethodGeneric(8);
    }
    ~WithGenericMethod_StreamingPull() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status StreamingPull(::grpc::ServerContext* /*context*/, ::grpc::ServerReaderWriter< ::google::pubsub::v1::StreamingPullResponse, ::google::pubsub::v1::StreamingPullRequest>* /*stream*/)  override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_ModifyPushConfig : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_ModifyPushConfig() {
      ::grpc::Service::MarkMethodGeneric(9);
    }
    ~WithGenericMethod_ModifyPushConfig() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ModifyPushConfig(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::ModifyPushConfigRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_GetSnapshot : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_GetSnapshot() {
      ::grpc::Service::MarkMethodGeneric(10);
    }
    ~WithGenericMethod_GetSnapshot() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetSnapshot(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::GetSnapshotRequest* /*request*/, ::google::pubsub::v1::Snapshot* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_ListSnapshots : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_ListSnapshots() {
      ::grpc::Service::MarkMethodGeneric(11);
    }
    ~WithGenericMethod_ListSnapshots() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListSnapshots(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::ListSnapshotsRequest* /*request*/, ::google::pubsub::v1::ListSnapshotsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_CreateSnapshot : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_CreateSnapshot() {
      ::grpc::Service::MarkMethodGeneric(12);
    }
    ~WithGenericMethod_CreateSnapshot() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateSnapshot(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::CreateSnapshotRequest* /*request*/, ::google::pubsub::v1::Snapshot* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_UpdateSnapshot : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_UpdateSnapshot() {
      ::grpc::Service::MarkMethodGeneric(13);
    }
    ~WithGenericMethod_UpdateSnapshot() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateSnapshot(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::UpdateSnapshotRequest* /*request*/, ::google::pubsub::v1::Snapshot* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_DeleteSnapshot : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_DeleteSnapshot() {
      ::grpc::Service::MarkMethodGeneric(14);
    }
    ~WithGenericMethod_DeleteSnapshot() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteSnapshot(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::DeleteSnapshotRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_Seek : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_Seek() {
      ::grpc::Service::MarkMethodGeneric(15);
    }
    ~WithGenericMethod_Seek() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Seek(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::SeekRequest* /*request*/, ::google::pubsub::v1::SeekResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithRawMethod_CreateSubscription : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_CreateSubscription() {
      ::grpc::Service::MarkMethodRaw(0);
    }
    ~WithRawMethod_CreateSubscription() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateSubscription(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::Subscription* /*request*/, ::google::pubsub::v1::Subscription* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestCreateSubscription(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(0, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_GetSubscription : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_GetSubscription() {
      ::grpc::Service::MarkMethodRaw(1);
    }
    ~WithRawMethod_GetSubscription() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetSubscription(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::GetSubscriptionRequest* /*request*/, ::google::pubsub::v1::Subscription* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGetSubscription(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(1, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_UpdateSubscription : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_UpdateSubscription() {
      ::grpc::Service::MarkMethodRaw(2);
    }
    ~WithRawMethod_UpdateSubscription() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateSubscription(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::UpdateSubscriptionRequest* /*request*/, ::google::pubsub::v1::Subscription* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestUpdateSubscription(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(2, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_ListSubscriptions : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_ListSubscriptions() {
      ::grpc::Service::MarkMethodRaw(3);
    }
    ~WithRawMethod_ListSubscriptions() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListSubscriptions(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::ListSubscriptionsRequest* /*request*/, ::google::pubsub::v1::ListSubscriptionsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestListSubscriptions(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(3, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_DeleteSubscription : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_DeleteSubscription() {
      ::grpc::Service::MarkMethodRaw(4);
    }
    ~WithRawMethod_DeleteSubscription() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteSubscription(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::DeleteSubscriptionRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestDeleteSubscription(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(4, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_ModifyAckDeadline : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_ModifyAckDeadline() {
      ::grpc::Service::MarkMethodRaw(5);
    }
    ~WithRawMethod_ModifyAckDeadline() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ModifyAckDeadline(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::ModifyAckDeadlineRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestModifyAckDeadline(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(5, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_Acknowledge : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_Acknowledge() {
      ::grpc::Service::MarkMethodRaw(6);
    }
    ~WithRawMethod_Acknowledge() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Acknowledge(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::AcknowledgeRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestAcknowledge(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(6, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_Pull : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_Pull() {
      ::grpc::Service::MarkMethodRaw(7);
    }
    ~WithRawMethod_Pull() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Pull(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::PullRequest* /*request*/, ::google::pubsub::v1::PullResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestPull(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(7, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_StreamingPull : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_StreamingPull() {
      ::grpc::Service::MarkMethodRaw(8);
    }
    ~WithRawMethod_StreamingPull() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status StreamingPull(::grpc::ServerContext* /*context*/, ::grpc::ServerReaderWriter< ::google::pubsub::v1::StreamingPullResponse, ::google::pubsub::v1::StreamingPullRequest>* /*stream*/)  override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestStreamingPull(::grpc::ServerContext* context, ::grpc::ServerAsyncReaderWriter< ::grpc::ByteBuffer, ::grpc::ByteBuffer>* stream, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncBidiStreaming(8, context, stream, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_ModifyPushConfig : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_ModifyPushConfig() {
      ::grpc::Service::MarkMethodRaw(9);
    }
    ~WithRawMethod_ModifyPushConfig() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ModifyPushConfig(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::ModifyPushConfigRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestModifyPushConfig(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(9, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_GetSnapshot : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_GetSnapshot() {
      ::grpc::Service::MarkMethodRaw(10);
    }
    ~WithRawMethod_GetSnapshot() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetSnapshot(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::GetSnapshotRequest* /*request*/, ::google::pubsub::v1::Snapshot* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGetSnapshot(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(10, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_ListSnapshots : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_ListSnapshots() {
      ::grpc::Service::MarkMethodRaw(11);
    }
    ~WithRawMethod_ListSnapshots() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListSnapshots(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::ListSnapshotsRequest* /*request*/, ::google::pubsub::v1::ListSnapshotsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestListSnapshots(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(11, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_CreateSnapshot : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_CreateSnapshot() {
      ::grpc::Service::MarkMethodRaw(12);
    }
    ~WithRawMethod_CreateSnapshot() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateSnapshot(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::CreateSnapshotRequest* /*request*/, ::google::pubsub::v1::Snapshot* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestCreateSnapshot(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(12, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_UpdateSnapshot : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_UpdateSnapshot() {
      ::grpc::Service::MarkMethodRaw(13);
    }
    ~WithRawMethod_UpdateSnapshot() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateSnapshot(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::UpdateSnapshotRequest* /*request*/, ::google::pubsub::v1::Snapshot* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestUpdateSnapshot(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(13, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_DeleteSnapshot : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_DeleteSnapshot() {
      ::grpc::Service::MarkMethodRaw(14);
    }
    ~WithRawMethod_DeleteSnapshot() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteSnapshot(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::DeleteSnapshotRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestDeleteSnapshot(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(14, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_Seek : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_Seek() {
      ::grpc::Service::MarkMethodRaw(15);
    }
    ~WithRawMethod_Seek() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Seek(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::SeekRequest* /*request*/, ::google::pubsub::v1::SeekResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestSeek(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(15, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_CreateSubscription : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_CreateSubscription() {
      ::grpc::Service::MarkMethodRawCallback(0,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->CreateSubscription(context, request, response); }));
    }
    ~WithRawCallbackMethod_CreateSubscription() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateSubscription(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::Subscription* /*request*/, ::google::pubsub::v1::Subscription* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* CreateSubscription(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_GetSubscription : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_GetSubscription() {
      ::grpc::Service::MarkMethodRawCallback(1,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->GetSubscription(context, request, response); }));
    }
    ~WithRawCallbackMethod_GetSubscription() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetSubscription(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::GetSubscriptionRequest* /*request*/, ::google::pubsub::v1::Subscription* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* GetSubscription(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_UpdateSubscription : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_UpdateSubscription() {
      ::grpc::Service::MarkMethodRawCallback(2,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->UpdateSubscription(context, request, response); }));
    }
    ~WithRawCallbackMethod_UpdateSubscription() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateSubscription(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::UpdateSubscriptionRequest* /*request*/, ::google::pubsub::v1::Subscription* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* UpdateSubscription(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_ListSubscriptions : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_ListSubscriptions() {
      ::grpc::Service::MarkMethodRawCallback(3,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->ListSubscriptions(context, request, response); }));
    }
    ~WithRawCallbackMethod_ListSubscriptions() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListSubscriptions(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::ListSubscriptionsRequest* /*request*/, ::google::pubsub::v1::ListSubscriptionsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* ListSubscriptions(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_DeleteSubscription : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_DeleteSubscription() {
      ::grpc::Service::MarkMethodRawCallback(4,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->DeleteSubscription(context, request, response); }));
    }
    ~WithRawCallbackMethod_DeleteSubscription() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteSubscription(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::DeleteSubscriptionRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* DeleteSubscription(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_ModifyAckDeadline : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_ModifyAckDeadline() {
      ::grpc::Service::MarkMethodRawCallback(5,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->ModifyAckDeadline(context, request, response); }));
    }
    ~WithRawCallbackMethod_ModifyAckDeadline() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ModifyAckDeadline(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::ModifyAckDeadlineRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* ModifyAckDeadline(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_Acknowledge : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_Acknowledge() {
      ::grpc::Service::MarkMethodRawCallback(6,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->Acknowledge(context, request, response); }));
    }
    ~WithRawCallbackMethod_Acknowledge() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Acknowledge(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::AcknowledgeRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* Acknowledge(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_Pull : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_Pull() {
      ::grpc::Service::MarkMethodRawCallback(7,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->Pull(context, request, response); }));
    }
    ~WithRawCallbackMethod_Pull() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Pull(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::PullRequest* /*request*/, ::google::pubsub::v1::PullResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* Pull(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_StreamingPull : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_StreamingPull() {
      ::grpc::Service::MarkMethodRawCallback(8,
          new ::grpc::internal::CallbackBidiHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context) { return this->StreamingPull(context); }));
    }
    ~WithRawCallbackMethod_StreamingPull() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status StreamingPull(::grpc::ServerContext* /*context*/, ::grpc::ServerReaderWriter< ::google::pubsub::v1::StreamingPullResponse, ::google::pubsub::v1::StreamingPullRequest>* /*stream*/)  override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerBidiReactor< ::grpc::ByteBuffer, ::grpc::ByteBuffer>* StreamingPull(
      ::grpc::CallbackServerContext* /*context*/)
      { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_ModifyPushConfig : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_ModifyPushConfig() {
      ::grpc::Service::MarkMethodRawCallback(9,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->ModifyPushConfig(context, request, response); }));
    }
    ~WithRawCallbackMethod_ModifyPushConfig() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ModifyPushConfig(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::ModifyPushConfigRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* ModifyPushConfig(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_GetSnapshot : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_GetSnapshot() {
      ::grpc::Service::MarkMethodRawCallback(10,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->GetSnapshot(context, request, response); }));
    }
    ~WithRawCallbackMethod_GetSnapshot() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetSnapshot(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::GetSnapshotRequest* /*request*/, ::google::pubsub::v1::Snapshot* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* GetSnapshot(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_ListSnapshots : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_ListSnapshots() {
      ::grpc::Service::MarkMethodRawCallback(11,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->ListSnapshots(context, request, response); }));
    }
    ~WithRawCallbackMethod_ListSnapshots() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListSnapshots(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::ListSnapshotsRequest* /*request*/, ::google::pubsub::v1::ListSnapshotsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* ListSnapshots(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_CreateSnapshot : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_CreateSnapshot() {
      ::grpc::Service::MarkMethodRawCallback(12,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->CreateSnapshot(context, request, response); }));
    }
    ~WithRawCallbackMethod_CreateSnapshot() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateSnapshot(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::CreateSnapshotRequest* /*request*/, ::google::pubsub::v1::Snapshot* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* CreateSnapshot(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_UpdateSnapshot : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_UpdateSnapshot() {
      ::grpc::Service::MarkMethodRawCallback(13,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->UpdateSnapshot(context, request, response); }));
    }
    ~WithRawCallbackMethod_UpdateSnapshot() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateSnapshot(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::UpdateSnapshotRequest* /*request*/, ::google::pubsub::v1::Snapshot* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* UpdateSnapshot(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_DeleteSnapshot : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_DeleteSnapshot() {
      ::grpc::Service::MarkMethodRawCallback(14,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->DeleteSnapshot(context, request, response); }));
    }
    ~WithRawCallbackMethod_DeleteSnapshot() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteSnapshot(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::DeleteSnapshotRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* DeleteSnapshot(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_Seek : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_Seek() {
      ::grpc::Service::MarkMethodRawCallback(15,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->Seek(context, request, response); }));
    }
    ~WithRawCallbackMethod_Seek() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status Seek(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::SeekRequest* /*request*/, ::google::pubsub::v1::SeekResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* Seek(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_CreateSubscription : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_CreateSubscription() {
      ::grpc::Service::MarkMethodStreamed(0,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::pubsub::v1::Subscription, ::google::pubsub::v1::Subscription>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::pubsub::v1::Subscription, ::google::pubsub::v1::Subscription>* streamer) {
                       return this->StreamedCreateSubscription(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_CreateSubscription() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status CreateSubscription(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::Subscription* /*request*/, ::google::pubsub::v1::Subscription* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedCreateSubscription(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::pubsub::v1::Subscription,::google::pubsub::v1::Subscription>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_GetSubscription : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_GetSubscription() {
      ::grpc::Service::MarkMethodStreamed(1,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::pubsub::v1::GetSubscriptionRequest, ::google::pubsub::v1::Subscription>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::pubsub::v1::GetSubscriptionRequest, ::google::pubsub::v1::Subscription>* streamer) {
                       return this->StreamedGetSubscription(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_GetSubscription() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status GetSubscription(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::GetSubscriptionRequest* /*request*/, ::google::pubsub::v1::Subscription* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedGetSubscription(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::pubsub::v1::GetSubscriptionRequest,::google::pubsub::v1::Subscription>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_UpdateSubscription : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_UpdateSubscription() {
      ::grpc::Service::MarkMethodStreamed(2,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::pubsub::v1::UpdateSubscriptionRequest, ::google::pubsub::v1::Subscription>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::pubsub::v1::UpdateSubscriptionRequest, ::google::pubsub::v1::Subscription>* streamer) {
                       return this->StreamedUpdateSubscription(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_UpdateSubscription() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status UpdateSubscription(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::UpdateSubscriptionRequest* /*request*/, ::google::pubsub::v1::Subscription* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedUpdateSubscription(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::pubsub::v1::UpdateSubscriptionRequest,::google::pubsub::v1::Subscription>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_ListSubscriptions : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_ListSubscriptions() {
      ::grpc::Service::MarkMethodStreamed(3,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::pubsub::v1::ListSubscriptionsRequest, ::google::pubsub::v1::ListSubscriptionsResponse>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::pubsub::v1::ListSubscriptionsRequest, ::google::pubsub::v1::ListSubscriptionsResponse>* streamer) {
                       return this->StreamedListSubscriptions(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_ListSubscriptions() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status ListSubscriptions(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::ListSubscriptionsRequest* /*request*/, ::google::pubsub::v1::ListSubscriptionsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedListSubscriptions(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::pubsub::v1::ListSubscriptionsRequest,::google::pubsub::v1::ListSubscriptionsResponse>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_DeleteSubscription : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_DeleteSubscription() {
      ::grpc::Service::MarkMethodStreamed(4,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::pubsub::v1::DeleteSubscriptionRequest, ::google::protobuf::Empty>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::pubsub::v1::DeleteSubscriptionRequest, ::google::protobuf::Empty>* streamer) {
                       return this->StreamedDeleteSubscription(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_DeleteSubscription() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status DeleteSubscription(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::DeleteSubscriptionRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedDeleteSubscription(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::pubsub::v1::DeleteSubscriptionRequest,::google::protobuf::Empty>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_ModifyAckDeadline : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_ModifyAckDeadline() {
      ::grpc::Service::MarkMethodStreamed(5,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::pubsub::v1::ModifyAckDeadlineRequest, ::google::protobuf::Empty>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::pubsub::v1::ModifyAckDeadlineRequest, ::google::protobuf::Empty>* streamer) {
                       return this->StreamedModifyAckDeadline(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_ModifyAckDeadline() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status ModifyAckDeadline(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::ModifyAckDeadlineRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedModifyAckDeadline(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::pubsub::v1::ModifyAckDeadlineRequest,::google::protobuf::Empty>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_Acknowledge : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_Acknowledge() {
      ::grpc::Service::MarkMethodStreamed(6,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::pubsub::v1::AcknowledgeRequest, ::google::protobuf::Empty>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::pubsub::v1::AcknowledgeRequest, ::google::protobuf::Empty>* streamer) {
                       return this->StreamedAcknowledge(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_Acknowledge() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status Acknowledge(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::AcknowledgeRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedAcknowledge(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::pubsub::v1::AcknowledgeRequest,::google::protobuf::Empty>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_Pull : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_Pull() {
      ::grpc::Service::MarkMethodStreamed(7,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::pubsub::v1::PullRequest, ::google::pubsub::v1::PullResponse>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::pubsub::v1::PullRequest, ::google::pubsub::v1::PullResponse>* streamer) {
                       return this->StreamedPull(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_Pull() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status Pull(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::PullRequest* /*request*/, ::google::pubsub::v1::PullResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedPull(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::pubsub::v1::PullRequest,::google::pubsub::v1::PullResponse>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_ModifyPushConfig : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_ModifyPushConfig() {
      ::grpc::Service::MarkMethodStreamed(9,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::pubsub::v1::ModifyPushConfigRequest, ::google::protobuf::Empty>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::pubsub::v1::ModifyPushConfigRequest, ::google::protobuf::Empty>* streamer) {
                       return this->StreamedModifyPushConfig(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_ModifyPushConfig() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status ModifyPushConfig(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::ModifyPushConfigRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedModifyPushConfig(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::pubsub::v1::ModifyPushConfigRequest,::google::protobuf::Empty>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_GetSnapshot : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_GetSnapshot() {
      ::grpc::Service::MarkMethodStreamed(10,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::pubsub::v1::GetSnapshotRequest, ::google::pubsub::v1::Snapshot>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::pubsub::v1::GetSnapshotRequest, ::google::pubsub::v1::Snapshot>* streamer) {
                       return this->StreamedGetSnapshot(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_GetSnapshot() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status GetSnapshot(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::GetSnapshotRequest* /*request*/, ::google::pubsub::v1::Snapshot* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedGetSnapshot(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::pubsub::v1::GetSnapshotRequest,::google::pubsub::v1::Snapshot>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_ListSnapshots : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_ListSnapshots() {
      ::grpc::Service::MarkMethodStreamed(11,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::pubsub::v1::ListSnapshotsRequest, ::google::pubsub::v1::ListSnapshotsResponse>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::pubsub::v1::ListSnapshotsRequest, ::google::pubsub::v1::ListSnapshotsResponse>* streamer) {
                       return this->StreamedListSnapshots(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_ListSnapshots() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status ListSnapshots(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::ListSnapshotsRequest* /*request*/, ::google::pubsub::v1::ListSnapshotsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedListSnapshots(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::pubsub::v1::ListSnapshotsRequest,::google::pubsub::v1::ListSnapshotsResponse>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_CreateSnapshot : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_CreateSnapshot() {
      ::grpc::Service::MarkMethodStreamed(12,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::pubsub::v1::CreateSnapshotRequest, ::google::pubsub::v1::Snapshot>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::pubsub::v1::CreateSnapshotRequest, ::google::pubsub::v1::Snapshot>* streamer) {
                       return this->StreamedCreateSnapshot(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_CreateSnapshot() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status CreateSnapshot(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::CreateSnapshotRequest* /*request*/, ::google::pubsub::v1::Snapshot* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedCreateSnapshot(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::pubsub::v1::CreateSnapshotRequest,::google::pubsub::v1::Snapshot>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_UpdateSnapshot : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_UpdateSnapshot() {
      ::grpc::Service::MarkMethodStreamed(13,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::pubsub::v1::UpdateSnapshotRequest, ::google::pubsub::v1::Snapshot>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::pubsub::v1::UpdateSnapshotRequest, ::google::pubsub::v1::Snapshot>* streamer) {
                       return this->StreamedUpdateSnapshot(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_UpdateSnapshot() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status UpdateSnapshot(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::UpdateSnapshotRequest* /*request*/, ::google::pubsub::v1::Snapshot* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedUpdateSnapshot(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::pubsub::v1::UpdateSnapshotRequest,::google::pubsub::v1::Snapshot>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_DeleteSnapshot : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_DeleteSnapshot() {
      ::grpc::Service::MarkMethodStreamed(14,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::pubsub::v1::DeleteSnapshotRequest, ::google::protobuf::Empty>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::pubsub::v1::DeleteSnapshotRequest, ::google::protobuf::Empty>* streamer) {
                       return this->StreamedDeleteSnapshot(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_DeleteSnapshot() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status DeleteSnapshot(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::DeleteSnapshotRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedDeleteSnapshot(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::pubsub::v1::DeleteSnapshotRequest,::google::protobuf::Empty>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_Seek : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_Seek() {
      ::grpc::Service::MarkMethodStreamed(15,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::pubsub::v1::SeekRequest, ::google::pubsub::v1::SeekResponse>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::pubsub::v1::SeekRequest, ::google::pubsub::v1::SeekResponse>* streamer) {
                       return this->StreamedSeek(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_Seek() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status Seek(::grpc::ServerContext* /*context*/, const ::google::pubsub::v1::SeekRequest* /*request*/, ::google::pubsub::v1::SeekResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedSeek(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::pubsub::v1::SeekRequest,::google::pubsub::v1::SeekResponse>* server_unary_streamer) = 0;
  };
  typedef WithStreamedUnaryMethod_CreateSubscription<WithStreamedUnaryMethod_GetSubscription<WithStreamedUnaryMethod_UpdateSubscription<WithStreamedUnaryMethod_ListSubscriptions<WithStreamedUnaryMethod_DeleteSubscription<WithStreamedUnaryMethod_ModifyAckDeadline<WithStreamedUnaryMethod_Acknowledge<WithStreamedUnaryMethod_Pull<WithStreamedUnaryMethod_ModifyPushConfig<WithStreamedUnaryMethod_GetSnapshot<WithStreamedUnaryMethod_ListSnapshots<WithStreamedUnaryMethod_CreateSnapshot<WithStreamedUnaryMethod_UpdateSnapshot<WithStreamedUnaryMethod_DeleteSnapshot<WithStreamedUnaryMethod_Seek<Service > > > > > > > > > > > > > > > StreamedUnaryService;
  typedef Service SplitStreamedService;
  typedef WithStreamedUnaryMethod_CreateSubscription<WithStreamedUnaryMethod_GetSubscription<WithStreamedUnaryMethod_UpdateSubscription<WithStreamedUnaryMethod_ListSubscriptions<WithStreamedUnaryMethod_DeleteSubscription<WithStreamedUnaryMethod_ModifyAckDeadline<WithStreamedUnaryMethod_Acknowledge<WithStreamedUnaryMethod_Pull<WithStreamedUnaryMethod_ModifyPushConfig<WithStreamedUnaryMethod_GetSnapshot<WithStreamedUnaryMethod_ListSnapshots<WithStreamedUnaryMethod_CreateSnapshot<WithStreamedUnaryMethod_UpdateSnapshot<WithStreamedUnaryMethod_DeleteSnapshot<WithStreamedUnaryMethod_Seek<Service > > > > > > > > > > > > > > > StreamedService;
};

}  // namespace v1
}  // namespace pubsub
}  // namespace google


#endif  // GRPC_google_2fpubsub_2fv1_2fpubsub_2eproto__INCLUDED
