// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/bigquery/reservation/v1/reservation.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BIGQUERY_RESERVATION_CLIENT_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BIGQUERY_RESERVATION_CLIENT_H

#include "google/cloud/bigquery/reservation_connection.h"
#include "google/cloud/future.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace bigquery {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

///
/// This API allows users to manage their flat-rate BigQuery reservations.
///
/// A reservation provides computational resource guarantees, in the form of
/// [slots](https://cloud.google.com/bigquery/docs/slots), to users. A slot is a
/// unit of computational power in BigQuery, and serves as the basic unit of
/// parallelism. In a scan of a multi-partitioned table, a single slot operates
/// on a single partition of the table. A reservation resource exists as a child
/// resource of the admin project and location, e.g.:
///   `projects/myproject/locations/US/reservations/reservationName`.
///
/// A capacity commitment is a way to purchase compute capacity for BigQuery
/// jobs (in the form of slots) with some committed period of usage. A capacity
/// commitment resource exists as a child resource of the admin project and
/// location, e.g.:
///   `projects/myproject/locations/US/capacityCommitments/id`.
///
/// @par Equality
///
/// Instances of this class created via copy-construction or copy-assignment
/// always compare equal. Instances created with equal
/// `std::shared_ptr<*Connection>` objects compare equal. Objects that compare
/// equal share the same underlying resources.
///
/// @par Performance
///
/// Creating a new instance of this class is a relatively expensive operation,
/// new objects establish new connections to the service. In contrast,
/// copy-construction, move-construction, and the corresponding assignment
/// operations are relatively efficient as the copies share all underlying
/// resources.
///
/// @par Thread Safety
///
/// Concurrent access to different instances of this class, even if they compare
/// equal, is guaranteed to work. Two or more threads operating on the same
/// instance of this class is not guaranteed to work. Since copy-construction
/// and move-construction is a relatively efficient operation, consider using
/// such a copy when using this class from multiple threads.
///
class ReservationServiceClient {
 public:
  explicit ReservationServiceClient(
      std::shared_ptr<ReservationServiceConnection> connection,
      Options opts = {});
  ~ReservationServiceClient();

  //@{
  // @name Copy and move support
  ReservationServiceClient(ReservationServiceClient const&) = default;
  ReservationServiceClient& operator=(ReservationServiceClient const&) =
      default;
  ReservationServiceClient(ReservationServiceClient&&) = default;
  ReservationServiceClient& operator=(ReservationServiceClient&&) = default;
  //@}

  //@{
  // @name Equality
  friend bool operator==(ReservationServiceClient const& a,
                         ReservationServiceClient const& b) {
    return a.connection_ == b.connection_;
  }
  friend bool operator!=(ReservationServiceClient const& a,
                         ReservationServiceClient const& b) {
    return !(a == b);
  }
  //@}

  ///
  /// Creates a new reservation resource.
  ///
  /// @param parent  Required. Project, location. E.g.,
  ///  `projects/myproject/locations/US`
  /// @param reservation  Definition of the new reservation to create.
  /// @param reservation_id  The reservation ID. This field must only contain
  /// lower case alphanumeric
  ///  characters or dash. Max length is 64 characters.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return
  /// @googleapis_link{google::cloud::bigquery::reservation::v1::Reservation,google/cloud/bigquery/reservation/v1/reservation.proto#L371}
  ///
  /// [google.cloud.bigquery.reservation.v1.CreateReservationRequest]:
  /// @googleapis_reference_link{google/cloud/bigquery/reservation/v1/reservation.proto#L500}
  /// [google.cloud.bigquery.reservation.v1.Reservation]:
  /// @googleapis_reference_link{google/cloud/bigquery/reservation/v1/reservation.proto#L371}
  ///
  StatusOr<google::cloud::bigquery::reservation::v1::Reservation>
  CreateReservation(
      std::string const& parent,
      google::cloud::bigquery::reservation::v1::Reservation const& reservation,
      std::string const& reservation_id, Options opts = {});

  ///
  /// Creates a new reservation resource.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::bigquery::reservation::v1::CreateReservationRequest,google/cloud/bigquery/reservation/v1/reservation.proto#L500}
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return
  /// @googleapis_link{google::cloud::bigquery::reservation::v1::Reservation,google/cloud/bigquery/reservation/v1/reservation.proto#L371}
  ///
  /// [google.cloud.bigquery.reservation.v1.CreateReservationRequest]:
  /// @googleapis_reference_link{google/cloud/bigquery/reservation/v1/reservation.proto#L500}
  /// [google.cloud.bigquery.reservation.v1.Reservation]:
  /// @googleapis_reference_link{google/cloud/bigquery/reservation/v1/reservation.proto#L371}
  ///
  StatusOr<google::cloud::bigquery::reservation::v1::Reservation>
  CreateReservation(
      google::cloud::bigquery::reservation::v1::CreateReservationRequest const&
          request,
      Options opts = {});

  ///
  /// Lists all the reservations for the project in the specified location.
  ///
  /// @param parent  Required. The parent resource name containing project and
  /// location, e.g.:
  ///    `projects/myproject/locations/US`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return
  /// @googleapis_link{google::cloud::bigquery::reservation::v1::Reservation,google/cloud/bigquery/reservation/v1/reservation.proto#L371}
  ///
  /// [google.cloud.bigquery.reservation.v1.ListReservationsRequest]:
  /// @googleapis_reference_link{google/cloud/bigquery/reservation/v1/reservation.proto#L519}
  /// [google.cloud.bigquery.reservation.v1.Reservation]:
  /// @googleapis_reference_link{google/cloud/bigquery/reservation/v1/reservation.proto#L371}
  ///
  StreamRange<google::cloud::bigquery::reservation::v1::Reservation>
  ListReservations(std::string const& parent, Options opts = {});

  ///
  /// Lists all the reservations for the project in the specified location.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::bigquery::reservation::v1::ListReservationsRequest,google/cloud/bigquery/reservation/v1/reservation.proto#L519}
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return
  /// @googleapis_link{google::cloud::bigquery::reservation::v1::Reservation,google/cloud/bigquery/reservation/v1/reservation.proto#L371}
  ///
  /// [google.cloud.bigquery.reservation.v1.ListReservationsRequest]:
  /// @googleapis_reference_link{google/cloud/bigquery/reservation/v1/reservation.proto#L519}
  /// [google.cloud.bigquery.reservation.v1.Reservation]:
  /// @googleapis_reference_link{google/cloud/bigquery/reservation/v1/reservation.proto#L371}
  ///
  StreamRange<google::cloud::bigquery::reservation::v1::Reservation>
  ListReservations(
      google::cloud::bigquery::reservation::v1::ListReservationsRequest request,
      Options opts = {});

  ///
  /// Returns information about the reservation.
  ///
  /// @param name  Required. Resource name of the reservation to retrieve. E.g.,
  ///     `projects/myproject/locations/US/reservations/team1-prod`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return
  /// @googleapis_link{google::cloud::bigquery::reservation::v1::Reservation,google/cloud/bigquery/reservation/v1/reservation.proto#L371}
  ///
  /// [google.cloud.bigquery.reservation.v1.GetReservationRequest]:
  /// @googleapis_reference_link{google/cloud/bigquery/reservation/v1/reservation.proto#L547}
  /// [google.cloud.bigquery.reservation.v1.Reservation]:
  /// @googleapis_reference_link{google/cloud/bigquery/reservation/v1/reservation.proto#L371}
  ///
  StatusOr<google::cloud::bigquery::reservation::v1::Reservation>
  GetReservation(std::string const& name, Options opts = {});

  ///
  /// Returns information about the reservation.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::bigquery::reservation::v1::GetReservationRequest,google/cloud/bigquery/reservation/v1/reservation.proto#L547}
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return
  /// @googleapis_link{google::cloud::bigquery::reservation::v1::Reservation,google/cloud/bigquery/reservation/v1/reservation.proto#L371}
  ///
  /// [google.cloud.bigquery.reservation.v1.GetReservationRequest]:
  /// @googleapis_reference_link{google/cloud/bigquery/reservation/v1/reservation.proto#L547}
  /// [google.cloud.bigquery.reservation.v1.Reservation]:
  /// @googleapis_reference_link{google/cloud/bigquery/reservation/v1/reservation.proto#L371}
  ///
  StatusOr<google::cloud::bigquery::reservation::v1::Reservation>
  GetReservation(
      google::cloud::bigquery::reservation::v1::GetReservationRequest const&
          request,
      Options opts = {});

  ///
  /// Deletes a reservation.
  /// Returns `google.rpc.Code.FAILED_PRECONDITION` when reservation has
  /// assignments.
  ///
  /// @param name  Required. Resource name of the reservation to retrieve. E.g.,
  ///     `projects/myproject/locations/US/reservations/team1-prod`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  ///
  /// [google.cloud.bigquery.reservation.v1.DeleteReservationRequest]:
  /// @googleapis_reference_link{google/cloud/bigquery/reservation/v1/reservation.proto#L559}
  ///
  Status DeleteReservation(std::string const& name, Options opts = {});

  ///
  /// Deletes a reservation.
  /// Returns `google.rpc.Code.FAILED_PRECONDITION` when reservation has
  /// assignments.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::bigquery::reservation::v1::DeleteReservationRequest,google/cloud/bigquery/reservation/v1/reservation.proto#L559}
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  ///
  /// [google.cloud.bigquery.reservation.v1.DeleteReservationRequest]:
  /// @googleapis_reference_link{google/cloud/bigquery/reservation/v1/reservation.proto#L559}
  ///
  Status DeleteReservation(
      google::cloud::bigquery::reservation::v1::DeleteReservationRequest const&
          request,
      Options opts = {});

  ///
  /// Updates an existing reservation resource.
  ///
  /// @param reservation  Content of the reservation to update.
  /// @param update_mask  Standard field mask for the set of fields to be
  /// updated.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return
  /// @googleapis_link{google::cloud::bigquery::reservation::v1::Reservation,google/cloud/bigquery/reservation/v1/reservation.proto#L371}
  ///
  /// [google.cloud.bigquery.reservation.v1.UpdateReservationRequest]:
  /// @googleapis_reference_link{google/cloud/bigquery/reservation/v1/reservation.proto#L571}
  /// [google.cloud.bigquery.reservation.v1.Reservation]:
  /// @googleapis_reference_link{google/cloud/bigquery/reservation/v1/reservation.proto#L371}
  ///
  StatusOr<google::cloud::bigquery::reservation::v1::Reservation>
  UpdateReservation(
      google::cloud::bigquery::reservation::v1::Reservation const& reservation,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  ///
  /// Updates an existing reservation resource.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::bigquery::reservation::v1::UpdateReservationRequest,google/cloud/bigquery/reservation/v1/reservation.proto#L571}
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return
  /// @googleapis_link{google::cloud::bigquery::reservation::v1::Reservation,google/cloud/bigquery/reservation/v1/reservation.proto#L371}
  ///
  /// [google.cloud.bigquery.reservation.v1.UpdateReservationRequest]:
  /// @googleapis_reference_link{google/cloud/bigquery/reservation/v1/reservation.proto#L571}
  /// [google.cloud.bigquery.reservation.v1.Reservation]:
  /// @googleapis_reference_link{google/cloud/bigquery/reservation/v1/reservation.proto#L371}
  ///
  StatusOr<google::cloud::bigquery::reservation::v1::Reservation>
  UpdateReservation(
      google::cloud::bigquery::reservation::v1::UpdateReservationRequest const&
          request,
      Options opts = {});

  ///
  /// Creates a new capacity commitment resource.
  ///
  /// @param parent  Required. Resource name of the parent reservation. E.g.,
  ///     `projects/myproject/locations/US`
  /// @param capacity_commitment  Content of the capacity commitment to create.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return
  /// @googleapis_link{google::cloud::bigquery::reservation::v1::CapacityCommitment,google/cloud/bigquery/reservation/v1/reservation.proto#L416}
  ///
  /// [google.cloud.bigquery.reservation.v1.CreateCapacityCommitmentRequest]:
  /// @googleapis_reference_link{google/cloud/bigquery/reservation/v1/reservation.proto#L580}
  /// [google.cloud.bigquery.reservation.v1.CapacityCommitment]:
  /// @googleapis_reference_link{google/cloud/bigquery/reservation/v1/reservation.proto#L416}
  ///
  StatusOr<google::cloud::bigquery::reservation::v1::CapacityCommitment>
  CreateCapacityCommitment(
      std::string const& parent,
      google::cloud::bigquery::reservation::v1::CapacityCommitment const&
          capacity_commitment,
      Options opts = {});

  ///
  /// Creates a new capacity commitment resource.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::bigquery::reservation::v1::CreateCapacityCommitmentRequest,google/cloud/bigquery/reservation/v1/reservation.proto#L580}
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return
  /// @googleapis_link{google::cloud::bigquery::reservation::v1::CapacityCommitment,google/cloud/bigquery/reservation/v1/reservation.proto#L416}
  ///
  /// [google.cloud.bigquery.reservation.v1.CreateCapacityCommitmentRequest]:
  /// @googleapis_reference_link{google/cloud/bigquery/reservation/v1/reservation.proto#L580}
  /// [google.cloud.bigquery.reservation.v1.CapacityCommitment]:
  /// @googleapis_reference_link{google/cloud/bigquery/reservation/v1/reservation.proto#L416}
  ///
  StatusOr<google::cloud::bigquery::reservation::v1::CapacityCommitment>
  CreateCapacityCommitment(google::cloud::bigquery::reservation::v1::
                               CreateCapacityCommitmentRequest const& request,
                           Options opts = {});

  ///
  /// Lists all the capacity commitments for the admin project.
  ///
  /// @param parent  Required. Resource name of the parent reservation. E.g.,
  ///     `projects/myproject/locations/US`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return
  /// @googleapis_link{google::cloud::bigquery::reservation::v1::CapacityCommitment,google/cloud/bigquery/reservation/v1/reservation.proto#L416}
  ///
  /// [google.cloud.bigquery.reservation.v1.ListCapacityCommitmentsRequest]:
  /// @googleapis_reference_link{google/cloud/bigquery/reservation/v1/reservation.proto#L606}
  /// [google.cloud.bigquery.reservation.v1.CapacityCommitment]:
  /// @googleapis_reference_link{google/cloud/bigquery/reservation/v1/reservation.proto#L416}
  ///
  StreamRange<google::cloud::bigquery::reservation::v1::CapacityCommitment>
  ListCapacityCommitments(std::string const& parent, Options opts = {});

  ///
  /// Lists all the capacity commitments for the admin project.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::bigquery::reservation::v1::ListCapacityCommitmentsRequest,google/cloud/bigquery/reservation/v1/reservation.proto#L606}
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return
  /// @googleapis_link{google::cloud::bigquery::reservation::v1::CapacityCommitment,google/cloud/bigquery/reservation/v1/reservation.proto#L416}
  ///
  /// [google.cloud.bigquery.reservation.v1.ListCapacityCommitmentsRequest]:
  /// @googleapis_reference_link{google/cloud/bigquery/reservation/v1/reservation.proto#L606}
  /// [google.cloud.bigquery.reservation.v1.CapacityCommitment]:
  /// @googleapis_reference_link{google/cloud/bigquery/reservation/v1/reservation.proto#L416}
  ///
  StreamRange<google::cloud::bigquery::reservation::v1::CapacityCommitment>
  ListCapacityCommitments(
      google::cloud::bigquery::reservation::v1::ListCapacityCommitmentsRequest
          request,
      Options opts = {});

  ///
  /// Returns information about the capacity commitment.
  ///
  /// @param name  Required. Resource name of the capacity commitment to
  /// retrieve. E.g.,
  ///     `projects/myproject/locations/US/capacityCommitments/123`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return
  /// @googleapis_link{google::cloud::bigquery::reservation::v1::CapacityCommitment,google/cloud/bigquery/reservation/v1/reservation.proto#L416}
  ///
  /// [google.cloud.bigquery.reservation.v1.GetCapacityCommitmentRequest]:
  /// @googleapis_reference_link{google/cloud/bigquery/reservation/v1/reservation.proto#L634}
  /// [google.cloud.bigquery.reservation.v1.CapacityCommitment]:
  /// @googleapis_reference_link{google/cloud/bigquery/reservation/v1/reservation.proto#L416}
  ///
  StatusOr<google::cloud::bigquery::reservation::v1::CapacityCommitment>
  GetCapacityCommitment(std::string const& name, Options opts = {});

  ///
  /// Returns information about the capacity commitment.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::bigquery::reservation::v1::GetCapacityCommitmentRequest,google/cloud/bigquery/reservation/v1/reservation.proto#L634}
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return
  /// @googleapis_link{google::cloud::bigquery::reservation::v1::CapacityCommitment,google/cloud/bigquery/reservation/v1/reservation.proto#L416}
  ///
  /// [google.cloud.bigquery.reservation.v1.GetCapacityCommitmentRequest]:
  /// @googleapis_reference_link{google/cloud/bigquery/reservation/v1/reservation.proto#L634}
  /// [google.cloud.bigquery.reservation.v1.CapacityCommitment]:
  /// @googleapis_reference_link{google/cloud/bigquery/reservation/v1/reservation.proto#L416}
  ///
  StatusOr<google::cloud::bigquery::reservation::v1::CapacityCommitment>
  GetCapacityCommitment(google::cloud::bigquery::reservation::v1::
                            GetCapacityCommitmentRequest const& request,
                        Options opts = {});

  ///
  /// Deletes a capacity commitment. Attempting to delete capacity commitment
  /// before its commitment_end_time will fail with the error code
  /// `google.rpc.Code.FAILED_PRECONDITION`.
  ///
  /// @param name  Required. Resource name of the capacity commitment to delete.
  /// E.g.,
  ///     `projects/myproject/locations/US/capacityCommitments/123`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  ///
  /// [google.cloud.bigquery.reservation.v1.DeleteCapacityCommitmentRequest]:
  /// @googleapis_reference_link{google/cloud/bigquery/reservation/v1/reservation.proto#L646}
  ///
  Status DeleteCapacityCommitment(std::string const& name, Options opts = {});

  ///
  /// Deletes a capacity commitment. Attempting to delete capacity commitment
  /// before its commitment_end_time will fail with the error code
  /// `google.rpc.Code.FAILED_PRECONDITION`.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::bigquery::reservation::v1::DeleteCapacityCommitmentRequest,google/cloud/bigquery/reservation/v1/reservation.proto#L646}
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  ///
  /// [google.cloud.bigquery.reservation.v1.DeleteCapacityCommitmentRequest]:
  /// @googleapis_reference_link{google/cloud/bigquery/reservation/v1/reservation.proto#L646}
  ///
  Status DeleteCapacityCommitment(
      google::cloud::bigquery::reservation::v1::
          DeleteCapacityCommitmentRequest const& request,
      Options opts = {});

  ///
  /// Updates an existing capacity commitment.
  ///
  /// Only `plan` and `renewal_plan` fields can be updated.
  ///
  /// Plan can only be changed to a plan of a longer commitment period.
  /// Attempting to change to a plan with shorter commitment period will fail
  /// with the error code `google.rpc.Code.FAILED_PRECONDITION`.
  ///
  /// @param capacity_commitment  Content of the capacity commitment to update.
  /// @param update_mask  Standard field mask for the set of fields to be
  /// updated.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return
  /// @googleapis_link{google::cloud::bigquery::reservation::v1::CapacityCommitment,google/cloud/bigquery/reservation/v1/reservation.proto#L416}
  ///
  /// [google.cloud.bigquery.reservation.v1.UpdateCapacityCommitmentRequest]:
  /// @googleapis_reference_link{google/cloud/bigquery/reservation/v1/reservation.proto#L663}
  /// [google.cloud.bigquery.reservation.v1.CapacityCommitment]:
  /// @googleapis_reference_link{google/cloud/bigquery/reservation/v1/reservation.proto#L416}
  ///
  StatusOr<google::cloud::bigquery::reservation::v1::CapacityCommitment>
  UpdateCapacityCommitment(
      google::cloud::bigquery::reservation::v1::CapacityCommitment const&
          capacity_commitment,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  ///
  /// Updates an existing capacity commitment.
  ///
  /// Only `plan` and `renewal_plan` fields can be updated.
  ///
  /// Plan can only be changed to a plan of a longer commitment period.
  /// Attempting to change to a plan with shorter commitment period will fail
  /// with the error code `google.rpc.Code.FAILED_PRECONDITION`.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::bigquery::reservation::v1::UpdateCapacityCommitmentRequest,google/cloud/bigquery/reservation/v1/reservation.proto#L663}
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return
  /// @googleapis_link{google::cloud::bigquery::reservation::v1::CapacityCommitment,google/cloud/bigquery/reservation/v1/reservation.proto#L416}
  ///
  /// [google.cloud.bigquery.reservation.v1.UpdateCapacityCommitmentRequest]:
  /// @googleapis_reference_link{google/cloud/bigquery/reservation/v1/reservation.proto#L663}
  /// [google.cloud.bigquery.reservation.v1.CapacityCommitment]:
  /// @googleapis_reference_link{google/cloud/bigquery/reservation/v1/reservation.proto#L416}
  ///
  StatusOr<google::cloud::bigquery::reservation::v1::CapacityCommitment>
  UpdateCapacityCommitment(google::cloud::bigquery::reservation::v1::
                               UpdateCapacityCommitmentRequest const& request,
                           Options opts = {});

  ///
  /// Splits capacity commitment to two commitments of the same plan and
  /// `commitment_end_time`.
  ///
  /// A common use case is to enable downgrading commitments.
  ///
  /// For example, in order to downgrade from 10000 slots to 8000, you might
  /// split a 10000 capacity commitment into commitments of 2000 and 8000. Then,
  /// you would change the plan of the first one to `FLEX` and then delete it.
  ///
  /// @param name  Required. The resource name e.g.,:
  ///   `projects/myproject/locations/US/capacityCommitments/123`
  /// @param slot_count  Number of slots in the capacity commitment after the
  /// split.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return
  /// @googleapis_link{google::cloud::bigquery::reservation::v1::SplitCapacityCommitmentResponse,google/cloud/bigquery/reservation/v1/reservation.proto#L687}
  ///
  /// [google.cloud.bigquery.reservation.v1.SplitCapacityCommitmentRequest]:
  /// @googleapis_reference_link{google/cloud/bigquery/reservation/v1/reservation.proto#L672}
  /// [google.cloud.bigquery.reservation.v1.SplitCapacityCommitmentResponse]:
  /// @googleapis_reference_link{google/cloud/bigquery/reservation/v1/reservation.proto#L687}
  ///
  StatusOr<
      google::cloud::bigquery::reservation::v1::SplitCapacityCommitmentResponse>
  SplitCapacityCommitment(std::string const& name, std::int64_t slot_count,
                          Options opts = {});

  ///
  /// Splits capacity commitment to two commitments of the same plan and
  /// `commitment_end_time`.
  ///
  /// A common use case is to enable downgrading commitments.
  ///
  /// For example, in order to downgrade from 10000 slots to 8000, you might
  /// split a 10000 capacity commitment into commitments of 2000 and 8000. Then,
  /// you would change the plan of the first one to `FLEX` and then delete it.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::bigquery::reservation::v1::SplitCapacityCommitmentRequest,google/cloud/bigquery/reservation/v1/reservation.proto#L672}
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return
  /// @googleapis_link{google::cloud::bigquery::reservation::v1::SplitCapacityCommitmentResponse,google/cloud/bigquery/reservation/v1/reservation.proto#L687}
  ///
  /// [google.cloud.bigquery.reservation.v1.SplitCapacityCommitmentRequest]:
  /// @googleapis_reference_link{google/cloud/bigquery/reservation/v1/reservation.proto#L672}
  /// [google.cloud.bigquery.reservation.v1.SplitCapacityCommitmentResponse]:
  /// @googleapis_reference_link{google/cloud/bigquery/reservation/v1/reservation.proto#L687}
  ///
  StatusOr<
      google::cloud::bigquery::reservation::v1::SplitCapacityCommitmentResponse>
  SplitCapacityCommitment(google::cloud::bigquery::reservation::v1::
                              SplitCapacityCommitmentRequest const& request,
                          Options opts = {});

  ///
  /// Merges capacity commitments of the same plan into a single commitment.
  ///
  /// The resulting capacity commitment has the greater commitment_end_time
  /// out of the to-be-merged capacity commitments.
  ///
  /// Attempting to merge capacity commitments of different plan will fail
  /// with the error code `google.rpc.Code.FAILED_PRECONDITION`.
  ///
  /// @param parent  Parent resource that identifies admin project and location
  /// e.g.,
  ///   `projects/myproject/locations/us`
  /// @param capacity_commitment_ids  Ids of capacity commitments to merge.
  ///  These capacity commitments must exist under admin project and location
  ///  specified in the parent.
  ///  ID is the last portion of capacity commitment name e.g., 'abc' for
  ///  projects/myproject/locations/US/capacityCommitments/abc
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return
  /// @googleapis_link{google::cloud::bigquery::reservation::v1::CapacityCommitment,google/cloud/bigquery/reservation/v1/reservation.proto#L416}
  ///
  /// [google.cloud.bigquery.reservation.v1.MergeCapacityCommitmentsRequest]:
  /// @googleapis_reference_link{google/cloud/bigquery/reservation/v1/reservation.proto#L696}
  /// [google.cloud.bigquery.reservation.v1.CapacityCommitment]:
  /// @googleapis_reference_link{google/cloud/bigquery/reservation/v1/reservation.proto#L416}
  ///
  StatusOr<google::cloud::bigquery::reservation::v1::CapacityCommitment>
  MergeCapacityCommitments(
      std::string const& parent,
      std::vector<std::string> const& capacity_commitment_ids,
      Options opts = {});

  ///
  /// Merges capacity commitments of the same plan into a single commitment.
  ///
  /// The resulting capacity commitment has the greater commitment_end_time
  /// out of the to-be-merged capacity commitments.
  ///
  /// Attempting to merge capacity commitments of different plan will fail
  /// with the error code `google.rpc.Code.FAILED_PRECONDITION`.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::bigquery::reservation::v1::MergeCapacityCommitmentsRequest,google/cloud/bigquery/reservation/v1/reservation.proto#L696}
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return
  /// @googleapis_link{google::cloud::bigquery::reservation::v1::CapacityCommitment,google/cloud/bigquery/reservation/v1/reservation.proto#L416}
  ///
  /// [google.cloud.bigquery.reservation.v1.MergeCapacityCommitmentsRequest]:
  /// @googleapis_reference_link{google/cloud/bigquery/reservation/v1/reservation.proto#L696}
  /// [google.cloud.bigquery.reservation.v1.CapacityCommitment]:
  /// @googleapis_reference_link{google/cloud/bigquery/reservation/v1/reservation.proto#L416}
  ///
  StatusOr<google::cloud::bigquery::reservation::v1::CapacityCommitment>
  MergeCapacityCommitments(google::cloud::bigquery::reservation::v1::
                               MergeCapacityCommitmentsRequest const& request,
                           Options opts = {});

  ///
  /// Creates an assignment object which allows the given project to submit jobs
  /// of a certain type using slots from the specified reservation.
  ///
  /// Currently a
  /// resource (project, folder, organization) can only have one assignment per
  /// each (job_type, location) combination, and that reservation will be used
  /// for all jobs of the matching type.
  ///
  /// Different assignments can be created on different levels of the
  /// projects, folders or organization hierarchy.  During query execution,
  /// the assignment is looked up at the project, folder and organization levels
  /// in that order. The first assignment found is applied to the query.
  ///
  /// When creating assignments, it does not matter if other assignments exist
  /// at higher levels.
  ///
  /// Example:
  ///
  /// * The organization `organizationA` contains two projects, `project1`
  ///   and `project2`.
  /// * Assignments for all three entities (`organizationA`, `project1`, and
  ///   `project2`) could all be created and mapped to the same or different
  ///   reservations.
  ///
  /// "None" assignments represent an absence of the assignment. Projects
  /// assigned to None use on-demand pricing. To create a "None" assignment, use
  /// "none" as a reservation_id in the parent. Example parent:
  /// `projects/myproject/locations/US/reservations/none`.
  ///
  /// Returns `google.rpc.Code.PERMISSION_DENIED` if user does not have
  /// 'bigquery.admin' permissions on the project using the reservation
  /// and the project that owns this reservation.
  ///
  /// Returns `google.rpc.Code.INVALID_ARGUMENT` when location of the assignment
  /// does not match location of the reservation.
  ///
  /// @param parent  Required. The parent resource name of the assignment
  ///  E.g. `projects/myproject/locations/US/reservations/team1-prod`
  /// @param assignment  Assignment resource to create.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return
  /// @googleapis_link{google::cloud::bigquery::reservation::v1::Assignment,google/cloud/bigquery/reservation/v1/reservation.proto#L713}
  ///
  /// [google.cloud.bigquery.reservation.v1.CreateAssignmentRequest]:
  /// @googleapis_reference_link{google/cloud/bigquery/reservation/v1/reservation.proto#L769}
  /// [google.cloud.bigquery.reservation.v1.Assignment]:
  /// @googleapis_reference_link{google/cloud/bigquery/reservation/v1/reservation.proto#L713}
  ///
  StatusOr<google::cloud::bigquery::reservation::v1::Assignment>
  CreateAssignment(
      std::string const& parent,
      google::cloud::bigquery::reservation::v1::Assignment const& assignment,
      Options opts = {});

  ///
  /// Creates an assignment object which allows the given project to submit jobs
  /// of a certain type using slots from the specified reservation.
  ///
  /// Currently a
  /// resource (project, folder, organization) can only have one assignment per
  /// each (job_type, location) combination, and that reservation will be used
  /// for all jobs of the matching type.
  ///
  /// Different assignments can be created on different levels of the
  /// projects, folders or organization hierarchy.  During query execution,
  /// the assignment is looked up at the project, folder and organization levels
  /// in that order. The first assignment found is applied to the query.
  ///
  /// When creating assignments, it does not matter if other assignments exist
  /// at higher levels.
  ///
  /// Example:
  ///
  /// * The organization `organizationA` contains two projects, `project1`
  ///   and `project2`.
  /// * Assignments for all three entities (`organizationA`, `project1`, and
  ///   `project2`) could all be created and mapped to the same or different
  ///   reservations.
  ///
  /// "None" assignments represent an absence of the assignment. Projects
  /// assigned to None use on-demand pricing. To create a "None" assignment, use
  /// "none" as a reservation_id in the parent. Example parent:
  /// `projects/myproject/locations/US/reservations/none`.
  ///
  /// Returns `google.rpc.Code.PERMISSION_DENIED` if user does not have
  /// 'bigquery.admin' permissions on the project using the reservation
  /// and the project that owns this reservation.
  ///
  /// Returns `google.rpc.Code.INVALID_ARGUMENT` when location of the assignment
  /// does not match location of the reservation.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::bigquery::reservation::v1::CreateAssignmentRequest,google/cloud/bigquery/reservation/v1/reservation.proto#L769}
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return
  /// @googleapis_link{google::cloud::bigquery::reservation::v1::Assignment,google/cloud/bigquery/reservation/v1/reservation.proto#L713}
  ///
  /// [google.cloud.bigquery.reservation.v1.CreateAssignmentRequest]:
  /// @googleapis_reference_link{google/cloud/bigquery/reservation/v1/reservation.proto#L769}
  /// [google.cloud.bigquery.reservation.v1.Assignment]:
  /// @googleapis_reference_link{google/cloud/bigquery/reservation/v1/reservation.proto#L713}
  ///
  StatusOr<google::cloud::bigquery::reservation::v1::Assignment>
  CreateAssignment(
      google::cloud::bigquery::reservation::v1::CreateAssignmentRequest const&
          request,
      Options opts = {});

  ///
  /// Lists assignments.
  ///
  /// Only explicitly created assignments will be returned.
  ///
  /// Example:
  ///
  /// * Organization `organizationA` contains two projects, `project1` and
  ///   `project2`.
  /// * Reservation `res1` exists and was created previously.
  /// * CreateAssignment was used previously to define the following
  ///   associations between entities and reservations: `<organizationA, res1>`
  ///   and `<project1, res1>`
  ///
  /// In this example, ListAssignments will just return the above two
  /// assignments for reservation `res1`, and no expansion/merge will happen.
  ///
  /// The wildcard "-" can be used for
  /// reservations in the request. In that case all assignments belongs to the
  /// specified project and location will be listed.
  ///
  /// **Note** "-" cannot be used for projects nor locations.
  ///
  /// @param parent  Required. The parent resource name e.g.:
  ///  `projects/myproject/locations/US/reservations/team1-prod`
  ///  Or:
  ///  `projects/myproject/locations/US/reservations/-`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return
  /// @googleapis_link{google::cloud::bigquery::reservation::v1::Assignment,google/cloud/bigquery/reservation/v1/reservation.proto#L713}
  ///
  /// [google.cloud.bigquery.reservation.v1.ListAssignmentsRequest]:
  /// @googleapis_reference_link{google/cloud/bigquery/reservation/v1/reservation.proto#L790}
  /// [google.cloud.bigquery.reservation.v1.Assignment]:
  /// @googleapis_reference_link{google/cloud/bigquery/reservation/v1/reservation.proto#L713}
  ///
  StreamRange<google::cloud::bigquery::reservation::v1::Assignment>
  ListAssignments(std::string const& parent, Options opts = {});

  ///
  /// Lists assignments.
  ///
  /// Only explicitly created assignments will be returned.
  ///
  /// Example:
  ///
  /// * Organization `organizationA` contains two projects, `project1` and
  ///   `project2`.
  /// * Reservation `res1` exists and was created previously.
  /// * CreateAssignment was used previously to define the following
  ///   associations between entities and reservations: `<organizationA, res1>`
  ///   and `<project1, res1>`
  ///
  /// In this example, ListAssignments will just return the above two
  /// assignments for reservation `res1`, and no expansion/merge will happen.
  ///
  /// The wildcard "-" can be used for
  /// reservations in the request. In that case all assignments belongs to the
  /// specified project and location will be listed.
  ///
  /// **Note** "-" cannot be used for projects nor locations.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::bigquery::reservation::v1::ListAssignmentsRequest,google/cloud/bigquery/reservation/v1/reservation.proto#L790}
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return
  /// @googleapis_link{google::cloud::bigquery::reservation::v1::Assignment,google/cloud/bigquery/reservation/v1/reservation.proto#L713}
  ///
  /// [google.cloud.bigquery.reservation.v1.ListAssignmentsRequest]:
  /// @googleapis_reference_link{google/cloud/bigquery/reservation/v1/reservation.proto#L790}
  /// [google.cloud.bigquery.reservation.v1.Assignment]:
  /// @googleapis_reference_link{google/cloud/bigquery/reservation/v1/reservation.proto#L713}
  ///
  StreamRange<google::cloud::bigquery::reservation::v1::Assignment>
  ListAssignments(
      google::cloud::bigquery::reservation::v1::ListAssignmentsRequest request,
      Options opts = {});

  ///
  /// Deletes a assignment. No expansion will happen.
  ///
  /// Example:
  ///
  /// * Organization `organizationA` contains two projects, `project1` and
  ///   `project2`.
  /// * Reservation `res1` exists and was created previously.
  /// * CreateAssignment was used previously to define the following
  ///   associations between entities and reservations: `<organizationA, res1>`
  ///   and `<project1, res1>`
  ///
  /// In this example, deletion of the `<organizationA, res1>` assignment won't
  /// affect the other assignment `<project1, res1>`. After said deletion,
  /// queries from `project1` will still use `res1` while queries from
  /// `project2` will switch to use on-demand mode.
  ///
  /// @param name  Required. Name of the resource, e.g.
  ///    `projects/myproject/locations/US/reservations/team1-prod/assignments/123`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  ///
  /// [google.cloud.bigquery.reservation.v1.DeleteAssignmentRequest]:
  /// @googleapis_reference_link{google/cloud/bigquery/reservation/v1/reservation.proto#L825}
  ///
  Status DeleteAssignment(std::string const& name, Options opts = {});

  ///
  /// Deletes a assignment. No expansion will happen.
  ///
  /// Example:
  ///
  /// * Organization `organizationA` contains two projects, `project1` and
  ///   `project2`.
  /// * Reservation `res1` exists and was created previously.
  /// * CreateAssignment was used previously to define the following
  ///   associations between entities and reservations: `<organizationA, res1>`
  ///   and `<project1, res1>`
  ///
  /// In this example, deletion of the `<organizationA, res1>` assignment won't
  /// affect the other assignment `<project1, res1>`. After said deletion,
  /// queries from `project1` will still use `res1` while queries from
  /// `project2` will switch to use on-demand mode.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::bigquery::reservation::v1::DeleteAssignmentRequest,google/cloud/bigquery/reservation/v1/reservation.proto#L825}
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  ///
  /// [google.cloud.bigquery.reservation.v1.DeleteAssignmentRequest]:
  /// @googleapis_reference_link{google/cloud/bigquery/reservation/v1/reservation.proto#L825}
  ///
  Status DeleteAssignment(
      google::cloud::bigquery::reservation::v1::DeleteAssignmentRequest const&
          request,
      Options opts = {});

  ///
  /// Deprecated: Looks up assignments for a specified resource for a particular
  /// region. If the request is about a project:
  ///
  /// 1. Assignments created on the project will be returned if they exist.
  /// 2. Otherwise assignments created on the closest ancestor will be
  ///    returned.
  /// 3. Assignments for different JobTypes will all be returned.
  ///
  /// The same logic applies if the request is about a folder.
  ///
  /// If the request is about an organization, then assignments created on the
  /// organization will be returned (organization doesn't have ancestors).
  ///
  /// Comparing to ListAssignments, there are some behavior
  /// differences:
  ///
  /// 1. permission on the assignee will be verified in this API.
  /// 2. Hierarchy lookup (project->folder->organization) happens in this API.
  /// 3. Parent here is `projects/*/locations/*`, instead of
  ///    `projects/*/locations/*reservations/*`.
  ///
  /// **Note** "-" cannot be used for projects
  /// nor locations.
  ///
  /// @param parent  Required. The resource name of the admin project(containing
  /// project and location),
  ///  e.g.:
  ///    `projects/myproject/locations/US`.
  /// @param query  Please specify resource name as assignee in the query.
  ///  Examples:
  ///  * `assignee=projects/myproject`
  ///  * `assignee=folders/123`
  ///  * `assignee=organizations/456`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return
  /// @googleapis_link{google::cloud::bigquery::reservation::v1::Assignment,google/cloud/bigquery/reservation/v1/reservation.proto#L713}
  ///
  /// [google.cloud.bigquery.reservation.v1.SearchAssignmentsRequest]:
  /// @googleapis_reference_link{google/cloud/bigquery/reservation/v1/reservation.proto#L840}
  /// [google.cloud.bigquery.reservation.v1.Assignment]:
  /// @googleapis_reference_link{google/cloud/bigquery/reservation/v1/reservation.proto#L713}
  ///
  StreamRange<google::cloud::bigquery::reservation::v1::Assignment>
  SearchAssignments(std::string const& parent, std::string const& query,
                    Options opts = {});

  ///
  /// Deprecated: Looks up assignments for a specified resource for a particular
  /// region. If the request is about a project:
  ///
  /// 1. Assignments created on the project will be returned if they exist.
  /// 2. Otherwise assignments created on the closest ancestor will be
  ///    returned.
  /// 3. Assignments for different JobTypes will all be returned.
  ///
  /// The same logic applies if the request is about a folder.
  ///
  /// If the request is about an organization, then assignments created on the
  /// organization will be returned (organization doesn't have ancestors).
  ///
  /// Comparing to ListAssignments, there are some behavior
  /// differences:
  ///
  /// 1. permission on the assignee will be verified in this API.
  /// 2. Hierarchy lookup (project->folder->organization) happens in this API.
  /// 3. Parent here is `projects/*/locations/*`, instead of
  ///    `projects/*/locations/*reservations/*`.
  ///
  /// **Note** "-" cannot be used for projects
  /// nor locations.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::bigquery::reservation::v1::SearchAssignmentsRequest,google/cloud/bigquery/reservation/v1/reservation.proto#L840}
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return
  /// @googleapis_link{google::cloud::bigquery::reservation::v1::Assignment,google/cloud/bigquery/reservation/v1/reservation.proto#L713}
  ///
  /// [google.cloud.bigquery.reservation.v1.SearchAssignmentsRequest]:
  /// @googleapis_reference_link{google/cloud/bigquery/reservation/v1/reservation.proto#L840}
  /// [google.cloud.bigquery.reservation.v1.Assignment]:
  /// @googleapis_reference_link{google/cloud/bigquery/reservation/v1/reservation.proto#L713}
  ///
  StreamRange<google::cloud::bigquery::reservation::v1::Assignment>
  SearchAssignments(
      google::cloud::bigquery::reservation::v1::SearchAssignmentsRequest
          request,
      Options opts = {});

  ///
  /// Looks up assignments for a specified resource for a particular region.
  /// If the request is about a project:
  ///
  /// 1. Assignments created on the project will be returned if they exist.
  /// 2. Otherwise assignments created on the closest ancestor will be
  ///    returned.
  /// 3. Assignments for different JobTypes will all be returned.
  ///
  /// The same logic applies if the request is about a folder.
  ///
  /// If the request is about an organization, then assignments created on the
  /// organization will be returned (organization doesn't have ancestors).
  ///
  /// Comparing to ListAssignments, there are some behavior
  /// differences:
  ///
  /// 1. permission on the assignee will be verified in this API.
  /// 2. Hierarchy lookup (project->folder->organization) happens in this API.
  /// 3. Parent here is `projects/*/locations/*`, instead of
  ///    `projects/*/locations/*reservations/*`.
  ///
  /// @param parent  Required. The resource name with location (project name
  /// could be the wildcard '-'),
  ///  e.g.:
  ///    `projects/-/locations/US`.
  /// @param query  Please specify resource name as assignee in the query.
  ///  Examples:
  ///  * `assignee=projects/myproject`
  ///  * `assignee=folders/123`
  ///  * `assignee=organizations/456`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return
  /// @googleapis_link{google::cloud::bigquery::reservation::v1::Assignment,google/cloud/bigquery/reservation/v1/reservation.proto#L713}
  ///
  /// [google.cloud.bigquery.reservation.v1.SearchAllAssignmentsRequest]:
  /// @googleapis_reference_link{google/cloud/bigquery/reservation/v1/reservation.proto#L871}
  /// [google.cloud.bigquery.reservation.v1.Assignment]:
  /// @googleapis_reference_link{google/cloud/bigquery/reservation/v1/reservation.proto#L713}
  ///
  StreamRange<google::cloud::bigquery::reservation::v1::Assignment>
  SearchAllAssignments(std::string const& parent, std::string const& query,
                       Options opts = {});

  ///
  /// Looks up assignments for a specified resource for a particular region.
  /// If the request is about a project:
  ///
  /// 1. Assignments created on the project will be returned if they exist.
  /// 2. Otherwise assignments created on the closest ancestor will be
  ///    returned.
  /// 3. Assignments for different JobTypes will all be returned.
  ///
  /// The same logic applies if the request is about a folder.
  ///
  /// If the request is about an organization, then assignments created on the
  /// organization will be returned (organization doesn't have ancestors).
  ///
  /// Comparing to ListAssignments, there are some behavior
  /// differences:
  ///
  /// 1. permission on the assignee will be verified in this API.
  /// 2. Hierarchy lookup (project->folder->organization) happens in this API.
  /// 3. Parent here is `projects/*/locations/*`, instead of
  ///    `projects/*/locations/*reservations/*`.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::bigquery::reservation::v1::SearchAllAssignmentsRequest,google/cloud/bigquery/reservation/v1/reservation.proto#L871}
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return
  /// @googleapis_link{google::cloud::bigquery::reservation::v1::Assignment,google/cloud/bigquery/reservation/v1/reservation.proto#L713}
  ///
  /// [google.cloud.bigquery.reservation.v1.SearchAllAssignmentsRequest]:
  /// @googleapis_reference_link{google/cloud/bigquery/reservation/v1/reservation.proto#L871}
  /// [google.cloud.bigquery.reservation.v1.Assignment]:
  /// @googleapis_reference_link{google/cloud/bigquery/reservation/v1/reservation.proto#L713}
  ///
  StreamRange<google::cloud::bigquery::reservation::v1::Assignment>
  SearchAllAssignments(
      google::cloud::bigquery::reservation::v1::SearchAllAssignmentsRequest
          request,
      Options opts = {});

  ///
  /// Moves an assignment under a new reservation.
  ///
  /// This differs from removing an existing assignment and recreating a new one
  /// by providing a transactional change that ensures an assignee always has an
  /// associated reservation.
  ///
  /// @param name  Required. The resource name of the assignment,
  ///  e.g.
  ///  `projects/myproject/locations/US/reservations/team1-prod/assignments/123`
  /// @param destination_id  The new reservation ID, e.g.:
  ///    `projects/myotherproject/locations/US/reservations/team2-prod`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return
  /// @googleapis_link{google::cloud::bigquery::reservation::v1::Assignment,google/cloud/bigquery/reservation/v1/reservation.proto#L713}
  ///
  /// [google.cloud.bigquery.reservation.v1.MoveAssignmentRequest]:
  /// @googleapis_reference_link{google/cloud/bigquery/reservation/v1/reservation.proto#L927}
  /// [google.cloud.bigquery.reservation.v1.Assignment]:
  /// @googleapis_reference_link{google/cloud/bigquery/reservation/v1/reservation.proto#L713}
  ///
  StatusOr<google::cloud::bigquery::reservation::v1::Assignment> MoveAssignment(
      std::string const& name, std::string const& destination_id,
      Options opts = {});

  ///
  /// Moves an assignment under a new reservation.
  ///
  /// This differs from removing an existing assignment and recreating a new one
  /// by providing a transactional change that ensures an assignee always has an
  /// associated reservation.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::bigquery::reservation::v1::MoveAssignmentRequest,google/cloud/bigquery/reservation/v1/reservation.proto#L927}
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return
  /// @googleapis_link{google::cloud::bigquery::reservation::v1::Assignment,google/cloud/bigquery/reservation/v1/reservation.proto#L713}
  ///
  /// [google.cloud.bigquery.reservation.v1.MoveAssignmentRequest]:
  /// @googleapis_reference_link{google/cloud/bigquery/reservation/v1/reservation.proto#L927}
  /// [google.cloud.bigquery.reservation.v1.Assignment]:
  /// @googleapis_reference_link{google/cloud/bigquery/reservation/v1/reservation.proto#L713}
  ///
  StatusOr<google::cloud::bigquery::reservation::v1::Assignment> MoveAssignment(
      google::cloud::bigquery::reservation::v1::MoveAssignmentRequest const&
          request,
      Options opts = {});

  ///
  /// Retrieves a BI reservation.
  ///
  /// @param name  Required. Name of the requested reservation, for example:
  ///  `projects/{project_id}/locations/{location_id}/biReservation`
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return
  /// @googleapis_link{google::cloud::bigquery::reservation::v1::BiReservation,google/cloud/bigquery/reservation/v1/reservation.proto#L946}
  ///
  /// [google.cloud.bigquery.reservation.v1.GetBiReservationRequest]:
  /// @googleapis_reference_link{google/cloud/bigquery/reservation/v1/reservation.proto#L965}
  /// [google.cloud.bigquery.reservation.v1.BiReservation]:
  /// @googleapis_reference_link{google/cloud/bigquery/reservation/v1/reservation.proto#L946}
  ///
  StatusOr<google::cloud::bigquery::reservation::v1::BiReservation>
  GetBiReservation(std::string const& name, Options opts = {});

  ///
  /// Retrieves a BI reservation.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::bigquery::reservation::v1::GetBiReservationRequest,google/cloud/bigquery/reservation/v1/reservation.proto#L965}
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return
  /// @googleapis_link{google::cloud::bigquery::reservation::v1::BiReservation,google/cloud/bigquery/reservation/v1/reservation.proto#L946}
  ///
  /// [google.cloud.bigquery.reservation.v1.GetBiReservationRequest]:
  /// @googleapis_reference_link{google/cloud/bigquery/reservation/v1/reservation.proto#L965}
  /// [google.cloud.bigquery.reservation.v1.BiReservation]:
  /// @googleapis_reference_link{google/cloud/bigquery/reservation/v1/reservation.proto#L946}
  ///
  StatusOr<google::cloud::bigquery::reservation::v1::BiReservation>
  GetBiReservation(
      google::cloud::bigquery::reservation::v1::GetBiReservationRequest const&
          request,
      Options opts = {});

  ///
  /// Updates a BI reservation.
  ///
  /// Only fields specified in the `field_mask` are updated.
  ///
  /// A singleton BI reservation always exists with default size 0.
  /// In order to reserve BI capacity it needs to be updated to an amount
  /// greater than 0. In order to release BI capacity reservation size
  /// must be set to 0.
  ///
  /// @param bi_reservation  A reservation to update.
  /// @param update_mask  A list of fields to be updated in this request.
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return
  /// @googleapis_link{google::cloud::bigquery::reservation::v1::BiReservation,google/cloud/bigquery/reservation/v1/reservation.proto#L946}
  ///
  /// [google.cloud.bigquery.reservation.v1.UpdateBiReservationRequest]:
  /// @googleapis_reference_link{google/cloud/bigquery/reservation/v1/reservation.proto#L977}
  /// [google.cloud.bigquery.reservation.v1.BiReservation]:
  /// @googleapis_reference_link{google/cloud/bigquery/reservation/v1/reservation.proto#L946}
  ///
  StatusOr<google::cloud::bigquery::reservation::v1::BiReservation>
  UpdateBiReservation(
      google::cloud::bigquery::reservation::v1::BiReservation const&
          bi_reservation,
      google::protobuf::FieldMask const& update_mask, Options opts = {});

  ///
  /// Updates a BI reservation.
  ///
  /// Only fields specified in the `field_mask` are updated.
  ///
  /// A singleton BI reservation always exists with default size 0.
  /// In order to reserve BI capacity it needs to be updated to an amount
  /// greater than 0. In order to release BI capacity reservation size
  /// must be set to 0.
  ///
  /// @param request
  /// @googleapis_link{google::cloud::bigquery::reservation::v1::UpdateBiReservationRequest,google/cloud/bigquery/reservation/v1/reservation.proto#L977}
  /// @param opts Optional. Override the class-level options, such as retry and
  ///     backoff policies.
  /// @return
  /// @googleapis_link{google::cloud::bigquery::reservation::v1::BiReservation,google/cloud/bigquery/reservation/v1/reservation.proto#L946}
  ///
  /// [google.cloud.bigquery.reservation.v1.UpdateBiReservationRequest]:
  /// @googleapis_reference_link{google/cloud/bigquery/reservation/v1/reservation.proto#L977}
  /// [google.cloud.bigquery.reservation.v1.BiReservation]:
  /// @googleapis_reference_link{google/cloud/bigquery/reservation/v1/reservation.proto#L946}
  ///
  StatusOr<google::cloud::bigquery::reservation::v1::BiReservation>
  UpdateBiReservation(google::cloud::bigquery::reservation::v1::
                          UpdateBiReservationRequest const& request,
                      Options opts = {});

 private:
  std::shared_ptr<ReservationServiceConnection> connection_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace bigquery
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BIGQUERY_RESERVATION_CLIENT_H
