// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/bigquery/datatransfer/v1/datatransfer.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BIGQUERY_INTERNAL_DATA_TRANSFER_CONNECTION_IMPL_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BIGQUERY_INTERNAL_DATA_TRANSFER_CONNECTION_IMPL_H

#include "google/cloud/bigquery/data_transfer_connection.h"
#include "google/cloud/bigquery/data_transfer_connection_idempotency_policy.h"
#include "google/cloud/bigquery/data_transfer_options.h"
#include "google/cloud/bigquery/internal/data_transfer_retry_traits.h"
#include "google/cloud/bigquery/internal/data_transfer_stub.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/options.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <memory>

namespace google {
namespace cloud {
namespace bigquery_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class DataTransferServiceConnectionImpl
    : public bigquery::DataTransferServiceConnection {
 public:
  ~DataTransferServiceConnectionImpl() override = default;

  DataTransferServiceConnectionImpl(
      std::unique_ptr<google::cloud::BackgroundThreads> background,
      std::shared_ptr<bigquery_internal::DataTransferServiceStub> stub,
      Options options);

  Options options() override { return options_; }

  StatusOr<google::cloud::bigquery::datatransfer::v1::DataSource> GetDataSource(
      google::cloud::bigquery::datatransfer::v1::GetDataSourceRequest const&
          request) override;

  StreamRange<google::cloud::bigquery::datatransfer::v1::DataSource>
  ListDataSources(
      google::cloud::bigquery::datatransfer::v1::ListDataSourcesRequest request)
      override;

  StatusOr<google::cloud::bigquery::datatransfer::v1::TransferConfig>
  CreateTransferConfig(google::cloud::bigquery::datatransfer::v1::
                           CreateTransferConfigRequest const& request) override;

  StatusOr<google::cloud::bigquery::datatransfer::v1::TransferConfig>
  UpdateTransferConfig(google::cloud::bigquery::datatransfer::v1::
                           UpdateTransferConfigRequest const& request) override;

  Status DeleteTransferConfig(
      google::cloud::bigquery::datatransfer::v1::
          DeleteTransferConfigRequest const& request) override;

  StatusOr<google::cloud::bigquery::datatransfer::v1::TransferConfig>
  GetTransferConfig(
      google::cloud::bigquery::datatransfer::v1::GetTransferConfigRequest const&
          request) override;

  StreamRange<google::cloud::bigquery::datatransfer::v1::TransferConfig>
  ListTransferConfigs(
      google::cloud::bigquery::datatransfer::v1::ListTransferConfigsRequest
          request) override;

  StatusOr<
      google::cloud::bigquery::datatransfer::v1::ScheduleTransferRunsResponse>
  ScheduleTransferRuns(google::cloud::bigquery::datatransfer::v1::
                           ScheduleTransferRunsRequest const& request) override;

  StatusOr<google::cloud::bigquery::datatransfer::v1::
               StartManualTransferRunsResponse>
  StartManualTransferRuns(
      google::cloud::bigquery::datatransfer::v1::
          StartManualTransferRunsRequest const& request) override;

  StatusOr<google::cloud::bigquery::datatransfer::v1::TransferRun>
  GetTransferRun(
      google::cloud::bigquery::datatransfer::v1::GetTransferRunRequest const&
          request) override;

  Status DeleteTransferRun(
      google::cloud::bigquery::datatransfer::v1::DeleteTransferRunRequest const&
          request) override;

  StreamRange<google::cloud::bigquery::datatransfer::v1::TransferRun>
  ListTransferRuns(
      google::cloud::bigquery::datatransfer::v1::ListTransferRunsRequest
          request) override;

  StreamRange<google::cloud::bigquery::datatransfer::v1::TransferMessage>
  ListTransferLogs(
      google::cloud::bigquery::datatransfer::v1::ListTransferLogsRequest
          request) override;

  StatusOr<google::cloud::bigquery::datatransfer::v1::CheckValidCredsResponse>
  CheckValidCreds(
      google::cloud::bigquery::datatransfer::v1::CheckValidCredsRequest const&
          request) override;

  Status EnrollDataSources(
      google::cloud::bigquery::datatransfer::v1::EnrollDataSourcesRequest const&
          request) override;

 private:
  std::unique_ptr<bigquery::DataTransferServiceRetryPolicy> retry_policy() {
    auto const& options = internal::CurrentOptions();
    if (options.has<bigquery::DataTransferServiceRetryPolicyOption>()) {
      return options.get<bigquery::DataTransferServiceRetryPolicyOption>()
          ->clone();
    }
    return options_.get<bigquery::DataTransferServiceRetryPolicyOption>()
        ->clone();
  }

  std::unique_ptr<BackoffPolicy> backoff_policy() {
    auto const& options = internal::CurrentOptions();
    if (options.has<bigquery::DataTransferServiceBackoffPolicyOption>()) {
      return options.get<bigquery::DataTransferServiceBackoffPolicyOption>()
          ->clone();
    }
    return options_.get<bigquery::DataTransferServiceBackoffPolicyOption>()
        ->clone();
  }

  std::unique_ptr<bigquery::DataTransferServiceConnectionIdempotencyPolicy>
  idempotency_policy() {
    auto const& options = internal::CurrentOptions();
    if (options.has<
            bigquery::DataTransferServiceConnectionIdempotencyPolicyOption>()) {
      return options
          .get<bigquery::DataTransferServiceConnectionIdempotencyPolicyOption>()
          ->clone();
    }
    return options_
        .get<bigquery::DataTransferServiceConnectionIdempotencyPolicyOption>()
        ->clone();
  }

  std::unique_ptr<google::cloud::BackgroundThreads> background_;
  std::shared_ptr<bigquery_internal::DataTransferServiceStub> stub_;
  Options options_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace bigquery_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BIGQUERY_INTERNAL_DATA_TRANSFER_CONNECTION_IMPL_H
