// Generated by the gRPC C++ plugin.
// If you make any local change, they will be lost.
// source: google/bigtable/admin/v2/bigtable_table_admin.proto
// Original file comments:
// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
#ifndef GRPC_google_2fbigtable_2fadmin_2fv2_2fbigtable_5ftable_5fadmin_2eproto__INCLUDED
#define GRPC_google_2fbigtable_2fadmin_2fv2_2fbigtable_5ftable_5fadmin_2eproto__INCLUDED

#include "google/bigtable/admin/v2/bigtable_table_admin.pb.h"

#include <functional>
#include <grpcpp/impl/codegen/async_generic_service.h>
#include <grpcpp/impl/codegen/async_stream.h>
#include <grpcpp/impl/codegen/async_unary_call.h>
#include <grpcpp/impl/codegen/client_callback.h>
#include <grpcpp/impl/codegen/client_context.h>
#include <grpcpp/impl/codegen/completion_queue.h>
#include <grpcpp/impl/codegen/message_allocator.h>
#include <grpcpp/impl/codegen/method_handler.h>
#include <grpcpp/impl/codegen/proto_utils.h>
#include <grpcpp/impl/codegen/rpc_method.h>
#include <grpcpp/impl/codegen/server_callback.h>
#include <grpcpp/impl/codegen/server_callback_handlers.h>
#include <grpcpp/impl/codegen/server_context.h>
#include <grpcpp/impl/codegen/service_type.h>
#include <grpcpp/impl/codegen/status.h>
#include <grpcpp/impl/codegen/stub_options.h>
#include <grpcpp/impl/codegen/sync_stream.h>

namespace google {
namespace bigtable {
namespace admin {
namespace v2 {

// Service for creating, configuring, and deleting Cloud Bigtable tables.
//
//
// Provides access to the table schemas only, not the data stored within
// the tables.
class BigtableTableAdmin final {
 public:
  static constexpr char const* service_full_name() {
    return "google.bigtable.admin.v2.BigtableTableAdmin";
  }
  class StubInterface {
   public:
    virtual ~StubInterface() {}
    // Creates a new table in the specified instance.
    // The table can be created with a full set of initial column families,
    // specified in the request.
    virtual ::grpc::Status CreateTable(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::CreateTableRequest& request, ::google::bigtable::admin::v2::Table* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::bigtable::admin::v2::Table>> AsyncCreateTable(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::CreateTableRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::bigtable::admin::v2::Table>>(AsyncCreateTableRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::bigtable::admin::v2::Table>> PrepareAsyncCreateTable(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::CreateTableRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::bigtable::admin::v2::Table>>(PrepareAsyncCreateTableRaw(context, request, cq));
    }
    // Creates a new table from the specified snapshot. The target table must
    // not exist. The snapshot and the table must be in the same instance.
    //
    // Note: This is a private alpha release of Cloud Bigtable snapshots. This
    // feature is not currently available to most Cloud Bigtable customers. This
    // feature might be changed in backward-incompatible ways and is not
    // recommended for production use. It is not subject to any SLA or deprecation
    // policy.
    virtual ::grpc::Status CreateTableFromSnapshot(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::CreateTableFromSnapshotRequest& request, ::google::longrunning::Operation* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>> AsyncCreateTableFromSnapshot(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::CreateTableFromSnapshotRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>>(AsyncCreateTableFromSnapshotRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>> PrepareAsyncCreateTableFromSnapshot(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::CreateTableFromSnapshotRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>>(PrepareAsyncCreateTableFromSnapshotRaw(context, request, cq));
    }
    // Lists all tables served from a specified instance.
    virtual ::grpc::Status ListTables(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::ListTablesRequest& request, ::google::bigtable::admin::v2::ListTablesResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::bigtable::admin::v2::ListTablesResponse>> AsyncListTables(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::ListTablesRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::bigtable::admin::v2::ListTablesResponse>>(AsyncListTablesRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::bigtable::admin::v2::ListTablesResponse>> PrepareAsyncListTables(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::ListTablesRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::bigtable::admin::v2::ListTablesResponse>>(PrepareAsyncListTablesRaw(context, request, cq));
    }
    // Gets metadata information about the specified table.
    virtual ::grpc::Status GetTable(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::GetTableRequest& request, ::google::bigtable::admin::v2::Table* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::bigtable::admin::v2::Table>> AsyncGetTable(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::GetTableRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::bigtable::admin::v2::Table>>(AsyncGetTableRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::bigtable::admin::v2::Table>> PrepareAsyncGetTable(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::GetTableRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::bigtable::admin::v2::Table>>(PrepareAsyncGetTableRaw(context, request, cq));
    }
    // Permanently deletes a specified table and all of its data.
    virtual ::grpc::Status DeleteTable(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::DeleteTableRequest& request, ::google::protobuf::Empty* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>> AsyncDeleteTable(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::DeleteTableRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>>(AsyncDeleteTableRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>> PrepareAsyncDeleteTable(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::DeleteTableRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>>(PrepareAsyncDeleteTableRaw(context, request, cq));
    }
    // Performs a series of column family modifications on the specified table.
    // Either all or none of the modifications will occur before this method
    // returns, but data requests received prior to that point may see a table
    // where only some modifications have taken effect.
    virtual ::grpc::Status ModifyColumnFamilies(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::ModifyColumnFamiliesRequest& request, ::google::bigtable::admin::v2::Table* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::bigtable::admin::v2::Table>> AsyncModifyColumnFamilies(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::ModifyColumnFamiliesRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::bigtable::admin::v2::Table>>(AsyncModifyColumnFamiliesRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::bigtable::admin::v2::Table>> PrepareAsyncModifyColumnFamilies(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::ModifyColumnFamiliesRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::bigtable::admin::v2::Table>>(PrepareAsyncModifyColumnFamiliesRaw(context, request, cq));
    }
    // Permanently drop/delete a row range from a specified table. The request can
    // specify whether to delete all rows in a table, or only those that match a
    // particular prefix.
    virtual ::grpc::Status DropRowRange(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::DropRowRangeRequest& request, ::google::protobuf::Empty* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>> AsyncDropRowRange(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::DropRowRangeRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>>(AsyncDropRowRangeRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>> PrepareAsyncDropRowRange(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::DropRowRangeRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>>(PrepareAsyncDropRowRangeRaw(context, request, cq));
    }
    // Generates a consistency token for a Table, which can be used in
    // CheckConsistency to check whether mutations to the table that finished
    // before this call started have been replicated. The tokens will be available
    // for 90 days.
    virtual ::grpc::Status GenerateConsistencyToken(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::GenerateConsistencyTokenRequest& request, ::google::bigtable::admin::v2::GenerateConsistencyTokenResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::bigtable::admin::v2::GenerateConsistencyTokenResponse>> AsyncGenerateConsistencyToken(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::GenerateConsistencyTokenRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::bigtable::admin::v2::GenerateConsistencyTokenResponse>>(AsyncGenerateConsistencyTokenRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::bigtable::admin::v2::GenerateConsistencyTokenResponse>> PrepareAsyncGenerateConsistencyToken(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::GenerateConsistencyTokenRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::bigtable::admin::v2::GenerateConsistencyTokenResponse>>(PrepareAsyncGenerateConsistencyTokenRaw(context, request, cq));
    }
    // Checks replication consistency based on a consistency token, that is, if
    // replication has caught up based on the conditions specified in the token
    // and the check request.
    virtual ::grpc::Status CheckConsistency(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::CheckConsistencyRequest& request, ::google::bigtable::admin::v2::CheckConsistencyResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::bigtable::admin::v2::CheckConsistencyResponse>> AsyncCheckConsistency(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::CheckConsistencyRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::bigtable::admin::v2::CheckConsistencyResponse>>(AsyncCheckConsistencyRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::bigtable::admin::v2::CheckConsistencyResponse>> PrepareAsyncCheckConsistency(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::CheckConsistencyRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::bigtable::admin::v2::CheckConsistencyResponse>>(PrepareAsyncCheckConsistencyRaw(context, request, cq));
    }
    // Creates a new snapshot in the specified cluster from the specified
    // source table. The cluster and the table must be in the same instance.
    //
    // Note: This is a private alpha release of Cloud Bigtable snapshots. This
    // feature is not currently available to most Cloud Bigtable customers. This
    // feature might be changed in backward-incompatible ways and is not
    // recommended for production use. It is not subject to any SLA or deprecation
    // policy.
    virtual ::grpc::Status SnapshotTable(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::SnapshotTableRequest& request, ::google::longrunning::Operation* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>> AsyncSnapshotTable(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::SnapshotTableRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>>(AsyncSnapshotTableRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>> PrepareAsyncSnapshotTable(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::SnapshotTableRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>>(PrepareAsyncSnapshotTableRaw(context, request, cq));
    }
    // Gets metadata information about the specified snapshot.
    //
    // Note: This is a private alpha release of Cloud Bigtable snapshots. This
    // feature is not currently available to most Cloud Bigtable customers. This
    // feature might be changed in backward-incompatible ways and is not
    // recommended for production use. It is not subject to any SLA or deprecation
    // policy.
    virtual ::grpc::Status GetSnapshot(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::GetSnapshotRequest& request, ::google::bigtable::admin::v2::Snapshot* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::bigtable::admin::v2::Snapshot>> AsyncGetSnapshot(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::GetSnapshotRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::bigtable::admin::v2::Snapshot>>(AsyncGetSnapshotRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::bigtable::admin::v2::Snapshot>> PrepareAsyncGetSnapshot(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::GetSnapshotRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::bigtable::admin::v2::Snapshot>>(PrepareAsyncGetSnapshotRaw(context, request, cq));
    }
    // Lists all snapshots associated with the specified cluster.
    //
    // Note: This is a private alpha release of Cloud Bigtable snapshots. This
    // feature is not currently available to most Cloud Bigtable customers. This
    // feature might be changed in backward-incompatible ways and is not
    // recommended for production use. It is not subject to any SLA or deprecation
    // policy.
    virtual ::grpc::Status ListSnapshots(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::ListSnapshotsRequest& request, ::google::bigtable::admin::v2::ListSnapshotsResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::bigtable::admin::v2::ListSnapshotsResponse>> AsyncListSnapshots(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::ListSnapshotsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::bigtable::admin::v2::ListSnapshotsResponse>>(AsyncListSnapshotsRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::bigtable::admin::v2::ListSnapshotsResponse>> PrepareAsyncListSnapshots(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::ListSnapshotsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::bigtable::admin::v2::ListSnapshotsResponse>>(PrepareAsyncListSnapshotsRaw(context, request, cq));
    }
    // Permanently deletes the specified snapshot.
    //
    // Note: This is a private alpha release of Cloud Bigtable snapshots. This
    // feature is not currently available to most Cloud Bigtable customers. This
    // feature might be changed in backward-incompatible ways and is not
    // recommended for production use. It is not subject to any SLA or deprecation
    // policy.
    virtual ::grpc::Status DeleteSnapshot(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::DeleteSnapshotRequest& request, ::google::protobuf::Empty* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>> AsyncDeleteSnapshot(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::DeleteSnapshotRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>>(AsyncDeleteSnapshotRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>> PrepareAsyncDeleteSnapshot(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::DeleteSnapshotRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>>(PrepareAsyncDeleteSnapshotRaw(context, request, cq));
    }
    // Starts creating a new Cloud Bigtable Backup.  The returned backup
    // [long-running operation][google.longrunning.Operation] can be used to
    // track creation of the backup. The
    // [metadata][google.longrunning.Operation.metadata] field type is
    // [CreateBackupMetadata][google.bigtable.admin.v2.CreateBackupMetadata]. The
    // [response][google.longrunning.Operation.response] field type is
    // [Backup][google.bigtable.admin.v2.Backup], if successful. Cancelling the returned operation will stop the
    // creation and delete the backup.
    virtual ::grpc::Status CreateBackup(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::CreateBackupRequest& request, ::google::longrunning::Operation* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>> AsyncCreateBackup(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::CreateBackupRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>>(AsyncCreateBackupRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>> PrepareAsyncCreateBackup(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::CreateBackupRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>>(PrepareAsyncCreateBackupRaw(context, request, cq));
    }
    // Gets metadata on a pending or completed Cloud Bigtable Backup.
    virtual ::grpc::Status GetBackup(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::GetBackupRequest& request, ::google::bigtable::admin::v2::Backup* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::bigtable::admin::v2::Backup>> AsyncGetBackup(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::GetBackupRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::bigtable::admin::v2::Backup>>(AsyncGetBackupRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::bigtable::admin::v2::Backup>> PrepareAsyncGetBackup(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::GetBackupRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::bigtable::admin::v2::Backup>>(PrepareAsyncGetBackupRaw(context, request, cq));
    }
    // Updates a pending or completed Cloud Bigtable Backup.
    virtual ::grpc::Status UpdateBackup(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::UpdateBackupRequest& request, ::google::bigtable::admin::v2::Backup* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::bigtable::admin::v2::Backup>> AsyncUpdateBackup(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::UpdateBackupRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::bigtable::admin::v2::Backup>>(AsyncUpdateBackupRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::bigtable::admin::v2::Backup>> PrepareAsyncUpdateBackup(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::UpdateBackupRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::bigtable::admin::v2::Backup>>(PrepareAsyncUpdateBackupRaw(context, request, cq));
    }
    // Deletes a pending or completed Cloud Bigtable backup.
    virtual ::grpc::Status DeleteBackup(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::DeleteBackupRequest& request, ::google::protobuf::Empty* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>> AsyncDeleteBackup(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::DeleteBackupRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>>(AsyncDeleteBackupRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>> PrepareAsyncDeleteBackup(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::DeleteBackupRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>>(PrepareAsyncDeleteBackupRaw(context, request, cq));
    }
    // Lists Cloud Bigtable backups. Returns both completed and pending
    // backups.
    virtual ::grpc::Status ListBackups(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::ListBackupsRequest& request, ::google::bigtable::admin::v2::ListBackupsResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::bigtable::admin::v2::ListBackupsResponse>> AsyncListBackups(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::ListBackupsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::bigtable::admin::v2::ListBackupsResponse>>(AsyncListBackupsRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::bigtable::admin::v2::ListBackupsResponse>> PrepareAsyncListBackups(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::ListBackupsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::bigtable::admin::v2::ListBackupsResponse>>(PrepareAsyncListBackupsRaw(context, request, cq));
    }
    // Create a new table by restoring from a completed backup. The new table
    // must be in the same project as the instance containing the backup.  The
    // returned table [long-running operation][google.longrunning.Operation] can
    // be used to track the progress of the operation, and to cancel it.  The
    // [metadata][google.longrunning.Operation.metadata] field type is
    // [RestoreTableMetadata][google.bigtable.admin.RestoreTableMetadata].  The
    // [response][google.longrunning.Operation.response] type is
    // [Table][google.bigtable.admin.v2.Table], if successful.
    virtual ::grpc::Status RestoreTable(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::RestoreTableRequest& request, ::google::longrunning::Operation* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>> AsyncRestoreTable(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::RestoreTableRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>>(AsyncRestoreTableRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>> PrepareAsyncRestoreTable(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::RestoreTableRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>>(PrepareAsyncRestoreTableRaw(context, request, cq));
    }
    // Gets the access control policy for a Table or Backup resource.
    // Returns an empty policy if the resource exists but does not have a policy
    // set.
    virtual ::grpc::Status GetIamPolicy(::grpc::ClientContext* context, const ::google::iam::v1::GetIamPolicyRequest& request, ::google::iam::v1::Policy* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::v1::Policy>> AsyncGetIamPolicy(::grpc::ClientContext* context, const ::google::iam::v1::GetIamPolicyRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::v1::Policy>>(AsyncGetIamPolicyRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::v1::Policy>> PrepareAsyncGetIamPolicy(::grpc::ClientContext* context, const ::google::iam::v1::GetIamPolicyRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::v1::Policy>>(PrepareAsyncGetIamPolicyRaw(context, request, cq));
    }
    // Sets the access control policy on a Table or Backup resource.
    // Replaces any existing policy.
    virtual ::grpc::Status SetIamPolicy(::grpc::ClientContext* context, const ::google::iam::v1::SetIamPolicyRequest& request, ::google::iam::v1::Policy* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::v1::Policy>> AsyncSetIamPolicy(::grpc::ClientContext* context, const ::google::iam::v1::SetIamPolicyRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::v1::Policy>>(AsyncSetIamPolicyRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::v1::Policy>> PrepareAsyncSetIamPolicy(::grpc::ClientContext* context, const ::google::iam::v1::SetIamPolicyRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::v1::Policy>>(PrepareAsyncSetIamPolicyRaw(context, request, cq));
    }
    // Returns permissions that the caller has on the specified Table or Backup resource.
    virtual ::grpc::Status TestIamPermissions(::grpc::ClientContext* context, const ::google::iam::v1::TestIamPermissionsRequest& request, ::google::iam::v1::TestIamPermissionsResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::v1::TestIamPermissionsResponse>> AsyncTestIamPermissions(::grpc::ClientContext* context, const ::google::iam::v1::TestIamPermissionsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::v1::TestIamPermissionsResponse>>(AsyncTestIamPermissionsRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::v1::TestIamPermissionsResponse>> PrepareAsyncTestIamPermissions(::grpc::ClientContext* context, const ::google::iam::v1::TestIamPermissionsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::v1::TestIamPermissionsResponse>>(PrepareAsyncTestIamPermissionsRaw(context, request, cq));
    }
    class async_interface {
     public:
      virtual ~async_interface() {}
      // Creates a new table in the specified instance.
      // The table can be created with a full set of initial column families,
      // specified in the request.
      virtual void CreateTable(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::CreateTableRequest* request, ::google::bigtable::admin::v2::Table* response, std::function<void(::grpc::Status)>) = 0;
      virtual void CreateTable(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::CreateTableRequest* request, ::google::bigtable::admin::v2::Table* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Creates a new table from the specified snapshot. The target table must
      // not exist. The snapshot and the table must be in the same instance.
      //
      // Note: This is a private alpha release of Cloud Bigtable snapshots. This
      // feature is not currently available to most Cloud Bigtable customers. This
      // feature might be changed in backward-incompatible ways and is not
      // recommended for production use. It is not subject to any SLA or deprecation
      // policy.
      virtual void CreateTableFromSnapshot(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::CreateTableFromSnapshotRequest* request, ::google::longrunning::Operation* response, std::function<void(::grpc::Status)>) = 0;
      virtual void CreateTableFromSnapshot(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::CreateTableFromSnapshotRequest* request, ::google::longrunning::Operation* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Lists all tables served from a specified instance.
      virtual void ListTables(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::ListTablesRequest* request, ::google::bigtable::admin::v2::ListTablesResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void ListTables(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::ListTablesRequest* request, ::google::bigtable::admin::v2::ListTablesResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Gets metadata information about the specified table.
      virtual void GetTable(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::GetTableRequest* request, ::google::bigtable::admin::v2::Table* response, std::function<void(::grpc::Status)>) = 0;
      virtual void GetTable(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::GetTableRequest* request, ::google::bigtable::admin::v2::Table* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Permanently deletes a specified table and all of its data.
      virtual void DeleteTable(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::DeleteTableRequest* request, ::google::protobuf::Empty* response, std::function<void(::grpc::Status)>) = 0;
      virtual void DeleteTable(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::DeleteTableRequest* request, ::google::protobuf::Empty* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Performs a series of column family modifications on the specified table.
      // Either all or none of the modifications will occur before this method
      // returns, but data requests received prior to that point may see a table
      // where only some modifications have taken effect.
      virtual void ModifyColumnFamilies(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::ModifyColumnFamiliesRequest* request, ::google::bigtable::admin::v2::Table* response, std::function<void(::grpc::Status)>) = 0;
      virtual void ModifyColumnFamilies(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::ModifyColumnFamiliesRequest* request, ::google::bigtable::admin::v2::Table* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Permanently drop/delete a row range from a specified table. The request can
      // specify whether to delete all rows in a table, or only those that match a
      // particular prefix.
      virtual void DropRowRange(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::DropRowRangeRequest* request, ::google::protobuf::Empty* response, std::function<void(::grpc::Status)>) = 0;
      virtual void DropRowRange(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::DropRowRangeRequest* request, ::google::protobuf::Empty* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Generates a consistency token for a Table, which can be used in
      // CheckConsistency to check whether mutations to the table that finished
      // before this call started have been replicated. The tokens will be available
      // for 90 days.
      virtual void GenerateConsistencyToken(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::GenerateConsistencyTokenRequest* request, ::google::bigtable::admin::v2::GenerateConsistencyTokenResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void GenerateConsistencyToken(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::GenerateConsistencyTokenRequest* request, ::google::bigtable::admin::v2::GenerateConsistencyTokenResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Checks replication consistency based on a consistency token, that is, if
      // replication has caught up based on the conditions specified in the token
      // and the check request.
      virtual void CheckConsistency(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::CheckConsistencyRequest* request, ::google::bigtable::admin::v2::CheckConsistencyResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void CheckConsistency(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::CheckConsistencyRequest* request, ::google::bigtable::admin::v2::CheckConsistencyResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Creates a new snapshot in the specified cluster from the specified
      // source table. The cluster and the table must be in the same instance.
      //
      // Note: This is a private alpha release of Cloud Bigtable snapshots. This
      // feature is not currently available to most Cloud Bigtable customers. This
      // feature might be changed in backward-incompatible ways and is not
      // recommended for production use. It is not subject to any SLA or deprecation
      // policy.
      virtual void SnapshotTable(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::SnapshotTableRequest* request, ::google::longrunning::Operation* response, std::function<void(::grpc::Status)>) = 0;
      virtual void SnapshotTable(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::SnapshotTableRequest* request, ::google::longrunning::Operation* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Gets metadata information about the specified snapshot.
      //
      // Note: This is a private alpha release of Cloud Bigtable snapshots. This
      // feature is not currently available to most Cloud Bigtable customers. This
      // feature might be changed in backward-incompatible ways and is not
      // recommended for production use. It is not subject to any SLA or deprecation
      // policy.
      virtual void GetSnapshot(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::GetSnapshotRequest* request, ::google::bigtable::admin::v2::Snapshot* response, std::function<void(::grpc::Status)>) = 0;
      virtual void GetSnapshot(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::GetSnapshotRequest* request, ::google::bigtable::admin::v2::Snapshot* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Lists all snapshots associated with the specified cluster.
      //
      // Note: This is a private alpha release of Cloud Bigtable snapshots. This
      // feature is not currently available to most Cloud Bigtable customers. This
      // feature might be changed in backward-incompatible ways and is not
      // recommended for production use. It is not subject to any SLA or deprecation
      // policy.
      virtual void ListSnapshots(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::ListSnapshotsRequest* request, ::google::bigtable::admin::v2::ListSnapshotsResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void ListSnapshots(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::ListSnapshotsRequest* request, ::google::bigtable::admin::v2::ListSnapshotsResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Permanently deletes the specified snapshot.
      //
      // Note: This is a private alpha release of Cloud Bigtable snapshots. This
      // feature is not currently available to most Cloud Bigtable customers. This
      // feature might be changed in backward-incompatible ways and is not
      // recommended for production use. It is not subject to any SLA or deprecation
      // policy.
      virtual void DeleteSnapshot(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::DeleteSnapshotRequest* request, ::google::protobuf::Empty* response, std::function<void(::grpc::Status)>) = 0;
      virtual void DeleteSnapshot(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::DeleteSnapshotRequest* request, ::google::protobuf::Empty* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Starts creating a new Cloud Bigtable Backup.  The returned backup
      // [long-running operation][google.longrunning.Operation] can be used to
      // track creation of the backup. The
      // [metadata][google.longrunning.Operation.metadata] field type is
      // [CreateBackupMetadata][google.bigtable.admin.v2.CreateBackupMetadata]. The
      // [response][google.longrunning.Operation.response] field type is
      // [Backup][google.bigtable.admin.v2.Backup], if successful. Cancelling the returned operation will stop the
      // creation and delete the backup.
      virtual void CreateBackup(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::CreateBackupRequest* request, ::google::longrunning::Operation* response, std::function<void(::grpc::Status)>) = 0;
      virtual void CreateBackup(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::CreateBackupRequest* request, ::google::longrunning::Operation* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Gets metadata on a pending or completed Cloud Bigtable Backup.
      virtual void GetBackup(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::GetBackupRequest* request, ::google::bigtable::admin::v2::Backup* response, std::function<void(::grpc::Status)>) = 0;
      virtual void GetBackup(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::GetBackupRequest* request, ::google::bigtable::admin::v2::Backup* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Updates a pending or completed Cloud Bigtable Backup.
      virtual void UpdateBackup(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::UpdateBackupRequest* request, ::google::bigtable::admin::v2::Backup* response, std::function<void(::grpc::Status)>) = 0;
      virtual void UpdateBackup(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::UpdateBackupRequest* request, ::google::bigtable::admin::v2::Backup* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Deletes a pending or completed Cloud Bigtable backup.
      virtual void DeleteBackup(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::DeleteBackupRequest* request, ::google::protobuf::Empty* response, std::function<void(::grpc::Status)>) = 0;
      virtual void DeleteBackup(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::DeleteBackupRequest* request, ::google::protobuf::Empty* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Lists Cloud Bigtable backups. Returns both completed and pending
      // backups.
      virtual void ListBackups(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::ListBackupsRequest* request, ::google::bigtable::admin::v2::ListBackupsResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void ListBackups(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::ListBackupsRequest* request, ::google::bigtable::admin::v2::ListBackupsResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Create a new table by restoring from a completed backup. The new table
      // must be in the same project as the instance containing the backup.  The
      // returned table [long-running operation][google.longrunning.Operation] can
      // be used to track the progress of the operation, and to cancel it.  The
      // [metadata][google.longrunning.Operation.metadata] field type is
      // [RestoreTableMetadata][google.bigtable.admin.RestoreTableMetadata].  The
      // [response][google.longrunning.Operation.response] type is
      // [Table][google.bigtable.admin.v2.Table], if successful.
      virtual void RestoreTable(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::RestoreTableRequest* request, ::google::longrunning::Operation* response, std::function<void(::grpc::Status)>) = 0;
      virtual void RestoreTable(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::RestoreTableRequest* request, ::google::longrunning::Operation* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Gets the access control policy for a Table or Backup resource.
      // Returns an empty policy if the resource exists but does not have a policy
      // set.
      virtual void GetIamPolicy(::grpc::ClientContext* context, const ::google::iam::v1::GetIamPolicyRequest* request, ::google::iam::v1::Policy* response, std::function<void(::grpc::Status)>) = 0;
      virtual void GetIamPolicy(::grpc::ClientContext* context, const ::google::iam::v1::GetIamPolicyRequest* request, ::google::iam::v1::Policy* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Sets the access control policy on a Table or Backup resource.
      // Replaces any existing policy.
      virtual void SetIamPolicy(::grpc::ClientContext* context, const ::google::iam::v1::SetIamPolicyRequest* request, ::google::iam::v1::Policy* response, std::function<void(::grpc::Status)>) = 0;
      virtual void SetIamPolicy(::grpc::ClientContext* context, const ::google::iam::v1::SetIamPolicyRequest* request, ::google::iam::v1::Policy* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Returns permissions that the caller has on the specified Table or Backup resource.
      virtual void TestIamPermissions(::grpc::ClientContext* context, const ::google::iam::v1::TestIamPermissionsRequest* request, ::google::iam::v1::TestIamPermissionsResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void TestIamPermissions(::grpc::ClientContext* context, const ::google::iam::v1::TestIamPermissionsRequest* request, ::google::iam::v1::TestIamPermissionsResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
    };
    typedef class async_interface experimental_async_interface;
    virtual class async_interface* async() { return nullptr; }
    class async_interface* experimental_async() { return async(); }
   private:
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::bigtable::admin::v2::Table>* AsyncCreateTableRaw(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::CreateTableRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::bigtable::admin::v2::Table>* PrepareAsyncCreateTableRaw(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::CreateTableRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>* AsyncCreateTableFromSnapshotRaw(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::CreateTableFromSnapshotRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>* PrepareAsyncCreateTableFromSnapshotRaw(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::CreateTableFromSnapshotRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::bigtable::admin::v2::ListTablesResponse>* AsyncListTablesRaw(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::ListTablesRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::bigtable::admin::v2::ListTablesResponse>* PrepareAsyncListTablesRaw(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::ListTablesRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::bigtable::admin::v2::Table>* AsyncGetTableRaw(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::GetTableRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::bigtable::admin::v2::Table>* PrepareAsyncGetTableRaw(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::GetTableRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>* AsyncDeleteTableRaw(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::DeleteTableRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>* PrepareAsyncDeleteTableRaw(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::DeleteTableRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::bigtable::admin::v2::Table>* AsyncModifyColumnFamiliesRaw(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::ModifyColumnFamiliesRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::bigtable::admin::v2::Table>* PrepareAsyncModifyColumnFamiliesRaw(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::ModifyColumnFamiliesRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>* AsyncDropRowRangeRaw(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::DropRowRangeRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>* PrepareAsyncDropRowRangeRaw(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::DropRowRangeRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::bigtable::admin::v2::GenerateConsistencyTokenResponse>* AsyncGenerateConsistencyTokenRaw(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::GenerateConsistencyTokenRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::bigtable::admin::v2::GenerateConsistencyTokenResponse>* PrepareAsyncGenerateConsistencyTokenRaw(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::GenerateConsistencyTokenRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::bigtable::admin::v2::CheckConsistencyResponse>* AsyncCheckConsistencyRaw(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::CheckConsistencyRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::bigtable::admin::v2::CheckConsistencyResponse>* PrepareAsyncCheckConsistencyRaw(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::CheckConsistencyRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>* AsyncSnapshotTableRaw(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::SnapshotTableRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>* PrepareAsyncSnapshotTableRaw(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::SnapshotTableRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::bigtable::admin::v2::Snapshot>* AsyncGetSnapshotRaw(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::GetSnapshotRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::bigtable::admin::v2::Snapshot>* PrepareAsyncGetSnapshotRaw(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::GetSnapshotRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::bigtable::admin::v2::ListSnapshotsResponse>* AsyncListSnapshotsRaw(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::ListSnapshotsRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::bigtable::admin::v2::ListSnapshotsResponse>* PrepareAsyncListSnapshotsRaw(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::ListSnapshotsRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>* AsyncDeleteSnapshotRaw(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::DeleteSnapshotRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>* PrepareAsyncDeleteSnapshotRaw(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::DeleteSnapshotRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>* AsyncCreateBackupRaw(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::CreateBackupRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>* PrepareAsyncCreateBackupRaw(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::CreateBackupRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::bigtable::admin::v2::Backup>* AsyncGetBackupRaw(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::GetBackupRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::bigtable::admin::v2::Backup>* PrepareAsyncGetBackupRaw(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::GetBackupRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::bigtable::admin::v2::Backup>* AsyncUpdateBackupRaw(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::UpdateBackupRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::bigtable::admin::v2::Backup>* PrepareAsyncUpdateBackupRaw(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::UpdateBackupRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>* AsyncDeleteBackupRaw(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::DeleteBackupRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>* PrepareAsyncDeleteBackupRaw(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::DeleteBackupRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::bigtable::admin::v2::ListBackupsResponse>* AsyncListBackupsRaw(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::ListBackupsRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::bigtable::admin::v2::ListBackupsResponse>* PrepareAsyncListBackupsRaw(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::ListBackupsRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>* AsyncRestoreTableRaw(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::RestoreTableRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>* PrepareAsyncRestoreTableRaw(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::RestoreTableRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::v1::Policy>* AsyncGetIamPolicyRaw(::grpc::ClientContext* context, const ::google::iam::v1::GetIamPolicyRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::v1::Policy>* PrepareAsyncGetIamPolicyRaw(::grpc::ClientContext* context, const ::google::iam::v1::GetIamPolicyRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::v1::Policy>* AsyncSetIamPolicyRaw(::grpc::ClientContext* context, const ::google::iam::v1::SetIamPolicyRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::v1::Policy>* PrepareAsyncSetIamPolicyRaw(::grpc::ClientContext* context, const ::google::iam::v1::SetIamPolicyRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::v1::TestIamPermissionsResponse>* AsyncTestIamPermissionsRaw(::grpc::ClientContext* context, const ::google::iam::v1::TestIamPermissionsRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::v1::TestIamPermissionsResponse>* PrepareAsyncTestIamPermissionsRaw(::grpc::ClientContext* context, const ::google::iam::v1::TestIamPermissionsRequest& request, ::grpc::CompletionQueue* cq) = 0;
  };
  class Stub final : public StubInterface {
   public:
    Stub(const std::shared_ptr< ::grpc::ChannelInterface>& channel, const ::grpc::StubOptions& options = ::grpc::StubOptions());
    ::grpc::Status CreateTable(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::CreateTableRequest& request, ::google::bigtable::admin::v2::Table* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::bigtable::admin::v2::Table>> AsyncCreateTable(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::CreateTableRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::bigtable::admin::v2::Table>>(AsyncCreateTableRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::bigtable::admin::v2::Table>> PrepareAsyncCreateTable(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::CreateTableRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::bigtable::admin::v2::Table>>(PrepareAsyncCreateTableRaw(context, request, cq));
    }
    ::grpc::Status CreateTableFromSnapshot(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::CreateTableFromSnapshotRequest& request, ::google::longrunning::Operation* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>> AsyncCreateTableFromSnapshot(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::CreateTableFromSnapshotRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>>(AsyncCreateTableFromSnapshotRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>> PrepareAsyncCreateTableFromSnapshot(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::CreateTableFromSnapshotRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>>(PrepareAsyncCreateTableFromSnapshotRaw(context, request, cq));
    }
    ::grpc::Status ListTables(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::ListTablesRequest& request, ::google::bigtable::admin::v2::ListTablesResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::bigtable::admin::v2::ListTablesResponse>> AsyncListTables(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::ListTablesRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::bigtable::admin::v2::ListTablesResponse>>(AsyncListTablesRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::bigtable::admin::v2::ListTablesResponse>> PrepareAsyncListTables(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::ListTablesRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::bigtable::admin::v2::ListTablesResponse>>(PrepareAsyncListTablesRaw(context, request, cq));
    }
    ::grpc::Status GetTable(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::GetTableRequest& request, ::google::bigtable::admin::v2::Table* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::bigtable::admin::v2::Table>> AsyncGetTable(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::GetTableRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::bigtable::admin::v2::Table>>(AsyncGetTableRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::bigtable::admin::v2::Table>> PrepareAsyncGetTable(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::GetTableRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::bigtable::admin::v2::Table>>(PrepareAsyncGetTableRaw(context, request, cq));
    }
    ::grpc::Status DeleteTable(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::DeleteTableRequest& request, ::google::protobuf::Empty* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>> AsyncDeleteTable(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::DeleteTableRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>>(AsyncDeleteTableRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>> PrepareAsyncDeleteTable(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::DeleteTableRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>>(PrepareAsyncDeleteTableRaw(context, request, cq));
    }
    ::grpc::Status ModifyColumnFamilies(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::ModifyColumnFamiliesRequest& request, ::google::bigtable::admin::v2::Table* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::bigtable::admin::v2::Table>> AsyncModifyColumnFamilies(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::ModifyColumnFamiliesRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::bigtable::admin::v2::Table>>(AsyncModifyColumnFamiliesRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::bigtable::admin::v2::Table>> PrepareAsyncModifyColumnFamilies(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::ModifyColumnFamiliesRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::bigtable::admin::v2::Table>>(PrepareAsyncModifyColumnFamiliesRaw(context, request, cq));
    }
    ::grpc::Status DropRowRange(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::DropRowRangeRequest& request, ::google::protobuf::Empty* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>> AsyncDropRowRange(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::DropRowRangeRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>>(AsyncDropRowRangeRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>> PrepareAsyncDropRowRange(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::DropRowRangeRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>>(PrepareAsyncDropRowRangeRaw(context, request, cq));
    }
    ::grpc::Status GenerateConsistencyToken(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::GenerateConsistencyTokenRequest& request, ::google::bigtable::admin::v2::GenerateConsistencyTokenResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::bigtable::admin::v2::GenerateConsistencyTokenResponse>> AsyncGenerateConsistencyToken(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::GenerateConsistencyTokenRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::bigtable::admin::v2::GenerateConsistencyTokenResponse>>(AsyncGenerateConsistencyTokenRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::bigtable::admin::v2::GenerateConsistencyTokenResponse>> PrepareAsyncGenerateConsistencyToken(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::GenerateConsistencyTokenRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::bigtable::admin::v2::GenerateConsistencyTokenResponse>>(PrepareAsyncGenerateConsistencyTokenRaw(context, request, cq));
    }
    ::grpc::Status CheckConsistency(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::CheckConsistencyRequest& request, ::google::bigtable::admin::v2::CheckConsistencyResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::bigtable::admin::v2::CheckConsistencyResponse>> AsyncCheckConsistency(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::CheckConsistencyRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::bigtable::admin::v2::CheckConsistencyResponse>>(AsyncCheckConsistencyRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::bigtable::admin::v2::CheckConsistencyResponse>> PrepareAsyncCheckConsistency(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::CheckConsistencyRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::bigtable::admin::v2::CheckConsistencyResponse>>(PrepareAsyncCheckConsistencyRaw(context, request, cq));
    }
    ::grpc::Status SnapshotTable(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::SnapshotTableRequest& request, ::google::longrunning::Operation* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>> AsyncSnapshotTable(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::SnapshotTableRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>>(AsyncSnapshotTableRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>> PrepareAsyncSnapshotTable(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::SnapshotTableRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>>(PrepareAsyncSnapshotTableRaw(context, request, cq));
    }
    ::grpc::Status GetSnapshot(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::GetSnapshotRequest& request, ::google::bigtable::admin::v2::Snapshot* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::bigtable::admin::v2::Snapshot>> AsyncGetSnapshot(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::GetSnapshotRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::bigtable::admin::v2::Snapshot>>(AsyncGetSnapshotRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::bigtable::admin::v2::Snapshot>> PrepareAsyncGetSnapshot(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::GetSnapshotRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::bigtable::admin::v2::Snapshot>>(PrepareAsyncGetSnapshotRaw(context, request, cq));
    }
    ::grpc::Status ListSnapshots(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::ListSnapshotsRequest& request, ::google::bigtable::admin::v2::ListSnapshotsResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::bigtable::admin::v2::ListSnapshotsResponse>> AsyncListSnapshots(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::ListSnapshotsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::bigtable::admin::v2::ListSnapshotsResponse>>(AsyncListSnapshotsRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::bigtable::admin::v2::ListSnapshotsResponse>> PrepareAsyncListSnapshots(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::ListSnapshotsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::bigtable::admin::v2::ListSnapshotsResponse>>(PrepareAsyncListSnapshotsRaw(context, request, cq));
    }
    ::grpc::Status DeleteSnapshot(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::DeleteSnapshotRequest& request, ::google::protobuf::Empty* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>> AsyncDeleteSnapshot(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::DeleteSnapshotRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>>(AsyncDeleteSnapshotRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>> PrepareAsyncDeleteSnapshot(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::DeleteSnapshotRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>>(PrepareAsyncDeleteSnapshotRaw(context, request, cq));
    }
    ::grpc::Status CreateBackup(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::CreateBackupRequest& request, ::google::longrunning::Operation* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>> AsyncCreateBackup(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::CreateBackupRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>>(AsyncCreateBackupRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>> PrepareAsyncCreateBackup(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::CreateBackupRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>>(PrepareAsyncCreateBackupRaw(context, request, cq));
    }
    ::grpc::Status GetBackup(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::GetBackupRequest& request, ::google::bigtable::admin::v2::Backup* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::bigtable::admin::v2::Backup>> AsyncGetBackup(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::GetBackupRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::bigtable::admin::v2::Backup>>(AsyncGetBackupRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::bigtable::admin::v2::Backup>> PrepareAsyncGetBackup(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::GetBackupRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::bigtable::admin::v2::Backup>>(PrepareAsyncGetBackupRaw(context, request, cq));
    }
    ::grpc::Status UpdateBackup(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::UpdateBackupRequest& request, ::google::bigtable::admin::v2::Backup* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::bigtable::admin::v2::Backup>> AsyncUpdateBackup(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::UpdateBackupRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::bigtable::admin::v2::Backup>>(AsyncUpdateBackupRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::bigtable::admin::v2::Backup>> PrepareAsyncUpdateBackup(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::UpdateBackupRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::bigtable::admin::v2::Backup>>(PrepareAsyncUpdateBackupRaw(context, request, cq));
    }
    ::grpc::Status DeleteBackup(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::DeleteBackupRequest& request, ::google::protobuf::Empty* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>> AsyncDeleteBackup(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::DeleteBackupRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>>(AsyncDeleteBackupRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>> PrepareAsyncDeleteBackup(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::DeleteBackupRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>>(PrepareAsyncDeleteBackupRaw(context, request, cq));
    }
    ::grpc::Status ListBackups(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::ListBackupsRequest& request, ::google::bigtable::admin::v2::ListBackupsResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::bigtable::admin::v2::ListBackupsResponse>> AsyncListBackups(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::ListBackupsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::bigtable::admin::v2::ListBackupsResponse>>(AsyncListBackupsRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::bigtable::admin::v2::ListBackupsResponse>> PrepareAsyncListBackups(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::ListBackupsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::bigtable::admin::v2::ListBackupsResponse>>(PrepareAsyncListBackupsRaw(context, request, cq));
    }
    ::grpc::Status RestoreTable(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::RestoreTableRequest& request, ::google::longrunning::Operation* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>> AsyncRestoreTable(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::RestoreTableRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>>(AsyncRestoreTableRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>> PrepareAsyncRestoreTable(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::RestoreTableRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>>(PrepareAsyncRestoreTableRaw(context, request, cq));
    }
    ::grpc::Status GetIamPolicy(::grpc::ClientContext* context, const ::google::iam::v1::GetIamPolicyRequest& request, ::google::iam::v1::Policy* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::v1::Policy>> AsyncGetIamPolicy(::grpc::ClientContext* context, const ::google::iam::v1::GetIamPolicyRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::v1::Policy>>(AsyncGetIamPolicyRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::v1::Policy>> PrepareAsyncGetIamPolicy(::grpc::ClientContext* context, const ::google::iam::v1::GetIamPolicyRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::v1::Policy>>(PrepareAsyncGetIamPolicyRaw(context, request, cq));
    }
    ::grpc::Status SetIamPolicy(::grpc::ClientContext* context, const ::google::iam::v1::SetIamPolicyRequest& request, ::google::iam::v1::Policy* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::v1::Policy>> AsyncSetIamPolicy(::grpc::ClientContext* context, const ::google::iam::v1::SetIamPolicyRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::v1::Policy>>(AsyncSetIamPolicyRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::v1::Policy>> PrepareAsyncSetIamPolicy(::grpc::ClientContext* context, const ::google::iam::v1::SetIamPolicyRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::v1::Policy>>(PrepareAsyncSetIamPolicyRaw(context, request, cq));
    }
    ::grpc::Status TestIamPermissions(::grpc::ClientContext* context, const ::google::iam::v1::TestIamPermissionsRequest& request, ::google::iam::v1::TestIamPermissionsResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::v1::TestIamPermissionsResponse>> AsyncTestIamPermissions(::grpc::ClientContext* context, const ::google::iam::v1::TestIamPermissionsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::v1::TestIamPermissionsResponse>>(AsyncTestIamPermissionsRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::v1::TestIamPermissionsResponse>> PrepareAsyncTestIamPermissions(::grpc::ClientContext* context, const ::google::iam::v1::TestIamPermissionsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::v1::TestIamPermissionsResponse>>(PrepareAsyncTestIamPermissionsRaw(context, request, cq));
    }
    class async final :
      public StubInterface::async_interface {
     public:
      void CreateTable(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::CreateTableRequest* request, ::google::bigtable::admin::v2::Table* response, std::function<void(::grpc::Status)>) override;
      void CreateTable(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::CreateTableRequest* request, ::google::bigtable::admin::v2::Table* response, ::grpc::ClientUnaryReactor* reactor) override;
      void CreateTableFromSnapshot(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::CreateTableFromSnapshotRequest* request, ::google::longrunning::Operation* response, std::function<void(::grpc::Status)>) override;
      void CreateTableFromSnapshot(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::CreateTableFromSnapshotRequest* request, ::google::longrunning::Operation* response, ::grpc::ClientUnaryReactor* reactor) override;
      void ListTables(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::ListTablesRequest* request, ::google::bigtable::admin::v2::ListTablesResponse* response, std::function<void(::grpc::Status)>) override;
      void ListTables(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::ListTablesRequest* request, ::google::bigtable::admin::v2::ListTablesResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
      void GetTable(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::GetTableRequest* request, ::google::bigtable::admin::v2::Table* response, std::function<void(::grpc::Status)>) override;
      void GetTable(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::GetTableRequest* request, ::google::bigtable::admin::v2::Table* response, ::grpc::ClientUnaryReactor* reactor) override;
      void DeleteTable(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::DeleteTableRequest* request, ::google::protobuf::Empty* response, std::function<void(::grpc::Status)>) override;
      void DeleteTable(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::DeleteTableRequest* request, ::google::protobuf::Empty* response, ::grpc::ClientUnaryReactor* reactor) override;
      void ModifyColumnFamilies(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::ModifyColumnFamiliesRequest* request, ::google::bigtable::admin::v2::Table* response, std::function<void(::grpc::Status)>) override;
      void ModifyColumnFamilies(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::ModifyColumnFamiliesRequest* request, ::google::bigtable::admin::v2::Table* response, ::grpc::ClientUnaryReactor* reactor) override;
      void DropRowRange(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::DropRowRangeRequest* request, ::google::protobuf::Empty* response, std::function<void(::grpc::Status)>) override;
      void DropRowRange(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::DropRowRangeRequest* request, ::google::protobuf::Empty* response, ::grpc::ClientUnaryReactor* reactor) override;
      void GenerateConsistencyToken(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::GenerateConsistencyTokenRequest* request, ::google::bigtable::admin::v2::GenerateConsistencyTokenResponse* response, std::function<void(::grpc::Status)>) override;
      void GenerateConsistencyToken(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::GenerateConsistencyTokenRequest* request, ::google::bigtable::admin::v2::GenerateConsistencyTokenResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
      void CheckConsistency(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::CheckConsistencyRequest* request, ::google::bigtable::admin::v2::CheckConsistencyResponse* response, std::function<void(::grpc::Status)>) override;
      void CheckConsistency(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::CheckConsistencyRequest* request, ::google::bigtable::admin::v2::CheckConsistencyResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
      void SnapshotTable(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::SnapshotTableRequest* request, ::google::longrunning::Operation* response, std::function<void(::grpc::Status)>) override;
      void SnapshotTable(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::SnapshotTableRequest* request, ::google::longrunning::Operation* response, ::grpc::ClientUnaryReactor* reactor) override;
      void GetSnapshot(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::GetSnapshotRequest* request, ::google::bigtable::admin::v2::Snapshot* response, std::function<void(::grpc::Status)>) override;
      void GetSnapshot(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::GetSnapshotRequest* request, ::google::bigtable::admin::v2::Snapshot* response, ::grpc::ClientUnaryReactor* reactor) override;
      void ListSnapshots(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::ListSnapshotsRequest* request, ::google::bigtable::admin::v2::ListSnapshotsResponse* response, std::function<void(::grpc::Status)>) override;
      void ListSnapshots(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::ListSnapshotsRequest* request, ::google::bigtable::admin::v2::ListSnapshotsResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
      void DeleteSnapshot(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::DeleteSnapshotRequest* request, ::google::protobuf::Empty* response, std::function<void(::grpc::Status)>) override;
      void DeleteSnapshot(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::DeleteSnapshotRequest* request, ::google::protobuf::Empty* response, ::grpc::ClientUnaryReactor* reactor) override;
      void CreateBackup(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::CreateBackupRequest* request, ::google::longrunning::Operation* response, std::function<void(::grpc::Status)>) override;
      void CreateBackup(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::CreateBackupRequest* request, ::google::longrunning::Operation* response, ::grpc::ClientUnaryReactor* reactor) override;
      void GetBackup(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::GetBackupRequest* request, ::google::bigtable::admin::v2::Backup* response, std::function<void(::grpc::Status)>) override;
      void GetBackup(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::GetBackupRequest* request, ::google::bigtable::admin::v2::Backup* response, ::grpc::ClientUnaryReactor* reactor) override;
      void UpdateBackup(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::UpdateBackupRequest* request, ::google::bigtable::admin::v2::Backup* response, std::function<void(::grpc::Status)>) override;
      void UpdateBackup(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::UpdateBackupRequest* request, ::google::bigtable::admin::v2::Backup* response, ::grpc::ClientUnaryReactor* reactor) override;
      void DeleteBackup(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::DeleteBackupRequest* request, ::google::protobuf::Empty* response, std::function<void(::grpc::Status)>) override;
      void DeleteBackup(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::DeleteBackupRequest* request, ::google::protobuf::Empty* response, ::grpc::ClientUnaryReactor* reactor) override;
      void ListBackups(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::ListBackupsRequest* request, ::google::bigtable::admin::v2::ListBackupsResponse* response, std::function<void(::grpc::Status)>) override;
      void ListBackups(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::ListBackupsRequest* request, ::google::bigtable::admin::v2::ListBackupsResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
      void RestoreTable(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::RestoreTableRequest* request, ::google::longrunning::Operation* response, std::function<void(::grpc::Status)>) override;
      void RestoreTable(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::RestoreTableRequest* request, ::google::longrunning::Operation* response, ::grpc::ClientUnaryReactor* reactor) override;
      void GetIamPolicy(::grpc::ClientContext* context, const ::google::iam::v1::GetIamPolicyRequest* request, ::google::iam::v1::Policy* response, std::function<void(::grpc::Status)>) override;
      void GetIamPolicy(::grpc::ClientContext* context, const ::google::iam::v1::GetIamPolicyRequest* request, ::google::iam::v1::Policy* response, ::grpc::ClientUnaryReactor* reactor) override;
      void SetIamPolicy(::grpc::ClientContext* context, const ::google::iam::v1::SetIamPolicyRequest* request, ::google::iam::v1::Policy* response, std::function<void(::grpc::Status)>) override;
      void SetIamPolicy(::grpc::ClientContext* context, const ::google::iam::v1::SetIamPolicyRequest* request, ::google::iam::v1::Policy* response, ::grpc::ClientUnaryReactor* reactor) override;
      void TestIamPermissions(::grpc::ClientContext* context, const ::google::iam::v1::TestIamPermissionsRequest* request, ::google::iam::v1::TestIamPermissionsResponse* response, std::function<void(::grpc::Status)>) override;
      void TestIamPermissions(::grpc::ClientContext* context, const ::google::iam::v1::TestIamPermissionsRequest* request, ::google::iam::v1::TestIamPermissionsResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
     private:
      friend class Stub;
      explicit async(Stub* stub): stub_(stub) { }
      Stub* stub() { return stub_; }
      Stub* stub_;
    };
    class async* async() override { return &async_stub_; }

   private:
    std::shared_ptr< ::grpc::ChannelInterface> channel_;
    class async async_stub_{this};
    ::grpc::ClientAsyncResponseReader< ::google::bigtable::admin::v2::Table>* AsyncCreateTableRaw(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::CreateTableRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::bigtable::admin::v2::Table>* PrepareAsyncCreateTableRaw(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::CreateTableRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>* AsyncCreateTableFromSnapshotRaw(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::CreateTableFromSnapshotRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>* PrepareAsyncCreateTableFromSnapshotRaw(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::CreateTableFromSnapshotRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::bigtable::admin::v2::ListTablesResponse>* AsyncListTablesRaw(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::ListTablesRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::bigtable::admin::v2::ListTablesResponse>* PrepareAsyncListTablesRaw(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::ListTablesRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::bigtable::admin::v2::Table>* AsyncGetTableRaw(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::GetTableRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::bigtable::admin::v2::Table>* PrepareAsyncGetTableRaw(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::GetTableRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>* AsyncDeleteTableRaw(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::DeleteTableRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>* PrepareAsyncDeleteTableRaw(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::DeleteTableRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::bigtable::admin::v2::Table>* AsyncModifyColumnFamiliesRaw(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::ModifyColumnFamiliesRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::bigtable::admin::v2::Table>* PrepareAsyncModifyColumnFamiliesRaw(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::ModifyColumnFamiliesRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>* AsyncDropRowRangeRaw(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::DropRowRangeRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>* PrepareAsyncDropRowRangeRaw(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::DropRowRangeRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::bigtable::admin::v2::GenerateConsistencyTokenResponse>* AsyncGenerateConsistencyTokenRaw(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::GenerateConsistencyTokenRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::bigtable::admin::v2::GenerateConsistencyTokenResponse>* PrepareAsyncGenerateConsistencyTokenRaw(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::GenerateConsistencyTokenRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::bigtable::admin::v2::CheckConsistencyResponse>* AsyncCheckConsistencyRaw(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::CheckConsistencyRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::bigtable::admin::v2::CheckConsistencyResponse>* PrepareAsyncCheckConsistencyRaw(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::CheckConsistencyRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>* AsyncSnapshotTableRaw(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::SnapshotTableRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>* PrepareAsyncSnapshotTableRaw(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::SnapshotTableRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::bigtable::admin::v2::Snapshot>* AsyncGetSnapshotRaw(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::GetSnapshotRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::bigtable::admin::v2::Snapshot>* PrepareAsyncGetSnapshotRaw(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::GetSnapshotRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::bigtable::admin::v2::ListSnapshotsResponse>* AsyncListSnapshotsRaw(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::ListSnapshotsRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::bigtable::admin::v2::ListSnapshotsResponse>* PrepareAsyncListSnapshotsRaw(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::ListSnapshotsRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>* AsyncDeleteSnapshotRaw(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::DeleteSnapshotRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>* PrepareAsyncDeleteSnapshotRaw(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::DeleteSnapshotRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>* AsyncCreateBackupRaw(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::CreateBackupRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>* PrepareAsyncCreateBackupRaw(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::CreateBackupRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::bigtable::admin::v2::Backup>* AsyncGetBackupRaw(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::GetBackupRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::bigtable::admin::v2::Backup>* PrepareAsyncGetBackupRaw(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::GetBackupRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::bigtable::admin::v2::Backup>* AsyncUpdateBackupRaw(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::UpdateBackupRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::bigtable::admin::v2::Backup>* PrepareAsyncUpdateBackupRaw(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::UpdateBackupRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>* AsyncDeleteBackupRaw(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::DeleteBackupRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>* PrepareAsyncDeleteBackupRaw(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::DeleteBackupRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::bigtable::admin::v2::ListBackupsResponse>* AsyncListBackupsRaw(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::ListBackupsRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::bigtable::admin::v2::ListBackupsResponse>* PrepareAsyncListBackupsRaw(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::ListBackupsRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>* AsyncRestoreTableRaw(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::RestoreTableRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>* PrepareAsyncRestoreTableRaw(::grpc::ClientContext* context, const ::google::bigtable::admin::v2::RestoreTableRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::iam::v1::Policy>* AsyncGetIamPolicyRaw(::grpc::ClientContext* context, const ::google::iam::v1::GetIamPolicyRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::iam::v1::Policy>* PrepareAsyncGetIamPolicyRaw(::grpc::ClientContext* context, const ::google::iam::v1::GetIamPolicyRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::iam::v1::Policy>* AsyncSetIamPolicyRaw(::grpc::ClientContext* context, const ::google::iam::v1::SetIamPolicyRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::iam::v1::Policy>* PrepareAsyncSetIamPolicyRaw(::grpc::ClientContext* context, const ::google::iam::v1::SetIamPolicyRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::iam::v1::TestIamPermissionsResponse>* AsyncTestIamPermissionsRaw(::grpc::ClientContext* context, const ::google::iam::v1::TestIamPermissionsRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::iam::v1::TestIamPermissionsResponse>* PrepareAsyncTestIamPermissionsRaw(::grpc::ClientContext* context, const ::google::iam::v1::TestIamPermissionsRequest& request, ::grpc::CompletionQueue* cq) override;
    const ::grpc::internal::RpcMethod rpcmethod_CreateTable_;
    const ::grpc::internal::RpcMethod rpcmethod_CreateTableFromSnapshot_;
    const ::grpc::internal::RpcMethod rpcmethod_ListTables_;
    const ::grpc::internal::RpcMethod rpcmethod_GetTable_;
    const ::grpc::internal::RpcMethod rpcmethod_DeleteTable_;
    const ::grpc::internal::RpcMethod rpcmethod_ModifyColumnFamilies_;
    const ::grpc::internal::RpcMethod rpcmethod_DropRowRange_;
    const ::grpc::internal::RpcMethod rpcmethod_GenerateConsistencyToken_;
    const ::grpc::internal::RpcMethod rpcmethod_CheckConsistency_;
    const ::grpc::internal::RpcMethod rpcmethod_SnapshotTable_;
    const ::grpc::internal::RpcMethod rpcmethod_GetSnapshot_;
    const ::grpc::internal::RpcMethod rpcmethod_ListSnapshots_;
    const ::grpc::internal::RpcMethod rpcmethod_DeleteSnapshot_;
    const ::grpc::internal::RpcMethod rpcmethod_CreateBackup_;
    const ::grpc::internal::RpcMethod rpcmethod_GetBackup_;
    const ::grpc::internal::RpcMethod rpcmethod_UpdateBackup_;
    const ::grpc::internal::RpcMethod rpcmethod_DeleteBackup_;
    const ::grpc::internal::RpcMethod rpcmethod_ListBackups_;
    const ::grpc::internal::RpcMethod rpcmethod_RestoreTable_;
    const ::grpc::internal::RpcMethod rpcmethod_GetIamPolicy_;
    const ::grpc::internal::RpcMethod rpcmethod_SetIamPolicy_;
    const ::grpc::internal::RpcMethod rpcmethod_TestIamPermissions_;
  };
  static std::unique_ptr<Stub> NewStub(const std::shared_ptr< ::grpc::ChannelInterface>& channel, const ::grpc::StubOptions& options = ::grpc::StubOptions());

  class Service : public ::grpc::Service {
   public:
    Service();
    virtual ~Service();
    // Creates a new table in the specified instance.
    // The table can be created with a full set of initial column families,
    // specified in the request.
    virtual ::grpc::Status CreateTable(::grpc::ServerContext* context, const ::google::bigtable::admin::v2::CreateTableRequest* request, ::google::bigtable::admin::v2::Table* response);
    // Creates a new table from the specified snapshot. The target table must
    // not exist. The snapshot and the table must be in the same instance.
    //
    // Note: This is a private alpha release of Cloud Bigtable snapshots. This
    // feature is not currently available to most Cloud Bigtable customers. This
    // feature might be changed in backward-incompatible ways and is not
    // recommended for production use. It is not subject to any SLA or deprecation
    // policy.
    virtual ::grpc::Status CreateTableFromSnapshot(::grpc::ServerContext* context, const ::google::bigtable::admin::v2::CreateTableFromSnapshotRequest* request, ::google::longrunning::Operation* response);
    // Lists all tables served from a specified instance.
    virtual ::grpc::Status ListTables(::grpc::ServerContext* context, const ::google::bigtable::admin::v2::ListTablesRequest* request, ::google::bigtable::admin::v2::ListTablesResponse* response);
    // Gets metadata information about the specified table.
    virtual ::grpc::Status GetTable(::grpc::ServerContext* context, const ::google::bigtable::admin::v2::GetTableRequest* request, ::google::bigtable::admin::v2::Table* response);
    // Permanently deletes a specified table and all of its data.
    virtual ::grpc::Status DeleteTable(::grpc::ServerContext* context, const ::google::bigtable::admin::v2::DeleteTableRequest* request, ::google::protobuf::Empty* response);
    // Performs a series of column family modifications on the specified table.
    // Either all or none of the modifications will occur before this method
    // returns, but data requests received prior to that point may see a table
    // where only some modifications have taken effect.
    virtual ::grpc::Status ModifyColumnFamilies(::grpc::ServerContext* context, const ::google::bigtable::admin::v2::ModifyColumnFamiliesRequest* request, ::google::bigtable::admin::v2::Table* response);
    // Permanently drop/delete a row range from a specified table. The request can
    // specify whether to delete all rows in a table, or only those that match a
    // particular prefix.
    virtual ::grpc::Status DropRowRange(::grpc::ServerContext* context, const ::google::bigtable::admin::v2::DropRowRangeRequest* request, ::google::protobuf::Empty* response);
    // Generates a consistency token for a Table, which can be used in
    // CheckConsistency to check whether mutations to the table that finished
    // before this call started have been replicated. The tokens will be available
    // for 90 days.
    virtual ::grpc::Status GenerateConsistencyToken(::grpc::ServerContext* context, const ::google::bigtable::admin::v2::GenerateConsistencyTokenRequest* request, ::google::bigtable::admin::v2::GenerateConsistencyTokenResponse* response);
    // Checks replication consistency based on a consistency token, that is, if
    // replication has caught up based on the conditions specified in the token
    // and the check request.
    virtual ::grpc::Status CheckConsistency(::grpc::ServerContext* context, const ::google::bigtable::admin::v2::CheckConsistencyRequest* request, ::google::bigtable::admin::v2::CheckConsistencyResponse* response);
    // Creates a new snapshot in the specified cluster from the specified
    // source table. The cluster and the table must be in the same instance.
    //
    // Note: This is a private alpha release of Cloud Bigtable snapshots. This
    // feature is not currently available to most Cloud Bigtable customers. This
    // feature might be changed in backward-incompatible ways and is not
    // recommended for production use. It is not subject to any SLA or deprecation
    // policy.
    virtual ::grpc::Status SnapshotTable(::grpc::ServerContext* context, const ::google::bigtable::admin::v2::SnapshotTableRequest* request, ::google::longrunning::Operation* response);
    // Gets metadata information about the specified snapshot.
    //
    // Note: This is a private alpha release of Cloud Bigtable snapshots. This
    // feature is not currently available to most Cloud Bigtable customers. This
    // feature might be changed in backward-incompatible ways and is not
    // recommended for production use. It is not subject to any SLA or deprecation
    // policy.
    virtual ::grpc::Status GetSnapshot(::grpc::ServerContext* context, const ::google::bigtable::admin::v2::GetSnapshotRequest* request, ::google::bigtable::admin::v2::Snapshot* response);
    // Lists all snapshots associated with the specified cluster.
    //
    // Note: This is a private alpha release of Cloud Bigtable snapshots. This
    // feature is not currently available to most Cloud Bigtable customers. This
    // feature might be changed in backward-incompatible ways and is not
    // recommended for production use. It is not subject to any SLA or deprecation
    // policy.
    virtual ::grpc::Status ListSnapshots(::grpc::ServerContext* context, const ::google::bigtable::admin::v2::ListSnapshotsRequest* request, ::google::bigtable::admin::v2::ListSnapshotsResponse* response);
    // Permanently deletes the specified snapshot.
    //
    // Note: This is a private alpha release of Cloud Bigtable snapshots. This
    // feature is not currently available to most Cloud Bigtable customers. This
    // feature might be changed in backward-incompatible ways and is not
    // recommended for production use. It is not subject to any SLA or deprecation
    // policy.
    virtual ::grpc::Status DeleteSnapshot(::grpc::ServerContext* context, const ::google::bigtable::admin::v2::DeleteSnapshotRequest* request, ::google::protobuf::Empty* response);
    // Starts creating a new Cloud Bigtable Backup.  The returned backup
    // [long-running operation][google.longrunning.Operation] can be used to
    // track creation of the backup. The
    // [metadata][google.longrunning.Operation.metadata] field type is
    // [CreateBackupMetadata][google.bigtable.admin.v2.CreateBackupMetadata]. The
    // [response][google.longrunning.Operation.response] field type is
    // [Backup][google.bigtable.admin.v2.Backup], if successful. Cancelling the returned operation will stop the
    // creation and delete the backup.
    virtual ::grpc::Status CreateBackup(::grpc::ServerContext* context, const ::google::bigtable::admin::v2::CreateBackupRequest* request, ::google::longrunning::Operation* response);
    // Gets metadata on a pending or completed Cloud Bigtable Backup.
    virtual ::grpc::Status GetBackup(::grpc::ServerContext* context, const ::google::bigtable::admin::v2::GetBackupRequest* request, ::google::bigtable::admin::v2::Backup* response);
    // Updates a pending or completed Cloud Bigtable Backup.
    virtual ::grpc::Status UpdateBackup(::grpc::ServerContext* context, const ::google::bigtable::admin::v2::UpdateBackupRequest* request, ::google::bigtable::admin::v2::Backup* response);
    // Deletes a pending or completed Cloud Bigtable backup.
    virtual ::grpc::Status DeleteBackup(::grpc::ServerContext* context, const ::google::bigtable::admin::v2::DeleteBackupRequest* request, ::google::protobuf::Empty* response);
    // Lists Cloud Bigtable backups. Returns both completed and pending
    // backups.
    virtual ::grpc::Status ListBackups(::grpc::ServerContext* context, const ::google::bigtable::admin::v2::ListBackupsRequest* request, ::google::bigtable::admin::v2::ListBackupsResponse* response);
    // Create a new table by restoring from a completed backup. The new table
    // must be in the same project as the instance containing the backup.  The
    // returned table [long-running operation][google.longrunning.Operation] can
    // be used to track the progress of the operation, and to cancel it.  The
    // [metadata][google.longrunning.Operation.metadata] field type is
    // [RestoreTableMetadata][google.bigtable.admin.RestoreTableMetadata].  The
    // [response][google.longrunning.Operation.response] type is
    // [Table][google.bigtable.admin.v2.Table], if successful.
    virtual ::grpc::Status RestoreTable(::grpc::ServerContext* context, const ::google::bigtable::admin::v2::RestoreTableRequest* request, ::google::longrunning::Operation* response);
    // Gets the access control policy for a Table or Backup resource.
    // Returns an empty policy if the resource exists but does not have a policy
    // set.
    virtual ::grpc::Status GetIamPolicy(::grpc::ServerContext* context, const ::google::iam::v1::GetIamPolicyRequest* request, ::google::iam::v1::Policy* response);
    // Sets the access control policy on a Table or Backup resource.
    // Replaces any existing policy.
    virtual ::grpc::Status SetIamPolicy(::grpc::ServerContext* context, const ::google::iam::v1::SetIamPolicyRequest* request, ::google::iam::v1::Policy* response);
    // Returns permissions that the caller has on the specified Table or Backup resource.
    virtual ::grpc::Status TestIamPermissions(::grpc::ServerContext* context, const ::google::iam::v1::TestIamPermissionsRequest* request, ::google::iam::v1::TestIamPermissionsResponse* response);
  };
  template <class BaseClass>
  class WithAsyncMethod_CreateTable : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_CreateTable() {
      ::grpc::Service::MarkMethodAsync(0);
    }
    ~WithAsyncMethod_CreateTable() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateTable(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::CreateTableRequest* /*request*/, ::google::bigtable::admin::v2::Table* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestCreateTable(::grpc::ServerContext* context, ::google::bigtable::admin::v2::CreateTableRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::bigtable::admin::v2::Table>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(0, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_CreateTableFromSnapshot : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_CreateTableFromSnapshot() {
      ::grpc::Service::MarkMethodAsync(1);
    }
    ~WithAsyncMethod_CreateTableFromSnapshot() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateTableFromSnapshot(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::CreateTableFromSnapshotRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestCreateTableFromSnapshot(::grpc::ServerContext* context, ::google::bigtable::admin::v2::CreateTableFromSnapshotRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::longrunning::Operation>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(1, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_ListTables : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_ListTables() {
      ::grpc::Service::MarkMethodAsync(2);
    }
    ~WithAsyncMethod_ListTables() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListTables(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::ListTablesRequest* /*request*/, ::google::bigtable::admin::v2::ListTablesResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestListTables(::grpc::ServerContext* context, ::google::bigtable::admin::v2::ListTablesRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::bigtable::admin::v2::ListTablesResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(2, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_GetTable : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_GetTable() {
      ::grpc::Service::MarkMethodAsync(3);
    }
    ~WithAsyncMethod_GetTable() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetTable(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::GetTableRequest* /*request*/, ::google::bigtable::admin::v2::Table* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGetTable(::grpc::ServerContext* context, ::google::bigtable::admin::v2::GetTableRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::bigtable::admin::v2::Table>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(3, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_DeleteTable : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_DeleteTable() {
      ::grpc::Service::MarkMethodAsync(4);
    }
    ~WithAsyncMethod_DeleteTable() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteTable(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::DeleteTableRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestDeleteTable(::grpc::ServerContext* context, ::google::bigtable::admin::v2::DeleteTableRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::protobuf::Empty>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(4, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_ModifyColumnFamilies : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_ModifyColumnFamilies() {
      ::grpc::Service::MarkMethodAsync(5);
    }
    ~WithAsyncMethod_ModifyColumnFamilies() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ModifyColumnFamilies(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::ModifyColumnFamiliesRequest* /*request*/, ::google::bigtable::admin::v2::Table* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestModifyColumnFamilies(::grpc::ServerContext* context, ::google::bigtable::admin::v2::ModifyColumnFamiliesRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::bigtable::admin::v2::Table>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(5, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_DropRowRange : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_DropRowRange() {
      ::grpc::Service::MarkMethodAsync(6);
    }
    ~WithAsyncMethod_DropRowRange() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DropRowRange(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::DropRowRangeRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestDropRowRange(::grpc::ServerContext* context, ::google::bigtable::admin::v2::DropRowRangeRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::protobuf::Empty>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(6, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_GenerateConsistencyToken : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_GenerateConsistencyToken() {
      ::grpc::Service::MarkMethodAsync(7);
    }
    ~WithAsyncMethod_GenerateConsistencyToken() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GenerateConsistencyToken(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::GenerateConsistencyTokenRequest* /*request*/, ::google::bigtable::admin::v2::GenerateConsistencyTokenResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGenerateConsistencyToken(::grpc::ServerContext* context, ::google::bigtable::admin::v2::GenerateConsistencyTokenRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::bigtable::admin::v2::GenerateConsistencyTokenResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(7, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_CheckConsistency : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_CheckConsistency() {
      ::grpc::Service::MarkMethodAsync(8);
    }
    ~WithAsyncMethod_CheckConsistency() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CheckConsistency(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::CheckConsistencyRequest* /*request*/, ::google::bigtable::admin::v2::CheckConsistencyResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestCheckConsistency(::grpc::ServerContext* context, ::google::bigtable::admin::v2::CheckConsistencyRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::bigtable::admin::v2::CheckConsistencyResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(8, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_SnapshotTable : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_SnapshotTable() {
      ::grpc::Service::MarkMethodAsync(9);
    }
    ~WithAsyncMethod_SnapshotTable() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status SnapshotTable(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::SnapshotTableRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestSnapshotTable(::grpc::ServerContext* context, ::google::bigtable::admin::v2::SnapshotTableRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::longrunning::Operation>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(9, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_GetSnapshot : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_GetSnapshot() {
      ::grpc::Service::MarkMethodAsync(10);
    }
    ~WithAsyncMethod_GetSnapshot() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetSnapshot(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::GetSnapshotRequest* /*request*/, ::google::bigtable::admin::v2::Snapshot* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGetSnapshot(::grpc::ServerContext* context, ::google::bigtable::admin::v2::GetSnapshotRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::bigtable::admin::v2::Snapshot>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(10, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_ListSnapshots : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_ListSnapshots() {
      ::grpc::Service::MarkMethodAsync(11);
    }
    ~WithAsyncMethod_ListSnapshots() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListSnapshots(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::ListSnapshotsRequest* /*request*/, ::google::bigtable::admin::v2::ListSnapshotsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestListSnapshots(::grpc::ServerContext* context, ::google::bigtable::admin::v2::ListSnapshotsRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::bigtable::admin::v2::ListSnapshotsResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(11, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_DeleteSnapshot : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_DeleteSnapshot() {
      ::grpc::Service::MarkMethodAsync(12);
    }
    ~WithAsyncMethod_DeleteSnapshot() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteSnapshot(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::DeleteSnapshotRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestDeleteSnapshot(::grpc::ServerContext* context, ::google::bigtable::admin::v2::DeleteSnapshotRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::protobuf::Empty>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(12, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_CreateBackup : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_CreateBackup() {
      ::grpc::Service::MarkMethodAsync(13);
    }
    ~WithAsyncMethod_CreateBackup() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateBackup(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::CreateBackupRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestCreateBackup(::grpc::ServerContext* context, ::google::bigtable::admin::v2::CreateBackupRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::longrunning::Operation>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(13, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_GetBackup : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_GetBackup() {
      ::grpc::Service::MarkMethodAsync(14);
    }
    ~WithAsyncMethod_GetBackup() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetBackup(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::GetBackupRequest* /*request*/, ::google::bigtable::admin::v2::Backup* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGetBackup(::grpc::ServerContext* context, ::google::bigtable::admin::v2::GetBackupRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::bigtable::admin::v2::Backup>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(14, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_UpdateBackup : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_UpdateBackup() {
      ::grpc::Service::MarkMethodAsync(15);
    }
    ~WithAsyncMethod_UpdateBackup() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateBackup(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::UpdateBackupRequest* /*request*/, ::google::bigtable::admin::v2::Backup* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestUpdateBackup(::grpc::ServerContext* context, ::google::bigtable::admin::v2::UpdateBackupRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::bigtable::admin::v2::Backup>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(15, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_DeleteBackup : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_DeleteBackup() {
      ::grpc::Service::MarkMethodAsync(16);
    }
    ~WithAsyncMethod_DeleteBackup() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteBackup(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::DeleteBackupRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestDeleteBackup(::grpc::ServerContext* context, ::google::bigtable::admin::v2::DeleteBackupRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::protobuf::Empty>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(16, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_ListBackups : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_ListBackups() {
      ::grpc::Service::MarkMethodAsync(17);
    }
    ~WithAsyncMethod_ListBackups() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListBackups(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::ListBackupsRequest* /*request*/, ::google::bigtable::admin::v2::ListBackupsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestListBackups(::grpc::ServerContext* context, ::google::bigtable::admin::v2::ListBackupsRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::bigtable::admin::v2::ListBackupsResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(17, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_RestoreTable : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_RestoreTable() {
      ::grpc::Service::MarkMethodAsync(18);
    }
    ~WithAsyncMethod_RestoreTable() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status RestoreTable(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::RestoreTableRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestRestoreTable(::grpc::ServerContext* context, ::google::bigtable::admin::v2::RestoreTableRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::longrunning::Operation>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(18, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_GetIamPolicy : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_GetIamPolicy() {
      ::grpc::Service::MarkMethodAsync(19);
    }
    ~WithAsyncMethod_GetIamPolicy() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetIamPolicy(::grpc::ServerContext* /*context*/, const ::google::iam::v1::GetIamPolicyRequest* /*request*/, ::google::iam::v1::Policy* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGetIamPolicy(::grpc::ServerContext* context, ::google::iam::v1::GetIamPolicyRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::iam::v1::Policy>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(19, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_SetIamPolicy : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_SetIamPolicy() {
      ::grpc::Service::MarkMethodAsync(20);
    }
    ~WithAsyncMethod_SetIamPolicy() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status SetIamPolicy(::grpc::ServerContext* /*context*/, const ::google::iam::v1::SetIamPolicyRequest* /*request*/, ::google::iam::v1::Policy* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestSetIamPolicy(::grpc::ServerContext* context, ::google::iam::v1::SetIamPolicyRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::iam::v1::Policy>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(20, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_TestIamPermissions : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_TestIamPermissions() {
      ::grpc::Service::MarkMethodAsync(21);
    }
    ~WithAsyncMethod_TestIamPermissions() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status TestIamPermissions(::grpc::ServerContext* /*context*/, const ::google::iam::v1::TestIamPermissionsRequest* /*request*/, ::google::iam::v1::TestIamPermissionsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestTestIamPermissions(::grpc::ServerContext* context, ::google::iam::v1::TestIamPermissionsRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::iam::v1::TestIamPermissionsResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(21, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  typedef WithAsyncMethod_CreateTable<WithAsyncMethod_CreateTableFromSnapshot<WithAsyncMethod_ListTables<WithAsyncMethod_GetTable<WithAsyncMethod_DeleteTable<WithAsyncMethod_ModifyColumnFamilies<WithAsyncMethod_DropRowRange<WithAsyncMethod_GenerateConsistencyToken<WithAsyncMethod_CheckConsistency<WithAsyncMethod_SnapshotTable<WithAsyncMethod_GetSnapshot<WithAsyncMethod_ListSnapshots<WithAsyncMethod_DeleteSnapshot<WithAsyncMethod_CreateBackup<WithAsyncMethod_GetBackup<WithAsyncMethod_UpdateBackup<WithAsyncMethod_DeleteBackup<WithAsyncMethod_ListBackups<WithAsyncMethod_RestoreTable<WithAsyncMethod_GetIamPolicy<WithAsyncMethod_SetIamPolicy<WithAsyncMethod_TestIamPermissions<Service > > > > > > > > > > > > > > > > > > > > > > AsyncService;
  template <class BaseClass>
  class WithCallbackMethod_CreateTable : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_CreateTable() {
      ::grpc::Service::MarkMethodCallback(0,
          new ::grpc::internal::CallbackUnaryHandler< ::google::bigtable::admin::v2::CreateTableRequest, ::google::bigtable::admin::v2::Table>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::bigtable::admin::v2::CreateTableRequest* request, ::google::bigtable::admin::v2::Table* response) { return this->CreateTable(context, request, response); }));}
    void SetMessageAllocatorFor_CreateTable(
        ::grpc::MessageAllocator< ::google::bigtable::admin::v2::CreateTableRequest, ::google::bigtable::admin::v2::Table>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(0);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::bigtable::admin::v2::CreateTableRequest, ::google::bigtable::admin::v2::Table>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_CreateTable() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateTable(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::CreateTableRequest* /*request*/, ::google::bigtable::admin::v2::Table* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* CreateTable(
      ::grpc::CallbackServerContext* /*context*/, const ::google::bigtable::admin::v2::CreateTableRequest* /*request*/, ::google::bigtable::admin::v2::Table* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_CreateTableFromSnapshot : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_CreateTableFromSnapshot() {
      ::grpc::Service::MarkMethodCallback(1,
          new ::grpc::internal::CallbackUnaryHandler< ::google::bigtable::admin::v2::CreateTableFromSnapshotRequest, ::google::longrunning::Operation>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::bigtable::admin::v2::CreateTableFromSnapshotRequest* request, ::google::longrunning::Operation* response) { return this->CreateTableFromSnapshot(context, request, response); }));}
    void SetMessageAllocatorFor_CreateTableFromSnapshot(
        ::grpc::MessageAllocator< ::google::bigtable::admin::v2::CreateTableFromSnapshotRequest, ::google::longrunning::Operation>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(1);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::bigtable::admin::v2::CreateTableFromSnapshotRequest, ::google::longrunning::Operation>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_CreateTableFromSnapshot() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateTableFromSnapshot(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::CreateTableFromSnapshotRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* CreateTableFromSnapshot(
      ::grpc::CallbackServerContext* /*context*/, const ::google::bigtable::admin::v2::CreateTableFromSnapshotRequest* /*request*/, ::google::longrunning::Operation* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_ListTables : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_ListTables() {
      ::grpc::Service::MarkMethodCallback(2,
          new ::grpc::internal::CallbackUnaryHandler< ::google::bigtable::admin::v2::ListTablesRequest, ::google::bigtable::admin::v2::ListTablesResponse>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::bigtable::admin::v2::ListTablesRequest* request, ::google::bigtable::admin::v2::ListTablesResponse* response) { return this->ListTables(context, request, response); }));}
    void SetMessageAllocatorFor_ListTables(
        ::grpc::MessageAllocator< ::google::bigtable::admin::v2::ListTablesRequest, ::google::bigtable::admin::v2::ListTablesResponse>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(2);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::bigtable::admin::v2::ListTablesRequest, ::google::bigtable::admin::v2::ListTablesResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_ListTables() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListTables(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::ListTablesRequest* /*request*/, ::google::bigtable::admin::v2::ListTablesResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* ListTables(
      ::grpc::CallbackServerContext* /*context*/, const ::google::bigtable::admin::v2::ListTablesRequest* /*request*/, ::google::bigtable::admin::v2::ListTablesResponse* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_GetTable : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_GetTable() {
      ::grpc::Service::MarkMethodCallback(3,
          new ::grpc::internal::CallbackUnaryHandler< ::google::bigtable::admin::v2::GetTableRequest, ::google::bigtable::admin::v2::Table>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::bigtable::admin::v2::GetTableRequest* request, ::google::bigtable::admin::v2::Table* response) { return this->GetTable(context, request, response); }));}
    void SetMessageAllocatorFor_GetTable(
        ::grpc::MessageAllocator< ::google::bigtable::admin::v2::GetTableRequest, ::google::bigtable::admin::v2::Table>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(3);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::bigtable::admin::v2::GetTableRequest, ::google::bigtable::admin::v2::Table>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_GetTable() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetTable(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::GetTableRequest* /*request*/, ::google::bigtable::admin::v2::Table* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* GetTable(
      ::grpc::CallbackServerContext* /*context*/, const ::google::bigtable::admin::v2::GetTableRequest* /*request*/, ::google::bigtable::admin::v2::Table* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_DeleteTable : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_DeleteTable() {
      ::grpc::Service::MarkMethodCallback(4,
          new ::grpc::internal::CallbackUnaryHandler< ::google::bigtable::admin::v2::DeleteTableRequest, ::google::protobuf::Empty>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::bigtable::admin::v2::DeleteTableRequest* request, ::google::protobuf::Empty* response) { return this->DeleteTable(context, request, response); }));}
    void SetMessageAllocatorFor_DeleteTable(
        ::grpc::MessageAllocator< ::google::bigtable::admin::v2::DeleteTableRequest, ::google::protobuf::Empty>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(4);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::bigtable::admin::v2::DeleteTableRequest, ::google::protobuf::Empty>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_DeleteTable() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteTable(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::DeleteTableRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* DeleteTable(
      ::grpc::CallbackServerContext* /*context*/, const ::google::bigtable::admin::v2::DeleteTableRequest* /*request*/, ::google::protobuf::Empty* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_ModifyColumnFamilies : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_ModifyColumnFamilies() {
      ::grpc::Service::MarkMethodCallback(5,
          new ::grpc::internal::CallbackUnaryHandler< ::google::bigtable::admin::v2::ModifyColumnFamiliesRequest, ::google::bigtable::admin::v2::Table>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::bigtable::admin::v2::ModifyColumnFamiliesRequest* request, ::google::bigtable::admin::v2::Table* response) { return this->ModifyColumnFamilies(context, request, response); }));}
    void SetMessageAllocatorFor_ModifyColumnFamilies(
        ::grpc::MessageAllocator< ::google::bigtable::admin::v2::ModifyColumnFamiliesRequest, ::google::bigtable::admin::v2::Table>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(5);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::bigtable::admin::v2::ModifyColumnFamiliesRequest, ::google::bigtable::admin::v2::Table>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_ModifyColumnFamilies() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ModifyColumnFamilies(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::ModifyColumnFamiliesRequest* /*request*/, ::google::bigtable::admin::v2::Table* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* ModifyColumnFamilies(
      ::grpc::CallbackServerContext* /*context*/, const ::google::bigtable::admin::v2::ModifyColumnFamiliesRequest* /*request*/, ::google::bigtable::admin::v2::Table* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_DropRowRange : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_DropRowRange() {
      ::grpc::Service::MarkMethodCallback(6,
          new ::grpc::internal::CallbackUnaryHandler< ::google::bigtable::admin::v2::DropRowRangeRequest, ::google::protobuf::Empty>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::bigtable::admin::v2::DropRowRangeRequest* request, ::google::protobuf::Empty* response) { return this->DropRowRange(context, request, response); }));}
    void SetMessageAllocatorFor_DropRowRange(
        ::grpc::MessageAllocator< ::google::bigtable::admin::v2::DropRowRangeRequest, ::google::protobuf::Empty>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(6);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::bigtable::admin::v2::DropRowRangeRequest, ::google::protobuf::Empty>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_DropRowRange() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DropRowRange(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::DropRowRangeRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* DropRowRange(
      ::grpc::CallbackServerContext* /*context*/, const ::google::bigtable::admin::v2::DropRowRangeRequest* /*request*/, ::google::protobuf::Empty* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_GenerateConsistencyToken : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_GenerateConsistencyToken() {
      ::grpc::Service::MarkMethodCallback(7,
          new ::grpc::internal::CallbackUnaryHandler< ::google::bigtable::admin::v2::GenerateConsistencyTokenRequest, ::google::bigtable::admin::v2::GenerateConsistencyTokenResponse>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::bigtable::admin::v2::GenerateConsistencyTokenRequest* request, ::google::bigtable::admin::v2::GenerateConsistencyTokenResponse* response) { return this->GenerateConsistencyToken(context, request, response); }));}
    void SetMessageAllocatorFor_GenerateConsistencyToken(
        ::grpc::MessageAllocator< ::google::bigtable::admin::v2::GenerateConsistencyTokenRequest, ::google::bigtable::admin::v2::GenerateConsistencyTokenResponse>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(7);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::bigtable::admin::v2::GenerateConsistencyTokenRequest, ::google::bigtable::admin::v2::GenerateConsistencyTokenResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_GenerateConsistencyToken() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GenerateConsistencyToken(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::GenerateConsistencyTokenRequest* /*request*/, ::google::bigtable::admin::v2::GenerateConsistencyTokenResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* GenerateConsistencyToken(
      ::grpc::CallbackServerContext* /*context*/, const ::google::bigtable::admin::v2::GenerateConsistencyTokenRequest* /*request*/, ::google::bigtable::admin::v2::GenerateConsistencyTokenResponse* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_CheckConsistency : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_CheckConsistency() {
      ::grpc::Service::MarkMethodCallback(8,
          new ::grpc::internal::CallbackUnaryHandler< ::google::bigtable::admin::v2::CheckConsistencyRequest, ::google::bigtable::admin::v2::CheckConsistencyResponse>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::bigtable::admin::v2::CheckConsistencyRequest* request, ::google::bigtable::admin::v2::CheckConsistencyResponse* response) { return this->CheckConsistency(context, request, response); }));}
    void SetMessageAllocatorFor_CheckConsistency(
        ::grpc::MessageAllocator< ::google::bigtable::admin::v2::CheckConsistencyRequest, ::google::bigtable::admin::v2::CheckConsistencyResponse>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(8);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::bigtable::admin::v2::CheckConsistencyRequest, ::google::bigtable::admin::v2::CheckConsistencyResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_CheckConsistency() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CheckConsistency(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::CheckConsistencyRequest* /*request*/, ::google::bigtable::admin::v2::CheckConsistencyResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* CheckConsistency(
      ::grpc::CallbackServerContext* /*context*/, const ::google::bigtable::admin::v2::CheckConsistencyRequest* /*request*/, ::google::bigtable::admin::v2::CheckConsistencyResponse* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_SnapshotTable : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_SnapshotTable() {
      ::grpc::Service::MarkMethodCallback(9,
          new ::grpc::internal::CallbackUnaryHandler< ::google::bigtable::admin::v2::SnapshotTableRequest, ::google::longrunning::Operation>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::bigtable::admin::v2::SnapshotTableRequest* request, ::google::longrunning::Operation* response) { return this->SnapshotTable(context, request, response); }));}
    void SetMessageAllocatorFor_SnapshotTable(
        ::grpc::MessageAllocator< ::google::bigtable::admin::v2::SnapshotTableRequest, ::google::longrunning::Operation>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(9);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::bigtable::admin::v2::SnapshotTableRequest, ::google::longrunning::Operation>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_SnapshotTable() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status SnapshotTable(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::SnapshotTableRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* SnapshotTable(
      ::grpc::CallbackServerContext* /*context*/, const ::google::bigtable::admin::v2::SnapshotTableRequest* /*request*/, ::google::longrunning::Operation* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_GetSnapshot : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_GetSnapshot() {
      ::grpc::Service::MarkMethodCallback(10,
          new ::grpc::internal::CallbackUnaryHandler< ::google::bigtable::admin::v2::GetSnapshotRequest, ::google::bigtable::admin::v2::Snapshot>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::bigtable::admin::v2::GetSnapshotRequest* request, ::google::bigtable::admin::v2::Snapshot* response) { return this->GetSnapshot(context, request, response); }));}
    void SetMessageAllocatorFor_GetSnapshot(
        ::grpc::MessageAllocator< ::google::bigtable::admin::v2::GetSnapshotRequest, ::google::bigtable::admin::v2::Snapshot>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(10);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::bigtable::admin::v2::GetSnapshotRequest, ::google::bigtable::admin::v2::Snapshot>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_GetSnapshot() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetSnapshot(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::GetSnapshotRequest* /*request*/, ::google::bigtable::admin::v2::Snapshot* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* GetSnapshot(
      ::grpc::CallbackServerContext* /*context*/, const ::google::bigtable::admin::v2::GetSnapshotRequest* /*request*/, ::google::bigtable::admin::v2::Snapshot* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_ListSnapshots : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_ListSnapshots() {
      ::grpc::Service::MarkMethodCallback(11,
          new ::grpc::internal::CallbackUnaryHandler< ::google::bigtable::admin::v2::ListSnapshotsRequest, ::google::bigtable::admin::v2::ListSnapshotsResponse>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::bigtable::admin::v2::ListSnapshotsRequest* request, ::google::bigtable::admin::v2::ListSnapshotsResponse* response) { return this->ListSnapshots(context, request, response); }));}
    void SetMessageAllocatorFor_ListSnapshots(
        ::grpc::MessageAllocator< ::google::bigtable::admin::v2::ListSnapshotsRequest, ::google::bigtable::admin::v2::ListSnapshotsResponse>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(11);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::bigtable::admin::v2::ListSnapshotsRequest, ::google::bigtable::admin::v2::ListSnapshotsResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_ListSnapshots() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListSnapshots(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::ListSnapshotsRequest* /*request*/, ::google::bigtable::admin::v2::ListSnapshotsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* ListSnapshots(
      ::grpc::CallbackServerContext* /*context*/, const ::google::bigtable::admin::v2::ListSnapshotsRequest* /*request*/, ::google::bigtable::admin::v2::ListSnapshotsResponse* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_DeleteSnapshot : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_DeleteSnapshot() {
      ::grpc::Service::MarkMethodCallback(12,
          new ::grpc::internal::CallbackUnaryHandler< ::google::bigtable::admin::v2::DeleteSnapshotRequest, ::google::protobuf::Empty>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::bigtable::admin::v2::DeleteSnapshotRequest* request, ::google::protobuf::Empty* response) { return this->DeleteSnapshot(context, request, response); }));}
    void SetMessageAllocatorFor_DeleteSnapshot(
        ::grpc::MessageAllocator< ::google::bigtable::admin::v2::DeleteSnapshotRequest, ::google::protobuf::Empty>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(12);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::bigtable::admin::v2::DeleteSnapshotRequest, ::google::protobuf::Empty>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_DeleteSnapshot() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteSnapshot(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::DeleteSnapshotRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* DeleteSnapshot(
      ::grpc::CallbackServerContext* /*context*/, const ::google::bigtable::admin::v2::DeleteSnapshotRequest* /*request*/, ::google::protobuf::Empty* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_CreateBackup : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_CreateBackup() {
      ::grpc::Service::MarkMethodCallback(13,
          new ::grpc::internal::CallbackUnaryHandler< ::google::bigtable::admin::v2::CreateBackupRequest, ::google::longrunning::Operation>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::bigtable::admin::v2::CreateBackupRequest* request, ::google::longrunning::Operation* response) { return this->CreateBackup(context, request, response); }));}
    void SetMessageAllocatorFor_CreateBackup(
        ::grpc::MessageAllocator< ::google::bigtable::admin::v2::CreateBackupRequest, ::google::longrunning::Operation>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(13);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::bigtable::admin::v2::CreateBackupRequest, ::google::longrunning::Operation>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_CreateBackup() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateBackup(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::CreateBackupRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* CreateBackup(
      ::grpc::CallbackServerContext* /*context*/, const ::google::bigtable::admin::v2::CreateBackupRequest* /*request*/, ::google::longrunning::Operation* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_GetBackup : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_GetBackup() {
      ::grpc::Service::MarkMethodCallback(14,
          new ::grpc::internal::CallbackUnaryHandler< ::google::bigtable::admin::v2::GetBackupRequest, ::google::bigtable::admin::v2::Backup>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::bigtable::admin::v2::GetBackupRequest* request, ::google::bigtable::admin::v2::Backup* response) { return this->GetBackup(context, request, response); }));}
    void SetMessageAllocatorFor_GetBackup(
        ::grpc::MessageAllocator< ::google::bigtable::admin::v2::GetBackupRequest, ::google::bigtable::admin::v2::Backup>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(14);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::bigtable::admin::v2::GetBackupRequest, ::google::bigtable::admin::v2::Backup>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_GetBackup() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetBackup(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::GetBackupRequest* /*request*/, ::google::bigtable::admin::v2::Backup* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* GetBackup(
      ::grpc::CallbackServerContext* /*context*/, const ::google::bigtable::admin::v2::GetBackupRequest* /*request*/, ::google::bigtable::admin::v2::Backup* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_UpdateBackup : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_UpdateBackup() {
      ::grpc::Service::MarkMethodCallback(15,
          new ::grpc::internal::CallbackUnaryHandler< ::google::bigtable::admin::v2::UpdateBackupRequest, ::google::bigtable::admin::v2::Backup>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::bigtable::admin::v2::UpdateBackupRequest* request, ::google::bigtable::admin::v2::Backup* response) { return this->UpdateBackup(context, request, response); }));}
    void SetMessageAllocatorFor_UpdateBackup(
        ::grpc::MessageAllocator< ::google::bigtable::admin::v2::UpdateBackupRequest, ::google::bigtable::admin::v2::Backup>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(15);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::bigtable::admin::v2::UpdateBackupRequest, ::google::bigtable::admin::v2::Backup>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_UpdateBackup() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateBackup(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::UpdateBackupRequest* /*request*/, ::google::bigtable::admin::v2::Backup* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* UpdateBackup(
      ::grpc::CallbackServerContext* /*context*/, const ::google::bigtable::admin::v2::UpdateBackupRequest* /*request*/, ::google::bigtable::admin::v2::Backup* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_DeleteBackup : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_DeleteBackup() {
      ::grpc::Service::MarkMethodCallback(16,
          new ::grpc::internal::CallbackUnaryHandler< ::google::bigtable::admin::v2::DeleteBackupRequest, ::google::protobuf::Empty>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::bigtable::admin::v2::DeleteBackupRequest* request, ::google::protobuf::Empty* response) { return this->DeleteBackup(context, request, response); }));}
    void SetMessageAllocatorFor_DeleteBackup(
        ::grpc::MessageAllocator< ::google::bigtable::admin::v2::DeleteBackupRequest, ::google::protobuf::Empty>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(16);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::bigtable::admin::v2::DeleteBackupRequest, ::google::protobuf::Empty>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_DeleteBackup() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteBackup(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::DeleteBackupRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* DeleteBackup(
      ::grpc::CallbackServerContext* /*context*/, const ::google::bigtable::admin::v2::DeleteBackupRequest* /*request*/, ::google::protobuf::Empty* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_ListBackups : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_ListBackups() {
      ::grpc::Service::MarkMethodCallback(17,
          new ::grpc::internal::CallbackUnaryHandler< ::google::bigtable::admin::v2::ListBackupsRequest, ::google::bigtable::admin::v2::ListBackupsResponse>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::bigtable::admin::v2::ListBackupsRequest* request, ::google::bigtable::admin::v2::ListBackupsResponse* response) { return this->ListBackups(context, request, response); }));}
    void SetMessageAllocatorFor_ListBackups(
        ::grpc::MessageAllocator< ::google::bigtable::admin::v2::ListBackupsRequest, ::google::bigtable::admin::v2::ListBackupsResponse>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(17);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::bigtable::admin::v2::ListBackupsRequest, ::google::bigtable::admin::v2::ListBackupsResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_ListBackups() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListBackups(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::ListBackupsRequest* /*request*/, ::google::bigtable::admin::v2::ListBackupsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* ListBackups(
      ::grpc::CallbackServerContext* /*context*/, const ::google::bigtable::admin::v2::ListBackupsRequest* /*request*/, ::google::bigtable::admin::v2::ListBackupsResponse* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_RestoreTable : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_RestoreTable() {
      ::grpc::Service::MarkMethodCallback(18,
          new ::grpc::internal::CallbackUnaryHandler< ::google::bigtable::admin::v2::RestoreTableRequest, ::google::longrunning::Operation>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::bigtable::admin::v2::RestoreTableRequest* request, ::google::longrunning::Operation* response) { return this->RestoreTable(context, request, response); }));}
    void SetMessageAllocatorFor_RestoreTable(
        ::grpc::MessageAllocator< ::google::bigtable::admin::v2::RestoreTableRequest, ::google::longrunning::Operation>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(18);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::bigtable::admin::v2::RestoreTableRequest, ::google::longrunning::Operation>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_RestoreTable() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status RestoreTable(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::RestoreTableRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* RestoreTable(
      ::grpc::CallbackServerContext* /*context*/, const ::google::bigtable::admin::v2::RestoreTableRequest* /*request*/, ::google::longrunning::Operation* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_GetIamPolicy : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_GetIamPolicy() {
      ::grpc::Service::MarkMethodCallback(19,
          new ::grpc::internal::CallbackUnaryHandler< ::google::iam::v1::GetIamPolicyRequest, ::google::iam::v1::Policy>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::iam::v1::GetIamPolicyRequest* request, ::google::iam::v1::Policy* response) { return this->GetIamPolicy(context, request, response); }));}
    void SetMessageAllocatorFor_GetIamPolicy(
        ::grpc::MessageAllocator< ::google::iam::v1::GetIamPolicyRequest, ::google::iam::v1::Policy>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(19);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::iam::v1::GetIamPolicyRequest, ::google::iam::v1::Policy>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_GetIamPolicy() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetIamPolicy(::grpc::ServerContext* /*context*/, const ::google::iam::v1::GetIamPolicyRequest* /*request*/, ::google::iam::v1::Policy* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* GetIamPolicy(
      ::grpc::CallbackServerContext* /*context*/, const ::google::iam::v1::GetIamPolicyRequest* /*request*/, ::google::iam::v1::Policy* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_SetIamPolicy : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_SetIamPolicy() {
      ::grpc::Service::MarkMethodCallback(20,
          new ::grpc::internal::CallbackUnaryHandler< ::google::iam::v1::SetIamPolicyRequest, ::google::iam::v1::Policy>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::iam::v1::SetIamPolicyRequest* request, ::google::iam::v1::Policy* response) { return this->SetIamPolicy(context, request, response); }));}
    void SetMessageAllocatorFor_SetIamPolicy(
        ::grpc::MessageAllocator< ::google::iam::v1::SetIamPolicyRequest, ::google::iam::v1::Policy>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(20);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::iam::v1::SetIamPolicyRequest, ::google::iam::v1::Policy>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_SetIamPolicy() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status SetIamPolicy(::grpc::ServerContext* /*context*/, const ::google::iam::v1::SetIamPolicyRequest* /*request*/, ::google::iam::v1::Policy* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* SetIamPolicy(
      ::grpc::CallbackServerContext* /*context*/, const ::google::iam::v1::SetIamPolicyRequest* /*request*/, ::google::iam::v1::Policy* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_TestIamPermissions : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_TestIamPermissions() {
      ::grpc::Service::MarkMethodCallback(21,
          new ::grpc::internal::CallbackUnaryHandler< ::google::iam::v1::TestIamPermissionsRequest, ::google::iam::v1::TestIamPermissionsResponse>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::iam::v1::TestIamPermissionsRequest* request, ::google::iam::v1::TestIamPermissionsResponse* response) { return this->TestIamPermissions(context, request, response); }));}
    void SetMessageAllocatorFor_TestIamPermissions(
        ::grpc::MessageAllocator< ::google::iam::v1::TestIamPermissionsRequest, ::google::iam::v1::TestIamPermissionsResponse>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(21);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::iam::v1::TestIamPermissionsRequest, ::google::iam::v1::TestIamPermissionsResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_TestIamPermissions() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status TestIamPermissions(::grpc::ServerContext* /*context*/, const ::google::iam::v1::TestIamPermissionsRequest* /*request*/, ::google::iam::v1::TestIamPermissionsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* TestIamPermissions(
      ::grpc::CallbackServerContext* /*context*/, const ::google::iam::v1::TestIamPermissionsRequest* /*request*/, ::google::iam::v1::TestIamPermissionsResponse* /*response*/)  { return nullptr; }
  };
  typedef WithCallbackMethod_CreateTable<WithCallbackMethod_CreateTableFromSnapshot<WithCallbackMethod_ListTables<WithCallbackMethod_GetTable<WithCallbackMethod_DeleteTable<WithCallbackMethod_ModifyColumnFamilies<WithCallbackMethod_DropRowRange<WithCallbackMethod_GenerateConsistencyToken<WithCallbackMethod_CheckConsistency<WithCallbackMethod_SnapshotTable<WithCallbackMethod_GetSnapshot<WithCallbackMethod_ListSnapshots<WithCallbackMethod_DeleteSnapshot<WithCallbackMethod_CreateBackup<WithCallbackMethod_GetBackup<WithCallbackMethod_UpdateBackup<WithCallbackMethod_DeleteBackup<WithCallbackMethod_ListBackups<WithCallbackMethod_RestoreTable<WithCallbackMethod_GetIamPolicy<WithCallbackMethod_SetIamPolicy<WithCallbackMethod_TestIamPermissions<Service > > > > > > > > > > > > > > > > > > > > > > CallbackService;
  typedef CallbackService ExperimentalCallbackService;
  template <class BaseClass>
  class WithGenericMethod_CreateTable : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_CreateTable() {
      ::grpc::Service::MarkMethodGeneric(0);
    }
    ~WithGenericMethod_CreateTable() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateTable(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::CreateTableRequest* /*request*/, ::google::bigtable::admin::v2::Table* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_CreateTableFromSnapshot : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_CreateTableFromSnapshot() {
      ::grpc::Service::MarkMethodGeneric(1);
    }
    ~WithGenericMethod_CreateTableFromSnapshot() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateTableFromSnapshot(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::CreateTableFromSnapshotRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_ListTables : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_ListTables() {
      ::grpc::Service::MarkMethodGeneric(2);
    }
    ~WithGenericMethod_ListTables() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListTables(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::ListTablesRequest* /*request*/, ::google::bigtable::admin::v2::ListTablesResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_GetTable : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_GetTable() {
      ::grpc::Service::MarkMethodGeneric(3);
    }
    ~WithGenericMethod_GetTable() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetTable(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::GetTableRequest* /*request*/, ::google::bigtable::admin::v2::Table* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_DeleteTable : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_DeleteTable() {
      ::grpc::Service::MarkMethodGeneric(4);
    }
    ~WithGenericMethod_DeleteTable() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteTable(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::DeleteTableRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_ModifyColumnFamilies : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_ModifyColumnFamilies() {
      ::grpc::Service::MarkMethodGeneric(5);
    }
    ~WithGenericMethod_ModifyColumnFamilies() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ModifyColumnFamilies(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::ModifyColumnFamiliesRequest* /*request*/, ::google::bigtable::admin::v2::Table* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_DropRowRange : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_DropRowRange() {
      ::grpc::Service::MarkMethodGeneric(6);
    }
    ~WithGenericMethod_DropRowRange() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DropRowRange(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::DropRowRangeRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_GenerateConsistencyToken : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_GenerateConsistencyToken() {
      ::grpc::Service::MarkMethodGeneric(7);
    }
    ~WithGenericMethod_GenerateConsistencyToken() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GenerateConsistencyToken(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::GenerateConsistencyTokenRequest* /*request*/, ::google::bigtable::admin::v2::GenerateConsistencyTokenResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_CheckConsistency : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_CheckConsistency() {
      ::grpc::Service::MarkMethodGeneric(8);
    }
    ~WithGenericMethod_CheckConsistency() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CheckConsistency(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::CheckConsistencyRequest* /*request*/, ::google::bigtable::admin::v2::CheckConsistencyResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_SnapshotTable : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_SnapshotTable() {
      ::grpc::Service::MarkMethodGeneric(9);
    }
    ~WithGenericMethod_SnapshotTable() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status SnapshotTable(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::SnapshotTableRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_GetSnapshot : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_GetSnapshot() {
      ::grpc::Service::MarkMethodGeneric(10);
    }
    ~WithGenericMethod_GetSnapshot() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetSnapshot(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::GetSnapshotRequest* /*request*/, ::google::bigtable::admin::v2::Snapshot* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_ListSnapshots : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_ListSnapshots() {
      ::grpc::Service::MarkMethodGeneric(11);
    }
    ~WithGenericMethod_ListSnapshots() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListSnapshots(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::ListSnapshotsRequest* /*request*/, ::google::bigtable::admin::v2::ListSnapshotsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_DeleteSnapshot : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_DeleteSnapshot() {
      ::grpc::Service::MarkMethodGeneric(12);
    }
    ~WithGenericMethod_DeleteSnapshot() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteSnapshot(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::DeleteSnapshotRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_CreateBackup : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_CreateBackup() {
      ::grpc::Service::MarkMethodGeneric(13);
    }
    ~WithGenericMethod_CreateBackup() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateBackup(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::CreateBackupRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_GetBackup : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_GetBackup() {
      ::grpc::Service::MarkMethodGeneric(14);
    }
    ~WithGenericMethod_GetBackup() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetBackup(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::GetBackupRequest* /*request*/, ::google::bigtable::admin::v2::Backup* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_UpdateBackup : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_UpdateBackup() {
      ::grpc::Service::MarkMethodGeneric(15);
    }
    ~WithGenericMethod_UpdateBackup() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateBackup(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::UpdateBackupRequest* /*request*/, ::google::bigtable::admin::v2::Backup* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_DeleteBackup : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_DeleteBackup() {
      ::grpc::Service::MarkMethodGeneric(16);
    }
    ~WithGenericMethod_DeleteBackup() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteBackup(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::DeleteBackupRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_ListBackups : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_ListBackups() {
      ::grpc::Service::MarkMethodGeneric(17);
    }
    ~WithGenericMethod_ListBackups() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListBackups(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::ListBackupsRequest* /*request*/, ::google::bigtable::admin::v2::ListBackupsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_RestoreTable : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_RestoreTable() {
      ::grpc::Service::MarkMethodGeneric(18);
    }
    ~WithGenericMethod_RestoreTable() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status RestoreTable(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::RestoreTableRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_GetIamPolicy : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_GetIamPolicy() {
      ::grpc::Service::MarkMethodGeneric(19);
    }
    ~WithGenericMethod_GetIamPolicy() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetIamPolicy(::grpc::ServerContext* /*context*/, const ::google::iam::v1::GetIamPolicyRequest* /*request*/, ::google::iam::v1::Policy* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_SetIamPolicy : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_SetIamPolicy() {
      ::grpc::Service::MarkMethodGeneric(20);
    }
    ~WithGenericMethod_SetIamPolicy() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status SetIamPolicy(::grpc::ServerContext* /*context*/, const ::google::iam::v1::SetIamPolicyRequest* /*request*/, ::google::iam::v1::Policy* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_TestIamPermissions : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_TestIamPermissions() {
      ::grpc::Service::MarkMethodGeneric(21);
    }
    ~WithGenericMethod_TestIamPermissions() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status TestIamPermissions(::grpc::ServerContext* /*context*/, const ::google::iam::v1::TestIamPermissionsRequest* /*request*/, ::google::iam::v1::TestIamPermissionsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithRawMethod_CreateTable : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_CreateTable() {
      ::grpc::Service::MarkMethodRaw(0);
    }
    ~WithRawMethod_CreateTable() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateTable(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::CreateTableRequest* /*request*/, ::google::bigtable::admin::v2::Table* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestCreateTable(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(0, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_CreateTableFromSnapshot : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_CreateTableFromSnapshot() {
      ::grpc::Service::MarkMethodRaw(1);
    }
    ~WithRawMethod_CreateTableFromSnapshot() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateTableFromSnapshot(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::CreateTableFromSnapshotRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestCreateTableFromSnapshot(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(1, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_ListTables : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_ListTables() {
      ::grpc::Service::MarkMethodRaw(2);
    }
    ~WithRawMethod_ListTables() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListTables(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::ListTablesRequest* /*request*/, ::google::bigtable::admin::v2::ListTablesResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestListTables(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(2, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_GetTable : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_GetTable() {
      ::grpc::Service::MarkMethodRaw(3);
    }
    ~WithRawMethod_GetTable() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetTable(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::GetTableRequest* /*request*/, ::google::bigtable::admin::v2::Table* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGetTable(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(3, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_DeleteTable : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_DeleteTable() {
      ::grpc::Service::MarkMethodRaw(4);
    }
    ~WithRawMethod_DeleteTable() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteTable(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::DeleteTableRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestDeleteTable(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(4, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_ModifyColumnFamilies : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_ModifyColumnFamilies() {
      ::grpc::Service::MarkMethodRaw(5);
    }
    ~WithRawMethod_ModifyColumnFamilies() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ModifyColumnFamilies(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::ModifyColumnFamiliesRequest* /*request*/, ::google::bigtable::admin::v2::Table* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestModifyColumnFamilies(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(5, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_DropRowRange : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_DropRowRange() {
      ::grpc::Service::MarkMethodRaw(6);
    }
    ~WithRawMethod_DropRowRange() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DropRowRange(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::DropRowRangeRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestDropRowRange(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(6, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_GenerateConsistencyToken : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_GenerateConsistencyToken() {
      ::grpc::Service::MarkMethodRaw(7);
    }
    ~WithRawMethod_GenerateConsistencyToken() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GenerateConsistencyToken(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::GenerateConsistencyTokenRequest* /*request*/, ::google::bigtable::admin::v2::GenerateConsistencyTokenResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGenerateConsistencyToken(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(7, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_CheckConsistency : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_CheckConsistency() {
      ::grpc::Service::MarkMethodRaw(8);
    }
    ~WithRawMethod_CheckConsistency() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CheckConsistency(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::CheckConsistencyRequest* /*request*/, ::google::bigtable::admin::v2::CheckConsistencyResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestCheckConsistency(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(8, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_SnapshotTable : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_SnapshotTable() {
      ::grpc::Service::MarkMethodRaw(9);
    }
    ~WithRawMethod_SnapshotTable() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status SnapshotTable(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::SnapshotTableRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestSnapshotTable(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(9, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_GetSnapshot : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_GetSnapshot() {
      ::grpc::Service::MarkMethodRaw(10);
    }
    ~WithRawMethod_GetSnapshot() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetSnapshot(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::GetSnapshotRequest* /*request*/, ::google::bigtable::admin::v2::Snapshot* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGetSnapshot(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(10, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_ListSnapshots : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_ListSnapshots() {
      ::grpc::Service::MarkMethodRaw(11);
    }
    ~WithRawMethod_ListSnapshots() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListSnapshots(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::ListSnapshotsRequest* /*request*/, ::google::bigtable::admin::v2::ListSnapshotsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestListSnapshots(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(11, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_DeleteSnapshot : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_DeleteSnapshot() {
      ::grpc::Service::MarkMethodRaw(12);
    }
    ~WithRawMethod_DeleteSnapshot() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteSnapshot(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::DeleteSnapshotRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestDeleteSnapshot(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(12, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_CreateBackup : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_CreateBackup() {
      ::grpc::Service::MarkMethodRaw(13);
    }
    ~WithRawMethod_CreateBackup() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateBackup(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::CreateBackupRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestCreateBackup(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(13, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_GetBackup : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_GetBackup() {
      ::grpc::Service::MarkMethodRaw(14);
    }
    ~WithRawMethod_GetBackup() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetBackup(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::GetBackupRequest* /*request*/, ::google::bigtable::admin::v2::Backup* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGetBackup(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(14, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_UpdateBackup : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_UpdateBackup() {
      ::grpc::Service::MarkMethodRaw(15);
    }
    ~WithRawMethod_UpdateBackup() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateBackup(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::UpdateBackupRequest* /*request*/, ::google::bigtable::admin::v2::Backup* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestUpdateBackup(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(15, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_DeleteBackup : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_DeleteBackup() {
      ::grpc::Service::MarkMethodRaw(16);
    }
    ~WithRawMethod_DeleteBackup() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteBackup(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::DeleteBackupRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestDeleteBackup(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(16, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_ListBackups : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_ListBackups() {
      ::grpc::Service::MarkMethodRaw(17);
    }
    ~WithRawMethod_ListBackups() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListBackups(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::ListBackupsRequest* /*request*/, ::google::bigtable::admin::v2::ListBackupsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestListBackups(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(17, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_RestoreTable : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_RestoreTable() {
      ::grpc::Service::MarkMethodRaw(18);
    }
    ~WithRawMethod_RestoreTable() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status RestoreTable(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::RestoreTableRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestRestoreTable(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(18, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_GetIamPolicy : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_GetIamPolicy() {
      ::grpc::Service::MarkMethodRaw(19);
    }
    ~WithRawMethod_GetIamPolicy() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetIamPolicy(::grpc::ServerContext* /*context*/, const ::google::iam::v1::GetIamPolicyRequest* /*request*/, ::google::iam::v1::Policy* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGetIamPolicy(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(19, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_SetIamPolicy : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_SetIamPolicy() {
      ::grpc::Service::MarkMethodRaw(20);
    }
    ~WithRawMethod_SetIamPolicy() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status SetIamPolicy(::grpc::ServerContext* /*context*/, const ::google::iam::v1::SetIamPolicyRequest* /*request*/, ::google::iam::v1::Policy* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestSetIamPolicy(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(20, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_TestIamPermissions : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_TestIamPermissions() {
      ::grpc::Service::MarkMethodRaw(21);
    }
    ~WithRawMethod_TestIamPermissions() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status TestIamPermissions(::grpc::ServerContext* /*context*/, const ::google::iam::v1::TestIamPermissionsRequest* /*request*/, ::google::iam::v1::TestIamPermissionsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestTestIamPermissions(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(21, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_CreateTable : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_CreateTable() {
      ::grpc::Service::MarkMethodRawCallback(0,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->CreateTable(context, request, response); }));
    }
    ~WithRawCallbackMethod_CreateTable() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateTable(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::CreateTableRequest* /*request*/, ::google::bigtable::admin::v2::Table* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* CreateTable(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_CreateTableFromSnapshot : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_CreateTableFromSnapshot() {
      ::grpc::Service::MarkMethodRawCallback(1,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->CreateTableFromSnapshot(context, request, response); }));
    }
    ~WithRawCallbackMethod_CreateTableFromSnapshot() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateTableFromSnapshot(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::CreateTableFromSnapshotRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* CreateTableFromSnapshot(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_ListTables : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_ListTables() {
      ::grpc::Service::MarkMethodRawCallback(2,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->ListTables(context, request, response); }));
    }
    ~WithRawCallbackMethod_ListTables() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListTables(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::ListTablesRequest* /*request*/, ::google::bigtable::admin::v2::ListTablesResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* ListTables(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_GetTable : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_GetTable() {
      ::grpc::Service::MarkMethodRawCallback(3,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->GetTable(context, request, response); }));
    }
    ~WithRawCallbackMethod_GetTable() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetTable(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::GetTableRequest* /*request*/, ::google::bigtable::admin::v2::Table* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* GetTable(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_DeleteTable : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_DeleteTable() {
      ::grpc::Service::MarkMethodRawCallback(4,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->DeleteTable(context, request, response); }));
    }
    ~WithRawCallbackMethod_DeleteTable() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteTable(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::DeleteTableRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* DeleteTable(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_ModifyColumnFamilies : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_ModifyColumnFamilies() {
      ::grpc::Service::MarkMethodRawCallback(5,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->ModifyColumnFamilies(context, request, response); }));
    }
    ~WithRawCallbackMethod_ModifyColumnFamilies() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ModifyColumnFamilies(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::ModifyColumnFamiliesRequest* /*request*/, ::google::bigtable::admin::v2::Table* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* ModifyColumnFamilies(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_DropRowRange : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_DropRowRange() {
      ::grpc::Service::MarkMethodRawCallback(6,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->DropRowRange(context, request, response); }));
    }
    ~WithRawCallbackMethod_DropRowRange() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DropRowRange(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::DropRowRangeRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* DropRowRange(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_GenerateConsistencyToken : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_GenerateConsistencyToken() {
      ::grpc::Service::MarkMethodRawCallback(7,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->GenerateConsistencyToken(context, request, response); }));
    }
    ~WithRawCallbackMethod_GenerateConsistencyToken() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GenerateConsistencyToken(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::GenerateConsistencyTokenRequest* /*request*/, ::google::bigtable::admin::v2::GenerateConsistencyTokenResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* GenerateConsistencyToken(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_CheckConsistency : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_CheckConsistency() {
      ::grpc::Service::MarkMethodRawCallback(8,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->CheckConsistency(context, request, response); }));
    }
    ~WithRawCallbackMethod_CheckConsistency() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CheckConsistency(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::CheckConsistencyRequest* /*request*/, ::google::bigtable::admin::v2::CheckConsistencyResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* CheckConsistency(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_SnapshotTable : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_SnapshotTable() {
      ::grpc::Service::MarkMethodRawCallback(9,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->SnapshotTable(context, request, response); }));
    }
    ~WithRawCallbackMethod_SnapshotTable() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status SnapshotTable(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::SnapshotTableRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* SnapshotTable(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_GetSnapshot : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_GetSnapshot() {
      ::grpc::Service::MarkMethodRawCallback(10,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->GetSnapshot(context, request, response); }));
    }
    ~WithRawCallbackMethod_GetSnapshot() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetSnapshot(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::GetSnapshotRequest* /*request*/, ::google::bigtable::admin::v2::Snapshot* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* GetSnapshot(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_ListSnapshots : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_ListSnapshots() {
      ::grpc::Service::MarkMethodRawCallback(11,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->ListSnapshots(context, request, response); }));
    }
    ~WithRawCallbackMethod_ListSnapshots() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListSnapshots(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::ListSnapshotsRequest* /*request*/, ::google::bigtable::admin::v2::ListSnapshotsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* ListSnapshots(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_DeleteSnapshot : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_DeleteSnapshot() {
      ::grpc::Service::MarkMethodRawCallback(12,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->DeleteSnapshot(context, request, response); }));
    }
    ~WithRawCallbackMethod_DeleteSnapshot() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteSnapshot(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::DeleteSnapshotRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* DeleteSnapshot(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_CreateBackup : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_CreateBackup() {
      ::grpc::Service::MarkMethodRawCallback(13,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->CreateBackup(context, request, response); }));
    }
    ~WithRawCallbackMethod_CreateBackup() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateBackup(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::CreateBackupRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* CreateBackup(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_GetBackup : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_GetBackup() {
      ::grpc::Service::MarkMethodRawCallback(14,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->GetBackup(context, request, response); }));
    }
    ~WithRawCallbackMethod_GetBackup() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetBackup(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::GetBackupRequest* /*request*/, ::google::bigtable::admin::v2::Backup* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* GetBackup(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_UpdateBackup : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_UpdateBackup() {
      ::grpc::Service::MarkMethodRawCallback(15,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->UpdateBackup(context, request, response); }));
    }
    ~WithRawCallbackMethod_UpdateBackup() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateBackup(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::UpdateBackupRequest* /*request*/, ::google::bigtable::admin::v2::Backup* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* UpdateBackup(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_DeleteBackup : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_DeleteBackup() {
      ::grpc::Service::MarkMethodRawCallback(16,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->DeleteBackup(context, request, response); }));
    }
    ~WithRawCallbackMethod_DeleteBackup() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteBackup(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::DeleteBackupRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* DeleteBackup(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_ListBackups : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_ListBackups() {
      ::grpc::Service::MarkMethodRawCallback(17,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->ListBackups(context, request, response); }));
    }
    ~WithRawCallbackMethod_ListBackups() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListBackups(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::ListBackupsRequest* /*request*/, ::google::bigtable::admin::v2::ListBackupsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* ListBackups(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_RestoreTable : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_RestoreTable() {
      ::grpc::Service::MarkMethodRawCallback(18,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->RestoreTable(context, request, response); }));
    }
    ~WithRawCallbackMethod_RestoreTable() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status RestoreTable(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::RestoreTableRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* RestoreTable(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_GetIamPolicy : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_GetIamPolicy() {
      ::grpc::Service::MarkMethodRawCallback(19,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->GetIamPolicy(context, request, response); }));
    }
    ~WithRawCallbackMethod_GetIamPolicy() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetIamPolicy(::grpc::ServerContext* /*context*/, const ::google::iam::v1::GetIamPolicyRequest* /*request*/, ::google::iam::v1::Policy* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* GetIamPolicy(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_SetIamPolicy : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_SetIamPolicy() {
      ::grpc::Service::MarkMethodRawCallback(20,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->SetIamPolicy(context, request, response); }));
    }
    ~WithRawCallbackMethod_SetIamPolicy() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status SetIamPolicy(::grpc::ServerContext* /*context*/, const ::google::iam::v1::SetIamPolicyRequest* /*request*/, ::google::iam::v1::Policy* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* SetIamPolicy(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_TestIamPermissions : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_TestIamPermissions() {
      ::grpc::Service::MarkMethodRawCallback(21,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->TestIamPermissions(context, request, response); }));
    }
    ~WithRawCallbackMethod_TestIamPermissions() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status TestIamPermissions(::grpc::ServerContext* /*context*/, const ::google::iam::v1::TestIamPermissionsRequest* /*request*/, ::google::iam::v1::TestIamPermissionsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* TestIamPermissions(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_CreateTable : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_CreateTable() {
      ::grpc::Service::MarkMethodStreamed(0,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::bigtable::admin::v2::CreateTableRequest, ::google::bigtable::admin::v2::Table>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::bigtable::admin::v2::CreateTableRequest, ::google::bigtable::admin::v2::Table>* streamer) {
                       return this->StreamedCreateTable(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_CreateTable() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status CreateTable(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::CreateTableRequest* /*request*/, ::google::bigtable::admin::v2::Table* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedCreateTable(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::bigtable::admin::v2::CreateTableRequest,::google::bigtable::admin::v2::Table>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_CreateTableFromSnapshot : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_CreateTableFromSnapshot() {
      ::grpc::Service::MarkMethodStreamed(1,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::bigtable::admin::v2::CreateTableFromSnapshotRequest, ::google::longrunning::Operation>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::bigtable::admin::v2::CreateTableFromSnapshotRequest, ::google::longrunning::Operation>* streamer) {
                       return this->StreamedCreateTableFromSnapshot(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_CreateTableFromSnapshot() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status CreateTableFromSnapshot(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::CreateTableFromSnapshotRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedCreateTableFromSnapshot(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::bigtable::admin::v2::CreateTableFromSnapshotRequest,::google::longrunning::Operation>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_ListTables : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_ListTables() {
      ::grpc::Service::MarkMethodStreamed(2,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::bigtable::admin::v2::ListTablesRequest, ::google::bigtable::admin::v2::ListTablesResponse>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::bigtable::admin::v2::ListTablesRequest, ::google::bigtable::admin::v2::ListTablesResponse>* streamer) {
                       return this->StreamedListTables(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_ListTables() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status ListTables(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::ListTablesRequest* /*request*/, ::google::bigtable::admin::v2::ListTablesResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedListTables(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::bigtable::admin::v2::ListTablesRequest,::google::bigtable::admin::v2::ListTablesResponse>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_GetTable : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_GetTable() {
      ::grpc::Service::MarkMethodStreamed(3,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::bigtable::admin::v2::GetTableRequest, ::google::bigtable::admin::v2::Table>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::bigtable::admin::v2::GetTableRequest, ::google::bigtable::admin::v2::Table>* streamer) {
                       return this->StreamedGetTable(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_GetTable() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status GetTable(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::GetTableRequest* /*request*/, ::google::bigtable::admin::v2::Table* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedGetTable(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::bigtable::admin::v2::GetTableRequest,::google::bigtable::admin::v2::Table>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_DeleteTable : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_DeleteTable() {
      ::grpc::Service::MarkMethodStreamed(4,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::bigtable::admin::v2::DeleteTableRequest, ::google::protobuf::Empty>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::bigtable::admin::v2::DeleteTableRequest, ::google::protobuf::Empty>* streamer) {
                       return this->StreamedDeleteTable(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_DeleteTable() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status DeleteTable(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::DeleteTableRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedDeleteTable(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::bigtable::admin::v2::DeleteTableRequest,::google::protobuf::Empty>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_ModifyColumnFamilies : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_ModifyColumnFamilies() {
      ::grpc::Service::MarkMethodStreamed(5,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::bigtable::admin::v2::ModifyColumnFamiliesRequest, ::google::bigtable::admin::v2::Table>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::bigtable::admin::v2::ModifyColumnFamiliesRequest, ::google::bigtable::admin::v2::Table>* streamer) {
                       return this->StreamedModifyColumnFamilies(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_ModifyColumnFamilies() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status ModifyColumnFamilies(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::ModifyColumnFamiliesRequest* /*request*/, ::google::bigtable::admin::v2::Table* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedModifyColumnFamilies(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::bigtable::admin::v2::ModifyColumnFamiliesRequest,::google::bigtable::admin::v2::Table>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_DropRowRange : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_DropRowRange() {
      ::grpc::Service::MarkMethodStreamed(6,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::bigtable::admin::v2::DropRowRangeRequest, ::google::protobuf::Empty>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::bigtable::admin::v2::DropRowRangeRequest, ::google::protobuf::Empty>* streamer) {
                       return this->StreamedDropRowRange(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_DropRowRange() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status DropRowRange(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::DropRowRangeRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedDropRowRange(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::bigtable::admin::v2::DropRowRangeRequest,::google::protobuf::Empty>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_GenerateConsistencyToken : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_GenerateConsistencyToken() {
      ::grpc::Service::MarkMethodStreamed(7,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::bigtable::admin::v2::GenerateConsistencyTokenRequest, ::google::bigtable::admin::v2::GenerateConsistencyTokenResponse>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::bigtable::admin::v2::GenerateConsistencyTokenRequest, ::google::bigtable::admin::v2::GenerateConsistencyTokenResponse>* streamer) {
                       return this->StreamedGenerateConsistencyToken(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_GenerateConsistencyToken() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status GenerateConsistencyToken(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::GenerateConsistencyTokenRequest* /*request*/, ::google::bigtable::admin::v2::GenerateConsistencyTokenResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedGenerateConsistencyToken(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::bigtable::admin::v2::GenerateConsistencyTokenRequest,::google::bigtable::admin::v2::GenerateConsistencyTokenResponse>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_CheckConsistency : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_CheckConsistency() {
      ::grpc::Service::MarkMethodStreamed(8,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::bigtable::admin::v2::CheckConsistencyRequest, ::google::bigtable::admin::v2::CheckConsistencyResponse>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::bigtable::admin::v2::CheckConsistencyRequest, ::google::bigtable::admin::v2::CheckConsistencyResponse>* streamer) {
                       return this->StreamedCheckConsistency(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_CheckConsistency() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status CheckConsistency(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::CheckConsistencyRequest* /*request*/, ::google::bigtable::admin::v2::CheckConsistencyResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedCheckConsistency(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::bigtable::admin::v2::CheckConsistencyRequest,::google::bigtable::admin::v2::CheckConsistencyResponse>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_SnapshotTable : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_SnapshotTable() {
      ::grpc::Service::MarkMethodStreamed(9,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::bigtable::admin::v2::SnapshotTableRequest, ::google::longrunning::Operation>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::bigtable::admin::v2::SnapshotTableRequest, ::google::longrunning::Operation>* streamer) {
                       return this->StreamedSnapshotTable(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_SnapshotTable() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status SnapshotTable(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::SnapshotTableRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedSnapshotTable(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::bigtable::admin::v2::SnapshotTableRequest,::google::longrunning::Operation>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_GetSnapshot : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_GetSnapshot() {
      ::grpc::Service::MarkMethodStreamed(10,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::bigtable::admin::v2::GetSnapshotRequest, ::google::bigtable::admin::v2::Snapshot>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::bigtable::admin::v2::GetSnapshotRequest, ::google::bigtable::admin::v2::Snapshot>* streamer) {
                       return this->StreamedGetSnapshot(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_GetSnapshot() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status GetSnapshot(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::GetSnapshotRequest* /*request*/, ::google::bigtable::admin::v2::Snapshot* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedGetSnapshot(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::bigtable::admin::v2::GetSnapshotRequest,::google::bigtable::admin::v2::Snapshot>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_ListSnapshots : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_ListSnapshots() {
      ::grpc::Service::MarkMethodStreamed(11,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::bigtable::admin::v2::ListSnapshotsRequest, ::google::bigtable::admin::v2::ListSnapshotsResponse>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::bigtable::admin::v2::ListSnapshotsRequest, ::google::bigtable::admin::v2::ListSnapshotsResponse>* streamer) {
                       return this->StreamedListSnapshots(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_ListSnapshots() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status ListSnapshots(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::ListSnapshotsRequest* /*request*/, ::google::bigtable::admin::v2::ListSnapshotsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedListSnapshots(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::bigtable::admin::v2::ListSnapshotsRequest,::google::bigtable::admin::v2::ListSnapshotsResponse>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_DeleteSnapshot : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_DeleteSnapshot() {
      ::grpc::Service::MarkMethodStreamed(12,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::bigtable::admin::v2::DeleteSnapshotRequest, ::google::protobuf::Empty>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::bigtable::admin::v2::DeleteSnapshotRequest, ::google::protobuf::Empty>* streamer) {
                       return this->StreamedDeleteSnapshot(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_DeleteSnapshot() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status DeleteSnapshot(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::DeleteSnapshotRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedDeleteSnapshot(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::bigtable::admin::v2::DeleteSnapshotRequest,::google::protobuf::Empty>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_CreateBackup : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_CreateBackup() {
      ::grpc::Service::MarkMethodStreamed(13,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::bigtable::admin::v2::CreateBackupRequest, ::google::longrunning::Operation>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::bigtable::admin::v2::CreateBackupRequest, ::google::longrunning::Operation>* streamer) {
                       return this->StreamedCreateBackup(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_CreateBackup() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status CreateBackup(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::CreateBackupRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedCreateBackup(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::bigtable::admin::v2::CreateBackupRequest,::google::longrunning::Operation>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_GetBackup : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_GetBackup() {
      ::grpc::Service::MarkMethodStreamed(14,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::bigtable::admin::v2::GetBackupRequest, ::google::bigtable::admin::v2::Backup>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::bigtable::admin::v2::GetBackupRequest, ::google::bigtable::admin::v2::Backup>* streamer) {
                       return this->StreamedGetBackup(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_GetBackup() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status GetBackup(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::GetBackupRequest* /*request*/, ::google::bigtable::admin::v2::Backup* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedGetBackup(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::bigtable::admin::v2::GetBackupRequest,::google::bigtable::admin::v2::Backup>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_UpdateBackup : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_UpdateBackup() {
      ::grpc::Service::MarkMethodStreamed(15,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::bigtable::admin::v2::UpdateBackupRequest, ::google::bigtable::admin::v2::Backup>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::bigtable::admin::v2::UpdateBackupRequest, ::google::bigtable::admin::v2::Backup>* streamer) {
                       return this->StreamedUpdateBackup(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_UpdateBackup() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status UpdateBackup(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::UpdateBackupRequest* /*request*/, ::google::bigtable::admin::v2::Backup* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedUpdateBackup(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::bigtable::admin::v2::UpdateBackupRequest,::google::bigtable::admin::v2::Backup>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_DeleteBackup : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_DeleteBackup() {
      ::grpc::Service::MarkMethodStreamed(16,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::bigtable::admin::v2::DeleteBackupRequest, ::google::protobuf::Empty>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::bigtable::admin::v2::DeleteBackupRequest, ::google::protobuf::Empty>* streamer) {
                       return this->StreamedDeleteBackup(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_DeleteBackup() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status DeleteBackup(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::DeleteBackupRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedDeleteBackup(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::bigtable::admin::v2::DeleteBackupRequest,::google::protobuf::Empty>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_ListBackups : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_ListBackups() {
      ::grpc::Service::MarkMethodStreamed(17,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::bigtable::admin::v2::ListBackupsRequest, ::google::bigtable::admin::v2::ListBackupsResponse>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::bigtable::admin::v2::ListBackupsRequest, ::google::bigtable::admin::v2::ListBackupsResponse>* streamer) {
                       return this->StreamedListBackups(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_ListBackups() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status ListBackups(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::ListBackupsRequest* /*request*/, ::google::bigtable::admin::v2::ListBackupsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedListBackups(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::bigtable::admin::v2::ListBackupsRequest,::google::bigtable::admin::v2::ListBackupsResponse>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_RestoreTable : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_RestoreTable() {
      ::grpc::Service::MarkMethodStreamed(18,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::bigtable::admin::v2::RestoreTableRequest, ::google::longrunning::Operation>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::bigtable::admin::v2::RestoreTableRequest, ::google::longrunning::Operation>* streamer) {
                       return this->StreamedRestoreTable(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_RestoreTable() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status RestoreTable(::grpc::ServerContext* /*context*/, const ::google::bigtable::admin::v2::RestoreTableRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedRestoreTable(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::bigtable::admin::v2::RestoreTableRequest,::google::longrunning::Operation>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_GetIamPolicy : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_GetIamPolicy() {
      ::grpc::Service::MarkMethodStreamed(19,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::iam::v1::GetIamPolicyRequest, ::google::iam::v1::Policy>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::iam::v1::GetIamPolicyRequest, ::google::iam::v1::Policy>* streamer) {
                       return this->StreamedGetIamPolicy(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_GetIamPolicy() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status GetIamPolicy(::grpc::ServerContext* /*context*/, const ::google::iam::v1::GetIamPolicyRequest* /*request*/, ::google::iam::v1::Policy* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedGetIamPolicy(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::iam::v1::GetIamPolicyRequest,::google::iam::v1::Policy>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_SetIamPolicy : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_SetIamPolicy() {
      ::grpc::Service::MarkMethodStreamed(20,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::iam::v1::SetIamPolicyRequest, ::google::iam::v1::Policy>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::iam::v1::SetIamPolicyRequest, ::google::iam::v1::Policy>* streamer) {
                       return this->StreamedSetIamPolicy(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_SetIamPolicy() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status SetIamPolicy(::grpc::ServerContext* /*context*/, const ::google::iam::v1::SetIamPolicyRequest* /*request*/, ::google::iam::v1::Policy* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedSetIamPolicy(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::iam::v1::SetIamPolicyRequest,::google::iam::v1::Policy>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_TestIamPermissions : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_TestIamPermissions() {
      ::grpc::Service::MarkMethodStreamed(21,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::iam::v1::TestIamPermissionsRequest, ::google::iam::v1::TestIamPermissionsResponse>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::iam::v1::TestIamPermissionsRequest, ::google::iam::v1::TestIamPermissionsResponse>* streamer) {
                       return this->StreamedTestIamPermissions(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_TestIamPermissions() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status TestIamPermissions(::grpc::ServerContext* /*context*/, const ::google::iam::v1::TestIamPermissionsRequest* /*request*/, ::google::iam::v1::TestIamPermissionsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedTestIamPermissions(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::iam::v1::TestIamPermissionsRequest,::google::iam::v1::TestIamPermissionsResponse>* server_unary_streamer) = 0;
  };
  typedef WithStreamedUnaryMethod_CreateTable<WithStreamedUnaryMethod_CreateTableFromSnapshot<WithStreamedUnaryMethod_ListTables<WithStreamedUnaryMethod_GetTable<WithStreamedUnaryMethod_DeleteTable<WithStreamedUnaryMethod_ModifyColumnFamilies<WithStreamedUnaryMethod_DropRowRange<WithStreamedUnaryMethod_GenerateConsistencyToken<WithStreamedUnaryMethod_CheckConsistency<WithStreamedUnaryMethod_SnapshotTable<WithStreamedUnaryMethod_GetSnapshot<WithStreamedUnaryMethod_ListSnapshots<WithStreamedUnaryMethod_DeleteSnapshot<WithStreamedUnaryMethod_CreateBackup<WithStreamedUnaryMethod_GetBackup<WithStreamedUnaryMethod_UpdateBackup<WithStreamedUnaryMethod_DeleteBackup<WithStreamedUnaryMethod_ListBackups<WithStreamedUnaryMethod_RestoreTable<WithStreamedUnaryMethod_GetIamPolicy<WithStreamedUnaryMethod_SetIamPolicy<WithStreamedUnaryMethod_TestIamPermissions<Service > > > > > > > > > > > > > > > > > > > > > > StreamedUnaryService;
  typedef Service SplitStreamedService;
  typedef WithStreamedUnaryMethod_CreateTable<WithStreamedUnaryMethod_CreateTableFromSnapshot<WithStreamedUnaryMethod_ListTables<WithStreamedUnaryMethod_GetTable<WithStreamedUnaryMethod_DeleteTable<WithStreamedUnaryMethod_ModifyColumnFamilies<WithStreamedUnaryMethod_DropRowRange<WithStreamedUnaryMethod_GenerateConsistencyToken<WithStreamedUnaryMethod_CheckConsistency<WithStreamedUnaryMethod_SnapshotTable<WithStreamedUnaryMethod_GetSnapshot<WithStreamedUnaryMethod_ListSnapshots<WithStreamedUnaryMethod_DeleteSnapshot<WithStreamedUnaryMethod_CreateBackup<WithStreamedUnaryMethod_GetBackup<WithStreamedUnaryMethod_UpdateBackup<WithStreamedUnaryMethod_DeleteBackup<WithStreamedUnaryMethod_ListBackups<WithStreamedUnaryMethod_RestoreTable<WithStreamedUnaryMethod_GetIamPolicy<WithStreamedUnaryMethod_SetIamPolicy<WithStreamedUnaryMethod_TestIamPermissions<Service > > > > > > > > > > > > > > > > > > > > > > StreamedService;
};

}  // namespace v2
}  // namespace admin
}  // namespace bigtable
}  // namespace google


#endif  // GRPC_google_2fbigtable_2fadmin_2fv2_2fbigtable_5ftable_5fadmin_2eproto__INCLUDED
