// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/bigquery/v2/model.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BIGQUERY_INTERNAL_MODEL_STUB_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BIGQUERY_INTERNAL_MODEL_STUB_H

#include "google/cloud/status_or.h"
#include "google/cloud/version.h"
#include <google/cloud/bigquery/v2/model.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace bigquery_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

class ModelServiceStub {
 public:
  virtual ~ModelServiceStub() = 0;

  virtual StatusOr<google::cloud::bigquery::v2::Model> GetModel(
      grpc::ClientContext& context,
      google::cloud::bigquery::v2::GetModelRequest const& request) = 0;

  virtual StatusOr<google::cloud::bigquery::v2::ListModelsResponse> ListModels(
      grpc::ClientContext& context,
      google::cloud::bigquery::v2::ListModelsRequest const& request) = 0;

  virtual StatusOr<google::cloud::bigquery::v2::Model> PatchModel(
      grpc::ClientContext& context,
      google::cloud::bigquery::v2::PatchModelRequest const& request) = 0;

  virtual Status DeleteModel(
      grpc::ClientContext& context,
      google::cloud::bigquery::v2::DeleteModelRequest const& request) = 0;
};

class DefaultModelServiceStub : public ModelServiceStub {
 public:
  explicit DefaultModelServiceStub(
      std::unique_ptr<google::cloud::bigquery::v2::ModelService::StubInterface>
          grpc_stub)
      : grpc_stub_(std::move(grpc_stub)) {}

  StatusOr<google::cloud::bigquery::v2::Model> GetModel(
      grpc::ClientContext& client_context,
      google::cloud::bigquery::v2::GetModelRequest const& request) override;

  StatusOr<google::cloud::bigquery::v2::ListModelsResponse> ListModels(
      grpc::ClientContext& client_context,
      google::cloud::bigquery::v2::ListModelsRequest const& request) override;

  StatusOr<google::cloud::bigquery::v2::Model> PatchModel(
      grpc::ClientContext& client_context,
      google::cloud::bigquery::v2::PatchModelRequest const& request) override;

  Status DeleteModel(
      grpc::ClientContext& client_context,
      google::cloud::bigquery::v2::DeleteModelRequest const& request) override;

 private:
  std::unique_ptr<google::cloud::bigquery::v2::ModelService::StubInterface>
      grpc_stub_;
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace bigquery_internal
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BIGQUERY_INTERNAL_MODEL_STUB_H
