# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

include(CMakeFindDependencyMacro)
find_dependency(google_cloud_cpp_storage)

foreach (target storage_client)
    if (TARGET ${target})
        continue ()
    endif ()
    add_library(${target} IMPORTED INTERFACE)
    set_target_properties(${target} PROPERTIES
        INTERFACE_LINK_LIBRARIES "google-cloud-cpp::storage")
    if (CMAKE_VERSION VERSION_GREATER 3.17)
        set_target_properties(${target} PROPERTIES
            DEPRECATION
            "This target will be removed on or about 2022-02-15, please use google-cloud-cpp::storage instead")
    endif ()
endforeach ()
