// Generated by the gRPC C++ plugin.
// If you make any local change, they will be lost.
// source: google/spanner/admin/database/v1/spanner_database_admin.proto
// Original file comments:
// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
#ifndef GRPC_google_2fspanner_2fadmin_2fdatabase_2fv1_2fspanner_5fdatabase_5fadmin_2eproto__INCLUDED
#define GRPC_google_2fspanner_2fadmin_2fdatabase_2fv1_2fspanner_5fdatabase_5fadmin_2eproto__INCLUDED

#include "google/spanner/admin/database/v1/spanner_database_admin.pb.h"

#include <functional>
#include <grpcpp/impl/codegen/async_generic_service.h>
#include <grpcpp/impl/codegen/async_stream.h>
#include <grpcpp/impl/codegen/async_unary_call.h>
#include <grpcpp/impl/codegen/client_callback.h>
#include <grpcpp/impl/codegen/client_context.h>
#include <grpcpp/impl/codegen/completion_queue.h>
#include <grpcpp/impl/codegen/message_allocator.h>
#include <grpcpp/impl/codegen/method_handler.h>
#include <grpcpp/impl/codegen/proto_utils.h>
#include <grpcpp/impl/codegen/rpc_method.h>
#include <grpcpp/impl/codegen/server_callback.h>
#include <grpcpp/impl/codegen/server_callback_handlers.h>
#include <grpcpp/impl/codegen/server_context.h>
#include <grpcpp/impl/codegen/service_type.h>
#include <grpcpp/impl/codegen/status.h>
#include <grpcpp/impl/codegen/stub_options.h>
#include <grpcpp/impl/codegen/sync_stream.h>

namespace google {
namespace spanner {
namespace admin {
namespace database {
namespace v1 {

// Cloud Spanner Database Admin API
//
// The Cloud Spanner Database Admin API can be used to:
//   * create, drop, and list databases
//   * update the schema of pre-existing databases
//   * create, delete and list backups for a database
//   * restore a database from an existing backup
class DatabaseAdmin final {
 public:
  static constexpr char const* service_full_name() {
    return "google.spanner.admin.database.v1.DatabaseAdmin";
  }
  class StubInterface {
   public:
    virtual ~StubInterface() {}
    // Lists Cloud Spanner databases.
    virtual ::grpc::Status ListDatabases(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::ListDatabasesRequest& request, ::google::spanner::admin::database::v1::ListDatabasesResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::admin::database::v1::ListDatabasesResponse>> AsyncListDatabases(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::ListDatabasesRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::admin::database::v1::ListDatabasesResponse>>(AsyncListDatabasesRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::admin::database::v1::ListDatabasesResponse>> PrepareAsyncListDatabases(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::ListDatabasesRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::admin::database::v1::ListDatabasesResponse>>(PrepareAsyncListDatabasesRaw(context, request, cq));
    }
    // Creates a new Cloud Spanner database and starts to prepare it for serving.
    // The returned [long-running operation][google.longrunning.Operation] will
    // have a name of the format `<database_name>/operations/<operation_id>` and
    // can be used to track preparation of the database. The
    // [metadata][google.longrunning.Operation.metadata] field type is
    // [CreateDatabaseMetadata][google.spanner.admin.database.v1.CreateDatabaseMetadata]. The
    // [response][google.longrunning.Operation.response] field type is
    // [Database][google.spanner.admin.database.v1.Database], if successful.
    virtual ::grpc::Status CreateDatabase(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::CreateDatabaseRequest& request, ::google::longrunning::Operation* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>> AsyncCreateDatabase(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::CreateDatabaseRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>>(AsyncCreateDatabaseRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>> PrepareAsyncCreateDatabase(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::CreateDatabaseRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>>(PrepareAsyncCreateDatabaseRaw(context, request, cq));
    }
    // Gets the state of a Cloud Spanner database.
    virtual ::grpc::Status GetDatabase(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::GetDatabaseRequest& request, ::google::spanner::admin::database::v1::Database* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::admin::database::v1::Database>> AsyncGetDatabase(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::GetDatabaseRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::admin::database::v1::Database>>(AsyncGetDatabaseRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::admin::database::v1::Database>> PrepareAsyncGetDatabase(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::GetDatabaseRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::admin::database::v1::Database>>(PrepareAsyncGetDatabaseRaw(context, request, cq));
    }
    // Updates the schema of a Cloud Spanner database by
    // creating/altering/dropping tables, columns, indexes, etc. The returned
    // [long-running operation][google.longrunning.Operation] will have a name of
    // the format `<database_name>/operations/<operation_id>` and can be used to
    // track execution of the schema change(s). The
    // [metadata][google.longrunning.Operation.metadata] field type is
    // [UpdateDatabaseDdlMetadata][google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata].  The operation has no response.
    virtual ::grpc::Status UpdateDatabaseDdl(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::UpdateDatabaseDdlRequest& request, ::google::longrunning::Operation* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>> AsyncUpdateDatabaseDdl(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::UpdateDatabaseDdlRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>>(AsyncUpdateDatabaseDdlRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>> PrepareAsyncUpdateDatabaseDdl(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::UpdateDatabaseDdlRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>>(PrepareAsyncUpdateDatabaseDdlRaw(context, request, cq));
    }
    // Drops (aka deletes) a Cloud Spanner database.
    // Completed backups for the database will be retained according to their
    // `expire_time`.
    // Note: Cloud Spanner might continue to accept requests for a few seconds
    // after the database has been deleted.
    virtual ::grpc::Status DropDatabase(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::DropDatabaseRequest& request, ::google::protobuf::Empty* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>> AsyncDropDatabase(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::DropDatabaseRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>>(AsyncDropDatabaseRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>> PrepareAsyncDropDatabase(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::DropDatabaseRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>>(PrepareAsyncDropDatabaseRaw(context, request, cq));
    }
    // Returns the schema of a Cloud Spanner database as a list of formatted
    // DDL statements. This method does not show pending schema updates, those may
    // be queried using the [Operations][google.longrunning.Operations] API.
    virtual ::grpc::Status GetDatabaseDdl(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::GetDatabaseDdlRequest& request, ::google::spanner::admin::database::v1::GetDatabaseDdlResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::admin::database::v1::GetDatabaseDdlResponse>> AsyncGetDatabaseDdl(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::GetDatabaseDdlRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::admin::database::v1::GetDatabaseDdlResponse>>(AsyncGetDatabaseDdlRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::admin::database::v1::GetDatabaseDdlResponse>> PrepareAsyncGetDatabaseDdl(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::GetDatabaseDdlRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::admin::database::v1::GetDatabaseDdlResponse>>(PrepareAsyncGetDatabaseDdlRaw(context, request, cq));
    }
    // Sets the access control policy on a database or backup resource.
    // Replaces any existing policy.
    //
    // Authorization requires `spanner.databases.setIamPolicy`
    // permission on [resource][google.iam.v1.SetIamPolicyRequest.resource].
    // For backups, authorization requires `spanner.backups.setIamPolicy`
    // permission on [resource][google.iam.v1.SetIamPolicyRequest.resource].
    virtual ::grpc::Status SetIamPolicy(::grpc::ClientContext* context, const ::google::iam::v1::SetIamPolicyRequest& request, ::google::iam::v1::Policy* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::v1::Policy>> AsyncSetIamPolicy(::grpc::ClientContext* context, const ::google::iam::v1::SetIamPolicyRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::v1::Policy>>(AsyncSetIamPolicyRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::v1::Policy>> PrepareAsyncSetIamPolicy(::grpc::ClientContext* context, const ::google::iam::v1::SetIamPolicyRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::v1::Policy>>(PrepareAsyncSetIamPolicyRaw(context, request, cq));
    }
    // Gets the access control policy for a database or backup resource.
    // Returns an empty policy if a database or backup exists but does not have a
    // policy set.
    //
    // Authorization requires `spanner.databases.getIamPolicy` permission on
    // [resource][google.iam.v1.GetIamPolicyRequest.resource].
    // For backups, authorization requires `spanner.backups.getIamPolicy`
    // permission on [resource][google.iam.v1.GetIamPolicyRequest.resource].
    virtual ::grpc::Status GetIamPolicy(::grpc::ClientContext* context, const ::google::iam::v1::GetIamPolicyRequest& request, ::google::iam::v1::Policy* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::v1::Policy>> AsyncGetIamPolicy(::grpc::ClientContext* context, const ::google::iam::v1::GetIamPolicyRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::v1::Policy>>(AsyncGetIamPolicyRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::v1::Policy>> PrepareAsyncGetIamPolicy(::grpc::ClientContext* context, const ::google::iam::v1::GetIamPolicyRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::v1::Policy>>(PrepareAsyncGetIamPolicyRaw(context, request, cq));
    }
    // Returns permissions that the caller has on the specified database or backup
    // resource.
    //
    // Attempting this RPC on a non-existent Cloud Spanner database will
    // result in a NOT_FOUND error if the user has
    // `spanner.databases.list` permission on the containing Cloud
    // Spanner instance. Otherwise returns an empty set of permissions.
    // Calling this method on a backup that does not exist will
    // result in a NOT_FOUND error if the user has
    // `spanner.backups.list` permission on the containing instance.
    virtual ::grpc::Status TestIamPermissions(::grpc::ClientContext* context, const ::google::iam::v1::TestIamPermissionsRequest& request, ::google::iam::v1::TestIamPermissionsResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::v1::TestIamPermissionsResponse>> AsyncTestIamPermissions(::grpc::ClientContext* context, const ::google::iam::v1::TestIamPermissionsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::v1::TestIamPermissionsResponse>>(AsyncTestIamPermissionsRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::v1::TestIamPermissionsResponse>> PrepareAsyncTestIamPermissions(::grpc::ClientContext* context, const ::google::iam::v1::TestIamPermissionsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::v1::TestIamPermissionsResponse>>(PrepareAsyncTestIamPermissionsRaw(context, request, cq));
    }
    // Starts creating a new Cloud Spanner Backup.
    // The returned backup [long-running operation][google.longrunning.Operation]
    // will have a name of the format
    // `projects/<project>/instances/<instance>/backups/<backup>/operations/<operation_id>`
    // and can be used to track creation of the backup. The
    // [metadata][google.longrunning.Operation.metadata] field type is
    // [CreateBackupMetadata][google.spanner.admin.database.v1.CreateBackupMetadata]. The
    // [response][google.longrunning.Operation.response] field type is
    // [Backup][google.spanner.admin.database.v1.Backup], if successful. Cancelling the returned operation will stop the
    // creation and delete the backup.
    // There can be only one pending backup creation per database. Backup creation
    // of different databases can run concurrently.
    virtual ::grpc::Status CreateBackup(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::CreateBackupRequest& request, ::google::longrunning::Operation* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>> AsyncCreateBackup(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::CreateBackupRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>>(AsyncCreateBackupRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>> PrepareAsyncCreateBackup(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::CreateBackupRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>>(PrepareAsyncCreateBackupRaw(context, request, cq));
    }
    // Gets metadata on a pending or completed [Backup][google.spanner.admin.database.v1.Backup].
    virtual ::grpc::Status GetBackup(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::GetBackupRequest& request, ::google::spanner::admin::database::v1::Backup* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::admin::database::v1::Backup>> AsyncGetBackup(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::GetBackupRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::admin::database::v1::Backup>>(AsyncGetBackupRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::admin::database::v1::Backup>> PrepareAsyncGetBackup(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::GetBackupRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::admin::database::v1::Backup>>(PrepareAsyncGetBackupRaw(context, request, cq));
    }
    // Updates a pending or completed [Backup][google.spanner.admin.database.v1.Backup].
    virtual ::grpc::Status UpdateBackup(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::UpdateBackupRequest& request, ::google::spanner::admin::database::v1::Backup* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::admin::database::v1::Backup>> AsyncUpdateBackup(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::UpdateBackupRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::admin::database::v1::Backup>>(AsyncUpdateBackupRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::admin::database::v1::Backup>> PrepareAsyncUpdateBackup(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::UpdateBackupRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::admin::database::v1::Backup>>(PrepareAsyncUpdateBackupRaw(context, request, cq));
    }
    // Deletes a pending or completed [Backup][google.spanner.admin.database.v1.Backup].
    virtual ::grpc::Status DeleteBackup(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::DeleteBackupRequest& request, ::google::protobuf::Empty* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>> AsyncDeleteBackup(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::DeleteBackupRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>>(AsyncDeleteBackupRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>> PrepareAsyncDeleteBackup(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::DeleteBackupRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>>(PrepareAsyncDeleteBackupRaw(context, request, cq));
    }
    // Lists completed and pending backups.
    // Backups returned are ordered by `create_time` in descending order,
    // starting from the most recent `create_time`.
    virtual ::grpc::Status ListBackups(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::ListBackupsRequest& request, ::google::spanner::admin::database::v1::ListBackupsResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::admin::database::v1::ListBackupsResponse>> AsyncListBackups(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::ListBackupsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::admin::database::v1::ListBackupsResponse>>(AsyncListBackupsRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::admin::database::v1::ListBackupsResponse>> PrepareAsyncListBackups(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::ListBackupsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::admin::database::v1::ListBackupsResponse>>(PrepareAsyncListBackupsRaw(context, request, cq));
    }
    // Create a new database by restoring from a completed backup. The new
    // database must be in the same project and in an instance with the same
    // instance configuration as the instance containing
    // the backup. The returned database [long-running
    // operation][google.longrunning.Operation] has a name of the format
    // `projects/<project>/instances/<instance>/databases/<database>/operations/<operation_id>`,
    // and can be used to track the progress of the operation, and to cancel it.
    // The [metadata][google.longrunning.Operation.metadata] field type is
    // [RestoreDatabaseMetadata][google.spanner.admin.database.v1.RestoreDatabaseMetadata].
    // The [response][google.longrunning.Operation.response] type
    // is [Database][google.spanner.admin.database.v1.Database], if
    // successful. Cancelling the returned operation will stop the restore and
    // delete the database.
    // There can be only one database being restored into an instance at a time.
    // Once the restore operation completes, a new restore operation can be
    // initiated, without waiting for the optimize operation associated with the
    // first restore to complete.
    virtual ::grpc::Status RestoreDatabase(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::RestoreDatabaseRequest& request, ::google::longrunning::Operation* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>> AsyncRestoreDatabase(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::RestoreDatabaseRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>>(AsyncRestoreDatabaseRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>> PrepareAsyncRestoreDatabase(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::RestoreDatabaseRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>>(PrepareAsyncRestoreDatabaseRaw(context, request, cq));
    }
    // Lists database [longrunning-operations][google.longrunning.Operation].
    // A database operation has a name of the form
    // `projects/<project>/instances/<instance>/databases/<database>/operations/<operation>`.
    // The long-running operation
    // [metadata][google.longrunning.Operation.metadata] field type
    // `metadata.type_url` describes the type of the metadata. Operations returned
    // include those that have completed/failed/canceled within the last 7 days,
    // and pending operations.
    virtual ::grpc::Status ListDatabaseOperations(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::ListDatabaseOperationsRequest& request, ::google::spanner::admin::database::v1::ListDatabaseOperationsResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::admin::database::v1::ListDatabaseOperationsResponse>> AsyncListDatabaseOperations(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::ListDatabaseOperationsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::admin::database::v1::ListDatabaseOperationsResponse>>(AsyncListDatabaseOperationsRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::admin::database::v1::ListDatabaseOperationsResponse>> PrepareAsyncListDatabaseOperations(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::ListDatabaseOperationsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::admin::database::v1::ListDatabaseOperationsResponse>>(PrepareAsyncListDatabaseOperationsRaw(context, request, cq));
    }
    // Lists the backup [long-running operations][google.longrunning.Operation] in
    // the given instance. A backup operation has a name of the form
    // `projects/<project>/instances/<instance>/backups/<backup>/operations/<operation>`.
    // The long-running operation
    // [metadata][google.longrunning.Operation.metadata] field type
    // `metadata.type_url` describes the type of the metadata. Operations returned
    // include those that have completed/failed/canceled within the last 7 days,
    // and pending operations. Operations returned are ordered by
    // `operation.metadata.value.progress.start_time` in descending order starting
    // from the most recently started operation.
    virtual ::grpc::Status ListBackupOperations(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::ListBackupOperationsRequest& request, ::google::spanner::admin::database::v1::ListBackupOperationsResponse* response) = 0;
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::admin::database::v1::ListBackupOperationsResponse>> AsyncListBackupOperations(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::ListBackupOperationsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::admin::database::v1::ListBackupOperationsResponse>>(AsyncListBackupOperationsRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::admin::database::v1::ListBackupOperationsResponse>> PrepareAsyncListBackupOperations(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::ListBackupOperationsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::admin::database::v1::ListBackupOperationsResponse>>(PrepareAsyncListBackupOperationsRaw(context, request, cq));
    }
    class async_interface {
     public:
      virtual ~async_interface() {}
      // Lists Cloud Spanner databases.
      virtual void ListDatabases(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::ListDatabasesRequest* request, ::google::spanner::admin::database::v1::ListDatabasesResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void ListDatabases(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::ListDatabasesRequest* request, ::google::spanner::admin::database::v1::ListDatabasesResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Creates a new Cloud Spanner database and starts to prepare it for serving.
      // The returned [long-running operation][google.longrunning.Operation] will
      // have a name of the format `<database_name>/operations/<operation_id>` and
      // can be used to track preparation of the database. The
      // [metadata][google.longrunning.Operation.metadata] field type is
      // [CreateDatabaseMetadata][google.spanner.admin.database.v1.CreateDatabaseMetadata]. The
      // [response][google.longrunning.Operation.response] field type is
      // [Database][google.spanner.admin.database.v1.Database], if successful.
      virtual void CreateDatabase(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::CreateDatabaseRequest* request, ::google::longrunning::Operation* response, std::function<void(::grpc::Status)>) = 0;
      virtual void CreateDatabase(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::CreateDatabaseRequest* request, ::google::longrunning::Operation* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Gets the state of a Cloud Spanner database.
      virtual void GetDatabase(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::GetDatabaseRequest* request, ::google::spanner::admin::database::v1::Database* response, std::function<void(::grpc::Status)>) = 0;
      virtual void GetDatabase(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::GetDatabaseRequest* request, ::google::spanner::admin::database::v1::Database* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Updates the schema of a Cloud Spanner database by
      // creating/altering/dropping tables, columns, indexes, etc. The returned
      // [long-running operation][google.longrunning.Operation] will have a name of
      // the format `<database_name>/operations/<operation_id>` and can be used to
      // track execution of the schema change(s). The
      // [metadata][google.longrunning.Operation.metadata] field type is
      // [UpdateDatabaseDdlMetadata][google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata].  The operation has no response.
      virtual void UpdateDatabaseDdl(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::UpdateDatabaseDdlRequest* request, ::google::longrunning::Operation* response, std::function<void(::grpc::Status)>) = 0;
      virtual void UpdateDatabaseDdl(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::UpdateDatabaseDdlRequest* request, ::google::longrunning::Operation* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Drops (aka deletes) a Cloud Spanner database.
      // Completed backups for the database will be retained according to their
      // `expire_time`.
      // Note: Cloud Spanner might continue to accept requests for a few seconds
      // after the database has been deleted.
      virtual void DropDatabase(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::DropDatabaseRequest* request, ::google::protobuf::Empty* response, std::function<void(::grpc::Status)>) = 0;
      virtual void DropDatabase(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::DropDatabaseRequest* request, ::google::protobuf::Empty* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Returns the schema of a Cloud Spanner database as a list of formatted
      // DDL statements. This method does not show pending schema updates, those may
      // be queried using the [Operations][google.longrunning.Operations] API.
      virtual void GetDatabaseDdl(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::GetDatabaseDdlRequest* request, ::google::spanner::admin::database::v1::GetDatabaseDdlResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void GetDatabaseDdl(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::GetDatabaseDdlRequest* request, ::google::spanner::admin::database::v1::GetDatabaseDdlResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Sets the access control policy on a database or backup resource.
      // Replaces any existing policy.
      //
      // Authorization requires `spanner.databases.setIamPolicy`
      // permission on [resource][google.iam.v1.SetIamPolicyRequest.resource].
      // For backups, authorization requires `spanner.backups.setIamPolicy`
      // permission on [resource][google.iam.v1.SetIamPolicyRequest.resource].
      virtual void SetIamPolicy(::grpc::ClientContext* context, const ::google::iam::v1::SetIamPolicyRequest* request, ::google::iam::v1::Policy* response, std::function<void(::grpc::Status)>) = 0;
      virtual void SetIamPolicy(::grpc::ClientContext* context, const ::google::iam::v1::SetIamPolicyRequest* request, ::google::iam::v1::Policy* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Gets the access control policy for a database or backup resource.
      // Returns an empty policy if a database or backup exists but does not have a
      // policy set.
      //
      // Authorization requires `spanner.databases.getIamPolicy` permission on
      // [resource][google.iam.v1.GetIamPolicyRequest.resource].
      // For backups, authorization requires `spanner.backups.getIamPolicy`
      // permission on [resource][google.iam.v1.GetIamPolicyRequest.resource].
      virtual void GetIamPolicy(::grpc::ClientContext* context, const ::google::iam::v1::GetIamPolicyRequest* request, ::google::iam::v1::Policy* response, std::function<void(::grpc::Status)>) = 0;
      virtual void GetIamPolicy(::grpc::ClientContext* context, const ::google::iam::v1::GetIamPolicyRequest* request, ::google::iam::v1::Policy* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Returns permissions that the caller has on the specified database or backup
      // resource.
      //
      // Attempting this RPC on a non-existent Cloud Spanner database will
      // result in a NOT_FOUND error if the user has
      // `spanner.databases.list` permission on the containing Cloud
      // Spanner instance. Otherwise returns an empty set of permissions.
      // Calling this method on a backup that does not exist will
      // result in a NOT_FOUND error if the user has
      // `spanner.backups.list` permission on the containing instance.
      virtual void TestIamPermissions(::grpc::ClientContext* context, const ::google::iam::v1::TestIamPermissionsRequest* request, ::google::iam::v1::TestIamPermissionsResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void TestIamPermissions(::grpc::ClientContext* context, const ::google::iam::v1::TestIamPermissionsRequest* request, ::google::iam::v1::TestIamPermissionsResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Starts creating a new Cloud Spanner Backup.
      // The returned backup [long-running operation][google.longrunning.Operation]
      // will have a name of the format
      // `projects/<project>/instances/<instance>/backups/<backup>/operations/<operation_id>`
      // and can be used to track creation of the backup. The
      // [metadata][google.longrunning.Operation.metadata] field type is
      // [CreateBackupMetadata][google.spanner.admin.database.v1.CreateBackupMetadata]. The
      // [response][google.longrunning.Operation.response] field type is
      // [Backup][google.spanner.admin.database.v1.Backup], if successful. Cancelling the returned operation will stop the
      // creation and delete the backup.
      // There can be only one pending backup creation per database. Backup creation
      // of different databases can run concurrently.
      virtual void CreateBackup(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::CreateBackupRequest* request, ::google::longrunning::Operation* response, std::function<void(::grpc::Status)>) = 0;
      virtual void CreateBackup(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::CreateBackupRequest* request, ::google::longrunning::Operation* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Gets metadata on a pending or completed [Backup][google.spanner.admin.database.v1.Backup].
      virtual void GetBackup(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::GetBackupRequest* request, ::google::spanner::admin::database::v1::Backup* response, std::function<void(::grpc::Status)>) = 0;
      virtual void GetBackup(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::GetBackupRequest* request, ::google::spanner::admin::database::v1::Backup* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Updates a pending or completed [Backup][google.spanner.admin.database.v1.Backup].
      virtual void UpdateBackup(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::UpdateBackupRequest* request, ::google::spanner::admin::database::v1::Backup* response, std::function<void(::grpc::Status)>) = 0;
      virtual void UpdateBackup(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::UpdateBackupRequest* request, ::google::spanner::admin::database::v1::Backup* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Deletes a pending or completed [Backup][google.spanner.admin.database.v1.Backup].
      virtual void DeleteBackup(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::DeleteBackupRequest* request, ::google::protobuf::Empty* response, std::function<void(::grpc::Status)>) = 0;
      virtual void DeleteBackup(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::DeleteBackupRequest* request, ::google::protobuf::Empty* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Lists completed and pending backups.
      // Backups returned are ordered by `create_time` in descending order,
      // starting from the most recent `create_time`.
      virtual void ListBackups(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::ListBackupsRequest* request, ::google::spanner::admin::database::v1::ListBackupsResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void ListBackups(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::ListBackupsRequest* request, ::google::spanner::admin::database::v1::ListBackupsResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Create a new database by restoring from a completed backup. The new
      // database must be in the same project and in an instance with the same
      // instance configuration as the instance containing
      // the backup. The returned database [long-running
      // operation][google.longrunning.Operation] has a name of the format
      // `projects/<project>/instances/<instance>/databases/<database>/operations/<operation_id>`,
      // and can be used to track the progress of the operation, and to cancel it.
      // The [metadata][google.longrunning.Operation.metadata] field type is
      // [RestoreDatabaseMetadata][google.spanner.admin.database.v1.RestoreDatabaseMetadata].
      // The [response][google.longrunning.Operation.response] type
      // is [Database][google.spanner.admin.database.v1.Database], if
      // successful. Cancelling the returned operation will stop the restore and
      // delete the database.
      // There can be only one database being restored into an instance at a time.
      // Once the restore operation completes, a new restore operation can be
      // initiated, without waiting for the optimize operation associated with the
      // first restore to complete.
      virtual void RestoreDatabase(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::RestoreDatabaseRequest* request, ::google::longrunning::Operation* response, std::function<void(::grpc::Status)>) = 0;
      virtual void RestoreDatabase(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::RestoreDatabaseRequest* request, ::google::longrunning::Operation* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Lists database [longrunning-operations][google.longrunning.Operation].
      // A database operation has a name of the form
      // `projects/<project>/instances/<instance>/databases/<database>/operations/<operation>`.
      // The long-running operation
      // [metadata][google.longrunning.Operation.metadata] field type
      // `metadata.type_url` describes the type of the metadata. Operations returned
      // include those that have completed/failed/canceled within the last 7 days,
      // and pending operations.
      virtual void ListDatabaseOperations(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::ListDatabaseOperationsRequest* request, ::google::spanner::admin::database::v1::ListDatabaseOperationsResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void ListDatabaseOperations(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::ListDatabaseOperationsRequest* request, ::google::spanner::admin::database::v1::ListDatabaseOperationsResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
      // Lists the backup [long-running operations][google.longrunning.Operation] in
      // the given instance. A backup operation has a name of the form
      // `projects/<project>/instances/<instance>/backups/<backup>/operations/<operation>`.
      // The long-running operation
      // [metadata][google.longrunning.Operation.metadata] field type
      // `metadata.type_url` describes the type of the metadata. Operations returned
      // include those that have completed/failed/canceled within the last 7 days,
      // and pending operations. Operations returned are ordered by
      // `operation.metadata.value.progress.start_time` in descending order starting
      // from the most recently started operation.
      virtual void ListBackupOperations(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::ListBackupOperationsRequest* request, ::google::spanner::admin::database::v1::ListBackupOperationsResponse* response, std::function<void(::grpc::Status)>) = 0;
      virtual void ListBackupOperations(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::ListBackupOperationsRequest* request, ::google::spanner::admin::database::v1::ListBackupOperationsResponse* response, ::grpc::ClientUnaryReactor* reactor) = 0;
    };
    typedef class async_interface experimental_async_interface;
    virtual class async_interface* async() { return nullptr; }
    class async_interface* experimental_async() { return async(); }
   private:
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::admin::database::v1::ListDatabasesResponse>* AsyncListDatabasesRaw(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::ListDatabasesRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::admin::database::v1::ListDatabasesResponse>* PrepareAsyncListDatabasesRaw(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::ListDatabasesRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>* AsyncCreateDatabaseRaw(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::CreateDatabaseRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>* PrepareAsyncCreateDatabaseRaw(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::CreateDatabaseRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::admin::database::v1::Database>* AsyncGetDatabaseRaw(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::GetDatabaseRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::admin::database::v1::Database>* PrepareAsyncGetDatabaseRaw(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::GetDatabaseRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>* AsyncUpdateDatabaseDdlRaw(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::UpdateDatabaseDdlRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>* PrepareAsyncUpdateDatabaseDdlRaw(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::UpdateDatabaseDdlRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>* AsyncDropDatabaseRaw(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::DropDatabaseRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>* PrepareAsyncDropDatabaseRaw(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::DropDatabaseRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::admin::database::v1::GetDatabaseDdlResponse>* AsyncGetDatabaseDdlRaw(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::GetDatabaseDdlRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::admin::database::v1::GetDatabaseDdlResponse>* PrepareAsyncGetDatabaseDdlRaw(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::GetDatabaseDdlRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::v1::Policy>* AsyncSetIamPolicyRaw(::grpc::ClientContext* context, const ::google::iam::v1::SetIamPolicyRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::v1::Policy>* PrepareAsyncSetIamPolicyRaw(::grpc::ClientContext* context, const ::google::iam::v1::SetIamPolicyRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::v1::Policy>* AsyncGetIamPolicyRaw(::grpc::ClientContext* context, const ::google::iam::v1::GetIamPolicyRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::v1::Policy>* PrepareAsyncGetIamPolicyRaw(::grpc::ClientContext* context, const ::google::iam::v1::GetIamPolicyRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::v1::TestIamPermissionsResponse>* AsyncTestIamPermissionsRaw(::grpc::ClientContext* context, const ::google::iam::v1::TestIamPermissionsRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::iam::v1::TestIamPermissionsResponse>* PrepareAsyncTestIamPermissionsRaw(::grpc::ClientContext* context, const ::google::iam::v1::TestIamPermissionsRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>* AsyncCreateBackupRaw(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::CreateBackupRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>* PrepareAsyncCreateBackupRaw(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::CreateBackupRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::admin::database::v1::Backup>* AsyncGetBackupRaw(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::GetBackupRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::admin::database::v1::Backup>* PrepareAsyncGetBackupRaw(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::GetBackupRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::admin::database::v1::Backup>* AsyncUpdateBackupRaw(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::UpdateBackupRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::admin::database::v1::Backup>* PrepareAsyncUpdateBackupRaw(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::UpdateBackupRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>* AsyncDeleteBackupRaw(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::DeleteBackupRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::protobuf::Empty>* PrepareAsyncDeleteBackupRaw(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::DeleteBackupRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::admin::database::v1::ListBackupsResponse>* AsyncListBackupsRaw(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::ListBackupsRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::admin::database::v1::ListBackupsResponse>* PrepareAsyncListBackupsRaw(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::ListBackupsRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>* AsyncRestoreDatabaseRaw(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::RestoreDatabaseRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::longrunning::Operation>* PrepareAsyncRestoreDatabaseRaw(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::RestoreDatabaseRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::admin::database::v1::ListDatabaseOperationsResponse>* AsyncListDatabaseOperationsRaw(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::ListDatabaseOperationsRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::admin::database::v1::ListDatabaseOperationsResponse>* PrepareAsyncListDatabaseOperationsRaw(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::ListDatabaseOperationsRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::admin::database::v1::ListBackupOperationsResponse>* AsyncListBackupOperationsRaw(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::ListBackupOperationsRequest& request, ::grpc::CompletionQueue* cq) = 0;
    virtual ::grpc::ClientAsyncResponseReaderInterface< ::google::spanner::admin::database::v1::ListBackupOperationsResponse>* PrepareAsyncListBackupOperationsRaw(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::ListBackupOperationsRequest& request, ::grpc::CompletionQueue* cq) = 0;
  };
  class Stub final : public StubInterface {
   public:
    Stub(const std::shared_ptr< ::grpc::ChannelInterface>& channel, const ::grpc::StubOptions& options = ::grpc::StubOptions());
    ::grpc::Status ListDatabases(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::ListDatabasesRequest& request, ::google::spanner::admin::database::v1::ListDatabasesResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::spanner::admin::database::v1::ListDatabasesResponse>> AsyncListDatabases(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::ListDatabasesRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::spanner::admin::database::v1::ListDatabasesResponse>>(AsyncListDatabasesRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::spanner::admin::database::v1::ListDatabasesResponse>> PrepareAsyncListDatabases(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::ListDatabasesRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::spanner::admin::database::v1::ListDatabasesResponse>>(PrepareAsyncListDatabasesRaw(context, request, cq));
    }
    ::grpc::Status CreateDatabase(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::CreateDatabaseRequest& request, ::google::longrunning::Operation* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>> AsyncCreateDatabase(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::CreateDatabaseRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>>(AsyncCreateDatabaseRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>> PrepareAsyncCreateDatabase(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::CreateDatabaseRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>>(PrepareAsyncCreateDatabaseRaw(context, request, cq));
    }
    ::grpc::Status GetDatabase(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::GetDatabaseRequest& request, ::google::spanner::admin::database::v1::Database* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::spanner::admin::database::v1::Database>> AsyncGetDatabase(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::GetDatabaseRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::spanner::admin::database::v1::Database>>(AsyncGetDatabaseRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::spanner::admin::database::v1::Database>> PrepareAsyncGetDatabase(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::GetDatabaseRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::spanner::admin::database::v1::Database>>(PrepareAsyncGetDatabaseRaw(context, request, cq));
    }
    ::grpc::Status UpdateDatabaseDdl(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::UpdateDatabaseDdlRequest& request, ::google::longrunning::Operation* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>> AsyncUpdateDatabaseDdl(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::UpdateDatabaseDdlRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>>(AsyncUpdateDatabaseDdlRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>> PrepareAsyncUpdateDatabaseDdl(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::UpdateDatabaseDdlRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>>(PrepareAsyncUpdateDatabaseDdlRaw(context, request, cq));
    }
    ::grpc::Status DropDatabase(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::DropDatabaseRequest& request, ::google::protobuf::Empty* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>> AsyncDropDatabase(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::DropDatabaseRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>>(AsyncDropDatabaseRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>> PrepareAsyncDropDatabase(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::DropDatabaseRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>>(PrepareAsyncDropDatabaseRaw(context, request, cq));
    }
    ::grpc::Status GetDatabaseDdl(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::GetDatabaseDdlRequest& request, ::google::spanner::admin::database::v1::GetDatabaseDdlResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::spanner::admin::database::v1::GetDatabaseDdlResponse>> AsyncGetDatabaseDdl(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::GetDatabaseDdlRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::spanner::admin::database::v1::GetDatabaseDdlResponse>>(AsyncGetDatabaseDdlRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::spanner::admin::database::v1::GetDatabaseDdlResponse>> PrepareAsyncGetDatabaseDdl(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::GetDatabaseDdlRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::spanner::admin::database::v1::GetDatabaseDdlResponse>>(PrepareAsyncGetDatabaseDdlRaw(context, request, cq));
    }
    ::grpc::Status SetIamPolicy(::grpc::ClientContext* context, const ::google::iam::v1::SetIamPolicyRequest& request, ::google::iam::v1::Policy* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::v1::Policy>> AsyncSetIamPolicy(::grpc::ClientContext* context, const ::google::iam::v1::SetIamPolicyRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::v1::Policy>>(AsyncSetIamPolicyRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::v1::Policy>> PrepareAsyncSetIamPolicy(::grpc::ClientContext* context, const ::google::iam::v1::SetIamPolicyRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::v1::Policy>>(PrepareAsyncSetIamPolicyRaw(context, request, cq));
    }
    ::grpc::Status GetIamPolicy(::grpc::ClientContext* context, const ::google::iam::v1::GetIamPolicyRequest& request, ::google::iam::v1::Policy* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::v1::Policy>> AsyncGetIamPolicy(::grpc::ClientContext* context, const ::google::iam::v1::GetIamPolicyRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::v1::Policy>>(AsyncGetIamPolicyRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::v1::Policy>> PrepareAsyncGetIamPolicy(::grpc::ClientContext* context, const ::google::iam::v1::GetIamPolicyRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::v1::Policy>>(PrepareAsyncGetIamPolicyRaw(context, request, cq));
    }
    ::grpc::Status TestIamPermissions(::grpc::ClientContext* context, const ::google::iam::v1::TestIamPermissionsRequest& request, ::google::iam::v1::TestIamPermissionsResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::v1::TestIamPermissionsResponse>> AsyncTestIamPermissions(::grpc::ClientContext* context, const ::google::iam::v1::TestIamPermissionsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::v1::TestIamPermissionsResponse>>(AsyncTestIamPermissionsRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::v1::TestIamPermissionsResponse>> PrepareAsyncTestIamPermissions(::grpc::ClientContext* context, const ::google::iam::v1::TestIamPermissionsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::iam::v1::TestIamPermissionsResponse>>(PrepareAsyncTestIamPermissionsRaw(context, request, cq));
    }
    ::grpc::Status CreateBackup(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::CreateBackupRequest& request, ::google::longrunning::Operation* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>> AsyncCreateBackup(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::CreateBackupRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>>(AsyncCreateBackupRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>> PrepareAsyncCreateBackup(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::CreateBackupRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>>(PrepareAsyncCreateBackupRaw(context, request, cq));
    }
    ::grpc::Status GetBackup(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::GetBackupRequest& request, ::google::spanner::admin::database::v1::Backup* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::spanner::admin::database::v1::Backup>> AsyncGetBackup(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::GetBackupRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::spanner::admin::database::v1::Backup>>(AsyncGetBackupRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::spanner::admin::database::v1::Backup>> PrepareAsyncGetBackup(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::GetBackupRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::spanner::admin::database::v1::Backup>>(PrepareAsyncGetBackupRaw(context, request, cq));
    }
    ::grpc::Status UpdateBackup(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::UpdateBackupRequest& request, ::google::spanner::admin::database::v1::Backup* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::spanner::admin::database::v1::Backup>> AsyncUpdateBackup(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::UpdateBackupRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::spanner::admin::database::v1::Backup>>(AsyncUpdateBackupRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::spanner::admin::database::v1::Backup>> PrepareAsyncUpdateBackup(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::UpdateBackupRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::spanner::admin::database::v1::Backup>>(PrepareAsyncUpdateBackupRaw(context, request, cq));
    }
    ::grpc::Status DeleteBackup(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::DeleteBackupRequest& request, ::google::protobuf::Empty* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>> AsyncDeleteBackup(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::DeleteBackupRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>>(AsyncDeleteBackupRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>> PrepareAsyncDeleteBackup(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::DeleteBackupRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>>(PrepareAsyncDeleteBackupRaw(context, request, cq));
    }
    ::grpc::Status ListBackups(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::ListBackupsRequest& request, ::google::spanner::admin::database::v1::ListBackupsResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::spanner::admin::database::v1::ListBackupsResponse>> AsyncListBackups(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::ListBackupsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::spanner::admin::database::v1::ListBackupsResponse>>(AsyncListBackupsRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::spanner::admin::database::v1::ListBackupsResponse>> PrepareAsyncListBackups(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::ListBackupsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::spanner::admin::database::v1::ListBackupsResponse>>(PrepareAsyncListBackupsRaw(context, request, cq));
    }
    ::grpc::Status RestoreDatabase(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::RestoreDatabaseRequest& request, ::google::longrunning::Operation* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>> AsyncRestoreDatabase(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::RestoreDatabaseRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>>(AsyncRestoreDatabaseRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>> PrepareAsyncRestoreDatabase(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::RestoreDatabaseRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>>(PrepareAsyncRestoreDatabaseRaw(context, request, cq));
    }
    ::grpc::Status ListDatabaseOperations(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::ListDatabaseOperationsRequest& request, ::google::spanner::admin::database::v1::ListDatabaseOperationsResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::spanner::admin::database::v1::ListDatabaseOperationsResponse>> AsyncListDatabaseOperations(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::ListDatabaseOperationsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::spanner::admin::database::v1::ListDatabaseOperationsResponse>>(AsyncListDatabaseOperationsRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::spanner::admin::database::v1::ListDatabaseOperationsResponse>> PrepareAsyncListDatabaseOperations(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::ListDatabaseOperationsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::spanner::admin::database::v1::ListDatabaseOperationsResponse>>(PrepareAsyncListDatabaseOperationsRaw(context, request, cq));
    }
    ::grpc::Status ListBackupOperations(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::ListBackupOperationsRequest& request, ::google::spanner::admin::database::v1::ListBackupOperationsResponse* response) override;
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::spanner::admin::database::v1::ListBackupOperationsResponse>> AsyncListBackupOperations(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::ListBackupOperationsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::spanner::admin::database::v1::ListBackupOperationsResponse>>(AsyncListBackupOperationsRaw(context, request, cq));
    }
    std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::spanner::admin::database::v1::ListBackupOperationsResponse>> PrepareAsyncListBackupOperations(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::ListBackupOperationsRequest& request, ::grpc::CompletionQueue* cq) {
      return std::unique_ptr< ::grpc::ClientAsyncResponseReader< ::google::spanner::admin::database::v1::ListBackupOperationsResponse>>(PrepareAsyncListBackupOperationsRaw(context, request, cq));
    }
    class async final :
      public StubInterface::async_interface {
     public:
      void ListDatabases(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::ListDatabasesRequest* request, ::google::spanner::admin::database::v1::ListDatabasesResponse* response, std::function<void(::grpc::Status)>) override;
      void ListDatabases(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::ListDatabasesRequest* request, ::google::spanner::admin::database::v1::ListDatabasesResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
      void CreateDatabase(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::CreateDatabaseRequest* request, ::google::longrunning::Operation* response, std::function<void(::grpc::Status)>) override;
      void CreateDatabase(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::CreateDatabaseRequest* request, ::google::longrunning::Operation* response, ::grpc::ClientUnaryReactor* reactor) override;
      void GetDatabase(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::GetDatabaseRequest* request, ::google::spanner::admin::database::v1::Database* response, std::function<void(::grpc::Status)>) override;
      void GetDatabase(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::GetDatabaseRequest* request, ::google::spanner::admin::database::v1::Database* response, ::grpc::ClientUnaryReactor* reactor) override;
      void UpdateDatabaseDdl(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::UpdateDatabaseDdlRequest* request, ::google::longrunning::Operation* response, std::function<void(::grpc::Status)>) override;
      void UpdateDatabaseDdl(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::UpdateDatabaseDdlRequest* request, ::google::longrunning::Operation* response, ::grpc::ClientUnaryReactor* reactor) override;
      void DropDatabase(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::DropDatabaseRequest* request, ::google::protobuf::Empty* response, std::function<void(::grpc::Status)>) override;
      void DropDatabase(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::DropDatabaseRequest* request, ::google::protobuf::Empty* response, ::grpc::ClientUnaryReactor* reactor) override;
      void GetDatabaseDdl(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::GetDatabaseDdlRequest* request, ::google::spanner::admin::database::v1::GetDatabaseDdlResponse* response, std::function<void(::grpc::Status)>) override;
      void GetDatabaseDdl(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::GetDatabaseDdlRequest* request, ::google::spanner::admin::database::v1::GetDatabaseDdlResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
      void SetIamPolicy(::grpc::ClientContext* context, const ::google::iam::v1::SetIamPolicyRequest* request, ::google::iam::v1::Policy* response, std::function<void(::grpc::Status)>) override;
      void SetIamPolicy(::grpc::ClientContext* context, const ::google::iam::v1::SetIamPolicyRequest* request, ::google::iam::v1::Policy* response, ::grpc::ClientUnaryReactor* reactor) override;
      void GetIamPolicy(::grpc::ClientContext* context, const ::google::iam::v1::GetIamPolicyRequest* request, ::google::iam::v1::Policy* response, std::function<void(::grpc::Status)>) override;
      void GetIamPolicy(::grpc::ClientContext* context, const ::google::iam::v1::GetIamPolicyRequest* request, ::google::iam::v1::Policy* response, ::grpc::ClientUnaryReactor* reactor) override;
      void TestIamPermissions(::grpc::ClientContext* context, const ::google::iam::v1::TestIamPermissionsRequest* request, ::google::iam::v1::TestIamPermissionsResponse* response, std::function<void(::grpc::Status)>) override;
      void TestIamPermissions(::grpc::ClientContext* context, const ::google::iam::v1::TestIamPermissionsRequest* request, ::google::iam::v1::TestIamPermissionsResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
      void CreateBackup(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::CreateBackupRequest* request, ::google::longrunning::Operation* response, std::function<void(::grpc::Status)>) override;
      void CreateBackup(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::CreateBackupRequest* request, ::google::longrunning::Operation* response, ::grpc::ClientUnaryReactor* reactor) override;
      void GetBackup(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::GetBackupRequest* request, ::google::spanner::admin::database::v1::Backup* response, std::function<void(::grpc::Status)>) override;
      void GetBackup(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::GetBackupRequest* request, ::google::spanner::admin::database::v1::Backup* response, ::grpc::ClientUnaryReactor* reactor) override;
      void UpdateBackup(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::UpdateBackupRequest* request, ::google::spanner::admin::database::v1::Backup* response, std::function<void(::grpc::Status)>) override;
      void UpdateBackup(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::UpdateBackupRequest* request, ::google::spanner::admin::database::v1::Backup* response, ::grpc::ClientUnaryReactor* reactor) override;
      void DeleteBackup(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::DeleteBackupRequest* request, ::google::protobuf::Empty* response, std::function<void(::grpc::Status)>) override;
      void DeleteBackup(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::DeleteBackupRequest* request, ::google::protobuf::Empty* response, ::grpc::ClientUnaryReactor* reactor) override;
      void ListBackups(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::ListBackupsRequest* request, ::google::spanner::admin::database::v1::ListBackupsResponse* response, std::function<void(::grpc::Status)>) override;
      void ListBackups(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::ListBackupsRequest* request, ::google::spanner::admin::database::v1::ListBackupsResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
      void RestoreDatabase(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::RestoreDatabaseRequest* request, ::google::longrunning::Operation* response, std::function<void(::grpc::Status)>) override;
      void RestoreDatabase(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::RestoreDatabaseRequest* request, ::google::longrunning::Operation* response, ::grpc::ClientUnaryReactor* reactor) override;
      void ListDatabaseOperations(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::ListDatabaseOperationsRequest* request, ::google::spanner::admin::database::v1::ListDatabaseOperationsResponse* response, std::function<void(::grpc::Status)>) override;
      void ListDatabaseOperations(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::ListDatabaseOperationsRequest* request, ::google::spanner::admin::database::v1::ListDatabaseOperationsResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
      void ListBackupOperations(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::ListBackupOperationsRequest* request, ::google::spanner::admin::database::v1::ListBackupOperationsResponse* response, std::function<void(::grpc::Status)>) override;
      void ListBackupOperations(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::ListBackupOperationsRequest* request, ::google::spanner::admin::database::v1::ListBackupOperationsResponse* response, ::grpc::ClientUnaryReactor* reactor) override;
     private:
      friend class Stub;
      explicit async(Stub* stub): stub_(stub) { }
      Stub* stub() { return stub_; }
      Stub* stub_;
    };
    class async* async() override { return &async_stub_; }

   private:
    std::shared_ptr< ::grpc::ChannelInterface> channel_;
    class async async_stub_{this};
    ::grpc::ClientAsyncResponseReader< ::google::spanner::admin::database::v1::ListDatabasesResponse>* AsyncListDatabasesRaw(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::ListDatabasesRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::spanner::admin::database::v1::ListDatabasesResponse>* PrepareAsyncListDatabasesRaw(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::ListDatabasesRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>* AsyncCreateDatabaseRaw(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::CreateDatabaseRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>* PrepareAsyncCreateDatabaseRaw(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::CreateDatabaseRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::spanner::admin::database::v1::Database>* AsyncGetDatabaseRaw(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::GetDatabaseRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::spanner::admin::database::v1::Database>* PrepareAsyncGetDatabaseRaw(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::GetDatabaseRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>* AsyncUpdateDatabaseDdlRaw(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::UpdateDatabaseDdlRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>* PrepareAsyncUpdateDatabaseDdlRaw(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::UpdateDatabaseDdlRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>* AsyncDropDatabaseRaw(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::DropDatabaseRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>* PrepareAsyncDropDatabaseRaw(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::DropDatabaseRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::spanner::admin::database::v1::GetDatabaseDdlResponse>* AsyncGetDatabaseDdlRaw(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::GetDatabaseDdlRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::spanner::admin::database::v1::GetDatabaseDdlResponse>* PrepareAsyncGetDatabaseDdlRaw(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::GetDatabaseDdlRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::iam::v1::Policy>* AsyncSetIamPolicyRaw(::grpc::ClientContext* context, const ::google::iam::v1::SetIamPolicyRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::iam::v1::Policy>* PrepareAsyncSetIamPolicyRaw(::grpc::ClientContext* context, const ::google::iam::v1::SetIamPolicyRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::iam::v1::Policy>* AsyncGetIamPolicyRaw(::grpc::ClientContext* context, const ::google::iam::v1::GetIamPolicyRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::iam::v1::Policy>* PrepareAsyncGetIamPolicyRaw(::grpc::ClientContext* context, const ::google::iam::v1::GetIamPolicyRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::iam::v1::TestIamPermissionsResponse>* AsyncTestIamPermissionsRaw(::grpc::ClientContext* context, const ::google::iam::v1::TestIamPermissionsRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::iam::v1::TestIamPermissionsResponse>* PrepareAsyncTestIamPermissionsRaw(::grpc::ClientContext* context, const ::google::iam::v1::TestIamPermissionsRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>* AsyncCreateBackupRaw(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::CreateBackupRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>* PrepareAsyncCreateBackupRaw(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::CreateBackupRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::spanner::admin::database::v1::Backup>* AsyncGetBackupRaw(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::GetBackupRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::spanner::admin::database::v1::Backup>* PrepareAsyncGetBackupRaw(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::GetBackupRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::spanner::admin::database::v1::Backup>* AsyncUpdateBackupRaw(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::UpdateBackupRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::spanner::admin::database::v1::Backup>* PrepareAsyncUpdateBackupRaw(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::UpdateBackupRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>* AsyncDeleteBackupRaw(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::DeleteBackupRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::protobuf::Empty>* PrepareAsyncDeleteBackupRaw(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::DeleteBackupRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::spanner::admin::database::v1::ListBackupsResponse>* AsyncListBackupsRaw(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::ListBackupsRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::spanner::admin::database::v1::ListBackupsResponse>* PrepareAsyncListBackupsRaw(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::ListBackupsRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>* AsyncRestoreDatabaseRaw(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::RestoreDatabaseRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::longrunning::Operation>* PrepareAsyncRestoreDatabaseRaw(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::RestoreDatabaseRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::spanner::admin::database::v1::ListDatabaseOperationsResponse>* AsyncListDatabaseOperationsRaw(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::ListDatabaseOperationsRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::spanner::admin::database::v1::ListDatabaseOperationsResponse>* PrepareAsyncListDatabaseOperationsRaw(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::ListDatabaseOperationsRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::spanner::admin::database::v1::ListBackupOperationsResponse>* AsyncListBackupOperationsRaw(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::ListBackupOperationsRequest& request, ::grpc::CompletionQueue* cq) override;
    ::grpc::ClientAsyncResponseReader< ::google::spanner::admin::database::v1::ListBackupOperationsResponse>* PrepareAsyncListBackupOperationsRaw(::grpc::ClientContext* context, const ::google::spanner::admin::database::v1::ListBackupOperationsRequest& request, ::grpc::CompletionQueue* cq) override;
    const ::grpc::internal::RpcMethod rpcmethod_ListDatabases_;
    const ::grpc::internal::RpcMethod rpcmethod_CreateDatabase_;
    const ::grpc::internal::RpcMethod rpcmethod_GetDatabase_;
    const ::grpc::internal::RpcMethod rpcmethod_UpdateDatabaseDdl_;
    const ::grpc::internal::RpcMethod rpcmethod_DropDatabase_;
    const ::grpc::internal::RpcMethod rpcmethod_GetDatabaseDdl_;
    const ::grpc::internal::RpcMethod rpcmethod_SetIamPolicy_;
    const ::grpc::internal::RpcMethod rpcmethod_GetIamPolicy_;
    const ::grpc::internal::RpcMethod rpcmethod_TestIamPermissions_;
    const ::grpc::internal::RpcMethod rpcmethod_CreateBackup_;
    const ::grpc::internal::RpcMethod rpcmethod_GetBackup_;
    const ::grpc::internal::RpcMethod rpcmethod_UpdateBackup_;
    const ::grpc::internal::RpcMethod rpcmethod_DeleteBackup_;
    const ::grpc::internal::RpcMethod rpcmethod_ListBackups_;
    const ::grpc::internal::RpcMethod rpcmethod_RestoreDatabase_;
    const ::grpc::internal::RpcMethod rpcmethod_ListDatabaseOperations_;
    const ::grpc::internal::RpcMethod rpcmethod_ListBackupOperations_;
  };
  static std::unique_ptr<Stub> NewStub(const std::shared_ptr< ::grpc::ChannelInterface>& channel, const ::grpc::StubOptions& options = ::grpc::StubOptions());

  class Service : public ::grpc::Service {
   public:
    Service();
    virtual ~Service();
    // Lists Cloud Spanner databases.
    virtual ::grpc::Status ListDatabases(::grpc::ServerContext* context, const ::google::spanner::admin::database::v1::ListDatabasesRequest* request, ::google::spanner::admin::database::v1::ListDatabasesResponse* response);
    // Creates a new Cloud Spanner database and starts to prepare it for serving.
    // The returned [long-running operation][google.longrunning.Operation] will
    // have a name of the format `<database_name>/operations/<operation_id>` and
    // can be used to track preparation of the database. The
    // [metadata][google.longrunning.Operation.metadata] field type is
    // [CreateDatabaseMetadata][google.spanner.admin.database.v1.CreateDatabaseMetadata]. The
    // [response][google.longrunning.Operation.response] field type is
    // [Database][google.spanner.admin.database.v1.Database], if successful.
    virtual ::grpc::Status CreateDatabase(::grpc::ServerContext* context, const ::google::spanner::admin::database::v1::CreateDatabaseRequest* request, ::google::longrunning::Operation* response);
    // Gets the state of a Cloud Spanner database.
    virtual ::grpc::Status GetDatabase(::grpc::ServerContext* context, const ::google::spanner::admin::database::v1::GetDatabaseRequest* request, ::google::spanner::admin::database::v1::Database* response);
    // Updates the schema of a Cloud Spanner database by
    // creating/altering/dropping tables, columns, indexes, etc. The returned
    // [long-running operation][google.longrunning.Operation] will have a name of
    // the format `<database_name>/operations/<operation_id>` and can be used to
    // track execution of the schema change(s). The
    // [metadata][google.longrunning.Operation.metadata] field type is
    // [UpdateDatabaseDdlMetadata][google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata].  The operation has no response.
    virtual ::grpc::Status UpdateDatabaseDdl(::grpc::ServerContext* context, const ::google::spanner::admin::database::v1::UpdateDatabaseDdlRequest* request, ::google::longrunning::Operation* response);
    // Drops (aka deletes) a Cloud Spanner database.
    // Completed backups for the database will be retained according to their
    // `expire_time`.
    // Note: Cloud Spanner might continue to accept requests for a few seconds
    // after the database has been deleted.
    virtual ::grpc::Status DropDatabase(::grpc::ServerContext* context, const ::google::spanner::admin::database::v1::DropDatabaseRequest* request, ::google::protobuf::Empty* response);
    // Returns the schema of a Cloud Spanner database as a list of formatted
    // DDL statements. This method does not show pending schema updates, those may
    // be queried using the [Operations][google.longrunning.Operations] API.
    virtual ::grpc::Status GetDatabaseDdl(::grpc::ServerContext* context, const ::google::spanner::admin::database::v1::GetDatabaseDdlRequest* request, ::google::spanner::admin::database::v1::GetDatabaseDdlResponse* response);
    // Sets the access control policy on a database or backup resource.
    // Replaces any existing policy.
    //
    // Authorization requires `spanner.databases.setIamPolicy`
    // permission on [resource][google.iam.v1.SetIamPolicyRequest.resource].
    // For backups, authorization requires `spanner.backups.setIamPolicy`
    // permission on [resource][google.iam.v1.SetIamPolicyRequest.resource].
    virtual ::grpc::Status SetIamPolicy(::grpc::ServerContext* context, const ::google::iam::v1::SetIamPolicyRequest* request, ::google::iam::v1::Policy* response);
    // Gets the access control policy for a database or backup resource.
    // Returns an empty policy if a database or backup exists but does not have a
    // policy set.
    //
    // Authorization requires `spanner.databases.getIamPolicy` permission on
    // [resource][google.iam.v1.GetIamPolicyRequest.resource].
    // For backups, authorization requires `spanner.backups.getIamPolicy`
    // permission on [resource][google.iam.v1.GetIamPolicyRequest.resource].
    virtual ::grpc::Status GetIamPolicy(::grpc::ServerContext* context, const ::google::iam::v1::GetIamPolicyRequest* request, ::google::iam::v1::Policy* response);
    // Returns permissions that the caller has on the specified database or backup
    // resource.
    //
    // Attempting this RPC on a non-existent Cloud Spanner database will
    // result in a NOT_FOUND error if the user has
    // `spanner.databases.list` permission on the containing Cloud
    // Spanner instance. Otherwise returns an empty set of permissions.
    // Calling this method on a backup that does not exist will
    // result in a NOT_FOUND error if the user has
    // `spanner.backups.list` permission on the containing instance.
    virtual ::grpc::Status TestIamPermissions(::grpc::ServerContext* context, const ::google::iam::v1::TestIamPermissionsRequest* request, ::google::iam::v1::TestIamPermissionsResponse* response);
    // Starts creating a new Cloud Spanner Backup.
    // The returned backup [long-running operation][google.longrunning.Operation]
    // will have a name of the format
    // `projects/<project>/instances/<instance>/backups/<backup>/operations/<operation_id>`
    // and can be used to track creation of the backup. The
    // [metadata][google.longrunning.Operation.metadata] field type is
    // [CreateBackupMetadata][google.spanner.admin.database.v1.CreateBackupMetadata]. The
    // [response][google.longrunning.Operation.response] field type is
    // [Backup][google.spanner.admin.database.v1.Backup], if successful. Cancelling the returned operation will stop the
    // creation and delete the backup.
    // There can be only one pending backup creation per database. Backup creation
    // of different databases can run concurrently.
    virtual ::grpc::Status CreateBackup(::grpc::ServerContext* context, const ::google::spanner::admin::database::v1::CreateBackupRequest* request, ::google::longrunning::Operation* response);
    // Gets metadata on a pending or completed [Backup][google.spanner.admin.database.v1.Backup].
    virtual ::grpc::Status GetBackup(::grpc::ServerContext* context, const ::google::spanner::admin::database::v1::GetBackupRequest* request, ::google::spanner::admin::database::v1::Backup* response);
    // Updates a pending or completed [Backup][google.spanner.admin.database.v1.Backup].
    virtual ::grpc::Status UpdateBackup(::grpc::ServerContext* context, const ::google::spanner::admin::database::v1::UpdateBackupRequest* request, ::google::spanner::admin::database::v1::Backup* response);
    // Deletes a pending or completed [Backup][google.spanner.admin.database.v1.Backup].
    virtual ::grpc::Status DeleteBackup(::grpc::ServerContext* context, const ::google::spanner::admin::database::v1::DeleteBackupRequest* request, ::google::protobuf::Empty* response);
    // Lists completed and pending backups.
    // Backups returned are ordered by `create_time` in descending order,
    // starting from the most recent `create_time`.
    virtual ::grpc::Status ListBackups(::grpc::ServerContext* context, const ::google::spanner::admin::database::v1::ListBackupsRequest* request, ::google::spanner::admin::database::v1::ListBackupsResponse* response);
    // Create a new database by restoring from a completed backup. The new
    // database must be in the same project and in an instance with the same
    // instance configuration as the instance containing
    // the backup. The returned database [long-running
    // operation][google.longrunning.Operation] has a name of the format
    // `projects/<project>/instances/<instance>/databases/<database>/operations/<operation_id>`,
    // and can be used to track the progress of the operation, and to cancel it.
    // The [metadata][google.longrunning.Operation.metadata] field type is
    // [RestoreDatabaseMetadata][google.spanner.admin.database.v1.RestoreDatabaseMetadata].
    // The [response][google.longrunning.Operation.response] type
    // is [Database][google.spanner.admin.database.v1.Database], if
    // successful. Cancelling the returned operation will stop the restore and
    // delete the database.
    // There can be only one database being restored into an instance at a time.
    // Once the restore operation completes, a new restore operation can be
    // initiated, without waiting for the optimize operation associated with the
    // first restore to complete.
    virtual ::grpc::Status RestoreDatabase(::grpc::ServerContext* context, const ::google::spanner::admin::database::v1::RestoreDatabaseRequest* request, ::google::longrunning::Operation* response);
    // Lists database [longrunning-operations][google.longrunning.Operation].
    // A database operation has a name of the form
    // `projects/<project>/instances/<instance>/databases/<database>/operations/<operation>`.
    // The long-running operation
    // [metadata][google.longrunning.Operation.metadata] field type
    // `metadata.type_url` describes the type of the metadata. Operations returned
    // include those that have completed/failed/canceled within the last 7 days,
    // and pending operations.
    virtual ::grpc::Status ListDatabaseOperations(::grpc::ServerContext* context, const ::google::spanner::admin::database::v1::ListDatabaseOperationsRequest* request, ::google::spanner::admin::database::v1::ListDatabaseOperationsResponse* response);
    // Lists the backup [long-running operations][google.longrunning.Operation] in
    // the given instance. A backup operation has a name of the form
    // `projects/<project>/instances/<instance>/backups/<backup>/operations/<operation>`.
    // The long-running operation
    // [metadata][google.longrunning.Operation.metadata] field type
    // `metadata.type_url` describes the type of the metadata. Operations returned
    // include those that have completed/failed/canceled within the last 7 days,
    // and pending operations. Operations returned are ordered by
    // `operation.metadata.value.progress.start_time` in descending order starting
    // from the most recently started operation.
    virtual ::grpc::Status ListBackupOperations(::grpc::ServerContext* context, const ::google::spanner::admin::database::v1::ListBackupOperationsRequest* request, ::google::spanner::admin::database::v1::ListBackupOperationsResponse* response);
  };
  template <class BaseClass>
  class WithAsyncMethod_ListDatabases : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_ListDatabases() {
      ::grpc::Service::MarkMethodAsync(0);
    }
    ~WithAsyncMethod_ListDatabases() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListDatabases(::grpc::ServerContext* /*context*/, const ::google::spanner::admin::database::v1::ListDatabasesRequest* /*request*/, ::google::spanner::admin::database::v1::ListDatabasesResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestListDatabases(::grpc::ServerContext* context, ::google::spanner::admin::database::v1::ListDatabasesRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::spanner::admin::database::v1::ListDatabasesResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(0, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_CreateDatabase : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_CreateDatabase() {
      ::grpc::Service::MarkMethodAsync(1);
    }
    ~WithAsyncMethod_CreateDatabase() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateDatabase(::grpc::ServerContext* /*context*/, const ::google::spanner::admin::database::v1::CreateDatabaseRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestCreateDatabase(::grpc::ServerContext* context, ::google::spanner::admin::database::v1::CreateDatabaseRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::longrunning::Operation>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(1, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_GetDatabase : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_GetDatabase() {
      ::grpc::Service::MarkMethodAsync(2);
    }
    ~WithAsyncMethod_GetDatabase() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetDatabase(::grpc::ServerContext* /*context*/, const ::google::spanner::admin::database::v1::GetDatabaseRequest* /*request*/, ::google::spanner::admin::database::v1::Database* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGetDatabase(::grpc::ServerContext* context, ::google::spanner::admin::database::v1::GetDatabaseRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::spanner::admin::database::v1::Database>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(2, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_UpdateDatabaseDdl : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_UpdateDatabaseDdl() {
      ::grpc::Service::MarkMethodAsync(3);
    }
    ~WithAsyncMethod_UpdateDatabaseDdl() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateDatabaseDdl(::grpc::ServerContext* /*context*/, const ::google::spanner::admin::database::v1::UpdateDatabaseDdlRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestUpdateDatabaseDdl(::grpc::ServerContext* context, ::google::spanner::admin::database::v1::UpdateDatabaseDdlRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::longrunning::Operation>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(3, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_DropDatabase : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_DropDatabase() {
      ::grpc::Service::MarkMethodAsync(4);
    }
    ~WithAsyncMethod_DropDatabase() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DropDatabase(::grpc::ServerContext* /*context*/, const ::google::spanner::admin::database::v1::DropDatabaseRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestDropDatabase(::grpc::ServerContext* context, ::google::spanner::admin::database::v1::DropDatabaseRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::protobuf::Empty>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(4, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_GetDatabaseDdl : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_GetDatabaseDdl() {
      ::grpc::Service::MarkMethodAsync(5);
    }
    ~WithAsyncMethod_GetDatabaseDdl() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetDatabaseDdl(::grpc::ServerContext* /*context*/, const ::google::spanner::admin::database::v1::GetDatabaseDdlRequest* /*request*/, ::google::spanner::admin::database::v1::GetDatabaseDdlResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGetDatabaseDdl(::grpc::ServerContext* context, ::google::spanner::admin::database::v1::GetDatabaseDdlRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::spanner::admin::database::v1::GetDatabaseDdlResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(5, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_SetIamPolicy : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_SetIamPolicy() {
      ::grpc::Service::MarkMethodAsync(6);
    }
    ~WithAsyncMethod_SetIamPolicy() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status SetIamPolicy(::grpc::ServerContext* /*context*/, const ::google::iam::v1::SetIamPolicyRequest* /*request*/, ::google::iam::v1::Policy* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestSetIamPolicy(::grpc::ServerContext* context, ::google::iam::v1::SetIamPolicyRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::iam::v1::Policy>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(6, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_GetIamPolicy : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_GetIamPolicy() {
      ::grpc::Service::MarkMethodAsync(7);
    }
    ~WithAsyncMethod_GetIamPolicy() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetIamPolicy(::grpc::ServerContext* /*context*/, const ::google::iam::v1::GetIamPolicyRequest* /*request*/, ::google::iam::v1::Policy* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGetIamPolicy(::grpc::ServerContext* context, ::google::iam::v1::GetIamPolicyRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::iam::v1::Policy>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(7, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_TestIamPermissions : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_TestIamPermissions() {
      ::grpc::Service::MarkMethodAsync(8);
    }
    ~WithAsyncMethod_TestIamPermissions() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status TestIamPermissions(::grpc::ServerContext* /*context*/, const ::google::iam::v1::TestIamPermissionsRequest* /*request*/, ::google::iam::v1::TestIamPermissionsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestTestIamPermissions(::grpc::ServerContext* context, ::google::iam::v1::TestIamPermissionsRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::iam::v1::TestIamPermissionsResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(8, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_CreateBackup : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_CreateBackup() {
      ::grpc::Service::MarkMethodAsync(9);
    }
    ~WithAsyncMethod_CreateBackup() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateBackup(::grpc::ServerContext* /*context*/, const ::google::spanner::admin::database::v1::CreateBackupRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestCreateBackup(::grpc::ServerContext* context, ::google::spanner::admin::database::v1::CreateBackupRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::longrunning::Operation>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(9, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_GetBackup : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_GetBackup() {
      ::grpc::Service::MarkMethodAsync(10);
    }
    ~WithAsyncMethod_GetBackup() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetBackup(::grpc::ServerContext* /*context*/, const ::google::spanner::admin::database::v1::GetBackupRequest* /*request*/, ::google::spanner::admin::database::v1::Backup* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGetBackup(::grpc::ServerContext* context, ::google::spanner::admin::database::v1::GetBackupRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::spanner::admin::database::v1::Backup>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(10, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_UpdateBackup : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_UpdateBackup() {
      ::grpc::Service::MarkMethodAsync(11);
    }
    ~WithAsyncMethod_UpdateBackup() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateBackup(::grpc::ServerContext* /*context*/, const ::google::spanner::admin::database::v1::UpdateBackupRequest* /*request*/, ::google::spanner::admin::database::v1::Backup* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestUpdateBackup(::grpc::ServerContext* context, ::google::spanner::admin::database::v1::UpdateBackupRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::spanner::admin::database::v1::Backup>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(11, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_DeleteBackup : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_DeleteBackup() {
      ::grpc::Service::MarkMethodAsync(12);
    }
    ~WithAsyncMethod_DeleteBackup() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteBackup(::grpc::ServerContext* /*context*/, const ::google::spanner::admin::database::v1::DeleteBackupRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestDeleteBackup(::grpc::ServerContext* context, ::google::spanner::admin::database::v1::DeleteBackupRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::protobuf::Empty>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(12, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_ListBackups : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_ListBackups() {
      ::grpc::Service::MarkMethodAsync(13);
    }
    ~WithAsyncMethod_ListBackups() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListBackups(::grpc::ServerContext* /*context*/, const ::google::spanner::admin::database::v1::ListBackupsRequest* /*request*/, ::google::spanner::admin::database::v1::ListBackupsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestListBackups(::grpc::ServerContext* context, ::google::spanner::admin::database::v1::ListBackupsRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::spanner::admin::database::v1::ListBackupsResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(13, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_RestoreDatabase : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_RestoreDatabase() {
      ::grpc::Service::MarkMethodAsync(14);
    }
    ~WithAsyncMethod_RestoreDatabase() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status RestoreDatabase(::grpc::ServerContext* /*context*/, const ::google::spanner::admin::database::v1::RestoreDatabaseRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestRestoreDatabase(::grpc::ServerContext* context, ::google::spanner::admin::database::v1::RestoreDatabaseRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::longrunning::Operation>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(14, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_ListDatabaseOperations : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_ListDatabaseOperations() {
      ::grpc::Service::MarkMethodAsync(15);
    }
    ~WithAsyncMethod_ListDatabaseOperations() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListDatabaseOperations(::grpc::ServerContext* /*context*/, const ::google::spanner::admin::database::v1::ListDatabaseOperationsRequest* /*request*/, ::google::spanner::admin::database::v1::ListDatabaseOperationsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestListDatabaseOperations(::grpc::ServerContext* context, ::google::spanner::admin::database::v1::ListDatabaseOperationsRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::spanner::admin::database::v1::ListDatabaseOperationsResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(15, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithAsyncMethod_ListBackupOperations : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithAsyncMethod_ListBackupOperations() {
      ::grpc::Service::MarkMethodAsync(16);
    }
    ~WithAsyncMethod_ListBackupOperations() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListBackupOperations(::grpc::ServerContext* /*context*/, const ::google::spanner::admin::database::v1::ListBackupOperationsRequest* /*request*/, ::google::spanner::admin::database::v1::ListBackupOperationsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestListBackupOperations(::grpc::ServerContext* context, ::google::spanner::admin::database::v1::ListBackupOperationsRequest* request, ::grpc::ServerAsyncResponseWriter< ::google::spanner::admin::database::v1::ListBackupOperationsResponse>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(16, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  typedef WithAsyncMethod_ListDatabases<WithAsyncMethod_CreateDatabase<WithAsyncMethod_GetDatabase<WithAsyncMethod_UpdateDatabaseDdl<WithAsyncMethod_DropDatabase<WithAsyncMethod_GetDatabaseDdl<WithAsyncMethod_SetIamPolicy<WithAsyncMethod_GetIamPolicy<WithAsyncMethod_TestIamPermissions<WithAsyncMethod_CreateBackup<WithAsyncMethod_GetBackup<WithAsyncMethod_UpdateBackup<WithAsyncMethod_DeleteBackup<WithAsyncMethod_ListBackups<WithAsyncMethod_RestoreDatabase<WithAsyncMethod_ListDatabaseOperations<WithAsyncMethod_ListBackupOperations<Service > > > > > > > > > > > > > > > > > AsyncService;
  template <class BaseClass>
  class WithCallbackMethod_ListDatabases : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_ListDatabases() {
      ::grpc::Service::MarkMethodCallback(0,
          new ::grpc::internal::CallbackUnaryHandler< ::google::spanner::admin::database::v1::ListDatabasesRequest, ::google::spanner::admin::database::v1::ListDatabasesResponse>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::spanner::admin::database::v1::ListDatabasesRequest* request, ::google::spanner::admin::database::v1::ListDatabasesResponse* response) { return this->ListDatabases(context, request, response); }));}
    void SetMessageAllocatorFor_ListDatabases(
        ::grpc::MessageAllocator< ::google::spanner::admin::database::v1::ListDatabasesRequest, ::google::spanner::admin::database::v1::ListDatabasesResponse>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(0);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::spanner::admin::database::v1::ListDatabasesRequest, ::google::spanner::admin::database::v1::ListDatabasesResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_ListDatabases() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListDatabases(::grpc::ServerContext* /*context*/, const ::google::spanner::admin::database::v1::ListDatabasesRequest* /*request*/, ::google::spanner::admin::database::v1::ListDatabasesResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* ListDatabases(
      ::grpc::CallbackServerContext* /*context*/, const ::google::spanner::admin::database::v1::ListDatabasesRequest* /*request*/, ::google::spanner::admin::database::v1::ListDatabasesResponse* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_CreateDatabase : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_CreateDatabase() {
      ::grpc::Service::MarkMethodCallback(1,
          new ::grpc::internal::CallbackUnaryHandler< ::google::spanner::admin::database::v1::CreateDatabaseRequest, ::google::longrunning::Operation>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::spanner::admin::database::v1::CreateDatabaseRequest* request, ::google::longrunning::Operation* response) { return this->CreateDatabase(context, request, response); }));}
    void SetMessageAllocatorFor_CreateDatabase(
        ::grpc::MessageAllocator< ::google::spanner::admin::database::v1::CreateDatabaseRequest, ::google::longrunning::Operation>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(1);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::spanner::admin::database::v1::CreateDatabaseRequest, ::google::longrunning::Operation>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_CreateDatabase() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateDatabase(::grpc::ServerContext* /*context*/, const ::google::spanner::admin::database::v1::CreateDatabaseRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* CreateDatabase(
      ::grpc::CallbackServerContext* /*context*/, const ::google::spanner::admin::database::v1::CreateDatabaseRequest* /*request*/, ::google::longrunning::Operation* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_GetDatabase : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_GetDatabase() {
      ::grpc::Service::MarkMethodCallback(2,
          new ::grpc::internal::CallbackUnaryHandler< ::google::spanner::admin::database::v1::GetDatabaseRequest, ::google::spanner::admin::database::v1::Database>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::spanner::admin::database::v1::GetDatabaseRequest* request, ::google::spanner::admin::database::v1::Database* response) { return this->GetDatabase(context, request, response); }));}
    void SetMessageAllocatorFor_GetDatabase(
        ::grpc::MessageAllocator< ::google::spanner::admin::database::v1::GetDatabaseRequest, ::google::spanner::admin::database::v1::Database>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(2);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::spanner::admin::database::v1::GetDatabaseRequest, ::google::spanner::admin::database::v1::Database>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_GetDatabase() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetDatabase(::grpc::ServerContext* /*context*/, const ::google::spanner::admin::database::v1::GetDatabaseRequest* /*request*/, ::google::spanner::admin::database::v1::Database* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* GetDatabase(
      ::grpc::CallbackServerContext* /*context*/, const ::google::spanner::admin::database::v1::GetDatabaseRequest* /*request*/, ::google::spanner::admin::database::v1::Database* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_UpdateDatabaseDdl : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_UpdateDatabaseDdl() {
      ::grpc::Service::MarkMethodCallback(3,
          new ::grpc::internal::CallbackUnaryHandler< ::google::spanner::admin::database::v1::UpdateDatabaseDdlRequest, ::google::longrunning::Operation>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::spanner::admin::database::v1::UpdateDatabaseDdlRequest* request, ::google::longrunning::Operation* response) { return this->UpdateDatabaseDdl(context, request, response); }));}
    void SetMessageAllocatorFor_UpdateDatabaseDdl(
        ::grpc::MessageAllocator< ::google::spanner::admin::database::v1::UpdateDatabaseDdlRequest, ::google::longrunning::Operation>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(3);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::spanner::admin::database::v1::UpdateDatabaseDdlRequest, ::google::longrunning::Operation>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_UpdateDatabaseDdl() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateDatabaseDdl(::grpc::ServerContext* /*context*/, const ::google::spanner::admin::database::v1::UpdateDatabaseDdlRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* UpdateDatabaseDdl(
      ::grpc::CallbackServerContext* /*context*/, const ::google::spanner::admin::database::v1::UpdateDatabaseDdlRequest* /*request*/, ::google::longrunning::Operation* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_DropDatabase : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_DropDatabase() {
      ::grpc::Service::MarkMethodCallback(4,
          new ::grpc::internal::CallbackUnaryHandler< ::google::spanner::admin::database::v1::DropDatabaseRequest, ::google::protobuf::Empty>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::spanner::admin::database::v1::DropDatabaseRequest* request, ::google::protobuf::Empty* response) { return this->DropDatabase(context, request, response); }));}
    void SetMessageAllocatorFor_DropDatabase(
        ::grpc::MessageAllocator< ::google::spanner::admin::database::v1::DropDatabaseRequest, ::google::protobuf::Empty>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(4);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::spanner::admin::database::v1::DropDatabaseRequest, ::google::protobuf::Empty>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_DropDatabase() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DropDatabase(::grpc::ServerContext* /*context*/, const ::google::spanner::admin::database::v1::DropDatabaseRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* DropDatabase(
      ::grpc::CallbackServerContext* /*context*/, const ::google::spanner::admin::database::v1::DropDatabaseRequest* /*request*/, ::google::protobuf::Empty* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_GetDatabaseDdl : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_GetDatabaseDdl() {
      ::grpc::Service::MarkMethodCallback(5,
          new ::grpc::internal::CallbackUnaryHandler< ::google::spanner::admin::database::v1::GetDatabaseDdlRequest, ::google::spanner::admin::database::v1::GetDatabaseDdlResponse>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::spanner::admin::database::v1::GetDatabaseDdlRequest* request, ::google::spanner::admin::database::v1::GetDatabaseDdlResponse* response) { return this->GetDatabaseDdl(context, request, response); }));}
    void SetMessageAllocatorFor_GetDatabaseDdl(
        ::grpc::MessageAllocator< ::google::spanner::admin::database::v1::GetDatabaseDdlRequest, ::google::spanner::admin::database::v1::GetDatabaseDdlResponse>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(5);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::spanner::admin::database::v1::GetDatabaseDdlRequest, ::google::spanner::admin::database::v1::GetDatabaseDdlResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_GetDatabaseDdl() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetDatabaseDdl(::grpc::ServerContext* /*context*/, const ::google::spanner::admin::database::v1::GetDatabaseDdlRequest* /*request*/, ::google::spanner::admin::database::v1::GetDatabaseDdlResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* GetDatabaseDdl(
      ::grpc::CallbackServerContext* /*context*/, const ::google::spanner::admin::database::v1::GetDatabaseDdlRequest* /*request*/, ::google::spanner::admin::database::v1::GetDatabaseDdlResponse* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_SetIamPolicy : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_SetIamPolicy() {
      ::grpc::Service::MarkMethodCallback(6,
          new ::grpc::internal::CallbackUnaryHandler< ::google::iam::v1::SetIamPolicyRequest, ::google::iam::v1::Policy>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::iam::v1::SetIamPolicyRequest* request, ::google::iam::v1::Policy* response) { return this->SetIamPolicy(context, request, response); }));}
    void SetMessageAllocatorFor_SetIamPolicy(
        ::grpc::MessageAllocator< ::google::iam::v1::SetIamPolicyRequest, ::google::iam::v1::Policy>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(6);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::iam::v1::SetIamPolicyRequest, ::google::iam::v1::Policy>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_SetIamPolicy() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status SetIamPolicy(::grpc::ServerContext* /*context*/, const ::google::iam::v1::SetIamPolicyRequest* /*request*/, ::google::iam::v1::Policy* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* SetIamPolicy(
      ::grpc::CallbackServerContext* /*context*/, const ::google::iam::v1::SetIamPolicyRequest* /*request*/, ::google::iam::v1::Policy* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_GetIamPolicy : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_GetIamPolicy() {
      ::grpc::Service::MarkMethodCallback(7,
          new ::grpc::internal::CallbackUnaryHandler< ::google::iam::v1::GetIamPolicyRequest, ::google::iam::v1::Policy>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::iam::v1::GetIamPolicyRequest* request, ::google::iam::v1::Policy* response) { return this->GetIamPolicy(context, request, response); }));}
    void SetMessageAllocatorFor_GetIamPolicy(
        ::grpc::MessageAllocator< ::google::iam::v1::GetIamPolicyRequest, ::google::iam::v1::Policy>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(7);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::iam::v1::GetIamPolicyRequest, ::google::iam::v1::Policy>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_GetIamPolicy() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetIamPolicy(::grpc::ServerContext* /*context*/, const ::google::iam::v1::GetIamPolicyRequest* /*request*/, ::google::iam::v1::Policy* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* GetIamPolicy(
      ::grpc::CallbackServerContext* /*context*/, const ::google::iam::v1::GetIamPolicyRequest* /*request*/, ::google::iam::v1::Policy* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_TestIamPermissions : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_TestIamPermissions() {
      ::grpc::Service::MarkMethodCallback(8,
          new ::grpc::internal::CallbackUnaryHandler< ::google::iam::v1::TestIamPermissionsRequest, ::google::iam::v1::TestIamPermissionsResponse>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::iam::v1::TestIamPermissionsRequest* request, ::google::iam::v1::TestIamPermissionsResponse* response) { return this->TestIamPermissions(context, request, response); }));}
    void SetMessageAllocatorFor_TestIamPermissions(
        ::grpc::MessageAllocator< ::google::iam::v1::TestIamPermissionsRequest, ::google::iam::v1::TestIamPermissionsResponse>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(8);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::iam::v1::TestIamPermissionsRequest, ::google::iam::v1::TestIamPermissionsResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_TestIamPermissions() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status TestIamPermissions(::grpc::ServerContext* /*context*/, const ::google::iam::v1::TestIamPermissionsRequest* /*request*/, ::google::iam::v1::TestIamPermissionsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* TestIamPermissions(
      ::grpc::CallbackServerContext* /*context*/, const ::google::iam::v1::TestIamPermissionsRequest* /*request*/, ::google::iam::v1::TestIamPermissionsResponse* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_CreateBackup : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_CreateBackup() {
      ::grpc::Service::MarkMethodCallback(9,
          new ::grpc::internal::CallbackUnaryHandler< ::google::spanner::admin::database::v1::CreateBackupRequest, ::google::longrunning::Operation>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::spanner::admin::database::v1::CreateBackupRequest* request, ::google::longrunning::Operation* response) { return this->CreateBackup(context, request, response); }));}
    void SetMessageAllocatorFor_CreateBackup(
        ::grpc::MessageAllocator< ::google::spanner::admin::database::v1::CreateBackupRequest, ::google::longrunning::Operation>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(9);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::spanner::admin::database::v1::CreateBackupRequest, ::google::longrunning::Operation>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_CreateBackup() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateBackup(::grpc::ServerContext* /*context*/, const ::google::spanner::admin::database::v1::CreateBackupRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* CreateBackup(
      ::grpc::CallbackServerContext* /*context*/, const ::google::spanner::admin::database::v1::CreateBackupRequest* /*request*/, ::google::longrunning::Operation* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_GetBackup : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_GetBackup() {
      ::grpc::Service::MarkMethodCallback(10,
          new ::grpc::internal::CallbackUnaryHandler< ::google::spanner::admin::database::v1::GetBackupRequest, ::google::spanner::admin::database::v1::Backup>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::spanner::admin::database::v1::GetBackupRequest* request, ::google::spanner::admin::database::v1::Backup* response) { return this->GetBackup(context, request, response); }));}
    void SetMessageAllocatorFor_GetBackup(
        ::grpc::MessageAllocator< ::google::spanner::admin::database::v1::GetBackupRequest, ::google::spanner::admin::database::v1::Backup>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(10);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::spanner::admin::database::v1::GetBackupRequest, ::google::spanner::admin::database::v1::Backup>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_GetBackup() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetBackup(::grpc::ServerContext* /*context*/, const ::google::spanner::admin::database::v1::GetBackupRequest* /*request*/, ::google::spanner::admin::database::v1::Backup* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* GetBackup(
      ::grpc::CallbackServerContext* /*context*/, const ::google::spanner::admin::database::v1::GetBackupRequest* /*request*/, ::google::spanner::admin::database::v1::Backup* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_UpdateBackup : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_UpdateBackup() {
      ::grpc::Service::MarkMethodCallback(11,
          new ::grpc::internal::CallbackUnaryHandler< ::google::spanner::admin::database::v1::UpdateBackupRequest, ::google::spanner::admin::database::v1::Backup>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::spanner::admin::database::v1::UpdateBackupRequest* request, ::google::spanner::admin::database::v1::Backup* response) { return this->UpdateBackup(context, request, response); }));}
    void SetMessageAllocatorFor_UpdateBackup(
        ::grpc::MessageAllocator< ::google::spanner::admin::database::v1::UpdateBackupRequest, ::google::spanner::admin::database::v1::Backup>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(11);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::spanner::admin::database::v1::UpdateBackupRequest, ::google::spanner::admin::database::v1::Backup>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_UpdateBackup() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateBackup(::grpc::ServerContext* /*context*/, const ::google::spanner::admin::database::v1::UpdateBackupRequest* /*request*/, ::google::spanner::admin::database::v1::Backup* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* UpdateBackup(
      ::grpc::CallbackServerContext* /*context*/, const ::google::spanner::admin::database::v1::UpdateBackupRequest* /*request*/, ::google::spanner::admin::database::v1::Backup* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_DeleteBackup : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_DeleteBackup() {
      ::grpc::Service::MarkMethodCallback(12,
          new ::grpc::internal::CallbackUnaryHandler< ::google::spanner::admin::database::v1::DeleteBackupRequest, ::google::protobuf::Empty>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::spanner::admin::database::v1::DeleteBackupRequest* request, ::google::protobuf::Empty* response) { return this->DeleteBackup(context, request, response); }));}
    void SetMessageAllocatorFor_DeleteBackup(
        ::grpc::MessageAllocator< ::google::spanner::admin::database::v1::DeleteBackupRequest, ::google::protobuf::Empty>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(12);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::spanner::admin::database::v1::DeleteBackupRequest, ::google::protobuf::Empty>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_DeleteBackup() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteBackup(::grpc::ServerContext* /*context*/, const ::google::spanner::admin::database::v1::DeleteBackupRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* DeleteBackup(
      ::grpc::CallbackServerContext* /*context*/, const ::google::spanner::admin::database::v1::DeleteBackupRequest* /*request*/, ::google::protobuf::Empty* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_ListBackups : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_ListBackups() {
      ::grpc::Service::MarkMethodCallback(13,
          new ::grpc::internal::CallbackUnaryHandler< ::google::spanner::admin::database::v1::ListBackupsRequest, ::google::spanner::admin::database::v1::ListBackupsResponse>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::spanner::admin::database::v1::ListBackupsRequest* request, ::google::spanner::admin::database::v1::ListBackupsResponse* response) { return this->ListBackups(context, request, response); }));}
    void SetMessageAllocatorFor_ListBackups(
        ::grpc::MessageAllocator< ::google::spanner::admin::database::v1::ListBackupsRequest, ::google::spanner::admin::database::v1::ListBackupsResponse>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(13);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::spanner::admin::database::v1::ListBackupsRequest, ::google::spanner::admin::database::v1::ListBackupsResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_ListBackups() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListBackups(::grpc::ServerContext* /*context*/, const ::google::spanner::admin::database::v1::ListBackupsRequest* /*request*/, ::google::spanner::admin::database::v1::ListBackupsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* ListBackups(
      ::grpc::CallbackServerContext* /*context*/, const ::google::spanner::admin::database::v1::ListBackupsRequest* /*request*/, ::google::spanner::admin::database::v1::ListBackupsResponse* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_RestoreDatabase : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_RestoreDatabase() {
      ::grpc::Service::MarkMethodCallback(14,
          new ::grpc::internal::CallbackUnaryHandler< ::google::spanner::admin::database::v1::RestoreDatabaseRequest, ::google::longrunning::Operation>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::spanner::admin::database::v1::RestoreDatabaseRequest* request, ::google::longrunning::Operation* response) { return this->RestoreDatabase(context, request, response); }));}
    void SetMessageAllocatorFor_RestoreDatabase(
        ::grpc::MessageAllocator< ::google::spanner::admin::database::v1::RestoreDatabaseRequest, ::google::longrunning::Operation>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(14);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::spanner::admin::database::v1::RestoreDatabaseRequest, ::google::longrunning::Operation>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_RestoreDatabase() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status RestoreDatabase(::grpc::ServerContext* /*context*/, const ::google::spanner::admin::database::v1::RestoreDatabaseRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* RestoreDatabase(
      ::grpc::CallbackServerContext* /*context*/, const ::google::spanner::admin::database::v1::RestoreDatabaseRequest* /*request*/, ::google::longrunning::Operation* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_ListDatabaseOperations : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_ListDatabaseOperations() {
      ::grpc::Service::MarkMethodCallback(15,
          new ::grpc::internal::CallbackUnaryHandler< ::google::spanner::admin::database::v1::ListDatabaseOperationsRequest, ::google::spanner::admin::database::v1::ListDatabaseOperationsResponse>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::spanner::admin::database::v1::ListDatabaseOperationsRequest* request, ::google::spanner::admin::database::v1::ListDatabaseOperationsResponse* response) { return this->ListDatabaseOperations(context, request, response); }));}
    void SetMessageAllocatorFor_ListDatabaseOperations(
        ::grpc::MessageAllocator< ::google::spanner::admin::database::v1::ListDatabaseOperationsRequest, ::google::spanner::admin::database::v1::ListDatabaseOperationsResponse>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(15);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::spanner::admin::database::v1::ListDatabaseOperationsRequest, ::google::spanner::admin::database::v1::ListDatabaseOperationsResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_ListDatabaseOperations() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListDatabaseOperations(::grpc::ServerContext* /*context*/, const ::google::spanner::admin::database::v1::ListDatabaseOperationsRequest* /*request*/, ::google::spanner::admin::database::v1::ListDatabaseOperationsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* ListDatabaseOperations(
      ::grpc::CallbackServerContext* /*context*/, const ::google::spanner::admin::database::v1::ListDatabaseOperationsRequest* /*request*/, ::google::spanner::admin::database::v1::ListDatabaseOperationsResponse* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithCallbackMethod_ListBackupOperations : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithCallbackMethod_ListBackupOperations() {
      ::grpc::Service::MarkMethodCallback(16,
          new ::grpc::internal::CallbackUnaryHandler< ::google::spanner::admin::database::v1::ListBackupOperationsRequest, ::google::spanner::admin::database::v1::ListBackupOperationsResponse>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::google::spanner::admin::database::v1::ListBackupOperationsRequest* request, ::google::spanner::admin::database::v1::ListBackupOperationsResponse* response) { return this->ListBackupOperations(context, request, response); }));}
    void SetMessageAllocatorFor_ListBackupOperations(
        ::grpc::MessageAllocator< ::google::spanner::admin::database::v1::ListBackupOperationsRequest, ::google::spanner::admin::database::v1::ListBackupOperationsResponse>* allocator) {
      ::grpc::internal::MethodHandler* const handler = ::grpc::Service::GetHandler(16);
      static_cast<::grpc::internal::CallbackUnaryHandler< ::google::spanner::admin::database::v1::ListBackupOperationsRequest, ::google::spanner::admin::database::v1::ListBackupOperationsResponse>*>(handler)
              ->SetMessageAllocator(allocator);
    }
    ~WithCallbackMethod_ListBackupOperations() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListBackupOperations(::grpc::ServerContext* /*context*/, const ::google::spanner::admin::database::v1::ListBackupOperationsRequest* /*request*/, ::google::spanner::admin::database::v1::ListBackupOperationsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* ListBackupOperations(
      ::grpc::CallbackServerContext* /*context*/, const ::google::spanner::admin::database::v1::ListBackupOperationsRequest* /*request*/, ::google::spanner::admin::database::v1::ListBackupOperationsResponse* /*response*/)  { return nullptr; }
  };
  typedef WithCallbackMethod_ListDatabases<WithCallbackMethod_CreateDatabase<WithCallbackMethod_GetDatabase<WithCallbackMethod_UpdateDatabaseDdl<WithCallbackMethod_DropDatabase<WithCallbackMethod_GetDatabaseDdl<WithCallbackMethod_SetIamPolicy<WithCallbackMethod_GetIamPolicy<WithCallbackMethod_TestIamPermissions<WithCallbackMethod_CreateBackup<WithCallbackMethod_GetBackup<WithCallbackMethod_UpdateBackup<WithCallbackMethod_DeleteBackup<WithCallbackMethod_ListBackups<WithCallbackMethod_RestoreDatabase<WithCallbackMethod_ListDatabaseOperations<WithCallbackMethod_ListBackupOperations<Service > > > > > > > > > > > > > > > > > CallbackService;
  typedef CallbackService ExperimentalCallbackService;
  template <class BaseClass>
  class WithGenericMethod_ListDatabases : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_ListDatabases() {
      ::grpc::Service::MarkMethodGeneric(0);
    }
    ~WithGenericMethod_ListDatabases() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListDatabases(::grpc::ServerContext* /*context*/, const ::google::spanner::admin::database::v1::ListDatabasesRequest* /*request*/, ::google::spanner::admin::database::v1::ListDatabasesResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_CreateDatabase : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_CreateDatabase() {
      ::grpc::Service::MarkMethodGeneric(1);
    }
    ~WithGenericMethod_CreateDatabase() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateDatabase(::grpc::ServerContext* /*context*/, const ::google::spanner::admin::database::v1::CreateDatabaseRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_GetDatabase : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_GetDatabase() {
      ::grpc::Service::MarkMethodGeneric(2);
    }
    ~WithGenericMethod_GetDatabase() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetDatabase(::grpc::ServerContext* /*context*/, const ::google::spanner::admin::database::v1::GetDatabaseRequest* /*request*/, ::google::spanner::admin::database::v1::Database* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_UpdateDatabaseDdl : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_UpdateDatabaseDdl() {
      ::grpc::Service::MarkMethodGeneric(3);
    }
    ~WithGenericMethod_UpdateDatabaseDdl() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateDatabaseDdl(::grpc::ServerContext* /*context*/, const ::google::spanner::admin::database::v1::UpdateDatabaseDdlRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_DropDatabase : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_DropDatabase() {
      ::grpc::Service::MarkMethodGeneric(4);
    }
    ~WithGenericMethod_DropDatabase() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DropDatabase(::grpc::ServerContext* /*context*/, const ::google::spanner::admin::database::v1::DropDatabaseRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_GetDatabaseDdl : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_GetDatabaseDdl() {
      ::grpc::Service::MarkMethodGeneric(5);
    }
    ~WithGenericMethod_GetDatabaseDdl() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetDatabaseDdl(::grpc::ServerContext* /*context*/, const ::google::spanner::admin::database::v1::GetDatabaseDdlRequest* /*request*/, ::google::spanner::admin::database::v1::GetDatabaseDdlResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_SetIamPolicy : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_SetIamPolicy() {
      ::grpc::Service::MarkMethodGeneric(6);
    }
    ~WithGenericMethod_SetIamPolicy() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status SetIamPolicy(::grpc::ServerContext* /*context*/, const ::google::iam::v1::SetIamPolicyRequest* /*request*/, ::google::iam::v1::Policy* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_GetIamPolicy : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_GetIamPolicy() {
      ::grpc::Service::MarkMethodGeneric(7);
    }
    ~WithGenericMethod_GetIamPolicy() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetIamPolicy(::grpc::ServerContext* /*context*/, const ::google::iam::v1::GetIamPolicyRequest* /*request*/, ::google::iam::v1::Policy* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_TestIamPermissions : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_TestIamPermissions() {
      ::grpc::Service::MarkMethodGeneric(8);
    }
    ~WithGenericMethod_TestIamPermissions() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status TestIamPermissions(::grpc::ServerContext* /*context*/, const ::google::iam::v1::TestIamPermissionsRequest* /*request*/, ::google::iam::v1::TestIamPermissionsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_CreateBackup : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_CreateBackup() {
      ::grpc::Service::MarkMethodGeneric(9);
    }
    ~WithGenericMethod_CreateBackup() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateBackup(::grpc::ServerContext* /*context*/, const ::google::spanner::admin::database::v1::CreateBackupRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_GetBackup : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_GetBackup() {
      ::grpc::Service::MarkMethodGeneric(10);
    }
    ~WithGenericMethod_GetBackup() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetBackup(::grpc::ServerContext* /*context*/, const ::google::spanner::admin::database::v1::GetBackupRequest* /*request*/, ::google::spanner::admin::database::v1::Backup* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_UpdateBackup : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_UpdateBackup() {
      ::grpc::Service::MarkMethodGeneric(11);
    }
    ~WithGenericMethod_UpdateBackup() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateBackup(::grpc::ServerContext* /*context*/, const ::google::spanner::admin::database::v1::UpdateBackupRequest* /*request*/, ::google::spanner::admin::database::v1::Backup* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_DeleteBackup : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_DeleteBackup() {
      ::grpc::Service::MarkMethodGeneric(12);
    }
    ~WithGenericMethod_DeleteBackup() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteBackup(::grpc::ServerContext* /*context*/, const ::google::spanner::admin::database::v1::DeleteBackupRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_ListBackups : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_ListBackups() {
      ::grpc::Service::MarkMethodGeneric(13);
    }
    ~WithGenericMethod_ListBackups() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListBackups(::grpc::ServerContext* /*context*/, const ::google::spanner::admin::database::v1::ListBackupsRequest* /*request*/, ::google::spanner::admin::database::v1::ListBackupsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_RestoreDatabase : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_RestoreDatabase() {
      ::grpc::Service::MarkMethodGeneric(14);
    }
    ~WithGenericMethod_RestoreDatabase() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status RestoreDatabase(::grpc::ServerContext* /*context*/, const ::google::spanner::admin::database::v1::RestoreDatabaseRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_ListDatabaseOperations : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_ListDatabaseOperations() {
      ::grpc::Service::MarkMethodGeneric(15);
    }
    ~WithGenericMethod_ListDatabaseOperations() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListDatabaseOperations(::grpc::ServerContext* /*context*/, const ::google::spanner::admin::database::v1::ListDatabaseOperationsRequest* /*request*/, ::google::spanner::admin::database::v1::ListDatabaseOperationsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithGenericMethod_ListBackupOperations : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithGenericMethod_ListBackupOperations() {
      ::grpc::Service::MarkMethodGeneric(16);
    }
    ~WithGenericMethod_ListBackupOperations() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListBackupOperations(::grpc::ServerContext* /*context*/, const ::google::spanner::admin::database::v1::ListBackupOperationsRequest* /*request*/, ::google::spanner::admin::database::v1::ListBackupOperationsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
  };
  template <class BaseClass>
  class WithRawMethod_ListDatabases : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_ListDatabases() {
      ::grpc::Service::MarkMethodRaw(0);
    }
    ~WithRawMethod_ListDatabases() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListDatabases(::grpc::ServerContext* /*context*/, const ::google::spanner::admin::database::v1::ListDatabasesRequest* /*request*/, ::google::spanner::admin::database::v1::ListDatabasesResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestListDatabases(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(0, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_CreateDatabase : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_CreateDatabase() {
      ::grpc::Service::MarkMethodRaw(1);
    }
    ~WithRawMethod_CreateDatabase() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateDatabase(::grpc::ServerContext* /*context*/, const ::google::spanner::admin::database::v1::CreateDatabaseRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestCreateDatabase(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(1, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_GetDatabase : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_GetDatabase() {
      ::grpc::Service::MarkMethodRaw(2);
    }
    ~WithRawMethod_GetDatabase() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetDatabase(::grpc::ServerContext* /*context*/, const ::google::spanner::admin::database::v1::GetDatabaseRequest* /*request*/, ::google::spanner::admin::database::v1::Database* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGetDatabase(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(2, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_UpdateDatabaseDdl : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_UpdateDatabaseDdl() {
      ::grpc::Service::MarkMethodRaw(3);
    }
    ~WithRawMethod_UpdateDatabaseDdl() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateDatabaseDdl(::grpc::ServerContext* /*context*/, const ::google::spanner::admin::database::v1::UpdateDatabaseDdlRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestUpdateDatabaseDdl(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(3, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_DropDatabase : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_DropDatabase() {
      ::grpc::Service::MarkMethodRaw(4);
    }
    ~WithRawMethod_DropDatabase() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DropDatabase(::grpc::ServerContext* /*context*/, const ::google::spanner::admin::database::v1::DropDatabaseRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestDropDatabase(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(4, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_GetDatabaseDdl : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_GetDatabaseDdl() {
      ::grpc::Service::MarkMethodRaw(5);
    }
    ~WithRawMethod_GetDatabaseDdl() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetDatabaseDdl(::grpc::ServerContext* /*context*/, const ::google::spanner::admin::database::v1::GetDatabaseDdlRequest* /*request*/, ::google::spanner::admin::database::v1::GetDatabaseDdlResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGetDatabaseDdl(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(5, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_SetIamPolicy : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_SetIamPolicy() {
      ::grpc::Service::MarkMethodRaw(6);
    }
    ~WithRawMethod_SetIamPolicy() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status SetIamPolicy(::grpc::ServerContext* /*context*/, const ::google::iam::v1::SetIamPolicyRequest* /*request*/, ::google::iam::v1::Policy* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestSetIamPolicy(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(6, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_GetIamPolicy : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_GetIamPolicy() {
      ::grpc::Service::MarkMethodRaw(7);
    }
    ~WithRawMethod_GetIamPolicy() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetIamPolicy(::grpc::ServerContext* /*context*/, const ::google::iam::v1::GetIamPolicyRequest* /*request*/, ::google::iam::v1::Policy* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGetIamPolicy(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(7, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_TestIamPermissions : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_TestIamPermissions() {
      ::grpc::Service::MarkMethodRaw(8);
    }
    ~WithRawMethod_TestIamPermissions() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status TestIamPermissions(::grpc::ServerContext* /*context*/, const ::google::iam::v1::TestIamPermissionsRequest* /*request*/, ::google::iam::v1::TestIamPermissionsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestTestIamPermissions(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(8, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_CreateBackup : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_CreateBackup() {
      ::grpc::Service::MarkMethodRaw(9);
    }
    ~WithRawMethod_CreateBackup() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateBackup(::grpc::ServerContext* /*context*/, const ::google::spanner::admin::database::v1::CreateBackupRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestCreateBackup(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(9, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_GetBackup : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_GetBackup() {
      ::grpc::Service::MarkMethodRaw(10);
    }
    ~WithRawMethod_GetBackup() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetBackup(::grpc::ServerContext* /*context*/, const ::google::spanner::admin::database::v1::GetBackupRequest* /*request*/, ::google::spanner::admin::database::v1::Backup* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestGetBackup(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(10, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_UpdateBackup : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_UpdateBackup() {
      ::grpc::Service::MarkMethodRaw(11);
    }
    ~WithRawMethod_UpdateBackup() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateBackup(::grpc::ServerContext* /*context*/, const ::google::spanner::admin::database::v1::UpdateBackupRequest* /*request*/, ::google::spanner::admin::database::v1::Backup* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestUpdateBackup(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(11, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_DeleteBackup : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_DeleteBackup() {
      ::grpc::Service::MarkMethodRaw(12);
    }
    ~WithRawMethod_DeleteBackup() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteBackup(::grpc::ServerContext* /*context*/, const ::google::spanner::admin::database::v1::DeleteBackupRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestDeleteBackup(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(12, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_ListBackups : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_ListBackups() {
      ::grpc::Service::MarkMethodRaw(13);
    }
    ~WithRawMethod_ListBackups() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListBackups(::grpc::ServerContext* /*context*/, const ::google::spanner::admin::database::v1::ListBackupsRequest* /*request*/, ::google::spanner::admin::database::v1::ListBackupsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestListBackups(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(13, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_RestoreDatabase : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_RestoreDatabase() {
      ::grpc::Service::MarkMethodRaw(14);
    }
    ~WithRawMethod_RestoreDatabase() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status RestoreDatabase(::grpc::ServerContext* /*context*/, const ::google::spanner::admin::database::v1::RestoreDatabaseRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestRestoreDatabase(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(14, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_ListDatabaseOperations : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_ListDatabaseOperations() {
      ::grpc::Service::MarkMethodRaw(15);
    }
    ~WithRawMethod_ListDatabaseOperations() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListDatabaseOperations(::grpc::ServerContext* /*context*/, const ::google::spanner::admin::database::v1::ListDatabaseOperationsRequest* /*request*/, ::google::spanner::admin::database::v1::ListDatabaseOperationsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestListDatabaseOperations(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(15, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawMethod_ListBackupOperations : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawMethod_ListBackupOperations() {
      ::grpc::Service::MarkMethodRaw(16);
    }
    ~WithRawMethod_ListBackupOperations() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListBackupOperations(::grpc::ServerContext* /*context*/, const ::google::spanner::admin::database::v1::ListBackupOperationsRequest* /*request*/, ::google::spanner::admin::database::v1::ListBackupOperationsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    void RequestListBackupOperations(::grpc::ServerContext* context, ::grpc::ByteBuffer* request, ::grpc::ServerAsyncResponseWriter< ::grpc::ByteBuffer>* response, ::grpc::CompletionQueue* new_call_cq, ::grpc::ServerCompletionQueue* notification_cq, void *tag) {
      ::grpc::Service::RequestAsyncUnary(16, context, request, response, new_call_cq, notification_cq, tag);
    }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_ListDatabases : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_ListDatabases() {
      ::grpc::Service::MarkMethodRawCallback(0,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->ListDatabases(context, request, response); }));
    }
    ~WithRawCallbackMethod_ListDatabases() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListDatabases(::grpc::ServerContext* /*context*/, const ::google::spanner::admin::database::v1::ListDatabasesRequest* /*request*/, ::google::spanner::admin::database::v1::ListDatabasesResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* ListDatabases(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_CreateDatabase : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_CreateDatabase() {
      ::grpc::Service::MarkMethodRawCallback(1,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->CreateDatabase(context, request, response); }));
    }
    ~WithRawCallbackMethod_CreateDatabase() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateDatabase(::grpc::ServerContext* /*context*/, const ::google::spanner::admin::database::v1::CreateDatabaseRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* CreateDatabase(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_GetDatabase : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_GetDatabase() {
      ::grpc::Service::MarkMethodRawCallback(2,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->GetDatabase(context, request, response); }));
    }
    ~WithRawCallbackMethod_GetDatabase() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetDatabase(::grpc::ServerContext* /*context*/, const ::google::spanner::admin::database::v1::GetDatabaseRequest* /*request*/, ::google::spanner::admin::database::v1::Database* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* GetDatabase(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_UpdateDatabaseDdl : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_UpdateDatabaseDdl() {
      ::grpc::Service::MarkMethodRawCallback(3,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->UpdateDatabaseDdl(context, request, response); }));
    }
    ~WithRawCallbackMethod_UpdateDatabaseDdl() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateDatabaseDdl(::grpc::ServerContext* /*context*/, const ::google::spanner::admin::database::v1::UpdateDatabaseDdlRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* UpdateDatabaseDdl(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_DropDatabase : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_DropDatabase() {
      ::grpc::Service::MarkMethodRawCallback(4,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->DropDatabase(context, request, response); }));
    }
    ~WithRawCallbackMethod_DropDatabase() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DropDatabase(::grpc::ServerContext* /*context*/, const ::google::spanner::admin::database::v1::DropDatabaseRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* DropDatabase(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_GetDatabaseDdl : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_GetDatabaseDdl() {
      ::grpc::Service::MarkMethodRawCallback(5,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->GetDatabaseDdl(context, request, response); }));
    }
    ~WithRawCallbackMethod_GetDatabaseDdl() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetDatabaseDdl(::grpc::ServerContext* /*context*/, const ::google::spanner::admin::database::v1::GetDatabaseDdlRequest* /*request*/, ::google::spanner::admin::database::v1::GetDatabaseDdlResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* GetDatabaseDdl(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_SetIamPolicy : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_SetIamPolicy() {
      ::grpc::Service::MarkMethodRawCallback(6,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->SetIamPolicy(context, request, response); }));
    }
    ~WithRawCallbackMethod_SetIamPolicy() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status SetIamPolicy(::grpc::ServerContext* /*context*/, const ::google::iam::v1::SetIamPolicyRequest* /*request*/, ::google::iam::v1::Policy* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* SetIamPolicy(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_GetIamPolicy : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_GetIamPolicy() {
      ::grpc::Service::MarkMethodRawCallback(7,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->GetIamPolicy(context, request, response); }));
    }
    ~WithRawCallbackMethod_GetIamPolicy() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetIamPolicy(::grpc::ServerContext* /*context*/, const ::google::iam::v1::GetIamPolicyRequest* /*request*/, ::google::iam::v1::Policy* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* GetIamPolicy(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_TestIamPermissions : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_TestIamPermissions() {
      ::grpc::Service::MarkMethodRawCallback(8,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->TestIamPermissions(context, request, response); }));
    }
    ~WithRawCallbackMethod_TestIamPermissions() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status TestIamPermissions(::grpc::ServerContext* /*context*/, const ::google::iam::v1::TestIamPermissionsRequest* /*request*/, ::google::iam::v1::TestIamPermissionsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* TestIamPermissions(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_CreateBackup : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_CreateBackup() {
      ::grpc::Service::MarkMethodRawCallback(9,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->CreateBackup(context, request, response); }));
    }
    ~WithRawCallbackMethod_CreateBackup() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status CreateBackup(::grpc::ServerContext* /*context*/, const ::google::spanner::admin::database::v1::CreateBackupRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* CreateBackup(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_GetBackup : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_GetBackup() {
      ::grpc::Service::MarkMethodRawCallback(10,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->GetBackup(context, request, response); }));
    }
    ~WithRawCallbackMethod_GetBackup() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status GetBackup(::grpc::ServerContext* /*context*/, const ::google::spanner::admin::database::v1::GetBackupRequest* /*request*/, ::google::spanner::admin::database::v1::Backup* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* GetBackup(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_UpdateBackup : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_UpdateBackup() {
      ::grpc::Service::MarkMethodRawCallback(11,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->UpdateBackup(context, request, response); }));
    }
    ~WithRawCallbackMethod_UpdateBackup() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status UpdateBackup(::grpc::ServerContext* /*context*/, const ::google::spanner::admin::database::v1::UpdateBackupRequest* /*request*/, ::google::spanner::admin::database::v1::Backup* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* UpdateBackup(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_DeleteBackup : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_DeleteBackup() {
      ::grpc::Service::MarkMethodRawCallback(12,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->DeleteBackup(context, request, response); }));
    }
    ~WithRawCallbackMethod_DeleteBackup() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status DeleteBackup(::grpc::ServerContext* /*context*/, const ::google::spanner::admin::database::v1::DeleteBackupRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* DeleteBackup(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_ListBackups : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_ListBackups() {
      ::grpc::Service::MarkMethodRawCallback(13,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->ListBackups(context, request, response); }));
    }
    ~WithRawCallbackMethod_ListBackups() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListBackups(::grpc::ServerContext* /*context*/, const ::google::spanner::admin::database::v1::ListBackupsRequest* /*request*/, ::google::spanner::admin::database::v1::ListBackupsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* ListBackups(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_RestoreDatabase : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_RestoreDatabase() {
      ::grpc::Service::MarkMethodRawCallback(14,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->RestoreDatabase(context, request, response); }));
    }
    ~WithRawCallbackMethod_RestoreDatabase() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status RestoreDatabase(::grpc::ServerContext* /*context*/, const ::google::spanner::admin::database::v1::RestoreDatabaseRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* RestoreDatabase(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_ListDatabaseOperations : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_ListDatabaseOperations() {
      ::grpc::Service::MarkMethodRawCallback(15,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->ListDatabaseOperations(context, request, response); }));
    }
    ~WithRawCallbackMethod_ListDatabaseOperations() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListDatabaseOperations(::grpc::ServerContext* /*context*/, const ::google::spanner::admin::database::v1::ListDatabaseOperationsRequest* /*request*/, ::google::spanner::admin::database::v1::ListDatabaseOperationsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* ListDatabaseOperations(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithRawCallbackMethod_ListBackupOperations : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithRawCallbackMethod_ListBackupOperations() {
      ::grpc::Service::MarkMethodRawCallback(16,
          new ::grpc::internal::CallbackUnaryHandler< ::grpc::ByteBuffer, ::grpc::ByteBuffer>(
            [this](
                   ::grpc::CallbackServerContext* context, const ::grpc::ByteBuffer* request, ::grpc::ByteBuffer* response) { return this->ListBackupOperations(context, request, response); }));
    }
    ~WithRawCallbackMethod_ListBackupOperations() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable synchronous version of this method
    ::grpc::Status ListBackupOperations(::grpc::ServerContext* /*context*/, const ::google::spanner::admin::database::v1::ListBackupOperationsRequest* /*request*/, ::google::spanner::admin::database::v1::ListBackupOperationsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    virtual ::grpc::ServerUnaryReactor* ListBackupOperations(
      ::grpc::CallbackServerContext* /*context*/, const ::grpc::ByteBuffer* /*request*/, ::grpc::ByteBuffer* /*response*/)  { return nullptr; }
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_ListDatabases : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_ListDatabases() {
      ::grpc::Service::MarkMethodStreamed(0,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::spanner::admin::database::v1::ListDatabasesRequest, ::google::spanner::admin::database::v1::ListDatabasesResponse>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::spanner::admin::database::v1::ListDatabasesRequest, ::google::spanner::admin::database::v1::ListDatabasesResponse>* streamer) {
                       return this->StreamedListDatabases(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_ListDatabases() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status ListDatabases(::grpc::ServerContext* /*context*/, const ::google::spanner::admin::database::v1::ListDatabasesRequest* /*request*/, ::google::spanner::admin::database::v1::ListDatabasesResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedListDatabases(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::spanner::admin::database::v1::ListDatabasesRequest,::google::spanner::admin::database::v1::ListDatabasesResponse>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_CreateDatabase : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_CreateDatabase() {
      ::grpc::Service::MarkMethodStreamed(1,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::spanner::admin::database::v1::CreateDatabaseRequest, ::google::longrunning::Operation>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::spanner::admin::database::v1::CreateDatabaseRequest, ::google::longrunning::Operation>* streamer) {
                       return this->StreamedCreateDatabase(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_CreateDatabase() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status CreateDatabase(::grpc::ServerContext* /*context*/, const ::google::spanner::admin::database::v1::CreateDatabaseRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedCreateDatabase(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::spanner::admin::database::v1::CreateDatabaseRequest,::google::longrunning::Operation>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_GetDatabase : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_GetDatabase() {
      ::grpc::Service::MarkMethodStreamed(2,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::spanner::admin::database::v1::GetDatabaseRequest, ::google::spanner::admin::database::v1::Database>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::spanner::admin::database::v1::GetDatabaseRequest, ::google::spanner::admin::database::v1::Database>* streamer) {
                       return this->StreamedGetDatabase(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_GetDatabase() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status GetDatabase(::grpc::ServerContext* /*context*/, const ::google::spanner::admin::database::v1::GetDatabaseRequest* /*request*/, ::google::spanner::admin::database::v1::Database* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedGetDatabase(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::spanner::admin::database::v1::GetDatabaseRequest,::google::spanner::admin::database::v1::Database>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_UpdateDatabaseDdl : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_UpdateDatabaseDdl() {
      ::grpc::Service::MarkMethodStreamed(3,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::spanner::admin::database::v1::UpdateDatabaseDdlRequest, ::google::longrunning::Operation>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::spanner::admin::database::v1::UpdateDatabaseDdlRequest, ::google::longrunning::Operation>* streamer) {
                       return this->StreamedUpdateDatabaseDdl(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_UpdateDatabaseDdl() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status UpdateDatabaseDdl(::grpc::ServerContext* /*context*/, const ::google::spanner::admin::database::v1::UpdateDatabaseDdlRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedUpdateDatabaseDdl(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::spanner::admin::database::v1::UpdateDatabaseDdlRequest,::google::longrunning::Operation>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_DropDatabase : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_DropDatabase() {
      ::grpc::Service::MarkMethodStreamed(4,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::spanner::admin::database::v1::DropDatabaseRequest, ::google::protobuf::Empty>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::spanner::admin::database::v1::DropDatabaseRequest, ::google::protobuf::Empty>* streamer) {
                       return this->StreamedDropDatabase(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_DropDatabase() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status DropDatabase(::grpc::ServerContext* /*context*/, const ::google::spanner::admin::database::v1::DropDatabaseRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedDropDatabase(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::spanner::admin::database::v1::DropDatabaseRequest,::google::protobuf::Empty>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_GetDatabaseDdl : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_GetDatabaseDdl() {
      ::grpc::Service::MarkMethodStreamed(5,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::spanner::admin::database::v1::GetDatabaseDdlRequest, ::google::spanner::admin::database::v1::GetDatabaseDdlResponse>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::spanner::admin::database::v1::GetDatabaseDdlRequest, ::google::spanner::admin::database::v1::GetDatabaseDdlResponse>* streamer) {
                       return this->StreamedGetDatabaseDdl(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_GetDatabaseDdl() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status GetDatabaseDdl(::grpc::ServerContext* /*context*/, const ::google::spanner::admin::database::v1::GetDatabaseDdlRequest* /*request*/, ::google::spanner::admin::database::v1::GetDatabaseDdlResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedGetDatabaseDdl(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::spanner::admin::database::v1::GetDatabaseDdlRequest,::google::spanner::admin::database::v1::GetDatabaseDdlResponse>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_SetIamPolicy : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_SetIamPolicy() {
      ::grpc::Service::MarkMethodStreamed(6,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::iam::v1::SetIamPolicyRequest, ::google::iam::v1::Policy>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::iam::v1::SetIamPolicyRequest, ::google::iam::v1::Policy>* streamer) {
                       return this->StreamedSetIamPolicy(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_SetIamPolicy() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status SetIamPolicy(::grpc::ServerContext* /*context*/, const ::google::iam::v1::SetIamPolicyRequest* /*request*/, ::google::iam::v1::Policy* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedSetIamPolicy(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::iam::v1::SetIamPolicyRequest,::google::iam::v1::Policy>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_GetIamPolicy : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_GetIamPolicy() {
      ::grpc::Service::MarkMethodStreamed(7,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::iam::v1::GetIamPolicyRequest, ::google::iam::v1::Policy>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::iam::v1::GetIamPolicyRequest, ::google::iam::v1::Policy>* streamer) {
                       return this->StreamedGetIamPolicy(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_GetIamPolicy() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status GetIamPolicy(::grpc::ServerContext* /*context*/, const ::google::iam::v1::GetIamPolicyRequest* /*request*/, ::google::iam::v1::Policy* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedGetIamPolicy(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::iam::v1::GetIamPolicyRequest,::google::iam::v1::Policy>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_TestIamPermissions : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_TestIamPermissions() {
      ::grpc::Service::MarkMethodStreamed(8,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::iam::v1::TestIamPermissionsRequest, ::google::iam::v1::TestIamPermissionsResponse>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::iam::v1::TestIamPermissionsRequest, ::google::iam::v1::TestIamPermissionsResponse>* streamer) {
                       return this->StreamedTestIamPermissions(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_TestIamPermissions() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status TestIamPermissions(::grpc::ServerContext* /*context*/, const ::google::iam::v1::TestIamPermissionsRequest* /*request*/, ::google::iam::v1::TestIamPermissionsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedTestIamPermissions(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::iam::v1::TestIamPermissionsRequest,::google::iam::v1::TestIamPermissionsResponse>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_CreateBackup : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_CreateBackup() {
      ::grpc::Service::MarkMethodStreamed(9,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::spanner::admin::database::v1::CreateBackupRequest, ::google::longrunning::Operation>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::spanner::admin::database::v1::CreateBackupRequest, ::google::longrunning::Operation>* streamer) {
                       return this->StreamedCreateBackup(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_CreateBackup() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status CreateBackup(::grpc::ServerContext* /*context*/, const ::google::spanner::admin::database::v1::CreateBackupRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedCreateBackup(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::spanner::admin::database::v1::CreateBackupRequest,::google::longrunning::Operation>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_GetBackup : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_GetBackup() {
      ::grpc::Service::MarkMethodStreamed(10,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::spanner::admin::database::v1::GetBackupRequest, ::google::spanner::admin::database::v1::Backup>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::spanner::admin::database::v1::GetBackupRequest, ::google::spanner::admin::database::v1::Backup>* streamer) {
                       return this->StreamedGetBackup(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_GetBackup() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status GetBackup(::grpc::ServerContext* /*context*/, const ::google::spanner::admin::database::v1::GetBackupRequest* /*request*/, ::google::spanner::admin::database::v1::Backup* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedGetBackup(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::spanner::admin::database::v1::GetBackupRequest,::google::spanner::admin::database::v1::Backup>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_UpdateBackup : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_UpdateBackup() {
      ::grpc::Service::MarkMethodStreamed(11,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::spanner::admin::database::v1::UpdateBackupRequest, ::google::spanner::admin::database::v1::Backup>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::spanner::admin::database::v1::UpdateBackupRequest, ::google::spanner::admin::database::v1::Backup>* streamer) {
                       return this->StreamedUpdateBackup(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_UpdateBackup() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status UpdateBackup(::grpc::ServerContext* /*context*/, const ::google::spanner::admin::database::v1::UpdateBackupRequest* /*request*/, ::google::spanner::admin::database::v1::Backup* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedUpdateBackup(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::spanner::admin::database::v1::UpdateBackupRequest,::google::spanner::admin::database::v1::Backup>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_DeleteBackup : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_DeleteBackup() {
      ::grpc::Service::MarkMethodStreamed(12,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::spanner::admin::database::v1::DeleteBackupRequest, ::google::protobuf::Empty>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::spanner::admin::database::v1::DeleteBackupRequest, ::google::protobuf::Empty>* streamer) {
                       return this->StreamedDeleteBackup(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_DeleteBackup() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status DeleteBackup(::grpc::ServerContext* /*context*/, const ::google::spanner::admin::database::v1::DeleteBackupRequest* /*request*/, ::google::protobuf::Empty* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedDeleteBackup(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::spanner::admin::database::v1::DeleteBackupRequest,::google::protobuf::Empty>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_ListBackups : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_ListBackups() {
      ::grpc::Service::MarkMethodStreamed(13,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::spanner::admin::database::v1::ListBackupsRequest, ::google::spanner::admin::database::v1::ListBackupsResponse>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::spanner::admin::database::v1::ListBackupsRequest, ::google::spanner::admin::database::v1::ListBackupsResponse>* streamer) {
                       return this->StreamedListBackups(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_ListBackups() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status ListBackups(::grpc::ServerContext* /*context*/, const ::google::spanner::admin::database::v1::ListBackupsRequest* /*request*/, ::google::spanner::admin::database::v1::ListBackupsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedListBackups(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::spanner::admin::database::v1::ListBackupsRequest,::google::spanner::admin::database::v1::ListBackupsResponse>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_RestoreDatabase : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_RestoreDatabase() {
      ::grpc::Service::MarkMethodStreamed(14,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::spanner::admin::database::v1::RestoreDatabaseRequest, ::google::longrunning::Operation>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::spanner::admin::database::v1::RestoreDatabaseRequest, ::google::longrunning::Operation>* streamer) {
                       return this->StreamedRestoreDatabase(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_RestoreDatabase() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status RestoreDatabase(::grpc::ServerContext* /*context*/, const ::google::spanner::admin::database::v1::RestoreDatabaseRequest* /*request*/, ::google::longrunning::Operation* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedRestoreDatabase(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::spanner::admin::database::v1::RestoreDatabaseRequest,::google::longrunning::Operation>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_ListDatabaseOperations : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_ListDatabaseOperations() {
      ::grpc::Service::MarkMethodStreamed(15,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::spanner::admin::database::v1::ListDatabaseOperationsRequest, ::google::spanner::admin::database::v1::ListDatabaseOperationsResponse>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::spanner::admin::database::v1::ListDatabaseOperationsRequest, ::google::spanner::admin::database::v1::ListDatabaseOperationsResponse>* streamer) {
                       return this->StreamedListDatabaseOperations(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_ListDatabaseOperations() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status ListDatabaseOperations(::grpc::ServerContext* /*context*/, const ::google::spanner::admin::database::v1::ListDatabaseOperationsRequest* /*request*/, ::google::spanner::admin::database::v1::ListDatabaseOperationsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedListDatabaseOperations(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::spanner::admin::database::v1::ListDatabaseOperationsRequest,::google::spanner::admin::database::v1::ListDatabaseOperationsResponse>* server_unary_streamer) = 0;
  };
  template <class BaseClass>
  class WithStreamedUnaryMethod_ListBackupOperations : public BaseClass {
   private:
    void BaseClassMustBeDerivedFromService(const Service* /*service*/) {}
   public:
    WithStreamedUnaryMethod_ListBackupOperations() {
      ::grpc::Service::MarkMethodStreamed(16,
        new ::grpc::internal::StreamedUnaryHandler<
          ::google::spanner::admin::database::v1::ListBackupOperationsRequest, ::google::spanner::admin::database::v1::ListBackupOperationsResponse>(
            [this](::grpc::ServerContext* context,
                   ::grpc::ServerUnaryStreamer<
                     ::google::spanner::admin::database::v1::ListBackupOperationsRequest, ::google::spanner::admin::database::v1::ListBackupOperationsResponse>* streamer) {
                       return this->StreamedListBackupOperations(context,
                         streamer);
                  }));
    }
    ~WithStreamedUnaryMethod_ListBackupOperations() override {
      BaseClassMustBeDerivedFromService(this);
    }
    // disable regular version of this method
    ::grpc::Status ListBackupOperations(::grpc::ServerContext* /*context*/, const ::google::spanner::admin::database::v1::ListBackupOperationsRequest* /*request*/, ::google::spanner::admin::database::v1::ListBackupOperationsResponse* /*response*/) override {
      abort();
      return ::grpc::Status(::grpc::StatusCode::UNIMPLEMENTED, "");
    }
    // replace default version of method with streamed unary
    virtual ::grpc::Status StreamedListBackupOperations(::grpc::ServerContext* context, ::grpc::ServerUnaryStreamer< ::google::spanner::admin::database::v1::ListBackupOperationsRequest,::google::spanner::admin::database::v1::ListBackupOperationsResponse>* server_unary_streamer) = 0;
  };
  typedef WithStreamedUnaryMethod_ListDatabases<WithStreamedUnaryMethod_CreateDatabase<WithStreamedUnaryMethod_GetDatabase<WithStreamedUnaryMethod_UpdateDatabaseDdl<WithStreamedUnaryMethod_DropDatabase<WithStreamedUnaryMethod_GetDatabaseDdl<WithStreamedUnaryMethod_SetIamPolicy<WithStreamedUnaryMethod_GetIamPolicy<WithStreamedUnaryMethod_TestIamPermissions<WithStreamedUnaryMethod_CreateBackup<WithStreamedUnaryMethod_GetBackup<WithStreamedUnaryMethod_UpdateBackup<WithStreamedUnaryMethod_DeleteBackup<WithStreamedUnaryMethod_ListBackups<WithStreamedUnaryMethod_RestoreDatabase<WithStreamedUnaryMethod_ListDatabaseOperations<WithStreamedUnaryMethod_ListBackupOperations<Service > > > > > > > > > > > > > > > > > StreamedUnaryService;
  typedef Service SplitStreamedService;
  typedef WithStreamedUnaryMethod_ListDatabases<WithStreamedUnaryMethod_CreateDatabase<WithStreamedUnaryMethod_GetDatabase<WithStreamedUnaryMethod_UpdateDatabaseDdl<WithStreamedUnaryMethod_DropDatabase<WithStreamedUnaryMethod_GetDatabaseDdl<WithStreamedUnaryMethod_SetIamPolicy<WithStreamedUnaryMethod_GetIamPolicy<WithStreamedUnaryMethod_TestIamPermissions<WithStreamedUnaryMethod_CreateBackup<WithStreamedUnaryMethod_GetBackup<WithStreamedUnaryMethod_UpdateBackup<WithStreamedUnaryMethod_DeleteBackup<WithStreamedUnaryMethod_ListBackups<WithStreamedUnaryMethod_RestoreDatabase<WithStreamedUnaryMethod_ListDatabaseOperations<WithStreamedUnaryMethod_ListBackupOperations<Service > > > > > > > > > > > > > > > > > StreamedService;
};

}  // namespace v1
}  // namespace database
}  // namespace admin
}  // namespace spanner
}  // namespace google


#endif  // GRPC_google_2fspanner_2fadmin_2fdatabase_2fv1_2fspanner_5fdatabase_5fadmin_2eproto__INCLUDED
